// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41245 = arguments.length;
var i__4737__auto___41246 = (0);
while(true){
if((i__4737__auto___41246 < len__4736__auto___41245)){
args__4742__auto__.push((arguments[i__4737__auto___41246]));

var G__41247 = (i__4737__auto___41246 + (1));
i__4737__auto___41246 = G__41247;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq41242){
var G__41243 = cljs.core.first(seq41242);
var seq41242__$1 = cljs.core.next(seq41242);
var G__41244 = cljs.core.first(seq41242__$1);
var seq41242__$2 = cljs.core.next(seq41242__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__41243,G__41244,seq41242__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e41248){var e = e41248;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e41249){var e = e41249;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e41250){var e = e41250;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e41251){var e = e41251;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e41252){var e = e41252;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41255 = arguments.length;
var i__4737__auto___41256 = (0);
while(true){
if((i__4737__auto___41256 < len__4736__auto___41255)){
args__4742__auto__.push((arguments[i__4737__auto___41256]));

var G__41257 = (i__4737__auto___41256 + (1));
i__4737__auto___41256 = G__41257;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e41254){var e = e41254;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq41253){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41253));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41260 = arguments.length;
var i__4737__auto___41261 = (0);
while(true){
if((i__4737__auto___41261 < len__4736__auto___41260)){
args__4742__auto__.push((arguments[i__4737__auto___41261]));

var G__41262 = (i__4737__auto___41261 + (1));
i__4737__auto___41261 = G__41262;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e41259){var e = e41259;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq41258){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41258));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e41263){var e = e41263;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41266 = arguments.length;
var i__4737__auto___41267 = (0);
while(true){
if((i__4737__auto___41267 < len__4736__auto___41266)){
args__4742__auto__.push((arguments[i__4737__auto___41267]));

var G__41268 = (i__4737__auto___41267 + (1));
i__4737__auto___41267 = G__41268;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e41265){var e = e41265;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq41264){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41264));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41271 = arguments.length;
var i__4737__auto___41272 = (0);
while(true){
if((i__4737__auto___41272 < len__4736__auto___41271)){
args__4742__auto__.push((arguments[i__4737__auto___41272]));

var G__41273 = (i__4737__auto___41272 + (1));
i__4737__auto___41272 = G__41273;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e41270){var e = e41270;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq41269){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41269));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e41274){var e = e41274;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e41275){var e = e41275;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41278 = arguments.length;
var i__4737__auto___41279 = (0);
while(true){
if((i__4737__auto___41279 < len__4736__auto___41278)){
args__4742__auto__.push((arguments[i__4737__auto___41279]));

var G__41280 = (i__4737__auto___41279 + (1));
i__4737__auto___41279 = G__41280;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e41277){var e = e41277;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq41276){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41276));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41283 = arguments.length;
var i__4737__auto___41284 = (0);
while(true){
if((i__4737__auto___41284 < len__4736__auto___41283)){
args__4742__auto__.push((arguments[i__4737__auto___41284]));

var G__41285 = (i__4737__auto___41284 + (1));
i__4737__auto___41284 = G__41285;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e41282){var e = e41282;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq41281){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41281));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41288 = arguments.length;
var i__4737__auto___41289 = (0);
while(true){
if((i__4737__auto___41289 < len__4736__auto___41288)){
args__4742__auto__.push((arguments[i__4737__auto___41289]));

var G__41290 = (i__4737__auto___41289 + (1));
i__4737__auto___41289 = G__41290;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e41287){var e = e41287;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq41286){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41286));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41293 = arguments.length;
var i__4737__auto___41294 = (0);
while(true){
if((i__4737__auto___41294 < len__4736__auto___41293)){
args__4742__auto__.push((arguments[i__4737__auto___41294]));

var G__41295 = (i__4737__auto___41294 + (1));
i__4737__auto___41294 = G__41295;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e41292){var e = e41292;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq41291){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41291));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41298 = arguments.length;
var i__4737__auto___41299 = (0);
while(true){
if((i__4737__auto___41299 < len__4736__auto___41298)){
args__4742__auto__.push((arguments[i__4737__auto___41299]));

var G__41300 = (i__4737__auto___41299 + (1));
i__4737__auto___41299 = G__41300;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e41297){var e = e41297;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq41296){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41296));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41303 = arguments.length;
var i__4737__auto___41304 = (0);
while(true){
if((i__4737__auto___41304 < len__4736__auto___41303)){
args__4742__auto__.push((arguments[i__4737__auto___41304]));

var G__41305 = (i__4737__auto___41304 + (1));
i__4737__auto___41304 = G__41305;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e41302){var e = e41302;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq41301){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41301));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41308 = arguments.length;
var i__4737__auto___41309 = (0);
while(true){
if((i__4737__auto___41309 < len__4736__auto___41308)){
args__4742__auto__.push((arguments[i__4737__auto___41309]));

var G__41310 = (i__4737__auto___41309 + (1));
i__4737__auto___41309 = G__41310;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e41307){var e = e41307;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq41306){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41306));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__41312 = arguments.length;
switch (G__41312) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_41340){
var state_val_41341 = (state_41340[(1)]);
if((state_val_41341 === (7))){
var inst_41325 = (state_41340[(7)]);
var inst_41328 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41325,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_41340__$1 = state_41340;
var statearr_41342_41428 = state_41340__$1;
(statearr_41342_41428[(2)] = inst_41328);

(statearr_41342_41428[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41341 === (1))){
var state_41340__$1 = state_41340;
var statearr_41343_41429 = state_41340__$1;
(statearr_41343_41429[(2)] = null);

(statearr_41343_41429[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41341 === (4))){
var inst_41313 = (state_41340[(2)]);
var state_41340__$1 = state_41340;
var statearr_41344_41430 = state_41340__$1;
(statearr_41344_41430[(2)] = inst_41313);

(statearr_41344_41430[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41341 === (6))){
var inst_41325 = (state_41340[(7)]);
var inst_41325__$1 = (state_41340[(2)]);
var inst_41326 = fluree.db.util.core.exception_QMARK_(inst_41325__$1);
var state_41340__$1 = (function (){var statearr_41345 = state_41340;
(statearr_41345[(7)] = inst_41325__$1);

return statearr_41345;
})();
if(inst_41326){
var statearr_41346_41431 = state_41340__$1;
(statearr_41346_41431[(1)] = (7));

} else {
var statearr_41347_41432 = state_41340__$1;
(statearr_41347_41432[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41341 === (3))){
var inst_41338 = (state_41340[(2)]);
var state_41340__$1 = state_41340;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41340__$1,inst_41338);
} else {
if((state_val_41341 === (2))){
var inst_41319 = (state_41340[(8)]);
var _ = (function (){var statearr_41349 = state_41340;
(statearr_41349[(4)] = cljs.core.cons((5),(state_41340[(4)])));

return statearr_41349;
})();
var inst_41319__$1 = cljs.core.volatile_BANG_((0));
var inst_41320 = cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_41321 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_41320,cljs.core.cst$kw$fuel,inst_41319__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,(100000)], 0));
var inst_41322 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,cljs.core.cst$kw$opts,inst_41321);
var inst_41323 = fluree.db.query.fql.query(db,inst_41322);
var state_41340__$1 = (function (){var statearr_41350 = state_41340;
(statearr_41350[(8)] = inst_41319__$1);

return statearr_41350;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41340__$1,(6),inst_41323);
} else {
if((state_val_41341 === (9))){
var inst_41335 = (state_41340[(2)]);
var _ = (function (){var statearr_41351 = state_41340;
(statearr_41351[(4)] = cljs.core.rest((state_41340[(4)])));

return statearr_41351;
})();
var state_41340__$1 = state_41340;
var statearr_41352_41433 = state_41340__$1;
(statearr_41352_41433[(2)] = inst_41335);

(statearr_41352_41433[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41341 === (5))){
var _ = (function (){var statearr_41353 = state_41340;
(statearr_41353[(4)] = cljs.core.rest((state_41340[(4)])));

return statearr_41353;
})();
var state_41340__$1 = state_41340;
var ex41348 = (state_41340__$1[(2)]);
var statearr_41354_41434 = state_41340__$1;
(statearr_41354_41434[(5)] = ex41348);


if((ex41348 instanceof Error)){
var statearr_41355_41435 = state_41340__$1;
(statearr_41355_41435[(1)] = (4));

(statearr_41355_41435[(5)] = null);

} else {
throw ex41348;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41341 === (8))){
var inst_41319 = (state_41340[(8)]);
var inst_41325 = (state_41340[(7)]);
var inst_41330 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41331 = cljs.core.deref(inst_41319);
var inst_41332 = [inst_41325,inst_41331];
var inst_41333 = (new cljs.core.PersistentVector(null,2,(5),inst_41330,inst_41332,null));
var state_41340__$1 = state_41340;
var statearr_41356_41436 = state_41340__$1;
(statearr_41356_41436[(2)] = inst_41333);

(statearr_41356_41436[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16301__auto____0 = (function (){
var statearr_41357 = [null,null,null,null,null,null,null,null,null];
(statearr_41357[(0)] = fluree$db$dbfunctions$internal$state_machine__16301__auto__);

(statearr_41357[(1)] = (1));

return statearr_41357;
});
var fluree$db$dbfunctions$internal$state_machine__16301__auto____1 = (function (state_41340){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_41340);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e41358){var ex__16304__auto__ = e41358;
var statearr_41359_41437 = state_41340;
(statearr_41359_41437[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_41340[(4)]))){
var statearr_41360_41438 = state_41340;
(statearr_41360_41438[(1)] = cljs.core.first((state_41340[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__41439 = state_41340;
state_41340 = G__41439;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16301__auto__ = function(state_41340){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____1.call(this,state_41340);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_41361 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_41361[(6)] = c__16375__auto__);

return statearr_41361;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_41406){
var state_val_41407 = (state_41406[(1)]);
if((state_val_41407 === (7))){
var inst_41392 = (state_41406[(2)]);
var inst_41393 = fluree.db.query.fql.query(db,inst_41392);
var state_41406__$1 = state_41406;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41406__$1,(8),inst_41393);
} else {
if((state_val_41407 === (1))){
var inst_41362 = typeof select === 'string';
var state_41406__$1 = state_41406;
if(cljs.core.truth_(inst_41362)){
var statearr_41408_41440 = state_41406__$1;
(statearr_41408_41440[(1)] = (2));

} else {
var statearr_41409_41441 = state_41406__$1;
(statearr_41409_41441[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41407 === (4))){
var inst_41368 = (state_41406[(7)]);
var inst_41375 = (state_41406[(8)]);
var inst_41367 = (state_41406[(2)]);
var inst_41368__$1 = cljs.core.volatile_BANG_((0));
var inst_41369 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$limit,cljs.core.cst$kw$opts];
var inst_41370 = [cljs.core.cst$kw$fuel,cljs.core.cst$kw$max_DASH_fuel];
var inst_41371 = [inst_41368__$1,(100000)];
var inst_41372 = cljs.core.PersistentHashMap.fromArrays(inst_41370,inst_41371);
var inst_41373 = [inst_41367,from,where,block,limit,inst_41372];
var inst_41374 = cljs.core.PersistentHashMap.fromArrays(inst_41369,inst_41373);
var inst_41375__$1 = fluree.db.util.core.without_nils(inst_41374);
var inst_41376 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_41375__$1);
var inst_41377 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_41375__$1);
var inst_41378 = cljs.core.first(inst_41377);
var inst_41379 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_41378], 0));
var inst_41380 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_41379);
var inst_41381 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_41375__$1);
var inst_41382 = cljs.core.last(inst_41381);
var inst_41383 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_41382], 0));
var inst_41384 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_41383);
var inst_41385 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_41376,inst_41380,inst_41384], 0));
var state_41406__$1 = (function (){var statearr_41410 = state_41406;
(statearr_41410[(7)] = inst_41368__$1);

(statearr_41410[(8)] = inst_41375__$1);

return statearr_41410;
})();
if(cljs.core.truth_(inst_41385)){
var statearr_41411_41442 = state_41406__$1;
(statearr_41411_41442[(1)] = (5));

} else {
var statearr_41412_41443 = state_41406__$1;
(statearr_41412_41443[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41407 === (6))){
var inst_41375 = (state_41406[(8)]);
var state_41406__$1 = state_41406;
var statearr_41413_41444 = state_41406__$1;
(statearr_41413_41444[(2)] = inst_41375);

(statearr_41413_41444[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41407 === (3))){
var state_41406__$1 = state_41406;
var statearr_41414_41445 = state_41406__$1;
(statearr_41414_41445[(2)] = select);

(statearr_41414_41445[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41407 === (2))){
var inst_41364 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_41406__$1 = state_41406;
var statearr_41415_41446 = state_41406__$1;
(statearr_41415_41446[(2)] = inst_41364);

(statearr_41415_41446[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41407 === (11))){
var inst_41404 = (state_41406[(2)]);
var state_41406__$1 = state_41406;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41406__$1,inst_41404);
} else {
if((state_val_41407 === (9))){
var inst_41395 = (state_41406[(9)]);
var state_41406__$1 = state_41406;
var statearr_41416_41447 = state_41406__$1;
(statearr_41416_41447[(2)] = inst_41395);

(statearr_41416_41447[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41407 === (5))){
var inst_41375 = (state_41406[(8)]);
var inst_41387 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_41375);
var inst_41388 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_41387);
var inst_41389 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41375,cljs.core.cst$kw$where,inst_41388);
var state_41406__$1 = state_41406;
var statearr_41417_41448 = state_41406__$1;
(statearr_41417_41448[(2)] = inst_41389);

(statearr_41417_41448[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41407 === (10))){
var inst_41395 = (state_41406[(9)]);
var inst_41368 = (state_41406[(7)]);
var inst_41399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41400 = cljs.core.deref(inst_41368);
var inst_41401 = [inst_41395,inst_41400];
var inst_41402 = (new cljs.core.PersistentVector(null,2,(5),inst_41399,inst_41401,null));
var state_41406__$1 = state_41406;
var statearr_41418_41449 = state_41406__$1;
(statearr_41418_41449[(2)] = inst_41402);

(statearr_41418_41449[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41407 === (8))){
var inst_41395 = (state_41406[(9)]);
var inst_41395__$1 = (state_41406[(2)]);
var inst_41396 = fluree.db.util.core.exception_QMARK_(inst_41395__$1);
var state_41406__$1 = (function (){var statearr_41419 = state_41406;
(statearr_41419[(9)] = inst_41395__$1);

return statearr_41419;
})();
if(inst_41396){
var statearr_41420_41450 = state_41406__$1;
(statearr_41420_41450[(1)] = (9));

} else {
var statearr_41421_41451 = state_41406__$1;
(statearr_41421_41451[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16301__auto____0 = (function (){
var statearr_41422 = [null,null,null,null,null,null,null,null,null,null];
(statearr_41422[(0)] = fluree$db$dbfunctions$internal$state_machine__16301__auto__);

(statearr_41422[(1)] = (1));

return statearr_41422;
});
var fluree$db$dbfunctions$internal$state_machine__16301__auto____1 = (function (state_41406){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_41406);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e41423){var ex__16304__auto__ = e41423;
var statearr_41424_41452 = state_41406;
(statearr_41424_41452[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_41406[(4)]))){
var statearr_41425_41453 = state_41406;
(statearr_41425_41453[(1)] = cljs.core.first((state_41406[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__41454 = state_41406;
state_41406 = G__41454;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16301__auto__ = function(state_41406){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____1.call(this,state_41406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_41426 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_41426[(6)] = c__16375__auto__);

return statearr_41426;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__41458 = path;
var vec__41459 = G__41458;
var seq__41460 = cljs.core.seq(vec__41459);
var first__41461 = cljs.core.first(seq__41460);
var seq__41460__$1 = cljs.core.next(seq__41460);
var var$ = first__41461;
var r = seq__41460__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__41458__$1 = G__41458;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__41465 = G__41458__$1;
var seq__41466 = cljs.core.seq(vec__41465);
var first__41467 = cljs.core.first(seq__41466);
var seq__41466__$1 = cljs.core.next(seq__41466);
var var$__$1 = first__41467;
var r__$1 = seq__41466__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__41468 = r__$1;
var G__41469 = n__$2;
var G__41470 = next_clauses;
G__41458__$1 = G__41468;
n__$1 = G__41469;
where_clauses__$1 = G__41470;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__41471 = r__$1;
var G__41472 = next_n;
var G__41473 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__41458__$1 = G__41471;
n__$1 = G__41472;
where_clauses__$1 = G__41473;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_41510){
var state_val_41511 = (state_41510[(1)]);
if((state_val_41511 === (7))){
var inst_41483 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41484 = [path];
var inst_41485 = (new cljs.core.PersistentVector(null,1,(5),inst_41483,inst_41484,null));
var state_41510__$1 = state_41510;
var statearr_41512_41540 = state_41510__$1;
(statearr_41512_41540[(2)] = inst_41485);

(statearr_41512_41540[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (1))){
var state_41510__$1 = state_41510;
var statearr_41513_41541 = state_41510__$1;
(statearr_41513_41541[(2)] = null);

(statearr_41513_41541[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (4))){
var inst_41474 = (state_41510[(2)]);
var state_41510__$1 = state_41510;
var statearr_41514_41542 = state_41510__$1;
(statearr_41514_41542[(2)] = inst_41474);

(statearr_41514_41542[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (13))){
var inst_41501 = (state_41510[(2)]);
var inst_41502 = fluree.db.util.async.throw_err(inst_41501);
var _ = (function (){var statearr_41515 = state_41510;
(statearr_41515[(4)] = cljs.core.rest((state_41510[(4)])));

return statearr_41515;
})();
var state_41510__$1 = state_41510;
var statearr_41516_41543 = state_41510__$1;
(statearr_41516_41543[(2)] = inst_41502);

(statearr_41516_41543[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (6))){
var state_41510__$1 = state_41510;
var statearr_41518_41544 = state_41510__$1;
(statearr_41518_41544[(2)] = path);

(statearr_41518_41544[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (3))){
var inst_41508 = (state_41510[(2)]);
var state_41510__$1 = state_41510;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41510__$1,inst_41508);
} else {
if((state_val_41511 === (12))){
var _ = (function (){var statearr_41519 = state_41510;
(statearr_41519[(4)] = cljs.core.rest((state_41510[(4)])));

return statearr_41519;
})();
var state_41510__$1 = state_41510;
var ex41517 = (state_41510__$1[(2)]);
var statearr_41520_41545 = state_41510__$1;
(statearr_41520_41545[(5)] = ex41517);


var statearr_41521_41546 = state_41510__$1;
(statearr_41521_41546[(1)] = (11));

(statearr_41521_41546[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (2))){
var _ = (function (){var statearr_41522 = state_41510;
(statearr_41522[(4)] = cljs.core.cons((5),(state_41510[(4)])));

return statearr_41522;
})();
var inst_41480 = cljs.core.vector_QMARK_(path);
var state_41510__$1 = state_41510;
if(inst_41480){
var statearr_41523_41547 = state_41510__$1;
(statearr_41523_41547[(1)] = (6));

} else {
var statearr_41524_41548 = state_41510__$1;
(statearr_41524_41548[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (11))){
var inst_41487 = (state_41510[(7)]);
var inst_41492 = (state_41510[(2)]);
var inst_41493 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41492,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_41487,endSubject], 0));
var state_41510__$1 = state_41510;
var statearr_41526_41549 = state_41510__$1;
(statearr_41526_41549[(2)] = inst_41493);

(statearr_41526_41549[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (9))){
var inst_41491 = (state_41510[(8)]);
var _ = (function (){var statearr_41527 = state_41510;
(statearr_41527[(4)] = cljs.core.cons((12),(state_41510[(4)])));

return statearr_41527;
})();
var inst_41499 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_41491);
var state_41510__$1 = state_41510;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41510__$1,(13),inst_41499);
} else {
if((state_val_41511 === (5))){
var _ = (function (){var statearr_41528 = state_41510;
(statearr_41528[(4)] = cljs.core.rest((state_41510[(4)])));

return statearr_41528;
})();
var state_41510__$1 = state_41510;
var ex41525 = (state_41510__$1[(2)]);
var statearr_41529_41550 = state_41510__$1;
(statearr_41529_41550[(5)] = ex41525);


if((ex41525 instanceof Error)){
var statearr_41530_41551 = state_41510__$1;
(statearr_41530_41551[(1)] = (4));

(statearr_41530_41551[(5)] = null);

} else {
throw ex41525;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (10))){
var inst_41505 = (state_41510[(2)]);
var _ = (function (){var statearr_41531 = state_41510;
(statearr_41531[(4)] = cljs.core.rest((state_41510[(4)])));

return statearr_41531;
})();
var state_41510__$1 = state_41510;
var statearr_41532_41552 = state_41510__$1;
(statearr_41532_41552[(2)] = inst_41505);

(statearr_41532_41552[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41511 === (8))){
var inst_41487 = (state_41510[(7)]);
var inst_41487__$1 = (state_41510[(2)]);
var inst_41488 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_41487__$1,endSubject);
var inst_41489 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_41490 = ["?var1",inst_41488];
var inst_41491 = cljs.core.PersistentHashMap.fromArrays(inst_41489,inst_41490);
var state_41510__$1 = (function (){var statearr_41533 = state_41510;
(statearr_41533[(7)] = inst_41487__$1);

(statearr_41533[(8)] = inst_41491);

return statearr_41533;
})();
var statearr_41534_41553 = state_41510__$1;
(statearr_41534_41553[(2)] = null);

(statearr_41534_41553[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto____0 = (function (){
var statearr_41535 = [null,null,null,null,null,null,null,null,null];
(statearr_41535[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto__);

(statearr_41535[(1)] = (1));

return statearr_41535;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto____1 = (function (state_41510){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_41510);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e41536){var ex__16304__auto__ = e41536;
var statearr_41537_41554 = state_41510;
(statearr_41537_41554[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_41510[(4)]))){
var statearr_41538_41555 = state_41510;
(statearr_41538_41555[(1)] = cljs.core.first((state_41510[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__41556 = state_41510;
state_41510 = G__41556;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto__ = function(state_41510){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto____1.call(this,state_41510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_41539 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_41539[(6)] = c__16375__auto__);

return statearr_41539;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e41557){var e = e41557;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e41558){var e = e41558;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e41559){var e = e41559;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e41560){var e = e41560;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41563 = arguments.length;
var i__4737__auto___41564 = (0);
while(true){
if((i__4737__auto___41564 < len__4736__auto___41563)){
args__4742__auto__.push((arguments[i__4737__auto___41564]));

var G__41565 = (i__4737__auto___41564 + (1));
i__4737__auto___41564 = G__41565;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e41562){var e = e41562;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq41561){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41561));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41568 = arguments.length;
var i__4737__auto___41569 = (0);
while(true){
if((i__4737__auto___41569 < len__4736__auto___41568)){
args__4742__auto__.push((arguments[i__4737__auto___41569]));

var G__41570 = (i__4737__auto___41569 + (1));
i__4737__auto___41569 = G__41570;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e41567){var e = e41567;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq41566){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41566));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41573 = arguments.length;
var i__4737__auto___41574 = (0);
while(true){
if((i__4737__auto___41574 < len__4736__auto___41573)){
args__4742__auto__.push((arguments[i__4737__auto___41574]));

var G__41575 = (i__4737__auto___41574 + (1));
i__4737__auto___41574 = G__41575;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4126__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e41572){var e = e41572;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq41571){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41571));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41578 = arguments.length;
var i__4737__auto___41579 = (0);
while(true){
if((i__4737__auto___41579 < len__4736__auto___41578)){
args__4742__auto__.push((arguments[i__4737__auto___41579]));

var G__41580 = (i__4737__auto___41579 + (1));
i__4737__auto___41579 = G__41580;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e41577){var e = e41577;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq41576){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41576));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e41581){var e = e41581;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e41582){var e = e41582;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e41583){var e = e41583;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e41584){var e = e41584;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e41585){var e = e41585;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__41591 = path;
var vec__41592 = G__41591;
var seq__41593 = cljs.core.seq(vec__41592);
var first__41594 = cljs.core.first(seq__41593);
var seq__41593__$1 = cljs.core.next(seq__41593);
var pred = first__41594;
var r = seq__41593__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__41591__$1 = G__41591;
var subjects__$1 = subjects;
while(true){
var vec__41598 = G__41591__$1;
var seq__41599 = cljs.core.seq(vec__41598);
var first__41600 = cljs.core.first(seq__41599);
var seq__41599__$1 = cljs.core.next(seq__41599);
var pred__$1 = first__41600;
var r__$1 = seq__41599__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__41591__$1,subjects__$1,vec__41598,seq__41599,first__41600,seq__41599__$1,pred__$1,r__$1,subjects__$2,G__41591,vec__41592,seq__41593,first__41594,seq__41593__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__41591__$1,subjects__$1,vec__41598,seq__41599,first__41600,seq__41599__$1,pred__$1,r__$1,subjects__$2,G__41591,vec__41592,seq__41593,first__41594,seq__41593__$1,pred,r,subjects){
return (function (p1__41586_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__41586_SHARP_,pred__$1);
});})(G__41591__$1,subjects__$1,vec__41598,seq__41599,first__41600,seq__41599__$1,pred__$1,r__$1,subjects__$2,G__41591,vec__41592,seq__41593,first__41594,seq__41593__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__41591__$1,subjects__$1,vec__41598,seq__41599,first__41600,seq__41599__$1,pred__$1,r__$1,subjects__$2,G__41591,vec__41592,seq__41593,first__41594,seq__41593__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4115__auto__ = r__$1;
if(and__4115__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4115__auto__;
}
})())){
var G__41601 = r__$1;
var G__41602 = next_subjects;
G__41591__$1 = G__41601;
subjects__$1 = G__41602;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e41587){var e = e41587;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e41603){var e = e41603;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e41604){var e = e41604;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41607 = arguments.length;
var i__4737__auto___41608 = (0);
while(true){
if((i__4737__auto___41608 < len__4736__auto___41607)){
args__4742__auto__.push((arguments[i__4737__auto___41608]));

var G__41609 = (i__4737__auto___41608 + (1));
i__4737__auto___41608 = G__41609;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e41606){var e = e41606;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq41605){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41605));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e41610){var e = e41610;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___41613 = arguments.length;
var i__4737__auto___41614 = (0);
while(true){
if((i__4737__auto___41614 < len__4736__auto___41613)){
args__4742__auto__.push((arguments[i__4737__auto___41614]));

var G__41615 = (i__4737__auto___41614 + (1));
i__4737__auto___41614 = G__41615;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e41612){var e = e41612;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq41611){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq41611));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e41616){var e = e41616;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_41671){
var state_val_41672 = (state_41671[(1)]);
if((state_val_41672 === (7))){
var inst_41618 = (state_41671[(2)]);
var state_41671__$1 = state_41671;
var statearr_41673_41706 = state_41671__$1;
(statearr_41673_41706[(2)] = inst_41618);

(statearr_41673_41706[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41672 === (1))){
var state_41671__$1 = state_41671;
var statearr_41674_41707 = state_41671__$1;
(statearr_41674_41707[(2)] = null);

(statearr_41674_41707[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41672 === (4))){
var inst_41617 = (state_41671[(2)]);
var state_41671__$1 = (function (){var statearr_41675 = state_41671;
(statearr_41675[(7)] = inst_41617);

return statearr_41675;
})();
var statearr_41676_41708 = state_41671__$1;
(statearr_41676_41708[(2)] = null);

(statearr_41676_41708[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41672 === (15))){
var inst_41655 = (state_41671[(8)]);
var inst_41659 = inst_41655.o;
var state_41671__$1 = state_41671;
var statearr_41677_41709 = state_41671__$1;
(statearr_41677_41709[(2)] = inst_41659);

(statearr_41677_41709[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41672 === (13))){
var inst_41655 = (state_41671[(8)]);
var inst_41651 = (state_41671[(2)]);
var inst_41652 = fluree.db.util.async.throw_err(inst_41651);
var inst_41653 = fluree.db.dbfunctions.internal.count(inst_41652);
var inst_41655__$1 = cljs.core.first(inst_41652);
var inst_41656 = (inst_41655__$1 == null);
var state_41671__$1 = (function (){var statearr_41678 = state_41671;
(statearr_41678[(8)] = inst_41655__$1);

(statearr_41678[(9)] = inst_41653);

return statearr_41678;
})();
if(cljs.core.truth_(inst_41656)){
var statearr_41679_41710 = state_41671__$1;
(statearr_41679_41710[(1)] = (14));

} else {
var statearr_41680_41711 = state_41671__$1;
(statearr_41680_41711[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41672 === (6))){
var inst_41627 = (state_41671[(2)]);
var state_41671__$1 = state_41671;
var statearr_41681_41712 = state_41671__$1;
(statearr_41681_41712[(2)] = inst_41627);

(statearr_41681_41712[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41672 === (3))){
var inst_41669 = (state_41671[(2)]);
var state_41671__$1 = state_41671;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41671__$1,inst_41669);
} else {
if((state_val_41672 === (12))){
var inst_41666 = (state_41671[(2)]);
var _ = (function (){var statearr_41682 = state_41671;
(statearr_41682[(4)] = cljs.core.rest((state_41671[(4)])));

return statearr_41682;
})();
var state_41671__$1 = state_41671;
var statearr_41683_41713 = state_41671__$1;
(statearr_41683_41713[(2)] = inst_41666);

(statearr_41683_41713[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41672 === (2))){
var _ = (function (){var statearr_41685 = state_41671;
(statearr_41685[(4)] = cljs.core.cons((9),(state_41671[(4)])));

return statearr_41685;
})();
var inst_41633 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41634 = typeof inst_41633 === 'string';
var state_41671__$1 = state_41671;
if(cljs.core.truth_(inst_41634)){
var statearr_41686_41714 = state_41671__$1;
(statearr_41686_41714[(1)] = (10));

} else {
var statearr_41687_41715 = state_41671__$1;
(statearr_41687_41715[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41672 === (11))){
var inst_41640 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41641 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_41640);
var inst_41642 = fluree.db.dbfunctions.internal.inc(inst_41641);
var inst_41643 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41640,cljs.core.cst$kw$t,inst_41642);
var inst_41644 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41645 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41646 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41647 = [inst_41645,inst_41646];
var inst_41648 = (new cljs.core.PersistentVector(null,2,(5),inst_41644,inst_41647,null));
var inst_41649 = fluree.db.dbproto._search(inst_41643,inst_41648);
var state_41671__$1 = state_41671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41671__$1,(13),inst_41649);
} else {
if((state_val_41672 === (9))){
var _ = (function (){var statearr_41688 = state_41671;
(statearr_41688[(4)] = cljs.core.rest((state_41671[(4)])));

return statearr_41688;
})();
var state_41671__$1 = state_41671;
var ex41684 = (state_41671__$1[(2)]);
var statearr_41689_41716 = state_41671__$1;
(statearr_41689_41716[(5)] = ex41684);


var statearr_41690_41717 = state_41671__$1;
(statearr_41690_41717[(1)] = (4));

(statearr_41690_41717[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41672 === (5))){
var inst_41617 = (state_41671[(7)]);
var _ = (function (){var statearr_41691 = state_41671;
(statearr_41691[(4)] = cljs.core.cons((8),(state_41671[(4)])));

return statearr_41691;
})();
var inst_41624 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41617,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_41692 = state_41671;
(statearr_41692[(4)] = cljs.core.rest((state_41671[(4)])));

return statearr_41692;
})();
var state_41671__$1 = state_41671;
var statearr_41693_41718 = state_41671__$1;
(statearr_41693_41718[(2)] = inst_41624);

(statearr_41693_41718[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41672 === (14))){
var state_41671__$1 = state_41671;
var statearr_41694_41719 = state_41671__$1;
(statearr_41694_41719[(2)] = null);

(statearr_41694_41719[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41672 === (16))){
var inst_41653 = (state_41671[(9)]);
var inst_41661 = (state_41671[(2)]);
var inst_41662 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41663 = [inst_41661,inst_41653];
var inst_41664 = (new cljs.core.PersistentVector(null,2,(5),inst_41662,inst_41663,null));
var state_41671__$1 = state_41671;
var statearr_41696_41720 = state_41671__$1;
(statearr_41696_41720[(2)] = inst_41664);

(statearr_41696_41720[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41672 === (10))){
var inst_41636 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41637 = [null,(0)];
var inst_41638 = (new cljs.core.PersistentVector(null,2,(5),inst_41636,inst_41637,null));
var state_41671__$1 = state_41671;
var statearr_41697_41721 = state_41671__$1;
(statearr_41697_41721[(2)] = inst_41638);

(statearr_41697_41721[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41672 === (8))){
var _ = (function (){var statearr_41698 = state_41671;
(statearr_41698[(4)] = cljs.core.rest((state_41671[(4)])));

return statearr_41698;
})();
var state_41671__$1 = state_41671;
var ex41695 = (state_41671__$1[(2)]);
var statearr_41699_41722 = state_41671__$1;
(statearr_41699_41722[(5)] = ex41695);


var statearr_41700_41723 = state_41671__$1;
(statearr_41700_41723[(1)] = (7));

(statearr_41700_41723[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto____0 = (function (){
var statearr_41701 = [null,null,null,null,null,null,null,null,null,null];
(statearr_41701[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto__);

(statearr_41701[(1)] = (1));

return statearr_41701;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto____1 = (function (state_41671){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_41671);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e41702){var ex__16304__auto__ = e41702;
var statearr_41703_41724 = state_41671;
(statearr_41703_41724[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_41671[(4)]))){
var statearr_41704_41725 = state_41671;
(statearr_41704_41725[(1)] = cljs.core.first((state_41671[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__41726 = state_41671;
state_41671 = G__41726;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto__ = function(state_41671){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto____1.call(this,state_41671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_41705 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_41705[(6)] = c__16375__auto__);

return statearr_41705;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_41778){
var state_val_41779 = (state_41778[(1)]);
if((state_val_41779 === (7))){
var inst_41728 = (state_41778[(2)]);
var state_41778__$1 = state_41778;
var statearr_41780_41809 = state_41778__$1;
(statearr_41780_41809[(2)] = inst_41728);

(statearr_41780_41809[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41779 === (1))){
var state_41778__$1 = state_41778;
var statearr_41781_41810 = state_41778__$1;
(statearr_41781_41810[(2)] = null);

(statearr_41781_41810[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41779 === (4))){
var inst_41727 = (state_41778[(2)]);
var state_41778__$1 = (function (){var statearr_41782 = state_41778;
(statearr_41782[(7)] = inst_41727);

return statearr_41782;
})();
var statearr_41783_41811 = state_41778__$1;
(statearr_41783_41811[(2)] = null);

(statearr_41783_41811[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41779 === (13))){
var inst_41773 = (state_41778[(2)]);
var _ = (function (){var statearr_41784 = state_41778;
(statearr_41784[(4)] = cljs.core.rest((state_41778[(4)])));

return statearr_41784;
})();
var state_41778__$1 = state_41778;
var statearr_41785_41812 = state_41778__$1;
(statearr_41785_41812[(2)] = inst_41773);

(statearr_41785_41812[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41779 === (6))){
var inst_41737 = (state_41778[(2)]);
var state_41778__$1 = state_41778;
var statearr_41786_41813 = state_41778__$1;
(statearr_41786_41813[(2)] = inst_41737);

(statearr_41786_41813[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41779 === (3))){
var inst_41776 = (state_41778[(2)]);
var state_41778__$1 = state_41778;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41778__$1,inst_41776);
} else {
if((state_val_41779 === (12))){
var inst_41760 = (state_41778[(8)]);
var inst_41769 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41770 = [null,inst_41760];
var inst_41771 = (new cljs.core.PersistentVector(null,2,(5),inst_41769,inst_41770,null));
var state_41778__$1 = state_41778;
var statearr_41787_41814 = state_41778__$1;
(statearr_41787_41814[(2)] = inst_41771);

(statearr_41787_41814[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41779 === (2))){
var _ = (function (){var statearr_41789 = state_41778;
(statearr_41789[(4)] = cljs.core.cons((9),(state_41778[(4)])));

return statearr_41789;
})();
var inst_41746 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_41747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41748 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41749 = [null,pred_name,"?o"];
var inst_41750 = (new cljs.core.PersistentVector(null,3,(5),inst_41748,inst_41749,null));
var inst_41751 = [inst_41750];
var inst_41752 = (new cljs.core.PersistentVector(null,1,(5),inst_41747,inst_41751,null));
var inst_41753 = ["?o",inst_41752,opts];
var inst_41754 = cljs.core.PersistentHashMap.fromArrays(inst_41746,inst_41753);
var inst_41755 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_41754);
var state_41778__$1 = state_41778;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41778__$1,(10),inst_41755);
} else {
if((state_val_41779 === (11))){
var inst_41759 = (state_41778[(9)]);
var inst_41760 = (state_41778[(8)]);
var inst_41764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41765 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_41759);
var inst_41766 = [inst_41765,inst_41760];
var inst_41767 = (new cljs.core.PersistentVector(null,2,(5),inst_41764,inst_41766,null));
var state_41778__$1 = state_41778;
var statearr_41790_41815 = state_41778__$1;
(statearr_41790_41815[(2)] = inst_41767);

(statearr_41790_41815[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41779 === (9))){
var _ = (function (){var statearr_41791 = state_41778;
(statearr_41791[(4)] = cljs.core.rest((state_41778[(4)])));

return statearr_41791;
})();
var state_41778__$1 = state_41778;
var ex41788 = (state_41778__$1[(2)]);
var statearr_41792_41816 = state_41778__$1;
(statearr_41792_41816[(5)] = ex41788);


var statearr_41793_41817 = state_41778__$1;
(statearr_41793_41817[(1)] = (4));

(statearr_41793_41817[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41779 === (5))){
var inst_41727 = (state_41778[(7)]);
var _ = (function (){var statearr_41795 = state_41778;
(statearr_41795[(4)] = cljs.core.cons((8),(state_41778[(4)])));

return statearr_41795;
})();
var inst_41734 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41727,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_41796 = state_41778;
(statearr_41796[(4)] = cljs.core.rest((state_41778[(4)])));

return statearr_41796;
})();
var state_41778__$1 = state_41778;
var statearr_41797_41818 = state_41778__$1;
(statearr_41797_41818[(2)] = inst_41734);

(statearr_41797_41818[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41779 === (10))){
var inst_41759 = (state_41778[(9)]);
var inst_41757 = (state_41778[(2)]);
var inst_41758 = fluree.db.util.async.throw_err(inst_41757);
var inst_41759__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41758,(0),null);
var inst_41760 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41758,(1),null);
var inst_41761 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_41759__$1);
var inst_41762 = cljs.core.not(inst_41761);
var state_41778__$1 = (function (){var statearr_41798 = state_41778;
(statearr_41798[(9)] = inst_41759__$1);

(statearr_41798[(8)] = inst_41760);

return statearr_41798;
})();
if(inst_41762){
var statearr_41799_41819 = state_41778__$1;
(statearr_41799_41819[(1)] = (11));

} else {
var statearr_41800_41820 = state_41778__$1;
(statearr_41800_41820[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41779 === (8))){
var _ = (function (){var statearr_41801 = state_41778;
(statearr_41801[(4)] = cljs.core.rest((state_41778[(4)])));

return statearr_41801;
})();
var state_41778__$1 = state_41778;
var ex41794 = (state_41778__$1[(2)]);
var statearr_41802_41821 = state_41778__$1;
(statearr_41802_41821[(5)] = ex41794);


var statearr_41803_41822 = state_41778__$1;
(statearr_41803_41822[(1)] = (7));

(statearr_41803_41822[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto____0 = (function (){
var statearr_41804 = [null,null,null,null,null,null,null,null,null,null];
(statearr_41804[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto__);

(statearr_41804[(1)] = (1));

return statearr_41804;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto____1 = (function (state_41778){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_41778);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e41805){var ex__16304__auto__ = e41805;
var statearr_41806_41823 = state_41778;
(statearr_41806_41823[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_41778[(4)]))){
var statearr_41807_41824 = state_41778;
(statearr_41807_41824[(1)] = cljs.core.first((state_41778[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__41825 = state_41778;
state_41778 = G__41825;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto__ = function(state_41778){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto____1.call(this,state_41778);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_41808 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_41808[(6)] = c__16375__auto__);

return statearr_41808;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$(((typeof email === 'string')?cljs.core.re_matches(pattern,email):false));
}catch (e41826){var e = e41826;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__41828 = arguments.length;
switch (G__41828) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_41898){
var state_val_41899 = (state_41898[(1)]);
if((state_val_41899 === (7))){
var inst_41830 = (state_41898[(2)]);
var state_41898__$1 = state_41898;
var statearr_41900_41944 = state_41898__$1;
(statearr_41900_41944[(2)] = inst_41830);

(statearr_41900_41944[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41899 === (20))){
var inst_41874 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41875 = ["*"];
var inst_41876 = (new cljs.core.PersistentVector(null,1,(5),inst_41874,inst_41875,null));
var state_41898__$1 = state_41898;
var statearr_41901_41945 = state_41898__$1;
(statearr_41901_41945[(2)] = inst_41876);

(statearr_41901_41945[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41899 === (1))){
var state_41898__$1 = state_41898;
var statearr_41902_41946 = state_41898__$1;
(statearr_41902_41946[(2)] = null);

(statearr_41902_41946[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41899 === (4))){
var inst_41829 = (state_41898[(2)]);
var state_41898__$1 = (function (){var statearr_41903 = state_41898;
(statearr_41903[(7)] = inst_41829);

return statearr_41903;
})();
var statearr_41904_41947 = state_41898__$1;
(statearr_41904_41947[(2)] = null);

(statearr_41904_41947[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41899 === (15))){
var inst_41893 = (state_41898[(2)]);
var _ = (function (){var statearr_41905 = state_41898;
(statearr_41905[(4)] = cljs.core.rest((state_41898[(4)])));

return statearr_41905;
})();
var state_41898__$1 = state_41898;
var statearr_41906_41948 = state_41898__$1;
(statearr_41906_41948[(2)] = inst_41893);

(statearr_41906_41948[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41899 === (21))){
var inst_41864 = (state_41898[(8)]);
var inst_41857 = (state_41898[(9)]);
var inst_41878 = (state_41898[(2)]);
var inst_41879 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_41880 = cljs.core.PersistentHashMap.EMPTY;
var inst_41881 = [inst_41878,inst_41864,inst_41880];
var inst_41882 = cljs.core.PersistentHashMap.fromArrays(inst_41879,inst_41881);
var inst_41883 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_41857,inst_41882);
var state_41898__$1 = state_41898;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41898__$1,(22),inst_41883);
} else {
if((state_val_41899 === (13))){
var inst_41852 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41898__$1 = state_41898;
var statearr_41907_41949 = state_41898__$1;
(statearr_41907_41949[(2)] = inst_41852);

(statearr_41907_41949[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41899 === (22))){
var inst_41885 = (state_41898[(2)]);
var inst_41886 = fluree.db.util.async.throw_err(inst_41885);
var inst_41887 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41886,(0),null);
var inst_41888 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41886,(1),null);
var inst_41889 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41890 = [inst_41887,inst_41888];
var inst_41891 = (new cljs.core.PersistentVector(null,2,(5),inst_41889,inst_41890,null));
var state_41898__$1 = state_41898;
var statearr_41908_41950 = state_41898__$1;
(statearr_41908_41950[(2)] = inst_41891);

(statearr_41908_41950[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41899 === (6))){
var inst_41839 = (state_41898[(2)]);
var state_41898__$1 = state_41898;
var statearr_41909_41951 = state_41898__$1;
(statearr_41909_41951[(2)] = inst_41839);

(statearr_41909_41951[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41899 === (17))){
var inst_41861 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41862 = fluree.db.dbfunctions.internal.get(inst_41861,cljs.core.cst$kw$_id);
var state_41898__$1 = state_41898;
var statearr_41910_41952 = state_41898__$1;
(statearr_41910_41952[(2)] = inst_41862);

(statearr_41910_41952[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41899 === (3))){
var inst_41896 = (state_41898[(2)]);
var state_41898__$1 = state_41898;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41898__$1,inst_41896);
} else {
if((state_val_41899 === (12))){
var inst_41850 = (state_41898[(2)]);
var state_41898__$1 = state_41898;
if(cljs.core.truth_(inst_41850)){
var statearr_41911_41953 = state_41898__$1;
(statearr_41911_41953[(1)] = (13));

} else {
var statearr_41912_41954 = state_41898__$1;
(statearr_41912_41954[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41899 === (2))){
var inst_41845 = (state_41898[(10)]);
var _ = (function (){var statearr_41913 = state_41898;
(statearr_41913[(4)] = cljs.core.cons((9),(state_41898[(4)])));

return statearr_41913;
})();
var inst_41845__$1 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41898__$1 = (function (){var statearr_41914 = state_41898;
(statearr_41914[(10)] = inst_41845__$1);

return statearr_41914;
})();
if(cljs.core.truth_(inst_41845__$1)){
var statearr_41915_41955 = state_41898__$1;
(statearr_41915_41955[(1)] = (10));

} else {
var statearr_41916_41956 = state_41898__$1;
(statearr_41916_41956[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41899 === (19))){
var inst_41866 = cljs.core.PersistentVector.EMPTY;
var inst_41867 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41868 = ["*"];
var inst_41869 = (new cljs.core.PersistentVector(null,1,(5),inst_41867,inst_41868,null));
var inst_41870 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_41871 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_41869,inst_41870);
var inst_41872 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41866,inst_41871);
var state_41898__$1 = state_41898;
var statearr_41918_41957 = state_41898__$1;
(statearr_41918_41957[(2)] = inst_41872);

(statearr_41918_41957[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41899 === (11))){
var inst_41845 = (state_41898[(10)]);
var state_41898__$1 = state_41898;
var statearr_41919_41958 = state_41898__$1;
(statearr_41919_41958[(2)] = inst_41845);

(statearr_41919_41958[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41899 === (9))){
var _ = (function (){var statearr_41920 = state_41898;
(statearr_41920[(4)] = cljs.core.rest((state_41898[(4)])));

return statearr_41920;
})();
var state_41898__$1 = state_41898;
var ex41917 = (state_41898__$1[(2)]);
var statearr_41921_41959 = state_41898__$1;
(statearr_41921_41959[(5)] = ex41917);


var statearr_41922_41960 = state_41898__$1;
(statearr_41922_41960[(1)] = (4));

(statearr_41922_41960[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41899 === (5))){
var inst_41829 = (state_41898[(7)]);
var _ = (function (){var statearr_41923 = state_41898;
(statearr_41923[(4)] = cljs.core.cons((8),(state_41898[(4)])));

return statearr_41923;
})();
var inst_41836 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41829,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_41924 = state_41898;
(statearr_41924[(4)] = cljs.core.rest((state_41898[(4)])));

return statearr_41924;
})();
var state_41898__$1 = state_41898;
var statearr_41925_41961 = state_41898__$1;
(statearr_41925_41961[(2)] = inst_41836);

(statearr_41925_41961[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41899 === (14))){
var inst_41858 = (state_41898[(11)]);
var inst_41857 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41858__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41898__$1 = (function (){var statearr_41926 = state_41898;
(statearr_41926[(9)] = inst_41857);

(statearr_41926[(11)] = inst_41858__$1);

return statearr_41926;
})();
if(cljs.core.truth_(inst_41858__$1)){
var statearr_41927_41962 = state_41898__$1;
(statearr_41927_41962[(1)] = (16));

} else {
var statearr_41928_41963 = state_41898__$1;
(statearr_41928_41963[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41899 === (16))){
var inst_41858 = (state_41898[(11)]);
var state_41898__$1 = state_41898;
var statearr_41929_41964 = state_41898__$1;
(statearr_41929_41964[(2)] = inst_41858);

(statearr_41929_41964[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41899 === (10))){
var inst_41847 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_41898__$1 = state_41898;
var statearr_41931_41965 = state_41898__$1;
(statearr_41931_41965[(2)] = inst_41847);

(statearr_41931_41965[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41899 === (18))){
var inst_41864 = (state_41898[(2)]);
var state_41898__$1 = (function (){var statearr_41932 = state_41898;
(statearr_41932[(8)] = inst_41864);

return statearr_41932;
})();
if(cljs.core.truth_(additional_params)){
var statearr_41933_41966 = state_41898__$1;
(statearr_41933_41966[(1)] = (19));

} else {
var statearr_41934_41967 = state_41898__$1;
(statearr_41934_41967[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41899 === (8))){
var _ = (function (){var statearr_41935 = state_41898;
(statearr_41935[(4)] = cljs.core.rest((state_41898[(4)])));

return statearr_41935;
})();
var state_41898__$1 = state_41898;
var ex41930 = (state_41898__$1[(2)]);
var statearr_41936_41968 = state_41898__$1;
(statearr_41936_41968[(5)] = ex41930);


var statearr_41937_41969 = state_41898__$1;
(statearr_41937_41969[(1)] = (7));

(statearr_41937_41969[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16301__auto____0 = (function (){
var statearr_41938 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41938[(0)] = fluree$db$dbfunctions$internal$state_machine__16301__auto__);

(statearr_41938[(1)] = (1));

return statearr_41938;
});
var fluree$db$dbfunctions$internal$state_machine__16301__auto____1 = (function (state_41898){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_41898);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e41939){var ex__16304__auto__ = e41939;
var statearr_41940_41970 = state_41898;
(statearr_41940_41970[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_41898[(4)]))){
var statearr_41941_41971 = state_41898;
(statearr_41941_41971[(1)] = cljs.core.first((state_41898[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__41972 = state_41898;
state_41898 = G__41972;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16301__auto__ = function(state_41898){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____1.call(this,state_41898);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_41942 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_41942[(6)] = c__16375__auto__);

return statearr_41942;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__41974 = arguments.length;
switch (G__41974) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_42018){
var state_val_42019 = (state_42018[(1)]);
if((state_val_42019 === (7))){
var inst_41996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41997 = ["*"];
var inst_41998 = (new cljs.core.PersistentVector(null,1,(5),inst_41996,inst_41997,null));
var state_42018__$1 = state_42018;
var statearr_42020_42040 = state_42018__$1;
(statearr_42020_42040[(2)] = inst_41998);

(statearr_42020_42040[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42019 === (1))){
var state_42018__$1 = state_42018;
var statearr_42021_42041 = state_42018__$1;
(statearr_42021_42041[(2)] = null);

(statearr_42021_42041[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42019 === (4))){
var inst_41975 = (state_42018[(2)]);
var inst_41976 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41975,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_42018__$1 = state_42018;
var statearr_42022_42042 = state_42018__$1;
(statearr_42022_42042[(2)] = inst_41976);

(statearr_42022_42042[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42019 === (6))){
var inst_41988 = cljs.core.PersistentVector.EMPTY;
var inst_41989 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41990 = ["*"];
var inst_41991 = (new cljs.core.PersistentVector(null,1,(5),inst_41989,inst_41990,null));
var inst_41992 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_41993 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_41991,inst_41992);
var inst_41994 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41988,inst_41993);
var state_42018__$1 = state_42018;
var statearr_42023_42043 = state_42018__$1;
(statearr_42023_42043[(2)] = inst_41994);

(statearr_42023_42043[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42019 === (3))){
var inst_42016 = (state_42018[(2)]);
var state_42018__$1 = state_42018;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42018__$1,inst_42016);
} else {
if((state_val_42019 === (2))){
var _ = (function (){var statearr_42025 = state_42018;
(statearr_42025[(4)] = cljs.core.cons((5),(state_42018[(4)])));

return statearr_42025;
})();
var inst_41985 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41986 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_42018__$1 = (function (){var statearr_42026 = state_42018;
(statearr_42026[(7)] = inst_41985);

(statearr_42026[(8)] = inst_41986);

return statearr_42026;
})();
if(cljs.core.truth_(additional_params)){
var statearr_42027_42044 = state_42018__$1;
(statearr_42027_42044[(1)] = (6));

} else {
var statearr_42028_42045 = state_42018__$1;
(statearr_42028_42045[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42019 === (9))){
var inst_42007 = (state_42018[(2)]);
var inst_42008 = fluree.db.util.async.throw_err(inst_42007);
var inst_42009 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42008,(0),null);
var inst_42010 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42008,(1),null);
var inst_42011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42012 = [inst_42009,inst_42010];
var inst_42013 = (new cljs.core.PersistentVector(null,2,(5),inst_42011,inst_42012,null));
var _ = (function (){var statearr_42029 = state_42018;
(statearr_42029[(4)] = cljs.core.rest((state_42018[(4)])));

return statearr_42029;
})();
var state_42018__$1 = state_42018;
var statearr_42030_42046 = state_42018__$1;
(statearr_42030_42046[(2)] = inst_42013);

(statearr_42030_42046[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42019 === (5))){
var _ = (function (){var statearr_42031 = state_42018;
(statearr_42031[(4)] = cljs.core.rest((state_42018[(4)])));

return statearr_42031;
})();
var state_42018__$1 = state_42018;
var ex42024 = (state_42018__$1[(2)]);
var statearr_42032_42047 = state_42018__$1;
(statearr_42032_42047[(5)] = ex42024);


var statearr_42033_42048 = state_42018__$1;
(statearr_42033_42048[(1)] = (4));

(statearr_42033_42048[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_42019 === (8))){
var inst_41985 = (state_42018[(7)]);
var inst_41986 = (state_42018[(8)]);
var inst_42000 = (state_42018[(2)]);
var inst_42001 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_42002 = cljs.core.PersistentHashMap.EMPTY;
var inst_42003 = [inst_42000,inst_41986,inst_42002];
var inst_42004 = cljs.core.PersistentHashMap.fromArrays(inst_42001,inst_42003);
var inst_42005 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_41985,inst_42004);
var state_42018__$1 = state_42018;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42018__$1,(9),inst_42005);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__16301__auto____0 = (function (){
var statearr_42034 = [null,null,null,null,null,null,null,null,null];
(statearr_42034[(0)] = fluree$db$dbfunctions$internal$state_machine__16301__auto__);

(statearr_42034[(1)] = (1));

return statearr_42034;
});
var fluree$db$dbfunctions$internal$state_machine__16301__auto____1 = (function (state_42018){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_42018);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e42035){var ex__16304__auto__ = e42035;
var statearr_42036_42049 = state_42018;
(statearr_42036_42049[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_42018[(4)]))){
var statearr_42037_42050 = state_42018;
(statearr_42037_42050[(1)] = cljs.core.first((state_42018[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__42051 = state_42018;
state_42018 = G__42051;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__16301__auto__ = function(state_42018){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__16301__auto____1.call(this,state_42018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_42038 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_42038[(6)] = c__16375__auto__);

return statearr_42038;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_42095){
var state_val_42096 = (state_42095[(1)]);
if((state_val_42096 === (1))){
var state_42095__$1 = state_42095;
var statearr_42097_42111 = state_42095__$1;
(statearr_42097_42111[(2)] = null);

(statearr_42097_42111[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42096 === (2))){
var _ = (function (){var statearr_42098 = state_42095;
(statearr_42098[(4)] = cljs.core.cons((5),(state_42095[(4)])));

return statearr_42098;
})();
var inst_42062 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_42063 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42064 = ["_user/_auth"];
var inst_42065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42066 = ["*"];
var inst_42067 = (new cljs.core.PersistentVector(null,1,(5),inst_42065,inst_42066,null));
var inst_42068 = [inst_42067];
var inst_42069 = cljs.core.PersistentHashMap.fromArrays(inst_42064,inst_42068);
var inst_42070 = [inst_42069];
var inst_42071 = (new cljs.core.PersistentVector(null,1,(5),inst_42063,inst_42070,null));
var inst_42072 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_42073 = cljs.core.PersistentHashMap.EMPTY;
var inst_42074 = [inst_42071,inst_42072,inst_42073];
var inst_42075 = cljs.core.PersistentHashMap.fromArrays(inst_42062,inst_42074);
var inst_42076 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_42077 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_42076,inst_42075);
var state_42095__$1 = state_42095;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42095__$1,(6),inst_42077);
} else {
if((state_val_42096 === (3))){
var inst_42093 = (state_42095[(2)]);
var state_42095__$1 = state_42095;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42095__$1,inst_42093);
} else {
if((state_val_42096 === (4))){
var inst_42052 = (state_42095[(2)]);
var inst_42053 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_42052,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_42095__$1 = state_42095;
var statearr_42100_42112 = state_42095__$1;
(statearr_42100_42112[(2)] = inst_42053);

(statearr_42100_42112[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42096 === (5))){
var _ = (function (){var statearr_42101 = state_42095;
(statearr_42101[(4)] = cljs.core.rest((state_42095[(4)])));

return statearr_42101;
})();
var state_42095__$1 = state_42095;
var ex42099 = (state_42095__$1[(2)]);
var statearr_42102_42113 = state_42095__$1;
(statearr_42102_42113[(5)] = ex42099);


var statearr_42103_42114 = state_42095__$1;
(statearr_42103_42114[(1)] = (4));

(statearr_42103_42114[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_42096 === (6))){
var inst_42079 = (state_42095[(2)]);
var inst_42080 = fluree.db.util.async.throw_err(inst_42079);
var inst_42081 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42080,(0),null);
var inst_42082 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42080,(1),null);
var inst_42083 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42084 = ["_user/_auth","_id"];
var inst_42085 = (new cljs.core.PersistentVector(null,2,(5),inst_42083,inst_42084,null));
var inst_42086 = fluree.db.dbfunctions.internal.get_in(inst_42081,inst_42085);
var inst_42087 = cljs.core.first(inst_42086);
var inst_42088 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42089 = [inst_42087,inst_42082];
var inst_42090 = (new cljs.core.PersistentVector(null,2,(5),inst_42088,inst_42089,null));
var _ = (function (){var statearr_42104 = state_42095;
(statearr_42104[(4)] = cljs.core.rest((state_42095[(4)])));

return statearr_42104;
})();
var state_42095__$1 = state_42095;
var statearr_42105_42115 = state_42095__$1;
(statearr_42105_42115[(2)] = inst_42090);

(statearr_42105_42115[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto____0 = (function (){
var statearr_42106 = [null,null,null,null,null,null,null];
(statearr_42106[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto__);

(statearr_42106[(1)] = (1));

return statearr_42106;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto____1 = (function (state_42095){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_42095);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e42107){var ex__16304__auto__ = e42107;
var statearr_42108_42116 = state_42095;
(statearr_42108_42116[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_42095[(4)]))){
var statearr_42109_42117 = state_42095;
(statearr_42109_42117[(1)] = cljs.core.first((state_42095[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__42118 = state_42095;
state_42095 = G__42118;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto__ = function(state_42095){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto____1.call(this,state_42095);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_42110 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_42110[(6)] = c__16375__auto__);

return statearr_42110;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_42135){
var state_val_42136 = (state_42135[(1)]);
if((state_val_42136 === (1))){
var state_42135__$1 = state_42135;
var statearr_42137_42151 = state_42135__$1;
(statearr_42137_42151[(2)] = null);

(statearr_42137_42151[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42136 === (2))){
var _ = (function (){var statearr_42138 = state_42135;
(statearr_42138[(4)] = cljs.core.cons((5),(state_42135[(4)])));

return statearr_42138;
})();
var inst_42125 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_42126 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_42127 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_42126,inst_42125);
var state_42135__$1 = state_42135;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42135__$1,(6),inst_42127);
} else {
if((state_val_42136 === (3))){
var inst_42133 = (state_42135[(2)]);
var state_42135__$1 = state_42135;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42135__$1,inst_42133);
} else {
if((state_val_42136 === (4))){
var inst_42119 = (state_42135[(2)]);
var state_42135__$1 = state_42135;
var statearr_42140_42152 = state_42135__$1;
(statearr_42140_42152[(2)] = inst_42119);

(statearr_42140_42152[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42136 === (5))){
var _ = (function (){var statearr_42141 = state_42135;
(statearr_42141[(4)] = cljs.core.rest((state_42135[(4)])));

return statearr_42141;
})();
var state_42135__$1 = state_42135;
var ex42139 = (state_42135__$1[(2)]);
var statearr_42142_42153 = state_42135__$1;
(statearr_42142_42153[(5)] = ex42139);


if((ex42139 instanceof Error)){
var statearr_42143_42154 = state_42135__$1;
(statearr_42143_42154[(1)] = (4));

(statearr_42143_42154[(5)] = null);

} else {
throw ex42139;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42136 === (6))){
var inst_42129 = (state_42135[(2)]);
var inst_42130 = fluree.db.util.async.throw_err(inst_42129);
var _ = (function (){var statearr_42144 = state_42135;
(statearr_42144[(4)] = cljs.core.rest((state_42135[(4)])));

return statearr_42144;
})();
var state_42135__$1 = state_42135;
var statearr_42145_42155 = state_42135__$1;
(statearr_42145_42155[(2)] = inst_42130);

(statearr_42145_42155[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto____0 = (function (){
var statearr_42146 = [null,null,null,null,null,null,null];
(statearr_42146[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto__);

(statearr_42146[(1)] = (1));

return statearr_42146;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto____1 = (function (state_42135){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_42135);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e42147){var ex__16304__auto__ = e42147;
var statearr_42148_42156 = state_42135;
(statearr_42148_42156[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_42135[(4)]))){
var statearr_42149_42157 = state_42135;
(statearr_42149_42157[(1)] = cljs.core.first((state_42135[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__42158 = state_42135;
state_42135 = G__42158;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto__ = function(state_42135){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto____1.call(this,state_42135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_42150 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_42150[(6)] = c__16375__auto__);

return statearr_42150;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__42159_SHARP_){
return p1__42159_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__42160_SHARP_){
return p1__42160_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e42161){var e = e42161;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__42162_SHARP_){
return p1__42162_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__42163_SHARP_){
return p1__42163_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e42164){var e = e42164;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__42166 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__42166);
})() | (0));
return num;
}catch (e42165){var e = e42165;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_42266){
var state_val_42267 = (state_42266[(1)]);
if((state_val_42267 === (7))){
var state_42266__$1 = state_42266;
var statearr_42268_42316 = state_42266__$1;
(statearr_42268_42316[(2)] = false);

(statearr_42268_42316[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (20))){
var inst_42201 = (state_42266[(7)]);
var inst_42200 = (state_42266[(8)]);
var inst_42222 = (state_42266[(2)]);
var inst_42223 = fluree.db.dbproto._p_prop(inst_42201,cljs.core.cst$kw$multi,inst_42200);
var state_42266__$1 = (function (){var statearr_42269 = state_42266;
(statearr_42269[(9)] = inst_42222);

return statearr_42269;
})();
if(cljs.core.truth_(inst_42223)){
var statearr_42270_42317 = state_42266__$1;
(statearr_42270_42317[(1)] = (21));

} else {
var statearr_42271_42318 = state_42266__$1;
(statearr_42271_42318[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (27))){
var inst_42261 = (state_42266[(2)]);
var _ = (function (){var statearr_42272 = state_42266;
(statearr_42272[(4)] = cljs.core.rest((state_42266[(4)])));

return statearr_42272;
})();
var state_42266__$1 = state_42266;
var statearr_42273_42319 = state_42266__$1;
(statearr_42273_42319[(2)] = inst_42261);

(statearr_42273_42319[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (1))){
var state_42266__$1 = state_42266;
var statearr_42274_42320 = state_42266__$1;
(statearr_42274_42320[(2)] = null);

(statearr_42274_42320[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (24))){
var inst_42250 = (state_42266[(10)]);
var inst_42246 = (state_42266[(2)]);
var inst_42247 = fluree.db.util.async.throw_err(inst_42246);
var inst_42248 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42247,(0),null);
var inst_42249 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42247,(1),null);
var inst_42250__$1 = cljs.core.first(inst_42248);
var inst_42251 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_42250__$1,compare_val);
var state_42266__$1 = (function (){var statearr_42275 = state_42266;
(statearr_42275[(11)] = inst_42249);

(statearr_42275[(10)] = inst_42250__$1);

return statearr_42275;
})();
if(inst_42251){
var statearr_42276_42321 = state_42266__$1;
(statearr_42276_42321[(1)] = (25));

} else {
var statearr_42277_42322 = state_42266__$1;
(statearr_42277_42322[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (4))){
var inst_42167 = (state_42266[(2)]);
var state_42266__$1 = state_42266;
var statearr_42278_42323 = state_42266__$1;
(statearr_42278_42323[(2)] = inst_42167);

(statearr_42278_42323[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (15))){
var state_42266__$1 = state_42266;
var statearr_42279_42324 = state_42266__$1;
(statearr_42279_42324[(2)] = null);

(statearr_42279_42324[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (21))){
var inst_42202 = (state_42266[(12)]);
var inst_42225 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_42202], 0));
var inst_42226 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42227 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_42228 = cljs.core.PersistentHashMap.fromArrays(inst_42226,inst_42227);
var inst_42229 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42225,inst_42228);
var inst_42230 = (function(){throw inst_42229})();
var state_42266__$1 = state_42266;
var statearr_42280_42325 = state_42266__$1;
(statearr_42280_42325[(2)] = inst_42230);

(statearr_42280_42325[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (13))){
var inst_42177 = (state_42266[(13)]);
var state_42266__$1 = state_42266;
var statearr_42281_42326 = state_42266__$1;
(statearr_42281_42326[(2)] = inst_42177);

(statearr_42281_42326[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (22))){
var state_42266__$1 = state_42266;
var statearr_42282_42327 = state_42266__$1;
(statearr_42282_42327[(2)] = null);

(statearr_42282_42327[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (6))){
var inst_42177 = (state_42266[(13)]);
var inst_42182 = inst_42177.cljs$lang$protocol_mask$partition0$;
var inst_42183 = (inst_42182 & (64));
var inst_42184 = inst_42177.cljs$core$ISeq$;
var inst_42185 = (cljs.core.PROTOCOL_SENTINEL === inst_42184);
var inst_42186 = ((inst_42183) || (inst_42185));
var state_42266__$1 = state_42266;
if(cljs.core.truth_(inst_42186)){
var statearr_42283_42328 = state_42266__$1;
(statearr_42283_42328[(1)] = (9));

} else {
var statearr_42284_42329 = state_42266__$1;
(statearr_42284_42329[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (25))){
var state_42266__$1 = state_42266;
var statearr_42285_42330 = state_42266__$1;
(statearr_42285_42330[(2)] = new_val);

(statearr_42285_42330[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (17))){
var inst_42202 = (state_42266[(12)]);
var inst_42212 = (state_42266[(2)]);
var state_42266__$1 = (function (){var statearr_42286 = state_42266;
(statearr_42286[(14)] = inst_42212);

return statearr_42286;
})();
if(cljs.core.truth_(inst_42202)){
var statearr_42287_42331 = state_42266__$1;
(statearr_42287_42331[(1)] = (18));

} else {
var statearr_42288_42332 = state_42266__$1;
(statearr_42288_42332[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (3))){
var inst_42264 = (state_42266[(2)]);
var state_42266__$1 = state_42266;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42266__$1,inst_42264);
} else {
if((state_val_42267 === (12))){
var inst_42177 = (state_42266[(13)]);
var inst_42195 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_42177);
var state_42266__$1 = state_42266;
var statearr_42289_42333 = state_42266__$1;
(statearr_42289_42333[(2)] = inst_42195);

(statearr_42289_42333[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (2))){
var inst_42177 = (state_42266[(13)]);
var _ = (function (){var statearr_42290 = state_42266;
(statearr_42290[(4)] = cljs.core.cons((5),(state_42266[(4)])));

return statearr_42290;
})();
var inst_42177__$1 = _QMARK_ctx;
var inst_42179 = (inst_42177__$1 == null);
var inst_42180 = cljs.core.not(inst_42179);
var state_42266__$1 = (function (){var statearr_42291 = state_42266;
(statearr_42291[(13)] = inst_42177__$1);

return statearr_42291;
})();
if(inst_42180){
var statearr_42292_42334 = state_42266__$1;
(statearr_42292_42334[(1)] = (6));

} else {
var statearr_42293_42335 = state_42266__$1;
(statearr_42293_42335[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (23))){
var inst_42201 = (state_42266[(7)]);
var inst_42199 = (state_42266[(15)]);
var inst_42202 = (state_42266[(12)]);
var inst_42233 = (state_42266[(2)]);
var inst_42234 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_42235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42236 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42237 = [inst_42199,inst_42202,"?current-val"];
var inst_42238 = (new cljs.core.PersistentVector(null,3,(5),inst_42236,inst_42237,null));
var inst_42239 = [inst_42238];
var inst_42240 = (new cljs.core.PersistentVector(null,1,(5),inst_42235,inst_42239,null));
var inst_42241 = cljs.core.PersistentHashMap.EMPTY;
var inst_42242 = ["?current-val",inst_42240,inst_42241];
var inst_42243 = cljs.core.PersistentHashMap.fromArrays(inst_42234,inst_42242);
var inst_42244 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_42201,inst_42243);
var state_42266__$1 = (function (){var statearr_42294 = state_42266;
(statearr_42294[(16)] = inst_42233);

return statearr_42294;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42266__$1,(24),inst_42244);
} else {
if((state_val_42267 === (19))){
var inst_42215 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_42216 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42217 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_42218 = cljs.core.PersistentHashMap.fromArrays(inst_42216,inst_42217);
var inst_42219 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42215,inst_42218);
var inst_42220 = (function(){throw inst_42219})();
var state_42266__$1 = state_42266;
var statearr_42295_42336 = state_42266__$1;
(statearr_42295_42336[(2)] = inst_42220);

(statearr_42295_42336[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (11))){
var inst_42190 = (state_42266[(2)]);
var state_42266__$1 = state_42266;
var statearr_42297_42337 = state_42266__$1;
(statearr_42297_42337[(2)] = inst_42190);

(statearr_42297_42337[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (9))){
var state_42266__$1 = state_42266;
var statearr_42298_42338 = state_42266__$1;
(statearr_42298_42338[(2)] = true);

(statearr_42298_42338[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (5))){
var _ = (function (){var statearr_42299 = state_42266;
(statearr_42299[(4)] = cljs.core.rest((state_42266[(4)])));

return statearr_42299;
})();
var state_42266__$1 = state_42266;
var ex42296 = (state_42266__$1[(2)]);
var statearr_42300_42339 = state_42266__$1;
(statearr_42300_42339[(5)] = ex42296);


if((ex42296 instanceof Error)){
var statearr_42301_42340 = state_42266__$1;
(statearr_42301_42340[(1)] = (4));

(statearr_42301_42340[(5)] = null);

} else {
throw ex42296;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (14))){
var inst_42201 = (state_42266[(7)]);
var inst_42199 = (state_42266[(15)]);
var inst_42200 = (state_42266[(8)]);
var inst_42198 = (state_42266[(2)]);
var inst_42199__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42198,cljs.core.cst$kw$sid);
var inst_42200__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42198,cljs.core.cst$kw$pid);
var inst_42201__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42198,cljs.core.cst$kw$db);
var inst_42202 = fluree.db.dbproto._p_prop(inst_42201__$1,cljs.core.cst$kw$name,inst_42200__$1);
var state_42266__$1 = (function (){var statearr_42302 = state_42266;
(statearr_42302[(7)] = inst_42201__$1);

(statearr_42302[(15)] = inst_42199__$1);

(statearr_42302[(12)] = inst_42202);

(statearr_42302[(8)] = inst_42200__$1);

return statearr_42302;
})();
if(cljs.core.truth_(inst_42199__$1)){
var statearr_42303_42341 = state_42266__$1;
(statearr_42303_42341[(1)] = (15));

} else {
var statearr_42304_42342 = state_42266__$1;
(statearr_42304_42342[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (26))){
var inst_42250 = (state_42266[(10)]);
var inst_42254 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42250)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_42255 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42256 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_42257 = cljs.core.PersistentHashMap.fromArrays(inst_42255,inst_42256);
var inst_42258 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42254,inst_42257);
var inst_42259 = (function(){throw inst_42258})();
var state_42266__$1 = state_42266;
var statearr_42305_42343 = state_42266__$1;
(statearr_42305_42343[(2)] = inst_42259);

(statearr_42305_42343[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (16))){
var inst_42205 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_42206 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42207 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_42208 = cljs.core.PersistentHashMap.fromArrays(inst_42206,inst_42207);
var inst_42209 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42205,inst_42208);
var inst_42210 = (function(){throw inst_42209})();
var state_42266__$1 = state_42266;
var statearr_42306_42344 = state_42266__$1;
(statearr_42306_42344[(2)] = inst_42210);

(statearr_42306_42344[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (10))){
var state_42266__$1 = state_42266;
var statearr_42307_42345 = state_42266__$1;
(statearr_42307_42345[(2)] = false);

(statearr_42307_42345[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (18))){
var state_42266__$1 = state_42266;
var statearr_42308_42346 = state_42266__$1;
(statearr_42308_42346[(2)] = null);

(statearr_42308_42346[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42267 === (8))){
var inst_42193 = (state_42266[(2)]);
var state_42266__$1 = state_42266;
if(cljs.core.truth_(inst_42193)){
var statearr_42309_42347 = state_42266__$1;
(statearr_42309_42347[(1)] = (12));

} else {
var statearr_42310_42348 = state_42266__$1;
(statearr_42310_42348[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto____0 = (function (){
var statearr_42311 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42311[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto__);

(statearr_42311[(1)] = (1));

return statearr_42311;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto____1 = (function (state_42266){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_42266);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e42312){var ex__16304__auto__ = e42312;
var statearr_42313_42349 = state_42266;
(statearr_42313_42349[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_42266[(4)]))){
var statearr_42314_42350 = state_42266;
(statearr_42314_42350[(1)] = cljs.core.first((state_42266[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__42351 = state_42266;
state_42266 = G__42351;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto__ = function(state_42266){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto____1.call(this,state_42266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_42315 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_42315[(6)] = c__16375__auto__);

return statearr_42315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
