// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5735__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5735__auto__)){
var st = temp__5735__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__33586 = cljs.core._EQ_;
var expr__33587 = e.getLastErrorCode();
if(cljs.core.truth_((pred__33586.cljs$core$IFn$_invoke$arity$2 ? pred__33586.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__33587) : pred__33586.call(null,goog.net.ErrorCode.NO_ERROR,expr__33587)))){
return cljs.core.cst$kw$xhttp_SLASH_no_DASH_error;
} else {
if(cljs.core.truth_((pred__33586.cljs$core$IFn$_invoke$arity$2 ? pred__33586.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__33587) : pred__33586.call(null,goog.net.ErrorCode.EXCEPTION,expr__33587)))){
return cljs.core.cst$kw$xhttp_SLASH_exception;
} else {
if(cljs.core.truth_((pred__33586.cljs$core$IFn$_invoke$arity$2 ? pred__33586.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__33587) : pred__33586.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__33587)))){
return cljs.core.cst$kw$xhttp_SLASH_http_DASH_error;
} else {
if(cljs.core.truth_((pred__33586.cljs$core$IFn$_invoke$arity$2 ? pred__33586.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__33587) : pred__33586.call(null,goog.net.ErrorCode.ABORT,expr__33587)))){
return cljs.core.cst$kw$xhttp_SLASH_abort;
} else {
if(cljs.core.truth_((pred__33586.cljs$core$IFn$_invoke$arity$2 ? pred__33586.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__33587) : pred__33586.call(null,goog.net.ErrorCode.TIMEOUT,expr__33587)))){
return cljs.core.cst$kw$xhttp_SLASH_timeout;
} else {
return cljs.core.cst$kw$xhttp_SLASH_unknown_DASH_error;
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4115__auto__ = status;
if(cljs.core.truth_(and__4115__auto__)){
return (status > (0));
} else {
return and__4115__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__33589 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$error,error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33589,cljs.core.cst$kw$status,status);
} else {
return G__33589;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__33590 = opts;
var map__33590__$1 = (((((!((map__33590 == null))))?(((((map__33590.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33590.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33590):map__33590);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33590__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33590__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33590__$1,cljs.core.cst$kw$headers);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__33592 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__33592__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__33592,headers], 0)):G__33592);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33592__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__33592__$1;
}
})();
try{var G__33594_33600 = url;
var G__33595_33601 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__33596_33602 = "POST";
var G__33597_33603 = fluree.db.util.json.stringify(message);
var G__33598_33604 = cljs.core.clj__GT_js(headers__$1);
var G__33599_33605 = request_timeout;
goog.net.XhrIo.send(G__33594_33600,G__33595_33601,G__33596_33602,G__33597_33603,G__33598_33604,G__33599_33605);
}catch (e33593){var e_33606 = e33593;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_33606);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__33607 = opts;
var map__33607__$1 = (((((!((map__33607 == null))))?(((((map__33607.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__33607.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__33607):map__33607);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33607__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33607__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33607__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33607__$1,cljs.core.cst$kw$body);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__33607__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$text);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__33609 = cljs.core.PersistentArrayMap.EMPTY;
var G__33609__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__33609,headers], 0)):G__33609);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33609__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__33609__$1;
}
})();
try{var G__33611_33618 = url;
var G__33612_33619 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__33617 = output_format;
var G__33617__$1 = (((G__33617 instanceof cljs.core.Keyword))?G__33617.fqn:null);
switch (G__33617__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__33613_33620 = "GET";
var G__33614_33621 = body;
var G__33615_33622 = cljs.core.clj__GT_js(headers__$1);
var G__33616_33623 = request_timeout;
goog.net.XhrIo.send(G__33611_33618,G__33612_33619,G__33613_33620,G__33614_33621,G__33615_33622,G__33616_33623);
}catch (e33610){var e_33625 = e33610;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_33625);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__33626 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"Accept"], null),"application/json"),cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$json);
if(cljs.core.truth_(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__33626,cljs.core.cst$kw$body,fluree.db.util.json.stringify(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__33626;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_33659){
var state_val_33660 = (state_33659[(1)]);
if((state_val_33660 === (7))){
var inst_33655 = (state_33659[(2)]);
var state_33659__$1 = state_33659;
var statearr_33661_33686 = state_33659__$1;
(statearr_33661_33686[(2)] = inst_33655);

(statearr_33661_33686[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33660 === (1))){
var state_33659__$1 = state_33659;
var statearr_33662_33687 = state_33659__$1;
(statearr_33662_33687[(2)] = null);

(statearr_33662_33687[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33660 === (4))){
var inst_33630 = (state_33659[(7)]);
var inst_33630__$1 = (state_33659[(2)]);
var inst_33631 = (inst_33630__$1 == null);
var state_33659__$1 = (function (){var statearr_33663 = state_33659;
(statearr_33663[(7)] = inst_33630__$1);

return statearr_33663;
})();
if(cljs.core.truth_(inst_33631)){
var statearr_33664_33688 = state_33659__$1;
(statearr_33664_33688[(1)] = (5));

} else {
var statearr_33665_33689 = state_33659__$1;
(statearr_33665_33689[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33660 === (6))){
var inst_33630 = (state_33659[(7)]);
var inst_33638 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33630,(0),null);
var inst_33639 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33630,(1),null);
var state_33659__$1 = (function (){var statearr_33666 = state_33659;
(statearr_33666[(8)] = inst_33638);

(statearr_33666[(9)] = inst_33639);

return statearr_33666;
})();
var statearr_33667_33690 = state_33659__$1;
(statearr_33667_33690[(2)] = null);

(statearr_33667_33690[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33660 === (3))){
var inst_33657 = (state_33659[(2)]);
var state_33659__$1 = state_33659;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33659__$1,inst_33657);
} else {
if((state_val_33660 === (2))){
var state_33659__$1 = state_33659;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33659__$1,(4),pub_chan);
} else {
if((state_val_33660 === (11))){
var _ = (function (){var statearr_33669 = state_33659;
(statearr_33669[(4)] = cljs.core.rest((state_33659[(4)])));

return statearr_33669;
})();
var state_33659__$1 = state_33659;
var ex33668 = (state_33659__$1[(2)]);
var statearr_33670_33691 = state_33659__$1;
(statearr_33670_33691[(5)] = ex33668);


if((ex33668 instanceof Error)){
var statearr_33671_33692 = state_33659__$1;
(statearr_33671_33692[(1)] = (10));

(statearr_33671_33692[(5)] = null);

} else {
throw ex33668;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33660 === (9))){
var inst_33652 = (state_33659[(2)]);
var state_33659__$1 = (function (){var statearr_33672 = state_33659;
(statearr_33672[(10)] = inst_33652);

return statearr_33672;
})();
var statearr_33673_33693 = state_33659__$1;
(statearr_33673_33693[(2)] = null);

(statearr_33673_33693[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33660 === (5))){
var inst_33633 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_33659__$1 = state_33659;
var statearr_33674_33694 = state_33659__$1;
(statearr_33674_33694[(2)] = inst_33633);

(statearr_33674_33694[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33660 === (10))){
var inst_33639 = (state_33659[(9)]);
var inst_33640 = (state_33659[(2)]);
var inst_33641 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_33640,"Websocket send message error:",inst_33640], 0));
var inst_33642 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33639,false);
var state_33659__$1 = (function (){var statearr_33675 = state_33659;
(statearr_33675[(11)] = inst_33641);

return statearr_33675;
})();
var statearr_33676_33695 = state_33659__$1;
(statearr_33676_33695[(2)] = inst_33642);

(statearr_33676_33695[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33660 === (8))){
var inst_33638 = (state_33659[(8)]);
var inst_33639 = (state_33659[(9)]);
var _ = (function (){var statearr_33677 = state_33659;
(statearr_33677[(4)] = cljs.core.cons((11),(state_33659[(4)])));

return statearr_33677;
})();
var inst_33648 = ws.send(inst_33638);
var inst_33649 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_33639,true);
var ___$1 = (function (){var statearr_33678 = state_33659;
(statearr_33678[(4)] = cljs.core.rest((state_33659[(4)])));

return statearr_33678;
})();
var state_33659__$1 = (function (){var statearr_33679 = state_33659;
(statearr_33679[(12)] = inst_33648);

return statearr_33679;
})();
var statearr_33680_33696 = state_33659__$1;
(statearr_33680_33696[(2)] = inst_33649);

(statearr_33680_33696[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto____0 = (function (){
var statearr_33681 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33681[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto__);

(statearr_33681[(1)] = (1));

return statearr_33681;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto____1 = (function (state_33659){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_33659);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e33682){var ex__16304__auto__ = e33682;
var statearr_33683_33697 = state_33659;
(statearr_33683_33697[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_33659[(4)]))){
var statearr_33684_33698 = state_33659;
(statearr_33684_33698[(1)] = cljs.core.first((state_33659[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__33699 = state_33659;
state_33659 = G__33699;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto__ = function(state_33659){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto____1.call(this,state_33659);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_33685 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_33685[(6)] = c__16375__auto__);

return statearr_33685;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__16375__auto___33738 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_33725){
var state_val_33726 = (state_33725[(1)]);
if((state_val_33726 === (1))){
var inst_33704 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33705 = [open_QMARK_,timeout_chan];
var inst_33706 = (new cljs.core.PersistentVector(null,2,(5),inst_33704,inst_33705,null));
var state_33725__$1 = state_33725;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_33725__$1,(2),inst_33706,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$priority,true], 0));
} else {
if((state_val_33726 === (2))){
var inst_33708 = (state_33725[(2)]);
var inst_33709 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33708,(0),null);
var inst_33710 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33708,(1),null);
var inst_33711 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33710,timeout_chan);
var state_33725__$1 = (function (){var statearr_33727 = state_33725;
(statearr_33727[(7)] = inst_33709);

return statearr_33727;
})();
if(inst_33711){
var statearr_33728_33739 = state_33725__$1;
(statearr_33728_33739[(1)] = (3));

} else {
var statearr_33729_33740 = state_33725__$1;
(statearr_33729_33740[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33726 === (3))){
var inst_33713 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_33714 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33715 = [(400),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_33716 = cljs.core.PersistentHashMap.fromArrays(inst_33714,inst_33715);
var inst_33717 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33713,inst_33716);
var inst_33718 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_33717);
var inst_33719 = fluree.db.util.xhttp.close_websocket(ws);
var state_33725__$1 = (function (){var statearr_33730 = state_33725;
(statearr_33730[(8)] = inst_33718);

return statearr_33730;
})();
var statearr_33731_33741 = state_33725__$1;
(statearr_33731_33741[(2)] = inst_33719);

(statearr_33731_33741[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33726 === (4))){
var inst_33721 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_33725__$1 = state_33725;
var statearr_33732_33742 = state_33725__$1;
(statearr_33732_33742[(2)] = inst_33721);

(statearr_33732_33742[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33726 === (5))){
var inst_33723 = (state_33725[(2)]);
var state_33725__$1 = state_33725;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33725__$1,inst_33723);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto____0 = (function (){
var statearr_33733 = [null,null,null,null,null,null,null,null,null];
(statearr_33733[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto__);

(statearr_33733[(1)] = (1));

return statearr_33733;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto____1 = (function (state_33725){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_33725);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e33734){var ex__16304__auto__ = e33734;
var statearr_33735_33743 = state_33725;
(statearr_33735_33743[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_33725[(4)]))){
var statearr_33736_33744 = state_33725;
(statearr_33736_33744[(1)] = cljs.core.first((state_33725[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__33745 = state_33725;
state_33725 = G__33745;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto__ = function(state_33725){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto____1.call(this,state_33725);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_33737 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_33737[(6)] = c__16375__auto___33738);

return statearr_33737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));


return cljs.core.cst$kw$fluree$db$util$xhttp_SLASH_no_DASH_return;
});
