// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e34007){var e = e34007;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__34008_SHARP_){
var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__34008_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__34008_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__34008_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__34008_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (cljs.core.not(key_as_var)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__34009_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34009_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__34010_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34010_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4115__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4126__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__34015 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34015,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34015,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__34011_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34011_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$object_DASH_fn], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,var$], null),idx);
} else {
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1)))?cljs.core.re_find(/\+/,key):false))){
var vec__34018 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34018,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34018,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4126__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__34012_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34012_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$recur], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__34013_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34013_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__34014_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__34014_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$search,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$rel,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$opts,cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34021_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__34021_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5733__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5733__auto__)){
var var$__$1 = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5733__auto__ = (function (){var or__4126__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var var$ = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (add_amount > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = fuel;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4115__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5733__auto__ = (function (){var G__34022 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__34022) : intersecting_vars.call(null,G__34022));
})();
if(cljs.core.truth_(temp__5733__auto__)){
var key_replace = temp__5733__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__34025,optional_QMARK_,fuel,max_fuel){
var map__34026 = p__34025;
var map__34026__$1 = (((((!((map__34026 == null))))?(((((map__34026.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34026.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34026):map__34026);
var res = map__34026__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34026__$1,cljs.core.cst$kw$vars);
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_34093){
var state_val_34094 = (state_34093[(1)]);
if((state_val_34094 === (7))){
var inst_34082 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34083 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_34084 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34083,clause);
var inst_34085 = [null,inst_34084];
var inst_34086 = (new cljs.core.PersistentVector(null,2,(5),inst_34082,inst_34085,null));
var state_34093__$1 = state_34093;
var statearr_34095_34123 = state_34093__$1;
(statearr_34095_34123[(2)] = inst_34086);

(statearr_34095_34123[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34094 === (1))){
var state_34093__$1 = state_34093;
var statearr_34096_34124 = state_34093__$1;
(statearr_34096_34124[(2)] = null);

(statearr_34096_34124[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34094 === (4))){
var inst_34028 = (state_34093[(2)]);
var state_34093__$1 = state_34093;
var statearr_34097_34125 = state_34093__$1;
(statearr_34097_34125[(2)] = inst_34028);

(statearr_34097_34125[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34094 === (15))){
var inst_34071 = (state_34093[(2)]);
var inst_34072 = fluree.db.util.async.throw_err(inst_34071);
var inst_34073 = cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(inst_34072);
var inst_34074 = cljs.core.count(inst_34073);
var inst_34075 = fluree.db.query.analytical.add_fuel(inst_34074,fuel,max_fuel);
var inst_34076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34077 = [inst_34072,r];
var inst_34078 = (new cljs.core.PersistentVector(null,2,(5),inst_34076,inst_34077,null));
var state_34093__$1 = (function (){var statearr_34098 = state_34093;
(statearr_34098[(7)] = inst_34075);

return statearr_34098;
})();
var statearr_34099_34126 = state_34093__$1;
(statearr_34099_34126[(2)] = inst_34078);

(statearr_34099_34126[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34094 === (13))){
var inst_34037 = (state_34093[(8)]);
var inst_34050 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_34051 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_34050);
var inst_34052 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_34037);
var inst_34053 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_34052);
var inst_34054 = cljs.core.set(inst_34053);
var inst_34055 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_34051);
var inst_34056 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_34055);
var inst_34057 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34054,inst_34056);
var inst_34058 = (function (){var all_wd = inst_34037;
var optional = inst_34051;
var all_wd_vars = inst_34054;
var all_vars = inst_34057;
return (function (p1__34023_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__34023_SHARP_) : all_vars.call(null,p1__34023_SHARP_));
});
})();
var inst_34059 = cljs.core.keys(vars);
var inst_34060 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34058,inst_34059);
var inst_34061 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_34060);
var inst_34062 = cljs.core.set(inst_34061);
var inst_34063 = (function (){var all_wd = inst_34037;
var optional = inst_34051;
var all_wd_vars = inst_34054;
var all_vars = inst_34057;
var intersecting_vars = inst_34062;
return (function (p1__34024_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__34024_SHARP_);
});
})();
var inst_34064 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34063,inst_34037);
var inst_34065 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_34064);
var inst_34066 = fluree.db.query.analytical.select_from_tuples(inst_34065,res);
var inst_34067 = fluree.db.query.analytical.replace_vars_wikidata(inst_34037,inst_34062,vars);
var inst_34068 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_34062,inst_34057);
var inst_34069 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_34067,inst_34065,inst_34066,inst_34068,inst_34051);
var state_34093__$1 = state_34093;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34093__$1,(15),inst_34069);
} else {
if((state_val_34094 === (6))){
var inst_34038 = (state_34093[(9)]);
var inst_34036 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_34037 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_34036);
var inst_34038__$1 = optional_QMARK_;
var state_34093__$1 = (function (){var statearr_34100 = state_34093;
(statearr_34100[(8)] = inst_34037);

(statearr_34100[(9)] = inst_34038__$1);

return statearr_34100;
})();
if(cljs.core.truth_(inst_34038__$1)){
var statearr_34101_34127 = state_34093__$1;
(statearr_34101_34127[(1)] = (9));

} else {
var statearr_34102_34128 = state_34093__$1;
(statearr_34102_34128[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34094 === (3))){
var inst_34091 = (state_34093[(2)]);
var state_34093__$1 = state_34093;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34093__$1,inst_34091);
} else {
if((state_val_34094 === (12))){
var inst_34046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34047 = [null,r];
var inst_34048 = (new cljs.core.PersistentVector(null,2,(5),inst_34046,inst_34047,null));
var state_34093__$1 = state_34093;
var statearr_34103_34129 = state_34093__$1;
(statearr_34103_34129[(2)] = inst_34048);

(statearr_34103_34129[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34094 === (2))){
var _ = (function (){var statearr_34104 = state_34093;
(statearr_34104[(4)] = cljs.core.cons((5),(state_34093[(4)])));

return statearr_34104;
})();
var inst_34034 = (r == null);
var state_34093__$1 = state_34093;
if(cljs.core.truth_(inst_34034)){
var statearr_34105_34130 = state_34093__$1;
(statearr_34105_34130[(1)] = (6));

} else {
var statearr_34106_34131 = state_34093__$1;
(statearr_34106_34131[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34094 === (11))){
var inst_34044 = (state_34093[(2)]);
var state_34093__$1 = state_34093;
if(cljs.core.truth_(inst_34044)){
var statearr_34108_34132 = state_34093__$1;
(statearr_34108_34132[(1)] = (12));

} else {
var statearr_34109_34133 = state_34093__$1;
(statearr_34109_34133[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34094 === (9))){
var inst_34037 = (state_34093[(8)]);
var inst_34040 = cljs.core.empty_QMARK_(inst_34037);
var inst_34041 = (!(inst_34040));
var state_34093__$1 = state_34093;
var statearr_34110_34134 = state_34093__$1;
(statearr_34110_34134[(2)] = inst_34041);

(statearr_34110_34134[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34094 === (5))){
var _ = (function (){var statearr_34111 = state_34093;
(statearr_34111[(4)] = cljs.core.rest((state_34093[(4)])));

return statearr_34111;
})();
var state_34093__$1 = state_34093;
var ex34107 = (state_34093__$1[(2)]);
var statearr_34112_34135 = state_34093__$1;
(statearr_34112_34135[(5)] = ex34107);


if((ex34107 instanceof Error)){
var statearr_34113_34136 = state_34093__$1;
(statearr_34113_34136[(1)] = (4));

(statearr_34113_34136[(5)] = null);

} else {
throw ex34107;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34094 === (14))){
var inst_34080 = (state_34093[(2)]);
var state_34093__$1 = state_34093;
var statearr_34114_34137 = state_34093__$1;
(statearr_34114_34137[(2)] = inst_34080);

(statearr_34114_34137[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34094 === (10))){
var inst_34038 = (state_34093[(9)]);
var state_34093__$1 = state_34093;
var statearr_34115_34138 = state_34093__$1;
(statearr_34115_34138[(2)] = inst_34038);

(statearr_34115_34138[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34094 === (8))){
var inst_34088 = (state_34093[(2)]);
var _ = (function (){var statearr_34116 = state_34093;
(statearr_34116[(4)] = cljs.core.rest((state_34093[(4)])));

return statearr_34116;
})();
var state_34093__$1 = state_34093;
var statearr_34117_34139 = state_34093__$1;
(statearr_34117_34139[(2)] = inst_34088);

(statearr_34117_34139[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_34118 = [null,null,null,null,null,null,null,null,null,null];
(statearr_34118[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto__);

(statearr_34118[(1)] = (1));

return statearr_34118;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto____1 = (function (state_34093){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_34093);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e34119){var ex__16304__auto__ = e34119;
var statearr_34120_34140 = state_34093;
(statearr_34120_34140[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_34093[(4)]))){
var statearr_34121_34141 = state_34093;
(statearr_34121_34141[(1)] = cljs.core.first((state_34093[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__34142 = state_34093;
state_34093 = G__34142;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto__ = function(state_34093){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto____1.call(this,state_34093);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_34122 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_34122[(6)] = c__16375__auto__);

return statearr_34122;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__34144 = arguments.length;
switch (G__34144) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_34238){
var state_val_34239 = (state_34238[(1)]);
if((state_val_34239 === (7))){
var inst_34151 = (state_34238[(7)]);
var inst_34161 = clojure.string.starts_with_QMARK_(inst_34151,"$fdb");
var state_34238__$1 = state_34238;
if(inst_34161){
var statearr_34240_34289 = state_34238__$1;
(statearr_34240_34289[(1)] = (9));

} else {
var statearr_34241_34290 = state_34238__$1;
(statearr_34241_34290[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (20))){
var state_34238__$1 = state_34238;
var statearr_34242_34291 = state_34238__$1;
(statearr_34242_34291[(2)] = null);

(statearr_34242_34291[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (27))){
var inst_34201 = (state_34238[(8)]);
var state_34238__$1 = state_34238;
var statearr_34243_34292 = state_34238__$1;
(statearr_34243_34292[(2)] = inst_34201);

(statearr_34243_34292[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (1))){
var state_34238__$1 = state_34238;
var statearr_34244_34293 = state_34238__$1;
(statearr_34244_34293[(2)] = null);

(statearr_34244_34293[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (24))){
var inst_34224 = (state_34238[(2)]);
var state_34238__$1 = state_34238;
var statearr_34245_34294 = state_34238__$1;
(statearr_34245_34294[(2)] = inst_34224);

(statearr_34245_34294[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (4))){
var inst_34145 = (state_34238[(2)]);
var state_34238__$1 = state_34238;
var statearr_34246_34295 = state_34238__$1;
(statearr_34246_34295[(2)] = inst_34145);

(statearr_34246_34295[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (15))){
var inst_34168 = (state_34238[(9)]);
var inst_34174 = (state_34238[(2)]);
var inst_34175 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34176 = cljs.core.PersistentVector.EMPTY;
var inst_34177 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_34178 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34176,inst_34177);
var inst_34179 = [inst_34168,inst_34178];
var inst_34180 = (new cljs.core.PersistentVector(null,2,(5),inst_34175,inst_34179,null));
var state_34238__$1 = (function (){var statearr_34247 = state_34238;
(statearr_34247[(10)] = inst_34174);

return statearr_34247;
})();
var statearr_34248_34296 = state_34238__$1;
(statearr_34248_34296[(2)] = inst_34180);

(statearr_34248_34296[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (21))){
var inst_34227 = (state_34238[(2)]);
var state_34238__$1 = state_34238;
var statearr_34249_34297 = state_34238__$1;
(statearr_34249_34297[(2)] = inst_34227);

(statearr_34249_34297[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (13))){
var inst_34168 = (state_34238[(9)]);
var inst_34171 = (function(){throw inst_34168})();
var state_34238__$1 = state_34238;
var statearr_34250_34298 = state_34238__$1;
(statearr_34250_34298[(2)] = inst_34171);

(statearr_34250_34298[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (22))){
var inst_34190 = (state_34238[(11)]);
var inst_34192 = (state_34238[(12)]);
var inst_34194 = fluree.db.query.analytical.parse_block_from_source(inst_34190);
var inst_34195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34196 = [cljs.core.cst$kw$sources,inst_34192];
var inst_34197 = (new cljs.core.PersistentVector(null,2,(5),inst_34195,inst_34196,null));
var inst_34198 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_34197);
var state_34238__$1 = (function (){var statearr_34251 = state_34238;
(statearr_34251[(13)] = inst_34194);

return statearr_34251;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34238__$1,(25),inst_34198);
} else {
if((state_val_34239 === (29))){
var inst_34205 = (state_34238[(2)]);
var inst_34206 = fluree.db.util.async.throw_err(inst_34205);
var state_34238__$1 = state_34238;
var statearr_34252_34299 = state_34238__$1;
(statearr_34252_34299[(2)] = inst_34206);

(statearr_34252_34299[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (6))){
var inst_34154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34155 = cljs.core.PersistentVector.EMPTY;
var inst_34156 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_34157 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34155,inst_34156);
var inst_34158 = [db,inst_34157];
var inst_34159 = (new cljs.core.PersistentVector(null,2,(5),inst_34154,inst_34158,null));
var state_34238__$1 = state_34238;
var statearr_34253_34300 = state_34238__$1;
(statearr_34253_34300[(2)] = inst_34159);

(statearr_34253_34300[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (28))){
var inst_34209 = (state_34238[(2)]);
var inst_34210 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34211 = cljs.core.PersistentVector.EMPTY;
var inst_34212 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_34213 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34211,inst_34212);
var inst_34214 = [inst_34209,inst_34213];
var inst_34215 = (new cljs.core.PersistentVector(null,2,(5),inst_34210,inst_34214,null));
var state_34238__$1 = state_34238;
var statearr_34254_34301 = state_34238__$1;
(statearr_34254_34301[(2)] = inst_34215);

(statearr_34254_34301[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (25))){
var inst_34194 = (state_34238[(13)]);
var inst_34200 = (state_34238[(2)]);
var inst_34201 = fluree.db.util.async.throw_err(inst_34200);
var state_34238__$1 = (function (){var statearr_34255 = state_34238;
(statearr_34255[(8)] = inst_34201);

return statearr_34255;
})();
if(cljs.core.truth_(inst_34194)){
var statearr_34256_34302 = state_34238__$1;
(statearr_34256_34302[(1)] = (26));

} else {
var statearr_34257_34303 = state_34238__$1;
(statearr_34257_34303[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (17))){
var state_34238__$1 = state_34238;
var statearr_34258_34304 = state_34238__$1;
(statearr_34258_34304[(1)] = (19));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (3))){
var inst_34236 = (state_34238[(2)]);
var state_34238__$1 = state_34238;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34238__$1,inst_34236);
} else {
if((state_val_34239 === (12))){
var inst_34168 = (state_34238[(9)]);
var inst_34167 = (state_34238[(2)]);
var inst_34168__$1 = fluree.db.util.async.throw_err(inst_34167);
var inst_34169 = fluree.db.util.core.exception_QMARK_(inst_34168__$1);
var state_34238__$1 = (function (){var statearr_34260 = state_34238;
(statearr_34260[(9)] = inst_34168__$1);

return statearr_34260;
})();
if(inst_34169){
var statearr_34261_34305 = state_34238__$1;
(statearr_34261_34305[(1)] = (13));

} else {
var statearr_34262_34306 = state_34238__$1;
(statearr_34262_34306[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (2))){
var inst_34151 = (state_34238[(7)]);
var _ = (function (){var statearr_34263 = state_34238;
(statearr_34263[(4)] = cljs.core.cons((5),(state_34238[(4)])));

return statearr_34263;
})();
var inst_34151__$1 = cljs.core.first(clause);
var inst_34152 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_34151__$1);
var state_34238__$1 = (function (){var statearr_34264 = state_34238;
(statearr_34264[(7)] = inst_34151__$1);

return statearr_34264;
})();
if(inst_34152){
var statearr_34265_34307 = state_34238__$1;
(statearr_34265_34307[(1)] = (6));

} else {
var statearr_34266_34308 = state_34238__$1;
(statearr_34266_34308[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (23))){
var inst_34151 = (state_34238[(7)]);
var inst_34217 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34151)," is not supported in Fluree"].join('');
var inst_34218 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34219 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_34220 = cljs.core.PersistentHashMap.fromArrays(inst_34218,inst_34219);
var inst_34221 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34217,inst_34220);
var inst_34222 = (function(){throw inst_34221})();
var state_34238__$1 = state_34238;
var statearr_34267_34309 = state_34238__$1;
(statearr_34267_34309[(2)] = inst_34222);

(statearr_34267_34309[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (19))){
var inst_34151 = (state_34238[(7)]);
var inst_34192 = (state_34238[(12)]);
var inst_34189 = fluree.db.query.analytical.isolate_source_name(inst_34151);
var inst_34190 = fluree.db.query.analytical.isolate_source_block(inst_34151);
var inst_34191 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_34189);
var inst_34192__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_34191);
var state_34238__$1 = (function (){var statearr_34268 = state_34238;
(statearr_34268[(11)] = inst_34190);

(statearr_34268[(12)] = inst_34192__$1);

return statearr_34268;
})();
if(cljs.core.truth_(inst_34192__$1)){
var statearr_34269_34310 = state_34238__$1;
(statearr_34269_34310[(1)] = (22));

} else {
var statearr_34270_34311 = state_34238__$1;
(statearr_34270_34311[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (11))){
var inst_34231 = (state_34238[(2)]);
var state_34238__$1 = state_34238;
var statearr_34272_34312 = state_34238__$1;
(statearr_34272_34312[(2)] = inst_34231);

(statearr_34272_34312[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (9))){
var inst_34151 = (state_34238[(7)]);
var inst_34163 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_34151,(4));
var inst_34164 = fluree.db.query.analytical.parse_block_from_source(inst_34163);
var inst_34165 = fluree.db.time_travel.as_of_block(db,inst_34164);
var state_34238__$1 = state_34238;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34238__$1,(12),inst_34165);
} else {
if((state_val_34239 === (5))){
var _ = (function (){var statearr_34273 = state_34238;
(statearr_34273[(4)] = cljs.core.rest((state_34238[(4)])));

return statearr_34273;
})();
var state_34238__$1 = state_34238;
var ex34271 = (state_34238__$1[(2)]);
var statearr_34274_34313 = state_34238__$1;
(statearr_34274_34313[(5)] = ex34271);


if((ex34271 instanceof Error)){
var statearr_34275_34314 = state_34238__$1;
(statearr_34275_34314[(1)] = (4));

(statearr_34275_34314[(5)] = null);

} else {
throw ex34271;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (14))){
var state_34238__$1 = state_34238;
var statearr_34276_34315 = state_34238__$1;
(statearr_34276_34315[(2)] = null);

(statearr_34276_34315[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (26))){
var inst_34194 = (state_34238[(13)]);
var inst_34201 = (state_34238[(8)]);
var inst_34203 = fluree.db.time_travel.as_of_block(inst_34201,inst_34194);
var state_34238__$1 = state_34238;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34238__$1,(29),inst_34203);
} else {
if((state_val_34239 === (16))){
var inst_34184 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34185 = ["$wd",clause];
var inst_34186 = (new cljs.core.PersistentVector(null,2,(5),inst_34184,inst_34185,null));
var state_34238__$1 = state_34238;
var statearr_34277_34316 = state_34238__$1;
(statearr_34277_34316[(2)] = inst_34186);

(statearr_34277_34316[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (10))){
var inst_34151 = (state_34238[(7)]);
var inst_34182 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_34151);
var state_34238__$1 = state_34238;
if(inst_34182){
var statearr_34278_34317 = state_34238__$1;
(statearr_34278_34317[(1)] = (16));

} else {
var statearr_34279_34318 = state_34238__$1;
(statearr_34279_34318[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (18))){
var inst_34229 = (state_34238[(2)]);
var state_34238__$1 = state_34238;
var statearr_34280_34319 = state_34238__$1;
(statearr_34280_34319[(2)] = inst_34229);

(statearr_34280_34319[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34239 === (8))){
var inst_34233 = (state_34238[(2)]);
var _ = (function (){var statearr_34281 = state_34238;
(statearr_34281[(4)] = cljs.core.rest((state_34238[(4)])));

return statearr_34281;
})();
var state_34238__$1 = state_34238;
var statearr_34282_34320 = state_34238__$1;
(statearr_34282_34320[(2)] = inst_34233);

(statearr_34282_34320[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__16301__auto__ = null;
var fluree$db$query$analytical$state_machine__16301__auto____0 = (function (){
var statearr_34283 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34283[(0)] = fluree$db$query$analytical$state_machine__16301__auto__);

(statearr_34283[(1)] = (1));

return statearr_34283;
});
var fluree$db$query$analytical$state_machine__16301__auto____1 = (function (state_34238){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_34238);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e34284){var ex__16304__auto__ = e34284;
var statearr_34285_34321 = state_34238;
(statearr_34285_34321[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_34238[(4)]))){
var statearr_34286_34322 = state_34238;
(statearr_34286_34322[(1)] = cljs.core.first((state_34238[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__34323 = state_34238;
state_34238 = G__34323;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__16301__auto__ = function(state_34238){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__16301__auto____1.call(this,state_34238);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__16301__auto____0;
fluree$db$query$analytical$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__16301__auto____1;
return fluree$db$query$analytical$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_34287 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_34287[(6)] = c__16375__auto__);

return statearr_34287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__34324){
var vec__34325 = p__34324;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34325,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34325,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34328_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$done,cljs.core.cst$kw$followed,cljs.core.cst$kw$all],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__34328_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__34332 = subjects;
var vec__34333 = G__34332;
var seq__34334 = cljs.core.seq(vec__34333);
var first__34335 = cljs.core.first(seq__34334);
var seq__34334__$1 = cljs.core.next(seq__34334);
var subject = first__34335;
var r = seq__34334__$1;
var acc = expanded_map;
var G__34332__$1 = G__34332;
var acc__$1 = acc;
while(true){
var vec__34339 = G__34332__$1;
var seq__34340 = cljs.core.seq(vec__34339);
var first__34341 = cljs.core.first(seq__34340);
var seq__34340__$1 = cljs.core.next(seq__34340);
var subject__$1 = first__34341;
var r__$1 = seq__34340__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null)))){
var G__34342 = r__$1;
var G__34343 = acc__$2;
G__34332__$1 = G__34342;
acc__$1 = G__34343;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__34332__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__34339,seq__34340,first__34341,seq__34340__$1,subject__$1,r__$1,acc__$2,G__34332,vec__34333,seq__34334,first__34335,seq__34334__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4126__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$all], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null),((function (G__34332__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__34339,seq__34340,first__34341,seq__34340__$1,subject__$1,r__$1,acc__$2,G__34332,vec__34333,seq__34334,first__34335,seq__34334__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__34332__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__34339,seq__34340,first__34341,seq__34340__$1,subject__$1,r__$1,acc__$2,G__34332,vec__34333,seq__34334,first__34335,seq__34334__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$done], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),((function (G__34332__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__34339,seq__34340,first__34341,seq__34340__$1,subject__$1,r__$1,acc__$2,G__34332,vec__34333,seq__34334,first__34335,seq__34334__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__34332__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__34339,seq__34340,first__34341,seq__34340__$1,subject__$1,r__$1,acc__$2,G__34332,vec__34333,seq__34334,first__34335,seq__34334__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__34332__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__34339,seq__34340,first__34341,seq__34340__$1,subject__$1,r__$1,acc__$2,G__34332,vec__34333,seq__34334,first__34335,seq__34334__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__34344 = r__$1;
var G__34345 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null),true);
G__34332__$1 = G__34344;
acc__$1 = G__34345;
continue;
} else {
var G__34346 = subjects;
var G__34347 = acc_STAR_;
G__34332__$1 = G__34346;
acc__$1 = G__34347;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$followed], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34348_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__34348_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_34439){
var state_val_34440 = (state_34439[(1)]);
if((state_val_34440 === (7))){
var state_34439__$1 = state_34439;
var statearr_34441_34487 = state_34439__$1;
(statearr_34441_34487[(2)] = (100));

(statearr_34441_34487[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (20))){
var inst_34388 = (state_34439[(7)]);
var state_34439__$1 = state_34439;
var statearr_34442_34488 = state_34439__$1;
(statearr_34442_34488[(2)] = inst_34388);

(statearr_34442_34488[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (1))){
var state_34439__$1 = state_34439;
var statearr_34443_34489 = state_34439__$1;
(statearr_34443_34489[(2)] = null);

(statearr_34443_34489[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (24))){
var inst_34360 = (state_34439[(8)]);
var inst_34427 = (state_34439[(9)]);
var inst_34426 = (state_34439[(10)]);
var inst_34425 = (state_34439[(11)]);
var inst_34430 = (function (){var max_depth = inst_34360;
var recur_map__$1 = inst_34426;
var subjects = inst_34425;
var tuples = inst_34427;
return (function (p1__34349_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__34349_SHARP_)],null));
});
})();
var inst_34431 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34430,inst_34427);
var inst_34432 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_34431);
var state_34439__$1 = state_34439;
var statearr_34444_34490 = state_34439__$1;
(statearr_34444_34490[(2)] = inst_34432);

(statearr_34444_34490[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (4))){
var inst_34350 = (state_34439[(2)]);
var state_34439__$1 = state_34439;
var statearr_34445_34491 = state_34439__$1;
(statearr_34445_34491[(2)] = inst_34350);

(statearr_34445_34491[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (15))){
var inst_34373 = (state_34439[(12)]);
var inst_34384 = cljs.core.PersistentVector.EMPTY;
var inst_34385 = cljs.core.seq(inst_34373);
var inst_34386 = cljs.core.first(inst_34385);
var inst_34387 = cljs.core.next(inst_34385);
var inst_34388 = inst_34384;
var inst_34389 = inst_34373;
var state_34439__$1 = (function (){var statearr_34446 = state_34439;
(statearr_34446[(13)] = inst_34389);

(statearr_34446[(7)] = inst_34388);

(statearr_34446[(14)] = inst_34387);

(statearr_34446[(15)] = inst_34386);

return statearr_34446;
})();
var statearr_34447_34492 = state_34439__$1;
(statearr_34447_34492[(2)] = null);

(statearr_34447_34492[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (21))){
var inst_34409 = (state_34439[(2)]);
var state_34439__$1 = state_34439;
var statearr_34448_34493 = state_34439__$1;
(statearr_34448_34493[(2)] = inst_34409);

(statearr_34448_34493[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (13))){
var inst_34422 = (state_34439[(2)]);
var state_34439__$1 = state_34439;
var statearr_34449_34494 = state_34439__$1;
(statearr_34449_34494[(2)] = inst_34422);

(statearr_34449_34494[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (22))){
var inst_34388 = (state_34439[(7)]);
var inst_34396 = (state_34439[(16)]);
var inst_34403 = (state_34439[(2)]);
var inst_34404 = fluree.db.util.async.throw_err(inst_34403);
var inst_34405 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_34388,inst_34404);
var inst_34388__$1 = inst_34405;
var inst_34389 = inst_34396;
var state_34439__$1 = (function (){var statearr_34450 = state_34439;
(statearr_34450[(13)] = inst_34389);

(statearr_34450[(7)] = inst_34388__$1);

return statearr_34450;
})();
var statearr_34451_34495 = state_34439__$1;
(statearr_34451_34495[(2)] = null);

(statearr_34451_34495[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (6))){
var inst_34356 = (state_34439[(17)]);
var state_34439__$1 = state_34439;
var statearr_34452_34496 = state_34439__$1;
(statearr_34452_34496[(2)] = inst_34356);

(statearr_34452_34496[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (25))){
var inst_34434 = (state_34439[(2)]);
var _ = (function (){var statearr_34453 = state_34439;
(statearr_34453[(4)] = cljs.core.rest((state_34439[(4)])));

return statearr_34453;
})();
var state_34439__$1 = state_34439;
var statearr_34454_34497 = state_34439__$1;
(statearr_34454_34497[(2)] = inst_34434);

(statearr_34454_34497[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (17))){
var inst_34389 = (state_34439[(13)]);
var inst_34395 = (state_34439[(18)]);
var inst_34394 = cljs.core.seq(inst_34389);
var inst_34395__$1 = cljs.core.first(inst_34394);
var inst_34396 = cljs.core.next(inst_34394);
var state_34439__$1 = (function (){var statearr_34455 = state_34439;
(statearr_34455[(18)] = inst_34395__$1);

(statearr_34455[(16)] = inst_34396);

return statearr_34455;
})();
if(cljs.core.truth_(inst_34395__$1)){
var statearr_34456_34498 = state_34439__$1;
(statearr_34456_34498[(1)] = (19));

} else {
var statearr_34457_34499 = state_34439__$1;
(statearr_34457_34499[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (3))){
var inst_34437 = (state_34439[(2)]);
var state_34439__$1 = state_34439;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34439__$1,inst_34437);
} else {
if((state_val_34440 === (12))){
var inst_34362 = (state_34439[(19)]);
var inst_34373 = (state_34439[(12)]);
var inst_34368 = cljs.core.vals(inst_34362);
var inst_34369 = cljs.core.flatten(inst_34368);
var inst_34370 = cljs.core.set(inst_34369);
var inst_34371 = cljs.core.keys(inst_34362);
var inst_34372 = cljs.core.set(inst_34371);
var inst_34373__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_34370,inst_34372);
var inst_34374 = cljs.core.empty_QMARK_(inst_34373__$1);
var state_34439__$1 = (function (){var statearr_34458 = state_34439;
(statearr_34458[(12)] = inst_34373__$1);

return statearr_34458;
})();
if(inst_34374){
var statearr_34459_34500 = state_34439__$1;
(statearr_34459_34500[(1)] = (14));

} else {
var statearr_34460_34501 = state_34439__$1;
(statearr_34460_34501[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (2))){
var inst_34356 = (state_34439[(17)]);
var _ = (function (){var statearr_34461 = state_34439;
(statearr_34461[(4)] = cljs.core.cons((5),(state_34439[(4)])));

return statearr_34461;
})();
var inst_34356__$1 = depth;
var state_34439__$1 = (function (){var statearr_34462 = state_34439;
(statearr_34462[(17)] = inst_34356__$1);

return statearr_34462;
})();
if(cljs.core.truth_(inst_34356__$1)){
var statearr_34463_34502 = state_34439__$1;
(statearr_34463_34502[(1)] = (6));

} else {
var statearr_34464_34503 = state_34439__$1;
(statearr_34464_34503[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (23))){
var inst_34427 = (state_34439[(9)]);
var state_34439__$1 = state_34439;
var statearr_34465_34504 = state_34439__$1;
(statearr_34465_34504[(2)] = inst_34427);

(statearr_34465_34504[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (19))){
var inst_34395 = (state_34439[(18)]);
var inst_34398 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34399 = [inst_34395,predicate];
var inst_34400 = (new cljs.core.PersistentVector(null,2,(5),inst_34398,inst_34399,null));
var inst_34401 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_34400);
var state_34439__$1 = state_34439;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34439__$1,(22),inst_34401);
} else {
if((state_val_34440 === (11))){
var inst_34362 = (state_34439[(19)]);
var state_34439__$1 = state_34439;
var statearr_34467_34505 = state_34439__$1;
(statearr_34467_34505[(2)] = inst_34362);

(statearr_34467_34505[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (9))){
var inst_34360 = (state_34439[(8)]);
var inst_34363 = (state_34439[(20)]);
var inst_34365 = (inst_34363 >= inst_34360);
var state_34439__$1 = state_34439;
if(cljs.core.truth_(inst_34365)){
var statearr_34468_34506 = state_34439__$1;
(statearr_34468_34506[(1)] = (11));

} else {
var statearr_34469_34507 = state_34439__$1;
(statearr_34469_34507[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (5))){
var _ = (function (){var statearr_34470 = state_34439;
(statearr_34470[(4)] = cljs.core.rest((state_34439[(4)])));

return statearr_34470;
})();
var state_34439__$1 = state_34439;
var ex34466 = (state_34439__$1[(2)]);
var statearr_34471_34508 = state_34439__$1;
(statearr_34471_34508[(5)] = ex34466);


if((ex34466 instanceof Error)){
var statearr_34472_34509 = state_34439__$1;
(statearr_34472_34509[(1)] = (4));

(statearr_34472_34509[(5)] = null);

} else {
throw ex34466;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (14))){
var inst_34362 = (state_34439[(19)]);
var state_34439__$1 = state_34439;
var statearr_34473_34510 = state_34439__$1;
(statearr_34473_34510[(2)] = inst_34362);

(statearr_34473_34510[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (16))){
var inst_34420 = (state_34439[(2)]);
var state_34439__$1 = state_34439;
var statearr_34474_34511 = state_34439__$1;
(statearr_34474_34511[(2)] = inst_34420);

(statearr_34474_34511[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (10))){
var inst_34426 = (state_34439[(10)]);
var inst_34425 = (state_34439[(11)]);
var inst_34424 = (state_34439[(2)]);
var inst_34425__$1 = cljs.core.keys(inst_34424);
var inst_34426__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_34425__$1,inst_34424);
var inst_34427 = fluree.db.query.analytical.recur_map__GT_tuples(inst_34425__$1,inst_34426__$1);
var state_34439__$1 = (function (){var statearr_34475 = state_34439;
(statearr_34475[(9)] = inst_34427);

(statearr_34475[(10)] = inst_34426__$1);

(statearr_34475[(11)] = inst_34425__$1);

return statearr_34475;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_34476_34512 = state_34439__$1;
(statearr_34476_34512[(1)] = (23));

} else {
var statearr_34477_34513 = state_34439__$1;
(statearr_34477_34513[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (18))){
var inst_34362 = (state_34439[(19)]);
var inst_34363 = (state_34439[(20)]);
var inst_34411 = (state_34439[(2)]);
var inst_34412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34413 = [(0),(2)];
var inst_34414 = (new cljs.core.PersistentVector(null,2,(5),inst_34412,inst_34413,null));
var inst_34415 = fluree.db.query.analytical.get_ns_arrays(inst_34414,inst_34411);
var inst_34416 = fluree.db.query.analytical.tuples__GT_map(inst_34362,inst_34415);
var inst_34417 = (inst_34363 + (1));
var inst_34362__$1 = inst_34416;
var inst_34363__$1 = inst_34417;
var state_34439__$1 = (function (){var statearr_34478 = state_34439;
(statearr_34478[(19)] = inst_34362__$1);

(statearr_34478[(20)] = inst_34363__$1);

return statearr_34478;
})();
var statearr_34479_34514 = state_34439__$1;
(statearr_34479_34514[(2)] = null);

(statearr_34479_34514[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34440 === (8))){
var inst_34360 = (state_34439[(2)]);
var inst_34361 = recur_map;
var inst_34362 = inst_34361;
var inst_34363 = (1);
var state_34439__$1 = (function (){var statearr_34480 = state_34439;
(statearr_34480[(19)] = inst_34362);

(statearr_34480[(8)] = inst_34360);

(statearr_34480[(20)] = inst_34363);

return statearr_34480;
})();
var statearr_34481_34515 = state_34439__$1;
(statearr_34481_34515[(2)] = null);

(statearr_34481_34515[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto____0 = (function (){
var statearr_34482 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34482[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto__);

(statearr_34482[(1)] = (1));

return statearr_34482;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto____1 = (function (state_34439){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_34439);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e34483){var ex__16304__auto__ = e34483;
var statearr_34484_34516 = state_34439;
(statearr_34484_34516[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_34439[(4)]))){
var statearr_34485_34517 = state_34439;
(statearr_34485_34517[(1)] = cljs.core.first((state_34439[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__34518 = state_34439;
state_34439 = G__34518;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto__ = function(state_34439){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto____1.call(this,state_34439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_34486 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_34486[(6)] = c__16375__auto__);

return statearr_34486;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__34519,clause,fuel,max_fuel){
var map__34520 = p__34519;
var map__34520__$1 = (((((!((map__34520 == null))))?(((((map__34520.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34520.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34520):map__34520);
var res = map__34520__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34520__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34520__$1,cljs.core.cst$kw$tuples);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34520__$1,cljs.core.cst$kw$vars);
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_34652){
var state_val_34653 = (state_34652[(1)]);
if((state_val_34653 === (7))){
var state_34652__$1 = state_34652;
var statearr_34654_34720 = state_34652__$1;
(statearr_34654_34720[(2)] = false);

(statearr_34654_34720[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (20))){
var inst_34584 = (state_34652[(7)]);
var state_34652__$1 = state_34652;
var statearr_34655_34721 = state_34652__$1;
(statearr_34655_34721[(2)] = inst_34584);

(statearr_34655_34721[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (27))){
var inst_34588 = (state_34652[(8)]);
var inst_34612 = (state_34652[(2)]);
var state_34652__$1 = (function (){var statearr_34656 = state_34652;
(statearr_34656[(9)] = inst_34612);

return statearr_34656;
})();
if(cljs.core.truth_(inst_34588)){
var statearr_34657_34722 = state_34652__$1;
(statearr_34657_34722[(1)] = (28));

} else {
var statearr_34658_34723 = state_34652__$1;
(statearr_34658_34723[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (1))){
var state_34652__$1 = state_34652;
var statearr_34659_34724 = state_34652__$1;
(statearr_34659_34724[(2)] = null);

(statearr_34659_34724[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (24))){
var inst_34600 = (state_34652[(2)]);
var inst_34601 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_34602 = fluree.db.query.analytical.variable_QMARK_(inst_34601);
var state_34652__$1 = (function (){var statearr_34660 = state_34652;
(statearr_34660[(10)] = inst_34600);

return statearr_34660;
})();
if(cljs.core.truth_(inst_34602)){
var statearr_34661_34725 = state_34652__$1;
(statearr_34661_34725[(1)] = (25));

} else {
var statearr_34662_34726 = state_34652__$1;
(statearr_34662_34726[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (4))){
var inst_34522 = (state_34652[(2)]);
var state_34652__$1 = state_34652;
var statearr_34663_34727 = state_34652__$1;
(statearr_34663_34727[(2)] = inst_34522);

(statearr_34663_34727[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (15))){
var inst_34570 = (state_34652[(11)]);
var state_34652__$1 = state_34652;
var statearr_34664_34728 = state_34652__$1;
(statearr_34664_34728[(2)] = inst_34570);

(statearr_34664_34728[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (21))){
var inst_34555 = (state_34652[(12)]);
var inst_34643 = (state_34652[(2)]);
var inst_34644 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_34645 = cljs.core.keys(inst_34555);
var inst_34646 = [inst_34645,vars,inst_34643];
var inst_34647 = cljs.core.PersistentHashMap.fromArrays(inst_34644,inst_34646);
var _ = (function (){var statearr_34665 = state_34652;
(statearr_34665[(4)] = cljs.core.rest((state_34652[(4)])));

return statearr_34665;
})();
var state_34652__$1 = state_34652;
var statearr_34666_34729 = state_34652__$1;
(statearr_34666_34729[(2)] = inst_34647);

(statearr_34666_34729[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (31))){
var inst_34584 = (state_34652[(7)]);
var inst_34586 = (state_34652[(13)]);
var inst_34619 = cljs.core.PersistentHashMap.EMPTY;
var inst_34620 = cljs.core.flatten(inst_34584);
var inst_34621 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34619,inst_34586,inst_34620);
var state_34652__$1 = state_34652;
var statearr_34667_34730 = state_34652__$1;
(statearr_34667_34730[(2)] = inst_34621);

(statearr_34667_34730[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (32))){
var inst_34586 = (state_34652[(13)]);
var inst_34623 = cljs.core.coll_QMARK_(inst_34586);
var state_34652__$1 = state_34652;
if(inst_34623){
var statearr_34668_34731 = state_34652__$1;
(statearr_34668_34731[(1)] = (34));

} else {
var statearr_34669_34732 = state_34652__$1;
(statearr_34669_34732[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (33))){
var inst_34634 = (state_34652[(2)]);
var state_34652__$1 = state_34652;
var statearr_34670_34733 = state_34652__$1;
(statearr_34670_34733[(2)] = inst_34634);

(statearr_34670_34733[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (13))){
var inst_34532 = (state_34652[(14)]);
var state_34652__$1 = state_34652;
var statearr_34671_34734 = state_34652__$1;
(statearr_34671_34734[(2)] = inst_34532);

(statearr_34671_34734[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (22))){
var inst_34568 = (state_34652[(15)]);
var inst_34592 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34568)].join('');
var inst_34593 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34594 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_34595 = cljs.core.PersistentHashMap.fromArrays(inst_34593,inst_34594);
var inst_34596 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34592,inst_34595);
var inst_34597 = (function(){throw inst_34596})();
var state_34652__$1 = state_34652;
var statearr_34672_34735 = state_34652__$1;
(statearr_34672_34735[(2)] = inst_34597);

(statearr_34672_34735[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (36))){
var inst_34632 = (state_34652[(2)]);
var state_34652__$1 = state_34652;
var statearr_34673_34736 = state_34652__$1;
(statearr_34673_34736[(2)] = inst_34632);

(statearr_34673_34736[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (29))){
var inst_34586 = (state_34652[(13)]);
var inst_34617 = typeof inst_34586 === 'number';
var state_34652__$1 = state_34652;
if(cljs.core.truth_(inst_34617)){
var statearr_34674_34737 = state_34652__$1;
(statearr_34674_34737[(1)] = (31));

} else {
var statearr_34675_34738 = state_34652__$1;
(statearr_34675_34738[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (6))){
var inst_34532 = (state_34652[(14)]);
var inst_34537 = inst_34532.cljs$lang$protocol_mask$partition0$;
var inst_34538 = (inst_34537 & (64));
var inst_34539 = inst_34532.cljs$core$ISeq$;
var inst_34540 = (cljs.core.PROTOCOL_SENTINEL === inst_34539);
var inst_34541 = ((inst_34538) || (inst_34540));
var state_34652__$1 = state_34652;
if(cljs.core.truth_(inst_34541)){
var statearr_34676_34739 = state_34652__$1;
(statearr_34676_34739[(1)] = (9));

} else {
var statearr_34677_34740 = state_34652__$1;
(statearr_34677_34740[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (28))){
var inst_34584 = (state_34652[(7)]);
var inst_34614 = cljs.core.PersistentHashMap.EMPTY;
var inst_34615 = fluree.db.query.analytical.tuples__GT_map(inst_34614,inst_34584);
var state_34652__$1 = state_34652;
var statearr_34678_34741 = state_34652__$1;
(statearr_34678_34741[(2)] = inst_34615);

(statearr_34678_34741[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (25))){
var state_34652__$1 = state_34652;
var statearr_34679_34742 = state_34652__$1;
(statearr_34679_34742[(2)] = null);

(statearr_34679_34742[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (34))){
var inst_34584 = (state_34652[(7)]);
var inst_34580 = (state_34652[(16)]);
var inst_34625 = cljs.core.PersistentHashMap.EMPTY;
var inst_34626 = cljs.core.first(inst_34580);
var inst_34627 = cljs.core.first(inst_34626);
var inst_34628 = cljs.core.flatten(inst_34584);
var inst_34629 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34625,inst_34627,inst_34628);
var state_34652__$1 = state_34652;
var statearr_34680_34743 = state_34652__$1;
(statearr_34680_34743[(2)] = inst_34629);

(statearr_34680_34743[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (17))){
var inst_34569 = (state_34652[(17)]);
var inst_34568 = (state_34652[(15)]);
var inst_34574 = (state_34652[(2)]);
var inst_34575 = [inst_34574];
var inst_34576 = cljs.core.PersistentHashMap.fromArrays(inst_34569,inst_34575);
var inst_34577 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_34568,inst_34576);
var state_34652__$1 = state_34652;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34652__$1,(18),inst_34577);
} else {
if((state_val_34653 === (3))){
var inst_34650 = (state_34652[(2)]);
var state_34652__$1 = state_34652;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34652__$1,inst_34650);
} else {
if((state_val_34653 === (12))){
var inst_34532 = (state_34652[(14)]);
var inst_34550 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_34532);
var state_34652__$1 = state_34652;
var statearr_34681_34744 = state_34652__$1;
(statearr_34681_34744[(2)] = inst_34550);

(statearr_34681_34744[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (2))){
var inst_34532 = (state_34652[(14)]);
var _ = (function (){var statearr_34682 = state_34652;
(statearr_34682[(4)] = cljs.core.cons((5),(state_34652[(4)])));

return statearr_34682;
})();
var inst_34532__$1 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_34534 = (inst_34532__$1 == null);
var inst_34535 = cljs.core.not(inst_34534);
var state_34652__$1 = (function (){var statearr_34683 = state_34652;
(statearr_34683[(14)] = inst_34532__$1);

return statearr_34683;
})();
if(inst_34535){
var statearr_34684_34745 = state_34652__$1;
(statearr_34684_34745[(1)] = (6));

} else {
var statearr_34685_34746 = state_34652__$1;
(statearr_34685_34746[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (23))){
var state_34652__$1 = state_34652;
var statearr_34686_34747 = state_34652__$1;
(statearr_34686_34747[(2)] = null);

(statearr_34686_34747[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (35))){
var state_34652__$1 = state_34652;
var statearr_34687_34748 = state_34652__$1;
(statearr_34687_34748[(2)] = null);

(statearr_34687_34748[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (19))){
var inst_34589 = (state_34652[(18)]);
var inst_34568 = (state_34652[(15)]);
var inst_34586 = cljs.core.first(inst_34568);
var inst_34587 = cljs.core.first(clause);
var inst_34588 = fluree.db.query.analytical.variable_QMARK_(inst_34587);
var inst_34589__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_34568,(1));
var inst_34590 = fluree.db.query.analytical.variable_QMARK_(inst_34589__$1);
var state_34652__$1 = (function (){var statearr_34688 = state_34652;
(statearr_34688[(8)] = inst_34588);

(statearr_34688[(18)] = inst_34589__$1);

(statearr_34688[(13)] = inst_34586);

return statearr_34688;
})();
if(cljs.core.truth_(inst_34590)){
var statearr_34689_34749 = state_34652__$1;
(statearr_34689_34749[(1)] = (22));

} else {
var statearr_34690_34750 = state_34652__$1;
(statearr_34690_34750[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (11))){
var inst_34545 = (state_34652[(2)]);
var state_34652__$1 = state_34652;
var statearr_34692_34751 = state_34652__$1;
(statearr_34692_34751[(2)] = inst_34545);

(statearr_34692_34751[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (9))){
var state_34652__$1 = state_34652;
var statearr_34693_34752 = state_34652__$1;
(statearr_34693_34752[(2)] = true);

(statearr_34693_34752[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (5))){
var _ = (function (){var statearr_34694 = state_34652;
(statearr_34694[(4)] = cljs.core.rest((state_34652[(4)])));

return statearr_34694;
})();
var state_34652__$1 = state_34652;
var ex34691 = (state_34652__$1[(2)]);
var statearr_34695_34753 = state_34652__$1;
(statearr_34695_34753[(5)] = ex34691);


if((ex34691 instanceof Error)){
var statearr_34696_34754 = state_34652__$1;
(statearr_34696_34754[(1)] = (4));

(statearr_34696_34754[(5)] = null);

} else {
throw ex34691;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (14))){
var inst_34558 = (state_34652[(19)]);
var inst_34570 = (state_34652[(11)]);
var inst_34559 = (state_34652[(20)]);
var inst_34555 = (state_34652[(12)]);
var inst_34553 = (state_34652[(2)]);
var inst_34554 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34553,cljs.core.cst$kw$search);
var inst_34555__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34553,cljs.core.cst$kw$rel);
var inst_34556 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34553,cljs.core.cst$kw$opts);
var inst_34557 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_34558__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_34556);
var inst_34559__$1 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_34556);
var inst_34561 = (function (){var map__34528 = inst_34553;
var search = inst_34554;
var rel = inst_34555__$1;
var opts = inst_34556;
var common_keys = inst_34557;
var object_fn = inst_34558__$1;
var recur_depth = inst_34559__$1;
return (function (p__34560,common_key){
var vec__34697 = p__34560;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34697,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34697,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__34700 = cljs.core._EQ_;
var expr__34701 = idx_of;
if(cljs.core.truth_((pred__34700.cljs$core$IFn$_invoke$arity$2 ? pred__34700.cljs$core$IFn$_invoke$arity$2((0),expr__34701) : pred__34700.call(null,(0),expr__34701)))){
return cljs.core.cst$kw$subject_DASH_fn;
} else {
if(cljs.core.truth_((pred__34700.cljs$core$IFn$_invoke$arity$2 ? pred__34700.cljs$core$IFn$_invoke$arity$2((1),expr__34701) : pred__34700.call(null,(1),expr__34701)))){
return cljs.core.cst$kw$predicate_DASH_fn;
} else {
if(cljs.core.truth_((pred__34700.cljs$core$IFn$_invoke$arity$2 ? pred__34700.cljs$core$IFn$_invoke$arity$2((2),expr__34701) : pred__34700.call(null,(2),expr__34701)))){
return cljs.core.cst$kw$object_DASH_fn;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__34701)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((((!(single_v_QMARK_)))?(function (){var and__4115__auto__ = object_fn;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4115__auto__;
}
})():false))?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_34562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34563 = cljs.core.PersistentHashMap.EMPTY;
var inst_34564 = [inst_34563,inst_34554];
var inst_34565 = (new cljs.core.PersistentVector(null,2,(5),inst_34562,inst_34564,null));
var inst_34566 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_34561,inst_34565,inst_34557);
var inst_34567 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34566,(0),null);
var inst_34568 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34566,(1),null);
var inst_34569 = [cljs.core.cst$kw$object_DASH_fn];
var inst_34570__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_34567);
var state_34652__$1 = (function (){var statearr_34703 = state_34652;
(statearr_34703[(19)] = inst_34558__$1);

(statearr_34703[(11)] = inst_34570__$1);

(statearr_34703[(20)] = inst_34559__$1);

(statearr_34703[(12)] = inst_34555__$1);

(statearr_34703[(17)] = inst_34569);

(statearr_34703[(15)] = inst_34568);

return statearr_34703;
})();
if(cljs.core.truth_(inst_34570__$1)){
var statearr_34704_34755 = state_34652__$1;
(statearr_34704_34755[(1)] = (15));

} else {
var statearr_34705_34756 = state_34652__$1;
(statearr_34705_34756[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (26))){
var inst_34568 = (state_34652[(15)]);
var inst_34605 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34568)].join('');
var inst_34606 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34607 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_34608 = cljs.core.PersistentHashMap.fromArrays(inst_34606,inst_34607);
var inst_34609 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34605,inst_34608);
var inst_34610 = (function(){throw inst_34609})();
var state_34652__$1 = state_34652;
var statearr_34706_34757 = state_34652__$1;
(statearr_34706_34757[(2)] = inst_34610);

(statearr_34706_34757[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (16))){
var inst_34558 = (state_34652[(19)]);
var state_34652__$1 = state_34652;
var statearr_34707_34758 = state_34652__$1;
(statearr_34707_34758[(2)] = inst_34558);

(statearr_34707_34758[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (30))){
var inst_34588 = (state_34652[(8)]);
var inst_34589 = (state_34652[(18)]);
var inst_34559 = (state_34652[(20)]);
var inst_34636 = (state_34652[(2)]);
var inst_34637 = fluree.db.query.analytical.tuples__GT_recur(db,inst_34589,inst_34636,inst_34559,inst_34588);
var state_34652__$1 = state_34652;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34652__$1,(37),inst_34637);
} else {
if((state_val_34653 === (10))){
var state_34652__$1 = state_34652;
var statearr_34708_34759 = state_34652__$1;
(statearr_34708_34759[(2)] = false);

(statearr_34708_34759[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (18))){
var inst_34559 = (state_34652[(20)]);
var inst_34555 = (state_34652[(12)]);
var inst_34580 = (state_34652[(16)]);
var inst_34579 = (state_34652[(2)]);
var inst_34580__$1 = fluree.db.util.async.throw_err(inst_34579);
var inst_34581 = cljs.core.count(inst_34580__$1);
var inst_34582 = fluree.db.query.analytical.add_fuel(inst_34581,fuel,max_fuel);
var inst_34583 = cljs.core.vals(inst_34555);
var inst_34584 = fluree.db.query.analytical.get_ns_arrays(inst_34583,inst_34580__$1);
var state_34652__$1 = (function (){var statearr_34709 = state_34652;
(statearr_34709[(7)] = inst_34584);

(statearr_34709[(16)] = inst_34580__$1);

(statearr_34709[(21)] = inst_34582);

return statearr_34709;
})();
if(cljs.core.truth_(inst_34559)){
var statearr_34710_34760 = state_34652__$1;
(statearr_34710_34760[(1)] = (19));

} else {
var statearr_34711_34761 = state_34652__$1;
(statearr_34711_34761[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (37))){
var inst_34639 = (state_34652[(2)]);
var inst_34640 = fluree.db.util.async.throw_err(inst_34639);
var state_34652__$1 = state_34652;
var statearr_34712_34762 = state_34652__$1;
(statearr_34712_34762[(2)] = inst_34640);

(statearr_34712_34762[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34653 === (8))){
var inst_34548 = (state_34652[(2)]);
var state_34652__$1 = state_34652;
if(cljs.core.truth_(inst_34548)){
var statearr_34713_34763 = state_34652__$1;
(statearr_34713_34763[(1)] = (12));

} else {
var statearr_34714_34764 = state_34652__$1;
(statearr_34714_34764[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_34715 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34715[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto__);

(statearr_34715[(1)] = (1));

return statearr_34715;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto____1 = (function (state_34652){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_34652);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e34716){var ex__16304__auto__ = e34716;
var statearr_34717_34765 = state_34652;
(statearr_34717_34765[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_34652[(4)]))){
var statearr_34718_34766 = state_34652;
(statearr_34718_34766[(1)] = cljs.core.first((state_34652[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__34767 = state_34652;
state_34652 = G__34767;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto__ = function(state_34652){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto____1.call(this,state_34652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_34719 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_34719[(6)] = c__16375__auto__);

return statearr_34719;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__34768,res,clause){
var map__34769 = p__34768;
var map__34769__$1 = (((((!((map__34769 == null))))?(((((map__34769.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34769.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34769):map__34769);
var db = map__34769__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34769__$1,cljs.core.cst$kw$conn);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34769__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34769__$1,cljs.core.cst$kw$dbid);
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_34869){
var state_val_34870 = (state_34869[(1)]);
if((state_val_34870 === (7))){
var inst_34780 = (state_34869[(7)]);
var state_34869__$1 = state_34869;
var statearr_34871_34911 = state_34869__$1;
(statearr_34871_34911[(2)] = inst_34780);

(statearr_34871_34911[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (20))){
var inst_34860 = (state_34869[(2)]);
var state_34869__$1 = state_34869;
var statearr_34872_34912 = state_34869__$1;
(statearr_34872_34912[(2)] = inst_34860);

(statearr_34872_34912[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (1))){
var state_34869__$1 = state_34869;
var statearr_34873_34913 = state_34869__$1;
(statearr_34873_34913[(2)] = null);

(statearr_34873_34913[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (24))){
var inst_34839 = (state_34869[(2)]);
var inst_34840 = fluree.db.util.async.throw_err(inst_34839);
var state_34869__$1 = state_34869;
var statearr_34874_34914 = state_34869__$1;
(statearr_34874_34914[(2)] = inst_34840);

(statearr_34874_34914[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (4))){
var inst_34773 = (state_34869[(2)]);
var state_34869__$1 = state_34869;
var statearr_34875_34915 = state_34869__$1;
(statearr_34875_34915[(2)] = inst_34773);

(statearr_34875_34915[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (15))){
var inst_34780 = (state_34869[(7)]);
var inst_34782 = (state_34869[(8)]);
var inst_34801 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_34802 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_34803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34804 = [inst_34780];
var inst_34805 = (new cljs.core.PersistentVector(null,1,(5),inst_34803,inst_34804,null));
var inst_34806 = (function (){var subject_var = inst_34780;
var object_var = inst_34782;
var min_sid = inst_34801;
var max_sid = (0);
return (function (p1__34771_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__34771_SHARP_);
});
})();
var inst_34807 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_34801,(0));
var inst_34808 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34806,inst_34807);
var inst_34809 = cljs.core.PersistentHashMap.EMPTY;
var inst_34810 = [inst_34805,inst_34808,inst_34809];
var inst_34811 = cljs.core.PersistentHashMap.fromArrays(inst_34802,inst_34810);
var state_34869__$1 = state_34869;
var statearr_34876_34916 = state_34869__$1;
(statearr_34876_34916[(2)] = inst_34811);

(statearr_34876_34916[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (21))){
var inst_34833 = (state_34869[(9)]);
var state_34869__$1 = state_34869;
var statearr_34877_34917 = state_34869__$1;
(statearr_34877_34917[(2)] = inst_34833);

(statearr_34877_34917[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (13))){
var inst_34782 = (state_34869[(8)]);
var state_34869__$1 = state_34869;
if(cljs.core.truth_(inst_34782)){
var statearr_34878_34918 = state_34869__$1;
(statearr_34878_34918[(1)] = (18));

} else {
var statearr_34879_34919 = state_34869__$1;
(statearr_34879_34919[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (22))){
var inst_34833 = (state_34869[(9)]);
var inst_34837 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_34833);
var state_34869__$1 = state_34869;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34869__$1,(24),inst_34837);
} else {
if((state_val_34870 === (6))){
var inst_34782 = (state_34869[(8)]);
var state_34869__$1 = state_34869;
var statearr_34880_34920 = state_34869__$1;
(statearr_34880_34920[(2)] = inst_34782);

(statearr_34880_34920[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (17))){
var inst_34830 = (state_34869[(2)]);
var state_34869__$1 = state_34869;
var statearr_34881_34921 = state_34869__$1;
(statearr_34881_34921[(2)] = inst_34830);

(statearr_34881_34921[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (3))){
var inst_34867 = (state_34869[(2)]);
var state_34869__$1 = state_34869;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34869__$1,inst_34867);
} else {
if((state_val_34870 === (12))){
var inst_34795 = ["_tx",null,"_block",null];
var inst_34796 = (new cljs.core.PersistentArrayMap(null,2,inst_34795,null));
var inst_34797 = (new cljs.core.PersistentHashSet(null,inst_34796,null));
var inst_34798 = cljs.core.last(clause);
var inst_34799 = (inst_34797.cljs$core$IFn$_invoke$arity$1 ? inst_34797.cljs$core$IFn$_invoke$arity$1(inst_34798) : inst_34797.call(null,inst_34798));
var state_34869__$1 = state_34869;
if(cljs.core.truth_(inst_34799)){
var statearr_34882_34922 = state_34869__$1;
(statearr_34882_34922[(1)] = (15));

} else {
var statearr_34883_34923 = state_34869__$1;
(statearr_34883_34923[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (2))){
var inst_34780 = (state_34869[(7)]);
var _ = (function (){var statearr_34884 = state_34869;
(statearr_34884[(4)] = cljs.core.cons((5),(state_34869[(4)])));

return statearr_34884;
})();
var inst_34779 = cljs.core.first(clause);
var inst_34780__$1 = fluree.db.query.analytical.variable_QMARK_(inst_34779);
var inst_34781 = cljs.core.last(clause);
var inst_34782 = fluree.db.query.analytical.variable_QMARK_(inst_34781);
var state_34869__$1 = (function (){var statearr_34885 = state_34869;
(statearr_34885[(7)] = inst_34780__$1);

(statearr_34885[(8)] = inst_34782);

return statearr_34885;
})();
if(cljs.core.truth_(inst_34780__$1)){
var statearr_34886_34924 = state_34869__$1;
(statearr_34886_34924[(1)] = (6));

} else {
var statearr_34887_34925 = state_34869__$1;
(statearr_34887_34925[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (23))){
var inst_34782 = (state_34869[(8)]);
var inst_34842 = (state_34869[(2)]);
var inst_34843 = fluree.db.flake.sid__GT_cid(inst_34842);
var inst_34844 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$name,inst_34843);
var inst_34845 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_34846 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34847 = [inst_34782];
var inst_34848 = (new cljs.core.PersistentVector(null,1,(5),inst_34846,inst_34847,null));
var inst_34849 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34850 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34851 = [inst_34844];
var inst_34852 = (new cljs.core.PersistentVector(null,1,(5),inst_34850,inst_34851,null));
var inst_34853 = [inst_34852];
var inst_34854 = (new cljs.core.PersistentVector(null,1,(5),inst_34849,inst_34853,null));
var inst_34855 = cljs.core.PersistentHashMap.EMPTY;
var inst_34856 = [inst_34848,inst_34854,inst_34855];
var inst_34857 = cljs.core.PersistentHashMap.fromArrays(inst_34845,inst_34856);
var state_34869__$1 = state_34869;
var statearr_34888_34926 = state_34869__$1;
(statearr_34888_34926[(2)] = inst_34857);

(statearr_34888_34926[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (19))){
var state_34869__$1 = state_34869;
var statearr_34889_34927 = state_34869__$1;
(statearr_34889_34927[(2)] = null);

(statearr_34889_34927[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (11))){
var inst_34864 = (state_34869[(2)]);
var _ = (function (){var statearr_34891 = state_34869;
(statearr_34891[(4)] = cljs.core.rest((state_34869[(4)])));

return statearr_34891;
})();
var state_34869__$1 = state_34869;
var statearr_34892_34928 = state_34869__$1;
(statearr_34892_34928[(2)] = inst_34864);

(statearr_34892_34928[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (9))){
var inst_34788 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34789 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_34790 = cljs.core.PersistentHashMap.fromArrays(inst_34788,inst_34789);
var inst_34791 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_34790);
var inst_34792 = (function(){throw inst_34791})();
var state_34869__$1 = state_34869;
var statearr_34893_34929 = state_34869__$1;
(statearr_34893_34929[(2)] = inst_34792);

(statearr_34893_34929[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (5))){
var _ = (function (){var statearr_34894 = state_34869;
(statearr_34894[(4)] = cljs.core.rest((state_34869[(4)])));

return statearr_34894;
})();
var state_34869__$1 = state_34869;
var ex34890 = (state_34869__$1[(2)]);
var statearr_34895_34930 = state_34869__$1;
(statearr_34895_34930[(5)] = ex34890);


if((ex34890 instanceof Error)){
var statearr_34896_34931 = state_34869__$1;
(statearr_34896_34931[(1)] = (4));

(statearr_34896_34931[(5)] = null);

} else {
throw ex34890;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (14))){
var inst_34862 = (state_34869[(2)]);
var state_34869__$1 = state_34869;
var statearr_34897_34932 = state_34869__$1;
(statearr_34897_34932[(2)] = inst_34862);

(statearr_34897_34932[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (16))){
var inst_34780 = (state_34869[(7)]);
var inst_34782 = (state_34869[(8)]);
var inst_34813 = cljs.core.last(clause);
var inst_34814 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,inst_34813);
var inst_34815 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_34816 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34815,inst_34814);
var inst_34817 = fluree.db.flake.min_subject_id(inst_34814);
var inst_34818 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_34819 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34820 = [inst_34780];
var inst_34821 = (new cljs.core.PersistentVector(null,1,(5),inst_34819,inst_34820,null));
var inst_34822 = (function (){var subject_var = inst_34780;
var object_var = inst_34782;
var cid = inst_34814;
var max_sid = inst_34816;
var min_sid = inst_34817;
return (function (p1__34772_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__34772_SHARP_);
});
})();
var inst_34823 = (inst_34816 + (1));
var inst_34824 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_34817,inst_34823);
var inst_34825 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34822,inst_34824);
var inst_34826 = cljs.core.PersistentHashMap.EMPTY;
var inst_34827 = [inst_34821,inst_34825,inst_34826];
var inst_34828 = cljs.core.PersistentHashMap.fromArrays(inst_34818,inst_34827);
var state_34869__$1 = state_34869;
var statearr_34898_34933 = state_34869__$1;
(statearr_34898_34933[(2)] = inst_34828);

(statearr_34898_34933[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (10))){
var inst_34780 = (state_34869[(7)]);
var state_34869__$1 = state_34869;
if(cljs.core.truth_(inst_34780)){
var statearr_34899_34934 = state_34869__$1;
(statearr_34899_34934[(1)] = (12));

} else {
var statearr_34900_34935 = state_34869__$1;
(statearr_34900_34935[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (18))){
var inst_34833 = (state_34869[(9)]);
var inst_34833__$1 = cljs.core.first(clause);
var inst_34834 = typeof inst_34833__$1 === 'number';
var state_34869__$1 = (function (){var statearr_34901 = state_34869;
(statearr_34901[(9)] = inst_34833__$1);

return statearr_34901;
})();
if(cljs.core.truth_(inst_34834)){
var statearr_34902_34936 = state_34869__$1;
(statearr_34902_34936[(1)] = (21));

} else {
var statearr_34903_34937 = state_34869__$1;
(statearr_34903_34937[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34870 === (8))){
var inst_34786 = (state_34869[(2)]);
var state_34869__$1 = state_34869;
if(cljs.core.truth_(inst_34786)){
var statearr_34904_34938 = state_34869__$1;
(statearr_34904_34938[(1)] = (9));

} else {
var statearr_34905_34939 = state_34869__$1;
(statearr_34905_34939[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_34906 = [null,null,null,null,null,null,null,null,null,null];
(statearr_34906[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto__);

(statearr_34906[(1)] = (1));

return statearr_34906;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto____1 = (function (state_34869){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_34869);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e34907){var ex__16304__auto__ = e34907;
var statearr_34908_34940 = state_34869;
(statearr_34908_34940[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_34869[(4)]))){
var statearr_34909_34941 = state_34869;
(statearr_34909_34941[(1)] = cljs.core.first((state_34869[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__34942 = state_34869;
state_34869 = G__34942;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto__ = function(state_34869){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto____1.call(this,state_34869);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_34910 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_34910[(6)] = c__16375__auto__);

return statearr_34910;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__34949 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__34949 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__34949;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4529__auto__ = (function fluree$db$query$analytical$variance_$_iter__34950(s__34951){
return (new cljs.core.LazySeq(null,(function (){
var s__34951__$1 = s__34951;
while(true){
var temp__5735__auto__ = cljs.core.seq(s__34951__$1);
if(temp__5735__auto__){
var s__34951__$2 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(s__34951__$2)){
var c__4527__auto__ = cljs.core.chunk_first(s__34951__$2);
var size__4528__auto__ = cljs.core.count(c__4527__auto__);
var b__34953 = cljs.core.chunk_buffer(size__4528__auto__);
if((function (){var i__34952 = (0);
while(true){
if((i__34952 < size__4528__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4527__auto__,i__34952);
var delta = (x - mean);
cljs.core.chunk_append(b__34953,(delta * delta));

var G__34955 = (i__34952 + (1));
i__34952 = G__34955;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__34953),fluree$db$query$analytical$variance_$_iter__34950(cljs.core.chunk_rest(s__34951__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__34953),null);
}
} else {
var x = cljs.core.first(s__34951__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__34950(cljs.core.rest(s__34951__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4529__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__34954 = variance(coll);
return Math.sqrt(G__34954);
});
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$variance,cljs.core.cst$sym$count,cljs.core.cst$sym$median,cljs.core.cst$sym$groupconcat,cljs.core.cst$sym$sum,cljs.core.cst$sym$abs,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$max,cljs.core.cst$sym$count_DASH_distinct,cljs.core.cst$sym$avg,cljs.core.cst$sym$floor,cljs.core.cst$sym$str,cljs.core.cst$sym$stddev,cljs.core.cst$sym$rand,cljs.core.cst$sym$sample],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4214__auto__ = n;
var y__4215__auto__ = (- n);
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
}),(function() {
var G__34956 = null;
var G__34956__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__34956__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__34956 = function(n,coll){
switch(arguments.length){
case 1:
return G__34956__1.call(this,n);
case 2:
return G__34956__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34956.cljs$core$IFn$_invoke$arity$1 = G__34956__1;
G__34956.cljs$core$IFn$_invoke$arity$2 = G__34956__2;
return G__34956;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__34957 = null;
var G__34957__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__34957__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__34957 = function(n,coll){
switch(arguments.length){
case 1:
return G__34957__1.call(this,n);
case 2:
return G__34957__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34957.cljs$core$IFn$_invoke$arity$1 = G__34957__1;
G__34957.cljs$core$IFn$_invoke$arity$2 = G__34957__2;
return G__34957;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__34958 = null;
var G__34958__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__34958__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__34958 = function(n,coll){
switch(arguments.length){
case 1:
return G__34958__1.call(this,n);
case 2:
return G__34958__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34958.cljs$core$IFn$_invoke$arity$1 = G__34958__1;
G__34958.cljs$core$IFn$_invoke$arity$2 = G__34958__2;
return G__34958;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
if(typeof x === 'string'){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return false;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$as,cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__34959 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$sample,cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34959,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34959,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34959,(2),null);
var agg_fn = (function (){var temp__5733__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5733__auto__)){
var agg_fn = temp__5733__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__34962 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),cljs.core.cst$sym$distinct)));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__34965 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__34965) : agg_fn.call(null,G__34965));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34962,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34962,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$variable,variable,cljs.core.cst$kw$as,as,cljs.core.cst$kw$code,agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__34966 = agg;
var map__34966__$1 = (((((!((map__34966 == null))))?(((((map__34966.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34966.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34966):map__34966);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34966__$1,cljs.core.cst$kw$variable);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34966__$1,cljs.core.cst$kw$as);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34966__$1,cljs.core.cst$kw$code);
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__34969 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34969,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34969,(1),null);
var map__34972 = res__$1;
var map__34972__$1 = (((((!((map__34972 == null))))?(((((map__34972.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34972.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34972):map__34972);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34972__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34972__$1,cljs.core.cst$kw$tuples);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34968_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__34968_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers_SINGLEQUOTE_,cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 */
fluree.db.query.analytical.find_match = (function fluree$db$query$analytical$find_match(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34974_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__34974_SHARP_);
}),a_idxs);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,b_tuple){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34975_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__34975_SHARP_);
}),b_idxs))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34976_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__34976_SHARP_);
}),b_not_idxs)));
} else {
return acc;
}
}),null,b_tuples);
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34977_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__34977_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__34980,row,b_tuple){
var vec__34981 = p__34980;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34981,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34981,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34978_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__34978_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4126__auto__ = acc;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34979_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__34979_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34984_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),p1__34984_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34985_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__34985_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__34990 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__34992 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__34991 = (function (p1__34986_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__34986_SHARP_);
});
return fexpr__34991(G__34992);
})()),cljs.core.set(b_idxs));
var fexpr__34989 = (function (p1__34987_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__34987_SHARP_);
});
return fexpr__34989(G__34990);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (a_tuple){
return fluree.db.query.analytical.find_match(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_res),b_idxs,b_not_idxs);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_res)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34988_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__34988_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_res)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34993_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__34993_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34994_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34994_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__34999 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__35001 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__35000 = (function (p1__34995_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__34995_SHARP_);
});
return fexpr__35000(G__35001);
})()),cljs.core.set(b_idxs));
var fexpr__34998 = (function (p1__34996_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__34996_SHARP_);
});
return fexpr__34998(G__34999);
})();
var c_tuples = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (a_tuple){
var matches = fluree.db.query.analytical.find_match(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples)));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__34997_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__34997_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * UNION clause takes a left-hand side, which is inner-joined, and a right-hand side, which is inner-joined.
 *   Any tuples unbound by the other set are included.
 */
fluree.db.query.analytical.outer_union = (function fluree$db$query$analytical$outer_union(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35002_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__35002_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35003_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__35003_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__35012 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__35014 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__35013 = (function (p1__35004_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__35004_SHARP_);
});
return fexpr__35013(G__35014);
})()),cljs.core.set(b_idxs));
var fexpr__35011 = (function (p1__35005_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__35005_SHARP_);
});
return fexpr__35011(G__35012);
})();
var vec__35008 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p__35015,a_tuple){
var vec__35016 = p__35015;
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35016,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35016,(1),null);
var vec__35019 = fluree.db.query.analytical.find_match_PLUS_row_nums(a_tuple,a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_idxs,b_not_idxs);
var matches = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35019,(0),null);
var matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35019,(1),null);
var matches__$1 = (function (){var or__4126__auto__ = matches;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null))], null);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,matches__$1),clojure.set.union.cljs$core$IFn$_invoke$arity$2(b_matched_rows,matched_rows)], null);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples));
var c_tuples = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35008,(0),null);
var b_matched_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35008,(1),null);
var b_unmatched_rows = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(b_matched_rows,cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),cljs.core.count(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples))));
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35006_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__35006_SHARP_);
}),b_not_idxs));
var b_idxs__GT_c_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35007_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__35007_SHARP_);
}),c_headers);
var c_from_unmatched_b_tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (b_row){
var b_tuple = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_row));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (c_idx){
if((c_idx == null)){
return null;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_tuple,c_idx);
}
}),b_idxs__GT_c_idxs);
}),b_unmatched_rows);
var c_tuples__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(c_tuples,c_from_unmatched_b_tuples);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples__$1], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__35023 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35023,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35023,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__35022_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__35022_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__35028 = (function (){var or__4126__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35028,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35028,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35026_SHARP_){
return fluree.db.util.core.index_of(headers,p1__35026_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__35027_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__35027_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__35031,filters,optional_QMARK_){
var map__35032 = p__35031;
var map__35032__$1 = (((((!((map__35032 == null))))?(((((map__35032.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35032.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35032):map__35032);
var tuple_map = map__35032__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35032__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35032__$1,cljs.core.cst$kw$vars);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35032__$1,cljs.core.cst$kw$tuples);
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__35034 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35034,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35034,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var map__35037 = res;
var map__35037__$1 = (((((!((map__35037 == null))))?(((((map__35037.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35037.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35037):map__35037);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35037__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35037__$1,cljs.core.cst$kw$vars);
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5733__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5733__auto__)){
var valid_var = temp__5733__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_35094){
var state_val_35095 = (state_35094[(1)]);
if((state_val_35095 === (7))){
var inst_35068 = (state_35094[(7)]);
var inst_35066 = (state_35094[(2)]);
var inst_35067 = fluree.db.util.async.throw_err(inst_35066);
var inst_35068__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35067,(0),null);
var inst_35069 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35067,(1),null);
var inst_35070 = (inst_35068__$1 == null);
var state_35094__$1 = (function (){var statearr_35096 = state_35094;
(statearr_35096[(7)] = inst_35068__$1);

(statearr_35096[(8)] = inst_35069);

return statearr_35096;
})();
if(cljs.core.truth_(inst_35070)){
var statearr_35097_35126 = state_35094__$1;
(statearr_35097_35126[(1)] = (8));

} else {
var statearr_35098_35127 = state_35094__$1;
(statearr_35098_35127[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35095 === (1))){
var inst_35046 = optional_clauses;
var inst_35047 = cljs.core.seq(inst_35046);
var inst_35048 = cljs.core.first(inst_35047);
var inst_35049 = cljs.core.next(inst_35047);
var inst_35050 = where_tuples;
var inst_35051 = inst_35046;
var inst_35052 = inst_35050;
var state_35094__$1 = (function (){var statearr_35099 = state_35094;
(statearr_35099[(9)] = inst_35052);

(statearr_35099[(10)] = inst_35051);

(statearr_35099[(11)] = inst_35048);

(statearr_35099[(12)] = inst_35049);

return statearr_35099;
})();
var statearr_35100_35128 = state_35094__$1;
(statearr_35100_35128[(2)] = null);

(statearr_35100_35128[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35095 === (4))){
var inst_35052 = (state_35094[(9)]);
var inst_35058 = (state_35094[(13)]);
var inst_35059 = (state_35094[(14)]);
var inst_35064 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_35052,inst_35058,inst_35059,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_35052,inst_35058,inst_35059,true,fuel,max_fuel,opts));
var state_35094__$1 = state_35094;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35094__$1,(7),inst_35064);
} else {
if((state_val_35095 === (15))){
var state_35094__$1 = state_35094;
var statearr_35101_35129 = state_35094__$1;
(statearr_35101_35129[(2)] = null);

(statearr_35101_35129[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35095 === (13))){
var inst_35085 = (state_35094[(2)]);
var state_35094__$1 = state_35094;
var statearr_35102_35130 = state_35094__$1;
(statearr_35102_35130[(2)] = inst_35085);

(statearr_35102_35130[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35095 === (6))){
var inst_35090 = (state_35094[(2)]);
var state_35094__$1 = state_35094;
var statearr_35103_35131 = state_35094__$1;
(statearr_35103_35131[(2)] = inst_35090);

(statearr_35103_35131[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35095 === (3))){
var inst_35092 = (state_35094[(2)]);
var state_35094__$1 = state_35094;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35094__$1,inst_35092);
} else {
if((state_val_35095 === (12))){
var state_35094__$1 = state_35094;
var statearr_35104_35132 = state_35094__$1;
(statearr_35104_35132[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35095 === (2))){
var inst_35058 = (state_35094[(13)]);
var inst_35051 = (state_35094[(10)]);
var inst_35057 = cljs.core.seq(inst_35051);
var inst_35058__$1 = cljs.core.first(inst_35057);
var inst_35059 = cljs.core.next(inst_35057);
var state_35094__$1 = (function (){var statearr_35106 = state_35094;
(statearr_35106[(13)] = inst_35058__$1);

(statearr_35106[(14)] = inst_35059);

return statearr_35106;
})();
if(cljs.core.truth_(inst_35058__$1)){
var statearr_35107_35133 = state_35094__$1;
(statearr_35107_35133[(1)] = (4));

} else {
var statearr_35108_35134 = state_35094__$1;
(statearr_35108_35134[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35095 === (11))){
var inst_35068 = (state_35094[(7)]);
var inst_35069 = (state_35094[(8)]);
var inst_35051 = inst_35069;
var inst_35052 = inst_35068;
var state_35094__$1 = (function (){var statearr_35109 = state_35094;
(statearr_35109[(9)] = inst_35052);

(statearr_35109[(10)] = inst_35051);

return statearr_35109;
})();
var statearr_35110_35135 = state_35094__$1;
(statearr_35110_35135[(2)] = null);

(statearr_35110_35135[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35095 === (9))){
var inst_35058 = (state_35094[(13)]);
var inst_35074 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(inst_35058);
var state_35094__$1 = state_35094;
if(cljs.core.truth_(inst_35074)){
var statearr_35111_35136 = state_35094__$1;
(statearr_35111_35136[(1)] = (11));

} else {
var statearr_35112_35137 = state_35094__$1;
(statearr_35112_35137[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35095 === (5))){
var inst_35052 = (state_35094[(9)]);
var state_35094__$1 = state_35094;
var statearr_35113_35138 = state_35094__$1;
(statearr_35113_35138[(2)] = inst_35052);

(statearr_35113_35138[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35095 === (14))){
var inst_35052 = (state_35094[(9)]);
var inst_35068 = (state_35094[(7)]);
var inst_35069 = (state_35094[(8)]);
var inst_35079 = fluree.db.query.analytical.left_outer_join(inst_35052,inst_35068);
var inst_35051 = inst_35069;
var inst_35052__$1 = inst_35079;
var state_35094__$1 = (function (){var statearr_35114 = state_35094;
(statearr_35114[(9)] = inst_35052__$1);

(statearr_35114[(10)] = inst_35051);

return statearr_35114;
})();
var statearr_35115_35139 = state_35094__$1;
(statearr_35115_35139[(2)] = null);

(statearr_35115_35139[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35095 === (16))){
var inst_35083 = (state_35094[(2)]);
var state_35094__$1 = state_35094;
var statearr_35117_35140 = state_35094__$1;
(statearr_35117_35140[(2)] = inst_35083);

(statearr_35117_35140[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35095 === (10))){
var inst_35087 = (state_35094[(2)]);
var state_35094__$1 = state_35094;
var statearr_35118_35141 = state_35094__$1;
(statearr_35118_35141[(2)] = inst_35087);

(statearr_35118_35141[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35095 === (8))){
var inst_35052 = (state_35094[(9)]);
var inst_35069 = (state_35094[(8)]);
var tmp35116 = inst_35052;
var inst_35051 = inst_35069;
var inst_35052__$1 = tmp35116;
var state_35094__$1 = (function (){var statearr_35119 = state_35094;
(statearr_35119[(9)] = inst_35052__$1);

(statearr_35119[(10)] = inst_35051);

return statearr_35119;
})();
var statearr_35120_35142 = state_35094__$1;
(statearr_35120_35142[(2)] = null);

(statearr_35120_35142[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto____0 = (function (){
var statearr_35121 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35121[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto__);

(statearr_35121[(1)] = (1));

return statearr_35121;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto____1 = (function (state_35094){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_35094);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e35122){var ex__16304__auto__ = e35122;
var statearr_35123_35143 = state_35094;
(statearr_35123_35143[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_35094[(4)]))){
var statearr_35124_35144 = state_35094;
(statearr_35124_35144[(1)] = cljs.core.first((state_35094[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__35145 = state_35094;
state_35094 = G__35145;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto__ = function(state_35094){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto____1.call(this,state_35094);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_35125 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_35125[(6)] = c__16375__auto__);

return statearr_35125;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__35147){
var vec__35148 = p__35147;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35148,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35148,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35146_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35146_SHARP_,var_val);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_,cljs.core.cst$kw$headers,headers_SINGLEQUOTE_], null);
}),res,cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__35152,p__35153,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__35154 = p__35152;
var map__35154__$1 = (((((!((map__35154 == null))))?(((((map__35154.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35154.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35154):map__35154);
var q_map = map__35154__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35154__$1,cljs.core.cst$kw$prefixes);
var map__35155 = p__35153;
var map__35155__$1 = (((((!((map__35155 == null))))?(((((map__35155.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__35155.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__35155):map__35155);
var res = map__35155__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35155__$1,cljs.core.cst$kw$vars);
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_35364){
var state_val_35365 = (state_35364[(1)]);
if((state_val_35365 === (7))){
var inst_35262 = cljs.core.count(clause);
var inst_35263 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_35262);
var inst_35264 = cljs.core.second(clause);
var inst_35265 = clojure.string.starts_with_QMARK_(inst_35264,"fullText:");
var inst_35266 = ((inst_35263) && (inst_35265));
var state_35364__$1 = state_35364;
if(cljs.core.truth_(inst_35266)){
var statearr_35366_35461 = state_35364__$1;
(statearr_35366_35461[(1)] = (31));

} else {
var statearr_35367_35462 = state_35364__$1;
(statearr_35367_35462[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (59))){
var inst_35333 = (state_35364[(7)]);
var inst_35336 = (state_35364[(2)]);
var inst_35337 = fluree.db.util.async.throw_err(inst_35336);
var inst_35338 = [inst_35337,r];
var inst_35339 = (new cljs.core.PersistentVector(null,2,(5),inst_35333,inst_35338,null));
var state_35364__$1 = state_35364;
var statearr_35368_35463 = state_35364__$1;
(statearr_35368_35463[(2)] = inst_35339);

(statearr_35368_35463[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (20))){
var inst_35226 = (state_35364[(2)]);
var state_35364__$1 = state_35364;
var statearr_35369_35464 = state_35364__$1;
(statearr_35369_35464[(2)] = inst_35226);

(statearr_35369_35464[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (58))){
var inst_35342 = (state_35364[(2)]);
var state_35364__$1 = state_35364;
var statearr_35370_35465 = state_35364__$1;
(statearr_35370_35465[(2)] = inst_35342);

(statearr_35370_35465[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (27))){
var inst_35256 = (state_35364[(2)]);
var state_35364__$1 = state_35364;
var statearr_35371_35466 = state_35364__$1;
(statearr_35371_35466[(2)] = inst_35256);

(statearr_35371_35466[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (1))){
var state_35364__$1 = state_35364;
var statearr_35372_35467 = state_35364__$1;
(statearr_35372_35467[(2)] = null);

(statearr_35372_35467[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (24))){
var inst_35220 = (state_35364[(2)]);
var state_35364__$1 = state_35364;
var statearr_35373_35468 = state_35364__$1;
(statearr_35373_35468[(2)] = inst_35220);

(statearr_35373_35468[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (55))){
var inst_35344 = (state_35364[(2)]);
var state_35364__$1 = state_35364;
var statearr_35374_35469 = state_35364__$1;
(statearr_35374_35469[(2)] = inst_35344);

(statearr_35374_35469[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (39))){
var inst_35298 = cljs.core.count(clause);
var inst_35299 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_35298);
var state_35364__$1 = state_35364;
if(inst_35299){
var statearr_35375_35470 = state_35364__$1;
(statearr_35375_35470[(1)] = (42));

} else {
var statearr_35376_35471 = state_35364__$1;
(statearr_35376_35471[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (46))){
var state_35364__$1 = state_35364;
var statearr_35377_35472 = state_35364__$1;
(statearr_35377_35472[(2)] = null);

(statearr_35377_35472[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (4))){
var inst_35158 = (state_35364[(2)]);
var state_35364__$1 = state_35364;
var statearr_35378_35473 = state_35364__$1;
(statearr_35378_35473[(2)] = inst_35158);

(statearr_35378_35473[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (54))){
var state_35364__$1 = state_35364;
var statearr_35379_35474 = state_35364__$1;
(statearr_35379_35474[(1)] = (56));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (15))){
var inst_35258 = (state_35364[(2)]);
var state_35364__$1 = state_35364;
var statearr_35381_35475 = state_35364__$1;
(statearr_35381_35475[(2)] = inst_35258);

(statearr_35381_35475[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (48))){
var inst_35315 = (state_35364[(8)]);
var inst_35313 = (state_35364[(2)]);
var inst_35314 = fluree.db.util.async.throw_err(inst_35313);
var inst_35315__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35314,(0),null);
var inst_35316 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35314,(1),null);
var inst_35317 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_35315__$1);
var state_35364__$1 = (function (){var statearr_35382 = state_35364;
(statearr_35382[(9)] = inst_35316);

(statearr_35382[(8)] = inst_35315__$1);

return statearr_35382;
})();
if(inst_35317){
var statearr_35383_35476 = state_35364__$1;
(statearr_35383_35476[(1)] = (49));

} else {
var statearr_35384_35477 = state_35364__$1;
(statearr_35384_35477[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (50))){
var inst_35316 = (state_35364[(9)]);
var inst_35324 = cljs.core.second(inst_35316);
var inst_35325 = clojure.string.starts_with_QMARK_(inst_35324,"fullText:");
var state_35364__$1 = state_35364;
if(inst_35325){
var statearr_35385_35478 = state_35364__$1;
(statearr_35385_35478[(1)] = (53));

} else {
var statearr_35386_35479 = state_35364__$1;
(statearr_35386_35479[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (21))){
var inst_35167 = (state_35364[(10)]);
var inst_35195 = (state_35364[(11)]);
var inst_35196 = (state_35364[(12)]);
var inst_35192 = (state_35364[(13)]);
var inst_35203 = (state_35364[(14)]);
var inst_35171 = (state_35364[(15)]);
var inst_35194 = (state_35364[(16)]);
var inst_35197 = (state_35364[(17)]);
var inst_35204 = (state_35364[(18)]);
var inst_35208 = (state_35364[(2)]);
var inst_35209 = fluree.db.util.async.throw_err(inst_35208);
var inst_35210 = (function (){var new_res = inst_35209;
var first__35191 = inst_35194;
var rest = inst_35204;
var tuples = inst_35197;
var pred__35168 = inst_35171;
var first__35201 = inst_35203;
var vec__35189 = inst_35192;
var vec__35199 = inst_35196;
var seq__35190 = inst_35195;
var G__35188 = inst_35196;
var seq__35200 = inst_35204;
var expr__35169 = inst_35167;
var segment_type = inst_35167;
var clause_group = inst_35203;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,cljs.core.cst$kw$var,cljs.core.dissoc,var$);
});
})();
var inst_35211 = cljs.core.keys(vars);
var inst_35212 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35210,inst_35209,inst_35211);
var inst_35213 = fluree.db.query.analytical.res_absorb_vars(inst_35212);
var state_35364__$1 = (function (){var statearr_35387 = state_35364;
(statearr_35387[(19)] = inst_35213);

return statearr_35387;
})();
if(cljs.core.truth_(inst_35197)){
var statearr_35388_35480 = state_35364__$1;
(statearr_35388_35480[(1)] = (22));

} else {
var statearr_35389_35481 = state_35364__$1;
(statearr_35389_35481[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (31))){
var inst_35268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35269 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_35270 = [inst_35269,r];
var inst_35271 = (new cljs.core.PersistentVector(null,2,(5),inst_35268,inst_35270,null));
var state_35364__$1 = state_35364;
var statearr_35390_35482 = state_35364__$1;
(statearr_35390_35482[(2)] = inst_35271);

(statearr_35390_35482[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (32))){
var inst_35273 = cljs.core.count(clause);
var inst_35274 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_35273);
var inst_35275 = cljs.core.second(clause);
var inst_35276 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_35275,"rdf:type");
var inst_35277 = ((inst_35274) && (inst_35276));
var state_35364__$1 = state_35364;
if(cljs.core.truth_(inst_35277)){
var statearr_35391_35483 = state_35364__$1;
(statearr_35391_35483[(1)] = (34));

} else {
var statearr_35392_35484 = state_35364__$1;
(statearr_35392_35484[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (40))){
var inst_35353 = (state_35364[(2)]);
var state_35364__$1 = state_35364;
var statearr_35393_35485 = state_35364__$1;
(statearr_35393_35485[(2)] = inst_35353);

(statearr_35393_35485[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (56))){
var inst_35316 = (state_35364[(9)]);
var inst_35315 = (state_35364[(8)]);
var inst_35333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35334 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_35315,res,inst_35316,fuel,max_fuel);
var state_35364__$1 = (function (){var statearr_35394 = state_35364;
(statearr_35394[(7)] = inst_35333);

return statearr_35394;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35364__$1,(59),inst_35334);
} else {
if((state_val_35365 === (33))){
var inst_35357 = (state_35364[(2)]);
var state_35364__$1 = state_35364;
var statearr_35395_35486 = state_35364__$1;
(statearr_35395_35486[(2)] = inst_35357);

(statearr_35395_35486[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (13))){
var inst_35192 = (state_35364[(13)]);
var inst_35192__$1 = cljs.core.cst$kw$union.cljs$core$IFn$_invoke$arity$1(clause);
var inst_35193 = cljs.core.seq(inst_35192__$1);
var inst_35194 = cljs.core.first(inst_35193);
var inst_35195 = cljs.core.next(inst_35193);
var inst_35196 = inst_35192__$1;
var inst_35197 = null;
var state_35364__$1 = (function (){var statearr_35396 = state_35364;
(statearr_35396[(11)] = inst_35195);

(statearr_35396[(12)] = inst_35196);

(statearr_35396[(13)] = inst_35192__$1);

(statearr_35396[(16)] = inst_35194);

(statearr_35396[(17)] = inst_35197);

return statearr_35396;
})();
var statearr_35397_35487 = state_35364__$1;
(statearr_35397_35487[(2)] = null);

(statearr_35397_35487[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (22))){
var inst_35213 = (state_35364[(19)]);
var inst_35197 = (state_35364[(17)]);
var inst_35204 = (state_35364[(18)]);
var inst_35215 = fluree.db.query.analytical.outer_union(inst_35197,inst_35213);
var inst_35196 = inst_35204;
var inst_35197__$1 = inst_35215;
var state_35364__$1 = (function (){var statearr_35398 = state_35364;
(statearr_35398[(12)] = inst_35196);

(statearr_35398[(17)] = inst_35197__$1);

return statearr_35398;
})();
var statearr_35399_35488 = state_35364__$1;
(statearr_35399_35488[(2)] = null);

(statearr_35399_35488[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (36))){
var inst_35355 = (state_35364[(2)]);
var state_35364__$1 = state_35364;
var statearr_35400_35489 = state_35364__$1;
(statearr_35400_35489[(2)] = inst_35355);

(statearr_35400_35489[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (41))){
var inst_35290 = (state_35364[(20)]);
var inst_35293 = (state_35364[(2)]);
var inst_35294 = fluree.db.util.async.throw_err(inst_35293);
var inst_35295 = [inst_35294,r];
var inst_35296 = (new cljs.core.PersistentVector(null,2,(5),inst_35290,inst_35295,null));
var state_35364__$1 = state_35364;
var statearr_35401_35490 = state_35364__$1;
(statearr_35401_35490[(2)] = inst_35296);

(statearr_35401_35490[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (43))){
var state_35364__$1 = state_35364;
var statearr_35402_35491 = state_35364__$1;
(statearr_35402_35491[(1)] = (45));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (29))){
var inst_35167 = (state_35364[(10)]);
var inst_35250 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35167)].join('');
var inst_35251 = (new Error(inst_35250));
var inst_35252 = (function(){throw inst_35251})();
var state_35364__$1 = state_35364;
var statearr_35404_35492 = state_35364__$1;
(statearr_35404_35492[(2)] = inst_35252);

(statearr_35404_35492[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (44))){
var inst_35351 = (state_35364[(2)]);
var state_35364__$1 = state_35364;
var statearr_35405_35493 = state_35364__$1;
(statearr_35405_35493[(2)] = inst_35351);

(statearr_35405_35493[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (6))){
var inst_35167 = (state_35364[(10)]);
var inst_35171 = (state_35364[(15)]);
var inst_35166 = cljs.core.keys(clause);
var inst_35167__$1 = cljs.core.first(inst_35166);
var inst_35171__$1 = cljs.core._EQ_;
var inst_35172 = (function (){var G__35406 = cljs.core.cst$kw$optional;
var G__35407 = inst_35167__$1;
return (inst_35171__$1.cljs$core$IFn$_invoke$arity$2 ? inst_35171__$1.cljs$core$IFn$_invoke$arity$2(G__35406,G__35407) : inst_35171__$1.call(null,G__35406,G__35407));
})();
var state_35364__$1 = (function (){var statearr_35408 = state_35364;
(statearr_35408[(10)] = inst_35167__$1);

(statearr_35408[(15)] = inst_35171__$1);

return statearr_35408;
})();
if(cljs.core.truth_(inst_35172)){
var statearr_35409_35494 = state_35364__$1;
(statearr_35409_35494[(1)] = (9));

} else {
var statearr_35410_35495 = state_35364__$1;
(statearr_35410_35495[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (28))){
var inst_35244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35245 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(clause);
var inst_35246 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_35245,optional_QMARK_);
var inst_35247 = [inst_35246,r];
var inst_35248 = (new cljs.core.PersistentVector(null,2,(5),inst_35244,inst_35247,null));
var state_35364__$1 = state_35364;
var statearr_35411_35496 = state_35364__$1;
(statearr_35411_35496[(2)] = inst_35248);

(statearr_35411_35496[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (51))){
var inst_35346 = (state_35364[(2)]);
var state_35364__$1 = state_35364;
var statearr_35412_35497 = state_35364__$1;
(statearr_35412_35497[(2)] = inst_35346);

(statearr_35412_35497[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (25))){
var inst_35167 = (state_35364[(10)]);
var inst_35171 = (state_35364[(15)]);
var inst_35232 = cljs.core.cst$kw$bind.cljs$core$IFn$_invoke$arity$1(clause);
var inst_35233 = (function (){var segment_type = inst_35167;
var pred__35168 = inst_35171;
var expr__35169 = inst_35167;
var bindings = inst_35232;
return (function (p1__35151_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__35151_SHARP_);
});
})();
var inst_35234 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35233,inst_35232);
var inst_35235 = cljs.core.PersistentHashMap.EMPTY;
var inst_35236 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35235,inst_35234);
var inst_35237 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35238 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_35236);
var inst_35239 = [inst_35238,r];
var inst_35240 = (new cljs.core.PersistentVector(null,2,(5),inst_35237,inst_35239,null));
var state_35364__$1 = state_35364;
var statearr_35413_35498 = state_35364__$1;
(statearr_35413_35498[(2)] = inst_35240);

(statearr_35413_35498[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (34))){
var inst_35279 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35280 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_35364__$1 = (function (){var statearr_35414 = state_35364;
(statearr_35414[(21)] = inst_35279);

return statearr_35414;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35364__$1,(37),inst_35280);
} else {
if((state_val_35365 === (17))){
var inst_35228 = (state_35364[(2)]);
var state_35364__$1 = state_35364;
var statearr_35415_35499 = state_35364__$1;
(statearr_35415_35499[(2)] = inst_35228);

(statearr_35415_35499[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (3))){
var inst_35362 = (state_35364[(2)]);
var state_35364__$1 = state_35364;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35364__$1,inst_35362);
} else {
if((state_val_35365 === (12))){
var inst_35174 = (state_35364[(22)]);
var inst_35178 = (state_35364[(2)]);
var inst_35179 = fluree.db.util.async.throw_err(inst_35178);
var inst_35180 = [inst_35179,r];
var inst_35181 = (new cljs.core.PersistentVector(null,2,(5),inst_35174,inst_35180,null));
var state_35364__$1 = state_35364;
var statearr_35416_35500 = state_35364__$1;
(statearr_35416_35500[(2)] = inst_35181);

(statearr_35416_35500[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (2))){
var _ = (function (){var statearr_35417 = state_35364;
(statearr_35417[(4)] = cljs.core.cons((5),(state_35364[(4)])));

return statearr_35417;
})();
var inst_35164 = cljs.core.map_QMARK_(clause);
var state_35364__$1 = state_35364;
if(inst_35164){
var statearr_35418_35501 = state_35364__$1;
(statearr_35418_35501[(1)] = (6));

} else {
var statearr_35419_35502 = state_35364__$1;
(statearr_35419_35502[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (23))){
var inst_35213 = (state_35364[(19)]);
var inst_35204 = (state_35364[(18)]);
var inst_35196 = inst_35204;
var inst_35197 = inst_35213;
var state_35364__$1 = (function (){var statearr_35420 = state_35364;
(statearr_35420[(12)] = inst_35196);

(statearr_35420[(17)] = inst_35197);

return statearr_35420;
})();
var statearr_35421_35503 = state_35364__$1;
(statearr_35421_35503[(2)] = null);

(statearr_35421_35503[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (47))){
var inst_35349 = (state_35364[(2)]);
var state_35364__$1 = state_35364;
var statearr_35422_35504 = state_35364__$1;
(statearr_35422_35504[(2)] = inst_35349);

(statearr_35422_35504[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (35))){
var inst_35287 = cljs.core.count(clause);
var inst_35288 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_35287);
var state_35364__$1 = state_35364;
if(inst_35288){
var statearr_35423_35505 = state_35364__$1;
(statearr_35423_35505[(1)] = (38));

} else {
var statearr_35424_35506 = state_35364__$1;
(statearr_35424_35506[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (19))){
var inst_35197 = (state_35364[(17)]);
var inst_35222 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35223 = [inst_35197,r];
var inst_35224 = (new cljs.core.PersistentVector(null,2,(5),inst_35222,inst_35223,null));
var state_35364__$1 = state_35364;
var statearr_35425_35507 = state_35364__$1;
(statearr_35425_35507[(2)] = inst_35224);

(statearr_35425_35507[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (57))){
var state_35364__$1 = state_35364;
var statearr_35426_35508 = state_35364__$1;
(statearr_35426_35508[(2)] = null);

(statearr_35426_35508[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (11))){
var inst_35260 = (state_35364[(2)]);
var state_35364__$1 = state_35364;
var statearr_35428_35509 = state_35364__$1;
(statearr_35428_35509[(2)] = inst_35260);

(statearr_35428_35509[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (9))){
var inst_35174 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35175 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(clause);
var inst_35176 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_35175,res,fuel,max_fuel,opts);
var state_35364__$1 = (function (){var statearr_35429 = state_35364;
(statearr_35429[(22)] = inst_35174);

return statearr_35429;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35364__$1,(12),inst_35176);
} else {
if((state_val_35365 === (5))){
var _ = (function (){var statearr_35430 = state_35364;
(statearr_35430[(4)] = cljs.core.rest((state_35364[(4)])));

return statearr_35430;
})();
var state_35364__$1 = state_35364;
var ex35427 = (state_35364__$1[(2)]);
var statearr_35431_35510 = state_35364__$1;
(statearr_35431_35510[(5)] = ex35427);


if((ex35427 instanceof Error)){
var statearr_35432_35511 = state_35364__$1;
(statearr_35432_35511[(1)] = (4));

(statearr_35432_35511[(5)] = null);

} else {
throw ex35427;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (14))){
var inst_35167 = (state_35364[(10)]);
var inst_35171 = (state_35364[(15)]);
var inst_35230 = (function (){var G__35433 = cljs.core.cst$kw$bind;
var G__35434 = inst_35167;
return (inst_35171.cljs$core$IFn$_invoke$arity$2 ? inst_35171.cljs$core$IFn$_invoke$arity$2(G__35433,G__35434) : inst_35171.call(null,G__35433,G__35434));
})();
var state_35364__$1 = state_35364;
if(cljs.core.truth_(inst_35230)){
var statearr_35435_35512 = state_35364__$1;
(statearr_35435_35512[(1)] = (25));

} else {
var statearr_35436_35513 = state_35364__$1;
(statearr_35436_35513[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (45))){
var inst_35311 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_35364__$1 = state_35364;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35364__$1,(48),inst_35311);
} else {
if((state_val_35365 === (53))){
var inst_35316 = (state_35364[(9)]);
var inst_35315 = (state_35364[(8)]);
var inst_35327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35328 = fluree.db.query.analytical.full_text__GT_tuples(inst_35315,res,inst_35316);
var inst_35329 = [inst_35328,r];
var inst_35330 = (new cljs.core.PersistentVector(null,2,(5),inst_35327,inst_35329,null));
var state_35364__$1 = state_35364;
var statearr_35437_35514 = state_35364__$1;
(statearr_35437_35514[(2)] = inst_35330);

(statearr_35437_35514[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (26))){
var inst_35167 = (state_35364[(10)]);
var inst_35171 = (state_35364[(15)]);
var inst_35242 = (function (){var G__35438 = cljs.core.cst$kw$filter;
var G__35439 = inst_35167;
return (inst_35171.cljs$core$IFn$_invoke$arity$2 ? inst_35171.cljs$core$IFn$_invoke$arity$2(G__35438,G__35439) : inst_35171.call(null,G__35438,G__35439));
})();
var state_35364__$1 = state_35364;
if(cljs.core.truth_(inst_35242)){
var statearr_35440_35515 = state_35364__$1;
(statearr_35440_35515[(1)] = (28));

} else {
var statearr_35441_35516 = state_35364__$1;
(statearr_35441_35516[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (16))){
var inst_35196 = (state_35364[(12)]);
var inst_35203 = (state_35364[(14)]);
var inst_35202 = cljs.core.seq(inst_35196);
var inst_35203__$1 = cljs.core.first(inst_35202);
var inst_35204 = cljs.core.next(inst_35202);
var state_35364__$1 = (function (){var statearr_35442 = state_35364;
(statearr_35442[(14)] = inst_35203__$1);

(statearr_35442[(18)] = inst_35204);

return statearr_35442;
})();
if(cljs.core.truth_(inst_35203__$1)){
var statearr_35443_35517 = state_35364__$1;
(statearr_35443_35517[(1)] = (18));

} else {
var statearr_35444_35518 = state_35364__$1;
(statearr_35444_35518[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (38))){
var inst_35290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35291 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_35364__$1 = (function (){var statearr_35445 = state_35364;
(statearr_35445[(20)] = inst_35290);

return statearr_35445;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35364__$1,(41),inst_35291);
} else {
if((state_val_35365 === (30))){
var inst_35254 = (state_35364[(2)]);
var state_35364__$1 = state_35364;
var statearr_35446_35519 = state_35364__$1;
(statearr_35446_35519[(2)] = inst_35254);

(statearr_35446_35519[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (10))){
var inst_35167 = (state_35364[(10)]);
var inst_35171 = (state_35364[(15)]);
var inst_35183 = (function (){var G__35447 = cljs.core.cst$kw$union;
var G__35448 = inst_35167;
return (inst_35171.cljs$core$IFn$_invoke$arity$2 ? inst_35171.cljs$core$IFn$_invoke$arity$2(G__35447,G__35448) : inst_35171.call(null,G__35447,G__35448));
})();
var state_35364__$1 = state_35364;
if(cljs.core.truth_(inst_35183)){
var statearr_35449_35520 = state_35364__$1;
(statearr_35449_35520[(1)] = (13));

} else {
var statearr_35450_35521 = state_35364__$1;
(statearr_35450_35521[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (18))){
var inst_35203 = (state_35364[(14)]);
var inst_35206 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_35203,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_35203,q_map,vars,fuel,max_fuel,opts));
var state_35364__$1 = state_35364;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35364__$1,(21),inst_35206);
} else {
if((state_val_35365 === (52))){
var inst_35321 = (state_35364[(2)]);
var inst_35322 = fluree.db.util.async.throw_err(inst_35321);
var state_35364__$1 = state_35364;
var statearr_35451_35522 = state_35364__$1;
(statearr_35451_35522[(2)] = inst_35322);

(statearr_35451_35522[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (42))){
var inst_35301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35302 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_35303 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_35302);
var inst_35304 = [inst_35303,r];
var inst_35305 = (new cljs.core.PersistentVector(null,2,(5),inst_35301,inst_35304,null));
var state_35364__$1 = state_35364;
var statearr_35452_35523 = state_35364__$1;
(statearr_35452_35523[(2)] = inst_35305);

(statearr_35452_35523[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (37))){
var inst_35279 = (state_35364[(21)]);
var inst_35282 = (state_35364[(2)]);
var inst_35283 = fluree.db.util.async.throw_err(inst_35282);
var inst_35284 = [inst_35283,r];
var inst_35285 = (new cljs.core.PersistentVector(null,2,(5),inst_35279,inst_35284,null));
var state_35364__$1 = state_35364;
var statearr_35453_35524 = state_35364__$1;
(statearr_35453_35524[(2)] = inst_35285);

(statearr_35453_35524[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (8))){
var inst_35359 = (state_35364[(2)]);
var _ = (function (){var statearr_35454 = state_35364;
(statearr_35454[(4)] = cljs.core.rest((state_35364[(4)])));

return statearr_35454;
})();
var state_35364__$1 = state_35364;
var statearr_35455_35525 = state_35364__$1;
(statearr_35455_35525[(2)] = inst_35359);

(statearr_35455_35525[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (49))){
var inst_35316 = (state_35364[(9)]);
var inst_35319 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_35316,r,res,optional_QMARK_,fuel,max_fuel);
var state_35364__$1 = state_35364;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35364__$1,(52),inst_35319);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_35456 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35456[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto__);

(statearr_35456[(1)] = (1));

return statearr_35456;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto____1 = (function (state_35364){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_35364);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e35457){var ex__16304__auto__ = e35457;
var statearr_35458_35526 = state_35364;
(statearr_35458_35526[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_35364[(4)]))){
var statearr_35459_35527 = state_35364;
(statearr_35459_35527[(1)] = cljs.core.first((state_35364[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__35528 = state_35364;
state_35364 = G__35528;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto__ = function(state_35364){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto____1.call(this,state_35364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_35460 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_35460[(6)] = c__16375__auto__);

return statearr_35460;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__35530 = arguments.length;
switch (G__35530) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_35610){
var state_val_35611 = (state_35610[(1)]);
if((state_val_35611 === (7))){
var inst_35605 = (state_35610[(2)]);
var _ = (function (){var statearr_35612 = state_35610;
(statearr_35612[(4)] = cljs.core.rest((state_35610[(4)])));

return statearr_35612;
})();
var state_35610__$1 = state_35610;
var statearr_35613_35661 = state_35610__$1;
(statearr_35613_35661[(2)] = inst_35605);

(statearr_35613_35661[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (20))){
var inst_35570 = (state_35610[(7)]);
var inst_35582 = (state_35610[(2)]);
var inst_35552 = inst_35570;
var inst_35553 = inst_35582;
var state_35610__$1 = (function (){var statearr_35614 = state_35610;
(statearr_35614[(8)] = inst_35552);

(statearr_35614[(9)] = inst_35553);

return statearr_35614;
})();
var statearr_35615_35662 = state_35610__$1;
(statearr_35615_35662[(2)] = null);

(statearr_35615_35662[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (1))){
var state_35610__$1 = state_35610;
var statearr_35616_35663 = state_35610__$1;
(statearr_35616_35663[(2)] = null);

(statearr_35616_35663[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (24))){
var inst_35569 = (state_35610[(10)]);
var inst_35553 = (state_35610[(9)]);
var inst_35570 = (state_35610[(7)]);
var inst_35590 = fluree.db.query.analytical.inner_join(inst_35553,inst_35569);
var inst_35552 = inst_35570;
var inst_35553__$1 = inst_35590;
var state_35610__$1 = (function (){var statearr_35617 = state_35610;
(statearr_35617[(8)] = inst_35552);

(statearr_35617[(9)] = inst_35553__$1);

return statearr_35617;
})();
var statearr_35618_35664 = state_35610__$1;
(statearr_35618_35664[(2)] = null);

(statearr_35618_35664[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (4))){
var inst_35531 = (state_35610[(2)]);
var state_35610__$1 = state_35610;
var statearr_35620_35665 = state_35610__$1;
(statearr_35620_35665[(2)] = inst_35531);

(statearr_35620_35665[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (15))){
var inst_35569 = (state_35610[(10)]);
var state_35610__$1 = state_35610;
if(cljs.core.truth_(inst_35569)){
var statearr_35621_35666 = state_35610__$1;
(statearr_35621_35666[(1)] = (18));

} else {
var statearr_35622_35667 = state_35610__$1;
(statearr_35622_35667[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (21))){
var inst_35553 = (state_35610[(9)]);
var inst_35570 = (state_35610[(7)]);
var tmp35619 = inst_35553;
var inst_35552 = inst_35570;
var inst_35553__$1 = tmp35619;
var state_35610__$1 = (function (){var statearr_35623 = state_35610;
(statearr_35623[(8)] = inst_35552);

(statearr_35623[(9)] = inst_35553__$1);

return statearr_35623;
})();
var statearr_35624_35668 = state_35610__$1;
(statearr_35624_35668[(2)] = null);

(statearr_35624_35668[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (13))){
var inst_35553 = (state_35610[(9)]);
var inst_35576 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_35553,cljs.core.cst$kw$vars);
var inst_35577 = cljs.core.empty_QMARK_(inst_35576);
var state_35610__$1 = state_35610;
if(inst_35577){
var statearr_35625_35669 = state_35610__$1;
(statearr_35625_35669[(1)] = (15));

} else {
var statearr_35626_35670 = state_35610__$1;
(statearr_35626_35670[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (22))){
var state_35610__$1 = state_35610;
var statearr_35627_35671 = state_35610__$1;
(statearr_35627_35671[(1)] = (24));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (6))){
var inst_35559 = (state_35610[(11)]);
var inst_35552 = (state_35610[(8)]);
var inst_35558 = cljs.core.seq(inst_35552);
var inst_35559__$1 = cljs.core.first(inst_35558);
var inst_35560 = cljs.core.next(inst_35558);
var state_35610__$1 = (function (){var statearr_35629 = state_35610;
(statearr_35629[(11)] = inst_35559__$1);

(statearr_35629[(12)] = inst_35560);

return statearr_35629;
})();
if(cljs.core.truth_(inst_35559__$1)){
var statearr_35630_35672 = state_35610__$1;
(statearr_35630_35672[(1)] = (8));

} else {
var statearr_35631_35673 = state_35610__$1;
(statearr_35631_35673[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (25))){
var state_35610__$1 = state_35610;
var statearr_35632_35674 = state_35610__$1;
(statearr_35632_35674[(2)] = null);

(statearr_35632_35674[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (17))){
var inst_35598 = (state_35610[(2)]);
var state_35610__$1 = state_35610;
var statearr_35633_35675 = state_35610__$1;
(statearr_35633_35675[(2)] = inst_35598);

(statearr_35633_35675[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (3))){
var inst_35608 = (state_35610[(2)]);
var state_35610__$1 = state_35610;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35610__$1,inst_35608);
} else {
if((state_val_35611 === (12))){
var inst_35569 = (state_35610[(10)]);
var inst_35570 = (state_35610[(7)]);
var inst_35552 = inst_35570;
var inst_35553 = inst_35569;
var state_35610__$1 = (function (){var statearr_35634 = state_35610;
(statearr_35634[(8)] = inst_35552);

(statearr_35634[(9)] = inst_35553);

return statearr_35634;
})();
var statearr_35635_35676 = state_35610__$1;
(statearr_35635_35676[(2)] = null);

(statearr_35635_35676[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (2))){
var _ = (function (){var statearr_35636 = state_35610;
(statearr_35636[(4)] = cljs.core.cons((5),(state_35610[(4)])));

return statearr_35636;
})();
var inst_35544 = where;
var inst_35545 = cljs.core.seq(inst_35544);
var inst_35546 = cljs.core.first(inst_35545);
var inst_35547 = cljs.core.next(inst_35545);
var inst_35548 = [cljs.core.cst$kw$vars];
var inst_35549 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_35550 = [inst_35549];
var inst_35551 = cljs.core.PersistentHashMap.fromArrays(inst_35548,inst_35550);
var inst_35552 = inst_35544;
var inst_35553 = inst_35551;
var state_35610__$1 = (function (){var statearr_35637 = state_35610;
(statearr_35637[(8)] = inst_35552);

(statearr_35637[(13)] = inst_35546);

(statearr_35637[(14)] = inst_35547);

(statearr_35637[(9)] = inst_35553);

return statearr_35637;
})();
var statearr_35638_35677 = state_35610__$1;
(statearr_35638_35677[(2)] = null);

(statearr_35638_35677[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (23))){
var inst_35596 = (state_35610[(2)]);
var state_35610__$1 = state_35610;
var statearr_35639_35678 = state_35610__$1;
(statearr_35639_35678[(2)] = inst_35596);

(statearr_35639_35678[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (19))){
var inst_35553 = (state_35610[(9)]);
var state_35610__$1 = state_35610;
var statearr_35640_35679 = state_35610__$1;
(statearr_35640_35679[(2)] = inst_35553);

(statearr_35640_35679[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (11))){
var inst_35559 = (state_35610[(11)]);
var inst_35567 = (state_35610[(2)]);
var inst_35568 = fluree.db.util.async.throw_err(inst_35567);
var inst_35569 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35568,(0),null);
var inst_35570 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35568,(1),null);
var inst_35571 = cljs.core.count(inst_35559);
var inst_35572 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_35571);
var state_35610__$1 = (function (){var statearr_35642 = state_35610;
(statearr_35642[(10)] = inst_35569);

(statearr_35642[(7)] = inst_35570);

return statearr_35642;
})();
if(inst_35572){
var statearr_35643_35680 = state_35610__$1;
(statearr_35643_35680[(1)] = (12));

} else {
var statearr_35644_35681 = state_35610__$1;
(statearr_35644_35681[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (9))){
var inst_35553 = (state_35610[(9)]);
var state_35610__$1 = state_35610;
var statearr_35645_35682 = state_35610__$1;
(statearr_35645_35682[(2)] = inst_35553);

(statearr_35645_35682[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (5))){
var _ = (function (){var statearr_35646 = state_35610;
(statearr_35646[(4)] = cljs.core.rest((state_35610[(4)])));

return statearr_35646;
})();
var state_35610__$1 = state_35610;
var ex35641 = (state_35610__$1[(2)]);
var statearr_35647_35683 = state_35610__$1;
(statearr_35647_35683[(5)] = ex35641);


if((ex35641 instanceof Error)){
var statearr_35648_35684 = state_35610__$1;
(statearr_35648_35684[(1)] = (4));

(statearr_35648_35684[(5)] = null);

} else {
throw ex35641;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (14))){
var inst_35600 = (state_35610[(2)]);
var state_35610__$1 = state_35610;
var statearr_35649_35685 = state_35610__$1;
(statearr_35649_35685[(2)] = inst_35600);

(statearr_35649_35685[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (26))){
var inst_35594 = (state_35610[(2)]);
var state_35610__$1 = state_35610;
var statearr_35650_35686 = state_35610__$1;
(statearr_35650_35686[(2)] = inst_35594);

(statearr_35650_35686[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (16))){
var inst_35569 = (state_35610[(10)]);
var inst_35585 = (inst_35569 == null);
var state_35610__$1 = state_35610;
if(cljs.core.truth_(inst_35585)){
var statearr_35651_35687 = state_35610__$1;
(statearr_35651_35687[(1)] = (21));

} else {
var statearr_35652_35688 = state_35610__$1;
(statearr_35652_35688[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (10))){
var inst_35603 = (state_35610[(2)]);
var state_35610__$1 = state_35610;
var statearr_35653_35689 = state_35610__$1;
(statearr_35653_35689[(2)] = inst_35603);

(statearr_35653_35689[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (18))){
var inst_35569 = (state_35610[(10)]);
var state_35610__$1 = state_35610;
var statearr_35654_35690 = state_35610__$1;
(statearr_35654_35690[(2)] = inst_35569);

(statearr_35654_35690[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35611 === (8))){
var inst_35559 = (state_35610[(11)]);
var inst_35560 = (state_35610[(12)]);
var inst_35553 = (state_35610[(9)]);
var inst_35565 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_35553,inst_35559,inst_35560,false,fuel,max_fuel,opts);
var state_35610__$1 = state_35610;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35610__$1,(11),inst_35565);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__16301__auto__ = null;
var fluree$db$query$analytical$state_machine__16301__auto____0 = (function (){
var statearr_35655 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35655[(0)] = fluree$db$query$analytical$state_machine__16301__auto__);

(statearr_35655[(1)] = (1));

return statearr_35655;
});
var fluree$db$query$analytical$state_machine__16301__auto____1 = (function (state_35610){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_35610);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e35656){var ex__16304__auto__ = e35656;
var statearr_35657_35691 = state_35610;
(statearr_35657_35691[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_35610[(4)]))){
var statearr_35658_35692 = state_35610;
(statearr_35658_35692[(1)] = cljs.core.first((state_35610[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__35693 = state_35610;
state_35610 = G__35693;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__16301__auto__ = function(state_35610){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__16301__auto____1.call(this,state_35610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__16301__auto____0;
fluree$db$query$analytical$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__16301__auto____1;
return fluree$db$query$analytical$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_35659 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_35659[(6)] = c__16375__auto__);

return statearr_35659;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_35748){
var state_val_35749 = (state_35748[(1)]);
if((state_val_35749 === (7))){
var state_35748__$1 = state_35748;
var statearr_35750_35788 = state_35748__$1;
(statearr_35750_35788[(2)] = false);

(statearr_35750_35788[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35749 === (20))){
var inst_35738 = (state_35748[(7)]);
var inst_35726 = (state_35748[(8)]);
var inst_35740 = fluree.db.query.analytical.tuples__GT_filtered(inst_35738,inst_35726,null);
var state_35748__$1 = state_35748;
var statearr_35751_35789 = state_35748__$1;
(statearr_35751_35789[(2)] = inst_35740);

(statearr_35751_35789[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35749 === (1))){
var state_35748__$1 = state_35748;
var statearr_35752_35790 = state_35748__$1;
(statearr_35752_35790[(2)] = null);

(statearr_35752_35790[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35749 === (4))){
var inst_35694 = (state_35748[(2)]);
var state_35748__$1 = state_35748;
var statearr_35753_35791 = state_35748__$1;
(statearr_35753_35791[(2)] = inst_35694);

(statearr_35753_35791[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35749 === (15))){
var inst_35725 = (state_35748[(9)]);
var inst_35729 = (state_35748[(2)]);
var inst_35730 = fluree.db.util.async.throw_err(inst_35729);
var state_35748__$1 = (function (){var statearr_35754 = state_35748;
(statearr_35754[(10)] = inst_35730);

return statearr_35754;
})();
if(cljs.core.truth_(inst_35725)){
var statearr_35755_35792 = state_35748__$1;
(statearr_35755_35792[(1)] = (16));

} else {
var statearr_35756_35793 = state_35748__$1;
(statearr_35756_35793[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35749 === (21))){
var inst_35738 = (state_35748[(7)]);
var state_35748__$1 = state_35748;
var statearr_35757_35794 = state_35748__$1;
(statearr_35757_35794[(2)] = inst_35738);

(statearr_35757_35794[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35749 === (13))){
var inst_35701 = (state_35748[(11)]);
var state_35748__$1 = state_35748;
var statearr_35758_35795 = state_35748__$1;
(statearr_35758_35795[(2)] = inst_35701);

(statearr_35758_35795[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35749 === (22))){
var inst_35743 = (state_35748[(2)]);
var _ = (function (){var statearr_35759 = state_35748;
(statearr_35759[(4)] = cljs.core.rest((state_35748[(4)])));

return statearr_35759;
})();
var state_35748__$1 = state_35748;
var statearr_35760_35796 = state_35748__$1;
(statearr_35760_35796[(2)] = inst_35743);

(statearr_35760_35796[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35749 === (6))){
var inst_35701 = (state_35748[(11)]);
var inst_35706 = inst_35701.cljs$lang$protocol_mask$partition0$;
var inst_35707 = (inst_35706 & (64));
var inst_35708 = inst_35701.cljs$core$ISeq$;
var inst_35709 = (cljs.core.PROTOCOL_SENTINEL === inst_35708);
var inst_35710 = ((inst_35707) || (inst_35709));
var state_35748__$1 = state_35748;
if(cljs.core.truth_(inst_35710)){
var statearr_35761_35797 = state_35748__$1;
(statearr_35761_35797[(1)] = (9));

} else {
var statearr_35762_35798 = state_35748__$1;
(statearr_35762_35798[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35749 === (17))){
var inst_35730 = (state_35748[(10)]);
var state_35748__$1 = state_35748;
var statearr_35763_35799 = state_35748__$1;
(statearr_35763_35799[(2)] = inst_35730);

(statearr_35763_35799[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35749 === (3))){
var inst_35746 = (state_35748[(2)]);
var state_35748__$1 = state_35748;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35748__$1,inst_35746);
} else {
if((state_val_35749 === (12))){
var inst_35701 = (state_35748[(11)]);
var inst_35719 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_35701);
var state_35748__$1 = state_35748;
var statearr_35764_35800 = state_35748__$1;
(statearr_35764_35800[(2)] = inst_35719);

(statearr_35764_35800[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35749 === (2))){
var inst_35701 = (state_35748[(11)]);
var _ = (function (){var statearr_35765 = state_35748;
(statearr_35765[(4)] = cljs.core.cons((5),(state_35748[(4)])));

return statearr_35765;
})();
var inst_35701__$1 = q_map;
var inst_35703 = (inst_35701__$1 == null);
var inst_35704 = cljs.core.not(inst_35703);
var state_35748__$1 = (function (){var statearr_35766 = state_35748;
(statearr_35766[(11)] = inst_35701__$1);

return statearr_35766;
})();
if(inst_35704){
var statearr_35767_35801 = state_35748__$1;
(statearr_35767_35801[(1)] = (6));

} else {
var statearr_35768_35802 = state_35748__$1;
(statearr_35768_35802[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35749 === (19))){
var inst_35734 = (state_35748[(2)]);
var inst_35735 = fluree.db.util.async.throw_err(inst_35734);
var state_35748__$1 = state_35748;
var statearr_35769_35803 = state_35748__$1;
(statearr_35769_35803[(2)] = inst_35735);

(statearr_35769_35803[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35749 === (11))){
var inst_35714 = (state_35748[(2)]);
var state_35748__$1 = state_35748;
var statearr_35771_35804 = state_35748__$1;
(statearr_35771_35804[(2)] = inst_35714);

(statearr_35771_35804[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35749 === (9))){
var state_35748__$1 = state_35748;
var statearr_35772_35805 = state_35748__$1;
(statearr_35772_35805[(2)] = true);

(statearr_35772_35805[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35749 === (5))){
var _ = (function (){var statearr_35773 = state_35748;
(statearr_35773[(4)] = cljs.core.rest((state_35748[(4)])));

return statearr_35773;
})();
var state_35748__$1 = state_35748;
var ex35770 = (state_35748__$1[(2)]);
var statearr_35774_35806 = state_35748__$1;
(statearr_35774_35806[(5)] = ex35770);


if((ex35770 instanceof Error)){
var statearr_35775_35807 = state_35748__$1;
(statearr_35775_35807[(1)] = (4));

(statearr_35775_35807[(5)] = null);

} else {
throw ex35770;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35749 === (14))){
var inst_35722 = (state_35748[(2)]);
var inst_35723 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35722,cljs.core.cst$kw$vars);
var inst_35724 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35722,cljs.core.cst$kw$where);
var inst_35725 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35722,cljs.core.cst$kw$optional);
var inst_35726 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35722,cljs.core.cst$kw$filter);
var inst_35727 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_35724,q_map,inst_35723,fuel,max_fuel,opts);
var state_35748__$1 = (function (){var statearr_35776 = state_35748;
(statearr_35776[(8)] = inst_35726);

(statearr_35776[(9)] = inst_35725);

return statearr_35776;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35748__$1,(15),inst_35727);
} else {
if((state_val_35749 === (16))){
var inst_35730 = (state_35748[(10)]);
var inst_35725 = (state_35748[(9)]);
var inst_35732 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_35725,inst_35730,fuel,max_fuel,opts);
var state_35748__$1 = state_35748;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35748__$1,(19),inst_35732);
} else {
if((state_val_35749 === (10))){
var state_35748__$1 = state_35748;
var statearr_35777_35808 = state_35748__$1;
(statearr_35777_35808[(2)] = false);

(statearr_35777_35808[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35749 === (18))){
var inst_35726 = (state_35748[(8)]);
var inst_35738 = (state_35748[(2)]);
var state_35748__$1 = (function (){var statearr_35778 = state_35748;
(statearr_35778[(7)] = inst_35738);

return statearr_35778;
})();
if(cljs.core.truth_(inst_35726)){
var statearr_35779_35809 = state_35748__$1;
(statearr_35779_35809[(1)] = (20));

} else {
var statearr_35780_35810 = state_35748__$1;
(statearr_35780_35810[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35749 === (8))){
var inst_35717 = (state_35748[(2)]);
var state_35748__$1 = state_35748;
if(cljs.core.truth_(inst_35717)){
var statearr_35781_35811 = state_35748__$1;
(statearr_35781_35811[(1)] = (12));

} else {
var statearr_35782_35812 = state_35748__$1;
(statearr_35782_35812[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__16301__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__16301__auto____0 = (function (){
var statearr_35783 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35783[(0)] = fluree$db$query$analytical$q_$_state_machine__16301__auto__);

(statearr_35783[(1)] = (1));

return statearr_35783;
});
var fluree$db$query$analytical$q_$_state_machine__16301__auto____1 = (function (state_35748){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_35748);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e35784){var ex__16304__auto__ = e35784;
var statearr_35785_35813 = state_35748;
(statearr_35785_35813[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_35748[(4)]))){
var statearr_35786_35814 = state_35748;
(statearr_35786_35814[(1)] = cljs.core.first((state_35748[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__35815 = state_35748;
state_35748 = G__35815;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__16301__auto__ = function(state_35748){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__16301__auto____1.call(this,state_35748);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__16301__auto____0;
fluree$db$query$analytical$q_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__16301__auto____1;
return fluree$db$query$analytical$q_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_35787 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_35787[(6)] = c__16375__auto__);

return statearr_35787;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
