// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__37131 = null;
var G__37131__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__37131__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__37131__2 = (function (result,flake){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + (1)));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__37131 = function(result,flake){
switch(arguments.length){
case 0:
return G__37131__0.call(this);
case 1:
return G__37131__1.call(this,result);
case 2:
return G__37131__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37131.cljs$core$IFn$_invoke$arity$0 = G__37131__0;
G__37131.cljs$core$IFn$_invoke$arity$1 = G__37131__1;
G__37131.cljs$core$IFn$_invoke$arity$2 = G__37131__2;
return G__37131;
})()
});
});
/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__37132 = null;
var G__37132__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__37132__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__37132__2 = (function (result,flakes){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + cljs.core.count(flakes)));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__37132 = function(result,flakes){
switch(arguments.length){
case 0:
return G__37132__0.call(this);
case 1:
return G__37132__1.call(this,result);
case 2:
return G__37132__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37132.cljs$core$IFn$_invoke$arity$0 = G__37132__0;
G__37132.cljs$core$IFn$_invoke$arity$1 = G__37132__1;
G__37132.cljs$core$IFn$_invoke$arity$2 = G__37132__2;
return G__37132;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + n));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4126__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
cljs.core._vreset_BANG_(cache,cljs.core.assoc_in(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__37134 = res;
var G__37134__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__37133_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__37133_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__37134):G__37134);
var G__37134__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__37134__$1):G__37134__$1);
var G__37134__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__37134__$2):G__37134__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__37134__$3);
} else {
return G__37134__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__37136 = arguments.length;
switch (G__37136) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_37439){
var state_val_37440 = (state_37439[(1)]);
if((state_val_37440 === (65))){
var inst_37166 = (state_37439[(7)]);
var inst_37297 = (state_37439[(8)]);
var inst_37290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37291 = cljs.core.deref(cache);
var inst_37292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37293 = flake.o;
var inst_37294 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37166);
var inst_37295 = [inst_37293,inst_37294];
var inst_37296 = (new cljs.core.PersistentVector(null,2,(5),inst_37292,inst_37295,null));
var inst_37297__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37291,inst_37296);
var state_37439__$1 = (function (){var statearr_37441 = state_37439;
(statearr_37441[(9)] = inst_37290);

(statearr_37441[(8)] = inst_37297__$1);

return statearr_37441;
})();
if(cljs.core.truth_(inst_37297__$1)){
var statearr_37442_37608 = state_37439__$1;
(statearr_37442_37608[(1)] = (68));

} else {
var statearr_37443_37609 = state_37439__$1;
(statearr_37443_37609[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (70))){
var inst_37290 = (state_37439[(9)]);
var inst_37315 = (state_37439[(2)]);
var inst_37316 = [inst_37315,offset_map];
var inst_37317 = (new cljs.core.PersistentVector(null,2,(5),inst_37290,inst_37316,null));
var state_37439__$1 = state_37439;
var statearr_37444_37610 = state_37439__$1;
(statearr_37444_37610[(2)] = inst_37317);

(statearr_37444_37610[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (62))){
var inst_37275 = (state_37439[(10)]);
var inst_37177 = (state_37439[(11)]);
var inst_37160 = (state_37439[(12)]);
var inst_37198 = (state_37439[(13)]);
var inst_37204 = (state_37439[(14)]);
var inst_37202 = (state_37439[(15)]);
var inst_37203 = (state_37439[(16)]);
var inst_37166 = (state_37439[(7)]);
var inst_37201 = (state_37439[(17)]);
var inst_37259 = (state_37439[(18)]);
var inst_37199 = (state_37439[(19)]);
var inst_37200 = (state_37439[(20)]);
var inst_37277 = (function (){var G__37261 = inst_37275;
var p = inst_37204;
var pred_spec__$1 = inst_37160;
var orderBy = inst_37202;
var nested_select_spec = inst_37259;
var multi_QMARK_ = inst_37199;
var limit = inst_37201;
var offset = inst_37203;
var k = inst_37177;
var map__37143 = inst_37198;
var pred_spec_SINGLEQUOTE_ = inst_37166;
var ref_QMARK_ = inst_37200;
return (function (n){
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,nested_select_spec,n) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n));
});
})();
var inst_37278 = (inst_37277.cljs$core$IFn$_invoke$arity$1 ? inst_37277.cljs$core$IFn$_invoke$arity$1(inst_37275) : inst_37277.call(null,inst_37275));
var state_37439__$1 = state_37439;
var statearr_37445_37611 = state_37439__$1;
(statearr_37445_37611[(2)] = inst_37278);

(statearr_37445_37611[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (74))){
var inst_37324 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
if(cljs.core.truth_(inst_37324)){
var statearr_37446_37612 = state_37439__$1;
(statearr_37446_37612[(1)] = (75));

} else {
var statearr_37447_37613 = state_37439__$1;
(statearr_37447_37613[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (7))){
var inst_37147 = (state_37439[(21)]);
var state_37439__$1 = state_37439;
var statearr_37448_37614 = state_37439__$1;
(statearr_37448_37614[(2)] = inst_37147);

(statearr_37448_37614[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (59))){
var inst_37269 = (state_37439[(22)]);
var inst_37271 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_37272 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_37271,inst_37269);
var state_37439__$1 = state_37439;
var statearr_37449_37615 = state_37439__$1;
(statearr_37449_37615[(2)] = inst_37272);

(statearr_37449_37615[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (86))){
var inst_37355 = (state_37439[(23)]);
var inst_37177 = (state_37439[(11)]);
var inst_37160 = (state_37439[(12)]);
var inst_37198 = (state_37439[(13)]);
var inst_37204 = (state_37439[(14)]);
var inst_37337 = (state_37439[(24)]);
var inst_37202 = (state_37439[(15)]);
var inst_37203 = (state_37439[(16)]);
var inst_37166 = (state_37439[(7)]);
var inst_37201 = (state_37439[(17)]);
var inst_37199 = (state_37439[(19)]);
var inst_37200 = (state_37439[(20)]);
var inst_37357 = (function (){var p = inst_37204;
var pred_spec__$1 = inst_37160;
var orderBy = inst_37202;
var children = inst_37337;
var multi_QMARK_ = inst_37199;
var limit = inst_37201;
var offset = inst_37203;
var k = inst_37177;
var G__37349 = inst_37355;
var map__37143 = inst_37198;
var pred_spec_SINGLEQUOTE_ = inst_37166;
var ref_QMARK_ = inst_37200;
return (function (n){
var G__37450 = db;
var G__37451 = cache;
var G__37452 = fuel;
var G__37453 = max_fuel;
var G__37454 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$wildcard_QMARK_,true], null);
var G__37455 = n;
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(G__37450,G__37451,G__37452,G__37453,G__37454,G__37455) : fluree.db.query.fql.flakes__GT_res.call(null,G__37450,G__37451,G__37452,G__37453,G__37454,G__37455));
});
})();
var inst_37358 = (inst_37357.cljs$core$IFn$_invoke$arity$1 ? inst_37357.cljs$core$IFn$_invoke$arity$1(inst_37355) : inst_37357.call(null,inst_37355));
var state_37439__$1 = state_37439;
var statearr_37456_37616 = state_37439__$1;
(statearr_37456_37616[(2)] = inst_37358);

(statearr_37456_37616[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (20))){
var inst_37175 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37457_37617 = state_37439__$1;
(statearr_37457_37617[(2)] = inst_37175);

(statearr_37457_37617[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (72))){
var inst_37166 = (state_37439[(7)]);
var inst_37321 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37166);
var state_37439__$1 = state_37439;
var statearr_37458_37618 = state_37439__$1;
(statearr_37458_37618[(2)] = inst_37321);

(statearr_37458_37618[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (58))){
var inst_37268 = (state_37439[(2)]);
var inst_37269 = fluree.db.util.async.throw_err(inst_37268);
var state_37439__$1 = (function (){var statearr_37459 = state_37439;
(statearr_37459[(22)] = inst_37269);

return statearr_37459;
})();
if(cljs.core.truth_(fuel)){
var statearr_37460_37619 = state_37439__$1;
(statearr_37460_37619[(1)] = (59));

} else {
var statearr_37461_37620 = state_37439__$1;
(statearr_37461_37620[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (60))){
var inst_37269 = (state_37439[(22)]);
var state_37439__$1 = state_37439;
var statearr_37462_37621 = state_37439__$1;
(statearr_37462_37621[(2)] = inst_37269);

(statearr_37462_37621[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (27))){
var inst_37166 = (state_37439[(7)]);
var inst_37195 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37166);
var state_37439__$1 = state_37439;
var statearr_37463_37622 = state_37439__$1;
(statearr_37463_37622[(2)] = inst_37195);

(statearr_37463_37622[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (1))){
var state_37439__$1 = state_37439;
var statearr_37464_37623 = state_37439__$1;
(statearr_37464_37623[(2)] = null);

(statearr_37464_37623[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (69))){
var inst_37166 = (state_37439[(7)]);
var inst_37300 = flake.o;
var inst_37301 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37166);
var inst_37302 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_37300,inst_37301);
var state_37439__$1 = state_37439;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37439__$1,(71),inst_37302);
} else {
if((state_val_37440 === (101))){
var inst_37399 = (state_37439[(25)]);
var inst_37177 = (state_37439[(11)]);
var inst_37400 = (state_37439[(26)]);
var inst_37419 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37420 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_37177,inst_37399);
var inst_37421 = [inst_37420,inst_37400];
var inst_37422 = (new cljs.core.PersistentVector(null,2,(5),inst_37419,inst_37421,null));
var state_37439__$1 = state_37439;
var statearr_37465_37624 = state_37439__$1;
(statearr_37465_37624[(2)] = inst_37422);

(statearr_37465_37624[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (24))){
var state_37439__$1 = state_37439;
var statearr_37466_37625 = state_37439__$1;
(statearr_37466_37625[(2)] = true);

(statearr_37466_37625[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (102))){
var state_37439__$1 = state_37439;
var statearr_37467_37626 = state_37439__$1;
(statearr_37467_37626[(1)] = (104));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (55))){
var inst_37166 = (state_37439[(7)]);
var inst_37288 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37166);
var state_37439__$1 = state_37439;
if(cljs.core.truth_(inst_37288)){
var statearr_37469_37627 = state_37439__$1;
(statearr_37469_37627[(1)] = (65));

} else {
var statearr_37470_37628 = state_37439__$1;
(statearr_37470_37628[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (85))){
var inst_37355 = (state_37439[(2)]);
var state_37439__$1 = (function (){var statearr_37471 = state_37439;
(statearr_37471[(23)] = inst_37355);

return statearr_37471;
})();
var statearr_37472_37629 = state_37439__$1;
(statearr_37472_37629[(1)] = (86));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (39))){
var inst_37204 = (state_37439[(14)]);
var inst_37221 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_37204,cljs.core.dec);
var state_37439__$1 = state_37439;
var statearr_37474_37630 = state_37439__$1;
(statearr_37474_37630[(2)] = inst_37221);

(statearr_37474_37630[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (88))){
var inst_37361 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37439__$1,(82),inst_37361);
} else {
if((state_val_37440 === (46))){
var inst_37244 = cljs.core.not(recur_QMARK_);
var state_37439__$1 = state_37439;
if(inst_37244){
var statearr_37475_37631 = state_37439__$1;
(statearr_37475_37631[(1)] = (48));

} else {
var statearr_37476_37632 = state_37439__$1;
(statearr_37476_37632[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (4))){
var inst_37137 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37477_37633 = state_37439__$1;
(statearr_37477_37633[(2)] = inst_37137);

(statearr_37477_37633[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (77))){
var inst_37390 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37478_37634 = state_37439__$1;
(statearr_37478_37634[(2)] = inst_37390);

(statearr_37478_37634[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (106))){
var inst_37430 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37479_37635 = state_37439__$1;
(statearr_37479_37635[(2)] = inst_37430);

(statearr_37479_37635[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (95))){
var inst_37199 = (state_37439[(19)]);
var state_37439__$1 = state_37439;
var statearr_37480_37636 = state_37439__$1;
(statearr_37480_37636[(2)] = inst_37199);

(statearr_37480_37636[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (54))){
var inst_37166 = (state_37439[(7)]);
var inst_37256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37257 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_37258 = (new cljs.core.PersistentVector(null,3,(5),inst_37256,inst_37257,null));
var inst_37259 = cljs.core.select_keys(inst_37166,inst_37258);
var inst_37260 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37262 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37263 = flake.o;
var inst_37264 = [inst_37263];
var inst_37265 = (new cljs.core.PersistentVector(null,1,(5),inst_37262,inst_37264,null));
var inst_37266 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_37265);
var state_37439__$1 = (function (){var statearr_37481 = state_37439;
(statearr_37481[(27)] = inst_37260);

(statearr_37481[(18)] = inst_37259);

return statearr_37481;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37439__$1,(58),inst_37266);
} else {
if((state_val_37440 === (92))){
var inst_37380 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37381 = flake.o;
var inst_37382 = [inst_37381,offset_map];
var inst_37383 = (new cljs.core.PersistentVector(null,2,(5),inst_37380,inst_37382,null));
var state_37439__$1 = state_37439;
var statearr_37482_37637 = state_37439__$1;
(statearr_37482_37637[(2)] = inst_37383);

(statearr_37482_37637[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (104))){
var inst_37400 = (state_37439[(26)]);
var inst_37425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37426 = [acc,inst_37400];
var inst_37427 = (new cljs.core.PersistentVector(null,2,(5),inst_37425,inst_37426,null));
var state_37439__$1 = state_37439;
var statearr_37483_37638 = state_37439__$1;
(statearr_37483_37638[(2)] = inst_37427);

(statearr_37483_37638[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (15))){
var inst_37167 = (state_37439[(28)]);
var state_37439__$1 = state_37439;
var statearr_37484_37639 = state_37439__$1;
(statearr_37484_37639[(2)] = inst_37167);

(statearr_37484_37639[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (48))){
var inst_37246 = (state_37439[(29)]);
var inst_37166 = (state_37439[(7)]);
var inst_37246__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_37166);
var state_37439__$1 = (function (){var statearr_37485 = state_37439;
(statearr_37485[(29)] = inst_37246__$1);

return statearr_37485;
})();
if(cljs.core.truth_(inst_37246__$1)){
var statearr_37486_37640 = state_37439__$1;
(statearr_37486_37640[(1)] = (51));

} else {
var statearr_37487_37641 = state_37439__$1;
(statearr_37487_37641[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (50))){
var inst_37254 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
if(cljs.core.truth_(inst_37254)){
var statearr_37488_37642 = state_37439__$1;
(statearr_37488_37642[(1)] = (54));

} else {
var statearr_37489_37643 = state_37439__$1;
(statearr_37489_37643[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (75))){
var inst_37166 = (state_37439[(7)]);
var inst_37326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37327 = flake.o;
var inst_37328 = [inst_37327];
var inst_37329 = (new cljs.core.PersistentVector(null,1,(5),inst_37326,inst_37328,null));
var inst_37330 = [cljs.core.cst$kw$limit];
var inst_37331 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_37166);
var inst_37332 = [inst_37331];
var inst_37333 = cljs.core.PersistentHashMap.fromArrays(inst_37330,inst_37332);
var inst_37334 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_37329,inst_37333);
var state_37439__$1 = state_37439;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37439__$1,(78),inst_37334);
} else {
if((state_val_37440 === (99))){
var inst_37399 = (state_37439[(25)]);
var inst_37416 = (inst_37399 == null);
var inst_37417 = cljs.core.not(inst_37416);
var state_37439__$1 = state_37439;
if(inst_37417){
var statearr_37490_37644 = state_37439__$1;
(statearr_37490_37644[(1)] = (101));

} else {
var statearr_37491_37645 = state_37439__$1;
(statearr_37491_37645[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (21))){
var inst_37166 = (state_37439[(7)]);
var inst_37182 = inst_37166.cljs$lang$protocol_mask$partition0$;
var inst_37183 = (inst_37182 & (64));
var inst_37184 = inst_37166.cljs$core$ISeq$;
var inst_37185 = (cljs.core.PROTOCOL_SENTINEL === inst_37184);
var inst_37186 = ((inst_37183) || (inst_37185));
var state_37439__$1 = state_37439;
if(cljs.core.truth_(inst_37186)){
var statearr_37492_37646 = state_37439__$1;
(statearr_37492_37646[(1)] = (24));

} else {
var statearr_37493_37647 = state_37439__$1;
(statearr_37493_37647[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (31))){
var inst_37199 = (state_37439[(19)]);
var state_37439__$1 = state_37439;
var statearr_37494_37648 = state_37439__$1;
(statearr_37494_37648[(2)] = inst_37199);

(statearr_37494_37648[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (32))){
var inst_37216 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
if(cljs.core.truth_(inst_37216)){
var statearr_37495_37649 = state_37439__$1;
(statearr_37495_37649[(1)] = (36));

} else {
var statearr_37496_37650 = state_37439__$1;
(statearr_37496_37650[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (40))){
var inst_37204 = (state_37439[(14)]);
var inst_37203 = (state_37439[(16)]);
var inst_37223 = (inst_37203 - (1));
var inst_37224 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_37204,inst_37223);
var state_37439__$1 = state_37439;
var statearr_37497_37651 = state_37439__$1;
(statearr_37497_37651[(2)] = inst_37224);

(statearr_37497_37651[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (91))){
var inst_37388 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37498_37652 = state_37439__$1;
(statearr_37498_37652[(2)] = inst_37388);

(statearr_37498_37652[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (56))){
var inst_37394 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37499_37653 = state_37439__$1;
(statearr_37499_37653[(2)] = inst_37394);

(statearr_37499_37653[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (33))){
var inst_37204 = (state_37439[(14)]);
var inst_37203 = (state_37439[(16)]);
var inst_37207 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_37203);
var inst_37208 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_37204);
var inst_37209 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_37208);
var inst_37210 = ((inst_37207) && (inst_37209));
var state_37439__$1 = state_37439;
var statearr_37500_37654 = state_37439__$1;
(statearr_37500_37654[(2)] = inst_37210);

(statearr_37500_37654[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (13))){
var inst_37160 = (state_37439[(12)]);
var inst_37164 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37160,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_37439__$1 = state_37439;
var statearr_37501_37655 = state_37439__$1;
(statearr_37501_37655[(2)] = inst_37164);

(statearr_37501_37655[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (22))){
var state_37439__$1 = state_37439;
var statearr_37502_37656 = state_37439__$1;
(statearr_37502_37656[(2)] = false);

(statearr_37502_37656[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (90))){
var state_37439__$1 = state_37439;
var statearr_37503_37657 = state_37439__$1;
(statearr_37503_37657[(1)] = (92));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (36))){
var inst_37204 = (state_37439[(14)]);
var inst_37218 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37219 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_37204);
var state_37439__$1 = (function (){var statearr_37505 = state_37439;
(statearr_37505[(30)] = inst_37218);

return statearr_37505;
})();
if(cljs.core.truth_(inst_37219)){
var statearr_37506_37658 = state_37439__$1;
(statearr_37506_37658[(1)] = (39));

} else {
var statearr_37507_37659 = state_37439__$1;
(statearr_37507_37659[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (41))){
var inst_37218 = (state_37439[(30)]);
var inst_37226 = (state_37439[(2)]);
var inst_37227 = [null,inst_37226];
var inst_37228 = (new cljs.core.PersistentVector(null,2,(5),inst_37218,inst_37227,null));
var state_37439__$1 = state_37439;
var statearr_37508_37660 = state_37439__$1;
(statearr_37508_37660[(2)] = inst_37228);

(statearr_37508_37660[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (89))){
var inst_37371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37372 = ["_id"];
var inst_37373 = flake.o;
var inst_37374 = [inst_37373];
var inst_37375 = cljs.core.PersistentHashMap.fromArrays(inst_37372,inst_37374);
var inst_37376 = [inst_37375,offset_map];
var inst_37377 = (new cljs.core.PersistentVector(null,2,(5),inst_37371,inst_37376,null));
var state_37439__$1 = state_37439;
var statearr_37509_37661 = state_37439__$1;
(statearr_37509_37661[(2)] = inst_37377);

(statearr_37509_37661[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (100))){
var inst_37434 = (state_37439[(2)]);
var _ = (function (){var statearr_37510 = state_37439;
(statearr_37510[(4)] = cljs.core.rest((state_37439[(4)])));

return statearr_37510;
})();
var state_37439__$1 = state_37439;
var statearr_37511_37662 = state_37439__$1;
(statearr_37511_37662[(2)] = inst_37434);

(statearr_37511_37662[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (43))){
var inst_37199 = (state_37439[(19)]);
var state_37439__$1 = state_37439;
var statearr_37512_37663 = state_37439__$1;
(statearr_37512_37663[(2)] = inst_37199);

(statearr_37512_37663[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (61))){
var inst_37275 = (state_37439[(2)]);
var state_37439__$1 = (function (){var statearr_37513 = state_37439;
(statearr_37513[(10)] = inst_37275);

return statearr_37513;
})();
var statearr_37514_37664 = state_37439__$1;
(statearr_37514_37664[(1)] = (62));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (29))){
var inst_37198 = (state_37439[(13)]);
var inst_37199 = (state_37439[(19)]);
var inst_37198__$1 = (state_37439[(2)]);
var inst_37199__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37198__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_37200 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37198__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_37201 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37198__$1,cljs.core.cst$kw$limit);
var inst_37202 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37198__$1,cljs.core.cst$kw$orderBy);
var inst_37203 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37198__$1,cljs.core.cst$kw$offset);
var inst_37204 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37198__$1,cljs.core.cst$kw$p);
var state_37439__$1 = (function (){var statearr_37516 = state_37439;
(statearr_37516[(13)] = inst_37198__$1);

(statearr_37516[(14)] = inst_37204);

(statearr_37516[(15)] = inst_37202);

(statearr_37516[(16)] = inst_37203);

(statearr_37516[(17)] = inst_37201);

(statearr_37516[(19)] = inst_37199__$1);

(statearr_37516[(20)] = inst_37200);

return statearr_37516;
})();
if(cljs.core.truth_(inst_37199__$1)){
var statearr_37517_37665 = state_37439__$1;
(statearr_37517_37665[(1)] = (30));

} else {
var statearr_37518_37666 = state_37439__$1;
(statearr_37518_37666[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (44))){
var inst_37238 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
if(cljs.core.truth_(inst_37238)){
var statearr_37519_37667 = state_37439__$1;
(statearr_37519_37667[(1)] = (45));

} else {
var statearr_37520_37668 = state_37439__$1;
(statearr_37520_37668[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (93))){
var state_37439__$1 = state_37439;
var statearr_37521_37669 = state_37439__$1;
(statearr_37521_37669[(2)] = null);

(statearr_37521_37669[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (6))){
var inst_37149 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_37150 = (inst_37149 == null);
var state_37439__$1 = state_37439;
var statearr_37522_37670 = state_37439__$1;
(statearr_37522_37670[(2)] = inst_37150);

(statearr_37522_37670[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (28))){
var inst_37166 = (state_37439[(7)]);
var state_37439__$1 = state_37439;
var statearr_37523_37671 = state_37439__$1;
(statearr_37523_37671[(2)] = inst_37166);

(statearr_37523_37671[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (64))){
var inst_37281 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37439__$1,(57),inst_37281);
} else {
if((state_val_37440 === (103))){
var inst_37432 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37524_37672 = state_37439__$1;
(statearr_37524_37672[(2)] = inst_37432);

(statearr_37524_37672[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (51))){
var inst_37246 = (state_37439[(29)]);
var state_37439__$1 = state_37439;
var statearr_37525_37673 = state_37439__$1;
(statearr_37525_37673[(2)] = inst_37246);

(statearr_37525_37673[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (25))){
var state_37439__$1 = state_37439;
var statearr_37526_37674 = state_37439__$1;
(statearr_37526_37674[(2)] = false);

(statearr_37526_37674[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (34))){
var inst_37203 = (state_37439[(16)]);
var state_37439__$1 = state_37439;
var statearr_37527_37675 = state_37439__$1;
(statearr_37527_37675[(2)] = inst_37203);

(statearr_37527_37675[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (17))){
var inst_37166 = (state_37439[(7)]);
var inst_37177 = (state_37439[(2)]);
var inst_37179 = (inst_37166 == null);
var inst_37180 = cljs.core.not(inst_37179);
var state_37439__$1 = (function (){var statearr_37528 = state_37439;
(statearr_37528[(11)] = inst_37177);

return statearr_37528;
})();
if(inst_37180){
var statearr_37529_37676 = state_37439__$1;
(statearr_37529_37676[(1)] = (21));

} else {
var statearr_37530_37677 = state_37439__$1;
(statearr_37530_37677[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (3))){
var inst_37437 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37439__$1,inst_37437);
} else {
if((state_val_37440 === (12))){
var inst_37160 = (state_37439[(12)]);
var state_37439__$1 = state_37439;
var statearr_37531_37678 = state_37439__$1;
(statearr_37531_37678[(2)] = inst_37160);

(statearr_37531_37678[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (2))){
var inst_37147 = (state_37439[(21)]);
var _ = (function (){var statearr_37532 = state_37439;
(statearr_37532[(4)] = cljs.core.cons((5),(state_37439[(4)])));

return statearr_37532;
})();
var inst_37147__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_37439__$1 = (function (){var statearr_37533 = state_37439;
(statearr_37533[(21)] = inst_37147__$1);

return statearr_37533;
})();
if(cljs.core.truth_(inst_37147__$1)){
var statearr_37534_37679 = state_37439__$1;
(statearr_37534_37679[(1)] = (6));

} else {
var statearr_37535_37680 = state_37439__$1;
(statearr_37535_37680[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (66))){
var inst_37319 = (state_37439[(31)]);
var inst_37319__$1 = componentFollow_QMARK_;
var state_37439__$1 = (function (){var statearr_37536 = state_37439;
(statearr_37536[(31)] = inst_37319__$1);

return statearr_37536;
})();
if(cljs.core.truth_(inst_37319__$1)){
var statearr_37537_37681 = state_37439__$1;
(statearr_37537_37681[(1)] = (72));

} else {
var statearr_37538_37682 = state_37439__$1;
(statearr_37538_37682[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (23))){
var inst_37193 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
if(cljs.core.truth_(inst_37193)){
var statearr_37539_37683 = state_37439__$1;
(statearr_37539_37683[(1)] = (27));

} else {
var statearr_37540_37684 = state_37439__$1;
(statearr_37540_37684[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (47))){
var inst_37396 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37541_37685 = state_37439__$1;
(statearr_37541_37685[(2)] = inst_37396);

(statearr_37541_37685[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (35))){
var inst_37213 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37542_37686 = state_37439__$1;
(statearr_37542_37686[(2)] = inst_37213);

(statearr_37542_37686[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (82))){
var inst_37348 = (state_37439[(32)]);
var inst_37363 = (state_37439[(2)]);
var inst_37364 = fluree.db.util.async.throw_err(inst_37363);
var inst_37365 = [inst_37364,offset_map];
var inst_37366 = (new cljs.core.PersistentVector(null,2,(5),inst_37348,inst_37365,null));
var state_37439__$1 = state_37439;
var statearr_37543_37687 = state_37439__$1;
(statearr_37543_37687[(2)] = inst_37366);

(statearr_37543_37687[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (76))){
var inst_37200 = (state_37439[(20)]);
var state_37439__$1 = state_37439;
if(cljs.core.truth_(inst_37200)){
var statearr_37544_37688 = state_37439__$1;
(statearr_37544_37688[(1)] = (89));

} else {
var statearr_37545_37689 = state_37439__$1;
(statearr_37545_37689[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (97))){
var inst_37406 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
if(cljs.core.truth_(inst_37406)){
var statearr_37546_37690 = state_37439__$1;
(statearr_37546_37690[(1)] = (98));

} else {
var statearr_37547_37691 = state_37439__$1;
(statearr_37547_37691[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (19))){
var inst_37166 = (state_37439[(7)]);
var inst_37173 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_37166);
var state_37439__$1 = state_37439;
var statearr_37548_37692 = state_37439__$1;
(statearr_37548_37692[(2)] = inst_37173);

(statearr_37548_37692[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (57))){
var inst_37260 = (state_37439[(27)]);
var inst_37283 = (state_37439[(2)]);
var inst_37284 = fluree.db.util.async.throw_err(inst_37283);
var inst_37285 = [inst_37284,offset_map];
var inst_37286 = (new cljs.core.PersistentVector(null,2,(5),inst_37260,inst_37285,null));
var state_37439__$1 = state_37439;
var statearr_37549_37693 = state_37439__$1;
(statearr_37549_37693[(2)] = inst_37286);

(statearr_37549_37693[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (68))){
var inst_37297 = (state_37439[(8)]);
var state_37439__$1 = state_37439;
var statearr_37550_37694 = state_37439__$1;
(statearr_37550_37694[(2)] = inst_37297);

(statearr_37550_37694[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (11))){
var inst_37160 = (state_37439[(12)]);
var inst_37160__$1 = (state_37439[(2)]);
var inst_37161 = cljs.core.contains_QMARK_(inst_37160__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var state_37439__$1 = (function (){var statearr_37552 = state_37439;
(statearr_37552[(12)] = inst_37160__$1);

return statearr_37552;
})();
if(inst_37161){
var statearr_37553_37695 = state_37439__$1;
(statearr_37553_37695[(1)] = (12));

} else {
var statearr_37554_37696 = state_37439__$1;
(statearr_37554_37696[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (9))){
var inst_37155 = flake.p;
var inst_37156 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_37157 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_37155,inst_37156);
var state_37439__$1 = state_37439;
var statearr_37555_37697 = state_37439__$1;
(statearr_37555_37697[(2)] = inst_37157);

(statearr_37555_37697[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (5))){
var _ = (function (){var statearr_37556 = state_37439;
(statearr_37556[(4)] = cljs.core.rest((state_37439[(4)])));

return statearr_37556;
})();
var state_37439__$1 = state_37439;
var ex37551 = (state_37439__$1[(2)]);
var statearr_37557_37698 = state_37439__$1;
(statearr_37557_37698[(5)] = ex37551);


if((ex37551 instanceof Error)){
var statearr_37558_37699 = state_37439__$1;
(statearr_37558_37699[(1)] = (4));

(statearr_37558_37699[(5)] = null);

} else {
throw ex37551;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (83))){
var inst_37337 = (state_37439[(24)]);
var inst_37351 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_37352 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_37351,inst_37337);
var state_37439__$1 = state_37439;
var statearr_37559_37700 = state_37439__$1;
(statearr_37559_37700[(2)] = inst_37352);

(statearr_37559_37700[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (14))){
var inst_37166 = (state_37439[(7)]);
var inst_37167 = (state_37439[(28)]);
var inst_37166__$1 = (state_37439[(2)]);
var inst_37167__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_37166__$1);
var state_37439__$1 = (function (){var statearr_37560 = state_37439;
(statearr_37560[(7)] = inst_37166__$1);

(statearr_37560[(28)] = inst_37167__$1);

return statearr_37560;
})();
if(cljs.core.truth_(inst_37167__$1)){
var statearr_37561_37701 = state_37439__$1;
(statearr_37561_37701[(1)] = (15));

} else {
var statearr_37562_37702 = state_37439__$1;
(statearr_37562_37702[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (45))){
var inst_37240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37241 = [null,offset_map];
var inst_37242 = (new cljs.core.PersistentVector(null,2,(5),inst_37240,inst_37241,null));
var state_37439__$1 = state_37439;
var statearr_37563_37703 = state_37439__$1;
(statearr_37563_37703[(2)] = inst_37242);

(statearr_37563_37703[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (53))){
var inst_37251 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37564_37704 = state_37439__$1;
(statearr_37564_37704[(2)] = inst_37251);

(statearr_37564_37704[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (78))){
var inst_37337 = (state_37439[(24)]);
var inst_37336 = (state_37439[(2)]);
var inst_37337__$1 = fluree.db.util.async.throw_err(inst_37336);
var inst_37338 = cljs.core.empty_QMARK_(inst_37337__$1);
var state_37439__$1 = (function (){var statearr_37565 = state_37439;
(statearr_37565[(24)] = inst_37337__$1);

return statearr_37565;
})();
if(inst_37338){
var statearr_37566_37705 = state_37439__$1;
(statearr_37566_37705[(1)] = (79));

} else {
var statearr_37567_37706 = state_37439__$1;
(statearr_37567_37706[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (26))){
var inst_37190 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37568_37707 = state_37439__$1;
(statearr_37568_37707[(2)] = inst_37190);

(statearr_37568_37707[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (16))){
var inst_37170 = (state_37439[(33)]);
var inst_37166 = (state_37439[(7)]);
var inst_37170__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37166);
var state_37439__$1 = (function (){var statearr_37569 = state_37439;
(statearr_37569[(33)] = inst_37170__$1);

return statearr_37569;
})();
if(cljs.core.truth_(inst_37170__$1)){
var statearr_37570_37708 = state_37439__$1;
(statearr_37570_37708[(1)] = (18));

} else {
var statearr_37571_37709 = state_37439__$1;
(statearr_37571_37709[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (81))){
var inst_37368 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37572_37710 = state_37439__$1;
(statearr_37572_37710[(2)] = inst_37368);

(statearr_37572_37710[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (79))){
var inst_37340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37341 = ["_id"];
var inst_37342 = flake.o;
var inst_37343 = [inst_37342];
var inst_37344 = cljs.core.PersistentHashMap.fromArrays(inst_37341,inst_37343);
var inst_37345 = [inst_37344,offset_map];
var inst_37346 = (new cljs.core.PersistentVector(null,2,(5),inst_37340,inst_37345,null));
var state_37439__$1 = state_37439;
var statearr_37573_37711 = state_37439__$1;
(statearr_37573_37711[(2)] = inst_37346);

(statearr_37573_37711[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (38))){
var inst_37399 = (state_37439[(25)]);
var inst_37398 = (state_37439[(2)]);
var inst_37399__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37398,(0),null);
var inst_37400 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37398,(1),null);
var inst_37401 = (inst_37399__$1 == null);
var inst_37402 = cljs.core.not(inst_37401);
var state_37439__$1 = (function (){var statearr_37574 = state_37439;
(statearr_37574[(25)] = inst_37399__$1);

(statearr_37574[(26)] = inst_37400);

return statearr_37574;
})();
if(inst_37402){
var statearr_37575_37712 = state_37439__$1;
(statearr_37575_37712[(1)] = (95));

} else {
var statearr_37576_37713 = state_37439__$1;
(statearr_37576_37713[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (98))){
var inst_37399 = (state_37439[(25)]);
var inst_37177 = (state_37439[(11)]);
var inst_37400 = (state_37439[(26)]);
var inst_37408 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37409 = cljs.core.PersistentVector.EMPTY;
var inst_37410 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(acc,inst_37177,inst_37409);
var inst_37411 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37410,inst_37399);
var inst_37412 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_37177,inst_37411);
var inst_37413 = [inst_37412,inst_37400];
var inst_37414 = (new cljs.core.PersistentVector(null,2,(5),inst_37408,inst_37413,null));
var state_37439__$1 = state_37439;
var statearr_37577_37714 = state_37439__$1;
(statearr_37577_37714[(2)] = inst_37414);

(statearr_37577_37714[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (87))){
var inst_37355 = (state_37439[(23)]);
var state_37439__$1 = state_37439;
var statearr_37578_37715 = state_37439__$1;
(statearr_37578_37715[(2)] = inst_37355);

(statearr_37578_37715[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (30))){
var inst_37203 = (state_37439[(16)]);
var state_37439__$1 = state_37439;
if(cljs.core.truth_(inst_37203)){
var statearr_37579_37716 = state_37439__$1;
(statearr_37579_37716[(1)] = (33));

} else {
var statearr_37580_37717 = state_37439__$1;
(statearr_37580_37717[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (73))){
var inst_37319 = (state_37439[(31)]);
var state_37439__$1 = state_37439;
var statearr_37581_37718 = state_37439__$1;
(statearr_37581_37718[(2)] = inst_37319);

(statearr_37581_37718[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (96))){
var state_37439__$1 = state_37439;
var statearr_37582_37719 = state_37439__$1;
(statearr_37582_37719[(2)] = false);

(statearr_37582_37719[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (10))){
var state_37439__$1 = state_37439;
var statearr_37583_37720 = state_37439__$1;
(statearr_37583_37720[(2)] = pred_spec);

(statearr_37583_37720[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (18))){
var inst_37170 = (state_37439[(33)]);
var state_37439__$1 = state_37439;
var statearr_37584_37721 = state_37439__$1;
(statearr_37584_37721[(2)] = inst_37170);

(statearr_37584_37721[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (105))){
var state_37439__$1 = state_37439;
var statearr_37585_37722 = state_37439__$1;
(statearr_37585_37722[(2)] = null);

(statearr_37585_37722[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (52))){
var inst_37166 = (state_37439[(7)]);
var inst_37249 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37166);
var state_37439__$1 = state_37439;
var statearr_37586_37723 = state_37439__$1;
(statearr_37586_37723[(2)] = inst_37249);

(statearr_37586_37723[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (67))){
var inst_37392 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37587_37724 = state_37439__$1;
(statearr_37587_37724[(2)] = inst_37392);

(statearr_37587_37724[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (71))){
var inst_37166 = (state_37439[(7)]);
var inst_37304 = (state_37439[(2)]);
var inst_37305 = fluree.db.util.async.throw_err(inst_37304);
var inst_37306 = cljs.core._deref(cache);
var inst_37307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37308 = flake.o;
var inst_37309 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37166);
var inst_37310 = [inst_37308,inst_37309];
var inst_37311 = (new cljs.core.PersistentVector(null,2,(5),inst_37307,inst_37310,null));
var inst_37312 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37306,inst_37311,inst_37305);
var inst_37313 = cljs.core._vreset_BANG_(cache,inst_37312);
var state_37439__$1 = (function (){var statearr_37588 = state_37439;
(statearr_37588[(34)] = inst_37313);

return statearr_37588;
})();
var statearr_37589_37725 = state_37439__$1;
(statearr_37589_37725[(2)] = inst_37305);

(statearr_37589_37725[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (42))){
var inst_37177 = (state_37439[(11)]);
var inst_37202 = (state_37439[(15)]);
var inst_37201 = (state_37439[(17)]);
var inst_37231 = cljs.core.not(inst_37202);
var inst_37232 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_37177);
var inst_37233 = cljs.core.count(inst_37232);
var inst_37234 = (inst_37233 >= inst_37201);
var inst_37235 = ((inst_37231) && (inst_37234));
var state_37439__$1 = state_37439;
var statearr_37590_37726 = state_37439__$1;
(statearr_37590_37726[(2)] = inst_37235);

(statearr_37590_37726[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (80))){
var inst_37348 = cljs.core.PersistentVector.EMPTY_NODE;
var state_37439__$1 = (function (){var statearr_37591 = state_37439;
(statearr_37591[(32)] = inst_37348);

return statearr_37591;
})();
if(cljs.core.truth_(fuel)){
var statearr_37592_37727 = state_37439__$1;
(statearr_37592_37727[(1)] = (83));

} else {
var statearr_37593_37728 = state_37439__$1;
(statearr_37593_37728[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (37))){
var inst_37199 = (state_37439[(19)]);
var state_37439__$1 = state_37439;
if(cljs.core.truth_(inst_37199)){
var statearr_37594_37729 = state_37439__$1;
(statearr_37594_37729[(1)] = (42));

} else {
var statearr_37595_37730 = state_37439__$1;
(statearr_37595_37730[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (63))){
var inst_37275 = (state_37439[(10)]);
var state_37439__$1 = state_37439;
var statearr_37596_37731 = state_37439__$1;
(statearr_37596_37731[(2)] = inst_37275);

(statearr_37596_37731[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (94))){
var inst_37386 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
var statearr_37597_37732 = state_37439__$1;
(statearr_37597_37732[(2)] = inst_37386);

(statearr_37597_37732[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (8))){
var inst_37153 = (state_37439[(2)]);
var state_37439__$1 = state_37439;
if(cljs.core.truth_(inst_37153)){
var statearr_37598_37733 = state_37439__$1;
(statearr_37598_37733[(1)] = (9));

} else {
var statearr_37599_37734 = state_37439__$1;
(statearr_37599_37734[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (49))){
var state_37439__$1 = state_37439;
var statearr_37600_37735 = state_37439__$1;
(statearr_37600_37735[(2)] = false);

(statearr_37600_37735[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37440 === (84))){
var inst_37337 = (state_37439[(24)]);
var state_37439__$1 = state_37439;
var statearr_37601_37736 = state_37439__$1;
(statearr_37601_37736[(2)] = inst_37337);

(statearr_37601_37736[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16301__auto__ = null;
var fluree$db$query$fql$state_machine__16301__auto____0 = (function (){
var statearr_37602 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37602[(0)] = fluree$db$query$fql$state_machine__16301__auto__);

(statearr_37602[(1)] = (1));

return statearr_37602;
});
var fluree$db$query$fql$state_machine__16301__auto____1 = (function (state_37439){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_37439);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e37603){var ex__16304__auto__ = e37603;
var statearr_37604_37737 = state_37439;
(statearr_37604_37737[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_37439[(4)]))){
var statearr_37605_37738 = state_37439;
(statearr_37605_37738[(1)] = cljs.core.first((state_37439[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__37739 = state_37439;
state_37439 = G__37739;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16301__auto__ = function(state_37439){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16301__auto____1.call(this,state_37439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16301__auto____0;
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16301__auto____1;
return fluree$db$query$fql$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_37606 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_37606[(6)] = c__16375__auto__);

return statearr_37606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
}));
cljs.core._vreset_BANG_(cache,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_37919){
var state_val_37920 = (state_37919[(1)]);
if((state_val_37920 === (7))){
var inst_37914 = (state_37919[(2)]);
var _ = (function (){var statearr_37921 = state_37919;
(statearr_37921[(4)] = cljs.core.rest((state_37919[(4)])));

return statearr_37921;
})();
var state_37919__$1 = state_37919;
var statearr_37922_38017 = state_37919__$1;
(statearr_37922_38017[(2)] = inst_37914);

(statearr_37922_38017[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (59))){
var inst_37800 = (state_37919[(7)]);
var state_37919__$1 = state_37919;
var statearr_37923_38018 = state_37919__$1;
(statearr_37923_38018[(2)] = inst_37800);

(statearr_37923_38018[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (20))){
var inst_37809 = (state_37919[(8)]);
var inst_37806 = (state_37919[(2)]);
var inst_37807 = fluree.db.util.async.throw_err(inst_37806);
var inst_37808 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_37807);
var inst_37809__$1 = cljs.core.not_empty(inst_37808);
var state_37919__$1 = (function (){var statearr_37924 = state_37919;
(statearr_37924[(8)] = inst_37809__$1);

return statearr_37924;
})();
if(cljs.core.truth_(inst_37809__$1)){
var statearr_37925_38019 = state_37919__$1;
(statearr_37925_38019[(1)] = (21));

} else {
var statearr_37926_38020 = state_37919__$1;
(statearr_37926_38020[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (58))){
var inst_37799 = (state_37919[(9)]);
var state_37919__$1 = state_37919;
var statearr_37927_38021 = state_37919__$1;
(statearr_37927_38021[(2)] = inst_37799);

(statearr_37927_38021[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (60))){
var inst_37906 = (state_37919[(2)]);
var state_37919__$1 = state_37919;
var statearr_37928_38022 = state_37919__$1;
(statearr_37928_38022[(2)] = inst_37906);

(statearr_37928_38022[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (27))){
var inst_37841 = (state_37919[(10)]);
var inst_37831 = (state_37919[(11)]);
var inst_37839 = (state_37919[(12)]);
var inst_37838 = cljs.core.seq(inst_37831);
var inst_37839__$1 = cljs.core.first(inst_37838);
var inst_37840 = cljs.core.next(inst_37838);
var inst_37841__$1 = cljs.core.not(inst_37839__$1);
var state_37919__$1 = (function (){var statearr_37929 = state_37919;
(statearr_37929[(10)] = inst_37841__$1);

(statearr_37929[(13)] = inst_37840);

(statearr_37929[(12)] = inst_37839__$1);

return statearr_37929;
})();
if(inst_37841__$1){
var statearr_37930_38023 = state_37919__$1;
(statearr_37930_38023[(1)] = (29));

} else {
var statearr_37931_38024 = state_37919__$1;
(statearr_37931_38024[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (1))){
var state_37919__$1 = state_37919;
var statearr_37932_38025 = state_37919__$1;
(statearr_37932_38025[(2)] = null);

(statearr_37932_38025[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (24))){
var inst_37809 = (state_37919[(8)]);
var inst_37815 = cljs.core.count(inst_37809);
var inst_37816 = fluree.db.query.fql.add_fuel(fuel,inst_37815,max_fuel);
var state_37919__$1 = state_37919;
var statearr_37933_38026 = state_37919__$1;
(statearr_37933_38026[(2)] = inst_37816);

(statearr_37933_38026[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (55))){
var inst_37798 = (state_37919[(14)]);
var state_37919__$1 = state_37919;
var statearr_37934_38027 = state_37919__$1;
(statearr_37934_38027[(2)] = inst_37798);

(statearr_37934_38027[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (39))){
var inst_37796 = (state_37919[(15)]);
var state_37919__$1 = state_37919;
var statearr_37935_38028 = state_37919__$1;
(statearr_37935_38028[(2)] = inst_37796);

(statearr_37935_38028[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (46))){
var inst_37894 = (state_37919[(2)]);
var state_37919__$1 = state_37919;
var statearr_37936_38029 = state_37919__$1;
(statearr_37936_38029[(2)] = inst_37894);

(statearr_37936_38029[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (4))){
var inst_37740 = (state_37919[(2)]);
var state_37919__$1 = state_37919;
var statearr_37937_38030 = state_37919__$1;
(statearr_37937_38030[(2)] = inst_37740);

(statearr_37937_38030[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (54))){
var inst_37833 = (state_37919[(16)]);
var inst_37885 = (state_37919[(2)]);
var inst_37886 = fluree.db.util.async.throw_err(inst_37885);
var inst_37887 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37833,inst_37886);
var state_37919__$1 = state_37919;
var statearr_37938_38031 = state_37919__$1;
(statearr_37938_38031[(2)] = inst_37887);

(statearr_37938_38031[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (15))){
var state_37919__$1 = state_37919;
var statearr_37939_38032 = state_37919__$1;
(statearr_37939_38032[(2)] = false);

(statearr_37939_38032[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (48))){
var inst_37833 = (state_37919[(16)]);
var state_37919__$1 = state_37919;
var statearr_37940_38033 = state_37919__$1;
(statearr_37940_38033[(2)] = inst_37833);

(statearr_37940_38033[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (50))){
var inst_37840 = (state_37919[(13)]);
var inst_37832 = (state_37919[(17)]);
var inst_37889 = (state_37919[(2)]);
var inst_37890 = (inst_37832 + (1));
var inst_37831 = inst_37840;
var inst_37832__$1 = inst_37890;
var inst_37833 = inst_37889;
var state_37919__$1 = (function (){var statearr_37941 = state_37919;
(statearr_37941[(16)] = inst_37833);

(statearr_37941[(11)] = inst_37831);

(statearr_37941[(17)] = inst_37832__$1);

return statearr_37941;
})();
var statearr_37942_38034 = state_37919__$1;
(statearr_37942_38034[(2)] = null);

(statearr_37942_38034[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (21))){
var state_37919__$1 = state_37919;
var statearr_37943_38035 = state_37919__$1;
(statearr_37943_38035[(2)] = fuel);

(statearr_37943_38035[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (31))){
var inst_37850 = (state_37919[(2)]);
var state_37919__$1 = state_37919;
if(cljs.core.truth_(inst_37850)){
var statearr_37944_38036 = state_37919__$1;
(statearr_37944_38036[(1)] = (35));

} else {
var statearr_37945_38037 = state_37919__$1;
(statearr_37945_38037[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (32))){
var inst_37797 = (state_37919[(18)]);
var inst_37832 = (state_37919[(17)]);
var inst_37845 = (inst_37832 >= inst_37797);
var state_37919__$1 = state_37919;
var statearr_37946_38038 = state_37919__$1;
(statearr_37946_38038[(2)] = inst_37845);

(statearr_37946_38038[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (40))){
var inst_37857 = (state_37919[(2)]);
var state_37919__$1 = state_37919;
if(cljs.core.truth_(inst_37857)){
var statearr_37947_38039 = state_37919__$1;
(statearr_37947_38039[(1)] = (41));

} else {
var statearr_37948_38040 = state_37919__$1;
(statearr_37948_38040[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (56))){
var inst_37799 = (state_37919[(9)]);
var state_37919__$1 = state_37919;
if(cljs.core.truth_(inst_37799)){
var statearr_37949_38041 = state_37919__$1;
(statearr_37949_38041[(1)] = (58));

} else {
var statearr_37950_38042 = state_37919__$1;
(statearr_37950_38042[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (33))){
var inst_37797 = (state_37919[(18)]);
var state_37919__$1 = state_37919;
var statearr_37951_38043 = state_37919__$1;
(statearr_37951_38043[(2)] = inst_37797);

(statearr_37951_38043[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (13))){
var inst_37790 = (state_37919[(2)]);
var state_37919__$1 = state_37919;
if(cljs.core.truth_(inst_37790)){
var statearr_37952_38044 = state_37919__$1;
(statearr_37952_38044[(1)] = (17));

} else {
var statearr_37953_38045 = state_37919__$1;
(statearr_37953_38045[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (22))){
var inst_37809 = (state_37919[(8)]);
var state_37919__$1 = state_37919;
var statearr_37955_38046 = state_37919__$1;
(statearr_37955_38046[(2)] = inst_37809);

(statearr_37955_38046[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (36))){
var inst_37796 = (state_37919[(15)]);
var state_37919__$1 = state_37919;
if(cljs.core.truth_(inst_37796)){
var statearr_37956_38047 = state_37919__$1;
(statearr_37956_38047[(1)] = (38));

} else {
var statearr_37957_38048 = state_37919__$1;
(statearr_37957_38048[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (41))){
var inst_37833 = (state_37919[(16)]);
var inst_37840 = (state_37919[(13)]);
var inst_37832 = (state_37919[(17)]);
var inst_37859 = (inst_37832 + (1));
var tmp37954 = inst_37833;
var inst_37831 = inst_37840;
var inst_37832__$1 = inst_37859;
var inst_37833__$1 = tmp37954;
var state_37919__$1 = (function (){var statearr_37958 = state_37919;
(statearr_37958[(16)] = inst_37833__$1);

(statearr_37958[(11)] = inst_37831);

(statearr_37958[(17)] = inst_37832__$1);

return statearr_37958;
})();
var statearr_37959_38049 = state_37919__$1;
(statearr_37959_38049[(2)] = null);

(statearr_37959_38049[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (43))){
var inst_37896 = (state_37919[(2)]);
var state_37919__$1 = state_37919;
var statearr_37960_38050 = state_37919__$1;
(statearr_37960_38050[(2)] = inst_37896);

(statearr_37960_38050[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (29))){
var inst_37841 = (state_37919[(10)]);
var state_37919__$1 = state_37919;
var statearr_37961_38051 = state_37919__$1;
(statearr_37961_38051[(2)] = inst_37841);

(statearr_37961_38051[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (44))){
var inst_37839 = (state_37919[(12)]);
var inst_37863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37864 = [inst_37839];
var inst_37865 = (new cljs.core.PersistentVector(null,1,(5),inst_37863,inst_37864,null));
var inst_37866 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_37865);
var state_37919__$1 = state_37919;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37919__$1,(47),inst_37866);
} else {
if((state_val_37920 === (6))){
var inst_37764 = (state_37919[(19)]);
var inst_37757 = (state_37919[(20)]);
var inst_37763 = cljs.core.seq(inst_37757);
var inst_37764__$1 = cljs.core.first(inst_37763);
var inst_37765 = cljs.core.next(inst_37763);
var inst_37766 = cljs.core.not(inst_37764__$1);
var state_37919__$1 = (function (){var statearr_37962 = state_37919;
(statearr_37962[(21)] = inst_37765);

(statearr_37962[(19)] = inst_37764__$1);

return statearr_37962;
})();
if(inst_37766){
var statearr_37963_38052 = state_37919__$1;
(statearr_37963_38052[(1)] = (8));

} else {
var statearr_37964_38053 = state_37919__$1;
(statearr_37964_38053[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (28))){
var inst_37798 = (state_37919[(14)]);
var inst_37900 = (state_37919[(2)]);
var state_37919__$1 = (function (){var statearr_37965 = state_37919;
(statearr_37965[(22)] = inst_37900);

return statearr_37965;
})();
if(cljs.core.truth_(inst_37798)){
var statearr_37966_38054 = state_37919__$1;
(statearr_37966_38054[(1)] = (55));

} else {
var statearr_37967_38055 = state_37919__$1;
(statearr_37967_38055[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (51))){
var inst_37869 = (state_37919[(23)]);
var inst_37878 = cljs.core.count(inst_37869);
var inst_37879 = fluree.db.query.fql.add_fuel(fuel,inst_37878,max_fuel);
var state_37919__$1 = state_37919;
var statearr_37968_38056 = state_37919__$1;
(statearr_37968_38056[(2)] = inst_37879);

(statearr_37968_38056[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (25))){
var state_37919__$1 = state_37919;
var statearr_37969_38057 = state_37919__$1;
(statearr_37969_38057[(2)] = null);

(statearr_37969_38057[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (34))){
var inst_37848 = (state_37919[(2)]);
var state_37919__$1 = state_37919;
var statearr_37970_38058 = state_37919__$1;
(statearr_37970_38058[(2)] = inst_37848);

(statearr_37970_38058[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (17))){
var inst_37774 = (state_37919[(24)]);
var inst_37792 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_37774);
var state_37919__$1 = state_37919;
var statearr_37971_38059 = state_37919__$1;
(statearr_37971_38059[(2)] = inst_37792);

(statearr_37971_38059[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (3))){
var inst_37917 = (state_37919[(2)]);
var state_37919__$1 = state_37919;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37919__$1,inst_37917);
} else {
if((state_val_37920 === (12))){
var state_37919__$1 = state_37919;
var statearr_37972_38060 = state_37919__$1;
(statearr_37972_38060[(2)] = false);

(statearr_37972_38060[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (2))){
var _ = (function (){var statearr_37973 = state_37919;
(statearr_37973[(4)] = cljs.core.cons((5),(state_37919[(4)])));

return statearr_37973;
})();
var inst_37753 = reverse_refs_specs;
var inst_37754 = cljs.core.seq(inst_37753);
var inst_37755 = cljs.core.first(inst_37754);
var inst_37756 = cljs.core.next(inst_37754);
var inst_37757 = inst_37753;
var inst_37758 = null;
var state_37919__$1 = (function (){var statearr_37974 = state_37919;
(statearr_37974[(25)] = inst_37758);

(statearr_37974[(26)] = inst_37755);

(statearr_37974[(20)] = inst_37757);

(statearr_37974[(27)] = inst_37756);

return statearr_37974;
})();
var statearr_37975_38061 = state_37919__$1;
(statearr_37975_38061[(2)] = null);

(statearr_37975_38061[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (23))){
var inst_37813 = (state_37919[(2)]);
var state_37919__$1 = state_37919;
if(cljs.core.truth_(inst_37813)){
var statearr_37976_38062 = state_37919__$1;
(statearr_37976_38062[(1)] = (24));

} else {
var statearr_37977_38063 = state_37919__$1;
(statearr_37977_38063[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (47))){
var inst_37869 = (state_37919[(23)]);
var inst_37774 = (state_37919[(24)]);
var inst_37868 = (state_37919[(2)]);
var inst_37869__$1 = fluree.db.util.async.throw_err(inst_37868);
var inst_37870 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37871 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_37872 = (new cljs.core.PersistentVector(null,4,(5),inst_37870,inst_37871,null));
var inst_37873 = cljs.core.select_keys(inst_37774,inst_37872);
var inst_37874 = cljs.core.empty_QMARK_(inst_37869__$1);
var state_37919__$1 = (function (){var statearr_37978 = state_37919;
(statearr_37978[(23)] = inst_37869__$1);

(statearr_37978[(28)] = inst_37873);

return statearr_37978;
})();
if(inst_37874){
var statearr_37979_38064 = state_37919__$1;
(statearr_37979_38064[(1)] = (48));

} else {
var statearr_37980_38065 = state_37919__$1;
(statearr_37980_38065[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (35))){
var inst_37833 = (state_37919[(16)]);
var state_37919__$1 = state_37919;
var statearr_37981_38066 = state_37919__$1;
(statearr_37981_38066[(2)] = inst_37833);

(statearr_37981_38066[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (19))){
var inst_37773 = (state_37919[(29)]);
var inst_37795 = (state_37919[(2)]);
var inst_37796 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37795,cljs.core.cst$kw$offset);
var inst_37797 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37795,cljs.core.cst$kw$limit);
var inst_37798 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37795,cljs.core.cst$kw$as);
var inst_37799 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37795,cljs.core.cst$kw$name);
var inst_37800 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37795,cljs.core.cst$kw$p);
var inst_37801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37802 = [subject_id,inst_37773];
var inst_37803 = (new cljs.core.PersistentVector(null,2,(5),inst_37801,inst_37802,null));
var inst_37804 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_37803);
var state_37919__$1 = (function (){var statearr_37982 = state_37919;
(statearr_37982[(15)] = inst_37796);

(statearr_37982[(18)] = inst_37797);

(statearr_37982[(14)] = inst_37798);

(statearr_37982[(7)] = inst_37800);

(statearr_37982[(9)] = inst_37799);

return statearr_37982;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37919__$1,(20),inst_37804);
} else {
if((state_val_37920 === (57))){
var inst_37765 = (state_37919[(21)]);
var inst_37758 = (state_37919[(25)]);
var inst_37900 = (state_37919[(22)]);
var inst_37908 = (state_37919[(2)]);
var inst_37909 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37758,inst_37908,inst_37900);
var inst_37757 = inst_37765;
var inst_37758__$1 = inst_37909;
var state_37919__$1 = (function (){var statearr_37983 = state_37919;
(statearr_37983[(25)] = inst_37758__$1);

(statearr_37983[(20)] = inst_37757);

return statearr_37983;
})();
var statearr_37984_38067 = state_37919__$1;
(statearr_37984_38067[(2)] = null);

(statearr_37984_38067[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (11))){
var inst_37774 = (state_37919[(24)]);
var inst_37779 = inst_37774.cljs$lang$protocol_mask$partition0$;
var inst_37780 = (inst_37779 & (64));
var inst_37781 = inst_37774.cljs$core$ISeq$;
var inst_37782 = (cljs.core.PROTOCOL_SENTINEL === inst_37781);
var inst_37783 = ((inst_37780) || (inst_37782));
var state_37919__$1 = state_37919;
if(cljs.core.truth_(inst_37783)){
var statearr_37986_38068 = state_37919__$1;
(statearr_37986_38068[(1)] = (14));

} else {
var statearr_37987_38069 = state_37919__$1;
(statearr_37987_38069[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (9))){
var inst_37764 = (state_37919[(19)]);
var inst_37774 = (state_37919[(24)]);
var inst_37773 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37764,(0),null);
var inst_37774__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37764,(1),null);
var inst_37776 = (inst_37774__$1 == null);
var inst_37777 = cljs.core.not(inst_37776);
var state_37919__$1 = (function (){var statearr_37988 = state_37919;
(statearr_37988[(29)] = inst_37773);

(statearr_37988[(24)] = inst_37774__$1);

return statearr_37988;
})();
if(inst_37777){
var statearr_37989_38070 = state_37919__$1;
(statearr_37989_38070[(1)] = (11));

} else {
var statearr_37990_38071 = state_37919__$1;
(statearr_37990_38071[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (5))){
var _ = (function (){var statearr_37991 = state_37919;
(statearr_37991[(4)] = cljs.core.rest((state_37919[(4)])));

return statearr_37991;
})();
var state_37919__$1 = state_37919;
var ex37985 = (state_37919__$1[(2)]);
var statearr_37992_38072 = state_37919__$1;
(statearr_37992_38072[(5)] = ex37985);


if((ex37985 instanceof Error)){
var statearr_37993_38073 = state_37919__$1;
(statearr_37993_38073[(1)] = (4));

(statearr_37993_38073[(5)] = null);

} else {
throw ex37985;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (14))){
var state_37919__$1 = state_37919;
var statearr_37994_38074 = state_37919__$1;
(statearr_37994_38074[(2)] = true);

(statearr_37994_38074[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (45))){
var state_37919__$1 = state_37919;
var statearr_37995_38075 = state_37919__$1;
(statearr_37995_38075[(2)] = null);

(statearr_37995_38075[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (53))){
var inst_37869 = (state_37919[(23)]);
var inst_37873 = (state_37919[(28)]);
var inst_37882 = (state_37919[(2)]);
var inst_37883 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_37873,inst_37869) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_37873,inst_37869));
var state_37919__$1 = (function (){var statearr_37996 = state_37919;
(statearr_37996[(30)] = inst_37882);

return statearr_37996;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37919__$1,(54),inst_37883);
} else {
if((state_val_37920 === (26))){
var inst_37809 = (state_37919[(8)]);
var inst_37819 = (state_37919[(2)]);
var inst_37827 = cljs.core.seq(inst_37809);
var inst_37828 = cljs.core.first(inst_37827);
var inst_37829 = cljs.core.next(inst_37827);
var inst_37830 = cljs.core.PersistentVector.EMPTY;
var inst_37831 = inst_37809;
var inst_37832 = (0);
var inst_37833 = inst_37830;
var state_37919__$1 = (function (){var statearr_37997 = state_37919;
(statearr_37997[(16)] = inst_37833);

(statearr_37997[(31)] = inst_37819);

(statearr_37997[(32)] = inst_37828);

(statearr_37997[(11)] = inst_37831);

(statearr_37997[(33)] = inst_37829);

(statearr_37997[(17)] = inst_37832);

return statearr_37997;
})();
var statearr_37998_38076 = state_37919__$1;
(statearr_37998_38076[(2)] = null);

(statearr_37998_38076[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (16))){
var inst_37787 = (state_37919[(2)]);
var state_37919__$1 = state_37919;
var statearr_37999_38077 = state_37919__$1;
(statearr_37999_38077[(2)] = inst_37787);

(statearr_37999_38077[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (38))){
var inst_37796 = (state_37919[(15)]);
var inst_37832 = (state_37919[(17)]);
var inst_37854 = (inst_37832 < inst_37796);
var state_37919__$1 = state_37919;
var statearr_38000_38078 = state_37919__$1;
(statearr_38000_38078[(2)] = inst_37854);

(statearr_38000_38078[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (30))){
var inst_37797 = (state_37919[(18)]);
var state_37919__$1 = state_37919;
if(cljs.core.truth_(inst_37797)){
var statearr_38001_38079 = state_37919__$1;
(statearr_38001_38079[(1)] = (32));

} else {
var statearr_38002_38080 = state_37919__$1;
(statearr_38002_38080[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (10))){
var inst_37912 = (state_37919[(2)]);
var state_37919__$1 = state_37919;
var statearr_38003_38081 = state_37919__$1;
(statearr_38003_38081[(2)] = inst_37912);

(statearr_38003_38081[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (18))){
var inst_37774 = (state_37919[(24)]);
var state_37919__$1 = state_37919;
var statearr_38004_38082 = state_37919__$1;
(statearr_38004_38082[(2)] = inst_37774);

(statearr_38004_38082[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (52))){
var state_37919__$1 = state_37919;
var statearr_38005_38083 = state_37919__$1;
(statearr_38005_38083[(2)] = null);

(statearr_38005_38083[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (42))){
var state_37919__$1 = state_37919;
var statearr_38006_38084 = state_37919__$1;
(statearr_38006_38084[(1)] = (44));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (37))){
var inst_37898 = (state_37919[(2)]);
var state_37919__$1 = state_37919;
var statearr_38008_38085 = state_37919__$1;
(statearr_38008_38085[(2)] = inst_37898);

(statearr_38008_38085[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (8))){
var inst_37758 = (state_37919[(25)]);
var state_37919__$1 = state_37919;
var statearr_38009_38086 = state_37919__$1;
(statearr_38009_38086[(2)] = inst_37758);

(statearr_38009_38086[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37920 === (49))){
var state_37919__$1 = state_37919;
if(cljs.core.truth_(fuel)){
var statearr_38010_38087 = state_37919__$1;
(statearr_38010_38087[(1)] = (51));

} else {
var statearr_38011_38088 = state_37919__$1;
(statearr_38011_38088[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto____0 = (function (){
var statearr_38012 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38012[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto__);

(statearr_38012[(1)] = (1));

return statearr_38012;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto____1 = (function (state_37919){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_37919);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e38013){var ex__16304__auto__ = e38013;
var statearr_38014_38089 = state_37919;
(statearr_38014_38089[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_37919[(4)]))){
var statearr_38015_38090 = state_37919;
(statearr_38015_38090[(1)] = cljs.core.first((state_37919[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__38091 = state_37919;
state_37919 = G__38091;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto__ = function(state_37919){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto____1.call(this,state_37919);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_38016 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_38016[(6)] = c__16375__auto__);

return statearr_38016;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__38092 = select_spec;
var map__38092__$1 = (((((!((map__38092 == null))))?(((((map__38092.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__38092.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38092):map__38092);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38092__$1,cljs.core.cst$kw$recur_DASH_seen);
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38092__$1,cljs.core.cst$kw$recur_DASH_depth);
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_depth], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_seen], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$compact_QMARK_], null));
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flake,select_spec,acc,fuel,max_fuel,cache){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_38175){
var state_val_38176 = (state_38175[(1)]);
if((state_val_38176 === (7))){
var state_38175__$1 = state_38175;
var statearr_38177_38229 = state_38175__$1;
(statearr_38177_38229[(2)] = false);

(statearr_38177_38229[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (20))){
var inst_38131 = (state_38175[(7)]);
var state_38175__$1 = state_38175;
if(cljs.core.truth_(inst_38131)){
var statearr_38178_38230 = state_38175__$1;
(statearr_38178_38230[(1)] = (22));

} else {
var statearr_38179_38231 = state_38175__$1;
(statearr_38179_38231[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (27))){
var inst_38154 = (state_38175[(8)]);
var inst_38160 = (state_38175[(2)]);
var state_38175__$1 = (function (){var statearr_38180 = state_38175;
(statearr_38180[(9)] = inst_38160);

return statearr_38180;
})();
if(cljs.core.truth_(inst_38154)){
var statearr_38181_38232 = state_38175__$1;
(statearr_38181_38232[(1)] = (28));

} else {
var statearr_38182_38233 = state_38175__$1;
(statearr_38182_38233[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (1))){
var state_38175__$1 = state_38175;
var statearr_38183_38234 = state_38175__$1;
(statearr_38183_38234[(2)] = null);

(statearr_38183_38234[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (24))){
var inst_38152 = (state_38175[(2)]);
var state_38175__$1 = state_38175;
var statearr_38184_38235 = state_38175__$1;
(statearr_38184_38235[(2)] = inst_38152);

(statearr_38184_38235[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (4))){
var inst_38094 = (state_38175[(2)]);
var state_38175__$1 = state_38175;
var statearr_38185_38236 = state_38175__$1;
(statearr_38185_38236[(2)] = inst_38094);

(statearr_38185_38236[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (15))){
var inst_38138 = (state_38175[(2)]);
var inst_38139 = fluree.db.util.async.throw_err(inst_38138);
var state_38175__$1 = (function (){var statearr_38186 = state_38175;
(statearr_38186[(10)] = inst_38139);

return statearr_38186;
})();
if(cljs.core.truth_(fuel)){
var statearr_38187_38237 = state_38175__$1;
(statearr_38187_38237[(1)] = (16));

} else {
var statearr_38188_38238 = state_38175__$1;
(statearr_38188_38238[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (21))){
var inst_38124 = (state_38175[(11)]);
var inst_38154 = (state_38175[(2)]);
var state_38175__$1 = (function (){var statearr_38189 = state_38175;
(statearr_38189[(8)] = inst_38154);

return statearr_38189;
})();
if(cljs.core.truth_(inst_38124)){
var statearr_38190_38239 = state_38175__$1;
(statearr_38190_38239[(1)] = (25));

} else {
var statearr_38191_38240 = state_38175__$1;
(statearr_38191_38240[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (31))){
var inst_38125 = (state_38175[(12)]);
var inst_38160 = (state_38175[(9)]);
var inst_38166 = (state_38175[(2)]);
var inst_38167 = fluree.db.util.async.throw_err(inst_38166);
var inst_38168 = (inst_38160.cljs$core$IFn$_invoke$arity$3 ? inst_38160.cljs$core$IFn$_invoke$arity$3(acc,inst_38125,inst_38167) : inst_38160.call(null,acc,inst_38125,inst_38167));
var state_38175__$1 = state_38175;
var statearr_38192_38241 = state_38175__$1;
(statearr_38192_38241[(2)] = inst_38168);

(statearr_38192_38241[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (13))){
var inst_38102 = (state_38175[(13)]);
var state_38175__$1 = state_38175;
var statearr_38193_38242 = state_38175__$1;
(statearr_38193_38242[(2)] = inst_38102);

(statearr_38193_38242[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (22))){
var inst_38131 = (state_38175[(7)]);
var state_38175__$1 = state_38175;
var statearr_38194_38243 = state_38175__$1;
(statearr_38194_38243[(2)] = inst_38131);

(statearr_38194_38243[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (29))){
var inst_38145 = (state_38175[(14)]);
var inst_38163 = fluree.db.query.fql.recur_select_spec(select_spec,flake);
var inst_38164 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_38163,inst_38145) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_38163,inst_38145));
var state_38175__$1 = state_38175;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38175__$1,(31),inst_38164);
} else {
if((state_val_38176 === (6))){
var inst_38102 = (state_38175[(13)]);
var inst_38107 = inst_38102.cljs$lang$protocol_mask$partition0$;
var inst_38108 = (inst_38107 & (64));
var inst_38109 = inst_38102.cljs$core$ISeq$;
var inst_38110 = (cljs.core.PROTOCOL_SENTINEL === inst_38109);
var inst_38111 = ((inst_38108) || (inst_38110));
var state_38175__$1 = state_38175;
if(cljs.core.truth_(inst_38111)){
var statearr_38195_38244 = state_38175__$1;
(statearr_38195_38244[(1)] = (9));

} else {
var statearr_38196_38245 = state_38175__$1;
(statearr_38196_38245[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (28))){
var state_38175__$1 = state_38175;
var statearr_38197_38246 = state_38175__$1;
(statearr_38197_38246[(2)] = acc);

(statearr_38197_38246[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (25))){
var inst_38128 = (state_38175[(15)]);
var inst_38127 = (state_38175[(16)]);
var inst_38130 = (state_38175[(17)]);
var inst_38145 = (state_38175[(14)]);
var inst_38125 = (state_38175[(12)]);
var inst_38131 = (state_38175[(7)]);
var inst_38101 = (state_38175[(18)]);
var inst_38154 = (state_38175[(8)]);
var inst_38129 = (state_38175[(19)]);
var inst_38126 = (state_38175[(20)]);
var inst_38123 = (state_38175[(21)]);
var inst_38124 = (state_38175[(11)]);
var inst_38156 = (function (){var recur_seen = inst_38127;
var recur_subject = inst_38101;
var sub_flakes = inst_38145;
var seen_QMARK_ = inst_38130;
var multi_QMARK_ = inst_38124;
var limit = inst_38129;
var recur_depth = inst_38128;
var map__38100 = inst_38123;
var as = inst_38125;
var max_depth_QMARK_ = inst_38131;
var recur = inst_38126;
var stop_QMARK_ = inst_38154;
return (function (results,as__$1,new_result){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(results,as__$1,fluree.db.query.fql.conjv,new_result);
});
})();
var state_38175__$1 = state_38175;
var statearr_38198_38247 = state_38175__$1;
(statearr_38198_38247[(2)] = inst_38156);

(statearr_38198_38247[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (17))){
var inst_38139 = (state_38175[(10)]);
var state_38175__$1 = state_38175;
var statearr_38199_38248 = state_38175__$1;
(statearr_38199_38248[(2)] = inst_38139);

(statearr_38199_38248[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (3))){
var inst_38173 = (state_38175[(2)]);
var state_38175__$1 = state_38175;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38175__$1,inst_38173);
} else {
if((state_val_38176 === (12))){
var inst_38102 = (state_38175[(13)]);
var inst_38120 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_38102);
var state_38175__$1 = state_38175;
var statearr_38200_38249 = state_38175__$1;
(statearr_38200_38249[(2)] = inst_38120);

(statearr_38200_38249[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (2))){
var inst_38102 = (state_38175[(13)]);
var _ = (function (){var statearr_38201 = state_38175;
(statearr_38201[(4)] = cljs.core.cons((5),(state_38175[(4)])));

return statearr_38201;
})();
var inst_38101 = flake.o;
var inst_38102__$1 = select_spec;
var inst_38104 = (inst_38102__$1 == null);
var inst_38105 = cljs.core.not(inst_38104);
var state_38175__$1 = (function (){var statearr_38202 = state_38175;
(statearr_38202[(13)] = inst_38102__$1);

(statearr_38202[(18)] = inst_38101);

return statearr_38202;
})();
if(inst_38105){
var statearr_38203_38250 = state_38175__$1;
(statearr_38203_38250[(1)] = (6));

} else {
var statearr_38204_38251 = state_38175__$1;
(statearr_38204_38251[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (23))){
var inst_38145 = (state_38175[(14)]);
var inst_38150 = cljs.core.empty_QMARK_(inst_38145);
var state_38175__$1 = state_38175;
var statearr_38205_38252 = state_38175__$1;
(statearr_38205_38252[(2)] = inst_38150);

(statearr_38205_38252[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (19))){
var inst_38130 = (state_38175[(17)]);
var state_38175__$1 = state_38175;
var statearr_38206_38253 = state_38175__$1;
(statearr_38206_38253[(2)] = inst_38130);

(statearr_38206_38253[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (11))){
var inst_38115 = (state_38175[(2)]);
var state_38175__$1 = state_38175;
var statearr_38208_38254 = state_38175__$1;
(statearr_38208_38254[(2)] = inst_38115);

(statearr_38208_38254[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (9))){
var state_38175__$1 = state_38175;
var statearr_38209_38255 = state_38175__$1;
(statearr_38209_38255[(2)] = true);

(statearr_38209_38255[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (5))){
var _ = (function (){var statearr_38210 = state_38175;
(statearr_38210[(4)] = cljs.core.rest((state_38175[(4)])));

return statearr_38210;
})();
var state_38175__$1 = state_38175;
var ex38207 = (state_38175__$1[(2)]);
var statearr_38211_38256 = state_38175__$1;
(statearr_38211_38256[(5)] = ex38207);


if((ex38207 instanceof Error)){
var statearr_38212_38257 = state_38175__$1;
(statearr_38212_38257[(1)] = (4));

(statearr_38212_38257[(5)] = null);

} else {
throw ex38207;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (14))){
var inst_38128 = (state_38175[(15)]);
var inst_38127 = (state_38175[(16)]);
var inst_38101 = (state_38175[(18)]);
var inst_38126 = (state_38175[(20)]);
var inst_38123 = (state_38175[(21)]);
var inst_38123__$1 = (state_38175[(2)]);
var inst_38124 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38123__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_38125 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38123__$1,cljs.core.cst$kw$as);
var inst_38126__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38123__$1,cljs.core.cst$kw$recur);
var inst_38127__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38123__$1,cljs.core.cst$kw$recur_DASH_seen);
var inst_38128__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38123__$1,cljs.core.cst$kw$recur_DASH_depth);
var inst_38129 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38123__$1,cljs.core.cst$kw$limit);
var inst_38130 = cljs.core.contains_QMARK_(inst_38127__$1,inst_38101);
var inst_38131 = (inst_38128__$1 > inst_38126__$1);
var inst_38133 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38134 = [inst_38101];
var inst_38135 = (new cljs.core.PersistentVector(null,1,(5),inst_38133,inst_38134,null));
var inst_38136 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38135);
var state_38175__$1 = (function (){var statearr_38213 = state_38175;
(statearr_38213[(15)] = inst_38128__$1);

(statearr_38213[(16)] = inst_38127__$1);

(statearr_38213[(17)] = inst_38130);

(statearr_38213[(12)] = inst_38125);

(statearr_38213[(7)] = inst_38131);

(statearr_38213[(19)] = inst_38129);

(statearr_38213[(20)] = inst_38126__$1);

(statearr_38213[(21)] = inst_38123__$1);

(statearr_38213[(11)] = inst_38124);

return statearr_38213;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38175__$1,(15),inst_38136);
} else {
if((state_val_38176 === (26))){
var inst_38128 = (state_38175[(15)]);
var inst_38127 = (state_38175[(16)]);
var inst_38130 = (state_38175[(17)]);
var inst_38145 = (state_38175[(14)]);
var inst_38125 = (state_38175[(12)]);
var inst_38131 = (state_38175[(7)]);
var inst_38101 = (state_38175[(18)]);
var inst_38154 = (state_38175[(8)]);
var inst_38129 = (state_38175[(19)]);
var inst_38126 = (state_38175[(20)]);
var inst_38123 = (state_38175[(21)]);
var inst_38124 = (state_38175[(11)]);
var inst_38158 = (function (){var recur_seen = inst_38127;
var recur_subject = inst_38101;
var sub_flakes = inst_38145;
var seen_QMARK_ = inst_38130;
var multi_QMARK_ = inst_38124;
var limit = inst_38129;
var recur_depth = inst_38128;
var map__38100 = inst_38123;
var as = inst_38125;
var max_depth_QMARK_ = inst_38131;
var recur = inst_38126;
var stop_QMARK_ = inst_38154;
return (function (results,as__$1,new_result){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,as__$1,new_result);
});
})();
var state_38175__$1 = state_38175;
var statearr_38214_38258 = state_38175__$1;
(statearr_38214_38258[(2)] = inst_38158);

(statearr_38214_38258[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (16))){
var inst_38139 = (state_38175[(10)]);
var inst_38141 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_38142 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_38141,inst_38139);
var state_38175__$1 = state_38175;
var statearr_38215_38259 = state_38175__$1;
(statearr_38215_38259[(2)] = inst_38142);

(statearr_38215_38259[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (30))){
var inst_38170 = (state_38175[(2)]);
var _ = (function (){var statearr_38216 = state_38175;
(statearr_38216[(4)] = cljs.core.rest((state_38175[(4)])));

return statearr_38216;
})();
var state_38175__$1 = state_38175;
var statearr_38217_38260 = state_38175__$1;
(statearr_38217_38260[(2)] = inst_38170);

(statearr_38217_38260[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (10))){
var state_38175__$1 = state_38175;
var statearr_38218_38261 = state_38175__$1;
(statearr_38218_38261[(2)] = false);

(statearr_38218_38261[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (18))){
var inst_38130 = (state_38175[(17)]);
var inst_38145 = (state_38175[(2)]);
var state_38175__$1 = (function (){var statearr_38219 = state_38175;
(statearr_38219[(14)] = inst_38145);

return statearr_38219;
})();
if(cljs.core.truth_(inst_38130)){
var statearr_38220_38262 = state_38175__$1;
(statearr_38220_38262[(1)] = (19));

} else {
var statearr_38221_38263 = state_38175__$1;
(statearr_38221_38263[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38176 === (8))){
var inst_38118 = (state_38175[(2)]);
var state_38175__$1 = state_38175;
if(cljs.core.truth_(inst_38118)){
var statearr_38222_38264 = state_38175__$1;
(statearr_38222_38264[(1)] = (12));

} else {
var statearr_38223_38265 = state_38175__$1;
(statearr_38223_38265[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto____0 = (function (){
var statearr_38224 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38224[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto__);

(statearr_38224[(1)] = (1));

return statearr_38224;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto____1 = (function (state_38175){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_38175);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e38225){var ex__16304__auto__ = e38225;
var statearr_38226_38266 = state_38175;
(statearr_38226_38266[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_38175[(4)]))){
var statearr_38227_38267 = state_38175;
(statearr_38227_38267[(1)] = cljs.core.first((state_38175[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__38268 = state_38175;
state_38175 = G__38268;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto__ = function(state_38175){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto____1.call(this,state_38175);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_38228 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_38228[(6)] = c__16375__auto__);

return statearr_38228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_38446){
var state_val_38447 = (state_38446[(1)]);
if((state_val_38447 === (7))){
var state_38446__$1 = state_38446;
var statearr_38448_38533 = state_38446__$1;
(statearr_38448_38533[(2)] = null);

(statearr_38448_38533[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (20))){
var inst_38307 = cljs.core.PersistentHashMap.EMPTY;
var state_38446__$1 = state_38446;
var statearr_38449_38534 = state_38446__$1;
(statearr_38449_38534[(2)] = inst_38307);

(statearr_38449_38534[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (27))){
var inst_38295 = (state_38446[(7)]);
var inst_38289 = (state_38446[(8)]);
var inst_38309 = (state_38446[(9)]);
var inst_38325 = (state_38446[(10)]);
var inst_38425 = (state_38446[(2)]);
var inst_38426 = (function (){var top_level_subject = inst_38289;
var select_spec = inst_38295;
var base_acc = inst_38309;
var acc_PLUS_refs = inst_38325;
var result = inst_38425;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4126__auto__ = (function (){var and__4115__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_38427 = cljs.core.PersistentVector.EMPTY;
var inst_38428 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_38295);
var inst_38429 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_38428);
var inst_38430 = cljs.core.vals(inst_38429);
var inst_38431 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_38295);
var inst_38432 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_38431);
var inst_38433 = cljs.core.vals(inst_38432);
var inst_38434 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_38430,inst_38433);
var inst_38435 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_38426,inst_38427,inst_38434);
var inst_38437 = (function (){var top_level_subject = inst_38289;
var select_spec = inst_38295;
var base_acc = inst_38309;
var acc_PLUS_refs = inst_38325;
var result = inst_38425;
var sort_preds = inst_38435;
return (function (acc,p__38436){
var vec__38450 = p__38436;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38450,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38450,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38450,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38450,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_38438 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_38437,inst_38425,inst_38435);
var state_38446__$1 = state_38446;
var statearr_38453_38535 = state_38446__$1;
(statearr_38453_38535[(2)] = inst_38438);

(statearr_38453_38535[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (1))){
var state_38446__$1 = state_38446;
var statearr_38454_38536 = state_38446__$1;
(statearr_38454_38536[(2)] = null);

(statearr_38454_38536[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (24))){
var inst_38325 = (state_38446[(10)]);
var inst_38325__$1 = (state_38446[(2)]);
var inst_38326 = flakes;
var inst_38327 = cljs.core.PersistentHashMap.EMPTY;
var inst_38328 = inst_38326;
var inst_38329 = inst_38325__$1;
var inst_38330 = inst_38327;
var state_38446__$1 = (function (){var statearr_38455 = state_38446;
(statearr_38455[(11)] = inst_38328);

(statearr_38455[(12)] = inst_38329);

(statearr_38455[(10)] = inst_38325__$1);

(statearr_38455[(13)] = inst_38330);

return statearr_38455;
})();
var statearr_38456_38537 = state_38446__$1;
(statearr_38456_38537[(2)] = null);

(statearr_38456_38537[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (39))){
var inst_38329 = (state_38446[(12)]);
var inst_38338 = (state_38446[(14)]);
var inst_38295 = (state_38446[(7)]);
var inst_38344 = (state_38446[(15)]);
var inst_38373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38374 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_38329,inst_38295,inst_38338,inst_38344,false);
var state_38446__$1 = (function (){var statearr_38457 = state_38446;
(statearr_38457[(16)] = inst_38373);

return statearr_38457;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38446__$1,(42),inst_38374);
} else {
if((state_val_38447 === (46))){
var inst_38328 = (state_38446[(11)]);
var inst_38338 = (state_38446[(14)]);
var inst_38330 = (state_38446[(13)]);
var inst_38391 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38392 = ["_id"];
var inst_38393 = inst_38338.s;
var inst_38394 = [inst_38393];
var inst_38395 = cljs.core.PersistentHashMap.fromArrays(inst_38392,inst_38394);
var inst_38396 = cljs.core.rest(inst_38328);
var inst_38397 = [inst_38395,inst_38396,inst_38330];
var inst_38398 = (new cljs.core.PersistentVector(null,3,(5),inst_38391,inst_38397,null));
var state_38446__$1 = state_38446;
var statearr_38458_38538 = state_38446__$1;
(statearr_38458_38538[(2)] = inst_38398);

(statearr_38458_38538[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (4))){
var inst_38269 = (state_38446[(2)]);
var state_38446__$1 = state_38446;
var statearr_38459_38539 = state_38446__$1;
(statearr_38459_38539[(2)] = inst_38269);

(statearr_38459_38539[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (15))){
var inst_38295 = (state_38446[(7)]);
var inst_38296 = (state_38446[(17)]);
var inst_38295__$1 = (state_38446[(2)]);
var inst_38296__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38295__$1);
var state_38446__$1 = (function (){var statearr_38460 = state_38446;
(statearr_38460[(7)] = inst_38295__$1);

(statearr_38460[(17)] = inst_38296__$1);

return statearr_38460;
})();
if(cljs.core.truth_(inst_38296__$1)){
var statearr_38461_38540 = state_38446__$1;
(statearr_38461_38540[(1)] = (16));

} else {
var statearr_38462_38541 = state_38446__$1;
(statearr_38462_38541[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (48))){
var inst_38409 = (state_38446[(2)]);
var state_38446__$1 = state_38446;
var statearr_38463_38542 = state_38446__$1;
(statearr_38463_38542[(2)] = inst_38409);

(statearr_38463_38542[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (50))){
var state_38446__$1 = state_38446;
var statearr_38464_38543 = state_38446__$1;
(statearr_38464_38543[(2)] = null);

(statearr_38464_38543[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (21))){
var inst_38295 = (state_38446[(7)]);
var inst_38309 = (state_38446[(2)]);
var inst_38310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38311 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_38312 = (new cljs.core.PersistentVector(null,2,(5),inst_38310,inst_38311,null));
var inst_38313 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38295,inst_38312);
var state_38446__$1 = (function (){var statearr_38465 = state_38446;
(statearr_38465[(9)] = inst_38309);

return statearr_38465;
})();
if(cljs.core.truth_(inst_38313)){
var statearr_38466_38544 = state_38446__$1;
(statearr_38466_38544[(1)] = (22));

} else {
var statearr_38467_38545 = state_38446__$1;
(statearr_38467_38545[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (31))){
var inst_38329 = (state_38446[(12)]);
var inst_38338 = (state_38446[(14)]);
var inst_38343 = (state_38446[(18)]);
var inst_38347 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38348 = fluree.db.query.fql.flake__GT_recur(db,inst_38338,inst_38343,inst_38329,fuel,max_fuel,cache);
var state_38446__$1 = (function (){var statearr_38468 = state_38446;
(statearr_38468[(19)] = inst_38347);

return statearr_38468;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38446__$1,(34),inst_38348);
} else {
if((state_val_38447 === (32))){
var inst_38343 = (state_38446[(18)]);
var state_38446__$1 = state_38446;
if(cljs.core.truth_(inst_38343)){
var statearr_38469_38546 = state_38446__$1;
(statearr_38469_38546[(1)] = (35));

} else {
var statearr_38470_38547 = state_38446__$1;
(statearr_38470_38547[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (40))){
var inst_38295 = (state_38446[(7)]);
var inst_38383 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_38295);
var inst_38384 = cljs.core.empty_QMARK_(inst_38383);
var state_38446__$1 = state_38446;
if(inst_38384){
var statearr_38471_38548 = state_38446__$1;
(statearr_38471_38548[(1)] = (43));

} else {
var statearr_38472_38549 = state_38446__$1;
(statearr_38472_38549[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (33))){
var inst_38338 = (state_38446[(14)]);
var inst_38415 = (state_38446[(2)]);
var inst_38416 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38415,(0),null);
var inst_38417 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38415,(1),null);
var inst_38418 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38415,(2),null);
var inst_38419 = inst_38338.s;
var inst_38420 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38416,cljs.core.cst$kw$_id,inst_38419);
var inst_38328 = inst_38417;
var inst_38329 = inst_38420;
var inst_38330 = inst_38418;
var state_38446__$1 = (function (){var statearr_38473 = state_38446;
(statearr_38473[(11)] = inst_38328);

(statearr_38473[(12)] = inst_38329);

(statearr_38473[(13)] = inst_38330);

return statearr_38473;
})();
var statearr_38474_38550 = state_38446__$1;
(statearr_38474_38550[(2)] = null);

(statearr_38474_38550[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (13))){
var inst_38289 = (state_38446[(8)]);
var inst_38292 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_38289);
var state_38446__$1 = state_38446;
var statearr_38475_38551 = state_38446__$1;
(statearr_38475_38551[(2)] = inst_38292);

(statearr_38475_38551[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (22))){
var inst_38295 = (state_38446[(7)]);
var inst_38315 = cljs.core.first(flakes);
var inst_38316 = fluree.db.query.fql.s(inst_38315);
var inst_38317 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_38295);
var inst_38318 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_38316,inst_38317);
var state_38446__$1 = state_38446;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38446__$1,(25),inst_38318);
} else {
if((state_val_38447 === (36))){
var inst_38295 = (state_38446[(7)]);
var inst_38371 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38295);
var state_38446__$1 = state_38446;
if(cljs.core.truth_(inst_38371)){
var statearr_38476_38552 = state_38446__$1;
(statearr_38476_38552[(1)] = (39));

} else {
var statearr_38477_38553 = state_38446__$1;
(statearr_38477_38553[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (41))){
var inst_38411 = (state_38446[(2)]);
var state_38446__$1 = state_38446;
var statearr_38478_38554 = state_38446__$1;
(statearr_38478_38554[(2)] = inst_38411);

(statearr_38478_38554[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (43))){
var inst_38295 = (state_38446[(7)]);
var inst_38386 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38295);
var state_38446__$1 = state_38446;
var statearr_38479_38555 = state_38446__$1;
(statearr_38479_38555[(2)] = inst_38386);

(statearr_38479_38555[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (29))){
var inst_38328 = (state_38446[(11)]);
var inst_38338 = (state_38446[(14)]);
var inst_38295 = (state_38446[(7)]);
var inst_38343 = (state_38446[(18)]);
var inst_38338__$1 = cljs.core.first(inst_38328);
var inst_38339 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38340 = inst_38338__$1.p;
var inst_38341 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_38340];
var inst_38342 = (new cljs.core.PersistentVector(null,3,(5),inst_38339,inst_38341,null));
var inst_38343__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38295,inst_38342);
var inst_38344 = fluree.db.query.fql.component_follow_QMARK_(inst_38343__$1,inst_38295);
var inst_38345 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_38343__$1);
var state_38446__$1 = (function (){var statearr_38480 = state_38446;
(statearr_38480[(14)] = inst_38338__$1);

(statearr_38480[(18)] = inst_38343__$1);

(statearr_38480[(15)] = inst_38344);

return statearr_38480;
})();
if(cljs.core.truth_(inst_38345)){
var statearr_38481_38556 = state_38446__$1;
(statearr_38481_38556[(1)] = (31));

} else {
var statearr_38482_38557 = state_38446__$1;
(statearr_38482_38557[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (44))){
var state_38446__$1 = state_38446;
var statearr_38483_38558 = state_38446__$1;
(statearr_38483_38558[(2)] = false);

(statearr_38483_38558[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (6))){
var state_38446__$1 = state_38446;
var statearr_38484_38559 = state_38446__$1;
(statearr_38484_38559[(2)] = null);

(statearr_38484_38559[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (28))){
var inst_38329 = (state_38446[(12)]);
var state_38446__$1 = state_38446;
var statearr_38485_38560 = state_38446__$1;
(statearr_38485_38560[(2)] = inst_38329);

(statearr_38485_38560[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (51))){
var inst_38407 = (state_38446[(2)]);
var state_38446__$1 = state_38446;
var statearr_38486_38561 = state_38446__$1;
(statearr_38486_38561[(2)] = inst_38407);

(statearr_38486_38561[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (25))){
var inst_38309 = (state_38446[(9)]);
var inst_38320 = (state_38446[(2)]);
var inst_38321 = fluree.db.util.async.throw_err(inst_38320);
var inst_38322 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38309,inst_38321], 0));
var state_38446__$1 = state_38446;
var statearr_38487_38562 = state_38446__$1;
(statearr_38487_38562[(2)] = inst_38322);

(statearr_38487_38562[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (34))){
var inst_38328 = (state_38446[(11)]);
var inst_38347 = (state_38446[(19)]);
var inst_38330 = (state_38446[(13)]);
var inst_38350 = (state_38446[(2)]);
var inst_38351 = fluree.db.util.async.throw_err(inst_38350);
var inst_38352 = cljs.core.rest(inst_38328);
var inst_38353 = [inst_38351,inst_38352,inst_38330];
var inst_38354 = (new cljs.core.PersistentVector(null,3,(5),inst_38347,inst_38353,null));
var state_38446__$1 = state_38446;
var statearr_38488_38563 = state_38446__$1;
(statearr_38488_38563[(2)] = inst_38354);

(statearr_38488_38563[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (17))){
var inst_38295 = (state_38446[(7)]);
var inst_38299 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_38295);
var state_38446__$1 = state_38446;
var statearr_38490_38564 = state_38446__$1;
(statearr_38490_38564[(2)] = inst_38299);

(statearr_38490_38564[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (3))){
var inst_38444 = (state_38446[(2)]);
var state_38446__$1 = state_38446;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38446__$1,inst_38444);
} else {
if((state_val_38447 === (12))){
var _ = (function (){var statearr_38491 = state_38446;
(statearr_38491[(4)] = cljs.core.rest((state_38446[(4)])));

return statearr_38491;
})();
var state_38446__$1 = state_38446;
var ex38489 = (state_38446__$1[(2)]);
var statearr_38492_38565 = state_38446__$1;
(statearr_38492_38565[(5)] = ex38489);


var statearr_38493_38566 = state_38446__$1;
(statearr_38493_38566[(1)] = (11));

(statearr_38493_38566[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (2))){
var _ = (function (){var statearr_38494 = state_38446;
(statearr_38494[(4)] = cljs.core.cons((5),(state_38446[(4)])));

return statearr_38494;
})();
var inst_38275 = cljs.core.not_empty(flakes);
var state_38446__$1 = state_38446;
if(cljs.core.truth_(inst_38275)){
var statearr_38495_38567 = state_38446__$1;
(statearr_38495_38567[(1)] = (6));

} else {
var statearr_38496_38568 = state_38446__$1;
(statearr_38496_38568[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (23))){
var inst_38309 = (state_38446[(9)]);
var state_38446__$1 = state_38446;
var statearr_38497_38569 = state_38446__$1;
(statearr_38497_38569[(2)] = inst_38309);

(statearr_38497_38569[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (47))){
var state_38446__$1 = state_38446;
var statearr_38498_38570 = state_38446__$1;
(statearr_38498_38570[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (35))){
var inst_38329 = (state_38446[(12)]);
var inst_38338 = (state_38446[(14)]);
var inst_38343 = (state_38446[(18)]);
var inst_38344 = (state_38446[(15)]);
var inst_38330 = (state_38446[(13)]);
var inst_38360 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_38329,inst_38343,inst_38338,inst_38344,false,inst_38330);
var state_38446__$1 = state_38446;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38446__$1,(38),inst_38360);
} else {
if((state_val_38447 === (19))){
var inst_38289 = (state_38446[(8)]);
var inst_38303 = ["_id"];
var inst_38304 = [inst_38289];
var inst_38305 = cljs.core.PersistentHashMap.fromArrays(inst_38303,inst_38304);
var state_38446__$1 = state_38446;
var statearr_38500_38571 = state_38446__$1;
(statearr_38500_38571[(2)] = inst_38305);

(statearr_38500_38571[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (11))){
var inst_38277 = (state_38446[(2)]);
var inst_38278 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38277], 0));
var inst_38279 = (function(){throw inst_38277})();
var state_38446__$1 = (function (){var statearr_38502 = state_38446;
(statearr_38502[(20)] = inst_38278);

return statearr_38502;
})();
var statearr_38503_38572 = state_38446__$1;
(statearr_38503_38572[(2)] = inst_38279);

(statearr_38503_38572[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (9))){
var _ = (function (){var statearr_38504 = state_38446;
(statearr_38504[(4)] = cljs.core.cons((12),(state_38446[(4)])));

return statearr_38504;
})();
var inst_38285 = cljs.core.first(flakes);
var inst_38286 = fluree.db.query.fql.s(inst_38285);
var ___$1 = (function (){var statearr_38505 = state_38446;
(statearr_38505[(4)] = cljs.core.rest((state_38446[(4)])));

return statearr_38505;
})();
var state_38446__$1 = state_38446;
var statearr_38506_38573 = state_38446__$1;
(statearr_38506_38573[(2)] = inst_38286);

(statearr_38506_38573[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (5))){
var _ = (function (){var statearr_38507 = state_38446;
(statearr_38507[(4)] = cljs.core.rest((state_38446[(4)])));

return statearr_38507;
})();
var state_38446__$1 = state_38446;
var ex38501 = (state_38446__$1[(2)]);
var statearr_38508_38574 = state_38446__$1;
(statearr_38508_38574[(5)] = ex38501);


if((ex38501 instanceof Error)){
var statearr_38509_38575 = state_38446__$1;
(statearr_38509_38575[(1)] = (4));

(statearr_38509_38575[(5)] = null);

} else {
throw ex38501;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (14))){
var state_38446__$1 = state_38446;
var statearr_38510_38576 = state_38446__$1;
(statearr_38510_38576[(2)] = base_select_spec);

(statearr_38510_38576[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (45))){
var inst_38389 = (state_38446[(2)]);
var state_38446__$1 = state_38446;
if(cljs.core.truth_(inst_38389)){
var statearr_38511_38577 = state_38446__$1;
(statearr_38511_38577[(1)] = (46));

} else {
var statearr_38512_38578 = state_38446__$1;
(statearr_38512_38578[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (26))){
var inst_38328 = (state_38446[(11)]);
var inst_38332 = cljs.core.empty_QMARK_(inst_38328);
var state_38446__$1 = state_38446;
if(inst_38332){
var statearr_38513_38579 = state_38446__$1;
(statearr_38513_38579[(1)] = (28));

} else {
var statearr_38514_38580 = state_38446__$1;
(statearr_38514_38580[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (16))){
var inst_38296 = (state_38446[(17)]);
var state_38446__$1 = state_38446;
var statearr_38515_38581 = state_38446__$1;
(statearr_38515_38581[(2)] = inst_38296);

(statearr_38515_38581[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (38))){
var inst_38328 = (state_38446[(11)]);
var inst_38362 = (state_38446[(2)]);
var inst_38363 = fluree.db.util.async.throw_err(inst_38362);
var inst_38364 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38363,(0),null);
var inst_38365 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38363,(1),null);
var inst_38366 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38367 = cljs.core.rest(inst_38328);
var inst_38368 = [inst_38364,inst_38367,inst_38365];
var inst_38369 = (new cljs.core.PersistentVector(null,3,(5),inst_38366,inst_38368,null));
var state_38446__$1 = state_38446;
var statearr_38516_38582 = state_38446__$1;
(statearr_38516_38582[(2)] = inst_38369);

(statearr_38516_38582[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (30))){
var inst_38423 = (state_38446[(2)]);
var state_38446__$1 = state_38446;
var statearr_38517_38583 = state_38446__$1;
(statearr_38517_38583[(2)] = inst_38423);

(statearr_38517_38583[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (10))){
var inst_38289 = (state_38446[(2)]);
var inst_38290 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_38446__$1 = (function (){var statearr_38518 = state_38446;
(statearr_38518[(8)] = inst_38289);

return statearr_38518;
})();
if(cljs.core.truth_(inst_38290)){
var statearr_38519_38584 = state_38446__$1;
(statearr_38519_38584[(1)] = (13));

} else {
var statearr_38520_38585 = state_38446__$1;
(statearr_38520_38585[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (18))){
var inst_38301 = (state_38446[(2)]);
var state_38446__$1 = state_38446;
if(cljs.core.truth_(inst_38301)){
var statearr_38521_38586 = state_38446__$1;
(statearr_38521_38586[(1)] = (19));

} else {
var statearr_38522_38587 = state_38446__$1;
(statearr_38522_38587[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (42))){
var inst_38328 = (state_38446[(11)]);
var inst_38373 = (state_38446[(16)]);
var inst_38330 = (state_38446[(13)]);
var inst_38376 = (state_38446[(2)]);
var inst_38377 = fluree.db.util.async.throw_err(inst_38376);
var inst_38378 = cljs.core.first(inst_38377);
var inst_38379 = cljs.core.rest(inst_38328);
var inst_38380 = [inst_38378,inst_38379,inst_38330];
var inst_38381 = (new cljs.core.PersistentVector(null,3,(5),inst_38373,inst_38380,null));
var state_38446__$1 = state_38446;
var statearr_38523_38588 = state_38446__$1;
(statearr_38523_38588[(2)] = inst_38381);

(statearr_38523_38588[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (37))){
var inst_38413 = (state_38446[(2)]);
var state_38446__$1 = state_38446;
var statearr_38524_38589 = state_38446__$1;
(statearr_38524_38589[(2)] = inst_38413);

(statearr_38524_38589[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (8))){
var inst_38441 = (state_38446[(2)]);
var _ = (function (){var statearr_38525 = state_38446;
(statearr_38525[(4)] = cljs.core.rest((state_38446[(4)])));

return statearr_38525;
})();
var state_38446__$1 = state_38446;
var statearr_38526_38590 = state_38446__$1;
(statearr_38526_38590[(2)] = inst_38441);

(statearr_38526_38590[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38447 === (49))){
var inst_38328 = (state_38446[(11)]);
var inst_38329 = (state_38446[(12)]);
var inst_38330 = (state_38446[(13)]);
var inst_38401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38402 = cljs.core.rest(inst_38328);
var inst_38403 = [inst_38329,inst_38402,inst_38330];
var inst_38404 = (new cljs.core.PersistentVector(null,3,(5),inst_38401,inst_38403,null));
var state_38446__$1 = state_38446;
var statearr_38527_38591 = state_38446__$1;
(statearr_38527_38591[(2)] = inst_38404);

(statearr_38527_38591[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto____0 = (function (){
var statearr_38528 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38528[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto__);

(statearr_38528[(1)] = (1));

return statearr_38528;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto____1 = (function (state_38446){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_38446);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e38529){var ex__16304__auto__ = e38529;
var statearr_38530_38592 = state_38446;
(statearr_38530_38592[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_38446[(4)]))){
var statearr_38531_38593 = state_38446;
(statearr_38531_38593[(1)] = cljs.core.first((state_38446[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__38594 = state_38446;
state_38446 = G__38594;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto__ = function(state_38446){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto____1.call(this,state_38446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_38532 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_38532[(6)] = c__16375__auto__);

return statearr_38532;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__38597 = arguments.length;
switch (G__38597) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_38639){
var state_val_38640 = (state_38639[(1)]);
if((state_val_38640 === (7))){
var inst_38605 = (state_38639[(7)]);
var state_38639__$1 = state_38639;
var statearr_38641_38671 = state_38639__$1;
(statearr_38641_38671[(2)] = inst_38605);

(statearr_38641_38671[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38640 === (1))){
var state_38639__$1 = state_38639;
var statearr_38642_38672 = state_38639__$1;
(statearr_38642_38672[(2)] = null);

(statearr_38642_38672[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38640 === (4))){
var inst_38598 = (state_38639[(2)]);
var state_38639__$1 = state_38639;
var statearr_38643_38673 = state_38639__$1;
(statearr_38643_38673[(2)] = inst_38598);

(statearr_38643_38673[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38640 === (15))){
var inst_38633 = (state_38639[(2)]);
var inst_38634 = fluree.db.util.async.throw_err(inst_38633);
var _ = (function (){var statearr_38644 = state_38639;
(statearr_38644[(4)] = cljs.core.rest((state_38639[(4)])));

return statearr_38644;
})();
var state_38639__$1 = state_38639;
var statearr_38645_38674 = state_38639__$1;
(statearr_38645_38674[(2)] = inst_38634);

(statearr_38645_38674[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38640 === (13))){
var inst_38617 = (state_38639[(8)]);
var state_38639__$1 = state_38639;
var statearr_38646_38675 = state_38639__$1;
(statearr_38646_38675[(2)] = inst_38617);

(statearr_38646_38675[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38640 === (6))){
var inst_38605 = (state_38639[(7)]);
var inst_38607 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_38608 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_38605,inst_38607);
var state_38639__$1 = state_38639;
var statearr_38647_38676 = state_38639__$1;
(statearr_38647_38676[(2)] = inst_38608);

(statearr_38647_38676[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38640 === (3))){
var inst_38637 = (state_38639[(2)]);
var state_38639__$1 = state_38639;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38639__$1,inst_38637);
} else {
if((state_val_38640 === (12))){
var inst_38617 = (state_38639[(8)]);
var inst_38619 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_38620 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_38617,inst_38619);
var state_38639__$1 = state_38639;
var statearr_38648_38677 = state_38639__$1;
(statearr_38648_38677[(2)] = inst_38620);

(statearr_38648_38677[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38640 === (2))){
var _ = (function (){var statearr_38649 = state_38639;
(statearr_38649[(4)] = cljs.core.cons((5),(state_38639[(4)])));

return statearr_38649;
})();
var inst_38605 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_38639__$1 = (function (){var statearr_38650 = state_38639;
(statearr_38650[(7)] = inst_38605);

return statearr_38650;
})();
if(cljs.core.truth_(fuel)){
var statearr_38651_38678 = state_38639__$1;
(statearr_38651_38678[(1)] = (6));

} else {
var statearr_38652_38679 = state_38639__$1;
(statearr_38652_38679[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38640 === (11))){
var inst_38617 = (state_38639[(2)]);
var state_38639__$1 = (function (){var statearr_38654 = state_38639;
(statearr_38654[(8)] = inst_38617);

return statearr_38654;
})();
if(cljs.core.truth_(limit)){
var statearr_38655_38680 = state_38639__$1;
(statearr_38655_38680[(1)] = (12));

} else {
var statearr_38656_38681 = state_38639__$1;
(statearr_38656_38681[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38640 === (9))){
var inst_38611 = (state_38639[(9)]);
var inst_38613 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_38614 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_38611,inst_38613);
var state_38639__$1 = state_38639;
var statearr_38657_38682 = state_38639__$1;
(statearr_38657_38682[(2)] = inst_38614);

(statearr_38657_38682[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38640 === (5))){
var _ = (function (){var statearr_38658 = state_38639;
(statearr_38658[(4)] = cljs.core.rest((state_38639[(4)])));

return statearr_38658;
})();
var state_38639__$1 = state_38639;
var ex38653 = (state_38639__$1[(2)]);
var statearr_38659_38683 = state_38639__$1;
(statearr_38659_38683[(5)] = ex38653);


if((ex38653 instanceof Error)){
var statearr_38660_38684 = state_38639__$1;
(statearr_38660_38684[(1)] = (4));

(statearr_38660_38684[(5)] = null);

} else {
throw ex38653;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38640 === (14))){
var inst_38623 = (state_38639[(2)]);
var inst_38624 = (function (){return (function (x){
var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4115__auto__;
}
});
})();
var inst_38625 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_38624);
var inst_38626 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_38623,inst_38625);
var inst_38627 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_38626,flakes);
var inst_38628 = cljs.core.PersistentVector.EMPTY;
var inst_38629 = (function (){var xf = inst_38626;
var flakes_by_sub = inst_38627;
return (function (p1__38595_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__38595_SHARP_);
});
})();
var inst_38630 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_38629,inst_38627);
var inst_38631 = fluree.db.util.async.merge_into_QMARK_(inst_38628,inst_38630);
var state_38639__$1 = state_38639;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38639__$1,(15),inst_38631);
} else {
if((state_val_38640 === (10))){
var inst_38611 = (state_38639[(9)]);
var state_38639__$1 = state_38639;
var statearr_38661_38685 = state_38639__$1;
(statearr_38661_38685[(2)] = inst_38611);

(statearr_38661_38685[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38640 === (8))){
var inst_38611 = (state_38639[(2)]);
var state_38639__$1 = (function (){var statearr_38662 = state_38639;
(statearr_38662[(9)] = inst_38611);

return statearr_38662;
})();
if(cljs.core.truth_(offset)){
var statearr_38663_38686 = state_38639__$1;
(statearr_38663_38686[(1)] = (9));

} else {
var statearr_38664_38687 = state_38639__$1;
(statearr_38664_38687[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16301__auto__ = null;
var fluree$db$query$fql$state_machine__16301__auto____0 = (function (){
var statearr_38665 = [null,null,null,null,null,null,null,null,null,null];
(statearr_38665[(0)] = fluree$db$query$fql$state_machine__16301__auto__);

(statearr_38665[(1)] = (1));

return statearr_38665;
});
var fluree$db$query$fql$state_machine__16301__auto____1 = (function (state_38639){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_38639);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e38666){var ex__16304__auto__ = e38666;
var statearr_38667_38688 = state_38639;
(statearr_38667_38688[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_38639[(4)]))){
var statearr_38668_38689 = state_38639;
(statearr_38668_38689[(1)] = cljs.core.first((state_38639[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__38690 = state_38639;
state_38639 = G__38690;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16301__auto__ = function(state_38639){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16301__auto____1.call(this,state_38639);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16301__auto____0;
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16301__auto____1;
return fluree$db$query$fql$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_38669 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_38669[(6)] = c__16375__auto__);

return statearr_38669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__38692 = arguments.length;
switch (G__38692) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_38776){
var state_val_38777 = (state_38776[(1)]);
if((state_val_38777 === (7))){
var inst_38771 = (state_38776[(2)]);
var _ = (function (){var statearr_38779 = state_38776;
(statearr_38779[(4)] = cljs.core.rest((state_38776[(4)])));

return statearr_38779;
})();
var state_38776__$1 = state_38776;
var statearr_38780_38827 = state_38776__$1;
(statearr_38780_38827[(2)] = inst_38771);

(statearr_38780_38827[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (20))){
var inst_38712 = (state_38776[(7)]);
var inst_38713 = (state_38776[(8)]);
var inst_38720 = (state_38776[(9)]);
var inst_38741 = (inst_38712 + (1));
var tmp38778 = inst_38713;
var inst_38711 = inst_38720;
var inst_38712__$1 = inst_38741;
var inst_38713__$1 = tmp38778;
var state_38776__$1 = (function (){var statearr_38781 = state_38776;
(statearr_38781[(7)] = inst_38712__$1);

(statearr_38781[(8)] = inst_38713__$1);

(statearr_38781[(10)] = inst_38711);

return statearr_38781;
})();
var statearr_38782_38828 = state_38776__$1;
(statearr_38782_38828[(2)] = null);

(statearr_38782_38828[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (27))){
var inst_38746 = (state_38776[(11)]);
var inst_38755 = (state_38776[(2)]);
var inst_38756 = fluree.db.util.async.throw_err(inst_38755);
var inst_38757 = (inst_38746.cljs$core$IFn$_invoke$arity$1 ? inst_38746.cljs$core$IFn$_invoke$arity$1(inst_38756) : inst_38746.call(null,inst_38756));
var state_38776__$1 = state_38776;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38776__$1,(26),inst_38757);
} else {
if((state_val_38777 === (1))){
var state_38776__$1 = state_38776;
var statearr_38783_38829 = state_38776__$1;
(statearr_38783_38829[(2)] = null);

(statearr_38783_38829[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (24))){
var state_38776__$1 = state_38776;
var statearr_38784_38830 = state_38776__$1;
(statearr_38784_38830[(2)] = null);

(statearr_38784_38830[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (4))){
var inst_38693 = (state_38776[(2)]);
var state_38776__$1 = state_38776;
var statearr_38785_38831 = state_38776__$1;
(statearr_38785_38831[(2)] = inst_38693);

(statearr_38785_38831[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (15))){
var inst_38734 = (state_38776[(12)]);
var inst_38734__$1 = offset;
var state_38776__$1 = (function (){var statearr_38786 = state_38776;
(statearr_38786[(12)] = inst_38734__$1);

return statearr_38786;
})();
if(cljs.core.truth_(inst_38734__$1)){
var statearr_38787_38832 = state_38776__$1;
(statearr_38787_38832[(1)] = (17));

} else {
var statearr_38788_38833 = state_38776__$1;
(statearr_38788_38833[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (21))){
var state_38776__$1 = state_38776;
var statearr_38789_38834 = state_38776__$1;
(statearr_38789_38834[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (13))){
var inst_38729 = (state_38776[(2)]);
var state_38776__$1 = state_38776;
var statearr_38791_38835 = state_38776__$1;
(statearr_38791_38835[(2)] = inst_38729);

(statearr_38791_38835[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (22))){
var inst_38767 = (state_38776[(2)]);
var state_38776__$1 = state_38776;
var statearr_38792_38836 = state_38776__$1;
(statearr_38792_38836[(2)] = inst_38767);

(statearr_38792_38836[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (6))){
var inst_38721 = (state_38776[(13)]);
var inst_38719 = (state_38776[(14)]);
var inst_38711 = (state_38776[(10)]);
var inst_38718 = cljs.core.seq(inst_38711);
var inst_38719__$1 = cljs.core.first(inst_38718);
var inst_38720 = cljs.core.next(inst_38718);
var inst_38721__$1 = (inst_38719__$1 == null);
var state_38776__$1 = (function (){var statearr_38793 = state_38776;
(statearr_38793[(13)] = inst_38721__$1);

(statearr_38793[(14)] = inst_38719__$1);

(statearr_38793[(9)] = inst_38720);

return statearr_38793;
})();
if(cljs.core.truth_(inst_38721__$1)){
var statearr_38794_38837 = state_38776__$1;
(statearr_38794_38837[(1)] = (8));

} else {
var statearr_38795_38838 = state_38776__$1;
(statearr_38795_38838[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (25))){
var inst_38765 = (state_38776[(2)]);
var state_38776__$1 = state_38776;
var statearr_38796_38839 = state_38776__$1;
(statearr_38796_38839[(2)] = inst_38765);

(statearr_38796_38839[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (17))){
var inst_38712 = (state_38776[(7)]);
var inst_38736 = (inst_38712 < offset);
var state_38776__$1 = state_38776;
var statearr_38797_38840 = state_38776__$1;
(statearr_38797_38840[(2)] = inst_38736);

(statearr_38797_38840[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (3))){
var inst_38774 = (state_38776[(2)]);
var state_38776__$1 = state_38776;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38776__$1,inst_38774);
} else {
if((state_val_38777 === (12))){
var inst_38724 = (state_38776[(15)]);
var state_38776__$1 = state_38776;
var statearr_38798_38841 = state_38776__$1;
(statearr_38798_38841[(2)] = inst_38724);

(statearr_38798_38841[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (2))){
var inst_38706 = (state_38776[(16)]);
var _ = (function (){var statearr_38799 = state_38776;
(statearr_38799[(4)] = cljs.core.cons((5),(state_38776[(4)])));

return statearr_38799;
})();
var inst_38706__$1 = subjects;
var inst_38707 = cljs.core.seq(inst_38706__$1);
var inst_38708 = cljs.core.first(inst_38707);
var inst_38709 = cljs.core.next(inst_38707);
var inst_38710 = cljs.core.PersistentVector.EMPTY;
var inst_38711 = inst_38706__$1;
var inst_38712 = (0);
var inst_38713 = inst_38710;
var state_38776__$1 = (function (){var statearr_38800 = state_38776;
(statearr_38800[(16)] = inst_38706__$1);

(statearr_38800[(17)] = inst_38709);

(statearr_38800[(18)] = inst_38708);

(statearr_38800[(7)] = inst_38712);

(statearr_38800[(8)] = inst_38713);

(statearr_38800[(10)] = inst_38711);

return statearr_38800;
})();
var statearr_38801_38842 = state_38776__$1;
(statearr_38801_38842[(2)] = null);

(statearr_38801_38842[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (23))){
var inst_38706 = (state_38776[(16)]);
var inst_38709 = (state_38776[(17)]);
var inst_38719 = (state_38776[(14)]);
var inst_38708 = (state_38776[(18)]);
var inst_38712 = (state_38776[(7)]);
var inst_38713 = (state_38776[(8)]);
var inst_38711 = (state_38776[(10)]);
var inst_38720 = (state_38776[(9)]);
var inst_38745 = (inst_38712 + (1));
var inst_38746 = (function (){var first__38705 = inst_38708;
var vec__38703 = inst_38706;
var seq__38704 = inst_38709;
var r = inst_38720;
var vec__38715 = inst_38711;
var acc = inst_38713;
var seq__38716 = inst_38720;
var n = inst_38712;
var s = inst_38719;
var first__38717 = inst_38719;
var G__38702 = inst_38711;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_38747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38748 = [inst_38719];
var inst_38749 = (new cljs.core.PersistentVector(null,1,(5),inst_38747,inst_38748,null));
var inst_38750 = [cljs.core.cst$kw$limit];
var inst_38751 = [limit];
var inst_38752 = cljs.core.PersistentHashMap.fromArrays(inst_38750,inst_38751);
var inst_38753 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38749,inst_38752);
var state_38776__$1 = (function (){var statearr_38802 = state_38776;
(statearr_38802[(11)] = inst_38746);

(statearr_38802[(19)] = inst_38745);

return statearr_38802;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38776__$1,(27),inst_38753);
} else {
if((state_val_38777 === (19))){
var inst_38739 = (state_38776[(2)]);
var state_38776__$1 = state_38776;
if(cljs.core.truth_(inst_38739)){
var statearr_38803_38843 = state_38776__$1;
(statearr_38803_38843[(1)] = (20));

} else {
var statearr_38804_38844 = state_38776__$1;
(statearr_38804_38844[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (11))){
var inst_38712 = (state_38776[(7)]);
var inst_38726 = (inst_38712 > limit);
var state_38776__$1 = state_38776;
var statearr_38806_38845 = state_38776__$1;
(statearr_38806_38845[(2)] = inst_38726);

(statearr_38806_38845[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (9))){
var inst_38724 = (state_38776[(15)]);
var inst_38724__$1 = limit;
var state_38776__$1 = (function (){var statearr_38807 = state_38776;
(statearr_38807[(15)] = inst_38724__$1);

return statearr_38807;
})();
if(cljs.core.truth_(inst_38724__$1)){
var statearr_38808_38846 = state_38776__$1;
(statearr_38808_38846[(1)] = (11));

} else {
var statearr_38809_38847 = state_38776__$1;
(statearr_38809_38847[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (5))){
var _ = (function (){var statearr_38810 = state_38776;
(statearr_38810[(4)] = cljs.core.rest((state_38776[(4)])));

return statearr_38810;
})();
var state_38776__$1 = state_38776;
var ex38805 = (state_38776__$1[(2)]);
var statearr_38811_38848 = state_38776__$1;
(statearr_38811_38848[(5)] = ex38805);


if((ex38805 instanceof Error)){
var statearr_38812_38849 = state_38776__$1;
(statearr_38812_38849[(1)] = (4));

(statearr_38812_38849[(5)] = null);

} else {
throw ex38805;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (14))){
var inst_38713 = (state_38776[(8)]);
var state_38776__$1 = state_38776;
var statearr_38813_38850 = state_38776__$1;
(statearr_38813_38850[(2)] = inst_38713);

(statearr_38813_38850[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (26))){
var inst_38745 = (state_38776[(19)]);
var inst_38713 = (state_38776[(8)]);
var inst_38720 = (state_38776[(9)]);
var inst_38759 = (state_38776[(2)]);
var inst_38760 = fluree.db.util.async.throw_err(inst_38759);
var inst_38761 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38713,inst_38760);
var inst_38711 = inst_38720;
var inst_38712 = inst_38745;
var inst_38713__$1 = inst_38761;
var state_38776__$1 = (function (){var statearr_38814 = state_38776;
(statearr_38814[(7)] = inst_38712);

(statearr_38814[(8)] = inst_38713__$1);

(statearr_38814[(10)] = inst_38711);

return statearr_38814;
})();
var statearr_38815_38851 = state_38776__$1;
(statearr_38815_38851[(2)] = null);

(statearr_38815_38851[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (16))){
var inst_38769 = (state_38776[(2)]);
var state_38776__$1 = state_38776;
var statearr_38816_38852 = state_38776__$1;
(statearr_38816_38852[(2)] = inst_38769);

(statearr_38816_38852[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (10))){
var inst_38731 = (state_38776[(2)]);
var state_38776__$1 = state_38776;
if(cljs.core.truth_(inst_38731)){
var statearr_38817_38853 = state_38776__$1;
(statearr_38817_38853[(1)] = (14));

} else {
var statearr_38818_38854 = state_38776__$1;
(statearr_38818_38854[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (18))){
var inst_38734 = (state_38776[(12)]);
var state_38776__$1 = state_38776;
var statearr_38819_38855 = state_38776__$1;
(statearr_38819_38855[(2)] = inst_38734);

(statearr_38819_38855[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38777 === (8))){
var inst_38721 = (state_38776[(13)]);
var state_38776__$1 = state_38776;
var statearr_38820_38856 = state_38776__$1;
(statearr_38820_38856[(2)] = inst_38721);

(statearr_38820_38856[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16301__auto__ = null;
var fluree$db$query$fql$state_machine__16301__auto____0 = (function (){
var statearr_38821 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38821[(0)] = fluree$db$query$fql$state_machine__16301__auto__);

(statearr_38821[(1)] = (1));

return statearr_38821;
});
var fluree$db$query$fql$state_machine__16301__auto____1 = (function (state_38776){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_38776);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e38822){var ex__16304__auto__ = e38822;
var statearr_38823_38857 = state_38776;
(statearr_38823_38857[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_38776[(4)]))){
var statearr_38824_38858 = state_38776;
(statearr_38824_38858[(1)] = cljs.core.first((state_38776[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__38859 = state_38776;
state_38776 = G__38859;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16301__auto__ = function(state_38776){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16301__auto____1.call(this,state_38776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16301__auto____0;
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16301__auto____1;
return fluree$db$query$fql$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_38825 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_38825[(6)] = c__16375__auto__);

return statearr_38825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4126__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__38861 = arguments.length;
switch (G__38861) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_39049){
var state_val_39050 = (state_39049[(1)]);
if((state_val_39050 === (7))){
var state_39049__$1 = state_39049;
var statearr_39051_39122 = state_39049__$1;
(statearr_39051_39122[(2)] = null);

(statearr_39051_39122[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (20))){
var inst_38904 = (state_39049[(7)]);
var inst_38902 = (state_39049[(8)]);
var inst_38932 = (state_39049[(2)]);
var inst_38933 = fluree.db.util.async.throw_err(inst_38932);
var inst_38934 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38935 = [inst_38902];
var inst_38936 = (new cljs.core.PersistentVector(null,1,(5),inst_38934,inst_38935,null));
var inst_38937 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38938 = [inst_38902,inst_38904];
var inst_38939 = (new cljs.core.PersistentVector(null,2,(5),inst_38937,inst_38938,null));
var inst_38940 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_38936,cljs.core._LT_,inst_38939);
var state_39049__$1 = (function (){var statearr_39052 = state_39049;
(statearr_39052[(9)] = inst_38933);

return statearr_39052;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39049__$1,(21),inst_38940);
} else {
if((state_val_39050 === (27))){
var inst_38903 = (state_39049[(10)]);
var inst_38921 = (state_39049[(11)]);
var inst_38969 = (inst_38921.cljs$core$IFn$_invoke$arity$2 ? inst_38921.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_38903) : inst_38921.call(null,cljs.core._GT__EQ_,inst_38903));
var state_39049__$1 = state_39049;
if(cljs.core.truth_(inst_38969)){
var statearr_39053_39123 = state_39049__$1;
(statearr_39053_39123[(1)] = (30));

} else {
var statearr_39054_39124 = state_39049__$1;
(statearr_39054_39124[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (1))){
var state_39049__$1 = state_39049;
var statearr_39055_39125 = state_39049__$1;
(statearr_39055_39125[(2)] = null);

(statearr_39055_39125[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (24))){
var inst_39018 = (state_39049[(2)]);
var state_39049__$1 = state_39049;
var statearr_39056_39126 = state_39049__$1;
(statearr_39056_39126[(2)] = inst_39018);

(statearr_39056_39126[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (39))){
var inst_39008 = null;
var state_39049__$1 = state_39049;
var statearr_39057_39127 = state_39049__$1;
(statearr_39057_39127[(2)] = inst_39008);

(statearr_39057_39127[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (46))){
var inst_39029 = (state_39049[(12)]);
var inst_38895 = (state_39049[(13)]);
var inst_38887 = inst_38895;
var inst_38888 = inst_39029;
var state_39049__$1 = (function (){var statearr_39058 = state_39049;
(statearr_39058[(14)] = inst_38888);

(statearr_39058[(15)] = inst_38887);

return statearr_39058;
})();
var statearr_39059_39128 = state_39049__$1;
(statearr_39059_39128[(2)] = null);

(statearr_39059_39128[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (4))){
var inst_38862 = (state_39049[(2)]);
var state_39049__$1 = state_39049;
var statearr_39060_39129 = state_39049__$1;
(statearr_39060_39129[(2)] = inst_38862);

(statearr_39060_39129[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (15))){
var state_39049__$1 = state_39049;
var statearr_39061_39130 = state_39049__$1;
(statearr_39061_39130[(2)] = null);

(statearr_39061_39130[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (21))){
var inst_38933 = (state_39049[(9)]);
var inst_38942 = (state_39049[(2)]);
var inst_38943 = fluree.db.util.async.throw_err(inst_38942);
var inst_38944 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_38933,inst_38943);
var state_39049__$1 = state_39049;
var statearr_39062_39131 = state_39049__$1;
(statearr_39062_39131[(2)] = inst_38944);

(statearr_39062_39131[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (31))){
var inst_38903 = (state_39049[(10)]);
var inst_38921 = (state_39049[(11)]);
var inst_38982 = (inst_38921.cljs$core$IFn$_invoke$arity$2 ? inst_38921.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_38903) : inst_38921.call(null,cljs.core._LT_,inst_38903));
var state_39049__$1 = state_39049;
if(cljs.core.truth_(inst_38982)){
var statearr_39063_39132 = state_39049__$1;
(statearr_39063_39132[(1)] = (34));

} else {
var statearr_39064_39133 = state_39049__$1;
(statearr_39064_39133[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (32))){
var inst_39014 = (state_39049[(2)]);
var state_39049__$1 = state_39049;
var statearr_39065_39134 = state_39049__$1;
(statearr_39065_39134[(2)] = inst_39014);

(statearr_39065_39134[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (40))){
var inst_39010 = (state_39049[(2)]);
var state_39049__$1 = state_39049;
var statearr_39066_39135 = state_39049__$1;
(statearr_39066_39135[(2)] = inst_39010);

(statearr_39066_39135[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (33))){
var inst_38979 = (state_39049[(2)]);
var inst_38980 = fluree.db.util.async.throw_err(inst_38979);
var state_39049__$1 = state_39049;
var statearr_39067_39136 = state_39049__$1;
(statearr_39067_39136[(2)] = inst_38980);

(statearr_39067_39136[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (13))){
var inst_39039 = (state_39049[(2)]);
var state_39049__$1 = state_39049;
var statearr_39068_39137 = state_39049__$1;
(statearr_39068_39137[(2)] = inst_39039);

(statearr_39068_39137[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (22))){
var inst_38904 = (state_39049[(7)]);
var inst_38902 = (state_39049[(8)]);
var inst_38948 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38949 = [inst_38902,inst_38904];
var inst_38950 = (new cljs.core.PersistentVector(null,2,(5),inst_38948,inst_38949,null));
var inst_38951 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_38950);
var state_39049__$1 = state_39049;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39049__$1,(25),inst_38951);
} else {
if((state_val_39050 === (36))){
var inst_39012 = (state_39049[(2)]);
var state_39049__$1 = state_39049;
var statearr_39069_39138 = state_39049__$1;
(statearr_39069_39138[(2)] = inst_39012);

(statearr_39069_39138[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (41))){
var inst_39005 = (state_39049[(2)]);
var inst_39006 = fluree.db.util.async.throw_err(inst_39005);
var state_39049__$1 = state_39049;
var statearr_39070_39139 = state_39049__$1;
(statearr_39070_39139[(2)] = inst_39006);

(statearr_39070_39139[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (43))){
var inst_38888 = (state_39049[(14)]);
var inst_39021 = (state_39049[(16)]);
var inst_39022 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38888,inst_39021);
var state_39049__$1 = state_39049;
var statearr_39071_39140 = state_39049__$1;
(statearr_39071_39140[(2)] = inst_39022);

(statearr_39071_39140[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (29))){
var inst_38966 = (state_39049[(2)]);
var inst_38967 = fluree.db.util.async.throw_err(inst_38966);
var state_39049__$1 = state_39049;
var statearr_39072_39141 = state_39049__$1;
(statearr_39072_39141[(2)] = inst_38967);

(statearr_39072_39141[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (44))){
var inst_38888 = (state_39049[(14)]);
var inst_39021 = (state_39049[(16)]);
var inst_39024 = cljs.core.PersistentHashSet.EMPTY;
var inst_39025 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39024,inst_39021);
var inst_39026 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_38888,inst_39025);
var state_39049__$1 = state_39049;
var statearr_39073_39142 = state_39049__$1;
(statearr_39073_39142[(2)] = inst_39026);

(statearr_39073_39142[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (6))){
var inst_38873 = (state_39049[(17)]);
var inst_38883 = cljs.core.seq(inst_38873);
var inst_38884 = cljs.core.first(inst_38883);
var inst_38885 = cljs.core.next(inst_38883);
var inst_38886 = cljs.core.PersistentHashSet.EMPTY;
var inst_38887 = inst_38873;
var inst_38888 = inst_38886;
var state_39049__$1 = (function (){var statearr_39074 = state_39049;
(statearr_39074[(14)] = inst_38888);

(statearr_39074[(18)] = inst_38885);

(statearr_39074[(19)] = inst_38884);

(statearr_39074[(15)] = inst_38887);

return statearr_39074;
})();
var statearr_39075_39143 = state_39049__$1;
(statearr_39075_39143[(2)] = null);

(statearr_39075_39143[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (28))){
var inst_39016 = (state_39049[(2)]);
var state_39049__$1 = state_39049;
var statearr_39076_39144 = state_39049__$1;
(statearr_39076_39144[(2)] = inst_39016);

(statearr_39076_39144[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (25))){
var inst_38953 = (state_39049[(2)]);
var inst_38954 = fluree.db.util.async.throw_err(inst_38953);
var state_39049__$1 = state_39049;
var statearr_39077_39145 = state_39049__$1;
(statearr_39077_39145[(2)] = inst_38954);

(statearr_39077_39145[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (34))){
var inst_38904 = (state_39049[(7)]);
var inst_38902 = (state_39049[(8)]);
var inst_38984 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38985 = [inst_38902];
var inst_38986 = (new cljs.core.PersistentVector(null,1,(5),inst_38984,inst_38985,null));
var inst_38987 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38988 = [inst_38902,inst_38904];
var inst_38989 = (new cljs.core.PersistentVector(null,2,(5),inst_38987,inst_38988,null));
var inst_38990 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_38986,cljs.core._LT_,inst_38989);
var state_39049__$1 = state_39049;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39049__$1,(37),inst_38990);
} else {
if((state_val_39050 === (17))){
var inst_38904 = (state_39049[(7)]);
var inst_38902 = (state_39049[(8)]);
var inst_38924 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38925 = [inst_38902,inst_38904];
var inst_38926 = (new cljs.core.PersistentVector(null,2,(5),inst_38924,inst_38925,null));
var inst_38927 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38928 = [inst_38902];
var inst_38929 = (new cljs.core.PersistentVector(null,1,(5),inst_38927,inst_38928,null));
var inst_38930 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_38926,cljs.core._LT__EQ_,inst_38929);
var state_39049__$1 = state_39049;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39049__$1,(20),inst_38930);
} else {
if((state_val_39050 === (3))){
var inst_39047 = (state_39049[(2)]);
var state_39049__$1 = state_39049;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39049__$1,inst_39047);
} else {
if((state_val_39050 === (12))){
var inst_38894 = (state_39049[(20)]);
var inst_38902 = (state_39049[(8)]);
var inst_38902__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38894,(0),null);
var inst_38903 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38894,(1),null);
var inst_38904 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38894,(2),null);
var inst_38905 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_38902__$1);
var inst_38906 = cljs.core.not(inst_38905);
var state_39049__$1 = (function (){var statearr_39078 = state_39049;
(statearr_39078[(7)] = inst_38904);

(statearr_39078[(10)] = inst_38903);

(statearr_39078[(8)] = inst_38902__$1);

return statearr_39078;
})();
if(inst_38906){
var statearr_39079_39146 = state_39049__$1;
(statearr_39079_39146[(1)] = (14));

} else {
var statearr_39080_39147 = state_39049__$1;
(statearr_39080_39147[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (2))){
var inst_38873 = (state_39049[(17)]);
var _ = (function (){var statearr_39081 = state_39049;
(statearr_39081[(4)] = cljs.core.cons((5),(state_39049[(4)])));

return statearr_39081;
})();
var inst_38871 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_38872 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38871,(0),null);
var inst_38873__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38871,(1),null);
var inst_38874 = cljs.core.not_empty(inst_38873__$1);
var state_39049__$1 = (function (){var statearr_39082 = state_39049;
(statearr_39082[(17)] = inst_38873__$1);

(statearr_39082[(21)] = inst_38872);

return statearr_39082;
})();
if(cljs.core.truth_(inst_38874)){
var statearr_39083_39148 = state_39049__$1;
(statearr_39083_39148[(1)] = (6));

} else {
var statearr_39084_39149 = state_39049__$1;
(statearr_39084_39149[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (23))){
var inst_38903 = (state_39049[(10)]);
var inst_38921 = (state_39049[(11)]);
var inst_38956 = (inst_38921.cljs$core$IFn$_invoke$arity$2 ? inst_38921.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_38903) : inst_38921.call(null,cljs.core._GT_,inst_38903));
var state_39049__$1 = state_39049;
if(cljs.core.truth_(inst_38956)){
var statearr_39085_39150 = state_39049__$1;
(statearr_39085_39150[(1)] = (26));

} else {
var statearr_39086_39151 = state_39049__$1;
(statearr_39086_39151[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (47))){
var inst_39037 = (state_39049[(2)]);
var state_39049__$1 = state_39049;
var statearr_39087_39152 = state_39049__$1;
(statearr_39087_39152[(2)] = inst_39037);

(statearr_39087_39152[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (35))){
var inst_38903 = (state_39049[(10)]);
var inst_38921 = (state_39049[(11)]);
var inst_38995 = (inst_38921.cljs$core$IFn$_invoke$arity$2 ? inst_38921.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_38903) : inst_38921.call(null,cljs.core._LT__EQ_,inst_38903));
var state_39049__$1 = state_39049;
if(cljs.core.truth_(inst_38995)){
var statearr_39088_39153 = state_39049__$1;
(statearr_39088_39153[(1)] = (38));

} else {
var statearr_39089_39154 = state_39049__$1;
(statearr_39089_39154[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (19))){
var inst_38872 = (state_39049[(21)]);
var inst_39020 = (state_39049[(2)]);
var inst_39021 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_39020);
var state_39049__$1 = (function (){var statearr_39090 = state_39049;
(statearr_39090[(16)] = inst_39021);

return statearr_39090;
})();
var G__39091_39155 = inst_38872;
var G__39091_39156__$1 = (((G__39091_39155 instanceof cljs.core.Keyword))?G__39091_39155.fqn:null);
switch (G__39091_39156__$1) {
case "or":
var statearr_39092_39158 = state_39049__$1;
(statearr_39092_39158[(1)] = (43));


break;
case "and":
var statearr_39093_39159 = state_39049__$1;
(statearr_39093_39159[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__39091_39156__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (11))){
var inst_38888 = (state_39049[(14)]);
var state_39049__$1 = state_39049;
var statearr_39095_39160 = state_39049__$1;
(statearr_39095_39160[(2)] = inst_38888);

(statearr_39095_39160[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (9))){
var inst_38894 = (state_39049[(20)]);
var inst_38887 = (state_39049[(15)]);
var inst_38893 = cljs.core.seq(inst_38887);
var inst_38894__$1 = cljs.core.first(inst_38893);
var inst_38895 = cljs.core.next(inst_38893);
var inst_38896 = cljs.core.not(inst_38894__$1);
var state_39049__$1 = (function (){var statearr_39096 = state_39049;
(statearr_39096[(20)] = inst_38894__$1);

(statearr_39096[(13)] = inst_38895);

return statearr_39096;
})();
if(inst_38896){
var statearr_39097_39161 = state_39049__$1;
(statearr_39097_39161[(1)] = (11));

} else {
var statearr_39098_39162 = state_39049__$1;
(statearr_39098_39162[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (5))){
var _ = (function (){var statearr_39099 = state_39049;
(statearr_39099[(4)] = cljs.core.rest((state_39049[(4)])));

return statearr_39099;
})();
var state_39049__$1 = state_39049;
var ex39094 = (state_39049__$1[(2)]);
var statearr_39100_39163 = state_39049__$1;
(statearr_39100_39163[(5)] = ex39094);


if((ex39094 instanceof Error)){
var statearr_39101_39164 = state_39049__$1;
(statearr_39101_39164[(1)] = (4));

(statearr_39101_39164[(5)] = null);

} else {
throw ex39094;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (14))){
var inst_38902 = (state_39049[(8)]);
var inst_38908 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_38902);
var inst_38909 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38908)].join('');
var inst_38910 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38911 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_38912 = cljs.core.PersistentHashMap.fromArrays(inst_38910,inst_38911);
var inst_38913 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38909,inst_38912);
var inst_38914 = (function(){throw inst_38913})();
var state_39049__$1 = state_39049;
var statearr_39102_39165 = state_39049__$1;
(statearr_39102_39165[(2)] = inst_38914);

(statearr_39102_39165[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (45))){
var inst_39029 = (state_39049[(12)]);
var state_39049__$1 = state_39049;
var statearr_39103_39166 = state_39049__$1;
(statearr_39103_39166[(2)] = inst_39029);

(statearr_39103_39166[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (26))){
var inst_38904 = (state_39049[(7)]);
var inst_38902 = (state_39049[(8)]);
var inst_38958 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38959 = [inst_38902,inst_38904];
var inst_38960 = (new cljs.core.PersistentVector(null,2,(5),inst_38958,inst_38959,null));
var inst_38961 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38962 = [inst_38902];
var inst_38963 = (new cljs.core.PersistentVector(null,1,(5),inst_38961,inst_38962,null));
var inst_38964 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_38960,cljs.core._LT__EQ_,inst_38963);
var state_39049__$1 = state_39049;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39049__$1,(29),inst_38964);
} else {
if((state_val_39050 === (16))){
var inst_38903 = (state_39049[(10)]);
var inst_38921 = (state_39049[(11)]);
var inst_38917 = (state_39049[(2)]);
var inst_38921__$1 = cljs.core.identical_QMARK_;
var inst_38922 = (inst_38921__$1.cljs$core$IFn$_invoke$arity$2 ? inst_38921__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_38903) : inst_38921__$1.call(null,cljs.core.not_EQ_,inst_38903));
var state_39049__$1 = (function (){var statearr_39104 = state_39049;
(statearr_39104[(22)] = inst_38917);

(statearr_39104[(11)] = inst_38921__$1);

return statearr_39104;
})();
if(cljs.core.truth_(inst_38922)){
var statearr_39105_39167 = state_39049__$1;
(statearr_39105_39167[(1)] = (17));

} else {
var statearr_39106_39168 = state_39049__$1;
(statearr_39106_39168[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (38))){
var inst_38904 = (state_39049[(7)]);
var inst_38902 = (state_39049[(8)]);
var inst_38997 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38998 = [inst_38902];
var inst_38999 = (new cljs.core.PersistentVector(null,1,(5),inst_38997,inst_38998,null));
var inst_39000 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39001 = [inst_38902,inst_38904];
var inst_39002 = (new cljs.core.PersistentVector(null,2,(5),inst_39000,inst_39001,null));
var inst_39003 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_38999,cljs.core._LT__EQ_,inst_39002);
var state_39049__$1 = state_39049;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39049__$1,(41),inst_39003);
} else {
if((state_val_39050 === (30))){
var inst_38904 = (state_39049[(7)]);
var inst_38902 = (state_39049[(8)]);
var inst_38971 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38972 = [inst_38902,inst_38904];
var inst_38973 = (new cljs.core.PersistentVector(null,2,(5),inst_38971,inst_38972,null));
var inst_38974 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38975 = [inst_38902];
var inst_38976 = (new cljs.core.PersistentVector(null,1,(5),inst_38974,inst_38975,null));
var inst_38977 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_38973,cljs.core._LT__EQ_,inst_38976);
var state_39049__$1 = state_39049;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39049__$1,(33),inst_38977);
} else {
if((state_val_39050 === (10))){
var inst_39041 = (state_39049[(2)]);
var state_39049__$1 = state_39049;
var statearr_39107_39169 = state_39049__$1;
(statearr_39107_39169[(2)] = inst_39041);

(statearr_39107_39169[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (18))){
var inst_38903 = (state_39049[(10)]);
var inst_38921 = (state_39049[(11)]);
var inst_38946 = (inst_38921.cljs$core$IFn$_invoke$arity$2 ? inst_38921.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_38903) : inst_38921.call(null,cljs.core._EQ_,inst_38903));
var state_39049__$1 = state_39049;
if(cljs.core.truth_(inst_38946)){
var statearr_39108_39170 = state_39049__$1;
(statearr_39108_39170[(1)] = (22));

} else {
var statearr_39109_39171 = state_39049__$1;
(statearr_39109_39171[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (42))){
var inst_38872 = (state_39049[(21)]);
var inst_39029 = (state_39049[(12)]);
var inst_39029__$1 = (state_39049[(2)]);
var inst_39030 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_38872);
var inst_39031 = cljs.core.empty_QMARK_(inst_39029__$1);
var inst_39032 = ((inst_39030) && (inst_39031));
var state_39049__$1 = (function (){var statearr_39110 = state_39049;
(statearr_39110[(12)] = inst_39029__$1);

return statearr_39110;
})();
if(cljs.core.truth_(inst_39032)){
var statearr_39111_39172 = state_39049__$1;
(statearr_39111_39172[(1)] = (45));

} else {
var statearr_39112_39173 = state_39049__$1;
(statearr_39112_39173[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (37))){
var inst_38992 = (state_39049[(2)]);
var inst_38993 = fluree.db.util.async.throw_err(inst_38992);
var state_39049__$1 = state_39049;
var statearr_39113_39174 = state_39049__$1;
(statearr_39113_39174[(2)] = inst_38993);

(statearr_39113_39174[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39050 === (8))){
var inst_39044 = (state_39049[(2)]);
var _ = (function (){var statearr_39114 = state_39049;
(statearr_39114[(4)] = cljs.core.rest((state_39049[(4)])));

return statearr_39114;
})();
var state_39049__$1 = state_39049;
var statearr_39115_39175 = state_39049__$1;
(statearr_39115_39175[(2)] = inst_39044);

(statearr_39115_39175[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16301__auto__ = null;
var fluree$db$query$fql$state_machine__16301__auto____0 = (function (){
var statearr_39116 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39116[(0)] = fluree$db$query$fql$state_machine__16301__auto__);

(statearr_39116[(1)] = (1));

return statearr_39116;
});
var fluree$db$query$fql$state_machine__16301__auto____1 = (function (state_39049){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_39049);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e39117){var ex__16304__auto__ = e39117;
var statearr_39118_39176 = state_39049;
(statearr_39118_39176[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_39049[(4)]))){
var statearr_39119_39177 = state_39049;
(statearr_39119_39177[(1)] = cljs.core.first((state_39049[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__39178 = state_39049;
state_39049 = G__39178;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16301__auto__ = function(state_39049){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16301__auto____1.call(this,state_39049);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16301__auto____0;
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16301__auto____1;
return fluree$db$query$fql$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_39120 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_39120[(6)] = c__16375__auto__);

return statearr_39120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

/**
 * Order By can be:
 *  - Single variable, ?favNums
 *  - Two-tuple,  [ASC, ?favNums]
 */
fluree.db.query.fql.order_offset_and_limit_results = (function fluree$db$query$fql$order_offset_and_limit_results(tuples,headers,orderBy,offset,limit){
var vec__39180 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39180,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39180,(1),null);
var indexOfFind = (function (){var or__4126__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (-1);
}
})();
var tuples_SINGLEQUOTE_ = ((((0) <= indexOfFind))?(function (){var G__39183 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__39179_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__39179_SHARP_,indexOfFind);
}),fluree.db.query.fql.compare_fn,tuples);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order)){
return cljs.core.reverse(G__39183);
} else {
return G__39183;
}
})():tuples);
var G__39184 = tuples_SINGLEQUOTE_;
var G__39184__$1 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__39184):G__39184);
var G__39184__$2 = (cljs.core.truth_(limit)?cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__39184__$1):G__39184__$1);
if(cljs.core.vector_QMARK_(tuples)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,G__39184__$2);
} else {
return G__39184__$2;
}
});
fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4126__auto__ = cljs.core.every_QMARK_((function (p1__39185_SHARP_){
return ((typeof p1__39185_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__39185_SHARP_)));
}),select_smt);
if(or__4126__auto__){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__39186_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__39186_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__39190 = vars;
var vec__39191 = G__39190;
var seq__39192 = cljs.core.seq(vec__39191);
var first__39193 = cljs.core.first(seq__39192);
var seq__39192__$1 = cljs.core.next(seq__39192);
var var$ = first__39193;
var r = seq__39192__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__39190__$1 = G__39190;
var all_vars__$1 = all_vars;
while(true){
var vec__39198 = G__39190__$1;
var seq__39199 = cljs.core.seq(vec__39198);
var first__39200 = cljs.core.first(seq__39199);
var seq__39199__$1 = cljs.core.next(seq__39199);
var var$__$1 = first__39200;
var r__$1 = seq__39199__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__39201 = cljs.core.set(all_vars__$2);
return (fexpr__39201.cljs$core$IFn$_invoke$arity$1 ? fexpr__39201.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__39201.call(null,var$__$1));
})())){
var G__39202 = r__$1;
var G__39203 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__39190__$1 = G__39202;
all_vars__$1 = G__39203;
continue;
} else {
var G__39204 = r__$1;
var G__39205 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__39190__$1 = G__39204;
all_vars__$1 = G__39205;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_39240){
var state_val_39241 = (state_39240[(1)]);
if((state_val_39241 === (1))){
var inst_39213 = functionArray;
var inst_39214 = cljs.core.seq(inst_39213);
var inst_39215 = cljs.core.first(inst_39214);
var inst_39216 = cljs.core.next(inst_39214);
var inst_39217 = cljs.core.PersistentVector.EMPTY;
var inst_39218 = inst_39213;
var inst_39219 = inst_39217;
var state_39240__$1 = (function (){var statearr_39242 = state_39240;
(statearr_39242[(7)] = inst_39215);

(statearr_39242[(8)] = inst_39216);

(statearr_39242[(9)] = inst_39219);

(statearr_39242[(10)] = inst_39218);

return statearr_39242;
})();
var statearr_39243_39256 = state_39240__$1;
(statearr_39243_39256[(2)] = null);

(statearr_39243_39256[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39241 === (2))){
var inst_39225 = (state_39240[(11)]);
var inst_39218 = (state_39240[(10)]);
var inst_39224 = cljs.core.seq(inst_39218);
var inst_39225__$1 = cljs.core.first(inst_39224);
var inst_39226 = cljs.core.next(inst_39224);
var state_39240__$1 = (function (){var statearr_39244 = state_39240;
(statearr_39244[(11)] = inst_39225__$1);

(statearr_39244[(12)] = inst_39226);

return statearr_39244;
})();
if(cljs.core.truth_(inst_39225__$1)){
var statearr_39245_39257 = state_39240__$1;
(statearr_39245_39257[(1)] = (4));

} else {
var statearr_39246_39258 = state_39240__$1;
(statearr_39246_39258[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39241 === (3))){
var inst_39238 = (state_39240[(2)]);
var state_39240__$1 = state_39240;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39240__$1,inst_39238);
} else {
if((state_val_39241 === (4))){
var inst_39225 = (state_39240[(11)]);
var inst_39228 = (inst_39225.cljs$core$IFn$_invoke$arity$1 ? inst_39225.cljs$core$IFn$_invoke$arity$1(tuple) : inst_39225.call(null,tuple));
var state_39240__$1 = state_39240;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39240__$1,(7),inst_39228);
} else {
if((state_val_39241 === (5))){
var inst_39219 = (state_39240[(9)]);
var state_39240__$1 = state_39240;
var statearr_39247_39259 = state_39240__$1;
(statearr_39247_39259[(2)] = inst_39219);

(statearr_39247_39259[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39241 === (6))){
var inst_39236 = (state_39240[(2)]);
var state_39240__$1 = state_39240;
var statearr_39248_39260 = state_39240__$1;
(statearr_39248_39260[(2)] = inst_39236);

(statearr_39248_39260[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39241 === (7))){
var inst_39219 = (state_39240[(9)]);
var inst_39226 = (state_39240[(12)]);
var inst_39230 = (state_39240[(2)]);
var inst_39231 = fluree.db.util.async.throw_err(inst_39230);
var inst_39232 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39219,inst_39231);
var inst_39218 = inst_39226;
var inst_39219__$1 = inst_39232;
var state_39240__$1 = (function (){var statearr_39249 = state_39240;
(statearr_39249[(9)] = inst_39219__$1);

(statearr_39249[(10)] = inst_39218);

return statearr_39249;
})();
var statearr_39250_39261 = state_39240__$1;
(statearr_39250_39261[(2)] = null);

(statearr_39250_39261[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__16301__auto____0 = (function (){
var statearr_39251 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39251[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__16301__auto__);

(statearr_39251[(1)] = (1));

return statearr_39251;
});
var fluree$db$query$fql$format_tuple_$_state_machine__16301__auto____1 = (function (state_39240){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_39240);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e39252){var ex__16304__auto__ = e39252;
var statearr_39253_39262 = state_39240;
(statearr_39253_39262[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_39240[(4)]))){
var statearr_39254_39263 = state_39240;
(statearr_39254_39263[(1)] = cljs.core.first((state_39240[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__39264 = state_39240;
state_39240 = G__39264;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__16301__auto__ = function(state_39240){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__16301__auto____1.call(this,state_39240);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__16301__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__16301__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_39255 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_39255[(6)] = c__16375__auto__);

return statearr_39255;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
fluree.db.query.fql.format_filter_tuples = (function fluree$db$query$fql$format_filter_tuples(db,tuples,p__39266,headers,vars,opts){
var map__39267 = p__39266;
var map__39267__$1 = (((((!((map__39267 == null))))?(((((map__39267.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39267.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39267):map__39267);
var select_spec = map__39267__$1;
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39267__$1,cljs.core.cst$kw$prettyPrint);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39267__$1,cljs.core.cst$kw$select);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39267__$1,cljs.core.cst$kw$inVector_QMARK_);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39267__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_39354){
var state_val_39355 = (state_39354[(1)]);
if((state_val_39355 === (7))){
var state_39354__$1 = state_39354;
var statearr_39356_39498 = state_39354__$1;
(statearr_39356_39498[(2)] = null);

(statearr_39356_39498[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (1))){
var state_39354__$1 = state_39354;
var statearr_39357_39499 = state_39354__$1;
(statearr_39357_39499[(2)] = null);

(statearr_39357_39499[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (4))){
var inst_39269 = (state_39354[(2)]);
var state_39354__$1 = state_39354;
var statearr_39358_39500 = state_39354__$1;
(statearr_39358_39500[(2)] = inst_39269);

(statearr_39358_39500[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (15))){
var inst_39343 = (state_39354[(2)]);
var inst_39344 = fluree.db.util.async.throw_err(inst_39343);
var state_39354__$1 = state_39354;
var statearr_39359_39501 = state_39354__$1;
(statearr_39359_39501[(2)] = inst_39344);

(statearr_39359_39501[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (13))){
var inst_39287 = (state_39354[(7)]);
var inst_39279 = (state_39354[(8)]);
var inst_39346 = (function (){var pp = inst_39279;
var functionArray = inst_39287;
return (function (tuple){
var tuple_res = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39265_SHARP_){
return (p1__39265_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__39265_SHARP_.cljs$core$IFn$_invoke$arity$1(tuple) : p1__39265_SHARP_.call(null,tuple));
}),functionArray);
if(cljs.core.truth_(pp)){
return cljs.core.zipmap(pp,tuple_res);
} else {
if(cljs.core.truth_(inVector_QMARK_)){
return tuple_res;
} else {
return cljs.core.first(tuple_res);

}
}
});
})();
var inst_39347 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39346,tuples);
var state_39354__$1 = state_39354;
var statearr_39360_39502 = state_39354__$1;
(statearr_39360_39502[(2)] = inst_39347);

(statearr_39360_39502[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (6))){
var inst_39276 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_39354__$1 = state_39354;
var statearr_39361_39503 = state_39354__$1;
(statearr_39361_39503[(2)] = inst_39276);

(statearr_39361_39503[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (3))){
var inst_39352 = (state_39354[(2)]);
var state_39354__$1 = state_39354;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39354__$1,inst_39352);
} else {
if((state_val_39355 === (12))){
var inst_39287 = (state_39354[(7)]);
var inst_39279 = (state_39354[(8)]);
var inst_39339 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_39340 = (function (){var pp = inst_39279;
var functionArray = inst_39287;
var c__16375__auto____$1 = inst_39339;
return (function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_39337){
var state_val_39338 = (state_39337[(1)]);
if((state_val_39338 === (7))){
var inst_39313 = (state_39337[(2)]);
var inst_39314 = fluree.db.util.async.throw_err(inst_39313);
var state_39337__$1 = (function (){var statearr_39362 = state_39337;
(statearr_39362[(7)] = inst_39314);

return statearr_39362;
})();
if(cljs.core.truth_(pp)){
var statearr_39363_39504 = state_39337__$1;
(statearr_39363_39504[(1)] = (8));

} else {
var statearr_39364_39505 = state_39337__$1;
(statearr_39364_39505[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39338 === (1))){
var inst_39296 = tuples;
var inst_39297 = cljs.core.seq(inst_39296);
var inst_39298 = cljs.core.first(inst_39297);
var inst_39299 = cljs.core.next(inst_39297);
var inst_39300 = cljs.core.PersistentVector.EMPTY;
var inst_39301 = inst_39296;
var inst_39302 = inst_39300;
var state_39337__$1 = (function (){var statearr_39365 = state_39337;
(statearr_39365[(8)] = inst_39301);

(statearr_39365[(9)] = inst_39299);

(statearr_39365[(10)] = inst_39298);

(statearr_39365[(11)] = inst_39302);

return statearr_39365;
})();
var statearr_39366_39506 = state_39337__$1;
(statearr_39366_39506[(2)] = null);

(statearr_39366_39506[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39338 === (4))){
var inst_39308 = (state_39337[(12)]);
var inst_39311 = fluree.db.query.fql.format_tuple(functionArray,inst_39308);
var state_39337__$1 = state_39337;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39337__$1,(7),inst_39311);
} else {
if((state_val_39338 === (15))){
var state_39337__$1 = state_39337;
var statearr_39367_39507 = state_39337__$1;
(statearr_39367_39507[(2)] = null);

(statearr_39367_39507[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39338 === (13))){
var inst_39326 = (state_39337[(2)]);
var state_39337__$1 = state_39337;
var statearr_39368_39508 = state_39337__$1;
(statearr_39368_39508[(2)] = inst_39326);

(statearr_39368_39508[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39338 === (6))){
var inst_39333 = (state_39337[(2)]);
var state_39337__$1 = state_39337;
var statearr_39369_39509 = state_39337__$1;
(statearr_39369_39509[(2)] = inst_39333);

(statearr_39369_39509[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39338 === (3))){
var inst_39335 = (state_39337[(2)]);
var state_39337__$1 = state_39337;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39337__$1,inst_39335);
} else {
if((state_val_39338 === (12))){
var state_39337__$1 = state_39337;
var statearr_39370_39510 = state_39337__$1;
(statearr_39370_39510[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39338 === (2))){
var inst_39301 = (state_39337[(8)]);
var inst_39308 = (state_39337[(12)]);
var inst_39307 = cljs.core.seq(inst_39301);
var inst_39308__$1 = cljs.core.first(inst_39307);
var inst_39309 = cljs.core.next(inst_39307);
var state_39337__$1 = (function (){var statearr_39372 = state_39337;
(statearr_39372[(12)] = inst_39308__$1);

(statearr_39372[(13)] = inst_39309);

return statearr_39372;
})();
if(cljs.core.truth_(inst_39308__$1)){
var statearr_39373_39511 = state_39337__$1;
(statearr_39373_39511[(1)] = (4));

} else {
var statearr_39374_39512 = state_39337__$1;
(statearr_39374_39512[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39338 === (11))){
var inst_39314 = (state_39337[(7)]);
var state_39337__$1 = state_39337;
var statearr_39375_39513 = state_39337__$1;
(statearr_39375_39513[(2)] = inst_39314);

(statearr_39375_39513[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39338 === (9))){
var state_39337__$1 = state_39337;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_39376_39514 = state_39337__$1;
(statearr_39376_39514[(1)] = (11));

} else {
var statearr_39377_39515 = state_39337__$1;
(statearr_39377_39515[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39338 === (5))){
var inst_39302 = (state_39337[(11)]);
var state_39337__$1 = state_39337;
var statearr_39378_39516 = state_39337__$1;
(statearr_39378_39516[(2)] = inst_39302);

(statearr_39378_39516[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39338 === (14))){
var inst_39314 = (state_39337[(7)]);
var inst_39321 = cljs.core.first(inst_39314);
var state_39337__$1 = state_39337;
var statearr_39379_39517 = state_39337__$1;
(statearr_39379_39517[(2)] = inst_39321);

(statearr_39379_39517[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39338 === (16))){
var inst_39324 = (state_39337[(2)]);
var state_39337__$1 = state_39337;
var statearr_39380_39518 = state_39337__$1;
(statearr_39380_39518[(2)] = inst_39324);

(statearr_39380_39518[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39338 === (10))){
var inst_39309 = (state_39337[(13)]);
var inst_39302 = (state_39337[(11)]);
var inst_39328 = (state_39337[(2)]);
var inst_39329 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39302,inst_39328);
var inst_39301 = inst_39309;
var inst_39302__$1 = inst_39329;
var state_39337__$1 = (function (){var statearr_39381 = state_39337;
(statearr_39381[(8)] = inst_39301);

(statearr_39381[(11)] = inst_39302__$1);

return statearr_39381;
})();
var statearr_39382_39519 = state_39337__$1;
(statearr_39382_39519[(2)] = null);

(statearr_39382_39519[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39338 === (8))){
var inst_39314 = (state_39337[(7)]);
var inst_39316 = cljs.core.zipmap(pp,inst_39314);
var state_39337__$1 = state_39337;
var statearr_39383_39520 = state_39337__$1;
(statearr_39383_39520[(2)] = inst_39316);

(statearr_39383_39520[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_39384 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39384[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__);

(statearr_39384[(1)] = (1));

return statearr_39384;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1 = (function (state_39337){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_39337);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e39385){var ex__16304__auto__ = e39385;
var statearr_39386_39521 = state_39337;
(statearr_39386_39521[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_39337[(4)]))){
var statearr_39387_39522 = state_39337;
(statearr_39387_39522[(1)] = cljs.core.first((state_39337[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__39523 = state_39337;
state_39337 = G__39523;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = function(state_39337){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1.call(this,state_39337);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_39388 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_39388[(6)] = c__16375__auto____$1);

return statearr_39388;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
});
})();
var inst_39341 = cljs.core.async.impl.dispatch.run(inst_39340);
var state_39354__$1 = (function (){var statearr_39389 = state_39354;
(statearr_39389[(9)] = inst_39341);

return statearr_39389;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39354__$1,(15),inst_39339);
} else {
if((state_val_39355 === (2))){
var _ = (function (){var statearr_39390 = state_39354;
(statearr_39390[(4)] = cljs.core.cons((5),(state_39354[(4)])));

return statearr_39390;
})();
var state_39354__$1 = state_39354;
if(cljs.core.truth_(prettyPrint)){
var statearr_39391_39524 = state_39354__$1;
(statearr_39391_39524[(1)] = (6));

} else {
var statearr_39392_39525 = state_39354__$1;
(statearr_39392_39525[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (11))){
var inst_39287 = (state_39354[(2)]);
var state_39354__$1 = (function (){var statearr_39394 = state_39354;
(statearr_39394[(7)] = inst_39287);

return statearr_39394;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_39395_39526 = state_39354__$1;
(statearr_39395_39526[(1)] = (12));

} else {
var statearr_39396_39527 = state_39354__$1;
(statearr_39396_39527[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (9))){
var inst_39279 = (state_39354[(8)]);
var inst_39281 = (function (){var pp = inst_39279;
return (function (select__$1){
var select_val = (function (){var or__4126__auto__ = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1);
}
})();
var idx = (cljs.core.truth_(select_val)?fluree.db.util.core.index_of(headers,select_val):null);
var select_fn = (cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1))?(function (tuple){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?(function (tuple){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val);
}):null)));
if(cljs.core.truth_(cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select__$1))){
return (function (tuple){
var c__16375__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_39431){
var state_val_39432 = (state_39431[(1)]);
if((state_val_39432 === (7))){
var state_39431__$1 = state_39431;
var statearr_39433_39528 = state_39431__$1;
(statearr_39433_39528[(2)] = null);

(statearr_39433_39528[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39432 === (1))){
var state_39431__$1 = state_39431;
var statearr_39434_39529 = state_39431__$1;
(statearr_39434_39529[(2)] = null);

(statearr_39434_39529[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39432 === (4))){
var inst_39397 = (state_39431[(2)]);
var state_39431__$1 = state_39431;
var statearr_39435_39530 = state_39431__$1;
(statearr_39435_39530[(2)] = inst_39397);

(statearr_39435_39530[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39432 === (6))){
var inst_39407 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_39408 = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select__$1);
var inst_39409 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_39410 = [inst_39408,inst_39409,opts];
var inst_39411 = cljs.core.PersistentHashMap.fromArrays(inst_39407,inst_39410);
var inst_39412 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_39411) : fluree.db.query.fql.query.call(null,db,inst_39411));
var state_39431__$1 = state_39431;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39431__$1,(9),inst_39412);
} else {
if((state_val_39432 === (3))){
var inst_39429 = (state_39431[(2)]);
var state_39431__$1 = state_39431;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39431__$1,inst_39429);
} else {
if((state_val_39432 === (12))){
var inst_39423 = (state_39431[(2)]);
var state_39431__$1 = state_39431;
var statearr_39436_39531 = state_39431__$1;
(statearr_39436_39531[(2)] = inst_39423);

(statearr_39436_39531[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39432 === (2))){
var _ = (function (){var statearr_39437 = state_39431;
(statearr_39437[(4)] = cljs.core.cons((5),(state_39431[(4)])));

return statearr_39437;
})();
var inst_39403 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var state_39431__$1 = state_39431;
if(cljs.core.truth_(inst_39403)){
var statearr_39438_39532 = state_39431__$1;
(statearr_39438_39532[(1)] = (6));

} else {
var statearr_39439_39533 = state_39431__$1;
(statearr_39439_39533[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39432 === (11))){
var inst_39418 = [cljs.core.cst$kw$_id];
var inst_39419 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var inst_39420 = [inst_39419];
var inst_39421 = cljs.core.PersistentHashMap.fromArrays(inst_39418,inst_39420);
var state_39431__$1 = state_39431;
var statearr_39441_39534 = state_39431__$1;
(statearr_39441_39534[(2)] = inst_39421);

(statearr_39441_39534[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39432 === (9))){
var inst_39415 = (state_39431[(7)]);
var inst_39414 = (state_39431[(2)]);
var inst_39415__$1 = fluree.db.util.async.throw_err(inst_39414);
var state_39431__$1 = (function (){var statearr_39442 = state_39431;
(statearr_39442[(7)] = inst_39415__$1);

return statearr_39442;
})();
if(cljs.core.truth_(inst_39415__$1)){
var statearr_39443_39535 = state_39431__$1;
(statearr_39443_39535[(1)] = (10));

} else {
var statearr_39444_39536 = state_39431__$1;
(statearr_39444_39536[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39432 === (5))){
var _ = (function (){var statearr_39445 = state_39431;
(statearr_39445[(4)] = cljs.core.rest((state_39431[(4)])));

return statearr_39445;
})();
var state_39431__$1 = state_39431;
var ex39440 = (state_39431__$1[(2)]);
var statearr_39446_39537 = state_39431__$1;
(statearr_39446_39537[(5)] = ex39440);


if((ex39440 instanceof Error)){
var statearr_39447_39538 = state_39431__$1;
(statearr_39447_39538[(1)] = (4));

(statearr_39447_39538[(5)] = null);

} else {
throw ex39440;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39432 === (10))){
var inst_39415 = (state_39431[(7)]);
var state_39431__$1 = state_39431;
var statearr_39448_39539 = state_39431__$1;
(statearr_39448_39539[(2)] = inst_39415);

(statearr_39448_39539[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39432 === (8))){
var inst_39426 = (state_39431[(2)]);
var _ = (function (){var statearr_39449 = state_39431;
(statearr_39449[(4)] = cljs.core.rest((state_39431[(4)])));

return statearr_39449;
})();
var state_39431__$1 = state_39431;
var statearr_39450_39540 = state_39431__$1;
(statearr_39450_39540[(2)] = inst_39426);

(statearr_39450_39540[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_39451 = [null,null,null,null,null,null,null,null];
(statearr_39451[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__);

(statearr_39451[(1)] = (1));

return statearr_39451;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1 = (function (state_39431){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_39431);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e39452){var ex__16304__auto__ = e39452;
var statearr_39453_39541 = state_39431;
(statearr_39453_39541[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_39431[(4)]))){
var statearr_39454_39542 = state_39431;
(statearr_39454_39542[(1)] = cljs.core.first((state_39431[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__39543 = state_39431;
state_39431 = G__39543;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = function(state_39431){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1.call(this,state_39431);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_39455 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_39455[(6)] = c__16375__auto____$1);

return statearr_39455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto____$1;
});
} else {
return (function (tuple){
var c__16375__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_39467){
var state_val_39468 = (state_39467[(1)]);
if((state_val_39468 === (1))){
var state_39467__$1 = state_39467;
var statearr_39469_39544 = state_39467__$1;
(statearr_39469_39544[(2)] = null);

(statearr_39469_39544[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39468 === (2))){
var _ = (function (){var statearr_39470 = state_39467;
(statearr_39470[(4)] = cljs.core.cons((5),(state_39467[(4)])));

return statearr_39470;
})();
var inst_39462 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var ___$1 = (function (){var statearr_39471 = state_39467;
(statearr_39471[(4)] = cljs.core.rest((state_39467[(4)])));

return statearr_39471;
})();
var state_39467__$1 = state_39467;
var statearr_39472_39545 = state_39467__$1;
(statearr_39472_39545[(2)] = inst_39462);

(statearr_39472_39545[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39468 === (3))){
var inst_39465 = (state_39467[(2)]);
var state_39467__$1 = state_39467;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39467__$1,inst_39465);
} else {
if((state_val_39468 === (4))){
var inst_39456 = (state_39467[(2)]);
var state_39467__$1 = state_39467;
var statearr_39474_39546 = state_39467__$1;
(statearr_39474_39546[(2)] = inst_39456);

(statearr_39474_39546[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39468 === (5))){
var _ = (function (){var statearr_39475 = state_39467;
(statearr_39475[(4)] = cljs.core.rest((state_39467[(4)])));

return statearr_39475;
})();
var state_39467__$1 = state_39467;
var ex39473 = (state_39467__$1[(2)]);
var statearr_39476_39547 = state_39467__$1;
(statearr_39476_39547[(5)] = ex39473);


if((ex39473 instanceof Error)){
var statearr_39477_39548 = state_39467__$1;
(statearr_39477_39548[(1)] = (4));

(statearr_39477_39548[(5)] = null);

} else {
throw ex39473;

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_39478 = [null,null,null,null,null,null,null];
(statearr_39478[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__);

(statearr_39478[(1)] = (1));

return statearr_39478;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1 = (function (state_39467){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_39467);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e39479){var ex__16304__auto__ = e39479;
var statearr_39480_39549 = state_39467;
(statearr_39480_39549[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_39467[(4)]))){
var statearr_39481_39550 = state_39467;
(statearr_39481_39550[(1)] = cljs.core.first((state_39467[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__39551 = state_39467;
state_39467 = G__39551;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = function(state_39467){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1.call(this,state_39467);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_39482 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_39482[(6)] = c__16375__auto____$1);

return statearr_39482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto____$1;
});
}
});
})();
var inst_39282 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39281,select);
var state_39354__$1 = state_39354;
var statearr_39483_39552 = state_39354__$1;
(statearr_39483_39552[(2)] = inst_39282);

(statearr_39483_39552[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (5))){
var _ = (function (){var statearr_39484 = state_39354;
(statearr_39484[(4)] = cljs.core.rest((state_39354[(4)])));

return statearr_39484;
})();
var state_39354__$1 = state_39354;
var ex39393 = (state_39354__$1[(2)]);
var statearr_39485_39553 = state_39354__$1;
(statearr_39485_39553[(5)] = ex39393);


if((ex39393 instanceof Error)){
var statearr_39486_39554 = state_39354__$1;
(statearr_39486_39554[(1)] = (4));

(statearr_39486_39554[(5)] = null);

} else {
throw ex39393;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (14))){
var inst_39349 = (state_39354[(2)]);
var _ = (function (){var statearr_39487 = state_39354;
(statearr_39487[(4)] = cljs.core.rest((state_39354[(4)])));

return statearr_39487;
})();
var state_39354__$1 = state_39354;
var statearr_39488_39555 = state_39354__$1;
(statearr_39488_39555[(2)] = inst_39349);

(statearr_39488_39555[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (10))){
var inst_39279 = (state_39354[(8)]);
var inst_39284 = (function (){var pp = inst_39279;
return (function (select__$1){
var temp__5733__auto__ = cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(temp__5733__auto__)){
var val = temp__5733__auto__;
return (function (x){
return val;
});
} else {
var idx = fluree.db.query.fql.get_header_idx(headers,select__$1);
return (function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
});
}
});
})();
var inst_39285 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39284,select);
var state_39354__$1 = state_39354;
var statearr_39489_39556 = state_39354__$1;
(statearr_39489_39556[(2)] = inst_39285);

(statearr_39489_39556[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39355 === (8))){
var inst_39279 = (state_39354[(2)]);
var state_39354__$1 = (function (){var statearr_39490 = state_39354;
(statearr_39490[(8)] = inst_39279);

return statearr_39490;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_39491_39557 = state_39354__$1;
(statearr_39491_39557[(1)] = (9));

} else {
var statearr_39492_39558 = state_39354__$1;
(statearr_39492_39558[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0 = (function (){
var statearr_39493 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39493[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__);

(statearr_39493[(1)] = (1));

return statearr_39493;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1 = (function (state_39354){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_39354);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e39494){var ex__16304__auto__ = e39494;
var statearr_39495_39559 = state_39354;
(statearr_39495_39559[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_39354[(4)]))){
var statearr_39496_39560 = state_39354;
(statearr_39496_39560[(1)] = cljs.core.first((state_39354[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__39561 = state_39354;
state_39354 = G__39561;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__ = function(state_39354){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1.call(this,state_39354);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_39497 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_39497[(6)] = c__16375__auto__);

return statearr_39497;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__39563 = arguments.length;
switch (G__39563) {
case 4:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4 = (function (db,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5 = (function (db,p__39564,p__39565,group_limit,opts){
var map__39566 = p__39564;
var map__39566__$1 = (((((!((map__39566 == null))))?(((((map__39566.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39566.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39566):map__39566);
var res = map__39566__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39566__$1,cljs.core.cst$kw$vars);
var map__39567 = p__39565;
var map__39567__$1 = (((((!((map__39567 == null))))?(((((map__39567.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39567.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39567):map__39567);
var select_spec = map__39567__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39567__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39567__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39567__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39567__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39567__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39567__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39567__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39567__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39567__$1,cljs.core.cst$kw$groupBy);
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_39723){
var state_val_39724 = (state_39723[(1)]);
if((state_val_39724 === (65))){
var inst_39691 = (state_39723[(7)]);
var state_39723__$1 = state_39723;
var statearr_39725_39844 = state_39723__$1;
(statearr_39725_39844[(2)] = inst_39691);

(statearr_39725_39844[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (70))){
var inst_39702 = (state_39723[(8)]);
var state_39723__$1 = state_39723;
var statearr_39726_39845 = state_39723__$1;
(statearr_39726_39845[(2)] = inst_39702);

(statearr_39726_39845[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (62))){
var inst_39679 = (state_39723[(9)]);
var state_39723__$1 = state_39723;
var statearr_39727_39846 = state_39723__$1;
(statearr_39727_39846[(2)] = inst_39679);

(statearr_39727_39846[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (74))){
var inst_39701 = (state_39723[(10)]);
var state_39723__$1 = state_39723;
var statearr_39728_39847 = state_39723__$1;
(statearr_39728_39847[(2)] = inst_39701);

(statearr_39728_39847[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (7))){
var inst_39576 = (state_39723[(11)]);
var state_39723__$1 = state_39723;
var statearr_39729_39848 = state_39723__$1;
(statearr_39729_39848[(2)] = inst_39576);

(statearr_39729_39848[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (59))){
var inst_39680 = (state_39723[(12)]);
var state_39723__$1 = state_39723;
var statearr_39730_39849 = state_39723__$1;
(statearr_39730_39849[(2)] = inst_39680);

(statearr_39730_39849[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (20))){
var inst_39611 = (state_39723[(13)]);
var inst_39611__$1 = (state_39723[(2)]);
var inst_39613 = (inst_39611__$1 == null);
var inst_39614 = cljs.core.not(inst_39613);
var state_39723__$1 = (function (){var statearr_39731 = state_39723;
(statearr_39731[(13)] = inst_39611__$1);

return statearr_39731;
})();
if(inst_39614){
var statearr_39732_39850 = state_39723__$1;
(statearr_39732_39850[(1)] = (21));

} else {
var statearr_39733_39851 = state_39723__$1;
(statearr_39733_39851[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (72))){
var inst_39707 = (state_39723[(2)]);
var state_39723__$1 = state_39723;
if(cljs.core.truth_(inst_39707)){
var statearr_39734_39852 = state_39723__$1;
(statearr_39734_39852[(1)] = (73));

} else {
var statearr_39735_39853 = state_39723__$1;
(statearr_39735_39853[(1)] = (74));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (58))){
var inst_39682 = ((0) < offset);
var state_39723__$1 = state_39723;
var statearr_39736_39854 = state_39723__$1;
(statearr_39736_39854[(2)] = inst_39682);

(statearr_39736_39854[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (60))){
var inst_39685 = (state_39723[(2)]);
var state_39723__$1 = state_39723;
if(cljs.core.truth_(inst_39685)){
var statearr_39737_39855 = state_39723__$1;
(statearr_39737_39855[(1)] = (61));

} else {
var statearr_39738_39856 = state_39723__$1;
(statearr_39738_39856[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (27))){
var inst_39611 = (state_39723[(13)]);
var inst_39629 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_39611);
var state_39723__$1 = state_39723;
var statearr_39739_39857 = state_39723__$1;
(statearr_39739_39857[(2)] = inst_39629);

(statearr_39739_39857[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (1))){
var state_39723__$1 = state_39723;
var statearr_39740_39858 = state_39723__$1;
(statearr_39740_39858[(2)] = null);

(statearr_39740_39858[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (69))){
var inst_39702 = (state_39723[(8)]);
var inst_39701 = (state_39723[(2)]);
var inst_39702__$1 = inVector_QMARK_;
var state_39723__$1 = (function (){var statearr_39741 = state_39723;
(statearr_39741[(10)] = inst_39701);

(statearr_39741[(8)] = inst_39702__$1);

return statearr_39741;
})();
if(cljs.core.truth_(inst_39702__$1)){
var statearr_39742_39859 = state_39723__$1;
(statearr_39742_39859[(1)] = (70));

} else {
var statearr_39743_39860 = state_39723__$1;
(statearr_39743_39860[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (24))){
var state_39723__$1 = state_39723;
var statearr_39744_39861 = state_39723__$1;
(statearr_39744_39861[(2)] = true);

(statearr_39744_39861[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (55))){
var inst_39657 = (state_39723[(14)]);
var inst_39676 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_39657);
var state_39723__$1 = state_39723;
var statearr_39745_39862 = state_39723__$1;
(statearr_39745_39862[(2)] = inst_39676);

(statearr_39745_39862[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (39))){
var inst_39643 = (state_39723[(15)]);
var inst_39633 = (state_39723[(16)]);
var inst_39647 = (state_39723[(17)]);
var inst_39634 = (state_39723[(18)]);
var inst_39649 = fluree.db.query.fql.order_offset_and_limit_results(inst_39634,inst_39633,orderBy,inst_39643,inst_39647);
var state_39723__$1 = state_39723;
var statearr_39746_39863 = state_39723__$1;
(statearr_39746_39863[(2)] = inst_39649);

(statearr_39746_39863[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (46))){
var inst_39663 = (state_39723[(19)]);
var inst_39663__$1 = group_limit;
var state_39723__$1 = (function (){var statearr_39747 = state_39723;
(statearr_39747[(19)] = inst_39663__$1);

return statearr_39747;
})();
if(cljs.core.truth_(inst_39663__$1)){
var statearr_39748_39864 = state_39723__$1;
(statearr_39748_39864[(1)] = (49));

} else {
var statearr_39749_39865 = state_39723__$1;
(statearr_39749_39865[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (4))){
var inst_39570 = (state_39723[(2)]);
var state_39723__$1 = state_39723;
var statearr_39750_39866 = state_39723__$1;
(statearr_39750_39866[(2)] = inst_39570);

(statearr_39750_39866[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (54))){
var inst_39716 = (state_39723[(2)]);
var state_39723__$1 = state_39723;
var statearr_39751_39867 = state_39723__$1;
(statearr_39751_39867[(2)] = inst_39716);

(statearr_39751_39867[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (15))){
var inst_39597 = (state_39723[(20)]);
var inst_39599 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39600 = [inst_39597];
var inst_39601 = (new cljs.core.PersistentVector(null,1,(5),inst_39599,inst_39600,null));
var state_39723__$1 = state_39723;
var statearr_39752_39868 = state_39723__$1;
(statearr_39752_39868[(2)] = inst_39601);

(statearr_39752_39868[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (48))){
var inst_39670 = (state_39723[(2)]);
var state_39723__$1 = state_39723;
var statearr_39753_39869 = state_39723__$1;
(statearr_39753_39869[(2)] = inst_39670);

(statearr_39753_39869[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (50))){
var state_39723__$1 = state_39723;
var statearr_39754_39870 = state_39723__$1;
(statearr_39754_39870[(2)] = offset);

(statearr_39754_39870[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (75))){
var inst_39713 = (state_39723[(2)]);
var state_39723__$1 = state_39723;
var statearr_39755_39871 = state_39723__$1;
(statearr_39755_39871[(2)] = inst_39713);

(statearr_39755_39871[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (21))){
var inst_39611 = (state_39723[(13)]);
var inst_39616 = inst_39611.cljs$lang$protocol_mask$partition0$;
var inst_39617 = (inst_39616 & (64));
var inst_39618 = inst_39611.cljs$core$ISeq$;
var inst_39619 = (cljs.core.PROTOCOL_SENTINEL === inst_39618);
var inst_39620 = ((inst_39617) || (inst_39619));
var state_39723__$1 = state_39723;
if(cljs.core.truth_(inst_39620)){
var statearr_39756_39872 = state_39723__$1;
(statearr_39756_39872[(1)] = (24));

} else {
var statearr_39757_39873 = state_39723__$1;
(statearr_39757_39873[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (31))){
var state_39723__$1 = state_39723;
var statearr_39758_39874 = state_39723__$1;
(statearr_39758_39874[(2)] = groupBy);

(statearr_39758_39874[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (32))){
var inst_39639 = (state_39723[(2)]);
var state_39723__$1 = state_39723;
if(cljs.core.truth_(inst_39639)){
var statearr_39759_39875 = state_39723__$1;
(statearr_39759_39875[(1)] = (33));

} else {
var statearr_39760_39876 = state_39723__$1;
(statearr_39760_39876[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (40))){
var inst_39634 = (state_39723[(18)]);
var state_39723__$1 = state_39723;
var statearr_39761_39877 = state_39723__$1;
(statearr_39761_39877[(2)] = inst_39634);

(statearr_39761_39877[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (56))){
var inst_39657 = (state_39723[(14)]);
var state_39723__$1 = state_39723;
var statearr_39762_39878 = state_39723__$1;
(statearr_39762_39878[(2)] = inst_39657);

(statearr_39762_39878[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (33))){
var state_39723__$1 = state_39723;
var statearr_39763_39879 = state_39723__$1;
(statearr_39763_39879[(2)] = (0));

(statearr_39763_39879[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (13))){
var inst_39586 = (state_39723[(21)]);
var state_39723__$1 = state_39723;
var statearr_39764_39880 = state_39723__$1;
(statearr_39764_39880[(2)] = inst_39586);

(statearr_39764_39880[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (22))){
var state_39723__$1 = state_39723;
var statearr_39765_39881 = state_39723__$1;
(statearr_39765_39881[(2)] = false);

(statearr_39765_39881[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (36))){
var state_39723__$1 = state_39723;
var statearr_39766_39882 = state_39723__$1;
(statearr_39766_39882[(2)] = null);

(statearr_39766_39882[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (41))){
var inst_39633 = (state_39723[(16)]);
var inst_39652 = (state_39723[(2)]);
var inst_39653 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$limit,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$groupBy], 0));
var inst_39654 = fluree.db.query.fql.format_filter_tuples(db,inst_39652,select_spec,inst_39633,vars,inst_39653);
var state_39723__$1 = state_39723;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39723__$1,(42),inst_39654);
} else {
if((state_val_39724 === (43))){
var inst_39658 = (state_39723[(22)]);
var state_39723__$1 = state_39723;
var statearr_39767_39883 = state_39723__$1;
(statearr_39767_39883[(2)] = inst_39658);

(statearr_39767_39883[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (61))){
var inst_39679 = (state_39723[(9)]);
var inst_39687 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_39679);
var state_39723__$1 = state_39723;
var statearr_39768_39884 = state_39723__$1;
(statearr_39768_39884[(2)] = inst_39687);

(statearr_39768_39884[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (29))){
var inst_39635 = (state_39723[(23)]);
var inst_39632 = (state_39723[(2)]);
var inst_39633 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39632,cljs.core.cst$kw$headers);
var inst_39634 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39632,cljs.core.cst$kw$tuples);
var inst_39635__$1 = selectDistinct_QMARK_;
var state_39723__$1 = (function (){var statearr_39769 = state_39723;
(statearr_39769[(16)] = inst_39633);

(statearr_39769[(23)] = inst_39635__$1);

(statearr_39769[(18)] = inst_39634);

return statearr_39769;
})();
if(cljs.core.truth_(inst_39635__$1)){
var statearr_39770_39885 = state_39723__$1;
(statearr_39770_39885[(1)] = (30));

} else {
var statearr_39771_39886 = state_39723__$1;
(statearr_39771_39886[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (44))){
var inst_39661 = cljs.core.not(orderBy);
var state_39723__$1 = state_39723;
if(inst_39661){
var statearr_39772_39887 = state_39723__$1;
(statearr_39772_39887[(1)] = (46));

} else {
var statearr_39773_39888 = state_39723__$1;
(statearr_39773_39888[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (6))){
var inst_39578 = cljs.core.count(select);
var inst_39579 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_39578);
var state_39723__$1 = state_39723;
var statearr_39774_39889 = state_39723__$1;
(statearr_39774_39889[(2)] = inst_39579);

(statearr_39774_39889[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (28))){
var inst_39611 = (state_39723[(13)]);
var state_39723__$1 = state_39723;
var statearr_39775_39890 = state_39723__$1;
(statearr_39775_39890[(2)] = inst_39611);

(statearr_39775_39890[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (64))){
var inst_39693 = ((0) < group_limit);
var state_39723__$1 = state_39723;
var statearr_39776_39891 = state_39723__$1;
(statearr_39776_39891[(2)] = inst_39693);

(statearr_39776_39891[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (51))){
var inst_39667 = (state_39723[(2)]);
var state_39723__$1 = state_39723;
var statearr_39777_39892 = state_39723__$1;
(statearr_39777_39892[(2)] = inst_39667);

(statearr_39777_39892[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (25))){
var state_39723__$1 = state_39723;
var statearr_39778_39893 = state_39723__$1;
(statearr_39778_39893[(2)] = false);

(statearr_39778_39893[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (34))){
var state_39723__$1 = state_39723;
var statearr_39779_39894 = state_39723__$1;
(statearr_39779_39894[(2)] = offset);

(statearr_39779_39894[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (17))){
var inst_39604 = (state_39723[(2)]);
var state_39723__$1 = state_39723;
var statearr_39780_39895 = state_39723__$1;
(statearr_39780_39895[(2)] = inst_39604);

(statearr_39780_39895[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (3))){
var inst_39721 = (state_39723[(2)]);
var state_39723__$1 = state_39723;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39723__$1,inst_39721);
} else {
if((state_val_39724 === (12))){
var inst_39586 = (state_39723[(21)]);
var inst_39588 = cljs.core.first(select);
var inst_39589 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_39588);
var inst_39590 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39589);
var inst_39591 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_39590,(1));
var inst_39592 = [inst_39591];
var inst_39593 = [inst_39586];
var inst_39594 = cljs.core.PersistentHashMap.fromArrays(inst_39592,inst_39593);
var state_39723__$1 = state_39723;
var statearr_39781_39896 = state_39723__$1;
(statearr_39781_39896[(2)] = inst_39594);

(statearr_39781_39896[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (2))){
var inst_39576 = (state_39723[(11)]);
var _ = (function (){var statearr_39782 = state_39723;
(statearr_39782[(4)] = cljs.core.cons((5),(state_39723[(4)])));

return statearr_39782;
})();
var inst_39576__$1 = aggregates;
var state_39723__$1 = (function (){var statearr_39783 = state_39723;
(statearr_39783[(11)] = inst_39576__$1);

return statearr_39783;
})();
if(cljs.core.truth_(inst_39576__$1)){
var statearr_39784_39897 = state_39723__$1;
(statearr_39784_39897[(1)] = (6));

} else {
var statearr_39785_39898 = state_39723__$1;
(statearr_39785_39898[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (66))){
var inst_39696 = (state_39723[(2)]);
var state_39723__$1 = state_39723;
if(cljs.core.truth_(inst_39696)){
var statearr_39786_39899 = state_39723__$1;
(statearr_39786_39899[(1)] = (67));

} else {
var statearr_39787_39900 = state_39723__$1;
(statearr_39787_39900[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (23))){
var inst_39627 = (state_39723[(2)]);
var state_39723__$1 = state_39723;
if(cljs.core.truth_(inst_39627)){
var statearr_39788_39901 = state_39723__$1;
(statearr_39788_39901[(1)] = (27));

} else {
var statearr_39789_39902 = state_39723__$1;
(statearr_39789_39902[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (47))){
var state_39723__$1 = state_39723;
var statearr_39790_39903 = state_39723__$1;
(statearr_39790_39903[(2)] = false);

(statearr_39790_39903[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (35))){
var inst_39643 = (state_39723[(2)]);
var state_39723__$1 = (function (){var statearr_39791 = state_39723;
(statearr_39791[(15)] = inst_39643);

return statearr_39791;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_39792_39904 = state_39723__$1;
(statearr_39792_39904[(1)] = (36));

} else {
var statearr_39793_39905 = state_39723__$1;
(statearr_39793_39905[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (19))){
var state_39723__$1 = state_39723;
var statearr_39794_39906 = state_39723__$1;
(statearr_39794_39906[(2)] = res);

(statearr_39794_39906[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (57))){
var inst_39680 = (state_39723[(12)]);
var inst_39679 = (state_39723[(2)]);
var inst_39680__$1 = offset;
var state_39723__$1 = (function (){var statearr_39795 = state_39723;
(statearr_39795[(9)] = inst_39679);

(statearr_39795[(12)] = inst_39680__$1);

return statearr_39795;
})();
if(cljs.core.truth_(inst_39680__$1)){
var statearr_39796_39907 = state_39723__$1;
(statearr_39796_39907[(1)] = (58));

} else {
var statearr_39797_39908 = state_39723__$1;
(statearr_39797_39908[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (68))){
var inst_39690 = (state_39723[(24)]);
var state_39723__$1 = state_39723;
var statearr_39798_39909 = state_39723__$1;
(statearr_39798_39909[(2)] = inst_39690);

(statearr_39798_39909[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (11))){
var inst_39718 = (state_39723[(2)]);
var _ = (function (){var statearr_39800 = state_39723;
(statearr_39800[(4)] = cljs.core.rest((state_39723[(4)])));

return statearr_39800;
})();
var state_39723__$1 = state_39723;
var statearr_39801_39910 = state_39723__$1;
(statearr_39801_39910[(2)] = inst_39718);

(statearr_39801_39910[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (9))){
var inst_39584 = cljs.core.first(aggregates);
var inst_39585 = fluree.db.query.analytical.calculate_aggregate(res,inst_39584);
var inst_39586 = cljs.core.second(inst_39585);
var state_39723__$1 = (function (){var statearr_39802 = state_39723;
(statearr_39802[(21)] = inst_39586);

return statearr_39802;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_39803_39911 = state_39723__$1;
(statearr_39803_39911[(1)] = (12));

} else {
var statearr_39804_39912 = state_39723__$1;
(statearr_39804_39912[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (5))){
var _ = (function (){var statearr_39805 = state_39723;
(statearr_39805[(4)] = cljs.core.rest((state_39723[(4)])));

return statearr_39805;
})();
var state_39723__$1 = state_39723;
var ex39799 = (state_39723__$1[(2)]);
var statearr_39806_39913 = state_39723__$1;
(statearr_39806_39913[(5)] = ex39799);


if((ex39799 instanceof Error)){
var statearr_39807_39914 = state_39723__$1;
(statearr_39807_39914[(1)] = (4));

(statearr_39807_39914[(5)] = null);

} else {
throw ex39799;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (14))){
var inst_39597 = (state_39723[(2)]);
var state_39723__$1 = (function (){var statearr_39808 = state_39723;
(statearr_39808[(20)] = inst_39597);

return statearr_39808;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_39809_39915 = state_39723__$1;
(statearr_39809_39915[(1)] = (15));

} else {
var statearr_39810_39916 = state_39723__$1;
(statearr_39810_39916[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (45))){
var inst_39672 = (state_39723[(2)]);
var state_39723__$1 = state_39723;
if(cljs.core.truth_(inst_39672)){
var statearr_39811_39917 = state_39723__$1;
(statearr_39811_39917[(1)] = (52));

} else {
var statearr_39812_39918 = state_39723__$1;
(statearr_39812_39918[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (53))){
var inst_39657 = (state_39723[(14)]);
var state_39723__$1 = state_39723;
var statearr_39813_39919 = state_39723__$1;
(statearr_39813_39919[(2)] = inst_39657);

(statearr_39813_39919[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (26))){
var inst_39624 = (state_39723[(2)]);
var state_39723__$1 = state_39723;
var statearr_39814_39920 = state_39723__$1;
(statearr_39814_39920[(2)] = inst_39624);

(statearr_39814_39920[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (16))){
var inst_39597 = (state_39723[(20)]);
var state_39723__$1 = state_39723;
var statearr_39815_39921 = state_39723__$1;
(statearr_39815_39921[(2)] = inst_39597);

(statearr_39815_39921[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (38))){
var inst_39647 = (state_39723[(2)]);
var state_39723__$1 = (function (){var statearr_39816 = state_39723;
(statearr_39816[(17)] = inst_39647);

return statearr_39816;
})();
if(cljs.core.truth_(orderBy)){
var statearr_39817_39922 = state_39723__$1;
(statearr_39817_39922[(1)] = (39));

} else {
var statearr_39818_39923 = state_39723__$1;
(statearr_39818_39923[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (30))){
var inst_39635 = (state_39723[(23)]);
var state_39723__$1 = state_39723;
var statearr_39819_39924 = state_39723__$1;
(statearr_39819_39924[(2)] = inst_39635);

(statearr_39819_39924[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (73))){
var inst_39701 = (state_39723[(10)]);
var inst_39709 = cljs.core.PersistentVector.EMPTY;
var inst_39710 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39709,inst_39701);
var state_39723__$1 = state_39723;
var statearr_39820_39925 = state_39723__$1;
(statearr_39820_39925[(2)] = inst_39710);

(statearr_39820_39925[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (10))){
var state_39723__$1 = state_39723;
if(cljs.core.truth_(aggregates)){
var statearr_39821_39926 = state_39723__$1;
(statearr_39821_39926[(1)] = (18));

} else {
var statearr_39822_39927 = state_39723__$1;
(statearr_39822_39927[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (18))){
var inst_39608 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_39723__$1 = state_39723;
var statearr_39823_39928 = state_39723__$1;
(statearr_39823_39928[(2)] = inst_39608);

(statearr_39823_39928[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (52))){
var state_39723__$1 = state_39723;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_39824_39929 = state_39723__$1;
(statearr_39824_39929[(1)] = (55));

} else {
var statearr_39825_39930 = state_39723__$1;
(statearr_39825_39930[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (67))){
var inst_39690 = (state_39723[(24)]);
var inst_39698 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(group_limit,inst_39690);
var state_39723__$1 = state_39723;
var statearr_39826_39931 = state_39723__$1;
(statearr_39826_39931[(2)] = inst_39698);

(statearr_39826_39931[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (71))){
var inst_39657 = (state_39723[(14)]);
var inst_39705 = cljs.core.vector_QMARK_(inst_39657);
var state_39723__$1 = state_39723;
var statearr_39827_39932 = state_39723__$1;
(statearr_39827_39932[(2)] = inst_39705);

(statearr_39827_39932[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (42))){
var inst_39658 = (state_39723[(22)]);
var inst_39656 = (state_39723[(2)]);
var inst_39657 = fluree.db.util.async.throw_err(inst_39656);
var inst_39658__$1 = selectDistinct_QMARK_;
var state_39723__$1 = (function (){var statearr_39828 = state_39723;
(statearr_39828[(14)] = inst_39657);

(statearr_39828[(22)] = inst_39658__$1);

return statearr_39828;
})();
if(cljs.core.truth_(inst_39658__$1)){
var statearr_39829_39933 = state_39723__$1;
(statearr_39829_39933[(1)] = (43));

} else {
var statearr_39830_39934 = state_39723__$1;
(statearr_39830_39934[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (37))){
var state_39723__$1 = state_39723;
var statearr_39831_39935 = state_39723__$1;
(statearr_39831_39935[(2)] = group_limit);

(statearr_39831_39935[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (63))){
var inst_39691 = (state_39723[(7)]);
var inst_39690 = (state_39723[(2)]);
var inst_39691__$1 = group_limit;
var state_39723__$1 = (function (){var statearr_39832 = state_39723;
(statearr_39832[(7)] = inst_39691__$1);

(statearr_39832[(24)] = inst_39690);

return statearr_39832;
})();
if(cljs.core.truth_(inst_39691__$1)){
var statearr_39833_39936 = state_39723__$1;
(statearr_39833_39936[(1)] = (64));

} else {
var statearr_39834_39937 = state_39723__$1;
(statearr_39834_39937[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (8))){
var inst_39582 = (state_39723[(2)]);
var state_39723__$1 = state_39723;
if(cljs.core.truth_(inst_39582)){
var statearr_39835_39938 = state_39723__$1;
(statearr_39835_39938[(1)] = (9));

} else {
var statearr_39836_39939 = state_39723__$1;
(statearr_39836_39939[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39724 === (49))){
var inst_39663 = (state_39723[(19)]);
var state_39723__$1 = state_39723;
var statearr_39837_39940 = state_39723__$1;
(statearr_39837_39940[(2)] = inst_39663);

(statearr_39837_39940[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16301__auto__ = null;
var fluree$db$query$fql$state_machine__16301__auto____0 = (function (){
var statearr_39838 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39838[(0)] = fluree$db$query$fql$state_machine__16301__auto__);

(statearr_39838[(1)] = (1));

return statearr_39838;
});
var fluree$db$query$fql$state_machine__16301__auto____1 = (function (state_39723){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_39723);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e39839){var ex__16304__auto__ = e39839;
var statearr_39840_39941 = state_39723;
(statearr_39840_39941[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_39723[(4)]))){
var statearr_39841_39942 = state_39723;
(statearr_39841_39942[(1)] = cljs.core.first((state_39723[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__39943 = state_39723;
state_39723 = G__39943;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16301__auto__ = function(state_39723){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16301__auto____1.call(this,state_39723);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16301__auto____0;
fluree$db$query$fql$state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16301__auto____1;
return fluree$db$query$fql$state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_39842 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_39842[(6)] = c__16375__auto__);

return statearr_39842;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 5);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__39946,groupBy){
var map__39947 = p__39946;
var map__39947__$1 = (((((!((map__39947 == null))))?(((((map__39947.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39947.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39947):map__39947);
var res = map__39947__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39947__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39947__$1,cljs.core.cst$kw$tuples);
var vec__39949 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39949,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39949,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39944_SHARP_){
return fluree.db.util.core.index_of(headers,p1__39944_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__39945_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__39945_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__39952 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39952,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39952,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,p__39955,p__39956,opts){
var map__39957 = p__39955;
var map__39957__$1 = (((((!((map__39957 == null))))?(((((map__39957.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39957.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39957):map__39957);
var res = map__39957__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39957__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39957__$1,cljs.core.cst$kw$vars);
var map__39958 = p__39956;
var map__39958__$1 = (((((!((map__39958 == null))))?(((((map__39958.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__39958.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39958):map__39958);
var select_spec = map__39958__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39958__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39958__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39958__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39958__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39958__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39958__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39958__$1,cljs.core.cst$kw$offset);
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_40180){
var state_val_40181 = (state_40180[(1)]);
if((state_val_40181 === (65))){
var inst_40030 = (state_40180[(7)]);
var inst_40091 = (state_40180[(8)]);
var inst_40039 = (state_40180[(9)]);
var inst_40121 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40030,inst_40039,inst_40091);
var state_40180__$1 = state_40180;
var statearr_40182_40315 = state_40180__$1;
(statearr_40182_40315[(2)] = inst_40121);

(statearr_40182_40315[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (70))){
var inst_40146 = (state_40180[(10)]);
var inst_40145 = (state_40180[(2)]);
var inst_40146__$1 = fluree.db.util.async.throw_err(inst_40145);
var inst_40147 = cljs.core.coll_QMARK_(inst_40146__$1);
var inst_40148 = (!(inst_40147));
var state_40180__$1 = (function (){var statearr_40183 = state_40180;
(statearr_40183[(10)] = inst_40146__$1);

return statearr_40183;
})();
if(inst_40148){
var statearr_40184_40316 = state_40180__$1;
(statearr_40184_40316[(1)] = (71));

} else {
var statearr_40185_40317 = state_40180__$1;
(statearr_40185_40317[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (62))){
var state_40180__$1 = state_40180;
var statearr_40186_40318 = state_40180__$1;
(statearr_40186_40318[(2)] = null);

(statearr_40186_40318[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (74))){
var inst_40146 = (state_40180[(10)]);
var inst_40151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40152 = [inst_40146];
var inst_40153 = (new cljs.core.PersistentVector(null,1,(5),inst_40151,inst_40152,null));
var state_40180__$1 = state_40180;
var statearr_40187_40319 = state_40180__$1;
(statearr_40187_40319[(2)] = inst_40153);

(statearr_40187_40319[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (7))){
var state_40180__$1 = state_40180;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_40188_40320 = state_40180__$1;
(statearr_40188_40320[(1)] = (67));

} else {
var statearr_40189_40321 = state_40180__$1;
(statearr_40189_40321[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (59))){
var state_40180__$1 = state_40180;
var statearr_40190_40322 = state_40180__$1;
(statearr_40190_40322[(1)] = (61));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (20))){
var state_40180__$1 = state_40180;
var statearr_40192_40323 = state_40180__$1;
(statearr_40192_40323[(2)] = (0));

(statearr_40192_40323[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (72))){
var state_40180__$1 = state_40180;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_40193_40324 = state_40180__$1;
(statearr_40193_40324[(1)] = (77));

} else {
var statearr_40194_40325 = state_40180__$1;
(statearr_40194_40325[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (58))){
var inst_40029 = (state_40180[(11)]);
var inst_40103 = (inst_40029 - (1));
var state_40180__$1 = state_40180;
var statearr_40195_40326 = state_40180__$1;
(statearr_40195_40326[(2)] = inst_40103);

(statearr_40195_40326[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (60))){
var inst_40113 = (state_40180[(2)]);
var state_40180__$1 = state_40180;
var statearr_40196_40327 = state_40180__$1;
(statearr_40196_40327[(2)] = inst_40113);

(statearr_40196_40327[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (27))){
var inst_40028 = (state_40180[(12)]);
var inst_40052 = (inst_40028 < (1));
var state_40180__$1 = state_40180;
var statearr_40197_40328 = state_40180__$1;
(statearr_40197_40328[(2)] = inst_40052);

(statearr_40197_40328[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (1))){
var state_40180__$1 = state_40180;
var statearr_40198_40329 = state_40180__$1;
(statearr_40198_40329[(2)] = null);

(statearr_40198_40329[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (69))){
var inst_40142 = (state_40180[(2)]);
var inst_40143 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,inst_40142,opts);
var state_40180__$1 = state_40180;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40180__$1,(70),inst_40143);
} else {
if((state_val_40181 === (24))){
var inst_40030 = (state_40180[(7)]);
var state_40180__$1 = state_40180;
var statearr_40199_40330 = state_40180__$1;
(statearr_40199_40330[(2)] = inst_40030);

(statearr_40199_40330[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (55))){
var state_40180__$1 = state_40180;
var statearr_40200_40331 = state_40180__$1;
(statearr_40200_40331[(2)] = (0));

(statearr_40200_40331[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (85))){
var inst_40167 = (state_40180[(2)]);
var state_40180__$1 = state_40180;
var statearr_40201_40332 = state_40180__$1;
(statearr_40201_40332[(2)] = inst_40167);

(statearr_40201_40332[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (39))){
var inst_40047 = (state_40180[(13)]);
var inst_40070 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,cljs.core.cst$kw$orderBy,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$limit,null], 0));
var inst_40071 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$offset,(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$limit,null], 0));
var inst_40072 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4(db,inst_40047,inst_40070,inst_40071);
var state_40180__$1 = state_40180;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40180__$1,(42),inst_40072);
} else {
if((state_val_40181 === (46))){
var inst_40028 = (state_40180[(12)]);
var inst_40083 = ((0) < inst_40028);
var state_40180__$1 = state_40180;
var statearr_40202_40333 = state_40180__$1;
(statearr_40202_40333[(2)] = inst_40083);

(statearr_40202_40333[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (4))){
var inst_39961 = (state_40180[(2)]);
var state_40180__$1 = state_40180;
var statearr_40203_40334 = state_40180__$1;
(statearr_40203_40334[(2)] = inst_39961);

(statearr_40203_40334[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (77))){
var inst_40146 = (state_40180[(10)]);
var inst_40159 = cljs.core.first(inst_40146);
var state_40180__$1 = state_40180;
var statearr_40204_40335 = state_40180__$1;
(statearr_40204_40335[(2)] = inst_40159);

(statearr_40204_40335[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (54))){
var inst_40029 = (state_40180[(11)]);
var inst_40098 = (state_40180[(2)]);
var inst_40099 = (inst_40029 <= (0));
var state_40180__$1 = (function (){var statearr_40205 = state_40180;
(statearr_40205[(14)] = inst_40098);

return statearr_40205;
})();
if(cljs.core.truth_(inst_40099)){
var statearr_40206_40336 = state_40180__$1;
(statearr_40206_40336[(1)] = (55));

} else {
var statearr_40207_40337 = state_40180__$1;
(statearr_40207_40337[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (15))){
var inst_39979 = (state_40180[(15)]);
var inst_39987 = (state_40180[(2)]);
var inst_39988 = fluree.db.util.async.throw_err(inst_39987);
var inst_39989 = [inst_39979];
var inst_39990 = [inst_39988];
var inst_39991 = cljs.core.PersistentHashMap.fromArrays(inst_39989,inst_39990);
var state_40180__$1 = state_40180;
var statearr_40208_40338 = state_40180__$1;
(statearr_40208_40338[(2)] = inst_39991);

(statearr_40208_40338[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (48))){
var inst_40086 = (state_40180[(2)]);
var state_40180__$1 = state_40180;
if(cljs.core.truth_(inst_40086)){
var statearr_40209_40339 = state_40180__$1;
(statearr_40209_40339[(1)] = (49));

} else {
var statearr_40210_40340 = state_40180__$1;
(statearr_40210_40340[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (50))){
var inst_40081 = (state_40180[(16)]);
var state_40180__$1 = state_40180;
var statearr_40211_40341 = state_40180__$1;
(statearr_40211_40341[(2)] = inst_40081);

(statearr_40211_40341[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (75))){
var inst_40146 = (state_40180[(10)]);
var state_40180__$1 = state_40180;
var statearr_40212_40342 = state_40180__$1;
(statearr_40212_40342[(2)] = inst_40146);

(statearr_40212_40342[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (21))){
var inst_40007 = (state_40180[(17)]);
var inst_40011 = (state_40180[(18)]);
var inst_40019 = (state_40180[(19)]);
var inst_40024 = (state_40180[(2)]);
var inst_40025 = cljs.core.PersistentHashMap.EMPTY;
var inst_40026 = inst_40007;
var inst_40027 = inst_40011;
var inst_40028 = inst_40019;
var inst_40029 = inst_40024;
var inst_40030 = inst_40025;
var state_40180__$1 = (function (){var statearr_40213 = state_40180;
(statearr_40213[(20)] = inst_40027);

(statearr_40213[(7)] = inst_40030);

(statearr_40213[(21)] = inst_40026);

(statearr_40213[(11)] = inst_40029);

(statearr_40213[(12)] = inst_40028);

return statearr_40213;
})();
var statearr_40214_40343 = state_40180__$1;
(statearr_40214_40343[(2)] = null);

(statearr_40214_40343[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (31))){
var inst_40029 = (state_40180[(11)]);
var inst_40044 = (state_40180[(22)]);
var inst_40058 = (inst_40029 >= inst_40044);
var state_40180__$1 = state_40180;
if(cljs.core.truth_(inst_40058)){
var statearr_40215_40344 = state_40180__$1;
(statearr_40215_40344[(1)] = (33));

} else {
var statearr_40216_40345 = state_40180__$1;
(statearr_40216_40345[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (32))){
var inst_40131 = (state_40180[(2)]);
var state_40180__$1 = state_40180;
var statearr_40217_40346 = state_40180__$1;
(statearr_40217_40346[(2)] = inst_40131);

(statearr_40217_40346[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (40))){
var state_40180__$1 = state_40180;
var statearr_40218_40347 = state_40180__$1;
(statearr_40218_40347[(2)] = null);

(statearr_40218_40347[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (56))){
var state_40180__$1 = state_40180;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_40219_40348 = state_40180__$1;
(statearr_40219_40348[(1)] = (58));

} else {
var statearr_40220_40349 = state_40180__$1;
(statearr_40220_40349[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (33))){
var state_40180__$1 = state_40180;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_40221_40350 = state_40180__$1;
(statearr_40221_40350[(1)] = (36));

} else {
var statearr_40222_40351 = state_40180__$1;
(statearr_40222_40351[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (13))){
var inst_40007 = (state_40180[(17)]);
var inst_39976 = (state_40180[(23)]);
var inst_40011 = (state_40180[(18)]);
var inst_40007__$1 = cljs.core.keys(inst_39976);
var inst_40008 = cljs.core.seq(inst_40007__$1);
var inst_40009 = cljs.core.first(inst_40008);
var inst_40010 = cljs.core.next(inst_40008);
var inst_40011__$1 = cljs.core.vals(inst_39976);
var inst_40012 = cljs.core.seq(inst_40011__$1);
var inst_40013 = cljs.core.first(inst_40012);
var inst_40014 = cljs.core.next(inst_40012);
var inst_40015 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_40180__$1 = (function (){var statearr_40223 = state_40180;
(statearr_40223[(24)] = inst_40010);

(statearr_40223[(25)] = inst_40009);

(statearr_40223[(17)] = inst_40007__$1);

(statearr_40223[(26)] = inst_40014);

(statearr_40223[(18)] = inst_40011__$1);

(statearr_40223[(27)] = inst_40013);

return statearr_40223;
})();
if(inst_40015){
var statearr_40224_40352 = state_40180__$1;
(statearr_40224_40352[(1)] = (16));

} else {
var statearr_40225_40353 = state_40180__$1;
(statearr_40225_40353[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (22))){
var inst_40027 = (state_40180[(20)]);
var inst_40026 = (state_40180[(21)]);
var inst_40038 = cljs.core.seq(inst_40026);
var inst_40039 = cljs.core.first(inst_40038);
var inst_40040 = cljs.core.next(inst_40038);
var inst_40041 = cljs.core.seq(inst_40027);
var inst_40042 = cljs.core.first(inst_40041);
var inst_40043 = cljs.core.next(inst_40041);
var inst_40044 = cljs.core.count(inst_40042);
var inst_40045 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_40046 = [headers,vars,inst_40042];
var inst_40047 = cljs.core.PersistentHashMap.fromArrays(inst_40045,inst_40046);
var inst_40048 = (inst_40042 == null);
var state_40180__$1 = (function (){var statearr_40226 = state_40180;
(statearr_40226[(9)] = inst_40039);

(statearr_40226[(22)] = inst_40044);

(statearr_40226[(28)] = inst_40040);

(statearr_40226[(13)] = inst_40047);

(statearr_40226[(29)] = inst_40043);

return statearr_40226;
})();
if(cljs.core.truth_(inst_40048)){
var statearr_40227_40354 = state_40180__$1;
(statearr_40227_40354[(1)] = (24));

} else {
var statearr_40228_40355 = state_40180__$1;
(statearr_40228_40355[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (36))){
var inst_40029 = (state_40180[(11)]);
var inst_40061 = (inst_40029 - (1));
var state_40180__$1 = state_40180;
var statearr_40229_40356 = state_40180__$1;
(statearr_40229_40356[(2)] = inst_40061);

(statearr_40229_40356[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (41))){
var inst_40127 = (state_40180[(2)]);
var state_40180__$1 = state_40180;
var statearr_40230_40357 = state_40180__$1;
(statearr_40230_40357[(2)] = inst_40127);

(statearr_40230_40357[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (43))){
var inst_40075 = (state_40180[(30)]);
var inst_40029 = (state_40180[(11)]);
var inst_40078 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_40029,inst_40075);
var state_40180__$1 = state_40180;
var statearr_40231_40358 = state_40180__$1;
(statearr_40231_40358[(2)] = inst_40078);

(statearr_40231_40358[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (61))){
var inst_40091 = (state_40180[(8)]);
var inst_40029 = (state_40180[(11)]);
var inst_40044 = (state_40180[(22)]);
var inst_40106 = cljs.core.count(inst_40091);
var inst_40107 = (inst_40044 - inst_40106);
var inst_40108 = (inst_40029 - inst_40107);
var state_40180__$1 = state_40180;
var statearr_40232_40359 = state_40180__$1;
(statearr_40232_40359[(2)] = inst_40108);

(statearr_40232_40359[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (29))){
var inst_40055 = (state_40180[(2)]);
var state_40180__$1 = state_40180;
if(cljs.core.truth_(inst_40055)){
var statearr_40233_40360 = state_40180__$1;
(statearr_40233_40360[(1)] = (30));

} else {
var statearr_40234_40361 = state_40180__$1;
(statearr_40234_40361[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (44))){
var inst_40075 = (state_40180[(30)]);
var state_40180__$1 = state_40180;
var statearr_40235_40362 = state_40180__$1;
(statearr_40235_40362[(2)] = inst_40075);

(statearr_40235_40362[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (6))){
var inst_39968 = (state_40180[(31)]);
var inst_39968__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_39970 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_40180__$1 = (function (){var statearr_40236 = state_40180;
(statearr_40236[(31)] = inst_39968__$1);

(statearr_40236[(32)] = inst_39970);

return statearr_40236;
})();
if(cljs.core.truth_(inst_39968__$1)){
var statearr_40237_40363 = state_40180__$1;
(statearr_40237_40363[(1)] = (9));

} else {
var statearr_40238_40364 = state_40180__$1;
(statearr_40238_40364[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (28))){
var inst_40028 = (state_40180[(12)]);
var state_40180__$1 = state_40180;
var statearr_40239_40365 = state_40180__$1;
(statearr_40239_40365[(2)] = inst_40028);

(statearr_40239_40365[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (64))){
var inst_40030 = (state_40180[(7)]);
var state_40180__$1 = state_40180;
var statearr_40240_40366 = state_40180__$1;
(statearr_40240_40366[(2)] = inst_40030);

(statearr_40240_40366[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (51))){
var inst_40028 = (state_40180[(12)]);
var inst_40091 = (state_40180[(2)]);
var inst_40092 = (inst_40028 == null);
var state_40180__$1 = (function (){var statearr_40241 = state_40180;
(statearr_40241[(8)] = inst_40091);

return statearr_40241;
})();
if(cljs.core.truth_(inst_40092)){
var statearr_40242_40367 = state_40180__$1;
(statearr_40242_40367[(1)] = (52));

} else {
var statearr_40243_40368 = state_40180__$1;
(statearr_40243_40368[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (25))){
var inst_40028 = (state_40180[(12)]);
var state_40180__$1 = state_40180;
if(cljs.core.truth_(inst_40028)){
var statearr_40244_40369 = state_40180__$1;
(statearr_40244_40369[(1)] = (27));

} else {
var statearr_40245_40370 = state_40180__$1;
(statearr_40245_40370[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (34))){
var state_40180__$1 = state_40180;
var statearr_40246_40371 = state_40180__$1;
(statearr_40246_40371[(1)] = (39));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (17))){
var state_40180__$1 = state_40180;
var statearr_40248_40372 = state_40180__$1;
(statearr_40248_40372[(2)] = limit);

(statearr_40248_40372[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (3))){
var inst_40178 = (state_40180[(2)]);
var state_40180__$1 = state_40180;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40180__$1,inst_40178);
} else {
if((state_val_40181 === (12))){
var inst_39976 = (state_40180[(23)]);
var inst_39978 = cljs.core.keys(inst_39976);
var inst_39979 = cljs.core.first(inst_39978);
var inst_39980 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_39981 = cljs.core.vals(inst_39976);
var inst_39982 = cljs.core.first(inst_39981);
var inst_39983 = [headers,vars,inst_39982];
var inst_39984 = cljs.core.PersistentHashMap.fromArrays(inst_39980,inst_39983);
var inst_39985 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,inst_39984,select_spec,limit,opts);
var state_40180__$1 = (function (){var statearr_40249 = state_40180;
(statearr_40249[(15)] = inst_39979);

return statearr_40249;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40180__$1,(15),inst_39985);
} else {
if((state_val_40181 === (2))){
var _ = (function (){var statearr_40250 = state_40180;
(statearr_40250[(4)] = cljs.core.cons((5),(state_40180[(4)])));

return statearr_40250;
})();
var state_40180__$1 = state_40180;
if(cljs.core.truth_(groupBy)){
var statearr_40251_40373 = state_40180__$1;
(statearr_40251_40373[(1)] = (6));

} else {
var statearr_40252_40374 = state_40180__$1;
(statearr_40252_40374[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (66))){
var inst_40098 = (state_40180[(14)]);
var inst_40115 = (state_40180[(33)]);
var inst_40040 = (state_40180[(28)]);
var inst_40043 = (state_40180[(29)]);
var inst_40123 = (state_40180[(2)]);
var inst_40026 = inst_40040;
var inst_40027 = inst_40043;
var inst_40028 = inst_40098;
var inst_40029 = inst_40115;
var inst_40030 = inst_40123;
var state_40180__$1 = (function (){var statearr_40253 = state_40180;
(statearr_40253[(20)] = inst_40027);

(statearr_40253[(7)] = inst_40030);

(statearr_40253[(21)] = inst_40026);

(statearr_40253[(11)] = inst_40029);

(statearr_40253[(12)] = inst_40028);

return statearr_40253;
})();
var statearr_40254_40375 = state_40180__$1;
(statearr_40254_40375[(2)] = null);

(statearr_40254_40375[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (23))){
var inst_40135 = (state_40180[(2)]);
var state_40180__$1 = state_40180;
var statearr_40255_40376 = state_40180__$1;
(statearr_40255_40376[(2)] = inst_40135);

(statearr_40255_40376[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (47))){
var inst_40028 = (state_40180[(12)]);
var state_40180__$1 = state_40180;
var statearr_40256_40377 = state_40180__$1;
(statearr_40256_40377[(2)] = inst_40028);

(statearr_40256_40377[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (35))){
var inst_40129 = (state_40180[(2)]);
var state_40180__$1 = state_40180;
var statearr_40257_40378 = state_40180__$1;
(statearr_40257_40378[(2)] = inst_40129);

(statearr_40257_40378[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (82))){
var inst_40169 = (state_40180[(2)]);
var state_40180__$1 = state_40180;
var statearr_40258_40379 = state_40180__$1;
(statearr_40258_40379[(2)] = inst_40169);

(statearr_40258_40379[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (76))){
var inst_40156 = (state_40180[(2)]);
var state_40180__$1 = state_40180;
var statearr_40259_40380 = state_40180__$1;
(statearr_40259_40380[(2)] = inst_40156);

(statearr_40259_40380[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (19))){
var inst_40020 = (state_40180[(34)]);
var state_40180__$1 = state_40180;
var statearr_40260_40381 = state_40180__$1;
(statearr_40260_40381[(2)] = inst_40020);

(statearr_40260_40381[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (57))){
var inst_40091 = (state_40180[(8)]);
var inst_40115 = (state_40180[(2)]);
var inst_40116 = (inst_40091 == null);
var inst_40117 = cljs.core.empty_QMARK_(inst_40091);
var inst_40118 = ((inst_40116) || (inst_40117));
var state_40180__$1 = (function (){var statearr_40261 = state_40180;
(statearr_40261[(33)] = inst_40115);

return statearr_40261;
})();
if(cljs.core.truth_(inst_40118)){
var statearr_40262_40382 = state_40180__$1;
(statearr_40262_40382[(1)] = (64));

} else {
var statearr_40263_40383 = state_40180__$1;
(statearr_40263_40383[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (68))){
var state_40180__$1 = state_40180;
var statearr_40264_40384 = state_40180__$1;
(statearr_40264_40384[(2)] = limit);

(statearr_40264_40384[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (11))){
var inst_39976 = (state_40180[(2)]);
var state_40180__$1 = (function (){var statearr_40266 = state_40180;
(statearr_40266[(23)] = inst_39976);

return statearr_40266;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_40267_40385 = state_40180__$1;
(statearr_40267_40385[(1)] = (12));

} else {
var statearr_40268_40386 = state_40180__$1;
(statearr_40268_40386[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (9))){
var inst_39968 = (state_40180[(31)]);
var inst_39970 = (state_40180[(32)]);
var inst_39972 = cljs.core.sorted_map_by(inst_39968);
var inst_39973 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39972,inst_39970);
var state_40180__$1 = state_40180;
var statearr_40269_40387 = state_40180__$1;
(statearr_40269_40387[(2)] = inst_39973);

(statearr_40269_40387[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (5))){
var _ = (function (){var statearr_40270 = state_40180;
(statearr_40270[(4)] = cljs.core.rest((state_40180[(4)])));

return statearr_40270;
})();
var state_40180__$1 = state_40180;
var ex40265 = (state_40180__$1[(2)]);
var statearr_40271_40388 = state_40180__$1;
(statearr_40271_40388[(5)] = ex40265);


if((ex40265 instanceof Error)){
var statearr_40272_40389 = state_40180__$1;
(statearr_40272_40389[(1)] = (4));

(statearr_40272_40389[(5)] = null);

} else {
throw ex40265;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (83))){
var inst_40146 = (state_40180[(10)]);
var state_40180__$1 = state_40180;
var statearr_40273_40390 = state_40180__$1;
(statearr_40273_40390[(2)] = inst_40146);

(statearr_40273_40390[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (14))){
var inst_40137 = (state_40180[(2)]);
var state_40180__$1 = state_40180;
var statearr_40274_40391 = state_40180__$1;
(statearr_40274_40391[(2)] = inst_40137);

(statearr_40274_40391[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (45))){
var inst_40028 = (state_40180[(12)]);
var inst_40081 = (state_40180[(2)]);
var state_40180__$1 = (function (){var statearr_40275 = state_40180;
(statearr_40275[(16)] = inst_40081);

return statearr_40275;
})();
if(cljs.core.truth_(inst_40028)){
var statearr_40276_40392 = state_40180__$1;
(statearr_40276_40392[(1)] = (46));

} else {
var statearr_40277_40393 = state_40180__$1;
(statearr_40277_40393[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (53))){
var inst_40091 = (state_40180[(8)]);
var inst_40028 = (state_40180[(12)]);
var inst_40095 = cljs.core.count(inst_40091);
var inst_40096 = (inst_40028 - inst_40095);
var state_40180__$1 = state_40180;
var statearr_40278_40394 = state_40180__$1;
(statearr_40278_40394[(2)] = inst_40096);

(statearr_40278_40394[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (78))){
var state_40180__$1 = state_40180;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_40279_40395 = state_40180__$1;
(statearr_40279_40395[(1)] = (80));

} else {
var statearr_40280_40396 = state_40180__$1;
(statearr_40280_40396[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (26))){
var inst_40133 = (state_40180[(2)]);
var state_40180__$1 = state_40180;
var statearr_40281_40397 = state_40180__$1;
(statearr_40281_40397[(2)] = inst_40133);

(statearr_40281_40397[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (16))){
var state_40180__$1 = state_40180;
var statearr_40282_40398 = state_40180__$1;
(statearr_40282_40398[(2)] = null);

(statearr_40282_40398[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (81))){
var state_40180__$1 = state_40180;
var statearr_40285_40399 = state_40180__$1;
(statearr_40285_40399[(1)] = (83));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (79))){
var inst_40171 = (state_40180[(2)]);
var state_40180__$1 = state_40180;
var statearr_40287_40400 = state_40180__$1;
(statearr_40287_40400[(2)] = inst_40171);

(statearr_40287_40400[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (38))){
var inst_40030 = (state_40180[(7)]);
var inst_40040 = (state_40180[(28)]);
var inst_40043 = (state_40180[(29)]);
var inst_40028 = (state_40180[(12)]);
var inst_40065 = (state_40180[(2)]);
var tmp40283 = inst_40030;
var tmp40284 = inst_40028;
var inst_40026 = inst_40040;
var inst_40027 = inst_40043;
var inst_40028__$1 = tmp40284;
var inst_40029 = inst_40065;
var inst_40030__$1 = tmp40283;
var state_40180__$1 = (function (){var statearr_40288 = state_40180;
(statearr_40288[(20)] = inst_40027);

(statearr_40288[(7)] = inst_40030__$1);

(statearr_40288[(21)] = inst_40026);

(statearr_40288[(11)] = inst_40029);

(statearr_40288[(12)] = inst_40028__$1);

return statearr_40288;
})();
var statearr_40289_40401 = state_40180__$1;
(statearr_40289_40401[(2)] = null);

(statearr_40289_40401[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (30))){
var inst_40030 = (state_40180[(7)]);
var state_40180__$1 = state_40180;
var statearr_40290_40402 = state_40180__$1;
(statearr_40290_40402[(2)] = inst_40030);

(statearr_40290_40402[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (73))){
var inst_40173 = (state_40180[(2)]);
var state_40180__$1 = state_40180;
var statearr_40291_40403 = state_40180__$1;
(statearr_40291_40403[(2)] = inst_40173);

(statearr_40291_40403[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (10))){
var inst_39970 = (state_40180[(32)]);
var state_40180__$1 = state_40180;
var statearr_40292_40404 = state_40180__$1;
(statearr_40292_40404[(2)] = inst_39970);

(statearr_40292_40404[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (18))){
var inst_40020 = (state_40180[(34)]);
var inst_40019 = (state_40180[(2)]);
var inst_40020__$1 = offset;
var state_40180__$1 = (function (){var statearr_40293 = state_40180;
(statearr_40293[(34)] = inst_40020__$1);

(statearr_40293[(19)] = inst_40019);

return statearr_40293;
})();
if(cljs.core.truth_(inst_40020__$1)){
var statearr_40294_40405 = state_40180__$1;
(statearr_40294_40405[(1)] = (19));

} else {
var statearr_40295_40406 = state_40180__$1;
(statearr_40295_40406[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (52))){
var state_40180__$1 = state_40180;
var statearr_40296_40407 = state_40180__$1;
(statearr_40296_40407[(2)] = null);

(statearr_40296_40407[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (67))){
var state_40180__$1 = state_40180;
var statearr_40297_40408 = state_40180__$1;
(statearr_40297_40408[(2)] = (1));

(statearr_40297_40408[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (71))){
var state_40180__$1 = state_40180;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_40298_40409 = state_40180__$1;
(statearr_40298_40409[(1)] = (74));

} else {
var statearr_40299_40410 = state_40180__$1;
(statearr_40299_40410[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (42))){
var inst_40029 = (state_40180[(11)]);
var inst_40074 = (state_40180[(2)]);
var inst_40075 = fluree.db.util.async.throw_err(inst_40074);
var inst_40076 = ((0) < inst_40029);
var state_40180__$1 = (function (){var statearr_40300 = state_40180;
(statearr_40300[(30)] = inst_40075);

return statearr_40300;
})();
if(cljs.core.truth_(inst_40076)){
var statearr_40301_40411 = state_40180__$1;
(statearr_40301_40411[(1)] = (43));

} else {
var statearr_40302_40412 = state_40180__$1;
(statearr_40302_40412[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (80))){
var inst_40146 = (state_40180[(10)]);
var inst_40162 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_40146);
var state_40180__$1 = state_40180;
var statearr_40303_40413 = state_40180__$1;
(statearr_40303_40413[(2)] = inst_40162);

(statearr_40303_40413[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (37))){
var inst_40029 = (state_40180[(11)]);
var inst_40044 = (state_40180[(22)]);
var inst_40063 = (inst_40029 - inst_40044);
var state_40180__$1 = state_40180;
var statearr_40304_40414 = state_40180__$1;
(statearr_40304_40414[(2)] = inst_40063);

(statearr_40304_40414[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (63))){
var inst_40111 = (state_40180[(2)]);
var state_40180__$1 = state_40180;
var statearr_40305_40415 = state_40180__$1;
(statearr_40305_40415[(2)] = inst_40111);

(statearr_40305_40415[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (8))){
var inst_40175 = (state_40180[(2)]);
var _ = (function (){var statearr_40306 = state_40180;
(statearr_40306[(4)] = cljs.core.rest((state_40180[(4)])));

return statearr_40306;
})();
var state_40180__$1 = state_40180;
var statearr_40307_40416 = state_40180__$1;
(statearr_40307_40416[(2)] = inst_40175);

(statearr_40307_40416[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (49))){
var inst_40081 = (state_40180[(16)]);
var inst_40028 = (state_40180[(12)]);
var inst_40088 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_40028,inst_40081);
var state_40180__$1 = state_40180;
var statearr_40308_40417 = state_40180__$1;
(statearr_40308_40417[(2)] = inst_40088);

(statearr_40308_40417[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40181 === (84))){
var state_40180__$1 = state_40180;
var statearr_40309_40418 = state_40180__$1;
(statearr_40309_40418[(2)] = null);

(statearr_40309_40418[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto____0 = (function (){
var statearr_40310 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40310[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto__);

(statearr_40310[(1)] = (1));

return statearr_40310;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto____1 = (function (state_40180){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_40180);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e40311){var ex__16304__auto__ = e40311;
var statearr_40312_40419 = state_40180;
(statearr_40312_40419[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_40180[(4)]))){
var statearr_40313_40420 = state_40180;
(statearr_40313_40420[(1)] = cljs.core.first((state_40180[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__40421 = state_40180;
state_40180 = G__40421;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto__ = function(state_40180){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto____1.call(this,state_40180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_40314 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_40314[(6)] = c__16375__auto__);

return statearr_40314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__40424,opts){
var map__40425 = p__40424;
var map__40425__$1 = (((((!((map__40425 == null))))?(((((map__40425.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40425.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40425):map__40425);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40425__$1,cljs.core.cst$kw$selectOne);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40425__$1,cljs.core.cst$kw$select);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40425__$1,cljs.core.cst$kw$selectDistinct);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40425__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__4126__auto__ = selectOne;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = select;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
var or__4126__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4126__auto____$2)){
return or__4126__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__40422_SHARP_){
return cljs.core.contains_QMARK_(p1__40422_SHARP_,cljs.core.cst$kw$code);
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__40423_SHARP_){
return cljs.core.contains_QMARK_(p1__40423_SHARP_,cljs.core.cst$kw$selection);
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5735__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5735__auto__)){
var orderBy = temp__5735__auto__;
if(cljs.core.truth_((function (){var or__4126__auto__ = typeof orderBy === 'string';
if(or__4126__auto__){
return or__4126__auto__;
} else {
if(cljs.core.vector_QMARK_(orderBy)){
var G__40434 = cljs.core.first(orderBy);
var fexpr__40433 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__40433.cljs$core$IFn$_invoke$arity$1 ? fexpr__40433.cljs$core$IFn$_invoke$arity$1(G__40434) : fexpr__40433.call(null,G__40434));
} else {
return false;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__4126__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})(),(function (){var or__4126__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4126__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4126__auto__ = selectDistinct;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__40435,p__40436){
var map__40437 = p__40435;
var map__40437__$1 = (((((!((map__40437 == null))))?(((((map__40437.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40437.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40437):map__40437);
var query_map = map__40437__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40437__$1,cljs.core.cst$kw$construct);
var map__40438 = p__40436;
var map__40438__$1 = (((((!((map__40438 == null))))?(((((map__40438.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40438.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40438):map__40438);
var where_result = map__40438__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40438__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40438__$1,cljs.core.cst$kw$tuples);
var vec__40441 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5733__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5733__auto__)){
var index_of = temp__5733__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40441,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40441,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40441,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_40474){
var state_val_40475 = (state_40474[(1)]);
if((state_val_40475 === (7))){
var inst_40453 = (state_40474[(7)]);
var state_40474__$1 = state_40474;
var statearr_40476_40499 = state_40474__$1;
(statearr_40476_40499[(2)] = inst_40453);

(statearr_40476_40499[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40475 === (1))){
var state_40474__$1 = state_40474;
var statearr_40477_40500 = state_40474__$1;
(statearr_40477_40500[(2)] = null);

(statearr_40477_40500[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40475 === (4))){
var inst_40444 = (state_40474[(2)]);
var state_40474__$1 = state_40474;
var statearr_40478_40501 = state_40474__$1;
(statearr_40478_40501[(2)] = inst_40444);

(statearr_40478_40501[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40475 === (13))){
var inst_40463 = (state_40474[(2)]);
var inst_40464 = fluree.db.util.async.throw_err(inst_40463);
var state_40474__$1 = state_40474;
var statearr_40479_40502 = state_40474__$1;
(statearr_40479_40502[(2)] = inst_40464);

(statearr_40479_40502[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40475 === (6))){
var inst_40453 = (state_40474[(7)]);
var inst_40452 = (state_40474[(2)]);
var inst_40453__$1 = fluree.db.util.async.throw_err(inst_40452);
var inst_40454 = fluree.db.util.core.exception_QMARK_(inst_40453__$1);
var state_40474__$1 = (function (){var statearr_40480 = state_40474;
(statearr_40480[(7)] = inst_40453__$1);

return statearr_40480;
})();
if(inst_40454){
var statearr_40481_40503 = state_40474__$1;
(statearr_40481_40503[(1)] = (7));

} else {
var statearr_40482_40504 = state_40474__$1;
(statearr_40482_40504[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40475 === (3))){
var inst_40472 = (state_40474[(2)]);
var state_40474__$1 = state_40474;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40474__$1,inst_40472);
} else {
if((state_val_40475 === (12))){
var inst_40467 = (state_40474[(2)]);
var state_40474__$1 = state_40474;
var statearr_40483_40505 = state_40474__$1;
(statearr_40483_40505[(2)] = inst_40467);

(statearr_40483_40505[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40475 === (2))){
var _ = (function (){var statearr_40484 = state_40474;
(statearr_40484[(4)] = cljs.core.cons((5),(state_40474[(4)])));

return statearr_40484;
})();
var inst_40450 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_40474__$1 = state_40474;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40474__$1,(6),inst_40450);
} else {
if((state_val_40475 === (11))){
var state_40474__$1 = state_40474;
var statearr_40486_40506 = state_40474__$1;
(statearr_40486_40506[(2)] = null);

(statearr_40486_40506[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40475 === (9))){
var inst_40469 = (state_40474[(2)]);
var _ = (function (){var statearr_40487 = state_40474;
(statearr_40487[(4)] = cljs.core.rest((state_40474[(4)])));

return statearr_40487;
})();
var state_40474__$1 = state_40474;
var statearr_40488_40507 = state_40474__$1;
(statearr_40488_40507[(2)] = inst_40469);

(statearr_40488_40507[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40475 === (5))){
var _ = (function (){var statearr_40489 = state_40474;
(statearr_40489[(4)] = cljs.core.rest((state_40474[(4)])));

return statearr_40489;
})();
var state_40474__$1 = state_40474;
var ex40485 = (state_40474__$1[(2)]);
var statearr_40490_40508 = state_40474__$1;
(statearr_40490_40508[(5)] = ex40485);


if((ex40485 instanceof Error)){
var statearr_40491_40509 = state_40474__$1;
(statearr_40491_40509[(1)] = (4));

(statearr_40491_40509[(5)] = null);

} else {
throw ex40485;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40475 === (10))){
var inst_40453 = (state_40474[(7)]);
var inst_40458 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_40453);
var inst_40459 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_40453);
var inst_40460 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_40458,inst_40459,query_map,opts);
var inst_40461 = fluree.db.query.fql.process_ad_hoc_res(db,inst_40453,inst_40460,opts);
var state_40474__$1 = state_40474;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40474__$1,(13),inst_40461);
} else {
if((state_val_40475 === (8))){
var state_40474__$1 = state_40474;
var statearr_40492_40510 = state_40474__$1;
(statearr_40492_40510[(1)] = (10));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto____0 = (function (){
var statearr_40494 = [null,null,null,null,null,null,null,null];
(statearr_40494[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto__);

(statearr_40494[(1)] = (1));

return statearr_40494;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto____1 = (function (state_40474){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_40474);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e40495){var ex__16304__auto__ = e40495;
var statearr_40496_40511 = state_40474;
(statearr_40496_40511[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_40474[(4)]))){
var statearr_40497_40512 = state_40474;
(statearr_40497_40512[(1)] = cljs.core.first((state_40474[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__40513 = state_40474;
state_40474 = G__40513;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto__ = function(state_40474){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto____1.call(this,state_40474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_40498 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_40498[(6)] = c__16375__auto__);

return statearr_40498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
});
/**
 * Returns core async channel with results
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__40514 = query_map;
var map__40514__$1 = (((((!((map__40514 == null))))?(((((map__40514.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__40514.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__40514):map__40514);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40514__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40514__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40514__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40514__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40514__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40514__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40514__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40514__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40514__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40514__$1,cljs.core.cst$kw$from);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40514__$1,cljs.core.cst$kw$opts);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40514__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = (function (){var G__40516 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__4126__auto__ = offset;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__40516,cljs.core.cst$kw$limit,(1));
} else {
return G__40516;
}
})();
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4126__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.truth_((function (){var or__4126__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__16375__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16376__auto__ = (function (){var switch__16300__auto__ = (function (state_40887){
var state_val_40888 = (state_40887[(1)]);
if((state_val_40888 === (121))){
var inst_40598 = (state_40887[(7)]);
var inst_40600 = (state_40887[(8)]);
var inst_40828 = (state_40887[(9)]);
var inst_40832 = (state_40887[(10)]);
var inst_40836 = (state_40887[(2)]);
var inst_40837 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_40600,fuel,max_fuel,inst_40598,inst_40828,inst_40832,inst_40836);
var state_40887__$1 = state_40887;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40887__$1,(115),inst_40837);
} else {
if((state_val_40888 === (65))){
var inst_40598 = (state_40887[(7)]);
var inst_40600 = (state_40887[(8)]);
var inst_40588 = (state_40887[(11)]);
var inst_40677 = (state_40887[(12)]);
var inst_40691 = (state_40887[(2)]);
var inst_40692 = fluree.db.util.async.throw_err(inst_40691);
var inst_40693 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_40677,inst_40692);
var inst_40694 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_40600,fuel,max_fuel,inst_40598,inst_40693,inst_40588);
var state_40887__$1 = state_40887;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40887__$1,(66),inst_40694);
} else {
if((state_val_40888 === (70))){
var inst_40587 = (state_40887[(13)]);
var state_40887__$1 = state_40887;
if(cljs.core.truth_(inst_40587)){
var statearr_40889_41081 = state_40887__$1;
(statearr_40889_41081[(1)] = (73));

} else {
var statearr_40890_41082 = state_40887__$1;
(statearr_40890_41082[(1)] = (74));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (62))){
var inst_40679 = cljs.core.PersistentHashMap.EMPTY;
var state_40887__$1 = state_40887;
var statearr_40891_41083 = state_40887__$1;
(statearr_40891_41083[(2)] = inst_40679);

(statearr_40891_41083[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (74))){
var inst_40590 = (state_40887[(14)]);
var inst_40588 = (state_40887[(11)]);
var inst_40713 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_40714 = [inst_40588,inst_40590];
var inst_40715 = cljs.core.PersistentHashMap.fromArrays(inst_40713,inst_40714);
var state_40887__$1 = state_40887;
var statearr_40892_41084 = state_40887__$1;
(statearr_40892_41084[(2)] = inst_40715);

(statearr_40892_41084[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (110))){
var inst_40796 = (state_40887[(15)]);
var inst_40810 = (state_40887[(2)]);
var inst_40811 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_40796,false);
var state_40887__$1 = (function (){var statearr_40893 = state_40887;
(statearr_40893[(16)] = inst_40810);

return statearr_40893;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40887__$1,(111),inst_40811);
} else {
if((state_val_40888 === (130))){
var inst_40877 = (state_40887[(2)]);
var state_40887__$1 = state_40887;
if(cljs.core.truth_(inst_40877)){
var statearr_40894_41085 = state_40887__$1;
(statearr_40894_41085[(1)] = (131));

} else {
var statearr_40895_41086 = state_40887__$1;
(statearr_40895_41086[(1)] = (132));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (128))){
var inst_40868 = (state_40887[(17)]);
var inst_40871 = cljs.core.coll_QMARK_(inst_40868);
var inst_40872 = fluree.db.util.core.exception_QMARK_(inst_40868);
var inst_40873 = (!(inst_40872));
var inst_40874 = ((inst_40871) && (inst_40873));
var state_40887__$1 = state_40887;
var statearr_40896_41087 = state_40887__$1;
(statearr_40896_41087[(2)] = inst_40874);

(statearr_40896_41087[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (7))){
var inst_40548 = (state_40887[(18)]);
var inst_40548__$1 = selectOne;
var state_40887__$1 = (function (){var statearr_40897 = state_40887;
(statearr_40897[(18)] = inst_40548__$1);

return statearr_40897;
})();
if(cljs.core.truth_(inst_40548__$1)){
var statearr_40898_41088 = state_40887__$1;
(statearr_40898_41088[(1)] = (9));

} else {
var statearr_40899_41089 = state_40887__$1;
(statearr_40899_41089[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (59))){
var inst_40671 = (state_40887[(19)]);
var inst_40673 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_40674 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_40671,inst_40673);
var state_40887__$1 = state_40887;
var statearr_40900_41090 = state_40887__$1;
(statearr_40900_41090[(2)] = inst_40674);

(statearr_40900_41090[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (86))){
var inst_40749 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_40887__$1 = state_40887;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40887__$1,(89),inst_40749);
} else {
if((state_val_40888 === (20))){
var inst_40578 = (state_40887[(2)]);
var state_40887__$1 = state_40887;
var statearr_40901_41091 = state_40887__$1;
(statearr_40901_41091[(2)] = inst_40578);

(statearr_40901_41091[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (72))){
var inst_40859 = (state_40887[(2)]);
var state_40887__$1 = state_40887;
var statearr_40902_41092 = state_40887__$1;
(statearr_40902_41092[(2)] = inst_40859);

(statearr_40902_41092[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (58))){
var inst_40671 = (state_40887[(2)]);
var state_40887__$1 = (function (){var statearr_40903 = state_40887;
(statearr_40903[(19)] = inst_40671);

return statearr_40903;
})();
var statearr_40904_41093 = state_40887__$1;
(statearr_40904_41093[(1)] = (59));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (60))){
var inst_40671 = (state_40887[(19)]);
var state_40887__$1 = state_40887;
var statearr_40906_41094 = state_40887__$1;
(statearr_40906_41094[(2)] = inst_40671);

(statearr_40906_41094[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (27))){
var inst_40587 = (state_40887[(13)]);
var inst_40602 = cljs.core.vector_QMARK_(inst_40587);
var state_40887__$1 = state_40887;
if(inst_40602){
var statearr_40907_41095 = state_40887__$1;
(statearr_40907_41095[(1)] = (30));

} else {
var statearr_40908_41096 = state_40887__$1;
(statearr_40908_41096[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (1))){
var state_40887__$1 = state_40887;
var statearr_40909_41097 = state_40887__$1;
(statearr_40909_41097[(2)] = null);

(statearr_40909_41097[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (69))){
var inst_40708 = (state_40887[(2)]);
var state_40887__$1 = state_40887;
if(cljs.core.truth_(inst_40708)){
var statearr_40910_41098 = state_40887__$1;
(statearr_40910_41098[(1)] = (70));

} else {
var statearr_40911_41099 = state_40887__$1;
(statearr_40911_41099[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (101))){
var inst_40587 = (state_40887[(13)]);
var inst_40826 = (state_40887[(2)]);
var inst_40827 = cljs.core.PersistentVector.EMPTY;
var inst_40828 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40827,inst_40826);
var state_40887__$1 = (function (){var statearr_40912 = state_40887;
(statearr_40912[(9)] = inst_40828);

return statearr_40912;
})();
if(cljs.core.truth_(inst_40587)){
var statearr_40913_41100 = state_40887__$1;
(statearr_40913_41100[(1)] = (116));

} else {
var statearr_40914_41101 = state_40887__$1;
(statearr_40914_41101[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (24))){
var inst_40591 = (state_40887[(20)]);
var inst_40589 = (state_40887[(21)]);
var inst_40595 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40591,cljs.core.cst$kw$componentFollow_QMARK_,inst_40589);
var state_40887__$1 = state_40887;
var statearr_40915_41102 = state_40887__$1;
(statearr_40915_41102[(2)] = inst_40595);

(statearr_40915_41102[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (102))){
var inst_40790 = (state_40887[(22)]);
var state_40887__$1 = state_40887;
var statearr_40916_41103 = state_40887__$1;
(statearr_40916_41103[(2)] = inst_40790);

(statearr_40916_41103[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (55))){
var inst_40861 = (state_40887[(2)]);
var state_40887__$1 = state_40887;
var statearr_40917_41104 = state_40887__$1;
(statearr_40917_41104[(2)] = inst_40861);

(statearr_40917_41104[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (85))){
var inst_40743 = (state_40887[(2)]);
var inst_40744 = fluree.db.util.async.throw_err(inst_40743);
var state_40887__$1 = state_40887;
var statearr_40918_41105 = state_40887__$1;
(statearr_40918_41105[(2)] = inst_40744);

(statearr_40918_41105[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (39))){
var inst_40637 = typeof from === 'string';
var state_40887__$1 = state_40887;
if(cljs.core.truth_(inst_40637)){
var statearr_40919_41106 = state_40887__$1;
(statearr_40919_41106[(1)] = (42));

} else {
var statearr_40920_41107 = state_40887__$1;
(statearr_40920_41107[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (88))){
var inst_40855 = (state_40887[(2)]);
var state_40887__$1 = state_40887;
var statearr_40921_41108 = state_40887__$1;
(statearr_40921_41108[(2)] = inst_40855);

(statearr_40921_41108[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (46))){
var inst_40656 = (state_40887[(2)]);
var inst_40657 = fluree.db.util.async.throw_err(inst_40656);
var state_40887__$1 = state_40887;
var statearr_40922_41109 = state_40887__$1;
(statearr_40922_41109[(2)] = inst_40657);

(statearr_40922_41109[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (4))){
var inst_40535 = (state_40887[(2)]);
var state_40887__$1 = state_40887;
var statearr_40923_41110 = state_40887__$1;
(statearr_40923_41110[(2)] = inst_40535);

(statearr_40923_41110[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (77))){
var inst_40724 = (state_40887[(2)]);
var inst_40725 = fluree.db.util.async.throw_err(inst_40724);
var state_40887__$1 = state_40887;
var statearr_40924_41111 = state_40887__$1;
(statearr_40924_41111[(2)] = inst_40725);

(statearr_40924_41111[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (106))){
var state_40887__$1 = state_40887;
if(cljs.core.truth_(fuel)){
var statearr_40925_41112 = state_40887__$1;
(statearr_40925_41112[(1)] = (108));

} else {
var statearr_40926_41113 = state_40887__$1;
(statearr_40926_41113[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (119))){
var state_40887__$1 = state_40887;
var statearr_40927_41114 = state_40887__$1;
(statearr_40927_41114[(2)] = null);

(statearr_40927_41114[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (95))){
var state_40887__$1 = state_40887;
var statearr_40928_41115 = state_40887__$1;
(statearr_40928_41115[(2)] = null);

(statearr_40928_41115[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (54))){
var inst_40700 = typeof from === 'string';
var state_40887__$1 = state_40887;
if(cljs.core.truth_(inst_40700)){
var statearr_40929_41116 = state_40887__$1;
(statearr_40929_41116[(1)] = (67));

} else {
var statearr_40930_41117 = state_40887__$1;
(statearr_40930_41117[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (92))){
var inst_40598 = (state_40887[(7)]);
var inst_40590 = (state_40887[(14)]);
var inst_40600 = (state_40887[(8)]);
var inst_40588 = (state_40887[(11)]);
var inst_40760 = (state_40887[(2)]);
var inst_40761 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_40600,fuel,max_fuel,inst_40598,inst_40760,inst_40588,inst_40590);
var state_40887__$1 = state_40887;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40887__$1,(93),inst_40761);
} else {
if((state_val_40888 === (104))){
var inst_40824 = (state_40887[(2)]);
var state_40887__$1 = state_40887;
var statearr_40931_41118 = state_40887__$1;
(statearr_40931_41118[(2)] = inst_40824);

(statearr_40931_41118[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (15))){
var inst_40565 = (state_40887[(23)]);
var inst_40570 = inst_40565.cljs$lang$protocol_mask$partition0$;
var inst_40571 = (inst_40570 & (64));
var inst_40572 = inst_40565.cljs$core$ISeq$;
var inst_40573 = (cljs.core.PROTOCOL_SENTINEL === inst_40572);
var inst_40574 = ((inst_40571) || (inst_40573));
var state_40887__$1 = state_40887;
if(cljs.core.truth_(inst_40574)){
var statearr_40932_41119 = state_40887__$1;
(statearr_40932_41119[(1)] = (18));

} else {
var statearr_40933_41120 = state_40887__$1;
(statearr_40933_41120[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (48))){
var inst_40588 = (state_40887[(11)]);
var state_40887__$1 = state_40887;
var statearr_40934_41121 = state_40887__$1;
(statearr_40934_41121[(2)] = inst_40588);

(statearr_40934_41121[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (50))){
var state_40887__$1 = state_40887;
var statearr_40935_41122 = state_40887__$1;
(statearr_40935_41122[(2)] = null);

(statearr_40935_41122[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (116))){
var state_40887__$1 = state_40887;
var statearr_40936_41123 = state_40887__$1;
(statearr_40936_41123[(2)] = null);

(statearr_40936_41123[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (75))){
var inst_40717 = (state_40887[(2)]);
var inst_40718 = fluree.db.query.range._block_or_tx_collection(db,inst_40717);
var state_40887__$1 = state_40887;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40887__$1,(76),inst_40718);
} else {
if((state_val_40888 === (99))){
var inst_40853 = (state_40887[(2)]);
var state_40887__$1 = state_40887;
var statearr_40937_41124 = state_40887__$1;
(statearr_40937_41124[(2)] = inst_40853);

(statearr_40937_41124[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (21))){
var inst_40565 = (state_40887[(23)]);
var inst_40583 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_40565);
var state_40887__$1 = state_40887;
var statearr_40938_41125 = state_40887__$1;
(statearr_40938_41125[(2)] = inst_40583);

(statearr_40938_41125[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (31))){
var inst_40587 = (state_40887[(13)]);
var inst_40610 = typeof inst_40587 === 'string';
var state_40887__$1 = state_40887;
if(cljs.core.truth_(inst_40610)){
var statearr_40939_41126 = state_40887__$1;
(statearr_40939_41126[(1)] = (33));

} else {
var statearr_40940_41127 = state_40887__$1;
(statearr_40940_41127[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (113))){
var inst_40790 = (state_40887[(22)]);
var state_40887__$1 = state_40887;
var statearr_40941_41128 = state_40887__$1;
(statearr_40941_41128[(2)] = inst_40790);

(statearr_40941_41128[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (32))){
var inst_40626 = (state_40887[(2)]);
var state_40887__$1 = state_40887;
var statearr_40942_41129 = state_40887__$1;
(statearr_40942_41129[(2)] = inst_40626);

(statearr_40942_41129[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (40))){
var inst_40659 = typeof from === 'string';
var inst_40660 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_40661 = clojure.string.includes_QMARK_(inst_40660,"/");
var inst_40662 = ((inst_40659) && (inst_40661));
var state_40887__$1 = state_40887;
if(cljs.core.truth_(inst_40662)){
var statearr_40943_41130 = state_40887__$1;
(statearr_40943_41130[(1)] = (53));

} else {
var statearr_40944_41131 = state_40887__$1;
(statearr_40944_41131[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (129))){
var inst_40869 = (state_40887[(24)]);
var state_40887__$1 = state_40887;
var statearr_40945_41132 = state_40887__$1;
(statearr_40945_41132[(2)] = inst_40869);

(statearr_40945_41132[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (91))){
var inst_40752 = (state_40887[(25)]);
var inst_40756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40757 = [inst_40752];
var inst_40758 = (new cljs.core.PersistentVector(null,1,(5),inst_40756,inst_40757,null));
var state_40887__$1 = state_40887;
var statearr_40946_41133 = state_40887__$1;
(statearr_40946_41133[(2)] = inst_40758);

(statearr_40946_41133[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (117))){
var inst_40588 = (state_40887[(11)]);
var state_40887__$1 = state_40887;
var statearr_40947_41134 = state_40887__$1;
(statearr_40947_41134[(2)] = inst_40588);

(statearr_40947_41134[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (108))){
var inst_40805 = cljs.core._deref(fuel);
var inst_40806 = (inst_40805 + (1));
var inst_40807 = cljs.core._vreset_BANG_(fuel,inst_40806);
var state_40887__$1 = state_40887;
var statearr_40948_41135 = state_40887__$1;
(statearr_40948_41135[(2)] = inst_40807);

(statearr_40948_41135[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (56))){
var inst_40665 = (state_40887[(26)]);
var inst_40667 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_40668 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_40665,inst_40667);
var state_40887__$1 = state_40887;
var statearr_40949_41136 = state_40887__$1;
(statearr_40949_41136[(2)] = inst_40668);

(statearr_40949_41136[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (33))){
var inst_40587 = (state_40887[(13)]);
var inst_40612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40613 = [inst_40587,"ASC"];
var inst_40614 = (new cljs.core.PersistentVector(null,2,(5),inst_40612,inst_40613,null));
var state_40887__$1 = state_40887;
var statearr_40950_41137 = state_40887__$1;
(statearr_40950_41137[(2)] = inst_40614);

(statearr_40950_41137[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (13))){
var inst_40554 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40555 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_40556 = cljs.core.PersistentHashMap.fromArrays(inst_40554,inst_40555);
var inst_40557 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_40556);
var inst_40558 = (function(){throw inst_40557})();
var state_40887__$1 = state_40887;
var statearr_40951_41138 = state_40887__$1;
(statearr_40951_41138[(2)] = inst_40558);

(statearr_40951_41138[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (22))){
var inst_40565 = (state_40887[(23)]);
var state_40887__$1 = state_40887;
var statearr_40952_41139 = state_40887__$1;
(statearr_40952_41139[(2)] = inst_40565);

(statearr_40952_41139[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (90))){
var state_40887__$1 = state_40887;
var statearr_40953_41140 = state_40887__$1;
(statearr_40953_41140[(2)] = null);

(statearr_40953_41140[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (109))){
var state_40887__$1 = state_40887;
var statearr_40954_41141 = state_40887__$1;
(statearr_40954_41141[(2)] = null);

(statearr_40954_41141[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (36))){
var inst_40617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40618 = [null,null];
var inst_40619 = (new cljs.core.PersistentVector(null,2,(5),inst_40617,inst_40618,null));
var state_40887__$1 = state_40887;
var statearr_40955_41142 = state_40887__$1;
(statearr_40955_41142[(2)] = inst_40619);

(statearr_40955_41142[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (41))){
var inst_40633 = (state_40887[(27)]);
var inst_40863 = (state_40887[(2)]);
var state_40887__$1 = (function (){var statearr_40956 = state_40887;
(statearr_40956[(28)] = inst_40863);

return statearr_40956;
})();
if(cljs.core.truth_(inst_40633)){
var statearr_40957_41143 = state_40887__$1;
(statearr_40957_41143[(1)] = (125));

} else {
var statearr_40958_41144 = state_40887__$1;
(statearr_40958_41144[(1)] = (126));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (118))){
var inst_40587 = (state_40887[(13)]);
var inst_40832 = (state_40887[(2)]);
var state_40887__$1 = (function (){var statearr_40959 = state_40887;
(statearr_40959[(10)] = inst_40832);

return statearr_40959;
})();
if(cljs.core.truth_(inst_40587)){
var statearr_40960_41145 = state_40887__$1;
(statearr_40960_41145[(1)] = (119));

} else {
var statearr_40961_41146 = state_40887__$1;
(statearr_40961_41146[(1)] = (120));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (89))){
var inst_40752 = (state_40887[(25)]);
var inst_40751 = (state_40887[(2)]);
var inst_40752__$1 = fluree.db.util.async.throw_err(inst_40751);
var inst_40753 = (inst_40752__$1 == null);
var state_40887__$1 = (function (){var statearr_40962 = state_40887;
(statearr_40962[(25)] = inst_40752__$1);

return statearr_40962;
})();
if(cljs.core.truth_(inst_40753)){
var statearr_40963_41147 = state_40887__$1;
(statearr_40963_41147[(1)] = (90));

} else {
var statearr_40964_41148 = state_40887__$1;
(statearr_40964_41148[(1)] = (91));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (100))){
var inst_40789 = (state_40887[(29)]);
var inst_40796 = (state_40887[(15)]);
var inst_40795 = cljs.core.seq(inst_40789);
var inst_40796__$1 = cljs.core.first(inst_40795);
var inst_40797 = cljs.core.next(inst_40795);
var inst_40798 = cljs.core.not(inst_40796__$1);
var state_40887__$1 = (function (){var statearr_40965 = state_40887;
(statearr_40965[(30)] = inst_40797);

(statearr_40965[(15)] = inst_40796__$1);

return statearr_40965;
})();
if(inst_40798){
var statearr_40966_41149 = state_40887__$1;
(statearr_40966_41149[(1)] = (102));

} else {
var statearr_40967_41150 = state_40887__$1;
(statearr_40967_41150[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (131))){
var inst_40868 = (state_40887[(17)]);
var inst_40879 = cljs.core.first(inst_40868);
var state_40887__$1 = state_40887;
var statearr_40968_41151 = state_40887__$1;
(statearr_40968_41151[(2)] = inst_40879);

(statearr_40968_41151[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (122))){
var inst_40843 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_40844 = ["Invalid 'from' in query:",inst_40843].join('');
var inst_40845 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40846 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_40847 = cljs.core.PersistentHashMap.fromArrays(inst_40845,inst_40846);
var inst_40848 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40844,inst_40847);
var state_40887__$1 = state_40887;
var statearr_40969_41152 = state_40887__$1;
(statearr_40969_41152[(2)] = inst_40848);

(statearr_40969_41152[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (43))){
var state_40887__$1 = state_40887;
var statearr_40970_41153 = state_40887__$1;
(statearr_40970_41153[(2)] = null);

(statearr_40970_41153[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (61))){
var inst_40587 = (state_40887[(13)]);
var inst_40677 = (state_40887[(2)]);
var state_40887__$1 = (function (){var statearr_40971 = state_40887;
(statearr_40971[(12)] = inst_40677);

return statearr_40971;
})();
if(cljs.core.truth_(inst_40587)){
var statearr_40972_41154 = state_40887__$1;
(statearr_40972_41154[(1)] = (62));

} else {
var statearr_40973_41155 = state_40887__$1;
(statearr_40973_41155[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (29))){
var inst_40632 = (state_40887[(2)]);
var inst_40633 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40632,(0),null);
var inst_40634 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40632,(1),null);
var inst_40635 = typeof where === 'string';
var state_40887__$1 = (function (){var statearr_40974 = state_40887;
(statearr_40974[(27)] = inst_40633);

(statearr_40974[(31)] = inst_40634);

return statearr_40974;
})();
if(cljs.core.truth_(inst_40635)){
var statearr_40975_41156 = state_40887__$1;
(statearr_40975_41156[(1)] = (39));

} else {
var statearr_40976_41157 = state_40887__$1;
(statearr_40976_41157[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (44))){
var inst_40641 = (state_40887[(2)]);
var inst_40642 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_40641);
var state_40887__$1 = state_40887;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40887__$1,(45),inst_40642);
} else {
if((state_val_40888 === (93))){
var inst_40763 = (state_40887[(2)]);
var inst_40764 = fluree.db.util.async.throw_err(inst_40763);
var state_40887__$1 = (function (){var statearr_40977 = state_40887;
(statearr_40977[(32)] = inst_40764);

return statearr_40977;
})();
if(cljs.core.truth_(fuel)){
var statearr_40978_41158 = state_40887__$1;
(statearr_40978_41158[(1)] = (94));

} else {
var statearr_40979_41159 = state_40887__$1;
(statearr_40979_41159[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (6))){
var inst_40545 = (state_40887[(33)]);
var state_40887__$1 = state_40887;
var statearr_40980_41160 = state_40887__$1;
(statearr_40980_41160[(2)] = inst_40545);

(statearr_40980_41160[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (111))){
var inst_40813 = (state_40887[(2)]);
var inst_40814 = fluree.db.util.async.throw_err(inst_40813);
var state_40887__$1 = state_40887;
var statearr_40981_41161 = state_40887__$1;
(statearr_40981_41161[(2)] = inst_40814);

(statearr_40981_41161[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (28))){
var inst_40628 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40629 = [null,null];
var inst_40630 = (new cljs.core.PersistentVector(null,2,(5),inst_40628,inst_40629,null));
var state_40887__$1 = state_40887;
var statearr_40982_41162 = state_40887__$1;
(statearr_40982_41162[(2)] = inst_40630);

(statearr_40982_41162[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (64))){
var inst_40685 = (state_40887[(2)]);
var inst_40686 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40687 = [from];
var inst_40688 = (new cljs.core.PersistentVector(null,1,(5),inst_40686,inst_40687,null));
var inst_40689 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_40688,inst_40685);
var state_40887__$1 = state_40887;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40887__$1,(65),inst_40689);
} else {
if((state_val_40888 === (103))){
var inst_40796 = (state_40887[(15)]);
var inst_40801 = cljs.core.int_QMARK_(inst_40796);
var state_40887__$1 = state_40887;
if(inst_40801){
var statearr_40983_41163 = state_40887__$1;
(statearr_40983_41163[(1)] = (105));

} else {
var statearr_40984_41164 = state_40887__$1;
(statearr_40984_41164[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (51))){
var inst_40590 = (state_40887[(14)]);
var state_40887__$1 = state_40887;
var statearr_40985_41165 = state_40887__$1;
(statearr_40985_41165[(2)] = inst_40590);

(statearr_40985_41165[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (25))){
var inst_40591 = (state_40887[(20)]);
var state_40887__$1 = state_40887;
var statearr_40986_41166 = state_40887__$1;
(statearr_40986_41166[(2)] = inst_40591);

(statearr_40986_41166[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (34))){
var state_40887__$1 = state_40887;
var statearr_40987_41167 = state_40887__$1;
(statearr_40987_41167[(1)] = (36));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (125))){
var inst_40590 = (state_40887[(14)]);
var inst_40863 = (state_40887[(28)]);
var inst_40633 = (state_40887[(27)]);
var inst_40634 = (state_40887[(31)]);
var inst_40588 = (state_40887[(11)]);
var inst_40865 = fluree.db.query.fql.sort_offset_and_limit_res(inst_40633,inst_40634,inst_40590,inst_40588,inst_40863);
var state_40887__$1 = state_40887;
var statearr_40989_41168 = state_40887__$1;
(statearr_40989_41168[(2)] = inst_40865);

(statearr_40989_41168[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (17))){
var inst_40581 = (state_40887[(2)]);
var state_40887__$1 = state_40887;
if(cljs.core.truth_(inst_40581)){
var statearr_40990_41169 = state_40887__$1;
(statearr_40990_41169[(1)] = (21));

} else {
var statearr_40991_41170 = state_40887__$1;
(statearr_40991_41170[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (3))){
var inst_40885 = (state_40887[(2)]);
var state_40887__$1 = state_40887;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40887__$1,inst_40885);
} else {
if((state_val_40888 === (12))){
var inst_40551 = (state_40887[(34)]);
var state_40887__$1 = state_40887;
var statearr_40992_41171 = state_40887__$1;
(statearr_40992_41171[(2)] = inst_40551);

(statearr_40992_41171[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (2))){
var inst_40545 = (state_40887[(33)]);
var _ = (function (){var statearr_40993 = state_40887;
(statearr_40993[(4)] = cljs.core.cons((5),(state_40887[(4)])));

return statearr_40993;
})();
var inst_40545__$1 = select;
var state_40887__$1 = (function (){var statearr_40994 = state_40887;
(statearr_40994[(33)] = inst_40545__$1);

return statearr_40994;
})();
if(cljs.core.truth_(inst_40545__$1)){
var statearr_40995_41172 = state_40887__$1;
(statearr_40995_41172[(1)] = (6));

} else {
var statearr_40996_41173 = state_40887__$1;
(statearr_40996_41173[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (66))){
var inst_40696 = (state_40887[(2)]);
var inst_40697 = fluree.db.util.async.throw_err(inst_40696);
var state_40887__$1 = state_40887;
var statearr_40997_41174 = state_40887__$1;
(statearr_40997_41174[(2)] = inst_40697);

(statearr_40997_41174[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (107))){
var inst_40816 = (state_40887[(35)]);
var inst_40816__$1 = (state_40887[(2)]);
var state_40887__$1 = (function (){var statearr_40998 = state_40887;
(statearr_40998[(35)] = inst_40816__$1);

return statearr_40998;
})();
if(cljs.core.truth_(inst_40816__$1)){
var statearr_40999_41175 = state_40887__$1;
(statearr_40999_41175[(1)] = (112));

} else {
var statearr_41000_41176 = state_40887__$1;
(statearr_41000_41176[(1)] = (113));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (23))){
var inst_40589 = (state_40887[(21)]);
var inst_40564 = (state_40887[(36)]);
var inst_40586 = (state_40887[(2)]);
var inst_40587 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40586,cljs.core.cst$kw$orderBy);
var inst_40588 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40586,cljs.core.cst$kw$limit);
var inst_40589__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40586,cljs.core.cst$kw$component);
var inst_40590 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40586,cljs.core.cst$kw$offset);
var inst_40591 = fluree.db.query.fql_parser.parse_db(db,inst_40564,opts_SINGLEQUOTE_);
var inst_40592 = (inst_40589__$1 == null);
var inst_40593 = cljs.core.not(inst_40592);
var state_40887__$1 = (function (){var statearr_41001 = state_40887;
(statearr_41001[(20)] = inst_40591);

(statearr_41001[(13)] = inst_40587);

(statearr_41001[(14)] = inst_40590);

(statearr_41001[(21)] = inst_40589__$1);

(statearr_41001[(11)] = inst_40588);

return statearr_41001;
})();
if(inst_40593){
var statearr_41002_41177 = state_40887__$1;
(statearr_41002_41177[(1)] = (24));

} else {
var statearr_41003_41178 = state_40887__$1;
(statearr_41003_41178[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (47))){
var state_40887__$1 = state_40887;
var statearr_41004_41179 = state_40887__$1;
(statearr_41004_41179[(2)] = null);

(statearr_41004_41179[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (35))){
var inst_40624 = (state_40887[(2)]);
var state_40887__$1 = state_40887;
var statearr_41005_41180 = state_40887__$1;
(statearr_41005_41180[(2)] = inst_40624);

(statearr_41005_41180[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (127))){
var inst_40869 = (state_40887[(24)]);
var inst_40868 = (state_40887[(2)]);
var inst_40869__$1 = selectOne;
var state_40887__$1 = (function (){var statearr_41006 = state_40887;
(statearr_41006[(24)] = inst_40869__$1);

(statearr_41006[(17)] = inst_40868);

return statearr_41006;
})();
if(cljs.core.truth_(inst_40869__$1)){
var statearr_41007_41181 = state_40887__$1;
(statearr_41007_41181[(1)] = (128));

} else {
var statearr_41008_41182 = state_40887__$1;
(statearr_41008_41182[(1)] = (129));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (82))){
var inst_40590 = (state_40887[(14)]);
var inst_40588 = (state_40887[(11)]);
var inst_40732 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_40733 = [inst_40588,inst_40590];
var inst_40734 = cljs.core.PersistentHashMap.fromArrays(inst_40732,inst_40733);
var state_40887__$1 = state_40887;
var statearr_41009_41183 = state_40887__$1;
(statearr_41009_41183[(2)] = inst_40734);

(statearr_41009_41183[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (76))){
var inst_40598 = (state_40887[(7)]);
var inst_40600 = (state_40887[(8)]);
var inst_40720 = (state_40887[(2)]);
var inst_40721 = fluree.db.util.async.throw_err(inst_40720);
var inst_40722 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_40600,fuel,max_fuel,inst_40598,inst_40721);
var state_40887__$1 = state_40887;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40887__$1,(77),inst_40722);
} else {
if((state_val_40888 === (97))){
var inst_40784 = from;
var inst_40785 = cljs.core.seq(inst_40784);
var inst_40786 = cljs.core.first(inst_40785);
var inst_40787 = cljs.core.next(inst_40785);
var inst_40788 = cljs.core.PersistentVector.EMPTY;
var inst_40789 = inst_40784;
var inst_40790 = inst_40788;
var state_40887__$1 = (function (){var statearr_41010 = state_40887;
(statearr_41010[(37)] = inst_40786);

(statearr_41010[(29)] = inst_40789);

(statearr_41010[(22)] = inst_40790);

(statearr_41010[(38)] = inst_40787);

return statearr_41010;
})();
var statearr_41011_41184 = state_40887__$1;
(statearr_41011_41184[(2)] = null);

(statearr_41011_41184[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (19))){
var state_40887__$1 = state_40887;
var statearr_41012_41185 = state_40887__$1;
(statearr_41012_41185[(2)] = false);

(statearr_41012_41185[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (57))){
var inst_40665 = (state_40887[(26)]);
var state_40887__$1 = state_40887;
var statearr_41013_41186 = state_40887__$1;
(statearr_41013_41186[(2)] = inst_40665);

(statearr_41013_41186[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (68))){
var state_40887__$1 = state_40887;
var statearr_41014_41187 = state_40887__$1;
(statearr_41014_41187[(2)] = false);

(statearr_41014_41187[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (11))){
var inst_40562 = (state_40887[(2)]);
var state_40887__$1 = state_40887;
var statearr_41015_41188 = state_40887__$1;
(statearr_41015_41188[(2)] = inst_40562);

(statearr_41015_41188[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (115))){
var inst_40839 = (state_40887[(2)]);
var inst_40840 = fluree.db.util.async.throw_err(inst_40839);
var state_40887__$1 = state_40887;
var statearr_41017_41189 = state_40887__$1;
(statearr_41017_41189[(2)] = inst_40840);

(statearr_41017_41189[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (9))){
var inst_40548 = (state_40887[(18)]);
var state_40887__$1 = state_40887;
var statearr_41018_41190 = state_40887__$1;
(statearr_41018_41190[(2)] = inst_40548);

(statearr_41018_41190[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (5))){
var _ = (function (){var statearr_41019 = state_40887;
(statearr_41019[(4)] = cljs.core.rest((state_40887[(4)])));

return statearr_41019;
})();
var state_40887__$1 = state_40887;
var ex41016 = (state_40887__$1[(2)]);
var statearr_41020_41191 = state_40887__$1;
(statearr_41020_41191[(5)] = ex41016);


if((ex41016 instanceof Error)){
var statearr_41021_41192 = state_40887__$1;
(statearr_41021_41192[(1)] = (4));

(statearr_41021_41192[(5)] = null);

} else {
throw ex41016;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (112))){
var inst_40816 = (state_40887[(35)]);
var inst_40790 = (state_40887[(22)]);
var inst_40818 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40790,inst_40816);
var state_40887__$1 = state_40887;
var statearr_41022_41193 = state_40887__$1;
(statearr_41022_41193[(2)] = inst_40818);

(statearr_41022_41193[(1)] = (114));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (83))){
var inst_40736 = (state_40887[(2)]);
var inst_40737 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_40736);
var state_40887__$1 = state_40887;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40887__$1,(84),inst_40737);
} else {
if((state_val_40888 === (14))){
var inst_40560 = (state_40887[(2)]);
var state_40887__$1 = state_40887;
var statearr_41023_41194 = state_40887__$1;
(statearr_41023_41194[(2)] = inst_40560);

(statearr_41023_41194[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (45))){
var inst_40587 = (state_40887[(13)]);
var inst_40644 = (state_40887[(2)]);
var inst_40645 = fluree.db.util.async.throw_err(inst_40644);
var state_40887__$1 = (function (){var statearr_41024 = state_40887;
(statearr_41024[(39)] = inst_40645);

return statearr_41024;
})();
if(cljs.core.truth_(inst_40587)){
var statearr_41025_41195 = state_40887__$1;
(statearr_41025_41195[(1)] = (47));

} else {
var statearr_41026_41196 = state_40887__$1;
(statearr_41026_41196[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (53))){
var inst_40665 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_40887__$1 = (function (){var statearr_41027 = state_40887;
(statearr_41027[(26)] = inst_40665);

return statearr_41027;
})();
if(cljs.core.truth_(fuel)){
var statearr_41028_41197 = state_40887__$1;
(statearr_41028_41197[(1)] = (56));

} else {
var statearr_41029_41198 = state_40887__$1;
(statearr_41029_41198[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (78))){
var inst_40587 = (state_40887[(13)]);
var state_40887__$1 = state_40887;
if(cljs.core.truth_(inst_40587)){
var statearr_41030_41199 = state_40887__$1;
(statearr_41030_41199[(1)] = (81));

} else {
var statearr_41031_41200 = state_40887__$1;
(statearr_41031_41200[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (132))){
var inst_40868 = (state_40887[(17)]);
var state_40887__$1 = state_40887;
var statearr_41032_41201 = state_40887__$1;
(statearr_41032_41201[(2)] = inst_40868);

(statearr_41032_41201[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (26))){
var inst_40587 = (state_40887[(13)]);
var inst_40598 = (state_40887[(2)]);
var inst_40599 = cljs.core.PersistentHashMap.EMPTY;
var inst_40600 = cljs.core.volatile_BANG_(inst_40599);
var state_40887__$1 = (function (){var statearr_41033 = state_40887;
(statearr_41033[(7)] = inst_40598);

(statearr_41033[(8)] = inst_40600);

return statearr_41033;
})();
if(cljs.core.truth_(inst_40587)){
var statearr_41034_41202 = state_40887__$1;
(statearr_41034_41202[(1)] = (27));

} else {
var statearr_41035_41203 = state_40887__$1;
(statearr_41035_41203[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (123))){
var state_40887__$1 = state_40887;
var statearr_41036_41204 = state_40887__$1;
(statearr_41036_41204[(2)] = null);

(statearr_41036_41204[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (16))){
var state_40887__$1 = state_40887;
var statearr_41037_41205 = state_40887__$1;
(statearr_41037_41205[(2)] = false);

(statearr_41037_41205[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (133))){
var inst_40882 = (state_40887[(2)]);
var _ = (function (){var statearr_41038 = state_40887;
(statearr_41038[(4)] = cljs.core.rest((state_40887[(4)])));

return statearr_41038;
})();
var state_40887__$1 = state_40887;
var statearr_41039_41206 = state_40887__$1;
(statearr_41039_41206[(2)] = inst_40882);

(statearr_41039_41206[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (81))){
var inst_40730 = cljs.core.PersistentHashMap.EMPTY;
var state_40887__$1 = state_40887;
var statearr_41040_41207 = state_40887__$1;
(statearr_41040_41207[(2)] = inst_40730);

(statearr_41040_41207[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (120))){
var inst_40590 = (state_40887[(14)]);
var state_40887__$1 = state_40887;
var statearr_41041_41208 = state_40887__$1;
(statearr_41041_41208[(2)] = inst_40590);

(statearr_41041_41208[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (79))){
var inst_40746 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_40887__$1 = state_40887;
if(inst_40746){
var statearr_41042_41209 = state_40887__$1;
(statearr_41042_41209[(1)] = (86));

} else {
var statearr_41043_41210 = state_40887__$1;
(statearr_41043_41210[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (38))){
var inst_40622 = (state_40887[(2)]);
var state_40887__$1 = state_40887;
var statearr_41044_41211 = state_40887__$1;
(statearr_41044_41211[(2)] = inst_40622);

(statearr_41044_41211[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (126))){
var inst_40863 = (state_40887[(28)]);
var state_40887__$1 = state_40887;
var statearr_41045_41212 = state_40887__$1;
(statearr_41045_41212[(2)] = inst_40863);

(statearr_41045_41212[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (98))){
var state_40887__$1 = state_40887;
var statearr_41046_41213 = state_40887__$1;
(statearr_41046_41213[(1)] = (122));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (124))){
var inst_40851 = (state_40887[(2)]);
var state_40887__$1 = state_40887;
var statearr_41048_41214 = state_40887__$1;
(statearr_41048_41214[(2)] = inst_40851);

(statearr_41048_41214[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (87))){
var inst_40773 = cljs.core.sequential_QMARK_(from);
var inst_40774 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var inst_40775 = ((inst_40773) && (inst_40774));
var state_40887__$1 = state_40887;
if(cljs.core.truth_(inst_40775)){
var statearr_41049_41215 = state_40887__$1;
(statearr_41049_41215[(1)] = (97));

} else {
var statearr_41050_41216 = state_40887__$1;
(statearr_41050_41216[(1)] = (98));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (30))){
var inst_40587 = (state_40887[(13)]);
var inst_40604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40605 = cljs.core.second(inst_40587);
var inst_40606 = cljs.core.first(inst_40587);
var inst_40607 = [inst_40605,inst_40606];
var inst_40608 = (new cljs.core.PersistentVector(null,2,(5),inst_40604,inst_40607,null));
var state_40887__$1 = state_40887;
var statearr_41051_41217 = state_40887__$1;
(statearr_41051_41217[(2)] = inst_40608);

(statearr_41051_41217[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (73))){
var inst_40711 = cljs.core.PersistentHashMap.EMPTY;
var state_40887__$1 = state_40887;
var statearr_41052_41218 = state_40887__$1;
(statearr_41052_41218[(2)] = inst_40711);

(statearr_41052_41218[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (96))){
var inst_40764 = (state_40887[(32)]);
var inst_40771 = (state_40887[(2)]);
var state_40887__$1 = (function (){var statearr_41053 = state_40887;
(statearr_41053[(40)] = inst_40771);

return statearr_41053;
})();
var statearr_41054_41219 = state_40887__$1;
(statearr_41054_41219[(2)] = inst_40764);

(statearr_41054_41219[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (10))){
var inst_40551 = (state_40887[(34)]);
var inst_40551__$1 = selectDistinct;
var state_40887__$1 = (function (){var statearr_41055 = state_40887;
(statearr_41055[(34)] = inst_40551__$1);

return statearr_41055;
})();
if(cljs.core.truth_(inst_40551__$1)){
var statearr_41056_41220 = state_40887__$1;
(statearr_41056_41220[(1)] = (12));

} else {
var statearr_41057_41221 = state_40887__$1;
(statearr_41057_41221[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (18))){
var state_40887__$1 = state_40887;
var statearr_41058_41222 = state_40887__$1;
(statearr_41058_41222[(2)] = true);

(statearr_41058_41222[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (105))){
var inst_40796 = (state_40887[(15)]);
var state_40887__$1 = state_40887;
var statearr_41059_41223 = state_40887__$1;
(statearr_41059_41223[(2)] = inst_40796);

(statearr_41059_41223[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (52))){
var inst_40649 = (state_40887[(41)]);
var inst_40598 = (state_40887[(7)]);
var inst_40600 = (state_40887[(8)]);
var inst_40645 = (state_40887[(39)]);
var inst_40653 = (state_40887[(2)]);
var inst_40654 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_40600,fuel,max_fuel,inst_40598,inst_40645,inst_40649,inst_40653);
var state_40887__$1 = state_40887;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40887__$1,(46),inst_40654);
} else {
if((state_val_40888 === (114))){
var inst_40797 = (state_40887[(30)]);
var inst_40821 = (state_40887[(2)]);
var inst_40789 = inst_40797;
var inst_40790 = inst_40821;
var state_40887__$1 = (function (){var statearr_41060 = state_40887;
(statearr_41060[(29)] = inst_40789);

(statearr_41060[(22)] = inst_40790);

return statearr_41060;
})();
var statearr_41061_41224 = state_40887__$1;
(statearr_41061_41224[(2)] = null);

(statearr_41061_41224[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (67))){
var inst_40702 = ["_tx",null,"_block",null];
var inst_40703 = (new cljs.core.PersistentArrayMap(null,2,inst_40702,null));
var inst_40704 = (new cljs.core.PersistentHashSet(null,inst_40703,null));
var inst_40705 = (inst_40704.cljs$core$IFn$_invoke$arity$1 ? inst_40704.cljs$core$IFn$_invoke$arity$1(from) : inst_40704.call(null,from));
var state_40887__$1 = state_40887;
var statearr_41062_41225 = state_40887__$1;
(statearr_41062_41225[(2)] = inst_40705);

(statearr_41062_41225[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (71))){
var inst_40727 = typeof from === 'string';
var state_40887__$1 = state_40887;
if(cljs.core.truth_(inst_40727)){
var statearr_41063_41226 = state_40887__$1;
(statearr_41063_41226[(1)] = (78));

} else {
var statearr_41064_41227 = state_40887__$1;
(statearr_41064_41227[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (42))){
var state_40887__$1 = state_40887;
var statearr_41065_41228 = state_40887__$1;
(statearr_41065_41228[(2)] = from);

(statearr_41065_41228[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (80))){
var inst_40857 = (state_40887[(2)]);
var state_40887__$1 = state_40887;
var statearr_41066_41229 = state_40887__$1;
(statearr_41066_41229[(2)] = inst_40857);

(statearr_41066_41229[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (37))){
var state_40887__$1 = state_40887;
var statearr_41067_41230 = state_40887__$1;
(statearr_41067_41230[(2)] = null);

(statearr_41067_41230[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (63))){
var inst_40590 = (state_40887[(14)]);
var inst_40588 = (state_40887[(11)]);
var inst_40681 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_40682 = [inst_40588,inst_40590];
var inst_40683 = cljs.core.PersistentHashMap.fromArrays(inst_40681,inst_40682);
var state_40887__$1 = state_40887;
var statearr_41068_41231 = state_40887__$1;
(statearr_41068_41231[(2)] = inst_40683);

(statearr_41068_41231[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (94))){
var inst_40766 = cljs.core._deref(fuel);
var inst_40767 = (inst_40766 + (1));
var inst_40768 = cljs.core._vreset_BANG_(fuel,inst_40767);
var state_40887__$1 = state_40887;
var statearr_41069_41232 = state_40887__$1;
(statearr_41069_41232[(2)] = inst_40768);

(statearr_41069_41232[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (8))){
var inst_40565 = (state_40887[(23)]);
var inst_40564 = (state_40887[(2)]);
var inst_40565__$1 = opts_SINGLEQUOTE_;
var inst_40567 = (inst_40565__$1 == null);
var inst_40568 = cljs.core.not(inst_40567);
var state_40887__$1 = (function (){var statearr_41070 = state_40887;
(statearr_41070[(23)] = inst_40565__$1);

(statearr_41070[(36)] = inst_40564);

return statearr_41070;
})();
if(inst_40568){
var statearr_41071_41233 = state_40887__$1;
(statearr_41071_41233[(1)] = (15));

} else {
var statearr_41072_41234 = state_40887__$1;
(statearr_41072_41234[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (49))){
var inst_40587 = (state_40887[(13)]);
var inst_40649 = (state_40887[(2)]);
var state_40887__$1 = (function (){var statearr_41073 = state_40887;
(statearr_41073[(41)] = inst_40649);

return statearr_41073;
})();
if(cljs.core.truth_(inst_40587)){
var statearr_41074_41235 = state_40887__$1;
(statearr_41074_41235[(1)] = (50));

} else {
var statearr_41075_41236 = state_40887__$1;
(statearr_41075_41236[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40888 === (84))){
var inst_40598 = (state_40887[(7)]);
var inst_40600 = (state_40887[(8)]);
var inst_40739 = (state_40887[(2)]);
var inst_40740 = fluree.db.util.async.throw_err(inst_40739);
var inst_40741 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_40600,fuel,max_fuel,inst_40598,inst_40740);
var state_40887__$1 = state_40887;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40887__$1,(85),inst_40741);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__16301__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__16301__auto____0 = (function (){
var statearr_41076 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41076[(0)] = fluree$db$query$fql$query_$_state_machine__16301__auto__);

(statearr_41076[(1)] = (1));

return statearr_41076;
});
var fluree$db$query$fql$query_$_state_machine__16301__auto____1 = (function (state_40887){
while(true){
var ret_value__16302__auto__ = (function (){try{while(true){
var result__16303__auto__ = switch__16300__auto__(state_40887);
if(cljs.core.keyword_identical_QMARK_(result__16303__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16303__auto__;
}
break;
}
}catch (e41077){var ex__16304__auto__ = e41077;
var statearr_41078_41237 = state_40887;
(statearr_41078_41237[(2)] = ex__16304__auto__);


if(cljs.core.seq((state_40887[(4)]))){
var statearr_41079_41238 = state_40887;
(statearr_41079_41238[(1)] = cljs.core.first((state_40887[(4)])));

} else {
throw ex__16304__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16302__auto__,cljs.core.cst$kw$recur)){
var G__41239 = state_40887;
state_40887 = G__41239;
continue;
} else {
return ret_value__16302__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__16301__auto__ = function(state_40887){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__16301__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__16301__auto____1.call(this,state_40887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__16301__auto____0;
fluree$db$query$fql$query_$_state_machine__16301__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__16301__auto____1;
return fluree$db$query$fql$query_$_state_machine__16301__auto__;
})()
})();
var state__16377__auto__ = (function (){var statearr_41080 = (f__16376__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16376__auto__.cljs$core$IFn$_invoke$arity$0() : f__16376__auto__.call(null));
(statearr_41080[(6)] = c__16375__auto__);

return statearr_41080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16377__auto__);
}));

return c__16375__auto__;
}

});
