// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants true, :target :nodejs}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$column,col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__42555 = (line + (1));
var G__42556 = (1);
var G__42557 = (counter + (1));
line = G__42555;
col = G__42556;
counter = G__42557;
continue;
} else {
var G__42558 = line;
var G__42559 = (col + (1));
var G__42560 = (counter + (1));
line = G__42558;
col = G__42559;
counter = G__42560;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__42561 = cljs.core.next(chars);
var G__42562 = (n__$1 - (1));
chars = G__42561;
n__$1 = G__42562;
continue;
} else {
var G__42563 = cljs.core.next(chars);
var G__42564 = n__$1;
chars = G__42563;
n__$1 = G__42564;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$text,instaparse.failure.get_line(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$char_DASH_range.cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__42565){
var map__42566 = p__42565;
var map__42566__$1 = (((((!((map__42566 == null))))?(((((map__42566.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__42566.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__42566):map__42566);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42566__$1,cljs.core.cst$kw$line);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42566__$1,cljs.core.cst$kw$column);
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42566__$1,cljs.core.cst$kw$text);
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42566__$1,cljs.core.cst$kw$reason);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full,reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.cst$kw$full),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__42568_42576 = cljs.core.seq(full_reasons);
var chunk__42569_42577 = null;
var count__42570_42578 = (0);
var i__42571_42579 = (0);
while(true){
if((i__42571_42579 < count__42570_42578)){
var r_42580 = chunk__42569_42577.cljs$core$IIndexed$_nth$arity$2(null,i__42571_42579);
instaparse.failure.print_reason(r_42580);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__42581 = seq__42568_42576;
var G__42582 = chunk__42569_42577;
var G__42583 = count__42570_42578;
var G__42584 = (i__42571_42579 + (1));
seq__42568_42576 = G__42581;
chunk__42569_42577 = G__42582;
count__42570_42578 = G__42583;
i__42571_42579 = G__42584;
continue;
} else {
var temp__5735__auto___42585 = cljs.core.seq(seq__42568_42576);
if(temp__5735__auto___42585){
var seq__42568_42586__$1 = temp__5735__auto___42585;
if(cljs.core.chunked_seq_QMARK_(seq__42568_42586__$1)){
var c__4556__auto___42587 = cljs.core.chunk_first(seq__42568_42586__$1);
var G__42588 = cljs.core.chunk_rest(seq__42568_42586__$1);
var G__42589 = c__4556__auto___42587;
var G__42590 = cljs.core.count(c__4556__auto___42587);
var G__42591 = (0);
seq__42568_42576 = G__42588;
chunk__42569_42577 = G__42589;
count__42570_42578 = G__42590;
i__42571_42579 = G__42591;
continue;
} else {
var r_42592 = cljs.core.first(seq__42568_42586__$1);
instaparse.failure.print_reason(r_42592);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__42593 = cljs.core.next(seq__42568_42586__$1);
var G__42594 = null;
var G__42595 = (0);
var G__42596 = (0);
seq__42568_42576 = G__42593;
chunk__42569_42577 = G__42594;
count__42570_42578 = G__42595;
i__42571_42579 = G__42596;
continue;
}
} else {
}
}
break;
}

var seq__42572 = cljs.core.seq(partial_reasons);
var chunk__42573 = null;
var count__42574 = (0);
var i__42575 = (0);
while(true){
if((i__42575 < count__42574)){
var r = chunk__42573.cljs$core$IIndexed$_nth$arity$2(null,i__42575);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__42597 = seq__42572;
var G__42598 = chunk__42573;
var G__42599 = count__42574;
var G__42600 = (i__42575 + (1));
seq__42572 = G__42597;
chunk__42573 = G__42598;
count__42574 = G__42599;
i__42575 = G__42600;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__42572);
if(temp__5735__auto__){
var seq__42572__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__42572__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__42572__$1);
var G__42601 = cljs.core.chunk_rest(seq__42572__$1);
var G__42602 = c__4556__auto__;
var G__42603 = cljs.core.count(c__4556__auto__);
var G__42604 = (0);
seq__42572 = G__42601;
chunk__42573 = G__42602;
count__42574 = G__42603;
i__42575 = G__42604;
continue;
} else {
var r = cljs.core.first(seq__42572__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__42605 = cljs.core.next(seq__42572__$1);
var G__42606 = null;
var G__42607 = (0);
var G__42608 = (0);
seq__42572 = G__42605;
chunk__42573 = G__42606;
count__42574 = G__42607;
i__42575 = G__42608;
continue;
}
} else {
return null;
}
}
break;
}
});
