// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__66752 = arguments.length;
switch (G__66752) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5733__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5733__auto__)){
var block = temp__5733__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2901__auto___66791 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_66773){
var state_val_66774 = (state_66773[(1)]);
if((state_val_66774 === (1))){
var state_66773__$1 = state_66773;
var statearr_66775_66792 = state_66773__$1;
(statearr_66775_66792[(2)] = null);

(statearr_66775_66792[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66774 === (2))){
var _ = (function (){var statearr_66776 = state_66773;
(statearr_66776[(4)] = cljs.core.cons((5),(state_66773[(4)])));

return statearr_66776;
})();
var inst_66759 = fluree.db.session.db(conn,ledger,null);
var state_66773__$1 = state_66773;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66773__$1,(7),inst_66759);
} else {
if((state_val_66774 === (3))){
var inst_66769 = (state_66773[(2)]);
var inst_66770 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_66769);
var inst_66771 = cljs.core.async.close_BANG_(pc);
var state_66773__$1 = (function (){var statearr_66778 = state_66773;
(statearr_66778[(7)] = inst_66770);

return statearr_66778;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_66773__$1,inst_66771);
} else {
if((state_val_66774 === (4))){
var inst_66753 = (state_66773[(2)]);
var state_66773__$1 = state_66773;
var statearr_66779_66793 = state_66773__$1;
(statearr_66779_66793[(2)] = inst_66753);

(statearr_66779_66793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66774 === (5))){
var _ = (function (){var statearr_66780 = state_66773;
(statearr_66780[(4)] = cljs.core.rest((state_66773[(4)])));

return statearr_66780;
})();
var state_66773__$1 = state_66773;
var ex66777 = (state_66773__$1[(2)]);
var statearr_66781_66794 = state_66773__$1;
(statearr_66781_66794[(5)] = ex66777);


var statearr_66782_66795 = state_66773__$1;
(statearr_66782_66795[(1)] = (4));

(statearr_66782_66795[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66774 === (6))){
var inst_66765 = (state_66773[(2)]);
var inst_66766 = fluree.db.util.async.throw_err(inst_66765);
var _ = (function (){var statearr_66783 = state_66773;
(statearr_66783[(4)] = cljs.core.rest((state_66773[(4)])));

return statearr_66783;
})();
var state_66773__$1 = state_66773;
var statearr_66784_66796 = state_66773__$1;
(statearr_66784_66796[(2)] = inst_66766);

(statearr_66784_66796[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66774 === (7))){
var inst_66761 = (state_66773[(2)]);
var inst_66762 = fluree.db.util.async.throw_err(inst_66761);
var inst_66763 = fluree.db.time_travel.as_of_block(inst_66762,block);
var state_66773__$1 = state_66773;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66773__$1,(6),inst_66763);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2879__auto__ = null;
var fluree$db$api$ledger$state_machine__2879__auto____0 = (function (){
var statearr_66785 = [null,null,null,null,null,null,null,null];
(statearr_66785[(0)] = fluree$db$api$ledger$state_machine__2879__auto__);

(statearr_66785[(1)] = (1));

return statearr_66785;
});
var fluree$db$api$ledger$state_machine__2879__auto____1 = (function (state_66773){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_66773);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e66786){var ex__2882__auto__ = e66786;
var statearr_66787_66797 = state_66773;
(statearr_66787_66797[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_66773[(4)]))){
var statearr_66788_66798 = state_66773;
(statearr_66788_66798[(1)] = cljs.core.first((state_66773[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66799 = state_66773;
state_66773 = G__66799;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2879__auto__ = function(state_66773){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2879__auto____1.call(this,state_66773);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2879__auto____0;
fluree$db$api$ledger$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2879__auto____1;
return fluree$db$api$ledger$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_66789 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_66789[(6)] = c__2901__auto___66791);

return statearr_66789;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_66840){
var state_val_66841 = (state_66840[(1)]);
if((state_val_66841 === (7))){
var inst_66809 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_66840__$1 = state_66840;
if(inst_66809){
var statearr_66842_66873 = state_66840__$1;
(statearr_66842_66873[(1)] = (9));

} else {
var statearr_66843_66874 = state_66840__$1;
(statearr_66843_66874[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (1))){
var state_66840__$1 = state_66840;
var statearr_66844_66875 = state_66840__$1;
(statearr_66844_66875[(2)] = null);

(statearr_66844_66875[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (4))){
var inst_66800 = (state_66840[(2)]);
var state_66840__$1 = state_66840;
var statearr_66845_66876 = state_66840__$1;
(statearr_66845_66876[(2)] = inst_66800);

(statearr_66845_66876[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (15))){
var inst_66817 = (state_66840[(7)]);
var inst_66816 = (state_66840[(2)]);
var inst_66817__$1 = fluree.db.util.async.throw_err(inst_66816);
var state_66840__$1 = (function (){var statearr_66846 = state_66840;
(statearr_66846[(7)] = inst_66817__$1);

return statearr_66846;
})();
if(cljs.core.truth_(inst_66817__$1)){
var statearr_66847_66877 = state_66840__$1;
(statearr_66847_66877[(1)] = (16));

} else {
var statearr_66848_66878 = state_66840__$1;
(statearr_66848_66878[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (13))){
var state_66840__$1 = state_66840;
var statearr_66849_66879 = state_66840__$1;
(statearr_66849_66879[(2)] = null);

(statearr_66849_66879[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (6))){
var state_66840__$1 = state_66840;
var statearr_66850_66880 = state_66840__$1;
(statearr_66850_66880[(2)] = db);

(statearr_66850_66880[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (17))){
var inst_66821 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_66822 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66823 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_66824 = cljs.core.PersistentHashMap.fromArrays(inst_66822,inst_66823);
var inst_66825 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66821,inst_66824);
var inst_66826 = (function(){throw inst_66825})();
var state_66840__$1 = state_66840;
var statearr_66851_66881 = state_66840__$1;
(statearr_66851_66881[(2)] = inst_66826);

(statearr_66851_66881[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (3))){
var inst_66838 = (state_66840[(2)]);
var state_66840__$1 = state_66840;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66840__$1,inst_66838);
} else {
if((state_val_66841 === (12))){
var inst_66814 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_66840__$1 = state_66840;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66840__$1,(15),inst_66814);
} else {
if((state_val_66841 === (2))){
var _ = (function (){var statearr_66852 = state_66840;
(statearr_66852[(4)] = cljs.core.cons((5),(state_66840[(4)])));

return statearr_66852;
})();
var inst_66806 = cljs.core.not(auth);
var state_66840__$1 = state_66840;
if(inst_66806){
var statearr_66853_66882 = state_66840__$1;
(statearr_66853_66882[(1)] = (6));

} else {
var statearr_66854_66883 = state_66840__$1;
(statearr_66854_66883[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (11))){
var inst_66833 = (state_66840[(2)]);
var state_66840__$1 = state_66840;
var statearr_66856_66884 = state_66840__$1;
(statearr_66856_66884[(2)] = inst_66833);

(statearr_66856_66884[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (9))){
var inst_66811 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_66840__$1 = state_66840;
var statearr_66857_66885 = state_66840__$1;
(statearr_66857_66885[(2)] = inst_66811);

(statearr_66857_66885[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (5))){
var _ = (function (){var statearr_66858 = state_66840;
(statearr_66858[(4)] = cljs.core.rest((state_66840[(4)])));

return statearr_66858;
})();
var state_66840__$1 = state_66840;
var ex66855 = (state_66840__$1[(2)]);
var statearr_66859_66886 = state_66840__$1;
(statearr_66859_66886[(5)] = ex66855);


if((ex66855 instanceof Error)){
var statearr_66860_66887 = state_66840__$1;
(statearr_66860_66887[(1)] = (4));

(statearr_66860_66887[(5)] = null);

} else {
throw ex66855;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (14))){
var inst_66831 = (state_66840[(2)]);
var state_66840__$1 = state_66840;
var statearr_66861_66888 = state_66840__$1;
(statearr_66861_66888[(2)] = inst_66831);

(statearr_66861_66888[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (16))){
var inst_66817 = (state_66840[(7)]);
var inst_66819 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_66817);
var state_66840__$1 = state_66840;
var statearr_66862_66889 = state_66840__$1;
(statearr_66862_66889[(2)] = inst_66819);

(statearr_66862_66889[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (10))){
var state_66840__$1 = state_66840;
var statearr_66863_66890 = state_66840__$1;
(statearr_66863_66890[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (18))){
var inst_66828 = (state_66840[(2)]);
var state_66840__$1 = state_66840;
var statearr_66865_66891 = state_66840__$1;
(statearr_66865_66891[(2)] = inst_66828);

(statearr_66865_66891[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66841 === (8))){
var inst_66835 = (state_66840[(2)]);
var _ = (function (){var statearr_66866 = state_66840;
(statearr_66866[(4)] = cljs.core.rest((state_66840[(4)])));

return statearr_66866;
})();
var state_66840__$1 = state_66840;
var statearr_66867_66892 = state_66840__$1;
(statearr_66867_66892[(2)] = inst_66835);

(statearr_66867_66892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto____0 = (function (){
var statearr_66868 = [null,null,null,null,null,null,null,null];
(statearr_66868[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto__);

(statearr_66868[(1)] = (1));

return statearr_66868;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto____1 = (function (state_66840){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_66840);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e66869){var ex__2882__auto__ = e66869;
var statearr_66870_66893 = state_66840;
(statearr_66870_66893[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_66840[(4)]))){
var statearr_66871_66894 = state_66840;
(statearr_66871_66894[(1)] = cljs.core.first((state_66840[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66895 = state_66840;
state_66840 = G__66895;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto__ = function(state_66840){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto____1.call(this,state_66840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_66872 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_66872[(6)] = c__2901__auto__);

return statearr_66872;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_66959){
var state_val_66960 = (state_66959[(1)]);
if((state_val_66960 === (7))){
var inst_66905 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_66959__$1 = state_66959;
if(inst_66905){
var statearr_66961_67010 = state_66959__$1;
(statearr_66961_67010[(1)] = (9));

} else {
var statearr_66962_67011 = state_66959__$1;
(statearr_66962_67011[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (20))){
var inst_66929 = (state_66959[(7)]);
var state_66959__$1 = state_66959;
if(cljs.core.truth_(inst_66929)){
var statearr_66963_67012 = state_66959__$1;
(statearr_66963_67012[(1)] = (22));

} else {
var statearr_66964_67013 = state_66959__$1;
(statearr_66964_67013[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (27))){
var state_66959__$1 = state_66959;
var statearr_66965_67014 = state_66959__$1;
(statearr_66965_67014[(2)] = null);

(statearr_66965_67014[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (1))){
var state_66959__$1 = state_66959;
var statearr_66966_67015 = state_66959__$1;
(statearr_66966_67015[(2)] = null);

(statearr_66966_67015[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (24))){
var inst_66943 = (state_66959[(2)]);
var state_66959__$1 = state_66959;
var statearr_66967_67016 = state_66959__$1;
(statearr_66967_67016[(2)] = inst_66943);

(statearr_66967_67016[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (4))){
var inst_66896 = (state_66959[(2)]);
var state_66959__$1 = state_66959;
var statearr_66968_67017 = state_66959__$1;
(statearr_66968_67017[(2)] = inst_66896);

(statearr_66968_67017[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (15))){
var inst_66912 = (state_66959[(8)]);
var inst_66911 = (state_66959[(2)]);
var inst_66912__$1 = fluree.db.util.async.throw_err(inst_66911);
var state_66959__$1 = (function (){var statearr_66969 = state_66959;
(statearr_66969[(8)] = inst_66912__$1);

return statearr_66969;
})();
if(cljs.core.truth_(inst_66912__$1)){
var statearr_66970_67018 = state_66959__$1;
(statearr_66970_67018[(1)] = (16));

} else {
var statearr_66971_67019 = state_66959__$1;
(statearr_66971_67019[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (21))){
var inst_66945 = (state_66959[(9)]);
var inst_66945__$1 = (state_66959[(2)]);
var state_66959__$1 = (function (){var statearr_66972 = state_66959;
(statearr_66972[(9)] = inst_66945__$1);

return statearr_66972;
})();
if(cljs.core.truth_(inst_66945__$1)){
var statearr_66973_67020 = state_66959__$1;
(statearr_66973_67020[(1)] = (29));

} else {
var statearr_66974_67021 = state_66959__$1;
(statearr_66974_67021[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (31))){
var inst_66945 = (state_66959[(9)]);
var inst_66929 = (state_66959[(7)]);
var inst_66953 = (state_66959[(2)]);
var inst_66954 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_66929,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_66945,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_66953], 0));
var _ = (function (){var statearr_66975 = state_66959;
(statearr_66975[(4)] = cljs.core.rest((state_66959[(4)])));

return statearr_66975;
})();
var state_66959__$1 = state_66959;
var statearr_66976_67022 = state_66959__$1;
(statearr_66976_67022[(2)] = inst_66954);

(statearr_66976_67022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (32))){
var inst_66949 = (state_66959[(2)]);
var inst_66950 = fluree.db.util.async.throw_err(inst_66949);
var state_66959__$1 = state_66959;
var statearr_66977_67023 = state_66959__$1;
(statearr_66977_67023[(2)] = inst_66950);

(statearr_66977_67023[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (13))){
var state_66959__$1 = state_66959;
var statearr_66978_67024 = state_66959__$1;
(statearr_66978_67024[(2)] = null);

(statearr_66978_67024[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (22))){
var inst_66929 = (state_66959[(7)]);
var inst_66933 = fluree.db.auth.roles(db,inst_66929);
var state_66959__$1 = state_66959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66959__$1,(25),inst_66933);
} else {
if((state_val_66960 === (29))){
var inst_66945 = (state_66959[(9)]);
var inst_66947 = fluree.db.permissions.permission_map(db,inst_66945,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_66959__$1 = state_66959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66959__$1,(32),inst_66947);
} else {
if((state_val_66960 === (6))){
var state_66959__$1 = state_66959;
var statearr_66979_67025 = state_66959__$1;
(statearr_66979_67025[(2)] = null);

(statearr_66979_67025[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (28))){
var inst_66941 = (state_66959[(2)]);
var state_66959__$1 = state_66959;
var statearr_66980_67026 = state_66959__$1;
(statearr_66980_67026[(2)] = inst_66941);

(statearr_66980_67026[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (25))){
var inst_66935 = (state_66959[(2)]);
var inst_66936 = fluree.db.util.async.throw_err(inst_66935);
var state_66959__$1 = state_66959;
var statearr_66981_67027 = state_66959__$1;
(statearr_66981_67027[(2)] = inst_66936);

(statearr_66981_67027[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (17))){
var inst_66915 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_66916 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66917 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_66918 = cljs.core.PersistentHashMap.fromArrays(inst_66916,inst_66917);
var inst_66919 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66915,inst_66918);
var inst_66920 = (function(){throw inst_66919})();
var state_66959__$1 = state_66959;
var statearr_66982_67028 = state_66959__$1;
(statearr_66982_67028[(2)] = inst_66920);

(statearr_66982_67028[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (3))){
var inst_66957 = (state_66959[(2)]);
var state_66959__$1 = state_66959;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66959__$1,inst_66957);
} else {
if((state_val_66960 === (12))){
var inst_66909 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_66959__$1 = state_66959;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66959__$1,(15),inst_66909);
} else {
if((state_val_66960 === (2))){
var _ = (function (){var statearr_66983 = state_66959;
(statearr_66983[(4)] = cljs.core.cons((5),(state_66959[(4)])));

return statearr_66983;
})();
var inst_66902 = (auth == null);
var state_66959__$1 = state_66959;
if(cljs.core.truth_(inst_66902)){
var statearr_66984_67029 = state_66959__$1;
(statearr_66984_67029[(1)] = (6));

} else {
var statearr_66985_67030 = state_66959__$1;
(statearr_66985_67030[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (23))){
var state_66959__$1 = state_66959;
var statearr_66986_67031 = state_66959__$1;
(statearr_66986_67031[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (19))){
var state_66959__$1 = state_66959;
var statearr_66988_67032 = state_66959__$1;
(statearr_66988_67032[(2)] = roles);

(statearr_66988_67032[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (11))){
var inst_66927 = (state_66959[(2)]);
var state_66959__$1 = state_66959;
var statearr_66990_67033 = state_66959__$1;
(statearr_66990_67033[(2)] = inst_66927);

(statearr_66990_67033[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (9))){
var state_66959__$1 = state_66959;
var statearr_66991_67034 = state_66959__$1;
(statearr_66991_67034[(2)] = (0));

(statearr_66991_67034[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (5))){
var _ = (function (){var statearr_66992 = state_66959;
(statearr_66992[(4)] = cljs.core.rest((state_66959[(4)])));

return statearr_66992;
})();
var state_66959__$1 = state_66959;
var ex66989 = (state_66959__$1[(2)]);
var statearr_66993_67035 = state_66959__$1;
(statearr_66993_67035[(5)] = ex66989);


if((ex66989 instanceof Error)){
var statearr_66994_67036 = state_66959__$1;
(statearr_66994_67036[(1)] = (4));

(statearr_66994_67036[(5)] = null);

} else {
throw ex66989;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (14))){
var inst_66925 = (state_66959[(2)]);
var state_66959__$1 = state_66959;
var statearr_66995_67037 = state_66959__$1;
(statearr_66995_67037[(2)] = inst_66925);

(statearr_66995_67037[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (26))){
var state_66959__$1 = state_66959;
var statearr_66996_67038 = state_66959__$1;
(statearr_66996_67038[(2)] = null);

(statearr_66996_67038[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (16))){
var inst_66912 = (state_66959[(8)]);
var state_66959__$1 = state_66959;
var statearr_66997_67039 = state_66959__$1;
(statearr_66997_67039[(2)] = inst_66912);

(statearr_66997_67039[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (30))){
var state_66959__$1 = state_66959;
var statearr_66998_67040 = state_66959__$1;
(statearr_66998_67040[(2)] = null);

(statearr_66998_67040[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (10))){
var state_66959__$1 = state_66959;
if(cljs.core.truth_(auth)){
var statearr_66999_67041 = state_66959__$1;
(statearr_66999_67041[(1)] = (12));

} else {
var statearr_67000_67042 = state_66959__$1;
(statearr_67000_67042[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (18))){
var inst_66922 = (state_66959[(2)]);
var state_66959__$1 = state_66959;
var statearr_67001_67043 = state_66959__$1;
(statearr_67001_67043[(2)] = inst_66922);

(statearr_67001_67043[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66960 === (8))){
var inst_66929 = (state_66959[(2)]);
var state_66959__$1 = (function (){var statearr_67002 = state_66959;
(statearr_67002[(7)] = inst_66929);

return statearr_67002;
})();
if(cljs.core.truth_(roles)){
var statearr_67003_67044 = state_66959__$1;
(statearr_67003_67044[(1)] = (19));

} else {
var statearr_67004_67045 = state_66959__$1;
(statearr_67004_67045[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto____0 = (function (){
var statearr_67005 = [null,null,null,null,null,null,null,null,null,null];
(statearr_67005[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto__);

(statearr_67005[(1)] = (1));

return statearr_67005;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto____1 = (function (state_66959){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_66959);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e67006){var ex__2882__auto__ = e67006;
var statearr_67007_67046 = state_66959;
(statearr_67007_67046[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_66959[(4)]))){
var statearr_67008_67047 = state_66959;
(statearr_67008_67047[(1)] = cljs.core.first((state_66959[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67048 = state_66959;
state_66959 = G__67048;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto__ = function(state_66959){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto____1.call(this,state_66959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_67009 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_67009[(6)] = c__2901__auto__);

return statearr_67009;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__67049 = db;
var map__67049__$1 = (((((!((map__67049 == null))))?(((((map__67049.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67049.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__67049):map__67049);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67049__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67049__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67049__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_67057){
var state_val_67058 = (state_67057[(1)]);
if((state_val_67058 === (1))){
var inst_67051 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_67052 = fluree.db.session.db(conn,inst_67051,null);
var state_67057__$1 = state_67057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67057__$1,(2),inst_67052);
} else {
if((state_val_67058 === (2))){
var inst_67054 = (state_67057[(2)]);
var inst_67055 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_67054);
var state_67057__$1 = state_67057;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67057__$1,inst_67055);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____0 = (function (){
var statearr_67059 = [null,null,null,null,null,null,null];
(statearr_67059[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__);

(statearr_67059[(1)] = (1));

return statearr_67059;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____1 = (function (state_67057){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_67057);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e67060){var ex__2882__auto__ = e67060;
var statearr_67061_67088 = state_67057;
(statearr_67061_67088[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_67057[(4)]))){
var statearr_67062_67089 = state_67057;
(statearr_67062_67089[(1)] = cljs.core.first((state_67057[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67090 = state_67057;
state_67057 = G__67090;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__ = function(state_67057){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____1.call(this,state_67057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_67063 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_67063[(6)] = c__2901__auto__);

return statearr_67063;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_67076){
var state_val_67077 = (state_67076[(1)]);
if((state_val_67077 === (1))){
var inst_67064 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_67065 = fluree.db.session.db(conn,inst_67064,null);
var state_67076__$1 = state_67076;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67076__$1,(2),inst_67065);
} else {
if((state_val_67077 === (2))){
var inst_67067 = (state_67076[(7)]);
var inst_67067__$1 = (state_67076[(2)]);
var inst_67068 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_67067__$1);
var inst_67069 = newer_block_QMARK_(inst_67068);
var state_67076__$1 = (function (){var statearr_67078 = state_67076;
(statearr_67078[(7)] = inst_67067__$1);

return statearr_67078;
})();
if(inst_67069){
var statearr_67079_67091 = state_67076__$1;
(statearr_67079_67091[(1)] = (3));

} else {
var statearr_67080_67092 = state_67076__$1;
(statearr_67080_67092[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67077 === (3))){
var inst_67067 = (state_67076[(7)]);
var inst_67071 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_67067);
var state_67076__$1 = state_67076;
var statearr_67081_67093 = state_67076__$1;
(statearr_67081_67093[(2)] = inst_67071);

(statearr_67081_67093[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67077 === (4))){
var state_67076__$1 = state_67076;
var statearr_67082_67094 = state_67076__$1;
(statearr_67082_67094[(2)] = null);

(statearr_67082_67094[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67077 === (5))){
var inst_67074 = (state_67076[(2)]);
var state_67076__$1 = state_67076;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67076__$1,inst_67074);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____0 = (function (){
var statearr_67083 = [null,null,null,null,null,null,null,null];
(statearr_67083[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__);

(statearr_67083[(1)] = (1));

return statearr_67083;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____1 = (function (state_67076){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_67076);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e67084){var ex__2882__auto__ = e67084;
var statearr_67085_67095 = state_67076;
(statearr_67085_67095[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_67076[(4)]))){
var statearr_67086_67096 = state_67076;
(statearr_67086_67096[(1)] = cljs.core.first((state_67076[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67097 = state_67076;
state_67076 = G__67097;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__ = function(state_67076){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____1.call(this,state_67076);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_67087 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_67087[(6)] = c__2901__auto__);

return statearr_67087;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__67098 = db;
var map__67098__$1 = (((((!((map__67098 == null))))?(((((map__67098.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67098.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__67098):map__67098);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67098__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67098__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67098__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__4217__auto__ = syncTimeout;
var y__4218__auto__ = (120000);
return ((x__4217__auto__ < y__4218__auto__) ? x__4217__auto__ : y__4218__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2901__auto___67175 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_67149){
var state_val_67150 = (state_67149[(1)]);
if((state_val_67150 === (7))){
var inst_67115 = (state_67149[(7)]);
var inst_67126 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_67115,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_67149__$1 = state_67149;
if(inst_67126){
var statearr_67151_67176 = state_67149__$1;
(statearr_67151_67176[(1)] = (9));

} else {
var statearr_67152_67177 = state_67149__$1;
(statearr_67152_67177[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67150 === (1))){
var inst_67100 = (state_67149[(8)]);
var inst_67108 = (state_67149[(9)]);
var inst_67100__$1 = cljs.core.async.timeout(timeout);
var inst_67108__$1 = res_port;
var inst_67109 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67110 = [inst_67100__$1,inst_67108__$1];
var inst_67111 = (new cljs.core.PersistentVector(null,2,(5),inst_67109,inst_67110,null));
var state_67149__$1 = (function (){var statearr_67153 = state_67149;
(statearr_67153[(8)] = inst_67100__$1);

(statearr_67153[(9)] = inst_67108__$1);

return statearr_67153;
})();
return cljs.core.async.ioc_alts_BANG_(state_67149__$1,(2),inst_67111);
} else {
if((state_val_67150 === (4))){
var inst_67108 = (state_67149[(9)]);
var inst_67115 = (state_67149[(7)]);
var inst_67119 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_67115,inst_67108);
var state_67149__$1 = state_67149;
if(inst_67119){
var statearr_67154_67178 = state_67149__$1;
(statearr_67154_67178[(1)] = (6));

} else {
var statearr_67155_67179 = state_67149__$1;
(statearr_67155_67179[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67150 === (13))){
var inst_67134 = (state_67149[(10)]);
var inst_67145 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_67134);
var state_67149__$1 = state_67149;
var statearr_67156_67180 = state_67149__$1;
(statearr_67156_67180[(2)] = inst_67145);

(statearr_67156_67180[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67150 === (6))){
var inst_67113 = (state_67149[(11)]);
var inst_67124 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67113,(0),null);
var state_67149__$1 = state_67149;
var statearr_67157_67181 = state_67149__$1;
(statearr_67157_67181[(2)] = inst_67124);

(statearr_67157_67181[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67150 === (3))){
var state_67149__$1 = state_67149;
var statearr_67158_67182 = state_67149__$1;
(statearr_67158_67182[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_67158_67182[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67150 === (12))){
var inst_67138 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_67139 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_67140 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_67141 = cljs.core.PersistentHashMap.fromArrays(inst_67139,inst_67140);
var inst_67142 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_67138,inst_67141);
var inst_67143 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_67142);
var state_67149__$1 = state_67149;
var statearr_67159_67183 = state_67149__$1;
(statearr_67159_67183[(2)] = inst_67143);

(statearr_67159_67183[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67150 === (2))){
var inst_67113 = (state_67149[(11)]);
var inst_67100 = (state_67149[(8)]);
var inst_67115 = (state_67149[(7)]);
var inst_67113__$1 = (state_67149[(2)]);
var inst_67114 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67113__$1,(0),null);
var inst_67115__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67113__$1,(1),null);
var inst_67116 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_67115__$1,inst_67100);
var state_67149__$1 = (function (){var statearr_67160 = state_67149;
(statearr_67160[(11)] = inst_67113__$1);

(statearr_67160[(12)] = inst_67114);

(statearr_67160[(7)] = inst_67115__$1);

return statearr_67160;
})();
if(inst_67116){
var statearr_67161_67184 = state_67149__$1;
(statearr_67161_67184[(1)] = (3));

} else {
var statearr_67162_67185 = state_67149__$1;
(statearr_67162_67185[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67150 === (11))){
var inst_67130 = (state_67149[(2)]);
var state_67149__$1 = state_67149;
var statearr_67163_67186 = state_67149__$1;
(statearr_67163_67186[(2)] = inst_67130);

(statearr_67163_67186[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67150 === (9))){
var inst_67114 = (state_67149[(12)]);
var state_67149__$1 = state_67149;
var statearr_67164_67187 = state_67149__$1;
(statearr_67164_67187[(2)] = inst_67114);

(statearr_67164_67187[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67150 === (5))){
var inst_67134 = (state_67149[(10)]);
var inst_67134__$1 = (state_67149[(2)]);
var inst_67135 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_67136 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_67134__$1);
var state_67149__$1 = (function (){var statearr_67165 = state_67149;
(statearr_67165[(10)] = inst_67134__$1);

(statearr_67165[(13)] = inst_67135);

return statearr_67165;
})();
if(inst_67136){
var statearr_67166_67188 = state_67149__$1;
(statearr_67166_67188[(1)] = (12));

} else {
var statearr_67167_67189 = state_67149__$1;
(statearr_67167_67189[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67150 === (14))){
var inst_67147 = (state_67149[(2)]);
var state_67149__$1 = state_67149;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67149__$1,inst_67147);
} else {
if((state_val_67150 === (10))){
var state_67149__$1 = state_67149;
var statearr_67168_67190 = state_67149__$1;
(statearr_67168_67190[(2)] = null);

(statearr_67168_67190[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67150 === (8))){
var inst_67132 = (state_67149[(2)]);
var state_67149__$1 = state_67149;
var statearr_67169_67191 = state_67149__$1;
(statearr_67169_67191[(2)] = inst_67132);

(statearr_67169_67191[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto____0 = (function (){
var statearr_67170 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67170[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto__);

(statearr_67170[(1)] = (1));

return statearr_67170;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto____1 = (function (state_67149){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_67149);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e67171){var ex__2882__auto__ = e67171;
var statearr_67172_67192 = state_67149;
(statearr_67172_67192[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_67149[(4)]))){
var statearr_67173_67193 = state_67149;
(statearr_67173_67193[(1)] = cljs.core.first((state_67149[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67194 = state_67149;
state_67149 = G__67194;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto__ = function(state_67149){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto____1.call(this,state_67149);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_67174 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_67174[(6)] = c__2901__auto___67175);

return statearr_67174;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__67196 = arguments.length;
switch (G__67196) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__67197){
var map__67198 = p__67197;
var map__67198__$1 = (((((!((map__67198 == null))))?(((((map__67198.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__67198.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__67198):map__67198);
var opts = map__67198__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67198__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67198__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67198__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67198__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67198__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2901__auto___67288 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_67250){
var state_val_67251 = (state_67250[(1)]);
if((state_val_67251 === (7))){
var inst_67212 = (state_67250[(7)]);
var inst_67214 = fluree.db.api.ledger.syncTo_db(inst_67212,syncTo,syncTimeout);
var state_67250__$1 = state_67250;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67250__$1,(10),inst_67214);
} else {
if((state_val_67251 === (20))){
var inst_67236 = (state_67250[(8)]);
var state_67250__$1 = state_67250;
var statearr_67252_67289 = state_67250__$1;
(statearr_67252_67289[(2)] = inst_67236);

(statearr_67252_67289[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67251 === (1))){
var state_67250__$1 = state_67250;
var statearr_67253_67290 = state_67250__$1;
(statearr_67253_67290[(2)] = null);

(statearr_67253_67290[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67251 === (4))){
var inst_67200 = (state_67250[(2)]);
var inst_67201 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_67200);
var inst_67202 = cljs.core.async.close_BANG_(pc);
var state_67250__$1 = (function (){var statearr_67254 = state_67250;
(statearr_67254[(9)] = inst_67201);

return statearr_67254;
})();
var statearr_67255_67291 = state_67250__$1;
(statearr_67255_67291[(2)] = inst_67202);

(statearr_67255_67291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67251 === (15))){
var inst_67228 = (state_67250[(10)]);
var inst_67230 = fluree.db.api.ledger.add_db_permissions(inst_67228,auth,roles);
var state_67250__$1 = state_67250;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67250__$1,(18),inst_67230);
} else {
if((state_val_67251 === (21))){
var inst_67244 = (state_67250[(2)]);
var inst_67245 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_67244);
var _ = (function (){var statearr_67256 = state_67250;
(statearr_67256[(4)] = cljs.core.rest((state_67250[(4)])));

return statearr_67256;
})();
var state_67250__$1 = state_67250;
var statearr_67257_67292 = state_67250__$1;
(statearr_67257_67292[(2)] = inst_67245);

(statearr_67257_67292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67251 === (13))){
var inst_67228 = (state_67250[(2)]);
var state_67250__$1 = (function (){var statearr_67258 = state_67250;
(statearr_67258[(10)] = inst_67228);

return statearr_67258;
})();
if(cljs.core.truth_(roles)){
var statearr_67259_67293 = state_67250__$1;
(statearr_67259_67293[(1)] = (15));

} else {
var statearr_67260_67294 = state_67250__$1;
(statearr_67260_67294[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67251 === (22))){
var inst_67240 = (state_67250[(2)]);
var inst_67241 = fluree.db.util.async.throw_err(inst_67240);
var state_67250__$1 = state_67250;
var statearr_67261_67295 = state_67250__$1;
(statearr_67261_67295[(2)] = inst_67241);

(statearr_67261_67295[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67251 === (6))){
var inst_67211 = (state_67250[(2)]);
var inst_67212 = fluree.db.util.async.throw_err(inst_67211);
var state_67250__$1 = (function (){var statearr_67262 = state_67250;
(statearr_67262[(7)] = inst_67212);

return statearr_67262;
})();
if(cljs.core.truth_(syncTo)){
var statearr_67263_67296 = state_67250__$1;
(statearr_67263_67296[(1)] = (7));

} else {
var statearr_67264_67297 = state_67250__$1;
(statearr_67264_67297[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67251 === (17))){
var inst_67236 = (state_67250[(2)]);
var state_67250__$1 = (function (){var statearr_67265 = state_67250;
(statearr_67265[(8)] = inst_67236);

return statearr_67265;
})();
if(cljs.core.truth_(auth)){
var statearr_67266_67298 = state_67250__$1;
(statearr_67266_67298[(1)] = (19));

} else {
var statearr_67267_67299 = state_67250__$1;
(statearr_67267_67299[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67251 === (3))){
var inst_67248 = (state_67250[(2)]);
var state_67250__$1 = state_67250;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67250__$1,inst_67248);
} else {
if((state_val_67251 === (12))){
var inst_67220 = (state_67250[(11)]);
var state_67250__$1 = state_67250;
var statearr_67268_67300 = state_67250__$1;
(statearr_67268_67300[(2)] = inst_67220);

(statearr_67268_67300[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67251 === (2))){
var _ = (function (){var statearr_67269 = state_67250;
(statearr_67269[(4)] = cljs.core.cons((5),(state_67250[(4)])));

return statearr_67269;
})();
var inst_67209 = fluree.db.session.db(conn,ledger,null);
var state_67250__$1 = state_67250;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67250__$1,(6),inst_67209);
} else {
if((state_val_67251 === (19))){
var inst_67236 = (state_67250[(8)]);
var inst_67238 = fluree.db.api.ledger.add_db_permissions(inst_67236,auth,roles);
var state_67250__$1 = state_67250;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67250__$1,(22),inst_67238);
} else {
if((state_val_67251 === (11))){
var inst_67220 = (state_67250[(11)]);
var inst_67222 = fluree.db.time_travel.as_of_block(inst_67220,block);
var state_67250__$1 = state_67250;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67250__$1,(14),inst_67222);
} else {
if((state_val_67251 === (9))){
var inst_67220 = (state_67250[(2)]);
var state_67250__$1 = (function (){var statearr_67271 = state_67250;
(statearr_67271[(11)] = inst_67220);

return statearr_67271;
})();
if(cljs.core.truth_(block)){
var statearr_67272_67301 = state_67250__$1;
(statearr_67272_67301[(1)] = (11));

} else {
var statearr_67273_67302 = state_67250__$1;
(statearr_67273_67302[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67251 === (5))){
var _ = (function (){var statearr_67274 = state_67250;
(statearr_67274[(4)] = cljs.core.rest((state_67250[(4)])));

return statearr_67274;
})();
var state_67250__$1 = state_67250;
var ex67270 = (state_67250__$1[(2)]);
var statearr_67275_67303 = state_67250__$1;
(statearr_67275_67303[(5)] = ex67270);


var statearr_67276_67304 = state_67250__$1;
(statearr_67276_67304[(1)] = (4));

(statearr_67276_67304[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67251 === (14))){
var inst_67224 = (state_67250[(2)]);
var inst_67225 = fluree.db.util.async.throw_err(inst_67224);
var state_67250__$1 = state_67250;
var statearr_67277_67305 = state_67250__$1;
(statearr_67277_67305[(2)] = inst_67225);

(statearr_67277_67305[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67251 === (16))){
var inst_67228 = (state_67250[(10)]);
var state_67250__$1 = state_67250;
var statearr_67278_67306 = state_67250__$1;
(statearr_67278_67306[(2)] = inst_67228);

(statearr_67278_67306[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67251 === (10))){
var inst_67216 = (state_67250[(2)]);
var inst_67217 = fluree.db.util.async.throw_err(inst_67216);
var state_67250__$1 = state_67250;
var statearr_67279_67307 = state_67250__$1;
(statearr_67279_67307[(2)] = inst_67217);

(statearr_67279_67307[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67251 === (18))){
var inst_67232 = (state_67250[(2)]);
var inst_67233 = fluree.db.util.async.throw_err(inst_67232);
var state_67250__$1 = state_67250;
var statearr_67280_67308 = state_67250__$1;
(statearr_67280_67308[(2)] = inst_67233);

(statearr_67280_67308[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_67251 === (8))){
var inst_67212 = (state_67250[(7)]);
var state_67250__$1 = state_67250;
var statearr_67281_67309 = state_67250__$1;
(statearr_67281_67309[(2)] = inst_67212);

(statearr_67281_67309[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2879__auto__ = null;
var fluree$db$api$ledger$state_machine__2879__auto____0 = (function (){
var statearr_67282 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67282[(0)] = fluree$db$api$ledger$state_machine__2879__auto__);

(statearr_67282[(1)] = (1));

return statearr_67282;
});
var fluree$db$api$ledger$state_machine__2879__auto____1 = (function (state_67250){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_67250);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e67283){var ex__2882__auto__ = e67283;
var statearr_67284_67310 = state_67250;
(statearr_67284_67310[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_67250[(4)]))){
var statearr_67285_67311 = state_67250;
(statearr_67285_67311[(1)] = cljs.core.first((state_67250[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__67312 = state_67250;
state_67250 = G__67312;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2879__auto__ = function(state_67250){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2879__auto____1.call(this,state_67250);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2879__auto____0;
fluree$db$api$ledger$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2879__auto____1;
return fluree$db$api$ledger$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_67286 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_67286[(6)] = c__2901__auto___67288);

return statearr_67286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

