// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.util.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('cljs.js');
fluree.db.util.core.max_long = ((9007199254740991) - (1));
fluree.db.util.core.min_long = (- fluree.db.util.core.max_long);
fluree.db.util.core.max_integer = (2147483647);
fluree.db.util.core.min_integer = (- (2147483647));
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
fluree.db.util.core.cljs_env_QMARK_ = (function fluree$db$util$core$cljs_env_QMARK_(env){
return cljs.core.boolean$(new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(env));
});
var ret__4785__auto___3106 = /**
 * Return then if we are generating cljs code and else for Clojure code.
 * https://groups.google.com/d/msg/clojurescript/iBY5HaQda4A/w1lAQi9_AwsJ
 */
fluree.db.util.core.if_cljs = (function fluree$db$util$core$if_cljs(_AMPERSAND_form,_AMPERSAND_env,then,else$){
if(fluree.db.util.core.cljs_env_QMARK_(_AMPERSAND_env)){
return then;
} else {
return else$;
}
});
(fluree.db.util.core.if_cljs.cljs$lang$macro = true);

var ret__4785__auto___3113 = (function (){
/**
 * A cross-platform variant of try-catch that catches all exceptions.
 * Does not (yet) support finally, and does not need or want an exception class.
 */
fluree.db.util.core.try_catchall = (function fluree$db$util$core$try_catchall(var_args){
var args__4742__auto__ = [];
var len__4736__auto___3114 = arguments.length;
var i__4737__auto___3115 = (0);
while(true){
if((i__4737__auto___3115 < len__4736__auto___3114)){
args__4742__auto__.push((arguments[i__4737__auto___3115]));

var G__3116 = (i__4737__auto___3115 + (1));
i__4737__auto___3115 = G__3116;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.util.core.try_catchall.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.util.core.try_catchall.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
var try_body = cljs.core.butlast(body);
var vec__3110 = cljs.core.last(body);
var seq__3111 = cljs.core.seq(vec__3110);
var first__3112 = cljs.core.first(seq__3111);
var seq__3111__$1 = cljs.core.next(seq__3111);
var catch$ = first__3112;
var first__3112__$1 = cljs.core.first(seq__3111__$1);
var seq__3111__$2 = cljs.core.next(seq__3111__$1);
var sym = first__3112__$1;
var catch_body = seq__3111__$2;
var catch_form = vec__3110;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(catch$,new cljs.core.Symbol(null,"catch","catch",-1616370245,null))){
} else {
throw (new Error("Assert failed: (= catch (quote catch))"));
}

if((sym instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? sym)"));
}

return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.core","if-cljs","fluree.db.util.core/if-cljs",-432169600,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"try","try",-1273693247,null),null,(1),null)),try_body,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"catch","catch",-1616370245,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("js","Object","js/Object",61215323,null),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,sym,null,(1),null)),catch_body], 0)))),null,(1),null))], 0)))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"try","try",-1273693247,null),null,(1),null)),try_body,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"catch","catch",-1616370245,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.core","Throwable","fluree.db.util.core/Throwable",853138167,null),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,sym,null,(1),null)),catch_body], 0)))),null,(1),null))], 0)))),null,(1),null))], 0))));
}));

(fluree.db.util.core.try_catchall.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.util.core.try_catchall.cljs$lang$applyTo = (function (seq3107){
var G__3108 = cljs.core.first(seq3107);
var seq3107__$1 = cljs.core.next(seq3107);
var G__3109 = cljs.core.first(seq3107__$1);
var seq3107__$2 = cljs.core.next(seq3107__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3108,G__3109,seq3107__$2);
}));

return null;
})()
;
(fluree.db.util.core.try_catchall.cljs$lang$macro = true);

var ret__4785__auto___3120 = (function (){
/**
 * Like try but supports catch*. catch* is like catch but supports CLJ/CLJS with
 *   less boilerplate. In CLJ it catches `Exception`. In CLJS it catches `:default`.
 *   Use it like this: `(try* ... (catch* err (handle-err err)))`.
 *   Also supports an optional finally clause.
 */
fluree.db.util.core.try_STAR_ = (function fluree$db$util$core$try_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___3121 = arguments.length;
var i__4737__auto___3122 = (0);
while(true){
if((i__4737__auto___3122 < len__4736__auto___3121)){
args__4742__auto__.push((arguments[i__4737__auto___3122]));

var G__3123 = (i__4737__auto___3122 + (1));
i__4737__auto___3122 = G__3123;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.util.core.try_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.util.core.try_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.core","if-cljs","fluree.db.util.core/if-cljs",-432169600,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("cljs-exceptions","try*","cljs-exceptions/try*",-1080387872,null),null,(1),null)),body))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("clj-exceptions","try*","clj-exceptions/try*",1421445009,null),null,(1),null)),body))),null,(1),null))], 0))));
}));

(fluree.db.util.core.try_STAR_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.util.core.try_STAR_.cljs$lang$applyTo = (function (seq3117){
var G__3118 = cljs.core.first(seq3117);
var seq3117__$1 = cljs.core.next(seq3117);
var G__3119 = cljs.core.first(seq3117__$1);
var seq3117__$2 = cljs.core.next(seq3117__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3118,G__3119,seq3117__$2);
}));

return null;
})()
;
(fluree.db.util.core.try_STAR_.cljs$lang$macro = true);

fluree.db.util.core.index_of = (function fluree$db$util$core$index_of(coll,value){
return cljs.core.some((function (p__3124){
var vec__3125 = p__3124;
var item = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3125,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3125,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,item)){
return idx;
} else {
return null;
}
}),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(coll,cljs.core.iterate(cljs.core.inc,(0)))));
});
fluree.db.util.core.random_uuid = (function fluree$db$util$core$random_uuid(){

return cljs.core.random_uuid();
});
/**
 * Given a date, returns epoch millis if possible.
 */
fluree.db.util.core.date__GT_millis = (function fluree$db$util$core$date__GT_millis(date){
if(typeof date === 'string'){
return Date.parse(date).getTime();
} else {
if(typeof date === 'number'){
return date;
} else {
if((date instanceof Date)){
return date.getTime();
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid date: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([date], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-date","db/invalid-date",2030527951)], null));

}
}
}
});
/**
 * Returns current time in epoch milliseonds for closure/script
 */
fluree.db.util.core.current_time_millis = (function fluree$db$util$core$current_time_millis(){
return (new Date()).getTime();
});
fluree.db.util.core.deep_merge = (function fluree$db$util$core$deep_merge(var_args){
var args__4742__auto__ = [];
var len__4736__auto___3132 = arguments.length;
var i__4737__auto___3133 = (0);
while(true){
if((i__4737__auto___3133 < len__4736__auto___3132)){
args__4742__auto__.push((arguments[i__4737__auto___3133]));

var G__3134 = (i__4737__auto___3133 + (1));
i__4737__auto___3133 = G__3134;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.util.core.deep_merge.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.util.core.deep_merge.cljs$core$IFn$_invoke$arity$variadic = (function (v,vs){
var rec_merge = (function fluree$db$util$core$rec_merge(v1,v2){
if(((cljs.core.map_QMARK_(v1)) && (cljs.core.map_QMARK_(v2)))){
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(fluree.db.util.core.deep_merge,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([v1,v2], 0));
} else {
return v2;
}
});
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,vs))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__3128_SHARP_,p2__3129_SHARP_){
return rec_merge(p1__3128_SHARP_,p2__3129_SHARP_);
}),v,vs);
} else {
return v;
}
}));

(fluree.db.util.core.deep_merge.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.util.core.deep_merge.cljs$lang$applyTo = (function (seq3130){
var G__3131 = cljs.core.first(seq3130);
var seq3130__$1 = cljs.core.next(seq3130);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3131,seq3130__$1);
}));

fluree.db.util.core.email_QMARK_ = (function fluree$db$util$core$email_QMARK_(email){
return cljs.core.re_matches(/^[\w-\+]+(\.[\w]+)*@[\w-]+(\.[\w]+)*(\.[a-z]{2,})$/,email);
});
/**
 * Tests if an predicate identity two-tuple
 *   in form of [pred-name-or-id pred-value]
 */
fluree.db.util.core.pred_ident_QMARK_ = (function fluree$db$util$core$pred_ident_QMARK_(x){
return ((cljs.core.sequential_QMARK_(x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),cljs.core.count(x))) && (typeof cljs.core.first(x) === 'string'));
});
fluree.db.util.core.temp_ident_QMARK_ = (function fluree$db$util$core$temp_ident_QMARK_(x){
return typeof x === 'string';
});
/**
 * Tests if an _id is a numeric or predicate-ident
 */
fluree.db.util.core.subj_ident_QMARK_ = (function fluree$db$util$core$subj_ident_QMARK_(x){
return ((cljs.core.int_QMARK_(x)) || (fluree.db.util.core.pred_ident_QMARK_(x)));
});
/**
 * Converts string to integer. Assumes you've already verified the string is
 *   parsable to an integer.
 */
fluree.db.util.core.str__GT_int = (function fluree$db$util$core$str__GT_int(s){
return parseInt(s);
});
/**
 * Converts a keyword to string. Can safely be called on a
 *   string which will return itself.
 */
fluree.db.util.core.keyword__GT_str = (function fluree$db$util$core$keyword__GT_str(k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(k),(1));
} else {
if(typeof k === 'string'){
return k;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot convert type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(k))," to string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));

}
}
});
/**
 * Converts a string to a keyword, checking to see if
 *   the string starts with a ':', which it strips before converting.
 */
fluree.db.util.core.str__GT_keyword = (function fluree$db$util$core$str__GT_keyword(s){
if(typeof s === 'string'){
if(clojure.string.starts_with_QMARK_(s,":")){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(1)));
} else {
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(s);
}
} else {
if((s instanceof cljs.core.Keyword)){
return s;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot convert type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(s))," to keyword: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));

}
}
});
/**
 * Takes time as a string and returns an java.time.Instant.
 */
fluree.db.util.core.str__GT_epoch_ms = (function fluree$db$util$core$str__GT_epoch_ms(time_str){
try{return Date.parse(time_str);
}catch (e3135){var _ = e3135;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid time string. Ensure format is ISO-8601 compatible. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([time_str], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-time","db/invalid-time",-1496866235)], null));
}});
/**
 * Truncate string s to n characters.
 */
fluree.db.util.core.trunc = (function fluree$db$util$core$trunc(s,n){
if((cljs.core.count(s) < n)){
return s;
} else {
return [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),n)," ..."].join('');
}
});
var ret__4785__auto___3143 = (function (){
fluree.db.util.core.some_of = (function fluree$db$util$core$some_of(var_args){
var G__3142 = arguments.length;
switch (G__3142) {
case 2:
return fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___3145 = arguments.length;
var i__4737__auto___3146 = (0);
while(true){
if((i__4737__auto___3146 < len__4736__auto___3145)){
args_arr__4757__auto__.push((arguments[i__4737__auto___3146]));

var G__3147 = (i__4737__auto___3146 + (1));
i__4737__auto___3146 = G__3147;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((3)),(0),null));
return fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4758__auto__);

}
});

(fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return null;
}));

(fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
}));

(fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,more){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","let","cljs.core/let",-308701135,null),null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol(null,"x__3136__auto__","x__3136__auto__",-1293622297,null),null,(1),null)),(new cljs.core.List(null,x,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("cljs.core","nil?","cljs.core/nil?",945071861,null),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"x__3136__auto__","x__3136__auto__",-1293622297,null),null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.core","some-of","fluree.db.util.core/some-of",1946305325,null),null,(1),null)),more))),null,(1),null)),(new cljs.core.List(null,new cljs.core.Symbol(null,"x__3136__auto__","x__3136__auto__",-1293622297,null),null,(1),null))], 0)))),null,(1),null))], 0))));
}));

/** @this {Function} */
(fluree.db.util.core.some_of.cljs$lang$applyTo = (function (seq3138){
var G__3139 = cljs.core.first(seq3138);
var seq3138__$1 = cljs.core.next(seq3138);
var G__3140 = cljs.core.first(seq3138__$1);
var seq3138__$2 = cljs.core.next(seq3138__$1);
var G__3141 = cljs.core.first(seq3138__$2);
var seq3138__$3 = cljs.core.next(seq3138__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3139,G__3140,G__3141,seq3138__$3);
}));

(fluree.db.util.core.some_of.cljs$lang$maxFixedArity = (3));

return null;
})()
;
(fluree.db.util.core.some_of.cljs$lang$macro = true);

/**
 * Filters map k/v pairs dropping any where predicate applied to value is false.
 */
fluree.db.util.core.filter_vals = (function fluree$db$util$core$filter_vals(pred,m){
return cljs.core.reduce_kv((function (m__$1,k,v){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(v) : pred.call(null,v)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m__$1,k,v);
} else {
return m__$1;
}
}),cljs.core.PersistentArrayMap.EMPTY,m);
});
/**
 * Remove all keys from a map that have nil or empty collection values.
 */
fluree.db.util.core.without_nils = (function fluree$db$util$core$without_nils(m){
return fluree.db.util.core.filter_vals((function (p1__3148_SHARP_){
if(cljs.core.coll_QMARK_(p1__3148_SHARP_)){
return cljs.core.not_empty(p1__3148_SHARP_);
} else {
return (!((p1__3148_SHARP_ == null)));
}
}),m);
});
/**
 * Like range, but includes start/end values.
 */
fluree.db.util.core.inclusive_range = (function fluree$db$util$core$inclusive_range(var_args){
var G__3150 = arguments.length;
switch (G__3150) {
case 0:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.range.cljs$core$IFn$_invoke$arity$0();
}));

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$1 = (function (end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$1((end + (1)));
}));

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2(start,(end + (1)));
}));

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3(start,(end + step),step);
}));

(fluree.db.util.core.inclusive_range.cljs$lang$maxFixedArity = 3);

/**
 * x-platform, returns true if is an execption
 */
fluree.db.util.core.exception_QMARK_ = (function fluree$db$util$core$exception_QMARK_(x){
return (x instanceof Error);
});
fluree.db.util.core.url_encode = (function fluree$db$util$core$url_encode(string){
var G__3152 = string;
var G__3152__$1 = (((G__3152 == null))?null:cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__3152));
var G__3152__$2 = (((G__3152__$1 == null))?null:encodeURIComponent(G__3152__$1));
if((G__3152__$2 == null)){
return null;
} else {
return G__3152__$2.replace("+","%20");
}
});
fluree.db.util.core.url_decode = (function fluree$db$util$core$url_decode(var_args){
var G__3154 = arguments.length;
switch (G__3154) {
case 1:
return fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$1 = (function (string){
return fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$2(string,"UTF-8");
}));

(fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$2 = (function (string,encoding){
var G__3155 = string;
var G__3155__$1 = (((G__3155 == null))?null:cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__3155));
if((G__3155__$1 == null)){
return null;
} else {
return decodeURIComponent(G__3155__$1);
}
}));

(fluree.db.util.core.url_decode.cljs$lang$maxFixedArity = 2);

fluree.db.util.core.map_invert = (function fluree$db$util$core$map_invert(m){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m__$1,p__3157){
var vec__3158 = p__3157;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3158,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3158,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m__$1,v,k);
}),cljs.core.PersistentArrayMap.EMPTY,m);
});
/**
 * Zero pads x
 */
fluree.db.util.core.zero_pad = (function fluree$db$util$core$zero_pad(x,pad){
var s = cljs.core.str.cljs$core$IFn$_invoke$arity$1(x);
while(true){
if((s.length < pad)){
var G__3161 = ["0",s].join('');
s = G__3161;
continue;
} else {
return s;
}
break;
}
});
