// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.call(null,cljs.core.mapcat.call(null,(function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.call(null,clojure.string.replace.call(null,cljs.core.name.call(null,lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.call(null,ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv.call(null,(function (xs,ns,_){
if(cljs.core._EQ_.call(null,needle,cljs.compiler.get_first_ns_segment.call(null,ns))){
return cljs.core.reduced.call(null,needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__5902 = s;
var map__5902__$1 = (((((!((map__5902 == null))))?(((((map__5902.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5902.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5902):map__5902);
var name = cljs.core.get.call(null,map__5902__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__5902__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__5905 = info;
var map__5906 = G__5905;
var map__5906__$1 = (((((!((map__5906 == null))))?(((((map__5906.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5906.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5906):map__5906);
var shadow = cljs.core.get.call(null,map__5906__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__5905__$1 = G__5905;
while(true){
var d__$2 = d__$1;
var map__5910 = G__5905__$1;
var map__5910__$1 = (((((!((map__5910 == null))))?(((((map__5910.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5910.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5910):map__5910);
var shadow__$1 = cljs.core.get.call(null,map__5910__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__5912 = (d__$2 + (1));
var G__5913 = shadow__$1;
d__$1 = G__5912;
G__5905__$1 = G__5913;
continue;
} else {
if(cljs.core.truth_(cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine.call(null,cljs.core._hash.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s)),cljs.compiler.shadow_depth.call(null,s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__5914){
var map__5915 = p__5914;
var map__5915__$1 = (((((!((map__5915 == null))))?(((((map__5915.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5915.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5915):map__5915);
var name_var = map__5915__$1;
var name = cljs.core.get.call(null,map__5915__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.call(null,map__5915__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__5917 = info;
var map__5917__$1 = (((((!((map__5917 == null))))?(((((map__5917.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5917.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5917):map__5917);
var ns = cljs.core.get.call(null,map__5917__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.call(null,map__5917__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.call(null,cljs.core.str,cljs.core.interpose.call(null,"_$_",cljs.core.concat.call(null,cljs.core.map.call(null,cljs.core.comp.call(null,cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.call(null,cljs.compiler.munge.call(null,[clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('')));
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.call(null,reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__5920 = arguments.length;
switch (G__5920) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.call(null,s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_.call(null,s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name.call(null,s);
} else {
var depth = cljs.compiler.shadow_depth.call(null,s);
var code = cljs.compiler.hash_scope.call(null,s);
var renamed = cljs.core.get.call(null,cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.call(null,name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace.call(null,ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved.call(null,reserved);
var ss__$2 = cljs.core.map.call(null,rf,clojure.string.split.call(null,ss__$1,/\./));
var ss__$3 = clojure.string.join.call(null,".",ss__$2);
var ms = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",25,1,11501,11501,new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)])).call(null,ss__$3);
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.call(null,ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.call(null,",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__5922 = cp;
switch (G__5922) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.call(null,"0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__5924_5928 = cljs.core.seq.call(null,s);
var chunk__5925_5929 = null;
var count__5926_5930 = (0);
var i__5927_5931 = (0);
while(true){
if((i__5927_5931 < count__5926_5930)){
var c_5932 = cljs.core._nth.call(null,chunk__5925_5929,i__5927_5931);
sb.append(cljs.compiler.escape_char.call(null,c_5932));


var G__5933 = seq__5924_5928;
var G__5934 = chunk__5925_5929;
var G__5935 = count__5926_5930;
var G__5936 = (i__5927_5931 + (1));
seq__5924_5928 = G__5933;
chunk__5925_5929 = G__5934;
count__5926_5930 = G__5935;
i__5927_5931 = G__5936;
continue;
} else {
var temp__5735__auto___5937 = cljs.core.seq.call(null,seq__5924_5928);
if(temp__5735__auto___5937){
var seq__5924_5938__$1 = temp__5735__auto___5937;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5924_5938__$1)){
var c__4556__auto___5939 = cljs.core.chunk_first.call(null,seq__5924_5938__$1);
var G__5940 = cljs.core.chunk_rest.call(null,seq__5924_5938__$1);
var G__5941 = c__4556__auto___5939;
var G__5942 = cljs.core.count.call(null,c__4556__auto___5939);
var G__5943 = (0);
seq__5924_5928 = G__5940;
chunk__5925_5929 = G__5941;
count__5926_5930 = G__5942;
i__5927_5931 = G__5943;
continue;
} else {
var c_5944 = cljs.core.first.call(null,seq__5924_5938__$1);
sb.append(cljs.compiler.escape_char.call(null,c_5944));


var G__5945 = cljs.core.next.call(null,seq__5924_5938__$1);
var G__5946 = null;
var G__5947 = (0);
var G__5948 = (0);
seq__5924_5928 = G__5945;
chunk__5925_5929 = G__5946;
count__5926_5930 = G__5947;
i__5927_5931 = G__5948;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__5949_5954 = ast;
var map__5949_5955__$1 = (((((!((map__5949_5954 == null))))?(((((map__5949_5954.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5949_5954.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5949_5954):map__5949_5954);
var env_5956 = cljs.core.get.call(null,map__5949_5955__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_5956))){
var map__5951_5957 = env_5956;
var map__5951_5958__$1 = (((((!((map__5951_5957 == null))))?(((((map__5951_5957.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5951_5957.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5951_5957):map__5951_5957);
var line_5959 = cljs.core.get.call(null,map__5951_5958__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_5960 = cljs.core.get.call(null,map__5951_5958__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__5953 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast)))){
return cljs.core.assoc.call(null,G__5953,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__5953;
}
})();
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_5959 - (1))], null),cljs.core.fnil.call(null,(function (line__$1){
return cljs.core.update_in.call(null,line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_5960)?(column_5960 - (1)):(0))], null),cljs.core.fnil.call(null,(function (column__$1){
return cljs.core.conj.call(null,column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}));
} else {
}
} else {
}

return cljs.compiler.emit_STAR_.call(null,ast);
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__5969 = arguments.length;
switch (G__5969) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___5976 = arguments.length;
var i__4737__auto___5977 = (0);
while(true){
if((i__4737__auto___5977 < len__4736__auto___5976)){
args_arr__4757__auto__.push((arguments[i__4737__auto___5977]));

var G__5978 = (i__4737__auto___5977 + (1));
i__4737__auto___5977 = G__5978;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4758__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_.call(null,a)){
cljs.compiler.emit.call(null,a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_.call(null,a)){
cljs.core.apply.call(null,cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
a.call(null);
} else {
var s_5979 = (function (){var G__5970 = a;
if((!(typeof a === 'string'))){
return G__5970.toString();
} else {
return G__5970;
}
})();
var temp__5739__auto___5980 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___5980 == null)){
} else {
var sm_data_5981 = temp__5739__auto___5980;
cljs.core.swap_BANG_.call(null,sm_data_5981,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__5961_SHARP_){
return (p1__5961_SHARP_ + s_5979.length);
}));
}

cljs.core.print.call(null,s_5979);

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

return cljs.compiler.emits.call(null,b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler.emits.call(null,c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler.emits.call(null,d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler.emits.call(null,e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__5971 = cljs.core.seq.call(null,xs);
var chunk__5972 = null;
var count__5973 = (0);
var i__5974 = (0);
while(true){
if((i__5974 < count__5973)){
var x = cljs.core._nth.call(null,chunk__5972,i__5974);
cljs.compiler.emits.call(null,x);


var G__5982 = seq__5971;
var G__5983 = chunk__5972;
var G__5984 = count__5973;
var G__5985 = (i__5974 + (1));
seq__5971 = G__5982;
chunk__5972 = G__5983;
count__5973 = G__5984;
i__5974 = G__5985;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__5971);
if(temp__5735__auto__){
var seq__5971__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5971__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__5971__$1);
var G__5986 = cljs.core.chunk_rest.call(null,seq__5971__$1);
var G__5987 = c__4556__auto__;
var G__5988 = cljs.core.count.call(null,c__4556__auto__);
var G__5989 = (0);
seq__5971 = G__5986;
chunk__5972 = G__5987;
count__5973 = G__5988;
i__5974 = G__5989;
continue;
} else {
var x = cljs.core.first.call(null,seq__5971__$1);
cljs.compiler.emits.call(null,x);


var G__5990 = cljs.core.next.call(null,seq__5971__$1);
var G__5991 = null;
var G__5992 = (0);
var G__5993 = (0);
seq__5971 = G__5990;
chunk__5972 = G__5991;
count__5973 = G__5992;
i__5974 = G__5993;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq5963){
var G__5964 = cljs.core.first.call(null,seq5963);
var seq5963__$1 = cljs.core.next.call(null,seq5963);
var G__5965 = cljs.core.first.call(null,seq5963__$1);
var seq5963__$2 = cljs.core.next.call(null,seq5963__$1);
var G__5966 = cljs.core.first.call(null,seq5963__$2);
var seq5963__$3 = cljs.core.next.call(null,seq5963__$2);
var G__5967 = cljs.core.first.call(null,seq5963__$3);
var seq5963__$4 = cljs.core.next.call(null,seq5963__$3);
var G__5968 = cljs.core.first.call(null,seq5963__$4);
var seq5963__$5 = cljs.core.next.call(null,seq5963__$4);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5964,G__5965,G__5966,G__5967,G__5968,seq5963__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.call(null);

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.call(null,cljs.compiler._STAR_source_map_data_STAR_,(function (p__5994){
var map__5995 = p__5994;
var map__5995__$1 = (((((!((map__5995 == null))))?(((((map__5995.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5995.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5995):map__5995);
var m = map__5995__$1;
var gen_line = cljs.core.get.call(null,map__5995__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__6004 = arguments.length;
switch (G__6004) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___6010 = arguments.length;
var i__4737__auto___6011 = (0);
while(true){
if((i__4737__auto___6011 < len__4736__auto___6010)){
args_arr__4757__auto__.push((arguments[i__4737__auto___6011]));

var G__6012 = (i__4737__auto___6011 + (1));
i__4737__auto___6011 = G__6012;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4758__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.call(null,a);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

return cljs.compiler._emitln.call(null);
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.call(null,a);

cljs.compiler.emits.call(null,b);

cljs.compiler.emits.call(null,c);

cljs.compiler.emits.call(null,d);

cljs.compiler.emits.call(null,e);

var seq__6005_6013 = cljs.core.seq.call(null,xs);
var chunk__6006_6014 = null;
var count__6007_6015 = (0);
var i__6008_6016 = (0);
while(true){
if((i__6008_6016 < count__6007_6015)){
var x_6017 = cljs.core._nth.call(null,chunk__6006_6014,i__6008_6016);
cljs.compiler.emits.call(null,x_6017);


var G__6018 = seq__6005_6013;
var G__6019 = chunk__6006_6014;
var G__6020 = count__6007_6015;
var G__6021 = (i__6008_6016 + (1));
seq__6005_6013 = G__6018;
chunk__6006_6014 = G__6019;
count__6007_6015 = G__6020;
i__6008_6016 = G__6021;
continue;
} else {
var temp__5735__auto___6022 = cljs.core.seq.call(null,seq__6005_6013);
if(temp__5735__auto___6022){
var seq__6005_6023__$1 = temp__5735__auto___6022;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6005_6023__$1)){
var c__4556__auto___6024 = cljs.core.chunk_first.call(null,seq__6005_6023__$1);
var G__6025 = cljs.core.chunk_rest.call(null,seq__6005_6023__$1);
var G__6026 = c__4556__auto___6024;
var G__6027 = cljs.core.count.call(null,c__4556__auto___6024);
var G__6028 = (0);
seq__6005_6013 = G__6025;
chunk__6006_6014 = G__6026;
count__6007_6015 = G__6027;
i__6008_6016 = G__6028;
continue;
} else {
var x_6029 = cljs.core.first.call(null,seq__6005_6023__$1);
cljs.compiler.emits.call(null,x_6029);


var G__6030 = cljs.core.next.call(null,seq__6005_6023__$1);
var G__6031 = null;
var G__6032 = (0);
var G__6033 = (0);
seq__6005_6013 = G__6030;
chunk__6006_6014 = G__6031;
count__6007_6015 = G__6032;
i__6008_6016 = G__6033;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln.call(null);
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq5998){
var G__5999 = cljs.core.first.call(null,seq5998);
var seq5998__$1 = cljs.core.next.call(null,seq5998);
var G__6000 = cljs.core.first.call(null,seq5998__$1);
var seq5998__$2 = cljs.core.next.call(null,seq5998__$1);
var G__6001 = cljs.core.first.call(null,seq5998__$2);
var seq5998__$3 = cljs.core.next.call(null,seq5998__$2);
var G__6002 = cljs.core.first.call(null,seq5998__$3);
var seq5998__$4 = cljs.core.next.call(null,seq5998__$3);
var G__6003 = cljs.core.first.call(null,seq5998__$4);
var seq5998__$5 = cljs.core.next.call(null,seq5998__$4);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5999,G__6000,G__6001,G__6002,G__6003,seq5998__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4667__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__6034_6038 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__6035_6039 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__6036_6040 = true;
var _STAR_print_fn_STAR__temp_val__6037_6041 = (function (x__4668__auto__){
return sb__4667__auto__.append(x__4668__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__6036_6040);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__6037_6041);

try{cljs.compiler.emit.call(null,expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__6035_6039);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__6034_6038);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4667__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.call(null,cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_.call(null,x)){
return cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.core.record_QMARK_.call(null,x)){
var vec__6042 = cljs.analyzer.record_ns_PLUS_name.call(null,x);
var ns = cljs.core.nth.call(null,vec__6042,(0),null);
var name = cljs.core.nth.call(null,vec__6042,(1),null);
return cljs.compiler.emit_record_value.call(null,ns,name,(function (){
return cljs.compiler.emit_constant.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,x));
}));
} else {
if(cljs.analyzer.cljs_map_QMARK_.call(null,x)){
return cljs.compiler.emit_map.call(null,cljs.core.keys.call(null,x),cljs.core.vals.call(null,x),cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
if(cljs.analyzer.cljs_vector_QMARK_.call(null,x)){
return cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep);
} else {
if(cljs.analyzer.cljs_set_QMARK_.call(null,x)){
return cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_);
} else {
return cljs.compiler.emit_constant_STAR_.call(null,x);

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta.call(null,cljs.core.meta.call(null,v));
if((!((cljs.core.seq.call(null,m) == null)))){
return cljs.compiler.emit_with_meta.call(null,(function (){
return cljs.compiler.emit_constant_no_meta.call(null,v);
}),(function (){
return cljs.compiler.emit_constant_no_meta.call(null,m);
}));
} else {
return cljs.compiler.emit_constant_no_meta.call(null,v);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.call(null,["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.call(null,cljs.core.type.call(null,x))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type.call(null,x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,null,(function (x){
return cljs.compiler.emits.call(null,"null");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.call(null,"NaN");
} else {
if(cljs.core.not.call(null,isFinite(x))){
return cljs.compiler.emits.call(null,(((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.call(null,"(",x,")");

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,String,(function (x){
return cljs.compiler.emits.call(null,cljs.compiler.wrap_in_double_quotes.call(null,cljs.compiler.escape_string.call(null,x)));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Boolean,(function (x){
return cljs.compiler.emits.call(null,(cljs.core.truth_(x)?"true":"false"));
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,RegExp,(function (x){
if(cljs.core._EQ_.call(null,"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.call(null,"(new RegExp(\"\"))");
} else {
var vec__6045 = cljs.core.re_find.call(null,/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.call(null,vec__6045,(0),null);
var flags = cljs.core.nth.call(null,vec__6045,(1),null);
var pattern = cljs.core.nth.call(null,vec__6045,(2),null);
return cljs.compiler.emits.call(null,pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace.call(null,kw);
var name = cljs.core.name.call(null,kw);
cljs.compiler.emits.call(null,"new cljs.core.Keyword(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,(cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,kw));

return cljs.compiler.emits.call(null,")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace.call(null,sym);
var name = cljs.core.name.call(null,sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.call(null,"new cljs.core.Symbol(");

cljs.compiler.emit_constant.call(null,ns);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,name);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,symstr);

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,cljs.core.hash.call(null,sym));

cljs.compiler.emits.call(null,",");

cljs.compiler.emit_constant.call(null,null);

return cljs.compiler.emits.call(null,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4115__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_keyword.call(null,x);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4115__auto__)){
return x.call(null,new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)));
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.call(null,"cljs.core.",value);
} else {
return cljs.compiler.emits_symbol.call(null,x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.call(null,cljs.core.map_indexed.call(null,(function (i,m){
if(cljs.core.even_QMARK_.call(null,i)){
return cljs.compiler.emit_constant.call(null,m);
} else {
return cljs.compiler.emits.call(null,m);
}
}),cljs.compiler.comma_sep.call(null,cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,Date,(function (date){
return cljs.compiler.emits.call(null,"new Date(",date.getTime(),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.call(null,"new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash.call(null,uuid_str),")");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_constant_STAR_,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_.call(null,items)){
return cljs.compiler.emit_js_object.call(null,items,(function (p1__6048_SHARP_){
return (function (){
return cljs.compiler.emit_constant.call(null,p1__6048_SHARP_);
});
}));
} else {
return cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep);
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__6050){
var map__6051 = p__6050;
var map__6051__$1 = (((((!((map__6051 == null))))?(((((map__6051.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6051.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6051):map__6051);
var ast = map__6051__$1;
var info = cljs.core.get.call(null,map__6051__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.call(null,map__6051__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.call(null,map__6051__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5733__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit.call(null,cljs.core.assoc.call(null,const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__6053 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__6053__$1 = (((((!((map__6053 == null))))?(((((map__6053.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6053.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6053):map__6053);
var cenv = map__6053__$1;
var options = cljs.core.get.call(null,map__6053__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.call(null,cljs.core.namespace.call(null,var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name.call(null,var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4126__auto__ = js_module_name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,ast));
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__6055 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.compiler.es5_GT__EQ_.call(null,new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options));
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.namespace.call(null,var_name) == null)));
} else {
return and__4115__auto__;
}
})())){
return clojure.set.difference.call(null,G__6055,cljs.analyzer.es5_allowed);
} else {
return G__6055;
}
})();
var js_module = cljs.core.get_in.call(null,cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4126__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.name.call(null,var_name);
}
})()], null));
var info__$2 = (function (){var G__6056 = info__$1;
if(cljs.core.not_EQ_.call(null,form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.call(null,G__6056,reserved);
} else {
return G__6056;
}
})();
var env__5894__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var G__6057_6058 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__6057_6059__$1 = (((G__6057_6058 instanceof cljs.core.Keyword))?G__6057_6058.fqn:null);
switch (G__6057_6059__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace.call(null,var_name))){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"].",cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved));
} else {
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.name.call(null,var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.namespace.call(null,var_name);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,"default",cljs.core.name.call(null,var_name));
} else {
return and__4115__auto__;
}
})())){
cljs.compiler.emits.call(null,cljs.compiler.munge.call(null,cljs.core.namespace.call(null,var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.call(null,info__$2);
}

break;
default:
cljs.compiler.emits.call(null,info__$2);

}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__6061){
var map__6062 = p__6061;
var map__6062__$1 = (((((!((map__6062 == null))))?(((((map__6062.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6062.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6062):map__6062);
var arg = map__6062__$1;
var env = cljs.core.get.call(null,map__6062__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.call(null,map__6062__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.call(null,map__6062__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.call(null,map__6062__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_.call(null,sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_.call(null,meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__6064 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__6064__$1 = (((((!((map__6064 == null))))?(((((map__6064.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6064.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6064):map__6064);
var name = cljs.core.get.call(null,map__6064__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__5894__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"new cljs.core.Var(function(){return ",cljs.compiler.munge.call(null,name),";},",sym,",",meta,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.call(null,"cljs.core.with_meta(",expr,",",meta,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__6066){
var map__6067 = p__6066;
var map__6067__$1 = (((((!((map__6067 == null))))?(((((map__6067.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6067.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6067):map__6067);
var expr = cljs.core.get.call(null,map__6067__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.call(null,map__6067__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.call(null,map__6067__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__5894__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_with_meta.call(null,expr,meta);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_.call(null,(function (p1__6069_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__6069_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count.call(null,keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count.call(null,keys) === (0))){
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count.call(null,keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_(distinct_keys_QMARK_.call(null,keys))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,keys),", [",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentArrayMap.createAsIfByAssoc([",comma_sep.call(null,cljs.core.interleave.call(null,keys,vals)),"])");
}
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashMap.fromArrays([",comma_sep.call(null,keys),"],[",comma_sep.call(null,vals),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__6070){
var map__6071 = p__6070;
var map__6071__$1 = (((((!((map__6071 == null))))?(((((map__6071.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6071.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6071):map__6071);
var env = cljs.core.get.call(null,map__6071__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.call(null,map__6071__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__6071__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__5894__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_map.call(null,keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.call(null,"cljs.core.list(",comma_sep.call(null,items),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count.call(null,items);
if((cnt < (32))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",comma_sep.call(null,items),"], null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentVector.fromArray([",comma_sep.call(null,items),"], true)");
}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__6073){
var map__6074 = p__6073;
var map__6074__$1 = (((((!((map__6074 == null))))?(((((map__6074.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6074.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6074):map__6074);
var items = cljs.core.get.call(null,map__6074__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__6074__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__5894__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_vector.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.call(null,cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_.call(null,(function (p1__6076_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__6076_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count.call(null,items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_.call(null,items)){
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_(distinct_constants_QMARK_.call(null,items))){
return cljs.compiler.emits.call(null,"new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count.call(null,items),", [",comma_sep.call(null,cljs.core.interleave.call(null,items,cljs.core.repeat.call(null,"null"))),"], null), null)");
} else {
return cljs.compiler.emits.call(null,"cljs.core.PersistentHashSet.createAsIfByAssoc([",comma_sep.call(null,items),"])");

}
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set","set",304602554),(function (p__6077){
var map__6078 = p__6077;
var map__6078__$1 = (((((!((map__6078 == null))))?(((((map__6078.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6078.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6078):map__6078);
var items = cljs.core.get.call(null,map__6078__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__6078__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__5894__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_set.call(null,items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.call(null,"({");

var temp__5735__auto___6102 = cljs.core.seq.call(null,items);
if(temp__5735__auto___6102){
var items_6103__$1 = temp__5735__auto___6102;
var vec__6080_6104 = items_6103__$1;
var seq__6081_6105 = cljs.core.seq.call(null,vec__6080_6104);
var first__6082_6106 = cljs.core.first.call(null,seq__6081_6105);
var seq__6081_6107__$1 = cljs.core.next.call(null,seq__6081_6105);
var vec__6083_6108 = first__6082_6106;
var k_6109 = cljs.core.nth.call(null,vec__6083_6108,(0),null);
var v_6110 = cljs.core.nth.call(null,vec__6083_6108,(1),null);
var r_6111 = seq__6081_6107__$1;
cljs.compiler.emits.call(null,"\"",cljs.core.name.call(null,k_6109),"\": ",emit_js_object_val.call(null,v_6110));

var seq__6086_6112 = cljs.core.seq.call(null,r_6111);
var chunk__6087_6113 = null;
var count__6088_6114 = (0);
var i__6089_6115 = (0);
while(true){
if((i__6089_6115 < count__6088_6114)){
var vec__6096_6116 = cljs.core._nth.call(null,chunk__6087_6113,i__6089_6115);
var k_6117__$1 = cljs.core.nth.call(null,vec__6096_6116,(0),null);
var v_6118__$1 = cljs.core.nth.call(null,vec__6096_6116,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_6117__$1),"\": ",emit_js_object_val.call(null,v_6118__$1));


var G__6119 = seq__6086_6112;
var G__6120 = chunk__6087_6113;
var G__6121 = count__6088_6114;
var G__6122 = (i__6089_6115 + (1));
seq__6086_6112 = G__6119;
chunk__6087_6113 = G__6120;
count__6088_6114 = G__6121;
i__6089_6115 = G__6122;
continue;
} else {
var temp__5735__auto___6123__$1 = cljs.core.seq.call(null,seq__6086_6112);
if(temp__5735__auto___6123__$1){
var seq__6086_6124__$1 = temp__5735__auto___6123__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6086_6124__$1)){
var c__4556__auto___6125 = cljs.core.chunk_first.call(null,seq__6086_6124__$1);
var G__6126 = cljs.core.chunk_rest.call(null,seq__6086_6124__$1);
var G__6127 = c__4556__auto___6125;
var G__6128 = cljs.core.count.call(null,c__4556__auto___6125);
var G__6129 = (0);
seq__6086_6112 = G__6126;
chunk__6087_6113 = G__6127;
count__6088_6114 = G__6128;
i__6089_6115 = G__6129;
continue;
} else {
var vec__6099_6130 = cljs.core.first.call(null,seq__6086_6124__$1);
var k_6131__$1 = cljs.core.nth.call(null,vec__6099_6130,(0),null);
var v_6132__$1 = cljs.core.nth.call(null,vec__6099_6130,(1),null);
cljs.compiler.emits.call(null,", \"",cljs.core.name.call(null,k_6131__$1),"\": ",emit_js_object_val.call(null,v_6132__$1));


var G__6133 = cljs.core.next.call(null,seq__6086_6124__$1);
var G__6134 = null;
var G__6135 = (0);
var G__6136 = (0);
seq__6086_6112 = G__6133;
chunk__6087_6113 = G__6134;
count__6088_6114 = G__6135;
i__6089_6115 = G__6136;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.call(null,"[",comma_sep.call(null,items),"]");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__6137){
var map__6138 = p__6137;
var map__6138__$1 = (((((!((map__6138 == null))))?(((((map__6138.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6138.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6138):map__6138);
var keys = cljs.core.get.call(null,map__6138__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.call(null,map__6138__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.call(null,map__6138__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__5894__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_object.call(null,cljs.core.map.call(null,cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__6140){
var map__6141 = p__6140;
var map__6141__$1 = (((((!((map__6141 == null))))?(((((map__6141.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6141.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6141):map__6141);
var items = cljs.core.get.call(null,map__6141__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.call(null,map__6141__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__5894__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_js_array.call(null,items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.call(null,ns,".map__GT_",name,"(",items,")");
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__6143){
var map__6144 = p__6143;
var map__6144__$1 = (((((!((map__6144 == null))))?(((((map__6144.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6144.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6144):map__6144);
var expr = cljs.core.get.call(null,map__6144__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit.call(null,expr);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__6146){
var map__6147 = p__6146;
var map__6147__$1 = (((((!((map__6147 == null))))?(((((map__6147.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6147.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6147):map__6147);
var form = cljs.core.get.call(null,map__6147__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.call(null,map__6147__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__5894__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emit_constant.call(null,form);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__6149 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__6149__$1 = (((((!((map__6149 == null))))?(((((map__6149.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6149.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6149):map__6149);
var op = cljs.core.get.call(null,map__6149__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__6149__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__6149__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4126__auto__ = ((cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842)))?(function (){var and__4115__auto__ = form;
if(cljs.core.truth_(and__4115__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.call(null,form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4115__auto__;
}
})():false);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if((!((const_expr == null)))){
return cljs.compiler.truthy_constant_QMARK_.call(null,const_expr);
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__6151 = cljs.analyzer.unwrap_quote.call(null,expr);
var map__6151__$1 = (((((!((map__6151 == null))))?(((((map__6151.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6151.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6151):map__6151);
var op = cljs.core.get.call(null,map__6151__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.call(null,map__6151__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.call(null,map__6151__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4126__auto__ = ((cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4126__auto__){
return or__4126__auto__;
} else {
if((!((const_expr == null)))){
return cljs.compiler.falsey_constant_QMARK_.call(null,const_expr);
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag.call(null,env,e);
var or__4126__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null).call(null,tag);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_.call(null,e);
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__6153){
var map__6154 = p__6153;
var map__6154__$1 = (((((!((map__6154 == null))))?(((((map__6154.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6154.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6154):map__6154);
var test = cljs.core.get.call(null,map__6154__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.call(null,map__6154__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.call(null,map__6154__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.call(null,map__6154__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.call(null,map__6154__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not.call(null,(function (){var or__4126__auto__ = unchecked;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.compiler.safe_test_QMARK_.call(null,env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_.call(null,test))){
return cljs.compiler.emitln.call(null,else$);
} else {
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"(",((checked)?"cljs.core.truth_":null),"(",test,")?",then,":",else$,")");
} else {
if(checked){
cljs.compiler.emitln.call(null,"if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.call(null,"if(",test,"){");
}

cljs.compiler.emitln.call(null,then,"} else {");

return cljs.compiler.emitln.call(null,else$,"}");
}

}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__6156){
var map__6157 = p__6156;
var map__6157__$1 = (((((!((map__6157 == null))))?(((((map__6157.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6157.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6157):map__6157);
var v = cljs.core.get.call(null,map__6157__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.call(null,map__6157__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.call(null,map__6157__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.call(null,map__6157__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.call(null,"(function(){");
} else {
}

var gs = cljs.core.gensym.call(null,"caseval__");
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"var ",gs,";");
} else {
}

cljs.compiler.emitln.call(null,"switch (",v,") {");

var seq__6159_6195 = cljs.core.seq.call(null,nodes);
var chunk__6160_6196 = null;
var count__6161_6197 = (0);
var i__6162_6198 = (0);
while(true){
if((i__6162_6198 < count__6161_6197)){
var map__6179_6199 = cljs.core._nth.call(null,chunk__6160_6196,i__6162_6198);
var map__6179_6200__$1 = (((((!((map__6179_6199 == null))))?(((((map__6179_6199.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6179_6199.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6179_6199):map__6179_6199);
var ts_6201 = cljs.core.get.call(null,map__6179_6200__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__6180_6202 = cljs.core.get.call(null,map__6179_6200__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__6180_6203__$1 = (((((!((map__6180_6202 == null))))?(((((map__6180_6202.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6180_6202.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6180_6202):map__6180_6202);
var then_6204 = cljs.core.get.call(null,map__6180_6203__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__6183_6205 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_6201));
var chunk__6184_6206 = null;
var count__6185_6207 = (0);
var i__6186_6208 = (0);
while(true){
if((i__6186_6208 < count__6185_6207)){
var test_6209 = cljs.core._nth.call(null,chunk__6184_6206,i__6186_6208);
cljs.compiler.emitln.call(null,"case ",test_6209,":");


var G__6210 = seq__6183_6205;
var G__6211 = chunk__6184_6206;
var G__6212 = count__6185_6207;
var G__6213 = (i__6186_6208 + (1));
seq__6183_6205 = G__6210;
chunk__6184_6206 = G__6211;
count__6185_6207 = G__6212;
i__6186_6208 = G__6213;
continue;
} else {
var temp__5735__auto___6214 = cljs.core.seq.call(null,seq__6183_6205);
if(temp__5735__auto___6214){
var seq__6183_6215__$1 = temp__5735__auto___6214;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6183_6215__$1)){
var c__4556__auto___6216 = cljs.core.chunk_first.call(null,seq__6183_6215__$1);
var G__6217 = cljs.core.chunk_rest.call(null,seq__6183_6215__$1);
var G__6218 = c__4556__auto___6216;
var G__6219 = cljs.core.count.call(null,c__4556__auto___6216);
var G__6220 = (0);
seq__6183_6205 = G__6217;
chunk__6184_6206 = G__6218;
count__6185_6207 = G__6219;
i__6186_6208 = G__6220;
continue;
} else {
var test_6221 = cljs.core.first.call(null,seq__6183_6215__$1);
cljs.compiler.emitln.call(null,"case ",test_6221,":");


var G__6222 = cljs.core.next.call(null,seq__6183_6215__$1);
var G__6223 = null;
var G__6224 = (0);
var G__6225 = (0);
seq__6183_6205 = G__6222;
chunk__6184_6206 = G__6223;
count__6185_6207 = G__6224;
i__6186_6208 = G__6225;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_6204);
} else {
cljs.compiler.emitln.call(null,then_6204);
}

cljs.compiler.emitln.call(null,"break;");


var G__6226 = seq__6159_6195;
var G__6227 = chunk__6160_6196;
var G__6228 = count__6161_6197;
var G__6229 = (i__6162_6198 + (1));
seq__6159_6195 = G__6226;
chunk__6160_6196 = G__6227;
count__6161_6197 = G__6228;
i__6162_6198 = G__6229;
continue;
} else {
var temp__5735__auto___6230 = cljs.core.seq.call(null,seq__6159_6195);
if(temp__5735__auto___6230){
var seq__6159_6231__$1 = temp__5735__auto___6230;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6159_6231__$1)){
var c__4556__auto___6232 = cljs.core.chunk_first.call(null,seq__6159_6231__$1);
var G__6233 = cljs.core.chunk_rest.call(null,seq__6159_6231__$1);
var G__6234 = c__4556__auto___6232;
var G__6235 = cljs.core.count.call(null,c__4556__auto___6232);
var G__6236 = (0);
seq__6159_6195 = G__6233;
chunk__6160_6196 = G__6234;
count__6161_6197 = G__6235;
i__6162_6198 = G__6236;
continue;
} else {
var map__6187_6237 = cljs.core.first.call(null,seq__6159_6231__$1);
var map__6187_6238__$1 = (((((!((map__6187_6237 == null))))?(((((map__6187_6237.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6187_6237.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6187_6237):map__6187_6237);
var ts_6239 = cljs.core.get.call(null,map__6187_6238__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__6188_6240 = cljs.core.get.call(null,map__6187_6238__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__6188_6241__$1 = (((((!((map__6188_6240 == null))))?(((((map__6188_6240.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6188_6240.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6188_6240):map__6188_6240);
var then_6242 = cljs.core.get.call(null,map__6188_6241__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__6191_6243 = cljs.core.seq.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"test","test",577538877),ts_6239));
var chunk__6192_6244 = null;
var count__6193_6245 = (0);
var i__6194_6246 = (0);
while(true){
if((i__6194_6246 < count__6193_6245)){
var test_6247 = cljs.core._nth.call(null,chunk__6192_6244,i__6194_6246);
cljs.compiler.emitln.call(null,"case ",test_6247,":");


var G__6248 = seq__6191_6243;
var G__6249 = chunk__6192_6244;
var G__6250 = count__6193_6245;
var G__6251 = (i__6194_6246 + (1));
seq__6191_6243 = G__6248;
chunk__6192_6244 = G__6249;
count__6193_6245 = G__6250;
i__6194_6246 = G__6251;
continue;
} else {
var temp__5735__auto___6252__$1 = cljs.core.seq.call(null,seq__6191_6243);
if(temp__5735__auto___6252__$1){
var seq__6191_6253__$1 = temp__5735__auto___6252__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6191_6253__$1)){
var c__4556__auto___6254 = cljs.core.chunk_first.call(null,seq__6191_6253__$1);
var G__6255 = cljs.core.chunk_rest.call(null,seq__6191_6253__$1);
var G__6256 = c__4556__auto___6254;
var G__6257 = cljs.core.count.call(null,c__4556__auto___6254);
var G__6258 = (0);
seq__6191_6243 = G__6255;
chunk__6192_6244 = G__6256;
count__6193_6245 = G__6257;
i__6194_6246 = G__6258;
continue;
} else {
var test_6259 = cljs.core.first.call(null,seq__6191_6253__$1);
cljs.compiler.emitln.call(null,"case ",test_6259,":");


var G__6260 = cljs.core.next.call(null,seq__6191_6253__$1);
var G__6261 = null;
var G__6262 = (0);
var G__6263 = (0);
seq__6191_6243 = G__6260;
chunk__6192_6244 = G__6261;
count__6193_6245 = G__6262;
i__6194_6246 = G__6263;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",then_6242);
} else {
cljs.compiler.emitln.call(null,then_6242);
}

cljs.compiler.emitln.call(null,"break;");


var G__6264 = cljs.core.next.call(null,seq__6159_6231__$1);
var G__6265 = null;
var G__6266 = (0);
var G__6267 = (0);
seq__6159_6195 = G__6264;
chunk__6160_6196 = G__6265;
count__6161_6197 = G__6266;
i__6162_6198 = G__6267;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.call(null,"default:");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,gs,"=",default$);
} else {
cljs.compiler.emitln.call(null,default$);
}
} else {
}

cljs.compiler.emitln.call(null,"}");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"return ",gs,";})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__6268){
var map__6269 = p__6268;
var map__6269__$1 = (((((!((map__6269 == null))))?(((((map__6269.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6269.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6269):map__6269);
var throw$ = cljs.core.get.call(null,map__6269__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.call(null,map__6269__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.call(null,"(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.call(null,"throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.call(null,cljs.compiler.mapped_types,t))){
return cljs.core.get.call(null,cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(1))))].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__6272 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.call(null,t,(0),idx),cljs.core.subs.call(null,t,(idx + (1)),cljs.core.count.call(null,t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.call(null,vec__6272,(0),null);
var rstr = cljs.core.nth.call(null,vec__6272,(1),null);
var ret_t = (cljs.core.truth_(rstr)?cljs.compiler.resolve_type.call(null,env,rstr):null);
var axstr = cljs.core.subs.call(null,fstr,(9),(cljs.core.count.call(null,fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_.call(null,axstr))?null:cljs.core.map.call(null,cljs.core.comp.call(null,(function (p1__6271_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__6271_SHARP_);
}),clojure.string.trim),clojure.string.split.call(null,axstr,/,/)));
var G__6275 = ["function(",clojure.string.join.call(null,",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__6275,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__6275;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.resolve_type.call(null,env,cljs.core.subs.call(null,t,(0),(cljs.core.count.call(null,t) - (1))))),"="].join('');
} else {
return cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.call(null,env,cljs.core.symbol.call(null,t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.call(null,clojure.string.trim.call(null,ts),(1),(cljs.core.count.call(null,ts) - (1)));
var xs = clojure.string.split.call(null,ts__$1,/\|/);
return ["{",clojure.string.join.call(null,"|",cljs.core.map.call(null,(function (p1__6276_SHARP_){
return cljs.compiler.resolve_type.call(null,env,p1__6276_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find.call(null,/@param/,line))){
var vec__6277 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__6278 = cljs.core.seq.call(null,vec__6277);
var first__6279 = cljs.core.first.call(null,seq__6278);
var seq__6278__$1 = cljs.core.next.call(null,seq__6278);
var p = first__6279;
var first__6279__$1 = cljs.core.first.call(null,seq__6278__$1);
var seq__6278__$2 = cljs.core.next.call(null,seq__6278__$1);
var ts = first__6279__$1;
var first__6279__$2 = cljs.core.first.call(null,seq__6278__$2);
var seq__6278__$3 = cljs.core.next.call(null,seq__6278__$2);
var n = first__6279__$2;
var xs = seq__6278__$3;
if(cljs.core.truth_(((cljs.core._EQ_.call(null,"@param",p))?(function (){var and__4115__auto__ = ts;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4115__auto__;
}
})():false))){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts),cljs.compiler.munge.call(null,n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find.call(null,/@return/,line))){
var vec__6280 = cljs.core.map.call(null,clojure.string.trim,clojure.string.split.call(null,clojure.string.trim.call(null,line),/ /));
var seq__6281 = cljs.core.seq.call(null,vec__6280);
var first__6282 = cljs.core.first.call(null,seq__6281);
var seq__6281__$1 = cljs.core.next.call(null,seq__6281);
var p = first__6282;
var first__6282__$1 = cljs.core.first.call(null,seq__6281__$1);
var seq__6281__$2 = cljs.core.next.call(null,seq__6281__$1);
var ts = first__6282__$1;
var xs = seq__6281__$2;
if(cljs.core.truth_(((cljs.core._EQ_.call(null,"@return",p))?(function (){var and__4115__auto__ = ts;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4115__auto__;
}
})():false))){
return clojure.string.join.call(null," ",cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types.call(null,env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null).call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null)));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__6285 = arguments.length;
switch (G__6285) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.call(null,null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.call(null,docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__6293 = cljs.core.map.call(null,(function (p1__6283_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_.call(null))){
return cljs.compiler.munge_param_return.call(null,env,p1__6283_SHARP_);
} else {
return p1__6283_SHARP_;
}
}),clojure.string.split_lines.call(null,e));
var seq__6294 = cljs.core.seq.call(null,vec__6293);
var first__6295 = cljs.core.first.call(null,seq__6294);
var seq__6294__$1 = cljs.core.next.call(null,seq__6294);
var x = first__6295;
var ys = seq__6294__$1;
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,x,"*/","* /"));

var seq__6296 = cljs.core.seq.call(null,ys);
var chunk__6297 = null;
var count__6298 = (0);
var i__6299 = (0);
while(true){
if((i__6299 < count__6298)){
var next_line = cljs.core._nth.call(null,chunk__6297,i__6299);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__6305 = seq__6296;
var G__6306 = chunk__6297;
var G__6307 = count__6298;
var G__6308 = (i__6299 + (1));
seq__6296 = G__6305;
chunk__6297 = G__6306;
count__6298 = G__6307;
i__6299 = G__6308;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__6296);
if(temp__5735__auto__){
var seq__6296__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6296__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__6296__$1);
var G__6309 = cljs.core.chunk_rest.call(null,seq__6296__$1);
var G__6310 = c__4556__auto__;
var G__6311 = cljs.core.count.call(null,c__4556__auto__);
var G__6312 = (0);
seq__6296 = G__6309;
chunk__6297 = G__6310;
count__6298 = G__6311;
i__6299 = G__6312;
continue;
} else {
var next_line = cljs.core.first.call(null,seq__6296__$1);
cljs.compiler.emitln.call(null," * ",clojure.string.replace.call(null,clojure.string.replace.call(null,next_line,/^   /,""),"*/","* /"));


var G__6313 = cljs.core.next.call(null,seq__6296__$1);
var G__6314 = null;
var G__6315 = (0);
var G__6316 = (0);
seq__6296 = G__6313;
chunk__6297 = G__6314;
count__6298 = G__6315;
i__6299 = G__6316;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq.call(null,docs__$2)){
cljs.compiler.emitln.call(null,"/**");

var seq__6300_6317 = cljs.core.seq.call(null,docs__$2);
var chunk__6301_6318 = null;
var count__6302_6319 = (0);
var i__6303_6320 = (0);
while(true){
if((i__6303_6320 < count__6302_6319)){
var e_6321 = cljs.core._nth.call(null,chunk__6301_6318,i__6303_6320);
if(cljs.core.truth_(e_6321)){
print_comment_lines.call(null,e_6321);
} else {
}


var G__6322 = seq__6300_6317;
var G__6323 = chunk__6301_6318;
var G__6324 = count__6302_6319;
var G__6325 = (i__6303_6320 + (1));
seq__6300_6317 = G__6322;
chunk__6301_6318 = G__6323;
count__6302_6319 = G__6324;
i__6303_6320 = G__6325;
continue;
} else {
var temp__5735__auto___6326 = cljs.core.seq.call(null,seq__6300_6317);
if(temp__5735__auto___6326){
var seq__6300_6327__$1 = temp__5735__auto___6326;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6300_6327__$1)){
var c__4556__auto___6328 = cljs.core.chunk_first.call(null,seq__6300_6327__$1);
var G__6329 = cljs.core.chunk_rest.call(null,seq__6300_6327__$1);
var G__6330 = c__4556__auto___6328;
var G__6331 = cljs.core.count.call(null,c__4556__auto___6328);
var G__6332 = (0);
seq__6300_6317 = G__6329;
chunk__6301_6318 = G__6330;
count__6302_6319 = G__6331;
i__6303_6320 = G__6332;
continue;
} else {
var e_6333 = cljs.core.first.call(null,seq__6300_6327__$1);
if(cljs.core.truth_(e_6333)){
print_comment_lines.call(null,e_6333);
} else {
}


var G__6334 = cljs.core.next.call(null,seq__6300_6327__$1);
var G__6335 = null;
var G__6336 = (0);
var G__6337 = (0);
seq__6300_6317 = G__6334;
chunk__6301_6318 = G__6335;
count__6302_6319 = G__6336;
i__6303_6320 = G__6337;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.call(null," */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.call(null,cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4115__auto__ = cljs.core.some.call(null,(function (p1__6339_SHARP_){
return goog.string.startsWith(p1__6339_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4115__auto__)){
var and__4115__auto____$1 = opts;
if(cljs.core.truth_(and__4115__auto____$1)){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478))){
var define = cljs.core.get_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_.call(null,define)){
return cljs.core.pr_str.call(null,define);
} else {
return null;
}
} else {
return false;
}
} else {
return and__4115__auto____$1;
}
} else {
return and__4115__auto__;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__6340){
var map__6341 = p__6340;
var map__6341__$1 = (((((!((map__6341 == null))))?(((((map__6341.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6341.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6341):map__6341);
var doc = cljs.core.get.call(null,map__6341__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.call(null,map__6341__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.call(null,map__6341__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.call(null,map__6341__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.call(null,map__6341__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.call(null,map__6341__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__6341__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.call(null,map__6341__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.call(null,map__6341__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.call(null,map__6341__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4126__auto__ = init;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.call(null,name);
cljs.compiler.emit_comment.call(null,env,doc,cljs.core.concat.call(null,(cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.call(null," = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define.call(null,mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,"; return (");

cljs.compiler.emits.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.call(null,env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast));

cljs.compiler.emitln.call(null,");})()");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,")");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.call(null,";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.call(null,"goog.exportSymbol('",cljs.compiler.munge.call(null,export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
return test;
} else {
return and__4115__auto__;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.call(null,";");
} else {
}

return cljs.compiler.emitln.call(null,var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__6343){
var map__6344 = p__6343;
var map__6344__$1 = (((((!((map__6344 == null))))?(((((map__6344.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6344.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6344):map__6344);
var name = cljs.core.get.call(null,map__6344__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__6344__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__6344__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.call(null,"arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,name)),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function (",arglist,"){");

var seq__6346_6370 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,cljs.core.vector,cljs.core.drop_last.call(null,(2),params)));
var chunk__6347_6371 = null;
var count__6348_6372 = (0);
var i__6349_6373 = (0);
while(true){
if((i__6349_6373 < count__6348_6372)){
var vec__6356_6374 = cljs.core._nth.call(null,chunk__6347_6371,i__6349_6373);
var i_6375 = cljs.core.nth.call(null,vec__6356_6374,(0),null);
var param_6376 = cljs.core.nth.call(null,vec__6356_6374,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_6376);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__6377 = seq__6346_6370;
var G__6378 = chunk__6347_6371;
var G__6379 = count__6348_6372;
var G__6380 = (i__6349_6373 + (1));
seq__6346_6370 = G__6377;
chunk__6347_6371 = G__6378;
count__6348_6372 = G__6379;
i__6349_6373 = G__6380;
continue;
} else {
var temp__5735__auto___6381 = cljs.core.seq.call(null,seq__6346_6370);
if(temp__5735__auto___6381){
var seq__6346_6382__$1 = temp__5735__auto___6381;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6346_6382__$1)){
var c__4556__auto___6383 = cljs.core.chunk_first.call(null,seq__6346_6382__$1);
var G__6384 = cljs.core.chunk_rest.call(null,seq__6346_6382__$1);
var G__6385 = c__4556__auto___6383;
var G__6386 = cljs.core.count.call(null,c__4556__auto___6383);
var G__6387 = (0);
seq__6346_6370 = G__6384;
chunk__6347_6371 = G__6385;
count__6348_6372 = G__6386;
i__6349_6373 = G__6387;
continue;
} else {
var vec__6359_6388 = cljs.core.first.call(null,seq__6346_6382__$1);
var i_6389 = cljs.core.nth.call(null,vec__6359_6388,(0),null);
var param_6390 = cljs.core.nth.call(null,vec__6359_6388,(1),null);
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,param_6390);

cljs.compiler.emits.call(null," = cljs.core.first(");

cljs.compiler.emitln.call(null,arglist,");");

cljs.compiler.emitln.call(null,arglist," = cljs.core.next(",arglist,");");


var G__6391 = cljs.core.next.call(null,seq__6346_6382__$1);
var G__6392 = null;
var G__6393 = (0);
var G__6394 = (0);
seq__6346_6370 = G__6391;
chunk__6347_6371 = G__6392;
count__6348_6372 = G__6393;
i__6349_6373 = G__6394;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count.call(null,params))){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,cljs.core.butlast.call(null,params)));

cljs.compiler.emitln.call(null," = cljs.core.first(",arglist,");");

cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.rest(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__6362_6395 = cljs.core.seq.call(null,params);
var chunk__6363_6396 = null;
var count__6364_6397 = (0);
var i__6365_6398 = (0);
while(true){
if((i__6365_6398 < count__6364_6397)){
var param_6399 = cljs.core._nth.call(null,chunk__6363_6396,i__6365_6398);
cljs.compiler.emit.call(null,param_6399);

if(cljs.core._EQ_.call(null,param_6399,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6400 = seq__6362_6395;
var G__6401 = chunk__6363_6396;
var G__6402 = count__6364_6397;
var G__6403 = (i__6365_6398 + (1));
seq__6362_6395 = G__6400;
chunk__6363_6396 = G__6401;
count__6364_6397 = G__6402;
i__6365_6398 = G__6403;
continue;
} else {
var temp__5735__auto___6404 = cljs.core.seq.call(null,seq__6362_6395);
if(temp__5735__auto___6404){
var seq__6362_6405__$1 = temp__5735__auto___6404;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6362_6405__$1)){
var c__4556__auto___6406 = cljs.core.chunk_first.call(null,seq__6362_6405__$1);
var G__6407 = cljs.core.chunk_rest.call(null,seq__6362_6405__$1);
var G__6408 = c__4556__auto___6406;
var G__6409 = cljs.core.count.call(null,c__4556__auto___6406);
var G__6410 = (0);
seq__6362_6395 = G__6407;
chunk__6363_6396 = G__6408;
count__6364_6397 = G__6409;
i__6365_6398 = G__6410;
continue;
} else {
var param_6411 = cljs.core.first.call(null,seq__6362_6405__$1);
cljs.compiler.emit.call(null,param_6411);

if(cljs.core._EQ_.call(null,param_6411,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6412 = cljs.core.next.call(null,seq__6362_6405__$1);
var G__6413 = null;
var G__6414 = (0);
var G__6415 = (0);
seq__6362_6395 = G__6412;
chunk__6363_6396 = G__6413;
count__6364_6397 = G__6414;
i__6365_6398 = G__6415;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
} else {
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = cljs.core.seq(",arglist,");");

cljs.compiler.emits.call(null,"return ",delegate_name,"(");

var seq__6366_6416 = cljs.core.seq.call(null,params);
var chunk__6367_6417 = null;
var count__6368_6418 = (0);
var i__6369_6419 = (0);
while(true){
if((i__6369_6419 < count__6368_6418)){
var param_6420 = cljs.core._nth.call(null,chunk__6367_6417,i__6369_6419);
cljs.compiler.emit.call(null,param_6420);

if(cljs.core._EQ_.call(null,param_6420,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6421 = seq__6366_6416;
var G__6422 = chunk__6367_6417;
var G__6423 = count__6368_6418;
var G__6424 = (i__6369_6419 + (1));
seq__6366_6416 = G__6421;
chunk__6367_6417 = G__6422;
count__6368_6418 = G__6423;
i__6369_6419 = G__6424;
continue;
} else {
var temp__5735__auto___6425 = cljs.core.seq.call(null,seq__6366_6416);
if(temp__5735__auto___6425){
var seq__6366_6426__$1 = temp__5735__auto___6425;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6366_6426__$1)){
var c__4556__auto___6427 = cljs.core.chunk_first.call(null,seq__6366_6426__$1);
var G__6428 = cljs.core.chunk_rest.call(null,seq__6366_6426__$1);
var G__6429 = c__4556__auto___6427;
var G__6430 = cljs.core.count.call(null,c__4556__auto___6427);
var G__6431 = (0);
seq__6366_6416 = G__6428;
chunk__6367_6417 = G__6429;
count__6368_6418 = G__6430;
i__6369_6419 = G__6431;
continue;
} else {
var param_6432 = cljs.core.first.call(null,seq__6366_6426__$1);
cljs.compiler.emit.call(null,param_6432);

if(cljs.core._EQ_.call(null,param_6432,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6433 = cljs.core.next.call(null,seq__6366_6426__$1);
var G__6434 = null;
var G__6435 = (0);
var G__6436 = (0);
seq__6366_6416 = G__6433;
chunk__6367_6417 = G__6434;
count__6368_6418 = G__6435;
i__6369_6419 = G__6436;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,");");
}

return cljs.compiler.emits.call(null,"})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__6437 = cljs.core.seq.call(null,params);
var chunk__6438 = null;
var count__6439 = (0);
var i__6440 = (0);
while(true){
if((i__6440 < count__6439)){
var param = cljs.core._nth.call(null,chunk__6438,i__6440);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6441 = seq__6437;
var G__6442 = chunk__6438;
var G__6443 = count__6439;
var G__6444 = (i__6440 + (1));
seq__6437 = G__6441;
chunk__6438 = G__6442;
count__6439 = G__6443;
i__6440 = G__6444;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__6437);
if(temp__5735__auto__){
var seq__6437__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6437__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__6437__$1);
var G__6445 = cljs.core.chunk_rest.call(null,seq__6437__$1);
var G__6446 = c__4556__auto__;
var G__6447 = cljs.core.count.call(null,c__4556__auto__);
var G__6448 = (0);
seq__6437 = G__6445;
chunk__6438 = G__6446;
count__6439 = G__6447;
i__6440 = G__6448;
continue;
} else {
var param = cljs.core.first.call(null,seq__6437__$1);
cljs.compiler.emit.call(null,param);

if(cljs.core._EQ_.call(null,param,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6449 = cljs.core.next.call(null,seq__6437__$1);
var G__6450 = null;
var G__6451 = (0);
var G__6452 = (0);
seq__6437 = G__6449;
chunk__6438 = G__6450;
count__6439 = G__6451;
i__6440 = G__6452;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__6453){
var map__6454 = p__6453;
var map__6454__$1 = (((((!((map__6454 == null))))?(((((map__6454.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6454.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6454):map__6454);
var expr = cljs.core.get.call(null,map__6454__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.call(null,map__6454__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__6454__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__6454__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__6454__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__6454__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__5894__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(function ",cljs.compiler.munge.call(null,name),"(");

cljs.compiler.emit_fn_params.call(null,params);

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emits.call(null,"})");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_.call(null,startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.call(null,"var ",i," = 0, ",a," = new Array(arguments.length -  ",startslice,");");

cljs.compiler.emitln.call(null,"while (",i," < ",a,".length) {",a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}");

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__6456){
var map__6457 = p__6456;
var map__6457__$1 = (((((!((map__6457 == null))))?(((((map__6457.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6457.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6457):map__6457);
var f = map__6457__$1;
var expr = cljs.core.get.call(null,map__6457__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.call(null,map__6457__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.call(null,map__6457__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.call(null,map__6457__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.call(null,map__6457__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.call(null,map__6457__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.call(null,map__6457__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.call(null,map__6457__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__5894__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

var name_6467__$1 = (function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_6468 = cljs.compiler.munge.call(null,name_6467__$1);
var delegate_name_6469 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_6468),"__delegate"].join('');
cljs.compiler.emitln.call(null,"(function() { ");

cljs.compiler.emits.call(null,"var ",delegate_name_6469," = function (");

var seq__6459_6470 = cljs.core.seq.call(null,params);
var chunk__6460_6471 = null;
var count__6461_6472 = (0);
var i__6462_6473 = (0);
while(true){
if((i__6462_6473 < count__6461_6472)){
var param_6474 = cljs.core._nth.call(null,chunk__6460_6471,i__6462_6473);
cljs.compiler.emit.call(null,param_6474);

if(cljs.core._EQ_.call(null,param_6474,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6475 = seq__6459_6470;
var G__6476 = chunk__6460_6471;
var G__6477 = count__6461_6472;
var G__6478 = (i__6462_6473 + (1));
seq__6459_6470 = G__6475;
chunk__6460_6471 = G__6476;
count__6461_6472 = G__6477;
i__6462_6473 = G__6478;
continue;
} else {
var temp__5735__auto___6479 = cljs.core.seq.call(null,seq__6459_6470);
if(temp__5735__auto___6479){
var seq__6459_6480__$1 = temp__5735__auto___6479;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6459_6480__$1)){
var c__4556__auto___6481 = cljs.core.chunk_first.call(null,seq__6459_6480__$1);
var G__6482 = cljs.core.chunk_rest.call(null,seq__6459_6480__$1);
var G__6483 = c__4556__auto___6481;
var G__6484 = cljs.core.count.call(null,c__4556__auto___6481);
var G__6485 = (0);
seq__6459_6470 = G__6482;
chunk__6460_6471 = G__6483;
count__6461_6472 = G__6484;
i__6462_6473 = G__6485;
continue;
} else {
var param_6486 = cljs.core.first.call(null,seq__6459_6480__$1);
cljs.compiler.emit.call(null,param_6486);

if(cljs.core._EQ_.call(null,param_6486,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6487 = cljs.core.next.call(null,seq__6459_6480__$1);
var G__6488 = null;
var G__6489 = (0);
var G__6490 = (0);
seq__6459_6470 = G__6487;
chunk__6460_6471 = G__6488;
count__6461_6472 = G__6489;
i__6462_6473 = G__6490;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,"var ",mname_6468," = function (",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.call(null,"var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,params));

cljs.compiler.emitln.call(null," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",(cljs.core.count.call(null,params) - (1)),") {");

var a_6491 = cljs.compiler.emit_arguments_to_array.call(null,(cljs.core.count.call(null,params) - (1)));
cljs.compiler.emitln.call(null,"  ",cljs.core.last.call(null,params)," = new cljs.core.IndexedSeq(",a_6491,",0,null);");

cljs.compiler.emitln.call(null,"} ");
} else {
}

cljs.compiler.emits.call(null,"return ",delegate_name_6469,".call(this,");

var seq__6463_6492 = cljs.core.seq.call(null,params);
var chunk__6464_6493 = null;
var count__6465_6494 = (0);
var i__6466_6495 = (0);
while(true){
if((i__6466_6495 < count__6465_6494)){
var param_6496 = cljs.core._nth.call(null,chunk__6464_6493,i__6466_6495);
cljs.compiler.emit.call(null,param_6496);

if(cljs.core._EQ_.call(null,param_6496,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6497 = seq__6463_6492;
var G__6498 = chunk__6464_6493;
var G__6499 = count__6465_6494;
var G__6500 = (i__6466_6495 + (1));
seq__6463_6492 = G__6497;
chunk__6464_6493 = G__6498;
count__6465_6494 = G__6499;
i__6466_6495 = G__6500;
continue;
} else {
var temp__5735__auto___6501 = cljs.core.seq.call(null,seq__6463_6492);
if(temp__5735__auto___6501){
var seq__6463_6502__$1 = temp__5735__auto___6501;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6463_6502__$1)){
var c__4556__auto___6503 = cljs.core.chunk_first.call(null,seq__6463_6502__$1);
var G__6504 = cljs.core.chunk_rest.call(null,seq__6463_6502__$1);
var G__6505 = c__4556__auto___6503;
var G__6506 = cljs.core.count.call(null,c__4556__auto___6503);
var G__6507 = (0);
seq__6463_6492 = G__6504;
chunk__6464_6493 = G__6505;
count__6465_6494 = G__6506;
i__6466_6495 = G__6507;
continue;
} else {
var param_6508 = cljs.core.first.call(null,seq__6463_6502__$1);
cljs.compiler.emit.call(null,param_6508);

if(cljs.core._EQ_.call(null,param_6508,cljs.core.last.call(null,params))){
} else {
cljs.compiler.emits.call(null,",");
}


var G__6509 = cljs.core.next.call(null,seq__6463_6502__$1);
var G__6510 = null;
var G__6511 = (0);
var G__6512 = (0);
seq__6463_6492 = G__6509;
chunk__6464_6493 = G__6510;
count__6465_6494 = G__6511;
i__6466_6495 = G__6512;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,");");

cljs.compiler.emitln.call(null,"};");

cljs.compiler.emitln.call(null,mname_6468,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.call(null,mname_6468,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to.call(null,cljs.core.assoc.call(null,f,new cljs.core.Keyword(null,"name","name",1843675177),name_6467__$1));

cljs.compiler.emitln.call(null,";");

cljs.compiler.emitln.call(null,mname_6468,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_6469,";");

cljs.compiler.emitln.call(null,"return ",mname_6468,";");

cljs.compiler.emitln.call(null,"})()");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__6516){
var map__6517 = p__6516;
var map__6517__$1 = (((((!((map__6517 == null))))?(((((map__6517.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6517.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6517):map__6517);
var variadic = cljs.core.get.call(null,map__6517__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.call(null,map__6517__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.call(null,map__6517__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.call(null,map__6517__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.call(null,map__6517__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.call(null,map__6517__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.call(null,map__6517__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.call(null,map__6517__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),cljs.core.filter.call(null,(function (p1__6513_SHARP_){
var and__4115__auto__ = p1__6513_SHARP_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__6513_SHARP_));
} else {
return and__4115__auto__;
}
}),recur_frames));
var loop_locals = cljs.core.seq.call(null,cljs.core.map.call(null,cljs.compiler.munge,cljs.core.concat.call(null,recur_params,(cljs.core.truth_((function (){var or__4126__auto__ = in_loop;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.seq.call(null,recur_params);
}
})())?cljs.core.mapcat.call(null,new cljs.core.Keyword(null,"params","params",710516235),loop_lets):null))));
if(loop_locals){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"((function (",cljs.compiler.comma_sep.call(null,cljs.core.map.call(null,cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.call(null,"return ");
}
} else {
}

if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method.call(null,cljs.core.assoc.call(null,cljs.core.first.call(null,methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_6570__$1 = (function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.gensym.call(null);
}
})();
var mname_6571 = cljs.compiler.munge.call(null,name_6570__$1);
var maxparams_6572 = cljs.core.apply.call(null,cljs.core.max_key,cljs.core.count,cljs.core.map.call(null,new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_6573 = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.call(null,cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_6571),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_6574 = cljs.core.sort_by.call(null,(function (p1__6514_SHARP_){
return cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second.call(null,p1__6514_SHARP_)));
}),cljs.core.seq.call(null,mmap_6573));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emitln.call(null,"(function() {");

cljs.compiler.emitln.call(null,"var ",mname_6571," = null;");

var seq__6519_6575 = cljs.core.seq.call(null,ms_6574);
var chunk__6520_6576 = null;
var count__6521_6577 = (0);
var i__6522_6578 = (0);
while(true){
if((i__6522_6578 < count__6521_6577)){
var vec__6529_6579 = cljs.core._nth.call(null,chunk__6520_6576,i__6522_6578);
var n_6580 = cljs.core.nth.call(null,vec__6529_6579,(0),null);
var meth_6581 = cljs.core.nth.call(null,vec__6529_6579,(1),null);
cljs.compiler.emits.call(null,"var ",n_6580," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_6581))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_6581);
} else {
cljs.compiler.emit_fn_method.call(null,meth_6581);
}

cljs.compiler.emitln.call(null,";");


var G__6582 = seq__6519_6575;
var G__6583 = chunk__6520_6576;
var G__6584 = count__6521_6577;
var G__6585 = (i__6522_6578 + (1));
seq__6519_6575 = G__6582;
chunk__6520_6576 = G__6583;
count__6521_6577 = G__6584;
i__6522_6578 = G__6585;
continue;
} else {
var temp__5735__auto___6586 = cljs.core.seq.call(null,seq__6519_6575);
if(temp__5735__auto___6586){
var seq__6519_6587__$1 = temp__5735__auto___6586;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6519_6587__$1)){
var c__4556__auto___6588 = cljs.core.chunk_first.call(null,seq__6519_6587__$1);
var G__6589 = cljs.core.chunk_rest.call(null,seq__6519_6587__$1);
var G__6590 = c__4556__auto___6588;
var G__6591 = cljs.core.count.call(null,c__4556__auto___6588);
var G__6592 = (0);
seq__6519_6575 = G__6589;
chunk__6520_6576 = G__6590;
count__6521_6577 = G__6591;
i__6522_6578 = G__6592;
continue;
} else {
var vec__6532_6593 = cljs.core.first.call(null,seq__6519_6587__$1);
var n_6594 = cljs.core.nth.call(null,vec__6532_6593,(0),null);
var meth_6595 = cljs.core.nth.call(null,vec__6532_6593,(1),null);
cljs.compiler.emits.call(null,"var ",n_6594," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_6595))){
cljs.compiler.emit_variadic_fn_method.call(null,meth_6595);
} else {
cljs.compiler.emit_fn_method.call(null,meth_6595);
}

cljs.compiler.emitln.call(null,";");


var G__6596 = cljs.core.next.call(null,seq__6519_6587__$1);
var G__6597 = null;
var G__6598 = (0);
var G__6599 = (0);
seq__6519_6575 = G__6596;
chunk__6520_6576 = G__6597;
count__6521_6577 = G__6598;
i__6522_6578 = G__6599;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,mname_6571," = function(",cljs.compiler.comma_sep.call(null,(cljs.core.truth_(variadic)?cljs.core.concat.call(null,cljs.core.butlast.call(null,maxparams_6572),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_6572)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,cljs.core.last.call(null,maxparams_6572));

cljs.compiler.emitln.call(null," = var_args;");
} else {
}

cljs.compiler.emitln.call(null,"switch(arguments.length){");

var seq__6535_6600 = cljs.core.seq.call(null,ms_6574);
var chunk__6536_6601 = null;
var count__6537_6602 = (0);
var i__6538_6603 = (0);
while(true){
if((i__6538_6603 < count__6537_6602)){
var vec__6545_6604 = cljs.core._nth.call(null,chunk__6536_6601,i__6538_6603);
var n_6605 = cljs.core.nth.call(null,vec__6545_6604,(0),null);
var meth_6606 = cljs.core.nth.call(null,vec__6545_6604,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_6606))){
cljs.compiler.emitln.call(null,"default:");

var restarg_6607 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_6607," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_6608 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_6607," = new cljs.core.IndexedSeq(",a_6608,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_6605,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_6572)),(((cljs.core.count.call(null,maxparams_6572) > (1)))?", ":null),restarg_6607,");");
} else {
var pcnt_6609 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_6606));
cljs.compiler.emitln.call(null,"case ",pcnt_6609,":");

cljs.compiler.emitln.call(null,"return ",n_6605,".call(this",(((pcnt_6609 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_6609,maxparams_6572)),null,(1),null)),(2),null))),");");
}


var G__6610 = seq__6535_6600;
var G__6611 = chunk__6536_6601;
var G__6612 = count__6537_6602;
var G__6613 = (i__6538_6603 + (1));
seq__6535_6600 = G__6610;
chunk__6536_6601 = G__6611;
count__6537_6602 = G__6612;
i__6538_6603 = G__6613;
continue;
} else {
var temp__5735__auto___6614 = cljs.core.seq.call(null,seq__6535_6600);
if(temp__5735__auto___6614){
var seq__6535_6615__$1 = temp__5735__auto___6614;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6535_6615__$1)){
var c__4556__auto___6616 = cljs.core.chunk_first.call(null,seq__6535_6615__$1);
var G__6617 = cljs.core.chunk_rest.call(null,seq__6535_6615__$1);
var G__6618 = c__4556__auto___6616;
var G__6619 = cljs.core.count.call(null,c__4556__auto___6616);
var G__6620 = (0);
seq__6535_6600 = G__6617;
chunk__6536_6601 = G__6618;
count__6537_6602 = G__6619;
i__6538_6603 = G__6620;
continue;
} else {
var vec__6548_6621 = cljs.core.first.call(null,seq__6535_6615__$1);
var n_6622 = cljs.core.nth.call(null,vec__6548_6621,(0),null);
var meth_6623 = cljs.core.nth.call(null,vec__6548_6621,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_6623))){
cljs.compiler.emitln.call(null,"default:");

var restarg_6624 = cljs.compiler.munge.call(null,cljs.core.gensym.call(null));
cljs.compiler.emitln.call(null,"var ",restarg_6624," = null;");

cljs.compiler.emitln.call(null,"if (arguments.length > ",max_fixed_arity,") {");

var a_6625 = cljs.compiler.emit_arguments_to_array.call(null,max_fixed_arity);
cljs.compiler.emitln.call(null,restarg_6624," = new cljs.core.IndexedSeq(",a_6625,",0,null);");

cljs.compiler.emitln.call(null,"}");

cljs.compiler.emitln.call(null,"return ",n_6622,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep.call(null,cljs.core.butlast.call(null,maxparams_6572)),(((cljs.core.count.call(null,maxparams_6572) > (1)))?", ":null),restarg_6624,");");
} else {
var pcnt_6626 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_6623));
cljs.compiler.emitln.call(null,"case ",pcnt_6626,":");

cljs.compiler.emitln.call(null,"return ",n_6622,".call(this",(((pcnt_6626 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,pcnt_6626,maxparams_6572)),null,(1),null)),(2),null))),");");
}


var G__6627 = cljs.core.next.call(null,seq__6535_6615__$1);
var G__6628 = null;
var G__6629 = (0);
var G__6630 = (0);
seq__6535_6600 = G__6627;
chunk__6536_6601 = G__6628;
count__6537_6602 = G__6629;
i__6538_6603 = G__6630;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"}");

var arg_count_js_6631 = ((cljs.core._EQ_.call(null,new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,cljs.core.first.call(null,ms_6574)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.call(null,"throw(new Error('Invalid arity: ' + ",arg_count_js_6631,"));");

cljs.compiler.emitln.call(null,"};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.call(null,mname_6571,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.call(null,mname_6571,".cljs$lang$applyTo = ",cljs.core.some.call(null,(function (p1__6515_SHARP_){
var vec__6551 = p1__6515_SHARP_;
var n = cljs.core.nth.call(null,vec__6551,(0),null);
var m = cljs.core.nth.call(null,vec__6551,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_6574),".cljs$lang$applyTo;");
} else {
}

var seq__6554_6632 = cljs.core.seq.call(null,ms_6574);
var chunk__6555_6633 = null;
var count__6556_6634 = (0);
var i__6557_6635 = (0);
while(true){
if((i__6557_6635 < count__6556_6634)){
var vec__6564_6636 = cljs.core._nth.call(null,chunk__6555_6633,i__6557_6635);
var n_6637 = cljs.core.nth.call(null,vec__6564_6636,(0),null);
var meth_6638 = cljs.core.nth.call(null,vec__6564_6636,(1),null);
var c_6639 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_6638));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_6638))){
cljs.compiler.emitln.call(null,mname_6571,".cljs$core$IFn$_invoke$arity$variadic = ",n_6637,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_6571,".cljs$core$IFn$_invoke$arity$",c_6639," = ",n_6637,";");
}


var G__6640 = seq__6554_6632;
var G__6641 = chunk__6555_6633;
var G__6642 = count__6556_6634;
var G__6643 = (i__6557_6635 + (1));
seq__6554_6632 = G__6640;
chunk__6555_6633 = G__6641;
count__6556_6634 = G__6642;
i__6557_6635 = G__6643;
continue;
} else {
var temp__5735__auto___6644 = cljs.core.seq.call(null,seq__6554_6632);
if(temp__5735__auto___6644){
var seq__6554_6645__$1 = temp__5735__auto___6644;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6554_6645__$1)){
var c__4556__auto___6646 = cljs.core.chunk_first.call(null,seq__6554_6645__$1);
var G__6647 = cljs.core.chunk_rest.call(null,seq__6554_6645__$1);
var G__6648 = c__4556__auto___6646;
var G__6649 = cljs.core.count.call(null,c__4556__auto___6646);
var G__6650 = (0);
seq__6554_6632 = G__6647;
chunk__6555_6633 = G__6648;
count__6556_6634 = G__6649;
i__6557_6635 = G__6650;
continue;
} else {
var vec__6567_6651 = cljs.core.first.call(null,seq__6554_6645__$1);
var n_6652 = cljs.core.nth.call(null,vec__6567_6651,(0),null);
var meth_6653 = cljs.core.nth.call(null,vec__6567_6651,(1),null);
var c_6654 = cljs.core.count.call(null,new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_6653));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_6653))){
cljs.compiler.emitln.call(null,mname_6571,".cljs$core$IFn$_invoke$arity$variadic = ",n_6652,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.call(null,mname_6571,".cljs$core$IFn$_invoke$arity$",c_6654," = ",n_6652,";");
}


var G__6655 = cljs.core.next.call(null,seq__6554_6645__$1);
var G__6656 = null;
var G__6657 = (0);
var G__6658 = (0);
seq__6554_6632 = G__6655;
chunk__6555_6633 = G__6656;
count__6556_6634 = G__6657;
i__6557_6635 = G__6658;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"return ",mname_6571,";");

cljs.compiler.emitln.call(null,"})()");
}

if(loop_locals){
return cljs.compiler.emitln.call(null,";})(",cljs.compiler.comma_sep.call(null,loop_locals),"))");
} else {
return null;
}
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"do","do",46310725),(function (p__6659){
var map__6660 = p__6659;
var map__6660__$1 = (((((!((map__6660 == null))))?(((((map__6660.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6660.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6660):map__6660);
var statements = cljs.core.get.call(null,map__6660__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.call(null,map__6660__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.call(null,map__6660__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.call(null,"(function (){");
} else {
}

var seq__6662_6666 = cljs.core.seq.call(null,statements);
var chunk__6663_6667 = null;
var count__6664_6668 = (0);
var i__6665_6669 = (0);
while(true){
if((i__6665_6669 < count__6664_6668)){
var s_6670 = cljs.core._nth.call(null,chunk__6663_6667,i__6665_6669);
cljs.compiler.emitln.call(null,s_6670);


var G__6671 = seq__6662_6666;
var G__6672 = chunk__6663_6667;
var G__6673 = count__6664_6668;
var G__6674 = (i__6665_6669 + (1));
seq__6662_6666 = G__6671;
chunk__6663_6667 = G__6672;
count__6664_6668 = G__6673;
i__6665_6669 = G__6674;
continue;
} else {
var temp__5735__auto___6675 = cljs.core.seq.call(null,seq__6662_6666);
if(temp__5735__auto___6675){
var seq__6662_6676__$1 = temp__5735__auto___6675;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6662_6676__$1)){
var c__4556__auto___6677 = cljs.core.chunk_first.call(null,seq__6662_6676__$1);
var G__6678 = cljs.core.chunk_rest.call(null,seq__6662_6676__$1);
var G__6679 = c__4556__auto___6677;
var G__6680 = cljs.core.count.call(null,c__4556__auto___6677);
var G__6681 = (0);
seq__6662_6666 = G__6678;
chunk__6663_6667 = G__6679;
count__6664_6668 = G__6680;
i__6665_6669 = G__6681;
continue;
} else {
var s_6682 = cljs.core.first.call(null,seq__6662_6676__$1);
cljs.compiler.emitln.call(null,s_6682);


var G__6683 = cljs.core.next.call(null,seq__6662_6676__$1);
var G__6684 = null;
var G__6685 = (0);
var G__6686 = (0);
seq__6662_6666 = G__6683;
chunk__6663_6667 = G__6684;
count__6664_6668 = G__6685;
i__6665_6669 = G__6686;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit.call(null,ret);

if(((cljs.core.seq.call(null,statements)) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.call(null,"})()");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__6687){
var map__6688 = p__6687;
var map__6688__$1 = (((((!((map__6688 == null))))?(((((map__6688.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6688.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6688):map__6688);
var try$ = cljs.core.get.call(null,map__6688__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.call(null,map__6688__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.call(null,map__6688__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.call(null,map__6688__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.call(null,map__6688__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

cljs.compiler.emits.call(null,"try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.call(null,"catch (",cljs.compiler.munge.call(null,name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote.call(null,finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.call(null,"finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.call(null,try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__6690,is_loop){
var map__6691 = p__6690;
var map__6691__$1 = (((((!((map__6691 == null))))?(((((map__6691.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6691.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6691):map__6691);
var expr = cljs.core.get.call(null,map__6691__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__6691__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__6691__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__6693_6707 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__6694_6708 = cljs.core.into.call(null,cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.call(null,(function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope.call(null,binding),cljs.core.gensym.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__6694_6708);

try{var seq__6695_6709 = cljs.core.seq.call(null,bindings);
var chunk__6696_6710 = null;
var count__6697_6711 = (0);
var i__6698_6712 = (0);
while(true){
if((i__6698_6712 < count__6697_6711)){
var map__6703_6713 = cljs.core._nth.call(null,chunk__6696_6710,i__6698_6712);
var map__6703_6714__$1 = (((((!((map__6703_6713 == null))))?(((((map__6703_6713.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6703_6713.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6703_6713):map__6703_6713);
var binding_6715 = map__6703_6714__$1;
var init_6716 = cljs.core.get.call(null,map__6703_6714__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_6715);

cljs.compiler.emitln.call(null," = ",init_6716,";");


var G__6717 = seq__6695_6709;
var G__6718 = chunk__6696_6710;
var G__6719 = count__6697_6711;
var G__6720 = (i__6698_6712 + (1));
seq__6695_6709 = G__6717;
chunk__6696_6710 = G__6718;
count__6697_6711 = G__6719;
i__6698_6712 = G__6720;
continue;
} else {
var temp__5735__auto___6721 = cljs.core.seq.call(null,seq__6695_6709);
if(temp__5735__auto___6721){
var seq__6695_6722__$1 = temp__5735__auto___6721;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6695_6722__$1)){
var c__4556__auto___6723 = cljs.core.chunk_first.call(null,seq__6695_6722__$1);
var G__6724 = cljs.core.chunk_rest.call(null,seq__6695_6722__$1);
var G__6725 = c__4556__auto___6723;
var G__6726 = cljs.core.count.call(null,c__4556__auto___6723);
var G__6727 = (0);
seq__6695_6709 = G__6724;
chunk__6696_6710 = G__6725;
count__6697_6711 = G__6726;
i__6698_6712 = G__6727;
continue;
} else {
var map__6705_6728 = cljs.core.first.call(null,seq__6695_6722__$1);
var map__6705_6729__$1 = (((((!((map__6705_6728 == null))))?(((((map__6705_6728.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6705_6728.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6705_6728):map__6705_6728);
var binding_6730 = map__6705_6729__$1;
var init_6731 = cljs.core.get.call(null,map__6705_6729__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.call(null,"var ");

cljs.compiler.emit.call(null,binding_6730);

cljs.compiler.emitln.call(null," = ",init_6731,";");


var G__6732 = cljs.core.next.call(null,seq__6695_6722__$1);
var G__6733 = null;
var G__6734 = (0);
var G__6735 = (0);
seq__6695_6709 = G__6732;
chunk__6696_6710 = G__6733;
count__6697_6711 = G__6734;
i__6698_6712 = G__6735;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"while(true){");
} else {
}

cljs.compiler.emits.call(null,expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.call(null,"break;");

cljs.compiler.emitln.call(null,"}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__6693_6707);
}
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let.call(null,ast,false);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let.call(null,ast,true);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__6736){
var map__6737 = p__6736;
var map__6737__$1 = (((((!((map__6737 == null))))?(((((map__6737.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6737.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6737):map__6737);
var frame = cljs.core.get.call(null,map__6737__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.call(null,map__6737__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.call(null,map__6737__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec.call(null,cljs.core.take.call(null,cljs.core.count.call(null,exprs),cljs.core.repeatedly.call(null,cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4613__auto___6739 = cljs.core.count.call(null,exprs);
var i_6740 = (0);
while(true){
if((i_6740 < n__4613__auto___6739)){
cljs.compiler.emitln.call(null,"var ",temps.call(null,i_6740)," = ",exprs.call(null,i_6740),";");

var G__6741 = (i_6740 + (1));
i_6740 = G__6741;
continue;
} else {
}
break;
}

var n__4613__auto___6742 = cljs.core.count.call(null,exprs);
var i_6743 = (0);
while(true){
if((i_6743 < n__4613__auto___6742)){
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,params.call(null,i_6743))," = ",temps.call(null,i_6743),";");

var G__6744 = (i_6743 + (1));
i_6743 = G__6744;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.call(null,"continue;");
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__6745){
var map__6746 = p__6745;
var map__6746__$1 = (((((!((map__6746 == null))))?(((((map__6746.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6746.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6746):map__6746);
var expr = cljs.core.get.call(null,map__6746__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.call(null,map__6746__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.call(null,map__6746__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.call(null,"(function (){");
} else {
}

var seq__6748_6760 = cljs.core.seq.call(null,bindings);
var chunk__6749_6761 = null;
var count__6750_6762 = (0);
var i__6751_6763 = (0);
while(true){
if((i__6751_6763 < count__6750_6762)){
var map__6756_6764 = cljs.core._nth.call(null,chunk__6749_6761,i__6751_6763);
var map__6756_6765__$1 = (((((!((map__6756_6764 == null))))?(((((map__6756_6764.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6756_6764.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6756_6764):map__6756_6764);
var binding_6766 = map__6756_6765__$1;
var init_6767 = cljs.core.get.call(null,map__6756_6765__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_6766)," = ",init_6767,";");


var G__6768 = seq__6748_6760;
var G__6769 = chunk__6749_6761;
var G__6770 = count__6750_6762;
var G__6771 = (i__6751_6763 + (1));
seq__6748_6760 = G__6768;
chunk__6749_6761 = G__6769;
count__6750_6762 = G__6770;
i__6751_6763 = G__6771;
continue;
} else {
var temp__5735__auto___6772 = cljs.core.seq.call(null,seq__6748_6760);
if(temp__5735__auto___6772){
var seq__6748_6773__$1 = temp__5735__auto___6772;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6748_6773__$1)){
var c__4556__auto___6774 = cljs.core.chunk_first.call(null,seq__6748_6773__$1);
var G__6775 = cljs.core.chunk_rest.call(null,seq__6748_6773__$1);
var G__6776 = c__4556__auto___6774;
var G__6777 = cljs.core.count.call(null,c__4556__auto___6774);
var G__6778 = (0);
seq__6748_6760 = G__6775;
chunk__6749_6761 = G__6776;
count__6750_6762 = G__6777;
i__6751_6763 = G__6778;
continue;
} else {
var map__6758_6779 = cljs.core.first.call(null,seq__6748_6773__$1);
var map__6758_6780__$1 = (((((!((map__6758_6779 == null))))?(((((map__6758_6779.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6758_6779.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6758_6779):map__6758_6779);
var binding_6781 = map__6758_6780__$1;
var init_6782 = cljs.core.get.call(null,map__6758_6780__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.call(null,"var ",cljs.compiler.munge.call(null,binding_6781)," = ",init_6782,";");


var G__6783 = cljs.core.next.call(null,seq__6748_6773__$1);
var G__6784 = null;
var G__6785 = (0);
var G__6786 = (0);
seq__6748_6760 = G__6783;
chunk__6749_6761 = G__6784;
count__6750_6762 = G__6785;
i__6751_6763 = G__6786;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.call(null,expr);

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.call(null,"})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__6789){
var map__6790 = p__6789;
var map__6790__$1 = (((((!((map__6790 == null))))?(((((map__6790.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6790.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6790):map__6790);
var expr = map__6790__$1;
var f = cljs.core.get.call(null,map__6790__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.call(null,map__6790__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__6790__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4115__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info))){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4115__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4115__auto__ = protocol;
if(cljs.core.truth_(and__4115__auto__)){
var and__4115__auto____$1 = tag;
if(cljs.core.truth_(and__4115__auto____$1)){
var or__4126__auto__ = (function (){var and__4115__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto____$2)){
var and__4115__auto____$3 = protocol;
if(cljs.core.truth_(and__4115__auto____$3)){
return cljs.core._EQ_.call(null,tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4115__auto____$3;
}
} else {
return and__4115__auto____$2;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto____$2 = (function (){var or__4126__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4115__auto____$2)){
var or__4126__auto____$1 = cljs.core._EQ_.call(null,protocol,tag);
if(or__4126__auto____$1){
return or__4126__auto____$1;
} else {
if((!(cljs.core.set_QMARK_.call(null,tag)))){
if(cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null).call(null,tag))){
var temp__5735__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var.call(null,env,cljs.core.vary_meta.call(null,tag,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true)));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return ps.call(null,protocol);
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4115__auto____$2;
}
}
} else {
return and__4115__auto____$1;
}
} else {
return and__4115__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag.call(null,env,cljs.core.first.call(null,new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.call(null,first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null).call(null,first_arg_tag))));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag.call(null,env,f);
var js_QMARK_ = (function (){var or__4126__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4126__auto____$1){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4126__auto__ = cljs.core._EQ_.call(null,ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.call(null,cljs.core.get.call(null,clojure.string.split.call(null,ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4126__auto__ = cljs.core._EQ_.call(null,new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4126__auto__){
return or__4126__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote.call(null,f);
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__6792 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count.call(null,args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not.call(null,variadic_QMARK_)) && (cljs.core._EQ_.call(null,cljs.core.count.call(null,mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return (arity > mfa);
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__6787_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__6787_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.call(null,cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.call(null,f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.call(null,cljs.core.assoc.call(null,info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__6788_SHARP_){
return cljs.core.dissoc.call(null,cljs.core.dissoc.call(null,p1__6788_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.call(null,vec__6792,(0),null);
var variadic_invoke = cljs.core.nth.call(null,vec__6792,(1),null);
var env__5894__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.call(null,"(!(",cljs.core.first.call(null,args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.call(null,"((",cljs.core.first.call(null,args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_6795 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.compiler.protocol_prefix.call(null,protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.call(null,cljs.core.name.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
cljs.compiler.emits.call(null,cljs.core.first.call(null,args),".",pimpl_6795,"(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",cljs.core.rest.call(null,args))),")");
} else {
if(keyword_QMARK_){
cljs.compiler.emits.call(null,f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count.call(null,args),"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_6796 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,cljs.core.take.call(null,mfa_6796,args)),(((mfa_6796 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.compiler.comma_sep.call(null,cljs.core.drop.call(null,mfa_6796,args)),"], 0))");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.call(null,f__$1,"(",cljs.compiler.comma_sep.call(null,args),")");
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null).call(null,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1));
} else {
return and__4115__auto__;
}
})())){
var fprop_6797 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.call(null,"(",f__$1,fprop_6797," ? ",f__$1,fprop_6797,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,"(",cljs.compiler.comma_sep.call(null,args),"))");
} else {
cljs.compiler.emits.call(null,"(",f__$1,fprop_6797," ? ",f__$1,fprop_6797,"(",cljs.compiler.comma_sep.call(null,args),") : ",f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),"))");
}
} else {
cljs.compiler.emits.call(null,f__$1,".call(",cljs.compiler.comma_sep.call(null,cljs.core.cons.call(null,"null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__6798){
var map__6799 = p__6798;
var map__6799__$1 = (((((!((map__6799 == null))))?(((((map__6799.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6799.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6799):map__6799);
var ctor = cljs.core.get.call(null,map__6799__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.call(null,map__6799__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__6799__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__5894__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(new ",ctor,"(",cljs.compiler.comma_sep.call(null,args),"))");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__6801){
var map__6802 = p__6801;
var map__6802__$1 = (((((!((map__6802 == null))))?(((((map__6802.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6802.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6802):map__6802);
var target = cljs.core.get.call(null,map__6802__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.call(null,map__6802__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.call(null,map__6802__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__5894__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

cljs.compiler.emits.call(null,"(",target," = ",val,")");

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_global_export.call(null,lib)," = goog.global",cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,(function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.call(null,cljs.core.name.call(null,(function (){var or__4126__auto__ = cljs.core.get.call(null,global_exports,cljs.core.symbol.call(null,lib));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,global_exports,cljs.core.name.call(null,lib));
}
})()),/\./))),";");
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__6804 = cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_);
var map__6804__$1 = (((((!((map__6804 == null))))?(((((map__6804.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6804.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6804):map__6804);
var options = cljs.core.get.call(null,map__6804__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.call(null,map__6804__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__6805 = options;
var map__6805__$1 = (((((!((map__6805 == null))))?(((((map__6805.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6805.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6805):map__6805);
var target = cljs.core.get.call(null,map__6805__$1,new cljs.core.Keyword(null,"target","target",253001721));
var nodejs_rt = cljs.core.get.call(null,map__6805__$1,new cljs.core.Keyword(null,"nodejs-rt","nodejs-rt",-512437071));
var optimizations = cljs.core.get.call(null,map__6805__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.call(null,cljs.core.gensym.call(null,new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__6806 = (function (){var libs__$1 = cljs.core.remove.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,seen)),cljs.core.filter.call(null,cljs.core.set.call(null,cljs.core.vals.call(null,libs)),deps));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__6811 = cljs.core.group_by.call(null,cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__6811__$1 = (((((!((map__6811 == null))))?(((((map__6811.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6811.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6811):map__6811);
var node_libs = cljs.core.get.call(null,map__6811__$1,true);
var libs_to_load = cljs.core.get.call(null,map__6811__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.call(null,vec__6806,(0),null);
var libs_to_load = cljs.core.nth.call(null,vec__6806,(1),null);
var global_exports_libs = cljs.core.filter.call(null,cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__6813_6833 = cljs.core.seq.call(null,libs_to_load);
var chunk__6814_6834 = null;
var count__6815_6835 = (0);
var i__6816_6836 = (0);
while(true){
if((i__6816_6836 < count__6815_6835)){
var lib_6837 = cljs.core._nth.call(null,chunk__6814_6834,i__6816_6836);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_6837)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_6837),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_6837),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_6837),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_6837),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_6837,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_6837),"');");
}

}
}
}


var G__6838 = seq__6813_6833;
var G__6839 = chunk__6814_6834;
var G__6840 = count__6815_6835;
var G__6841 = (i__6816_6836 + (1));
seq__6813_6833 = G__6838;
chunk__6814_6834 = G__6839;
count__6815_6835 = G__6840;
i__6816_6836 = G__6841;
continue;
} else {
var temp__5735__auto___6842 = cljs.core.seq.call(null,seq__6813_6833);
if(temp__5735__auto___6842){
var seq__6813_6843__$1 = temp__5735__auto___6842;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6813_6843__$1)){
var c__4556__auto___6844 = cljs.core.chunk_first.call(null,seq__6813_6843__$1);
var G__6845 = cljs.core.chunk_rest.call(null,seq__6813_6843__$1);
var G__6846 = c__4556__auto___6844;
var G__6847 = cljs.core.count.call(null,c__4556__auto___6844);
var G__6848 = (0);
seq__6813_6833 = G__6845;
chunk__6814_6834 = G__6846;
count__6815_6835 = G__6847;
i__6816_6836 = G__6848;
continue;
} else {
var lib_6849 = cljs.core.first.call(null,seq__6813_6843__$1);
if(((cljs.analyzer.foreign_dep_QMARK_.call(null,lib_6849)) && ((!(cljs.core.keyword_identical_QMARK_.call(null,optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_6849),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_6849),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,cljs.core.get.call(null,reloads,lib_6849),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_6849),"', 'reload-all');");
} else {
if(cljs.core._EQ_.call(null,lib_6849,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,lib_6849),"');");
}

}
}
}


var G__6850 = cljs.core.next.call(null,seq__6813_6843__$1);
var G__6851 = null;
var G__6852 = (0);
var G__6853 = (0);
seq__6813_6833 = G__6850;
chunk__6814_6834 = G__6851;
count__6815_6835 = G__6852;
i__6816_6836 = G__6853;
continue;
}
} else {
}
}
break;
}

var seq__6817_6854 = cljs.core.seq.call(null,node_libs);
var chunk__6818_6855 = null;
var count__6819_6856 = (0);
var i__6820_6857 = (0);
while(true){
if((i__6820_6857 < count__6819_6856)){
var lib_6858 = cljs.core._nth.call(null,chunk__6818_6855,i__6820_6857);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_6858)," = require('",lib_6858,"');");


var G__6859 = seq__6817_6854;
var G__6860 = chunk__6818_6855;
var G__6861 = count__6819_6856;
var G__6862 = (i__6820_6857 + (1));
seq__6817_6854 = G__6859;
chunk__6818_6855 = G__6860;
count__6819_6856 = G__6861;
i__6820_6857 = G__6862;
continue;
} else {
var temp__5735__auto___6863 = cljs.core.seq.call(null,seq__6817_6854);
if(temp__5735__auto___6863){
var seq__6817_6864__$1 = temp__5735__auto___6863;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6817_6864__$1)){
var c__4556__auto___6865 = cljs.core.chunk_first.call(null,seq__6817_6864__$1);
var G__6866 = cljs.core.chunk_rest.call(null,seq__6817_6864__$1);
var G__6867 = c__4556__auto___6865;
var G__6868 = cljs.core.count.call(null,c__4556__auto___6865);
var G__6869 = (0);
seq__6817_6854 = G__6866;
chunk__6818_6855 = G__6867;
count__6819_6856 = G__6868;
i__6820_6857 = G__6869;
continue;
} else {
var lib_6870 = cljs.core.first.call(null,seq__6817_6864__$1);
cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,ns_name),".",cljs.analyzer.munge_node_lib.call(null,lib_6870)," = require('",lib_6870,"');");


var G__6871 = cljs.core.next.call(null,seq__6817_6864__$1);
var G__6872 = null;
var G__6873 = (0);
var G__6874 = (0);
seq__6817_6854 = G__6871;
chunk__6818_6855 = G__6872;
count__6819_6856 = G__6873;
i__6820_6857 = G__6874;
continue;
}
} else {
}
}
break;
}

var seq__6821_6875 = cljs.core.seq.call(null,global_exports_libs);
var chunk__6822_6876 = null;
var count__6823_6877 = (0);
var i__6824_6878 = (0);
while(true){
if((i__6824_6878 < count__6823_6877)){
var lib_6879 = cljs.core._nth.call(null,chunk__6822_6876,i__6824_6878);
var map__6829_6880 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,lib_6879));
var map__6829_6881__$1 = (((((!((map__6829_6880 == null))))?(((((map__6829_6880.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6829_6880.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6829_6880):map__6829_6880);
var global_exports_6882 = cljs.core.get.call(null,map__6829_6881__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_6882,lib_6879);


var G__6883 = seq__6821_6875;
var G__6884 = chunk__6822_6876;
var G__6885 = count__6823_6877;
var G__6886 = (i__6824_6878 + (1));
seq__6821_6875 = G__6883;
chunk__6822_6876 = G__6884;
count__6823_6877 = G__6885;
i__6824_6878 = G__6886;
continue;
} else {
var temp__5735__auto___6887 = cljs.core.seq.call(null,seq__6821_6875);
if(temp__5735__auto___6887){
var seq__6821_6888__$1 = temp__5735__auto___6887;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6821_6888__$1)){
var c__4556__auto___6889 = cljs.core.chunk_first.call(null,seq__6821_6888__$1);
var G__6890 = cljs.core.chunk_rest.call(null,seq__6821_6888__$1);
var G__6891 = c__4556__auto___6889;
var G__6892 = cljs.core.count.call(null,c__4556__auto___6889);
var G__6893 = (0);
seq__6821_6875 = G__6890;
chunk__6822_6876 = G__6891;
count__6823_6877 = G__6892;
i__6824_6878 = G__6893;
continue;
} else {
var lib_6894 = cljs.core.first.call(null,seq__6821_6888__$1);
var map__6831_6895 = cljs.core.get.call(null,js_dependency_index,cljs.core.name.call(null,lib_6894));
var map__6831_6896__$1 = (((((!((map__6831_6895 == null))))?(((((map__6831_6895.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6831_6895.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6831_6895):map__6831_6895);
var global_exports_6897 = cljs.core.get.call(null,map__6831_6896__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export.call(null,ns_name,global_exports_6897,lib_6894);


var G__6898 = cljs.core.next.call(null,seq__6821_6888__$1);
var G__6899 = null;
var G__6900 = (0);
var G__6901 = (0);
seq__6821_6875 = G__6898;
chunk__6822_6876 = G__6899;
count__6823_6877 = G__6900;
i__6824_6878 = G__6901;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,libs)))){
return cljs.compiler.emitln.call(null,"if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",loaded_libs,");");
} else {
return null;
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__6902){
var map__6903 = p__6902;
var map__6903__$1 = (((((!((map__6903 == null))))?(((((map__6903.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6903.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6903):map__6903);
var name = cljs.core.get.call(null,map__6903__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__6903__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__6903__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__6903__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__6903__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__6903__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__6903__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.call(null,"'nil';");
} else {
return null;
}
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__6905){
var map__6906 = p__6905;
var map__6906__$1 = (((((!((map__6906 == null))))?(((((map__6906.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6906.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6906):map__6906);
var name = cljs.core.get.call(null,map__6906__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.call(null,map__6906__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.call(null,map__6906__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.call(null,map__6906__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.call(null,map__6906__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.call(null,map__6906__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.call(null,map__6906__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,name),"');");

if(cljs.core._EQ_.call(null,name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.call(null,"goog.require('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs.call(null,requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs.call(null,uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__6908){
var map__6909 = p__6908;
var map__6909__$1 = (((((!((map__6909 == null))))?(((((map__6909.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__6909.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__6909):map__6909);
var t = cljs.core.get.call(null,map__6909__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__6909__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__6909__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__6909__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__6909__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.call(null,cljs.compiler.munge,fields);
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__6911_6935 = cljs.core.seq.call(null,protocols);
var chunk__6912_6936 = null;
var count__6913_6937 = (0);
var i__6914_6938 = (0);
while(true){
if((i__6914_6938 < count__6913_6937)){
var protocol_6939 = cljs.core._nth.call(null,chunk__6912_6936,i__6914_6938);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_6939)),"}");


var G__6940 = seq__6911_6935;
var G__6941 = chunk__6912_6936;
var G__6942 = count__6913_6937;
var G__6943 = (i__6914_6938 + (1));
seq__6911_6935 = G__6940;
chunk__6912_6936 = G__6941;
count__6913_6937 = G__6942;
i__6914_6938 = G__6943;
continue;
} else {
var temp__5735__auto___6944 = cljs.core.seq.call(null,seq__6911_6935);
if(temp__5735__auto___6944){
var seq__6911_6945__$1 = temp__5735__auto___6944;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6911_6945__$1)){
var c__4556__auto___6946 = cljs.core.chunk_first.call(null,seq__6911_6945__$1);
var G__6947 = cljs.core.chunk_rest.call(null,seq__6911_6945__$1);
var G__6948 = c__4556__auto___6946;
var G__6949 = cljs.core.count.call(null,c__4556__auto___6946);
var G__6950 = (0);
seq__6911_6935 = G__6947;
chunk__6912_6936 = G__6948;
count__6913_6937 = G__6949;
i__6914_6938 = G__6950;
continue;
} else {
var protocol_6951 = cljs.core.first.call(null,seq__6911_6945__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_6951)),"}");


var G__6952 = cljs.core.next.call(null,seq__6911_6945__$1);
var G__6953 = null;
var G__6954 = (0);
var G__6955 = (0);
seq__6911_6935 = G__6952;
chunk__6912_6936 = G__6953;
count__6913_6937 = G__6954;
i__6914_6938 = G__6955;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__6915_6956 = cljs.core.seq.call(null,fields__$1);
var chunk__6916_6957 = null;
var count__6917_6958 = (0);
var i__6918_6959 = (0);
while(true){
if((i__6918_6959 < count__6917_6958)){
var fld_6960 = cljs.core._nth.call(null,chunk__6916_6957,i__6918_6959);
cljs.compiler.emitln.call(null,"this.",fld_6960," = ",fld_6960,";");


var G__6961 = seq__6915_6956;
var G__6962 = chunk__6916_6957;
var G__6963 = count__6917_6958;
var G__6964 = (i__6918_6959 + (1));
seq__6915_6956 = G__6961;
chunk__6916_6957 = G__6962;
count__6917_6958 = G__6963;
i__6918_6959 = G__6964;
continue;
} else {
var temp__5735__auto___6965 = cljs.core.seq.call(null,seq__6915_6956);
if(temp__5735__auto___6965){
var seq__6915_6966__$1 = temp__5735__auto___6965;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6915_6966__$1)){
var c__4556__auto___6967 = cljs.core.chunk_first.call(null,seq__6915_6966__$1);
var G__6968 = cljs.core.chunk_rest.call(null,seq__6915_6966__$1);
var G__6969 = c__4556__auto___6967;
var G__6970 = cljs.core.count.call(null,c__4556__auto___6967);
var G__6971 = (0);
seq__6915_6956 = G__6968;
chunk__6916_6957 = G__6969;
count__6917_6958 = G__6970;
i__6918_6959 = G__6971;
continue;
} else {
var fld_6972 = cljs.core.first.call(null,seq__6915_6966__$1);
cljs.compiler.emitln.call(null,"this.",fld_6972," = ",fld_6972,";");


var G__6973 = cljs.core.next.call(null,seq__6915_6966__$1);
var G__6974 = null;
var G__6975 = (0);
var G__6976 = (0);
seq__6915_6956 = G__6973;
chunk__6916_6957 = G__6974;
count__6917_6958 = G__6975;
i__6918_6959 = G__6976;
continue;
}
} else {
}
}
break;
}

var seq__6919_6977 = cljs.core.seq.call(null,pmasks);
var chunk__6920_6978 = null;
var count__6921_6979 = (0);
var i__6922_6980 = (0);
while(true){
if((i__6922_6980 < count__6921_6979)){
var vec__6929_6981 = cljs.core._nth.call(null,chunk__6920_6978,i__6922_6980);
var pno_6982 = cljs.core.nth.call(null,vec__6929_6981,(0),null);
var pmask_6983 = cljs.core.nth.call(null,vec__6929_6981,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_6982,"$ = ",pmask_6983,";");


var G__6984 = seq__6919_6977;
var G__6985 = chunk__6920_6978;
var G__6986 = count__6921_6979;
var G__6987 = (i__6922_6980 + (1));
seq__6919_6977 = G__6984;
chunk__6920_6978 = G__6985;
count__6921_6979 = G__6986;
i__6922_6980 = G__6987;
continue;
} else {
var temp__5735__auto___6988 = cljs.core.seq.call(null,seq__6919_6977);
if(temp__5735__auto___6988){
var seq__6919_6989__$1 = temp__5735__auto___6988;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__6919_6989__$1)){
var c__4556__auto___6990 = cljs.core.chunk_first.call(null,seq__6919_6989__$1);
var G__6991 = cljs.core.chunk_rest.call(null,seq__6919_6989__$1);
var G__6992 = c__4556__auto___6990;
var G__6993 = cljs.core.count.call(null,c__4556__auto___6990);
var G__6994 = (0);
seq__6919_6977 = G__6991;
chunk__6920_6978 = G__6992;
count__6921_6979 = G__6993;
i__6922_6980 = G__6994;
continue;
} else {
var vec__6932_6995 = cljs.core.first.call(null,seq__6919_6989__$1);
var pno_6996 = cljs.core.nth.call(null,vec__6932_6995,(0),null);
var pmask_6997 = cljs.core.nth.call(null,vec__6932_6995,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_6996,"$ = ",pmask_6997,";");


var G__6998 = cljs.core.next.call(null,seq__6919_6989__$1);
var G__6999 = null;
var G__7000 = (0);
var G__7001 = (0);
seq__6919_6977 = G__6998;
chunk__6920_6978 = G__6999;
count__6921_6979 = G__7000;
i__6922_6980 = G__7001;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__7002){
var map__7003 = p__7002;
var map__7003__$1 = (((((!((map__7003 == null))))?(((((map__7003.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7003.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7003):map__7003);
var t = cljs.core.get.call(null,map__7003__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.call(null,map__7003__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.call(null,map__7003__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.call(null,map__7003__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.call(null,map__7003__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.call(null,cljs.core.map.call(null,cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.call(null,"");

cljs.compiler.emitln.call(null,"/**");

cljs.compiler.emitln.call(null,"* @constructor");

var seq__7005_7029 = cljs.core.seq.call(null,protocols);
var chunk__7006_7030 = null;
var count__7007_7031 = (0);
var i__7008_7032 = (0);
while(true){
if((i__7008_7032 < count__7007_7031)){
var protocol_7033 = cljs.core._nth.call(null,chunk__7006_7030,i__7008_7032);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7033)),"}");


var G__7034 = seq__7005_7029;
var G__7035 = chunk__7006_7030;
var G__7036 = count__7007_7031;
var G__7037 = (i__7008_7032 + (1));
seq__7005_7029 = G__7034;
chunk__7006_7030 = G__7035;
count__7007_7031 = G__7036;
i__7008_7032 = G__7037;
continue;
} else {
var temp__5735__auto___7038 = cljs.core.seq.call(null,seq__7005_7029);
if(temp__5735__auto___7038){
var seq__7005_7039__$1 = temp__5735__auto___7038;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7005_7039__$1)){
var c__4556__auto___7040 = cljs.core.chunk_first.call(null,seq__7005_7039__$1);
var G__7041 = cljs.core.chunk_rest.call(null,seq__7005_7039__$1);
var G__7042 = c__4556__auto___7040;
var G__7043 = cljs.core.count.call(null,c__4556__auto___7040);
var G__7044 = (0);
seq__7005_7029 = G__7041;
chunk__7006_7030 = G__7042;
count__7007_7031 = G__7043;
i__7008_7032 = G__7044;
continue;
} else {
var protocol_7045 = cljs.core.first.call(null,seq__7005_7039__$1);
cljs.compiler.emitln.call(null," * @implements {",cljs.compiler.munge.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_7045)),"}");


var G__7046 = cljs.core.next.call(null,seq__7005_7039__$1);
var G__7047 = null;
var G__7048 = (0);
var G__7049 = (0);
seq__7005_7029 = G__7046;
chunk__7006_7030 = G__7047;
count__7007_7031 = G__7048;
i__7008_7032 = G__7049;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"*/");

cljs.compiler.emitln.call(null,cljs.compiler.munge.call(null,t)," = (function (",cljs.compiler.comma_sep.call(null,fields__$1),"){");

var seq__7009_7050 = cljs.core.seq.call(null,fields__$1);
var chunk__7010_7051 = null;
var count__7011_7052 = (0);
var i__7012_7053 = (0);
while(true){
if((i__7012_7053 < count__7011_7052)){
var fld_7054 = cljs.core._nth.call(null,chunk__7010_7051,i__7012_7053);
cljs.compiler.emitln.call(null,"this.",fld_7054," = ",fld_7054,";");


var G__7055 = seq__7009_7050;
var G__7056 = chunk__7010_7051;
var G__7057 = count__7011_7052;
var G__7058 = (i__7012_7053 + (1));
seq__7009_7050 = G__7055;
chunk__7010_7051 = G__7056;
count__7011_7052 = G__7057;
i__7012_7053 = G__7058;
continue;
} else {
var temp__5735__auto___7059 = cljs.core.seq.call(null,seq__7009_7050);
if(temp__5735__auto___7059){
var seq__7009_7060__$1 = temp__5735__auto___7059;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7009_7060__$1)){
var c__4556__auto___7061 = cljs.core.chunk_first.call(null,seq__7009_7060__$1);
var G__7062 = cljs.core.chunk_rest.call(null,seq__7009_7060__$1);
var G__7063 = c__4556__auto___7061;
var G__7064 = cljs.core.count.call(null,c__4556__auto___7061);
var G__7065 = (0);
seq__7009_7050 = G__7062;
chunk__7010_7051 = G__7063;
count__7011_7052 = G__7064;
i__7012_7053 = G__7065;
continue;
} else {
var fld_7066 = cljs.core.first.call(null,seq__7009_7060__$1);
cljs.compiler.emitln.call(null,"this.",fld_7066," = ",fld_7066,";");


var G__7067 = cljs.core.next.call(null,seq__7009_7060__$1);
var G__7068 = null;
var G__7069 = (0);
var G__7070 = (0);
seq__7009_7050 = G__7067;
chunk__7010_7051 = G__7068;
count__7011_7052 = G__7069;
i__7012_7053 = G__7070;
continue;
}
} else {
}
}
break;
}

var seq__7013_7071 = cljs.core.seq.call(null,pmasks);
var chunk__7014_7072 = null;
var count__7015_7073 = (0);
var i__7016_7074 = (0);
while(true){
if((i__7016_7074 < count__7015_7073)){
var vec__7023_7075 = cljs.core._nth.call(null,chunk__7014_7072,i__7016_7074);
var pno_7076 = cljs.core.nth.call(null,vec__7023_7075,(0),null);
var pmask_7077 = cljs.core.nth.call(null,vec__7023_7075,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7076,"$ = ",pmask_7077,";");


var G__7078 = seq__7013_7071;
var G__7079 = chunk__7014_7072;
var G__7080 = count__7015_7073;
var G__7081 = (i__7016_7074 + (1));
seq__7013_7071 = G__7078;
chunk__7014_7072 = G__7079;
count__7015_7073 = G__7080;
i__7016_7074 = G__7081;
continue;
} else {
var temp__5735__auto___7082 = cljs.core.seq.call(null,seq__7013_7071);
if(temp__5735__auto___7082){
var seq__7013_7083__$1 = temp__5735__auto___7082;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7013_7083__$1)){
var c__4556__auto___7084 = cljs.core.chunk_first.call(null,seq__7013_7083__$1);
var G__7085 = cljs.core.chunk_rest.call(null,seq__7013_7083__$1);
var G__7086 = c__4556__auto___7084;
var G__7087 = cljs.core.count.call(null,c__4556__auto___7084);
var G__7088 = (0);
seq__7013_7071 = G__7085;
chunk__7014_7072 = G__7086;
count__7015_7073 = G__7087;
i__7016_7074 = G__7088;
continue;
} else {
var vec__7026_7089 = cljs.core.first.call(null,seq__7013_7083__$1);
var pno_7090 = cljs.core.nth.call(null,vec__7026_7089,(0),null);
var pmask_7091 = cljs.core.nth.call(null,vec__7026_7089,(1),null);
cljs.compiler.emitln.call(null,"this.cljs$lang$protocol_mask$partition",pno_7090,"$ = ",pmask_7091,";");


var G__7092 = cljs.core.next.call(null,seq__7013_7083__$1);
var G__7093 = null;
var G__7094 = (0);
var G__7095 = (0);
seq__7013_7071 = G__7092;
chunk__7014_7072 = G__7093;
count__7015_7073 = G__7094;
i__7016_7074 = G__7095;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.call(null,"});");

return cljs.compiler.emit.call(null,body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__7096){
var map__7097 = p__7096;
var map__7097__$1 = (((((!((map__7097 == null))))?(((((map__7097.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7097.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7097):map__7097);
var target = cljs.core.get.call(null,map__7097__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.call(null,map__7097__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.call(null,map__7097__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.call(null,map__7097__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.call(null,map__7097__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__5894__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.call(null,target,".",cljs.compiler.munge.call(null,method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep.call(null,args),")");
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
});
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot.call(null,ast);
}));
cljs.core._add_method.call(null,cljs.compiler.emit_STAR_,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__7099){
var map__7100 = p__7099;
var map__7100__$1 = (((((!((map__7100 == null))))?(((((map__7100.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7100.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7100):map__7100);
var op = cljs.core.get.call(null,map__7100__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.call(null,map__7100__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.call(null,map__7100__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.call(null,map__7100__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.call(null,map__7100__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4115__auto__ = code;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(clojure.string.trim.call(null,code),"/*");
} else {
return and__4115__auto__;
}
})())){
return cljs.compiler.emits.call(null,code);
} else {
var env__5894__auto__ = env;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
cljs.compiler.emits.call(null,"return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.call(null,code);
} else {
cljs.compiler.emits.call(null,cljs.core.interleave.call(null,cljs.core.concat.call(null,segs,cljs.core.repeat.call(null,null)),cljs.core.concat.call(null,args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__5894__auto__))){
return null;
} else {
return cljs.compiler.emitln.call(null,";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.call(null,"goog.provide('",cljs.compiler.munge.call(null,cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.call(null,"goog.require('cljs.core');");

var seq__7106 = cljs.core.seq.call(null,table);
var chunk__7107 = null;
var count__7108 = (0);
var i__7109 = (0);
while(true){
if((i__7109 < count__7108)){
var vec__7116 = cljs.core._nth.call(null,chunk__7107,i__7109);
var sym = cljs.core.nth.call(null,vec__7116,(0),null);
var value = cljs.core.nth.call(null,vec__7116,(1),null);
var ns_7122 = cljs.core.namespace.call(null,sym);
var name_7123 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__7124 = seq__7106;
var G__7125 = chunk__7107;
var G__7126 = count__7108;
var G__7127 = (i__7109 + (1));
seq__7106 = G__7124;
chunk__7107 = G__7125;
count__7108 = G__7126;
i__7109 = G__7127;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__7106);
if(temp__5735__auto__){
var seq__7106__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__7106__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__7106__$1);
var G__7128 = cljs.core.chunk_rest.call(null,seq__7106__$1);
var G__7129 = c__4556__auto__;
var G__7130 = cljs.core.count.call(null,c__4556__auto__);
var G__7131 = (0);
seq__7106 = G__7128;
chunk__7107 = G__7129;
count__7108 = G__7130;
i__7109 = G__7131;
continue;
} else {
var vec__7119 = cljs.core.first.call(null,seq__7106__$1);
var sym = cljs.core.nth.call(null,vec__7119,(0),null);
var value = cljs.core.nth.call(null,vec__7119,(1),null);
var ns_7132 = cljs.core.namespace.call(null,sym);
var name_7133 = cljs.core.name.call(null,sym);
cljs.compiler.emits.call(null,"cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword.call(null,sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol.call(null,sym);
} else {
throw cljs.core.ex_info.call(null,["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.call(null,";\n");


var G__7134 = cljs.core.next.call(null,seq__7106__$1);
var G__7135 = null;
var G__7136 = (0);
var G__7137 = (0);
seq__7106 = G__7134;
chunk__7107 = G__7135;
count__7108 = G__7136;
i__7109 = G__7137;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__7139 = arguments.length;
switch (G__7139) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.call(null,cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.call(null,cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs.call(null):null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq.call(null,cljs.core.keys.call(null,externs));
while(true){
if(ks){
var k_7144 = cljs.core.first.call(null,ks);
var vec__7140_7145 = cljs.core.conj.call(null,prefix,k_7144);
var top_7146 = cljs.core.nth.call(null,vec__7140_7145,(0),null);
var prefix_SINGLEQUOTE__7147 = vec__7140_7145;
if(((cljs.core.not_EQ_.call(null,new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_7144)) && ((cljs.core.get_in.call(null,known_externs,prefix_SINGLEQUOTE__7147) == null)))){
if((!(((cljs.core.contains_QMARK_.call(null,cljs.core.deref.call(null,top_level),top_7146)) || (cljs.core.contains_QMARK_.call(null,known_externs,top_7146)))))){
cljs.compiler.emitln.call(null,"var ",clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__7147)),";");

cljs.core.swap_BANG_.call(null,top_level,cljs.core.conj,top_7146);
} else {
cljs.compiler.emitln.call(null,clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.compiler.munge,prefix_SINGLEQUOTE__7147)),";");
}
} else {
}

var m_7148 = cljs.core.get.call(null,externs,k_7144);
if(cljs.core.empty_QMARK_.call(null,m_7148)){
} else {
cljs.compiler.emit_externs.call(null,prefix_SINGLEQUOTE__7147,m_7148,top_level,known_externs);
}

var G__7149 = cljs.core.next.call(null,ks);
ks = G__7149;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

