// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.call(null,(function (m,p__4792){
var vec__4793 = p__4792;
var i = cljs.core.nth.call(null,vec__4793,(0),null);
var v = cljs.core.nth.call(null,vec__4793,(1),null);
return cljs.core.assoc.call(null,m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.call(null,(function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources.call(null,sources);
return (function (a,b){
return cljs.core.compare.call(null,sources__$1.call(null,a),sources__$1.call(null,b));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__4796 = seg;
var gcol = cljs.core.nth.call(null,vec__4796,(0),null);
var source = cljs.core.nth.call(null,vec__4796,(1),null);
var line = cljs.core.nth.call(null,vec__4796,(2),null);
var col = cljs.core.nth.call(null,vec__4796,(3),null);
var name = cljs.core.nth.call(null,vec__4796,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol,new cljs.core.Keyword(null,"source","source",-433931539),(goog.object.get(source_map,"sources")[source]),new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"name","name",1843675177),(function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.meta.call(null,seg));
if(cljs.core.truth_(temp__5735__auto__)){
var name__$1 = temp__5735__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__4799 = seg;
var gcol = cljs.core.nth.call(null,vec__4799,(0),null);
var source = cljs.core.nth.call(null,vec__4799,(1),null);
var line = cljs.core.nth.call(null,vec__4799,(2),null);
var col = cljs.core.nth.call(null,vec__4799,(3),null);
var name = cljs.core.nth.call(null,vec__4799,(4),null);
var vec__4802 = relseg;
var rgcol = cljs.core.nth.call(null,vec__4802,(0),null);
var rsource = cljs.core.nth.call(null,vec__4802,(1),null);
var rline = cljs.core.nth.call(null,vec__4802,(2),null);
var rcol = cljs.core.nth.call(null,vec__4802,(3),null);
var rname = cljs.core.nth.call(null,vec__4802,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4126__auto__ = source;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4126__auto__ = line;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4126__auto__ = col;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta.call(null,nseg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__4805 = segmap;
var map__4805__$1 = (((((!((map__4805 == null))))?(((((map__4805.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4805.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4805):map__4805);
var gcol = cljs.core.get.call(null,map__4805__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__4805__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__4805__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__4805__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__4805__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gline","gline",-1086242431),gline,new cljs.core.Keyword(null,"gcol","gcol",309250807),gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.call(null,(function (m__$1){
return cljs.core.update_in.call(null,m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.call(null,(function (v){
return cljs.core.conj.call(null,v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__4808 = arguments.length;
switch (G__4808) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.call(null,goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by.call(null,cljs.source_map.source_compare.call(null,sources));
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__4812 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__4816 = cljs.core.next.call(null,segs__$1);
var G__4817 = nrelseg;
var G__4818 = cljs.source_map.update_reverse_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__4816;
relseg__$1 = G__4817;
result__$1 = G__4818;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__4812,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__4812,(1),null);
var G__4819 = (gline + (1));
var G__4820 = cljs.core.next.call(null,lines__$1);
var G__4821 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__4822 = result__$1;
gline = G__4819;
lines__$1 = G__4820;
relseg = G__4821;
result = G__4822;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__4824 = segmap;
var map__4824__$1 = (((((!((map__4824 == null))))?(((((map__4824.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4824.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4824):map__4824);
var gcol = cljs.core.get.call(null,map__4824__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var source = cljs.core.get.call(null,map__4824__$1,new cljs.core.Keyword(null,"source","source",-433931539));
var line = cljs.core.get.call(null,map__4824__$1,new cljs.core.Keyword(null,"line","line",212345235));
var col = cljs.core.get.call(null,map__4824__$1,new cljs.core.Keyword(null,"col","col",-1959363084));
var name = cljs.core.get.call(null,map__4824__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var d = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line,new cljs.core.Keyword(null,"col","col",-1959363084),col,new cljs.core.Keyword(null,"source","source",-433931539),source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.call(null,d,new cljs.core.Keyword(null,"name","name",1843675177),name):d);
return cljs.core.update_in.call(null,result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.call(null,(function (m){
return cljs.core.update_in.call(null,m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.call(null,(function (p1__4823_SHARP_){
return cljs.core.conj.call(null,p1__4823_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map.call(null)));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__4827 = arguments.length;
switch (G__4827) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.call(null,goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq.call(null,clojure.string.split.call(null,mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first.call(null,lines__$1);
var vec__4831 = ((clojure.string.blank_QMARK_.call(null,line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq.call(null,clojure.string.split.call(null,line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first.call(null,segs__$1);
var nrelseg = cljs.source_map.seg_combine.call(null,cljs.source_map.base64_vlq.decode.call(null,seg),relseg__$1);
var G__4835 = cljs.core.next.call(null,segs__$1);
var G__4836 = nrelseg;
var G__4837 = cljs.source_map.update_result.call(null,result__$1,cljs.source_map.seg__GT_map.call(null,nrelseg,source_map),gline);
segs__$1 = G__4835;
relseg__$1 = G__4836;
result__$1 = G__4837;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.call(null,vec__4831,(0),null);
var relseg__$1 = cljs.core.nth.call(null,vec__4831,(1),null);
var G__4838 = (gline + (1));
var G__4839 = cljs.core.next.call(null,lines__$1);
var G__4840 = cljs.core.assoc.call(null,relseg__$1,(0),(0));
var G__4841 = result__$1;
gline = G__4838;
lines__$1 = G__4839;
relseg = G__4840;
result = G__4841;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.call(null,(function (segs,cols){
cljs.core.swap_BANG_.call(null,relseg,(function (p__4842){
var vec__4843 = p__4842;
var _ = cljs.core.nth.call(null,vec__4843,(0),null);
var source = cljs.core.nth.call(null,vec__4843,(1),null);
var line = cljs.core.nth.call(null,vec__4843,(2),null);
var col = cljs.core.nth.call(null,vec__4843,(3),null);
var name = cljs.core.nth.call(null,vec__4843,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.call(null,segs,cljs.core.reduce.call(null,(function (cols__$1,p__4846){
var vec__4847 = p__4846;
var gcol = cljs.core.nth.call(null,vec__4847,(0),null);
var sidx = cljs.core.nth.call(null,vec__4847,(1),null);
var line = cljs.core.nth.call(null,vec__4847,(2),null);
var col = cljs.core.nth.call(null,vec__4847,(3),null);
var name = cljs.core.nth.call(null,vec__4847,(4),null);
var seg = vec__4847;
var offset = cljs.core.map.call(null,cljs.core._,seg,cljs.core.deref.call(null,relseg));
cljs.core.swap_BANG_.call(null,relseg,(function (p__4850){
var vec__4851 = p__4850;
var _ = cljs.core.nth.call(null,vec__4851,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__4851,(1),null);
var ___$2 = cljs.core.nth.call(null,vec__4851,(2),null);
var ___$3 = cljs.core.nth.call(null,vec__4851,(3),null);
var lname = cljs.core.nth.call(null,vec__4851,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.call(null,cols__$1,cljs.source_map.base64_vlq.encode.call(null,offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.call(null,(0));
var preamble_lines = cljs.core.take.call(null,(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"preamble-line-count","preamble-line-count",-659949744).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.call(null,cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"gcol","gcol",309250807).cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5733__auto__ = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5733__auto__)){
var name = temp__5733__auto__;
var idx = (function (){var temp__5733__auto____$1 = cljs.core.get.call(null,cljs.core.deref.call(null,names__GT_idx),name);
if(cljs.core.truth_(temp__5733__auto____$1)){
var idx = temp__5733__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref.call(null,name_idx);
cljs.core.swap_BANG_.call(null,names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.call(null,name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.call(null,segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__4857 = cljs.core.seq.call(null,infos);
var chunk__4858 = null;
var count__4859 = (0);
var i__4860 = (0);
while(true){
if((i__4860 < count__4859)){
var info = cljs.core._nth.call(null,chunk__4858,i__4860);
var segv_5211 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_5212 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_5213 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_5212 > (lc_5213 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__4857,chunk__4858,count__4859,i__4860,segv_5211,gline_5212,lc_5213,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_5212 - (lc_5213 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_5211], null));
});})(seq__4857,chunk__4858,count__4859,i__4860,segv_5211,gline_5212,lc_5213,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__4857,chunk__4858,count__4859,i__4860,segv_5211,gline_5212,lc_5213,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_5212], null),cljs.core.conj,segv_5211);
});})(seq__4857,chunk__4858,count__4859,i__4860,segv_5211,gline_5212,lc_5213,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__5214 = seq__4857;
var G__5215 = chunk__4858;
var G__5216 = count__4859;
var G__5217 = (i__4860 + (1));
seq__4857 = G__5214;
chunk__4858 = G__5215;
count__4859 = G__5216;
i__4860 = G__5217;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__4857);
if(temp__5735__auto__){
var seq__4857__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4857__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__4857__$1);
var G__5218 = cljs.core.chunk_rest.call(null,seq__4857__$1);
var G__5219 = c__4556__auto__;
var G__5220 = cljs.core.count.call(null,c__4556__auto__);
var G__5221 = (0);
seq__4857 = G__5218;
chunk__4858 = G__5219;
count__4859 = G__5220;
i__4860 = G__5221;
continue;
} else {
var info = cljs.core.first.call(null,seq__4857__$1);
var segv_5222 = info__GT_segv.call(null,info,source_idx,line,col);
var gline_5223 = new cljs.core.Keyword(null,"gline","gline",-1086242431).cljs$core$IFn$_invoke$arity$1(info);
var lc_5224 = cljs.core.count.call(null,cljs.core.deref.call(null,lines));
if((gline_5223 > (lc_5224 - (1)))){
cljs.core.swap_BANG_.call(null,lines,((function (seq__4857,chunk__4858,count__4859,i__4860,segv_5222,gline_5223,lc_5224,info,seq__4857__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.call(null,cljs.core.into.call(null,lines__$1,cljs.core.repeat.call(null,((gline_5223 - (lc_5224 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_5222], null));
});})(seq__4857,chunk__4858,count__4859,i__4860,segv_5222,gline_5223,lc_5224,info,seq__4857__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.call(null,lines,((function (seq__4857,chunk__4858,count__4859,i__4860,segv_5222,gline_5223,lc_5224,info,seq__4857__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.call(null,lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_5223], null),cljs.core.conj,segv_5222);
});})(seq__4857,chunk__4858,count__4859,i__4860,segv_5222,gline_5223,lc_5224,info,seq__4857__$1,temp__5735__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__5225 = cljs.core.next.call(null,seq__4857__$1);
var G__5226 = null;
var G__5227 = (0);
var G__5228 = (0);
seq__4857 = G__5225;
chunk__4858 = G__5226;
count__4859 = G__5227;
i__4860 = G__5228;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__4861_5229 = cljs.core.seq.call(null,cljs.core.map_indexed.call(null,((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__4862_5230 = null;
var count__4863_5231 = (0);
var i__4864_5232 = (0);
while(true){
if((i__4864_5232 < count__4863_5231)){
var vec__5037_5233 = cljs.core._nth.call(null,chunk__4862_5230,i__4864_5232);
var source_idx_5234 = cljs.core.nth.call(null,vec__5037_5233,(0),null);
var vec__5040_5235 = cljs.core.nth.call(null,vec__5037_5233,(1),null);
var __5236 = cljs.core.nth.call(null,vec__5040_5235,(0),null);
var lines_5237__$1 = cljs.core.nth.call(null,vec__5040_5235,(1),null);
var seq__5043_5238 = cljs.core.seq.call(null,lines_5237__$1);
var chunk__5044_5239 = null;
var count__5045_5240 = (0);
var i__5046_5241 = (0);
while(true){
if((i__5046_5241 < count__5045_5240)){
var vec__5085_5242 = cljs.core._nth.call(null,chunk__5044_5239,i__5046_5241);
var line_5243 = cljs.core.nth.call(null,vec__5085_5242,(0),null);
var cols_5244 = cljs.core.nth.call(null,vec__5085_5242,(1),null);
var seq__5088_5245 = cljs.core.seq.call(null,cols_5244);
var chunk__5089_5246 = null;
var count__5090_5247 = (0);
var i__5091_5248 = (0);
while(true){
if((i__5091_5248 < count__5090_5247)){
var vec__5098_5249 = cljs.core._nth.call(null,chunk__5089_5246,i__5091_5248);
var col_5250 = cljs.core.nth.call(null,vec__5098_5249,(0),null);
var infos_5251 = cljs.core.nth.call(null,vec__5098_5249,(1),null);
encode_cols.call(null,infos_5251,source_idx_5234,line_5243,col_5250);


var G__5252 = seq__5088_5245;
var G__5253 = chunk__5089_5246;
var G__5254 = count__5090_5247;
var G__5255 = (i__5091_5248 + (1));
seq__5088_5245 = G__5252;
chunk__5089_5246 = G__5253;
count__5090_5247 = G__5254;
i__5091_5248 = G__5255;
continue;
} else {
var temp__5735__auto___5256 = cljs.core.seq.call(null,seq__5088_5245);
if(temp__5735__auto___5256){
var seq__5088_5257__$1 = temp__5735__auto___5256;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5088_5257__$1)){
var c__4556__auto___5258 = cljs.core.chunk_first.call(null,seq__5088_5257__$1);
var G__5259 = cljs.core.chunk_rest.call(null,seq__5088_5257__$1);
var G__5260 = c__4556__auto___5258;
var G__5261 = cljs.core.count.call(null,c__4556__auto___5258);
var G__5262 = (0);
seq__5088_5245 = G__5259;
chunk__5089_5246 = G__5260;
count__5090_5247 = G__5261;
i__5091_5248 = G__5262;
continue;
} else {
var vec__5101_5263 = cljs.core.first.call(null,seq__5088_5257__$1);
var col_5264 = cljs.core.nth.call(null,vec__5101_5263,(0),null);
var infos_5265 = cljs.core.nth.call(null,vec__5101_5263,(1),null);
encode_cols.call(null,infos_5265,source_idx_5234,line_5243,col_5264);


var G__5266 = cljs.core.next.call(null,seq__5088_5257__$1);
var G__5267 = null;
var G__5268 = (0);
var G__5269 = (0);
seq__5088_5245 = G__5266;
chunk__5089_5246 = G__5267;
count__5090_5247 = G__5268;
i__5091_5248 = G__5269;
continue;
}
} else {
}
}
break;
}


var G__5270 = seq__5043_5238;
var G__5271 = chunk__5044_5239;
var G__5272 = count__5045_5240;
var G__5273 = (i__5046_5241 + (1));
seq__5043_5238 = G__5270;
chunk__5044_5239 = G__5271;
count__5045_5240 = G__5272;
i__5046_5241 = G__5273;
continue;
} else {
var temp__5735__auto___5274 = cljs.core.seq.call(null,seq__5043_5238);
if(temp__5735__auto___5274){
var seq__5043_5275__$1 = temp__5735__auto___5274;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5043_5275__$1)){
var c__4556__auto___5276 = cljs.core.chunk_first.call(null,seq__5043_5275__$1);
var G__5277 = cljs.core.chunk_rest.call(null,seq__5043_5275__$1);
var G__5278 = c__4556__auto___5276;
var G__5279 = cljs.core.count.call(null,c__4556__auto___5276);
var G__5280 = (0);
seq__5043_5238 = G__5277;
chunk__5044_5239 = G__5278;
count__5045_5240 = G__5279;
i__5046_5241 = G__5280;
continue;
} else {
var vec__5104_5281 = cljs.core.first.call(null,seq__5043_5275__$1);
var line_5282 = cljs.core.nth.call(null,vec__5104_5281,(0),null);
var cols_5283 = cljs.core.nth.call(null,vec__5104_5281,(1),null);
var seq__5107_5284 = cljs.core.seq.call(null,cols_5283);
var chunk__5108_5285 = null;
var count__5109_5286 = (0);
var i__5110_5287 = (0);
while(true){
if((i__5110_5287 < count__5109_5286)){
var vec__5117_5288 = cljs.core._nth.call(null,chunk__5108_5285,i__5110_5287);
var col_5289 = cljs.core.nth.call(null,vec__5117_5288,(0),null);
var infos_5290 = cljs.core.nth.call(null,vec__5117_5288,(1),null);
encode_cols.call(null,infos_5290,source_idx_5234,line_5282,col_5289);


var G__5291 = seq__5107_5284;
var G__5292 = chunk__5108_5285;
var G__5293 = count__5109_5286;
var G__5294 = (i__5110_5287 + (1));
seq__5107_5284 = G__5291;
chunk__5108_5285 = G__5292;
count__5109_5286 = G__5293;
i__5110_5287 = G__5294;
continue;
} else {
var temp__5735__auto___5295__$1 = cljs.core.seq.call(null,seq__5107_5284);
if(temp__5735__auto___5295__$1){
var seq__5107_5296__$1 = temp__5735__auto___5295__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5107_5296__$1)){
var c__4556__auto___5297 = cljs.core.chunk_first.call(null,seq__5107_5296__$1);
var G__5298 = cljs.core.chunk_rest.call(null,seq__5107_5296__$1);
var G__5299 = c__4556__auto___5297;
var G__5300 = cljs.core.count.call(null,c__4556__auto___5297);
var G__5301 = (0);
seq__5107_5284 = G__5298;
chunk__5108_5285 = G__5299;
count__5109_5286 = G__5300;
i__5110_5287 = G__5301;
continue;
} else {
var vec__5120_5302 = cljs.core.first.call(null,seq__5107_5296__$1);
var col_5303 = cljs.core.nth.call(null,vec__5120_5302,(0),null);
var infos_5304 = cljs.core.nth.call(null,vec__5120_5302,(1),null);
encode_cols.call(null,infos_5304,source_idx_5234,line_5282,col_5303);


var G__5305 = cljs.core.next.call(null,seq__5107_5296__$1);
var G__5306 = null;
var G__5307 = (0);
var G__5308 = (0);
seq__5107_5284 = G__5305;
chunk__5108_5285 = G__5306;
count__5109_5286 = G__5307;
i__5110_5287 = G__5308;
continue;
}
} else {
}
}
break;
}


var G__5309 = cljs.core.next.call(null,seq__5043_5275__$1);
var G__5310 = null;
var G__5311 = (0);
var G__5312 = (0);
seq__5043_5238 = G__5309;
chunk__5044_5239 = G__5310;
count__5045_5240 = G__5311;
i__5046_5241 = G__5312;
continue;
}
} else {
}
}
break;
}


var G__5313 = seq__4861_5229;
var G__5314 = chunk__4862_5230;
var G__5315 = count__4863_5231;
var G__5316 = (i__4864_5232 + (1));
seq__4861_5229 = G__5313;
chunk__4862_5230 = G__5314;
count__4863_5231 = G__5315;
i__4864_5232 = G__5316;
continue;
} else {
var temp__5735__auto___5317 = cljs.core.seq.call(null,seq__4861_5229);
if(temp__5735__auto___5317){
var seq__4861_5318__$1 = temp__5735__auto___5317;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__4861_5318__$1)){
var c__4556__auto___5319 = cljs.core.chunk_first.call(null,seq__4861_5318__$1);
var G__5320 = cljs.core.chunk_rest.call(null,seq__4861_5318__$1);
var G__5321 = c__4556__auto___5319;
var G__5322 = cljs.core.count.call(null,c__4556__auto___5319);
var G__5323 = (0);
seq__4861_5229 = G__5320;
chunk__4862_5230 = G__5321;
count__4863_5231 = G__5322;
i__4864_5232 = G__5323;
continue;
} else {
var vec__5123_5324 = cljs.core.first.call(null,seq__4861_5318__$1);
var source_idx_5325 = cljs.core.nth.call(null,vec__5123_5324,(0),null);
var vec__5126_5326 = cljs.core.nth.call(null,vec__5123_5324,(1),null);
var __5327 = cljs.core.nth.call(null,vec__5126_5326,(0),null);
var lines_5328__$1 = cljs.core.nth.call(null,vec__5126_5326,(1),null);
var seq__5129_5329 = cljs.core.seq.call(null,lines_5328__$1);
var chunk__5130_5330 = null;
var count__5131_5331 = (0);
var i__5132_5332 = (0);
while(true){
if((i__5132_5332 < count__5131_5331)){
var vec__5171_5333 = cljs.core._nth.call(null,chunk__5130_5330,i__5132_5332);
var line_5334 = cljs.core.nth.call(null,vec__5171_5333,(0),null);
var cols_5335 = cljs.core.nth.call(null,vec__5171_5333,(1),null);
var seq__5174_5336 = cljs.core.seq.call(null,cols_5335);
var chunk__5175_5337 = null;
var count__5176_5338 = (0);
var i__5177_5339 = (0);
while(true){
if((i__5177_5339 < count__5176_5338)){
var vec__5184_5340 = cljs.core._nth.call(null,chunk__5175_5337,i__5177_5339);
var col_5341 = cljs.core.nth.call(null,vec__5184_5340,(0),null);
var infos_5342 = cljs.core.nth.call(null,vec__5184_5340,(1),null);
encode_cols.call(null,infos_5342,source_idx_5325,line_5334,col_5341);


var G__5343 = seq__5174_5336;
var G__5344 = chunk__5175_5337;
var G__5345 = count__5176_5338;
var G__5346 = (i__5177_5339 + (1));
seq__5174_5336 = G__5343;
chunk__5175_5337 = G__5344;
count__5176_5338 = G__5345;
i__5177_5339 = G__5346;
continue;
} else {
var temp__5735__auto___5347__$1 = cljs.core.seq.call(null,seq__5174_5336);
if(temp__5735__auto___5347__$1){
var seq__5174_5348__$1 = temp__5735__auto___5347__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5174_5348__$1)){
var c__4556__auto___5349 = cljs.core.chunk_first.call(null,seq__5174_5348__$1);
var G__5350 = cljs.core.chunk_rest.call(null,seq__5174_5348__$1);
var G__5351 = c__4556__auto___5349;
var G__5352 = cljs.core.count.call(null,c__4556__auto___5349);
var G__5353 = (0);
seq__5174_5336 = G__5350;
chunk__5175_5337 = G__5351;
count__5176_5338 = G__5352;
i__5177_5339 = G__5353;
continue;
} else {
var vec__5187_5354 = cljs.core.first.call(null,seq__5174_5348__$1);
var col_5355 = cljs.core.nth.call(null,vec__5187_5354,(0),null);
var infos_5356 = cljs.core.nth.call(null,vec__5187_5354,(1),null);
encode_cols.call(null,infos_5356,source_idx_5325,line_5334,col_5355);


var G__5357 = cljs.core.next.call(null,seq__5174_5348__$1);
var G__5358 = null;
var G__5359 = (0);
var G__5360 = (0);
seq__5174_5336 = G__5357;
chunk__5175_5337 = G__5358;
count__5176_5338 = G__5359;
i__5177_5339 = G__5360;
continue;
}
} else {
}
}
break;
}


var G__5361 = seq__5129_5329;
var G__5362 = chunk__5130_5330;
var G__5363 = count__5131_5331;
var G__5364 = (i__5132_5332 + (1));
seq__5129_5329 = G__5361;
chunk__5130_5330 = G__5362;
count__5131_5331 = G__5363;
i__5132_5332 = G__5364;
continue;
} else {
var temp__5735__auto___5365__$1 = cljs.core.seq.call(null,seq__5129_5329);
if(temp__5735__auto___5365__$1){
var seq__5129_5366__$1 = temp__5735__auto___5365__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5129_5366__$1)){
var c__4556__auto___5367 = cljs.core.chunk_first.call(null,seq__5129_5366__$1);
var G__5368 = cljs.core.chunk_rest.call(null,seq__5129_5366__$1);
var G__5369 = c__4556__auto___5367;
var G__5370 = cljs.core.count.call(null,c__4556__auto___5367);
var G__5371 = (0);
seq__5129_5329 = G__5368;
chunk__5130_5330 = G__5369;
count__5131_5331 = G__5370;
i__5132_5332 = G__5371;
continue;
} else {
var vec__5190_5372 = cljs.core.first.call(null,seq__5129_5366__$1);
var line_5373 = cljs.core.nth.call(null,vec__5190_5372,(0),null);
var cols_5374 = cljs.core.nth.call(null,vec__5190_5372,(1),null);
var seq__5193_5375 = cljs.core.seq.call(null,cols_5374);
var chunk__5194_5376 = null;
var count__5195_5377 = (0);
var i__5196_5378 = (0);
while(true){
if((i__5196_5378 < count__5195_5377)){
var vec__5203_5379 = cljs.core._nth.call(null,chunk__5194_5376,i__5196_5378);
var col_5380 = cljs.core.nth.call(null,vec__5203_5379,(0),null);
var infos_5381 = cljs.core.nth.call(null,vec__5203_5379,(1),null);
encode_cols.call(null,infos_5381,source_idx_5325,line_5373,col_5380);


var G__5382 = seq__5193_5375;
var G__5383 = chunk__5194_5376;
var G__5384 = count__5195_5377;
var G__5385 = (i__5196_5378 + (1));
seq__5193_5375 = G__5382;
chunk__5194_5376 = G__5383;
count__5195_5377 = G__5384;
i__5196_5378 = G__5385;
continue;
} else {
var temp__5735__auto___5386__$2 = cljs.core.seq.call(null,seq__5193_5375);
if(temp__5735__auto___5386__$2){
var seq__5193_5387__$1 = temp__5735__auto___5386__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5193_5387__$1)){
var c__4556__auto___5388 = cljs.core.chunk_first.call(null,seq__5193_5387__$1);
var G__5389 = cljs.core.chunk_rest.call(null,seq__5193_5387__$1);
var G__5390 = c__4556__auto___5388;
var G__5391 = cljs.core.count.call(null,c__4556__auto___5388);
var G__5392 = (0);
seq__5193_5375 = G__5389;
chunk__5194_5376 = G__5390;
count__5195_5377 = G__5391;
i__5196_5378 = G__5392;
continue;
} else {
var vec__5206_5393 = cljs.core.first.call(null,seq__5193_5387__$1);
var col_5394 = cljs.core.nth.call(null,vec__5206_5393,(0),null);
var infos_5395 = cljs.core.nth.call(null,vec__5206_5393,(1),null);
encode_cols.call(null,infos_5395,source_idx_5325,line_5373,col_5394);


var G__5396 = cljs.core.next.call(null,seq__5193_5387__$1);
var G__5397 = null;
var G__5398 = (0);
var G__5399 = (0);
seq__5193_5375 = G__5396;
chunk__5194_5376 = G__5397;
count__5195_5377 = G__5398;
i__5196_5378 = G__5399;
continue;
}
} else {
}
}
break;
}


var G__5400 = cljs.core.next.call(null,seq__5129_5366__$1);
var G__5401 = null;
var G__5402 = (0);
var G__5403 = (0);
seq__5129_5329 = G__5400;
chunk__5130_5330 = G__5401;
count__5131_5331 = G__5402;
i__5132_5332 = G__5403;
continue;
}
} else {
}
}
break;
}


var G__5404 = cljs.core.next.call(null,seq__4861_5318__$1);
var G__5405 = null;
var G__5406 = (0);
var G__5407 = (0);
seq__4861_5229 = G__5404;
chunk__4862_5230 = G__5405;
count__4863_5231 = G__5406;
i__4864_5232 = G__5407;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__5209 = ({"version": (3), "file": new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys.call(null,m);
var f = cljs.core.comp.call(null,((new cljs.core.Keyword(null,"source-map-timestamp","source-map-timestamp",1973015633).cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__4854_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__4854_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__4855_SHARP_){
return cljs.core.last.call(null,clojure.string.split.call(null,p1__4855_SHARP_,/\//));
}));
return cljs.core.into_array.call(null,cljs.core.map.call(null,f,paths));
})(), "lineCount": new cljs.core.Keyword(null,"lines","lines",-700165781).cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.call(null,";",cljs.core.map.call(null,(function (p1__4856_SHARP_){
return clojure.string.join.call(null,",",p1__4856_SHARP_);
}),cljs.source_map.lines__GT_segs.call(null,cljs.core.concat.call(null,preamble_lines,cljs.core.deref.call(null,lines))))), "names": cljs.core.into_array.call(null,cljs.core.map.call(null,clojure.set.map_invert.call(null,cljs.core.deref.call(null,names__GT_idx)),cljs.core.range.call(null,cljs.core.count.call(null,cljs.core.deref.call(null,names__GT_idx)))))});
if(cljs.core.truth_(new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts))){
var G__5210 = G__5209;
goog.object.set(G__5210,"sourcesContent",cljs.core.into_array.call(null,new cljs.core.Keyword(null,"sources-content","sources-content",1729970239).cljs$core$IFn$_invoke$arity$1(opts)));

return G__5210;
} else {
return G__5209;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq.call(null,cljs_map);
var new_lines = cljs.core.sorted_map.call(null);
while(true){
if(line_map_seq){
var vec__5408 = cljs.core.first.call(null,line_map_seq);
var line = cljs.core.nth.call(null,vec__5408,(0),null);
var col_map = cljs.core.nth.call(null,vec__5408,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq.call(null,col_map);
var new_cols = cljs.core.sorted_map.call(null);
while(true){
if(col_map_seq){
var vec__5411 = cljs.core.first.call(null,col_map_seq);
var col = cljs.core.nth.call(null,vec__5411,(0),null);
var infos = cljs.core.nth.call(null,vec__5411,(1),null);
var G__5417 = cljs.core.next.call(null,col_map_seq);
var G__5418 = cljs.core.assoc.call(null,new_cols,col,cljs.core.reduce.call(null,((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__5411,col,infos,vec__5408,line,col_map){
return (function (v,p__5414){
var map__5415 = p__5414;
var map__5415__$1 = (((((!((map__5415 == null))))?(((((map__5415.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5415.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5415):map__5415);
var gline = cljs.core.get.call(null,map__5415__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol = cljs.core.get.call(null,map__5415__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
return cljs.core.into.call(null,v,cljs.core.get_in.call(null,js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__5411,col,infos,vec__5408,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__5417;
new_cols = G__5418;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__5419 = cljs.core.next.call(null,line_map_seq);
var G__5420 = cljs.core.assoc.call(null,new_lines,line,new_cols);
line_map_seq = G__5419;
new_lines = G__5420;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.call(null,cljs.core.sorted_map.call(null));
var seq__5421_5693 = cljs.core.seq.call(null,reverse_map);
var chunk__5422_5694 = null;
var count__5423_5695 = (0);
var i__5424_5696 = (0);
while(true){
if((i__5424_5696 < count__5423_5695)){
var vec__5559_5697 = cljs.core._nth.call(null,chunk__5422_5694,i__5424_5696);
var line_5698 = cljs.core.nth.call(null,vec__5559_5697,(0),null);
var columns_5699 = cljs.core.nth.call(null,vec__5559_5697,(1),null);
var seq__5562_5700 = cljs.core.seq.call(null,columns_5699);
var chunk__5563_5701 = null;
var count__5564_5702 = (0);
var i__5565_5703 = (0);
while(true){
if((i__5565_5703 < count__5564_5702)){
var vec__5596_5704 = cljs.core._nth.call(null,chunk__5563_5701,i__5565_5703);
var column_5705 = cljs.core.nth.call(null,vec__5596_5704,(0),null);
var column_info_5706 = cljs.core.nth.call(null,vec__5596_5704,(1),null);
var seq__5599_5707 = cljs.core.seq.call(null,column_info_5706);
var chunk__5600_5708 = null;
var count__5601_5709 = (0);
var i__5602_5710 = (0);
while(true){
if((i__5602_5710 < count__5601_5709)){
var map__5607_5711 = cljs.core._nth.call(null,chunk__5600_5708,i__5602_5710);
var map__5607_5712__$1 = (((((!((map__5607_5711 == null))))?(((((map__5607_5711.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5607_5711.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5607_5711):map__5607_5711);
var gline_5713 = cljs.core.get.call(null,map__5607_5712__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_5714 = cljs.core.get.call(null,map__5607_5712__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_5715 = cljs.core.get.call(null,map__5607_5712__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_5713], null),cljs.core.fnil.call(null,((function (seq__5599_5707,chunk__5600_5708,count__5601_5709,i__5602_5710,seq__5562_5700,chunk__5563_5701,count__5564_5702,i__5565_5703,seq__5421_5693,chunk__5422_5694,count__5423_5695,i__5424_5696,map__5607_5711,map__5607_5712__$1,gline_5713,gcol_5714,name_5715,vec__5596_5704,column_5705,column_info_5706,vec__5559_5697,line_5698,columns_5699,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_5714], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_5698,new cljs.core.Keyword(null,"col","col",-1959363084),column_5705,new cljs.core.Keyword(null,"name","name",1843675177),name_5715], null));
});})(seq__5599_5707,chunk__5600_5708,count__5601_5709,i__5602_5710,seq__5562_5700,chunk__5563_5701,count__5564_5702,i__5565_5703,seq__5421_5693,chunk__5422_5694,count__5423_5695,i__5424_5696,map__5607_5711,map__5607_5712__$1,gline_5713,gcol_5714,name_5715,vec__5596_5704,column_5705,column_info_5706,vec__5559_5697,line_5698,columns_5699,inverted))
,cljs.core.sorted_map.call(null)));


var G__5716 = seq__5599_5707;
var G__5717 = chunk__5600_5708;
var G__5718 = count__5601_5709;
var G__5719 = (i__5602_5710 + (1));
seq__5599_5707 = G__5716;
chunk__5600_5708 = G__5717;
count__5601_5709 = G__5718;
i__5602_5710 = G__5719;
continue;
} else {
var temp__5735__auto___5720 = cljs.core.seq.call(null,seq__5599_5707);
if(temp__5735__auto___5720){
var seq__5599_5721__$1 = temp__5735__auto___5720;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5599_5721__$1)){
var c__4556__auto___5722 = cljs.core.chunk_first.call(null,seq__5599_5721__$1);
var G__5723 = cljs.core.chunk_rest.call(null,seq__5599_5721__$1);
var G__5724 = c__4556__auto___5722;
var G__5725 = cljs.core.count.call(null,c__4556__auto___5722);
var G__5726 = (0);
seq__5599_5707 = G__5723;
chunk__5600_5708 = G__5724;
count__5601_5709 = G__5725;
i__5602_5710 = G__5726;
continue;
} else {
var map__5609_5727 = cljs.core.first.call(null,seq__5599_5721__$1);
var map__5609_5728__$1 = (((((!((map__5609_5727 == null))))?(((((map__5609_5727.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5609_5727.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5609_5727):map__5609_5727);
var gline_5729 = cljs.core.get.call(null,map__5609_5728__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_5730 = cljs.core.get.call(null,map__5609_5728__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_5731 = cljs.core.get.call(null,map__5609_5728__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_5729], null),cljs.core.fnil.call(null,((function (seq__5599_5707,chunk__5600_5708,count__5601_5709,i__5602_5710,seq__5562_5700,chunk__5563_5701,count__5564_5702,i__5565_5703,seq__5421_5693,chunk__5422_5694,count__5423_5695,i__5424_5696,map__5609_5727,map__5609_5728__$1,gline_5729,gcol_5730,name_5731,seq__5599_5721__$1,temp__5735__auto___5720,vec__5596_5704,column_5705,column_info_5706,vec__5559_5697,line_5698,columns_5699,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_5730], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_5698,new cljs.core.Keyword(null,"col","col",-1959363084),column_5705,new cljs.core.Keyword(null,"name","name",1843675177),name_5731], null));
});})(seq__5599_5707,chunk__5600_5708,count__5601_5709,i__5602_5710,seq__5562_5700,chunk__5563_5701,count__5564_5702,i__5565_5703,seq__5421_5693,chunk__5422_5694,count__5423_5695,i__5424_5696,map__5609_5727,map__5609_5728__$1,gline_5729,gcol_5730,name_5731,seq__5599_5721__$1,temp__5735__auto___5720,vec__5596_5704,column_5705,column_info_5706,vec__5559_5697,line_5698,columns_5699,inverted))
,cljs.core.sorted_map.call(null)));


var G__5732 = cljs.core.next.call(null,seq__5599_5721__$1);
var G__5733 = null;
var G__5734 = (0);
var G__5735 = (0);
seq__5599_5707 = G__5732;
chunk__5600_5708 = G__5733;
count__5601_5709 = G__5734;
i__5602_5710 = G__5735;
continue;
}
} else {
}
}
break;
}


var G__5736 = seq__5562_5700;
var G__5737 = chunk__5563_5701;
var G__5738 = count__5564_5702;
var G__5739 = (i__5565_5703 + (1));
seq__5562_5700 = G__5736;
chunk__5563_5701 = G__5737;
count__5564_5702 = G__5738;
i__5565_5703 = G__5739;
continue;
} else {
var temp__5735__auto___5740 = cljs.core.seq.call(null,seq__5562_5700);
if(temp__5735__auto___5740){
var seq__5562_5741__$1 = temp__5735__auto___5740;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5562_5741__$1)){
var c__4556__auto___5742 = cljs.core.chunk_first.call(null,seq__5562_5741__$1);
var G__5743 = cljs.core.chunk_rest.call(null,seq__5562_5741__$1);
var G__5744 = c__4556__auto___5742;
var G__5745 = cljs.core.count.call(null,c__4556__auto___5742);
var G__5746 = (0);
seq__5562_5700 = G__5743;
chunk__5563_5701 = G__5744;
count__5564_5702 = G__5745;
i__5565_5703 = G__5746;
continue;
} else {
var vec__5611_5747 = cljs.core.first.call(null,seq__5562_5741__$1);
var column_5748 = cljs.core.nth.call(null,vec__5611_5747,(0),null);
var column_info_5749 = cljs.core.nth.call(null,vec__5611_5747,(1),null);
var seq__5614_5750 = cljs.core.seq.call(null,column_info_5749);
var chunk__5615_5751 = null;
var count__5616_5752 = (0);
var i__5617_5753 = (0);
while(true){
if((i__5617_5753 < count__5616_5752)){
var map__5622_5754 = cljs.core._nth.call(null,chunk__5615_5751,i__5617_5753);
var map__5622_5755__$1 = (((((!((map__5622_5754 == null))))?(((((map__5622_5754.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5622_5754.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5622_5754):map__5622_5754);
var gline_5756 = cljs.core.get.call(null,map__5622_5755__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_5757 = cljs.core.get.call(null,map__5622_5755__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_5758 = cljs.core.get.call(null,map__5622_5755__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_5756], null),cljs.core.fnil.call(null,((function (seq__5614_5750,chunk__5615_5751,count__5616_5752,i__5617_5753,seq__5562_5700,chunk__5563_5701,count__5564_5702,i__5565_5703,seq__5421_5693,chunk__5422_5694,count__5423_5695,i__5424_5696,map__5622_5754,map__5622_5755__$1,gline_5756,gcol_5757,name_5758,vec__5611_5747,column_5748,column_info_5749,seq__5562_5741__$1,temp__5735__auto___5740,vec__5559_5697,line_5698,columns_5699,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_5757], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_5698,new cljs.core.Keyword(null,"col","col",-1959363084),column_5748,new cljs.core.Keyword(null,"name","name",1843675177),name_5758], null));
});})(seq__5614_5750,chunk__5615_5751,count__5616_5752,i__5617_5753,seq__5562_5700,chunk__5563_5701,count__5564_5702,i__5565_5703,seq__5421_5693,chunk__5422_5694,count__5423_5695,i__5424_5696,map__5622_5754,map__5622_5755__$1,gline_5756,gcol_5757,name_5758,vec__5611_5747,column_5748,column_info_5749,seq__5562_5741__$1,temp__5735__auto___5740,vec__5559_5697,line_5698,columns_5699,inverted))
,cljs.core.sorted_map.call(null)));


var G__5759 = seq__5614_5750;
var G__5760 = chunk__5615_5751;
var G__5761 = count__5616_5752;
var G__5762 = (i__5617_5753 + (1));
seq__5614_5750 = G__5759;
chunk__5615_5751 = G__5760;
count__5616_5752 = G__5761;
i__5617_5753 = G__5762;
continue;
} else {
var temp__5735__auto___5763__$1 = cljs.core.seq.call(null,seq__5614_5750);
if(temp__5735__auto___5763__$1){
var seq__5614_5764__$1 = temp__5735__auto___5763__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5614_5764__$1)){
var c__4556__auto___5765 = cljs.core.chunk_first.call(null,seq__5614_5764__$1);
var G__5766 = cljs.core.chunk_rest.call(null,seq__5614_5764__$1);
var G__5767 = c__4556__auto___5765;
var G__5768 = cljs.core.count.call(null,c__4556__auto___5765);
var G__5769 = (0);
seq__5614_5750 = G__5766;
chunk__5615_5751 = G__5767;
count__5616_5752 = G__5768;
i__5617_5753 = G__5769;
continue;
} else {
var map__5624_5770 = cljs.core.first.call(null,seq__5614_5764__$1);
var map__5624_5771__$1 = (((((!((map__5624_5770 == null))))?(((((map__5624_5770.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5624_5770.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5624_5770):map__5624_5770);
var gline_5772 = cljs.core.get.call(null,map__5624_5771__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_5773 = cljs.core.get.call(null,map__5624_5771__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_5774 = cljs.core.get.call(null,map__5624_5771__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_5772], null),cljs.core.fnil.call(null,((function (seq__5614_5750,chunk__5615_5751,count__5616_5752,i__5617_5753,seq__5562_5700,chunk__5563_5701,count__5564_5702,i__5565_5703,seq__5421_5693,chunk__5422_5694,count__5423_5695,i__5424_5696,map__5624_5770,map__5624_5771__$1,gline_5772,gcol_5773,name_5774,seq__5614_5764__$1,temp__5735__auto___5763__$1,vec__5611_5747,column_5748,column_info_5749,seq__5562_5741__$1,temp__5735__auto___5740,vec__5559_5697,line_5698,columns_5699,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_5773], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_5698,new cljs.core.Keyword(null,"col","col",-1959363084),column_5748,new cljs.core.Keyword(null,"name","name",1843675177),name_5774], null));
});})(seq__5614_5750,chunk__5615_5751,count__5616_5752,i__5617_5753,seq__5562_5700,chunk__5563_5701,count__5564_5702,i__5565_5703,seq__5421_5693,chunk__5422_5694,count__5423_5695,i__5424_5696,map__5624_5770,map__5624_5771__$1,gline_5772,gcol_5773,name_5774,seq__5614_5764__$1,temp__5735__auto___5763__$1,vec__5611_5747,column_5748,column_info_5749,seq__5562_5741__$1,temp__5735__auto___5740,vec__5559_5697,line_5698,columns_5699,inverted))
,cljs.core.sorted_map.call(null)));


var G__5775 = cljs.core.next.call(null,seq__5614_5764__$1);
var G__5776 = null;
var G__5777 = (0);
var G__5778 = (0);
seq__5614_5750 = G__5775;
chunk__5615_5751 = G__5776;
count__5616_5752 = G__5777;
i__5617_5753 = G__5778;
continue;
}
} else {
}
}
break;
}


var G__5779 = cljs.core.next.call(null,seq__5562_5741__$1);
var G__5780 = null;
var G__5781 = (0);
var G__5782 = (0);
seq__5562_5700 = G__5779;
chunk__5563_5701 = G__5780;
count__5564_5702 = G__5781;
i__5565_5703 = G__5782;
continue;
}
} else {
}
}
break;
}


var G__5783 = seq__5421_5693;
var G__5784 = chunk__5422_5694;
var G__5785 = count__5423_5695;
var G__5786 = (i__5424_5696 + (1));
seq__5421_5693 = G__5783;
chunk__5422_5694 = G__5784;
count__5423_5695 = G__5785;
i__5424_5696 = G__5786;
continue;
} else {
var temp__5735__auto___5787 = cljs.core.seq.call(null,seq__5421_5693);
if(temp__5735__auto___5787){
var seq__5421_5788__$1 = temp__5735__auto___5787;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5421_5788__$1)){
var c__4556__auto___5789 = cljs.core.chunk_first.call(null,seq__5421_5788__$1);
var G__5790 = cljs.core.chunk_rest.call(null,seq__5421_5788__$1);
var G__5791 = c__4556__auto___5789;
var G__5792 = cljs.core.count.call(null,c__4556__auto___5789);
var G__5793 = (0);
seq__5421_5693 = G__5790;
chunk__5422_5694 = G__5791;
count__5423_5695 = G__5792;
i__5424_5696 = G__5793;
continue;
} else {
var vec__5626_5794 = cljs.core.first.call(null,seq__5421_5788__$1);
var line_5795 = cljs.core.nth.call(null,vec__5626_5794,(0),null);
var columns_5796 = cljs.core.nth.call(null,vec__5626_5794,(1),null);
var seq__5629_5797 = cljs.core.seq.call(null,columns_5796);
var chunk__5630_5798 = null;
var count__5631_5799 = (0);
var i__5632_5800 = (0);
while(true){
if((i__5632_5800 < count__5631_5799)){
var vec__5663_5801 = cljs.core._nth.call(null,chunk__5630_5798,i__5632_5800);
var column_5802 = cljs.core.nth.call(null,vec__5663_5801,(0),null);
var column_info_5803 = cljs.core.nth.call(null,vec__5663_5801,(1),null);
var seq__5666_5804 = cljs.core.seq.call(null,column_info_5803);
var chunk__5667_5805 = null;
var count__5668_5806 = (0);
var i__5669_5807 = (0);
while(true){
if((i__5669_5807 < count__5668_5806)){
var map__5674_5808 = cljs.core._nth.call(null,chunk__5667_5805,i__5669_5807);
var map__5674_5809__$1 = (((((!((map__5674_5808 == null))))?(((((map__5674_5808.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5674_5808.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5674_5808):map__5674_5808);
var gline_5810 = cljs.core.get.call(null,map__5674_5809__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_5811 = cljs.core.get.call(null,map__5674_5809__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_5812 = cljs.core.get.call(null,map__5674_5809__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_5810], null),cljs.core.fnil.call(null,((function (seq__5666_5804,chunk__5667_5805,count__5668_5806,i__5669_5807,seq__5629_5797,chunk__5630_5798,count__5631_5799,i__5632_5800,seq__5421_5693,chunk__5422_5694,count__5423_5695,i__5424_5696,map__5674_5808,map__5674_5809__$1,gline_5810,gcol_5811,name_5812,vec__5663_5801,column_5802,column_info_5803,vec__5626_5794,line_5795,columns_5796,seq__5421_5788__$1,temp__5735__auto___5787,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_5811], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_5795,new cljs.core.Keyword(null,"col","col",-1959363084),column_5802,new cljs.core.Keyword(null,"name","name",1843675177),name_5812], null));
});})(seq__5666_5804,chunk__5667_5805,count__5668_5806,i__5669_5807,seq__5629_5797,chunk__5630_5798,count__5631_5799,i__5632_5800,seq__5421_5693,chunk__5422_5694,count__5423_5695,i__5424_5696,map__5674_5808,map__5674_5809__$1,gline_5810,gcol_5811,name_5812,vec__5663_5801,column_5802,column_info_5803,vec__5626_5794,line_5795,columns_5796,seq__5421_5788__$1,temp__5735__auto___5787,inverted))
,cljs.core.sorted_map.call(null)));


var G__5813 = seq__5666_5804;
var G__5814 = chunk__5667_5805;
var G__5815 = count__5668_5806;
var G__5816 = (i__5669_5807 + (1));
seq__5666_5804 = G__5813;
chunk__5667_5805 = G__5814;
count__5668_5806 = G__5815;
i__5669_5807 = G__5816;
continue;
} else {
var temp__5735__auto___5817__$1 = cljs.core.seq.call(null,seq__5666_5804);
if(temp__5735__auto___5817__$1){
var seq__5666_5818__$1 = temp__5735__auto___5817__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5666_5818__$1)){
var c__4556__auto___5819 = cljs.core.chunk_first.call(null,seq__5666_5818__$1);
var G__5820 = cljs.core.chunk_rest.call(null,seq__5666_5818__$1);
var G__5821 = c__4556__auto___5819;
var G__5822 = cljs.core.count.call(null,c__4556__auto___5819);
var G__5823 = (0);
seq__5666_5804 = G__5820;
chunk__5667_5805 = G__5821;
count__5668_5806 = G__5822;
i__5669_5807 = G__5823;
continue;
} else {
var map__5676_5824 = cljs.core.first.call(null,seq__5666_5818__$1);
var map__5676_5825__$1 = (((((!((map__5676_5824 == null))))?(((((map__5676_5824.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5676_5824.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5676_5824):map__5676_5824);
var gline_5826 = cljs.core.get.call(null,map__5676_5825__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_5827 = cljs.core.get.call(null,map__5676_5825__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_5828 = cljs.core.get.call(null,map__5676_5825__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_5826], null),cljs.core.fnil.call(null,((function (seq__5666_5804,chunk__5667_5805,count__5668_5806,i__5669_5807,seq__5629_5797,chunk__5630_5798,count__5631_5799,i__5632_5800,seq__5421_5693,chunk__5422_5694,count__5423_5695,i__5424_5696,map__5676_5824,map__5676_5825__$1,gline_5826,gcol_5827,name_5828,seq__5666_5818__$1,temp__5735__auto___5817__$1,vec__5663_5801,column_5802,column_info_5803,vec__5626_5794,line_5795,columns_5796,seq__5421_5788__$1,temp__5735__auto___5787,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_5827], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_5795,new cljs.core.Keyword(null,"col","col",-1959363084),column_5802,new cljs.core.Keyword(null,"name","name",1843675177),name_5828], null));
});})(seq__5666_5804,chunk__5667_5805,count__5668_5806,i__5669_5807,seq__5629_5797,chunk__5630_5798,count__5631_5799,i__5632_5800,seq__5421_5693,chunk__5422_5694,count__5423_5695,i__5424_5696,map__5676_5824,map__5676_5825__$1,gline_5826,gcol_5827,name_5828,seq__5666_5818__$1,temp__5735__auto___5817__$1,vec__5663_5801,column_5802,column_info_5803,vec__5626_5794,line_5795,columns_5796,seq__5421_5788__$1,temp__5735__auto___5787,inverted))
,cljs.core.sorted_map.call(null)));


var G__5829 = cljs.core.next.call(null,seq__5666_5818__$1);
var G__5830 = null;
var G__5831 = (0);
var G__5832 = (0);
seq__5666_5804 = G__5829;
chunk__5667_5805 = G__5830;
count__5668_5806 = G__5831;
i__5669_5807 = G__5832;
continue;
}
} else {
}
}
break;
}


var G__5833 = seq__5629_5797;
var G__5834 = chunk__5630_5798;
var G__5835 = count__5631_5799;
var G__5836 = (i__5632_5800 + (1));
seq__5629_5797 = G__5833;
chunk__5630_5798 = G__5834;
count__5631_5799 = G__5835;
i__5632_5800 = G__5836;
continue;
} else {
var temp__5735__auto___5837__$1 = cljs.core.seq.call(null,seq__5629_5797);
if(temp__5735__auto___5837__$1){
var seq__5629_5838__$1 = temp__5735__auto___5837__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5629_5838__$1)){
var c__4556__auto___5839 = cljs.core.chunk_first.call(null,seq__5629_5838__$1);
var G__5840 = cljs.core.chunk_rest.call(null,seq__5629_5838__$1);
var G__5841 = c__4556__auto___5839;
var G__5842 = cljs.core.count.call(null,c__4556__auto___5839);
var G__5843 = (0);
seq__5629_5797 = G__5840;
chunk__5630_5798 = G__5841;
count__5631_5799 = G__5842;
i__5632_5800 = G__5843;
continue;
} else {
var vec__5678_5844 = cljs.core.first.call(null,seq__5629_5838__$1);
var column_5845 = cljs.core.nth.call(null,vec__5678_5844,(0),null);
var column_info_5846 = cljs.core.nth.call(null,vec__5678_5844,(1),null);
var seq__5681_5847 = cljs.core.seq.call(null,column_info_5846);
var chunk__5682_5848 = null;
var count__5683_5849 = (0);
var i__5684_5850 = (0);
while(true){
if((i__5684_5850 < count__5683_5849)){
var map__5689_5851 = cljs.core._nth.call(null,chunk__5682_5848,i__5684_5850);
var map__5689_5852__$1 = (((((!((map__5689_5851 == null))))?(((((map__5689_5851.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5689_5851.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5689_5851):map__5689_5851);
var gline_5853 = cljs.core.get.call(null,map__5689_5852__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_5854 = cljs.core.get.call(null,map__5689_5852__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_5855 = cljs.core.get.call(null,map__5689_5852__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_5853], null),cljs.core.fnil.call(null,((function (seq__5681_5847,chunk__5682_5848,count__5683_5849,i__5684_5850,seq__5629_5797,chunk__5630_5798,count__5631_5799,i__5632_5800,seq__5421_5693,chunk__5422_5694,count__5423_5695,i__5424_5696,map__5689_5851,map__5689_5852__$1,gline_5853,gcol_5854,name_5855,vec__5678_5844,column_5845,column_info_5846,seq__5629_5838__$1,temp__5735__auto___5837__$1,vec__5626_5794,line_5795,columns_5796,seq__5421_5788__$1,temp__5735__auto___5787,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_5854], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_5795,new cljs.core.Keyword(null,"col","col",-1959363084),column_5845,new cljs.core.Keyword(null,"name","name",1843675177),name_5855], null));
});})(seq__5681_5847,chunk__5682_5848,count__5683_5849,i__5684_5850,seq__5629_5797,chunk__5630_5798,count__5631_5799,i__5632_5800,seq__5421_5693,chunk__5422_5694,count__5423_5695,i__5424_5696,map__5689_5851,map__5689_5852__$1,gline_5853,gcol_5854,name_5855,vec__5678_5844,column_5845,column_info_5846,seq__5629_5838__$1,temp__5735__auto___5837__$1,vec__5626_5794,line_5795,columns_5796,seq__5421_5788__$1,temp__5735__auto___5787,inverted))
,cljs.core.sorted_map.call(null)));


var G__5856 = seq__5681_5847;
var G__5857 = chunk__5682_5848;
var G__5858 = count__5683_5849;
var G__5859 = (i__5684_5850 + (1));
seq__5681_5847 = G__5856;
chunk__5682_5848 = G__5857;
count__5683_5849 = G__5858;
i__5684_5850 = G__5859;
continue;
} else {
var temp__5735__auto___5860__$2 = cljs.core.seq.call(null,seq__5681_5847);
if(temp__5735__auto___5860__$2){
var seq__5681_5861__$1 = temp__5735__auto___5860__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__5681_5861__$1)){
var c__4556__auto___5862 = cljs.core.chunk_first.call(null,seq__5681_5861__$1);
var G__5863 = cljs.core.chunk_rest.call(null,seq__5681_5861__$1);
var G__5864 = c__4556__auto___5862;
var G__5865 = cljs.core.count.call(null,c__4556__auto___5862);
var G__5866 = (0);
seq__5681_5847 = G__5863;
chunk__5682_5848 = G__5864;
count__5683_5849 = G__5865;
i__5684_5850 = G__5866;
continue;
} else {
var map__5691_5867 = cljs.core.first.call(null,seq__5681_5861__$1);
var map__5691_5868__$1 = (((((!((map__5691_5867 == null))))?(((((map__5691_5867.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5691_5867.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5691_5867):map__5691_5867);
var gline_5869 = cljs.core.get.call(null,map__5691_5868__$1,new cljs.core.Keyword(null,"gline","gline",-1086242431));
var gcol_5870 = cljs.core.get.call(null,map__5691_5868__$1,new cljs.core.Keyword(null,"gcol","gcol",309250807));
var name_5871 = cljs.core.get.call(null,map__5691_5868__$1,new cljs.core.Keyword(null,"name","name",1843675177));
cljs.core.swap_BANG_.call(null,inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_5869], null),cljs.core.fnil.call(null,((function (seq__5681_5847,chunk__5682_5848,count__5683_5849,i__5684_5850,seq__5629_5797,chunk__5630_5798,count__5631_5799,i__5632_5800,seq__5421_5693,chunk__5422_5694,count__5423_5695,i__5424_5696,map__5691_5867,map__5691_5868__$1,gline_5869,gcol_5870,name_5871,seq__5681_5861__$1,temp__5735__auto___5860__$2,vec__5678_5844,column_5845,column_info_5846,seq__5629_5838__$1,temp__5735__auto___5837__$1,vec__5626_5794,line_5795,columns_5796,seq__5421_5788__$1,temp__5735__auto___5787,inverted){
return (function (columns__$1){
return cljs.core.update_in.call(null,columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_5870], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"line","line",212345235),line_5795,new cljs.core.Keyword(null,"col","col",-1959363084),column_5845,new cljs.core.Keyword(null,"name","name",1843675177),name_5871], null));
});})(seq__5681_5847,chunk__5682_5848,count__5683_5849,i__5684_5850,seq__5629_5797,chunk__5630_5798,count__5631_5799,i__5632_5800,seq__5421_5693,chunk__5422_5694,count__5423_5695,i__5424_5696,map__5691_5867,map__5691_5868__$1,gline_5869,gcol_5870,name_5871,seq__5681_5861__$1,temp__5735__auto___5860__$2,vec__5678_5844,column_5845,column_info_5846,seq__5629_5838__$1,temp__5735__auto___5837__$1,vec__5626_5794,line_5795,columns_5796,seq__5421_5788__$1,temp__5735__auto___5787,inverted))
,cljs.core.sorted_map.call(null)));


var G__5872 = cljs.core.next.call(null,seq__5681_5861__$1);
var G__5873 = null;
var G__5874 = (0);
var G__5875 = (0);
seq__5681_5847 = G__5872;
chunk__5682_5848 = G__5873;
count__5683_5849 = G__5874;
i__5684_5850 = G__5875;
continue;
}
} else {
}
}
break;
}


var G__5876 = cljs.core.next.call(null,seq__5629_5838__$1);
var G__5877 = null;
var G__5878 = (0);
var G__5879 = (0);
seq__5629_5797 = G__5876;
chunk__5630_5798 = G__5877;
count__5631_5799 = G__5878;
i__5632_5800 = G__5879;
continue;
}
} else {
}
}
break;
}


var G__5880 = cljs.core.next.call(null,seq__5421_5788__$1);
var G__5881 = null;
var G__5882 = (0);
var G__5883 = (0);
seq__5421_5693 = G__5880;
chunk__5422_5694 = G__5881;
count__5423_5695 = G__5882;
i__5424_5696 = G__5883;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref.call(null,inverted);
});
