// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.call(null,new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt.call(null,secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__63767 = arguments.length;
switch (G__63767) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.call(null,conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_63809){
var state_val_63810 = (state_63809[(1)]);
if((state_val_63810 === (7))){
var inst_63779 = typeof user === 'string';
var state_63809__$1 = state_63809;
if(cljs.core.truth_(inst_63779)){
var statearr_63811_63840 = state_63809__$1;
(statearr_63811_63840[(1)] = (9));

} else {
var statearr_63812_63841 = state_63809__$1;
(statearr_63812_63841[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63810 === (1))){
var state_63809__$1 = state_63809;
var statearr_63813_63842 = state_63809__$1;
(statearr_63813_63842[(2)] = null);

(statearr_63813_63842[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63810 === (4))){
var inst_63768 = (state_63809[(2)]);
var inst_63769 = fluree.db.util.log.error.call(null,inst_63768);
var inst_63770 = reject.call(null,inst_63768);
var state_63809__$1 = (function (){var statearr_63814 = state_63809;
(statearr_63814[(7)] = inst_63769);

return statearr_63814;
})();
var statearr_63815_63843 = state_63809__$1;
(statearr_63815_63843[(2)] = inst_63770);

(statearr_63815_63843[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63810 === (15))){
var inst_63798 = (state_63809[(2)]);
var inst_63799 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_63798);
var inst_63800 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63801 = cljs.core.constantly.call(null,inst_63799);
var inst_63802 = cljs.core.swap_BANG_.call(null,inst_63800,inst_63801);
var inst_63803 = fluree.db.connection.add_token.call(null,conn,inst_63799);
var inst_63804 = resolve.call(null,inst_63798);
var _ = (function (){var statearr_63816 = state_63809;
(statearr_63816[(4)] = cljs.core.rest.call(null,(state_63809[(4)])));

return statearr_63816;
})();
var state_63809__$1 = (function (){var statearr_63817 = state_63809;
(statearr_63817[(8)] = inst_63802);

(statearr_63817[(9)] = inst_63803);

return statearr_63817;
})();
var statearr_63818_63844 = state_63809__$1;
(statearr_63818_63844[(2)] = inst_63804);

(statearr_63818_63844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63810 === (13))){
var state_63809__$1 = state_63809;
var statearr_63819_63845 = state_63809__$1;
(statearr_63819_63845[(2)] = null);

(statearr_63819_63845[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63810 === (6))){
var state_63809__$1 = state_63809;
var statearr_63820_63846 = state_63809__$1;
(statearr_63820_63846[(2)] = user);

(statearr_63820_63846[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63810 === (3))){
var inst_63807 = (state_63809[(2)]);
var state_63809__$1 = state_63809;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63809__$1,inst_63807);
} else {
if((state_val_63810 === (12))){
var state_63809__$1 = state_63809;
var statearr_63821_63847 = state_63809__$1;
(statearr_63821_63847[(2)] = user);

(statearr_63821_63847[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63810 === (2))){
var _ = (function (){var statearr_63822 = state_63809;
(statearr_63822[(4)] = cljs.core.cons.call(null,(5),(state_63809[(4)])));

return statearr_63822;
})();
var inst_63776 = typeof user === 'number';
var state_63809__$1 = state_63809;
if(cljs.core.truth_(inst_63776)){
var statearr_63823_63848 = state_63809__$1;
(statearr_63823_63848[(1)] = (6));

} else {
var statearr_63824_63849 = state_63809__$1;
(statearr_63824_63849[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63810 === (11))){
var inst_63790 = (state_63809[(2)]);
var state_63809__$1 = state_63809;
var statearr_63826_63850 = state_63809__$1;
(statearr_63826_63850[(2)] = inst_63790);

(statearr_63826_63850[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63810 === (9))){
var inst_63781 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63782 = ["_user/username",user];
var inst_63783 = (new cljs.core.PersistentVector(null,2,(5),inst_63781,inst_63782,null));
var state_63809__$1 = state_63809;
var statearr_63827_63851 = state_63809__$1;
(statearr_63827_63851[(2)] = inst_63783);

(statearr_63827_63851[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63810 === (5))){
var _ = (function (){var statearr_63828 = state_63809;
(statearr_63828[(4)] = cljs.core.rest.call(null,(state_63809[(4)])));

return statearr_63828;
})();
var state_63809__$1 = state_63809;
var ex63825 = (state_63809__$1[(2)]);
var statearr_63829_63852 = state_63809__$1;
(statearr_63829_63852[(5)] = ex63825);


var statearr_63830_63853 = state_63809__$1;
(statearr_63830_63853[(1)] = (4));

(statearr_63830_63853[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63810 === (14))){
var inst_63788 = (state_63809[(2)]);
var state_63809__$1 = state_63809;
var statearr_63831_63854 = state_63809__$1;
(statearr_63831_63854[(2)] = inst_63788);

(statearr_63831_63854[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63810 === (10))){
var state_63809__$1 = state_63809;
var statearr_63832_63855 = state_63809__$1;
(statearr_63832_63855[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63810 === (8))){
var inst_63792 = (state_63809[(2)]);
var inst_63793 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_63794 = [account,inst_63792,password,expireSeconds,syncTo];
var inst_63795 = cljs.core.PersistentHashMap.fromArrays(inst_63793,inst_63794);
var inst_63796 = fluree.db.operations.send_operation.call(null,conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_63795);
var state_63809__$1 = state_63809;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_63809__$1,(15),inst_63796);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2879__auto__ = null;
var fluree$db$connection_js$state_machine__2879__auto____0 = (function (){
var statearr_63834 = [null,null,null,null,null,null,null,null,null,null];
(statearr_63834[(0)] = fluree$db$connection_js$state_machine__2879__auto__);

(statearr_63834[(1)] = (1));

return statearr_63834;
});
var fluree$db$connection_js$state_machine__2879__auto____1 = (function (state_63809){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_63809);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e63835){var ex__2882__auto__ = e63835;
var statearr_63836_63856 = state_63809;
(statearr_63836_63856[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_63809[(4)]))){
var statearr_63837_63857 = state_63809;
(statearr_63837_63857[(1)] = cljs.core.first.call(null,(state_63809[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63858 = state_63809;
state_63809 = G__63858;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2879__auto__ = function(state_63809){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2879__auto____1.call(this,state_63809);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2879__auto____0;
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2879__auto____1;
return fluree$db$connection_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_63838 = f__2902__auto__.call(null);
(statearr_63838[(6)] = c__2901__auto__);

return statearr_63838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__63860 = arguments.length;
switch (G__63860) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,fluree.db.connection.connect.call(null,servers_string,opts),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.call(null);
var _ = (function (){var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_63869){
var state_val_63870 = (state_63869[(1)]);
if((state_val_63870 === (1))){
var inst_63861 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_63862 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63863 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_63864 = (new cljs.core.PersistentVector(null,4,(5),inst_63862,inst_63863,null));
var inst_63865 = cljs.core.async.put_BANG_.call(null,inst_63861,inst_63864);
var inst_63866 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__63871 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__63872 = null;
var count__63873 = (0);
var i__63874 = (0);
while(true){
if((i__63874 < count__63873)){
var k = cljs.core._nth.call(null,chunk__63872,i__63874);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__63882 = seq__63871;
var G__63883 = chunk__63872;
var G__63884 = count__63873;
var G__63885 = (i__63874 + (1));
seq__63871 = G__63882;
chunk__63872 = G__63883;
count__63873 = G__63884;
i__63874 = G__63885;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__63871);
if(temp__5735__auto__){
var seq__63871__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__63871__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__63871__$1);
var G__63886 = cljs.core.chunk_rest.call(null,seq__63871__$1);
var G__63887 = c__4556__auto__;
var G__63888 = cljs.core.count.call(null,c__4556__auto__);
var G__63889 = (0);
seq__63871 = G__63886;
chunk__63872 = G__63887;
count__63873 = G__63888;
i__63874 = G__63889;
continue;
} else {
var k = cljs.core.first.call(null,seq__63871__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.call(null,x,k,null));


var G__63890 = cljs.core.next.call(null,seq__63871__$1);
var G__63891 = null;
var G__63892 = (0);
var G__63893 = (0);
seq__63871 = G__63890;
chunk__63872 = G__63891;
count__63873 = G__63892;
i__63874 = G__63893;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_63867 = cljs.core.async.take_BANG_.call(null,pc,inst_63866);
var state_63869__$1 = (function (){var statearr_63875 = state_63869;
(statearr_63875[(7)] = inst_63865);

return statearr_63875;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63869__$1,inst_63867);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2879__auto__ = null;
var fluree$db$connection_js$state_machine__2879__auto____0 = (function (){
var statearr_63876 = [null,null,null,null,null,null,null,null];
(statearr_63876[(0)] = fluree$db$connection_js$state_machine__2879__auto__);

(statearr_63876[(1)] = (1));

return statearr_63876;
});
var fluree$db$connection_js$state_machine__2879__auto____1 = (function (state_63869){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_63869);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e63877){var ex__2882__auto__ = e63877;
var statearr_63878_63894 = state_63869;
(statearr_63878_63894[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_63869[(4)]))){
var statearr_63879_63895 = state_63869;
(statearr_63879_63895[(1)] = cljs.core.first.call(null,(state_63869[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63896 = state_63869;
state_63869 = G__63896;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2879__auto__ = function(state_63869){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2879__auto____1.call(this,state_63869);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2879__auto____0;
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2879__auto____1;
return fluree$db$connection_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_63880 = f__2902__auto__.call(null);
(statearr_63880[(6)] = c__2901__auto__);

return statearr_63880;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__63898 = arguments.length;
switch (G__63898) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.call(null,servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_63932){
var state_val_63933 = (state_63932[(1)]);
if((state_val_63933 === (1))){
var state_63932__$1 = state_63932;
var statearr_63934_63955 = state_63932__$1;
(statearr_63934_63955[(2)] = null);

(statearr_63934_63955[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63933 === (2))){
var _ = (function (){var statearr_63935 = state_63932;
(statearr_63935[(4)] = cljs.core.cons.call(null,(5),(state_63932[(4)])));

return statearr_63935;
})();
var inst_63907 = fluree.db.connection.connect.call(null,servers_string,opts);
var inst_63908 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63909 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_63910 = (new cljs.core.PersistentVector(null,1,(5),inst_63908,inst_63909,null));
var inst_63911 = cljs.core.PersistentHashMap.EMPTY;
var inst_63912 = cljs.core.atom.call(null,inst_63911);
var inst_63913 = cljs.core.assoc_in.call(null,inst_63907,inst_63910,inst_63912);
var inst_63914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63915 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_63916 = (new cljs.core.PersistentVector(null,1,(5),inst_63914,inst_63915,null));
var inst_63917 = cljs.core.PersistentHashMap.EMPTY;
var inst_63918 = cljs.core.atom.call(null,inst_63917);
var inst_63919 = cljs.core.assoc_in.call(null,inst_63913,inst_63916,inst_63918);
var inst_63920 = cljs.core.async.promise_chan.call(null);
var inst_63921 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_63919);
var inst_63922 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_63923 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_63920,null];
var inst_63924 = (new cljs.core.PersistentVector(null,4,(5),inst_63922,inst_63923,null));
var inst_63925 = cljs.core.async.put_BANG_.call(null,inst_63921,inst_63924);
var inst_63926 = (function (){var conn = inst_63919;
var pc = inst_63920;
return (function (x){
if((x == null)){
} else {
var seq__63936_63956 = cljs.core.seq.call(null,cljs.core.keys.call(null,x));
var chunk__63937_63957 = null;
var count__63938_63958 = (0);
var i__63939_63959 = (0);
while(true){
if((i__63939_63959 < count__63938_63958)){
var k_63960 = cljs.core._nth.call(null,chunk__63937_63957,i__63939_63959);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_63960], null),cljs.core.get.call(null,x,k_63960,null));


var G__63961 = seq__63936_63956;
var G__63962 = chunk__63937_63957;
var G__63963 = count__63938_63958;
var G__63964 = (i__63939_63959 + (1));
seq__63936_63956 = G__63961;
chunk__63937_63957 = G__63962;
count__63938_63958 = G__63963;
i__63939_63959 = G__63964;
continue;
} else {
var temp__5735__auto___63965 = cljs.core.seq.call(null,seq__63936_63956);
if(temp__5735__auto___63965){
var seq__63936_63966__$1 = temp__5735__auto___63965;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__63936_63966__$1)){
var c__4556__auto___63967 = cljs.core.chunk_first.call(null,seq__63936_63966__$1);
var G__63968 = cljs.core.chunk_rest.call(null,seq__63936_63966__$1);
var G__63969 = c__4556__auto___63967;
var G__63970 = cljs.core.count.call(null,c__4556__auto___63967);
var G__63971 = (0);
seq__63936_63956 = G__63968;
chunk__63937_63957 = G__63969;
count__63938_63958 = G__63970;
i__63939_63959 = G__63971;
continue;
} else {
var k_63972 = cljs.core.first.call(null,seq__63936_63966__$1);
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_63972], null),cljs.core.get.call(null,x,k_63972,null));


var G__63973 = cljs.core.next.call(null,seq__63936_63966__$1);
var G__63974 = null;
var G__63975 = (0);
var G__63976 = (0);
seq__63936_63956 = G__63973;
chunk__63937_63957 = G__63974;
count__63938_63958 = G__63975;
i__63939_63959 = G__63976;
continue;
}
} else {
}
}
break;
}
}

return resolve.call(null,conn);
});
})();
var inst_63927 = cljs.core.async.take_BANG_.call(null,inst_63920,inst_63926);
var ___$1 = (function (){var statearr_63940 = state_63932;
(statearr_63940[(4)] = cljs.core.rest.call(null,(state_63932[(4)])));

return statearr_63940;
})();
var state_63932__$1 = (function (){var statearr_63941 = state_63932;
(statearr_63941[(7)] = inst_63925);

return statearr_63941;
})();
var statearr_63942_63977 = state_63932__$1;
(statearr_63942_63977[(2)] = inst_63927);

(statearr_63942_63977[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63933 === (3))){
var inst_63930 = (state_63932[(2)]);
var state_63932__$1 = state_63932;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_63932__$1,inst_63930);
} else {
if((state_val_63933 === (4))){
var inst_63899 = (state_63932[(2)]);
var inst_63900 = fluree.db.util.log.error.call(null,inst_63899);
var inst_63901 = reject.call(null,inst_63899);
var state_63932__$1 = (function (){var statearr_63944 = state_63932;
(statearr_63944[(8)] = inst_63900);

return statearr_63944;
})();
var statearr_63945_63978 = state_63932__$1;
(statearr_63945_63978[(2)] = inst_63901);

(statearr_63945_63978[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_63933 === (5))){
var _ = (function (){var statearr_63946 = state_63932;
(statearr_63946[(4)] = cljs.core.rest.call(null,(state_63932[(4)])));

return statearr_63946;
})();
var state_63932__$1 = state_63932;
var ex63943 = (state_63932__$1[(2)]);
var statearr_63947_63979 = state_63932__$1;
(statearr_63947_63979[(5)] = ex63943);


var statearr_63948_63980 = state_63932__$1;
(statearr_63948_63980[(1)] = (4));

(statearr_63948_63980[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2879__auto__ = null;
var fluree$db$connection_js$state_machine__2879__auto____0 = (function (){
var statearr_63949 = [null,null,null,null,null,null,null,null,null];
(statearr_63949[(0)] = fluree$db$connection_js$state_machine__2879__auto__);

(statearr_63949[(1)] = (1));

return statearr_63949;
});
var fluree$db$connection_js$state_machine__2879__auto____1 = (function (state_63932){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_63932);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e63950){var ex__2882__auto__ = e63950;
var statearr_63951_63981 = state_63932;
(statearr_63951_63981[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_63932[(4)]))){
var statearr_63952_63982 = state_63932;
(statearr_63952_63982[(1)] = cljs.core.first.call(null,(state_63932[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__63983 = state_63932;
state_63932 = G__63983;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2879__auto__ = function(state_63932){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2879__auto____1.call(this,state_63932);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2879__auto____0;
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2879__auto____1;
return fluree$db$connection_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_63953 = f__2902__auto__.call(null);
(statearr_63953[(6)] = c__2901__auto__);

return statearr_63953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_.call(null,conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__63985 = arguments.length;
switch (G__63985) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.call(null,conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not.call(null,open_api_QMARK_)) && (cljs.core.not.call(null,has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.call(null,"To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token.call(null,conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__63987 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__63987,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__63987,(1),null);
var cb_STAR_ = (function (header,data){
return callback.call(null,cljs.core.clj__GT_js.call(null,header),cljs.core.clj__GT_js.call(null,data));
});
return fluree.db.connection.add_listener.call(null,conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__63990 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__63990,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__63990,(1),null);
return fluree.db.connection.remove_listener.call(null,conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js.call(null,fluree.db.connection.listeners.call(null,conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64043){
var state_val_64044 = (state_64043[(1)]);
if((state_val_64044 === (7))){
var inst_64004 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64005 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_64006 = cljs.core.PersistentHashMap.fromArrays(inst_64004,inst_64005);
var inst_64007 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_64006);
var inst_64008 = (function(){throw inst_64007})();
var state_64043__$1 = state_64043;
var statearr_64045_64074 = state_64043__$1;
(statearr_64045_64074[(2)] = inst_64008);

(statearr_64045_64074[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64044 === (1))){
var state_64043__$1 = state_64043;
var statearr_64046_64075 = state_64043__$1;
(statearr_64046_64075[(2)] = null);

(statearr_64046_64075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64044 === (4))){
var inst_63993 = (state_64043[(2)]);
var inst_63994 = cljs.core.clj__GT_js.call(null,inst_63993);
var inst_63995 = reject.call(null,inst_63994);
var state_64043__$1 = state_64043;
var statearr_64047_64076 = state_64043__$1;
(statearr_64047_64076[(2)] = inst_63995);

(statearr_64047_64076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64044 === (13))){
var inst_64022 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64023 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_64024 = cljs.core.PersistentHashMap.fromArrays(inst_64022,inst_64023);
var inst_64025 = cljs.core.ex_info.call(null,"A password must be supplied.",inst_64024);
var inst_64026 = (function(){throw inst_64025})();
var state_64043__$1 = state_64043;
var statearr_64048_64077 = state_64043__$1;
(statearr_64048_64077[(2)] = inst_64026);

(statearr_64048_64077[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64044 === (6))){
var state_64043__$1 = state_64043;
var statearr_64049_64078 = state_64043__$1;
(statearr_64049_64078[(2)] = null);

(statearr_64049_64078[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64044 === (3))){
var inst_64041 = (state_64043[(2)]);
var state_64043__$1 = state_64043;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64043__$1,inst_64041);
} else {
if((state_val_64044 === (12))){
var state_64043__$1 = state_64043;
var statearr_64050_64079 = state_64043__$1;
(statearr_64050_64079[(2)] = null);

(statearr_64050_64079[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64044 === (2))){
var _ = (function (){var statearr_64051 = state_64043;
(statearr_64051[(4)] = cljs.core.cons.call(null,(5),(state_64043[(4)])));

return statearr_64051;
})();
var inst_64001 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_64043__$1 = state_64043;
if(cljs.core.truth_(inst_64001)){
var statearr_64052_64080 = state_64043__$1;
(statearr_64052_64080[(1)] = (6));

} else {
var statearr_64053_64081 = state_64043__$1;
(statearr_64053_64081[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64044 === (11))){
var inst_64019 = (state_64043[(2)]);
var state_64043__$1 = (function (){var statearr_64055 = state_64043;
(statearr_64055[(7)] = inst_64019);

return statearr_64055;
})();
if(cljs.core.truth_(password)){
var statearr_64056_64082 = state_64043__$1;
(statearr_64056_64082[(1)] = (12));

} else {
var statearr_64057_64083 = state_64043__$1;
(statearr_64057_64083[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64044 === (9))){
var state_64043__$1 = state_64043;
var statearr_64058_64084 = state_64043__$1;
(statearr_64058_64084[(2)] = null);

(statearr_64058_64084[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64044 === (5))){
var _ = (function (){var statearr_64059 = state_64043;
(statearr_64059[(4)] = cljs.core.rest.call(null,(state_64043[(4)])));

return statearr_64059;
})();
var state_64043__$1 = state_64043;
var ex64054 = (state_64043__$1[(2)]);
var statearr_64060_64085 = state_64043__$1;
(statearr_64060_64085[(5)] = ex64054);


var statearr_64061_64086 = state_64043__$1;
(statearr_64061_64086[(1)] = (4));

(statearr_64061_64086[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64044 === (14))){
var inst_64028 = (state_64043[(2)]);
var inst_64029 = cljs.core.assoc.call(null,map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,new cljs.core.Keyword(null,"password","password",417022471),password);
var inst_64030 = fluree.db.util.core.without_nils.call(null,inst_64029);
var inst_64031 = cljs.core.async.promise_chan.call(null);
var inst_64032 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_64033 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64034 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_64030,inst_64031,null];
var inst_64035 = (new cljs.core.PersistentVector(null,4,(5),inst_64033,inst_64034,null));
var inst_64036 = cljs.core.async.put_BANG_.call(null,inst_64032,inst_64035);
var inst_64037 = (function (){var _ = inst_64028;
var data = inst_64030;
var pc = inst_64031;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_64038 = cljs.core.async.take_BANG_.call(null,inst_64031,inst_64037);
var _ = (function (){var statearr_64062 = state_64043;
(statearr_64062[(4)] = cljs.core.rest.call(null,(state_64043[(4)])));

return statearr_64062;
})();
var state_64043__$1 = (function (){var statearr_64063 = state_64043;
(statearr_64063[(8)] = inst_64036);

return statearr_64063;
})();
var statearr_64064_64087 = state_64043__$1;
(statearr_64064_64087[(2)] = inst_64038);

(statearr_64064_64087[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64044 === (10))){
var inst_64013 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64014 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_64015 = cljs.core.PersistentHashMap.fromArrays(inst_64013,inst_64014);
var inst_64016 = cljs.core.ex_info.call(null,"A ledger must be supplied.",inst_64015);
var inst_64017 = (function(){throw inst_64016})();
var state_64043__$1 = state_64043;
var statearr_64065_64088 = state_64043__$1;
(statearr_64065_64088[(2)] = inst_64017);

(statearr_64065_64088[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64044 === (8))){
var inst_64010 = (state_64043[(2)]);
var state_64043__$1 = (function (){var statearr_64066 = state_64043;
(statearr_64066[(9)] = inst_64010);

return statearr_64066;
})();
if(cljs.core.truth_(ledger)){
var statearr_64067_64089 = state_64043__$1;
(statearr_64067_64089[(1)] = (9));

} else {
var statearr_64068_64090 = state_64043__$1;
(statearr_64068_64090[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2879__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2879__auto____0 = (function (){
var statearr_64069 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64069[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2879__auto__);

(statearr_64069[(1)] = (1));

return statearr_64069;
});
var fluree$db$connection_js$password_generate_$_state_machine__2879__auto____1 = (function (state_64043){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_64043);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64070){var ex__2882__auto__ = e64070;
var statearr_64071_64091 = state_64043;
(statearr_64071_64091[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_64043[(4)]))){
var statearr_64072_64092 = state_64043;
(statearr_64072_64092[(1)] = cljs.core.first.call(null,(state_64043[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64093 = state_64043;
state_64043 = G__64093;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2879__auto__ = function(state_64043){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2879__auto____1.call(this,state_64043);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2879__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2879__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64073 = f__2902__auto__.call(null);
(statearr_64073[(6)] = c__2901__auto__);

return statearr_64073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__64095 = arguments.length;
switch (G__64095) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64162){
var state_val_64163 = (state_64162[(1)]);
if((state_val_64163 === (7))){
var inst_64107 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64108 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_64109 = cljs.core.PersistentHashMap.fromArrays(inst_64107,inst_64108);
var inst_64110 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_64109);
var inst_64111 = (function(){throw inst_64110})();
var state_64162__$1 = state_64162;
var statearr_64164_64203 = state_64162__$1;
(statearr_64164_64203[(2)] = inst_64111);

(statearr_64164_64203[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64163 === (20))){
var inst_64145 = (state_64162[(2)]);
var inst_64146 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_64147 = [ledger,password,user,auth,expire];
var inst_64148 = cljs.core.PersistentHashMap.fromArrays(inst_64146,inst_64147);
var inst_64149 = fluree.db.util.core.without_nils.call(null,inst_64148);
var inst_64150 = cljs.core.async.promise_chan.call(null);
var inst_64151 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_64152 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64153 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_64149,inst_64150,null];
var inst_64154 = (new cljs.core.PersistentVector(null,4,(5),inst_64152,inst_64153,null));
var inst_64155 = cljs.core.async.put_BANG_.call(null,inst_64151,inst_64154);
var inst_64156 = (function (){var _ = inst_64145;
var data = inst_64149;
var pc = inst_64150;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data.call(null,result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message.call(null,result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
return reject.call(null,cljs.core.clj__GT_js.call(null,err_resp));
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
}
});
})();
var inst_64157 = cljs.core.async.take_BANG_.call(null,inst_64150,inst_64156);
var _ = (function (){var statearr_64165 = state_64162;
(statearr_64165[(4)] = cljs.core.rest.call(null,(state_64162[(4)])));

return statearr_64165;
})();
var state_64162__$1 = (function (){var statearr_64166 = state_64162;
(statearr_64166[(7)] = inst_64155);

return statearr_64166;
})();
var statearr_64167_64204 = state_64162__$1;
(statearr_64167_64204[(2)] = inst_64157);

(statearr_64167_64204[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64163 === (1))){
var state_64162__$1 = state_64162;
var statearr_64168_64205 = state_64162__$1;
(statearr_64168_64205[(2)] = null);

(statearr_64168_64205[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64163 === (4))){
var inst_64096 = (state_64162[(2)]);
var inst_64097 = cljs.core.clj__GT_js.call(null,inst_64096);
var inst_64098 = reject.call(null,inst_64097);
var state_64162__$1 = state_64162;
var statearr_64169_64206 = state_64162__$1;
(statearr_64169_64206[(2)] = inst_64098);

(statearr_64169_64206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64163 === (15))){
var inst_64132 = (state_64162[(8)]);
var state_64162__$1 = state_64162;
var statearr_64170_64207 = state_64162__$1;
(statearr_64170_64207[(2)] = inst_64132);

(statearr_64170_64207[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64163 === (13))){
var inst_64125 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64126 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_64127 = cljs.core.PersistentHashMap.fromArrays(inst_64125,inst_64126);
var inst_64128 = cljs.core.ex_info.call(null,"A password must be supplied in the provided JSON.",inst_64127);
var inst_64129 = (function(){throw inst_64128})();
var state_64162__$1 = state_64162;
var statearr_64171_64208 = state_64162__$1;
(statearr_64171_64208[(2)] = inst_64129);

(statearr_64171_64208[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64163 === (6))){
var state_64162__$1 = state_64162;
var statearr_64172_64209 = state_64162__$1;
(statearr_64172_64209[(2)] = null);

(statearr_64172_64209[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64163 === (17))){
var inst_64136 = (state_64162[(2)]);
var state_64162__$1 = state_64162;
if(cljs.core.truth_(inst_64136)){
var statearr_64173_64210 = state_64162__$1;
(statearr_64173_64210[(1)] = (18));

} else {
var statearr_64174_64211 = state_64162__$1;
(statearr_64174_64211[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64163 === (3))){
var inst_64160 = (state_64162[(2)]);
var state_64162__$1 = state_64162;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64162__$1,inst_64160);
} else {
if((state_val_64163 === (12))){
var state_64162__$1 = state_64162;
var statearr_64175_64212 = state_64162__$1;
(statearr_64175_64212[(2)] = null);

(statearr_64175_64212[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64163 === (2))){
var _ = (function (){var statearr_64176 = state_64162;
(statearr_64176[(4)] = cljs.core.cons.call(null,(5),(state_64162[(4)])));

return statearr_64176;
})();
var inst_64104 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_64162__$1 = state_64162;
if(cljs.core.truth_(inst_64104)){
var statearr_64177_64213 = state_64162__$1;
(statearr_64177_64213[(1)] = (6));

} else {
var statearr_64178_64214 = state_64162__$1;
(statearr_64178_64214[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64163 === (19))){
var inst_64139 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64140 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_64141 = cljs.core.PersistentHashMap.fromArrays(inst_64139,inst_64140);
var inst_64142 = cljs.core.ex_info.call(null,"A user identity or auth identity must be supplied.",inst_64141);
var inst_64143 = (function(){throw inst_64142})();
var state_64162__$1 = state_64162;
var statearr_64179_64215 = state_64162__$1;
(statearr_64179_64215[(2)] = inst_64143);

(statearr_64179_64215[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64163 === (11))){
var inst_64122 = (state_64162[(2)]);
var state_64162__$1 = (function (){var statearr_64181 = state_64162;
(statearr_64181[(9)] = inst_64122);

return statearr_64181;
})();
if(cljs.core.truth_(password)){
var statearr_64182_64216 = state_64162__$1;
(statearr_64182_64216[(1)] = (12));

} else {
var statearr_64183_64217 = state_64162__$1;
(statearr_64183_64217[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64163 === (9))){
var state_64162__$1 = state_64162;
var statearr_64184_64218 = state_64162__$1;
(statearr_64184_64218[(2)] = null);

(statearr_64184_64218[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64163 === (5))){
var _ = (function (){var statearr_64185 = state_64162;
(statearr_64185[(4)] = cljs.core.rest.call(null,(state_64162[(4)])));

return statearr_64185;
})();
var state_64162__$1 = state_64162;
var ex64180 = (state_64162__$1[(2)]);
var statearr_64186_64219 = state_64162__$1;
(statearr_64186_64219[(5)] = ex64180);


var statearr_64187_64220 = state_64162__$1;
(statearr_64187_64220[(1)] = (4));

(statearr_64187_64220[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64163 === (14))){
var inst_64132 = (state_64162[(8)]);
var inst_64131 = (state_64162[(2)]);
var inst_64132__$1 = user;
var state_64162__$1 = (function (){var statearr_64188 = state_64162;
(statearr_64188[(10)] = inst_64131);

(statearr_64188[(8)] = inst_64132__$1);

return statearr_64188;
})();
if(cljs.core.truth_(inst_64132__$1)){
var statearr_64189_64221 = state_64162__$1;
(statearr_64189_64221[(1)] = (15));

} else {
var statearr_64190_64222 = state_64162__$1;
(statearr_64190_64222[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64163 === (16))){
var state_64162__$1 = state_64162;
var statearr_64191_64223 = state_64162__$1;
(statearr_64191_64223[(2)] = auth);

(statearr_64191_64223[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64163 === (10))){
var inst_64116 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64117 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_64118 = cljs.core.PersistentHashMap.fromArrays(inst_64116,inst_64117);
var inst_64119 = cljs.core.ex_info.call(null,"A ledger must be supplied in the provided JSON.",inst_64118);
var inst_64120 = (function(){throw inst_64119})();
var state_64162__$1 = state_64162;
var statearr_64192_64224 = state_64162__$1;
(statearr_64192_64224[(2)] = inst_64120);

(statearr_64192_64224[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64163 === (18))){
var state_64162__$1 = state_64162;
var statearr_64193_64225 = state_64162__$1;
(statearr_64193_64225[(2)] = null);

(statearr_64193_64225[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64163 === (8))){
var inst_64113 = (state_64162[(2)]);
var state_64162__$1 = (function (){var statearr_64194 = state_64162;
(statearr_64194[(11)] = inst_64113);

return statearr_64194;
})();
if(cljs.core.truth_(ledger)){
var statearr_64195_64226 = state_64162__$1;
(statearr_64195_64226[(1)] = (9));

} else {
var statearr_64196_64227 = state_64162__$1;
(statearr_64196_64227[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2879__auto__ = null;
var fluree$db$connection_js$state_machine__2879__auto____0 = (function (){
var statearr_64197 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64197[(0)] = fluree$db$connection_js$state_machine__2879__auto__);

(statearr_64197[(1)] = (1));

return statearr_64197;
});
var fluree$db$connection_js$state_machine__2879__auto____1 = (function (state_64162){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_64162);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64198){var ex__2882__auto__ = e64198;
var statearr_64199_64228 = state_64162;
(statearr_64199_64228[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_64162[(4)]))){
var statearr_64200_64229 = state_64162;
(statearr_64200_64229[(1)] = cljs.core.first.call(null,(state_64162[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64230 = state_64162;
state_64162 = G__64230;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2879__auto__ = function(state_64162){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2879__auto____1.call(this,state_64162);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2879__auto____0;
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2879__auto____1;
return fluree$db$connection_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64201 = f__2902__auto__.call(null);
(statearr_64201[(6)] = c__2901__auto__);

return statearr_64201;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__64232 = arguments.length;
switch (G__64232) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64267){
var state_val_64268 = (state_64267[(1)]);
if((state_val_64268 === (1))){
var state_64267__$1 = state_64267;
var statearr_64269_64289 = state_64267__$1;
(statearr_64269_64289[(2)] = null);

(statearr_64269_64289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64268 === (2))){
var _ = (function (){var statearr_64270 = state_64267;
(statearr_64270[(4)] = cljs.core.cons.call(null,(5),(state_64267[(4)])));

return statearr_64270;
})();
var inst_64241 = fluree.db.connection_js.password_enabled_QMARK_.call(null,conn);
var state_64267__$1 = state_64267;
if(cljs.core.truth_(inst_64241)){
var statearr_64271_64290 = state_64267__$1;
(statearr_64271_64290[(1)] = (6));

} else {
var statearr_64272_64291 = state_64267__$1;
(statearr_64272_64291[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64268 === (3))){
var inst_64265 = (state_64267[(2)]);
var state_64267__$1 = state_64267;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_64267__$1,inst_64265);
} else {
if((state_val_64268 === (4))){
var inst_64233 = (state_64267[(2)]);
var inst_64234 = cljs.core.clj__GT_js.call(null,inst_64233);
var inst_64235 = reject.call(null,inst_64234);
var state_64267__$1 = state_64267;
var statearr_64274_64292 = state_64267__$1;
(statearr_64274_64292[(2)] = inst_64235);

(statearr_64274_64292[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64268 === (5))){
var _ = (function (){var statearr_64275 = state_64267;
(statearr_64275[(4)] = cljs.core.rest.call(null,(state_64267[(4)])));

return statearr_64275;
})();
var state_64267__$1 = state_64267;
var ex64273 = (state_64267__$1[(2)]);
var statearr_64276_64293 = state_64267__$1;
(statearr_64276_64293[(5)] = ex64273);


var statearr_64277_64294 = state_64267__$1;
(statearr_64277_64294[(1)] = (4));

(statearr_64277_64294[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64268 === (6))){
var state_64267__$1 = state_64267;
var statearr_64278_64295 = state_64267__$1;
(statearr_64278_64295[(2)] = null);

(statearr_64278_64295[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64268 === (7))){
var inst_64244 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64245 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_64246 = cljs.core.PersistentHashMap.fromArrays(inst_64244,inst_64245);
var inst_64247 = cljs.core.ex_info.call(null,"Password authentication is not enabled.",inst_64246);
var inst_64248 = (function(){throw inst_64247})();
var state_64267__$1 = state_64267;
var statearr_64279_64296 = state_64267__$1;
(statearr_64279_64296[(2)] = inst_64248);

(statearr_64279_64296[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64268 === (8))){
var inst_64250 = (state_64267[(2)]);
var inst_64251 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_64252 = [jwt,expire];
var inst_64253 = cljs.core.PersistentHashMap.fromArrays(inst_64251,inst_64252);
var inst_64254 = fluree.db.util.core.without_nils.call(null,inst_64253);
var inst_64255 = cljs.core.async.promise_chan.call(null);
var inst_64256 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_64257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64258 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_64254,inst_64255,null];
var inst_64259 = (new cljs.core.PersistentVector(null,4,(5),inst_64257,inst_64258,null));
var inst_64260 = cljs.core.async.put_BANG_.call(null,inst_64256,inst_64259);
var inst_64261 = (function (){var _ = inst_64250;
var data = inst_64254;
var pc = inst_64255;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.call(null,"The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
return reject.call(null,cljs.core.clj__GT_js.call(null,result));
} else {
return null;
}
} else {
fluree.db.connection.add_token.call(null,conn,result);

return resolve.call(null,cljs.core.clj__GT_js.call(null,result));

}
});
})();
var inst_64262 = cljs.core.async.take_BANG_.call(null,inst_64255,inst_64261);
var _ = (function (){var statearr_64280 = state_64267;
(statearr_64280[(4)] = cljs.core.rest.call(null,(state_64267[(4)])));

return statearr_64280;
})();
var state_64267__$1 = (function (){var statearr_64281 = state_64267;
(statearr_64281[(7)] = inst_64260);

return statearr_64281;
})();
var statearr_64282_64297 = state_64267__$1;
(statearr_64282_64297[(2)] = inst_64262);

(statearr_64282_64297[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2879__auto__ = null;
var fluree$db$connection_js$state_machine__2879__auto____0 = (function (){
var statearr_64283 = [null,null,null,null,null,null,null,null];
(statearr_64283[(0)] = fluree$db$connection_js$state_machine__2879__auto__);

(statearr_64283[(1)] = (1));

return statearr_64283;
});
var fluree$db$connection_js$state_machine__2879__auto____1 = (function (state_64267){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_64267);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64284){var ex__2882__auto__ = e64284;
var statearr_64285_64298 = state_64267;
(statearr_64285_64298[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_64267[(4)]))){
var statearr_64286_64299 = state_64267;
(statearr_64286_64299[(1)] = cljs.core.first.call(null,(state_64267[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64300 = state_64267;
state_64267 = G__64300;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2879__auto__ = function(state_64267){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2879__auto____1.call(this,state_64267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2879__auto____0;
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2879__auto____1;
return fluree$db$connection_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64287 = f__2902__auto__.call(null);
(statearr_64287[(6)] = c__2901__auto__);

return statearr_64287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

