// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4785__auto___54318 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol(null,"if","if",1181717262,null),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(new cljs.core.List(null,new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null)))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_54369){
var state_val_54370 = (state_54369[(1)]);
if((state_val_54370 === (7))){
var inst_54364 = (state_54369[(2)]);
var _ = (function (){var statearr_54371 = state_54369;
(statearr_54371[(4)] = cljs.core.rest.call(null,(state_54369[(4)])));

return statearr_54371;
})();
var state_54369__$1 = state_54369;
var statearr_54372_54399 = state_54369__$1;
(statearr_54372_54399[(2)] = inst_54364);

(statearr_54372_54399[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54370 === (1))){
var state_54369__$1 = state_54369;
var statearr_54373_54400 = state_54369__$1;
(statearr_54373_54400[(2)] = null);

(statearr_54373_54400[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54370 === (4))){
var inst_54319 = (state_54369[(2)]);
var state_54369__$1 = state_54369;
var statearr_54374_54401 = state_54369__$1;
(statearr_54374_54401[(2)] = inst_54319);

(statearr_54374_54401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54370 === (13))){
var inst_54360 = (state_54369[(2)]);
var state_54369__$1 = state_54369;
var statearr_54375_54402 = state_54369__$1;
(statearr_54375_54402[(2)] = inst_54360);

(statearr_54375_54402[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54370 === (6))){
var inst_54344 = (state_54369[(7)]);
var inst_54337 = (state_54369[(8)]);
var inst_54343 = cljs.core.seq.call(null,inst_54337);
var inst_54344__$1 = cljs.core.first.call(null,inst_54343);
var inst_54345 = cljs.core.next.call(null,inst_54343);
var inst_54346 = cljs.core.not.call(null,inst_54344__$1);
var state_54369__$1 = (function (){var statearr_54376 = state_54369;
(statearr_54376[(7)] = inst_54344__$1);

(statearr_54376[(9)] = inst_54345);

return statearr_54376;
})();
if(inst_54346){
var statearr_54377_54403 = state_54369__$1;
(statearr_54377_54403[(1)] = (8));

} else {
var statearr_54378_54404 = state_54369__$1;
(statearr_54378_54404[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54370 === (3))){
var inst_54367 = (state_54369[(2)]);
var state_54369__$1 = state_54369;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54369__$1,inst_54367);
} else {
if((state_val_54370 === (12))){
var inst_54344 = (state_54369[(7)]);
var inst_54338 = (state_54369[(10)]);
var inst_54345 = (state_54369[(9)]);
var inst_54357 = cljs.core.conj.call(null,inst_54338,inst_54344);
var inst_54337 = inst_54345;
var inst_54338__$1 = inst_54357;
var state_54369__$1 = (function (){var statearr_54379 = state_54369;
(statearr_54379[(10)] = inst_54338__$1);

(statearr_54379[(8)] = inst_54337);

return statearr_54379;
})();
var statearr_54380_54405 = state_54369__$1;
(statearr_54380_54405[(2)] = null);

(statearr_54380_54405[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54370 === (2))){
var _ = (function (){var statearr_54381 = state_54369;
(statearr_54381[(4)] = cljs.core.cons.call(null,(5),(state_54369[(4)])));

return statearr_54381;
})();
var inst_54332 = args;
var inst_54333 = cljs.core.seq.call(null,inst_54332);
var inst_54334 = cljs.core.first.call(null,inst_54333);
var inst_54335 = cljs.core.next.call(null,inst_54333);
var inst_54336 = cljs.core.PersistentVector.EMPTY;
var inst_54337 = inst_54332;
var inst_54338 = inst_54336;
var state_54369__$1 = (function (){var statearr_54382 = state_54369;
(statearr_54382[(11)] = inst_54335);

(statearr_54382[(10)] = inst_54338);

(statearr_54382[(12)] = inst_54334);

(statearr_54382[(8)] = inst_54337);

return statearr_54382;
})();
var statearr_54383_54406 = state_54369__$1;
(statearr_54383_54406[(2)] = null);

(statearr_54383_54406[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54370 === (11))){
var inst_54344 = (state_54369[(7)]);
var state_54369__$1 = state_54369;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54369__$1,(14),inst_54344);
} else {
if((state_val_54370 === (9))){
var inst_54344 = (state_54369[(7)]);
var inst_54349 = fluree.db.util.async.channel_QMARK_.call(null,inst_54344);
var state_54369__$1 = state_54369;
if(inst_54349){
var statearr_54385_54407 = state_54369__$1;
(statearr_54385_54407[(1)] = (11));

} else {
var statearr_54386_54408 = state_54369__$1;
(statearr_54386_54408[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54370 === (5))){
var _ = (function (){var statearr_54387 = state_54369;
(statearr_54387[(4)] = cljs.core.rest.call(null,(state_54369[(4)])));

return statearr_54387;
})();
var state_54369__$1 = state_54369;
var ex54384 = (state_54369__$1[(2)]);
var statearr_54388_54409 = state_54369__$1;
(statearr_54388_54409[(5)] = ex54384);


if((ex54384 instanceof Error)){
var statearr_54389_54410 = state_54369__$1;
(statearr_54389_54410[(1)] = (4));

(statearr_54389_54410[(5)] = null);

} else {
throw ex54384;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54370 === (14))){
var inst_54338 = (state_54369[(10)]);
var inst_54345 = (state_54369[(9)]);
var inst_54352 = (state_54369[(2)]);
var inst_54353 = fluree.db.util.async.throw_err.call(null,inst_54352);
var inst_54354 = cljs.core.conj.call(null,inst_54338,inst_54353);
var inst_54337 = inst_54345;
var inst_54338__$1 = inst_54354;
var state_54369__$1 = (function (){var statearr_54390 = state_54369;
(statearr_54390[(10)] = inst_54338__$1);

(statearr_54390[(8)] = inst_54337);

return statearr_54390;
})();
var statearr_54391_54411 = state_54369__$1;
(statearr_54391_54411[(2)] = null);

(statearr_54391_54411[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54370 === (10))){
var inst_54362 = (state_54369[(2)]);
var state_54369__$1 = state_54369;
var statearr_54392_54412 = state_54369__$1;
(statearr_54392_54412[(2)] = inst_54362);

(statearr_54392_54412[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54370 === (8))){
var inst_54338 = (state_54369[(10)]);
var state_54369__$1 = state_54369;
var statearr_54393_54413 = state_54369__$1;
(statearr_54393_54413[(2)] = inst_54338);

(statearr_54393_54413[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto____0 = (function (){
var statearr_54394 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54394[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto__);

(statearr_54394[(1)] = (1));

return statearr_54394;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto____1 = (function (state_54369){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_54369);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e54395){var ex__2882__auto__ = e54395;
var statearr_54396_54414 = state_54369;
(statearr_54396_54414[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_54369[(4)]))){
var statearr_54397_54415 = state_54369;
(statearr_54397_54415[(1)] = cljs.core.first.call(null,(state_54369[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54416 = state_54369;
state_54369 = G__54416;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto__ = function(state_54369){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto____1.call(this,state_54369);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_54398 = f__2902__auto__.call(null);
(statearr_54398[(6)] = c__2901__auto__);

return statearr_54398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__54417 = entry;
var res = cljs.core.nth.call(null,vec__54417,(0),null);
var cost = cljs.core.nth.call(null,vec__54417,(1),null);
fluree.db.util.log.debug.call(null,"Smart function stack: ",res);

return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.call(null,s,new cljs.core.Keyword(null,"stack","stack",-793405930),cljs.core.conj.call(null,new cljs.core.Keyword(null,"stack","stack",-793405930).cljs$core$IFn$_invoke$arity$1(s),entry),new cljs.core.Keyword(null,"credits","credits",785860820),fluree.db.dbfunctions.internal._.call(null,new cljs.core.Keyword(null,"credits","credits",785860820).cljs$core$IFn$_invoke$arity$1(s),cost),new cljs.core.Keyword(null,"spent","spent",-62769180),fluree.db.dbfunctions.internal._PLUS_.call(null,new cljs.core.Keyword(null,"spent","spent",-62769180).cljs$core$IFn$_invoke$arity$1(s),cost));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.call(null,msg,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"stack","stack",-793405930),fluree.db.dbfunctions.fns.stack.call(null,_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_54465){
var state_val_54466 = (state_54465[(1)]);
if((state_val_54466 === (7))){
var state_54465__$1 = state_54465;
var statearr_54467_54496 = state_54465__$1;
(statearr_54467_54496[(2)] = coll);

(statearr_54467_54496[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54466 === (1))){
var state_54465__$1 = state_54465;
var statearr_54468_54497 = state_54465__$1;
(statearr_54468_54497[(2)] = null);

(statearr_54468_54497[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54466 === (4))){
var inst_54420 = (state_54465[(2)]);
var state_54465__$1 = state_54465;
var statearr_54469_54498 = state_54465__$1;
(statearr_54469_54498[(2)] = inst_54420);

(statearr_54469_54498[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54466 === (15))){
var inst_54439 = (state_54465[(7)]);
var inst_54447 = (state_54465[(2)]);
var inst_54448 = fluree.db.dbfunctions.internal.nth.call(null,inst_54439,inst_54447);
var inst_54449 = cljs.core.count.call(null,inst_54439);
var inst_54450 = ((9) + inst_54449);
var inst_54451 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54452 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54454 = [inst_54439,inst_54447];
var inst_54455 = (new cljs.core.PersistentVector(null,2,(5),inst_54453,inst_54454,null));
var inst_54456 = ["nth",inst_54455,inst_54448];
var inst_54457 = cljs.core.PersistentHashMap.fromArrays(inst_54452,inst_54456);
var inst_54458 = [inst_54457,inst_54450];
var inst_54459 = (new cljs.core.PersistentVector(null,2,(5),inst_54451,inst_54458,null));
var inst_54460 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54459);
var _ = (function (){var statearr_54470 = state_54465;
(statearr_54470[(4)] = cljs.core.rest.call(null,(state_54465[(4)])));

return statearr_54470;
})();
var state_54465__$1 = (function (){var statearr_54471 = state_54465;
(statearr_54471[(8)] = inst_54460);

return statearr_54471;
})();
var statearr_54472_54499 = state_54465__$1;
(statearr_54472_54499[(2)] = inst_54448);

(statearr_54472_54499[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54466 === (13))){
var state_54465__$1 = state_54465;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54465__$1,(16),key);
} else {
if((state_val_54466 === (6))){
var state_54465__$1 = state_54465;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54465__$1,(9),coll);
} else {
if((state_val_54466 === (3))){
var inst_54463 = (state_54465[(2)]);
var state_54465__$1 = state_54465;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54465__$1,inst_54463);
} else {
if((state_val_54466 === (12))){
var inst_54439 = (state_54465[(2)]);
var inst_54440 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_54465__$1 = (function (){var statearr_54473 = state_54465;
(statearr_54473[(7)] = inst_54439);

return statearr_54473;
})();
if(inst_54440){
var statearr_54474_54500 = state_54465__$1;
(statearr_54474_54500[(1)] = (13));

} else {
var statearr_54475_54501 = state_54465__$1;
(statearr_54475_54501[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54466 === (2))){
var _ = (function (){var statearr_54476 = state_54465;
(statearr_54476[(4)] = cljs.core.cons.call(null,(5),(state_54465[(4)])));

return statearr_54476;
})();
var inst_54426 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_54465__$1 = state_54465;
if(inst_54426){
var statearr_54477_54502 = state_54465__$1;
(statearr_54477_54502[(1)] = (6));

} else {
var statearr_54478_54503 = state_54465__$1;
(statearr_54478_54503[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54466 === (11))){
var inst_54433 = (state_54465[(9)]);
var state_54465__$1 = state_54465;
var statearr_54480_54504 = state_54465__$1;
(statearr_54480_54504[(2)] = inst_54433);

(statearr_54480_54504[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54466 === (9))){
var inst_54429 = (state_54465[(2)]);
var inst_54430 = fluree.db.util.async.throw_err.call(null,inst_54429);
var state_54465__$1 = state_54465;
var statearr_54481_54505 = state_54465__$1;
(statearr_54481_54505[(2)] = inst_54430);

(statearr_54481_54505[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54466 === (5))){
var _ = (function (){var statearr_54482 = state_54465;
(statearr_54482[(4)] = cljs.core.rest.call(null,(state_54465[(4)])));

return statearr_54482;
})();
var state_54465__$1 = state_54465;
var ex54479 = (state_54465__$1[(2)]);
var statearr_54483_54506 = state_54465__$1;
(statearr_54483_54506[(5)] = ex54479);


if((ex54479 instanceof Error)){
var statearr_54484_54507 = state_54465__$1;
(statearr_54484_54507[(1)] = (4));

(statearr_54484_54507[(5)] = null);

} else {
throw ex54479;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54466 === (14))){
var state_54465__$1 = state_54465;
var statearr_54485_54508 = state_54465__$1;
(statearr_54485_54508[(2)] = key);

(statearr_54485_54508[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54466 === (16))){
var inst_54443 = (state_54465[(2)]);
var inst_54444 = fluree.db.util.async.throw_err.call(null,inst_54443);
var state_54465__$1 = state_54465;
var statearr_54486_54509 = state_54465__$1;
(statearr_54486_54509[(2)] = inst_54444);

(statearr_54486_54509[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54466 === (10))){
var inst_54433 = (state_54465[(9)]);
var inst_54436 = cljs.core.vec.call(null,inst_54433);
var state_54465__$1 = state_54465;
var statearr_54487_54510 = state_54465__$1;
(statearr_54487_54510[(2)] = inst_54436);

(statearr_54487_54510[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54466 === (8))){
var inst_54433 = (state_54465[(9)]);
var inst_54433__$1 = (state_54465[(2)]);
var inst_54434 = cljs.core.set_QMARK_.call(null,inst_54433__$1);
var state_54465__$1 = (function (){var statearr_54488 = state_54465;
(statearr_54488[(9)] = inst_54433__$1);

return statearr_54488;
})();
if(inst_54434){
var statearr_54489_54511 = state_54465__$1;
(statearr_54489_54511[(1)] = (10));

} else {
var statearr_54490_54512 = state_54465__$1;
(statearr_54490_54512[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto____0 = (function (){
var statearr_54491 = [null,null,null,null,null,null,null,null,null,null];
(statearr_54491[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto__);

(statearr_54491[(1)] = (1));

return statearr_54491;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto____1 = (function (state_54465){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_54465);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e54492){var ex__2882__auto__ = e54492;
var statearr_54493_54513 = state_54465;
(statearr_54493_54513[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_54465[(4)]))){
var statearr_54494_54514 = state_54465;
(statearr_54494_54514[(1)] = cljs.core.first.call(null,(state_54465[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54515 = state_54465;
state_54465 = G__54515;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto__ = function(state_54465){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto____1.call(this,state_54465);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_54495 = f__2902__auto__.call(null);
(statearr_54495[(6)] = c__2901__auto__);

return statearr_54495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_54576){
var state_val_54577 = (state_54576[(1)]);
if((state_val_54577 === (7))){
var state_54576__$1 = state_54576;
var statearr_54578_54612 = state_54576__$1;
(statearr_54578_54612[(2)] = test);

(statearr_54578_54612[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54577 === (20))){
var inst_54550 = (state_54576[(2)]);
var inst_54551 = fluree.db.util.async.throw_err.call(null,inst_54550);
var state_54576__$1 = state_54576;
var statearr_54579_54613 = state_54576__$1;
(statearr_54579_54613[(2)] = inst_54551);

(statearr_54579_54613[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54577 === (1))){
var state_54576__$1 = state_54576;
var statearr_54580_54614 = state_54576__$1;
(statearr_54580_54614[(2)] = null);

(statearr_54580_54614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54577 === (4))){
var inst_54516 = (state_54576[(2)]);
var state_54576__$1 = state_54576;
var statearr_54581_54615 = state_54576__$1;
(statearr_54581_54615[(2)] = inst_54516);

(statearr_54581_54615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54577 === (15))){
var inst_54534 = (state_54576[(7)]);
var inst_54542 = (state_54576[(2)]);
var inst_54543 = [inst_54542,f];
var inst_54544 = (new cljs.core.PersistentVector(null,2,(5),inst_54534,inst_54543,null));
var state_54576__$1 = state_54576;
var statearr_54582_54616 = state_54576__$1;
(statearr_54582_54616[(2)] = inst_54544);

(statearr_54582_54616[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54577 === (13))){
var state_54576__$1 = state_54576;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54576__$1,(16),t);
} else {
if((state_val_54577 === (6))){
var state_54576__$1 = state_54576;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54576__$1,(9),test);
} else {
if((state_val_54577 === (17))){
var state_54576__$1 = state_54576;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54576__$1,(20),f);
} else {
if((state_val_54577 === (3))){
var inst_54574 = (state_54576[(2)]);
var state_54576__$1 = state_54576;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54576__$1,inst_54574);
} else {
if((state_val_54577 === (12))){
var inst_54532 = (state_54576[(8)]);
var inst_54558 = (state_54576[(2)]);
var inst_54559 = cljs.core.nth.call(null,inst_54558,(0),null);
var inst_54560 = cljs.core.nth.call(null,inst_54558,(1),null);
var inst_54561 = fluree.db.dbfunctions.internal.if_else.call(null,inst_54532,inst_54559,inst_54560);
var inst_54562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54563 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54565 = [inst_54532,inst_54559,inst_54560];
var inst_54566 = (new cljs.core.PersistentVector(null,3,(5),inst_54564,inst_54565,null));
var inst_54567 = ["if-else",inst_54566,inst_54561];
var inst_54568 = cljs.core.PersistentHashMap.fromArrays(inst_54563,inst_54567);
var inst_54569 = [inst_54568,(10)];
var inst_54570 = (new cljs.core.PersistentVector(null,2,(5),inst_54562,inst_54569,null));
var inst_54571 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54570);
var _ = (function (){var statearr_54583 = state_54576;
(statearr_54583[(4)] = cljs.core.rest.call(null,(state_54576[(4)])));

return statearr_54583;
})();
var state_54576__$1 = (function (){var statearr_54584 = state_54576;
(statearr_54584[(9)] = inst_54571);

return statearr_54584;
})();
var statearr_54585_54617 = state_54576__$1;
(statearr_54585_54617[(2)] = inst_54561);

(statearr_54585_54617[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54577 === (2))){
var _ = (function (){var statearr_54586 = state_54576;
(statearr_54586[(4)] = cljs.core.cons.call(null,(5),(state_54576[(4)])));

return statearr_54586;
})();
var inst_54525 = fluree.db.util.async.channel_QMARK_.call(null,test);
var state_54576__$1 = state_54576;
if(inst_54525){
var statearr_54587_54618 = state_54576__$1;
(statearr_54587_54618[(1)] = (6));

} else {
var statearr_54588_54619 = state_54576__$1;
(statearr_54588_54619[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54577 === (19))){
var inst_54546 = (state_54576[(10)]);
var inst_54554 = (state_54576[(2)]);
var inst_54555 = [f,inst_54554];
var inst_54556 = (new cljs.core.PersistentVector(null,2,(5),inst_54546,inst_54555,null));
var state_54576__$1 = state_54576;
var statearr_54589_54620 = state_54576__$1;
(statearr_54589_54620[(2)] = inst_54556);

(statearr_54589_54620[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54577 === (11))){
var inst_54546 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54547 = fluree.db.util.async.channel_QMARK_.call(null,f);
var state_54576__$1 = (function (){var statearr_54591 = state_54576;
(statearr_54591[(10)] = inst_54546);

return statearr_54591;
})();
if(inst_54547){
var statearr_54592_54621 = state_54576__$1;
(statearr_54592_54621[(1)] = (17));

} else {
var statearr_54593_54622 = state_54576__$1;
(statearr_54593_54622[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54577 === (9))){
var inst_54528 = (state_54576[(2)]);
var inst_54529 = fluree.db.util.async.throw_err.call(null,inst_54528);
var state_54576__$1 = state_54576;
var statearr_54594_54623 = state_54576__$1;
(statearr_54594_54623[(2)] = inst_54529);

(statearr_54594_54623[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54577 === (5))){
var _ = (function (){var statearr_54595 = state_54576;
(statearr_54595[(4)] = cljs.core.rest.call(null,(state_54576[(4)])));

return statearr_54595;
})();
var state_54576__$1 = state_54576;
var ex54590 = (state_54576__$1[(2)]);
var statearr_54596_54624 = state_54576__$1;
(statearr_54596_54624[(5)] = ex54590);


if((ex54590 instanceof Error)){
var statearr_54597_54625 = state_54576__$1;
(statearr_54597_54625[(1)] = (4));

(statearr_54597_54625[(5)] = null);

} else {
throw ex54590;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54577 === (14))){
var state_54576__$1 = state_54576;
var statearr_54598_54626 = state_54576__$1;
(statearr_54598_54626[(2)] = t);

(statearr_54598_54626[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54577 === (16))){
var inst_54538 = (state_54576[(2)]);
var inst_54539 = fluree.db.util.async.throw_err.call(null,inst_54538);
var state_54576__$1 = state_54576;
var statearr_54599_54627 = state_54576__$1;
(statearr_54599_54627[(2)] = inst_54539);

(statearr_54599_54627[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54577 === (10))){
var inst_54534 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54535 = fluree.db.util.async.channel_QMARK_.call(null,t);
var state_54576__$1 = (function (){var statearr_54600 = state_54576;
(statearr_54600[(7)] = inst_54534);

return statearr_54600;
})();
if(inst_54535){
var statearr_54601_54628 = state_54576__$1;
(statearr_54601_54628[(1)] = (13));

} else {
var statearr_54602_54629 = state_54576__$1;
(statearr_54602_54629[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54577 === (18))){
var state_54576__$1 = state_54576;
var statearr_54603_54630 = state_54576__$1;
(statearr_54603_54630[(2)] = f);

(statearr_54603_54630[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54577 === (8))){
var inst_54532 = (state_54576[(8)]);
var inst_54532__$1 = (state_54576[(2)]);
var state_54576__$1 = (function (){var statearr_54604 = state_54576;
(statearr_54604[(8)] = inst_54532__$1);

return statearr_54604;
})();
if(cljs.core.truth_(inst_54532__$1)){
var statearr_54605_54631 = state_54576__$1;
(statearr_54605_54631[(1)] = (10));

} else {
var statearr_54606_54632 = state_54576__$1;
(statearr_54606_54632[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto____0 = (function (){
var statearr_54607 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54607[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto__);

(statearr_54607[(1)] = (1));

return statearr_54607;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto____1 = (function (state_54576){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_54576);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e54608){var ex__2882__auto__ = e54608;
var statearr_54609_54633 = state_54576;
(statearr_54609_54633[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_54576[(4)]))){
var statearr_54610_54634 = state_54576;
(statearr_54610_54634[(1)] = cljs.core.first.call(null,(state_54576[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54635 = state_54576;
state_54576 = G__54635;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto__ = function(state_54576){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto____1.call(this,state_54576);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_54611 = f__2902__auto__.call(null);
(statearr_54611[(6)] = c__2901__auto__);

return statearr_54611;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_54665){
var state_val_54666 = (state_54665[(1)]);
if((state_val_54666 === (7))){
var state_54665__$1 = state_54665;
var statearr_54667_54686 = state_54665__$1;
(statearr_54667_54686[(2)] = arg);

(statearr_54667_54686[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54666 === (1))){
var state_54665__$1 = state_54665;
var statearr_54668_54687 = state_54665__$1;
(statearr_54668_54687[(2)] = null);

(statearr_54668_54687[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54666 === (4))){
var inst_54636 = (state_54665[(2)]);
var state_54665__$1 = state_54665;
var statearr_54669_54688 = state_54665__$1;
(statearr_54669_54688[(2)] = inst_54636);

(statearr_54669_54688[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54666 === (6))){
var state_54665__$1 = state_54665;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54665__$1,(9),arg);
} else {
if((state_val_54666 === (3))){
var inst_54663 = (state_54665[(2)]);
var state_54665__$1 = state_54665;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54665__$1,inst_54663);
} else {
if((state_val_54666 === (2))){
var _ = (function (){var statearr_54671 = state_54665;
(statearr_54671[(4)] = cljs.core.cons.call(null,(5),(state_54665[(4)])));

return statearr_54671;
})();
var inst_54642 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_54665__$1 = state_54665;
if(inst_54642){
var statearr_54672_54689 = state_54665__$1;
(statearr_54672_54689[(1)] = (6));

} else {
var statearr_54673_54690 = state_54665__$1;
(statearr_54673_54690[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54666 === (9))){
var inst_54645 = (state_54665[(2)]);
var inst_54646 = fluree.db.util.async.throw_err.call(null,inst_54645);
var state_54665__$1 = state_54665;
var statearr_54674_54691 = state_54665__$1;
(statearr_54674_54691[(2)] = inst_54646);

(statearr_54674_54691[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54666 === (5))){
var _ = (function (){var statearr_54675 = state_54665;
(statearr_54675[(4)] = cljs.core.rest.call(null,(state_54665[(4)])));

return statearr_54675;
})();
var state_54665__$1 = state_54665;
var ex54670 = (state_54665__$1[(2)]);
var statearr_54676_54692 = state_54665__$1;
(statearr_54676_54692[(5)] = ex54670);


if((ex54670 instanceof Error)){
var statearr_54677_54693 = state_54665__$1;
(statearr_54677_54693[(1)] = (4));

(statearr_54677_54693[(5)] = null);

} else {
throw ex54670;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54666 === (8))){
var inst_54649 = (state_54665[(2)]);
var inst_54650 = fluree.db.dbfunctions.internal.nil_QMARK_.call(null,inst_54649);
var inst_54651 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54652 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54654 = [inst_54649];
var inst_54655 = (new cljs.core.PersistentVector(null,1,(5),inst_54653,inst_54654,null));
var inst_54656 = ["nil?",inst_54655,inst_54650];
var inst_54657 = cljs.core.PersistentHashMap.fromArrays(inst_54652,inst_54656);
var inst_54658 = [inst_54657,(10)];
var inst_54659 = (new cljs.core.PersistentVector(null,2,(5),inst_54651,inst_54658,null));
var inst_54660 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54659);
var _ = (function (){var statearr_54678 = state_54665;
(statearr_54678[(4)] = cljs.core.rest.call(null,(state_54665[(4)])));

return statearr_54678;
})();
var state_54665__$1 = (function (){var statearr_54679 = state_54665;
(statearr_54679[(7)] = inst_54660);

return statearr_54679;
})();
var statearr_54680_54694 = state_54665__$1;
(statearr_54680_54694[(2)] = inst_54650);

(statearr_54680_54694[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto____0 = (function (){
var statearr_54681 = [null,null,null,null,null,null,null,null];
(statearr_54681[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto__);

(statearr_54681[(1)] = (1));

return statearr_54681;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto____1 = (function (state_54665){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_54665);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e54682){var ex__2882__auto__ = e54682;
var statearr_54683_54695 = state_54665;
(statearr_54683_54695[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_54665[(4)]))){
var statearr_54684_54696 = state_54665;
(statearr_54684_54696[(1)] = cljs.core.first.call(null,(state_54665[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54697 = state_54665;
state_54665 = G__54697;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto__ = function(state_54665){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto____1.call(this,state_54665);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_54685 = f__2902__auto__.call(null);
(statearr_54685[(6)] = c__2901__auto__);

return statearr_54685;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_54727){
var state_val_54728 = (state_54727[(1)]);
if((state_val_54728 === (7))){
var state_54727__$1 = state_54727;
var statearr_54729_54748 = state_54727__$1;
(statearr_54729_54748[(2)] = arg);

(statearr_54729_54748[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54728 === (1))){
var state_54727__$1 = state_54727;
var statearr_54730_54749 = state_54727__$1;
(statearr_54730_54749[(2)] = null);

(statearr_54730_54749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54728 === (4))){
var inst_54698 = (state_54727[(2)]);
var state_54727__$1 = state_54727;
var statearr_54731_54750 = state_54727__$1;
(statearr_54731_54750[(2)] = inst_54698);

(statearr_54731_54750[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54728 === (6))){
var state_54727__$1 = state_54727;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54727__$1,(9),arg);
} else {
if((state_val_54728 === (3))){
var inst_54725 = (state_54727[(2)]);
var state_54727__$1 = state_54727;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54727__$1,inst_54725);
} else {
if((state_val_54728 === (2))){
var _ = (function (){var statearr_54733 = state_54727;
(statearr_54733[(4)] = cljs.core.cons.call(null,(5),(state_54727[(4)])));

return statearr_54733;
})();
var inst_54704 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_54727__$1 = state_54727;
if(inst_54704){
var statearr_54734_54751 = state_54727__$1;
(statearr_54734_54751[(1)] = (6));

} else {
var statearr_54735_54752 = state_54727__$1;
(statearr_54735_54752[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54728 === (9))){
var inst_54707 = (state_54727[(2)]);
var inst_54708 = fluree.db.util.async.throw_err.call(null,inst_54707);
var state_54727__$1 = state_54727;
var statearr_54736_54753 = state_54727__$1;
(statearr_54736_54753[(2)] = inst_54708);

(statearr_54736_54753[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54728 === (5))){
var _ = (function (){var statearr_54737 = state_54727;
(statearr_54737[(4)] = cljs.core.rest.call(null,(state_54727[(4)])));

return statearr_54737;
})();
var state_54727__$1 = state_54727;
var ex54732 = (state_54727__$1[(2)]);
var statearr_54738_54754 = state_54727__$1;
(statearr_54738_54754[(5)] = ex54732);


if((ex54732 instanceof Error)){
var statearr_54739_54755 = state_54727__$1;
(statearr_54739_54755[(1)] = (4));

(statearr_54739_54755[(5)] = null);

} else {
throw ex54732;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54728 === (8))){
var inst_54711 = (state_54727[(2)]);
var inst_54712 = fluree.db.dbfunctions.internal.not.call(null,inst_54711);
var inst_54713 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54714 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54715 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54716 = [inst_54711];
var inst_54717 = (new cljs.core.PersistentVector(null,1,(5),inst_54715,inst_54716,null));
var inst_54718 = ["not?",inst_54717,inst_54712];
var inst_54719 = cljs.core.PersistentHashMap.fromArrays(inst_54714,inst_54718);
var inst_54720 = [inst_54719,(10)];
var inst_54721 = (new cljs.core.PersistentVector(null,2,(5),inst_54713,inst_54720,null));
var inst_54722 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54721);
var _ = (function (){var statearr_54740 = state_54727;
(statearr_54740[(4)] = cljs.core.rest.call(null,(state_54727[(4)])));

return statearr_54740;
})();
var state_54727__$1 = (function (){var statearr_54741 = state_54727;
(statearr_54741[(7)] = inst_54722);

return statearr_54741;
})();
var statearr_54742_54756 = state_54727__$1;
(statearr_54742_54756[(2)] = inst_54712);

(statearr_54742_54756[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto____0 = (function (){
var statearr_54743 = [null,null,null,null,null,null,null,null];
(statearr_54743[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto__);

(statearr_54743[(1)] = (1));

return statearr_54743;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto____1 = (function (state_54727){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_54727);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e54744){var ex__2882__auto__ = e54744;
var statearr_54745_54757 = state_54727;
(statearr_54745_54757[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_54727[(4)]))){
var statearr_54746_54758 = state_54727;
(statearr_54746_54758[(1)] = cljs.core.first.call(null,(state_54727[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54759 = state_54727;
state_54727 = G__54759;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto__ = function(state_54727){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto____1.call(this,state_54727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_54747 = f__2902__auto__.call(null);
(statearr_54747[(6)] = c__2901__auto__);

return statearr_54747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_54789){
var state_val_54790 = (state_54789[(1)]);
if((state_val_54790 === (7))){
var state_54789__$1 = state_54789;
var statearr_54791_54810 = state_54789__$1;
(statearr_54791_54810[(2)] = arg);

(statearr_54791_54810[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54790 === (1))){
var state_54789__$1 = state_54789;
var statearr_54792_54811 = state_54789__$1;
(statearr_54792_54811[(2)] = null);

(statearr_54792_54811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54790 === (4))){
var inst_54760 = (state_54789[(2)]);
var state_54789__$1 = state_54789;
var statearr_54793_54812 = state_54789__$1;
(statearr_54793_54812[(2)] = inst_54760);

(statearr_54793_54812[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54790 === (6))){
var state_54789__$1 = state_54789;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54789__$1,(9),arg);
} else {
if((state_val_54790 === (3))){
var inst_54787 = (state_54789[(2)]);
var state_54789__$1 = state_54789;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54789__$1,inst_54787);
} else {
if((state_val_54790 === (2))){
var _ = (function (){var statearr_54795 = state_54789;
(statearr_54795[(4)] = cljs.core.cons.call(null,(5),(state_54789[(4)])));

return statearr_54795;
})();
var inst_54766 = fluree.db.util.async.channel_QMARK_.call(null,arg);
var state_54789__$1 = state_54789;
if(inst_54766){
var statearr_54796_54813 = state_54789__$1;
(statearr_54796_54813[(1)] = (6));

} else {
var statearr_54797_54814 = state_54789__$1;
(statearr_54797_54814[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54790 === (9))){
var inst_54769 = (state_54789[(2)]);
var inst_54770 = fluree.db.util.async.throw_err.call(null,inst_54769);
var state_54789__$1 = state_54789;
var statearr_54798_54815 = state_54789__$1;
(statearr_54798_54815[(2)] = inst_54770);

(statearr_54798_54815[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54790 === (5))){
var _ = (function (){var statearr_54799 = state_54789;
(statearr_54799[(4)] = cljs.core.rest.call(null,(state_54789[(4)])));

return statearr_54799;
})();
var state_54789__$1 = state_54789;
var ex54794 = (state_54789__$1[(2)]);
var statearr_54800_54816 = state_54789__$1;
(statearr_54800_54816[(5)] = ex54794);


if((ex54794 instanceof Error)){
var statearr_54801_54817 = state_54789__$1;
(statearr_54801_54817[(1)] = (4));

(statearr_54801_54817[(5)] = null);

} else {
throw ex54794;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54790 === (8))){
var inst_54773 = (state_54789[(2)]);
var inst_54774 = fluree.db.dbfunctions.internal.empty_QMARK_.call(null,inst_54773);
var inst_54775 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54776 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54778 = [inst_54773];
var inst_54779 = (new cljs.core.PersistentVector(null,1,(5),inst_54777,inst_54778,null));
var inst_54780 = ["empty?",inst_54779,inst_54774];
var inst_54781 = cljs.core.PersistentHashMap.fromArrays(inst_54776,inst_54780);
var inst_54782 = [inst_54781,(10)];
var inst_54783 = (new cljs.core.PersistentVector(null,2,(5),inst_54775,inst_54782,null));
var inst_54784 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54783);
var _ = (function (){var statearr_54802 = state_54789;
(statearr_54802[(4)] = cljs.core.rest.call(null,(state_54789[(4)])));

return statearr_54802;
})();
var state_54789__$1 = (function (){var statearr_54803 = state_54789;
(statearr_54803[(7)] = inst_54784);

return statearr_54803;
})();
var statearr_54804_54818 = state_54789__$1;
(statearr_54804_54818[(2)] = inst_54774);

(statearr_54804_54818[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto____0 = (function (){
var statearr_54805 = [null,null,null,null,null,null,null,null];
(statearr_54805[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto__);

(statearr_54805[(1)] = (1));

return statearr_54805;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto____1 = (function (state_54789){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_54789);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e54806){var ex__2882__auto__ = e54806;
var statearr_54807_54819 = state_54789;
(statearr_54807_54819[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_54789[(4)]))){
var statearr_54808_54820 = state_54789;
(statearr_54808_54820[(1)] = cljs.core.first.call(null,(state_54789[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54821 = state_54789;
state_54789 = G__54821;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto__ = function(state_54789){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto____1.call(this,state_54789);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_54809 = f__2902__auto__.call(null);
(statearr_54809[(6)] = c__2901__auto__);

return statearr_54809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___54866 = arguments.length;
var i__4737__auto___54867 = (0);
while(true){
if((i__4737__auto___54867 < len__4736__auto___54866)){
args__4742__auto__.push((arguments[i__4737__auto___54867]));

var G__54868 = (i__4737__auto___54867 + (1));
i__4737__auto___54867 = G__54868;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_54849){
var state_val_54850 = (state_54849[(1)]);
if((state_val_54850 === (1))){
var state_54849__$1 = state_54849;
var statearr_54851_54869 = state_54849__$1;
(statearr_54851_54869[(2)] = null);

(statearr_54851_54869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54850 === (2))){
var _ = (function (){var statearr_54852 = state_54849;
(statearr_54852[(4)] = cljs.core.cons.call(null,(5),(state_54849[(4)])));

return statearr_54852;
})();
var inst_54830 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54849__$1 = state_54849;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54849__$1,(6),inst_54830);
} else {
if((state_val_54850 === (3))){
var inst_54847 = (state_54849[(2)]);
var state_54849__$1 = state_54849;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54849__$1,inst_54847);
} else {
if((state_val_54850 === (4))){
var inst_54824 = (state_54849[(2)]);
var state_54849__$1 = state_54849;
var statearr_54854_54870 = state_54849__$1;
(statearr_54854_54870[(2)] = inst_54824);

(statearr_54854_54870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54850 === (5))){
var _ = (function (){var statearr_54855 = state_54849;
(statearr_54855[(4)] = cljs.core.rest.call(null,(state_54849[(4)])));

return statearr_54855;
})();
var state_54849__$1 = state_54849;
var ex54853 = (state_54849__$1[(2)]);
var statearr_54856_54871 = state_54849__$1;
(statearr_54856_54871[(5)] = ex54853);


if((ex54853 instanceof Error)){
var statearr_54857_54872 = state_54849__$1;
(statearr_54857_54872[(1)] = (4));

(statearr_54857_54872[(5)] = null);

} else {
throw ex54853;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54850 === (6))){
var inst_54832 = (state_54849[(2)]);
var inst_54833 = fluree.db.util.async.throw_err.call(null,inst_54832);
var inst_54834 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.str,inst_54833);
var inst_54835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54836 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54838 = [inst_54833];
var inst_54839 = (new cljs.core.PersistentVector(null,1,(5),inst_54837,inst_54838,null));
var inst_54840 = ["str",inst_54839,inst_54834];
var inst_54841 = cljs.core.PersistentHashMap.fromArrays(inst_54836,inst_54840);
var inst_54842 = [inst_54841,(10)];
var inst_54843 = (new cljs.core.PersistentVector(null,2,(5),inst_54835,inst_54842,null));
var inst_54844 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54843);
var _ = (function (){var statearr_54858 = state_54849;
(statearr_54858[(4)] = cljs.core.rest.call(null,(state_54849[(4)])));

return statearr_54858;
})();
var state_54849__$1 = (function (){var statearr_54859 = state_54849;
(statearr_54859[(7)] = inst_54844);

return statearr_54859;
})();
var statearr_54860_54873 = state_54849__$1;
(statearr_54860_54873[(2)] = inst_54834);

(statearr_54860_54873[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_54861 = [null,null,null,null,null,null,null,null];
(statearr_54861[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_54861[(1)] = (1));

return statearr_54861;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_54849){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_54849);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e54862){var ex__2882__auto__ = e54862;
var statearr_54863_54874 = state_54849;
(statearr_54863_54874[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_54849[(4)]))){
var statearr_54864_54875 = state_54849;
(statearr_54864_54875[(1)] = cljs.core.first.call(null,(state_54849[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54876 = state_54849;
state_54849 = G__54876;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_54849){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_54849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_54865 = f__2902__auto__.call(null);
(statearr_54865[(6)] = c__2901__auto__);

return statearr_54865;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq54822){
var G__54823 = cljs.core.first.call(null,seq54822);
var seq54822__$1 = cljs.core.next.call(null,seq54822);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__54823,seq54822__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_54902){
var state_val_54903 = (state_54902[(1)]);
if((state_val_54903 === (1))){
var state_54902__$1 = state_54902;
var statearr_54904_54919 = state_54902__$1;
(statearr_54904_54919[(2)] = null);

(statearr_54904_54919[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54903 === (2))){
var _ = (function (){var statearr_54905 = state_54902;
(statearr_54905[(4)] = cljs.core.cons.call(null,(5),(state_54902[(4)])));

return statearr_54905;
})();
var inst_54883 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_54902__$1 = state_54902;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54902__$1,(6),inst_54883);
} else {
if((state_val_54903 === (3))){
var inst_54900 = (state_54902[(2)]);
var state_54902__$1 = state_54902;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54902__$1,inst_54900);
} else {
if((state_val_54903 === (4))){
var inst_54877 = (state_54902[(2)]);
var state_54902__$1 = state_54902;
var statearr_54907_54920 = state_54902__$1;
(statearr_54907_54920[(2)] = inst_54877);

(statearr_54907_54920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54903 === (5))){
var _ = (function (){var statearr_54908 = state_54902;
(statearr_54908[(4)] = cljs.core.rest.call(null,(state_54902[(4)])));

return statearr_54908;
})();
var state_54902__$1 = state_54902;
var ex54906 = (state_54902__$1[(2)]);
var statearr_54909_54921 = state_54902__$1;
(statearr_54909_54921[(5)] = ex54906);


if((ex54906 instanceof Error)){
var statearr_54910_54922 = state_54902__$1;
(statearr_54910_54922[(1)] = (4));

(statearr_54910_54922[(5)] = null);

} else {
throw ex54906;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54903 === (6))){
var inst_54885 = (state_54902[(2)]);
var inst_54886 = fluree.db.util.async.throw_err.call(null,inst_54885);
var inst_54887 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.subs,inst_54886);
var inst_54888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54889 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54890 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54891 = [inst_54886];
var inst_54892 = (new cljs.core.PersistentVector(null,1,(5),inst_54890,inst_54891,null));
var inst_54893 = ["subs",inst_54892,inst_54887];
var inst_54894 = cljs.core.PersistentHashMap.fromArrays(inst_54889,inst_54893);
var inst_54895 = [inst_54894,(30)];
var inst_54896 = (new cljs.core.PersistentVector(null,2,(5),inst_54888,inst_54895,null));
var inst_54897 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54896);
var _ = (function (){var statearr_54911 = state_54902;
(statearr_54911[(4)] = cljs.core.rest.call(null,(state_54902[(4)])));

return statearr_54911;
})();
var state_54902__$1 = (function (){var statearr_54912 = state_54902;
(statearr_54912[(7)] = inst_54897);

return statearr_54912;
})();
var statearr_54913_54923 = state_54902__$1;
(statearr_54913_54923[(2)] = inst_54887);

(statearr_54913_54923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto____0 = (function (){
var statearr_54914 = [null,null,null,null,null,null,null,null];
(statearr_54914[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto__);

(statearr_54914[(1)] = (1));

return statearr_54914;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto____1 = (function (state_54902){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_54902);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e54915){var ex__2882__auto__ = e54915;
var statearr_54916_54924 = state_54902;
(statearr_54916_54924[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_54902[(4)]))){
var statearr_54917_54925 = state_54902;
(statearr_54917_54925[(1)] = cljs.core.first.call(null,(state_54902[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54926 = state_54902;
state_54902 = G__54926;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto__ = function(state_54902){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto____1.call(this,state_54902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_54918 = f__2902__auto__.call(null);
(statearr_54918[(6)] = c__2901__auto__);

return statearr_54918;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_54956){
var state_val_54957 = (state_54956[(1)]);
if((state_val_54957 === (7))){
var state_54956__$1 = state_54956;
var statearr_54958_54977 = state_54956__$1;
(statearr_54958_54977[(2)] = str);

(statearr_54958_54977[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54957 === (1))){
var state_54956__$1 = state_54956;
var statearr_54959_54978 = state_54956__$1;
(statearr_54959_54978[(2)] = null);

(statearr_54959_54978[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54957 === (4))){
var inst_54927 = (state_54956[(2)]);
var state_54956__$1 = state_54956;
var statearr_54960_54979 = state_54956__$1;
(statearr_54960_54979[(2)] = inst_54927);

(statearr_54960_54979[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54957 === (6))){
var state_54956__$1 = state_54956;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_54956__$1,(9),str);
} else {
if((state_val_54957 === (3))){
var inst_54954 = (state_54956[(2)]);
var state_54956__$1 = state_54956;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_54956__$1,inst_54954);
} else {
if((state_val_54957 === (2))){
var _ = (function (){var statearr_54962 = state_54956;
(statearr_54962[(4)] = cljs.core.cons.call(null,(5),(state_54956[(4)])));

return statearr_54962;
})();
var inst_54933 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_54956__$1 = state_54956;
if(inst_54933){
var statearr_54963_54980 = state_54956__$1;
(statearr_54963_54980[(1)] = (6));

} else {
var statearr_54964_54981 = state_54956__$1;
(statearr_54964_54981[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54957 === (9))){
var inst_54936 = (state_54956[(2)]);
var inst_54937 = fluree.db.util.async.throw_err.call(null,inst_54936);
var state_54956__$1 = state_54956;
var statearr_54965_54982 = state_54956__$1;
(statearr_54965_54982[(2)] = inst_54937);

(statearr_54965_54982[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54957 === (5))){
var _ = (function (){var statearr_54966 = state_54956;
(statearr_54966[(4)] = cljs.core.rest.call(null,(state_54956[(4)])));

return statearr_54966;
})();
var state_54956__$1 = state_54956;
var ex54961 = (state_54956__$1[(2)]);
var statearr_54967_54983 = state_54956__$1;
(statearr_54967_54983[(5)] = ex54961);


if((ex54961 instanceof Error)){
var statearr_54968_54984 = state_54956__$1;
(statearr_54968_54984[(1)] = (4));

(statearr_54968_54984[(5)] = null);

} else {
throw ex54961;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54957 === (8))){
var inst_54940 = (state_54956[(2)]);
var inst_54941 = fluree.db.dbfunctions.internal.lower_case.call(null,inst_54940);
var inst_54942 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54943 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_54944 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54945 = [inst_54940];
var inst_54946 = (new cljs.core.PersistentVector(null,1,(5),inst_54944,inst_54945,null));
var inst_54947 = ["lower-case",inst_54946,inst_54941];
var inst_54948 = cljs.core.PersistentHashMap.fromArrays(inst_54943,inst_54947);
var inst_54949 = [inst_54948,(10)];
var inst_54950 = (new cljs.core.PersistentVector(null,2,(5),inst_54942,inst_54949,null));
var inst_54951 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_54950);
var _ = (function (){var statearr_54969 = state_54956;
(statearr_54969[(4)] = cljs.core.rest.call(null,(state_54956[(4)])));

return statearr_54969;
})();
var state_54956__$1 = (function (){var statearr_54970 = state_54956;
(statearr_54970[(7)] = inst_54951);

return statearr_54970;
})();
var statearr_54971_54985 = state_54956__$1;
(statearr_54971_54985[(2)] = inst_54941);

(statearr_54971_54985[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto____0 = (function (){
var statearr_54972 = [null,null,null,null,null,null,null,null];
(statearr_54972[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto__);

(statearr_54972[(1)] = (1));

return statearr_54972;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto____1 = (function (state_54956){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_54956);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e54973){var ex__2882__auto__ = e54973;
var statearr_54974_54986 = state_54956;
(statearr_54974_54986[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_54956[(4)]))){
var statearr_54975_54987 = state_54956;
(statearr_54975_54987[(1)] = cljs.core.first.call(null,(state_54956[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54988 = state_54956;
state_54956 = G__54988;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto__ = function(state_54956){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto____1.call(this,state_54956);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_54976 = f__2902__auto__.call(null);
(statearr_54976[(6)] = c__2901__auto__);

return statearr_54976;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55018){
var state_val_55019 = (state_55018[(1)]);
if((state_val_55019 === (7))){
var state_55018__$1 = state_55018;
var statearr_55020_55039 = state_55018__$1;
(statearr_55020_55039[(2)] = str);

(statearr_55020_55039[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55019 === (1))){
var state_55018__$1 = state_55018;
var statearr_55021_55040 = state_55018__$1;
(statearr_55021_55040[(2)] = null);

(statearr_55021_55040[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55019 === (4))){
var inst_54989 = (state_55018[(2)]);
var state_55018__$1 = state_55018;
var statearr_55022_55041 = state_55018__$1;
(statearr_55022_55041[(2)] = inst_54989);

(statearr_55022_55041[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55019 === (6))){
var state_55018__$1 = state_55018;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55018__$1,(9),str);
} else {
if((state_val_55019 === (3))){
var inst_55016 = (state_55018[(2)]);
var state_55018__$1 = state_55018;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55018__$1,inst_55016);
} else {
if((state_val_55019 === (2))){
var _ = (function (){var statearr_55024 = state_55018;
(statearr_55024[(4)] = cljs.core.cons.call(null,(5),(state_55018[(4)])));

return statearr_55024;
})();
var inst_54995 = fluree.db.util.async.channel_QMARK_.call(null,str);
var state_55018__$1 = state_55018;
if(inst_54995){
var statearr_55025_55042 = state_55018__$1;
(statearr_55025_55042[(1)] = (6));

} else {
var statearr_55026_55043 = state_55018__$1;
(statearr_55026_55043[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55019 === (9))){
var inst_54998 = (state_55018[(2)]);
var inst_54999 = fluree.db.util.async.throw_err.call(null,inst_54998);
var state_55018__$1 = state_55018;
var statearr_55027_55044 = state_55018__$1;
(statearr_55027_55044[(2)] = inst_54999);

(statearr_55027_55044[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55019 === (5))){
var _ = (function (){var statearr_55028 = state_55018;
(statearr_55028[(4)] = cljs.core.rest.call(null,(state_55018[(4)])));

return statearr_55028;
})();
var state_55018__$1 = state_55018;
var ex55023 = (state_55018__$1[(2)]);
var statearr_55029_55045 = state_55018__$1;
(statearr_55029_55045[(5)] = ex55023);


if((ex55023 instanceof Error)){
var statearr_55030_55046 = state_55018__$1;
(statearr_55030_55046[(1)] = (4));

(statearr_55030_55046[(5)] = null);

} else {
throw ex55023;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55019 === (8))){
var inst_55002 = (state_55018[(2)]);
var inst_55003 = fluree.db.dbfunctions.internal.upper_case.call(null,inst_55002);
var inst_55004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55005 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55006 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55007 = [inst_55002];
var inst_55008 = (new cljs.core.PersistentVector(null,1,(5),inst_55006,inst_55007,null));
var inst_55009 = ["upper-case",inst_55008,inst_55003];
var inst_55010 = cljs.core.PersistentHashMap.fromArrays(inst_55005,inst_55009);
var inst_55011 = [inst_55010,(10)];
var inst_55012 = (new cljs.core.PersistentVector(null,2,(5),inst_55004,inst_55011,null));
var inst_55013 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55012);
var _ = (function (){var statearr_55031 = state_55018;
(statearr_55031[(4)] = cljs.core.rest.call(null,(state_55018[(4)])));

return statearr_55031;
})();
var state_55018__$1 = (function (){var statearr_55032 = state_55018;
(statearr_55032[(7)] = inst_55013);

return statearr_55032;
})();
var statearr_55033_55047 = state_55018__$1;
(statearr_55033_55047[(2)] = inst_55003);

(statearr_55033_55047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto____0 = (function (){
var statearr_55034 = [null,null,null,null,null,null,null,null];
(statearr_55034[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto__);

(statearr_55034[(1)] = (1));

return statearr_55034;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto____1 = (function (state_55018){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_55018);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55035){var ex__2882__auto__ = e55035;
var statearr_55036_55048 = state_55018;
(statearr_55036_55048[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_55018[(4)]))){
var statearr_55037_55049 = state_55018;
(statearr_55037_55049[(1)] = cljs.core.first.call(null,(state_55018[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55050 = state_55018;
state_55018 = G__55050;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto__ = function(state_55018){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto____1.call(this,state_55018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55038 = f__2902__auto__.call(null);
(statearr_55038[(6)] = c__2901__auto__);

return statearr_55038;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4115__auto__)){
return (!(typeof cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null)) === 'string'));
} else {
return and__4115__auto__;
}
})())){
var res = cljs.core.get_in.call(null,_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287)], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?sid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?pid",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__55052 = arguments.length;
switch (G__55052) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55080){
var state_val_55081 = (state_55080[(1)]);
if((state_val_55081 === (1))){
var state_55080__$1 = state_55080;
var statearr_55082_55098 = state_55080__$1;
(statearr_55082_55098[(2)] = null);

(statearr_55082_55098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55081 === (2))){
var _ = (function (){var statearr_55083 = state_55080;
(statearr_55083[(4)] = cljs.core.cons.call(null,(5),(state_55080[(4)])));

return statearr_55083;
})();
var inst_55062 = fluree.db.dbfunctions.internal._QMARK_s.call(null,_QMARK_ctx,additional_select);
var state_55080__$1 = state_55080;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55080__$1,(6),inst_55062);
} else {
if((state_val_55081 === (3))){
var inst_55078 = (state_55080[(2)]);
var state_55080__$1 = state_55080;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55080__$1,inst_55078);
} else {
if((state_val_55081 === (4))){
var inst_55053 = (state_55080[(2)]);
var state_55080__$1 = state_55080;
var statearr_55085_55099 = state_55080__$1;
(statearr_55085_55099[(2)] = inst_55053);

(statearr_55085_55099[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55081 === (5))){
var _ = (function (){var statearr_55086 = state_55080;
(statearr_55086[(4)] = cljs.core.rest.call(null,(state_55080[(4)])));

return statearr_55086;
})();
var state_55080__$1 = state_55080;
var ex55084 = (state_55080__$1[(2)]);
var statearr_55087_55100 = state_55080__$1;
(statearr_55087_55100[(5)] = ex55084);


if((ex55084 instanceof Error)){
var statearr_55088_55101 = state_55080__$1;
(statearr_55088_55101[(1)] = (4));

(statearr_55088_55101[(5)] = null);

} else {
throw ex55084;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55081 === (6))){
var inst_55064 = (state_55080[(2)]);
var inst_55065 = fluree.db.util.async.throw_err.call(null,inst_55064);
var inst_55066 = cljs.core.nth.call(null,inst_55065,(0),null);
var inst_55067 = cljs.core.nth.call(null,inst_55065,(1),null);
var inst_55068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55069 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55070 = ["?s","?ctx",inst_55066];
var inst_55071 = cljs.core.PersistentHashMap.fromArrays(inst_55069,inst_55070);
var inst_55072 = ((10) + inst_55067);
var inst_55073 = [inst_55071,inst_55072];
var inst_55074 = (new cljs.core.PersistentVector(null,2,(5),inst_55068,inst_55073,null));
var inst_55075 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55074);
var _ = (function (){var statearr_55089 = state_55080;
(statearr_55089[(4)] = cljs.core.rest.call(null,(state_55080[(4)])));

return statearr_55089;
})();
var state_55080__$1 = (function (){var statearr_55090 = state_55080;
(statearr_55090[(7)] = inst_55075);

return statearr_55090;
})();
var statearr_55091_55102 = state_55080__$1;
(statearr_55091_55102[(2)] = inst_55066);

(statearr_55091_55102[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_55092 = [null,null,null,null,null,null,null,null];
(statearr_55092[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_55092[(1)] = (1));

return statearr_55092;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_55080){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_55080);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55093){var ex__2882__auto__ = e55093;
var statearr_55094_55103 = state_55080;
(statearr_55094_55103[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_55080[(4)]))){
var statearr_55095_55104 = state_55080;
(statearr_55095_55104[(1)] = cljs.core.first.call(null,(state_55080[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55105 = state_55080;
state_55080 = G__55105;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_55080){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_55080);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55096 = f__2902__auto__.call(null);
(statearr_55096[(6)] = c__2901__auto__);

return statearr_55096;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__55107 = arguments.length;
switch (G__55107) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.call(null,_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55145){
var state_val_55146 = (state_55145[(1)]);
if((state_val_55146 === (7))){
var inst_55138 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?p from this function interface");
var state_55145__$1 = state_55145;
var statearr_55147_55167 = state_55145__$1;
(statearr_55147_55167[(2)] = inst_55138);

(statearr_55147_55167[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55146 === (1))){
var state_55145__$1 = state_55145;
var statearr_55148_55168 = state_55145__$1;
(statearr_55148_55168[(2)] = null);

(statearr_55148_55168[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55146 === (4))){
var inst_55108 = (state_55145[(2)]);
var state_55145__$1 = state_55145;
var statearr_55149_55169 = state_55145__$1;
(statearr_55149_55169[(2)] = inst_55108);

(statearr_55149_55169[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55146 === (6))){
var inst_55119 = fluree.db.dbfunctions.fns.coerce_args.call(null,additional_select);
var state_55145__$1 = state_55145;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55145__$1,(10),inst_55119);
} else {
if((state_val_55146 === (3))){
var inst_55143 = (state_55145[(2)]);
var state_55145__$1 = state_55145;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55145__$1,inst_55143);
} else {
if((state_val_55146 === (2))){
var _ = (function (){var statearr_55151 = state_55145;
(statearr_55151[(4)] = cljs.core.cons.call(null,(5),(state_55145[(4)])));

return statearr_55151;
})();
var inst_55114 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55145__$1 = state_55145;
if(cljs.core.truth_(inst_55114)){
var statearr_55152_55170 = state_55145__$1;
(statearr_55152_55170[(1)] = (6));

} else {
var statearr_55153_55171 = state_55145__$1;
(statearr_55153_55171[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55146 === (9))){
var inst_55125 = (state_55145[(2)]);
var inst_55126 = fluree.db.util.async.throw_err.call(null,inst_55125);
var inst_55127 = cljs.core.nth.call(null,inst_55126,(0),null);
var inst_55128 = cljs.core.nth.call(null,inst_55126,(1),null);
var inst_55129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55130 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55131 = ["?p","?ctx",inst_55127];
var inst_55132 = cljs.core.PersistentHashMap.fromArrays(inst_55130,inst_55131);
var inst_55133 = ((10) + inst_55128);
var inst_55134 = [inst_55132,inst_55133];
var inst_55135 = (new cljs.core.PersistentVector(null,2,(5),inst_55129,inst_55134,null));
var inst_55136 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55135);
var state_55145__$1 = (function (){var statearr_55154 = state_55145;
(statearr_55154[(7)] = inst_55136);

return statearr_55154;
})();
var statearr_55155_55172 = state_55145__$1;
(statearr_55155_55172[(2)] = inst_55127);

(statearr_55155_55172[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55146 === (5))){
var _ = (function (){var statearr_55156 = state_55145;
(statearr_55156[(4)] = cljs.core.rest.call(null,(state_55145[(4)])));

return statearr_55156;
})();
var state_55145__$1 = state_55145;
var ex55150 = (state_55145__$1[(2)]);
var statearr_55157_55173 = state_55145__$1;
(statearr_55157_55173[(5)] = ex55150);


if((ex55150 instanceof Error)){
var statearr_55158_55174 = state_55145__$1;
(statearr_55158_55174[(1)] = (4));

(statearr_55158_55174[(5)] = null);

} else {
throw ex55150;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55146 === (10))){
var inst_55121 = (state_55145[(2)]);
var inst_55122 = fluree.db.util.async.throw_err.call(null,inst_55121);
var inst_55123 = fluree.db.dbfunctions.internal._QMARK_p.call(null,_QMARK_ctx,inst_55122);
var state_55145__$1 = state_55145;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55145__$1,(9),inst_55123);
} else {
if((state_val_55146 === (8))){
var inst_55140 = (state_55145[(2)]);
var _ = (function (){var statearr_55159 = state_55145;
(statearr_55159[(4)] = cljs.core.rest.call(null,(state_55145[(4)])));

return statearr_55159;
})();
var state_55145__$1 = state_55145;
var statearr_55160_55175 = state_55145__$1;
(statearr_55160_55175[(2)] = inst_55140);

(statearr_55160_55175[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_55161 = [null,null,null,null,null,null,null,null];
(statearr_55161[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_55161[(1)] = (1));

return statearr_55161;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_55145){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_55145);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55162){var ex__2882__auto__ = e55162;
var statearr_55163_55176 = state_55145;
(statearr_55163_55176[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_55145[(4)]))){
var statearr_55164_55177 = state_55145;
(statearr_55164_55177[(1)] = cljs.core.first.call(null,(state_55145[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55178 = state_55145;
state_55145 = G__55178;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_55145){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_55145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55165 = f__2902__auto__.call(null);
(statearr_55165[(6)] = c__2901__auto__);

return statearr_55165;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55227 = arguments.length;
var i__4737__auto___55228 = (0);
while(true){
if((i__4737__auto___55228 < len__4736__auto___55227)){
args__4742__auto__.push((arguments[i__4737__auto___55228]));

var G__55229 = (i__4737__auto___55228 + (1));
i__4737__auto___55228 = G__55229;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55210){
var state_val_55211 = (state_55210[(1)]);
if((state_val_55211 === (1))){
var state_55210__$1 = state_55210;
var statearr_55212_55230 = state_55210__$1;
(statearr_55212_55230[(2)] = null);

(statearr_55212_55230[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55211 === (2))){
var _ = (function (){var statearr_55213 = state_55210;
(statearr_55213[(4)] = cljs.core.cons.call(null,(5),(state_55210[(4)])));

return statearr_55213;
})();
var inst_55187 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55210__$1 = state_55210;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55210__$1,(6),inst_55187);
} else {
if((state_val_55211 === (3))){
var inst_55208 = (state_55210[(2)]);
var state_55210__$1 = state_55210;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55210__$1,inst_55208);
} else {
if((state_val_55211 === (4))){
var inst_55181 = (state_55210[(2)]);
var state_55210__$1 = state_55210;
var statearr_55215_55231 = state_55210__$1;
(statearr_55215_55231[(2)] = inst_55181);

(statearr_55215_55231[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55211 === (5))){
var _ = (function (){var statearr_55216 = state_55210;
(statearr_55216[(4)] = cljs.core.rest.call(null,(state_55210[(4)])));

return statearr_55216;
})();
var state_55210__$1 = state_55210;
var ex55214 = (state_55210__$1[(2)]);
var statearr_55217_55232 = state_55210__$1;
(statearr_55217_55232[(5)] = ex55214);


if((ex55214 instanceof Error)){
var statearr_55218_55233 = state_55210__$1;
(statearr_55218_55233[(1)] = (4));

(statearr_55218_55233[(5)] = null);

} else {
throw ex55214;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55211 === (6))){
var inst_55189 = (state_55210[(2)]);
var inst_55190 = fluree.db.util.async.throw_err.call(null,inst_55189);
var inst_55191 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.and,inst_55190);
var inst_55192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55193 = [inst_55190];
var inst_55194 = (new cljs.core.PersistentVector(null,1,(5),inst_55192,inst_55193,null));
var inst_55195 = cljs.core.count.call(null,inst_55194);
var inst_55196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55197 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55199 = [inst_55190];
var inst_55200 = (new cljs.core.PersistentVector(null,1,(5),inst_55198,inst_55199,null));
var inst_55201 = ["and",inst_55200,inst_55191];
var inst_55202 = cljs.core.PersistentHashMap.fromArrays(inst_55197,inst_55201);
var inst_55203 = [inst_55202,inst_55195];
var inst_55204 = (new cljs.core.PersistentVector(null,2,(5),inst_55196,inst_55203,null));
var inst_55205 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55204);
var _ = (function (){var statearr_55219 = state_55210;
(statearr_55219[(4)] = cljs.core.rest.call(null,(state_55210[(4)])));

return statearr_55219;
})();
var state_55210__$1 = (function (){var statearr_55220 = state_55210;
(statearr_55220[(7)] = inst_55205);

return statearr_55220;
})();
var statearr_55221_55234 = state_55210__$1;
(statearr_55221_55234[(2)] = inst_55191);

(statearr_55221_55234[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_55222 = [null,null,null,null,null,null,null,null];
(statearr_55222[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_55222[(1)] = (1));

return statearr_55222;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_55210){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_55210);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55223){var ex__2882__auto__ = e55223;
var statearr_55224_55235 = state_55210;
(statearr_55224_55235[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_55210[(4)]))){
var statearr_55225_55236 = state_55210;
(statearr_55225_55236[(1)] = cljs.core.first.call(null,(state_55210[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55237 = state_55210;
state_55210 = G__55237;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_55210){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_55210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55226 = f__2902__auto__.call(null);
(statearr_55226[(6)] = c__2901__auto__);

return statearr_55226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq55179){
var G__55180 = cljs.core.first.call(null,seq55179);
var seq55179__$1 = cljs.core.next.call(null,seq55179);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55180,seq55179__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55286 = arguments.length;
var i__4737__auto___55287 = (0);
while(true){
if((i__4737__auto___55287 < len__4736__auto___55286)){
args__4742__auto__.push((arguments[i__4737__auto___55287]));

var G__55288 = (i__4737__auto___55287 + (1));
i__4737__auto___55287 = G__55288;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55269){
var state_val_55270 = (state_55269[(1)]);
if((state_val_55270 === (1))){
var state_55269__$1 = state_55269;
var statearr_55271_55289 = state_55269__$1;
(statearr_55271_55289[(2)] = null);

(statearr_55271_55289[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55270 === (2))){
var _ = (function (){var statearr_55272 = state_55269;
(statearr_55272[(4)] = cljs.core.cons.call(null,(5),(state_55269[(4)])));

return statearr_55272;
})();
var inst_55246 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55269__$1 = state_55269;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55269__$1,(6),inst_55246);
} else {
if((state_val_55270 === (3))){
var inst_55267 = (state_55269[(2)]);
var state_55269__$1 = state_55269;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55269__$1,inst_55267);
} else {
if((state_val_55270 === (4))){
var inst_55240 = (state_55269[(2)]);
var state_55269__$1 = state_55269;
var statearr_55274_55290 = state_55269__$1;
(statearr_55274_55290[(2)] = inst_55240);

(statearr_55274_55290[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55270 === (5))){
var _ = (function (){var statearr_55275 = state_55269;
(statearr_55275[(4)] = cljs.core.rest.call(null,(state_55269[(4)])));

return statearr_55275;
})();
var state_55269__$1 = state_55269;
var ex55273 = (state_55269__$1[(2)]);
var statearr_55276_55291 = state_55269__$1;
(statearr_55276_55291[(5)] = ex55273);


if((ex55273 instanceof Error)){
var statearr_55277_55292 = state_55269__$1;
(statearr_55277_55292[(1)] = (4));

(statearr_55277_55292[(5)] = null);

} else {
throw ex55273;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55270 === (6))){
var inst_55248 = (state_55269[(2)]);
var inst_55249 = fluree.db.util.async.throw_err.call(null,inst_55248);
var inst_55250 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.or,inst_55249);
var inst_55251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55252 = [inst_55249];
var inst_55253 = (new cljs.core.PersistentVector(null,1,(5),inst_55251,inst_55252,null));
var inst_55254 = cljs.core.count.call(null,inst_55253);
var inst_55255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55256 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55258 = [inst_55249];
var inst_55259 = (new cljs.core.PersistentVector(null,1,(5),inst_55257,inst_55258,null));
var inst_55260 = ["or",inst_55259,inst_55250];
var inst_55261 = cljs.core.PersistentHashMap.fromArrays(inst_55256,inst_55260);
var inst_55262 = [inst_55261,inst_55254];
var inst_55263 = (new cljs.core.PersistentVector(null,2,(5),inst_55255,inst_55262,null));
var inst_55264 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55263);
var _ = (function (){var statearr_55278 = state_55269;
(statearr_55278[(4)] = cljs.core.rest.call(null,(state_55269[(4)])));

return statearr_55278;
})();
var state_55269__$1 = (function (){var statearr_55279 = state_55269;
(statearr_55279[(7)] = inst_55264);

return statearr_55279;
})();
var statearr_55280_55293 = state_55269__$1;
(statearr_55280_55293[(2)] = inst_55250);

(statearr_55280_55293[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_55281 = [null,null,null,null,null,null,null,null];
(statearr_55281[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_55281[(1)] = (1));

return statearr_55281;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_55269){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_55269);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55282){var ex__2882__auto__ = e55282;
var statearr_55283_55294 = state_55269;
(statearr_55283_55294[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_55269[(4)]))){
var statearr_55284_55295 = state_55269;
(statearr_55284_55295[(1)] = cljs.core.first.call(null,(state_55269[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55296 = state_55269;
state_55269 = G__55296;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_55269){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_55269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55285 = f__2902__auto__.call(null);
(statearr_55285[(6)] = c__2901__auto__);

return statearr_55285;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq55238){
var G__55239 = cljs.core.first.call(null,seq55238);
var seq55238__$1 = cljs.core.next.call(null,seq55238);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55239,seq55238__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55334){
var state_val_55335 = (state_55334[(1)]);
if((state_val_55335 === (7))){
var inst_55310 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_55334__$1 = state_55334;
if(inst_55310){
var statearr_55336_55359 = state_55334__$1;
(statearr_55336_55359[(1)] = (10));

} else {
var statearr_55337_55360 = state_55334__$1;
(statearr_55337_55360[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55335 === (1))){
var state_55334__$1 = state_55334;
var statearr_55338_55361 = state_55334__$1;
(statearr_55338_55361[(2)] = null);

(statearr_55338_55361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55335 === (4))){
var inst_55297 = (state_55334[(2)]);
var state_55334__$1 = state_55334;
var statearr_55339_55362 = state_55334__$1;
(statearr_55339_55362[(2)] = inst_55297);

(statearr_55339_55362[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55335 === (13))){
var inst_55313 = (state_55334[(2)]);
var inst_55314 = fluree.db.util.async.throw_err.call(null,inst_55313);
var state_55334__$1 = state_55334;
var statearr_55340_55363 = state_55334__$1;
(statearr_55340_55363[(2)] = inst_55314);

(statearr_55340_55363[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55335 === (6))){
var inst_55305 = fluree.db.dbfunctions.fns.coerce_args.call(null,coll);
var state_55334__$1 = state_55334;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55334__$1,(9),inst_55305);
} else {
if((state_val_55335 === (3))){
var inst_55332 = (state_55334[(2)]);
var state_55334__$1 = state_55334;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55334__$1,inst_55332);
} else {
if((state_val_55335 === (12))){
var inst_55317 = (state_55334[(2)]);
var state_55334__$1 = state_55334;
var statearr_55341_55364 = state_55334__$1;
(statearr_55341_55364[(2)] = inst_55317);

(statearr_55341_55364[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55335 === (2))){
var _ = (function (){var statearr_55342 = state_55334;
(statearr_55342[(4)] = cljs.core.cons.call(null,(5),(state_55334[(4)])));

return statearr_55342;
})();
var inst_55303 = cljs.core.vector_QMARK_.call(null,coll);
var state_55334__$1 = state_55334;
if(inst_55303){
var statearr_55343_55365 = state_55334__$1;
(statearr_55343_55365[(1)] = (6));

} else {
var statearr_55344_55366 = state_55334__$1;
(statearr_55344_55366[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55335 === (11))){
var state_55334__$1 = state_55334;
var statearr_55346_55367 = state_55334__$1;
(statearr_55346_55367[(2)] = coll);

(statearr_55346_55367[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55335 === (9))){
var inst_55307 = (state_55334[(2)]);
var inst_55308 = fluree.db.util.async.throw_err.call(null,inst_55307);
var state_55334__$1 = state_55334;
var statearr_55347_55368 = state_55334__$1;
(statearr_55347_55368[(2)] = inst_55308);

(statearr_55347_55368[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55335 === (5))){
var _ = (function (){var statearr_55348 = state_55334;
(statearr_55348[(4)] = cljs.core.rest.call(null,(state_55334[(4)])));

return statearr_55348;
})();
var state_55334__$1 = state_55334;
var ex55345 = (state_55334__$1[(2)]);
var statearr_55349_55369 = state_55334__$1;
(statearr_55349_55369[(5)] = ex55345);


if((ex55345 instanceof Error)){
var statearr_55350_55370 = state_55334__$1;
(statearr_55350_55370[(1)] = (4));

(statearr_55350_55370[(5)] = null);

} else {
throw ex55345;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55335 === (10))){
var state_55334__$1 = state_55334;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55334__$1,(13),coll);
} else {
if((state_val_55335 === (8))){
var inst_55319 = (state_55334[(2)]);
var inst_55320 = cljs.core.remove.call(null,cljs.core.nil_QMARK_,inst_55319);
var inst_55321 = cljs.core.count.call(null,inst_55320);
var inst_55322 = ((9) + inst_55321);
var inst_55323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55324 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55325 = ["count",inst_55319,inst_55321];
var inst_55326 = cljs.core.PersistentHashMap.fromArrays(inst_55324,inst_55325);
var inst_55327 = [inst_55326,inst_55322];
var inst_55328 = (new cljs.core.PersistentVector(null,2,(5),inst_55323,inst_55327,null));
var inst_55329 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55328);
var _ = (function (){var statearr_55351 = state_55334;
(statearr_55351[(4)] = cljs.core.rest.call(null,(state_55334[(4)])));

return statearr_55351;
})();
var state_55334__$1 = (function (){var statearr_55352 = state_55334;
(statearr_55352[(7)] = inst_55329);

return statearr_55352;
})();
var statearr_55353_55371 = state_55334__$1;
(statearr_55353_55371[(2)] = inst_55321);

(statearr_55353_55371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto____0 = (function (){
var statearr_55354 = [null,null,null,null,null,null,null,null];
(statearr_55354[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto__);

(statearr_55354[(1)] = (1));

return statearr_55354;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto____1 = (function (state_55334){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_55334);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55355){var ex__2882__auto__ = e55355;
var statearr_55356_55372 = state_55334;
(statearr_55356_55372[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_55334[(4)]))){
var statearr_55357_55373 = state_55334;
(statearr_55357_55373[(1)] = cljs.core.first.call(null,(state_55334[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55374 = state_55334;
state_55334 = G__55374;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto__ = function(state_55334){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto____1.call(this,state_55334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55358 = f__2902__auto__.call(null);
(statearr_55358[(6)] = c__2901__auto__);

return statearr_55358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55424){
var state_val_55425 = (state_55424[(1)]);
if((state_val_55425 === (7))){
var state_55424__$1 = state_55424;
var statearr_55426_55459 = state_55424__$1;
(statearr_55426_55459[(2)] = subject);

(statearr_55426_55459[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55425 === (1))){
var state_55424__$1 = state_55424;
var statearr_55427_55460 = state_55424__$1;
(statearr_55427_55460[(2)] = null);

(statearr_55427_55460[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55425 === (4))){
var inst_55375 = (state_55424[(2)]);
var state_55424__$1 = state_55424;
var statearr_55428_55461 = state_55424__$1;
(statearr_55428_55461[(2)] = inst_55375);

(statearr_55428_55461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55425 === (15))){
var inst_55388 = (state_55424[(7)]);
var state_55424__$1 = state_55424;
var statearr_55429_55462 = state_55424__$1;
(statearr_55429_55462[(2)] = inst_55388);

(statearr_55429_55462[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55425 === (13))){
var inst_55392 = (state_55424[(2)]);
var inst_55393 = fluree.db.util.async.throw_err.call(null,inst_55392);
var state_55424__$1 = state_55424;
var statearr_55430_55463 = state_55424__$1;
(statearr_55430_55463[(2)] = inst_55393);

(statearr_55430_55463[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55425 === (6))){
var state_55424__$1 = state_55424;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55424__$1,(9),subject);
} else {
if((state_val_55425 === (17))){
var inst_55388 = (state_55424[(7)]);
var inst_55402 = cljs.core.first.call(null,inst_55388);
var state_55424__$1 = state_55424;
var statearr_55431_55464 = state_55424__$1;
(statearr_55431_55464[(2)] = inst_55402);

(statearr_55431_55464[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55425 === (3))){
var inst_55422 = (state_55424[(2)]);
var state_55424__$1 = state_55424;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55424__$1,inst_55422);
} else {
if((state_val_55425 === (12))){
var inst_55388 = (state_55424[(7)]);
var inst_55396 = (state_55424[(2)]);
var inst_55397 = cljs.core.vector_QMARK_.call(null,inst_55388);
var state_55424__$1 = (function (){var statearr_55432 = state_55424;
(statearr_55432[(8)] = inst_55396);

return statearr_55432;
})();
if(inst_55397){
var statearr_55433_55465 = state_55424__$1;
(statearr_55433_55465[(1)] = (14));

} else {
var statearr_55434_55466 = state_55424__$1;
(statearr_55434_55466[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55425 === (2))){
var _ = (function (){var statearr_55435 = state_55424;
(statearr_55435[(4)] = cljs.core.cons.call(null,(5),(state_55424[(4)])));

return statearr_55435;
})();
var inst_55381 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_55424__$1 = state_55424;
if(inst_55381){
var statearr_55436_55467 = state_55424__$1;
(statearr_55436_55467[(1)] = (6));

} else {
var statearr_55437_55468 = state_55424__$1;
(statearr_55437_55468[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55425 === (19))){
var inst_55405 = (state_55424[(2)]);
var state_55424__$1 = state_55424;
var statearr_55438_55469 = state_55424__$1;
(statearr_55438_55469[(2)] = inst_55405);

(statearr_55438_55469[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55425 === (11))){
var state_55424__$1 = state_55424;
var statearr_55440_55470 = state_55424__$1;
(statearr_55440_55470[(2)] = pred);

(statearr_55440_55470[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55425 === (9))){
var inst_55384 = (state_55424[(2)]);
var inst_55385 = fluree.db.util.async.throw_err.call(null,inst_55384);
var state_55424__$1 = state_55424;
var statearr_55441_55471 = state_55424__$1;
(statearr_55441_55471[(2)] = inst_55385);

(statearr_55441_55471[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55425 === (5))){
var _ = (function (){var statearr_55442 = state_55424;
(statearr_55442[(4)] = cljs.core.rest.call(null,(state_55424[(4)])));

return statearr_55442;
})();
var state_55424__$1 = state_55424;
var ex55439 = (state_55424__$1[(2)]);
var statearr_55443_55472 = state_55424__$1;
(statearr_55443_55472[(5)] = ex55439);


if((ex55439 instanceof Error)){
var statearr_55444_55473 = state_55424__$1;
(statearr_55444_55473[(1)] = (4));

(statearr_55444_55473[(5)] = null);

} else {
throw ex55439;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55425 === (14))){
var inst_55388 = (state_55424[(7)]);
var inst_55399 = cljs.core.count.call(null,inst_55388);
var inst_55400 = cljs.core._EQ_.call(null,(1),inst_55399);
var state_55424__$1 = state_55424;
if(inst_55400){
var statearr_55445_55474 = state_55424__$1;
(statearr_55445_55474[(1)] = (17));

} else {
var statearr_55446_55475 = state_55424__$1;
(statearr_55446_55475[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55425 === (16))){
var inst_55388 = (state_55424[(7)]);
var inst_55396 = (state_55424[(8)]);
var inst_55408 = (state_55424[(2)]);
var inst_55409 = fluree.db.dbfunctions.internal.get.call(null,inst_55408,inst_55396);
var inst_55410 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55411 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55413 = [inst_55388,inst_55396];
var inst_55414 = (new cljs.core.PersistentVector(null,2,(5),inst_55412,inst_55413,null));
var inst_55415 = ["get",inst_55414,inst_55409];
var inst_55416 = cljs.core.PersistentHashMap.fromArrays(inst_55411,inst_55415);
var inst_55417 = [inst_55416,(10)];
var inst_55418 = (new cljs.core.PersistentVector(null,2,(5),inst_55410,inst_55417,null));
var inst_55419 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55418);
var _ = (function (){var statearr_55447 = state_55424;
(statearr_55447[(4)] = cljs.core.rest.call(null,(state_55424[(4)])));

return statearr_55447;
})();
var state_55424__$1 = (function (){var statearr_55448 = state_55424;
(statearr_55448[(9)] = inst_55419);

return statearr_55448;
})();
var statearr_55449_55476 = state_55424__$1;
(statearr_55449_55476[(2)] = inst_55409);

(statearr_55449_55476[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55425 === (10))){
var state_55424__$1 = state_55424;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55424__$1,(13),pred);
} else {
if((state_val_55425 === (18))){
var inst_55388 = (state_55424[(7)]);
var state_55424__$1 = state_55424;
var statearr_55450_55477 = state_55424__$1;
(statearr_55450_55477[(2)] = inst_55388);

(statearr_55450_55477[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55425 === (8))){
var inst_55388 = (state_55424[(2)]);
var inst_55389 = fluree.db.util.async.channel_QMARK_.call(null,pred);
var state_55424__$1 = (function (){var statearr_55451 = state_55424;
(statearr_55451[(7)] = inst_55388);

return statearr_55451;
})();
if(inst_55389){
var statearr_55452_55478 = state_55424__$1;
(statearr_55452_55478[(1)] = (10));

} else {
var statearr_55453_55479 = state_55424__$1;
(statearr_55453_55479[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto____0 = (function (){
var statearr_55454 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55454[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto__);

(statearr_55454[(1)] = (1));

return statearr_55454;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto____1 = (function (state_55424){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_55424);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55455){var ex__2882__auto__ = e55455;
var statearr_55456_55480 = state_55424;
(statearr_55456_55480[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_55424[(4)]))){
var statearr_55457_55481 = state_55424;
(statearr_55457_55481[(1)] = cljs.core.first.call(null,(state_55424[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55482 = state_55424;
state_55424 = G__55482;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto__ = function(state_55424){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto____1.call(this,state_55424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55458 = f__2902__auto__.call(null);
(statearr_55458[(6)] = c__2901__auto__);

return statearr_55458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"o","o",-1350007228).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"?o",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55521){
var state_val_55522 = (state_55521[(1)]);
if((state_val_55522 === (7))){
var inst_55489 = (state_55521[(7)]);
var state_55521__$1 = state_55521;
var statearr_55523_55547 = state_55521__$1;
(statearr_55523_55547[(2)] = inst_55489);

(statearr_55523_55547[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55522 === (1))){
var state_55521__$1 = state_55521;
var statearr_55524_55548 = state_55521__$1;
(statearr_55524_55548[(2)] = null);

(statearr_55524_55548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55522 === (4))){
var inst_55483 = (state_55521[(2)]);
var state_55521__$1 = state_55521;
var statearr_55525_55549 = state_55521__$1;
(statearr_55525_55549[(2)] = inst_55483);

(statearr_55525_55549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55522 === (6))){
var inst_55491 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55521__$1 = state_55521;
var statearr_55526_55550 = state_55521__$1;
(statearr_55526_55550[(2)] = inst_55491);

(statearr_55526_55550[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55522 === (3))){
var inst_55519 = (state_55521[(2)]);
var state_55521__$1 = state_55521;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55521__$1,inst_55519);
} else {
if((state_val_55522 === (12))){
var inst_55501 = (state_55521[(2)]);
var inst_55502 = fluree.db.util.async.throw_err.call(null,inst_55501);
var inst_55503 = cljs.core.nth.call(null,inst_55502,(0),null);
var inst_55504 = cljs.core.nth.call(null,inst_55502,(1),null);
var inst_55505 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55506 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55507 = ["?pO","?ctx",inst_55503];
var inst_55508 = cljs.core.PersistentHashMap.fromArrays(inst_55506,inst_55507);
var inst_55509 = ((10) + inst_55504);
var inst_55510 = [inst_55508,inst_55509];
var inst_55511 = (new cljs.core.PersistentVector(null,2,(5),inst_55505,inst_55510,null));
var inst_55512 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55511);
var state_55521__$1 = (function (){var statearr_55527 = state_55521;
(statearr_55527[(8)] = inst_55512);

return statearr_55527;
})();
var statearr_55528_55551 = state_55521__$1;
(statearr_55528_55551[(2)] = inst_55503);

(statearr_55528_55551[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55522 === (2))){
var inst_55489 = (state_55521[(7)]);
var _ = (function (){var statearr_55529 = state_55521;
(statearr_55529[(4)] = cljs.core.cons.call(null,(5),(state_55521[(4)])));

return statearr_55529;
})();
var inst_55489__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_55521__$1 = (function (){var statearr_55530 = state_55521;
(statearr_55530[(7)] = inst_55489__$1);

return statearr_55530;
})();
if(cljs.core.truth_(inst_55489__$1)){
var statearr_55531_55552 = state_55521__$1;
(statearr_55531_55552[(1)] = (6));

} else {
var statearr_55532_55553 = state_55521__$1;
(statearr_55532_55553[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55522 === (11))){
var inst_55516 = (state_55521[(2)]);
var _ = (function (){var statearr_55534 = state_55521;
(statearr_55534[(4)] = cljs.core.rest.call(null,(state_55521[(4)])));

return statearr_55534;
})();
var state_55521__$1 = state_55521;
var statearr_55535_55554 = state_55521__$1;
(statearr_55535_55554[(2)] = inst_55516);

(statearr_55535_55554[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55522 === (9))){
var inst_55499 = fluree.db.dbfunctions.internal._QMARK_pO.call(null,_QMARK_ctx);
var state_55521__$1 = state_55521;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55521__$1,(12),inst_55499);
} else {
if((state_val_55522 === (5))){
var _ = (function (){var statearr_55536 = state_55521;
(statearr_55536[(4)] = cljs.core.rest.call(null,(state_55521[(4)])));

return statearr_55536;
})();
var state_55521__$1 = state_55521;
var ex55533 = (state_55521__$1[(2)]);
var statearr_55537_55555 = state_55521__$1;
(statearr_55537_55555[(5)] = ex55533);


if((ex55533 instanceof Error)){
var statearr_55538_55556 = state_55521__$1;
(statearr_55538_55556[(1)] = (4));

(statearr_55538_55556[(5)] = null);

} else {
throw ex55533;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55522 === (10))){
var inst_55514 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_55521__$1 = state_55521;
var statearr_55539_55557 = state_55521__$1;
(statearr_55539_55557[(2)] = inst_55514);

(statearr_55539_55557[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55522 === (8))){
var inst_55494 = (state_55521[(2)]);
var state_55521__$1 = state_55521;
if(cljs.core.truth_(inst_55494)){
var statearr_55540_55558 = state_55521__$1;
(statearr_55540_55558[(1)] = (9));

} else {
var statearr_55541_55559 = state_55521__$1;
(statearr_55541_55559[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto____0 = (function (){
var statearr_55542 = [null,null,null,null,null,null,null,null,null];
(statearr_55542[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto__);

(statearr_55542[(1)] = (1));

return statearr_55542;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto____1 = (function (state_55521){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_55521);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55543){var ex__2882__auto__ = e55543;
var statearr_55544_55560 = state_55521;
(statearr_55544_55560[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_55521[(4)]))){
var statearr_55545_55561 = state_55521;
(statearr_55545_55561[(1)] = cljs.core.first.call(null,(state_55521[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55562 = state_55521;
state_55521 = G__55562;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto__ = function(state_55521){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto____1.call(this,state_55521);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55546 = f__2902__auto__.call(null);
(statearr_55546[(6)] = c__2901__auto__);

return statearr_55546;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55614){
var state_val_55615 = (state_55614[(1)]);
if((state_val_55615 === (7))){
var state_55614__$1 = state_55614;
var statearr_55616_55649 = state_55614__$1;
(statearr_55616_55649[(2)] = subject);

(statearr_55616_55649[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55615 === (1))){
var state_55614__$1 = state_55614;
var statearr_55617_55650 = state_55614__$1;
(statearr_55617_55650[(2)] = null);

(statearr_55617_55650[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55615 === (4))){
var inst_55563 = (state_55614[(2)]);
var state_55614__$1 = state_55614;
var statearr_55618_55651 = state_55614__$1;
(statearr_55618_55651[(2)] = inst_55563);

(statearr_55618_55651[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55615 === (15))){
var inst_55576 = (state_55614[(7)]);
var state_55614__$1 = state_55614;
var statearr_55619_55652 = state_55614__$1;
(statearr_55619_55652[(2)] = inst_55576);

(statearr_55619_55652[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55615 === (13))){
var inst_55580 = (state_55614[(2)]);
var inst_55581 = fluree.db.util.async.throw_err.call(null,inst_55580);
var state_55614__$1 = state_55614;
var statearr_55620_55653 = state_55614__$1;
(statearr_55620_55653[(2)] = inst_55581);

(statearr_55620_55653[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55615 === (6))){
var state_55614__$1 = state_55614;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55614__$1,(9),subject);
} else {
if((state_val_55615 === (17))){
var inst_55576 = (state_55614[(7)]);
var inst_55590 = cljs.core.first.call(null,inst_55576);
var state_55614__$1 = state_55614;
var statearr_55621_55654 = state_55614__$1;
(statearr_55621_55654[(2)] = inst_55590);

(statearr_55621_55654[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55615 === (3))){
var inst_55612 = (state_55614[(2)]);
var state_55614__$1 = state_55614;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55614__$1,inst_55612);
} else {
if((state_val_55615 === (12))){
var inst_55576 = (state_55614[(7)]);
var inst_55584 = (state_55614[(2)]);
var inst_55585 = cljs.core.vector_QMARK_.call(null,inst_55576);
var state_55614__$1 = (function (){var statearr_55622 = state_55614;
(statearr_55622[(8)] = inst_55584);

return statearr_55622;
})();
if(inst_55585){
var statearr_55623_55655 = state_55614__$1;
(statearr_55623_55655[(1)] = (14));

} else {
var statearr_55624_55656 = state_55614__$1;
(statearr_55624_55656[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55615 === (2))){
var _ = (function (){var statearr_55625 = state_55614;
(statearr_55625[(4)] = cljs.core.cons.call(null,(5),(state_55614[(4)])));

return statearr_55625;
})();
var inst_55569 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_55614__$1 = state_55614;
if(inst_55569){
var statearr_55626_55657 = state_55614__$1;
(statearr_55626_55657[(1)] = (6));

} else {
var statearr_55627_55658 = state_55614__$1;
(statearr_55627_55658[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55615 === (19))){
var inst_55593 = (state_55614[(2)]);
var state_55614__$1 = state_55614;
var statearr_55628_55659 = state_55614__$1;
(statearr_55628_55659[(2)] = inst_55593);

(statearr_55628_55659[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55615 === (11))){
var state_55614__$1 = state_55614;
var statearr_55630_55660 = state_55614__$1;
(statearr_55630_55660[(2)] = path);

(statearr_55630_55660[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55615 === (9))){
var inst_55572 = (state_55614[(2)]);
var inst_55573 = fluree.db.util.async.throw_err.call(null,inst_55572);
var state_55614__$1 = state_55614;
var statearr_55631_55661 = state_55614__$1;
(statearr_55631_55661[(2)] = inst_55573);

(statearr_55631_55661[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55615 === (5))){
var _ = (function (){var statearr_55632 = state_55614;
(statearr_55632[(4)] = cljs.core.rest.call(null,(state_55614[(4)])));

return statearr_55632;
})();
var state_55614__$1 = state_55614;
var ex55629 = (state_55614__$1[(2)]);
var statearr_55633_55662 = state_55614__$1;
(statearr_55633_55662[(5)] = ex55629);


if((ex55629 instanceof Error)){
var statearr_55634_55663 = state_55614__$1;
(statearr_55634_55663[(1)] = (4));

(statearr_55634_55663[(5)] = null);

} else {
throw ex55629;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55615 === (14))){
var inst_55576 = (state_55614[(7)]);
var inst_55587 = cljs.core.count.call(null,inst_55576);
var inst_55588 = cljs.core._EQ_.call(null,(1),inst_55587);
var state_55614__$1 = state_55614;
if(inst_55588){
var statearr_55635_55664 = state_55614__$1;
(statearr_55635_55664[(1)] = (17));

} else {
var statearr_55636_55665 = state_55614__$1;
(statearr_55636_55665[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55615 === (16))){
var inst_55576 = (state_55614[(7)]);
var inst_55584 = (state_55614[(8)]);
var inst_55596 = (state_55614[(2)]);
var inst_55597 = fluree.db.dbfunctions.internal.get_all.call(null,inst_55596,inst_55584);
var inst_55598 = cljs.core.count.call(null,inst_55584);
var inst_55599 = ((9) + inst_55598);
var inst_55600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55601 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55603 = [inst_55576,inst_55584];
var inst_55604 = (new cljs.core.PersistentVector(null,2,(5),inst_55602,inst_55603,null));
var inst_55605 = ["get-all",inst_55604,inst_55597];
var inst_55606 = cljs.core.PersistentHashMap.fromArrays(inst_55601,inst_55605);
var inst_55607 = [inst_55606,inst_55599];
var inst_55608 = (new cljs.core.PersistentVector(null,2,(5),inst_55600,inst_55607,null));
var inst_55609 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55608);
var _ = (function (){var statearr_55637 = state_55614;
(statearr_55637[(4)] = cljs.core.rest.call(null,(state_55614[(4)])));

return statearr_55637;
})();
var state_55614__$1 = (function (){var statearr_55638 = state_55614;
(statearr_55638[(9)] = inst_55609);

return statearr_55638;
})();
var statearr_55639_55666 = state_55614__$1;
(statearr_55639_55666[(2)] = inst_55597);

(statearr_55639_55666[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55615 === (10))){
var state_55614__$1 = state_55614;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55614__$1,(13),path);
} else {
if((state_val_55615 === (18))){
var inst_55576 = (state_55614[(7)]);
var state_55614__$1 = state_55614;
var statearr_55640_55667 = state_55614__$1;
(statearr_55640_55667[(2)] = inst_55576);

(statearr_55640_55667[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55615 === (8))){
var inst_55576 = (state_55614[(2)]);
var inst_55577 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_55614__$1 = (function (){var statearr_55641 = state_55614;
(statearr_55641[(7)] = inst_55576);

return statearr_55641;
})();
if(inst_55577){
var statearr_55642_55668 = state_55614__$1;
(statearr_55642_55668[(1)] = (10));

} else {
var statearr_55643_55669 = state_55614__$1;
(statearr_55643_55669[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto____0 = (function (){
var statearr_55644 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55644[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto__);

(statearr_55644[(1)] = (1));

return statearr_55644;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto____1 = (function (state_55614){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_55614);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55645){var ex__2882__auto__ = e55645;
var statearr_55646_55670 = state_55614;
(statearr_55646_55670[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_55614[(4)]))){
var statearr_55647_55671 = state_55614;
(statearr_55647_55671[(1)] = cljs.core.first.call(null,(state_55614[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55672 = state_55614;
state_55614 = G__55672;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto__ = function(state_55614){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto____1.call(this,state_55614);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55648 = f__2902__auto__.call(null);
(statearr_55648[(6)] = c__2901__auto__);

return statearr_55648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55711){
var state_val_55712 = (state_55711[(1)]);
if((state_val_55712 === (7))){
var state_55711__$1 = state_55711;
var statearr_55713_55737 = state_55711__$1;
(statearr_55713_55737[(2)] = subject);

(statearr_55713_55737[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55712 === (1))){
var state_55711__$1 = state_55711;
var statearr_55714_55738 = state_55711__$1;
(statearr_55714_55738[(2)] = null);

(statearr_55714_55738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55712 === (4))){
var inst_55673 = (state_55711[(2)]);
var state_55711__$1 = state_55711;
var statearr_55715_55739 = state_55711__$1;
(statearr_55715_55739[(2)] = inst_55673);

(statearr_55715_55739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55712 === (13))){
var inst_55690 = (state_55711[(2)]);
var inst_55691 = fluree.db.util.async.throw_err.call(null,inst_55690);
var state_55711__$1 = state_55711;
var statearr_55716_55740 = state_55711__$1;
(statearr_55716_55740[(2)] = inst_55691);

(statearr_55716_55740[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55712 === (6))){
var state_55711__$1 = state_55711;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55711__$1,(9),subject);
} else {
if((state_val_55712 === (3))){
var inst_55709 = (state_55711[(2)]);
var state_55711__$1 = state_55711;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55711__$1,inst_55709);
} else {
if((state_val_55712 === (12))){
var inst_55686 = (state_55711[(7)]);
var inst_55694 = (state_55711[(2)]);
var inst_55695 = fluree.db.dbfunctions.internal.get_in.call(null,inst_55686,inst_55694);
var inst_55696 = cljs.core.count.call(null,inst_55694);
var inst_55697 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55698 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55700 = [inst_55686,inst_55694];
var inst_55701 = (new cljs.core.PersistentVector(null,2,(5),inst_55699,inst_55700,null));
var inst_55702 = ["get-in",inst_55701,inst_55695];
var inst_55703 = cljs.core.PersistentHashMap.fromArrays(inst_55698,inst_55702);
var inst_55704 = [inst_55703,inst_55696];
var inst_55705 = (new cljs.core.PersistentVector(null,2,(5),inst_55697,inst_55704,null));
var inst_55706 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55705);
var _ = (function (){var statearr_55717 = state_55711;
(statearr_55717[(4)] = cljs.core.rest.call(null,(state_55711[(4)])));

return statearr_55717;
})();
var state_55711__$1 = (function (){var statearr_55718 = state_55711;
(statearr_55718[(8)] = inst_55706);

return statearr_55718;
})();
var statearr_55719_55741 = state_55711__$1;
(statearr_55719_55741[(2)] = inst_55695);

(statearr_55719_55741[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55712 === (2))){
var _ = (function (){var statearr_55720 = state_55711;
(statearr_55720[(4)] = cljs.core.cons.call(null,(5),(state_55711[(4)])));

return statearr_55720;
})();
var inst_55679 = fluree.db.util.async.channel_QMARK_.call(null,subject);
var state_55711__$1 = state_55711;
if(inst_55679){
var statearr_55721_55742 = state_55711__$1;
(statearr_55721_55742[(1)] = (6));

} else {
var statearr_55722_55743 = state_55711__$1;
(statearr_55722_55743[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55712 === (11))){
var state_55711__$1 = state_55711;
var statearr_55724_55744 = state_55711__$1;
(statearr_55724_55744[(2)] = path);

(statearr_55724_55744[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55712 === (9))){
var inst_55682 = (state_55711[(2)]);
var inst_55683 = fluree.db.util.async.throw_err.call(null,inst_55682);
var state_55711__$1 = state_55711;
var statearr_55725_55745 = state_55711__$1;
(statearr_55725_55745[(2)] = inst_55683);

(statearr_55725_55745[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55712 === (5))){
var _ = (function (){var statearr_55726 = state_55711;
(statearr_55726[(4)] = cljs.core.rest.call(null,(state_55711[(4)])));

return statearr_55726;
})();
var state_55711__$1 = state_55711;
var ex55723 = (state_55711__$1[(2)]);
var statearr_55727_55746 = state_55711__$1;
(statearr_55727_55746[(5)] = ex55723);


if((ex55723 instanceof Error)){
var statearr_55728_55747 = state_55711__$1;
(statearr_55728_55747[(1)] = (4));

(statearr_55728_55747[(5)] = null);

} else {
throw ex55723;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55712 === (10))){
var state_55711__$1 = state_55711;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55711__$1,(13),path);
} else {
if((state_val_55712 === (8))){
var inst_55686 = (state_55711[(2)]);
var inst_55687 = fluree.db.util.async.channel_QMARK_.call(null,path);
var state_55711__$1 = (function (){var statearr_55729 = state_55711;
(statearr_55729[(7)] = inst_55686);

return statearr_55729;
})();
if(inst_55687){
var statearr_55730_55748 = state_55711__$1;
(statearr_55730_55748[(1)] = (10));

} else {
var statearr_55731_55749 = state_55711__$1;
(statearr_55731_55749[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto____0 = (function (){
var statearr_55732 = [null,null,null,null,null,null,null,null,null];
(statearr_55732[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto__);

(statearr_55732[(1)] = (1));

return statearr_55732;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto____1 = (function (state_55711){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_55711);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55733){var ex__2882__auto__ = e55733;
var statearr_55734_55750 = state_55711;
(statearr_55734_55750[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_55711[(4)]))){
var statearr_55735_55751 = state_55711;
(statearr_55735_55751[(1)] = cljs.core.first.call(null,(state_55711[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55752 = state_55711;
state_55711 = G__55752;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto__ = function(state_55711){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto____1.call(this,state_55711);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55736 = f__2902__auto__.call(null);
(statearr_55736[(6)] = c__2901__auto__);

return statearr_55736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55797){
var state_val_55798 = (state_55797[(1)]);
if((state_val_55798 === (7))){
var state_55797__$1 = state_55797;
var statearr_55799_55828 = state_55797__$1;
(statearr_55799_55828[(2)] = coll);

(statearr_55799_55828[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55798 === (1))){
var state_55797__$1 = state_55797;
var statearr_55800_55829 = state_55797__$1;
(statearr_55800_55829[(2)] = null);

(statearr_55800_55829[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55798 === (4))){
var inst_55753 = (state_55797[(2)]);
var state_55797__$1 = state_55797;
var statearr_55801_55830 = state_55797__$1;
(statearr_55801_55830[(2)] = inst_55753);

(statearr_55801_55830[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55798 === (15))){
var inst_55773 = (state_55797[(7)]);
var inst_55781 = (state_55797[(2)]);
var inst_55782 = fluree.db.dbfunctions.internal.contains_QMARK_.call(null,inst_55773,inst_55781);
var inst_55783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55784 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55785 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55786 = [inst_55773,inst_55781];
var inst_55787 = (new cljs.core.PersistentVector(null,2,(5),inst_55785,inst_55786,null));
var inst_55788 = ["contains?",inst_55787,inst_55782];
var inst_55789 = cljs.core.PersistentHashMap.fromArrays(inst_55784,inst_55788);
var inst_55790 = [inst_55789,(10)];
var inst_55791 = (new cljs.core.PersistentVector(null,2,(5),inst_55783,inst_55790,null));
var inst_55792 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55791);
var _ = (function (){var statearr_55802 = state_55797;
(statearr_55802[(4)] = cljs.core.rest.call(null,(state_55797[(4)])));

return statearr_55802;
})();
var state_55797__$1 = (function (){var statearr_55803 = state_55797;
(statearr_55803[(8)] = inst_55792);

return statearr_55803;
})();
var statearr_55804_55831 = state_55797__$1;
(statearr_55804_55831[(2)] = inst_55782);

(statearr_55804_55831[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55798 === (13))){
var state_55797__$1 = state_55797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55797__$1,(16),key);
} else {
if((state_val_55798 === (6))){
var state_55797__$1 = state_55797;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55797__$1,(9),coll);
} else {
if((state_val_55798 === (3))){
var inst_55795 = (state_55797[(2)]);
var state_55797__$1 = state_55797;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55797__$1,inst_55795);
} else {
if((state_val_55798 === (12))){
var inst_55773 = (state_55797[(2)]);
var inst_55774 = fluree.db.util.async.channel_QMARK_.call(null,key);
var state_55797__$1 = (function (){var statearr_55805 = state_55797;
(statearr_55805[(7)] = inst_55773);

return statearr_55805;
})();
if(inst_55774){
var statearr_55806_55832 = state_55797__$1;
(statearr_55806_55832[(1)] = (13));

} else {
var statearr_55807_55833 = state_55797__$1;
(statearr_55807_55833[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55798 === (2))){
var _ = (function (){var statearr_55808 = state_55797;
(statearr_55808[(4)] = cljs.core.cons.call(null,(5),(state_55797[(4)])));

return statearr_55808;
})();
var inst_55759 = fluree.db.util.async.channel_QMARK_.call(null,coll);
var state_55797__$1 = state_55797;
if(inst_55759){
var statearr_55809_55834 = state_55797__$1;
(statearr_55809_55834[(1)] = (6));

} else {
var statearr_55810_55835 = state_55797__$1;
(statearr_55810_55835[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55798 === (11))){
var inst_55766 = (state_55797[(9)]);
var inst_55770 = cljs.core.flatten.call(null,inst_55766);
var inst_55771 = cljs.core.set.call(null,inst_55770);
var state_55797__$1 = state_55797;
var statearr_55812_55836 = state_55797__$1;
(statearr_55812_55836[(2)] = inst_55771);

(statearr_55812_55836[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55798 === (9))){
var inst_55762 = (state_55797[(2)]);
var inst_55763 = fluree.db.util.async.throw_err.call(null,inst_55762);
var state_55797__$1 = state_55797;
var statearr_55813_55837 = state_55797__$1;
(statearr_55813_55837[(2)] = inst_55763);

(statearr_55813_55837[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55798 === (5))){
var _ = (function (){var statearr_55814 = state_55797;
(statearr_55814[(4)] = cljs.core.rest.call(null,(state_55797[(4)])));

return statearr_55814;
})();
var state_55797__$1 = state_55797;
var ex55811 = (state_55797__$1[(2)]);
var statearr_55815_55838 = state_55797__$1;
(statearr_55815_55838[(5)] = ex55811);


if((ex55811 instanceof Error)){
var statearr_55816_55839 = state_55797__$1;
(statearr_55816_55839[(1)] = (4));

(statearr_55816_55839[(5)] = null);

} else {
throw ex55811;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55798 === (14))){
var state_55797__$1 = state_55797;
var statearr_55817_55840 = state_55797__$1;
(statearr_55817_55840[(2)] = key);

(statearr_55817_55840[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55798 === (16))){
var inst_55777 = (state_55797[(2)]);
var inst_55778 = fluree.db.util.async.throw_err.call(null,inst_55777);
var state_55797__$1 = state_55797;
var statearr_55818_55841 = state_55797__$1;
(statearr_55818_55841[(2)] = inst_55778);

(statearr_55818_55841[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55798 === (10))){
var inst_55766 = (state_55797[(9)]);
var state_55797__$1 = state_55797;
var statearr_55819_55842 = state_55797__$1;
(statearr_55819_55842[(2)] = inst_55766);

(statearr_55819_55842[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55798 === (8))){
var inst_55766 = (state_55797[(9)]);
var inst_55766__$1 = (state_55797[(2)]);
var inst_55767 = cljs.core.set_QMARK_.call(null,inst_55766__$1);
var state_55797__$1 = (function (){var statearr_55820 = state_55797;
(statearr_55820[(9)] = inst_55766__$1);

return statearr_55820;
})();
if(inst_55767){
var statearr_55821_55843 = state_55797__$1;
(statearr_55821_55843[(1)] = (10));

} else {
var statearr_55822_55844 = state_55797__$1;
(statearr_55822_55844[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto____0 = (function (){
var statearr_55823 = [null,null,null,null,null,null,null,null,null,null];
(statearr_55823[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto__);

(statearr_55823[(1)] = (1));

return statearr_55823;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto____1 = (function (state_55797){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_55797);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55824){var ex__2882__auto__ = e55824;
var statearr_55825_55845 = state_55797;
(statearr_55825_55845[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_55797[(4)]))){
var statearr_55826_55846 = state_55797;
(statearr_55826_55846[(1)] = cljs.core.first.call(null,(state_55797[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55847 = state_55797;
state_55797 = G__55847;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto__ = function(state_55797){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto____1.call(this,state_55797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55827 = f__2902__auto__.call(null);
(statearr_55827[(6)] = c__2901__auto__);

return statearr_55827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55912 = arguments.length;
var i__4737__auto___55913 = (0);
while(true){
if((i__4737__auto___55913 < len__4736__auto___55912)){
args__4742__auto__.push((arguments[i__4737__auto___55913]));

var G__55914 = (i__4737__auto___55913 + (1));
i__4737__auto___55913 = G__55914;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55890){
var state_val_55891 = (state_55890[(1)]);
if((state_val_55891 === (7))){
var inst_55859 = (state_55890[(7)]);
var inst_55866 = cljs.core.first.call(null,inst_55859);
var state_55890__$1 = state_55890;
var statearr_55892_55915 = state_55890__$1;
(statearr_55892_55915[(2)] = inst_55866);

(statearr_55892_55915[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (1))){
var state_55890__$1 = state_55890;
var statearr_55893_55916 = state_55890__$1;
(statearr_55893_55916[(2)] = null);

(statearr_55893_55916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (4))){
var inst_55850 = (state_55890[(2)]);
var state_55890__$1 = state_55890;
var statearr_55894_55917 = state_55890__$1;
(statearr_55894_55917[(2)] = inst_55850);

(statearr_55894_55917[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (6))){
var inst_55859 = (state_55890[(7)]);
var inst_55858 = (state_55890[(2)]);
var inst_55859__$1 = fluree.db.util.async.throw_err.call(null,inst_55858);
var inst_55860 = cljs.core.count.call(null,inst_55859__$1);
var inst_55861 = cljs.core._EQ_.call(null,(1),inst_55860);
var inst_55862 = cljs.core.first.call(null,inst_55859__$1);
var inst_55863 = cljs.core.coll_QMARK_.call(null,inst_55862);
var inst_55864 = ((inst_55861) && (inst_55863));
var state_55890__$1 = (function (){var statearr_55895 = state_55890;
(statearr_55895[(7)] = inst_55859__$1);

return statearr_55895;
})();
if(cljs.core.truth_(inst_55864)){
var statearr_55896_55918 = state_55890__$1;
(statearr_55896_55918[(1)] = (7));

} else {
var statearr_55897_55919 = state_55890__$1;
(statearr_55897_55919[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (3))){
var inst_55888 = (state_55890[(2)]);
var state_55890__$1 = state_55890;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55890__$1,inst_55888);
} else {
if((state_val_55891 === (2))){
var _ = (function (){var statearr_55899 = state_55890;
(statearr_55899[(4)] = cljs.core.cons.call(null,(5),(state_55890[(4)])));

return statearr_55899;
})();
var inst_55856 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55890__$1 = state_55890;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55890__$1,(6),inst_55856);
} else {
if((state_val_55891 === (9))){
var inst_55869 = (state_55890[(2)]);
var inst_55870 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.hash_set,inst_55869);
var inst_55871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55872 = [inst_55869];
var inst_55873 = (new cljs.core.PersistentVector(null,1,(5),inst_55871,inst_55872,null));
var inst_55874 = cljs.core.count.call(null,inst_55873);
var inst_55875 = ((9) + inst_55874);
var inst_55876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55877 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55878 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55879 = [inst_55869];
var inst_55880 = (new cljs.core.PersistentVector(null,1,(5),inst_55878,inst_55879,null));
var inst_55881 = ["hash-set",inst_55880,inst_55870];
var inst_55882 = cljs.core.PersistentHashMap.fromArrays(inst_55877,inst_55881);
var inst_55883 = [inst_55882,inst_55875];
var inst_55884 = (new cljs.core.PersistentVector(null,2,(5),inst_55876,inst_55883,null));
var inst_55885 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55884);
var _ = (function (){var statearr_55900 = state_55890;
(statearr_55900[(4)] = cljs.core.rest.call(null,(state_55890[(4)])));

return statearr_55900;
})();
var state_55890__$1 = (function (){var statearr_55901 = state_55890;
(statearr_55901[(8)] = inst_55885);

return statearr_55901;
})();
var statearr_55902_55920 = state_55890__$1;
(statearr_55902_55920[(2)] = inst_55870);

(statearr_55902_55920[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (5))){
var _ = (function (){var statearr_55903 = state_55890;
(statearr_55903[(4)] = cljs.core.rest.call(null,(state_55890[(4)])));

return statearr_55903;
})();
var state_55890__$1 = state_55890;
var ex55898 = (state_55890__$1[(2)]);
var statearr_55904_55921 = state_55890__$1;
(statearr_55904_55921[(5)] = ex55898);


if((ex55898 instanceof Error)){
var statearr_55905_55922 = state_55890__$1;
(statearr_55905_55922[(1)] = (4));

(statearr_55905_55922[(5)] = null);

} else {
throw ex55898;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55891 === (8))){
var inst_55859 = (state_55890[(7)]);
var state_55890__$1 = state_55890;
var statearr_55906_55923 = state_55890__$1;
(statearr_55906_55923[(2)] = inst_55859);

(statearr_55906_55923[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_55907 = [null,null,null,null,null,null,null,null,null];
(statearr_55907[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_55907[(1)] = (1));

return statearr_55907;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_55890){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_55890);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55908){var ex__2882__auto__ = e55908;
var statearr_55909_55924 = state_55890;
(statearr_55909_55924[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_55890[(4)]))){
var statearr_55910_55925 = state_55890;
(statearr_55910_55925[(1)] = cljs.core.first.call(null,(state_55890[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55926 = state_55890;
state_55890 = G__55926;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_55890){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_55890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55911 = f__2902__auto__.call(null);
(statearr_55911[(6)] = c__2901__auto__);

return statearr_55911;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq55848){
var G__55849 = cljs.core.first.call(null,seq55848);
var seq55848__$1 = cljs.core.next.call(null,seq55848);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55849,seq55848__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___55976 = arguments.length;
var i__4737__auto___55977 = (0);
while(true){
if((i__4737__auto___55977 < len__4736__auto___55976)){
args__4742__auto__.push((arguments[i__4737__auto___55977]));

var G__55978 = (i__4737__auto___55977 + (1));
i__4737__auto___55977 = G__55978;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_55959){
var state_val_55960 = (state_55959[(1)]);
if((state_val_55960 === (1))){
var state_55959__$1 = state_55959;
var statearr_55961_55979 = state_55959__$1;
(statearr_55961_55979[(2)] = null);

(statearr_55961_55979[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55960 === (2))){
var _ = (function (){var statearr_55962 = state_55959;
(statearr_55962[(4)] = cljs.core.cons.call(null,(5),(state_55959[(4)])));

return statearr_55962;
})();
var inst_55935 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_55959__$1 = state_55959;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_55959__$1,(6),inst_55935);
} else {
if((state_val_55960 === (3))){
var inst_55957 = (state_55959[(2)]);
var state_55959__$1 = state_55959;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_55959__$1,inst_55957);
} else {
if((state_val_55960 === (4))){
var inst_55929 = (state_55959[(2)]);
var state_55959__$1 = state_55959;
var statearr_55964_55980 = state_55959__$1;
(statearr_55964_55980[(2)] = inst_55929);

(statearr_55964_55980[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55960 === (5))){
var _ = (function (){var statearr_55965 = state_55959;
(statearr_55965[(4)] = cljs.core.rest.call(null,(state_55959[(4)])));

return statearr_55965;
})();
var state_55959__$1 = state_55959;
var ex55963 = (state_55959__$1[(2)]);
var statearr_55966_55981 = state_55959__$1;
(statearr_55966_55981[(5)] = ex55963);


if((ex55963 instanceof Error)){
var statearr_55967_55982 = state_55959__$1;
(statearr_55967_55982[(1)] = (4));

(statearr_55967_55982[(5)] = null);

} else {
throw ex55963;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_55960 === (6))){
var inst_55937 = (state_55959[(2)]);
var inst_55938 = fluree.db.util.async.throw_err.call(null,inst_55937);
var inst_55939 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._EQ__EQ_,inst_55938);
var inst_55940 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55941 = [inst_55938];
var inst_55942 = (new cljs.core.PersistentVector(null,1,(5),inst_55940,inst_55941,null));
var inst_55943 = cljs.core.count.call(null,inst_55942);
var inst_55944 = ((9) + inst_55943);
var inst_55945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55946 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_55947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_55948 = [inst_55938];
var inst_55949 = (new cljs.core.PersistentVector(null,1,(5),inst_55947,inst_55948,null));
var inst_55950 = ["==",inst_55949,inst_55939];
var inst_55951 = cljs.core.PersistentHashMap.fromArrays(inst_55946,inst_55950);
var inst_55952 = [inst_55951,inst_55944];
var inst_55953 = (new cljs.core.PersistentVector(null,2,(5),inst_55945,inst_55952,null));
var inst_55954 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_55953);
var _ = (function (){var statearr_55968 = state_55959;
(statearr_55968[(4)] = cljs.core.rest.call(null,(state_55959[(4)])));

return statearr_55968;
})();
var state_55959__$1 = (function (){var statearr_55969 = state_55959;
(statearr_55969[(7)] = inst_55954);

return statearr_55969;
})();
var statearr_55970_55983 = state_55959__$1;
(statearr_55970_55983[(2)] = inst_55939);

(statearr_55970_55983[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_55971 = [null,null,null,null,null,null,null,null];
(statearr_55971[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_55971[(1)] = (1));

return statearr_55971;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_55959){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_55959);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e55972){var ex__2882__auto__ = e55972;
var statearr_55973_55984 = state_55959;
(statearr_55973_55984[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_55959[(4)]))){
var statearr_55974_55985 = state_55959;
(statearr_55974_55985[(1)] = cljs.core.first.call(null,(state_55959[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55986 = state_55959;
state_55959 = G__55986;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_55959){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_55959);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_55975 = f__2902__auto__.call(null);
(statearr_55975[(6)] = c__2901__auto__);

return statearr_55975;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq55927){
var G__55928 = cljs.core.first.call(null,seq55927);
var seq55927__$1 = cljs.core.next.call(null,seq55927);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55928,seq55927__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56036 = arguments.length;
var i__4737__auto___56037 = (0);
while(true){
if((i__4737__auto___56037 < len__4736__auto___56036)){
args__4742__auto__.push((arguments[i__4737__auto___56037]));

var G__56038 = (i__4737__auto___56037 + (1));
i__4737__auto___56037 = G__56038;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56019){
var state_val_56020 = (state_56019[(1)]);
if((state_val_56020 === (1))){
var state_56019__$1 = state_56019;
var statearr_56021_56039 = state_56019__$1;
(statearr_56021_56039[(2)] = null);

(statearr_56021_56039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56020 === (2))){
var _ = (function (){var statearr_56022 = state_56019;
(statearr_56022[(4)] = cljs.core.cons.call(null,(5),(state_56019[(4)])));

return statearr_56022;
})();
var inst_55995 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56019__$1 = state_56019;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56019__$1,(6),inst_55995);
} else {
if((state_val_56020 === (3))){
var inst_56017 = (state_56019[(2)]);
var state_56019__$1 = state_56019;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56019__$1,inst_56017);
} else {
if((state_val_56020 === (4))){
var inst_55989 = (state_56019[(2)]);
var state_56019__$1 = state_56019;
var statearr_56024_56040 = state_56019__$1;
(statearr_56024_56040[(2)] = inst_55989);

(statearr_56024_56040[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56020 === (5))){
var _ = (function (){var statearr_56025 = state_56019;
(statearr_56025[(4)] = cljs.core.rest.call(null,(state_56019[(4)])));

return statearr_56025;
})();
var state_56019__$1 = state_56019;
var ex56023 = (state_56019__$1[(2)]);
var statearr_56026_56041 = state_56019__$1;
(statearr_56026_56041[(5)] = ex56023);


if((ex56023 instanceof Error)){
var statearr_56027_56042 = state_56019__$1;
(statearr_56027_56042[(1)] = (4));

(statearr_56027_56042[(5)] = null);

} else {
throw ex56023;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56020 === (6))){
var inst_55997 = (state_56019[(2)]);
var inst_55998 = fluree.db.util.async.throw_err.call(null,inst_55997);
var inst_55999 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT_,inst_55998);
var inst_56000 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56001 = [inst_55998];
var inst_56002 = (new cljs.core.PersistentVector(null,1,(5),inst_56000,inst_56001,null));
var inst_56003 = cljs.core.count.call(null,inst_56002);
var inst_56004 = ((9) + inst_56003);
var inst_56005 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56006 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56007 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56008 = [inst_55998];
var inst_56009 = (new cljs.core.PersistentVector(null,1,(5),inst_56007,inst_56008,null));
var inst_56010 = [">",inst_56009,inst_55999];
var inst_56011 = cljs.core.PersistentHashMap.fromArrays(inst_56006,inst_56010);
var inst_56012 = [inst_56011,inst_56004];
var inst_56013 = (new cljs.core.PersistentVector(null,2,(5),inst_56005,inst_56012,null));
var inst_56014 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56013);
var _ = (function (){var statearr_56028 = state_56019;
(statearr_56028[(4)] = cljs.core.rest.call(null,(state_56019[(4)])));

return statearr_56028;
})();
var state_56019__$1 = (function (){var statearr_56029 = state_56019;
(statearr_56029[(7)] = inst_56014);

return statearr_56029;
})();
var statearr_56030_56043 = state_56019__$1;
(statearr_56030_56043[(2)] = inst_55999);

(statearr_56030_56043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56031 = [null,null,null,null,null,null,null,null];
(statearr_56031[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56031[(1)] = (1));

return statearr_56031;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56019){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_56019);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56032){var ex__2882__auto__ = e56032;
var statearr_56033_56044 = state_56019;
(statearr_56033_56044[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_56019[(4)]))){
var statearr_56034_56045 = state_56019;
(statearr_56034_56045[(1)] = cljs.core.first.call(null,(state_56019[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56046 = state_56019;
state_56019 = G__56046;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56019){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56035 = f__2902__auto__.call(null);
(statearr_56035[(6)] = c__2901__auto__);

return statearr_56035;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq55987){
var G__55988 = cljs.core.first.call(null,seq55987);
var seq55987__$1 = cljs.core.next.call(null,seq55987);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__55988,seq55987__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56096 = arguments.length;
var i__4737__auto___56097 = (0);
while(true){
if((i__4737__auto___56097 < len__4736__auto___56096)){
args__4742__auto__.push((arguments[i__4737__auto___56097]));

var G__56098 = (i__4737__auto___56097 + (1));
i__4737__auto___56097 = G__56098;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56079){
var state_val_56080 = (state_56079[(1)]);
if((state_val_56080 === (1))){
var state_56079__$1 = state_56079;
var statearr_56081_56099 = state_56079__$1;
(statearr_56081_56099[(2)] = null);

(statearr_56081_56099[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56080 === (2))){
var _ = (function (){var statearr_56082 = state_56079;
(statearr_56082[(4)] = cljs.core.cons.call(null,(5),(state_56079[(4)])));

return statearr_56082;
})();
var inst_56055 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56079__$1 = state_56079;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56079__$1,(6),inst_56055);
} else {
if((state_val_56080 === (3))){
var inst_56077 = (state_56079[(2)]);
var state_56079__$1 = state_56079;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56079__$1,inst_56077);
} else {
if((state_val_56080 === (4))){
var inst_56049 = (state_56079[(2)]);
var state_56079__$1 = state_56079;
var statearr_56084_56100 = state_56079__$1;
(statearr_56084_56100[(2)] = inst_56049);

(statearr_56084_56100[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56080 === (5))){
var _ = (function (){var statearr_56085 = state_56079;
(statearr_56085[(4)] = cljs.core.rest.call(null,(state_56079[(4)])));

return statearr_56085;
})();
var state_56079__$1 = state_56079;
var ex56083 = (state_56079__$1[(2)]);
var statearr_56086_56101 = state_56079__$1;
(statearr_56086_56101[(5)] = ex56083);


if((ex56083 instanceof Error)){
var statearr_56087_56102 = state_56079__$1;
(statearr_56087_56102[(1)] = (4));

(statearr_56087_56102[(5)] = null);

} else {
throw ex56083;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56080 === (6))){
var inst_56057 = (state_56079[(2)]);
var inst_56058 = fluree.db.util.async.throw_err.call(null,inst_56057);
var inst_56059 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT_,inst_56058);
var inst_56060 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56061 = [inst_56058];
var inst_56062 = (new cljs.core.PersistentVector(null,1,(5),inst_56060,inst_56061,null));
var inst_56063 = cljs.core.count.call(null,inst_56062);
var inst_56064 = ((9) + inst_56063);
var inst_56065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56066 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56067 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56068 = [inst_56058];
var inst_56069 = (new cljs.core.PersistentVector(null,1,(5),inst_56067,inst_56068,null));
var inst_56070 = ["<",inst_56069,inst_56059];
var inst_56071 = cljs.core.PersistentHashMap.fromArrays(inst_56066,inst_56070);
var inst_56072 = [inst_56071,inst_56064];
var inst_56073 = (new cljs.core.PersistentVector(null,2,(5),inst_56065,inst_56072,null));
var inst_56074 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56073);
var _ = (function (){var statearr_56088 = state_56079;
(statearr_56088[(4)] = cljs.core.rest.call(null,(state_56079[(4)])));

return statearr_56088;
})();
var state_56079__$1 = (function (){var statearr_56089 = state_56079;
(statearr_56089[(7)] = inst_56074);

return statearr_56089;
})();
var statearr_56090_56103 = state_56079__$1;
(statearr_56090_56103[(2)] = inst_56059);

(statearr_56090_56103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56091 = [null,null,null,null,null,null,null,null];
(statearr_56091[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56091[(1)] = (1));

return statearr_56091;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56079){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_56079);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56092){var ex__2882__auto__ = e56092;
var statearr_56093_56104 = state_56079;
(statearr_56093_56104[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_56079[(4)]))){
var statearr_56094_56105 = state_56079;
(statearr_56094_56105[(1)] = cljs.core.first.call(null,(state_56079[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56106 = state_56079;
state_56079 = G__56106;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56079){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56095 = f__2902__auto__.call(null);
(statearr_56095[(6)] = c__2901__auto__);

return statearr_56095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq56047){
var G__56048 = cljs.core.first.call(null,seq56047);
var seq56047__$1 = cljs.core.next.call(null,seq56047);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56048,seq56047__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56156 = arguments.length;
var i__4737__auto___56157 = (0);
while(true){
if((i__4737__auto___56157 < len__4736__auto___56156)){
args__4742__auto__.push((arguments[i__4737__auto___56157]));

var G__56158 = (i__4737__auto___56157 + (1));
i__4737__auto___56157 = G__56158;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56139){
var state_val_56140 = (state_56139[(1)]);
if((state_val_56140 === (1))){
var state_56139__$1 = state_56139;
var statearr_56141_56159 = state_56139__$1;
(statearr_56141_56159[(2)] = null);

(statearr_56141_56159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56140 === (2))){
var _ = (function (){var statearr_56142 = state_56139;
(statearr_56142[(4)] = cljs.core.cons.call(null,(5),(state_56139[(4)])));

return statearr_56142;
})();
var inst_56115 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56139__$1 = state_56139;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56139__$1,(6),inst_56115);
} else {
if((state_val_56140 === (3))){
var inst_56137 = (state_56139[(2)]);
var state_56139__$1 = state_56139;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56139__$1,inst_56137);
} else {
if((state_val_56140 === (4))){
var inst_56109 = (state_56139[(2)]);
var state_56139__$1 = state_56139;
var statearr_56144_56160 = state_56139__$1;
(statearr_56144_56160[(2)] = inst_56109);

(statearr_56144_56160[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56140 === (5))){
var _ = (function (){var statearr_56145 = state_56139;
(statearr_56145[(4)] = cljs.core.rest.call(null,(state_56139[(4)])));

return statearr_56145;
})();
var state_56139__$1 = state_56139;
var ex56143 = (state_56139__$1[(2)]);
var statearr_56146_56161 = state_56139__$1;
(statearr_56146_56161[(5)] = ex56143);


if((ex56143 instanceof Error)){
var statearr_56147_56162 = state_56139__$1;
(statearr_56147_56162[(1)] = (4));

(statearr_56147_56162[(5)] = null);

} else {
throw ex56143;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56140 === (6))){
var inst_56117 = (state_56139[(2)]);
var inst_56118 = fluree.db.util.async.throw_err.call(null,inst_56117);
var inst_56119 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._LT__EQ_,inst_56118);
var inst_56120 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56121 = [inst_56118];
var inst_56122 = (new cljs.core.PersistentVector(null,1,(5),inst_56120,inst_56121,null));
var inst_56123 = cljs.core.count.call(null,inst_56122);
var inst_56124 = ((9) + inst_56123);
var inst_56125 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56126 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56127 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56128 = [inst_56118];
var inst_56129 = (new cljs.core.PersistentVector(null,1,(5),inst_56127,inst_56128,null));
var inst_56130 = ["<=",inst_56129,inst_56119];
var inst_56131 = cljs.core.PersistentHashMap.fromArrays(inst_56126,inst_56130);
var inst_56132 = [inst_56131,inst_56124];
var inst_56133 = (new cljs.core.PersistentVector(null,2,(5),inst_56125,inst_56132,null));
var inst_56134 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56133);
var _ = (function (){var statearr_56148 = state_56139;
(statearr_56148[(4)] = cljs.core.rest.call(null,(state_56139[(4)])));

return statearr_56148;
})();
var state_56139__$1 = (function (){var statearr_56149 = state_56139;
(statearr_56149[(7)] = inst_56134);

return statearr_56149;
})();
var statearr_56150_56163 = state_56139__$1;
(statearr_56150_56163[(2)] = inst_56119);

(statearr_56150_56163[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56151 = [null,null,null,null,null,null,null,null];
(statearr_56151[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56151[(1)] = (1));

return statearr_56151;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56139){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_56139);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56152){var ex__2882__auto__ = e56152;
var statearr_56153_56164 = state_56139;
(statearr_56153_56164[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_56139[(4)]))){
var statearr_56154_56165 = state_56139;
(statearr_56154_56165[(1)] = cljs.core.first.call(null,(state_56139[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56166 = state_56139;
state_56139 = G__56166;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56139){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56155 = f__2902__auto__.call(null);
(statearr_56155[(6)] = c__2901__auto__);

return statearr_56155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq56107){
var G__56108 = cljs.core.first.call(null,seq56107);
var seq56107__$1 = cljs.core.next.call(null,seq56107);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56108,seq56107__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56216 = arguments.length;
var i__4737__auto___56217 = (0);
while(true){
if((i__4737__auto___56217 < len__4736__auto___56216)){
args__4742__auto__.push((arguments[i__4737__auto___56217]));

var G__56218 = (i__4737__auto___56217 + (1));
i__4737__auto___56217 = G__56218;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56199){
var state_val_56200 = (state_56199[(1)]);
if((state_val_56200 === (1))){
var state_56199__$1 = state_56199;
var statearr_56201_56219 = state_56199__$1;
(statearr_56201_56219[(2)] = null);

(statearr_56201_56219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56200 === (2))){
var _ = (function (){var statearr_56202 = state_56199;
(statearr_56202[(4)] = cljs.core.cons.call(null,(5),(state_56199[(4)])));

return statearr_56202;
})();
var inst_56175 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56199__$1 = state_56199;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56199__$1,(6),inst_56175);
} else {
if((state_val_56200 === (3))){
var inst_56197 = (state_56199[(2)]);
var state_56199__$1 = state_56199;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56199__$1,inst_56197);
} else {
if((state_val_56200 === (4))){
var inst_56169 = (state_56199[(2)]);
var state_56199__$1 = state_56199;
var statearr_56204_56220 = state_56199__$1;
(statearr_56204_56220[(2)] = inst_56169);

(statearr_56204_56220[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56200 === (5))){
var _ = (function (){var statearr_56205 = state_56199;
(statearr_56205[(4)] = cljs.core.rest.call(null,(state_56199[(4)])));

return statearr_56205;
})();
var state_56199__$1 = state_56199;
var ex56203 = (state_56199__$1[(2)]);
var statearr_56206_56221 = state_56199__$1;
(statearr_56206_56221[(5)] = ex56203);


if((ex56203 instanceof Error)){
var statearr_56207_56222 = state_56199__$1;
(statearr_56207_56222[(1)] = (4));

(statearr_56207_56222[(5)] = null);

} else {
throw ex56203;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56200 === (6))){
var inst_56177 = (state_56199[(2)]);
var inst_56178 = fluree.db.util.async.throw_err.call(null,inst_56177);
var inst_56179 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._GT__EQ_,inst_56178);
var inst_56180 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56181 = [inst_56178];
var inst_56182 = (new cljs.core.PersistentVector(null,1,(5),inst_56180,inst_56181,null));
var inst_56183 = cljs.core.count.call(null,inst_56182);
var inst_56184 = ((9) + inst_56183);
var inst_56185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56186 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56187 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56188 = [inst_56178];
var inst_56189 = (new cljs.core.PersistentVector(null,1,(5),inst_56187,inst_56188,null));
var inst_56190 = [">=",inst_56189,inst_56179];
var inst_56191 = cljs.core.PersistentHashMap.fromArrays(inst_56186,inst_56190);
var inst_56192 = [inst_56191,inst_56184];
var inst_56193 = (new cljs.core.PersistentVector(null,2,(5),inst_56185,inst_56192,null));
var inst_56194 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56193);
var _ = (function (){var statearr_56208 = state_56199;
(statearr_56208[(4)] = cljs.core.rest.call(null,(state_56199[(4)])));

return statearr_56208;
})();
var state_56199__$1 = (function (){var statearr_56209 = state_56199;
(statearr_56209[(7)] = inst_56194);

return statearr_56209;
})();
var statearr_56210_56223 = state_56199__$1;
(statearr_56210_56223[(2)] = inst_56179);

(statearr_56210_56223[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56211 = [null,null,null,null,null,null,null,null];
(statearr_56211[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56211[(1)] = (1));

return statearr_56211;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56199){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_56199);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56212){var ex__2882__auto__ = e56212;
var statearr_56213_56224 = state_56199;
(statearr_56213_56224[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_56199[(4)]))){
var statearr_56214_56225 = state_56199;
(statearr_56214_56225[(1)] = cljs.core.first.call(null,(state_56199[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56226 = state_56199;
state_56199 = G__56226;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56199){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56215 = f__2902__auto__.call(null);
(statearr_56215[(6)] = c__2901__auto__);

return statearr_56215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq56167){
var G__56168 = cljs.core.first.call(null,seq56167);
var seq56167__$1 = cljs.core.next.call(null,seq56167);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56168,seq56167__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56276 = arguments.length;
var i__4737__auto___56277 = (0);
while(true){
if((i__4737__auto___56277 < len__4736__auto___56276)){
args__4742__auto__.push((arguments[i__4737__auto___56277]));

var G__56278 = (i__4737__auto___56277 + (1));
i__4737__auto___56277 = G__56278;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56259){
var state_val_56260 = (state_56259[(1)]);
if((state_val_56260 === (1))){
var state_56259__$1 = state_56259;
var statearr_56261_56279 = state_56259__$1;
(statearr_56261_56279[(2)] = null);

(statearr_56261_56279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (2))){
var _ = (function (){var statearr_56262 = state_56259;
(statearr_56262[(4)] = cljs.core.cons.call(null,(5),(state_56259[(4)])));

return statearr_56262;
})();
var inst_56235 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56259__$1 = state_56259;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56259__$1,(6),inst_56235);
} else {
if((state_val_56260 === (3))){
var inst_56257 = (state_56259[(2)]);
var state_56259__$1 = state_56259;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56259__$1,inst_56257);
} else {
if((state_val_56260 === (4))){
var inst_56229 = (state_56259[(2)]);
var state_56259__$1 = state_56259;
var statearr_56264_56280 = state_56259__$1;
(statearr_56264_56280[(2)] = inst_56229);

(statearr_56264_56280[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (5))){
var _ = (function (){var statearr_56265 = state_56259;
(statearr_56265[(4)] = cljs.core.rest.call(null,(state_56259[(4)])));

return statearr_56265;
})();
var state_56259__$1 = state_56259;
var ex56263 = (state_56259__$1[(2)]);
var statearr_56266_56281 = state_56259__$1;
(statearr_56266_56281[(5)] = ex56263);


if((ex56263 instanceof Error)){
var statearr_56267_56282 = state_56259__$1;
(statearr_56267_56282[(1)] = (4));

(statearr_56267_56282[(5)] = null);

} else {
throw ex56263;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56260 === (6))){
var inst_56237 = (state_56259[(2)]);
var inst_56238 = fluree.db.util.async.throw_err.call(null,inst_56237);
var inst_56239 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.not_EQ_,inst_56238);
var inst_56240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56241 = [inst_56238];
var inst_56242 = (new cljs.core.PersistentVector(null,1,(5),inst_56240,inst_56241,null));
var inst_56243 = cljs.core.count.call(null,inst_56242);
var inst_56244 = ((9) + inst_56243);
var inst_56245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56246 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56247 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56248 = [inst_56238];
var inst_56249 = (new cljs.core.PersistentVector(null,1,(5),inst_56247,inst_56248,null));
var inst_56250 = ["not=",inst_56249,inst_56239];
var inst_56251 = cljs.core.PersistentHashMap.fromArrays(inst_56246,inst_56250);
var inst_56252 = [inst_56251,inst_56244];
var inst_56253 = (new cljs.core.PersistentVector(null,2,(5),inst_56245,inst_56252,null));
var inst_56254 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56253);
var _ = (function (){var statearr_56268 = state_56259;
(statearr_56268[(4)] = cljs.core.rest.call(null,(state_56259[(4)])));

return statearr_56268;
})();
var state_56259__$1 = (function (){var statearr_56269 = state_56259;
(statearr_56269[(7)] = inst_56254);

return statearr_56269;
})();
var statearr_56270_56283 = state_56259__$1;
(statearr_56270_56283[(2)] = inst_56239);

(statearr_56270_56283[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56271 = [null,null,null,null,null,null,null,null];
(statearr_56271[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56271[(1)] = (1));

return statearr_56271;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56259){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_56259);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56272){var ex__2882__auto__ = e56272;
var statearr_56273_56284 = state_56259;
(statearr_56273_56284[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_56259[(4)]))){
var statearr_56274_56285 = state_56259;
(statearr_56274_56285[(1)] = cljs.core.first.call(null,(state_56259[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56286 = state_56259;
state_56259 = G__56286;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56259){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56275 = f__2902__auto__.call(null);
(statearr_56275[(6)] = c__2901__auto__);

return statearr_56275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq56227){
var G__56228 = cljs.core.first.call(null,seq56227);
var seq56227__$1 = cljs.core.next.call(null,seq56227);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56228,seq56227__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56336 = arguments.length;
var i__4737__auto___56337 = (0);
while(true){
if((i__4737__auto___56337 < len__4736__auto___56336)){
args__4742__auto__.push((arguments[i__4737__auto___56337]));

var G__56338 = (i__4737__auto___56337 + (1));
i__4737__auto___56337 = G__56338;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56319){
var state_val_56320 = (state_56319[(1)]);
if((state_val_56320 === (1))){
var state_56319__$1 = state_56319;
var statearr_56321_56339 = state_56319__$1;
(statearr_56321_56339[(2)] = null);

(statearr_56321_56339[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56320 === (2))){
var _ = (function (){var statearr_56322 = state_56319;
(statearr_56322[(4)] = cljs.core.cons.call(null,(5),(state_56319[(4)])));

return statearr_56322;
})();
var inst_56295 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56319__$1 = state_56319;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56319__$1,(6),inst_56295);
} else {
if((state_val_56320 === (3))){
var inst_56317 = (state_56319[(2)]);
var state_56319__$1 = state_56319;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56319__$1,inst_56317);
} else {
if((state_val_56320 === (4))){
var inst_56289 = (state_56319[(2)]);
var state_56319__$1 = state_56319;
var statearr_56324_56340 = state_56319__$1;
(statearr_56324_56340[(2)] = inst_56289);

(statearr_56324_56340[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56320 === (5))){
var _ = (function (){var statearr_56325 = state_56319;
(statearr_56325[(4)] = cljs.core.rest.call(null,(state_56319[(4)])));

return statearr_56325;
})();
var state_56319__$1 = state_56319;
var ex56323 = (state_56319__$1[(2)]);
var statearr_56326_56341 = state_56319__$1;
(statearr_56326_56341[(5)] = ex56323);


if((ex56323 instanceof Error)){
var statearr_56327_56342 = state_56319__$1;
(statearr_56327_56342[(1)] = (4));

(statearr_56327_56342[(5)] = null);

} else {
throw ex56323;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56320 === (6))){
var inst_56297 = (state_56319[(2)]);
var inst_56298 = fluree.db.util.async.throw_err.call(null,inst_56297);
var inst_56299 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.max,inst_56298);
var inst_56300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56301 = [inst_56298];
var inst_56302 = (new cljs.core.PersistentVector(null,1,(5),inst_56300,inst_56301,null));
var inst_56303 = cljs.core.count.call(null,inst_56302);
var inst_56304 = ((9) + inst_56303);
var inst_56305 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56306 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56308 = [inst_56298];
var inst_56309 = (new cljs.core.PersistentVector(null,1,(5),inst_56307,inst_56308,null));
var inst_56310 = ["max",inst_56309,inst_56299];
var inst_56311 = cljs.core.PersistentHashMap.fromArrays(inst_56306,inst_56310);
var inst_56312 = [inst_56311,inst_56304];
var inst_56313 = (new cljs.core.PersistentVector(null,2,(5),inst_56305,inst_56312,null));
var inst_56314 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56313);
var _ = (function (){var statearr_56328 = state_56319;
(statearr_56328[(4)] = cljs.core.rest.call(null,(state_56319[(4)])));

return statearr_56328;
})();
var state_56319__$1 = (function (){var statearr_56329 = state_56319;
(statearr_56329[(7)] = inst_56314);

return statearr_56329;
})();
var statearr_56330_56343 = state_56319__$1;
(statearr_56330_56343[(2)] = inst_56299);

(statearr_56330_56343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56331 = [null,null,null,null,null,null,null,null];
(statearr_56331[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56331[(1)] = (1));

return statearr_56331;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56319){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_56319);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56332){var ex__2882__auto__ = e56332;
var statearr_56333_56344 = state_56319;
(statearr_56333_56344[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_56319[(4)]))){
var statearr_56334_56345 = state_56319;
(statearr_56334_56345[(1)] = cljs.core.first.call(null,(state_56319[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56346 = state_56319;
state_56319 = G__56346;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56319){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56335 = f__2902__auto__.call(null);
(statearr_56335[(6)] = c__2901__auto__);

return statearr_56335;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq56287){
var G__56288 = cljs.core.first.call(null,seq56287);
var seq56287__$1 = cljs.core.next.call(null,seq56287);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56288,seq56287__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56396 = arguments.length;
var i__4737__auto___56397 = (0);
while(true){
if((i__4737__auto___56397 < len__4736__auto___56396)){
args__4742__auto__.push((arguments[i__4737__auto___56397]));

var G__56398 = (i__4737__auto___56397 + (1));
i__4737__auto___56397 = G__56398;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56379){
var state_val_56380 = (state_56379[(1)]);
if((state_val_56380 === (1))){
var state_56379__$1 = state_56379;
var statearr_56381_56399 = state_56379__$1;
(statearr_56381_56399[(2)] = null);

(statearr_56381_56399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56380 === (2))){
var _ = (function (){var statearr_56382 = state_56379;
(statearr_56382[(4)] = cljs.core.cons.call(null,(5),(state_56379[(4)])));

return statearr_56382;
})();
var inst_56355 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56379__$1 = state_56379;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56379__$1,(6),inst_56355);
} else {
if((state_val_56380 === (3))){
var inst_56377 = (state_56379[(2)]);
var state_56379__$1 = state_56379;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56379__$1,inst_56377);
} else {
if((state_val_56380 === (4))){
var inst_56349 = (state_56379[(2)]);
var state_56379__$1 = state_56379;
var statearr_56384_56400 = state_56379__$1;
(statearr_56384_56400[(2)] = inst_56349);

(statearr_56384_56400[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56380 === (5))){
var _ = (function (){var statearr_56385 = state_56379;
(statearr_56385[(4)] = cljs.core.rest.call(null,(state_56379[(4)])));

return statearr_56385;
})();
var state_56379__$1 = state_56379;
var ex56383 = (state_56379__$1[(2)]);
var statearr_56386_56401 = state_56379__$1;
(statearr_56386_56401[(5)] = ex56383);


if((ex56383 instanceof Error)){
var statearr_56387_56402 = state_56379__$1;
(statearr_56387_56402[(1)] = (4));

(statearr_56387_56402[(5)] = null);

} else {
throw ex56383;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56380 === (6))){
var inst_56357 = (state_56379[(2)]);
var inst_56358 = fluree.db.util.async.throw_err.call(null,inst_56357);
var inst_56359 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal.min,inst_56358);
var inst_56360 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56361 = [inst_56358];
var inst_56362 = (new cljs.core.PersistentVector(null,1,(5),inst_56360,inst_56361,null));
var inst_56363 = cljs.core.count.call(null,inst_56362);
var inst_56364 = ((9) + inst_56363);
var inst_56365 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56366 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56367 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56368 = [inst_56358];
var inst_56369 = (new cljs.core.PersistentVector(null,1,(5),inst_56367,inst_56368,null));
var inst_56370 = ["min",inst_56369,inst_56359];
var inst_56371 = cljs.core.PersistentHashMap.fromArrays(inst_56366,inst_56370);
var inst_56372 = [inst_56371,inst_56364];
var inst_56373 = (new cljs.core.PersistentVector(null,2,(5),inst_56365,inst_56372,null));
var inst_56374 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56373);
var _ = (function (){var statearr_56388 = state_56379;
(statearr_56388[(4)] = cljs.core.rest.call(null,(state_56379[(4)])));

return statearr_56388;
})();
var state_56379__$1 = (function (){var statearr_56389 = state_56379;
(statearr_56389[(7)] = inst_56374);

return statearr_56389;
})();
var statearr_56390_56403 = state_56379__$1;
(statearr_56390_56403[(2)] = inst_56359);

(statearr_56390_56403[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56391 = [null,null,null,null,null,null,null,null];
(statearr_56391[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56391[(1)] = (1));

return statearr_56391;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56379){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_56379);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56392){var ex__2882__auto__ = e56392;
var statearr_56393_56404 = state_56379;
(statearr_56393_56404[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_56379[(4)]))){
var statearr_56394_56405 = state_56379;
(statearr_56394_56405[(1)] = cljs.core.first.call(null,(state_56379[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56406 = state_56379;
state_56379 = G__56406;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56379){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56379);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56395 = f__2902__auto__.call(null);
(statearr_56395[(6)] = c__2901__auto__);

return statearr_56395;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq56347){
var G__56348 = cljs.core.first.call(null,seq56347);
var seq56347__$1 = cljs.core.next.call(null,seq56347);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56348,seq56347__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__56408 = arguments.length;
switch (G__56408) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56453){
var state_val_56454 = (state_56453[(1)]);
if((state_val_56454 === (7))){
var state_56453__$1 = state_56453;
var statearr_56455_56592 = state_56453__$1;
(statearr_56455_56592[(2)] = query_map);

(statearr_56455_56592[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56454 === (1))){
var state_56453__$1 = state_56453;
var statearr_56456_56593 = state_56453__$1;
(statearr_56456_56593[(2)] = null);

(statearr_56456_56593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56454 === (4))){
var inst_56409 = (state_56453[(2)]);
var state_56453__$1 = state_56453;
var statearr_56457_56594 = state_56453__$1;
(statearr_56457_56594[(2)] = inst_56409);

(statearr_56457_56594[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56454 === (13))){
var inst_56431 = (state_56453[(7)]);
var inst_56435 = (state_56453[(2)]);
var inst_56436 = fluree.db.util.async.throw_err.call(null,inst_56435);
var inst_56437 = cljs.core.nth.call(null,inst_56436,(0),null);
var inst_56438 = cljs.core.nth.call(null,inst_56436,(1),null);
var inst_56439 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56440 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56442 = [inst_56431];
var inst_56443 = (new cljs.core.PersistentVector(null,1,(5),inst_56441,inst_56442,null));
var inst_56444 = ["query",inst_56443,inst_56437];
var inst_56445 = cljs.core.PersistentHashMap.fromArrays(inst_56440,inst_56444);
var inst_56446 = [inst_56445,inst_56438];
var inst_56447 = (new cljs.core.PersistentVector(null,2,(5),inst_56439,inst_56446,null));
var inst_56448 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56447);
var _ = (function (){var statearr_56458 = state_56453;
(statearr_56458[(4)] = cljs.core.rest.call(null,(state_56453[(4)])));

return statearr_56458;
})();
var state_56453__$1 = (function (){var statearr_56459 = state_56453;
(statearr_56459[(8)] = inst_56448);

return statearr_56459;
})();
var statearr_56460_56595 = state_56453__$1;
(statearr_56460_56595[(2)] = inst_56437);

(statearr_56460_56595[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56454 === (6))){
var state_56453__$1 = state_56453;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56453__$1,(9),query_map);
} else {
if((state_val_56454 === (3))){
var inst_56451 = (state_56453[(2)]);
var state_56453__$1 = state_56453;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56453__$1,inst_56451);
} else {
if((state_val_56454 === (12))){
var inst_56431 = (state_56453[(7)]);
var inst_56431__$1 = (state_56453[(2)]);
var inst_56432 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56433 = fluree.db.dbfunctions.internal.query.call(null,inst_56432,inst_56431__$1);
var state_56453__$1 = (function (){var statearr_56461 = state_56453;
(statearr_56461[(7)] = inst_56431__$1);

return statearr_56461;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56453__$1,(13),inst_56433);
} else {
if((state_val_56454 === (2))){
var _ = (function (){var statearr_56462 = state_56453;
(statearr_56462[(4)] = cljs.core.cons.call(null,(5),(state_56453[(4)])));

return statearr_56462;
})();
var inst_56418 = fluree.db.util.async.channel_QMARK_.call(null,query_map);
var state_56453__$1 = state_56453;
if(inst_56418){
var statearr_56463_56596 = state_56453__$1;
(statearr_56463_56596[(1)] = (6));

} else {
var statearr_56464_56597 = state_56453__$1;
(statearr_56464_56597[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56454 === (11))){
var inst_56425 = (state_56453[(9)]);
var state_56453__$1 = state_56453;
var statearr_56466_56598 = state_56453__$1;
(statearr_56466_56598[(2)] = inst_56425);

(statearr_56466_56598[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56454 === (9))){
var inst_56421 = (state_56453[(2)]);
var inst_56422 = fluree.db.util.async.throw_err.call(null,inst_56421);
var state_56453__$1 = state_56453;
var statearr_56467_56599 = state_56453__$1;
(statearr_56467_56599[(2)] = inst_56422);

(statearr_56467_56599[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56454 === (5))){
var _ = (function (){var statearr_56468 = state_56453;
(statearr_56468[(4)] = cljs.core.rest.call(null,(state_56453[(4)])));

return statearr_56468;
})();
var state_56453__$1 = state_56453;
var ex56465 = (state_56453__$1[(2)]);
var statearr_56469_56600 = state_56453__$1;
(statearr_56469_56600[(5)] = ex56465);


if((ex56465 instanceof Error)){
var statearr_56470_56601 = state_56453__$1;
(statearr_56470_56601[(1)] = (4));

(statearr_56470_56601[(5)] = null);

} else {
throw ex56465;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56454 === (10))){
var inst_56425 = (state_56453[(9)]);
var inst_56428 = fluree.db.util.json.parse.call(null,inst_56425);
var state_56453__$1 = state_56453;
var statearr_56471_56602 = state_56453__$1;
(statearr_56471_56602[(2)] = inst_56428);

(statearr_56471_56602[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56454 === (8))){
var inst_56425 = (state_56453[(9)]);
var inst_56425__$1 = (state_56453[(2)]);
var inst_56426 = typeof inst_56425__$1 === 'string';
var state_56453__$1 = (function (){var statearr_56472 = state_56453;
(statearr_56472[(9)] = inst_56425__$1);

return statearr_56472;
})();
if(cljs.core.truth_(inst_56426)){
var statearr_56473_56603 = state_56453__$1;
(statearr_56473_56603[(1)] = (10));

} else {
var statearr_56474_56604 = state_56453__$1;
(statearr_56474_56604[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56475 = [null,null,null,null,null,null,null,null,null,null];
(statearr_56475[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56475[(1)] = (1));

return statearr_56475;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56453){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_56453);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56476){var ex__2882__auto__ = e56476;
var statearr_56477_56605 = state_56453;
(statearr_56477_56605[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_56453[(4)]))){
var statearr_56478_56606 = state_56453;
(statearr_56478_56606[(1)] = cljs.core.first.call(null,(state_56453[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56607 = state_56453;
state_56453 = G__56607;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56453){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56453);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56479 = f__2902__auto__.call(null);
(statearr_56479[(6)] = c__2901__auto__);

return statearr_56479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56550){
var state_val_56551 = (state_56550[(1)]);
if((state_val_56551 === (7))){
var state_56550__$1 = state_56550;
var statearr_56552_56608 = state_56550__$1;
(statearr_56552_56608[(2)] = select);

(statearr_56552_56608[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56551 === (20))){
var inst_56520 = (state_56550[(2)]);
var inst_56521 = fluree.db.util.async.channel_QMARK_.call(null,limit);
var state_56550__$1 = (function (){var statearr_56553 = state_56550;
(statearr_56553[(7)] = inst_56520);

return statearr_56553;
})();
if(inst_56521){
var statearr_56554_56609 = state_56550__$1;
(statearr_56554_56609[(1)] = (22));

} else {
var statearr_56555_56610 = state_56550__$1;
(statearr_56555_56610[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56551 === (1))){
var state_56550__$1 = state_56550;
var statearr_56556_56611 = state_56550__$1;
(statearr_56556_56611[(2)] = null);

(statearr_56556_56611[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56551 === (24))){
var inst_56520 = (state_56550[(7)]);
var inst_56496 = (state_56550[(8)]);
var inst_56504 = (state_56550[(9)]);
var inst_56512 = (state_56550[(10)]);
var inst_56528 = (state_56550[(2)]);
var inst_56529 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56530 = fluree.db.dbfunctions.internal.query.call(null,inst_56529,inst_56496,inst_56504,inst_56512,inst_56520,inst_56528);
var state_56550__$1 = state_56550;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56550__$1,(26),inst_56530);
} else {
if((state_val_56551 === (4))){
var inst_56480 = (state_56550[(2)]);
var state_56550__$1 = state_56550;
var statearr_56557_56612 = state_56550__$1;
(statearr_56557_56612[(2)] = inst_56480);

(statearr_56557_56612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56551 === (15))){
var state_56550__$1 = state_56550;
var statearr_56558_56613 = state_56550__$1;
(statearr_56558_56613[(2)] = where);

(statearr_56558_56613[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56551 === (21))){
var inst_56516 = (state_56550[(2)]);
var inst_56517 = fluree.db.util.async.throw_err.call(null,inst_56516);
var state_56550__$1 = state_56550;
var statearr_56559_56614 = state_56550__$1;
(statearr_56559_56614[(2)] = inst_56517);

(statearr_56559_56614[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56551 === (13))){
var inst_56500 = (state_56550[(2)]);
var inst_56501 = fluree.db.util.async.throw_err.call(null,inst_56500);
var state_56550__$1 = state_56550;
var statearr_56560_56615 = state_56550__$1;
(statearr_56560_56615[(2)] = inst_56501);

(statearr_56560_56615[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56551 === (22))){
var state_56550__$1 = state_56550;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56550__$1,(25),limit);
} else {
if((state_val_56551 === (6))){
var state_56550__$1 = state_56550;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56550__$1,(9),select);
} else {
if((state_val_56551 === (25))){
var inst_56524 = (state_56550[(2)]);
var inst_56525 = fluree.db.util.async.throw_err.call(null,inst_56524);
var state_56550__$1 = state_56550;
var statearr_56561_56616 = state_56550__$1;
(statearr_56561_56616[(2)] = inst_56525);

(statearr_56561_56616[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56551 === (17))){
var inst_56508 = (state_56550[(2)]);
var inst_56509 = fluree.db.util.async.throw_err.call(null,inst_56508);
var state_56550__$1 = state_56550;
var statearr_56562_56617 = state_56550__$1;
(statearr_56562_56617[(2)] = inst_56509);

(statearr_56562_56617[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56551 === (3))){
var inst_56548 = (state_56550[(2)]);
var state_56550__$1 = state_56550;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56550__$1,inst_56548);
} else {
if((state_val_56551 === (12))){
var inst_56504 = (state_56550[(2)]);
var inst_56505 = fluree.db.util.async.channel_QMARK_.call(null,where);
var state_56550__$1 = (function (){var statearr_56563 = state_56550;
(statearr_56563[(9)] = inst_56504);

return statearr_56563;
})();
if(inst_56505){
var statearr_56564_56618 = state_56550__$1;
(statearr_56564_56618[(1)] = (14));

} else {
var statearr_56565_56619 = state_56550__$1;
(statearr_56565_56619[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56551 === (2))){
var _ = (function (){var statearr_56566 = state_56550;
(statearr_56566[(4)] = cljs.core.cons.call(null,(5),(state_56550[(4)])));

return statearr_56566;
})();
var inst_56489 = fluree.db.util.async.channel_QMARK_.call(null,select);
var state_56550__$1 = state_56550;
if(inst_56489){
var statearr_56567_56620 = state_56550__$1;
(statearr_56567_56620[(1)] = (6));

} else {
var statearr_56568_56621 = state_56550__$1;
(statearr_56568_56621[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56551 === (23))){
var state_56550__$1 = state_56550;
var statearr_56569_56622 = state_56550__$1;
(statearr_56569_56622[(2)] = limit);

(statearr_56569_56622[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56551 === (19))){
var state_56550__$1 = state_56550;
var statearr_56570_56623 = state_56550__$1;
(statearr_56570_56623[(2)] = block);

(statearr_56570_56623[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56551 === (11))){
var state_56550__$1 = state_56550;
var statearr_56572_56624 = state_56550__$1;
(statearr_56572_56624[(2)] = from);

(statearr_56572_56624[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56551 === (9))){
var inst_56492 = (state_56550[(2)]);
var inst_56493 = fluree.db.util.async.throw_err.call(null,inst_56492);
var state_56550__$1 = state_56550;
var statearr_56573_56625 = state_56550__$1;
(statearr_56573_56625[(2)] = inst_56493);

(statearr_56573_56625[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56551 === (5))){
var _ = (function (){var statearr_56574 = state_56550;
(statearr_56574[(4)] = cljs.core.rest.call(null,(state_56550[(4)])));

return statearr_56574;
})();
var state_56550__$1 = state_56550;
var ex56571 = (state_56550__$1[(2)]);
var statearr_56575_56626 = state_56550__$1;
(statearr_56575_56626[(5)] = ex56571);


if((ex56571 instanceof Error)){
var statearr_56576_56627 = state_56550__$1;
(statearr_56576_56627[(1)] = (4));

(statearr_56576_56627[(5)] = null);

} else {
throw ex56571;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56551 === (14))){
var state_56550__$1 = state_56550;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56550__$1,(17),where);
} else {
if((state_val_56551 === (26))){
var inst_56520 = (state_56550[(7)]);
var inst_56496 = (state_56550[(8)]);
var inst_56504 = (state_56550[(9)]);
var inst_56512 = (state_56550[(10)]);
var inst_56532 = (state_56550[(2)]);
var inst_56533 = fluree.db.util.async.throw_err.call(null,inst_56532);
var inst_56534 = cljs.core.nth.call(null,inst_56533,(0),null);
var inst_56535 = cljs.core.nth.call(null,inst_56533,(1),null);
var inst_56536 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56537 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56538 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56539 = [inst_56496,inst_56504,inst_56512,inst_56520];
var inst_56540 = (new cljs.core.PersistentVector(null,4,(5),inst_56538,inst_56539,null));
var inst_56541 = ["query",inst_56540,inst_56534];
var inst_56542 = cljs.core.PersistentHashMap.fromArrays(inst_56537,inst_56541);
var inst_56543 = [inst_56542,inst_56535];
var inst_56544 = (new cljs.core.PersistentVector(null,2,(5),inst_56536,inst_56543,null));
var inst_56545 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56544);
var _ = (function (){var statearr_56577 = state_56550;
(statearr_56577[(4)] = cljs.core.rest.call(null,(state_56550[(4)])));

return statearr_56577;
})();
var state_56550__$1 = (function (){var statearr_56578 = state_56550;
(statearr_56578[(11)] = inst_56545);

return statearr_56578;
})();
var statearr_56579_56628 = state_56550__$1;
(statearr_56579_56628[(2)] = inst_56534);

(statearr_56579_56628[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56551 === (16))){
var inst_56512 = (state_56550[(2)]);
var inst_56513 = fluree.db.util.async.channel_QMARK_.call(null,block);
var state_56550__$1 = (function (){var statearr_56580 = state_56550;
(statearr_56580[(10)] = inst_56512);

return statearr_56580;
})();
if(inst_56513){
var statearr_56581_56629 = state_56550__$1;
(statearr_56581_56629[(1)] = (18));

} else {
var statearr_56582_56630 = state_56550__$1;
(statearr_56582_56630[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56551 === (10))){
var state_56550__$1 = state_56550;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56550__$1,(13),from);
} else {
if((state_val_56551 === (18))){
var state_56550__$1 = state_56550;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56550__$1,(21),block);
} else {
if((state_val_56551 === (8))){
var inst_56496 = (state_56550[(2)]);
var inst_56497 = fluree.db.util.async.channel_QMARK_.call(null,from);
var state_56550__$1 = (function (){var statearr_56583 = state_56550;
(statearr_56583[(8)] = inst_56496);

return statearr_56583;
})();
if(inst_56497){
var statearr_56584_56631 = state_56550__$1;
(statearr_56584_56631[(1)] = (10));

} else {
var statearr_56585_56632 = state_56550__$1;
(statearr_56585_56632[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56586 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56586[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56586[(1)] = (1));

return statearr_56586;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56550){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_56550);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56587){var ex__2882__auto__ = e56587;
var statearr_56588_56633 = state_56550;
(statearr_56588_56633[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_56550[(4)]))){
var statearr_56589_56634 = state_56550;
(statearr_56589_56634[(1)] = cljs.core.first.call(null,(state_56550[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56635 = state_56550;
state_56550 = G__56635;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56550){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56590 = f__2902__auto__.call(null);
(statearr_56590[(6)] = c__2901__auto__);

return statearr_56590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56691){
var state_val_56692 = (state_56691[(1)]);
if((state_val_56692 === (7))){
var state_56691__$1 = state_56691;
var statearr_56693_56724 = state_56691__$1;
(statearr_56693_56724[(2)] = startSubject);

(statearr_56693_56724[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56692 === (1))){
var state_56691__$1 = state_56691;
var statearr_56694_56725 = state_56691__$1;
(statearr_56694_56725[(2)] = null);

(statearr_56694_56725[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56692 === (4))){
var inst_56636 = (state_56691[(2)]);
var state_56691__$1 = state_56691;
var statearr_56695_56726 = state_56691__$1;
(statearr_56695_56726[(2)] = inst_56636);

(statearr_56695_56726[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56692 === (15))){
var inst_56668 = (state_56691[(2)]);
var inst_56669 = fluree.db.util.async.throw_err.call(null,inst_56668);
var inst_56670 = cljs.core.nth.call(null,inst_56669,(0),null);
var inst_56671 = cljs.core.nth.call(null,inst_56669,(1),null);
var inst_56672 = cljs.core.empty_QMARK_.call(null,inst_56670);
var state_56691__$1 = (function (){var statearr_56696 = state_56691;
(statearr_56696[(7)] = inst_56671);

return statearr_56696;
})();
if(inst_56672){
var statearr_56697_56727 = state_56691__$1;
(statearr_56697_56727[(1)] = (16));

} else {
var statearr_56698_56728 = state_56691__$1;
(statearr_56698_56728[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56692 === (13))){
var inst_56664 = (state_56691[(8)]);
var inst_56656 = (state_56691[(9)]);
var inst_56652 = (state_56691[(10)]);
var inst_56664__$1 = (state_56691[(2)]);
var inst_56665 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56666 = fluree.db.dbfunctions.internal.relationship_QMARK_.call(null,inst_56665,inst_56652,inst_56656,inst_56664__$1);
var state_56691__$1 = (function (){var statearr_56699 = state_56691;
(statearr_56699[(8)] = inst_56664__$1);

return statearr_56699;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56691__$1,(15),inst_56666);
} else {
if((state_val_56692 === (6))){
var state_56691__$1 = state_56691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56691__$1,(9),startSubject);
} else {
if((state_val_56692 === (17))){
var state_56691__$1 = state_56691;
var statearr_56700_56729 = state_56691__$1;
(statearr_56700_56729[(2)] = true);

(statearr_56700_56729[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56692 === (3))){
var inst_56689 = (state_56691[(2)]);
var state_56691__$1 = state_56691;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56691__$1,inst_56689);
} else {
if((state_val_56692 === (12))){
var state_56691__$1 = state_56691;
var statearr_56701_56730 = state_56691__$1;
(statearr_56701_56730[(2)] = endSubject);

(statearr_56701_56730[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56692 === (2))){
var _ = (function (){var statearr_56702 = state_56691;
(statearr_56702[(4)] = cljs.core.cons.call(null,(5),(state_56691[(4)])));

return statearr_56702;
})();
var inst_56645 = fluree.db.util.async.channel_QMARK_.call(null,startSubject);
var state_56691__$1 = state_56691;
if(inst_56645){
var statearr_56703_56731 = state_56691__$1;
(statearr_56703_56731[(1)] = (6));

} else {
var statearr_56704_56732 = state_56691__$1;
(statearr_56704_56732[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56692 === (11))){
var state_56691__$1 = state_56691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56691__$1,(14),endSubject);
} else {
if((state_val_56692 === (9))){
var inst_56648 = (state_56691[(2)]);
var inst_56649 = fluree.db.util.async.throw_err.call(null,inst_56648);
var state_56691__$1 = state_56691;
var statearr_56706_56733 = state_56691__$1;
(statearr_56706_56733[(2)] = inst_56649);

(statearr_56706_56733[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56692 === (5))){
var _ = (function (){var statearr_56707 = state_56691;
(statearr_56707[(4)] = cljs.core.rest.call(null,(state_56691[(4)])));

return statearr_56707;
})();
var state_56691__$1 = state_56691;
var ex56705 = (state_56691__$1[(2)]);
var statearr_56708_56734 = state_56691__$1;
(statearr_56708_56734[(5)] = ex56705);


if((ex56705 instanceof Error)){
var statearr_56709_56735 = state_56691__$1;
(statearr_56709_56735[(1)] = (4));

(statearr_56709_56735[(5)] = null);

} else {
throw ex56705;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56692 === (14))){
var inst_56660 = (state_56691[(2)]);
var inst_56661 = fluree.db.util.async.throw_err.call(null,inst_56660);
var state_56691__$1 = state_56691;
var statearr_56710_56736 = state_56691__$1;
(statearr_56710_56736[(2)] = inst_56661);

(statearr_56710_56736[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56692 === (16))){
var state_56691__$1 = state_56691;
var statearr_56711_56737 = state_56691__$1;
(statearr_56711_56737[(2)] = false);

(statearr_56711_56737[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56692 === (10))){
var inst_56655 = (state_56691[(2)]);
var inst_56656 = fluree.db.util.async.throw_err.call(null,inst_56655);
var inst_56657 = fluree.db.util.async.channel_QMARK_.call(null,endSubject);
var state_56691__$1 = (function (){var statearr_56712 = state_56691;
(statearr_56712[(9)] = inst_56656);

return statearr_56712;
})();
if(inst_56657){
var statearr_56713_56738 = state_56691__$1;
(statearr_56713_56738[(1)] = (11));

} else {
var statearr_56714_56739 = state_56691__$1;
(statearr_56714_56739[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56692 === (18))){
var inst_56664 = (state_56691[(8)]);
var inst_56656 = (state_56691[(9)]);
var inst_56652 = (state_56691[(10)]);
var inst_56671 = (state_56691[(7)]);
var inst_56676 = (state_56691[(2)]);
var inst_56677 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56678 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56680 = [inst_56652,inst_56656,inst_56664];
var inst_56681 = (new cljs.core.PersistentVector(null,3,(5),inst_56679,inst_56680,null));
var inst_56682 = ["relationship?",inst_56681,inst_56676];
var inst_56683 = cljs.core.PersistentHashMap.fromArrays(inst_56678,inst_56682);
var inst_56684 = [inst_56683,inst_56671];
var inst_56685 = (new cljs.core.PersistentVector(null,2,(5),inst_56677,inst_56684,null));
var inst_56686 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56685);
var _ = (function (){var statearr_56715 = state_56691;
(statearr_56715[(4)] = cljs.core.rest.call(null,(state_56691[(4)])));

return statearr_56715;
})();
var state_56691__$1 = (function (){var statearr_56716 = state_56691;
(statearr_56716[(11)] = inst_56686);

return statearr_56716;
})();
var statearr_56717_56740 = state_56691__$1;
(statearr_56717_56740[(2)] = inst_56676);

(statearr_56717_56740[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56692 === (8))){
var inst_56652 = (state_56691[(2)]);
var inst_56653 = fluree.db.dbfunctions.fns.coerce_args.call(null,path);
var state_56691__$1 = (function (){var statearr_56718 = state_56691;
(statearr_56718[(10)] = inst_56652);

return statearr_56718;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56691__$1,(10),inst_56653);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto____0 = (function (){
var statearr_56719 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_56719[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto__);

(statearr_56719[(1)] = (1));

return statearr_56719;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto____1 = (function (state_56691){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_56691);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56720){var ex__2882__auto__ = e56720;
var statearr_56721_56741 = state_56691;
(statearr_56721_56741[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_56691[(4)]))){
var statearr_56722_56742 = state_56691;
(statearr_56722_56742[(1)] = cljs.core.first.call(null,(state_56691[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56743 = state_56691;
state_56691 = G__56743;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto__ = function(state_56691){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto____1.call(this,state_56691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56723 = f__2902__auto__.call(null);
(statearr_56723[(6)] = c__2901__auto__);

return statearr_56723;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56780){
var state_val_56781 = (state_56780[(1)]);
if((state_val_56781 === (7))){
var state_56780__$1 = state_56780;
var statearr_56782_56802 = state_56780__$1;
(statearr_56782_56802[(2)] = pred_name);

(statearr_56782_56802[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56781 === (1))){
var state_56780__$1 = state_56780;
var statearr_56783_56803 = state_56780__$1;
(statearr_56783_56803[(2)] = null);

(statearr_56783_56803[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56781 === (4))){
var inst_56744 = (state_56780[(2)]);
var state_56780__$1 = state_56780;
var statearr_56784_56804 = state_56780__$1;
(statearr_56784_56804[(2)] = inst_56744);

(statearr_56784_56804[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56781 === (6))){
var state_56780__$1 = state_56780;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56780__$1,(9),pred_name);
} else {
if((state_val_56781 === (3))){
var inst_56778 = (state_56780[(2)]);
var state_56780__$1 = state_56780;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56780__$1,inst_56778);
} else {
if((state_val_56781 === (2))){
var _ = (function (){var statearr_56786 = state_56780;
(statearr_56786[(4)] = cljs.core.cons.call(null,(5),(state_56780[(4)])));

return statearr_56786;
})();
var inst_56753 = fluree.db.util.async.channel_QMARK_.call(null,pred_name);
var state_56780__$1 = state_56780;
if(inst_56753){
var statearr_56787_56805 = state_56780__$1;
(statearr_56787_56805[(1)] = (6));

} else {
var statearr_56788_56806 = state_56780__$1;
(statearr_56788_56806[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56781 === (9))){
var inst_56756 = (state_56780[(2)]);
var inst_56757 = fluree.db.util.async.throw_err.call(null,inst_56756);
var state_56780__$1 = state_56780;
var statearr_56789_56807 = state_56780__$1;
(statearr_56789_56807[(2)] = inst_56757);

(statearr_56789_56807[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56781 === (5))){
var _ = (function (){var statearr_56790 = state_56780;
(statearr_56790[(4)] = cljs.core.rest.call(null,(state_56780[(4)])));

return statearr_56790;
})();
var state_56780__$1 = state_56780;
var ex56785 = (state_56780__$1[(2)]);
var statearr_56791_56808 = state_56780__$1;
(statearr_56791_56808[(5)] = ex56785);


if((ex56785 instanceof Error)){
var statearr_56792_56809 = state_56780__$1;
(statearr_56792_56809[(1)] = (4));

(statearr_56792_56809[(5)] = null);

} else {
throw ex56785;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56781 === (10))){
var inst_56760 = (state_56780[(7)]);
var inst_56764 = (state_56780[(2)]);
var inst_56765 = fluree.db.util.async.throw_err.call(null,inst_56764);
var inst_56766 = cljs.core.nth.call(null,inst_56765,(0),null);
var inst_56767 = cljs.core.nth.call(null,inst_56765,(1),null);
var inst_56768 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56769 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56770 = ["max-pred-val",inst_56760,inst_56766];
var inst_56771 = cljs.core.PersistentHashMap.fromArrays(inst_56769,inst_56770);
var inst_56772 = (inst_56767 + (10));
var inst_56773 = [inst_56771,inst_56772];
var inst_56774 = (new cljs.core.PersistentVector(null,2,(5),inst_56768,inst_56773,null));
var inst_56775 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56774);
var _ = (function (){var statearr_56793 = state_56780;
(statearr_56793[(4)] = cljs.core.rest.call(null,(state_56780[(4)])));

return statearr_56793;
})();
var state_56780__$1 = (function (){var statearr_56794 = state_56780;
(statearr_56794[(8)] = inst_56775);

return statearr_56794;
})();
var statearr_56795_56810 = state_56780__$1;
(statearr_56795_56810[(2)] = inst_56766);

(statearr_56795_56810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56781 === (8))){
var inst_56760 = (state_56780[(7)]);
var inst_56760__$1 = (state_56780[(2)]);
var inst_56761 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_56762 = fluree.db.dbfunctions.internal.max_pred_val.call(null,inst_56761,inst_56760__$1,null);
var state_56780__$1 = (function (){var statearr_56796 = state_56780;
(statearr_56796[(7)] = inst_56760__$1);

return statearr_56796;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56780__$1,(10),inst_56762);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto____0 = (function (){
var statearr_56797 = [null,null,null,null,null,null,null,null,null];
(statearr_56797[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto__);

(statearr_56797[(1)] = (1));

return statearr_56797;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto____1 = (function (state_56780){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_56780);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56798){var ex__2882__auto__ = e56798;
var statearr_56799_56811 = state_56780;
(statearr_56799_56811[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_56780[(4)]))){
var statearr_56800_56812 = state_56780;
(statearr_56800_56812[(1)] = cljs.core.first.call(null,(state_56780[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56813 = state_56780;
state_56780 = G__56813;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto__ = function(state_56780){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto____1.call(this,state_56780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56801 = f__2902__auto__.call(null);
(statearr_56801[(6)] = c__2901__auto__);

return statearr_56801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56840){
var state_val_56841 = (state_56840[(1)]);
if((state_val_56841 === (7))){
var state_56840__$1 = state_56840;
var statearr_56842_56861 = state_56840__$1;
(statearr_56842_56861[(2)] = n);

(statearr_56842_56861[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56841 === (1))){
var state_56840__$1 = state_56840;
var statearr_56843_56862 = state_56840__$1;
(statearr_56843_56862[(2)] = null);

(statearr_56843_56862[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56841 === (4))){
var inst_56814 = (state_56840[(2)]);
var state_56840__$1 = state_56840;
var statearr_56844_56863 = state_56840__$1;
(statearr_56844_56863[(2)] = inst_56814);

(statearr_56844_56863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56841 === (6))){
var state_56840__$1 = state_56840;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56840__$1,(9),n);
} else {
if((state_val_56841 === (3))){
var inst_56838 = (state_56840[(2)]);
var state_56840__$1 = state_56840;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56840__$1,inst_56838);
} else {
if((state_val_56841 === (2))){
var _ = (function (){var statearr_56846 = state_56840;
(statearr_56846[(4)] = cljs.core.cons.call(null,(5),(state_56840[(4)])));

return statearr_56846;
})();
var inst_56820 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56840__$1 = state_56840;
if(inst_56820){
var statearr_56847_56864 = state_56840__$1;
(statearr_56847_56864[(1)] = (6));

} else {
var statearr_56848_56865 = state_56840__$1;
(statearr_56848_56865[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56841 === (9))){
var inst_56823 = (state_56840[(2)]);
var inst_56824 = fluree.db.util.async.throw_err.call(null,inst_56823);
var state_56840__$1 = state_56840;
var statearr_56849_56866 = state_56840__$1;
(statearr_56849_56866[(2)] = inst_56824);

(statearr_56849_56866[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56841 === (5))){
var _ = (function (){var statearr_56850 = state_56840;
(statearr_56850[(4)] = cljs.core.rest.call(null,(state_56840[(4)])));

return statearr_56850;
})();
var state_56840__$1 = state_56840;
var ex56845 = (state_56840__$1[(2)]);
var statearr_56851_56867 = state_56840__$1;
(statearr_56851_56867[(5)] = ex56845);


if((ex56845 instanceof Error)){
var statearr_56852_56868 = state_56840__$1;
(statearr_56852_56868[(1)] = (4));

(statearr_56852_56868[(5)] = null);

} else {
throw ex56845;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56841 === (8))){
var inst_56827 = (state_56840[(2)]);
var inst_56828 = fluree.db.dbfunctions.internal.inc.call(null,inst_56827);
var inst_56829 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56830 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56831 = ["inc",inst_56827,inst_56828];
var inst_56832 = cljs.core.PersistentHashMap.fromArrays(inst_56830,inst_56831);
var inst_56833 = [inst_56832,(10)];
var inst_56834 = (new cljs.core.PersistentVector(null,2,(5),inst_56829,inst_56833,null));
var inst_56835 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56834);
var _ = (function (){var statearr_56853 = state_56840;
(statearr_56853[(4)] = cljs.core.rest.call(null,(state_56840[(4)])));

return statearr_56853;
})();
var state_56840__$1 = (function (){var statearr_56854 = state_56840;
(statearr_56854[(7)] = inst_56835);

return statearr_56854;
})();
var statearr_56855_56869 = state_56840__$1;
(statearr_56855_56869[(2)] = inst_56828);

(statearr_56855_56869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto____0 = (function (){
var statearr_56856 = [null,null,null,null,null,null,null,null];
(statearr_56856[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto__);

(statearr_56856[(1)] = (1));

return statearr_56856;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto____1 = (function (state_56840){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_56840);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56857){var ex__2882__auto__ = e56857;
var statearr_56858_56870 = state_56840;
(statearr_56858_56870[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_56840[(4)]))){
var statearr_56859_56871 = state_56840;
(statearr_56859_56871[(1)] = cljs.core.first.call(null,(state_56840[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56872 = state_56840;
state_56840 = G__56872;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto__ = function(state_56840){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto____1.call(this,state_56840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56860 = f__2902__auto__.call(null);
(statearr_56860[(6)] = c__2901__auto__);

return statearr_56860;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56899){
var state_val_56900 = (state_56899[(1)]);
if((state_val_56900 === (7))){
var state_56899__$1 = state_56899;
var statearr_56901_56920 = state_56899__$1;
(statearr_56901_56920[(2)] = n);

(statearr_56901_56920[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56900 === (1))){
var state_56899__$1 = state_56899;
var statearr_56902_56921 = state_56899__$1;
(statearr_56902_56921[(2)] = null);

(statearr_56902_56921[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56900 === (4))){
var inst_56873 = (state_56899[(2)]);
var state_56899__$1 = state_56899;
var statearr_56903_56922 = state_56899__$1;
(statearr_56903_56922[(2)] = inst_56873);

(statearr_56903_56922[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56900 === (6))){
var state_56899__$1 = state_56899;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56899__$1,(9),n);
} else {
if((state_val_56900 === (3))){
var inst_56897 = (state_56899[(2)]);
var state_56899__$1 = state_56899;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56899__$1,inst_56897);
} else {
if((state_val_56900 === (2))){
var _ = (function (){var statearr_56905 = state_56899;
(statearr_56905[(4)] = cljs.core.cons.call(null,(5),(state_56899[(4)])));

return statearr_56905;
})();
var inst_56879 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_56899__$1 = state_56899;
if(inst_56879){
var statearr_56906_56923 = state_56899__$1;
(statearr_56906_56923[(1)] = (6));

} else {
var statearr_56907_56924 = state_56899__$1;
(statearr_56907_56924[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56900 === (9))){
var inst_56882 = (state_56899[(2)]);
var inst_56883 = fluree.db.util.async.throw_err.call(null,inst_56882);
var state_56899__$1 = state_56899;
var statearr_56908_56925 = state_56899__$1;
(statearr_56908_56925[(2)] = inst_56883);

(statearr_56908_56925[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56900 === (5))){
var _ = (function (){var statearr_56909 = state_56899;
(statearr_56909[(4)] = cljs.core.rest.call(null,(state_56899[(4)])));

return statearr_56909;
})();
var state_56899__$1 = state_56899;
var ex56904 = (state_56899__$1[(2)]);
var statearr_56910_56926 = state_56899__$1;
(statearr_56910_56926[(5)] = ex56904);


if((ex56904 instanceof Error)){
var statearr_56911_56927 = state_56899__$1;
(statearr_56911_56927[(1)] = (4));

(statearr_56911_56927[(5)] = null);

} else {
throw ex56904;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56900 === (8))){
var inst_56886 = (state_56899[(2)]);
var inst_56887 = fluree.db.dbfunctions.internal.dec.call(null,inst_56886);
var inst_56888 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56889 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56890 = ["dec",inst_56886,inst_56887];
var inst_56891 = cljs.core.PersistentHashMap.fromArrays(inst_56889,inst_56890);
var inst_56892 = [inst_56891,(10)];
var inst_56893 = (new cljs.core.PersistentVector(null,2,(5),inst_56888,inst_56892,null));
var inst_56894 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56893);
var _ = (function (){var statearr_56912 = state_56899;
(statearr_56912[(4)] = cljs.core.rest.call(null,(state_56899[(4)])));

return statearr_56912;
})();
var state_56899__$1 = (function (){var statearr_56913 = state_56899;
(statearr_56913[(7)] = inst_56894);

return statearr_56913;
})();
var statearr_56914_56928 = state_56899__$1;
(statearr_56914_56928[(2)] = inst_56887);

(statearr_56914_56928[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto____0 = (function (){
var statearr_56915 = [null,null,null,null,null,null,null,null];
(statearr_56915[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto__);

(statearr_56915[(1)] = (1));

return statearr_56915;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto____1 = (function (state_56899){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_56899);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56916){var ex__2882__auto__ = e56916;
var statearr_56917_56929 = state_56899;
(statearr_56917_56929[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_56899[(4)]))){
var statearr_56918_56930 = state_56899;
(statearr_56918_56930[(1)] = cljs.core.first.call(null,(state_56899[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56931 = state_56899;
state_56899 = G__56931;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto__ = function(state_56899){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto____1.call(this,state_56899);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56919 = f__2902__auto__.call(null);
(statearr_56919[(6)] = c__2901__auto__);

return statearr_56919;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli();
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"now",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___56981 = arguments.length;
var i__4737__auto___56982 = (0);
while(true){
if((i__4737__auto___56982 < len__4736__auto___56981)){
args__4742__auto__.push((arguments[i__4737__auto___56982]));

var G__56983 = (i__4737__auto___56982 + (1));
i__4737__auto___56982 = G__56983;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_56964){
var state_val_56965 = (state_56964[(1)]);
if((state_val_56965 === (1))){
var state_56964__$1 = state_56964;
var statearr_56966_56984 = state_56964__$1;
(statearr_56966_56984[(2)] = null);

(statearr_56966_56984[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56965 === (2))){
var _ = (function (){var statearr_56967 = state_56964;
(statearr_56967[(4)] = cljs.core.cons.call(null,(5),(state_56964[(4)])));

return statearr_56967;
})();
var inst_56940 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_56964__$1 = state_56964;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_56964__$1,(6),inst_56940);
} else {
if((state_val_56965 === (3))){
var inst_56962 = (state_56964[(2)]);
var state_56964__$1 = state_56964;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_56964__$1,inst_56962);
} else {
if((state_val_56965 === (4))){
var inst_56934 = (state_56964[(2)]);
var state_56964__$1 = state_56964;
var statearr_56969_56985 = state_56964__$1;
(statearr_56969_56985[(2)] = inst_56934);

(statearr_56969_56985[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56965 === (5))){
var _ = (function (){var statearr_56970 = state_56964;
(statearr_56970[(4)] = cljs.core.rest.call(null,(state_56964[(4)])));

return statearr_56970;
})();
var state_56964__$1 = state_56964;
var ex56968 = (state_56964__$1[(2)]);
var statearr_56971_56986 = state_56964__$1;
(statearr_56971_56986[(5)] = ex56968);


if((ex56968 instanceof Error)){
var statearr_56972_56987 = state_56964__$1;
(statearr_56972_56987[(1)] = (4));

(statearr_56972_56987[(5)] = null);

} else {
throw ex56968;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_56965 === (6))){
var inst_56942 = (state_56964[(2)]);
var inst_56943 = fluree.db.util.async.throw_err.call(null,inst_56942);
var inst_56944 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._PLUS_,inst_56943);
var inst_56945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56946 = [inst_56943];
var inst_56947 = (new cljs.core.PersistentVector(null,1,(5),inst_56945,inst_56946,null));
var inst_56948 = cljs.core.count.call(null,inst_56947);
var inst_56949 = ((9) + inst_56948);
var inst_56950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56951 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_56952 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_56953 = [inst_56943];
var inst_56954 = (new cljs.core.PersistentVector(null,1,(5),inst_56952,inst_56953,null));
var inst_56955 = ["+",inst_56954,inst_56944];
var inst_56956 = cljs.core.PersistentHashMap.fromArrays(inst_56951,inst_56955);
var inst_56957 = [inst_56956,inst_56949];
var inst_56958 = (new cljs.core.PersistentVector(null,2,(5),inst_56950,inst_56957,null));
var inst_56959 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_56958);
var _ = (function (){var statearr_56973 = state_56964;
(statearr_56973[(4)] = cljs.core.rest.call(null,(state_56964[(4)])));

return statearr_56973;
})();
var state_56964__$1 = (function (){var statearr_56974 = state_56964;
(statearr_56974[(7)] = inst_56959);

return statearr_56974;
})();
var statearr_56975_56988 = state_56964__$1;
(statearr_56975_56988[(2)] = inst_56944);

(statearr_56975_56988[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_56976 = [null,null,null,null,null,null,null,null];
(statearr_56976[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_56976[(1)] = (1));

return statearr_56976;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_56964){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_56964);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e56977){var ex__2882__auto__ = e56977;
var statearr_56978_56989 = state_56964;
(statearr_56978_56989[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_56964[(4)]))){
var statearr_56979_56990 = state_56964;
(statearr_56979_56990[(1)] = cljs.core.first.call(null,(state_56964[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__56991 = state_56964;
state_56964 = G__56991;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_56964){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_56964);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_56980 = f__2902__auto__.call(null);
(statearr_56980[(6)] = c__2901__auto__);

return statearr_56980;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq56932){
var G__56933 = cljs.core.first.call(null,seq56932);
var seq56932__$1 = cljs.core.next.call(null,seq56932);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56933,seq56932__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___57041 = arguments.length;
var i__4737__auto___57042 = (0);
while(true){
if((i__4737__auto___57042 < len__4736__auto___57041)){
args__4742__auto__.push((arguments[i__4737__auto___57042]));

var G__57043 = (i__4737__auto___57042 + (1));
i__4737__auto___57042 = G__57043;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57024){
var state_val_57025 = (state_57024[(1)]);
if((state_val_57025 === (1))){
var state_57024__$1 = state_57024;
var statearr_57026_57044 = state_57024__$1;
(statearr_57026_57044[(2)] = null);

(statearr_57026_57044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57025 === (2))){
var _ = (function (){var statearr_57027 = state_57024;
(statearr_57027[(4)] = cljs.core.cons.call(null,(5),(state_57024[(4)])));

return statearr_57027;
})();
var inst_57000 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_57024__$1 = state_57024;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57024__$1,(6),inst_57000);
} else {
if((state_val_57025 === (3))){
var inst_57022 = (state_57024[(2)]);
var state_57024__$1 = state_57024;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57024__$1,inst_57022);
} else {
if((state_val_57025 === (4))){
var inst_56994 = (state_57024[(2)]);
var state_57024__$1 = state_57024;
var statearr_57029_57045 = state_57024__$1;
(statearr_57029_57045[(2)] = inst_56994);

(statearr_57029_57045[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57025 === (5))){
var _ = (function (){var statearr_57030 = state_57024;
(statearr_57030[(4)] = cljs.core.rest.call(null,(state_57024[(4)])));

return statearr_57030;
})();
var state_57024__$1 = state_57024;
var ex57028 = (state_57024__$1[(2)]);
var statearr_57031_57046 = state_57024__$1;
(statearr_57031_57046[(5)] = ex57028);


if((ex57028 instanceof Error)){
var statearr_57032_57047 = state_57024__$1;
(statearr_57032_57047[(1)] = (4));

(statearr_57032_57047[(5)] = null);

} else {
throw ex57028;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57025 === (6))){
var inst_57002 = (state_57024[(2)]);
var inst_57003 = fluree.db.util.async.throw_err.call(null,inst_57002);
var inst_57004 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._,inst_57003);
var inst_57005 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57006 = [inst_57003];
var inst_57007 = (new cljs.core.PersistentVector(null,1,(5),inst_57005,inst_57006,null));
var inst_57008 = cljs.core.count.call(null,inst_57007);
var inst_57009 = ((9) + inst_57008);
var inst_57010 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57011 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57012 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57013 = [inst_57003];
var inst_57014 = (new cljs.core.PersistentVector(null,1,(5),inst_57012,inst_57013,null));
var inst_57015 = ["-",inst_57014,inst_57004];
var inst_57016 = cljs.core.PersistentHashMap.fromArrays(inst_57011,inst_57015);
var inst_57017 = [inst_57016,inst_57009];
var inst_57018 = (new cljs.core.PersistentVector(null,2,(5),inst_57010,inst_57017,null));
var inst_57019 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57018);
var _ = (function (){var statearr_57033 = state_57024;
(statearr_57033[(4)] = cljs.core.rest.call(null,(state_57024[(4)])));

return statearr_57033;
})();
var state_57024__$1 = (function (){var statearr_57034 = state_57024;
(statearr_57034[(7)] = inst_57019);

return statearr_57034;
})();
var statearr_57035_57048 = state_57024__$1;
(statearr_57035_57048[(2)] = inst_57004);

(statearr_57035_57048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_57036 = [null,null,null,null,null,null,null,null];
(statearr_57036[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_57036[(1)] = (1));

return statearr_57036;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_57024){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_57024);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57037){var ex__2882__auto__ = e57037;
var statearr_57038_57049 = state_57024;
(statearr_57038_57049[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_57024[(4)]))){
var statearr_57039_57050 = state_57024;
(statearr_57039_57050[(1)] = cljs.core.first.call(null,(state_57024[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57051 = state_57024;
state_57024 = G__57051;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_57024){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_57024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57040 = f__2902__auto__.call(null);
(statearr_57040[(6)] = c__2901__auto__);

return statearr_57040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq56992){
var G__56993 = cljs.core.first.call(null,seq56992);
var seq56992__$1 = cljs.core.next.call(null,seq56992);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__56993,seq56992__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___57101 = arguments.length;
var i__4737__auto___57102 = (0);
while(true){
if((i__4737__auto___57102 < len__4736__auto___57101)){
args__4742__auto__.push((arguments[i__4737__auto___57102]));

var G__57103 = (i__4737__auto___57102 + (1));
i__4737__auto___57102 = G__57103;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57084){
var state_val_57085 = (state_57084[(1)]);
if((state_val_57085 === (1))){
var state_57084__$1 = state_57084;
var statearr_57086_57104 = state_57084__$1;
(statearr_57086_57104[(2)] = null);

(statearr_57086_57104[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57085 === (2))){
var _ = (function (){var statearr_57087 = state_57084;
(statearr_57087[(4)] = cljs.core.cons.call(null,(5),(state_57084[(4)])));

return statearr_57087;
})();
var inst_57060 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_57084__$1 = state_57084;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57084__$1,(6),inst_57060);
} else {
if((state_val_57085 === (3))){
var inst_57082 = (state_57084[(2)]);
var state_57084__$1 = state_57084;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57084__$1,inst_57082);
} else {
if((state_val_57085 === (4))){
var inst_57054 = (state_57084[(2)]);
var state_57084__$1 = state_57084;
var statearr_57089_57105 = state_57084__$1;
(statearr_57089_57105[(2)] = inst_57054);

(statearr_57089_57105[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57085 === (5))){
var _ = (function (){var statearr_57090 = state_57084;
(statearr_57090[(4)] = cljs.core.rest.call(null,(state_57084[(4)])));

return statearr_57090;
})();
var state_57084__$1 = state_57084;
var ex57088 = (state_57084__$1[(2)]);
var statearr_57091_57106 = state_57084__$1;
(statearr_57091_57106[(5)] = ex57088);


if((ex57088 instanceof Error)){
var statearr_57092_57107 = state_57084__$1;
(statearr_57092_57107[(1)] = (4));

(statearr_57092_57107[(5)] = null);

} else {
throw ex57088;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57085 === (6))){
var inst_57062 = (state_57084[(2)]);
var inst_57063 = fluree.db.util.async.throw_err.call(null,inst_57062);
var inst_57064 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._STAR_,inst_57063);
var inst_57065 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57066 = [inst_57063];
var inst_57067 = (new cljs.core.PersistentVector(null,1,(5),inst_57065,inst_57066,null));
var inst_57068 = cljs.core.count.call(null,inst_57067);
var inst_57069 = ((9) + inst_57068);
var inst_57070 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57071 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57072 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57073 = [inst_57063];
var inst_57074 = (new cljs.core.PersistentVector(null,1,(5),inst_57072,inst_57073,null));
var inst_57075 = ["*",inst_57074,inst_57064];
var inst_57076 = cljs.core.PersistentHashMap.fromArrays(inst_57071,inst_57075);
var inst_57077 = [inst_57076,inst_57069];
var inst_57078 = (new cljs.core.PersistentVector(null,2,(5),inst_57070,inst_57077,null));
var inst_57079 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57078);
var _ = (function (){var statearr_57093 = state_57084;
(statearr_57093[(4)] = cljs.core.rest.call(null,(state_57084[(4)])));

return statearr_57093;
})();
var state_57084__$1 = (function (){var statearr_57094 = state_57084;
(statearr_57094[(7)] = inst_57079);

return statearr_57094;
})();
var statearr_57095_57108 = state_57084__$1;
(statearr_57095_57108[(2)] = inst_57064);

(statearr_57095_57108[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_57096 = [null,null,null,null,null,null,null,null];
(statearr_57096[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_57096[(1)] = (1));

return statearr_57096;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_57084){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_57084);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57097){var ex__2882__auto__ = e57097;
var statearr_57098_57109 = state_57084;
(statearr_57098_57109[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_57084[(4)]))){
var statearr_57099_57110 = state_57084;
(statearr_57099_57110[(1)] = cljs.core.first.call(null,(state_57084[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57111 = state_57084;
state_57084 = G__57111;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_57084){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_57084);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57100 = f__2902__auto__.call(null);
(statearr_57100[(6)] = c__2901__auto__);

return statearr_57100;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq57052){
var G__57053 = cljs.core.first.call(null,seq57052);
var seq57052__$1 = cljs.core.next.call(null,seq57052);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57053,seq57052__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___57161 = arguments.length;
var i__4737__auto___57162 = (0);
while(true){
if((i__4737__auto___57162 < len__4736__auto___57161)){
args__4742__auto__.push((arguments[i__4737__auto___57162]));

var G__57163 = (i__4737__auto___57162 + (1));
i__4737__auto___57162 = G__57163;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57144){
var state_val_57145 = (state_57144[(1)]);
if((state_val_57145 === (1))){
var state_57144__$1 = state_57144;
var statearr_57146_57164 = state_57144__$1;
(statearr_57146_57164[(2)] = null);

(statearr_57146_57164[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57145 === (2))){
var _ = (function (){var statearr_57147 = state_57144;
(statearr_57147[(4)] = cljs.core.cons.call(null,(5),(state_57144[(4)])));

return statearr_57147;
})();
var inst_57120 = fluree.db.dbfunctions.fns.coerce_args.call(null,args);
var state_57144__$1 = state_57144;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57144__$1,(6),inst_57120);
} else {
if((state_val_57145 === (3))){
var inst_57142 = (state_57144[(2)]);
var state_57144__$1 = state_57144;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57144__$1,inst_57142);
} else {
if((state_val_57145 === (4))){
var inst_57114 = (state_57144[(2)]);
var state_57144__$1 = state_57144;
var statearr_57149_57165 = state_57144__$1;
(statearr_57149_57165[(2)] = inst_57114);

(statearr_57149_57165[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57145 === (5))){
var _ = (function (){var statearr_57150 = state_57144;
(statearr_57150[(4)] = cljs.core.rest.call(null,(state_57144[(4)])));

return statearr_57150;
})();
var state_57144__$1 = state_57144;
var ex57148 = (state_57144__$1[(2)]);
var statearr_57151_57166 = state_57144__$1;
(statearr_57151_57166[(5)] = ex57148);


if((ex57148 instanceof Error)){
var statearr_57152_57167 = state_57144__$1;
(statearr_57152_57167[(1)] = (4));

(statearr_57152_57167[(5)] = null);

} else {
throw ex57148;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57145 === (6))){
var inst_57122 = (state_57144[(2)]);
var inst_57123 = fluree.db.util.async.throw_err.call(null,inst_57122);
var inst_57124 = cljs.core.apply.call(null,fluree.db.dbfunctions.internal._SLASH_,inst_57123);
var inst_57125 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57126 = [inst_57123];
var inst_57127 = (new cljs.core.PersistentVector(null,1,(5),inst_57125,inst_57126,null));
var inst_57128 = cljs.core.count.call(null,inst_57127);
var inst_57129 = ((9) + inst_57128);
var inst_57130 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57131 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57133 = [inst_57123];
var inst_57134 = (new cljs.core.PersistentVector(null,1,(5),inst_57132,inst_57133,null));
var inst_57135 = ["/",inst_57134,inst_57124];
var inst_57136 = cljs.core.PersistentHashMap.fromArrays(inst_57131,inst_57135);
var inst_57137 = [inst_57136,inst_57129];
var inst_57138 = (new cljs.core.PersistentVector(null,2,(5),inst_57130,inst_57137,null));
var inst_57139 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57138);
var _ = (function (){var statearr_57153 = state_57144;
(statearr_57153[(4)] = cljs.core.rest.call(null,(state_57144[(4)])));

return statearr_57153;
})();
var state_57144__$1 = (function (){var statearr_57154 = state_57144;
(statearr_57154[(7)] = inst_57139);

return statearr_57154;
})();
var statearr_57155_57168 = state_57144__$1;
(statearr_57155_57168[(2)] = inst_57124);

(statearr_57155_57168[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_57156 = [null,null,null,null,null,null,null,null];
(statearr_57156[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_57156[(1)] = (1));

return statearr_57156;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_57144){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_57144);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57157){var ex__2882__auto__ = e57157;
var statearr_57158_57169 = state_57144;
(statearr_57158_57169[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_57144[(4)]))){
var statearr_57159_57170 = state_57144;
(statearr_57159_57170[(1)] = cljs.core.first.call(null,(state_57144[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57171 = state_57144;
state_57144 = G__57171;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_57144){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_57144);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57160 = f__2902__auto__.call(null);
(statearr_57160[(6)] = c__2901__auto__);

return statearr_57160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq57112){
var G__57113 = cljs.core.first.call(null,seq57112);
var seq57112__$1 = cljs.core.next.call(null,seq57112);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__57113,seq57112__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57209){
var state_val_57210 = (state_57209[(1)]);
if((state_val_57210 === (7))){
var state_57209__$1 = state_57209;
var statearr_57211_57235 = state_57209__$1;
(statearr_57211_57235[(2)] = n);

(statearr_57211_57235[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57210 === (1))){
var state_57209__$1 = state_57209;
var statearr_57212_57236 = state_57209__$1;
(statearr_57212_57236[(2)] = null);

(statearr_57212_57236[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57210 === (4))){
var inst_57172 = (state_57209[(2)]);
var state_57209__$1 = state_57209;
var statearr_57213_57237 = state_57209__$1;
(statearr_57213_57237[(2)] = inst_57172);

(statearr_57213_57237[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57210 === (13))){
var inst_57189 = (state_57209[(2)]);
var inst_57190 = fluree.db.util.async.throw_err.call(null,inst_57189);
var state_57209__$1 = state_57209;
var statearr_57214_57238 = state_57209__$1;
(statearr_57214_57238[(2)] = inst_57190);

(statearr_57214_57238[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57210 === (6))){
var state_57209__$1 = state_57209;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57209__$1,(9),n);
} else {
if((state_val_57210 === (3))){
var inst_57207 = (state_57209[(2)]);
var state_57209__$1 = state_57209;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57209__$1,inst_57207);
} else {
if((state_val_57210 === (12))){
var inst_57185 = (state_57209[(7)]);
var inst_57193 = (state_57209[(2)]);
var inst_57194 = fluree.db.dbfunctions.internal.quot.call(null,inst_57185,inst_57193);
var inst_57195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57196 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57198 = [inst_57185,inst_57193];
var inst_57199 = (new cljs.core.PersistentVector(null,2,(5),inst_57197,inst_57198,null));
var inst_57200 = ["quot",inst_57199,inst_57194];
var inst_57201 = cljs.core.PersistentHashMap.fromArrays(inst_57196,inst_57200);
var inst_57202 = [inst_57201,(2)];
var inst_57203 = (new cljs.core.PersistentVector(null,2,(5),inst_57195,inst_57202,null));
var inst_57204 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57203);
var _ = (function (){var statearr_57215 = state_57209;
(statearr_57215[(4)] = cljs.core.rest.call(null,(state_57209[(4)])));

return statearr_57215;
})();
var state_57209__$1 = (function (){var statearr_57216 = state_57209;
(statearr_57216[(8)] = inst_57204);

return statearr_57216;
})();
var statearr_57217_57239 = state_57209__$1;
(statearr_57217_57239[(2)] = inst_57194);

(statearr_57217_57239[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57210 === (2))){
var _ = (function (){var statearr_57218 = state_57209;
(statearr_57218[(4)] = cljs.core.cons.call(null,(5),(state_57209[(4)])));

return statearr_57218;
})();
var inst_57178 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_57209__$1 = state_57209;
if(inst_57178){
var statearr_57219_57240 = state_57209__$1;
(statearr_57219_57240[(1)] = (6));

} else {
var statearr_57220_57241 = state_57209__$1;
(statearr_57220_57241[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57210 === (11))){
var state_57209__$1 = state_57209;
var statearr_57222_57242 = state_57209__$1;
(statearr_57222_57242[(2)] = d);

(statearr_57222_57242[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57210 === (9))){
var inst_57181 = (state_57209[(2)]);
var inst_57182 = fluree.db.util.async.throw_err.call(null,inst_57181);
var state_57209__$1 = state_57209;
var statearr_57223_57243 = state_57209__$1;
(statearr_57223_57243[(2)] = inst_57182);

(statearr_57223_57243[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57210 === (5))){
var _ = (function (){var statearr_57224 = state_57209;
(statearr_57224[(4)] = cljs.core.rest.call(null,(state_57209[(4)])));

return statearr_57224;
})();
var state_57209__$1 = state_57209;
var ex57221 = (state_57209__$1[(2)]);
var statearr_57225_57244 = state_57209__$1;
(statearr_57225_57244[(5)] = ex57221);


if((ex57221 instanceof Error)){
var statearr_57226_57245 = state_57209__$1;
(statearr_57226_57245[(1)] = (4));

(statearr_57226_57245[(5)] = null);

} else {
throw ex57221;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57210 === (10))){
var state_57209__$1 = state_57209;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57209__$1,(13),d);
} else {
if((state_val_57210 === (8))){
var inst_57185 = (state_57209[(2)]);
var inst_57186 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_57209__$1 = (function (){var statearr_57227 = state_57209;
(statearr_57227[(7)] = inst_57185);

return statearr_57227;
})();
if(inst_57186){
var statearr_57228_57246 = state_57209__$1;
(statearr_57228_57246[(1)] = (10));

} else {
var statearr_57229_57247 = state_57209__$1;
(statearr_57229_57247[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto____0 = (function (){
var statearr_57230 = [null,null,null,null,null,null,null,null,null];
(statearr_57230[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto__);

(statearr_57230[(1)] = (1));

return statearr_57230;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto____1 = (function (state_57209){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_57209);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57231){var ex__2882__auto__ = e57231;
var statearr_57232_57248 = state_57209;
(statearr_57232_57248[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_57209[(4)]))){
var statearr_57233_57249 = state_57209;
(statearr_57233_57249[(1)] = cljs.core.first.call(null,(state_57209[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57250 = state_57209;
state_57209 = G__57250;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto__ = function(state_57209){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto____1.call(this,state_57209);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57234 = f__2902__auto__.call(null);
(statearr_57234[(6)] = c__2901__auto__);

return statearr_57234;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57288){
var state_val_57289 = (state_57288[(1)]);
if((state_val_57289 === (7))){
var state_57288__$1 = state_57288;
var statearr_57290_57314 = state_57288__$1;
(statearr_57290_57314[(2)] = n);

(statearr_57290_57314[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57289 === (1))){
var state_57288__$1 = state_57288;
var statearr_57291_57315 = state_57288__$1;
(statearr_57291_57315[(2)] = null);

(statearr_57291_57315[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57289 === (4))){
var inst_57251 = (state_57288[(2)]);
var state_57288__$1 = state_57288;
var statearr_57292_57316 = state_57288__$1;
(statearr_57292_57316[(2)] = inst_57251);

(statearr_57292_57316[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57289 === (13))){
var inst_57268 = (state_57288[(2)]);
var inst_57269 = fluree.db.util.async.throw_err.call(null,inst_57268);
var state_57288__$1 = state_57288;
var statearr_57293_57317 = state_57288__$1;
(statearr_57293_57317[(2)] = inst_57269);

(statearr_57293_57317[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57289 === (6))){
var state_57288__$1 = state_57288;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57288__$1,(9),n);
} else {
if((state_val_57289 === (3))){
var inst_57286 = (state_57288[(2)]);
var state_57288__$1 = state_57288;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57288__$1,inst_57286);
} else {
if((state_val_57289 === (12))){
var inst_57264 = (state_57288[(7)]);
var inst_57272 = (state_57288[(2)]);
var inst_57273 = fluree.db.dbfunctions.internal.mod.call(null,inst_57264,inst_57272);
var inst_57274 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57275 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57276 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57277 = [inst_57264,inst_57272];
var inst_57278 = (new cljs.core.PersistentVector(null,2,(5),inst_57276,inst_57277,null));
var inst_57279 = ["mod",inst_57278,inst_57273];
var inst_57280 = cljs.core.PersistentHashMap.fromArrays(inst_57275,inst_57279);
var inst_57281 = [inst_57280,(2)];
var inst_57282 = (new cljs.core.PersistentVector(null,2,(5),inst_57274,inst_57281,null));
var inst_57283 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57282);
var _ = (function (){var statearr_57294 = state_57288;
(statearr_57294[(4)] = cljs.core.rest.call(null,(state_57288[(4)])));

return statearr_57294;
})();
var state_57288__$1 = (function (){var statearr_57295 = state_57288;
(statearr_57295[(8)] = inst_57283);

return statearr_57295;
})();
var statearr_57296_57318 = state_57288__$1;
(statearr_57296_57318[(2)] = inst_57273);

(statearr_57296_57318[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57289 === (2))){
var _ = (function (){var statearr_57297 = state_57288;
(statearr_57297[(4)] = cljs.core.cons.call(null,(5),(state_57288[(4)])));

return statearr_57297;
})();
var inst_57257 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_57288__$1 = state_57288;
if(inst_57257){
var statearr_57298_57319 = state_57288__$1;
(statearr_57298_57319[(1)] = (6));

} else {
var statearr_57299_57320 = state_57288__$1;
(statearr_57299_57320[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57289 === (11))){
var state_57288__$1 = state_57288;
var statearr_57301_57321 = state_57288__$1;
(statearr_57301_57321[(2)] = d);

(statearr_57301_57321[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57289 === (9))){
var inst_57260 = (state_57288[(2)]);
var inst_57261 = fluree.db.util.async.throw_err.call(null,inst_57260);
var state_57288__$1 = state_57288;
var statearr_57302_57322 = state_57288__$1;
(statearr_57302_57322[(2)] = inst_57261);

(statearr_57302_57322[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57289 === (5))){
var _ = (function (){var statearr_57303 = state_57288;
(statearr_57303[(4)] = cljs.core.rest.call(null,(state_57288[(4)])));

return statearr_57303;
})();
var state_57288__$1 = state_57288;
var ex57300 = (state_57288__$1[(2)]);
var statearr_57304_57323 = state_57288__$1;
(statearr_57304_57323[(5)] = ex57300);


if((ex57300 instanceof Error)){
var statearr_57305_57324 = state_57288__$1;
(statearr_57305_57324[(1)] = (4));

(statearr_57305_57324[(5)] = null);

} else {
throw ex57300;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57289 === (10))){
var state_57288__$1 = state_57288;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57288__$1,(13),d);
} else {
if((state_val_57289 === (8))){
var inst_57264 = (state_57288[(2)]);
var inst_57265 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_57288__$1 = (function (){var statearr_57306 = state_57288;
(statearr_57306[(7)] = inst_57264);

return statearr_57306;
})();
if(inst_57265){
var statearr_57307_57325 = state_57288__$1;
(statearr_57307_57325[(1)] = (10));

} else {
var statearr_57308_57326 = state_57288__$1;
(statearr_57308_57326[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto____0 = (function (){
var statearr_57309 = [null,null,null,null,null,null,null,null,null];
(statearr_57309[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto__);

(statearr_57309[(1)] = (1));

return statearr_57309;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto____1 = (function (state_57288){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_57288);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57310){var ex__2882__auto__ = e57310;
var statearr_57311_57327 = state_57288;
(statearr_57311_57327[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_57288[(4)]))){
var statearr_57312_57328 = state_57288;
(statearr_57312_57328[(1)] = cljs.core.first.call(null,(state_57288[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57329 = state_57288;
state_57288 = G__57329;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto__ = function(state_57288){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto____1.call(this,state_57288);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57313 = f__2902__auto__.call(null);
(statearr_57313[(6)] = c__2901__auto__);

return statearr_57313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57367){
var state_val_57368 = (state_57367[(1)]);
if((state_val_57368 === (7))){
var state_57367__$1 = state_57367;
var statearr_57369_57393 = state_57367__$1;
(statearr_57369_57393[(2)] = n);

(statearr_57369_57393[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57368 === (1))){
var state_57367__$1 = state_57367;
var statearr_57370_57394 = state_57367__$1;
(statearr_57370_57394[(2)] = null);

(statearr_57370_57394[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57368 === (4))){
var inst_57330 = (state_57367[(2)]);
var state_57367__$1 = state_57367;
var statearr_57371_57395 = state_57367__$1;
(statearr_57371_57395[(2)] = inst_57330);

(statearr_57371_57395[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57368 === (13))){
var inst_57347 = (state_57367[(2)]);
var inst_57348 = fluree.db.util.async.throw_err.call(null,inst_57347);
var state_57367__$1 = state_57367;
var statearr_57372_57396 = state_57367__$1;
(statearr_57372_57396[(2)] = inst_57348);

(statearr_57372_57396[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57368 === (6))){
var state_57367__$1 = state_57367;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57367__$1,(9),n);
} else {
if((state_val_57368 === (3))){
var inst_57365 = (state_57367[(2)]);
var state_57367__$1 = state_57367;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57367__$1,inst_57365);
} else {
if((state_val_57368 === (12))){
var inst_57343 = (state_57367[(7)]);
var inst_57351 = (state_57367[(2)]);
var inst_57352 = fluree.db.dbfunctions.internal.rem.call(null,inst_57343,inst_57351);
var inst_57353 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57354 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57355 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57356 = [inst_57343,inst_57351];
var inst_57357 = (new cljs.core.PersistentVector(null,2,(5),inst_57355,inst_57356,null));
var inst_57358 = ["rem",inst_57357,inst_57352];
var inst_57359 = cljs.core.PersistentHashMap.fromArrays(inst_57354,inst_57358);
var inst_57360 = [inst_57359,(2)];
var inst_57361 = (new cljs.core.PersistentVector(null,2,(5),inst_57353,inst_57360,null));
var inst_57362 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57361);
var _ = (function (){var statearr_57373 = state_57367;
(statearr_57373[(4)] = cljs.core.rest.call(null,(state_57367[(4)])));

return statearr_57373;
})();
var state_57367__$1 = (function (){var statearr_57374 = state_57367;
(statearr_57374[(8)] = inst_57362);

return statearr_57374;
})();
var statearr_57375_57397 = state_57367__$1;
(statearr_57375_57397[(2)] = inst_57352);

(statearr_57375_57397[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57368 === (2))){
var _ = (function (){var statearr_57376 = state_57367;
(statearr_57376[(4)] = cljs.core.cons.call(null,(5),(state_57367[(4)])));

return statearr_57376;
})();
var inst_57336 = fluree.db.util.async.channel_QMARK_.call(null,n);
var state_57367__$1 = state_57367;
if(inst_57336){
var statearr_57377_57398 = state_57367__$1;
(statearr_57377_57398[(1)] = (6));

} else {
var statearr_57378_57399 = state_57367__$1;
(statearr_57378_57399[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57368 === (11))){
var state_57367__$1 = state_57367;
var statearr_57380_57400 = state_57367__$1;
(statearr_57380_57400[(2)] = d);

(statearr_57380_57400[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57368 === (9))){
var inst_57339 = (state_57367[(2)]);
var inst_57340 = fluree.db.util.async.throw_err.call(null,inst_57339);
var state_57367__$1 = state_57367;
var statearr_57381_57401 = state_57367__$1;
(statearr_57381_57401[(2)] = inst_57340);

(statearr_57381_57401[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57368 === (5))){
var _ = (function (){var statearr_57382 = state_57367;
(statearr_57382[(4)] = cljs.core.rest.call(null,(state_57367[(4)])));

return statearr_57382;
})();
var state_57367__$1 = state_57367;
var ex57379 = (state_57367__$1[(2)]);
var statearr_57383_57402 = state_57367__$1;
(statearr_57383_57402[(5)] = ex57379);


if((ex57379 instanceof Error)){
var statearr_57384_57403 = state_57367__$1;
(statearr_57384_57403[(1)] = (4));

(statearr_57384_57403[(5)] = null);

} else {
throw ex57379;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57368 === (10))){
var state_57367__$1 = state_57367;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57367__$1,(13),d);
} else {
if((state_val_57368 === (8))){
var inst_57343 = (state_57367[(2)]);
var inst_57344 = fluree.db.util.async.channel_QMARK_.call(null,d);
var state_57367__$1 = (function (){var statearr_57385 = state_57367;
(statearr_57385[(7)] = inst_57343);

return statearr_57385;
})();
if(inst_57344){
var statearr_57386_57404 = state_57367__$1;
(statearr_57386_57404[(1)] = (10));

} else {
var statearr_57387_57405 = state_57367__$1;
(statearr_57387_57405[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto____0 = (function (){
var statearr_57388 = [null,null,null,null,null,null,null,null,null];
(statearr_57388[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto__);

(statearr_57388[(1)] = (1));

return statearr_57388;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto____1 = (function (state_57367){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_57367);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57389){var ex__2882__auto__ = e57389;
var statearr_57390_57406 = state_57367;
(statearr_57390_57406[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_57367[(4)]))){
var statearr_57391_57407 = state_57367;
(statearr_57391_57407[(1)] = cljs.core.first.call(null,(state_57367[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57408 = state_57367;
state_57367 = G__57408;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto__ = function(state_57367){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto____1.call(this,state_57367);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57392 = f__2902__auto__.call(null);
(statearr_57392[(6)] = c__2901__auto__);

return statearr_57392;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57435){
var state_val_57436 = (state_57435[(1)]);
if((state_val_57436 === (7))){
var state_57435__$1 = state_57435;
var statearr_57437_57456 = state_57435__$1;
(statearr_57437_57456[(2)] = x);

(statearr_57437_57456[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57436 === (1))){
var state_57435__$1 = state_57435;
var statearr_57438_57457 = state_57435__$1;
(statearr_57438_57457[(2)] = null);

(statearr_57438_57457[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57436 === (4))){
var inst_57409 = (state_57435[(2)]);
var state_57435__$1 = state_57435;
var statearr_57439_57458 = state_57435__$1;
(statearr_57439_57458[(2)] = inst_57409);

(statearr_57439_57458[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57436 === (6))){
var state_57435__$1 = state_57435;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57435__$1,(9),x);
} else {
if((state_val_57436 === (3))){
var inst_57433 = (state_57435[(2)]);
var state_57435__$1 = state_57435;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57435__$1,inst_57433);
} else {
if((state_val_57436 === (2))){
var _ = (function (){var statearr_57441 = state_57435;
(statearr_57441[(4)] = cljs.core.cons.call(null,(5),(state_57435[(4)])));

return statearr_57441;
})();
var inst_57415 = fluree.db.util.async.channel_QMARK_.call(null,x);
var state_57435__$1 = state_57435;
if(inst_57415){
var statearr_57442_57459 = state_57435__$1;
(statearr_57442_57459[(1)] = (6));

} else {
var statearr_57443_57460 = state_57435__$1;
(statearr_57443_57460[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57436 === (9))){
var inst_57418 = (state_57435[(2)]);
var inst_57419 = fluree.db.util.async.throw_err.call(null,inst_57418);
var state_57435__$1 = state_57435;
var statearr_57444_57461 = state_57435__$1;
(statearr_57444_57461[(2)] = inst_57419);

(statearr_57444_57461[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57436 === (5))){
var _ = (function (){var statearr_57445 = state_57435;
(statearr_57445[(4)] = cljs.core.rest.call(null,(state_57435[(4)])));

return statearr_57445;
})();
var state_57435__$1 = state_57435;
var ex57440 = (state_57435__$1[(2)]);
var statearr_57446_57462 = state_57435__$1;
(statearr_57446_57462[(5)] = ex57440);


if((ex57440 instanceof Error)){
var statearr_57447_57463 = state_57435__$1;
(statearr_57447_57463[(1)] = (4));

(statearr_57447_57463[(5)] = null);

} else {
throw ex57440;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57436 === (8))){
var inst_57422 = (state_57435[(2)]);
var inst_57423 = fluree.db.dbfunctions.internal.boolean$.call(null,inst_57422);
var inst_57424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57425 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57426 = ["boolean",inst_57422,inst_57423];
var inst_57427 = cljs.core.PersistentHashMap.fromArrays(inst_57425,inst_57426);
var inst_57428 = [inst_57427,(10)];
var inst_57429 = (new cljs.core.PersistentVector(null,2,(5),inst_57424,inst_57428,null));
var inst_57430 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57429);
var _ = (function (){var statearr_57448 = state_57435;
(statearr_57448[(4)] = cljs.core.rest.call(null,(state_57435[(4)])));

return statearr_57448;
})();
var state_57435__$1 = (function (){var statearr_57449 = state_57435;
(statearr_57449[(7)] = inst_57430);

return statearr_57449;
})();
var statearr_57450_57464 = state_57435__$1;
(statearr_57450_57464[(2)] = inst_57423);

(statearr_57450_57464[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto____0 = (function (){
var statearr_57451 = [null,null,null,null,null,null,null,null];
(statearr_57451[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto__);

(statearr_57451[(1)] = (1));

return statearr_57451;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto____1 = (function (state_57435){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_57435);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57452){var ex__2882__auto__ = e57452;
var statearr_57453_57465 = state_57435;
(statearr_57453_57465[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_57435[(4)]))){
var statearr_57454_57466 = state_57435;
(statearr_57454_57466[(1)] = cljs.core.first.call(null,(state_57435[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57467 = state_57435;
state_57435 = G__57467;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto__ = function(state_57435){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto____1.call(this,state_57435);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57455 = f__2902__auto__.call(null);
(statearr_57455[(6)] = c__2901__auto__);

return statearr_57455;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57505){
var state_val_57506 = (state_57505[(1)]);
if((state_val_57506 === (7))){
var state_57505__$1 = state_57505;
var statearr_57507_57531 = state_57505__$1;
(statearr_57507_57531[(2)] = pattern);

(statearr_57507_57531[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57506 === (1))){
var state_57505__$1 = state_57505;
var statearr_57508_57532 = state_57505__$1;
(statearr_57508_57532[(2)] = null);

(statearr_57508_57532[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57506 === (4))){
var inst_57468 = (state_57505[(2)]);
var state_57505__$1 = state_57505;
var statearr_57509_57533 = state_57505__$1;
(statearr_57509_57533[(2)] = inst_57468);

(statearr_57509_57533[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57506 === (13))){
var inst_57485 = (state_57505[(2)]);
var inst_57486 = fluree.db.util.async.throw_err.call(null,inst_57485);
var state_57505__$1 = state_57505;
var statearr_57510_57534 = state_57505__$1;
(statearr_57510_57534[(2)] = inst_57486);

(statearr_57510_57534[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57506 === (6))){
var state_57505__$1 = state_57505;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57505__$1,(9),pattern);
} else {
if((state_val_57506 === (3))){
var inst_57503 = (state_57505[(2)]);
var state_57505__$1 = state_57505;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57505__$1,inst_57503);
} else {
if((state_val_57506 === (12))){
var inst_57481 = (state_57505[(7)]);
var inst_57489 = (state_57505[(2)]);
var inst_57490 = fluree.db.dbfunctions.internal.re_find.call(null,inst_57481,inst_57489);
var inst_57491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57492 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57493 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57494 = [inst_57481,inst_57489];
var inst_57495 = (new cljs.core.PersistentVector(null,2,(5),inst_57493,inst_57494,null));
var inst_57496 = ["re-find",inst_57495,inst_57490];
var inst_57497 = cljs.core.PersistentHashMap.fromArrays(inst_57492,inst_57496);
var inst_57498 = [inst_57497,(10)];
var inst_57499 = (new cljs.core.PersistentVector(null,2,(5),inst_57491,inst_57498,null));
var inst_57500 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57499);
var _ = (function (){var statearr_57511 = state_57505;
(statearr_57511[(4)] = cljs.core.rest.call(null,(state_57505[(4)])));

return statearr_57511;
})();
var state_57505__$1 = (function (){var statearr_57512 = state_57505;
(statearr_57512[(8)] = inst_57500);

return statearr_57512;
})();
var statearr_57513_57535 = state_57505__$1;
(statearr_57513_57535[(2)] = inst_57490);

(statearr_57513_57535[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57506 === (2))){
var _ = (function (){var statearr_57514 = state_57505;
(statearr_57514[(4)] = cljs.core.cons.call(null,(5),(state_57505[(4)])));

return statearr_57514;
})();
var inst_57474 = fluree.db.util.async.channel_QMARK_.call(null,pattern);
var state_57505__$1 = state_57505;
if(inst_57474){
var statearr_57515_57536 = state_57505__$1;
(statearr_57515_57536[(1)] = (6));

} else {
var statearr_57516_57537 = state_57505__$1;
(statearr_57516_57537[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57506 === (11))){
var state_57505__$1 = state_57505;
var statearr_57518_57538 = state_57505__$1;
(statearr_57518_57538[(2)] = string);

(statearr_57518_57538[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57506 === (9))){
var inst_57477 = (state_57505[(2)]);
var inst_57478 = fluree.db.util.async.throw_err.call(null,inst_57477);
var state_57505__$1 = state_57505;
var statearr_57519_57539 = state_57505__$1;
(statearr_57519_57539[(2)] = inst_57478);

(statearr_57519_57539[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57506 === (5))){
var _ = (function (){var statearr_57520 = state_57505;
(statearr_57520[(4)] = cljs.core.rest.call(null,(state_57505[(4)])));

return statearr_57520;
})();
var state_57505__$1 = state_57505;
var ex57517 = (state_57505__$1[(2)]);
var statearr_57521_57540 = state_57505__$1;
(statearr_57521_57540[(5)] = ex57517);


if((ex57517 instanceof Error)){
var statearr_57522_57541 = state_57505__$1;
(statearr_57522_57541[(1)] = (4));

(statearr_57522_57541[(5)] = null);

} else {
throw ex57517;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57506 === (10))){
var state_57505__$1 = state_57505;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57505__$1,(13),string);
} else {
if((state_val_57506 === (8))){
var inst_57481 = (state_57505[(2)]);
var inst_57482 = fluree.db.util.async.channel_QMARK_.call(null,string);
var state_57505__$1 = (function (){var statearr_57523 = state_57505;
(statearr_57523[(7)] = inst_57481);

return statearr_57523;
})();
if(inst_57482){
var statearr_57524_57542 = state_57505__$1;
(statearr_57524_57542[(1)] = (10));

} else {
var statearr_57525_57543 = state_57505__$1;
(statearr_57525_57543[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto____0 = (function (){
var statearr_57526 = [null,null,null,null,null,null,null,null,null];
(statearr_57526[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto__);

(statearr_57526[(1)] = (1));

return statearr_57526;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto____1 = (function (state_57505){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_57505);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57527){var ex__2882__auto__ = e57527;
var statearr_57528_57544 = state_57505;
(statearr_57528_57544[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_57505[(4)]))){
var statearr_57529_57545 = state_57505;
(statearr_57529_57545[(1)] = cljs.core.first.call(null,(state_57505[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57546 = state_57505;
state_57505 = G__57546;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto__ = function(state_57505){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto____1.call(this,state_57505);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57530 = f__2902__auto__.call(null);
(statearr_57530[(6)] = c__2901__auto__);

return statearr_57530;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57573){
var state_val_57574 = (state_57573[(1)]);
if((state_val_57574 === (7))){
var state_57573__$1 = state_57573;
var statearr_57575_57594 = state_57573__$1;
(statearr_57575_57594[(2)] = email);

(statearr_57575_57594[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57574 === (1))){
var state_57573__$1 = state_57573;
var statearr_57576_57595 = state_57573__$1;
(statearr_57576_57595[(2)] = null);

(statearr_57576_57595[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57574 === (4))){
var inst_57547 = (state_57573[(2)]);
var state_57573__$1 = state_57573;
var statearr_57577_57596 = state_57573__$1;
(statearr_57577_57596[(2)] = inst_57547);

(statearr_57577_57596[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57574 === (6))){
var state_57573__$1 = state_57573;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57573__$1,(9),email);
} else {
if((state_val_57574 === (3))){
var inst_57571 = (state_57573[(2)]);
var state_57573__$1 = state_57573;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57573__$1,inst_57571);
} else {
if((state_val_57574 === (2))){
var _ = (function (){var statearr_57579 = state_57573;
(statearr_57579[(4)] = cljs.core.cons.call(null,(5),(state_57573[(4)])));

return statearr_57579;
})();
var inst_57553 = fluree.db.util.async.channel_QMARK_.call(null,email);
var state_57573__$1 = state_57573;
if(inst_57553){
var statearr_57580_57597 = state_57573__$1;
(statearr_57580_57597[(1)] = (6));

} else {
var statearr_57581_57598 = state_57573__$1;
(statearr_57581_57598[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57574 === (9))){
var inst_57556 = (state_57573[(2)]);
var inst_57557 = fluree.db.util.async.throw_err.call(null,inst_57556);
var state_57573__$1 = state_57573;
var statearr_57582_57599 = state_57573__$1;
(statearr_57582_57599[(2)] = inst_57557);

(statearr_57582_57599[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57574 === (5))){
var _ = (function (){var statearr_57583 = state_57573;
(statearr_57583[(4)] = cljs.core.rest.call(null,(state_57573[(4)])));

return statearr_57583;
})();
var state_57573__$1 = state_57573;
var ex57578 = (state_57573__$1[(2)]);
var statearr_57584_57600 = state_57573__$1;
(statearr_57584_57600[(5)] = ex57578);


if((ex57578 instanceof Error)){
var statearr_57585_57601 = state_57573__$1;
(statearr_57585_57601[(1)] = (4));

(statearr_57585_57601[(5)] = null);

} else {
throw ex57578;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57574 === (8))){
var inst_57560 = (state_57573[(2)]);
var inst_57561 = fluree.db.dbfunctions.internal.valid_email_QMARK_.call(null,inst_57560);
var inst_57562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57563 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57564 = ["re-find",inst_57560,inst_57561];
var inst_57565 = cljs.core.PersistentHashMap.fromArrays(inst_57563,inst_57564);
var inst_57566 = [inst_57565,(10)];
var inst_57567 = (new cljs.core.PersistentVector(null,2,(5),inst_57562,inst_57566,null));
var inst_57568 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57567);
var _ = (function (){var statearr_57586 = state_57573;
(statearr_57586[(4)] = cljs.core.rest.call(null,(state_57573[(4)])));

return statearr_57586;
})();
var state_57573__$1 = (function (){var statearr_57587 = state_57573;
(statearr_57587[(7)] = inst_57568);

return statearr_57587;
})();
var statearr_57588_57602 = state_57573__$1;
(statearr_57588_57602[(2)] = inst_57561);

(statearr_57588_57602[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto____0 = (function (){
var statearr_57589 = [null,null,null,null,null,null,null,null];
(statearr_57589[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto__);

(statearr_57589[(1)] = (1));

return statearr_57589;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto____1 = (function (state_57573){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_57573);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57590){var ex__2882__auto__ = e57590;
var statearr_57591_57603 = state_57573;
(statearr_57591_57603[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_57573[(4)]))){
var statearr_57592_57604 = state_57573;
(statearr_57592_57604[(1)] = cljs.core.first.call(null,(state_57573[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57605 = state_57573;
state_57573 = G__57605;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto__ = function(state_57573){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto____1.call(this,state_57573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57593 = f__2902__auto__.call(null);
(statearr_57593[(6)] = c__2901__auto__);

return statearr_57593;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57652){
var state_val_57653 = (state_57652[(1)]);
if((state_val_57653 === (7))){
var inst_57622 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57652__$1 = state_57652;
if(cljs.core.truth_(inst_57622)){
var statearr_57654_57681 = state_57652__$1;
(statearr_57654_57681[(1)] = (9));

} else {
var statearr_57655_57682 = state_57652__$1;
(statearr_57655_57682[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (1))){
var state_57652__$1 = state_57652;
var statearr_57656_57683 = state_57652__$1;
(statearr_57656_57683[(2)] = null);

(statearr_57656_57683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (4))){
var inst_57606 = (state_57652[(2)]);
var state_57652__$1 = state_57652;
var statearr_57657_57684 = state_57652__$1;
(statearr_57657_57684[(2)] = inst_57606);

(statearr_57657_57684[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (15))){
var inst_57633 = (state_57652[(2)]);
var state_57652__$1 = state_57652;
var statearr_57658_57685 = state_57652__$1;
(statearr_57658_57685[(2)] = inst_57633);

(statearr_57658_57685[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (13))){
var inst_57630 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_57652__$1 = state_57652;
var statearr_57659_57686 = state_57652__$1;
(statearr_57659_57686[(2)] = inst_57630);

(statearr_57659_57686[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (6))){
var inst_57617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57618 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_57619 = [inst_57618,(0)];
var inst_57620 = (new cljs.core.PersistentVector(null,2,(5),inst_57617,inst_57619,null));
var state_57652__$1 = state_57652;
var statearr_57660_57687 = state_57652__$1;
(statearr_57660_57687[(2)] = inst_57620);

(statearr_57660_57687[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (3))){
var inst_57650 = (state_57652[(2)]);
var state_57652__$1 = state_57652;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57652__$1,inst_57650);
} else {
if((state_val_57653 === (12))){
var inst_57626 = (state_57652[(2)]);
var inst_57627 = fluree.db.util.async.throw_err.call(null,inst_57626);
var state_57652__$1 = state_57652;
var statearr_57661_57688 = state_57652__$1;
(statearr_57661_57688[(2)] = inst_57627);

(statearr_57661_57688[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (2))){
var _ = (function (){var statearr_57662 = state_57652;
(statearr_57662[(4)] = cljs.core.cons.call(null,(5),(state_57652[(4)])));

return statearr_57662;
})();
var inst_57615 = new cljs.core.Keyword(null,"user_id","user_id",993497112).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57652__$1 = state_57652;
if(cljs.core.truth_(inst_57615)){
var statearr_57663_57689 = state_57652__$1;
(statearr_57663_57689[(1)] = (6));

} else {
var statearr_57664_57690 = state_57652__$1;
(statearr_57664_57690[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (11))){
var inst_57635 = (state_57652[(2)]);
var state_57652__$1 = state_57652;
var statearr_57666_57691 = state_57652__$1;
(statearr_57666_57691[(2)] = inst_57635);

(statearr_57666_57691[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (9))){
var inst_57624 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth.call(null,_QMARK_ctx);
var state_57652__$1 = state_57652;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57652__$1,(12),inst_57624);
} else {
if((state_val_57653 === (5))){
var _ = (function (){var statearr_57667 = state_57652;
(statearr_57667[(4)] = cljs.core.rest.call(null,(state_57652[(4)])));

return statearr_57667;
})();
var state_57652__$1 = state_57652;
var ex57665 = (state_57652__$1[(2)]);
var statearr_57668_57692 = state_57652__$1;
(statearr_57668_57692[(5)] = ex57665);


if((ex57665 instanceof Error)){
var statearr_57669_57693 = state_57652__$1;
(statearr_57669_57693[(1)] = (4));

(statearr_57669_57693[(5)] = null);

} else {
throw ex57665;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (14))){
var state_57652__$1 = state_57652;
var statearr_57670_57694 = state_57652__$1;
(statearr_57670_57694[(2)] = null);

(statearr_57670_57694[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (10))){
var state_57652__$1 = state_57652;
var statearr_57671_57695 = state_57652__$1;
(statearr_57671_57695[(1)] = (13));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57653 === (8))){
var inst_57637 = (state_57652[(2)]);
var inst_57638 = cljs.core.nth.call(null,inst_57637,(0),null);
var inst_57639 = cljs.core.nth.call(null,inst_57637,(1),null);
var inst_57640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57641 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57642 = ["?user_id","?ctx",inst_57638];
var inst_57643 = cljs.core.PersistentHashMap.fromArrays(inst_57641,inst_57642);
var inst_57644 = ((10) + inst_57639);
var inst_57645 = [inst_57643,inst_57644];
var inst_57646 = (new cljs.core.PersistentVector(null,2,(5),inst_57640,inst_57645,null));
var inst_57647 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57646);
var _ = (function (){var statearr_57673 = state_57652;
(statearr_57673[(4)] = cljs.core.rest.call(null,(state_57652[(4)])));

return statearr_57673;
})();
var state_57652__$1 = (function (){var statearr_57674 = state_57652;
(statearr_57674[(7)] = inst_57647);

return statearr_57674;
})();
var statearr_57675_57696 = state_57652__$1;
(statearr_57675_57696[(2)] = inst_57638);

(statearr_57675_57696[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto____0 = (function (){
var statearr_57676 = [null,null,null,null,null,null,null,null];
(statearr_57676[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto__);

(statearr_57676[(1)] = (1));

return statearr_57676;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto____1 = (function (state_57652){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_57652);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57677){var ex__2882__auto__ = e57677;
var statearr_57678_57697 = state_57652;
(statearr_57678_57697[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_57652[(4)]))){
var statearr_57679_57698 = state_57652;
(statearr_57679_57698[(1)] = cljs.core.first.call(null,(state_57652[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57699 = state_57652;
state_57652 = G__57699;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto__ = function(state_57652){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto____1.call(this,state_57652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57680 = f__2902__auto__.call(null);
(statearr_57680[(6)] = c__2901__auto__);

return statearr_57680;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57727){
var state_val_57728 = (state_57727[(1)]);
if((state_val_57728 === (7))){
var inst_57720 = fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_57727__$1 = state_57727;
var statearr_57729_57748 = state_57727__$1;
(statearr_57729_57748[(2)] = inst_57720);

(statearr_57729_57748[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57728 === (1))){
var state_57727__$1 = state_57727;
var statearr_57730_57749 = state_57727__$1;
(statearr_57730_57749[(2)] = null);

(statearr_57730_57749[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57728 === (4))){
var inst_57700 = (state_57727[(2)]);
var state_57727__$1 = state_57727;
var statearr_57731_57750 = state_57727__$1;
(statearr_57731_57750[(2)] = inst_57700);

(statearr_57731_57750[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57728 === (6))){
var inst_57708 = fluree.db.dbfunctions.internal._QMARK_auth_id.call(null,_QMARK_ctx);
var state_57727__$1 = state_57727;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57727__$1,(9),inst_57708);
} else {
if((state_val_57728 === (3))){
var inst_57725 = (state_57727[(2)]);
var state_57727__$1 = state_57727;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57727__$1,inst_57725);
} else {
if((state_val_57728 === (2))){
var _ = (function (){var statearr_57733 = state_57727;
(statearr_57733[(4)] = cljs.core.cons.call(null,(5),(state_57727[(4)])));

return statearr_57733;
})();
var inst_57706 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_57727__$1 = state_57727;
if(cljs.core.truth_(inst_57706)){
var statearr_57734_57751 = state_57727__$1;
(statearr_57734_57751[(1)] = (6));

} else {
var statearr_57735_57752 = state_57727__$1;
(statearr_57735_57752[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57728 === (9))){
var inst_57710 = (state_57727[(2)]);
var inst_57711 = fluree.db.util.async.throw_err.call(null,inst_57710);
var inst_57712 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57713 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57714 = ["?auth_id","?ctx",inst_57711];
var inst_57715 = cljs.core.PersistentHashMap.fromArrays(inst_57713,inst_57714);
var inst_57716 = [inst_57715,(10)];
var inst_57717 = (new cljs.core.PersistentVector(null,2,(5),inst_57712,inst_57716,null));
var inst_57718 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57717);
var state_57727__$1 = (function (){var statearr_57736 = state_57727;
(statearr_57736[(7)] = inst_57718);

return statearr_57736;
})();
var statearr_57737_57753 = state_57727__$1;
(statearr_57737_57753[(2)] = inst_57711);

(statearr_57737_57753[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57728 === (5))){
var _ = (function (){var statearr_57738 = state_57727;
(statearr_57738[(4)] = cljs.core.rest.call(null,(state_57727[(4)])));

return statearr_57738;
})();
var state_57727__$1 = state_57727;
var ex57732 = (state_57727__$1[(2)]);
var statearr_57739_57754 = state_57727__$1;
(statearr_57739_57754[(5)] = ex57732);


if((ex57732 instanceof Error)){
var statearr_57740_57755 = state_57727__$1;
(statearr_57740_57755[(1)] = (4));

(statearr_57740_57755[(5)] = null);

} else {
throw ex57732;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57728 === (8))){
var inst_57722 = (state_57727[(2)]);
var _ = (function (){var statearr_57741 = state_57727;
(statearr_57741[(4)] = cljs.core.rest.call(null,(state_57727[(4)])));

return statearr_57741;
})();
var state_57727__$1 = state_57727;
var statearr_57742_57756 = state_57727__$1;
(statearr_57742_57756[(2)] = inst_57722);

(statearr_57742_57756[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto____0 = (function (){
var statearr_57743 = [null,null,null,null,null,null,null,null];
(statearr_57743[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto__);

(statearr_57743[(1)] = (1));

return statearr_57743;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto____1 = (function (state_57727){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_57727);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57744){var ex__2882__auto__ = e57744;
var statearr_57745_57757 = state_57727;
(statearr_57745_57757[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_57727[(4)]))){
var statearr_57746_57758 = state_57727;
(statearr_57746_57758[(1)] = cljs.core.first.call(null,(state_57727[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57759 = state_57727;
state_57727 = G__57759;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto__ = function(state_57727){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto____1.call(this,state_57727);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57747 = f__2902__auto__.call(null);
(statearr_57747[(6)] = c__2901__auto__);

return statearr_57747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objT",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"objF",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"function","function",-2127255473),"flakes",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"?ctx",new cljs.core.Keyword(null,"result","result",1415092211),res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise.call(null,_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__57761 = arguments.length;
switch (G__57761) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.call(null,_QMARK_ctx,max,new cljs.core.Keyword(null,"instant","instant",655498374).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx).toEpochMilli());
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57803){
var state_val_57804 = (state_57803[(1)]);
if((state_val_57804 === (7))){
var state_57803__$1 = state_57803;
var statearr_57805_57835 = state_57803__$1;
(statearr_57805_57835[(2)] = seed);

(statearr_57805_57835[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57804 === (1))){
var state_57803__$1 = state_57803;
var statearr_57806_57836 = state_57803__$1;
(statearr_57806_57836[(2)] = null);

(statearr_57806_57836[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57804 === (4))){
var inst_57762 = (state_57803[(2)]);
var state_57803__$1 = state_57803;
var statearr_57807_57837 = state_57803__$1;
(statearr_57807_57837[(2)] = inst_57762);

(statearr_57807_57837[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57804 === (15))){
var state_57803__$1 = state_57803;
var statearr_57808_57838 = state_57803__$1;
(statearr_57808_57838[(2)] = (10));

(statearr_57808_57838[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57804 === (13))){
var inst_57779 = (state_57803[(2)]);
var inst_57780 = fluree.db.util.async.throw_err.call(null,inst_57779);
var state_57803__$1 = state_57803;
var statearr_57809_57839 = state_57803__$1;
(statearr_57809_57839[(2)] = inst_57780);

(statearr_57809_57839[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57804 === (6))){
var state_57803__$1 = state_57803;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57803__$1,(9),seed);
} else {
if((state_val_57804 === (3))){
var inst_57801 = (state_57803[(2)]);
var state_57803__$1 = state_57803;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57803__$1,inst_57801);
} else {
if((state_val_57804 === (12))){
var inst_57783 = (state_57803[(7)]);
var inst_57783__$1 = (state_57803[(2)]);
var state_57803__$1 = (function (){var statearr_57810 = state_57803;
(statearr_57810[(7)] = inst_57783__$1);

return statearr_57810;
})();
if(cljs.core.truth_(inst_57783__$1)){
var statearr_57811_57840 = state_57803__$1;
(statearr_57811_57840[(1)] = (14));

} else {
var statearr_57812_57841 = state_57803__$1;
(statearr_57812_57841[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57804 === (2))){
var _ = (function (){var statearr_57813 = state_57803;
(statearr_57813[(4)] = cljs.core.cons.call(null,(5),(state_57803[(4)])));

return statearr_57813;
})();
var inst_57768 = fluree.db.util.async.channel_QMARK_.call(null,seed);
var state_57803__$1 = state_57803;
if(inst_57768){
var statearr_57814_57842 = state_57803__$1;
(statearr_57814_57842[(1)] = (6));

} else {
var statearr_57815_57843 = state_57803__$1;
(statearr_57815_57843[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57804 === (11))){
var state_57803__$1 = state_57803;
var statearr_57817_57844 = state_57803__$1;
(statearr_57817_57844[(2)] = max);

(statearr_57817_57844[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57804 === (9))){
var inst_57771 = (state_57803[(2)]);
var inst_57772 = fluree.db.util.async.throw_err.call(null,inst_57771);
var state_57803__$1 = state_57803;
var statearr_57818_57845 = state_57803__$1;
(statearr_57818_57845[(2)] = inst_57772);

(statearr_57818_57845[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57804 === (5))){
var _ = (function (){var statearr_57819 = state_57803;
(statearr_57819[(4)] = cljs.core.rest.call(null,(state_57803[(4)])));

return statearr_57819;
})();
var state_57803__$1 = state_57803;
var ex57816 = (state_57803__$1[(2)]);
var statearr_57820_57846 = state_57803__$1;
(statearr_57820_57846[(5)] = ex57816);


if((ex57816 instanceof Error)){
var statearr_57821_57847 = state_57803__$1;
(statearr_57821_57847[(1)] = (4));

(statearr_57821_57847[(5)] = null);

} else {
throw ex57816;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57804 === (14))){
var inst_57783 = (state_57803[(7)]);
var state_57803__$1 = state_57803;
var statearr_57822_57848 = state_57803__$1;
(statearr_57822_57848[(2)] = inst_57783);

(statearr_57822_57848[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57804 === (16))){
var inst_57775 = (state_57803[(8)]);
var inst_57787 = (state_57803[(2)]);
var inst_57788 = fluree.db.dbfunctions.internal.rand.call(null,inst_57775,inst_57787);
var inst_57789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57790 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57791 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57792 = [max,seed];
var inst_57793 = (new cljs.core.PersistentVector(null,2,(5),inst_57791,inst_57792,null));
var inst_57794 = ["rand",inst_57793,inst_57788];
var inst_57795 = cljs.core.PersistentHashMap.fromArrays(inst_57790,inst_57794);
var inst_57796 = [inst_57795,(10)];
var inst_57797 = (new cljs.core.PersistentVector(null,2,(5),inst_57789,inst_57796,null));
var inst_57798 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57797);
var _ = (function (){var statearr_57823 = state_57803;
(statearr_57823[(4)] = cljs.core.rest.call(null,(state_57803[(4)])));

return statearr_57823;
})();
var state_57803__$1 = (function (){var statearr_57824 = state_57803;
(statearr_57824[(9)] = inst_57798);

return statearr_57824;
})();
var statearr_57825_57849 = state_57803__$1;
(statearr_57825_57849[(2)] = inst_57788);

(statearr_57825_57849[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57804 === (10))){
var state_57803__$1 = state_57803;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57803__$1,(13),max);
} else {
if((state_val_57804 === (8))){
var inst_57775 = (state_57803[(2)]);
var inst_57776 = fluree.db.util.async.channel_QMARK_.call(null,max);
var state_57803__$1 = (function (){var statearr_57826 = state_57803;
(statearr_57826[(8)] = inst_57775);

return statearr_57826;
})();
if(inst_57776){
var statearr_57827_57850 = state_57803__$1;
(statearr_57827_57850[(1)] = (10));

} else {
var statearr_57828_57851 = state_57803__$1;
(statearr_57828_57851[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__2879__auto____0 = (function (){
var statearr_57829 = [null,null,null,null,null,null,null,null,null,null];
(statearr_57829[(0)] = fluree$db$dbfunctions$fns$state_machine__2879__auto__);

(statearr_57829[(1)] = (1));

return statearr_57829;
});
var fluree$db$dbfunctions$fns$state_machine__2879__auto____1 = (function (state_57803){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_57803);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57830){var ex__2882__auto__ = e57830;
var statearr_57831_57852 = state_57803;
(statearr_57831_57852[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_57803[(4)]))){
var statearr_57832_57853 = state_57803;
(statearr_57832_57853[(1)] = cljs.core.first.call(null,(state_57803[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57854 = state_57803;
state_57803 = G__57854;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__2879__auto__ = function(state_57803){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__2879__auto____1.call(this,state_57803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57833 = f__2902__auto__.call(null);
(statearr_57833[(6)] = c__2901__auto__);

return statearr_57833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57875){
var state_val_57876 = (state_57875[(1)]);
if((state_val_57876 === (1))){
var state_57875__$1 = state_57875;
var statearr_57877_57892 = state_57875__$1;
(statearr_57877_57892[(2)] = null);

(statearr_57877_57892[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57876 === (2))){
var _ = (function (){var statearr_57878 = state_57875;
(statearr_57878[(4)] = cljs.core.cons.call(null,(5),(state_57875[(4)])));

return statearr_57878;
})();
var inst_57861 = fluree.db.util.core.random_uuid.call(null);
var inst_57862 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_57861);
var inst_57863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57864 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57865 = cljs.core.PersistentVector.EMPTY;
var inst_57866 = ["uuid",inst_57865,inst_57862];
var inst_57867 = cljs.core.PersistentHashMap.fromArrays(inst_57864,inst_57866);
var inst_57868 = [inst_57867,(10)];
var inst_57869 = (new cljs.core.PersistentVector(null,2,(5),inst_57863,inst_57868,null));
var inst_57870 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57869);
var ___$1 = (function (){var statearr_57879 = state_57875;
(statearr_57879[(4)] = cljs.core.rest.call(null,(state_57875[(4)])));

return statearr_57879;
})();
var state_57875__$1 = (function (){var statearr_57880 = state_57875;
(statearr_57880[(7)] = inst_57870);

return statearr_57880;
})();
var statearr_57881_57893 = state_57875__$1;
(statearr_57881_57893[(2)] = inst_57862);

(statearr_57881_57893[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57876 === (3))){
var inst_57873 = (state_57875[(2)]);
var state_57875__$1 = state_57875;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57875__$1,inst_57873);
} else {
if((state_val_57876 === (4))){
var inst_57855 = (state_57875[(2)]);
var state_57875__$1 = state_57875;
var statearr_57883_57894 = state_57875__$1;
(statearr_57883_57894[(2)] = inst_57855);

(statearr_57883_57894[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57876 === (5))){
var _ = (function (){var statearr_57884 = state_57875;
(statearr_57884[(4)] = cljs.core.rest.call(null,(state_57875[(4)])));

return statearr_57884;
})();
var state_57875__$1 = state_57875;
var ex57882 = (state_57875__$1[(2)]);
var statearr_57885_57895 = state_57875__$1;
(statearr_57885_57895[(5)] = ex57882);


if((ex57882 instanceof Error)){
var statearr_57886_57896 = state_57875__$1;
(statearr_57886_57896[(1)] = (4));

(statearr_57886_57896[(5)] = null);

} else {
throw ex57882;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto____0 = (function (){
var statearr_57887 = [null,null,null,null,null,null,null,null];
(statearr_57887[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto__);

(statearr_57887[(1)] = (1));

return statearr_57887;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto____1 = (function (state_57875){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_57875);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57888){var ex__2882__auto__ = e57888;
var statearr_57889_57897 = state_57875;
(statearr_57889_57897[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_57875[(4)]))){
var statearr_57890_57898 = state_57875;
(statearr_57890_57898[(1)] = cljs.core.first.call(null,(state_57875[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57899 = state_57875;
state_57875 = G__57899;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto__ = function(state_57875){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto____1.call(this,state_57875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57891 = f__2902__auto__.call(null);
(statearr_57891[(6)] = c__2901__auto__);

return statearr_57891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57929){
var state_val_57930 = (state_57929[(1)]);
if((state_val_57930 === (7))){
var state_57929__$1 = state_57929;
var statearr_57931_57950 = state_57929__$1;
(statearr_57931_57950[(2)] = num);

(statearr_57931_57950[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57930 === (1))){
var state_57929__$1 = state_57929;
var statearr_57932_57951 = state_57929__$1;
(statearr_57932_57951[(2)] = null);

(statearr_57932_57951[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57930 === (4))){
var inst_57900 = (state_57929[(2)]);
var state_57929__$1 = state_57929;
var statearr_57933_57952 = state_57929__$1;
(statearr_57933_57952[(2)] = inst_57900);

(statearr_57933_57952[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57930 === (6))){
var state_57929__$1 = state_57929;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57929__$1,(9),num);
} else {
if((state_val_57930 === (3))){
var inst_57927 = (state_57929[(2)]);
var state_57929__$1 = state_57929;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57929__$1,inst_57927);
} else {
if((state_val_57930 === (2))){
var _ = (function (){var statearr_57935 = state_57929;
(statearr_57935[(4)] = cljs.core.cons.call(null,(5),(state_57929[(4)])));

return statearr_57935;
})();
var inst_57906 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_57929__$1 = state_57929;
if(inst_57906){
var statearr_57936_57953 = state_57929__$1;
(statearr_57936_57953[(1)] = (6));

} else {
var statearr_57937_57954 = state_57929__$1;
(statearr_57937_57954[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57930 === (9))){
var inst_57909 = (state_57929[(2)]);
var inst_57910 = fluree.db.util.async.throw_err.call(null,inst_57909);
var state_57929__$1 = state_57929;
var statearr_57938_57955 = state_57929__$1;
(statearr_57938_57955[(2)] = inst_57910);

(statearr_57938_57955[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57930 === (5))){
var _ = (function (){var statearr_57939 = state_57929;
(statearr_57939[(4)] = cljs.core.rest.call(null,(state_57929[(4)])));

return statearr_57939;
})();
var state_57929__$1 = state_57929;
var ex57934 = (state_57929__$1[(2)]);
var statearr_57940_57956 = state_57929__$1;
(statearr_57940_57956[(5)] = ex57934);


if((ex57934 instanceof Error)){
var statearr_57941_57957 = state_57929__$1;
(statearr_57941_57957[(1)] = (4));

(statearr_57941_57957[(5)] = null);

} else {
throw ex57934;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57930 === (8))){
var inst_57913 = (state_57929[(2)]);
var inst_57914 = fluree.db.dbfunctions.internal.ceil.call(null,inst_57913);
var inst_57915 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57916 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57917 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57918 = [fluree.db.dbfunctions.fns.ceil];
var inst_57919 = (new cljs.core.PersistentVector(null,1,(5),inst_57917,inst_57918,null));
var inst_57920 = ["",inst_57919,inst_57914];
var inst_57921 = cljs.core.PersistentHashMap.fromArrays(inst_57916,inst_57920);
var inst_57922 = [inst_57921,(10)];
var inst_57923 = (new cljs.core.PersistentVector(null,2,(5),inst_57915,inst_57922,null));
var inst_57924 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57923);
var _ = (function (){var statearr_57942 = state_57929;
(statearr_57942[(4)] = cljs.core.rest.call(null,(state_57929[(4)])));

return statearr_57942;
})();
var state_57929__$1 = (function (){var statearr_57943 = state_57929;
(statearr_57943[(7)] = inst_57924);

return statearr_57943;
})();
var statearr_57944_57958 = state_57929__$1;
(statearr_57944_57958[(2)] = inst_57914);

(statearr_57944_57958[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto____0 = (function (){
var statearr_57945 = [null,null,null,null,null,null,null,null];
(statearr_57945[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto__);

(statearr_57945[(1)] = (1));

return statearr_57945;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto____1 = (function (state_57929){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_57929);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e57946){var ex__2882__auto__ = e57946;
var statearr_57947_57959 = state_57929;
(statearr_57947_57959[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_57929[(4)]))){
var statearr_57948_57960 = state_57929;
(statearr_57948_57960[(1)] = cljs.core.first.call(null,(state_57929[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__57961 = state_57929;
state_57929 = G__57961;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto__ = function(state_57929){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto____1.call(this,state_57929);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_57949 = f__2902__auto__.call(null);
(statearr_57949[(6)] = c__2901__auto__);

return statearr_57949;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_57991){
var state_val_57992 = (state_57991[(1)]);
if((state_val_57992 === (7))){
var state_57991__$1 = state_57991;
var statearr_57993_58012 = state_57991__$1;
(statearr_57993_58012[(2)] = num);

(statearr_57993_58012[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57992 === (1))){
var state_57991__$1 = state_57991;
var statearr_57994_58013 = state_57991__$1;
(statearr_57994_58013[(2)] = null);

(statearr_57994_58013[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57992 === (4))){
var inst_57962 = (state_57991[(2)]);
var state_57991__$1 = state_57991;
var statearr_57995_58014 = state_57991__$1;
(statearr_57995_58014[(2)] = inst_57962);

(statearr_57995_58014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57992 === (6))){
var state_57991__$1 = state_57991;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_57991__$1,(9),num);
} else {
if((state_val_57992 === (3))){
var inst_57989 = (state_57991[(2)]);
var state_57991__$1 = state_57991;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_57991__$1,inst_57989);
} else {
if((state_val_57992 === (2))){
var _ = (function (){var statearr_57997 = state_57991;
(statearr_57997[(4)] = cljs.core.cons.call(null,(5),(state_57991[(4)])));

return statearr_57997;
})();
var inst_57968 = fluree.db.util.async.channel_QMARK_.call(null,num);
var state_57991__$1 = state_57991;
if(inst_57968){
var statearr_57998_58015 = state_57991__$1;
(statearr_57998_58015[(1)] = (6));

} else {
var statearr_57999_58016 = state_57991__$1;
(statearr_57999_58016[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57992 === (9))){
var inst_57971 = (state_57991[(2)]);
var inst_57972 = fluree.db.util.async.throw_err.call(null,inst_57971);
var state_57991__$1 = state_57991;
var statearr_58000_58017 = state_57991__$1;
(statearr_58000_58017[(2)] = inst_57972);

(statearr_58000_58017[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57992 === (5))){
var _ = (function (){var statearr_58001 = state_57991;
(statearr_58001[(4)] = cljs.core.rest.call(null,(state_57991[(4)])));

return statearr_58001;
})();
var state_57991__$1 = state_57991;
var ex57996 = (state_57991__$1[(2)]);
var statearr_58002_58018 = state_57991__$1;
(statearr_58002_58018[(5)] = ex57996);


if((ex57996 instanceof Error)){
var statearr_58003_58019 = state_57991__$1;
(statearr_58003_58019[(1)] = (4));

(statearr_58003_58019[(5)] = null);

} else {
throw ex57996;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_57992 === (8))){
var inst_57975 = (state_57991[(2)]);
var inst_57976 = fluree.db.dbfunctions.internal.floor.call(null,inst_57975);
var inst_57977 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57978 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_57979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_57980 = [fluree.db.dbfunctions.fns.floor];
var inst_57981 = (new cljs.core.PersistentVector(null,1,(5),inst_57979,inst_57980,null));
var inst_57982 = ["",inst_57981,inst_57976];
var inst_57983 = cljs.core.PersistentHashMap.fromArrays(inst_57978,inst_57982);
var inst_57984 = [inst_57983,(10)];
var inst_57985 = (new cljs.core.PersistentVector(null,2,(5),inst_57977,inst_57984,null));
var inst_57986 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_57985);
var _ = (function (){var statearr_58004 = state_57991;
(statearr_58004[(4)] = cljs.core.rest.call(null,(state_57991[(4)])));

return statearr_58004;
})();
var state_57991__$1 = (function (){var statearr_58005 = state_57991;
(statearr_58005[(7)] = inst_57986);

return statearr_58005;
})();
var statearr_58006_58020 = state_57991__$1;
(statearr_58006_58020[(2)] = inst_57976);

(statearr_58006_58020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto____0 = (function (){
var statearr_58007 = [null,null,null,null,null,null,null,null];
(statearr_58007[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto__);

(statearr_58007[(1)] = (1));

return statearr_58007;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto____1 = (function (state_57991){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_57991);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e58008){var ex__2882__auto__ = e58008;
var statearr_58009_58021 = state_57991;
(statearr_58009_58021[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_57991[(4)]))){
var statearr_58010_58022 = state_57991;
(statearr_58010_58022[(1)] = cljs.core.first.call(null,(state_57991[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58023 = state_57991;
state_57991 = G__58023;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto__ = function(state_57991){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto____1.call(this,state_57991);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_58011 = f__2902__auto__.call(null);
(statearr_58011[(6)] = c__2901__auto__);

return statearr_58011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_58048){
var state_val_58049 = (state_58048[(1)]);
if((state_val_58049 === (1))){
var state_58048__$1 = state_58048;
var statearr_58050_58065 = state_58048__$1;
(statearr_58050_58065[(2)] = null);

(statearr_58050_58065[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58049 === (2))){
var _ = (function (){var statearr_58051 = state_58048;
(statearr_58051[(4)] = cljs.core.cons.call(null,(5),(state_58048[(4)])));

return statearr_58051;
})();
var inst_58030 = fluree.db.dbfunctions.internal.cas.call(null,_QMARK_ctx,compare_val,new_val);
var state_58048__$1 = state_58048;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_58048__$1,(6),inst_58030);
} else {
if((state_val_58049 === (3))){
var inst_58046 = (state_58048[(2)]);
var state_58048__$1 = state_58048;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_58048__$1,inst_58046);
} else {
if((state_val_58049 === (4))){
var inst_58024 = (state_58048[(2)]);
var state_58048__$1 = state_58048;
var statearr_58053_58066 = state_58048__$1;
(statearr_58053_58066[(2)] = inst_58024);

(statearr_58053_58066[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58049 === (5))){
var _ = (function (){var statearr_58054 = state_58048;
(statearr_58054[(4)] = cljs.core.rest.call(null,(state_58048[(4)])));

return statearr_58054;
})();
var state_58048__$1 = state_58048;
var ex58052 = (state_58048__$1[(2)]);
var statearr_58055_58067 = state_58048__$1;
(statearr_58055_58067[(5)] = ex58052);


if((ex58052 instanceof Error)){
var statearr_58056_58068 = state_58048__$1;
(statearr_58056_58068[(1)] = (4));

(statearr_58056_58068[(5)] = null);

} else {
throw ex58052;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_58049 === (6))){
var inst_58032 = (state_58048[(2)]);
var inst_58033 = fluree.db.util.async.throw_err.call(null,inst_58032);
var inst_58034 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58035 = [new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_58036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_58037 = [compare_val,new_val];
var inst_58038 = (new cljs.core.PersistentVector(null,2,(5),inst_58036,inst_58037,null));
var inst_58039 = ["",inst_58038,inst_58033];
var inst_58040 = cljs.core.PersistentHashMap.fromArrays(inst_58035,inst_58039);
var inst_58041 = [inst_58040,(10)];
var inst_58042 = (new cljs.core.PersistentVector(null,2,(5),inst_58034,inst_58041,null));
var inst_58043 = fluree.db.dbfunctions.fns.add_stack.call(null,_QMARK_ctx,inst_58042);
var _ = (function (){var statearr_58057 = state_58048;
(statearr_58057[(4)] = cljs.core.rest.call(null,(state_58048[(4)])));

return statearr_58057;
})();
var state_58048__$1 = (function (){var statearr_58058 = state_58048;
(statearr_58058[(7)] = inst_58043);

return statearr_58058;
})();
var statearr_58059_58069 = state_58048__$1;
(statearr_58059_58069[(2)] = inst_58033);

(statearr_58059_58069[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto____0 = (function (){
var statearr_58060 = [null,null,null,null,null,null,null,null];
(statearr_58060[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto__);

(statearr_58060[(1)] = (1));

return statearr_58060;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto____1 = (function (state_58048){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_58048);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e58061){var ex__2882__auto__ = e58061;
var statearr_58062_58070 = state_58048;
(statearr_58062_58070[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_58048[(4)]))){
var statearr_58063_58071 = state_58048;
(statearr_58063_58071[(1)] = cljs.core.first.call(null,(state_58048[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__58072 = state_58048;
state_58048 = G__58072;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto__ = function(state_58048){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto____1.call(this,state_58048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_58064 = f__2902__auto__.call(null);
(statearr_58064[(6)] = c__2901__auto__);

return statearr_58064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
