// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('goog.net.XhrIo');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5735__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5735__auto__)){
var st = temp__5735__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__16333 = cljs.core._EQ_;
var expr__16334 = e.getLastErrorCode();
if(cljs.core.truth_(pred__16333.call(null,goog.net.ErrorCode.NO_ERROR,expr__16334))){
return new cljs.core.Keyword("xhttp","no-error","xhttp/no-error",1902047248);
} else {
if(cljs.core.truth_(pred__16333.call(null,goog.net.ErrorCode.EXCEPTION,expr__16334))){
return new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040);
} else {
if(cljs.core.truth_(pred__16333.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__16334))){
return new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305);
} else {
if(cljs.core.truth_(pred__16333.call(null,goog.net.ErrorCode.ABORT,expr__16334))){
return new cljs.core.Keyword("xhttp","abort","xhttp/abort",666776046);
} else {
if(cljs.core.truth_(pred__16333.call(null,goog.net.ErrorCode.TIMEOUT,expr__16334))){
return new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562);
} else {
return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4115__auto__ = status;
if(cljs.core.truth_(and__4115__auto__)){
return (status > (0));
} else {
return and__4115__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.call(null,message,(function (){var G__16336 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.call(null,G__16336,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__16336;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__16337 = opts;
var map__16337__$1 = (((((!((map__16337 == null))))?(((((map__16337.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16337.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16337):map__16337);
var request_timeout = cljs.core.get.call(null,map__16337__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__16337__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__16337__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__16339 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__16339__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__16339,headers):G__16339);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__16339__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__16339__$1;
}
})();
try{goog.net.XhrIo.send(url,(function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.call(null,response_chan,cljs.core.js__GT_clj.call(null,xhr.getResponseJson(),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
} else {
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,xhr));
}
}),"POST",fluree.db.util.json.stringify.call(null,message),cljs.core.clj__GT_js.call(null,headers__$1),request_timeout);
}catch (e16340){var e_16341 = e16340;
fluree.db.util.log.warn.call(null,"CAUGHT ERROR!");

cljs.core.async.put_BANG_.call(null,response_chan,e_16341);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__16342 = opts;
var map__16342__$1 = (((((!((map__16342 == null))))?(((((map__16342.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16342.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16342):map__16342);
var request_timeout = cljs.core.get.call(null,map__16342__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.call(null,map__16342__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.call(null,map__16342__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.call(null,map__16342__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.call(null,map__16342__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.call(null);
var headers__$1 = (function (){var G__16344 = cljs.core.PersistentArrayMap.EMPTY;
var G__16344__$1 = (cljs.core.truth_(headers)?cljs.core.merge.call(null,G__16344,headers):G__16344);
if(cljs.core.truth_(token)){
return cljs.core.assoc.call(null,G__16344__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__16344__$1;
}
})();
try{goog.net.XhrIo.send(url,(function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.call(null,response_chan,(function (){var G__16346 = output_format;
var G__16346__$1 = (((G__16346 instanceof cljs.core.Keyword))?G__16346.fqn:null);
switch (G__16346__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.call(null,"http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.call(null,response_chan,fluree.db.util.xhttp.format_error_response.call(null,url,xhr));
}
}),"GET",body,cljs.core.clj__GT_js.call(null,headers__$1),request_timeout);
}catch (e16345){var e_16348 = e16345;
fluree.db.util.log.warn.call(null,"CAUUGHT ERROR!");

cljs.core.async.put_BANG_.call(null,response_chan,e_16348);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__16349 = cljs.core.assoc.call(null,cljs.core.assoc_in.call(null,opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.call(null,G__16349,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify.call(null,new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__16349;
}
})();
return fluree.db.util.xhttp.get.call(null,url,opts_STAR_);
});
/**
 * Sends messages across web socket. Sends never block and will immediately queue.
 *   Message to send should be a two-tuple placed on the pub-chan, of:
 *  [msg resp-chan]
 *   where a true/false response will eventually be placed on the resp-chan if the send
 *   is successful.
 */
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_16382){
var state_val_16383 = (state_16382[(1)]);
if((state_val_16383 === (7))){
var inst_16378 = (state_16382[(2)]);
var state_16382__$1 = state_16382;
var statearr_16384_16409 = state_16382__$1;
(statearr_16384_16409[(2)] = inst_16378);

(statearr_16384_16409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16383 === (1))){
var state_16382__$1 = state_16382;
var statearr_16385_16410 = state_16382__$1;
(statearr_16385_16410[(2)] = null);

(statearr_16385_16410[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16383 === (4))){
var inst_16353 = (state_16382[(7)]);
var inst_16353__$1 = (state_16382[(2)]);
var inst_16354 = (inst_16353__$1 == null);
var state_16382__$1 = (function (){var statearr_16386 = state_16382;
(statearr_16386[(7)] = inst_16353__$1);

return statearr_16386;
})();
if(cljs.core.truth_(inst_16354)){
var statearr_16387_16411 = state_16382__$1;
(statearr_16387_16411[(1)] = (5));

} else {
var statearr_16388_16412 = state_16382__$1;
(statearr_16388_16412[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16383 === (6))){
var inst_16353 = (state_16382[(7)]);
var inst_16361 = cljs.core.nth.call(null,inst_16353,(0),null);
var inst_16362 = cljs.core.nth.call(null,inst_16353,(1),null);
var state_16382__$1 = (function (){var statearr_16389 = state_16382;
(statearr_16389[(8)] = inst_16361);

(statearr_16389[(9)] = inst_16362);

return statearr_16389;
})();
var statearr_16390_16413 = state_16382__$1;
(statearr_16390_16413[(2)] = null);

(statearr_16390_16413[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16383 === (3))){
var inst_16380 = (state_16382[(2)]);
var state_16382__$1 = state_16382;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16382__$1,inst_16380);
} else {
if((state_val_16383 === (2))){
var state_16382__$1 = state_16382;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16382__$1,(4),pub_chan);
} else {
if((state_val_16383 === (11))){
var _ = (function (){var statearr_16392 = state_16382;
(statearr_16392[(4)] = cljs.core.rest.call(null,(state_16382[(4)])));

return statearr_16392;
})();
var state_16382__$1 = state_16382;
var ex16391 = (state_16382__$1[(2)]);
var statearr_16393_16414 = state_16382__$1;
(statearr_16393_16414[(5)] = ex16391);


if((ex16391 instanceof Error)){
var statearr_16394_16415 = state_16382__$1;
(statearr_16394_16415[(1)] = (10));

(statearr_16394_16415[(5)] = null);

} else {
throw ex16391;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16383 === (9))){
var inst_16375 = (state_16382[(2)]);
var state_16382__$1 = (function (){var statearr_16395 = state_16382;
(statearr_16395[(10)] = inst_16375);

return statearr_16395;
})();
var statearr_16396_16416 = state_16382__$1;
(statearr_16396_16416[(2)] = null);

(statearr_16396_16416[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16383 === (5))){
var inst_16356 = fluree.db.util.log.info.call(null,"Web socket pub/producer channel closed.");
var state_16382__$1 = state_16382;
var statearr_16397_16417 = state_16382__$1;
(statearr_16397_16417[(2)] = inst_16356);

(statearr_16397_16417[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16383 === (10))){
var inst_16362 = (state_16382[(9)]);
var inst_16363 = (state_16382[(2)]);
var inst_16364 = fluree.db.util.log.error.call(null,inst_16363,"Websocket send message error:",inst_16363);
var inst_16365 = cljs.core.async.put_BANG_.call(null,inst_16362,false);
var state_16382__$1 = (function (){var statearr_16398 = state_16382;
(statearr_16398[(11)] = inst_16364);

return statearr_16398;
})();
var statearr_16399_16418 = state_16382__$1;
(statearr_16399_16418[(2)] = inst_16365);

(statearr_16399_16418[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16383 === (8))){
var inst_16361 = (state_16382[(8)]);
var inst_16362 = (state_16382[(9)]);
var _ = (function (){var statearr_16400 = state_16382;
(statearr_16400[(4)] = cljs.core.cons.call(null,(11),(state_16382[(4)])));

return statearr_16400;
})();
var inst_16371 = ws.send(inst_16361);
var inst_16372 = cljs.core.async.put_BANG_.call(null,inst_16362,true);
var ___$1 = (function (){var statearr_16401 = state_16382;
(statearr_16401[(4)] = cljs.core.rest.call(null,(state_16382[(4)])));

return statearr_16401;
})();
var state_16382__$1 = (function (){var statearr_16402 = state_16382;
(statearr_16402[(12)] = inst_16371);

return statearr_16402;
})();
var statearr_16403_16419 = state_16382__$1;
(statearr_16403_16419[(2)] = inst_16372);

(statearr_16403_16419[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto____0 = (function (){
var statearr_16404 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16404[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto__);

(statearr_16404[(1)] = (1));

return statearr_16404;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto____1 = (function (state_16382){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_16382);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e16405){var ex__2882__auto__ = e16405;
var statearr_16406_16420 = state_16382;
(statearr_16406_16420[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_16382[(4)]))){
var statearr_16407_16421 = state_16382;
(statearr_16407_16421[(1)] = cljs.core.first.call(null,(state_16382[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16422 = state_16382;
state_16382 = G__16422;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto__ = function(state_16382){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto____1.call(this,state_16382);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_16408 = f__2902__auto__.call(null);
(statearr_16408[(6)] = c__2901__auto__);

return statearr_16408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.call(null);
var timeout_chan = cljs.core.async.timeout.call(null,timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.call(null,open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.call(null,sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.call(null,"Websocket closed: ",e.reason,"Code: ",e.code);

return close_fn.call(null);
}));

var c__2901__auto___16461 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_16448){
var state_val_16449 = (state_16448[(1)]);
if((state_val_16449 === (1))){
var inst_16427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16428 = [open_QMARK_,timeout_chan];
var inst_16429 = (new cljs.core.PersistentVector(null,2,(5),inst_16427,inst_16428,null));
var state_16448__$1 = state_16448;
return cljs.core.async.ioc_alts_BANG_.call(null,state_16448__$1,(2),inst_16429,new cljs.core.Keyword(null,"priority","priority",1431093715),true);
} else {
if((state_val_16449 === (2))){
var inst_16431 = (state_16448[(2)]);
var inst_16432 = cljs.core.nth.call(null,inst_16431,(0),null);
var inst_16433 = cljs.core.nth.call(null,inst_16431,(1),null);
var inst_16434 = cljs.core._EQ_.call(null,inst_16433,timeout_chan);
var state_16448__$1 = (function (){var statearr_16450 = state_16448;
(statearr_16450[(7)] = inst_16432);

return statearr_16450;
})();
if(inst_16434){
var statearr_16451_16462 = state_16448__$1;
(statearr_16451_16462[(1)] = (3));

} else {
var statearr_16452_16463 = state_16448__$1;
(statearr_16452_16463[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16449 === (3))){
var inst_16436 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_16437 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16438 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_16439 = cljs.core.PersistentHashMap.fromArrays(inst_16437,inst_16438);
var inst_16440 = cljs.core.ex_info.call(null,inst_16436,inst_16439);
var inst_16441 = cljs.core.async.put_BANG_.call(null,resp_chan,inst_16440);
var inst_16442 = fluree.db.util.xhttp.close_websocket.call(null,ws);
var state_16448__$1 = (function (){var statearr_16453 = state_16448;
(statearr_16453[(8)] = inst_16441);

return statearr_16453;
})();
var statearr_16454_16464 = state_16448__$1;
(statearr_16454_16464[(2)] = inst_16442);

(statearr_16454_16464[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16449 === (4))){
var inst_16444 = fluree.db.util.xhttp.socket_publish_loop.call(null,ws,pub_chan);
var state_16448__$1 = state_16448;
var statearr_16455_16465 = state_16448__$1;
(statearr_16455_16465[(2)] = inst_16444);

(statearr_16455_16465[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16449 === (5))){
var inst_16446 = (state_16448[(2)]);
var state_16448__$1 = state_16448;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16448__$1,inst_16446);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto____0 = (function (){
var statearr_16456 = [null,null,null,null,null,null,null,null,null];
(statearr_16456[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto__);

(statearr_16456[(1)] = (1));

return statearr_16456;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto____1 = (function (state_16448){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_16448);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e16457){var ex__2882__auto__ = e16457;
var statearr_16458_16466 = state_16448;
(statearr_16458_16466[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_16448[(4)]))){
var statearr_16459_16467 = state_16448;
(statearr_16459_16467[(1)] = cljs.core.first.call(null,(state_16448[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16468 = state_16448;
state_16448 = G__16468;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto__ = function(state_16448){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto____1.call(this,state_16448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_16460 = f__2902__auto__.call(null);
(statearr_16460[(6)] = c__2901__auto___16461);

return statearr_16460;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
