// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('flureenjs');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.crypto');
goog.require('fluree.db.api.query');
goog.require('fluree.db.api.ledger');
goog.require('fluree.db.auth');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.dbfunctions.fns');
goog.require('fluree.db.flake');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.operations');
goog.require('fluree.db.permissions');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.graphql_parser');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.sparql_parser');
goog.require('fluree.db.query.sql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('goog.string.format');
goog.require('cljs.nodejs');
goog.require('fluree.db.connection_js');
goog.require('fluree.db.api_js');
goog.require('cljs.js');
goog.require('cljs.analyzer');
goog.require('cljs.env');
goog.require('cljs.compiler');
cljs.nodejs.enable_util_print_BANG_.call(null);
flureenjs.init_state = (function flureenjs$init_state(state){
return cljs.core.assoc_in.call(null,state,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null)], null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"rename-macros","rename-macros",1076432512),new cljs.core.Keyword(null,"renames","renames",343278368),new cljs.core.Keyword(null,"use-macros","use-macros",-905638393),new cljs.core.Keyword(null,"excludes","excludes",-1791725945),new cljs.core.Keyword(null,"macros","macros",811339431),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"imports","imports",-1249933394),new cljs.core.Keyword(null,"requires","requires",-1201390927),new cljs.core.Keyword("cljs.spec","speced-vars","cljs.spec/speced-vars",1010010387),new cljs.core.Keyword(null,"uses","uses",232664692),new cljs.core.Keyword(null,"defs","defs",1398449717),new cljs.core.Keyword("cljs.spec","registry-ref","cljs.spec/registry-ref",-71711915),new cljs.core.Keyword(null,"require-macros","require-macros",707947416),new cljs.core.Keyword("cljs.analyzer","constants","cljs.analyzer/constants",1697083770),new cljs.core.Keyword(null,"doc","doc",1913296891)],[cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Symbol(null,"channel?","channel?",1465411494,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"<?","<?",-1929864530,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"go-try","go-try",1412345407,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 34, [new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),"null",new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),"null",new cljs.core.Symbol(null,"subs","subs",1453849536,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"dec","dec",-766002333,null),"null",new cljs.core.Symbol(null,"<","<",993667236,null),"null",new cljs.core.Symbol(null,"<=","<=",1244895369,null),"null",new cljs.core.Symbol(null,"*","*",345799209,null),"null",new cljs.core.Symbol(null,"min","min",2085523049,null),"null",new cljs.core.Symbol(null,"get","get",-971253014,null),"null",new cljs.core.Symbol(null,"empty?","empty?",76408555,null),"null",new cljs.core.Symbol(null,"quot","quot",-1125214196,null),"null",new cljs.core.Symbol(null,"not=","not=",1466536204,null),"null",new cljs.core.Symbol(null,"rand","rand",-1745930995,null),"null",new cljs.core.Symbol(null,">",">",1085014381,null),"null",new cljs.core.Symbol(null,"mod","mod",1510044207,null),"null",new cljs.core.Symbol(null,"-","-",-471816912,null),"null",new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),"null",new cljs.core.Symbol(null,"or","or",1876275696,null),"null",new cljs.core.Symbol(null,"rem","rem",664046770,null),"null",new cljs.core.Symbol(null,"nth","nth",1529209554,null),"null",new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),"null",new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),"null",new cljs.core.Symbol(null,"not","not",1044554643,null),"null",new cljs.core.Symbol(null,"/","/",-1371932971,null),"null",new cljs.core.Symbol(null,">=",">=",1016916022,null),"null",new cljs.core.Symbol(null,"inc","inc",324505433,null),"null",new cljs.core.Symbol(null,"+","+",-740910886,null),"null",new cljs.core.Symbol(null,"str","str",-1564826950,null),"null",new cljs.core.Symbol(null,"max","max",1701898075,null),"null",new cljs.core.Symbol(null,"==","==",-234118149,null),"null",new cljs.core.Symbol(null,"count","count",-514511684,null),"null",new cljs.core.Symbol(null,"and","and",668631710,null),"null",new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),"null"], null), null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block.",new cljs.core.Keyword(null,"line","line",212345235),12,new cljs.core.Keyword(null,"column","column",2078222095),1,new cljs.core.Keyword(null,"file","file",-1269645878),"fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Keyword(null,"macro","macro",-867863404),true], null)], null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Symbol(null,"json","json",-1374467199,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"log","log",45015523,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fdb","fdb",-1644172664,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"util","util",1147903249,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null)],[new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.log","fluree.db.util.log",598709551,null),new cljs.core.Symbol(null,"fluree.db.util.core","fluree.db.util.core",-924508158,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.internal","fluree.db.dbfunctions.internal",-1962008394,null),new cljs.core.Symbol(null,"fluree.db.util.json","fluree.db.util.json",1183102298,null)]),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"channel?","channel?",1465411494,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.with_meta(new cljs.core.Symbol(null,"uuid","uuid",-504564192,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a random number, seed is either provided or a we use the txn instant",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"max-pred-val","max-pred-val",-1898501472,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Finds the maximum predicate value.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10, plus fuel cost."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"contains?","contains?",-1676812576,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if key is present.",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null))))], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"subs","subs",1453849536,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(30)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"query","query",352022017,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Executes a query",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Fuel required for query"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the flakes from the current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerce to boolean. Everything except false and nil is true.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"dec","dec",-766002333,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Decrements any number (or nil/null) by 1.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"<","<",993667236,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"floor","floor",-772394748,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes the floor of a number",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?o","?o",-1814741084,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the object of an predicate from the current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(1)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?sid","?sid",-778261371,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current subject id",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"objF","objF",-104129083,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the summed object of all false flakes",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"ceil","ceil",-184398425,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes the ceiling of a number",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"add-stack","add-stack",1221952039,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Adds an entry to the current stack."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"<=","<=",1244895369,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"*","*",345799209,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns product of all the numbers in the sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in *"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"min","min",2085523049,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets min value from a sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get","get",-971253014,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets a value from an subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?pO","?pO",1714537515,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the most recent object of an predicate, as of the previous block",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 plus fuel cost"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"empty?","empty?",76408555,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"True if empty or #{nil}, else false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"quot","quot",-1125214196,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Quot[ient] of dividing numerator by denominator.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"now","now",-9994004,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns current epoch milliseconds on the executing machine.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if two (or more) values are not equal.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"raise","raise",1824672588,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Throws an exception with the provided message."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"if-else","if-else",-1675068243,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Evaluates test.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"rand","rand",-1745930995,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a random number, seed is either provided or a we use the txn instant",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,">",">",1085014381,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"mod","mod",1510044207,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Modulus of num and div. Truncates toward negative infinity.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"lower-case","lower-case",1428172944,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Makes string lower case",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"-","-",-471816912,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns difference of all the numbers in the sequence with the first number as the minuend.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in -"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"hash-set","hash-set",-1145168432,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a hash-set of values",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of items in hash-set"], null)))),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"or","or",1876275696,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if any in the sequence are true, else returns false",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Count of objects in or"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"valid-email?","valid-email?",-1587437519,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Determines whether an email is valid, based on its pattern",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"coerce-args","coerce-args",494321873,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?s","?s",456183954,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current subject.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"rem","rem",664046770,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Remainder of dividing numerator by denominator.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nth","nth",1529209554,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the nth item in a collection",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of objects in collection"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"nil?","nil?",1612038930,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"True if nil, else false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"cas","cas",1188988307,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Does a compare and set/swap operation as a transaction function.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(20)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"re-find","re-find",1143444147,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Execute a re-find operation of regex pattern on provided string.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"not","not",1044554643,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Takes a boolean, true returns false, false returns true.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"/","/",-1371932971,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in /",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,">=",">=",1016916022,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"upper-case","upper-case",1427515769,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Makes string upper-case",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"inc","inc",324505433,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Increments any number (or nil/null) by 1.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"+","+",-740910886,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns sum of each argument.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in +"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"str","str",-1564826950,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Concatenates all in sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"objT","objT",1212205659,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets the summed object of all true flakes",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets max value from a sequence.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"==","==",-234118149,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Return true if arguments in sequence equal each other.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + number of arguments."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"count","count",-514511684,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of objects in count"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get-all","get-all",-567116420,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Follows an subject down the provided path and returns a set of all matching subjects.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + length of path"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?p","?p",-10896580,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current predicate predicates",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"stack","stack",847125597,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the current stack."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?auth_id","?auth_id",612691741,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current auth _id.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"extract","extract",399446909,null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block."], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?user_id","?user_id",-101968770,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current user _id.",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"relationship?","relationship?",1461608766,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Determines whether there is a relationship between two subjects",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"10, plus fuel cost"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"and","and",668631710,null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if all in a sequence are true, else returns false",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Count of objects in and"], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"?pid","?pid",1629644191,null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Gets current predicate id",new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null)),cljs.core.with_meta(new cljs.core.Symbol(null,"get-in","get-in",-1965644065,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the value of a nested structure",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Length of path"], null))))], null))],[cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,777,null,777,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","uuid","fluree.db.dbfunctions.fns/uuid",1199900311,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,777,null,new cljs.core.Symbol(null,"any","any",-948528346,null),777,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,7,521,null,521,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),"Finds the maximum predicate value.","10, plus fuel cost."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","max-pred-val","fluree.db.dbfunctions.fns/max-pred-val",884898813,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null)),null,cljs.core.list(null,null),1,false,521,null,new cljs.core.Symbol(null,"any","any",-948528346,null),521,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pred-name","pred-name",1636854076,null)], null))),"Finds the maximum predicate value.","10, plus fuel cost."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),347,new cljs.core.Keyword(null,"column","column",2078222095),7,new cljs.core.Keyword(null,"end-line","end-line",1837326455),347,new cljs.core.Keyword(null,"end-column","end-column",1425389514),16,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if key is present.",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null))))], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","contains?","fluree.db.dbfunctions.fns/contains?",979635755,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),null,cljs.core.list(null,null),1,false,347,new cljs.core.Symbol(null,"any","any",-948528346,null),347,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns true if key is present.",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),(10)], null))))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,133,null,133,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(30)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","subs","fluree.db.dbfunctions.fns/subs",815704759,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),null,cljs.core.list(null,null),1,false,133,null,new cljs.core.Symbol(null,"any","any",-948528346,null),133,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(30)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,479,null,479,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null))),"Executes a query","Fuel required for query"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","query","fluree.db.dbfunctions.fns/query",2131906892,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),6,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)], null),null,6,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),6,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),479,null,479,6,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"query-map","query-map",831954555,null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"select","select",-1506602266,null),new cljs.core.Symbol(null,"from","from",-839142725,null),new cljs.core.Symbol(null,"where","where",-404264438,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"limit","limit",284709164,null)], null)),"Executes a query","Fuel required for query"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,7,750,null,750,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the flakes from the current subject.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","flakes","fluree.db.dbfunctions.fns/flakes",2105901429,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,750,null,new cljs.core.Symbol(null,"any","any",-948528346,null),750,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the flakes from the current subject.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,659,null,659,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Coerce to boolean. Everything except false and nil is true.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","boolean","fluree.db.dbfunctions.fns/boolean",831125140,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null)),null,cljs.core.list(null,null),1,false,659,null,new cljs.core.Symbol(null,"any","any",-948528346,null),659,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"x","x",-555367584,null)], null))),"Coerce to boolean. Everything except false and nil is true.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,545,null,545,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Decrements any number (or nil/null) by 1.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","dec","fluree.db.dbfunctions.fns/dec",2016365502,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),1,false,545,null,new cljs.core.Symbol(null,"any","any",-948528346,null),545,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Decrements any number (or nil/null) by 1.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,401,null,401,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically increasing order, otherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<","fluree.db.dbfunctions.fns/<",-518653073,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),401,null,new cljs.core.Symbol(null,"any","any",-948528346,null),401,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,7,799,null,799,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the floor of a number",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","floor","fluree.db.dbfunctions.fns/floor",2077352177,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),null,cljs.core.list(null,null),1,false,799,null,new cljs.core.Symbol(null,"any","any",-948528346,null),799,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the floor of a number",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,7,288,null,288,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the object of an predicate from the current subject.",(1)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?o","fluree.db.dbfunctions.fns/?o",2112743665,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,288,null,new cljs.core.Symbol(null,"any","any",-948528346,null),288,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the object of an predicate from the current subject.",(1)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,169,null,169,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current subject id",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?sid","fluree.db.dbfunctions.fns/?sid",-1145594406,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,169,null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null"], null), null),169,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current subject id",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,738,null,738,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all false flakes",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","objF","fluree.db.dbfunctions.fns/objF",1608830606,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,738,null,new cljs.core.Symbol(null,"any","any",-948528346,null),738,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all false flakes",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,787,null,787,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the ceiling of a number",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","ceil","fluree.db.dbfunctions.fns/ceil",-1898210568,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null)),null,cljs.core.list(null,null),1,false,787,null,new cljs.core.Symbol(null,"any","any",-948528346,null),787,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"num","num",-669195096,null)], null))),"Takes the ceiling of a number",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),39,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),39,new cljs.core.Keyword(null,"end-column","end-column",1425389514),17,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Adds an entry to the current stack."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","add-stack","fluree.db.dbfunctions.fns/add-stack",-218303854,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null)),null,cljs.core.list(null,null),1,false,39,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [null,"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null"], null), null),39,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"entry","entry",2145700350,null)], null))),"Adds an entry to the current stack."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,414,null,414,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<=","fluree.db.dbfunctions.fns/<=",-535009166,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),414,null,new cljs.core.Symbol(null,"any","any",-948528346,null),414,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,594,null,594,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns product of all the numbers in the sequence.","9 + count of numbers in *"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","*","fluree.db.dbfunctions.fns/*",1333037714,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),594,null,new cljs.core.Symbol(null,"any","any",-948528346,null),594,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns product of all the numbers in the sequence.","9 + count of numbers in *"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,466,null,466,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Gets min value from a sequence.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","min","fluree.db.dbfunctions.fns/min",-1032470830,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),466,null,new cljs.core.Symbol(null,"any","any",-948528346,null),466,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets min value from a sequence.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,270,null,270,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),"Gets a value from an subject.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get","fluree.db.dbfunctions.fns/get",1827842903,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null)),null,cljs.core.list(null,null),1,false,270,null,new cljs.core.Symbol(null,"any","any",-948528346,null),270,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"pred","pred",-727012372,null)], null))),"Gets a value from an subject.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,300,null,300,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the most recent object of an predicate, as of the previous block","10 plus fuel cost"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pO","fluree.db.dbfunctions.fns/?pO",-2142759792,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,300,null,new cljs.core.Symbol(null,"any","any",-948528346,null),300,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the most recent object of an predicate, as of the previous block","10 plus fuel cost"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,7,109,null,109,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if empty or #{nil}, else false.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","empty?","fluree.db.dbfunctions.fns/empty?",-487925850,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,109,null,new cljs.core.Symbol(null,"any","any",-948528346,null),109,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if empty or #{nil}, else false.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,620,null,620,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Quot[ient] of dividing numerator by denominator.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","quot","fluree.db.dbfunctions.fns/quot",1725032899,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,620,null,new cljs.core.Symbol(null,"any","any",-948528346,null),620,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Quot[ient] of dividing numerator by denominator.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,558,null,558,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns current epoch milliseconds on the executing machine.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","now","fluree.db.dbfunctions.fns/now",1494134809,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,558,null,new cljs.core.Symbol(null,"any","any",-948528346,null),558,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns current epoch milliseconds on the executing machine.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,440,null,440,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if two (or more) values are not equal.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","not=","fluree.db.dbfunctions.fns/not=",-1186054057,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),440,null,new cljs.core.Symbol(null,"any","any",-948528346,null),440,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if two (or more) values are not equal.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),50,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),50,new cljs.core.Keyword(null,"end-column","end-column",1425389514),13,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Throws an exception with the provided message."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","raise","fluree.db.dbfunctions.fns/raise",-2030365545,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null)),null,cljs.core.list(null,null),1,false,50,new cljs.core.Symbol(null,"ignore","ignore",8989494,null),50,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"msg","msg",254428083,null)], null))),"Throws an exception with the provided message."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,73,null,73,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),"Evaluates test.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","if-else","fluree.db.dbfunctions.fns/if-else",-1024242186,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null)),null,cljs.core.list(null,null),1,false,73,null,new cljs.core.Symbol(null,"any","any",-948528346,null),73,4,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"test","test",-2076896892,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"f","f",43394975,null)], null))),"Evaluates test.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,762,null,762,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null))),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","rand","fluree.db.dbfunctions.fns/rand",805823682,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),3,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)], null),null,3,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),3,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),762,null,762,3,true,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"max","max",1701898075,null),new cljs.core.Symbol(null,"seed","seed",1709144854,null)], null)),"Returns a random number, seed is either provided or a we use the txn instant",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,388,null,388,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns",">","fluree.db.dbfunctions.fns/>",-23637352,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),388,null,new cljs.core.Symbol(null,"any","any",-948528346,null),388,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,633,null,633,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Modulus of num and div. Truncates toward negative infinity.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","mod","fluree.db.dbfunctions.fns/mod",-198597254,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,633,null,new cljs.core.Symbol(null,"any","any",-948528346,null),633,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Modulus of num and div. Truncates toward negative infinity.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,7,145,null,145,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string lower case",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","lower-case","fluree.db.dbfunctions.fns/lower-case",-442259,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),null,cljs.core.list(null,null),1,false,145,null,new cljs.core.Symbol(null,"any","any",-948528346,null),145,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string lower case",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,581,null,581,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns difference of all the numbers in the sequence with the first number as the minuend.","9 + count of numbers in -"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","-","fluree.db.dbfunctions.fns/-",-1982229401,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),581,null,new cljs.core.Symbol(null,"any","any",-948528346,null),581,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.","9 + count of numbers in -"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),361,new cljs.core.Keyword(null,"column","column",2078222095),7,new cljs.core.Keyword(null,"end-line","end-line",1837326455),361,new cljs.core.Keyword(null,"end-column","end-column",1425389514),15,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns a hash-set of values",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of items in hash-set"], null)))),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null)], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","hash-set","fluree.db.dbfunctions.fns/hash-set",-1047040869,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),361,new cljs.core.Symbol(null,"any","any",-948528346,null),361,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,243,null,243,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if any in the sequence are true, else returns false","Count of objects in or"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","or","fluree.db.dbfunctions.fns/or",-919667013,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),243,null,new cljs.core.Symbol(null,"any","any",-948528346,null),243,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if any in the sequence are true, else returns false","Count of objects in or"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,7,684,null,684,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),"Determines whether an email is valid, based on its pattern",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","valid-email?","fluree.db.dbfunctions.fns/valid-email?",110711142,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null)),null,cljs.core.list(null,null),1,false,684,null,new cljs.core.Symbol(null,"any","any",-948528346,null),684,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"email","email",-1238619063,null)], null))),"Determines whether an email is valid, based on its pattern",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),20,new cljs.core.Keyword(null,"column","column",2078222095),8,new cljs.core.Keyword(null,"end-line","end-line",1837326455),20,new cljs.core.Keyword(null,"end-column","end-column",1425389514),19,new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."], null),true,new cljs.core.Symbol("fluree.db.dbfunctions.fns","coerce-args","fluree.db.dbfunctions.fns/coerce-args",1196396954,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),null,cljs.core.list(null,null),1,false,20,new cljs.core.Symbol(null,"any","any",-948528346,null),20,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Coerces args that may be core async channels into values.\n  Returns exception instead of args if any exception occurs during resolution."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,201,null,201,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),"Gets current subject.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?s","fluree.db.dbfunctions.fns/?s",-1324621735,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),null,2,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),201,null,201,2,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current subject.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,646,null,646,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Remainder of dividing numerator by denominator.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","rem","fluree.db.dbfunctions.fns/rem",1237147007,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null)),null,cljs.core.list(null,null),1,false,646,null,new cljs.core.Symbol(null,"any","any",-948528346,null),646,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null),new cljs.core.Symbol(null,"d","d",-682293345,null)], null))),"Remainder of dividing numerator by denominator.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,58,null,58,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns the nth item in a collection","9 + count of objects in collection"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","nth","fluree.db.dbfunctions.fns/nth",-246664273,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null)),null,cljs.core.list(null,null),1,false,58,null,new cljs.core.Symbol(null,"any","any",-948528346,null),58,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null),new cljs.core.Symbol(null,"key","key",124488940,null)], null))),"Returns the nth item in a collection","9 + count of objects in collection"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,86,null,86,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if nil, else false.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","nil?","fluree.db.dbfunctions.fns/nil?",-1144188177,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,86,null,new cljs.core.Symbol(null,"any","any",-948528346,null),86,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"True if nil, else false.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,811,null,811,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),"Does a compare and set/swap operation as a transaction function.",(20)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","cas","fluree.db.dbfunctions.fns/cas",-1666886306,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null)),null,cljs.core.list(null,null),1,false,811,null,new cljs.core.Symbol(null,"any","any",-948528346,null),811,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"compare-val","compare-val",-1213904434,null),new cljs.core.Symbol(null,"new-val","new-val",902372928,null)], null))),"Does a compare and set/swap operation as a transaction function.",(20)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,671,null,671,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),"Execute a re-find operation of regex pattern on provided string.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","re-find","fluree.db.dbfunctions.fns/re-find",-1361091826,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null)),null,cljs.core.list(null,null),1,false,671,null,new cljs.core.Symbol(null,"any","any",-948528346,null),671,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"pattern","pattern",1882666950,null),new cljs.core.Symbol(null,"string","string",-349010059,null)], null))),"Execute a re-find operation of regex pattern on provided string.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,98,null,98,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"Takes a boolean, true returns false, false returns true.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","not","fluree.db.dbfunctions.fns/not",-1684442274,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null)),null,cljs.core.list(null,null),1,false,98,null,new cljs.core.Symbol(null,"any","any",-948528346,null),98,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"arg","arg",-106730310,null)], null))),"Takes a boolean, true returns false, false returns true.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"9 + count of numbers in /",new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.Keyword(null,"file","file",-1269645878),null], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","/","fluree.db.dbfunctions.fns//",1439768862,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),607,null,new cljs.core.Symbol(null,"any","any",-948528346,null),(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence","9 + count of numbers in /"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,427,null,427,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns",">=","fluree.db.dbfunctions.fns/>=",-1771718525,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),427,null,new cljs.core.Symbol(null,"any","any",-948528346,null),427,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,7,157,null,157,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string upper-case",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","upper-case","fluree.db.dbfunctions.fns/upper-case",-210929244,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null)),null,cljs.core.list(null,null),1,false,157,null,new cljs.core.Symbol(null,"any","any",-948528346,null),157,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"str","str",-1564826950,null)], null))),"Makes string upper-case",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,7,533,null,533,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Increments any number (or nil/null) by 1.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","inc","fluree.db.dbfunctions.fns/inc",1299152788,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null)),null,cljs.core.list(null,null),1,false,533,null,new cljs.core.Symbol(null,"any","any",-948528346,null),533,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"n","n",-2092305744,null)], null))),"Increments any number (or nil/null) by 1.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,568,null,568,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns sum of each argument.","9 + count of numbers in +"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","+","fluree.db.dbfunctions.fns/+",1979608855,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),568,null,new cljs.core.Symbol(null,"any","any",-948528346,null),568,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns sum of each argument.","9 + count of numbers in +"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,121,null,121,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Concatenates all in sequence.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","str","fluree.db.dbfunctions.fns/str",215086055,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),121,null,new cljs.core.Symbol(null,"any","any",-948528346,null),121,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Concatenates all in sequence.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,726,null,726,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all true flakes",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","objT","fluree.db.dbfunctions.fns/objT",308919174,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,726,null,new cljs.core.Symbol(null,"any","any",-948528346,null),726,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets the summed object of all true flakes",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,453,null,453,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Gets max value from a sequence.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","max","fluree.db.dbfunctions.fns/max",-821447668,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),453,null,new cljs.core.Symbol(null,"any","any",-948528346,null),453,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Gets max value from a sequence.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,375,null,375,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Return true if arguments in sequence equal each other.","9 + number of arguments."]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","==","fluree.db.dbfunctions.fns/==",1478685734,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),375,null,new cljs.core.Symbol(null,"any","any",-948528346,null),375,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Return true if arguments in sequence equal each other.","9 + number of arguments."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,7,256,null,256,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps","9 + count of objects in count"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","count","fluree.db.dbfunctions.fns/count",1267596361,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null)),null,cljs.core.list(null,null),1,false,256,null,new cljs.core.Symbol(null,"any","any",-948528346,null),256,2,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null))),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps","9 + count of objects in count"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,7,313,null,313,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Follows an subject down the provided path and returns a set of all matching subjects.","9 + length of path"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-all","fluree.db.dbfunctions.fns/get-all",1682787369,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),null,cljs.core.list(null,null),1,false,313,null,new cljs.core.Symbol(null,"any","any",-948528346,null),313,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null))),"Follows an subject down the provided path and returns a set of all matching subjects.","9 + length of path"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),7,214,null,214,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null))),"Gets current predicate predicates","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?p","fluree.db.dbfunctions.fns/?p",1090611913,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),2,new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)], null),null,2,cljs.core.list(null,null),1,false,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),2,new cljs.core.Keyword(null,"variadic?","variadic?",584179762),false,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),214,null,214,2,true,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"additional-select","additional-select",794520732,null)], null)),"Gets current predicate predicates","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),33,new cljs.core.Keyword(null,"column","column",2078222095),7,new cljs.core.Keyword(null,"end-line","end-line",1837326455),33,new cljs.core.Keyword(null,"end-column","end-column",1425389514),12,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the current stack."], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","stack","fluree.db.dbfunctions.fns/stack",-729322264,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,33,new cljs.core.Symbol(null,"any","any",-948528346,null),33,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Returns the current stack."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,7,714,null,714,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current auth _id.",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?auth_id","fluree.db.dbfunctions.fns/?auth_id",-1900200218,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,714,null,new cljs.core.Symbol(null,"any","any",-948528346,null),714,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current auth _id.",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"macro","macro",-867863404),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891)],[null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),12,new cljs.core.Keyword(null,"column","column",2078222095),11,new cljs.core.Keyword(null,"end-line","end-line",1837326455),12,new cljs.core.Keyword(null,"end-column","end-column",1425389514),18,new cljs.core.Keyword(null,"macro","macro",-867863404),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Resolves a value if a channel.\n  Must be used inside of a go-block."], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","extract","fluree.db.dbfunctions.fns/extract",-1458126328,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",18,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"&form","&form",1482799337,null),new cljs.core.Symbol(null,"&env","&env",-919163083,null),new cljs.core.Symbol(null,"v","v",1661996586,null)], null)),null,cljs.core.list(null,null),1,false,12,true,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),"null",new cljs.core.Symbol("cljs.core","IList","cljs.core/IList",1015168964,null),"null"], null), null),12,3,false,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"v","v",1661996586,null)], null))),"Resolves a value if a channel.\n  Must be used inside of a go-block."]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,7,696,null,696,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current user _id.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?user_id","fluree.db.dbfunctions.fns/?user_id",599092011,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,696,null,new cljs.core.Symbol(null,"any","any",-948528346,null),696,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current user _id.","10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,7,506,null,506,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),"Determines whether there is a relationship between two subjects","10, plus fuel cost"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","relationship?","fluree.db.dbfunctions.fns/relationship?",-46706197,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null)),null,cljs.core.list(null,null),1,false,506,null,new cljs.core.Symbol(null,"any","any",-948528346,null),506,4,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"startSubject","startSubject",1232729714,null),new cljs.core.Symbol(null,"path","path",1452340359,null),new cljs.core.Symbol(null,"endSubject","endSubject",-458079393,null)], null))),"Determines whether there is a relationship between two subjects","10, plus fuel cost"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"methods","methods",453930866),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"top-fn","top-fn",-2056129173),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),7,230,null,230,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null))),"Returns true if all in a sequence are true, else returns false","Count of objects in and"]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","and","fluree.db.dbfunctions.fns/and",2113043921,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),(1),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),cljs.core.list(null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"args","args",-1338879193,null))], null),null,(1),cljs.core.list(null),1,true,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869),(1),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),true,new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol(null,"any","any",-948528346,null)], null)], null),230,null,new cljs.core.Symbol(null,"any","any",-948528346,null),230,(1),true,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"&","&",-2144855648,null),new cljs.core.Symbol(null,"args","args",-1338879193,null)], null)),"Returns true if all in a sequence are true, else returns false","Count of objects in and"]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],[null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315)],["/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,7,188,null,188,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current predicate id",(10)]),new cljs.core.Symbol("fluree.db.dbfunctions.fns","?pid","fluree.db.dbfunctions.fns/?pid",-1962601142,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null)),null,cljs.core.list(null,null),1,false,188,null,new cljs.core.Symbol(null,"any","any",-948528346,null),188,1,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null)], null))),"Gets current predicate id",(10)]),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556),new cljs.core.Keyword(null,"meta","meta",1499536964),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"method-params","method-params",-980792179),new cljs.core.Keyword(null,"protocol-impl","protocol-impl",2101328365),new cljs.core.Keyword(null,"arglists-meta","arglists-meta",1944829838),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"variadic?","variadic?",584179762),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"ret-tag","ret-tag",1705919990),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),new cljs.core.Keyword(null,"fn-var","fn-var",1086204730),new cljs.core.Keyword(null,"arglists","arglists",1661989754)],[null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"file","file",-1269645878),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.Keyword(null,"line","line",212345235),332,new cljs.core.Keyword(null,"column","column",2078222095),7,new cljs.core.Keyword(null,"end-line","end-line",1837326455),332,new cljs.core.Keyword(null,"end-column","end-column",1425389514),13,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the value of a nested structure",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Length of path"], null))))], null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","get-in","fluree.db.dbfunctions.fns/get-in",821000586,null),"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null)),null,cljs.core.list(null,null),1,false,332,new cljs.core.Symbol(null,"any","any",-948528346,null),332,3,true,cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"?ctx","?ctx",429619575,null),new cljs.core.Symbol(null,"subject","subject",228651076,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"doc","doc",1913296891),"Returns the value of a nested structure",new cljs.core.Keyword("fdb","spec","fdb/spec",346638389),null,new cljs.core.Keyword("fdb","cost","fdb/cost",-1094749315),"Length of path"], null))))])]),cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"fluree.db.dbfunctions.fns","fluree.db.dbfunctions.fns",-165809281,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null),new cljs.core.Symbol(null,"fluree.db.util.async","fluree.db.util.async",-2039227613,null)], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"seen","seen",-518999789),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 25, [new cljs.core.Keyword(null,"_id","_id",-789960287),"null",new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),"null",new cljs.core.Keyword(null,"o","o",-1350007228),"null",new cljs.core.Keyword(null,"spent","spent",-62769180),"null",new cljs.core.Keyword(null,"instant","instant",655498374),"null",new cljs.core.Keyword(null,"else","else",-1508377146),"null",new cljs.core.Keyword(null,"db","db",993250759),"null",new cljs.core.Keyword(null,"arguments","arguments",-1182834456),"null",new cljs.core.Keyword(null,"recur","recur",-437573268),"null",new cljs.core.Keyword(null,"state","state",-1988618099),"null",new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),"null",new cljs.core.Symbol(null,"if","if",1181717262,null),"null",new cljs.core.Keyword(null,"s","s",1705939918),"null",new cljs.core.Keyword(null,"function","function",-2127255473),"null",new cljs.core.Keyword(null,"pid","pid",1018387698),"null",new cljs.core.Keyword(null,"status","status",-1997798413),"null",new cljs.core.Keyword(null,"result","result",1415092211),"null",new cljs.core.Keyword(null,"credits","credits",785860820),"null",new cljs.core.Keyword(null,"stack","stack",-793405930),"null",new cljs.core.Keyword(null,"user_id","user_id",993497112),"null",new cljs.core.Keyword(null,"error","error",-978969032),"null",new cljs.core.Keyword(null,"flakes","flakes",1977895739),"null",new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),"null",new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),"null",new cljs.core.Keyword(null,"sid","sid",1815016414),"null"], null), null),new cljs.core.Keyword(null,"order","order",-1254677256),new cljs.core.PersistentVector(null, 25, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"if","if",1181717262,null),new cljs.core.Symbol("fluree.db.util.async","channel?","fluree.db.util.async/channel?",-2090639411,null),new cljs.core.Symbol("fluree.db.dbfunctions.fns","<?","fluree.db.dbfunctions.fns/<?",-489206821,null),new cljs.core.Keyword(null,"recur","recur",-437573268),new cljs.core.Keyword(null,"else","else",-1508377146),new cljs.core.Keyword(null,"stack","stack",-793405930),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"credits","credits",785860820),new cljs.core.Keyword(null,"spent","spent",-62769180),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799),new cljs.core.Keyword(null,"function","function",-2127255473),new cljs.core.Keyword(null,"arguments","arguments",-1182834456),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"sid","sid",1815016414),new cljs.core.Keyword(null,"s","s",1705939918),new cljs.core.Keyword(null,"_id","_id",-789960287),new cljs.core.Keyword(null,"pid","pid",1018387698),new cljs.core.Keyword(null,"o","o",-1350007228),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"auth_id","auth_id",1917762333),new cljs.core.Keyword(null,"user_id","user_id",993497112),new cljs.core.Keyword(null,"flakes","flakes",1977895739)], null)], null),null]));
});
flureenjs.nj_state = cljs.js.empty_state.call(null,flureenjs.init_state);
var st_69223 = flureenjs.nj_state;
(cljs.core._STAR_eval_STAR_ = (function (form){
var result = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"result","result",1415092211),null], null));
var form_str = ((typeof form === 'string')?form:cljs.core.str.cljs$core$IFn$_invoke$arity$1(form));
var name = "rtm";
var opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"eval","eval",-1103567905),cljs.js.js_eval,new cljs.core.Keyword(null,"ns","ns",441598760),cljs.core.find_ns.call(null,cljs.analyzer._STAR_cljs_ns_STAR_),new cljs.core.Keyword(null,"target","target",253001721),new cljs.core.Keyword(null,"nodejs","nodejs",321212524)], null);
var cb = (function (res){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res))){
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(res));
} else {
return cljs.core.swap_BANG_.call(null,result,cljs.core.assoc,new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(res));
}
});
cljs.js.eval_str.call(null,st_69223,form_str,name,opts,cb);

return new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,result));
}));
if((typeof flureenjs !== 'undefined') && (typeof flureenjs.app_state !== 'undefined')){
} else {
flureenjs.app_state = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"product","product",1363474257),"Fluree NodeJs Library",new cljs.core.Keyword(null,"version","version",425292698),"v1.0.0-rc16"], null));
}
cljs.core.println.call(null,new cljs.core.Keyword(null,"product","product",1363474257).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs.app_state)),new cljs.core.Keyword(null,"version","version",425292698).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,flureenjs.app_state)));
flureenjs.njs_crypto = (function (){try{return require("crypto");
}catch (e69224){var ex = e69224;
fluree.db.util.log.warn.call(null,["Error: Unable to access Node.js crypto module:",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ex)].join(''));

fluree.db.util.log.warn.call(null,"Private key generation is not available.");

return null;
}})();
fluree.db.util.log.set_level_BANG_.call(null,new cljs.core.Keyword(null,"warning","warning",-1685650671));
/**
 * Configure logging for Fluree processes.  Supported options:
 *   1. level [Values: severe, warning, info, config, fine, finer, finest]
 *   
 */
flureenjs.set_logging = (function flureenjs$set_logging(opts){
var opts_SINGLEQUOTE_ = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var map__69226 = opts_SINGLEQUOTE_;
var map__69226__$1 = (((((!((map__69226 == null))))?(((((map__69226.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__69226.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__69226):map__69226);
var level = cljs.core.get.call(null,map__69226__$1,new cljs.core.Keyword(null,"level","level",1290497552));
return fluree.db.util.log.set_level_BANG_.call(null,cljs.core.keyword.call(null,level));
});
goog.exportSymbol('flureenjs.set_logging', flureenjs.set_logging);
/**
 * Returns account id from either a public key or message and signature.
 */
flureenjs.account_id = (function flureenjs$account_id(var_args){
var G__69229 = arguments.length;
switch (G__69229) {
case 1:
return flureenjs.account_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return flureenjs.account_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.account_id', flureenjs.account_id);

(flureenjs.account_id.cljs$core$IFn$_invoke$arity$1 = (function (public_key){
return fluree.crypto.account_id_from_public.call(null,public_key);
}));

(flureenjs.account_id.cljs$core$IFn$_invoke$arity$2 = (function (message,signature){
return fluree.crypto.account_id_from_message.call(null,message,signature);
}));

(flureenjs.account_id.cljs$lang$maxFixedArity = 2);

/**
 * Takes an http request and creates an http signature using a private key
 */
flureenjs.http_signature = (function flureenjs$http_signature(var_args){
var G__69232 = arguments.length;
switch (G__69232) {
case 4:
return flureenjs.http_signature.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.http_signature.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.http_signature', flureenjs.http_signature);

(flureenjs.http_signature.cljs$core$IFn$_invoke$arity$4 = (function (req_method,url,request,private_key){
return flureenjs.http_signature.call(null,req_method,url,request,private_key,null);
}));

(flureenjs.http_signature.cljs$core$IFn$_invoke$arity$5 = (function (req_method,url,request,private_key,auth){
var request__$1 = cljs.core.js__GT_clj.call(null,request);
return fluree.db.query.http_signatures.sign_request.call(null,req_method,url,request__$1,private_key,auth);
}));

(flureenjs.http_signature.cljs$lang$maxFixedArity = 5);

/**
 * Returns a public key given a private key.
 */
flureenjs.public_key_from_private = (function flureenjs$public_key_from_private(private_key){
return fluree.crypto.pub_key_from_private.call(null,private_key);
});
goog.exportSymbol('flureenjs.public_key_from_private', flureenjs.public_key_from_private);
/**
 * Returns a public key from a message and a signature.
 */
flureenjs.public_key = (function flureenjs$public_key(message,signature){
return fluree.crypto.pub_key_from_message.call(null,message,signature);
});
goog.exportSymbol('flureenjs.public_key', flureenjs.public_key);
/**
 * Generates a private-public key pair using the Node.js
 *   crypto module. The JavaScript code looks like:
 * 
 *   const ecdh = crypto.createECDH('secp256k1');
 *   ecdh.generateKeys()
 *   return { private: ecdh.getPrivateKey('hex'),
 *            public:  ecdh.getPublicKey('hex','compressed')};
 *   
 */
flureenjs.generate_key_pair = (function flureenjs$generate_key_pair(){
if(cljs.core.truth_(flureenjs.njs_crypto)){
var ecdh = cljs.core.js_invoke.call(null,flureenjs.njs_crypto,"createECDH","secp256k1");
var _ = cljs.core.js_invoke.call(null,ecdh,"generateKeys");
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),cljs.core.js_invoke.call(null,ecdh,"getPrivateKey","hex"),new cljs.core.Keyword(null,"public","public",1566243851),cljs.core.js_invoke.call(null,ecdh,"getPublicKey","hex","compressed")], null);
} else {
throw "Node.js crypto module not accessible";
}
});
/**
 * Generates a new private key, returned in a map along with
 *   the public key and account id. Return keys are :public,
 *   :private, and :id.
 *   
 */
flureenjs.new_private_key = (function flureenjs$new_private_key(){
try{var kp = flureenjs.generate_key_pair.call(null);
var account = fluree.crypto.account_id_from_private.call(null,new cljs.core.Keyword(null,"private","private",-558947994).cljs$core$IFn$_invoke$arity$1(kp));
return cljs.core.assoc.call(null,kp,new cljs.core.Keyword(null,"id","id",-1388402092),account);
}catch (e69234){var e = e69234;
fluree.db.util.log.error.call(null,["Unable to generate private key. Error: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(e)].join(''));

throw e;
}});
goog.exportSymbol('flureenjs.new_private_key', flureenjs.new_private_key);
/**
 * Returns a signature for a message given provided private key.
 */
flureenjs.sign = (function flureenjs$sign(message,private_key){
return fluree.crypto.sign_message.call(null,message,private_key);
});
goog.exportSymbol('flureenjs.sign', flureenjs.sign);
/**
 * Sets a new default private key for the entire tx-group, network or db level.
 *   This will only succeed if signed by the default private key for the tx-group,
 *   or if setting for a dbid, either the tx-group or network.
 * 
 *   It will overwrite any existing default private key.
 * 
 *   It will respond with true or false.
 * 
 *   Returns promise that eventually contains the results. 
 */
flureenjs.set_default_key = (function flureenjs$set_default_key(var_args){
var G__69236 = arguments.length;
switch (G__69236) {
case 2:
return flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.set_default_key', flureenjs.set_default_key);

(flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$2 = (function (conn,private_key){
return flureenjs.set_default_key.call(null,conn,null,null,private_key,null);
}));

(flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$3 = (function (conn,network,private_key){
return flureenjs.set_default_key.call(null,conn,network,null,private_key,null);
}));

(flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,private_key){
return flureenjs.set_default_key.call(null,conn,network,dbid,private_key,null);
}));

(flureenjs.set_default_key.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,private_key,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_69312){
var state_val_69313 = (state_69312[(1)]);
if((state_val_69313 === (7))){
var state_69312__$1 = state_69312;
var statearr_69314_69368 = state_69312__$1;
(statearr_69314_69368[(2)] = false);

(statearr_69314_69368[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (20))){
var inst_69275 = (state_69312[(7)]);
var inst_69270 = (state_69312[(8)]);
var inst_69280 = (state_69312[(2)]);
var inst_69281 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"private-key","private-key",426483388),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_69282 = [new cljs.core.Keyword(null,"default-key","default-key",-2094960617),network,dbid,private_key,inst_69275,inst_69280];
var inst_69283 = cljs.core.PersistentHashMap.fromArrays(inst_69281,inst_69282);
var state_69312__$1 = (function (){var statearr_69315 = state_69312;
(statearr_69315[(9)] = inst_69283);

return statearr_69315;
})();
if(cljs.core.truth_(inst_69270)){
var statearr_69316_69369 = state_69312__$1;
(statearr_69316_69369[(1)] = (21));

} else {
var statearr_69317_69370 = state_69312__$1;
(statearr_69317_69370[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (27))){
var inst_69305 = (state_69312[(2)]);
var inst_69306 = cljs.core.clj__GT_js.call(null,inst_69305);
var inst_69307 = resolve.call(null,inst_69306);
var _ = (function (){var statearr_69318 = state_69312;
(statearr_69318[(4)] = cljs.core.rest.call(null,(state_69312[(4)])));

return statearr_69318;
})();
var state_69312__$1 = state_69312;
var statearr_69319_69371 = state_69312__$1;
(statearr_69319_69371[(2)] = inst_69307);

(statearr_69319_69371[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (1))){
var state_69312__$1 = state_69312;
var statearr_69320_69372 = state_69312__$1;
(statearr_69320_69372[(2)] = null);

(statearr_69320_69372[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (24))){
var inst_69289 = (state_69312[(10)]);
var inst_69270 = (state_69312[(8)]);
var inst_69291 = fluree.crypto.sign_message.call(null,inst_69289,inst_69270);
var state_69312__$1 = state_69312;
var statearr_69321_69373 = state_69312__$1;
(statearr_69321_69373[(2)] = inst_69291);

(statearr_69321_69373[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (4))){
var inst_69237 = (state_69312[(2)]);
var inst_69238 = fluree.db.util.log.error.call(null,inst_69237);
var inst_69239 = reject.call(null,inst_69237);
var state_69312__$1 = (function (){var statearr_69322 = state_69312;
(statearr_69322[(11)] = inst_69238);

return statearr_69322;
})();
var statearr_69323_69374 = state_69312__$1;
(statearr_69323_69374[(2)] = inst_69239);

(statearr_69323_69374[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (15))){
var inst_69268 = (state_69312[(12)]);
var state_69312__$1 = state_69312;
var statearr_69324_69375 = state_69312__$1;
(statearr_69324_69375[(2)] = inst_69268);

(statearr_69324_69375[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (21))){
var inst_69283 = (state_69312[(9)]);
var inst_69285 = fluree.db.util.core.without_nils.call(null,inst_69283);
var inst_69286 = fluree.db.util.json.stringify.call(null,inst_69285);
var state_69312__$1 = state_69312;
var statearr_69325_69376 = state_69312__$1;
(statearr_69325_69376[(2)] = inst_69286);

(statearr_69325_69376[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (13))){
var inst_69246 = (state_69312[(13)]);
var state_69312__$1 = state_69312;
var statearr_69326_69377 = state_69312__$1;
(statearr_69326_69377[(2)] = inst_69246);

(statearr_69326_69377[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (22))){
var state_69312__$1 = state_69312;
var statearr_69327_69378 = state_69312__$1;
(statearr_69327_69378[(2)] = null);

(statearr_69327_69378[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (29))){
var inst_69283 = (state_69312[(9)]);
var inst_69301 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_69283);
var state_69312__$1 = state_69312;
var statearr_69328_69379 = state_69312__$1;
(statearr_69328_69379[(2)] = inst_69301);

(statearr_69328_69379[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (6))){
var inst_69246 = (state_69312[(13)]);
var inst_69251 = inst_69246.cljs$lang$protocol_mask$partition0$;
var inst_69252 = (inst_69251 & (64));
var inst_69253 = inst_69246.cljs$core$ISeq$;
var inst_69254 = (cljs.core.PROTOCOL_SENTINEL === inst_69253);
var inst_69255 = ((inst_69252) || (inst_69254));
var state_69312__$1 = state_69312;
if(cljs.core.truth_(inst_69255)){
var statearr_69329_69380 = state_69312__$1;
(statearr_69329_69380[(1)] = (9));

} else {
var statearr_69330_69381 = state_69312__$1;
(statearr_69330_69381[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (28))){
var inst_69289 = (state_69312[(10)]);
var inst_69294 = (state_69312[(14)]);
var inst_69296 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_69297 = [inst_69289,inst_69294];
var inst_69298 = cljs.core.PersistentHashMap.fromArrays(inst_69296,inst_69297);
var inst_69299 = fluree.db.operations.command_async.call(null,conn,inst_69298);
var state_69312__$1 = state_69312;
var statearr_69331_69382 = state_69312__$1;
(statearr_69331_69382[(2)] = inst_69299);

(statearr_69331_69382[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (25))){
var state_69312__$1 = state_69312;
var statearr_69332_69383 = state_69312__$1;
(statearr_69332_69383[(2)] = null);

(statearr_69332_69383[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (17))){
var inst_69269 = (state_69312[(15)]);
var inst_69275 = (state_69312[(2)]);
var state_69312__$1 = (function (){var statearr_69333 = state_69312;
(statearr_69333[(7)] = inst_69275);

return statearr_69333;
})();
if(cljs.core.truth_(inst_69269)){
var statearr_69334_69384 = state_69312__$1;
(statearr_69334_69384[(1)] = (18));

} else {
var statearr_69335_69385 = state_69312__$1;
(statearr_69335_69385[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (3))){
var inst_69310 = (state_69312[(2)]);
var state_69312__$1 = state_69312;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69312__$1,inst_69310);
} else {
if((state_val_69313 === (12))){
var inst_69246 = (state_69312[(13)]);
var inst_69264 = cljs.core.apply.call(null,cljs.core.hash_map,inst_69246);
var state_69312__$1 = state_69312;
var statearr_69336_69386 = state_69312__$1;
(statearr_69336_69386[(2)] = inst_69264);

(statearr_69336_69386[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (2))){
var inst_69246 = (state_69312[(13)]);
var _ = (function (){var statearr_69337 = state_69312;
(statearr_69337[(4)] = cljs.core.cons.call(null,(5),(state_69312[(4)])));

return statearr_69337;
})();
var inst_69246__$1 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_69248 = (inst_69246__$1 == null);
var inst_69249 = cljs.core.not.call(null,inst_69248);
var state_69312__$1 = (function (){var statearr_69338 = state_69312;
(statearr_69338[(13)] = inst_69246__$1);

return statearr_69338;
})();
if(inst_69249){
var statearr_69339_69387 = state_69312__$1;
(statearr_69339_69387[(1)] = (6));

} else {
var statearr_69340_69388 = state_69312__$1;
(statearr_69340_69388[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (23))){
var inst_69270 = (state_69312[(8)]);
var inst_69289 = (state_69312[(2)]);
var state_69312__$1 = (function (){var statearr_69341 = state_69312;
(statearr_69341[(10)] = inst_69289);

return statearr_69341;
})();
if(cljs.core.truth_(inst_69270)){
var statearr_69342_69389 = state_69312__$1;
(statearr_69342_69389[(1)] = (24));

} else {
var statearr_69343_69390 = state_69312__$1;
(statearr_69343_69390[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (19))){
var inst_69271 = (state_69312[(16)]);
var inst_69278 = (inst_69271 + (30000));
var state_69312__$1 = state_69312;
var statearr_69344_69391 = state_69312__$1;
(statearr_69344_69391[(2)] = inst_69278);

(statearr_69344_69391[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (11))){
var inst_69259 = (state_69312[(2)]);
var state_69312__$1 = state_69312;
var statearr_69346_69392 = state_69312__$1;
(statearr_69346_69392[(2)] = inst_69259);

(statearr_69346_69392[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (9))){
var state_69312__$1 = state_69312;
var statearr_69347_69393 = state_69312__$1;
(statearr_69347_69393[(2)] = true);

(statearr_69347_69393[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (5))){
var _ = (function (){var statearr_69348 = state_69312;
(statearr_69348[(4)] = cljs.core.rest.call(null,(state_69312[(4)])));

return statearr_69348;
})();
var state_69312__$1 = state_69312;
var ex69345 = (state_69312__$1[(2)]);
var statearr_69349_69394 = state_69312__$1;
(statearr_69349_69394[(5)] = ex69345);


var statearr_69350_69395 = state_69312__$1;
(statearr_69350_69395[(1)] = (4));

(statearr_69350_69395[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (14))){
var inst_69268 = (state_69312[(12)]);
var inst_69267 = (state_69312[(2)]);
var inst_69268__$1 = cljs.core.get.call(null,inst_69267,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_69269 = cljs.core.get.call(null,inst_69267,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_69270 = cljs.core.get.call(null,inst_69267,new cljs.core.Keyword(null,"signing-key","signing-key",1285642632));
var inst_69271 = fluree.db.util.core.current_time_millis.call(null);
var state_69312__$1 = (function (){var statearr_69351 = state_69312;
(statearr_69351[(16)] = inst_69271);

(statearr_69351[(12)] = inst_69268__$1);

(statearr_69351[(15)] = inst_69269);

(statearr_69351[(8)] = inst_69270);

return statearr_69351;
})();
if(cljs.core.truth_(inst_69268__$1)){
var statearr_69352_69396 = state_69312__$1;
(statearr_69352_69396[(1)] = (15));

} else {
var statearr_69353_69397 = state_69312__$1;
(statearr_69353_69397[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (26))){
var inst_69270 = (state_69312[(8)]);
var inst_69294 = (state_69312[(2)]);
var state_69312__$1 = (function (){var statearr_69354 = state_69312;
(statearr_69354[(14)] = inst_69294);

return statearr_69354;
})();
if(cljs.core.truth_(inst_69270)){
var statearr_69355_69398 = state_69312__$1;
(statearr_69355_69398[(1)] = (28));

} else {
var statearr_69356_69399 = state_69312__$1;
(statearr_69356_69399[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (16))){
var inst_69271 = (state_69312[(16)]);
var state_69312__$1 = state_69312;
var statearr_69357_69400 = state_69312__$1;
(statearr_69357_69400[(2)] = inst_69271);

(statearr_69357_69400[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (30))){
var inst_69303 = (state_69312[(2)]);
var state_69312__$1 = state_69312;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69312__$1,(27),inst_69303);
} else {
if((state_val_69313 === (10))){
var state_69312__$1 = state_69312;
var statearr_69358_69401 = state_69312__$1;
(statearr_69358_69401[(2)] = false);

(statearr_69358_69401[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (18))){
var inst_69269 = (state_69312[(15)]);
var state_69312__$1 = state_69312;
var statearr_69359_69402 = state_69312__$1;
(statearr_69359_69402[(2)] = inst_69269);

(statearr_69359_69402[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69313 === (8))){
var inst_69262 = (state_69312[(2)]);
var state_69312__$1 = state_69312;
if(cljs.core.truth_(inst_69262)){
var statearr_69360_69403 = state_69312__$1;
(statearr_69360_69403[(1)] = (12));

} else {
var statearr_69361_69404 = state_69312__$1;
(statearr_69361_69404[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2879__auto__ = null;
var flureenjs$state_machine__2879__auto____0 = (function (){
var statearr_69362 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69362[(0)] = flureenjs$state_machine__2879__auto__);

(statearr_69362[(1)] = (1));

return statearr_69362;
});
var flureenjs$state_machine__2879__auto____1 = (function (state_69312){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_69312);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e69363){var ex__2882__auto__ = e69363;
var statearr_69364_69405 = state_69312;
(statearr_69364_69405[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_69312[(4)]))){
var statearr_69365_69406 = state_69312;
(statearr_69365_69406[(1)] = cljs.core.first.call(null,(state_69312[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69407 = state_69312;
state_69312 = G__69407;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$state_machine__2879__auto__ = function(state_69312){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$state_machine__2879__auto____1.call(this,state_69312);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2879__auto____0;
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2879__auto____1;
return flureenjs$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_69366 = f__2902__auto__.call(null);
(statearr_69366[(6)] = c__2901__auto__);

return statearr_69366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureenjs.set_default_key.cljs$lang$maxFixedArity = 5);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
flureenjs.connect = (function flureenjs$connect(var_args){
var args__4742__auto__ = [];
var len__4736__auto___69414 = arguments.length;
var i__4737__auto___69415 = (0);
while(true){
if((i__4737__auto___69415 < len__4736__auto___69414)){
args__4742__auto__.push((arguments[i__4737__auto___69415]));

var G__69416 = (i__4737__auto___69415 + (1));
i__4737__auto___69415 = G__69416;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return flureenjs.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});
goog.exportSymbol('flureenjs.connect', flureenjs.connect);

(flureenjs.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers_string,p__69410){
var vec__69411 = p__69410;
var opts = cljs.core.nth.call(null,vec__69411,(0),null);
var clj_opts = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return fluree.db.connection_js.connect.call(null,servers_string,clj_opts);
}));

(flureenjs.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(flureenjs.connect.cljs$lang$applyTo = (function (seq69408){
var G__69409 = cljs.core.first.call(null,seq69408);
var seq69408__$1 = cljs.core.next.call(null,seq69408);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69409,seq69408__$1);
}));

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * Returns a promise that eventually contains the connection object.
 */
flureenjs.connect_p = (function flureenjs$connect_p(var_args){
var args__4742__auto__ = [];
var len__4736__auto___69423 = arguments.length;
var i__4737__auto___69424 = (0);
while(true){
if((i__4737__auto___69424 < len__4736__auto___69423)){
args__4742__auto__.push((arguments[i__4737__auto___69424]));

var G__69425 = (i__4737__auto___69424 + (1));
i__4737__auto___69424 = G__69425;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return flureenjs.connect_p.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});
goog.exportSymbol('flureenjs.connect_p', flureenjs.connect_p);

(flureenjs.connect_p.cljs$core$IFn$_invoke$arity$variadic = (function (servers_string,p__69419){
var vec__69420 = p__69419;
var opts = cljs.core.nth.call(null,vec__69420,(0),null);
var clj_opts = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return fluree.db.connection_js.connect_p.call(null,servers_string,clj_opts);
}));

(flureenjs.connect_p.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(flureenjs.connect_p.cljs$lang$applyTo = (function (seq69417){
var G__69418 = cljs.core.first.call(null,seq69417);
var seq69417__$1 = cljs.core.next.call(null,seq69417);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69418,seq69417__$1);
}));

/**
 * Closes a connection
 */
flureenjs.close = (function flureenjs$close(conn){
return fluree.db.connection_js.close.call(null,conn);
});
goog.exportSymbol('flureenjs.close', flureenjs.close);
/**
 * Attempts to generate a new user auth record account.
 * 
 *   Returns a promise that eventually contains the token or an exception.
 */
flureenjs.password_generate = (function flureenjs$password_generate(var_args){
var G__69427 = arguments.length;
switch (G__69427) {
case 4:
return flureenjs.password_generate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return flureenjs.password_generate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.password_generate', flureenjs.password_generate);

(flureenjs.password_generate.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return flureenjs.password_generate.call(null,conn,ledger,password,user,null);
}));

(flureenjs.password_generate.cljs$core$IFn$_invoke$arity$5 = (function (conn,ledger,password,user,opts){
var data = cljs.core.assoc.call(null,cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true),new cljs.core.Keyword(null,"user","user",1532431356),user);
return fluree.db.connection_js.password_generate.call(null,conn,ledger,password,data);
}));

(flureenjs.password_generate.cljs$lang$maxFixedArity = 5);

/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - connection - connection object to server
 *   - ledger     - ledger identifier
 *   - password   - plain-text password
 *   - user       - _user/username (TODO: should allow any _user ident in the future)
 *   - auth       - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire     - requested time to expire in milliseconds
 * 
 *   Returns a promise that eventually contains the token or an exception.
 */
flureenjs.password_login = (function flureenjs$password_login(var_args){
var G__69430 = arguments.length;
switch (G__69430) {
case 4:
return flureenjs.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return flureenjs.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.password_login', flureenjs.password_login);

(flureenjs.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user);
}));

(flureenjs.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return fluree.db.connection_js.password_login.call(null,conn,ledger,password,user,auth,expire);
}));

(flureenjs.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 *   Returns a promise that eventually contains the token or an exception
 */
flureenjs.renew_token = (function flureenjs$renew_token(var_args){
var G__69433 = arguments.length;
switch (G__69433) {
case 2:
return flureenjs.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.renew_token', flureenjs.renew_token);

(flureenjs.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,null);
}));

(flureenjs.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return fluree.db.connection_js.renew_token.call(null,conn,jwt,expire);
}));

(flureenjs.renew_token.cljs$lang$maxFixedArity = 3);

/**
 * Takes block event data from (listen...) and adds an :added and
 *   :retracted key containing maps of data organized by subject
 *   and containing full predicate names.
 */
flureenjs.block_event__GT_map = (function flureenjs$block_event__GT_map(conn,ledger,block_event){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_69484){
var state_val_69485 = (state_69484[(1)]);
if((state_val_69485 === (7))){
var inst_69451 = (state_69484[(7)]);
var inst_69456 = inst_69451.cljs$lang$protocol_mask$partition0$;
var inst_69457 = (inst_69456 & (64));
var inst_69458 = inst_69451.cljs$core$ISeq$;
var inst_69459 = (cljs.core.PROTOCOL_SENTINEL === inst_69458);
var inst_69460 = ((inst_69457) || (inst_69459));
var state_69484__$1 = state_69484;
if(cljs.core.truth_(inst_69460)){
var statearr_69486_69514 = state_69484__$1;
(statearr_69486_69514[(1)] = (10));

} else {
var statearr_69487_69515 = state_69484__$1;
(statearr_69487_69515[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (1))){
var state_69484__$1 = state_69484;
var statearr_69488_69516 = state_69484__$1;
(statearr_69488_69516[(2)] = null);

(statearr_69488_69516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (4))){
var inst_69436 = (state_69484[(2)]);
var inst_69437 = fluree.db.util.log.error.call(null,inst_69436);
var inst_69438 = reject.call(null,inst_69436);
var state_69484__$1 = (function (){var statearr_69489 = state_69484;
(statearr_69489[(8)] = inst_69437);

return statearr_69489;
})();
var statearr_69490_69517 = state_69484__$1;
(statearr_69490_69517[(2)] = inst_69438);

(statearr_69490_69517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (15))){
var inst_69448 = (state_69484[(9)]);
var inst_69472 = (state_69484[(2)]);
var inst_69473 = cljs.core.get.call(null,inst_69472,true);
var inst_69474 = cljs.core.get.call(null,inst_69472,false);
var inst_69475 = (function (){var db = inst_69448;
var map__69444 = inst_69472;
var add = inst_69473;
var retract = inst_69474;
return (function (flakes){
var by_subj = cljs.core.group_by.call(null,cljs.core.first,flakes);
return cljs.core.reduce_kv.call(null,(function (acc,sid,flakes__$1){
return cljs.core.conj.call(null,acc,cljs.core.reduce.call(null,(function (m,flake){
var p_schema = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"pred","pred",1927423397),cljs.core.second.call(null,flake)], null));
var v = cljs.core.nth.call(null,flake,(2));
if(cljs.core.truth_(new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(p_schema))){
return cljs.core.update.call(null,m,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(p_schema),cljs.core.conj,v);
} else {
return cljs.core.assoc.call(null,m,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(p_schema),v);
}
}),new cljs.core.PersistentArrayMap(null, 1, ["_id",sid], null),flakes__$1));
}),cljs.core.PersistentVector.EMPTY,by_subj);
});
})();
var inst_69476 = inst_69475.call(null,inst_69473);
var inst_69477 = inst_69475.call(null,inst_69474);
var inst_69478 = cljs.core.assoc.call(null,block_event,new cljs.core.Keyword(null,"added","added",2057651688),inst_69476,new cljs.core.Keyword(null,"retracted","retracted",-1399687854),inst_69477);
var inst_69479 = resolve.call(null,inst_69478);
var _ = (function (){var statearr_69491 = state_69484;
(statearr_69491[(4)] = cljs.core.rest.call(null,(state_69484[(4)])));

return statearr_69491;
})();
var state_69484__$1 = state_69484;
var statearr_69492_69518 = state_69484__$1;
(statearr_69492_69518[(2)] = inst_69479);

(statearr_69492_69518[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (13))){
var inst_69451 = (state_69484[(7)]);
var inst_69469 = cljs.core.apply.call(null,cljs.core.hash_map,inst_69451);
var state_69484__$1 = state_69484;
var statearr_69493_69519 = state_69484__$1;
(statearr_69493_69519[(2)] = inst_69469);

(statearr_69493_69519[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (6))){
var inst_69448 = (state_69484[(9)]);
var inst_69451 = (state_69484[(7)]);
var inst_69447 = (state_69484[(2)]);
var inst_69448__$1 = fluree.db.util.async.throw_err.call(null,inst_69447);
var inst_69449 = (function (){var db = inst_69448__$1;
return (function (p1__69435_SHARP_){
return cljs.core.nth.call(null,p1__69435_SHARP_,(4));
});
})();
var inst_69450 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block_event);
var inst_69451__$1 = cljs.core.group_by.call(null,inst_69449,inst_69450);
var inst_69453 = (inst_69451__$1 == null);
var inst_69454 = cljs.core.not.call(null,inst_69453);
var state_69484__$1 = (function (){var statearr_69494 = state_69484;
(statearr_69494[(9)] = inst_69448__$1);

(statearr_69494[(7)] = inst_69451__$1);

return statearr_69494;
})();
if(inst_69454){
var statearr_69495_69520 = state_69484__$1;
(statearr_69495_69520[(1)] = (7));

} else {
var statearr_69496_69521 = state_69484__$1;
(statearr_69496_69521[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (3))){
var inst_69482 = (state_69484[(2)]);
var state_69484__$1 = state_69484;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69484__$1,inst_69482);
} else {
if((state_val_69485 === (12))){
var inst_69464 = (state_69484[(2)]);
var state_69484__$1 = state_69484;
var statearr_69497_69522 = state_69484__$1;
(statearr_69497_69522[(2)] = inst_69464);

(statearr_69497_69522[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (2))){
var _ = (function (){var statearr_69498 = state_69484;
(statearr_69498[(4)] = cljs.core.cons.call(null,(5),(state_69484[(4)])));

return statearr_69498;
})();
var inst_69445 = flureenjs.db_instance.call(null,conn,ledger);
var state_69484__$1 = state_69484;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69484__$1,(6),inst_69445);
} else {
if((state_val_69485 === (11))){
var state_69484__$1 = state_69484;
var statearr_69500_69523 = state_69484__$1;
(statearr_69500_69523[(2)] = false);

(statearr_69500_69523[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (9))){
var inst_69467 = (state_69484[(2)]);
var state_69484__$1 = state_69484;
if(cljs.core.truth_(inst_69467)){
var statearr_69501_69524 = state_69484__$1;
(statearr_69501_69524[(1)] = (13));

} else {
var statearr_69502_69525 = state_69484__$1;
(statearr_69502_69525[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (5))){
var _ = (function (){var statearr_69503 = state_69484;
(statearr_69503[(4)] = cljs.core.rest.call(null,(state_69484[(4)])));

return statearr_69503;
})();
var state_69484__$1 = state_69484;
var ex69499 = (state_69484__$1[(2)]);
var statearr_69504_69526 = state_69484__$1;
(statearr_69504_69526[(5)] = ex69499);


var statearr_69505_69527 = state_69484__$1;
(statearr_69505_69527[(1)] = (4));

(statearr_69505_69527[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (14))){
var inst_69451 = (state_69484[(7)]);
var state_69484__$1 = state_69484;
var statearr_69506_69528 = state_69484__$1;
(statearr_69506_69528[(2)] = inst_69451);

(statearr_69506_69528[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (10))){
var state_69484__$1 = state_69484;
var statearr_69507_69529 = state_69484__$1;
(statearr_69507_69529[(2)] = true);

(statearr_69507_69529[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69485 === (8))){
var state_69484__$1 = state_69484;
var statearr_69508_69530 = state_69484__$1;
(statearr_69508_69530[(2)] = false);

(statearr_69508_69530[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$block_event__GT_map_$_state_machine__2879__auto__ = null;
var flureenjs$block_event__GT_map_$_state_machine__2879__auto____0 = (function (){
var statearr_69509 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69509[(0)] = flureenjs$block_event__GT_map_$_state_machine__2879__auto__);

(statearr_69509[(1)] = (1));

return statearr_69509;
});
var flureenjs$block_event__GT_map_$_state_machine__2879__auto____1 = (function (state_69484){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_69484);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e69510){var ex__2882__auto__ = e69510;
var statearr_69511_69531 = state_69484;
(statearr_69511_69531[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_69484[(4)]))){
var statearr_69512_69532 = state_69484;
(statearr_69512_69532[(1)] = cljs.core.first.call(null,(state_69484[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69533 = state_69484;
state_69484 = G__69533;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$block_event__GT_map_$_state_machine__2879__auto__ = function(state_69484){
switch(arguments.length){
case 0:
return flureenjs$block_event__GT_map_$_state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$block_event__GT_map_$_state_machine__2879__auto____1.call(this,state_69484);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$block_event__GT_map_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$block_event__GT_map_$_state_machine__2879__auto____0;
flureenjs$block_event__GT_map_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$block_event__GT_map_$_state_machine__2879__auto____1;
return flureenjs$block_event__GT_map_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_69513 = f__2902__auto__.call(null);
(statearr_69513[(6)] = c__2901__auto__);

return statearr_69513;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
});
/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
flureenjs.listen = (function flureenjs$listen(conn,ledger,key,callback){
return fluree.db.connection_js.listen.call(null,conn,ledger,key,callback);
});
goog.exportSymbol('flureenjs.listen', flureenjs.listen);
/**
 * Closes a listener.
 */
flureenjs.close_listener = (function flureenjs$close_listener(conn,ledger,key){
return fluree.db.connection_js.close_listener.call(null,conn,ledger,key);
});
goog.exportSymbol('flureenjs.close_listener', flureenjs.close_listener);
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
flureenjs.listeners = (function flureenjs$listeners(conn){
return fluree.db.connection_js.listeners.call(null,conn);
});
goog.exportSymbol('flureenjs.listeners', flureenjs.listeners);
/**
 * Returns a queryable database from the connection.
 */
flureenjs.db = (function flureenjs$db(var_args){
var args__4742__auto__ = [];
var len__4736__auto___69541 = arguments.length;
var i__4737__auto___69542 = (0);
while(true){
if((i__4737__auto___69542 < len__4736__auto___69541)){
args__4742__auto__.push((arguments[i__4737__auto___69542]));

var G__69543 = (i__4737__auto___69542 + (1));
i__4737__auto___69542 = G__69543;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return flureenjs.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});
goog.exportSymbol('flureenjs.db', flureenjs.db);

(flureenjs.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__69537){
var vec__69538 = p__69537;
var opts = cljs.core.nth.call(null,vec__69538,(0),null);
var clj_opts = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
return flureenjs.db_instance.call(null,conn,ledger,clj_opts);
}));

(flureenjs.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureenjs.db.cljs$lang$applyTo = (function (seq69534){
var G__69535 = cljs.core.first.call(null,seq69534);
var seq69534__$1 = cljs.core.next.call(null,seq69534);
var G__69536 = cljs.core.first.call(null,seq69534__$1);
var seq69534__$2 = cljs.core.next.call(null,seq69534__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69535,G__69536,seq69534__$2);
}));

/**
 * Returns a queryable database from the connection.
 */
flureenjs.db_instance = (function flureenjs$db_instance(var_args){
var G__69545 = arguments.length;
switch (G__69545) {
case 2:
return flureenjs.db_instance.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.db_instance.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureenjs.db_instance.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.db_instance.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.db_instance.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.call(null);
var c__2901__auto___69651 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_69611){
var state_val_69612 = (state_69611[(1)]);
if((state_val_69612 === (7))){
var state_69611__$1 = state_69611;
var statearr_69613_69652 = state_69611__$1;
(statearr_69613_69652[(2)] = false);

(statearr_69613_69652[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69612 === (20))){
var inst_69597 = (state_69611[(2)]);
var state_69611__$1 = state_69611;
var statearr_69614_69653 = state_69611__$1;
(statearr_69614_69653[(2)] = inst_69597);

(statearr_69614_69653[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69612 === (1))){
var state_69611__$1 = state_69611;
var statearr_69615_69654 = state_69611__$1;
(statearr_69615_69654[(2)] = null);

(statearr_69615_69654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69612 === (4))){
var inst_69546 = (state_69611[(2)]);
var inst_69547 = fluree.db.util.log.error.call(null,inst_69546);
var inst_69548 = cljs.core.async.put_BANG_.call(null,pc,inst_69546);
var inst_69549 = cljs.core.async.close_BANG_.call(null,pc);
var state_69611__$1 = (function (){var statearr_69616 = state_69611;
(statearr_69616[(7)] = inst_69547);

(statearr_69616[(8)] = inst_69548);

return statearr_69616;
})();
var statearr_69617_69655 = state_69611__$1;
(statearr_69617_69655[(2)] = inst_69549);

(statearr_69617_69655[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69612 === (15))){
var inst_69581 = (state_69611[(9)]);
var state_69611__$1 = state_69611;
var statearr_69618_69656 = state_69611__$1;
(statearr_69618_69656[(2)] = inst_69581);

(statearr_69618_69656[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69612 === (21))){
var inst_69585 = (state_69611[(10)]);
var inst_69586 = (state_69611[(11)]);
var inst_69603 = (state_69611[(2)]);
var inst_69604 = fluree.db.util.async.throw_err.call(null,inst_69603);
var inst_69605 = cljs.core.assoc.call(null,inst_69604,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"network","network",2050004697),inst_69585,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_69586);
var inst_69606 = cljs.core.async.put_BANG_.call(null,pc,inst_69605);
var _ = (function (){var statearr_69619 = state_69611;
(statearr_69619[(4)] = cljs.core.rest.call(null,(state_69611[(4)])));

return statearr_69619;
})();
var state_69611__$1 = state_69611;
var statearr_69620_69657 = state_69611__$1;
(statearr_69620_69657[(2)] = inst_69606);

(statearr_69620_69657[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69612 === (13))){
var inst_69559 = (state_69611[(12)]);
var state_69611__$1 = state_69611;
var statearr_69621_69658 = state_69611__$1;
(statearr_69621_69658[(2)] = inst_69559);

(statearr_69621_69658[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69612 === (6))){
var inst_69559 = (state_69611[(12)]);
var inst_69564 = inst_69559.cljs$lang$protocol_mask$partition0$;
var inst_69565 = (inst_69564 & (64));
var inst_69566 = inst_69559.cljs$core$ISeq$;
var inst_69567 = (cljs.core.PROTOCOL_SENTINEL === inst_69566);
var inst_69568 = ((inst_69565) || (inst_69567));
var state_69611__$1 = state_69611;
if(cljs.core.truth_(inst_69568)){
var statearr_69622_69659 = state_69611__$1;
(statearr_69622_69659[(1)] = (9));

} else {
var statearr_69623_69660 = state_69611__$1;
(statearr_69623_69660[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69612 === (17))){
var inst_69599 = (state_69611[(2)]);
var inst_69600 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_69599);
var inst_69601 = fluree.db.api.ledger.db.call(null,conn,ledger,inst_69600);
var state_69611__$1 = state_69611;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69611__$1,(21),inst_69601);
} else {
if((state_val_69612 === (3))){
var inst_69609 = (state_69611[(2)]);
var state_69611__$1 = state_69611;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69611__$1,inst_69609);
} else {
if((state_val_69612 === (12))){
var inst_69559 = (state_69611[(12)]);
var inst_69577 = cljs.core.apply.call(null,cljs.core.hash_map,inst_69559);
var state_69611__$1 = state_69611;
var statearr_69624_69661 = state_69611__$1;
(statearr_69624_69661[(2)] = inst_69577);

(statearr_69624_69661[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69612 === (2))){
var inst_69559 = (state_69611[(12)]);
var _ = (function (){var statearr_69625 = state_69611;
(statearr_69625[(4)] = cljs.core.cons.call(null,(5),(state_69611[(4)])));

return statearr_69625;
})();
var inst_69559__$1 = opts;
var inst_69561 = (inst_69559__$1 == null);
var inst_69562 = cljs.core.not.call(null,inst_69561);
var state_69611__$1 = (function (){var statearr_69626 = state_69611;
(statearr_69626[(12)] = inst_69559__$1);

return statearr_69626;
})();
if(inst_69562){
var statearr_69627_69662 = state_69611__$1;
(statearr_69627_69662[(1)] = (6));

} else {
var statearr_69628_69663 = state_69611__$1;
(statearr_69628_69663[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69612 === (19))){
var state_69611__$1 = state_69611;
var statearr_69629_69664 = state_69611__$1;
(statearr_69629_69664[(2)] = null);

(statearr_69629_69664[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69612 === (11))){
var inst_69572 = (state_69611[(2)]);
var state_69611__$1 = state_69611;
var statearr_69631_69665 = state_69611__$1;
(statearr_69631_69665[(2)] = inst_69572);

(statearr_69631_69665[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69612 === (9))){
var state_69611__$1 = state_69611;
var statearr_69632_69666 = state_69611__$1;
(statearr_69632_69666[(2)] = true);

(statearr_69632_69666[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69612 === (5))){
var _ = (function (){var statearr_69633 = state_69611;
(statearr_69633[(4)] = cljs.core.rest.call(null,(state_69611[(4)])));

return statearr_69633;
})();
var state_69611__$1 = state_69611;
var ex69630 = (state_69611__$1[(2)]);
var statearr_69634_69667 = state_69611__$1;
(statearr_69634_69667[(5)] = ex69630);


var statearr_69635_69668 = state_69611__$1;
(statearr_69635_69668[(1)] = (4));

(statearr_69635_69668[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69612 === (14))){
var inst_69581 = (state_69611[(9)]);
var inst_69580 = (state_69611[(2)]);
var inst_69581__$1 = cljs.core.get.call(null,inst_69580,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_69582 = cljs.core.get.call(null,inst_69580,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var inst_69583 = fluree.db.connection_js.check_connection.call(null,conn,opts);
var inst_69584 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_69585 = cljs.core.nth.call(null,inst_69584,(0),null);
var inst_69586 = cljs.core.nth.call(null,inst_69584,(1),null);
var state_69611__$1 = (function (){var statearr_69636 = state_69611;
(statearr_69636[(10)] = inst_69585);

(statearr_69636[(13)] = inst_69582);

(statearr_69636[(9)] = inst_69581__$1);

(statearr_69636[(14)] = inst_69583);

(statearr_69636[(11)] = inst_69586);

return statearr_69636;
})();
if(cljs.core.truth_(inst_69581__$1)){
var statearr_69637_69669 = state_69611__$1;
(statearr_69637_69669[(1)] = (15));

} else {
var statearr_69638_69670 = state_69611__$1;
(statearr_69638_69670[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69612 === (16))){
var inst_69582 = (state_69611[(13)]);
var state_69611__$1 = state_69611;
if(cljs.core.truth_(inst_69582)){
var statearr_69639_69671 = state_69611__$1;
(statearr_69639_69671[(1)] = (18));

} else {
var statearr_69640_69672 = state_69611__$1;
(statearr_69640_69672[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69612 === (10))){
var state_69611__$1 = state_69611;
var statearr_69641_69673 = state_69611__$1;
(statearr_69641_69673[(2)] = false);

(statearr_69641_69673[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69612 === (18))){
var inst_69582 = (state_69611[(13)]);
var inst_69590 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69591 = fluree.db.connection_js.validate_token.call(null,conn,inst_69582);
var inst_69592 = new cljs.core.Keyword(null,"sub","sub",-2093760025).cljs$core$IFn$_invoke$arity$1(inst_69591);
var inst_69593 = ["_auth/id",inst_69592];
var inst_69594 = (new cljs.core.PersistentVector(null,2,(5),inst_69590,inst_69593,null));
var state_69611__$1 = state_69611;
var statearr_69642_69674 = state_69611__$1;
(statearr_69642_69674[(2)] = inst_69594);

(statearr_69642_69674[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69612 === (8))){
var inst_69575 = (state_69611[(2)]);
var state_69611__$1 = state_69611;
if(cljs.core.truth_(inst_69575)){
var statearr_69643_69675 = state_69611__$1;
(statearr_69643_69675[(1)] = (12));

} else {
var statearr_69644_69676 = state_69611__$1;
(statearr_69644_69676[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2879__auto__ = null;
var flureenjs$state_machine__2879__auto____0 = (function (){
var statearr_69645 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69645[(0)] = flureenjs$state_machine__2879__auto__);

(statearr_69645[(1)] = (1));

return statearr_69645;
});
var flureenjs$state_machine__2879__auto____1 = (function (state_69611){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_69611);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e69646){var ex__2882__auto__ = e69646;
var statearr_69647_69677 = state_69611;
(statearr_69647_69677[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_69611[(4)]))){
var statearr_69648_69678 = state_69611;
(statearr_69648_69678[(1)] = cljs.core.first.call(null,(state_69611[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69679 = state_69611;
state_69611 = G__69679;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$state_machine__2879__auto__ = function(state_69611){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$state_machine__2879__auto____1.call(this,state_69611);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2879__auto____0;
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2879__auto____1;
return flureenjs$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_69649 = f__2902__auto__.call(null);
(statearr_69649[(6)] = c__2901__auto___69651);

return statearr_69649;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));


return pc;
}));

(flureenjs.db_instance.cljs$lang$maxFixedArity = 3);

/**
 * Returns a queryable database from the connection.
 */
flureenjs.db_p = (function flureenjs$db_p(var_args){
var args__4742__auto__ = [];
var len__4736__auto___69719 = arguments.length;
var i__4737__auto___69720 = (0);
while(true){
if((i__4737__auto___69720 < len__4736__auto___69719)){
args__4742__auto__.push((arguments[i__4737__auto___69720]));

var G__69721 = (i__4737__auto___69720 + (1));
i__4737__auto___69720 = G__69721;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return flureenjs.db_p.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});
goog.exportSymbol('flureenjs.db_p', flureenjs.db_p);

(flureenjs.db_p.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__69683){
var vec__69684 = p__69683;
var opts = cljs.core.nth.call(null,vec__69684,(0),null);
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_69702){
var state_val_69703 = (state_69702[(1)]);
if((state_val_69703 === (1))){
var state_69702__$1 = state_69702;
var statearr_69704_69722 = state_69702__$1;
(statearr_69704_69722[(2)] = null);

(statearr_69704_69722[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69703 === (2))){
var _ = (function (){var statearr_69705 = state_69702;
(statearr_69705[(4)] = cljs.core.cons.call(null,(5),(state_69702[(4)])));

return statearr_69705;
})();
var inst_69695 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_69696 = flureenjs.db_instance.call(null,conn,ledger,inst_69695);
var inst_69697 = resolve.call(null,inst_69696);
var ___$1 = (function (){var statearr_69706 = state_69702;
(statearr_69706[(4)] = cljs.core.rest.call(null,(state_69702[(4)])));

return statearr_69706;
})();
var state_69702__$1 = state_69702;
var statearr_69707_69723 = state_69702__$1;
(statearr_69707_69723[(2)] = inst_69697);

(statearr_69707_69723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69703 === (3))){
var inst_69700 = (state_69702[(2)]);
var state_69702__$1 = state_69702;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69702__$1,inst_69700);
} else {
if((state_val_69703 === (4))){
var inst_69687 = (state_69702[(2)]);
var inst_69688 = fluree.db.util.log.error.call(null,inst_69687);
var inst_69689 = reject.call(null,inst_69687);
var state_69702__$1 = (function (){var statearr_69709 = state_69702;
(statearr_69709[(7)] = inst_69688);

return statearr_69709;
})();
var statearr_69710_69724 = state_69702__$1;
(statearr_69710_69724[(2)] = inst_69689);

(statearr_69710_69724[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69703 === (5))){
var _ = (function (){var statearr_69711 = state_69702;
(statearr_69711[(4)] = cljs.core.rest.call(null,(state_69702[(4)])));

return statearr_69711;
})();
var state_69702__$1 = state_69702;
var ex69708 = (state_69702__$1[(2)]);
var statearr_69712_69725 = state_69702__$1;
(statearr_69712_69725[(5)] = ex69708);


var statearr_69713_69726 = state_69702__$1;
(statearr_69713_69726[(1)] = (4));

(statearr_69713_69726[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2879__auto__ = null;
var flureenjs$state_machine__2879__auto____0 = (function (){
var statearr_69714 = [null,null,null,null,null,null,null,null];
(statearr_69714[(0)] = flureenjs$state_machine__2879__auto__);

(statearr_69714[(1)] = (1));

return statearr_69714;
});
var flureenjs$state_machine__2879__auto____1 = (function (state_69702){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_69702);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e69715){var ex__2882__auto__ = e69715;
var statearr_69716_69727 = state_69702;
(statearr_69716_69727[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_69702[(4)]))){
var statearr_69717_69728 = state_69702;
(statearr_69717_69728[(1)] = cljs.core.first.call(null,(state_69702[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69729 = state_69702;
state_69702 = G__69729;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$state_machine__2879__auto__ = function(state_69702){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$state_machine__2879__auto____1.call(this,state_69702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2879__auto____0;
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2879__auto____1;
return flureenjs$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_69718 = f__2902__auto__.call(null);
(statearr_69718[(6)] = c__2901__auto__);

return statearr_69718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureenjs.db_p.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(flureenjs.db_p.cljs$lang$applyTo = (function (seq69680){
var G__69681 = cljs.core.first.call(null,seq69680);
var seq69680__$1 = cljs.core.next.call(null,seq69680);
var G__69682 = cljs.core.first.call(null,seq69680__$1);
var seq69680__$2 = cljs.core.next.call(null,seq69680__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69681,G__69682,seq69680__$2);
}));

/**
 * Returns promise containing collection id given a collection name.
 *   If collection doesn't exist, returns nil.
 */
flureenjs.collection_id = (function flureenjs$collection_id(db,collection){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_69749){
var state_val_69750 = (state_69749[(1)]);
if((state_val_69750 === (1))){
var state_69749__$1 = state_69749;
var statearr_69751_69767 = state_69749__$1;
(statearr_69751_69767[(2)] = null);

(statearr_69751_69767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69750 === (2))){
var _ = (function (){var statearr_69752 = state_69749;
(statearr_69752[(4)] = cljs.core.cons.call(null,(5),(state_69749[(4)])));

return statearr_69752;
})();
var inst_69738 = cljs.core.js__GT_clj.call(null,collection,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_69749__$1 = (function (){var statearr_69753 = state_69749;
(statearr_69753[(7)] = inst_69738);

return statearr_69753;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69749__$1,(6),db);
} else {
if((state_val_69750 === (3))){
var inst_69747 = (state_69749[(2)]);
var state_69749__$1 = state_69749;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69749__$1,inst_69747);
} else {
if((state_val_69750 === (4))){
var inst_69730 = (state_69749[(2)]);
var inst_69731 = fluree.db.util.log.error.call(null,inst_69730);
var inst_69732 = reject.call(null,inst_69730);
var state_69749__$1 = (function (){var statearr_69755 = state_69749;
(statearr_69755[(8)] = inst_69731);

return statearr_69755;
})();
var statearr_69756_69768 = state_69749__$1;
(statearr_69756_69768[(2)] = inst_69732);

(statearr_69756_69768[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69750 === (5))){
var _ = (function (){var statearr_69757 = state_69749;
(statearr_69757[(4)] = cljs.core.rest.call(null,(state_69749[(4)])));

return statearr_69757;
})();
var state_69749__$1 = state_69749;
var ex69754 = (state_69749__$1[(2)]);
var statearr_69758_69769 = state_69749__$1;
(statearr_69758_69769[(5)] = ex69754);


var statearr_69759_69770 = state_69749__$1;
(statearr_69759_69770[(1)] = (4));

(statearr_69759_69770[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69750 === (6))){
var inst_69738 = (state_69749[(7)]);
var inst_69740 = (state_69749[(2)]);
var inst_69741 = fluree.db.util.async.throw_err.call(null,inst_69740);
var inst_69742 = fluree.db.dbproto._c_prop.call(null,inst_69741,new cljs.core.Keyword(null,"id","id",-1388402092),inst_69738);
var inst_69743 = cljs.core.clj__GT_js.call(null,inst_69742);
var inst_69744 = resolve.call(null,inst_69743);
var _ = (function (){var statearr_69760 = state_69749;
(statearr_69760[(4)] = cljs.core.rest.call(null,(state_69749[(4)])));

return statearr_69760;
})();
var state_69749__$1 = state_69749;
var statearr_69761_69771 = state_69749__$1;
(statearr_69761_69771[(2)] = inst_69744);

(statearr_69761_69771[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$collection_id_$_state_machine__2879__auto__ = null;
var flureenjs$collection_id_$_state_machine__2879__auto____0 = (function (){
var statearr_69762 = [null,null,null,null,null,null,null,null,null];
(statearr_69762[(0)] = flureenjs$collection_id_$_state_machine__2879__auto__);

(statearr_69762[(1)] = (1));

return statearr_69762;
});
var flureenjs$collection_id_$_state_machine__2879__auto____1 = (function (state_69749){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_69749);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e69763){var ex__2882__auto__ = e69763;
var statearr_69764_69772 = state_69749;
(statearr_69764_69772[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_69749[(4)]))){
var statearr_69765_69773 = state_69749;
(statearr_69765_69773[(1)] = cljs.core.first.call(null,(state_69749[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69774 = state_69749;
state_69749 = G__69774;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$collection_id_$_state_machine__2879__auto__ = function(state_69749){
switch(arguments.length){
case 0:
return flureenjs$collection_id_$_state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$collection_id_$_state_machine__2879__auto____1.call(this,state_69749);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$collection_id_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$collection_id_$_state_machine__2879__auto____0;
flureenjs$collection_id_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$collection_id_$_state_machine__2879__auto____1;
return flureenjs$collection_id_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_69766 = f__2902__auto__.call(null);
(statearr_69766[(6)] = c__2901__auto__);

return statearr_69766;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureenjs.collection_id', flureenjs.collection_id);
/**
 * Returns promise containing predicate id given a predicate.
 *   If predicate doesn't exist, returns nil.
 */
flureenjs.predicate_id = (function flureenjs$predicate_id(db,predicate){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_69794){
var state_val_69795 = (state_69794[(1)]);
if((state_val_69795 === (1))){
var state_69794__$1 = state_69794;
var statearr_69796_69812 = state_69794__$1;
(statearr_69796_69812[(2)] = null);

(statearr_69796_69812[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69795 === (2))){
var _ = (function (){var statearr_69797 = state_69794;
(statearr_69797[(4)] = cljs.core.cons.call(null,(5),(state_69794[(4)])));

return statearr_69797;
})();
var inst_69783 = cljs.core.js__GT_clj.call(null,predicate,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_69794__$1 = (function (){var statearr_69798 = state_69794;
(statearr_69798[(7)] = inst_69783);

return statearr_69798;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69794__$1,(6),db);
} else {
if((state_val_69795 === (3))){
var inst_69792 = (state_69794[(2)]);
var state_69794__$1 = state_69794;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69794__$1,inst_69792);
} else {
if((state_val_69795 === (4))){
var inst_69775 = (state_69794[(2)]);
var inst_69776 = fluree.db.util.log.error.call(null,inst_69775);
var inst_69777 = reject.call(null,inst_69775);
var state_69794__$1 = (function (){var statearr_69800 = state_69794;
(statearr_69800[(8)] = inst_69776);

return statearr_69800;
})();
var statearr_69801_69813 = state_69794__$1;
(statearr_69801_69813[(2)] = inst_69777);

(statearr_69801_69813[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69795 === (5))){
var _ = (function (){var statearr_69802 = state_69794;
(statearr_69802[(4)] = cljs.core.rest.call(null,(state_69794[(4)])));

return statearr_69802;
})();
var state_69794__$1 = state_69794;
var ex69799 = (state_69794__$1[(2)]);
var statearr_69803_69814 = state_69794__$1;
(statearr_69803_69814[(5)] = ex69799);


var statearr_69804_69815 = state_69794__$1;
(statearr_69804_69815[(1)] = (4));

(statearr_69804_69815[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69795 === (6))){
var inst_69783 = (state_69794[(7)]);
var inst_69785 = (state_69794[(2)]);
var inst_69786 = fluree.db.util.async.throw_err.call(null,inst_69785);
var inst_69787 = fluree.db.dbproto._p_prop.call(null,inst_69786,new cljs.core.Keyword(null,"id","id",-1388402092),inst_69783);
var inst_69788 = cljs.core.clj__GT_js.call(null,inst_69787);
var inst_69789 = resolve.call(null,inst_69788);
var _ = (function (){var statearr_69805 = state_69794;
(statearr_69805[(4)] = cljs.core.rest.call(null,(state_69794[(4)])));

return statearr_69805;
})();
var state_69794__$1 = state_69794;
var statearr_69806_69816 = state_69794__$1;
(statearr_69806_69816[(2)] = inst_69789);

(statearr_69806_69816[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$predicate_id_$_state_machine__2879__auto__ = null;
var flureenjs$predicate_id_$_state_machine__2879__auto____0 = (function (){
var statearr_69807 = [null,null,null,null,null,null,null,null,null];
(statearr_69807[(0)] = flureenjs$predicate_id_$_state_machine__2879__auto__);

(statearr_69807[(1)] = (1));

return statearr_69807;
});
var flureenjs$predicate_id_$_state_machine__2879__auto____1 = (function (state_69794){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_69794);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e69808){var ex__2882__auto__ = e69808;
var statearr_69809_69817 = state_69794;
(statearr_69809_69817[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_69794[(4)]))){
var statearr_69810_69818 = state_69794;
(statearr_69810_69818[(1)] = cljs.core.first.call(null,(state_69794[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69819 = state_69794;
state_69794 = G__69819;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$predicate_id_$_state_machine__2879__auto__ = function(state_69794){
switch(arguments.length){
case 0:
return flureenjs$predicate_id_$_state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$predicate_id_$_state_machine__2879__auto____1.call(this,state_69794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$predicate_id_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$predicate_id_$_state_machine__2879__auto____0;
flureenjs$predicate_id_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$predicate_id_$_state_machine__2879__auto____1;
return flureenjs$predicate_id_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_69811 = f__2902__auto__.call(null);
(statearr_69811[(6)] = c__2901__auto__);

return statearr_69811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureenjs.predicate_id', flureenjs.predicate_id);
/**
 * Returns promise containing predicate name given a predicate.
 *   If predicate doesn't exist, returns nil.
 */
flureenjs.predicate_name = (function flureenjs$predicate_name(db,predicate){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_69839){
var state_val_69840 = (state_69839[(1)]);
if((state_val_69840 === (1))){
var state_69839__$1 = state_69839;
var statearr_69841_69857 = state_69839__$1;
(statearr_69841_69857[(2)] = null);

(statearr_69841_69857[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69840 === (2))){
var _ = (function (){var statearr_69842 = state_69839;
(statearr_69842[(4)] = cljs.core.cons.call(null,(5),(state_69839[(4)])));

return statearr_69842;
})();
var inst_69828 = cljs.core.js__GT_clj.call(null,predicate,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_69839__$1 = (function (){var statearr_69843 = state_69839;
(statearr_69843[(7)] = inst_69828);

return statearr_69843;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69839__$1,(6),db);
} else {
if((state_val_69840 === (3))){
var inst_69837 = (state_69839[(2)]);
var state_69839__$1 = state_69839;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69839__$1,inst_69837);
} else {
if((state_val_69840 === (4))){
var inst_69820 = (state_69839[(2)]);
var inst_69821 = fluree.db.util.log.error.call(null,inst_69820);
var inst_69822 = reject.call(null,inst_69820);
var state_69839__$1 = (function (){var statearr_69845 = state_69839;
(statearr_69845[(8)] = inst_69821);

return statearr_69845;
})();
var statearr_69846_69858 = state_69839__$1;
(statearr_69846_69858[(2)] = inst_69822);

(statearr_69846_69858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69840 === (5))){
var _ = (function (){var statearr_69847 = state_69839;
(statearr_69847[(4)] = cljs.core.rest.call(null,(state_69839[(4)])));

return statearr_69847;
})();
var state_69839__$1 = state_69839;
var ex69844 = (state_69839__$1[(2)]);
var statearr_69848_69859 = state_69839__$1;
(statearr_69848_69859[(5)] = ex69844);


var statearr_69849_69860 = state_69839__$1;
(statearr_69849_69860[(1)] = (4));

(statearr_69849_69860[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69840 === (6))){
var inst_69828 = (state_69839[(7)]);
var inst_69830 = (state_69839[(2)]);
var inst_69831 = fluree.db.util.async.throw_err.call(null,inst_69830);
var inst_69832 = fluree.db.dbproto._p_prop.call(null,inst_69831,new cljs.core.Keyword(null,"name","name",1843675177),inst_69828);
var inst_69833 = cljs.core.clj__GT_js.call(null,inst_69832);
var inst_69834 = resolve.call(null,inst_69833);
var _ = (function (){var statearr_69850 = state_69839;
(statearr_69850[(4)] = cljs.core.rest.call(null,(state_69839[(4)])));

return statearr_69850;
})();
var state_69839__$1 = state_69839;
var statearr_69851_69861 = state_69839__$1;
(statearr_69851_69861[(2)] = inst_69834);

(statearr_69851_69861[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$predicate_name_$_state_machine__2879__auto__ = null;
var flureenjs$predicate_name_$_state_machine__2879__auto____0 = (function (){
var statearr_69852 = [null,null,null,null,null,null,null,null,null];
(statearr_69852[(0)] = flureenjs$predicate_name_$_state_machine__2879__auto__);

(statearr_69852[(1)] = (1));

return statearr_69852;
});
var flureenjs$predicate_name_$_state_machine__2879__auto____1 = (function (state_69839){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_69839);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e69853){var ex__2882__auto__ = e69853;
var statearr_69854_69862 = state_69839;
(statearr_69854_69862[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_69839[(4)]))){
var statearr_69855_69863 = state_69839;
(statearr_69855_69863[(1)] = cljs.core.first.call(null,(state_69839[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69864 = state_69839;
state_69839 = G__69864;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$predicate_name_$_state_machine__2879__auto__ = function(state_69839){
switch(arguments.length){
case 0:
return flureenjs$predicate_name_$_state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$predicate_name_$_state_machine__2879__auto____1.call(this,state_69839);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$predicate_name_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$predicate_name_$_state_machine__2879__auto____0;
flureenjs$predicate_name_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$predicate_name_$_state_machine__2879__auto____1;
return flureenjs$predicate_name_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_69856 = f__2902__auto__.call(null);
(statearr_69856[(6)] = c__2901__auto__);

return statearr_69856;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureenjs.predicate_name', flureenjs.predicate_name);
/**
 * Returns promise containing subject id given a subject
 *   identity or a subject id.
 *   If subject doesn't exist, returns nil.
 */
flureenjs.subid = (function flureenjs$subid(db,ident){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_69887){
var state_val_69888 = (state_69887[(1)]);
if((state_val_69888 === (1))){
var state_69887__$1 = state_69887;
var statearr_69889_69905 = state_69887__$1;
(statearr_69889_69905[(2)] = null);

(statearr_69889_69905[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69888 === (2))){
var _ = (function (){var statearr_69890 = state_69887;
(statearr_69890[(4)] = cljs.core.cons.call(null,(5),(state_69887[(4)])));

return statearr_69890;
})();
var inst_69873 = cljs.core.js__GT_clj.call(null,ident,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_69887__$1 = (function (){var statearr_69891 = state_69887;
(statearr_69891[(7)] = inst_69873);

return statearr_69891;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69887__$1,(7),db);
} else {
if((state_val_69888 === (3))){
var inst_69885 = (state_69887[(2)]);
var state_69887__$1 = state_69887;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69887__$1,inst_69885);
} else {
if((state_val_69888 === (4))){
var inst_69865 = (state_69887[(2)]);
var inst_69866 = fluree.db.util.log.error.call(null,inst_69865);
var inst_69867 = reject.call(null,inst_69865);
var state_69887__$1 = (function (){var statearr_69893 = state_69887;
(statearr_69893[(8)] = inst_69866);

return statearr_69893;
})();
var statearr_69894_69906 = state_69887__$1;
(statearr_69894_69906[(2)] = inst_69867);

(statearr_69894_69906[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69888 === (5))){
var _ = (function (){var statearr_69895 = state_69887;
(statearr_69895[(4)] = cljs.core.rest.call(null,(state_69887[(4)])));

return statearr_69895;
})();
var state_69887__$1 = state_69887;
var ex69892 = (state_69887__$1[(2)]);
var statearr_69896_69907 = state_69887__$1;
(statearr_69896_69907[(5)] = ex69892);


var statearr_69897_69908 = state_69887__$1;
(statearr_69897_69908[(1)] = (4));

(statearr_69897_69908[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69888 === (6))){
var inst_69879 = (state_69887[(2)]);
var inst_69880 = fluree.db.util.async.throw_err.call(null,inst_69879);
var inst_69881 = cljs.core.clj__GT_js.call(null,inst_69880);
var inst_69882 = resolve.call(null,inst_69881);
var _ = (function (){var statearr_69898 = state_69887;
(statearr_69898[(4)] = cljs.core.rest.call(null,(state_69887[(4)])));

return statearr_69898;
})();
var state_69887__$1 = state_69887;
var statearr_69899_69909 = state_69887__$1;
(statearr_69899_69909[(2)] = inst_69882);

(statearr_69899_69909[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69888 === (7))){
var inst_69873 = (state_69887[(7)]);
var inst_69875 = (state_69887[(2)]);
var inst_69876 = fluree.db.util.async.throw_err.call(null,inst_69875);
var inst_69877 = fluree.db.dbproto._subid.call(null,inst_69876,inst_69873,false);
var state_69887__$1 = state_69887;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69887__$1,(6),inst_69877);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$subid_$_state_machine__2879__auto__ = null;
var flureenjs$subid_$_state_machine__2879__auto____0 = (function (){
var statearr_69900 = [null,null,null,null,null,null,null,null,null];
(statearr_69900[(0)] = flureenjs$subid_$_state_machine__2879__auto__);

(statearr_69900[(1)] = (1));

return statearr_69900;
});
var flureenjs$subid_$_state_machine__2879__auto____1 = (function (state_69887){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_69887);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e69901){var ex__2882__auto__ = e69901;
var statearr_69902_69910 = state_69887;
(statearr_69902_69910[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_69887[(4)]))){
var statearr_69903_69911 = state_69887;
(statearr_69903_69911[(1)] = cljs.core.first.call(null,(state_69887[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69912 = state_69887;
state_69887 = G__69912;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$subid_$_state_machine__2879__auto__ = function(state_69887){
switch(arguments.length){
case 0:
return flureenjs$subid_$_state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$subid_$_state_machine__2879__auto____1.call(this,state_69887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$subid_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$subid_$_state_machine__2879__auto____0;
flureenjs$subid_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$subid_$_state_machine__2879__auto____1;
return flureenjs$subid_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_69904 = f__2902__auto__.call(null);
(statearr_69904[(6)] = c__2901__auto__);

return statearr_69904;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureenjs.subid', flureenjs.subid);
/**
 * Completely deletes a ledger.
 *   Returns a promise that will have a response with a corresponding status of success.
 * 
 *   A 200 status indicates the deletion has been successfully initiated.
 *   The full deletion happens in the background on the respective ledger.
 * 
 *   Query servers get notified when this process initiates, and ledger will be marked as
 *   being in a deletion state during the deletion process.
 * 
 *   Attempts to use a ledger in a deletion state will throw an exception.
 */
flureenjs.delete_ledger = (function flureenjs$delete_ledger(var_args){
var G__69914 = arguments.length;
switch (G__69914) {
case 2:
return flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.delete_ledger', flureenjs.delete_ledger);

(flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.delete_ledger.call(null,conn,ledger,null);
}));

(flureenjs.delete_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_70004){
var state_val_70005 = (state_70004[(1)]);
if((state_val_70005 === (7))){
var inst_69927 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_70004__$1 = state_70004;
var statearr_70006_70064 = state_70004__$1;
(statearr_70006_70064[(2)] = inst_69927);

(statearr_70006_70064[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (20))){
var inst_69953 = (state_70004[(7)]);
var inst_69960 = (state_70004[(2)]);
var state_70004__$1 = (function (){var statearr_70007 = state_70004;
(statearr_70007[(8)] = inst_69960);

return statearr_70007;
})();
if(cljs.core.truth_(inst_69953)){
var statearr_70008_70065 = state_70004__$1;
(statearr_70008_70065[(1)] = (21));

} else {
var statearr_70009_70066 = state_70004__$1;
(statearr_70009_70066[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (27))){
var inst_69955 = (state_70004[(9)]);
var inst_69974 = (state_70004[(10)]);
var inst_69976 = fluree.crypto.sign_message.call(null,inst_69974,inst_69955);
var state_70004__$1 = state_70004;
var statearr_70010_70067 = state_70004__$1;
(statearr_70010_70067[(2)] = inst_69976);

(statearr_70010_70067[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (1))){
var state_70004__$1 = state_70004;
var statearr_70011_70068 = state_70004__$1;
(statearr_70011_70068[(2)] = null);

(statearr_70011_70068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (24))){
var inst_69968 = (state_70004[(11)]);
var inst_69970 = fluree.db.util.core.without_nils.call(null,inst_69968);
var inst_69971 = fluree.db.util.json.stringify.call(null,inst_69970);
var state_70004__$1 = state_70004;
var statearr_70012_70069 = state_70004__$1;
(statearr_70012_70069[(2)] = inst_69971);

(statearr_70012_70069[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (4))){
var inst_69915 = (state_70004[(2)]);
var inst_69916 = fluree.db.util.log.error.call(null,inst_69915);
var inst_69917 = reject.call(null,inst_69915);
var state_70004__$1 = (function (){var statearr_70013 = state_70004;
(statearr_70013[(12)] = inst_69916);

return statearr_70013;
})();
var statearr_70014_70070 = state_70004__$1;
(statearr_70014_70070[(2)] = inst_69917);

(statearr_70014_70070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (15))){
var inst_69929 = (state_70004[(13)]);
var inst_69948 = cljs.core.apply.call(null,cljs.core.hash_map,inst_69929);
var state_70004__$1 = state_70004;
var statearr_70015_70071 = state_70004__$1;
(statearr_70015_70071[(2)] = inst_69948);

(statearr_70015_70071[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (21))){
var inst_69953 = (state_70004[(7)]);
var state_70004__$1 = state_70004;
var statearr_70016_70072 = state_70004__$1;
(statearr_70016_70072[(2)] = inst_69953);

(statearr_70016_70072[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (31))){
var inst_69968 = (state_70004[(11)]);
var inst_69989 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_69968);
var state_70004__$1 = state_70004;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70004__$1,(34),inst_69989);
} else {
if((state_val_70005 === (32))){
var inst_69994 = (state_70004[(2)]);
var inst_69995 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_69996 = [(200),inst_69994];
var inst_69997 = cljs.core.PersistentHashMap.fromArrays(inst_69995,inst_69996);
var inst_69998 = cljs.core.clj__GT_js.call(null,inst_69997);
var inst_69999 = resolve.call(null,inst_69998);
var _ = (function (){var statearr_70017 = state_70004;
(statearr_70017[(4)] = cljs.core.rest.call(null,(state_70004[(4)])));

return statearr_70017;
})();
var state_70004__$1 = state_70004;
var statearr_70018_70073 = state_70004__$1;
(statearr_70018_70073[(2)] = inst_69999);

(statearr_70018_70073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (33))){
var inst_69986 = (state_70004[(2)]);
var inst_69987 = fluree.db.util.async.throw_err.call(null,inst_69986);
var state_70004__$1 = state_70004;
var statearr_70019_70074 = state_70004__$1;
(statearr_70019_70074[(2)] = inst_69987);

(statearr_70019_70074[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (13))){
var state_70004__$1 = state_70004;
var statearr_70020_70075 = state_70004__$1;
(statearr_70020_70075[(2)] = false);

(statearr_70020_70075[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (22))){
var inst_69956 = (state_70004[(14)]);
var inst_69963 = (inst_69956 + (30000));
var state_70004__$1 = state_70004;
var statearr_70021_70076 = state_70004__$1;
(statearr_70021_70076[(2)] = inst_69963);

(statearr_70021_70076[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (29))){
var inst_69955 = (state_70004[(9)]);
var inst_69979 = (state_70004[(2)]);
var state_70004__$1 = (function (){var statearr_70022 = state_70004;
(statearr_70022[(15)] = inst_69979);

return statearr_70022;
})();
if(cljs.core.truth_(inst_69955)){
var statearr_70023_70077 = state_70004__$1;
(statearr_70023_70077[(1)] = (30));

} else {
var statearr_70024_70078 = state_70004__$1;
(statearr_70024_70078[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (6))){
var state_70004__$1 = state_70004;
var statearr_70025_70079 = state_70004__$1;
(statearr_70025_70079[(2)] = null);

(statearr_70025_70079[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (28))){
var state_70004__$1 = state_70004;
var statearr_70026_70080 = state_70004__$1;
(statearr_70026_70080[(2)] = null);

(statearr_70026_70080[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (25))){
var state_70004__$1 = state_70004;
var statearr_70027_70081 = state_70004__$1;
(statearr_70027_70081[(2)] = null);

(statearr_70027_70081[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (34))){
var inst_69991 = (state_70004[(2)]);
var inst_69992 = fluree.db.util.async.throw_err.call(null,inst_69991);
var state_70004__$1 = state_70004;
var statearr_70028_70082 = state_70004__$1;
(statearr_70028_70082[(2)] = inst_69992);

(statearr_70028_70082[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (17))){
var inst_69952 = (state_70004[(16)]);
var inst_69951 = (state_70004[(2)]);
var inst_69952__$1 = cljs.core.get.call(null,inst_69951,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_69953 = cljs.core.get.call(null,inst_69951,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_69954 = cljs.core.get.call(null,inst_69951,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_69955 = cljs.core.get.call(null,inst_69951,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_69956 = fluree.db.util.core.current_time_millis.call(null);
var state_70004__$1 = (function (){var statearr_70029 = state_70004;
(statearr_70029[(17)] = inst_69954);

(statearr_70029[(14)] = inst_69956);

(statearr_70029[(9)] = inst_69955);

(statearr_70029[(7)] = inst_69953);

(statearr_70029[(16)] = inst_69952__$1);

return statearr_70029;
})();
if(cljs.core.truth_(inst_69952__$1)){
var statearr_70030_70083 = state_70004__$1;
(statearr_70030_70083[(1)] = (18));

} else {
var statearr_70031_70084 = state_70004__$1;
(statearr_70031_70084[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (3))){
var inst_70002 = (state_70004[(2)]);
var state_70004__$1 = state_70004;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70004__$1,inst_70002);
} else {
if((state_val_70005 === (12))){
var state_70004__$1 = state_70004;
var statearr_70032_70085 = state_70004__$1;
(statearr_70032_70085[(2)] = true);

(statearr_70032_70085[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (2))){
var _ = (function (){var statearr_70033 = state_70004;
(statearr_70033[(4)] = cljs.core.cons.call(null,(5),(state_70004[(4)])));

return statearr_70033;
})();
var inst_69924 = (opts == null);
var state_70004__$1 = state_70004;
if(cljs.core.truth_(inst_69924)){
var statearr_70034_70086 = state_70004__$1;
(statearr_70034_70086[(1)] = (6));

} else {
var statearr_70035_70087 = state_70004__$1;
(statearr_70035_70087[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (23))){
var inst_69960 = (state_70004[(8)]);
var inst_69955 = (state_70004[(9)]);
var inst_69965 = (state_70004[(2)]);
var inst_69966 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_69967 = [new cljs.core.Keyword(null,"delete-db","delete-db",1646085839),ledger,inst_69960,inst_69965];
var inst_69968 = cljs.core.PersistentHashMap.fromArrays(inst_69966,inst_69967);
var state_70004__$1 = (function (){var statearr_70036 = state_70004;
(statearr_70036[(11)] = inst_69968);

return statearr_70036;
})();
if(cljs.core.truth_(inst_69955)){
var statearr_70037_70088 = state_70004__$1;
(statearr_70037_70088[(1)] = (24));

} else {
var statearr_70038_70089 = state_70004__$1;
(statearr_70038_70089[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (19))){
var inst_69956 = (state_70004[(14)]);
var state_70004__$1 = state_70004;
var statearr_70039_70090 = state_70004__$1;
(statearr_70039_70090[(2)] = inst_69956);

(statearr_70039_70090[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (11))){
var inst_69946 = (state_70004[(2)]);
var state_70004__$1 = state_70004;
if(cljs.core.truth_(inst_69946)){
var statearr_70041_70091 = state_70004__$1;
(statearr_70041_70091[(1)] = (15));

} else {
var statearr_70042_70092 = state_70004__$1;
(statearr_70042_70092[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (9))){
var inst_69929 = (state_70004[(13)]);
var inst_69935 = inst_69929.cljs$lang$protocol_mask$partition0$;
var inst_69936 = (inst_69935 & (64));
var inst_69937 = inst_69929.cljs$core$ISeq$;
var inst_69938 = (cljs.core.PROTOCOL_SENTINEL === inst_69937);
var inst_69939 = ((inst_69936) || (inst_69938));
var state_70004__$1 = state_70004;
if(cljs.core.truth_(inst_69939)){
var statearr_70043_70093 = state_70004__$1;
(statearr_70043_70093[(1)] = (12));

} else {
var statearr_70044_70094 = state_70004__$1;
(statearr_70044_70094[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (5))){
var _ = (function (){var statearr_70045 = state_70004;
(statearr_70045[(4)] = cljs.core.rest.call(null,(state_70004[(4)])));

return statearr_70045;
})();
var state_70004__$1 = state_70004;
var ex70040 = (state_70004__$1[(2)]);
var statearr_70046_70095 = state_70004__$1;
(statearr_70046_70095[(5)] = ex70040);


var statearr_70047_70096 = state_70004__$1;
(statearr_70047_70096[(1)] = (4));

(statearr_70047_70096[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (14))){
var inst_69943 = (state_70004[(2)]);
var state_70004__$1 = state_70004;
var statearr_70048_70097 = state_70004__$1;
(statearr_70048_70097[(2)] = inst_69943);

(statearr_70048_70097[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (26))){
var inst_69955 = (state_70004[(9)]);
var inst_69974 = (state_70004[(2)]);
var state_70004__$1 = (function (){var statearr_70049 = state_70004;
(statearr_70049[(10)] = inst_69974);

return statearr_70049;
})();
if(cljs.core.truth_(inst_69955)){
var statearr_70050_70098 = state_70004__$1;
(statearr_70050_70098[(1)] = (27));

} else {
var statearr_70051_70099 = state_70004__$1;
(statearr_70051_70099[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (16))){
var inst_69929 = (state_70004[(13)]);
var state_70004__$1 = state_70004;
var statearr_70052_70100 = state_70004__$1;
(statearr_70052_70100[(2)] = inst_69929);

(statearr_70052_70100[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (30))){
var inst_69979 = (state_70004[(15)]);
var inst_69974 = (state_70004[(10)]);
var inst_69981 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_69982 = [inst_69974,inst_69979];
var inst_69983 = cljs.core.PersistentHashMap.fromArrays(inst_69981,inst_69982);
var inst_69984 = fluree.db.operations.command_async.call(null,conn,inst_69983);
var state_70004__$1 = state_70004;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70004__$1,(33),inst_69984);
} else {
if((state_val_70005 === (10))){
var state_70004__$1 = state_70004;
var statearr_70053_70101 = state_70004__$1;
(statearr_70053_70101[(2)] = false);

(statearr_70053_70101[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (18))){
var inst_69952 = (state_70004[(16)]);
var state_70004__$1 = state_70004;
var statearr_70054_70102 = state_70004__$1;
(statearr_70054_70102[(2)] = inst_69952);

(statearr_70054_70102[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70005 === (8))){
var inst_69929 = (state_70004[(13)]);
var inst_69929__$1 = (state_70004[(2)]);
var inst_69930 = fluree.db.connection_js.check_connection.call(null,conn,inst_69929__$1);
var inst_69932 = (inst_69929__$1 == null);
var inst_69933 = cljs.core.not.call(null,inst_69932);
var state_70004__$1 = (function (){var statearr_70055 = state_70004;
(statearr_70055[(18)] = inst_69930);

(statearr_70055[(13)] = inst_69929__$1);

return statearr_70055;
})();
if(inst_69933){
var statearr_70056_70103 = state_70004__$1;
(statearr_70056_70103[(1)] = (9));

} else {
var statearr_70057_70104 = state_70004__$1;
(statearr_70057_70104[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2879__auto__ = null;
var flureenjs$state_machine__2879__auto____0 = (function (){
var statearr_70058 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70058[(0)] = flureenjs$state_machine__2879__auto__);

(statearr_70058[(1)] = (1));

return statearr_70058;
});
var flureenjs$state_machine__2879__auto____1 = (function (state_70004){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_70004);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e70059){var ex__2882__auto__ = e70059;
var statearr_70060_70105 = state_70004;
(statearr_70060_70105[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_70004[(4)]))){
var statearr_70061_70106 = state_70004;
(statearr_70061_70106[(1)] = cljs.core.first.call(null,(state_70004[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70107 = state_70004;
state_70004 = G__70107;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$state_machine__2879__auto__ = function(state_70004){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$state_machine__2879__auto____1.call(this,state_70004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2879__auto____0;
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2879__auto____1;
return flureenjs$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_70062 = f__2902__auto__.call(null);
(statearr_70062[(6)] = c__2901__auto__);

return statearr_70062;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureenjs.delete_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Returns promise with ledger's status as a map, including index, indexes, block, and status.
 *   If ledger doesn't exist, will return an empty map.
 */
flureenjs.ledger_info = (function flureenjs$ledger_info(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_70126){
var state_val_70127 = (state_70126[(1)]);
if((state_val_70127 === (1))){
var state_70126__$1 = state_70126;
var statearr_70128_70143 = state_70126__$1;
(statearr_70128_70143[(2)] = null);

(statearr_70128_70143[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70127 === (2))){
var _ = (function (){var statearr_70129 = state_70126;
(statearr_70129[(4)] = cljs.core.cons.call(null,(5),(state_70126[(4)])));

return statearr_70129;
})();
var inst_70116 = fluree.db.operations.ledger_info_async.call(null,conn,ledger);
var state_70126__$1 = state_70126;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70126__$1,(6),inst_70116);
} else {
if((state_val_70127 === (3))){
var inst_70124 = (state_70126[(2)]);
var state_70126__$1 = state_70126;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70126__$1,inst_70124);
} else {
if((state_val_70127 === (4))){
var inst_70108 = (state_70126[(2)]);
var inst_70109 = fluree.db.util.log.error.call(null,inst_70108);
var inst_70110 = reject.call(null,inst_70108);
var state_70126__$1 = (function (){var statearr_70131 = state_70126;
(statearr_70131[(7)] = inst_70109);

return statearr_70131;
})();
var statearr_70132_70144 = state_70126__$1;
(statearr_70132_70144[(2)] = inst_70110);

(statearr_70132_70144[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70127 === (5))){
var _ = (function (){var statearr_70133 = state_70126;
(statearr_70133[(4)] = cljs.core.rest.call(null,(state_70126[(4)])));

return statearr_70133;
})();
var state_70126__$1 = state_70126;
var ex70130 = (state_70126__$1[(2)]);
var statearr_70134_70145 = state_70126__$1;
(statearr_70134_70145[(5)] = ex70130);


var statearr_70135_70146 = state_70126__$1;
(statearr_70135_70146[(1)] = (4));

(statearr_70135_70146[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70127 === (6))){
var inst_70118 = (state_70126[(2)]);
var inst_70119 = fluree.db.util.async.throw_err.call(null,inst_70118);
var inst_70120 = cljs.core.clj__GT_js.call(null,inst_70119);
var inst_70121 = resolve.call(null,inst_70120);
var _ = (function (){var statearr_70136 = state_70126;
(statearr_70136[(4)] = cljs.core.rest.call(null,(state_70126[(4)])));

return statearr_70136;
})();
var state_70126__$1 = state_70126;
var statearr_70137_70147 = state_70126__$1;
(statearr_70137_70147[(2)] = inst_70121);

(statearr_70137_70147[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledger_info_$_state_machine__2879__auto__ = null;
var flureenjs$ledger_info_$_state_machine__2879__auto____0 = (function (){
var statearr_70138 = [null,null,null,null,null,null,null,null];
(statearr_70138[(0)] = flureenjs$ledger_info_$_state_machine__2879__auto__);

(statearr_70138[(1)] = (1));

return statearr_70138;
});
var flureenjs$ledger_info_$_state_machine__2879__auto____1 = (function (state_70126){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_70126);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e70139){var ex__2882__auto__ = e70139;
var statearr_70140_70148 = state_70126;
(statearr_70140_70148[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_70126[(4)]))){
var statearr_70141_70149 = state_70126;
(statearr_70141_70149[(1)] = cljs.core.first.call(null,(state_70126[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70150 = state_70126;
state_70126 = G__70150;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$ledger_info_$_state_machine__2879__auto__ = function(state_70126){
switch(arguments.length){
case 0:
return flureenjs$ledger_info_$_state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$ledger_info_$_state_machine__2879__auto____1.call(this,state_70126);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledger_info_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledger_info_$_state_machine__2879__auto____0;
flureenjs$ledger_info_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledger_info_$_state_machine__2879__auto____1;
return flureenjs$ledger_info_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_70142 = f__2902__auto__.call(null);
(statearr_70142[(6)] = c__2901__auto__);

return statearr_70142;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureenjs.ledger_info', flureenjs.ledger_info);
/**
 * Returns promise with a list of ledgers the connected server is currently serving.
 */
flureenjs.ledger_list = (function flureenjs$ledger_list(conn){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_70169){
var state_val_70170 = (state_70169[(1)]);
if((state_val_70170 === (1))){
var state_70169__$1 = state_70169;
var statearr_70171_70186 = state_70169__$1;
(statearr_70171_70186[(2)] = null);

(statearr_70171_70186[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70170 === (2))){
var _ = (function (){var statearr_70172 = state_70169;
(statearr_70172[(4)] = cljs.core.cons.call(null,(5),(state_70169[(4)])));

return statearr_70172;
})();
var inst_70159 = fluree.db.operations.ledgers_async.call(null,conn);
var state_70169__$1 = state_70169;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70169__$1,(6),inst_70159);
} else {
if((state_val_70170 === (3))){
var inst_70167 = (state_70169[(2)]);
var state_70169__$1 = state_70169;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70169__$1,inst_70167);
} else {
if((state_val_70170 === (4))){
var inst_70151 = (state_70169[(2)]);
var inst_70152 = fluree.db.util.log.error.call(null,inst_70151);
var inst_70153 = reject.call(null,inst_70151);
var state_70169__$1 = (function (){var statearr_70174 = state_70169;
(statearr_70174[(7)] = inst_70152);

return statearr_70174;
})();
var statearr_70175_70187 = state_70169__$1;
(statearr_70175_70187[(2)] = inst_70153);

(statearr_70175_70187[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70170 === (5))){
var _ = (function (){var statearr_70176 = state_70169;
(statearr_70176[(4)] = cljs.core.rest.call(null,(state_70169[(4)])));

return statearr_70176;
})();
var state_70169__$1 = state_70169;
var ex70173 = (state_70169__$1[(2)]);
var statearr_70177_70188 = state_70169__$1;
(statearr_70177_70188[(5)] = ex70173);


var statearr_70178_70189 = state_70169__$1;
(statearr_70178_70189[(1)] = (4));

(statearr_70178_70189[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70170 === (6))){
var inst_70161 = (state_70169[(2)]);
var inst_70162 = fluree.db.util.async.throw_err.call(null,inst_70161);
var inst_70163 = cljs.core.clj__GT_js.call(null,inst_70162);
var inst_70164 = resolve.call(null,inst_70163);
var _ = (function (){var statearr_70179 = state_70169;
(statearr_70179[(4)] = cljs.core.rest.call(null,(state_70169[(4)])));

return statearr_70179;
})();
var state_70169__$1 = state_70169;
var statearr_70180_70190 = state_70169__$1;
(statearr_70180_70190[(2)] = inst_70164);

(statearr_70180_70190[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledger_list_$_state_machine__2879__auto__ = null;
var flureenjs$ledger_list_$_state_machine__2879__auto____0 = (function (){
var statearr_70181 = [null,null,null,null,null,null,null,null];
(statearr_70181[(0)] = flureenjs$ledger_list_$_state_machine__2879__auto__);

(statearr_70181[(1)] = (1));

return statearr_70181;
});
var flureenjs$ledger_list_$_state_machine__2879__auto____1 = (function (state_70169){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_70169);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e70182){var ex__2882__auto__ = e70182;
var statearr_70183_70191 = state_70169;
(statearr_70183_70191[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_70169[(4)]))){
var statearr_70184_70192 = state_70169;
(statearr_70184_70192[(1)] = cljs.core.first.call(null,(state_70169[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70193 = state_70169;
state_70169 = G__70193;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$ledger_list_$_state_machine__2879__auto__ = function(state_70169){
switch(arguments.length){
case 0:
return flureenjs$ledger_list_$_state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$ledger_list_$_state_machine__2879__auto____1.call(this,state_70169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledger_list_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledger_list_$_state_machine__2879__auto____0;
flureenjs$ledger_list_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledger_list_$_state_machine__2879__auto____1;
return flureenjs$ledger_list_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_70185 = f__2902__auto__.call(null);
(statearr_70185[(6)] = c__2901__auto__);

return statearr_70185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureenjs.ledger_list', flureenjs.ledger_list);
/**
 * Returns promise with ledger's  with ledger's stats, including db size and # of flakes.
 *   If ledger doesn't exist, will return an empty map.
 */
flureenjs.ledger_stats = (function flureenjs$ledger_stats(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_70212){
var state_val_70213 = (state_70212[(1)]);
if((state_val_70213 === (1))){
var state_70212__$1 = state_70212;
var statearr_70214_70229 = state_70212__$1;
(statearr_70214_70229[(2)] = null);

(statearr_70214_70229[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70213 === (2))){
var _ = (function (){var statearr_70215 = state_70212;
(statearr_70215[(4)] = cljs.core.cons.call(null,(5),(state_70212[(4)])));

return statearr_70215;
})();
var inst_70202 = fluree.db.operations.ledger_stats_async.call(null,conn,ledger);
var state_70212__$1 = state_70212;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70212__$1,(6),inst_70202);
} else {
if((state_val_70213 === (3))){
var inst_70210 = (state_70212[(2)]);
var state_70212__$1 = state_70212;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70212__$1,inst_70210);
} else {
if((state_val_70213 === (4))){
var inst_70194 = (state_70212[(2)]);
var inst_70195 = fluree.db.util.log.error.call(null,inst_70194);
var inst_70196 = reject.call(null,inst_70194);
var state_70212__$1 = (function (){var statearr_70217 = state_70212;
(statearr_70217[(7)] = inst_70195);

return statearr_70217;
})();
var statearr_70218_70230 = state_70212__$1;
(statearr_70218_70230[(2)] = inst_70196);

(statearr_70218_70230[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70213 === (5))){
var _ = (function (){var statearr_70219 = state_70212;
(statearr_70219[(4)] = cljs.core.rest.call(null,(state_70212[(4)])));

return statearr_70219;
})();
var state_70212__$1 = state_70212;
var ex70216 = (state_70212__$1[(2)]);
var statearr_70220_70231 = state_70212__$1;
(statearr_70220_70231[(5)] = ex70216);


var statearr_70221_70232 = state_70212__$1;
(statearr_70221_70232[(1)] = (4));

(statearr_70221_70232[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70213 === (6))){
var inst_70204 = (state_70212[(2)]);
var inst_70205 = fluree.db.util.async.throw_err.call(null,inst_70204);
var inst_70206 = cljs.core.clj__GT_js.call(null,inst_70205);
var inst_70207 = resolve.call(null,inst_70206);
var _ = (function (){var statearr_70222 = state_70212;
(statearr_70222[(4)] = cljs.core.rest.call(null,(state_70212[(4)])));

return statearr_70222;
})();
var state_70212__$1 = state_70212;
var statearr_70223_70233 = state_70212__$1;
(statearr_70223_70233[(2)] = inst_70207);

(statearr_70223_70233[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$ledger_stats_$_state_machine__2879__auto__ = null;
var flureenjs$ledger_stats_$_state_machine__2879__auto____0 = (function (){
var statearr_70224 = [null,null,null,null,null,null,null,null];
(statearr_70224[(0)] = flureenjs$ledger_stats_$_state_machine__2879__auto__);

(statearr_70224[(1)] = (1));

return statearr_70224;
});
var flureenjs$ledger_stats_$_state_machine__2879__auto____1 = (function (state_70212){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_70212);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e70225){var ex__2882__auto__ = e70225;
var statearr_70226_70234 = state_70212;
(statearr_70226_70234[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_70212[(4)]))){
var statearr_70227_70235 = state_70212;
(statearr_70227_70235[(1)] = cljs.core.first.call(null,(state_70212[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70236 = state_70212;
state_70212 = G__70236;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$ledger_stats_$_state_machine__2879__auto__ = function(state_70212){
switch(arguments.length){
case 0:
return flureenjs$ledger_stats_$_state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$ledger_stats_$_state_machine__2879__auto____1.call(this,state_70212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$ledger_stats_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$ledger_stats_$_state_machine__2879__auto____0;
flureenjs$ledger_stats_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$ledger_stats_$_state_machine__2879__auto____1;
return flureenjs$ledger_stats_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_70228 = f__2902__auto__.call(null);
(statearr_70228[(6)] = c__2901__auto__);

return statearr_70228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureenjs.ledger_stats', flureenjs.ledger_stats);
/**
 * Attempts to create new ledger.
 * 
 * A successful result will kick off a process on the ledger server(s) to bootstrap.
 * 
 * Once successful, will return with a command-id.
 * 
 * Ledger creation is handled asynchronously and may not be immediately available.
 * 
 * Options include:
 * - :alias       - Alias, if different than db-ident.
 * - :root        - Root account id to bootstrap with (string). Defaults to connection default account id.
 * - :doc         - Optional doc string about this db.
 * - :fork        - If forking an existing db, ref to db (actual identity, not db-ident). Must exist in network db.
 * - :forkBlock   - If fork is provided, optionally provide the block to fork at. Defaults to latest known.
 * - :persistResp - Respond immediately once persisted with the dbid, don't wait for transaction to be finished
 * 
 */
flureenjs.new_ledger = (function flureenjs$new_ledger(var_args){
var G__70238 = arguments.length;
switch (G__70238) {
case 2:
return flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.new_ledger', flureenjs.new_ledger);

(flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return flureenjs.new_ledger.call(null,conn,ledger,null);
}));

(flureenjs.new_ledger.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_70376){
var state_val_70377 = (state_70376[(1)]);
if((state_val_70377 === (7))){
var inst_70261 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_70376__$1 = state_70376;
var statearr_70378_70456 = state_70376__$1;
(statearr_70378_70456[(2)] = inst_70261);

(statearr_70378_70456[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (20))){
var inst_70297 = (state_70376[(7)]);
var inst_70307 = (state_70376[(8)]);
var inst_70300 = (state_70376[(9)]);
var inst_70307__$1 = (state_70376[(2)]);
var inst_70308 = fluree.db.graphdb.validate_ledger_name.call(null,inst_70307__$1,"ledger");
var inst_70309 = fluree.db.graphdb.validate_ledger_name.call(null,inst_70300,"network");
var state_70376__$1 = (function (){var statearr_70379 = state_70376;
(statearr_70379[(8)] = inst_70307__$1);

(statearr_70379[(10)] = inst_70309);

(statearr_70379[(11)] = inst_70308);

return statearr_70379;
})();
if(cljs.core.truth_(inst_70297)){
var statearr_70380_70457 = state_70376__$1;
(statearr_70380_70457[(1)] = (21));

} else {
var statearr_70381_70458 = state_70376__$1;
(statearr_70381_70458[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (27))){
var inst_70315 = (state_70376[(12)]);
var inst_70316 = (state_70376[(13)]);
var inst_70323 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70315),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70316)].join('');
var state_70376__$1 = state_70376;
var statearr_70382_70459 = state_70376__$1;
(statearr_70382_70459[(2)] = inst_70323);

(statearr_70382_70459[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (1))){
var state_70376__$1 = state_70376;
var statearr_70383_70460 = state_70376__$1;
(statearr_70383_70460[(2)] = null);

(statearr_70383_70460[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (24))){
var inst_70316 = (state_70376[(13)]);
var inst_70318 = fluree.db.graphdb.validate_ledger_name.call(null,inst_70316,"alias");
var state_70376__$1 = state_70376;
var statearr_70384_70461 = state_70376__$1;
(statearr_70384_70461[(2)] = inst_70318);

(statearr_70384_70461[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (39))){
var inst_70346 = (state_70376[(14)]);
var inst_70290 = (state_70376[(15)]);
var inst_70348 = fluree.crypto.sign_message.call(null,inst_70346,inst_70290);
var state_70376__$1 = state_70376;
var statearr_70385_70462 = state_70376__$1;
(statearr_70385_70462[(2)] = inst_70348);

(statearr_70385_70462[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (46))){
var inst_70363 = (state_70376[(2)]);
var inst_70364 = fluree.db.util.async.throw_err.call(null,inst_70363);
var state_70376__$1 = state_70376;
var statearr_70386_70463 = state_70376__$1;
(statearr_70386_70463[(2)] = inst_70364);

(statearr_70386_70463[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (4))){
var inst_70239 = (state_70376[(2)]);
var inst_70240 = fluree.db.util.log.error.call(null,inst_70239);
var inst_70241 = cljs.core.ex_data.call(null,inst_70239);
var inst_70242 = cljs.core.ex_message.call(null,inst_70239);
var inst_70243 = cljs.core.assoc.call(null,inst_70241,new cljs.core.Keyword(null,"message","message",-406056002),inst_70242);
var inst_70244 = cljs.core.clj__GT_js.call(null,inst_70243);
var inst_70245 = reject.call(null,inst_70244);
var state_70376__$1 = (function (){var statearr_70387 = state_70376;
(statearr_70387[(16)] = inst_70240);

return statearr_70387;
})();
var statearr_70388_70464 = state_70376__$1;
(statearr_70388_70464[(2)] = inst_70245);

(statearr_70388_70464[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (15))){
var inst_70263 = (state_70376[(17)]);
var inst_70282 = cljs.core.apply.call(null,cljs.core.hash_map,inst_70263);
var state_70376__$1 = state_70376;
var statearr_70389_70465 = state_70376__$1;
(statearr_70389_70465[(2)] = inst_70282);

(statearr_70389_70465[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (21))){
var inst_70311 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var state_70376__$1 = state_70376;
var statearr_70390_70466 = state_70376__$1;
(statearr_70390_70466[(2)] = inst_70311);

(statearr_70390_70466[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (31))){
var inst_70327 = (state_70376[(18)]);
var state_70376__$1 = state_70376;
var statearr_70391_70467 = state_70376__$1;
(statearr_70391_70467[(2)] = inst_70327);

(statearr_70391_70467[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (32))){
var inst_70294 = (state_70376[(19)]);
var inst_70331 = (state_70376[(2)]);
var state_70376__$1 = (function (){var statearr_70392 = state_70376;
(statearr_70392[(20)] = inst_70331);

return statearr_70392;
})();
if(cljs.core.truth_(inst_70294)){
var statearr_70393_70468 = state_70376__$1;
(statearr_70393_70468[(1)] = (33));

} else {
var statearr_70394_70469 = state_70376__$1;
(statearr_70394_70469[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (40))){
var state_70376__$1 = state_70376;
var statearr_70395_70470 = state_70376__$1;
(statearr_70395_70470[(2)] = null);

(statearr_70395_70470[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (33))){
var inst_70294 = (state_70376[(19)]);
var state_70376__$1 = state_70376;
var statearr_70396_70471 = state_70376__$1;
(statearr_70396_70471[(2)] = inst_70294);

(statearr_70396_70471[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (13))){
var state_70376__$1 = state_70376;
var statearr_70397_70472 = state_70376__$1;
(statearr_70397_70472[(2)] = false);

(statearr_70397_70472[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (22))){
var state_70376__$1 = state_70376;
var statearr_70398_70473 = state_70376__$1;
(statearr_70398_70473[(2)] = null);

(statearr_70398_70473[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (36))){
var inst_70340 = (state_70376[(21)]);
var inst_70342 = fluree.db.util.core.without_nils.call(null,inst_70340);
var inst_70343 = fluree.db.util.json.stringify.call(null,inst_70342);
var state_70376__$1 = state_70376;
var statearr_70399_70474 = state_70376__$1;
(statearr_70399_70474[(2)] = inst_70343);

(statearr_70399_70474[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (41))){
var inst_70290 = (state_70376[(15)]);
var inst_70351 = (state_70376[(2)]);
var state_70376__$1 = (function (){var statearr_70400 = state_70376;
(statearr_70400[(22)] = inst_70351);

return statearr_70400;
})();
if(cljs.core.truth_(inst_70290)){
var statearr_70401_70475 = state_70376__$1;
(statearr_70401_70475[(1)] = (42));

} else {
var statearr_70402_70476 = state_70376__$1;
(statearr_70402_70476[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (43))){
var inst_70340 = (state_70376[(21)]);
var inst_70361 = fluree.db.operations.unsigned_command_async.call(null,conn,inst_70340);
var state_70376__$1 = state_70376;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70376__$1,(46),inst_70361);
} else {
if((state_val_70377 === (29))){
var inst_70288 = (state_70376[(23)]);
var inst_70326 = (state_70376[(2)]);
var inst_70327 = fluree.db.util.core.current_time_millis.call(null);
var state_70376__$1 = (function (){var statearr_70403 = state_70376;
(statearr_70403[(24)] = inst_70326);

(statearr_70403[(18)] = inst_70327);

return statearr_70403;
})();
if(cljs.core.truth_(inst_70288)){
var statearr_70404_70477 = state_70376__$1;
(statearr_70404_70477[(1)] = (30));

} else {
var statearr_70405_70478 = state_70376__$1;
(statearr_70405_70478[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (44))){
var inst_70366 = (state_70376[(2)]);
var inst_70367 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211)];
var inst_70368 = [(200),inst_70366];
var inst_70369 = cljs.core.PersistentHashMap.fromArrays(inst_70367,inst_70368);
var inst_70370 = cljs.core.clj__GT_js.call(null,inst_70369);
var inst_70371 = resolve.call(null,inst_70370);
var _ = (function (){var statearr_70406 = state_70376;
(statearr_70406[(4)] = cljs.core.rest.call(null,(state_70376[(4)])));

return statearr_70406;
})();
var state_70376__$1 = state_70376;
var statearr_70407_70479 = state_70376__$1;
(statearr_70407_70479[(2)] = inst_70371);

(statearr_70407_70479[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (6))){
var state_70376__$1 = state_70376;
var statearr_70408_70480 = state_70376__$1;
(statearr_70408_70480[(2)] = null);

(statearr_70408_70480[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (28))){
var state_70376__$1 = state_70376;
var statearr_70409_70481 = state_70376__$1;
(statearr_70409_70481[(2)] = null);

(statearr_70409_70481[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (25))){
var state_70376__$1 = state_70376;
var statearr_70410_70482 = state_70376__$1;
(statearr_70410_70482[(2)] = null);

(statearr_70410_70482[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (34))){
var inst_70327 = (state_70376[(18)]);
var inst_70334 = (inst_70327 + (30000));
var state_70376__$1 = state_70376;
var statearr_70411_70483 = state_70376__$1;
(statearr_70411_70483[(2)] = inst_70334);

(statearr_70411_70483[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (17))){
var inst_70301 = (state_70376[(25)]);
var inst_70285 = (state_70376[(2)]);
var inst_70286 = cljs.core.get.call(null,inst_70285,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_70287 = cljs.core.get.call(null,inst_70285,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_70288 = cljs.core.get.call(null,inst_70285,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_70289 = cljs.core.get.call(null,inst_70285,new cljs.core.Keyword(null,"doc","doc",1913296891));
var inst_70290 = cljs.core.get.call(null,inst_70285,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_70291 = cljs.core.get.call(null,inst_70285,new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508));
var inst_70292 = cljs.core.get.call(null,inst_70285,new cljs.core.Keyword(null,"copy","copy",-1077617309));
var inst_70293 = cljs.core.get.call(null,inst_70285,new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547));
var inst_70294 = cljs.core.get.call(null,inst_70285,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_70295 = cljs.core.get.call(null,inst_70285,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_70296 = cljs.core.get.call(null,inst_70285,new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846));
var inst_70297 = cljs.core.get.call(null,inst_70285,new cljs.core.Keyword(null,"alias","alias",-2039751630));
var inst_70298 = cljs.core.get.call(null,inst_70285,new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710));
var inst_70299 = fluree.db.graphdb.validate_ledger_ident.call(null,ledger);
var inst_70300 = cljs.core.nth.call(null,inst_70299,(0),null);
var inst_70301__$1 = cljs.core.nth.call(null,inst_70299,(1),null);
var inst_70302 = clojure.string.starts_with_QMARK_.call(null,inst_70301__$1,"$");
var state_70376__$1 = (function (){var statearr_70412 = state_70376;
(statearr_70412[(7)] = inst_70297);

(statearr_70412[(26)] = inst_70298);

(statearr_70412[(25)] = inst_70301__$1);

(statearr_70412[(27)] = inst_70289);

(statearr_70412[(19)] = inst_70294);

(statearr_70412[(28)] = inst_70295);

(statearr_70412[(29)] = inst_70291);

(statearr_70412[(30)] = inst_70292);

(statearr_70412[(31)] = inst_70293);

(statearr_70412[(23)] = inst_70288);

(statearr_70412[(9)] = inst_70300);

(statearr_70412[(32)] = inst_70296);

(statearr_70412[(33)] = inst_70287);

(statearr_70412[(34)] = inst_70286);

(statearr_70412[(15)] = inst_70290);

return statearr_70412;
})();
if(inst_70302){
var statearr_70413_70484 = state_70376__$1;
(statearr_70413_70484[(1)] = (18));

} else {
var statearr_70414_70485 = state_70376__$1;
(statearr_70414_70485[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (3))){
var inst_70374 = (state_70376[(2)]);
var state_70376__$1 = state_70376;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70376__$1,inst_70374);
} else {
if((state_val_70377 === (12))){
var state_70376__$1 = state_70376;
var statearr_70415_70486 = state_70376__$1;
(statearr_70415_70486[(2)] = true);

(statearr_70415_70486[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (2))){
var _ = (function (){var statearr_70416 = state_70376;
(statearr_70416[(4)] = cljs.core.cons.call(null,(5),(state_70376[(4)])));

return statearr_70416;
})();
var inst_70258 = (opts == null);
var state_70376__$1 = state_70376;
if(cljs.core.truth_(inst_70258)){
var statearr_70417_70487 = state_70376__$1;
(statearr_70417_70487[(1)] = (6));

} else {
var statearr_70418_70488 = state_70376__$1;
(statearr_70418_70488[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (23))){
var inst_70297 = (state_70376[(7)]);
var inst_70314 = (state_70376[(2)]);
var inst_70315 = cljs.core.nth.call(null,inst_70314,(0),null);
var inst_70316 = cljs.core.nth.call(null,inst_70314,(1),null);
var state_70376__$1 = (function (){var statearr_70419 = state_70376;
(statearr_70419[(12)] = inst_70315);

(statearr_70419[(13)] = inst_70316);

return statearr_70419;
})();
if(cljs.core.truth_(inst_70297)){
var statearr_70420_70489 = state_70376__$1;
(statearr_70420_70489[(1)] = (24));

} else {
var statearr_70421_70490 = state_70376__$1;
(statearr_70421_70490[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (35))){
var inst_70298 = (state_70376[(26)]);
var inst_70326 = (state_70376[(24)]);
var inst_70307 = (state_70376[(8)]);
var inst_70289 = (state_70376[(27)]);
var inst_70295 = (state_70376[(28)]);
var inst_70291 = (state_70376[(29)]);
var inst_70292 = (state_70376[(30)]);
var inst_70293 = (state_70376[(31)]);
var inst_70300 = (state_70376[(9)]);
var inst_70296 = (state_70376[(32)]);
var inst_70331 = (state_70376[(20)]);
var inst_70287 = (state_70376[(33)]);
var inst_70290 = (state_70376[(15)]);
var inst_70336 = (state_70376[(2)]);
var inst_70337 = [new cljs.core.Keyword(null,"copy","copy",-1077617309),new cljs.core.Keyword(null,"snapshotBlock","snapshotBlock",1503536547),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"alias","alias",-2039751630),new cljs.core.Keyword(null,"snapshot","snapshot",-1274785710),new cljs.core.Keyword(null,"copyBlock","copyBlock",-1204032846),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508)];
var inst_70338 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70300),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70307)].join('');
var inst_70339 = [inst_70292,inst_70293,inst_70338,new cljs.core.Keyword(null,"new-db","new-db",1305352401),inst_70336,inst_70295,inst_70326,inst_70298,inst_70296,inst_70287,inst_70331,inst_70289,inst_70291];
var inst_70340 = cljs.core.PersistentHashMap.fromArrays(inst_70337,inst_70339);
var state_70376__$1 = (function (){var statearr_70422 = state_70376;
(statearr_70422[(21)] = inst_70340);

return statearr_70422;
})();
if(cljs.core.truth_(inst_70290)){
var statearr_70423_70491 = state_70376__$1;
(statearr_70423_70491[(1)] = (36));

} else {
var statearr_70424_70492 = state_70376__$1;
(statearr_70424_70492[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (19))){
var inst_70301 = (state_70376[(25)]);
var state_70376__$1 = state_70376;
var statearr_70425_70493 = state_70376__$1;
(statearr_70425_70493[(2)] = inst_70301);

(statearr_70425_70493[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (11))){
var inst_70280 = (state_70376[(2)]);
var state_70376__$1 = state_70376;
if(cljs.core.truth_(inst_70280)){
var statearr_70427_70494 = state_70376__$1;
(statearr_70427_70494[(1)] = (15));

} else {
var statearr_70428_70495 = state_70376__$1;
(statearr_70428_70495[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (9))){
var inst_70263 = (state_70376[(17)]);
var inst_70269 = inst_70263.cljs$lang$protocol_mask$partition0$;
var inst_70270 = (inst_70269 & (64));
var inst_70271 = inst_70263.cljs$core$ISeq$;
var inst_70272 = (cljs.core.PROTOCOL_SENTINEL === inst_70271);
var inst_70273 = ((inst_70270) || (inst_70272));
var state_70376__$1 = state_70376;
if(cljs.core.truth_(inst_70273)){
var statearr_70429_70496 = state_70376__$1;
(statearr_70429_70496[(1)] = (12));

} else {
var statearr_70430_70497 = state_70376__$1;
(statearr_70430_70497[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (5))){
var _ = (function (){var statearr_70431 = state_70376;
(statearr_70431[(4)] = cljs.core.rest.call(null,(state_70376[(4)])));

return statearr_70431;
})();
var state_70376__$1 = state_70376;
var ex70426 = (state_70376__$1[(2)]);
var statearr_70432_70498 = state_70376__$1;
(statearr_70432_70498[(5)] = ex70426);


var statearr_70433_70499 = state_70376__$1;
(statearr_70433_70499[(1)] = (4));

(statearr_70433_70499[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (14))){
var inst_70277 = (state_70376[(2)]);
var state_70376__$1 = state_70376;
var statearr_70434_70500 = state_70376__$1;
(statearr_70434_70500[(2)] = inst_70277);

(statearr_70434_70500[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (45))){
var inst_70358 = (state_70376[(2)]);
var inst_70359 = fluree.db.util.async.throw_err.call(null,inst_70358);
var state_70376__$1 = state_70376;
var statearr_70435_70501 = state_70376__$1;
(statearr_70435_70501[(2)] = inst_70359);

(statearr_70435_70501[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (26))){
var inst_70297 = (state_70376[(7)]);
var inst_70321 = (state_70376[(2)]);
var state_70376__$1 = (function (){var statearr_70436 = state_70376;
(statearr_70436[(35)] = inst_70321);

return statearr_70436;
})();
if(cljs.core.truth_(inst_70297)){
var statearr_70437_70502 = state_70376__$1;
(statearr_70437_70502[(1)] = (27));

} else {
var statearr_70438_70503 = state_70376__$1;
(statearr_70438_70503[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (16))){
var inst_70263 = (state_70376[(17)]);
var state_70376__$1 = state_70376;
var statearr_70439_70504 = state_70376__$1;
(statearr_70439_70504[(2)] = inst_70263);

(statearr_70439_70504[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (38))){
var inst_70290 = (state_70376[(15)]);
var inst_70346 = (state_70376[(2)]);
var state_70376__$1 = (function (){var statearr_70440 = state_70376;
(statearr_70440[(14)] = inst_70346);

return statearr_70440;
})();
if(cljs.core.truth_(inst_70290)){
var statearr_70441_70505 = state_70376__$1;
(statearr_70441_70505[(1)] = (39));

} else {
var statearr_70442_70506 = state_70376__$1;
(statearr_70442_70506[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (30))){
var inst_70288 = (state_70376[(23)]);
var state_70376__$1 = state_70376;
var statearr_70443_70507 = state_70376__$1;
(statearr_70443_70507[(2)] = inst_70288);

(statearr_70443_70507[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (10))){
var state_70376__$1 = state_70376;
var statearr_70444_70508 = state_70376__$1;
(statearr_70444_70508[(2)] = false);

(statearr_70444_70508[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (18))){
var inst_70301 = (state_70376[(25)]);
var inst_70304 = cljs.core.subs.call(null,inst_70301,(1));
var state_70376__$1 = state_70376;
var statearr_70445_70509 = state_70376__$1;
(statearr_70445_70509[(2)] = inst_70304);

(statearr_70445_70509[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (42))){
var inst_70346 = (state_70376[(14)]);
var inst_70351 = (state_70376[(22)]);
var inst_70353 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200)];
var inst_70354 = [inst_70346,inst_70351];
var inst_70355 = cljs.core.PersistentHashMap.fromArrays(inst_70353,inst_70354);
var inst_70356 = fluree.db.operations.command_async.call(null,conn,inst_70355);
var state_70376__$1 = state_70376;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70376__$1,(45),inst_70356);
} else {
if((state_val_70377 === (37))){
var state_70376__$1 = state_70376;
var statearr_70446_70510 = state_70376__$1;
(statearr_70446_70510[(2)] = null);

(statearr_70446_70510[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70377 === (8))){
var inst_70263 = (state_70376[(17)]);
var inst_70263__$1 = (state_70376[(2)]);
var inst_70264 = fluree.db.connection_js.check_connection.call(null,conn,inst_70263__$1);
var inst_70266 = (inst_70263__$1 == null);
var inst_70267 = cljs.core.not.call(null,inst_70266);
var state_70376__$1 = (function (){var statearr_70447 = state_70376;
(statearr_70447[(36)] = inst_70264);

(statearr_70447[(17)] = inst_70263__$1);

return statearr_70447;
})();
if(inst_70267){
var statearr_70448_70511 = state_70376__$1;
(statearr_70448_70511[(1)] = (9));

} else {
var statearr_70449_70512 = state_70376__$1;
(statearr_70449_70512[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2879__auto__ = null;
var flureenjs$state_machine__2879__auto____0 = (function (){
var statearr_70450 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_70450[(0)] = flureenjs$state_machine__2879__auto__);

(statearr_70450[(1)] = (1));

return statearr_70450;
});
var flureenjs$state_machine__2879__auto____1 = (function (state_70376){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_70376);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e70451){var ex__2882__auto__ = e70451;
var statearr_70452_70513 = state_70376;
(statearr_70452_70513[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_70376[(4)]))){
var statearr_70453_70514 = state_70376;
(statearr_70453_70514[(1)] = cljs.core.first.call(null,(state_70376[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70515 = state_70376;
state_70376 = G__70515;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$state_machine__2879__auto__ = function(state_70376){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$state_machine__2879__auto____1.call(this,state_70376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2879__auto____0;
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2879__auto____1;
return flureenjs$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_70454 = f__2902__auto__.call(null);
(statearr_70454[(6)] = c__2901__auto__);

return statearr_70454;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureenjs.new_ledger.cljs$lang$maxFixedArity = 3);

/**
 * Resolves a ledger identity in the form of 'network/ledger-or-alias' and returns a
 *   tuple of either [network ledger alias] or [network ledger].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger id.
 * 
 *   If you are providing a ledger id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the db-ident.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias or id of testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 */
flureenjs.resolve_ledger = (function flureenjs$resolve_ledger(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_70531){
var state_val_70532 = (state_70531[(1)]);
if((state_val_70532 === (1))){
var state_70531__$1 = state_70531;
var statearr_70533_70548 = state_70531__$1;
(statearr_70533_70548[(2)] = null);

(statearr_70533_70548[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70532 === (2))){
var _ = (function (){var statearr_70534 = state_70531;
(statearr_70534[(4)] = cljs.core.cons.call(null,(5),(state_70531[(4)])));

return statearr_70534;
})();
var inst_70524 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var inst_70525 = cljs.core.clj__GT_js.call(null,inst_70524);
var inst_70526 = resolve.call(null,inst_70525);
var ___$1 = (function (){var statearr_70535 = state_70531;
(statearr_70535[(4)] = cljs.core.rest.call(null,(state_70531[(4)])));

return statearr_70535;
})();
var state_70531__$1 = state_70531;
var statearr_70536_70549 = state_70531__$1;
(statearr_70536_70549[(2)] = inst_70526);

(statearr_70536_70549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70532 === (3))){
var inst_70529 = (state_70531[(2)]);
var state_70531__$1 = state_70531;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70531__$1,inst_70529);
} else {
if((state_val_70532 === (4))){
var inst_70516 = (state_70531[(2)]);
var inst_70517 = fluree.db.util.log.error.call(null,inst_70516);
var inst_70518 = reject.call(null,inst_70516);
var state_70531__$1 = (function (){var statearr_70538 = state_70531;
(statearr_70538[(7)] = inst_70517);

return statearr_70538;
})();
var statearr_70539_70550 = state_70531__$1;
(statearr_70539_70550[(2)] = inst_70518);

(statearr_70539_70550[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70532 === (5))){
var _ = (function (){var statearr_70540 = state_70531;
(statearr_70540[(4)] = cljs.core.rest.call(null,(state_70531[(4)])));

return statearr_70540;
})();
var state_70531__$1 = state_70531;
var ex70537 = (state_70531__$1[(2)]);
var statearr_70541_70551 = state_70531__$1;
(statearr_70541_70551[(5)] = ex70537);


var statearr_70542_70552 = state_70531__$1;
(statearr_70542_70552[(1)] = (4));

(statearr_70542_70552[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$resolve_ledger_$_state_machine__2879__auto__ = null;
var flureenjs$resolve_ledger_$_state_machine__2879__auto____0 = (function (){
var statearr_70543 = [null,null,null,null,null,null,null,null];
(statearr_70543[(0)] = flureenjs$resolve_ledger_$_state_machine__2879__auto__);

(statearr_70543[(1)] = (1));

return statearr_70543;
});
var flureenjs$resolve_ledger_$_state_machine__2879__auto____1 = (function (state_70531){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_70531);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e70544){var ex__2882__auto__ = e70544;
var statearr_70545_70553 = state_70531;
(statearr_70545_70553[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_70531[(4)]))){
var statearr_70546_70554 = state_70531;
(statearr_70546_70554[(1)] = cljs.core.first.call(null,(state_70531[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70555 = state_70531;
state_70531 = G__70555;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$resolve_ledger_$_state_machine__2879__auto__ = function(state_70531){
switch(arguments.length){
case 0:
return flureenjs$resolve_ledger_$_state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$resolve_ledger_$_state_machine__2879__auto____1.call(this,state_70531);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$resolve_ledger_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$resolve_ledger_$_state_machine__2879__auto____0;
flureenjs$resolve_ledger_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$resolve_ledger_$_state_machine__2879__auto____1;
return flureenjs$resolve_ledger_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_70547 = f__2902__auto__.call(null);
(statearr_70547[(6)] = c__2901__auto__);

return statearr_70547;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureenjs.resolve_ledger', flureenjs.resolve_ledger);
/**
 * Returns actual session object for a given ledger.
 */
flureenjs.session = (function flureenjs$session(conn,ledger){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_70571){
var state_val_70572 = (state_70571[(1)]);
if((state_val_70572 === (1))){
var state_70571__$1 = state_70571;
var statearr_70573_70588 = state_70571__$1;
(statearr_70573_70588[(2)] = null);

(statearr_70573_70588[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70572 === (2))){
var _ = (function (){var statearr_70574 = state_70571;
(statearr_70574[(4)] = cljs.core.cons.call(null,(5),(state_70571[(4)])));

return statearr_70574;
})();
var inst_70564 = fluree.db.session.session.call(null,conn,ledger);
var inst_70565 = cljs.core.clj__GT_js.call(null,inst_70564);
var inst_70566 = resolve.call(null,inst_70565);
var ___$1 = (function (){var statearr_70575 = state_70571;
(statearr_70575[(4)] = cljs.core.rest.call(null,(state_70571[(4)])));

return statearr_70575;
})();
var state_70571__$1 = state_70571;
var statearr_70576_70589 = state_70571__$1;
(statearr_70576_70589[(2)] = inst_70566);

(statearr_70576_70589[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70572 === (3))){
var inst_70569 = (state_70571[(2)]);
var state_70571__$1 = state_70571;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70571__$1,inst_70569);
} else {
if((state_val_70572 === (4))){
var inst_70556 = (state_70571[(2)]);
var inst_70557 = fluree.db.util.log.error.call(null,inst_70556);
var inst_70558 = reject.call(null,inst_70556);
var state_70571__$1 = (function (){var statearr_70578 = state_70571;
(statearr_70578[(7)] = inst_70557);

return statearr_70578;
})();
var statearr_70579_70590 = state_70571__$1;
(statearr_70579_70590[(2)] = inst_70558);

(statearr_70579_70590[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70572 === (5))){
var _ = (function (){var statearr_70580 = state_70571;
(statearr_70580[(4)] = cljs.core.rest.call(null,(state_70571[(4)])));

return statearr_70580;
})();
var state_70571__$1 = state_70571;
var ex70577 = (state_70571__$1[(2)]);
var statearr_70581_70591 = state_70571__$1;
(statearr_70581_70591[(5)] = ex70577);


var statearr_70582_70592 = state_70571__$1;
(statearr_70582_70592[(1)] = (4));

(statearr_70582_70592[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var flureenjs$session_$_state_machine__2879__auto__ = null;
var flureenjs$session_$_state_machine__2879__auto____0 = (function (){
var statearr_70583 = [null,null,null,null,null,null,null,null];
(statearr_70583[(0)] = flureenjs$session_$_state_machine__2879__auto__);

(statearr_70583[(1)] = (1));

return statearr_70583;
});
var flureenjs$session_$_state_machine__2879__auto____1 = (function (state_70571){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_70571);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e70584){var ex__2882__auto__ = e70584;
var statearr_70585_70593 = state_70571;
(statearr_70585_70593[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_70571[(4)]))){
var statearr_70586_70594 = state_70571;
(statearr_70586_70594[(1)] = cljs.core.first.call(null,(state_70571[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70595 = state_70571;
state_70571 = G__70595;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$session_$_state_machine__2879__auto__ = function(state_70571){
switch(arguments.length){
case 0:
return flureenjs$session_$_state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$session_$_state_machine__2879__auto____1.call(this,state_70571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$session_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$session_$_state_machine__2879__auto____0;
flureenjs$session_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$session_$_state_machine__2879__auto____1;
return flureenjs$session_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_70587 = f__2902__auto__.call(null);
(statearr_70587[(6)] = c__2901__auto__);

return statearr_70587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureenjs.session', flureenjs.session);
flureenjs.block_Flakes__GT_vector = (function flureenjs$block_Flakes__GT_vector(blocks){
var G__70599 = blocks;
var vec__70600 = G__70599;
var seq__70601 = cljs.core.seq.call(null,vec__70600);
var first__70602 = cljs.core.first.call(null,seq__70601);
var seq__70601__$1 = cljs.core.next.call(null,seq__70601);
var block = first__70602;
var r = seq__70601__$1;
var acc = cljs.core.PersistentVector.EMPTY;
var G__70599__$1 = G__70599;
var acc__$1 = acc;
while(true){
var vec__70606 = G__70599__$1;
var seq__70607 = cljs.core.seq.call(null,vec__70606);
var first__70608 = cljs.core.first.call(null,seq__70607);
var seq__70607__$1 = cljs.core.next.call(null,seq__70607);
var block__$1 = first__70608;
var r__$1 = seq__70607__$1;
var acc__$2 = acc__$1;
if(cljs.core.truth_(block__$1)){
var flakes = cljs.core.map.call(null,fluree.db.flake.Flake__GT_parts,new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(block__$1));
var G__70609 = r__$1;
var G__70610 = cljs.core.into.call(null,acc__$2,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,block__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes)], null));
G__70599__$1 = G__70609;
acc__$1 = G__70610;
continue;
} else {
return acc__$2;
}
break;
}
});
/**
 * Returns a promise containing search results of flake parts (flake-parts).
 */
flureenjs.search = (function flureenjs$search(db,flake_parts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_70634){
var state_val_70635 = (state_70634[(1)]);
if((state_val_70635 === (1))){
var state_70634__$1 = state_70634;
var statearr_70636_70652 = state_70634__$1;
(statearr_70636_70652[(2)] = null);

(statearr_70636_70652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70635 === (2))){
var _ = (function (){var statearr_70637 = state_70634;
(statearr_70637[(4)] = cljs.core.cons.call(null,(5),(state_70634[(4)])));

return statearr_70637;
})();
var inst_70619 = cljs.core.js__GT_clj.call(null,flake_parts);
var state_70634__$1 = (function (){var statearr_70638 = state_70634;
(statearr_70638[(7)] = inst_70619);

return statearr_70638;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70634__$1,(7),db);
} else {
if((state_val_70635 === (3))){
var inst_70632 = (state_70634[(2)]);
var state_70634__$1 = state_70634;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70634__$1,inst_70632);
} else {
if((state_val_70635 === (4))){
var inst_70611 = (state_70634[(2)]);
var inst_70612 = fluree.db.util.log.error.call(null,inst_70611);
var inst_70613 = reject.call(null,inst_70611);
var state_70634__$1 = (function (){var statearr_70640 = state_70634;
(statearr_70640[(8)] = inst_70612);

return statearr_70640;
})();
var statearr_70641_70653 = state_70634__$1;
(statearr_70641_70653[(2)] = inst_70613);

(statearr_70641_70653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70635 === (5))){
var _ = (function (){var statearr_70642 = state_70634;
(statearr_70642[(4)] = cljs.core.rest.call(null,(state_70634[(4)])));

return statearr_70642;
})();
var state_70634__$1 = state_70634;
var ex70639 = (state_70634__$1[(2)]);
var statearr_70643_70654 = state_70634__$1;
(statearr_70643_70654[(5)] = ex70639);


var statearr_70644_70655 = state_70634__$1;
(statearr_70644_70655[(1)] = (4));

(statearr_70644_70655[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70635 === (6))){
var inst_70625 = (state_70634[(2)]);
var inst_70626 = fluree.db.util.async.throw_err.call(null,inst_70625);
var inst_70627 = cljs.core.map.call(null,fluree.db.flake.Flake__GT_parts,inst_70626);
var inst_70628 = cljs.core.clj__GT_js.call(null,inst_70627);
var inst_70629 = resolve.call(null,inst_70628);
var _ = (function (){var statearr_70645 = state_70634;
(statearr_70645[(4)] = cljs.core.rest.call(null,(state_70634[(4)])));

return statearr_70645;
})();
var state_70634__$1 = state_70634;
var statearr_70646_70656 = state_70634__$1;
(statearr_70646_70656[(2)] = inst_70629);

(statearr_70646_70656[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70635 === (7))){
var inst_70619 = (state_70634[(7)]);
var inst_70621 = (state_70634[(2)]);
var inst_70622 = fluree.db.util.async.throw_err.call(null,inst_70621);
var inst_70623 = fluree.db.dbproto._search.call(null,inst_70622,inst_70619);
var state_70634__$1 = state_70634;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70634__$1,(6),inst_70623);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$search_$_state_machine__2879__auto__ = null;
var flureenjs$search_$_state_machine__2879__auto____0 = (function (){
var statearr_70647 = [null,null,null,null,null,null,null,null,null];
(statearr_70647[(0)] = flureenjs$search_$_state_machine__2879__auto__);

(statearr_70647[(1)] = (1));

return statearr_70647;
});
var flureenjs$search_$_state_machine__2879__auto____1 = (function (state_70634){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_70634);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e70648){var ex__2882__auto__ = e70648;
var statearr_70649_70657 = state_70634;
(statearr_70649_70657[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_70634[(4)]))){
var statearr_70650_70658 = state_70634;
(statearr_70650_70658[(1)] = cljs.core.first.call(null,(state_70634[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70659 = state_70634;
state_70634 = G__70659;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$search_$_state_machine__2879__auto__ = function(state_70634){
switch(arguments.length){
case 0:
return flureenjs$search_$_state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$search_$_state_machine__2879__auto____1.call(this,state_70634);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$search_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$search_$_state_machine__2879__auto____0;
flureenjs$search_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$search_$_state_machine__2879__auto____1;
return flureenjs$search_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_70651 = f__2902__auto__.call(null);
(statearr_70651[(6)] = c__2901__auto__);

return statearr_70651;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureenjs.search', flureenjs.search);
/**
 * Returns a promise containing a new db based on the provided db,
 * including the provided flakes. Flakes can contain one or more 't's,
 * but should be sequential and start after the current 't' of the provided
 * db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.). Remember
 * 't' is negative and thus should be in descending order.
 * 
 * A forward-time-travel db can be further forward-time-traveled.
 * 
 * A forward-time travel DB is held in memory, and is not shared across servers.
 * Ensure you have adequate memory to hold the flakes you generate and add. If
 * access is provided via an external API, do any desired size restrictions or
 * controls within your API endpoint.
 * 
 * Remember schema operations done via forward-time-travel should be done in a
 * 't' prior to the flakes that end up requiring the schema change.
 */
flureenjs.forward_time_travel = (function flureenjs$forward_time_travel(db,flakes){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_70680){
var state_val_70681 = (state_70680[(1)]);
if((state_val_70681 === (1))){
var state_70680__$1 = state_70680;
var statearr_70682_70698 = state_70680__$1;
(statearr_70682_70698[(2)] = null);

(statearr_70682_70698[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70681 === (2))){
var _ = (function (){var statearr_70683 = state_70680;
(statearr_70683[(4)] = cljs.core.cons.call(null,(5),(state_70680[(4)])));

return statearr_70683;
})();
var inst_70668 = cljs.core.js__GT_clj.call(null,flakes);
var inst_70669 = cljs.core.map.call(null,fluree.db.flake.parts__GT_Flake,inst_70668);
var state_70680__$1 = (function (){var statearr_70684 = state_70680;
(statearr_70684[(7)] = inst_70669);

return statearr_70684;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70680__$1,(6),db);
} else {
if((state_val_70681 === (3))){
var inst_70678 = (state_70680[(2)]);
var state_70680__$1 = state_70680;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70680__$1,inst_70678);
} else {
if((state_val_70681 === (4))){
var inst_70660 = (state_70680[(2)]);
var inst_70661 = fluree.db.util.log.error.call(null,inst_70660);
var inst_70662 = reject.call(null,inst_70660);
var state_70680__$1 = (function (){var statearr_70686 = state_70680;
(statearr_70686[(8)] = inst_70661);

return statearr_70686;
})();
var statearr_70687_70699 = state_70680__$1;
(statearr_70687_70699[(2)] = inst_70662);

(statearr_70687_70699[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70681 === (5))){
var _ = (function (){var statearr_70688 = state_70680;
(statearr_70688[(4)] = cljs.core.rest.call(null,(state_70680[(4)])));

return statearr_70688;
})();
var state_70680__$1 = state_70680;
var ex70685 = (state_70680__$1[(2)]);
var statearr_70689_70700 = state_70680__$1;
(statearr_70689_70700[(5)] = ex70685);


var statearr_70690_70701 = state_70680__$1;
(statearr_70690_70701[(1)] = (4));

(statearr_70690_70701[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70681 === (6))){
var inst_70669 = (state_70680[(7)]);
var inst_70671 = (state_70680[(2)]);
var inst_70672 = fluree.db.util.async.throw_err.call(null,inst_70671);
var inst_70673 = fluree.db.graphdb.forward_time_travel.call(null,inst_70672,null,inst_70669);
var inst_70674 = cljs.core.clj__GT_js.call(null,inst_70673);
var inst_70675 = resolve.call(null,inst_70674);
var _ = (function (){var statearr_70691 = state_70680;
(statearr_70691[(4)] = cljs.core.rest.call(null,(state_70680[(4)])));

return statearr_70691;
})();
var state_70680__$1 = state_70680;
var statearr_70692_70702 = state_70680__$1;
(statearr_70692_70702[(2)] = inst_70675);

(statearr_70692_70702[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$forward_time_travel_$_state_machine__2879__auto__ = null;
var flureenjs$forward_time_travel_$_state_machine__2879__auto____0 = (function (){
var statearr_70693 = [null,null,null,null,null,null,null,null,null];
(statearr_70693[(0)] = flureenjs$forward_time_travel_$_state_machine__2879__auto__);

(statearr_70693[(1)] = (1));

return statearr_70693;
});
var flureenjs$forward_time_travel_$_state_machine__2879__auto____1 = (function (state_70680){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_70680);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e70694){var ex__2882__auto__ = e70694;
var statearr_70695_70703 = state_70680;
(statearr_70695_70703[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_70680[(4)]))){
var statearr_70696_70704 = state_70680;
(statearr_70696_70704[(1)] = cljs.core.first.call(null,(state_70680[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70705 = state_70680;
state_70680 = G__70705;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$forward_time_travel_$_state_machine__2879__auto__ = function(state_70680){
switch(arguments.length){
case 0:
return flureenjs$forward_time_travel_$_state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$forward_time_travel_$_state_machine__2879__auto____1.call(this,state_70680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$forward_time_travel_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$forward_time_travel_$_state_machine__2879__auto____0;
flureenjs$forward_time_travel_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$forward_time_travel_$_state_machine__2879__auto____1;
return flureenjs$forward_time_travel_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_70697 = f__2902__auto__.call(null);
(statearr_70697[(6)] = c__2901__auto__);

return statearr_70697;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureenjs.forward_time_travel', flureenjs.forward_time_travel);
/**
 * Returns true if provided db is a forward-time-travel db.
 */
flureenjs.is_forward_time_travel_db = (function flureenjs$is_forward_time_travel_db(db){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_70729){
var state_val_70730 = (state_70729[(1)]);
if((state_val_70730 === (7))){
var state_70729__$1 = state_70729;
var statearr_70731_70750 = state_70729__$1;
(statearr_70731_70750[(2)] = db);

(statearr_70731_70750[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70730 === (1))){
var state_70729__$1 = state_70729;
var statearr_70732_70751 = state_70729__$1;
(statearr_70732_70751[(2)] = null);

(statearr_70732_70751[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70730 === (4))){
var inst_70706 = (state_70729[(2)]);
var inst_70707 = fluree.db.util.log.error.call(null,inst_70706);
var inst_70708 = reject.call(null,inst_70706);
var state_70729__$1 = (function (){var statearr_70733 = state_70729;
(statearr_70733[(7)] = inst_70707);

return statearr_70733;
})();
var statearr_70734_70752 = state_70729__$1;
(statearr_70734_70752[(2)] = inst_70708);

(statearr_70734_70752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70730 === (6))){
var state_70729__$1 = state_70729;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70729__$1,(9),db);
} else {
if((state_val_70730 === (3))){
var inst_70727 = (state_70729[(2)]);
var state_70729__$1 = state_70729;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70729__$1,inst_70727);
} else {
if((state_val_70730 === (2))){
var _ = (function (){var statearr_70736 = state_70729;
(statearr_70736[(4)] = cljs.core.cons.call(null,(5),(state_70729[(4)])));

return statearr_70736;
})();
var inst_70714 = fluree.db.util.async.channel_QMARK_.call(null,db);
var state_70729__$1 = state_70729;
if(inst_70714){
var statearr_70737_70753 = state_70729__$1;
(statearr_70737_70753[(1)] = (6));

} else {
var statearr_70738_70754 = state_70729__$1;
(statearr_70738_70754[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70730 === (9))){
var inst_70717 = (state_70729[(2)]);
var inst_70718 = fluree.db.util.async.throw_err.call(null,inst_70717);
var state_70729__$1 = state_70729;
var statearr_70739_70755 = state_70729__$1;
(statearr_70739_70755[(2)] = inst_70718);

(statearr_70739_70755[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70730 === (5))){
var _ = (function (){var statearr_70740 = state_70729;
(statearr_70740[(4)] = cljs.core.rest.call(null,(state_70729[(4)])));

return statearr_70740;
})();
var state_70729__$1 = state_70729;
var ex70735 = (state_70729__$1[(2)]);
var statearr_70741_70756 = state_70729__$1;
(statearr_70741_70756[(5)] = ex70735);


var statearr_70742_70757 = state_70729__$1;
(statearr_70742_70757[(1)] = (4));

(statearr_70742_70757[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70730 === (8))){
var inst_70721 = (state_70729[(2)]);
var inst_70722 = fluree.db.graphdb.forward_time_travel_db_QMARK_.call(null,inst_70721);
var inst_70723 = cljs.core.clj__GT_js.call(null,inst_70722);
var inst_70724 = resolve.call(null,inst_70723);
var _ = (function (){var statearr_70743 = state_70729;
(statearr_70743[(4)] = cljs.core.rest.call(null,(state_70729[(4)])));

return statearr_70743;
})();
var state_70729__$1 = state_70729;
var statearr_70744_70758 = state_70729__$1;
(statearr_70744_70758[(2)] = inst_70724);

(statearr_70744_70758[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$is_forward_time_travel_db_$_state_machine__2879__auto__ = null;
var flureenjs$is_forward_time_travel_db_$_state_machine__2879__auto____0 = (function (){
var statearr_70745 = [null,null,null,null,null,null,null,null];
(statearr_70745[(0)] = flureenjs$is_forward_time_travel_db_$_state_machine__2879__auto__);

(statearr_70745[(1)] = (1));

return statearr_70745;
});
var flureenjs$is_forward_time_travel_db_$_state_machine__2879__auto____1 = (function (state_70729){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_70729);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e70746){var ex__2882__auto__ = e70746;
var statearr_70747_70759 = state_70729;
(statearr_70747_70759[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_70729[(4)]))){
var statearr_70748_70760 = state_70729;
(statearr_70748_70760[(1)] = cljs.core.first.call(null,(state_70729[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70761 = state_70729;
state_70729 = G__70761;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$is_forward_time_travel_db_$_state_machine__2879__auto__ = function(state_70729){
switch(arguments.length){
case 0:
return flureenjs$is_forward_time_travel_db_$_state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$is_forward_time_travel_db_$_state_machine__2879__auto____1.call(this,state_70729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$is_forward_time_travel_db_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$is_forward_time_travel_db_$_state_machine__2879__auto____0;
flureenjs$is_forward_time_travel_db_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$is_forward_time_travel_db_$_state_machine__2879__auto____1;
return flureenjs$is_forward_time_travel_db_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_70749 = f__2902__auto__.call(null);
(statearr_70749[(6)] = c__2901__auto__);

return statearr_70749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureenjs.is_forward_time_travel_db', flureenjs.is_forward_time_travel_db);
/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a promise that will eventually contain a response or an exception
 *   if the timeout period has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
flureenjs.monitor_tx = (function flureenjs$monitor_tx(conn,ledger,txid,timeout_ms){
if(cljs.core.int_QMARK_.call(null,timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_70781){
var state_val_70782 = (state_70781[(1)]);
if((state_val_70782 === (1))){
var state_70781__$1 = state_70781;
var statearr_70783_70799 = state_70781__$1;
(statearr_70783_70799[(2)] = null);

(statearr_70783_70799[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70782 === (2))){
var _ = (function (){var statearr_70784 = state_70781;
(statearr_70784[(4)] = cljs.core.cons.call(null,(5),(state_70781[(4)])));

return statearr_70784;
})();
var inst_70771 = fluree.db.connection_js.check_connection.call(null,conn);
var inst_70772 = fluree.db.api_js.monitor_tx.call(null,conn,ledger,txid,timeout_ms);
var state_70781__$1 = (function (){var statearr_70785 = state_70781;
(statearr_70785[(7)] = inst_70771);

return statearr_70785;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_70781__$1,(6),inst_70772);
} else {
if((state_val_70782 === (3))){
var inst_70779 = (state_70781[(2)]);
var state_70781__$1 = state_70781;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70781__$1,inst_70779);
} else {
if((state_val_70782 === (4))){
var inst_70762 = (state_70781[(2)]);
var inst_70763 = fluree.db.util.log.error.call(null,inst_70762);
var inst_70764 = cljs.core.clj__GT_js.call(null,inst_70762);
var inst_70765 = reject.call(null,inst_70764);
var state_70781__$1 = (function (){var statearr_70787 = state_70781;
(statearr_70787[(8)] = inst_70763);

return statearr_70787;
})();
var statearr_70788_70800 = state_70781__$1;
(statearr_70788_70800[(2)] = inst_70765);

(statearr_70788_70800[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70782 === (5))){
var _ = (function (){var statearr_70789 = state_70781;
(statearr_70789[(4)] = cljs.core.rest.call(null,(state_70781[(4)])));

return statearr_70789;
})();
var state_70781__$1 = state_70781;
var ex70786 = (state_70781__$1[(2)]);
var statearr_70790_70801 = state_70781__$1;
(statearr_70790_70801[(5)] = ex70786);


var statearr_70791_70802 = state_70781__$1;
(statearr_70791_70802[(1)] = (4));

(statearr_70791_70802[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70782 === (6))){
var inst_70774 = (state_70781[(2)]);
var inst_70775 = cljs.core.clj__GT_js.call(null,inst_70774);
var inst_70776 = resolve.call(null,inst_70775);
var _ = (function (){var statearr_70792 = state_70781;
(statearr_70792[(4)] = cljs.core.rest.call(null,(state_70781[(4)])));

return statearr_70792;
})();
var state_70781__$1 = state_70781;
var statearr_70793_70803 = state_70781__$1;
(statearr_70793_70803[(2)] = inst_70776);

(statearr_70793_70803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$monitor_tx_$_state_machine__2879__auto__ = null;
var flureenjs$monitor_tx_$_state_machine__2879__auto____0 = (function (){
var statearr_70794 = [null,null,null,null,null,null,null,null,null];
(statearr_70794[(0)] = flureenjs$monitor_tx_$_state_machine__2879__auto__);

(statearr_70794[(1)] = (1));

return statearr_70794;
});
var flureenjs$monitor_tx_$_state_machine__2879__auto____1 = (function (state_70781){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_70781);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e70795){var ex__2882__auto__ = e70795;
var statearr_70796_70804 = state_70781;
(statearr_70796_70804[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_70781[(4)]))){
var statearr_70797_70805 = state_70781;
(statearr_70797_70805[(1)] = cljs.core.first.call(null,(state_70781[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__70806 = state_70781;
state_70781 = G__70806;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$monitor_tx_$_state_machine__2879__auto__ = function(state_70781){
switch(arguments.length){
case 0:
return flureenjs$monitor_tx_$_state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$monitor_tx_$_state_machine__2879__auto____1.call(this,state_70781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$monitor_tx_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$monitor_tx_$_state_machine__2879__auto____0;
flureenjs$monitor_tx_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$monitor_tx_$_state_machine__2879__auto____1;
return flureenjs$monitor_tx_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_70798 = f__2902__auto__.call(null);
(statearr_70798[(6)] = c__2901__auto__);

return statearr_70798;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureenjs.monitor_tx', flureenjs.monitor_tx);
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
flureenjs.tx__GT_command = (function flureenjs$tx__GT_command(var_args){
var G__70808 = arguments.length;
switch (G__70808) {
case 3:
return flureenjs.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(flureenjs.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return flureenjs.tx__GT_command.call(null,ledger,txn,private_key,null);
}));

(flureenjs.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.call(null,"Private key not provided",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_70937){
var state_val_70938 = (state_70937[(1)]);
if((state_val_70938 === (7))){
var state_70937__$1 = state_70937;
var statearr_70939_71019 = state_70937__$1;
(statearr_70939_71019[(2)] = ledger);

(statearr_70939_71019[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (20))){
var inst_70852 = (state_70937[(7)]);
var inst_70867 = (state_70937[(2)]);
var inst_70868 = fluree.crypto.account_id_from_private.call(null,private_key);
var state_70937__$1 = (function (){var statearr_70940 = state_70937;
(statearr_70940[(8)] = inst_70867);

(statearr_70940[(9)] = inst_70868);

return statearr_70940;
})();
if(cljs.core.truth_(inst_70852)){
var statearr_70941_71020 = state_70937__$1;
(statearr_70941_71020[(1)] = (24));

} else {
var statearr_70942_71021 = state_70937__$1;
(statearr_70942_71021[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (27))){
var inst_70868 = (state_70937[(9)]);
var inst_70852 = (state_70937[(7)]);
var inst_70875 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70876 = [inst_70852,inst_70868];
var inst_70877 = (new cljs.core.PersistentVector(null,2,(5),inst_70875,inst_70876,null));
var state_70937__$1 = state_70937;
var statearr_70943_71022 = state_70937__$1;
(statearr_70943_71022[(2)] = inst_70877);

(statearr_70943_71022[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (1))){
var state_70937__$1 = state_70937;
var statearr_70944_71023 = state_70937__$1;
(statearr_70944_71023[(2)] = null);

(statearr_70944_71023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (24))){
var inst_70868 = (state_70937[(9)]);
var inst_70852 = (state_70937[(7)]);
var inst_70870 = cljs.core.not_EQ_.call(null,inst_70852,inst_70868);
var state_70937__$1 = state_70937;
var statearr_70945_71024 = state_70937__$1;
(statearr_70945_71024[(2)] = inst_70870);

(statearr_70945_71024[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (39))){
var inst_70853 = (state_70937[(10)]);
var state_70937__$1 = state_70937;
var statearr_70946_71025 = state_70937__$1;
(statearr_70946_71025[(2)] = inst_70853);

(statearr_70946_71025[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (4))){
var inst_70809 = (state_70937[(2)]);
var inst_70810 = fluree.db.util.log.error.call(null,inst_70809);
var inst_70811 = cljs.core.clj__GT_js.call(null,inst_70809);
var inst_70812 = reject.call(null,inst_70811);
var state_70937__$1 = (function (){var statearr_70947 = state_70937;
(statearr_70947[(11)] = inst_70810);

return statearr_70947;
})();
var statearr_70948_71026 = state_70937__$1;
(statearr_70948_71026[(2)] = inst_70812);

(statearr_70948_71026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (15))){
var inst_70830 = (state_70937[(12)]);
var inst_70848 = cljs.core.apply.call(null,cljs.core.hash_map,inst_70830);
var state_70937__$1 = state_70937;
var statearr_70949_71027 = state_70937__$1;
(statearr_70949_71027[(2)] = inst_70848);

(statearr_70949_71027[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (21))){
var state_70937__$1 = state_70937;
var statearr_70950_71028 = state_70937__$1;
(statearr_70950_71028[(2)] = null);

(statearr_70950_71028[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (31))){
var state_70937__$1 = state_70937;
var statearr_70951_71029 = state_70937__$1;
(statearr_70951_71029[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (32))){
var inst_70892 = (state_70937[(2)]);
var state_70937__$1 = state_70937;
var statearr_70953_71030 = state_70937__$1;
(statearr_70953_71030[(2)] = inst_70892);

(statearr_70953_71030[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (40))){
var inst_70897 = (state_70937[(13)]);
var inst_70904 = (inst_70897 + (30000));
var state_70937__$1 = state_70937;
var statearr_70954_71031 = state_70937__$1;
(statearr_70954_71031[(2)] = inst_70904);

(statearr_70954_71031[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (33))){
var inst_70868 = (state_70937[(9)]);
var inst_70885 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70886 = [inst_70868,null];
var inst_70887 = (new cljs.core.PersistentVector(null,2,(5),inst_70885,inst_70886,null));
var state_70937__$1 = state_70937;
var statearr_70955_71032 = state_70937__$1;
(statearr_70955_71032[(2)] = inst_70887);

(statearr_70955_71032[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (13))){
var state_70937__$1 = state_70937;
var statearr_70956_71033 = state_70937__$1;
(statearr_70956_71033[(2)] = false);

(statearr_70956_71033[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (22))){
var inst_70860 = ["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('');
var inst_70861 = (new Error(inst_70860));
var inst_70862 = (function(){throw inst_70861})();
var state_70937__$1 = state_70937;
var statearr_70957_71034 = state_70937__$1;
(statearr_70957_71034[(2)] = inst_70862);

(statearr_70957_71034[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (36))){
var inst_70854 = (state_70937[(14)]);
var state_70937__$1 = state_70937;
var statearr_70958_71035 = state_70937__$1;
(statearr_70958_71035[(2)] = inst_70854);

(statearr_70958_71035[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (41))){
var inst_70906 = (state_70937[(2)]);
var state_70937__$1 = (function (){var statearr_70959 = state_70937;
(statearr_70959[(15)] = inst_70906);

return statearr_70959;
})();
var statearr_70960_71036 = state_70937__$1;
(statearr_70960_71036[(2)] = null);

(statearr_70960_71036[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (43))){
var inst_70926 = (state_70937[(2)]);
var inst_70927 = fluree.crypto.sign_message.call(null,inst_70926,private_key);
var inst_70928 = fluree.crypto.sha3_256.call(null,inst_70926);
var inst_70929 = [new cljs.core.Keyword(null,"cmd","cmd",-302931143),new cljs.core.Keyword(null,"sig","sig",-1920417200),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"db","db",993250759)];
var inst_70930 = [inst_70926,inst_70927,inst_70928,ledger];
var inst_70931 = cljs.core.PersistentHashMap.fromArrays(inst_70929,inst_70930);
var inst_70932 = resolve.call(null,inst_70931);
var _ = (function (){var statearr_70961 = state_70937;
(statearr_70961[(4)] = cljs.core.rest.call(null,(state_70937[(4)])));

return statearr_70961;
})();
var state_70937__$1 = state_70937;
var statearr_70962_71037 = state_70937__$1;
(statearr_70962_71037[(2)] = inst_70932);

(statearr_70962_71037[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (29))){
var inst_70854 = (state_70937[(14)]);
var inst_70894 = (state_70937[(2)]);
var inst_70895 = cljs.core.nth.call(null,inst_70894,(0),null);
var inst_70896 = cljs.core.nth.call(null,inst_70894,(1),null);
var inst_70897 = fluree.db.util.core.current_time_millis.call(null);
var state_70937__$1 = (function (){var statearr_70963 = state_70937;
(statearr_70963[(13)] = inst_70897);

(statearr_70963[(16)] = inst_70896);

(statearr_70963[(17)] = inst_70895);

return statearr_70963;
})();
if(cljs.core.truth_(inst_70854)){
var statearr_70964_71038 = state_70937__$1;
(statearr_70964_71038[(1)] = (36));

} else {
var statearr_70965_71039 = state_70937__$1;
(statearr_70965_71039[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (44))){
var inst_70907 = (state_70937[(2)]);
var inst_70908 = fluree.db.util.log.error.call(null,inst_70907);
var inst_70909 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_70910 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_70911 = cljs.core.PersistentHashMap.fromArrays(inst_70909,inst_70910);
var inst_70912 = cljs.core.ex_info.call(null,"Transaction contains data that cannot be serialized into JSON.",inst_70911);
var inst_70913 = (function(){throw inst_70912})();
var state_70937__$1 = (function (){var statearr_70966 = state_70937;
(statearr_70966[(18)] = inst_70908);

return statearr_70966;
})();
var statearr_70967_71040 = state_70937__$1;
(statearr_70967_71040[(2)] = inst_70913);

(statearr_70967_71040[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (6))){
var inst_70824 = cljs.core.first.call(null,ledger);
var inst_70825 = cljs.core.second.call(null,ledger);
var inst_70826 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70824),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_70825)].join('');
var state_70937__$1 = state_70937;
var statearr_70968_71041 = state_70937__$1;
(statearr_70968_71041[(2)] = inst_70826);

(statearr_70968_71041[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (28))){
var inst_70852 = (state_70937[(7)]);
var state_70937__$1 = state_70937;
if(cljs.core.truth_(inst_70852)){
var statearr_70969_71042 = state_70937__$1;
(statearr_70969_71042[(1)] = (30));

} else {
var statearr_70970_71043 = state_70937__$1;
(statearr_70970_71043[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (25))){
var inst_70852 = (state_70937[(7)]);
var state_70937__$1 = state_70937;
var statearr_70971_71044 = state_70937__$1;
(statearr_70971_71044[(2)] = inst_70852);

(statearr_70971_71044[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (34))){
var state_70937__$1 = state_70937;
var statearr_70972_71045 = state_70937__$1;
(statearr_70972_71045[(2)] = null);

(statearr_70972_71045[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (17))){
var inst_70855 = (state_70937[(19)]);
var inst_70851 = (state_70937[(2)]);
var inst_70852 = cljs.core.get.call(null,inst_70851,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_70853 = cljs.core.get.call(null,inst_70851,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_70854 = cljs.core.get.call(null,inst_70851,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var inst_70855__$1 = cljs.core.get.call(null,inst_70851,new cljs.core.Keyword(null,"deps","deps",1883360319));
var state_70937__$1 = (function (){var statearr_70973 = state_70937;
(statearr_70973[(19)] = inst_70855__$1);

(statearr_70973[(14)] = inst_70854);

(statearr_70973[(7)] = inst_70852);

(statearr_70973[(10)] = inst_70853);

return statearr_70973;
})();
if(cljs.core.truth_(inst_70855__$1)){
var statearr_70974_71046 = state_70937__$1;
(statearr_70974_71046[(1)] = (18));

} else {
var statearr_70975_71047 = state_70937__$1;
(statearr_70975_71047[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (3))){
var inst_70935 = (state_70937[(2)]);
var state_70937__$1 = state_70937;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_70937__$1,inst_70935);
} else {
if((state_val_70938 === (12))){
var state_70937__$1 = state_70937;
var statearr_70976_71048 = state_70937__$1;
(statearr_70976_71048[(2)] = true);

(statearr_70976_71048[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (2))){
var _ = (function (){var statearr_70977 = state_70937;
(statearr_70977[(4)] = cljs.core.cons.call(null,(5),(state_70937[(4)])));

return statearr_70977;
})();
var inst_70822 = cljs.core.sequential_QMARK_.call(null,ledger);
var state_70937__$1 = state_70937;
if(inst_70822){
var statearr_70978_71049 = state_70937__$1;
(statearr_70978_71049[(1)] = (6));

} else {
var statearr_70979_71050 = state_70937__$1;
(statearr_70979_71050[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (23))){
var inst_70864 = (state_70937[(2)]);
var state_70937__$1 = state_70937;
var statearr_70980_71051 = state_70937__$1;
(statearr_70980_71051[(2)] = inst_70864);

(statearr_70980_71051[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (35))){
var inst_70890 = (state_70937[(2)]);
var state_70937__$1 = state_70937;
var statearr_70981_71052 = state_70937__$1;
(statearr_70981_71052[(2)] = inst_70890);

(statearr_70981_71052[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (19))){
var state_70937__$1 = state_70937;
var statearr_70982_71053 = state_70937__$1;
(statearr_70982_71053[(2)] = null);

(statearr_70982_71053[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (11))){
var inst_70846 = (state_70937[(2)]);
var state_70937__$1 = state_70937;
if(cljs.core.truth_(inst_70846)){
var statearr_70984_71054 = state_70937__$1;
(statearr_70984_71054[(1)] = (15));

} else {
var statearr_70985_71055 = state_70937__$1;
(statearr_70985_71055[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (9))){
var inst_70830 = (state_70937[(12)]);
var inst_70835 = inst_70830.cljs$lang$protocol_mask$partition0$;
var inst_70836 = (inst_70835 & (64));
var inst_70837 = inst_70830.cljs$core$ISeq$;
var inst_70838 = (cljs.core.PROTOCOL_SENTINEL === inst_70837);
var inst_70839 = ((inst_70836) || (inst_70838));
var state_70937__$1 = state_70937;
if(cljs.core.truth_(inst_70839)){
var statearr_70986_71056 = state_70937__$1;
(statearr_70986_71056[(1)] = (12));

} else {
var statearr_70987_71057 = state_70937__$1;
(statearr_70987_71057[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (5))){
var _ = (function (){var statearr_70989 = state_70937;
(statearr_70989[(4)] = cljs.core.rest.call(null,(state_70937[(4)])));

return statearr_70989;
})();
var state_70937__$1 = state_70937;
var ex70983 = (state_70937__$1[(2)]);
var statearr_70990_71058 = state_70937__$1;
(statearr_70990_71058[(5)] = ex70983);


var statearr_70991_71059 = state_70937__$1;
(statearr_70991_71059[(1)] = (4));

(statearr_70991_71059[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (14))){
var inst_70843 = (state_70937[(2)]);
var state_70937__$1 = state_70937;
var statearr_70992_71060 = state_70937__$1;
(statearr_70992_71060[(2)] = inst_70843);

(statearr_70992_71060[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (45))){
var _ = (function (){var statearr_70993 = state_70937;
(statearr_70993[(4)] = cljs.core.rest.call(null,(state_70937[(4)])));

return statearr_70993;
})();
var state_70937__$1 = state_70937;
var ex70988 = (state_70937__$1[(2)]);
var statearr_70994_71061 = state_70937__$1;
(statearr_70994_71061[(5)] = ex70988);


var statearr_70995_71062 = state_70937__$1;
(statearr_70995_71062[(1)] = (44));

(statearr_70995_71062[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (26))){
var inst_70873 = (state_70937[(2)]);
var state_70937__$1 = state_70937;
if(cljs.core.truth_(inst_70873)){
var statearr_70996_71063 = state_70937__$1;
(statearr_70996_71063[(1)] = (27));

} else {
var statearr_70997_71064 = state_70937__$1;
(statearr_70997_71064[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (16))){
var inst_70830 = (state_70937[(12)]);
var state_70937__$1 = state_70937;
var statearr_70998_71065 = state_70937__$1;
(statearr_70998_71065[(2)] = inst_70830);

(statearr_70998_71065[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (38))){
var inst_70853 = (state_70937[(10)]);
var inst_70901 = (state_70937[(2)]);
var state_70937__$1 = (function (){var statearr_70999 = state_70937;
(statearr_70999[(20)] = inst_70901);

return statearr_70999;
})();
if(cljs.core.truth_(inst_70853)){
var statearr_71000_71066 = state_70937__$1;
(statearr_71000_71066[(1)] = (39));

} else {
var statearr_71001_71067 = state_70937__$1;
(statearr_71001_71067[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (30))){
var inst_70852 = (state_70937[(7)]);
var inst_70880 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70881 = [inst_70852,null];
var inst_70882 = (new cljs.core.PersistentVector(null,2,(5),inst_70880,inst_70881,null));
var state_70937__$1 = state_70937;
var statearr_71002_71068 = state_70937__$1;
(statearr_71002_71068[(2)] = inst_70882);

(statearr_71002_71068[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (10))){
var state_70937__$1 = state_70937;
var statearr_71003_71069 = state_70937__$1;
(statearr_71003_71069[(2)] = false);

(statearr_71003_71069[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (18))){
var inst_70855 = (state_70937[(19)]);
var inst_70857 = cljs.core.sequential_QMARK_.call(null,inst_70855);
var state_70937__$1 = state_70937;
if(inst_70857){
var statearr_71004_71070 = state_70937__$1;
(statearr_71004_71070[(1)] = (21));

} else {
var statearr_71005_71071 = state_70937__$1;
(statearr_71005_71071[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (42))){
var inst_70829 = (state_70937[(21)]);
var inst_70901 = (state_70937[(20)]);
var inst_70896 = (state_70937[(16)]);
var inst_70895 = (state_70937[(17)]);
var inst_70855 = (state_70937[(19)]);
var inst_70906 = (state_70937[(15)]);
var _ = (function (){var statearr_71006 = state_70937;
(statearr_71006[(4)] = cljs.core.cons.call(null,(45),(state_70937[(4)])));

return statearr_71006;
})();
var inst_70919 = [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"authority","authority",-551669367),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"deps","deps",1883360319)];
var inst_70920 = [new cljs.core.Keyword(null,"tx","tx",466630418),inst_70829,txn,inst_70901,inst_70895,inst_70896,inst_70906,inst_70855];
var inst_70921 = cljs.core.PersistentHashMap.fromArrays(inst_70919,inst_70920);
var inst_70922 = fluree.db.util.core.without_nils.call(null,inst_70921);
var inst_70923 = fluree.db.util.json.stringify.call(null,inst_70922);
var ___$1 = (function (){var statearr_71007 = state_70937;
(statearr_71007[(4)] = cljs.core.rest.call(null,(state_70937[(4)])));

return statearr_71007;
})();
var state_70937__$1 = state_70937;
var statearr_71008_71072 = state_70937__$1;
(statearr_71008_71072[(2)] = inst_70923);

(statearr_71008_71072[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (37))){
var inst_70897 = (state_70937[(13)]);
var state_70937__$1 = state_70937;
var statearr_71009_71073 = state_70937__$1;
(statearr_71009_71073[(2)] = inst_70897);

(statearr_71009_71073[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_70938 === (8))){
var inst_70830 = (state_70937[(12)]);
var inst_70829 = (state_70937[(2)]);
var inst_70830__$1 = opts;
var inst_70832 = (inst_70830__$1 == null);
var inst_70833 = cljs.core.not.call(null,inst_70832);
var state_70937__$1 = (function (){var statearr_71010 = state_70937;
(statearr_71010[(12)] = inst_70830__$1);

(statearr_71010[(21)] = inst_70829);

return statearr_71010;
})();
if(inst_70833){
var statearr_71011_71074 = state_70937__$1;
(statearr_71011_71074[(1)] = (9));

} else {
var statearr_71012_71075 = state_70937__$1;
(statearr_71012_71075[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2879__auto__ = null;
var flureenjs$state_machine__2879__auto____0 = (function (){
var statearr_71013 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71013[(0)] = flureenjs$state_machine__2879__auto__);

(statearr_71013[(1)] = (1));

return statearr_71013;
});
var flureenjs$state_machine__2879__auto____1 = (function (state_70937){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_70937);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e71014){var ex__2882__auto__ = e71014;
var statearr_71015_71076 = state_70937;
(statearr_71015_71076[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_70937[(4)]))){
var statearr_71016_71077 = state_70937;
(statearr_71016_71077[(1)] = cljs.core.first.call(null,(state_70937[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71078 = state_70937;
state_70937 = G__71078;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$state_machine__2879__auto__ = function(state_70937){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$state_machine__2879__auto____1.call(this,state_70937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2879__auto____0;
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2879__auto____1;
return flureenjs$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_71017 = f__2902__auto__.call(null);
(statearr_71017[(6)] = c__2901__auto__);

return statearr_71017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureenjs.tx__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Submits a transaction for a ledger and a transaction. Returns a promise
 * that will eventually have the result of the tx, the txid (if :txid-only option used), or
 * an exception due to an invalid transaction or if the timeout occurs prior to a response.
 * 
 * Will locally sign a final transaction command if a private key is provided via :private-key
 * in the options, otherwise will submit the transaction to the connected ledger and request signature,
 * provided the ledger group has a default private key available for signing.
 * 
 * Options (opts) is a map with the following possible keys:
 * - private-key - The private key to use for signing. If not present, a default
 *                 private key will attempt to be used from the connection, if available.
 * - auth        - The auth id for the auth record being used. The private key must
 *                 correspond to this auth record, or an authority of this auth record.
 * - expire      - When this transaction should expire if not yet attempted.
 *                 Defaults to 5 minutes.
 * - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                 By default epoch milliseconds is used.
 * - deps        - List of one or more txids that must be successfully processed before
 *                 this tx is processed. If any fail, this tx will fail. (not yet implemented)
 * - txid-only   - Boolean (default of false). If true, will not wait for a response to the tx,
 *                 but instead return with the txid once it is successfully persisted by the
 *                 transactors. The txid can be used to look up/monitor the response at a later time.
 * - timeout     - will respond with an exception if timeout reached before response available.
 */
flureenjs.transact = (function flureenjs$transact(var_args){
var G__71080 = arguments.length;
switch (G__71080) {
case 3:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.transact.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.transact', flureenjs.transact);

(flureenjs.transact.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return flureenjs.transact.call(null,conn,ledger,txn,null);
}));

(flureenjs.transact.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_71106){
var state_val_71107 = (state_71106[(1)]);
if((state_val_71107 === (7))){
var inst_71092 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_71106__$1 = state_71106;
var statearr_71108_71129 = state_71106__$1;
(statearr_71108_71129[(2)] = inst_71092);

(statearr_71108_71129[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71107 === (1))){
var state_71106__$1 = state_71106;
var statearr_71109_71130 = state_71106__$1;
(statearr_71109_71130[(2)] = null);

(statearr_71109_71130[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71107 === (4))){
var inst_71081 = (state_71106[(2)]);
var inst_71082 = fluree.db.util.log.error.call(null,inst_71081);
var inst_71083 = reject.call(null,inst_71081);
var state_71106__$1 = (function (){var statearr_71110 = state_71106;
(statearr_71110[(7)] = inst_71082);

return statearr_71110;
})();
var statearr_71111_71131 = state_71106__$1;
(statearr_71111_71131[(2)] = inst_71083);

(statearr_71111_71131[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71107 === (6))){
var state_71106__$1 = state_71106;
var statearr_71112_71132 = state_71106__$1;
(statearr_71112_71132[(2)] = null);

(statearr_71112_71132[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71107 === (3))){
var inst_71104 = (state_71106[(2)]);
var state_71106__$1 = state_71106;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71106__$1,inst_71104);
} else {
if((state_val_71107 === (2))){
var _ = (function (){var statearr_71114 = state_71106;
(statearr_71114[(4)] = cljs.core.cons.call(null,(5),(state_71106[(4)])));

return statearr_71114;
})();
var inst_71089 = (opts == null);
var state_71106__$1 = state_71106;
if(cljs.core.truth_(inst_71089)){
var statearr_71115_71133 = state_71106__$1;
(statearr_71115_71133[(1)] = (6));

} else {
var statearr_71116_71134 = state_71106__$1;
(statearr_71116_71134[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71107 === (9))){
var inst_71099 = (state_71106[(2)]);
var inst_71100 = cljs.core.clj__GT_js.call(null,inst_71099);
var inst_71101 = resolve.call(null,inst_71100);
var _ = (function (){var statearr_71117 = state_71106;
(statearr_71117[(4)] = cljs.core.rest.call(null,(state_71106[(4)])));

return statearr_71117;
})();
var state_71106__$1 = state_71106;
var statearr_71118_71135 = state_71106__$1;
(statearr_71118_71135[(2)] = inst_71101);

(statearr_71118_71135[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71107 === (5))){
var _ = (function (){var statearr_71119 = state_71106;
(statearr_71119[(4)] = cljs.core.rest.call(null,(state_71106[(4)])));

return statearr_71119;
})();
var state_71106__$1 = state_71106;
var ex71113 = (state_71106__$1[(2)]);
var statearr_71120_71136 = state_71106__$1;
(statearr_71120_71136[(5)] = ex71113);


var statearr_71121_71137 = state_71106__$1;
(statearr_71121_71137[(1)] = (4));

(statearr_71121_71137[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71107 === (8))){
var inst_71094 = (state_71106[(2)]);
var inst_71095 = fluree.db.connection_js.check_connection.call(null,conn,inst_71094);
var inst_71096 = cljs.core.js__GT_clj.call(null,txn,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_71097 = fluree.db.api_js.transact_async.call(null,conn,ledger,inst_71096,inst_71094);
var state_71106__$1 = (function (){var statearr_71122 = state_71106;
(statearr_71122[(8)] = inst_71095);

return statearr_71122;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71106__$1,(9),inst_71097);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2879__auto__ = null;
var flureenjs$state_machine__2879__auto____0 = (function (){
var statearr_71123 = [null,null,null,null,null,null,null,null,null];
(statearr_71123[(0)] = flureenjs$state_machine__2879__auto__);

(statearr_71123[(1)] = (1));

return statearr_71123;
});
var flureenjs$state_machine__2879__auto____1 = (function (state_71106){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_71106);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e71124){var ex__2882__auto__ = e71124;
var statearr_71125_71138 = state_71106;
(statearr_71125_71138[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_71106[(4)]))){
var statearr_71126_71139 = state_71106;
(statearr_71126_71139[(1)] = cljs.core.first.call(null,(state_71106[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71140 = state_71106;
state_71106 = G__71140;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$state_machine__2879__auto__ = function(state_71106){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$state_machine__2879__auto____1.call(this,state_71106);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2879__auto____0;
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2879__auto____1;
return flureenjs$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_71127 = f__2902__auto__.call(null);
(statearr_71127[(6)] = c__2901__auto__);

return statearr_71127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureenjs.transact.cljs$lang$maxFixedArity = 4);

/**
 * Returns a Promise that will eventually contain transaction information for blocks from
 * start block (inclusive) to end if provided (exclusive). Each block is a separate map,
 * containing keys :block :tx
 */
flureenjs.block_range_with_txn = (function flureenjs$block_range_with_txn(var_args){
var G__71142 = arguments.length;
switch (G__71142) {
case 3:
return flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.block_range_with_txn', flureenjs.block_range_with_txn);

(flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,block_map){
return flureenjs.block_range_with_txn.call(null,conn,ledger,block_map,null);
}));

(flureenjs.block_range_with_txn.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,block_map,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_71191){
var state_val_71192 = (state_71191[(1)]);
if((state_val_71192 === (7))){
var state_71191__$1 = state_71191;
var statearr_71193_71223 = state_71191__$1;
(statearr_71193_71223[(2)] = false);

(statearr_71193_71223[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (1))){
var state_71191__$1 = state_71191;
var statearr_71194_71224 = state_71191__$1;
(statearr_71194_71224[(2)] = null);

(statearr_71194_71224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (4))){
var inst_71143 = (state_71191[(2)]);
var inst_71144 = fluree.db.util.log.error.call(null,inst_71143);
var inst_71145 = reject.call(null,inst_71143);
var state_71191__$1 = (function (){var statearr_71195 = state_71191;
(statearr_71195[(7)] = inst_71144);

return statearr_71195;
})();
var statearr_71196_71225 = state_71191__$1;
(statearr_71196_71225[(2)] = inst_71145);

(statearr_71196_71225[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (15))){
var inst_71176 = (state_71191[(8)]);
var inst_71175 = (state_71191[(9)]);
var inst_71152 = (state_71191[(10)]);
var inst_71179 = (state_71191[(2)]);
var inst_71180 = fluree.db.query.block.block_range.call(null,inst_71179,inst_71175,inst_71176,inst_71152);
var state_71191__$1 = state_71191;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71191__$1,(16),inst_71180);
} else {
if((state_val_71192 === (13))){
var inst_71153 = (state_71191[(11)]);
var state_71191__$1 = state_71191;
var statearr_71197_71226 = state_71191__$1;
(statearr_71197_71226[(2)] = inst_71153);

(statearr_71197_71226[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (6))){
var inst_71153 = (state_71191[(11)]);
var inst_71158 = inst_71153.cljs$lang$protocol_mask$partition0$;
var inst_71159 = (inst_71158 & (64));
var inst_71160 = inst_71153.cljs$core$ISeq$;
var inst_71161 = (cljs.core.PROTOCOL_SENTINEL === inst_71160);
var inst_71162 = ((inst_71159) || (inst_71161));
var state_71191__$1 = state_71191;
if(cljs.core.truth_(inst_71162)){
var statearr_71198_71227 = state_71191__$1;
(statearr_71198_71227[(1)] = (9));

} else {
var statearr_71199_71228 = state_71191__$1;
(statearr_71199_71228[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (3))){
var inst_71189 = (state_71191[(2)]);
var state_71191__$1 = state_71191;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71191__$1,inst_71189);
} else {
if((state_val_71192 === (12))){
var inst_71153 = (state_71191[(11)]);
var inst_71171 = cljs.core.apply.call(null,cljs.core.hash_map,inst_71153);
var state_71191__$1 = state_71191;
var statearr_71200_71229 = state_71191__$1;
(statearr_71200_71229[(2)] = inst_71171);

(statearr_71200_71229[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (2))){
var inst_71153 = (state_71191[(11)]);
var _ = (function (){var statearr_71201 = state_71191;
(statearr_71201[(4)] = cljs.core.cons.call(null,(5),(state_71191[(4)])));

return statearr_71201;
})();
var inst_71152 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_71153__$1 = cljs.core.js__GT_clj.call(null,block_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_71155 = (inst_71153__$1 == null);
var inst_71156 = cljs.core.not.call(null,inst_71155);
var state_71191__$1 = (function (){var statearr_71202 = state_71191;
(statearr_71202[(11)] = inst_71153__$1);

(statearr_71202[(10)] = inst_71152);

return statearr_71202;
})();
if(inst_71156){
var statearr_71203_71230 = state_71191__$1;
(statearr_71203_71230[(1)] = (6));

} else {
var statearr_71204_71231 = state_71191__$1;
(statearr_71204_71231[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (11))){
var inst_71166 = (state_71191[(2)]);
var state_71191__$1 = state_71191;
var statearr_71206_71232 = state_71191__$1;
(statearr_71206_71232[(2)] = inst_71166);

(statearr_71206_71232[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (9))){
var state_71191__$1 = state_71191;
var statearr_71207_71233 = state_71191__$1;
(statearr_71207_71233[(2)] = true);

(statearr_71207_71233[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (5))){
var _ = (function (){var statearr_71208 = state_71191;
(statearr_71208[(4)] = cljs.core.rest.call(null,(state_71191[(4)])));

return statearr_71208;
})();
var state_71191__$1 = state_71191;
var ex71205 = (state_71191__$1[(2)]);
var statearr_71209_71234 = state_71191__$1;
(statearr_71209_71234[(5)] = ex71205);


var statearr_71210_71235 = state_71191__$1;
(statearr_71210_71235[(1)] = (4));

(statearr_71210_71235[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (14))){
var inst_71152 = (state_71191[(10)]);
var inst_71174 = (state_71191[(2)]);
var inst_71175 = cljs.core.get.call(null,inst_71174,new cljs.core.Keyword(null,"start","start",-355208981));
var inst_71176 = cljs.core.get.call(null,inst_71174,new cljs.core.Keyword(null,"end","end",-268185958));
var inst_71177 = flureenjs.db_instance.call(null,conn,ledger,inst_71152);
var state_71191__$1 = (function (){var statearr_71211 = state_71191;
(statearr_71211[(8)] = inst_71176);

(statearr_71211[(9)] = inst_71175);

return statearr_71211;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71191__$1,(15),inst_71177);
} else {
if((state_val_71192 === (16))){
var inst_71182 = (state_71191[(2)]);
var inst_71183 = fluree.db.util.async.throw_err.call(null,inst_71182);
var inst_71184 = fluree.db.query.range.block_with_tx_data.call(null,inst_71183);
var inst_71185 = cljs.core.clj__GT_js.call(null,inst_71184);
var inst_71186 = resolve.call(null,inst_71185);
var _ = (function (){var statearr_71212 = state_71191;
(statearr_71212[(4)] = cljs.core.rest.call(null,(state_71191[(4)])));

return statearr_71212;
})();
var state_71191__$1 = state_71191;
var statearr_71213_71236 = state_71191__$1;
(statearr_71213_71236[(2)] = inst_71186);

(statearr_71213_71236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (10))){
var state_71191__$1 = state_71191;
var statearr_71214_71237 = state_71191__$1;
(statearr_71214_71237[(2)] = false);

(statearr_71214_71237[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71192 === (8))){
var inst_71169 = (state_71191[(2)]);
var state_71191__$1 = state_71191;
if(cljs.core.truth_(inst_71169)){
var statearr_71215_71238 = state_71191__$1;
(statearr_71215_71238[(1)] = (12));

} else {
var statearr_71216_71239 = state_71191__$1;
(statearr_71216_71239[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2879__auto__ = null;
var flureenjs$state_machine__2879__auto____0 = (function (){
var statearr_71217 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71217[(0)] = flureenjs$state_machine__2879__auto__);

(statearr_71217[(1)] = (1));

return statearr_71217;
});
var flureenjs$state_machine__2879__auto____1 = (function (state_71191){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_71191);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e71218){var ex__2882__auto__ = e71218;
var statearr_71219_71240 = state_71191;
(statearr_71219_71240[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_71191[(4)]))){
var statearr_71220_71241 = state_71191;
(statearr_71220_71241[(1)] = cljs.core.first.call(null,(state_71191[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71242 = state_71191;
state_71191 = G__71242;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$state_machine__2879__auto__ = function(state_71191){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$state_machine__2879__auto____1.call(this,state_71191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2879__auto____0;
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2879__auto____1;
return flureenjs$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_71221 = f__2902__auto__.call(null);
(statearr_71221[(6)] = c__2901__auto__);

return statearr_71221;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureenjs.block_range_with_txn.cljs$lang$maxFixedArity = 4);

flureenjs.block_query = (function flureenjs$block_query(var_args){
var G__71244 = arguments.length;
switch (G__71244) {
case 3:
return flureenjs.block_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.block_query.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.block_query', flureenjs.block_query);

(flureenjs.block_query.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return flureenjs.block_query.call(null,conn,ledger,query_map,null);
}));

(flureenjs.block_query.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_71302){
var state_val_71303 = (state_71302[(1)]);
if((state_val_71303 === (7))){
var state_71302__$1 = state_71302;
var statearr_71304_71345 = state_71302__$1;
(statearr_71304_71345[(2)] = null);

(statearr_71304_71345[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (20))){
var inst_71281 = (state_71302[(2)]);
var state_71302__$1 = state_71302;
var statearr_71305_71346 = state_71302__$1;
(statearr_71305_71346[(2)] = inst_71281);

(statearr_71305_71346[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (1))){
var state_71302__$1 = state_71302;
var statearr_71306_71347 = state_71302__$1;
(statearr_71306_71347[(2)] = null);

(statearr_71306_71347[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (4))){
var inst_71245 = (state_71302[(2)]);
var inst_71246 = fluree.db.util.log.error.call(null,inst_71245);
var inst_71247 = reject.call(null,inst_71245);
var state_71302__$1 = (function (){var statearr_71307 = state_71302;
(statearr_71307[(7)] = inst_71246);

return statearr_71307;
})();
var statearr_71308_71348 = state_71302__$1;
(statearr_71308_71348[(2)] = inst_71247);

(statearr_71308_71348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (15))){
var state_71302__$1 = state_71302;
var statearr_71309_71349 = state_71302__$1;
(statearr_71309_71349[(2)] = null);

(statearr_71309_71349[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (21))){
var inst_71294 = (state_71302[(2)]);
var inst_71295 = fluree.db.util.async.throw_err.call(null,inst_71294);
var inst_71296 = cljs.core.clj__GT_js.call(null,inst_71295);
var inst_71297 = resolve.call(null,inst_71296);
var _ = (function (){var statearr_71310 = state_71302;
(statearr_71310[(4)] = cljs.core.rest.call(null,(state_71302[(4)])));

return statearr_71310;
})();
var state_71302__$1 = state_71302;
var statearr_71311_71350 = state_71302__$1;
(statearr_71311_71350[(2)] = inst_71297);

(statearr_71311_71350[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (13))){
var inst_71269 = (state_71302[(8)]);
var inst_71260 = (state_71302[(9)]);
var inst_71269__$1 = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(inst_71260);
var inst_71270 = (inst_71269__$1 == null);
var state_71302__$1 = (function (){var statearr_71312 = state_71302;
(statearr_71312[(8)] = inst_71269__$1);

return statearr_71312;
})();
if(cljs.core.truth_(inst_71270)){
var statearr_71313_71351 = state_71302__$1;
(statearr_71313_71351[(1)] = (15));

} else {
var statearr_71314_71352 = state_71302__$1;
(statearr_71314_71352[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (6))){
var inst_71256 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_71302__$1 = state_71302;
var statearr_71315_71353 = state_71302__$1;
(statearr_71315_71353[(2)] = inst_71256);

(statearr_71315_71353[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (17))){
var inst_71275 = (state_71302[(10)]);
var inst_71275__$1 = (state_71302[(2)]);
var inst_71276 = (inst_71275__$1 == null);
var state_71302__$1 = (function (){var statearr_71316 = state_71302;
(statearr_71316[(10)] = inst_71275__$1);

return statearr_71316;
})();
if(cljs.core.truth_(inst_71276)){
var statearr_71317_71354 = state_71302__$1;
(statearr_71317_71354[(1)] = (18));

} else {
var statearr_71318_71355 = state_71302__$1;
(statearr_71318_71355[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (3))){
var inst_71300 = (state_71302[(2)]);
var state_71302__$1 = state_71302;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71302__$1,inst_71300);
} else {
if((state_val_71303 === (12))){
var inst_71265 = (state_71302[(11)]);
var state_71302__$1 = state_71302;
var statearr_71319_71356 = state_71302__$1;
(statearr_71319_71356[(2)] = inst_71265);

(statearr_71319_71356[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (2))){
var inst_71253 = (state_71302[(12)]);
var _ = (function (){var statearr_71320 = state_71302;
(statearr_71320[(4)] = cljs.core.cons.call(null,(5),(state_71302[(4)])));

return statearr_71320;
})();
var inst_71253__$1 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_71254 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_71253__$1);
var state_71302__$1 = (function (){var statearr_71321 = state_71302;
(statearr_71321[(13)] = inst_71254);

(statearr_71321[(12)] = inst_71253__$1);

return statearr_71321;
})();
if(cljs.core.truth_(opts)){
var statearr_71322_71357 = state_71302__$1;
(statearr_71322_71357[(1)] = (6));

} else {
var statearr_71323_71358 = state_71302__$1;
(statearr_71323_71358[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (19))){
var inst_71275 = (state_71302[(10)]);
var inst_71279 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_71275);
var state_71302__$1 = state_71302;
var statearr_71324_71359 = state_71302__$1;
(statearr_71324_71359[(2)] = inst_71279);

(statearr_71324_71359[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (11))){
var inst_71260 = (state_71302[(9)]);
var inst_71253 = (state_71302[(12)]);
var inst_71285 = (state_71302[(2)]);
var inst_71286 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_71287 = [inst_71285];
var inst_71288 = cljs.core.PersistentHashMap.fromArrays(inst_71286,inst_71287);
var inst_71289 = fluree.db.util.core.without_nils.call(null,inst_71288);
var inst_71290 = cljs.core.merge.call(null,inst_71260,inst_71289);
var inst_71291 = cljs.core.update.call(null,inst_71253,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge,inst_71290);
var inst_71292 = fluree.db.api.query.block_query_async.call(null,conn,ledger,inst_71291);
var state_71302__$1 = state_71302;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71302__$1,(21),inst_71292);
} else {
if((state_val_71303 === (9))){
var inst_71262 = (state_71302[(14)]);
var state_71302__$1 = state_71302;
var statearr_71326_71360 = state_71302__$1;
(statearr_71326_71360[(2)] = inst_71262);

(statearr_71326_71360[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (5))){
var _ = (function (){var statearr_71327 = state_71302;
(statearr_71327[(4)] = cljs.core.rest.call(null,(state_71302[(4)])));

return statearr_71327;
})();
var state_71302__$1 = state_71302;
var ex71325 = (state_71302__$1[(2)]);
var statearr_71328_71361 = state_71302__$1;
(statearr_71328_71361[(5)] = ex71325);


var statearr_71329_71362 = state_71302__$1;
(statearr_71329_71362[(1)] = (4));

(statearr_71329_71362[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (14))){
var inst_71283 = (state_71302[(2)]);
var state_71302__$1 = state_71302;
var statearr_71330_71363 = state_71302__$1;
(statearr_71330_71363[(2)] = inst_71283);

(statearr_71330_71363[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (16))){
var inst_71269 = (state_71302[(8)]);
var inst_71273 = fluree.db.connection_js.validate_token.call(null,conn,inst_71269);
var state_71302__$1 = state_71302;
var statearr_71331_71364 = state_71302__$1;
(statearr_71331_71364[(2)] = inst_71273);

(statearr_71331_71364[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (10))){
var inst_71260 = (state_71302[(9)]);
var inst_71265 = (state_71302[(11)]);
var inst_71265__$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(inst_71260);
var state_71302__$1 = (function (){var statearr_71332 = state_71302;
(statearr_71332[(11)] = inst_71265__$1);

return statearr_71332;
})();
if(cljs.core.truth_(inst_71265__$1)){
var statearr_71333_71365 = state_71302__$1;
(statearr_71333_71365[(1)] = (12));

} else {
var statearr_71334_71366 = state_71302__$1;
(statearr_71334_71366[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (18))){
var state_71302__$1 = state_71302;
var statearr_71335_71367 = state_71302__$1;
(statearr_71335_71367[(2)] = null);

(statearr_71335_71367[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71303 === (8))){
var inst_71254 = (state_71302[(13)]);
var inst_71260 = (state_71302[(9)]);
var inst_71262 = (state_71302[(14)]);
var inst_71259 = (state_71302[(2)]);
var inst_71260__$1 = cljs.core.merge.call(null,inst_71254,inst_71259);
var inst_71261 = fluree.db.connection_js.check_connection.call(null,conn,inst_71260__$1);
var inst_71262__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_71260__$1);
var state_71302__$1 = (function (){var statearr_71336 = state_71302;
(statearr_71336[(15)] = inst_71261);

(statearr_71336[(9)] = inst_71260__$1);

(statearr_71336[(14)] = inst_71262__$1);

return statearr_71336;
})();
if(cljs.core.truth_(inst_71262__$1)){
var statearr_71337_71368 = state_71302__$1;
(statearr_71337_71368[(1)] = (9));

} else {
var statearr_71338_71369 = state_71302__$1;
(statearr_71338_71369[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2879__auto__ = null;
var flureenjs$state_machine__2879__auto____0 = (function (){
var statearr_71339 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71339[(0)] = flureenjs$state_machine__2879__auto__);

(statearr_71339[(1)] = (1));

return statearr_71339;
});
var flureenjs$state_machine__2879__auto____1 = (function (state_71302){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_71302);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e71340){var ex__2882__auto__ = e71340;
var statearr_71341_71370 = state_71302;
(statearr_71341_71370[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_71302[(4)]))){
var statearr_71342_71371 = state_71302;
(statearr_71342_71371[(1)] = cljs.core.first.call(null,(state_71302[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71372 = state_71302;
state_71302 = G__71372;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$state_machine__2879__auto__ = function(state_71302){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$state_machine__2879__auto____1.call(this,state_71302);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2879__auto____0;
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2879__auto____1;
return flureenjs$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_71343 = f__2902__auto__.call(null);
(statearr_71343[(6)] = c__2901__auto__);

return statearr_71343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureenjs.block_query.cljs$lang$maxFixedArity = 4);

/**
 * Returns a promise containing blocks from start (inclusive)
 * to end if provided (exclusive).
 * 
 * Each block is a separate map, containing keys :block, :t and :flakes.
 */
flureenjs.block_range = (function flureenjs$block_range(var_args){
var G__71374 = arguments.length;
switch (G__71374) {
case 2:
return flureenjs.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.block_range', flureenjs.block_range);

(flureenjs.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return flureenjs.block_range.call(null,db,start,null,null);
}));

(flureenjs.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return flureenjs.block_range.call(null,db,start,end,null);
}));

(flureenjs.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_71398){
var state_val_71399 = (state_71398[(1)]);
if((state_val_71399 === (1))){
var state_71398__$1 = state_71398;
var statearr_71400_71417 = state_71398__$1;
(statearr_71400_71417[(2)] = null);

(statearr_71400_71417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71399 === (2))){
var _ = (function (){var statearr_71401 = state_71398;
(statearr_71401[(4)] = cljs.core.cons.call(null,(5),(state_71398[(4)])));

return statearr_71401;
})();
var inst_71383 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_71398__$1 = (function (){var statearr_71402 = state_71398;
(statearr_71402[(7)] = inst_71383);

return statearr_71402;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71398__$1,(7),db);
} else {
if((state_val_71399 === (3))){
var inst_71396 = (state_71398[(2)]);
var state_71398__$1 = state_71398;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71398__$1,inst_71396);
} else {
if((state_val_71399 === (4))){
var inst_71375 = (state_71398[(2)]);
var inst_71376 = fluree.db.util.log.error.call(null,inst_71375);
var inst_71377 = reject.call(null,inst_71375);
var state_71398__$1 = (function (){var statearr_71404 = state_71398;
(statearr_71404[(8)] = inst_71376);

return statearr_71404;
})();
var statearr_71405_71418 = state_71398__$1;
(statearr_71405_71418[(2)] = inst_71377);

(statearr_71405_71418[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71399 === (5))){
var _ = (function (){var statearr_71406 = state_71398;
(statearr_71406[(4)] = cljs.core.rest.call(null,(state_71398[(4)])));

return statearr_71406;
})();
var state_71398__$1 = state_71398;
var ex71403 = (state_71398__$1[(2)]);
var statearr_71407_71419 = state_71398__$1;
(statearr_71407_71419[(5)] = ex71403);


var statearr_71408_71420 = state_71398__$1;
(statearr_71408_71420[(1)] = (4));

(statearr_71408_71420[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71399 === (6))){
var inst_71389 = (state_71398[(2)]);
var inst_71390 = fluree.db.util.async.throw_err.call(null,inst_71389);
var inst_71391 = flureenjs.block_Flakes__GT_vector.call(null,inst_71390);
var inst_71392 = cljs.core.clj__GT_js.call(null,inst_71391);
var inst_71393 = resolve.call(null,inst_71392);
var _ = (function (){var statearr_71409 = state_71398;
(statearr_71409[(4)] = cljs.core.rest.call(null,(state_71398[(4)])));

return statearr_71409;
})();
var state_71398__$1 = state_71398;
var statearr_71410_71421 = state_71398__$1;
(statearr_71410_71421[(2)] = inst_71393);

(statearr_71410_71421[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71399 === (7))){
var inst_71383 = (state_71398[(7)]);
var inst_71385 = (state_71398[(2)]);
var inst_71386 = fluree.db.util.async.throw_err.call(null,inst_71385);
var inst_71387 = fluree.db.query.block.block_range.call(null,inst_71386,start,end,inst_71383);
var state_71398__$1 = state_71398;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71398__$1,(6),inst_71387);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2879__auto__ = null;
var flureenjs$state_machine__2879__auto____0 = (function (){
var statearr_71411 = [null,null,null,null,null,null,null,null,null];
(statearr_71411[(0)] = flureenjs$state_machine__2879__auto__);

(statearr_71411[(1)] = (1));

return statearr_71411;
});
var flureenjs$state_machine__2879__auto____1 = (function (state_71398){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_71398);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e71412){var ex__2882__auto__ = e71412;
var statearr_71413_71422 = state_71398;
(statearr_71413_71422[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_71398[(4)]))){
var statearr_71414_71423 = state_71398;
(statearr_71414_71423[(1)] = cljs.core.first.call(null,(state_71398[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71424 = state_71398;
state_71398 = G__71424;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$state_machine__2879__auto__ = function(state_71398){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$state_machine__2879__auto____1.call(this,state_71398);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2879__auto____0;
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2879__auto____1;
return flureenjs$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_71415 = f__2902__auto__.call(null);
(statearr_71415[(6)] = c__2901__auto__);

return statearr_71415;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureenjs.block_range.cljs$lang$maxFixedArity = 4);

/**
 * Returns spot index range for only the requested collection.
 */
flureenjs.collection_flakes = (function flureenjs$collection_flakes(db,collection){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_71447){
var state_val_71448 = (state_71447[(1)]);
if((state_val_71448 === (1))){
var state_71447__$1 = state_71447;
var statearr_71449_71464 = state_71447__$1;
(statearr_71449_71464[(2)] = null);

(statearr_71449_71464[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71448 === (2))){
var _ = (function (){var statearr_71450 = state_71447;
(statearr_71450[(4)] = cljs.core.cons.call(null,(5),(state_71447[(4)])));

return statearr_71450;
})();
var state_71447__$1 = state_71447;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71447__$1,(7),db);
} else {
if((state_val_71448 === (3))){
var inst_71445 = (state_71447[(2)]);
var state_71447__$1 = state_71447;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71447__$1,inst_71445);
} else {
if((state_val_71448 === (4))){
var inst_71425 = (state_71447[(2)]);
var inst_71426 = fluree.db.util.log.error.call(null,inst_71425);
var inst_71427 = reject.call(null,inst_71425);
var state_71447__$1 = (function (){var statearr_71452 = state_71447;
(statearr_71452[(7)] = inst_71426);

return statearr_71452;
})();
var statearr_71453_71465 = state_71447__$1;
(statearr_71453_71465[(2)] = inst_71427);

(statearr_71453_71465[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71448 === (5))){
var _ = (function (){var statearr_71454 = state_71447;
(statearr_71454[(4)] = cljs.core.rest.call(null,(state_71447[(4)])));

return statearr_71454;
})();
var state_71447__$1 = state_71447;
var ex71451 = (state_71447__$1[(2)]);
var statearr_71455_71466 = state_71447__$1;
(statearr_71455_71466[(5)] = ex71451);


var statearr_71456_71467 = state_71447__$1;
(statearr_71456_71467[(1)] = (4));

(statearr_71456_71467[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71448 === (6))){
var inst_71438 = (state_71447[(2)]);
var inst_71439 = fluree.db.util.async.throw_err.call(null,inst_71438);
var inst_71440 = cljs.core.map.call(null,fluree.db.flake.Flake__GT_parts,inst_71439);
var inst_71441 = cljs.core.clj__GT_js.call(null,inst_71440);
var inst_71442 = resolve.call(null,inst_71441);
var _ = (function (){var statearr_71457 = state_71447;
(statearr_71457[(4)] = cljs.core.rest.call(null,(state_71447[(4)])));

return statearr_71457;
})();
var state_71447__$1 = state_71447;
var statearr_71458_71468 = state_71447__$1;
(statearr_71458_71468[(2)] = inst_71442);

(statearr_71458_71468[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71448 === (7))){
var inst_71434 = (state_71447[(2)]);
var inst_71435 = fluree.db.util.async.throw_err.call(null,inst_71434);
var inst_71436 = fluree.db.query.range.collection.call(null,inst_71435,collection);
var state_71447__$1 = state_71447;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71447__$1,(6),inst_71436);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$collection_flakes_$_state_machine__2879__auto__ = null;
var flureenjs$collection_flakes_$_state_machine__2879__auto____0 = (function (){
var statearr_71459 = [null,null,null,null,null,null,null,null];
(statearr_71459[(0)] = flureenjs$collection_flakes_$_state_machine__2879__auto__);

(statearr_71459[(1)] = (1));

return statearr_71459;
});
var flureenjs$collection_flakes_$_state_machine__2879__auto____1 = (function (state_71447){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_71447);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e71460){var ex__2882__auto__ = e71460;
var statearr_71461_71469 = state_71447;
(statearr_71461_71469[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_71447[(4)]))){
var statearr_71462_71470 = state_71447;
(statearr_71462_71470[(1)] = cljs.core.first.call(null,(state_71447[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71471 = state_71447;
state_71447 = G__71471;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$collection_flakes_$_state_machine__2879__auto__ = function(state_71447){
switch(arguments.length){
case 0:
return flureenjs$collection_flakes_$_state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$collection_flakes_$_state_machine__2879__auto____1.call(this,state_71447);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$collection_flakes_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$collection_flakes_$_state_machine__2879__auto____0;
flureenjs$collection_flakes_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$collection_flakes_$_state_machine__2879__auto____1;
return flureenjs$collection_flakes_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_71463 = f__2902__auto__.call(null);
(statearr_71463[(6)] = c__2901__auto__);

return statearr_71463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureenjs.collection_flakes', flureenjs.collection_flakes);
/**
 * Execute a graphql query against the specified database.
 */
flureenjs.graphql = (function flureenjs$graphql(var_args){
var G__71473 = arguments.length;
switch (G__71473) {
case 3:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return flureenjs.graphql.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.graphql', flureenjs.graphql);

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,param){
return flureenjs.graphql.call(null,conn,ledger,param,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.graphql.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,param,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_71595){
var state_val_71596 = (state_71595[(1)]);
if((state_val_71596 === (7))){
var state_71595__$1 = state_71595;
var statearr_71597_71662 = state_71595__$1;
(statearr_71597_71662[(2)] = null);

(statearr_71597_71662[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (20))){
var inst_71523 = (state_71595[(7)]);
var state_71595__$1 = state_71595;
var statearr_71598_71663 = state_71595__$1;
(statearr_71598_71663[(2)] = inst_71523);

(statearr_71598_71663[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (27))){
var inst_71523 = (state_71595[(7)]);
var inst_71537 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_71523);
var state_71595__$1 = state_71595;
var statearr_71599_71664 = state_71595__$1;
(statearr_71599_71664[(2)] = inst_71537);

(statearr_71599_71664[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (1))){
var state_71595__$1 = state_71595;
var statearr_71600_71665 = state_71595__$1;
(statearr_71600_71665[(2)] = null);

(statearr_71600_71665[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (24))){
var inst_71523 = (state_71595[(7)]);
var inst_71541 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_71523);
var inst_71542 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"history","history",-247395220),inst_71541);
var state_71595__$1 = state_71595;
if(inst_71542){
var statearr_71601_71666 = state_71595__$1;
(statearr_71601_71666[(1)] = (29));

} else {
var statearr_71602_71667 = state_71595__$1;
(statearr_71602_71667[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (39))){
var inst_71580 = (state_71595[(2)]);
var state_71595__$1 = state_71595;
var statearr_71603_71668 = state_71595__$1;
(statearr_71603_71668[(2)] = inst_71580);

(statearr_71603_71668[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (4))){
var inst_71474 = (state_71595[(2)]);
var inst_71475 = fluree.db.util.log.error.call(null,inst_71474);
var inst_71476 = cljs.core.clj__GT_js.call(null,inst_71474);
var inst_71477 = reject.call(null,inst_71476);
var state_71595__$1 = (function (){var statearr_71604 = state_71595;
(statearr_71604[(8)] = inst_71475);

return statearr_71604;
})();
var statearr_71605_71669 = state_71595__$1;
(statearr_71605_71669[(2)] = inst_71477);

(statearr_71605_71669[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (15))){
var inst_71485 = (state_71595[(9)]);
var inst_71510 = cljs.core.apply.call(null,cljs.core.hash_map,inst_71485);
var state_71595__$1 = state_71595;
var statearr_71606_71670 = state_71595__$1;
(statearr_71606_71670[(2)] = inst_71510);

(statearr_71606_71670[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (21))){
var inst_71523 = (state_71595[(7)]);
var inst_71527 = [new cljs.core.Keyword(null,"__schema","__schema",-305244223),null,new cljs.core.Keyword(null,"__type","__type",1665433236),null];
var inst_71528 = (new cljs.core.PersistentArrayMap(null,2,inst_71527,null));
var inst_71529 = (new cljs.core.PersistentHashSet(null,inst_71528,null));
var inst_71530 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_71523);
var inst_71531 = inst_71529.call(null,inst_71530);
var state_71595__$1 = state_71595;
if(cljs.core.truth_(inst_71531)){
var statearr_71607_71671 = state_71595__$1;
(statearr_71607_71671[(1)] = (23));

} else {
var statearr_71608_71672 = state_71595__$1;
(statearr_71608_71672[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (31))){
var inst_71584 = (state_71595[(2)]);
var state_71595__$1 = state_71595;
var statearr_71609_71673 = state_71595__$1;
(statearr_71609_71673[(2)] = inst_71584);

(statearr_71609_71673[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (32))){
var inst_71548 = (state_71595[(2)]);
var inst_71549 = fluree.db.util.async.throw_err.call(null,inst_71548);
var state_71595__$1 = state_71595;
var statearr_71610_71674 = state_71595__$1;
(statearr_71610_71674[(2)] = inst_71549);

(statearr_71610_71674[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (40))){
var inst_71566 = (state_71595[(2)]);
var inst_71567 = fluree.db.util.async.throw_err.call(null,inst_71566);
var state_71595__$1 = state_71595;
var statearr_71611_71675 = state_71595__$1;
(statearr_71611_71675[(2)] = inst_71567);

(statearr_71611_71675[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (33))){
var inst_71492 = (state_71595[(10)]);
var inst_71523 = (state_71595[(7)]);
var inst_71554 = cljs.core.dissoc.call(null,inst_71523,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_71555 = cljs.core.assoc.call(null,inst_71554,new cljs.core.Keyword(null,"opts","opts",155075701),inst_71492);
var inst_71556 = fluree.db.api.query.block_query_async.call(null,conn,ledger,inst_71555);
var state_71595__$1 = state_71595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71595__$1,(36),inst_71556);
} else {
if((state_val_71596 === (13))){
var state_71595__$1 = state_71595;
var statearr_71612_71676 = state_71595__$1;
(statearr_71612_71676[(2)] = false);

(statearr_71612_71676[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (22))){
var inst_71588 = (state_71595[(2)]);
var inst_71589 = cljs.core.clj__GT_js.call(null,inst_71588);
var inst_71590 = resolve.call(null,inst_71589);
var _ = (function (){var statearr_71613 = state_71595;
(statearr_71613[(4)] = cljs.core.rest.call(null,(state_71595[(4)])));

return statearr_71613;
})();
var state_71595__$1 = state_71595;
var statearr_71614_71677 = state_71595__$1;
(statearr_71614_71677[(2)] = inst_71590);

(statearr_71614_71677[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (36))){
var inst_71558 = (state_71595[(2)]);
var inst_71559 = fluree.db.util.async.throw_err.call(null,inst_71558);
var state_71595__$1 = state_71595;
var statearr_71615_71678 = state_71595__$1;
(statearr_71615_71678[(2)] = inst_71559);

(statearr_71615_71678[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (41))){
var inst_71492 = (state_71595[(10)]);
var inst_71516 = (state_71595[(11)]);
var inst_71523 = (state_71595[(7)]);
var inst_71570 = cljs.core.dissoc.call(null,inst_71523,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_71571 = cljs.core.assoc.call(null,inst_71570,new cljs.core.Keyword(null,"opts","opts",155075701),inst_71492);
var inst_71572 = fluree.db.api.query.multi_query_async.call(null,inst_71516,inst_71571);
var state_71595__$1 = state_71595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71595__$1,(44),inst_71572);
} else {
if((state_val_71596 === (43))){
var inst_71578 = (state_71595[(2)]);
var state_71595__$1 = state_71595;
var statearr_71616_71679 = state_71595__$1;
(statearr_71616_71679[(2)] = inst_71578);

(statearr_71616_71679[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (29))){
var inst_71492 = (state_71595[(10)]);
var inst_71519 = (state_71595[(12)]);
var inst_71523 = (state_71595[(7)]);
var inst_71544 = cljs.core.dissoc.call(null,inst_71523,new cljs.core.Keyword(null,"type","type",1174270348));
var inst_71545 = cljs.core.assoc.call(null,inst_71544,new cljs.core.Keyword(null,"opts","opts",155075701),inst_71492);
var inst_71546 = fluree.db.api.query.history_query_async.call(null,inst_71519,inst_71545);
var state_71595__$1 = state_71595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71595__$1,(32),inst_71546);
} else {
if((state_val_71596 === (44))){
var inst_71574 = (state_71595[(2)]);
var inst_71575 = fluree.db.util.async.throw_err.call(null,inst_71574);
var state_71595__$1 = state_71595;
var statearr_71617_71680 = state_71595__$1;
(statearr_71617_71680[(2)] = inst_71575);

(statearr_71617_71680[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (6))){
var inst_71488 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_71595__$1 = state_71595;
var statearr_71618_71681 = state_71595__$1;
(statearr_71618_71681[(2)] = inst_71488);

(statearr_71618_71681[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (28))){
var inst_71539 = (state_71595[(2)]);
var state_71595__$1 = state_71595;
var statearr_71619_71682 = state_71595__$1;
(statearr_71619_71682[(2)] = inst_71539);

(statearr_71619_71682[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (25))){
var inst_71586 = (state_71595[(2)]);
var state_71595__$1 = state_71595;
var statearr_71620_71683 = state_71595__$1;
(statearr_71620_71683[(2)] = inst_71586);

(statearr_71620_71683[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (34))){
var inst_71523 = (state_71595[(7)]);
var inst_71561 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_71523);
var state_71595__$1 = state_71595;
if(cljs.core.truth_(inst_71561)){
var statearr_71621_71684 = state_71595__$1;
(statearr_71621_71684[(1)] = (37));

} else {
var statearr_71622_71685 = state_71595__$1;
(statearr_71622_71685[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (17))){
var inst_71492 = (state_71595[(10)]);
var inst_71516 = (state_71595[(11)]);
var inst_71513 = (state_71595[(2)]);
var inst_71514 = cljs.core.get.call(null,inst_71513,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_71515 = cljs.core.get.call(null,inst_71513,new cljs.core.Keyword(null,"variables","variables",1563680814));
var inst_71516__$1 = flureenjs.db_instance.call(null,conn,ledger,inst_71492);
var state_71595__$1 = (function (){var statearr_71623 = state_71595;
(statearr_71623[(11)] = inst_71516__$1);

(statearr_71623[(13)] = inst_71515);

(statearr_71623[(14)] = inst_71514);

return statearr_71623;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71595__$1,(18),inst_71516__$1);
} else {
if((state_val_71596 === (3))){
var inst_71593 = (state_71595[(2)]);
var state_71595__$1 = state_71595;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71595__$1,inst_71593);
} else {
if((state_val_71596 === (12))){
var state_71595__$1 = state_71595;
var statearr_71624_71686 = state_71595__$1;
(statearr_71624_71686[(2)] = true);

(statearr_71624_71686[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (2))){
var inst_71485 = (state_71595[(9)]);
var _ = (function (){var statearr_71625 = state_71595;
(statearr_71625[(4)] = cljs.core.cons.call(null,(5),(state_71595[(4)])));

return statearr_71625;
})();
var inst_71484 = fluree.db.util.json.parse.call(null,param);
var inst_71485__$1 = cljs.core.js__GT_clj.call(null,inst_71484,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_71486 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_71485__$1);
var state_71595__$1 = (function (){var statearr_71626 = state_71595;
(statearr_71626[(15)] = inst_71486);

(statearr_71626[(9)] = inst_71485__$1);

return statearr_71626;
})();
if(cljs.core.truth_(opts)){
var statearr_71627_71687 = state_71595__$1;
(statearr_71627_71687[(1)] = (6));

} else {
var statearr_71628_71688 = state_71595__$1;
(statearr_71628_71688[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (23))){
var inst_71492 = (state_71595[(10)]);
var inst_71533 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_71492);
var state_71595__$1 = state_71595;
if(cljs.core.truth_(inst_71533)){
var statearr_71629_71689 = state_71595__$1;
(statearr_71629_71689[(1)] = (26));

} else {
var statearr_71630_71690 = state_71595__$1;
(statearr_71630_71690[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (35))){
var inst_71582 = (state_71595[(2)]);
var state_71595__$1 = state_71595;
var statearr_71631_71691 = state_71595__$1;
(statearr_71631_71691[(2)] = inst_71582);

(statearr_71631_71691[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (19))){
var inst_71523 = (state_71595[(7)]);
var inst_71522 = (state_71595[(2)]);
var inst_71523__$1 = fluree.db.util.async.throw_err.call(null,inst_71522);
var inst_71524 = fluree.db.util.core.exception_QMARK_.call(null,inst_71523__$1);
var state_71595__$1 = (function (){var statearr_71632 = state_71595;
(statearr_71632[(7)] = inst_71523__$1);

return statearr_71632;
})();
if(inst_71524){
var statearr_71633_71692 = state_71595__$1;
(statearr_71633_71692[(1)] = (20));

} else {
var statearr_71634_71693 = state_71595__$1;
(statearr_71634_71693[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (11))){
var inst_71508 = (state_71595[(2)]);
var state_71595__$1 = state_71595;
if(cljs.core.truth_(inst_71508)){
var statearr_71636_71694 = state_71595__$1;
(statearr_71636_71694[(1)] = (15));

} else {
var statearr_71637_71695 = state_71595__$1;
(statearr_71637_71695[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (9))){
var inst_71485 = (state_71595[(9)]);
var inst_71497 = inst_71485.cljs$lang$protocol_mask$partition0$;
var inst_71498 = (inst_71497 & (64));
var inst_71499 = inst_71485.cljs$core$ISeq$;
var inst_71500 = (cljs.core.PROTOCOL_SENTINEL === inst_71499);
var inst_71501 = ((inst_71498) || (inst_71500));
var state_71595__$1 = state_71595;
if(cljs.core.truth_(inst_71501)){
var statearr_71638_71696 = state_71595__$1;
(statearr_71638_71696[(1)] = (12));

} else {
var statearr_71639_71697 = state_71595__$1;
(statearr_71639_71697[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (5))){
var _ = (function (){var statearr_71640 = state_71595;
(statearr_71640[(4)] = cljs.core.rest.call(null,(state_71595[(4)])));

return statearr_71640;
})();
var state_71595__$1 = state_71595;
var ex71635 = (state_71595__$1[(2)]);
var statearr_71641_71698 = state_71595__$1;
(statearr_71641_71698[(5)] = ex71635);


var statearr_71642_71699 = state_71595__$1;
(statearr_71642_71699[(1)] = (4));

(statearr_71642_71699[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (14))){
var inst_71505 = (state_71595[(2)]);
var state_71595__$1 = state_71595;
var statearr_71643_71700 = state_71595__$1;
(statearr_71643_71700[(2)] = inst_71505);

(statearr_71643_71700[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (26))){
var inst_71523 = (state_71595[(7)]);
var inst_71535 = cljs.core.dissoc.call(null,inst_71523,new cljs.core.Keyword(null,"type","type",1174270348));
var state_71595__$1 = state_71595;
var statearr_71644_71701 = state_71595__$1;
(statearr_71644_71701[(2)] = inst_71535);

(statearr_71644_71701[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (16))){
var inst_71485 = (state_71595[(9)]);
var state_71595__$1 = state_71595;
var statearr_71645_71702 = state_71595__$1;
(statearr_71645_71702[(2)] = inst_71485);

(statearr_71645_71702[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (38))){
var state_71595__$1 = state_71595;
var statearr_71646_71703 = state_71595__$1;
(statearr_71646_71703[(1)] = (41));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (30))){
var inst_71523 = (state_71595[(7)]);
var inst_71551 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_71523);
var inst_71552 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),inst_71551);
var state_71595__$1 = state_71595;
if(inst_71552){
var statearr_71648_71704 = state_71595__$1;
(statearr_71648_71704[(1)] = (33));

} else {
var statearr_71649_71705 = state_71595__$1;
(statearr_71649_71705[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (10))){
var state_71595__$1 = state_71595;
var statearr_71650_71706 = state_71595__$1;
(statearr_71650_71706[(2)] = false);

(statearr_71650_71706[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (18))){
var inst_71492 = (state_71595[(10)]);
var inst_71519 = (state_71595[(12)]);
var inst_71515 = (state_71595[(13)]);
var inst_71514 = (state_71595[(14)]);
var inst_71518 = (state_71595[(2)]);
var inst_71519__$1 = fluree.db.util.async.throw_err.call(null,inst_71518);
var inst_71520 = fluree.db.query.graphql_parser.parse_graphql_to_flureeql.call(null,inst_71519__$1,inst_71514,inst_71515,inst_71492);
var state_71595__$1 = (function (){var statearr_71651 = state_71595;
(statearr_71651[(12)] = inst_71519__$1);

return statearr_71651;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71595__$1,(19),inst_71520);
} else {
if((state_val_71596 === (42))){
var state_71595__$1 = state_71595;
var statearr_71652_71707 = state_71595__$1;
(statearr_71652_71707[(2)] = null);

(statearr_71652_71707[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71596 === (37))){
var inst_71492 = (state_71595[(10)]);
var inst_71523 = (state_71595[(7)]);
var inst_71563 = new cljs.core.Keyword(null,"tx","tx",466630418).cljs$core$IFn$_invoke$arity$1(inst_71523);
var inst_71564 = fluree.db.api_js.transact_async.call(null,conn,ledger,inst_71563,inst_71492);
var state_71595__$1 = state_71595;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71595__$1,(40),inst_71564);
} else {
if((state_val_71596 === (8))){
var inst_71486 = (state_71595[(15)]);
var inst_71485 = (state_71595[(9)]);
var inst_71491 = (state_71595[(2)]);
var inst_71492 = cljs.core.merge.call(null,inst_71486,inst_71491);
var inst_71494 = (inst_71485 == null);
var inst_71495 = cljs.core.not.call(null,inst_71494);
var state_71595__$1 = (function (){var statearr_71653 = state_71595;
(statearr_71653[(10)] = inst_71492);

return statearr_71653;
})();
if(inst_71495){
var statearr_71654_71708 = state_71595__$1;
(statearr_71654_71708[(1)] = (9));

} else {
var statearr_71655_71709 = state_71595__$1;
(statearr_71655_71709[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2879__auto__ = null;
var flureenjs$state_machine__2879__auto____0 = (function (){
var statearr_71656 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71656[(0)] = flureenjs$state_machine__2879__auto__);

(statearr_71656[(1)] = (1));

return statearr_71656;
});
var flureenjs$state_machine__2879__auto____1 = (function (state_71595){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_71595);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e71657){var ex__2882__auto__ = e71657;
var statearr_71658_71710 = state_71595;
(statearr_71658_71710[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_71595[(4)]))){
var statearr_71659_71711 = state_71595;
(statearr_71659_71711[(1)] = cljs.core.first.call(null,(state_71595[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71712 = state_71595;
state_71595 = G__71712;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$state_machine__2879__auto__ = function(state_71595){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$state_machine__2879__auto____1.call(this,state_71595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2879__auto____0;
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2879__auto____1;
return flureenjs$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_71660 = f__2902__auto__.call(null);
(statearr_71660[(6)] = c__2901__auto__);

return statearr_71660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureenjs.graphql.cljs$lang$maxFixedArity = 4);

flureenjs.history_query = (function flureenjs$history_query(var_args){
var G__71714 = arguments.length;
switch (G__71714) {
case 2:
return flureenjs.history_query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.history_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.history_query', flureenjs.history_query);

(flureenjs.history_query.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return flureenjs.history_query.call(null,sources,query_map,null);
}));

(flureenjs.history_query.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_71741){
var state_val_71742 = (state_71741[(1)]);
if((state_val_71742 === (1))){
var state_71741__$1 = state_71741;
var statearr_71743_71759 = state_71741__$1;
(statearr_71743_71759[(2)] = null);

(statearr_71743_71759[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71742 === (2))){
var _ = (function (){var statearr_71744 = state_71741;
(statearr_71744[(4)] = cljs.core.cons.call(null,(5),(state_71741[(4)])));

return statearr_71744;
})();
var inst_71723 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_71724 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_71723);
var inst_71725 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_71726 = cljs.core.merge.call(null,inst_71724,inst_71725);
var inst_71727 = [new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_71728 = [inst_71726];
var inst_71729 = cljs.core.PersistentHashMap.fromArrays(inst_71727,inst_71728);
var inst_71730 = cljs.core.merge.call(null,inst_71723,inst_71729);
var inst_71731 = fluree.db.api.query.history_query_async.call(null,sources,inst_71730);
var state_71741__$1 = state_71741;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71741__$1,(6),inst_71731);
} else {
if((state_val_71742 === (3))){
var inst_71739 = (state_71741[(2)]);
var state_71741__$1 = state_71741;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71741__$1,inst_71739);
} else {
if((state_val_71742 === (4))){
var inst_71715 = (state_71741[(2)]);
var inst_71716 = fluree.db.util.log.error.call(null,inst_71715);
var inst_71717 = reject.call(null,inst_71715);
var state_71741__$1 = (function (){var statearr_71746 = state_71741;
(statearr_71746[(7)] = inst_71716);

return statearr_71746;
})();
var statearr_71747_71760 = state_71741__$1;
(statearr_71747_71760[(2)] = inst_71717);

(statearr_71747_71760[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71742 === (5))){
var _ = (function (){var statearr_71748 = state_71741;
(statearr_71748[(4)] = cljs.core.rest.call(null,(state_71741[(4)])));

return statearr_71748;
})();
var state_71741__$1 = state_71741;
var ex71745 = (state_71741__$1[(2)]);
var statearr_71749_71761 = state_71741__$1;
(statearr_71749_71761[(5)] = ex71745);


var statearr_71750_71762 = state_71741__$1;
(statearr_71750_71762[(1)] = (4));

(statearr_71750_71762[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71742 === (6))){
var inst_71733 = (state_71741[(2)]);
var inst_71734 = fluree.db.util.async.throw_err.call(null,inst_71733);
var inst_71735 = cljs.core.clj__GT_js.call(null,inst_71734);
var inst_71736 = resolve.call(null,inst_71735);
var _ = (function (){var statearr_71751 = state_71741;
(statearr_71751[(4)] = cljs.core.rest.call(null,(state_71741[(4)])));

return statearr_71751;
})();
var state_71741__$1 = state_71741;
var statearr_71752_71763 = state_71741__$1;
(statearr_71752_71763[(2)] = inst_71736);

(statearr_71752_71763[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2879__auto__ = null;
var flureenjs$state_machine__2879__auto____0 = (function (){
var statearr_71753 = [null,null,null,null,null,null,null,null];
(statearr_71753[(0)] = flureenjs$state_machine__2879__auto__);

(statearr_71753[(1)] = (1));

return statearr_71753;
});
var flureenjs$state_machine__2879__auto____1 = (function (state_71741){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_71741);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e71754){var ex__2882__auto__ = e71754;
var statearr_71755_71764 = state_71741;
(statearr_71755_71764[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_71741[(4)]))){
var statearr_71756_71765 = state_71741;
(statearr_71756_71765[(1)] = cljs.core.first.call(null,(state_71741[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71766 = state_71741;
state_71741 = G__71766;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$state_machine__2879__auto__ = function(state_71741){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$state_machine__2879__auto____1.call(this,state_71741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2879__auto____0;
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2879__auto____1;
return flureenjs$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_71757 = f__2902__auto__.call(null);
(statearr_71757[(6)] = c__2901__auto__);

return statearr_71757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureenjs.history_query.cljs$lang$maxFixedArity = 3);

flureenjs.multi_query = (function flureenjs$multi_query(var_args){
var G__71768 = arguments.length;
switch (G__71768) {
case 2:
return flureenjs.multi_query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.multi_query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.multi_query', flureenjs.multi_query);

(flureenjs.multi_query.cljs$core$IFn$_invoke$arity$2 = (function (source,multi_query_map){
return flureenjs.multi_query.call(null,source,multi_query_map,null);
}));

(flureenjs.multi_query.cljs$core$IFn$_invoke$arity$3 = (function (source,multi_query_map,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_71795){
var state_val_71796 = (state_71795[(1)]);
if((state_val_71796 === (1))){
var state_71795__$1 = state_71795;
var statearr_71797_71813 = state_71795__$1;
(statearr_71797_71813[(2)] = null);

(statearr_71797_71813[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71796 === (2))){
var _ = (function (){var statearr_71798 = state_71795;
(statearr_71798[(4)] = cljs.core.cons.call(null,(5),(state_71795[(4)])));

return statearr_71798;
})();
var inst_71777 = cljs.core.js__GT_clj.call(null,multi_query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_71778 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_71777);
var inst_71779 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_71780 = cljs.core.merge.call(null,inst_71778,inst_71779);
var inst_71781 = [new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_71782 = [inst_71780];
var inst_71783 = cljs.core.PersistentHashMap.fromArrays(inst_71781,inst_71782);
var inst_71784 = cljs.core.merge.call(null,inst_71777,inst_71783);
var inst_71785 = fluree.db.api.query.multi_query_async.call(null,source,inst_71784);
var state_71795__$1 = state_71795;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71795__$1,(6),inst_71785);
} else {
if((state_val_71796 === (3))){
var inst_71793 = (state_71795[(2)]);
var state_71795__$1 = state_71795;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71795__$1,inst_71793);
} else {
if((state_val_71796 === (4))){
var inst_71769 = (state_71795[(2)]);
var inst_71770 = fluree.db.util.log.error.call(null,inst_71769);
var inst_71771 = reject.call(null,inst_71769);
var state_71795__$1 = (function (){var statearr_71800 = state_71795;
(statearr_71800[(7)] = inst_71770);

return statearr_71800;
})();
var statearr_71801_71814 = state_71795__$1;
(statearr_71801_71814[(2)] = inst_71771);

(statearr_71801_71814[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71796 === (5))){
var _ = (function (){var statearr_71802 = state_71795;
(statearr_71802[(4)] = cljs.core.rest.call(null,(state_71795[(4)])));

return statearr_71802;
})();
var state_71795__$1 = state_71795;
var ex71799 = (state_71795__$1[(2)]);
var statearr_71803_71815 = state_71795__$1;
(statearr_71803_71815[(5)] = ex71799);


var statearr_71804_71816 = state_71795__$1;
(statearr_71804_71816[(1)] = (4));

(statearr_71804_71816[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71796 === (6))){
var inst_71787 = (state_71795[(2)]);
var inst_71788 = fluree.db.util.async.throw_err.call(null,inst_71787);
var inst_71789 = cljs.core.clj__GT_js.call(null,inst_71788);
var inst_71790 = resolve.call(null,inst_71789);
var _ = (function (){var statearr_71805 = state_71795;
(statearr_71805[(4)] = cljs.core.rest.call(null,(state_71795[(4)])));

return statearr_71805;
})();
var state_71795__$1 = state_71795;
var statearr_71806_71817 = state_71795__$1;
(statearr_71806_71817[(2)] = inst_71790);

(statearr_71806_71817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2879__auto__ = null;
var flureenjs$state_machine__2879__auto____0 = (function (){
var statearr_71807 = [null,null,null,null,null,null,null,null];
(statearr_71807[(0)] = flureenjs$state_machine__2879__auto__);

(statearr_71807[(1)] = (1));

return statearr_71807;
});
var flureenjs$state_machine__2879__auto____1 = (function (state_71795){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_71795);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e71808){var ex__2882__auto__ = e71808;
var statearr_71809_71818 = state_71795;
(statearr_71809_71818[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_71795[(4)]))){
var statearr_71810_71819 = state_71795;
(statearr_71810_71819[(1)] = cljs.core.first.call(null,(state_71795[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71820 = state_71795;
state_71795 = G__71820;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$state_machine__2879__auto__ = function(state_71795){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$state_machine__2879__auto____1.call(this,state_71795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2879__auto____0;
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2879__auto____1;
return flureenjs$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_71811 = f__2902__auto__.call(null);
(statearr_71811[(6)] = c__2901__auto__);

return statearr_71811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureenjs.multi_query.cljs$lang$maxFixedArity = 3);

/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 * 
 *   Returns promise that eventually contains the results or
 *   an exception.
 */
flureenjs.query = (function flureenjs$query(source,query_map){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_71841){
var state_val_71842 = (state_71841[(1)]);
if((state_val_71842 === (1))){
var state_71841__$1 = state_71841;
var statearr_71843_71858 = state_71841__$1;
(statearr_71843_71858[(2)] = null);

(statearr_71843_71858[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71842 === (2))){
var _ = (function (){var statearr_71844 = state_71841;
(statearr_71844[(4)] = cljs.core.cons.call(null,(5),(state_71841[(4)])));

return statearr_71844;
})();
var inst_71830 = cljs.core.js__GT_clj.call(null,query_map,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_71831 = fluree.db.api.query.query.call(null,source,inst_71830);
var state_71841__$1 = state_71841;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71841__$1,(6),inst_71831);
} else {
if((state_val_71842 === (3))){
var inst_71839 = (state_71841[(2)]);
var state_71841__$1 = state_71841;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71841__$1,inst_71839);
} else {
if((state_val_71842 === (4))){
var inst_71821 = (state_71841[(2)]);
var inst_71822 = fluree.db.util.log.error.call(null,inst_71821);
var inst_71823 = cljs.core.clj__GT_js.call(null,inst_71821);
var inst_71824 = reject.call(null,inst_71823);
var state_71841__$1 = (function (){var statearr_71846 = state_71841;
(statearr_71846[(7)] = inst_71822);

return statearr_71846;
})();
var statearr_71847_71859 = state_71841__$1;
(statearr_71847_71859[(2)] = inst_71824);

(statearr_71847_71859[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71842 === (5))){
var _ = (function (){var statearr_71848 = state_71841;
(statearr_71848[(4)] = cljs.core.rest.call(null,(state_71841[(4)])));

return statearr_71848;
})();
var state_71841__$1 = state_71841;
var ex71845 = (state_71841__$1[(2)]);
var statearr_71849_71860 = state_71841__$1;
(statearr_71849_71860[(5)] = ex71845);


var statearr_71850_71861 = state_71841__$1;
(statearr_71850_71861[(1)] = (4));

(statearr_71850_71861[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71842 === (6))){
var inst_71833 = (state_71841[(2)]);
var inst_71834 = fluree.db.util.async.throw_err.call(null,inst_71833);
var inst_71835 = cljs.core.clj__GT_js.call(null,inst_71834);
var inst_71836 = resolve.call(null,inst_71835);
var _ = (function (){var statearr_71851 = state_71841;
(statearr_71851[(4)] = cljs.core.rest.call(null,(state_71841[(4)])));

return statearr_71851;
})();
var state_71841__$1 = state_71841;
var statearr_71852_71862 = state_71841__$1;
(statearr_71852_71862[(2)] = inst_71836);

(statearr_71852_71862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$query_$_state_machine__2879__auto__ = null;
var flureenjs$query_$_state_machine__2879__auto____0 = (function (){
var statearr_71853 = [null,null,null,null,null,null,null,null];
(statearr_71853[(0)] = flureenjs$query_$_state_machine__2879__auto__);

(statearr_71853[(1)] = (1));

return statearr_71853;
});
var flureenjs$query_$_state_machine__2879__auto____1 = (function (state_71841){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_71841);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e71854){var ex__2882__auto__ = e71854;
var statearr_71855_71863 = state_71841;
(statearr_71855_71863[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_71841[(4)]))){
var statearr_71856_71864 = state_71841;
(statearr_71856_71864[(1)] = cljs.core.first.call(null,(state_71841[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71865 = state_71841;
state_71841 = G__71865;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$query_$_state_machine__2879__auto__ = function(state_71841){
switch(arguments.length){
case 0:
return flureenjs$query_$_state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$query_$_state_machine__2879__auto____1.call(this,state_71841);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$query_$_state_machine__2879__auto____0;
flureenjs$query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$query_$_state_machine__2879__auto____1;
return flureenjs$query_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_71857 = f__2902__auto__.call(null);
(statearr_71857[(6)] = c__2901__auto__);

return statearr_71857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureenjs.query', flureenjs.query);
/**
 * Execute a query against a database source, with the
 *   given flakes applied.
 * 
 *   Returns promise that eventually contains the results or
 *   an exception.
 */
flureenjs.query_with = (function flureenjs$query_with(db,param){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_71915){
var state_val_71916 = (state_71915[(1)]);
if((state_val_71916 === (7))){
var state_71915__$1 = state_71915;
var statearr_71917_71946 = state_71915__$1;
(statearr_71917_71946[(2)] = false);

(statearr_71917_71946[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71916 === (1))){
var state_71915__$1 = state_71915;
var statearr_71918_71947 = state_71915__$1;
(statearr_71918_71947[(2)] = null);

(statearr_71918_71947[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71916 === (4))){
var inst_71866 = (state_71915[(2)]);
var inst_71867 = fluree.db.util.log.error.call(null,inst_71866);
var inst_71868 = cljs.core.clj__GT_js.call(null,inst_71866);
var inst_71869 = reject.call(null,inst_71868);
var state_71915__$1 = (function (){var statearr_71919 = state_71915;
(statearr_71919[(7)] = inst_71867);

return statearr_71919;
})();
var statearr_71920_71948 = state_71915__$1;
(statearr_71920_71948[(2)] = inst_71869);

(statearr_71920_71948[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71916 === (15))){
var inst_71898 = (state_71915[(8)]);
var inst_71900 = (state_71915[(9)]);
var inst_71902 = (state_71915[(2)]);
var inst_71903 = fluree.db.util.async.throw_err.call(null,inst_71902);
var inst_71904 = fluree.db.dbproto._forward_time_travel.call(null,inst_71903,inst_71900);
var inst_71905 = fluree.db.api.query.query.call(null,inst_71904,inst_71898);
var state_71915__$1 = state_71915;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71915__$1,(16),inst_71905);
} else {
if((state_val_71916 === (13))){
var inst_71876 = (state_71915[(10)]);
var state_71915__$1 = state_71915;
var statearr_71921_71949 = state_71915__$1;
(statearr_71921_71949[(2)] = inst_71876);

(statearr_71921_71949[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71916 === (6))){
var inst_71876 = (state_71915[(10)]);
var inst_71881 = inst_71876.cljs$lang$protocol_mask$partition0$;
var inst_71882 = (inst_71881 & (64));
var inst_71883 = inst_71876.cljs$core$ISeq$;
var inst_71884 = (cljs.core.PROTOCOL_SENTINEL === inst_71883);
var inst_71885 = ((inst_71882) || (inst_71884));
var state_71915__$1 = state_71915;
if(cljs.core.truth_(inst_71885)){
var statearr_71922_71950 = state_71915__$1;
(statearr_71922_71950[(1)] = (9));

} else {
var statearr_71923_71951 = state_71915__$1;
(statearr_71923_71951[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71916 === (3))){
var inst_71913 = (state_71915[(2)]);
var state_71915__$1 = state_71915;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71915__$1,inst_71913);
} else {
if((state_val_71916 === (12))){
var inst_71876 = (state_71915[(10)]);
var inst_71894 = cljs.core.apply.call(null,cljs.core.hash_map,inst_71876);
var state_71915__$1 = state_71915;
var statearr_71924_71952 = state_71915__$1;
(statearr_71924_71952[(2)] = inst_71894);

(statearr_71924_71952[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71916 === (2))){
var inst_71876 = (state_71915[(10)]);
var _ = (function (){var statearr_71925 = state_71915;
(statearr_71925[(4)] = cljs.core.cons.call(null,(5),(state_71915[(4)])));

return statearr_71925;
})();
var inst_71876__$1 = cljs.core.js__GT_clj.call(null,param,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_71878 = (inst_71876__$1 == null);
var inst_71879 = cljs.core.not.call(null,inst_71878);
var state_71915__$1 = (function (){var statearr_71926 = state_71915;
(statearr_71926[(10)] = inst_71876__$1);

return statearr_71926;
})();
if(inst_71879){
var statearr_71927_71953 = state_71915__$1;
(statearr_71927_71953[(1)] = (6));

} else {
var statearr_71928_71954 = state_71915__$1;
(statearr_71928_71954[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71916 === (11))){
var inst_71889 = (state_71915[(2)]);
var state_71915__$1 = state_71915;
var statearr_71930_71955 = state_71915__$1;
(statearr_71930_71955[(2)] = inst_71889);

(statearr_71930_71955[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71916 === (9))){
var state_71915__$1 = state_71915;
var statearr_71931_71956 = state_71915__$1;
(statearr_71931_71956[(2)] = true);

(statearr_71931_71956[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71916 === (5))){
var _ = (function (){var statearr_71932 = state_71915;
(statearr_71932[(4)] = cljs.core.rest.call(null,(state_71915[(4)])));

return statearr_71932;
})();
var state_71915__$1 = state_71915;
var ex71929 = (state_71915__$1[(2)]);
var statearr_71933_71957 = state_71915__$1;
(statearr_71933_71957[(5)] = ex71929);


var statearr_71934_71958 = state_71915__$1;
(statearr_71934_71958[(1)] = (4));

(statearr_71934_71958[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71916 === (14))){
var inst_71897 = (state_71915[(2)]);
var inst_71898 = cljs.core.get.call(null,inst_71897,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_71899 = cljs.core.get.call(null,inst_71897,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_71900 = cljs.core.map.call(null,fluree.db.flake.parts__GT_Flake,inst_71899);
var state_71915__$1 = (function (){var statearr_71935 = state_71915;
(statearr_71935[(8)] = inst_71898);

(statearr_71935[(9)] = inst_71900);

return statearr_71935;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71915__$1,(15),db);
} else {
if((state_val_71916 === (16))){
var inst_71907 = (state_71915[(2)]);
var inst_71908 = fluree.db.util.async.throw_err.call(null,inst_71907);
var inst_71909 = cljs.core.clj__GT_js.call(null,inst_71908);
var inst_71910 = resolve.call(null,inst_71909);
var _ = (function (){var statearr_71936 = state_71915;
(statearr_71936[(4)] = cljs.core.rest.call(null,(state_71915[(4)])));

return statearr_71936;
})();
var state_71915__$1 = state_71915;
var statearr_71937_71959 = state_71915__$1;
(statearr_71937_71959[(2)] = inst_71910);

(statearr_71937_71959[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71916 === (10))){
var state_71915__$1 = state_71915;
var statearr_71938_71960 = state_71915__$1;
(statearr_71938_71960[(2)] = false);

(statearr_71938_71960[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71916 === (8))){
var inst_71892 = (state_71915[(2)]);
var state_71915__$1 = state_71915;
if(cljs.core.truth_(inst_71892)){
var statearr_71939_71961 = state_71915__$1;
(statearr_71939_71961[(1)] = (12));

} else {
var statearr_71940_71962 = state_71915__$1;
(statearr_71940_71962[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$query_with_$_state_machine__2879__auto__ = null;
var flureenjs$query_with_$_state_machine__2879__auto____0 = (function (){
var statearr_71941 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_71941[(0)] = flureenjs$query_with_$_state_machine__2879__auto__);

(statearr_71941[(1)] = (1));

return statearr_71941;
});
var flureenjs$query_with_$_state_machine__2879__auto____1 = (function (state_71915){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_71915);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e71942){var ex__2882__auto__ = e71942;
var statearr_71943_71963 = state_71915;
(statearr_71943_71963[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_71915[(4)]))){
var statearr_71944_71964 = state_71915;
(statearr_71944_71964[(1)] = cljs.core.first.call(null,(state_71915[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__71965 = state_71915;
state_71915 = G__71965;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$query_with_$_state_machine__2879__auto__ = function(state_71915){
switch(arguments.length){
case 0:
return flureenjs$query_with_$_state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$query_with_$_state_machine__2879__auto____1.call(this,state_71915);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$query_with_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$query_with_$_state_machine__2879__auto____0;
flureenjs$query_with_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$query_with_$_state_machine__2879__auto____1;
return flureenjs$query_with_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_71945 = f__2902__auto__.call(null);
(statearr_71945[(6)] = c__2901__auto__);

return statearr_71945;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
});
goog.exportSymbol('flureenjs.query_with', flureenjs.query_with);
/**
 * Exceute a sparql query against a specified database
 */
flureenjs.sparql = (function flureenjs$sparql(var_args){
var G__71967 = arguments.length;
switch (G__71967) {
case 2:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.sparql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.sparql', flureenjs.sparql);

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$2 = (function (db,sparql_str){
return flureenjs.sparql.call(null,db,sparql_str,null);
}));

(flureenjs.sparql.cljs$core$IFn$_invoke$arity$3 = (function (db,sparql_str,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_71997){
var state_val_71998 = (state_71997[(1)]);
if((state_val_71998 === (7))){
var state_71997__$1 = state_71997;
var statearr_71999_72020 = state_71997__$1;
(statearr_71999_72020[(2)] = null);

(statearr_71999_72020[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71998 === (1))){
var state_71997__$1 = state_71997;
var statearr_72000_72021 = state_71997__$1;
(statearr_72000_72021[(2)] = null);

(statearr_72000_72021[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71998 === (4))){
var inst_71968 = (state_71997[(2)]);
var inst_71969 = fluree.db.util.log.error.call(null,inst_71968);
var inst_71970 = cljs.core.clj__GT_js.call(null,inst_71968);
var inst_71971 = reject.call(null,inst_71970);
var state_71997__$1 = (function (){var statearr_72001 = state_71997;
(statearr_72001[(7)] = inst_71969);

return statearr_72001;
})();
var statearr_72002_72022 = state_71997__$1;
(statearr_72002_72022[(2)] = inst_71971);

(statearr_72002_72022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71998 === (6))){
var inst_71981 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var state_71997__$1 = state_71997;
var statearr_72003_72023 = state_71997__$1;
(statearr_72003_72023[(2)] = inst_71981);

(statearr_72003_72023[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71998 === (3))){
var inst_71995 = (state_71997[(2)]);
var state_71997__$1 = state_71997;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_71997__$1,inst_71995);
} else {
if((state_val_71998 === (2))){
var inst_71978 = (state_71997[(8)]);
var _ = (function (){var statearr_72005 = state_71997;
(statearr_72005[(4)] = cljs.core.cons.call(null,(5),(state_71997[(4)])));

return statearr_72005;
})();
var inst_71977 = fluree.db.util.json.parse.call(null,sparql_str);
var inst_71978__$1 = fluree.db.query.sparql_parser.sparql_to_ad_hoc.call(null,inst_71977);
var inst_71979 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_71978__$1);
var state_71997__$1 = (function (){var statearr_72006 = state_71997;
(statearr_72006[(8)] = inst_71978__$1);

(statearr_72006[(9)] = inst_71979);

return statearr_72006;
})();
if(cljs.core.truth_(opts)){
var statearr_72007_72024 = state_71997__$1;
(statearr_72007_72024[(1)] = (6));

} else {
var statearr_72008_72025 = state_71997__$1;
(statearr_72008_72025[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71998 === (9))){
var inst_71989 = (state_71997[(2)]);
var inst_71990 = fluree.db.util.async.throw_err.call(null,inst_71989);
var inst_71991 = cljs.core.clj__GT_js.call(null,inst_71990);
var inst_71992 = resolve.call(null,inst_71991);
var _ = (function (){var statearr_72009 = state_71997;
(statearr_72009[(4)] = cljs.core.rest.call(null,(state_71997[(4)])));

return statearr_72009;
})();
var state_71997__$1 = state_71997;
var statearr_72010_72026 = state_71997__$1;
(statearr_72010_72026[(2)] = inst_71992);

(statearr_72010_72026[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71998 === (5))){
var _ = (function (){var statearr_72011 = state_71997;
(statearr_72011[(4)] = cljs.core.rest.call(null,(state_71997[(4)])));

return statearr_72011;
})();
var state_71997__$1 = state_71997;
var ex72004 = (state_71997__$1[(2)]);
var statearr_72012_72027 = state_71997__$1;
(statearr_72012_72027[(5)] = ex72004);


var statearr_72013_72028 = state_71997__$1;
(statearr_72013_72028[(1)] = (4));

(statearr_72013_72028[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_71998 === (8))){
var inst_71978 = (state_71997[(8)]);
var inst_71979 = (state_71997[(9)]);
var inst_71984 = (state_71997[(2)]);
var inst_71985 = cljs.core.merge.call(null,inst_71979,inst_71984);
var inst_71986 = cljs.core.assoc.call(null,inst_71978,new cljs.core.Keyword(null,"opts","opts",155075701),inst_71985);
var inst_71987 = fluree.db.api.query.query_async.call(null,db,inst_71986);
var state_71997__$1 = state_71997;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_71997__$1,(9),inst_71987);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2879__auto__ = null;
var flureenjs$state_machine__2879__auto____0 = (function (){
var statearr_72014 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72014[(0)] = flureenjs$state_machine__2879__auto__);

(statearr_72014[(1)] = (1));

return statearr_72014;
});
var flureenjs$state_machine__2879__auto____1 = (function (state_71997){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_71997);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e72015){var ex__2882__auto__ = e72015;
var statearr_72016_72029 = state_71997;
(statearr_72016_72029[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_71997[(4)]))){
var statearr_72017_72030 = state_71997;
(statearr_72017_72030[(1)] = cljs.core.first.call(null,(state_71997[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72031 = state_71997;
state_71997 = G__72031;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$state_machine__2879__auto__ = function(state_71997){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$state_machine__2879__auto____1.call(this,state_71997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2879__auto____0;
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2879__auto____1;
return flureenjs$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_72018 = f__2902__auto__.call(null);
(statearr_72018[(6)] = c__2901__auto__);

return statearr_72018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureenjs.sparql.cljs$lang$maxFixedArity = 3);

/**
 * Exceute a sql query against a specified database
 */
flureenjs.sql = (function flureenjs$sql(var_args){
var G__72033 = arguments.length;
switch (G__72033) {
case 2:
return flureenjs.sql.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return flureenjs.sql.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});
goog.exportSymbol('flureenjs.sql', flureenjs.sql);

(flureenjs.sql.cljs$core$IFn$_invoke$arity$2 = (function (db,sql_str){
return flureenjs.sql.call(null,db,sql_str,cljs.core.PersistentArrayMap.EMPTY);
}));

(flureenjs.sql.cljs$core$IFn$_invoke$arity$3 = (function (db,sql_str,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_72057){
var state_val_72058 = (state_72057[(1)]);
if((state_val_72058 === (1))){
var state_72057__$1 = state_72057;
var statearr_72059_72075 = state_72057__$1;
(statearr_72059_72075[(2)] = null);

(statearr_72059_72075[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72058 === (2))){
var _ = (function (){var statearr_72060 = state_72057;
(statearr_72060[(4)] = cljs.core.cons.call(null,(5),(state_72057[(4)])));

return statearr_72060;
})();
var inst_72043 = cljs.core.js__GT_clj.call(null,opts,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
var inst_72044 = fluree.db.util.json.parse.call(null,sql_str);
var inst_72045 = fluree.db.query.sql.parse.call(null,inst_72044);
var inst_72046 = cljs.core.update.call(null,inst_72045,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.merge,inst_72043);
var inst_72047 = fluree.db.api.query.query_async.call(null,db,inst_72046);
var state_72057__$1 = state_72057;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_72057__$1,(6),inst_72047);
} else {
if((state_val_72058 === (3))){
var inst_72055 = (state_72057[(2)]);
var state_72057__$1 = state_72057;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_72057__$1,inst_72055);
} else {
if((state_val_72058 === (4))){
var inst_72034 = (state_72057[(2)]);
var inst_72035 = fluree.db.util.log.error.call(null,inst_72034);
var inst_72036 = cljs.core.clj__GT_js.call(null,inst_72034);
var inst_72037 = reject.call(null,inst_72036);
var state_72057__$1 = (function (){var statearr_72062 = state_72057;
(statearr_72062[(7)] = inst_72035);

return statearr_72062;
})();
var statearr_72063_72076 = state_72057__$1;
(statearr_72063_72076[(2)] = inst_72037);

(statearr_72063_72076[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72058 === (5))){
var _ = (function (){var statearr_72064 = state_72057;
(statearr_72064[(4)] = cljs.core.rest.call(null,(state_72057[(4)])));

return statearr_72064;
})();
var state_72057__$1 = state_72057;
var ex72061 = (state_72057__$1[(2)]);
var statearr_72065_72077 = state_72057__$1;
(statearr_72065_72077[(5)] = ex72061);


var statearr_72066_72078 = state_72057__$1;
(statearr_72066_72078[(1)] = (4));

(statearr_72066_72078[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_72058 === (6))){
var inst_72049 = (state_72057[(2)]);
var inst_72050 = fluree.db.util.async.throw_err.call(null,inst_72049);
var inst_72051 = cljs.core.clj__GT_js.call(null,inst_72050);
var inst_72052 = resolve.call(null,inst_72051);
var _ = (function (){var statearr_72067 = state_72057;
(statearr_72067[(4)] = cljs.core.rest.call(null,(state_72057[(4)])));

return statearr_72067;
})();
var state_72057__$1 = state_72057;
var statearr_72068_72079 = state_72057__$1;
(statearr_72068_72079[(2)] = inst_72052);

(statearr_72068_72079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var flureenjs$state_machine__2879__auto__ = null;
var flureenjs$state_machine__2879__auto____0 = (function (){
var statearr_72069 = [null,null,null,null,null,null,null,null];
(statearr_72069[(0)] = flureenjs$state_machine__2879__auto__);

(statearr_72069[(1)] = (1));

return statearr_72069;
});
var flureenjs$state_machine__2879__auto____1 = (function (state_72057){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_72057);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e72070){var ex__2882__auto__ = e72070;
var statearr_72071_72080 = state_72057;
(statearr_72071_72080[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_72057[(4)]))){
var statearr_72072_72081 = state_72057;
(statearr_72072_72081[(1)] = cljs.core.first.call(null,(state_72057[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__72082 = state_72057;
state_72057 = G__72082;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
flureenjs$state_machine__2879__auto__ = function(state_72057){
switch(arguments.length){
case 0:
return flureenjs$state_machine__2879__auto____0.call(this);
case 1:
return flureenjs$state_machine__2879__auto____1.call(this,state_72057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = flureenjs$state_machine__2879__auto____0;
flureenjs$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = flureenjs$state_machine__2879__auto____1;
return flureenjs$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_72073 = f__2902__auto__.call(null);
(statearr_72073[(6)] = c__2901__auto__);

return statearr_72073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(flureenjs.sql.cljs$lang$maxFixedArity = 3);

