// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__64627 = arguments.length;
switch (G__64627) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5733__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5733__auto__)){
var block = temp__5733__auto__;
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2901__auto___64666 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64648){
var state_val_64649 = (state_64648[(1)]);
if((state_val_64649 === (1))){
var state_64648__$1 = state_64648;
var statearr_64650_64667 = state_64648__$1;
(statearr_64650_64667[(2)] = null);

(statearr_64650_64667[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64649 === (2))){
var _ = (function (){var statearr_64651 = state_64648;
(statearr_64651[(4)] = cljs.core.cons((5),(state_64648[(4)])));

return statearr_64651;
})();
var inst_64634 = fluree.db.session.db(conn,ledger,null);
var state_64648__$1 = state_64648;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64648__$1,(7),inst_64634);
} else {
if((state_val_64649 === (3))){
var inst_64644 = (state_64648[(2)]);
var inst_64645 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64644);
var inst_64646 = cljs.core.async.close_BANG_(pc);
var state_64648__$1 = (function (){var statearr_64653 = state_64648;
(statearr_64653[(7)] = inst_64645);

return statearr_64653;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_64648__$1,inst_64646);
} else {
if((state_val_64649 === (4))){
var inst_64628 = (state_64648[(2)]);
var state_64648__$1 = state_64648;
var statearr_64654_64668 = state_64648__$1;
(statearr_64654_64668[(2)] = inst_64628);

(statearr_64654_64668[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64649 === (5))){
var _ = (function (){var statearr_64655 = state_64648;
(statearr_64655[(4)] = cljs.core.rest((state_64648[(4)])));

return statearr_64655;
})();
var state_64648__$1 = state_64648;
var ex64652 = (state_64648__$1[(2)]);
var statearr_64656_64669 = state_64648__$1;
(statearr_64656_64669[(5)] = ex64652);


var statearr_64657_64670 = state_64648__$1;
(statearr_64657_64670[(1)] = (4));

(statearr_64657_64670[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64649 === (6))){
var inst_64640 = (state_64648[(2)]);
var inst_64641 = fluree.db.util.async.throw_err(inst_64640);
var _ = (function (){var statearr_64658 = state_64648;
(statearr_64658[(4)] = cljs.core.rest((state_64648[(4)])));

return statearr_64658;
})();
var state_64648__$1 = state_64648;
var statearr_64659_64671 = state_64648__$1;
(statearr_64659_64671[(2)] = inst_64641);

(statearr_64659_64671[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64649 === (7))){
var inst_64636 = (state_64648[(2)]);
var inst_64637 = fluree.db.util.async.throw_err(inst_64636);
var inst_64638 = fluree.db.time_travel.as_of_block(inst_64637,block);
var state_64648__$1 = state_64648;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64648__$1,(6),inst_64638);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2879__auto__ = null;
var fluree$db$api$ledger$state_machine__2879__auto____0 = (function (){
var statearr_64660 = [null,null,null,null,null,null,null,null];
(statearr_64660[(0)] = fluree$db$api$ledger$state_machine__2879__auto__);

(statearr_64660[(1)] = (1));

return statearr_64660;
});
var fluree$db$api$ledger$state_machine__2879__auto____1 = (function (state_64648){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_64648);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64661){var ex__2882__auto__ = e64661;
var statearr_64662_64672 = state_64648;
(statearr_64662_64672[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_64648[(4)]))){
var statearr_64663_64673 = state_64648;
(statearr_64663_64673[(1)] = cljs.core.first((state_64648[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64674 = state_64648;
state_64648 = G__64674;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2879__auto__ = function(state_64648){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2879__auto____1.call(this,state_64648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2879__auto____0;
fluree$db$api$ledger$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2879__auto____1;
return fluree$db$api$ledger$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64664 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_64664[(6)] = c__2901__auto___64666);

return statearr_64664;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));


return pc;
} else {
return fluree.db.session.db(conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64715){
var state_val_64716 = (state_64715[(1)]);
if((state_val_64716 === (7))){
var inst_64684 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_64715__$1 = state_64715;
if(inst_64684){
var statearr_64717_64748 = state_64715__$1;
(statearr_64717_64748[(1)] = (9));

} else {
var statearr_64718_64749 = state_64715__$1;
(statearr_64718_64749[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64716 === (1))){
var state_64715__$1 = state_64715;
var statearr_64719_64750 = state_64715__$1;
(statearr_64719_64750[(2)] = null);

(statearr_64719_64750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64716 === (4))){
var inst_64675 = (state_64715[(2)]);
var state_64715__$1 = state_64715;
var statearr_64720_64751 = state_64715__$1;
(statearr_64720_64751[(2)] = inst_64675);

(statearr_64720_64751[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64716 === (15))){
var inst_64692 = (state_64715[(7)]);
var inst_64691 = (state_64715[(2)]);
var inst_64692__$1 = fluree.db.util.async.throw_err(inst_64691);
var state_64715__$1 = (function (){var statearr_64721 = state_64715;
(statearr_64721[(7)] = inst_64692__$1);

return statearr_64721;
})();
if(cljs.core.truth_(inst_64692__$1)){
var statearr_64722_64752 = state_64715__$1;
(statearr_64722_64752[(1)] = (16));

} else {
var statearr_64723_64753 = state_64715__$1;
(statearr_64723_64753[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64716 === (13))){
var state_64715__$1 = state_64715;
var statearr_64724_64754 = state_64715__$1;
(statearr_64724_64754[(2)] = null);

(statearr_64724_64754[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64716 === (6))){
var state_64715__$1 = state_64715;
var statearr_64725_64755 = state_64715__$1;
(statearr_64725_64755[(2)] = db);

(statearr_64725_64755[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64716 === (17))){
var inst_64696 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_64697 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64698 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_64699 = cljs.core.PersistentHashMap.fromArrays(inst_64697,inst_64698);
var inst_64700 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64696,inst_64699);
var inst_64701 = (function(){throw inst_64700})();
var state_64715__$1 = state_64715;
var statearr_64726_64756 = state_64715__$1;
(statearr_64726_64756[(2)] = inst_64701);

(statearr_64726_64756[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64716 === (3))){
var inst_64713 = (state_64715[(2)]);
var state_64715__$1 = state_64715;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64715__$1,inst_64713);
} else {
if((state_val_64716 === (12))){
var inst_64689 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_64715__$1 = state_64715;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64715__$1,(15),inst_64689);
} else {
if((state_val_64716 === (2))){
var _ = (function (){var statearr_64727 = state_64715;
(statearr_64727[(4)] = cljs.core.cons((5),(state_64715[(4)])));

return statearr_64727;
})();
var inst_64681 = cljs.core.not(auth);
var state_64715__$1 = state_64715;
if(inst_64681){
var statearr_64728_64757 = state_64715__$1;
(statearr_64728_64757[(1)] = (6));

} else {
var statearr_64729_64758 = state_64715__$1;
(statearr_64729_64758[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64716 === (11))){
var inst_64708 = (state_64715[(2)]);
var state_64715__$1 = state_64715;
var statearr_64731_64759 = state_64715__$1;
(statearr_64731_64759[(2)] = inst_64708);

(statearr_64731_64759[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64716 === (9))){
var inst_64686 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_64715__$1 = state_64715;
var statearr_64732_64760 = state_64715__$1;
(statearr_64732_64760[(2)] = inst_64686);

(statearr_64732_64760[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64716 === (5))){
var _ = (function (){var statearr_64733 = state_64715;
(statearr_64733[(4)] = cljs.core.rest((state_64715[(4)])));

return statearr_64733;
})();
var state_64715__$1 = state_64715;
var ex64730 = (state_64715__$1[(2)]);
var statearr_64734_64761 = state_64715__$1;
(statearr_64734_64761[(5)] = ex64730);


if((ex64730 instanceof Error)){
var statearr_64735_64762 = state_64715__$1;
(statearr_64735_64762[(1)] = (4));

(statearr_64735_64762[(5)] = null);

} else {
throw ex64730;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64716 === (14))){
var inst_64706 = (state_64715[(2)]);
var state_64715__$1 = state_64715;
var statearr_64736_64763 = state_64715__$1;
(statearr_64736_64763[(2)] = inst_64706);

(statearr_64736_64763[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64716 === (16))){
var inst_64692 = (state_64715[(7)]);
var inst_64694 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_64692);
var state_64715__$1 = state_64715;
var statearr_64737_64764 = state_64715__$1;
(statearr_64737_64764[(2)] = inst_64694);

(statearr_64737_64764[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64716 === (10))){
var state_64715__$1 = state_64715;
var statearr_64738_64765 = state_64715__$1;
(statearr_64738_64765[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64716 === (18))){
var inst_64703 = (state_64715[(2)]);
var state_64715__$1 = state_64715;
var statearr_64740_64766 = state_64715__$1;
(statearr_64740_64766[(2)] = inst_64703);

(statearr_64740_64766[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64716 === (8))){
var inst_64710 = (state_64715[(2)]);
var _ = (function (){var statearr_64741 = state_64715;
(statearr_64741[(4)] = cljs.core.rest((state_64715[(4)])));

return statearr_64741;
})();
var state_64715__$1 = state_64715;
var statearr_64742_64767 = state_64715__$1;
(statearr_64742_64767[(2)] = inst_64710);

(statearr_64742_64767[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto____0 = (function (){
var statearr_64743 = [null,null,null,null,null,null,null,null];
(statearr_64743[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto__);

(statearr_64743[(1)] = (1));

return statearr_64743;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto____1 = (function (state_64715){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_64715);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64744){var ex__2882__auto__ = e64744;
var statearr_64745_64768 = state_64715;
(statearr_64745_64768[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_64715[(4)]))){
var statearr_64746_64769 = state_64715;
(statearr_64746_64769[(1)] = cljs.core.first((state_64715[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64770 = state_64715;
state_64715 = G__64770;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto__ = function(state_64715){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto____1.call(this,state_64715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64747 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_64747[(6)] = c__2901__auto__);

return statearr_64747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64834){
var state_val_64835 = (state_64834[(1)]);
if((state_val_64835 === (7))){
var inst_64780 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth);
var state_64834__$1 = state_64834;
if(inst_64780){
var statearr_64836_64885 = state_64834__$1;
(statearr_64836_64885[(1)] = (9));

} else {
var statearr_64837_64886 = state_64834__$1;
(statearr_64837_64886[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (20))){
var inst_64804 = (state_64834[(7)]);
var state_64834__$1 = state_64834;
if(cljs.core.truth_(inst_64804)){
var statearr_64838_64887 = state_64834__$1;
(statearr_64838_64887[(1)] = (22));

} else {
var statearr_64839_64888 = state_64834__$1;
(statearr_64839_64888[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (27))){
var state_64834__$1 = state_64834;
var statearr_64840_64889 = state_64834__$1;
(statearr_64840_64889[(2)] = null);

(statearr_64840_64889[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (1))){
var state_64834__$1 = state_64834;
var statearr_64841_64890 = state_64834__$1;
(statearr_64841_64890[(2)] = null);

(statearr_64841_64890[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (24))){
var inst_64818 = (state_64834[(2)]);
var state_64834__$1 = state_64834;
var statearr_64842_64891 = state_64834__$1;
(statearr_64842_64891[(2)] = inst_64818);

(statearr_64842_64891[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (4))){
var inst_64771 = (state_64834[(2)]);
var state_64834__$1 = state_64834;
var statearr_64843_64892 = state_64834__$1;
(statearr_64843_64892[(2)] = inst_64771);

(statearr_64843_64892[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (15))){
var inst_64787 = (state_64834[(8)]);
var inst_64786 = (state_64834[(2)]);
var inst_64787__$1 = fluree.db.util.async.throw_err(inst_64786);
var state_64834__$1 = (function (){var statearr_64844 = state_64834;
(statearr_64844[(8)] = inst_64787__$1);

return statearr_64844;
})();
if(cljs.core.truth_(inst_64787__$1)){
var statearr_64845_64893 = state_64834__$1;
(statearr_64845_64893[(1)] = (16));

} else {
var statearr_64846_64894 = state_64834__$1;
(statearr_64846_64894[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (21))){
var inst_64820 = (state_64834[(9)]);
var inst_64820__$1 = (state_64834[(2)]);
var state_64834__$1 = (function (){var statearr_64847 = state_64834;
(statearr_64847[(9)] = inst_64820__$1);

return statearr_64847;
})();
if(cljs.core.truth_(inst_64820__$1)){
var statearr_64848_64895 = state_64834__$1;
(statearr_64848_64895[(1)] = (29));

} else {
var statearr_64849_64896 = state_64834__$1;
(statearr_64849_64896[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (31))){
var inst_64820 = (state_64834[(9)]);
var inst_64804 = (state_64834[(7)]);
var inst_64828 = (state_64834[(2)]);
var inst_64829 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_64804,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"roles","roles",143379530),inst_64820,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_64828], 0));
var _ = (function (){var statearr_64850 = state_64834;
(statearr_64850[(4)] = cljs.core.rest((state_64834[(4)])));

return statearr_64850;
})();
var state_64834__$1 = state_64834;
var statearr_64851_64897 = state_64834__$1;
(statearr_64851_64897[(2)] = inst_64829);

(statearr_64851_64897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (32))){
var inst_64824 = (state_64834[(2)]);
var inst_64825 = fluree.db.util.async.throw_err(inst_64824);
var state_64834__$1 = state_64834;
var statearr_64852_64898 = state_64834__$1;
(statearr_64852_64898[(2)] = inst_64825);

(statearr_64852_64898[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (13))){
var state_64834__$1 = state_64834;
var statearr_64853_64899 = state_64834__$1;
(statearr_64853_64899[(2)] = null);

(statearr_64853_64899[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (22))){
var inst_64804 = (state_64834[(7)]);
var inst_64808 = fluree.db.auth.roles(db,inst_64804);
var state_64834__$1 = state_64834;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64834__$1,(25),inst_64808);
} else {
if((state_val_64835 === (29))){
var inst_64820 = (state_64834[(9)]);
var inst_64822 = fluree.db.permissions.permission_map(db,inst_64820,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_64834__$1 = state_64834;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64834__$1,(32),inst_64822);
} else {
if((state_val_64835 === (6))){
var state_64834__$1 = state_64834;
var statearr_64854_64900 = state_64834__$1;
(statearr_64854_64900[(2)] = null);

(statearr_64854_64900[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (28))){
var inst_64816 = (state_64834[(2)]);
var state_64834__$1 = state_64834;
var statearr_64855_64901 = state_64834__$1;
(statearr_64855_64901[(2)] = inst_64816);

(statearr_64855_64901[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (25))){
var inst_64810 = (state_64834[(2)]);
var inst_64811 = fluree.db.util.async.throw_err(inst_64810);
var state_64834__$1 = state_64834;
var statearr_64856_64902 = state_64834__$1;
(statearr_64856_64902[(2)] = inst_64811);

(statearr_64856_64902[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (17))){
var inst_64790 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_64791 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64792 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_64793 = cljs.core.PersistentHashMap.fromArrays(inst_64791,inst_64792);
var inst_64794 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_64790,inst_64793);
var inst_64795 = (function(){throw inst_64794})();
var state_64834__$1 = state_64834;
var statearr_64857_64903 = state_64834__$1;
(statearr_64857_64903[(2)] = inst_64795);

(statearr_64857_64903[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (3))){
var inst_64832 = (state_64834[(2)]);
var state_64834__$1 = state_64834;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64834__$1,inst_64832);
} else {
if((state_val_64835 === (12))){
var inst_64784 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,auth);
var state_64834__$1 = state_64834;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64834__$1,(15),inst_64784);
} else {
if((state_val_64835 === (2))){
var _ = (function (){var statearr_64858 = state_64834;
(statearr_64858[(4)] = cljs.core.cons((5),(state_64834[(4)])));

return statearr_64858;
})();
var inst_64777 = (auth == null);
var state_64834__$1 = state_64834;
if(cljs.core.truth_(inst_64777)){
var statearr_64859_64904 = state_64834__$1;
(statearr_64859_64904[(1)] = (6));

} else {
var statearr_64860_64905 = state_64834__$1;
(statearr_64860_64905[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (23))){
var state_64834__$1 = state_64834;
var statearr_64861_64906 = state_64834__$1;
(statearr_64861_64906[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (19))){
var state_64834__$1 = state_64834;
var statearr_64863_64907 = state_64834__$1;
(statearr_64863_64907[(2)] = roles);

(statearr_64863_64907[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (11))){
var inst_64802 = (state_64834[(2)]);
var state_64834__$1 = state_64834;
var statearr_64865_64908 = state_64834__$1;
(statearr_64865_64908[(2)] = inst_64802);

(statearr_64865_64908[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (9))){
var state_64834__$1 = state_64834;
var statearr_64866_64909 = state_64834__$1;
(statearr_64866_64909[(2)] = (0));

(statearr_64866_64909[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (5))){
var _ = (function (){var statearr_64867 = state_64834;
(statearr_64867[(4)] = cljs.core.rest((state_64834[(4)])));

return statearr_64867;
})();
var state_64834__$1 = state_64834;
var ex64864 = (state_64834__$1[(2)]);
var statearr_64868_64910 = state_64834__$1;
(statearr_64868_64910[(5)] = ex64864);


if((ex64864 instanceof Error)){
var statearr_64869_64911 = state_64834__$1;
(statearr_64869_64911[(1)] = (4));

(statearr_64869_64911[(5)] = null);

} else {
throw ex64864;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (14))){
var inst_64800 = (state_64834[(2)]);
var state_64834__$1 = state_64834;
var statearr_64870_64912 = state_64834__$1;
(statearr_64870_64912[(2)] = inst_64800);

(statearr_64870_64912[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (26))){
var state_64834__$1 = state_64834;
var statearr_64871_64913 = state_64834__$1;
(statearr_64871_64913[(2)] = null);

(statearr_64871_64913[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (16))){
var inst_64787 = (state_64834[(8)]);
var state_64834__$1 = state_64834;
var statearr_64872_64914 = state_64834__$1;
(statearr_64872_64914[(2)] = inst_64787);

(statearr_64872_64914[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (30))){
var state_64834__$1 = state_64834;
var statearr_64873_64915 = state_64834__$1;
(statearr_64873_64915[(2)] = null);

(statearr_64873_64915[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (10))){
var state_64834__$1 = state_64834;
if(cljs.core.truth_(auth)){
var statearr_64874_64916 = state_64834__$1;
(statearr_64874_64916[(1)] = (12));

} else {
var statearr_64875_64917 = state_64834__$1;
(statearr_64875_64917[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (18))){
var inst_64797 = (state_64834[(2)]);
var state_64834__$1 = state_64834;
var statearr_64876_64918 = state_64834__$1;
(statearr_64876_64918[(2)] = inst_64797);

(statearr_64876_64918[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64835 === (8))){
var inst_64804 = (state_64834[(2)]);
var state_64834__$1 = (function (){var statearr_64877 = state_64834;
(statearr_64877[(7)] = inst_64804);

return statearr_64877;
})();
if(cljs.core.truth_(roles)){
var statearr_64878_64919 = state_64834__$1;
(statearr_64878_64919[(1)] = (19));

} else {
var statearr_64879_64920 = state_64834__$1;
(statearr_64879_64920[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto____0 = (function (){
var statearr_64880 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64880[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto__);

(statearr_64880[(1)] = (1));

return statearr_64880;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto____1 = (function (state_64834){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_64834);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64881){var ex__2882__auto__ = e64881;
var statearr_64882_64921 = state_64834;
(statearr_64882_64921[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_64834[(4)]))){
var statearr_64883_64922 = state_64834;
(statearr_64883_64922[(1)] = cljs.core.first((state_64834[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64923 = state_64834;
state_64834 = G__64923;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto__ = function(state_64834){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto____1.call(this,state_64834);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64884 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_64884[(6)] = c__2901__auto__);

return statearr_64884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__64924 = db;
var map__64924__$1 = (((((!((map__64924 == null))))?(((((map__64924.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64924.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__64924):map__64924);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64924__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64924__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64924__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NEW EVENT:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([evt], 0)),cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([data], 0))], 0));

if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener(conn,network,dbid,listen_id);

var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64932){
var state_val_64933 = (state_64932[(1)]);
if((state_val_64933 === (1))){
var inst_64926 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_64927 = fluree.db.session.db(conn,inst_64926,null);
var state_64932__$1 = state_64932;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64932__$1,(2),inst_64927);
} else {
if((state_val_64933 === (2))){
var inst_64929 = (state_64932[(2)]);
var inst_64930 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_64929);
var state_64932__$1 = state_64932;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64932__$1,inst_64930);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____0 = (function (){
var statearr_64934 = [null,null,null,null,null,null,null];
(statearr_64934[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__);

(statearr_64934[(1)] = (1));

return statearr_64934;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____1 = (function (state_64932){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_64932);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64935){var ex__2882__auto__ = e64935;
var statearr_64936_64963 = state_64932;
(statearr_64936_64963[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_64932[(4)]))){
var statearr_64937_64964 = state_64932;
(statearr_64937_64964[(1)] = cljs.core.first((state_64932[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64965 = state_64932;
state_64932 = G__64965;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__ = function(state_64932){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____1.call(this,state_64932);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64938 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_64938[(6)] = c__2901__auto__);

return statearr_64938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener(conn,network,dbid,listen_id,event_fn);

var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64951){
var state_val_64952 = (state_64951[(1)]);
if((state_val_64952 === (1))){
var inst_64939 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_64940 = fluree.db.session.db(conn,inst_64939,null);
var state_64951__$1 = state_64951;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64951__$1,(2),inst_64940);
} else {
if((state_val_64952 === (2))){
var inst_64942 = (state_64951[(7)]);
var inst_64942__$1 = (state_64951[(2)]);
var inst_64943 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_64942__$1);
var inst_64944 = newer_block_QMARK_(inst_64943);
var state_64951__$1 = (function (){var statearr_64953 = state_64951;
(statearr_64953[(7)] = inst_64942__$1);

return statearr_64953;
})();
if(inst_64944){
var statearr_64954_64966 = state_64951__$1;
(statearr_64954_64966[(1)] = (3));

} else {
var statearr_64955_64967 = state_64951__$1;
(statearr_64955_64967[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64952 === (3))){
var inst_64942 = (state_64951[(7)]);
var inst_64946 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_port,inst_64942);
var state_64951__$1 = state_64951;
var statearr_64956_64968 = state_64951__$1;
(statearr_64956_64968[(2)] = inst_64946);

(statearr_64956_64968[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64952 === (4))){
var state_64951__$1 = state_64951;
var statearr_64957_64969 = state_64951__$1;
(statearr_64957_64969[(2)] = null);

(statearr_64957_64969[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64952 === (5))){
var inst_64949 = (state_64951[(2)]);
var state_64951__$1 = state_64951;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64951__$1,inst_64949);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____0 = (function (){
var statearr_64958 = [null,null,null,null,null,null,null,null];
(statearr_64958[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__);

(statearr_64958[(1)] = (1));

return statearr_64958;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____1 = (function (state_64951){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_64951);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64959){var ex__2882__auto__ = e64959;
var statearr_64960_64970 = state_64951;
(statearr_64960_64970[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_64951[(4)]))){
var statearr_64961_64971 = state_64951;
(statearr_64961_64971[(1)] = cljs.core.first((state_64951[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64972 = state_64951;
state_64951 = G__64972;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__ = function(state_64951){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____1.call(this,state_64951);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64962 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_64962[(6)] = c__2901__auto__);

return statearr_64962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_(syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var map__64973 = db;
var map__64973__$1 = (((((!((map__64973 == null))))?(((((map__64973.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__64973.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__64973):map__64973);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64973__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64973__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__64973__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid();
var timeout = ((cljs.core.pos_int_QMARK_(syncTimeout))?(function (){var x__4217__auto__ = syncTimeout;
var y__4218__auto__ = (120000);
return ((x__4217__auto__ < y__4218__auto__) ? x__4217__auto__ : y__4218__auto__);
})():(60000));
var res_port = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,db);
} else {
fluree.db.api.ledger.syncTo_wait(db,syncTo,listen_id,res_port);

var c__2901__auto___65050 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65024){
var state_val_65025 = (state_65024[(1)]);
if((state_val_65025 === (7))){
var inst_64990 = (state_65024[(7)]);
var inst_65001 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_64990,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_65024__$1 = state_65024;
if(inst_65001){
var statearr_65026_65051 = state_65024__$1;
(statearr_65026_65051[(1)] = (9));

} else {
var statearr_65027_65052 = state_65024__$1;
(statearr_65027_65052[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65025 === (1))){
var inst_64975 = (state_65024[(8)]);
var inst_64983 = (state_65024[(9)]);
var inst_64975__$1 = cljs.core.async.timeout(timeout);
var inst_64983__$1 = res_port;
var inst_64984 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64985 = [inst_64975__$1,inst_64983__$1];
var inst_64986 = (new cljs.core.PersistentVector(null,2,(5),inst_64984,inst_64985,null));
var state_65024__$1 = (function (){var statearr_65028 = state_65024;
(statearr_65028[(8)] = inst_64975__$1);

(statearr_65028[(9)] = inst_64983__$1);

return statearr_65028;
})();
return cljs.core.async.ioc_alts_BANG_(state_65024__$1,(2),inst_64986);
} else {
if((state_val_65025 === (4))){
var inst_64983 = (state_65024[(9)]);
var inst_64990 = (state_65024[(7)]);
var inst_64994 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_64990,inst_64983);
var state_65024__$1 = state_65024;
if(inst_64994){
var statearr_65029_65053 = state_65024__$1;
(statearr_65029_65053[(1)] = (6));

} else {
var statearr_65030_65054 = state_65024__$1;
(statearr_65030_65054[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65025 === (13))){
var inst_65009 = (state_65024[(10)]);
var inst_65020 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65009);
var state_65024__$1 = state_65024;
var statearr_65031_65055 = state_65024__$1;
(statearr_65031_65055[(2)] = inst_65020);

(statearr_65031_65055[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65025 === (6))){
var inst_64988 = (state_65024[(11)]);
var inst_64999 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64988,(0),null);
var state_65024__$1 = state_65024;
var statearr_65032_65056 = state_65024__$1;
(statearr_65032_65056[(2)] = inst_64999);

(statearr_65032_65056[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65025 === (3))){
var state_65024__$1 = state_65024;
var statearr_65033_65057 = state_65024__$1;
(statearr_65033_65057[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_65033_65057[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65025 === (12))){
var inst_65013 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_65014 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65015 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_65016 = cljs.core.PersistentHashMap.fromArrays(inst_65014,inst_65015);
var inst_65017 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65013,inst_65016);
var inst_65018 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65017);
var state_65024__$1 = state_65024;
var statearr_65034_65058 = state_65024__$1;
(statearr_65034_65058[(2)] = inst_65018);

(statearr_65034_65058[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65025 === (2))){
var inst_64975 = (state_65024[(8)]);
var inst_64988 = (state_65024[(11)]);
var inst_64990 = (state_65024[(7)]);
var inst_64988__$1 = (state_65024[(2)]);
var inst_64989 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64988__$1,(0),null);
var inst_64990__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64988__$1,(1),null);
var inst_64991 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_64990__$1,inst_64975);
var state_65024__$1 = (function (){var statearr_65035 = state_65024;
(statearr_65035[(11)] = inst_64988__$1);

(statearr_65035[(7)] = inst_64990__$1);

(statearr_65035[(12)] = inst_64989);

return statearr_65035;
})();
if(inst_64991){
var statearr_65036_65059 = state_65024__$1;
(statearr_65036_65059[(1)] = (3));

} else {
var statearr_65037_65060 = state_65024__$1;
(statearr_65037_65060[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65025 === (11))){
var inst_65005 = (state_65024[(2)]);
var state_65024__$1 = state_65024;
var statearr_65038_65061 = state_65024__$1;
(statearr_65038_65061[(2)] = inst_65005);

(statearr_65038_65061[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65025 === (9))){
var inst_64989 = (state_65024[(12)]);
var state_65024__$1 = state_65024;
var statearr_65039_65062 = state_65024__$1;
(statearr_65039_65062[(2)] = inst_64989);

(statearr_65039_65062[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65025 === (5))){
var inst_65009 = (state_65024[(10)]);
var inst_65009__$1 = (state_65024[(2)]);
var inst_65010 = fluree.db.connection.remove_listener(conn,network,dbid,listen_id);
var inst_65011 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_65009__$1);
var state_65024__$1 = (function (){var statearr_65040 = state_65024;
(statearr_65040[(10)] = inst_65009__$1);

(statearr_65040[(13)] = inst_65010);

return statearr_65040;
})();
if(inst_65011){
var statearr_65041_65063 = state_65024__$1;
(statearr_65041_65063[(1)] = (12));

} else {
var statearr_65042_65064 = state_65024__$1;
(statearr_65042_65064[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65025 === (14))){
var inst_65022 = (state_65024[(2)]);
var state_65024__$1 = state_65024;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65024__$1,inst_65022);
} else {
if((state_val_65025 === (10))){
var state_65024__$1 = state_65024;
var statearr_65043_65065 = state_65024__$1;
(statearr_65043_65065[(2)] = null);

(statearr_65043_65065[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65025 === (8))){
var inst_65007 = (state_65024[(2)]);
var state_65024__$1 = state_65024;
var statearr_65044_65066 = state_65024__$1;
(statearr_65044_65066[(2)] = inst_65007);

(statearr_65044_65066[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto____0 = (function (){
var statearr_65045 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65045[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto__);

(statearr_65045[(1)] = (1));

return statearr_65045;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto____1 = (function (state_65024){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_65024);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65046){var ex__2882__auto__ = e65046;
var statearr_65047_65067 = state_65024;
(statearr_65047_65067[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_65024[(4)]))){
var statearr_65048_65068 = state_65024;
(statearr_65048_65068[(1)] = cljs.core.first((state_65024[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65069 = state_65024;
state_65024 = G__65069;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto__ = function(state_65024){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto____1.call(this,state_65024);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65049 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_65049[(6)] = c__2901__auto___65050);

return statearr_65049;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__65071 = arguments.length;
switch (G__65071) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3(conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__65072){
var map__65073 = p__65072;
var map__65073__$1 = (((((!((map__65073 == null))))?(((((map__65073.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65073.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__65073):map__65073);
var opts = map__65073__$1;
var roles = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65073__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65073__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65073__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65073__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65073__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2901__auto___65163 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65125){
var state_val_65126 = (state_65125[(1)]);
if((state_val_65126 === (7))){
var inst_65087 = (state_65125[(7)]);
var inst_65089 = fluree.db.api.ledger.syncTo_db(inst_65087,syncTo,syncTimeout);
var state_65125__$1 = state_65125;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65125__$1,(10),inst_65089);
} else {
if((state_val_65126 === (20))){
var inst_65111 = (state_65125[(8)]);
var state_65125__$1 = state_65125;
var statearr_65127_65164 = state_65125__$1;
(statearr_65127_65164[(2)] = inst_65111);

(statearr_65127_65164[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (1))){
var state_65125__$1 = state_65125;
var statearr_65128_65165 = state_65125__$1;
(statearr_65128_65165[(2)] = null);

(statearr_65128_65165[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (4))){
var inst_65075 = (state_65125[(2)]);
var inst_65076 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65075);
var inst_65077 = cljs.core.async.close_BANG_(pc);
var state_65125__$1 = (function (){var statearr_65129 = state_65125;
(statearr_65129[(9)] = inst_65076);

return statearr_65129;
})();
var statearr_65130_65166 = state_65125__$1;
(statearr_65130_65166[(2)] = inst_65077);

(statearr_65130_65166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (15))){
var inst_65103 = (state_65125[(10)]);
var inst_65105 = fluree.db.api.ledger.add_db_permissions(inst_65103,auth,roles);
var state_65125__$1 = state_65125;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65125__$1,(18),inst_65105);
} else {
if((state_val_65126 === (21))){
var inst_65119 = (state_65125[(2)]);
var inst_65120 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_65119);
var _ = (function (){var statearr_65131 = state_65125;
(statearr_65131[(4)] = cljs.core.rest((state_65125[(4)])));

return statearr_65131;
})();
var state_65125__$1 = state_65125;
var statearr_65132_65167 = state_65125__$1;
(statearr_65132_65167[(2)] = inst_65120);

(statearr_65132_65167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (13))){
var inst_65103 = (state_65125[(2)]);
var state_65125__$1 = (function (){var statearr_65133 = state_65125;
(statearr_65133[(10)] = inst_65103);

return statearr_65133;
})();
if(cljs.core.truth_(roles)){
var statearr_65134_65168 = state_65125__$1;
(statearr_65134_65168[(1)] = (15));

} else {
var statearr_65135_65169 = state_65125__$1;
(statearr_65135_65169[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (22))){
var inst_65115 = (state_65125[(2)]);
var inst_65116 = fluree.db.util.async.throw_err(inst_65115);
var state_65125__$1 = state_65125;
var statearr_65136_65170 = state_65125__$1;
(statearr_65136_65170[(2)] = inst_65116);

(statearr_65136_65170[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (6))){
var inst_65086 = (state_65125[(2)]);
var inst_65087 = fluree.db.util.async.throw_err(inst_65086);
var state_65125__$1 = (function (){var statearr_65137 = state_65125;
(statearr_65137[(7)] = inst_65087);

return statearr_65137;
})();
if(cljs.core.truth_(syncTo)){
var statearr_65138_65171 = state_65125__$1;
(statearr_65138_65171[(1)] = (7));

} else {
var statearr_65139_65172 = state_65125__$1;
(statearr_65139_65172[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (17))){
var inst_65111 = (state_65125[(2)]);
var state_65125__$1 = (function (){var statearr_65140 = state_65125;
(statearr_65140[(8)] = inst_65111);

return statearr_65140;
})();
if(cljs.core.truth_(auth)){
var statearr_65141_65173 = state_65125__$1;
(statearr_65141_65173[(1)] = (19));

} else {
var statearr_65142_65174 = state_65125__$1;
(statearr_65142_65174[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (3))){
var inst_65123 = (state_65125[(2)]);
var state_65125__$1 = state_65125;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65125__$1,inst_65123);
} else {
if((state_val_65126 === (12))){
var inst_65095 = (state_65125[(11)]);
var state_65125__$1 = state_65125;
var statearr_65143_65175 = state_65125__$1;
(statearr_65143_65175[(2)] = inst_65095);

(statearr_65143_65175[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (2))){
var _ = (function (){var statearr_65144 = state_65125;
(statearr_65144[(4)] = cljs.core.cons((5),(state_65125[(4)])));

return statearr_65144;
})();
var inst_65084 = fluree.db.session.db(conn,ledger,null);
var state_65125__$1 = state_65125;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65125__$1,(6),inst_65084);
} else {
if((state_val_65126 === (19))){
var inst_65111 = (state_65125[(8)]);
var inst_65113 = fluree.db.api.ledger.add_db_permissions(inst_65111,auth,roles);
var state_65125__$1 = state_65125;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65125__$1,(22),inst_65113);
} else {
if((state_val_65126 === (11))){
var inst_65095 = (state_65125[(11)]);
var inst_65097 = fluree.db.time_travel.as_of_block(inst_65095,block);
var state_65125__$1 = state_65125;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65125__$1,(14),inst_65097);
} else {
if((state_val_65126 === (9))){
var inst_65095 = (state_65125[(2)]);
var state_65125__$1 = (function (){var statearr_65146 = state_65125;
(statearr_65146[(11)] = inst_65095);

return statearr_65146;
})();
if(cljs.core.truth_(block)){
var statearr_65147_65176 = state_65125__$1;
(statearr_65147_65176[(1)] = (11));

} else {
var statearr_65148_65177 = state_65125__$1;
(statearr_65148_65177[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (5))){
var _ = (function (){var statearr_65149 = state_65125;
(statearr_65149[(4)] = cljs.core.rest((state_65125[(4)])));

return statearr_65149;
})();
var state_65125__$1 = state_65125;
var ex65145 = (state_65125__$1[(2)]);
var statearr_65150_65178 = state_65125__$1;
(statearr_65150_65178[(5)] = ex65145);


var statearr_65151_65179 = state_65125__$1;
(statearr_65151_65179[(1)] = (4));

(statearr_65151_65179[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (14))){
var inst_65099 = (state_65125[(2)]);
var inst_65100 = fluree.db.util.async.throw_err(inst_65099);
var state_65125__$1 = state_65125;
var statearr_65152_65180 = state_65125__$1;
(statearr_65152_65180[(2)] = inst_65100);

(statearr_65152_65180[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (16))){
var inst_65103 = (state_65125[(10)]);
var state_65125__$1 = state_65125;
var statearr_65153_65181 = state_65125__$1;
(statearr_65153_65181[(2)] = inst_65103);

(statearr_65153_65181[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (10))){
var inst_65091 = (state_65125[(2)]);
var inst_65092 = fluree.db.util.async.throw_err(inst_65091);
var state_65125__$1 = state_65125;
var statearr_65154_65182 = state_65125__$1;
(statearr_65154_65182[(2)] = inst_65092);

(statearr_65154_65182[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (18))){
var inst_65107 = (state_65125[(2)]);
var inst_65108 = fluree.db.util.async.throw_err(inst_65107);
var state_65125__$1 = state_65125;
var statearr_65155_65183 = state_65125__$1;
(statearr_65155_65183[(2)] = inst_65108);

(statearr_65155_65183[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65126 === (8))){
var inst_65087 = (state_65125[(7)]);
var state_65125__$1 = state_65125;
var statearr_65156_65184 = state_65125__$1;
(statearr_65156_65184[(2)] = inst_65087);

(statearr_65156_65184[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2879__auto__ = null;
var fluree$db$api$ledger$state_machine__2879__auto____0 = (function (){
var statearr_65157 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65157[(0)] = fluree$db$api$ledger$state_machine__2879__auto__);

(statearr_65157[(1)] = (1));

return statearr_65157;
});
var fluree$db$api$ledger$state_machine__2879__auto____1 = (function (state_65125){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_65125);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65158){var ex__2882__auto__ = e65158;
var statearr_65159_65185 = state_65125;
(statearr_65159_65185[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_65125[(4)]))){
var statearr_65160_65186 = state_65125;
(statearr_65160_65186[(1)] = cljs.core.first((state_65125[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65187 = state_65125;
state_65125 = G__65187;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2879__auto__ = function(state_65125){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2879__auto____1.call(this,state_65125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2879__auto____0;
fluree$db$api$ledger$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2879__auto____1;
return fluree$db$api$ledger$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65161 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_65161[(6)] = c__2901__auto___65163);

return statearr_65161;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

