// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.tools.reader.edn');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28639 = arguments.length;
var i__4737__auto___28640 = (0);
while(true){
if((i__4737__auto___28640 < len__4736__auto___28639)){
args__4742__auto__.push((arguments[i__4737__auto___28640]));

var G__28641 = (i__4737__auto___28640 + (1));
i__4737__auto___28640 = G__28641;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((((e.getMessage() == null))?e.getClass():e.getMessage())),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq28636){
var G__28637 = cljs.core.first(seq28636);
var seq28636__$1 = cljs.core.next(seq28636);
var G__28638 = cljs.core.first(seq28636__$1);
var seq28636__$2 = cljs.core.next(seq28636__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28637,G__28638,seq28636__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e28642){var e = e28642;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e28643){var e = e28643;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e28644){var e = e28644;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e28645){var e = e28645;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e28646){var e = e28646;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28649 = arguments.length;
var i__4737__auto___28650 = (0);
while(true){
if((i__4737__auto___28650 < len__4736__auto___28649)){
args__4742__auto__.push((arguments[i__4737__auto___28650]));

var G__28651 = (i__4737__auto___28650 + (1));
i__4737__auto___28650 = G__28651;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28648){var e = e28648;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq28647){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28647));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28654 = arguments.length;
var i__4737__auto___28655 = (0);
while(true){
if((i__4737__auto___28655 < len__4736__auto___28654)){
args__4742__auto__.push((arguments[i__4737__auto___28655]));

var G__28656 = (i__4737__auto___28655 + (1));
i__4737__auto___28655 = G__28656;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e28653){var e = e28653;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq28652){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28652));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e28657){var e = e28657;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28660 = arguments.length;
var i__4737__auto___28661 = (0);
while(true){
if((i__4737__auto___28661 < len__4736__auto___28660)){
args__4742__auto__.push((arguments[i__4737__auto___28661]));

var G__28662 = (i__4737__auto___28661 + (1));
i__4737__auto___28661 = G__28662;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e28659){var e = e28659;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq28658){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28658));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28665 = arguments.length;
var i__4737__auto___28666 = (0);
while(true){
if((i__4737__auto___28666 < len__4736__auto___28665)){
args__4742__auto__.push((arguments[i__4737__auto___28666]));

var G__28667 = (i__4737__auto___28666 + (1));
i__4737__auto___28666 = G__28667;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e28664){var e = e28664;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq28663){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28663));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e28668){var e = e28668;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e28669){var e = e28669;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28672 = arguments.length;
var i__4737__auto___28673 = (0);
while(true){
if((i__4737__auto___28673 < len__4736__auto___28672)){
args__4742__auto__.push((arguments[i__4737__auto___28673]));

var G__28674 = (i__4737__auto___28673 + (1));
i__4737__auto___28673 = G__28674;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28671){var e = e28671;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq28670){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28670));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28677 = arguments.length;
var i__4737__auto___28678 = (0);
while(true){
if((i__4737__auto___28678 < len__4736__auto___28677)){
args__4742__auto__.push((arguments[i__4737__auto___28678]));

var G__28679 = (i__4737__auto___28678 + (1));
i__4737__auto___28678 = G__28679;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e28676){var e = e28676;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq28675){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28675));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28682 = arguments.length;
var i__4737__auto___28683 = (0);
while(true){
if((i__4737__auto___28683 < len__4736__auto___28682)){
args__4742__auto__.push((arguments[i__4737__auto___28683]));

var G__28684 = (i__4737__auto___28683 + (1));
i__4737__auto___28683 = G__28684;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e28681){var e = e28681;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq28680){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28680));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28687 = arguments.length;
var i__4737__auto___28688 = (0);
while(true){
if((i__4737__auto___28688 < len__4736__auto___28687)){
args__4742__auto__.push((arguments[i__4737__auto___28688]));

var G__28689 = (i__4737__auto___28688 + (1));
i__4737__auto___28688 = G__28689;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e28686){var e = e28686;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq28685){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28685));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28692 = arguments.length;
var i__4737__auto___28693 = (0);
while(true){
if((i__4737__auto___28693 < len__4736__auto___28692)){
args__4742__auto__.push((arguments[i__4737__auto___28693]));

var G__28694 = (i__4737__auto___28693 + (1));
i__4737__auto___28693 = G__28694;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e28691){var e = e28691;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq28690){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28690));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28697 = arguments.length;
var i__4737__auto___28698 = (0);
while(true){
if((i__4737__auto___28698 < len__4736__auto___28697)){
args__4742__auto__.push((arguments[i__4737__auto___28698]));

var G__28699 = (i__4737__auto___28698 + (1));
i__4737__auto___28698 = G__28699;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e28696){var e = e28696;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq28695){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28695));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28702 = arguments.length;
var i__4737__auto___28703 = (0);
while(true){
if((i__4737__auto___28703 < len__4736__auto___28702)){
args__4742__auto__.push((arguments[i__4737__auto___28703]));

var G__28704 = (i__4737__auto___28703 + (1));
i__4737__auto___28703 = G__28704;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e28701){var e = e28701;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq28700){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28700));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__28706 = arguments.length;
switch (G__28706) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_28734){
var state_val_28735 = (state_28734[(1)]);
if((state_val_28735 === (7))){
var inst_28719 = (state_28734[(7)]);
var inst_28722 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28719,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_28734__$1 = state_28734;
var statearr_28736_28822 = state_28734__$1;
(statearr_28736_28822[(2)] = inst_28722);

(statearr_28736_28822[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28735 === (1))){
var state_28734__$1 = state_28734;
var statearr_28737_28823 = state_28734__$1;
(statearr_28737_28823[(2)] = null);

(statearr_28737_28823[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28735 === (4))){
var inst_28707 = (state_28734[(2)]);
var state_28734__$1 = state_28734;
var statearr_28738_28824 = state_28734__$1;
(statearr_28738_28824[(2)] = inst_28707);

(statearr_28738_28824[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28735 === (6))){
var inst_28719 = (state_28734[(7)]);
var inst_28719__$1 = (state_28734[(2)]);
var inst_28720 = fluree.db.util.core.exception_QMARK_(inst_28719__$1);
var state_28734__$1 = (function (){var statearr_28739 = state_28734;
(statearr_28739[(7)] = inst_28719__$1);

return statearr_28739;
})();
if(inst_28720){
var statearr_28740_28825 = state_28734__$1;
(statearr_28740_28825[(1)] = (7));

} else {
var statearr_28741_28826 = state_28734__$1;
(statearr_28741_28826[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28735 === (3))){
var inst_28732 = (state_28734[(2)]);
var state_28734__$1 = state_28734;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28734__$1,inst_28732);
} else {
if((state_val_28735 === (2))){
var inst_28713 = (state_28734[(8)]);
var _ = (function (){var statearr_28743 = state_28734;
(statearr_28743[(4)] = cljs.core.cons((5),(state_28734[(4)])));

return statearr_28743;
})();
var inst_28713__$1 = cljs.core.volatile_BANG_((0));
var inst_28714 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_28715 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_28714,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_28713__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),(100000)], 0));
var inst_28716 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_28715);
var inst_28717 = fluree.db.query.fql.query(db,inst_28716);
var state_28734__$1 = (function (){var statearr_28744 = state_28734;
(statearr_28744[(8)] = inst_28713__$1);

return statearr_28744;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28734__$1,(6),inst_28717);
} else {
if((state_val_28735 === (9))){
var inst_28729 = (state_28734[(2)]);
var _ = (function (){var statearr_28745 = state_28734;
(statearr_28745[(4)] = cljs.core.rest((state_28734[(4)])));

return statearr_28745;
})();
var state_28734__$1 = state_28734;
var statearr_28746_28827 = state_28734__$1;
(statearr_28746_28827[(2)] = inst_28729);

(statearr_28746_28827[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28735 === (5))){
var _ = (function (){var statearr_28747 = state_28734;
(statearr_28747[(4)] = cljs.core.rest((state_28734[(4)])));

return statearr_28747;
})();
var state_28734__$1 = state_28734;
var ex28742 = (state_28734__$1[(2)]);
var statearr_28748_28828 = state_28734__$1;
(statearr_28748_28828[(5)] = ex28742);


if((ex28742 instanceof Error)){
var statearr_28749_28829 = state_28734__$1;
(statearr_28749_28829[(1)] = (4));

(statearr_28749_28829[(5)] = null);

} else {
throw ex28742;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28735 === (8))){
var inst_28713 = (state_28734[(8)]);
var inst_28719 = (state_28734[(7)]);
var inst_28724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28725 = cljs.core.deref(inst_28713);
var inst_28726 = [inst_28719,inst_28725];
var inst_28727 = (new cljs.core.PersistentVector(null,2,(5),inst_28724,inst_28726,null));
var state_28734__$1 = state_28734;
var statearr_28750_28830 = state_28734__$1;
(statearr_28750_28830[(2)] = inst_28727);

(statearr_28750_28830[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2879__auto____0 = (function (){
var statearr_28751 = [null,null,null,null,null,null,null,null,null];
(statearr_28751[(0)] = fluree$db$dbfunctions$internal$state_machine__2879__auto__);

(statearr_28751[(1)] = (1));

return statearr_28751;
});
var fluree$db$dbfunctions$internal$state_machine__2879__auto____1 = (function (state_28734){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_28734);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e28752){var ex__2882__auto__ = e28752;
var statearr_28753_28831 = state_28734;
(statearr_28753_28831[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_28734[(4)]))){
var statearr_28754_28832 = state_28734;
(statearr_28754_28832[(1)] = cljs.core.first((state_28734[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28833 = state_28734;
state_28734 = G__28833;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2879__auto__ = function(state_28734){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2879__auto____1.call(this,state_28734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_28755 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_28755[(6)] = c__2901__auto__);

return statearr_28755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_28800){
var state_val_28801 = (state_28800[(1)]);
if((state_val_28801 === (7))){
var inst_28786 = (state_28800[(2)]);
var inst_28787 = fluree.db.query.fql.query(db,inst_28786);
var state_28800__$1 = state_28800;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28800__$1,(8),inst_28787);
} else {
if((state_val_28801 === (1))){
var inst_28756 = typeof select === 'string';
var state_28800__$1 = state_28800;
if(cljs.core.truth_(inst_28756)){
var statearr_28802_28834 = state_28800__$1;
(statearr_28802_28834[(1)] = (2));

} else {
var statearr_28803_28835 = state_28800__$1;
(statearr_28803_28835[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28801 === (4))){
var inst_28762 = (state_28800[(7)]);
var inst_28769 = (state_28800[(8)]);
var inst_28761 = (state_28800[(2)]);
var inst_28762__$1 = cljs.core.volatile_BANG_((0));
var inst_28763 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_28764 = [new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012)];
var inst_28765 = [inst_28762__$1,(100000)];
var inst_28766 = cljs.core.PersistentHashMap.fromArrays(inst_28764,inst_28765);
var inst_28767 = [inst_28761,from,where,block,limit,inst_28766];
var inst_28768 = cljs.core.PersistentHashMap.fromArrays(inst_28763,inst_28767);
var inst_28769__$1 = fluree.db.util.core.without_nils(inst_28768);
var inst_28770 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28769__$1);
var inst_28771 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28769__$1);
var inst_28772 = cljs.core.first(inst_28771);
var inst_28773 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28772], 0));
var inst_28774 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_28773);
var inst_28775 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28769__$1);
var inst_28776 = cljs.core.last(inst_28775);
var inst_28777 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28776], 0));
var inst_28778 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_28777);
var inst_28779 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_28770,inst_28774,inst_28778], 0));
var state_28800__$1 = (function (){var statearr_28804 = state_28800;
(statearr_28804[(7)] = inst_28762__$1);

(statearr_28804[(8)] = inst_28769__$1);

return statearr_28804;
})();
if(cljs.core.truth_(inst_28779)){
var statearr_28805_28836 = state_28800__$1;
(statearr_28805_28836[(1)] = (5));

} else {
var statearr_28806_28837 = state_28800__$1;
(statearr_28806_28837[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28801 === (6))){
var inst_28769 = (state_28800[(8)]);
var state_28800__$1 = state_28800;
var statearr_28807_28838 = state_28800__$1;
(statearr_28807_28838[(2)] = inst_28769);

(statearr_28807_28838[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28801 === (3))){
var state_28800__$1 = state_28800;
var statearr_28808_28839 = state_28800__$1;
(statearr_28808_28839[(2)] = select);

(statearr_28808_28839[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28801 === (2))){
var inst_28758 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_28800__$1 = state_28800;
var statearr_28809_28840 = state_28800__$1;
(statearr_28809_28840[(2)] = inst_28758);

(statearr_28809_28840[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28801 === (11))){
var inst_28798 = (state_28800[(2)]);
var state_28800__$1 = state_28800;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28800__$1,inst_28798);
} else {
if((state_val_28801 === (9))){
var inst_28789 = (state_28800[(9)]);
var state_28800__$1 = state_28800;
var statearr_28810_28841 = state_28800__$1;
(statearr_28810_28841[(2)] = inst_28789);

(statearr_28810_28841[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28801 === (5))){
var inst_28769 = (state_28800[(8)]);
var inst_28781 = new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(inst_28769);
var inst_28782 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_28781);
var inst_28783 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28769,new cljs.core.Keyword(null,"where","where",-2044795965),inst_28782);
var state_28800__$1 = state_28800;
var statearr_28811_28842 = state_28800__$1;
(statearr_28811_28842[(2)] = inst_28783);

(statearr_28811_28842[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28801 === (10))){
var inst_28762 = (state_28800[(7)]);
var inst_28789 = (state_28800[(9)]);
var inst_28793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28794 = cljs.core.deref(inst_28762);
var inst_28795 = [inst_28789,inst_28794];
var inst_28796 = (new cljs.core.PersistentVector(null,2,(5),inst_28793,inst_28795,null));
var state_28800__$1 = state_28800;
var statearr_28812_28843 = state_28800__$1;
(statearr_28812_28843[(2)] = inst_28796);

(statearr_28812_28843[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28801 === (8))){
var inst_28789 = (state_28800[(9)]);
var inst_28789__$1 = (state_28800[(2)]);
var inst_28790 = fluree.db.util.core.exception_QMARK_(inst_28789__$1);
var state_28800__$1 = (function (){var statearr_28813 = state_28800;
(statearr_28813[(9)] = inst_28789__$1);

return statearr_28813;
})();
if(inst_28790){
var statearr_28814_28844 = state_28800__$1;
(statearr_28814_28844[(1)] = (9));

} else {
var statearr_28815_28845 = state_28800__$1;
(statearr_28815_28845[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2879__auto____0 = (function (){
var statearr_28816 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28816[(0)] = fluree$db$dbfunctions$internal$state_machine__2879__auto__);

(statearr_28816[(1)] = (1));

return statearr_28816;
});
var fluree$db$dbfunctions$internal$state_machine__2879__auto____1 = (function (state_28800){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_28800);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e28817){var ex__2882__auto__ = e28817;
var statearr_28818_28846 = state_28800;
(statearr_28818_28846[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_28800[(4)]))){
var statearr_28819_28847 = state_28800;
(statearr_28819_28847[(1)] = cljs.core.first((state_28800[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28848 = state_28800;
state_28800 = G__28848;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2879__auto__ = function(state_28800){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2879__auto____1.call(this,state_28800);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_28820 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_28820[(6)] = c__2901__auto__);

return statearr_28820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__28852 = path;
var vec__28853 = G__28852;
var seq__28854 = cljs.core.seq(vec__28853);
var first__28855 = cljs.core.first(seq__28854);
var seq__28854__$1 = cljs.core.next(seq__28854);
var var$ = first__28855;
var r = seq__28854__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__28852__$1 = G__28852;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__28859 = G__28852__$1;
var seq__28860 = cljs.core.seq(vec__28859);
var first__28861 = cljs.core.first(seq__28860);
var seq__28860__$1 = cljs.core.next(seq__28860);
var var$__$1 = first__28861;
var r__$1 = seq__28860__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__28862 = r__$1;
var G__28863 = n__$2;
var G__28864 = next_clauses;
G__28852__$1 = G__28862;
n__$1 = G__28863;
where_clauses__$1 = G__28864;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__28865 = r__$1;
var G__28866 = next_n;
var G__28867 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__28852__$1 = G__28865;
n__$1 = G__28866;
where_clauses__$1 = G__28867;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_28904){
var state_val_28905 = (state_28904[(1)]);
if((state_val_28905 === (7))){
var inst_28877 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28878 = [path];
var inst_28879 = (new cljs.core.PersistentVector(null,1,(5),inst_28877,inst_28878,null));
var state_28904__$1 = state_28904;
var statearr_28906_28934 = state_28904__$1;
(statearr_28906_28934[(2)] = inst_28879);

(statearr_28906_28934[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28905 === (1))){
var state_28904__$1 = state_28904;
var statearr_28907_28935 = state_28904__$1;
(statearr_28907_28935[(2)] = null);

(statearr_28907_28935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28905 === (4))){
var inst_28868 = (state_28904[(2)]);
var state_28904__$1 = state_28904;
var statearr_28908_28936 = state_28904__$1;
(statearr_28908_28936[(2)] = inst_28868);

(statearr_28908_28936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28905 === (13))){
var inst_28895 = (state_28904[(2)]);
var inst_28896 = fluree.db.util.async.throw_err(inst_28895);
var _ = (function (){var statearr_28909 = state_28904;
(statearr_28909[(4)] = cljs.core.rest((state_28904[(4)])));

return statearr_28909;
})();
var state_28904__$1 = state_28904;
var statearr_28910_28937 = state_28904__$1;
(statearr_28910_28937[(2)] = inst_28896);

(statearr_28910_28937[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28905 === (6))){
var state_28904__$1 = state_28904;
var statearr_28912_28938 = state_28904__$1;
(statearr_28912_28938[(2)] = path);

(statearr_28912_28938[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28905 === (3))){
var inst_28902 = (state_28904[(2)]);
var state_28904__$1 = state_28904;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28904__$1,inst_28902);
} else {
if((state_val_28905 === (12))){
var _ = (function (){var statearr_28913 = state_28904;
(statearr_28913[(4)] = cljs.core.rest((state_28904[(4)])));

return statearr_28913;
})();
var state_28904__$1 = state_28904;
var ex28911 = (state_28904__$1[(2)]);
var statearr_28914_28939 = state_28904__$1;
(statearr_28914_28939[(5)] = ex28911);


var statearr_28915_28940 = state_28904__$1;
(statearr_28915_28940[(1)] = (11));

(statearr_28915_28940[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28905 === (2))){
var _ = (function (){var statearr_28916 = state_28904;
(statearr_28916[(4)] = cljs.core.cons((5),(state_28904[(4)])));

return statearr_28916;
})();
var inst_28874 = cljs.core.vector_QMARK_(path);
var state_28904__$1 = state_28904;
if(inst_28874){
var statearr_28917_28941 = state_28904__$1;
(statearr_28917_28941[(1)] = (6));

} else {
var statearr_28918_28942 = state_28904__$1;
(statearr_28918_28942[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28905 === (11))){
var inst_28881 = (state_28904[(7)]);
var inst_28886 = (state_28904[(2)]);
var inst_28887 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_28886,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_28881,endSubject], 0));
var state_28904__$1 = state_28904;
var statearr_28920_28943 = state_28904__$1;
(statearr_28920_28943[(2)] = inst_28887);

(statearr_28920_28943[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28905 === (9))){
var inst_28885 = (state_28904[(8)]);
var _ = (function (){var statearr_28921 = state_28904;
(statearr_28921[(4)] = cljs.core.cons((12),(state_28904[(4)])));

return statearr_28921;
})();
var inst_28893 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_28885);
var state_28904__$1 = state_28904;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28904__$1,(13),inst_28893);
} else {
if((state_val_28905 === (5))){
var _ = (function (){var statearr_28922 = state_28904;
(statearr_28922[(4)] = cljs.core.rest((state_28904[(4)])));

return statearr_28922;
})();
var state_28904__$1 = state_28904;
var ex28919 = (state_28904__$1[(2)]);
var statearr_28923_28944 = state_28904__$1;
(statearr_28923_28944[(5)] = ex28919);


if((ex28919 instanceof Error)){
var statearr_28924_28945 = state_28904__$1;
(statearr_28924_28945[(1)] = (4));

(statearr_28924_28945[(5)] = null);

} else {
throw ex28919;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28905 === (10))){
var inst_28899 = (state_28904[(2)]);
var _ = (function (){var statearr_28925 = state_28904;
(statearr_28925[(4)] = cljs.core.rest((state_28904[(4)])));

return statearr_28925;
})();
var state_28904__$1 = state_28904;
var statearr_28926_28946 = state_28904__$1;
(statearr_28926_28946[(2)] = inst_28899);

(statearr_28926_28946[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28905 === (8))){
var inst_28881 = (state_28904[(7)]);
var inst_28881__$1 = (state_28904[(2)]);
var inst_28882 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_28881__$1,endSubject);
var inst_28883 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_28884 = ["?var1",inst_28882];
var inst_28885 = cljs.core.PersistentHashMap.fromArrays(inst_28883,inst_28884);
var state_28904__$1 = (function (){var statearr_28927 = state_28904;
(statearr_28927[(8)] = inst_28885);

(statearr_28927[(7)] = inst_28881__$1);

return statearr_28927;
})();
var statearr_28928_28947 = state_28904__$1;
(statearr_28928_28947[(2)] = null);

(statearr_28928_28947[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto____0 = (function (){
var statearr_28929 = [null,null,null,null,null,null,null,null,null];
(statearr_28929[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto__);

(statearr_28929[(1)] = (1));

return statearr_28929;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto____1 = (function (state_28904){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_28904);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e28930){var ex__2882__auto__ = e28930;
var statearr_28931_28948 = state_28904;
(statearr_28931_28948[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_28904[(4)]))){
var statearr_28932_28949 = state_28904;
(statearr_28932_28949[(1)] = cljs.core.first((state_28904[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28950 = state_28904;
state_28904 = G__28950;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto__ = function(state_28904){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto____1.call(this,state_28904);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_28933 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_28933[(6)] = c__2901__auto__);

return statearr_28933;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e28951){var e = e28951;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e28952){var e = e28952;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e28953){var e = e28953;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e28954){var e = e28954;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28957 = arguments.length;
var i__4737__auto___28958 = (0);
while(true){
if((i__4737__auto___28958 < len__4736__auto___28957)){
args__4742__auto__.push((arguments[i__4737__auto___28958]));

var G__28959 = (i__4737__auto___28958 + (1));
i__4737__auto___28958 = G__28959;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e28956){var e = e28956;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq28955){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28955));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28962 = arguments.length;
var i__4737__auto___28963 = (0);
while(true){
if((i__4737__auto___28963 < len__4736__auto___28962)){
args__4742__auto__.push((arguments[i__4737__auto___28963]));

var G__28964 = (i__4737__auto___28963 + (1));
i__4737__auto___28963 = G__28964;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e28961){var e = e28961;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq28960){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28960));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28967 = arguments.length;
var i__4737__auto___28968 = (0);
while(true){
if((i__4737__auto___28968 < len__4736__auto___28967)){
args__4742__auto__.push((arguments[i__4737__auto___28968]));

var G__28969 = (i__4737__auto___28968 + (1));
i__4737__auto___28968 = G__28969;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4126__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e28966){var e = e28966;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq28965){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28965));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___28972 = arguments.length;
var i__4737__auto___28973 = (0);
while(true){
if((i__4737__auto___28973 < len__4736__auto___28972)){
args__4742__auto__.push((arguments[i__4737__auto___28973]));

var G__28974 = (i__4737__auto___28973 + (1));
i__4737__auto___28973 = G__28974;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-fn","db/invalid-fn",-107800799)], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e28971){var e = e28971;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq28970){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28970));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e28975){var e = e28975;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e28976){var e = e28976;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e28977){var e = e28977;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e28978){var e = e28978;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e28979){var e = e28979;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__28985 = path;
var vec__28986 = G__28985;
var seq__28987 = cljs.core.seq(vec__28986);
var first__28988 = cljs.core.first(seq__28987);
var seq__28987__$1 = cljs.core.next(seq__28987);
var pred = first__28988;
var r = seq__28987__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__28985__$1 = G__28985;
var subjects__$1 = subjects;
while(true){
var vec__28992 = G__28985__$1;
var seq__28993 = cljs.core.seq(vec__28992);
var first__28994 = cljs.core.first(seq__28993);
var seq__28993__$1 = cljs.core.next(seq__28993);
var pred__$1 = first__28994;
var r__$1 = seq__28993__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__28985__$1,subjects__$1,vec__28992,seq__28993,first__28994,seq__28993__$1,pred__$1,r__$1,subjects__$2,G__28985,vec__28986,seq__28987,first__28988,seq__28987__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__28985__$1,subjects__$1,vec__28992,seq__28993,first__28994,seq__28993__$1,pred__$1,r__$1,subjects__$2,G__28985,vec__28986,seq__28987,first__28988,seq__28987__$1,pred,r,subjects){
return (function (p1__28980_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__28980_SHARP_,pred__$1);
});})(G__28985__$1,subjects__$1,vec__28992,seq__28993,first__28994,seq__28993__$1,pred__$1,r__$1,subjects__$2,G__28985,vec__28986,seq__28987,first__28988,seq__28987__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__28985__$1,subjects__$1,vec__28992,seq__28993,first__28994,seq__28993__$1,pred__$1,r__$1,subjects__$2,G__28985,vec__28986,seq__28987,first__28988,seq__28987__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4115__auto__ = r__$1;
if(and__4115__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4115__auto__;
}
})())){
var G__28995 = r__$1;
var G__28996 = next_subjects;
G__28985__$1 = G__28995;
subjects__$1 = G__28996;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e28981){var e = e28981;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e28997){var e = e28997;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e28998){var e = e28998;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4742__auto__ = [];
var len__4736__auto___29001 = arguments.length;
var i__4737__auto___29002 = (0);
while(true){
if((i__4737__auto___29002 < len__4736__auto___29001)){
args__4742__auto__.push((arguments[i__4737__auto___29002]));

var G__29003 = (i__4737__auto___29002 + (1));
i__4737__auto___29002 = G__29003;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e29000){var e = e29000;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq28999){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28999));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e29004){var e = e29004;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___29007 = arguments.length;
var i__4737__auto___29008 = (0);
while(true){
if((i__4737__auto___29008 < len__4736__auto___29007)){
args__4742__auto__.push((arguments[i__4737__auto___29008]));

var G__29009 = (i__4737__auto___29008 + (1));
i__4737__auto___29008 = G__29009;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e29006){var e = e29006;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq29005){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq29005));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e29010){var e = e29010;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_29065){
var state_val_29066 = (state_29065[(1)]);
if((state_val_29066 === (7))){
var inst_29012 = (state_29065[(2)]);
var state_29065__$1 = state_29065;
var statearr_29067_29100 = state_29065__$1;
(statearr_29067_29100[(2)] = inst_29012);

(statearr_29067_29100[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29066 === (1))){
var state_29065__$1 = state_29065;
var statearr_29068_29101 = state_29065__$1;
(statearr_29068_29101[(2)] = null);

(statearr_29068_29101[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29066 === (4))){
var inst_29011 = (state_29065[(2)]);
var state_29065__$1 = (function (){var statearr_29069 = state_29065;
(statearr_29069[(7)] = inst_29011);

return statearr_29069;
})();
var statearr_29070_29102 = state_29065__$1;
(statearr_29070_29102[(2)] = null);

(statearr_29070_29102[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29066 === (15))){
var inst_29049 = (state_29065[(8)]);
var inst_29053 = inst_29049.o;
var state_29065__$1 = state_29065;
var statearr_29071_29103 = state_29065__$1;
(statearr_29071_29103[(2)] = inst_29053);

(statearr_29071_29103[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29066 === (13))){
var inst_29049 = (state_29065[(8)]);
var inst_29045 = (state_29065[(2)]);
var inst_29046 = fluree.db.util.async.throw_err(inst_29045);
var inst_29047 = fluree.db.dbfunctions.internal.count(inst_29046);
var inst_29049__$1 = cljs.core.first(inst_29046);
var inst_29050 = (inst_29049__$1 == null);
var state_29065__$1 = (function (){var statearr_29072 = state_29065;
(statearr_29072[(8)] = inst_29049__$1);

(statearr_29072[(9)] = inst_29047);

return statearr_29072;
})();
if(cljs.core.truth_(inst_29050)){
var statearr_29073_29104 = state_29065__$1;
(statearr_29073_29104[(1)] = (14));

} else {
var statearr_29074_29105 = state_29065__$1;
(statearr_29074_29105[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29066 === (6))){
var inst_29021 = (state_29065[(2)]);
var state_29065__$1 = state_29065;
var statearr_29075_29106 = state_29065__$1;
(statearr_29075_29106[(2)] = inst_29021);

(statearr_29075_29106[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29066 === (3))){
var inst_29063 = (state_29065[(2)]);
var state_29065__$1 = state_29065;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29065__$1,inst_29063);
} else {
if((state_val_29066 === (12))){
var inst_29060 = (state_29065[(2)]);
var _ = (function (){var statearr_29076 = state_29065;
(statearr_29076[(4)] = cljs.core.rest((state_29065[(4)])));

return statearr_29076;
})();
var state_29065__$1 = state_29065;
var statearr_29077_29107 = state_29065__$1;
(statearr_29077_29107[(2)] = inst_29060);

(statearr_29077_29107[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29066 === (2))){
var _ = (function (){var statearr_29079 = state_29065;
(statearr_29079[(4)] = cljs.core.cons((9),(state_29065[(4)])));

return statearr_29079;
})();
var inst_29027 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29028 = typeof inst_29027 === 'string';
var state_29065__$1 = state_29065;
if(cljs.core.truth_(inst_29028)){
var statearr_29080_29108 = state_29065__$1;
(statearr_29080_29108[(1)] = (10));

} else {
var statearr_29081_29109 = state_29065__$1;
(statearr_29081_29109[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29066 === (11))){
var inst_29034 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29035 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_29034);
var inst_29036 = fluree.db.dbfunctions.internal.inc(inst_29035);
var inst_29037 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_29034,new cljs.core.Keyword(null,"t","t",-1397832519),inst_29036);
var inst_29038 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29039 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29040 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29041 = [inst_29039,inst_29040];
var inst_29042 = (new cljs.core.PersistentVector(null,2,(5),inst_29038,inst_29041,null));
var inst_29043 = fluree.db.dbproto._search(inst_29037,inst_29042);
var state_29065__$1 = state_29065;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29065__$1,(13),inst_29043);
} else {
if((state_val_29066 === (9))){
var _ = (function (){var statearr_29082 = state_29065;
(statearr_29082[(4)] = cljs.core.rest((state_29065[(4)])));

return statearr_29082;
})();
var state_29065__$1 = state_29065;
var ex29078 = (state_29065__$1[(2)]);
var statearr_29083_29110 = state_29065__$1;
(statearr_29083_29110[(5)] = ex29078);


var statearr_29084_29111 = state_29065__$1;
(statearr_29084_29111[(1)] = (4));

(statearr_29084_29111[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29066 === (5))){
var inst_29011 = (state_29065[(7)]);
var _ = (function (){var statearr_29085 = state_29065;
(statearr_29085[(4)] = cljs.core.cons((8),(state_29065[(4)])));

return statearr_29085;
})();
var inst_29018 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29011,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_29086 = state_29065;
(statearr_29086[(4)] = cljs.core.rest((state_29065[(4)])));

return statearr_29086;
})();
var state_29065__$1 = state_29065;
var statearr_29087_29112 = state_29065__$1;
(statearr_29087_29112[(2)] = inst_29018);

(statearr_29087_29112[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29066 === (14))){
var state_29065__$1 = state_29065;
var statearr_29088_29113 = state_29065__$1;
(statearr_29088_29113[(2)] = null);

(statearr_29088_29113[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29066 === (16))){
var inst_29047 = (state_29065[(9)]);
var inst_29055 = (state_29065[(2)]);
var inst_29056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29057 = [inst_29055,inst_29047];
var inst_29058 = (new cljs.core.PersistentVector(null,2,(5),inst_29056,inst_29057,null));
var state_29065__$1 = state_29065;
var statearr_29090_29114 = state_29065__$1;
(statearr_29090_29114[(2)] = inst_29058);

(statearr_29090_29114[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29066 === (10))){
var inst_29030 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29031 = [null,(0)];
var inst_29032 = (new cljs.core.PersistentVector(null,2,(5),inst_29030,inst_29031,null));
var state_29065__$1 = state_29065;
var statearr_29091_29115 = state_29065__$1;
(statearr_29091_29115[(2)] = inst_29032);

(statearr_29091_29115[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29066 === (8))){
var _ = (function (){var statearr_29092 = state_29065;
(statearr_29092[(4)] = cljs.core.rest((state_29065[(4)])));

return statearr_29092;
})();
var state_29065__$1 = state_29065;
var ex29089 = (state_29065__$1[(2)]);
var statearr_29093_29116 = state_29065__$1;
(statearr_29093_29116[(5)] = ex29089);


var statearr_29094_29117 = state_29065__$1;
(statearr_29094_29117[(1)] = (7));

(statearr_29094_29117[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto____0 = (function (){
var statearr_29095 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29095[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto__);

(statearr_29095[(1)] = (1));

return statearr_29095;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto____1 = (function (state_29065){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_29065);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e29096){var ex__2882__auto__ = e29096;
var statearr_29097_29118 = state_29065;
(statearr_29097_29118[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_29065[(4)]))){
var statearr_29098_29119 = state_29065;
(statearr_29098_29119[(1)] = cljs.core.first((state_29065[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29120 = state_29065;
state_29065 = G__29120;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto__ = function(state_29065){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto____1.call(this,state_29065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_29099 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_29099[(6)] = c__2901__auto__);

return statearr_29099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_29172){
var state_val_29173 = (state_29172[(1)]);
if((state_val_29173 === (7))){
var inst_29122 = (state_29172[(2)]);
var state_29172__$1 = state_29172;
var statearr_29174_29203 = state_29172__$1;
(statearr_29174_29203[(2)] = inst_29122);

(statearr_29174_29203[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (1))){
var state_29172__$1 = state_29172;
var statearr_29175_29204 = state_29172__$1;
(statearr_29175_29204[(2)] = null);

(statearr_29175_29204[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (4))){
var inst_29121 = (state_29172[(2)]);
var state_29172__$1 = (function (){var statearr_29176 = state_29172;
(statearr_29176[(7)] = inst_29121);

return statearr_29176;
})();
var statearr_29177_29205 = state_29172__$1;
(statearr_29177_29205[(2)] = null);

(statearr_29177_29205[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (13))){
var inst_29167 = (state_29172[(2)]);
var _ = (function (){var statearr_29178 = state_29172;
(statearr_29178[(4)] = cljs.core.rest((state_29172[(4)])));

return statearr_29178;
})();
var state_29172__$1 = state_29172;
var statearr_29179_29206 = state_29172__$1;
(statearr_29179_29206[(2)] = inst_29167);

(statearr_29179_29206[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (6))){
var inst_29131 = (state_29172[(2)]);
var state_29172__$1 = state_29172;
var statearr_29180_29207 = state_29172__$1;
(statearr_29180_29207[(2)] = inst_29131);

(statearr_29180_29207[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (3))){
var inst_29170 = (state_29172[(2)]);
var state_29172__$1 = state_29172;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29172__$1,inst_29170);
} else {
if((state_val_29173 === (12))){
var inst_29154 = (state_29172[(8)]);
var inst_29163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29164 = [null,inst_29154];
var inst_29165 = (new cljs.core.PersistentVector(null,2,(5),inst_29163,inst_29164,null));
var state_29172__$1 = state_29172;
var statearr_29181_29208 = state_29172__$1;
(statearr_29181_29208[(2)] = inst_29165);

(statearr_29181_29208[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (2))){
var _ = (function (){var statearr_29183 = state_29172;
(statearr_29183[(4)] = cljs.core.cons((9),(state_29172[(4)])));

return statearr_29183;
})();
var inst_29140 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29143 = [null,pred_name,"?o"];
var inst_29144 = (new cljs.core.PersistentVector(null,3,(5),inst_29142,inst_29143,null));
var inst_29145 = [inst_29144];
var inst_29146 = (new cljs.core.PersistentVector(null,1,(5),inst_29141,inst_29145,null));
var inst_29147 = ["?o",inst_29146,opts];
var inst_29148 = cljs.core.PersistentHashMap.fromArrays(inst_29140,inst_29147);
var inst_29149 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_29148);
var state_29172__$1 = state_29172;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29172__$1,(10),inst_29149);
} else {
if((state_val_29173 === (11))){
var inst_29153 = (state_29172[(9)]);
var inst_29154 = (state_29172[(8)]);
var inst_29158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29159 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_29153);
var inst_29160 = [inst_29159,inst_29154];
var inst_29161 = (new cljs.core.PersistentVector(null,2,(5),inst_29158,inst_29160,null));
var state_29172__$1 = state_29172;
var statearr_29184_29209 = state_29172__$1;
(statearr_29184_29209[(2)] = inst_29161);

(statearr_29184_29209[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (9))){
var _ = (function (){var statearr_29185 = state_29172;
(statearr_29185[(4)] = cljs.core.rest((state_29172[(4)])));

return statearr_29185;
})();
var state_29172__$1 = state_29172;
var ex29182 = (state_29172__$1[(2)]);
var statearr_29186_29210 = state_29172__$1;
(statearr_29186_29210[(5)] = ex29182);


var statearr_29187_29211 = state_29172__$1;
(statearr_29187_29211[(1)] = (4));

(statearr_29187_29211[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (5))){
var inst_29121 = (state_29172[(7)]);
var _ = (function (){var statearr_29189 = state_29172;
(statearr_29189[(4)] = cljs.core.cons((8),(state_29172[(4)])));

return statearr_29189;
})();
var inst_29128 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29121,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_29190 = state_29172;
(statearr_29190[(4)] = cljs.core.rest((state_29172[(4)])));

return statearr_29190;
})();
var state_29172__$1 = state_29172;
var statearr_29191_29212 = state_29172__$1;
(statearr_29191_29212[(2)] = inst_29128);

(statearr_29191_29212[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (10))){
var inst_29153 = (state_29172[(9)]);
var inst_29151 = (state_29172[(2)]);
var inst_29152 = fluree.db.util.async.throw_err(inst_29151);
var inst_29153__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29152,(0),null);
var inst_29154 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29152,(1),null);
var inst_29155 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_29153__$1);
var inst_29156 = cljs.core.not(inst_29155);
var state_29172__$1 = (function (){var statearr_29192 = state_29172;
(statearr_29192[(9)] = inst_29153__$1);

(statearr_29192[(8)] = inst_29154);

return statearr_29192;
})();
if(inst_29156){
var statearr_29193_29213 = state_29172__$1;
(statearr_29193_29213[(1)] = (11));

} else {
var statearr_29194_29214 = state_29172__$1;
(statearr_29194_29214[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29173 === (8))){
var _ = (function (){var statearr_29195 = state_29172;
(statearr_29195[(4)] = cljs.core.rest((state_29172[(4)])));

return statearr_29195;
})();
var state_29172__$1 = state_29172;
var ex29188 = (state_29172__$1[(2)]);
var statearr_29196_29215 = state_29172__$1;
(statearr_29196_29215[(5)] = ex29188);


var statearr_29197_29216 = state_29172__$1;
(statearr_29197_29216[(1)] = (7));

(statearr_29197_29216[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto____0 = (function (){
var statearr_29198 = [null,null,null,null,null,null,null,null,null,null];
(statearr_29198[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto__);

(statearr_29198[(1)] = (1));

return statearr_29198;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto____1 = (function (state_29172){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_29172);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e29199){var ex__2882__auto__ = e29199;
var statearr_29200_29217 = state_29172;
(statearr_29200_29217[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_29172[(4)]))){
var statearr_29201_29218 = state_29172;
(statearr_29201_29218[(1)] = cljs.core.first((state_29172[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29219 = state_29172;
state_29172 = G__29219;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto__ = function(state_29172){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto____1.call(this,state_29172);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_29202 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_29202[(6)] = c__2901__auto__);

return statearr_29202;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$(((typeof email === 'string')?cljs.core.re_matches(pattern,email):false));
}catch (e29220){var e = e29220;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__29222 = arguments.length;
switch (G__29222) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_29292){
var state_val_29293 = (state_29292[(1)]);
if((state_val_29293 === (7))){
var inst_29224 = (state_29292[(2)]);
var state_29292__$1 = state_29292;
var statearr_29294_29338 = state_29292__$1;
(statearr_29294_29338[(2)] = inst_29224);

(statearr_29294_29338[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29293 === (20))){
var inst_29268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29269 = ["*"];
var inst_29270 = (new cljs.core.PersistentVector(null,1,(5),inst_29268,inst_29269,null));
var state_29292__$1 = state_29292;
var statearr_29295_29339 = state_29292__$1;
(statearr_29295_29339[(2)] = inst_29270);

(statearr_29295_29339[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29293 === (1))){
var state_29292__$1 = state_29292;
var statearr_29296_29340 = state_29292__$1;
(statearr_29296_29340[(2)] = null);

(statearr_29296_29340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29293 === (4))){
var inst_29223 = (state_29292[(2)]);
var state_29292__$1 = (function (){var statearr_29297 = state_29292;
(statearr_29297[(7)] = inst_29223);

return statearr_29297;
})();
var statearr_29298_29341 = state_29292__$1;
(statearr_29298_29341[(2)] = null);

(statearr_29298_29341[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29293 === (15))){
var inst_29287 = (state_29292[(2)]);
var _ = (function (){var statearr_29299 = state_29292;
(statearr_29299[(4)] = cljs.core.rest((state_29292[(4)])));

return statearr_29299;
})();
var state_29292__$1 = state_29292;
var statearr_29300_29342 = state_29292__$1;
(statearr_29300_29342[(2)] = inst_29287);

(statearr_29300_29342[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29293 === (21))){
var inst_29258 = (state_29292[(8)]);
var inst_29251 = (state_29292[(9)]);
var inst_29272 = (state_29292[(2)]);
var inst_29273 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29274 = cljs.core.PersistentHashMap.EMPTY;
var inst_29275 = [inst_29272,inst_29258,inst_29274];
var inst_29276 = cljs.core.PersistentHashMap.fromArrays(inst_29273,inst_29275);
var inst_29277 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29251,inst_29276);
var state_29292__$1 = state_29292;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29292__$1,(22),inst_29277);
} else {
if((state_val_29293 === (13))){
var inst_29246 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29292__$1 = state_29292;
var statearr_29301_29343 = state_29292__$1;
(statearr_29301_29343[(2)] = inst_29246);

(statearr_29301_29343[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29293 === (22))){
var inst_29279 = (state_29292[(2)]);
var inst_29280 = fluree.db.util.async.throw_err(inst_29279);
var inst_29281 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29280,(0),null);
var inst_29282 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29280,(1),null);
var inst_29283 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29284 = [inst_29281,inst_29282];
var inst_29285 = (new cljs.core.PersistentVector(null,2,(5),inst_29283,inst_29284,null));
var state_29292__$1 = state_29292;
var statearr_29302_29344 = state_29292__$1;
(statearr_29302_29344[(2)] = inst_29285);

(statearr_29302_29344[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29293 === (6))){
var inst_29233 = (state_29292[(2)]);
var state_29292__$1 = state_29292;
var statearr_29303_29345 = state_29292__$1;
(statearr_29303_29345[(2)] = inst_29233);

(statearr_29303_29345[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29293 === (17))){
var inst_29255 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29256 = fluree.db.dbfunctions.internal.get(inst_29255,new cljs.core.Keyword(null,"_id","_id",-789960287));
var state_29292__$1 = state_29292;
var statearr_29304_29346 = state_29292__$1;
(statearr_29304_29346[(2)] = inst_29256);

(statearr_29304_29346[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29293 === (3))){
var inst_29290 = (state_29292[(2)]);
var state_29292__$1 = state_29292;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29292__$1,inst_29290);
} else {
if((state_val_29293 === (12))){
var inst_29244 = (state_29292[(2)]);
var state_29292__$1 = state_29292;
if(cljs.core.truth_(inst_29244)){
var statearr_29305_29347 = state_29292__$1;
(statearr_29305_29347[(1)] = (13));

} else {
var statearr_29306_29348 = state_29292__$1;
(statearr_29306_29348[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29293 === (2))){
var inst_29239 = (state_29292[(10)]);
var _ = (function (){var statearr_29307 = state_29292;
(statearr_29307[(4)] = cljs.core.cons((9),(state_29292[(4)])));

return statearr_29307;
})();
var inst_29239__$1 = new cljs.core.Keyword(null,"s","s",1705939918).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29292__$1 = (function (){var statearr_29308 = state_29292;
(statearr_29308[(10)] = inst_29239__$1);

return statearr_29308;
})();
if(cljs.core.truth_(inst_29239__$1)){
var statearr_29309_29349 = state_29292__$1;
(statearr_29309_29349[(1)] = (10));

} else {
var statearr_29310_29350 = state_29292__$1;
(statearr_29310_29350[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29293 === (19))){
var inst_29260 = cljs.core.PersistentVector.EMPTY;
var inst_29261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29262 = ["*"];
var inst_29263 = (new cljs.core.PersistentVector(null,1,(5),inst_29261,inst_29262,null));
var inst_29264 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_29265 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_29263,inst_29264);
var inst_29266 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29260,inst_29265);
var state_29292__$1 = state_29292;
var statearr_29312_29351 = state_29292__$1;
(statearr_29312_29351[(2)] = inst_29266);

(statearr_29312_29351[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29293 === (11))){
var inst_29239 = (state_29292[(10)]);
var state_29292__$1 = state_29292;
var statearr_29313_29352 = state_29292__$1;
(statearr_29313_29352[(2)] = inst_29239);

(statearr_29313_29352[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29293 === (9))){
var _ = (function (){var statearr_29314 = state_29292;
(statearr_29314[(4)] = cljs.core.rest((state_29292[(4)])));

return statearr_29314;
})();
var state_29292__$1 = state_29292;
var ex29311 = (state_29292__$1[(2)]);
var statearr_29315_29353 = state_29292__$1;
(statearr_29315_29353[(5)] = ex29311);


var statearr_29316_29354 = state_29292__$1;
(statearr_29316_29354[(1)] = (4));

(statearr_29316_29354[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29293 === (5))){
var inst_29223 = (state_29292[(7)]);
var _ = (function (){var statearr_29317 = state_29292;
(statearr_29317[(4)] = cljs.core.cons((8),(state_29292[(4)])));

return statearr_29317;
})();
var inst_29230 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29223,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_29318 = state_29292;
(statearr_29318[(4)] = cljs.core.rest((state_29292[(4)])));

return statearr_29318;
})();
var state_29292__$1 = state_29292;
var statearr_29319_29355 = state_29292__$1;
(statearr_29319_29355[(2)] = inst_29230);

(statearr_29319_29355[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29293 === (14))){
var inst_29252 = (state_29292[(11)]);
var inst_29251 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29252__$1 = new cljs.core.Keyword(null,"sid","sid",1815016414).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29292__$1 = (function (){var statearr_29320 = state_29292;
(statearr_29320[(9)] = inst_29251);

(statearr_29320[(11)] = inst_29252__$1);

return statearr_29320;
})();
if(cljs.core.truth_(inst_29252__$1)){
var statearr_29321_29356 = state_29292__$1;
(statearr_29321_29356[(1)] = (16));

} else {
var statearr_29322_29357 = state_29292__$1;
(statearr_29322_29357[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29293 === (16))){
var inst_29252 = (state_29292[(11)]);
var state_29292__$1 = state_29292;
var statearr_29323_29358 = state_29292__$1;
(statearr_29323_29358[(2)] = inst_29252);

(statearr_29323_29358[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29293 === (10))){
var inst_29241 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_29292__$1 = state_29292;
var statearr_29325_29359 = state_29292__$1;
(statearr_29325_29359[(2)] = inst_29241);

(statearr_29325_29359[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29293 === (18))){
var inst_29258 = (state_29292[(2)]);
var state_29292__$1 = (function (){var statearr_29326 = state_29292;
(statearr_29326[(8)] = inst_29258);

return statearr_29326;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29327_29360 = state_29292__$1;
(statearr_29327_29360[(1)] = (19));

} else {
var statearr_29328_29361 = state_29292__$1;
(statearr_29328_29361[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29293 === (8))){
var _ = (function (){var statearr_29329 = state_29292;
(statearr_29329[(4)] = cljs.core.rest((state_29292[(4)])));

return statearr_29329;
})();
var state_29292__$1 = state_29292;
var ex29324 = (state_29292__$1[(2)]);
var statearr_29330_29362 = state_29292__$1;
(statearr_29330_29362[(5)] = ex29324);


var statearr_29331_29363 = state_29292__$1;
(statearr_29331_29363[(1)] = (7));

(statearr_29331_29363[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2879__auto____0 = (function (){
var statearr_29332 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29332[(0)] = fluree$db$dbfunctions$internal$state_machine__2879__auto__);

(statearr_29332[(1)] = (1));

return statearr_29332;
});
var fluree$db$dbfunctions$internal$state_machine__2879__auto____1 = (function (state_29292){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_29292);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e29333){var ex__2882__auto__ = e29333;
var statearr_29334_29364 = state_29292;
(statearr_29334_29364[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_29292[(4)]))){
var statearr_29335_29365 = state_29292;
(statearr_29335_29365[(1)] = cljs.core.first((state_29292[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29366 = state_29292;
state_29292 = G__29366;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2879__auto__ = function(state_29292){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2879__auto____1.call(this,state_29292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_29336 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_29336[(6)] = c__2901__auto__);

return statearr_29336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__29368 = arguments.length;
switch (G__29368) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_29412){
var state_val_29413 = (state_29412[(1)]);
if((state_val_29413 === (7))){
var inst_29390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29391 = ["*"];
var inst_29392 = (new cljs.core.PersistentVector(null,1,(5),inst_29390,inst_29391,null));
var state_29412__$1 = state_29412;
var statearr_29414_29434 = state_29412__$1;
(statearr_29414_29434[(2)] = inst_29392);

(statearr_29414_29434[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29413 === (1))){
var state_29412__$1 = state_29412;
var statearr_29415_29435 = state_29412__$1;
(statearr_29415_29435[(2)] = null);

(statearr_29415_29435[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29413 === (4))){
var inst_29369 = (state_29412[(2)]);
var inst_29370 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29369,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_29412__$1 = state_29412;
var statearr_29416_29436 = state_29412__$1;
(statearr_29416_29436[(2)] = inst_29370);

(statearr_29416_29436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29413 === (6))){
var inst_29382 = cljs.core.PersistentVector.EMPTY;
var inst_29383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29384 = ["*"];
var inst_29385 = (new cljs.core.PersistentVector(null,1,(5),inst_29383,inst_29384,null));
var inst_29386 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_29387 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_29385,inst_29386);
var inst_29388 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29382,inst_29387);
var state_29412__$1 = state_29412;
var statearr_29417_29437 = state_29412__$1;
(statearr_29417_29437[(2)] = inst_29388);

(statearr_29417_29437[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29413 === (3))){
var inst_29410 = (state_29412[(2)]);
var state_29412__$1 = state_29412;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29412__$1,inst_29410);
} else {
if((state_val_29413 === (2))){
var _ = (function (){var statearr_29419 = state_29412;
(statearr_29419[(4)] = cljs.core.cons((5),(state_29412[(4)])));

return statearr_29419;
})();
var inst_29379 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29380 = new cljs.core.Keyword(null,"pid","pid",1018387698).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_29412__$1 = (function (){var statearr_29420 = state_29412;
(statearr_29420[(7)] = inst_29379);

(statearr_29420[(8)] = inst_29380);

return statearr_29420;
})();
if(cljs.core.truth_(additional_params)){
var statearr_29421_29438 = state_29412__$1;
(statearr_29421_29438[(1)] = (6));

} else {
var statearr_29422_29439 = state_29412__$1;
(statearr_29422_29439[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29413 === (9))){
var inst_29401 = (state_29412[(2)]);
var inst_29402 = fluree.db.util.async.throw_err(inst_29401);
var inst_29403 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29402,(0),null);
var inst_29404 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29402,(1),null);
var inst_29405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29406 = [inst_29403,inst_29404];
var inst_29407 = (new cljs.core.PersistentVector(null,2,(5),inst_29405,inst_29406,null));
var _ = (function (){var statearr_29423 = state_29412;
(statearr_29423[(4)] = cljs.core.rest((state_29412[(4)])));

return statearr_29423;
})();
var state_29412__$1 = state_29412;
var statearr_29424_29440 = state_29412__$1;
(statearr_29424_29440[(2)] = inst_29407);

(statearr_29424_29440[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29413 === (5))){
var _ = (function (){var statearr_29425 = state_29412;
(statearr_29425[(4)] = cljs.core.rest((state_29412[(4)])));

return statearr_29425;
})();
var state_29412__$1 = state_29412;
var ex29418 = (state_29412__$1[(2)]);
var statearr_29426_29441 = state_29412__$1;
(statearr_29426_29441[(5)] = ex29418);


var statearr_29427_29442 = state_29412__$1;
(statearr_29427_29442[(1)] = (4));

(statearr_29427_29442[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29413 === (8))){
var inst_29379 = (state_29412[(7)]);
var inst_29380 = (state_29412[(8)]);
var inst_29394 = (state_29412[(2)]);
var inst_29395 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29396 = cljs.core.PersistentHashMap.EMPTY;
var inst_29397 = [inst_29394,inst_29380,inst_29396];
var inst_29398 = cljs.core.PersistentHashMap.fromArrays(inst_29395,inst_29397);
var inst_29399 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29379,inst_29398);
var state_29412__$1 = state_29412;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29412__$1,(9),inst_29399);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__2879__auto____0 = (function (){
var statearr_29428 = [null,null,null,null,null,null,null,null,null];
(statearr_29428[(0)] = fluree$db$dbfunctions$internal$state_machine__2879__auto__);

(statearr_29428[(1)] = (1));

return statearr_29428;
});
var fluree$db$dbfunctions$internal$state_machine__2879__auto____1 = (function (state_29412){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_29412);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e29429){var ex__2882__auto__ = e29429;
var statearr_29430_29443 = state_29412;
(statearr_29430_29443[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_29412[(4)]))){
var statearr_29431_29444 = state_29412;
(statearr_29431_29444[(1)] = cljs.core.first((state_29412[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29445 = state_29412;
state_29412 = G__29445;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__2879__auto__ = function(state_29412){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__2879__auto____1.call(this,state_29412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_29432 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_29432[(6)] = c__2901__auto__);

return statearr_29432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_29489){
var state_val_29490 = (state_29489[(1)]);
if((state_val_29490 === (1))){
var state_29489__$1 = state_29489;
var statearr_29491_29505 = state_29489__$1;
(statearr_29491_29505[(2)] = null);

(statearr_29491_29505[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29490 === (2))){
var _ = (function (){var statearr_29492 = state_29489;
(statearr_29492[(4)] = cljs.core.cons((5),(state_29489[(4)])));

return statearr_29492;
})();
var inst_29456 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29457 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29458 = ["_user/_auth"];
var inst_29459 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29460 = ["*"];
var inst_29461 = (new cljs.core.PersistentVector(null,1,(5),inst_29459,inst_29460,null));
var inst_29462 = [inst_29461];
var inst_29463 = cljs.core.PersistentHashMap.fromArrays(inst_29458,inst_29462);
var inst_29464 = [inst_29463];
var inst_29465 = (new cljs.core.PersistentVector(null,1,(5),inst_29457,inst_29464,null));
var inst_29466 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29467 = cljs.core.PersistentHashMap.EMPTY;
var inst_29468 = [inst_29465,inst_29466,inst_29467];
var inst_29469 = cljs.core.PersistentHashMap.fromArrays(inst_29456,inst_29468);
var inst_29470 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29471 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29470,inst_29469);
var state_29489__$1 = state_29489;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29489__$1,(6),inst_29471);
} else {
if((state_val_29490 === (3))){
var inst_29487 = (state_29489[(2)]);
var state_29489__$1 = state_29489;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29489__$1,inst_29487);
} else {
if((state_val_29490 === (4))){
var inst_29446 = (state_29489[(2)]);
var inst_29447 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_29446,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_29489__$1 = state_29489;
var statearr_29494_29506 = state_29489__$1;
(statearr_29494_29506[(2)] = inst_29447);

(statearr_29494_29506[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29490 === (5))){
var _ = (function (){var statearr_29495 = state_29489;
(statearr_29495[(4)] = cljs.core.rest((state_29489[(4)])));

return statearr_29495;
})();
var state_29489__$1 = state_29489;
var ex29493 = (state_29489__$1[(2)]);
var statearr_29496_29507 = state_29489__$1;
(statearr_29496_29507[(5)] = ex29493);


var statearr_29497_29508 = state_29489__$1;
(statearr_29497_29508[(1)] = (4));

(statearr_29497_29508[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29490 === (6))){
var inst_29473 = (state_29489[(2)]);
var inst_29474 = fluree.db.util.async.throw_err(inst_29473);
var inst_29475 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29474,(0),null);
var inst_29476 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29474,(1),null);
var inst_29477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29478 = ["_user/_auth","_id"];
var inst_29479 = (new cljs.core.PersistentVector(null,2,(5),inst_29477,inst_29478,null));
var inst_29480 = fluree.db.dbfunctions.internal.get_in(inst_29475,inst_29479);
var inst_29481 = cljs.core.first(inst_29480);
var inst_29482 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29483 = [inst_29481,inst_29476];
var inst_29484 = (new cljs.core.PersistentVector(null,2,(5),inst_29482,inst_29483,null));
var _ = (function (){var statearr_29498 = state_29489;
(statearr_29498[(4)] = cljs.core.rest((state_29489[(4)])));

return statearr_29498;
})();
var state_29489__$1 = state_29489;
var statearr_29499_29509 = state_29489__$1;
(statearr_29499_29509[(2)] = inst_29484);

(statearr_29499_29509[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto____0 = (function (){
var statearr_29500 = [null,null,null,null,null,null,null];
(statearr_29500[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto__);

(statearr_29500[(1)] = (1));

return statearr_29500;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto____1 = (function (state_29489){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_29489);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e29501){var ex__2882__auto__ = e29501;
var statearr_29502_29510 = state_29489;
(statearr_29502_29510[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_29489[(4)]))){
var statearr_29503_29511 = state_29489;
(statearr_29503_29511[(1)] = cljs.core.first((state_29489[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29512 = state_29489;
state_29489 = G__29512;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto__ = function(state_29489){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto____1.call(this,state_29489);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_29504 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_29504[(6)] = c__2901__auto__);

return statearr_29504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_29529){
var state_val_29530 = (state_29529[(1)]);
if((state_val_29530 === (1))){
var state_29529__$1 = state_29529;
var statearr_29531_29545 = state_29529__$1;
(statearr_29531_29545[(2)] = null);

(statearr_29531_29545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (2))){
var _ = (function (){var statearr_29532 = state_29529;
(statearr_29532[(4)] = cljs.core.cons((5),(state_29529[(4)])));

return statearr_29532;
})();
var inst_29519 = new cljs.core.Keyword(null,"auth_id","auth_id",1917762333).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29520 = new cljs.core.Keyword(null,"db","db",993250759).cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_29521 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_29520,inst_29519);
var state_29529__$1 = state_29529;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29529__$1,(6),inst_29521);
} else {
if((state_val_29530 === (3))){
var inst_29527 = (state_29529[(2)]);
var state_29529__$1 = state_29529;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29529__$1,inst_29527);
} else {
if((state_val_29530 === (4))){
var inst_29513 = (state_29529[(2)]);
var state_29529__$1 = state_29529;
var statearr_29534_29546 = state_29529__$1;
(statearr_29534_29546[(2)] = inst_29513);

(statearr_29534_29546[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (5))){
var _ = (function (){var statearr_29535 = state_29529;
(statearr_29535[(4)] = cljs.core.rest((state_29529[(4)])));

return statearr_29535;
})();
var state_29529__$1 = state_29529;
var ex29533 = (state_29529__$1[(2)]);
var statearr_29536_29547 = state_29529__$1;
(statearr_29536_29547[(5)] = ex29533);


if((ex29533 instanceof Error)){
var statearr_29537_29548 = state_29529__$1;
(statearr_29537_29548[(1)] = (4));

(statearr_29537_29548[(5)] = null);

} else {
throw ex29533;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29530 === (6))){
var inst_29523 = (state_29529[(2)]);
var inst_29524 = fluree.db.util.async.throw_err(inst_29523);
var _ = (function (){var statearr_29538 = state_29529;
(statearr_29538[(4)] = cljs.core.rest((state_29529[(4)])));

return statearr_29538;
})();
var state_29529__$1 = state_29529;
var statearr_29539_29549 = state_29529__$1;
(statearr_29539_29549[(2)] = inst_29524);

(statearr_29539_29549[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto____0 = (function (){
var statearr_29540 = [null,null,null,null,null,null,null];
(statearr_29540[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto__);

(statearr_29540[(1)] = (1));

return statearr_29540;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto____1 = (function (state_29529){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_29529);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e29541){var ex__2882__auto__ = e29541;
var statearr_29542_29550 = state_29529;
(statearr_29542_29550[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_29529[(4)]))){
var statearr_29543_29551 = state_29529;
(statearr_29543_29551[(1)] = cljs.core.first((state_29529[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29552 = state_29529;
state_29529 = G__29552;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto__ = function(state_29529){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto____1.call(this,state_29529);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_29544 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_29544[(6)] = c__2901__auto__);

return statearr_29544;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__29553_SHARP_){
return p1__29553_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29554_SHARP_){
return p1__29554_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29555){var e = e29555;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__29556_SHARP_){
return p1__29556_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__29557_SHARP_){
return p1__29557_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e29558){var e = e29558;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__29560 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__29560);
})() | (0));
return num;
}catch (e29559){var e = e29559;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_29660){
var state_val_29661 = (state_29660[(1)]);
if((state_val_29661 === (7))){
var state_29660__$1 = state_29660;
var statearr_29662_29710 = state_29660__$1;
(statearr_29662_29710[(2)] = false);

(statearr_29662_29710[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (20))){
var inst_29594 = (state_29660[(7)]);
var inst_29595 = (state_29660[(8)]);
var inst_29616 = (state_29660[(2)]);
var inst_29617 = fluree.db.dbproto._p_prop(inst_29595,new cljs.core.Keyword(null,"multi","multi",-190293005),inst_29594);
var state_29660__$1 = (function (){var statearr_29663 = state_29660;
(statearr_29663[(9)] = inst_29616);

return statearr_29663;
})();
if(cljs.core.truth_(inst_29617)){
var statearr_29664_29711 = state_29660__$1;
(statearr_29664_29711[(1)] = (21));

} else {
var statearr_29665_29712 = state_29660__$1;
(statearr_29665_29712[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (27))){
var inst_29655 = (state_29660[(2)]);
var _ = (function (){var statearr_29666 = state_29660;
(statearr_29666[(4)] = cljs.core.rest((state_29660[(4)])));

return statearr_29666;
})();
var state_29660__$1 = state_29660;
var statearr_29667_29713 = state_29660__$1;
(statearr_29667_29713[(2)] = inst_29655);

(statearr_29667_29713[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (1))){
var state_29660__$1 = state_29660;
var statearr_29668_29714 = state_29660__$1;
(statearr_29668_29714[(2)] = null);

(statearr_29668_29714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (24))){
var inst_29644 = (state_29660[(10)]);
var inst_29640 = (state_29660[(2)]);
var inst_29641 = fluree.db.util.async.throw_err(inst_29640);
var inst_29642 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29641,(0),null);
var inst_29643 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29641,(1),null);
var inst_29644__$1 = cljs.core.first(inst_29642);
var inst_29645 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_29644__$1,compare_val);
var state_29660__$1 = (function (){var statearr_29669 = state_29660;
(statearr_29669[(10)] = inst_29644__$1);

(statearr_29669[(11)] = inst_29643);

return statearr_29669;
})();
if(inst_29645){
var statearr_29670_29715 = state_29660__$1;
(statearr_29670_29715[(1)] = (25));

} else {
var statearr_29671_29716 = state_29660__$1;
(statearr_29671_29716[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (4))){
var inst_29561 = (state_29660[(2)]);
var state_29660__$1 = state_29660;
var statearr_29672_29717 = state_29660__$1;
(statearr_29672_29717[(2)] = inst_29561);

(statearr_29672_29717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (15))){
var state_29660__$1 = state_29660;
var statearr_29673_29718 = state_29660__$1;
(statearr_29673_29718[(2)] = null);

(statearr_29673_29718[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (21))){
var inst_29596 = (state_29660[(12)]);
var inst_29619 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_29596], 0));
var inst_29620 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29621 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29622 = cljs.core.PersistentHashMap.fromArrays(inst_29620,inst_29621);
var inst_29623 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29619,inst_29622);
var inst_29624 = (function(){throw inst_29623})();
var state_29660__$1 = state_29660;
var statearr_29674_29719 = state_29660__$1;
(statearr_29674_29719[(2)] = inst_29624);

(statearr_29674_29719[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (13))){
var inst_29571 = (state_29660[(13)]);
var state_29660__$1 = state_29660;
var statearr_29675_29720 = state_29660__$1;
(statearr_29675_29720[(2)] = inst_29571);

(statearr_29675_29720[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (22))){
var state_29660__$1 = state_29660;
var statearr_29676_29721 = state_29660__$1;
(statearr_29676_29721[(2)] = null);

(statearr_29676_29721[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (6))){
var inst_29571 = (state_29660[(13)]);
var inst_29576 = inst_29571.cljs$lang$protocol_mask$partition0$;
var inst_29577 = (inst_29576 & (64));
var inst_29578 = inst_29571.cljs$core$ISeq$;
var inst_29579 = (cljs.core.PROTOCOL_SENTINEL === inst_29578);
var inst_29580 = ((inst_29577) || (inst_29579));
var state_29660__$1 = state_29660;
if(cljs.core.truth_(inst_29580)){
var statearr_29677_29722 = state_29660__$1;
(statearr_29677_29722[(1)] = (9));

} else {
var statearr_29678_29723 = state_29660__$1;
(statearr_29678_29723[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (25))){
var state_29660__$1 = state_29660;
var statearr_29679_29724 = state_29660__$1;
(statearr_29679_29724[(2)] = new_val);

(statearr_29679_29724[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (17))){
var inst_29596 = (state_29660[(12)]);
var inst_29606 = (state_29660[(2)]);
var state_29660__$1 = (function (){var statearr_29680 = state_29660;
(statearr_29680[(14)] = inst_29606);

return statearr_29680;
})();
if(cljs.core.truth_(inst_29596)){
var statearr_29681_29725 = state_29660__$1;
(statearr_29681_29725[(1)] = (18));

} else {
var statearr_29682_29726 = state_29660__$1;
(statearr_29682_29726[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (3))){
var inst_29658 = (state_29660[(2)]);
var state_29660__$1 = state_29660;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29660__$1,inst_29658);
} else {
if((state_val_29661 === (12))){
var inst_29571 = (state_29660[(13)]);
var inst_29589 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_29571);
var state_29660__$1 = state_29660;
var statearr_29683_29727 = state_29660__$1;
(statearr_29683_29727[(2)] = inst_29589);

(statearr_29683_29727[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (2))){
var inst_29571 = (state_29660[(13)]);
var _ = (function (){var statearr_29684 = state_29660;
(statearr_29684[(4)] = cljs.core.cons((5),(state_29660[(4)])));

return statearr_29684;
})();
var inst_29571__$1 = _QMARK_ctx;
var inst_29573 = (inst_29571__$1 == null);
var inst_29574 = cljs.core.not(inst_29573);
var state_29660__$1 = (function (){var statearr_29685 = state_29660;
(statearr_29685[(13)] = inst_29571__$1);

return statearr_29685;
})();
if(inst_29574){
var statearr_29686_29728 = state_29660__$1;
(statearr_29686_29728[(1)] = (6));

} else {
var statearr_29687_29729 = state_29660__$1;
(statearr_29687_29729[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (23))){
var inst_29596 = (state_29660[(12)]);
var inst_29593 = (state_29660[(15)]);
var inst_29595 = (state_29660[(8)]);
var inst_29627 = (state_29660[(2)]);
var inst_29628 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_29629 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29631 = [inst_29593,inst_29596,"?current-val"];
var inst_29632 = (new cljs.core.PersistentVector(null,3,(5),inst_29630,inst_29631,null));
var inst_29633 = [inst_29632];
var inst_29634 = (new cljs.core.PersistentVector(null,1,(5),inst_29629,inst_29633,null));
var inst_29635 = cljs.core.PersistentHashMap.EMPTY;
var inst_29636 = ["?current-val",inst_29634,inst_29635];
var inst_29637 = cljs.core.PersistentHashMap.fromArrays(inst_29628,inst_29636);
var inst_29638 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_29595,inst_29637);
var state_29660__$1 = (function (){var statearr_29688 = state_29660;
(statearr_29688[(16)] = inst_29627);

return statearr_29688;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29660__$1,(24),inst_29638);
} else {
if((state_val_29661 === (19))){
var inst_29609 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29610 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29611 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29612 = cljs.core.PersistentHashMap.fromArrays(inst_29610,inst_29611);
var inst_29613 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29609,inst_29612);
var inst_29614 = (function(){throw inst_29613})();
var state_29660__$1 = state_29660;
var statearr_29689_29730 = state_29660__$1;
(statearr_29689_29730[(2)] = inst_29614);

(statearr_29689_29730[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (11))){
var inst_29584 = (state_29660[(2)]);
var state_29660__$1 = state_29660;
var statearr_29691_29731 = state_29660__$1;
(statearr_29691_29731[(2)] = inst_29584);

(statearr_29691_29731[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (9))){
var state_29660__$1 = state_29660;
var statearr_29692_29732 = state_29660__$1;
(statearr_29692_29732[(2)] = true);

(statearr_29692_29732[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (5))){
var _ = (function (){var statearr_29693 = state_29660;
(statearr_29693[(4)] = cljs.core.rest((state_29660[(4)])));

return statearr_29693;
})();
var state_29660__$1 = state_29660;
var ex29690 = (state_29660__$1[(2)]);
var statearr_29694_29733 = state_29660__$1;
(statearr_29694_29733[(5)] = ex29690);


if((ex29690 instanceof Error)){
var statearr_29695_29734 = state_29660__$1;
(statearr_29695_29734[(1)] = (4));

(statearr_29695_29734[(5)] = null);

} else {
throw ex29690;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (14))){
var inst_29593 = (state_29660[(15)]);
var inst_29594 = (state_29660[(7)]);
var inst_29595 = (state_29660[(8)]);
var inst_29592 = (state_29660[(2)]);
var inst_29593__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29592,new cljs.core.Keyword(null,"sid","sid",1815016414));
var inst_29594__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29592,new cljs.core.Keyword(null,"pid","pid",1018387698));
var inst_29595__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_29592,new cljs.core.Keyword(null,"db","db",993250759));
var inst_29596 = fluree.db.dbproto._p_prop(inst_29595__$1,new cljs.core.Keyword(null,"name","name",1843675177),inst_29594__$1);
var state_29660__$1 = (function (){var statearr_29696 = state_29660;
(statearr_29696[(12)] = inst_29596);

(statearr_29696[(15)] = inst_29593__$1);

(statearr_29696[(7)] = inst_29594__$1);

(statearr_29696[(8)] = inst_29595__$1);

return statearr_29696;
})();
if(cljs.core.truth_(inst_29593__$1)){
var statearr_29697_29735 = state_29660__$1;
(statearr_29697_29735[(1)] = (15));

} else {
var statearr_29698_29736 = state_29660__$1;
(statearr_29698_29736[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (26))){
var inst_29644 = (state_29660[(10)]);
var inst_29648 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_29644)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_29649 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29650 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29651 = cljs.core.PersistentHashMap.fromArrays(inst_29649,inst_29650);
var inst_29652 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29648,inst_29651);
var inst_29653 = (function(){throw inst_29652})();
var state_29660__$1 = state_29660;
var statearr_29699_29737 = state_29660__$1;
(statearr_29699_29737[(2)] = inst_29653);

(statearr_29699_29737[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (16))){
var inst_29599 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_29600 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_29601 = [(400),new cljs.core.Keyword("db","validation-error","db/validation-error",1040488996)];
var inst_29602 = cljs.core.PersistentHashMap.fromArrays(inst_29600,inst_29601);
var inst_29603 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_29599,inst_29602);
var inst_29604 = (function(){throw inst_29603})();
var state_29660__$1 = state_29660;
var statearr_29700_29738 = state_29660__$1;
(statearr_29700_29738[(2)] = inst_29604);

(statearr_29700_29738[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (10))){
var state_29660__$1 = state_29660;
var statearr_29701_29739 = state_29660__$1;
(statearr_29701_29739[(2)] = false);

(statearr_29701_29739[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (18))){
var state_29660__$1 = state_29660;
var statearr_29702_29740 = state_29660__$1;
(statearr_29702_29740[(2)] = null);

(statearr_29702_29740[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29661 === (8))){
var inst_29587 = (state_29660[(2)]);
var state_29660__$1 = state_29660;
if(cljs.core.truth_(inst_29587)){
var statearr_29703_29741 = state_29660__$1;
(statearr_29703_29741[(1)] = (12));

} else {
var statearr_29704_29742 = state_29660__$1;
(statearr_29704_29742[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto____0 = (function (){
var statearr_29705 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29705[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto__);

(statearr_29705[(1)] = (1));

return statearr_29705;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto____1 = (function (state_29660){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_29660);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e29706){var ex__2882__auto__ = e29706;
var statearr_29707_29743 = state_29660;
(statearr_29707_29743[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_29660[(4)]))){
var statearr_29708_29744 = state_29660;
(statearr_29708_29744[(1)] = cljs.core.first((state_29660[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29745 = state_29660;
state_29660 = G__29745;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto__ = function(state_29660){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto____1.call(this,state_29660);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_29709 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_29709[(6)] = c__2901__auto__);

return statearr_29709;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
