// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__16513_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16513_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__16517 = coll;
var vec__16518 = G__16517;
var seq__16519 = cljs.core.seq(vec__16518);
var first__16520 = cljs.core.first(seq__16519);
var seq__16519__$1 = cljs.core.next(seq__16519);
var clause = first__16520;
var r = seq__16519__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__16517__$1 = G__16517;
var res__$1 = res;
while(true){
var vec__16524 = G__16517__$1;
var seq__16525 = cljs.core.seq(vec__16524);
var first__16526 = cljs.core.first(seq__16525);
var seq__16525__$1 = cljs.core.next(seq__16525);
var clause__$1 = first__16526;
var r__$1 = seq__16525__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__16527 = r__$1;
var G__16528 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__16517__$1 = G__16527;
res__$1 = G__16528;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__16532 = coll;
var vec__16533 = G__16532;
var seq__16534 = cljs.core.seq(vec__16533);
var first__16535 = cljs.core.first(seq__16534);
var seq__16534__$1 = cljs.core.next(seq__16534);
var clause = first__16535;
var r = seq__16534__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__16532__$1 = G__16532;
var res__$1 = res;
while(true){
var vec__16539 = G__16532__$1;
var seq__16540 = cljs.core.seq(vec__16539);
var first__16541 = cljs.core.first(seq__16540);
var seq__16540__$1 = cljs.core.next(seq__16540);
var clause__$1 = first__16541;
var r__$1 = seq__16540__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__16542 = r__$1;
var G__16543 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__16532__$1 = G__16542;
res__$1 = G__16543;
continue;
} else {
var G__16544 = r__$1;
var G__16545 = res__$2;
G__16532__$1 = G__16544;
res__$1 = G__16545;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__16549 = coll;
var vec__16550 = G__16549;
var seq__16551 = cljs.core.seq(vec__16550);
var first__16552 = cljs.core.first(seq__16551);
var seq__16551__$1 = cljs.core.next(seq__16551);
var clause = first__16552;
var r = seq__16551__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__16549__$1 = G__16549;
var res__$1 = res;
while(true){
var vec__16556 = G__16549__$1;
var seq__16557 = cljs.core.seq(vec__16556);
var first__16558 = cljs.core.first(seq__16557);
var seq__16557__$1 = cljs.core.next(seq__16557);
var clause__$1 = first__16558;
var r__$1 = seq__16557__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__16559 = r__$1;
var G__16560 = res__$2;
G__16549__$1 = G__16559;
res__$1 = G__16560;
continue;
} else {
var G__16561 = r__$1;
var G__16562 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__16549__$1 = G__16561;
res__$1 = G__16562;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_(((typeof string === 'string')?cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string):false))){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var clause_str = [clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,clause)),"."].join('');
if(cljs.core.truth_(optional_QMARK_)){
return ["OPTIONAL {",clause_str,"}"].join('');
} else {
return clause_str;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map)], 0));
var map__16566 = opts;
var map__16566__$1 = (((((!((map__16566 == null))))?(((((map__16566.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16566.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__16566):map__16566);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16566__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16566__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16566__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16566__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16566__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__16563_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16563_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__16564_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__16564_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__16565_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__16565_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = language;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_16581){
var state_val_16582 = (state_16581[(1)]);
if((state_val_16582 === (1))){
var inst_16568 = fluree.db.util.core.url_encode(query);
var inst_16569 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16568)].join('');
var inst_16570 = ["User-Agent","Accept"];
var inst_16571 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_16572 = cljs.core.PersistentHashMap.fromArrays(inst_16570,inst_16571);
var inst_16573 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_16574 = [inst_16572,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_16575 = cljs.core.PersistentHashMap.fromArrays(inst_16573,inst_16574);
var inst_16576 = fluree.db.util.xhttp.get(inst_16569,inst_16575);
var state_16581__$1 = state_16581;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16581__$1,(2),inst_16576);
} else {
if((state_val_16582 === (2))){
var inst_16578 = (state_16581[(2)]);
var inst_16579 = fluree.db.util.async.throw_err(inst_16578);
var state_16581__$1 = state_16581;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16581__$1,inst_16579);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto____0 = (function (){
var statearr_16583 = [null,null,null,null,null,null,null];
(statearr_16583[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto__);

(statearr_16583[(1)] = (1));

return statearr_16583;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto____1 = (function (state_16581){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_16581);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e16584){var ex__2882__auto__ = e16584;
var statearr_16585_16588 = state_16581;
(statearr_16585_16588[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_16581[(4)]))){
var statearr_16586_16589 = state_16581;
(statearr_16586_16589[(1)] = cljs.core.first((state_16581[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16590 = state_16581;
state_16581 = G__16590;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto__ = function(state_16581){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto____1.call(this,state_16581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_16587 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_16587[(6)] = c__2901__auto__);

return statearr_16587;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_16608){
var state_val_16609 = (state_16608[(1)]);
if((state_val_16609 === (1))){
var inst_16591 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_16608__$1 = state_16608;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16608__$1,(2),inst_16591);
} else {
if((state_val_16609 === (2))){
var inst_16594 = (state_16608[(7)]);
var inst_16593 = (state_16608[(2)]);
var inst_16594__$1 = fluree.db.util.async.throw_err(inst_16593);
var inst_16595 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_16594__$1);
var inst_16596 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_16595);
var state_16608__$1 = (function (){var statearr_16610 = state_16608;
(statearr_16610[(7)] = inst_16594__$1);

return statearr_16610;
})();
if(inst_16596){
var statearr_16611_16620 = state_16608__$1;
(statearr_16611_16620[(1)] = (3));

} else {
var statearr_16612_16621 = state_16608__$1;
(statearr_16612_16621[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (3))){
var inst_16594 = (state_16608[(7)]);
var state_16608__$1 = state_16608;
var statearr_16613_16622 = state_16608__$1;
(statearr_16613_16622[(2)] = inst_16594);

(statearr_16613_16622[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (4))){
var inst_16594 = (state_16608[(7)]);
var inst_16599 = (function (){var body = inst_16594;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_16600 = cljs.core.second(inst_16594);
var inst_16601 = cljs.core.second(inst_16600);
var inst_16602 = cljs.core.first(inst_16601);
var inst_16603 = cljs.core.second(inst_16602);
var inst_16604 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_16599,inst_16603);
var state_16608__$1 = state_16608;
var statearr_16614_16623 = state_16608__$1;
(statearr_16614_16623[(2)] = inst_16604);

(statearr_16614_16623[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (5))){
var inst_16606 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16608__$1,inst_16606);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto____0 = (function (){
var statearr_16615 = [null,null,null,null,null,null,null,null];
(statearr_16615[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto__);

(statearr_16615[(1)] = (1));

return statearr_16615;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto____1 = (function (state_16608){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_16608);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e16616){var ex__2882__auto__ = e16616;
var statearr_16617_16624 = state_16608;
(statearr_16617_16624[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_16608[(4)]))){
var statearr_16618_16625 = state_16608;
(statearr_16618_16625[(1)] = cljs.core.first((state_16608[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16626 = state_16608;
state_16608 = G__16626;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto__ = function(state_16608){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto____1.call(this,state_16608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_16619 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_16619[(6)] = c__2901__auto__);

return statearr_16619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__16627_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16627_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__16628_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16628_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__16629_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1((p1__16629_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__16629_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__16629_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_16695){
var state_val_16696 = (state_16695[(1)]);
if((state_val_16696 === (7))){
var inst_16640 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_16695__$1 = state_16695;
var statearr_16697_16738 = state_16695__$1;
(statearr_16697_16738[(2)] = inst_16640);

(statearr_16697_16738[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (20))){
var inst_16668 = (state_16695[(7)]);
var inst_16688 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_16668,all_vars);
var state_16695__$1 = state_16695;
var statearr_16698_16739 = state_16695__$1;
(statearr_16698_16739[(2)] = inst_16688);

(statearr_16698_16739[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (1))){
var state_16695__$1 = state_16695;
var statearr_16699_16740 = state_16695__$1;
(statearr_16699_16740[(2)] = null);

(statearr_16699_16740[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (24))){
var inst_16669 = (state_16695[(8)]);
var inst_16668 = (state_16695[(7)]);
var inst_16674 = (state_16695[(9)]);
var inst_16679 = (state_16695[(2)]);
var inst_16680 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_16674,(0),inst_16679);
var inst_16681 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16682 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_16668);
var inst_16683 = [inst_16669,inst_16682];
var inst_16684 = cljs.core.PersistentHashMap.fromArrays(inst_16681,inst_16683);
var inst_16685 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_16680,inst_16684);
var inst_16686 = (function(){throw inst_16685})();
var state_16695__$1 = state_16695;
var statearr_16700_16741 = state_16695__$1;
(statearr_16700_16741[(2)] = inst_16686);

(statearr_16700_16741[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (4))){
var inst_16630 = (state_16695[(2)]);
var state_16695__$1 = state_16695;
var statearr_16701_16742 = state_16695__$1;
(statearr_16701_16742[(2)] = inst_16630);

(statearr_16701_16742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (15))){
var inst_16660 = (state_16695[(2)]);
var state_16695__$1 = state_16695;
var statearr_16702_16743 = state_16695__$1;
(statearr_16702_16743[(2)] = inst_16660);

(statearr_16702_16743[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (21))){
var inst_16690 = (state_16695[(2)]);
var _ = (function (){var statearr_16703 = state_16695;
(statearr_16703[(4)] = cljs.core.rest((state_16695[(4)])));

return statearr_16703;
})();
var state_16695__$1 = state_16695;
var statearr_16704_16744 = state_16695__$1;
(statearr_16704_16744[(2)] = inst_16690);

(statearr_16704_16744[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (13))){
var state_16695__$1 = state_16695;
var statearr_16705_16745 = state_16695__$1;
(statearr_16705_16745[(2)] = true);

(statearr_16705_16745[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (22))){
var inst_16673 = (state_16695[(10)]);
var state_16695__$1 = state_16695;
var statearr_16706_16746 = state_16695__$1;
(statearr_16706_16746[(2)] = inst_16673);

(statearr_16706_16746[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (6))){
var state_16695__$1 = state_16695;
var statearr_16707_16747 = state_16695__$1;
(statearr_16707_16747[(2)] = null);

(statearr_16707_16747[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (17))){
var inst_16647 = (state_16695[(11)]);
var state_16695__$1 = state_16695;
var statearr_16708_16748 = state_16695__$1;
(statearr_16708_16748[(2)] = inst_16647);

(statearr_16708_16748[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (3))){
var inst_16693 = (state_16695[(2)]);
var state_16695__$1 = state_16695;
return cljs.core.async.impl.ioc_helpers.return_chan(state_16695__$1,inst_16693);
} else {
if((state_val_16696 === (12))){
var inst_16663 = (state_16695[(2)]);
var state_16695__$1 = state_16695;
if(cljs.core.truth_(inst_16663)){
var statearr_16709_16749 = state_16695__$1;
(statearr_16709_16749[(1)] = (16));

} else {
var statearr_16710_16750 = state_16695__$1;
(statearr_16710_16750[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (2))){
var _ = (function (){var statearr_16711 = state_16695;
(statearr_16711[(4)] = cljs.core.cons((5),(state_16695[(4)])));

return statearr_16711;
})();
var inst_16637 = cljs.core.empty_QMARK_(matching_vars);
var state_16695__$1 = state_16695;
if(inst_16637){
var statearr_16712_16751 = state_16695__$1;
(statearr_16712_16751[(1)] = (6));

} else {
var statearr_16713_16752 = state_16695__$1;
(statearr_16713_16752[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (23))){
var state_16695__$1 = state_16695;
var statearr_16714_16753 = state_16695__$1;
(statearr_16714_16753[(2)] = (1000));

(statearr_16714_16753[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (19))){
var inst_16673 = (state_16695[(10)]);
var inst_16668 = (state_16695[(7)]);
var inst_16670 = (state_16695[(12)]);
var inst_16673__$1 = cljs.core.count(inst_16670);
var inst_16674 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_16668);
var inst_16675 = (inst_16673__$1 < (1000));
var state_16695__$1 = (function (){var statearr_16715 = state_16695;
(statearr_16715[(10)] = inst_16673__$1);

(statearr_16715[(9)] = inst_16674);

return statearr_16715;
})();
if(cljs.core.truth_(inst_16675)){
var statearr_16716_16754 = state_16695__$1;
(statearr_16716_16754[(1)] = (22));

} else {
var statearr_16717_16755 = state_16695__$1;
(statearr_16717_16755[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (11))){
var state_16695__$1 = state_16695;
var statearr_16719_16756 = state_16695__$1;
(statearr_16719_16756[(2)] = false);

(statearr_16719_16756[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (9))){
var inst_16647 = (state_16695[(11)]);
var inst_16646 = (state_16695[(2)]);
var inst_16647__$1 = fluree.db.util.async.throw_err(inst_16646);
var inst_16649 = (inst_16647__$1 == null);
var inst_16650 = cljs.core.not(inst_16649);
var state_16695__$1 = (function (){var statearr_16720 = state_16695;
(statearr_16720[(11)] = inst_16647__$1);

return statearr_16720;
})();
if(inst_16650){
var statearr_16721_16757 = state_16695__$1;
(statearr_16721_16757[(1)] = (10));

} else {
var statearr_16722_16758 = state_16695__$1;
(statearr_16722_16758[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (5))){
var _ = (function (){var statearr_16723 = state_16695;
(statearr_16723[(4)] = cljs.core.rest((state_16695[(4)])));

return statearr_16723;
})();
var state_16695__$1 = state_16695;
var ex16718 = (state_16695__$1[(2)]);
var statearr_16724_16759 = state_16695__$1;
(statearr_16724_16759[(5)] = ex16718);


if((ex16718 instanceof Error)){
var statearr_16725_16760 = state_16695__$1;
(statearr_16725_16760[(1)] = (4));

(statearr_16725_16760[(5)] = null);

} else {
throw ex16718;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (14))){
var state_16695__$1 = state_16695;
var statearr_16726_16761 = state_16695__$1;
(statearr_16726_16761[(2)] = false);

(statearr_16726_16761[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (16))){
var inst_16647 = (state_16695[(11)]);
var inst_16665 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_16647);
var state_16695__$1 = state_16695;
var statearr_16727_16762 = state_16695__$1;
(statearr_16727_16762[(2)] = inst_16665);

(statearr_16727_16762[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (10))){
var inst_16647 = (state_16695[(11)]);
var inst_16652 = inst_16647.cljs$lang$protocol_mask$partition0$;
var inst_16653 = (inst_16652 & (64));
var inst_16654 = inst_16647.cljs$core$ISeq$;
var inst_16655 = (cljs.core.PROTOCOL_SENTINEL === inst_16654);
var inst_16656 = ((inst_16653) || (inst_16655));
var state_16695__$1 = state_16695;
if(cljs.core.truth_(inst_16656)){
var statearr_16728_16763 = state_16695__$1;
(statearr_16728_16763[(1)] = (13));

} else {
var statearr_16729_16764 = state_16695__$1;
(statearr_16729_16764[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (18))){
var inst_16669 = (state_16695[(8)]);
var inst_16668 = (state_16695[(7)]);
var inst_16668__$1 = (state_16695[(2)]);
var inst_16669__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16668__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_16670 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_16668__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_16671 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_16669__$1);
var state_16695__$1 = (function (){var statearr_16730 = state_16695;
(statearr_16730[(8)] = inst_16669__$1);

(statearr_16730[(7)] = inst_16668__$1);

(statearr_16730[(12)] = inst_16670);

return statearr_16730;
})();
if(inst_16671){
var statearr_16731_16765 = state_16695__$1;
(statearr_16731_16765[(1)] = (19));

} else {
var statearr_16732_16766 = state_16695__$1;
(statearr_16732_16766[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16696 === (8))){
var inst_16642 = (state_16695[(2)]);
var inst_16643 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_16642,optional_clauses);
var inst_16644 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_16643);
var state_16695__$1 = state_16695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_16695__$1,(9),inst_16644);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto____0 = (function (){
var statearr_16733 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16733[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto__);

(statearr_16733[(1)] = (1));

return statearr_16733;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto____1 = (function (state_16695){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_16695);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e16734){var ex__2882__auto__ = e16734;
var statearr_16735_16767 = state_16695;
(statearr_16735_16767[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_16695[(4)]))){
var statearr_16736_16768 = state_16695;
(statearr_16736_16768[(1)] = cljs.core.first((state_16695[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16769 = state_16695;
state_16695 = G__16769;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto__ = function(state_16695){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto____1.call(this,state_16695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_16737 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_16737[(6)] = c__2901__auto__);

return statearr_16737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
