// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__8592 = arguments.length;
switch (G__8592) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async8593 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8593 = (function (f,blockable,meta8594){
this.f = f;
this.blockable = blockable;
this.meta8594 = meta8594;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async8593.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8595,meta8594__$1){
var self__ = this;
var _8595__$1 = this;
return (new cljs.core.async.t_cljs$core$async8593(self__.f,self__.blockable,meta8594__$1));
}));

(cljs.core.async.t_cljs$core$async8593.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8595){
var self__ = this;
var _8595__$1 = this;
return self__.meta8594;
}));

(cljs.core.async.t_cljs$core$async8593.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async8593.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async8593.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async8593.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async8593.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta8594","meta8594",-1831960828,null)], null);
}));

(cljs.core.async.t_cljs$core$async8593.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async8593.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8593");

(cljs.core.async.t_cljs$core$async8593.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async8593");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8593.
 */
cljs.core.async.__GT_t_cljs$core$async8593 = (function cljs$core$async$__GT_t_cljs$core$async8593(f__$1,blockable__$1,meta8594){
return (new cljs.core.async.t_cljs$core$async8593(f__$1,blockable__$1,meta8594));
});

}

return (new cljs.core.async.t_cljs$core$async8593(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__8599 = arguments.length;
switch (G__8599) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__8602 = arguments.length;
switch (G__8602) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__8605 = arguments.length;
switch (G__8605) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_8607 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_8607) : fn1.call(null,val_8607));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_8607) : fn1.call(null,val_8607));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__8609 = arguments.length;
switch (G__8609) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4613__auto___8611 = n;
var x_8612 = (0);
while(true){
if((x_8612 < n__4613__auto___8611)){
(a[x_8612] = x_8612);

var G__8613 = (x_8612 + (1));
x_8612 = G__8613;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async8614 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8614 = (function (flag,meta8615){
this.flag = flag;
this.meta8615 = meta8615;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async8614.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8616,meta8615__$1){
var self__ = this;
var _8616__$1 = this;
return (new cljs.core.async.t_cljs$core$async8614(self__.flag,meta8615__$1));
}));

(cljs.core.async.t_cljs$core$async8614.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8616){
var self__ = this;
var _8616__$1 = this;
return self__.meta8615;
}));

(cljs.core.async.t_cljs$core$async8614.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async8614.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async8614.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async8614.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async8614.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta8615","meta8615",-216778322,null)], null);
}));

(cljs.core.async.t_cljs$core$async8614.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async8614.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8614");

(cljs.core.async.t_cljs$core$async8614.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async8614");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8614.
 */
cljs.core.async.__GT_t_cljs$core$async8614 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async8614(flag__$1,meta8615){
return (new cljs.core.async.t_cljs$core$async8614(flag__$1,meta8615));
});

}

return (new cljs.core.async.t_cljs$core$async8614(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async8617 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async8617 = (function (flag,cb,meta8618){
this.flag = flag;
this.cb = cb;
this.meta8618 = meta8618;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async8617.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_8619,meta8618__$1){
var self__ = this;
var _8619__$1 = this;
return (new cljs.core.async.t_cljs$core$async8617(self__.flag,self__.cb,meta8618__$1));
}));

(cljs.core.async.t_cljs$core$async8617.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_8619){
var self__ = this;
var _8619__$1 = this;
return self__.meta8618;
}));

(cljs.core.async.t_cljs$core$async8617.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async8617.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async8617.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async8617.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async8617.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta8618","meta8618",-1813828771,null)], null);
}));

(cljs.core.async.t_cljs$core$async8617.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async8617.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async8617");

(cljs.core.async.t_cljs$core$async8617.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async8617");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async8617.
 */
cljs.core.async.__GT_t_cljs$core$async8617 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async8617(flag__$1,cb__$1,meta8618){
return (new cljs.core.async.t_cljs$core$async8617(flag__$1,cb__$1,meta8618));
});

}

return (new cljs.core.async.t_cljs$core$async8617(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__8620_SHARP_){
var G__8622 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__8620_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__8622) : fret.call(null,G__8622));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__8621_SHARP_){
var G__8623 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__8621_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__8623) : fret.call(null,G__8623));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4126__auto__ = wport;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return port;
}
})()], null));
} else {
var G__8624 = (i + (1));
i = G__8624;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4126__auto__ = ret;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4115__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4115__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___8630 = arguments.length;
var i__4737__auto___8631 = (0);
while(true){
if((i__4737__auto___8631 < len__4736__auto___8630)){
args__4742__auto__.push((arguments[i__4737__auto___8631]));

var G__8632 = (i__4737__auto___8631 + (1));
i__4737__auto___8631 = G__8632;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__8627){
var map__8628 = p__8627;
var map__8628__$1 = (((((!((map__8628 == null))))?(((((map__8628.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__8628.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__8628):map__8628);
var opts = map__8628__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq8625){
var G__8626 = cljs.core.first(seq8625);
var seq8625__$1 = cljs.core.next(seq8625);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8626,seq8625__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__8634 = arguments.length;
switch (G__8634) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__8532__auto___8681 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = (function (state_8658){
var state_val_8659 = (state_8658[(1)]);
if((state_val_8659 === (7))){
var inst_8654 = (state_8658[(2)]);
var state_8658__$1 = state_8658;
var statearr_8660_8682 = state_8658__$1;
(statearr_8660_8682[(2)] = inst_8654);

(statearr_8660_8682[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8659 === (1))){
var state_8658__$1 = state_8658;
var statearr_8661_8683 = state_8658__$1;
(statearr_8661_8683[(2)] = null);

(statearr_8661_8683[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8659 === (4))){
var inst_8637 = (state_8658[(7)]);
var inst_8637__$1 = (state_8658[(2)]);
var inst_8638 = (inst_8637__$1 == null);
var state_8658__$1 = (function (){var statearr_8662 = state_8658;
(statearr_8662[(7)] = inst_8637__$1);

return statearr_8662;
})();
if(cljs.core.truth_(inst_8638)){
var statearr_8663_8684 = state_8658__$1;
(statearr_8663_8684[(1)] = (5));

} else {
var statearr_8664_8685 = state_8658__$1;
(statearr_8664_8685[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8659 === (13))){
var state_8658__$1 = state_8658;
var statearr_8665_8686 = state_8658__$1;
(statearr_8665_8686[(2)] = null);

(statearr_8665_8686[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8659 === (6))){
var inst_8637 = (state_8658[(7)]);
var state_8658__$1 = state_8658;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_8658__$1,(11),to,inst_8637);
} else {
if((state_val_8659 === (3))){
var inst_8656 = (state_8658[(2)]);
var state_8658__$1 = state_8658;
return cljs.core.async.impl.ioc_helpers.return_chan(state_8658__$1,inst_8656);
} else {
if((state_val_8659 === (12))){
var state_8658__$1 = state_8658;
var statearr_8666_8687 = state_8658__$1;
(statearr_8666_8687[(2)] = null);

(statearr_8666_8687[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8659 === (2))){
var state_8658__$1 = state_8658;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_8658__$1,(4),from);
} else {
if((state_val_8659 === (11))){
var inst_8647 = (state_8658[(2)]);
var state_8658__$1 = state_8658;
if(cljs.core.truth_(inst_8647)){
var statearr_8667_8688 = state_8658__$1;
(statearr_8667_8688[(1)] = (12));

} else {
var statearr_8668_8689 = state_8658__$1;
(statearr_8668_8689[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8659 === (9))){
var state_8658__$1 = state_8658;
var statearr_8669_8690 = state_8658__$1;
(statearr_8669_8690[(2)] = null);

(statearr_8669_8690[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8659 === (5))){
var state_8658__$1 = state_8658;
if(cljs.core.truth_(close_QMARK_)){
var statearr_8670_8691 = state_8658__$1;
(statearr_8670_8691[(1)] = (8));

} else {
var statearr_8671_8692 = state_8658__$1;
(statearr_8671_8692[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8659 === (14))){
var inst_8652 = (state_8658[(2)]);
var state_8658__$1 = state_8658;
var statearr_8672_8693 = state_8658__$1;
(statearr_8672_8693[(2)] = inst_8652);

(statearr_8672_8693[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8659 === (10))){
var inst_8644 = (state_8658[(2)]);
var state_8658__$1 = state_8658;
var statearr_8673_8694 = state_8658__$1;
(statearr_8673_8694[(2)] = inst_8644);

(statearr_8673_8694[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8659 === (8))){
var inst_8641 = cljs.core.async.close_BANG_(to);
var state_8658__$1 = state_8658;
var statearr_8674_8695 = state_8658__$1;
(statearr_8674_8695[(2)] = inst_8641);

(statearr_8674_8695[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__8458__auto__ = null;
var cljs$core$async$state_machine__8458__auto____0 = (function (){
var statearr_8675 = [null,null,null,null,null,null,null,null];
(statearr_8675[(0)] = cljs$core$async$state_machine__8458__auto__);

(statearr_8675[(1)] = (1));

return statearr_8675;
});
var cljs$core$async$state_machine__8458__auto____1 = (function (state_8658){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_8658);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e8676){var ex__8461__auto__ = e8676;
var statearr_8677_8696 = state_8658;
(statearr_8677_8696[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_8658[(4)]))){
var statearr_8678_8697 = state_8658;
(statearr_8678_8697[(1)] = cljs.core.first((state_8658[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8698 = state_8658;
state_8658 = G__8698;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$state_machine__8458__auto__ = function(state_8658){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8458__auto____1.call(this,state_8658);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8458__auto____0;
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8458__auto____1;
return cljs$core$async$state_machine__8458__auto__;
})()
})();
var state__8534__auto__ = (function (){var statearr_8679 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_8679[(6)] = c__8532__auto___8681);

return statearr_8679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__8699){
var vec__8700 = p__8699;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8700,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8700,(1),null);
var job = vec__8700;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__8532__auto___8876 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = (function (state_8707){
var state_val_8708 = (state_8707[(1)]);
if((state_val_8708 === (1))){
var state_8707__$1 = state_8707;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_8707__$1,(2),res,v);
} else {
if((state_val_8708 === (2))){
var inst_8704 = (state_8707[(2)]);
var inst_8705 = cljs.core.async.close_BANG_(res);
var state_8707__$1 = (function (){var statearr_8709 = state_8707;
(statearr_8709[(7)] = inst_8704);

return statearr_8709;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_8707__$1,inst_8705);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____0 = (function (){
var statearr_8710 = [null,null,null,null,null,null,null,null];
(statearr_8710[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__);

(statearr_8710[(1)] = (1));

return statearr_8710;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____1 = (function (state_8707){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_8707);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e8711){var ex__8461__auto__ = e8711;
var statearr_8712_8877 = state_8707;
(statearr_8712_8877[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_8707[(4)]))){
var statearr_8713_8878 = state_8707;
(statearr_8713_8878[(1)] = cljs.core.first((state_8707[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8879 = state_8707;
state_8707 = G__8879;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__ = function(state_8707){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____1.call(this,state_8707);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__;
})()
})();
var state__8534__auto__ = (function (){var statearr_8714 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_8714[(6)] = c__8532__auto___8876);

return statearr_8714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__8715){
var vec__8716 = p__8715;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8716,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8716,(1),null);
var job = vec__8716;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4613__auto___8880 = n;
var __8881 = (0);
while(true){
if((__8881 < n__4613__auto___8880)){
var G__8719_8882 = type;
var G__8719_8883__$1 = (((G__8719_8882 instanceof cljs.core.Keyword))?G__8719_8882.fqn:null);
switch (G__8719_8883__$1) {
case "compute":
var c__8532__auto___8885 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__8881,c__8532__auto___8885,G__8719_8882,G__8719_8883__$1,n__4613__auto___8880,jobs,results,process,async){
return (function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = ((function (__8881,c__8532__auto___8885,G__8719_8882,G__8719_8883__$1,n__4613__auto___8880,jobs,results,process,async){
return (function (state_8732){
var state_val_8733 = (state_8732[(1)]);
if((state_val_8733 === (1))){
var state_8732__$1 = state_8732;
var statearr_8734_8886 = state_8732__$1;
(statearr_8734_8886[(2)] = null);

(statearr_8734_8886[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8733 === (2))){
var state_8732__$1 = state_8732;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_8732__$1,(4),jobs);
} else {
if((state_val_8733 === (3))){
var inst_8730 = (state_8732[(2)]);
var state_8732__$1 = state_8732;
return cljs.core.async.impl.ioc_helpers.return_chan(state_8732__$1,inst_8730);
} else {
if((state_val_8733 === (4))){
var inst_8722 = (state_8732[(2)]);
var inst_8723 = process(inst_8722);
var state_8732__$1 = state_8732;
if(cljs.core.truth_(inst_8723)){
var statearr_8735_8887 = state_8732__$1;
(statearr_8735_8887[(1)] = (5));

} else {
var statearr_8736_8888 = state_8732__$1;
(statearr_8736_8888[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8733 === (5))){
var state_8732__$1 = state_8732;
var statearr_8737_8889 = state_8732__$1;
(statearr_8737_8889[(2)] = null);

(statearr_8737_8889[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8733 === (6))){
var state_8732__$1 = state_8732;
var statearr_8738_8890 = state_8732__$1;
(statearr_8738_8890[(2)] = null);

(statearr_8738_8890[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8733 === (7))){
var inst_8728 = (state_8732[(2)]);
var state_8732__$1 = state_8732;
var statearr_8739_8891 = state_8732__$1;
(statearr_8739_8891[(2)] = inst_8728);

(statearr_8739_8891[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__8881,c__8532__auto___8885,G__8719_8882,G__8719_8883__$1,n__4613__auto___8880,jobs,results,process,async))
;
return ((function (__8881,switch__8457__auto__,c__8532__auto___8885,G__8719_8882,G__8719_8883__$1,n__4613__auto___8880,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____0 = (function (){
var statearr_8740 = [null,null,null,null,null,null,null];
(statearr_8740[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__);

(statearr_8740[(1)] = (1));

return statearr_8740;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____1 = (function (state_8732){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_8732);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e8741){var ex__8461__auto__ = e8741;
var statearr_8742_8892 = state_8732;
(statearr_8742_8892[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_8732[(4)]))){
var statearr_8743_8893 = state_8732;
(statearr_8743_8893[(1)] = cljs.core.first((state_8732[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8894 = state_8732;
state_8732 = G__8894;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__ = function(state_8732){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____1.call(this,state_8732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__;
})()
;})(__8881,switch__8457__auto__,c__8532__auto___8885,G__8719_8882,G__8719_8883__$1,n__4613__auto___8880,jobs,results,process,async))
})();
var state__8534__auto__ = (function (){var statearr_8744 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_8744[(6)] = c__8532__auto___8885);

return statearr_8744;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
});})(__8881,c__8532__auto___8885,G__8719_8882,G__8719_8883__$1,n__4613__auto___8880,jobs,results,process,async))
);


break;
case "async":
var c__8532__auto___8895 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__8881,c__8532__auto___8895,G__8719_8882,G__8719_8883__$1,n__4613__auto___8880,jobs,results,process,async){
return (function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = ((function (__8881,c__8532__auto___8895,G__8719_8882,G__8719_8883__$1,n__4613__auto___8880,jobs,results,process,async){
return (function (state_8757){
var state_val_8758 = (state_8757[(1)]);
if((state_val_8758 === (1))){
var state_8757__$1 = state_8757;
var statearr_8759_8896 = state_8757__$1;
(statearr_8759_8896[(2)] = null);

(statearr_8759_8896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8758 === (2))){
var state_8757__$1 = state_8757;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_8757__$1,(4),jobs);
} else {
if((state_val_8758 === (3))){
var inst_8755 = (state_8757[(2)]);
var state_8757__$1 = state_8757;
return cljs.core.async.impl.ioc_helpers.return_chan(state_8757__$1,inst_8755);
} else {
if((state_val_8758 === (4))){
var inst_8747 = (state_8757[(2)]);
var inst_8748 = async(inst_8747);
var state_8757__$1 = state_8757;
if(cljs.core.truth_(inst_8748)){
var statearr_8760_8897 = state_8757__$1;
(statearr_8760_8897[(1)] = (5));

} else {
var statearr_8761_8898 = state_8757__$1;
(statearr_8761_8898[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8758 === (5))){
var state_8757__$1 = state_8757;
var statearr_8762_8899 = state_8757__$1;
(statearr_8762_8899[(2)] = null);

(statearr_8762_8899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8758 === (6))){
var state_8757__$1 = state_8757;
var statearr_8763_8900 = state_8757__$1;
(statearr_8763_8900[(2)] = null);

(statearr_8763_8900[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8758 === (7))){
var inst_8753 = (state_8757[(2)]);
var state_8757__$1 = state_8757;
var statearr_8764_8901 = state_8757__$1;
(statearr_8764_8901[(2)] = inst_8753);

(statearr_8764_8901[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__8881,c__8532__auto___8895,G__8719_8882,G__8719_8883__$1,n__4613__auto___8880,jobs,results,process,async))
;
return ((function (__8881,switch__8457__auto__,c__8532__auto___8895,G__8719_8882,G__8719_8883__$1,n__4613__auto___8880,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____0 = (function (){
var statearr_8765 = [null,null,null,null,null,null,null];
(statearr_8765[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__);

(statearr_8765[(1)] = (1));

return statearr_8765;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____1 = (function (state_8757){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_8757);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e8766){var ex__8461__auto__ = e8766;
var statearr_8767_8902 = state_8757;
(statearr_8767_8902[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_8757[(4)]))){
var statearr_8768_8903 = state_8757;
(statearr_8768_8903[(1)] = cljs.core.first((state_8757[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8904 = state_8757;
state_8757 = G__8904;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__ = function(state_8757){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____1.call(this,state_8757);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__;
})()
;})(__8881,switch__8457__auto__,c__8532__auto___8895,G__8719_8882,G__8719_8883__$1,n__4613__auto___8880,jobs,results,process,async))
})();
var state__8534__auto__ = (function (){var statearr_8769 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_8769[(6)] = c__8532__auto___8895);

return statearr_8769;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
});})(__8881,c__8532__auto___8895,G__8719_8882,G__8719_8883__$1,n__4613__auto___8880,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__8719_8883__$1)].join('')));

}

var G__8905 = (__8881 + (1));
__8881 = G__8905;
continue;
} else {
}
break;
}

var c__8532__auto___8906 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = (function (state_8791){
var state_val_8792 = (state_8791[(1)]);
if((state_val_8792 === (7))){
var inst_8787 = (state_8791[(2)]);
var state_8791__$1 = state_8791;
var statearr_8793_8907 = state_8791__$1;
(statearr_8793_8907[(2)] = inst_8787);

(statearr_8793_8907[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8792 === (1))){
var state_8791__$1 = state_8791;
var statearr_8794_8908 = state_8791__$1;
(statearr_8794_8908[(2)] = null);

(statearr_8794_8908[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8792 === (4))){
var inst_8772 = (state_8791[(7)]);
var inst_8772__$1 = (state_8791[(2)]);
var inst_8773 = (inst_8772__$1 == null);
var state_8791__$1 = (function (){var statearr_8795 = state_8791;
(statearr_8795[(7)] = inst_8772__$1);

return statearr_8795;
})();
if(cljs.core.truth_(inst_8773)){
var statearr_8796_8909 = state_8791__$1;
(statearr_8796_8909[(1)] = (5));

} else {
var statearr_8797_8910 = state_8791__$1;
(statearr_8797_8910[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8792 === (6))){
var inst_8772 = (state_8791[(7)]);
var inst_8777 = (state_8791[(8)]);
var inst_8777__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_8778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_8779 = [inst_8772,inst_8777__$1];
var inst_8780 = (new cljs.core.PersistentVector(null,2,(5),inst_8778,inst_8779,null));
var state_8791__$1 = (function (){var statearr_8798 = state_8791;
(statearr_8798[(8)] = inst_8777__$1);

return statearr_8798;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_8791__$1,(8),jobs,inst_8780);
} else {
if((state_val_8792 === (3))){
var inst_8789 = (state_8791[(2)]);
var state_8791__$1 = state_8791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_8791__$1,inst_8789);
} else {
if((state_val_8792 === (2))){
var state_8791__$1 = state_8791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_8791__$1,(4),from);
} else {
if((state_val_8792 === (9))){
var inst_8784 = (state_8791[(2)]);
var state_8791__$1 = (function (){var statearr_8799 = state_8791;
(statearr_8799[(9)] = inst_8784);

return statearr_8799;
})();
var statearr_8800_8911 = state_8791__$1;
(statearr_8800_8911[(2)] = null);

(statearr_8800_8911[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8792 === (5))){
var inst_8775 = cljs.core.async.close_BANG_(jobs);
var state_8791__$1 = state_8791;
var statearr_8801_8912 = state_8791__$1;
(statearr_8801_8912[(2)] = inst_8775);

(statearr_8801_8912[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8792 === (8))){
var inst_8777 = (state_8791[(8)]);
var inst_8782 = (state_8791[(2)]);
var state_8791__$1 = (function (){var statearr_8802 = state_8791;
(statearr_8802[(10)] = inst_8782);

return statearr_8802;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_8791__$1,(9),results,inst_8777);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____0 = (function (){
var statearr_8803 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_8803[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__);

(statearr_8803[(1)] = (1));

return statearr_8803;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____1 = (function (state_8791){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_8791);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e8804){var ex__8461__auto__ = e8804;
var statearr_8805_8913 = state_8791;
(statearr_8805_8913[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_8791[(4)]))){
var statearr_8806_8914 = state_8791;
(statearr_8806_8914[(1)] = cljs.core.first((state_8791[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8915 = state_8791;
state_8791 = G__8915;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__ = function(state_8791){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____1.call(this,state_8791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__;
})()
})();
var state__8534__auto__ = (function (){var statearr_8807 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_8807[(6)] = c__8532__auto___8906);

return statearr_8807;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
}));


var c__8532__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = (function (state_8845){
var state_val_8846 = (state_8845[(1)]);
if((state_val_8846 === (7))){
var inst_8841 = (state_8845[(2)]);
var state_8845__$1 = state_8845;
var statearr_8847_8916 = state_8845__$1;
(statearr_8847_8916[(2)] = inst_8841);

(statearr_8847_8916[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8846 === (20))){
var state_8845__$1 = state_8845;
var statearr_8848_8917 = state_8845__$1;
(statearr_8848_8917[(2)] = null);

(statearr_8848_8917[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8846 === (1))){
var state_8845__$1 = state_8845;
var statearr_8849_8918 = state_8845__$1;
(statearr_8849_8918[(2)] = null);

(statearr_8849_8918[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8846 === (4))){
var inst_8810 = (state_8845[(7)]);
var inst_8810__$1 = (state_8845[(2)]);
var inst_8811 = (inst_8810__$1 == null);
var state_8845__$1 = (function (){var statearr_8850 = state_8845;
(statearr_8850[(7)] = inst_8810__$1);

return statearr_8850;
})();
if(cljs.core.truth_(inst_8811)){
var statearr_8851_8919 = state_8845__$1;
(statearr_8851_8919[(1)] = (5));

} else {
var statearr_8852_8920 = state_8845__$1;
(statearr_8852_8920[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8846 === (15))){
var inst_8823 = (state_8845[(8)]);
var state_8845__$1 = state_8845;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_8845__$1,(18),to,inst_8823);
} else {
if((state_val_8846 === (21))){
var inst_8836 = (state_8845[(2)]);
var state_8845__$1 = state_8845;
var statearr_8853_8921 = state_8845__$1;
(statearr_8853_8921[(2)] = inst_8836);

(statearr_8853_8921[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8846 === (13))){
var inst_8838 = (state_8845[(2)]);
var state_8845__$1 = (function (){var statearr_8854 = state_8845;
(statearr_8854[(9)] = inst_8838);

return statearr_8854;
})();
var statearr_8855_8922 = state_8845__$1;
(statearr_8855_8922[(2)] = null);

(statearr_8855_8922[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8846 === (6))){
var inst_8810 = (state_8845[(7)]);
var state_8845__$1 = state_8845;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_8845__$1,(11),inst_8810);
} else {
if((state_val_8846 === (17))){
var inst_8831 = (state_8845[(2)]);
var state_8845__$1 = state_8845;
if(cljs.core.truth_(inst_8831)){
var statearr_8856_8923 = state_8845__$1;
(statearr_8856_8923[(1)] = (19));

} else {
var statearr_8857_8924 = state_8845__$1;
(statearr_8857_8924[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8846 === (3))){
var inst_8843 = (state_8845[(2)]);
var state_8845__$1 = state_8845;
return cljs.core.async.impl.ioc_helpers.return_chan(state_8845__$1,inst_8843);
} else {
if((state_val_8846 === (12))){
var inst_8820 = (state_8845[(10)]);
var state_8845__$1 = state_8845;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_8845__$1,(14),inst_8820);
} else {
if((state_val_8846 === (2))){
var state_8845__$1 = state_8845;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_8845__$1,(4),results);
} else {
if((state_val_8846 === (19))){
var state_8845__$1 = state_8845;
var statearr_8858_8925 = state_8845__$1;
(statearr_8858_8925[(2)] = null);

(statearr_8858_8925[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8846 === (11))){
var inst_8820 = (state_8845[(2)]);
var state_8845__$1 = (function (){var statearr_8859 = state_8845;
(statearr_8859[(10)] = inst_8820);

return statearr_8859;
})();
var statearr_8860_8926 = state_8845__$1;
(statearr_8860_8926[(2)] = null);

(statearr_8860_8926[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8846 === (9))){
var state_8845__$1 = state_8845;
var statearr_8861_8927 = state_8845__$1;
(statearr_8861_8927[(2)] = null);

(statearr_8861_8927[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8846 === (5))){
var state_8845__$1 = state_8845;
if(cljs.core.truth_(close_QMARK_)){
var statearr_8862_8928 = state_8845__$1;
(statearr_8862_8928[(1)] = (8));

} else {
var statearr_8863_8929 = state_8845__$1;
(statearr_8863_8929[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8846 === (14))){
var inst_8823 = (state_8845[(8)]);
var inst_8823__$1 = (state_8845[(2)]);
var inst_8824 = (inst_8823__$1 == null);
var inst_8825 = cljs.core.not(inst_8824);
var state_8845__$1 = (function (){var statearr_8864 = state_8845;
(statearr_8864[(8)] = inst_8823__$1);

return statearr_8864;
})();
if(inst_8825){
var statearr_8865_8930 = state_8845__$1;
(statearr_8865_8930[(1)] = (15));

} else {
var statearr_8866_8931 = state_8845__$1;
(statearr_8866_8931[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8846 === (16))){
var state_8845__$1 = state_8845;
var statearr_8867_8932 = state_8845__$1;
(statearr_8867_8932[(2)] = false);

(statearr_8867_8932[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8846 === (10))){
var inst_8817 = (state_8845[(2)]);
var state_8845__$1 = state_8845;
var statearr_8868_8933 = state_8845__$1;
(statearr_8868_8933[(2)] = inst_8817);

(statearr_8868_8933[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8846 === (18))){
var inst_8828 = (state_8845[(2)]);
var state_8845__$1 = state_8845;
var statearr_8869_8934 = state_8845__$1;
(statearr_8869_8934[(2)] = inst_8828);

(statearr_8869_8934[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8846 === (8))){
var inst_8814 = cljs.core.async.close_BANG_(to);
var state_8845__$1 = state_8845;
var statearr_8870_8935 = state_8845__$1;
(statearr_8870_8935[(2)] = inst_8814);

(statearr_8870_8935[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____0 = (function (){
var statearr_8871 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_8871[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__);

(statearr_8871[(1)] = (1));

return statearr_8871;
});
var cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____1 = (function (state_8845){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_8845);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e8872){var ex__8461__auto__ = e8872;
var statearr_8873_8936 = state_8845;
(statearr_8873_8936[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_8845[(4)]))){
var statearr_8874_8937 = state_8845;
(statearr_8874_8937[(1)] = cljs.core.first((state_8845[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8938 = state_8845;
state_8845 = G__8938;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__ = function(state_8845){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____1.call(this,state_8845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__8458__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__8458__auto__;
})()
})();
var state__8534__auto__ = (function (){var statearr_8875 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_8875[(6)] = c__8532__auto__);

return statearr_8875;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
}));

return c__8532__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__8940 = arguments.length;
switch (G__8940) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__8943 = arguments.length;
switch (G__8943) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__8946 = arguments.length;
switch (G__8946) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__8532__auto___8996 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = (function (state_8972){
var state_val_8973 = (state_8972[(1)]);
if((state_val_8973 === (7))){
var inst_8968 = (state_8972[(2)]);
var state_8972__$1 = state_8972;
var statearr_8974_8997 = state_8972__$1;
(statearr_8974_8997[(2)] = inst_8968);

(statearr_8974_8997[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8973 === (1))){
var state_8972__$1 = state_8972;
var statearr_8975_8998 = state_8972__$1;
(statearr_8975_8998[(2)] = null);

(statearr_8975_8998[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8973 === (4))){
var inst_8949 = (state_8972[(7)]);
var inst_8949__$1 = (state_8972[(2)]);
var inst_8950 = (inst_8949__$1 == null);
var state_8972__$1 = (function (){var statearr_8976 = state_8972;
(statearr_8976[(7)] = inst_8949__$1);

return statearr_8976;
})();
if(cljs.core.truth_(inst_8950)){
var statearr_8977_8999 = state_8972__$1;
(statearr_8977_8999[(1)] = (5));

} else {
var statearr_8978_9000 = state_8972__$1;
(statearr_8978_9000[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8973 === (13))){
var state_8972__$1 = state_8972;
var statearr_8979_9001 = state_8972__$1;
(statearr_8979_9001[(2)] = null);

(statearr_8979_9001[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8973 === (6))){
var inst_8949 = (state_8972[(7)]);
var inst_8955 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_8949) : p.call(null,inst_8949));
var state_8972__$1 = state_8972;
if(cljs.core.truth_(inst_8955)){
var statearr_8980_9002 = state_8972__$1;
(statearr_8980_9002[(1)] = (9));

} else {
var statearr_8981_9003 = state_8972__$1;
(statearr_8981_9003[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8973 === (3))){
var inst_8970 = (state_8972[(2)]);
var state_8972__$1 = state_8972;
return cljs.core.async.impl.ioc_helpers.return_chan(state_8972__$1,inst_8970);
} else {
if((state_val_8973 === (12))){
var state_8972__$1 = state_8972;
var statearr_8982_9004 = state_8972__$1;
(statearr_8982_9004[(2)] = null);

(statearr_8982_9004[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8973 === (2))){
var state_8972__$1 = state_8972;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_8972__$1,(4),ch);
} else {
if((state_val_8973 === (11))){
var inst_8949 = (state_8972[(7)]);
var inst_8959 = (state_8972[(2)]);
var state_8972__$1 = state_8972;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_8972__$1,(8),inst_8959,inst_8949);
} else {
if((state_val_8973 === (9))){
var state_8972__$1 = state_8972;
var statearr_8983_9005 = state_8972__$1;
(statearr_8983_9005[(2)] = tc);

(statearr_8983_9005[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8973 === (5))){
var inst_8952 = cljs.core.async.close_BANG_(tc);
var inst_8953 = cljs.core.async.close_BANG_(fc);
var state_8972__$1 = (function (){var statearr_8984 = state_8972;
(statearr_8984[(8)] = inst_8952);

return statearr_8984;
})();
var statearr_8985_9006 = state_8972__$1;
(statearr_8985_9006[(2)] = inst_8953);

(statearr_8985_9006[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8973 === (14))){
var inst_8966 = (state_8972[(2)]);
var state_8972__$1 = state_8972;
var statearr_8986_9007 = state_8972__$1;
(statearr_8986_9007[(2)] = inst_8966);

(statearr_8986_9007[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8973 === (10))){
var state_8972__$1 = state_8972;
var statearr_8987_9008 = state_8972__$1;
(statearr_8987_9008[(2)] = fc);

(statearr_8987_9008[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_8973 === (8))){
var inst_8961 = (state_8972[(2)]);
var state_8972__$1 = state_8972;
if(cljs.core.truth_(inst_8961)){
var statearr_8988_9009 = state_8972__$1;
(statearr_8988_9009[(1)] = (12));

} else {
var statearr_8989_9010 = state_8972__$1;
(statearr_8989_9010[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__8458__auto__ = null;
var cljs$core$async$state_machine__8458__auto____0 = (function (){
var statearr_8990 = [null,null,null,null,null,null,null,null,null];
(statearr_8990[(0)] = cljs$core$async$state_machine__8458__auto__);

(statearr_8990[(1)] = (1));

return statearr_8990;
});
var cljs$core$async$state_machine__8458__auto____1 = (function (state_8972){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_8972);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e8991){var ex__8461__auto__ = e8991;
var statearr_8992_9011 = state_8972;
(statearr_8992_9011[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_8972[(4)]))){
var statearr_8993_9012 = state_8972;
(statearr_8993_9012[(1)] = cljs.core.first((state_8972[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9013 = state_8972;
state_8972 = G__9013;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$state_machine__8458__auto__ = function(state_8972){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8458__auto____1.call(this,state_8972);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8458__auto____0;
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8458__auto____1;
return cljs$core$async$state_machine__8458__auto__;
})()
})();
var state__8534__auto__ = (function (){var statearr_8994 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_8994[(6)] = c__8532__auto___8996);

return statearr_8994;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__8532__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = (function (state_9035){
var state_val_9036 = (state_9035[(1)]);
if((state_val_9036 === (7))){
var inst_9031 = (state_9035[(2)]);
var state_9035__$1 = state_9035;
var statearr_9037_9056 = state_9035__$1;
(statearr_9037_9056[(2)] = inst_9031);

(statearr_9037_9056[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9036 === (1))){
var inst_9014 = init;
var inst_9015 = inst_9014;
var state_9035__$1 = (function (){var statearr_9038 = state_9035;
(statearr_9038[(7)] = inst_9015);

return statearr_9038;
})();
var statearr_9039_9057 = state_9035__$1;
(statearr_9039_9057[(2)] = null);

(statearr_9039_9057[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9036 === (4))){
var inst_9018 = (state_9035[(8)]);
var inst_9018__$1 = (state_9035[(2)]);
var inst_9019 = (inst_9018__$1 == null);
var state_9035__$1 = (function (){var statearr_9040 = state_9035;
(statearr_9040[(8)] = inst_9018__$1);

return statearr_9040;
})();
if(cljs.core.truth_(inst_9019)){
var statearr_9041_9058 = state_9035__$1;
(statearr_9041_9058[(1)] = (5));

} else {
var statearr_9042_9059 = state_9035__$1;
(statearr_9042_9059[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9036 === (6))){
var inst_9015 = (state_9035[(7)]);
var inst_9018 = (state_9035[(8)]);
var inst_9022 = (state_9035[(9)]);
var inst_9022__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_9015,inst_9018) : f.call(null,inst_9015,inst_9018));
var inst_9023 = cljs.core.reduced_QMARK_(inst_9022__$1);
var state_9035__$1 = (function (){var statearr_9043 = state_9035;
(statearr_9043[(9)] = inst_9022__$1);

return statearr_9043;
})();
if(inst_9023){
var statearr_9044_9060 = state_9035__$1;
(statearr_9044_9060[(1)] = (8));

} else {
var statearr_9045_9061 = state_9035__$1;
(statearr_9045_9061[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9036 === (3))){
var inst_9033 = (state_9035[(2)]);
var state_9035__$1 = state_9035;
return cljs.core.async.impl.ioc_helpers.return_chan(state_9035__$1,inst_9033);
} else {
if((state_val_9036 === (2))){
var state_9035__$1 = state_9035;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_9035__$1,(4),ch);
} else {
if((state_val_9036 === (9))){
var inst_9022 = (state_9035[(9)]);
var inst_9015 = inst_9022;
var state_9035__$1 = (function (){var statearr_9046 = state_9035;
(statearr_9046[(7)] = inst_9015);

return statearr_9046;
})();
var statearr_9047_9062 = state_9035__$1;
(statearr_9047_9062[(2)] = null);

(statearr_9047_9062[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9036 === (5))){
var inst_9015 = (state_9035[(7)]);
var state_9035__$1 = state_9035;
var statearr_9048_9063 = state_9035__$1;
(statearr_9048_9063[(2)] = inst_9015);

(statearr_9048_9063[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9036 === (10))){
var inst_9029 = (state_9035[(2)]);
var state_9035__$1 = state_9035;
var statearr_9049_9064 = state_9035__$1;
(statearr_9049_9064[(2)] = inst_9029);

(statearr_9049_9064[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9036 === (8))){
var inst_9022 = (state_9035[(9)]);
var inst_9025 = cljs.core.deref(inst_9022);
var state_9035__$1 = state_9035;
var statearr_9050_9065 = state_9035__$1;
(statearr_9050_9065[(2)] = inst_9025);

(statearr_9050_9065[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__8458__auto__ = null;
var cljs$core$async$reduce_$_state_machine__8458__auto____0 = (function (){
var statearr_9051 = [null,null,null,null,null,null,null,null,null,null];
(statearr_9051[(0)] = cljs$core$async$reduce_$_state_machine__8458__auto__);

(statearr_9051[(1)] = (1));

return statearr_9051;
});
var cljs$core$async$reduce_$_state_machine__8458__auto____1 = (function (state_9035){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_9035);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e9052){var ex__8461__auto__ = e9052;
var statearr_9053_9066 = state_9035;
(statearr_9053_9066[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_9035[(4)]))){
var statearr_9054_9067 = state_9035;
(statearr_9054_9067[(1)] = cljs.core.first((state_9035[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9068 = state_9035;
state_9035 = G__9068;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__8458__auto__ = function(state_9035){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__8458__auto____1.call(this,state_9035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__8458__auto____0;
cljs$core$async$reduce_$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__8458__auto____1;
return cljs$core$async$reduce_$_state_machine__8458__auto__;
})()
})();
var state__8534__auto__ = (function (){var statearr_9055 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_9055[(6)] = c__8532__auto__);

return statearr_9055;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
}));

return c__8532__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__8532__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = (function (state_9074){
var state_val_9075 = (state_9074[(1)]);
if((state_val_9075 === (1))){
var inst_9069 = cljs.core.async.reduce(f__$1,init,ch);
var state_9074__$1 = state_9074;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_9074__$1,(2),inst_9069);
} else {
if((state_val_9075 === (2))){
var inst_9071 = (state_9074[(2)]);
var inst_9072 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_9071) : f__$1.call(null,inst_9071));
var state_9074__$1 = state_9074;
return cljs.core.async.impl.ioc_helpers.return_chan(state_9074__$1,inst_9072);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__8458__auto__ = null;
var cljs$core$async$transduce_$_state_machine__8458__auto____0 = (function (){
var statearr_9076 = [null,null,null,null,null,null,null];
(statearr_9076[(0)] = cljs$core$async$transduce_$_state_machine__8458__auto__);

(statearr_9076[(1)] = (1));

return statearr_9076;
});
var cljs$core$async$transduce_$_state_machine__8458__auto____1 = (function (state_9074){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_9074);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e9077){var ex__8461__auto__ = e9077;
var statearr_9078_9081 = state_9074;
(statearr_9078_9081[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_9074[(4)]))){
var statearr_9079_9082 = state_9074;
(statearr_9079_9082[(1)] = cljs.core.first((state_9074[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9083 = state_9074;
state_9074 = G__9083;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__8458__auto__ = function(state_9074){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__8458__auto____1.call(this,state_9074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__8458__auto____0;
cljs$core$async$transduce_$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__8458__auto____1;
return cljs$core$async$transduce_$_state_machine__8458__auto__;
})()
})();
var state__8534__auto__ = (function (){var statearr_9080 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_9080[(6)] = c__8532__auto__);

return statearr_9080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
}));

return c__8532__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__9085 = arguments.length;
switch (G__9085) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__8532__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = (function (state_9110){
var state_val_9111 = (state_9110[(1)]);
if((state_val_9111 === (7))){
var inst_9092 = (state_9110[(2)]);
var state_9110__$1 = state_9110;
var statearr_9112_9134 = state_9110__$1;
(statearr_9112_9134[(2)] = inst_9092);

(statearr_9112_9134[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9111 === (1))){
var inst_9086 = cljs.core.seq(coll);
var inst_9087 = inst_9086;
var state_9110__$1 = (function (){var statearr_9113 = state_9110;
(statearr_9113[(7)] = inst_9087);

return statearr_9113;
})();
var statearr_9114_9135 = state_9110__$1;
(statearr_9114_9135[(2)] = null);

(statearr_9114_9135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9111 === (4))){
var inst_9087 = (state_9110[(7)]);
var inst_9090 = cljs.core.first(inst_9087);
var state_9110__$1 = state_9110;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_9110__$1,(7),ch,inst_9090);
} else {
if((state_val_9111 === (13))){
var inst_9104 = (state_9110[(2)]);
var state_9110__$1 = state_9110;
var statearr_9115_9136 = state_9110__$1;
(statearr_9115_9136[(2)] = inst_9104);

(statearr_9115_9136[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9111 === (6))){
var inst_9095 = (state_9110[(2)]);
var state_9110__$1 = state_9110;
if(cljs.core.truth_(inst_9095)){
var statearr_9116_9137 = state_9110__$1;
(statearr_9116_9137[(1)] = (8));

} else {
var statearr_9117_9138 = state_9110__$1;
(statearr_9117_9138[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9111 === (3))){
var inst_9108 = (state_9110[(2)]);
var state_9110__$1 = state_9110;
return cljs.core.async.impl.ioc_helpers.return_chan(state_9110__$1,inst_9108);
} else {
if((state_val_9111 === (12))){
var state_9110__$1 = state_9110;
var statearr_9118_9139 = state_9110__$1;
(statearr_9118_9139[(2)] = null);

(statearr_9118_9139[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9111 === (2))){
var inst_9087 = (state_9110[(7)]);
var state_9110__$1 = state_9110;
if(cljs.core.truth_(inst_9087)){
var statearr_9119_9140 = state_9110__$1;
(statearr_9119_9140[(1)] = (4));

} else {
var statearr_9120_9141 = state_9110__$1;
(statearr_9120_9141[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9111 === (11))){
var inst_9101 = cljs.core.async.close_BANG_(ch);
var state_9110__$1 = state_9110;
var statearr_9121_9142 = state_9110__$1;
(statearr_9121_9142[(2)] = inst_9101);

(statearr_9121_9142[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9111 === (9))){
var state_9110__$1 = state_9110;
if(cljs.core.truth_(close_QMARK_)){
var statearr_9122_9143 = state_9110__$1;
(statearr_9122_9143[(1)] = (11));

} else {
var statearr_9123_9144 = state_9110__$1;
(statearr_9123_9144[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9111 === (5))){
var inst_9087 = (state_9110[(7)]);
var state_9110__$1 = state_9110;
var statearr_9124_9145 = state_9110__$1;
(statearr_9124_9145[(2)] = inst_9087);

(statearr_9124_9145[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9111 === (10))){
var inst_9106 = (state_9110[(2)]);
var state_9110__$1 = state_9110;
var statearr_9125_9146 = state_9110__$1;
(statearr_9125_9146[(2)] = inst_9106);

(statearr_9125_9146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9111 === (8))){
var inst_9087 = (state_9110[(7)]);
var inst_9097 = cljs.core.next(inst_9087);
var inst_9087__$1 = inst_9097;
var state_9110__$1 = (function (){var statearr_9126 = state_9110;
(statearr_9126[(7)] = inst_9087__$1);

return statearr_9126;
})();
var statearr_9127_9147 = state_9110__$1;
(statearr_9127_9147[(2)] = null);

(statearr_9127_9147[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__8458__auto__ = null;
var cljs$core$async$state_machine__8458__auto____0 = (function (){
var statearr_9128 = [null,null,null,null,null,null,null,null];
(statearr_9128[(0)] = cljs$core$async$state_machine__8458__auto__);

(statearr_9128[(1)] = (1));

return statearr_9128;
});
var cljs$core$async$state_machine__8458__auto____1 = (function (state_9110){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_9110);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e9129){var ex__8461__auto__ = e9129;
var statearr_9130_9148 = state_9110;
(statearr_9130_9148[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_9110[(4)]))){
var statearr_9131_9149 = state_9110;
(statearr_9131_9149[(1)] = cljs.core.first((state_9110[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9150 = state_9110;
state_9110 = G__9150;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$state_machine__8458__auto__ = function(state_9110){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8458__auto____1.call(this,state_9110);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8458__auto____0;
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8458__auto____1;
return cljs$core$async$state_machine__8458__auto__;
})()
})();
var state__8534__auto__ = (function (){var statearr_9132 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_9132[(6)] = c__8532__auto__);

return statearr_9132;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
}));

return c__8532__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__9152 = arguments.length;
switch (G__9152) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_9154 = (function (_){
var x__4428__auto__ = (((_ == null))?null:_);
var m__4429__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4429__auto__.call(null,_));
} else {
var m__4426__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4426__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_9154(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_9155 = (function (m,ch,close_QMARK_){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4429__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4426__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_9155(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_9156 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_9156(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_9157 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_9157(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async9158 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async9158 = (function (ch,cs,meta9159){
this.ch = ch;
this.cs = cs;
this.meta9159 = meta9159;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async9158.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_9160,meta9159__$1){
var self__ = this;
var _9160__$1 = this;
return (new cljs.core.async.t_cljs$core$async9158(self__.ch,self__.cs,meta9159__$1));
}));

(cljs.core.async.t_cljs$core$async9158.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_9160){
var self__ = this;
var _9160__$1 = this;
return self__.meta9159;
}));

(cljs.core.async.t_cljs$core$async9158.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async9158.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async9158.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async9158.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async9158.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async9158.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async9158.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta9159","meta9159",590552223,null)], null);
}));

(cljs.core.async.t_cljs$core$async9158.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async9158.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async9158");

(cljs.core.async.t_cljs$core$async9158.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async9158");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async9158.
 */
cljs.core.async.__GT_t_cljs$core$async9158 = (function cljs$core$async$mult_$___GT_t_cljs$core$async9158(ch__$1,cs__$1,meta9159){
return (new cljs.core.async.t_cljs$core$async9158(ch__$1,cs__$1,meta9159));
});

}

return (new cljs.core.async.t_cljs$core$async9158(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__8532__auto___9377 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = (function (state_9293){
var state_val_9294 = (state_9293[(1)]);
if((state_val_9294 === (7))){
var inst_9289 = (state_9293[(2)]);
var state_9293__$1 = state_9293;
var statearr_9295_9378 = state_9293__$1;
(statearr_9295_9378[(2)] = inst_9289);

(statearr_9295_9378[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (20))){
var inst_9194 = (state_9293[(7)]);
var inst_9206 = cljs.core.first(inst_9194);
var inst_9207 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_9206,(0),null);
var inst_9208 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_9206,(1),null);
var state_9293__$1 = (function (){var statearr_9296 = state_9293;
(statearr_9296[(8)] = inst_9207);

return statearr_9296;
})();
if(cljs.core.truth_(inst_9208)){
var statearr_9297_9379 = state_9293__$1;
(statearr_9297_9379[(1)] = (22));

} else {
var statearr_9298_9380 = state_9293__$1;
(statearr_9298_9380[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (27))){
var inst_9163 = (state_9293[(9)]);
var inst_9243 = (state_9293[(10)]);
var inst_9236 = (state_9293[(11)]);
var inst_9238 = (state_9293[(12)]);
var inst_9243__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_9236,inst_9238);
var inst_9244 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_9243__$1,inst_9163,done);
var state_9293__$1 = (function (){var statearr_9299 = state_9293;
(statearr_9299[(10)] = inst_9243__$1);

return statearr_9299;
})();
if(cljs.core.truth_(inst_9244)){
var statearr_9300_9381 = state_9293__$1;
(statearr_9300_9381[(1)] = (30));

} else {
var statearr_9301_9382 = state_9293__$1;
(statearr_9301_9382[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (1))){
var state_9293__$1 = state_9293;
var statearr_9302_9383 = state_9293__$1;
(statearr_9302_9383[(2)] = null);

(statearr_9302_9383[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (24))){
var inst_9194 = (state_9293[(7)]);
var inst_9213 = (state_9293[(2)]);
var inst_9214 = cljs.core.next(inst_9194);
var inst_9172 = inst_9214;
var inst_9173 = null;
var inst_9174 = (0);
var inst_9175 = (0);
var state_9293__$1 = (function (){var statearr_9303 = state_9293;
(statearr_9303[(13)] = inst_9175);

(statearr_9303[(14)] = inst_9172);

(statearr_9303[(15)] = inst_9213);

(statearr_9303[(16)] = inst_9174);

(statearr_9303[(17)] = inst_9173);

return statearr_9303;
})();
var statearr_9304_9384 = state_9293__$1;
(statearr_9304_9384[(2)] = null);

(statearr_9304_9384[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (39))){
var state_9293__$1 = state_9293;
var statearr_9308_9385 = state_9293__$1;
(statearr_9308_9385[(2)] = null);

(statearr_9308_9385[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (4))){
var inst_9163 = (state_9293[(9)]);
var inst_9163__$1 = (state_9293[(2)]);
var inst_9164 = (inst_9163__$1 == null);
var state_9293__$1 = (function (){var statearr_9309 = state_9293;
(statearr_9309[(9)] = inst_9163__$1);

return statearr_9309;
})();
if(cljs.core.truth_(inst_9164)){
var statearr_9310_9386 = state_9293__$1;
(statearr_9310_9386[(1)] = (5));

} else {
var statearr_9311_9387 = state_9293__$1;
(statearr_9311_9387[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (15))){
var inst_9175 = (state_9293[(13)]);
var inst_9172 = (state_9293[(14)]);
var inst_9174 = (state_9293[(16)]);
var inst_9173 = (state_9293[(17)]);
var inst_9190 = (state_9293[(2)]);
var inst_9191 = (inst_9175 + (1));
var tmp9305 = inst_9172;
var tmp9306 = inst_9174;
var tmp9307 = inst_9173;
var inst_9172__$1 = tmp9305;
var inst_9173__$1 = tmp9307;
var inst_9174__$1 = tmp9306;
var inst_9175__$1 = inst_9191;
var state_9293__$1 = (function (){var statearr_9312 = state_9293;
(statearr_9312[(13)] = inst_9175__$1);

(statearr_9312[(14)] = inst_9172__$1);

(statearr_9312[(18)] = inst_9190);

(statearr_9312[(16)] = inst_9174__$1);

(statearr_9312[(17)] = inst_9173__$1);

return statearr_9312;
})();
var statearr_9313_9388 = state_9293__$1;
(statearr_9313_9388[(2)] = null);

(statearr_9313_9388[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (21))){
var inst_9217 = (state_9293[(2)]);
var state_9293__$1 = state_9293;
var statearr_9317_9389 = state_9293__$1;
(statearr_9317_9389[(2)] = inst_9217);

(statearr_9317_9389[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (31))){
var inst_9243 = (state_9293[(10)]);
var inst_9247 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_9243);
var state_9293__$1 = state_9293;
var statearr_9318_9390 = state_9293__$1;
(statearr_9318_9390[(2)] = inst_9247);

(statearr_9318_9390[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (32))){
var inst_9237 = (state_9293[(19)]);
var inst_9235 = (state_9293[(20)]);
var inst_9236 = (state_9293[(11)]);
var inst_9238 = (state_9293[(12)]);
var inst_9249 = (state_9293[(2)]);
var inst_9250 = (inst_9238 + (1));
var tmp9314 = inst_9237;
var tmp9315 = inst_9235;
var tmp9316 = inst_9236;
var inst_9235__$1 = tmp9315;
var inst_9236__$1 = tmp9316;
var inst_9237__$1 = tmp9314;
var inst_9238__$1 = inst_9250;
var state_9293__$1 = (function (){var statearr_9319 = state_9293;
(statearr_9319[(19)] = inst_9237__$1);

(statearr_9319[(20)] = inst_9235__$1);

(statearr_9319[(21)] = inst_9249);

(statearr_9319[(11)] = inst_9236__$1);

(statearr_9319[(12)] = inst_9238__$1);

return statearr_9319;
})();
var statearr_9320_9391 = state_9293__$1;
(statearr_9320_9391[(2)] = null);

(statearr_9320_9391[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (40))){
var inst_9262 = (state_9293[(22)]);
var inst_9266 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_9262);
var state_9293__$1 = state_9293;
var statearr_9321_9392 = state_9293__$1;
(statearr_9321_9392[(2)] = inst_9266);

(statearr_9321_9392[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (33))){
var inst_9253 = (state_9293[(23)]);
var inst_9255 = cljs.core.chunked_seq_QMARK_(inst_9253);
var state_9293__$1 = state_9293;
if(inst_9255){
var statearr_9322_9393 = state_9293__$1;
(statearr_9322_9393[(1)] = (36));

} else {
var statearr_9323_9394 = state_9293__$1;
(statearr_9323_9394[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (13))){
var inst_9184 = (state_9293[(24)]);
var inst_9187 = cljs.core.async.close_BANG_(inst_9184);
var state_9293__$1 = state_9293;
var statearr_9324_9395 = state_9293__$1;
(statearr_9324_9395[(2)] = inst_9187);

(statearr_9324_9395[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (22))){
var inst_9207 = (state_9293[(8)]);
var inst_9210 = cljs.core.async.close_BANG_(inst_9207);
var state_9293__$1 = state_9293;
var statearr_9325_9396 = state_9293__$1;
(statearr_9325_9396[(2)] = inst_9210);

(statearr_9325_9396[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (36))){
var inst_9253 = (state_9293[(23)]);
var inst_9257 = cljs.core.chunk_first(inst_9253);
var inst_9258 = cljs.core.chunk_rest(inst_9253);
var inst_9259 = cljs.core.count(inst_9257);
var inst_9235 = inst_9258;
var inst_9236 = inst_9257;
var inst_9237 = inst_9259;
var inst_9238 = (0);
var state_9293__$1 = (function (){var statearr_9326 = state_9293;
(statearr_9326[(19)] = inst_9237);

(statearr_9326[(20)] = inst_9235);

(statearr_9326[(11)] = inst_9236);

(statearr_9326[(12)] = inst_9238);

return statearr_9326;
})();
var statearr_9327_9397 = state_9293__$1;
(statearr_9327_9397[(2)] = null);

(statearr_9327_9397[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (41))){
var inst_9253 = (state_9293[(23)]);
var inst_9268 = (state_9293[(2)]);
var inst_9269 = cljs.core.next(inst_9253);
var inst_9235 = inst_9269;
var inst_9236 = null;
var inst_9237 = (0);
var inst_9238 = (0);
var state_9293__$1 = (function (){var statearr_9328 = state_9293;
(statearr_9328[(19)] = inst_9237);

(statearr_9328[(20)] = inst_9235);

(statearr_9328[(11)] = inst_9236);

(statearr_9328[(12)] = inst_9238);

(statearr_9328[(25)] = inst_9268);

return statearr_9328;
})();
var statearr_9329_9398 = state_9293__$1;
(statearr_9329_9398[(2)] = null);

(statearr_9329_9398[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (43))){
var state_9293__$1 = state_9293;
var statearr_9330_9399 = state_9293__$1;
(statearr_9330_9399[(2)] = null);

(statearr_9330_9399[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (29))){
var inst_9277 = (state_9293[(2)]);
var state_9293__$1 = state_9293;
var statearr_9331_9400 = state_9293__$1;
(statearr_9331_9400[(2)] = inst_9277);

(statearr_9331_9400[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (44))){
var inst_9286 = (state_9293[(2)]);
var state_9293__$1 = (function (){var statearr_9332 = state_9293;
(statearr_9332[(26)] = inst_9286);

return statearr_9332;
})();
var statearr_9333_9401 = state_9293__$1;
(statearr_9333_9401[(2)] = null);

(statearr_9333_9401[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (6))){
var inst_9227 = (state_9293[(27)]);
var inst_9226 = cljs.core.deref(cs);
var inst_9227__$1 = cljs.core.keys(inst_9226);
var inst_9228 = cljs.core.count(inst_9227__$1);
var inst_9229 = cljs.core.reset_BANG_(dctr,inst_9228);
var inst_9234 = cljs.core.seq(inst_9227__$1);
var inst_9235 = inst_9234;
var inst_9236 = null;
var inst_9237 = (0);
var inst_9238 = (0);
var state_9293__$1 = (function (){var statearr_9334 = state_9293;
(statearr_9334[(19)] = inst_9237);

(statearr_9334[(20)] = inst_9235);

(statearr_9334[(27)] = inst_9227__$1);

(statearr_9334[(11)] = inst_9236);

(statearr_9334[(28)] = inst_9229);

(statearr_9334[(12)] = inst_9238);

return statearr_9334;
})();
var statearr_9335_9402 = state_9293__$1;
(statearr_9335_9402[(2)] = null);

(statearr_9335_9402[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (28))){
var inst_9235 = (state_9293[(20)]);
var inst_9253 = (state_9293[(23)]);
var inst_9253__$1 = cljs.core.seq(inst_9235);
var state_9293__$1 = (function (){var statearr_9336 = state_9293;
(statearr_9336[(23)] = inst_9253__$1);

return statearr_9336;
})();
if(inst_9253__$1){
var statearr_9337_9403 = state_9293__$1;
(statearr_9337_9403[(1)] = (33));

} else {
var statearr_9338_9404 = state_9293__$1;
(statearr_9338_9404[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (25))){
var inst_9237 = (state_9293[(19)]);
var inst_9238 = (state_9293[(12)]);
var inst_9240 = (inst_9238 < inst_9237);
var inst_9241 = inst_9240;
var state_9293__$1 = state_9293;
if(cljs.core.truth_(inst_9241)){
var statearr_9339_9405 = state_9293__$1;
(statearr_9339_9405[(1)] = (27));

} else {
var statearr_9340_9406 = state_9293__$1;
(statearr_9340_9406[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (34))){
var state_9293__$1 = state_9293;
var statearr_9341_9407 = state_9293__$1;
(statearr_9341_9407[(2)] = null);

(statearr_9341_9407[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (17))){
var state_9293__$1 = state_9293;
var statearr_9342_9408 = state_9293__$1;
(statearr_9342_9408[(2)] = null);

(statearr_9342_9408[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (3))){
var inst_9291 = (state_9293[(2)]);
var state_9293__$1 = state_9293;
return cljs.core.async.impl.ioc_helpers.return_chan(state_9293__$1,inst_9291);
} else {
if((state_val_9294 === (12))){
var inst_9222 = (state_9293[(2)]);
var state_9293__$1 = state_9293;
var statearr_9343_9409 = state_9293__$1;
(statearr_9343_9409[(2)] = inst_9222);

(statearr_9343_9409[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (2))){
var state_9293__$1 = state_9293;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_9293__$1,(4),ch);
} else {
if((state_val_9294 === (23))){
var state_9293__$1 = state_9293;
var statearr_9344_9410 = state_9293__$1;
(statearr_9344_9410[(2)] = null);

(statearr_9344_9410[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (35))){
var inst_9275 = (state_9293[(2)]);
var state_9293__$1 = state_9293;
var statearr_9345_9411 = state_9293__$1;
(statearr_9345_9411[(2)] = inst_9275);

(statearr_9345_9411[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (19))){
var inst_9194 = (state_9293[(7)]);
var inst_9198 = cljs.core.chunk_first(inst_9194);
var inst_9199 = cljs.core.chunk_rest(inst_9194);
var inst_9200 = cljs.core.count(inst_9198);
var inst_9172 = inst_9199;
var inst_9173 = inst_9198;
var inst_9174 = inst_9200;
var inst_9175 = (0);
var state_9293__$1 = (function (){var statearr_9346 = state_9293;
(statearr_9346[(13)] = inst_9175);

(statearr_9346[(14)] = inst_9172);

(statearr_9346[(16)] = inst_9174);

(statearr_9346[(17)] = inst_9173);

return statearr_9346;
})();
var statearr_9347_9412 = state_9293__$1;
(statearr_9347_9412[(2)] = null);

(statearr_9347_9412[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (11))){
var inst_9172 = (state_9293[(14)]);
var inst_9194 = (state_9293[(7)]);
var inst_9194__$1 = cljs.core.seq(inst_9172);
var state_9293__$1 = (function (){var statearr_9348 = state_9293;
(statearr_9348[(7)] = inst_9194__$1);

return statearr_9348;
})();
if(inst_9194__$1){
var statearr_9349_9413 = state_9293__$1;
(statearr_9349_9413[(1)] = (16));

} else {
var statearr_9350_9414 = state_9293__$1;
(statearr_9350_9414[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (9))){
var inst_9224 = (state_9293[(2)]);
var state_9293__$1 = state_9293;
var statearr_9351_9415 = state_9293__$1;
(statearr_9351_9415[(2)] = inst_9224);

(statearr_9351_9415[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (5))){
var inst_9170 = cljs.core.deref(cs);
var inst_9171 = cljs.core.seq(inst_9170);
var inst_9172 = inst_9171;
var inst_9173 = null;
var inst_9174 = (0);
var inst_9175 = (0);
var state_9293__$1 = (function (){var statearr_9352 = state_9293;
(statearr_9352[(13)] = inst_9175);

(statearr_9352[(14)] = inst_9172);

(statearr_9352[(16)] = inst_9174);

(statearr_9352[(17)] = inst_9173);

return statearr_9352;
})();
var statearr_9353_9416 = state_9293__$1;
(statearr_9353_9416[(2)] = null);

(statearr_9353_9416[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (14))){
var state_9293__$1 = state_9293;
var statearr_9354_9417 = state_9293__$1;
(statearr_9354_9417[(2)] = null);

(statearr_9354_9417[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (45))){
var inst_9283 = (state_9293[(2)]);
var state_9293__$1 = state_9293;
var statearr_9355_9418 = state_9293__$1;
(statearr_9355_9418[(2)] = inst_9283);

(statearr_9355_9418[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (26))){
var inst_9227 = (state_9293[(27)]);
var inst_9279 = (state_9293[(2)]);
var inst_9280 = cljs.core.seq(inst_9227);
var state_9293__$1 = (function (){var statearr_9356 = state_9293;
(statearr_9356[(29)] = inst_9279);

return statearr_9356;
})();
if(inst_9280){
var statearr_9357_9419 = state_9293__$1;
(statearr_9357_9419[(1)] = (42));

} else {
var statearr_9358_9420 = state_9293__$1;
(statearr_9358_9420[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (16))){
var inst_9194 = (state_9293[(7)]);
var inst_9196 = cljs.core.chunked_seq_QMARK_(inst_9194);
var state_9293__$1 = state_9293;
if(inst_9196){
var statearr_9359_9421 = state_9293__$1;
(statearr_9359_9421[(1)] = (19));

} else {
var statearr_9360_9422 = state_9293__$1;
(statearr_9360_9422[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (38))){
var inst_9272 = (state_9293[(2)]);
var state_9293__$1 = state_9293;
var statearr_9361_9423 = state_9293__$1;
(statearr_9361_9423[(2)] = inst_9272);

(statearr_9361_9423[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (30))){
var state_9293__$1 = state_9293;
var statearr_9362_9424 = state_9293__$1;
(statearr_9362_9424[(2)] = null);

(statearr_9362_9424[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (10))){
var inst_9175 = (state_9293[(13)]);
var inst_9173 = (state_9293[(17)]);
var inst_9183 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_9173,inst_9175);
var inst_9184 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_9183,(0),null);
var inst_9185 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_9183,(1),null);
var state_9293__$1 = (function (){var statearr_9363 = state_9293;
(statearr_9363[(24)] = inst_9184);

return statearr_9363;
})();
if(cljs.core.truth_(inst_9185)){
var statearr_9364_9425 = state_9293__$1;
(statearr_9364_9425[(1)] = (13));

} else {
var statearr_9365_9426 = state_9293__$1;
(statearr_9365_9426[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (18))){
var inst_9220 = (state_9293[(2)]);
var state_9293__$1 = state_9293;
var statearr_9366_9427 = state_9293__$1;
(statearr_9366_9427[(2)] = inst_9220);

(statearr_9366_9427[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (42))){
var state_9293__$1 = state_9293;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_9293__$1,(45),dchan);
} else {
if((state_val_9294 === (37))){
var inst_9163 = (state_9293[(9)]);
var inst_9253 = (state_9293[(23)]);
var inst_9262 = (state_9293[(22)]);
var inst_9262__$1 = cljs.core.first(inst_9253);
var inst_9263 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_9262__$1,inst_9163,done);
var state_9293__$1 = (function (){var statearr_9367 = state_9293;
(statearr_9367[(22)] = inst_9262__$1);

return statearr_9367;
})();
if(cljs.core.truth_(inst_9263)){
var statearr_9368_9428 = state_9293__$1;
(statearr_9368_9428[(1)] = (39));

} else {
var statearr_9369_9429 = state_9293__$1;
(statearr_9369_9429[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9294 === (8))){
var inst_9175 = (state_9293[(13)]);
var inst_9174 = (state_9293[(16)]);
var inst_9177 = (inst_9175 < inst_9174);
var inst_9178 = inst_9177;
var state_9293__$1 = state_9293;
if(cljs.core.truth_(inst_9178)){
var statearr_9370_9430 = state_9293__$1;
(statearr_9370_9430[(1)] = (10));

} else {
var statearr_9371_9431 = state_9293__$1;
(statearr_9371_9431[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__8458__auto__ = null;
var cljs$core$async$mult_$_state_machine__8458__auto____0 = (function (){
var statearr_9372 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9372[(0)] = cljs$core$async$mult_$_state_machine__8458__auto__);

(statearr_9372[(1)] = (1));

return statearr_9372;
});
var cljs$core$async$mult_$_state_machine__8458__auto____1 = (function (state_9293){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_9293);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e9373){var ex__8461__auto__ = e9373;
var statearr_9374_9432 = state_9293;
(statearr_9374_9432[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_9293[(4)]))){
var statearr_9375_9433 = state_9293;
(statearr_9375_9433[(1)] = cljs.core.first((state_9293[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9434 = state_9293;
state_9293 = G__9434;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__8458__auto__ = function(state_9293){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__8458__auto____1.call(this,state_9293);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__8458__auto____0;
cljs$core$async$mult_$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__8458__auto____1;
return cljs$core$async$mult_$_state_machine__8458__auto__;
})()
})();
var state__8534__auto__ = (function (){var statearr_9376 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_9376[(6)] = c__8532__auto___9377);

return statearr_9376;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__9436 = arguments.length;
switch (G__9436) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_9438 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_9438(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_9439 = (function (m,ch){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4429__auto__.call(null,m,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4426__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_9439(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_9440 = (function (m){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4429__auto__.call(null,m));
} else {
var m__4426__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4426__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_9440(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_9441 = (function (m,state_map){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4429__auto__.call(null,m,state_map));
} else {
var m__4426__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4426__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_9441(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_9442 = (function (m,mode){
var x__4428__auto__ = (((m == null))?null:m);
var m__4429__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4429__auto__.call(null,m,mode));
} else {
var m__4426__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4426__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_9442(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4742__auto__ = [];
var len__4736__auto___9453 = arguments.length;
var i__4737__auto___9454 = (0);
while(true){
if((i__4737__auto___9454 < len__4736__auto___9453)){
args__4742__auto__.push((arguments[i__4737__auto___9454]));

var G__9455 = (i__4737__auto___9454 + (1));
i__4737__auto___9454 = G__9455;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((3) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4743__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__9447){
var map__9448 = p__9447;
var map__9448__$1 = (((((!((map__9448 == null))))?(((((map__9448.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__9448.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__9448):map__9448);
var opts = map__9448__$1;
var statearr_9450_9456 = state;
(statearr_9450_9456[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts((function (val){
var statearr_9451_9457 = state;
(statearr_9451_9457[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_9452_9458 = state;
(statearr_9452_9458[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq9443){
var G__9444 = cljs.core.first(seq9443);
var seq9443__$1 = cljs.core.next(seq9443);
var G__9445 = cljs.core.first(seq9443__$1);
var seq9443__$2 = cljs.core.next(seq9443__$1);
var G__9446 = cljs.core.first(seq9443__$2);
var seq9443__$3 = cljs.core.next(seq9443__$2);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__9444,G__9445,G__9446,seq9443__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async9459 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async9459 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta9460){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta9460 = meta9460;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_9461,meta9460__$1){
var self__ = this;
var _9461__$1 = this;
return (new cljs.core.async.t_cljs$core$async9459(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta9460__$1));
}));

(cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_9461){
var self__ = this;
var _9461__$1 = this;
return self__.meta9460;
}));

(cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async9459.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async9459.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta9460","meta9460",1867313105,null)], null);
}));

(cljs.core.async.t_cljs$core$async9459.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async9459.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async9459");

(cljs.core.async.t_cljs$core$async9459.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async9459");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async9459.
 */
cljs.core.async.__GT_t_cljs$core$async9459 = (function cljs$core$async$mix_$___GT_t_cljs$core$async9459(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta9460){
return (new cljs.core.async.t_cljs$core$async9459(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta9460));
});

}

return (new cljs.core.async.t_cljs$core$async9459(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8532__auto___9624 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = (function (state_9563){
var state_val_9564 = (state_9563[(1)]);
if((state_val_9564 === (7))){
var inst_9478 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
var statearr_9565_9625 = state_9563__$1;
(statearr_9565_9625[(2)] = inst_9478);

(statearr_9565_9625[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (20))){
var inst_9490 = (state_9563[(7)]);
var state_9563__$1 = state_9563;
var statearr_9566_9626 = state_9563__$1;
(statearr_9566_9626[(2)] = inst_9490);

(statearr_9566_9626[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (27))){
var state_9563__$1 = state_9563;
var statearr_9567_9627 = state_9563__$1;
(statearr_9567_9627[(2)] = null);

(statearr_9567_9627[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (1))){
var inst_9465 = (state_9563[(8)]);
var inst_9465__$1 = calc_state();
var inst_9467 = (inst_9465__$1 == null);
var inst_9468 = cljs.core.not(inst_9467);
var state_9563__$1 = (function (){var statearr_9568 = state_9563;
(statearr_9568[(8)] = inst_9465__$1);

return statearr_9568;
})();
if(inst_9468){
var statearr_9569_9628 = state_9563__$1;
(statearr_9569_9628[(1)] = (2));

} else {
var statearr_9570_9629 = state_9563__$1;
(statearr_9570_9629[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (24))){
var inst_9523 = (state_9563[(9)]);
var inst_9514 = (state_9563[(10)]);
var inst_9537 = (state_9563[(11)]);
var inst_9537__$1 = (inst_9514.cljs$core$IFn$_invoke$arity$1 ? inst_9514.cljs$core$IFn$_invoke$arity$1(inst_9523) : inst_9514.call(null,inst_9523));
var state_9563__$1 = (function (){var statearr_9571 = state_9563;
(statearr_9571[(11)] = inst_9537__$1);

return statearr_9571;
})();
if(cljs.core.truth_(inst_9537__$1)){
var statearr_9572_9630 = state_9563__$1;
(statearr_9572_9630[(1)] = (29));

} else {
var statearr_9573_9631 = state_9563__$1;
(statearr_9573_9631[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (4))){
var inst_9481 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
if(cljs.core.truth_(inst_9481)){
var statearr_9574_9632 = state_9563__$1;
(statearr_9574_9632[(1)] = (8));

} else {
var statearr_9575_9633 = state_9563__$1;
(statearr_9575_9633[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (15))){
var inst_9508 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
if(cljs.core.truth_(inst_9508)){
var statearr_9576_9634 = state_9563__$1;
(statearr_9576_9634[(1)] = (19));

} else {
var statearr_9577_9635 = state_9563__$1;
(statearr_9577_9635[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (21))){
var inst_9513 = (state_9563[(12)]);
var inst_9513__$1 = (state_9563[(2)]);
var inst_9514 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_9513__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_9515 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_9513__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_9516 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_9513__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_9563__$1 = (function (){var statearr_9578 = state_9563;
(statearr_9578[(13)] = inst_9515);

(statearr_9578[(12)] = inst_9513__$1);

(statearr_9578[(10)] = inst_9514);

return statearr_9578;
})();
return cljs.core.async.ioc_alts_BANG_(state_9563__$1,(22),inst_9516);
} else {
if((state_val_9564 === (31))){
var inst_9545 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
if(cljs.core.truth_(inst_9545)){
var statearr_9579_9636 = state_9563__$1;
(statearr_9579_9636[(1)] = (32));

} else {
var statearr_9580_9637 = state_9563__$1;
(statearr_9580_9637[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (32))){
var inst_9522 = (state_9563[(14)]);
var state_9563__$1 = state_9563;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_9563__$1,(35),out,inst_9522);
} else {
if((state_val_9564 === (33))){
var inst_9513 = (state_9563[(12)]);
var inst_9490 = inst_9513;
var state_9563__$1 = (function (){var statearr_9581 = state_9563;
(statearr_9581[(7)] = inst_9490);

return statearr_9581;
})();
var statearr_9582_9638 = state_9563__$1;
(statearr_9582_9638[(2)] = null);

(statearr_9582_9638[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (13))){
var inst_9490 = (state_9563[(7)]);
var inst_9497 = inst_9490.cljs$lang$protocol_mask$partition0$;
var inst_9498 = (inst_9497 & (64));
var inst_9499 = inst_9490.cljs$core$ISeq$;
var inst_9500 = (cljs.core.PROTOCOL_SENTINEL === inst_9499);
var inst_9501 = ((inst_9498) || (inst_9500));
var state_9563__$1 = state_9563;
if(cljs.core.truth_(inst_9501)){
var statearr_9583_9639 = state_9563__$1;
(statearr_9583_9639[(1)] = (16));

} else {
var statearr_9584_9640 = state_9563__$1;
(statearr_9584_9640[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (22))){
var inst_9523 = (state_9563[(9)]);
var inst_9522 = (state_9563[(14)]);
var inst_9521 = (state_9563[(2)]);
var inst_9522__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_9521,(0),null);
var inst_9523__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_9521,(1),null);
var inst_9524 = (inst_9522__$1 == null);
var inst_9525 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_9523__$1,change);
var inst_9526 = ((inst_9524) || (inst_9525));
var state_9563__$1 = (function (){var statearr_9585 = state_9563;
(statearr_9585[(9)] = inst_9523__$1);

(statearr_9585[(14)] = inst_9522__$1);

return statearr_9585;
})();
if(cljs.core.truth_(inst_9526)){
var statearr_9586_9641 = state_9563__$1;
(statearr_9586_9641[(1)] = (23));

} else {
var statearr_9587_9642 = state_9563__$1;
(statearr_9587_9642[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (36))){
var inst_9513 = (state_9563[(12)]);
var inst_9490 = inst_9513;
var state_9563__$1 = (function (){var statearr_9588 = state_9563;
(statearr_9588[(7)] = inst_9490);

return statearr_9588;
})();
var statearr_9589_9643 = state_9563__$1;
(statearr_9589_9643[(2)] = null);

(statearr_9589_9643[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (29))){
var inst_9537 = (state_9563[(11)]);
var state_9563__$1 = state_9563;
var statearr_9590_9644 = state_9563__$1;
(statearr_9590_9644[(2)] = inst_9537);

(statearr_9590_9644[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (6))){
var state_9563__$1 = state_9563;
var statearr_9591_9645 = state_9563__$1;
(statearr_9591_9645[(2)] = false);

(statearr_9591_9645[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (28))){
var inst_9533 = (state_9563[(2)]);
var inst_9534 = calc_state();
var inst_9490 = inst_9534;
var state_9563__$1 = (function (){var statearr_9592 = state_9563;
(statearr_9592[(7)] = inst_9490);

(statearr_9592[(15)] = inst_9533);

return statearr_9592;
})();
var statearr_9593_9646 = state_9563__$1;
(statearr_9593_9646[(2)] = null);

(statearr_9593_9646[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (25))){
var inst_9559 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
var statearr_9594_9647 = state_9563__$1;
(statearr_9594_9647[(2)] = inst_9559);

(statearr_9594_9647[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (34))){
var inst_9557 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
var statearr_9595_9648 = state_9563__$1;
(statearr_9595_9648[(2)] = inst_9557);

(statearr_9595_9648[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (17))){
var state_9563__$1 = state_9563;
var statearr_9596_9649 = state_9563__$1;
(statearr_9596_9649[(2)] = false);

(statearr_9596_9649[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (3))){
var state_9563__$1 = state_9563;
var statearr_9597_9650 = state_9563__$1;
(statearr_9597_9650[(2)] = false);

(statearr_9597_9650[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (12))){
var inst_9561 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_9563__$1,inst_9561);
} else {
if((state_val_9564 === (2))){
var inst_9465 = (state_9563[(8)]);
var inst_9470 = inst_9465.cljs$lang$protocol_mask$partition0$;
var inst_9471 = (inst_9470 & (64));
var inst_9472 = inst_9465.cljs$core$ISeq$;
var inst_9473 = (cljs.core.PROTOCOL_SENTINEL === inst_9472);
var inst_9474 = ((inst_9471) || (inst_9473));
var state_9563__$1 = state_9563;
if(cljs.core.truth_(inst_9474)){
var statearr_9598_9651 = state_9563__$1;
(statearr_9598_9651[(1)] = (5));

} else {
var statearr_9599_9652 = state_9563__$1;
(statearr_9599_9652[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (23))){
var inst_9522 = (state_9563[(14)]);
var inst_9528 = (inst_9522 == null);
var state_9563__$1 = state_9563;
if(cljs.core.truth_(inst_9528)){
var statearr_9600_9653 = state_9563__$1;
(statearr_9600_9653[(1)] = (26));

} else {
var statearr_9601_9654 = state_9563__$1;
(statearr_9601_9654[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (35))){
var inst_9548 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
if(cljs.core.truth_(inst_9548)){
var statearr_9602_9655 = state_9563__$1;
(statearr_9602_9655[(1)] = (36));

} else {
var statearr_9603_9656 = state_9563__$1;
(statearr_9603_9656[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (19))){
var inst_9490 = (state_9563[(7)]);
var inst_9510 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_9490);
var state_9563__$1 = state_9563;
var statearr_9604_9657 = state_9563__$1;
(statearr_9604_9657[(2)] = inst_9510);

(statearr_9604_9657[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (11))){
var inst_9490 = (state_9563[(7)]);
var inst_9494 = (inst_9490 == null);
var inst_9495 = cljs.core.not(inst_9494);
var state_9563__$1 = state_9563;
if(inst_9495){
var statearr_9605_9658 = state_9563__$1;
(statearr_9605_9658[(1)] = (13));

} else {
var statearr_9606_9659 = state_9563__$1;
(statearr_9606_9659[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (9))){
var inst_9465 = (state_9563[(8)]);
var state_9563__$1 = state_9563;
var statearr_9607_9660 = state_9563__$1;
(statearr_9607_9660[(2)] = inst_9465);

(statearr_9607_9660[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (5))){
var state_9563__$1 = state_9563;
var statearr_9608_9661 = state_9563__$1;
(statearr_9608_9661[(2)] = true);

(statearr_9608_9661[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (14))){
var state_9563__$1 = state_9563;
var statearr_9609_9662 = state_9563__$1;
(statearr_9609_9662[(2)] = false);

(statearr_9609_9662[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (26))){
var inst_9523 = (state_9563[(9)]);
var inst_9530 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_9523);
var state_9563__$1 = state_9563;
var statearr_9610_9663 = state_9563__$1;
(statearr_9610_9663[(2)] = inst_9530);

(statearr_9610_9663[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (16))){
var state_9563__$1 = state_9563;
var statearr_9611_9664 = state_9563__$1;
(statearr_9611_9664[(2)] = true);

(statearr_9611_9664[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (38))){
var inst_9553 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
var statearr_9612_9665 = state_9563__$1;
(statearr_9612_9665[(2)] = inst_9553);

(statearr_9612_9665[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (30))){
var inst_9515 = (state_9563[(13)]);
var inst_9523 = (state_9563[(9)]);
var inst_9514 = (state_9563[(10)]);
var inst_9540 = cljs.core.empty_QMARK_(inst_9514);
var inst_9541 = (inst_9515.cljs$core$IFn$_invoke$arity$1 ? inst_9515.cljs$core$IFn$_invoke$arity$1(inst_9523) : inst_9515.call(null,inst_9523));
var inst_9542 = cljs.core.not(inst_9541);
var inst_9543 = ((inst_9540) && (inst_9542));
var state_9563__$1 = state_9563;
var statearr_9613_9666 = state_9563__$1;
(statearr_9613_9666[(2)] = inst_9543);

(statearr_9613_9666[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (10))){
var inst_9465 = (state_9563[(8)]);
var inst_9486 = (state_9563[(2)]);
var inst_9487 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_9486,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_9488 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_9486,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_9489 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_9486,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_9490 = inst_9465;
var state_9563__$1 = (function (){var statearr_9614 = state_9563;
(statearr_9614[(7)] = inst_9490);

(statearr_9614[(16)] = inst_9489);

(statearr_9614[(17)] = inst_9487);

(statearr_9614[(18)] = inst_9488);

return statearr_9614;
})();
var statearr_9615_9667 = state_9563__$1;
(statearr_9615_9667[(2)] = null);

(statearr_9615_9667[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (18))){
var inst_9505 = (state_9563[(2)]);
var state_9563__$1 = state_9563;
var statearr_9616_9668 = state_9563__$1;
(statearr_9616_9668[(2)] = inst_9505);

(statearr_9616_9668[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (37))){
var state_9563__$1 = state_9563;
var statearr_9617_9669 = state_9563__$1;
(statearr_9617_9669[(2)] = null);

(statearr_9617_9669[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9564 === (8))){
var inst_9465 = (state_9563[(8)]);
var inst_9483 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_9465);
var state_9563__$1 = state_9563;
var statearr_9618_9670 = state_9563__$1;
(statearr_9618_9670[(2)] = inst_9483);

(statearr_9618_9670[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__8458__auto__ = null;
var cljs$core$async$mix_$_state_machine__8458__auto____0 = (function (){
var statearr_9619 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9619[(0)] = cljs$core$async$mix_$_state_machine__8458__auto__);

(statearr_9619[(1)] = (1));

return statearr_9619;
});
var cljs$core$async$mix_$_state_machine__8458__auto____1 = (function (state_9563){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_9563);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e9620){var ex__8461__auto__ = e9620;
var statearr_9621_9671 = state_9563;
(statearr_9621_9671[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_9563[(4)]))){
var statearr_9622_9672 = state_9563;
(statearr_9622_9672[(1)] = cljs.core.first((state_9563[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9673 = state_9563;
state_9563 = G__9673;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__8458__auto__ = function(state_9563){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__8458__auto____1.call(this,state_9563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__8458__auto____0;
cljs$core$async$mix_$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__8458__auto____1;
return cljs$core$async$mix_$_state_machine__8458__auto__;
})()
})();
var state__8534__auto__ = (function (){var statearr_9623 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_9623[(6)] = c__8532__auto___9624);

return statearr_9623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_9676 = (function (p,v,ch,close_QMARK_){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4429__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4426__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4426__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_9676(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_9677 = (function (p,v,ch){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4429__auto__.call(null,p,v,ch));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4426__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_9677(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_9678 = (function() {
var G__9679 = null;
var G__9679__1 = (function (p){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4429__auto__.call(null,p));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4426__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__9679__2 = (function (p,v){
var x__4428__auto__ = (((p == null))?null:p);
var m__4429__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4429__auto__.call(null,p,v));
} else {
var m__4426__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4426__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__9679 = function(p,v){
switch(arguments.length){
case 1:
return G__9679__1.call(this,p);
case 2:
return G__9679__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9679.cljs$core$IFn$_invoke$arity$1 = G__9679__1;
G__9679.cljs$core$IFn$_invoke$arity$2 = G__9679__2;
return G__9679;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__9675 = arguments.length;
switch (G__9675) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_9678.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_9678.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__9683 = arguments.length;
switch (G__9683) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__9681_SHARP_){
if(cljs.core.truth_((p1__9681_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__9681_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__9681_SHARP_.call(null,topic)))){
return p1__9681_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__9681_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async9684 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async9684 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta9685){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta9685 = meta9685;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async9684.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_9686,meta9685__$1){
var self__ = this;
var _9686__$1 = this;
return (new cljs.core.async.t_cljs$core$async9684(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta9685__$1));
}));

(cljs.core.async.t_cljs$core$async9684.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_9686){
var self__ = this;
var _9686__$1 = this;
return self__.meta9685;
}));

(cljs.core.async.t_cljs$core$async9684.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async9684.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async9684.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async9684.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async9684.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async9684.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async9684.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async9684.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta9685","meta9685",-1663541267,null)], null);
}));

(cljs.core.async.t_cljs$core$async9684.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async9684.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async9684");

(cljs.core.async.t_cljs$core$async9684.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async9684");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async9684.
 */
cljs.core.async.__GT_t_cljs$core$async9684 = (function cljs$core$async$__GT_t_cljs$core$async9684(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta9685){
return (new cljs.core.async.t_cljs$core$async9684(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta9685));
});

}

return (new cljs.core.async.t_cljs$core$async9684(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__8532__auto___9805 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = (function (state_9758){
var state_val_9759 = (state_9758[(1)]);
if((state_val_9759 === (7))){
var inst_9754 = (state_9758[(2)]);
var state_9758__$1 = state_9758;
var statearr_9760_9806 = state_9758__$1;
(statearr_9760_9806[(2)] = inst_9754);

(statearr_9760_9806[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (20))){
var state_9758__$1 = state_9758;
var statearr_9761_9807 = state_9758__$1;
(statearr_9761_9807[(2)] = null);

(statearr_9761_9807[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (1))){
var state_9758__$1 = state_9758;
var statearr_9762_9808 = state_9758__$1;
(statearr_9762_9808[(2)] = null);

(statearr_9762_9808[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (24))){
var inst_9737 = (state_9758[(7)]);
var inst_9746 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_9737);
var state_9758__$1 = state_9758;
var statearr_9763_9809 = state_9758__$1;
(statearr_9763_9809[(2)] = inst_9746);

(statearr_9763_9809[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (4))){
var inst_9689 = (state_9758[(8)]);
var inst_9689__$1 = (state_9758[(2)]);
var inst_9690 = (inst_9689__$1 == null);
var state_9758__$1 = (function (){var statearr_9764 = state_9758;
(statearr_9764[(8)] = inst_9689__$1);

return statearr_9764;
})();
if(cljs.core.truth_(inst_9690)){
var statearr_9765_9810 = state_9758__$1;
(statearr_9765_9810[(1)] = (5));

} else {
var statearr_9766_9811 = state_9758__$1;
(statearr_9766_9811[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (15))){
var inst_9731 = (state_9758[(2)]);
var state_9758__$1 = state_9758;
var statearr_9767_9812 = state_9758__$1;
(statearr_9767_9812[(2)] = inst_9731);

(statearr_9767_9812[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (21))){
var inst_9751 = (state_9758[(2)]);
var state_9758__$1 = (function (){var statearr_9768 = state_9758;
(statearr_9768[(9)] = inst_9751);

return statearr_9768;
})();
var statearr_9769_9813 = state_9758__$1;
(statearr_9769_9813[(2)] = null);

(statearr_9769_9813[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (13))){
var inst_9713 = (state_9758[(10)]);
var inst_9715 = cljs.core.chunked_seq_QMARK_(inst_9713);
var state_9758__$1 = state_9758;
if(inst_9715){
var statearr_9770_9814 = state_9758__$1;
(statearr_9770_9814[(1)] = (16));

} else {
var statearr_9771_9815 = state_9758__$1;
(statearr_9771_9815[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (22))){
var inst_9743 = (state_9758[(2)]);
var state_9758__$1 = state_9758;
if(cljs.core.truth_(inst_9743)){
var statearr_9772_9816 = state_9758__$1;
(statearr_9772_9816[(1)] = (23));

} else {
var statearr_9773_9817 = state_9758__$1;
(statearr_9773_9817[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (6))){
var inst_9739 = (state_9758[(11)]);
var inst_9689 = (state_9758[(8)]);
var inst_9737 = (state_9758[(7)]);
var inst_9737__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_9689) : topic_fn.call(null,inst_9689));
var inst_9738 = cljs.core.deref(mults);
var inst_9739__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_9738,inst_9737__$1);
var state_9758__$1 = (function (){var statearr_9774 = state_9758;
(statearr_9774[(11)] = inst_9739__$1);

(statearr_9774[(7)] = inst_9737__$1);

return statearr_9774;
})();
if(cljs.core.truth_(inst_9739__$1)){
var statearr_9775_9818 = state_9758__$1;
(statearr_9775_9818[(1)] = (19));

} else {
var statearr_9776_9819 = state_9758__$1;
(statearr_9776_9819[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (25))){
var inst_9748 = (state_9758[(2)]);
var state_9758__$1 = state_9758;
var statearr_9777_9820 = state_9758__$1;
(statearr_9777_9820[(2)] = inst_9748);

(statearr_9777_9820[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (17))){
var inst_9713 = (state_9758[(10)]);
var inst_9722 = cljs.core.first(inst_9713);
var inst_9723 = cljs.core.async.muxch_STAR_(inst_9722);
var inst_9724 = cljs.core.async.close_BANG_(inst_9723);
var inst_9725 = cljs.core.next(inst_9713);
var inst_9699 = inst_9725;
var inst_9700 = null;
var inst_9701 = (0);
var inst_9702 = (0);
var state_9758__$1 = (function (){var statearr_9778 = state_9758;
(statearr_9778[(12)] = inst_9702);

(statearr_9778[(13)] = inst_9724);

(statearr_9778[(14)] = inst_9700);

(statearr_9778[(15)] = inst_9701);

(statearr_9778[(16)] = inst_9699);

return statearr_9778;
})();
var statearr_9779_9821 = state_9758__$1;
(statearr_9779_9821[(2)] = null);

(statearr_9779_9821[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (3))){
var inst_9756 = (state_9758[(2)]);
var state_9758__$1 = state_9758;
return cljs.core.async.impl.ioc_helpers.return_chan(state_9758__$1,inst_9756);
} else {
if((state_val_9759 === (12))){
var inst_9733 = (state_9758[(2)]);
var state_9758__$1 = state_9758;
var statearr_9780_9822 = state_9758__$1;
(statearr_9780_9822[(2)] = inst_9733);

(statearr_9780_9822[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (2))){
var state_9758__$1 = state_9758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_9758__$1,(4),ch);
} else {
if((state_val_9759 === (23))){
var state_9758__$1 = state_9758;
var statearr_9781_9823 = state_9758__$1;
(statearr_9781_9823[(2)] = null);

(statearr_9781_9823[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (19))){
var inst_9739 = (state_9758[(11)]);
var inst_9689 = (state_9758[(8)]);
var inst_9741 = cljs.core.async.muxch_STAR_(inst_9739);
var state_9758__$1 = state_9758;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_9758__$1,(22),inst_9741,inst_9689);
} else {
if((state_val_9759 === (11))){
var inst_9713 = (state_9758[(10)]);
var inst_9699 = (state_9758[(16)]);
var inst_9713__$1 = cljs.core.seq(inst_9699);
var state_9758__$1 = (function (){var statearr_9782 = state_9758;
(statearr_9782[(10)] = inst_9713__$1);

return statearr_9782;
})();
if(inst_9713__$1){
var statearr_9783_9824 = state_9758__$1;
(statearr_9783_9824[(1)] = (13));

} else {
var statearr_9784_9825 = state_9758__$1;
(statearr_9784_9825[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (9))){
var inst_9735 = (state_9758[(2)]);
var state_9758__$1 = state_9758;
var statearr_9785_9826 = state_9758__$1;
(statearr_9785_9826[(2)] = inst_9735);

(statearr_9785_9826[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (5))){
var inst_9696 = cljs.core.deref(mults);
var inst_9697 = cljs.core.vals(inst_9696);
var inst_9698 = cljs.core.seq(inst_9697);
var inst_9699 = inst_9698;
var inst_9700 = null;
var inst_9701 = (0);
var inst_9702 = (0);
var state_9758__$1 = (function (){var statearr_9786 = state_9758;
(statearr_9786[(12)] = inst_9702);

(statearr_9786[(14)] = inst_9700);

(statearr_9786[(15)] = inst_9701);

(statearr_9786[(16)] = inst_9699);

return statearr_9786;
})();
var statearr_9787_9827 = state_9758__$1;
(statearr_9787_9827[(2)] = null);

(statearr_9787_9827[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (14))){
var state_9758__$1 = state_9758;
var statearr_9791_9828 = state_9758__$1;
(statearr_9791_9828[(2)] = null);

(statearr_9791_9828[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (16))){
var inst_9713 = (state_9758[(10)]);
var inst_9717 = cljs.core.chunk_first(inst_9713);
var inst_9718 = cljs.core.chunk_rest(inst_9713);
var inst_9719 = cljs.core.count(inst_9717);
var inst_9699 = inst_9718;
var inst_9700 = inst_9717;
var inst_9701 = inst_9719;
var inst_9702 = (0);
var state_9758__$1 = (function (){var statearr_9792 = state_9758;
(statearr_9792[(12)] = inst_9702);

(statearr_9792[(14)] = inst_9700);

(statearr_9792[(15)] = inst_9701);

(statearr_9792[(16)] = inst_9699);

return statearr_9792;
})();
var statearr_9793_9829 = state_9758__$1;
(statearr_9793_9829[(2)] = null);

(statearr_9793_9829[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (10))){
var inst_9702 = (state_9758[(12)]);
var inst_9700 = (state_9758[(14)]);
var inst_9701 = (state_9758[(15)]);
var inst_9699 = (state_9758[(16)]);
var inst_9707 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_9700,inst_9702);
var inst_9708 = cljs.core.async.muxch_STAR_(inst_9707);
var inst_9709 = cljs.core.async.close_BANG_(inst_9708);
var inst_9710 = (inst_9702 + (1));
var tmp9788 = inst_9700;
var tmp9789 = inst_9701;
var tmp9790 = inst_9699;
var inst_9699__$1 = tmp9790;
var inst_9700__$1 = tmp9788;
var inst_9701__$1 = tmp9789;
var inst_9702__$1 = inst_9710;
var state_9758__$1 = (function (){var statearr_9794 = state_9758;
(statearr_9794[(17)] = inst_9709);

(statearr_9794[(12)] = inst_9702__$1);

(statearr_9794[(14)] = inst_9700__$1);

(statearr_9794[(15)] = inst_9701__$1);

(statearr_9794[(16)] = inst_9699__$1);

return statearr_9794;
})();
var statearr_9795_9830 = state_9758__$1;
(statearr_9795_9830[(2)] = null);

(statearr_9795_9830[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (18))){
var inst_9728 = (state_9758[(2)]);
var state_9758__$1 = state_9758;
var statearr_9796_9831 = state_9758__$1;
(statearr_9796_9831[(2)] = inst_9728);

(statearr_9796_9831[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9759 === (8))){
var inst_9702 = (state_9758[(12)]);
var inst_9701 = (state_9758[(15)]);
var inst_9704 = (inst_9702 < inst_9701);
var inst_9705 = inst_9704;
var state_9758__$1 = state_9758;
if(cljs.core.truth_(inst_9705)){
var statearr_9797_9832 = state_9758__$1;
(statearr_9797_9832[(1)] = (10));

} else {
var statearr_9798_9833 = state_9758__$1;
(statearr_9798_9833[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__8458__auto__ = null;
var cljs$core$async$state_machine__8458__auto____0 = (function (){
var statearr_9799 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9799[(0)] = cljs$core$async$state_machine__8458__auto__);

(statearr_9799[(1)] = (1));

return statearr_9799;
});
var cljs$core$async$state_machine__8458__auto____1 = (function (state_9758){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_9758);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e9800){var ex__8461__auto__ = e9800;
var statearr_9801_9834 = state_9758;
(statearr_9801_9834[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_9758[(4)]))){
var statearr_9802_9835 = state_9758;
(statearr_9802_9835[(1)] = cljs.core.first((state_9758[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9836 = state_9758;
state_9758 = G__9836;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$state_machine__8458__auto__ = function(state_9758){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8458__auto____1.call(this,state_9758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8458__auto____0;
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8458__auto____1;
return cljs$core$async$state_machine__8458__auto__;
})()
})();
var state__8534__auto__ = (function (){var statearr_9803 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_9803[(6)] = c__8532__auto___9805);

return statearr_9803;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__9838 = arguments.length;
switch (G__9838) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__9841 = arguments.length;
switch (G__9841) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__9844 = arguments.length;
switch (G__9844) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__8532__auto___9922 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = (function (state_9887){
var state_val_9888 = (state_9887[(1)]);
if((state_val_9888 === (7))){
var state_9887__$1 = state_9887;
var statearr_9889_9923 = state_9887__$1;
(statearr_9889_9923[(2)] = null);

(statearr_9889_9923[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9888 === (1))){
var state_9887__$1 = state_9887;
var statearr_9890_9924 = state_9887__$1;
(statearr_9890_9924[(2)] = null);

(statearr_9890_9924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9888 === (4))){
var inst_9847 = (state_9887[(7)]);
var inst_9848 = (state_9887[(8)]);
var inst_9850 = (inst_9848 < inst_9847);
var state_9887__$1 = state_9887;
if(cljs.core.truth_(inst_9850)){
var statearr_9891_9925 = state_9887__$1;
(statearr_9891_9925[(1)] = (6));

} else {
var statearr_9892_9926 = state_9887__$1;
(statearr_9892_9926[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9888 === (15))){
var inst_9873 = (state_9887[(9)]);
var inst_9878 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_9873);
var state_9887__$1 = state_9887;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_9887__$1,(17),out,inst_9878);
} else {
if((state_val_9888 === (13))){
var inst_9873 = (state_9887[(9)]);
var inst_9873__$1 = (state_9887[(2)]);
var inst_9874 = cljs.core.some(cljs.core.nil_QMARK_,inst_9873__$1);
var state_9887__$1 = (function (){var statearr_9893 = state_9887;
(statearr_9893[(9)] = inst_9873__$1);

return statearr_9893;
})();
if(cljs.core.truth_(inst_9874)){
var statearr_9894_9927 = state_9887__$1;
(statearr_9894_9927[(1)] = (14));

} else {
var statearr_9895_9928 = state_9887__$1;
(statearr_9895_9928[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9888 === (6))){
var state_9887__$1 = state_9887;
var statearr_9896_9929 = state_9887__$1;
(statearr_9896_9929[(2)] = null);

(statearr_9896_9929[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9888 === (17))){
var inst_9880 = (state_9887[(2)]);
var state_9887__$1 = (function (){var statearr_9898 = state_9887;
(statearr_9898[(10)] = inst_9880);

return statearr_9898;
})();
var statearr_9899_9930 = state_9887__$1;
(statearr_9899_9930[(2)] = null);

(statearr_9899_9930[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9888 === (3))){
var inst_9885 = (state_9887[(2)]);
var state_9887__$1 = state_9887;
return cljs.core.async.impl.ioc_helpers.return_chan(state_9887__$1,inst_9885);
} else {
if((state_val_9888 === (12))){
var _ = (function (){var statearr_9900 = state_9887;
(statearr_9900[(4)] = cljs.core.rest((state_9887[(4)])));

return statearr_9900;
})();
var state_9887__$1 = state_9887;
var ex9897 = (state_9887__$1[(2)]);
var statearr_9901_9931 = state_9887__$1;
(statearr_9901_9931[(5)] = ex9897);


if((ex9897 instanceof Object)){
var statearr_9902_9932 = state_9887__$1;
(statearr_9902_9932[(1)] = (11));

(statearr_9902_9932[(5)] = null);

} else {
throw ex9897;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9888 === (2))){
var inst_9846 = cljs.core.reset_BANG_(dctr,cnt);
var inst_9847 = cnt;
var inst_9848 = (0);
var state_9887__$1 = (function (){var statearr_9903 = state_9887;
(statearr_9903[(7)] = inst_9847);

(statearr_9903[(11)] = inst_9846);

(statearr_9903[(8)] = inst_9848);

return statearr_9903;
})();
var statearr_9904_9933 = state_9887__$1;
(statearr_9904_9933[(2)] = null);

(statearr_9904_9933[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9888 === (11))){
var inst_9852 = (state_9887[(2)]);
var inst_9853 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_9887__$1 = (function (){var statearr_9905 = state_9887;
(statearr_9905[(12)] = inst_9852);

return statearr_9905;
})();
var statearr_9906_9934 = state_9887__$1;
(statearr_9906_9934[(2)] = inst_9853);

(statearr_9906_9934[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9888 === (9))){
var inst_9848 = (state_9887[(8)]);
var _ = (function (){var statearr_9907 = state_9887;
(statearr_9907[(4)] = cljs.core.cons((12),(state_9887[(4)])));

return statearr_9907;
})();
var inst_9859 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_9848) : chs__$1.call(null,inst_9848));
var inst_9860 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_9848) : done.call(null,inst_9848));
var inst_9861 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_9859,inst_9860);
var ___$1 = (function (){var statearr_9908 = state_9887;
(statearr_9908[(4)] = cljs.core.rest((state_9887[(4)])));

return statearr_9908;
})();
var state_9887__$1 = state_9887;
var statearr_9909_9935 = state_9887__$1;
(statearr_9909_9935[(2)] = inst_9861);

(statearr_9909_9935[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9888 === (5))){
var inst_9871 = (state_9887[(2)]);
var state_9887__$1 = (function (){var statearr_9910 = state_9887;
(statearr_9910[(13)] = inst_9871);

return statearr_9910;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_9887__$1,(13),dchan);
} else {
if((state_val_9888 === (14))){
var inst_9876 = cljs.core.async.close_BANG_(out);
var state_9887__$1 = state_9887;
var statearr_9911_9936 = state_9887__$1;
(statearr_9911_9936[(2)] = inst_9876);

(statearr_9911_9936[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9888 === (16))){
var inst_9883 = (state_9887[(2)]);
var state_9887__$1 = state_9887;
var statearr_9912_9937 = state_9887__$1;
(statearr_9912_9937[(2)] = inst_9883);

(statearr_9912_9937[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9888 === (10))){
var inst_9848 = (state_9887[(8)]);
var inst_9864 = (state_9887[(2)]);
var inst_9865 = (inst_9848 + (1));
var inst_9848__$1 = inst_9865;
var state_9887__$1 = (function (){var statearr_9913 = state_9887;
(statearr_9913[(8)] = inst_9848__$1);

(statearr_9913[(14)] = inst_9864);

return statearr_9913;
})();
var statearr_9914_9938 = state_9887__$1;
(statearr_9914_9938[(2)] = null);

(statearr_9914_9938[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9888 === (8))){
var inst_9869 = (state_9887[(2)]);
var state_9887__$1 = state_9887;
var statearr_9915_9939 = state_9887__$1;
(statearr_9915_9939[(2)] = inst_9869);

(statearr_9915_9939[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__8458__auto__ = null;
var cljs$core$async$state_machine__8458__auto____0 = (function (){
var statearr_9916 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9916[(0)] = cljs$core$async$state_machine__8458__auto__);

(statearr_9916[(1)] = (1));

return statearr_9916;
});
var cljs$core$async$state_machine__8458__auto____1 = (function (state_9887){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_9887);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e9917){var ex__8461__auto__ = e9917;
var statearr_9918_9940 = state_9887;
(statearr_9918_9940[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_9887[(4)]))){
var statearr_9919_9941 = state_9887;
(statearr_9919_9941[(1)] = cljs.core.first((state_9887[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__9942 = state_9887;
state_9887 = G__9942;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$state_machine__8458__auto__ = function(state_9887){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8458__auto____1.call(this,state_9887);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8458__auto____0;
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8458__auto____1;
return cljs$core$async$state_machine__8458__auto__;
})()
})();
var state__8534__auto__ = (function (){var statearr_9920 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_9920[(6)] = c__8532__auto___9922);

return statearr_9920;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__9945 = arguments.length;
switch (G__9945) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8532__auto___10000 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = (function (state_9977){
var state_val_9978 = (state_9977[(1)]);
if((state_val_9978 === (7))){
var inst_9957 = (state_9977[(7)]);
var inst_9956 = (state_9977[(8)]);
var inst_9956__$1 = (state_9977[(2)]);
var inst_9957__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_9956__$1,(0),null);
var inst_9958 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_9956__$1,(1),null);
var inst_9959 = (inst_9957__$1 == null);
var state_9977__$1 = (function (){var statearr_9979 = state_9977;
(statearr_9979[(9)] = inst_9958);

(statearr_9979[(7)] = inst_9957__$1);

(statearr_9979[(8)] = inst_9956__$1);

return statearr_9979;
})();
if(cljs.core.truth_(inst_9959)){
var statearr_9980_10001 = state_9977__$1;
(statearr_9980_10001[(1)] = (8));

} else {
var statearr_9981_10002 = state_9977__$1;
(statearr_9981_10002[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9978 === (1))){
var inst_9946 = cljs.core.vec(chs);
var inst_9947 = inst_9946;
var state_9977__$1 = (function (){var statearr_9982 = state_9977;
(statearr_9982[(10)] = inst_9947);

return statearr_9982;
})();
var statearr_9983_10003 = state_9977__$1;
(statearr_9983_10003[(2)] = null);

(statearr_9983_10003[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9978 === (4))){
var inst_9947 = (state_9977[(10)]);
var state_9977__$1 = state_9977;
return cljs.core.async.ioc_alts_BANG_(state_9977__$1,(7),inst_9947);
} else {
if((state_val_9978 === (6))){
var inst_9973 = (state_9977[(2)]);
var state_9977__$1 = state_9977;
var statearr_9984_10004 = state_9977__$1;
(statearr_9984_10004[(2)] = inst_9973);

(statearr_9984_10004[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9978 === (3))){
var inst_9975 = (state_9977[(2)]);
var state_9977__$1 = state_9977;
return cljs.core.async.impl.ioc_helpers.return_chan(state_9977__$1,inst_9975);
} else {
if((state_val_9978 === (2))){
var inst_9947 = (state_9977[(10)]);
var inst_9949 = cljs.core.count(inst_9947);
var inst_9950 = (inst_9949 > (0));
var state_9977__$1 = state_9977;
if(cljs.core.truth_(inst_9950)){
var statearr_9986_10005 = state_9977__$1;
(statearr_9986_10005[(1)] = (4));

} else {
var statearr_9987_10006 = state_9977__$1;
(statearr_9987_10006[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9978 === (11))){
var inst_9947 = (state_9977[(10)]);
var inst_9966 = (state_9977[(2)]);
var tmp9985 = inst_9947;
var inst_9947__$1 = tmp9985;
var state_9977__$1 = (function (){var statearr_9988 = state_9977;
(statearr_9988[(11)] = inst_9966);

(statearr_9988[(10)] = inst_9947__$1);

return statearr_9988;
})();
var statearr_9989_10007 = state_9977__$1;
(statearr_9989_10007[(2)] = null);

(statearr_9989_10007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9978 === (9))){
var inst_9957 = (state_9977[(7)]);
var state_9977__$1 = state_9977;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_9977__$1,(11),out,inst_9957);
} else {
if((state_val_9978 === (5))){
var inst_9971 = cljs.core.async.close_BANG_(out);
var state_9977__$1 = state_9977;
var statearr_9990_10008 = state_9977__$1;
(statearr_9990_10008[(2)] = inst_9971);

(statearr_9990_10008[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9978 === (10))){
var inst_9969 = (state_9977[(2)]);
var state_9977__$1 = state_9977;
var statearr_9991_10009 = state_9977__$1;
(statearr_9991_10009[(2)] = inst_9969);

(statearr_9991_10009[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_9978 === (8))){
var inst_9958 = (state_9977[(9)]);
var inst_9957 = (state_9977[(7)]);
var inst_9947 = (state_9977[(10)]);
var inst_9956 = (state_9977[(8)]);
var inst_9961 = (function (){var cs = inst_9947;
var vec__9952 = inst_9956;
var v = inst_9957;
var c = inst_9958;
return (function (p1__9943_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__9943_SHARP_);
});
})();
var inst_9962 = cljs.core.filterv(inst_9961,inst_9947);
var inst_9947__$1 = inst_9962;
var state_9977__$1 = (function (){var statearr_9992 = state_9977;
(statearr_9992[(10)] = inst_9947__$1);

return statearr_9992;
})();
var statearr_9993_10010 = state_9977__$1;
(statearr_9993_10010[(2)] = null);

(statearr_9993_10010[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__8458__auto__ = null;
var cljs$core$async$state_machine__8458__auto____0 = (function (){
var statearr_9994 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_9994[(0)] = cljs$core$async$state_machine__8458__auto__);

(statearr_9994[(1)] = (1));

return statearr_9994;
});
var cljs$core$async$state_machine__8458__auto____1 = (function (state_9977){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_9977);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e9995){var ex__8461__auto__ = e9995;
var statearr_9996_10011 = state_9977;
(statearr_9996_10011[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_9977[(4)]))){
var statearr_9997_10012 = state_9977;
(statearr_9997_10012[(1)] = cljs.core.first((state_9977[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10013 = state_9977;
state_9977 = G__10013;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$state_machine__8458__auto__ = function(state_9977){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8458__auto____1.call(this,state_9977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8458__auto____0;
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8458__auto____1;
return cljs$core$async$state_machine__8458__auto__;
})()
})();
var state__8534__auto__ = (function (){var statearr_9998 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_9998[(6)] = c__8532__auto___10000);

return statearr_9998;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__10015 = arguments.length;
switch (G__10015) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8532__auto___10061 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = (function (state_10039){
var state_val_10040 = (state_10039[(1)]);
if((state_val_10040 === (7))){
var inst_10021 = (state_10039[(7)]);
var inst_10021__$1 = (state_10039[(2)]);
var inst_10022 = (inst_10021__$1 == null);
var inst_10023 = cljs.core.not(inst_10022);
var state_10039__$1 = (function (){var statearr_10041 = state_10039;
(statearr_10041[(7)] = inst_10021__$1);

return statearr_10041;
})();
if(inst_10023){
var statearr_10042_10062 = state_10039__$1;
(statearr_10042_10062[(1)] = (8));

} else {
var statearr_10043_10063 = state_10039__$1;
(statearr_10043_10063[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10040 === (1))){
var inst_10016 = (0);
var state_10039__$1 = (function (){var statearr_10044 = state_10039;
(statearr_10044[(8)] = inst_10016);

return statearr_10044;
})();
var statearr_10045_10064 = state_10039__$1;
(statearr_10045_10064[(2)] = null);

(statearr_10045_10064[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10040 === (4))){
var state_10039__$1 = state_10039;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_10039__$1,(7),ch);
} else {
if((state_val_10040 === (6))){
var inst_10034 = (state_10039[(2)]);
var state_10039__$1 = state_10039;
var statearr_10046_10065 = state_10039__$1;
(statearr_10046_10065[(2)] = inst_10034);

(statearr_10046_10065[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10040 === (3))){
var inst_10036 = (state_10039[(2)]);
var inst_10037 = cljs.core.async.close_BANG_(out);
var state_10039__$1 = (function (){var statearr_10047 = state_10039;
(statearr_10047[(9)] = inst_10036);

return statearr_10047;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_10039__$1,inst_10037);
} else {
if((state_val_10040 === (2))){
var inst_10016 = (state_10039[(8)]);
var inst_10018 = (inst_10016 < n);
var state_10039__$1 = state_10039;
if(cljs.core.truth_(inst_10018)){
var statearr_10048_10066 = state_10039__$1;
(statearr_10048_10066[(1)] = (4));

} else {
var statearr_10049_10067 = state_10039__$1;
(statearr_10049_10067[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10040 === (11))){
var inst_10016 = (state_10039[(8)]);
var inst_10026 = (state_10039[(2)]);
var inst_10027 = (inst_10016 + (1));
var inst_10016__$1 = inst_10027;
var state_10039__$1 = (function (){var statearr_10050 = state_10039;
(statearr_10050[(10)] = inst_10026);

(statearr_10050[(8)] = inst_10016__$1);

return statearr_10050;
})();
var statearr_10051_10068 = state_10039__$1;
(statearr_10051_10068[(2)] = null);

(statearr_10051_10068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10040 === (9))){
var state_10039__$1 = state_10039;
var statearr_10052_10069 = state_10039__$1;
(statearr_10052_10069[(2)] = null);

(statearr_10052_10069[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10040 === (5))){
var state_10039__$1 = state_10039;
var statearr_10053_10070 = state_10039__$1;
(statearr_10053_10070[(2)] = null);

(statearr_10053_10070[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10040 === (10))){
var inst_10031 = (state_10039[(2)]);
var state_10039__$1 = state_10039;
var statearr_10054_10071 = state_10039__$1;
(statearr_10054_10071[(2)] = inst_10031);

(statearr_10054_10071[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10040 === (8))){
var inst_10021 = (state_10039[(7)]);
var state_10039__$1 = state_10039;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_10039__$1,(11),out,inst_10021);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__8458__auto__ = null;
var cljs$core$async$state_machine__8458__auto____0 = (function (){
var statearr_10055 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_10055[(0)] = cljs$core$async$state_machine__8458__auto__);

(statearr_10055[(1)] = (1));

return statearr_10055;
});
var cljs$core$async$state_machine__8458__auto____1 = (function (state_10039){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_10039);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e10056){var ex__8461__auto__ = e10056;
var statearr_10057_10072 = state_10039;
(statearr_10057_10072[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_10039[(4)]))){
var statearr_10058_10073 = state_10039;
(statearr_10058_10073[(1)] = cljs.core.first((state_10039[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10074 = state_10039;
state_10039 = G__10074;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$state_machine__8458__auto__ = function(state_10039){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8458__auto____1.call(this,state_10039);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8458__auto____0;
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8458__auto____1;
return cljs$core$async$state_machine__8458__auto__;
})()
})();
var state__8534__auto__ = (function (){var statearr_10059 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_10059[(6)] = c__8532__auto___10061);

return statearr_10059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async10076 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10076 = (function (f,ch,meta10077){
this.f = f;
this.ch = ch;
this.meta10077 = meta10077;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async10076.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10078,meta10077__$1){
var self__ = this;
var _10078__$1 = this;
return (new cljs.core.async.t_cljs$core$async10076(self__.f,self__.ch,meta10077__$1));
}));

(cljs.core.async.t_cljs$core$async10076.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10078){
var self__ = this;
var _10078__$1 = this;
return self__.meta10077;
}));

(cljs.core.async.t_cljs$core$async10076.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async10076.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async10076.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async10076.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async10076.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async10079 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10079 = (function (f,ch,meta10077,_,fn1,meta10080){
this.f = f;
this.ch = ch;
this.meta10077 = meta10077;
this._ = _;
this.fn1 = fn1;
this.meta10080 = meta10080;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async10079.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10081,meta10080__$1){
var self__ = this;
var _10081__$1 = this;
return (new cljs.core.async.t_cljs$core$async10079(self__.f,self__.ch,self__.meta10077,self__._,self__.fn1,meta10080__$1));
}));

(cljs.core.async.t_cljs$core$async10079.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10081){
var self__ = this;
var _10081__$1 = this;
return self__.meta10080;
}));

(cljs.core.async.t_cljs$core$async10079.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async10079.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async10079.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async10079.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__10075_SHARP_){
var G__10082 = (((p1__10075_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__10075_SHARP_) : self__.f.call(null,p1__10075_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__10082) : f1.call(null,G__10082));
});
}));

(cljs.core.async.t_cljs$core$async10079.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10077","meta10077",-40364242,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async10076","cljs.core.async/t_cljs$core$async10076",2018292973,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta10080","meta10080",-469537727,null)], null);
}));

(cljs.core.async.t_cljs$core$async10079.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async10079.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10079");

(cljs.core.async.t_cljs$core$async10079.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async10079");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async10079.
 */
cljs.core.async.__GT_t_cljs$core$async10079 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async10079(f__$1,ch__$1,meta10077__$1,___$2,fn1__$1,meta10080){
return (new cljs.core.async.t_cljs$core$async10079(f__$1,ch__$1,meta10077__$1,___$2,fn1__$1,meta10080));
});

}

return (new cljs.core.async.t_cljs$core$async10079(self__.f,self__.ch,self__.meta10077,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4115__auto__ = ret;
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4115__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__10083 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__10083) : self__.f.call(null,G__10083));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async10076.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async10076.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async10076.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10077","meta10077",-40364242,null)], null);
}));

(cljs.core.async.t_cljs$core$async10076.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async10076.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10076");

(cljs.core.async.t_cljs$core$async10076.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async10076");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async10076.
 */
cljs.core.async.__GT_t_cljs$core$async10076 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async10076(f__$1,ch__$1,meta10077){
return (new cljs.core.async.t_cljs$core$async10076(f__$1,ch__$1,meta10077));
});

}

return (new cljs.core.async.t_cljs$core$async10076(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async10084 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10084 = (function (f,ch,meta10085){
this.f = f;
this.ch = ch;
this.meta10085 = meta10085;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async10084.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10086,meta10085__$1){
var self__ = this;
var _10086__$1 = this;
return (new cljs.core.async.t_cljs$core$async10084(self__.f,self__.ch,meta10085__$1));
}));

(cljs.core.async.t_cljs$core$async10084.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10086){
var self__ = this;
var _10086__$1 = this;
return self__.meta10085;
}));

(cljs.core.async.t_cljs$core$async10084.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async10084.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async10084.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async10084.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async10084.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async10084.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async10084.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10085","meta10085",-147887743,null)], null);
}));

(cljs.core.async.t_cljs$core$async10084.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async10084.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10084");

(cljs.core.async.t_cljs$core$async10084.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async10084");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async10084.
 */
cljs.core.async.__GT_t_cljs$core$async10084 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async10084(f__$1,ch__$1,meta10085){
return (new cljs.core.async.t_cljs$core$async10084(f__$1,ch__$1,meta10085));
});

}

return (new cljs.core.async.t_cljs$core$async10084(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async10087 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async10087 = (function (p,ch,meta10088){
this.p = p;
this.ch = ch;
this.meta10088 = meta10088;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async10087.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_10089,meta10088__$1){
var self__ = this;
var _10089__$1 = this;
return (new cljs.core.async.t_cljs$core$async10087(self__.p,self__.ch,meta10088__$1));
}));

(cljs.core.async.t_cljs$core$async10087.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_10089){
var self__ = this;
var _10089__$1 = this;
return self__.meta10088;
}));

(cljs.core.async.t_cljs$core$async10087.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async10087.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async10087.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async10087.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async10087.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async10087.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async10087.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async10087.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta10088","meta10088",-121561601,null)], null);
}));

(cljs.core.async.t_cljs$core$async10087.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async10087.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async10087");

(cljs.core.async.t_cljs$core$async10087.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"cljs.core.async/t_cljs$core$async10087");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async10087.
 */
cljs.core.async.__GT_t_cljs$core$async10087 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async10087(p__$1,ch__$1,meta10088){
return (new cljs.core.async.t_cljs$core$async10087(p__$1,ch__$1,meta10088));
});

}

return (new cljs.core.async.t_cljs$core$async10087(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__10091 = arguments.length;
switch (G__10091) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8532__auto___10132 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = (function (state_10112){
var state_val_10113 = (state_10112[(1)]);
if((state_val_10113 === (7))){
var inst_10108 = (state_10112[(2)]);
var state_10112__$1 = state_10112;
var statearr_10114_10133 = state_10112__$1;
(statearr_10114_10133[(2)] = inst_10108);

(statearr_10114_10133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10113 === (1))){
var state_10112__$1 = state_10112;
var statearr_10115_10134 = state_10112__$1;
(statearr_10115_10134[(2)] = null);

(statearr_10115_10134[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10113 === (4))){
var inst_10094 = (state_10112[(7)]);
var inst_10094__$1 = (state_10112[(2)]);
var inst_10095 = (inst_10094__$1 == null);
var state_10112__$1 = (function (){var statearr_10116 = state_10112;
(statearr_10116[(7)] = inst_10094__$1);

return statearr_10116;
})();
if(cljs.core.truth_(inst_10095)){
var statearr_10117_10135 = state_10112__$1;
(statearr_10117_10135[(1)] = (5));

} else {
var statearr_10118_10136 = state_10112__$1;
(statearr_10118_10136[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10113 === (6))){
var inst_10094 = (state_10112[(7)]);
var inst_10099 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_10094) : p.call(null,inst_10094));
var state_10112__$1 = state_10112;
if(cljs.core.truth_(inst_10099)){
var statearr_10119_10137 = state_10112__$1;
(statearr_10119_10137[(1)] = (8));

} else {
var statearr_10120_10138 = state_10112__$1;
(statearr_10120_10138[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10113 === (3))){
var inst_10110 = (state_10112[(2)]);
var state_10112__$1 = state_10112;
return cljs.core.async.impl.ioc_helpers.return_chan(state_10112__$1,inst_10110);
} else {
if((state_val_10113 === (2))){
var state_10112__$1 = state_10112;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_10112__$1,(4),ch);
} else {
if((state_val_10113 === (11))){
var inst_10102 = (state_10112[(2)]);
var state_10112__$1 = state_10112;
var statearr_10121_10139 = state_10112__$1;
(statearr_10121_10139[(2)] = inst_10102);

(statearr_10121_10139[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10113 === (9))){
var state_10112__$1 = state_10112;
var statearr_10122_10140 = state_10112__$1;
(statearr_10122_10140[(2)] = null);

(statearr_10122_10140[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10113 === (5))){
var inst_10097 = cljs.core.async.close_BANG_(out);
var state_10112__$1 = state_10112;
var statearr_10123_10141 = state_10112__$1;
(statearr_10123_10141[(2)] = inst_10097);

(statearr_10123_10141[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10113 === (10))){
var inst_10105 = (state_10112[(2)]);
var state_10112__$1 = (function (){var statearr_10124 = state_10112;
(statearr_10124[(8)] = inst_10105);

return statearr_10124;
})();
var statearr_10125_10142 = state_10112__$1;
(statearr_10125_10142[(2)] = null);

(statearr_10125_10142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10113 === (8))){
var inst_10094 = (state_10112[(7)]);
var state_10112__$1 = state_10112;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_10112__$1,(11),out,inst_10094);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__8458__auto__ = null;
var cljs$core$async$state_machine__8458__auto____0 = (function (){
var statearr_10126 = [null,null,null,null,null,null,null,null,null];
(statearr_10126[(0)] = cljs$core$async$state_machine__8458__auto__);

(statearr_10126[(1)] = (1));

return statearr_10126;
});
var cljs$core$async$state_machine__8458__auto____1 = (function (state_10112){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_10112);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e10127){var ex__8461__auto__ = e10127;
var statearr_10128_10143 = state_10112;
(statearr_10128_10143[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_10112[(4)]))){
var statearr_10129_10144 = state_10112;
(statearr_10129_10144[(1)] = cljs.core.first((state_10112[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10145 = state_10112;
state_10112 = G__10145;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$state_machine__8458__auto__ = function(state_10112){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8458__auto____1.call(this,state_10112);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8458__auto____0;
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8458__auto____1;
return cljs$core$async$state_machine__8458__auto__;
})()
})();
var state__8534__auto__ = (function (){var statearr_10130 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_10130[(6)] = c__8532__auto___10132);

return statearr_10130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__10147 = arguments.length;
switch (G__10147) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__8532__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = (function (state_10210){
var state_val_10211 = (state_10210[(1)]);
if((state_val_10211 === (7))){
var inst_10206 = (state_10210[(2)]);
var state_10210__$1 = state_10210;
var statearr_10212_10251 = state_10210__$1;
(statearr_10212_10251[(2)] = inst_10206);

(statearr_10212_10251[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10211 === (20))){
var inst_10176 = (state_10210[(7)]);
var inst_10187 = (state_10210[(2)]);
var inst_10188 = cljs.core.next(inst_10176);
var inst_10162 = inst_10188;
var inst_10163 = null;
var inst_10164 = (0);
var inst_10165 = (0);
var state_10210__$1 = (function (){var statearr_10213 = state_10210;
(statearr_10213[(8)] = inst_10163);

(statearr_10213[(9)] = inst_10165);

(statearr_10213[(10)] = inst_10187);

(statearr_10213[(11)] = inst_10162);

(statearr_10213[(12)] = inst_10164);

return statearr_10213;
})();
var statearr_10214_10252 = state_10210__$1;
(statearr_10214_10252[(2)] = null);

(statearr_10214_10252[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10211 === (1))){
var state_10210__$1 = state_10210;
var statearr_10215_10253 = state_10210__$1;
(statearr_10215_10253[(2)] = null);

(statearr_10215_10253[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10211 === (4))){
var inst_10151 = (state_10210[(13)]);
var inst_10151__$1 = (state_10210[(2)]);
var inst_10152 = (inst_10151__$1 == null);
var state_10210__$1 = (function (){var statearr_10216 = state_10210;
(statearr_10216[(13)] = inst_10151__$1);

return statearr_10216;
})();
if(cljs.core.truth_(inst_10152)){
var statearr_10217_10254 = state_10210__$1;
(statearr_10217_10254[(1)] = (5));

} else {
var statearr_10218_10255 = state_10210__$1;
(statearr_10218_10255[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10211 === (15))){
var state_10210__$1 = state_10210;
var statearr_10222_10256 = state_10210__$1;
(statearr_10222_10256[(2)] = null);

(statearr_10222_10256[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10211 === (21))){
var state_10210__$1 = state_10210;
var statearr_10223_10257 = state_10210__$1;
(statearr_10223_10257[(2)] = null);

(statearr_10223_10257[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10211 === (13))){
var inst_10163 = (state_10210[(8)]);
var inst_10165 = (state_10210[(9)]);
var inst_10162 = (state_10210[(11)]);
var inst_10164 = (state_10210[(12)]);
var inst_10172 = (state_10210[(2)]);
var inst_10173 = (inst_10165 + (1));
var tmp10219 = inst_10163;
var tmp10220 = inst_10162;
var tmp10221 = inst_10164;
var inst_10162__$1 = tmp10220;
var inst_10163__$1 = tmp10219;
var inst_10164__$1 = tmp10221;
var inst_10165__$1 = inst_10173;
var state_10210__$1 = (function (){var statearr_10224 = state_10210;
(statearr_10224[(8)] = inst_10163__$1);

(statearr_10224[(9)] = inst_10165__$1);

(statearr_10224[(14)] = inst_10172);

(statearr_10224[(11)] = inst_10162__$1);

(statearr_10224[(12)] = inst_10164__$1);

return statearr_10224;
})();
var statearr_10225_10258 = state_10210__$1;
(statearr_10225_10258[(2)] = null);

(statearr_10225_10258[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10211 === (22))){
var state_10210__$1 = state_10210;
var statearr_10226_10259 = state_10210__$1;
(statearr_10226_10259[(2)] = null);

(statearr_10226_10259[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10211 === (6))){
var inst_10151 = (state_10210[(13)]);
var inst_10160 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_10151) : f.call(null,inst_10151));
var inst_10161 = cljs.core.seq(inst_10160);
var inst_10162 = inst_10161;
var inst_10163 = null;
var inst_10164 = (0);
var inst_10165 = (0);
var state_10210__$1 = (function (){var statearr_10227 = state_10210;
(statearr_10227[(8)] = inst_10163);

(statearr_10227[(9)] = inst_10165);

(statearr_10227[(11)] = inst_10162);

(statearr_10227[(12)] = inst_10164);

return statearr_10227;
})();
var statearr_10228_10260 = state_10210__$1;
(statearr_10228_10260[(2)] = null);

(statearr_10228_10260[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10211 === (17))){
var inst_10176 = (state_10210[(7)]);
var inst_10180 = cljs.core.chunk_first(inst_10176);
var inst_10181 = cljs.core.chunk_rest(inst_10176);
var inst_10182 = cljs.core.count(inst_10180);
var inst_10162 = inst_10181;
var inst_10163 = inst_10180;
var inst_10164 = inst_10182;
var inst_10165 = (0);
var state_10210__$1 = (function (){var statearr_10229 = state_10210;
(statearr_10229[(8)] = inst_10163);

(statearr_10229[(9)] = inst_10165);

(statearr_10229[(11)] = inst_10162);

(statearr_10229[(12)] = inst_10164);

return statearr_10229;
})();
var statearr_10230_10261 = state_10210__$1;
(statearr_10230_10261[(2)] = null);

(statearr_10230_10261[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10211 === (3))){
var inst_10208 = (state_10210[(2)]);
var state_10210__$1 = state_10210;
return cljs.core.async.impl.ioc_helpers.return_chan(state_10210__$1,inst_10208);
} else {
if((state_val_10211 === (12))){
var inst_10196 = (state_10210[(2)]);
var state_10210__$1 = state_10210;
var statearr_10231_10262 = state_10210__$1;
(statearr_10231_10262[(2)] = inst_10196);

(statearr_10231_10262[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10211 === (2))){
var state_10210__$1 = state_10210;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_10210__$1,(4),in$);
} else {
if((state_val_10211 === (23))){
var inst_10204 = (state_10210[(2)]);
var state_10210__$1 = state_10210;
var statearr_10232_10263 = state_10210__$1;
(statearr_10232_10263[(2)] = inst_10204);

(statearr_10232_10263[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10211 === (19))){
var inst_10191 = (state_10210[(2)]);
var state_10210__$1 = state_10210;
var statearr_10233_10264 = state_10210__$1;
(statearr_10233_10264[(2)] = inst_10191);

(statearr_10233_10264[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10211 === (11))){
var inst_10176 = (state_10210[(7)]);
var inst_10162 = (state_10210[(11)]);
var inst_10176__$1 = cljs.core.seq(inst_10162);
var state_10210__$1 = (function (){var statearr_10234 = state_10210;
(statearr_10234[(7)] = inst_10176__$1);

return statearr_10234;
})();
if(inst_10176__$1){
var statearr_10235_10265 = state_10210__$1;
(statearr_10235_10265[(1)] = (14));

} else {
var statearr_10236_10266 = state_10210__$1;
(statearr_10236_10266[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10211 === (9))){
var inst_10198 = (state_10210[(2)]);
var inst_10199 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_10210__$1 = (function (){var statearr_10237 = state_10210;
(statearr_10237[(15)] = inst_10198);

return statearr_10237;
})();
if(cljs.core.truth_(inst_10199)){
var statearr_10238_10267 = state_10210__$1;
(statearr_10238_10267[(1)] = (21));

} else {
var statearr_10239_10268 = state_10210__$1;
(statearr_10239_10268[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10211 === (5))){
var inst_10154 = cljs.core.async.close_BANG_(out);
var state_10210__$1 = state_10210;
var statearr_10240_10269 = state_10210__$1;
(statearr_10240_10269[(2)] = inst_10154);

(statearr_10240_10269[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10211 === (14))){
var inst_10176 = (state_10210[(7)]);
var inst_10178 = cljs.core.chunked_seq_QMARK_(inst_10176);
var state_10210__$1 = state_10210;
if(inst_10178){
var statearr_10241_10270 = state_10210__$1;
(statearr_10241_10270[(1)] = (17));

} else {
var statearr_10242_10271 = state_10210__$1;
(statearr_10242_10271[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10211 === (16))){
var inst_10194 = (state_10210[(2)]);
var state_10210__$1 = state_10210;
var statearr_10243_10272 = state_10210__$1;
(statearr_10243_10272[(2)] = inst_10194);

(statearr_10243_10272[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10211 === (10))){
var inst_10163 = (state_10210[(8)]);
var inst_10165 = (state_10210[(9)]);
var inst_10170 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_10163,inst_10165);
var state_10210__$1 = state_10210;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_10210__$1,(13),out,inst_10170);
} else {
if((state_val_10211 === (18))){
var inst_10176 = (state_10210[(7)]);
var inst_10185 = cljs.core.first(inst_10176);
var state_10210__$1 = state_10210;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_10210__$1,(20),out,inst_10185);
} else {
if((state_val_10211 === (8))){
var inst_10165 = (state_10210[(9)]);
var inst_10164 = (state_10210[(12)]);
var inst_10167 = (inst_10165 < inst_10164);
var inst_10168 = inst_10167;
var state_10210__$1 = state_10210;
if(cljs.core.truth_(inst_10168)){
var statearr_10244_10273 = state_10210__$1;
(statearr_10244_10273[(1)] = (10));

} else {
var statearr_10245_10274 = state_10210__$1;
(statearr_10245_10274[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__8458__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__8458__auto____0 = (function (){
var statearr_10246 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10246[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__8458__auto__);

(statearr_10246[(1)] = (1));

return statearr_10246;
});
var cljs$core$async$mapcat_STAR__$_state_machine__8458__auto____1 = (function (state_10210){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_10210);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e10247){var ex__8461__auto__ = e10247;
var statearr_10248_10275 = state_10210;
(statearr_10248_10275[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_10210[(4)]))){
var statearr_10249_10276 = state_10210;
(statearr_10249_10276[(1)] = cljs.core.first((state_10210[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10277 = state_10210;
state_10210 = G__10277;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__8458__auto__ = function(state_10210){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__8458__auto____1.call(this,state_10210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__8458__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__8458__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__8458__auto__;
})()
})();
var state__8534__auto__ = (function (){var statearr_10250 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_10250[(6)] = c__8532__auto__);

return statearr_10250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
}));

return c__8532__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__10279 = arguments.length;
switch (G__10279) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__10282 = arguments.length;
switch (G__10282) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__10285 = arguments.length;
switch (G__10285) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8532__auto___10333 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = (function (state_10309){
var state_val_10310 = (state_10309[(1)]);
if((state_val_10310 === (7))){
var inst_10304 = (state_10309[(2)]);
var state_10309__$1 = state_10309;
var statearr_10311_10334 = state_10309__$1;
(statearr_10311_10334[(2)] = inst_10304);

(statearr_10311_10334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10310 === (1))){
var inst_10286 = null;
var state_10309__$1 = (function (){var statearr_10312 = state_10309;
(statearr_10312[(7)] = inst_10286);

return statearr_10312;
})();
var statearr_10313_10335 = state_10309__$1;
(statearr_10313_10335[(2)] = null);

(statearr_10313_10335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10310 === (4))){
var inst_10289 = (state_10309[(8)]);
var inst_10289__$1 = (state_10309[(2)]);
var inst_10290 = (inst_10289__$1 == null);
var inst_10291 = cljs.core.not(inst_10290);
var state_10309__$1 = (function (){var statearr_10314 = state_10309;
(statearr_10314[(8)] = inst_10289__$1);

return statearr_10314;
})();
if(inst_10291){
var statearr_10315_10336 = state_10309__$1;
(statearr_10315_10336[(1)] = (5));

} else {
var statearr_10316_10337 = state_10309__$1;
(statearr_10316_10337[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10310 === (6))){
var state_10309__$1 = state_10309;
var statearr_10317_10338 = state_10309__$1;
(statearr_10317_10338[(2)] = null);

(statearr_10317_10338[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10310 === (3))){
var inst_10306 = (state_10309[(2)]);
var inst_10307 = cljs.core.async.close_BANG_(out);
var state_10309__$1 = (function (){var statearr_10318 = state_10309;
(statearr_10318[(9)] = inst_10306);

return statearr_10318;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_10309__$1,inst_10307);
} else {
if((state_val_10310 === (2))){
var state_10309__$1 = state_10309;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_10309__$1,(4),ch);
} else {
if((state_val_10310 === (11))){
var inst_10289 = (state_10309[(8)]);
var inst_10298 = (state_10309[(2)]);
var inst_10286 = inst_10289;
var state_10309__$1 = (function (){var statearr_10319 = state_10309;
(statearr_10319[(7)] = inst_10286);

(statearr_10319[(10)] = inst_10298);

return statearr_10319;
})();
var statearr_10320_10339 = state_10309__$1;
(statearr_10320_10339[(2)] = null);

(statearr_10320_10339[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10310 === (9))){
var inst_10289 = (state_10309[(8)]);
var state_10309__$1 = state_10309;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_10309__$1,(11),out,inst_10289);
} else {
if((state_val_10310 === (5))){
var inst_10289 = (state_10309[(8)]);
var inst_10286 = (state_10309[(7)]);
var inst_10293 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_10289,inst_10286);
var state_10309__$1 = state_10309;
if(inst_10293){
var statearr_10322_10340 = state_10309__$1;
(statearr_10322_10340[(1)] = (8));

} else {
var statearr_10323_10341 = state_10309__$1;
(statearr_10323_10341[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10310 === (10))){
var inst_10301 = (state_10309[(2)]);
var state_10309__$1 = state_10309;
var statearr_10324_10342 = state_10309__$1;
(statearr_10324_10342[(2)] = inst_10301);

(statearr_10324_10342[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10310 === (8))){
var inst_10286 = (state_10309[(7)]);
var tmp10321 = inst_10286;
var inst_10286__$1 = tmp10321;
var state_10309__$1 = (function (){var statearr_10325 = state_10309;
(statearr_10325[(7)] = inst_10286__$1);

return statearr_10325;
})();
var statearr_10326_10343 = state_10309__$1;
(statearr_10326_10343[(2)] = null);

(statearr_10326_10343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__8458__auto__ = null;
var cljs$core$async$state_machine__8458__auto____0 = (function (){
var statearr_10327 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_10327[(0)] = cljs$core$async$state_machine__8458__auto__);

(statearr_10327[(1)] = (1));

return statearr_10327;
});
var cljs$core$async$state_machine__8458__auto____1 = (function (state_10309){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_10309);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e10328){var ex__8461__auto__ = e10328;
var statearr_10329_10344 = state_10309;
(statearr_10329_10344[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_10309[(4)]))){
var statearr_10330_10345 = state_10309;
(statearr_10330_10345[(1)] = cljs.core.first((state_10309[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10346 = state_10309;
state_10309 = G__10346;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$state_machine__8458__auto__ = function(state_10309){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8458__auto____1.call(this,state_10309);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8458__auto____0;
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8458__auto____1;
return cljs$core$async$state_machine__8458__auto__;
})()
})();
var state__8534__auto__ = (function (){var statearr_10331 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_10331[(6)] = c__8532__auto___10333);

return statearr_10331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__10348 = arguments.length;
switch (G__10348) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8532__auto___10415 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = (function (state_10386){
var state_val_10387 = (state_10386[(1)]);
if((state_val_10387 === (7))){
var inst_10382 = (state_10386[(2)]);
var state_10386__$1 = state_10386;
var statearr_10388_10416 = state_10386__$1;
(statearr_10388_10416[(2)] = inst_10382);

(statearr_10388_10416[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10387 === (1))){
var inst_10349 = (new Array(n));
var inst_10350 = inst_10349;
var inst_10351 = (0);
var state_10386__$1 = (function (){var statearr_10389 = state_10386;
(statearr_10389[(7)] = inst_10350);

(statearr_10389[(8)] = inst_10351);

return statearr_10389;
})();
var statearr_10390_10417 = state_10386__$1;
(statearr_10390_10417[(2)] = null);

(statearr_10390_10417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10387 === (4))){
var inst_10354 = (state_10386[(9)]);
var inst_10354__$1 = (state_10386[(2)]);
var inst_10355 = (inst_10354__$1 == null);
var inst_10356 = cljs.core.not(inst_10355);
var state_10386__$1 = (function (){var statearr_10391 = state_10386;
(statearr_10391[(9)] = inst_10354__$1);

return statearr_10391;
})();
if(inst_10356){
var statearr_10392_10418 = state_10386__$1;
(statearr_10392_10418[(1)] = (5));

} else {
var statearr_10393_10419 = state_10386__$1;
(statearr_10393_10419[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10387 === (15))){
var inst_10376 = (state_10386[(2)]);
var state_10386__$1 = state_10386;
var statearr_10394_10420 = state_10386__$1;
(statearr_10394_10420[(2)] = inst_10376);

(statearr_10394_10420[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10387 === (13))){
var state_10386__$1 = state_10386;
var statearr_10395_10421 = state_10386__$1;
(statearr_10395_10421[(2)] = null);

(statearr_10395_10421[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10387 === (6))){
var inst_10351 = (state_10386[(8)]);
var inst_10372 = (inst_10351 > (0));
var state_10386__$1 = state_10386;
if(cljs.core.truth_(inst_10372)){
var statearr_10396_10422 = state_10386__$1;
(statearr_10396_10422[(1)] = (12));

} else {
var statearr_10397_10423 = state_10386__$1;
(statearr_10397_10423[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10387 === (3))){
var inst_10384 = (state_10386[(2)]);
var state_10386__$1 = state_10386;
return cljs.core.async.impl.ioc_helpers.return_chan(state_10386__$1,inst_10384);
} else {
if((state_val_10387 === (12))){
var inst_10350 = (state_10386[(7)]);
var inst_10374 = cljs.core.vec(inst_10350);
var state_10386__$1 = state_10386;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_10386__$1,(15),out,inst_10374);
} else {
if((state_val_10387 === (2))){
var state_10386__$1 = state_10386;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_10386__$1,(4),ch);
} else {
if((state_val_10387 === (11))){
var inst_10366 = (state_10386[(2)]);
var inst_10367 = (new Array(n));
var inst_10350 = inst_10367;
var inst_10351 = (0);
var state_10386__$1 = (function (){var statearr_10398 = state_10386;
(statearr_10398[(7)] = inst_10350);

(statearr_10398[(8)] = inst_10351);

(statearr_10398[(10)] = inst_10366);

return statearr_10398;
})();
var statearr_10399_10424 = state_10386__$1;
(statearr_10399_10424[(2)] = null);

(statearr_10399_10424[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10387 === (9))){
var inst_10350 = (state_10386[(7)]);
var inst_10364 = cljs.core.vec(inst_10350);
var state_10386__$1 = state_10386;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_10386__$1,(11),out,inst_10364);
} else {
if((state_val_10387 === (5))){
var inst_10350 = (state_10386[(7)]);
var inst_10359 = (state_10386[(11)]);
var inst_10351 = (state_10386[(8)]);
var inst_10354 = (state_10386[(9)]);
var inst_10358 = (inst_10350[inst_10351] = inst_10354);
var inst_10359__$1 = (inst_10351 + (1));
var inst_10360 = (inst_10359__$1 < n);
var state_10386__$1 = (function (){var statearr_10400 = state_10386;
(statearr_10400[(11)] = inst_10359__$1);

(statearr_10400[(12)] = inst_10358);

return statearr_10400;
})();
if(cljs.core.truth_(inst_10360)){
var statearr_10401_10425 = state_10386__$1;
(statearr_10401_10425[(1)] = (8));

} else {
var statearr_10402_10426 = state_10386__$1;
(statearr_10402_10426[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10387 === (14))){
var inst_10379 = (state_10386[(2)]);
var inst_10380 = cljs.core.async.close_BANG_(out);
var state_10386__$1 = (function (){var statearr_10404 = state_10386;
(statearr_10404[(13)] = inst_10379);

return statearr_10404;
})();
var statearr_10405_10427 = state_10386__$1;
(statearr_10405_10427[(2)] = inst_10380);

(statearr_10405_10427[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10387 === (10))){
var inst_10370 = (state_10386[(2)]);
var state_10386__$1 = state_10386;
var statearr_10406_10428 = state_10386__$1;
(statearr_10406_10428[(2)] = inst_10370);

(statearr_10406_10428[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10387 === (8))){
var inst_10350 = (state_10386[(7)]);
var inst_10359 = (state_10386[(11)]);
var tmp10403 = inst_10350;
var inst_10350__$1 = tmp10403;
var inst_10351 = inst_10359;
var state_10386__$1 = (function (){var statearr_10407 = state_10386;
(statearr_10407[(7)] = inst_10350__$1);

(statearr_10407[(8)] = inst_10351);

return statearr_10407;
})();
var statearr_10408_10429 = state_10386__$1;
(statearr_10408_10429[(2)] = null);

(statearr_10408_10429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__8458__auto__ = null;
var cljs$core$async$state_machine__8458__auto____0 = (function (){
var statearr_10409 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10409[(0)] = cljs$core$async$state_machine__8458__auto__);

(statearr_10409[(1)] = (1));

return statearr_10409;
});
var cljs$core$async$state_machine__8458__auto____1 = (function (state_10386){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_10386);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e10410){var ex__8461__auto__ = e10410;
var statearr_10411_10430 = state_10386;
(statearr_10411_10430[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_10386[(4)]))){
var statearr_10412_10431 = state_10386;
(statearr_10412_10431[(1)] = cljs.core.first((state_10386[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10432 = state_10386;
state_10386 = G__10432;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$state_machine__8458__auto__ = function(state_10386){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8458__auto____1.call(this,state_10386);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8458__auto____0;
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8458__auto____1;
return cljs$core$async$state_machine__8458__auto__;
})()
})();
var state__8534__auto__ = (function (){var statearr_10413 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_10413[(6)] = c__8532__auto___10415);

return statearr_10413;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__10434 = arguments.length;
switch (G__10434) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__8532__auto___10505 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__8533__auto__ = (function (){var switch__8457__auto__ = (function (state_10476){
var state_val_10477 = (state_10476[(1)]);
if((state_val_10477 === (7))){
var inst_10472 = (state_10476[(2)]);
var state_10476__$1 = state_10476;
var statearr_10478_10506 = state_10476__$1;
(statearr_10478_10506[(2)] = inst_10472);

(statearr_10478_10506[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10477 === (1))){
var inst_10435 = [];
var inst_10436 = inst_10435;
var inst_10437 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_10476__$1 = (function (){var statearr_10479 = state_10476;
(statearr_10479[(7)] = inst_10436);

(statearr_10479[(8)] = inst_10437);

return statearr_10479;
})();
var statearr_10480_10507 = state_10476__$1;
(statearr_10480_10507[(2)] = null);

(statearr_10480_10507[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10477 === (4))){
var inst_10440 = (state_10476[(9)]);
var inst_10440__$1 = (state_10476[(2)]);
var inst_10441 = (inst_10440__$1 == null);
var inst_10442 = cljs.core.not(inst_10441);
var state_10476__$1 = (function (){var statearr_10481 = state_10476;
(statearr_10481[(9)] = inst_10440__$1);

return statearr_10481;
})();
if(inst_10442){
var statearr_10482_10508 = state_10476__$1;
(statearr_10482_10508[(1)] = (5));

} else {
var statearr_10483_10509 = state_10476__$1;
(statearr_10483_10509[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10477 === (15))){
var inst_10466 = (state_10476[(2)]);
var state_10476__$1 = state_10476;
var statearr_10484_10510 = state_10476__$1;
(statearr_10484_10510[(2)] = inst_10466);

(statearr_10484_10510[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10477 === (13))){
var state_10476__$1 = state_10476;
var statearr_10485_10511 = state_10476__$1;
(statearr_10485_10511[(2)] = null);

(statearr_10485_10511[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10477 === (6))){
var inst_10436 = (state_10476[(7)]);
var inst_10461 = inst_10436.length;
var inst_10462 = (inst_10461 > (0));
var state_10476__$1 = state_10476;
if(cljs.core.truth_(inst_10462)){
var statearr_10486_10512 = state_10476__$1;
(statearr_10486_10512[(1)] = (12));

} else {
var statearr_10487_10513 = state_10476__$1;
(statearr_10487_10513[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10477 === (3))){
var inst_10474 = (state_10476[(2)]);
var state_10476__$1 = state_10476;
return cljs.core.async.impl.ioc_helpers.return_chan(state_10476__$1,inst_10474);
} else {
if((state_val_10477 === (12))){
var inst_10436 = (state_10476[(7)]);
var inst_10464 = cljs.core.vec(inst_10436);
var state_10476__$1 = state_10476;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_10476__$1,(15),out,inst_10464);
} else {
if((state_val_10477 === (2))){
var state_10476__$1 = state_10476;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_10476__$1,(4),ch);
} else {
if((state_val_10477 === (11))){
var inst_10444 = (state_10476[(10)]);
var inst_10440 = (state_10476[(9)]);
var inst_10454 = (state_10476[(2)]);
var inst_10455 = [];
var inst_10456 = inst_10455.push(inst_10440);
var inst_10436 = inst_10455;
var inst_10437 = inst_10444;
var state_10476__$1 = (function (){var statearr_10488 = state_10476;
(statearr_10488[(11)] = inst_10456);

(statearr_10488[(12)] = inst_10454);

(statearr_10488[(7)] = inst_10436);

(statearr_10488[(8)] = inst_10437);

return statearr_10488;
})();
var statearr_10489_10514 = state_10476__$1;
(statearr_10489_10514[(2)] = null);

(statearr_10489_10514[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10477 === (9))){
var inst_10436 = (state_10476[(7)]);
var inst_10452 = cljs.core.vec(inst_10436);
var state_10476__$1 = state_10476;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_10476__$1,(11),out,inst_10452);
} else {
if((state_val_10477 === (5))){
var inst_10444 = (state_10476[(10)]);
var inst_10440 = (state_10476[(9)]);
var inst_10437 = (state_10476[(8)]);
var inst_10444__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_10440) : f.call(null,inst_10440));
var inst_10445 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_10444__$1,inst_10437);
var inst_10446 = cljs.core.keyword_identical_QMARK_(inst_10437,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_10447 = ((inst_10445) || (inst_10446));
var state_10476__$1 = (function (){var statearr_10490 = state_10476;
(statearr_10490[(10)] = inst_10444__$1);

return statearr_10490;
})();
if(cljs.core.truth_(inst_10447)){
var statearr_10491_10515 = state_10476__$1;
(statearr_10491_10515[(1)] = (8));

} else {
var statearr_10492_10516 = state_10476__$1;
(statearr_10492_10516[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10477 === (14))){
var inst_10469 = (state_10476[(2)]);
var inst_10470 = cljs.core.async.close_BANG_(out);
var state_10476__$1 = (function (){var statearr_10494 = state_10476;
(statearr_10494[(13)] = inst_10469);

return statearr_10494;
})();
var statearr_10495_10517 = state_10476__$1;
(statearr_10495_10517[(2)] = inst_10470);

(statearr_10495_10517[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10477 === (10))){
var inst_10459 = (state_10476[(2)]);
var state_10476__$1 = state_10476;
var statearr_10496_10518 = state_10476__$1;
(statearr_10496_10518[(2)] = inst_10459);

(statearr_10496_10518[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_10477 === (8))){
var inst_10444 = (state_10476[(10)]);
var inst_10436 = (state_10476[(7)]);
var inst_10440 = (state_10476[(9)]);
var inst_10449 = inst_10436.push(inst_10440);
var tmp10493 = inst_10436;
var inst_10436__$1 = tmp10493;
var inst_10437 = inst_10444;
var state_10476__$1 = (function (){var statearr_10497 = state_10476;
(statearr_10497[(7)] = inst_10436__$1);

(statearr_10497[(8)] = inst_10437);

(statearr_10497[(14)] = inst_10449);

return statearr_10497;
})();
var statearr_10498_10519 = state_10476__$1;
(statearr_10498_10519[(2)] = null);

(statearr_10498_10519[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__8458__auto__ = null;
var cljs$core$async$state_machine__8458__auto____0 = (function (){
var statearr_10499 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_10499[(0)] = cljs$core$async$state_machine__8458__auto__);

(statearr_10499[(1)] = (1));

return statearr_10499;
});
var cljs$core$async$state_machine__8458__auto____1 = (function (state_10476){
while(true){
var ret_value__8459__auto__ = (function (){try{while(true){
var result__8460__auto__ = switch__8457__auto__(state_10476);
if(cljs.core.keyword_identical_QMARK_(result__8460__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__8460__auto__;
}
break;
}
}catch (e10500){var ex__8461__auto__ = e10500;
var statearr_10501_10520 = state_10476;
(statearr_10501_10520[(2)] = ex__8461__auto__);


if(cljs.core.seq((state_10476[(4)]))){
var statearr_10502_10521 = state_10476;
(statearr_10502_10521[(1)] = cljs.core.first((state_10476[(4)])));

} else {
throw ex__8461__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__8459__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__10522 = state_10476;
state_10476 = G__10522;
continue;
} else {
return ret_value__8459__auto__;
}
break;
}
});
cljs$core$async$state_machine__8458__auto__ = function(state_10476){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__8458__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__8458__auto____1.call(this,state_10476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__8458__auto____0;
cljs$core$async$state_machine__8458__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__8458__auto____1;
return cljs$core$async$state_machine__8458__auto__;
})()
})();
var state__8534__auto__ = (function (){var statearr_10503 = (f__8533__auto__.cljs$core$IFn$_invoke$arity$0 ? f__8533__auto__.cljs$core$IFn$_invoke$arity$0() : f__8533__auto__.call(null));
(statearr_10503[(6)] = c__8532__auto___10505);

return statearr_10503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__8534__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

