// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.api_js');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.crypto');
goog.require('fluree.db.flake');
goog.require('fluree.db.operations');
goog.require('fluree.db.query.block');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.session');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('goog.string.format');
goog.require('fluree.db.connection_js');
/**
 * Returns a queryable database from the connection.
 * No permissions applied - assumes root
 */
fluree.db.api_js.db = (function fluree$db$api_js$db(var_args){
var args__4742__auto__ = [];
var len__4736__auto___64730 = arguments.length;
var i__4737__auto___64731 = (0);
while(true){
if((i__4737__auto___64731 < len__4736__auto___64730)){
args__4742__auto__.push((arguments[i__4737__auto___64731]));

var G__64732 = (i__4737__auto___64731 + (1));
i__4737__auto___64731 = G__64732;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((2) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((2)),(0),null)):null);
return fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4743__auto__);
});

(fluree.db.api_js.db.cljs$core$IFn$_invoke$arity$variadic = (function (conn,ledger,p__64629){
var vec__64630 = p__64629;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64630,(0),null);
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2901__auto___64733 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64694){
var state_val_64695 = (state_64694[(1)]);
if((state_val_64695 === (7))){
var state_64694__$1 = state_64694;
var statearr_64696_64734 = state_64694__$1;
(statearr_64696_64734[(2)] = false);

(statearr_64696_64734[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64695 === (1))){
var state_64694__$1 = state_64694;
var statearr_64697_64735 = state_64694__$1;
(statearr_64697_64735[(2)] = null);

(statearr_64697_64735[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64695 === (4))){
var inst_64633 = (state_64694[(2)]);
var inst_64634 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64633], 0));
var inst_64635 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64633);
var inst_64636 = cljs.core.async.close_BANG_(pc);
var state_64694__$1 = (function (){var statearr_64698 = state_64694;
(statearr_64698[(7)] = inst_64635);

(statearr_64698[(8)] = inst_64634);

return statearr_64698;
})();
var statearr_64699_64736 = state_64694__$1;
(statearr_64699_64736[(2)] = inst_64636);

(statearr_64699_64736[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64695 === (15))){
var inst_64671 = (state_64694[(9)]);
var inst_64674 = (state_64694[(10)]);
var inst_64675 = (state_64694[(11)]);
var inst_64678 = (state_64694[(2)]);
var inst_64679 = fluree.db.util.async.throw_err(inst_64678);
var inst_64680 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_64679,new cljs.core.Keyword(null,"conn","conn",278309663),conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"network","network",2050004697),inst_64674,new cljs.core.Keyword(null,"dbid","dbid",-196647356),inst_64675], 0));
var state_64694__$1 = (function (){var statearr_64700 = state_64694;
(statearr_64700[(12)] = inst_64680);

return statearr_64700;
})();
if(cljs.core.truth_(inst_64671)){
var statearr_64701_64737 = state_64694__$1;
(statearr_64701_64737[(1)] = (16));

} else {
var statearr_64702_64738 = state_64694__$1;
(statearr_64702_64738[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64695 === (13))){
var inst_64646 = (state_64694[(13)]);
var state_64694__$1 = state_64694;
var statearr_64703_64739 = state_64694__$1;
(statearr_64703_64739[(2)] = inst_64646);

(statearr_64703_64739[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64695 === (6))){
var inst_64646 = (state_64694[(13)]);
var inst_64651 = inst_64646.cljs$lang$protocol_mask$partition0$;
var inst_64652 = (inst_64651 & (64));
var inst_64653 = inst_64646.cljs$core$ISeq$;
var inst_64654 = (cljs.core.PROTOCOL_SENTINEL === inst_64653);
var inst_64655 = ((inst_64652) || (inst_64654));
var state_64694__$1 = state_64694;
if(cljs.core.truth_(inst_64655)){
var statearr_64704_64740 = state_64694__$1;
(statearr_64704_64740[(1)] = (9));

} else {
var statearr_64705_64741 = state_64694__$1;
(statearr_64705_64741[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64695 === (17))){
var inst_64680 = (state_64694[(12)]);
var state_64694__$1 = state_64694;
var statearr_64706_64742 = state_64694__$1;
(statearr_64706_64742[(2)] = inst_64680);

(statearr_64706_64742[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64695 === (3))){
var inst_64692 = (state_64694[(2)]);
var state_64694__$1 = state_64694;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64694__$1,inst_64692);
} else {
if((state_val_64695 === (12))){
var inst_64646 = (state_64694[(13)]);
var inst_64664 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_64646);
var state_64694__$1 = state_64694;
var statearr_64707_64743 = state_64694__$1;
(statearr_64707_64743[(2)] = inst_64664);

(statearr_64707_64743[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64695 === (2))){
var inst_64646 = (state_64694[(13)]);
var _ = (function (){var statearr_64708 = state_64694;
(statearr_64708[(4)] = cljs.core.cons((5),(state_64694[(4)])));

return statearr_64708;
})();
var inst_64646__$1 = opts;
var inst_64648 = (inst_64646__$1 == null);
var inst_64649 = cljs.core.not(inst_64648);
var state_64694__$1 = (function (){var statearr_64709 = state_64694;
(statearr_64709[(13)] = inst_64646__$1);

return statearr_64709;
})();
if(inst_64649){
var statearr_64710_64744 = state_64694__$1;
(statearr_64710_64744[(1)] = (6));

} else {
var statearr_64711_64745 = state_64694__$1;
(statearr_64711_64745[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64695 === (19))){
var inst_64684 = (state_64694[(2)]);
var inst_64685 = fluree.db.util.async.throw_err(inst_64684);
var state_64694__$1 = state_64694;
var statearr_64712_64746 = state_64694__$1;
(statearr_64712_64746[(2)] = inst_64685);

(statearr_64712_64746[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64695 === (11))){
var inst_64659 = (state_64694[(2)]);
var state_64694__$1 = state_64694;
var statearr_64714_64747 = state_64694__$1;
(statearr_64714_64747[(2)] = inst_64659);

(statearr_64714_64747[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64695 === (9))){
var state_64694__$1 = state_64694;
var statearr_64715_64748 = state_64694__$1;
(statearr_64715_64748[(2)] = true);

(statearr_64715_64748[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64695 === (5))){
var _ = (function (){var statearr_64716 = state_64694;
(statearr_64716[(4)] = cljs.core.rest((state_64694[(4)])));

return statearr_64716;
})();
var state_64694__$1 = state_64694;
var ex64713 = (state_64694__$1[(2)]);
var statearr_64717_64749 = state_64694__$1;
(statearr_64717_64749[(5)] = ex64713);


var statearr_64718_64750 = state_64694__$1;
(statearr_64718_64750[(1)] = (4));

(statearr_64718_64750[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64695 === (14))){
var inst_64667 = (state_64694[(2)]);
var inst_64668 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64667,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_64669 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64667,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_64670 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64667,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_64671 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64667,new cljs.core.Keyword(null,"block","block",664686210));
var inst_64672 = fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,opts);
var inst_64673 = fluree.db.session.resolve_ledger(conn,ledger);
var inst_64674 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64673,(0),null);
var inst_64675 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64673,(1),null);
var inst_64676 = fluree.db.session.db(conn,ledger,opts);
var state_64694__$1 = (function (){var statearr_64719 = state_64694;
(statearr_64719[(9)] = inst_64671);

(statearr_64719[(10)] = inst_64674);

(statearr_64719[(14)] = inst_64669);

(statearr_64719[(15)] = inst_64668);

(statearr_64719[(16)] = inst_64672);

(statearr_64719[(17)] = inst_64670);

(statearr_64719[(11)] = inst_64675);

return statearr_64719;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64694__$1,(15),inst_64676);
} else {
if((state_val_64695 === (16))){
var inst_64671 = (state_64694[(9)]);
var inst_64680 = (state_64694[(12)]);
var inst_64682 = fluree.db.time_travel.as_of_block(inst_64680,inst_64671);
var state_64694__$1 = state_64694;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64694__$1,(19),inst_64682);
} else {
if((state_val_64695 === (10))){
var state_64694__$1 = state_64694;
var statearr_64720_64751 = state_64694__$1;
(statearr_64720_64751[(2)] = false);

(statearr_64720_64751[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64695 === (18))){
var inst_64688 = (state_64694[(2)]);
var inst_64689 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64688);
var _ = (function (){var statearr_64721 = state_64694;
(statearr_64721[(4)] = cljs.core.rest((state_64694[(4)])));

return statearr_64721;
})();
var state_64694__$1 = state_64694;
var statearr_64722_64752 = state_64694__$1;
(statearr_64722_64752[(2)] = inst_64689);

(statearr_64722_64752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64695 === (8))){
var inst_64662 = (state_64694[(2)]);
var state_64694__$1 = state_64694;
if(cljs.core.truth_(inst_64662)){
var statearr_64723_64753 = state_64694__$1;
(statearr_64723_64753[(1)] = (12));

} else {
var statearr_64724_64754 = state_64694__$1;
(statearr_64724_64754[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2879__auto__ = null;
var fluree$db$api_js$state_machine__2879__auto____0 = (function (){
var statearr_64725 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64725[(0)] = fluree$db$api_js$state_machine__2879__auto__);

(statearr_64725[(1)] = (1));

return statearr_64725;
});
var fluree$db$api_js$state_machine__2879__auto____1 = (function (state_64694){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_64694);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64726){var ex__2882__auto__ = e64726;
var statearr_64727_64755 = state_64694;
(statearr_64727_64755[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_64694[(4)]))){
var statearr_64728_64756 = state_64694;
(statearr_64728_64756[(1)] = cljs.core.first((state_64694[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64757 = state_64694;
state_64694 = G__64757;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2879__auto__ = function(state_64694){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2879__auto____1.call(this,state_64694);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2879__auto____0;
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2879__auto____1;
return fluree$db$api_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64729 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_64729[(6)] = c__2901__auto___64733);

return statearr_64729;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));


return pc;
}));

(fluree.db.api_js.db.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.api_js.db.cljs$lang$applyTo = (function (seq64626){
var G__64627 = cljs.core.first(seq64626);
var seq64626__$1 = cljs.core.next(seq64626);
var G__64628 = cljs.core.first(seq64626__$1);
var seq64626__$2 = cljs.core.next(seq64626__$1);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__64627,G__64628,seq64626__$2);
}));

fluree.db.api_js.db_ident_QMARK_ = (function fluree$db$api_js$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api_js.isolate_ledger_id = (function fluree$db$api_js$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Validates & returns the query sources.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.get_sources = (function fluree$db$api_js$get_sources(conn,network,open_api,auth,prefixes,db_fn){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

if(cljs.core.truth_(((fluree.db.api_js.db_ident_QMARK_(val))?(function (){var and__4115__auto__ = open_api;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(network,cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(val,/\//)));
} else {
return and__4115__auto__;
}
})():false))){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
if(cljs.core.truth_(((fluree.db.api_js.db_ident_QMARK_(val))?open_api:false))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When attempting to query across multiple databases in different networks, you must be using a closed API.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
} else {
if(cljs.core.truth_(((fluree.db.api_js.db_ident_QMARK_(val))?auth:false))){
var db_id = fluree.db.api_js.isolate_ledger_id(val);
var ledger = cljs.core.apply.cljs$core$IFn$_invoke$arity$4(db_fn,conn,db_id,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,ledger);
} else {
return acc;

}
}
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
/**
 * Execute an unsigned query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns a channel, where the results are eventually put.
 * 
 *   The db function, to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.query_async = (function fluree$db$api_js$query_async(var_args){
var G__64760 = arguments.length;
switch (G__64760) {
case 2:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,fluree.db.api_js.db);
}));

(fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,db_fn){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64910){
var state_val_64911 = (state_64910[(1)]);
if((state_val_64911 === (7))){
var state_64910__$1 = state_64910;
var statearr_64912_65008 = state_64910__$1;
(statearr_64912_65008[(2)] = false);

(statearr_64912_65008[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (59))){
var inst_64899 = (state_64910[(2)]);
var state_64910__$1 = state_64910;
var statearr_64913_65009 = state_64910__$1;
(statearr_64913_65009[(2)] = inst_64899);

(statearr_64913_65009[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (20))){
var inst_64814 = (state_64910[(7)]);
var inst_64815 = (state_64910[(8)]);
var inst_64798 = (state_64910[(9)]);
var inst_64817 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_64814);
var inst_64818 = fluree.db.connection_js.open_api_QMARK_(inst_64815);
var inst_64819 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_64814);
var inst_64820 = fluree.db.api_js.get_sources(inst_64815,inst_64817,inst_64818,inst_64819,inst_64798,db_fn);
var state_64910__$1 = state_64910;
var statearr_64914_65010 = state_64910__$1;
(statearr_64914_65010[(2)] = inst_64820);

(statearr_64914_65010[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (58))){
var state_64910__$1 = state_64910;
var statearr_64915_65011 = state_64910__$1;
(statearr_64915_65011[(2)] = null);

(statearr_64915_65011[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (27))){
var inst_64800 = (state_64910[(10)]);
var state_64910__$1 = state_64910;
if(cljs.core.truth_(inst_64800)){
var statearr_64916_65012 = state_64910__$1;
(statearr_64916_65012[(1)] = (29));

} else {
var statearr_64917_65013 = state_64910__$1;
(statearr_64917_65013[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (1))){
var state_64910__$1 = state_64910;
var statearr_64918_65014 = state_64910__$1;
(statearr_64918_65014[(2)] = null);

(statearr_64918_65014[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (24))){
var state_64910__$1 = state_64910;
var statearr_64919_65015 = state_64910__$1;
(statearr_64919_65015[(2)] = (1000000));

(statearr_64919_65015[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (55))){
var inst_64868 = (state_64910[(11)]);
var state_64910__$1 = state_64910;
var statearr_64920_65016 = state_64910__$1;
(statearr_64920_65016[(2)] = inst_64868);

(statearr_64920_65016[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (39))){
var inst_64849 = (state_64910[(12)]);
var state_64910__$1 = state_64910;
var statearr_64921_65017 = state_64910__$1;
(statearr_64921_65017[(2)] = inst_64849);

(statearr_64921_65017[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (46))){
var inst_64905 = (state_64910[(2)]);
var _ = (function (){var statearr_64922 = state_64910;
(statearr_64922[(4)] = cljs.core.rest((state_64910[(4)])));

return statearr_64922;
})();
var state_64910__$1 = state_64910;
var statearr_64923_65018 = state_64910__$1;
(statearr_64923_65018[(2)] = inst_64905);

(statearr_64923_65018[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (4))){
var inst_64761 = (state_64910[(2)]);
var inst_64762 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64761], 0));
var inst_64763 = cljs.core.ex_data(inst_64761);
var inst_64764 = cljs.core.ex_message(inst_64761);
var inst_64765 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_64763,new cljs.core.Keyword(null,"message","message",-406056002),inst_64764);
var state_64910__$1 = (function (){var statearr_64924 = state_64910;
(statearr_64924[(13)] = inst_64762);

return statearr_64924;
})();
var statearr_64925_65019 = state_64910__$1;
(statearr_64925_65019[(2)] = inst_64765);

(statearr_64925_65019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (54))){
var inst_64868 = (state_64910[(11)]);
var inst_64882 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_64868);
var state_64910__$1 = state_64910;
var statearr_64926_65020 = state_64910__$1;
(statearr_64926_65020[(2)] = inst_64882);

(statearr_64926_65020[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (15))){
var inst_64796 = (state_64910[(14)]);
var inst_64805 = (state_64910[(2)]);
var inst_64806 = fluree.db.util.async.throw_err(inst_64805);
var state_64910__$1 = (function (){var statearr_64927 = state_64910;
(statearr_64927[(15)] = inst_64806);

return statearr_64927;
})();
if(cljs.core.truth_(inst_64796)){
var statearr_64928_65021 = state_64910__$1;
(statearr_64928_65021[(1)] = (16));

} else {
var statearr_64929_65022 = state_64910__$1;
(statearr_64929_65022[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (48))){
var inst_64868 = (state_64910[(11)]);
var inst_64871 = cljs.core.ex_data(inst_64868);
var inst_64872 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64873 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_64871);
var inst_64874 = cljs.core.ex_message(inst_64868);
var inst_64875 = [inst_64873,inst_64874,new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64876 = cljs.core.PersistentHashMap.fromArrays(inst_64872,inst_64875);
var state_64910__$1 = state_64910;
var statearr_64930_65023 = state_64910__$1;
(statearr_64930_65023[(2)] = inst_64876);

(statearr_64930_65023[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (50))){
var inst_64903 = (state_64910[(2)]);
var state_64910__$1 = state_64910;
var statearr_64931_65024 = state_64910__$1;
(statearr_64931_65024[(2)] = inst_64903);

(statearr_64931_65024[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (21))){
var inst_64822 = cljs.core.PersistentHashMap.EMPTY;
var state_64910__$1 = state_64910;
var statearr_64932_65025 = state_64910__$1;
(statearr_64932_65025[(2)] = inst_64822);

(statearr_64932_65025[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (31))){
var inst_64847 = (state_64910[(2)]);
var state_64910__$1 = state_64910;
var statearr_64933_65026 = state_64910__$1;
(statearr_64933_65026[(2)] = inst_64847);

(statearr_64933_65026[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (32))){
var inst_64799 = (state_64910[(16)]);
var state_64910__$1 = state_64910;
var statearr_64934_65027 = state_64910__$1;
(statearr_64934_65027[(2)] = inst_64799);

(statearr_64934_65027[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (40))){
var inst_64857 = (state_64910[(17)]);
var inst_64857__$1 = (state_64910[(2)]);
var inst_64858 = cljs.core.not(inst_64857__$1);
var state_64910__$1 = (function (){var statearr_64935 = state_64910;
(statearr_64935[(17)] = inst_64857__$1);

return statearr_64935;
})();
if(inst_64858){
var statearr_64936_65028 = state_64910__$1;
(statearr_64936_65028[(1)] = (44));

} else {
var statearr_64937_65029 = state_64910__$1;
(statearr_64937_65029[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (56))){
var inst_64801 = (state_64910[(18)]);
var inst_64825 = (state_64910[(19)]);
var inst_64832 = (state_64910[(20)]);
var inst_64799 = (state_64910[(16)]);
var inst_64795 = (state_64910[(21)]);
var inst_64814 = (state_64910[(7)]);
var inst_64793 = (state_64910[(22)]);
var inst_64833 = (state_64910[(23)]);
var inst_64797 = (state_64910[(24)]);
var inst_64869 = (state_64910[(25)]);
var inst_64868 = (state_64910[(11)]);
var inst_64824 = (state_64910[(26)]);
var inst_64879 = (state_64910[(27)]);
var inst_64803 = (state_64910[(28)]);
var inst_64806 = (state_64910[(15)]);
var inst_64815 = (state_64910[(8)]);
var inst_64800 = (state_64910[(10)]);
var inst_64798 = (state_64910[(9)]);
var inst_64830 = (state_64910[(29)]);
var inst_64857 = (state_64910[(17)]);
var inst_64796 = (state_64910[(14)]);
var inst_64794 = (state_64910[(30)]);
var inst_64831 = (state_64910[(31)]);
var inst_64885 = (state_64910[(2)]);
var inst_64886 = cljs.core.deref(inst_64825);
var inst_64887 = (function (){var error_QMARK_ = inst_64869;
var construct = inst_64794;
var valid_query_QMARK_ = inst_64857;
var conn = inst_64815;
var select = inst_64795;
var map__64771 = inst_64793;
var block = inst_64796;
var where = inst_64797;
var prefixes = inst_64798;
var db = inst_64806;
var meta_QMARK_ = inst_64831;
var source_opts = inst_64824;
var fuel = inst_64825;
var db_STAR_ = inst_64814;
var selectDistinct = inst_64799;
var result = inst_64868;
var start_ms = inst_64832;
var selectOne = inst_64800;
var from = inst_64801;
var max_fuel = inst_64830;
var opts = inst_64833;
var selectReduced = inst_64803;
return (function (p1__64758_SHARP_){
var G__64938 = "%.2fms";
var G__64939 = p1__64758_SHARP_;
return goog.string.format(G__64938,G__64939);
});
})();
var inst_64888 = fluree.db.util.core.current_time_millis();
var inst_64889 = (inst_64888 - inst_64832);
var inst_64890 = (inst_64889 / (1000000));
var inst_64891 = (inst_64887.cljs$core$IFn$_invoke$arity$1 ? inst_64887.cljs$core$IFn$_invoke$arity$1(inst_64890) : inst_64887.call(null,inst_64890));
var inst_64892 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_64814);
var inst_64893 = [(200),inst_64885,inst_64886,inst_64891,inst_64892];
var inst_64894 = cljs.core.PersistentHashMap.fromArrays(inst_64879,inst_64893);
var state_64910__$1 = state_64910;
var statearr_64940_65030 = state_64910__$1;
(statearr_64940_65030[(2)] = inst_64894);

(statearr_64940_65030[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (33))){
var inst_64803 = (state_64910[(28)]);
var state_64910__$1 = state_64910;
if(cljs.core.truth_(inst_64803)){
var statearr_64941_65031 = state_64910__$1;
(statearr_64941_65031[(1)] = (35));

} else {
var statearr_64942_65032 = state_64910__$1;
(statearr_64942_65032[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (13))){
var inst_64772 = (state_64910[(32)]);
var state_64910__$1 = state_64910;
var statearr_64943_65033 = state_64910__$1;
(statearr_64943_65033[(2)] = inst_64772);

(statearr_64943_65033[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (22))){
var inst_64802 = (state_64910[(33)]);
var inst_64826 = (state_64910[(34)]);
var inst_64824 = (state_64910[(2)]);
var inst_64825 = cljs.core.volatile_BANG_((0));
var inst_64826__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_64802);
var state_64910__$1 = (function (){var statearr_64944 = state_64910;
(statearr_64944[(19)] = inst_64825);

(statearr_64944[(26)] = inst_64824);

(statearr_64944[(34)] = inst_64826__$1);

return statearr_64944;
})();
if(cljs.core.truth_(inst_64826__$1)){
var statearr_64945_65034 = state_64910__$1;
(statearr_64945_65034[(1)] = (23));

} else {
var statearr_64946_65035 = state_64910__$1;
(statearr_64946_65035[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (36))){
var inst_64794 = (state_64910[(30)]);
var state_64910__$1 = state_64910;
var statearr_64947_65036 = state_64910__$1;
(statearr_64947_65036[(2)] = inst_64794);

(statearr_64947_65036[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (41))){
var inst_64801 = (state_64910[(18)]);
var state_64910__$1 = state_64910;
var statearr_64948_65037 = state_64910__$1;
(statearr_64948_65037[(2)] = inst_64801);

(statearr_64948_65037[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (43))){
var inst_64854 = (state_64910[(2)]);
var state_64910__$1 = state_64910;
var statearr_64949_65038 = state_64910__$1;
(statearr_64949_65038[(2)] = inst_64854);

(statearr_64949_65038[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (29))){
var inst_64800 = (state_64910[(10)]);
var state_64910__$1 = state_64910;
var statearr_64950_65039 = state_64910__$1;
(statearr_64950_65039[(2)] = inst_64800);

(statearr_64950_65039[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (44))){
var inst_64860 = [new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64861 = ["Invalid query.",(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_64862 = cljs.core.PersistentHashMap.fromArrays(inst_64860,inst_64861);
var state_64910__$1 = state_64910;
var statearr_64951_65040 = state_64910__$1;
(statearr_64951_65040[(2)] = inst_64862);

(statearr_64951_65040[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (6))){
var inst_64772 = (state_64910[(32)]);
var inst_64777 = inst_64772.cljs$lang$protocol_mask$partition0$;
var inst_64778 = (inst_64777 & (64));
var inst_64779 = inst_64772.cljs$core$ISeq$;
var inst_64780 = (cljs.core.PROTOCOL_SENTINEL === inst_64779);
var inst_64781 = ((inst_64778) || (inst_64780));
var state_64910__$1 = state_64910;
if(cljs.core.truth_(inst_64781)){
var statearr_64952_65041 = state_64910__$1;
(statearr_64952_65041[(1)] = (9));

} else {
var statearr_64953_65042 = state_64910__$1;
(statearr_64953_65042[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (28))){
var inst_64849 = (state_64910[(12)]);
var inst_64849__$1 = (state_64910[(2)]);
var state_64910__$1 = (function (){var statearr_64954 = state_64910;
(statearr_64954[(12)] = inst_64849__$1);

return statearr_64954;
})();
if(cljs.core.truth_(inst_64849__$1)){
var statearr_64955_65043 = state_64910__$1;
(statearr_64955_65043[(1)] = (38));

} else {
var statearr_64956_65044 = state_64910__$1;
(statearr_64956_65044[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (51))){
var inst_64868 = (state_64910[(11)]);
var inst_64879 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_64880 = cljs.core.sequential_QMARK_(inst_64868);
var state_64910__$1 = (function (){var statearr_64957 = state_64910;
(statearr_64957[(27)] = inst_64879);

return statearr_64957;
})();
if(inst_64880){
var statearr_64958_65045 = state_64910__$1;
(statearr_64958_65045[(1)] = (54));

} else {
var statearr_64959_65046 = state_64910__$1;
(statearr_64959_65046[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (25))){
var inst_64825 = (state_64910[(19)]);
var inst_64795 = (state_64910[(21)]);
var inst_64802 = (state_64910[(33)]);
var inst_64824 = (state_64910[(26)]);
var inst_64830 = (state_64910[(29)]);
var inst_64830__$1 = (state_64910[(2)]);
var inst_64831 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_64802);
var inst_64832 = fluree.db.util.core.current_time_millis();
var inst_64833 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_64802,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_64824,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_64830__$1,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_64825], 0));
var state_64910__$1 = (function (){var statearr_64960 = state_64910;
(statearr_64960[(20)] = inst_64832);

(statearr_64960[(23)] = inst_64833);

(statearr_64960[(29)] = inst_64830__$1);

(statearr_64960[(31)] = inst_64831);

return statearr_64960;
})();
if(cljs.core.truth_(inst_64795)){
var statearr_64961_65047 = state_64910__$1;
(statearr_64961_65047[(1)] = (26));

} else {
var statearr_64962_65048 = state_64910__$1;
(statearr_64962_65048[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (34))){
var inst_64845 = (state_64910[(2)]);
var state_64910__$1 = state_64910;
var statearr_64963_65049 = state_64910__$1;
(statearr_64963_65049[(2)] = inst_64845);

(statearr_64963_65049[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (17))){
var inst_64806 = (state_64910[(15)]);
var state_64910__$1 = state_64910;
var statearr_64964_65050 = state_64910__$1;
(statearr_64964_65050[(2)] = inst_64806);

(statearr_64964_65050[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (3))){
var inst_64908 = (state_64910[(2)]);
var state_64910__$1 = state_64910;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64910__$1,inst_64908);
} else {
if((state_val_64911 === (12))){
var inst_64772 = (state_64910[(32)]);
var inst_64790 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_64772);
var state_64910__$1 = state_64910;
var statearr_64965_65051 = state_64910__$1;
(statearr_64965_65051[(2)] = inst_64790);

(statearr_64965_65051[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (2))){
var inst_64772 = (state_64910[(32)]);
var _ = (function (){var statearr_64966 = state_64910;
(statearr_64966[(4)] = cljs.core.cons((5),(state_64910[(4)])));

return statearr_64966;
})();
var inst_64772__$1 = query_map;
var inst_64774 = (inst_64772__$1 == null);
var inst_64775 = cljs.core.not(inst_64774);
var state_64910__$1 = (function (){var statearr_64967 = state_64910;
(statearr_64967[(32)] = inst_64772__$1);

return statearr_64967;
})();
if(inst_64775){
var statearr_64968_65052 = state_64910__$1;
(statearr_64968_65052[(1)] = (6));

} else {
var statearr_64969_65053 = state_64910__$1;
(statearr_64969_65053[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (23))){
var inst_64826 = (state_64910[(34)]);
var state_64910__$1 = state_64910;
var statearr_64970_65054 = state_64910__$1;
(statearr_64970_65054[(2)] = inst_64826);

(statearr_64970_65054[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (47))){
var inst_64869 = (state_64910[(25)]);
var inst_64868 = (state_64910[(11)]);
var inst_64867 = (state_64910[(2)]);
var inst_64868__$1 = fluree.db.util.async.throw_err(inst_64867);
var inst_64869__$1 = (inst_64868__$1 instanceof cljs.core.ExceptionInfo);
var state_64910__$1 = (function (){var statearr_64971 = state_64910;
(statearr_64971[(25)] = inst_64869__$1);

(statearr_64971[(11)] = inst_64868__$1);

return statearr_64971;
})();
if(cljs.core.truth_(inst_64869__$1)){
var statearr_64972_65055 = state_64910__$1;
(statearr_64972_65055[(1)] = (48));

} else {
var statearr_64973_65056 = state_64910__$1;
(statearr_64973_65056[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (35))){
var inst_64803 = (state_64910[(28)]);
var state_64910__$1 = state_64910;
var statearr_64974_65057 = state_64910__$1;
(statearr_64974_65057[(2)] = inst_64803);

(statearr_64974_65057[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (19))){
var inst_64810 = (state_64910[(2)]);
var inst_64811 = fluree.db.util.async.throw_err(inst_64810);
var state_64910__$1 = state_64910;
var statearr_64975_65058 = state_64910__$1;
(statearr_64975_65058[(2)] = inst_64811);

(statearr_64975_65058[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (57))){
var inst_64868 = (state_64910[(11)]);
var state_64910__$1 = state_64910;
var statearr_64976_65059 = state_64910__$1;
(statearr_64976_65059[(2)] = inst_64868);

(statearr_64976_65059[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (11))){
var inst_64785 = (state_64910[(2)]);
var state_64910__$1 = state_64910;
var statearr_64978_65060 = state_64910__$1;
(statearr_64978_65060[(2)] = inst_64785);

(statearr_64978_65060[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (9))){
var state_64910__$1 = state_64910;
var statearr_64979_65061 = state_64910__$1;
(statearr_64979_65061[(2)] = true);

(statearr_64979_65061[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (5))){
var _ = (function (){var statearr_64980 = state_64910;
(statearr_64980[(4)] = cljs.core.rest((state_64910[(4)])));

return statearr_64980;
})();
var state_64910__$1 = state_64910;
var ex64977 = (state_64910__$1[(2)]);
var statearr_64981_65062 = state_64910__$1;
(statearr_64981_65062[(5)] = ex64977);


var statearr_64982_65063 = state_64910__$1;
(statearr_64982_65063[(1)] = (4));

(statearr_64982_65063[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (14))){
var inst_64793 = (state_64910[(22)]);
var inst_64793__$1 = (state_64910[(2)]);
var inst_64794 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64793__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_64795 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64793__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_64796 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64793__$1,new cljs.core.Keyword(null,"block","block",664686210));
var inst_64797 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64793__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_64798 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64793__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_64799 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64793__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_64800 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64793__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_64801 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64793__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_64802 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64793__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_64803 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_64793__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var state_64910__$1 = (function (){var statearr_64983 = state_64910;
(statearr_64983[(18)] = inst_64801);

(statearr_64983[(16)] = inst_64799);

(statearr_64983[(21)] = inst_64795);

(statearr_64983[(33)] = inst_64802);

(statearr_64983[(22)] = inst_64793__$1);

(statearr_64983[(24)] = inst_64797);

(statearr_64983[(28)] = inst_64803);

(statearr_64983[(10)] = inst_64800);

(statearr_64983[(9)] = inst_64798);

(statearr_64983[(14)] = inst_64796);

(statearr_64983[(30)] = inst_64794);

return statearr_64983;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64910__$1,(15),sources);
} else {
if((state_val_64911 === (45))){
var inst_64814 = (state_64910[(7)]);
var inst_64833 = (state_64910[(23)]);
var inst_64864 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,new cljs.core.Keyword(null,"opts","opts",155075701),inst_64833);
var inst_64865 = fluree.db.query.fql.query(inst_64814,inst_64864);
var state_64910__$1 = state_64910;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64910__$1,(47),inst_64865);
} else {
if((state_val_64911 === (53))){
var inst_64901 = (state_64910[(2)]);
var state_64910__$1 = state_64910;
var statearr_64984_65064 = state_64910__$1;
(statearr_64984_65064[(2)] = inst_64901);

(statearr_64984_65064[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (26))){
var inst_64795 = (state_64910[(21)]);
var state_64910__$1 = state_64910;
var statearr_64985_65065 = state_64910__$1;
(statearr_64985_65065[(2)] = inst_64795);

(statearr_64985_65065[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (16))){
var inst_64806 = (state_64910[(15)]);
var inst_64796 = (state_64910[(14)]);
var inst_64808 = fluree.db.time_travel.as_of_block(inst_64806,inst_64796);
var state_64910__$1 = state_64910;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64910__$1,(19),inst_64808);
} else {
if((state_val_64911 === (38))){
var inst_64801 = (state_64910[(18)]);
var state_64910__$1 = state_64910;
if(cljs.core.truth_(inst_64801)){
var statearr_64986_65066 = state_64910__$1;
(statearr_64986_65066[(1)] = (41));

} else {
var statearr_64987_65067 = state_64910__$1;
(statearr_64987_65067[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (30))){
var inst_64799 = (state_64910[(16)]);
var state_64910__$1 = state_64910;
if(cljs.core.truth_(inst_64799)){
var statearr_64988_65068 = state_64910__$1;
(statearr_64988_65068[(1)] = (32));

} else {
var statearr_64989_65069 = state_64910__$1;
(statearr_64989_65069[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (10))){
var state_64910__$1 = state_64910;
var statearr_64990_65070 = state_64910__$1;
(statearr_64990_65070[(2)] = false);

(statearr_64990_65070[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (18))){
var inst_64814 = (state_64910[(7)]);
var inst_64798 = (state_64910[(9)]);
var inst_64814__$1 = (state_64910[(2)]);
var inst_64815 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_64814__$1);
var state_64910__$1 = (function (){var statearr_64991 = state_64910;
(statearr_64991[(7)] = inst_64814__$1);

(statearr_64991[(8)] = inst_64815);

return statearr_64991;
})();
if(cljs.core.truth_(inst_64798)){
var statearr_64992_65071 = state_64910__$1;
(statearr_64992_65071[(1)] = (20));

} else {
var statearr_64993_65072 = state_64910__$1;
(statearr_64993_65072[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (52))){
var state_64910__$1 = state_64910;
var statearr_64994_65073 = state_64910__$1;
(statearr_64994_65073[(1)] = (57));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (42))){
var inst_64797 = (state_64910[(24)]);
var state_64910__$1 = state_64910;
var statearr_64996_65074 = state_64910__$1;
(statearr_64996_65074[(2)] = inst_64797);

(statearr_64996_65074[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (37))){
var inst_64843 = (state_64910[(2)]);
var state_64910__$1 = state_64910;
var statearr_64997_65075 = state_64910__$1;
(statearr_64997_65075[(2)] = inst_64843);

(statearr_64997_65075[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (8))){
var inst_64788 = (state_64910[(2)]);
var state_64910__$1 = state_64910;
if(cljs.core.truth_(inst_64788)){
var statearr_64998_65076 = state_64910__$1;
(statearr_64998_65076[(1)] = (12));

} else {
var statearr_64999_65077 = state_64910__$1;
(statearr_64999_65077[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64911 === (49))){
var inst_64831 = (state_64910[(31)]);
var state_64910__$1 = state_64910;
if(cljs.core.truth_(inst_64831)){
var statearr_65000_65078 = state_64910__$1;
(statearr_65000_65078[(1)] = (51));

} else {
var statearr_65001_65079 = state_64910__$1;
(statearr_65001_65079[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2879__auto__ = null;
var fluree$db$api_js$state_machine__2879__auto____0 = (function (){
var statearr_65002 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65002[(0)] = fluree$db$api_js$state_machine__2879__auto__);

(statearr_65002[(1)] = (1));

return statearr_65002;
});
var fluree$db$api_js$state_machine__2879__auto____1 = (function (state_64910){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_64910);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65003){var ex__2882__auto__ = e65003;
var statearr_65004_65080 = state_64910;
(statearr_65004_65080[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_64910[(4)]))){
var statearr_65005_65081 = state_64910;
(statearr_65005_65081[(1)] = cljs.core.first((state_64910[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65082 = state_64910;
state_64910 = G__65082;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2879__auto__ = function(state_64910){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2879__auto____1.call(this,state_64910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2879__auto____0;
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2879__auto____1;
return fluree$db$api_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65006 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_65006[(6)] = c__2901__auto__);

return statearr_65006;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.api_js.query_async.cljs$lang$maxFixedArity = 3);

/**
 * Monitors a database for a specific transaction id included in a block.
 * 
 *   Returns a core async channel that will eventually contain a response,
 *   or will close after the timeout has expired.
 * 
 *   Response may contain an exception, if the tx resulted in an exception.
 */
fluree.db.api_js.monitor_tx = (function fluree$db$api_js$monitor_tx(conn,ledger,tid,timeout_ms){
if(cljs.core.int_QMARK_(timeout_ms)){
} else {
throw (new Error(["Assert failed: ","monitor-tx requires timeout to be provided in milliseconds as an integer.","\n","(int? timeout-ms)"].join('')));
}

var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$2(conn,ledger);
var key = cljs.core.random_uuid();
var resp_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout_ms);
fluree.db.session.monitor_tx(session,tid,key,(function (p1__65083_SHARP_){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,p1__65083_SHARP_);
}));

var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65105){
var state_val_65106 = (state_65105[(1)]);
if((state_val_65106 === (1))){
var inst_65087 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65088 = [resp_chan,timeout_chan];
var inst_65089 = (new cljs.core.PersistentVector(null,2,(5),inst_65087,inst_65088,null));
var state_65105__$1 = state_65105;
return cljs.core.async.ioc_alts_BANG_(state_65105__$1,(2),inst_65089);
} else {
if((state_val_65106 === (2))){
var inst_65091 = (state_65105[(2)]);
var inst_65092 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65091,(0),null);
var inst_65093 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65091,(1),null);
var inst_65094 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(timeout_chan,inst_65093);
var state_65105__$1 = (function (){var statearr_65107 = state_65105;
(statearr_65107[(7)] = inst_65092);

return statearr_65107;
})();
if(inst_65094){
var statearr_65108_65118 = state_65105__$1;
(statearr_65108_65118[(1)] = (3));

} else {
var statearr_65109_65119 = state_65105__$1;
(statearr_65109_65119[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65106 === (3))){
var inst_65096 = fluree.db.session.monitor_tx_remove(session,tid,key);
var inst_65097 = [new cljs.core.Keyword(null,"txid","txid",1606205478),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002)];
var inst_65098 = ["Timeout of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(timeout_ms)," ms for reached without transaction being included in new block. Transaction is still being processed. To view transaction results, issue: {\"select\": [\"*\"], \"from\": [\"_tx/id\", \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"\" ]}"].join('');
var inst_65099 = [tid,(408),inst_65098];
var inst_65100 = cljs.core.PersistentHashMap.fromArrays(inst_65097,inst_65099);
var state_65105__$1 = (function (){var statearr_65110 = state_65105;
(statearr_65110[(8)] = inst_65096);

return statearr_65110;
})();
var statearr_65111_65120 = state_65105__$1;
(statearr_65111_65120[(2)] = inst_65100);

(statearr_65111_65120[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65106 === (4))){
var inst_65092 = (state_65105[(7)]);
var state_65105__$1 = state_65105;
var statearr_65112_65121 = state_65105__$1;
(statearr_65112_65121[(2)] = inst_65092);

(statearr_65112_65121[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65106 === (5))){
var inst_65103 = (state_65105[(2)]);
var state_65105__$1 = state_65105;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65105__$1,inst_65103);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$monitor_tx_$_state_machine__2879__auto__ = null;
var fluree$db$api_js$monitor_tx_$_state_machine__2879__auto____0 = (function (){
var statearr_65113 = [null,null,null,null,null,null,null,null,null];
(statearr_65113[(0)] = fluree$db$api_js$monitor_tx_$_state_machine__2879__auto__);

(statearr_65113[(1)] = (1));

return statearr_65113;
});
var fluree$db$api_js$monitor_tx_$_state_machine__2879__auto____1 = (function (state_65105){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_65105);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65114){var ex__2882__auto__ = e65114;
var statearr_65115_65122 = state_65105;
(statearr_65115_65122[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_65105[(4)]))){
var statearr_65116_65123 = state_65105;
(statearr_65116_65123[(1)] = cljs.core.first((state_65105[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65124 = state_65105;
state_65105 = G__65124;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$monitor_tx_$_state_machine__2879__auto__ = function(state_65105){
switch(arguments.length){
case 0:
return fluree$db$api_js$monitor_tx_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$monitor_tx_$_state_machine__2879__auto____1.call(this,state_65105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$monitor_tx_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$monitor_tx_$_state_machine__2879__auto____0;
fluree$db$api_js$monitor_tx_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$monitor_tx_$_state_machine__2879__auto____1;
return fluree$db$api_js$monitor_tx_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65117 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_65117[(6)] = c__2901__auto__);

return statearr_65117;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Helper function to fill out the parts of the transaction that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.tx__GT_command = (function fluree$db$api_js$tx__GT_command(var_args){
var G__65126 = arguments.length;
switch (G__65126) {
case 3:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,txn,private_key){
return fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,private_key,null);
}));

(fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,txn,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-transaction","db/invalid-transaction",1706641798)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__65127 = opts;
var map__65127__$1 = (((((!((map__65127 == null))))?(((((map__65127.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__65127.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__65127):map__65127);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65127__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65127__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65127__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__65127__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
var _ = (cljs.core.truth_(deps)?((cljs.core.sequential_QMARK_(deps))?null:(function(){throw (new Error(["Assert failed: ","Command/transaction 'deps', when provided, must be a sequential list/array.","\n","(sequential? deps)"].join('')))})()):null);
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__65128 = (cljs.core.truth_((function (){var and__4115__auto__ = auth;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4115__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65128,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65128,(1),null);
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4126__auto__ = nonce;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4126__auto__ = expire;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"tx","tx",466630418),txn,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1,new cljs.core.Keyword(null,"deps","deps",1883360319),deps], null)));
}catch (e65132){var e = e65132;

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Transaction contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.tx__GT_command.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.transact_async = (function fluree$db$api_js$transact_async(var_args){
var G__65135 = arguments.length;
switch (G__65135) {
case 3:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,txn){
return fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,txn,null);
}));

(fluree.db.api_js.transact_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,txn,opts){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65221){
var state_val_65222 = (state_65221[(1)]);
if((state_val_65222 === (7))){
var state_65221__$1 = state_65221;
var statearr_65223_65272 = state_65221__$1;
(statearr_65223_65272[(2)] = false);

(statearr_65223_65272[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (20))){
var inst_65188 = (state_65221[(2)]);
var state_65221__$1 = state_65221;
var statearr_65224_65273 = state_65221__$1;
(statearr_65224_65273[(2)] = inst_65188);

(statearr_65224_65273[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (27))){
var inst_65201 = (state_65221[(7)]);
var inst_65204 = cljs.core.ex_data(inst_65201);
var inst_65205 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"message","message",-406056002),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65206 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_65204);
var inst_65207 = cljs.core.ex_message(inst_65201);
var inst_65208 = [inst_65206,inst_65207,new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_65209 = cljs.core.PersistentHashMap.fromArrays(inst_65205,inst_65208);
var state_65221__$1 = state_65221;
var statearr_65225_65274 = state_65221__$1;
(statearr_65225_65274[(2)] = inst_65209);

(statearr_65225_65274[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (1))){
var state_65221__$1 = state_65221;
var statearr_65226_65275 = state_65221__$1;
(statearr_65226_65275[(2)] = null);

(statearr_65226_65275[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (24))){
var inst_65171 = (state_65221[(8)]);
var inst_65196 = (state_65221[(9)]);
var inst_65199 = fluree.db.api_js.monitor_tx(conn,ledger,inst_65196,inst_65171);
var state_65221__$1 = state_65221;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65221__$1,(26),inst_65199);
} else {
if((state_val_65222 === (4))){
var inst_65136 = (state_65221[(2)]);
var inst_65137 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65136], 0));
var inst_65138 = cljs.core.ex_data(inst_65136);
var inst_65139 = cljs.core.ex_message(inst_65136);
var inst_65140 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65138,new cljs.core.Keyword(null,"message","message",-406056002),inst_65139);
var state_65221__$1 = (function (){var statearr_65227 = state_65221;
(statearr_65227[(10)] = inst_65137);

return statearr_65227;
})();
var statearr_65228_65276 = state_65221__$1;
(statearr_65228_65276[(2)] = inst_65140);

(statearr_65228_65276[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (15))){
var inst_65169 = (state_65221[(11)]);
var inst_65170 = (state_65221[(12)]);
var inst_65179 = fluree.db.api_js.tx__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,txn,inst_65169,opts);
var inst_65180 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(inst_65179);
var inst_65181 = fluree.db.operations.command_async(conn,inst_65179);
var state_65221__$1 = (function (){var statearr_65229 = state_65221;
(statearr_65229[(13)] = inst_65180);

(statearr_65229[(14)] = inst_65181);

return statearr_65229;
})();
if(cljs.core.truth_(inst_65170)){
var statearr_65230_65277 = state_65221__$1;
(statearr_65230_65277[(1)] = (18));

} else {
var statearr_65231_65278 = state_65221__$1;
(statearr_65231_65278[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (21))){
var inst_65186 = (state_65221[(2)]);
var state_65221__$1 = state_65221;
var statearr_65232_65279 = state_65221__$1;
(statearr_65232_65279[(2)] = inst_65186);

(statearr_65232_65279[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (13))){
var inst_65147 = (state_65221[(15)]);
var state_65221__$1 = state_65221;
var statearr_65233_65280 = state_65221__$1;
(statearr_65233_65280[(2)] = inst_65147);

(statearr_65233_65280[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (22))){
var inst_65170 = (state_65221[(12)]);
var inst_65196 = (state_65221[(2)]);
var state_65221__$1 = (function (){var statearr_65234 = state_65221;
(statearr_65234[(9)] = inst_65196);

return statearr_65234;
})();
if(cljs.core.truth_(inst_65170)){
var statearr_65235_65281 = state_65221__$1;
(statearr_65235_65281[(1)] = (23));

} else {
var statearr_65236_65282 = state_65221__$1;
(statearr_65236_65282[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (29))){
var inst_65212 = (state_65221[(2)]);
var state_65221__$1 = state_65221;
var statearr_65237_65283 = state_65221__$1;
(statearr_65237_65283[(2)] = inst_65212);

(statearr_65237_65283[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (6))){
var inst_65147 = (state_65221[(15)]);
var inst_65152 = inst_65147.cljs$lang$protocol_mask$partition0$;
var inst_65153 = (inst_65152 & (64));
var inst_65154 = inst_65147.cljs$core$ISeq$;
var inst_65155 = (cljs.core.PROTOCOL_SENTINEL === inst_65154);
var inst_65156 = ((inst_65153) || (inst_65155));
var state_65221__$1 = state_65221;
if(cljs.core.truth_(inst_65156)){
var statearr_65238_65284 = state_65221__$1;
(statearr_65238_65284[(1)] = (9));

} else {
var statearr_65239_65285 = state_65221__$1;
(statearr_65239_65285[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (28))){
var inst_65201 = (state_65221[(7)]);
var state_65221__$1 = state_65221;
var statearr_65240_65286 = state_65221__$1;
(statearr_65240_65286[(2)] = inst_65201);

(statearr_65240_65286[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (25))){
var inst_65214 = (state_65221[(2)]);
var state_65221__$1 = state_65221;
var statearr_65241_65287 = state_65221__$1;
(statearr_65241_65287[(2)] = inst_65214);

(statearr_65241_65287[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (17))){
var inst_65216 = (state_65221[(2)]);
var _ = (function (){var statearr_65242 = state_65221;
(statearr_65242[(4)] = cljs.core.rest((state_65221[(4)])));

return statearr_65242;
})();
var state_65221__$1 = state_65221;
var statearr_65243_65288 = state_65221__$1;
(statearr_65243_65288[(2)] = inst_65216);

(statearr_65243_65288[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (3))){
var inst_65219 = (state_65221[(2)]);
var state_65221__$1 = state_65221;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65221__$1,inst_65219);
} else {
if((state_val_65222 === (12))){
var inst_65147 = (state_65221[(15)]);
var inst_65165 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_65147);
var state_65221__$1 = state_65221;
var statearr_65244_65289 = state_65221__$1;
(statearr_65244_65289[(2)] = inst_65165);

(statearr_65244_65289[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (2))){
var inst_65147 = (state_65221[(15)]);
var _ = (function (){var statearr_65245 = state_65221;
(statearr_65245[(4)] = cljs.core.cons((5),(state_65221[(4)])));

return statearr_65245;
})();
var inst_65147__$1 = opts;
var inst_65149 = (inst_65147__$1 == null);
var inst_65150 = cljs.core.not(inst_65149);
var state_65221__$1 = (function (){var statearr_65246 = state_65221;
(statearr_65246[(15)] = inst_65147__$1);

return statearr_65246;
})();
if(inst_65150){
var statearr_65247_65290 = state_65221__$1;
(statearr_65247_65290[(1)] = (6));

} else {
var statearr_65248_65291 = state_65221__$1;
(statearr_65248_65291[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (23))){
var inst_65196 = (state_65221[(9)]);
var state_65221__$1 = state_65221;
var statearr_65249_65292 = state_65221__$1;
(statearr_65249_65292[(2)] = inst_65196);

(statearr_65249_65292[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (19))){
var inst_65171 = (state_65221[(8)]);
var inst_65180 = (state_65221[(13)]);
var inst_65184 = fluree.db.api_js.monitor_tx(conn,ledger,inst_65180,inst_65171);
var state_65221__$1 = state_65221;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65221__$1,(21),inst_65184);
} else {
if((state_val_65222 === (11))){
var inst_65160 = (state_65221[(2)]);
var state_65221__$1 = state_65221;
var statearr_65251_65293 = state_65221__$1;
(statearr_65251_65293[(2)] = inst_65160);

(statearr_65251_65293[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (9))){
var state_65221__$1 = state_65221;
var statearr_65252_65294 = state_65221__$1;
(statearr_65252_65294[(2)] = true);

(statearr_65252_65294[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (5))){
var _ = (function (){var statearr_65253 = state_65221;
(statearr_65253[(4)] = cljs.core.rest((state_65221[(4)])));

return statearr_65253;
})();
var state_65221__$1 = state_65221;
var ex65250 = (state_65221__$1[(2)]);
var statearr_65254_65295 = state_65221__$1;
(statearr_65254_65295[(5)] = ex65250);


var statearr_65255_65296 = state_65221__$1;
(statearr_65255_65296[(1)] = (4));

(statearr_65255_65296[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (14))){
var inst_65169 = (state_65221[(11)]);
var inst_65168 = (state_65221[(2)]);
var inst_65169__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65168,new cljs.core.Keyword(null,"private-key","private-key",426483388));
var inst_65170 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65168,new cljs.core.Keyword(null,"txid-only","txid-only",1518298509));
var inst_65171 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_65168,new cljs.core.Keyword(null,"timeout","timeout",-318625318),(60000));
var inst_65172 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65168,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_65173 = fluree.db.util.core.current_time_millis();
var inst_65174 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_65168,new cljs.core.Keyword(null,"nonce","nonce",564330331),inst_65173);
var inst_65175 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65168,new cljs.core.Keyword(null,"deps","deps",1883360319));
var inst_65176 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65168,new cljs.core.Keyword(null,"expire","expire",-70657108));
var inst_65177 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65168,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var state_65221__$1 = (function (){var statearr_65256 = state_65221;
(statearr_65256[(16)] = inst_65176);

(statearr_65256[(17)] = inst_65174);

(statearr_65256[(11)] = inst_65169__$1);

(statearr_65256[(18)] = inst_65172);

(statearr_65256[(8)] = inst_65171);

(statearr_65256[(19)] = inst_65177);

(statearr_65256[(20)] = inst_65175);

(statearr_65256[(12)] = inst_65170);

return statearr_65256;
})();
if(cljs.core.truth_(inst_65169__$1)){
var statearr_65257_65297 = state_65221__$1;
(statearr_65257_65297[(1)] = (15));

} else {
var statearr_65258_65298 = state_65221__$1;
(statearr_65258_65298[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (26))){
var inst_65201 = (state_65221[(7)]);
var inst_65201__$1 = (state_65221[(2)]);
var inst_65202 = (inst_65201__$1 instanceof cljs.core.ExceptionInfo);
var state_65221__$1 = (function (){var statearr_65259 = state_65221;
(statearr_65259[(7)] = inst_65201__$1);

return statearr_65259;
})();
if(cljs.core.truth_(inst_65202)){
var statearr_65260_65299 = state_65221__$1;
(statearr_65260_65299[(1)] = (27));

} else {
var statearr_65261_65300 = state_65221__$1;
(statearr_65261_65300[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (16))){
var inst_65176 = (state_65221[(16)]);
var inst_65174 = (state_65221[(17)]);
var inst_65172 = (state_65221[(18)]);
var inst_65177 = (state_65221[(19)]);
var inst_65175 = (state_65221[(20)]);
var inst_65190 = [new cljs.core.Keyword(null,"db","db",993250759),new cljs.core.Keyword(null,"tx","tx",466630418),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"nonce","nonce",564330331),new cljs.core.Keyword(null,"deps","deps",1883360319),new cljs.core.Keyword(null,"expire","expire",-70657108),new cljs.core.Keyword(null,"jwt","jwt",1504015441)];
var inst_65191 = [ledger,txn,inst_65172,inst_65174,inst_65175,inst_65176,inst_65177];
var inst_65192 = cljs.core.PersistentHashMap.fromArrays(inst_65190,inst_65191);
var inst_65193 = fluree.db.util.core.without_nils(inst_65192);
var inst_65194 = fluree.db.operations.transact_async(conn,inst_65193);
var state_65221__$1 = state_65221;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65221__$1,(22),inst_65194);
} else {
if((state_val_65222 === (10))){
var state_65221__$1 = state_65221;
var statearr_65262_65301 = state_65221__$1;
(statearr_65262_65301[(2)] = false);

(statearr_65262_65301[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (18))){
var inst_65181 = (state_65221[(14)]);
var state_65221__$1 = state_65221;
var statearr_65263_65302 = state_65221__$1;
(statearr_65263_65302[(2)] = inst_65181);

(statearr_65263_65302[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65222 === (8))){
var inst_65163 = (state_65221[(2)]);
var state_65221__$1 = state_65221;
if(cljs.core.truth_(inst_65163)){
var statearr_65264_65303 = state_65221__$1;
(statearr_65264_65303[(1)] = (12));

} else {
var statearr_65265_65304 = state_65221__$1;
(statearr_65265_65304[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2879__auto__ = null;
var fluree$db$api_js$state_machine__2879__auto____0 = (function (){
var statearr_65266 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65266[(0)] = fluree$db$api_js$state_machine__2879__auto__);

(statearr_65266[(1)] = (1));

return statearr_65266;
});
var fluree$db$api_js$state_machine__2879__auto____1 = (function (state_65221){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_65221);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65267){var ex__2882__auto__ = e65267;
var statearr_65268_65305 = state_65221;
(statearr_65268_65305[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_65221[(4)]))){
var statearr_65269_65306 = state_65221;
(statearr_65269_65306[(1)] = cljs.core.first((state_65221[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65307 = state_65221;
state_65221 = G__65307;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2879__auto__ = function(state_65221){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2879__auto____1.call(this,state_65221);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2879__auto____0;
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2879__auto____1;
return fluree$db$api_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65270 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_65270[(6)] = c__2901__auto__);

return statearr_65270;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.api_js.transact_async.cljs$lang$maxFixedArity = 4);

fluree.db.api_js.min_safe = (function fluree$db$api_js$min_safe(var_args){
var args__4742__auto__ = [];
var len__4736__auto___65309 = arguments.length;
var i__4737__auto___65310 = (0);
while(true){
if((i__4737__auto___65310 < len__4736__auto___65309)){
args__4742__auto__.push((arguments[i__4737__auto___65310]));

var G__65311 = (i__4737__auto___65310 + (1));
i__4737__auto___65310 = G__65311;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.api_js.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api_js.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api_js.min_safe.cljs$lang$applyTo = (function (seq65308){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq65308));
}));

fluree.db.api_js.format_flake_groups_pretty = (function fluree$db$api_js$format_flake_groups_pretty(db,cache,fuel,flakes){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65342){
var state_val_65343 = (state_65342[(1)]);
if((state_val_65343 === (1))){
var inst_65312 = cljs.core.first(flakes);
var inst_65313 = cljs.core.rest(flakes);
var inst_65314 = cljs.core.PersistentVector.EMPTY;
var inst_65315 = inst_65312;
var inst_65316 = inst_65313;
var inst_65317 = inst_65314;
var state_65342__$1 = (function (){var statearr_65344 = state_65342;
(statearr_65344[(7)] = inst_65315);

(statearr_65344[(8)] = inst_65317);

(statearr_65344[(9)] = inst_65316);

return statearr_65344;
})();
var statearr_65345_65358 = state_65342__$1;
(statearr_65345_65358[(2)] = null);

(statearr_65345_65358[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65343 === (2))){
var inst_65315 = (state_65342[(7)]);
var inst_65319 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_65320 = cljs.core.PersistentHashMap.EMPTY;
var inst_65321 = [true,inst_65320];
var inst_65322 = cljs.core.PersistentHashMap.fromArrays(inst_65319,inst_65321);
var inst_65323 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_65322,inst_65315);
var state_65342__$1 = state_65342;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65342__$1,(4),inst_65323);
} else {
if((state_val_65343 === (3))){
var inst_65340 = (state_65342[(2)]);
var state_65342__$1 = state_65342;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65342__$1,inst_65340);
} else {
if((state_val_65343 === (4))){
var inst_65317 = (state_65342[(8)]);
var inst_65316 = (state_65342[(9)]);
var inst_65325 = (state_65342[(2)]);
var inst_65326 = fluree.db.util.async.throw_err(inst_65325);
var inst_65327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65328 = [inst_65326];
var inst_65329 = (new cljs.core.PersistentVector(null,1,(5),inst_65327,inst_65328,null));
var inst_65330 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_65317,inst_65329);
var inst_65331 = cljs.core.first(inst_65316);
var state_65342__$1 = (function (){var statearr_65346 = state_65342;
(statearr_65346[(10)] = inst_65330);

return statearr_65346;
})();
if(cljs.core.truth_(inst_65331)){
var statearr_65347_65359 = state_65342__$1;
(statearr_65347_65359[(1)] = (5));

} else {
var statearr_65348_65360 = state_65342__$1;
(statearr_65348_65360[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65343 === (5))){
var inst_65330 = (state_65342[(10)]);
var inst_65316 = (state_65342[(9)]);
var inst_65333 = cljs.core.first(inst_65316);
var inst_65334 = cljs.core.rest(inst_65316);
var inst_65315 = inst_65333;
var inst_65316__$1 = inst_65334;
var inst_65317 = inst_65330;
var state_65342__$1 = (function (){var statearr_65349 = state_65342;
(statearr_65349[(7)] = inst_65315);

(statearr_65349[(8)] = inst_65317);

(statearr_65349[(9)] = inst_65316__$1);

return statearr_65349;
})();
var statearr_65350_65361 = state_65342__$1;
(statearr_65350_65361[(2)] = null);

(statearr_65350_65361[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65343 === (6))){
var inst_65330 = (state_65342[(10)]);
var state_65342__$1 = state_65342;
var statearr_65351_65362 = state_65342__$1;
(statearr_65351_65362[(2)] = inst_65330);

(statearr_65351_65362[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65343 === (7))){
var inst_65338 = (state_65342[(2)]);
var state_65342__$1 = state_65342;
var statearr_65352_65363 = state_65342__$1;
(statearr_65352_65363[(2)] = inst_65338);

(statearr_65352_65363[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto__ = null;
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto____0 = (function (){
var statearr_65353 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_65353[(0)] = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto__);

(statearr_65353[(1)] = (1));

return statearr_65353;
});
var fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto____1 = (function (state_65342){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_65342);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65354){var ex__2882__auto__ = e65354;
var statearr_65355_65364 = state_65342;
(statearr_65355_65364[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_65342[(4)]))){
var statearr_65356_65365 = state_65342;
(statearr_65356_65365[(1)] = cljs.core.first((state_65342[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65366 = state_65342;
state_65342 = G__65366;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto__ = function(state_65342){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto____1.call(this,state_65342);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto____0;
fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto____1;
return fluree$db$api_js$format_flake_groups_pretty_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65357 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_65357[(6)] = c__2901__auto__);

return statearr_65357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.api_js.format_block_resp_pretty = (function fluree$db$api_js$format_block_resp_pretty(db,resp){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65434){
var state_val_65435 = (state_65434[(1)]);
if((state_val_65435 === (7))){
var inst_65394 = (state_65434[(2)]);
var inst_65395 = fluree.db.util.async.throw_err(inst_65394);
var state_65434__$1 = state_65434;
var statearr_65436_65462 = state_65434__$1;
(statearr_65436_65462[(2)] = inst_65395);

(statearr_65436_65462[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65435 === (1))){
var inst_65371 = cljs.core.volatile_BANG_((0));
var inst_65372 = cljs.core.PersistentHashMap.EMPTY;
var inst_65373 = cljs.core.volatile_BANG_(inst_65372);
var inst_65374 = cljs.core.first(resp);
var inst_65375 = cljs.core.rest(resp);
var inst_65376 = cljs.core.PersistentVector.EMPTY;
var inst_65377 = inst_65371;
var inst_65378 = inst_65373;
var inst_65379 = inst_65374;
var inst_65380 = inst_65375;
var inst_65381 = inst_65376;
var state_65434__$1 = (function (){var statearr_65437 = state_65434;
(statearr_65437[(7)] = inst_65378);

(statearr_65437[(8)] = inst_65379);

(statearr_65437[(9)] = inst_65380);

(statearr_65437[(10)] = inst_65377);

(statearr_65437[(11)] = inst_65381);

return statearr_65437;
})();
var statearr_65438_65463 = state_65434__$1;
(statearr_65438_65463[(2)] = null);

(statearr_65438_65463[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65435 === (4))){
var inst_65378 = (state_65434[(7)]);
var inst_65383 = (state_65434[(12)]);
var inst_65379 = (state_65434[(8)]);
var inst_65380 = (state_65434[(9)]);
var inst_65377 = (state_65434[(10)]);
var inst_65381 = (state_65434[(11)]);
var inst_65385 = (state_65434[(13)]);
var inst_65389 = (function (){var fuel = inst_65377;
var cache = inst_65378;
var curr_block = inst_65379;
var rest_blocks = inst_65380;
var acc = inst_65381;
var flakes = inst_65383;
var asserted = inst_65385;
return (function (p1__65368_SHARP_){
return p1__65368_SHARP_.s;
});
})();
var inst_65390 = cljs.core.group_by(inst_65389,inst_65385);
var inst_65391 = cljs.core.vals(inst_65390);
var inst_65392 = fluree.db.api_js.format_flake_groups_pretty(db,inst_65378,inst_65377,inst_65391);
var state_65434__$1 = state_65434;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65434__$1,(7),inst_65392);
} else {
if((state_val_65435 === (13))){
var inst_65422 = (state_65434[(14)]);
var state_65434__$1 = state_65434;
var statearr_65439_65464 = state_65434__$1;
(statearr_65439_65464[(2)] = inst_65422);

(statearr_65439_65464[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65435 === (6))){
var inst_65378 = (state_65434[(7)]);
var inst_65383 = (state_65434[(12)]);
var inst_65379 = (state_65434[(8)]);
var inst_65380 = (state_65434[(9)]);
var inst_65400 = (state_65434[(15)]);
var inst_65398 = (state_65434[(16)]);
var inst_65377 = (state_65434[(10)]);
var inst_65381 = (state_65434[(11)]);
var inst_65385 = (state_65434[(13)]);
var inst_65398__$1 = (state_65434[(2)]);
var inst_65399 = (function (){var fuel = inst_65377;
var cache = inst_65378;
var curr_block = inst_65379;
var rest_blocks = inst_65380;
var acc = inst_65381;
var flakes = inst_65383;
var asserted = inst_65385;
var asserted_SINGLEQUOTE_ = inst_65398__$1;
return (function (p1__65369_SHARP_){
return p1__65369_SHARP_.op === false;
});
})();
var inst_65400__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_65399,inst_65383);
var inst_65401 = cljs.core.empty_QMARK_(inst_65400__$1);
var inst_65402 = (!(inst_65401));
var state_65434__$1 = (function (){var statearr_65442 = state_65434;
(statearr_65442[(15)] = inst_65400__$1);

(statearr_65442[(16)] = inst_65398__$1);

return statearr_65442;
})();
if(inst_65402){
var statearr_65443_65465 = state_65434__$1;
(statearr_65443_65465[(1)] = (8));

} else {
var statearr_65444_65466 = state_65434__$1;
(statearr_65444_65466[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65435 === (3))){
var inst_65432 = (state_65434[(2)]);
var state_65434__$1 = state_65434;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65434__$1,inst_65432);
} else {
if((state_val_65435 === (12))){
var inst_65378 = (state_65434[(7)]);
var inst_65422 = (state_65434[(14)]);
var inst_65380 = (state_65434[(9)]);
var inst_65377 = (state_65434[(10)]);
var inst_65425 = cljs.core.first(inst_65380);
var inst_65426 = cljs.core.rest(inst_65380);
var tmp65440 = inst_65378;
var tmp65441 = inst_65377;
var inst_65377__$1 = tmp65441;
var inst_65378__$1 = tmp65440;
var inst_65379 = inst_65425;
var inst_65380__$1 = inst_65426;
var inst_65381 = inst_65422;
var state_65434__$1 = (function (){var statearr_65445 = state_65434;
(statearr_65445[(7)] = inst_65378__$1);

(statearr_65445[(8)] = inst_65379);

(statearr_65445[(9)] = inst_65380__$1);

(statearr_65445[(10)] = inst_65377__$1);

(statearr_65445[(11)] = inst_65381);

return statearr_65445;
})();
var statearr_65446_65467 = state_65434__$1;
(statearr_65446_65467[(2)] = null);

(statearr_65446_65467[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65435 === (2))){
var inst_65378 = (state_65434[(7)]);
var inst_65383 = (state_65434[(12)]);
var inst_65379 = (state_65434[(8)]);
var inst_65380 = (state_65434[(9)]);
var inst_65377 = (state_65434[(10)]);
var inst_65381 = (state_65434[(11)]);
var inst_65385 = (state_65434[(13)]);
var inst_65383__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_65379);
var inst_65384 = (function (){var fuel = inst_65377;
var cache = inst_65378;
var curr_block = inst_65379;
var rest_blocks = inst_65380;
var acc = inst_65381;
var flakes = inst_65383__$1;
return (function (p1__65367_SHARP_){
return p1__65367_SHARP_.op;
});
})();
var inst_65385__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_65384,inst_65383__$1);
var inst_65386 = cljs.core.empty_QMARK_(inst_65385__$1);
var inst_65387 = (!(inst_65386));
var state_65434__$1 = (function (){var statearr_65447 = state_65434;
(statearr_65447[(12)] = inst_65383__$1);

(statearr_65447[(13)] = inst_65385__$1);

return statearr_65447;
})();
if(inst_65387){
var statearr_65448_65468 = state_65434__$1;
(statearr_65448_65468[(1)] = (4));

} else {
var statearr_65449_65469 = state_65434__$1;
(statearr_65449_65469[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65435 === (11))){
var inst_65410 = (state_65434[(2)]);
var inst_65411 = fluree.db.util.async.throw_err(inst_65410);
var state_65434__$1 = state_65434;
var statearr_65450_65470 = state_65434__$1;
(statearr_65450_65470[(2)] = inst_65411);

(statearr_65450_65470[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65435 === (9))){
var state_65434__$1 = state_65434;
var statearr_65451_65471 = state_65434__$1;
(statearr_65451_65471[(2)] = null);

(statearr_65451_65471[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65435 === (5))){
var state_65434__$1 = state_65434;
var statearr_65452_65472 = state_65434__$1;
(statearr_65452_65472[(2)] = null);

(statearr_65452_65472[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65435 === (14))){
var inst_65430 = (state_65434[(2)]);
var state_65434__$1 = state_65434;
var statearr_65453_65473 = state_65434__$1;
(statearr_65453_65473[(2)] = inst_65430);

(statearr_65453_65473[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65435 === (10))){
var inst_65379 = (state_65434[(8)]);
var inst_65380 = (state_65434[(9)]);
var inst_65398 = (state_65434[(16)]);
var inst_65381 = (state_65434[(11)]);
var inst_65414 = (state_65434[(2)]);
var inst_65415 = [new cljs.core.Keyword(null,"asserted","asserted",-1558973611),new cljs.core.Keyword(null,"retracted","retracted",-1399687854)];
var inst_65416 = [inst_65398,inst_65414];
var inst_65417 = cljs.core.PersistentHashMap.fromArrays(inst_65415,inst_65416);
var inst_65418 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65379,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_65417);
var inst_65419 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65420 = [inst_65418];
var inst_65421 = (new cljs.core.PersistentVector(null,1,(5),inst_65419,inst_65420,null));
var inst_65422 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_65381,inst_65421);
var inst_65423 = cljs.core.first(inst_65380);
var state_65434__$1 = (function (){var statearr_65454 = state_65434;
(statearr_65454[(14)] = inst_65422);

return statearr_65454;
})();
if(cljs.core.truth_(inst_65423)){
var statearr_65455_65474 = state_65434__$1;
(statearr_65455_65474[(1)] = (12));

} else {
var statearr_65456_65475 = state_65434__$1;
(statearr_65456_65475[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65435 === (8))){
var inst_65378 = (state_65434[(7)]);
var inst_65383 = (state_65434[(12)]);
var inst_65379 = (state_65434[(8)]);
var inst_65380 = (state_65434[(9)]);
var inst_65400 = (state_65434[(15)]);
var inst_65398 = (state_65434[(16)]);
var inst_65377 = (state_65434[(10)]);
var inst_65381 = (state_65434[(11)]);
var inst_65385 = (state_65434[(13)]);
var inst_65404 = (function (){var flakes = inst_65383;
var rest_blocks = inst_65380;
var curr_block = inst_65379;
var asserted_SINGLEQUOTE_ = inst_65398;
var acc = inst_65381;
var fuel = inst_65377;
var cache = inst_65378;
var retracted = inst_65400;
var asserted = inst_65385;
return (function (p1__65370_SHARP_){
return p1__65370_SHARP_.s;
});
})();
var inst_65405 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.flip_flake,inst_65400);
var inst_65406 = cljs.core.group_by(inst_65404,inst_65405);
var inst_65407 = cljs.core.vals(inst_65406);
var inst_65408 = fluree.db.api_js.format_flake_groups_pretty(db,inst_65378,inst_65377,inst_65407);
var state_65434__$1 = state_65434;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65434__$1,(11),inst_65408);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto__ = null;
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto____0 = (function (){
var statearr_65457 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65457[(0)] = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto__);

(statearr_65457[(1)] = (1));

return statearr_65457;
});
var fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto____1 = (function (state_65434){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_65434);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65458){var ex__2882__auto__ = e65458;
var statearr_65459_65476 = state_65434;
(statearr_65459_65476[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_65434[(4)]))){
var statearr_65460_65477 = state_65434;
(statearr_65460_65477[(1)] = cljs.core.first((state_65434[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65478 = state_65434;
state_65434 = G__65478;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto__ = function(state_65434){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto____1.call(this,state_65434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto____0;
fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto____1;
return fluree$db$api_js$format_block_resp_pretty_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65461 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_65461[(6)] = c__2901__auto__);

return statearr_65461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.api_js.format_history_resp = (function fluree$db$api_js$format_history_resp(db,resp){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65578){
var state_val_65579 = (state_65578[(1)]);
if((state_val_65579 === (7))){
var inst_65543 = (state_65578[(7)]);
var inst_65550 = (state_65578[(8)]);
var inst_65549 = cljs.core.seq(inst_65543);
var inst_65550__$1 = cljs.core.first(inst_65549);
var inst_65551 = cljs.core.next(inst_65549);
var state_65578__$1 = (function (){var statearr_65580 = state_65578;
(statearr_65580[(8)] = inst_65550__$1);

(statearr_65580[(9)] = inst_65551);

return statearr_65580;
})();
if(cljs.core.truth_(inst_65550__$1)){
var statearr_65581_65618 = state_65578__$1;
(statearr_65581_65618[(1)] = (9));

} else {
var statearr_65582_65619 = state_65578__$1;
(statearr_65582_65619[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65579 === (1))){
var state_65578__$1 = state_65578;
var statearr_65583_65620 = state_65578__$1;
(statearr_65583_65620[(2)] = null);

(statearr_65583_65620[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65579 === (4))){
var inst_65480 = (state_65578[(2)]);
var state_65578__$1 = state_65578;
var statearr_65584_65621 = state_65578__$1;
(statearr_65584_65621[(2)] = inst_65480);

(statearr_65584_65621[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65579 === (6))){
var inst_65529 = (state_65578[(2)]);
var inst_65530 = fluree.db.util.async.throw_err(inst_65529);
var inst_65538 = resp;
var inst_65539 = cljs.core.seq(inst_65538);
var inst_65540 = cljs.core.first(inst_65539);
var inst_65541 = cljs.core.next(inst_65539);
var inst_65542 = cljs.core.PersistentHashMap.EMPTY;
var inst_65543 = inst_65538;
var inst_65544 = inst_65542;
var state_65578__$1 = (function (){var statearr_65585 = state_65578;
(statearr_65585[(7)] = inst_65543);

(statearr_65585[(10)] = inst_65544);

(statearr_65585[(11)] = inst_65530);

(statearr_65585[(12)] = inst_65540);

(statearr_65585[(13)] = inst_65541);

return statearr_65585;
})();
var statearr_65586_65622 = state_65578__$1;
(statearr_65586_65622[(2)] = null);

(statearr_65586_65622[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65579 === (3))){
var inst_65576 = (state_65578[(2)]);
var state_65578__$1 = state_65578;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65578__$1,inst_65576);
} else {
if((state_val_65579 === (2))){
var _ = (function (){var statearr_65587 = state_65578;
(statearr_65587[(4)] = cljs.core.cons((5),(state_65578[(4)])));

return statearr_65587;
})();
var inst_65486 = (function (){return (function (p1__65479_SHARP_){
return p1__65479_SHARP_.t;
});
})();
var inst_65487 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_65486,resp);
var inst_65488 = cljs.core.set(inst_65487);
var inst_65525 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_65526 = (function (){var ts = inst_65488;
var c__2901__auto____$1 = inst_65525;
return (function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65523){
var state_val_65524 = (state_65523[(1)]);
if((state_val_65524 === (1))){
var inst_65496 = ts;
var inst_65497 = cljs.core.seq(inst_65496);
var inst_65498 = cljs.core.first(inst_65497);
var inst_65499 = cljs.core.next(inst_65497);
var inst_65500 = cljs.core.PersistentHashMap.EMPTY;
var inst_65501 = inst_65496;
var inst_65502 = inst_65500;
var state_65523__$1 = (function (){var statearr_65588 = state_65523;
(statearr_65588[(7)] = inst_65502);

(statearr_65588[(8)] = inst_65498);

(statearr_65588[(9)] = inst_65501);

(statearr_65588[(10)] = inst_65499);

return statearr_65588;
})();
var statearr_65589_65623 = state_65523__$1;
(statearr_65589_65623[(2)] = null);

(statearr_65589_65623[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65524 === (2))){
var inst_65508 = (state_65523[(11)]);
var inst_65501 = (state_65523[(9)]);
var inst_65507 = cljs.core.seq(inst_65501);
var inst_65508__$1 = cljs.core.first(inst_65507);
var inst_65509 = cljs.core.next(inst_65507);
var state_65523__$1 = (function (){var statearr_65590 = state_65523;
(statearr_65590[(11)] = inst_65508__$1);

(statearr_65590[(12)] = inst_65509);

return statearr_65590;
})();
if(cljs.core.truth_(inst_65508__$1)){
var statearr_65591_65624 = state_65523__$1;
(statearr_65591_65624[(1)] = (4));

} else {
var statearr_65592_65625 = state_65523__$1;
(statearr_65592_65625[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65524 === (3))){
var inst_65521 = (state_65523[(2)]);
var state_65523__$1 = state_65523;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65523__$1,inst_65521);
} else {
if((state_val_65524 === (4))){
var inst_65508 = (state_65523[(11)]);
var inst_65511 = fluree.db.time_travel.non_border_t_to_block(db,inst_65508);
var state_65523__$1 = state_65523;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65523__$1,(7),inst_65511);
} else {
if((state_val_65524 === (5))){
var inst_65502 = (state_65523[(7)]);
var state_65523__$1 = state_65523;
var statearr_65593_65626 = state_65523__$1;
(statearr_65593_65626[(2)] = inst_65502);

(statearr_65593_65626[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65524 === (6))){
var inst_65519 = (state_65523[(2)]);
var state_65523__$1 = state_65523;
var statearr_65594_65627 = state_65523__$1;
(statearr_65594_65627[(2)] = inst_65519);

(statearr_65594_65627[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65524 === (7))){
var inst_65502 = (state_65523[(7)]);
var inst_65508 = (state_65523[(11)]);
var inst_65509 = (state_65523[(12)]);
var inst_65513 = (state_65523[(2)]);
var inst_65514 = fluree.db.util.async.throw_err(inst_65513);
var inst_65515 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65502,inst_65508,inst_65514);
var inst_65501 = inst_65509;
var inst_65502__$1 = inst_65515;
var state_65523__$1 = (function (){var statearr_65595 = state_65523;
(statearr_65595[(7)] = inst_65502__$1);

(statearr_65595[(9)] = inst_65501);

return statearr_65595;
})();
var statearr_65596_65628 = state_65523__$1;
(statearr_65596_65628[(2)] = null);

(statearr_65596_65628[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____0 = (function (){
var statearr_65597 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65597[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__);

(statearr_65597[(1)] = (1));

return statearr_65597;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____1 = (function (state_65523){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_65523);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65598){var ex__2882__auto__ = e65598;
var statearr_65599_65629 = state_65523;
(statearr_65599_65629[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_65523[(4)]))){
var statearr_65600_65630 = state_65523;
(statearr_65600_65630[(1)] = cljs.core.first((state_65523[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65631 = state_65523;
state_65523 = G__65631;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__ = function(state_65523){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____1.call(this,state_65523);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65601 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_65601[(6)] = c__2901__auto____$1);

return statearr_65601;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
});
})();
var inst_65527 = cljs.core.async.impl.dispatch.run(inst_65526);
var state_65578__$1 = (function (){var statearr_65602 = state_65578;
(statearr_65602[(14)] = inst_65527);

return statearr_65602;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65578__$1,(6),inst_65525);
} else {
if((state_val_65579 === (11))){
var inst_65570 = (state_65578[(2)]);
var state_65578__$1 = state_65578;
var statearr_65604_65632 = state_65578__$1;
(statearr_65604_65632[(2)] = inst_65570);

(statearr_65604_65632[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65579 === (9))){
var inst_65550 = (state_65578[(8)]);
var inst_65544 = (state_65578[(10)]);
var inst_65530 = (state_65578[(11)]);
var inst_65551 = (state_65578[(9)]);
var inst_65553 = inst_65550.t;
var inst_65554 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65530,inst_65553);
var inst_65555 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65556 = [inst_65554,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_65557 = (new cljs.core.PersistentVector(null,2,(5),inst_65555,inst_65556,null));
var inst_65558 = cljs.core.assoc_in(inst_65544,inst_65557,inst_65554);
var inst_65559 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65560 = [inst_65554,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_65561 = (new cljs.core.PersistentVector(null,2,(5),inst_65559,inst_65560,null));
var inst_65562 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_65558,inst_65561,cljs.core.conj,inst_65550);
var inst_65563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65564 = [inst_65554,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_65565 = (new cljs.core.PersistentVector(null,2,(5),inst_65563,inst_65564,null));
var inst_65566 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_65562,inst_65565,fluree.db.api_js.min_safe,inst_65553);
var inst_65543 = inst_65551;
var inst_65544__$1 = inst_65566;
var state_65578__$1 = (function (){var statearr_65605 = state_65578;
(statearr_65605[(7)] = inst_65543);

(statearr_65605[(10)] = inst_65544__$1);

return statearr_65605;
})();
var statearr_65606_65633 = state_65578__$1;
(statearr_65606_65633[(2)] = null);

(statearr_65606_65633[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65579 === (5))){
var _ = (function (){var statearr_65607 = state_65578;
(statearr_65607[(4)] = cljs.core.rest((state_65578[(4)])));

return statearr_65607;
})();
var state_65578__$1 = state_65578;
var ex65603 = (state_65578__$1[(2)]);
var statearr_65608_65634 = state_65578__$1;
(statearr_65608_65634[(5)] = ex65603);


if((ex65603 instanceof Error)){
var statearr_65609_65635 = state_65578__$1;
(statearr_65609_65635[(1)] = (4));

(statearr_65609_65635[(5)] = null);

} else {
throw ex65603;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65579 === (10))){
var inst_65544 = (state_65578[(10)]);
var state_65578__$1 = state_65578;
var statearr_65610_65636 = state_65578__$1;
(statearr_65610_65636[(2)] = inst_65544);

(statearr_65610_65636[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65579 === (8))){
var inst_65572 = (state_65578[(2)]);
var inst_65573 = cljs.core.vals(inst_65572);
var _ = (function (){var statearr_65611 = state_65578;
(statearr_65611[(4)] = cljs.core.rest((state_65578[(4)])));

return statearr_65611;
})();
var state_65578__$1 = state_65578;
var statearr_65612_65637 = state_65578__$1;
(statearr_65612_65637[(2)] = inst_65573);

(statearr_65612_65637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__ = null;
var fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____0 = (function (){
var statearr_65613 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65613[(0)] = fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__);

(statearr_65613[(1)] = (1));

return statearr_65613;
});
var fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____1 = (function (state_65578){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_65578);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65614){var ex__2882__auto__ = e65614;
var statearr_65615_65638 = state_65578;
(statearr_65615_65638[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_65578[(4)]))){
var statearr_65616_65639 = state_65578;
(statearr_65616_65639[(1)] = cljs.core.first((state_65578[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65640 = state_65578;
state_65578 = G__65640;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__ = function(state_65578){
switch(arguments.length){
case 0:
return fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____1.call(this,state_65578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____0;
fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$format_history_resp_$_state_machine__2879__auto____1;
return fluree$db$api_js$format_history_resp_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65617 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_65617[(6)] = c__2901__auto__);

return statearr_65617;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns an asynchronous channel that eventually contains the start and end block for a query
 *   or an error.
 */
fluree.db.api_js.resolve_block_range = (function fluree$db$api_js$resolve_block_range(db,query_map){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_65782){
var state_val_65783 = (state_65782[(1)]);
if((state_val_65783 === (7))){
var inst_65665 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65666 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65667 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65668 = [inst_65666,inst_65667];
var inst_65669 = (new cljs.core.PersistentVector(null,2,(5),inst_65665,inst_65668,null));
var state_65782__$1 = state_65782;
var statearr_65784_65851 = state_65782__$1;
(statearr_65784_65851[(2)] = inst_65669);

(statearr_65784_65851[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (20))){
var inst_65695 = (state_65782[(7)]);
var state_65782__$1 = state_65782;
var statearr_65785_65852 = state_65782__$1;
(statearr_65785_65852[(2)] = inst_65695);

(statearr_65785_65852[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (27))){
var state_65782__$1 = state_65782;
var statearr_65786_65853 = state_65782__$1;
(statearr_65786_65853[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (1))){
var state_65782__$1 = state_65782;
var statearr_65788_65854 = state_65782__$1;
(statearr_65788_65854[(2)] = null);

(statearr_65788_65854[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (24))){
var inst_65694 = (state_65782[(8)]);
var state_65782__$1 = state_65782;
if(cljs.core.truth_(inst_65694)){
var statearr_65789_65855 = state_65782__$1;
(statearr_65789_65855[(1)] = (26));

} else {
var statearr_65790_65856 = state_65782__$1;
(statearr_65790_65856[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (39))){
var inst_65769 = (state_65782[(9)]);
var state_65782__$1 = state_65782;
var statearr_65791_65857 = state_65782__$1;
(statearr_65791_65857[(2)] = inst_65769);

(statearr_65791_65857[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (4))){
var inst_65641 = (state_65782[(2)]);
var inst_65642 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65641], 0));
var inst_65643 = cljs.core.ex_data(inst_65641);
var inst_65644 = cljs.core.ex_message(inst_65641);
var inst_65645 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65643,new cljs.core.Keyword(null,"message","message",-406056002),inst_65644);
var state_65782__$1 = (function (){var statearr_65792 = state_65782;
(statearr_65792[(10)] = inst_65642);

return statearr_65792;
})();
var statearr_65793_65858 = state_65782__$1;
(statearr_65793_65858[(2)] = inst_65645);

(statearr_65793_65858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (15))){
var inst_65679 = (state_65782[(11)]);
var inst_65674 = (state_65782[(12)]);
var inst_65688 = (state_65782[(2)]);
var inst_65689 = [inst_65679,inst_65688];
var inst_65690 = (new cljs.core.PersistentVector(null,2,(5),inst_65674,inst_65689,null));
var state_65782__$1 = state_65782;
var statearr_65794_65859 = state_65782__$1;
(statearr_65794_65859[(2)] = inst_65690);

(statearr_65794_65859[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (21))){
var inst_65694 = (state_65782[(8)]);
var state_65782__$1 = state_65782;
var statearr_65795_65860 = state_65782__$1;
(statearr_65795_65860[(2)] = inst_65694);

(statearr_65795_65860[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (31))){
var inst_65735 = (state_65782[(2)]);
var state_65782__$1 = state_65782;
var statearr_65796_65861 = state_65782__$1;
(statearr_65796_65861[(2)] = inst_65735);

(statearr_65796_65861[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (32))){
var inst_65671 = (state_65782[(13)]);
var inst_65747 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65671], 0));
var inst_65748 = ["Invalid block range provided: ",inst_65747].join('');
var inst_65749 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65750 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65751 = cljs.core.PersistentHashMap.fromArrays(inst_65749,inst_65750);
var inst_65752 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65748,inst_65751);
var inst_65753 = (function(){throw inst_65752})();
var state_65782__$1 = state_65782;
var statearr_65797_65862 = state_65782__$1;
(statearr_65797_65862[(2)] = inst_65753);

(statearr_65797_65862[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (40))){
var inst_65768 = (state_65782[(14)]);
var inst_65774 = (state_65782[(2)]);
var inst_65775 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65776 = [inst_65768,inst_65774];
var inst_65777 = (new cljs.core.PersistentVector(null,2,(5),inst_65775,inst_65776,null));
var _ = (function (){var statearr_65798 = state_65782;
(statearr_65798[(4)] = cljs.core.rest((state_65782[(4)])));

return statearr_65798;
})();
var state_65782__$1 = state_65782;
var statearr_65799_65863 = state_65782__$1;
(statearr_65799_65863[(2)] = inst_65777);

(statearr_65799_65863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (33))){
var state_65782__$1 = state_65782;
var statearr_65800_65864 = state_65782__$1;
(statearr_65800_65864[(2)] = null);

(statearr_65800_65864[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (13))){
var inst_65680 = (state_65782[(15)]);
var inst_65682 = fluree.db.time_travel.block_to_int_format(db,inst_65680);
var state_65782__$1 = state_65782;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65782__$1,(16),inst_65682);
} else {
if((state_val_65783 === (22))){
var inst_65713 = (state_65782[(2)]);
var state_65782__$1 = state_65782;
if(cljs.core.truth_(inst_65713)){
var statearr_65801_65865 = state_65782__$1;
(statearr_65801_65865[(1)] = (23));

} else {
var statearr_65802_65866 = state_65782__$1;
(statearr_65802_65866[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (36))){
var inst_65741 = (state_65782[(16)]);
var inst_65740 = (state_65782[(17)]);
var inst_65763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65764 = [inst_65740,inst_65741];
var inst_65765 = (new cljs.core.PersistentVector(null,2,(5),inst_65763,inst_65764,null));
var state_65782__$1 = state_65782;
var statearr_65803_65867 = state_65782__$1;
(statearr_65803_65867[(2)] = inst_65765);

(statearr_65803_65867[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (29))){
var inst_65671 = (state_65782[(13)]);
var inst_65726 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65671], 0));
var inst_65727 = ["Invalid block range provided: ",inst_65726].join('');
var inst_65728 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65729 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65730 = cljs.core.PersistentHashMap.fromArrays(inst_65728,inst_65729);
var inst_65731 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65727,inst_65730);
var inst_65732 = (function(){throw inst_65731})();
var state_65782__$1 = state_65782;
var statearr_65804_65868 = state_65782__$1;
(statearr_65804_65868[(2)] = inst_65732);

(statearr_65804_65868[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (6))){
var inst_65663 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_65782__$1 = state_65782;
var statearr_65805_65869 = state_65782__$1;
(statearr_65805_65869[(2)] = inst_65663);

(statearr_65805_65869[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (28))){
var inst_65737 = (state_65782[(2)]);
var state_65782__$1 = state_65782;
var statearr_65806_65870 = state_65782__$1;
(statearr_65806_65870[(2)] = inst_65737);

(statearr_65806_65870[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (25))){
var inst_65741 = (state_65782[(16)]);
var inst_65740 = (state_65782[(17)]);
var inst_65739 = (state_65782[(2)]);
var inst_65740__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65739,(0),null);
var inst_65741__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65739,(1),null);
var inst_65742 = cljs.core.pos_int_QMARK_(inst_65740__$1);
var inst_65743 = cljs.core.pos_int_QMARK_(inst_65741__$1);
var inst_65744 = ((inst_65742) && (inst_65743));
var inst_65745 = cljs.core.not(inst_65744);
var state_65782__$1 = (function (){var statearr_65807 = state_65782;
(statearr_65807[(16)] = inst_65741__$1);

(statearr_65807[(17)] = inst_65740__$1);

return statearr_65807;
})();
if(inst_65745){
var statearr_65808_65871 = state_65782__$1;
(statearr_65808_65871[(1)] = (32));

} else {
var statearr_65809_65872 = state_65782__$1;
(statearr_65809_65872[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (34))){
var inst_65741 = (state_65782[(16)]);
var inst_65740 = (state_65782[(17)]);
var inst_65756 = (state_65782[(2)]);
var inst_65757 = (inst_65741 < inst_65740);
var state_65782__$1 = (function (){var statearr_65810 = state_65782;
(statearr_65810[(18)] = inst_65756);

return statearr_65810;
})();
if(cljs.core.truth_(inst_65757)){
var statearr_65811_65873 = state_65782__$1;
(statearr_65811_65873[(1)] = (35));

} else {
var statearr_65812_65874 = state_65782__$1;
(statearr_65812_65874[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (17))){
var inst_65694 = (state_65782[(8)]);
var inst_65696 = (state_65782[(19)]);
var inst_65699 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65694], 0));
var inst_65700 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65696], 0));
var inst_65701 = ["Start block is out of range for this ledger. Start block provided: ",inst_65699,". Database block: ",inst_65700].join('');
var inst_65702 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65703 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65704 = cljs.core.PersistentHashMap.fromArrays(inst_65702,inst_65703);
var inst_65705 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65701,inst_65704);
var inst_65706 = (function(){throw inst_65705})();
var state_65782__$1 = state_65782;
var statearr_65813_65875 = state_65782__$1;
(statearr_65813_65875[(2)] = inst_65706);

(statearr_65813_65875[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (3))){
var inst_65780 = (state_65782[(2)]);
var state_65782__$1 = state_65782;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65782__$1,inst_65780);
} else {
if((state_val_65783 === (12))){
var inst_65680 = (state_65782[(15)]);
var inst_65671 = (state_65782[(13)]);
var inst_65678 = (state_65782[(2)]);
var inst_65679 = fluree.db.util.async.throw_err(inst_65678);
var inst_65680__$1 = cljs.core.second(inst_65671);
var state_65782__$1 = (function (){var statearr_65814 = state_65782;
(statearr_65814[(11)] = inst_65679);

(statearr_65814[(15)] = inst_65680__$1);

return statearr_65814;
})();
if(cljs.core.truth_(inst_65680__$1)){
var statearr_65815_65876 = state_65782__$1;
(statearr_65815_65876[(1)] = (13));

} else {
var statearr_65816_65877 = state_65782__$1;
(statearr_65816_65877[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (2))){
var _ = (function (){var statearr_65817 = state_65782;
(statearr_65817[(4)] = cljs.core.cons((5),(state_65782[(4)])));

return statearr_65817;
})();
var inst_65660 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_65661 = cljs.core.sequential_QMARK_(inst_65660);
var state_65782__$1 = state_65782;
if(inst_65661){
var statearr_65818_65878 = state_65782__$1;
(statearr_65818_65878[(1)] = (6));

} else {
var statearr_65819_65879 = state_65782__$1;
(statearr_65819_65879[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (23))){
var inst_65694 = (state_65782[(8)]);
var inst_65695 = (state_65782[(7)]);
var inst_65715 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65716 = [inst_65694,inst_65695];
var inst_65717 = (new cljs.core.PersistentVector(null,2,(5),inst_65715,inst_65716,null));
var state_65782__$1 = state_65782;
var statearr_65820_65880 = state_65782__$1;
(statearr_65820_65880[(2)] = inst_65717);

(statearr_65820_65880[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (35))){
var inst_65741 = (state_65782[(16)]);
var inst_65740 = (state_65782[(17)]);
var inst_65759 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65760 = [inst_65741,inst_65740];
var inst_65761 = (new cljs.core.PersistentVector(null,2,(5),inst_65759,inst_65760,null));
var state_65782__$1 = state_65782;
var statearr_65821_65881 = state_65782__$1;
(statearr_65821_65881[(2)] = inst_65761);

(statearr_65821_65881[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (19))){
var inst_65694 = (state_65782[(8)]);
var inst_65709 = (state_65782[(2)]);
var state_65782__$1 = (function (){var statearr_65822 = state_65782;
(statearr_65822[(20)] = inst_65709);

return statearr_65822;
})();
if(cljs.core.truth_(inst_65694)){
var statearr_65823_65882 = state_65782__$1;
(statearr_65823_65882[(1)] = (20));

} else {
var statearr_65824_65883 = state_65782__$1;
(statearr_65824_65883[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (11))){
var inst_65694 = (state_65782[(8)]);
var inst_65696 = (state_65782[(19)]);
var inst_65693 = (state_65782[(2)]);
var inst_65694__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65693,(0),null);
var inst_65695 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65693,(1),null);
var inst_65696__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_65697 = (inst_65694__$1 > inst_65696__$1);
var state_65782__$1 = (function (){var statearr_65826 = state_65782;
(statearr_65826[(8)] = inst_65694__$1);

(statearr_65826[(7)] = inst_65695);

(statearr_65826[(19)] = inst_65696__$1);

return statearr_65826;
})();
if(cljs.core.truth_(inst_65697)){
var statearr_65827_65884 = state_65782__$1;
(statearr_65827_65884[(1)] = (17));

} else {
var statearr_65828_65885 = state_65782__$1;
(statearr_65828_65885[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (9))){
var inst_65671 = (state_65782[(13)]);
var inst_65674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65675 = cljs.core.first(inst_65671);
var inst_65676 = fluree.db.time_travel.block_to_int_format(db,inst_65675);
var state_65782__$1 = (function (){var statearr_65829 = state_65782;
(statearr_65829[(12)] = inst_65674);

return statearr_65829;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65782__$1,(12),inst_65676);
} else {
if((state_val_65783 === (5))){
var _ = (function (){var statearr_65830 = state_65782;
(statearr_65830[(4)] = cljs.core.rest((state_65782[(4)])));

return statearr_65830;
})();
var state_65782__$1 = state_65782;
var ex65825 = (state_65782__$1[(2)]);
var statearr_65831_65886 = state_65782__$1;
(statearr_65831_65886[(5)] = ex65825);


var statearr_65832_65887 = state_65782__$1;
(statearr_65832_65887[(1)] = (4));

(statearr_65832_65887[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (14))){
var state_65782__$1 = state_65782;
var statearr_65833_65888 = state_65782__$1;
(statearr_65833_65888[(2)] = null);

(statearr_65833_65888[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (26))){
var inst_65694 = (state_65782[(8)]);
var inst_65720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65721 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_65722 = [inst_65694,inst_65721];
var inst_65723 = (new cljs.core.PersistentVector(null,2,(5),inst_65720,inst_65722,null));
var state_65782__$1 = state_65782;
var statearr_65834_65889 = state_65782__$1;
(statearr_65834_65889[(2)] = inst_65723);

(statearr_65834_65889[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (16))){
var inst_65684 = (state_65782[(2)]);
var inst_65685 = fluree.db.util.async.throw_err(inst_65684);
var state_65782__$1 = state_65782;
var statearr_65835_65890 = state_65782__$1;
(statearr_65835_65890[(2)] = inst_65685);

(statearr_65835_65890[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (38))){
var inst_65696 = (state_65782[(19)]);
var state_65782__$1 = state_65782;
var statearr_65836_65891 = state_65782__$1;
(statearr_65836_65891[(2)] = inst_65696);

(statearr_65836_65891[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (30))){
var state_65782__$1 = state_65782;
var statearr_65837_65892 = state_65782__$1;
(statearr_65837_65892[(2)] = null);

(statearr_65837_65892[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (10))){
var inst_65671 = (state_65782[(13)]);
var state_65782__$1 = state_65782;
var statearr_65838_65893 = state_65782__$1;
(statearr_65838_65893[(2)] = inst_65671);

(statearr_65838_65893[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (18))){
var state_65782__$1 = state_65782;
var statearr_65839_65894 = state_65782__$1;
(statearr_65839_65894[(2)] = null);

(statearr_65839_65894[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (37))){
var inst_65769 = (state_65782[(9)]);
var inst_65696 = (state_65782[(19)]);
var inst_65767 = (state_65782[(2)]);
var inst_65768 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65767,(0),null);
var inst_65769__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65767,(1),null);
var inst_65770 = (inst_65769__$1 > inst_65696);
var state_65782__$1 = (function (){var statearr_65840 = state_65782;
(statearr_65840[(9)] = inst_65769__$1);

(statearr_65840[(14)] = inst_65768);

return statearr_65840;
})();
if(cljs.core.truth_(inst_65770)){
var statearr_65841_65895 = state_65782__$1;
(statearr_65841_65895[(1)] = (38));

} else {
var statearr_65842_65896 = state_65782__$1;
(statearr_65842_65896[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_65783 === (8))){
var inst_65671 = (state_65782[(13)]);
var inst_65671__$1 = (state_65782[(2)]);
var inst_65672 = cljs.core.some(cljs.core.string_QMARK_,inst_65671__$1);
var state_65782__$1 = (function (){var statearr_65843 = state_65782;
(statearr_65843[(13)] = inst_65671__$1);

return statearr_65843;
})();
if(cljs.core.truth_(inst_65672)){
var statearr_65844_65897 = state_65782__$1;
(statearr_65844_65897[(1)] = (9));

} else {
var statearr_65845_65898 = state_65782__$1;
(statearr_65845_65898[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto__ = null;
var fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto____0 = (function (){
var statearr_65846 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65846[(0)] = fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto__);

(statearr_65846[(1)] = (1));

return statearr_65846;
});
var fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto____1 = (function (state_65782){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_65782);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e65847){var ex__2882__auto__ = e65847;
var statearr_65848_65899 = state_65782;
(statearr_65848_65899[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_65782[(4)]))){
var statearr_65849_65900 = state_65782;
(statearr_65849_65900[(1)] = cljs.core.first((state_65782[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__65901 = state_65782;
state_65782 = G__65901;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto__ = function(state_65782){
switch(arguments.length){
case 0:
return fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto____1.call(this,state_65782);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto____0;
fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto____1;
return fluree$db$api_js$resolve_block_range_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_65850 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_65850[(6)] = c__2901__auto__);

return statearr_65850;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns an asynchronous channel that eventually returns the results or an error.
 *   
 */
fluree.db.api_js.block_query_async = (function fluree$db$api_js$block_query_async(var_args){
var G__65904 = arguments.length;
switch (G__65904) {
case 2:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
return fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3(db,query_map,null);
}));

(fluree.db.api_js.block_query_async.cljs$core$IFn$_invoke$arity$3 = (function (db,query_map,opts){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_66019){
var state_val_66020 = (state_66019[(1)]);
if((state_val_66020 === (7))){
var state_66019__$1 = state_66019;
var statearr_66021_66087 = state_66019__$1;
(statearr_66021_66087[(2)] = false);

(statearr_66021_66087[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (20))){
var state_66019__$1 = state_66019;
var statearr_66022_66088 = state_66019__$1;
(statearr_66022_66088[(2)] = null);

(statearr_66022_66088[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (27))){
var inst_65986 = (state_66019[(2)]);
var inst_65987 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(query_map);
var state_66019__$1 = (function (){var statearr_66023 = state_66019;
(statearr_66023[(7)] = inst_65986);

return statearr_66023;
})();
if(cljs.core.truth_(inst_65987)){
var statearr_66024_66089 = state_66019__$1;
(statearr_66024_66089[(1)] = (29));

} else {
var statearr_66025_66090 = state_66019__$1;
(statearr_66025_66090[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (1))){
var state_66019__$1 = state_66019;
var statearr_66026_66091 = state_66019__$1;
(statearr_66026_66091[(2)] = null);

(statearr_66026_66091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (24))){
var inst_65947 = (state_66019[(8)]);
var inst_65960 = (state_66019[(2)]);
var inst_65961 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65960,inst_65947);
var inst_65962 = (function(){throw inst_65961})();
var state_66019__$1 = state_66019;
var statearr_66027_66092 = state_66019__$1;
(statearr_66027_66092[(2)] = inst_65962);

(statearr_66027_66092[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (4))){
var inst_65905 = (state_66019[(2)]);
var inst_65906 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_65905], 0));
var inst_65907 = cljs.core.ex_data(inst_65905);
var inst_65908 = cljs.core.ex_message(inst_65905);
var inst_65909 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_65907,new cljs.core.Keyword(null,"message","message",-406056002),inst_65908);
var state_66019__$1 = (function (){var statearr_66028 = state_66019;
(statearr_66028[(9)] = inst_65906);

return statearr_66028;
})();
var statearr_66029_66093 = state_66019__$1;
(statearr_66029_66093[(2)] = inst_65909);

(statearr_66029_66093[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (15))){
var inst_65947 = (state_66019[(8)]);
var inst_65946 = (state_66019[(2)]);
var inst_65947__$1 = fluree.db.util.async.throw_err(inst_65946);
var inst_65948 = cljs.core.map_QMARK_(inst_65947__$1);
var state_66019__$1 = (function (){var statearr_66030 = state_66019;
(statearr_66030[(8)] = inst_65947__$1);

return statearr_66030;
})();
if(inst_65948){
var statearr_66031_66094 = state_66019__$1;
(statearr_66031_66094[(1)] = (16));

} else {
var statearr_66032_66095 = state_66019__$1;
(statearr_66032_66095[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (21))){
var inst_65947 = (state_66019[(8)]);
var inst_65965 = (state_66019[(2)]);
var inst_65966 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65947,(0),null);
var inst_65967 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65947,(1),null);
var inst_65968 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_65969 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query_map,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_65970 = cljs.core.keys(inst_65969);
var inst_65971 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_65968,inst_65970);
var state_66019__$1 = (function (){var statearr_66033 = state_66019;
(statearr_66033[(10)] = inst_65966);

(statearr_66033[(11)] = inst_65965);

(statearr_66033[(12)] = inst_65967);

return statearr_66033;
})();
if(inst_65971){
var statearr_66034_66096 = state_66019__$1;
(statearr_66034_66096[(1)] = (25));

} else {
var statearr_66035_66097 = state_66019__$1;
(statearr_66035_66097[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (31))){
var inst_65995 = (state_66019[(2)]);
var inst_65996 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_66019__$1 = (function (){var statearr_66036 = state_66019;
(statearr_66036[(13)] = inst_65995);

return statearr_66036;
})();
if(cljs.core.truth_(inst_65996)){
var statearr_66037_66098 = state_66019__$1;
(statearr_66037_66098[(1)] = (33));

} else {
var statearr_66038_66099 = state_66019__$1;
(statearr_66038_66099[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (32))){
var inst_65991 = (state_66019[(2)]);
var inst_65992 = fluree.db.util.async.throw_err(inst_65991);
var state_66019__$1 = state_66019;
var statearr_66039_66100 = state_66019__$1;
(statearr_66039_66100[(2)] = inst_65992);

(statearr_66039_66100[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (33))){
var inst_65995 = (state_66019[(13)]);
var inst_65998 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_65999 = cljs.core.sequential_QMARK_(inst_65995);
var state_66019__$1 = (function (){var statearr_66040 = state_66019;
(statearr_66040[(14)] = inst_65998);

return statearr_66040;
})();
if(inst_65999){
var statearr_66041_66101 = state_66019__$1;
(statearr_66041_66101[(1)] = (36));

} else {
var statearr_66042_66102 = state_66019__$1;
(statearr_66042_66102[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (13))){
var inst_65920 = (state_66019[(15)]);
var state_66019__$1 = state_66019;
var statearr_66043_66103 = state_66019__$1;
(statearr_66043_66103[(2)] = inst_65920);

(statearr_66043_66103[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (22))){
var inst_65955 = (state_66019[(16)]);
var state_66019__$1 = state_66019;
var statearr_66044_66104 = state_66019__$1;
(statearr_66044_66104[(2)] = inst_65955);

(statearr_66044_66104[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (36))){
var inst_65995 = (state_66019[(13)]);
var inst_66001 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_65995);
var state_66019__$1 = state_66019;
var statearr_66045_66105 = state_66019__$1;
(statearr_66045_66105[(2)] = inst_66001);

(statearr_66045_66105[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (29))){
var inst_65986 = (state_66019[(7)]);
var inst_65989 = fluree.db.api_js.format_block_resp_pretty(db,inst_65986);
var state_66019__$1 = state_66019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66019__$1,(32),inst_65989);
} else {
if((state_val_66020 === (6))){
var inst_65920 = (state_66019[(15)]);
var inst_65925 = inst_65920.cljs$lang$protocol_mask$partition0$;
var inst_65926 = (inst_65925 & (64));
var inst_65927 = inst_65920.cljs$core$ISeq$;
var inst_65928 = (cljs.core.PROTOCOL_SENTINEL === inst_65927);
var inst_65929 = ((inst_65926) || (inst_65928));
var state_66019__$1 = state_66019;
if(cljs.core.truth_(inst_65929)){
var statearr_66046_66106 = state_66019__$1;
(statearr_66046_66106[(1)] = (9));

} else {
var statearr_66047_66107 = state_66019__$1;
(statearr_66047_66107[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (28))){
var inst_65975 = (state_66019[(2)]);
var inst_65976 = fluree.db.util.async.throw_err(inst_65975);
var state_66019__$1 = state_66019;
var statearr_66048_66108 = state_66019__$1;
(statearr_66048_66108[(2)] = inst_65976);

(statearr_66048_66108[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (25))){
var inst_65966 = (state_66019[(10)]);
var inst_65967 = (state_66019[(12)]);
var inst_65973 = fluree.db.query.block.block_range(db,inst_65966,inst_65967,opts);
var state_66019__$1 = state_66019;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66019__$1,(28),inst_65973);
} else {
if((state_val_66020 === (34))){
var inst_65995 = (state_66019[(13)]);
var state_66019__$1 = state_66019;
var statearr_66049_66109 = state_66019__$1;
(statearr_66049_66109[(2)] = inst_65995);

(statearr_66049_66109[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (17))){
var state_66019__$1 = state_66019;
var statearr_66050_66110 = state_66019__$1;
(statearr_66050_66110[(2)] = false);

(statearr_66050_66110[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (3))){
var inst_66017 = (state_66019[(2)]);
var state_66019__$1 = state_66019;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66019__$1,inst_66017);
} else {
if((state_val_66020 === (12))){
var inst_65920 = (state_66019[(15)]);
var inst_65938 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_65920);
var state_66019__$1 = state_66019;
var statearr_66051_66111 = state_66019__$1;
(statearr_66051_66111[(2)] = inst_65938);

(statearr_66051_66111[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (2))){
var inst_65920 = (state_66019[(15)]);
var _ = (function (){var statearr_66052 = state_66019;
(statearr_66052[(4)] = cljs.core.cons((5),(state_66019[(4)])));

return statearr_66052;
})();
var inst_65919 = fluree.db.util.core.current_time_millis();
var inst_65920__$1 = db;
var inst_65922 = (inst_65920__$1 == null);
var inst_65923 = cljs.core.not(inst_65922);
var state_66019__$1 = (function (){var statearr_66053 = state_66019;
(statearr_66053[(17)] = inst_65919);

(statearr_66053[(15)] = inst_65920__$1);

return statearr_66053;
})();
if(inst_65923){
var statearr_66054_66112 = state_66019__$1;
(statearr_66054_66112[(1)] = (6));

} else {
var statearr_66055_66113 = state_66019__$1;
(statearr_66055_66113[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (23))){
var inst_65943 = (state_66019[(18)]);
var inst_65942 = (state_66019[(19)]);
var inst_65958 = ["Unknown error attempting to resolve block range for ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65942),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_65943)].join('');
var state_66019__$1 = state_66019;
var statearr_66056_66114 = state_66019__$1;
(statearr_66056_66114[(2)] = inst_65958);

(statearr_66056_66114[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (35))){
var inst_66014 = (state_66019[(2)]);
var _ = (function (){var statearr_66057 = state_66019;
(statearr_66057[(4)] = cljs.core.rest((state_66019[(4)])));

return statearr_66057;
})();
var state_66019__$1 = state_66019;
var statearr_66058_66115 = state_66019__$1;
(statearr_66058_66115[(2)] = inst_66014);

(statearr_66058_66115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (19))){
var inst_65947 = (state_66019[(8)]);
var inst_65955 = (state_66019[(16)]);
var inst_65955__$1 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_65947);
var state_66019__$1 = (function (){var statearr_66059 = state_66019;
(statearr_66059[(16)] = inst_65955__$1);

return statearr_66059;
})();
if(cljs.core.truth_(inst_65955__$1)){
var statearr_66060_66116 = state_66019__$1;
(statearr_66060_66116[(1)] = (22));

} else {
var statearr_66061_66117 = state_66019__$1;
(statearr_66061_66117[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (11))){
var inst_65933 = (state_66019[(2)]);
var state_66019__$1 = state_66019;
var statearr_66063_66118 = state_66019__$1;
(statearr_66063_66118[(2)] = inst_65933);

(statearr_66063_66118[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (9))){
var state_66019__$1 = state_66019;
var statearr_66064_66119 = state_66019__$1;
(statearr_66064_66119[(2)] = true);

(statearr_66064_66119[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (5))){
var _ = (function (){var statearr_66065 = state_66019;
(statearr_66065[(4)] = cljs.core.rest((state_66019[(4)])));

return statearr_66065;
})();
var state_66019__$1 = state_66019;
var ex66062 = (state_66019__$1[(2)]);
var statearr_66066_66120 = state_66019__$1;
(statearr_66066_66120[(5)] = ex66062);


var statearr_66067_66121 = state_66019__$1;
(statearr_66067_66121[(1)] = (4));

(statearr_66067_66121[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (14))){
var inst_65941 = (state_66019[(20)]);
var inst_65941__$1 = (state_66019[(2)]);
var inst_65942 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65941__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_65943 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_65941__$1,new cljs.core.Keyword(null,"db-id","db-id",747248515));
var inst_65944 = fluree.db.api_js.resolve_block_range(db,query_map);
var state_66019__$1 = (function (){var statearr_66068 = state_66019;
(statearr_66068[(20)] = inst_65941__$1);

(statearr_66068[(18)] = inst_65943);

(statearr_66068[(19)] = inst_65942);

return statearr_66068;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66019__$1,(15),inst_65944);
} else {
if((state_val_66020 === (26))){
var inst_65978 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_65979 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_65978].join('');
var inst_65980 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_65981 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_65982 = cljs.core.PersistentHashMap.fromArrays(inst_65980,inst_65981);
var inst_65983 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_65979,inst_65982);
var inst_65984 = (function(){throw inst_65983})();
var state_66019__$1 = state_66019;
var statearr_66069_66122 = state_66019__$1;
(statearr_66069_66122[(2)] = inst_65984);

(statearr_66069_66122[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (16))){
var inst_65947 = (state_66019[(8)]);
var inst_65950 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_65947);
var state_66019__$1 = state_66019;
var statearr_66070_66123 = state_66019__$1;
(statearr_66070_66123[(2)] = inst_65950);

(statearr_66070_66123[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (38))){
var inst_65966 = (state_66019[(10)]);
var inst_65947 = (state_66019[(8)]);
var inst_65941 = (state_66019[(20)]);
var inst_65943 = (state_66019[(18)]);
var inst_65919 = (state_66019[(17)]);
var inst_65998 = (state_66019[(14)]);
var inst_65965 = (state_66019[(11)]);
var inst_65942 = (state_66019[(19)]);
var inst_65967 = (state_66019[(12)]);
var inst_65995 = (state_66019[(13)]);
var inst_65986 = (state_66019[(7)]);
var inst_66004 = (state_66019[(2)]);
var inst_66005 = (function (){var network = inst_65942;
var block_start = inst_65966;
var map__65915 = inst_65941;
var block_end = inst_65967;
var range = inst_65947;
var db_id = inst_65943;
var _ = inst_65965;
var start = inst_65919;
var result_SINGLEQUOTE_ = inst_65995;
var result = inst_65986;
var vec__65916 = inst_65947;
return (function (p1__65902_SHARP_){
var G__66071 = "%.2fms";
var G__66072 = p1__65902_SHARP_;
return goog.string.format(G__66071,G__66072);
});
})();
var inst_66006 = fluree.db.util.core.current_time_millis();
var inst_66007 = (inst_66006 - inst_65919);
var inst_66008 = (inst_66007 / (1000000));
var inst_66009 = (inst_66005.cljs$core$IFn$_invoke$arity$1 ? inst_66005.cljs$core$IFn$_invoke$arity$1(inst_66008) : inst_66005.call(null,inst_66008));
var inst_66010 = [(200),inst_66004,(100),inst_66009];
var inst_66011 = cljs.core.PersistentHashMap.fromArrays(inst_65998,inst_66010);
var state_66019__$1 = state_66019;
var statearr_66073_66124 = state_66019__$1;
(statearr_66073_66124[(2)] = inst_66011);

(statearr_66073_66124[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (30))){
var inst_65986 = (state_66019[(7)]);
var state_66019__$1 = state_66019;
var statearr_66074_66125 = state_66019__$1;
(statearr_66074_66125[(2)] = inst_65986);

(statearr_66074_66125[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (10))){
var state_66019__$1 = state_66019;
var statearr_66075_66126 = state_66019__$1;
(statearr_66075_66126[(2)] = false);

(statearr_66075_66126[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (18))){
var inst_65953 = (state_66019[(2)]);
var state_66019__$1 = state_66019;
if(cljs.core.truth_(inst_65953)){
var statearr_66076_66127 = state_66019__$1;
(statearr_66076_66127[(1)] = (19));

} else {
var statearr_66077_66128 = state_66019__$1;
(statearr_66077_66128[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (37))){
var inst_65995 = (state_66019[(13)]);
var state_66019__$1 = state_66019;
var statearr_66078_66129 = state_66019__$1;
(statearr_66078_66129[(2)] = inst_65995);

(statearr_66078_66129[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66020 === (8))){
var inst_65936 = (state_66019[(2)]);
var state_66019__$1 = state_66019;
if(cljs.core.truth_(inst_65936)){
var statearr_66079_66130 = state_66019__$1;
(statearr_66079_66130[(1)] = (12));

} else {
var statearr_66080_66131 = state_66019__$1;
(statearr_66080_66131[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2879__auto__ = null;
var fluree$db$api_js$state_machine__2879__auto____0 = (function (){
var statearr_66081 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66081[(0)] = fluree$db$api_js$state_machine__2879__auto__);

(statearr_66081[(1)] = (1));

return statearr_66081;
});
var fluree$db$api_js$state_machine__2879__auto____1 = (function (state_66019){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_66019);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e66082){var ex__2882__auto__ = e66082;
var statearr_66083_66132 = state_66019;
(statearr_66083_66132[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_66019[(4)]))){
var statearr_66084_66133 = state_66019;
(statearr_66084_66133[(1)] = cljs.core.first((state_66019[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66134 = state_66019;
state_66019 = G__66134;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2879__auto__ = function(state_66019){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2879__auto____1.call(this,state_66019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2879__auto____0;
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2879__auto____1;
return fluree$db$api_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_66085 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_66085[(6)] = c__2901__auto__);

return statearr_66085;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.api_js.block_query_async.cljs$lang$maxFixedArity = 3);

fluree.db.api_js.history_query_async = (function fluree$db$api_js$history_query_async(var_args){
var G__66136 = arguments.length;
switch (G__66136) {
case 2:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,query_map){
return fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3(sources,query_map,null);
}));

(fluree.db.api_js.history_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,query_map,opts){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_66337){
var state_val_66338 = (state_66337[(1)]);
if((state_val_66338 === (7))){
var inst_66154 = (state_66337[(2)]);
var state_66337__$1 = state_66337;
var statearr_66339_66423 = state_66337__$1;
(statearr_66339_66423[(2)] = inst_66154);

(statearr_66339_66423[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (59))){
var inst_66335 = (state_66337[(2)]);
var state_66337__$1 = state_66337;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66337__$1,inst_66335);
} else {
if((state_val_66338 === (20))){
var state_66337__$1 = state_66337;
var statearr_66340_66424 = state_66337__$1;
(statearr_66340_66424[(2)] = (-1));

(statearr_66340_66424[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (58))){
var inst_66327 = (state_66337[(7)]);
var state_66337__$1 = state_66337;
var statearr_66341_66425 = state_66337__$1;
(statearr_66341_66425[(2)] = inst_66327);

(statearr_66341_66425[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (27))){
var inst_66164 = (state_66337[(8)]);
var inst_66214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66215 = [inst_66164];
var inst_66216 = (new cljs.core.PersistentVector(null,1,(5),inst_66214,inst_66215,null));
var state_66337__$1 = state_66337;
var statearr_66342_66426 = state_66337__$1;
(statearr_66342_66426[(2)] = inst_66216);

(statearr_66342_66426[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (1))){
var inst_66141 = (state_66337[(9)]);
var inst_66141__$1 = query_map;
var inst_66143 = (inst_66141__$1 == null);
var inst_66144 = cljs.core.not(inst_66143);
var state_66337__$1 = (function (){var statearr_66343 = state_66337;
(statearr_66343[(9)] = inst_66141__$1);

return statearr_66343;
})();
if(inst_66144){
var statearr_66344_66427 = state_66337__$1;
(statearr_66344_66427[(1)] = (2));

} else {
var statearr_66345_66428 = state_66337__$1;
(statearr_66345_66428[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (24))){
var inst_66168 = (state_66337[(10)]);
var inst_66209 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_66168);
var state_66337__$1 = state_66337;
var statearr_66346_66429 = state_66337__$1;
(statearr_66346_66429[(2)] = inst_66209);

(statearr_66346_66429[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (55))){
var inst_66185 = (state_66337[(11)]);
var inst_66327 = (state_66337[(2)]);
var state_66337__$1 = (function (){var statearr_66347 = state_66337;
(statearr_66347[(7)] = inst_66327);

return statearr_66347;
})();
if(cljs.core.truth_(inst_66185)){
var statearr_66348_66430 = state_66337__$1;
(statearr_66348_66430[(1)] = (57));

} else {
var statearr_66349_66431 = state_66337__$1;
(statearr_66349_66431[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (39))){
var inst_66245 = (state_66337[(12)]);
var inst_66260 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66261 = [inst_66245,new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_66262 = (new cljs.core.PersistentVector(null,2,(5),inst_66260,inst_66261,null));
var state_66337__$1 = state_66337;
var statearr_66350_66432 = state_66337__$1;
(statearr_66350_66432[(2)] = inst_66262);

(statearr_66350_66432[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (46))){
var state_66337__$1 = state_66337;
var statearr_66351_66433 = state_66337__$1;
(statearr_66351_66433[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (4))){
var inst_66157 = (state_66337[(2)]);
var state_66337__$1 = state_66337;
if(cljs.core.truth_(inst_66157)){
var statearr_66353_66434 = state_66337__$1;
(statearr_66353_66434[(1)] = (8));

} else {
var statearr_66354_66435 = state_66337__$1;
(statearr_66354_66435[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (54))){
var inst_66319 = (state_66337[(13)]);
var state_66337__$1 = state_66337;
var statearr_66355_66436 = state_66337__$1;
(statearr_66355_66436[(2)] = inst_66319);

(statearr_66355_66436[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (15))){
var inst_66172 = (state_66337[(2)]);
var inst_66173 = fluree.db.util.async.throw_err(inst_66172);
var state_66337__$1 = state_66337;
var statearr_66356_66437 = state_66337__$1;
(statearr_66356_66437[(2)] = inst_66173);

(statearr_66356_66437[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (48))){
var inst_66164 = (state_66337[(8)]);
var inst_66292 = ["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66164)].join('');
var inst_66293 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66294 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_66295 = cljs.core.PersistentHashMap.fromArrays(inst_66293,inst_66294);
var inst_66296 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66292,inst_66295);
var inst_66297 = (function(){throw inst_66296})();
var state_66337__$1 = state_66337;
var statearr_66357_66438 = state_66337__$1;
(statearr_66357_66438[(2)] = inst_66297);

(statearr_66357_66438[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (50))){
var inst_66300 = (state_66337[(2)]);
var state_66337__$1 = state_66337;
var statearr_66358_66439 = state_66337__$1;
(statearr_66358_66439[(2)] = inst_66300);

(statearr_66358_66439[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (21))){
var inst_66178 = (state_66337[(14)]);
var inst_66201 = (state_66337[(2)]);
var state_66337__$1 = (function (){var statearr_66359 = state_66337;
(statearr_66359[(15)] = inst_66201);

return statearr_66359;
})();
if(cljs.core.truth_(inst_66178)){
var statearr_66360_66440 = state_66337__$1;
(statearr_66360_66440[(1)] = (23));

} else {
var statearr_66361_66441 = state_66337__$1;
(statearr_66361_66441[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (31))){
var state_66337__$1 = state_66337;
var statearr_66362_66442 = state_66337__$1;
(statearr_66362_66442[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (32))){
var inst_66243 = (state_66337[(2)]);
var state_66337__$1 = state_66337;
var statearr_66364_66443 = state_66337__$1;
(statearr_66364_66443[(2)] = inst_66243);

(statearr_66364_66443[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (40))){
var inst_66255 = (state_66337[(16)]);
var inst_66254 = (state_66337[(17)]);
var inst_66253 = (state_66337[(18)]);
var inst_66264 = (inst_66253 == null);
var inst_66265 = (inst_66254 == null);
var inst_66266 = cljs.core.not(inst_66265);
var inst_66267 = (inst_66255 == null);
var inst_66268 = ((inst_66264) && (inst_66266) && (inst_66267));
var state_66337__$1 = state_66337;
if(cljs.core.truth_(inst_66268)){
var statearr_66365_66444 = state_66337__$1;
(statearr_66365_66444[(1)] = (42));

} else {
var statearr_66366_66445 = state_66337__$1;
(statearr_66366_66445[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (56))){
var inst_66323 = (state_66337[(2)]);
var inst_66324 = fluree.db.util.async.throw_err(inst_66323);
var state_66337__$1 = state_66337;
var statearr_66367_66446 = state_66337__$1;
(statearr_66367_66446[(2)] = inst_66324);

(statearr_66367_66446[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (33))){
var inst_66164 = (state_66337[(8)]);
var inst_66222 = ["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66164)].join('');
var inst_66223 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66224 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_66225 = cljs.core.PersistentHashMap.fromArrays(inst_66223,inst_66224);
var inst_66226 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66222,inst_66225);
var inst_66227 = (function(){throw inst_66226})();
var state_66337__$1 = state_66337;
var statearr_66368_66447 = state_66337__$1;
(statearr_66368_66447[(2)] = inst_66227);

(statearr_66368_66447[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (13))){
var state_66337__$1 = state_66337;
var statearr_66369_66448 = state_66337__$1;
(statearr_66369_66448[(2)] = null);

(statearr_66369_66448[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (22))){
var inst_66195 = (state_66337[(2)]);
var inst_66196 = fluree.db.util.async.throw_err(inst_66195);
var inst_66197 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_66196);
var inst_66198 = (inst_66197 - (1));
var state_66337__$1 = state_66337;
var statearr_66370_66449 = state_66337__$1;
(statearr_66370_66449[(2)] = inst_66198);

(statearr_66370_66449[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (36))){
var inst_66164 = (state_66337[(8)]);
var inst_66233 = ["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_66164)].join('');
var inst_66234 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_66235 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_66236 = cljs.core.PersistentHashMap.fromArrays(inst_66234,inst_66235);
var inst_66237 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_66233,inst_66236);
var inst_66238 = (function(){throw inst_66237})();
var state_66337__$1 = state_66337;
var statearr_66371_66450 = state_66337__$1;
(statearr_66371_66450[(2)] = inst_66238);

(statearr_66371_66450[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (41))){
var inst_66168 = (state_66337[(10)]);
var inst_66201 = (state_66337[(15)]);
var inst_66211 = (state_66337[(19)]);
var inst_66306 = (state_66337[(2)]);
var inst_66307 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66306,(0),null);
var inst_66308 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66306,(1),null);
var inst_66309 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_66310 = [inst_66201,inst_66211];
var inst_66311 = cljs.core.PersistentHashMap.fromArrays(inst_66309,inst_66310);
var inst_66312 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_66168,inst_66308,cljs.core._EQ_,inst_66307,inst_66311);
var state_66337__$1 = state_66337;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66337__$1,(51),inst_66312);
} else {
if((state_val_66338 === (43))){
var inst_66255 = (state_66337[(16)]);
var inst_66254 = (state_66337[(17)]);
var inst_66253 = (state_66337[(18)]);
var inst_66277 = (inst_66253 == null);
var inst_66278 = (inst_66254 == null);
var inst_66279 = cljs.core.not(inst_66278);
var inst_66280 = (inst_66255 == null);
var inst_66281 = cljs.core.not(inst_66280);
var inst_66282 = ((inst_66277) && (inst_66279) && (inst_66281));
var state_66337__$1 = state_66337;
if(cljs.core.truth_(inst_66282)){
var statearr_66372_66451 = state_66337__$1;
(statearr_66372_66451[(1)] = (45));

} else {
var statearr_66373_66452 = state_66337__$1;
(statearr_66373_66452[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (29))){
var inst_66245 = (state_66337[(12)]);
var inst_66253 = (state_66337[(18)]);
var inst_66245__$1 = (state_66337[(2)]);
var inst_66246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66247 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66245__$1,(0));
var inst_66248 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66245__$1,(1));
var inst_66249 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66245__$1,(2));
var inst_66250 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66245__$1,(3));
var inst_66251 = [inst_66247,inst_66248,inst_66249,inst_66250];
var inst_66252 = (new cljs.core.PersistentVector(null,4,(5),inst_66246,inst_66251,null));
var inst_66253__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66252,(0),null);
var inst_66254 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66252,(1),null);
var inst_66255 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66252,(2),null);
var inst_66256 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66252,(3),null);
var inst_66257 = (inst_66253__$1 == null);
var inst_66258 = cljs.core.not(inst_66257);
var state_66337__$1 = (function (){var statearr_66374 = state_66337;
(statearr_66374[(16)] = inst_66255);

(statearr_66374[(17)] = inst_66254);

(statearr_66374[(20)] = inst_66256);

(statearr_66374[(12)] = inst_66245__$1);

(statearr_66374[(18)] = inst_66253__$1);

return statearr_66374;
})();
if(inst_66258){
var statearr_66375_66453 = state_66337__$1;
(statearr_66375_66453[(1)] = (39));

} else {
var statearr_66376_66454 = state_66337__$1;
(statearr_66376_66454[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (44))){
var inst_66304 = (state_66337[(2)]);
var state_66337__$1 = state_66337;
var statearr_66377_66455 = state_66337__$1;
(statearr_66377_66455[(2)] = inst_66304);

(statearr_66377_66455[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (6))){
var state_66337__$1 = state_66337;
var statearr_66378_66456 = state_66337__$1;
(statearr_66378_66456[(2)] = false);

(statearr_66378_66456[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (28))){
var inst_66164 = (state_66337[(8)]);
var inst_66218 = cljs.core.sequential_QMARK_(inst_66164);
var state_66337__$1 = state_66337;
if(inst_66218){
var statearr_66379_66457 = state_66337__$1;
(statearr_66379_66457[(1)] = (30));

} else {
var statearr_66380_66458 = state_66337__$1;
(statearr_66380_66458[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (51))){
var inst_66168 = (state_66337[(10)]);
var inst_66315 = (state_66337[(21)]);
var inst_66314 = (state_66337[(2)]);
var inst_66315__$1 = fluree.db.util.async.throw_err(inst_66314);
var inst_66316 = fluree.db.api_js.format_history_resp(inst_66168,inst_66315__$1);
var state_66337__$1 = (function (){var statearr_66381 = state_66337;
(statearr_66381[(21)] = inst_66315__$1);

return statearr_66381;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66337__$1,(52),inst_66316);
} else {
if((state_val_66338 === (25))){
var inst_66164 = (state_66337[(8)]);
var inst_66211 = (state_66337[(2)]);
var inst_66212 = fluree.db.util.core.subj_ident_QMARK_(inst_66164);
var state_66337__$1 = (function (){var statearr_66382 = state_66337;
(statearr_66382[(19)] = inst_66211);

return statearr_66382;
})();
if(inst_66212){
var statearr_66383_66459 = state_66337__$1;
(statearr_66383_66459[(1)] = (27));

} else {
var statearr_66384_66460 = state_66337__$1;
(statearr_66384_66460[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (34))){
var inst_66164 = (state_66337[(8)]);
var state_66337__$1 = state_66337;
var statearr_66385_66461 = state_66337__$1;
(statearr_66385_66461[(2)] = inst_66164);

(statearr_66385_66461[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (17))){
var inst_66177 = (state_66337[(22)]);
var state_66337__$1 = state_66337;
var statearr_66386_66462 = state_66337__$1;
(statearr_66386_66462[(2)] = inst_66177);

(statearr_66386_66462[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (3))){
var state_66337__$1 = state_66337;
var statearr_66387_66463 = state_66337__$1;
(statearr_66387_66463[(2)] = false);

(statearr_66387_66463[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (12))){
var inst_66168 = (state_66337[(10)]);
var inst_66170 = fluree.db.api_js.resolve_block_range(inst_66168,query_map);
var state_66337__$1 = state_66337;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66337__$1,(15),inst_66170);
} else {
if((state_val_66338 === (2))){
var inst_66141 = (state_66337[(9)]);
var inst_66146 = inst_66141.cljs$lang$protocol_mask$partition0$;
var inst_66147 = (inst_66146 & (64));
var inst_66148 = inst_66141.cljs$core$ISeq$;
var inst_66149 = (cljs.core.PROTOCOL_SENTINEL === inst_66148);
var inst_66150 = ((inst_66147) || (inst_66149));
var state_66337__$1 = state_66337;
if(cljs.core.truth_(inst_66150)){
var statearr_66388_66464 = state_66337__$1;
(statearr_66388_66464[(1)] = (5));

} else {
var statearr_66389_66465 = state_66337__$1;
(statearr_66389_66465[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (23))){
var inst_66168 = (state_66337[(10)]);
var inst_66178 = (state_66337[(14)]);
var inst_66203 = fluree.db.time_travel.as_of_block(inst_66168,inst_66178);
var state_66337__$1 = state_66337;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66337__$1,(26),inst_66203);
} else {
if((state_val_66338 === (47))){
var inst_66302 = (state_66337[(2)]);
var state_66337__$1 = state_66337;
var statearr_66390_66466 = state_66337__$1;
(statearr_66390_66466[(2)] = inst_66302);

(statearr_66390_66466[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (35))){
var inst_66230 = (state_66337[(2)]);
var state_66337__$1 = state_66337;
var statearr_66391_66467 = state_66337__$1;
(statearr_66391_66467[(2)] = inst_66230);

(statearr_66391_66467[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (19))){
var inst_66168 = (state_66337[(10)]);
var inst_66177 = (state_66337[(22)]);
var inst_66192 = (inst_66177 - (1));
var inst_66193 = fluree.db.time_travel.as_of_block(inst_66168,inst_66192);
var state_66337__$1 = state_66337;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66337__$1,(22),inst_66193);
} else {
if((state_val_66338 === (57))){
var inst_66327 = (state_66337[(7)]);
var inst_66315 = (state_66337[(21)]);
var inst_66329 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_66330 = cljs.core.count(inst_66315);
var inst_66331 = [inst_66327,inst_66330,(200)];
var inst_66332 = cljs.core.PersistentHashMap.fromArrays(inst_66329,inst_66331);
var state_66337__$1 = state_66337;
var statearr_66392_66468 = state_66337__$1;
(statearr_66392_66468[(2)] = inst_66332);

(statearr_66392_66468[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (11))){
var inst_66163 = (state_66337[(23)]);
var inst_66167 = (state_66337[(2)]);
var inst_66168 = fluree.db.util.async.throw_err(inst_66167);
var state_66337__$1 = (function (){var statearr_66393 = state_66337;
(statearr_66393[(10)] = inst_66168);

return statearr_66393;
})();
if(cljs.core.truth_(inst_66163)){
var statearr_66394_66469 = state_66337__$1;
(statearr_66394_66469[(1)] = (12));

} else {
var statearr_66395_66470 = state_66337__$1;
(statearr_66395_66470[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (9))){
var inst_66141 = (state_66337[(9)]);
var state_66337__$1 = state_66337;
var statearr_66396_66471 = state_66337__$1;
(statearr_66396_66471[(2)] = inst_66141);

(statearr_66396_66471[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (5))){
var state_66337__$1 = state_66337;
var statearr_66397_66472 = state_66337__$1;
(statearr_66397_66472[(2)] = true);

(statearr_66397_66472[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (14))){
var inst_66177 = (state_66337[(22)]);
var inst_66176 = (state_66337[(2)]);
var inst_66177__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66176,(0),null);
var inst_66178 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66176,(1),null);
var inst_66185 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_66337__$1 = (function (){var statearr_66398 = state_66337;
(statearr_66398[(22)] = inst_66177__$1);

(statearr_66398[(14)] = inst_66178);

(statearr_66398[(11)] = inst_66185);

return statearr_66398;
})();
if(cljs.core.truth_(inst_66177__$1)){
var statearr_66399_66473 = state_66337__$1;
(statearr_66399_66473[(1)] = (16));

} else {
var statearr_66400_66474 = state_66337__$1;
(statearr_66400_66474[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (45))){
var inst_66255 = (state_66337[(16)]);
var inst_66254 = (state_66337[(17)]);
var inst_66256 = (state_66337[(20)]);
var inst_66253 = (state_66337[(18)]);
var inst_66284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66286 = [inst_66254,inst_66255,inst_66253,inst_66256];
var inst_66287 = (new cljs.core.PersistentVector(null,4,(5),inst_66285,inst_66286,null));
var inst_66288 = [inst_66287,new cljs.core.Keyword(null,"post","post",269697687)];
var inst_66289 = (new cljs.core.PersistentVector(null,2,(5),inst_66284,inst_66288,null));
var state_66337__$1 = state_66337;
var statearr_66401_66475 = state_66337__$1;
(statearr_66401_66475[(2)] = inst_66289);

(statearr_66401_66475[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (53))){
var inst_66168 = (state_66337[(10)]);
var inst_66319 = (state_66337[(13)]);
var inst_66321 = fluree.db.api_js.format_block_resp_pretty(inst_66168,inst_66319);
var state_66337__$1 = state_66337;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66337__$1,(56),inst_66321);
} else {
if((state_val_66338 === (26))){
var inst_66205 = (state_66337[(2)]);
var inst_66206 = fluree.db.util.async.throw_err(inst_66205);
var inst_66207 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_66206);
var state_66337__$1 = state_66337;
var statearr_66402_66476 = state_66337__$1;
(statearr_66402_66476[(2)] = inst_66207);

(statearr_66402_66476[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (16))){
var inst_66177 = (state_66337[(22)]);
var inst_66187 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_66177);
var state_66337__$1 = state_66337;
var statearr_66403_66477 = state_66337__$1;
(statearr_66403_66477[(2)] = inst_66187);

(statearr_66403_66477[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (38))){
var inst_66241 = (state_66337[(2)]);
var state_66337__$1 = state_66337;
var statearr_66404_66478 = state_66337__$1;
(statearr_66404_66478[(2)] = inst_66241);

(statearr_66404_66478[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (30))){
var inst_66164 = (state_66337[(8)]);
var inst_66220 = cljs.core.empty_QMARK_(inst_66164);
var state_66337__$1 = state_66337;
if(inst_66220){
var statearr_66405_66479 = state_66337__$1;
(statearr_66405_66479[(1)] = (33));

} else {
var statearr_66406_66480 = state_66337__$1;
(statearr_66406_66480[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (10))){
var inst_66162 = (state_66337[(2)]);
var inst_66163 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66162,new cljs.core.Keyword(null,"block","block",664686210));
var inst_66164 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66162,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_66165 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_66162,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var state_66337__$1 = (function (){var statearr_66407 = state_66337;
(statearr_66407[(24)] = inst_66165);

(statearr_66407[(8)] = inst_66164);

(statearr_66407[(23)] = inst_66163);

return statearr_66407;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66337__$1,(11),sources);
} else {
if((state_val_66338 === (18))){
var inst_66190 = (state_66337[(2)]);
var state_66337__$1 = state_66337;
if(cljs.core.truth_(inst_66190)){
var statearr_66408_66481 = state_66337__$1;
(statearr_66408_66481[(1)] = (19));

} else {
var statearr_66409_66482 = state_66337__$1;
(statearr_66409_66482[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (52))){
var inst_66165 = (state_66337[(24)]);
var inst_66318 = (state_66337[(2)]);
var inst_66319 = fluree.db.util.async.throw_err(inst_66318);
var state_66337__$1 = (function (){var statearr_66410 = state_66337;
(statearr_66410[(13)] = inst_66319);

return statearr_66410;
})();
if(cljs.core.truth_(inst_66165)){
var statearr_66411_66483 = state_66337__$1;
(statearr_66411_66483[(1)] = (53));

} else {
var statearr_66412_66484 = state_66337__$1;
(statearr_66412_66484[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (42))){
var inst_66255 = (state_66337[(16)]);
var inst_66254 = (state_66337[(17)]);
var inst_66256 = (state_66337[(20)]);
var inst_66253 = (state_66337[(18)]);
var inst_66270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66272 = [inst_66254,inst_66253,inst_66255,inst_66256];
var inst_66273 = (new cljs.core.PersistentVector(null,4,(5),inst_66271,inst_66272,null));
var inst_66274 = [inst_66273,new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_66275 = (new cljs.core.PersistentVector(null,2,(5),inst_66270,inst_66274,null));
var state_66337__$1 = state_66337;
var statearr_66413_66485 = state_66337__$1;
(statearr_66413_66485[(2)] = inst_66275);

(statearr_66413_66485[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (37))){
var state_66337__$1 = state_66337;
var statearr_66414_66486 = state_66337__$1;
(statearr_66414_66486[(2)] = null);

(statearr_66414_66486[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (8))){
var inst_66141 = (state_66337[(9)]);
var inst_66159 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_66141);
var state_66337__$1 = state_66337;
var statearr_66415_66487 = state_66337__$1;
(statearr_66415_66487[(2)] = inst_66159);

(statearr_66415_66487[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66338 === (49))){
var state_66337__$1 = state_66337;
var statearr_66416_66488 = state_66337__$1;
(statearr_66416_66488[(2)] = null);

(statearr_66416_66488[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2879__auto__ = null;
var fluree$db$api_js$state_machine__2879__auto____0 = (function (){
var statearr_66417 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66417[(0)] = fluree$db$api_js$state_machine__2879__auto__);

(statearr_66417[(1)] = (1));

return statearr_66417;
});
var fluree$db$api_js$state_machine__2879__auto____1 = (function (state_66337){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_66337);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e66418){var ex__2882__auto__ = e66418;
var statearr_66419_66489 = state_66337;
(statearr_66419_66489[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_66337[(4)]))){
var statearr_66420_66490 = state_66337;
(statearr_66420_66490[(1)] = cljs.core.first((state_66337[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66491 = state_66337;
state_66337 = G__66491;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2879__auto__ = function(state_66337){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2879__auto____1.call(this,state_66337);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2879__auto____0;
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2879__auto____1;
return fluree$db$api_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_66421 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_66421[(6)] = c__2901__auto__);

return statearr_66421;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.api_js.history_query_async.cljs$lang$maxFixedArity = 3);

/**
 * Returns an asynchronous channel that eventually contains the result or an error.
 * 
 *   The db function, required to evaluate prefixes/multiple sources, is passed
 *   as a parameter.  This allows for the node.js version to override the
 *   default [fluree.db.api-js.db] with its own function.
 *   
 */
fluree.db.api_js.multi_query_async = (function fluree$db$api_js$multi_query_async(var_args){
var G__66499 = arguments.length;
switch (G__66499) {
case 2:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$2 = (function (sources,multi_query_map){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,null,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$3 = (function (sources,multi_query_map,opts){
return fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4(sources,multi_query_map,opts,fluree.db.api_js.db);
}));

(fluree.db.api_js.multi_query_async.cljs$core$IFn$_invoke$arity$4 = (function (sources,multi_query_map,opts,db_fn){
var db = sources;
var block = (function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(multi_query_map);
if(cljs.core.truth_(temp__5735__auto__)){
var block = temp__5735__auto__;
return fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(fluree.db.time_travel.block_to_int_format(fluree.db.util.async.throw_err(cljs.core.async._LT__BANG_(db)),block)));
} else {
return null;
}
})();
var meta_QMARK_ = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var _ = (cljs.core.truth_((function (){var and__4115__auto__ = block;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.map_QMARK_(block);
} else {
return and__4115__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Block is a reserved keyword. Please choose another name for your query. ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var ___$1 = (cljs.core.truth_((function (){var and__4115__auto__ = block;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.coll_QMARK_(block);
} else {
return and__4115__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Query block must be a string or integer. Block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null))})():null);
var multi_query_map_SINGLEQUOTE_ = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(multi_query_map,new cljs.core.Keyword(null,"block","block",664686210));
var vals_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__66492_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__66492_SHARP_,new cljs.core.Keyword(null,"block","block",664686210));
}),cljs.core.vals(multi_query_map_SINGLEQUOTE_));
var keys_SINGLEQUOTE_ = cljs.core.keys(multi_query_map_SINGLEQUOTE_);
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_66588){
var state_val_66589 = (state_66588[(1)]);
if((state_val_66589 === (7))){
var inst_66542 = (state_66588[(7)]);
var inst_66539 = (state_66588[(8)]);
var inst_66549 = (state_66588[(9)]);
var inst_66545 = (state_66588[(10)]);
var inst_66555 = (function (){var responses = inst_66539;
var responses_STAR_ = inst_66542;
var statuses = inst_66545;
var fuel = inst_66549;
return (function (p1__66495_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),p1__66495_SHARP_);
});
})();
var inst_66556 = cljs.core.some(inst_66555,inst_66545);
var state_66588__$1 = state_66588;
if(cljs.core.truth_(inst_66556)){
var statearr_66590_66638 = state_66588__$1;
(statearr_66590_66638[(1)] = (9));

} else {
var statearr_66591_66639 = state_66588__$1;
(statearr_66591_66639[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (20))){
var inst_66583 = (state_66588[(2)]);
var state_66588__$1 = state_66588;
var statearr_66592_66640 = state_66588__$1;
(statearr_66592_66640[(2)] = inst_66583);

(statearr_66592_66640[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (1))){
var inst_66534 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_66535 = (function (){var c__2901__auto____$1 = inst_66534;
return (function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_66532){
var state_val_66533 = (state_66532[(1)]);
if((state_val_66533 === (1))){
var inst_66500 = cljs.core.first(keys_SINGLEQUOTE_);
var inst_66501 = cljs.core.first(vals_SINGLEQUOTE_);
var inst_66502 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_66501,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_66503 = cljs.core.rest(keys_SINGLEQUOTE_);
var inst_66504 = cljs.core.rest(vals_SINGLEQUOTE_);
var inst_66505 = cljs.core.PersistentHashMap.EMPTY;
var inst_66506 = inst_66500;
var inst_66507 = inst_66502;
var inst_66508 = inst_66503;
var inst_66509 = inst_66504;
var inst_66510 = inst_66505;
var state_66532__$1 = (function (){var statearr_66593 = state_66532;
(statearr_66593[(7)] = inst_66508);

(statearr_66593[(8)] = inst_66509);

(statearr_66593[(9)] = inst_66506);

(statearr_66593[(10)] = inst_66510);

(statearr_66593[(11)] = inst_66507);

return statearr_66593;
})();
var statearr_66594_66641 = state_66532__$1;
(statearr_66594_66641[(2)] = null);

(statearr_66594_66641[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66533 === (2))){
var inst_66507 = (state_66532[(11)]);
var inst_66512 = new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(inst_66507);
var inst_66513 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts,inst_66512], 0));
var inst_66514 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_66507,new cljs.core.Keyword(null,"opts","opts",155075701),inst_66513);
var inst_66515 = fluree.db.api_js.query_async.cljs$core$IFn$_invoke$arity$3(db,inst_66514,db_fn);
var state_66532__$1 = state_66532;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66532__$1,(4),inst_66515);
} else {
if((state_val_66533 === (3))){
var inst_66530 = (state_66532[(2)]);
var state_66532__$1 = state_66532;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66532__$1,inst_66530);
} else {
if((state_val_66533 === (4))){
var inst_66508 = (state_66532[(7)]);
var inst_66506 = (state_66532[(9)]);
var inst_66510 = (state_66532[(10)]);
var inst_66517 = (state_66532[(2)]);
var inst_66518 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_66510,inst_66506,inst_66517);
var inst_66519 = cljs.core.first(inst_66508);
var state_66532__$1 = (function (){var statearr_66595 = state_66532;
(statearr_66595[(12)] = inst_66518);

return statearr_66595;
})();
if(cljs.core.truth_(inst_66519)){
var statearr_66596_66642 = state_66532__$1;
(statearr_66596_66642[(1)] = (5));

} else {
var statearr_66597_66643 = state_66532__$1;
(statearr_66597_66643[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66533 === (5))){
var inst_66508 = (state_66532[(7)]);
var inst_66518 = (state_66532[(12)]);
var inst_66509 = (state_66532[(8)]);
var inst_66521 = cljs.core.first(inst_66508);
var inst_66522 = cljs.core.first(inst_66509);
var inst_66523 = cljs.core.rest(inst_66508);
var inst_66524 = cljs.core.rest(inst_66509);
var inst_66506 = inst_66521;
var inst_66507 = inst_66522;
var inst_66508__$1 = inst_66523;
var inst_66509__$1 = inst_66524;
var inst_66510 = inst_66518;
var state_66532__$1 = (function (){var statearr_66598 = state_66532;
(statearr_66598[(7)] = inst_66508__$1);

(statearr_66598[(8)] = inst_66509__$1);

(statearr_66598[(9)] = inst_66506);

(statearr_66598[(10)] = inst_66510);

(statearr_66598[(11)] = inst_66507);

return statearr_66598;
})();
var statearr_66599_66644 = state_66532__$1;
(statearr_66599_66644[(2)] = null);

(statearr_66599_66644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66533 === (6))){
var inst_66518 = (state_66532[(12)]);
var state_66532__$1 = state_66532;
var statearr_66600_66645 = state_66532__$1;
(statearr_66600_66645[(2)] = inst_66518);

(statearr_66600_66645[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66533 === (7))){
var inst_66528 = (state_66532[(2)]);
var state_66532__$1 = state_66532;
var statearr_66601_66646 = state_66532__$1;
(statearr_66601_66646[(2)] = inst_66528);

(statearr_66601_66646[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2879__auto__ = null;
var fluree$db$api_js$state_machine__2879__auto____0 = (function (){
var statearr_66602 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66602[(0)] = fluree$db$api_js$state_machine__2879__auto__);

(statearr_66602[(1)] = (1));

return statearr_66602;
});
var fluree$db$api_js$state_machine__2879__auto____1 = (function (state_66532){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_66532);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e66603){var ex__2882__auto__ = e66603;
var statearr_66604_66647 = state_66532;
(statearr_66604_66647[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_66532[(4)]))){
var statearr_66605_66648 = state_66532;
(statearr_66605_66648[(1)] = cljs.core.first((state_66532[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66649 = state_66532;
state_66532 = G__66649;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2879__auto__ = function(state_66532){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2879__auto____1.call(this,state_66532);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2879__auto____0;
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2879__auto____1;
return fluree$db$api_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_66606 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_66606[(6)] = c__2901__auto____$1);

return statearr_66606;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
});
})();
var inst_66536 = cljs.core.async.impl.dispatch.run(inst_66535);
var state_66588__$1 = (function (){var statearr_66607 = state_66588;
(statearr_66607[(11)] = inst_66536);

return statearr_66607;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66588__$1,(2),inst_66534);
} else {
if((state_val_66589 === (4))){
var inst_66539 = (state_66588[(8)]);
var state_66588__$1 = state_66588;
var statearr_66608_66650 = state_66588__$1;
(statearr_66608_66650[(2)] = inst_66539);

(statearr_66608_66650[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (15))){
var state_66588__$1 = state_66588;
var statearr_66609_66651 = state_66588__$1;
(statearr_66609_66651[(2)] = (400));

(statearr_66609_66651[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (13))){
var state_66588__$1 = state_66588;
var statearr_66610_66652 = state_66588__$1;
(statearr_66610_66652[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (6))){
var inst_66545 = (state_66588[(10)]);
var inst_66553 = cljs.core.first(inst_66545);
var state_66588__$1 = state_66588;
var statearr_66612_66653 = state_66588__$1;
(statearr_66612_66653[(2)] = inst_66553);

(statearr_66612_66653[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (17))){
var inst_66566 = (state_66588[(2)]);
var state_66588__$1 = state_66588;
var statearr_66613_66654 = state_66588__$1;
(statearr_66613_66654[(2)] = inst_66566);

(statearr_66613_66654[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (3))){
var inst_66542 = (state_66588[(7)]);
var inst_66539 = (state_66588[(8)]);
var inst_66549 = (state_66588[(9)]);
var inst_66545 = (state_66588[(10)]);
var inst_66544 = cljs.core.vals(inst_66539);
var inst_66545__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"status","status",-1997798413),inst_66544);
var inst_66546 = (function (){var responses = inst_66539;
var responses_STAR_ = inst_66542;
var statuses = inst_66545__$1;
return (function (p1__66493_SHARP_){
var or__4126__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(p1__66493_SHARP_);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
});
})();
var inst_66547 = cljs.core.vals(inst_66539);
var inst_66548 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_66546,inst_66547);
var inst_66549__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,inst_66548);
var inst_66550 = (function (){var responses = inst_66539;
var responses_STAR_ = inst_66542;
var statuses = inst_66545__$1;
var fuel = inst_66549__$1;
return (function (p1__66494_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(statuses),p1__66494_SHARP_);
});
})();
var inst_66551 = cljs.core.every_QMARK_(inst_66550,inst_66545__$1);
var state_66588__$1 = (function (){var statearr_66614 = state_66588;
(statearr_66614[(9)] = inst_66549__$1);

(statearr_66614[(10)] = inst_66545__$1);

return statearr_66614;
})();
if(inst_66551){
var statearr_66615_66655 = state_66588__$1;
(statearr_66615_66655[(1)] = (6));

} else {
var statearr_66616_66656 = state_66588__$1;
(statearr_66616_66656[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (12))){
var state_66588__$1 = state_66588;
var statearr_66617_66657 = state_66588__$1;
(statearr_66617_66657[(2)] = (500));

(statearr_66617_66657[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (2))){
var inst_66539 = (state_66588[(8)]);
var inst_66538 = (state_66588[(2)]);
var inst_66539__$1 = fluree.db.util.async.throw_err(inst_66538);
var inst_66540 = (function (){var responses = inst_66539__$1;
return (function (acc,index,response){
var resp = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(response);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return response;
}
})();
if(cljs.core.truth_(meta_QMARK_)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response))){
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"result","result",1415092211),index], null),resp);
} else {
return cljs.core.assoc_in(acc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"errors","errors",-908790718),index], null),new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response));
}
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,index,resp);
}
});
})();
var inst_66541 = cljs.core.PersistentHashMap.EMPTY;
var inst_66542 = cljs.core.reduce_kv(inst_66540,inst_66541,inst_66539__$1);
var state_66588__$1 = (function (){var statearr_66618 = state_66588;
(statearr_66618[(7)] = inst_66542);

(statearr_66618[(8)] = inst_66539__$1);

return statearr_66618;
})();
if(cljs.core.truth_(meta_QMARK_)){
var statearr_66619_66658 = state_66588__$1;
(statearr_66619_66658[(1)] = (3));

} else {
var statearr_66620_66659 = state_66588__$1;
(statearr_66620_66659[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (19))){
var inst_66542 = (state_66588[(7)]);
var inst_66572 = (state_66588[(12)]);
var inst_66549 = (state_66588[(9)]);
var inst_66581 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_66542,new cljs.core.Keyword(null,"status","status",-1997798413),inst_66572,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_66549], 0));
var state_66588__$1 = state_66588;
var statearr_66621_66660 = state_66588__$1;
(statearr_66621_66660[(2)] = inst_66581);

(statearr_66621_66660[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (11))){
var inst_66570 = (state_66588[(2)]);
var state_66588__$1 = state_66588;
var statearr_66622_66661 = state_66588__$1;
(statearr_66622_66661[(2)] = inst_66570);

(statearr_66622_66661[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (9))){
var state_66588__$1 = state_66588;
var statearr_66623_66662 = state_66588__$1;
(statearr_66623_66662[(2)] = (207));

(statearr_66623_66662[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (5))){
var inst_66586 = (state_66588[(2)]);
var state_66588__$1 = state_66588;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66588__$1,inst_66586);
} else {
if((state_val_66589 === (14))){
var inst_66568 = (state_66588[(2)]);
var state_66588__$1 = state_66588;
var statearr_66624_66663 = state_66588__$1;
(statearr_66624_66663[(2)] = inst_66568);

(statearr_66624_66663[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (16))){
var state_66588__$1 = state_66588;
var statearr_66625_66664 = state_66588__$1;
(statearr_66625_66664[(2)] = null);

(statearr_66625_66664[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (10))){
var inst_66542 = (state_66588[(7)]);
var inst_66539 = (state_66588[(8)]);
var inst_66549 = (state_66588[(9)]);
var inst_66545 = (state_66588[(10)]);
var inst_66559 = (function (){var responses = inst_66539;
var responses_STAR_ = inst_66542;
var statuses = inst_66545;
var fuel = inst_66549;
return (function (p1__66496_SHARP_){
return ((499) < p1__66496_SHARP_);
});
})();
var inst_66560 = cljs.core.some(inst_66559,inst_66545);
var state_66588__$1 = state_66588;
if(cljs.core.truth_(inst_66560)){
var statearr_66626_66665 = state_66588__$1;
(statearr_66626_66665[(1)] = (12));

} else {
var statearr_66627_66666 = state_66588__$1;
(statearr_66627_66666[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (18))){
var inst_66542 = (state_66588[(7)]);
var inst_66577 = (state_66588[(13)]);
var inst_66572 = (state_66588[(12)]);
var inst_66549 = (state_66588[(9)]);
var inst_66579 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_66542,new cljs.core.Keyword(null,"status","status",-1997798413),inst_66572,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_66549,new cljs.core.Keyword(null,"block","block",664686210),inst_66577], 0));
var state_66588__$1 = state_66588;
var statearr_66628_66667 = state_66588__$1;
(statearr_66628_66667[(2)] = inst_66579);

(statearr_66628_66667[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66589 === (8))){
var inst_66542 = (state_66588[(7)]);
var inst_66539 = (state_66588[(8)]);
var inst_66577 = (state_66588[(13)]);
var inst_66572 = (state_66588[(12)]);
var inst_66549 = (state_66588[(9)]);
var inst_66545 = (state_66588[(10)]);
var inst_66572__$1 = (state_66588[(2)]);
var inst_66573 = (function (){var responses = inst_66539;
var responses_STAR_ = inst_66542;
var statuses = inst_66545;
var fuel = inst_66549;
var status = inst_66572__$1;
return (function (p1__66497_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(p1__66497_SHARP_));
});
})();
var inst_66574 = cljs.core.vals(inst_66539);
var inst_66575 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_66573,inst_66574);
var inst_66576 = cljs.core.first(inst_66575);
var inst_66577__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_66576);
var state_66588__$1 = (function (){var statearr_66629 = state_66588;
(statearr_66629[(13)] = inst_66577__$1);

(statearr_66629[(12)] = inst_66572__$1);

return statearr_66629;
})();
if(cljs.core.truth_(inst_66577__$1)){
var statearr_66630_66668 = state_66588__$1;
(statearr_66630_66668[(1)] = (18));

} else {
var statearr_66631_66669 = state_66588__$1;
(statearr_66631_66669[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2879__auto__ = null;
var fluree$db$api_js$state_machine__2879__auto____0 = (function (){
var statearr_66632 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_66632[(0)] = fluree$db$api_js$state_machine__2879__auto__);

(statearr_66632[(1)] = (1));

return statearr_66632;
});
var fluree$db$api_js$state_machine__2879__auto____1 = (function (state_66588){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_66588);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e66633){var ex__2882__auto__ = e66633;
var statearr_66634_66670 = state_66588;
(statearr_66634_66670[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_66588[(4)]))){
var statearr_66635_66671 = state_66588;
(statearr_66635_66671[(1)] = cljs.core.first((state_66588[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66672 = state_66588;
state_66588 = G__66672;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2879__auto__ = function(state_66588){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2879__auto____1.call(this,state_66588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2879__auto____0;
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2879__auto____1;
return fluree$db$api_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_66636 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_66636[(6)] = c__2901__auto__);

return statearr_66636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.api_js.multi_query_async.cljs$lang$maxFixedArity = 4);

/**
 * Helper function to fill out the parts of the query that are incomplete,
 *   producing a signed command.
 * 
 *   Optional opts is a map with the following keys. If not provided,
 *   defaults will be attempted.
 *   - auth        - The auth id for the auth record being used. The private key must
 *                correspond to this auth record, or an authority of this auth record.
 *   - expire      - When this transaction should expire if not yet attempted.
 *                Defaults to 5 minutes.
 *   - nonce       - Any long/64-bit integer value that will make this transaction unique.
 *                By default epoch milliseconds is used.
 *   - deps        - Not yet implemented, list of dependent transactions.
 * 
 *   If successful, will return a map with four keys:
 *  - cmd  - a map with the command/transaction data as a JSON string
 *  - sig  - the signature of the above stringified map
 *  - id   - the ID for this unique request - in case you want to look it up later, sha3 of 'cmd'
 *  - db   - the ledger for this transaction
 */
fluree.db.api_js.qry__GT_command = (function fluree$db$api_js$qry__GT_command(var_args){
var G__66674 = arguments.length;
switch (G__66674) {
case 3:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$3 = (function (ledger,qry_map,private_key){
return fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,qry_map,private_key,null);
}));

(fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4 = (function (ledger,qry_map,private_key,opts){
if(cljs.core.truth_(private_key)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Private key not provided and no default present on connection",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}

var db_name = ((cljs.core.sequential_QMARK_(ledger))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(ledger)),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.second(ledger))].join(''):ledger);
var map__66675 = opts;
var map__66675__$1 = (((((!((map__66675 == null))))?(((((map__66675.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__66675.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__66675):map__66675);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66675__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66675__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66675__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var action = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__66675__$1,new cljs.core.Keyword(null,"action","action",-811238024));
var key_auth_id = (fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1 ? fluree.crypto.account_id_from_private.cljs$core$IFn$_invoke$arity$1(private_key) : fluree.crypto.account_id_from_private.call(null,private_key));
var vec__66676 = (cljs.core.truth_((function (){var and__4115__auto__ = auth;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(auth,key_auth_id);
} else {
return and__4115__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,key_auth_id], null):(cljs.core.truth_(auth)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [auth,null], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_auth_id,null], null)
));
var auth__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66676,(0),null);
var authority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66676,(1),null);
var action__$1 = (function (){var or__4126__auto__ = action;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"query","query",-1288509510);
}
})();
var timestamp = fluree.db.util.core.current_time_millis();
var nonce__$1 = (function (){var or__4126__auto__ = nonce;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return timestamp;
}
})();
var expire__$1 = (function (){var or__4126__auto__ = expire;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (timestamp + (30000));
}
})();
var cmd = (function (){try{return fluree.db.util.json.stringify_preserve_namespace(fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"signed-qry","signed-qry",-1632927184),new cljs.core.Keyword(null,"action","action",-811238024),action__$1,new cljs.core.Keyword(null,"db","db",993250759),db_name,new cljs.core.Keyword(null,"qry","qry",-231103548),qry_map,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce__$1,new cljs.core.Keyword(null,"auth","auth",1389754926),auth__$1,new cljs.core.Keyword(null,"authority","authority",-551669367),authority,new cljs.core.Keyword(null,"expire","expire",-70657108),expire__$1], null)));
}catch (e66680){var e = e66680;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Signed query contains data that cannot be serialized into JSON.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-signed-query","db/invalid-signed-query",-2113460664)], null));
}})();
var sig = fluree.crypto.sign_message(cmd,private_key);
var id = fluree.crypto.sha3_256.cljs$core$IFn$_invoke$arity$1(cmd);
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"cmd","cmd",-302931143),cmd,new cljs.core.Keyword(null,"sig","sig",-1920417200),sig,new cljs.core.Keyword(null,"id","id",-1388402092),id,new cljs.core.Keyword(null,"db","db",993250759),ledger], null);
}));

(fluree.db.api_js.qry__GT_command.cljs$lang$maxFixedArity = 4);

/**
 * Execute a signed query against a ledger.
 * 
 *   Returns an asynchronous channel that eventually contains the results.
 */
fluree.db.api_js.signed_query_async = (function fluree$db$api_js$signed_query_async(var_args){
var G__66683 = arguments.length;
switch (G__66683) {
case 3:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,query_map){
return fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4(conn,ledger,query_map,null);
}));

(fluree.db.api_js.signed_query_async.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,query_map,opts){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_66714){
var state_val_66715 = (state_66714[(1)]);
if((state_val_66715 === (7))){
var state_66714__$1 = state_66714;
var statearr_66716_66737 = state_66714__$1;
(statearr_66716_66737[(2)] = opts);

(statearr_66716_66737[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66715 === (1))){
var state_66714__$1 = state_66714;
var statearr_66717_66738 = state_66714__$1;
(statearr_66717_66738[(2)] = null);

(statearr_66717_66738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66715 === (4))){
var inst_66684 = (state_66714[(2)]);
var inst_66685 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_66684], 0));
var inst_66686 = cljs.core.ex_data(inst_66684);
var inst_66687 = cljs.core.ex_message(inst_66684);
var inst_66688 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_66686,new cljs.core.Keyword(null,"message","message",-406056002),inst_66687);
var state_66714__$1 = (function (){var statearr_66718 = state_66714;
(statearr_66718[(7)] = inst_66685);

return statearr_66718;
})();
var statearr_66719_66739 = state_66714__$1;
(statearr_66719_66739[(2)] = inst_66688);

(statearr_66719_66739[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66715 === (6))){
var inst_66698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66699 = [new cljs.core.Keyword(null,"action","action",-811238024)];
var inst_66700 = (new cljs.core.PersistentVector(null,1,(5),inst_66698,inst_66699,null));
var inst_66701 = cljs.core.assoc_in(opts,inst_66700,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_66714__$1 = state_66714;
var statearr_66720_66740 = state_66714__$1;
(statearr_66720_66740[(2)] = inst_66701);

(statearr_66720_66740[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66715 === (3))){
var inst_66712 = (state_66714[(2)]);
var state_66714__$1 = state_66714;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66714__$1,inst_66712);
} else {
if((state_val_66715 === (2))){
var _ = (function (){var statearr_66722 = state_66714;
(statearr_66722[(4)] = cljs.core.cons((5),(state_66714[(4)])));

return statearr_66722;
})();
var inst_66694 = new cljs.core.Keyword(null,"private-key","private-key",426483388).cljs$core$IFn$_invoke$arity$1(opts);
var inst_66695 = new cljs.core.Keyword(null,"action","action",-811238024).cljs$core$IFn$_invoke$arity$1(opts);
var inst_66696 = (inst_66695 == null);
var state_66714__$1 = (function (){var statearr_66723 = state_66714;
(statearr_66723[(8)] = inst_66694);

return statearr_66723;
})();
if(cljs.core.truth_(inst_66696)){
var statearr_66724_66741 = state_66714__$1;
(statearr_66724_66741[(1)] = (6));

} else {
var statearr_66725_66742 = state_66714__$1;
(statearr_66725_66742[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66715 === (9))){
var inst_66708 = (state_66714[(2)]);
var inst_66709 = fluree.db.util.async.throw_err(inst_66708);
var _ = (function (){var statearr_66726 = state_66714;
(statearr_66726[(4)] = cljs.core.rest((state_66714[(4)])));

return statearr_66726;
})();
var state_66714__$1 = state_66714;
var statearr_66727_66743 = state_66714__$1;
(statearr_66727_66743[(2)] = inst_66709);

(statearr_66727_66743[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66715 === (5))){
var _ = (function (){var statearr_66728 = state_66714;
(statearr_66728[(4)] = cljs.core.rest((state_66714[(4)])));

return statearr_66728;
})();
var state_66714__$1 = state_66714;
var ex66721 = (state_66714__$1[(2)]);
var statearr_66729_66744 = state_66714__$1;
(statearr_66729_66744[(5)] = ex66721);


var statearr_66730_66745 = state_66714__$1;
(statearr_66730_66745[(1)] = (4));

(statearr_66730_66745[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_66715 === (8))){
var inst_66694 = (state_66714[(8)]);
var inst_66704 = (state_66714[(2)]);
var inst_66705 = fluree.db.api_js.qry__GT_command.cljs$core$IFn$_invoke$arity$4(ledger,query_map,inst_66694,inst_66704);
var inst_66706 = fluree.db.operations.command_async(conn,inst_66705);
var state_66714__$1 = state_66714;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66714__$1,(9),inst_66706);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api_js$state_machine__2879__auto__ = null;
var fluree$db$api_js$state_machine__2879__auto____0 = (function (){
var statearr_66731 = [null,null,null,null,null,null,null,null,null];
(statearr_66731[(0)] = fluree$db$api_js$state_machine__2879__auto__);

(statearr_66731[(1)] = (1));

return statearr_66731;
});
var fluree$db$api_js$state_machine__2879__auto____1 = (function (state_66714){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_66714);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e66732){var ex__2882__auto__ = e66732;
var statearr_66733_66746 = state_66714;
(statearr_66733_66746[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_66714[(4)]))){
var statearr_66734_66747 = state_66714;
(statearr_66734_66747[(1)] = cljs.core.first((state_66714[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__66748 = state_66714;
state_66714 = G__66748;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api_js$state_machine__2879__auto__ = function(state_66714){
switch(arguments.length){
case 0:
return fluree$db$api_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api_js$state_machine__2879__auto____1.call(this,state_66714);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api_js$state_machine__2879__auto____0;
fluree$db$api_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api_js$state_machine__2879__auto____1;
return fluree$db$api_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_66735 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_66735[(6)] = c__2901__auto__);

return statearr_66735;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.api_js.signed_query_async.cljs$lang$maxFixedArity = 4);

