// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.connection_js');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('alphabase.core');
goog.require('fluree.db.connection');
goog.require('fluree.db.operations');
goog.require('fluree.db.session');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.token_auth');
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.dbaas_QMARK_ = (function fluree$db$connection_js$dbaas_QMARK_(conn){
if(new cljs.core.Keyword(null,"dbaas?","dbaas?",998068571).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))) === true){
return true;
} else {
return false;
}
});
/**
 * Returns open-api? setting from connection object
 */
fluree.db.connection_js.open_api_QMARK_ = (function fluree$db$connection_js$open_api_QMARK_(conn){
return new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Verifies that the jwt token has not expired.
 *   Only returns when token is valid.  Otherwise, an exception is thrown.
 */
fluree.db.connection_js.validate_token = (function fluree$db$connection_js$validate_token(conn,jwt){
var secret = alphabase.core.base_to_byte_array.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"jwt-secret","jwt-secret",-356972172).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn))),new cljs.core.Keyword(null,"hex","hex",41691346));
return fluree.db.token_auth.verify_jwt(secret,jwt);
});
/**
 * Authenticate with Fluree On-Demand
 */
fluree.db.connection_js.authenticate = (function fluree$db$connection_js$authenticate(var_args){
var G__64080 = arguments.length;
switch (G__64080) {
case 4:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$4 = (function (conn,account,user,password){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5(conn,account,user,password,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$5 = (function (conn,account,user,password,expireSeconds){
return fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6(conn,account,user,password,expireSeconds,null);
}));

(fluree.db.connection_js.authenticate.cljs$core$IFn$_invoke$arity$6 = (function (conn,account,user,password,expireSeconds,syncTo){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64122){
var state_val_64123 = (state_64122[(1)]);
if((state_val_64123 === (7))){
var inst_64092 = typeof user === 'string';
var state_64122__$1 = state_64122;
if(cljs.core.truth_(inst_64092)){
var statearr_64124_64153 = state_64122__$1;
(statearr_64124_64153[(1)] = (9));

} else {
var statearr_64125_64154 = state_64122__$1;
(statearr_64125_64154[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64123 === (1))){
var state_64122__$1 = state_64122;
var statearr_64126_64155 = state_64122__$1;
(statearr_64126_64155[(2)] = null);

(statearr_64126_64155[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64123 === (4))){
var inst_64081 = (state_64122[(2)]);
var inst_64082 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64081], 0));
var inst_64083 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_64081) : reject.call(null,inst_64081));
var state_64122__$1 = (function (){var statearr_64127 = state_64122;
(statearr_64127[(7)] = inst_64082);

return statearr_64127;
})();
var statearr_64128_64156 = state_64122__$1;
(statearr_64128_64156[(2)] = inst_64083);

(statearr_64128_64156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64123 === (15))){
var inst_64111 = (state_64122[(2)]);
var inst_64112 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(inst_64111);
var inst_64113 = new cljs.core.Keyword(null,"token","token",-1211463215).cljs$core$IFn$_invoke$arity$1(conn);
var inst_64114 = cljs.core.constantly(inst_64112);
var inst_64115 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_64113,inst_64114);
var inst_64116 = fluree.db.connection.add_token(conn,inst_64112);
var inst_64117 = (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(inst_64111) : resolve.call(null,inst_64111));
var _ = (function (){var statearr_64129 = state_64122;
(statearr_64129[(4)] = cljs.core.rest((state_64122[(4)])));

return statearr_64129;
})();
var state_64122__$1 = (function (){var statearr_64130 = state_64122;
(statearr_64130[(8)] = inst_64116);

(statearr_64130[(9)] = inst_64115);

return statearr_64130;
})();
var statearr_64131_64157 = state_64122__$1;
(statearr_64131_64157[(2)] = inst_64117);

(statearr_64131_64157[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64123 === (13))){
var state_64122__$1 = state_64122;
var statearr_64132_64158 = state_64122__$1;
(statearr_64132_64158[(2)] = null);

(statearr_64132_64158[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64123 === (6))){
var state_64122__$1 = state_64122;
var statearr_64133_64159 = state_64122__$1;
(statearr_64133_64159[(2)] = user);

(statearr_64133_64159[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64123 === (3))){
var inst_64120 = (state_64122[(2)]);
var state_64122__$1 = state_64122;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64122__$1,inst_64120);
} else {
if((state_val_64123 === (12))){
var state_64122__$1 = state_64122;
var statearr_64134_64160 = state_64122__$1;
(statearr_64134_64160[(2)] = user);

(statearr_64134_64160[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64123 === (2))){
var _ = (function (){var statearr_64135 = state_64122;
(statearr_64135[(4)] = cljs.core.cons((5),(state_64122[(4)])));

return statearr_64135;
})();
var inst_64089 = typeof user === 'number';
var state_64122__$1 = state_64122;
if(cljs.core.truth_(inst_64089)){
var statearr_64136_64161 = state_64122__$1;
(statearr_64136_64161[(1)] = (6));

} else {
var statearr_64137_64162 = state_64122__$1;
(statearr_64137_64162[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64123 === (11))){
var inst_64103 = (state_64122[(2)]);
var state_64122__$1 = state_64122;
var statearr_64139_64163 = state_64122__$1;
(statearr_64139_64163[(2)] = inst_64103);

(statearr_64139_64163[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64123 === (9))){
var inst_64094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64095 = ["_user/username",user];
var inst_64096 = (new cljs.core.PersistentVector(null,2,(5),inst_64094,inst_64095,null));
var state_64122__$1 = state_64122;
var statearr_64140_64164 = state_64122__$1;
(statearr_64140_64164[(2)] = inst_64096);

(statearr_64140_64164[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64123 === (5))){
var _ = (function (){var statearr_64141 = state_64122;
(statearr_64141[(4)] = cljs.core.rest((state_64122[(4)])));

return statearr_64141;
})();
var state_64122__$1 = state_64122;
var ex64138 = (state_64122__$1[(2)]);
var statearr_64142_64165 = state_64122__$1;
(statearr_64142_64165[(5)] = ex64138);


var statearr_64143_64166 = state_64122__$1;
(statearr_64143_64166[(1)] = (4));

(statearr_64143_64166[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64123 === (14))){
var inst_64101 = (state_64122[(2)]);
var state_64122__$1 = state_64122;
var statearr_64144_64167 = state_64122__$1;
(statearr_64144_64167[(2)] = inst_64101);

(statearr_64144_64167[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64123 === (10))){
var state_64122__$1 = state_64122;
var statearr_64145_64168 = state_64122__$1;
(statearr_64145_64168[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64123 === (8))){
var inst_64105 = (state_64122[(2)]);
var inst_64106 = [new cljs.core.Keyword(null,"account","account",718006320),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"expireSeconds","expireSeconds",139078122),new cljs.core.Keyword(null,"syncTo","syncTo",281420769)];
var inst_64107 = [account,inst_64105,password,expireSeconds,syncTo];
var inst_64108 = cljs.core.PersistentHashMap.fromArrays(inst_64106,inst_64107);
var inst_64109 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,new cljs.core.Keyword(null,"authenticate","authenticate",743951231),inst_64108);
var state_64122__$1 = state_64122;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64122__$1,(15),inst_64109);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2879__auto__ = null;
var fluree$db$connection_js$state_machine__2879__auto____0 = (function (){
var statearr_64147 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64147[(0)] = fluree$db$connection_js$state_machine__2879__auto__);

(statearr_64147[(1)] = (1));

return statearr_64147;
});
var fluree$db$connection_js$state_machine__2879__auto____1 = (function (state_64122){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_64122);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64148){var ex__2882__auto__ = e64148;
var statearr_64149_64169 = state_64122;
(statearr_64149_64169[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_64122[(4)]))){
var statearr_64150_64170 = state_64122;
(statearr_64150_64170[(1)] = cljs.core.first((state_64122[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64171 = state_64122;
state_64122 = G__64171;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2879__auto__ = function(state_64122){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2879__auto____1.call(this,state_64122);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2879__auto____0;
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2879__auto____1;
return fluree$db$connection_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64151 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_64151[(6)] = c__2901__auto__);

return statearr_64151;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(fluree.db.connection_js.authenticate.cljs$lang$maxFixedArity = 6);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 */
fluree.db.connection_js.connect = (function fluree$db$connection_js$connect(var_args){
var G__64173 = arguments.length;
switch (G__64173) {
case 1:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
var conn = cljs.core.assoc_in(cljs.core.assoc_in(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"token","token",-1211463215)], null),cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY));
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var _ = (function (){var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64182){
var state_val_64183 = (state_64182[(1)]);
if((state_val_64183 === (1))){
var inst_64174 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_64175 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64176 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,pc,null];
var inst_64177 = (new cljs.core.PersistentVector(null,4,(5),inst_64175,inst_64176,null));
var inst_64178 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_64174,inst_64177);
var inst_64179 = (function (){return (function (x){
if((x == null)){
return null;
} else {
var seq__64184 = cljs.core.seq(cljs.core.keys(x));
var chunk__64185 = null;
var count__64186 = (0);
var i__64187 = (0);
while(true){
if((i__64187 < count__64186)){
var k = chunk__64185.cljs$core$IIndexed$_nth$arity$2(null,i__64187);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__64195 = seq__64184;
var G__64196 = chunk__64185;
var G__64197 = count__64186;
var G__64198 = (i__64187 + (1));
seq__64184 = G__64195;
chunk__64185 = G__64196;
count__64186 = G__64197;
i__64187 = G__64198;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__64184);
if(temp__5735__auto__){
var seq__64184__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__64184__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__64184__$1);
var G__64199 = cljs.core.chunk_rest(seq__64184__$1);
var G__64200 = c__4556__auto__;
var G__64201 = cljs.core.count(c__4556__auto__);
var G__64202 = (0);
seq__64184 = G__64199;
chunk__64185 = G__64200;
count__64186 = G__64201;
i__64187 = G__64202;
continue;
} else {
var k = cljs.core.first(seq__64184__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k,null));


var G__64203 = cljs.core.next(seq__64184__$1);
var G__64204 = null;
var G__64205 = (0);
var G__64206 = (0);
seq__64184 = G__64203;
chunk__64185 = G__64204;
count__64186 = G__64205;
i__64187 = G__64206;
continue;
}
} else {
return null;
}
}
break;
}
}
});
})();
var inst_64180 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_64179);
var state_64182__$1 = (function (){var statearr_64188 = state_64182;
(statearr_64188[(7)] = inst_64178);

return statearr_64188;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_64182__$1,inst_64180);
} else {
return null;
}
});
return (function() {
var fluree$db$connection_js$state_machine__2879__auto__ = null;
var fluree$db$connection_js$state_machine__2879__auto____0 = (function (){
var statearr_64189 = [null,null,null,null,null,null,null,null];
(statearr_64189[(0)] = fluree$db$connection_js$state_machine__2879__auto__);

(statearr_64189[(1)] = (1));

return statearr_64189;
});
var fluree$db$connection_js$state_machine__2879__auto____1 = (function (state_64182){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_64182);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64190){var ex__2882__auto__ = e64190;
var statearr_64191_64207 = state_64182;
(statearr_64191_64207[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_64182[(4)]))){
var statearr_64192_64208 = state_64182;
(statearr_64192_64208[(1)] = cljs.core.first((state_64182[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64209 = state_64182;
state_64182 = G__64209;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2879__auto__ = function(state_64182){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2879__auto____1.call(this,state_64182);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2879__auto____0;
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2879__auto____1;
return fluree$db$connection_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64193 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_64193[(6)] = c__2901__auto__);

return statearr_64193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
})();
return conn;
}));

(fluree.db.connection_js.connect.cljs$lang$maxFixedArity = 2);

/**
 * Connect to a ledger server using URL address. If using a ledger group, multiple addresses can be
 * supplied, separated by commas.
 * 
 * Returns a promise that eventually contains the connection object.
 */
fluree.db.connection_js.connect_p = (function fluree$db$connection_js$connect_p(var_args){
var G__64211 = arguments.length;
switch (G__64211) {
case 1:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$1 = (function (servers_string){
return fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2(servers_string,null);
}));

(fluree.db.connection_js.connect_p.cljs$core$IFn$_invoke$arity$2 = (function (servers_string,opts){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64245){
var state_val_64246 = (state_64245[(1)]);
if((state_val_64246 === (1))){
var state_64245__$1 = state_64245;
var statearr_64247_64268 = state_64245__$1;
(statearr_64247_64268[(2)] = null);

(statearr_64247_64268[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64246 === (2))){
var _ = (function (){var statearr_64248 = state_64245;
(statearr_64248[(4)] = cljs.core.cons((5),(state_64245[(4)])));

return statearr_64248;
})();
var inst_64220 = fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic(servers_string,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([opts], 0));
var inst_64221 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64222 = [new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018)];
var inst_64223 = (new cljs.core.PersistentVector(null,1,(5),inst_64221,inst_64222,null));
var inst_64224 = cljs.core.PersistentHashMap.EMPTY;
var inst_64225 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_64224);
var inst_64226 = cljs.core.assoc_in(inst_64220,inst_64223,inst_64225);
var inst_64227 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64228 = [new cljs.core.Keyword(null,"token","token",-1211463215)];
var inst_64229 = (new cljs.core.PersistentVector(null,1,(5),inst_64227,inst_64228,null));
var inst_64230 = cljs.core.PersistentHashMap.EMPTY;
var inst_64231 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(inst_64230);
var inst_64232 = cljs.core.assoc_in(inst_64226,inst_64229,inst_64231);
var inst_64233 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_64234 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(inst_64232);
var inst_64235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64236 = [new cljs.core.Keyword(null,"settings","settings",1556144875),null,inst_64233,null];
var inst_64237 = (new cljs.core.PersistentVector(null,4,(5),inst_64235,inst_64236,null));
var inst_64238 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_64234,inst_64237);
var inst_64239 = (function (){var conn = inst_64232;
var pc = inst_64233;
return (function (x){
if((x == null)){
} else {
var seq__64249_64269 = cljs.core.seq(cljs.core.keys(x));
var chunk__64250_64270 = null;
var count__64251_64271 = (0);
var i__64252_64272 = (0);
while(true){
if((i__64252_64272 < count__64251_64271)){
var k_64273 = chunk__64250_64270.cljs$core$IIndexed$_nth$arity$2(null,i__64252_64272);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_64273], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_64273,null));


var G__64274 = seq__64249_64269;
var G__64275 = chunk__64250_64270;
var G__64276 = count__64251_64271;
var G__64277 = (i__64252_64272 + (1));
seq__64249_64269 = G__64274;
chunk__64250_64270 = G__64275;
count__64251_64271 = G__64276;
i__64252_64272 = G__64277;
continue;
} else {
var temp__5735__auto___64278 = cljs.core.seq(seq__64249_64269);
if(temp__5735__auto___64278){
var seq__64249_64279__$1 = temp__5735__auto___64278;
if(cljs.core.chunked_seq_QMARK_(seq__64249_64279__$1)){
var c__4556__auto___64280 = cljs.core.chunk_first(seq__64249_64279__$1);
var G__64281 = cljs.core.chunk_rest(seq__64249_64279__$1);
var G__64282 = c__4556__auto___64280;
var G__64283 = cljs.core.count(c__4556__auto___64280);
var G__64284 = (0);
seq__64249_64269 = G__64281;
chunk__64250_64270 = G__64282;
count__64251_64271 = G__64283;
i__64252_64272 = G__64284;
continue;
} else {
var k_64285 = cljs.core.first(seq__64249_64279__$1);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k_64285], null),cljs.core.get.cljs$core$IFn$_invoke$arity$3(x,k_64285,null));


var G__64286 = cljs.core.next(seq__64249_64279__$1);
var G__64287 = null;
var G__64288 = (0);
var G__64289 = (0);
seq__64249_64269 = G__64286;
chunk__64250_64270 = G__64287;
count__64251_64271 = G__64288;
i__64252_64272 = G__64289;
continue;
}
} else {
}
}
break;
}
}

return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(conn) : resolve.call(null,conn));
});
})();
var inst_64240 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_64233,inst_64239);
var ___$1 = (function (){var statearr_64253 = state_64245;
(statearr_64253[(4)] = cljs.core.rest((state_64245[(4)])));

return statearr_64253;
})();
var state_64245__$1 = (function (){var statearr_64254 = state_64245;
(statearr_64254[(7)] = inst_64238);

return statearr_64254;
})();
var statearr_64255_64290 = state_64245__$1;
(statearr_64255_64290[(2)] = inst_64240);

(statearr_64255_64290[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64246 === (3))){
var inst_64243 = (state_64245[(2)]);
var state_64245__$1 = state_64245;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64245__$1,inst_64243);
} else {
if((state_val_64246 === (4))){
var inst_64212 = (state_64245[(2)]);
var inst_64213 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_64212], 0));
var inst_64214 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_64212) : reject.call(null,inst_64212));
var state_64245__$1 = (function (){var statearr_64257 = state_64245;
(statearr_64257[(8)] = inst_64213);

return statearr_64257;
})();
var statearr_64258_64291 = state_64245__$1;
(statearr_64258_64291[(2)] = inst_64214);

(statearr_64258_64291[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64246 === (5))){
var _ = (function (){var statearr_64259 = state_64245;
(statearr_64259[(4)] = cljs.core.rest((state_64245[(4)])));

return statearr_64259;
})();
var state_64245__$1 = state_64245;
var ex64256 = (state_64245__$1[(2)]);
var statearr_64260_64292 = state_64245__$1;
(statearr_64260_64292[(5)] = ex64256);


var statearr_64261_64293 = state_64245__$1;
(statearr_64261_64293[(1)] = (4));

(statearr_64261_64293[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2879__auto__ = null;
var fluree$db$connection_js$state_machine__2879__auto____0 = (function (){
var statearr_64262 = [null,null,null,null,null,null,null,null,null];
(statearr_64262[(0)] = fluree$db$connection_js$state_machine__2879__auto__);

(statearr_64262[(1)] = (1));

return statearr_64262;
});
var fluree$db$connection_js$state_machine__2879__auto____1 = (function (state_64245){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_64245);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64263){var ex__2882__auto__ = e64263;
var statearr_64264_64294 = state_64245;
(statearr_64264_64294[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_64245[(4)]))){
var statearr_64265_64295 = state_64245;
(statearr_64265_64295[(1)] = cljs.core.first((state_64245[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64296 = state_64245;
state_64245 = G__64296;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2879__auto__ = function(state_64245){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2879__auto____1.call(this,state_64245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2879__auto____0;
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2879__auto____1;
return fluree$db$connection_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64266 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_64266[(6)] = c__2901__auto__);

return statearr_64266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(fluree.db.connection_js.connect_p.cljs$lang$maxFixedArity = 2);

/**
 * Closes a connection
 */
fluree.db.connection_js.close = (function fluree$db$connection_js$close(conn){
return fluree.db.connection.close_BANG_(conn);
});
/**
 * Returns true when the connection is properly configured to access the server.
 *   If jwt tokens are used; will also verify that the token has not expired.
 *   Otherwise, throws an error.
 */
fluree.db.connection_js.check_connection = (function fluree$db$connection_js$check_connection(var_args){
var G__64298 = arguments.length;
switch (G__64298) {
case 1:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$1 = (function (conn){
return fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2(conn,null);
}));

(fluree.db.connection_js.check_connection.cljs$core$IFn$_invoke$arity$2 = (function (conn,opts){
var open_api_QMARK_ = new cljs.core.Keyword(null,"open-api?","open-api?",-789180347).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
var token = new cljs.core.Keyword(null,"jwt","jwt",1504015441).cljs$core$IFn$_invoke$arity$1(opts);
var has_auth_QMARK_ = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = new cljs.core.Keyword(null,"auth-id","auth-id",444160740).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return token;
}
}
})();
var _ = ((((cljs.core.not(open_api_QMARK_)) && (cljs.core.not(has_auth_QMARK_))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("To access the server, either open-api must be true or a valid auth must be available.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(401),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null);
var ___$1 = (cljs.core.truth_(token)?fluree.db.connection_js.validate_token(conn,token):null);
return true;
}));

(fluree.db.connection_js.check_connection.cljs$lang$maxFixedArity = 2);

/**
 * Listens to all events of a given ledger. Supply a ledger identity,
 *   any key, and a two-argument function that will be called with each event.
 * 
 *   The key is any arbitrary key, and is only used to close the listener via close-listener,
 *   otherwise it is opaque to the listener.
 * 
 *   The callback function's first argument is the event header/metadata and the second argument
 *   is the event data itself.
 */
fluree.db.connection_js.listen = (function fluree$db$connection_js$listen(conn,ledger,key,callback){
var vec__64300 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64300,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64300,(1),null);
var cb_STAR_ = (function (header,data){
var G__64303 = cljs.core.clj__GT_js(header);
var G__64304 = cljs.core.clj__GT_js(data);
return (callback.cljs$core$IFn$_invoke$arity$2 ? callback.cljs$core$IFn$_invoke$arity$2(G__64303,G__64304) : callback.call(null,G__64303,G__64304));
});
return fluree.db.connection.add_listener(conn,network,ledger_id,key,cb_STAR_);
});
/**
 * Closes a listener.
 */
fluree.db.connection_js.close_listener = (function fluree$db$connection_js$close_listener(conn,ledger,key){
var vec__64305 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64305,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64305,(1),null);
return fluree.db.connection.remove_listener(conn,network,ledger_id,key);
});
/**
 * Return a list of listeners currently registered for each ledger along with their respective keys.
 */
fluree.db.connection_js.listeners = (function fluree$db$connection_js$listeners(conn){
return cljs.core.clj__GT_js(fluree.db.connection.listeners(conn));
});
/**
 * Returns true when the ledger server/group supports password authentication
 */
fluree.db.connection_js.password_enabled_QMARK_ = (function fluree$db$connection_js$password_enabled_QMARK_(conn){
return new cljs.core.Keyword(null,"password-enabled?","password-enabled?",-456274989).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(new cljs.core.Keyword(null,"flureedb-settings","flureedb-settings",-113464018).cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Generates a password auth record for an existing role, or a user.
 *   The user may exist, or if createUser? is true, the user is created.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.password_generate = (function fluree$db$connection_js$password_generate(conn,ledger,password,map_data){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64358){
var state_val_64359 = (state_64358[(1)]);
if((state_val_64359 === (7))){
var inst_64319 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64320 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_64321 = cljs.core.PersistentHashMap.fromArrays(inst_64319,inst_64320);
var inst_64322 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_64321);
var inst_64323 = (function(){throw inst_64322})();
var state_64358__$1 = state_64358;
var statearr_64360_64392 = state_64358__$1;
(statearr_64360_64392[(2)] = inst_64323);

(statearr_64360_64392[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64359 === (1))){
var state_64358__$1 = state_64358;
var statearr_64361_64393 = state_64358__$1;
(statearr_64361_64393[(2)] = null);

(statearr_64361_64393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64359 === (4))){
var inst_64308 = (state_64358[(2)]);
var inst_64309 = cljs.core.clj__GT_js(inst_64308);
var inst_64310 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_64309) : reject.call(null,inst_64309));
var state_64358__$1 = state_64358;
var statearr_64362_64394 = state_64358__$1;
(statearr_64362_64394[(2)] = inst_64310);

(statearr_64362_64394[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64359 === (13))){
var inst_64337 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64338 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_64339 = cljs.core.PersistentHashMap.fromArrays(inst_64337,inst_64338);
var inst_64340 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied.",inst_64339);
var inst_64341 = (function(){throw inst_64340})();
var state_64358__$1 = state_64358;
var statearr_64363_64395 = state_64358__$1;
(statearr_64363_64395[(2)] = inst_64341);

(statearr_64363_64395[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64359 === (6))){
var state_64358__$1 = state_64358;
var statearr_64364_64396 = state_64358__$1;
(statearr_64364_64396[(2)] = null);

(statearr_64364_64396[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64359 === (3))){
var inst_64356 = (state_64358[(2)]);
var state_64358__$1 = state_64358;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64358__$1,inst_64356);
} else {
if((state_val_64359 === (12))){
var state_64358__$1 = state_64358;
var statearr_64365_64397 = state_64358__$1;
(statearr_64365_64397[(2)] = null);

(statearr_64365_64397[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64359 === (2))){
var _ = (function (){var statearr_64366 = state_64358;
(statearr_64366[(4)] = cljs.core.cons((5),(state_64358[(4)])));

return statearr_64366;
})();
var inst_64316 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_64358__$1 = state_64358;
if(cljs.core.truth_(inst_64316)){
var statearr_64367_64398 = state_64358__$1;
(statearr_64367_64398[(1)] = (6));

} else {
var statearr_64368_64399 = state_64358__$1;
(statearr_64368_64399[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64359 === (11))){
var inst_64334 = (state_64358[(2)]);
var state_64358__$1 = (function (){var statearr_64370 = state_64358;
(statearr_64370[(7)] = inst_64334);

return statearr_64370;
})();
if(cljs.core.truth_(password)){
var statearr_64371_64400 = state_64358__$1;
(statearr_64371_64400[(1)] = (12));

} else {
var statearr_64372_64401 = state_64358__$1;
(statearr_64372_64401[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64359 === (9))){
var state_64358__$1 = state_64358;
var statearr_64373_64402 = state_64358__$1;
(statearr_64373_64402[(2)] = null);

(statearr_64373_64402[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64359 === (5))){
var _ = (function (){var statearr_64374 = state_64358;
(statearr_64374[(4)] = cljs.core.rest((state_64358[(4)])));

return statearr_64374;
})();
var state_64358__$1 = state_64358;
var ex64369 = (state_64358__$1[(2)]);
var statearr_64375_64403 = state_64358__$1;
(statearr_64375_64403[(5)] = ex64369);


var statearr_64376_64404 = state_64358__$1;
(statearr_64376_64404[(1)] = (4));

(statearr_64376_64404[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64359 === (14))){
var inst_64343 = (state_64358[(2)]);
var inst_64344 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(map_data,new cljs.core.Keyword(null,"ledger","ledger",561720706),ledger,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"password","password",417022471),password], 0));
var inst_64345 = fluree.db.util.core.without_nils(inst_64344);
var inst_64346 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_64347 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_64348 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64349 = [new cljs.core.Keyword(null,"pw-generate","pw-generate",-1834816603),inst_64345,inst_64346,null];
var inst_64350 = (new cljs.core.PersistentVector(null,4,(5),inst_64348,inst_64349,null));
var inst_64351 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_64347,inst_64350);
var inst_64352 = (function (){var _ = inst_64343;
var data = inst_64345;
var pc = inst_64346;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The password auth could not be generated.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__64377 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__64377) : reject.call(null,G__64377));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__64378 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__64378) : reject.call(null,G__64378));
} else {
var G__64379 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__64379) : resolve.call(null,G__64379));

}
}
});
})();
var inst_64353 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_64346,inst_64352);
var _ = (function (){var statearr_64380 = state_64358;
(statearr_64380[(4)] = cljs.core.rest((state_64358[(4)])));

return statearr_64380;
})();
var state_64358__$1 = (function (){var statearr_64381 = state_64358;
(statearr_64381[(8)] = inst_64351);

return statearr_64381;
})();
var statearr_64382_64405 = state_64358__$1;
(statearr_64382_64405[(2)] = inst_64353);

(statearr_64382_64405[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64359 === (10))){
var inst_64328 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64329 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_64330 = cljs.core.PersistentHashMap.fromArrays(inst_64328,inst_64329);
var inst_64331 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied.",inst_64330);
var inst_64332 = (function(){throw inst_64331})();
var state_64358__$1 = state_64358;
var statearr_64383_64406 = state_64358__$1;
(statearr_64383_64406[(2)] = inst_64332);

(statearr_64383_64406[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64359 === (8))){
var inst_64325 = (state_64358[(2)]);
var state_64358__$1 = (function (){var statearr_64384 = state_64358;
(statearr_64384[(9)] = inst_64325);

return statearr_64384;
})();
if(cljs.core.truth_(ledger)){
var statearr_64385_64407 = state_64358__$1;
(statearr_64385_64407[(1)] = (9));

} else {
var statearr_64386_64408 = state_64358__$1;
(statearr_64386_64408[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$password_generate_$_state_machine__2879__auto__ = null;
var fluree$db$connection_js$password_generate_$_state_machine__2879__auto____0 = (function (){
var statearr_64387 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64387[(0)] = fluree$db$connection_js$password_generate_$_state_machine__2879__auto__);

(statearr_64387[(1)] = (1));

return statearr_64387;
});
var fluree$db$connection_js$password_generate_$_state_machine__2879__auto____1 = (function (state_64358){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_64358);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64388){var ex__2882__auto__ = e64388;
var statearr_64389_64409 = state_64358;
(statearr_64389_64409[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_64358[(4)]))){
var statearr_64390_64410 = state_64358;
(statearr_64390_64410[(1)] = cljs.core.first((state_64358[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64411 = state_64358;
state_64358 = G__64411;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection_js$password_generate_$_state_machine__2879__auto__ = function(state_64358){
switch(arguments.length){
case 0:
return fluree$db$connection_js$password_generate_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection_js$password_generate_$_state_machine__2879__auto____1.call(this,state_64358);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$password_generate_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$password_generate_$_state_machine__2879__auto____0;
fluree$db$connection_js$password_generate_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$password_generate_$_state_machine__2879__auto____1;
return fluree$db$connection_js$password_generate_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64391 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_64391[(6)] = c__2901__auto__);

return statearr_64391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
})));
});
/**
 * Returns a JWT token if successful.
 *   Must supply ledger, password and either user or auth identifier.
 *   Expire is optional
 *   - ledger   - ledger identifier
 *   - password - plain-text password
 *   - user     - _user/username (TODO: should allow any _user ident in the future)
 *   - auth     - _auth/id (TODO: should allow any _auth ident in the future)
 *   - expire   - requested time to expire in milliseconds
 */
fluree.db.connection_js.password_login = (function fluree$db$connection_js$password_login(var_args){
var G__64413 = arguments.length;
switch (G__64413) {
case 4:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$4 = (function (conn,ledger,password,user){
return fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6(conn,ledger,password,user,null,null);
}));

(fluree.db.connection_js.password_login.cljs$core$IFn$_invoke$arity$6 = (function (conn,ledger,password,user,auth,expire){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64480){
var state_val_64481 = (state_64480[(1)]);
if((state_val_64481 === (7))){
var inst_64425 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64426 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_64427 = cljs.core.PersistentHashMap.fromArrays(inst_64425,inst_64426);
var inst_64428 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_64427);
var inst_64429 = (function(){throw inst_64428})();
var state_64480__$1 = state_64480;
var statearr_64482_64524 = state_64480__$1;
(statearr_64482_64524[(2)] = inst_64429);

(statearr_64482_64524[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64481 === (20))){
var inst_64463 = (state_64480[(2)]);
var inst_64464 = [new cljs.core.Keyword(null,"ledger","ledger",561720706),new cljs.core.Keyword(null,"password","password",417022471),new cljs.core.Keyword(null,"user","user",1532431356),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_64465 = [ledger,password,user,auth,expire];
var inst_64466 = cljs.core.PersistentHashMap.fromArrays(inst_64464,inst_64465);
var inst_64467 = fluree.db.util.core.without_nils(inst_64466);
var inst_64468 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_64469 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_64470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64471 = [new cljs.core.Keyword(null,"pw-login","pw-login",-335915426),inst_64467,inst_64468,null];
var inst_64472 = (new cljs.core.PersistentVector(null,4,(5),inst_64470,inst_64471,null));
var inst_64473 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_64469,inst_64472);
var inst_64474 = (function (){var _ = inst_64463;
var data = inst_64467;
var pc = inst_64468;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A token could not be generated for the identity and password combination.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__64483 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__64483) : reject.call(null,G__64483));
} else {
return null;
}
} else {
if((result instanceof cljs.core.ExceptionInfo)){
var err_data = cljs.core.ex_data(result);
var err_resp = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (400);
}
})(),new cljs.core.Keyword(null,"message","message",-406056002),cljs.core.ex_message(result),new cljs.core.Keyword(null,"error","error",-978969032),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(err_data);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926);
}
})()], null);
var G__64484 = cljs.core.clj__GT_js(err_resp);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__64484) : reject.call(null,G__64484));
} else {
fluree.db.connection.add_token(conn,result);

var G__64485 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__64485) : resolve.call(null,G__64485));

}
}
});
})();
var inst_64475 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_64468,inst_64474);
var _ = (function (){var statearr_64486 = state_64480;
(statearr_64486[(4)] = cljs.core.rest((state_64480[(4)])));

return statearr_64486;
})();
var state_64480__$1 = (function (){var statearr_64487 = state_64480;
(statearr_64487[(7)] = inst_64473);

return statearr_64487;
})();
var statearr_64488_64525 = state_64480__$1;
(statearr_64488_64525[(2)] = inst_64475);

(statearr_64488_64525[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64481 === (1))){
var state_64480__$1 = state_64480;
var statearr_64489_64526 = state_64480__$1;
(statearr_64489_64526[(2)] = null);

(statearr_64489_64526[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64481 === (4))){
var inst_64414 = (state_64480[(2)]);
var inst_64415 = cljs.core.clj__GT_js(inst_64414);
var inst_64416 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_64415) : reject.call(null,inst_64415));
var state_64480__$1 = state_64480;
var statearr_64490_64527 = state_64480__$1;
(statearr_64490_64527[(2)] = inst_64416);

(statearr_64490_64527[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64481 === (15))){
var inst_64450 = (state_64480[(8)]);
var state_64480__$1 = state_64480;
var statearr_64491_64528 = state_64480__$1;
(statearr_64491_64528[(2)] = inst_64450);

(statearr_64491_64528[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64481 === (13))){
var inst_64443 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64444 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_64445 = cljs.core.PersistentHashMap.fromArrays(inst_64443,inst_64444);
var inst_64446 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A password must be supplied in the provided JSON.",inst_64445);
var inst_64447 = (function(){throw inst_64446})();
var state_64480__$1 = state_64480;
var statearr_64492_64529 = state_64480__$1;
(statearr_64492_64529[(2)] = inst_64447);

(statearr_64492_64529[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64481 === (6))){
var state_64480__$1 = state_64480;
var statearr_64493_64530 = state_64480__$1;
(statearr_64493_64530[(2)] = null);

(statearr_64493_64530[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64481 === (17))){
var inst_64454 = (state_64480[(2)]);
var state_64480__$1 = state_64480;
if(cljs.core.truth_(inst_64454)){
var statearr_64494_64531 = state_64480__$1;
(statearr_64494_64531[(1)] = (18));

} else {
var statearr_64495_64532 = state_64480__$1;
(statearr_64495_64532[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64481 === (3))){
var inst_64478 = (state_64480[(2)]);
var state_64480__$1 = state_64480;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64480__$1,inst_64478);
} else {
if((state_val_64481 === (12))){
var state_64480__$1 = state_64480;
var statearr_64496_64533 = state_64480__$1;
(statearr_64496_64533[(2)] = null);

(statearr_64496_64533[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64481 === (2))){
var _ = (function (){var statearr_64497 = state_64480;
(statearr_64497[(4)] = cljs.core.cons((5),(state_64480[(4)])));

return statearr_64497;
})();
var inst_64422 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_64480__$1 = state_64480;
if(cljs.core.truth_(inst_64422)){
var statearr_64498_64534 = state_64480__$1;
(statearr_64498_64534[(1)] = (6));

} else {
var statearr_64499_64535 = state_64480__$1;
(statearr_64499_64535[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64481 === (19))){
var inst_64457 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64458 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_64459 = cljs.core.PersistentHashMap.fromArrays(inst_64457,inst_64458);
var inst_64460 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A user identity or auth identity must be supplied.",inst_64459);
var inst_64461 = (function(){throw inst_64460})();
var state_64480__$1 = state_64480;
var statearr_64500_64536 = state_64480__$1;
(statearr_64500_64536[(2)] = inst_64461);

(statearr_64500_64536[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64481 === (11))){
var inst_64440 = (state_64480[(2)]);
var state_64480__$1 = (function (){var statearr_64502 = state_64480;
(statearr_64502[(9)] = inst_64440);

return statearr_64502;
})();
if(cljs.core.truth_(password)){
var statearr_64503_64537 = state_64480__$1;
(statearr_64503_64537[(1)] = (12));

} else {
var statearr_64504_64538 = state_64480__$1;
(statearr_64504_64538[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64481 === (9))){
var state_64480__$1 = state_64480;
var statearr_64505_64539 = state_64480__$1;
(statearr_64505_64539[(2)] = null);

(statearr_64505_64539[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64481 === (5))){
var _ = (function (){var statearr_64506 = state_64480;
(statearr_64506[(4)] = cljs.core.rest((state_64480[(4)])));

return statearr_64506;
})();
var state_64480__$1 = state_64480;
var ex64501 = (state_64480__$1[(2)]);
var statearr_64507_64540 = state_64480__$1;
(statearr_64507_64540[(5)] = ex64501);


var statearr_64508_64541 = state_64480__$1;
(statearr_64508_64541[(1)] = (4));

(statearr_64508_64541[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64481 === (14))){
var inst_64450 = (state_64480[(8)]);
var inst_64449 = (state_64480[(2)]);
var inst_64450__$1 = user;
var state_64480__$1 = (function (){var statearr_64509 = state_64480;
(statearr_64509[(10)] = inst_64449);

(statearr_64509[(8)] = inst_64450__$1);

return statearr_64509;
})();
if(cljs.core.truth_(inst_64450__$1)){
var statearr_64510_64542 = state_64480__$1;
(statearr_64510_64542[(1)] = (15));

} else {
var statearr_64511_64543 = state_64480__$1;
(statearr_64511_64543[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64481 === (16))){
var state_64480__$1 = state_64480;
var statearr_64512_64544 = state_64480__$1;
(statearr_64512_64544[(2)] = auth);

(statearr_64512_64544[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64481 === (10))){
var inst_64434 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64435 = [(400),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)];
var inst_64436 = cljs.core.PersistentHashMap.fromArrays(inst_64434,inst_64435);
var inst_64437 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A ledger must be supplied in the provided JSON.",inst_64436);
var inst_64438 = (function(){throw inst_64437})();
var state_64480__$1 = state_64480;
var statearr_64513_64545 = state_64480__$1;
(statearr_64513_64545[(2)] = inst_64438);

(statearr_64513_64545[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64481 === (18))){
var state_64480__$1 = state_64480;
var statearr_64514_64546 = state_64480__$1;
(statearr_64514_64546[(2)] = null);

(statearr_64514_64546[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64481 === (8))){
var inst_64431 = (state_64480[(2)]);
var state_64480__$1 = (function (){var statearr_64515 = state_64480;
(statearr_64515[(11)] = inst_64431);

return statearr_64515;
})();
if(cljs.core.truth_(ledger)){
var statearr_64516_64547 = state_64480__$1;
(statearr_64516_64547[(1)] = (9));

} else {
var statearr_64517_64548 = state_64480__$1;
(statearr_64517_64548[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2879__auto__ = null;
var fluree$db$connection_js$state_machine__2879__auto____0 = (function (){
var statearr_64518 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64518[(0)] = fluree$db$connection_js$state_machine__2879__auto__);

(statearr_64518[(1)] = (1));

return statearr_64518;
});
var fluree$db$connection_js$state_machine__2879__auto____1 = (function (state_64480){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_64480);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64519){var ex__2882__auto__ = e64519;
var statearr_64520_64549 = state_64480;
(statearr_64520_64549[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_64480[(4)]))){
var statearr_64521_64550 = state_64480;
(statearr_64521_64550[(1)] = cljs.core.first((state_64480[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64551 = state_64480;
state_64480 = G__64551;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2879__auto__ = function(state_64480){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2879__auto____1.call(this,state_64480);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2879__auto____0;
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2879__auto____1;
return fluree$db$connection_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64522 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_64522[(6)] = c__2901__auto__);

return statearr_64522;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(fluree.db.connection_js.password_login.cljs$lang$maxFixedArity = 6);

/**
 * Renews a JWT token if successful.
 * 
 *   Returns a promise that eventually contains the token or an exception
 */
fluree.db.connection_js.renew_token = (function fluree$db$connection_js$renew_token(var_args){
var G__64553 = arguments.length;
switch (G__64553) {
case 2:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$2 = (function (conn,jwt){
return fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3(conn,jwt,null);
}));

(fluree.db.connection_js.renew_token.cljs$core$IFn$_invoke$arity$3 = (function (conn,jwt,expire){
return (new Promise((function (resolve,reject){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_64588){
var state_val_64589 = (state_64588[(1)]);
if((state_val_64589 === (1))){
var state_64588__$1 = state_64588;
var statearr_64590_64612 = state_64588__$1;
(statearr_64590_64612[(2)] = null);

(statearr_64590_64612[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64589 === (2))){
var _ = (function (){var statearr_64591 = state_64588;
(statearr_64591[(4)] = cljs.core.cons((5),(state_64588[(4)])));

return statearr_64591;
})();
var inst_64562 = fluree.db.connection_js.password_enabled_QMARK_(conn);
var state_64588__$1 = state_64588;
if(cljs.core.truth_(inst_64562)){
var statearr_64592_64613 = state_64588__$1;
(statearr_64592_64613[(1)] = (6));

} else {
var statearr_64593_64614 = state_64588__$1;
(statearr_64593_64614[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64589 === (3))){
var inst_64586 = (state_64588[(2)]);
var state_64588__$1 = state_64588;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64588__$1,inst_64586);
} else {
if((state_val_64589 === (4))){
var inst_64554 = (state_64588[(2)]);
var inst_64555 = cljs.core.clj__GT_js(inst_64554);
var inst_64556 = (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(inst_64555) : reject.call(null,inst_64555));
var state_64588__$1 = state_64588;
var statearr_64595_64615 = state_64588__$1;
(statearr_64595_64615[(2)] = inst_64556);

(statearr_64595_64615[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64589 === (5))){
var _ = (function (){var statearr_64596 = state_64588;
(statearr_64596[(4)] = cljs.core.rest((state_64588[(4)])));

return statearr_64596;
})();
var state_64588__$1 = state_64588;
var ex64594 = (state_64588__$1[(2)]);
var statearr_64597_64616 = state_64588__$1;
(statearr_64597_64616[(5)] = ex64594);


var statearr_64598_64617 = state_64588__$1;
(statearr_64598_64617[(1)] = (4));

(statearr_64598_64617[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64589 === (6))){
var state_64588__$1 = state_64588;
var statearr_64599_64618 = state_64588__$1;
(statearr_64599_64618[(2)] = null);

(statearr_64599_64618[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64589 === (7))){
var inst_64565 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_64566 = [(401),new cljs.core.Keyword("db","no-password-auth","db/no-password-auth",1344949614)];
var inst_64567 = cljs.core.PersistentHashMap.fromArrays(inst_64565,inst_64566);
var inst_64568 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Password authentication is not enabled.",inst_64567);
var inst_64569 = (function(){throw inst_64568})();
var state_64588__$1 = state_64588;
var statearr_64600_64619 = state_64588__$1;
(statearr_64600_64619[(2)] = inst_64569);

(statearr_64600_64619[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_64589 === (8))){
var inst_64571 = (state_64588[(2)]);
var inst_64572 = [new cljs.core.Keyword(null,"jwt","jwt",1504015441),new cljs.core.Keyword(null,"expire","expire",-70657108)];
var inst_64573 = [jwt,expire];
var inst_64574 = cljs.core.PersistentHashMap.fromArrays(inst_64572,inst_64573);
var inst_64575 = fluree.db.util.core.without_nils(inst_64574);
var inst_64576 = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var inst_64577 = new cljs.core.Keyword(null,"req-chan","req-chan",-35924046).cljs$core$IFn$_invoke$arity$1(conn);
var inst_64578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64579 = [new cljs.core.Keyword(null,"pw-renew","pw-renew",2082701857),inst_64575,inst_64576,null];
var inst_64580 = (new cljs.core.PersistentVector(null,4,(5),inst_64578,inst_64579,null));
var inst_64581 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_64577,inst_64580);
var inst_64582 = (function (){var _ = inst_64571;
var data = inst_64575;
var pc = inst_64576;
return (function (result){
if(cljs.core.truth_((((result == null))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("The token could not be renewed.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null))})():null))){
if(cljs.core.truth_(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(result))){
var G__64601 = cljs.core.clj__GT_js(result);
return (reject.cljs$core$IFn$_invoke$arity$1 ? reject.cljs$core$IFn$_invoke$arity$1(G__64601) : reject.call(null,G__64601));
} else {
return null;
}
} else {
fluree.db.connection.add_token(conn,result);

var G__64602 = cljs.core.clj__GT_js(result);
return (resolve.cljs$core$IFn$_invoke$arity$1 ? resolve.cljs$core$IFn$_invoke$arity$1(G__64602) : resolve.call(null,G__64602));

}
});
})();
var inst_64583 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_64576,inst_64582);
var _ = (function (){var statearr_64603 = state_64588;
(statearr_64603[(4)] = cljs.core.rest((state_64588[(4)])));

return statearr_64603;
})();
var state_64588__$1 = (function (){var statearr_64604 = state_64588;
(statearr_64604[(7)] = inst_64581);

return statearr_64604;
})();
var statearr_64605_64620 = state_64588__$1;
(statearr_64605_64620[(2)] = inst_64583);

(statearr_64605_64620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection_js$state_machine__2879__auto__ = null;
var fluree$db$connection_js$state_machine__2879__auto____0 = (function (){
var statearr_64606 = [null,null,null,null,null,null,null,null];
(statearr_64606[(0)] = fluree$db$connection_js$state_machine__2879__auto__);

(statearr_64606[(1)] = (1));

return statearr_64606;
});
var fluree$db$connection_js$state_machine__2879__auto____1 = (function (state_64588){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_64588);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e64607){var ex__2882__auto__ = e64607;
var statearr_64608_64621 = state_64588;
(statearr_64608_64621[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_64588[(4)]))){
var statearr_64609_64622 = state_64588;
(statearr_64609_64622[(1)] = cljs.core.first((state_64588[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__64623 = state_64588;
state_64588 = G__64623;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$connection_js$state_machine__2879__auto__ = function(state_64588){
switch(arguments.length){
case 0:
return fluree$db$connection_js$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$connection_js$state_machine__2879__auto____1.call(this,state_64588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection_js$state_machine__2879__auto____0;
fluree$db$connection_js$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection_js$state_machine__2879__auto____1;
return fluree$db$connection_js$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_64610 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_64610[(6)] = c__2901__auto__);

return statearr_64610;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
})));
}));

(fluree.db.connection_js.renew_token.cljs$lang$maxFixedArity = 3);

