// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__22148 = null;
var G__22148__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22148__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22148__2 = (function (result,flake){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + (1)));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__22148 = function(result,flake){
switch(arguments.length){
case 0:
return G__22148__0.call(this);
case 1:
return G__22148__1.call(this,result);
case 2:
return G__22148__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22148.cljs$core$IFn$_invoke$arity$0 = G__22148__0;
G__22148.cljs$core$IFn$_invoke$arity$1 = G__22148__1;
G__22148.cljs$core$IFn$_invoke$arity$2 = G__22148__2;
return G__22148;
})()
});
});
/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__22149 = null;
var G__22149__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__22149__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__22149__2 = (function (result,flakes){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + cljs.core.count(flakes)));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__22149 = function(result,flakes){
switch(arguments.length){
case 0:
return G__22149__0.call(this);
case 1:
return G__22149__1.call(this,result);
case 2:
return G__22149__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22149.cljs$core$IFn$_invoke$arity$0 = G__22149__0;
G__22149.cljs$core$IFn$_invoke$arity$1 = G__22149__1;
G__22149.cljs$core$IFn$_invoke$arity$2 = G__22149__2;
return G__22149;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + n));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4126__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
cljs.core._vreset_BANG_(cache,cljs.core.assoc_in(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__22151 = res;
var G__22151__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__22150_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__22150_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__22151):G__22151);
var G__22151__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__22151__$1):G__22151__$1);
var G__22151__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__22151__$2):G__22151__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__22151__$3);
} else {
return G__22151__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__22153 = arguments.length;
switch (G__22153) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_22456){
var state_val_22457 = (state_22456[(1)]);
if((state_val_22457 === (65))){
var inst_22314 = (state_22456[(7)]);
var inst_22183 = (state_22456[(8)]);
var inst_22307 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22308 = cljs.core.deref(cache);
var inst_22309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22310 = flake.o;
var inst_22311 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22183);
var inst_22312 = [inst_22310,inst_22311];
var inst_22313 = (new cljs.core.PersistentVector(null,2,(5),inst_22309,inst_22312,null));
var inst_22314__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22308,inst_22313);
var state_22456__$1 = (function (){var statearr_22458 = state_22456;
(statearr_22458[(7)] = inst_22314__$1);

(statearr_22458[(9)] = inst_22307);

return statearr_22458;
})();
if(cljs.core.truth_(inst_22314__$1)){
var statearr_22459_22625 = state_22456__$1;
(statearr_22459_22625[(1)] = (68));

} else {
var statearr_22460_22626 = state_22456__$1;
(statearr_22460_22626[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (70))){
var inst_22307 = (state_22456[(9)]);
var inst_22332 = (state_22456[(2)]);
var inst_22333 = [inst_22332,offset_map];
var inst_22334 = (new cljs.core.PersistentVector(null,2,(5),inst_22307,inst_22333,null));
var state_22456__$1 = state_22456;
var statearr_22461_22627 = state_22456__$1;
(statearr_22461_22627[(2)] = inst_22334);

(statearr_22461_22627[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (62))){
var inst_22221 = (state_22456[(10)]);
var inst_22194 = (state_22456[(11)]);
var inst_22219 = (state_22456[(12)]);
var inst_22215 = (state_22456[(13)]);
var inst_22183 = (state_22456[(8)]);
var inst_22276 = (state_22456[(14)]);
var inst_22216 = (state_22456[(15)]);
var inst_22218 = (state_22456[(16)]);
var inst_22292 = (state_22456[(17)]);
var inst_22217 = (state_22456[(18)]);
var inst_22220 = (state_22456[(19)]);
var inst_22177 = (state_22456[(20)]);
var inst_22294 = (function (){var p = inst_22221;
var pred_spec__$1 = inst_22177;
var orderBy = inst_22219;
var nested_select_spec = inst_22276;
var multi_QMARK_ = inst_22216;
var limit = inst_22218;
var offset = inst_22220;
var G__22278 = inst_22292;
var k = inst_22194;
var pred_spec_SINGLEQUOTE_ = inst_22183;
var map__22160 = inst_22215;
var ref_QMARK_ = inst_22217;
return (function (n){
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,nested_select_spec,n) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n));
});
})();
var inst_22295 = (inst_22294.cljs$core$IFn$_invoke$arity$1 ? inst_22294.cljs$core$IFn$_invoke$arity$1(inst_22292) : inst_22294.call(null,inst_22292));
var state_22456__$1 = state_22456;
var statearr_22462_22628 = state_22456__$1;
(statearr_22462_22628[(2)] = inst_22295);

(statearr_22462_22628[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (74))){
var inst_22341 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
if(cljs.core.truth_(inst_22341)){
var statearr_22463_22629 = state_22456__$1;
(statearr_22463_22629[(1)] = (75));

} else {
var statearr_22464_22630 = state_22456__$1;
(statearr_22464_22630[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (7))){
var inst_22164 = (state_22456[(21)]);
var state_22456__$1 = state_22456;
var statearr_22465_22631 = state_22456__$1;
(statearr_22465_22631[(2)] = inst_22164);

(statearr_22465_22631[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (59))){
var inst_22286 = (state_22456[(22)]);
var inst_22288 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_22289 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_22288,inst_22286);
var state_22456__$1 = state_22456;
var statearr_22466_22632 = state_22456__$1;
(statearr_22466_22632[(2)] = inst_22289);

(statearr_22466_22632[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (86))){
var inst_22221 = (state_22456[(10)]);
var inst_22194 = (state_22456[(11)]);
var inst_22219 = (state_22456[(12)]);
var inst_22215 = (state_22456[(13)]);
var inst_22354 = (state_22456[(23)]);
var inst_22372 = (state_22456[(24)]);
var inst_22183 = (state_22456[(8)]);
var inst_22216 = (state_22456[(15)]);
var inst_22218 = (state_22456[(16)]);
var inst_22217 = (state_22456[(18)]);
var inst_22220 = (state_22456[(19)]);
var inst_22177 = (state_22456[(20)]);
var inst_22374 = (function (){var G__22366 = inst_22372;
var p = inst_22221;
var pred_spec__$1 = inst_22177;
var orderBy = inst_22219;
var children = inst_22354;
var multi_QMARK_ = inst_22216;
var limit = inst_22218;
var offset = inst_22220;
var k = inst_22194;
var pred_spec_SINGLEQUOTE_ = inst_22183;
var map__22160 = inst_22215;
var ref_QMARK_ = inst_22217;
return (function (n){
var G__22467 = db;
var G__22468 = cache;
var G__22469 = fuel;
var G__22470 = max_fuel;
var G__22471 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),true], null);
var G__22472 = n;
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(G__22467,G__22468,G__22469,G__22470,G__22471,G__22472) : fluree.db.query.fql.flakes__GT_res.call(null,G__22467,G__22468,G__22469,G__22470,G__22471,G__22472));
});
})();
var inst_22375 = (inst_22374.cljs$core$IFn$_invoke$arity$1 ? inst_22374.cljs$core$IFn$_invoke$arity$1(inst_22372) : inst_22374.call(null,inst_22372));
var state_22456__$1 = state_22456;
var statearr_22473_22633 = state_22456__$1;
(statearr_22473_22633[(2)] = inst_22375);

(statearr_22473_22633[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (20))){
var inst_22192 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
var statearr_22474_22634 = state_22456__$1;
(statearr_22474_22634[(2)] = inst_22192);

(statearr_22474_22634[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (72))){
var inst_22183 = (state_22456[(8)]);
var inst_22338 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22183);
var state_22456__$1 = state_22456;
var statearr_22475_22635 = state_22456__$1;
(statearr_22475_22635[(2)] = inst_22338);

(statearr_22475_22635[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (58))){
var inst_22285 = (state_22456[(2)]);
var inst_22286 = fluree.db.util.async.throw_err(inst_22285);
var state_22456__$1 = (function (){var statearr_22476 = state_22456;
(statearr_22476[(22)] = inst_22286);

return statearr_22476;
})();
if(cljs.core.truth_(fuel)){
var statearr_22477_22636 = state_22456__$1;
(statearr_22477_22636[(1)] = (59));

} else {
var statearr_22478_22637 = state_22456__$1;
(statearr_22478_22637[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (60))){
var inst_22286 = (state_22456[(22)]);
var state_22456__$1 = state_22456;
var statearr_22479_22638 = state_22456__$1;
(statearr_22479_22638[(2)] = inst_22286);

(statearr_22479_22638[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (27))){
var inst_22183 = (state_22456[(8)]);
var inst_22212 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_22183);
var state_22456__$1 = state_22456;
var statearr_22480_22639 = state_22456__$1;
(statearr_22480_22639[(2)] = inst_22212);

(statearr_22480_22639[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (1))){
var state_22456__$1 = state_22456;
var statearr_22481_22640 = state_22456__$1;
(statearr_22481_22640[(2)] = null);

(statearr_22481_22640[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (69))){
var inst_22183 = (state_22456[(8)]);
var inst_22317 = flake.o;
var inst_22318 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22183);
var inst_22319 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_22317,inst_22318);
var state_22456__$1 = state_22456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22456__$1,(71),inst_22319);
} else {
if((state_val_22457 === (101))){
var inst_22416 = (state_22456[(25)]);
var inst_22417 = (state_22456[(26)]);
var inst_22194 = (state_22456[(11)]);
var inst_22436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22437 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22194,inst_22416);
var inst_22438 = [inst_22437,inst_22417];
var inst_22439 = (new cljs.core.PersistentVector(null,2,(5),inst_22436,inst_22438,null));
var state_22456__$1 = state_22456;
var statearr_22482_22641 = state_22456__$1;
(statearr_22482_22641[(2)] = inst_22439);

(statearr_22482_22641[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (24))){
var state_22456__$1 = state_22456;
var statearr_22483_22642 = state_22456__$1;
(statearr_22483_22642[(2)] = true);

(statearr_22483_22642[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (102))){
var state_22456__$1 = state_22456;
var statearr_22484_22643 = state_22456__$1;
(statearr_22484_22643[(1)] = (104));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (55))){
var inst_22183 = (state_22456[(8)]);
var inst_22305 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22183);
var state_22456__$1 = state_22456;
if(cljs.core.truth_(inst_22305)){
var statearr_22486_22644 = state_22456__$1;
(statearr_22486_22644[(1)] = (65));

} else {
var statearr_22487_22645 = state_22456__$1;
(statearr_22487_22645[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (85))){
var inst_22372 = (state_22456[(2)]);
var state_22456__$1 = (function (){var statearr_22488 = state_22456;
(statearr_22488[(24)] = inst_22372);

return statearr_22488;
})();
var statearr_22489_22646 = state_22456__$1;
(statearr_22489_22646[(1)] = (86));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (39))){
var inst_22221 = (state_22456[(10)]);
var inst_22238 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22221,cljs.core.dec);
var state_22456__$1 = state_22456;
var statearr_22491_22647 = state_22456__$1;
(statearr_22491_22647[(2)] = inst_22238);

(statearr_22491_22647[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (88))){
var inst_22378 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22456__$1,(82),inst_22378);
} else {
if((state_val_22457 === (46))){
var inst_22261 = cljs.core.not(recur_QMARK_);
var state_22456__$1 = state_22456;
if(inst_22261){
var statearr_22492_22648 = state_22456__$1;
(statearr_22492_22648[(1)] = (48));

} else {
var statearr_22493_22649 = state_22456__$1;
(statearr_22493_22649[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (4))){
var inst_22154 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
var statearr_22494_22650 = state_22456__$1;
(statearr_22494_22650[(2)] = inst_22154);

(statearr_22494_22650[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (77))){
var inst_22407 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
var statearr_22495_22651 = state_22456__$1;
(statearr_22495_22651[(2)] = inst_22407);

(statearr_22495_22651[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (106))){
var inst_22447 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
var statearr_22496_22652 = state_22456__$1;
(statearr_22496_22652[(2)] = inst_22447);

(statearr_22496_22652[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (95))){
var inst_22216 = (state_22456[(15)]);
var state_22456__$1 = state_22456;
var statearr_22497_22653 = state_22456__$1;
(statearr_22497_22653[(2)] = inst_22216);

(statearr_22497_22653[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (54))){
var inst_22183 = (state_22456[(8)]);
var inst_22273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22274 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_22275 = (new cljs.core.PersistentVector(null,3,(5),inst_22273,inst_22274,null));
var inst_22276 = cljs.core.select_keys(inst_22183,inst_22275);
var inst_22277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22279 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22280 = flake.o;
var inst_22281 = [inst_22280];
var inst_22282 = (new cljs.core.PersistentVector(null,1,(5),inst_22279,inst_22281,null));
var inst_22283 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22282);
var state_22456__$1 = (function (){var statearr_22498 = state_22456;
(statearr_22498[(27)] = inst_22277);

(statearr_22498[(14)] = inst_22276);

return statearr_22498;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22456__$1,(58),inst_22283);
} else {
if((state_val_22457 === (92))){
var inst_22397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22398 = flake.o;
var inst_22399 = [inst_22398,offset_map];
var inst_22400 = (new cljs.core.PersistentVector(null,2,(5),inst_22397,inst_22399,null));
var state_22456__$1 = state_22456;
var statearr_22499_22654 = state_22456__$1;
(statearr_22499_22654[(2)] = inst_22400);

(statearr_22499_22654[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (104))){
var inst_22417 = (state_22456[(26)]);
var inst_22442 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22443 = [acc,inst_22417];
var inst_22444 = (new cljs.core.PersistentVector(null,2,(5),inst_22442,inst_22443,null));
var state_22456__$1 = state_22456;
var statearr_22500_22655 = state_22456__$1;
(statearr_22500_22655[(2)] = inst_22444);

(statearr_22500_22655[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (15))){
var inst_22184 = (state_22456[(28)]);
var state_22456__$1 = state_22456;
var statearr_22501_22656 = state_22456__$1;
(statearr_22501_22656[(2)] = inst_22184);

(statearr_22501_22656[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (48))){
var inst_22263 = (state_22456[(29)]);
var inst_22183 = (state_22456[(8)]);
var inst_22263__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22183);
var state_22456__$1 = (function (){var statearr_22502 = state_22456;
(statearr_22502[(29)] = inst_22263__$1);

return statearr_22502;
})();
if(cljs.core.truth_(inst_22263__$1)){
var statearr_22503_22657 = state_22456__$1;
(statearr_22503_22657[(1)] = (51));

} else {
var statearr_22504_22658 = state_22456__$1;
(statearr_22504_22658[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (50))){
var inst_22271 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
if(cljs.core.truth_(inst_22271)){
var statearr_22505_22659 = state_22456__$1;
(statearr_22505_22659[(1)] = (54));

} else {
var statearr_22506_22660 = state_22456__$1;
(statearr_22506_22660[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (75))){
var inst_22183 = (state_22456[(8)]);
var inst_22343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22344 = flake.o;
var inst_22345 = [inst_22344];
var inst_22346 = (new cljs.core.PersistentVector(null,1,(5),inst_22343,inst_22345,null));
var inst_22347 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22348 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22183);
var inst_22349 = [inst_22348];
var inst_22350 = cljs.core.PersistentHashMap.fromArrays(inst_22347,inst_22349);
var inst_22351 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22346,inst_22350);
var state_22456__$1 = state_22456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22456__$1,(78),inst_22351);
} else {
if((state_val_22457 === (99))){
var inst_22416 = (state_22456[(25)]);
var inst_22433 = (inst_22416 == null);
var inst_22434 = cljs.core.not(inst_22433);
var state_22456__$1 = state_22456;
if(inst_22434){
var statearr_22507_22661 = state_22456__$1;
(statearr_22507_22661[(1)] = (101));

} else {
var statearr_22508_22662 = state_22456__$1;
(statearr_22508_22662[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (21))){
var inst_22183 = (state_22456[(8)]);
var inst_22199 = inst_22183.cljs$lang$protocol_mask$partition0$;
var inst_22200 = (inst_22199 & (64));
var inst_22201 = inst_22183.cljs$core$ISeq$;
var inst_22202 = (cljs.core.PROTOCOL_SENTINEL === inst_22201);
var inst_22203 = ((inst_22200) || (inst_22202));
var state_22456__$1 = state_22456;
if(cljs.core.truth_(inst_22203)){
var statearr_22509_22663 = state_22456__$1;
(statearr_22509_22663[(1)] = (24));

} else {
var statearr_22510_22664 = state_22456__$1;
(statearr_22510_22664[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (31))){
var inst_22216 = (state_22456[(15)]);
var state_22456__$1 = state_22456;
var statearr_22511_22665 = state_22456__$1;
(statearr_22511_22665[(2)] = inst_22216);

(statearr_22511_22665[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (32))){
var inst_22233 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
if(cljs.core.truth_(inst_22233)){
var statearr_22512_22666 = state_22456__$1;
(statearr_22512_22666[(1)] = (36));

} else {
var statearr_22513_22667 = state_22456__$1;
(statearr_22513_22667[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (40))){
var inst_22221 = (state_22456[(10)]);
var inst_22220 = (state_22456[(19)]);
var inst_22240 = (inst_22220 - (1));
var inst_22241 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_22221,inst_22240);
var state_22456__$1 = state_22456;
var statearr_22514_22668 = state_22456__$1;
(statearr_22514_22668[(2)] = inst_22241);

(statearr_22514_22668[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (91))){
var inst_22405 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
var statearr_22515_22669 = state_22456__$1;
(statearr_22515_22669[(2)] = inst_22405);

(statearr_22515_22669[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (56))){
var inst_22411 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
var statearr_22516_22670 = state_22456__$1;
(statearr_22516_22670[(2)] = inst_22411);

(statearr_22516_22670[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (33))){
var inst_22221 = (state_22456[(10)]);
var inst_22220 = (state_22456[(19)]);
var inst_22224 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22220);
var inst_22225 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22221);
var inst_22226 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_22225);
var inst_22227 = ((inst_22224) && (inst_22226));
var state_22456__$1 = state_22456;
var statearr_22517_22671 = state_22456__$1;
(statearr_22517_22671[(2)] = inst_22227);

(statearr_22517_22671[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (13))){
var inst_22177 = (state_22456[(20)]);
var inst_22181 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22177,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_22456__$1 = state_22456;
var statearr_22518_22672 = state_22456__$1;
(statearr_22518_22672[(2)] = inst_22181);

(statearr_22518_22672[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (22))){
var state_22456__$1 = state_22456;
var statearr_22519_22673 = state_22456__$1;
(statearr_22519_22673[(2)] = false);

(statearr_22519_22673[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (90))){
var state_22456__$1 = state_22456;
var statearr_22520_22674 = state_22456__$1;
(statearr_22520_22674[(1)] = (92));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (36))){
var inst_22221 = (state_22456[(10)]);
var inst_22235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22236 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_22221);
var state_22456__$1 = (function (){var statearr_22522 = state_22456;
(statearr_22522[(30)] = inst_22235);

return statearr_22522;
})();
if(cljs.core.truth_(inst_22236)){
var statearr_22523_22675 = state_22456__$1;
(statearr_22523_22675[(1)] = (39));

} else {
var statearr_22524_22676 = state_22456__$1;
(statearr_22524_22676[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (41))){
var inst_22235 = (state_22456[(30)]);
var inst_22243 = (state_22456[(2)]);
var inst_22244 = [null,inst_22243];
var inst_22245 = (new cljs.core.PersistentVector(null,2,(5),inst_22235,inst_22244,null));
var state_22456__$1 = state_22456;
var statearr_22525_22677 = state_22456__$1;
(statearr_22525_22677[(2)] = inst_22245);

(statearr_22525_22677[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (89))){
var inst_22388 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22389 = ["_id"];
var inst_22390 = flake.o;
var inst_22391 = [inst_22390];
var inst_22392 = cljs.core.PersistentHashMap.fromArrays(inst_22389,inst_22391);
var inst_22393 = [inst_22392,offset_map];
var inst_22394 = (new cljs.core.PersistentVector(null,2,(5),inst_22388,inst_22393,null));
var state_22456__$1 = state_22456;
var statearr_22526_22678 = state_22456__$1;
(statearr_22526_22678[(2)] = inst_22394);

(statearr_22526_22678[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (100))){
var inst_22451 = (state_22456[(2)]);
var _ = (function (){var statearr_22527 = state_22456;
(statearr_22527[(4)] = cljs.core.rest((state_22456[(4)])));

return statearr_22527;
})();
var state_22456__$1 = state_22456;
var statearr_22528_22679 = state_22456__$1;
(statearr_22528_22679[(2)] = inst_22451);

(statearr_22528_22679[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (43))){
var inst_22216 = (state_22456[(15)]);
var state_22456__$1 = state_22456;
var statearr_22529_22680 = state_22456__$1;
(statearr_22529_22680[(2)] = inst_22216);

(statearr_22529_22680[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (61))){
var inst_22292 = (state_22456[(2)]);
var state_22456__$1 = (function (){var statearr_22530 = state_22456;
(statearr_22530[(17)] = inst_22292);

return statearr_22530;
})();
var statearr_22531_22681 = state_22456__$1;
(statearr_22531_22681[(1)] = (62));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (29))){
var inst_22215 = (state_22456[(13)]);
var inst_22216 = (state_22456[(15)]);
var inst_22215__$1 = (state_22456[(2)]);
var inst_22216__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22215__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22217 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22215__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22218 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22215__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22219 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22215__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22220 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22215__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22221 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22215__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_22456__$1 = (function (){var statearr_22533 = state_22456;
(statearr_22533[(10)] = inst_22221);

(statearr_22533[(12)] = inst_22219);

(statearr_22533[(13)] = inst_22215__$1);

(statearr_22533[(15)] = inst_22216__$1);

(statearr_22533[(16)] = inst_22218);

(statearr_22533[(18)] = inst_22217);

(statearr_22533[(19)] = inst_22220);

return statearr_22533;
})();
if(cljs.core.truth_(inst_22216__$1)){
var statearr_22534_22682 = state_22456__$1;
(statearr_22534_22682[(1)] = (30));

} else {
var statearr_22535_22683 = state_22456__$1;
(statearr_22535_22683[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (44))){
var inst_22255 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
if(cljs.core.truth_(inst_22255)){
var statearr_22536_22684 = state_22456__$1;
(statearr_22536_22684[(1)] = (45));

} else {
var statearr_22537_22685 = state_22456__$1;
(statearr_22537_22685[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (93))){
var state_22456__$1 = state_22456;
var statearr_22538_22686 = state_22456__$1;
(statearr_22538_22686[(2)] = null);

(statearr_22538_22686[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (6))){
var inst_22166 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22167 = (inst_22166 == null);
var state_22456__$1 = state_22456;
var statearr_22539_22687 = state_22456__$1;
(statearr_22539_22687[(2)] = inst_22167);

(statearr_22539_22687[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (28))){
var inst_22183 = (state_22456[(8)]);
var state_22456__$1 = state_22456;
var statearr_22540_22688 = state_22456__$1;
(statearr_22540_22688[(2)] = inst_22183);

(statearr_22540_22688[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (64))){
var inst_22298 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22456__$1,(57),inst_22298);
} else {
if((state_val_22457 === (103))){
var inst_22449 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
var statearr_22541_22689 = state_22456__$1;
(statearr_22541_22689[(2)] = inst_22449);

(statearr_22541_22689[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (51))){
var inst_22263 = (state_22456[(29)]);
var state_22456__$1 = state_22456;
var statearr_22542_22690 = state_22456__$1;
(statearr_22542_22690[(2)] = inst_22263);

(statearr_22542_22690[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (25))){
var state_22456__$1 = state_22456;
var statearr_22543_22691 = state_22456__$1;
(statearr_22543_22691[(2)] = false);

(statearr_22543_22691[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (34))){
var inst_22220 = (state_22456[(19)]);
var state_22456__$1 = state_22456;
var statearr_22544_22692 = state_22456__$1;
(statearr_22544_22692[(2)] = inst_22220);

(statearr_22544_22692[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (17))){
var inst_22183 = (state_22456[(8)]);
var inst_22194 = (state_22456[(2)]);
var inst_22196 = (inst_22183 == null);
var inst_22197 = cljs.core.not(inst_22196);
var state_22456__$1 = (function (){var statearr_22545 = state_22456;
(statearr_22545[(11)] = inst_22194);

return statearr_22545;
})();
if(inst_22197){
var statearr_22546_22693 = state_22456__$1;
(statearr_22546_22693[(1)] = (21));

} else {
var statearr_22547_22694 = state_22456__$1;
(statearr_22547_22694[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (3))){
var inst_22454 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22456__$1,inst_22454);
} else {
if((state_val_22457 === (12))){
var inst_22177 = (state_22456[(20)]);
var state_22456__$1 = state_22456;
var statearr_22548_22695 = state_22456__$1;
(statearr_22548_22695[(2)] = inst_22177);

(statearr_22548_22695[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (2))){
var inst_22164 = (state_22456[(21)]);
var _ = (function (){var statearr_22549 = state_22456;
(statearr_22549[(4)] = cljs.core.cons((5),(state_22456[(4)])));

return statearr_22549;
})();
var inst_22164__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22456__$1 = (function (){var statearr_22550 = state_22456;
(statearr_22550[(21)] = inst_22164__$1);

return statearr_22550;
})();
if(cljs.core.truth_(inst_22164__$1)){
var statearr_22551_22696 = state_22456__$1;
(statearr_22551_22696[(1)] = (6));

} else {
var statearr_22552_22697 = state_22456__$1;
(statearr_22552_22697[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (66))){
var inst_22336 = (state_22456[(31)]);
var inst_22336__$1 = componentFollow_QMARK_;
var state_22456__$1 = (function (){var statearr_22553 = state_22456;
(statearr_22553[(31)] = inst_22336__$1);

return statearr_22553;
})();
if(cljs.core.truth_(inst_22336__$1)){
var statearr_22554_22698 = state_22456__$1;
(statearr_22554_22698[(1)] = (72));

} else {
var statearr_22555_22699 = state_22456__$1;
(statearr_22555_22699[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (23))){
var inst_22210 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
if(cljs.core.truth_(inst_22210)){
var statearr_22556_22700 = state_22456__$1;
(statearr_22556_22700[(1)] = (27));

} else {
var statearr_22557_22701 = state_22456__$1;
(statearr_22557_22701[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (47))){
var inst_22413 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
var statearr_22558_22702 = state_22456__$1;
(statearr_22558_22702[(2)] = inst_22413);

(statearr_22558_22702[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (35))){
var inst_22230 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
var statearr_22559_22703 = state_22456__$1;
(statearr_22559_22703[(2)] = inst_22230);

(statearr_22559_22703[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (82))){
var inst_22365 = (state_22456[(32)]);
var inst_22380 = (state_22456[(2)]);
var inst_22381 = fluree.db.util.async.throw_err(inst_22380);
var inst_22382 = [inst_22381,offset_map];
var inst_22383 = (new cljs.core.PersistentVector(null,2,(5),inst_22365,inst_22382,null));
var state_22456__$1 = state_22456;
var statearr_22560_22704 = state_22456__$1;
(statearr_22560_22704[(2)] = inst_22383);

(statearr_22560_22704[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (76))){
var inst_22217 = (state_22456[(18)]);
var state_22456__$1 = state_22456;
if(cljs.core.truth_(inst_22217)){
var statearr_22561_22705 = state_22456__$1;
(statearr_22561_22705[(1)] = (89));

} else {
var statearr_22562_22706 = state_22456__$1;
(statearr_22562_22706[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (97))){
var inst_22423 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
if(cljs.core.truth_(inst_22423)){
var statearr_22563_22707 = state_22456__$1;
(statearr_22563_22707[(1)] = (98));

} else {
var statearr_22564_22708 = state_22456__$1;
(statearr_22564_22708[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (19))){
var inst_22183 = (state_22456[(8)]);
var inst_22190 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22183);
var state_22456__$1 = state_22456;
var statearr_22565_22709 = state_22456__$1;
(statearr_22565_22709[(2)] = inst_22190);

(statearr_22565_22709[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (57))){
var inst_22277 = (state_22456[(27)]);
var inst_22300 = (state_22456[(2)]);
var inst_22301 = fluree.db.util.async.throw_err(inst_22300);
var inst_22302 = [inst_22301,offset_map];
var inst_22303 = (new cljs.core.PersistentVector(null,2,(5),inst_22277,inst_22302,null));
var state_22456__$1 = state_22456;
var statearr_22566_22710 = state_22456__$1;
(statearr_22566_22710[(2)] = inst_22303);

(statearr_22566_22710[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (68))){
var inst_22314 = (state_22456[(7)]);
var state_22456__$1 = state_22456;
var statearr_22567_22711 = state_22456__$1;
(statearr_22567_22711[(2)] = inst_22314);

(statearr_22567_22711[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (11))){
var inst_22177 = (state_22456[(20)]);
var inst_22177__$1 = (state_22456[(2)]);
var inst_22178 = cljs.core.contains_QMARK_(inst_22177__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var state_22456__$1 = (function (){var statearr_22569 = state_22456;
(statearr_22569[(20)] = inst_22177__$1);

return statearr_22569;
})();
if(inst_22178){
var statearr_22570_22712 = state_22456__$1;
(statearr_22570_22712[(1)] = (12));

} else {
var statearr_22571_22713 = state_22456__$1;
(statearr_22571_22713[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (9))){
var inst_22172 = flake.p;
var inst_22173 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22174 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_22172,inst_22173);
var state_22456__$1 = state_22456;
var statearr_22572_22714 = state_22456__$1;
(statearr_22572_22714[(2)] = inst_22174);

(statearr_22572_22714[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (5))){
var _ = (function (){var statearr_22573 = state_22456;
(statearr_22573[(4)] = cljs.core.rest((state_22456[(4)])));

return statearr_22573;
})();
var state_22456__$1 = state_22456;
var ex22568 = (state_22456__$1[(2)]);
var statearr_22574_22715 = state_22456__$1;
(statearr_22574_22715[(5)] = ex22568);


if((ex22568 instanceof Error)){
var statearr_22575_22716 = state_22456__$1;
(statearr_22575_22716[(1)] = (4));

(statearr_22575_22716[(5)] = null);

} else {
throw ex22568;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (83))){
var inst_22354 = (state_22456[(23)]);
var inst_22368 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_22369 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_22368,inst_22354);
var state_22456__$1 = state_22456;
var statearr_22576_22717 = state_22456__$1;
(statearr_22576_22717[(2)] = inst_22369);

(statearr_22576_22717[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (14))){
var inst_22184 = (state_22456[(28)]);
var inst_22183 = (state_22456[(8)]);
var inst_22183__$1 = (state_22456[(2)]);
var inst_22184__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22183__$1);
var state_22456__$1 = (function (){var statearr_22577 = state_22456;
(statearr_22577[(28)] = inst_22184__$1);

(statearr_22577[(8)] = inst_22183__$1);

return statearr_22577;
})();
if(cljs.core.truth_(inst_22184__$1)){
var statearr_22578_22718 = state_22456__$1;
(statearr_22578_22718[(1)] = (15));

} else {
var statearr_22579_22719 = state_22456__$1;
(statearr_22579_22719[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (45))){
var inst_22257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22258 = [null,offset_map];
var inst_22259 = (new cljs.core.PersistentVector(null,2,(5),inst_22257,inst_22258,null));
var state_22456__$1 = state_22456;
var statearr_22580_22720 = state_22456__$1;
(statearr_22580_22720[(2)] = inst_22259);

(statearr_22580_22720[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (53))){
var inst_22268 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
var statearr_22581_22721 = state_22456__$1;
(statearr_22581_22721[(2)] = inst_22268);

(statearr_22581_22721[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (78))){
var inst_22354 = (state_22456[(23)]);
var inst_22353 = (state_22456[(2)]);
var inst_22354__$1 = fluree.db.util.async.throw_err(inst_22353);
var inst_22355 = cljs.core.empty_QMARK_(inst_22354__$1);
var state_22456__$1 = (function (){var statearr_22582 = state_22456;
(statearr_22582[(23)] = inst_22354__$1);

return statearr_22582;
})();
if(inst_22355){
var statearr_22583_22722 = state_22456__$1;
(statearr_22583_22722[(1)] = (79));

} else {
var statearr_22584_22723 = state_22456__$1;
(statearr_22584_22723[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (26))){
var inst_22207 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
var statearr_22585_22724 = state_22456__$1;
(statearr_22585_22724[(2)] = inst_22207);

(statearr_22585_22724[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (16))){
var inst_22187 = (state_22456[(33)]);
var inst_22183 = (state_22456[(8)]);
var inst_22187__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22183);
var state_22456__$1 = (function (){var statearr_22586 = state_22456;
(statearr_22586[(33)] = inst_22187__$1);

return statearr_22586;
})();
if(cljs.core.truth_(inst_22187__$1)){
var statearr_22587_22725 = state_22456__$1;
(statearr_22587_22725[(1)] = (18));

} else {
var statearr_22588_22726 = state_22456__$1;
(statearr_22588_22726[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (81))){
var inst_22385 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
var statearr_22589_22727 = state_22456__$1;
(statearr_22589_22727[(2)] = inst_22385);

(statearr_22589_22727[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (79))){
var inst_22357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22358 = ["_id"];
var inst_22359 = flake.o;
var inst_22360 = [inst_22359];
var inst_22361 = cljs.core.PersistentHashMap.fromArrays(inst_22358,inst_22360);
var inst_22362 = [inst_22361,offset_map];
var inst_22363 = (new cljs.core.PersistentVector(null,2,(5),inst_22357,inst_22362,null));
var state_22456__$1 = state_22456;
var statearr_22590_22728 = state_22456__$1;
(statearr_22590_22728[(2)] = inst_22363);

(statearr_22590_22728[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (38))){
var inst_22416 = (state_22456[(25)]);
var inst_22415 = (state_22456[(2)]);
var inst_22416__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22415,(0),null);
var inst_22417 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22415,(1),null);
var inst_22418 = (inst_22416__$1 == null);
var inst_22419 = cljs.core.not(inst_22418);
var state_22456__$1 = (function (){var statearr_22591 = state_22456;
(statearr_22591[(25)] = inst_22416__$1);

(statearr_22591[(26)] = inst_22417);

return statearr_22591;
})();
if(inst_22419){
var statearr_22592_22729 = state_22456__$1;
(statearr_22592_22729[(1)] = (95));

} else {
var statearr_22593_22730 = state_22456__$1;
(statearr_22593_22730[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (98))){
var inst_22416 = (state_22456[(25)]);
var inst_22417 = (state_22456[(26)]);
var inst_22194 = (state_22456[(11)]);
var inst_22425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22426 = cljs.core.PersistentVector.EMPTY;
var inst_22427 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(acc,inst_22194,inst_22426);
var inst_22428 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22427,inst_22416);
var inst_22429 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_22194,inst_22428);
var inst_22430 = [inst_22429,inst_22417];
var inst_22431 = (new cljs.core.PersistentVector(null,2,(5),inst_22425,inst_22430,null));
var state_22456__$1 = state_22456;
var statearr_22594_22731 = state_22456__$1;
(statearr_22594_22731[(2)] = inst_22431);

(statearr_22594_22731[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (87))){
var inst_22372 = (state_22456[(24)]);
var state_22456__$1 = state_22456;
var statearr_22595_22732 = state_22456__$1;
(statearr_22595_22732[(2)] = inst_22372);

(statearr_22595_22732[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (30))){
var inst_22220 = (state_22456[(19)]);
var state_22456__$1 = state_22456;
if(cljs.core.truth_(inst_22220)){
var statearr_22596_22733 = state_22456__$1;
(statearr_22596_22733[(1)] = (33));

} else {
var statearr_22597_22734 = state_22456__$1;
(statearr_22597_22734[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (73))){
var inst_22336 = (state_22456[(31)]);
var state_22456__$1 = state_22456;
var statearr_22598_22735 = state_22456__$1;
(statearr_22598_22735[(2)] = inst_22336);

(statearr_22598_22735[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (96))){
var state_22456__$1 = state_22456;
var statearr_22599_22736 = state_22456__$1;
(statearr_22599_22736[(2)] = false);

(statearr_22599_22736[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (10))){
var state_22456__$1 = state_22456;
var statearr_22600_22737 = state_22456__$1;
(statearr_22600_22737[(2)] = pred_spec);

(statearr_22600_22737[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (18))){
var inst_22187 = (state_22456[(33)]);
var state_22456__$1 = state_22456;
var statearr_22601_22738 = state_22456__$1;
(statearr_22601_22738[(2)] = inst_22187);

(statearr_22601_22738[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (105))){
var state_22456__$1 = state_22456;
var statearr_22602_22739 = state_22456__$1;
(statearr_22602_22739[(2)] = null);

(statearr_22602_22739[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (52))){
var inst_22183 = (state_22456[(8)]);
var inst_22266 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22183);
var state_22456__$1 = state_22456;
var statearr_22603_22740 = state_22456__$1;
(statearr_22603_22740[(2)] = inst_22266);

(statearr_22603_22740[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (67))){
var inst_22409 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
var statearr_22604_22741 = state_22456__$1;
(statearr_22604_22741[(2)] = inst_22409);

(statearr_22604_22741[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (71))){
var inst_22183 = (state_22456[(8)]);
var inst_22321 = (state_22456[(2)]);
var inst_22322 = fluree.db.util.async.throw_err(inst_22321);
var inst_22323 = cljs.core._deref(cache);
var inst_22324 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22325 = flake.o;
var inst_22326 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22183);
var inst_22327 = [inst_22325,inst_22326];
var inst_22328 = (new cljs.core.PersistentVector(null,2,(5),inst_22324,inst_22327,null));
var inst_22329 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22323,inst_22328,inst_22322);
var inst_22330 = cljs.core._vreset_BANG_(cache,inst_22329);
var state_22456__$1 = (function (){var statearr_22605 = state_22456;
(statearr_22605[(34)] = inst_22330);

return statearr_22605;
})();
var statearr_22606_22742 = state_22456__$1;
(statearr_22606_22742[(2)] = inst_22322);

(statearr_22606_22742[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (42))){
var inst_22194 = (state_22456[(11)]);
var inst_22219 = (state_22456[(12)]);
var inst_22218 = (state_22456[(16)]);
var inst_22248 = cljs.core.not(inst_22219);
var inst_22249 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_22194);
var inst_22250 = cljs.core.count(inst_22249);
var inst_22251 = (inst_22250 >= inst_22218);
var inst_22252 = ((inst_22248) && (inst_22251));
var state_22456__$1 = state_22456;
var statearr_22607_22743 = state_22456__$1;
(statearr_22607_22743[(2)] = inst_22252);

(statearr_22607_22743[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (80))){
var inst_22365 = cljs.core.PersistentVector.EMPTY_NODE;
var state_22456__$1 = (function (){var statearr_22608 = state_22456;
(statearr_22608[(32)] = inst_22365);

return statearr_22608;
})();
if(cljs.core.truth_(fuel)){
var statearr_22609_22744 = state_22456__$1;
(statearr_22609_22744[(1)] = (83));

} else {
var statearr_22610_22745 = state_22456__$1;
(statearr_22610_22745[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (37))){
var inst_22216 = (state_22456[(15)]);
var state_22456__$1 = state_22456;
if(cljs.core.truth_(inst_22216)){
var statearr_22611_22746 = state_22456__$1;
(statearr_22611_22746[(1)] = (42));

} else {
var statearr_22612_22747 = state_22456__$1;
(statearr_22612_22747[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (63))){
var inst_22292 = (state_22456[(17)]);
var state_22456__$1 = state_22456;
var statearr_22613_22748 = state_22456__$1;
(statearr_22613_22748[(2)] = inst_22292);

(statearr_22613_22748[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (94))){
var inst_22403 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
var statearr_22614_22749 = state_22456__$1;
(statearr_22614_22749[(2)] = inst_22403);

(statearr_22614_22749[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (8))){
var inst_22170 = (state_22456[(2)]);
var state_22456__$1 = state_22456;
if(cljs.core.truth_(inst_22170)){
var statearr_22615_22750 = state_22456__$1;
(statearr_22615_22750[(1)] = (9));

} else {
var statearr_22616_22751 = state_22456__$1;
(statearr_22616_22751[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (49))){
var state_22456__$1 = state_22456;
var statearr_22617_22752 = state_22456__$1;
(statearr_22617_22752[(2)] = false);

(statearr_22617_22752[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22457 === (84))){
var inst_22354 = (state_22456[(23)]);
var state_22456__$1 = state_22456;
var statearr_22618_22753 = state_22456__$1;
(statearr_22618_22753[(2)] = inst_22354);

(statearr_22618_22753[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2879__auto__ = null;
var fluree$db$query$fql$state_machine__2879__auto____0 = (function (){
var statearr_22619 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22619[(0)] = fluree$db$query$fql$state_machine__2879__auto__);

(statearr_22619[(1)] = (1));

return statearr_22619;
});
var fluree$db$query$fql$state_machine__2879__auto____1 = (function (state_22456){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_22456);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e22620){var ex__2882__auto__ = e22620;
var statearr_22621_22754 = state_22456;
(statearr_22621_22754[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_22456[(4)]))){
var statearr_22622_22755 = state_22456;
(statearr_22622_22755[(1)] = cljs.core.first((state_22456[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22756 = state_22456;
state_22456 = G__22756;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2879__auto__ = function(state_22456){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2879__auto____1.call(this,state_22456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2879__auto____0;
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2879__auto____1;
return fluree$db$query$fql$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_22623 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_22623[(6)] = c__2901__auto__);

return statearr_22623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel)], 0))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
cljs.core._vreset_BANG_(cache,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_22936){
var state_val_22937 = (state_22936[(1)]);
if((state_val_22937 === (7))){
var inst_22931 = (state_22936[(2)]);
var _ = (function (){var statearr_22938 = state_22936;
(statearr_22938[(4)] = cljs.core.rest((state_22936[(4)])));

return statearr_22938;
})();
var state_22936__$1 = state_22936;
var statearr_22939_23034 = state_22936__$1;
(statearr_22939_23034[(2)] = inst_22931);

(statearr_22939_23034[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (59))){
var inst_22817 = (state_22936[(7)]);
var state_22936__$1 = state_22936;
var statearr_22940_23035 = state_22936__$1;
(statearr_22940_23035[(2)] = inst_22817);

(statearr_22940_23035[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (20))){
var inst_22826 = (state_22936[(8)]);
var inst_22823 = (state_22936[(2)]);
var inst_22824 = fluree.db.util.async.throw_err(inst_22823);
var inst_22825 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_22824);
var inst_22826__$1 = cljs.core.not_empty(inst_22825);
var state_22936__$1 = (function (){var statearr_22941 = state_22936;
(statearr_22941[(8)] = inst_22826__$1);

return statearr_22941;
})();
if(cljs.core.truth_(inst_22826__$1)){
var statearr_22942_23036 = state_22936__$1;
(statearr_22942_23036[(1)] = (21));

} else {
var statearr_22943_23037 = state_22936__$1;
(statearr_22943_23037[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (58))){
var inst_22816 = (state_22936[(9)]);
var state_22936__$1 = state_22936;
var statearr_22944_23038 = state_22936__$1;
(statearr_22944_23038[(2)] = inst_22816);

(statearr_22944_23038[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (60))){
var inst_22923 = (state_22936[(2)]);
var state_22936__$1 = state_22936;
var statearr_22945_23039 = state_22936__$1;
(statearr_22945_23039[(2)] = inst_22923);

(statearr_22945_23039[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (27))){
var inst_22856 = (state_22936[(10)]);
var inst_22848 = (state_22936[(11)]);
var inst_22858 = (state_22936[(12)]);
var inst_22855 = cljs.core.seq(inst_22848);
var inst_22856__$1 = cljs.core.first(inst_22855);
var inst_22857 = cljs.core.next(inst_22855);
var inst_22858__$1 = cljs.core.not(inst_22856__$1);
var state_22936__$1 = (function (){var statearr_22946 = state_22936;
(statearr_22946[(10)] = inst_22856__$1);

(statearr_22946[(12)] = inst_22858__$1);

(statearr_22946[(13)] = inst_22857);

return statearr_22946;
})();
if(inst_22858__$1){
var statearr_22947_23040 = state_22936__$1;
(statearr_22947_23040[(1)] = (29));

} else {
var statearr_22948_23041 = state_22936__$1;
(statearr_22948_23041[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (1))){
var state_22936__$1 = state_22936;
var statearr_22949_23042 = state_22936__$1;
(statearr_22949_23042[(2)] = null);

(statearr_22949_23042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (24))){
var inst_22826 = (state_22936[(8)]);
var inst_22832 = cljs.core.count(inst_22826);
var inst_22833 = fluree.db.query.fql.add_fuel(fuel,inst_22832,max_fuel);
var state_22936__$1 = state_22936;
var statearr_22950_23043 = state_22936__$1;
(statearr_22950_23043[(2)] = inst_22833);

(statearr_22950_23043[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (55))){
var inst_22815 = (state_22936[(14)]);
var state_22936__$1 = state_22936;
var statearr_22951_23044 = state_22936__$1;
(statearr_22951_23044[(2)] = inst_22815);

(statearr_22951_23044[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (39))){
var inst_22813 = (state_22936[(15)]);
var state_22936__$1 = state_22936;
var statearr_22952_23045 = state_22936__$1;
(statearr_22952_23045[(2)] = inst_22813);

(statearr_22952_23045[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (46))){
var inst_22911 = (state_22936[(2)]);
var state_22936__$1 = state_22936;
var statearr_22953_23046 = state_22936__$1;
(statearr_22953_23046[(2)] = inst_22911);

(statearr_22953_23046[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (4))){
var inst_22757 = (state_22936[(2)]);
var state_22936__$1 = state_22936;
var statearr_22954_23047 = state_22936__$1;
(statearr_22954_23047[(2)] = inst_22757);

(statearr_22954_23047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (54))){
var inst_22850 = (state_22936[(16)]);
var inst_22902 = (state_22936[(2)]);
var inst_22903 = fluree.db.util.async.throw_err(inst_22902);
var inst_22904 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_22850,inst_22903);
var state_22936__$1 = state_22936;
var statearr_22955_23048 = state_22936__$1;
(statearr_22955_23048[(2)] = inst_22904);

(statearr_22955_23048[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (15))){
var state_22936__$1 = state_22936;
var statearr_22956_23049 = state_22936__$1;
(statearr_22956_23049[(2)] = false);

(statearr_22956_23049[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (48))){
var inst_22850 = (state_22936[(16)]);
var state_22936__$1 = state_22936;
var statearr_22957_23050 = state_22936__$1;
(statearr_22957_23050[(2)] = inst_22850);

(statearr_22957_23050[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (50))){
var inst_22857 = (state_22936[(13)]);
var inst_22849 = (state_22936[(17)]);
var inst_22906 = (state_22936[(2)]);
var inst_22907 = (inst_22849 + (1));
var inst_22848 = inst_22857;
var inst_22849__$1 = inst_22907;
var inst_22850 = inst_22906;
var state_22936__$1 = (function (){var statearr_22958 = state_22936;
(statearr_22958[(16)] = inst_22850);

(statearr_22958[(11)] = inst_22848);

(statearr_22958[(17)] = inst_22849__$1);

return statearr_22958;
})();
var statearr_22959_23051 = state_22936__$1;
(statearr_22959_23051[(2)] = null);

(statearr_22959_23051[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (21))){
var state_22936__$1 = state_22936;
var statearr_22960_23052 = state_22936__$1;
(statearr_22960_23052[(2)] = fuel);

(statearr_22960_23052[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (31))){
var inst_22867 = (state_22936[(2)]);
var state_22936__$1 = state_22936;
if(cljs.core.truth_(inst_22867)){
var statearr_22961_23053 = state_22936__$1;
(statearr_22961_23053[(1)] = (35));

} else {
var statearr_22962_23054 = state_22936__$1;
(statearr_22962_23054[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (32))){
var inst_22814 = (state_22936[(18)]);
var inst_22849 = (state_22936[(17)]);
var inst_22862 = (inst_22849 >= inst_22814);
var state_22936__$1 = state_22936;
var statearr_22963_23055 = state_22936__$1;
(statearr_22963_23055[(2)] = inst_22862);

(statearr_22963_23055[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (40))){
var inst_22874 = (state_22936[(2)]);
var state_22936__$1 = state_22936;
if(cljs.core.truth_(inst_22874)){
var statearr_22964_23056 = state_22936__$1;
(statearr_22964_23056[(1)] = (41));

} else {
var statearr_22965_23057 = state_22936__$1;
(statearr_22965_23057[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (56))){
var inst_22816 = (state_22936[(9)]);
var state_22936__$1 = state_22936;
if(cljs.core.truth_(inst_22816)){
var statearr_22966_23058 = state_22936__$1;
(statearr_22966_23058[(1)] = (58));

} else {
var statearr_22967_23059 = state_22936__$1;
(statearr_22967_23059[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (33))){
var inst_22814 = (state_22936[(18)]);
var state_22936__$1 = state_22936;
var statearr_22968_23060 = state_22936__$1;
(statearr_22968_23060[(2)] = inst_22814);

(statearr_22968_23060[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (13))){
var inst_22807 = (state_22936[(2)]);
var state_22936__$1 = state_22936;
if(cljs.core.truth_(inst_22807)){
var statearr_22969_23061 = state_22936__$1;
(statearr_22969_23061[(1)] = (17));

} else {
var statearr_22970_23062 = state_22936__$1;
(statearr_22970_23062[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (22))){
var inst_22826 = (state_22936[(8)]);
var state_22936__$1 = state_22936;
var statearr_22972_23063 = state_22936__$1;
(statearr_22972_23063[(2)] = inst_22826);

(statearr_22972_23063[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (36))){
var inst_22813 = (state_22936[(15)]);
var state_22936__$1 = state_22936;
if(cljs.core.truth_(inst_22813)){
var statearr_22973_23064 = state_22936__$1;
(statearr_22973_23064[(1)] = (38));

} else {
var statearr_22974_23065 = state_22936__$1;
(statearr_22974_23065[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (41))){
var inst_22850 = (state_22936[(16)]);
var inst_22857 = (state_22936[(13)]);
var inst_22849 = (state_22936[(17)]);
var inst_22876 = (inst_22849 + (1));
var tmp22971 = inst_22850;
var inst_22848 = inst_22857;
var inst_22849__$1 = inst_22876;
var inst_22850__$1 = tmp22971;
var state_22936__$1 = (function (){var statearr_22975 = state_22936;
(statearr_22975[(16)] = inst_22850__$1);

(statearr_22975[(11)] = inst_22848);

(statearr_22975[(17)] = inst_22849__$1);

return statearr_22975;
})();
var statearr_22976_23066 = state_22936__$1;
(statearr_22976_23066[(2)] = null);

(statearr_22976_23066[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (43))){
var inst_22913 = (state_22936[(2)]);
var state_22936__$1 = state_22936;
var statearr_22977_23067 = state_22936__$1;
(statearr_22977_23067[(2)] = inst_22913);

(statearr_22977_23067[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (29))){
var inst_22858 = (state_22936[(12)]);
var state_22936__$1 = state_22936;
var statearr_22978_23068 = state_22936__$1;
(statearr_22978_23068[(2)] = inst_22858);

(statearr_22978_23068[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (44))){
var inst_22856 = (state_22936[(10)]);
var inst_22880 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22881 = [inst_22856];
var inst_22882 = (new cljs.core.PersistentVector(null,1,(5),inst_22880,inst_22881,null));
var inst_22883 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22882);
var state_22936__$1 = state_22936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22936__$1,(47),inst_22883);
} else {
if((state_val_22937 === (6))){
var inst_22781 = (state_22936[(19)]);
var inst_22774 = (state_22936[(20)]);
var inst_22780 = cljs.core.seq(inst_22774);
var inst_22781__$1 = cljs.core.first(inst_22780);
var inst_22782 = cljs.core.next(inst_22780);
var inst_22783 = cljs.core.not(inst_22781__$1);
var state_22936__$1 = (function (){var statearr_22979 = state_22936;
(statearr_22979[(21)] = inst_22782);

(statearr_22979[(19)] = inst_22781__$1);

return statearr_22979;
})();
if(inst_22783){
var statearr_22980_23069 = state_22936__$1;
(statearr_22980_23069[(1)] = (8));

} else {
var statearr_22981_23070 = state_22936__$1;
(statearr_22981_23070[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (28))){
var inst_22815 = (state_22936[(14)]);
var inst_22917 = (state_22936[(2)]);
var state_22936__$1 = (function (){var statearr_22982 = state_22936;
(statearr_22982[(22)] = inst_22917);

return statearr_22982;
})();
if(cljs.core.truth_(inst_22815)){
var statearr_22983_23071 = state_22936__$1;
(statearr_22983_23071[(1)] = (55));

} else {
var statearr_22984_23072 = state_22936__$1;
(statearr_22984_23072[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (51))){
var inst_22886 = (state_22936[(23)]);
var inst_22895 = cljs.core.count(inst_22886);
var inst_22896 = fluree.db.query.fql.add_fuel(fuel,inst_22895,max_fuel);
var state_22936__$1 = state_22936;
var statearr_22985_23073 = state_22936__$1;
(statearr_22985_23073[(2)] = inst_22896);

(statearr_22985_23073[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (25))){
var state_22936__$1 = state_22936;
var statearr_22986_23074 = state_22936__$1;
(statearr_22986_23074[(2)] = null);

(statearr_22986_23074[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (34))){
var inst_22865 = (state_22936[(2)]);
var state_22936__$1 = state_22936;
var statearr_22987_23075 = state_22936__$1;
(statearr_22987_23075[(2)] = inst_22865);

(statearr_22987_23075[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (17))){
var inst_22791 = (state_22936[(24)]);
var inst_22809 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_22791);
var state_22936__$1 = state_22936;
var statearr_22988_23076 = state_22936__$1;
(statearr_22988_23076[(2)] = inst_22809);

(statearr_22988_23076[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (3))){
var inst_22934 = (state_22936[(2)]);
var state_22936__$1 = state_22936;
return cljs.core.async.impl.ioc_helpers.return_chan(state_22936__$1,inst_22934);
} else {
if((state_val_22937 === (12))){
var state_22936__$1 = state_22936;
var statearr_22989_23077 = state_22936__$1;
(statearr_22989_23077[(2)] = false);

(statearr_22989_23077[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (2))){
var _ = (function (){var statearr_22990 = state_22936;
(statearr_22990[(4)] = cljs.core.cons((5),(state_22936[(4)])));

return statearr_22990;
})();
var inst_22770 = reverse_refs_specs;
var inst_22771 = cljs.core.seq(inst_22770);
var inst_22772 = cljs.core.first(inst_22771);
var inst_22773 = cljs.core.next(inst_22771);
var inst_22774 = inst_22770;
var inst_22775 = null;
var state_22936__$1 = (function (){var statearr_22991 = state_22936;
(statearr_22991[(25)] = inst_22773);

(statearr_22991[(26)] = inst_22775);

(statearr_22991[(20)] = inst_22774);

(statearr_22991[(27)] = inst_22772);

return statearr_22991;
})();
var statearr_22992_23078 = state_22936__$1;
(statearr_22992_23078[(2)] = null);

(statearr_22992_23078[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (23))){
var inst_22830 = (state_22936[(2)]);
var state_22936__$1 = state_22936;
if(cljs.core.truth_(inst_22830)){
var statearr_22993_23079 = state_22936__$1;
(statearr_22993_23079[(1)] = (24));

} else {
var statearr_22994_23080 = state_22936__$1;
(statearr_22994_23080[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (47))){
var inst_22791 = (state_22936[(24)]);
var inst_22886 = (state_22936[(23)]);
var inst_22885 = (state_22936[(2)]);
var inst_22886__$1 = fluree.db.util.async.throw_err(inst_22885);
var inst_22887 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22888 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22889 = (new cljs.core.PersistentVector(null,4,(5),inst_22887,inst_22888,null));
var inst_22890 = cljs.core.select_keys(inst_22791,inst_22889);
var inst_22891 = cljs.core.empty_QMARK_(inst_22886__$1);
var state_22936__$1 = (function (){var statearr_22995 = state_22936;
(statearr_22995[(23)] = inst_22886__$1);

(statearr_22995[(28)] = inst_22890);

return statearr_22995;
})();
if(inst_22891){
var statearr_22996_23081 = state_22936__$1;
(statearr_22996_23081[(1)] = (48));

} else {
var statearr_22997_23082 = state_22936__$1;
(statearr_22997_23082[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (35))){
var inst_22850 = (state_22936[(16)]);
var state_22936__$1 = state_22936;
var statearr_22998_23083 = state_22936__$1;
(statearr_22998_23083[(2)] = inst_22850);

(statearr_22998_23083[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (19))){
var inst_22790 = (state_22936[(29)]);
var inst_22812 = (state_22936[(2)]);
var inst_22813 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22812,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22814 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22812,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22815 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22812,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_22816 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22812,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_22817 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_22812,new cljs.core.Keyword(null,"p","p",151049309));
var inst_22818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22819 = [subject_id,inst_22790];
var inst_22820 = (new cljs.core.PersistentVector(null,2,(5),inst_22818,inst_22819,null));
var inst_22821 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_22820);
var state_22936__$1 = (function (){var statearr_22999 = state_22936;
(statearr_22999[(15)] = inst_22813);

(statearr_22999[(9)] = inst_22816);

(statearr_22999[(14)] = inst_22815);

(statearr_22999[(7)] = inst_22817);

(statearr_22999[(18)] = inst_22814);

return statearr_22999;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22936__$1,(20),inst_22821);
} else {
if((state_val_22937 === (57))){
var inst_22782 = (state_22936[(21)]);
var inst_22917 = (state_22936[(22)]);
var inst_22775 = (state_22936[(26)]);
var inst_22925 = (state_22936[(2)]);
var inst_22926 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_22775,inst_22925,inst_22917);
var inst_22774 = inst_22782;
var inst_22775__$1 = inst_22926;
var state_22936__$1 = (function (){var statearr_23000 = state_22936;
(statearr_23000[(26)] = inst_22775__$1);

(statearr_23000[(20)] = inst_22774);

return statearr_23000;
})();
var statearr_23001_23084 = state_22936__$1;
(statearr_23001_23084[(2)] = null);

(statearr_23001_23084[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (11))){
var inst_22791 = (state_22936[(24)]);
var inst_22796 = inst_22791.cljs$lang$protocol_mask$partition0$;
var inst_22797 = (inst_22796 & (64));
var inst_22798 = inst_22791.cljs$core$ISeq$;
var inst_22799 = (cljs.core.PROTOCOL_SENTINEL === inst_22798);
var inst_22800 = ((inst_22797) || (inst_22799));
var state_22936__$1 = state_22936;
if(cljs.core.truth_(inst_22800)){
var statearr_23003_23085 = state_22936__$1;
(statearr_23003_23085[(1)] = (14));

} else {
var statearr_23004_23086 = state_22936__$1;
(statearr_23004_23086[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (9))){
var inst_22781 = (state_22936[(19)]);
var inst_22791 = (state_22936[(24)]);
var inst_22790 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22781,(0),null);
var inst_22791__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_22781,(1),null);
var inst_22793 = (inst_22791__$1 == null);
var inst_22794 = cljs.core.not(inst_22793);
var state_22936__$1 = (function (){var statearr_23005 = state_22936;
(statearr_23005[(24)] = inst_22791__$1);

(statearr_23005[(29)] = inst_22790);

return statearr_23005;
})();
if(inst_22794){
var statearr_23006_23087 = state_22936__$1;
(statearr_23006_23087[(1)] = (11));

} else {
var statearr_23007_23088 = state_22936__$1;
(statearr_23007_23088[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (5))){
var _ = (function (){var statearr_23008 = state_22936;
(statearr_23008[(4)] = cljs.core.rest((state_22936[(4)])));

return statearr_23008;
})();
var state_22936__$1 = state_22936;
var ex23002 = (state_22936__$1[(2)]);
var statearr_23009_23089 = state_22936__$1;
(statearr_23009_23089[(5)] = ex23002);


if((ex23002 instanceof Error)){
var statearr_23010_23090 = state_22936__$1;
(statearr_23010_23090[(1)] = (4));

(statearr_23010_23090[(5)] = null);

} else {
throw ex23002;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (14))){
var state_22936__$1 = state_22936;
var statearr_23011_23091 = state_22936__$1;
(statearr_23011_23091[(2)] = true);

(statearr_23011_23091[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (45))){
var state_22936__$1 = state_22936;
var statearr_23012_23092 = state_22936__$1;
(statearr_23012_23092[(2)] = null);

(statearr_23012_23092[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (53))){
var inst_22886 = (state_22936[(23)]);
var inst_22890 = (state_22936[(28)]);
var inst_22899 = (state_22936[(2)]);
var inst_22900 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_22890,inst_22886) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22890,inst_22886));
var state_22936__$1 = (function (){var statearr_23013 = state_22936;
(statearr_23013[(30)] = inst_22899);

return statearr_23013;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_22936__$1,(54),inst_22900);
} else {
if((state_val_22937 === (26))){
var inst_22826 = (state_22936[(8)]);
var inst_22836 = (state_22936[(2)]);
var inst_22844 = cljs.core.seq(inst_22826);
var inst_22845 = cljs.core.first(inst_22844);
var inst_22846 = cljs.core.next(inst_22844);
var inst_22847 = cljs.core.PersistentVector.EMPTY;
var inst_22848 = inst_22826;
var inst_22849 = (0);
var inst_22850 = inst_22847;
var state_22936__$1 = (function (){var statearr_23014 = state_22936;
(statearr_23014[(16)] = inst_22850);

(statearr_23014[(31)] = inst_22846);

(statearr_23014[(32)] = inst_22836);

(statearr_23014[(33)] = inst_22845);

(statearr_23014[(11)] = inst_22848);

(statearr_23014[(17)] = inst_22849);

return statearr_23014;
})();
var statearr_23015_23093 = state_22936__$1;
(statearr_23015_23093[(2)] = null);

(statearr_23015_23093[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (16))){
var inst_22804 = (state_22936[(2)]);
var state_22936__$1 = state_22936;
var statearr_23016_23094 = state_22936__$1;
(statearr_23016_23094[(2)] = inst_22804);

(statearr_23016_23094[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (38))){
var inst_22813 = (state_22936[(15)]);
var inst_22849 = (state_22936[(17)]);
var inst_22871 = (inst_22849 < inst_22813);
var state_22936__$1 = state_22936;
var statearr_23017_23095 = state_22936__$1;
(statearr_23017_23095[(2)] = inst_22871);

(statearr_23017_23095[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (30))){
var inst_22814 = (state_22936[(18)]);
var state_22936__$1 = state_22936;
if(cljs.core.truth_(inst_22814)){
var statearr_23018_23096 = state_22936__$1;
(statearr_23018_23096[(1)] = (32));

} else {
var statearr_23019_23097 = state_22936__$1;
(statearr_23019_23097[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (10))){
var inst_22929 = (state_22936[(2)]);
var state_22936__$1 = state_22936;
var statearr_23020_23098 = state_22936__$1;
(statearr_23020_23098[(2)] = inst_22929);

(statearr_23020_23098[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (18))){
var inst_22791 = (state_22936[(24)]);
var state_22936__$1 = state_22936;
var statearr_23021_23099 = state_22936__$1;
(statearr_23021_23099[(2)] = inst_22791);

(statearr_23021_23099[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (52))){
var state_22936__$1 = state_22936;
var statearr_23022_23100 = state_22936__$1;
(statearr_23022_23100[(2)] = null);

(statearr_23022_23100[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (42))){
var state_22936__$1 = state_22936;
var statearr_23023_23101 = state_22936__$1;
(statearr_23023_23101[(1)] = (44));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (37))){
var inst_22915 = (state_22936[(2)]);
var state_22936__$1 = state_22936;
var statearr_23025_23102 = state_22936__$1;
(statearr_23025_23102[(2)] = inst_22915);

(statearr_23025_23102[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (8))){
var inst_22775 = (state_22936[(26)]);
var state_22936__$1 = state_22936;
var statearr_23026_23103 = state_22936__$1;
(statearr_23026_23103[(2)] = inst_22775);

(statearr_23026_23103[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22937 === (49))){
var state_22936__$1 = state_22936;
if(cljs.core.truth_(fuel)){
var statearr_23027_23104 = state_22936__$1;
(statearr_23027_23104[(1)] = (51));

} else {
var statearr_23028_23105 = state_22936__$1;
(statearr_23028_23105[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto____0 = (function (){
var statearr_23029 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23029[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto__);

(statearr_23029[(1)] = (1));

return statearr_23029;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto____1 = (function (state_22936){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_22936);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e23030){var ex__2882__auto__ = e23030;
var statearr_23031_23106 = state_22936;
(statearr_23031_23106[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_22936[(4)]))){
var statearr_23032_23107 = state_22936;
(statearr_23032_23107[(1)] = cljs.core.first((state_22936[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23108 = state_22936;
state_22936 = G__23108;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto__ = function(state_22936){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto____1.call(this,state_22936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_23033 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_23033[(6)] = c__2901__auto__);

return statearr_23033;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__23109 = select_spec;
var map__23109__$1 = (((((!((map__23109 == null))))?(((((map__23109.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23109.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23109):map__23109);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23109__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23109__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flake,select_spec,acc,fuel,max_fuel,cache){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_23192){
var state_val_23193 = (state_23192[(1)]);
if((state_val_23193 === (7))){
var state_23192__$1 = state_23192;
var statearr_23194_23246 = state_23192__$1;
(statearr_23194_23246[(2)] = false);

(statearr_23194_23246[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (20))){
var inst_23148 = (state_23192[(7)]);
var state_23192__$1 = state_23192;
if(cljs.core.truth_(inst_23148)){
var statearr_23195_23247 = state_23192__$1;
(statearr_23195_23247[(1)] = (22));

} else {
var statearr_23196_23248 = state_23192__$1;
(statearr_23196_23248[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (27))){
var inst_23171 = (state_23192[(8)]);
var inst_23177 = (state_23192[(2)]);
var state_23192__$1 = (function (){var statearr_23197 = state_23192;
(statearr_23197[(9)] = inst_23177);

return statearr_23197;
})();
if(cljs.core.truth_(inst_23171)){
var statearr_23198_23249 = state_23192__$1;
(statearr_23198_23249[(1)] = (28));

} else {
var statearr_23199_23250 = state_23192__$1;
(statearr_23199_23250[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (1))){
var state_23192__$1 = state_23192;
var statearr_23200_23251 = state_23192__$1;
(statearr_23200_23251[(2)] = null);

(statearr_23200_23251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (24))){
var inst_23169 = (state_23192[(2)]);
var state_23192__$1 = state_23192;
var statearr_23201_23252 = state_23192__$1;
(statearr_23201_23252[(2)] = inst_23169);

(statearr_23201_23252[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (4))){
var inst_23111 = (state_23192[(2)]);
var state_23192__$1 = state_23192;
var statearr_23202_23253 = state_23192__$1;
(statearr_23202_23253[(2)] = inst_23111);

(statearr_23202_23253[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (15))){
var inst_23155 = (state_23192[(2)]);
var inst_23156 = fluree.db.util.async.throw_err(inst_23155);
var state_23192__$1 = (function (){var statearr_23203 = state_23192;
(statearr_23203[(10)] = inst_23156);

return statearr_23203;
})();
if(cljs.core.truth_(fuel)){
var statearr_23204_23254 = state_23192__$1;
(statearr_23204_23254[(1)] = (16));

} else {
var statearr_23205_23255 = state_23192__$1;
(statearr_23205_23255[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (21))){
var inst_23141 = (state_23192[(11)]);
var inst_23171 = (state_23192[(2)]);
var state_23192__$1 = (function (){var statearr_23206 = state_23192;
(statearr_23206[(8)] = inst_23171);

return statearr_23206;
})();
if(cljs.core.truth_(inst_23141)){
var statearr_23207_23256 = state_23192__$1;
(statearr_23207_23256[(1)] = (25));

} else {
var statearr_23208_23257 = state_23192__$1;
(statearr_23208_23257[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (31))){
var inst_23177 = (state_23192[(9)]);
var inst_23142 = (state_23192[(12)]);
var inst_23183 = (state_23192[(2)]);
var inst_23184 = fluree.db.util.async.throw_err(inst_23183);
var inst_23185 = (inst_23177.cljs$core$IFn$_invoke$arity$3 ? inst_23177.cljs$core$IFn$_invoke$arity$3(acc,inst_23142,inst_23184) : inst_23177.call(null,acc,inst_23142,inst_23184));
var state_23192__$1 = state_23192;
var statearr_23209_23258 = state_23192__$1;
(statearr_23209_23258[(2)] = inst_23185);

(statearr_23209_23258[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (13))){
var inst_23119 = (state_23192[(13)]);
var state_23192__$1 = state_23192;
var statearr_23210_23259 = state_23192__$1;
(statearr_23210_23259[(2)] = inst_23119);

(statearr_23210_23259[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (22))){
var inst_23148 = (state_23192[(7)]);
var state_23192__$1 = state_23192;
var statearr_23211_23260 = state_23192__$1;
(statearr_23211_23260[(2)] = inst_23148);

(statearr_23211_23260[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (29))){
var inst_23162 = (state_23192[(14)]);
var inst_23180 = fluree.db.query.fql.recur_select_spec(select_spec,flake);
var inst_23181 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_23180,inst_23162) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23180,inst_23162));
var state_23192__$1 = state_23192;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23192__$1,(31),inst_23181);
} else {
if((state_val_23193 === (6))){
var inst_23119 = (state_23192[(13)]);
var inst_23124 = inst_23119.cljs$lang$protocol_mask$partition0$;
var inst_23125 = (inst_23124 & (64));
var inst_23126 = inst_23119.cljs$core$ISeq$;
var inst_23127 = (cljs.core.PROTOCOL_SENTINEL === inst_23126);
var inst_23128 = ((inst_23125) || (inst_23127));
var state_23192__$1 = state_23192;
if(cljs.core.truth_(inst_23128)){
var statearr_23212_23261 = state_23192__$1;
(statearr_23212_23261[(1)] = (9));

} else {
var statearr_23213_23262 = state_23192__$1;
(statearr_23213_23262[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (28))){
var state_23192__$1 = state_23192;
var statearr_23214_23263 = state_23192__$1;
(statearr_23214_23263[(2)] = acc);

(statearr_23214_23263[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (25))){
var inst_23144 = (state_23192[(15)]);
var inst_23148 = (state_23192[(7)]);
var inst_23171 = (state_23192[(8)]);
var inst_23162 = (state_23192[(14)]);
var inst_23118 = (state_23192[(16)]);
var inst_23145 = (state_23192[(17)]);
var inst_23142 = (state_23192[(12)]);
var inst_23140 = (state_23192[(18)]);
var inst_23147 = (state_23192[(19)]);
var inst_23141 = (state_23192[(11)]);
var inst_23146 = (state_23192[(20)]);
var inst_23143 = (state_23192[(21)]);
var inst_23173 = (function (){var recur_seen = inst_23144;
var map__23117 = inst_23140;
var recur_subject = inst_23118;
var sub_flakes = inst_23162;
var seen_QMARK_ = inst_23147;
var multi_QMARK_ = inst_23141;
var limit = inst_23146;
var recur_depth = inst_23145;
var as = inst_23142;
var max_depth_QMARK_ = inst_23148;
var recur = inst_23143;
var stop_QMARK_ = inst_23171;
return (function (results,as__$1,new_result){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(results,as__$1,fluree.db.query.fql.conjv,new_result);
});
})();
var state_23192__$1 = state_23192;
var statearr_23215_23264 = state_23192__$1;
(statearr_23215_23264[(2)] = inst_23173);

(statearr_23215_23264[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (17))){
var inst_23156 = (state_23192[(10)]);
var state_23192__$1 = state_23192;
var statearr_23216_23265 = state_23192__$1;
(statearr_23216_23265[(2)] = inst_23156);

(statearr_23216_23265[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (3))){
var inst_23190 = (state_23192[(2)]);
var state_23192__$1 = state_23192;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23192__$1,inst_23190);
} else {
if((state_val_23193 === (12))){
var inst_23119 = (state_23192[(13)]);
var inst_23137 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_23119);
var state_23192__$1 = state_23192;
var statearr_23217_23266 = state_23192__$1;
(statearr_23217_23266[(2)] = inst_23137);

(statearr_23217_23266[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (2))){
var inst_23119 = (state_23192[(13)]);
var _ = (function (){var statearr_23218 = state_23192;
(statearr_23218[(4)] = cljs.core.cons((5),(state_23192[(4)])));

return statearr_23218;
})();
var inst_23118 = flake.o;
var inst_23119__$1 = select_spec;
var inst_23121 = (inst_23119__$1 == null);
var inst_23122 = cljs.core.not(inst_23121);
var state_23192__$1 = (function (){var statearr_23219 = state_23192;
(statearr_23219[(16)] = inst_23118);

(statearr_23219[(13)] = inst_23119__$1);

return statearr_23219;
})();
if(inst_23122){
var statearr_23220_23267 = state_23192__$1;
(statearr_23220_23267[(1)] = (6));

} else {
var statearr_23221_23268 = state_23192__$1;
(statearr_23221_23268[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (23))){
var inst_23162 = (state_23192[(14)]);
var inst_23167 = cljs.core.empty_QMARK_(inst_23162);
var state_23192__$1 = state_23192;
var statearr_23222_23269 = state_23192__$1;
(statearr_23222_23269[(2)] = inst_23167);

(statearr_23222_23269[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (19))){
var inst_23147 = (state_23192[(19)]);
var state_23192__$1 = state_23192;
var statearr_23223_23270 = state_23192__$1;
(statearr_23223_23270[(2)] = inst_23147);

(statearr_23223_23270[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (11))){
var inst_23132 = (state_23192[(2)]);
var state_23192__$1 = state_23192;
var statearr_23225_23271 = state_23192__$1;
(statearr_23225_23271[(2)] = inst_23132);

(statearr_23225_23271[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (9))){
var state_23192__$1 = state_23192;
var statearr_23226_23272 = state_23192__$1;
(statearr_23226_23272[(2)] = true);

(statearr_23226_23272[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (5))){
var _ = (function (){var statearr_23227 = state_23192;
(statearr_23227[(4)] = cljs.core.rest((state_23192[(4)])));

return statearr_23227;
})();
var state_23192__$1 = state_23192;
var ex23224 = (state_23192__$1[(2)]);
var statearr_23228_23273 = state_23192__$1;
(statearr_23228_23273[(5)] = ex23224);


if((ex23224 instanceof Error)){
var statearr_23229_23274 = state_23192__$1;
(statearr_23229_23274[(1)] = (4));

(statearr_23229_23274[(5)] = null);

} else {
throw ex23224;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (14))){
var inst_23144 = (state_23192[(15)]);
var inst_23118 = (state_23192[(16)]);
var inst_23145 = (state_23192[(17)]);
var inst_23140 = (state_23192[(18)]);
var inst_23143 = (state_23192[(21)]);
var inst_23140__$1 = (state_23192[(2)]);
var inst_23141 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23140__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_23142 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23140__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_23143__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23140__$1,new cljs.core.Keyword(null,"recur","recur",-437573268));
var inst_23144__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23140__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_23145__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23140__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_23146 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_23140__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_23147 = cljs.core.contains_QMARK_(inst_23144__$1,inst_23118);
var inst_23148 = (inst_23145__$1 > inst_23143__$1);
var inst_23150 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23151 = [inst_23118];
var inst_23152 = (new cljs.core.PersistentVector(null,1,(5),inst_23150,inst_23151,null));
var inst_23153 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23152);
var state_23192__$1 = (function (){var statearr_23230 = state_23192;
(statearr_23230[(15)] = inst_23144__$1);

(statearr_23230[(7)] = inst_23148);

(statearr_23230[(17)] = inst_23145__$1);

(statearr_23230[(12)] = inst_23142);

(statearr_23230[(18)] = inst_23140__$1);

(statearr_23230[(19)] = inst_23147);

(statearr_23230[(11)] = inst_23141);

(statearr_23230[(20)] = inst_23146);

(statearr_23230[(21)] = inst_23143__$1);

return statearr_23230;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23192__$1,(15),inst_23153);
} else {
if((state_val_23193 === (26))){
var inst_23144 = (state_23192[(15)]);
var inst_23148 = (state_23192[(7)]);
var inst_23171 = (state_23192[(8)]);
var inst_23162 = (state_23192[(14)]);
var inst_23118 = (state_23192[(16)]);
var inst_23145 = (state_23192[(17)]);
var inst_23142 = (state_23192[(12)]);
var inst_23140 = (state_23192[(18)]);
var inst_23147 = (state_23192[(19)]);
var inst_23141 = (state_23192[(11)]);
var inst_23146 = (state_23192[(20)]);
var inst_23143 = (state_23192[(21)]);
var inst_23175 = (function (){var recur_seen = inst_23144;
var map__23117 = inst_23140;
var recur_subject = inst_23118;
var sub_flakes = inst_23162;
var seen_QMARK_ = inst_23147;
var multi_QMARK_ = inst_23141;
var limit = inst_23146;
var recur_depth = inst_23145;
var as = inst_23142;
var max_depth_QMARK_ = inst_23148;
var recur = inst_23143;
var stop_QMARK_ = inst_23171;
return (function (results,as__$1,new_result){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,as__$1,new_result);
});
})();
var state_23192__$1 = state_23192;
var statearr_23231_23275 = state_23192__$1;
(statearr_23231_23275[(2)] = inst_23175);

(statearr_23231_23275[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (16))){
var inst_23156 = (state_23192[(10)]);
var inst_23158 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_23159 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_23158,inst_23156);
var state_23192__$1 = state_23192;
var statearr_23232_23276 = state_23192__$1;
(statearr_23232_23276[(2)] = inst_23159);

(statearr_23232_23276[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (30))){
var inst_23187 = (state_23192[(2)]);
var _ = (function (){var statearr_23233 = state_23192;
(statearr_23233[(4)] = cljs.core.rest((state_23192[(4)])));

return statearr_23233;
})();
var state_23192__$1 = state_23192;
var statearr_23234_23277 = state_23192__$1;
(statearr_23234_23277[(2)] = inst_23187);

(statearr_23234_23277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (10))){
var state_23192__$1 = state_23192;
var statearr_23235_23278 = state_23192__$1;
(statearr_23235_23278[(2)] = false);

(statearr_23235_23278[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (18))){
var inst_23147 = (state_23192[(19)]);
var inst_23162 = (state_23192[(2)]);
var state_23192__$1 = (function (){var statearr_23236 = state_23192;
(statearr_23236[(14)] = inst_23162);

return statearr_23236;
})();
if(cljs.core.truth_(inst_23147)){
var statearr_23237_23279 = state_23192__$1;
(statearr_23237_23279[(1)] = (19));

} else {
var statearr_23238_23280 = state_23192__$1;
(statearr_23238_23280[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23193 === (8))){
var inst_23135 = (state_23192[(2)]);
var state_23192__$1 = state_23192;
if(cljs.core.truth_(inst_23135)){
var statearr_23239_23281 = state_23192__$1;
(statearr_23239_23281[(1)] = (12));

} else {
var statearr_23240_23282 = state_23192__$1;
(statearr_23240_23282[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto____0 = (function (){
var statearr_23241 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23241[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto__);

(statearr_23241[(1)] = (1));

return statearr_23241;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto____1 = (function (state_23192){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_23192);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e23242){var ex__2882__auto__ = e23242;
var statearr_23243_23283 = state_23192;
(statearr_23243_23283[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_23192[(4)]))){
var statearr_23244_23284 = state_23192;
(statearr_23244_23284[(1)] = cljs.core.first((state_23192[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23285 = state_23192;
state_23192 = G__23285;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto__ = function(state_23192){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto____1.call(this,state_23192);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_23245 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_23245[(6)] = c__2901__auto__);

return statearr_23245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_23463){
var state_val_23464 = (state_23463[(1)]);
if((state_val_23464 === (7))){
var state_23463__$1 = state_23463;
var statearr_23465_23550 = state_23463__$1;
(statearr_23465_23550[(2)] = null);

(statearr_23465_23550[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (20))){
var inst_23324 = cljs.core.PersistentHashMap.EMPTY;
var state_23463__$1 = state_23463;
var statearr_23466_23551 = state_23463__$1;
(statearr_23466_23551[(2)] = inst_23324);

(statearr_23466_23551[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (27))){
var inst_23342 = (state_23463[(7)]);
var inst_23312 = (state_23463[(8)]);
var inst_23306 = (state_23463[(9)]);
var inst_23326 = (state_23463[(10)]);
var inst_23442 = (state_23463[(2)]);
var inst_23443 = (function (){var top_level_subject = inst_23306;
var select_spec = inst_23312;
var base_acc = inst_23326;
var acc_PLUS_refs = inst_23342;
var result = inst_23442;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4126__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23444 = cljs.core.PersistentVector.EMPTY;
var inst_23445 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23312);
var inst_23446 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23445);
var inst_23447 = cljs.core.vals(inst_23446);
var inst_23448 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23312);
var inst_23449 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23448);
var inst_23450 = cljs.core.vals(inst_23449);
var inst_23451 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_23447,inst_23450);
var inst_23452 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23443,inst_23444,inst_23451);
var inst_23454 = (function (){var top_level_subject = inst_23306;
var select_spec = inst_23312;
var base_acc = inst_23326;
var acc_PLUS_refs = inst_23342;
var result = inst_23442;
var sort_preds = inst_23452;
return (function (acc,p__23453){
var vec__23467 = p__23453;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23467,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23467,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23467,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23467,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_23455 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_23454,inst_23442,inst_23452);
var state_23463__$1 = state_23463;
var statearr_23470_23552 = state_23463__$1;
(statearr_23470_23552[(2)] = inst_23455);

(statearr_23470_23552[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (1))){
var state_23463__$1 = state_23463;
var statearr_23471_23553 = state_23463__$1;
(statearr_23471_23553[(2)] = null);

(statearr_23471_23553[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (24))){
var inst_23342 = (state_23463[(7)]);
var inst_23342__$1 = (state_23463[(2)]);
var inst_23343 = flakes;
var inst_23344 = cljs.core.PersistentHashMap.EMPTY;
var inst_23345 = inst_23343;
var inst_23346 = inst_23342__$1;
var inst_23347 = inst_23344;
var state_23463__$1 = (function (){var statearr_23472 = state_23463;
(statearr_23472[(7)] = inst_23342__$1);

(statearr_23472[(11)] = inst_23345);

(statearr_23472[(12)] = inst_23347);

(statearr_23472[(13)] = inst_23346);

return statearr_23472;
})();
var statearr_23473_23554 = state_23463__$1;
(statearr_23473_23554[(2)] = null);

(statearr_23473_23554[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (39))){
var inst_23312 = (state_23463[(8)]);
var inst_23355 = (state_23463[(14)]);
var inst_23361 = (state_23463[(15)]);
var inst_23346 = (state_23463[(13)]);
var inst_23390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23391 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_23346,inst_23312,inst_23355,inst_23361,false);
var state_23463__$1 = (function (){var statearr_23474 = state_23463;
(statearr_23474[(16)] = inst_23390);

return statearr_23474;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23463__$1,(42),inst_23391);
} else {
if((state_val_23464 === (46))){
var inst_23355 = (state_23463[(14)]);
var inst_23345 = (state_23463[(11)]);
var inst_23347 = (state_23463[(12)]);
var inst_23408 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23409 = ["_id"];
var inst_23410 = inst_23355.s;
var inst_23411 = [inst_23410];
var inst_23412 = cljs.core.PersistentHashMap.fromArrays(inst_23409,inst_23411);
var inst_23413 = cljs.core.rest(inst_23345);
var inst_23414 = [inst_23412,inst_23413,inst_23347];
var inst_23415 = (new cljs.core.PersistentVector(null,3,(5),inst_23408,inst_23414,null));
var state_23463__$1 = state_23463;
var statearr_23475_23555 = state_23463__$1;
(statearr_23475_23555[(2)] = inst_23415);

(statearr_23475_23555[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (4))){
var inst_23286 = (state_23463[(2)]);
var state_23463__$1 = state_23463;
var statearr_23476_23556 = state_23463__$1;
(statearr_23476_23556[(2)] = inst_23286);

(statearr_23476_23556[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (15))){
var inst_23313 = (state_23463[(17)]);
var inst_23312 = (state_23463[(8)]);
var inst_23312__$1 = (state_23463[(2)]);
var inst_23313__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23312__$1);
var state_23463__$1 = (function (){var statearr_23477 = state_23463;
(statearr_23477[(17)] = inst_23313__$1);

(statearr_23477[(8)] = inst_23312__$1);

return statearr_23477;
})();
if(cljs.core.truth_(inst_23313__$1)){
var statearr_23478_23557 = state_23463__$1;
(statearr_23478_23557[(1)] = (16));

} else {
var statearr_23479_23558 = state_23463__$1;
(statearr_23479_23558[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (48))){
var inst_23426 = (state_23463[(2)]);
var state_23463__$1 = state_23463;
var statearr_23480_23559 = state_23463__$1;
(statearr_23480_23559[(2)] = inst_23426);

(statearr_23480_23559[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (50))){
var state_23463__$1 = state_23463;
var statearr_23481_23560 = state_23463__$1;
(statearr_23481_23560[(2)] = null);

(statearr_23481_23560[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (21))){
var inst_23312 = (state_23463[(8)]);
var inst_23326 = (state_23463[(2)]);
var inst_23327 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23328 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23329 = (new cljs.core.PersistentVector(null,2,(5),inst_23327,inst_23328,null));
var inst_23330 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23312,inst_23329);
var state_23463__$1 = (function (){var statearr_23482 = state_23463;
(statearr_23482[(10)] = inst_23326);

return statearr_23482;
})();
if(cljs.core.truth_(inst_23330)){
var statearr_23483_23561 = state_23463__$1;
(statearr_23483_23561[(1)] = (22));

} else {
var statearr_23484_23562 = state_23463__$1;
(statearr_23484_23562[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (31))){
var inst_23355 = (state_23463[(14)]);
var inst_23360 = (state_23463[(18)]);
var inst_23346 = (state_23463[(13)]);
var inst_23364 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23365 = fluree.db.query.fql.flake__GT_recur(db,inst_23355,inst_23360,inst_23346,fuel,max_fuel,cache);
var state_23463__$1 = (function (){var statearr_23485 = state_23463;
(statearr_23485[(19)] = inst_23364);

return statearr_23485;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23463__$1,(34),inst_23365);
} else {
if((state_val_23464 === (32))){
var inst_23360 = (state_23463[(18)]);
var state_23463__$1 = state_23463;
if(cljs.core.truth_(inst_23360)){
var statearr_23486_23563 = state_23463__$1;
(statearr_23486_23563[(1)] = (35));

} else {
var statearr_23487_23564 = state_23463__$1;
(statearr_23487_23564[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (40))){
var inst_23312 = (state_23463[(8)]);
var inst_23400 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23312);
var inst_23401 = cljs.core.empty_QMARK_(inst_23400);
var state_23463__$1 = state_23463;
if(inst_23401){
var statearr_23488_23565 = state_23463__$1;
(statearr_23488_23565[(1)] = (43));

} else {
var statearr_23489_23566 = state_23463__$1;
(statearr_23489_23566[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (33))){
var inst_23355 = (state_23463[(14)]);
var inst_23432 = (state_23463[(2)]);
var inst_23433 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23432,(0),null);
var inst_23434 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23432,(1),null);
var inst_23435 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23432,(2),null);
var inst_23436 = inst_23355.s;
var inst_23437 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_23433,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23436);
var inst_23345 = inst_23434;
var inst_23346 = inst_23437;
var inst_23347 = inst_23435;
var state_23463__$1 = (function (){var statearr_23490 = state_23463;
(statearr_23490[(11)] = inst_23345);

(statearr_23490[(12)] = inst_23347);

(statearr_23490[(13)] = inst_23346);

return statearr_23490;
})();
var statearr_23491_23567 = state_23463__$1;
(statearr_23491_23567[(2)] = null);

(statearr_23491_23567[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (13))){
var inst_23306 = (state_23463[(9)]);
var inst_23309 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_23306);
var state_23463__$1 = state_23463;
var statearr_23492_23568 = state_23463__$1;
(statearr_23492_23568[(2)] = inst_23309);

(statearr_23492_23568[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (22))){
var inst_23312 = (state_23463[(8)]);
var inst_23332 = cljs.core.first(flakes);
var inst_23333 = fluree.db.query.fql.s(inst_23332);
var inst_23334 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_23312);
var inst_23335 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_23333,inst_23334);
var state_23463__$1 = state_23463;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23463__$1,(25),inst_23335);
} else {
if((state_val_23464 === (36))){
var inst_23312 = (state_23463[(8)]);
var inst_23388 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23312);
var state_23463__$1 = state_23463;
if(cljs.core.truth_(inst_23388)){
var statearr_23493_23569 = state_23463__$1;
(statearr_23493_23569[(1)] = (39));

} else {
var statearr_23494_23570 = state_23463__$1;
(statearr_23494_23570[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (41))){
var inst_23428 = (state_23463[(2)]);
var state_23463__$1 = state_23463;
var statearr_23495_23571 = state_23463__$1;
(statearr_23495_23571[(2)] = inst_23428);

(statearr_23495_23571[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (43))){
var inst_23312 = (state_23463[(8)]);
var inst_23403 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23312);
var state_23463__$1 = state_23463;
var statearr_23496_23572 = state_23463__$1;
(statearr_23496_23572[(2)] = inst_23403);

(statearr_23496_23572[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (29))){
var inst_23312 = (state_23463[(8)]);
var inst_23355 = (state_23463[(14)]);
var inst_23345 = (state_23463[(11)]);
var inst_23360 = (state_23463[(18)]);
var inst_23355__$1 = cljs.core.first(inst_23345);
var inst_23356 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23357 = inst_23355__$1.p;
var inst_23358 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23357];
var inst_23359 = (new cljs.core.PersistentVector(null,3,(5),inst_23356,inst_23358,null));
var inst_23360__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_23312,inst_23359);
var inst_23361 = fluree.db.query.fql.component_follow_QMARK_(inst_23360__$1,inst_23312);
var inst_23362 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23360__$1);
var state_23463__$1 = (function (){var statearr_23497 = state_23463;
(statearr_23497[(14)] = inst_23355__$1);

(statearr_23497[(15)] = inst_23361);

(statearr_23497[(18)] = inst_23360__$1);

return statearr_23497;
})();
if(cljs.core.truth_(inst_23362)){
var statearr_23498_23573 = state_23463__$1;
(statearr_23498_23573[(1)] = (31));

} else {
var statearr_23499_23574 = state_23463__$1;
(statearr_23499_23574[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (44))){
var state_23463__$1 = state_23463;
var statearr_23500_23575 = state_23463__$1;
(statearr_23500_23575[(2)] = false);

(statearr_23500_23575[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (6))){
var state_23463__$1 = state_23463;
var statearr_23501_23576 = state_23463__$1;
(statearr_23501_23576[(2)] = null);

(statearr_23501_23576[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (28))){
var inst_23346 = (state_23463[(13)]);
var state_23463__$1 = state_23463;
var statearr_23502_23577 = state_23463__$1;
(statearr_23502_23577[(2)] = inst_23346);

(statearr_23502_23577[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (51))){
var inst_23424 = (state_23463[(2)]);
var state_23463__$1 = state_23463;
var statearr_23503_23578 = state_23463__$1;
(statearr_23503_23578[(2)] = inst_23424);

(statearr_23503_23578[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (25))){
var inst_23326 = (state_23463[(10)]);
var inst_23337 = (state_23463[(2)]);
var inst_23338 = fluree.db.util.async.throw_err(inst_23337);
var inst_23339 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_23326,inst_23338], 0));
var state_23463__$1 = state_23463;
var statearr_23504_23579 = state_23463__$1;
(statearr_23504_23579[(2)] = inst_23339);

(statearr_23504_23579[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (34))){
var inst_23364 = (state_23463[(19)]);
var inst_23345 = (state_23463[(11)]);
var inst_23347 = (state_23463[(12)]);
var inst_23367 = (state_23463[(2)]);
var inst_23368 = fluree.db.util.async.throw_err(inst_23367);
var inst_23369 = cljs.core.rest(inst_23345);
var inst_23370 = [inst_23368,inst_23369,inst_23347];
var inst_23371 = (new cljs.core.PersistentVector(null,3,(5),inst_23364,inst_23370,null));
var state_23463__$1 = state_23463;
var statearr_23505_23580 = state_23463__$1;
(statearr_23505_23580[(2)] = inst_23371);

(statearr_23505_23580[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (17))){
var inst_23312 = (state_23463[(8)]);
var inst_23316 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23312);
var state_23463__$1 = state_23463;
var statearr_23507_23581 = state_23463__$1;
(statearr_23507_23581[(2)] = inst_23316);

(statearr_23507_23581[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (3))){
var inst_23461 = (state_23463[(2)]);
var state_23463__$1 = state_23463;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23463__$1,inst_23461);
} else {
if((state_val_23464 === (12))){
var _ = (function (){var statearr_23508 = state_23463;
(statearr_23508[(4)] = cljs.core.rest((state_23463[(4)])));

return statearr_23508;
})();
var state_23463__$1 = state_23463;
var ex23506 = (state_23463__$1[(2)]);
var statearr_23509_23582 = state_23463__$1;
(statearr_23509_23582[(5)] = ex23506);


var statearr_23510_23583 = state_23463__$1;
(statearr_23510_23583[(1)] = (11));

(statearr_23510_23583[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (2))){
var _ = (function (){var statearr_23511 = state_23463;
(statearr_23511[(4)] = cljs.core.cons((5),(state_23463[(4)])));

return statearr_23511;
})();
var inst_23292 = cljs.core.not_empty(flakes);
var state_23463__$1 = state_23463;
if(cljs.core.truth_(inst_23292)){
var statearr_23512_23584 = state_23463__$1;
(statearr_23512_23584[(1)] = (6));

} else {
var statearr_23513_23585 = state_23463__$1;
(statearr_23513_23585[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (23))){
var inst_23326 = (state_23463[(10)]);
var state_23463__$1 = state_23463;
var statearr_23514_23586 = state_23463__$1;
(statearr_23514_23586[(2)] = inst_23326);

(statearr_23514_23586[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (47))){
var state_23463__$1 = state_23463;
var statearr_23515_23587 = state_23463__$1;
(statearr_23515_23587[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (35))){
var inst_23355 = (state_23463[(14)]);
var inst_23361 = (state_23463[(15)]);
var inst_23347 = (state_23463[(12)]);
var inst_23360 = (state_23463[(18)]);
var inst_23346 = (state_23463[(13)]);
var inst_23377 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_23346,inst_23360,inst_23355,inst_23361,false,inst_23347);
var state_23463__$1 = state_23463;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23463__$1,(38),inst_23377);
} else {
if((state_val_23464 === (19))){
var inst_23306 = (state_23463[(9)]);
var inst_23320 = ["_id"];
var inst_23321 = [inst_23306];
var inst_23322 = cljs.core.PersistentHashMap.fromArrays(inst_23320,inst_23321);
var state_23463__$1 = state_23463;
var statearr_23517_23588 = state_23463__$1;
(statearr_23517_23588[(2)] = inst_23322);

(statearr_23517_23588[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (11))){
var inst_23294 = (state_23463[(2)]);
var inst_23295 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_23294], 0));
var inst_23296 = (function(){throw inst_23294})();
var state_23463__$1 = (function (){var statearr_23519 = state_23463;
(statearr_23519[(20)] = inst_23295);

return statearr_23519;
})();
var statearr_23520_23589 = state_23463__$1;
(statearr_23520_23589[(2)] = inst_23296);

(statearr_23520_23589[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (9))){
var _ = (function (){var statearr_23521 = state_23463;
(statearr_23521[(4)] = cljs.core.cons((12),(state_23463[(4)])));

return statearr_23521;
})();
var inst_23302 = cljs.core.first(flakes);
var inst_23303 = fluree.db.query.fql.s(inst_23302);
var ___$1 = (function (){var statearr_23522 = state_23463;
(statearr_23522[(4)] = cljs.core.rest((state_23463[(4)])));

return statearr_23522;
})();
var state_23463__$1 = state_23463;
var statearr_23523_23590 = state_23463__$1;
(statearr_23523_23590[(2)] = inst_23303);

(statearr_23523_23590[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (5))){
var _ = (function (){var statearr_23524 = state_23463;
(statearr_23524[(4)] = cljs.core.rest((state_23463[(4)])));

return statearr_23524;
})();
var state_23463__$1 = state_23463;
var ex23518 = (state_23463__$1[(2)]);
var statearr_23525_23591 = state_23463__$1;
(statearr_23525_23591[(5)] = ex23518);


if((ex23518 instanceof Error)){
var statearr_23526_23592 = state_23463__$1;
(statearr_23526_23592[(1)] = (4));

(statearr_23526_23592[(5)] = null);

} else {
throw ex23518;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (14))){
var state_23463__$1 = state_23463;
var statearr_23527_23593 = state_23463__$1;
(statearr_23527_23593[(2)] = base_select_spec);

(statearr_23527_23593[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (45))){
var inst_23406 = (state_23463[(2)]);
var state_23463__$1 = state_23463;
if(cljs.core.truth_(inst_23406)){
var statearr_23528_23594 = state_23463__$1;
(statearr_23528_23594[(1)] = (46));

} else {
var statearr_23529_23595 = state_23463__$1;
(statearr_23529_23595[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (26))){
var inst_23345 = (state_23463[(11)]);
var inst_23349 = cljs.core.empty_QMARK_(inst_23345);
var state_23463__$1 = state_23463;
if(inst_23349){
var statearr_23530_23596 = state_23463__$1;
(statearr_23530_23596[(1)] = (28));

} else {
var statearr_23531_23597 = state_23463__$1;
(statearr_23531_23597[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (16))){
var inst_23313 = (state_23463[(17)]);
var state_23463__$1 = state_23463;
var statearr_23532_23598 = state_23463__$1;
(statearr_23532_23598[(2)] = inst_23313);

(statearr_23532_23598[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (38))){
var inst_23345 = (state_23463[(11)]);
var inst_23379 = (state_23463[(2)]);
var inst_23380 = fluree.db.util.async.throw_err(inst_23379);
var inst_23381 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23380,(0),null);
var inst_23382 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23380,(1),null);
var inst_23383 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23384 = cljs.core.rest(inst_23345);
var inst_23385 = [inst_23381,inst_23384,inst_23382];
var inst_23386 = (new cljs.core.PersistentVector(null,3,(5),inst_23383,inst_23385,null));
var state_23463__$1 = state_23463;
var statearr_23533_23599 = state_23463__$1;
(statearr_23533_23599[(2)] = inst_23386);

(statearr_23533_23599[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (30))){
var inst_23440 = (state_23463[(2)]);
var state_23463__$1 = state_23463;
var statearr_23534_23600 = state_23463__$1;
(statearr_23534_23600[(2)] = inst_23440);

(statearr_23534_23600[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (10))){
var inst_23306 = (state_23463[(2)]);
var inst_23307 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_23463__$1 = (function (){var statearr_23535 = state_23463;
(statearr_23535[(9)] = inst_23306);

return statearr_23535;
})();
if(cljs.core.truth_(inst_23307)){
var statearr_23536_23601 = state_23463__$1;
(statearr_23536_23601[(1)] = (13));

} else {
var statearr_23537_23602 = state_23463__$1;
(statearr_23537_23602[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (18))){
var inst_23318 = (state_23463[(2)]);
var state_23463__$1 = state_23463;
if(cljs.core.truth_(inst_23318)){
var statearr_23538_23603 = state_23463__$1;
(statearr_23538_23603[(1)] = (19));

} else {
var statearr_23539_23604 = state_23463__$1;
(statearr_23539_23604[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (42))){
var inst_23345 = (state_23463[(11)]);
var inst_23347 = (state_23463[(12)]);
var inst_23390 = (state_23463[(16)]);
var inst_23393 = (state_23463[(2)]);
var inst_23394 = fluree.db.util.async.throw_err(inst_23393);
var inst_23395 = cljs.core.first(inst_23394);
var inst_23396 = cljs.core.rest(inst_23345);
var inst_23397 = [inst_23395,inst_23396,inst_23347];
var inst_23398 = (new cljs.core.PersistentVector(null,3,(5),inst_23390,inst_23397,null));
var state_23463__$1 = state_23463;
var statearr_23540_23605 = state_23463__$1;
(statearr_23540_23605[(2)] = inst_23398);

(statearr_23540_23605[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (37))){
var inst_23430 = (state_23463[(2)]);
var state_23463__$1 = state_23463;
var statearr_23541_23606 = state_23463__$1;
(statearr_23541_23606[(2)] = inst_23430);

(statearr_23541_23606[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (8))){
var inst_23458 = (state_23463[(2)]);
var _ = (function (){var statearr_23542 = state_23463;
(statearr_23542[(4)] = cljs.core.rest((state_23463[(4)])));

return statearr_23542;
})();
var state_23463__$1 = state_23463;
var statearr_23543_23607 = state_23463__$1;
(statearr_23543_23607[(2)] = inst_23458);

(statearr_23543_23607[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23464 === (49))){
var inst_23345 = (state_23463[(11)]);
var inst_23347 = (state_23463[(12)]);
var inst_23346 = (state_23463[(13)]);
var inst_23418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23419 = cljs.core.rest(inst_23345);
var inst_23420 = [inst_23346,inst_23419,inst_23347];
var inst_23421 = (new cljs.core.PersistentVector(null,3,(5),inst_23418,inst_23420,null));
var state_23463__$1 = state_23463;
var statearr_23544_23608 = state_23463__$1;
(statearr_23544_23608[(2)] = inst_23421);

(statearr_23544_23608[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto____0 = (function (){
var statearr_23545 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23545[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto__);

(statearr_23545[(1)] = (1));

return statearr_23545;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto____1 = (function (state_23463){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_23463);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e23546){var ex__2882__auto__ = e23546;
var statearr_23547_23609 = state_23463;
(statearr_23547_23609[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_23463[(4)]))){
var statearr_23548_23610 = state_23463;
(statearr_23548_23610[(1)] = cljs.core.first((state_23463[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23611 = state_23463;
state_23463 = G__23611;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto__ = function(state_23463){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto____1.call(this,state_23463);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_23549 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_23549[(6)] = c__2901__auto__);

return statearr_23549;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__23614 = arguments.length;
switch (G__23614) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_23656){
var state_val_23657 = (state_23656[(1)]);
if((state_val_23657 === (7))){
var inst_23622 = (state_23656[(7)]);
var state_23656__$1 = state_23656;
var statearr_23658_23688 = state_23656__$1;
(statearr_23658_23688[(2)] = inst_23622);

(statearr_23658_23688[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23657 === (1))){
var state_23656__$1 = state_23656;
var statearr_23659_23689 = state_23656__$1;
(statearr_23659_23689[(2)] = null);

(statearr_23659_23689[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23657 === (4))){
var inst_23615 = (state_23656[(2)]);
var state_23656__$1 = state_23656;
var statearr_23660_23690 = state_23656__$1;
(statearr_23660_23690[(2)] = inst_23615);

(statearr_23660_23690[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23657 === (15))){
var inst_23650 = (state_23656[(2)]);
var inst_23651 = fluree.db.util.async.throw_err(inst_23650);
var _ = (function (){var statearr_23661 = state_23656;
(statearr_23661[(4)] = cljs.core.rest((state_23656[(4)])));

return statearr_23661;
})();
var state_23656__$1 = state_23656;
var statearr_23662_23691 = state_23656__$1;
(statearr_23662_23691[(2)] = inst_23651);

(statearr_23662_23691[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23657 === (13))){
var inst_23634 = (state_23656[(8)]);
var state_23656__$1 = state_23656;
var statearr_23663_23692 = state_23656__$1;
(statearr_23663_23692[(2)] = inst_23634);

(statearr_23663_23692[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23657 === (6))){
var inst_23622 = (state_23656[(7)]);
var inst_23624 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_23625 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23622,inst_23624);
var state_23656__$1 = state_23656;
var statearr_23664_23693 = state_23656__$1;
(statearr_23664_23693[(2)] = inst_23625);

(statearr_23664_23693[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23657 === (3))){
var inst_23654 = (state_23656[(2)]);
var state_23656__$1 = state_23656;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23656__$1,inst_23654);
} else {
if((state_val_23657 === (12))){
var inst_23634 = (state_23656[(8)]);
var inst_23636 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_23637 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23634,inst_23636);
var state_23656__$1 = state_23656;
var statearr_23665_23694 = state_23656__$1;
(statearr_23665_23694[(2)] = inst_23637);

(statearr_23665_23694[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23657 === (2))){
var _ = (function (){var statearr_23666 = state_23656;
(statearr_23666[(4)] = cljs.core.cons((5),(state_23656[(4)])));

return statearr_23666;
})();
var inst_23622 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_23656__$1 = (function (){var statearr_23667 = state_23656;
(statearr_23667[(7)] = inst_23622);

return statearr_23667;
})();
if(cljs.core.truth_(fuel)){
var statearr_23668_23695 = state_23656__$1;
(statearr_23668_23695[(1)] = (6));

} else {
var statearr_23669_23696 = state_23656__$1;
(statearr_23669_23696[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23657 === (11))){
var inst_23634 = (state_23656[(2)]);
var state_23656__$1 = (function (){var statearr_23671 = state_23656;
(statearr_23671[(8)] = inst_23634);

return statearr_23671;
})();
if(cljs.core.truth_(limit)){
var statearr_23672_23697 = state_23656__$1;
(statearr_23672_23697[(1)] = (12));

} else {
var statearr_23673_23698 = state_23656__$1;
(statearr_23673_23698[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23657 === (9))){
var inst_23628 = (state_23656[(9)]);
var inst_23630 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_23631 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23628,inst_23630);
var state_23656__$1 = state_23656;
var statearr_23674_23699 = state_23656__$1;
(statearr_23674_23699[(2)] = inst_23631);

(statearr_23674_23699[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23657 === (5))){
var _ = (function (){var statearr_23675 = state_23656;
(statearr_23675[(4)] = cljs.core.rest((state_23656[(4)])));

return statearr_23675;
})();
var state_23656__$1 = state_23656;
var ex23670 = (state_23656__$1[(2)]);
var statearr_23676_23700 = state_23656__$1;
(statearr_23676_23700[(5)] = ex23670);


if((ex23670 instanceof Error)){
var statearr_23677_23701 = state_23656__$1;
(statearr_23677_23701[(1)] = (4));

(statearr_23677_23701[(5)] = null);

} else {
throw ex23670;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23657 === (14))){
var inst_23640 = (state_23656[(2)]);
var inst_23641 = (function (){return (function (x){
var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4115__auto__;
}
});
})();
var inst_23642 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_23641);
var inst_23643 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_23640,inst_23642);
var inst_23644 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_23643,flakes);
var inst_23645 = cljs.core.PersistentVector.EMPTY;
var inst_23646 = (function (){var xf = inst_23643;
var flakes_by_sub = inst_23644;
return (function (p1__23612_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__23612_SHARP_);
});
})();
var inst_23647 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_23646,inst_23644);
var inst_23648 = fluree.db.util.async.merge_into_QMARK_(inst_23645,inst_23647);
var state_23656__$1 = state_23656;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23656__$1,(15),inst_23648);
} else {
if((state_val_23657 === (10))){
var inst_23628 = (state_23656[(9)]);
var state_23656__$1 = state_23656;
var statearr_23678_23702 = state_23656__$1;
(statearr_23678_23702[(2)] = inst_23628);

(statearr_23678_23702[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23657 === (8))){
var inst_23628 = (state_23656[(2)]);
var state_23656__$1 = (function (){var statearr_23679 = state_23656;
(statearr_23679[(9)] = inst_23628);

return statearr_23679;
})();
if(cljs.core.truth_(offset)){
var statearr_23680_23703 = state_23656__$1;
(statearr_23680_23703[(1)] = (9));

} else {
var statearr_23681_23704 = state_23656__$1;
(statearr_23681_23704[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2879__auto__ = null;
var fluree$db$query$fql$state_machine__2879__auto____0 = (function (){
var statearr_23682 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23682[(0)] = fluree$db$query$fql$state_machine__2879__auto__);

(statearr_23682[(1)] = (1));

return statearr_23682;
});
var fluree$db$query$fql$state_machine__2879__auto____1 = (function (state_23656){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_23656);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e23683){var ex__2882__auto__ = e23683;
var statearr_23684_23705 = state_23656;
(statearr_23684_23705[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_23656[(4)]))){
var statearr_23685_23706 = state_23656;
(statearr_23685_23706[(1)] = cljs.core.first((state_23656[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23707 = state_23656;
state_23656 = G__23707;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2879__auto__ = function(state_23656){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2879__auto____1.call(this,state_23656);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2879__auto____0;
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2879__auto____1;
return fluree$db$query$fql$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_23686 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_23686[(6)] = c__2901__auto__);

return statearr_23686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__23709 = arguments.length;
switch (G__23709) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_23793){
var state_val_23794 = (state_23793[(1)]);
if((state_val_23794 === (7))){
var inst_23788 = (state_23793[(2)]);
var _ = (function (){var statearr_23796 = state_23793;
(statearr_23796[(4)] = cljs.core.rest((state_23793[(4)])));

return statearr_23796;
})();
var state_23793__$1 = state_23793;
var statearr_23797_23844 = state_23793__$1;
(statearr_23797_23844[(2)] = inst_23788);

(statearr_23797_23844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (20))){
var inst_23729 = (state_23793[(7)]);
var inst_23737 = (state_23793[(8)]);
var inst_23730 = (state_23793[(9)]);
var inst_23758 = (inst_23729 + (1));
var tmp23795 = inst_23730;
var inst_23728 = inst_23737;
var inst_23729__$1 = inst_23758;
var inst_23730__$1 = tmp23795;
var state_23793__$1 = (function (){var statearr_23798 = state_23793;
(statearr_23798[(7)] = inst_23729__$1);

(statearr_23798[(9)] = inst_23730__$1);

(statearr_23798[(10)] = inst_23728);

return statearr_23798;
})();
var statearr_23799_23845 = state_23793__$1;
(statearr_23799_23845[(2)] = null);

(statearr_23799_23845[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (27))){
var inst_23763 = (state_23793[(11)]);
var inst_23772 = (state_23793[(2)]);
var inst_23773 = fluree.db.util.async.throw_err(inst_23772);
var inst_23774 = (inst_23763.cljs$core$IFn$_invoke$arity$1 ? inst_23763.cljs$core$IFn$_invoke$arity$1(inst_23773) : inst_23763.call(null,inst_23773));
var state_23793__$1 = state_23793;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23793__$1,(26),inst_23774);
} else {
if((state_val_23794 === (1))){
var state_23793__$1 = state_23793;
var statearr_23800_23846 = state_23793__$1;
(statearr_23800_23846[(2)] = null);

(statearr_23800_23846[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (24))){
var state_23793__$1 = state_23793;
var statearr_23801_23847 = state_23793__$1;
(statearr_23801_23847[(2)] = null);

(statearr_23801_23847[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (4))){
var inst_23710 = (state_23793[(2)]);
var state_23793__$1 = state_23793;
var statearr_23802_23848 = state_23793__$1;
(statearr_23802_23848[(2)] = inst_23710);

(statearr_23802_23848[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (15))){
var inst_23751 = (state_23793[(12)]);
var inst_23751__$1 = offset;
var state_23793__$1 = (function (){var statearr_23803 = state_23793;
(statearr_23803[(12)] = inst_23751__$1);

return statearr_23803;
})();
if(cljs.core.truth_(inst_23751__$1)){
var statearr_23804_23849 = state_23793__$1;
(statearr_23804_23849[(1)] = (17));

} else {
var statearr_23805_23850 = state_23793__$1;
(statearr_23805_23850[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (21))){
var state_23793__$1 = state_23793;
var statearr_23806_23851 = state_23793__$1;
(statearr_23806_23851[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (13))){
var inst_23746 = (state_23793[(2)]);
var state_23793__$1 = state_23793;
var statearr_23808_23852 = state_23793__$1;
(statearr_23808_23852[(2)] = inst_23746);

(statearr_23808_23852[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (22))){
var inst_23784 = (state_23793[(2)]);
var state_23793__$1 = state_23793;
var statearr_23809_23853 = state_23793__$1;
(statearr_23809_23853[(2)] = inst_23784);

(statearr_23809_23853[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (6))){
var inst_23736 = (state_23793[(13)]);
var inst_23738 = (state_23793[(14)]);
var inst_23728 = (state_23793[(10)]);
var inst_23735 = cljs.core.seq(inst_23728);
var inst_23736__$1 = cljs.core.first(inst_23735);
var inst_23737 = cljs.core.next(inst_23735);
var inst_23738__$1 = (inst_23736__$1 == null);
var state_23793__$1 = (function (){var statearr_23810 = state_23793;
(statearr_23810[(13)] = inst_23736__$1);

(statearr_23810[(14)] = inst_23738__$1);

(statearr_23810[(8)] = inst_23737);

return statearr_23810;
})();
if(cljs.core.truth_(inst_23738__$1)){
var statearr_23811_23854 = state_23793__$1;
(statearr_23811_23854[(1)] = (8));

} else {
var statearr_23812_23855 = state_23793__$1;
(statearr_23812_23855[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (25))){
var inst_23782 = (state_23793[(2)]);
var state_23793__$1 = state_23793;
var statearr_23813_23856 = state_23793__$1;
(statearr_23813_23856[(2)] = inst_23782);

(statearr_23813_23856[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (17))){
var inst_23729 = (state_23793[(7)]);
var inst_23753 = (inst_23729 < offset);
var state_23793__$1 = state_23793;
var statearr_23814_23857 = state_23793__$1;
(statearr_23814_23857[(2)] = inst_23753);

(statearr_23814_23857[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (3))){
var inst_23791 = (state_23793[(2)]);
var state_23793__$1 = state_23793;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23793__$1,inst_23791);
} else {
if((state_val_23794 === (12))){
var inst_23741 = (state_23793[(15)]);
var state_23793__$1 = state_23793;
var statearr_23815_23858 = state_23793__$1;
(statearr_23815_23858[(2)] = inst_23741);

(statearr_23815_23858[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (2))){
var inst_23723 = (state_23793[(16)]);
var _ = (function (){var statearr_23816 = state_23793;
(statearr_23816[(4)] = cljs.core.cons((5),(state_23793[(4)])));

return statearr_23816;
})();
var inst_23723__$1 = subjects;
var inst_23724 = cljs.core.seq(inst_23723__$1);
var inst_23725 = cljs.core.first(inst_23724);
var inst_23726 = cljs.core.next(inst_23724);
var inst_23727 = cljs.core.PersistentVector.EMPTY;
var inst_23728 = inst_23723__$1;
var inst_23729 = (0);
var inst_23730 = inst_23727;
var state_23793__$1 = (function (){var statearr_23817 = state_23793;
(statearr_23817[(17)] = inst_23725);

(statearr_23817[(7)] = inst_23729);

(statearr_23817[(18)] = inst_23726);

(statearr_23817[(16)] = inst_23723__$1);

(statearr_23817[(9)] = inst_23730);

(statearr_23817[(10)] = inst_23728);

return statearr_23817;
})();
var statearr_23818_23859 = state_23793__$1;
(statearr_23818_23859[(2)] = null);

(statearr_23818_23859[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (23))){
var inst_23725 = (state_23793[(17)]);
var inst_23729 = (state_23793[(7)]);
var inst_23736 = (state_23793[(13)]);
var inst_23726 = (state_23793[(18)]);
var inst_23737 = (state_23793[(8)]);
var inst_23723 = (state_23793[(16)]);
var inst_23730 = (state_23793[(9)]);
var inst_23728 = (state_23793[(10)]);
var inst_23762 = (inst_23729 + (1));
var inst_23763 = (function (){var seq__23721 = inst_23726;
var first__23722 = inst_23725;
var seq__23733 = inst_23737;
var r = inst_23737;
var acc = inst_23730;
var first__23734 = inst_23736;
var n = inst_23729;
var s = inst_23736;
var vec__23720 = inst_23723;
var G__23719 = inst_23728;
var vec__23732 = inst_23728;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_23764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23765 = [inst_23736];
var inst_23766 = (new cljs.core.PersistentVector(null,1,(5),inst_23764,inst_23765,null));
var inst_23767 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_23768 = [limit];
var inst_23769 = cljs.core.PersistentHashMap.fromArrays(inst_23767,inst_23768);
var inst_23770 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23766,inst_23769);
var state_23793__$1 = (function (){var statearr_23819 = state_23793;
(statearr_23819[(11)] = inst_23763);

(statearr_23819[(19)] = inst_23762);

return statearr_23819;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23793__$1,(27),inst_23770);
} else {
if((state_val_23794 === (19))){
var inst_23756 = (state_23793[(2)]);
var state_23793__$1 = state_23793;
if(cljs.core.truth_(inst_23756)){
var statearr_23820_23860 = state_23793__$1;
(statearr_23820_23860[(1)] = (20));

} else {
var statearr_23821_23861 = state_23793__$1;
(statearr_23821_23861[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (11))){
var inst_23729 = (state_23793[(7)]);
var inst_23743 = (inst_23729 > limit);
var state_23793__$1 = state_23793;
var statearr_23823_23862 = state_23793__$1;
(statearr_23823_23862[(2)] = inst_23743);

(statearr_23823_23862[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (9))){
var inst_23741 = (state_23793[(15)]);
var inst_23741__$1 = limit;
var state_23793__$1 = (function (){var statearr_23824 = state_23793;
(statearr_23824[(15)] = inst_23741__$1);

return statearr_23824;
})();
if(cljs.core.truth_(inst_23741__$1)){
var statearr_23825_23863 = state_23793__$1;
(statearr_23825_23863[(1)] = (11));

} else {
var statearr_23826_23864 = state_23793__$1;
(statearr_23826_23864[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (5))){
var _ = (function (){var statearr_23827 = state_23793;
(statearr_23827[(4)] = cljs.core.rest((state_23793[(4)])));

return statearr_23827;
})();
var state_23793__$1 = state_23793;
var ex23822 = (state_23793__$1[(2)]);
var statearr_23828_23865 = state_23793__$1;
(statearr_23828_23865[(5)] = ex23822);


if((ex23822 instanceof Error)){
var statearr_23829_23866 = state_23793__$1;
(statearr_23829_23866[(1)] = (4));

(statearr_23829_23866[(5)] = null);

} else {
throw ex23822;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (14))){
var inst_23730 = (state_23793[(9)]);
var state_23793__$1 = state_23793;
var statearr_23830_23867 = state_23793__$1;
(statearr_23830_23867[(2)] = inst_23730);

(statearr_23830_23867[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (26))){
var inst_23737 = (state_23793[(8)]);
var inst_23762 = (state_23793[(19)]);
var inst_23730 = (state_23793[(9)]);
var inst_23776 = (state_23793[(2)]);
var inst_23777 = fluree.db.util.async.throw_err(inst_23776);
var inst_23778 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23730,inst_23777);
var inst_23728 = inst_23737;
var inst_23729 = inst_23762;
var inst_23730__$1 = inst_23778;
var state_23793__$1 = (function (){var statearr_23831 = state_23793;
(statearr_23831[(7)] = inst_23729);

(statearr_23831[(9)] = inst_23730__$1);

(statearr_23831[(10)] = inst_23728);

return statearr_23831;
})();
var statearr_23832_23868 = state_23793__$1;
(statearr_23832_23868[(2)] = null);

(statearr_23832_23868[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (16))){
var inst_23786 = (state_23793[(2)]);
var state_23793__$1 = state_23793;
var statearr_23833_23869 = state_23793__$1;
(statearr_23833_23869[(2)] = inst_23786);

(statearr_23833_23869[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (10))){
var inst_23748 = (state_23793[(2)]);
var state_23793__$1 = state_23793;
if(cljs.core.truth_(inst_23748)){
var statearr_23834_23870 = state_23793__$1;
(statearr_23834_23870[(1)] = (14));

} else {
var statearr_23835_23871 = state_23793__$1;
(statearr_23835_23871[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (18))){
var inst_23751 = (state_23793[(12)]);
var state_23793__$1 = state_23793;
var statearr_23836_23872 = state_23793__$1;
(statearr_23836_23872[(2)] = inst_23751);

(statearr_23836_23872[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23794 === (8))){
var inst_23738 = (state_23793[(14)]);
var state_23793__$1 = state_23793;
var statearr_23837_23873 = state_23793__$1;
(statearr_23837_23873[(2)] = inst_23738);

(statearr_23837_23873[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2879__auto__ = null;
var fluree$db$query$fql$state_machine__2879__auto____0 = (function (){
var statearr_23838 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23838[(0)] = fluree$db$query$fql$state_machine__2879__auto__);

(statearr_23838[(1)] = (1));

return statearr_23838;
});
var fluree$db$query$fql$state_machine__2879__auto____1 = (function (state_23793){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_23793);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e23839){var ex__2882__auto__ = e23839;
var statearr_23840_23874 = state_23793;
(statearr_23840_23874[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_23793[(4)]))){
var statearr_23841_23875 = state_23793;
(statearr_23841_23875[(1)] = cljs.core.first((state_23793[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23876 = state_23793;
state_23793 = G__23876;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2879__auto__ = function(state_23793){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2879__auto____1.call(this,state_23793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2879__auto____0;
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2879__auto____1;
return fluree$db$query$fql$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_23842 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_23842[(6)] = c__2901__auto__);

return statearr_23842;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4126__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__23878 = arguments.length;
switch (G__23878) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_24066){
var state_val_24067 = (state_24066[(1)]);
if((state_val_24067 === (7))){
var state_24066__$1 = state_24066;
var statearr_24068_24139 = state_24066__$1;
(statearr_24068_24139[(2)] = null);

(statearr_24068_24139[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (20))){
var inst_23919 = (state_24066[(7)]);
var inst_23921 = (state_24066[(8)]);
var inst_23949 = (state_24066[(2)]);
var inst_23950 = fluree.db.util.async.throw_err(inst_23949);
var inst_23951 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23952 = [inst_23919];
var inst_23953 = (new cljs.core.PersistentVector(null,1,(5),inst_23951,inst_23952,null));
var inst_23954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23955 = [inst_23919,inst_23921];
var inst_23956 = (new cljs.core.PersistentVector(null,2,(5),inst_23954,inst_23955,null));
var inst_23957 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23953,cljs.core._LT_,inst_23956);
var state_24066__$1 = (function (){var statearr_24069 = state_24066;
(statearr_24069[(9)] = inst_23950);

return statearr_24069;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24066__$1,(21),inst_23957);
} else {
if((state_val_24067 === (27))){
var inst_23938 = (state_24066[(10)]);
var inst_23920 = (state_24066[(11)]);
var inst_23986 = (inst_23938.cljs$core$IFn$_invoke$arity$2 ? inst_23938.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_23920) : inst_23938.call(null,cljs.core._GT__EQ_,inst_23920));
var state_24066__$1 = state_24066;
if(cljs.core.truth_(inst_23986)){
var statearr_24070_24140 = state_24066__$1;
(statearr_24070_24140[(1)] = (30));

} else {
var statearr_24071_24141 = state_24066__$1;
(statearr_24071_24141[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (1))){
var state_24066__$1 = state_24066;
var statearr_24072_24142 = state_24066__$1;
(statearr_24072_24142[(2)] = null);

(statearr_24072_24142[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (24))){
var inst_24035 = (state_24066[(2)]);
var state_24066__$1 = state_24066;
var statearr_24073_24143 = state_24066__$1;
(statearr_24073_24143[(2)] = inst_24035);

(statearr_24073_24143[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (39))){
var inst_24025 = null;
var state_24066__$1 = state_24066;
var statearr_24074_24144 = state_24066__$1;
(statearr_24074_24144[(2)] = inst_24025);

(statearr_24074_24144[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (46))){
var inst_24046 = (state_24066[(12)]);
var inst_23912 = (state_24066[(13)]);
var inst_23904 = inst_23912;
var inst_23905 = inst_24046;
var state_24066__$1 = (function (){var statearr_24075 = state_24066;
(statearr_24075[(14)] = inst_23904);

(statearr_24075[(15)] = inst_23905);

return statearr_24075;
})();
var statearr_24076_24145 = state_24066__$1;
(statearr_24076_24145[(2)] = null);

(statearr_24076_24145[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (4))){
var inst_23879 = (state_24066[(2)]);
var state_24066__$1 = state_24066;
var statearr_24077_24146 = state_24066__$1;
(statearr_24077_24146[(2)] = inst_23879);

(statearr_24077_24146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (15))){
var state_24066__$1 = state_24066;
var statearr_24078_24147 = state_24066__$1;
(statearr_24078_24147[(2)] = null);

(statearr_24078_24147[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (21))){
var inst_23950 = (state_24066[(9)]);
var inst_23959 = (state_24066[(2)]);
var inst_23960 = fluree.db.util.async.throw_err(inst_23959);
var inst_23961 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_23950,inst_23960);
var state_24066__$1 = state_24066;
var statearr_24079_24148 = state_24066__$1;
(statearr_24079_24148[(2)] = inst_23961);

(statearr_24079_24148[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (31))){
var inst_23938 = (state_24066[(10)]);
var inst_23920 = (state_24066[(11)]);
var inst_23999 = (inst_23938.cljs$core$IFn$_invoke$arity$2 ? inst_23938.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_23920) : inst_23938.call(null,cljs.core._LT_,inst_23920));
var state_24066__$1 = state_24066;
if(cljs.core.truth_(inst_23999)){
var statearr_24080_24149 = state_24066__$1;
(statearr_24080_24149[(1)] = (34));

} else {
var statearr_24081_24150 = state_24066__$1;
(statearr_24081_24150[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (32))){
var inst_24031 = (state_24066[(2)]);
var state_24066__$1 = state_24066;
var statearr_24082_24151 = state_24066__$1;
(statearr_24082_24151[(2)] = inst_24031);

(statearr_24082_24151[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (40))){
var inst_24027 = (state_24066[(2)]);
var state_24066__$1 = state_24066;
var statearr_24083_24152 = state_24066__$1;
(statearr_24083_24152[(2)] = inst_24027);

(statearr_24083_24152[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (33))){
var inst_23996 = (state_24066[(2)]);
var inst_23997 = fluree.db.util.async.throw_err(inst_23996);
var state_24066__$1 = state_24066;
var statearr_24084_24153 = state_24066__$1;
(statearr_24084_24153[(2)] = inst_23997);

(statearr_24084_24153[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (13))){
var inst_24056 = (state_24066[(2)]);
var state_24066__$1 = state_24066;
var statearr_24085_24154 = state_24066__$1;
(statearr_24085_24154[(2)] = inst_24056);

(statearr_24085_24154[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (22))){
var inst_23919 = (state_24066[(7)]);
var inst_23921 = (state_24066[(8)]);
var inst_23965 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23966 = [inst_23919,inst_23921];
var inst_23967 = (new cljs.core.PersistentVector(null,2,(5),inst_23965,inst_23966,null));
var inst_23968 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_23967);
var state_24066__$1 = state_24066;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24066__$1,(25),inst_23968);
} else {
if((state_val_24067 === (36))){
var inst_24029 = (state_24066[(2)]);
var state_24066__$1 = state_24066;
var statearr_24086_24155 = state_24066__$1;
(statearr_24086_24155[(2)] = inst_24029);

(statearr_24086_24155[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (41))){
var inst_24022 = (state_24066[(2)]);
var inst_24023 = fluree.db.util.async.throw_err(inst_24022);
var state_24066__$1 = state_24066;
var statearr_24087_24156 = state_24066__$1;
(statearr_24087_24156[(2)] = inst_24023);

(statearr_24087_24156[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (43))){
var inst_23905 = (state_24066[(15)]);
var inst_24038 = (state_24066[(16)]);
var inst_24039 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_23905,inst_24038);
var state_24066__$1 = state_24066;
var statearr_24088_24157 = state_24066__$1;
(statearr_24088_24157[(2)] = inst_24039);

(statearr_24088_24157[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (29))){
var inst_23983 = (state_24066[(2)]);
var inst_23984 = fluree.db.util.async.throw_err(inst_23983);
var state_24066__$1 = state_24066;
var statearr_24089_24158 = state_24066__$1;
(statearr_24089_24158[(2)] = inst_23984);

(statearr_24089_24158[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (44))){
var inst_23905 = (state_24066[(15)]);
var inst_24038 = (state_24066[(16)]);
var inst_24041 = cljs.core.PersistentHashSet.EMPTY;
var inst_24042 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24041,inst_24038);
var inst_24043 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_23905,inst_24042);
var state_24066__$1 = state_24066;
var statearr_24090_24159 = state_24066__$1;
(statearr_24090_24159[(2)] = inst_24043);

(statearr_24090_24159[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (6))){
var inst_23890 = (state_24066[(17)]);
var inst_23900 = cljs.core.seq(inst_23890);
var inst_23901 = cljs.core.first(inst_23900);
var inst_23902 = cljs.core.next(inst_23900);
var inst_23903 = cljs.core.PersistentHashSet.EMPTY;
var inst_23904 = inst_23890;
var inst_23905 = inst_23903;
var state_24066__$1 = (function (){var statearr_24091 = state_24066;
(statearr_24091[(14)] = inst_23904);

(statearr_24091[(15)] = inst_23905);

(statearr_24091[(18)] = inst_23901);

(statearr_24091[(19)] = inst_23902);

return statearr_24091;
})();
var statearr_24092_24160 = state_24066__$1;
(statearr_24092_24160[(2)] = null);

(statearr_24092_24160[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (28))){
var inst_24033 = (state_24066[(2)]);
var state_24066__$1 = state_24066;
var statearr_24093_24161 = state_24066__$1;
(statearr_24093_24161[(2)] = inst_24033);

(statearr_24093_24161[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (25))){
var inst_23970 = (state_24066[(2)]);
var inst_23971 = fluree.db.util.async.throw_err(inst_23970);
var state_24066__$1 = state_24066;
var statearr_24094_24162 = state_24066__$1;
(statearr_24094_24162[(2)] = inst_23971);

(statearr_24094_24162[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (34))){
var inst_23919 = (state_24066[(7)]);
var inst_23921 = (state_24066[(8)]);
var inst_24001 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24002 = [inst_23919];
var inst_24003 = (new cljs.core.PersistentVector(null,1,(5),inst_24001,inst_24002,null));
var inst_24004 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24005 = [inst_23919,inst_23921];
var inst_24006 = (new cljs.core.PersistentVector(null,2,(5),inst_24004,inst_24005,null));
var inst_24007 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24003,cljs.core._LT_,inst_24006);
var state_24066__$1 = state_24066;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24066__$1,(37),inst_24007);
} else {
if((state_val_24067 === (17))){
var inst_23919 = (state_24066[(7)]);
var inst_23921 = (state_24066[(8)]);
var inst_23941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23942 = [inst_23919,inst_23921];
var inst_23943 = (new cljs.core.PersistentVector(null,2,(5),inst_23941,inst_23942,null));
var inst_23944 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23945 = [inst_23919];
var inst_23946 = (new cljs.core.PersistentVector(null,1,(5),inst_23944,inst_23945,null));
var inst_23947 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_23943,cljs.core._LT__EQ_,inst_23946);
var state_24066__$1 = state_24066;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24066__$1,(20),inst_23947);
} else {
if((state_val_24067 === (3))){
var inst_24064 = (state_24066[(2)]);
var state_24066__$1 = state_24066;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24066__$1,inst_24064);
} else {
if((state_val_24067 === (12))){
var inst_23919 = (state_24066[(7)]);
var inst_23911 = (state_24066[(20)]);
var inst_23919__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23911,(0),null);
var inst_23920 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23911,(1),null);
var inst_23921 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23911,(2),null);
var inst_23922 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_23919__$1);
var inst_23923 = cljs.core.not(inst_23922);
var state_24066__$1 = (function (){var statearr_24095 = state_24066;
(statearr_24095[(7)] = inst_23919__$1);

(statearr_24095[(8)] = inst_23921);

(statearr_24095[(11)] = inst_23920);

return statearr_24095;
})();
if(inst_23923){
var statearr_24096_24163 = state_24066__$1;
(statearr_24096_24163[(1)] = (14));

} else {
var statearr_24097_24164 = state_24066__$1;
(statearr_24097_24164[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (2))){
var inst_23890 = (state_24066[(17)]);
var _ = (function (){var statearr_24098 = state_24066;
(statearr_24098[(4)] = cljs.core.cons((5),(state_24066[(4)])));

return statearr_24098;
})();
var inst_23888 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_23889 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23888,(0),null);
var inst_23890__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_23888,(1),null);
var inst_23891 = cljs.core.not_empty(inst_23890__$1);
var state_24066__$1 = (function (){var statearr_24099 = state_24066;
(statearr_24099[(21)] = inst_23889);

(statearr_24099[(17)] = inst_23890__$1);

return statearr_24099;
})();
if(cljs.core.truth_(inst_23891)){
var statearr_24100_24165 = state_24066__$1;
(statearr_24100_24165[(1)] = (6));

} else {
var statearr_24101_24166 = state_24066__$1;
(statearr_24101_24166[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (23))){
var inst_23938 = (state_24066[(10)]);
var inst_23920 = (state_24066[(11)]);
var inst_23973 = (inst_23938.cljs$core$IFn$_invoke$arity$2 ? inst_23938.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_23920) : inst_23938.call(null,cljs.core._GT_,inst_23920));
var state_24066__$1 = state_24066;
if(cljs.core.truth_(inst_23973)){
var statearr_24102_24167 = state_24066__$1;
(statearr_24102_24167[(1)] = (26));

} else {
var statearr_24103_24168 = state_24066__$1;
(statearr_24103_24168[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (47))){
var inst_24054 = (state_24066[(2)]);
var state_24066__$1 = state_24066;
var statearr_24104_24169 = state_24066__$1;
(statearr_24104_24169[(2)] = inst_24054);

(statearr_24104_24169[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (35))){
var inst_23938 = (state_24066[(10)]);
var inst_23920 = (state_24066[(11)]);
var inst_24012 = (inst_23938.cljs$core$IFn$_invoke$arity$2 ? inst_23938.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_23920) : inst_23938.call(null,cljs.core._LT__EQ_,inst_23920));
var state_24066__$1 = state_24066;
if(cljs.core.truth_(inst_24012)){
var statearr_24105_24170 = state_24066__$1;
(statearr_24105_24170[(1)] = (38));

} else {
var statearr_24106_24171 = state_24066__$1;
(statearr_24106_24171[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (19))){
var inst_23889 = (state_24066[(21)]);
var inst_24037 = (state_24066[(2)]);
var inst_24038 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_24037);
var state_24066__$1 = (function (){var statearr_24107 = state_24066;
(statearr_24107[(16)] = inst_24038);

return statearr_24107;
})();
var G__24108_24172 = inst_23889;
var G__24108_24173__$1 = (((G__24108_24172 instanceof cljs.core.Keyword))?G__24108_24172.fqn:null);
switch (G__24108_24173__$1) {
case "or":
var statearr_24109_24175 = state_24066__$1;
(statearr_24109_24175[(1)] = (43));


break;
case "and":
var statearr_24110_24176 = state_24066__$1;
(statearr_24110_24176[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__24108_24173__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (11))){
var inst_23905 = (state_24066[(15)]);
var state_24066__$1 = state_24066;
var statearr_24112_24177 = state_24066__$1;
(statearr_24112_24177[(2)] = inst_23905);

(statearr_24112_24177[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (9))){
var inst_23904 = (state_24066[(14)]);
var inst_23911 = (state_24066[(20)]);
var inst_23910 = cljs.core.seq(inst_23904);
var inst_23911__$1 = cljs.core.first(inst_23910);
var inst_23912 = cljs.core.next(inst_23910);
var inst_23913 = cljs.core.not(inst_23911__$1);
var state_24066__$1 = (function (){var statearr_24113 = state_24066;
(statearr_24113[(13)] = inst_23912);

(statearr_24113[(20)] = inst_23911__$1);

return statearr_24113;
})();
if(inst_23913){
var statearr_24114_24178 = state_24066__$1;
(statearr_24114_24178[(1)] = (11));

} else {
var statearr_24115_24179 = state_24066__$1;
(statearr_24115_24179[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (5))){
var _ = (function (){var statearr_24116 = state_24066;
(statearr_24116[(4)] = cljs.core.rest((state_24066[(4)])));

return statearr_24116;
})();
var state_24066__$1 = state_24066;
var ex24111 = (state_24066__$1[(2)]);
var statearr_24117_24180 = state_24066__$1;
(statearr_24117_24180[(5)] = ex24111);


if((ex24111 instanceof Error)){
var statearr_24118_24181 = state_24066__$1;
(statearr_24118_24181[(1)] = (4));

(statearr_24118_24181[(5)] = null);

} else {
throw ex24111;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (14))){
var inst_23919 = (state_24066[(7)]);
var inst_23925 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_23919);
var inst_23926 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_23925)].join('');
var inst_23927 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_23928 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_23929 = cljs.core.PersistentHashMap.fromArrays(inst_23927,inst_23928);
var inst_23930 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_23926,inst_23929);
var inst_23931 = (function(){throw inst_23930})();
var state_24066__$1 = state_24066;
var statearr_24119_24182 = state_24066__$1;
(statearr_24119_24182[(2)] = inst_23931);

(statearr_24119_24182[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (45))){
var inst_24046 = (state_24066[(12)]);
var state_24066__$1 = state_24066;
var statearr_24120_24183 = state_24066__$1;
(statearr_24120_24183[(2)] = inst_24046);

(statearr_24120_24183[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (26))){
var inst_23919 = (state_24066[(7)]);
var inst_23921 = (state_24066[(8)]);
var inst_23975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23976 = [inst_23919,inst_23921];
var inst_23977 = (new cljs.core.PersistentVector(null,2,(5),inst_23975,inst_23976,null));
var inst_23978 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23979 = [inst_23919];
var inst_23980 = (new cljs.core.PersistentVector(null,1,(5),inst_23978,inst_23979,null));
var inst_23981 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_23977,cljs.core._LT__EQ_,inst_23980);
var state_24066__$1 = state_24066;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24066__$1,(29),inst_23981);
} else {
if((state_val_24067 === (16))){
var inst_23938 = (state_24066[(10)]);
var inst_23920 = (state_24066[(11)]);
var inst_23934 = (state_24066[(2)]);
var inst_23938__$1 = cljs.core.identical_QMARK_;
var inst_23939 = (inst_23938__$1.cljs$core$IFn$_invoke$arity$2 ? inst_23938__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_23920) : inst_23938__$1.call(null,cljs.core.not_EQ_,inst_23920));
var state_24066__$1 = (function (){var statearr_24121 = state_24066;
(statearr_24121[(10)] = inst_23938__$1);

(statearr_24121[(22)] = inst_23934);

return statearr_24121;
})();
if(cljs.core.truth_(inst_23939)){
var statearr_24122_24184 = state_24066__$1;
(statearr_24122_24184[(1)] = (17));

} else {
var statearr_24123_24185 = state_24066__$1;
(statearr_24123_24185[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (38))){
var inst_23919 = (state_24066[(7)]);
var inst_23921 = (state_24066[(8)]);
var inst_24014 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24015 = [inst_23919];
var inst_24016 = (new cljs.core.PersistentVector(null,1,(5),inst_24014,inst_24015,null));
var inst_24017 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24018 = [inst_23919,inst_23921];
var inst_24019 = (new cljs.core.PersistentVector(null,2,(5),inst_24017,inst_24018,null));
var inst_24020 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_24016,cljs.core._LT__EQ_,inst_24019);
var state_24066__$1 = state_24066;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24066__$1,(41),inst_24020);
} else {
if((state_val_24067 === (30))){
var inst_23919 = (state_24066[(7)]);
var inst_23921 = (state_24066[(8)]);
var inst_23988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23989 = [inst_23919,inst_23921];
var inst_23990 = (new cljs.core.PersistentVector(null,2,(5),inst_23988,inst_23989,null));
var inst_23991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23992 = [inst_23919];
var inst_23993 = (new cljs.core.PersistentVector(null,1,(5),inst_23991,inst_23992,null));
var inst_23994 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23990,cljs.core._LT__EQ_,inst_23993);
var state_24066__$1 = state_24066;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24066__$1,(33),inst_23994);
} else {
if((state_val_24067 === (10))){
var inst_24058 = (state_24066[(2)]);
var state_24066__$1 = state_24066;
var statearr_24124_24186 = state_24066__$1;
(statearr_24124_24186[(2)] = inst_24058);

(statearr_24124_24186[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (18))){
var inst_23938 = (state_24066[(10)]);
var inst_23920 = (state_24066[(11)]);
var inst_23963 = (inst_23938.cljs$core$IFn$_invoke$arity$2 ? inst_23938.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_23920) : inst_23938.call(null,cljs.core._EQ_,inst_23920));
var state_24066__$1 = state_24066;
if(cljs.core.truth_(inst_23963)){
var statearr_24125_24187 = state_24066__$1;
(statearr_24125_24187[(1)] = (22));

} else {
var statearr_24126_24188 = state_24066__$1;
(statearr_24126_24188[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (42))){
var inst_24046 = (state_24066[(12)]);
var inst_23889 = (state_24066[(21)]);
var inst_24046__$1 = (state_24066[(2)]);
var inst_24047 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"and","and",-971899817),inst_23889);
var inst_24048 = cljs.core.empty_QMARK_(inst_24046__$1);
var inst_24049 = ((inst_24047) && (inst_24048));
var state_24066__$1 = (function (){var statearr_24127 = state_24066;
(statearr_24127[(12)] = inst_24046__$1);

return statearr_24127;
})();
if(cljs.core.truth_(inst_24049)){
var statearr_24128_24189 = state_24066__$1;
(statearr_24128_24189[(1)] = (45));

} else {
var statearr_24129_24190 = state_24066__$1;
(statearr_24129_24190[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (37))){
var inst_24009 = (state_24066[(2)]);
var inst_24010 = fluree.db.util.async.throw_err(inst_24009);
var state_24066__$1 = state_24066;
var statearr_24130_24191 = state_24066__$1;
(statearr_24130_24191[(2)] = inst_24010);

(statearr_24130_24191[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24067 === (8))){
var inst_24061 = (state_24066[(2)]);
var _ = (function (){var statearr_24131 = state_24066;
(statearr_24131[(4)] = cljs.core.rest((state_24066[(4)])));

return statearr_24131;
})();
var state_24066__$1 = state_24066;
var statearr_24132_24192 = state_24066__$1;
(statearr_24132_24192[(2)] = inst_24061);

(statearr_24132_24192[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2879__auto__ = null;
var fluree$db$query$fql$state_machine__2879__auto____0 = (function (){
var statearr_24133 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24133[(0)] = fluree$db$query$fql$state_machine__2879__auto__);

(statearr_24133[(1)] = (1));

return statearr_24133;
});
var fluree$db$query$fql$state_machine__2879__auto____1 = (function (state_24066){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_24066);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e24134){var ex__2882__auto__ = e24134;
var statearr_24135_24193 = state_24066;
(statearr_24135_24193[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_24066[(4)]))){
var statearr_24136_24194 = state_24066;
(statearr_24136_24194[(1)] = cljs.core.first((state_24066[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24195 = state_24066;
state_24066 = G__24195;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2879__auto__ = function(state_24066){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2879__auto____1.call(this,state_24066);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2879__auto____0;
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2879__auto____1;
return fluree$db$query$fql$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_24137 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_24137[(6)] = c__2901__auto__);

return statearr_24137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

/**
 * Order By can be:
 *  - Single variable, ?favNums
 *  - Two-tuple,  [ASC, ?favNums]
 */
fluree.db.query.fql.order_offset_and_limit_results = (function fluree$db$query$fql$order_offset_and_limit_results(tuples,headers,orderBy,offset,limit){
var vec__24197 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24197,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24197,(1),null);
var indexOfFind = (function (){var or__4126__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (-1);
}
})();
var tuples_SINGLEQUOTE_ = ((((0) <= indexOfFind))?(function (){var G__24200 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__24196_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__24196_SHARP_,indexOfFind);
}),fluree.db.query.fql.compare_fn,tuples);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order)){
return cljs.core.reverse(G__24200);
} else {
return G__24200;
}
})():tuples);
var G__24201 = tuples_SINGLEQUOTE_;
var G__24201__$1 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__24201):G__24201);
var G__24201__$2 = (cljs.core.truth_(limit)?cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__24201__$1):G__24201__$1);
if(cljs.core.vector_QMARK_(tuples)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,G__24201__$2);
} else {
return G__24201__$2;
}
});
fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4126__auto__ = cljs.core.every_QMARK_((function (p1__24202_SHARP_){
return ((typeof p1__24202_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__24202_SHARP_)));
}),select_smt);
if(or__4126__auto__){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__24203_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__24203_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__24207 = vars;
var vec__24208 = G__24207;
var seq__24209 = cljs.core.seq(vec__24208);
var first__24210 = cljs.core.first(seq__24209);
var seq__24209__$1 = cljs.core.next(seq__24209);
var var$ = first__24210;
var r = seq__24209__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24207__$1 = G__24207;
var all_vars__$1 = all_vars;
while(true){
var vec__24215 = G__24207__$1;
var seq__24216 = cljs.core.seq(vec__24215);
var first__24217 = cljs.core.first(seq__24216);
var seq__24216__$1 = cljs.core.next(seq__24216);
var var$__$1 = first__24217;
var r__$1 = seq__24216__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__24218 = cljs.core.set(all_vars__$2);
return (fexpr__24218.cljs$core$IFn$_invoke$arity$1 ? fexpr__24218.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__24218.call(null,var$__$1));
})())){
var G__24219 = r__$1;
var G__24220 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__24207__$1 = G__24219;
all_vars__$1 = G__24220;
continue;
} else {
var G__24221 = r__$1;
var G__24222 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__24207__$1 = G__24221;
all_vars__$1 = G__24222;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_24257){
var state_val_24258 = (state_24257[(1)]);
if((state_val_24258 === (1))){
var inst_24230 = functionArray;
var inst_24231 = cljs.core.seq(inst_24230);
var inst_24232 = cljs.core.first(inst_24231);
var inst_24233 = cljs.core.next(inst_24231);
var inst_24234 = cljs.core.PersistentVector.EMPTY;
var inst_24235 = inst_24230;
var inst_24236 = inst_24234;
var state_24257__$1 = (function (){var statearr_24259 = state_24257;
(statearr_24259[(7)] = inst_24235);

(statearr_24259[(8)] = inst_24232);

(statearr_24259[(9)] = inst_24233);

(statearr_24259[(10)] = inst_24236);

return statearr_24259;
})();
var statearr_24260_24273 = state_24257__$1;
(statearr_24260_24273[(2)] = null);

(statearr_24260_24273[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24258 === (2))){
var inst_24235 = (state_24257[(7)]);
var inst_24242 = (state_24257[(11)]);
var inst_24241 = cljs.core.seq(inst_24235);
var inst_24242__$1 = cljs.core.first(inst_24241);
var inst_24243 = cljs.core.next(inst_24241);
var state_24257__$1 = (function (){var statearr_24261 = state_24257;
(statearr_24261[(12)] = inst_24243);

(statearr_24261[(11)] = inst_24242__$1);

return statearr_24261;
})();
if(cljs.core.truth_(inst_24242__$1)){
var statearr_24262_24274 = state_24257__$1;
(statearr_24262_24274[(1)] = (4));

} else {
var statearr_24263_24275 = state_24257__$1;
(statearr_24263_24275[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24258 === (3))){
var inst_24255 = (state_24257[(2)]);
var state_24257__$1 = state_24257;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24257__$1,inst_24255);
} else {
if((state_val_24258 === (4))){
var inst_24242 = (state_24257[(11)]);
var inst_24245 = (inst_24242.cljs$core$IFn$_invoke$arity$1 ? inst_24242.cljs$core$IFn$_invoke$arity$1(tuple) : inst_24242.call(null,tuple));
var state_24257__$1 = state_24257;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24257__$1,(7),inst_24245);
} else {
if((state_val_24258 === (5))){
var inst_24236 = (state_24257[(10)]);
var state_24257__$1 = state_24257;
var statearr_24264_24276 = state_24257__$1;
(statearr_24264_24276[(2)] = inst_24236);

(statearr_24264_24276[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24258 === (6))){
var inst_24253 = (state_24257[(2)]);
var state_24257__$1 = state_24257;
var statearr_24265_24277 = state_24257__$1;
(statearr_24265_24277[(2)] = inst_24253);

(statearr_24265_24277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24258 === (7))){
var inst_24243 = (state_24257[(12)]);
var inst_24236 = (state_24257[(10)]);
var inst_24247 = (state_24257[(2)]);
var inst_24248 = fluree.db.util.async.throw_err(inst_24247);
var inst_24249 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24236,inst_24248);
var inst_24235 = inst_24243;
var inst_24236__$1 = inst_24249;
var state_24257__$1 = (function (){var statearr_24266 = state_24257;
(statearr_24266[(7)] = inst_24235);

(statearr_24266[(10)] = inst_24236__$1);

return statearr_24266;
})();
var statearr_24267_24278 = state_24257__$1;
(statearr_24267_24278[(2)] = null);

(statearr_24267_24278[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__2879__auto____0 = (function (){
var statearr_24268 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24268[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__2879__auto__);

(statearr_24268[(1)] = (1));

return statearr_24268;
});
var fluree$db$query$fql$format_tuple_$_state_machine__2879__auto____1 = (function (state_24257){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_24257);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e24269){var ex__2882__auto__ = e24269;
var statearr_24270_24279 = state_24257;
(statearr_24270_24279[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_24257[(4)]))){
var statearr_24271_24280 = state_24257;
(statearr_24271_24280[(1)] = cljs.core.first((state_24257[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24281 = state_24257;
state_24257 = G__24281;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__2879__auto__ = function(state_24257){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__2879__auto____1.call(this,state_24257);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__2879__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__2879__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_24272 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_24272[(6)] = c__2901__auto__);

return statearr_24272;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 * 
 *   TODO - this uses a 'functionArray' of pre-defined functions that take a single tuple argument
 *     - I think this could be done more cleanly and possibly efficiently, so refactor another day.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(tuples,functionArray,inVector_QMARK_,pretty_print,parallelism){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_24323){
var state_val_24324 = (state_24323[(1)]);
if((state_val_24324 === (7))){
var inst_24318 = (state_24323[(2)]);
var _ = (function (){var statearr_24325 = state_24323;
(statearr_24325[(4)] = cljs.core.rest((state_24323[(4)])));

return statearr_24325;
})();
var state_24323__$1 = state_24323;
var statearr_24326_24407 = state_24323__$1;
(statearr_24326_24407[(2)] = inst_24318);

(statearr_24326_24407[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (1))){
var state_24323__$1 = state_24323;
var statearr_24327_24408 = state_24323__$1;
(statearr_24327_24408[(2)] = null);

(statearr_24327_24408[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (4))){
var inst_24282 = (state_24323[(2)]);
var state_24323__$1 = state_24323;
var statearr_24328_24409 = state_24323__$1;
(statearr_24328_24409[(2)] = inst_24282);

(statearr_24328_24409[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (15))){
var inst_24297 = (state_24323[(7)]);
var inst_24294 = (state_24323[(8)]);
var inst_24308 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_24294,inst_24297);
var inst_24294__$1 = inst_24308;
var state_24323__$1 = (function (){var statearr_24329 = state_24323;
(statearr_24329[(8)] = inst_24294__$1);

return statearr_24329;
})();
var statearr_24330_24410 = state_24323__$1;
(statearr_24330_24410[(2)] = null);

(statearr_24330_24410[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (13))){
var state_24323__$1 = state_24323;
var statearr_24331_24411 = state_24323__$1;
(statearr_24331_24411[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (6))){
var inst_24289 = (state_24323[(9)]);
var state_24323__$1 = state_24323;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24323__$1,(8),inst_24289);
} else {
if((state_val_24324 === (17))){
var inst_24312 = (state_24323[(2)]);
var state_24323__$1 = state_24323;
var statearr_24333_24412 = state_24323__$1;
(statearr_24333_24412[(2)] = inst_24312);

(statearr_24333_24412[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (3))){
var inst_24321 = (state_24323[(2)]);
var state_24323__$1 = state_24323;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24323__$1,inst_24321);
} else {
if((state_val_24324 === (12))){
var inst_24289 = (state_24323[(9)]);
var inst_24288 = (state_24323[(10)]);
var inst_24297 = (state_24323[(7)]);
var inst_24303 = cljs.core.async.close_BANG_(inst_24288);
var inst_24304 = cljs.core.async.close_BANG_(inst_24289);
var inst_24305 = (function(){throw inst_24297})();
var state_24323__$1 = (function (){var statearr_24334 = state_24323;
(statearr_24334[(11)] = inst_24303);

(statearr_24334[(12)] = inst_24304);

return statearr_24334;
})();
var statearr_24335_24413 = state_24323__$1;
(statearr_24335_24413[(2)] = inst_24305);

(statearr_24335_24413[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (2))){
var inst_24289 = (state_24323[(9)]);
var inst_24288 = (state_24323[(10)]);
var _ = (function (){var statearr_24336 = state_24323;
(statearr_24336[(4)] = cljs.core.cons((5),(state_24323[(4)])));

return statearr_24336;
})();
var inst_24288__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24289__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_24290 = (function (){var queue_ch = inst_24288__$1;
var res_ch = inst_24289__$1;
return (function (tuple,port){
var c__2901__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_24362){
var state_val_24363 = (state_24362[(1)]);
if((state_val_24363 === (7))){
var state_24362__$1 = state_24362;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24364_24414 = state_24362__$1;
(statearr_24364_24414[(1)] = (9));

} else {
var statearr_24365_24415 = state_24362__$1;
(statearr_24365_24415[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24363 === (1))){
var inst_24337 = fluree.db.query.fql.format_tuple(functionArray,tuple);
var state_24362__$1 = state_24362;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24362__$1,(2),inst_24337);
} else {
if((state_val_24363 === (4))){
var state_24362__$1 = state_24362;
if(cljs.core.truth_(pretty_print)){
var statearr_24366_24416 = state_24362__$1;
(statearr_24366_24416[(1)] = (6));

} else {
var statearr_24367_24417 = state_24362__$1;
(statearr_24367_24417[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24363 === (13))){
var state_24362__$1 = state_24362;
var statearr_24368_24418 = state_24362__$1;
(statearr_24368_24418[(2)] = null);

(statearr_24368_24418[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24363 === (6))){
var inst_24339 = (state_24362[(7)]);
var inst_24344 = cljs.core.zipmap(pretty_print,inst_24339);
var state_24362__$1 = state_24362;
var statearr_24369_24419 = state_24362__$1;
(statearr_24369_24419[(2)] = inst_24344);

(statearr_24369_24419[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24363 === (3))){
var inst_24339 = (state_24362[(7)]);
var state_24362__$1 = state_24362;
var statearr_24370_24420 = state_24362__$1;
(statearr_24370_24420[(2)] = inst_24339);

(statearr_24370_24420[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24363 === (12))){
var inst_24339 = (state_24362[(7)]);
var inst_24349 = cljs.core.first(inst_24339);
var state_24362__$1 = state_24362;
var statearr_24371_24421 = state_24362__$1;
(statearr_24371_24421[(2)] = inst_24349);

(statearr_24371_24421[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24363 === (2))){
var inst_24339 = (state_24362[(7)]);
var inst_24339__$1 = (state_24362[(2)]);
var inst_24340 = fluree.db.util.core.exception_QMARK_(inst_24339__$1);
var state_24362__$1 = (function (){var statearr_24372 = state_24362;
(statearr_24372[(7)] = inst_24339__$1);

return statearr_24372;
})();
if(inst_24340){
var statearr_24373_24422 = state_24362__$1;
(statearr_24373_24422[(1)] = (3));

} else {
var statearr_24374_24423 = state_24362__$1;
(statearr_24374_24423[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24363 === (11))){
var inst_24354 = (state_24362[(2)]);
var state_24362__$1 = state_24362;
var statearr_24375_24424 = state_24362__$1;
(statearr_24375_24424[(2)] = inst_24354);

(statearr_24375_24424[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24363 === (9))){
var inst_24339 = (state_24362[(7)]);
var state_24362__$1 = state_24362;
var statearr_24376_24425 = state_24362__$1;
(statearr_24376_24425[(2)] = inst_24339);

(statearr_24376_24425[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24363 === (5))){
var inst_24358 = (state_24362[(2)]);
var inst_24359 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_24358);
var inst_24360 = cljs.core.async.close_BANG_(port);
var state_24362__$1 = (function (){var statearr_24377 = state_24362;
(statearr_24377[(8)] = inst_24359);

return statearr_24377;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_24362__$1,inst_24360);
} else {
if((state_val_24363 === (14))){
var inst_24352 = (state_24362[(2)]);
var state_24362__$1 = state_24362;
var statearr_24378_24426 = state_24362__$1;
(statearr_24378_24426[(2)] = inst_24352);

(statearr_24378_24426[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24363 === (10))){
var state_24362__$1 = state_24362;
var statearr_24379_24427 = state_24362__$1;
(statearr_24379_24427[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24363 === (8))){
var inst_24356 = (state_24362[(2)]);
var state_24362__$1 = state_24362;
var statearr_24381_24428 = state_24362__$1;
(statearr_24381_24428[(2)] = inst_24356);

(statearr_24381_24428[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____0 = (function (){
var statearr_24382 = [null,null,null,null,null,null,null,null,null];
(statearr_24382[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__);

(statearr_24382[(1)] = (1));

return statearr_24382;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____1 = (function (state_24362){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_24362);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e24383){var ex__2882__auto__ = e24383;
var statearr_24384_24429 = state_24362;
(statearr_24384_24429[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_24362[(4)]))){
var statearr_24385_24430 = state_24362;
(statearr_24385_24430[(1)] = cljs.core.first((state_24362[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24431 = state_24362;
state_24362 = G__24431;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__ = function(state_24362){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____1.call(this,state_24362);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_24386 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_24386[(6)] = c__2901__auto____$1);

return statearr_24386;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto____$1;
});
})();
var inst_24291 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_24288__$1,tuples);
var inst_24292 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_24289__$1,inst_24290,inst_24288__$1);
var inst_24293 = cljs.core.PersistentVector.EMPTY;
var inst_24294 = inst_24293;
var state_24323__$1 = (function (){var statearr_24387 = state_24323;
(statearr_24387[(9)] = inst_24289__$1);

(statearr_24387[(10)] = inst_24288__$1);

(statearr_24387[(8)] = inst_24294);

(statearr_24387[(13)] = inst_24292);

(statearr_24387[(14)] = inst_24291);

return statearr_24387;
})();
var statearr_24388_24432 = state_24323__$1;
(statearr_24388_24432[(2)] = null);

(statearr_24388_24432[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (11))){
var inst_24316 = (state_24323[(2)]);
var state_24323__$1 = state_24323;
var statearr_24390_24433 = state_24323__$1;
(statearr_24390_24433[(2)] = inst_24316);

(statearr_24390_24433[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (9))){
var inst_24294 = (state_24323[(8)]);
var state_24323__$1 = state_24323;
var statearr_24391_24434 = state_24323__$1;
(statearr_24391_24434[(2)] = inst_24294);

(statearr_24391_24434[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (5))){
var _ = (function (){var statearr_24392 = state_24323;
(statearr_24392[(4)] = cljs.core.rest((state_24323[(4)])));

return statearr_24392;
})();
var state_24323__$1 = state_24323;
var ex24389 = (state_24323__$1[(2)]);
var statearr_24393_24435 = state_24323__$1;
(statearr_24393_24435[(5)] = ex24389);


if((ex24389 instanceof Error)){
var statearr_24394_24436 = state_24323__$1;
(statearr_24394_24436[(1)] = (4));

(statearr_24394_24436[(5)] = null);

} else {
throw ex24389;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (14))){
var inst_24314 = (state_24323[(2)]);
var state_24323__$1 = state_24323;
var statearr_24395_24437 = state_24323__$1;
(statearr_24395_24437[(2)] = inst_24314);

(statearr_24395_24437[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (16))){
var state_24323__$1 = state_24323;
var statearr_24396_24438 = state_24323__$1;
(statearr_24396_24438[(2)] = null);

(statearr_24396_24438[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (10))){
var inst_24297 = (state_24323[(7)]);
var inst_24301 = fluree.db.util.core.exception_QMARK_(inst_24297);
var state_24323__$1 = state_24323;
if(inst_24301){
var statearr_24397_24439 = state_24323__$1;
(statearr_24397_24439[(1)] = (12));

} else {
var statearr_24398_24440 = state_24323__$1;
(statearr_24398_24440[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24324 === (8))){
var inst_24297 = (state_24323[(7)]);
var inst_24297__$1 = (state_24323[(2)]);
var inst_24298 = (inst_24297__$1 == null);
var state_24323__$1 = (function (){var statearr_24399 = state_24323;
(statearr_24399[(7)] = inst_24297__$1);

return statearr_24399;
})();
if(cljs.core.truth_(inst_24298)){
var statearr_24400_24441 = state_24323__$1;
(statearr_24400_24441[(1)] = (9));

} else {
var statearr_24401_24442 = state_24323__$1;
(statearr_24401_24442[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____0 = (function (){
var statearr_24402 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24402[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__);

(statearr_24402[(1)] = (1));

return statearr_24402;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____1 = (function (state_24323){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_24323);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e24403){var ex__2882__auto__ = e24403;
var statearr_24404_24443 = state_24323;
(statearr_24404_24443[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_24323[(4)]))){
var statearr_24405_24444 = state_24323;
(statearr_24405_24444[(1)] = cljs.core.first((state_24323[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24445 = state_24323;
state_24323 = G__24445;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__ = function(state_24323){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____1.call(this,state_24323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_24406 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_24406[(6)] = c__2901__auto__);

return statearr_24406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.fql.format_filter_tuples = (function fluree$db$query$fql$format_filter_tuples(db,tuples,p__24447,headers,vars,opts){
var map__24448 = p__24447;
var map__24448__$1 = (((((!((map__24448 == null))))?(((((map__24448.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24448.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24448):map__24448);
var select_spec = map__24448__$1;
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24448__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24448__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24448__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24448__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_24483){
var state_val_24484 = (state_24483[(1)]);
if((state_val_24484 === (7))){
var state_24483__$1 = state_24483;
var statearr_24485_24598 = state_24483__$1;
(statearr_24485_24598[(2)] = null);

(statearr_24485_24598[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (1))){
var state_24483__$1 = state_24483;
var statearr_24486_24599 = state_24483__$1;
(statearr_24486_24599[(2)] = null);

(statearr_24486_24599[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (4))){
var inst_24450 = (state_24483[(2)]);
var state_24483__$1 = state_24483;
var statearr_24487_24600 = state_24483__$1;
(statearr_24487_24600[(2)] = inst_24450);

(statearr_24487_24600[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (15))){
var inst_24472 = (state_24483[(2)]);
var inst_24473 = fluree.db.util.async.throw_err(inst_24472);
var state_24483__$1 = state_24483;
var statearr_24488_24601 = state_24483__$1;
(statearr_24488_24601[(2)] = inst_24473);

(statearr_24488_24601[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (13))){
var inst_24468 = (state_24483[(7)]);
var inst_24460 = (state_24483[(8)]);
var inst_24475 = (function (){var pp = inst_24460;
var functionArray = inst_24468;
return (function (tuple){
var tuple_res = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__24446_SHARP_){
return (p1__24446_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__24446_SHARP_.cljs$core$IFn$_invoke$arity$1(tuple) : p1__24446_SHARP_.call(null,tuple));
}),functionArray);
if(cljs.core.truth_(pp)){
return cljs.core.zipmap(pp,tuple_res);
} else {
if(cljs.core.truth_(inVector_QMARK_)){
return tuple_res;
} else {
return cljs.core.first(tuple_res);

}
}
});
})();
var inst_24476 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_24475,tuples);
var state_24483__$1 = state_24483;
var statearr_24489_24602 = state_24483__$1;
(statearr_24489_24602[(2)] = inst_24476);

(statearr_24489_24602[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (6))){
var inst_24457 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_24483__$1 = state_24483;
var statearr_24490_24603 = state_24483__$1;
(statearr_24490_24603[(2)] = inst_24457);

(statearr_24490_24603[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (3))){
var inst_24481 = (state_24483[(2)]);
var state_24483__$1 = state_24483;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24483__$1,inst_24481);
} else {
if((state_val_24484 === (12))){
var inst_24468 = (state_24483[(7)]);
var inst_24460 = (state_24483[(8)]);
var inst_24470 = fluree.db.query.fql.pipeline_expandmaps_result(tuples,inst_24468,inVector_QMARK_,inst_24460,(8));
var state_24483__$1 = state_24483;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24483__$1,(15),inst_24470);
} else {
if((state_val_24484 === (2))){
var _ = (function (){var statearr_24491 = state_24483;
(statearr_24491[(4)] = cljs.core.cons((5),(state_24483[(4)])));

return statearr_24491;
})();
var state_24483__$1 = state_24483;
if(cljs.core.truth_(prettyPrint)){
var statearr_24492_24604 = state_24483__$1;
(statearr_24492_24604[(1)] = (6));

} else {
var statearr_24493_24605 = state_24483__$1;
(statearr_24493_24605[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (11))){
var inst_24468 = (state_24483[(2)]);
var state_24483__$1 = (function (){var statearr_24495 = state_24483;
(statearr_24495[(7)] = inst_24468);

return statearr_24495;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24496_24606 = state_24483__$1;
(statearr_24496_24606[(1)] = (12));

} else {
var statearr_24497_24607 = state_24483__$1;
(statearr_24497_24607[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (9))){
var inst_24460 = (state_24483[(8)]);
var inst_24462 = (function (){var pp = inst_24460;
return (function (select__$1){
var select_val = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1);
}
})();
var idx = (cljs.core.truth_(select_val)?fluree.db.util.core.index_of(headers,select_val):null);
var select_fn = (cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1))?(function (tuple){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?(function (tuple){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val);
}):null)));
if(cljs.core.truth_(new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select__$1))){
return (function (tuple){
var c__2901__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_24530){
var state_val_24531 = (state_24530[(1)]);
if((state_val_24531 === (7))){
var state_24530__$1 = state_24530;
var statearr_24532_24608 = state_24530__$1;
(statearr_24532_24608[(2)] = null);

(statearr_24532_24608[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24531 === (1))){
var state_24530__$1 = state_24530;
var statearr_24533_24609 = state_24530__$1;
(statearr_24533_24609[(2)] = null);

(statearr_24533_24609[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24531 === (4))){
var inst_24498 = (state_24530[(2)]);
var state_24530__$1 = state_24530;
var statearr_24534_24610 = state_24530__$1;
(statearr_24534_24610[(2)] = inst_24498);

(statearr_24534_24610[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24531 === (6))){
var inst_24504 = (state_24530[(7)]);
var inst_24508 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24509 = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select__$1);
var inst_24510 = [inst_24509,inst_24504,opts];
var inst_24511 = cljs.core.PersistentHashMap.fromArrays(inst_24508,inst_24510);
var inst_24512 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_24511) : fluree.db.query.fql.query.call(null,db,inst_24511));
var state_24530__$1 = state_24530;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24530__$1,(9),inst_24512);
} else {
if((state_val_24531 === (3))){
var inst_24528 = (state_24530[(2)]);
var state_24530__$1 = state_24530;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24530__$1,inst_24528);
} else {
if((state_val_24531 === (12))){
var inst_24522 = (state_24530[(2)]);
var state_24530__$1 = state_24530;
var statearr_24535_24611 = state_24530__$1;
(statearr_24535_24611[(2)] = inst_24522);

(statearr_24535_24611[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24531 === (2))){
var inst_24504 = (state_24530[(7)]);
var _ = (function (){var statearr_24536 = state_24530;
(statearr_24536[(4)] = cljs.core.cons((5),(state_24530[(4)])));

return statearr_24536;
})();
var inst_24504__$1 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var state_24530__$1 = (function (){var statearr_24537 = state_24530;
(statearr_24537[(7)] = inst_24504__$1);

return statearr_24537;
})();
if(cljs.core.truth_(inst_24504__$1)){
var statearr_24538_24612 = state_24530__$1;
(statearr_24538_24612[(1)] = (6));

} else {
var statearr_24539_24613 = state_24530__$1;
(statearr_24539_24613[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24531 === (11))){
var inst_24504 = (state_24530[(7)]);
var inst_24518 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_24519 = [inst_24504];
var inst_24520 = cljs.core.PersistentHashMap.fromArrays(inst_24518,inst_24519);
var state_24530__$1 = state_24530;
var statearr_24541_24614 = state_24530__$1;
(statearr_24541_24614[(2)] = inst_24520);

(statearr_24541_24614[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24531 === (9))){
var inst_24515 = (state_24530[(8)]);
var inst_24514 = (state_24530[(2)]);
var inst_24515__$1 = fluree.db.util.async.throw_err(inst_24514);
var state_24530__$1 = (function (){var statearr_24542 = state_24530;
(statearr_24542[(8)] = inst_24515__$1);

return statearr_24542;
})();
if(cljs.core.truth_(inst_24515__$1)){
var statearr_24543_24615 = state_24530__$1;
(statearr_24543_24615[(1)] = (10));

} else {
var statearr_24544_24616 = state_24530__$1;
(statearr_24544_24616[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24531 === (5))){
var _ = (function (){var statearr_24545 = state_24530;
(statearr_24545[(4)] = cljs.core.rest((state_24530[(4)])));

return statearr_24545;
})();
var state_24530__$1 = state_24530;
var ex24540 = (state_24530__$1[(2)]);
var statearr_24546_24617 = state_24530__$1;
(statearr_24546_24617[(5)] = ex24540);


if((ex24540 instanceof Error)){
var statearr_24547_24618 = state_24530__$1;
(statearr_24547_24618[(1)] = (4));

(statearr_24547_24618[(5)] = null);

} else {
throw ex24540;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24531 === (10))){
var inst_24515 = (state_24530[(8)]);
var state_24530__$1 = state_24530;
var statearr_24548_24619 = state_24530__$1;
(statearr_24548_24619[(2)] = inst_24515);

(statearr_24548_24619[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24531 === (8))){
var inst_24525 = (state_24530[(2)]);
var _ = (function (){var statearr_24549 = state_24530;
(statearr_24549[(4)] = cljs.core.rest((state_24530[(4)])));

return statearr_24549;
})();
var state_24530__$1 = state_24530;
var statearr_24550_24620 = state_24530__$1;
(statearr_24550_24620[(2)] = inst_24525);

(statearr_24550_24620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____0 = (function (){
var statearr_24551 = [null,null,null,null,null,null,null,null,null];
(statearr_24551[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__);

(statearr_24551[(1)] = (1));

return statearr_24551;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____1 = (function (state_24530){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_24530);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e24552){var ex__2882__auto__ = e24552;
var statearr_24553_24621 = state_24530;
(statearr_24553_24621[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_24530[(4)]))){
var statearr_24554_24622 = state_24530;
(statearr_24554_24622[(1)] = cljs.core.first((state_24530[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24623 = state_24530;
state_24530 = G__24623;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__ = function(state_24530){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____1.call(this,state_24530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_24555 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_24555[(6)] = c__2901__auto____$1);

return statearr_24555;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto____$1;
});
} else {
return (function (tuple){
var c__2901__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_24567){
var state_val_24568 = (state_24567[(1)]);
if((state_val_24568 === (1))){
var state_24567__$1 = state_24567;
var statearr_24569_24624 = state_24567__$1;
(statearr_24569_24624[(2)] = null);

(statearr_24569_24624[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24568 === (2))){
var _ = (function (){var statearr_24570 = state_24567;
(statearr_24570[(4)] = cljs.core.cons((5),(state_24567[(4)])));

return statearr_24570;
})();
var inst_24562 = (select_fn.cljs$core$IFn$_invoke$arity$1 ? select_fn.cljs$core$IFn$_invoke$arity$1(tuple) : select_fn.call(null,tuple));
var ___$1 = (function (){var statearr_24571 = state_24567;
(statearr_24571[(4)] = cljs.core.rest((state_24567[(4)])));

return statearr_24571;
})();
var state_24567__$1 = state_24567;
var statearr_24572_24625 = state_24567__$1;
(statearr_24572_24625[(2)] = inst_24562);

(statearr_24572_24625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24568 === (3))){
var inst_24565 = (state_24567[(2)]);
var state_24567__$1 = state_24567;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24567__$1,inst_24565);
} else {
if((state_val_24568 === (4))){
var inst_24556 = (state_24567[(2)]);
var state_24567__$1 = state_24567;
var statearr_24574_24626 = state_24567__$1;
(statearr_24574_24626[(2)] = inst_24556);

(statearr_24574_24626[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24568 === (5))){
var _ = (function (){var statearr_24575 = state_24567;
(statearr_24575[(4)] = cljs.core.rest((state_24567[(4)])));

return statearr_24575;
})();
var state_24567__$1 = state_24567;
var ex24573 = (state_24567__$1[(2)]);
var statearr_24576_24627 = state_24567__$1;
(statearr_24576_24627[(5)] = ex24573);


if((ex24573 instanceof Error)){
var statearr_24577_24628 = state_24567__$1;
(statearr_24577_24628[(1)] = (4));

(statearr_24577_24628[(5)] = null);

} else {
throw ex24573;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____0 = (function (){
var statearr_24578 = [null,null,null,null,null,null,null];
(statearr_24578[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__);

(statearr_24578[(1)] = (1));

return statearr_24578;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____1 = (function (state_24567){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_24567);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e24579){var ex__2882__auto__ = e24579;
var statearr_24580_24629 = state_24567;
(statearr_24580_24629[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_24567[(4)]))){
var statearr_24581_24630 = state_24567;
(statearr_24581_24630[(1)] = cljs.core.first((state_24567[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24631 = state_24567;
state_24567 = G__24631;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__ = function(state_24567){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____1.call(this,state_24567);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_24582 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_24582[(6)] = c__2901__auto____$1);

return statearr_24582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto____$1;
});
}
});
})();
var inst_24463 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_24462,select);
var state_24483__$1 = state_24483;
var statearr_24583_24632 = state_24483__$1;
(statearr_24583_24632[(2)] = inst_24463);

(statearr_24583_24632[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (5))){
var _ = (function (){var statearr_24584 = state_24483;
(statearr_24584[(4)] = cljs.core.rest((state_24483[(4)])));

return statearr_24584;
})();
var state_24483__$1 = state_24483;
var ex24494 = (state_24483__$1[(2)]);
var statearr_24585_24633 = state_24483__$1;
(statearr_24585_24633[(5)] = ex24494);


if((ex24494 instanceof Error)){
var statearr_24586_24634 = state_24483__$1;
(statearr_24586_24634[(1)] = (4));

(statearr_24586_24634[(5)] = null);

} else {
throw ex24494;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (14))){
var inst_24478 = (state_24483[(2)]);
var _ = (function (){var statearr_24587 = state_24483;
(statearr_24587[(4)] = cljs.core.rest((state_24483[(4)])));

return statearr_24587;
})();
var state_24483__$1 = state_24483;
var statearr_24588_24635 = state_24483__$1;
(statearr_24588_24635[(2)] = inst_24478);

(statearr_24588_24635[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (10))){
var inst_24460 = (state_24483[(8)]);
var inst_24465 = (function (){var pp = inst_24460;
return (function (select__$1){
var temp__5733__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(temp__5733__auto__)){
var val = temp__5733__auto__;
return (function (x){
return val;
});
} else {
var idx = fluree.db.query.fql.get_header_idx(headers,select__$1);
return (function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
});
}
});
})();
var inst_24466 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_24465,select);
var state_24483__$1 = state_24483;
var statearr_24589_24636 = state_24483__$1;
(statearr_24589_24636[(2)] = inst_24466);

(statearr_24589_24636[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24484 === (8))){
var inst_24460 = (state_24483[(2)]);
var state_24483__$1 = (function (){var statearr_24590 = state_24483;
(statearr_24590[(8)] = inst_24460);

return statearr_24590;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24591_24637 = state_24483__$1;
(statearr_24591_24637[(1)] = (9));

} else {
var statearr_24592_24638 = state_24483__$1;
(statearr_24592_24638[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____0 = (function (){
var statearr_24593 = [null,null,null,null,null,null,null,null,null];
(statearr_24593[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__);

(statearr_24593[(1)] = (1));

return statearr_24593;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____1 = (function (state_24483){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_24483);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e24594){var ex__2882__auto__ = e24594;
var statearr_24595_24639 = state_24483;
(statearr_24595_24639[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_24483[(4)]))){
var statearr_24596_24640 = state_24483;
(statearr_24596_24640[(1)] = cljs.core.first((state_24483[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24641 = state_24483;
state_24483 = G__24641;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__ = function(state_24483){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____1.call(this,state_24483);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_24597 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_24597[(6)] = c__2901__auto__);

return statearr_24597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24643 = arguments.length;
switch (G__24643) {
case 4:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4 = (function (db,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5 = (function (db,p__24644,p__24645,group_limit,opts){
var map__24646 = p__24644;
var map__24646__$1 = (((((!((map__24646 == null))))?(((((map__24646.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24646.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24646):map__24646);
var res = map__24646__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24646__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24647 = p__24645;
var map__24647__$1 = (((((!((map__24647 == null))))?(((((map__24647.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24647.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__24647):map__24647);
var select_spec = map__24647__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24647__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24647__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24647__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24647__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24647__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24647__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24647__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24647__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24647__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_24818){
var state_val_24819 = (state_24818[(1)]);
if((state_val_24819 === (65))){
var inst_24752 = (state_24818[(7)]);
var state_24818__$1 = state_24818;
var statearr_24820_24951 = state_24818__$1;
(statearr_24820_24951[(2)] = inst_24752);

(statearr_24820_24951[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (70))){
var inst_24774 = (state_24818[(8)]);
var inst_24782 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_24774);
var state_24818__$1 = state_24818;
var statearr_24821_24952 = state_24818__$1;
(statearr_24821_24952[(2)] = inst_24782);

(statearr_24821_24952[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (62))){
var inst_24752 = (state_24818[(7)]);
var state_24818__$1 = state_24818;
var statearr_24822_24953 = state_24818__$1;
(statearr_24822_24953[(2)] = inst_24752);

(statearr_24822_24953[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (74))){
var inst_24786 = (state_24818[(9)]);
var state_24818__$1 = state_24818;
var statearr_24823_24954 = state_24818__$1;
(statearr_24823_24954[(2)] = inst_24786);

(statearr_24823_24954[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (7))){
var inst_24656 = (state_24818[(10)]);
var state_24818__$1 = state_24818;
var statearr_24824_24955 = state_24818__$1;
(statearr_24824_24955[(2)] = inst_24656);

(statearr_24824_24955[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (59))){
var state_24818__$1 = state_24818;
var statearr_24825_24956 = state_24818__$1;
(statearr_24825_24956[(2)] = offset);

(statearr_24825_24956[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (20))){
var inst_24691 = (state_24818[(11)]);
var inst_24691__$1 = (state_24818[(2)]);
var inst_24693 = (inst_24691__$1 == null);
var inst_24694 = cljs.core.not(inst_24693);
var state_24818__$1 = (function (){var statearr_24826 = state_24818;
(statearr_24826[(11)] = inst_24691__$1);

return statearr_24826;
})();
if(inst_24694){
var statearr_24827_24957 = state_24818__$1;
(statearr_24827_24957[(1)] = (21));

} else {
var statearr_24828_24958 = state_24818__$1;
(statearr_24828_24958[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (72))){
var inst_24786 = (state_24818[(9)]);
var inst_24785 = (state_24818[(2)]);
var inst_24786__$1 = group_limit;
var state_24818__$1 = (function (){var statearr_24829 = state_24818;
(statearr_24829[(12)] = inst_24785);

(statearr_24829[(9)] = inst_24786__$1);

return statearr_24829;
})();
if(cljs.core.truth_(inst_24786__$1)){
var statearr_24830_24959 = state_24818__$1;
(statearr_24830_24959[(1)] = (73));

} else {
var statearr_24831_24960 = state_24818__$1;
(statearr_24831_24960[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (58))){
var inst_24758 = (state_24818[(13)]);
var state_24818__$1 = state_24818;
var statearr_24832_24961 = state_24818__$1;
(statearr_24832_24961[(2)] = inst_24758);

(statearr_24832_24961[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (60))){
var inst_24762 = (state_24818[(2)]);
var state_24818__$1 = state_24818;
var statearr_24833_24962 = state_24818__$1;
(statearr_24833_24962[(2)] = inst_24762);

(statearr_24833_24962[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (27))){
var inst_24691 = (state_24818[(11)]);
var inst_24709 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_24691);
var state_24818__$1 = state_24818;
var statearr_24834_24963 = state_24818__$1;
(statearr_24834_24963[(2)] = inst_24709);

(statearr_24834_24963[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (1))){
var state_24818__$1 = state_24818;
var statearr_24835_24964 = state_24818__$1;
(statearr_24835_24964[(2)] = null);

(statearr_24835_24964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (69))){
var inst_24780 = (state_24818[(2)]);
var state_24818__$1 = state_24818;
if(cljs.core.truth_(inst_24780)){
var statearr_24836_24965 = state_24818__$1;
(statearr_24836_24965[(1)] = (70));

} else {
var statearr_24837_24966 = state_24818__$1;
(statearr_24837_24966[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (24))){
var state_24818__$1 = state_24818;
var statearr_24838_24967 = state_24818__$1;
(statearr_24838_24967[(2)] = true);

(statearr_24838_24967[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (55))){
var inst_24758 = (state_24818[(13)]);
var inst_24758__$1 = group_limit;
var state_24818__$1 = (function (){var statearr_24839 = state_24818;
(statearr_24839[(13)] = inst_24758__$1);

return statearr_24839;
})();
if(cljs.core.truth_(inst_24758__$1)){
var statearr_24840_24968 = state_24818__$1;
(statearr_24840_24968[(1)] = (58));

} else {
var statearr_24841_24969 = state_24818__$1;
(statearr_24841_24969[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (39))){
var inst_24724 = (state_24818[(14)]);
var state_24818__$1 = state_24818;
var statearr_24842_24970 = state_24818__$1;
(statearr_24842_24970[(2)] = inst_24724);

(statearr_24842_24970[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (46))){
var state_24818__$1 = state_24818;
var statearr_24843_24971 = state_24818__$1;
(statearr_24843_24971[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (4))){
var inst_24650 = (state_24818[(2)]);
var state_24818__$1 = state_24818;
var statearr_24845_24972 = state_24818__$1;
(statearr_24845_24972[(2)] = inst_24650);

(statearr_24845_24972[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (77))){
var inst_24785 = (state_24818[(12)]);
var state_24818__$1 = state_24818;
var statearr_24846_24973 = state_24818__$1;
(statearr_24846_24973[(2)] = inst_24785);

(statearr_24846_24973[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (54))){
var inst_24767 = (state_24818[(2)]);
var state_24818__$1 = state_24818;
if(cljs.core.truth_(inst_24767)){
var statearr_24847_24974 = state_24818__$1;
(statearr_24847_24974[(1)] = (61));

} else {
var statearr_24848_24975 = state_24818__$1;
(statearr_24848_24975[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (15))){
var inst_24677 = (state_24818[(15)]);
var inst_24679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24680 = [inst_24677];
var inst_24681 = (new cljs.core.PersistentVector(null,1,(5),inst_24679,inst_24680,null));
var state_24818__$1 = state_24818;
var statearr_24849_24976 = state_24818__$1;
(statearr_24849_24976[(2)] = inst_24681);

(statearr_24849_24976[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (48))){
var inst_24724 = (state_24818[(14)]);
var state_24818__$1 = state_24818;
var statearr_24850_24977 = state_24818__$1;
(statearr_24850_24977[(2)] = inst_24724);

(statearr_24850_24977[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (50))){
var inst_24741 = (state_24818[(2)]);
var state_24818__$1 = state_24818;
var statearr_24851_24978 = state_24818__$1;
(statearr_24851_24978[(2)] = inst_24741);

(statearr_24851_24978[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (75))){
var inst_24791 = (state_24818[(2)]);
var state_24818__$1 = state_24818;
if(cljs.core.truth_(inst_24791)){
var statearr_24852_24979 = state_24818__$1;
(statearr_24852_24979[(1)] = (76));

} else {
var statearr_24853_24980 = state_24818__$1;
(statearr_24853_24980[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (21))){
var inst_24691 = (state_24818[(11)]);
var inst_24696 = inst_24691.cljs$lang$protocol_mask$partition0$;
var inst_24697 = (inst_24696 & (64));
var inst_24698 = inst_24691.cljs$core$ISeq$;
var inst_24699 = (cljs.core.PROTOCOL_SENTINEL === inst_24698);
var inst_24700 = ((inst_24697) || (inst_24699));
var state_24818__$1 = state_24818;
if(cljs.core.truth_(inst_24700)){
var statearr_24854_24981 = state_24818__$1;
(statearr_24854_24981[(1)] = (24));

} else {
var statearr_24855_24982 = state_24818__$1;
(statearr_24855_24982[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (31))){
var state_24818__$1 = state_24818;
var statearr_24856_24983 = state_24818__$1;
(statearr_24856_24983[(2)] = offset);

(statearr_24856_24983[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (32))){
var inst_24718 = (state_24818[(2)]);
var state_24818__$1 = (function (){var statearr_24857 = state_24818;
(statearr_24857[(16)] = inst_24718);

return statearr_24857;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24858_24984 = state_24818__$1;
(statearr_24858_24984[(1)] = (33));

} else {
var statearr_24859_24985 = state_24818__$1;
(statearr_24859_24985[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (40))){
var inst_24718 = (state_24818[(16)]);
var state_24818__$1 = state_24818;
if(cljs.core.truth_(inst_24718)){
var statearr_24860_24986 = state_24818__$1;
(statearr_24860_24986[(1)] = (42));

} else {
var statearr_24861_24987 = state_24818__$1;
(statearr_24861_24987[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (56))){
var state_24818__$1 = state_24818;
var statearr_24862_24988 = state_24818__$1;
(statearr_24862_24988[(2)] = false);

(statearr_24862_24988[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (33))){
var inst_24714 = (state_24818[(17)]);
var inst_24720 = cljs.core.PersistentHashSet.EMPTY;
var inst_24721 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24720,inst_24714);
var state_24818__$1 = state_24818;
var statearr_24863_24989 = state_24818__$1;
(statearr_24863_24989[(2)] = inst_24721);

(statearr_24863_24989[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (13))){
var inst_24666 = (state_24818[(18)]);
var state_24818__$1 = state_24818;
var statearr_24864_24990 = state_24818__$1;
(statearr_24864_24990[(2)] = inst_24666);

(statearr_24864_24990[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (22))){
var state_24818__$1 = state_24818;
var statearr_24865_24991 = state_24818__$1;
(statearr_24865_24991[(2)] = false);

(statearr_24865_24991[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (36))){
var inst_24724 = (state_24818[(14)]);
var inst_24713 = (state_24818[(19)]);
var inst_24718 = (state_24818[(16)]);
var inst_24726 = fluree.db.query.fql.order_offset_and_limit_results(inst_24724,inst_24713,orderBy,inst_24718,group_limit);
var state_24818__$1 = state_24818;
var statearr_24866_24992 = state_24818__$1;
(statearr_24866_24992[(2)] = inst_24726);

(statearr_24866_24992[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (41))){
var inst_24745 = (state_24818[(2)]);
var state_24818__$1 = state_24818;
var statearr_24867_24993 = state_24818__$1;
(statearr_24867_24993[(2)] = inst_24745);

(statearr_24867_24993[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (43))){
var state_24818__$1 = state_24818;
var statearr_24868_24994 = state_24818__$1;
(statearr_24868_24994[(2)] = group_limit);

(statearr_24868_24994[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (61))){
var state_24818__$1 = state_24818;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24869_24995 = state_24818__$1;
(statearr_24869_24995[(1)] = (64));

} else {
var statearr_24870_24996 = state_24818__$1;
(statearr_24870_24996[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (29))){
var inst_24712 = (state_24818[(2)]);
var inst_24713 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24712,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_24714 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_24712,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var state_24818__$1 = (function (){var statearr_24871 = state_24818;
(statearr_24871[(19)] = inst_24713);

(statearr_24871[(17)] = inst_24714);

return statearr_24871;
})();
if(cljs.core.truth_(groupBy)){
var statearr_24872_24997 = state_24818__$1;
(statearr_24872_24997[(1)] = (30));

} else {
var statearr_24873_24998 = state_24818__$1;
(statearr_24873_24998[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (44))){
var inst_24733 = (state_24818[(2)]);
var state_24818__$1 = state_24818;
if(cljs.core.truth_(inst_24733)){
var statearr_24874_24999 = state_24818__$1;
(statearr_24874_24999[(1)] = (45));

} else {
var statearr_24875_25000 = state_24818__$1;
(statearr_24875_25000[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (6))){
var inst_24658 = cljs.core.count(select);
var inst_24659 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_24658);
var state_24818__$1 = state_24818;
var statearr_24876_25001 = state_24818__$1;
(statearr_24876_25001[(2)] = inst_24659);

(statearr_24876_25001[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (28))){
var inst_24691 = (state_24818[(11)]);
var state_24818__$1 = state_24818;
var statearr_24877_25002 = state_24818__$1;
(statearr_24877_25002[(2)] = inst_24691);

(statearr_24877_25002[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (64))){
var inst_24752 = (state_24818[(7)]);
var inst_24771 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_24752);
var state_24818__$1 = state_24818;
var statearr_24878_25003 = state_24818__$1;
(statearr_24878_25003[(2)] = inst_24771);

(statearr_24878_25003[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (51))){
var inst_24753 = (state_24818[(20)]);
var inst_24751 = (state_24818[(2)]);
var inst_24752 = fluree.db.util.async.throw_err(inst_24751);
var inst_24753__$1 = selectDistinct_QMARK_;
var state_24818__$1 = (function (){var statearr_24879 = state_24818;
(statearr_24879[(20)] = inst_24753__$1);

(statearr_24879[(7)] = inst_24752);

return statearr_24879;
})();
if(cljs.core.truth_(inst_24753__$1)){
var statearr_24880_25004 = state_24818__$1;
(statearr_24880_25004[(1)] = (52));

} else {
var statearr_24881_25005 = state_24818__$1;
(statearr_24881_25005[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (25))){
var state_24818__$1 = state_24818;
var statearr_24882_25006 = state_24818__$1;
(statearr_24882_25006[(2)] = false);

(statearr_24882_25006[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (34))){
var inst_24714 = (state_24818[(17)]);
var state_24818__$1 = state_24818;
var statearr_24883_25007 = state_24818__$1;
(statearr_24883_25007[(2)] = inst_24714);

(statearr_24883_25007[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (17))){
var inst_24684 = (state_24818[(2)]);
var state_24818__$1 = state_24818;
var statearr_24884_25008 = state_24818__$1;
(statearr_24884_25008[(2)] = inst_24684);

(statearr_24884_25008[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (3))){
var inst_24816 = (state_24818[(2)]);
var state_24818__$1 = state_24818;
return cljs.core.async.impl.ioc_helpers.return_chan(state_24818__$1,inst_24816);
} else {
if((state_val_24819 === (12))){
var inst_24666 = (state_24818[(18)]);
var inst_24668 = cljs.core.first(select);
var inst_24669 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_24668);
var inst_24670 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24669);
var inst_24671 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_24670,(1));
var inst_24672 = [inst_24671];
var inst_24673 = [inst_24666];
var inst_24674 = cljs.core.PersistentHashMap.fromArrays(inst_24672,inst_24673);
var state_24818__$1 = state_24818;
var statearr_24885_25009 = state_24818__$1;
(statearr_24885_25009[(2)] = inst_24674);

(statearr_24885_25009[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (2))){
var inst_24656 = (state_24818[(10)]);
var _ = (function (){var statearr_24886 = state_24818;
(statearr_24886[(4)] = cljs.core.cons((5),(state_24818[(4)])));

return statearr_24886;
})();
var inst_24656__$1 = aggregates;
var state_24818__$1 = (function (){var statearr_24887 = state_24818;
(statearr_24887[(10)] = inst_24656__$1);

return statearr_24887;
})();
if(cljs.core.truth_(inst_24656__$1)){
var statearr_24888_25010 = state_24818__$1;
(statearr_24888_25010[(1)] = (6));

} else {
var statearr_24889_25011 = state_24818__$1;
(statearr_24889_25011[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (66))){
var inst_24775 = (state_24818[(21)]);
var inst_24774 = (state_24818[(2)]);
var inst_24775__$1 = offset;
var state_24818__$1 = (function (){var statearr_24890 = state_24818;
(statearr_24890[(21)] = inst_24775__$1);

(statearr_24890[(8)] = inst_24774);

return statearr_24890;
})();
if(cljs.core.truth_(inst_24775__$1)){
var statearr_24891_25012 = state_24818__$1;
(statearr_24891_25012[(1)] = (67));

} else {
var statearr_24892_25013 = state_24818__$1;
(statearr_24892_25013[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (23))){
var inst_24707 = (state_24818[(2)]);
var state_24818__$1 = state_24818;
if(cljs.core.truth_(inst_24707)){
var statearr_24893_25014 = state_24818__$1;
(statearr_24893_25014[(1)] = (27));

} else {
var statearr_24894_25015 = state_24818__$1;
(statearr_24894_25015[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (47))){
var inst_24743 = (state_24818[(2)]);
var state_24818__$1 = state_24818;
var statearr_24895_25016 = state_24818__$1;
(statearr_24895_25016[(2)] = inst_24743);

(statearr_24895_25016[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (35))){
var inst_24724 = (state_24818[(2)]);
var state_24818__$1 = (function (){var statearr_24896 = state_24818;
(statearr_24896[(14)] = inst_24724);

return statearr_24896;
})();
if(cljs.core.truth_(orderBy)){
var statearr_24897_25017 = state_24818__$1;
(statearr_24897_25017[(1)] = (36));

} else {
var statearr_24898_25018 = state_24818__$1;
(statearr_24898_25018[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (82))){
var inst_24796 = (state_24818[(22)]);
var inst_24804 = cljs.core.PersistentVector.EMPTY;
var inst_24805 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_24804,inst_24796);
var state_24818__$1 = state_24818;
var statearr_24899_25019 = state_24818__$1;
(statearr_24899_25019[(2)] = inst_24805);

(statearr_24899_25019[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (76))){
var inst_24785 = (state_24818[(12)]);
var inst_24793 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(group_limit,inst_24785);
var state_24818__$1 = state_24818;
var statearr_24900_25020 = state_24818__$1;
(statearr_24900_25020[(2)] = inst_24793);

(statearr_24900_25020[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (19))){
var state_24818__$1 = state_24818;
var statearr_24901_25021 = state_24818__$1;
(statearr_24901_25021[(2)] = res);

(statearr_24901_25021[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (57))){
var inst_24765 = (state_24818[(2)]);
var state_24818__$1 = state_24818;
var statearr_24902_25022 = state_24818__$1;
(statearr_24902_25022[(2)] = inst_24765);

(statearr_24902_25022[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (68))){
var inst_24775 = (state_24818[(21)]);
var state_24818__$1 = state_24818;
var statearr_24903_25023 = state_24818__$1;
(statearr_24903_25023[(2)] = inst_24775);

(statearr_24903_25023[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (11))){
var inst_24813 = (state_24818[(2)]);
var _ = (function (){var statearr_24905 = state_24818;
(statearr_24905[(4)] = cljs.core.rest((state_24818[(4)])));

return statearr_24905;
})();
var state_24818__$1 = state_24818;
var statearr_24906_25024 = state_24818__$1;
(statearr_24906_25024[(2)] = inst_24813);

(statearr_24906_25024[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (9))){
var inst_24664 = cljs.core.first(aggregates);
var inst_24665 = fluree.db.query.analytical.calculate_aggregate(res,inst_24664);
var inst_24666 = cljs.core.second(inst_24665);
var state_24818__$1 = (function (){var statearr_24907 = state_24818;
(statearr_24907[(18)] = inst_24666);

return statearr_24907;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24908_25025 = state_24818__$1;
(statearr_24908_25025[(1)] = (12));

} else {
var statearr_24909_25026 = state_24818__$1;
(statearr_24909_25026[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (5))){
var _ = (function (){var statearr_24910 = state_24818;
(statearr_24910[(4)] = cljs.core.rest((state_24818[(4)])));

return statearr_24910;
})();
var state_24818__$1 = state_24818;
var ex24904 = (state_24818__$1[(2)]);
var statearr_24911_25027 = state_24818__$1;
(statearr_24911_25027[(5)] = ex24904);


if((ex24904 instanceof Error)){
var statearr_24912_25028 = state_24818__$1;
(statearr_24912_25028[(1)] = (4));

(statearr_24912_25028[(5)] = null);

} else {
throw ex24904;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (83))){
var inst_24796 = (state_24818[(22)]);
var state_24818__$1 = state_24818;
var statearr_24913_25029 = state_24818__$1;
(statearr_24913_25029[(2)] = inst_24796);

(statearr_24913_25029[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (14))){
var inst_24677 = (state_24818[(2)]);
var state_24818__$1 = (function (){var statearr_24914 = state_24818;
(statearr_24914[(15)] = inst_24677);

return statearr_24914;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24915_25030 = state_24818__$1;
(statearr_24915_25030[(1)] = (15));

} else {
var statearr_24916_25031 = state_24818__$1;
(statearr_24916_25031[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (45))){
var inst_24724 = (state_24818[(14)]);
var inst_24718 = (state_24818[(16)]);
var inst_24735 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_24718,inst_24724);
var inst_24736 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(group_limit,inst_24735);
var state_24818__$1 = state_24818;
var statearr_24917_25032 = state_24818__$1;
(statearr_24917_25032[(2)] = inst_24736);

(statearr_24917_25032[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (53))){
var inst_24756 = cljs.core.not(orderBy);
var state_24818__$1 = state_24818;
if(inst_24756){
var statearr_24918_25033 = state_24818__$1;
(statearr_24918_25033[(1)] = (55));

} else {
var statearr_24919_25034 = state_24818__$1;
(statearr_24919_25034[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (78))){
var inst_24797 = (state_24818[(23)]);
var inst_24796 = (state_24818[(2)]);
var inst_24797__$1 = inVector_QMARK_;
var state_24818__$1 = (function (){var statearr_24920 = state_24818;
(statearr_24920[(23)] = inst_24797__$1);

(statearr_24920[(22)] = inst_24796);

return statearr_24920;
})();
if(cljs.core.truth_(inst_24797__$1)){
var statearr_24921_25035 = state_24818__$1;
(statearr_24921_25035[(1)] = (79));

} else {
var statearr_24922_25036 = state_24818__$1;
(statearr_24922_25036[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (26))){
var inst_24704 = (state_24818[(2)]);
var state_24818__$1 = state_24818;
var statearr_24923_25037 = state_24818__$1;
(statearr_24923_25037[(2)] = inst_24704);

(statearr_24923_25037[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (16))){
var inst_24677 = (state_24818[(15)]);
var state_24818__$1 = state_24818;
var statearr_24924_25038 = state_24818__$1;
(statearr_24924_25038[(2)] = inst_24677);

(statearr_24924_25038[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (81))){
var inst_24802 = (state_24818[(2)]);
var state_24818__$1 = state_24818;
if(cljs.core.truth_(inst_24802)){
var statearr_24925_25039 = state_24818__$1;
(statearr_24925_25039[(1)] = (82));

} else {
var statearr_24926_25040 = state_24818__$1;
(statearr_24926_25040[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (79))){
var inst_24797 = (state_24818[(23)]);
var state_24818__$1 = state_24818;
var statearr_24927_25041 = state_24818__$1;
(statearr_24927_25041[(2)] = inst_24797);

(statearr_24927_25041[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (38))){
var inst_24713 = (state_24818[(19)]);
var inst_24747 = (state_24818[(2)]);
var inst_24748 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667)], 0));
var inst_24749 = fluree.db.query.fql.format_filter_tuples(db,inst_24747,select_spec,inst_24713,vars,inst_24748);
var state_24818__$1 = state_24818;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_24818__$1,(51),inst_24749);
} else {
if((state_val_24819 === (30))){
var state_24818__$1 = state_24818;
var statearr_24928_25042 = state_24818__$1;
(statearr_24928_25042[(2)] = (0));

(statearr_24928_25042[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (73))){
var inst_24788 = ((0) < group_limit);
var state_24818__$1 = state_24818;
var statearr_24929_25043 = state_24818__$1;
(statearr_24929_25043[(2)] = inst_24788);

(statearr_24929_25043[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (10))){
var state_24818__$1 = state_24818;
if(cljs.core.truth_(aggregates)){
var statearr_24930_25044 = state_24818__$1;
(statearr_24930_25044[(1)] = (18));

} else {
var statearr_24931_25045 = state_24818__$1;
(statearr_24931_25045[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (18))){
var inst_24688 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_24818__$1 = state_24818;
var statearr_24932_25046 = state_24818__$1;
(statearr_24932_25046[(2)] = inst_24688);

(statearr_24932_25046[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (52))){
var inst_24753 = (state_24818[(20)]);
var state_24818__$1 = state_24818;
var statearr_24933_25047 = state_24818__$1;
(statearr_24933_25047[(2)] = inst_24753);

(statearr_24933_25047[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (67))){
var inst_24777 = ((0) < offset);
var state_24818__$1 = state_24818;
var statearr_24934_25048 = state_24818__$1;
(statearr_24934_25048[(2)] = inst_24777);

(statearr_24934_25048[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (71))){
var inst_24774 = (state_24818[(8)]);
var state_24818__$1 = state_24818;
var statearr_24935_25049 = state_24818__$1;
(statearr_24935_25049[(2)] = inst_24774);

(statearr_24935_25049[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (42))){
var inst_24718 = (state_24818[(16)]);
var state_24818__$1 = state_24818;
var statearr_24936_25050 = state_24818__$1;
(statearr_24936_25050[(2)] = inst_24718);

(statearr_24936_25050[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (80))){
var inst_24752 = (state_24818[(7)]);
var inst_24800 = cljs.core.vector_QMARK_(inst_24752);
var state_24818__$1 = state_24818;
var statearr_24937_25051 = state_24818__$1;
(statearr_24937_25051[(2)] = inst_24800);

(statearr_24937_25051[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (37))){
var state_24818__$1 = state_24818;
if(cljs.core.truth_(groupBy)){
var statearr_24938_25052 = state_24818__$1;
(statearr_24938_25052[(1)] = (39));

} else {
var statearr_24939_25053 = state_24818__$1;
(statearr_24939_25053[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (63))){
var inst_24811 = (state_24818[(2)]);
var state_24818__$1 = state_24818;
var statearr_24940_25054 = state_24818__$1;
(statearr_24940_25054[(2)] = inst_24811);

(statearr_24940_25054[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (8))){
var inst_24662 = (state_24818[(2)]);
var state_24818__$1 = state_24818;
if(cljs.core.truth_(inst_24662)){
var statearr_24941_25055 = state_24818__$1;
(statearr_24941_25055[(1)] = (9));

} else {
var statearr_24942_25056 = state_24818__$1;
(statearr_24942_25056[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (49))){
var state_24818__$1 = state_24818;
var statearr_24943_25057 = state_24818__$1;
(statearr_24943_25057[(2)] = null);

(statearr_24943_25057[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24819 === (84))){
var inst_24808 = (state_24818[(2)]);
var state_24818__$1 = state_24818;
var statearr_24944_25058 = state_24818__$1;
(statearr_24944_25058[(2)] = inst_24808);

(statearr_24944_25058[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2879__auto__ = null;
var fluree$db$query$fql$state_machine__2879__auto____0 = (function (){
var statearr_24945 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24945[(0)] = fluree$db$query$fql$state_machine__2879__auto__);

(statearr_24945[(1)] = (1));

return statearr_24945;
});
var fluree$db$query$fql$state_machine__2879__auto____1 = (function (state_24818){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_24818);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e24946){var ex__2882__auto__ = e24946;
var statearr_24947_25059 = state_24818;
(statearr_24947_25059[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_24818[(4)]))){
var statearr_24948_25060 = state_24818;
(statearr_24948_25060[(1)] = cljs.core.first((state_24818[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25061 = state_24818;
state_24818 = G__25061;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2879__auto__ = function(state_24818){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2879__auto____1.call(this,state_24818);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2879__auto____0;
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2879__auto____1;
return fluree$db$query$fql$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_24949 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_24949[(6)] = c__2901__auto__);

return statearr_24949;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 5);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__25064,groupBy){
var map__25065 = p__25064;
var map__25065__$1 = (((((!((map__25065 == null))))?(((((map__25065.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25065.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25065):map__25065);
var res = map__25065__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25065__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25065__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25067 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25067,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25067,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__25062_SHARP_){
return fluree.db.util.core.index_of(headers,p1__25062_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__25063_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__25063_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__25070 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25070,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25070,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,p__25073,p__25074,opts){
var map__25075 = p__25073;
var map__25075__$1 = (((((!((map__25075 == null))))?(((((map__25075.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25075.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25075):map__25075);
var res = map__25075__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25075__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25075__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__25076 = p__25074;
var map__25076__$1 = (((((!((map__25076 == null))))?(((((map__25076.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25076.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25076):map__25076);
var select_spec = map__25076__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25076__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25076__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25076__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25076__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25076__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25076__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25076__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_25293){
var state_val_25294 = (state_25293[(1)]);
if((state_val_25294 === (65))){
var inst_25157 = (state_25293[(7)]);
var inst_25148 = (state_25293[(8)]);
var inst_25209 = (state_25293[(9)]);
var inst_25239 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25148,inst_25157,inst_25209);
var state_25293__$1 = state_25293;
var statearr_25295_25424 = state_25293__$1;
(statearr_25295_25424[(2)] = inst_25239);

(statearr_25295_25424[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (70))){
var inst_25264 = (state_25293[(10)]);
var inst_25263 = (state_25293[(2)]);
var inst_25264__$1 = fluree.db.util.async.throw_err(inst_25263);
var inst_25265 = cljs.core.coll_QMARK_(inst_25264__$1);
var inst_25266 = (!(inst_25265));
var state_25293__$1 = (function (){var statearr_25296 = state_25293;
(statearr_25296[(10)] = inst_25264__$1);

return statearr_25296;
})();
if(inst_25266){
var statearr_25297_25425 = state_25293__$1;
(statearr_25297_25425[(1)] = (71));

} else {
var statearr_25298_25426 = state_25293__$1;
(statearr_25298_25426[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (62))){
var state_25293__$1 = state_25293;
var statearr_25299_25427 = state_25293__$1;
(statearr_25299_25427[(2)] = null);

(statearr_25299_25427[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (74))){
var inst_25264 = (state_25293[(10)]);
var inst_25269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25270 = [inst_25264];
var inst_25271 = (new cljs.core.PersistentVector(null,1,(5),inst_25269,inst_25270,null));
var state_25293__$1 = state_25293;
var statearr_25300_25428 = state_25293__$1;
(statearr_25300_25428[(2)] = inst_25271);

(statearr_25300_25428[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (7))){
var state_25293__$1 = state_25293;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25301_25429 = state_25293__$1;
(statearr_25301_25429[(1)] = (67));

} else {
var statearr_25302_25430 = state_25293__$1;
(statearr_25302_25430[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (59))){
var state_25293__$1 = state_25293;
var statearr_25303_25431 = state_25293__$1;
(statearr_25303_25431[(1)] = (61));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (20))){
var state_25293__$1 = state_25293;
var statearr_25305_25432 = state_25293__$1;
(statearr_25305_25432[(2)] = (0));

(statearr_25305_25432[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (72))){
var state_25293__$1 = state_25293;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25306_25433 = state_25293__$1;
(statearr_25306_25433[(1)] = (77));

} else {
var statearr_25307_25434 = state_25293__$1;
(statearr_25307_25434[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (58))){
var inst_25147 = (state_25293[(11)]);
var inst_25221 = (inst_25147 - (1));
var state_25293__$1 = state_25293;
var statearr_25308_25435 = state_25293__$1;
(statearr_25308_25435[(2)] = inst_25221);

(statearr_25308_25435[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (60))){
var inst_25231 = (state_25293[(2)]);
var state_25293__$1 = state_25293;
var statearr_25309_25436 = state_25293__$1;
(statearr_25309_25436[(2)] = inst_25231);

(statearr_25309_25436[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (27))){
var inst_25146 = (state_25293[(12)]);
var inst_25170 = (inst_25146 < (1));
var state_25293__$1 = state_25293;
var statearr_25310_25437 = state_25293__$1;
(statearr_25310_25437[(2)] = inst_25170);

(statearr_25310_25437[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (1))){
var state_25293__$1 = state_25293;
var statearr_25311_25438 = state_25293__$1;
(statearr_25311_25438[(2)] = null);

(statearr_25311_25438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (69))){
var inst_25260 = (state_25293[(2)]);
var inst_25261 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,res,select_spec,inst_25260,opts);
var state_25293__$1 = state_25293;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25293__$1,(70),inst_25261);
} else {
if((state_val_25294 === (24))){
var inst_25148 = (state_25293[(8)]);
var state_25293__$1 = state_25293;
var statearr_25312_25439 = state_25293__$1;
(statearr_25312_25439[(2)] = inst_25148);

(statearr_25312_25439[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (55))){
var state_25293__$1 = state_25293;
var statearr_25313_25440 = state_25293__$1;
(statearr_25313_25440[(2)] = (0));

(statearr_25313_25440[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (39))){
var inst_25165 = (state_25293[(13)]);
var inst_25188 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25189 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"limit","limit",-1355822363),null], 0));
var inst_25190 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4(db,inst_25165,inst_25188,inst_25189);
var state_25293__$1 = state_25293;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25293__$1,(42),inst_25190);
} else {
if((state_val_25294 === (46))){
var inst_25146 = (state_25293[(12)]);
var inst_25201 = ((0) < inst_25146);
var state_25293__$1 = state_25293;
var statearr_25314_25441 = state_25293__$1;
(statearr_25314_25441[(2)] = inst_25201);

(statearr_25314_25441[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (4))){
var inst_25079 = (state_25293[(2)]);
var state_25293__$1 = state_25293;
var statearr_25315_25442 = state_25293__$1;
(statearr_25315_25442[(2)] = inst_25079);

(statearr_25315_25442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (77))){
var inst_25264 = (state_25293[(10)]);
var inst_25277 = cljs.core.first(inst_25264);
var state_25293__$1 = state_25293;
var statearr_25316_25443 = state_25293__$1;
(statearr_25316_25443[(2)] = inst_25277);

(statearr_25316_25443[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (54))){
var inst_25147 = (state_25293[(11)]);
var inst_25216 = (state_25293[(2)]);
var inst_25217 = (inst_25147 <= (0));
var state_25293__$1 = (function (){var statearr_25317 = state_25293;
(statearr_25317[(14)] = inst_25216);

return statearr_25317;
})();
if(cljs.core.truth_(inst_25217)){
var statearr_25318_25444 = state_25293__$1;
(statearr_25318_25444[(1)] = (55));

} else {
var statearr_25319_25445 = state_25293__$1;
(statearr_25319_25445[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (15))){
var inst_25097 = (state_25293[(15)]);
var inst_25105 = (state_25293[(2)]);
var inst_25106 = fluree.db.util.async.throw_err(inst_25105);
var inst_25107 = [inst_25097];
var inst_25108 = [inst_25106];
var inst_25109 = cljs.core.PersistentHashMap.fromArrays(inst_25107,inst_25108);
var state_25293__$1 = state_25293;
var statearr_25320_25446 = state_25293__$1;
(statearr_25320_25446[(2)] = inst_25109);

(statearr_25320_25446[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (48))){
var inst_25204 = (state_25293[(2)]);
var state_25293__$1 = state_25293;
if(cljs.core.truth_(inst_25204)){
var statearr_25321_25447 = state_25293__$1;
(statearr_25321_25447[(1)] = (49));

} else {
var statearr_25322_25448 = state_25293__$1;
(statearr_25322_25448[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (50))){
var inst_25199 = (state_25293[(16)]);
var state_25293__$1 = state_25293;
var statearr_25323_25449 = state_25293__$1;
(statearr_25323_25449[(2)] = inst_25199);

(statearr_25323_25449[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (75))){
var inst_25264 = (state_25293[(10)]);
var state_25293__$1 = state_25293;
var statearr_25324_25450 = state_25293__$1;
(statearr_25324_25450[(2)] = inst_25264);

(statearr_25324_25450[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (21))){
var inst_25125 = (state_25293[(17)]);
var inst_25129 = (state_25293[(18)]);
var inst_25137 = (state_25293[(19)]);
var inst_25142 = (state_25293[(2)]);
var inst_25143 = cljs.core.PersistentHashMap.EMPTY;
var inst_25144 = inst_25125;
var inst_25145 = inst_25129;
var inst_25146 = inst_25137;
var inst_25147 = inst_25142;
var inst_25148 = inst_25143;
var state_25293__$1 = (function (){var statearr_25325 = state_25293;
(statearr_25325[(11)] = inst_25147);

(statearr_25325[(12)] = inst_25146);

(statearr_25325[(8)] = inst_25148);

(statearr_25325[(20)] = inst_25145);

(statearr_25325[(21)] = inst_25144);

return statearr_25325;
})();
var statearr_25326_25451 = state_25293__$1;
(statearr_25326_25451[(2)] = null);

(statearr_25326_25451[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (31))){
var inst_25162 = (state_25293[(22)]);
var inst_25147 = (state_25293[(11)]);
var inst_25176 = (inst_25147 >= inst_25162);
var state_25293__$1 = state_25293;
if(cljs.core.truth_(inst_25176)){
var statearr_25327_25452 = state_25293__$1;
(statearr_25327_25452[(1)] = (33));

} else {
var statearr_25328_25453 = state_25293__$1;
(statearr_25328_25453[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (32))){
var inst_25249 = (state_25293[(2)]);
var state_25293__$1 = state_25293;
var statearr_25329_25454 = state_25293__$1;
(statearr_25329_25454[(2)] = inst_25249);

(statearr_25329_25454[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (40))){
var state_25293__$1 = state_25293;
var statearr_25330_25455 = state_25293__$1;
(statearr_25330_25455[(2)] = null);

(statearr_25330_25455[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (56))){
var state_25293__$1 = state_25293;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25331_25456 = state_25293__$1;
(statearr_25331_25456[(1)] = (58));

} else {
var statearr_25332_25457 = state_25293__$1;
(statearr_25332_25457[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (33))){
var state_25293__$1 = state_25293;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25333_25458 = state_25293__$1;
(statearr_25333_25458[(1)] = (36));

} else {
var statearr_25334_25459 = state_25293__$1;
(statearr_25334_25459[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (13))){
var inst_25094 = (state_25293[(23)]);
var inst_25125 = (state_25293[(17)]);
var inst_25129 = (state_25293[(18)]);
var inst_25125__$1 = cljs.core.keys(inst_25094);
var inst_25126 = cljs.core.seq(inst_25125__$1);
var inst_25127 = cljs.core.first(inst_25126);
var inst_25128 = cljs.core.next(inst_25126);
var inst_25129__$1 = cljs.core.vals(inst_25094);
var inst_25130 = cljs.core.seq(inst_25129__$1);
var inst_25131 = cljs.core.first(inst_25130);
var inst_25132 = cljs.core.next(inst_25130);
var inst_25133 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_25293__$1 = (function (){var statearr_25335 = state_25293;
(statearr_25335[(24)] = inst_25127);

(statearr_25335[(25)] = inst_25131);

(statearr_25335[(26)] = inst_25128);

(statearr_25335[(17)] = inst_25125__$1);

(statearr_25335[(18)] = inst_25129__$1);

(statearr_25335[(27)] = inst_25132);

return statearr_25335;
})();
if(inst_25133){
var statearr_25336_25460 = state_25293__$1;
(statearr_25336_25460[(1)] = (16));

} else {
var statearr_25337_25461 = state_25293__$1;
(statearr_25337_25461[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (22))){
var inst_25145 = (state_25293[(20)]);
var inst_25144 = (state_25293[(21)]);
var inst_25156 = cljs.core.seq(inst_25144);
var inst_25157 = cljs.core.first(inst_25156);
var inst_25158 = cljs.core.next(inst_25156);
var inst_25159 = cljs.core.seq(inst_25145);
var inst_25160 = cljs.core.first(inst_25159);
var inst_25161 = cljs.core.next(inst_25159);
var inst_25162 = cljs.core.count(inst_25160);
var inst_25163 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25164 = [headers,vars,inst_25160];
var inst_25165 = cljs.core.PersistentHashMap.fromArrays(inst_25163,inst_25164);
var inst_25166 = (inst_25160 == null);
var state_25293__$1 = (function (){var statearr_25338 = state_25293;
(statearr_25338[(22)] = inst_25162);

(statearr_25338[(13)] = inst_25165);

(statearr_25338[(28)] = inst_25158);

(statearr_25338[(7)] = inst_25157);

(statearr_25338[(29)] = inst_25161);

return statearr_25338;
})();
if(cljs.core.truth_(inst_25166)){
var statearr_25339_25462 = state_25293__$1;
(statearr_25339_25462[(1)] = (24));

} else {
var statearr_25340_25463 = state_25293__$1;
(statearr_25340_25463[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (36))){
var inst_25147 = (state_25293[(11)]);
var inst_25179 = (inst_25147 - (1));
var state_25293__$1 = state_25293;
var statearr_25341_25464 = state_25293__$1;
(statearr_25341_25464[(2)] = inst_25179);

(statearr_25341_25464[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (41))){
var inst_25245 = (state_25293[(2)]);
var state_25293__$1 = state_25293;
var statearr_25342_25465 = state_25293__$1;
(statearr_25342_25465[(2)] = inst_25245);

(statearr_25342_25465[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (43))){
var inst_25147 = (state_25293[(11)]);
var inst_25193 = (state_25293[(30)]);
var inst_25196 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_25147,inst_25193);
var state_25293__$1 = state_25293;
var statearr_25343_25466 = state_25293__$1;
(statearr_25343_25466[(2)] = inst_25196);

(statearr_25343_25466[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (61))){
var inst_25162 = (state_25293[(22)]);
var inst_25147 = (state_25293[(11)]);
var inst_25209 = (state_25293[(9)]);
var inst_25224 = cljs.core.count(inst_25209);
var inst_25225 = (inst_25162 - inst_25224);
var inst_25226 = (inst_25147 - inst_25225);
var state_25293__$1 = state_25293;
var statearr_25344_25467 = state_25293__$1;
(statearr_25344_25467[(2)] = inst_25226);

(statearr_25344_25467[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (29))){
var inst_25173 = (state_25293[(2)]);
var state_25293__$1 = state_25293;
if(cljs.core.truth_(inst_25173)){
var statearr_25345_25468 = state_25293__$1;
(statearr_25345_25468[(1)] = (30));

} else {
var statearr_25346_25469 = state_25293__$1;
(statearr_25346_25469[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (44))){
var inst_25193 = (state_25293[(30)]);
var state_25293__$1 = state_25293;
var statearr_25347_25470 = state_25293__$1;
(statearr_25347_25470[(2)] = inst_25193);

(statearr_25347_25470[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (6))){
var inst_25086 = (state_25293[(31)]);
var inst_25086__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_25088 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_25293__$1 = (function (){var statearr_25348 = state_25293;
(statearr_25348[(31)] = inst_25086__$1);

(statearr_25348[(32)] = inst_25088);

return statearr_25348;
})();
if(cljs.core.truth_(inst_25086__$1)){
var statearr_25349_25471 = state_25293__$1;
(statearr_25349_25471[(1)] = (9));

} else {
var statearr_25350_25472 = state_25293__$1;
(statearr_25350_25472[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (28))){
var inst_25146 = (state_25293[(12)]);
var state_25293__$1 = state_25293;
var statearr_25351_25473 = state_25293__$1;
(statearr_25351_25473[(2)] = inst_25146);

(statearr_25351_25473[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (64))){
var inst_25148 = (state_25293[(8)]);
var state_25293__$1 = state_25293;
var statearr_25352_25474 = state_25293__$1;
(statearr_25352_25474[(2)] = inst_25148);

(statearr_25352_25474[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (51))){
var inst_25146 = (state_25293[(12)]);
var inst_25209 = (state_25293[(2)]);
var inst_25210 = (inst_25146 == null);
var state_25293__$1 = (function (){var statearr_25353 = state_25293;
(statearr_25353[(9)] = inst_25209);

return statearr_25353;
})();
if(cljs.core.truth_(inst_25210)){
var statearr_25354_25475 = state_25293__$1;
(statearr_25354_25475[(1)] = (52));

} else {
var statearr_25355_25476 = state_25293__$1;
(statearr_25355_25476[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (25))){
var inst_25146 = (state_25293[(12)]);
var state_25293__$1 = state_25293;
if(cljs.core.truth_(inst_25146)){
var statearr_25356_25477 = state_25293__$1;
(statearr_25356_25477[(1)] = (27));

} else {
var statearr_25357_25478 = state_25293__$1;
(statearr_25357_25478[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (34))){
var state_25293__$1 = state_25293;
var statearr_25358_25479 = state_25293__$1;
(statearr_25358_25479[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (17))){
var state_25293__$1 = state_25293;
var statearr_25360_25480 = state_25293__$1;
(statearr_25360_25480[(2)] = limit);

(statearr_25360_25480[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (3))){
var inst_25291 = (state_25293[(2)]);
var state_25293__$1 = state_25293;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25293__$1,inst_25291);
} else {
if((state_val_25294 === (12))){
var inst_25094 = (state_25293[(23)]);
var inst_25096 = cljs.core.keys(inst_25094);
var inst_25097 = cljs.core.first(inst_25096);
var inst_25098 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25099 = cljs.core.vals(inst_25094);
var inst_25100 = cljs.core.first(inst_25099);
var inst_25101 = [headers,vars,inst_25100];
var inst_25102 = cljs.core.PersistentHashMap.fromArrays(inst_25098,inst_25101);
var inst_25103 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5(db,inst_25102,select_spec,limit,opts);
var state_25293__$1 = (function (){var statearr_25361 = state_25293;
(statearr_25361[(15)] = inst_25097);

return statearr_25361;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25293__$1,(15),inst_25103);
} else {
if((state_val_25294 === (2))){
var _ = (function (){var statearr_25362 = state_25293;
(statearr_25362[(4)] = cljs.core.cons((5),(state_25293[(4)])));

return statearr_25362;
})();
var state_25293__$1 = state_25293;
if(cljs.core.truth_(groupBy)){
var statearr_25363_25481 = state_25293__$1;
(statearr_25363_25481[(1)] = (6));

} else {
var statearr_25364_25482 = state_25293__$1;
(statearr_25364_25482[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (66))){
var inst_25216 = (state_25293[(14)]);
var inst_25158 = (state_25293[(28)]);
var inst_25233 = (state_25293[(33)]);
var inst_25161 = (state_25293[(29)]);
var inst_25241 = (state_25293[(2)]);
var inst_25144 = inst_25158;
var inst_25145 = inst_25161;
var inst_25146 = inst_25216;
var inst_25147 = inst_25233;
var inst_25148 = inst_25241;
var state_25293__$1 = (function (){var statearr_25365 = state_25293;
(statearr_25365[(11)] = inst_25147);

(statearr_25365[(12)] = inst_25146);

(statearr_25365[(8)] = inst_25148);

(statearr_25365[(20)] = inst_25145);

(statearr_25365[(21)] = inst_25144);

return statearr_25365;
})();
var statearr_25366_25483 = state_25293__$1;
(statearr_25366_25483[(2)] = null);

(statearr_25366_25483[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (23))){
var inst_25253 = (state_25293[(2)]);
var state_25293__$1 = state_25293;
var statearr_25367_25484 = state_25293__$1;
(statearr_25367_25484[(2)] = inst_25253);

(statearr_25367_25484[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (47))){
var inst_25146 = (state_25293[(12)]);
var state_25293__$1 = state_25293;
var statearr_25368_25485 = state_25293__$1;
(statearr_25368_25485[(2)] = inst_25146);

(statearr_25368_25485[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (35))){
var inst_25247 = (state_25293[(2)]);
var state_25293__$1 = state_25293;
var statearr_25369_25486 = state_25293__$1;
(statearr_25369_25486[(2)] = inst_25247);

(statearr_25369_25486[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (82))){
var inst_25282 = (state_25293[(2)]);
var state_25293__$1 = state_25293;
var statearr_25370_25487 = state_25293__$1;
(statearr_25370_25487[(2)] = inst_25282);

(statearr_25370_25487[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (76))){
var inst_25274 = (state_25293[(2)]);
var state_25293__$1 = state_25293;
var statearr_25371_25488 = state_25293__$1;
(statearr_25371_25488[(2)] = inst_25274);

(statearr_25371_25488[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (19))){
var inst_25138 = (state_25293[(34)]);
var state_25293__$1 = state_25293;
var statearr_25372_25489 = state_25293__$1;
(statearr_25372_25489[(2)] = inst_25138);

(statearr_25372_25489[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (57))){
var inst_25209 = (state_25293[(9)]);
var inst_25233 = (state_25293[(2)]);
var inst_25234 = (inst_25209 == null);
var inst_25235 = cljs.core.empty_QMARK_(inst_25209);
var inst_25236 = ((inst_25234) || (inst_25235));
var state_25293__$1 = (function (){var statearr_25373 = state_25293;
(statearr_25373[(33)] = inst_25233);

return statearr_25373;
})();
if(cljs.core.truth_(inst_25236)){
var statearr_25374_25490 = state_25293__$1;
(statearr_25374_25490[(1)] = (64));

} else {
var statearr_25375_25491 = state_25293__$1;
(statearr_25375_25491[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (68))){
var state_25293__$1 = state_25293;
var statearr_25376_25492 = state_25293__$1;
(statearr_25376_25492[(2)] = limit);

(statearr_25376_25492[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (11))){
var inst_25094 = (state_25293[(2)]);
var state_25293__$1 = (function (){var statearr_25378 = state_25293;
(statearr_25378[(23)] = inst_25094);

return statearr_25378;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25379_25493 = state_25293__$1;
(statearr_25379_25493[(1)] = (12));

} else {
var statearr_25380_25494 = state_25293__$1;
(statearr_25380_25494[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (9))){
var inst_25086 = (state_25293[(31)]);
var inst_25088 = (state_25293[(32)]);
var inst_25090 = cljs.core.sorted_map_by(inst_25086);
var inst_25091 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25090,inst_25088);
var state_25293__$1 = state_25293;
var statearr_25381_25495 = state_25293__$1;
(statearr_25381_25495[(2)] = inst_25091);

(statearr_25381_25495[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (5))){
var _ = (function (){var statearr_25382 = state_25293;
(statearr_25382[(4)] = cljs.core.rest((state_25293[(4)])));

return statearr_25382;
})();
var state_25293__$1 = state_25293;
var ex25377 = (state_25293__$1[(2)]);
var statearr_25383_25496 = state_25293__$1;
(statearr_25383_25496[(5)] = ex25377);


if((ex25377 instanceof Error)){
var statearr_25384_25497 = state_25293__$1;
(statearr_25384_25497[(1)] = (4));

(statearr_25384_25497[(5)] = null);

} else {
throw ex25377;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (14))){
var inst_25255 = (state_25293[(2)]);
var state_25293__$1 = state_25293;
var statearr_25385_25498 = state_25293__$1;
(statearr_25385_25498[(2)] = inst_25255);

(statearr_25385_25498[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (45))){
var inst_25146 = (state_25293[(12)]);
var inst_25199 = (state_25293[(2)]);
var state_25293__$1 = (function (){var statearr_25386 = state_25293;
(statearr_25386[(16)] = inst_25199);

return statearr_25386;
})();
if(cljs.core.truth_(inst_25146)){
var statearr_25387_25499 = state_25293__$1;
(statearr_25387_25499[(1)] = (46));

} else {
var statearr_25388_25500 = state_25293__$1;
(statearr_25388_25500[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (53))){
var inst_25146 = (state_25293[(12)]);
var inst_25209 = (state_25293[(9)]);
var inst_25213 = cljs.core.count(inst_25209);
var inst_25214 = (inst_25146 - inst_25213);
var state_25293__$1 = state_25293;
var statearr_25389_25501 = state_25293__$1;
(statearr_25389_25501[(2)] = inst_25214);

(statearr_25389_25501[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (78))){
var state_25293__$1 = state_25293;
var statearr_25390_25502 = state_25293__$1;
(statearr_25390_25502[(1)] = (80));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (26))){
var inst_25251 = (state_25293[(2)]);
var state_25293__$1 = state_25293;
var statearr_25392_25503 = state_25293__$1;
(statearr_25392_25503[(2)] = inst_25251);

(statearr_25392_25503[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (16))){
var state_25293__$1 = state_25293;
var statearr_25393_25504 = state_25293__$1;
(statearr_25393_25504[(2)] = null);

(statearr_25393_25504[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (81))){
var state_25293__$1 = state_25293;
var statearr_25396_25505 = state_25293__$1;
(statearr_25396_25505[(2)] = null);

(statearr_25396_25505[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (79))){
var inst_25284 = (state_25293[(2)]);
var state_25293__$1 = state_25293;
var statearr_25397_25506 = state_25293__$1;
(statearr_25397_25506[(2)] = inst_25284);

(statearr_25397_25506[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (38))){
var inst_25158 = (state_25293[(28)]);
var inst_25146 = (state_25293[(12)]);
var inst_25148 = (state_25293[(8)]);
var inst_25161 = (state_25293[(29)]);
var inst_25183 = (state_25293[(2)]);
var tmp25394 = inst_25146;
var tmp25395 = inst_25148;
var inst_25144 = inst_25158;
var inst_25145 = inst_25161;
var inst_25146__$1 = tmp25394;
var inst_25147 = inst_25183;
var inst_25148__$1 = tmp25395;
var state_25293__$1 = (function (){var statearr_25398 = state_25293;
(statearr_25398[(11)] = inst_25147);

(statearr_25398[(12)] = inst_25146__$1);

(statearr_25398[(8)] = inst_25148__$1);

(statearr_25398[(20)] = inst_25145);

(statearr_25398[(21)] = inst_25144);

return statearr_25398;
})();
var statearr_25399_25507 = state_25293__$1;
(statearr_25399_25507[(2)] = null);

(statearr_25399_25507[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (30))){
var inst_25148 = (state_25293[(8)]);
var state_25293__$1 = state_25293;
var statearr_25400_25508 = state_25293__$1;
(statearr_25400_25508[(2)] = inst_25148);

(statearr_25400_25508[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (73))){
var inst_25286 = (state_25293[(2)]);
var state_25293__$1 = state_25293;
var statearr_25401_25509 = state_25293__$1;
(statearr_25401_25509[(2)] = inst_25286);

(statearr_25401_25509[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (10))){
var inst_25088 = (state_25293[(32)]);
var state_25293__$1 = state_25293;
var statearr_25402_25510 = state_25293__$1;
(statearr_25402_25510[(2)] = inst_25088);

(statearr_25402_25510[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (18))){
var inst_25138 = (state_25293[(34)]);
var inst_25137 = (state_25293[(2)]);
var inst_25138__$1 = offset;
var state_25293__$1 = (function (){var statearr_25403 = state_25293;
(statearr_25403[(34)] = inst_25138__$1);

(statearr_25403[(19)] = inst_25137);

return statearr_25403;
})();
if(cljs.core.truth_(inst_25138__$1)){
var statearr_25404_25511 = state_25293__$1;
(statearr_25404_25511[(1)] = (19));

} else {
var statearr_25405_25512 = state_25293__$1;
(statearr_25405_25512[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (52))){
var state_25293__$1 = state_25293;
var statearr_25406_25513 = state_25293__$1;
(statearr_25406_25513[(2)] = null);

(statearr_25406_25513[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (67))){
var state_25293__$1 = state_25293;
var statearr_25407_25514 = state_25293__$1;
(statearr_25407_25514[(2)] = (1));

(statearr_25407_25514[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (71))){
var state_25293__$1 = state_25293;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25408_25515 = state_25293__$1;
(statearr_25408_25515[(1)] = (74));

} else {
var statearr_25409_25516 = state_25293__$1;
(statearr_25409_25516[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (42))){
var inst_25147 = (state_25293[(11)]);
var inst_25192 = (state_25293[(2)]);
var inst_25193 = fluree.db.util.async.throw_err(inst_25192);
var inst_25194 = ((0) < inst_25147);
var state_25293__$1 = (function (){var statearr_25410 = state_25293;
(statearr_25410[(30)] = inst_25193);

return statearr_25410;
})();
if(cljs.core.truth_(inst_25194)){
var statearr_25411_25517 = state_25293__$1;
(statearr_25411_25517[(1)] = (43));

} else {
var statearr_25412_25518 = state_25293__$1;
(statearr_25412_25518[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (80))){
var inst_25264 = (state_25293[(10)]);
var state_25293__$1 = state_25293;
var statearr_25413_25519 = state_25293__$1;
(statearr_25413_25519[(2)] = inst_25264);

(statearr_25413_25519[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (37))){
var inst_25162 = (state_25293[(22)]);
var inst_25147 = (state_25293[(11)]);
var inst_25181 = (inst_25147 - inst_25162);
var state_25293__$1 = state_25293;
var statearr_25414_25520 = state_25293__$1;
(statearr_25414_25520[(2)] = inst_25181);

(statearr_25414_25520[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (63))){
var inst_25229 = (state_25293[(2)]);
var state_25293__$1 = state_25293;
var statearr_25415_25521 = state_25293__$1;
(statearr_25415_25521[(2)] = inst_25229);

(statearr_25415_25521[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (8))){
var inst_25288 = (state_25293[(2)]);
var _ = (function (){var statearr_25416 = state_25293;
(statearr_25416[(4)] = cljs.core.rest((state_25293[(4)])));

return statearr_25416;
})();
var state_25293__$1 = state_25293;
var statearr_25417_25522 = state_25293__$1;
(statearr_25417_25522[(2)] = inst_25288);

(statearr_25417_25522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25294 === (49))){
var inst_25199 = (state_25293[(16)]);
var inst_25146 = (state_25293[(12)]);
var inst_25206 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_25146,inst_25199);
var state_25293__$1 = state_25293;
var statearr_25418_25523 = state_25293__$1;
(statearr_25418_25523[(2)] = inst_25206);

(statearr_25418_25523[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto____0 = (function (){
var statearr_25419 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25419[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto__);

(statearr_25419[(1)] = (1));

return statearr_25419;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto____1 = (function (state_25293){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_25293);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e25420){var ex__2882__auto__ = e25420;
var statearr_25421_25524 = state_25293;
(statearr_25421_25524[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_25293[(4)]))){
var statearr_25422_25525 = state_25293;
(statearr_25422_25525[(1)] = cljs.core.first((state_25293[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25526 = state_25293;
state_25293 = G__25526;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto__ = function(state_25293){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto____1.call(this,state_25293);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_25423 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_25423[(6)] = c__2901__auto__);

return statearr_25423;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__25529,opts){
var map__25530 = p__25529;
var map__25530__$1 = (((((!((map__25530 == null))))?(((((map__25530.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25530.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25530):map__25530);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25530__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25530__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25530__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25530__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__4126__auto__ = selectOne;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = select;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
var or__4126__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4126__auto____$2)){
return or__4126__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__25527_SHARP_){
return cljs.core.contains_QMARK_(p1__25527_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__25528_SHARP_){
return cljs.core.contains_QMARK_(p1__25528_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5735__auto__)){
var orderBy = temp__5735__auto__;
if(cljs.core.truth_((function (){var or__4126__auto__ = typeof orderBy === 'string';
if(or__4126__auto__){
return or__4126__auto__;
} else {
if(cljs.core.vector_QMARK_(orderBy)){
var G__25539 = cljs.core.first(orderBy);
var fexpr__25538 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__25538.cljs$core$IFn$_invoke$arity$1 ? fexpr__25538.cljs$core$IFn$_invoke$arity$1(G__25539) : fexpr__25538.call(null,G__25539));
} else {
return false;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})(),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4126__auto__ = selectDistinct;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__25540,p__25541){
var map__25542 = p__25540;
var map__25542__$1 = (((((!((map__25542 == null))))?(((((map__25542.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25542.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25542):map__25542);
var query_map = map__25542__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25542__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__25543 = p__25541;
var map__25543__$1 = (((((!((map__25543 == null))))?(((((map__25543.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25543.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25543):map__25543);
var where_result = map__25543__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25543__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25543__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25546 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5733__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5733__auto__)){
var index_of = temp__5733__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25546,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25546,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25546,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_25579){
var state_val_25580 = (state_25579[(1)]);
if((state_val_25580 === (7))){
var inst_25558 = (state_25579[(7)]);
var state_25579__$1 = state_25579;
var statearr_25581_25604 = state_25579__$1;
(statearr_25581_25604[(2)] = inst_25558);

(statearr_25581_25604[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25580 === (1))){
var state_25579__$1 = state_25579;
var statearr_25582_25605 = state_25579__$1;
(statearr_25582_25605[(2)] = null);

(statearr_25582_25605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25580 === (4))){
var inst_25549 = (state_25579[(2)]);
var state_25579__$1 = state_25579;
var statearr_25583_25606 = state_25579__$1;
(statearr_25583_25606[(2)] = inst_25549);

(statearr_25583_25606[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25580 === (13))){
var inst_25568 = (state_25579[(2)]);
var inst_25569 = fluree.db.util.async.throw_err(inst_25568);
var state_25579__$1 = state_25579;
var statearr_25584_25607 = state_25579__$1;
(statearr_25584_25607[(2)] = inst_25569);

(statearr_25584_25607[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25580 === (6))){
var inst_25558 = (state_25579[(7)]);
var inst_25557 = (state_25579[(2)]);
var inst_25558__$1 = fluree.db.util.async.throw_err(inst_25557);
var inst_25559 = fluree.db.util.core.exception_QMARK_(inst_25558__$1);
var state_25579__$1 = (function (){var statearr_25585 = state_25579;
(statearr_25585[(7)] = inst_25558__$1);

return statearr_25585;
})();
if(inst_25559){
var statearr_25586_25608 = state_25579__$1;
(statearr_25586_25608[(1)] = (7));

} else {
var statearr_25587_25609 = state_25579__$1;
(statearr_25587_25609[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25580 === (3))){
var inst_25577 = (state_25579[(2)]);
var state_25579__$1 = state_25579;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25579__$1,inst_25577);
} else {
if((state_val_25580 === (12))){
var inst_25572 = (state_25579[(2)]);
var state_25579__$1 = state_25579;
var statearr_25588_25610 = state_25579__$1;
(statearr_25588_25610[(2)] = inst_25572);

(statearr_25588_25610[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25580 === (2))){
var _ = (function (){var statearr_25589 = state_25579;
(statearr_25589[(4)] = cljs.core.cons((5),(state_25579[(4)])));

return statearr_25589;
})();
var inst_25555 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_25579__$1 = state_25579;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25579__$1,(6),inst_25555);
} else {
if((state_val_25580 === (11))){
var state_25579__$1 = state_25579;
var statearr_25591_25611 = state_25579__$1;
(statearr_25591_25611[(2)] = null);

(statearr_25591_25611[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25580 === (9))){
var inst_25574 = (state_25579[(2)]);
var _ = (function (){var statearr_25592 = state_25579;
(statearr_25592[(4)] = cljs.core.rest((state_25579[(4)])));

return statearr_25592;
})();
var state_25579__$1 = state_25579;
var statearr_25593_25612 = state_25579__$1;
(statearr_25593_25612[(2)] = inst_25574);

(statearr_25593_25612[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25580 === (5))){
var _ = (function (){var statearr_25594 = state_25579;
(statearr_25594[(4)] = cljs.core.rest((state_25579[(4)])));

return statearr_25594;
})();
var state_25579__$1 = state_25579;
var ex25590 = (state_25579__$1[(2)]);
var statearr_25595_25613 = state_25579__$1;
(statearr_25595_25613[(5)] = ex25590);


if((ex25590 instanceof Error)){
var statearr_25596_25614 = state_25579__$1;
(statearr_25596_25614[(1)] = (4));

(statearr_25596_25614[(5)] = null);

} else {
throw ex25590;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25580 === (10))){
var inst_25558 = (state_25579[(7)]);
var inst_25563 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_25558);
var inst_25564 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_25558);
var inst_25565 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_25563,inst_25564,query_map,opts);
var inst_25566 = fluree.db.query.fql.process_ad_hoc_res(db,inst_25558,inst_25565,opts);
var state_25579__$1 = state_25579;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25579__$1,(13),inst_25566);
} else {
if((state_val_25580 === (8))){
var state_25579__$1 = state_25579;
var statearr_25597_25615 = state_25579__$1;
(statearr_25597_25615[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto____0 = (function (){
var statearr_25599 = [null,null,null,null,null,null,null,null];
(statearr_25599[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto__);

(statearr_25599[(1)] = (1));

return statearr_25599;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto____1 = (function (state_25579){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_25579);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e25600){var ex__2882__auto__ = e25600;
var statearr_25601_25616 = state_25579;
(statearr_25601_25616[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_25579[(4)]))){
var statearr_25602_25617 = state_25579;
(statearr_25602_25617[(1)] = cljs.core.first((state_25579[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25618 = state_25579;
state_25579 = G__25618;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto__ = function(state_25579){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto____1.call(this,state_25579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_25603 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_25603[(6)] = c__2901__auto__);

return statearr_25603;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns core async channel with results
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__25619 = query_map;
var map__25619__$1 = (((((!((map__25619 == null))))?(((((map__25619.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25619.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__25619):map__25619);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25619__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25619__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25619__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25619__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25619__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25619__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25619__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25619__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25619__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25619__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25619__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__25619__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__25621 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4126__auto__ = offset;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__25621,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__25621;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.truth_((function (){var or__4126__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_25992){
var state_val_25993 = (state_25992[(1)]);
if((state_val_25993 === (121))){
var inst_25705 = (state_25992[(7)]);
var inst_25937 = (state_25992[(8)]);
var inst_25933 = (state_25992[(9)]);
var inst_25703 = (state_25992[(10)]);
var inst_25941 = (state_25992[(2)]);
var inst_25942 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25705,fuel,max_fuel,inst_25703,inst_25933,inst_25937,inst_25941);
var state_25992__$1 = state_25992;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25992__$1,(115),inst_25942);
} else {
if((state_val_25993 === (65))){
var inst_25705 = (state_25992[(7)]);
var inst_25693 = (state_25992[(11)]);
var inst_25703 = (state_25992[(10)]);
var inst_25782 = (state_25992[(12)]);
var inst_25796 = (state_25992[(2)]);
var inst_25797 = fluree.db.util.async.throw_err(inst_25796);
var inst_25798 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_25782,inst_25797);
var inst_25799 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_25705,fuel,max_fuel,inst_25703,inst_25798,inst_25693);
var state_25992__$1 = state_25992;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25992__$1,(66),inst_25799);
} else {
if((state_val_25993 === (70))){
var inst_25692 = (state_25992[(13)]);
var state_25992__$1 = state_25992;
if(cljs.core.truth_(inst_25692)){
var statearr_25994_26186 = state_25992__$1;
(statearr_25994_26186[(1)] = (73));

} else {
var statearr_25995_26187 = state_25992__$1;
(statearr_25995_26187[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (62))){
var inst_25784 = cljs.core.PersistentHashMap.EMPTY;
var state_25992__$1 = state_25992;
var statearr_25996_26188 = state_25992__$1;
(statearr_25996_26188[(2)] = inst_25784);

(statearr_25996_26188[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (74))){
var inst_25693 = (state_25992[(11)]);
var inst_25695 = (state_25992[(14)]);
var inst_25818 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25819 = [inst_25693,inst_25695];
var inst_25820 = cljs.core.PersistentHashMap.fromArrays(inst_25818,inst_25819);
var state_25992__$1 = state_25992;
var statearr_25997_26189 = state_25992__$1;
(statearr_25997_26189[(2)] = inst_25820);

(statearr_25997_26189[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (110))){
var inst_25901 = (state_25992[(15)]);
var inst_25915 = (state_25992[(2)]);
var inst_25916 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_25901,false);
var state_25992__$1 = (function (){var statearr_25998 = state_25992;
(statearr_25998[(16)] = inst_25915);

return statearr_25998;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25992__$1,(111),inst_25916);
} else {
if((state_val_25993 === (130))){
var inst_25982 = (state_25992[(2)]);
var state_25992__$1 = state_25992;
if(cljs.core.truth_(inst_25982)){
var statearr_25999_26190 = state_25992__$1;
(statearr_25999_26190[(1)] = (131));

} else {
var statearr_26000_26191 = state_25992__$1;
(statearr_26000_26191[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (128))){
var inst_25973 = (state_25992[(17)]);
var inst_25976 = cljs.core.coll_QMARK_(inst_25973);
var inst_25977 = fluree.db.util.core.exception_QMARK_(inst_25973);
var inst_25978 = (!(inst_25977));
var inst_25979 = ((inst_25976) && (inst_25978));
var state_25992__$1 = state_25992;
var statearr_26001_26192 = state_25992__$1;
(statearr_26001_26192[(2)] = inst_25979);

(statearr_26001_26192[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (7))){
var inst_25653 = (state_25992[(18)]);
var inst_25653__$1 = selectOne;
var state_25992__$1 = (function (){var statearr_26002 = state_25992;
(statearr_26002[(18)] = inst_25653__$1);

return statearr_26002;
})();
if(cljs.core.truth_(inst_25653__$1)){
var statearr_26003_26193 = state_25992__$1;
(statearr_26003_26193[(1)] = (9));

} else {
var statearr_26004_26194 = state_25992__$1;
(statearr_26004_26194[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (59))){
var inst_25776 = (state_25992[(19)]);
var inst_25778 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_25779 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_25776,inst_25778);
var state_25992__$1 = state_25992;
var statearr_26005_26195 = state_25992__$1;
(statearr_26005_26195[(2)] = inst_25779);

(statearr_26005_26195[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (86))){
var inst_25854 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_25992__$1 = state_25992;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25992__$1,(89),inst_25854);
} else {
if((state_val_25993 === (20))){
var inst_25683 = (state_25992[(2)]);
var state_25992__$1 = state_25992;
var statearr_26006_26196 = state_25992__$1;
(statearr_26006_26196[(2)] = inst_25683);

(statearr_26006_26196[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (72))){
var inst_25964 = (state_25992[(2)]);
var state_25992__$1 = state_25992;
var statearr_26007_26197 = state_25992__$1;
(statearr_26007_26197[(2)] = inst_25964);

(statearr_26007_26197[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (58))){
var inst_25776 = (state_25992[(2)]);
var state_25992__$1 = (function (){var statearr_26008 = state_25992;
(statearr_26008[(19)] = inst_25776);

return statearr_26008;
})();
var statearr_26009_26198 = state_25992__$1;
(statearr_26009_26198[(1)] = (59));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (60))){
var inst_25776 = (state_25992[(19)]);
var state_25992__$1 = state_25992;
var statearr_26011_26199 = state_25992__$1;
(statearr_26011_26199[(2)] = inst_25776);

(statearr_26011_26199[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (27))){
var inst_25692 = (state_25992[(13)]);
var inst_25707 = cljs.core.vector_QMARK_(inst_25692);
var state_25992__$1 = state_25992;
if(inst_25707){
var statearr_26012_26200 = state_25992__$1;
(statearr_26012_26200[(1)] = (30));

} else {
var statearr_26013_26201 = state_25992__$1;
(statearr_26013_26201[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (1))){
var state_25992__$1 = state_25992;
var statearr_26014_26202 = state_25992__$1;
(statearr_26014_26202[(2)] = null);

(statearr_26014_26202[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (69))){
var inst_25813 = (state_25992[(2)]);
var state_25992__$1 = state_25992;
if(cljs.core.truth_(inst_25813)){
var statearr_26015_26203 = state_25992__$1;
(statearr_26015_26203[(1)] = (70));

} else {
var statearr_26016_26204 = state_25992__$1;
(statearr_26016_26204[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (101))){
var inst_25692 = (state_25992[(13)]);
var inst_25931 = (state_25992[(2)]);
var inst_25932 = cljs.core.PersistentVector.EMPTY;
var inst_25933 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25932,inst_25931);
var state_25992__$1 = (function (){var statearr_26017 = state_25992;
(statearr_26017[(9)] = inst_25933);

return statearr_26017;
})();
if(cljs.core.truth_(inst_25692)){
var statearr_26018_26205 = state_25992__$1;
(statearr_26018_26205[(1)] = (116));

} else {
var statearr_26019_26206 = state_25992__$1;
(statearr_26019_26206[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (24))){
var inst_25694 = (state_25992[(20)]);
var inst_25696 = (state_25992[(21)]);
var inst_25700 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_25696,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_25694);
var state_25992__$1 = state_25992;
var statearr_26020_26207 = state_25992__$1;
(statearr_26020_26207[(2)] = inst_25700);

(statearr_26020_26207[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (102))){
var inst_25895 = (state_25992[(22)]);
var state_25992__$1 = state_25992;
var statearr_26021_26208 = state_25992__$1;
(statearr_26021_26208[(2)] = inst_25895);

(statearr_26021_26208[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (55))){
var inst_25966 = (state_25992[(2)]);
var state_25992__$1 = state_25992;
var statearr_26022_26209 = state_25992__$1;
(statearr_26022_26209[(2)] = inst_25966);

(statearr_26022_26209[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (85))){
var inst_25848 = (state_25992[(2)]);
var inst_25849 = fluree.db.util.async.throw_err(inst_25848);
var state_25992__$1 = state_25992;
var statearr_26023_26210 = state_25992__$1;
(statearr_26023_26210[(2)] = inst_25849);

(statearr_26023_26210[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (39))){
var inst_25742 = typeof from === 'string';
var state_25992__$1 = state_25992;
if(cljs.core.truth_(inst_25742)){
var statearr_26024_26211 = state_25992__$1;
(statearr_26024_26211[(1)] = (42));

} else {
var statearr_26025_26212 = state_25992__$1;
(statearr_26025_26212[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (88))){
var inst_25960 = (state_25992[(2)]);
var state_25992__$1 = state_25992;
var statearr_26026_26213 = state_25992__$1;
(statearr_26026_26213[(2)] = inst_25960);

(statearr_26026_26213[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (46))){
var inst_25761 = (state_25992[(2)]);
var inst_25762 = fluree.db.util.async.throw_err(inst_25761);
var state_25992__$1 = state_25992;
var statearr_26027_26214 = state_25992__$1;
(statearr_26027_26214[(2)] = inst_25762);

(statearr_26027_26214[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (4))){
var inst_25640 = (state_25992[(2)]);
var state_25992__$1 = state_25992;
var statearr_26028_26215 = state_25992__$1;
(statearr_26028_26215[(2)] = inst_25640);

(statearr_26028_26215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (77))){
var inst_25829 = (state_25992[(2)]);
var inst_25830 = fluree.db.util.async.throw_err(inst_25829);
var state_25992__$1 = state_25992;
var statearr_26029_26216 = state_25992__$1;
(statearr_26029_26216[(2)] = inst_25830);

(statearr_26029_26216[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (106))){
var state_25992__$1 = state_25992;
if(cljs.core.truth_(fuel)){
var statearr_26030_26217 = state_25992__$1;
(statearr_26030_26217[(1)] = (108));

} else {
var statearr_26031_26218 = state_25992__$1;
(statearr_26031_26218[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (119))){
var state_25992__$1 = state_25992;
var statearr_26032_26219 = state_25992__$1;
(statearr_26032_26219[(2)] = null);

(statearr_26032_26219[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (95))){
var state_25992__$1 = state_25992;
var statearr_26033_26220 = state_25992__$1;
(statearr_26033_26220[(2)] = null);

(statearr_26033_26220[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (54))){
var inst_25805 = typeof from === 'string';
var state_25992__$1 = state_25992;
if(cljs.core.truth_(inst_25805)){
var statearr_26034_26221 = state_25992__$1;
(statearr_26034_26221[(1)] = (67));

} else {
var statearr_26035_26222 = state_25992__$1;
(statearr_26035_26222[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (92))){
var inst_25705 = (state_25992[(7)]);
var inst_25693 = (state_25992[(11)]);
var inst_25703 = (state_25992[(10)]);
var inst_25695 = (state_25992[(14)]);
var inst_25865 = (state_25992[(2)]);
var inst_25866 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25705,fuel,max_fuel,inst_25703,inst_25865,inst_25693,inst_25695);
var state_25992__$1 = state_25992;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25992__$1,(93),inst_25866);
} else {
if((state_val_25993 === (104))){
var inst_25929 = (state_25992[(2)]);
var state_25992__$1 = state_25992;
var statearr_26036_26223 = state_25992__$1;
(statearr_26036_26223[(2)] = inst_25929);

(statearr_26036_26223[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (15))){
var inst_25670 = (state_25992[(23)]);
var inst_25675 = inst_25670.cljs$lang$protocol_mask$partition0$;
var inst_25676 = (inst_25675 & (64));
var inst_25677 = inst_25670.cljs$core$ISeq$;
var inst_25678 = (cljs.core.PROTOCOL_SENTINEL === inst_25677);
var inst_25679 = ((inst_25676) || (inst_25678));
var state_25992__$1 = state_25992;
if(cljs.core.truth_(inst_25679)){
var statearr_26037_26224 = state_25992__$1;
(statearr_26037_26224[(1)] = (18));

} else {
var statearr_26038_26225 = state_25992__$1;
(statearr_26038_26225[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (48))){
var inst_25693 = (state_25992[(11)]);
var state_25992__$1 = state_25992;
var statearr_26039_26226 = state_25992__$1;
(statearr_26039_26226[(2)] = inst_25693);

(statearr_26039_26226[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (50))){
var state_25992__$1 = state_25992;
var statearr_26040_26227 = state_25992__$1;
(statearr_26040_26227[(2)] = null);

(statearr_26040_26227[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (116))){
var state_25992__$1 = state_25992;
var statearr_26041_26228 = state_25992__$1;
(statearr_26041_26228[(2)] = null);

(statearr_26041_26228[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (75))){
var inst_25822 = (state_25992[(2)]);
var inst_25823 = fluree.db.query.range._block_or_tx_collection(db,inst_25822);
var state_25992__$1 = state_25992;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25992__$1,(76),inst_25823);
} else {
if((state_val_25993 === (99))){
var inst_25958 = (state_25992[(2)]);
var state_25992__$1 = state_25992;
var statearr_26042_26229 = state_25992__$1;
(statearr_26042_26229[(2)] = inst_25958);

(statearr_26042_26229[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (21))){
var inst_25670 = (state_25992[(23)]);
var inst_25688 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_25670);
var state_25992__$1 = state_25992;
var statearr_26043_26230 = state_25992__$1;
(statearr_26043_26230[(2)] = inst_25688);

(statearr_26043_26230[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (31))){
var inst_25692 = (state_25992[(13)]);
var inst_25715 = typeof inst_25692 === 'string';
var state_25992__$1 = state_25992;
if(cljs.core.truth_(inst_25715)){
var statearr_26044_26231 = state_25992__$1;
(statearr_26044_26231[(1)] = (33));

} else {
var statearr_26045_26232 = state_25992__$1;
(statearr_26045_26232[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (113))){
var inst_25895 = (state_25992[(22)]);
var state_25992__$1 = state_25992;
var statearr_26046_26233 = state_25992__$1;
(statearr_26046_26233[(2)] = inst_25895);

(statearr_26046_26233[(1)] = (114));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (32))){
var inst_25731 = (state_25992[(2)]);
var state_25992__$1 = state_25992;
var statearr_26047_26234 = state_25992__$1;
(statearr_26047_26234[(2)] = inst_25731);

(statearr_26047_26234[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (40))){
var inst_25764 = typeof from === 'string';
var inst_25765 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_25766 = clojure.string.includes_QMARK_(inst_25765,"/");
var inst_25767 = ((inst_25764) && (inst_25766));
var state_25992__$1 = state_25992;
if(cljs.core.truth_(inst_25767)){
var statearr_26048_26235 = state_25992__$1;
(statearr_26048_26235[(1)] = (53));

} else {
var statearr_26049_26236 = state_25992__$1;
(statearr_26049_26236[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (129))){
var inst_25974 = (state_25992[(24)]);
var state_25992__$1 = state_25992;
var statearr_26050_26237 = state_25992__$1;
(statearr_26050_26237[(2)] = inst_25974);

(statearr_26050_26237[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (91))){
var inst_25857 = (state_25992[(25)]);
var inst_25861 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25862 = [inst_25857];
var inst_25863 = (new cljs.core.PersistentVector(null,1,(5),inst_25861,inst_25862,null));
var state_25992__$1 = state_25992;
var statearr_26051_26238 = state_25992__$1;
(statearr_26051_26238[(2)] = inst_25863);

(statearr_26051_26238[(1)] = (92));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (117))){
var inst_25693 = (state_25992[(11)]);
var state_25992__$1 = state_25992;
var statearr_26052_26239 = state_25992__$1;
(statearr_26052_26239[(2)] = inst_25693);

(statearr_26052_26239[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (108))){
var inst_25910 = cljs.core._deref(fuel);
var inst_25911 = (inst_25910 + (1));
var inst_25912 = cljs.core._vreset_BANG_(fuel,inst_25911);
var state_25992__$1 = state_25992;
var statearr_26053_26240 = state_25992__$1;
(statearr_26053_26240[(2)] = inst_25912);

(statearr_26053_26240[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (56))){
var inst_25770 = (state_25992[(26)]);
var inst_25772 = fluree.db.query.fql.fuel_flake_transducer(fuel,max_fuel);
var inst_25773 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_25770,inst_25772);
var state_25992__$1 = state_25992;
var statearr_26054_26241 = state_25992__$1;
(statearr_26054_26241[(2)] = inst_25773);

(statearr_26054_26241[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (33))){
var inst_25692 = (state_25992[(13)]);
var inst_25717 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25718 = [inst_25692,"ASC"];
var inst_25719 = (new cljs.core.PersistentVector(null,2,(5),inst_25717,inst_25718,null));
var state_25992__$1 = state_25992;
var statearr_26055_26242 = state_25992__$1;
(statearr_26055_26242[(2)] = inst_25719);

(statearr_26055_26242[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (13))){
var inst_25659 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25660 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25661 = cljs.core.PersistentHashMap.fromArrays(inst_25659,inst_25660);
var inst_25662 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_25661);
var inst_25663 = (function(){throw inst_25662})();
var state_25992__$1 = state_25992;
var statearr_26056_26243 = state_25992__$1;
(statearr_26056_26243[(2)] = inst_25663);

(statearr_26056_26243[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (22))){
var inst_25670 = (state_25992[(23)]);
var state_25992__$1 = state_25992;
var statearr_26057_26244 = state_25992__$1;
(statearr_26057_26244[(2)] = inst_25670);

(statearr_26057_26244[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (90))){
var state_25992__$1 = state_25992;
var statearr_26058_26245 = state_25992__$1;
(statearr_26058_26245[(2)] = null);

(statearr_26058_26245[(1)] = (92));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (109))){
var state_25992__$1 = state_25992;
var statearr_26059_26246 = state_25992__$1;
(statearr_26059_26246[(2)] = null);

(statearr_26059_26246[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (36))){
var inst_25722 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25723 = [null,null];
var inst_25724 = (new cljs.core.PersistentVector(null,2,(5),inst_25722,inst_25723,null));
var state_25992__$1 = state_25992;
var statearr_26060_26247 = state_25992__$1;
(statearr_26060_26247[(2)] = inst_25724);

(statearr_26060_26247[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (41))){
var inst_25738 = (state_25992[(27)]);
var inst_25968 = (state_25992[(2)]);
var state_25992__$1 = (function (){var statearr_26061 = state_25992;
(statearr_26061[(28)] = inst_25968);

return statearr_26061;
})();
if(cljs.core.truth_(inst_25738)){
var statearr_26062_26248 = state_25992__$1;
(statearr_26062_26248[(1)] = (125));

} else {
var statearr_26063_26249 = state_25992__$1;
(statearr_26063_26249[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (118))){
var inst_25692 = (state_25992[(13)]);
var inst_25937 = (state_25992[(2)]);
var state_25992__$1 = (function (){var statearr_26064 = state_25992;
(statearr_26064[(8)] = inst_25937);

return statearr_26064;
})();
if(cljs.core.truth_(inst_25692)){
var statearr_26065_26250 = state_25992__$1;
(statearr_26065_26250[(1)] = (119));

} else {
var statearr_26066_26251 = state_25992__$1;
(statearr_26066_26251[(1)] = (120));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (89))){
var inst_25857 = (state_25992[(25)]);
var inst_25856 = (state_25992[(2)]);
var inst_25857__$1 = fluree.db.util.async.throw_err(inst_25856);
var inst_25858 = (inst_25857__$1 == null);
var state_25992__$1 = (function (){var statearr_26067 = state_25992;
(statearr_26067[(25)] = inst_25857__$1);

return statearr_26067;
})();
if(cljs.core.truth_(inst_25858)){
var statearr_26068_26252 = state_25992__$1;
(statearr_26068_26252[(1)] = (90));

} else {
var statearr_26069_26253 = state_25992__$1;
(statearr_26069_26253[(1)] = (91));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (100))){
var inst_25901 = (state_25992[(15)]);
var inst_25894 = (state_25992[(29)]);
var inst_25900 = cljs.core.seq(inst_25894);
var inst_25901__$1 = cljs.core.first(inst_25900);
var inst_25902 = cljs.core.next(inst_25900);
var inst_25903 = cljs.core.not(inst_25901__$1);
var state_25992__$1 = (function (){var statearr_26070 = state_25992;
(statearr_26070[(30)] = inst_25902);

(statearr_26070[(15)] = inst_25901__$1);

return statearr_26070;
})();
if(inst_25903){
var statearr_26071_26254 = state_25992__$1;
(statearr_26071_26254[(1)] = (102));

} else {
var statearr_26072_26255 = state_25992__$1;
(statearr_26072_26255[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (131))){
var inst_25973 = (state_25992[(17)]);
var inst_25984 = cljs.core.first(inst_25973);
var state_25992__$1 = state_25992;
var statearr_26073_26256 = state_25992__$1;
(statearr_26073_26256[(2)] = inst_25984);

(statearr_26073_26256[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (122))){
var inst_25948 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_25949 = ["Invalid 'from' in query:",inst_25948].join('');
var inst_25950 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25951 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25952 = cljs.core.PersistentHashMap.fromArrays(inst_25950,inst_25951);
var inst_25953 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_25949,inst_25952);
var state_25992__$1 = state_25992;
var statearr_26074_26257 = state_25992__$1;
(statearr_26074_26257[(2)] = inst_25953);

(statearr_26074_26257[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (43))){
var state_25992__$1 = state_25992;
var statearr_26075_26258 = state_25992__$1;
(statearr_26075_26258[(2)] = null);

(statearr_26075_26258[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (61))){
var inst_25692 = (state_25992[(13)]);
var inst_25782 = (state_25992[(2)]);
var state_25992__$1 = (function (){var statearr_26076 = state_25992;
(statearr_26076[(12)] = inst_25782);

return statearr_26076;
})();
if(cljs.core.truth_(inst_25692)){
var statearr_26077_26259 = state_25992__$1;
(statearr_26077_26259[(1)] = (62));

} else {
var statearr_26078_26260 = state_25992__$1;
(statearr_26078_26260[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (29))){
var inst_25737 = (state_25992[(2)]);
var inst_25738 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25737,(0),null);
var inst_25739 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25737,(1),null);
var inst_25740 = typeof where === 'string';
var state_25992__$1 = (function (){var statearr_26079 = state_25992;
(statearr_26079[(27)] = inst_25738);

(statearr_26079[(31)] = inst_25739);

return statearr_26079;
})();
if(cljs.core.truth_(inst_25740)){
var statearr_26080_26261 = state_25992__$1;
(statearr_26080_26261[(1)] = (39));

} else {
var statearr_26081_26262 = state_25992__$1;
(statearr_26081_26262[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (44))){
var inst_25746 = (state_25992[(2)]);
var inst_25747 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_25746);
var state_25992__$1 = state_25992;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25992__$1,(45),inst_25747);
} else {
if((state_val_25993 === (93))){
var inst_25868 = (state_25992[(2)]);
var inst_25869 = fluree.db.util.async.throw_err(inst_25868);
var state_25992__$1 = (function (){var statearr_26082 = state_25992;
(statearr_26082[(32)] = inst_25869);

return statearr_26082;
})();
if(cljs.core.truth_(fuel)){
var statearr_26083_26263 = state_25992__$1;
(statearr_26083_26263[(1)] = (94));

} else {
var statearr_26084_26264 = state_25992__$1;
(statearr_26084_26264[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (6))){
var inst_25650 = (state_25992[(33)]);
var state_25992__$1 = state_25992;
var statearr_26085_26265 = state_25992__$1;
(statearr_26085_26265[(2)] = inst_25650);

(statearr_26085_26265[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (111))){
var inst_25918 = (state_25992[(2)]);
var inst_25919 = fluree.db.util.async.throw_err(inst_25918);
var state_25992__$1 = state_25992;
var statearr_26086_26266 = state_25992__$1;
(statearr_26086_26266[(2)] = inst_25919);

(statearr_26086_26266[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (28))){
var inst_25733 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25734 = [null,null];
var inst_25735 = (new cljs.core.PersistentVector(null,2,(5),inst_25733,inst_25734,null));
var state_25992__$1 = state_25992;
var statearr_26087_26267 = state_25992__$1;
(statearr_26087_26267[(2)] = inst_25735);

(statearr_26087_26267[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (64))){
var inst_25790 = (state_25992[(2)]);
var inst_25791 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25792 = [from];
var inst_25793 = (new cljs.core.PersistentVector(null,1,(5),inst_25791,inst_25792,null));
var inst_25794 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25793,inst_25790);
var state_25992__$1 = state_25992;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25992__$1,(65),inst_25794);
} else {
if((state_val_25993 === (103))){
var inst_25901 = (state_25992[(15)]);
var inst_25906 = cljs.core.int_QMARK_(inst_25901);
var state_25992__$1 = state_25992;
if(inst_25906){
var statearr_26088_26268 = state_25992__$1;
(statearr_26088_26268[(1)] = (105));

} else {
var statearr_26089_26269 = state_25992__$1;
(statearr_26089_26269[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (51))){
var inst_25695 = (state_25992[(14)]);
var state_25992__$1 = state_25992;
var statearr_26090_26270 = state_25992__$1;
(statearr_26090_26270[(2)] = inst_25695);

(statearr_26090_26270[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (25))){
var inst_25696 = (state_25992[(21)]);
var state_25992__$1 = state_25992;
var statearr_26091_26271 = state_25992__$1;
(statearr_26091_26271[(2)] = inst_25696);

(statearr_26091_26271[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (34))){
var state_25992__$1 = state_25992;
var statearr_26092_26272 = state_25992__$1;
(statearr_26092_26272[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (125))){
var inst_25693 = (state_25992[(11)]);
var inst_25968 = (state_25992[(28)]);
var inst_25738 = (state_25992[(27)]);
var inst_25739 = (state_25992[(31)]);
var inst_25695 = (state_25992[(14)]);
var inst_25970 = fluree.db.query.fql.sort_offset_and_limit_res(inst_25738,inst_25739,inst_25695,inst_25693,inst_25968);
var state_25992__$1 = state_25992;
var statearr_26094_26273 = state_25992__$1;
(statearr_26094_26273[(2)] = inst_25970);

(statearr_26094_26273[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (17))){
var inst_25686 = (state_25992[(2)]);
var state_25992__$1 = state_25992;
if(cljs.core.truth_(inst_25686)){
var statearr_26095_26274 = state_25992__$1;
(statearr_26095_26274[(1)] = (21));

} else {
var statearr_26096_26275 = state_25992__$1;
(statearr_26096_26275[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (3))){
var inst_25990 = (state_25992[(2)]);
var state_25992__$1 = state_25992;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25992__$1,inst_25990);
} else {
if((state_val_25993 === (12))){
var inst_25656 = (state_25992[(34)]);
var state_25992__$1 = state_25992;
var statearr_26097_26276 = state_25992__$1;
(statearr_26097_26276[(2)] = inst_25656);

(statearr_26097_26276[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (2))){
var inst_25650 = (state_25992[(33)]);
var _ = (function (){var statearr_26098 = state_25992;
(statearr_26098[(4)] = cljs.core.cons((5),(state_25992[(4)])));

return statearr_26098;
})();
var inst_25650__$1 = select;
var state_25992__$1 = (function (){var statearr_26099 = state_25992;
(statearr_26099[(33)] = inst_25650__$1);

return statearr_26099;
})();
if(cljs.core.truth_(inst_25650__$1)){
var statearr_26100_26277 = state_25992__$1;
(statearr_26100_26277[(1)] = (6));

} else {
var statearr_26101_26278 = state_25992__$1;
(statearr_26101_26278[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (66))){
var inst_25801 = (state_25992[(2)]);
var inst_25802 = fluree.db.util.async.throw_err(inst_25801);
var state_25992__$1 = state_25992;
var statearr_26102_26279 = state_25992__$1;
(statearr_26102_26279[(2)] = inst_25802);

(statearr_26102_26279[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (107))){
var inst_25921 = (state_25992[(35)]);
var inst_25921__$1 = (state_25992[(2)]);
var state_25992__$1 = (function (){var statearr_26103 = state_25992;
(statearr_26103[(35)] = inst_25921__$1);

return statearr_26103;
})();
if(cljs.core.truth_(inst_25921__$1)){
var statearr_26104_26280 = state_25992__$1;
(statearr_26104_26280[(1)] = (112));

} else {
var statearr_26105_26281 = state_25992__$1;
(statearr_26105_26281[(1)] = (113));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (23))){
var inst_25694 = (state_25992[(20)]);
var inst_25669 = (state_25992[(36)]);
var inst_25691 = (state_25992[(2)]);
var inst_25692 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25691,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_25693 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25691,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25694__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25691,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_25695 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_25691,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_25696 = fluree.db.query.fql_parser.parse_db(db,inst_25669,opts_SINGLEQUOTE_);
var inst_25697 = (inst_25694__$1 == null);
var inst_25698 = cljs.core.not(inst_25697);
var state_25992__$1 = (function (){var statearr_26106 = state_25992;
(statearr_26106[(11)] = inst_25693);

(statearr_26106[(13)] = inst_25692);

(statearr_26106[(20)] = inst_25694__$1);

(statearr_26106[(21)] = inst_25696);

(statearr_26106[(14)] = inst_25695);

return statearr_26106;
})();
if(inst_25698){
var statearr_26107_26282 = state_25992__$1;
(statearr_26107_26282[(1)] = (24));

} else {
var statearr_26108_26283 = state_25992__$1;
(statearr_26108_26283[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (47))){
var state_25992__$1 = state_25992;
var statearr_26109_26284 = state_25992__$1;
(statearr_26109_26284[(2)] = null);

(statearr_26109_26284[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (35))){
var inst_25729 = (state_25992[(2)]);
var state_25992__$1 = state_25992;
var statearr_26110_26285 = state_25992__$1;
(statearr_26110_26285[(2)] = inst_25729);

(statearr_26110_26285[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (127))){
var inst_25974 = (state_25992[(24)]);
var inst_25973 = (state_25992[(2)]);
var inst_25974__$1 = selectOne;
var state_25992__$1 = (function (){var statearr_26111 = state_25992;
(statearr_26111[(24)] = inst_25974__$1);

(statearr_26111[(17)] = inst_25973);

return statearr_26111;
})();
if(cljs.core.truth_(inst_25974__$1)){
var statearr_26112_26286 = state_25992__$1;
(statearr_26112_26286[(1)] = (128));

} else {
var statearr_26113_26287 = state_25992__$1;
(statearr_26113_26287[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (82))){
var inst_25693 = (state_25992[(11)]);
var inst_25695 = (state_25992[(14)]);
var inst_25837 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25838 = [inst_25693,inst_25695];
var inst_25839 = cljs.core.PersistentHashMap.fromArrays(inst_25837,inst_25838);
var state_25992__$1 = state_25992;
var statearr_26114_26288 = state_25992__$1;
(statearr_26114_26288[(2)] = inst_25839);

(statearr_26114_26288[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (76))){
var inst_25705 = (state_25992[(7)]);
var inst_25703 = (state_25992[(10)]);
var inst_25825 = (state_25992[(2)]);
var inst_25826 = fluree.db.util.async.throw_err(inst_25825);
var inst_25827 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_25705,fuel,max_fuel,inst_25703,inst_25826);
var state_25992__$1 = state_25992;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25992__$1,(77),inst_25827);
} else {
if((state_val_25993 === (97))){
var inst_25889 = from;
var inst_25890 = cljs.core.seq(inst_25889);
var inst_25891 = cljs.core.first(inst_25890);
var inst_25892 = cljs.core.next(inst_25890);
var inst_25893 = cljs.core.PersistentVector.EMPTY;
var inst_25894 = inst_25889;
var inst_25895 = inst_25893;
var state_25992__$1 = (function (){var statearr_26115 = state_25992;
(statearr_26115[(37)] = inst_25892);

(statearr_26115[(29)] = inst_25894);

(statearr_26115[(22)] = inst_25895);

(statearr_26115[(38)] = inst_25891);

return statearr_26115;
})();
var statearr_26116_26289 = state_25992__$1;
(statearr_26116_26289[(2)] = null);

(statearr_26116_26289[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (19))){
var state_25992__$1 = state_25992;
var statearr_26117_26290 = state_25992__$1;
(statearr_26117_26290[(2)] = false);

(statearr_26117_26290[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (57))){
var inst_25770 = (state_25992[(26)]);
var state_25992__$1 = state_25992;
var statearr_26118_26291 = state_25992__$1;
(statearr_26118_26291[(2)] = inst_25770);

(statearr_26118_26291[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (68))){
var state_25992__$1 = state_25992;
var statearr_26119_26292 = state_25992__$1;
(statearr_26119_26292[(2)] = false);

(statearr_26119_26292[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (11))){
var inst_25667 = (state_25992[(2)]);
var state_25992__$1 = state_25992;
var statearr_26120_26293 = state_25992__$1;
(statearr_26120_26293[(2)] = inst_25667);

(statearr_26120_26293[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (115))){
var inst_25944 = (state_25992[(2)]);
var inst_25945 = fluree.db.util.async.throw_err(inst_25944);
var state_25992__$1 = state_25992;
var statearr_26122_26294 = state_25992__$1;
(statearr_26122_26294[(2)] = inst_25945);

(statearr_26122_26294[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (9))){
var inst_25653 = (state_25992[(18)]);
var state_25992__$1 = state_25992;
var statearr_26123_26295 = state_25992__$1;
(statearr_26123_26295[(2)] = inst_25653);

(statearr_26123_26295[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (5))){
var _ = (function (){var statearr_26124 = state_25992;
(statearr_26124[(4)] = cljs.core.rest((state_25992[(4)])));

return statearr_26124;
})();
var state_25992__$1 = state_25992;
var ex26121 = (state_25992__$1[(2)]);
var statearr_26125_26296 = state_25992__$1;
(statearr_26125_26296[(5)] = ex26121);


if((ex26121 instanceof Error)){
var statearr_26126_26297 = state_25992__$1;
(statearr_26126_26297[(1)] = (4));

(statearr_26126_26297[(5)] = null);

} else {
throw ex26121;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (112))){
var inst_25921 = (state_25992[(35)]);
var inst_25895 = (state_25992[(22)]);
var inst_25923 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_25895,inst_25921);
var state_25992__$1 = state_25992;
var statearr_26127_26298 = state_25992__$1;
(statearr_26127_26298[(2)] = inst_25923);

(statearr_26127_26298[(1)] = (114));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (83))){
var inst_25841 = (state_25992[(2)]);
var inst_25842 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_25841);
var state_25992__$1 = state_25992;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25992__$1,(84),inst_25842);
} else {
if((state_val_25993 === (14))){
var inst_25665 = (state_25992[(2)]);
var state_25992__$1 = state_25992;
var statearr_26128_26299 = state_25992__$1;
(statearr_26128_26299[(2)] = inst_25665);

(statearr_26128_26299[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (45))){
var inst_25692 = (state_25992[(13)]);
var inst_25749 = (state_25992[(2)]);
var inst_25750 = fluree.db.util.async.throw_err(inst_25749);
var state_25992__$1 = (function (){var statearr_26129 = state_25992;
(statearr_26129[(39)] = inst_25750);

return statearr_26129;
})();
if(cljs.core.truth_(inst_25692)){
var statearr_26130_26300 = state_25992__$1;
(statearr_26130_26300[(1)] = (47));

} else {
var statearr_26131_26301 = state_25992__$1;
(statearr_26131_26301[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (53))){
var inst_25770 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_25992__$1 = (function (){var statearr_26132 = state_25992;
(statearr_26132[(26)] = inst_25770);

return statearr_26132;
})();
if(cljs.core.truth_(fuel)){
var statearr_26133_26302 = state_25992__$1;
(statearr_26133_26302[(1)] = (56));

} else {
var statearr_26134_26303 = state_25992__$1;
(statearr_26134_26303[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (78))){
var inst_25692 = (state_25992[(13)]);
var state_25992__$1 = state_25992;
if(cljs.core.truth_(inst_25692)){
var statearr_26135_26304 = state_25992__$1;
(statearr_26135_26304[(1)] = (81));

} else {
var statearr_26136_26305 = state_25992__$1;
(statearr_26136_26305[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (132))){
var inst_25973 = (state_25992[(17)]);
var state_25992__$1 = state_25992;
var statearr_26137_26306 = state_25992__$1;
(statearr_26137_26306[(2)] = inst_25973);

(statearr_26137_26306[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (26))){
var inst_25692 = (state_25992[(13)]);
var inst_25703 = (state_25992[(2)]);
var inst_25704 = cljs.core.PersistentHashMap.EMPTY;
var inst_25705 = cljs.core.volatile_BANG_(inst_25704);
var state_25992__$1 = (function (){var statearr_26138 = state_25992;
(statearr_26138[(7)] = inst_25705);

(statearr_26138[(10)] = inst_25703);

return statearr_26138;
})();
if(cljs.core.truth_(inst_25692)){
var statearr_26139_26307 = state_25992__$1;
(statearr_26139_26307[(1)] = (27));

} else {
var statearr_26140_26308 = state_25992__$1;
(statearr_26140_26308[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (123))){
var state_25992__$1 = state_25992;
var statearr_26141_26309 = state_25992__$1;
(statearr_26141_26309[(2)] = null);

(statearr_26141_26309[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (16))){
var state_25992__$1 = state_25992;
var statearr_26142_26310 = state_25992__$1;
(statearr_26142_26310[(2)] = false);

(statearr_26142_26310[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (133))){
var inst_25987 = (state_25992[(2)]);
var _ = (function (){var statearr_26143 = state_25992;
(statearr_26143[(4)] = cljs.core.rest((state_25992[(4)])));

return statearr_26143;
})();
var state_25992__$1 = state_25992;
var statearr_26144_26311 = state_25992__$1;
(statearr_26144_26311[(2)] = inst_25987);

(statearr_26144_26311[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (81))){
var inst_25835 = cljs.core.PersistentHashMap.EMPTY;
var state_25992__$1 = state_25992;
var statearr_26145_26312 = state_25992__$1;
(statearr_26145_26312[(2)] = inst_25835);

(statearr_26145_26312[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (120))){
var inst_25695 = (state_25992[(14)]);
var state_25992__$1 = state_25992;
var statearr_26146_26313 = state_25992__$1;
(statearr_26146_26313[(2)] = inst_25695);

(statearr_26146_26313[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (79))){
var inst_25851 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_25992__$1 = state_25992;
if(inst_25851){
var statearr_26147_26314 = state_25992__$1;
(statearr_26147_26314[(1)] = (86));

} else {
var statearr_26148_26315 = state_25992__$1;
(statearr_26148_26315[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (38))){
var inst_25727 = (state_25992[(2)]);
var state_25992__$1 = state_25992;
var statearr_26149_26316 = state_25992__$1;
(statearr_26149_26316[(2)] = inst_25727);

(statearr_26149_26316[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (126))){
var inst_25968 = (state_25992[(28)]);
var state_25992__$1 = state_25992;
var statearr_26150_26317 = state_25992__$1;
(statearr_26150_26317[(2)] = inst_25968);

(statearr_26150_26317[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (98))){
var state_25992__$1 = state_25992;
var statearr_26151_26318 = state_25992__$1;
(statearr_26151_26318[(1)] = (122));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (124))){
var inst_25956 = (state_25992[(2)]);
var state_25992__$1 = state_25992;
var statearr_26153_26319 = state_25992__$1;
(statearr_26153_26319[(2)] = inst_25956);

(statearr_26153_26319[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (87))){
var inst_25878 = cljs.core.sequential_QMARK_(from);
var inst_25879 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var inst_25880 = ((inst_25878) && (inst_25879));
var state_25992__$1 = state_25992;
if(cljs.core.truth_(inst_25880)){
var statearr_26154_26320 = state_25992__$1;
(statearr_26154_26320[(1)] = (97));

} else {
var statearr_26155_26321 = state_25992__$1;
(statearr_26155_26321[(1)] = (98));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (30))){
var inst_25692 = (state_25992[(13)]);
var inst_25709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25710 = cljs.core.second(inst_25692);
var inst_25711 = cljs.core.first(inst_25692);
var inst_25712 = [inst_25710,inst_25711];
var inst_25713 = (new cljs.core.PersistentVector(null,2,(5),inst_25709,inst_25712,null));
var state_25992__$1 = state_25992;
var statearr_26156_26322 = state_25992__$1;
(statearr_26156_26322[(2)] = inst_25713);

(statearr_26156_26322[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (73))){
var inst_25816 = cljs.core.PersistentHashMap.EMPTY;
var state_25992__$1 = state_25992;
var statearr_26157_26323 = state_25992__$1;
(statearr_26157_26323[(2)] = inst_25816);

(statearr_26157_26323[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (96))){
var inst_25869 = (state_25992[(32)]);
var inst_25876 = (state_25992[(2)]);
var state_25992__$1 = (function (){var statearr_26158 = state_25992;
(statearr_26158[(40)] = inst_25876);

return statearr_26158;
})();
var statearr_26159_26324 = state_25992__$1;
(statearr_26159_26324[(2)] = inst_25869);

(statearr_26159_26324[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (10))){
var inst_25656 = (state_25992[(34)]);
var inst_25656__$1 = selectDistinct;
var state_25992__$1 = (function (){var statearr_26160 = state_25992;
(statearr_26160[(34)] = inst_25656__$1);

return statearr_26160;
})();
if(cljs.core.truth_(inst_25656__$1)){
var statearr_26161_26325 = state_25992__$1;
(statearr_26161_26325[(1)] = (12));

} else {
var statearr_26162_26326 = state_25992__$1;
(statearr_26162_26326[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (18))){
var state_25992__$1 = state_25992;
var statearr_26163_26327 = state_25992__$1;
(statearr_26163_26327[(2)] = true);

(statearr_26163_26327[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (105))){
var inst_25901 = (state_25992[(15)]);
var state_25992__$1 = state_25992;
var statearr_26164_26328 = state_25992__$1;
(statearr_26164_26328[(2)] = inst_25901);

(statearr_26164_26328[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (52))){
var inst_25705 = (state_25992[(7)]);
var inst_25750 = (state_25992[(39)]);
var inst_25754 = (state_25992[(41)]);
var inst_25703 = (state_25992[(10)]);
var inst_25758 = (state_25992[(2)]);
var inst_25759 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_25705,fuel,max_fuel,inst_25703,inst_25750,inst_25754,inst_25758);
var state_25992__$1 = state_25992;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25992__$1,(46),inst_25759);
} else {
if((state_val_25993 === (114))){
var inst_25902 = (state_25992[(30)]);
var inst_25926 = (state_25992[(2)]);
var inst_25894 = inst_25902;
var inst_25895 = inst_25926;
var state_25992__$1 = (function (){var statearr_26165 = state_25992;
(statearr_26165[(29)] = inst_25894);

(statearr_26165[(22)] = inst_25895);

return statearr_26165;
})();
var statearr_26166_26329 = state_25992__$1;
(statearr_26166_26329[(2)] = null);

(statearr_26166_26329[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (67))){
var inst_25807 = ["_tx",null,"_block",null];
var inst_25808 = (new cljs.core.PersistentArrayMap(null,2,inst_25807,null));
var inst_25809 = (new cljs.core.PersistentHashSet(null,inst_25808,null));
var inst_25810 = (inst_25809.cljs$core$IFn$_invoke$arity$1 ? inst_25809.cljs$core$IFn$_invoke$arity$1(from) : inst_25809.call(null,from));
var state_25992__$1 = state_25992;
var statearr_26167_26330 = state_25992__$1;
(statearr_26167_26330[(2)] = inst_25810);

(statearr_26167_26330[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (71))){
var inst_25832 = typeof from === 'string';
var state_25992__$1 = state_25992;
if(cljs.core.truth_(inst_25832)){
var statearr_26168_26331 = state_25992__$1;
(statearr_26168_26331[(1)] = (78));

} else {
var statearr_26169_26332 = state_25992__$1;
(statearr_26169_26332[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (42))){
var state_25992__$1 = state_25992;
var statearr_26170_26333 = state_25992__$1;
(statearr_26170_26333[(2)] = from);

(statearr_26170_26333[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (80))){
var inst_25962 = (state_25992[(2)]);
var state_25992__$1 = state_25992;
var statearr_26171_26334 = state_25992__$1;
(statearr_26171_26334[(2)] = inst_25962);

(statearr_26171_26334[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (37))){
var state_25992__$1 = state_25992;
var statearr_26172_26335 = state_25992__$1;
(statearr_26172_26335[(2)] = null);

(statearr_26172_26335[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (63))){
var inst_25693 = (state_25992[(11)]);
var inst_25695 = (state_25992[(14)]);
var inst_25786 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25787 = [inst_25693,inst_25695];
var inst_25788 = cljs.core.PersistentHashMap.fromArrays(inst_25786,inst_25787);
var state_25992__$1 = state_25992;
var statearr_26173_26336 = state_25992__$1;
(statearr_26173_26336[(2)] = inst_25788);

(statearr_26173_26336[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (94))){
var inst_25871 = cljs.core._deref(fuel);
var inst_25872 = (inst_25871 + (1));
var inst_25873 = cljs.core._vreset_BANG_(fuel,inst_25872);
var state_25992__$1 = state_25992;
var statearr_26174_26337 = state_25992__$1;
(statearr_26174_26337[(2)] = inst_25873);

(statearr_26174_26337[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (8))){
var inst_25670 = (state_25992[(23)]);
var inst_25669 = (state_25992[(2)]);
var inst_25670__$1 = opts_SINGLEQUOTE_;
var inst_25672 = (inst_25670__$1 == null);
var inst_25673 = cljs.core.not(inst_25672);
var state_25992__$1 = (function (){var statearr_26175 = state_25992;
(statearr_26175[(36)] = inst_25669);

(statearr_26175[(23)] = inst_25670__$1);

return statearr_26175;
})();
if(inst_25673){
var statearr_26176_26338 = state_25992__$1;
(statearr_26176_26338[(1)] = (15));

} else {
var statearr_26177_26339 = state_25992__$1;
(statearr_26177_26339[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (49))){
var inst_25692 = (state_25992[(13)]);
var inst_25754 = (state_25992[(2)]);
var state_25992__$1 = (function (){var statearr_26178 = state_25992;
(statearr_26178[(41)] = inst_25754);

return statearr_26178;
})();
if(cljs.core.truth_(inst_25692)){
var statearr_26179_26340 = state_25992__$1;
(statearr_26179_26340[(1)] = (50));

} else {
var statearr_26180_26341 = state_25992__$1;
(statearr_26180_26341[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25993 === (84))){
var inst_25705 = (state_25992[(7)]);
var inst_25703 = (state_25992[(10)]);
var inst_25844 = (state_25992[(2)]);
var inst_25845 = fluree.db.util.async.throw_err(inst_25844);
var inst_25846 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_25705,fuel,max_fuel,inst_25703,inst_25845);
var state_25992__$1 = state_25992;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25992__$1,(85),inst_25846);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__2879__auto____0 = (function (){
var statearr_26181 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26181[(0)] = fluree$db$query$fql$query_$_state_machine__2879__auto__);

(statearr_26181[(1)] = (1));

return statearr_26181;
});
var fluree$db$query$fql$query_$_state_machine__2879__auto____1 = (function (state_25992){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_25992);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e26182){var ex__2882__auto__ = e26182;
var statearr_26183_26342 = state_25992;
(statearr_26183_26342[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_25992[(4)]))){
var statearr_26184_26343 = state_25992;
(statearr_26184_26343[(1)] = cljs.core.first((state_25992[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26344 = state_25992;
state_25992 = G__26344;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__2879__auto__ = function(state_25992){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__2879__auto____1.call(this,state_25992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__2879__auto____0;
fluree$db$query$fql$query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__2879__auto____1;
return fluree$db$query$fql$query_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_26185 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_26185[(6)] = c__2901__auto__);

return statearr_26185;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}

});
