// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((!((start_flake.o == null)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4126__auto__ = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__13647 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13647,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13647,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13647,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13647,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13647,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13647,(5),null);
var G__13650 = idx;
var G__13650__$1 = (((G__13650 instanceof cljs.core.Keyword))?G__13650.fqn:null);
switch (G__13650__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13650__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__13652 = idx;
var G__13652__$1 = (((G__13652 instanceof cljs.core.Keyword))?G__13652.fqn:null);
switch (G__13652__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13652__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__13654 = idx;
var G__13654__$1 = (((G__13654 instanceof cljs.core.Keyword))?G__13654.fqn:null);
switch (G__13654__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13654__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__13657 = arguments.length;
switch (G__13657) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__13658 = (function (){var pred__13661 = cljs.core.identical_QMARK_;
var expr__13662 = test;
if(cljs.core.truth_((pred__13661.cljs$core$IFn$_invoke$arity$2 ? pred__13661.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__13662) : pred__13661.call(null,cljs.core._EQ_,expr__13662)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__13661.cljs$core$IFn$_invoke$arity$2 ? pred__13661.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__13662) : pred__13661.call(null,cljs.core._LT_,expr__13662)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__13661.cljs$core$IFn$_invoke$arity$2 ? pred__13661.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__13662) : pred__13661.call(null,cljs.core._LT__EQ_,expr__13662)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__13661.cljs$core$IFn$_invoke$arity$2 ? pred__13661.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__13662) : pred__13661.call(null,cljs.core._GT_,expr__13662)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__13661.cljs$core$IFn$_invoke$arity$2 ? pred__13661.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__13662) : pred__13661.call(null,cljs.core._GT__EQ_,expr__13662)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__13662)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13658,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13658,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13658,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__13658,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_13875){
var state_val_13876 = (state_13875[(1)]);
if((state_val_13876 === (65))){
var inst_13828 = (state_13875[(7)]);
var inst_13796 = (state_13875[(8)]);
var inst_13840 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_13828,inst_13796);
var state_13875__$1 = state_13875;
var statearr_13877_13993 = state_13875__$1;
(statearr_13877_13993[(2)] = inst_13840);

(statearr_13877_13993[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (70))){
var inst_13858 = (state_13875[(2)]);
var inst_13859 = cljs.core.not(inst_13858);
var state_13875__$1 = state_13875;
if(inst_13859){
var statearr_13878_13994 = state_13875__$1;
(statearr_13878_13994[(1)] = (71));

} else {
var statearr_13879_13995 = state_13875__$1;
(statearr_13879_13995[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (62))){
var inst_13810 = (state_13875[(9)]);
var inst_13849 = (state_13875[(10)]);
var inst_13849__$1 = (state_13875[(2)]);
var inst_13850 = cljs.core.count(inst_13849__$1);
var state_13875__$1 = (function (){var statearr_13880 = state_13875;
(statearr_13880[(11)] = inst_13850);

(statearr_13880[(10)] = inst_13849__$1);

return statearr_13880;
})();
if(cljs.core.truth_(inst_13810)){
var statearr_13881_13996 = state_13875__$1;
(statearr_13881_13996[(1)] = (68));

} else {
var statearr_13882_13997 = state_13875__$1;
(statearr_13882_13997[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (74))){
var inst_13850 = (state_13875[(11)]);
var inst_13849 = (state_13875[(10)]);
var inst_13864 = (state_13875[(2)]);
var inst_13865 = fluree.db.util.async.throw_err(inst_13864);
var inst_13794 = inst_13865;
var inst_13795 = inst_13850;
var inst_13796 = inst_13849;
var state_13875__$1 = (function (){var statearr_13883 = state_13875;
(statearr_13883[(12)] = inst_13794);

(statearr_13883[(13)] = inst_13795);

(statearr_13883[(8)] = inst_13796);

return statearr_13883;
})();
var statearr_13884_13998 = state_13875__$1;
(statearr_13884_13998[(2)] = null);

(statearr_13884_13998[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (7))){
var inst_13677 = (state_13875[(14)]);
var state_13875__$1 = state_13875;
var statearr_13885_13999 = state_13875__$1;
(statearr_13885_13999[(2)] = inst_13677);

(statearr_13885_13999[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (59))){
var inst_13794 = (state_13875[(12)]);
var inst_13809 = (state_13875[(2)]);
var inst_13810 = fluree.db.dbproto._rhs(inst_13794);
var state_13875__$1 = (function (){var statearr_13886 = state_13875;
(statearr_13886[(15)] = inst_13809);

(statearr_13886[(9)] = inst_13810);

return statearr_13886;
})();
var statearr_13887_14000 = state_13875__$1;
(statearr_13887_14000[(1)] = (60));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (20))){
var inst_13678 = (state_13875[(16)]);
var inst_13725 = (state_13875[(2)]);
var inst_13726 = (inst_13678 == null);
var state_13875__$1 = (function (){var statearr_13889 = state_13875;
(statearr_13889[(17)] = inst_13725);

return statearr_13889;
})();
if(cljs.core.truth_(inst_13726)){
var statearr_13890_14001 = state_13875__$1;
(statearr_13890_14001[(1)] = (22));

} else {
var statearr_13891_14002 = state_13875__$1;
(statearr_13891_14002[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (72))){
var inst_13789 = (state_13875[(18)]);
var inst_13810 = (state_13875[(9)]);
var inst_13862 = fluree.db.dbproto._lookup_leaf(inst_13789,inst_13810);
var state_13875__$1 = state_13875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13875__$1,(74),inst_13862);
} else {
if((state_val_13876 === (58))){
var inst_13802 = (state_13875[(19)]);
var state_13875__$1 = state_13875;
var statearr_13892_14003 = state_13875__$1;
(statearr_13892_14003[(2)] = inst_13802);

(statearr_13892_14003[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (60))){
var inst_13795 = (state_13875[(13)]);
var inst_13809 = (state_13875[(15)]);
var inst_13796 = (state_13875[(8)]);
var inst_13768 = (state_13875[(20)]);
var inst_13812 = (inst_13768 - inst_13795);
var inst_13813 = fluree.db.flake.take(inst_13812,inst_13809);
var inst_13814 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_13813,inst_13796);
var state_13875__$1 = state_13875;
var statearr_13893_14004 = state_13875__$1;
(statearr_13893_14004[(2)] = inst_13814);

(statearr_13893_14004[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (27))){
var inst_13685 = (state_13875[(21)]);
var inst_13734 = (state_13875[(2)]);
var inst_13735 = (inst_13685 == null);
var state_13875__$1 = (function (){var statearr_13894 = state_13875;
(statearr_13894[(22)] = inst_13734);

return statearr_13894;
})();
if(cljs.core.truth_(inst_13735)){
var statearr_13895_14005 = state_13875__$1;
(statearr_13895_14005[(1)] = (28));

} else {
var statearr_13896_14006 = state_13875__$1;
(statearr_13896_14006[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (1))){
var state_13875__$1 = state_13875;
var statearr_13897_14007 = state_13875__$1;
(statearr_13897_14007[(2)] = null);

(statearr_13897_14007[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (69))){
var inst_13810 = (state_13875[(9)]);
var state_13875__$1 = state_13875;
var statearr_13898_14008 = state_13875__$1;
(statearr_13898_14008[(2)] = inst_13810);

(statearr_13898_14008[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (24))){
var inst_13730 = (state_13875[(2)]);
var state_13875__$1 = state_13875;
if(cljs.core.truth_(inst_13730)){
var statearr_13899_14009 = state_13875__$1;
(statearr_13899_14009[(1)] = (25));

} else {
var statearr_13900_14010 = state_13875__$1;
(statearr_13900_14010[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (55))){
var inst_13870 = (state_13875[(2)]);
var _ = (function (){var statearr_13901 = state_13875;
(statearr_13901[(4)] = cljs.core.rest((state_13875[(4)])));

return statearr_13901;
})();
var state_13875__$1 = state_13875;
var statearr_13902_14011 = state_13875__$1;
(statearr_13902_14011[(2)] = inst_13870);

(statearr_13902_14011[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (39))){
var inst_13750 = (state_13875[(2)]);
var state_13875__$1 = state_13875;
var statearr_13903_14012 = state_13875__$1;
(statearr_13903_14012[(2)] = inst_13750);

(statearr_13903_14012[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (46))){
var inst_13764 = (state_13875[(23)]);
var state_13875__$1 = state_13875;
var statearr_13904_14013 = state_13875__$1;
(statearr_13904_14013[(2)] = inst_13764);

(statearr_13904_14013[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (4))){
var inst_13664 = (state_13875[(2)]);
var state_13875__$1 = state_13875;
var statearr_13905_14014 = state_13875__$1;
(statearr_13905_14014[(2)] = inst_13664);

(statearr_13905_14014[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (54))){
var inst_13794 = (state_13875[(12)]);
var inst_13779 = (state_13875[(24)]);
var inst_13780 = (state_13875[(25)]);
var inst_13784 = (state_13875[(26)]);
var inst_13798 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_13794,inst_13779,inst_13780,inst_13784);
var state_13875__$1 = state_13875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13875__$1,(56),inst_13798);
} else {
if((state_val_13876 === (15))){
var inst_13679 = (state_13875[(27)]);
var state_13875__$1 = state_13875;
var statearr_13906_14015 = state_13875__$1;
(statearr_13906_14015[(2)] = inst_13679);

(statearr_13906_14015[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (48))){
var inst_13774 = (state_13875[(28)]);
var inst_13768 = (state_13875[(2)]);
var inst_13769 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_13770 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13771 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_13772 = (new cljs.core.PersistentVector(null,3,(5),inst_13770,inst_13771,null));
var inst_13773 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_13772);
var inst_13774__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_13875__$1 = (function (){var statearr_13907 = state_13875;
(statearr_13907[(29)] = inst_13773);

(statearr_13907[(30)] = inst_13769);

(statearr_13907[(28)] = inst_13774__$1);

(statearr_13907[(20)] = inst_13768);

return statearr_13907;
})();
if(cljs.core.truth_(inst_13774__$1)){
var statearr_13908_14016 = state_13875__$1;
(statearr_13908_14016[(1)] = (49));

} else {
var statearr_13909_14017 = state_13875__$1;
(statearr_13909_14017[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (50))){
var inst_13777 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_13875__$1 = state_13875;
var statearr_13910_14018 = state_13875__$1;
(statearr_13910_14018[(2)] = inst_13777);

(statearr_13910_14018[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (21))){
var inst_13721 = (state_13875[(2)]);
var inst_13722 = fluree.db.util.async.throw_err(inst_13721);
var state_13875__$1 = state_13875;
var statearr_13911_14019 = state_13875__$1;
(statearr_13911_14019[(2)] = inst_13722);

(statearr_13911_14019[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (31))){
var state_13875__$1 = state_13875;
var statearr_13912_14020 = state_13875__$1;
(statearr_13912_14020[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_13912_14020[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (32))){
var inst_13685 = (state_13875[(21)]);
var state_13875__$1 = state_13875;
var statearr_13913_14021 = state_13875__$1;
(statearr_13913_14021[(2)] = inst_13685);

(statearr_13913_14021[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (40))){
var inst_13689 = (state_13875[(31)]);
var state_13875__$1 = state_13875;
var statearr_13914_14022 = state_13875__$1;
(statearr_13914_14022[(2)] = inst_13689);

(statearr_13914_14022[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (56))){
var inst_13801 = (state_13875[(32)]);
var inst_13762 = (state_13875[(33)]);
var inst_13763 = (state_13875[(34)]);
var inst_13800 = (state_13875[(2)]);
var inst_13801__$1 = fluree.db.util.async.throw_err(inst_13800);
var inst_13802 = fluree.db.flake.subrange(inst_13801__$1,start_test,inst_13762,end_test,inst_13763);
var inst_13803 = fluree.db.query.range.value_with_nil_pred(idx,inst_13762,inst_13763);
var state_13875__$1 = (function (){var statearr_13915 = state_13875;
(statearr_13915[(32)] = inst_13801__$1);

(statearr_13915[(19)] = inst_13802);

return statearr_13915;
})();
if(inst_13803){
var statearr_13916_14023 = state_13875__$1;
(statearr_13916_14023[(1)] = (57));

} else {
var statearr_13917_14024 = state_13875__$1;
(statearr_13917_14024[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (33))){
var inst_13682 = (state_13875[(35)]);
var inst_13743 = (state_13875[(2)]);
var state_13875__$1 = (function (){var statearr_13918 = state_13875;
(statearr_13918[(36)] = inst_13743);

return statearr_13918;
})();
if(cljs.core.truth_(inst_13682)){
var statearr_13919_14025 = state_13875__$1;
(statearr_13919_14025[(1)] = (34));

} else {
var statearr_13920_14026 = state_13875__$1;
(statearr_13920_14026[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (13))){
var inst_13703 = (state_13875[(2)]);
var inst_13704 = fluree.db.util.async.throw_err(inst_13703);
var state_13875__$1 = state_13875;
var statearr_13921_14027 = state_13875__$1;
(statearr_13921_14027[(2)] = inst_13704);

(statearr_13921_14027[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (22))){
var inst_13716 = (state_13875[(37)]);
var state_13875__$1 = state_13875;
var statearr_13922_14028 = state_13875__$1;
(statearr_13922_14028[(2)] = inst_13716);

(statearr_13922_14028[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (36))){
var inst_13689 = (state_13875[(31)]);
var inst_13752 = (state_13875[(2)]);
var state_13875__$1 = (function (){var statearr_13923 = state_13875;
(statearr_13923[(38)] = inst_13752);

return statearr_13923;
})();
if(cljs.core.truth_(inst_13689)){
var statearr_13924_14029 = state_13875__$1;
(statearr_13924_14029[(1)] = (40));

} else {
var statearr_13925_14030 = state_13875__$1;
(statearr_13925_14030[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (41))){
var inst_13755 = (cljs.core._LT__EQ_ === end_test);
var state_13875__$1 = state_13875;
if(cljs.core.truth_(inst_13755)){
var statearr_13926_14031 = state_13875__$1;
(statearr_13926_14031[(1)] = (43));

} else {
var statearr_13927_14032 = state_13875__$1;
(statearr_13927_14032[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (43))){
var state_13875__$1 = state_13875;
var statearr_13928_14033 = state_13875__$1;
(statearr_13928_14033[(2)] = (2147483647));

(statearr_13928_14033[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (61))){
var inst_13795 = (state_13875[(13)]);
var inst_13809 = (state_13875[(15)]);
var inst_13823 = cljs.core.seq(inst_13809);
var inst_13824 = cljs.core.first(inst_13823);
var inst_13825 = cljs.core.next(inst_13823);
var inst_13826 = inst_13809;
var inst_13827 = inst_13795;
var inst_13828 = inst_13809;
var state_13875__$1 = (function (){var statearr_13929 = state_13875;
(statearr_13929[(39)] = inst_13827);

(statearr_13929[(40)] = inst_13825);

(statearr_13929[(41)] = inst_13824);

(statearr_13929[(7)] = inst_13828);

(statearr_13929[(42)] = inst_13826);

return statearr_13929;
})();
var statearr_13930_14034 = state_13875__$1;
(statearr_13930_14034[(2)] = null);

(statearr_13930_14034[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (29))){
var state_13875__$1 = state_13875;
var statearr_13931_14035 = state_13875__$1;
(statearr_13931_14035[(2)] = false);

(statearr_13931_14035[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (44))){
var state_13875__$1 = state_13875;
var statearr_13932_14036 = state_13875__$1;
(statearr_13932_14036[(2)] = fluree.db.util.core.min_integer);

(statearr_13932_14036[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (6))){
var inst_13677 = (state_13875[(14)]);
var inst_13692 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13677);
var state_13875__$1 = state_13875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13875__$1,(9),inst_13692);
} else {
if((state_val_13876 === (28))){
var inst_13725 = (state_13875[(17)]);
var state_13875__$1 = state_13875;
var statearr_13933_14037 = state_13875__$1;
(statearr_13933_14037[(2)] = inst_13725);

(statearr_13933_14037[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (64))){
var inst_13847 = (state_13875[(2)]);
var state_13875__$1 = state_13875;
var statearr_13934_14038 = state_13875__$1;
(statearr_13934_14038[(2)] = inst_13847);

(statearr_13934_14038[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (51))){
var inst_13779 = (state_13875[(2)]);
var inst_13780 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_13781 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13782 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_13783 = (new cljs.core.PersistentVector(null,2,(5),inst_13781,inst_13782,null));
var inst_13784 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_13783);
var inst_13785 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_13786 = fluree.db.dbproto._resolve(inst_13785);
var state_13875__$1 = (function (){var statearr_13935 = state_13875;
(statearr_13935[(24)] = inst_13779);

(statearr_13935[(25)] = inst_13780);

(statearr_13935[(26)] = inst_13784);

return statearr_13935;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13875__$1,(52),inst_13786);
} else {
if((state_val_13876 === (25))){
var state_13875__$1 = state_13875;
var statearr_13936_14039 = state_13875__$1;
(statearr_13936_14039[(2)] = (-1));

(statearr_13936_14039[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (34))){
var inst_13682 = (state_13875[(35)]);
var state_13875__$1 = state_13875;
var statearr_13937_14040 = state_13875__$1;
(statearr_13937_14040[(2)] = inst_13682);

(statearr_13937_14040[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (17))){
var inst_13712 = (state_13875[(2)]);
var inst_13713 = fluree.db.util.async.throw_err(inst_13712);
var state_13875__$1 = state_13875;
var statearr_13938_14041 = state_13875__$1;
(statearr_13938_14041[(2)] = inst_13713);

(statearr_13938_14041[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (3))){
var inst_13873 = (state_13875[(2)]);
var state_13875__$1 = state_13875;
return cljs.core.async.impl.ioc_helpers.return_chan(state_13875__$1,inst_13873);
} else {
if((state_val_13876 === (12))){
var inst_13679 = (state_13875[(27)]);
var inst_13707 = (state_13875[(2)]);
var inst_13708 = fluree.db.util.core.pred_ident_QMARK_(inst_13679);
var state_13875__$1 = (function (){var statearr_13940 = state_13875;
(statearr_13940[(43)] = inst_13707);

return statearr_13940;
})();
if(inst_13708){
var statearr_13941_14042 = state_13875__$1;
(statearr_13941_14042[(1)] = (14));

} else {
var statearr_13942_14043 = state_13875__$1;
(statearr_13942_14043[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (2))){
var inst_13677 = (state_13875[(14)]);
var inst_13683 = (state_13875[(44)]);
var inst_13676 = (state_13875[(45)]);
var _ = (function (){var statearr_13943 = state_13875;
(statearr_13943[(4)] = cljs.core.cons((5),(state_13875[(4)])));

return statearr_13943;
})();
var inst_13676__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_13677__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13676__$1,(0),null);
var inst_13678 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13676__$1,(1),null);
var inst_13679 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13676__$1,(2),null);
var inst_13680 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13676__$1,(3),null);
var inst_13681 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13676__$1,(4),null);
var inst_13682 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13676__$1,(5),null);
var inst_13683__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_13684 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13683__$1,(0),null);
var inst_13685 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13683__$1,(1),null);
var inst_13686 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13683__$1,(2),null);
var inst_13687 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13683__$1,(3),null);
var inst_13688 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13683__$1,(4),null);
var inst_13689 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_13683__$1,(5),null);
var inst_13690 = fluree.db.util.core.pred_ident_QMARK_(inst_13677__$1);
var state_13875__$1 = (function (){var statearr_13944 = state_13875;
(statearr_13944[(46)] = inst_13688);

(statearr_13944[(47)] = inst_13684);

(statearr_13944[(31)] = inst_13689);

(statearr_13944[(14)] = inst_13677__$1);

(statearr_13944[(16)] = inst_13678);

(statearr_13944[(48)] = inst_13681);

(statearr_13944[(49)] = inst_13686);

(statearr_13944[(27)] = inst_13679);

(statearr_13944[(50)] = inst_13687);

(statearr_13944[(44)] = inst_13683__$1);

(statearr_13944[(35)] = inst_13682);

(statearr_13944[(45)] = inst_13676__$1);

(statearr_13944[(51)] = inst_13680);

(statearr_13944[(21)] = inst_13685);

return statearr_13944;
})();
if(inst_13690){
var statearr_13945_14044 = state_13875__$1;
(statearr_13945_14044[(1)] = (6));

} else {
var statearr_13946_14045 = state_13875__$1;
(statearr_13946_14045[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (66))){
var inst_13827 = (state_13875[(39)]);
var inst_13828 = (state_13875[(7)]);
var inst_13835 = (state_13875[(52)]);
var inst_13842 = (inst_13827 + (1));
var tmp13939 = inst_13828;
var inst_13826 = inst_13835;
var inst_13827__$1 = inst_13842;
var inst_13828__$1 = tmp13939;
var state_13875__$1 = (function (){var statearr_13947 = state_13875;
(statearr_13947[(39)] = inst_13827__$1);

(statearr_13947[(7)] = inst_13828__$1);

(statearr_13947[(42)] = inst_13826);

return statearr_13947;
})();
var statearr_13948_14046 = state_13875__$1;
(statearr_13948_14046[(2)] = null);

(statearr_13948_14046[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (23))){
var state_13875__$1 = state_13875;
var statearr_13949_14047 = state_13875__$1;
(statearr_13949_14047[(2)] = false);

(statearr_13949_14047[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (47))){
var state_13875__$1 = state_13875;
var statearr_13950_14048 = state_13875__$1;
(statearr_13950_14048[(2)] = fluree.db.util.core.max_long);

(statearr_13950_14048[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (35))){
var inst_13746 = (cljs.core._GT__EQ_ === start_test);
var state_13875__$1 = state_13875;
if(cljs.core.truth_(inst_13746)){
var statearr_13951_14049 = state_13875__$1;
(statearr_13951_14049[(1)] = (37));

} else {
var statearr_13952_14050 = state_13875__$1;
(statearr_13952_14050[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (19))){
var inst_13686 = (state_13875[(49)]);
var state_13875__$1 = state_13875;
var statearr_13953_14051 = state_13875__$1;
(statearr_13953_14051[(2)] = inst_13686);

(statearr_13953_14051[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (57))){
var inst_13773 = (state_13875[(29)]);
var inst_13761 = (state_13875[(53)]);
var inst_13801 = (state_13875[(32)]);
var inst_13688 = (state_13875[(46)]);
var inst_13794 = (state_13875[(12)]);
var inst_13802 = (state_13875[(19)]);
var inst_13769 = (state_13875[(30)]);
var inst_13734 = (state_13875[(22)]);
var inst_13795 = (state_13875[(13)]);
var inst_13698 = (state_13875[(54)]);
var inst_13789 = (state_13875[(18)]);
var inst_13752 = (state_13875[(38)]);
var inst_13762 = (state_13875[(33)]);
var inst_13779 = (state_13875[(24)]);
var inst_13763 = (state_13875[(34)]);
var inst_13780 = (state_13875[(25)]);
var inst_13681 = (state_13875[(48)]);
var inst_13716 = (state_13875[(37)]);
var inst_13784 = (state_13875[(26)]);
var inst_13796 = (state_13875[(8)]);
var inst_13687 = (state_13875[(50)]);
var inst_13683 = (state_13875[(44)]);
var inst_13743 = (state_13875[(36)]);
var inst_13707 = (state_13875[(43)]);
var inst_13676 = (state_13875[(45)]);
var inst_13725 = (state_13875[(17)]);
var inst_13680 = (state_13875[(51)]);
var inst_13768 = (state_13875[(20)]);
var inst_13805 = (function (){var no_filter_QMARK_ = true;
var next_node = inst_13794;
var flakes = inst_13801;
var s1 = inst_13698;
var o2 = inst_13725;
var t1 = inst_13680;
var i = inst_13795;
var m1 = inst_13752;
var root_node = inst_13789;
var to_t = inst_13780;
var s2 = inst_13707;
var p2 = inst_13743;
var vec__13670 = inst_13676;
var permissions = inst_13769;
var limit = inst_13768;
var start_flake = inst_13762;
var vec__13673 = inst_13683;
var acc = inst_13796;
var t2 = inst_13687;
var op1 = inst_13681;
var o1 = inst_13716;
var end_flake = inst_13763;
var base_result = inst_13802;
var p1 = inst_13734;
var idx_compare = inst_13773;
var op2 = inst_13688;
var from_t = inst_13779;
var m2 = inst_13761;
var novelty = inst_13784;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_13806 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_13805,inst_13802,inst_13802);
var state_13875__$1 = state_13875;
var statearr_13954_14052 = state_13875__$1;
(statearr_13954_14052[(2)] = inst_13806);

(statearr_13954_14052[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (68))){
var inst_13773 = (state_13875[(29)]);
var inst_13850 = (state_13875[(11)]);
var inst_13763 = (state_13875[(34)]);
var inst_13810 = (state_13875[(9)]);
var inst_13768 = (state_13875[(20)]);
var inst_13852 = (inst_13773.cljs$core$IFn$_invoke$arity$2 ? inst_13773.cljs$core$IFn$_invoke$arity$2(inst_13810,inst_13763) : inst_13773.call(null,inst_13810,inst_13763));
var inst_13853 = (inst_13852 < (0));
var inst_13854 = (inst_13850 < inst_13768);
var inst_13855 = ((inst_13853) && (inst_13854));
var state_13875__$1 = state_13875;
var statearr_13955_14053 = state_13875__$1;
(statearr_13955_14053[(2)] = inst_13855);

(statearr_13955_14053[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (11))){
var inst_13684 = (state_13875[(47)]);
var state_13875__$1 = state_13875;
var statearr_13957_14054 = state_13875__$1;
(statearr_13957_14054[(2)] = inst_13684);

(statearr_13957_14054[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (9))){
var inst_13694 = (state_13875[(2)]);
var inst_13695 = fluree.db.util.async.throw_err(inst_13694);
var state_13875__$1 = state_13875;
var statearr_13958_14055 = state_13875__$1;
(statearr_13958_14055[(2)] = inst_13695);

(statearr_13958_14055[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (5))){
var _ = (function (){var statearr_13959 = state_13875;
(statearr_13959[(4)] = cljs.core.rest((state_13875[(4)])));

return statearr_13959;
})();
var state_13875__$1 = state_13875;
var ex13956 = (state_13875__$1[(2)]);
var statearr_13960_14056 = state_13875__$1;
(statearr_13960_14056[(5)] = ex13956);


if((ex13956 instanceof Error)){
var statearr_13961_14057 = state_13875__$1;
(statearr_13961_14057[(1)] = (4));

(statearr_13961_14057[(5)] = null);

} else {
throw ex13956;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (14))){
var inst_13679 = (state_13875[(27)]);
var inst_13710 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13679);
var state_13875__$1 = state_13875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13875__$1,(17),inst_13710);
} else {
if((state_val_13876 === (45))){
var inst_13759 = (state_13875[(2)]);
var state_13875__$1 = state_13875;
var statearr_13962_14058 = state_13875__$1;
(statearr_13962_14058[(2)] = inst_13759);

(statearr_13962_14058[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (53))){
var inst_13792 = (state_13875[(2)]);
var inst_13793 = fluree.db.util.async.throw_err(inst_13792);
var inst_13794 = inst_13793;
var inst_13795 = (0);
var inst_13796 = null;
var state_13875__$1 = (function (){var statearr_13963 = state_13875;
(statearr_13963[(12)] = inst_13794);

(statearr_13963[(13)] = inst_13795);

(statearr_13963[(8)] = inst_13796);

return statearr_13963;
})();
var statearr_13964_14059 = state_13875__$1;
(statearr_13964_14059[(2)] = null);

(statearr_13964_14059[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (26))){
var inst_13678 = (state_13875[(16)]);
var state_13875__$1 = state_13875;
var statearr_13965_14060 = state_13875__$1;
(statearr_13965_14060[(2)] = inst_13678);

(statearr_13965_14060[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (16))){
var inst_13686 = (state_13875[(49)]);
var inst_13716 = (state_13875[(2)]);
var inst_13717 = fluree.db.util.core.pred_ident_QMARK_(inst_13686);
var state_13875__$1 = (function (){var statearr_13966 = state_13875;
(statearr_13966[(37)] = inst_13716);

return statearr_13966;
})();
if(inst_13717){
var statearr_13967_14061 = state_13875__$1;
(statearr_13967_14061[(1)] = (18));

} else {
var statearr_13968_14062 = state_13875__$1;
(statearr_13968_14062[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (38))){
var state_13875__$1 = state_13875;
var statearr_13969_14063 = state_13875__$1;
(statearr_13969_14063[(2)] = (2147483647));

(statearr_13969_14063[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (30))){
var inst_13739 = (state_13875[(2)]);
var state_13875__$1 = state_13875;
if(cljs.core.truth_(inst_13739)){
var statearr_13970_14064 = state_13875__$1;
(statearr_13970_14064[(1)] = (31));

} else {
var statearr_13971_14065 = state_13875__$1;
(statearr_13971_14065[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (73))){
var inst_13868 = (state_13875[(2)]);
var state_13875__$1 = state_13875;
var statearr_13972_14066 = state_13875__$1;
(statearr_13972_14066[(2)] = inst_13868);

(statearr_13972_14066[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (10))){
var inst_13684 = (state_13875[(47)]);
var inst_13701 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13684);
var state_13875__$1 = state_13875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13875__$1,(13),inst_13701);
} else {
if((state_val_13876 === (18))){
var inst_13686 = (state_13875[(49)]);
var inst_13719 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_13686);
var state_13875__$1 = state_13875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13875__$1,(21),inst_13719);
} else {
if((state_val_13876 === (52))){
var inst_13789 = (state_13875[(18)]);
var inst_13762 = (state_13875[(33)]);
var inst_13788 = (state_13875[(2)]);
var inst_13789__$1 = fluree.db.util.async.throw_err(inst_13788);
var inst_13790 = fluree.db.dbproto._lookup_leaf(inst_13789__$1,inst_13762);
var state_13875__$1 = (function (){var statearr_13973 = state_13875;
(statearr_13973[(18)] = inst_13789__$1);

return statearr_13973;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_13875__$1,(53),inst_13790);
} else {
if((state_val_13876 === (67))){
var inst_13845 = (state_13875[(2)]);
var state_13875__$1 = state_13875;
var statearr_13974_14067 = state_13875__$1;
(statearr_13974_14067[(2)] = inst_13845);

(statearr_13974_14067[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (71))){
var inst_13849 = (state_13875[(10)]);
var state_13875__$1 = state_13875;
var statearr_13975_14068 = state_13875__$1;
(statearr_13975_14068[(2)] = inst_13849);

(statearr_13975_14068[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (42))){
var inst_13761 = (state_13875[(53)]);
var inst_13688 = (state_13875[(46)]);
var inst_13734 = (state_13875[(22)]);
var inst_13764 = (state_13875[(23)]);
var inst_13698 = (state_13875[(54)]);
var inst_13752 = (state_13875[(38)]);
var inst_13681 = (state_13875[(48)]);
var inst_13716 = (state_13875[(37)]);
var inst_13687 = (state_13875[(50)]);
var inst_13743 = (state_13875[(36)]);
var inst_13707 = (state_13875[(43)]);
var inst_13725 = (state_13875[(17)]);
var inst_13680 = (state_13875[(51)]);
var inst_13761__$1 = (state_13875[(2)]);
var inst_13762 = fluree.db.flake.__GT_Flake(inst_13698,inst_13734,inst_13716,inst_13680,inst_13681,inst_13752);
var inst_13763 = fluree.db.flake.__GT_Flake(inst_13707,inst_13743,inst_13725,inst_13687,inst_13688,inst_13761__$1);
var inst_13764__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_13875__$1 = (function (){var statearr_13976 = state_13875;
(statearr_13976[(53)] = inst_13761__$1);

(statearr_13976[(23)] = inst_13764__$1);

(statearr_13976[(33)] = inst_13762);

(statearr_13976[(34)] = inst_13763);

return statearr_13976;
})();
if(cljs.core.truth_(inst_13764__$1)){
var statearr_13977_14069 = state_13875__$1;
(statearr_13977_14069[(1)] = (46));

} else {
var statearr_13978_14070 = state_13875__$1;
(statearr_13978_14070[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (37))){
var state_13875__$1 = state_13875;
var statearr_13979_14071 = state_13875__$1;
(statearr_13979_14071[(2)] = fluree.db.util.core.min_integer);

(statearr_13979_14071[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (63))){
var inst_13827 = (state_13875[(39)]);
var inst_13826 = (state_13875[(42)]);
var inst_13768 = (state_13875[(20)]);
var inst_13833 = cljs.core.seq(inst_13826);
var inst_13834 = cljs.core.first(inst_13833);
var inst_13835 = cljs.core.next(inst_13833);
var inst_13836 = (inst_13834 == null);
var inst_13837 = (inst_13827 > inst_13768);
var inst_13838 = ((inst_13836) || (inst_13837));
var state_13875__$1 = (function (){var statearr_13980 = state_13875;
(statearr_13980[(52)] = inst_13835);

return statearr_13980;
})();
if(cljs.core.truth_(inst_13838)){
var statearr_13981_14072 = state_13875__$1;
(statearr_13981_14072[(1)] = (65));

} else {
var statearr_13982_14073 = state_13875__$1;
(statearr_13982_14073[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (8))){
var inst_13684 = (state_13875[(47)]);
var inst_13698 = (state_13875[(2)]);
var inst_13699 = fluree.db.util.core.pred_ident_QMARK_(inst_13684);
var state_13875__$1 = (function (){var statearr_13983 = state_13875;
(statearr_13983[(54)] = inst_13698);

return statearr_13983;
})();
if(inst_13699){
var statearr_13984_14074 = state_13875__$1;
(statearr_13984_14074[(1)] = (10));

} else {
var statearr_13985_14075 = state_13875__$1;
(statearr_13985_14075[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13876 === (49))){
var inst_13774 = (state_13875[(28)]);
var state_13875__$1 = state_13875;
var statearr_13986_14076 = state_13875__$1;
(statearr_13986_14076[(2)] = inst_13774);

(statearr_13986_14076[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2879__auto__ = null;
var fluree$db$query$range$state_machine__2879__auto____0 = (function (){
var statearr_13987 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13987[(0)] = fluree$db$query$range$state_machine__2879__auto__);

(statearr_13987[(1)] = (1));

return statearr_13987;
});
var fluree$db$query$range$state_machine__2879__auto____1 = (function (state_13875){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_13875);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e13988){var ex__2882__auto__ = e13988;
var statearr_13989_14077 = state_13875;
(statearr_13989_14077[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_13875[(4)]))){
var statearr_13990_14078 = state_13875;
(statearr_13990_14078[(1)] = cljs.core.first((state_13875[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14079 = state_13875;
state_13875 = G__14079;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2879__auto__ = function(state_13875){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2879__auto____1.call(this,state_13875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2879__auto____0;
fluree$db$query$range$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2879__auto____1;
return fluree$db$query$range$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_13991 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_13991[(6)] = c__2901__auto__);

return statearr_13991;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_14129){
var state_val_14130 = (state_14129[(1)]);
if((state_val_14130 === (7))){
var state_14129__$1 = state_14129;
var statearr_14131_14150 = state_14129__$1;
(statearr_14131_14150[(2)] = (0));

(statearr_14131_14150[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (1))){
var inst_14087 = subject_groups;
var inst_14088 = cljs.core.seq(inst_14087);
var inst_14089 = cljs.core.first(inst_14088);
var inst_14090 = cljs.core.next(inst_14088);
var inst_14091 = flake_start;
var inst_14092 = subject_start;
var inst_14093 = cljs.core.PersistentVector.EMPTY;
var inst_14094 = inst_14087;
var inst_14095 = inst_14091;
var inst_14096 = inst_14092;
var inst_14097 = inst_14093;
var state_14129__$1 = (function (){var statearr_14132 = state_14129;
(statearr_14132[(7)] = inst_14096);

(statearr_14132[(8)] = inst_14095);

(statearr_14132[(9)] = inst_14090);

(statearr_14132[(10)] = inst_14089);

(statearr_14132[(11)] = inst_14097);

(statearr_14132[(12)] = inst_14094);

return statearr_14132;
})();
var statearr_14133_14151 = state_14129__$1;
(statearr_14133_14151[(2)] = null);

(statearr_14133_14151[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (4))){
var inst_14096 = (state_14129[(7)]);
var inst_14095 = (state_14129[(8)]);
var inst_14097 = (state_14129[(11)]);
var inst_14110 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14111 = [inst_14095,inst_14096,inst_14097];
var inst_14112 = (new cljs.core.PersistentVector(null,3,(5),inst_14110,inst_14111,null));
var state_14129__$1 = state_14129;
var statearr_14134_14152 = state_14129__$1;
(statearr_14134_14152[(2)] = inst_14112);

(statearr_14134_14152[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (6))){
var inst_14125 = (state_14129[(2)]);
var state_14129__$1 = state_14129;
var statearr_14135_14153 = state_14129__$1;
(statearr_14135_14153[(2)] = inst_14125);

(statearr_14135_14153[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (3))){
var inst_14127 = (state_14129[(2)]);
var state_14129__$1 = state_14129;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14129__$1,inst_14127);
} else {
if((state_val_14130 === (2))){
var inst_14096 = (state_14129[(7)]);
var inst_14095 = (state_14129[(8)]);
var inst_14103 = (state_14129[(13)]);
var inst_14094 = (state_14129[(12)]);
var inst_14102 = cljs.core.seq(inst_14094);
var inst_14103__$1 = cljs.core.first(inst_14102);
var inst_14104 = cljs.core.next(inst_14102);
var inst_14105 = (inst_14103__$1 == null);
var inst_14106 = (inst_14095 >= flake_limit);
var inst_14107 = (inst_14096 >= subject_limit);
var inst_14108 = ((inst_14105) || (inst_14106) || (inst_14107));
var state_14129__$1 = (function (){var statearr_14136 = state_14129;
(statearr_14136[(14)] = inst_14104);

(statearr_14136[(13)] = inst_14103__$1);

return statearr_14136;
})();
if(cljs.core.truth_(inst_14108)){
var statearr_14137_14154 = state_14129__$1;
(statearr_14137_14154[(1)] = (4));

} else {
var statearr_14138_14155 = state_14129__$1;
(statearr_14138_14155[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (9))){
var inst_14096 = (state_14129[(7)]);
var inst_14104 = (state_14129[(14)]);
var inst_14095 = (state_14129[(8)]);
var inst_14114 = (state_14129[(15)]);
var inst_14097 = (state_14129[(11)]);
var inst_14103 = (state_14129[(13)]);
var inst_14119 = (state_14129[(2)]);
var inst_14120 = (inst_14095 + inst_14114);
var inst_14121 = (inst_14096 + inst_14119);
var inst_14122 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14097,inst_14103);
var inst_14094 = inst_14104;
var inst_14095__$1 = inst_14120;
var inst_14096__$1 = inst_14121;
var inst_14097__$1 = inst_14122;
var state_14129__$1 = (function (){var statearr_14139 = state_14129;
(statearr_14139[(7)] = inst_14096__$1);

(statearr_14139[(8)] = inst_14095__$1);

(statearr_14139[(11)] = inst_14097__$1);

(statearr_14139[(12)] = inst_14094);

return statearr_14139;
})();
var statearr_14140_14156 = state_14129__$1;
(statearr_14140_14156[(2)] = null);

(statearr_14140_14156[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (5))){
var inst_14114 = (state_14129[(15)]);
var inst_14103 = (state_14129[(13)]);
var inst_14114__$1 = cljs.core.count(inst_14103);
var inst_14115 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_14114__$1);
var state_14129__$1 = (function (){var statearr_14141 = state_14129;
(statearr_14141[(15)] = inst_14114__$1);

return statearr_14141;
})();
if(inst_14115){
var statearr_14142_14157 = state_14129__$1;
(statearr_14142_14157[(1)] = (7));

} else {
var statearr_14143_14158 = state_14129__$1;
(statearr_14143_14158[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14130 === (8))){
var state_14129__$1 = state_14129;
var statearr_14144_14159 = state_14129__$1;
(statearr_14144_14159[(2)] = (1));

(statearr_14144_14159[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto____0 = (function (){
var statearr_14145 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14145[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto__);

(statearr_14145[(1)] = (1));

return statearr_14145;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto____1 = (function (state_14129){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_14129);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e14146){var ex__2882__auto__ = e14146;
var statearr_14147_14160 = state_14129;
(statearr_14147_14160[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_14129[(4)]))){
var statearr_14148_14161 = state_14129;
(statearr_14148_14161[(1)] = cljs.core.first((state_14129[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14162 = state_14129;
state_14129 = G__14162;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto__ = function(state_14129){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto____1.call(this,state_14129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_14149 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_14149[(6)] = c__2901__auto__);

return statearr_14149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_14208){
var state_val_14209 = (state_14208[(1)]);
if((state_val_14209 === (7))){
var state_14208__$1 = state_14208;
var statearr_14210_14248 = state_14208__$1;
(statearr_14210_14248[(2)] = null);

(statearr_14210_14248[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14209 === (20))){
var inst_14194 = (state_14208[(2)]);
var inst_14195 = fluree.db.util.async.throw_err(inst_14194);
var inst_14173 = inst_14195;
var state_14208__$1 = (function (){var statearr_14211 = state_14208;
(statearr_14211[(7)] = inst_14173);

return statearr_14211;
})();
var statearr_14212_14249 = state_14208__$1;
(statearr_14212_14249[(2)] = null);

(statearr_14212_14249[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14209 === (1))){
var state_14208__$1 = state_14208;
var statearr_14213_14250 = state_14208__$1;
(statearr_14213_14250[(2)] = null);

(statearr_14213_14250[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14209 === (4))){
var inst_14163 = (state_14208[(2)]);
var state_14208__$1 = state_14208;
var statearr_14214_14251 = state_14208__$1;
(statearr_14214_14251[(2)] = inst_14163);

(statearr_14214_14251[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14209 === (15))){
var inst_14173 = (state_14208[(7)]);
var inst_14190 = (state_14208[(8)]);
var inst_14190__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_14173);
var state_14208__$1 = (function (){var statearr_14215 = state_14208;
(statearr_14215[(8)] = inst_14190__$1);

return statearr_14215;
})();
if(cljs.core.truth_(inst_14190__$1)){
var statearr_14216_14252 = state_14208__$1;
(statearr_14216_14252[(1)] = (17));

} else {
var statearr_14217_14253 = state_14208__$1;
(statearr_14217_14253[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14209 === (13))){
var inst_14183 = (state_14208[(2)]);
var inst_14184 = fluree.db.util.async.throw_err(inst_14183);
var _ = (function (){var statearr_14218 = state_14208;
(statearr_14218[(4)] = cljs.core.rest((state_14208[(4)])));

return statearr_14218;
})();
var state_14208__$1 = state_14208;
var statearr_14219_14254 = state_14208__$1;
(statearr_14219_14254[(2)] = inst_14184);

(statearr_14219_14254[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14209 === (6))){
var inst_14171 = (state_14208[(2)]);
var inst_14172 = fluree.db.util.async.throw_err(inst_14171);
var inst_14173 = inst_14172;
var state_14208__$1 = (function (){var statearr_14220 = state_14208;
(statearr_14220[(7)] = inst_14173);

return statearr_14220;
})();
var statearr_14221_14255 = state_14208__$1;
(statearr_14221_14255[(2)] = null);

(statearr_14221_14255[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14209 === (17))){
var inst_14190 = (state_14208[(8)]);
var inst_14192 = fluree.db.dbproto._lookup_leaf(root_node,inst_14190);
var state_14208__$1 = state_14208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14208__$1,(20),inst_14192);
} else {
if((state_val_14209 === (3))){
var inst_14206 = (state_14208[(2)]);
var state_14208__$1 = state_14208;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14208__$1,inst_14206);
} else {
if((state_val_14209 === (12))){
var _ = (function (){var statearr_14223 = state_14208;
(statearr_14223[(4)] = cljs.core.rest((state_14208[(4)])));

return statearr_14223;
})();
var state_14208__$1 = state_14208;
var ex14222 = (state_14208__$1[(2)]);
var statearr_14224_14256 = state_14208__$1;
(statearr_14224_14256[(5)] = ex14222);


var statearr_14225_14257 = state_14208__$1;
(statearr_14225_14257[(1)] = (11));

(statearr_14225_14257[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14209 === (2))){
var _ = (function (){var statearr_14226 = state_14208;
(statearr_14226[(4)] = cljs.core.cons((5),(state_14208[(4)])));

return statearr_14226;
})();
var inst_14169 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_14208__$1 = state_14208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14208__$1,(6),inst_14169);
} else {
if((state_val_14209 === (19))){
var inst_14199 = (state_14208[(2)]);
var state_14208__$1 = state_14208;
var statearr_14227_14258 = state_14208__$1;
(statearr_14227_14258[(2)] = inst_14199);

(statearr_14227_14258[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14209 === (11))){
var inst_14175 = (state_14208[(2)]);
var state_14208__$1 = (function (){var statearr_14229 = state_14208;
(statearr_14229[(9)] = inst_14175);

return statearr_14229;
})();
var statearr_14230_14259 = state_14208__$1;
(statearr_14230_14259[(2)] = null);

(statearr_14230_14259[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14209 === (9))){
var inst_14173 = (state_14208[(7)]);
var _ = (function (){var statearr_14231 = state_14208;
(statearr_14231[(4)] = cljs.core.cons((12),(state_14208[(4)])));

return statearr_14231;
})();
var inst_14181 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_14173,t,novelty,fast_forward_db_QMARK_);
var state_14208__$1 = state_14208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14208__$1,(13),inst_14181);
} else {
if((state_val_14209 === (5))){
var _ = (function (){var statearr_14232 = state_14208;
(statearr_14232[(4)] = cljs.core.rest((state_14208[(4)])));

return statearr_14232;
})();
var state_14208__$1 = state_14208;
var ex14228 = (state_14208__$1[(2)]);
var statearr_14233_14260 = state_14208__$1;
(statearr_14233_14260[(5)] = ex14228);


if((ex14228 instanceof Error)){
var statearr_14234_14261 = state_14208__$1;
(statearr_14234_14261[(1)] = (4));

(statearr_14234_14261[(5)] = null);

} else {
throw ex14228;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14209 === (14))){
var inst_14187 = (state_14208[(10)]);
var state_14208__$1 = state_14208;
var statearr_14235_14262 = state_14208__$1;
(statearr_14235_14262[(2)] = inst_14187);

(statearr_14235_14262[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14209 === (16))){
var inst_14201 = (state_14208[(2)]);
var state_14208__$1 = state_14208;
var statearr_14236_14263 = state_14208__$1;
(statearr_14236_14263[(2)] = inst_14201);

(statearr_14236_14263[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14209 === (10))){
var inst_14187 = (state_14208[(10)]);
var inst_14187__$1 = (state_14208[(2)]);
var state_14208__$1 = (function (){var statearr_14237 = state_14208;
(statearr_14237[(10)] = inst_14187__$1);

return statearr_14237;
})();
if(cljs.core.truth_(inst_14187__$1)){
var statearr_14238_14264 = state_14208__$1;
(statearr_14238_14264[(1)] = (14));

} else {
var statearr_14239_14265 = state_14208__$1;
(statearr_14239_14265[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14209 === (18))){
var state_14208__$1 = state_14208;
var statearr_14240_14266 = state_14208__$1;
(statearr_14240_14266[(2)] = null);

(statearr_14240_14266[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14209 === (8))){
var inst_14203 = (state_14208[(2)]);
var _ = (function (){var statearr_14241 = state_14208;
(statearr_14241[(4)] = cljs.core.rest((state_14208[(4)])));

return statearr_14241;
})();
var state_14208__$1 = state_14208;
var statearr_14242_14267 = state_14208__$1;
(statearr_14242_14267[(2)] = inst_14203);

(statearr_14242_14267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto____0 = (function (){
var statearr_14243 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14243[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto__);

(statearr_14243[(1)] = (1));

return statearr_14243;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto____1 = (function (state_14208){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_14208);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e14244){var ex__2882__auto__ = e14244;
var statearr_14245_14268 = state_14208;
(statearr_14245_14268[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_14208[(4)]))){
var statearr_14246_14269 = state_14208;
(statearr_14246_14269[(1)] = cljs.core.first((state_14208[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14270 = state_14208;
state_14208 = G__14270;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto__ = function(state_14208){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto____1.call(this,state_14208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_14247 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_14247[(6)] = c__2901__auto__);

return statearr_14247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__14277 = arguments.length;
switch (G__14277) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14278 = (function (){var pred__14281 = cljs.core.identical_QMARK_;
var expr__14282 = test;
if(cljs.core.truth_((pred__14281.cljs$core$IFn$_invoke$arity$2 ? pred__14281.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__14282) : pred__14281.call(null,cljs.core._EQ_,expr__14282)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14281.cljs$core$IFn$_invoke$arity$2 ? pred__14281.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__14282) : pred__14281.call(null,cljs.core._LT_,expr__14282)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__14281.cljs$core$IFn$_invoke$arity$2 ? pred__14281.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__14282) : pred__14281.call(null,cljs.core._LT__EQ_,expr__14282)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__14281.cljs$core$IFn$_invoke$arity$2 ? pred__14281.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__14282) : pred__14281.call(null,cljs.core._GT_,expr__14282)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__14281.cljs$core$IFn$_invoke$arity$2 ? pred__14281.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__14282) : pred__14281.call(null,cljs.core._GT__EQ_,expr__14282)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__14282)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14278,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14278,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14278,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14278,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_14681){
var state_val_14682 = (state_14681[(1)]);
if((state_val_14682 === (121))){
var inst_14542 = (state_14681[(7)]);
var state_14681__$1 = state_14681;
var statearr_14683_14889 = state_14681__$1;
(statearr_14683_14889[(2)] = inst_14542);

(statearr_14683_14889[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (65))){
var state_14681__$1 = state_14681;
var statearr_14684_14890 = state_14681__$1;
(statearr_14684_14890[(2)] = fluree.db.util.core.min_integer);

(statearr_14684_14890[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (70))){
var state_14681__$1 = state_14681;
var statearr_14685_14891 = state_14681__$1;
(statearr_14685_14891[(2)] = true);

(statearr_14685_14891[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (62))){
var inst_14444 = (cljs.core._LT__EQ_ === end_test);
var state_14681__$1 = state_14681;
if(cljs.core.truth_(inst_14444)){
var statearr_14686_14892 = state_14681__$1;
(statearr_14686_14892[(1)] = (64));

} else {
var statearr_14687_14893 = state_14681__$1;
(statearr_14687_14893[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (74))){
var inst_14453 = (state_14681[(8)]);
var state_14681__$1 = state_14681;
var statearr_14688_14894 = state_14681__$1;
(statearr_14688_14894[(2)] = inst_14453);

(statearr_14688_14894[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (110))){
var inst_14583 = (state_14681[(9)]);
var inst_14508 = (state_14681[(10)]);
var inst_14575 = (state_14681[(11)]);
var inst_14584 = (state_14681[(12)]);
var inst_14481 = (state_14681[(13)]);
var inst_14585 = (state_14681[(14)]);
var inst_14583__$1 = cljs.core.count(inst_14575);
var inst_14584__$1 = (inst_14508 + inst_14583__$1);
var inst_14585__$1 = (inst_14584__$1 - inst_14481);
var inst_14586 = cljs.core.pos_int_QMARK_(inst_14585__$1);
var state_14681__$1 = (function (){var statearr_14689 = state_14681;
(statearr_14689[(9)] = inst_14583__$1);

(statearr_14689[(12)] = inst_14584__$1);

(statearr_14689[(14)] = inst_14585__$1);

return statearr_14689;
})();
if(inst_14586){
var statearr_14690_14895 = state_14681__$1;
(statearr_14690_14895[(1)] = (113));

} else {
var statearr_14691_14896 = state_14681__$1;
(statearr_14691_14896[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (130))){
var inst_14644 = (state_14681[(15)]);
var state_14681__$1 = state_14681;
var statearr_14692_14897 = state_14681__$1;
(statearr_14692_14897[(2)] = inst_14644);

(statearr_14692_14897[(1)] = (132));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (128))){
var inst_14653 = (state_14681[(16)]);
var state_14681__$1 = state_14681;
var statearr_14693_14898 = state_14681__$1;
(statearr_14693_14898[(2)] = inst_14653);

(statearr_14693_14898[(1)] = (129));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (7))){
var state_14681__$1 = state_14681;
var statearr_14694_14899 = state_14681__$1;
(statearr_14694_14899[(2)] = false);

(statearr_14694_14899[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (59))){
var state_14681__$1 = state_14681;
var statearr_14695_14900 = state_14681__$1;
(statearr_14695_14900[(2)] = (2147483647));

(statearr_14695_14900[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (86))){
var inst_14423 = (state_14681[(17)]);
var inst_14392 = (state_14681[(18)]);
var inst_14506 = (state_14681[(19)]);
var inst_14351 = (state_14681[(20)]);
var inst_14450 = (state_14681[(21)]);
var inst_14502 = (state_14681[(22)]);
var inst_14507 = (state_14681[(23)]);
var inst_14487 = (state_14681[(24)]);
var inst_14360 = (state_14681[(25)]);
var inst_14482 = (state_14681[(26)]);
var inst_14393 = (state_14681[(27)]);
var inst_14508 = (state_14681[(10)]);
var inst_14311 = (state_14681[(28)]);
var inst_14505 = (state_14681[(29)]);
var inst_14475 = (state_14681[(30)]);
var inst_14515 = (state_14681[(31)]);
var inst_14396 = (state_14681[(32)]);
var inst_14340 = (state_14681[(33)]);
var inst_14414 = (state_14681[(34)]);
var inst_14452 = (state_14681[(35)]);
var inst_14451 = (state_14681[(36)]);
var inst_14315 = (state_14681[(37)]);
var inst_14432 = (state_14681[(38)]);
var inst_14483 = (state_14681[(39)]);
var inst_14441 = (state_14681[(40)]);
var inst_14493 = (state_14681[(41)]);
var inst_14481 = (state_14681[(13)]);
var inst_14474 = (state_14681[(42)]);
var inst_14492 = (state_14681[(43)]);
var inst_14308 = (state_14681[(44)]);
var inst_14304 = (state_14681[(45)]);
var inst_14341 = (state_14681[(46)]);
var inst_14509 = (state_14681[(47)]);
var inst_14498 = (state_14681[(48)]);
var inst_14339 = (state_14681[(49)]);
var inst_14316 = (state_14681[(50)]);
var inst_14405 = (state_14681[(51)]);
var inst_14488 = (state_14681[(52)]);
var inst_14309 = (state_14681[(53)]);
var inst_14519 = (function (){var no_filter_QMARK_ = true;
var t = inst_14488;
var max_limit_QMARK_ = inst_14482;
var map__14303 = inst_14474;
var next_node = inst_14505;
var vec__14297 = inst_14392;
var fast_forward_db_QMARK_ = inst_14493;
var s1 = inst_14351;
var o2 = inst_14414;
var t1 = inst_14308;
var predicate_fn = inst_14341;
var i = inst_14507;
var m1 = inst_14441;
var root_node = inst_14498;
var s2 = inst_14360;
var p2 = inst_14432;
var permissions = inst_14483;
var limit = inst_14481;
var start_flake = inst_14451;
var flake_limit = inst_14475;
var offset = inst_14506;
var acc = inst_14509;
var t2 = inst_14315;
var op1 = inst_14309;
var o1 = inst_14405;
var end_flake = inst_14452;
var base_result = inst_14515;
var s = inst_14508;
var node_start = inst_14502;
var p1 = inst_14423;
var subject_fn = inst_14340;
var vec__14293 = inst_14311;
var map__14296 = inst_14339;
var object_fn = inst_14396;
var idx_compare = inst_14487;
var G__14516 = inst_14515;
var vec__14300 = inst_14393;
var op2 = inst_14316;
var m2 = inst_14450;
var vec__14290 = inst_14304;
var novelty = inst_14492;
return (function (p1__14271_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__14271_SHARP_.o,start_flake.o);
});
})();
var inst_14520 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14519,inst_14515);
var state_14681__$1 = state_14681;
var statearr_14696_14901 = state_14681__$1;
(statearr_14696_14901[(2)] = inst_14520);

(statearr_14696_14901[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (20))){
var inst_14312 = (state_14681[(54)]);
var state_14681__$1 = state_14681;
var statearr_14697_14902 = state_14681__$1;
(statearr_14697_14902[(2)] = inst_14312);

(statearr_14697_14902[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (72))){
var inst_14466 = (state_14681[(2)]);
var state_14681__$1 = state_14681;
var statearr_14698_14903 = state_14681__$1;
(statearr_14698_14903[(2)] = inst_14466);

(statearr_14698_14903[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (58))){
var state_14681__$1 = state_14681;
var statearr_14699_14904 = state_14681__$1;
(statearr_14699_14904[(2)] = fluree.db.util.core.min_integer);

(statearr_14699_14904[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (60))){
var inst_14439 = (state_14681[(2)]);
var state_14681__$1 = state_14681;
var statearr_14700_14905 = state_14681__$1;
(statearr_14700_14905[(2)] = inst_14439);

(statearr_14700_14905[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (27))){
var state_14681__$1 = state_14681;
var statearr_14701_14906 = state_14681__$1;
(statearr_14701_14906[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (1))){
var state_14681__$1 = state_14681;
var statearr_14703_14907 = state_14681__$1;
(statearr_14703_14907[(2)] = null);

(statearr_14703_14907[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (69))){
var inst_14469 = (state_14681[(2)]);
var state_14681__$1 = state_14681;
if(cljs.core.truth_(inst_14469)){
var statearr_14704_14908 = state_14681__$1;
(statearr_14704_14908[(1)] = (73));

} else {
var statearr_14705_14909 = state_14681__$1;
(statearr_14705_14909[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (101))){
var state_14681__$1 = state_14681;
var statearr_14706_14910 = state_14681__$1;
(statearr_14706_14910[(2)] = true);

(statearr_14706_14910[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (24))){
var inst_14314 = (state_14681[(55)]);
var inst_14364 = cljs.core.boolean_QMARK_(inst_14314);
var state_14681__$1 = state_14681;
if(inst_14364){
var statearr_14707_14911 = state_14681__$1;
(statearr_14707_14911[(1)] = (26));

} else {
var statearr_14708_14912 = state_14681__$1;
(statearr_14708_14912[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (102))){
var state_14681__$1 = state_14681;
var statearr_14709_14913 = state_14681__$1;
(statearr_14709_14913[(2)] = false);

(statearr_14709_14913[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (55))){
var inst_14310 = (state_14681[(56)]);
var state_14681__$1 = state_14681;
var statearr_14710_14914 = state_14681__$1;
(statearr_14710_14914[(2)] = inst_14310);

(statearr_14710_14914[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (85))){
var inst_14673 = (state_14681[(2)]);
var state_14681__$1 = state_14681;
var statearr_14711_14915 = state_14681__$1;
(statearr_14711_14915[(2)] = inst_14673);

(statearr_14711_14915[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (39))){
var inst_14395 = (state_14681[(57)]);
var inst_14408 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14395);
var state_14681__$1 = state_14681;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14681__$1,(42),inst_14408);
} else {
if((state_val_14682 === (88))){
var inst_14340 = (state_14681[(33)]);
var inst_14523 = (state_14681[(2)]);
var state_14681__$1 = (function (){var statearr_14712 = state_14681;
(statearr_14712[(58)] = inst_14523);

return statearr_14712;
})();
if(cljs.core.truth_(inst_14340)){
var statearr_14713_14916 = state_14681__$1;
(statearr_14713_14916[(1)] = (89));

} else {
var statearr_14714_14917 = state_14681__$1;
(statearr_14714_14917[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (46))){
var state_14681__$1 = state_14681;
var statearr_14715_14918 = state_14681__$1;
(statearr_14715_14918[(2)] = (-1));

(statearr_14715_14918[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (4))){
var inst_14284 = (state_14681[(2)]);
var state_14681__$1 = state_14681;
var statearr_14716_14919 = state_14681__$1;
(statearr_14716_14919[(2)] = inst_14284);

(statearr_14716_14919[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (77))){
var state_14681__$1 = state_14681;
var statearr_14717_14920 = state_14681__$1;
(statearr_14717_14920[(2)] = fluree.db.util.core.max_long);

(statearr_14717_14920[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (106))){
var inst_14542 = (state_14681[(7)]);
var inst_14640 = (state_14681[(2)]);
var inst_14641 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14640,(0),null);
var inst_14642 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14640,(1),null);
var inst_14643 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14640,(2),null);
var inst_14644 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14640,(3),null);
var state_14681__$1 = (function (){var statearr_14718 = state_14681;
(statearr_14718[(15)] = inst_14644);

(statearr_14718[(59)] = inst_14642);

(statearr_14718[(60)] = inst_14643);

(statearr_14718[(61)] = inst_14641);

return statearr_14718;
})();
if(cljs.core.truth_(inst_14542)){
var statearr_14719_14921 = state_14681__$1;
(statearr_14719_14921[(1)] = (120));

} else {
var statearr_14720_14922 = state_14681__$1;
(statearr_14720_14922[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (119))){
var inst_14626 = (state_14681[(2)]);
var inst_14627 = fluree.db.util.async.throw_err(inst_14626);
var state_14681__$1 = state_14681;
var statearr_14721_14923 = state_14681__$1;
(statearr_14721_14923[(2)] = inst_14627);

(statearr_14721_14923[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (95))){
var inst_14423 = (state_14681[(17)]);
var inst_14392 = (state_14681[(18)]);
var inst_14506 = (state_14681[(19)]);
var inst_14351 = (state_14681[(20)]);
var inst_14450 = (state_14681[(21)]);
var inst_14502 = (state_14681[(22)]);
var inst_14507 = (state_14681[(23)]);
var inst_14487 = (state_14681[(24)]);
var inst_14360 = (state_14681[(25)]);
var inst_14482 = (state_14681[(26)]);
var inst_14393 = (state_14681[(27)]);
var inst_14508 = (state_14681[(10)]);
var inst_14311 = (state_14681[(28)]);
var inst_14505 = (state_14681[(29)]);
var inst_14475 = (state_14681[(30)]);
var inst_14535 = (state_14681[(62)]);
var inst_14515 = (state_14681[(31)]);
var inst_14396 = (state_14681[(32)]);
var inst_14340 = (state_14681[(33)]);
var inst_14414 = (state_14681[(34)]);
var inst_14452 = (state_14681[(35)]);
var inst_14451 = (state_14681[(36)]);
var inst_14315 = (state_14681[(37)]);
var inst_14432 = (state_14681[(38)]);
var inst_14483 = (state_14681[(39)]);
var inst_14441 = (state_14681[(40)]);
var inst_14493 = (state_14681[(41)]);
var inst_14481 = (state_14681[(13)]);
var inst_14474 = (state_14681[(42)]);
var inst_14492 = (state_14681[(43)]);
var inst_14308 = (state_14681[(44)]);
var inst_14304 = (state_14681[(45)]);
var inst_14341 = (state_14681[(46)]);
var inst_14509 = (state_14681[(47)]);
var inst_14498 = (state_14681[(48)]);
var inst_14339 = (state_14681[(49)]);
var inst_14316 = (state_14681[(50)]);
var inst_14405 = (state_14681[(51)]);
var inst_14488 = (state_14681[(52)]);
var inst_14309 = (state_14681[(53)]);
var inst_14537 = (function (){var no_filter_QMARK_ = true;
var t = inst_14488;
var max_limit_QMARK_ = inst_14482;
var map__14303 = inst_14474;
var next_node = inst_14505;
var vec__14297 = inst_14392;
var fast_forward_db_QMARK_ = inst_14493;
var s1 = inst_14351;
var o2 = inst_14414;
var t1 = inst_14308;
var predicate_fn = inst_14341;
var i = inst_14507;
var m1 = inst_14441;
var root_node = inst_14498;
var s2 = inst_14360;
var p2 = inst_14432;
var permissions = inst_14483;
var limit = inst_14481;
var start_flake = inst_14451;
var flake_limit = inst_14475;
var offset = inst_14506;
var acc = inst_14509;
var t2 = inst_14315;
var op1 = inst_14309;
var o1 = inst_14405;
var end_flake = inst_14452;
var base_result = inst_14515;
var s = inst_14508;
var node_start = inst_14502;
var p1 = inst_14423;
var subject_fn = inst_14340;
var vec__14293 = inst_14311;
var map__14296 = inst_14339;
var object_fn = inst_14396;
var idx_compare = inst_14487;
var G__14516 = inst_14535;
var vec__14300 = inst_14393;
var op2 = inst_14316;
var m2 = inst_14450;
var vec__14290 = inst_14304;
var novelty = inst_14492;
return (function (p1__14274_SHARP_){
var G__14722 = p1__14274_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__14722) : object_fn.call(null,G__14722));
});
})();
var inst_14538 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14537,inst_14535);
var state_14681__$1 = state_14681;
var statearr_14723_14924 = state_14681__$1;
(statearr_14723_14924[(2)] = inst_14538);

(statearr_14723_14924[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (54))){
var inst_14310 = (state_14681[(56)]);
var inst_14432 = (state_14681[(2)]);
var state_14681__$1 = (function (){var statearr_14724 = state_14681;
(statearr_14724[(38)] = inst_14432);

return statearr_14724;
})();
if(cljs.core.truth_(inst_14310)){
var statearr_14725_14925 = state_14681__$1;
(statearr_14725_14925[(1)] = (55));

} else {
var statearr_14726_14926 = state_14681__$1;
(statearr_14726_14926[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (92))){
var inst_14423 = (state_14681[(17)]);
var inst_14392 = (state_14681[(18)]);
var inst_14506 = (state_14681[(19)]);
var inst_14351 = (state_14681[(20)]);
var inst_14450 = (state_14681[(21)]);
var inst_14529 = (state_14681[(63)]);
var inst_14502 = (state_14681[(22)]);
var inst_14507 = (state_14681[(23)]);
var inst_14487 = (state_14681[(24)]);
var inst_14360 = (state_14681[(25)]);
var inst_14482 = (state_14681[(26)]);
var inst_14393 = (state_14681[(27)]);
var inst_14508 = (state_14681[(10)]);
var inst_14311 = (state_14681[(28)]);
var inst_14505 = (state_14681[(29)]);
var inst_14475 = (state_14681[(30)]);
var inst_14515 = (state_14681[(31)]);
var inst_14396 = (state_14681[(32)]);
var inst_14340 = (state_14681[(33)]);
var inst_14414 = (state_14681[(34)]);
var inst_14452 = (state_14681[(35)]);
var inst_14451 = (state_14681[(36)]);
var inst_14315 = (state_14681[(37)]);
var inst_14432 = (state_14681[(38)]);
var inst_14483 = (state_14681[(39)]);
var inst_14441 = (state_14681[(40)]);
var inst_14493 = (state_14681[(41)]);
var inst_14481 = (state_14681[(13)]);
var inst_14474 = (state_14681[(42)]);
var inst_14492 = (state_14681[(43)]);
var inst_14308 = (state_14681[(44)]);
var inst_14304 = (state_14681[(45)]);
var inst_14341 = (state_14681[(46)]);
var inst_14509 = (state_14681[(47)]);
var inst_14498 = (state_14681[(48)]);
var inst_14339 = (state_14681[(49)]);
var inst_14316 = (state_14681[(50)]);
var inst_14405 = (state_14681[(51)]);
var inst_14488 = (state_14681[(52)]);
var inst_14309 = (state_14681[(53)]);
var inst_14531 = (function (){var no_filter_QMARK_ = true;
var t = inst_14488;
var max_limit_QMARK_ = inst_14482;
var map__14303 = inst_14474;
var next_node = inst_14505;
var vec__14297 = inst_14392;
var fast_forward_db_QMARK_ = inst_14493;
var s1 = inst_14351;
var o2 = inst_14414;
var t1 = inst_14308;
var predicate_fn = inst_14341;
var i = inst_14507;
var m1 = inst_14441;
var root_node = inst_14498;
var s2 = inst_14360;
var p2 = inst_14432;
var permissions = inst_14483;
var limit = inst_14481;
var start_flake = inst_14451;
var flake_limit = inst_14475;
var offset = inst_14506;
var acc = inst_14509;
var t2 = inst_14315;
var op1 = inst_14309;
var o1 = inst_14405;
var end_flake = inst_14452;
var base_result = inst_14515;
var s = inst_14508;
var node_start = inst_14502;
var p1 = inst_14423;
var subject_fn = inst_14340;
var vec__14293 = inst_14311;
var map__14296 = inst_14339;
var object_fn = inst_14396;
var idx_compare = inst_14487;
var G__14516 = inst_14529;
var vec__14300 = inst_14393;
var op2 = inst_14316;
var m2 = inst_14450;
var vec__14290 = inst_14304;
var novelty = inst_14492;
return (function (p1__14273_SHARP_){
var G__14727 = p1__14273_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__14727) : predicate_fn.call(null,G__14727));
});
})();
var inst_14532 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14531,inst_14529);
var state_14681__$1 = state_14681;
var statearr_14728_14927 = state_14681__$1;
(statearr_14728_14927[(2)] = inst_14532);

(statearr_14728_14927[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (104))){
var inst_14507 = (state_14681[(23)]);
var inst_14508 = (state_14681[(10)]);
var inst_14475 = (state_14681[(30)]);
var inst_14509 = (state_14681[(47)]);
var inst_14541 = (state_14681[(64)]);
var inst_14553 = cljs.core.count(inst_14541);
var inst_14554 = (inst_14475 - inst_14507);
var inst_14555 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_14554,inst_14541);
var inst_14556 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14509,inst_14555);
var inst_14557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14558 = (inst_14507 + inst_14553);
var inst_14559 = [(0),inst_14558,inst_14508,inst_14556];
var inst_14560 = (new cljs.core.PersistentVector(null,4,(5),inst_14557,inst_14559,null));
var state_14681__$1 = state_14681;
var statearr_14729_14928 = state_14681__$1;
(statearr_14729_14928[(2)] = inst_14560);

(statearr_14729_14928[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (15))){
var inst_14305 = (state_14681[(65)]);
var inst_14345 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14305);
var state_14681__$1 = state_14681;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14681__$1,(18),inst_14345);
} else {
if((state_val_14682 === (48))){
var inst_14313 = (state_14681[(66)]);
var inst_14423 = (state_14681[(2)]);
var inst_14424 = (inst_14313 == null);
var state_14681__$1 = (function (){var statearr_14730 = state_14681;
(statearr_14730[(17)] = inst_14423);

return statearr_14730;
})();
if(cljs.core.truth_(inst_14424)){
var statearr_14731_14929 = state_14681__$1;
(statearr_14731_14929[(1)] = (49));

} else {
var statearr_14732_14930 = state_14681__$1;
(statearr_14732_14930[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (50))){
var state_14681__$1 = state_14681;
var statearr_14733_14931 = state_14681__$1;
(statearr_14733_14931[(2)] = false);

(statearr_14733_14931[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (116))){
var inst_14601 = (state_14681[(67)]);
var inst_14603 = (state_14681[(68)]);
var inst_14602 = (state_14681[(69)]);
var inst_14475 = (state_14681[(30)]);
var inst_14606 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14607 = (inst_14603 - inst_14475);
var inst_14608 = (inst_14602 - inst_14607);
var inst_14609 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_14608,inst_14601);
var inst_14610 = [inst_14475,inst_14609];
var inst_14611 = (new cljs.core.PersistentVector(null,2,(5),inst_14606,inst_14610,null));
var state_14681__$1 = state_14681;
var statearr_14734_14932 = state_14681__$1;
(statearr_14734_14932[(2)] = inst_14611);

(statearr_14734_14932[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (75))){
var inst_14476 = (state_14681[(70)]);
var inst_14474 = (state_14681[(42)]);
var inst_14474__$1 = (state_14681[(2)]);
var inst_14475 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_14474__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_14476__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14474__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_14477 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_14474__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_14681__$1 = (function (){var statearr_14735 = state_14681;
(statearr_14735[(30)] = inst_14475);

(statearr_14735[(70)] = inst_14476__$1);

(statearr_14735[(42)] = inst_14474__$1);

(statearr_14735[(71)] = inst_14477);

return statearr_14735;
})();
if(cljs.core.truth_(inst_14476__$1)){
var statearr_14736_14933 = state_14681__$1;
(statearr_14736_14933[(1)] = (76));

} else {
var statearr_14737_14934 = state_14681__$1;
(statearr_14737_14934[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (99))){
var inst_14482 = (state_14681[(26)]);
var state_14681__$1 = state_14681;
var statearr_14738_14935 = state_14681__$1;
(statearr_14738_14935[(2)] = inst_14482);

(statearr_14738_14935[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (21))){
var inst_14307 = (state_14681[(72)]);
var inst_14360 = (state_14681[(2)]);
var inst_14361 = cljs.core.boolean_QMARK_(inst_14307);
var state_14681__$1 = (function (){var statearr_14739 = state_14681;
(statearr_14739[(25)] = inst_14360);

return statearr_14739;
})();
if(inst_14361){
var statearr_14740_14936 = state_14681__$1;
(statearr_14740_14936[(1)] = (23));

} else {
var statearr_14741_14937 = state_14681__$1;
(statearr_14741_14937[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (31))){
var inst_14370 = (state_14681[(2)]);
var state_14681__$1 = state_14681;
var statearr_14742_14938 = state_14681__$1;
(statearr_14742_14938[(2)] = inst_14370);

(statearr_14742_14938[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (113))){
var inst_14583 = (state_14681[(9)]);
var inst_14481 = (state_14681[(13)]);
var inst_14585 = (state_14681[(14)]);
var inst_14588 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14589 = (inst_14583 - inst_14585);
var inst_14590 = [inst_14481,inst_14589];
var inst_14591 = (new cljs.core.PersistentVector(null,2,(5),inst_14588,inst_14590,null));
var state_14681__$1 = state_14681;
var statearr_14743_14939 = state_14681__$1;
(statearr_14743_14939[(2)] = inst_14591);

(statearr_14743_14939[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (32))){
var inst_14307 = (state_14681[(72)]);
var inst_14314 = (state_14681[(55)]);
var inst_14342 = (state_14681[(73)]);
var inst_14377 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14379 = [inst_14307,inst_14314];
var inst_14380 = (new cljs.core.PersistentVector(null,2,(5),inst_14378,inst_14379,null));
var inst_14381 = [inst_14380,inst_14342];
var inst_14382 = (new cljs.core.PersistentVector(null,2,(5),inst_14377,inst_14381,null));
var state_14681__$1 = state_14681;
var statearr_14744_14940 = state_14681__$1;
(statearr_14744_14940[(2)] = inst_14382);

(statearr_14744_14940[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (40))){
var inst_14395 = (state_14681[(57)]);
var state_14681__$1 = state_14681;
var statearr_14745_14941 = state_14681__$1;
(statearr_14745_14941[(2)] = inst_14395);

(statearr_14745_14941[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (129))){
var inst_14665 = (state_14681[(2)]);
var inst_14666 = cljs.core.not(inst_14665);
var state_14681__$1 = state_14681;
if(inst_14666){
var statearr_14746_14942 = state_14681__$1;
(statearr_14746_14942[(1)] = (130));

} else {
var statearr_14747_14943 = state_14681__$1;
(statearr_14747_14943[(1)] = (131));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (91))){
var inst_14341 = (state_14681[(46)]);
var inst_14529 = (state_14681[(2)]);
var state_14681__$1 = (function (){var statearr_14748 = state_14681;
(statearr_14748[(63)] = inst_14529);

return statearr_14748;
})();
if(cljs.core.truth_(inst_14341)){
var statearr_14749_14944 = state_14681__$1;
(statearr_14749_14944[(1)] = (92));

} else {
var statearr_14750_14945 = state_14681__$1;
(statearr_14750_14945[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (117))){
var inst_14601 = (state_14681[(67)]);
var inst_14603 = (state_14681[(68)]);
var inst_14613 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14614 = [inst_14603,inst_14601];
var inst_14615 = (new cljs.core.PersistentVector(null,2,(5),inst_14613,inst_14614,null));
var state_14681__$1 = state_14681;
var statearr_14751_14946 = state_14681__$1;
(statearr_14751_14946[(2)] = inst_14615);

(statearr_14751_14946[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (108))){
var inst_14506 = (state_14681[(19)]);
var inst_14563 = (state_14681[(74)]);
var inst_14575 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_14506,inst_14563);
var state_14681__$1 = (function (){var statearr_14752 = state_14681;
(statearr_14752[(11)] = inst_14575);

return statearr_14752;
})();
var statearr_14753_14947 = state_14681__$1;
(statearr_14753_14947[(1)] = (110));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (56))){
var inst_14435 = (cljs.core._GT__EQ_ === start_test);
var state_14681__$1 = state_14681;
if(cljs.core.truth_(inst_14435)){
var statearr_14755_14948 = state_14681__$1;
(statearr_14755_14948[(1)] = (58));

} else {
var statearr_14756_14949 = state_14681__$1;
(statearr_14756_14949[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (33))){
var inst_14307 = (state_14681[(72)]);
var inst_14351 = (state_14681[(20)]);
var inst_14360 = (state_14681[(25)]);
var inst_14374 = (state_14681[(75)]);
var inst_14311 = (state_14681[(28)]);
var inst_14314 = (state_14681[(55)]);
var inst_14340 = (state_14681[(33)]);
var inst_14342 = (state_14681[(73)]);
var inst_14317 = (state_14681[(76)]);
var inst_14310 = (state_14681[(56)]);
var inst_14313 = (state_14681[(66)]);
var inst_14306 = (state_14681[(77)]);
var inst_14315 = (state_14681[(37)]);
var inst_14308 = (state_14681[(44)]);
var inst_14304 = (state_14681[(45)]);
var inst_14341 = (state_14681[(46)]);
var inst_14339 = (state_14681[(49)]);
var inst_14316 = (state_14681[(50)]);
var inst_14309 = (state_14681[(53)]);
var inst_14384 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14385 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14386 = [null,null];
var inst_14387 = (new cljs.core.PersistentVector(null,2,(5),inst_14385,inst_14386,null));
var inst_14388 = (function (){var bool = inst_14374;
var s1 = inst_14351;
var o2 = inst_14314;
var t1 = inst_14308;
var predicate_fn = inst_14341;
var m1 = inst_14310;
var s2 = inst_14360;
var p2 = inst_14313;
var temp__5737__auto__ = inst_14374;
var t2 = inst_14315;
var op1 = inst_14309;
var o1 = inst_14307;
var p1 = inst_14306;
var subject_fn = inst_14340;
var vec__14293 = inst_14311;
var map__14296 = inst_14339;
var object_fn = inst_14342;
var op2 = inst_14316;
var m2 = inst_14317;
var vec__14290 = inst_14304;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_14389 = [inst_14387,inst_14388];
var inst_14390 = (new cljs.core.PersistentVector(null,2,(5),inst_14384,inst_14389,null));
var state_14681__$1 = state_14681;
var statearr_14757_14950 = state_14681__$1;
(statearr_14757_14950[(2)] = inst_14390);

(statearr_14757_14950[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (13))){
var inst_14318 = (state_14681[(78)]);
var state_14681__$1 = state_14681;
var statearr_14758_14951 = state_14681__$1;
(statearr_14758_14951[(2)] = inst_14318);

(statearr_14758_14951[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (22))){
var inst_14356 = (state_14681[(2)]);
var inst_14357 = fluree.db.util.async.throw_err(inst_14356);
var state_14681__$1 = state_14681;
var statearr_14759_14952 = state_14681__$1;
(statearr_14759_14952[(2)] = inst_14357);

(statearr_14759_14952[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (90))){
var inst_14523 = (state_14681[(58)]);
var state_14681__$1 = state_14681;
var statearr_14760_14953 = state_14681__$1;
(statearr_14760_14953[(2)] = inst_14523);

(statearr_14760_14953[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (109))){
var inst_14638 = (state_14681[(2)]);
var state_14681__$1 = state_14681;
var statearr_14761_14954 = state_14681__$1;
(statearr_14761_14954[(2)] = inst_14638);

(statearr_14761_14954[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (36))){
var inst_14394 = (state_14681[(79)]);
var state_14681__$1 = state_14681;
var statearr_14762_14955 = state_14681__$1;
(statearr_14762_14955[(2)] = inst_14394);

(statearr_14762_14955[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (41))){
var inst_14306 = (state_14681[(77)]);
var inst_14414 = (state_14681[(2)]);
var inst_14415 = (inst_14306 == null);
var state_14681__$1 = (function (){var statearr_14763 = state_14681;
(statearr_14763[(34)] = inst_14414);

return statearr_14763;
})();
if(cljs.core.truth_(inst_14415)){
var statearr_14764_14956 = state_14681__$1;
(statearr_14764_14956[(1)] = (43));

} else {
var statearr_14765_14957 = state_14681__$1;
(statearr_14765_14957[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (118))){
var inst_14598 = (state_14681[(80)]);
var inst_14617 = (state_14681[(2)]);
var inst_14618 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14617,(0),null);
var inst_14619 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14617,(1),null);
var inst_14620 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14621 = [inst_14618,inst_14598,inst_14619];
var inst_14622 = (new cljs.core.PersistentVector(null,3,(5),inst_14620,inst_14621,null));
var state_14681__$1 = state_14681;
var statearr_14766_14958 = state_14681__$1;
(statearr_14766_14958[(2)] = inst_14622);

(statearr_14766_14958[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (89))){
var inst_14423 = (state_14681[(17)]);
var inst_14392 = (state_14681[(18)]);
var inst_14506 = (state_14681[(19)]);
var inst_14351 = (state_14681[(20)]);
var inst_14450 = (state_14681[(21)]);
var inst_14502 = (state_14681[(22)]);
var inst_14507 = (state_14681[(23)]);
var inst_14487 = (state_14681[(24)]);
var inst_14360 = (state_14681[(25)]);
var inst_14482 = (state_14681[(26)]);
var inst_14393 = (state_14681[(27)]);
var inst_14508 = (state_14681[(10)]);
var inst_14311 = (state_14681[(28)]);
var inst_14505 = (state_14681[(29)]);
var inst_14475 = (state_14681[(30)]);
var inst_14515 = (state_14681[(31)]);
var inst_14396 = (state_14681[(32)]);
var inst_14340 = (state_14681[(33)]);
var inst_14414 = (state_14681[(34)]);
var inst_14452 = (state_14681[(35)]);
var inst_14451 = (state_14681[(36)]);
var inst_14523 = (state_14681[(58)]);
var inst_14315 = (state_14681[(37)]);
var inst_14432 = (state_14681[(38)]);
var inst_14483 = (state_14681[(39)]);
var inst_14441 = (state_14681[(40)]);
var inst_14493 = (state_14681[(41)]);
var inst_14481 = (state_14681[(13)]);
var inst_14474 = (state_14681[(42)]);
var inst_14492 = (state_14681[(43)]);
var inst_14308 = (state_14681[(44)]);
var inst_14304 = (state_14681[(45)]);
var inst_14341 = (state_14681[(46)]);
var inst_14509 = (state_14681[(47)]);
var inst_14498 = (state_14681[(48)]);
var inst_14339 = (state_14681[(49)]);
var inst_14316 = (state_14681[(50)]);
var inst_14405 = (state_14681[(51)]);
var inst_14488 = (state_14681[(52)]);
var inst_14309 = (state_14681[(53)]);
var inst_14525 = (function (){var no_filter_QMARK_ = true;
var t = inst_14488;
var max_limit_QMARK_ = inst_14482;
var map__14303 = inst_14474;
var next_node = inst_14505;
var vec__14297 = inst_14392;
var fast_forward_db_QMARK_ = inst_14493;
var s1 = inst_14351;
var o2 = inst_14414;
var t1 = inst_14308;
var predicate_fn = inst_14341;
var i = inst_14507;
var m1 = inst_14441;
var root_node = inst_14498;
var s2 = inst_14360;
var p2 = inst_14432;
var permissions = inst_14483;
var limit = inst_14481;
var start_flake = inst_14451;
var flake_limit = inst_14475;
var offset = inst_14506;
var acc = inst_14509;
var t2 = inst_14315;
var op1 = inst_14309;
var o1 = inst_14405;
var end_flake = inst_14452;
var base_result = inst_14515;
var s = inst_14508;
var node_start = inst_14502;
var p1 = inst_14423;
var subject_fn = inst_14340;
var vec__14293 = inst_14311;
var map__14296 = inst_14339;
var object_fn = inst_14396;
var idx_compare = inst_14487;
var G__14516 = inst_14523;
var vec__14300 = inst_14393;
var op2 = inst_14316;
var m2 = inst_14450;
var vec__14290 = inst_14304;
var novelty = inst_14492;
return (function (p1__14272_SHARP_){
var G__14767 = p1__14272_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__14767) : subject_fn.call(null,G__14767));
});
})();
var inst_14526 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_14525,inst_14523);
var state_14681__$1 = state_14681;
var statearr_14768_14959 = state_14681__$1;
(statearr_14768_14959[(2)] = inst_14526);

(statearr_14768_14959[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (100))){
var inst_14551 = (state_14681[(2)]);
var state_14681__$1 = state_14681;
if(cljs.core.truth_(inst_14551)){
var statearr_14769_14960 = state_14681__$1;
(statearr_14769_14960[(1)] = (104));

} else {
var statearr_14770_14961 = state_14681__$1;
(statearr_14770_14961[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (131))){
var inst_14644 = (state_14681[(15)]);
var inst_14661 = (state_14681[(81)]);
var inst_14642 = (state_14681[(59)]);
var inst_14643 = (state_14681[(60)]);
var inst_14641 = (state_14681[(61)]);
var inst_14505 = inst_14661;
var inst_14506 = inst_14641;
var inst_14507 = inst_14642;
var inst_14508 = inst_14643;
var inst_14509 = inst_14644;
var state_14681__$1 = (function (){var statearr_14771 = state_14681;
(statearr_14771[(19)] = inst_14506);

(statearr_14771[(23)] = inst_14507);

(statearr_14771[(10)] = inst_14508);

(statearr_14771[(29)] = inst_14505);

(statearr_14771[(47)] = inst_14509);

return statearr_14771;
})();
var statearr_14772_14962 = state_14681__$1;
(statearr_14772_14962[(2)] = null);

(statearr_14772_14962[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (122))){
var inst_14653 = (state_14681[(16)]);
var inst_14653__$1 = (state_14681[(2)]);
var state_14681__$1 = (function (){var statearr_14773 = state_14681;
(statearr_14773[(16)] = inst_14653__$1);

return statearr_14773;
})();
if(cljs.core.truth_(inst_14653__$1)){
var statearr_14774_14963 = state_14681__$1;
(statearr_14774_14963[(1)] = (123));

} else {
var statearr_14775_14964 = state_14681__$1;
(statearr_14775_14964[(1)] = (124));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (43))){
var inst_14405 = (state_14681[(51)]);
var state_14681__$1 = state_14681;
var statearr_14776_14965 = state_14681__$1;
(statearr_14776_14965[(2)] = inst_14405);

(statearr_14776_14965[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (61))){
var inst_14317 = (state_14681[(76)]);
var state_14681__$1 = state_14681;
var statearr_14777_14966 = state_14681__$1;
(statearr_14777_14966[(2)] = inst_14317);

(statearr_14777_14966[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (29))){
var state_14681__$1 = state_14681;
var statearr_14778_14967 = state_14681__$1;
(statearr_14778_14967[(2)] = null);

(statearr_14778_14967[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (44))){
var state_14681__$1 = state_14681;
var statearr_14779_14968 = state_14681__$1;
(statearr_14779_14968[(2)] = false);

(statearr_14779_14968[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (93))){
var inst_14529 = (state_14681[(63)]);
var state_14681__$1 = state_14681;
var statearr_14780_14969 = state_14681__$1;
(statearr_14780_14969[(2)] = inst_14529);

(statearr_14780_14969[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (6))){
var inst_14318 = (state_14681[(78)]);
var inst_14323 = inst_14318.cljs$lang$protocol_mask$partition0$;
var inst_14324 = (inst_14323 & (64));
var inst_14325 = inst_14318.cljs$core$ISeq$;
var inst_14326 = (cljs.core.PROTOCOL_SENTINEL === inst_14325);
var inst_14327 = ((inst_14324) || (inst_14326));
var state_14681__$1 = state_14681;
if(cljs.core.truth_(inst_14327)){
var statearr_14781_14970 = state_14681__$1;
(statearr_14781_14970[(1)] = (9));

} else {
var statearr_14782_14971 = state_14681__$1;
(statearr_14782_14971[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (111))){
var inst_14507 = (state_14681[(23)]);
var inst_14508 = (state_14681[(10)]);
var inst_14575 = (state_14681[(11)]);
var inst_14475 = (state_14681[(30)]);
var inst_14481 = (state_14681[(13)]);
var inst_14624 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_14575,inst_14507,inst_14508,inst_14475,inst_14481);
var state_14681__$1 = state_14681;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14681__$1,(119),inst_14624);
} else {
if((state_val_14682 === (28))){
var inst_14372 = (state_14681[(2)]);
var state_14681__$1 = state_14681;
var statearr_14783_14972 = state_14681__$1;
(statearr_14783_14972[(2)] = inst_14372);

(statearr_14783_14972[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (64))){
var state_14681__$1 = state_14681;
var statearr_14784_14973 = state_14681__$1;
(statearr_14784_14973[(2)] = (2147483647));

(statearr_14784_14973[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (103))){
var inst_14548 = (state_14681[(2)]);
var state_14681__$1 = state_14681;
var statearr_14785_14974 = state_14681__$1;
(statearr_14785_14974[(2)] = inst_14548);

(statearr_14785_14974[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (51))){
var inst_14428 = (state_14681[(2)]);
var state_14681__$1 = state_14681;
if(cljs.core.truth_(inst_14428)){
var statearr_14786_14975 = state_14681__$1;
(statearr_14786_14975[(1)] = (52));

} else {
var statearr_14787_14976 = state_14681__$1;
(statearr_14787_14976[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (25))){
var inst_14374 = (state_14681[(75)]);
var inst_14374__$1 = (state_14681[(2)]);
var inst_14375 = (inst_14374__$1 == null);
var state_14681__$1 = (function (){var statearr_14788 = state_14681;
(statearr_14788[(75)] = inst_14374__$1);

return statearr_14788;
})();
if(cljs.core.truth_(inst_14375)){
var statearr_14789_14977 = state_14681__$1;
(statearr_14789_14977[(1)] = (32));

} else {
var statearr_14790_14978 = state_14681__$1;
(statearr_14790_14978[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (34))){
var inst_14392 = (state_14681[(18)]);
var inst_14394 = (state_14681[(79)]);
var inst_14393 = (state_14681[(27)]);
var inst_14392__$1 = (state_14681[(2)]);
var inst_14393__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14392__$1,(0),null);
var inst_14394__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14393__$1,(0),null);
var inst_14395 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14393__$1,(1),null);
var inst_14396 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14392__$1,(1),null);
var inst_14397 = fluree.db.util.core.pred_ident_QMARK_(inst_14394__$1);
var state_14681__$1 = (function (){var statearr_14791 = state_14681;
(statearr_14791[(18)] = inst_14392__$1);

(statearr_14791[(79)] = inst_14394__$1);

(statearr_14791[(27)] = inst_14393__$1);

(statearr_14791[(57)] = inst_14395);

(statearr_14791[(32)] = inst_14396);

return statearr_14791;
})();
if(inst_14397){
var statearr_14792_14979 = state_14681__$1;
(statearr_14792_14979[(1)] = (35));

} else {
var statearr_14793_14980 = state_14681__$1;
(statearr_14793_14980[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (125))){
var inst_14653 = (state_14681[(16)]);
var inst_14661 = (state_14681[(2)]);
var state_14681__$1 = (function (){var statearr_14794 = state_14681;
(statearr_14794[(81)] = inst_14661);

return statearr_14794;
})();
if(cljs.core.truth_(inst_14653)){
var statearr_14795_14981 = state_14681__$1;
(statearr_14795_14981[(1)] = (127));

} else {
var statearr_14796_14982 = state_14681__$1;
(statearr_14796_14982[(1)] = (128));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (17))){
var inst_14312 = (state_14681[(54)]);
var inst_14351 = (state_14681[(2)]);
var inst_14352 = fluree.db.util.core.pred_ident_QMARK_(inst_14312);
var state_14681__$1 = (function (){var statearr_14797 = state_14681;
(statearr_14797[(20)] = inst_14351);

return statearr_14797;
})();
if(inst_14352){
var statearr_14798_14983 = state_14681__$1;
(statearr_14798_14983[(1)] = (19));

} else {
var statearr_14799_14984 = state_14681__$1;
(statearr_14799_14984[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (3))){
var inst_14679 = (state_14681[(2)]);
var state_14681__$1 = state_14681;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14681__$1,inst_14679);
} else {
if((state_val_14682 === (12))){
var inst_14318 = (state_14681[(78)]);
var inst_14336 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_14318);
var state_14681__$1 = state_14681;
var statearr_14800_14985 = state_14681__$1;
(statearr_14800_14985[(2)] = inst_14336);

(statearr_14800_14985[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (2))){
var inst_14311 = (state_14681[(28)]);
var inst_14318 = (state_14681[(78)]);
var inst_14304 = (state_14681[(45)]);
var _ = (function (){var statearr_14801 = state_14681;
(statearr_14801[(4)] = cljs.core.cons((5),(state_14681[(4)])));

return statearr_14801;
})();
var inst_14304__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_14305 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14304__$1,(0),null);
var inst_14306 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14304__$1,(1),null);
var inst_14307 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14304__$1,(2),null);
var inst_14308 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14304__$1,(3),null);
var inst_14309 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14304__$1,(4),null);
var inst_14310 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14304__$1,(5),null);
var inst_14311__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_14312 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14311__$1,(0),null);
var inst_14313 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14311__$1,(1),null);
var inst_14314 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14311__$1,(2),null);
var inst_14315 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14311__$1,(3),null);
var inst_14316 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14311__$1,(4),null);
var inst_14317 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14311__$1,(5),null);
var inst_14318__$1 = opts;
var inst_14320 = (inst_14318__$1 == null);
var inst_14321 = cljs.core.not(inst_14320);
var state_14681__$1 = (function (){var statearr_14802 = state_14681;
(statearr_14802[(72)] = inst_14307);

(statearr_14802[(28)] = inst_14311__$1);

(statearr_14802[(54)] = inst_14312);

(statearr_14802[(55)] = inst_14314);

(statearr_14802[(76)] = inst_14317);

(statearr_14802[(56)] = inst_14310);

(statearr_14802[(66)] = inst_14313);

(statearr_14802[(77)] = inst_14306);

(statearr_14802[(37)] = inst_14315);

(statearr_14802[(65)] = inst_14305);

(statearr_14802[(78)] = inst_14318__$1);

(statearr_14802[(44)] = inst_14308);

(statearr_14802[(45)] = inst_14304__$1);

(statearr_14802[(50)] = inst_14316);

(statearr_14802[(53)] = inst_14309);

return statearr_14802;
})();
if(inst_14321){
var statearr_14803_14986 = state_14681__$1;
(statearr_14803_14986[(1)] = (6));

} else {
var statearr_14804_14987 = state_14681__$1;
(statearr_14804_14987[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (66))){
var inst_14448 = (state_14681[(2)]);
var state_14681__$1 = state_14681;
var statearr_14805_14988 = state_14681__$1;
(statearr_14805_14988[(2)] = inst_14448);

(statearr_14805_14988[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (107))){
var inst_14506 = (state_14681[(19)]);
var inst_14507 = (state_14681[(23)]);
var inst_14508 = (state_14681[(10)]);
var inst_14564 = (state_14681[(82)]);
var inst_14509 = (state_14681[(47)]);
var inst_14567 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14568 = (inst_14506 - inst_14564);
var inst_14569 = [inst_14568,inst_14507,inst_14508,inst_14509];
var inst_14570 = (new cljs.core.PersistentVector(null,4,(5),inst_14567,inst_14569,null));
var state_14681__$1 = state_14681;
var statearr_14806_14989 = state_14681__$1;
(statearr_14806_14989[(2)] = inst_14570);

(statearr_14806_14989[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (23))){
var inst_14307 = (state_14681[(72)]);
var state_14681__$1 = state_14681;
var statearr_14807_14990 = state_14681__$1;
(statearr_14807_14990[(2)] = inst_14307);

(statearr_14807_14990[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (47))){
var inst_14306 = (state_14681[(77)]);
var state_14681__$1 = state_14681;
var statearr_14808_14991 = state_14681__$1;
(statearr_14808_14991[(2)] = inst_14306);

(statearr_14808_14991[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (35))){
var inst_14394 = (state_14681[(79)]);
var inst_14399 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14394);
var state_14681__$1 = state_14681;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14681__$1,(38),inst_14399);
} else {
if((state_val_14682 === (127))){
var inst_14661 = (state_14681[(81)]);
var state_14681__$1 = state_14681;
var statearr_14809_14992 = state_14681__$1;
(statearr_14809_14992[(2)] = inst_14661);

(statearr_14809_14992[(1)] = (129));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (82))){
var state_14681__$1 = state_14681;
var statearr_14810_14993 = state_14681__$1;
(statearr_14810_14993[(2)] = null);

(statearr_14810_14993[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (76))){
var inst_14476 = (state_14681[(70)]);
var state_14681__$1 = state_14681;
var statearr_14811_14994 = state_14681__$1;
(statearr_14811_14994[(2)] = inst_14476);

(statearr_14811_14994[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (97))){
var inst_14482 = (state_14681[(26)]);
var inst_14505 = (state_14681[(29)]);
var inst_14541 = (state_14681[(2)]);
var inst_14542 = fluree.db.dbproto._rhs(inst_14505);
var state_14681__$1 = (function (){var statearr_14812 = state_14681;
(statearr_14812[(7)] = inst_14542);

(statearr_14812[(64)] = inst_14541);

return statearr_14812;
})();
if(cljs.core.truth_(inst_14482)){
var statearr_14813_14995 = state_14681__$1;
(statearr_14813_14995[(1)] = (98));

} else {
var statearr_14814_14996 = state_14681__$1;
(statearr_14814_14996[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (19))){
var inst_14312 = (state_14681[(54)]);
var inst_14354 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_14312);
var state_14681__$1 = state_14681;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14681__$1,(22),inst_14354);
} else {
if((state_val_14682 === (57))){
var inst_14317 = (state_14681[(76)]);
var inst_14441 = (state_14681[(2)]);
var state_14681__$1 = (function (){var statearr_14815 = state_14681;
(statearr_14815[(40)] = inst_14441);

return statearr_14815;
})();
if(cljs.core.truth_(inst_14317)){
var statearr_14816_14997 = state_14681__$1;
(statearr_14816_14997[(1)] = (61));

} else {
var statearr_14817_14998 = state_14681__$1;
(statearr_14817_14998[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (68))){
var state_14681__$1 = state_14681;
var statearr_14818_14999 = state_14681__$1;
(statearr_14818_14999[(2)] = false);

(statearr_14818_14999[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (11))){
var inst_14331 = (state_14681[(2)]);
var state_14681__$1 = state_14681;
var statearr_14819_15000 = state_14681__$1;
(statearr_14819_15000[(2)] = inst_14331);

(statearr_14819_15000[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (115))){
var inst_14601 = (state_14681[(67)]);
var inst_14507 = (state_14681[(23)]);
var inst_14575 = (state_14681[(11)]);
var inst_14603 = (state_14681[(68)]);
var inst_14602 = (state_14681[(69)]);
var inst_14475 = (state_14681[(30)]);
var inst_14597 = (state_14681[(2)]);
var inst_14598 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14597,(0),null);
var inst_14599 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14597,(1),null);
var inst_14600 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_14599,inst_14575);
var inst_14601__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_14600);
var inst_14602__$1 = cljs.core.count(inst_14601__$1);
var inst_14603__$1 = (inst_14507 + inst_14602__$1);
var inst_14604 = (inst_14603__$1 > inst_14475);
var state_14681__$1 = (function (){var statearr_14821 = state_14681;
(statearr_14821[(67)] = inst_14601__$1);

(statearr_14821[(68)] = inst_14603__$1);

(statearr_14821[(69)] = inst_14602__$1);

(statearr_14821[(80)] = inst_14598);

return statearr_14821;
})();
if(cljs.core.truth_(inst_14604)){
var statearr_14822_15001 = state_14681__$1;
(statearr_14822_15001[(1)] = (116));

} else {
var statearr_14823_15002 = state_14681__$1;
(statearr_14823_15002[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (9))){
var state_14681__$1 = state_14681;
var statearr_14824_15003 = state_14681__$1;
(statearr_14824_15003[(2)] = true);

(statearr_14824_15003[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (5))){
var _ = (function (){var statearr_14825 = state_14681;
(statearr_14825[(4)] = cljs.core.rest((state_14681[(4)])));

return statearr_14825;
})();
var state_14681__$1 = state_14681;
var ex14820 = (state_14681__$1[(2)]);
var statearr_14826_15004 = state_14681__$1;
(statearr_14826_15004[(5)] = ex14820);


if((ex14820 instanceof Error)){
var statearr_14827_15005 = state_14681__$1;
(statearr_14827_15005[(1)] = (4));

(statearr_14827_15005[(5)] = null);

} else {
throw ex14820;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (112))){
var inst_14509 = (state_14681[(47)]);
var inst_14629 = (state_14681[(2)]);
var inst_14630 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14629,(0),null);
var inst_14631 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14629,(1),null);
var inst_14632 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14629,(2),null);
var inst_14633 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14634 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_14509,inst_14632);
var inst_14635 = [(0),inst_14630,inst_14631,inst_14634];
var inst_14636 = (new cljs.core.PersistentVector(null,4,(5),inst_14633,inst_14635,null));
var state_14681__$1 = state_14681;
var statearr_14828_15006 = state_14681__$1;
(statearr_14828_15006[(2)] = inst_14636);

(statearr_14828_15006[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (83))){
var inst_14676 = (state_14681[(2)]);
var _ = (function (){var statearr_14829 = state_14681;
(statearr_14829[(4)] = cljs.core.rest((state_14681[(4)])));

return statearr_14829;
})();
var state_14681__$1 = state_14681;
var statearr_14830_15007 = state_14681__$1;
(statearr_14830_15007[(2)] = inst_14676);

(statearr_14830_15007[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (14))){
var inst_14305 = (state_14681[(65)]);
var inst_14339 = (state_14681[(49)]);
var inst_14339__$1 = (state_14681[(2)]);
var inst_14340 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14339__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_14341 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14339__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_14342 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14339__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_14343 = fluree.db.util.core.pred_ident_QMARK_(inst_14305);
var state_14681__$1 = (function (){var statearr_14831 = state_14681;
(statearr_14831[(33)] = inst_14340);

(statearr_14831[(73)] = inst_14342);

(statearr_14831[(46)] = inst_14341);

(statearr_14831[(49)] = inst_14339__$1);

return statearr_14831;
})();
if(inst_14343){
var statearr_14832_15008 = state_14681__$1;
(statearr_14832_15008[(1)] = (15));

} else {
var statearr_14833_15009 = state_14681__$1;
(statearr_14833_15009[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (45))){
var inst_14419 = (state_14681[(2)]);
var state_14681__$1 = state_14681;
if(cljs.core.truth_(inst_14419)){
var statearr_14834_15010 = state_14681__$1;
(statearr_14834_15010[(1)] = (46));

} else {
var statearr_14835_15011 = state_14681__$1;
(statearr_14835_15011[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (53))){
var inst_14313 = (state_14681[(66)]);
var state_14681__$1 = state_14681;
var statearr_14836_15012 = state_14681__$1;
(statearr_14836_15012[(2)] = inst_14313);

(statearr_14836_15012[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (78))){
var inst_14481 = (state_14681[(13)]);
var inst_14481__$1 = (state_14681[(2)]);
var inst_14482 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14481__$1,fluree.db.util.core.max_long);
var inst_14483 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_14484 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14485 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_14486 = (new cljs.core.PersistentVector(null,3,(5),inst_14484,inst_14485,null));
var inst_14487 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_14486);
var inst_14488 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_14489 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14490 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_14491 = (new cljs.core.PersistentVector(null,2,(5),inst_14489,inst_14490,null));
var inst_14492 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_14491);
var inst_14493 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_14494 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_14495 = fluree.db.dbproto._resolve(inst_14494);
var state_14681__$1 = (function (){var statearr_14837 = state_14681;
(statearr_14837[(24)] = inst_14487);

(statearr_14837[(26)] = inst_14482);

(statearr_14837[(39)] = inst_14483);

(statearr_14837[(41)] = inst_14493);

(statearr_14837[(13)] = inst_14481__$1);

(statearr_14837[(43)] = inst_14492);

(statearr_14837[(52)] = inst_14488);

return statearr_14837;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14681__$1,(79),inst_14495);
} else {
if((state_val_14682 === (132))){
var inst_14671 = (state_14681[(2)]);
var state_14681__$1 = state_14681;
var statearr_14838_15013 = state_14681__$1;
(statearr_14838_15013[(2)] = inst_14671);

(statearr_14838_15013[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (26))){
var inst_14314 = (state_14681[(55)]);
var state_14681__$1 = state_14681;
var statearr_14839_15014 = state_14681__$1;
(statearr_14839_15014[(2)] = inst_14314);

(statearr_14839_15014[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (123))){
var inst_14542 = (state_14681[(7)]);
var inst_14493 = (state_14681[(41)]);
var inst_14492 = (state_14681[(43)]);
var inst_14498 = (state_14681[(48)]);
var inst_14488 = (state_14681[(52)]);
var inst_14655 = fluree.db.query.range.find_next_valid_node(inst_14498,inst_14542,inst_14488,inst_14492,inst_14493);
var state_14681__$1 = state_14681;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14681__$1,(126),inst_14655);
} else {
if((state_val_14682 === (16))){
var inst_14305 = (state_14681[(65)]);
var state_14681__$1 = state_14681;
var statearr_14840_15015 = state_14681__$1;
(statearr_14840_15015[(2)] = inst_14305);

(statearr_14840_15015[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (81))){
var inst_14502 = (state_14681[(22)]);
var inst_14477 = (state_14681[(71)]);
var inst_14504 = cljs.core.PersistentVector.EMPTY;
var inst_14505 = inst_14502;
var inst_14506 = inst_14477;
var inst_14507 = (0);
var inst_14508 = (0);
var inst_14509 = inst_14504;
var state_14681__$1 = (function (){var statearr_14841 = state_14681;
(statearr_14841[(19)] = inst_14506);

(statearr_14841[(23)] = inst_14507);

(statearr_14841[(10)] = inst_14508);

(statearr_14841[(29)] = inst_14505);

(statearr_14841[(47)] = inst_14509);

return statearr_14841;
})();
var statearr_14842_15016 = state_14681__$1;
(statearr_14842_15016[(2)] = null);

(statearr_14842_15016[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (120))){
var inst_14642 = (state_14681[(59)]);
var inst_14643 = (state_14681[(60)]);
var inst_14487 = (state_14681[(24)]);
var inst_14542 = (state_14681[(7)]);
var inst_14475 = (state_14681[(30)]);
var inst_14452 = (state_14681[(35)]);
var inst_14481 = (state_14681[(13)]);
var inst_14646 = (inst_14487.cljs$core$IFn$_invoke$arity$2 ? inst_14487.cljs$core$IFn$_invoke$arity$2(inst_14542,inst_14452) : inst_14487.call(null,inst_14542,inst_14452));
var inst_14647 = (inst_14646 < (0));
var inst_14648 = (inst_14642 < inst_14475);
var inst_14649 = (inst_14643 < inst_14481);
var inst_14650 = ((inst_14647) && (inst_14648) && (inst_14649));
var state_14681__$1 = state_14681;
var statearr_14843_15017 = state_14681__$1;
(statearr_14843_15017[(2)] = inst_14650);

(statearr_14843_15017[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (79))){
var inst_14451 = (state_14681[(36)]);
var inst_14493 = (state_14681[(41)]);
var inst_14492 = (state_14681[(43)]);
var inst_14498 = (state_14681[(48)]);
var inst_14488 = (state_14681[(52)]);
var inst_14497 = (state_14681[(2)]);
var inst_14498__$1 = fluree.db.util.async.throw_err(inst_14497);
var inst_14499 = fluree.db.query.range.find_next_valid_node(inst_14498__$1,inst_14451,inst_14488,inst_14492,inst_14493);
var state_14681__$1 = (function (){var statearr_14844 = state_14681;
(statearr_14844[(48)] = inst_14498__$1);

return statearr_14844;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14681__$1,(80),inst_14499);
} else {
if((state_val_14682 === (38))){
var inst_14401 = (state_14681[(2)]);
var inst_14402 = fluree.db.util.async.throw_err(inst_14401);
var state_14681__$1 = state_14681;
var statearr_14845_15018 = state_14681__$1;
(statearr_14845_15018[(2)] = inst_14402);

(statearr_14845_15018[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (126))){
var inst_14657 = (state_14681[(2)]);
var inst_14658 = fluree.db.util.async.throw_err(inst_14657);
var state_14681__$1 = state_14681;
var statearr_14846_15019 = state_14681__$1;
(statearr_14846_15019[(2)] = inst_14658);

(statearr_14846_15019[(1)] = (125));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (98))){
var inst_14506 = (state_14681[(19)]);
var inst_14544 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_14506);
var state_14681__$1 = state_14681;
if(inst_14544){
var statearr_14847_15020 = state_14681__$1;
(statearr_14847_15020[(1)] = (101));

} else {
var statearr_14848_15021 = state_14681__$1;
(statearr_14848_15021[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (124))){
var state_14681__$1 = state_14681;
var statearr_14849_15022 = state_14681__$1;
(statearr_14849_15022[(2)] = null);

(statearr_14849_15022[(1)] = (125));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (87))){
var inst_14515 = (state_14681[(31)]);
var state_14681__$1 = state_14681;
var statearr_14850_15023 = state_14681__$1;
(statearr_14850_15023[(2)] = inst_14515);

(statearr_14850_15023[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (30))){
var state_14681__$1 = state_14681;
var statearr_14851_15024 = state_14681__$1;
(statearr_14851_15024[(2)] = null);

(statearr_14851_15024[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (73))){
var inst_14453 = (state_14681[(8)]);
var inst_14471 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_14453);
var state_14681__$1 = state_14681;
var statearr_14852_15025 = state_14681__$1;
(statearr_14852_15025[(2)] = inst_14471);

(statearr_14852_15025[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (96))){
var inst_14535 = (state_14681[(62)]);
var state_14681__$1 = state_14681;
var statearr_14853_15026 = state_14681__$1;
(statearr_14853_15026[(2)] = inst_14535);

(statearr_14853_15026[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (10))){
var state_14681__$1 = state_14681;
var statearr_14854_15027 = state_14681__$1;
(statearr_14854_15027[(2)] = false);

(statearr_14854_15027[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (18))){
var inst_14347 = (state_14681[(2)]);
var inst_14348 = fluree.db.util.async.throw_err(inst_14347);
var state_14681__$1 = state_14681;
var statearr_14855_15028 = state_14681__$1;
(statearr_14855_15028[(2)] = inst_14348);

(statearr_14855_15028[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (105))){
var inst_14423 = (state_14681[(17)]);
var inst_14392 = (state_14681[(18)]);
var inst_14506 = (state_14681[(19)]);
var inst_14351 = (state_14681[(20)]);
var inst_14450 = (state_14681[(21)]);
var inst_14502 = (state_14681[(22)]);
var inst_14507 = (state_14681[(23)]);
var inst_14487 = (state_14681[(24)]);
var inst_14360 = (state_14681[(25)]);
var inst_14482 = (state_14681[(26)]);
var inst_14393 = (state_14681[(27)]);
var inst_14508 = (state_14681[(10)]);
var inst_14311 = (state_14681[(28)]);
var inst_14542 = (state_14681[(7)]);
var inst_14505 = (state_14681[(29)]);
var inst_14564 = (state_14681[(82)]);
var inst_14475 = (state_14681[(30)]);
var inst_14515 = (state_14681[(31)]);
var inst_14396 = (state_14681[(32)]);
var inst_14340 = (state_14681[(33)]);
var inst_14414 = (state_14681[(34)]);
var inst_14563 = (state_14681[(74)]);
var inst_14452 = (state_14681[(35)]);
var inst_14451 = (state_14681[(36)]);
var inst_14315 = (state_14681[(37)]);
var inst_14432 = (state_14681[(38)]);
var inst_14483 = (state_14681[(39)]);
var inst_14441 = (state_14681[(40)]);
var inst_14493 = (state_14681[(41)]);
var inst_14481 = (state_14681[(13)]);
var inst_14474 = (state_14681[(42)]);
var inst_14492 = (state_14681[(43)]);
var inst_14308 = (state_14681[(44)]);
var inst_14304 = (state_14681[(45)]);
var inst_14341 = (state_14681[(46)]);
var inst_14509 = (state_14681[(47)]);
var inst_14498 = (state_14681[(48)]);
var inst_14339 = (state_14681[(49)]);
var inst_14316 = (state_14681[(50)]);
var inst_14541 = (state_14681[(64)]);
var inst_14405 = (state_14681[(51)]);
var inst_14488 = (state_14681[(52)]);
var inst_14309 = (state_14681[(53)]);
var inst_14562 = (function (){var no_filter_QMARK_ = true;
var base_result_SINGLEQUOTE_ = inst_14541;
var t = inst_14488;
var max_limit_QMARK_ = inst_14482;
var map__14303 = inst_14474;
var next_node = inst_14505;
var vec__14297 = inst_14392;
var fast_forward_db_QMARK_ = inst_14493;
var s1 = inst_14351;
var o2 = inst_14414;
var t1 = inst_14308;
var predicate_fn = inst_14341;
var i = inst_14507;
var rhs = inst_14542;
var m1 = inst_14441;
var root_node = inst_14498;
var s2 = inst_14360;
var p2 = inst_14432;
var permissions = inst_14483;
var limit = inst_14481;
var start_flake = inst_14451;
var flake_limit = inst_14475;
var offset = inst_14506;
var acc = inst_14509;
var t2 = inst_14315;
var op1 = inst_14309;
var o1 = inst_14405;
var end_flake = inst_14452;
var base_result = inst_14515;
var s = inst_14508;
var node_start = inst_14502;
var p1 = inst_14423;
var subject_fn = inst_14340;
var vec__14293 = inst_14311;
var map__14296 = inst_14339;
var object_fn = inst_14396;
var idx_compare = inst_14487;
var vec__14300 = inst_14393;
var op2 = inst_14316;
var m2 = inst_14450;
var vec__14290 = inst_14304;
var novelty = inst_14492;
return (function (p1__14275_SHARP_){
return p1__14275_SHARP_.s;
});
})();
var inst_14563__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_14562,inst_14541);
var inst_14564__$1 = cljs.core.count(inst_14563__$1);
var inst_14565 = (inst_14506 > inst_14564__$1);
var state_14681__$1 = (function (){var statearr_14856 = state_14681;
(statearr_14856[(82)] = inst_14564__$1);

(statearr_14856[(74)] = inst_14563__$1);

return statearr_14856;
})();
if(cljs.core.truth_(inst_14565)){
var statearr_14857_15029 = state_14681__$1;
(statearr_14857_15029[(1)] = (107));

} else {
var statearr_14858_15030 = state_14681__$1;
(statearr_14858_15030[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (52))){
var state_14681__$1 = state_14681;
var statearr_14859_15031 = state_14681__$1;
(statearr_14859_15031[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14859_15031[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (114))){
var inst_14584 = (state_14681[(12)]);
var inst_14593 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14594 = [inst_14584,inst_14584];
var inst_14595 = (new cljs.core.PersistentVector(null,2,(5),inst_14593,inst_14594,null));
var state_14681__$1 = state_14681;
var statearr_14860_15032 = state_14681__$1;
(statearr_14860_15032[(2)] = inst_14595);

(statearr_14860_15032[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (67))){
var inst_14453 = (state_14681[(8)]);
var inst_14458 = inst_14453.cljs$lang$protocol_mask$partition0$;
var inst_14459 = (inst_14458 & (64));
var inst_14460 = inst_14453.cljs$core$ISeq$;
var inst_14461 = (cljs.core.PROTOCOL_SENTINEL === inst_14460);
var inst_14462 = ((inst_14459) || (inst_14461));
var state_14681__$1 = state_14681;
if(cljs.core.truth_(inst_14462)){
var statearr_14861_15033 = state_14681__$1;
(statearr_14861_15033[(1)] = (70));

} else {
var statearr_14862_15034 = state_14681__$1;
(statearr_14862_15034[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (71))){
var state_14681__$1 = state_14681;
var statearr_14863_15035 = state_14681__$1;
(statearr_14863_15035[(2)] = false);

(statearr_14863_15035[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (42))){
var inst_14410 = (state_14681[(2)]);
var inst_14411 = fluree.db.util.async.throw_err(inst_14410);
var state_14681__$1 = state_14681;
var statearr_14864_15036 = state_14681__$1;
(statearr_14864_15036[(2)] = inst_14411);

(statearr_14864_15036[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (80))){
var inst_14502 = (state_14681[(22)]);
var inst_14501 = (state_14681[(2)]);
var inst_14502__$1 = fluree.db.util.async.throw_err(inst_14501);
var state_14681__$1 = (function (){var statearr_14865 = state_14681;
(statearr_14865[(22)] = inst_14502__$1);

return statearr_14865;
})();
if(cljs.core.truth_(inst_14502__$1)){
var statearr_14866_15037 = state_14681__$1;
(statearr_14866_15037[(1)] = (81));

} else {
var statearr_14867_15038 = state_14681__$1;
(statearr_14867_15038[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (37))){
var inst_14395 = (state_14681[(57)]);
var inst_14405 = (state_14681[(2)]);
var inst_14406 = fluree.db.util.core.pred_ident_QMARK_(inst_14395);
var state_14681__$1 = (function (){var statearr_14868 = state_14681;
(statearr_14868[(51)] = inst_14405);

return statearr_14868;
})();
if(inst_14406){
var statearr_14869_15039 = state_14681__$1;
(statearr_14869_15039[(1)] = (39));

} else {
var statearr_14870_15040 = state_14681__$1;
(statearr_14870_15040[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (63))){
var inst_14423 = (state_14681[(17)]);
var inst_14351 = (state_14681[(20)]);
var inst_14450 = (state_14681[(21)]);
var inst_14360 = (state_14681[(25)]);
var inst_14414 = (state_14681[(34)]);
var inst_14315 = (state_14681[(37)]);
var inst_14432 = (state_14681[(38)]);
var inst_14453 = (state_14681[(8)]);
var inst_14441 = (state_14681[(40)]);
var inst_14308 = (state_14681[(44)]);
var inst_14316 = (state_14681[(50)]);
var inst_14405 = (state_14681[(51)]);
var inst_14309 = (state_14681[(53)]);
var inst_14450__$1 = (state_14681[(2)]);
var inst_14451 = fluree.db.flake.__GT_Flake(inst_14351,inst_14423,inst_14405,inst_14308,inst_14309,inst_14441);
var inst_14452 = fluree.db.flake.__GT_Flake(inst_14360,inst_14432,inst_14414,inst_14315,inst_14316,inst_14450__$1);
var inst_14453__$1 = opts;
var inst_14455 = (inst_14453__$1 == null);
var inst_14456 = cljs.core.not(inst_14455);
var state_14681__$1 = (function (){var statearr_14871 = state_14681;
(statearr_14871[(21)] = inst_14450__$1);

(statearr_14871[(35)] = inst_14452);

(statearr_14871[(36)] = inst_14451);

(statearr_14871[(8)] = inst_14453__$1);

return statearr_14871;
})();
if(inst_14456){
var statearr_14872_15041 = state_14681__$1;
(statearr_14872_15041[(1)] = (67));

} else {
var statearr_14873_15042 = state_14681__$1;
(statearr_14873_15042[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (94))){
var inst_14396 = (state_14681[(32)]);
var inst_14535 = (state_14681[(2)]);
var state_14681__$1 = (function (){var statearr_14874 = state_14681;
(statearr_14874[(62)] = inst_14535);

return statearr_14874;
})();
if(cljs.core.truth_(inst_14396)){
var statearr_14875_15043 = state_14681__$1;
(statearr_14875_15043[(1)] = (95));

} else {
var statearr_14876_15044 = state_14681__$1;
(statearr_14876_15044[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (8))){
var inst_14334 = (state_14681[(2)]);
var state_14681__$1 = state_14681;
if(cljs.core.truth_(inst_14334)){
var statearr_14877_15045 = state_14681__$1;
(statearr_14877_15045[(1)] = (12));

} else {
var statearr_14878_15046 = state_14681__$1;
(statearr_14878_15046[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (49))){
var inst_14414 = (state_14681[(34)]);
var state_14681__$1 = state_14681;
var statearr_14879_15047 = state_14681__$1;
(statearr_14879_15047[(2)] = inst_14414);

(statearr_14879_15047[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14682 === (84))){
var inst_14505 = (state_14681[(29)]);
var inst_14452 = (state_14681[(35)]);
var inst_14451 = (state_14681[(36)]);
var inst_14514 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_14505);
var inst_14515 = fluree.db.flake.subrange(inst_14514,start_test,inst_14451,end_test,inst_14452);
var inst_14517 = fluree.db.query.range.value_with_nil_pred(idx,inst_14451,inst_14452);
var state_14681__$1 = (function (){var statearr_14880 = state_14681;
(statearr_14880[(31)] = inst_14515);

return statearr_14880;
})();
if(inst_14517){
var statearr_14881_15048 = state_14681__$1;
(statearr_14881_15048[(1)] = (86));

} else {
var statearr_14882_15049 = state_14681__$1;
(statearr_14882_15049[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2879__auto__ = null;
var fluree$db$query$range$state_machine__2879__auto____0 = (function (){
var statearr_14883 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14883[(0)] = fluree$db$query$range$state_machine__2879__auto__);

(statearr_14883[(1)] = (1));

return statearr_14883;
});
var fluree$db$query$range$state_machine__2879__auto____1 = (function (state_14681){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_14681);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e14884){var ex__2882__auto__ = e14884;
var statearr_14885_15050 = state_14681;
(statearr_14885_15050[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_14681[(4)]))){
var statearr_14886_15051 = state_14681;
(statearr_14886_15051[(1)] = cljs.core.first((state_14681[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15052 = state_14681;
state_14681 = G__15052;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2879__auto__ = function(state_14681){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2879__auto____1.call(this,state_14681);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2879__auto____0;
fluree$db$query$range$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2879__auto____1;
return fluree$db$query$range$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_14887 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_14887[(6)] = c__2901__auto__);

return statearr_14887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_15108){
var state_val_15109 = (state_15108[(1)]);
if((state_val_15109 === (7))){
var inst_15082 = (state_15108[(7)]);
var inst_15072 = (state_15108[(8)]);
var inst_15080 = fluree.db.flake.Flake__GT_parts(inst_15072);
var inst_15081 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15080,(0),null);
var inst_15082__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15080,(1),null);
var inst_15083 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15080,(2),null);
var inst_15084 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15080,(3),null);
var inst_15085 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15080,(4),null);
var inst_15086 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15080,(5),null);
var inst_15087 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_15083,inst_15082__$1);
var state_15108__$1 = (function (){var statearr_15110 = state_15108;
(statearr_15110[(7)] = inst_15082__$1);

(statearr_15110[(9)] = inst_15086);

(statearr_15110[(10)] = inst_15084);

(statearr_15110[(11)] = inst_15081);

(statearr_15110[(12)] = inst_15085);

return statearr_15110;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15108__$1,(10),inst_15087);
} else {
if((state_val_15109 === (1))){
var inst_15060 = flakes;
var inst_15061 = cljs.core.seq(inst_15060);
var inst_15062 = cljs.core.first(inst_15061);
var inst_15063 = cljs.core.next(inst_15061);
var inst_15064 = cljs.core.PersistentVector.EMPTY;
var inst_15065 = inst_15060;
var inst_15066 = inst_15064;
var state_15108__$1 = (function (){var statearr_15111 = state_15108;
(statearr_15111[(13)] = inst_15062);

(statearr_15111[(14)] = inst_15063);

(statearr_15111[(15)] = inst_15065);

(statearr_15111[(16)] = inst_15066);

return statearr_15111;
})();
var statearr_15112_15130 = state_15108__$1;
(statearr_15112_15130[(2)] = null);

(statearr_15112_15130[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15109 === (4))){
var inst_15072 = (state_15108[(8)]);
var inst_15075 = fluree.db.query.range.is_tag_flake_QMARK_(inst_15072);
var state_15108__$1 = state_15108;
if(inst_15075){
var statearr_15113_15131 = state_15108__$1;
(statearr_15113_15131[(1)] = (7));

} else {
var statearr_15114_15132 = state_15108__$1;
(statearr_15114_15132[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15109 === (6))){
var inst_15104 = (state_15108[(2)]);
var state_15108__$1 = state_15108;
var statearr_15115_15133 = state_15108__$1;
(statearr_15115_15133[(2)] = inst_15104);

(statearr_15115_15133[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15109 === (3))){
var inst_15106 = (state_15108[(2)]);
var state_15108__$1 = state_15108;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15108__$1,inst_15106);
} else {
if((state_val_15109 === (2))){
var inst_15072 = (state_15108[(8)]);
var inst_15065 = (state_15108[(15)]);
var inst_15071 = cljs.core.seq(inst_15065);
var inst_15072__$1 = cljs.core.first(inst_15071);
var inst_15073 = cljs.core.next(inst_15071);
var state_15108__$1 = (function (){var statearr_15116 = state_15108;
(statearr_15116[(8)] = inst_15072__$1);

(statearr_15116[(17)] = inst_15073);

return statearr_15116;
})();
if(cljs.core.truth_(inst_15072__$1)){
var statearr_15117_15134 = state_15108__$1;
(statearr_15117_15134[(1)] = (4));

} else {
var statearr_15118_15135 = state_15108__$1;
(statearr_15118_15135[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15109 === (9))){
var inst_15101 = (state_15108[(2)]);
var state_15108__$1 = state_15108;
var statearr_15119_15136 = state_15108__$1;
(statearr_15119_15136[(2)] = inst_15101);

(statearr_15119_15136[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15109 === (5))){
var inst_15066 = (state_15108[(16)]);
var state_15108__$1 = state_15108;
var statearr_15120_15137 = state_15108__$1;
(statearr_15120_15137[(2)] = inst_15066);

(statearr_15120_15137[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15109 === (10))){
var inst_15082 = (state_15108[(7)]);
var inst_15086 = (state_15108[(9)]);
var inst_15073 = (state_15108[(17)]);
var inst_15084 = (state_15108[(10)]);
var inst_15066 = (state_15108[(16)]);
var inst_15081 = (state_15108[(11)]);
var inst_15085 = (state_15108[(12)]);
var inst_15089 = (state_15108[(2)]);
var inst_15090 = fluree.db.util.async.throw_err(inst_15089);
var inst_15091 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15092 = [inst_15081,inst_15082,inst_15090,inst_15084,inst_15085,inst_15086];
var inst_15093 = (new cljs.core.PersistentVector(null,6,(5),inst_15091,inst_15092,null));
var inst_15094 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_15093);
var inst_15095 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_15066,inst_15094);
var inst_15065 = inst_15073;
var inst_15066__$1 = inst_15095;
var state_15108__$1 = (function (){var statearr_15121 = state_15108;
(statearr_15121[(15)] = inst_15065);

(statearr_15121[(16)] = inst_15066__$1);

return statearr_15121;
})();
var statearr_15122_15138 = state_15108__$1;
(statearr_15122_15138[(2)] = null);

(statearr_15122_15138[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15109 === (8))){
var inst_15072 = (state_15108[(8)]);
var inst_15073 = (state_15108[(17)]);
var inst_15066 = (state_15108[(16)]);
var inst_15098 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_15066,inst_15072);
var inst_15065 = inst_15073;
var inst_15066__$1 = inst_15098;
var state_15108__$1 = (function (){var statearr_15123 = state_15108;
(statearr_15123[(15)] = inst_15065);

(statearr_15123[(16)] = inst_15066__$1);

return statearr_15123;
})();
var statearr_15124_15139 = state_15108__$1;
(statearr_15124_15139[(2)] = null);

(statearr_15124_15139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto____0 = (function (){
var statearr_15125 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15125[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto__);

(statearr_15125[(1)] = (1));

return statearr_15125;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto____1 = (function (state_15108){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_15108);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e15126){var ex__2882__auto__ = e15126;
var statearr_15127_15140 = state_15108;
(statearr_15127_15140[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_15108[(4)]))){
var statearr_15128_15141 = state_15108;
(statearr_15128_15141[(1)] = cljs.core.first((state_15108[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15142 = state_15108;
state_15108 = G__15142;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto__ = function(state_15108){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto____1.call(this,state_15108);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_15129 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_15129[(6)] = c__2901__auto__);

return statearr_15129;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__15144 = arguments.length;
switch (G__15144) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_15295){
var state_val_15296 = (state_15295[(1)]);
if((state_val_15296 === (62))){
var inst_15282 = (state_15295[(7)]);
var state_15295__$1 = state_15295;
var statearr_15297_15386 = state_15295__$1;
(statearr_15297_15386[(2)] = inst_15282);

(statearr_15297_15386[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (7))){
var state_15295__$1 = state_15295;
var statearr_15298_15387 = state_15295__$1;
(statearr_15298_15387[(2)] = false);

(statearr_15298_15387[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (59))){
var inst_15274 = (state_15295[(2)]);
var state_15295__$1 = state_15295;
var statearr_15299_15388 = state_15295__$1;
(statearr_15299_15388[(2)] = inst_15274);

(statearr_15299_15388[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (20))){
var state_15295__$1 = state_15295;
var statearr_15300_15389 = state_15295__$1;
(statearr_15300_15389[(2)] = null);

(statearr_15300_15389[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (58))){
var state_15295__$1 = state_15295;
var statearr_15301_15390 = state_15295__$1;
(statearr_15301_15390[(2)] = null);

(statearr_15301_15390[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (60))){
var inst_15270 = (state_15295[(2)]);
var inst_15271 = fluree.db.util.async.throw_err(inst_15270);
var state_15295__$1 = state_15295;
var statearr_15302_15391 = state_15295__$1;
(statearr_15302_15391[(2)] = inst_15271);

(statearr_15302_15391[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (27))){
var inst_15195 = (state_15295[(8)]);
var inst_15206 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_15195);
var state_15295__$1 = state_15295;
if(inst_15206){
var statearr_15303_15392 = state_15295__$1;
(statearr_15303_15392[(1)] = (30));

} else {
var statearr_15304_15393 = state_15295__$1;
(statearr_15304_15393[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (1))){
var state_15295__$1 = state_15295;
var statearr_15305_15394 = state_15295__$1;
(statearr_15305_15394[(2)] = null);

(statearr_15305_15394[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (24))){
var inst_15156 = (state_15295[(9)]);
var state_15295__$1 = state_15295;
if(cljs.core.truth_(inst_15156)){
var statearr_15306_15395 = state_15295__$1;
(statearr_15306_15395[(1)] = (27));

} else {
var statearr_15307_15396 = state_15295__$1;
(statearr_15307_15396[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (55))){
var inst_15276 = (state_15295[(2)]);
var state_15295__$1 = state_15295;
var statearr_15308_15397 = state_15295__$1;
(statearr_15308_15397[(2)] = inst_15276);

(statearr_15308_15397[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (39))){
var inst_15226 = (state_15295[(2)]);
var inst_15227 = fluree.db.util.async.throw_err(inst_15226);
var state_15295__$1 = state_15295;
var statearr_15309_15398 = state_15295__$1;
(statearr_15309_15398[(2)] = inst_15227);

(statearr_15309_15398[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (46))){
var inst_15239 = (state_15295[(10)]);
var inst_15239__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_15295__$1 = (function (){var statearr_15310 = state_15295;
(statearr_15310[(10)] = inst_15239__$1);

return statearr_15310;
})();
if(cljs.core.truth_(inst_15239__$1)){
var statearr_15311_15399 = state_15295__$1;
(statearr_15311_15399[(1)] = (49));

} else {
var statearr_15312_15400 = state_15295__$1;
(statearr_15312_15400[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (4))){
var inst_15145 = (state_15295[(2)]);
var state_15295__$1 = state_15295;
var statearr_15313_15401 = state_15295__$1;
(statearr_15313_15401[(2)] = inst_15145);

(statearr_15313_15401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (54))){
var inst_15195 = (state_15295[(8)]);
var state_15295__$1 = state_15295;
if(cljs.core.truth_(inst_15195)){
var statearr_15314_15402 = state_15295__$1;
(statearr_15314_15402[(1)] = (57));

} else {
var statearr_15315_15403 = state_15295__$1;
(statearr_15315_15403[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (15))){
var inst_15157 = (state_15295[(11)]);
var inst_15176 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_15157);
var state_15295__$1 = state_15295;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15295__$1,(18),inst_15176);
} else {
if((state_val_15296 === (48))){
var inst_15278 = (state_15295[(2)]);
var state_15295__$1 = state_15295;
var statearr_15316_15404 = state_15295__$1;
(statearr_15316_15404[(2)] = inst_15278);

(statearr_15316_15404[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (50))){
var inst_15165 = (state_15295[(12)]);
var inst_15195 = (state_15295[(8)]);
var inst_15154 = (state_15295[(13)]);
var inst_15158 = (state_15295[(14)]);
var inst_15155 = (state_15295[(15)]);
var inst_15156 = (state_15295[(9)]);
var inst_15159 = (state_15295[(16)]);
var inst_15239 = (state_15295[(10)]);
var inst_15170 = (state_15295[(17)]);
var inst_15243 = (function (){var t = inst_15158;
var temp__5733__auto__ = inst_15239;
var p = inst_15156;
var idx_predicate_QMARK_ = inst_15159;
var vec__15151 = inst_15154;
var o = inst_15195;
var tag_predicate_QMARK_ = inst_15165;
var s = inst_15155;
var o_coerce_QMARK_ = inst_15170;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_15295__$1 = state_15295;
var statearr_15317_15405 = state_15295__$1;
(statearr_15317_15405[(2)] = inst_15243);

(statearr_15317_15405[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (21))){
var inst_15191 = (state_15295[(2)]);
var state_15295__$1 = state_15295;
var statearr_15318_15406 = state_15295__$1;
(statearr_15318_15406[(2)] = inst_15191);

(statearr_15318_15406[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (31))){
var state_15295__$1 = state_15295;
var statearr_15319_15407 = state_15295__$1;
(statearr_15319_15407[(2)] = false);

(statearr_15319_15407[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (32))){
var inst_15216 = (state_15295[(2)]);
var state_15295__$1 = state_15295;
var statearr_15320_15408 = state_15295__$1;
(statearr_15320_15408[(2)] = inst_15216);

(statearr_15320_15408[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (40))){
var inst_15159 = (state_15295[(16)]);
var inst_15230 = cljs.core.not(inst_15159);
var state_15295__$1 = state_15295;
if(inst_15230){
var statearr_15321_15409 = state_15295__$1;
(statearr_15321_15409[(1)] = (43));

} else {
var statearr_15322_15410 = state_15295__$1;
(statearr_15322_15410[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (56))){
var inst_15261 = (state_15295[(2)]);
var inst_15262 = fluree.db.util.async.throw_err(inst_15261);
var state_15295__$1 = state_15295;
var statearr_15323_15411 = state_15295__$1;
(statearr_15323_15411[(2)] = inst_15262);

(statearr_15323_15411[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (33))){
var inst_15195 = (state_15295[(8)]);
var inst_15209 = cljs.core.fn_QMARK_(inst_15195);
var inst_15210 = (!(inst_15209));
var state_15295__$1 = state_15295;
var statearr_15324_15412 = state_15295__$1;
(statearr_15324_15412[(2)] = inst_15210);

(statearr_15324_15412[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (13))){
var inst_15157 = (state_15295[(11)]);
var inst_15174 = fluree.db.query.range.tag_string_QMARK_(inst_15157);
var state_15295__$1 = state_15295;
if(cljs.core.truth_(inst_15174)){
var statearr_15325_15413 = state_15295__$1;
(statearr_15325_15413[(1)] = (15));

} else {
var statearr_15326_15414 = state_15295__$1;
(statearr_15326_15414[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (22))){
var inst_15187 = (state_15295[(2)]);
var inst_15188 = fluree.db.util.async.throw_err(inst_15187);
var state_15295__$1 = state_15295;
var statearr_15327_15415 = state_15295__$1;
(statearr_15327_15415[(2)] = inst_15188);

(statearr_15327_15415[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (36))){
var inst_15195 = (state_15295[(8)]);
var inst_15158 = (state_15295[(14)]);
var inst_15155 = (state_15295[(15)]);
var inst_15156 = (state_15295[(9)]);
var inst_15221 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15222 = [inst_15156,inst_15195,inst_15155,inst_15158];
var inst_15223 = (new cljs.core.PersistentVector(null,4,(5),inst_15221,inst_15222,null));
var inst_15224 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_15223,opts);
var state_15295__$1 = state_15295;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15295__$1,(39),inst_15224);
} else {
if((state_val_15296 === (41))){
var inst_15156 = (state_15295[(9)]);
var state_15295__$1 = state_15295;
var statearr_15328_15416 = state_15295__$1;
(statearr_15328_15416[(2)] = inst_15156);

(statearr_15328_15416[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (43))){
var inst_15195 = (state_15295[(8)]);
var state_15295__$1 = state_15295;
var statearr_15329_15417 = state_15295__$1;
(statearr_15329_15417[(2)] = inst_15195);

(statearr_15329_15417[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (61))){
var inst_15282 = (state_15295[(7)]);
var inst_15284 = fluree.db.query.range.coerce_tag_flakes(db,inst_15282);
var state_15295__$1 = state_15295;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15295__$1,(64),inst_15284);
} else {
if((state_val_15296 === (29))){
var inst_15219 = (state_15295[(2)]);
var state_15295__$1 = state_15295;
if(cljs.core.truth_(inst_15219)){
var statearr_15330_15418 = state_15295__$1;
(statearr_15330_15418[(1)] = (36));

} else {
var statearr_15331_15419 = state_15295__$1;
(statearr_15331_15419[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (44))){
var state_15295__$1 = state_15295;
var statearr_15332_15420 = state_15295__$1;
(statearr_15332_15420[(2)] = false);

(statearr_15332_15420[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (6))){
var inst_15156 = (state_15295[(9)]);
var inst_15161 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"type","type",1174270348),inst_15156);
var inst_15162 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_15161);
var state_15295__$1 = state_15295;
var statearr_15333_15421 = state_15295__$1;
(statearr_15333_15421[(2)] = inst_15162);

(statearr_15333_15421[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (28))){
var inst_15156 = (state_15295[(9)]);
var state_15295__$1 = state_15295;
var statearr_15334_15422 = state_15295__$1;
(statearr_15334_15422[(2)] = inst_15156);

(statearr_15334_15422[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (64))){
var inst_15286 = (state_15295[(2)]);
var inst_15287 = fluree.db.util.async.throw_err(inst_15286);
var state_15295__$1 = state_15295;
var statearr_15335_15423 = state_15295__$1;
(statearr_15335_15423[(2)] = inst_15287);

(statearr_15335_15423[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (51))){
var inst_15158 = (state_15295[(14)]);
var inst_15155 = (state_15295[(15)]);
var inst_15156 = (state_15295[(9)]);
var inst_15245 = (state_15295[(2)]);
var inst_15246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15247 = [inst_15156,inst_15155,null,inst_15158];
var inst_15248 = (new cljs.core.PersistentVector(null,4,(5),inst_15246,inst_15247,null));
var inst_15249 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_15245);
var inst_15250 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15248,inst_15249);
var state_15295__$1 = state_15295;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15295__$1,(52),inst_15250);
} else {
if((state_val_15296 === (25))){
var inst_15165 = (state_15295[(12)]);
var inst_15282 = (state_15295[(2)]);
var state_15295__$1 = (function (){var statearr_15336 = state_15295;
(statearr_15336[(7)] = inst_15282);

return statearr_15336;
})();
if(cljs.core.truth_(inst_15165)){
var statearr_15337_15424 = state_15295__$1;
(statearr_15337_15424[(1)] = (61));

} else {
var statearr_15338_15425 = state_15295__$1;
(statearr_15338_15425[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (34))){
var inst_15159 = (state_15295[(16)]);
var state_15295__$1 = state_15295;
var statearr_15339_15426 = state_15295__$1;
(statearr_15339_15426[(2)] = inst_15159);

(statearr_15339_15426[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (17))){
var inst_15193 = (state_15295[(2)]);
var state_15295__$1 = state_15295;
var statearr_15340_15427 = state_15295__$1;
(statearr_15340_15427[(2)] = inst_15193);

(statearr_15340_15427[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (3))){
var inst_15293 = (state_15295[(2)]);
var state_15295__$1 = state_15295;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15295__$1,inst_15293);
} else {
if((state_val_15296 === (12))){
var inst_15157 = (state_15295[(11)]);
var state_15295__$1 = state_15295;
var statearr_15341_15428 = state_15295__$1;
(statearr_15341_15428[(2)] = inst_15157);

(statearr_15341_15428[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (2))){
var inst_15154 = (state_15295[(13)]);
var inst_15156 = (state_15295[(9)]);
var _ = (function (){var statearr_15342 = state_15295;
(statearr_15342[(4)] = cljs.core.cons((5),(state_15295[(4)])));

return statearr_15342;
})();
var inst_15154__$1 = fparts;
var inst_15155 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15154__$1,(0),null);
var inst_15156__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15154__$1,(1),null);
var inst_15157 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15154__$1,(2),null);
var inst_15158 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15154__$1,(3),null);
var inst_15159 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_15156__$1);
var state_15295__$1 = (function (){var statearr_15343 = state_15295;
(statearr_15343[(13)] = inst_15154__$1);

(statearr_15343[(11)] = inst_15157);

(statearr_15343[(14)] = inst_15158);

(statearr_15343[(15)] = inst_15155);

(statearr_15343[(9)] = inst_15156__$1);

(statearr_15343[(16)] = inst_15159);

return statearr_15343;
})();
if(cljs.core.truth_(inst_15156__$1)){
var statearr_15344_15429 = state_15295__$1;
(statearr_15344_15429[(1)] = (6));

} else {
var statearr_15345_15430 = state_15295__$1;
(statearr_15345_15430[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (23))){
var inst_15195 = (state_15295[(8)]);
var inst_15158 = (state_15295[(14)]);
var inst_15155 = (state_15295[(15)]);
var inst_15156 = (state_15295[(9)]);
var inst_15197 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15198 = [inst_15155,inst_15156,inst_15195,inst_15158];
var inst_15199 = (new cljs.core.PersistentVector(null,4,(5),inst_15197,inst_15198,null));
var inst_15200 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15199,opts);
var state_15295__$1 = state_15295;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15295__$1,(26),inst_15200);
} else {
if((state_val_15296 === (47))){
var inst_15156 = (state_15295[(9)]);
var state_15295__$1 = state_15295;
if(cljs.core.truth_(inst_15156)){
var statearr_15346_15431 = state_15295__$1;
(statearr_15346_15431[(1)] = (53));

} else {
var statearr_15347_15432 = state_15295__$1;
(statearr_15347_15432[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (35))){
var inst_15213 = (state_15295[(2)]);
var state_15295__$1 = state_15295;
var statearr_15348_15433 = state_15295__$1;
(statearr_15348_15433[(2)] = inst_15213);

(statearr_15348_15433[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (19))){
var inst_15157 = (state_15295[(11)]);
var inst_15156 = (state_15295[(9)]);
var inst_15183 = fluree.db.dbproto._p_prop(db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15156);
var inst_15184 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15183),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15157)].join('');
var inst_15185 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_15184);
var state_15295__$1 = state_15295;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15295__$1,(22),inst_15185);
} else {
if((state_val_15296 === (57))){
var inst_15195 = (state_15295[(8)]);
var inst_15158 = (state_15295[(14)]);
var inst_15155 = (state_15295[(15)]);
var inst_15156 = (state_15295[(9)]);
var inst_15265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15266 = [inst_15195,inst_15156,inst_15155,inst_15158];
var inst_15267 = (new cljs.core.PersistentVector(null,4,(5),inst_15265,inst_15266,null));
var inst_15268 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_15267,opts);
var state_15295__$1 = state_15295;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15295__$1,(60),inst_15268);
} else {
if((state_val_15296 === (11))){
var inst_15170 = (state_15295[(17)]);
var inst_15170__$1 = (state_15295[(2)]);
var inst_15171 = cljs.core.not(inst_15170__$1);
var state_15295__$1 = (function (){var statearr_15350 = state_15295;
(statearr_15350[(17)] = inst_15170__$1);

return statearr_15350;
})();
if(inst_15171){
var statearr_15351_15434 = state_15295__$1;
(statearr_15351_15434[(1)] = (12));

} else {
var statearr_15352_15435 = state_15295__$1;
(statearr_15352_15435[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (9))){
var inst_15157 = (state_15295[(11)]);
var inst_15167 = typeof inst_15157 === 'string';
var state_15295__$1 = state_15295;
var statearr_15353_15436 = state_15295__$1;
(statearr_15353_15436[(2)] = inst_15167);

(statearr_15353_15436[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (5))){
var _ = (function (){var statearr_15354 = state_15295;
(statearr_15354[(4)] = cljs.core.rest((state_15295[(4)])));

return statearr_15354;
})();
var state_15295__$1 = state_15295;
var ex15349 = (state_15295__$1[(2)]);
var statearr_15355_15437 = state_15295__$1;
(statearr_15355_15437[(5)] = ex15349);


if((ex15349 instanceof Error)){
var statearr_15356_15438 = state_15295__$1;
(statearr_15356_15438[(1)] = (4));

(statearr_15356_15438[(5)] = null);

} else {
throw ex15349;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (14))){
var inst_15155 = (state_15295[(15)]);
var inst_15195 = (state_15295[(2)]);
var state_15295__$1 = (function (){var statearr_15357 = state_15295;
(statearr_15357[(8)] = inst_15195);

return statearr_15357;
})();
if(cljs.core.truth_(inst_15155)){
var statearr_15358_15439 = state_15295__$1;
(statearr_15358_15439[(1)] = (23));

} else {
var statearr_15359_15440 = state_15295__$1;
(statearr_15359_15440[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (45))){
var inst_15234 = (state_15295[(2)]);
var state_15295__$1 = state_15295;
var statearr_15360_15441 = state_15295__$1;
(statearr_15360_15441[(2)] = inst_15234);

(statearr_15360_15441[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (53))){
var inst_15195 = (state_15295[(8)]);
var inst_15158 = (state_15295[(14)]);
var inst_15155 = (state_15295[(15)]);
var inst_15156 = (state_15295[(9)]);
var inst_15256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15257 = [inst_15156,inst_15155,inst_15195,inst_15158];
var inst_15258 = (new cljs.core.PersistentVector(null,4,(5),inst_15256,inst_15257,null));
var inst_15259 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15258,opts);
var state_15295__$1 = state_15295;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15295__$1,(56),inst_15259);
} else {
if((state_val_15296 === (26))){
var inst_15202 = (state_15295[(2)]);
var inst_15203 = fluree.db.util.async.throw_err(inst_15202);
var state_15295__$1 = state_15295;
var statearr_15361_15442 = state_15295__$1;
(statearr_15361_15442[(2)] = inst_15203);

(statearr_15361_15442[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (16))){
var inst_15157 = (state_15295[(11)]);
var inst_15181 = typeof inst_15157 === 'string';
var state_15295__$1 = state_15295;
if(cljs.core.truth_(inst_15181)){
var statearr_15362_15443 = state_15295__$1;
(statearr_15362_15443[(1)] = (19));

} else {
var statearr_15363_15444 = state_15295__$1;
(statearr_15363_15444[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (38))){
var inst_15280 = (state_15295[(2)]);
var state_15295__$1 = state_15295;
var statearr_15364_15445 = state_15295__$1;
(statearr_15364_15445[(2)] = inst_15280);

(statearr_15364_15445[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (30))){
var inst_15159 = (state_15295[(16)]);
var state_15295__$1 = state_15295;
if(cljs.core.truth_(inst_15159)){
var statearr_15365_15446 = state_15295__$1;
(statearr_15365_15446[(1)] = (33));

} else {
var statearr_15366_15447 = state_15295__$1;
(statearr_15366_15447[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (10))){
var inst_15165 = (state_15295[(12)]);
var state_15295__$1 = state_15295;
var statearr_15367_15448 = state_15295__$1;
(statearr_15367_15448[(2)] = inst_15165);

(statearr_15367_15448[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (18))){
var inst_15178 = (state_15295[(2)]);
var inst_15179 = fluree.db.util.async.throw_err(inst_15178);
var state_15295__$1 = state_15295;
var statearr_15368_15449 = state_15295__$1;
(statearr_15368_15449[(2)] = inst_15179);

(statearr_15368_15449[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (52))){
var inst_15252 = (state_15295[(2)]);
var inst_15253 = fluree.db.util.async.throw_err(inst_15252);
var state_15295__$1 = state_15295;
var statearr_15369_15450 = state_15295__$1;
(statearr_15369_15450[(2)] = inst_15253);

(statearr_15369_15450[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (42))){
var inst_15237 = (state_15295[(2)]);
var state_15295__$1 = state_15295;
if(cljs.core.truth_(inst_15237)){
var statearr_15370_15451 = state_15295__$1;
(statearr_15370_15451[(1)] = (46));

} else {
var statearr_15371_15452 = state_15295__$1;
(statearr_15371_15452[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (37))){
var inst_15156 = (state_15295[(9)]);
var state_15295__$1 = state_15295;
if(cljs.core.truth_(inst_15156)){
var statearr_15372_15453 = state_15295__$1;
(statearr_15372_15453[(1)] = (40));

} else {
var statearr_15373_15454 = state_15295__$1;
(statearr_15373_15454[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (63))){
var inst_15290 = (state_15295[(2)]);
var _ = (function (){var statearr_15374 = state_15295;
(statearr_15374[(4)] = cljs.core.rest((state_15295[(4)])));

return statearr_15374;
})();
var state_15295__$1 = state_15295;
var statearr_15375_15455 = state_15295__$1;
(statearr_15375_15455[(2)] = inst_15290);

(statearr_15375_15455[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (8))){
var inst_15165 = (state_15295[(12)]);
var inst_15165__$1 = (state_15295[(2)]);
var state_15295__$1 = (function (){var statearr_15376 = state_15295;
(statearr_15376[(12)] = inst_15165__$1);

return statearr_15376;
})();
if(cljs.core.truth_(inst_15165__$1)){
var statearr_15377_15456 = state_15295__$1;
(statearr_15377_15456[(1)] = (9));

} else {
var statearr_15378_15457 = state_15295__$1;
(statearr_15378_15457[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15296 === (49))){
var inst_15165 = (state_15295[(12)]);
var inst_15195 = (state_15295[(8)]);
var inst_15154 = (state_15295[(13)]);
var inst_15158 = (state_15295[(14)]);
var inst_15155 = (state_15295[(15)]);
var inst_15156 = (state_15295[(9)]);
var inst_15159 = (state_15295[(16)]);
var inst_15239 = (state_15295[(10)]);
var inst_15170 = (state_15295[(17)]);
var inst_15241 = (function (){var obj_fn = inst_15239;
var t = inst_15158;
var temp__5733__auto__ = inst_15239;
var p = inst_15156;
var idx_predicate_QMARK_ = inst_15159;
var vec__15151 = inst_15154;
var o = inst_15195;
var tag_predicate_QMARK_ = inst_15165;
var s = inst_15155;
var o_coerce_QMARK_ = inst_15170;
return (function (x){
var and__4115__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4115__auto__;
}
});
})();
var state_15295__$1 = state_15295;
var statearr_15379_15458 = state_15295__$1;
(statearr_15379_15458[(2)] = inst_15241);

(statearr_15379_15458[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2879__auto__ = null;
var fluree$db$query$range$state_machine__2879__auto____0 = (function (){
var statearr_15380 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15380[(0)] = fluree$db$query$range$state_machine__2879__auto__);

(statearr_15380[(1)] = (1));

return statearr_15380;
});
var fluree$db$query$range$state_machine__2879__auto____1 = (function (state_15295){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_15295);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e15381){var ex__2882__auto__ = e15381;
var statearr_15382_15459 = state_15295;
(statearr_15382_15459[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_15295[(4)]))){
var statearr_15383_15460 = state_15295;
(statearr_15383_15460[(1)] = cljs.core.first((state_15295[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15461 = state_15295;
state_15295 = G__15461;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2879__auto__ = function(state_15295){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2879__auto____1.call(this,state_15295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2879__auto____0;
fluree$db$query$range$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2879__auto____1;
return fluree$db$query$range$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_15384 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_15384[(6)] = c__2901__auto__);

return statearr_15384;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15463 = arguments.length;
switch (G__15463) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_15498){
var state_val_15499 = (state_15498[(1)]);
if((state_val_15499 === (7))){
var inst_15485 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_15486 = ["Invalid collection name: ",inst_15485].join('');
var inst_15487 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15488 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15489 = cljs.core.PersistentHashMap.fromArrays(inst_15487,inst_15488);
var inst_15490 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_15486,inst_15489);
var inst_15491 = (function(){throw inst_15490})();
var state_15498__$1 = state_15498;
var statearr_15500_15520 = state_15498__$1;
(statearr_15500_15520[(2)] = inst_15491);

(statearr_15500_15520[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15499 === (1))){
var state_15498__$1 = state_15498;
var statearr_15501_15521 = state_15498__$1;
(statearr_15501_15521[(2)] = null);

(statearr_15501_15521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15499 === (4))){
var inst_15464 = (state_15498[(2)]);
var state_15498__$1 = state_15498;
var statearr_15502_15522 = state_15498__$1;
(statearr_15502_15522[(2)] = inst_15464);

(statearr_15502_15522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15499 === (6))){
var inst_15470 = (state_15498[(7)]);
var inst_15472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15473 = fluree.db.flake.max_subject_id(inst_15470);
var inst_15474 = [inst_15473];
var inst_15475 = (new cljs.core.PersistentVector(null,1,(5),inst_15472,inst_15474,null));
var inst_15476 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15477 = fluree.db.flake.min_subject_id(inst_15470);
var inst_15478 = [inst_15477];
var inst_15479 = (new cljs.core.PersistentVector(null,1,(5),inst_15476,inst_15478,null));
var inst_15480 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15475,cljs.core._LT__EQ_,inst_15479,opts);
var state_15498__$1 = state_15498;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15498__$1,(9),inst_15480);
} else {
if((state_val_15499 === (3))){
var inst_15496 = (state_15498[(2)]);
var state_15498__$1 = state_15498;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15498__$1,inst_15496);
} else {
if((state_val_15499 === (2))){
var inst_15470 = (state_15498[(7)]);
var _ = (function (){var statearr_15504 = state_15498;
(statearr_15504[(4)] = cljs.core.cons((5),(state_15498[(4)])));

return statearr_15504;
})();
var inst_15470__$1 = fluree.db.dbproto._c_prop(db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_15498__$1 = (function (){var statearr_15505 = state_15498;
(statearr_15505[(7)] = inst_15470__$1);

return statearr_15505;
})();
if(cljs.core.truth_(inst_15470__$1)){
var statearr_15506_15523 = state_15498__$1;
(statearr_15506_15523[(1)] = (6));

} else {
var statearr_15507_15524 = state_15498__$1;
(statearr_15507_15524[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15499 === (9))){
var inst_15482 = (state_15498[(2)]);
var inst_15483 = fluree.db.util.async.throw_err(inst_15482);
var state_15498__$1 = state_15498;
var statearr_15508_15525 = state_15498__$1;
(statearr_15508_15525[(2)] = inst_15483);

(statearr_15508_15525[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15499 === (5))){
var _ = (function (){var statearr_15509 = state_15498;
(statearr_15509[(4)] = cljs.core.rest((state_15498[(4)])));

return statearr_15509;
})();
var state_15498__$1 = state_15498;
var ex15503 = (state_15498__$1[(2)]);
var statearr_15510_15526 = state_15498__$1;
(statearr_15510_15526[(5)] = ex15503);


var statearr_15511_15527 = state_15498__$1;
(statearr_15511_15527[(1)] = (4));

(statearr_15511_15527[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15499 === (8))){
var inst_15493 = (state_15498[(2)]);
var _ = (function (){var statearr_15512 = state_15498;
(statearr_15512[(4)] = cljs.core.rest((state_15498[(4)])));

return statearr_15512;
})();
var state_15498__$1 = state_15498;
var statearr_15513_15528 = state_15498__$1;
(statearr_15513_15528[(2)] = inst_15493);

(statearr_15513_15528[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2879__auto__ = null;
var fluree$db$query$range$state_machine__2879__auto____0 = (function (){
var statearr_15514 = [null,null,null,null,null,null,null,null];
(statearr_15514[(0)] = fluree$db$query$range$state_machine__2879__auto__);

(statearr_15514[(1)] = (1));

return statearr_15514;
});
var fluree$db$query$range$state_machine__2879__auto____1 = (function (state_15498){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_15498);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e15515){var ex__2882__auto__ = e15515;
var statearr_15516_15529 = state_15498;
(statearr_15516_15529[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_15498[(4)]))){
var statearr_15517_15530 = state_15498;
(statearr_15517_15530[(1)] = cljs.core.first((state_15498[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15531 = state_15498;
state_15498 = G__15531;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2879__auto__ = function(state_15498){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2879__auto____1.call(this,state_15498);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2879__auto____0;
fluree$db$query$range$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2879__auto____1;
return fluree$db$query$range$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_15518 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_15518[(6)] = c__2901__auto__);

return statearr_15518;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15535 = flakes;
var vec__15536 = G__15535;
var seq__15537 = cljs.core.seq(vec__15536);
var first__15538 = cljs.core.first(seq__15537);
var seq__15537__$1 = cljs.core.next(seq__15537);
var flake_SINGLEQUOTE_ = first__15538;
var r = seq__15537__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15535__$1 = G__15535;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15545 = G__15535__$1;
var seq__15546 = cljs.core.seq(vec__15545);
var first__15547 = cljs.core.first(seq__15546);
var seq__15546__$1 = cljs.core.next(seq__15546);
var flake_SINGLEQUOTE___$1 = first__15547;
var r__$1 = seq__15546__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e15549){var e = e15549;
return null;
}})();
var map__15548 = cmd_map;
var map__15548__$1 = (((((!((map__15548 == null))))?(((((map__15548.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15548.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15548):map__15548);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15548__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15548__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15548__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15548__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15548__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15548__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__15551 = r__$1;
var G__15552 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15535__$1 = G__15551;
result_STAR___$1 = G__15552;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__15561 = blocks;
var vec__15562 = G__15561;
var seq__15563 = cljs.core.seq(vec__15562);
var first__15564 = cljs.core.first(seq__15563);
var seq__15563__$1 = cljs.core.next(seq__15563);
var block_SINGLEQUOTE_ = first__15564;
var r = seq__15563__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15561__$1 = G__15561;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15570 = G__15561__$1;
var seq__15571 = cljs.core.seq(vec__15570);
var first__15572 = cljs.core.first(seq__15571);
var seq__15571__$1 = cljs.core.next(seq__15571);
var block_SINGLEQUOTE___$1 = first__15572;
var r__$1 = seq__15571__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__15573 = block_SINGLEQUOTE___$1;
var map__15573__$1 = (((((!((map__15573 == null))))?(((((map__15573.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15573.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__15573):map__15573);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15573__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15573__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15573__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some(((function (G__15561__$1,result_STAR___$1,map__15573,map__15573__$1,block,t,flakes,vec__15570,seq__15571,first__15572,seq__15571__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15561,vec__15562,seq__15563,first__15564,seq__15563__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15553_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15553_SHARP_.p,(2))){
return p1__15553_SHARP_.o;
} else {
return null;
}
});})(G__15561__$1,result_STAR___$1,map__15573,map__15573__$1,block,t,flakes,vec__15570,seq__15571,first__15572,seq__15571__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15561,vec__15562,seq__15563,first__15564,seq__15563__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__15561__$1,result_STAR___$1,map__15573,map__15573__$1,block,t,flakes,prev_hash,vec__15570,seq__15571,first__15572,seq__15571__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15561,vec__15562,seq__15563,first__15564,seq__15563__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15554_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15554_SHARP_.p,(1))){
return p1__15554_SHARP_.o;
} else {
return null;
}
});})(G__15561__$1,result_STAR___$1,map__15573,map__15573__$1,block,t,flakes,prev_hash,vec__15570,seq__15571,first__15572,seq__15571__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15561,vec__15562,seq__15563,first__15564,seq__15563__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__15561__$1,result_STAR___$1,map__15573,map__15573__$1,block,t,flakes,prev_hash,hash,vec__15570,seq__15571,first__15572,seq__15571__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15561,vec__15562,seq__15563,first__15564,seq__15563__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15555_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15555_SHARP_.p,(5))){
return p1__15555_SHARP_.o;
} else {
return null;
}
});})(G__15561__$1,result_STAR___$1,map__15573,map__15573__$1,block,t,flakes,prev_hash,hash,vec__15570,seq__15571,first__15572,seq__15571__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15561,vec__15562,seq__15563,first__15564,seq__15563__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__15561__$1,result_STAR___$1,map__15573,map__15573__$1,block,t,flakes,prev_hash,hash,instant,vec__15570,seq__15571,first__15572,seq__15571__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15561,vec__15562,seq__15563,first__15564,seq__15563__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15556_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15556_SHARP_.p,(7))){
return p1__15556_SHARP_.o;
} else {
return null;
}
});})(G__15561__$1,result_STAR___$1,map__15573,map__15573__$1,block,t,flakes,prev_hash,hash,instant,vec__15570,seq__15571,first__15572,seq__15571__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15561,vec__15562,seq__15563,first__15564,seq__15563__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__15561__$1,result_STAR___$1,map__15573,map__15573__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15570,seq__15571,first__15572,seq__15571__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15561,vec__15562,seq__15563,first__15564,seq__15563__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15557_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__15557_SHARP_.p,(106));
});})(G__15561__$1,result_STAR___$1,map__15573,map__15573__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15570,seq__15571,first__15572,seq__15571__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15561,vec__15562,seq__15563,first__15564,seq__15563__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__15575 = r__$1;
var G__15576 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__15561__$1 = G__15575;
result_STAR___$1 = G__15576;
continue;
}
break;
}
});
