// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.api.ledger');
goog.require('cljs.core');
goog.require('fluree.db.session');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.connection');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.time_travel');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.root_db = (function fluree$db$api$ledger$root_db(var_args){
var G__68633 = arguments.length;
switch (G__68633) {
case 2:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.root_db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var temp__5733__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5733__auto__)){
var block = temp__5733__auto__;
var pc = cljs.core.async.promise_chan.call(null);
var c__2901__auto___68672 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_68654){
var state_val_68655 = (state_68654[(1)]);
if((state_val_68655 === (1))){
var state_68654__$1 = state_68654;
var statearr_68656_68673 = state_68654__$1;
(statearr_68656_68673[(2)] = null);

(statearr_68656_68673[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68655 === (2))){
var _ = (function (){var statearr_68657 = state_68654;
(statearr_68657[(4)] = cljs.core.cons.call(null,(5),(state_68654[(4)])));

return statearr_68657;
})();
var inst_68640 = fluree.db.session.db.call(null,conn,ledger,null);
var state_68654__$1 = state_68654;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68654__$1,(7),inst_68640);
} else {
if((state_val_68655 === (3))){
var inst_68650 = (state_68654[(2)]);
var inst_68651 = cljs.core.async.put_BANG_.call(null,pc,inst_68650);
var inst_68652 = cljs.core.async.close_BANG_.call(null,pc);
var state_68654__$1 = (function (){var statearr_68659 = state_68654;
(statearr_68659[(7)] = inst_68651);

return statearr_68659;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68654__$1,inst_68652);
} else {
if((state_val_68655 === (4))){
var inst_68634 = (state_68654[(2)]);
var state_68654__$1 = state_68654;
var statearr_68660_68674 = state_68654__$1;
(statearr_68660_68674[(2)] = inst_68634);

(statearr_68660_68674[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68655 === (5))){
var _ = (function (){var statearr_68661 = state_68654;
(statearr_68661[(4)] = cljs.core.rest.call(null,(state_68654[(4)])));

return statearr_68661;
})();
var state_68654__$1 = state_68654;
var ex68658 = (state_68654__$1[(2)]);
var statearr_68662_68675 = state_68654__$1;
(statearr_68662_68675[(5)] = ex68658);


var statearr_68663_68676 = state_68654__$1;
(statearr_68663_68676[(1)] = (4));

(statearr_68663_68676[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68655 === (6))){
var inst_68646 = (state_68654[(2)]);
var inst_68647 = fluree.db.util.async.throw_err.call(null,inst_68646);
var _ = (function (){var statearr_68664 = state_68654;
(statearr_68664[(4)] = cljs.core.rest.call(null,(state_68654[(4)])));

return statearr_68664;
})();
var state_68654__$1 = state_68654;
var statearr_68665_68677 = state_68654__$1;
(statearr_68665_68677[(2)] = inst_68647);

(statearr_68665_68677[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68655 === (7))){
var inst_68642 = (state_68654[(2)]);
var inst_68643 = fluree.db.util.async.throw_err.call(null,inst_68642);
var inst_68644 = fluree.db.time_travel.as_of_block.call(null,inst_68643,block);
var state_68654__$1 = state_68654;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68654__$1,(6),inst_68644);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2879__auto__ = null;
var fluree$db$api$ledger$state_machine__2879__auto____0 = (function (){
var statearr_68666 = [null,null,null,null,null,null,null,null];
(statearr_68666[(0)] = fluree$db$api$ledger$state_machine__2879__auto__);

(statearr_68666[(1)] = (1));

return statearr_68666;
});
var fluree$db$api$ledger$state_machine__2879__auto____1 = (function (state_68654){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_68654);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e68667){var ex__2882__auto__ = e68667;
var statearr_68668_68678 = state_68654;
(statearr_68668_68678[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_68654[(4)]))){
var statearr_68669_68679 = state_68654;
(statearr_68669_68679[(1)] = cljs.core.first.call(null,(state_68654[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68680 = state_68654;
state_68654 = G__68680;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2879__auto__ = function(state_68654){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2879__auto____1.call(this,state_68654);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2879__auto____0;
fluree$db$api$ledger$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2879__auto____1;
return fluree$db$api$ledger$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_68670 = f__2902__auto__.call(null);
(statearr_68670[(6)] = c__2901__auto___68672);

return statearr_68670;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));


return pc;
} else {
return fluree.db.session.db.call(null,conn,ledger,null);
}
}));

(fluree.db.api.ledger.root_db.cljs$lang$maxFixedArity = 3);

/**
 * Resolves auth subject id from any identity value. Will
 *   throw an exception if it is unable to resolve to an established identity.
 *   Auth 0 is a special case. It:
 *   - Is short-hand to keeping 'local' root-level permissions. 'local' permissions
 *  may already be a restricted permissioned set of data, it simply is not further restricted.
 *   - Does not attempt to resolve to a subject ID (as it would error as '0' will not exist in the db)
 */
fluree.db.api.ledger.add_db_auth_sid = (function fluree$db$api$ledger$add_db_auth_sid(db,auth){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_68721){
var state_val_68722 = (state_68721[(1)]);
if((state_val_68722 === (7))){
var inst_68690 = cljs.core._EQ_.call(null,(0),auth);
var state_68721__$1 = state_68721;
if(inst_68690){
var statearr_68723_68754 = state_68721__$1;
(statearr_68723_68754[(1)] = (9));

} else {
var statearr_68724_68755 = state_68721__$1;
(statearr_68724_68755[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68722 === (1))){
var state_68721__$1 = state_68721;
var statearr_68725_68756 = state_68721__$1;
(statearr_68725_68756[(2)] = null);

(statearr_68725_68756[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68722 === (4))){
var inst_68681 = (state_68721[(2)]);
var state_68721__$1 = state_68721;
var statearr_68726_68757 = state_68721__$1;
(statearr_68726_68757[(2)] = inst_68681);

(statearr_68726_68757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68722 === (15))){
var inst_68698 = (state_68721[(7)]);
var inst_68697 = (state_68721[(2)]);
var inst_68698__$1 = fluree.db.util.async.throw_err.call(null,inst_68697);
var state_68721__$1 = (function (){var statearr_68727 = state_68721;
(statearr_68727[(7)] = inst_68698__$1);

return statearr_68727;
})();
if(cljs.core.truth_(inst_68698__$1)){
var statearr_68728_68758 = state_68721__$1;
(statearr_68728_68758[(1)] = (16));

} else {
var statearr_68729_68759 = state_68721__$1;
(statearr_68729_68759[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68722 === (13))){
var state_68721__$1 = state_68721;
var statearr_68730_68760 = state_68721__$1;
(statearr_68730_68760[(2)] = null);

(statearr_68730_68760[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68722 === (6))){
var state_68721__$1 = state_68721;
var statearr_68731_68761 = state_68721__$1;
(statearr_68731_68761[(2)] = db);

(statearr_68731_68761[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68722 === (17))){
var inst_68702 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_68703 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68704 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_68705 = cljs.core.PersistentHashMap.fromArrays(inst_68703,inst_68704);
var inst_68706 = cljs.core.ex_info.call(null,inst_68702,inst_68705);
var inst_68707 = (function(){throw inst_68706})();
var state_68721__$1 = state_68721;
var statearr_68732_68762 = state_68721__$1;
(statearr_68732_68762[(2)] = inst_68707);

(statearr_68732_68762[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68722 === (3))){
var inst_68719 = (state_68721[(2)]);
var state_68721__$1 = state_68721;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68721__$1,inst_68719);
} else {
if((state_val_68722 === (12))){
var inst_68695 = fluree.db.dbproto._subid.call(null,db,auth);
var state_68721__$1 = state_68721;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68721__$1,(15),inst_68695);
} else {
if((state_val_68722 === (2))){
var _ = (function (){var statearr_68733 = state_68721;
(statearr_68733[(4)] = cljs.core.cons.call(null,(5),(state_68721[(4)])));

return statearr_68733;
})();
var inst_68687 = cljs.core.not.call(null,auth);
var state_68721__$1 = state_68721;
if(inst_68687){
var statearr_68734_68763 = state_68721__$1;
(statearr_68734_68763[(1)] = (6));

} else {
var statearr_68735_68764 = state_68721__$1;
(statearr_68735_68764[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68722 === (11))){
var inst_68714 = (state_68721[(2)]);
var state_68721__$1 = state_68721;
var statearr_68737_68765 = state_68721__$1;
(statearr_68737_68765[(2)] = inst_68714);

(statearr_68737_68765[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68722 === (9))){
var inst_68692 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),(0));
var state_68721__$1 = state_68721;
var statearr_68738_68766 = state_68721__$1;
(statearr_68738_68766[(2)] = inst_68692);

(statearr_68738_68766[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68722 === (5))){
var _ = (function (){var statearr_68739 = state_68721;
(statearr_68739[(4)] = cljs.core.rest.call(null,(state_68721[(4)])));

return statearr_68739;
})();
var state_68721__$1 = state_68721;
var ex68736 = (state_68721__$1[(2)]);
var statearr_68740_68767 = state_68721__$1;
(statearr_68740_68767[(5)] = ex68736);


if((ex68736 instanceof Error)){
var statearr_68741_68768 = state_68721__$1;
(statearr_68741_68768[(1)] = (4));

(statearr_68741_68768[(5)] = null);

} else {
throw ex68736;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68722 === (14))){
var inst_68712 = (state_68721[(2)]);
var state_68721__$1 = state_68721;
var statearr_68742_68769 = state_68721__$1;
(statearr_68742_68769[(2)] = inst_68712);

(statearr_68742_68769[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68722 === (16))){
var inst_68698 = (state_68721[(7)]);
var inst_68700 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_68698);
var state_68721__$1 = state_68721;
var statearr_68743_68770 = state_68721__$1;
(statearr_68743_68770[(2)] = inst_68700);

(statearr_68743_68770[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68722 === (10))){
var state_68721__$1 = state_68721;
var statearr_68744_68771 = state_68721__$1;
(statearr_68744_68771[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68722 === (18))){
var inst_68709 = (state_68721[(2)]);
var state_68721__$1 = state_68721;
var statearr_68746_68772 = state_68721__$1;
(statearr_68746_68772[(2)] = inst_68709);

(statearr_68746_68772[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68722 === (8))){
var inst_68716 = (state_68721[(2)]);
var _ = (function (){var statearr_68747 = state_68721;
(statearr_68747[(4)] = cljs.core.rest.call(null,(state_68721[(4)])));

return statearr_68747;
})();
var state_68721__$1 = state_68721;
var statearr_68748_68773 = state_68721__$1;
(statearr_68748_68773[(2)] = inst_68716);

(statearr_68748_68773[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto__ = null;
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto____0 = (function (){
var statearr_68749 = [null,null,null,null,null,null,null,null];
(statearr_68749[(0)] = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto__);

(statearr_68749[(1)] = (1));

return statearr_68749;
});
var fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto____1 = (function (state_68721){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_68721);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e68750){var ex__2882__auto__ = e68750;
var statearr_68751_68774 = state_68721;
(statearr_68751_68774[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_68721[(4)]))){
var statearr_68752_68775 = state_68721;
(statearr_68752_68775[(1)] = cljs.core.first.call(null,(state_68721[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68776 = state_68721;
state_68721 = G__68776;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto__ = function(state_68721){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto____1.call(this,state_68721);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto____0;
fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto____1;
return fluree$db$api$ledger$add_db_auth_sid_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_68753 = f__2902__auto__.call(null);
(statearr_68753[(6)] = c__2901__auto__);

return statearr_68753;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Adds permissions to db. Permissions can either be explicitly stated with roles
 *   or it can be derived from an auth-id.
 *   This assumes the :auth on the db, if it was provided, is already resolved
 *   via add-db-auth-sid function.
 */
fluree.db.api.ledger.add_db_permissions = (function fluree$db$api$ledger$add_db_permissions(db,auth,roles){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_68840){
var state_val_68841 = (state_68840[(1)]);
if((state_val_68841 === (7))){
var inst_68786 = cljs.core._EQ_.call(null,(0),auth);
var state_68840__$1 = state_68840;
if(inst_68786){
var statearr_68842_68891 = state_68840__$1;
(statearr_68842_68891[(1)] = (9));

} else {
var statearr_68843_68892 = state_68840__$1;
(statearr_68843_68892[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (20))){
var inst_68810 = (state_68840[(7)]);
var state_68840__$1 = state_68840;
if(cljs.core.truth_(inst_68810)){
var statearr_68844_68893 = state_68840__$1;
(statearr_68844_68893[(1)] = (22));

} else {
var statearr_68845_68894 = state_68840__$1;
(statearr_68845_68894[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (27))){
var state_68840__$1 = state_68840;
var statearr_68846_68895 = state_68840__$1;
(statearr_68846_68895[(2)] = null);

(statearr_68846_68895[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (1))){
var state_68840__$1 = state_68840;
var statearr_68847_68896 = state_68840__$1;
(statearr_68847_68896[(2)] = null);

(statearr_68847_68896[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (24))){
var inst_68824 = (state_68840[(2)]);
var state_68840__$1 = state_68840;
var statearr_68848_68897 = state_68840__$1;
(statearr_68848_68897[(2)] = inst_68824);

(statearr_68848_68897[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (4))){
var inst_68777 = (state_68840[(2)]);
var state_68840__$1 = state_68840;
var statearr_68849_68898 = state_68840__$1;
(statearr_68849_68898[(2)] = inst_68777);

(statearr_68849_68898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (15))){
var inst_68793 = (state_68840[(8)]);
var inst_68792 = (state_68840[(2)]);
var inst_68793__$1 = fluree.db.util.async.throw_err.call(null,inst_68792);
var state_68840__$1 = (function (){var statearr_68850 = state_68840;
(statearr_68850[(8)] = inst_68793__$1);

return statearr_68850;
})();
if(cljs.core.truth_(inst_68793__$1)){
var statearr_68851_68899 = state_68840__$1;
(statearr_68851_68899[(1)] = (16));

} else {
var statearr_68852_68900 = state_68840__$1;
(statearr_68852_68900[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (21))){
var inst_68826 = (state_68840[(9)]);
var inst_68826__$1 = (state_68840[(2)]);
var state_68840__$1 = (function (){var statearr_68853 = state_68840;
(statearr_68853[(9)] = inst_68826__$1);

return statearr_68853;
})();
if(cljs.core.truth_(inst_68826__$1)){
var statearr_68854_68901 = state_68840__$1;
(statearr_68854_68901[(1)] = (29));

} else {
var statearr_68855_68902 = state_68840__$1;
(statearr_68855_68902[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (31))){
var inst_68810 = (state_68840[(7)]);
var inst_68826 = (state_68840[(9)]);
var inst_68834 = (state_68840[(2)]);
var inst_68835 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_68810,new cljs.core.Keyword(null,"roles","roles",143379530),inst_68826,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_68834);
var _ = (function (){var statearr_68856 = state_68840;
(statearr_68856[(4)] = cljs.core.rest.call(null,(state_68840[(4)])));

return statearr_68856;
})();
var state_68840__$1 = state_68840;
var statearr_68857_68903 = state_68840__$1;
(statearr_68857_68903[(2)] = inst_68835);

(statearr_68857_68903[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (32))){
var inst_68830 = (state_68840[(2)]);
var inst_68831 = fluree.db.util.async.throw_err.call(null,inst_68830);
var state_68840__$1 = state_68840;
var statearr_68858_68904 = state_68840__$1;
(statearr_68858_68904[(2)] = inst_68831);

(statearr_68858_68904[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (13))){
var state_68840__$1 = state_68840;
var statearr_68859_68905 = state_68840__$1;
(statearr_68859_68905[(2)] = null);

(statearr_68859_68905[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (22))){
var inst_68810 = (state_68840[(7)]);
var inst_68814 = fluree.db.auth.roles.call(null,db,inst_68810);
var state_68840__$1 = state_68840;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68840__$1,(25),inst_68814);
} else {
if((state_val_68841 === (29))){
var inst_68826 = (state_68840[(9)]);
var inst_68828 = fluree.db.permissions.permission_map.call(null,db,inst_68826,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_68840__$1 = state_68840;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68840__$1,(32),inst_68828);
} else {
if((state_val_68841 === (6))){
var state_68840__$1 = state_68840;
var statearr_68860_68906 = state_68840__$1;
(statearr_68860_68906[(2)] = null);

(statearr_68860_68906[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (28))){
var inst_68822 = (state_68840[(2)]);
var state_68840__$1 = state_68840;
var statearr_68861_68907 = state_68840__$1;
(statearr_68861_68907[(2)] = inst_68822);

(statearr_68861_68907[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (25))){
var inst_68816 = (state_68840[(2)]);
var inst_68817 = fluree.db.util.async.throw_err.call(null,inst_68816);
var state_68840__$1 = state_68840;
var statearr_68862_68908 = state_68840__$1;
(statearr_68862_68908[(2)] = inst_68817);

(statearr_68862_68908[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (17))){
var inst_68796 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(auth)," unknown."].join('');
var inst_68797 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_68798 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_68799 = cljs.core.PersistentHashMap.fromArrays(inst_68797,inst_68798);
var inst_68800 = cljs.core.ex_info.call(null,inst_68796,inst_68799);
var inst_68801 = (function(){throw inst_68800})();
var state_68840__$1 = state_68840;
var statearr_68863_68909 = state_68840__$1;
(statearr_68863_68909[(2)] = inst_68801);

(statearr_68863_68909[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (3))){
var inst_68838 = (state_68840[(2)]);
var state_68840__$1 = state_68840;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68840__$1,inst_68838);
} else {
if((state_val_68841 === (12))){
var inst_68790 = fluree.db.dbproto._subid.call(null,db,auth);
var state_68840__$1 = state_68840;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68840__$1,(15),inst_68790);
} else {
if((state_val_68841 === (2))){
var _ = (function (){var statearr_68864 = state_68840;
(statearr_68864[(4)] = cljs.core.cons.call(null,(5),(state_68840[(4)])));

return statearr_68864;
})();
var inst_68783 = (auth == null);
var state_68840__$1 = state_68840;
if(cljs.core.truth_(inst_68783)){
var statearr_68865_68910 = state_68840__$1;
(statearr_68865_68910[(1)] = (6));

} else {
var statearr_68866_68911 = state_68840__$1;
(statearr_68866_68911[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (23))){
var state_68840__$1 = state_68840;
var statearr_68867_68912 = state_68840__$1;
(statearr_68867_68912[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (19))){
var state_68840__$1 = state_68840;
var statearr_68869_68913 = state_68840__$1;
(statearr_68869_68913[(2)] = roles);

(statearr_68869_68913[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (11))){
var inst_68808 = (state_68840[(2)]);
var state_68840__$1 = state_68840;
var statearr_68871_68914 = state_68840__$1;
(statearr_68871_68914[(2)] = inst_68808);

(statearr_68871_68914[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (9))){
var state_68840__$1 = state_68840;
var statearr_68872_68915 = state_68840__$1;
(statearr_68872_68915[(2)] = (0));

(statearr_68872_68915[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (5))){
var _ = (function (){var statearr_68873 = state_68840;
(statearr_68873[(4)] = cljs.core.rest.call(null,(state_68840[(4)])));

return statearr_68873;
})();
var state_68840__$1 = state_68840;
var ex68870 = (state_68840__$1[(2)]);
var statearr_68874_68916 = state_68840__$1;
(statearr_68874_68916[(5)] = ex68870);


if((ex68870 instanceof Error)){
var statearr_68875_68917 = state_68840__$1;
(statearr_68875_68917[(1)] = (4));

(statearr_68875_68917[(5)] = null);

} else {
throw ex68870;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (14))){
var inst_68806 = (state_68840[(2)]);
var state_68840__$1 = state_68840;
var statearr_68876_68918 = state_68840__$1;
(statearr_68876_68918[(2)] = inst_68806);

(statearr_68876_68918[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (26))){
var state_68840__$1 = state_68840;
var statearr_68877_68919 = state_68840__$1;
(statearr_68877_68919[(2)] = null);

(statearr_68877_68919[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (16))){
var inst_68793 = (state_68840[(8)]);
var state_68840__$1 = state_68840;
var statearr_68878_68920 = state_68840__$1;
(statearr_68878_68920[(2)] = inst_68793);

(statearr_68878_68920[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (30))){
var state_68840__$1 = state_68840;
var statearr_68879_68921 = state_68840__$1;
(statearr_68879_68921[(2)] = null);

(statearr_68879_68921[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (10))){
var state_68840__$1 = state_68840;
if(cljs.core.truth_(auth)){
var statearr_68880_68922 = state_68840__$1;
(statearr_68880_68922[(1)] = (12));

} else {
var statearr_68881_68923 = state_68840__$1;
(statearr_68881_68923[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (18))){
var inst_68803 = (state_68840[(2)]);
var state_68840__$1 = state_68840;
var statearr_68882_68924 = state_68840__$1;
(statearr_68882_68924[(2)] = inst_68803);

(statearr_68882_68924[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68841 === (8))){
var inst_68810 = (state_68840[(2)]);
var state_68840__$1 = (function (){var statearr_68883 = state_68840;
(statearr_68883[(7)] = inst_68810);

return statearr_68883;
})();
if(cljs.core.truth_(roles)){
var statearr_68884_68925 = state_68840__$1;
(statearr_68884_68925[(1)] = (19));

} else {
var statearr_68885_68926 = state_68840__$1;
(statearr_68885_68926[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto__ = null;
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto____0 = (function (){
var statearr_68886 = [null,null,null,null,null,null,null,null,null,null];
(statearr_68886[(0)] = fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto__);

(statearr_68886[(1)] = (1));

return statearr_68886;
});
var fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto____1 = (function (state_68840){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_68840);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e68887){var ex__2882__auto__ = e68887;
var statearr_68888_68927 = state_68840;
(statearr_68888_68927[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_68840[(4)]))){
var statearr_68889_68928 = state_68840;
(statearr_68889_68928[(1)] = cljs.core.first.call(null,(state_68840[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68929 = state_68840;
state_68840 = G__68929;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto__ = function(state_68840){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto____1.call(this,state_68840);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto____0;
fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto____1;
return fluree$db$api$ledger$add_db_permissions_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_68890 = f__2902__auto__.call(null);
(statearr_68890[(6)] = c__2901__auto__);

return statearr_68890;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Executes wait listener for updated db that is at least at block syncTo.
 *   Received listen-id which is used as key for connection listener, allowing
 *   anything with that key to cancel the listener.
 * 
 *   resp-port is the async port on which any successful response will be placed.
 */
fluree.db.api.ledger.syncTo_wait = (function fluree$db$api$ledger$syncTo_wait(db,syncTo,listen_id,resp_port){
var map__68930 = db;
var map__68930__$1 = (((((!((map__68930 == null))))?(((((map__68930.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__68930.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__68930):map__68930);
var conn = cljs.core.get.call(null,map__68930__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__68930__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__68930__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var newer_block_QMARK_ = (function (block){
return (block >= syncTo);
});
var event_fn = (function (evt,data){
fluree.db.util.log.warn.call(null,"NEW EVENT:",cljs.core.pr_str.call(null,evt),cljs.core.pr_str.call(null,data));

if(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),evt)) && (newer_block_QMARK_.call(null,new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(data))))){
fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);

var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_68938){
var state_val_68939 = (state_68938[(1)]);
if((state_val_68939 === (1))){
var inst_68932 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_68933 = fluree.db.session.db.call(null,conn,inst_68932,null);
var state_68938__$1 = state_68938;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68938__$1,(2),inst_68933);
} else {
if((state_val_68939 === (2))){
var inst_68935 = (state_68938[(2)]);
var inst_68936 = cljs.core.async.put_BANG_.call(null,resp_port,inst_68935);
var state_68938__$1 = state_68938;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68938__$1,inst_68936);
} else {
return null;
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____0 = (function (){
var statearr_68940 = [null,null,null,null,null,null,null];
(statearr_68940[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__);

(statearr_68940[(1)] = (1));

return statearr_68940;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____1 = (function (state_68938){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_68938);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e68941){var ex__2882__auto__ = e68941;
var statearr_68942_68969 = state_68938;
(statearr_68942_68969[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_68938[(4)]))){
var statearr_68943_68970 = state_68938;
(statearr_68943_68970[(1)] = cljs.core.first.call(null,(state_68938[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68971 = state_68938;
state_68938 = G__68971;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__ = function(state_68938){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____1.call(this,state_68938);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_68944 = f__2902__auto__.call(null);
(statearr_68944[(6)] = c__2901__auto__);

return statearr_68944;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
} else {
return null;
}
});
fluree.db.connection.add_listener.call(null,conn,network,dbid,listen_id,event_fn);

var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_68957){
var state_val_68958 = (state_68957[(1)]);
if((state_val_68958 === (1))){
var inst_68945 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var inst_68946 = fluree.db.session.db.call(null,conn,inst_68945,null);
var state_68957__$1 = state_68957;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_68957__$1,(2),inst_68946);
} else {
if((state_val_68958 === (2))){
var inst_68948 = (state_68957[(7)]);
var inst_68948__$1 = (state_68957[(2)]);
var inst_68949 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_68948__$1);
var inst_68950 = newer_block_QMARK_.call(null,inst_68949);
var state_68957__$1 = (function (){var statearr_68959 = state_68957;
(statearr_68959[(7)] = inst_68948__$1);

return statearr_68959;
})();
if(inst_68950){
var statearr_68960_68972 = state_68957__$1;
(statearr_68960_68972[(1)] = (3));

} else {
var statearr_68961_68973 = state_68957__$1;
(statearr_68961_68973[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68958 === (3))){
var inst_68948 = (state_68957[(7)]);
var inst_68952 = cljs.core.async.put_BANG_.call(null,resp_port,inst_68948);
var state_68957__$1 = state_68957;
var statearr_68962_68974 = state_68957__$1;
(statearr_68962_68974[(2)] = inst_68952);

(statearr_68962_68974[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68958 === (4))){
var state_68957__$1 = state_68957;
var statearr_68963_68975 = state_68957__$1;
(statearr_68963_68975[(2)] = null);

(statearr_68963_68975[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_68958 === (5))){
var inst_68955 = (state_68957[(2)]);
var state_68957__$1 = state_68957;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_68957__$1,inst_68955);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__ = null;
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____0 = (function (){
var statearr_68964 = [null,null,null,null,null,null,null,null];
(statearr_68964[(0)] = fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__);

(statearr_68964[(1)] = (1));

return statearr_68964;
});
var fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____1 = (function (state_68957){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_68957);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e68965){var ex__2882__auto__ = e68965;
var statearr_68966_68976 = state_68957;
(statearr_68966_68976[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_68957[(4)]))){
var statearr_68967_68977 = state_68957;
(statearr_68967_68977[(1)] = cljs.core.first.call(null,(state_68957[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__68978 = state_68957;
state_68957 = G__68978;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__ = function(state_68957){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____1.call(this,state_68957);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____0;
fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto____1;
return fluree$db$api$ledger$syncTo_wait_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_68968 = f__2902__auto__.call(null);
(statearr_68968[(6)] = c__2901__auto__);

return statearr_68968;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.api.ledger.syncTo_db = (function fluree$db$api$ledger$syncTo_db(db,syncTo,syncTimeout){
if(cljs.core.pos_int_QMARK_.call(null,syncTo)){
} else {
throw (new Error(["Assert failed: ",["syncTo must be a block number (positive integer), provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join(''),"\n","(pos-int? syncTo)"].join('')));
}

var pc = cljs.core.async.promise_chan.call(null);
var map__68979 = db;
var map__68979__$1 = (((((!((map__68979 == null))))?(((((map__68979.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__68979.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__68979):map__68979);
var conn = cljs.core.get.call(null,map__68979__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var network = cljs.core.get.call(null,map__68979__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__68979__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var listen_id = fluree.db.util.core.random_uuid.call(null);
var timeout = ((cljs.core.pos_int_QMARK_.call(null,syncTimeout))?(function (){var x__4217__auto__ = syncTimeout;
var y__4218__auto__ = (120000);
return ((x__4217__auto__ < y__4218__auto__) ? x__4217__auto__ : y__4218__auto__);
})():(60000));
var res_port = cljs.core.async.chan.call(null);
if((new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db) >= syncTo)){
cljs.core.async.put_BANG_.call(null,pc,db);
} else {
fluree.db.api.ledger.syncTo_wait.call(null,db,syncTo,listen_id,res_port);

var c__2901__auto___69056 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_69030){
var state_val_69031 = (state_69030[(1)]);
if((state_val_69031 === (7))){
var inst_68996 = (state_69030[(7)]);
var inst_69007 = cljs.core._EQ_.call(null,inst_68996,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_69030__$1 = state_69030;
if(inst_69007){
var statearr_69032_69057 = state_69030__$1;
(statearr_69032_69057[(1)] = (9));

} else {
var statearr_69033_69058 = state_69030__$1;
(statearr_69033_69058[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69031 === (1))){
var inst_68981 = (state_69030[(8)]);
var inst_68989 = (state_69030[(9)]);
var inst_68981__$1 = cljs.core.async.timeout.call(null,timeout);
var inst_68989__$1 = res_port;
var inst_68990 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68991 = [inst_68981__$1,inst_68989__$1];
var inst_68992 = (new cljs.core.PersistentVector(null,2,(5),inst_68990,inst_68991,null));
var state_69030__$1 = (function (){var statearr_69034 = state_69030;
(statearr_69034[(8)] = inst_68981__$1);

(statearr_69034[(9)] = inst_68989__$1);

return statearr_69034;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_69030__$1,(2),inst_68992);
} else {
if((state_val_69031 === (4))){
var inst_68996 = (state_69030[(7)]);
var inst_68989 = (state_69030[(9)]);
var inst_69000 = cljs.core._EQ_.call(null,inst_68996,inst_68989);
var state_69030__$1 = state_69030;
if(inst_69000){
var statearr_69035_69059 = state_69030__$1;
(statearr_69035_69059[(1)] = (6));

} else {
var statearr_69036_69060 = state_69030__$1;
(statearr_69036_69060[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69031 === (13))){
var inst_69015 = (state_69030[(10)]);
var inst_69026 = cljs.core.async.put_BANG_.call(null,pc,inst_69015);
var state_69030__$1 = state_69030;
var statearr_69037_69061 = state_69030__$1;
(statearr_69037_69061[(2)] = inst_69026);

(statearr_69037_69061[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69031 === (6))){
var inst_68994 = (state_69030[(11)]);
var inst_69005 = cljs.core.nth.call(null,inst_68994,(0),null);
var state_69030__$1 = state_69030;
var statearr_69038_69062 = state_69030__$1;
(statearr_69038_69062[(2)] = inst_69005);

(statearr_69038_69062[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69031 === (3))){
var state_69030__$1 = state_69030;
var statearr_69039_69063 = state_69030__$1;
(statearr_69039_69063[(2)] = new cljs.core.Keyword(null,"timeout","timeout",-318625318));

(statearr_69039_69063[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69031 === (12))){
var inst_69019 = ["Timeout waiting for block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(syncTo)].join('');
var inst_69020 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_69021 = [(400),new cljs.core.Keyword("db","timeout","db/timeout",-318636520)];
var inst_69022 = cljs.core.PersistentHashMap.fromArrays(inst_69020,inst_69021);
var inst_69023 = cljs.core.ex_info.call(null,inst_69019,inst_69022);
var inst_69024 = cljs.core.async.put_BANG_.call(null,pc,inst_69023);
var state_69030__$1 = state_69030;
var statearr_69040_69064 = state_69030__$1;
(statearr_69040_69064[(2)] = inst_69024);

(statearr_69040_69064[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69031 === (2))){
var inst_68994 = (state_69030[(11)]);
var inst_68996 = (state_69030[(7)]);
var inst_68981 = (state_69030[(8)]);
var inst_68994__$1 = (state_69030[(2)]);
var inst_68995 = cljs.core.nth.call(null,inst_68994__$1,(0),null);
var inst_68996__$1 = cljs.core.nth.call(null,inst_68994__$1,(1),null);
var inst_68997 = cljs.core._EQ_.call(null,inst_68996__$1,inst_68981);
var state_69030__$1 = (function (){var statearr_69041 = state_69030;
(statearr_69041[(11)] = inst_68994__$1);

(statearr_69041[(7)] = inst_68996__$1);

(statearr_69041[(12)] = inst_68995);

return statearr_69041;
})();
if(inst_68997){
var statearr_69042_69065 = state_69030__$1;
(statearr_69042_69065[(1)] = (3));

} else {
var statearr_69043_69066 = state_69030__$1;
(statearr_69043_69066[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69031 === (11))){
var inst_69011 = (state_69030[(2)]);
var state_69030__$1 = state_69030;
var statearr_69044_69067 = state_69030__$1;
(statearr_69044_69067[(2)] = inst_69011);

(statearr_69044_69067[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69031 === (9))){
var inst_68995 = (state_69030[(12)]);
var state_69030__$1 = state_69030;
var statearr_69045_69068 = state_69030__$1;
(statearr_69045_69068[(2)] = inst_68995);

(statearr_69045_69068[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69031 === (5))){
var inst_69015 = (state_69030[(10)]);
var inst_69015__$1 = (state_69030[(2)]);
var inst_69016 = fluree.db.connection.remove_listener.call(null,conn,network,dbid,listen_id);
var inst_69017 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"timeout","timeout",-318625318),inst_69015__$1);
var state_69030__$1 = (function (){var statearr_69046 = state_69030;
(statearr_69046[(10)] = inst_69015__$1);

(statearr_69046[(13)] = inst_69016);

return statearr_69046;
})();
if(inst_69017){
var statearr_69047_69069 = state_69030__$1;
(statearr_69047_69069[(1)] = (12));

} else {
var statearr_69048_69070 = state_69030__$1;
(statearr_69048_69070[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69031 === (14))){
var inst_69028 = (state_69030[(2)]);
var state_69030__$1 = state_69030;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69030__$1,inst_69028);
} else {
if((state_val_69031 === (10))){
var state_69030__$1 = state_69030;
var statearr_69049_69071 = state_69030__$1;
(statearr_69049_69071[(2)] = null);

(statearr_69049_69071[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69031 === (8))){
var inst_69013 = (state_69030[(2)]);
var state_69030__$1 = state_69030;
var statearr_69050_69072 = state_69030__$1;
(statearr_69050_69072[(2)] = inst_69013);

(statearr_69050_69072[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto__ = null;
var fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto____0 = (function (){
var statearr_69051 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69051[(0)] = fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto__);

(statearr_69051[(1)] = (1));

return statearr_69051;
});
var fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto____1 = (function (state_69030){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_69030);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e69052){var ex__2882__auto__ = e69052;
var statearr_69053_69073 = state_69030;
(statearr_69053_69073[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_69030[(4)]))){
var statearr_69054_69074 = state_69030;
(statearr_69054_69074[(1)] = cljs.core.first.call(null,(state_69030[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69075 = state_69030;
state_69030 = G__69075;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto__ = function(state_69030){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto____1.call(this,state_69030);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto____0;
fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto____1;
return fluree$db$api$ledger$syncTo_db_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_69055 = f__2902__auto__.call(null);
(statearr_69055[(6)] = c__2901__auto___69056);

return statearr_69055;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

}

return pc;
});
/**
 * Returns a queryable database from the connection for the specified ledger.
 */
fluree.db.api.ledger.db = (function fluree$db$api$ledger$db(var_args){
var G__69077 = arguments.length;
switch (G__69077) {
case 2:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.api.ledger.root_db.call(null,conn,ledger,null);
}));

(fluree.db.api.ledger.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__69078){
var map__69079 = p__69078;
var map__69079__$1 = (((((!((map__69079 == null))))?(((((map__69079.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__69079.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__69079):map__69079);
var opts = map__69079__$1;
var roles = cljs.core.get.call(null,map__69079__$1,new cljs.core.Keyword(null,"roles","roles",143379530));
var auth = cljs.core.get.call(null,map__69079__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var block = cljs.core.get.call(null,map__69079__$1,new cljs.core.Keyword(null,"block","block",664686210));
var syncTo = cljs.core.get.call(null,map__69079__$1,new cljs.core.Keyword(null,"syncTo","syncTo",281420769));
var syncTimeout = cljs.core.get.call(null,map__69079__$1,new cljs.core.Keyword(null,"syncTimeout","syncTimeout",640091482));
var pc = cljs.core.async.promise_chan.call(null);
var c__2901__auto___69169 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_69131){
var state_val_69132 = (state_69131[(1)]);
if((state_val_69132 === (7))){
var inst_69093 = (state_69131[(7)]);
var inst_69095 = fluree.db.api.ledger.syncTo_db.call(null,inst_69093,syncTo,syncTimeout);
var state_69131__$1 = state_69131;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69131__$1,(10),inst_69095);
} else {
if((state_val_69132 === (20))){
var inst_69117 = (state_69131[(8)]);
var state_69131__$1 = state_69131;
var statearr_69133_69170 = state_69131__$1;
(statearr_69133_69170[(2)] = inst_69117);

(statearr_69133_69170[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69132 === (1))){
var state_69131__$1 = state_69131;
var statearr_69134_69171 = state_69131__$1;
(statearr_69134_69171[(2)] = null);

(statearr_69134_69171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69132 === (4))){
var inst_69081 = (state_69131[(2)]);
var inst_69082 = cljs.core.async.put_BANG_.call(null,pc,inst_69081);
var inst_69083 = cljs.core.async.close_BANG_.call(null,pc);
var state_69131__$1 = (function (){var statearr_69135 = state_69131;
(statearr_69135[(9)] = inst_69082);

return statearr_69135;
})();
var statearr_69136_69172 = state_69131__$1;
(statearr_69136_69172[(2)] = inst_69083);

(statearr_69136_69172[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69132 === (15))){
var inst_69109 = (state_69131[(10)]);
var inst_69111 = fluree.db.api.ledger.add_db_permissions.call(null,inst_69109,auth,roles);
var state_69131__$1 = state_69131;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69131__$1,(18),inst_69111);
} else {
if((state_val_69132 === (21))){
var inst_69125 = (state_69131[(2)]);
var inst_69126 = cljs.core.async.put_BANG_.call(null,pc,inst_69125);
var _ = (function (){var statearr_69137 = state_69131;
(statearr_69137[(4)] = cljs.core.rest.call(null,(state_69131[(4)])));

return statearr_69137;
})();
var state_69131__$1 = state_69131;
var statearr_69138_69173 = state_69131__$1;
(statearr_69138_69173[(2)] = inst_69126);

(statearr_69138_69173[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69132 === (13))){
var inst_69109 = (state_69131[(2)]);
var state_69131__$1 = (function (){var statearr_69139 = state_69131;
(statearr_69139[(10)] = inst_69109);

return statearr_69139;
})();
if(cljs.core.truth_(roles)){
var statearr_69140_69174 = state_69131__$1;
(statearr_69140_69174[(1)] = (15));

} else {
var statearr_69141_69175 = state_69131__$1;
(statearr_69141_69175[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69132 === (22))){
var inst_69121 = (state_69131[(2)]);
var inst_69122 = fluree.db.util.async.throw_err.call(null,inst_69121);
var state_69131__$1 = state_69131;
var statearr_69142_69176 = state_69131__$1;
(statearr_69142_69176[(2)] = inst_69122);

(statearr_69142_69176[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69132 === (6))){
var inst_69092 = (state_69131[(2)]);
var inst_69093 = fluree.db.util.async.throw_err.call(null,inst_69092);
var state_69131__$1 = (function (){var statearr_69143 = state_69131;
(statearr_69143[(7)] = inst_69093);

return statearr_69143;
})();
if(cljs.core.truth_(syncTo)){
var statearr_69144_69177 = state_69131__$1;
(statearr_69144_69177[(1)] = (7));

} else {
var statearr_69145_69178 = state_69131__$1;
(statearr_69145_69178[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69132 === (17))){
var inst_69117 = (state_69131[(2)]);
var state_69131__$1 = (function (){var statearr_69146 = state_69131;
(statearr_69146[(8)] = inst_69117);

return statearr_69146;
})();
if(cljs.core.truth_(auth)){
var statearr_69147_69179 = state_69131__$1;
(statearr_69147_69179[(1)] = (19));

} else {
var statearr_69148_69180 = state_69131__$1;
(statearr_69148_69180[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69132 === (3))){
var inst_69129 = (state_69131[(2)]);
var state_69131__$1 = state_69131;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_69131__$1,inst_69129);
} else {
if((state_val_69132 === (12))){
var inst_69101 = (state_69131[(11)]);
var state_69131__$1 = state_69131;
var statearr_69149_69181 = state_69131__$1;
(statearr_69149_69181[(2)] = inst_69101);

(statearr_69149_69181[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69132 === (2))){
var _ = (function (){var statearr_69150 = state_69131;
(statearr_69150[(4)] = cljs.core.cons.call(null,(5),(state_69131[(4)])));

return statearr_69150;
})();
var inst_69090 = fluree.db.session.db.call(null,conn,ledger,null);
var state_69131__$1 = state_69131;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69131__$1,(6),inst_69090);
} else {
if((state_val_69132 === (19))){
var inst_69117 = (state_69131[(8)]);
var inst_69119 = fluree.db.api.ledger.add_db_permissions.call(null,inst_69117,auth,roles);
var state_69131__$1 = state_69131;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69131__$1,(22),inst_69119);
} else {
if((state_val_69132 === (11))){
var inst_69101 = (state_69131[(11)]);
var inst_69103 = fluree.db.time_travel.as_of_block.call(null,inst_69101,block);
var state_69131__$1 = state_69131;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_69131__$1,(14),inst_69103);
} else {
if((state_val_69132 === (9))){
var inst_69101 = (state_69131[(2)]);
var state_69131__$1 = (function (){var statearr_69152 = state_69131;
(statearr_69152[(11)] = inst_69101);

return statearr_69152;
})();
if(cljs.core.truth_(block)){
var statearr_69153_69182 = state_69131__$1;
(statearr_69153_69182[(1)] = (11));

} else {
var statearr_69154_69183 = state_69131__$1;
(statearr_69154_69183[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69132 === (5))){
var _ = (function (){var statearr_69155 = state_69131;
(statearr_69155[(4)] = cljs.core.rest.call(null,(state_69131[(4)])));

return statearr_69155;
})();
var state_69131__$1 = state_69131;
var ex69151 = (state_69131__$1[(2)]);
var statearr_69156_69184 = state_69131__$1;
(statearr_69156_69184[(5)] = ex69151);


var statearr_69157_69185 = state_69131__$1;
(statearr_69157_69185[(1)] = (4));

(statearr_69157_69185[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69132 === (14))){
var inst_69105 = (state_69131[(2)]);
var inst_69106 = fluree.db.util.async.throw_err.call(null,inst_69105);
var state_69131__$1 = state_69131;
var statearr_69158_69186 = state_69131__$1;
(statearr_69158_69186[(2)] = inst_69106);

(statearr_69158_69186[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69132 === (16))){
var inst_69109 = (state_69131[(10)]);
var state_69131__$1 = state_69131;
var statearr_69159_69187 = state_69131__$1;
(statearr_69159_69187[(2)] = inst_69109);

(statearr_69159_69187[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69132 === (10))){
var inst_69097 = (state_69131[(2)]);
var inst_69098 = fluree.db.util.async.throw_err.call(null,inst_69097);
var state_69131__$1 = state_69131;
var statearr_69160_69188 = state_69131__$1;
(statearr_69160_69188[(2)] = inst_69098);

(statearr_69160_69188[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69132 === (18))){
var inst_69113 = (state_69131[(2)]);
var inst_69114 = fluree.db.util.async.throw_err.call(null,inst_69113);
var state_69131__$1 = state_69131;
var statearr_69161_69189 = state_69131__$1;
(statearr_69161_69189[(2)] = inst_69114);

(statearr_69161_69189[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_69132 === (8))){
var inst_69093 = (state_69131[(7)]);
var state_69131__$1 = state_69131;
var statearr_69162_69190 = state_69131__$1;
(statearr_69162_69190[(2)] = inst_69093);

(statearr_69162_69190[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$ledger$state_machine__2879__auto__ = null;
var fluree$db$api$ledger$state_machine__2879__auto____0 = (function (){
var statearr_69163 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69163[(0)] = fluree$db$api$ledger$state_machine__2879__auto__);

(statearr_69163[(1)] = (1));

return statearr_69163;
});
var fluree$db$api$ledger$state_machine__2879__auto____1 = (function (state_69131){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_69131);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e69164){var ex__2882__auto__ = e69164;
var statearr_69165_69191 = state_69131;
(statearr_69165_69191[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_69131[(4)]))){
var statearr_69166_69192 = state_69131;
(statearr_69166_69192[(1)] = cljs.core.first.call(null,(state_69131[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__69193 = state_69131;
state_69131 = G__69193;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$ledger$state_machine__2879__auto__ = function(state_69131){
switch(arguments.length){
case 0:
return fluree$db$api$ledger$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$ledger$state_machine__2879__auto____1.call(this,state_69131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$ledger$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$ledger$state_machine__2879__auto____0;
fluree$db$api$ledger$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$ledger$state_machine__2879__auto____1;
return fluree$db$api$ledger$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_69167 = f__2902__auto__.call(null);
(statearr_69167[(6)] = c__2901__auto___69169);

return statearr_69167;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));


return pc;
}));

(fluree.db.api.ledger.db.cljs$lang$maxFixedArity = 3);

