// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.dbproto');
goog.require('cljs.core');

/**
 * All nodes must implement this protocol. It's includes the minimal functionality
 * necessary to avoid resolving nodes unless strictly necessary.
 * @interface
 */
fluree.db.dbproto.IResolve = function(){};

var fluree$db$dbproto$IResolve$_first_flake$dyn_13581 = (function (node){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._first_flake[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node);
} else {
var m__4426__auto__ = (fluree.db.dbproto._first_flake["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-first-flake",node);
}
}
});
/**
 * Returns the first flake in this node
 */
fluree.db.dbproto._first_flake = (function fluree$db$dbproto$_first_flake(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_first_flake$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_first_flake$arity$1(node);
} else {
return fluree$db$dbproto$IResolve$_first_flake$dyn_13581.call(null,node);
}
});

var fluree$db$dbproto$IResolve$_rhs$dyn_13582 = (function (node){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._rhs[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node);
} else {
var m__4426__auto__ = (fluree.db.dbproto._rhs["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-rhs",node);
}
}
});
/**
 * Returns the next node's first flake
 */
fluree.db.dbproto._rhs = (function fluree$db$dbproto$_rhs(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_rhs$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_rhs$arity$1(node);
} else {
return fluree$db$dbproto$IResolve$_rhs$dyn_13582.call(null,node);
}
});

var fluree$db$dbproto$IResolve$_history_count$dyn_13583 = (function (node){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._history_count[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node);
} else {
var m__4426__auto__ = (fluree.db.dbproto._history_count["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-history-count",node);
}
}
});
/**
 * Returns how many history nodes are present for this node (if a leaf)
 */
fluree.db.dbproto._history_count = (function fluree$db$dbproto$_history_count(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_history_count$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_history_count$arity$1(node);
} else {
return fluree$db$dbproto$IResolve$_history_count$dyn_13583.call(null,node);
}
});

var fluree$db$dbproto$IResolve$_resolve$dyn_13584 = (function (node){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._resolve[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node);
} else {
var m__4426__auto__ = (fluree.db.dbproto._resolve["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-resolve",node);
}
}
});
/**
 * Returns node resolved with data as async channel
 */
fluree.db.dbproto._resolve = (function fluree$db$dbproto$_resolve(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve$arity$1(node);
} else {
return fluree$db$dbproto$IResolve$_resolve$dyn_13584.call(null,node);
}
});

var fluree$db$dbproto$IResolve$_resolve_to_t$dyn_13585 = (function() {
var G__13586 = null;
var G__13586__3 = (function (node,t,idx_novelty){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._resolve_to_t[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node,t,idx_novelty);
} else {
var m__4426__auto__ = (fluree.db.dbproto._resolve_to_t["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node,t,idx_novelty);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-resolve-to-t",node);
}
}
});
var G__13586__4 = (function (node,t,idx_novelty,fast_forward_db_QMARK_){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._resolve_to_t[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node,t,idx_novelty,fast_forward_db_QMARK_);
} else {
var m__4426__auto__ = (fluree.db.dbproto._resolve_to_t["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node,t,idx_novelty,fast_forward_db_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-resolve-to-t",node);
}
}
});
var G__13586__5 = (function (node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._resolve_to_t[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes);
} else {
var m__4426__auto__ = (fluree.db.dbproto._resolve_to_t["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-resolve-to-t",node);
}
}
});
G__13586 = function(node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes){
switch(arguments.length){
case 3:
return G__13586__3.call(this,node,t,idx_novelty);
case 4:
return G__13586__4.call(this,node,t,idx_novelty,fast_forward_db_QMARK_);
case 5:
return G__13586__5.call(this,node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13586.cljs$core$IFn$_invoke$arity$3 = G__13586__3;
G__13586.cljs$core$IFn$_invoke$arity$4 = G__13586__4;
G__13586.cljs$core$IFn$_invoke$arity$5 = G__13586__5;
return G__13586;
})()
;
/**
 * Resolves this node at specified transaction 't'. Novelty included for the specified index.
 */
fluree.db.dbproto._resolve_to_t = (function fluree$db$dbproto$_resolve_to_t(var_args){
var G__13578 = arguments.length;
switch (G__13578) {
case 3:
return fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$3 = (function (node,t,idx_novelty){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3(node,t,idx_novelty);
} else {
return fluree$db$dbproto$IResolve$_resolve_to_t$dyn_13585.call(null,node,t,idx_novelty);
}
}));

(fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4 = (function (node,t,idx_novelty,fast_forward_db_QMARK_){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4(node,t,idx_novelty,fast_forward_db_QMARK_);
} else {
return fluree$db$dbproto$IResolve$_resolve_to_t$dyn_13585.call(null,node,t,idx_novelty,fast_forward_db_QMARK_);
}
}));

(fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$5 = (function (node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5(node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes);
} else {
return fluree$db$dbproto$IResolve$_resolve_to_t$dyn_13585.call(null,node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes);
}
}));

(fluree.db.dbproto._resolve_to_t.cljs$lang$maxFixedArity = 5);


var fluree$db$dbproto$IResolve$_resolve_history$dyn_13588 = (function (node){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._resolve_history[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node);
} else {
var m__4426__auto__ = (fluree.db.dbproto._resolve_history["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-resolve-history",node);
}
}
});
/**
 * Returns the history for data nodes.
 */
fluree.db.dbproto._resolve_history = (function fluree$db$dbproto$_resolve_history(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_history$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_history$arity$1(node);
} else {
return fluree$db$dbproto$IResolve$_resolve_history$dyn_13588.call(null,node);
}
});

var fluree$db$dbproto$IResolve$_resolve_history_range$dyn_13589 = (function() {
var G__13590 = null;
var G__13590__3 = (function (node,from_t,to_t){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._resolve_history_range[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node,from_t,to_t);
} else {
var m__4426__auto__ = (fluree.db.dbproto._resolve_history_range["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node,from_t,to_t);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-resolve-history-range",node);
}
}
});
var G__13590__4 = (function (node,from_t,to_t,idx_novelty){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._resolve_history_range[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node,from_t,to_t,idx_novelty);
} else {
var m__4426__auto__ = (fluree.db.dbproto._resolve_history_range["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node,from_t,to_t,idx_novelty);
} else {
throw cljs.core.missing_protocol.call(null,"IResolve.-resolve-history-range",node);
}
}
});
G__13590 = function(node,from_t,to_t,idx_novelty){
switch(arguments.length){
case 3:
return G__13590__3.call(this,node,from_t,to_t);
case 4:
return G__13590__4.call(this,node,from_t,to_t,idx_novelty);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13590.cljs$core$IFn$_invoke$arity$3 = G__13590__3;
G__13590.cljs$core$IFn$_invoke$arity$4 = G__13590__4;
return G__13590;
})()
;
/**
 * Returns the history within specified range of 't' values. From is most recent time.
 */
fluree.db.dbproto._resolve_history_range = (function fluree$db$dbproto$_resolve_history_range(var_args){
var G__13580 = arguments.length;
switch (G__13580) {
case 3:
return fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$3 = (function (node,from_t,to_t){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3(node,from_t,to_t);
} else {
return fluree$db$dbproto$IResolve$_resolve_history_range$dyn_13589.call(null,node,from_t,to_t);
}
}));

(fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4 = (function (node,from_t,to_t,idx_novelty){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4(node,from_t,to_t,idx_novelty);
} else {
return fluree$db$dbproto$IResolve$_resolve_history_range$dyn_13589.call(null,node,from_t,to_t,idx_novelty);
}
}));

(fluree.db.dbproto._resolve_history_range.cljs$lang$maxFixedArity = 4);



/**
 * @interface
 */
fluree.db.dbproto.INode = function(){};

var fluree$db$dbproto$INode$_lookup$dyn_13592 = (function (node,flake){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._lookup[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node,flake);
} else {
var m__4426__auto__ = (fluree.db.dbproto._lookup["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node,flake);
} else {
throw cljs.core.missing_protocol.call(null,"INode.-lookup",node);
}
}
});
/**
 * Returns the child node which contains the given key
 */
fluree.db.dbproto._lookup = (function fluree$db$dbproto$_lookup(node,flake){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$INode$_lookup$arity$2 == null)))))){
return node.fluree$db$dbproto$INode$_lookup$arity$2(node,flake);
} else {
return fluree$db$dbproto$INode$_lookup$dyn_13592.call(null,node,flake);
}
});

var fluree$db$dbproto$INode$_lookup_after$dyn_13593 = (function (node,flake){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._lookup_after[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node,flake);
} else {
var m__4426__auto__ = (fluree.db.dbproto._lookup_after["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node,flake);
} else {
throw cljs.core.missing_protocol.call(null,"INode.-lookup-after",node);
}
}
});
/**
 * Returns the child node which comes after the given key
 */
fluree.db.dbproto._lookup_after = (function fluree$db$dbproto$_lookup_after(node,flake){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$INode$_lookup_after$arity$2 == null)))))){
return node.fluree$db$dbproto$INode$_lookup_after$arity$2(node,flake);
} else {
return fluree$db$dbproto$INode$_lookup_after$dyn_13593.call(null,node,flake);
}
});

var fluree$db$dbproto$INode$_lookup_leaf$dyn_13594 = (function (node,flake){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._lookup_leaf[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node,flake);
} else {
var m__4426__auto__ = (fluree.db.dbproto._lookup_leaf["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node,flake);
} else {
throw cljs.core.missing_protocol.call(null,"INode.-lookup-leaf",node);
}
}
});
/**
 * Returns the leaf node which contains the given key
 */
fluree.db.dbproto._lookup_leaf = (function fluree$db$dbproto$_lookup_leaf(node,flake){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$INode$_lookup_leaf$arity$2 == null)))))){
return node.fluree$db$dbproto$INode$_lookup_leaf$arity$2(node,flake);
} else {
return fluree$db$dbproto$INode$_lookup_leaf$dyn_13594.call(null,node,flake);
}
});

var fluree$db$dbproto$INode$_lookup_leaf_after$dyn_13595 = (function (node,flake){
var x__4428__auto__ = (((node == null))?null:node);
var m__4429__auto__ = (fluree.db.dbproto._lookup_leaf_after[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,node,flake);
} else {
var m__4426__auto__ = (fluree.db.dbproto._lookup_leaf_after["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,node,flake);
} else {
throw cljs.core.missing_protocol.call(null,"INode.-lookup-leaf-after",node);
}
}
});
/**
 * Returns the leaf node which comes after the given key
 */
fluree.db.dbproto._lookup_leaf_after = (function fluree$db$dbproto$_lookup_leaf_after(node,flake){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 == null)))))){
return node.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2(node,flake);
} else {
return fluree$db$dbproto$INode$_lookup_leaf_after$dyn_13595.call(null,node,flake);
}
});


/**
 * @interface
 */
fluree.db.dbproto.IFlureeDb = function(){};

var fluree$db$dbproto$IFlureeDb$_latest_db$dyn_13606 = (function (db){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._latest_db[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db);
} else {
var m__4426__auto__ = (fluree.db.dbproto._latest_db["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-latest-db",db);
}
}
});
/**
 * Updates a db to the most current version of the db known to this server. Maintains existing permissions
 */
fluree.db.dbproto._latest_db = (function fluree$db$dbproto$_latest_db(db){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1(db);
} else {
return fluree$db$dbproto$IFlureeDb$_latest_db$dyn_13606.call(null,db);
}
});

var fluree$db$dbproto$IFlureeDb$_rootdb$dyn_13607 = (function (db){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._rootdb[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db);
} else {
var m__4426__auto__ = (fluree.db.dbproto._rootdb["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-rootdb",db);
}
}
});
/**
 * Returns root db version of this db.
 */
fluree.db.dbproto._rootdb = (function fluree$db$dbproto$_rootdb(db){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(db);
} else {
return fluree$db$dbproto$IFlureeDb$_rootdb$dyn_13607.call(null,db);
}
});

var fluree$db$dbproto$IFlureeDb$_forward_time_travel$dyn_13608 = (function() {
var G__13609 = null;
var G__13609__2 = (function (db,flakes){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._forward_time_travel[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,flakes);
} else {
var m__4426__auto__ = (fluree.db.dbproto._forward_time_travel["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,flakes);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-forward-time-travel",db);
}
}
});
var G__13609__3 = (function (db,tt_id,flakes){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._forward_time_travel[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,tt_id,flakes);
} else {
var m__4426__auto__ = (fluree.db.dbproto._forward_time_travel["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,tt_id,flakes);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-forward-time-travel",db);
}
}
});
G__13609 = function(db,tt_id,flakes){
switch(arguments.length){
case 2:
return G__13609__2.call(this,db,tt_id);
case 3:
return G__13609__3.call(this,db,tt_id,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13609.cljs$core$IFn$_invoke$arity$2 = G__13609__2;
G__13609.cljs$core$IFn$_invoke$arity$3 = G__13609__3;
return G__13609;
})()
;
fluree.db.dbproto._forward_time_travel = (function fluree$db$dbproto$_forward_time_travel(var_args){
var G__13597 = arguments.length;
switch (G__13597) {
case 2:
return fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2(db,flakes);
} else {
return fluree$db$dbproto$IFlureeDb$_forward_time_travel$dyn_13608.call(null,db,flakes);
}
}));

(fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$3 = (function (db,tt_id,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3(db,tt_id,flakes);
} else {
return fluree$db$dbproto$IFlureeDb$_forward_time_travel$dyn_13608.call(null,db,tt_id,flakes);
}
}));

(fluree.db.dbproto._forward_time_travel.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_c_prop$dyn_13611 = (function (db,property,collection){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._c_prop[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,property,collection);
} else {
var m__4426__auto__ = (fluree.db.dbproto._c_prop["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,property,collection);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-c-prop",db);
}
}
});
/**
 * Returns schema property for a collection.
 */
fluree.db.dbproto._c_prop = (function fluree$db$dbproto$_c_prop(db,property,collection){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(db,property,collection);
} else {
return fluree$db$dbproto$IFlureeDb$_c_prop$dyn_13611.call(null,db,property,collection);
}
});

var fluree$db$dbproto$IFlureeDb$_p_prop$dyn_13612 = (function (db,property,predicate){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._p_prop[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,property,predicate);
} else {
var m__4426__auto__ = (fluree.db.dbproto._p_prop["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,property,predicate);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-p-prop",db);
}
}
});
/**
 * Returns the property specified for the given predicate.
 */
fluree.db.dbproto._p_prop = (function fluree$db$dbproto$_p_prop(db,property,predicate){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(db,property,predicate);
} else {
return fluree$db$dbproto$IFlureeDb$_p_prop$dyn_13612.call(null,db,property,predicate);
}
});

var fluree$db$dbproto$IFlureeDb$_tag$dyn_13613 = (function() {
var G__13614 = null;
var G__13614__2 = (function (db,tag_id){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._tag[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,tag_id);
} else {
var m__4426__auto__ = (fluree.db.dbproto._tag["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,tag_id);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-tag",db);
}
}
});
var G__13614__3 = (function (db,tag_id,pred){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._tag[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,tag_id,pred);
} else {
var m__4426__auto__ = (fluree.db.dbproto._tag["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,tag_id,pred);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-tag",db);
}
}
});
G__13614 = function(db,tag_id,pred){
switch(arguments.length){
case 2:
return G__13614__2.call(this,db,tag_id);
case 3:
return G__13614__3.call(this,db,tag_id,pred);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13614.cljs$core$IFn$_invoke$arity$2 = G__13614__2;
G__13614.cljs$core$IFn$_invoke$arity$3 = G__13614__3;
return G__13614;
})()
;
/**
 * Returns resolved tag, shortens namespace if pred provided.
 */
fluree.db.dbproto._tag = (function fluree$db$dbproto$_tag(var_args){
var G__13599 = arguments.length;
switch (G__13599) {
case 2:
return fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2 = (function (db,tag_id){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag$arity$2(db,tag_id);
} else {
return fluree$db$dbproto$IFlureeDb$_tag$dyn_13613.call(null,db,tag_id);
}
}));

(fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3 = (function (db,tag_id,pred){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag$arity$3(db,tag_id,pred);
} else {
return fluree$db$dbproto$IFlureeDb$_tag$dyn_13613.call(null,db,tag_id,pred);
}
}));

(fluree.db.dbproto._tag.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_tag_id$dyn_13616 = (function() {
var G__13617 = null;
var G__13617__2 = (function (db,tag_name){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._tag_id[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,tag_name);
} else {
var m__4426__auto__ = (fluree.db.dbproto._tag_id["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,tag_name);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-tag-id",db);
}
}
});
var G__13617__3 = (function (db,tag_name,pred){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._tag_id[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,tag_name,pred);
} else {
var m__4426__auto__ = (fluree.db.dbproto._tag_id["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,tag_name,pred);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-tag-id",db);
}
}
});
G__13617 = function(db,tag_name,pred){
switch(arguments.length){
case 2:
return G__13617__2.call(this,db,tag_name);
case 3:
return G__13617__3.call(this,db,tag_name,pred);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13617.cljs$core$IFn$_invoke$arity$2 = G__13617__2;
G__13617.cljs$core$IFn$_invoke$arity$3 = G__13617__3;
return G__13617;
})()
;
/**
 * Returns the tag sid. If pred provided will namespace tag if not already.
 */
fluree.db.dbproto._tag_id = (function fluree$db$dbproto$_tag_id(var_args){
var G__13601 = arguments.length;
switch (G__13601) {
case 2:
return fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2 = (function (db,tag_name){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(db,tag_name);
} else {
return fluree$db$dbproto$IFlureeDb$_tag_id$dyn_13616.call(null,db,tag_name);
}
}));

(fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$3 = (function (db,tag_name,pred){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3(db,tag_name,pred);
} else {
return fluree$db$dbproto$IFlureeDb$_tag_id$dyn_13616.call(null,db,tag_name,pred);
}
}));

(fluree.db.dbproto._tag_id.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_subid$dyn_13619 = (function() {
var G__13620 = null;
var G__13620__2 = (function (db,ident){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._subid[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,ident);
} else {
var m__4426__auto__ = (fluree.db.dbproto._subid["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,ident);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-subid",db);
}
}
});
var G__13620__3 = (function (db,ident,strict_QMARK_){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._subid[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,ident,strict_QMARK_);
} else {
var m__4426__auto__ = (fluree.db.dbproto._subid["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,ident,strict_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-subid",db);
}
}
});
G__13620 = function(db,ident,strict_QMARK_){
switch(arguments.length){
case 2:
return G__13620__2.call(this,db,ident);
case 3:
return G__13620__3.call(this,db,ident,strict_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13620.cljs$core$IFn$_invoke$arity$2 = G__13620__2;
G__13620.cljs$core$IFn$_invoke$arity$3 = G__13620__3;
return G__13620;
})()
;
/**
 * Returns subject ID if exists, else nil
 */
fluree.db.dbproto._subid = (function fluree$db$dbproto$_subid(var_args){
var G__13603 = arguments.length;
switch (G__13603) {
case 2:
return fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2 = (function (db,ident){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_subid$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_subid$arity$2(db,ident);
} else {
return fluree$db$dbproto$IFlureeDb$_subid$dyn_13619.call(null,db,ident);
}
}));

(fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3 = (function (db,ident,strict_QMARK_){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_subid$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_subid$arity$3(db,ident,strict_QMARK_);
} else {
return fluree$db$dbproto$IFlureeDb$_subid$dyn_13619.call(null,db,ident,strict_QMARK_);
}
}));

(fluree.db.dbproto._subid.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_search$dyn_13622 = (function (db,fparts){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._search[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,fparts);
} else {
var m__4426__auto__ = (fluree.db.dbproto._search["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,fparts);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-search",db);
}
}
});
/**
 * Performs a slice, but determines best index to use.
 */
fluree.db.dbproto._search = (function fluree$db$dbproto$_search(db,fparts){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_search$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_search$arity$2(db,fparts);
} else {
return fluree$db$dbproto$IFlureeDb$_search$dyn_13622.call(null,db,fparts);
}
});

var fluree$db$dbproto$IFlureeDb$_query$dyn_13623 = (function() {
var G__13624 = null;
var G__13624__2 = (function (db,query){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._query[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,query);
} else {
var m__4426__auto__ = (fluree.db.dbproto._query["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,query);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-query",db);
}
}
});
var G__13624__3 = (function (db,query,opts){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._query[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,query,opts);
} else {
var m__4426__auto__ = (fluree.db.dbproto._query["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,query,opts);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-query",db);
}
}
});
G__13624 = function(db,query,opts){
switch(arguments.length){
case 2:
return G__13624__2.call(this,db,query);
case 3:
return G__13624__3.call(this,db,query,opts);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__13624.cljs$core$IFn$_invoke$arity$2 = G__13624__2;
G__13624.cljs$core$IFn$_invoke$arity$3 = G__13624__3;
return G__13624;
})()
;
/**
 * Performs a query.
 */
fluree.db.dbproto._query = (function fluree$db$dbproto$_query(var_args){
var G__13605 = arguments.length;
switch (G__13605) {
case 2:
return fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2 = (function (db,query){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_query$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_query$arity$2(db,query);
} else {
return fluree$db$dbproto$IFlureeDb$_query$dyn_13623.call(null,db,query);
}
}));

(fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$3 = (function (db,query,opts){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_query$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_query$arity$3(db,query,opts);
} else {
return fluree$db$dbproto$IFlureeDb$_query$dyn_13623.call(null,db,query,opts);
}
}));

(fluree.db.dbproto._query.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_with$dyn_13626 = (function (db,block,flakes){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._with[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,block,flakes);
} else {
var m__4426__auto__ = (fluree.db.dbproto._with["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,block,flakes);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-with",db);
}
}
});
/**
 * Applies flakes to this db as a new block with possibly multiple 't' transactions.
 */
fluree.db.dbproto._with = (function fluree$db$dbproto$_with(db,block,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_with$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_with$arity$3(db,block,flakes);
} else {
return fluree$db$dbproto$IFlureeDb$_with$dyn_13626.call(null,db,block,flakes);
}
});

var fluree$db$dbproto$IFlureeDb$_with_t$dyn_13627 = (function (db,flakes){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._with_t[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,flakes);
} else {
var m__4426__auto__ = (fluree.db.dbproto._with_t["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,flakes);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-with-t",db);
}
}
});
/**
 * Applies flakes to this db as a new 't', but retains current block.
 */
fluree.db.dbproto._with_t = (function fluree$db$dbproto$_with_t(db,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_with_t$arity$2(db,flakes);
} else {
return fluree$db$dbproto$IFlureeDb$_with_t$dyn_13627.call(null,db,flakes);
}
});

var fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$dyn_13628 = (function (db,pred_id){
var x__4428__auto__ = (((db == null))?null:db);
var m__4429__auto__ = (fluree.db.dbproto._add_predicate_to_idx[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return m__4429__auto__.call(null,db,pred_id);
} else {
var m__4426__auto__ = (fluree.db.dbproto._add_predicate_to_idx["_"]);
if((!((m__4426__auto__ == null)))){
return m__4426__auto__.call(null,db,pred_id);
} else {
throw cljs.core.missing_protocol.call(null,"IFlureeDb.-add-predicate-to-idx",db);
}
}
});
/**
 * Adds predicate to idx, return updated db.
 */
fluree.db.dbproto._add_predicate_to_idx = (function fluree$db$dbproto$_add_predicate_to_idx(db,pred_id){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2(db,pred_id);
} else {
return fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$dyn_13628.call(null,db,pred_id);
}
});

fluree.db.dbproto.db_QMARK_ = (function fluree$db$dbproto$db_QMARK_(db){
if((!((db == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === db.fluree$db$dbproto$IFlureeDb$)))){
return true;
} else {
if((!db.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,fluree.db.dbproto.IFlureeDb,db);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,fluree.db.dbproto.IFlureeDb,db);
}
});
