// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches.call(null,/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.call(null,["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__26182 = cljs.core.re_find.call(null,/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str.call(null,ledger));
var _ = cljs.core.nth.call(null,vec__26182,(0),null);
var network = cljs.core.nth.call(null,vec__26182,(1),null);
var maybe_alias = cljs.core.nth.call(null,vec__26182,(2),null);
if(cljs.core.truth_((function (){var and__4115__auto__ = network;
if(cljs.core.truth_(and__4115__auto__)){
return maybe_alias;
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-ledger-name","db/invalid-ledger-name",-1642293447)], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_26279){
var state_val_26280 = (state_26279[(1)]);
if((state_val_26280 === (7))){
var inst_26200 = (state_26279[(7)]);
var inst_26205 = inst_26200.cljs$lang$protocol_mask$partition0$;
var inst_26206 = (inst_26205 & (64));
var inst_26207 = inst_26200.cljs$core$ISeq$;
var inst_26208 = (cljs.core.PROTOCOL_SENTINEL === inst_26207);
var inst_26209 = ((inst_26206) || (inst_26208));
var state_26279__$1 = state_26279;
if(cljs.core.truth_(inst_26209)){
var statearr_26281_26327 = state_26279__$1;
(statearr_26281_26327[(1)] = (10));

} else {
var statearr_26282_26328 = state_26279__$1;
(statearr_26282_26328[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (20))){
var state_26279__$1 = state_26279;
var statearr_26283_26329 = state_26279__$1;
(statearr_26283_26329[(2)] = false);

(statearr_26283_26329[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (27))){
var inst_26225 = (state_26279[(8)]);
var inst_26199 = (state_26279[(9)]);
var inst_26222 = (state_26279[(10)]);
var inst_26263 = (state_26279[(2)]);
var inst_26264 = cljs.core.into.call(null,inst_26222,inst_26199);
var inst_26265 = new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(db);
var inst_26266 = cljs.core.swap_BANG_.call(null,inst_26265,cljs.core.empty);
var inst_26267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26268 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26269 = (new cljs.core.PersistentVector(null,2,(5),inst_26267,inst_26268,null));
var inst_26270 = cljs.core.assoc_in.call(null,db,inst_26269,inst_26264);
var inst_26271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26272 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26273 = (new cljs.core.PersistentVector(null,2,(5),inst_26271,inst_26272,null));
var inst_26274 = cljs.core.assoc_in.call(null,inst_26270,inst_26273,inst_26225);
var _ = (function (){var statearr_26284 = state_26279;
(statearr_26284[(4)] = cljs.core.rest.call(null,(state_26279[(4)])));

return statearr_26284;
})();
var state_26279__$1 = (function (){var statearr_26285 = state_26279;
(statearr_26285[(11)] = inst_26266);

(statearr_26285[(12)] = inst_26263);

return statearr_26285;
})();
var statearr_26286_26330 = state_26279__$1;
(statearr_26286_26330[(2)] = inst_26274);

(statearr_26286_26330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (1))){
var state_26279__$1 = state_26279;
var statearr_26287_26331 = state_26279__$1;
(statearr_26287_26331[(2)] = null);

(statearr_26287_26331[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (24))){
var inst_26225 = (state_26279[(8)]);
var inst_26250 = (state_26279[(2)]);
var inst_26251 = cljs.core.get.call(null,inst_26250,new cljs.core.Keyword(null,"novelty-min","novelty-min",556791300));
var inst_26252 = cljs.core.get.call(null,inst_26250,new cljs.core.Keyword(null,"novelty-max","novelty-max",1816916050));
var inst_26253 = (inst_26225 > inst_26252);
var state_26279__$1 = (function (){var statearr_26288 = state_26279;
(statearr_26288[(13)] = inst_26251);

return statearr_26288;
})();
if(cljs.core.truth_(inst_26253)){
var statearr_26289_26332 = state_26279__$1;
(statearr_26289_26332[(1)] = (25));

} else {
var statearr_26290_26333 = state_26279__$1;
(statearr_26290_26333[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (4))){
var inst_26185 = (state_26279[(2)]);
var state_26279__$1 = state_26279;
var statearr_26291_26334 = state_26279__$1;
(statearr_26291_26334[(2)] = inst_26185);

(statearr_26291_26334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (15))){
var inst_26229 = (state_26279[(14)]);
var inst_26199 = (state_26279[(9)]);
var inst_26221 = (state_26279[(2)]);
var inst_26222 = cljs.core.get.call(null,inst_26221,new cljs.core.Keyword(null,"post","post",269697687));
var inst_26223 = cljs.core.get.call(null,inst_26221,new cljs.core.Keyword(null,"size","size",1098693007));
var inst_26224 = fluree.db.flake.size_bytes.call(null,inst_26199);
var inst_26225 = (inst_26223 + inst_26224);
var inst_26226 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26227 = [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_26228 = (new cljs.core.PersistentVector(null,2,(5),inst_26226,inst_26227,null));
var inst_26229__$1 = cljs.core.get_in.call(null,db,inst_26228);
var inst_26231 = (inst_26229__$1 == null);
var inst_26232 = cljs.core.not.call(null,inst_26231);
var state_26279__$1 = (function (){var statearr_26292 = state_26279;
(statearr_26292[(14)] = inst_26229__$1);

(statearr_26292[(8)] = inst_26225);

(statearr_26292[(10)] = inst_26222);

return statearr_26292;
})();
if(inst_26232){
var statearr_26293_26335 = state_26279__$1;
(statearr_26293_26335[(1)] = (16));

} else {
var statearr_26294_26336 = state_26279__$1;
(statearr_26294_26336[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (21))){
var inst_26242 = (state_26279[(2)]);
var state_26279__$1 = state_26279;
var statearr_26295_26337 = state_26279__$1;
(statearr_26295_26337[(2)] = inst_26242);

(statearr_26295_26337[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (13))){
var inst_26200 = (state_26279[(7)]);
var inst_26218 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26200);
var state_26279__$1 = state_26279;
var statearr_26296_26338 = state_26279__$1;
(statearr_26296_26338[(2)] = inst_26218);

(statearr_26296_26338[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (22))){
var inst_26229 = (state_26279[(14)]);
var inst_26247 = cljs.core.apply.call(null,cljs.core.hash_map,inst_26229);
var state_26279__$1 = state_26279;
var statearr_26297_26339 = state_26279__$1;
(statearr_26297_26339[(2)] = inst_26247);

(statearr_26297_26339[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (6))){
var inst_26200 = (state_26279[(7)]);
var inst_26198 = (state_26279[(2)]);
var inst_26199 = fluree.db.util.async.throw_err.call(null,inst_26198);
var inst_26200__$1 = new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(db);
var inst_26202 = (inst_26200__$1 == null);
var inst_26203 = cljs.core.not.call(null,inst_26202);
var state_26279__$1 = (function (){var statearr_26298 = state_26279;
(statearr_26298[(7)] = inst_26200__$1);

(statearr_26298[(9)] = inst_26199);

return statearr_26298;
})();
if(inst_26203){
var statearr_26299_26340 = state_26279__$1;
(statearr_26299_26340[(1)] = (7));

} else {
var statearr_26300_26341 = state_26279__$1;
(statearr_26300_26341[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (25))){
var inst_26255 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_26256 = [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_26257 = [new cljs.core.Keyword("db","max-novelty-size","db/max-novelty-size",499694493),(400)];
var inst_26258 = cljs.core.PersistentHashMap.fromArrays(inst_26256,inst_26257);
var inst_26259 = cljs.core.ex_info.call(null,inst_26255,inst_26258);
var inst_26260 = (function(){throw inst_26259})();
var state_26279__$1 = state_26279;
var statearr_26301_26342 = state_26279__$1;
(statearr_26301_26342[(2)] = inst_26260);

(statearr_26301_26342[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (17))){
var state_26279__$1 = state_26279;
var statearr_26302_26343 = state_26279__$1;
(statearr_26302_26343[(2)] = false);

(statearr_26302_26343[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (3))){
var inst_26277 = (state_26279[(2)]);
var state_26279__$1 = state_26279;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26279__$1,inst_26277);
} else {
if((state_val_26280 === (12))){
var inst_26213 = (state_26279[(2)]);
var state_26279__$1 = state_26279;
var statearr_26303_26344 = state_26279__$1;
(statearr_26303_26344[(2)] = inst_26213);

(statearr_26303_26344[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (2))){
var _ = (function (){var statearr_26304 = state_26279;
(statearr_26304[(4)] = cljs.core.cons.call(null,(5),(state_26279[(4)])));

return statearr_26304;
})();
var inst_26193 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26194 = [pred_id];
var inst_26195 = (new cljs.core.PersistentVector(null,1,(5),inst_26193,inst_26194,null));
var inst_26196 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_26195);
var state_26279__$1 = state_26279;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26279__$1,(6),inst_26196);
} else {
if((state_val_26280 === (23))){
var inst_26229 = (state_26279[(14)]);
var state_26279__$1 = state_26279;
var statearr_26305_26345 = state_26279__$1;
(statearr_26305_26345[(2)] = inst_26229);

(statearr_26305_26345[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (19))){
var state_26279__$1 = state_26279;
var statearr_26306_26346 = state_26279__$1;
(statearr_26306_26346[(2)] = true);

(statearr_26306_26346[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (11))){
var state_26279__$1 = state_26279;
var statearr_26308_26347 = state_26279__$1;
(statearr_26308_26347[(2)] = false);

(statearr_26308_26347[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (9))){
var inst_26216 = (state_26279[(2)]);
var state_26279__$1 = state_26279;
if(cljs.core.truth_(inst_26216)){
var statearr_26309_26348 = state_26279__$1;
(statearr_26309_26348[(1)] = (13));

} else {
var statearr_26310_26349 = state_26279__$1;
(statearr_26310_26349[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (5))){
var _ = (function (){var statearr_26311 = state_26279;
(statearr_26311[(4)] = cljs.core.rest.call(null,(state_26279[(4)])));

return statearr_26311;
})();
var state_26279__$1 = state_26279;
var ex26307 = (state_26279__$1[(2)]);
var statearr_26312_26350 = state_26279__$1;
(statearr_26312_26350[(5)] = ex26307);


if((ex26307 instanceof Error)){
var statearr_26313_26351 = state_26279__$1;
(statearr_26313_26351[(1)] = (4));

(statearr_26313_26351[(5)] = null);

} else {
throw ex26307;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (14))){
var inst_26200 = (state_26279[(7)]);
var state_26279__$1 = state_26279;
var statearr_26314_26352 = state_26279__$1;
(statearr_26314_26352[(2)] = inst_26200);

(statearr_26314_26352[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (26))){
var state_26279__$1 = state_26279;
var statearr_26315_26353 = state_26279__$1;
(statearr_26315_26353[(2)] = null);

(statearr_26315_26353[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (16))){
var inst_26229 = (state_26279[(14)]);
var inst_26234 = inst_26229.cljs$lang$protocol_mask$partition0$;
var inst_26235 = (inst_26234 & (64));
var inst_26236 = inst_26229.cljs$core$ISeq$;
var inst_26237 = (cljs.core.PROTOCOL_SENTINEL === inst_26236);
var inst_26238 = ((inst_26235) || (inst_26237));
var state_26279__$1 = state_26279;
if(cljs.core.truth_(inst_26238)){
var statearr_26316_26354 = state_26279__$1;
(statearr_26316_26354[(1)] = (19));

} else {
var statearr_26317_26355 = state_26279__$1;
(statearr_26317_26355[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (10))){
var state_26279__$1 = state_26279;
var statearr_26318_26356 = state_26279__$1;
(statearr_26318_26356[(2)] = true);

(statearr_26318_26356[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (18))){
var inst_26245 = (state_26279[(2)]);
var state_26279__$1 = state_26279;
if(cljs.core.truth_(inst_26245)){
var statearr_26319_26357 = state_26279__$1;
(statearr_26319_26357[(1)] = (22));

} else {
var statearr_26320_26358 = state_26279__$1;
(statearr_26320_26358[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26280 === (8))){
var state_26279__$1 = state_26279;
var statearr_26321_26359 = state_26279__$1;
(statearr_26321_26359[(2)] = false);

(statearr_26321_26359[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto____0 = (function (){
var statearr_26322 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26322[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto__);

(statearr_26322[(1)] = (1));

return statearr_26322;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto____1 = (function (state_26279){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_26279);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e26323){var ex__2882__auto__ = e26323;
var statearr_26324_26360 = state_26279;
(statearr_26324_26360[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_26279[(4)]))){
var statearr_26325_26361 = state_26279;
(statearr_26325_26361[(1)] = cljs.core.first.call(null,(state_26279[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26362 = state_26279;
state_26279 = G__26362;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto__ = function(state_26279){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto____1.call(this,state_26279);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_26326 = f__2902__auto__.call(null);
(statearr_26326[(6)] = c__2901__auto__);

return statearr_26326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(db,flakes){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_26561){
var state_val_26562 = (state_26561[(1)]);
if((state_val_26562 === (7))){
var state_26561__$1 = state_26561;
var statearr_26563_26629 = state_26561__$1;
(statearr_26563_26629[(2)] = null);

(statearr_26563_26629[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (20))){
var inst_26487 = (state_26561[(7)]);
var inst_26454 = (state_26561[(8)]);
var inst_26403 = (state_26561[(9)]);
var inst_26483 = (state_26561[(10)]);
var inst_26485 = (state_26561[(11)]);
var inst_26484 = (state_26561[(12)]);
var inst_26404 = (state_26561[(13)]);
var inst_26486 = (state_26561[(14)]);
var inst_26497 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26498 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26499 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26500 = (new cljs.core.PersistentVector(null,2,(5),inst_26498,inst_26499,null));
var inst_26501 = cljs.core.get_in.call(null,inst_26454,inst_26500);
var inst_26502 = (inst_26403 + inst_26501);
var inst_26503 = [inst_26483,inst_26484,inst_26485,inst_26486,inst_26502];
var inst_26504 = cljs.core.PersistentHashMap.fromArrays(inst_26497,inst_26503);
var inst_26505 = cljs.core.assoc.call(null,inst_26454,new cljs.core.Keyword(null,"ecount","ecount",-879380887),inst_26487,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),inst_26504);
var state_26561__$1 = (function (){var statearr_26564 = state_26561;
(statearr_26564[(15)] = inst_26505);

return statearr_26564;
})();
if(cljs.core.truth_(inst_26404)){
var statearr_26565_26630 = state_26561__$1;
(statearr_26565_26630[(1)] = (23));

} else {
var statearr_26566_26631 = state_26561__$1;
(statearr_26566_26631[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (27))){
var inst_26505 = (state_26561[(15)]);
var state_26561__$1 = state_26561;
var statearr_26567_26632 = state_26561__$1;
(statearr_26567_26632[(2)] = inst_26505);

(statearr_26567_26632[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (1))){
var state_26561__$1 = state_26561;
var statearr_26568_26633 = state_26561__$1;
(statearr_26568_26633[(2)] = null);

(statearr_26568_26633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (24))){
var inst_26505 = (state_26561[(15)]);
var inst_26508 = new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(inst_26505);
var inst_26509 = (inst_26508 == null);
var state_26561__$1 = state_26561;
var statearr_26569_26634 = state_26561__$1;
(statearr_26569_26634[(2)] = inst_26509);

(statearr_26569_26634[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (39))){
var inst_26536 = (state_26561[(16)]);
var inst_26537 = (state_26561[(17)]);
var inst_26544 = (state_26561[(18)]);
var inst_26535 = (state_26561[(19)]);
var inst_26494 = (state_26561[(20)]);
var inst_26551 = (state_26561[(2)]);
var inst_26482 = inst_26494;
var inst_26483 = inst_26536;
var inst_26484 = inst_26537;
var inst_26485 = inst_26544;
var inst_26486 = inst_26551;
var inst_26487 = inst_26535;
var state_26561__$1 = (function (){var statearr_26570 = state_26561;
(statearr_26570[(7)] = inst_26487);

(statearr_26570[(10)] = inst_26483);

(statearr_26570[(11)] = inst_26485);

(statearr_26570[(12)] = inst_26484);

(statearr_26570[(21)] = inst_26482);

(statearr_26570[(14)] = inst_26486);

return statearr_26570;
})();
var statearr_26571_26635 = state_26561__$1;
(statearr_26571_26635[(2)] = null);

(statearr_26571_26635[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (4))){
var inst_26366 = (state_26561[(2)]);
var state_26561__$1 = state_26561;
var statearr_26572_26636 = state_26561__$1;
(statearr_26572_26636[(2)] = inst_26366);

(statearr_26572_26636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (15))){
var inst_26426 = (state_26561[(22)]);
var state_26561__$1 = state_26561;
var statearr_26573_26637 = state_26561__$1;
(statearr_26573_26637[(2)] = inst_26426);

(statearr_26573_26637[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (21))){
var inst_26390 = (state_26561[(23)]);
var inst_26487 = (state_26561[(7)]);
var inst_26493 = (state_26561[(24)]);
var inst_26394 = (state_26561[(25)]);
var inst_26464 = (state_26561[(26)]);
var inst_26398 = (state_26561[(27)]);
var inst_26454 = (state_26561[(8)]);
var inst_26373 = (state_26561[(28)]);
var inst_26403 = (state_26561[(9)]);
var inst_26483 = (state_26561[(10)]);
var inst_26485 = (state_26561[(11)]);
var inst_26484 = (state_26561[(12)]);
var inst_26463 = (state_26561[(29)]);
var inst_26407 = (state_26561[(30)]);
var inst_26413 = (state_26561[(31)]);
var inst_26388 = (state_26561[(32)]);
var inst_26405 = (state_26561[(33)]);
var inst_26482 = (state_26561[(21)]);
var inst_26404 = (state_26561[(13)]);
var inst_26494 = (state_26561[(20)]);
var inst_26402 = (state_26561[(34)]);
var inst_26486 = (state_26561[(14)]);
var inst_26532 = inst_26493.s;
var inst_26533 = fluree.db.flake.sid__GT_cid.call(null,inst_26532);
var inst_26534 = (function (){var flakes_bytes = inst_26403;
var t = inst_26373;
var vec__26459 = inst_26390;
var G__26458 = inst_26482;
var seq__26460 = inst_26464;
var spot = inst_26483;
var add_flakes = inst_26390;
var root_setting_change_QMARK_ = inst_26405;
var first__26491 = inst_26493;
var ref_QMARK__map = inst_26402;
var r = inst_26494;
var vec__26489 = inst_26482;
var psot = inst_26484;
var add_pred_to_idx_QMARK_ = inst_26413;
var _ = inst_26388;
var cid = inst_26533;
var ecount = inst_26487;
var first__26461 = inst_26463;
var seq__26490 = inst_26494;
var pred_ecount = inst_26407;
var db_STAR_ = inst_26454;
var schema_change_QMARK_ = inst_26404;
var add_preds = inst_26394;
var opst = inst_26486;
var idx_QMARK__map = inst_26398;
var post = inst_26485;
var f = inst_26493;
return (function (p1__26365_SHARP_){
if(cljs.core.truth_(p1__26365_SHARP_)){
var x__4214__auto__ = p1__26365_SHARP_;
var y__4215__auto__ = f.s;
return ((x__4214__auto__ > y__4215__auto__) ? x__4214__auto__ : y__4215__auto__);
} else {
return f.s;
}
});
})();
var inst_26535 = cljs.core.update.call(null,inst_26487,inst_26533,inst_26534);
var inst_26536 = cljs.core.conj.call(null,inst_26483,inst_26493);
var inst_26537 = cljs.core.conj.call(null,inst_26484,inst_26493);
var inst_26538 = inst_26493.p;
var inst_26539 = cljs.core.get.call(null,inst_26398,inst_26538);
var state_26561__$1 = (function (){var statearr_26574 = state_26561;
(statearr_26574[(16)] = inst_26536);

(statearr_26574[(17)] = inst_26537);

(statearr_26574[(19)] = inst_26535);

return statearr_26574;
})();
if(cljs.core.truth_(inst_26539)){
var statearr_26575_26638 = state_26561__$1;
(statearr_26575_26638[(1)] = (34));

} else {
var statearr_26576_26639 = state_26561__$1;
(statearr_26576_26639[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (31))){
var inst_26520 = (state_26561[(35)]);
var state_26561__$1 = state_26561;
var statearr_26577_26640 = state_26561__$1;
(statearr_26577_26640[(2)] = inst_26520);

(statearr_26577_26640[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (32))){
var inst_26530 = (state_26561[(2)]);
var state_26561__$1 = state_26561;
var statearr_26578_26641 = state_26561__$1;
(statearr_26578_26641[(2)] = inst_26530);

(statearr_26578_26641[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (33))){
var inst_26520 = (state_26561[(35)]);
var inst_26525 = (state_26561[(2)]);
var inst_26526 = fluree.db.util.async.throw_err.call(null,inst_26525);
var inst_26527 = cljs.core.assoc.call(null,inst_26520,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_26526);
var state_26561__$1 = state_26561;
var statearr_26579_26642 = state_26561__$1;
(statearr_26579_26642[(2)] = inst_26527);

(statearr_26579_26642[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (13))){
var inst_26390 = (state_26561[(23)]);
var inst_26454 = (state_26561[(8)]);
var inst_26373 = (state_26561[(28)]);
var inst_26403 = (state_26561[(9)]);
var inst_26444 = (state_26561[(2)]);
var inst_26445 = cljs.core.assoc.call(null,inst_26444,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26373);
var inst_26446 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26447 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_26448 = (new cljs.core.PersistentVector(null,2,(5),inst_26446,inst_26447,null));
var inst_26449 = cljs.core.update_in.call(null,inst_26445,inst_26448,cljs.core._PLUS_,inst_26403);
var inst_26450 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26451 = [new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_26452 = (new cljs.core.PersistentVector(null,2,(5),inst_26450,inst_26451,null));
var inst_26453 = cljs.core.count.call(null,inst_26390);
var inst_26454__$1 = cljs.core.update_in.call(null,inst_26449,inst_26452,cljs.core._PLUS_,inst_26453);
var inst_26462 = cljs.core.seq.call(null,inst_26390);
var inst_26463 = cljs.core.first.call(null,inst_26462);
var inst_26464 = cljs.core.next.call(null,inst_26462);
var inst_26465 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26466 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_26467 = (new cljs.core.PersistentVector(null,2,(5),inst_26465,inst_26466,null));
var inst_26468 = cljs.core.get_in.call(null,inst_26454__$1,inst_26467);
var inst_26469 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26470 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"psot","psot",2111653059)];
var inst_26471 = (new cljs.core.PersistentVector(null,2,(5),inst_26469,inst_26470,null));
var inst_26472 = cljs.core.get_in.call(null,inst_26454__$1,inst_26471);
var inst_26473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26474 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"post","post",269697687)];
var inst_26475 = (new cljs.core.PersistentVector(null,2,(5),inst_26473,inst_26474,null));
var inst_26476 = cljs.core.get_in.call(null,inst_26454__$1,inst_26475);
var inst_26477 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26478 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26479 = (new cljs.core.PersistentVector(null,2,(5),inst_26477,inst_26478,null));
var inst_26480 = cljs.core.get_in.call(null,inst_26454__$1,inst_26479);
var inst_26481 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26482 = inst_26390;
var inst_26483 = inst_26468;
var inst_26484 = inst_26472;
var inst_26485 = inst_26476;
var inst_26486 = inst_26480;
var inst_26487 = inst_26481;
var state_26561__$1 = (function (){var statearr_26580 = state_26561;
(statearr_26580[(7)] = inst_26487);

(statearr_26580[(26)] = inst_26464);

(statearr_26580[(8)] = inst_26454__$1);

(statearr_26580[(10)] = inst_26483);

(statearr_26580[(11)] = inst_26485);

(statearr_26580[(12)] = inst_26484);

(statearr_26580[(29)] = inst_26463);

(statearr_26580[(21)] = inst_26482);

(statearr_26580[(14)] = inst_26486);

return statearr_26580;
})();
var statearr_26581_26643 = state_26561__$1;
(statearr_26581_26643[(2)] = null);

(statearr_26581_26643[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (22))){
var inst_26554 = (state_26561[(2)]);
var state_26561__$1 = state_26561;
var statearr_26582_26644 = state_26561__$1;
(statearr_26582_26644[(2)] = inst_26554);

(statearr_26582_26644[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (36))){
var inst_26493 = (state_26561[(24)]);
var inst_26402 = (state_26561[(34)]);
var inst_26544 = (state_26561[(2)]);
var inst_26545 = inst_26493.p;
var inst_26546 = cljs.core.get.call(null,inst_26402,inst_26545);
var state_26561__$1 = (function (){var statearr_26583 = state_26561;
(statearr_26583[(18)] = inst_26544);

return statearr_26583;
})();
if(cljs.core.truth_(inst_26546)){
var statearr_26584_26645 = state_26561__$1;
(statearr_26584_26645[(1)] = (37));

} else {
var statearr_26585_26646 = state_26561__$1;
(statearr_26585_26646[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (29))){
var inst_26505 = (state_26561[(15)]);
var inst_26515 = (state_26561[(2)]);
var inst_26516 = fluree.db.util.async.throw_err.call(null,inst_26515);
var inst_26517 = cljs.core.assoc.call(null,inst_26505,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_26516);
var state_26561__$1 = state_26561;
var statearr_26586_26647 = state_26561__$1;
(statearr_26586_26647[(2)] = inst_26517);

(statearr_26586_26647[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (6))){
var inst_26373 = (state_26561[(28)]);
var inst_26378 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26379 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26380 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26378)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26379)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26373),"."].join('');
var inst_26381 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26382 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26383 = cljs.core.PersistentHashMap.fromArrays(inst_26381,inst_26382);
var inst_26384 = cljs.core.ex_info.call(null,inst_26380,inst_26383);
var inst_26385 = (function(){throw inst_26384})();
var state_26561__$1 = state_26561;
var statearr_26587_26648 = state_26561__$1;
(statearr_26587_26648[(2)] = inst_26385);

(statearr_26587_26648[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (28))){
var inst_26405 = (state_26561[(33)]);
var inst_26520 = (state_26561[(2)]);
var state_26561__$1 = (function (){var statearr_26588 = state_26561;
(statearr_26588[(35)] = inst_26520);

return statearr_26588;
})();
if(cljs.core.truth_(inst_26405)){
var statearr_26589_26649 = state_26561__$1;
(statearr_26589_26649[(1)] = (30));

} else {
var statearr_26590_26650 = state_26561__$1;
(statearr_26590_26650[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (25))){
var inst_26511 = (state_26561[(2)]);
var state_26561__$1 = state_26561;
if(cljs.core.truth_(inst_26511)){
var statearr_26591_26651 = state_26561__$1;
(statearr_26591_26651[(1)] = (26));

} else {
var statearr_26592_26652 = state_26561__$1;
(statearr_26592_26652[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (34))){
var inst_26493 = (state_26561[(24)]);
var inst_26485 = (state_26561[(11)]);
var inst_26541 = cljs.core.conj.call(null,inst_26485,inst_26493);
var state_26561__$1 = state_26561;
var statearr_26593_26653 = state_26561__$1;
(statearr_26593_26653[(2)] = inst_26541);

(statearr_26593_26653[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (17))){
var inst_26433 = (state_26561[(36)]);
var inst_26437 = (state_26561[(2)]);
var inst_26438 = fluree.db.util.async.throw_err.call(null,inst_26437);
var inst_26425 = inst_26433;
var inst_26426 = inst_26438;
var state_26561__$1 = (function (){var statearr_26594 = state_26561;
(statearr_26594[(22)] = inst_26426);

(statearr_26594[(37)] = inst_26425);

return statearr_26594;
})();
var statearr_26595_26654 = state_26561__$1;
(statearr_26595_26654[(2)] = null);

(statearr_26595_26654[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (3))){
var inst_26559 = (state_26561[(2)]);
var state_26561__$1 = state_26561;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26561__$1,inst_26559);
} else {
if((state_val_26562 === (12))){
var inst_26432 = (state_26561[(38)]);
var inst_26425 = (state_26561[(37)]);
var inst_26431 = cljs.core.seq.call(null,inst_26425);
var inst_26432__$1 = cljs.core.first.call(null,inst_26431);
var inst_26433 = cljs.core.next.call(null,inst_26431);
var state_26561__$1 = (function (){var statearr_26596 = state_26561;
(statearr_26596[(36)] = inst_26433);

(statearr_26596[(38)] = inst_26432__$1);

return statearr_26596;
})();
if(cljs.core.truth_(inst_26432__$1)){
var statearr_26597_26655 = state_26561__$1;
(statearr_26597_26655[(1)] = (14));

} else {
var statearr_26598_26656 = state_26561__$1;
(statearr_26598_26656[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (2))){
var inst_26373 = (state_26561[(28)]);
var _ = (function (){var statearr_26599 = state_26561;
(statearr_26599[(4)] = cljs.core.cons.call(null,(5),(state_26561[(4)])));

return statearr_26599;
})();
var inst_26372 = cljs.core.first.call(null,flakes);
var inst_26373__$1 = inst_26372.t;
var inst_26374 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_26375 = (inst_26374 - (1));
var inst_26376 = cljs.core.not_EQ_.call(null,inst_26373__$1,inst_26375);
var state_26561__$1 = (function (){var statearr_26600 = state_26561;
(statearr_26600[(28)] = inst_26373__$1);

return statearr_26600;
})();
if(inst_26376){
var statearr_26601_26657 = state_26561__$1;
(statearr_26601_26657[(1)] = (6));

} else {
var statearr_26602_26658 = state_26561__$1;
(statearr_26602_26658[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (23))){
var inst_26404 = (state_26561[(13)]);
var state_26561__$1 = state_26561;
var statearr_26603_26659 = state_26561__$1;
(statearr_26603_26659[(2)] = inst_26404);

(statearr_26603_26659[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (35))){
var inst_26485 = (state_26561[(11)]);
var state_26561__$1 = state_26561;
var statearr_26604_26660 = state_26561__$1;
(statearr_26604_26660[(2)] = inst_26485);

(statearr_26604_26660[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (19))){
var inst_26556 = (state_26561[(2)]);
var _ = (function (){var statearr_26605 = state_26561;
(statearr_26605[(4)] = cljs.core.rest.call(null,(state_26561[(4)])));

return statearr_26605;
})();
var state_26561__$1 = state_26561;
var statearr_26606_26661 = state_26561__$1;
(statearr_26606_26661[(2)] = inst_26556);

(statearr_26606_26661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (11))){
var inst_26413 = (state_26561[(31)]);
var inst_26413__$1 = (state_26561[(2)]);
var inst_26421 = cljs.core.seq.call(null,inst_26413__$1);
var inst_26422 = cljs.core.first.call(null,inst_26421);
var inst_26423 = cljs.core.next.call(null,inst_26421);
var inst_26424 = db;
var inst_26425 = inst_26413__$1;
var inst_26426 = inst_26424;
var state_26561__$1 = (function (){var statearr_26608 = state_26561;
(statearr_26608[(39)] = inst_26423);

(statearr_26608[(22)] = inst_26426);

(statearr_26608[(31)] = inst_26413__$1);

(statearr_26608[(40)] = inst_26422);

(statearr_26608[(37)] = inst_26425);

return statearr_26608;
})();
var statearr_26609_26662 = state_26561__$1;
(statearr_26609_26662[(2)] = null);

(statearr_26609_26662[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (9))){
var inst_26390 = (state_26561[(23)]);
var inst_26407 = (state_26561[(30)]);
var inst_26409 = fluree.db.util.schema.add_to_post_preds_QMARK_.call(null,inst_26390,inst_26407);
var state_26561__$1 = state_26561;
var statearr_26610_26663 = state_26561__$1;
(statearr_26610_26663[(2)] = inst_26409);

(statearr_26610_26663[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (5))){
var _ = (function (){var statearr_26611 = state_26561;
(statearr_26611[(4)] = cljs.core.rest.call(null,(state_26561[(4)])));

return statearr_26611;
})();
var state_26561__$1 = state_26561;
var ex26607 = (state_26561__$1[(2)]);
var statearr_26612_26664 = state_26561__$1;
(statearr_26612_26664[(5)] = ex26607);


if((ex26607 instanceof Error)){
var statearr_26613_26665 = state_26561__$1;
(statearr_26613_26665[(1)] = (4));

(statearr_26613_26665[(5)] = null);

} else {
throw ex26607;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (14))){
var inst_26426 = (state_26561[(22)]);
var inst_26432 = (state_26561[(38)]);
var inst_26435 = fluree.db.graphdb.add_predicate_to_idx.call(null,inst_26426,inst_26432);
var state_26561__$1 = state_26561;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26561__$1,(17),inst_26435);
} else {
if((state_val_26562 === (26))){
var inst_26505 = (state_26561[(15)]);
var inst_26513 = fluree.db.query.schema.schema_map.call(null,inst_26505);
var state_26561__$1 = state_26561;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26561__$1,(29),inst_26513);
} else {
if((state_val_26562 === (16))){
var inst_26442 = (state_26561[(2)]);
var state_26561__$1 = state_26561;
var statearr_26614_26666 = state_26561__$1;
(statearr_26614_26666[(2)] = inst_26442);

(statearr_26614_26666[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (38))){
var inst_26486 = (state_26561[(14)]);
var state_26561__$1 = state_26561;
var statearr_26615_26667 = state_26561__$1;
(statearr_26615_26667[(2)] = inst_26486);

(statearr_26615_26667[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (30))){
var inst_26520 = (state_26561[(35)]);
var inst_26523 = fluree.db.query.schema.setting_map.call(null,inst_26520);
var state_26561__$1 = state_26561;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26561__$1,(33),inst_26523);
} else {
if((state_val_26562 === (10))){
var inst_26411 = cljs.core.PersistentVector.EMPTY;
var state_26561__$1 = state_26561;
var statearr_26616_26668 = state_26561__$1;
(statearr_26616_26668[(2)] = inst_26411);

(statearr_26616_26668[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (18))){
var inst_26493 = (state_26561[(24)]);
var inst_26482 = (state_26561[(21)]);
var inst_26492 = cljs.core.seq.call(null,inst_26482);
var inst_26493__$1 = cljs.core.first.call(null,inst_26492);
var inst_26494 = cljs.core.next.call(null,inst_26492);
var inst_26495 = cljs.core.not.call(null,inst_26493__$1);
var state_26561__$1 = (function (){var statearr_26617 = state_26561;
(statearr_26617[(24)] = inst_26493__$1);

(statearr_26617[(20)] = inst_26494);

return statearr_26617;
})();
if(inst_26495){
var statearr_26618_26669 = state_26561__$1;
(statearr_26618_26669[(1)] = (20));

} else {
var statearr_26619_26670 = state_26561__$1;
(statearr_26619_26670[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (37))){
var inst_26493 = (state_26561[(24)]);
var inst_26486 = (state_26561[(14)]);
var inst_26548 = cljs.core.conj.call(null,inst_26486,inst_26493);
var state_26561__$1 = state_26561;
var statearr_26620_26671 = state_26561__$1;
(statearr_26620_26671[(2)] = inst_26548);

(statearr_26620_26671[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26562 === (8))){
var inst_26390 = (state_26561[(23)]);
var inst_26394 = (state_26561[(25)]);
var inst_26398 = (state_26561[(27)]);
var inst_26373 = (state_26561[(28)]);
var inst_26388 = (state_26561[(32)]);
var inst_26404 = (state_26561[(13)]);
var inst_26388__$1 = (state_26561[(2)]);
var inst_26389 = (function (){var t = inst_26373;
var _ = inst_26388__$1;
return (function (p1__26363_SHARP_){
return cljs.core.not.call(null,fluree.db.graphdb.exclude_predicates.call(null,p1__26363_SHARP_.p));
});
})();
var inst_26390__$1 = cljs.core.filter.call(null,inst_26389,flakes);
var inst_26391 = cljs.core.PersistentHashSet.EMPTY;
var inst_26392 = (function (){var t = inst_26373;
var _ = inst_26388__$1;
var add_flakes = inst_26390__$1;
return (function (p1__26364_SHARP_){
return p1__26364_SHARP_.p;
});
})();
var inst_26393 = cljs.core.map.call(null,inst_26392,inst_26390__$1);
var inst_26394__$1 = cljs.core.into.call(null,inst_26391,inst_26393);
var inst_26395 = cljs.core.PersistentHashMap.EMPTY;
var inst_26396 = (function (){var t = inst_26373;
var _ = inst_26388__$1;
var add_flakes = inst_26390__$1;
var add_preds = inst_26394__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p)], null);
});
})();
var inst_26397 = cljs.core.map.call(null,inst_26396,inst_26394__$1);
var inst_26398__$1 = cljs.core.into.call(null,inst_26395,inst_26397);
var inst_26399 = cljs.core.PersistentHashMap.EMPTY;
var inst_26400 = (function (){var t = inst_26373;
var _ = inst_26388__$1;
var add_flakes = inst_26390__$1;
var add_preds = inst_26394__$1;
var idx_QMARK__map = inst_26398__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p)], null);
});
})();
var inst_26401 = cljs.core.map.call(null,inst_26400,inst_26394__$1);
var inst_26402 = cljs.core.into.call(null,inst_26399,inst_26401);
var inst_26403 = fluree.db.flake.size_bytes.call(null,inst_26390__$1);
var inst_26404__$1 = fluree.db.util.schema.schema_change_QMARK_.call(null,inst_26390__$1);
var inst_26405 = fluree.db.util.schema.setting_change_QMARK_.call(null,inst_26390__$1);
var inst_26406 = new cljs.core.Keyword(null,"ecount","ecount",-879380887).cljs$core$IFn$_invoke$arity$1(db);
var inst_26407 = cljs.core.get.call(null,inst_26406,(0));
var state_26561__$1 = (function (){var statearr_26621 = state_26561;
(statearr_26621[(23)] = inst_26390__$1);

(statearr_26621[(25)] = inst_26394__$1);

(statearr_26621[(27)] = inst_26398__$1);

(statearr_26621[(9)] = inst_26403);

(statearr_26621[(30)] = inst_26407);

(statearr_26621[(32)] = inst_26388__$1);

(statearr_26621[(33)] = inst_26405);

(statearr_26621[(13)] = inst_26404__$1);

(statearr_26621[(34)] = inst_26402);

return statearr_26621;
})();
if(cljs.core.truth_(inst_26404__$1)){
var statearr_26622_26672 = state_26561__$1;
(statearr_26622_26672[(1)] = (9));

} else {
var statearr_26623_26673 = state_26561__$1;
(statearr_26623_26673[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$with_t_$_state_machine__2879__auto__ = null;
var fluree$db$graphdb$with_t_$_state_machine__2879__auto____0 = (function (){
var statearr_26624 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26624[(0)] = fluree$db$graphdb$with_t_$_state_machine__2879__auto__);

(statearr_26624[(1)] = (1));

return statearr_26624;
});
var fluree$db$graphdb$with_t_$_state_machine__2879__auto____1 = (function (state_26561){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_26561);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e26625){var ex__2882__auto__ = e26625;
var statearr_26626_26674 = state_26561;
(statearr_26626_26674[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_26561[(4)]))){
var statearr_26627_26675 = state_26561;
(statearr_26627_26675[(1)] = cljs.core.first.call(null,(state_26561[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26676 = state_26561;
state_26561 = G__26676;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$with_t_$_state_machine__2879__auto__ = function(state_26561){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_t_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_t_$_state_machine__2879__auto____1.call(this,state_26561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_t_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_t_$_state_machine__2879__auto____0;
fluree$db$graphdb$with_t_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_t_$_state_machine__2879__auto____1;
return fluree$db$graphdb$with_t_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_26628 = f__2902__auto__.call(null);
(statearr_26628[(6)] = c__2901__auto__);

return statearr_26628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(db,block,flakes){
var resp_ch = cljs.core.async.promise_chan.call(null);
var c__2901__auto___26822 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_26772){
var state_val_26773 = (state_26772[(1)]);
if((state_val_26773 === (7))){
var state_26772__$1 = state_26772;
var statearr_26774_26823 = state_26772__$1;
(statearr_26774_26823[(2)] = null);

(statearr_26774_26823[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (20))){
var inst_26722 = (state_26772[(7)]);
var inst_26721 = (state_26772[(8)]);
var inst_26720 = (state_26772[(9)]);
var inst_26741 = (inst_26720 + (1));
var inst_26742 = cljs.core.assoc.call(null,inst_26722,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26741);
var inst_26743 = fluree.db.graphdb.with_t.call(null,inst_26742,inst_26721);
var state_26772__$1 = state_26772;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26772__$1,(23),inst_26743);
} else {
if((state_val_26773 === (1))){
var state_26772__$1 = state_26772;
var statearr_26775_26824 = state_26772__$1;
(statearr_26775_26824[(2)] = null);

(statearr_26775_26824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (24))){
var inst_26746 = (state_26772[(10)]);
var inst_26749 = cljs.core.assoc.call(null,inst_26746,new cljs.core.Keyword(null,"block","block",664686210),block);
var state_26772__$1 = state_26772;
var statearr_26776_26825 = state_26772__$1;
(statearr_26776_26825[(2)] = inst_26749);

(statearr_26776_26825[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (4))){
var inst_26677 = (state_26772[(2)]);
var inst_26678 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26677);
var state_26772__$1 = state_26772;
var statearr_26777_26826 = state_26772__$1;
(statearr_26777_26826[(2)] = inst_26678);

(statearr_26777_26826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (15))){
var inst_26728 = (state_26772[(11)]);
var state_26772__$1 = state_26772;
var statearr_26778_26827 = state_26772__$1;
(statearr_26778_26827[(2)] = inst_26728);

(statearr_26778_26827[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (21))){
var state_26772__$1 = state_26772;
var statearr_26779_26828 = state_26772__$1;
(statearr_26779_26828[(2)] = null);

(statearr_26779_26828[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (13))){
var inst_26764 = (state_26772[(2)]);
var inst_26765 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26764);
var state_26772__$1 = state_26772;
var statearr_26780_26829 = state_26772__$1;
(statearr_26780_26829[(2)] = inst_26765);

(statearr_26780_26829[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (22))){
var inst_26760 = (state_26772[(2)]);
var state_26772__$1 = state_26772;
var statearr_26781_26830 = state_26772__$1;
(statearr_26781_26830[(2)] = inst_26760);

(statearr_26781_26830[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (6))){
var inst_26688 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(db);
var inst_26689 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26690 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26688)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_26689)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_26691 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26692 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_26693 = cljs.core.PersistentHashMap.fromArrays(inst_26691,inst_26692);
var inst_26694 = cljs.core.ex_info.call(null,inst_26690,inst_26693);
var inst_26695 = (function(){throw inst_26694})();
var state_26772__$1 = state_26772;
var statearr_26784_26831 = state_26772__$1;
(statearr_26784_26831[(2)] = inst_26695);

(statearr_26784_26831[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (25))){
var inst_26728 = (state_26772[(11)]);
var inst_26729 = (state_26772[(12)]);
var inst_26746 = (state_26772[(10)]);
var inst_26751 = inst_26728.t;
var inst_26752 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26753 = [inst_26728];
var inst_26754 = (new cljs.core.PersistentVector(null,1,(5),inst_26752,inst_26753,null));
var inst_26719 = inst_26729;
var inst_26720 = inst_26751;
var inst_26721 = inst_26754;
var inst_26722 = inst_26746;
var state_26772__$1 = (function (){var statearr_26785 = state_26772;
(statearr_26785[(7)] = inst_26722);

(statearr_26785[(13)] = inst_26719);

(statearr_26785[(8)] = inst_26721);

(statearr_26785[(9)] = inst_26720);

return statearr_26785;
})();
var statearr_26786_26832 = state_26772__$1;
(statearr_26786_26832[(2)] = null);

(statearr_26786_26832[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (17))){
var inst_26722 = (state_26772[(7)]);
var inst_26728 = (state_26772[(11)]);
var inst_26729 = (state_26772[(12)]);
var inst_26721 = (state_26772[(8)]);
var inst_26720 = (state_26772[(9)]);
var inst_26737 = cljs.core.conj.call(null,inst_26721,inst_26728);
var tmp26782 = inst_26722;
var tmp26783 = inst_26720;
var inst_26719 = inst_26729;
var inst_26720__$1 = tmp26783;
var inst_26721__$1 = inst_26737;
var inst_26722__$1 = tmp26782;
var state_26772__$1 = (function (){var statearr_26787 = state_26772;
(statearr_26787[(7)] = inst_26722__$1);

(statearr_26787[(13)] = inst_26719);

(statearr_26787[(8)] = inst_26721__$1);

(statearr_26787[(9)] = inst_26720__$1);

return statearr_26787;
})();
var statearr_26788_26833 = state_26772__$1;
(statearr_26788_26833[(2)] = null);

(statearr_26788_26833[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (3))){
var inst_26770 = (state_26772[(2)]);
var state_26772__$1 = state_26772;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26772__$1,inst_26770);
} else {
if((state_val_26773 === (12))){
var inst_26728 = (state_26772[(11)]);
var inst_26719 = (state_26772[(13)]);
var inst_26727 = cljs.core.seq.call(null,inst_26719);
var inst_26728__$1 = cljs.core.first.call(null,inst_26727);
var inst_26729 = cljs.core.next.call(null,inst_26727);
var state_26772__$1 = (function (){var statearr_26789 = state_26772;
(statearr_26789[(11)] = inst_26728__$1);

(statearr_26789[(12)] = inst_26729);

return statearr_26789;
})();
if(cljs.core.truth_(inst_26728__$1)){
var statearr_26790_26834 = state_26772__$1;
(statearr_26790_26834[(1)] = (14));

} else {
var statearr_26791_26835 = state_26772__$1;
(statearr_26791_26835[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (2))){
var _ = (function (){var statearr_26792 = state_26772;
(statearr_26792[(4)] = cljs.core.cons.call(null,(5),(state_26772[(4)])));

return statearr_26792;
})();
var inst_26684 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_26685 = (inst_26684 + (1));
var inst_26686 = cljs.core.not_EQ_.call(null,block,inst_26685);
var state_26772__$1 = state_26772;
if(inst_26686){
var statearr_26793_26836 = state_26772__$1;
(statearr_26793_26836[(1)] = (6));

} else {
var statearr_26794_26837 = state_26772__$1;
(statearr_26794_26837[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (23))){
var inst_26728 = (state_26772[(11)]);
var inst_26745 = (state_26772[(2)]);
var inst_26746 = fluree.db.util.async.throw_err.call(null,inst_26745);
var inst_26747 = (inst_26728 == null);
var state_26772__$1 = (function (){var statearr_26795 = state_26772;
(statearr_26795[(10)] = inst_26746);

return statearr_26795;
})();
if(cljs.core.truth_(inst_26747)){
var statearr_26796_26838 = state_26772__$1;
(statearr_26796_26838[(1)] = (24));

} else {
var statearr_26797_26839 = state_26772__$1;
(statearr_26797_26839[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (19))){
var inst_26762 = (state_26772[(2)]);
var state_26772__$1 = state_26772;
var statearr_26798_26840 = state_26772__$1;
(statearr_26798_26840[(2)] = inst_26762);

(statearr_26798_26840[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (11))){
var inst_26767 = (state_26772[(2)]);
var _ = (function (){var statearr_26800 = state_26772;
(statearr_26800[(4)] = cljs.core.rest.call(null,(state_26772[(4)])));

return statearr_26800;
})();
var state_26772__$1 = state_26772;
var statearr_26801_26841 = state_26772__$1;
(statearr_26801_26841[(2)] = inst_26767);

(statearr_26801_26841[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (9))){
var inst_26701 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"block","block",664686210),block);
var inst_26702 = cljs.core.async.put_BANG_.call(null,resp_ch,inst_26701);
var state_26772__$1 = state_26772;
var statearr_26802_26842 = state_26772__$1;
(statearr_26802_26842[(2)] = inst_26702);

(statearr_26802_26842[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (5))){
var _ = (function (){var statearr_26803 = state_26772;
(statearr_26803[(4)] = cljs.core.rest.call(null,(state_26772[(4)])));

return statearr_26803;
})();
var state_26772__$1 = state_26772;
var ex26799 = (state_26772__$1[(2)]);
var statearr_26804_26843 = state_26772__$1;
(statearr_26804_26843[(5)] = ex26799);


var statearr_26805_26844 = state_26772__$1;
(statearr_26805_26844[(1)] = (4));

(statearr_26805_26844[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (14))){
var inst_26728 = (state_26772[(11)]);
var inst_26720 = (state_26772[(9)]);
var inst_26731 = inst_26728.t;
var inst_26732 = cljs.core._EQ_.call(null,inst_26720,inst_26731);
var state_26772__$1 = state_26772;
var statearr_26806_26845 = state_26772__$1;
(statearr_26806_26845[(2)] = inst_26732);

(statearr_26806_26845[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (26))){
var inst_26757 = (state_26772[(2)]);
var state_26772__$1 = state_26772;
var statearr_26807_26846 = state_26772__$1;
(statearr_26807_26846[(2)] = inst_26757);

(statearr_26807_26846[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (16))){
var inst_26735 = (state_26772[(2)]);
var state_26772__$1 = state_26772;
if(cljs.core.truth_(inst_26735)){
var statearr_26808_26847 = state_26772__$1;
(statearr_26808_26847[(1)] = (17));

} else {
var statearr_26809_26848 = state_26772__$1;
(statearr_26809_26848[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (10))){
var inst_26704 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_block,flakes);
var inst_26712 = cljs.core.seq.call(null,inst_26704);
var inst_26713 = cljs.core.first.call(null,inst_26712);
var inst_26714 = cljs.core.next.call(null,inst_26712);
var inst_26715 = cljs.core.first.call(null,inst_26704);
var inst_26716 = inst_26715.t;
var inst_26717 = cljs.core.PersistentVector.EMPTY;
var inst_26718 = db;
var inst_26719 = inst_26704;
var inst_26720 = inst_26716;
var inst_26721 = inst_26717;
var inst_26722 = inst_26718;
var state_26772__$1 = (function (){var statearr_26810 = state_26772;
(statearr_26810[(14)] = inst_26714);

(statearr_26810[(7)] = inst_26722);

(statearr_26810[(13)] = inst_26719);

(statearr_26810[(15)] = inst_26713);

(statearr_26810[(8)] = inst_26721);

(statearr_26810[(9)] = inst_26720);

return statearr_26810;
})();
var statearr_26811_26849 = state_26772__$1;
(statearr_26811_26849[(2)] = null);

(statearr_26811_26849[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (18))){
var state_26772__$1 = state_26772;
var statearr_26812_26850 = state_26772__$1;
(statearr_26812_26850[(1)] = (20));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26773 === (8))){
var inst_26698 = (state_26772[(2)]);
var inst_26699 = cljs.core.empty_QMARK_.call(null,flakes);
var state_26772__$1 = (function (){var statearr_26814 = state_26772;
(statearr_26814[(16)] = inst_26698);

return statearr_26814;
})();
if(inst_26699){
var statearr_26815_26851 = state_26772__$1;
(statearr_26815_26851[(1)] = (9));

} else {
var statearr_26816_26852 = state_26772__$1;
(statearr_26816_26852[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$with_$_state_machine__2879__auto__ = null;
var fluree$db$graphdb$with_$_state_machine__2879__auto____0 = (function (){
var statearr_26817 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26817[(0)] = fluree$db$graphdb$with_$_state_machine__2879__auto__);

(statearr_26817[(1)] = (1));

return statearr_26817;
});
var fluree$db$graphdb$with_$_state_machine__2879__auto____1 = (function (state_26772){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_26772);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e26818){var ex__2882__auto__ = e26818;
var statearr_26819_26853 = state_26772;
(statearr_26819_26853[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_26772[(4)]))){
var statearr_26820_26854 = state_26772;
(statearr_26820_26854[(1)] = cljs.core.first.call(null,(state_26772[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26855 = state_26772;
state_26772 = G__26855;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$with_$_state_machine__2879__auto__ = function(state_26772){
switch(arguments.length){
case 0:
return fluree$db$graphdb$with_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$with_$_state_machine__2879__auto____1.call(this,state_26772);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$with_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$with_$_state_machine__2879__auto____0;
fluree$db$graphdb$with_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$with_$_state_machine__2879__auto____1;
return fluree$db$graphdb$with_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_26821 = f__2902__auto__.call(null);
(statearr_26821[(6)] = c__2901__auto___26822);

return statearr_26821;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));


return resp_ch;
});
/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_26911){
var state_val_26912 = (state_26911[(1)]);
if((state_val_26912 === (7))){
var state_26911__$1 = state_26911;
var statearr_26913_26940 = state_26911__$1;
(statearr_26913_26940[(2)] = tt_id);

(statearr_26913_26940[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26912 === (1))){
var state_26911__$1 = state_26911;
var statearr_26914_26941 = state_26911__$1;
(statearr_26914_26941[(2)] = null);

(statearr_26914_26941[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26912 === (4))){
var inst_26856 = (state_26911[(2)]);
var state_26911__$1 = state_26911;
var statearr_26915_26942 = state_26911__$1;
(statearr_26915_26942[(2)] = inst_26856);

(statearr_26915_26942[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26912 === (13))){
var inst_26904 = (state_26911[(2)]);
var state_26911__$1 = state_26911;
var statearr_26916_26943 = state_26911__$1;
(statearr_26916_26943[(2)] = inst_26904);

(statearr_26916_26943[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26912 === (6))){
var inst_26864 = fluree.db.util.core.random_uuid.call(null);
var state_26911__$1 = state_26911;
var statearr_26917_26944 = state_26911__$1;
(statearr_26917_26944[(2)] = inst_26864);

(statearr_26917_26944[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26912 === (3))){
var inst_26909 = (state_26911[(2)]);
var state_26911__$1 = state_26911;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_26911__$1,inst_26909);
} else {
if((state_val_26912 === (12))){
var inst_26887 = (state_26911[(7)]);
var state_26911__$1 = state_26911;
var statearr_26918_26945 = state_26911__$1;
(statearr_26918_26945[(2)] = inst_26887);

(statearr_26918_26945[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26912 === (2))){
var _ = (function (){var statearr_26919 = state_26911;
(statearr_26919[(4)] = cljs.core.cons.call(null,(5),(state_26911[(4)])));

return statearr_26919;
})();
var inst_26862 = (tt_id == null);
var state_26911__$1 = state_26911;
if(cljs.core.truth_(inst_26862)){
var statearr_26920_26946 = state_26911__$1;
(statearr_26920_26946[(1)] = (6));

} else {
var statearr_26921_26947 = state_26911__$1;
(statearr_26921_26947[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26912 === (11))){
var inst_26887 = (state_26911[(7)]);
var inst_26894 = (state_26911[(8)]);
var inst_26897 = fluree.db.graphdb.with_t.call(null,inst_26887,inst_26894);
var state_26911__$1 = state_26911;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_26911__$1,(14),inst_26897);
} else {
if((state_val_26912 === (9))){
var inst_26888 = (state_26911[(9)]);
var inst_26894 = (state_26911[(8)]);
var inst_26893 = cljs.core.seq.call(null,inst_26888);
var inst_26894__$1 = cljs.core.first.call(null,inst_26893);
var inst_26895 = cljs.core.next.call(null,inst_26893);
var state_26911__$1 = (function (){var statearr_26923 = state_26911;
(statearr_26923[(10)] = inst_26895);

(statearr_26923[(8)] = inst_26894__$1);

return statearr_26923;
})();
if(cljs.core.truth_(inst_26894__$1)){
var statearr_26924_26948 = state_26911__$1;
(statearr_26924_26948[(1)] = (11));

} else {
var statearr_26925_26949 = state_26911__$1;
(statearr_26925_26949[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26912 === (5))){
var _ = (function (){var statearr_26926 = state_26911;
(statearr_26926[(4)] = cljs.core.rest.call(null,(state_26911[(4)])));

return statearr_26926;
})();
var state_26911__$1 = state_26911;
var ex26922 = (state_26911__$1[(2)]);
var statearr_26927_26950 = state_26911__$1;
(statearr_26927_26950[(5)] = ex26922);


if((ex26922 instanceof Error)){
var statearr_26928_26951 = state_26911__$1;
(statearr_26928_26951[(1)] = (4));

(statearr_26928_26951[(5)] = null);

} else {
throw ex26922;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26912 === (14))){
var inst_26895 = (state_26911[(10)]);
var inst_26899 = (state_26911[(2)]);
var inst_26900 = fluree.db.util.async.throw_err.call(null,inst_26899);
var inst_26887 = inst_26900;
var inst_26888 = inst_26895;
var state_26911__$1 = (function (){var statearr_26929 = state_26911;
(statearr_26929[(7)] = inst_26887);

(statearr_26929[(9)] = inst_26888);

return statearr_26929;
})();
var statearr_26930_26952 = state_26911__$1;
(statearr_26930_26952[(2)] = null);

(statearr_26930_26952[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26912 === (10))){
var inst_26906 = (state_26911[(2)]);
var _ = (function (){var statearr_26931 = state_26911;
(statearr_26931[(4)] = cljs.core.rest.call(null,(state_26911[(4)])));

return statearr_26931;
})();
var state_26911__$1 = state_26911;
var statearr_26932_26953 = state_26911__$1;
(statearr_26932_26953[(2)] = inst_26906);

(statearr_26932_26953[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_26912 === (8))){
var inst_26867 = (state_26911[(2)]);
var inst_26868 = (function (){var tt_id_SINGLEQUOTE_ = inst_26867;
return (function (db_STAR_,idx){
return cljs.core.assoc.call(null,db_STAR_,idx,cljs.core.assoc.call(null,cljs.core.get.call(null,db_STAR_,idx),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),tt_id_SINGLEQUOTE_));
});
})();
var inst_26869 = cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),inst_26867);
var inst_26870 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26871 = [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)];
var inst_26872 = (new cljs.core.PersistentVector(null,4,(5),inst_26870,inst_26871,null));
var inst_26873 = cljs.core.reduce.call(null,inst_26868,inst_26869,inst_26872);
var inst_26874 = cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),flakes);
var inst_26875 = cljs.core.reverse.call(null,inst_26874);
var inst_26876 = cljs.core.partition_by.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),inst_26875);
var inst_26884 = cljs.core.seq.call(null,inst_26876);
var inst_26885 = cljs.core.first.call(null,inst_26884);
var inst_26886 = cljs.core.next.call(null,inst_26884);
var inst_26887 = inst_26873;
var inst_26888 = inst_26876;
var state_26911__$1 = (function (){var statearr_26933 = state_26911;
(statearr_26933[(7)] = inst_26887);

(statearr_26933[(9)] = inst_26888);

(statearr_26933[(11)] = inst_26885);

(statearr_26933[(12)] = inst_26886);

return statearr_26933;
})();
var statearr_26934_26954 = state_26911__$1;
(statearr_26934_26954[(2)] = null);

(statearr_26934_26954[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto____0 = (function (){
var statearr_26935 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26935[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto__);

(statearr_26935[(1)] = (1));

return statearr_26935;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto____1 = (function (state_26911){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_26911);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e26936){var ex__2882__auto__ = e26936;
var statearr_26937_26955 = state_26911;
(statearr_26937_26955[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_26911[(4)]))){
var statearr_26938_26956 = state_26911;
(statearr_26938_26956[(1)] = cljs.core.first.call(null,(state_26911[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26957 = state_26911;
state_26911 = G__26957;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto__ = function(state_26911){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto____1.call(this,state_26911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_26939 = f__2902__auto__.call(null);
(statearr_26939[(6)] = c__2901__auto__);

return statearr_26939;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.call(null);
var c__2901__auto___27135 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_27072){
var state_val_27073 = (state_27072[(1)]);
if((state_val_27073 === (7))){
var inst_26985 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var inst_26986 = cljs.core.first.call(null,ident);
var inst_26987 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_26986);
var inst_26988 = (inst_26987 == null);
var inst_26989 = ((inst_26985) && (inst_26988));
var state_27072__$1 = state_27072;
if(cljs.core.truth_(inst_26989)){
var statearr_27074_27136 = state_27072__$1;
(statearr_27074_27136[(1)] = (13));

} else {
var statearr_27075_27137 = state_27072__$1;
(statearr_27075_27137[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (20))){
var state_27072__$1 = state_27072;
var statearr_27076_27138 = state_27072__$1;
(statearr_27076_27138[(2)] = null);

(statearr_27076_27138[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (27))){
var state_27072__$1 = state_27072;
var statearr_27077_27139 = state_27072__$1;
(statearr_27077_27139[(2)] = null);

(statearr_27077_27139[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (1))){
var state_27072__$1 = state_27072;
var statearr_27078_27140 = state_27072__$1;
(statearr_27078_27140[(2)] = null);

(statearr_27078_27140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (24))){
var inst_27018 = (state_27072[(7)]);
var inst_27022 = inst_27018.s;
var state_27072__$1 = state_27072;
var statearr_27079_27141 = state_27072__$1;
(statearr_27079_27141[(2)] = inst_27022);

(statearr_27079_27141[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (39))){
var state_27072__$1 = state_27072;
var statearr_27080_27142 = state_27072__$1;
(statearr_27080_27142[(2)] = null);

(statearr_27080_27142[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (4))){
var inst_26958 = (state_27072[(2)]);
var inst_26959 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_26960 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26961 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_26962 = cljs.core.PersistentHashMap.fromArrays(inst_26960,inst_26961);
var inst_26963 = cljs.core.ex_info.call(null,inst_26959,inst_26962,inst_26958);
var inst_26964 = cljs.core.async.put_BANG_.call(null,return_chan,inst_26963);
var state_27072__$1 = state_27072;
var statearr_27081_27143 = state_27072__$1;
(statearr_27081_27143[(2)] = inst_26964);

(statearr_27081_27143[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (15))){
var inst_27040 = (state_27072[(2)]);
var state_27072__$1 = state_27072;
var statearr_27082_27144 = state_27072__$1;
(statearr_27082_27144[(2)] = inst_27040);

(statearr_27082_27144[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (21))){
var inst_27012 = (state_27072[(8)]);
var inst_27016 = cljs.core.first.call(null,inst_27012);
var state_27072__$1 = state_27072;
var statearr_27083_27145 = state_27072__$1;
(statearr_27083_27145[(2)] = inst_27016);

(statearr_27083_27145[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (31))){
var inst_27067 = (state_27072[(2)]);
var _ = (function (){var statearr_27084 = state_27072;
(statearr_27084[(4)] = cljs.core.rest.call(null,(state_27072[(4)])));

return statearr_27084;
})();
var state_27072__$1 = state_27072;
var statearr_27085_27146 = state_27072__$1;
(statearr_27085_27146[(2)] = inst_27067);

(statearr_27085_27146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (32))){
var state_27072__$1 = state_27072;
var statearr_27086_27147 = state_27072__$1;
(statearr_27086_27147[(2)] = strict_QMARK_);

(statearr_27086_27147[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (40))){
var inst_27063 = (state_27072[(2)]);
var state_27072__$1 = state_27072;
var statearr_27087_27148 = state_27072__$1;
(statearr_27087_27148[(2)] = inst_27063);

(statearr_27087_27148[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (33))){
var state_27072__$1 = state_27072;
var statearr_27088_27149 = state_27072__$1;
(statearr_27088_27149[(2)] = false);

(statearr_27088_27149[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (13))){
var inst_26991 = cljs.core.first.call(null,ident);
var inst_26992 = cljs.core.pr_str.call(null,inst_26991);
var inst_26993 = ["Subject ID lookup failed. The predicate ",inst_26992," does not exist."].join('');
var inst_26994 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_26995 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_26996 = cljs.core.PersistentHashMap.fromArrays(inst_26994,inst_26995);
var inst_26997 = cljs.core.ex_info.call(null,inst_26993,inst_26996);
var inst_26998 = (function(){throw inst_26997})();
var state_27072__$1 = state_27072;
var statearr_27089_27150 = state_27072__$1;
(statearr_27089_27150[(2)] = inst_26998);

(statearr_27089_27150[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (22))){
var inst_27018 = (state_27072[(7)]);
var inst_27018__$1 = (state_27072[(2)]);
var inst_27019 = (inst_27018__$1 == null);
var state_27072__$1 = (function (){var statearr_27090 = state_27072;
(statearr_27090[(7)] = inst_27018__$1);

return statearr_27090;
})();
if(cljs.core.truth_(inst_27019)){
var statearr_27091_27151 = state_27072__$1;
(statearr_27091_27151[(1)] = (23));

} else {
var statearr_27092_27152 = state_27072__$1;
(statearr_27092_27152[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (36))){
var state_27072__$1 = state_27072;
var statearr_27093_27153 = state_27072__$1;
(statearr_27093_27153[(1)] = (38));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (29))){
var inst_27042 = (state_27072[(9)]);
var inst_27044 = cljs.core.async.put_BANG_.call(null,return_chan,inst_27042);
var state_27072__$1 = state_27072;
var statearr_27095_27154 = state_27072__$1;
(statearr_27095_27154[(2)] = inst_27044);

(statearr_27095_27154[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (6))){
var inst_26972 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26973 = [ident];
var inst_26974 = (new cljs.core.PersistentVector(null,1,(5),inst_26972,inst_26973,null));
var inst_26975 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_26974);
var state_27072__$1 = state_27072;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27072__$1,(9),inst_26975);
} else {
if((state_val_27073 === (28))){
var inst_27036 = (state_27072[(2)]);
var state_27072__$1 = state_27072;
var statearr_27096_27155 = state_27072__$1;
(statearr_27096_27155[(2)] = inst_27036);

(statearr_27096_27155[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (25))){
var inst_27024 = (state_27072[(2)]);
var state_27072__$1 = state_27072;
var statearr_27097_27156 = state_27072__$1;
(statearr_27097_27156[(2)] = inst_27024);

(statearr_27097_27156[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (34))){
var inst_27050 = (state_27072[(2)]);
var state_27072__$1 = state_27072;
if(cljs.core.truth_(inst_27050)){
var statearr_27098_27157 = state_27072__$1;
(statearr_27098_27157[(1)] = (35));

} else {
var statearr_27099_27158 = state_27072__$1;
(statearr_27099_27158[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (17))){
var state_27072__$1 = state_27072;
var statearr_27100_27159 = state_27072__$1;
(statearr_27100_27159[(1)] = (26));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (3))){
var inst_27070 = (state_27072[(2)]);
var state_27072__$1 = state_27072;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27072__$1,inst_27070);
} else {
if((state_val_27073 === (12))){
var inst_26983 = (state_27072[(2)]);
var state_27072__$1 = state_27072;
var statearr_27102_27160 = state_27072__$1;
(statearr_27102_27160[(2)] = inst_26983);

(statearr_27102_27160[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (2))){
var _ = (function (){var statearr_27103 = state_27072;
(statearr_27103[(4)] = cljs.core.cons.call(null,(5),(state_27072[(4)])));

return statearr_27103;
})();
var inst_26970 = typeof ident === 'number';
var state_27072__$1 = state_27072;
if(cljs.core.truth_(inst_26970)){
var statearr_27104_27161 = state_27072__$1;
(statearr_27104_27161[(1)] = (6));

} else {
var statearr_27105_27162 = state_27072__$1;
(statearr_27105_27162[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (23))){
var state_27072__$1 = state_27072;
var statearr_27106_27163 = state_27072__$1;
(statearr_27106_27163[(2)] = null);

(statearr_27106_27163[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (35))){
var inst_27052 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_27053 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27054 = [(400),new cljs.core.Keyword("db","invalid-subject","db/invalid-subject",-8172837)];
var inst_27055 = cljs.core.PersistentHashMap.fromArrays(inst_27053,inst_27054);
var inst_27056 = cljs.core.ex_info.call(null,inst_27052,inst_27055);
var inst_27057 = cljs.core.async.put_BANG_.call(null,return_chan,inst_27056);
var state_27072__$1 = state_27072;
var statearr_27107_27164 = state_27072__$1;
(statearr_27107_27164[(2)] = inst_27057);

(statearr_27107_27164[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (19))){
var inst_27012 = (state_27072[(8)]);
var inst_27011 = (state_27072[(2)]);
var inst_27012__$1 = fluree.db.util.async.throw_err.call(null,inst_27011);
var inst_27013 = (inst_27012__$1 == null);
var state_27072__$1 = (function (){var statearr_27108 = state_27072;
(statearr_27108[(8)] = inst_27012__$1);

return statearr_27108;
})();
if(cljs.core.truth_(inst_27013)){
var statearr_27109_27165 = state_27072__$1;
(statearr_27109_27165[(1)] = (20));

} else {
var statearr_27110_27166 = state_27072__$1;
(statearr_27110_27166[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (11))){
var state_27072__$1 = state_27072;
var statearr_27112_27167 = state_27072__$1;
(statearr_27112_27167[(2)] = null);

(statearr_27112_27167[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (9))){
var inst_26977 = (state_27072[(2)]);
var inst_26978 = fluree.db.util.async.throw_err.call(null,inst_26977);
var inst_26979 = cljs.core.not_empty.call(null,inst_26978);
var state_27072__$1 = state_27072;
if(cljs.core.truth_(inst_26979)){
var statearr_27113_27168 = state_27072__$1;
(statearr_27113_27168[(1)] = (10));

} else {
var statearr_27114_27169 = state_27072__$1;
(statearr_27114_27169[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (5))){
var _ = (function (){var statearr_27115 = state_27072;
(statearr_27115[(4)] = cljs.core.rest.call(null,(state_27072[(4)])));

return statearr_27115;
})();
var state_27072__$1 = state_27072;
var ex27111 = (state_27072__$1[(2)]);
var statearr_27116_27170 = state_27072__$1;
(statearr_27116_27170[(5)] = ex27111);


var statearr_27117_27171 = state_27072__$1;
(statearr_27117_27171[(1)] = (4));

(statearr_27117_27171[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (14))){
var inst_27000 = fluree.db.util.core.pred_ident_QMARK_.call(null,ident);
var state_27072__$1 = state_27072;
if(inst_27000){
var statearr_27118_27172 = state_27072__$1;
(statearr_27118_27172[(1)] = (16));

} else {
var statearr_27119_27173 = state_27072__$1;
(statearr_27119_27173[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (26))){
var inst_27027 = cljs.core.pr_str.call(null,ident);
var inst_27028 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_27027].join('');
var inst_27029 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27030 = [(400),new cljs.core.Keyword("db","invalid-ident","db/invalid-ident",939019721)];
var inst_27031 = cljs.core.PersistentHashMap.fromArrays(inst_27029,inst_27030);
var inst_27032 = cljs.core.ex_info.call(null,inst_27028,inst_27031);
var inst_27033 = (function(){throw inst_27032})();
var state_27072__$1 = state_27072;
var statearr_27120_27174 = state_27072__$1;
(statearr_27120_27174[(2)] = inst_27033);

(statearr_27120_27174[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (16))){
var inst_27003 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27004 = cljs.core.first.call(null,ident);
var inst_27005 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),inst_27004);
var inst_27006 = cljs.core.second.call(null,ident);
var inst_27007 = [inst_27005,inst_27006];
var inst_27008 = (new cljs.core.PersistentVector(null,2,(5),inst_27003,inst_27007,null));
var inst_27009 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27008);
var state_27072__$1 = state_27072;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27072__$1,(19),inst_27009);
} else {
if((state_val_27073 === (38))){
var inst_27060 = cljs.core.async.close_BANG_.call(null,return_chan);
var state_27072__$1 = state_27072;
var statearr_27121_27175 = state_27072__$1;
(statearr_27121_27175[(2)] = inst_27060);

(statearr_27121_27175[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (30))){
var inst_27042 = (state_27072[(9)]);
var inst_27046 = (inst_27042 == null);
var state_27072__$1 = state_27072;
if(cljs.core.truth_(inst_27046)){
var statearr_27122_27176 = state_27072__$1;
(statearr_27122_27176[(1)] = (32));

} else {
var statearr_27123_27177 = state_27072__$1;
(statearr_27123_27177[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (10))){
var state_27072__$1 = state_27072;
var statearr_27124_27178 = state_27072__$1;
(statearr_27124_27178[(2)] = ident);

(statearr_27124_27178[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (18))){
var inst_27038 = (state_27072[(2)]);
var state_27072__$1 = state_27072;
var statearr_27125_27179 = state_27072__$1;
(statearr_27125_27179[(2)] = inst_27038);

(statearr_27125_27179[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (37))){
var inst_27065 = (state_27072[(2)]);
var state_27072__$1 = state_27072;
var statearr_27126_27180 = state_27072__$1;
(statearr_27126_27180[(2)] = inst_27065);

(statearr_27126_27180[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27073 === (8))){
var inst_27042 = (state_27072[(9)]);
var inst_27042__$1 = (state_27072[(2)]);
var state_27072__$1 = (function (){var statearr_27127 = state_27072;
(statearr_27127[(9)] = inst_27042__$1);

return statearr_27127;
})();
if(cljs.core.truth_(inst_27042__$1)){
var statearr_27128_27181 = state_27072__$1;
(statearr_27128_27181[(1)] = (29));

} else {
var statearr_27129_27182 = state_27072__$1;
(statearr_27129_27182[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__2879__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__2879__auto____0 = (function (){
var statearr_27130 = [null,null,null,null,null,null,null,null,null,null];
(statearr_27130[(0)] = fluree$db$graphdb$subid_$_state_machine__2879__auto__);

(statearr_27130[(1)] = (1));

return statearr_27130;
});
var fluree$db$graphdb$subid_$_state_machine__2879__auto____1 = (function (state_27072){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_27072);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e27131){var ex__2882__auto__ = e27131;
var statearr_27132_27183 = state_27072;
(statearr_27132_27183[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_27072[(4)]))){
var statearr_27133_27184 = state_27072;
(statearr_27133_27184[(1)] = cljs.core.first.call(null,(state_27072[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27185 = state_27072;
state_27072 = G__27185;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__2879__auto__ = function(state_27072){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__2879__auto____1.call(this,state_27072);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__2879__auto____0;
fluree$db$graphdb$subid_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__2879__auto____1;
return fluree$db$graphdb$subid_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_27134 = f__2902__auto__.call(null);
(statearr_27134[(6)] = c__2901__auto___27135);

return statearr_27134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k27187,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__27191 = k27187;
var G__27191__$1 = (((G__27191 instanceof cljs.core.Keyword))?G__27191.fqn:null);
switch (G__27191__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k27187,else__4383__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__27192){
var vec__27193 = p__27192;
var k__4403__auto__ = cljs.core.nth.call(null,vec__27193,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__27193,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"post","post",269697687),self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27186){
var self__ = this;
var G__27186__$1 = this;
return (new cljs.core.RecordIter((0),G__27186__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (20 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27188,other27189){
var self__ = this;
var this27188__$1 = this;
return (((!((other27189 == null)))) && ((this27188__$1.constructor === other27189.constructor)) && (cljs.core._EQ_.call(null,this27188__$1.conn,other27189.conn)) && (cljs.core._EQ_.call(null,this27188__$1.network,other27189.network)) && (cljs.core._EQ_.call(null,this27188__$1.dbid,other27189.dbid)) && (cljs.core._EQ_.call(null,this27188__$1.block,other27189.block)) && (cljs.core._EQ_.call(null,this27188__$1.t,other27189.t)) && (cljs.core._EQ_.call(null,this27188__$1.tt_id,other27189.tt_id)) && (cljs.core._EQ_.call(null,this27188__$1.stats,other27189.stats)) && (cljs.core._EQ_.call(null,this27188__$1.spot,other27189.spot)) && (cljs.core._EQ_.call(null,this27188__$1.psot,other27189.psot)) && (cljs.core._EQ_.call(null,this27188__$1.post,other27189.post)) && (cljs.core._EQ_.call(null,this27188__$1.opst,other27189.opst)) && (cljs.core._EQ_.call(null,this27188__$1.schema,other27189.schema)) && (cljs.core._EQ_.call(null,this27188__$1.settings,other27189.settings)) && (cljs.core._EQ_.call(null,this27188__$1.index_configs,other27189.index_configs)) && (cljs.core._EQ_.call(null,this27188__$1.schema_cache,other27189.schema_cache)) && (cljs.core._EQ_.call(null,this27188__$1.novelty,other27189.novelty)) && (cljs.core._EQ_.call(null,this27188__$1.permissions,other27189.permissions)) && (cljs.core._EQ_.call(null,this27188__$1.fork,other27189.fork)) && (cljs.core._EQ_.call(null,this27188__$1.fork_block,other27189.fork_block)) && (cljs.core._EQ_.call(null,this27188__$1.current_db_fn,other27189.current_db_fn)) && (cljs.core._EQ_.call(null,this27188__$1.__extmap,other27189.__extmap)));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),null,new cljs.core.Keyword(null,"schema","schema",-1582001791),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"psot","psot",2111653059),null,new cljs.core.Keyword(null,"permissions","permissions",67803075),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"settings","settings",1556144875),null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),null,new cljs.core.Keyword(null,"opst","opst",1213963058),null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"fork","fork",1062974235),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"stats","stats",-85643011),null,new cljs.core.Keyword(null,"spot","spot",-1706962147),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__27186){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__27196 = cljs.core.keyword_identical_QMARK_;
var expr__27197 = k__4388__auto__;
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__27197))){
return (new fluree.db.graphdb.GraphDb(G__27186,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__27197))){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__27186,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__27197))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__27186,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__27197))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__27186,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__27197))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__27186,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__27197))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__27186,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"stats","stats",-85643011),expr__27197))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__27186,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),expr__27197))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__27186,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"psot","psot",2111653059),expr__27197))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__27186,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"post","post",269697687),expr__27197))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__27186,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"opst","opst",1213963058),expr__27197))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__27186,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"schema","schema",-1582001791),expr__27197))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__27186,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"settings","settings",1556144875),expr__27197))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__27186,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),expr__27197))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__27186,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__27197))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__27186,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"novelty","novelty",-1590246024),expr__27197))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__27186,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"permissions","permissions",67803075),expr__27197))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__27186,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"fork","fork",1062974235),expr__27197))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__27186,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"fork-block","fork-block",178387923),expr__27197))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__27186,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27196.call(null,new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),expr__27197))){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__27186,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__27186),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"stats","stats",-85643011),self__.stats,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"spot","spot",-1706962147),self__.spot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"psot","psot",2111653059),self__.psot,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"post","post",269697687),self__.post,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"opst","opst",1213963058),self__.opst,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema","schema",-1582001791),self__.schema,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"settings","settings",1556144875),self__.settings,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),self__.index_configs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"novelty","novelty",-1590246024),self__.novelty,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork","fork",1062974235),self__.fork,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"fork-block","fork-block",178387923),self__.fork_block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336),self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__27186){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__27186,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_27214){
var state_val_27215 = (state_27214[(1)]);
if((state_val_27215 === (1))){
var state_27214__$1 = state_27214;
var statearr_27216_27479 = state_27214__$1;
(statearr_27216_27479[(2)] = null);

(statearr_27216_27479[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27215 === (2))){
var _ = (function (){var statearr_27217 = state_27214;
(statearr_27217[(4)] = cljs.core.cons.call(null,(5),(state_27214[(4)])));

return statearr_27217;
})();
var inst_27205 = self__.current_db_fn.call(null);
var state_27214__$1 = state_27214;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27214__$1,(6),inst_27205);
} else {
if((state_val_27215 === (3))){
var inst_27212 = (state_27214[(2)]);
var state_27214__$1 = state_27214;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27214__$1,inst_27212);
} else {
if((state_val_27215 === (4))){
var inst_27199 = (state_27214[(2)]);
var state_27214__$1 = state_27214;
var statearr_27219_27480 = state_27214__$1;
(statearr_27219_27480[(2)] = inst_27199);

(statearr_27219_27480[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27215 === (5))){
var _ = (function (){var statearr_27220 = state_27214;
(statearr_27220[(4)] = cljs.core.rest.call(null,(state_27214[(4)])));

return statearr_27220;
})();
var state_27214__$1 = state_27214;
var ex27218 = (state_27214__$1[(2)]);
var statearr_27221_27481 = state_27214__$1;
(statearr_27221_27481[(5)] = ex27218);


if((ex27218 instanceof Error)){
var statearr_27222_27482 = state_27214__$1;
(statearr_27222_27482[(1)] = (4));

(statearr_27222_27482[(5)] = null);

} else {
throw ex27218;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27215 === (6))){
var inst_27207 = (state_27214[(2)]);
var inst_27208 = fluree.db.util.async.throw_err.call(null,inst_27207);
var inst_27209 = cljs.core.assoc.call(null,inst_27208,new cljs.core.Keyword(null,"permissions","permissions",67803075),self__.permissions);
var _ = (function (){var statearr_27223 = state_27214;
(statearr_27223[(4)] = cljs.core.rest.call(null,(state_27214[(4)])));

return statearr_27223;
})();
var state_27214__$1 = state_27214;
var statearr_27224_27483 = state_27214__$1;
(statearr_27224_27483[(2)] = inst_27209);

(statearr_27224_27483[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2879__auto__ = null;
var fluree$db$graphdb$state_machine__2879__auto____0 = (function (){
var statearr_27225 = [null,null,null,null,null,null,null];
(statearr_27225[(0)] = fluree$db$graphdb$state_machine__2879__auto__);

(statearr_27225[(1)] = (1));

return statearr_27225;
});
var fluree$db$graphdb$state_machine__2879__auto____1 = (function (state_27214){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_27214);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e27226){var ex__2882__auto__ = e27226;
var statearr_27227_27484 = state_27214;
(statearr_27227_27484[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_27214[(4)]))){
var statearr_27228_27485 = state_27214;
(statearr_27228_27485[(1)] = cljs.core.first.call(null,(state_27214[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27486 = state_27214;
state_27214 = G__27486;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2879__auto__ = function(state_27214){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2879__auto____1.call(this,state_27214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2879__auto____0;
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2879__auto____1;
return fluree$db$graphdb$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_27229 = f__2902__auto__.call(null);
(statearr_27229[(6)] = c__2901__auto__);

return statearr_27229;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx.call(null,this$__$1,pred_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"sid","sid",1815016414),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:name :id :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_.call(null,collection)){
return cljs.core.get_in.call(null,self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),"_tx",property], null));
} else {
return cljs.core.get_in.call(null,self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coll","coll",1647737163),collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [new cljs.core.Keyword(null,"unique","unique",329397282),null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),null,new cljs.core.Keyword(null,"index","index",-1531685915),null,new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),null,new cljs.core.Keyword(null,"type","type",1174270348),null,new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),null,new cljs.core.Keyword(null,"component","component",1555936782),null,new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),null,new cljs.core.Keyword(null,"spec","spec",347520401),null,new cljs.core.Keyword(null,"multi","multi",-190293005),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),null,new cljs.core.Keyword(null,"idx?","idx?",-564590377),null,new cljs.core.Keyword(null,"ref?","ref?",1932693720),null,new cljs.core.Keyword(null,"upsert","upsert",1416724984),null,new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),null], null), null).call(null,property))){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.call(null,property)].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :restrictTag} property)"].join('')));
}

var G__27230 = cljs.core.get_in.call(null,self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pred","pred",1927423397),predicate,property], null));
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,new cljs.core.Keyword(null,"id","id",-1388402092),G__27230);
} else {
return G__27230;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.call(null,this$__$1,block__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid.call(null,this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.call(null,this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.call(null,this$__$1,new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"root?","root?",-2045639518),true,new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel.call(null,db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query.call(null,this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.call(null,this$__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_27262){
var state_val_27263 = (state_27262[(1)]);
if((state_val_27263 === (7))){
var state_27262__$1 = state_27262;
var statearr_27264_27487 = state_27262__$1;
(statearr_27264_27487[(2)] = null);

(statearr_27264_27487[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27263 === (1))){
var state_27262__$1 = state_27262;
var statearr_27265_27488 = state_27262__$1;
(statearr_27265_27488[(2)] = null);

(statearr_27265_27488[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27263 === (4))){
var inst_27231 = (state_27262[(2)]);
var state_27262__$1 = state_27262;
var statearr_27266_27489 = state_27262__$1;
(statearr_27266_27489[(2)] = inst_27231);

(statearr_27266_27489[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27263 === (6))){
var inst_27245 = (state_27262[(7)]);
var inst_27244 = (state_27262[(2)]);
var inst_27245__$1 = fluree.db.util.async.throw_err.call(null,inst_27244);
var inst_27246 = (inst_27245__$1 == null);
var state_27262__$1 = (function (){var statearr_27267 = state_27262;
(statearr_27267[(7)] = inst_27245__$1);

return statearr_27267;
})();
if(cljs.core.truth_(inst_27246)){
var statearr_27268_27490 = state_27262__$1;
(statearr_27268_27490[(1)] = (7));

} else {
var statearr_27269_27491 = state_27262__$1;
(statearr_27269_27491[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27263 === (3))){
var inst_27260 = (state_27262[(2)]);
var state_27262__$1 = state_27262;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27262__$1,inst_27260);
} else {
if((state_val_27263 === (12))){
var inst_27257 = (state_27262[(2)]);
var _ = (function (){var statearr_27270 = state_27262;
(statearr_27270[(4)] = cljs.core.rest.call(null,(state_27262[(4)])));

return statearr_27270;
})();
var state_27262__$1 = state_27262;
var statearr_27271_27492 = state_27262__$1;
(statearr_27271_27492[(2)] = inst_27257);

(statearr_27271_27492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27263 === (2))){
var _ = (function (){var statearr_27272 = state_27262;
(statearr_27272[(4)] = cljs.core.cons.call(null,(5),(state_27262[(4)])));

return statearr_27272;
})();
var inst_27238 = fluree.db.dbproto._rootdb.call(null,this$__$1);
var inst_27239 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27240 = [tag_id,(30)];
var inst_27241 = (new cljs.core.PersistentVector(null,2,(5),inst_27239,inst_27240,null));
var inst_27242 = fluree.db.query.range.index_range.call(null,inst_27238,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_27241);
var state_27262__$1 = state_27262;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27262__$1,(6),inst_27242);
} else {
if((state_val_27263 === (11))){
var inst_27251 = (state_27262[(8)]);
var inst_27255 = inst_27251.o;
var state_27262__$1 = state_27262;
var statearr_27274_27493 = state_27262__$1;
(statearr_27274_27493[(2)] = inst_27255);

(statearr_27274_27493[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27263 === (9))){
var inst_27251 = (state_27262[(8)]);
var inst_27251__$1 = (state_27262[(2)]);
var inst_27252 = (inst_27251__$1 == null);
var state_27262__$1 = (function (){var statearr_27275 = state_27262;
(statearr_27275[(8)] = inst_27251__$1);

return statearr_27275;
})();
if(cljs.core.truth_(inst_27252)){
var statearr_27276_27494 = state_27262__$1;
(statearr_27276_27494[(1)] = (10));

} else {
var statearr_27277_27495 = state_27262__$1;
(statearr_27277_27495[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27263 === (5))){
var _ = (function (){var statearr_27278 = state_27262;
(statearr_27278[(4)] = cljs.core.rest.call(null,(state_27262[(4)])));

return statearr_27278;
})();
var state_27262__$1 = state_27262;
var ex27273 = (state_27262__$1[(2)]);
var statearr_27279_27496 = state_27262__$1;
(statearr_27279_27496[(5)] = ex27273);


if((ex27273 instanceof Error)){
var statearr_27280_27497 = state_27262__$1;
(statearr_27280_27497[(1)] = (4));

(statearr_27280_27497[(5)] = null);

} else {
throw ex27273;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27263 === (10))){
var state_27262__$1 = state_27262;
var statearr_27281_27498 = state_27262__$1;
(statearr_27281_27498[(2)] = null);

(statearr_27281_27498[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27263 === (8))){
var inst_27245 = (state_27262[(7)]);
var inst_27249 = cljs.core.first.call(null,inst_27245);
var state_27262__$1 = state_27262;
var statearr_27282_27499 = state_27262__$1;
(statearr_27282_27499[(2)] = inst_27249);

(statearr_27282_27499[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2879__auto__ = null;
var fluree$db$graphdb$state_machine__2879__auto____0 = (function (){
var statearr_27283 = [null,null,null,null,null,null,null,null,null];
(statearr_27283[(0)] = fluree$db$graphdb$state_machine__2879__auto__);

(statearr_27283[(1)] = (1));

return statearr_27283;
});
var fluree$db$graphdb$state_machine__2879__auto____1 = (function (state_27262){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_27262);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e27284){var ex__2882__auto__ = e27284;
var statearr_27285_27500 = state_27262;
(statearr_27285_27500[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_27262[(4)]))){
var statearr_27286_27501 = state_27262;
(statearr_27286_27501[(1)] = cljs.core.first.call(null,(state_27262[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27502 = state_27262;
state_27262 = G__27502;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2879__auto__ = function(state_27262){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2879__auto____1.call(this,state_27262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2879__auto____0;
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2879__auto____1;
return fluree$db$graphdb$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_27287 = f__2902__auto__.call(null);
(statearr_27287[(6)] = c__2901__auto__);

return statearr_27287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_27323){
var state_val_27324 = (state_27323[(1)]);
if((state_val_27324 === (7))){
var inst_27297 = fluree.db.dbproto._p_prop.call(null,this$__$1,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27323__$1 = state_27323;
var statearr_27325_27503 = state_27323__$1;
(statearr_27325_27503[(2)] = inst_27297);

(statearr_27325_27503[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (1))){
var state_27323__$1 = state_27323;
var statearr_27326_27504 = state_27323__$1;
(statearr_27326_27504[(2)] = null);

(statearr_27326_27504[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (4))){
var inst_27288 = (state_27323[(2)]);
var state_27323__$1 = state_27323;
var statearr_27327_27505 = state_27323__$1;
(statearr_27327_27505[(2)] = inst_27288);

(statearr_27327_27505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (15))){
var inst_27318 = (state_27323[(2)]);
var _ = (function (){var statearr_27328 = state_27323;
(statearr_27328[(4)] = cljs.core.rest.call(null,(state_27323[(4)])));

return statearr_27328;
})();
var state_27323__$1 = state_27323;
var statearr_27329_27506 = state_27323__$1;
(statearr_27329_27506[(2)] = inst_27318);

(statearr_27329_27506[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (13))){
var inst_27303 = (state_27323[(7)]);
var inst_27309 = clojure.string.includes_QMARK_.call(null,inst_27303,":");
var state_27323__$1 = state_27323;
if(inst_27309){
var statearr_27330_27507 = state_27323__$1;
(statearr_27330_27507[(1)] = (16));

} else {
var statearr_27331_27508 = state_27323__$1;
(statearr_27331_27508[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (6))){
var state_27323__$1 = state_27323;
var statearr_27332_27509 = state_27323__$1;
(statearr_27332_27509[(2)] = pred);

(statearr_27332_27509[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (17))){
var inst_27303 = (state_27323[(7)]);
var state_27323__$1 = state_27323;
var statearr_27333_27510 = state_27323__$1;
(statearr_27333_27510[(2)] = inst_27303);

(statearr_27333_27510[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (3))){
var inst_27321 = (state_27323[(2)]);
var state_27323__$1 = state_27323;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27323__$1,inst_27321);
} else {
if((state_val_27324 === (12))){
var inst_27307 = (state_27323[(2)]);
var state_27323__$1 = state_27323;
if(cljs.core.truth_(inst_27307)){
var statearr_27334_27511 = state_27323__$1;
(statearr_27334_27511[(1)] = (13));

} else {
var statearr_27335_27512 = state_27323__$1;
(statearr_27335_27512[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (2))){
var _ = (function (){var statearr_27336 = state_27323;
(statearr_27336[(4)] = cljs.core.cons.call(null,(5),(state_27323[(4)])));

return statearr_27336;
})();
var inst_27294 = typeof pred === 'string';
var state_27323__$1 = state_27323;
if(cljs.core.truth_(inst_27294)){
var statearr_27337_27513 = state_27323__$1;
(statearr_27337_27513[(1)] = (6));

} else {
var statearr_27338_27514 = state_27323__$1;
(statearr_27338_27514[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (11))){
var inst_27299 = (state_27323[(8)]);
var state_27323__$1 = state_27323;
var statearr_27340_27515 = state_27323__$1;
(statearr_27340_27515[(2)] = inst_27299);

(statearr_27340_27515[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (9))){
var inst_27299 = (state_27323[(8)]);
var inst_27302 = (state_27323[(2)]);
var inst_27303 = fluree.db.util.async.throw_err.call(null,inst_27302);
var state_27323__$1 = (function (){var statearr_27341 = state_27323;
(statearr_27341[(7)] = inst_27303);

return statearr_27341;
})();
if(cljs.core.truth_(inst_27299)){
var statearr_27342_27516 = state_27323__$1;
(statearr_27342_27516[(1)] = (10));

} else {
var statearr_27343_27517 = state_27323__$1;
(statearr_27343_27517[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (5))){
var _ = (function (){var statearr_27344 = state_27323;
(statearr_27344[(4)] = cljs.core.rest.call(null,(state_27323[(4)])));

return statearr_27344;
})();
var state_27323__$1 = state_27323;
var ex27339 = (state_27323__$1[(2)]);
var statearr_27345_27518 = state_27323__$1;
(statearr_27345_27518[(5)] = ex27339);


if((ex27339 instanceof Error)){
var statearr_27346_27519 = state_27323__$1;
(statearr_27346_27519[(1)] = (4));

(statearr_27346_27519[(5)] = null);

} else {
throw ex27339;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (14))){
var state_27323__$1 = state_27323;
var statearr_27347_27520 = state_27323__$1;
(statearr_27347_27520[(2)] = null);

(statearr_27347_27520[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (16))){
var inst_27303 = (state_27323[(7)]);
var inst_27311 = clojure.string.split.call(null,inst_27303,/:/);
var inst_27312 = cljs.core.second.call(null,inst_27311);
var state_27323__$1 = state_27323;
var statearr_27348_27521 = state_27323__$1;
(statearr_27348_27521[(2)] = inst_27312);

(statearr_27348_27521[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (10))){
var inst_27303 = (state_27323[(7)]);
var state_27323__$1 = state_27323;
var statearr_27349_27522 = state_27323__$1;
(statearr_27349_27522[(2)] = inst_27303);

(statearr_27349_27522[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (18))){
var inst_27315 = (state_27323[(2)]);
var state_27323__$1 = state_27323;
var statearr_27350_27523 = state_27323__$1;
(statearr_27350_27523[(2)] = inst_27315);

(statearr_27350_27523[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27324 === (8))){
var inst_27299 = (state_27323[(2)]);
var inst_27300 = fluree.db.dbproto._tag.call(null,this$__$1,tag_id);
var state_27323__$1 = (function (){var statearr_27351 = state_27323;
(statearr_27351[(8)] = inst_27299);

return statearr_27351;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27323__$1,(9),inst_27300);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2879__auto__ = null;
var fluree$db$graphdb$state_machine__2879__auto____0 = (function (){
var statearr_27352 = [null,null,null,null,null,null,null,null,null];
(statearr_27352[(0)] = fluree$db$graphdb$state_machine__2879__auto__);

(statearr_27352[(1)] = (1));

return statearr_27352;
});
var fluree$db$graphdb$state_machine__2879__auto____1 = (function (state_27323){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_27323);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e27353){var ex__2882__auto__ = e27353;
var statearr_27354_27524 = state_27323;
(statearr_27354_27524[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_27323[(4)]))){
var statearr_27355_27525 = state_27323;
(statearr_27355_27525[(1)] = cljs.core.first.call(null,(state_27323[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27526 = state_27323;
state_27323 = G__27526;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2879__auto__ = function(state_27323){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2879__auto____1.call(this,state_27323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2879__auto____0;
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2879__auto____1;
return fluree$db$graphdb$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_27356 = f__2902__auto__.call(null);
(statearr_27356[(6)] = c__2901__auto__);

return statearr_27356;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_27388){
var state_val_27389 = (state_27388[(1)]);
if((state_val_27389 === (7))){
var state_27388__$1 = state_27388;
var statearr_27390_27527 = state_27388__$1;
(statearr_27390_27527[(2)] = null);

(statearr_27390_27527[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27389 === (1))){
var state_27388__$1 = state_27388;
var statearr_27391_27528 = state_27388__$1;
(statearr_27391_27528[(2)] = null);

(statearr_27391_27528[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27389 === (4))){
var inst_27357 = (state_27388[(2)]);
var state_27388__$1 = state_27388;
var statearr_27392_27529 = state_27388__$1;
(statearr_27392_27529[(2)] = inst_27357);

(statearr_27392_27529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27389 === (6))){
var inst_27371 = (state_27388[(7)]);
var inst_27370 = (state_27388[(2)]);
var inst_27371__$1 = fluree.db.util.async.throw_err.call(null,inst_27370);
var inst_27372 = (inst_27371__$1 == null);
var state_27388__$1 = (function (){var statearr_27393 = state_27388;
(statearr_27393[(7)] = inst_27371__$1);

return statearr_27393;
})();
if(cljs.core.truth_(inst_27372)){
var statearr_27394_27530 = state_27388__$1;
(statearr_27394_27530[(1)] = (7));

} else {
var statearr_27395_27531 = state_27388__$1;
(statearr_27395_27531[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27389 === (3))){
var inst_27386 = (state_27388[(2)]);
var state_27388__$1 = state_27388;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27388__$1,inst_27386);
} else {
if((state_val_27389 === (12))){
var inst_27383 = (state_27388[(2)]);
var _ = (function (){var statearr_27396 = state_27388;
(statearr_27396[(4)] = cljs.core.rest.call(null,(state_27388[(4)])));

return statearr_27396;
})();
var state_27388__$1 = state_27388;
var statearr_27397_27532 = state_27388__$1;
(statearr_27397_27532[(2)] = inst_27383);

(statearr_27397_27532[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27389 === (2))){
var _ = (function (){var statearr_27398 = state_27388;
(statearr_27398[(4)] = cljs.core.cons.call(null,(5),(state_27388[(4)])));

return statearr_27398;
})();
var inst_27364 = fluree.db.dbproto._rootdb.call(null,this$__$1);
var inst_27365 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27366 = [(30),tag_name];
var inst_27367 = (new cljs.core.PersistentVector(null,2,(5),inst_27365,inst_27366,null));
var inst_27368 = fluree.db.query.range.index_range.call(null,inst_27364,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_27367);
var state_27388__$1 = state_27388;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27388__$1,(6),inst_27368);
} else {
if((state_val_27389 === (11))){
var inst_27377 = (state_27388[(8)]);
var inst_27381 = inst_27377.s;
var state_27388__$1 = state_27388;
var statearr_27400_27533 = state_27388__$1;
(statearr_27400_27533[(2)] = inst_27381);

(statearr_27400_27533[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27389 === (9))){
var inst_27377 = (state_27388[(8)]);
var inst_27377__$1 = (state_27388[(2)]);
var inst_27378 = (inst_27377__$1 == null);
var state_27388__$1 = (function (){var statearr_27401 = state_27388;
(statearr_27401[(8)] = inst_27377__$1);

return statearr_27401;
})();
if(cljs.core.truth_(inst_27378)){
var statearr_27402_27534 = state_27388__$1;
(statearr_27402_27534[(1)] = (10));

} else {
var statearr_27403_27535 = state_27388__$1;
(statearr_27403_27535[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27389 === (5))){
var _ = (function (){var statearr_27404 = state_27388;
(statearr_27404[(4)] = cljs.core.rest.call(null,(state_27388[(4)])));

return statearr_27404;
})();
var state_27388__$1 = state_27388;
var ex27399 = (state_27388__$1[(2)]);
var statearr_27405_27536 = state_27388__$1;
(statearr_27405_27536[(5)] = ex27399);


if((ex27399 instanceof Error)){
var statearr_27406_27537 = state_27388__$1;
(statearr_27406_27537[(1)] = (4));

(statearr_27406_27537[(5)] = null);

} else {
throw ex27399;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27389 === (10))){
var state_27388__$1 = state_27388;
var statearr_27407_27538 = state_27388__$1;
(statearr_27407_27538[(2)] = null);

(statearr_27407_27538[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27389 === (8))){
var inst_27371 = (state_27388[(7)]);
var inst_27375 = cljs.core.first.call(null,inst_27371);
var state_27388__$1 = state_27388;
var statearr_27408_27539 = state_27388__$1;
(statearr_27408_27539[(2)] = inst_27375);

(statearr_27408_27539[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2879__auto__ = null;
var fluree$db$graphdb$state_machine__2879__auto____0 = (function (){
var statearr_27409 = [null,null,null,null,null,null,null,null,null];
(statearr_27409[(0)] = fluree$db$graphdb$state_machine__2879__auto__);

(statearr_27409[(1)] = (1));

return statearr_27409;
});
var fluree$db$graphdb$state_machine__2879__auto____1 = (function (state_27388){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_27388);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e27410){var ex__2882__auto__ = e27410;
var statearr_27411_27540 = state_27388;
(statearr_27411_27540[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_27388[(4)]))){
var statearr_27412_27541 = state_27388;
(statearr_27412_27541[(1)] = cljs.core.first.call(null,(state_27388[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27542 = state_27388;
state_27388 = G__27542;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2879__auto__ = function(state_27388){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2879__auto____1.call(this,state_27388);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2879__auto____0;
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2879__auto____1;
return fluree$db$graphdb$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_27413 = f__2902__auto__.call(null);
(statearr_27413[(6)] = c__2901__auto__);

return statearr_27413;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_27448){
var state_val_27449 = (state_27448[(1)]);
if((state_val_27449 === (7))){
var inst_27427 = typeof pred === 'string';
var state_27448__$1 = state_27448;
if(cljs.core.truth_(inst_27427)){
var statearr_27450_27543 = state_27448__$1;
(statearr_27450_27543[(1)] = (10));

} else {
var statearr_27451_27544 = state_27448__$1;
(statearr_27451_27544[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27449 === (1))){
var state_27448__$1 = state_27448;
var statearr_27452_27545 = state_27448__$1;
(statearr_27452_27545[(2)] = null);

(statearr_27452_27545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27449 === (4))){
var inst_27414 = (state_27448[(2)]);
var state_27448__$1 = state_27448;
var statearr_27453_27546 = state_27448__$1;
(statearr_27453_27546[(2)] = inst_27414);

(statearr_27453_27546[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27449 === (15))){
var inst_27441 = (state_27448[(2)]);
var state_27448__$1 = state_27448;
var statearr_27454_27547 = state_27448__$1;
(statearr_27454_27547[(2)] = inst_27441);

(statearr_27454_27547[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27449 === (13))){
var inst_27432 = (state_27448[(7)]);
var inst_27434 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27432),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_27435 = fluree.db.dbproto._tag_id.call(null,this$__$1,inst_27434);
var state_27448__$1 = state_27448;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27448__$1,(16),inst_27435);
} else {
if((state_val_27449 === (6))){
var inst_27422 = fluree.db.dbproto._tag_id.call(null,this$__$1,tag_name);
var state_27448__$1 = state_27448;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27448__$1,(9),inst_27422);
} else {
if((state_val_27449 === (3))){
var inst_27446 = (state_27448[(2)]);
var state_27448__$1 = state_27448;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27448__$1,inst_27446);
} else {
if((state_val_27449 === (12))){
var inst_27432 = (state_27448[(7)]);
var inst_27432__$1 = (state_27448[(2)]);
var state_27448__$1 = (function (){var statearr_27455 = state_27448;
(statearr_27455[(7)] = inst_27432__$1);

return statearr_27455;
})();
if(cljs.core.truth_(inst_27432__$1)){
var statearr_27456_27548 = state_27448__$1;
(statearr_27456_27548[(1)] = (13));

} else {
var statearr_27457_27549 = state_27448__$1;
(statearr_27457_27549[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27449 === (2))){
var _ = (function (){var statearr_27458 = state_27448;
(statearr_27458[(4)] = cljs.core.cons.call(null,(5),(state_27448[(4)])));

return statearr_27458;
})();
var inst_27420 = clojure.string.includes_QMARK_.call(null,tag_name,"/");
var state_27448__$1 = state_27448;
if(inst_27420){
var statearr_27459_27550 = state_27448__$1;
(statearr_27459_27550[(1)] = (6));

} else {
var statearr_27460_27551 = state_27448__$1;
(statearr_27460_27551[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27449 === (11))){
var inst_27430 = fluree.db.dbproto._p_prop.call(null,this$__$1,new cljs.core.Keyword(null,"name","name",1843675177),pred);
var state_27448__$1 = state_27448;
var statearr_27462_27552 = state_27448__$1;
(statearr_27462_27552[(2)] = inst_27430);

(statearr_27462_27552[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27449 === (9))){
var inst_27424 = (state_27448[(2)]);
var inst_27425 = fluree.db.util.async.throw_err.call(null,inst_27424);
var state_27448__$1 = state_27448;
var statearr_27463_27553 = state_27448__$1;
(statearr_27463_27553[(2)] = inst_27425);

(statearr_27463_27553[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27449 === (5))){
var _ = (function (){var statearr_27464 = state_27448;
(statearr_27464[(4)] = cljs.core.rest.call(null,(state_27448[(4)])));

return statearr_27464;
})();
var state_27448__$1 = state_27448;
var ex27461 = (state_27448__$1[(2)]);
var statearr_27465_27554 = state_27448__$1;
(statearr_27465_27554[(5)] = ex27461);


if((ex27461 instanceof Error)){
var statearr_27466_27555 = state_27448__$1;
(statearr_27466_27555[(1)] = (4));

(statearr_27466_27555[(5)] = null);

} else {
throw ex27461;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27449 === (14))){
var state_27448__$1 = state_27448;
var statearr_27467_27556 = state_27448__$1;
(statearr_27467_27556[(2)] = null);

(statearr_27467_27556[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27449 === (16))){
var inst_27437 = (state_27448[(2)]);
var inst_27438 = fluree.db.util.async.throw_err.call(null,inst_27437);
var state_27448__$1 = state_27448;
var statearr_27468_27557 = state_27448__$1;
(statearr_27468_27557[(2)] = inst_27438);

(statearr_27468_27557[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27449 === (10))){
var state_27448__$1 = state_27448;
var statearr_27469_27558 = state_27448__$1;
(statearr_27469_27558[(2)] = pred);

(statearr_27469_27558[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27449 === (8))){
var inst_27443 = (state_27448[(2)]);
var _ = (function (){var statearr_27470 = state_27448;
(statearr_27470[(4)] = cljs.core.rest.call(null,(state_27448[(4)])));

return statearr_27470;
})();
var state_27448__$1 = state_27448;
var statearr_27471_27559 = state_27448__$1;
(statearr_27471_27559[(2)] = inst_27443);

(statearr_27471_27559[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__2879__auto__ = null;
var fluree$db$graphdb$state_machine__2879__auto____0 = (function (){
var statearr_27472 = [null,null,null,null,null,null,null,null];
(statearr_27472[(0)] = fluree$db$graphdb$state_machine__2879__auto__);

(statearr_27472[(1)] = (1));

return statearr_27472;
});
var fluree$db$graphdb$state_machine__2879__auto____1 = (function (state_27448){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_27448);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e27473){var ex__2882__auto__ = e27473;
var statearr_27474_27560 = state_27448;
(statearr_27474_27560[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_27448[(4)]))){
var statearr_27475_27561 = state_27448;
(statearr_27475_27561[(1)] = cljs.core.first.call(null,(state_27448[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27562 = state_27448;
state_27448 = G__27562;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__2879__auto__ = function(state_27448){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__2879__auto____1.call(this,state_27448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__2879__auto____0;
fluree$db$graphdb$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__2879__auto____1;
return fluree$db$graphdb$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_27476 = f__2902__auto__.call(null);
(statearr_27476[(6)] = c__2901__auto__);

return statearr_27476;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"stats","stats",1554888516,null),new cljs.core.Symbol(null,"spot","spot",-66430620,null),new cljs.core.Symbol(null,"psot","psot",-542782710,null),new cljs.core.Symbol(null,"post","post",1910229214,null),new cljs.core.Symbol(null,"opst","opst",-1440472711,null),new cljs.core.Symbol(null,"schema","schema",58529736,null),new cljs.core.Symbol(null,"settings","settings",-1098290894,null),new cljs.core.Symbol(null,"index-configs","index-configs",-1600476489,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"novelty","novelty",50285503,null),new cljs.core.Symbol(null,"permissions","permissions",1708334602,null),new cljs.core.Symbol(null,"fork","fork",-1591461534,null),new cljs.core.Symbol(null,"fork-block","fork-block",1818919450,null),new cljs.core.Symbol(null,"current-db-fn","current-db-fn",1880177863,null)], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__27190){
var extmap__4419__auto__ = (function (){var G__27477 = cljs.core.dissoc.call(null,G__27190,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"settings","settings",1556144875),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"novelty","novelty",-1590246024),new cljs.core.Keyword(null,"permissions","permissions",67803075),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"fork-block","fork-block",178387923),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336));
if(cljs.core.record_QMARK_.call(null,G__27190)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__27477);
} else {
return G__27477;
}
})();
return (new fluree.db.graphdb.GraphDb(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27190),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27190),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27190),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__27190),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__27190),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__27190),new cljs.core.Keyword(null,"stats","stats",-85643011).cljs$core$IFn$_invoke$arity$1(G__27190),new cljs.core.Keyword(null,"spot","spot",-1706962147).cljs$core$IFn$_invoke$arity$1(G__27190),new cljs.core.Keyword(null,"psot","psot",2111653059).cljs$core$IFn$_invoke$arity$1(G__27190),new cljs.core.Keyword(null,"post","post",269697687).cljs$core$IFn$_invoke$arity$1(G__27190),new cljs.core.Keyword(null,"opst","opst",1213963058).cljs$core$IFn$_invoke$arity$1(G__27190),new cljs.core.Keyword(null,"schema","schema",-1582001791).cljs$core$IFn$_invoke$arity$1(G__27190),new cljs.core.Keyword(null,"settings","settings",1556144875).cljs$core$IFn$_invoke$arity$1(G__27190),new cljs.core.Keyword(null,"index-configs","index-configs",1053959280).cljs$core$IFn$_invoke$arity$1(G__27190),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27190),new cljs.core.Keyword(null,"novelty","novelty",-1590246024).cljs$core$IFn$_invoke$arity$1(G__27190),new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(G__27190),new cljs.core.Keyword(null,"fork","fork",1062974235).cljs$core$IFn$_invoke$arity$1(G__27190),new cljs.core.Keyword(null,"fork-block","fork-block",178387923).cljs$core$IFn$_invoke$arity$1(G__27190),new cljs.core.Keyword(null,"current-db-fn","current-db-fn",239646336).cljs$core$IFn$_invoke$arity$1(G__27190),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write.call(null,w,"#FlureeGraphDB ");

return cljs.core._write.call(null,w,cljs.core.pr.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"network","network",2050004697),db__$1.network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),db__$1.dbid,new cljs.core.Keyword(null,"block","block",664686210),db__$1.block,new cljs.core.Keyword(null,"t","t",-1397832519),db__$1.t,new cljs.core.Keyword(null,"stats","stats",-85643011),db__$1.stats,new cljs.core.Keyword(null,"permissions","permissions",67803075),db__$1.permissions], null)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.call(null,(function (m,idx){
var ss = clojure.data.avl.sorted_set_by.call(null,cljs.core.get_in.call(null,index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null)));
return cljs.core.assoc.call(null,m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"size","size",1098693007),(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.call(null,index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake.call(null,fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"conn","conn",278309663)],[(0),dbid,index_config,true,(0),true,new cljs.core.Keyword(null,"empty","empty",767870958),(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.call(null,comparator,first_flake,child_node);
var idx_node = fluree.db.index.__GT_IndexNode.call(null,(0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"spot","spot",-1706962147),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_spot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_spot_novelty], null)),new cljs.core.Keyword(null,"psot","psot",2111653059),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_psot,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_psot_novelty], null)),new cljs.core.Keyword(null,"post","post",269697687),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_post,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_post_novelty], null)),new cljs.core.Keyword(null,"opst","opst",1213963058),fluree.db.index.map__GT_IndexConfig.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"comparator","comparator",2144896662),fluree.db.flake.cmp_flakes_opst,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map.call(null,fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"collection","collection",-683361892),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),false], null),new cljs.core.Keyword(null,"predicate","predicate",-1742501860),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"all?","all?",1103779750),true], null),new cljs.core.Keyword(null,"root?","root?",-2045639518),true], null);
var spot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var psot = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"psot","psot",2111653059));
var post = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"post","post",269697687));
var opst = fluree.db.graphdb.new_empty_index.call(null,conn,fluree.db.graphdb.default_index_configs,network,dbid,new cljs.core.Keyword(null,"opst","opst",1213963058));
var stats = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"flakes","flakes",1977895739),(0),new cljs.core.Keyword(null,"size","size",1098693007),(0),new cljs.core.Keyword(null,"indexed","indexed",390758624),(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb.call(null,conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
