// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k19724,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__19728 = k19724;
var G__19728__$1 = (((G__19728 instanceof cljs.core.Keyword))?G__19728.fqn:null);
switch (G__19728__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k19724,else__4383__auto__);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__19729){
var vec__19730 = p__19729;
var k__4403__auto__ = cljs.core.nth.call(null,vec__19730,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__19730,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"index-type","index-type",500383962),self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"comparator","comparator",2144896662),self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),self__.historyComparator],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__19723){
var self__ = this;
var G__19723__$1 = this;
return (new cljs.core.RecordIter((0),G__19723__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (3 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this19725,other19726){
var self__ = this;
var this19725__$1 = this;
return (((!((other19726 == null)))) && ((this19725__$1.constructor === other19726.constructor)) && (cljs.core._EQ_.call(null,this19725__$1.index_type,other19726.index_type)) && (cljs.core._EQ_.call(null,this19725__$1.comparator,other19726.comparator)) && (cljs.core._EQ_.call(null,this19725__$1.historyComparator,other19726.historyComparator)) && (cljs.core._EQ_.call(null,this19725__$1.__extmap,other19726.__extmap)));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),null,new cljs.core.Keyword(null,"comparator","comparator",2144896662),null,new cljs.core.Keyword(null,"index-type","index-type",500383962),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__19723){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__19733 = cljs.core.keyword_identical_QMARK_;
var expr__19734 = k__4388__auto__;
if(cljs.core.truth_(pred__19733.call(null,new cljs.core.Keyword(null,"index-type","index-type",500383962),expr__19734))){
return (new fluree.db.index.IndexConfig(G__19723,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19733.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662),expr__19734))){
return (new fluree.db.index.IndexConfig(self__.index_type,G__19723,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19733.call(null,new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),expr__19734))){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__19723,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__19723),null));
}
}
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"index-type","index-type",500383962),self__.index_type,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"comparator","comparator",2144896662),self__.comparator,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658),self__.historyComparator,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__19723){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__19723,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"index-type","index-type",2140915489,null),new cljs.core.Symbol(null,"comparator","comparator",-509539107,null),new cljs.core.Symbol(null,"historyComparator","historyComparator",236913869,null)], null);
}));

(fluree.db.index.IndexConfig.cljs$lang$type = true);

(fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
}));

(fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.index/IndexConfig");
}));

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__19727){
var extmap__4419__auto__ = (function (){var G__19736 = cljs.core.dissoc.call(null,G__19727,new cljs.core.Keyword(null,"index-type","index-type",500383962),new cljs.core.Keyword(null,"comparator","comparator",2144896662),new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658));
if(cljs.core.record_QMARK_.call(null,G__19727)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__19736);
} else {
return G__19736;
}
})();
return (new fluree.db.index.IndexConfig(new cljs.core.Keyword(null,"index-type","index-type",500383962).cljs$core$IFn$_invoke$arity$1(G__19727),new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(G__19727),new cljs.core.Keyword(null,"historyComparator","historyComparator",-1403617658).cljs$core$IFn$_invoke$arity$1(G__19727),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k19739,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__19743 = k19739;
var G__19743__$1 = (((G__19743 instanceof cljs.core.Keyword))?G__19743.fqn:null);
switch (G__19743__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k19739,else__4383__auto__);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__19744){
var vec__19745 = p__19744;
var k__4403__auto__ = cljs.core.nth.call(null,vec__19745,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__19745,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"children","children",-940561982),self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__19738){
var self__ = this;
var G__19738__$1 = this;
return (new cljs.core.RecordIter((0),G__19738__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_19749){
var state_val_19750 = (state_19749[(1)]);
if((state_val_19750 === (1))){
var state_19749__$1 = state_19749;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19749__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__2879__auto__ = null;
var fluree$db$index$state_machine__2879__auto____0 = (function (){
var statearr_19751 = [null,null,null,null,null,null,null];
(statearr_19751[(0)] = fluree$db$index$state_machine__2879__auto__);

(statearr_19751[(1)] = (1));

return statearr_19751;
});
var fluree$db$index$state_machine__2879__auto____1 = (function (state_19749){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_19749);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e19752){var ex__2882__auto__ = e19752;
var statearr_19753_19851 = state_19749;
(statearr_19753_19851[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_19749[(4)]))){
var statearr_19754_19852 = state_19749;
(statearr_19754_19852[(1)] = cljs.core.first.call(null,(state_19749[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19853 = state_19749;
state_19749 = G__19853;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$index$state_machine__2879__auto__ = function(state_19749){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2879__auto____1.call(this,state_19749);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2879__auto____0;
fluree$db$index$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2879__auto____1;
return fluree$db$index$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_19755 = f__2902__auto__.call(null);
(statearr_19755[(6)] = c__2901__auto__);

return statearr_19755;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key.call(null,cljs.core.first.call(null,self__.children));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (6 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val.call(null,(function (){var or__4126__auto__ = clojure.data.avl.nearest.call(null,self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.first.call(null,self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val.call(null,(function (){var or__4126__auto__ = clojure.data.avl.nearest.call(null,self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.last.call(null,self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_19780){
var state_val_19781 = (state_19780[(1)]);
if((state_val_19781 === (7))){
var inst_19762 = (state_19780[(7)]);
var inst_19766 = fluree.db.dbproto._resolve.call(null,inst_19762);
var state_19780__$1 = state_19780;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19780__$1,(10),inst_19766);
} else {
if((state_val_19781 === (1))){
var state_19780__$1 = state_19780;
var statearr_19782_19854 = state_19780__$1;
(statearr_19782_19854[(2)] = null);

(statearr_19782_19854[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (4))){
var inst_19756 = (state_19780[(2)]);
var state_19780__$1 = state_19780;
var statearr_19783_19855 = state_19780__$1;
(statearr_19783_19855[(2)] = inst_19756);

(statearr_19783_19855[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (6))){
var inst_19762 = (state_19780[(7)]);
var state_19780__$1 = state_19780;
var statearr_19784_19856 = state_19780__$1;
(statearr_19784_19856[(2)] = inst_19762);

(statearr_19784_19856[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (3))){
var inst_19778 = (state_19780[(2)]);
var state_19780__$1 = state_19780;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19780__$1,inst_19778);
} else {
if((state_val_19781 === (2))){
var inst_19762 = (state_19780[(7)]);
var _ = (function (){var statearr_19786 = state_19780;
(statearr_19786[(4)] = cljs.core.cons.call(null,(5),(state_19780[(4)])));

return statearr_19786;
})();
var inst_19762__$1 = fluree.db.dbproto._lookup.call(null,this$__$1,flake);
var inst_19763 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(inst_19762__$1);
var state_19780__$1 = (function (){var statearr_19787 = state_19780;
(statearr_19787[(7)] = inst_19762__$1);

return statearr_19787;
})();
if(cljs.core.truth_(inst_19763)){
var statearr_19788_19857 = state_19780__$1;
(statearr_19788_19857[(1)] = (6));

} else {
var statearr_19789_19858 = state_19780__$1;
(statearr_19789_19858[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (9))){
var inst_19772 = (state_19780[(2)]);
var inst_19773 = fluree.db.util.async.throw_err.call(null,inst_19772);
var state_19780__$1 = state_19780;
var statearr_19790_19859 = state_19780__$1;
(statearr_19790_19859[(2)] = inst_19773);

(statearr_19790_19859[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (5))){
var _ = (function (){var statearr_19791 = state_19780;
(statearr_19791[(4)] = cljs.core.rest.call(null,(state_19780[(4)])));

return statearr_19791;
})();
var state_19780__$1 = state_19780;
var ex19785 = (state_19780__$1[(2)]);
var statearr_19792_19860 = state_19780__$1;
(statearr_19792_19860[(5)] = ex19785);


if((ex19785 instanceof Error)){
var statearr_19793_19861 = state_19780__$1;
(statearr_19793_19861[(1)] = (4));

(statearr_19793_19861[(5)] = null);

} else {
throw ex19785;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19781 === (10))){
var inst_19768 = (state_19780[(2)]);
var inst_19769 = fluree.db.util.async.throw_err.call(null,inst_19768);
var inst_19770 = fluree.db.dbproto._lookup_leaf.call(null,inst_19769,flake);
var state_19780__$1 = state_19780;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19780__$1,(9),inst_19770);
} else {
if((state_val_19781 === (8))){
var inst_19775 = (state_19780[(2)]);
var _ = (function (){var statearr_19794 = state_19780;
(statearr_19794[(4)] = cljs.core.rest.call(null,(state_19780[(4)])));

return statearr_19794;
})();
var state_19780__$1 = state_19780;
var statearr_19795_19862 = state_19780__$1;
(statearr_19795_19862[(2)] = inst_19775);

(statearr_19795_19862[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2879__auto__ = null;
var fluree$db$index$state_machine__2879__auto____0 = (function (){
var statearr_19796 = [null,null,null,null,null,null,null,null];
(statearr_19796[(0)] = fluree$db$index$state_machine__2879__auto__);

(statearr_19796[(1)] = (1));

return statearr_19796;
});
var fluree$db$index$state_machine__2879__auto____1 = (function (state_19780){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_19780);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e19797){var ex__2882__auto__ = e19797;
var statearr_19798_19863 = state_19780;
(statearr_19798_19863[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_19780[(4)]))){
var statearr_19799_19864 = state_19780;
(statearr_19799_19864[(1)] = cljs.core.first.call(null,(state_19780[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19865 = state_19780;
state_19780 = G__19865;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$index$state_machine__2879__auto__ = function(state_19780){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2879__auto____1.call(this,state_19780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2879__auto____0;
fluree$db$index$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2879__auto____1;
return fluree$db$index$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_19800 = f__2902__auto__.call(null);
(statearr_19800[(6)] = c__2901__auto__);

return statearr_19800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_19825){
var state_val_19826 = (state_19825[(1)]);
if((state_val_19826 === (7))){
var inst_19807 = (state_19825[(7)]);
var inst_19811 = fluree.db.dbproto._resolve.call(null,inst_19807);
var state_19825__$1 = state_19825;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19825__$1,(10),inst_19811);
} else {
if((state_val_19826 === (1))){
var state_19825__$1 = state_19825;
var statearr_19827_19866 = state_19825__$1;
(statearr_19827_19866[(2)] = null);

(statearr_19827_19866[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19826 === (4))){
var inst_19801 = (state_19825[(2)]);
var state_19825__$1 = state_19825;
var statearr_19828_19867 = state_19825__$1;
(statearr_19828_19867[(2)] = inst_19801);

(statearr_19828_19867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19826 === (6))){
var inst_19807 = (state_19825[(7)]);
var state_19825__$1 = state_19825;
var statearr_19829_19868 = state_19825__$1;
(statearr_19829_19868[(2)] = inst_19807);

(statearr_19829_19868[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19826 === (3))){
var inst_19823 = (state_19825[(2)]);
var state_19825__$1 = state_19825;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19825__$1,inst_19823);
} else {
if((state_val_19826 === (2))){
var inst_19807 = (state_19825[(7)]);
var _ = (function (){var statearr_19831 = state_19825;
(statearr_19831[(4)] = cljs.core.cons.call(null,(5),(state_19825[(4)])));

return statearr_19831;
})();
var inst_19807__$1 = fluree.db.dbproto._lookup_after.call(null,this$__$1,flake);
var inst_19808 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(inst_19807__$1);
var state_19825__$1 = (function (){var statearr_19832 = state_19825;
(statearr_19832[(7)] = inst_19807__$1);

return statearr_19832;
})();
if(cljs.core.truth_(inst_19808)){
var statearr_19833_19869 = state_19825__$1;
(statearr_19833_19869[(1)] = (6));

} else {
var statearr_19834_19870 = state_19825__$1;
(statearr_19834_19870[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19826 === (9))){
var inst_19817 = (state_19825[(2)]);
var inst_19818 = fluree.db.util.async.throw_err.call(null,inst_19817);
var state_19825__$1 = state_19825;
var statearr_19835_19871 = state_19825__$1;
(statearr_19835_19871[(2)] = inst_19818);

(statearr_19835_19871[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19826 === (5))){
var _ = (function (){var statearr_19836 = state_19825;
(statearr_19836[(4)] = cljs.core.rest.call(null,(state_19825[(4)])));

return statearr_19836;
})();
var state_19825__$1 = state_19825;
var ex19830 = (state_19825__$1[(2)]);
var statearr_19837_19872 = state_19825__$1;
(statearr_19837_19872[(5)] = ex19830);


if((ex19830 instanceof Error)){
var statearr_19838_19873 = state_19825__$1;
(statearr_19838_19873[(1)] = (4));

(statearr_19838_19873[(5)] = null);

} else {
throw ex19830;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19826 === (10))){
var inst_19813 = (state_19825[(2)]);
var inst_19814 = fluree.db.util.async.throw_err.call(null,inst_19813);
var inst_19815 = fluree.db.dbproto._lookup_leaf_after.call(null,inst_19814,flake);
var state_19825__$1 = state_19825;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19825__$1,(9),inst_19815);
} else {
if((state_val_19826 === (8))){
var inst_19820 = (state_19825[(2)]);
var _ = (function (){var statearr_19839 = state_19825;
(statearr_19839[(4)] = cljs.core.rest.call(null,(state_19825[(4)])));

return statearr_19839;
})();
var state_19825__$1 = state_19825;
var statearr_19840_19874 = state_19825__$1;
(statearr_19840_19874[(2)] = inst_19820);

(statearr_19840_19874[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__2879__auto__ = null;
var fluree$db$index$state_machine__2879__auto____0 = (function (){
var statearr_19841 = [null,null,null,null,null,null,null,null];
(statearr_19841[(0)] = fluree$db$index$state_machine__2879__auto__);

(statearr_19841[(1)] = (1));

return statearr_19841;
});
var fluree$db$index$state_machine__2879__auto____1 = (function (state_19825){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_19825);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e19842){var ex__2882__auto__ = e19842;
var statearr_19843_19875 = state_19825;
(statearr_19843_19875[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_19825[(4)]))){
var statearr_19844_19876 = state_19825;
(statearr_19844_19876[(1)] = cljs.core.first.call(null,(state_19825[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19877 = state_19825;
state_19825 = G__19877;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$index$state_machine__2879__auto__ = function(state_19825){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2879__auto____1.call(this,state_19825);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2879__auto____0;
fluree$db$index$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2879__auto____1;
return fluree$db$index$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_19845 = f__2902__auto__.call(null);
(statearr_19845[(6)] = c__2901__auto__);

return statearr_19845;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this19740,other19741){
var self__ = this;
var this19740__$1 = this;
return (((!((other19741 == null)))) && ((this19740__$1.constructor === other19741.constructor)) && (cljs.core._EQ_.call(null,this19740__$1.block,other19741.block)) && (cljs.core._EQ_.call(null,this19740__$1.t,other19741.t)) && (cljs.core._EQ_.call(null,this19740__$1.rhs,other19741.rhs)) && (cljs.core._EQ_.call(null,this19740__$1.children,other19741.children)) && (cljs.core._EQ_.call(null,this19740__$1.config,other19741.config)) && (cljs.core._EQ_.call(null,this19740__$1.leftmost_QMARK_,other19741.leftmost_QMARK_)) && (cljs.core._EQ_.call(null,this19740__$1.__extmap,other19741.__extmap)));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"children","children",-940561982),null,new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__19738){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__19846 = cljs.core.keyword_identical_QMARK_;
var expr__19847 = k__4388__auto__;
if(cljs.core.truth_(pred__19846.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__19847))){
return (new fluree.db.index.IndexNode(G__19738,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19846.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__19847))){
return (new fluree.db.index.IndexNode(self__.block,G__19738,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19846.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__19847))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__19738,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19846.call(null,new cljs.core.Keyword(null,"children","children",-940561982),expr__19847))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__19738,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19846.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__19847))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__19738,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19846.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__19847))){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__19738,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__19738),null));
}
}
}
}
}
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"children","children",-940561982),self__.children,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__19738){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__19738,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"children","children",699969545,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null)], null);
}));

(fluree.db.index.IndexNode.cljs$lang$type = true);

(fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
}));

(fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.index/IndexNode");
}));

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__19742){
var extmap__4419__auto__ = (function (){var G__19849 = cljs.core.dissoc.call(null,G__19742,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559));
if(cljs.core.record_QMARK_.call(null,G__19742)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__19849);
} else {
return G__19849;
}
})();
return (new fluree.db.index.IndexNode(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__19742),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__19742),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__19742),new cljs.core.Keyword(null,"children","children",-940561982).cljs$core$IFn$_invoke$arity$1(G__19742),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__19742),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__19742),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k19879,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__19883 = k19879;
var G__19883__$1 = (((G__19883 instanceof cljs.core.Keyword))?G__19883.fqn:null);
switch (G__19883__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k19879,else__4383__auto__);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__19884){
var vec__19885 = p__19884;
var k__4403__auto__ = cljs.core.nth.call(null,vec__19885,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__19885,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.index.DataNode{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"flakes","flakes",1977895739),self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__19878){
var self__ = this;
var G__19878__$1 = this;
return (new cljs.core.RecordIter((0),G__19878__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"config","config",994861415)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_19889){
var state_val_19890 = (state_19889[(1)]);
if((state_val_19890 === (1))){
var state_19889__$1 = state_19889;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19889__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__2879__auto__ = null;
var fluree$db$index$state_machine__2879__auto____0 = (function (){
var statearr_19891 = [null,null,null,null,null,null,null];
(statearr_19891[(0)] = fluree$db$index$state_machine__2879__auto__);

(statearr_19891[(1)] = (1));

return statearr_19891;
});
var fluree$db$index$state_machine__2879__auto____1 = (function (state_19889){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_19889);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e19892){var ex__2882__auto__ = e19892;
var statearr_19893_19913 = state_19889;
(statearr_19893_19913[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_19889[(4)]))){
var statearr_19894_19914 = state_19889;
(statearr_19894_19914[(1)] = cljs.core.first.call(null,(state_19889[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19915 = state_19889;
state_19889 = G__19915;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$index$state_machine__2879__auto__ = function(state_19889){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2879__auto____1.call(this,state_19889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2879__auto____0;
fluree$db$index$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2879__auto____1;
return fluree$db$index$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_19895 = f__2902__auto__.call(null);
(statearr_19895[(6)] = c__2901__auto__);

return statearr_19895;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.call(null,"-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first.call(null,self__.flakes);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (5 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.call(null,"-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.call(null,"-lookup-leaf was called on a data node, which shouldn't happen!");

var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_19901){
var state_val_19902 = (state_19901[(1)]);
if((state_val_19902 === (1))){
var inst_19896 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19897 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_19898 = cljs.core.PersistentHashMap.fromArrays(inst_19896,inst_19897);
var inst_19899 = cljs.core.ex_info.call(null,"-lookup-leaf was called on a data node, which shouldn't happen!",inst_19898);
var state_19901__$1 = state_19901;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19901__$1,inst_19899);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__2879__auto__ = null;
var fluree$db$index$state_machine__2879__auto____0 = (function (){
var statearr_19903 = [null,null,null,null,null,null,null];
(statearr_19903[(0)] = fluree$db$index$state_machine__2879__auto__);

(statearr_19903[(1)] = (1));

return statearr_19903;
});
var fluree$db$index$state_machine__2879__auto____1 = (function (state_19901){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_19901);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e19904){var ex__2882__auto__ = e19904;
var statearr_19905_19916 = state_19901;
(statearr_19905_19916[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_19901[(4)]))){
var statearr_19906_19917 = state_19901;
(statearr_19906_19917[(1)] = cljs.core.first.call(null,(state_19901[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19918 = state_19901;
state_19901 = G__19918;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$index$state_machine__2879__auto__ = function(state_19901){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__2879__auto____1.call(this,state_19901);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__2879__auto____0;
fluree$db$index$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__2879__auto____1;
return fluree$db$index$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_19907 = f__2902__auto__.call(null);
(statearr_19907[(6)] = c__2901__auto__);

return statearr_19907;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this19880,other19881){
var self__ = this;
var this19880__$1 = this;
return (((!((other19881 == null)))) && ((this19880__$1.constructor === other19881.constructor)) && (cljs.core._EQ_.call(null,this19880__$1.block,other19881.block)) && (cljs.core._EQ_.call(null,this19880__$1.t,other19881.t)) && (cljs.core._EQ_.call(null,this19880__$1.flakes,other19881.flakes)) && (cljs.core._EQ_.call(null,this19880__$1.rhs,other19881.rhs)) && (cljs.core._EQ_.call(null,this19880__$1.config,other19881.config)) && (cljs.core._EQ_.call(null,this19880__$1.__extmap,other19881.__extmap)));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"flakes","flakes",1977895739),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__19878){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__19908 = cljs.core.keyword_identical_QMARK_;
var expr__19909 = k__4388__auto__;
if(cljs.core.truth_(pred__19908.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__19909))){
return (new fluree.db.index.DataNode(G__19878,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19908.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__19909))){
return (new fluree.db.index.DataNode(self__.block,G__19878,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19908.call(null,new cljs.core.Keyword(null,"flakes","flakes",1977895739),expr__19909))){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__19878,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19908.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__19909))){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__19878,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__19908.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__19909))){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__19878,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__19878),null));
}
}
}
}
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"flakes","flakes",1977895739),self__.flakes,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__19878){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__19878,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"flakes","flakes",-676540030,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"config","config",-1659574354,null)], null);
}));

(fluree.db.index.DataNode.cljs$lang$type = true);

(fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
}));

(fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.index/DataNode");
}));

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__19882){
var extmap__4419__auto__ = (function (){var G__19911 = cljs.core.dissoc.call(null,G__19882,new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"config","config",994861415));
if(cljs.core.record_QMARK_.call(null,G__19882)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__19911);
} else {
return G__19911;
}
})();
return (new fluree.db.index.DataNode(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__19882),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__19882),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(G__19882),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__19882),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__19882),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode.call(null,block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});
