// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,cljs.core.name.call(null,form)),"?")))){
return cljs.core.symbol.call(null,form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.call(null,(function (value_group){
var stringified = cljs.core.map.call(null,(function (p1__16471_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16471_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.call(null," ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.call(null," ",value_groups);
return ["VALUES ( ",clojure.string.join.call(null," ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__16475 = coll;
var vec__16476 = G__16475;
var seq__16477 = cljs.core.seq.call(null,vec__16476);
var first__16478 = cljs.core.first.call(null,seq__16477);
var seq__16477__$1 = cljs.core.next.call(null,seq__16477);
var clause = first__16478;
var r = seq__16477__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__16475__$1 = G__16475;
var res__$1 = res;
while(true){
var vec__16482 = G__16475__$1;
var seq__16483 = cljs.core.seq.call(null,vec__16482);
var first__16484 = cljs.core.first.call(null,seq__16483);
var seq__16483__$1 = cljs.core.next.call(null,seq__16483);
var clause__$1 = first__16484;
var r__$1 = seq__16483__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__16485 = r__$1;
var G__16486 = cljs.core.conj.call(null,res__$2,clause__$1);
G__16475__$1 = G__16485;
res__$1 = G__16486;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__16490 = coll;
var vec__16491 = G__16490;
var seq__16492 = cljs.core.seq.call(null,vec__16491);
var first__16493 = cljs.core.first.call(null,seq__16492);
var seq__16492__$1 = cljs.core.next.call(null,seq__16492);
var clause = first__16493;
var r = seq__16492__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__16490__$1 = G__16490;
var res__$1 = res;
while(true){
var vec__16497 = G__16490__$1;
var seq__16498 = cljs.core.seq.call(null,vec__16497);
var first__16499 = cljs.core.first.call(null,seq__16498);
var seq__16498__$1 = cljs.core.next.call(null,seq__16498);
var clause__$1 = first__16499;
var r__$1 = seq__16498__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__16500 = r__$1;
var G__16501 = cljs.core.conj.call(null,res__$2,cljs.core.rest.call(null,clause__$1));
G__16490__$1 = G__16500;
res__$1 = G__16501;
continue;
} else {
var G__16502 = r__$1;
var G__16503 = res__$2;
G__16490__$1 = G__16502;
res__$1 = G__16503;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__16507 = coll;
var vec__16508 = G__16507;
var seq__16509 = cljs.core.seq.call(null,vec__16508);
var first__16510 = cljs.core.first.call(null,seq__16509);
var seq__16509__$1 = cljs.core.next.call(null,seq__16509);
var clause = first__16510;
var r = seq__16509__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__16507__$1 = G__16507;
var res__$1 = res;
while(true){
var vec__16514 = G__16507__$1;
var seq__16515 = cljs.core.seq.call(null,vec__16514);
var first__16516 = cljs.core.first.call(null,seq__16515);
var seq__16515__$1 = cljs.core.next.call(null,seq__16515);
var clause__$1 = first__16516;
var r__$1 = seq__16515__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.call(null,"$wd",cljs.core.first.call(null,clause__$1))){
var G__16517 = r__$1;
var G__16518 = res__$2;
G__16507__$1 = G__16517;
res__$1 = G__16518;
continue;
} else {
var G__16519 = r__$1;
var G__16520 = cljs.core.conj.call(null,res__$2,clause__$1);
G__16507__$1 = G__16519;
res__$1 = G__16520;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_(((typeof string === 'string')?cljs.core.re_matches.call(null,/^wd(t)*:(P|Q)\d+$/,string):false))){
cljs.core.symbol.call(null,string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var clause_str = [clojure.string.join.call(null," ",cljs.core.map.call(null,fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,clause)),"."].join('');
if(cljs.core.truth_(optional_QMARK_)){
return ["OPTIONAL {",clause_str,"}"].join('');
} else {
return clause_str;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.call(null,(function (acc_str,prefix){
var pfx = cljs.core.symbol.call(null,[fluree.db.util.core.keyword__GT_str.call(null,cljs.core.key.call(null,prefix)),":"].join(''));
var source = cljs.core.symbol.call(null,cljs.core.val.call(null,prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"limit","limit",-1355822363),(100),new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"distinct","distinct",-1788879121),false,new cljs.core.Keyword(null,"language","language",-1591107564),"en"], null),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132).cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"wikidataOpts","wikidataOpts",646884132)], null),q_map));
var map__16524 = opts;
var map__16524__$1 = (((((!((map__16524 == null))))?(((((map__16524.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16524.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16524):map__16524);
var limit = cljs.core.get.call(null,map__16524__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__16524__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var distinct = cljs.core.get.call(null,map__16524__$1,new cljs.core.Keyword(null,"distinct","distinct",-1788879121));
var language = cljs.core.get.call(null,map__16524__$1,new cljs.core.Keyword(null,"language","language",-1591107564));
var prefixes = cljs.core.get.call(null,map__16524__$1,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes.call(null,prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.call(null," ",cljs.core.map.call(null,(function (p1__16521_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16521_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.call(null," ",select_vars)].join('');
var where_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__16522_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__16522_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.call(null," ",cljs.core.mapv.call(null,(function (p1__16523_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata.call(null,p1__16523_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4126__auto__ = language;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_16539){
var state_val_16540 = (state_16539[(1)]);
if((state_val_16540 === (1))){
var inst_16526 = fluree.db.util.core.url_encode.call(null,query);
var inst_16527 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_16526)].join('');
var inst_16528 = ["User-Agent","Accept"];
var inst_16529 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_16530 = cljs.core.PersistentHashMap.fromArrays(inst_16528,inst_16529);
var inst_16531 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),new cljs.core.Keyword(null,"output-format","output-format",-1826382676)];
var inst_16532 = [inst_16530,(30000),new cljs.core.Keyword(null,"wikidata","wikidata",2100084440)];
var inst_16533 = cljs.core.PersistentHashMap.fromArrays(inst_16531,inst_16532);
var inst_16534 = fluree.db.util.xhttp.get.call(null,inst_16527,inst_16533);
var state_16539__$1 = state_16539;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16539__$1,(2),inst_16534);
} else {
if((state_val_16540 === (2))){
var inst_16536 = (state_16539[(2)]);
var inst_16537 = fluree.db.util.async.throw_err.call(null,inst_16536);
var state_16539__$1 = state_16539;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16539__$1,inst_16537);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto____0 = (function (){
var statearr_16541 = [null,null,null,null,null,null,null];
(statearr_16541[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto__);

(statearr_16541[(1)] = (1));

return statearr_16541;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto____1 = (function (state_16539){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_16539);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e16542){var ex__2882__auto__ = e16542;
var statearr_16543_16546 = state_16539;
(statearr_16543_16546[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_16539[(4)]))){
var statearr_16544_16547 = state_16539;
(statearr_16544_16547[(1)] = cljs.core.first.call(null,(state_16539[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16548 = state_16539;
state_16539 = G__16548;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto__ = function(state_16539){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto____1.call(this,state_16539);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_16545 = f__2902__auto__.call(null);
(statearr_16545[(6)] = c__2901__auto__);

return statearr_16545;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_16566){
var state_val_16567 = (state_16566[(1)]);
if((state_val_16567 === (1))){
var inst_16549 = fluree.db.query.analytical_wikidata.submit_wikidata_query.call(null,query);
var state_16566__$1 = state_16566;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16566__$1,(2),inst_16549);
} else {
if((state_val_16567 === (2))){
var inst_16552 = (state_16566[(7)]);
var inst_16551 = (state_16566[(2)]);
var inst_16552__$1 = fluree.db.util.async.throw_err.call(null,inst_16551);
var inst_16553 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_16552__$1);
var inst_16554 = cljs.core.not_EQ_.call(null,(200),inst_16553);
var state_16566__$1 = (function (){var statearr_16568 = state_16566;
(statearr_16568[(7)] = inst_16552__$1);

return statearr_16568;
})();
if(inst_16554){
var statearr_16569_16578 = state_16566__$1;
(statearr_16569_16578[(1)] = (3));

} else {
var statearr_16570_16579 = state_16566__$1;
(statearr_16570_16579[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16567 === (3))){
var inst_16552 = (state_16566[(7)]);
var state_16566__$1 = state_16566;
var statearr_16571_16580 = state_16566__$1;
(statearr_16571_16580[(2)] = inst_16552);

(statearr_16571_16580[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16567 === (4))){
var inst_16552 = (state_16566[(7)]);
var inst_16557 = (function (){var body = inst_16552;
return (function (item){
return cljs.core.reduce.call(null,(function (acc,k_v){
return cljs.core.assoc.call(null,acc,cljs.core.key.call(null,k_v),new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_16558 = cljs.core.second.call(null,inst_16552);
var inst_16559 = cljs.core.second.call(null,inst_16558);
var inst_16560 = cljs.core.first.call(null,inst_16559);
var inst_16561 = cljs.core.second.call(null,inst_16560);
var inst_16562 = cljs.core.mapv.call(null,inst_16557,inst_16561);
var state_16566__$1 = state_16566;
var statearr_16572_16581 = state_16566__$1;
(statearr_16572_16581[(2)] = inst_16562);

(statearr_16572_16581[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16567 === (5))){
var inst_16564 = (state_16566[(2)]);
var state_16566__$1 = state_16566;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16566__$1,inst_16564);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto____0 = (function (){
var statearr_16573 = [null,null,null,null,null,null,null,null];
(statearr_16573[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto__);

(statearr_16573[(1)] = (1));

return statearr_16573;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto____1 = (function (state_16566){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_16566);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e16574){var ex__2882__auto__ = e16574;
var statearr_16575_16582 = state_16566;
(statearr_16575_16582[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_16566[(4)]))){
var statearr_16576_16583 = state_16566;
(statearr_16576_16583[(1)] = cljs.core.first.call(null,(state_16566[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16584 = state_16566;
state_16566 = G__16584;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto__ = function(state_16566){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto____1.call(this,state_16566);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_16577 = f__2902__auto__.call(null);
(statearr_16577[(6)] = c__2901__auto__);

return statearr_16577;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.call(null,(function (p1__16585_SHARP_){
return cljs.core.symbol.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16585_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.call(null,cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.call(null,(function (p1__16586_SHARP_){
return fluree.db.util.core.str__GT_keyword.call(null,cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__16586_SHARP_),(1)));
}),headers);
var results = new cljs.core.Keyword(null,"bindings","bindings",1271397192).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.call(null,(function (res){
return cljs.core.map.call(null,(function (p1__16587_SHARP_){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__16587_SHARP_.call(null,res));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"headers","headers",-835030129),headers,new cljs.core.Keyword(null,"vars","vars",-2046957217),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"tuples","tuples",-676032639),tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_16653){
var state_val_16654 = (state_16653[(1)]);
if((state_val_16654 === (7))){
var inst_16598 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt.call(null,matching_vars,matching_vals);
var state_16653__$1 = state_16653;
var statearr_16655_16696 = state_16653__$1;
(statearr_16655_16696[(2)] = inst_16598);

(statearr_16655_16696[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (20))){
var inst_16626 = (state_16653[(7)]);
var inst_16646 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples.call(null,inst_16626,all_vars);
var state_16653__$1 = state_16653;
var statearr_16656_16697 = state_16653__$1;
(statearr_16656_16697[(2)] = inst_16646);

(statearr_16656_16697[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (1))){
var state_16653__$1 = state_16653;
var statearr_16657_16698 = state_16653__$1;
(statearr_16657_16698[(2)] = null);

(statearr_16657_16698[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (24))){
var inst_16627 = (state_16653[(8)]);
var inst_16632 = (state_16653[(9)]);
var inst_16626 = (state_16653[(7)]);
var inst_16637 = (state_16653[(2)]);
var inst_16638 = cljs.core.subs.call(null,inst_16632,(0),inst_16637);
var inst_16639 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_16640 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_16626);
var inst_16641 = [inst_16627,inst_16640];
var inst_16642 = cljs.core.PersistentHashMap.fromArrays(inst_16639,inst_16641);
var inst_16643 = cljs.core.ex_info.call(null,inst_16638,inst_16642);
var inst_16644 = (function(){throw inst_16643})();
var state_16653__$1 = state_16653;
var statearr_16658_16699 = state_16653__$1;
(statearr_16658_16699[(2)] = inst_16644);

(statearr_16658_16699[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (4))){
var inst_16588 = (state_16653[(2)]);
var state_16653__$1 = state_16653;
var statearr_16659_16700 = state_16653__$1;
(statearr_16659_16700[(2)] = inst_16588);

(statearr_16659_16700[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (15))){
var inst_16618 = (state_16653[(2)]);
var state_16653__$1 = state_16653;
var statearr_16660_16701 = state_16653__$1;
(statearr_16660_16701[(2)] = inst_16618);

(statearr_16660_16701[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (21))){
var inst_16648 = (state_16653[(2)]);
var _ = (function (){var statearr_16661 = state_16653;
(statearr_16661[(4)] = cljs.core.rest.call(null,(state_16653[(4)])));

return statearr_16661;
})();
var state_16653__$1 = state_16653;
var statearr_16662_16702 = state_16653__$1;
(statearr_16662_16702[(2)] = inst_16648);

(statearr_16662_16702[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (13))){
var state_16653__$1 = state_16653;
var statearr_16663_16703 = state_16653__$1;
(statearr_16663_16703[(2)] = true);

(statearr_16663_16703[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (22))){
var inst_16631 = (state_16653[(10)]);
var state_16653__$1 = state_16653;
var statearr_16664_16704 = state_16653__$1;
(statearr_16664_16704[(2)] = inst_16631);

(statearr_16664_16704[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (6))){
var state_16653__$1 = state_16653;
var statearr_16665_16705 = state_16653__$1;
(statearr_16665_16705[(2)] = null);

(statearr_16665_16705[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (17))){
var inst_16605 = (state_16653[(11)]);
var state_16653__$1 = state_16653;
var statearr_16666_16706 = state_16653__$1;
(statearr_16666_16706[(2)] = inst_16605);

(statearr_16666_16706[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (3))){
var inst_16651 = (state_16653[(2)]);
var state_16653__$1 = state_16653;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16653__$1,inst_16651);
} else {
if((state_val_16654 === (12))){
var inst_16621 = (state_16653[(2)]);
var state_16653__$1 = state_16653;
if(cljs.core.truth_(inst_16621)){
var statearr_16667_16707 = state_16653__$1;
(statearr_16667_16707[(1)] = (16));

} else {
var statearr_16668_16708 = state_16653__$1;
(statearr_16668_16708[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (2))){
var _ = (function (){var statearr_16669 = state_16653;
(statearr_16669[(4)] = cljs.core.cons.call(null,(5),(state_16653[(4)])));

return statearr_16669;
})();
var inst_16595 = cljs.core.empty_QMARK_.call(null,matching_vars);
var state_16653__$1 = state_16653;
if(inst_16595){
var statearr_16670_16709 = state_16653__$1;
(statearr_16670_16709[(1)] = (6));

} else {
var statearr_16671_16710 = state_16653__$1;
(statearr_16671_16710[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (23))){
var state_16653__$1 = state_16653;
var statearr_16672_16711 = state_16653__$1;
(statearr_16672_16711[(2)] = (1000));

(statearr_16672_16711[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (19))){
var inst_16628 = (state_16653[(12)]);
var inst_16631 = (state_16653[(10)]);
var inst_16626 = (state_16653[(7)]);
var inst_16631__$1 = cljs.core.count.call(null,inst_16628);
var inst_16632 = new cljs.core.Keyword(null,"message","message",-406056002).cljs$core$IFn$_invoke$arity$1(inst_16626);
var inst_16633 = (inst_16631__$1 < (1000));
var state_16653__$1 = (function (){var statearr_16673 = state_16653;
(statearr_16673[(10)] = inst_16631__$1);

(statearr_16673[(9)] = inst_16632);

return statearr_16673;
})();
if(cljs.core.truth_(inst_16633)){
var statearr_16674_16712 = state_16653__$1;
(statearr_16674_16712[(1)] = (22));

} else {
var statearr_16675_16713 = state_16653__$1;
(statearr_16675_16713[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (11))){
var state_16653__$1 = state_16653;
var statearr_16677_16714 = state_16653__$1;
(statearr_16677_16714[(2)] = false);

(statearr_16677_16714[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (9))){
var inst_16605 = (state_16653[(11)]);
var inst_16604 = (state_16653[(2)]);
var inst_16605__$1 = fluree.db.util.async.throw_err.call(null,inst_16604);
var inst_16607 = (inst_16605__$1 == null);
var inst_16608 = cljs.core.not.call(null,inst_16607);
var state_16653__$1 = (function (){var statearr_16678 = state_16653;
(statearr_16678[(11)] = inst_16605__$1);

return statearr_16678;
})();
if(inst_16608){
var statearr_16679_16715 = state_16653__$1;
(statearr_16679_16715[(1)] = (10));

} else {
var statearr_16680_16716 = state_16653__$1;
(statearr_16680_16716[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (5))){
var _ = (function (){var statearr_16681 = state_16653;
(statearr_16681[(4)] = cljs.core.rest.call(null,(state_16653[(4)])));

return statearr_16681;
})();
var state_16653__$1 = state_16653;
var ex16676 = (state_16653__$1[(2)]);
var statearr_16682_16717 = state_16653__$1;
(statearr_16682_16717[(5)] = ex16676);


if((ex16676 instanceof Error)){
var statearr_16683_16718 = state_16653__$1;
(statearr_16683_16718[(1)] = (4));

(statearr_16683_16718[(5)] = null);

} else {
throw ex16676;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (14))){
var state_16653__$1 = state_16653;
var statearr_16684_16719 = state_16653__$1;
(statearr_16684_16719[(2)] = false);

(statearr_16684_16719[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (16))){
var inst_16605 = (state_16653[(11)]);
var inst_16623 = cljs.core.apply.call(null,cljs.core.hash_map,inst_16605);
var state_16653__$1 = state_16653;
var statearr_16685_16720 = state_16653__$1;
(statearr_16685_16720[(2)] = inst_16623);

(statearr_16685_16720[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (10))){
var inst_16605 = (state_16653[(11)]);
var inst_16610 = inst_16605.cljs$lang$protocol_mask$partition0$;
var inst_16611 = (inst_16610 & (64));
var inst_16612 = inst_16605.cljs$core$ISeq$;
var inst_16613 = (cljs.core.PROTOCOL_SENTINEL === inst_16612);
var inst_16614 = ((inst_16611) || (inst_16613));
var state_16653__$1 = state_16653;
if(cljs.core.truth_(inst_16614)){
var statearr_16686_16721 = state_16653__$1;
(statearr_16686_16721[(1)] = (13));

} else {
var statearr_16687_16722 = state_16653__$1;
(statearr_16687_16722[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (18))){
var inst_16627 = (state_16653[(8)]);
var inst_16626 = (state_16653[(7)]);
var inst_16626__$1 = (state_16653[(2)]);
var inst_16627__$1 = cljs.core.get.call(null,inst_16626__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_16628 = cljs.core.get.call(null,inst_16626__$1,new cljs.core.Keyword(null,"message","message",-406056002));
var inst_16629 = cljs.core._EQ_.call(null,(400),inst_16627__$1);
var state_16653__$1 = (function (){var statearr_16688 = state_16653;
(statearr_16688[(12)] = inst_16628);

(statearr_16688[(8)] = inst_16627__$1);

(statearr_16688[(7)] = inst_16626__$1);

return statearr_16688;
})();
if(inst_16629){
var statearr_16689_16723 = state_16653__$1;
(statearr_16689_16723[(1)] = (19));

} else {
var statearr_16690_16724 = state_16653__$1;
(statearr_16690_16724[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16654 === (8))){
var inst_16600 = (state_16653[(2)]);
var inst_16601 = fluree.db.query.analytical_wikidata.generateWikiDataQuery.call(null,q_map,clauses,all_vars,inst_16600,optional_clauses);
var inst_16602 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query.call(null,inst_16601);
var state_16653__$1 = state_16653;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16653__$1,(9),inst_16602);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto____0 = (function (){
var statearr_16691 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_16691[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto__);

(statearr_16691[(1)] = (1));

return statearr_16691;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto____1 = (function (state_16653){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_16653);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e16692){var ex__2882__auto__ = e16692;
var statearr_16693_16725 = state_16653;
(statearr_16693_16725[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_16653[(4)]))){
var statearr_16694_16726 = state_16653;
(statearr_16694_16726[(1)] = cljs.core.first.call(null,(state_16653[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16727 = state_16653;
state_16653 = G__16727;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto__ = function(state_16653){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto____1.call(this,state_16653);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_16695 = f__2902__auto__.call(null);
(statearr_16695[(6)] = c__2901__auto__);

return statearr_16695;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
