// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__22004 = null;
var G__22004__0 = (function (){
return xf.call(null);
});
var G__22004__1 = (function (result){
return xf.call(null,result);
});
var G__22004__2 = (function (result,flake){
cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + (1)));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
}

return xf.call(null,result,flake);
});
G__22004 = function(result,flake){
switch(arguments.length){
case 0:
return G__22004__0.call(this);
case 1:
return G__22004__1.call(this,result);
case 2:
return G__22004__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22004.cljs$core$IFn$_invoke$arity$0 = G__22004__0;
G__22004.cljs$core$IFn$_invoke$arity$1 = G__22004__1;
G__22004.cljs$core$IFn$_invoke$arity$2 = G__22004__2;
return G__22004;
})()
});
});
/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__22005 = null;
var G__22005__0 = (function (){
return xf.call(null);
});
var G__22005__1 = (function (result){
return xf.call(null,result);
});
var G__22005__2 = (function (result,flakes){
cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + cljs.core.count.call(null,flakes)));

return xf.call(null,result,flakes);
});
G__22005 = function(result,flakes){
switch(arguments.length){
case 0:
return G__22005__0.call(this);
case 1:
return G__22005__1.call(this,result);
case 2:
return G__22005__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__22005.cljs$core$IFn$_invoke$arity$0 = G__22005__0;
G__22005.cljs$core$IFn$_invoke$arity$1 = G__22005__1;
G__22005.cljs$core$IFn$_invoke$arity$2 = G__22005__2;
return G__22005;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_.call(null,fuel,(cljs.core._deref.call(null,fuel) + n));

if(cljs.core.truth_((function (){var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref.call(null,fuel) > max_fuel);
} else {
return and__4115__auto__;
}
})())){
throw cljs.core.ex_info.call(null,["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","exceeded-cost","db/exceeded-cost",-915096223)], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4126__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config.call(null,db,p,compact_QMARK_);
cljs.core._vreset_BANG_.call(null,cache,cljs.core.assoc_in.call(null,cljs.core._deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare.call(null,clojure.string.upper_case.call(null,a),clojure.string.upper_case.call(null,b));
if(cljs.core._EQ_.call(null,res,(0))){
return ((-1) * cljs.core.compare.call(null,a,b));
} else {
return res;
}
} else {
return cljs.core.compare.call(null,a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_.call(null,res)){
var G__22007 = res;
var G__22007__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.call(null,(function (p1__22006_SHARP_){
return cljs.core.get.call(null,p1__22006_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__22007):G__22007);
var G__22007__$2 = ((cljs.core._EQ_.call(null,"DESC",sortOrder))?cljs.core.reverse.call(null,G__22007__$1):G__22007__$1);
var G__22007__$3 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__22007__$2):G__22007__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.call(null,limit,G__22007__$3);
} else {
return G__22007__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__22009 = arguments.length;
switch (G__22009) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_22312){
var state_val_22313 = (state_22312[(1)]);
if((state_val_22313 === (65))){
var inst_22039 = (state_22312[(7)]);
var inst_22170 = (state_22312[(8)]);
var inst_22163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22164 = cljs.core.deref.call(null,cache);
var inst_22165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22166 = flake.o;
var inst_22167 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22039);
var inst_22168 = [inst_22166,inst_22167];
var inst_22169 = (new cljs.core.PersistentVector(null,2,(5),inst_22165,inst_22168,null));
var inst_22170__$1 = cljs.core.get.call(null,inst_22164,inst_22169);
var state_22312__$1 = (function (){var statearr_22314 = state_22312;
(statearr_22314[(9)] = inst_22163);

(statearr_22314[(8)] = inst_22170__$1);

return statearr_22314;
})();
if(cljs.core.truth_(inst_22170__$1)){
var statearr_22315_22475 = state_22312__$1;
(statearr_22315_22475[(1)] = (68));

} else {
var statearr_22316_22476 = state_22312__$1;
(statearr_22316_22476[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (70))){
var inst_22163 = (state_22312[(9)]);
var inst_22188 = (state_22312[(2)]);
var inst_22189 = [inst_22188,offset_map];
var inst_22190 = (new cljs.core.PersistentVector(null,2,(5),inst_22163,inst_22189,null));
var state_22312__$1 = state_22312;
var statearr_22317_22477 = state_22312__$1;
(statearr_22317_22477[(2)] = inst_22190);

(statearr_22317_22477[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (62))){
var inst_22071 = (state_22312[(10)]);
var inst_22072 = (state_22312[(11)]);
var inst_22076 = (state_22312[(12)]);
var inst_22148 = (state_22312[(13)]);
var inst_22033 = (state_22312[(14)]);
var inst_22073 = (state_22312[(15)]);
var inst_22077 = (state_22312[(16)]);
var inst_22050 = (state_22312[(17)]);
var inst_22132 = (state_22312[(18)]);
var inst_22039 = (state_22312[(7)]);
var inst_22074 = (state_22312[(19)]);
var inst_22075 = (state_22312[(20)]);
var inst_22150 = (function (){var p = inst_22077;
var pred_spec__$1 = inst_22033;
var orderBy = inst_22075;
var nested_select_spec = inst_22132;
var multi_QMARK_ = inst_22072;
var limit = inst_22074;
var offset = inst_22076;
var map__22016 = inst_22071;
var k = inst_22050;
var pred_spec_SINGLEQUOTE_ = inst_22039;
var ref_QMARK_ = inst_22073;
var G__22134 = inst_22148;
return (function (n){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n);
});
})();
var inst_22151 = inst_22150.call(null,inst_22148);
var state_22312__$1 = state_22312;
var statearr_22318_22478 = state_22312__$1;
(statearr_22318_22478[(2)] = inst_22151);

(statearr_22318_22478[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (74))){
var inst_22197 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
if(cljs.core.truth_(inst_22197)){
var statearr_22319_22479 = state_22312__$1;
(statearr_22319_22479[(1)] = (75));

} else {
var statearr_22320_22480 = state_22312__$1;
(statearr_22320_22480[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (7))){
var inst_22020 = (state_22312[(21)]);
var state_22312__$1 = state_22312;
var statearr_22321_22481 = state_22312__$1;
(statearr_22321_22481[(2)] = inst_22020);

(statearr_22321_22481[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (59))){
var inst_22142 = (state_22312[(22)]);
var inst_22144 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_22145 = cljs.core.sequence.call(null,inst_22144,inst_22142);
var state_22312__$1 = state_22312;
var statearr_22322_22482 = state_22312__$1;
(statearr_22322_22482[(2)] = inst_22145);

(statearr_22322_22482[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (86))){
var inst_22071 = (state_22312[(10)]);
var inst_22072 = (state_22312[(11)]);
var inst_22076 = (state_22312[(12)]);
var inst_22033 = (state_22312[(14)]);
var inst_22228 = (state_22312[(23)]);
var inst_22073 = (state_22312[(15)]);
var inst_22077 = (state_22312[(16)]);
var inst_22050 = (state_22312[(17)]);
var inst_22039 = (state_22312[(7)]);
var inst_22074 = (state_22312[(19)]);
var inst_22210 = (state_22312[(24)]);
var inst_22075 = (state_22312[(20)]);
var inst_22230 = (function (){var G__22222 = inst_22228;
var p = inst_22077;
var pred_spec__$1 = inst_22033;
var orderBy = inst_22075;
var children = inst_22210;
var multi_QMARK_ = inst_22072;
var limit = inst_22074;
var offset = inst_22076;
var map__22016 = inst_22071;
var k = inst_22050;
var pred_spec_SINGLEQUOTE_ = inst_22039;
var ref_QMARK_ = inst_22073;
return (function (n){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),true], null),n);
});
})();
var inst_22231 = inst_22230.call(null,inst_22228);
var state_22312__$1 = state_22312;
var statearr_22323_22483 = state_22312__$1;
(statearr_22323_22483[(2)] = inst_22231);

(statearr_22323_22483[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (20))){
var inst_22048 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
var statearr_22324_22484 = state_22312__$1;
(statearr_22324_22484[(2)] = inst_22048);

(statearr_22324_22484[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (72))){
var inst_22039 = (state_22312[(7)]);
var inst_22194 = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(inst_22039);
var state_22312__$1 = state_22312;
var statearr_22325_22485 = state_22312__$1;
(statearr_22325_22485[(2)] = inst_22194);

(statearr_22325_22485[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (58))){
var inst_22141 = (state_22312[(2)]);
var inst_22142 = fluree.db.util.async.throw_err.call(null,inst_22141);
var state_22312__$1 = (function (){var statearr_22326 = state_22312;
(statearr_22326[(22)] = inst_22142);

return statearr_22326;
})();
if(cljs.core.truth_(fuel)){
var statearr_22327_22486 = state_22312__$1;
(statearr_22327_22486[(1)] = (59));

} else {
var statearr_22328_22487 = state_22312__$1;
(statearr_22328_22487[(1)] = (60));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (60))){
var inst_22142 = (state_22312[(22)]);
var state_22312__$1 = state_22312;
var statearr_22329_22488 = state_22312__$1;
(statearr_22329_22488[(2)] = inst_22142);

(statearr_22329_22488[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (27))){
var inst_22039 = (state_22312[(7)]);
var inst_22068 = cljs.core.apply.call(null,cljs.core.hash_map,inst_22039);
var state_22312__$1 = state_22312;
var statearr_22330_22489 = state_22312__$1;
(statearr_22330_22489[(2)] = inst_22068);

(statearr_22330_22489[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (1))){
var state_22312__$1 = state_22312;
var statearr_22331_22490 = state_22312__$1;
(statearr_22331_22490[(2)] = null);

(statearr_22331_22490[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (69))){
var inst_22039 = (state_22312[(7)]);
var inst_22173 = flake.o;
var inst_22174 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22039);
var inst_22175 = fluree.db.dbproto._tag.call(null,db,inst_22173,inst_22174);
var state_22312__$1 = state_22312;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22312__$1,(71),inst_22175);
} else {
if((state_val_22313 === (101))){
var inst_22050 = (state_22312[(17)]);
var inst_22273 = (state_22312[(25)]);
var inst_22272 = (state_22312[(26)]);
var inst_22292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22293 = cljs.core.assoc.call(null,acc,inst_22050,inst_22272);
var inst_22294 = [inst_22293,inst_22273];
var inst_22295 = (new cljs.core.PersistentVector(null,2,(5),inst_22292,inst_22294,null));
var state_22312__$1 = state_22312;
var statearr_22332_22491 = state_22312__$1;
(statearr_22332_22491[(2)] = inst_22295);

(statearr_22332_22491[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (24))){
var state_22312__$1 = state_22312;
var statearr_22333_22492 = state_22312__$1;
(statearr_22333_22492[(2)] = true);

(statearr_22333_22492[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (102))){
var state_22312__$1 = state_22312;
var statearr_22334_22493 = state_22312__$1;
(statearr_22334_22493[(1)] = (104));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (55))){
var inst_22039 = (state_22312[(7)]);
var inst_22161 = new cljs.core.Keyword(null,"tag?","tag?",1714008252).cljs$core$IFn$_invoke$arity$1(inst_22039);
var state_22312__$1 = state_22312;
if(cljs.core.truth_(inst_22161)){
var statearr_22336_22494 = state_22312__$1;
(statearr_22336_22494[(1)] = (65));

} else {
var statearr_22337_22495 = state_22312__$1;
(statearr_22337_22495[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (85))){
var inst_22228 = (state_22312[(2)]);
var state_22312__$1 = (function (){var statearr_22338 = state_22312;
(statearr_22338[(23)] = inst_22228);

return statearr_22338;
})();
var statearr_22339_22496 = state_22312__$1;
(statearr_22339_22496[(1)] = (86));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (39))){
var inst_22077 = (state_22312[(16)]);
var inst_22094 = cljs.core.update.call(null,offset_map,inst_22077,cljs.core.dec);
var state_22312__$1 = state_22312;
var statearr_22341_22497 = state_22312__$1;
(statearr_22341_22497[(2)] = inst_22094);

(statearr_22341_22497[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (88))){
var inst_22234 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22312__$1,(82),inst_22234);
} else {
if((state_val_22313 === (46))){
var inst_22117 = cljs.core.not.call(null,recur_QMARK_);
var state_22312__$1 = state_22312;
if(inst_22117){
var statearr_22342_22498 = state_22312__$1;
(statearr_22342_22498[(1)] = (48));

} else {
var statearr_22343_22499 = state_22312__$1;
(statearr_22343_22499[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (4))){
var inst_22010 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
var statearr_22344_22500 = state_22312__$1;
(statearr_22344_22500[(2)] = inst_22010);

(statearr_22344_22500[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (77))){
var inst_22263 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
var statearr_22345_22501 = state_22312__$1;
(statearr_22345_22501[(2)] = inst_22263);

(statearr_22345_22501[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (106))){
var inst_22303 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
var statearr_22346_22502 = state_22312__$1;
(statearr_22346_22502[(2)] = inst_22303);

(statearr_22346_22502[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (95))){
var inst_22072 = (state_22312[(11)]);
var state_22312__$1 = state_22312;
var statearr_22347_22503 = state_22312__$1;
(statearr_22347_22503[(2)] = inst_22072);

(statearr_22347_22503[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (54))){
var inst_22039 = (state_22312[(7)]);
var inst_22129 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22130 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_22131 = (new cljs.core.PersistentVector(null,3,(5),inst_22129,inst_22130,null));
var inst_22132 = cljs.core.select_keys.call(null,inst_22039,inst_22131);
var inst_22133 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22136 = flake.o;
var inst_22137 = [inst_22136];
var inst_22138 = (new cljs.core.PersistentVector(null,1,(5),inst_22135,inst_22137,null));
var inst_22139 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22138);
var state_22312__$1 = (function (){var statearr_22348 = state_22312;
(statearr_22348[(18)] = inst_22132);

(statearr_22348[(27)] = inst_22133);

return statearr_22348;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22312__$1,(58),inst_22139);
} else {
if((state_val_22313 === (92))){
var inst_22253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22254 = flake.o;
var inst_22255 = [inst_22254,offset_map];
var inst_22256 = (new cljs.core.PersistentVector(null,2,(5),inst_22253,inst_22255,null));
var state_22312__$1 = state_22312;
var statearr_22349_22504 = state_22312__$1;
(statearr_22349_22504[(2)] = inst_22256);

(statearr_22349_22504[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (104))){
var inst_22273 = (state_22312[(25)]);
var inst_22298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22299 = [acc,inst_22273];
var inst_22300 = (new cljs.core.PersistentVector(null,2,(5),inst_22298,inst_22299,null));
var state_22312__$1 = state_22312;
var statearr_22350_22505 = state_22312__$1;
(statearr_22350_22505[(2)] = inst_22300);

(statearr_22350_22505[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (15))){
var inst_22040 = (state_22312[(28)]);
var state_22312__$1 = state_22312;
var statearr_22351_22506 = state_22312__$1;
(statearr_22351_22506[(2)] = inst_22040);

(statearr_22351_22506[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (48))){
var inst_22119 = (state_22312[(29)]);
var inst_22039 = (state_22312[(7)]);
var inst_22119__$1 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_22039);
var state_22312__$1 = (function (){var statearr_22352 = state_22312;
(statearr_22352[(29)] = inst_22119__$1);

return statearr_22352;
})();
if(cljs.core.truth_(inst_22119__$1)){
var statearr_22353_22507 = state_22312__$1;
(statearr_22353_22507[(1)] = (51));

} else {
var statearr_22354_22508 = state_22312__$1;
(statearr_22354_22508[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (50))){
var inst_22127 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
if(cljs.core.truth_(inst_22127)){
var statearr_22355_22509 = state_22312__$1;
(statearr_22355_22509[(1)] = (54));

} else {
var statearr_22356_22510 = state_22312__$1;
(statearr_22356_22510[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (75))){
var inst_22039 = (state_22312[(7)]);
var inst_22199 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22200 = flake.o;
var inst_22201 = [inst_22200];
var inst_22202 = (new cljs.core.PersistentVector(null,1,(5),inst_22199,inst_22201,null));
var inst_22203 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22204 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(inst_22039);
var inst_22205 = [inst_22204];
var inst_22206 = cljs.core.PersistentHashMap.fromArrays(inst_22203,inst_22205);
var inst_22207 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22202,inst_22206);
var state_22312__$1 = state_22312;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22312__$1,(78),inst_22207);
} else {
if((state_val_22313 === (99))){
var inst_22272 = (state_22312[(26)]);
var inst_22289 = (inst_22272 == null);
var inst_22290 = cljs.core.not.call(null,inst_22289);
var state_22312__$1 = state_22312;
if(inst_22290){
var statearr_22357_22511 = state_22312__$1;
(statearr_22357_22511[(1)] = (101));

} else {
var statearr_22358_22512 = state_22312__$1;
(statearr_22358_22512[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (21))){
var inst_22039 = (state_22312[(7)]);
var inst_22055 = inst_22039.cljs$lang$protocol_mask$partition0$;
var inst_22056 = (inst_22055 & (64));
var inst_22057 = inst_22039.cljs$core$ISeq$;
var inst_22058 = (cljs.core.PROTOCOL_SENTINEL === inst_22057);
var inst_22059 = ((inst_22056) || (inst_22058));
var state_22312__$1 = state_22312;
if(cljs.core.truth_(inst_22059)){
var statearr_22359_22513 = state_22312__$1;
(statearr_22359_22513[(1)] = (24));

} else {
var statearr_22360_22514 = state_22312__$1;
(statearr_22360_22514[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (31))){
var inst_22072 = (state_22312[(11)]);
var state_22312__$1 = state_22312;
var statearr_22361_22515 = state_22312__$1;
(statearr_22361_22515[(2)] = inst_22072);

(statearr_22361_22515[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (32))){
var inst_22089 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
if(cljs.core.truth_(inst_22089)){
var statearr_22362_22516 = state_22312__$1;
(statearr_22362_22516[(1)] = (36));

} else {
var statearr_22363_22517 = state_22312__$1;
(statearr_22363_22517[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (40))){
var inst_22076 = (state_22312[(12)]);
var inst_22077 = (state_22312[(16)]);
var inst_22096 = (inst_22076 - (1));
var inst_22097 = cljs.core.assoc.call(null,offset_map,inst_22077,inst_22096);
var state_22312__$1 = state_22312;
var statearr_22364_22518 = state_22312__$1;
(statearr_22364_22518[(2)] = inst_22097);

(statearr_22364_22518[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (91))){
var inst_22261 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
var statearr_22365_22519 = state_22312__$1;
(statearr_22365_22519[(2)] = inst_22261);

(statearr_22365_22519[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (56))){
var inst_22267 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
var statearr_22366_22520 = state_22312__$1;
(statearr_22366_22520[(2)] = inst_22267);

(statearr_22366_22520[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (33))){
var inst_22076 = (state_22312[(12)]);
var inst_22077 = (state_22312[(16)]);
var inst_22080 = cljs.core.not_EQ_.call(null,(0),inst_22076);
var inst_22081 = cljs.core.get.call(null,offset_map,inst_22077);
var inst_22082 = cljs.core.not_EQ_.call(null,(0),inst_22081);
var inst_22083 = ((inst_22080) && (inst_22082));
var state_22312__$1 = state_22312;
var statearr_22367_22521 = state_22312__$1;
(statearr_22367_22521[(2)] = inst_22083);

(statearr_22367_22521[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (13))){
var inst_22033 = (state_22312[(14)]);
var inst_22037 = cljs.core.assoc.call(null,inst_22033,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),componentFollow_QMARK_);
var state_22312__$1 = state_22312;
var statearr_22368_22522 = state_22312__$1;
(statearr_22368_22522[(2)] = inst_22037);

(statearr_22368_22522[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (22))){
var state_22312__$1 = state_22312;
var statearr_22369_22523 = state_22312__$1;
(statearr_22369_22523[(2)] = false);

(statearr_22369_22523[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (90))){
var state_22312__$1 = state_22312;
var statearr_22370_22524 = state_22312__$1;
(statearr_22370_22524[(1)] = (92));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (36))){
var inst_22077 = (state_22312[(16)]);
var inst_22091 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22092 = cljs.core.get.call(null,offset_map,inst_22077);
var state_22312__$1 = (function (){var statearr_22372 = state_22312;
(statearr_22372[(30)] = inst_22091);

return statearr_22372;
})();
if(cljs.core.truth_(inst_22092)){
var statearr_22373_22525 = state_22312__$1;
(statearr_22373_22525[(1)] = (39));

} else {
var statearr_22374_22526 = state_22312__$1;
(statearr_22374_22526[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (41))){
var inst_22091 = (state_22312[(30)]);
var inst_22099 = (state_22312[(2)]);
var inst_22100 = [null,inst_22099];
var inst_22101 = (new cljs.core.PersistentVector(null,2,(5),inst_22091,inst_22100,null));
var state_22312__$1 = state_22312;
var statearr_22375_22527 = state_22312__$1;
(statearr_22375_22527[(2)] = inst_22101);

(statearr_22375_22527[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (89))){
var inst_22244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22245 = ["_id"];
var inst_22246 = flake.o;
var inst_22247 = [inst_22246];
var inst_22248 = cljs.core.PersistentHashMap.fromArrays(inst_22245,inst_22247);
var inst_22249 = [inst_22248,offset_map];
var inst_22250 = (new cljs.core.PersistentVector(null,2,(5),inst_22244,inst_22249,null));
var state_22312__$1 = state_22312;
var statearr_22376_22528 = state_22312__$1;
(statearr_22376_22528[(2)] = inst_22250);

(statearr_22376_22528[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (100))){
var inst_22307 = (state_22312[(2)]);
var _ = (function (){var statearr_22377 = state_22312;
(statearr_22377[(4)] = cljs.core.rest.call(null,(state_22312[(4)])));

return statearr_22377;
})();
var state_22312__$1 = state_22312;
var statearr_22378_22529 = state_22312__$1;
(statearr_22378_22529[(2)] = inst_22307);

(statearr_22378_22529[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (43))){
var inst_22072 = (state_22312[(11)]);
var state_22312__$1 = state_22312;
var statearr_22379_22530 = state_22312__$1;
(statearr_22379_22530[(2)] = inst_22072);

(statearr_22379_22530[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (61))){
var inst_22148 = (state_22312[(2)]);
var state_22312__$1 = (function (){var statearr_22380 = state_22312;
(statearr_22380[(13)] = inst_22148);

return statearr_22380;
})();
var statearr_22381_22531 = state_22312__$1;
(statearr_22381_22531[(1)] = (62));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (29))){
var inst_22071 = (state_22312[(10)]);
var inst_22072 = (state_22312[(11)]);
var inst_22071__$1 = (state_22312[(2)]);
var inst_22072__$1 = cljs.core.get.call(null,inst_22071__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22073 = cljs.core.get.call(null,inst_22071__$1,new cljs.core.Keyword(null,"ref?","ref?",1932693720));
var inst_22074 = cljs.core.get.call(null,inst_22071__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22075 = cljs.core.get.call(null,inst_22071__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_22076 = cljs.core.get.call(null,inst_22071__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22077 = cljs.core.get.call(null,inst_22071__$1,new cljs.core.Keyword(null,"p","p",151049309));
var state_22312__$1 = (function (){var statearr_22383 = state_22312;
(statearr_22383[(10)] = inst_22071__$1);

(statearr_22383[(11)] = inst_22072__$1);

(statearr_22383[(12)] = inst_22076);

(statearr_22383[(15)] = inst_22073);

(statearr_22383[(16)] = inst_22077);

(statearr_22383[(19)] = inst_22074);

(statearr_22383[(20)] = inst_22075);

return statearr_22383;
})();
if(cljs.core.truth_(inst_22072__$1)){
var statearr_22384_22532 = state_22312__$1;
(statearr_22384_22532[(1)] = (30));

} else {
var statearr_22385_22533 = state_22312__$1;
(statearr_22385_22533[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (44))){
var inst_22111 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
if(cljs.core.truth_(inst_22111)){
var statearr_22386_22534 = state_22312__$1;
(statearr_22386_22534[(1)] = (45));

} else {
var statearr_22387_22535 = state_22312__$1;
(statearr_22387_22535[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (93))){
var state_22312__$1 = state_22312;
var statearr_22388_22536 = state_22312__$1;
(statearr_22388_22536[(2)] = null);

(statearr_22388_22536[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (6))){
var inst_22022 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22023 = (inst_22022 == null);
var state_22312__$1 = state_22312;
var statearr_22389_22537 = state_22312__$1;
(statearr_22389_22537[(2)] = inst_22023);

(statearr_22389_22537[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (28))){
var inst_22039 = (state_22312[(7)]);
var state_22312__$1 = state_22312;
var statearr_22390_22538 = state_22312__$1;
(statearr_22390_22538[(2)] = inst_22039);

(statearr_22390_22538[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (64))){
var inst_22154 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22312__$1,(57),inst_22154);
} else {
if((state_val_22313 === (103))){
var inst_22305 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
var statearr_22391_22539 = state_22312__$1;
(statearr_22391_22539[(2)] = inst_22305);

(statearr_22391_22539[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (51))){
var inst_22119 = (state_22312[(29)]);
var state_22312__$1 = state_22312;
var statearr_22392_22540 = state_22312__$1;
(statearr_22392_22540[(2)] = inst_22119);

(statearr_22392_22540[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (25))){
var state_22312__$1 = state_22312;
var statearr_22393_22541 = state_22312__$1;
(statearr_22393_22541[(2)] = false);

(statearr_22393_22541[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (34))){
var inst_22076 = (state_22312[(12)]);
var state_22312__$1 = state_22312;
var statearr_22394_22542 = state_22312__$1;
(statearr_22394_22542[(2)] = inst_22076);

(statearr_22394_22542[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (17))){
var inst_22039 = (state_22312[(7)]);
var inst_22050 = (state_22312[(2)]);
var inst_22052 = (inst_22039 == null);
var inst_22053 = cljs.core.not.call(null,inst_22052);
var state_22312__$1 = (function (){var statearr_22395 = state_22312;
(statearr_22395[(17)] = inst_22050);

return statearr_22395;
})();
if(inst_22053){
var statearr_22396_22543 = state_22312__$1;
(statearr_22396_22543[(1)] = (21));

} else {
var statearr_22397_22544 = state_22312__$1;
(statearr_22397_22544[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (3))){
var inst_22310 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22312__$1,inst_22310);
} else {
if((state_val_22313 === (12))){
var inst_22033 = (state_22312[(14)]);
var state_22312__$1 = state_22312;
var statearr_22398_22545 = state_22312__$1;
(statearr_22398_22545[(2)] = inst_22033);

(statearr_22398_22545[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (2))){
var inst_22020 = (state_22312[(21)]);
var _ = (function (){var statearr_22399 = state_22312;
(statearr_22399[(4)] = cljs.core.cons.call(null,(5),(state_22312[(4)])));

return statearr_22399;
})();
var inst_22020__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_22312__$1 = (function (){var statearr_22400 = state_22312;
(statearr_22400[(21)] = inst_22020__$1);

return statearr_22400;
})();
if(cljs.core.truth_(inst_22020__$1)){
var statearr_22401_22546 = state_22312__$1;
(statearr_22401_22546[(1)] = (6));

} else {
var statearr_22402_22547 = state_22312__$1;
(statearr_22402_22547[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (66))){
var inst_22192 = (state_22312[(31)]);
var inst_22192__$1 = componentFollow_QMARK_;
var state_22312__$1 = (function (){var statearr_22403 = state_22312;
(statearr_22403[(31)] = inst_22192__$1);

return statearr_22403;
})();
if(cljs.core.truth_(inst_22192__$1)){
var statearr_22404_22548 = state_22312__$1;
(statearr_22404_22548[(1)] = (72));

} else {
var statearr_22405_22549 = state_22312__$1;
(statearr_22405_22549[(1)] = (73));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (23))){
var inst_22066 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
if(cljs.core.truth_(inst_22066)){
var statearr_22406_22550 = state_22312__$1;
(statearr_22406_22550[(1)] = (27));

} else {
var statearr_22407_22551 = state_22312__$1;
(statearr_22407_22551[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (47))){
var inst_22269 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
var statearr_22408_22552 = state_22312__$1;
(statearr_22408_22552[(2)] = inst_22269);

(statearr_22408_22552[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (35))){
var inst_22086 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
var statearr_22409_22553 = state_22312__$1;
(statearr_22409_22553[(2)] = inst_22086);

(statearr_22409_22553[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (82))){
var inst_22221 = (state_22312[(32)]);
var inst_22236 = (state_22312[(2)]);
var inst_22237 = fluree.db.util.async.throw_err.call(null,inst_22236);
var inst_22238 = [inst_22237,offset_map];
var inst_22239 = (new cljs.core.PersistentVector(null,2,(5),inst_22221,inst_22238,null));
var state_22312__$1 = state_22312;
var statearr_22410_22554 = state_22312__$1;
(statearr_22410_22554[(2)] = inst_22239);

(statearr_22410_22554[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (76))){
var inst_22073 = (state_22312[(15)]);
var state_22312__$1 = state_22312;
if(cljs.core.truth_(inst_22073)){
var statearr_22411_22555 = state_22312__$1;
(statearr_22411_22555[(1)] = (89));

} else {
var statearr_22412_22556 = state_22312__$1;
(statearr_22412_22556[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (97))){
var inst_22279 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
if(cljs.core.truth_(inst_22279)){
var statearr_22413_22557 = state_22312__$1;
(statearr_22413_22557[(1)] = (98));

} else {
var statearr_22414_22558 = state_22312__$1;
(statearr_22414_22558[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (19))){
var inst_22039 = (state_22312[(7)]);
var inst_22046 = new cljs.core.Keyword(null,"p","p",151049309).cljs$core$IFn$_invoke$arity$1(inst_22039);
var state_22312__$1 = state_22312;
var statearr_22415_22559 = state_22312__$1;
(statearr_22415_22559[(2)] = inst_22046);

(statearr_22415_22559[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (57))){
var inst_22133 = (state_22312[(27)]);
var inst_22156 = (state_22312[(2)]);
var inst_22157 = fluree.db.util.async.throw_err.call(null,inst_22156);
var inst_22158 = [inst_22157,offset_map];
var inst_22159 = (new cljs.core.PersistentVector(null,2,(5),inst_22133,inst_22158,null));
var state_22312__$1 = state_22312;
var statearr_22416_22560 = state_22312__$1;
(statearr_22416_22560[(2)] = inst_22159);

(statearr_22416_22560[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (68))){
var inst_22170 = (state_22312[(8)]);
var state_22312__$1 = state_22312;
var statearr_22417_22561 = state_22312__$1;
(statearr_22417_22561[(2)] = inst_22170);

(statearr_22417_22561[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (11))){
var inst_22033 = (state_22312[(14)]);
var inst_22033__$1 = (state_22312[(2)]);
var inst_22034 = cljs.core.contains_QMARK_.call(null,inst_22033__$1,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651));
var state_22312__$1 = (function (){var statearr_22419 = state_22312;
(statearr_22419[(14)] = inst_22033__$1);

return statearr_22419;
})();
if(inst_22034){
var statearr_22420_22562 = state_22312__$1;
(statearr_22420_22562[(1)] = (12));

} else {
var statearr_22421_22563 = state_22312__$1;
(statearr_22421_22563[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (9))){
var inst_22028 = flake.p;
var inst_22029 = new cljs.core.Keyword(null,"compact?","compact?",1216893298).cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_22030 = fluree.db.query.fql.wildcard_pred_spec.call(null,db,cache,inst_22028,inst_22029);
var state_22312__$1 = state_22312;
var statearr_22422_22564 = state_22312__$1;
(statearr_22422_22564[(2)] = inst_22030);

(statearr_22422_22564[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (5))){
var _ = (function (){var statearr_22423 = state_22312;
(statearr_22423[(4)] = cljs.core.rest.call(null,(state_22312[(4)])));

return statearr_22423;
})();
var state_22312__$1 = state_22312;
var ex22418 = (state_22312__$1[(2)]);
var statearr_22424_22565 = state_22312__$1;
(statearr_22424_22565[(5)] = ex22418);


if((ex22418 instanceof Error)){
var statearr_22425_22566 = state_22312__$1;
(statearr_22425_22566[(1)] = (4));

(statearr_22425_22566[(5)] = null);

} else {
throw ex22418;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (83))){
var inst_22210 = (state_22312[(24)]);
var inst_22224 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_22225 = cljs.core.sequence.call(null,inst_22224,inst_22210);
var state_22312__$1 = state_22312;
var statearr_22426_22567 = state_22312__$1;
(statearr_22426_22567[(2)] = inst_22225);

(statearr_22426_22567[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (14))){
var inst_22040 = (state_22312[(28)]);
var inst_22039 = (state_22312[(7)]);
var inst_22039__$1 = (state_22312[(2)]);
var inst_22040__$1 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_22039__$1);
var state_22312__$1 = (function (){var statearr_22427 = state_22312;
(statearr_22427[(28)] = inst_22040__$1);

(statearr_22427[(7)] = inst_22039__$1);

return statearr_22427;
})();
if(cljs.core.truth_(inst_22040__$1)){
var statearr_22428_22568 = state_22312__$1;
(statearr_22428_22568[(1)] = (15));

} else {
var statearr_22429_22569 = state_22312__$1;
(statearr_22429_22569[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (45))){
var inst_22113 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22114 = [null,offset_map];
var inst_22115 = (new cljs.core.PersistentVector(null,2,(5),inst_22113,inst_22114,null));
var state_22312__$1 = state_22312;
var statearr_22430_22570 = state_22312__$1;
(statearr_22430_22570[(2)] = inst_22115);

(statearr_22430_22570[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (53))){
var inst_22124 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
var statearr_22431_22571 = state_22312__$1;
(statearr_22431_22571[(2)] = inst_22124);

(statearr_22431_22571[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (78))){
var inst_22210 = (state_22312[(24)]);
var inst_22209 = (state_22312[(2)]);
var inst_22210__$1 = fluree.db.util.async.throw_err.call(null,inst_22209);
var inst_22211 = cljs.core.empty_QMARK_.call(null,inst_22210__$1);
var state_22312__$1 = (function (){var statearr_22432 = state_22312;
(statearr_22432[(24)] = inst_22210__$1);

return statearr_22432;
})();
if(inst_22211){
var statearr_22433_22572 = state_22312__$1;
(statearr_22433_22572[(1)] = (79));

} else {
var statearr_22434_22573 = state_22312__$1;
(statearr_22434_22573[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (26))){
var inst_22063 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
var statearr_22435_22574 = state_22312__$1;
(statearr_22435_22574[(2)] = inst_22063);

(statearr_22435_22574[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (16))){
var inst_22043 = (state_22312[(33)]);
var inst_22039 = (state_22312[(7)]);
var inst_22043__$1 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22039);
var state_22312__$1 = (function (){var statearr_22436 = state_22312;
(statearr_22436[(33)] = inst_22043__$1);

return statearr_22436;
})();
if(cljs.core.truth_(inst_22043__$1)){
var statearr_22437_22575 = state_22312__$1;
(statearr_22437_22575[(1)] = (18));

} else {
var statearr_22438_22576 = state_22312__$1;
(statearr_22438_22576[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (81))){
var inst_22241 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
var statearr_22439_22577 = state_22312__$1;
(statearr_22439_22577[(2)] = inst_22241);

(statearr_22439_22577[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (79))){
var inst_22213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22214 = ["_id"];
var inst_22215 = flake.o;
var inst_22216 = [inst_22215];
var inst_22217 = cljs.core.PersistentHashMap.fromArrays(inst_22214,inst_22216);
var inst_22218 = [inst_22217,offset_map];
var inst_22219 = (new cljs.core.PersistentVector(null,2,(5),inst_22213,inst_22218,null));
var state_22312__$1 = state_22312;
var statearr_22440_22578 = state_22312__$1;
(statearr_22440_22578[(2)] = inst_22219);

(statearr_22440_22578[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (38))){
var inst_22272 = (state_22312[(26)]);
var inst_22271 = (state_22312[(2)]);
var inst_22272__$1 = cljs.core.nth.call(null,inst_22271,(0),null);
var inst_22273 = cljs.core.nth.call(null,inst_22271,(1),null);
var inst_22274 = (inst_22272__$1 == null);
var inst_22275 = cljs.core.not.call(null,inst_22274);
var state_22312__$1 = (function (){var statearr_22441 = state_22312;
(statearr_22441[(25)] = inst_22273);

(statearr_22441[(26)] = inst_22272__$1);

return statearr_22441;
})();
if(inst_22275){
var statearr_22442_22579 = state_22312__$1;
(statearr_22442_22579[(1)] = (95));

} else {
var statearr_22443_22580 = state_22312__$1;
(statearr_22443_22580[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (98))){
var inst_22050 = (state_22312[(17)]);
var inst_22273 = (state_22312[(25)]);
var inst_22272 = (state_22312[(26)]);
var inst_22281 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22282 = cljs.core.PersistentVector.EMPTY;
var inst_22283 = cljs.core.get.call(null,acc,inst_22050,inst_22282);
var inst_22284 = cljs.core.conj.call(null,inst_22283,inst_22272);
var inst_22285 = cljs.core.assoc.call(null,acc,inst_22050,inst_22284);
var inst_22286 = [inst_22285,inst_22273];
var inst_22287 = (new cljs.core.PersistentVector(null,2,(5),inst_22281,inst_22286,null));
var state_22312__$1 = state_22312;
var statearr_22444_22581 = state_22312__$1;
(statearr_22444_22581[(2)] = inst_22287);

(statearr_22444_22581[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (87))){
var inst_22228 = (state_22312[(23)]);
var state_22312__$1 = state_22312;
var statearr_22445_22582 = state_22312__$1;
(statearr_22445_22582[(2)] = inst_22228);

(statearr_22445_22582[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (30))){
var inst_22076 = (state_22312[(12)]);
var state_22312__$1 = state_22312;
if(cljs.core.truth_(inst_22076)){
var statearr_22446_22583 = state_22312__$1;
(statearr_22446_22583[(1)] = (33));

} else {
var statearr_22447_22584 = state_22312__$1;
(statearr_22447_22584[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (73))){
var inst_22192 = (state_22312[(31)]);
var state_22312__$1 = state_22312;
var statearr_22448_22585 = state_22312__$1;
(statearr_22448_22585[(2)] = inst_22192);

(statearr_22448_22585[(1)] = (74));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (96))){
var state_22312__$1 = state_22312;
var statearr_22449_22586 = state_22312__$1;
(statearr_22449_22586[(2)] = false);

(statearr_22449_22586[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (10))){
var state_22312__$1 = state_22312;
var statearr_22450_22587 = state_22312__$1;
(statearr_22450_22587[(2)] = pred_spec);

(statearr_22450_22587[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (18))){
var inst_22043 = (state_22312[(33)]);
var state_22312__$1 = state_22312;
var statearr_22451_22588 = state_22312__$1;
(statearr_22451_22588[(2)] = inst_22043);

(statearr_22451_22588[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (105))){
var state_22312__$1 = state_22312;
var statearr_22452_22589 = state_22312__$1;
(statearr_22452_22589[(2)] = null);

(statearr_22452_22589[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (52))){
var inst_22039 = (state_22312[(7)]);
var inst_22122 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_22039);
var state_22312__$1 = state_22312;
var statearr_22453_22590 = state_22312__$1;
(statearr_22453_22590[(2)] = inst_22122);

(statearr_22453_22590[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (67))){
var inst_22265 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
var statearr_22454_22591 = state_22312__$1;
(statearr_22454_22591[(2)] = inst_22265);

(statearr_22454_22591[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (71))){
var inst_22039 = (state_22312[(7)]);
var inst_22177 = (state_22312[(2)]);
var inst_22178 = fluree.db.util.async.throw_err.call(null,inst_22177);
var inst_22179 = cljs.core._deref.call(null,cache);
var inst_22180 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22181 = flake.o;
var inst_22182 = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(inst_22039);
var inst_22183 = [inst_22181,inst_22182];
var inst_22184 = (new cljs.core.PersistentVector(null,2,(5),inst_22180,inst_22183,null));
var inst_22185 = cljs.core.assoc.call(null,inst_22179,inst_22184,inst_22178);
var inst_22186 = cljs.core._vreset_BANG_.call(null,cache,inst_22185);
var state_22312__$1 = (function (){var statearr_22455 = state_22312;
(statearr_22455[(34)] = inst_22186);

return statearr_22455;
})();
var statearr_22456_22592 = state_22312__$1;
(statearr_22456_22592[(2)] = inst_22178);

(statearr_22456_22592[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (42))){
var inst_22050 = (state_22312[(17)]);
var inst_22074 = (state_22312[(19)]);
var inst_22075 = (state_22312[(20)]);
var inst_22104 = cljs.core.not.call(null,inst_22075);
var inst_22105 = cljs.core.get.call(null,acc,inst_22050);
var inst_22106 = cljs.core.count.call(null,inst_22105);
var inst_22107 = (inst_22106 >= inst_22074);
var inst_22108 = ((inst_22104) && (inst_22107));
var state_22312__$1 = state_22312;
var statearr_22457_22593 = state_22312__$1;
(statearr_22457_22593[(2)] = inst_22108);

(statearr_22457_22593[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (80))){
var inst_22221 = cljs.core.PersistentVector.EMPTY_NODE;
var state_22312__$1 = (function (){var statearr_22458 = state_22312;
(statearr_22458[(32)] = inst_22221);

return statearr_22458;
})();
if(cljs.core.truth_(fuel)){
var statearr_22459_22594 = state_22312__$1;
(statearr_22459_22594[(1)] = (83));

} else {
var statearr_22460_22595 = state_22312__$1;
(statearr_22460_22595[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (37))){
var inst_22072 = (state_22312[(11)]);
var state_22312__$1 = state_22312;
if(cljs.core.truth_(inst_22072)){
var statearr_22461_22596 = state_22312__$1;
(statearr_22461_22596[(1)] = (42));

} else {
var statearr_22462_22597 = state_22312__$1;
(statearr_22462_22597[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (63))){
var inst_22148 = (state_22312[(13)]);
var state_22312__$1 = state_22312;
var statearr_22463_22598 = state_22312__$1;
(statearr_22463_22598[(2)] = inst_22148);

(statearr_22463_22598[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (94))){
var inst_22259 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
var statearr_22464_22599 = state_22312__$1;
(statearr_22464_22599[(2)] = inst_22259);

(statearr_22464_22599[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (8))){
var inst_22026 = (state_22312[(2)]);
var state_22312__$1 = state_22312;
if(cljs.core.truth_(inst_22026)){
var statearr_22465_22600 = state_22312__$1;
(statearr_22465_22600[(1)] = (9));

} else {
var statearr_22466_22601 = state_22312__$1;
(statearr_22466_22601[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (49))){
var state_22312__$1 = state_22312;
var statearr_22467_22602 = state_22312__$1;
(statearr_22467_22602[(2)] = false);

(statearr_22467_22602[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22313 === (84))){
var inst_22210 = (state_22312[(24)]);
var state_22312__$1 = state_22312;
var statearr_22468_22603 = state_22312__$1;
(statearr_22468_22603[(2)] = inst_22210);

(statearr_22468_22603[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2879__auto__ = null;
var fluree$db$query$fql$state_machine__2879__auto____0 = (function (){
var statearr_22469 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22469[(0)] = fluree$db$query$fql$state_machine__2879__auto__);

(statearr_22469[(1)] = (1));

return statearr_22469;
});
var fluree$db$query$fql$state_machine__2879__auto____1 = (function (state_22312){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_22312);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e22470){var ex__2882__auto__ = e22470;
var statearr_22471_22604 = state_22312;
(statearr_22471_22604[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_22312[(4)]))){
var statearr_22472_22605 = state_22312;
(statearr_22472_22605[(1)] = cljs.core.first.call(null,(state_22312[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22606 = state_22312;
state_22312 = G__22606;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2879__auto__ = function(state_22312){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2879__auto____1.call(this,state_22312);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2879__auto____0;
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2879__auto____1;
return fluree$db$query$fql$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_22473 = f__2902__auto__.call(null);
(statearr_22473[(6)] = c__2901__auto__);

return statearr_22473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid.call(null,subject_id);
var or__4126__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec.call(null,db,coll_id,cljs.core.get_in.call(null,base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null)));
var updated_spec = cljs.core.update.call(null,base_pred_spec,new cljs.core.Keyword(null,"select","select",1147833503),(function (sel){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,sel,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),cljs.core.merge.call(null,lookup_specs,new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(sel))),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767));
}));
cljs.core._vreset_BANG_.call(null,cache,cljs.core.assoc.call(null,cljs.core._deref.call(null,cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"ns-lookup","ns-lookup",960704767)], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_22786){
var state_val_22787 = (state_22786[(1)]);
if((state_val_22787 === (7))){
var inst_22781 = (state_22786[(2)]);
var _ = (function (){var statearr_22788 = state_22786;
(statearr_22788[(4)] = cljs.core.rest.call(null,(state_22786[(4)])));

return statearr_22788;
})();
var state_22786__$1 = state_22786;
var statearr_22789_22884 = state_22786__$1;
(statearr_22789_22884[(2)] = inst_22781);

(statearr_22789_22884[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (59))){
var inst_22667 = (state_22786[(7)]);
var state_22786__$1 = state_22786;
var statearr_22790_22885 = state_22786__$1;
(statearr_22790_22885[(2)] = inst_22667);

(statearr_22790_22885[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (20))){
var inst_22676 = (state_22786[(8)]);
var inst_22673 = (state_22786[(2)]);
var inst_22674 = fluree.db.util.async.throw_err.call(null,inst_22673);
var inst_22675 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_22674);
var inst_22676__$1 = cljs.core.not_empty.call(null,inst_22675);
var state_22786__$1 = (function (){var statearr_22791 = state_22786;
(statearr_22791[(8)] = inst_22676__$1);

return statearr_22791;
})();
if(cljs.core.truth_(inst_22676__$1)){
var statearr_22792_22886 = state_22786__$1;
(statearr_22792_22886[(1)] = (21));

} else {
var statearr_22793_22887 = state_22786__$1;
(statearr_22793_22887[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (58))){
var inst_22666 = (state_22786[(9)]);
var state_22786__$1 = state_22786;
var statearr_22794_22888 = state_22786__$1;
(statearr_22794_22888[(2)] = inst_22666);

(statearr_22794_22888[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (60))){
var inst_22773 = (state_22786[(2)]);
var state_22786__$1 = state_22786;
var statearr_22795_22889 = state_22786__$1;
(statearr_22795_22889[(2)] = inst_22773);

(statearr_22795_22889[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (27))){
var inst_22706 = (state_22786[(10)]);
var inst_22708 = (state_22786[(11)]);
var inst_22698 = (state_22786[(12)]);
var inst_22705 = cljs.core.seq.call(null,inst_22698);
var inst_22706__$1 = cljs.core.first.call(null,inst_22705);
var inst_22707 = cljs.core.next.call(null,inst_22705);
var inst_22708__$1 = cljs.core.not.call(null,inst_22706__$1);
var state_22786__$1 = (function (){var statearr_22796 = state_22786;
(statearr_22796[(13)] = inst_22707);

(statearr_22796[(10)] = inst_22706__$1);

(statearr_22796[(11)] = inst_22708__$1);

return statearr_22796;
})();
if(inst_22708__$1){
var statearr_22797_22890 = state_22786__$1;
(statearr_22797_22890[(1)] = (29));

} else {
var statearr_22798_22891 = state_22786__$1;
(statearr_22798_22891[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (1))){
var state_22786__$1 = state_22786;
var statearr_22799_22892 = state_22786__$1;
(statearr_22799_22892[(2)] = null);

(statearr_22799_22892[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (24))){
var inst_22676 = (state_22786[(8)]);
var inst_22682 = cljs.core.count.call(null,inst_22676);
var inst_22683 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_22682,max_fuel);
var state_22786__$1 = state_22786;
var statearr_22800_22893 = state_22786__$1;
(statearr_22800_22893[(2)] = inst_22683);

(statearr_22800_22893[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (55))){
var inst_22665 = (state_22786[(14)]);
var state_22786__$1 = state_22786;
var statearr_22801_22894 = state_22786__$1;
(statearr_22801_22894[(2)] = inst_22665);

(statearr_22801_22894[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (39))){
var inst_22663 = (state_22786[(15)]);
var state_22786__$1 = state_22786;
var statearr_22802_22895 = state_22786__$1;
(statearr_22802_22895[(2)] = inst_22663);

(statearr_22802_22895[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (46))){
var inst_22761 = (state_22786[(2)]);
var state_22786__$1 = state_22786;
var statearr_22803_22896 = state_22786__$1;
(statearr_22803_22896[(2)] = inst_22761);

(statearr_22803_22896[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (4))){
var inst_22607 = (state_22786[(2)]);
var state_22786__$1 = state_22786;
var statearr_22804_22897 = state_22786__$1;
(statearr_22804_22897[(2)] = inst_22607);

(statearr_22804_22897[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (54))){
var inst_22700 = (state_22786[(16)]);
var inst_22752 = (state_22786[(2)]);
var inst_22753 = fluree.db.util.async.throw_err.call(null,inst_22752);
var inst_22754 = cljs.core.conj.call(null,inst_22700,inst_22753);
var state_22786__$1 = state_22786;
var statearr_22805_22898 = state_22786__$1;
(statearr_22805_22898[(2)] = inst_22754);

(statearr_22805_22898[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (15))){
var state_22786__$1 = state_22786;
var statearr_22806_22899 = state_22786__$1;
(statearr_22806_22899[(2)] = false);

(statearr_22806_22899[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (48))){
var inst_22700 = (state_22786[(16)]);
var state_22786__$1 = state_22786;
var statearr_22807_22900 = state_22786__$1;
(statearr_22807_22900[(2)] = inst_22700);

(statearr_22807_22900[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (50))){
var inst_22707 = (state_22786[(13)]);
var inst_22699 = (state_22786[(17)]);
var inst_22756 = (state_22786[(2)]);
var inst_22757 = (inst_22699 + (1));
var inst_22698 = inst_22707;
var inst_22699__$1 = inst_22757;
var inst_22700 = inst_22756;
var state_22786__$1 = (function (){var statearr_22808 = state_22786;
(statearr_22808[(17)] = inst_22699__$1);

(statearr_22808[(16)] = inst_22700);

(statearr_22808[(12)] = inst_22698);

return statearr_22808;
})();
var statearr_22809_22901 = state_22786__$1;
(statearr_22809_22901[(2)] = null);

(statearr_22809_22901[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (21))){
var state_22786__$1 = state_22786;
var statearr_22810_22902 = state_22786__$1;
(statearr_22810_22902[(2)] = fuel);

(statearr_22810_22902[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (31))){
var inst_22717 = (state_22786[(2)]);
var state_22786__$1 = state_22786;
if(cljs.core.truth_(inst_22717)){
var statearr_22811_22903 = state_22786__$1;
(statearr_22811_22903[(1)] = (35));

} else {
var statearr_22812_22904 = state_22786__$1;
(statearr_22812_22904[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (32))){
var inst_22699 = (state_22786[(17)]);
var inst_22664 = (state_22786[(18)]);
var inst_22712 = (inst_22699 >= inst_22664);
var state_22786__$1 = state_22786;
var statearr_22813_22905 = state_22786__$1;
(statearr_22813_22905[(2)] = inst_22712);

(statearr_22813_22905[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (40))){
var inst_22724 = (state_22786[(2)]);
var state_22786__$1 = state_22786;
if(cljs.core.truth_(inst_22724)){
var statearr_22814_22906 = state_22786__$1;
(statearr_22814_22906[(1)] = (41));

} else {
var statearr_22815_22907 = state_22786__$1;
(statearr_22815_22907[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (56))){
var inst_22666 = (state_22786[(9)]);
var state_22786__$1 = state_22786;
if(cljs.core.truth_(inst_22666)){
var statearr_22816_22908 = state_22786__$1;
(statearr_22816_22908[(1)] = (58));

} else {
var statearr_22817_22909 = state_22786__$1;
(statearr_22817_22909[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (33))){
var inst_22664 = (state_22786[(18)]);
var state_22786__$1 = state_22786;
var statearr_22818_22910 = state_22786__$1;
(statearr_22818_22910[(2)] = inst_22664);

(statearr_22818_22910[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (13))){
var inst_22657 = (state_22786[(2)]);
var state_22786__$1 = state_22786;
if(cljs.core.truth_(inst_22657)){
var statearr_22819_22911 = state_22786__$1;
(statearr_22819_22911[(1)] = (17));

} else {
var statearr_22820_22912 = state_22786__$1;
(statearr_22820_22912[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (22))){
var inst_22676 = (state_22786[(8)]);
var state_22786__$1 = state_22786;
var statearr_22822_22913 = state_22786__$1;
(statearr_22822_22913[(2)] = inst_22676);

(statearr_22822_22913[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (36))){
var inst_22663 = (state_22786[(15)]);
var state_22786__$1 = state_22786;
if(cljs.core.truth_(inst_22663)){
var statearr_22823_22914 = state_22786__$1;
(statearr_22823_22914[(1)] = (38));

} else {
var statearr_22824_22915 = state_22786__$1;
(statearr_22824_22915[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (41))){
var inst_22707 = (state_22786[(13)]);
var inst_22699 = (state_22786[(17)]);
var inst_22700 = (state_22786[(16)]);
var inst_22726 = (inst_22699 + (1));
var tmp22821 = inst_22700;
var inst_22698 = inst_22707;
var inst_22699__$1 = inst_22726;
var inst_22700__$1 = tmp22821;
var state_22786__$1 = (function (){var statearr_22825 = state_22786;
(statearr_22825[(17)] = inst_22699__$1);

(statearr_22825[(16)] = inst_22700__$1);

(statearr_22825[(12)] = inst_22698);

return statearr_22825;
})();
var statearr_22826_22916 = state_22786__$1;
(statearr_22826_22916[(2)] = null);

(statearr_22826_22916[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (43))){
var inst_22763 = (state_22786[(2)]);
var state_22786__$1 = state_22786;
var statearr_22827_22917 = state_22786__$1;
(statearr_22827_22917[(2)] = inst_22763);

(statearr_22827_22917[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (29))){
var inst_22708 = (state_22786[(11)]);
var state_22786__$1 = state_22786;
var statearr_22828_22918 = state_22786__$1;
(statearr_22828_22918[(2)] = inst_22708);

(statearr_22828_22918[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (44))){
var inst_22706 = (state_22786[(10)]);
var inst_22730 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22731 = [inst_22706];
var inst_22732 = (new cljs.core.PersistentVector(null,1,(5),inst_22730,inst_22731,null));
var inst_22733 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_22732);
var state_22786__$1 = state_22786;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22786__$1,(47),inst_22733);
} else {
if((state_val_22787 === (6))){
var inst_22631 = (state_22786[(19)]);
var inst_22624 = (state_22786[(20)]);
var inst_22630 = cljs.core.seq.call(null,inst_22624);
var inst_22631__$1 = cljs.core.first.call(null,inst_22630);
var inst_22632 = cljs.core.next.call(null,inst_22630);
var inst_22633 = cljs.core.not.call(null,inst_22631__$1);
var state_22786__$1 = (function (){var statearr_22829 = state_22786;
(statearr_22829[(21)] = inst_22632);

(statearr_22829[(19)] = inst_22631__$1);

return statearr_22829;
})();
if(inst_22633){
var statearr_22830_22919 = state_22786__$1;
(statearr_22830_22919[(1)] = (8));

} else {
var statearr_22831_22920 = state_22786__$1;
(statearr_22831_22920[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (28))){
var inst_22665 = (state_22786[(14)]);
var inst_22767 = (state_22786[(2)]);
var state_22786__$1 = (function (){var statearr_22832 = state_22786;
(statearr_22832[(22)] = inst_22767);

return statearr_22832;
})();
if(cljs.core.truth_(inst_22665)){
var statearr_22833_22921 = state_22786__$1;
(statearr_22833_22921[(1)] = (55));

} else {
var statearr_22834_22922 = state_22786__$1;
(statearr_22834_22922[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (51))){
var inst_22736 = (state_22786[(23)]);
var inst_22745 = cljs.core.count.call(null,inst_22736);
var inst_22746 = fluree.db.query.fql.add_fuel.call(null,fuel,inst_22745,max_fuel);
var state_22786__$1 = state_22786;
var statearr_22835_22923 = state_22786__$1;
(statearr_22835_22923[(2)] = inst_22746);

(statearr_22835_22923[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (25))){
var state_22786__$1 = state_22786;
var statearr_22836_22924 = state_22786__$1;
(statearr_22836_22924[(2)] = null);

(statearr_22836_22924[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (34))){
var inst_22715 = (state_22786[(2)]);
var state_22786__$1 = state_22786;
var statearr_22837_22925 = state_22786__$1;
(statearr_22837_22925[(2)] = inst_22715);

(statearr_22837_22925[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (17))){
var inst_22641 = (state_22786[(24)]);
var inst_22659 = cljs.core.apply.call(null,cljs.core.hash_map,inst_22641);
var state_22786__$1 = state_22786;
var statearr_22838_22926 = state_22786__$1;
(statearr_22838_22926[(2)] = inst_22659);

(statearr_22838_22926[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (3))){
var inst_22784 = (state_22786[(2)]);
var state_22786__$1 = state_22786;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22786__$1,inst_22784);
} else {
if((state_val_22787 === (12))){
var state_22786__$1 = state_22786;
var statearr_22839_22927 = state_22786__$1;
(statearr_22839_22927[(2)] = false);

(statearr_22839_22927[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (2))){
var _ = (function (){var statearr_22840 = state_22786;
(statearr_22840[(4)] = cljs.core.cons.call(null,(5),(state_22786[(4)])));

return statearr_22840;
})();
var inst_22620 = reverse_refs_specs;
var inst_22621 = cljs.core.seq.call(null,inst_22620);
var inst_22622 = cljs.core.first.call(null,inst_22621);
var inst_22623 = cljs.core.next.call(null,inst_22621);
var inst_22624 = inst_22620;
var inst_22625 = null;
var state_22786__$1 = (function (){var statearr_22841 = state_22786;
(statearr_22841[(25)] = inst_22622);

(statearr_22841[(26)] = inst_22623);

(statearr_22841[(27)] = inst_22625);

(statearr_22841[(20)] = inst_22624);

return statearr_22841;
})();
var statearr_22842_22928 = state_22786__$1;
(statearr_22842_22928[(2)] = null);

(statearr_22842_22928[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (23))){
var inst_22680 = (state_22786[(2)]);
var state_22786__$1 = state_22786;
if(cljs.core.truth_(inst_22680)){
var statearr_22843_22929 = state_22786__$1;
(statearr_22843_22929[(1)] = (24));

} else {
var statearr_22844_22930 = state_22786__$1;
(statearr_22844_22930[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (47))){
var inst_22736 = (state_22786[(23)]);
var inst_22641 = (state_22786[(24)]);
var inst_22735 = (state_22786[(2)]);
var inst_22736__$1 = fluree.db.util.async.throw_err.call(null,inst_22735);
var inst_22737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22738 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"compact?","compact?",1216893298),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_22739 = (new cljs.core.PersistentVector(null,4,(5),inst_22737,inst_22738,null));
var inst_22740 = cljs.core.select_keys.call(null,inst_22641,inst_22739);
var inst_22741 = cljs.core.empty_QMARK_.call(null,inst_22736__$1);
var state_22786__$1 = (function (){var statearr_22845 = state_22786;
(statearr_22845[(28)] = inst_22740);

(statearr_22845[(23)] = inst_22736__$1);

return statearr_22845;
})();
if(inst_22741){
var statearr_22846_22931 = state_22786__$1;
(statearr_22846_22931[(1)] = (48));

} else {
var statearr_22847_22932 = state_22786__$1;
(statearr_22847_22932[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (35))){
var inst_22700 = (state_22786[(16)]);
var state_22786__$1 = state_22786;
var statearr_22848_22933 = state_22786__$1;
(statearr_22848_22933[(2)] = inst_22700);

(statearr_22848_22933[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (19))){
var inst_22640 = (state_22786[(29)]);
var inst_22662 = (state_22786[(2)]);
var inst_22663 = cljs.core.get.call(null,inst_22662,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_22664 = cljs.core.get.call(null,inst_22662,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22665 = cljs.core.get.call(null,inst_22662,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_22666 = cljs.core.get.call(null,inst_22662,new cljs.core.Keyword(null,"name","name",1843675177));
var inst_22667 = cljs.core.get.call(null,inst_22662,new cljs.core.Keyword(null,"p","p",151049309));
var inst_22668 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_22669 = [subject_id,inst_22640];
var inst_22670 = (new cljs.core.PersistentVector(null,2,(5),inst_22668,inst_22669,null));
var inst_22671 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_22670);
var state_22786__$1 = (function (){var statearr_22849 = state_22786;
(statearr_22849[(7)] = inst_22667);

(statearr_22849[(18)] = inst_22664);

(statearr_22849[(14)] = inst_22665);

(statearr_22849[(9)] = inst_22666);

(statearr_22849[(15)] = inst_22663);

return statearr_22849;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22786__$1,(20),inst_22671);
} else {
if((state_val_22787 === (57))){
var inst_22632 = (state_22786[(21)]);
var inst_22625 = (state_22786[(27)]);
var inst_22767 = (state_22786[(22)]);
var inst_22775 = (state_22786[(2)]);
var inst_22776 = cljs.core.assoc.call(null,inst_22625,inst_22775,inst_22767);
var inst_22624 = inst_22632;
var inst_22625__$1 = inst_22776;
var state_22786__$1 = (function (){var statearr_22850 = state_22786;
(statearr_22850[(27)] = inst_22625__$1);

(statearr_22850[(20)] = inst_22624);

return statearr_22850;
})();
var statearr_22851_22934 = state_22786__$1;
(statearr_22851_22934[(2)] = null);

(statearr_22851_22934[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (11))){
var inst_22641 = (state_22786[(24)]);
var inst_22646 = inst_22641.cljs$lang$protocol_mask$partition0$;
var inst_22647 = (inst_22646 & (64));
var inst_22648 = inst_22641.cljs$core$ISeq$;
var inst_22649 = (cljs.core.PROTOCOL_SENTINEL === inst_22648);
var inst_22650 = ((inst_22647) || (inst_22649));
var state_22786__$1 = state_22786;
if(cljs.core.truth_(inst_22650)){
var statearr_22853_22935 = state_22786__$1;
(statearr_22853_22935[(1)] = (14));

} else {
var statearr_22854_22936 = state_22786__$1;
(statearr_22854_22936[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (9))){
var inst_22631 = (state_22786[(19)]);
var inst_22641 = (state_22786[(24)]);
var inst_22640 = cljs.core.nth.call(null,inst_22631,(0),null);
var inst_22641__$1 = cljs.core.nth.call(null,inst_22631,(1),null);
var inst_22643 = (inst_22641__$1 == null);
var inst_22644 = cljs.core.not.call(null,inst_22643);
var state_22786__$1 = (function (){var statearr_22855 = state_22786;
(statearr_22855[(29)] = inst_22640);

(statearr_22855[(24)] = inst_22641__$1);

return statearr_22855;
})();
if(inst_22644){
var statearr_22856_22937 = state_22786__$1;
(statearr_22856_22937[(1)] = (11));

} else {
var statearr_22857_22938 = state_22786__$1;
(statearr_22857_22938[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (5))){
var _ = (function (){var statearr_22858 = state_22786;
(statearr_22858[(4)] = cljs.core.rest.call(null,(state_22786[(4)])));

return statearr_22858;
})();
var state_22786__$1 = state_22786;
var ex22852 = (state_22786__$1[(2)]);
var statearr_22859_22939 = state_22786__$1;
(statearr_22859_22939[(5)] = ex22852);


if((ex22852 instanceof Error)){
var statearr_22860_22940 = state_22786__$1;
(statearr_22860_22940[(1)] = (4));

(statearr_22860_22940[(5)] = null);

} else {
throw ex22852;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (14))){
var state_22786__$1 = state_22786;
var statearr_22861_22941 = state_22786__$1;
(statearr_22861_22941[(2)] = true);

(statearr_22861_22941[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (45))){
var state_22786__$1 = state_22786;
var statearr_22862_22942 = state_22786__$1;
(statearr_22862_22942[(2)] = null);

(statearr_22862_22942[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (53))){
var inst_22740 = (state_22786[(28)]);
var inst_22736 = (state_22786[(23)]);
var inst_22749 = (state_22786[(2)]);
var inst_22750 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_22740,inst_22736);
var state_22786__$1 = (function (){var statearr_22863 = state_22786;
(statearr_22863[(30)] = inst_22749);

return statearr_22863;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22786__$1,(54),inst_22750);
} else {
if((state_val_22787 === (26))){
var inst_22676 = (state_22786[(8)]);
var inst_22686 = (state_22786[(2)]);
var inst_22694 = cljs.core.seq.call(null,inst_22676);
var inst_22695 = cljs.core.first.call(null,inst_22694);
var inst_22696 = cljs.core.next.call(null,inst_22694);
var inst_22697 = cljs.core.PersistentVector.EMPTY;
var inst_22698 = inst_22676;
var inst_22699 = (0);
var inst_22700 = inst_22697;
var state_22786__$1 = (function (){var statearr_22864 = state_22786;
(statearr_22864[(17)] = inst_22699);

(statearr_22864[(31)] = inst_22686);

(statearr_22864[(32)] = inst_22695);

(statearr_22864[(16)] = inst_22700);

(statearr_22864[(33)] = inst_22696);

(statearr_22864[(12)] = inst_22698);

return statearr_22864;
})();
var statearr_22865_22943 = state_22786__$1;
(statearr_22865_22943[(2)] = null);

(statearr_22865_22943[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (16))){
var inst_22654 = (state_22786[(2)]);
var state_22786__$1 = state_22786;
var statearr_22866_22944 = state_22786__$1;
(statearr_22866_22944[(2)] = inst_22654);

(statearr_22866_22944[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (38))){
var inst_22699 = (state_22786[(17)]);
var inst_22663 = (state_22786[(15)]);
var inst_22721 = (inst_22699 < inst_22663);
var state_22786__$1 = state_22786;
var statearr_22867_22945 = state_22786__$1;
(statearr_22867_22945[(2)] = inst_22721);

(statearr_22867_22945[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (30))){
var inst_22664 = (state_22786[(18)]);
var state_22786__$1 = state_22786;
if(cljs.core.truth_(inst_22664)){
var statearr_22868_22946 = state_22786__$1;
(statearr_22868_22946[(1)] = (32));

} else {
var statearr_22869_22947 = state_22786__$1;
(statearr_22869_22947[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (10))){
var inst_22779 = (state_22786[(2)]);
var state_22786__$1 = state_22786;
var statearr_22870_22948 = state_22786__$1;
(statearr_22870_22948[(2)] = inst_22779);

(statearr_22870_22948[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (18))){
var inst_22641 = (state_22786[(24)]);
var state_22786__$1 = state_22786;
var statearr_22871_22949 = state_22786__$1;
(statearr_22871_22949[(2)] = inst_22641);

(statearr_22871_22949[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (52))){
var state_22786__$1 = state_22786;
var statearr_22872_22950 = state_22786__$1;
(statearr_22872_22950[(2)] = null);

(statearr_22872_22950[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (42))){
var state_22786__$1 = state_22786;
var statearr_22873_22951 = state_22786__$1;
(statearr_22873_22951[(1)] = (44));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (37))){
var inst_22765 = (state_22786[(2)]);
var state_22786__$1 = state_22786;
var statearr_22875_22952 = state_22786__$1;
(statearr_22875_22952[(2)] = inst_22765);

(statearr_22875_22952[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (8))){
var inst_22625 = (state_22786[(27)]);
var state_22786__$1 = state_22786;
var statearr_22876_22953 = state_22786__$1;
(statearr_22876_22953[(2)] = inst_22625);

(statearr_22876_22953[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22787 === (49))){
var state_22786__$1 = state_22786;
if(cljs.core.truth_(fuel)){
var statearr_22877_22954 = state_22786__$1;
(statearr_22877_22954[(1)] = (51));

} else {
var statearr_22878_22955 = state_22786__$1;
(statearr_22878_22955[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto____0 = (function (){
var statearr_22879 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_22879[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto__);

(statearr_22879[(1)] = (1));

return statearr_22879;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto____1 = (function (state_22786){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_22786);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e22880){var ex__2882__auto__ = e22880;
var statearr_22881_22956 = state_22786;
(statearr_22881_22956[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_22786[(4)]))){
var statearr_22882_22957 = state_22786;
(statearr_22882_22957[(1)] = cljs.core.first.call(null,(state_22786[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22958 = state_22786;
state_22786 = G__22958;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto__ = function(state_22786){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto____1.call(this,state_22786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_22883 = f__2902__auto__.call(null);
(statearr_22883[(6)] = c__2901__auto__);

return statearr_22883;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_.call(null,pred_spec,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"component?","component?",407783990).cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.call(null,(function (acc,spec){
var key_spec = cljs.core.key.call(null,spec);
var val_spec = (((new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(cljs.core.val.call(null,spec)) == null))?cljs.core.assoc.call(null,cljs.core.val.call(null,spec),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651).cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val.call(null,spec));
return cljs.core.assoc.call(null,acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.call(null,select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.call(null,coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__22959 = select_spec;
var map__22959__$1 = (((((!((map__22959 == null))))?(((((map__22959.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22959.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22959):map__22959);
var recur_seen = cljs.core.get.call(null,map__22959__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var recur_depth = cljs.core.get.call(null,map__22959__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
return cljs.core.select_keys.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057)], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),recur_pred,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687)], null),cljs.core.conj.call(null,recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),new cljs.core.Keyword(null,"compact?","compact?",1216893298)], null));
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flake,select_spec,acc,fuel,max_fuel,cache){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_23042){
var state_val_23043 = (state_23042[(1)]);
if((state_val_23043 === (7))){
var state_23042__$1 = state_23042;
var statearr_23044_23096 = state_23042__$1;
(statearr_23044_23096[(2)] = false);

(statearr_23044_23096[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (20))){
var inst_22998 = (state_23042[(7)]);
var state_23042__$1 = state_23042;
if(cljs.core.truth_(inst_22998)){
var statearr_23045_23097 = state_23042__$1;
(statearr_23045_23097[(1)] = (22));

} else {
var statearr_23046_23098 = state_23042__$1;
(statearr_23046_23098[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (27))){
var inst_23021 = (state_23042[(8)]);
var inst_23027 = (state_23042[(2)]);
var state_23042__$1 = (function (){var statearr_23047 = state_23042;
(statearr_23047[(9)] = inst_23027);

return statearr_23047;
})();
if(cljs.core.truth_(inst_23021)){
var statearr_23048_23099 = state_23042__$1;
(statearr_23048_23099[(1)] = (28));

} else {
var statearr_23049_23100 = state_23042__$1;
(statearr_23049_23100[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (1))){
var state_23042__$1 = state_23042;
var statearr_23050_23101 = state_23042__$1;
(statearr_23050_23101[(2)] = null);

(statearr_23050_23101[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (24))){
var inst_23019 = (state_23042[(2)]);
var state_23042__$1 = state_23042;
var statearr_23051_23102 = state_23042__$1;
(statearr_23051_23102[(2)] = inst_23019);

(statearr_23051_23102[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (4))){
var inst_22961 = (state_23042[(2)]);
var state_23042__$1 = state_23042;
var statearr_23052_23103 = state_23042__$1;
(statearr_23052_23103[(2)] = inst_22961);

(statearr_23052_23103[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (15))){
var inst_23005 = (state_23042[(2)]);
var inst_23006 = fluree.db.util.async.throw_err.call(null,inst_23005);
var state_23042__$1 = (function (){var statearr_23053 = state_23042;
(statearr_23053[(10)] = inst_23006);

return statearr_23053;
})();
if(cljs.core.truth_(fuel)){
var statearr_23054_23104 = state_23042__$1;
(statearr_23054_23104[(1)] = (16));

} else {
var statearr_23055_23105 = state_23042__$1;
(statearr_23055_23105[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (21))){
var inst_22991 = (state_23042[(11)]);
var inst_23021 = (state_23042[(2)]);
var state_23042__$1 = (function (){var statearr_23056 = state_23042;
(statearr_23056[(8)] = inst_23021);

return statearr_23056;
})();
if(cljs.core.truth_(inst_22991)){
var statearr_23057_23106 = state_23042__$1;
(statearr_23057_23106[(1)] = (25));

} else {
var statearr_23058_23107 = state_23042__$1;
(statearr_23058_23107[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (31))){
var inst_22992 = (state_23042[(12)]);
var inst_23027 = (state_23042[(9)]);
var inst_23033 = (state_23042[(2)]);
var inst_23034 = fluree.db.util.async.throw_err.call(null,inst_23033);
var inst_23035 = inst_23027.call(null,acc,inst_22992,inst_23034);
var state_23042__$1 = state_23042;
var statearr_23059_23108 = state_23042__$1;
(statearr_23059_23108[(2)] = inst_23035);

(statearr_23059_23108[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (13))){
var inst_22969 = (state_23042[(13)]);
var state_23042__$1 = state_23042;
var statearr_23060_23109 = state_23042__$1;
(statearr_23060_23109[(2)] = inst_22969);

(statearr_23060_23109[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (22))){
var inst_22998 = (state_23042[(7)]);
var state_23042__$1 = state_23042;
var statearr_23061_23110 = state_23042__$1;
(statearr_23061_23110[(2)] = inst_22998);

(statearr_23061_23110[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (29))){
var inst_23012 = (state_23042[(14)]);
var inst_23030 = fluree.db.query.fql.recur_select_spec.call(null,select_spec,flake);
var inst_23031 = fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_23030,inst_23012);
var state_23042__$1 = state_23042;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23042__$1,(31),inst_23031);
} else {
if((state_val_23043 === (6))){
var inst_22969 = (state_23042[(13)]);
var inst_22974 = inst_22969.cljs$lang$protocol_mask$partition0$;
var inst_22975 = (inst_22974 & (64));
var inst_22976 = inst_22969.cljs$core$ISeq$;
var inst_22977 = (cljs.core.PROTOCOL_SENTINEL === inst_22976);
var inst_22978 = ((inst_22975) || (inst_22977));
var state_23042__$1 = state_23042;
if(cljs.core.truth_(inst_22978)){
var statearr_23062_23111 = state_23042__$1;
(statearr_23062_23111[(1)] = (9));

} else {
var statearr_23063_23112 = state_23042__$1;
(statearr_23063_23112[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (28))){
var state_23042__$1 = state_23042;
var statearr_23064_23113 = state_23042__$1;
(statearr_23064_23113[(2)] = acc);

(statearr_23064_23113[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (25))){
var inst_22992 = (state_23042[(12)]);
var inst_22996 = (state_23042[(15)]);
var inst_23012 = (state_23042[(14)]);
var inst_22997 = (state_23042[(16)]);
var inst_22995 = (state_23042[(17)]);
var inst_22994 = (state_23042[(18)]);
var inst_22968 = (state_23042[(19)]);
var inst_22991 = (state_23042[(11)]);
var inst_22990 = (state_23042[(20)]);
var inst_23021 = (state_23042[(8)]);
var inst_22993 = (state_23042[(21)]);
var inst_22998 = (state_23042[(7)]);
var inst_23023 = (function (){var recur_seen = inst_22994;
var recur_subject = inst_22968;
var sub_flakes = inst_23012;
var seen_QMARK_ = inst_22997;
var multi_QMARK_ = inst_22991;
var limit = inst_22996;
var recur_depth = inst_22995;
var as = inst_22992;
var max_depth_QMARK_ = inst_22998;
var map__22967 = inst_22990;
var recur = inst_22993;
var stop_QMARK_ = inst_23021;
return (function (results,as__$1,new_result){
return cljs.core.update.call(null,results,as__$1,fluree.db.query.fql.conjv,new_result);
});
})();
var state_23042__$1 = state_23042;
var statearr_23065_23114 = state_23042__$1;
(statearr_23065_23114[(2)] = inst_23023);

(statearr_23065_23114[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (17))){
var inst_23006 = (state_23042[(10)]);
var state_23042__$1 = state_23042;
var statearr_23066_23115 = state_23042__$1;
(statearr_23066_23115[(2)] = inst_23006);

(statearr_23066_23115[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (3))){
var inst_23040 = (state_23042[(2)]);
var state_23042__$1 = state_23042;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23042__$1,inst_23040);
} else {
if((state_val_23043 === (12))){
var inst_22969 = (state_23042[(13)]);
var inst_22987 = cljs.core.apply.call(null,cljs.core.hash_map,inst_22969);
var state_23042__$1 = state_23042;
var statearr_23067_23116 = state_23042__$1;
(statearr_23067_23116[(2)] = inst_22987);

(statearr_23067_23116[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (2))){
var inst_22969 = (state_23042[(13)]);
var _ = (function (){var statearr_23068 = state_23042;
(statearr_23068[(4)] = cljs.core.cons.call(null,(5),(state_23042[(4)])));

return statearr_23068;
})();
var inst_22968 = flake.o;
var inst_22969__$1 = select_spec;
var inst_22971 = (inst_22969__$1 == null);
var inst_22972 = cljs.core.not.call(null,inst_22971);
var state_23042__$1 = (function (){var statearr_23069 = state_23042;
(statearr_23069[(13)] = inst_22969__$1);

(statearr_23069[(19)] = inst_22968);

return statearr_23069;
})();
if(inst_22972){
var statearr_23070_23117 = state_23042__$1;
(statearr_23070_23117[(1)] = (6));

} else {
var statearr_23071_23118 = state_23042__$1;
(statearr_23071_23118[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (23))){
var inst_23012 = (state_23042[(14)]);
var inst_23017 = cljs.core.empty_QMARK_.call(null,inst_23012);
var state_23042__$1 = state_23042;
var statearr_23072_23119 = state_23042__$1;
(statearr_23072_23119[(2)] = inst_23017);

(statearr_23072_23119[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (19))){
var inst_22997 = (state_23042[(16)]);
var state_23042__$1 = state_23042;
var statearr_23073_23120 = state_23042__$1;
(statearr_23073_23120[(2)] = inst_22997);

(statearr_23073_23120[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (11))){
var inst_22982 = (state_23042[(2)]);
var state_23042__$1 = state_23042;
var statearr_23075_23121 = state_23042__$1;
(statearr_23075_23121[(2)] = inst_22982);

(statearr_23075_23121[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (9))){
var state_23042__$1 = state_23042;
var statearr_23076_23122 = state_23042__$1;
(statearr_23076_23122[(2)] = true);

(statearr_23076_23122[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (5))){
var _ = (function (){var statearr_23077 = state_23042;
(statearr_23077[(4)] = cljs.core.rest.call(null,(state_23042[(4)])));

return statearr_23077;
})();
var state_23042__$1 = state_23042;
var ex23074 = (state_23042__$1[(2)]);
var statearr_23078_23123 = state_23042__$1;
(statearr_23078_23123[(5)] = ex23074);


if((ex23074 instanceof Error)){
var statearr_23079_23124 = state_23042__$1;
(statearr_23079_23124[(1)] = (4));

(statearr_23079_23124[(5)] = null);

} else {
throw ex23074;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (14))){
var inst_22995 = (state_23042[(17)]);
var inst_22994 = (state_23042[(18)]);
var inst_22968 = (state_23042[(19)]);
var inst_22990 = (state_23042[(20)]);
var inst_22993 = (state_23042[(21)]);
var inst_22990__$1 = (state_23042[(2)]);
var inst_22991 = cljs.core.get.call(null,inst_22990__$1,new cljs.core.Keyword(null,"multi?","multi?",-749311069));
var inst_22992 = cljs.core.get.call(null,inst_22990__$1,new cljs.core.Keyword(null,"as","as",1148689641));
var inst_22993__$1 = cljs.core.get.call(null,inst_22990__$1,new cljs.core.Keyword(null,"recur","recur",-437573268));
var inst_22994__$1 = cljs.core.get.call(null,inst_22990__$1,new cljs.core.Keyword(null,"recur-seen","recur-seen",-1026475687));
var inst_22995__$1 = cljs.core.get.call(null,inst_22990__$1,new cljs.core.Keyword(null,"recur-depth","recur-depth",2141362057));
var inst_22996 = cljs.core.get.call(null,inst_22990__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_22997 = cljs.core.contains_QMARK_.call(null,inst_22994__$1,inst_22968);
var inst_22998 = (inst_22995__$1 > inst_22993__$1);
var inst_23000 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23001 = [inst_22968];
var inst_23002 = (new cljs.core.PersistentVector(null,1,(5),inst_23000,inst_23001,null));
var inst_23003 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23002);
var state_23042__$1 = (function (){var statearr_23080 = state_23042;
(statearr_23080[(12)] = inst_22992);

(statearr_23080[(15)] = inst_22996);

(statearr_23080[(16)] = inst_22997);

(statearr_23080[(17)] = inst_22995__$1);

(statearr_23080[(18)] = inst_22994__$1);

(statearr_23080[(11)] = inst_22991);

(statearr_23080[(20)] = inst_22990__$1);

(statearr_23080[(21)] = inst_22993__$1);

(statearr_23080[(7)] = inst_22998);

return statearr_23080;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23042__$1,(15),inst_23003);
} else {
if((state_val_23043 === (26))){
var inst_22992 = (state_23042[(12)]);
var inst_22996 = (state_23042[(15)]);
var inst_23012 = (state_23042[(14)]);
var inst_22997 = (state_23042[(16)]);
var inst_22995 = (state_23042[(17)]);
var inst_22994 = (state_23042[(18)]);
var inst_22968 = (state_23042[(19)]);
var inst_22991 = (state_23042[(11)]);
var inst_22990 = (state_23042[(20)]);
var inst_23021 = (state_23042[(8)]);
var inst_22993 = (state_23042[(21)]);
var inst_22998 = (state_23042[(7)]);
var inst_23025 = (function (){var recur_seen = inst_22994;
var recur_subject = inst_22968;
var sub_flakes = inst_23012;
var seen_QMARK_ = inst_22997;
var multi_QMARK_ = inst_22991;
var limit = inst_22996;
var recur_depth = inst_22995;
var as = inst_22992;
var max_depth_QMARK_ = inst_22998;
var map__22967 = inst_22990;
var recur = inst_22993;
var stop_QMARK_ = inst_23021;
return (function (results,as__$1,new_result){
return cljs.core.assoc.call(null,results,as__$1,new_result);
});
})();
var state_23042__$1 = state_23042;
var statearr_23081_23125 = state_23042__$1;
(statearr_23081_23125[(2)] = inst_23025);

(statearr_23081_23125[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (16))){
var inst_23006 = (state_23042[(10)]);
var inst_23008 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_23009 = cljs.core.sequence.call(null,inst_23008,inst_23006);
var state_23042__$1 = state_23042;
var statearr_23082_23126 = state_23042__$1;
(statearr_23082_23126[(2)] = inst_23009);

(statearr_23082_23126[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (30))){
var inst_23037 = (state_23042[(2)]);
var _ = (function (){var statearr_23083 = state_23042;
(statearr_23083[(4)] = cljs.core.rest.call(null,(state_23042[(4)])));

return statearr_23083;
})();
var state_23042__$1 = state_23042;
var statearr_23084_23127 = state_23042__$1;
(statearr_23084_23127[(2)] = inst_23037);

(statearr_23084_23127[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (10))){
var state_23042__$1 = state_23042;
var statearr_23085_23128 = state_23042__$1;
(statearr_23085_23128[(2)] = false);

(statearr_23085_23128[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (18))){
var inst_22997 = (state_23042[(16)]);
var inst_23012 = (state_23042[(2)]);
var state_23042__$1 = (function (){var statearr_23086 = state_23042;
(statearr_23086[(14)] = inst_23012);

return statearr_23086;
})();
if(cljs.core.truth_(inst_22997)){
var statearr_23087_23129 = state_23042__$1;
(statearr_23087_23129[(1)] = (19));

} else {
var statearr_23088_23130 = state_23042__$1;
(statearr_23088_23130[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23043 === (8))){
var inst_22985 = (state_23042[(2)]);
var state_23042__$1 = state_23042;
if(cljs.core.truth_(inst_22985)){
var statearr_23089_23131 = state_23042__$1;
(statearr_23089_23131[(1)] = (12));

} else {
var statearr_23090_23132 = state_23042__$1;
(statearr_23090_23132[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto____0 = (function (){
var statearr_23091 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23091[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto__);

(statearr_23091[(1)] = (1));

return statearr_23091;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto____1 = (function (state_23042){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_23042);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e23092){var ex__2882__auto__ = e23092;
var statearr_23093_23133 = state_23042;
(statearr_23093_23133[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_23042[(4)]))){
var statearr_23094_23134 = state_23042;
(statearr_23094_23134[(1)] = cljs.core.first.call(null,(state_23042[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23135 = state_23042;
state_23042 = G__23135;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto__ = function(state_23042){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto____1.call(this,state_23042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_23095 = f__2902__auto__.call(null);
(statearr_23095[(6)] = c__2901__auto__);

return statearr_23095;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_23313){
var state_val_23314 = (state_23313[(1)]);
if((state_val_23314 === (7))){
var state_23313__$1 = state_23313;
var statearr_23315_23400 = state_23313__$1;
(statearr_23315_23400[(2)] = null);

(statearr_23315_23400[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (20))){
var inst_23174 = cljs.core.PersistentHashMap.EMPTY;
var state_23313__$1 = state_23313;
var statearr_23316_23401 = state_23313__$1;
(statearr_23316_23401[(2)] = inst_23174);

(statearr_23316_23401[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (27))){
var inst_23192 = (state_23313[(7)]);
var inst_23162 = (state_23313[(8)]);
var inst_23156 = (state_23313[(9)]);
var inst_23176 = (state_23313[(10)]);
var inst_23292 = (state_23313[(2)]);
var inst_23293 = (function (){var top_level_subject = inst_23156;
var select_spec = inst_23162;
var base_acc = inst_23176;
var acc_PLUS_refs = inst_23192;
var result = inst_23292;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4126__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"multi?","multi?",-749311069).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto__ = new cljs.core.Keyword(null,"reverse?","reverse?",-1672868474).cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4115__auto__)){
return new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4115__auto__;
}
}
})())){
return cljs.core.conj.call(null,acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(spec),new cljs.core.Keyword(null,"order","order",-1254677256).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"predicate","predicate",-1742501860).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(spec)),new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_23294 = cljs.core.PersistentVector.EMPTY;
var inst_23295 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23162);
var inst_23296 = new cljs.core.Keyword(null,"pred-id","pred-id",-942630484).cljs$core$IFn$_invoke$arity$1(inst_23295);
var inst_23297 = cljs.core.vals.call(null,inst_23296);
var inst_23298 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23162);
var inst_23299 = new cljs.core.Keyword(null,"reverse","reverse",-888455266).cljs$core$IFn$_invoke$arity$1(inst_23298);
var inst_23300 = cljs.core.vals.call(null,inst_23299);
var inst_23301 = cljs.core.concat.call(null,inst_23297,inst_23300);
var inst_23302 = cljs.core.reduce.call(null,inst_23293,inst_23294,inst_23301);
var inst_23304 = (function (){var top_level_subject = inst_23156;
var select_spec = inst_23162;
var base_acc = inst_23176;
var acc_PLUS_refs = inst_23192;
var result = inst_23292;
var sort_preds = inst_23302;
return (function (acc,p__23303){
var vec__23317 = p__23303;
var selectPred = cljs.core.nth.call(null,vec__23317,(0),null);
var sortOrder = cljs.core.nth.call(null,vec__23317,(1),null);
var sortPred = cljs.core.nth.call(null,vec__23317,(2),null);
var limit = cljs.core.nth.call(null,vec__23317,(3),null);
return cljs.core.assoc.call(null,acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res.call(null,sortPred,sortOrder,(0),limit,cljs.core.get.call(null,acc,selectPred)));
});
})();
var inst_23305 = cljs.core.reduce.call(null,inst_23304,inst_23292,inst_23302);
var state_23313__$1 = state_23313;
var statearr_23320_23402 = state_23313__$1;
(statearr_23320_23402[(2)] = inst_23305);

(statearr_23320_23402[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (1))){
var state_23313__$1 = state_23313;
var statearr_23321_23403 = state_23313__$1;
(statearr_23321_23403[(2)] = null);

(statearr_23321_23403[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (24))){
var inst_23192 = (state_23313[(7)]);
var inst_23192__$1 = (state_23313[(2)]);
var inst_23193 = flakes;
var inst_23194 = cljs.core.PersistentHashMap.EMPTY;
var inst_23195 = inst_23193;
var inst_23196 = inst_23192__$1;
var inst_23197 = inst_23194;
var state_23313__$1 = (function (){var statearr_23322 = state_23313;
(statearr_23322[(11)] = inst_23195);

(statearr_23322[(7)] = inst_23192__$1);

(statearr_23322[(12)] = inst_23197);

(statearr_23322[(13)] = inst_23196);

return statearr_23322;
})();
var statearr_23323_23404 = state_23313__$1;
(statearr_23323_23404[(2)] = null);

(statearr_23323_23404[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (39))){
var inst_23162 = (state_23313[(8)]);
var inst_23196 = (state_23313[(13)]);
var inst_23211 = (state_23313[(14)]);
var inst_23205 = (state_23313[(15)]);
var inst_23240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23241 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_23196,inst_23162,inst_23205,inst_23211,false);
var state_23313__$1 = (function (){var statearr_23324 = state_23313;
(statearr_23324[(16)] = inst_23240);

return statearr_23324;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23313__$1,(42),inst_23241);
} else {
if((state_val_23314 === (46))){
var inst_23195 = (state_23313[(11)]);
var inst_23197 = (state_23313[(12)]);
var inst_23205 = (state_23313[(15)]);
var inst_23258 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23259 = ["_id"];
var inst_23260 = inst_23205.s;
var inst_23261 = [inst_23260];
var inst_23262 = cljs.core.PersistentHashMap.fromArrays(inst_23259,inst_23261);
var inst_23263 = cljs.core.rest.call(null,inst_23195);
var inst_23264 = [inst_23262,inst_23263,inst_23197];
var inst_23265 = (new cljs.core.PersistentVector(null,3,(5),inst_23258,inst_23264,null));
var state_23313__$1 = state_23313;
var statearr_23325_23405 = state_23313__$1;
(statearr_23325_23405[(2)] = inst_23265);

(statearr_23325_23405[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (4))){
var inst_23136 = (state_23313[(2)]);
var state_23313__$1 = state_23313;
var statearr_23326_23406 = state_23313__$1;
(statearr_23326_23406[(2)] = inst_23136);

(statearr_23326_23406[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (15))){
var inst_23162 = (state_23313[(8)]);
var inst_23163 = (state_23313[(17)]);
var inst_23162__$1 = (state_23313[(2)]);
var inst_23163__$1 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23162__$1);
var state_23313__$1 = (function (){var statearr_23327 = state_23313;
(statearr_23327[(8)] = inst_23162__$1);

(statearr_23327[(17)] = inst_23163__$1);

return statearr_23327;
})();
if(cljs.core.truth_(inst_23163__$1)){
var statearr_23328_23407 = state_23313__$1;
(statearr_23328_23407[(1)] = (16));

} else {
var statearr_23329_23408 = state_23313__$1;
(statearr_23329_23408[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (48))){
var inst_23276 = (state_23313[(2)]);
var state_23313__$1 = state_23313;
var statearr_23330_23409 = state_23313__$1;
(statearr_23330_23409[(2)] = inst_23276);

(statearr_23330_23409[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (50))){
var state_23313__$1 = state_23313;
var statearr_23331_23410 = state_23313__$1;
(statearr_23331_23410[(2)] = null);

(statearr_23331_23410[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (21))){
var inst_23162 = (state_23313[(8)]);
var inst_23176 = (state_23313[(2)]);
var inst_23177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23178 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"reverse","reverse",-888455266)];
var inst_23179 = (new cljs.core.PersistentVector(null,2,(5),inst_23177,inst_23178,null));
var inst_23180 = cljs.core.get_in.call(null,inst_23162,inst_23179);
var state_23313__$1 = (function (){var statearr_23332 = state_23313;
(statearr_23332[(10)] = inst_23176);

return statearr_23332;
})();
if(cljs.core.truth_(inst_23180)){
var statearr_23333_23411 = state_23313__$1;
(statearr_23333_23411[(1)] = (22));

} else {
var statearr_23334_23412 = state_23313__$1;
(statearr_23334_23412[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (31))){
var inst_23210 = (state_23313[(18)]);
var inst_23196 = (state_23313[(13)]);
var inst_23205 = (state_23313[(15)]);
var inst_23214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23215 = fluree.db.query.fql.flake__GT_recur.call(null,db,inst_23205,inst_23210,inst_23196,fuel,max_fuel,cache);
var state_23313__$1 = (function (){var statearr_23335 = state_23313;
(statearr_23335[(19)] = inst_23214);

return statearr_23335;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23313__$1,(34),inst_23215);
} else {
if((state_val_23314 === (32))){
var inst_23210 = (state_23313[(18)]);
var state_23313__$1 = state_23313;
if(cljs.core.truth_(inst_23210)){
var statearr_23336_23413 = state_23313__$1;
(statearr_23336_23413[(1)] = (35));

} else {
var statearr_23337_23414 = state_23313__$1;
(statearr_23337_23414[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (40))){
var inst_23162 = (state_23313[(8)]);
var inst_23250 = new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(inst_23162);
var inst_23251 = cljs.core.empty_QMARK_.call(null,inst_23250);
var state_23313__$1 = state_23313;
if(inst_23251){
var statearr_23338_23415 = state_23313__$1;
(statearr_23338_23415[(1)] = (43));

} else {
var statearr_23339_23416 = state_23313__$1;
(statearr_23339_23416[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (33))){
var inst_23205 = (state_23313[(15)]);
var inst_23282 = (state_23313[(2)]);
var inst_23283 = cljs.core.nth.call(null,inst_23282,(0),null);
var inst_23284 = cljs.core.nth.call(null,inst_23282,(1),null);
var inst_23285 = cljs.core.nth.call(null,inst_23282,(2),null);
var inst_23286 = inst_23205.s;
var inst_23287 = cljs.core.assoc.call(null,inst_23283,new cljs.core.Keyword(null,"_id","_id",-789960287),inst_23286);
var inst_23195 = inst_23284;
var inst_23196 = inst_23287;
var inst_23197 = inst_23285;
var state_23313__$1 = (function (){var statearr_23340 = state_23313;
(statearr_23340[(11)] = inst_23195);

(statearr_23340[(12)] = inst_23197);

(statearr_23340[(13)] = inst_23196);

return statearr_23340;
})();
var statearr_23341_23417 = state_23313__$1;
(statearr_23341_23417[(2)] = null);

(statearr_23341_23417[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (13))){
var inst_23156 = (state_23313[(9)]);
var inst_23159 = fluree.db.query.fql.full_select_spec.call(null,db,cache,base_select_spec,inst_23156);
var state_23313__$1 = state_23313;
var statearr_23342_23418 = state_23313__$1;
(statearr_23342_23418[(2)] = inst_23159);

(statearr_23342_23418[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (22))){
var inst_23162 = (state_23313[(8)]);
var inst_23182 = cljs.core.first.call(null,flakes);
var inst_23183 = fluree.db.query.fql.s.call(null,inst_23182);
var inst_23184 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs.call(null,inst_23162);
var inst_23185 = fluree.db.query.fql.resolve_reverse_refs.call(null,db,cache,fuel,max_fuel,inst_23183,inst_23184);
var state_23313__$1 = state_23313;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23313__$1,(25),inst_23185);
} else {
if((state_val_23314 === (36))){
var inst_23162 = (state_23313[(8)]);
var inst_23238 = new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101).cljs$core$IFn$_invoke$arity$1(inst_23162);
var state_23313__$1 = state_23313;
if(cljs.core.truth_(inst_23238)){
var statearr_23343_23419 = state_23313__$1;
(statearr_23343_23419[(1)] = (39));

} else {
var statearr_23344_23420 = state_23313__$1;
(statearr_23344_23420[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (41))){
var inst_23278 = (state_23313[(2)]);
var state_23313__$1 = state_23313;
var statearr_23345_23421 = state_23313__$1;
(statearr_23345_23421[(2)] = inst_23278);

(statearr_23345_23421[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (43))){
var inst_23162 = (state_23313[(8)]);
var inst_23253 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23162);
var state_23313__$1 = state_23313;
var statearr_23346_23422 = state_23313__$1;
(statearr_23346_23422[(2)] = inst_23253);

(statearr_23346_23422[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (29))){
var inst_23195 = (state_23313[(11)]);
var inst_23162 = (state_23313[(8)]);
var inst_23210 = (state_23313[(18)]);
var inst_23205 = (state_23313[(15)]);
var inst_23205__$1 = cljs.core.first.call(null,inst_23195);
var inst_23206 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23207 = inst_23205__$1.p;
var inst_23208 = [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"pred-id","pred-id",-942630484),inst_23207];
var inst_23209 = (new cljs.core.PersistentVector(null,3,(5),inst_23206,inst_23208,null));
var inst_23210__$1 = cljs.core.get_in.call(null,inst_23162,inst_23209);
var inst_23211 = fluree.db.query.fql.component_follow_QMARK_.call(null,inst_23210__$1,inst_23162);
var inst_23212 = new cljs.core.Keyword(null,"recur","recur",-437573268).cljs$core$IFn$_invoke$arity$1(inst_23210__$1);
var state_23313__$1 = (function (){var statearr_23347 = state_23313;
(statearr_23347[(18)] = inst_23210__$1);

(statearr_23347[(14)] = inst_23211);

(statearr_23347[(15)] = inst_23205__$1);

return statearr_23347;
})();
if(cljs.core.truth_(inst_23212)){
var statearr_23348_23423 = state_23313__$1;
(statearr_23348_23423[(1)] = (31));

} else {
var statearr_23349_23424 = state_23313__$1;
(statearr_23349_23424[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (44))){
var state_23313__$1 = state_23313;
var statearr_23350_23425 = state_23313__$1;
(statearr_23350_23425[(2)] = false);

(statearr_23350_23425[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (6))){
var state_23313__$1 = state_23313;
var statearr_23351_23426 = state_23313__$1;
(statearr_23351_23426[(2)] = null);

(statearr_23351_23426[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (28))){
var inst_23196 = (state_23313[(13)]);
var state_23313__$1 = state_23313;
var statearr_23352_23427 = state_23313__$1;
(statearr_23352_23427[(2)] = inst_23196);

(statearr_23352_23427[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (51))){
var inst_23274 = (state_23313[(2)]);
var state_23313__$1 = state_23313;
var statearr_23353_23428 = state_23313__$1;
(statearr_23353_23428[(2)] = inst_23274);

(statearr_23353_23428[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (25))){
var inst_23176 = (state_23313[(10)]);
var inst_23187 = (state_23313[(2)]);
var inst_23188 = fluree.db.util.async.throw_err.call(null,inst_23187);
var inst_23189 = cljs.core.merge.call(null,inst_23176,inst_23188);
var state_23313__$1 = state_23313;
var statearr_23354_23429 = state_23313__$1;
(statearr_23354_23429[(2)] = inst_23189);

(statearr_23354_23429[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (34))){
var inst_23195 = (state_23313[(11)]);
var inst_23197 = (state_23313[(12)]);
var inst_23214 = (state_23313[(19)]);
var inst_23217 = (state_23313[(2)]);
var inst_23218 = fluree.db.util.async.throw_err.call(null,inst_23217);
var inst_23219 = cljs.core.rest.call(null,inst_23195);
var inst_23220 = [inst_23218,inst_23219,inst_23197];
var inst_23221 = (new cljs.core.PersistentVector(null,3,(5),inst_23214,inst_23220,null));
var state_23313__$1 = state_23313;
var statearr_23355_23430 = state_23313__$1;
(statearr_23355_23430[(2)] = inst_23221);

(statearr_23355_23430[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (17))){
var inst_23162 = (state_23313[(8)]);
var inst_23166 = new cljs.core.Keyword(null,"id?","id?",-1487101183).cljs$core$IFn$_invoke$arity$1(inst_23162);
var state_23313__$1 = state_23313;
var statearr_23357_23431 = state_23313__$1;
(statearr_23357_23431[(2)] = inst_23166);

(statearr_23357_23431[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (3))){
var inst_23311 = (state_23313[(2)]);
var state_23313__$1 = state_23313;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23313__$1,inst_23311);
} else {
if((state_val_23314 === (12))){
var _ = (function (){var statearr_23358 = state_23313;
(statearr_23358[(4)] = cljs.core.rest.call(null,(state_23313[(4)])));

return statearr_23358;
})();
var state_23313__$1 = state_23313;
var ex23356 = (state_23313__$1[(2)]);
var statearr_23359_23432 = state_23313__$1;
(statearr_23359_23432[(5)] = ex23356);


var statearr_23360_23433 = state_23313__$1;
(statearr_23360_23433[(1)] = (11));

(statearr_23360_23433[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (2))){
var _ = (function (){var statearr_23361 = state_23313;
(statearr_23361[(4)] = cljs.core.cons.call(null,(5),(state_23313[(4)])));

return statearr_23361;
})();
var inst_23142 = cljs.core.not_empty.call(null,flakes);
var state_23313__$1 = state_23313;
if(cljs.core.truth_(inst_23142)){
var statearr_23362_23434 = state_23313__$1;
(statearr_23362_23434[(1)] = (6));

} else {
var statearr_23363_23435 = state_23313__$1;
(statearr_23363_23435[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (23))){
var inst_23176 = (state_23313[(10)]);
var state_23313__$1 = state_23313;
var statearr_23364_23436 = state_23313__$1;
(statearr_23364_23436[(2)] = inst_23176);

(statearr_23364_23436[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (47))){
var state_23313__$1 = state_23313;
var statearr_23365_23437 = state_23313__$1;
(statearr_23365_23437[(1)] = (49));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (35))){
var inst_23197 = (state_23313[(12)]);
var inst_23210 = (state_23313[(18)]);
var inst_23196 = (state_23313[(13)]);
var inst_23211 = (state_23313[(14)]);
var inst_23205 = (state_23313[(15)]);
var inst_23227 = fluree.db.query.fql.add_pred.call(null,db,cache,fuel,max_fuel,inst_23196,inst_23210,inst_23205,inst_23211,false,inst_23197);
var state_23313__$1 = state_23313;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23313__$1,(38),inst_23227);
} else {
if((state_val_23314 === (19))){
var inst_23156 = (state_23313[(9)]);
var inst_23170 = ["_id"];
var inst_23171 = [inst_23156];
var inst_23172 = cljs.core.PersistentHashMap.fromArrays(inst_23170,inst_23171);
var state_23313__$1 = state_23313;
var statearr_23367_23438 = state_23313__$1;
(statearr_23367_23438[(2)] = inst_23172);

(statearr_23367_23438[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (11))){
var inst_23144 = (state_23313[(2)]);
var inst_23145 = fluree.db.util.log.error.call(null,inst_23144);
var inst_23146 = (function(){throw inst_23144})();
var state_23313__$1 = (function (){var statearr_23369 = state_23313;
(statearr_23369[(20)] = inst_23145);

return statearr_23369;
})();
var statearr_23370_23439 = state_23313__$1;
(statearr_23370_23439[(2)] = inst_23146);

(statearr_23370_23439[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (9))){
var _ = (function (){var statearr_23371 = state_23313;
(statearr_23371[(4)] = cljs.core.cons.call(null,(12),(state_23313[(4)])));

return statearr_23371;
})();
var inst_23152 = cljs.core.first.call(null,flakes);
var inst_23153 = fluree.db.query.fql.s.call(null,inst_23152);
var ___$1 = (function (){var statearr_23372 = state_23313;
(statearr_23372[(4)] = cljs.core.rest.call(null,(state_23313[(4)])));

return statearr_23372;
})();
var state_23313__$1 = state_23313;
var statearr_23373_23440 = state_23313__$1;
(statearr_23373_23440[(2)] = inst_23153);

(statearr_23373_23440[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (5))){
var _ = (function (){var statearr_23374 = state_23313;
(statearr_23374[(4)] = cljs.core.rest.call(null,(state_23313[(4)])));

return statearr_23374;
})();
var state_23313__$1 = state_23313;
var ex23368 = (state_23313__$1[(2)]);
var statearr_23375_23441 = state_23313__$1;
(statearr_23375_23441[(5)] = ex23368);


if((ex23368 instanceof Error)){
var statearr_23376_23442 = state_23313__$1;
(statearr_23376_23442[(1)] = (4));

(statearr_23376_23442[(5)] = null);

} else {
throw ex23368;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (14))){
var state_23313__$1 = state_23313;
var statearr_23377_23443 = state_23313__$1;
(statearr_23377_23443[(2)] = base_select_spec);

(statearr_23377_23443[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (45))){
var inst_23256 = (state_23313[(2)]);
var state_23313__$1 = state_23313;
if(cljs.core.truth_(inst_23256)){
var statearr_23378_23444 = state_23313__$1;
(statearr_23378_23444[(1)] = (46));

} else {
var statearr_23379_23445 = state_23313__$1;
(statearr_23379_23445[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (26))){
var inst_23195 = (state_23313[(11)]);
var inst_23199 = cljs.core.empty_QMARK_.call(null,inst_23195);
var state_23313__$1 = state_23313;
if(inst_23199){
var statearr_23380_23446 = state_23313__$1;
(statearr_23380_23446[(1)] = (28));

} else {
var statearr_23381_23447 = state_23313__$1;
(statearr_23381_23447[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (16))){
var inst_23163 = (state_23313[(17)]);
var state_23313__$1 = state_23313;
var statearr_23382_23448 = state_23313__$1;
(statearr_23382_23448[(2)] = inst_23163);

(statearr_23382_23448[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (38))){
var inst_23195 = (state_23313[(11)]);
var inst_23229 = (state_23313[(2)]);
var inst_23230 = fluree.db.util.async.throw_err.call(null,inst_23229);
var inst_23231 = cljs.core.nth.call(null,inst_23230,(0),null);
var inst_23232 = cljs.core.nth.call(null,inst_23230,(1),null);
var inst_23233 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23234 = cljs.core.rest.call(null,inst_23195);
var inst_23235 = [inst_23231,inst_23234,inst_23232];
var inst_23236 = (new cljs.core.PersistentVector(null,3,(5),inst_23233,inst_23235,null));
var state_23313__$1 = state_23313;
var statearr_23383_23449 = state_23313__$1;
(statearr_23383_23449[(2)] = inst_23236);

(statearr_23383_23449[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (30))){
var inst_23290 = (state_23313[(2)]);
var state_23313__$1 = state_23313;
var statearr_23384_23450 = state_23313__$1;
(statearr_23384_23450[(2)] = inst_23290);

(statearr_23384_23450[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (10))){
var inst_23156 = (state_23313[(2)]);
var inst_23157 = fluree.db.query.fql.has_ns_lookups_QMARK_.call(null,base_select_spec);
var state_23313__$1 = (function (){var statearr_23385 = state_23313;
(statearr_23385[(9)] = inst_23156);

return statearr_23385;
})();
if(cljs.core.truth_(inst_23157)){
var statearr_23386_23451 = state_23313__$1;
(statearr_23386_23451[(1)] = (13));

} else {
var statearr_23387_23452 = state_23313__$1;
(statearr_23387_23452[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (18))){
var inst_23168 = (state_23313[(2)]);
var state_23313__$1 = state_23313;
if(cljs.core.truth_(inst_23168)){
var statearr_23388_23453 = state_23313__$1;
(statearr_23388_23453[(1)] = (19));

} else {
var statearr_23389_23454 = state_23313__$1;
(statearr_23389_23454[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (42))){
var inst_23195 = (state_23313[(11)]);
var inst_23197 = (state_23313[(12)]);
var inst_23240 = (state_23313[(16)]);
var inst_23243 = (state_23313[(2)]);
var inst_23244 = fluree.db.util.async.throw_err.call(null,inst_23243);
var inst_23245 = cljs.core.first.call(null,inst_23244);
var inst_23246 = cljs.core.rest.call(null,inst_23195);
var inst_23247 = [inst_23245,inst_23246,inst_23197];
var inst_23248 = (new cljs.core.PersistentVector(null,3,(5),inst_23240,inst_23247,null));
var state_23313__$1 = state_23313;
var statearr_23390_23455 = state_23313__$1;
(statearr_23390_23455[(2)] = inst_23248);

(statearr_23390_23455[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (37))){
var inst_23280 = (state_23313[(2)]);
var state_23313__$1 = state_23313;
var statearr_23391_23456 = state_23313__$1;
(statearr_23391_23456[(2)] = inst_23280);

(statearr_23391_23456[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (8))){
var inst_23308 = (state_23313[(2)]);
var _ = (function (){var statearr_23392 = state_23313;
(statearr_23392[(4)] = cljs.core.rest.call(null,(state_23313[(4)])));

return statearr_23392;
})();
var state_23313__$1 = state_23313;
var statearr_23393_23457 = state_23313__$1;
(statearr_23393_23457[(2)] = inst_23308);

(statearr_23393_23457[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23314 === (49))){
var inst_23195 = (state_23313[(11)]);
var inst_23197 = (state_23313[(12)]);
var inst_23196 = (state_23313[(13)]);
var inst_23268 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23269 = cljs.core.rest.call(null,inst_23195);
var inst_23270 = [inst_23196,inst_23269,inst_23197];
var inst_23271 = (new cljs.core.PersistentVector(null,3,(5),inst_23268,inst_23270,null));
var state_23313__$1 = state_23313;
var statearr_23394_23458 = state_23313__$1;
(statearr_23394_23458[(2)] = inst_23271);

(statearr_23394_23458[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto____0 = (function (){
var statearr_23395 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23395[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto__);

(statearr_23395[(1)] = (1));

return statearr_23395;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto____1 = (function (state_23313){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_23313);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e23396){var ex__2882__auto__ = e23396;
var statearr_23397_23459 = state_23313;
(statearr_23397_23459[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_23313[(4)]))){
var statearr_23398_23460 = state_23313;
(statearr_23398_23460[(1)] = cljs.core.first.call(null,(state_23313[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23461 = state_23313;
state_23313 = G__23461;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto__ = function(state_23313){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto____1.call(this,state_23313);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_23399 = f__2902__auto__.call(null);
(statearr_23399[(6)] = c__2901__auto__);

return statearr_23399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__23464 = arguments.length;
switch (G__23464) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.call(null,db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_23506){
var state_val_23507 = (state_23506[(1)]);
if((state_val_23507 === (7))){
var inst_23472 = (state_23506[(7)]);
var state_23506__$1 = state_23506;
var statearr_23508_23538 = state_23506__$1;
(statearr_23508_23538[(2)] = inst_23472);

(statearr_23508_23538[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23507 === (1))){
var state_23506__$1 = state_23506;
var statearr_23509_23539 = state_23506__$1;
(statearr_23509_23539[(2)] = null);

(statearr_23509_23539[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23507 === (4))){
var inst_23465 = (state_23506[(2)]);
var state_23506__$1 = state_23506;
var statearr_23510_23540 = state_23506__$1;
(statearr_23510_23540[(2)] = inst_23465);

(statearr_23510_23540[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23507 === (15))){
var inst_23500 = (state_23506[(2)]);
var inst_23501 = fluree.db.util.async.throw_err.call(null,inst_23500);
var _ = (function (){var statearr_23511 = state_23506;
(statearr_23511[(4)] = cljs.core.rest.call(null,(state_23506[(4)])));

return statearr_23511;
})();
var state_23506__$1 = state_23506;
var statearr_23512_23541 = state_23506__$1;
(statearr_23512_23541[(2)] = inst_23501);

(statearr_23512_23541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23507 === (13))){
var inst_23484 = (state_23506[(8)]);
var state_23506__$1 = state_23506;
var statearr_23513_23542 = state_23506__$1;
(statearr_23513_23542[(2)] = inst_23484);

(statearr_23513_23542[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23507 === (6))){
var inst_23472 = (state_23506[(7)]);
var inst_23474 = fluree.db.query.fql.fuel_flakes_transducer.call(null,fuel,max_fuel);
var inst_23475 = cljs.core.comp.call(null,inst_23472,inst_23474);
var state_23506__$1 = state_23506;
var statearr_23514_23543 = state_23506__$1;
(statearr_23514_23543[(2)] = inst_23475);

(statearr_23514_23543[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23507 === (3))){
var inst_23504 = (state_23506[(2)]);
var state_23506__$1 = state_23506;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23506__$1,inst_23504);
} else {
if((state_val_23507 === (12))){
var inst_23484 = (state_23506[(8)]);
var inst_23486 = cljs.core.take.call(null,limit);
var inst_23487 = cljs.core.comp.call(null,inst_23484,inst_23486);
var state_23506__$1 = state_23506;
var statearr_23515_23544 = state_23506__$1;
(statearr_23515_23544[(2)] = inst_23487);

(statearr_23515_23544[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23507 === (2))){
var _ = (function (){var statearr_23516 = state_23506;
(statearr_23516[(4)] = cljs.core.cons.call(null,(5),(state_23506[(4)])));

return statearr_23516;
})();
var inst_23472 = cljs.core.partition_by.call(null,fluree.db.query.fql.s);
var state_23506__$1 = (function (){var statearr_23517 = state_23506;
(statearr_23517[(7)] = inst_23472);

return statearr_23517;
})();
if(cljs.core.truth_(fuel)){
var statearr_23518_23545 = state_23506__$1;
(statearr_23518_23545[(1)] = (6));

} else {
var statearr_23519_23546 = state_23506__$1;
(statearr_23519_23546[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23507 === (11))){
var inst_23484 = (state_23506[(2)]);
var state_23506__$1 = (function (){var statearr_23521 = state_23506;
(statearr_23521[(8)] = inst_23484);

return statearr_23521;
})();
if(cljs.core.truth_(limit)){
var statearr_23522_23547 = state_23506__$1;
(statearr_23522_23547[(1)] = (12));

} else {
var statearr_23523_23548 = state_23506__$1;
(statearr_23523_23548[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23507 === (9))){
var inst_23478 = (state_23506[(9)]);
var inst_23480 = cljs.core.drop.call(null,offset);
var inst_23481 = cljs.core.comp.call(null,inst_23478,inst_23480);
var state_23506__$1 = state_23506;
var statearr_23524_23549 = state_23506__$1;
(statearr_23524_23549[(2)] = inst_23481);

(statearr_23524_23549[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23507 === (5))){
var _ = (function (){var statearr_23525 = state_23506;
(statearr_23525[(4)] = cljs.core.rest.call(null,(state_23506[(4)])));

return statearr_23525;
})();
var state_23506__$1 = state_23506;
var ex23520 = (state_23506__$1[(2)]);
var statearr_23526_23550 = state_23506__$1;
(statearr_23526_23550[(5)] = ex23520);


if((ex23520 instanceof Error)){
var statearr_23527_23551 = state_23506__$1;
(statearr_23527_23551[(1)] = (4));

(statearr_23527_23551[(5)] = null);

} else {
throw ex23520;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23507 === (14))){
var inst_23490 = (state_23506[(2)]);
var inst_23491 = (function (){return (function (x){
var and__4115__auto__ = max_fuel;
if(cljs.core.truth_(and__4115__auto__)){
return (cljs.core.deref.call(null,fuel) >= max_fuel);
} else {
return and__4115__auto__;
}
});
})();
var inst_23492 = cljs.core.halt_when.call(null,inst_23491);
var inst_23493 = cljs.core.comp.call(null,inst_23490,inst_23492);
var inst_23494 = cljs.core.sequence.call(null,inst_23493,flakes);
var inst_23495 = cljs.core.PersistentVector.EMPTY;
var inst_23496 = (function (){var xf = inst_23493;
var flakes_by_sub = inst_23494;
return (function (p1__23462_SHARP_){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,p1__23462_SHARP_);
});
})();
var inst_23497 = cljs.core.map.call(null,inst_23496,inst_23494);
var inst_23498 = fluree.db.util.async.merge_into_QMARK_.call(null,inst_23495,inst_23497);
var state_23506__$1 = state_23506;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23506__$1,(15),inst_23498);
} else {
if((state_val_23507 === (10))){
var inst_23478 = (state_23506[(9)]);
var state_23506__$1 = state_23506;
var statearr_23528_23552 = state_23506__$1;
(statearr_23528_23552[(2)] = inst_23478);

(statearr_23528_23552[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23507 === (8))){
var inst_23478 = (state_23506[(2)]);
var state_23506__$1 = (function (){var statearr_23529 = state_23506;
(statearr_23529[(9)] = inst_23478);

return statearr_23529;
})();
if(cljs.core.truth_(offset)){
var statearr_23530_23553 = state_23506__$1;
(statearr_23530_23553[(1)] = (9));

} else {
var statearr_23531_23554 = state_23506__$1;
(statearr_23531_23554[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2879__auto__ = null;
var fluree$db$query$fql$state_machine__2879__auto____0 = (function (){
var statearr_23532 = [null,null,null,null,null,null,null,null,null,null];
(statearr_23532[(0)] = fluree$db$query$fql$state_machine__2879__auto__);

(statearr_23532[(1)] = (1));

return statearr_23532;
});
var fluree$db$query$fql$state_machine__2879__auto____1 = (function (state_23506){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_23506);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e23533){var ex__2882__auto__ = e23533;
var statearr_23534_23555 = state_23506;
(statearr_23534_23555[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_23506[(4)]))){
var statearr_23535_23556 = state_23506;
(statearr_23535_23556[(1)] = cljs.core.first.call(null,(state_23506[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23557 = state_23506;
state_23506 = G__23557;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2879__auto__ = function(state_23506){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2879__auto____1.call(this,state_23506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2879__auto____0;
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2879__auto____1;
return fluree$db$query$fql$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_23536 = f__2902__auto__.call(null);
(statearr_23536[(6)] = c__2901__auto__);

return statearr_23536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__23559 = arguments.length;
switch (G__23559) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.call(null,db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_23643){
var state_val_23644 = (state_23643[(1)]);
if((state_val_23644 === (7))){
var inst_23638 = (state_23643[(2)]);
var _ = (function (){var statearr_23646 = state_23643;
(statearr_23646[(4)] = cljs.core.rest.call(null,(state_23643[(4)])));

return statearr_23646;
})();
var state_23643__$1 = state_23643;
var statearr_23647_23694 = state_23643__$1;
(statearr_23647_23694[(2)] = inst_23638);

(statearr_23647_23694[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (20))){
var inst_23580 = (state_23643[(7)]);
var inst_23579 = (state_23643[(8)]);
var inst_23587 = (state_23643[(9)]);
var inst_23608 = (inst_23579 + (1));
var tmp23645 = inst_23580;
var inst_23578 = inst_23587;
var inst_23579__$1 = inst_23608;
var inst_23580__$1 = tmp23645;
var state_23643__$1 = (function (){var statearr_23648 = state_23643;
(statearr_23648[(7)] = inst_23580__$1);

(statearr_23648[(10)] = inst_23578);

(statearr_23648[(8)] = inst_23579__$1);

return statearr_23648;
})();
var statearr_23649_23695 = state_23643__$1;
(statearr_23649_23695[(2)] = null);

(statearr_23649_23695[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (27))){
var inst_23613 = (state_23643[(11)]);
var inst_23622 = (state_23643[(2)]);
var inst_23623 = fluree.db.util.async.throw_err.call(null,inst_23622);
var inst_23624 = inst_23613.call(null,inst_23623);
var state_23643__$1 = state_23643;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23643__$1,(26),inst_23624);
} else {
if((state_val_23644 === (1))){
var state_23643__$1 = state_23643;
var statearr_23650_23696 = state_23643__$1;
(statearr_23650_23696[(2)] = null);

(statearr_23650_23696[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (24))){
var state_23643__$1 = state_23643;
var statearr_23651_23697 = state_23643__$1;
(statearr_23651_23697[(2)] = null);

(statearr_23651_23697[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (4))){
var inst_23560 = (state_23643[(2)]);
var state_23643__$1 = state_23643;
var statearr_23652_23698 = state_23643__$1;
(statearr_23652_23698[(2)] = inst_23560);

(statearr_23652_23698[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (15))){
var inst_23601 = (state_23643[(12)]);
var inst_23601__$1 = offset;
var state_23643__$1 = (function (){var statearr_23653 = state_23643;
(statearr_23653[(12)] = inst_23601__$1);

return statearr_23653;
})();
if(cljs.core.truth_(inst_23601__$1)){
var statearr_23654_23699 = state_23643__$1;
(statearr_23654_23699[(1)] = (17));

} else {
var statearr_23655_23700 = state_23643__$1;
(statearr_23655_23700[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (21))){
var state_23643__$1 = state_23643;
var statearr_23656_23701 = state_23643__$1;
(statearr_23656_23701[(1)] = (23));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (13))){
var inst_23596 = (state_23643[(2)]);
var state_23643__$1 = state_23643;
var statearr_23658_23702 = state_23643__$1;
(statearr_23658_23702[(2)] = inst_23596);

(statearr_23658_23702[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (22))){
var inst_23634 = (state_23643[(2)]);
var state_23643__$1 = state_23643;
var statearr_23659_23703 = state_23643__$1;
(statearr_23659_23703[(2)] = inst_23634);

(statearr_23659_23703[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (6))){
var inst_23588 = (state_23643[(13)]);
var inst_23578 = (state_23643[(10)]);
var inst_23586 = (state_23643[(14)]);
var inst_23585 = cljs.core.seq.call(null,inst_23578);
var inst_23586__$1 = cljs.core.first.call(null,inst_23585);
var inst_23587 = cljs.core.next.call(null,inst_23585);
var inst_23588__$1 = (inst_23586__$1 == null);
var state_23643__$1 = (function (){var statearr_23660 = state_23643;
(statearr_23660[(13)] = inst_23588__$1);

(statearr_23660[(14)] = inst_23586__$1);

(statearr_23660[(9)] = inst_23587);

return statearr_23660;
})();
if(cljs.core.truth_(inst_23588__$1)){
var statearr_23661_23704 = state_23643__$1;
(statearr_23661_23704[(1)] = (8));

} else {
var statearr_23662_23705 = state_23643__$1;
(statearr_23662_23705[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (25))){
var inst_23632 = (state_23643[(2)]);
var state_23643__$1 = state_23643;
var statearr_23663_23706 = state_23643__$1;
(statearr_23663_23706[(2)] = inst_23632);

(statearr_23663_23706[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (17))){
var inst_23579 = (state_23643[(8)]);
var inst_23603 = (inst_23579 < offset);
var state_23643__$1 = state_23643;
var statearr_23664_23707 = state_23643__$1;
(statearr_23664_23707[(2)] = inst_23603);

(statearr_23664_23707[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (3))){
var inst_23641 = (state_23643[(2)]);
var state_23643__$1 = state_23643;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23643__$1,inst_23641);
} else {
if((state_val_23644 === (12))){
var inst_23591 = (state_23643[(15)]);
var state_23643__$1 = state_23643;
var statearr_23665_23708 = state_23643__$1;
(statearr_23665_23708[(2)] = inst_23591);

(statearr_23665_23708[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (2))){
var inst_23573 = (state_23643[(16)]);
var _ = (function (){var statearr_23666 = state_23643;
(statearr_23666[(4)] = cljs.core.cons.call(null,(5),(state_23643[(4)])));

return statearr_23666;
})();
var inst_23573__$1 = subjects;
var inst_23574 = cljs.core.seq.call(null,inst_23573__$1);
var inst_23575 = cljs.core.first.call(null,inst_23574);
var inst_23576 = cljs.core.next.call(null,inst_23574);
var inst_23577 = cljs.core.PersistentVector.EMPTY;
var inst_23578 = inst_23573__$1;
var inst_23579 = (0);
var inst_23580 = inst_23577;
var state_23643__$1 = (function (){var statearr_23667 = state_23643;
(statearr_23667[(7)] = inst_23580);

(statearr_23667[(10)] = inst_23578);

(statearr_23667[(8)] = inst_23579);

(statearr_23667[(16)] = inst_23573__$1);

(statearr_23667[(17)] = inst_23575);

(statearr_23667[(18)] = inst_23576);

return statearr_23667;
})();
var statearr_23668_23709 = state_23643__$1;
(statearr_23668_23709[(2)] = null);

(statearr_23668_23709[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (23))){
var inst_23580 = (state_23643[(7)]);
var inst_23578 = (state_23643[(10)]);
var inst_23579 = (state_23643[(8)]);
var inst_23586 = (state_23643[(14)]);
var inst_23573 = (state_23643[(16)]);
var inst_23587 = (state_23643[(9)]);
var inst_23575 = (state_23643[(17)]);
var inst_23576 = (state_23643[(18)]);
var inst_23612 = (inst_23579 + (1));
var inst_23613 = (function (){var vec__23570 = inst_23573;
var G__23569 = inst_23578;
var seq__23583 = inst_23587;
var r = inst_23587;
var acc = inst_23580;
var n = inst_23579;
var first__23572 = inst_23575;
var first__23584 = inst_23586;
var s = inst_23586;
var seq__23571 = inst_23576;
var vec__23582 = inst_23578;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_23614 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23615 = [inst_23586];
var inst_23616 = (new cljs.core.PersistentVector(null,1,(5),inst_23614,inst_23615,null));
var inst_23617 = [new cljs.core.Keyword(null,"limit","limit",-1355822363)];
var inst_23618 = [limit];
var inst_23619 = cljs.core.PersistentHashMap.fromArrays(inst_23617,inst_23618);
var inst_23620 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_23616,inst_23619);
var state_23643__$1 = (function (){var statearr_23669 = state_23643;
(statearr_23669[(11)] = inst_23613);

(statearr_23669[(19)] = inst_23612);

return statearr_23669;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23643__$1,(27),inst_23620);
} else {
if((state_val_23644 === (19))){
var inst_23606 = (state_23643[(2)]);
var state_23643__$1 = state_23643;
if(cljs.core.truth_(inst_23606)){
var statearr_23670_23710 = state_23643__$1;
(statearr_23670_23710[(1)] = (20));

} else {
var statearr_23671_23711 = state_23643__$1;
(statearr_23671_23711[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (11))){
var inst_23579 = (state_23643[(8)]);
var inst_23593 = (inst_23579 > limit);
var state_23643__$1 = state_23643;
var statearr_23673_23712 = state_23643__$1;
(statearr_23673_23712[(2)] = inst_23593);

(statearr_23673_23712[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (9))){
var inst_23591 = (state_23643[(15)]);
var inst_23591__$1 = limit;
var state_23643__$1 = (function (){var statearr_23674 = state_23643;
(statearr_23674[(15)] = inst_23591__$1);

return statearr_23674;
})();
if(cljs.core.truth_(inst_23591__$1)){
var statearr_23675_23713 = state_23643__$1;
(statearr_23675_23713[(1)] = (11));

} else {
var statearr_23676_23714 = state_23643__$1;
(statearr_23676_23714[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (5))){
var _ = (function (){var statearr_23677 = state_23643;
(statearr_23677[(4)] = cljs.core.rest.call(null,(state_23643[(4)])));

return statearr_23677;
})();
var state_23643__$1 = state_23643;
var ex23672 = (state_23643__$1[(2)]);
var statearr_23678_23715 = state_23643__$1;
(statearr_23678_23715[(5)] = ex23672);


if((ex23672 instanceof Error)){
var statearr_23679_23716 = state_23643__$1;
(statearr_23679_23716[(1)] = (4));

(statearr_23679_23716[(5)] = null);

} else {
throw ex23672;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (14))){
var inst_23580 = (state_23643[(7)]);
var state_23643__$1 = state_23643;
var statearr_23680_23717 = state_23643__$1;
(statearr_23680_23717[(2)] = inst_23580);

(statearr_23680_23717[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (26))){
var inst_23580 = (state_23643[(7)]);
var inst_23587 = (state_23643[(9)]);
var inst_23612 = (state_23643[(19)]);
var inst_23626 = (state_23643[(2)]);
var inst_23627 = fluree.db.util.async.throw_err.call(null,inst_23626);
var inst_23628 = cljs.core.conj.call(null,inst_23580,inst_23627);
var inst_23578 = inst_23587;
var inst_23579 = inst_23612;
var inst_23580__$1 = inst_23628;
var state_23643__$1 = (function (){var statearr_23681 = state_23643;
(statearr_23681[(7)] = inst_23580__$1);

(statearr_23681[(10)] = inst_23578);

(statearr_23681[(8)] = inst_23579);

return statearr_23681;
})();
var statearr_23682_23718 = state_23643__$1;
(statearr_23682_23718[(2)] = null);

(statearr_23682_23718[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (16))){
var inst_23636 = (state_23643[(2)]);
var state_23643__$1 = state_23643;
var statearr_23683_23719 = state_23643__$1;
(statearr_23683_23719[(2)] = inst_23636);

(statearr_23683_23719[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (10))){
var inst_23598 = (state_23643[(2)]);
var state_23643__$1 = state_23643;
if(cljs.core.truth_(inst_23598)){
var statearr_23684_23720 = state_23643__$1;
(statearr_23684_23720[(1)] = (14));

} else {
var statearr_23685_23721 = state_23643__$1;
(statearr_23685_23721[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (18))){
var inst_23601 = (state_23643[(12)]);
var state_23643__$1 = state_23643;
var statearr_23686_23722 = state_23643__$1;
(statearr_23686_23722[(2)] = inst_23601);

(statearr_23686_23722[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23644 === (8))){
var inst_23588 = (state_23643[(13)]);
var state_23643__$1 = state_23643;
var statearr_23687_23723 = state_23643__$1;
(statearr_23687_23723[(2)] = inst_23588);

(statearr_23687_23723[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2879__auto__ = null;
var fluree$db$query$fql$state_machine__2879__auto____0 = (function (){
var statearr_23688 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23688[(0)] = fluree$db$query$fql$state_machine__2879__auto__);

(statearr_23688[(1)] = (1));

return statearr_23688;
});
var fluree$db$query$fql$state_machine__2879__auto____1 = (function (state_23643){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_23643);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e23689){var ex__2882__auto__ = e23689;
var statearr_23690_23724 = state_23643;
(statearr_23690_23724[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_23643[(4)]))){
var statearr_23691_23725 = state_23643;
(statearr_23691_23725[(1)] = cljs.core.first.call(null,(state_23643[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__23726 = state_23643;
state_23643 = G__23726;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2879__auto__ = function(state_23643){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2879__auto____1.call(this,state_23643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2879__auto____0;
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2879__auto____1;
return fluree$db$query$fql$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_23692 = f__2902__auto__.call(null);
(statearr_23692[(6)] = c__2901__auto__);

return statearr_23692;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4126__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"ref?","ref?",1932693720),p);
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__23728 = arguments.length;
switch (G__23728) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.call(null,db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_23916){
var state_val_23917 = (state_23916[(1)]);
if((state_val_23917 === (7))){
var state_23916__$1 = state_23916;
var statearr_23918_23989 = state_23916__$1;
(statearr_23918_23989[(2)] = null);

(statearr_23918_23989[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (20))){
var inst_23769 = (state_23916[(7)]);
var inst_23771 = (state_23916[(8)]);
var inst_23799 = (state_23916[(2)]);
var inst_23800 = fluree.db.util.async.throw_err.call(null,inst_23799);
var inst_23801 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23802 = [inst_23769];
var inst_23803 = (new cljs.core.PersistentVector(null,1,(5),inst_23801,inst_23802,null));
var inst_23804 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23805 = [inst_23769,inst_23771];
var inst_23806 = (new cljs.core.PersistentVector(null,2,(5),inst_23804,inst_23805,null));
var inst_23807 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23803,cljs.core._LT_,inst_23806);
var state_23916__$1 = (function (){var statearr_23919 = state_23916;
(statearr_23919[(9)] = inst_23800);

return statearr_23919;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23916__$1,(21),inst_23807);
} else {
if((state_val_23917 === (27))){
var inst_23788 = (state_23916[(10)]);
var inst_23770 = (state_23916[(11)]);
var inst_23836 = inst_23788.call(null,cljs.core._GT__EQ_,inst_23770);
var state_23916__$1 = state_23916;
if(cljs.core.truth_(inst_23836)){
var statearr_23920_23990 = state_23916__$1;
(statearr_23920_23990[(1)] = (30));

} else {
var statearr_23921_23991 = state_23916__$1;
(statearr_23921_23991[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (1))){
var state_23916__$1 = state_23916;
var statearr_23922_23992 = state_23916__$1;
(statearr_23922_23992[(2)] = null);

(statearr_23922_23992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (24))){
var inst_23885 = (state_23916[(2)]);
var state_23916__$1 = state_23916;
var statearr_23923_23993 = state_23916__$1;
(statearr_23923_23993[(2)] = inst_23885);

(statearr_23923_23993[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (39))){
var inst_23875 = null;
var state_23916__$1 = state_23916;
var statearr_23924_23994 = state_23916__$1;
(statearr_23924_23994[(2)] = inst_23875);

(statearr_23924_23994[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (46))){
var inst_23896 = (state_23916[(12)]);
var inst_23762 = (state_23916[(13)]);
var inst_23754 = inst_23762;
var inst_23755 = inst_23896;
var state_23916__$1 = (function (){var statearr_23925 = state_23916;
(statearr_23925[(14)] = inst_23755);

(statearr_23925[(15)] = inst_23754);

return statearr_23925;
})();
var statearr_23926_23995 = state_23916__$1;
(statearr_23926_23995[(2)] = null);

(statearr_23926_23995[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (4))){
var inst_23729 = (state_23916[(2)]);
var state_23916__$1 = state_23916;
var statearr_23927_23996 = state_23916__$1;
(statearr_23927_23996[(2)] = inst_23729);

(statearr_23927_23996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (15))){
var state_23916__$1 = state_23916;
var statearr_23928_23997 = state_23916__$1;
(statearr_23928_23997[(2)] = null);

(statearr_23928_23997[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (21))){
var inst_23800 = (state_23916[(9)]);
var inst_23809 = (state_23916[(2)]);
var inst_23810 = fluree.db.util.async.throw_err.call(null,inst_23809);
var inst_23811 = cljs.core.concat.call(null,inst_23800,inst_23810);
var state_23916__$1 = state_23916;
var statearr_23929_23998 = state_23916__$1;
(statearr_23929_23998[(2)] = inst_23811);

(statearr_23929_23998[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (31))){
var inst_23788 = (state_23916[(10)]);
var inst_23770 = (state_23916[(11)]);
var inst_23849 = inst_23788.call(null,cljs.core._LT_,inst_23770);
var state_23916__$1 = state_23916;
if(cljs.core.truth_(inst_23849)){
var statearr_23930_23999 = state_23916__$1;
(statearr_23930_23999[(1)] = (34));

} else {
var statearr_23931_24000 = state_23916__$1;
(statearr_23931_24000[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (32))){
var inst_23881 = (state_23916[(2)]);
var state_23916__$1 = state_23916;
var statearr_23932_24001 = state_23916__$1;
(statearr_23932_24001[(2)] = inst_23881);

(statearr_23932_24001[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (40))){
var inst_23877 = (state_23916[(2)]);
var state_23916__$1 = state_23916;
var statearr_23933_24002 = state_23916__$1;
(statearr_23933_24002[(2)] = inst_23877);

(statearr_23933_24002[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (33))){
var inst_23846 = (state_23916[(2)]);
var inst_23847 = fluree.db.util.async.throw_err.call(null,inst_23846);
var state_23916__$1 = state_23916;
var statearr_23934_24003 = state_23916__$1;
(statearr_23934_24003[(2)] = inst_23847);

(statearr_23934_24003[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (13))){
var inst_23906 = (state_23916[(2)]);
var state_23916__$1 = state_23916;
var statearr_23935_24004 = state_23916__$1;
(statearr_23935_24004[(2)] = inst_23906);

(statearr_23935_24004[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (22))){
var inst_23769 = (state_23916[(7)]);
var inst_23771 = (state_23916[(8)]);
var inst_23815 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23816 = [inst_23769,inst_23771];
var inst_23817 = (new cljs.core.PersistentVector(null,2,(5),inst_23815,inst_23816,null));
var inst_23818 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_23817);
var state_23916__$1 = state_23916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23916__$1,(25),inst_23818);
} else {
if((state_val_23917 === (36))){
var inst_23879 = (state_23916[(2)]);
var state_23916__$1 = state_23916;
var statearr_23936_24005 = state_23916__$1;
(statearr_23936_24005[(2)] = inst_23879);

(statearr_23936_24005[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (41))){
var inst_23872 = (state_23916[(2)]);
var inst_23873 = fluree.db.util.async.throw_err.call(null,inst_23872);
var state_23916__$1 = state_23916;
var statearr_23937_24006 = state_23916__$1;
(statearr_23937_24006[(2)] = inst_23873);

(statearr_23937_24006[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (43))){
var inst_23755 = (state_23916[(14)]);
var inst_23888 = (state_23916[(16)]);
var inst_23889 = cljs.core.into.call(null,inst_23755,inst_23888);
var state_23916__$1 = state_23916;
var statearr_23938_24007 = state_23916__$1;
(statearr_23938_24007[(2)] = inst_23889);

(statearr_23938_24007[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (29))){
var inst_23833 = (state_23916[(2)]);
var inst_23834 = fluree.db.util.async.throw_err.call(null,inst_23833);
var state_23916__$1 = state_23916;
var statearr_23939_24008 = state_23916__$1;
(statearr_23939_24008[(2)] = inst_23834);

(statearr_23939_24008[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (44))){
var inst_23755 = (state_23916[(14)]);
var inst_23888 = (state_23916[(16)]);
var inst_23891 = cljs.core.PersistentHashSet.EMPTY;
var inst_23892 = cljs.core.into.call(null,inst_23891,inst_23888);
var inst_23893 = clojure.set.intersection.call(null,inst_23755,inst_23892);
var state_23916__$1 = state_23916;
var statearr_23940_24009 = state_23916__$1;
(statearr_23940_24009[(2)] = inst_23893);

(statearr_23940_24009[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (6))){
var inst_23740 = (state_23916[(17)]);
var inst_23750 = cljs.core.seq.call(null,inst_23740);
var inst_23751 = cljs.core.first.call(null,inst_23750);
var inst_23752 = cljs.core.next.call(null,inst_23750);
var inst_23753 = cljs.core.PersistentHashSet.EMPTY;
var inst_23754 = inst_23740;
var inst_23755 = inst_23753;
var state_23916__$1 = (function (){var statearr_23941 = state_23916;
(statearr_23941[(14)] = inst_23755);

(statearr_23941[(15)] = inst_23754);

(statearr_23941[(18)] = inst_23751);

(statearr_23941[(19)] = inst_23752);

return statearr_23941;
})();
var statearr_23942_24010 = state_23916__$1;
(statearr_23942_24010[(2)] = null);

(statearr_23942_24010[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (28))){
var inst_23883 = (state_23916[(2)]);
var state_23916__$1 = state_23916;
var statearr_23943_24011 = state_23916__$1;
(statearr_23943_24011[(2)] = inst_23883);

(statearr_23943_24011[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (25))){
var inst_23820 = (state_23916[(2)]);
var inst_23821 = fluree.db.util.async.throw_err.call(null,inst_23820);
var state_23916__$1 = state_23916;
var statearr_23944_24012 = state_23916__$1;
(statearr_23944_24012[(2)] = inst_23821);

(statearr_23944_24012[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (34))){
var inst_23769 = (state_23916[(7)]);
var inst_23771 = (state_23916[(8)]);
var inst_23851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23852 = [inst_23769];
var inst_23853 = (new cljs.core.PersistentVector(null,1,(5),inst_23851,inst_23852,null));
var inst_23854 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23855 = [inst_23769,inst_23771];
var inst_23856 = (new cljs.core.PersistentVector(null,2,(5),inst_23854,inst_23855,null));
var inst_23857 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23853,cljs.core._LT_,inst_23856);
var state_23916__$1 = state_23916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23916__$1,(37),inst_23857);
} else {
if((state_val_23917 === (17))){
var inst_23769 = (state_23916[(7)]);
var inst_23771 = (state_23916[(8)]);
var inst_23791 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23792 = [inst_23769,inst_23771];
var inst_23793 = (new cljs.core.PersistentVector(null,2,(5),inst_23791,inst_23792,null));
var inst_23794 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23795 = [inst_23769];
var inst_23796 = (new cljs.core.PersistentVector(null,1,(5),inst_23794,inst_23795,null));
var inst_23797 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_23793,cljs.core._LT__EQ_,inst_23796);
var state_23916__$1 = state_23916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23916__$1,(20),inst_23797);
} else {
if((state_val_23917 === (3))){
var inst_23914 = (state_23916[(2)]);
var state_23916__$1 = state_23916;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_23916__$1,inst_23914);
} else {
if((state_val_23917 === (12))){
var inst_23769 = (state_23916[(7)]);
var inst_23761 = (state_23916[(20)]);
var inst_23769__$1 = cljs.core.nth.call(null,inst_23761,(0),null);
var inst_23770 = cljs.core.nth.call(null,inst_23761,(1),null);
var inst_23771 = cljs.core.nth.call(null,inst_23761,(2),null);
var inst_23772 = fluree.db.query.fql.valid_where_predicate_QMARK_.call(null,db,inst_23769__$1);
var inst_23773 = cljs.core.not.call(null,inst_23772);
var state_23916__$1 = (function (){var statearr_23945 = state_23916;
(statearr_23945[(7)] = inst_23769__$1);

(statearr_23945[(8)] = inst_23771);

(statearr_23945[(11)] = inst_23770);

return statearr_23945;
})();
if(inst_23773){
var statearr_23946_24013 = state_23916__$1;
(statearr_23946_24013[(1)] = (14));

} else {
var statearr_23947_24014 = state_23916__$1;
(statearr_23947_24014[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (2))){
var inst_23740 = (state_23916[(17)]);
var _ = (function (){var statearr_23948 = state_23916;
(statearr_23948[(4)] = cljs.core.cons.call(null,(5),(state_23916[(4)])));

return statearr_23948;
})();
var inst_23738 = fluree.db.query.fql_parser.parse_where.call(null,db,where_clause,default_collection);
var inst_23739 = cljs.core.nth.call(null,inst_23738,(0),null);
var inst_23740__$1 = cljs.core.nth.call(null,inst_23738,(1),null);
var inst_23741 = cljs.core.not_empty.call(null,inst_23740__$1);
var state_23916__$1 = (function (){var statearr_23949 = state_23916;
(statearr_23949[(21)] = inst_23739);

(statearr_23949[(17)] = inst_23740__$1);

return statearr_23949;
})();
if(cljs.core.truth_(inst_23741)){
var statearr_23950_24015 = state_23916__$1;
(statearr_23950_24015[(1)] = (6));

} else {
var statearr_23951_24016 = state_23916__$1;
(statearr_23951_24016[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (23))){
var inst_23788 = (state_23916[(10)]);
var inst_23770 = (state_23916[(11)]);
var inst_23823 = inst_23788.call(null,cljs.core._GT_,inst_23770);
var state_23916__$1 = state_23916;
if(cljs.core.truth_(inst_23823)){
var statearr_23952_24017 = state_23916__$1;
(statearr_23952_24017[(1)] = (26));

} else {
var statearr_23953_24018 = state_23916__$1;
(statearr_23953_24018[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (47))){
var inst_23904 = (state_23916[(2)]);
var state_23916__$1 = state_23916;
var statearr_23954_24019 = state_23916__$1;
(statearr_23954_24019[(2)] = inst_23904);

(statearr_23954_24019[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (35))){
var inst_23788 = (state_23916[(10)]);
var inst_23770 = (state_23916[(11)]);
var inst_23862 = inst_23788.call(null,cljs.core._LT__EQ_,inst_23770);
var state_23916__$1 = state_23916;
if(cljs.core.truth_(inst_23862)){
var statearr_23955_24020 = state_23916__$1;
(statearr_23955_24020[(1)] = (38));

} else {
var statearr_23956_24021 = state_23916__$1;
(statearr_23956_24021[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (19))){
var inst_23739 = (state_23916[(21)]);
var inst_23887 = (state_23916[(2)]);
var inst_23888 = cljs.core.map.call(null,fluree.db.query.fql.s,inst_23887);
var state_23916__$1 = (function (){var statearr_23957 = state_23916;
(statearr_23957[(16)] = inst_23888);

return statearr_23957;
})();
var G__23958_24022 = inst_23739;
var G__23958_24023__$1 = (((G__23958_24022 instanceof cljs.core.Keyword))?G__23958_24022.fqn:null);
switch (G__23958_24023__$1) {
case "or":
var statearr_23959_24025 = state_23916__$1;
(statearr_23959_24025[(1)] = (43));


break;
case "and":
var statearr_23960_24026 = state_23916__$1;
(statearr_23960_24026[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__23958_24023__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (11))){
var inst_23755 = (state_23916[(14)]);
var state_23916__$1 = state_23916;
var statearr_23962_24027 = state_23916__$1;
(statearr_23962_24027[(2)] = inst_23755);

(statearr_23962_24027[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (9))){
var inst_23761 = (state_23916[(20)]);
var inst_23754 = (state_23916[(15)]);
var inst_23760 = cljs.core.seq.call(null,inst_23754);
var inst_23761__$1 = cljs.core.first.call(null,inst_23760);
var inst_23762 = cljs.core.next.call(null,inst_23760);
var inst_23763 = cljs.core.not.call(null,inst_23761__$1);
var state_23916__$1 = (function (){var statearr_23963 = state_23916;
(statearr_23963[(20)] = inst_23761__$1);

(statearr_23963[(13)] = inst_23762);

return statearr_23963;
})();
if(inst_23763){
var statearr_23964_24028 = state_23916__$1;
(statearr_23964_24028[(1)] = (11));

} else {
var statearr_23965_24029 = state_23916__$1;
(statearr_23965_24029[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (5))){
var _ = (function (){var statearr_23966 = state_23916;
(statearr_23966[(4)] = cljs.core.rest.call(null,(state_23916[(4)])));

return statearr_23966;
})();
var state_23916__$1 = state_23916;
var ex23961 = (state_23916__$1[(2)]);
var statearr_23967_24030 = state_23916__$1;
(statearr_23967_24030[(5)] = ex23961);


if((ex23961 instanceof Error)){
var statearr_23968_24031 = state_23916__$1;
(statearr_23968_24031[(1)] = (4));

(statearr_23968_24031[(5)] = null);

} else {
throw ex23961;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (14))){
var inst_23769 = (state_23916[(7)]);
var inst_23775 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_23769);
var inst_23776 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_23775)].join('');
var inst_23777 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_23778 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_23779 = cljs.core.PersistentHashMap.fromArrays(inst_23777,inst_23778);
var inst_23780 = cljs.core.ex_info.call(null,inst_23776,inst_23779);
var inst_23781 = (function(){throw inst_23780})();
var state_23916__$1 = state_23916;
var statearr_23969_24032 = state_23916__$1;
(statearr_23969_24032[(2)] = inst_23781);

(statearr_23969_24032[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (45))){
var inst_23896 = (state_23916[(12)]);
var state_23916__$1 = state_23916;
var statearr_23970_24033 = state_23916__$1;
(statearr_23970_24033[(2)] = inst_23896);

(statearr_23970_24033[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (26))){
var inst_23769 = (state_23916[(7)]);
var inst_23771 = (state_23916[(8)]);
var inst_23825 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23826 = [inst_23769,inst_23771];
var inst_23827 = (new cljs.core.PersistentVector(null,2,(5),inst_23825,inst_23826,null));
var inst_23828 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23829 = [inst_23769];
var inst_23830 = (new cljs.core.PersistentVector(null,1,(5),inst_23828,inst_23829,null));
var inst_23831 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT_,inst_23827,cljs.core._LT__EQ_,inst_23830);
var state_23916__$1 = state_23916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23916__$1,(29),inst_23831);
} else {
if((state_val_23917 === (16))){
var inst_23788 = (state_23916[(10)]);
var inst_23770 = (state_23916[(11)]);
var inst_23784 = (state_23916[(2)]);
var inst_23788__$1 = cljs.core.identical_QMARK_;
var inst_23789 = inst_23788__$1.call(null,cljs.core.not_EQ_,inst_23770);
var state_23916__$1 = (function (){var statearr_23971 = state_23916;
(statearr_23971[(22)] = inst_23784);

(statearr_23971[(10)] = inst_23788__$1);

return statearr_23971;
})();
if(cljs.core.truth_(inst_23789)){
var statearr_23972_24034 = state_23916__$1;
(statearr_23972_24034[(1)] = (17));

} else {
var statearr_23973_24035 = state_23916__$1;
(statearr_23973_24035[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (38))){
var inst_23769 = (state_23916[(7)]);
var inst_23771 = (state_23916[(8)]);
var inst_23864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23865 = [inst_23769];
var inst_23866 = (new cljs.core.PersistentVector(null,1,(5),inst_23864,inst_23865,null));
var inst_23867 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23868 = [inst_23769,inst_23771];
var inst_23869 = (new cljs.core.PersistentVector(null,2,(5),inst_23867,inst_23868,null));
var inst_23870 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23866,cljs.core._LT__EQ_,inst_23869);
var state_23916__$1 = state_23916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23916__$1,(41),inst_23870);
} else {
if((state_val_23917 === (30))){
var inst_23769 = (state_23916[(7)]);
var inst_23771 = (state_23916[(8)]);
var inst_23838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23839 = [inst_23769,inst_23771];
var inst_23840 = (new cljs.core.PersistentVector(null,2,(5),inst_23838,inst_23839,null));
var inst_23841 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_23842 = [inst_23769];
var inst_23843 = (new cljs.core.PersistentVector(null,1,(5),inst_23841,inst_23842,null));
var inst_23844 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._GT__EQ_,inst_23840,cljs.core._LT__EQ_,inst_23843);
var state_23916__$1 = state_23916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_23916__$1,(33),inst_23844);
} else {
if((state_val_23917 === (10))){
var inst_23908 = (state_23916[(2)]);
var state_23916__$1 = state_23916;
var statearr_23974_24036 = state_23916__$1;
(statearr_23974_24036[(2)] = inst_23908);

(statearr_23974_24036[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (18))){
var inst_23788 = (state_23916[(10)]);
var inst_23770 = (state_23916[(11)]);
var inst_23813 = inst_23788.call(null,cljs.core._EQ_,inst_23770);
var state_23916__$1 = state_23916;
if(cljs.core.truth_(inst_23813)){
var statearr_23975_24037 = state_23916__$1;
(statearr_23975_24037[(1)] = (22));

} else {
var statearr_23976_24038 = state_23916__$1;
(statearr_23976_24038[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (42))){
var inst_23739 = (state_23916[(21)]);
var inst_23896 = (state_23916[(12)]);
var inst_23896__$1 = (state_23916[(2)]);
var inst_23897 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"and","and",-971899817),inst_23739);
var inst_23898 = cljs.core.empty_QMARK_.call(null,inst_23896__$1);
var inst_23899 = ((inst_23897) && (inst_23898));
var state_23916__$1 = (function (){var statearr_23977 = state_23916;
(statearr_23977[(12)] = inst_23896__$1);

return statearr_23977;
})();
if(cljs.core.truth_(inst_23899)){
var statearr_23978_24039 = state_23916__$1;
(statearr_23978_24039[(1)] = (45));

} else {
var statearr_23979_24040 = state_23916__$1;
(statearr_23979_24040[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (37))){
var inst_23859 = (state_23916[(2)]);
var inst_23860 = fluree.db.util.async.throw_err.call(null,inst_23859);
var state_23916__$1 = state_23916;
var statearr_23980_24041 = state_23916__$1;
(statearr_23980_24041[(2)] = inst_23860);

(statearr_23980_24041[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_23917 === (8))){
var inst_23911 = (state_23916[(2)]);
var _ = (function (){var statearr_23981 = state_23916;
(statearr_23981[(4)] = cljs.core.rest.call(null,(state_23916[(4)])));

return statearr_23981;
})();
var state_23916__$1 = state_23916;
var statearr_23982_24042 = state_23916__$1;
(statearr_23982_24042[(2)] = inst_23911);

(statearr_23982_24042[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2879__auto__ = null;
var fluree$db$query$fql$state_machine__2879__auto____0 = (function (){
var statearr_23983 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23983[(0)] = fluree$db$query$fql$state_machine__2879__auto__);

(statearr_23983[(1)] = (1));

return statearr_23983;
});
var fluree$db$query$fql$state_machine__2879__auto____1 = (function (state_23916){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_23916);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e23984){var ex__2882__auto__ = e23984;
var statearr_23985_24043 = state_23916;
(statearr_23985_24043[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_23916[(4)]))){
var statearr_23986_24044 = state_23916;
(statearr_23986_24044[(1)] = cljs.core.first.call(null,(state_23916[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24045 = state_23916;
state_23916 = G__24045;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2879__auto__ = function(state_23916){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2879__auto____1.call(this,state_23916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2879__auto____0;
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2879__auto____1;
return fluree$db$query$fql$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_23987 = f__2902__auto__.call(null);
(statearr_23987[(6)] = c__2901__auto__);

return statearr_23987;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

/**
 * Order By can be:
 *  - Single variable, ?favNums
 *  - Two-tuple,  [ASC, ?favNums]
 */
fluree.db.query.fql.order_offset_and_limit_results = (function fluree$db$query$fql$order_offset_and_limit_results(tuples,headers,orderBy,offset,limit){
var vec__24047 = orderBy;
var order = cljs.core.nth.call(null,vec__24047,(0),null);
var var$ = cljs.core.nth.call(null,vec__24047,(1),null);
var indexOfFind = (function (){var or__4126__auto__ = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,var$));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (-1);
}
})();
var tuples_SINGLEQUOTE_ = ((((0) <= indexOfFind))?(function (){var G__24050 = cljs.core.sort_by.call(null,(function (p1__24046_SHARP_){
return cljs.core.nth.call(null,p1__24046_SHARP_,indexOfFind);
}),fluree.db.query.fql.compare_fn,tuples);
if(cljs.core._EQ_.call(null,"DESC",order)){
return cljs.core.reverse.call(null,G__24050);
} else {
return G__24050;
}
})():tuples);
var G__24051 = tuples_SINGLEQUOTE_;
var G__24051__$1 = (cljs.core.truth_(offset)?cljs.core.drop.call(null,offset,G__24051):G__24051);
var G__24051__$2 = (cljs.core.truth_(limit)?cljs.core.take.call(null,limit,G__24051__$1):G__24051__$1);
if(cljs.core.vector_QMARK_.call(null,tuples)){
return cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,G__24051__$2);
} else {
return G__24051__$2;
}
});
fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,cljs.core.keys.call(null,x))))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
var var_as_symbol = cljs.core.symbol.call(null,cljs.core.first.call(null,cljs.core.keys.call(null,x)));
var ___$1 = (cljs.core.truth_(valid_var.call(null,var_as_symbol))?null:(function(){throw cljs.core.ex_info.call(null,["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_as_symbol,new cljs.core.Keyword(null,"selection","selection",975998651),cljs.core.first.call(null,cljs.core.vals.call(null,x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4126__auto__ = cljs.core.every_QMARK_.call(null,(function (p1__24052_SHARP_){
return ((typeof p1__24052_SHARP_ === 'string') || (cljs.core.map_QMARK_.call(null,p1__24052_SHARP_)));
}),select_smt);
if(or__4126__auto__){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
})();
var vars__$1 = cljs.core.set.call(null,vars);
var all_vars = cljs.core.set.call(null,cljs.core.concat.call(null,vars__$1,cljs.core.keys.call(null,interim_vars)));
return cljs.core.map.call(null,(function (select){
var var_symbol = ((cljs.core.map_QMARK_.call(null,select))?null:cljs.core.symbol.call(null,select));
if(cljs.core.truth_(vars__$1.call(null,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"variable","variable",-281346492),var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_.call(null,select))){
return fluree.db.query.analytical.parse_aggregate.call(null,select,vars__$1);
} else {
if(cljs.core.map_QMARK_.call(null,select)){
return fluree.db.query.fql.parse_map.call(null,select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.call(null,interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),cljs.core.get.call(null,interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.call(null,["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.call(null,(function (select__$1){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies.call(null,vars);
if(cljs.core.every_QMARK_.call(null,(function (p1__24053_SHARP_){
return cljs.core._EQ_.call(null,(1),p1__24053_SHARP_);
}),cljs.core.vals.call(null,freqs))){
return vars;
} else {
var G__24057 = vars;
var vec__24058 = G__24057;
var seq__24059 = cljs.core.seq.call(null,vec__24058);
var first__24060 = cljs.core.first.call(null,seq__24059);
var seq__24059__$1 = cljs.core.next.call(null,seq__24059);
var var$ = first__24060;
var r = seq__24059__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__24057__$1 = G__24057;
var all_vars__$1 = all_vars;
while(true){
var vec__24064 = G__24057__$1;
var seq__24065 = cljs.core.seq.call(null,vec__24064);
var first__24066 = cljs.core.first.call(null,seq__24065);
var seq__24065__$1 = cljs.core.next.call(null,seq__24065);
var var$__$1 = first__24066;
var r__$1 = seq__24065__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not.call(null,var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_(cljs.core.set.call(null,all_vars__$2).call(null,var$__$1))){
var G__24067 = r__$1;
var G__24068 = cljs.core.conj.call(null,all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,all_vars__$2))].join(''));
G__24057__$1 = G__24067;
all_vars__$1 = G__24068;
continue;
} else {
var G__24069 = r__$1;
var G__24070 = cljs.core.conj.call(null,all_vars__$2,var$__$1);
G__24057__$1 = G__24069;
all_vars__$1 = G__24070;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_24105){
var state_val_24106 = (state_24105[(1)]);
if((state_val_24106 === (1))){
var inst_24078 = functionArray;
var inst_24079 = cljs.core.seq.call(null,inst_24078);
var inst_24080 = cljs.core.first.call(null,inst_24079);
var inst_24081 = cljs.core.next.call(null,inst_24079);
var inst_24082 = cljs.core.PersistentVector.EMPTY;
var inst_24083 = inst_24078;
var inst_24084 = inst_24082;
var state_24105__$1 = (function (){var statearr_24107 = state_24105;
(statearr_24107[(7)] = inst_24083);

(statearr_24107[(8)] = inst_24084);

(statearr_24107[(9)] = inst_24081);

(statearr_24107[(10)] = inst_24080);

return statearr_24107;
})();
var statearr_24108_24121 = state_24105__$1;
(statearr_24108_24121[(2)] = null);

(statearr_24108_24121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24106 === (2))){
var inst_24083 = (state_24105[(7)]);
var inst_24090 = (state_24105[(11)]);
var inst_24089 = cljs.core.seq.call(null,inst_24083);
var inst_24090__$1 = cljs.core.first.call(null,inst_24089);
var inst_24091 = cljs.core.next.call(null,inst_24089);
var state_24105__$1 = (function (){var statearr_24109 = state_24105;
(statearr_24109[(12)] = inst_24091);

(statearr_24109[(11)] = inst_24090__$1);

return statearr_24109;
})();
if(cljs.core.truth_(inst_24090__$1)){
var statearr_24110_24122 = state_24105__$1;
(statearr_24110_24122[(1)] = (4));

} else {
var statearr_24111_24123 = state_24105__$1;
(statearr_24111_24123[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24106 === (3))){
var inst_24103 = (state_24105[(2)]);
var state_24105__$1 = state_24105;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24105__$1,inst_24103);
} else {
if((state_val_24106 === (4))){
var inst_24090 = (state_24105[(11)]);
var inst_24093 = inst_24090.call(null,tuple);
var state_24105__$1 = state_24105;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24105__$1,(7),inst_24093);
} else {
if((state_val_24106 === (5))){
var inst_24084 = (state_24105[(8)]);
var state_24105__$1 = state_24105;
var statearr_24112_24124 = state_24105__$1;
(statearr_24112_24124[(2)] = inst_24084);

(statearr_24112_24124[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24106 === (6))){
var inst_24101 = (state_24105[(2)]);
var state_24105__$1 = state_24105;
var statearr_24113_24125 = state_24105__$1;
(statearr_24113_24125[(2)] = inst_24101);

(statearr_24113_24125[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24106 === (7))){
var inst_24084 = (state_24105[(8)]);
var inst_24091 = (state_24105[(12)]);
var inst_24095 = (state_24105[(2)]);
var inst_24096 = fluree.db.util.async.throw_err.call(null,inst_24095);
var inst_24097 = cljs.core.conj.call(null,inst_24084,inst_24096);
var inst_24083 = inst_24091;
var inst_24084__$1 = inst_24097;
var state_24105__$1 = (function (){var statearr_24114 = state_24105;
(statearr_24114[(7)] = inst_24083);

(statearr_24114[(8)] = inst_24084__$1);

return statearr_24114;
})();
var statearr_24115_24126 = state_24105__$1;
(statearr_24115_24126[(2)] = null);

(statearr_24115_24126[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__2879__auto____0 = (function (){
var statearr_24116 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24116[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__2879__auto__);

(statearr_24116[(1)] = (1));

return statearr_24116;
});
var fluree$db$query$fql$format_tuple_$_state_machine__2879__auto____1 = (function (state_24105){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_24105);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e24117){var ex__2882__auto__ = e24117;
var statearr_24118_24127 = state_24105;
(statearr_24118_24127[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_24105[(4)]))){
var statearr_24119_24128 = state_24105;
(statearr_24119_24128[(1)] = cljs.core.first.call(null,(state_24105[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24129 = state_24105;
state_24105 = G__24129;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__2879__auto__ = function(state_24105){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__2879__auto____1.call(this,state_24105);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__2879__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__2879__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_24120 = f__2902__auto__.call(null);
(statearr_24120[(6)] = c__2901__auto__);

return statearr_24120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,cljs.core.map.call(null,cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"code","code",1586293142).cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of.call(null,headers,new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 * 
 *   TODO - this uses a 'functionArray' of pre-defined functions that take a single tuple argument
 *     - I think this could be done more cleanly and possibly efficiently, so refactor another day.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(tuples,functionArray,inVector_QMARK_,pretty_print,parallelism){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_24171){
var state_val_24172 = (state_24171[(1)]);
if((state_val_24172 === (7))){
var inst_24166 = (state_24171[(2)]);
var _ = (function (){var statearr_24173 = state_24171;
(statearr_24173[(4)] = cljs.core.rest.call(null,(state_24171[(4)])));

return statearr_24173;
})();
var state_24171__$1 = state_24171;
var statearr_24174_24255 = state_24171__$1;
(statearr_24174_24255[(2)] = inst_24166);

(statearr_24174_24255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24172 === (1))){
var state_24171__$1 = state_24171;
var statearr_24175_24256 = state_24171__$1;
(statearr_24175_24256[(2)] = null);

(statearr_24175_24256[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24172 === (4))){
var inst_24130 = (state_24171[(2)]);
var state_24171__$1 = state_24171;
var statearr_24176_24257 = state_24171__$1;
(statearr_24176_24257[(2)] = inst_24130);

(statearr_24176_24257[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24172 === (15))){
var inst_24142 = (state_24171[(7)]);
var inst_24145 = (state_24171[(8)]);
var inst_24156 = cljs.core.conj.call(null,inst_24142,inst_24145);
var inst_24142__$1 = inst_24156;
var state_24171__$1 = (function (){var statearr_24177 = state_24171;
(statearr_24177[(7)] = inst_24142__$1);

return statearr_24177;
})();
var statearr_24178_24258 = state_24171__$1;
(statearr_24178_24258[(2)] = null);

(statearr_24178_24258[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24172 === (13))){
var state_24171__$1 = state_24171;
var statearr_24179_24259 = state_24171__$1;
(statearr_24179_24259[(1)] = (15));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24172 === (6))){
var inst_24137 = (state_24171[(9)]);
var state_24171__$1 = state_24171;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24171__$1,(8),inst_24137);
} else {
if((state_val_24172 === (17))){
var inst_24160 = (state_24171[(2)]);
var state_24171__$1 = state_24171;
var statearr_24181_24260 = state_24171__$1;
(statearr_24181_24260[(2)] = inst_24160);

(statearr_24181_24260[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24172 === (3))){
var inst_24169 = (state_24171[(2)]);
var state_24171__$1 = state_24171;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24171__$1,inst_24169);
} else {
if((state_val_24172 === (12))){
var inst_24137 = (state_24171[(9)]);
var inst_24145 = (state_24171[(8)]);
var inst_24136 = (state_24171[(10)]);
var inst_24151 = cljs.core.async.close_BANG_.call(null,inst_24136);
var inst_24152 = cljs.core.async.close_BANG_.call(null,inst_24137);
var inst_24153 = (function(){throw inst_24145})();
var state_24171__$1 = (function (){var statearr_24182 = state_24171;
(statearr_24182[(11)] = inst_24152);

(statearr_24182[(12)] = inst_24151);

return statearr_24182;
})();
var statearr_24183_24261 = state_24171__$1;
(statearr_24183_24261[(2)] = inst_24153);

(statearr_24183_24261[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24172 === (2))){
var inst_24137 = (state_24171[(9)]);
var inst_24136 = (state_24171[(10)]);
var _ = (function (){var statearr_24184 = state_24171;
(statearr_24184[(4)] = cljs.core.cons.call(null,(5),(state_24171[(4)])));

return statearr_24184;
})();
var inst_24136__$1 = cljs.core.async.chan.call(null);
var inst_24137__$1 = cljs.core.async.chan.call(null);
var inst_24138 = (function (){var queue_ch = inst_24136__$1;
var res_ch = inst_24137__$1;
return (function (tuple,port){
var c__2901__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_24210){
var state_val_24211 = (state_24210[(1)]);
if((state_val_24211 === (7))){
var state_24210__$1 = state_24210;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24212_24262 = state_24210__$1;
(statearr_24212_24262[(1)] = (9));

} else {
var statearr_24213_24263 = state_24210__$1;
(statearr_24213_24263[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (1))){
var inst_24185 = fluree.db.query.fql.format_tuple.call(null,functionArray,tuple);
var state_24210__$1 = state_24210;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24210__$1,(2),inst_24185);
} else {
if((state_val_24211 === (4))){
var state_24210__$1 = state_24210;
if(cljs.core.truth_(pretty_print)){
var statearr_24214_24264 = state_24210__$1;
(statearr_24214_24264[(1)] = (6));

} else {
var statearr_24215_24265 = state_24210__$1;
(statearr_24215_24265[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (13))){
var state_24210__$1 = state_24210;
var statearr_24216_24266 = state_24210__$1;
(statearr_24216_24266[(2)] = null);

(statearr_24216_24266[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (6))){
var inst_24187 = (state_24210[(7)]);
var inst_24192 = cljs.core.zipmap.call(null,pretty_print,inst_24187);
var state_24210__$1 = state_24210;
var statearr_24217_24267 = state_24210__$1;
(statearr_24217_24267[(2)] = inst_24192);

(statearr_24217_24267[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (3))){
var inst_24187 = (state_24210[(7)]);
var state_24210__$1 = state_24210;
var statearr_24218_24268 = state_24210__$1;
(statearr_24218_24268[(2)] = inst_24187);

(statearr_24218_24268[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (12))){
var inst_24187 = (state_24210[(7)]);
var inst_24197 = cljs.core.first.call(null,inst_24187);
var state_24210__$1 = state_24210;
var statearr_24219_24269 = state_24210__$1;
(statearr_24219_24269[(2)] = inst_24197);

(statearr_24219_24269[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (2))){
var inst_24187 = (state_24210[(7)]);
var inst_24187__$1 = (state_24210[(2)]);
var inst_24188 = fluree.db.util.core.exception_QMARK_.call(null,inst_24187__$1);
var state_24210__$1 = (function (){var statearr_24220 = state_24210;
(statearr_24220[(7)] = inst_24187__$1);

return statearr_24220;
})();
if(inst_24188){
var statearr_24221_24270 = state_24210__$1;
(statearr_24221_24270[(1)] = (3));

} else {
var statearr_24222_24271 = state_24210__$1;
(statearr_24222_24271[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (11))){
var inst_24202 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
var statearr_24223_24272 = state_24210__$1;
(statearr_24223_24272[(2)] = inst_24202);

(statearr_24223_24272[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (9))){
var inst_24187 = (state_24210[(7)]);
var state_24210__$1 = state_24210;
var statearr_24224_24273 = state_24210__$1;
(statearr_24224_24273[(2)] = inst_24187);

(statearr_24224_24273[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (5))){
var inst_24206 = (state_24210[(2)]);
var inst_24207 = cljs.core.async.put_BANG_.call(null,port,inst_24206);
var inst_24208 = cljs.core.async.close_BANG_.call(null,port);
var state_24210__$1 = (function (){var statearr_24225 = state_24210;
(statearr_24225[(8)] = inst_24207);

return statearr_24225;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24210__$1,inst_24208);
} else {
if((state_val_24211 === (14))){
var inst_24200 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
var statearr_24226_24274 = state_24210__$1;
(statearr_24226_24274[(2)] = inst_24200);

(statearr_24226_24274[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (10))){
var state_24210__$1 = state_24210;
var statearr_24227_24275 = state_24210__$1;
(statearr_24227_24275[(1)] = (12));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24211 === (8))){
var inst_24204 = (state_24210[(2)]);
var state_24210__$1 = state_24210;
var statearr_24229_24276 = state_24210__$1;
(statearr_24229_24276[(2)] = inst_24204);

(statearr_24229_24276[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____0 = (function (){
var statearr_24230 = [null,null,null,null,null,null,null,null,null];
(statearr_24230[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__);

(statearr_24230[(1)] = (1));

return statearr_24230;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____1 = (function (state_24210){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_24210);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e24231){var ex__2882__auto__ = e24231;
var statearr_24232_24277 = state_24210;
(statearr_24232_24277[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_24210[(4)]))){
var statearr_24233_24278 = state_24210;
(statearr_24233_24278[(1)] = cljs.core.first.call(null,(state_24210[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24279 = state_24210;
state_24210 = G__24279;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__ = function(state_24210){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____1.call(this,state_24210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_24234 = f__2902__auto__.call(null);
(statearr_24234[(6)] = c__2901__auto____$1);

return statearr_24234;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto____$1;
});
})();
var inst_24139 = cljs.core.async.onto_chan_BANG_.call(null,inst_24136__$1,tuples);
var inst_24140 = cljs.core.async.pipeline_async.call(null,parallelism,inst_24137__$1,inst_24138,inst_24136__$1);
var inst_24141 = cljs.core.PersistentVector.EMPTY;
var inst_24142 = inst_24141;
var state_24171__$1 = (function (){var statearr_24235 = state_24171;
(statearr_24235[(9)] = inst_24137__$1);

(statearr_24235[(7)] = inst_24142);

(statearr_24235[(13)] = inst_24139);

(statearr_24235[(14)] = inst_24140);

(statearr_24235[(10)] = inst_24136__$1);

return statearr_24235;
})();
var statearr_24236_24280 = state_24171__$1;
(statearr_24236_24280[(2)] = null);

(statearr_24236_24280[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24172 === (11))){
var inst_24164 = (state_24171[(2)]);
var state_24171__$1 = state_24171;
var statearr_24238_24281 = state_24171__$1;
(statearr_24238_24281[(2)] = inst_24164);

(statearr_24238_24281[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24172 === (9))){
var inst_24142 = (state_24171[(7)]);
var state_24171__$1 = state_24171;
var statearr_24239_24282 = state_24171__$1;
(statearr_24239_24282[(2)] = inst_24142);

(statearr_24239_24282[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24172 === (5))){
var _ = (function (){var statearr_24240 = state_24171;
(statearr_24240[(4)] = cljs.core.rest.call(null,(state_24171[(4)])));

return statearr_24240;
})();
var state_24171__$1 = state_24171;
var ex24237 = (state_24171__$1[(2)]);
var statearr_24241_24283 = state_24171__$1;
(statearr_24241_24283[(5)] = ex24237);


if((ex24237 instanceof Error)){
var statearr_24242_24284 = state_24171__$1;
(statearr_24242_24284[(1)] = (4));

(statearr_24242_24284[(5)] = null);

} else {
throw ex24237;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24172 === (14))){
var inst_24162 = (state_24171[(2)]);
var state_24171__$1 = state_24171;
var statearr_24243_24285 = state_24171__$1;
(statearr_24243_24285[(2)] = inst_24162);

(statearr_24243_24285[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24172 === (16))){
var state_24171__$1 = state_24171;
var statearr_24244_24286 = state_24171__$1;
(statearr_24244_24286[(2)] = null);

(statearr_24244_24286[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24172 === (10))){
var inst_24145 = (state_24171[(8)]);
var inst_24149 = fluree.db.util.core.exception_QMARK_.call(null,inst_24145);
var state_24171__$1 = state_24171;
if(inst_24149){
var statearr_24245_24287 = state_24171__$1;
(statearr_24245_24287[(1)] = (12));

} else {
var statearr_24246_24288 = state_24171__$1;
(statearr_24246_24288[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24172 === (8))){
var inst_24145 = (state_24171[(8)]);
var inst_24145__$1 = (state_24171[(2)]);
var inst_24146 = (inst_24145__$1 == null);
var state_24171__$1 = (function (){var statearr_24247 = state_24171;
(statearr_24247[(8)] = inst_24145__$1);

return statearr_24247;
})();
if(cljs.core.truth_(inst_24146)){
var statearr_24248_24289 = state_24171__$1;
(statearr_24248_24289[(1)] = (9));

} else {
var statearr_24249_24290 = state_24171__$1;
(statearr_24249_24290[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____0 = (function (){
var statearr_24250 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24250[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__);

(statearr_24250[(1)] = (1));

return statearr_24250;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____1 = (function (state_24171){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_24171);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e24251){var ex__2882__auto__ = e24251;
var statearr_24252_24291 = state_24171;
(statearr_24252_24291[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_24171[(4)]))){
var statearr_24253_24292 = state_24171;
(statearr_24253_24292[(1)] = cljs.core.first.call(null,(state_24171[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24293 = state_24171;
state_24171 = G__24293;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__ = function(state_24171){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____1.call(this,state_24171);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_24254 = f__2902__auto__.call(null);
(statearr_24254[(6)] = c__2901__auto__);

return statearr_24254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.fql.format_filter_tuples = (function fluree$db$query$fql$format_filter_tuples(db,tuples,p__24295,headers,vars,opts){
var map__24296 = p__24295;
var map__24296__$1 = (((((!((map__24296 == null))))?(((((map__24296.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24296.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24296):map__24296);
var select_spec = map__24296__$1;
var prettyPrint = cljs.core.get.call(null,map__24296__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var select = cljs.core.get.call(null,map__24296__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var inVector_QMARK_ = cljs.core.get.call(null,map__24296__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var expandMaps_QMARK_ = cljs.core.get.call(null,map__24296__$1,new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444));
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_24331){
var state_val_24332 = (state_24331[(1)]);
if((state_val_24332 === (7))){
var state_24331__$1 = state_24331;
var statearr_24333_24444 = state_24331__$1;
(statearr_24333_24444[(2)] = null);

(statearr_24333_24444[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (1))){
var state_24331__$1 = state_24331;
var statearr_24334_24445 = state_24331__$1;
(statearr_24334_24445[(2)] = null);

(statearr_24334_24445[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (4))){
var inst_24298 = (state_24331[(2)]);
var state_24331__$1 = state_24331;
var statearr_24335_24446 = state_24331__$1;
(statearr_24335_24446[(2)] = inst_24298);

(statearr_24335_24446[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (15))){
var inst_24320 = (state_24331[(2)]);
var inst_24321 = fluree.db.util.async.throw_err.call(null,inst_24320);
var state_24331__$1 = state_24331;
var statearr_24336_24447 = state_24331__$1;
(statearr_24336_24447[(2)] = inst_24321);

(statearr_24336_24447[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (13))){
var inst_24308 = (state_24331[(7)]);
var inst_24316 = (state_24331[(8)]);
var inst_24323 = (function (){var pp = inst_24308;
var functionArray = inst_24316;
return (function (tuple){
var tuple_res = cljs.core.map.call(null,(function (p1__24294_SHARP_){
return p1__24294_SHARP_.call(null,tuple);
}),functionArray);
if(cljs.core.truth_(pp)){
return cljs.core.zipmap.call(null,pp,tuple_res);
} else {
if(cljs.core.truth_(inVector_QMARK_)){
return tuple_res;
} else {
return cljs.core.first.call(null,tuple_res);

}
}
});
})();
var inst_24324 = cljs.core.map.call(null,inst_24323,tuples);
var state_24331__$1 = state_24331;
var statearr_24337_24448 = state_24331__$1;
(statearr_24337_24448[(2)] = inst_24324);

(statearr_24337_24448[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (6))){
var inst_24305 = fluree.db.query.fql.get_pretty_print_keys.call(null,select);
var state_24331__$1 = state_24331;
var statearr_24338_24449 = state_24331__$1;
(statearr_24338_24449[(2)] = inst_24305);

(statearr_24338_24449[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (3))){
var inst_24329 = (state_24331[(2)]);
var state_24331__$1 = state_24331;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24331__$1,inst_24329);
} else {
if((state_val_24332 === (12))){
var inst_24308 = (state_24331[(7)]);
var inst_24316 = (state_24331[(8)]);
var inst_24318 = fluree.db.query.fql.pipeline_expandmaps_result.call(null,tuples,inst_24316,inVector_QMARK_,inst_24308,(8));
var state_24331__$1 = state_24331;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24331__$1,(15),inst_24318);
} else {
if((state_val_24332 === (2))){
var _ = (function (){var statearr_24339 = state_24331;
(statearr_24339[(4)] = cljs.core.cons.call(null,(5),(state_24331[(4)])));

return statearr_24339;
})();
var state_24331__$1 = state_24331;
if(cljs.core.truth_(prettyPrint)){
var statearr_24340_24450 = state_24331__$1;
(statearr_24340_24450[(1)] = (6));

} else {
var statearr_24341_24451 = state_24331__$1;
(statearr_24341_24451[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (11))){
var inst_24316 = (state_24331[(2)]);
var state_24331__$1 = (function (){var statearr_24343 = state_24331;
(statearr_24343[(8)] = inst_24316);

return statearr_24343;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24344_24452 = state_24331__$1;
(statearr_24344_24452[(1)] = (12));

} else {
var statearr_24345_24453 = state_24331__$1;
(statearr_24345_24453[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (9))){
var inst_24308 = (state_24331[(7)]);
var inst_24310 = (function (){var pp = inst_24308;
return (function (select__$1){
var select_val = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"variable","variable",-281346492).cljs$core$IFn$_invoke$arity$1(select__$1);
}
})();
var idx = (cljs.core.truth_(select_val)?fluree.db.util.core.index_of.call(null,headers,select_val):null);
var select_fn = (cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.call(null,tuple,idx);
}):(cljs.core.truth_(new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1))?(function (tuple){
return new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1);
}):(cljs.core.truth_(cljs.core.get.call(null,vars,select_val))?(function (tuple){
return cljs.core.get.call(null,vars,select_val);
}):null)));
if(cljs.core.truth_(new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select__$1))){
return (function (tuple){
var c__2901__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_24376){
var state_val_24377 = (state_24376[(1)]);
if((state_val_24377 === (7))){
var state_24376__$1 = state_24376;
var statearr_24378_24454 = state_24376__$1;
(statearr_24378_24454[(2)] = null);

(statearr_24378_24454[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (1))){
var state_24376__$1 = state_24376;
var statearr_24379_24455 = state_24376__$1;
(statearr_24379_24455[(2)] = null);

(statearr_24379_24455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (4))){
var inst_24346 = (state_24376[(2)]);
var state_24376__$1 = state_24376;
var statearr_24380_24456 = state_24376__$1;
(statearr_24380_24456[(2)] = inst_24346);

(statearr_24380_24456[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (6))){
var inst_24352 = (state_24376[(7)]);
var inst_24354 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"from","from",1815293044),new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_24355 = new cljs.core.Keyword(null,"selection","selection",975998651).cljs$core$IFn$_invoke$arity$1(select__$1);
var inst_24356 = [inst_24355,inst_24352,opts];
var inst_24357 = cljs.core.PersistentHashMap.fromArrays(inst_24354,inst_24356);
var inst_24358 = fluree.db.query.fql.query.call(null,db,inst_24357);
var state_24376__$1 = state_24376;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24376__$1,(9),inst_24358);
} else {
if((state_val_24377 === (3))){
var inst_24374 = (state_24376[(2)]);
var state_24376__$1 = state_24376;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24376__$1,inst_24374);
} else {
if((state_val_24377 === (12))){
var inst_24368 = (state_24376[(2)]);
var state_24376__$1 = state_24376;
var statearr_24381_24457 = state_24376__$1;
(statearr_24381_24457[(2)] = inst_24368);

(statearr_24381_24457[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (2))){
var inst_24352 = (state_24376[(7)]);
var _ = (function (){var statearr_24382 = state_24376;
(statearr_24382[(4)] = cljs.core.cons.call(null,(5),(state_24376[(4)])));

return statearr_24382;
})();
var inst_24352__$1 = select_fn.call(null,tuple);
var state_24376__$1 = (function (){var statearr_24383 = state_24376;
(statearr_24383[(7)] = inst_24352__$1);

return statearr_24383;
})();
if(cljs.core.truth_(inst_24352__$1)){
var statearr_24384_24458 = state_24376__$1;
(statearr_24384_24458[(1)] = (6));

} else {
var statearr_24385_24459 = state_24376__$1;
(statearr_24385_24459[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (11))){
var inst_24352 = (state_24376[(7)]);
var inst_24364 = [new cljs.core.Keyword(null,"_id","_id",-789960287)];
var inst_24365 = [inst_24352];
var inst_24366 = cljs.core.PersistentHashMap.fromArrays(inst_24364,inst_24365);
var state_24376__$1 = state_24376;
var statearr_24387_24460 = state_24376__$1;
(statearr_24387_24460[(2)] = inst_24366);

(statearr_24387_24460[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (9))){
var inst_24361 = (state_24376[(8)]);
var inst_24360 = (state_24376[(2)]);
var inst_24361__$1 = fluree.db.util.async.throw_err.call(null,inst_24360);
var state_24376__$1 = (function (){var statearr_24388 = state_24376;
(statearr_24388[(8)] = inst_24361__$1);

return statearr_24388;
})();
if(cljs.core.truth_(inst_24361__$1)){
var statearr_24389_24461 = state_24376__$1;
(statearr_24389_24461[(1)] = (10));

} else {
var statearr_24390_24462 = state_24376__$1;
(statearr_24390_24462[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (5))){
var _ = (function (){var statearr_24391 = state_24376;
(statearr_24391[(4)] = cljs.core.rest.call(null,(state_24376[(4)])));

return statearr_24391;
})();
var state_24376__$1 = state_24376;
var ex24386 = (state_24376__$1[(2)]);
var statearr_24392_24463 = state_24376__$1;
(statearr_24392_24463[(5)] = ex24386);


if((ex24386 instanceof Error)){
var statearr_24393_24464 = state_24376__$1;
(statearr_24393_24464[(1)] = (4));

(statearr_24393_24464[(5)] = null);

} else {
throw ex24386;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (10))){
var inst_24361 = (state_24376[(8)]);
var state_24376__$1 = state_24376;
var statearr_24394_24465 = state_24376__$1;
(statearr_24394_24465[(2)] = inst_24361);

(statearr_24394_24465[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24377 === (8))){
var inst_24371 = (state_24376[(2)]);
var _ = (function (){var statearr_24395 = state_24376;
(statearr_24395[(4)] = cljs.core.rest.call(null,(state_24376[(4)])));

return statearr_24395;
})();
var state_24376__$1 = state_24376;
var statearr_24396_24466 = state_24376__$1;
(statearr_24396_24466[(2)] = inst_24371);

(statearr_24396_24466[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____0 = (function (){
var statearr_24397 = [null,null,null,null,null,null,null,null,null];
(statearr_24397[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__);

(statearr_24397[(1)] = (1));

return statearr_24397;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____1 = (function (state_24376){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_24376);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e24398){var ex__2882__auto__ = e24398;
var statearr_24399_24467 = state_24376;
(statearr_24399_24467[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_24376[(4)]))){
var statearr_24400_24468 = state_24376;
(statearr_24400_24468[(1)] = cljs.core.first.call(null,(state_24376[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24469 = state_24376;
state_24376 = G__24469;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__ = function(state_24376){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____1.call(this,state_24376);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_24401 = f__2902__auto__.call(null);
(statearr_24401[(6)] = c__2901__auto____$1);

return statearr_24401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto____$1;
});
} else {
return (function (tuple){
var c__2901__auto____$1 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_24413){
var state_val_24414 = (state_24413[(1)]);
if((state_val_24414 === (1))){
var state_24413__$1 = state_24413;
var statearr_24415_24470 = state_24413__$1;
(statearr_24415_24470[(2)] = null);

(statearr_24415_24470[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24414 === (2))){
var _ = (function (){var statearr_24416 = state_24413;
(statearr_24416[(4)] = cljs.core.cons.call(null,(5),(state_24413[(4)])));

return statearr_24416;
})();
var inst_24408 = select_fn.call(null,tuple);
var ___$1 = (function (){var statearr_24417 = state_24413;
(statearr_24417[(4)] = cljs.core.rest.call(null,(state_24413[(4)])));

return statearr_24417;
})();
var state_24413__$1 = state_24413;
var statearr_24418_24471 = state_24413__$1;
(statearr_24418_24471[(2)] = inst_24408);

(statearr_24418_24471[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24414 === (3))){
var inst_24411 = (state_24413[(2)]);
var state_24413__$1 = state_24413;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24413__$1,inst_24411);
} else {
if((state_val_24414 === (4))){
var inst_24402 = (state_24413[(2)]);
var state_24413__$1 = state_24413;
var statearr_24420_24472 = state_24413__$1;
(statearr_24420_24472[(2)] = inst_24402);

(statearr_24420_24472[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24414 === (5))){
var _ = (function (){var statearr_24421 = state_24413;
(statearr_24421[(4)] = cljs.core.rest.call(null,(state_24413[(4)])));

return statearr_24421;
})();
var state_24413__$1 = state_24413;
var ex24419 = (state_24413__$1[(2)]);
var statearr_24422_24473 = state_24413__$1;
(statearr_24422_24473[(5)] = ex24419);


if((ex24419 instanceof Error)){
var statearr_24423_24474 = state_24413__$1;
(statearr_24423_24474[(1)] = (4));

(statearr_24423_24474[(5)] = null);

} else {
throw ex24419;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____0 = (function (){
var statearr_24424 = [null,null,null,null,null,null,null];
(statearr_24424[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__);

(statearr_24424[(1)] = (1));

return statearr_24424;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____1 = (function (state_24413){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_24413);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e24425){var ex__2882__auto__ = e24425;
var statearr_24426_24475 = state_24413;
(statearr_24426_24475[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_24413[(4)]))){
var statearr_24427_24476 = state_24413;
(statearr_24427_24476[(1)] = cljs.core.first.call(null,(state_24413[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24477 = state_24413;
state_24413 = G__24477;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__ = function(state_24413){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____1.call(this,state_24413);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_24428 = f__2902__auto__.call(null);
(statearr_24428[(6)] = c__2901__auto____$1);

return statearr_24428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto____$1;
});
}
});
})();
var inst_24311 = cljs.core.map.call(null,inst_24310,select);
var state_24331__$1 = state_24331;
var statearr_24429_24478 = state_24331__$1;
(statearr_24429_24478[(2)] = inst_24311);

(statearr_24429_24478[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (5))){
var _ = (function (){var statearr_24430 = state_24331;
(statearr_24430[(4)] = cljs.core.rest.call(null,(state_24331[(4)])));

return statearr_24430;
})();
var state_24331__$1 = state_24331;
var ex24342 = (state_24331__$1[(2)]);
var statearr_24431_24479 = state_24331__$1;
(statearr_24431_24479[(5)] = ex24342);


if((ex24342 instanceof Error)){
var statearr_24432_24480 = state_24331__$1;
(statearr_24432_24480[(1)] = (4));

(statearr_24432_24480[(5)] = null);

} else {
throw ex24342;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (14))){
var inst_24326 = (state_24331[(2)]);
var _ = (function (){var statearr_24433 = state_24331;
(statearr_24433[(4)] = cljs.core.rest.call(null,(state_24331[(4)])));

return statearr_24433;
})();
var state_24331__$1 = state_24331;
var statearr_24434_24481 = state_24331__$1;
(statearr_24434_24481[(2)] = inst_24326);

(statearr_24434_24481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (10))){
var inst_24308 = (state_24331[(7)]);
var inst_24313 = (function (){var pp = inst_24308;
return (function (select__$1){
var temp__5733__auto__ = new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(select__$1);
if(cljs.core.truth_(temp__5733__auto__)){
var val = temp__5733__auto__;
return (function (x){
return val;
});
} else {
var idx = fluree.db.query.fql.get_header_idx.call(null,headers,select__$1);
return (function (tuple){
return cljs.core.nth.call(null,tuple,idx);
});
}
});
})();
var inst_24314 = cljs.core.map.call(null,inst_24313,select);
var state_24331__$1 = state_24331;
var statearr_24435_24482 = state_24331__$1;
(statearr_24435_24482[(2)] = inst_24314);

(statearr_24435_24482[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24332 === (8))){
var inst_24308 = (state_24331[(2)]);
var state_24331__$1 = (function (){var statearr_24436 = state_24331;
(statearr_24436[(7)] = inst_24308);

return statearr_24436;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_24437_24483 = state_24331__$1;
(statearr_24437_24483[(1)] = (9));

} else {
var statearr_24438_24484 = state_24331__$1;
(statearr_24438_24484[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____0 = (function (){
var statearr_24439 = [null,null,null,null,null,null,null,null,null];
(statearr_24439[(0)] = fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__);

(statearr_24439[(1)] = (1));

return statearr_24439;
});
var fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____1 = (function (state_24331){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_24331);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e24440){var ex__2882__auto__ = e24440;
var statearr_24441_24485 = state_24331;
(statearr_24441_24485[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_24331[(4)]))){
var statearr_24442_24486 = state_24331;
(statearr_24442_24486[(1)] = cljs.core.first.call(null,(state_24331[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24487 = state_24331;
state_24331 = G__24487;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__ = function(state_24331){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____1.call(this,state_24331);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____0;
fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto____1;
return fluree$db$query$fql$format_filter_tuples_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_24443 = f__2902__auto__.call(null);
(statearr_24443[(6)] = c__2901__auto__);

return statearr_24443;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__24489 = arguments.length;
switch (G__24489) {
case 4:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$4 = (function (db,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.call(null,db,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$5 = (function (db,p__24490,p__24491,group_limit,opts){
var map__24492 = p__24490;
var map__24492__$1 = (((((!((map__24492 == null))))?(((((map__24492.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24492.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24492):map__24492);
var res = map__24492__$1;
var vars = cljs.core.get.call(null,map__24492__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24493 = p__24491;
var map__24493__$1 = (((((!((map__24493 == null))))?(((((map__24493.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24493.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24493):map__24493);
var select_spec = map__24493__$1;
var inVector_QMARK_ = cljs.core.get.call(null,map__24493__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var select = cljs.core.get.call(null,map__24493__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__24493__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__24493__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__24493__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var aggregates = cljs.core.get.call(null,map__24493__$1,new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289));
var prettyPrint = cljs.core.get.call(null,map__24493__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__24493__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var groupBy = cljs.core.get.call(null,map__24493__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_24664){
var state_val_24665 = (state_24664[(1)]);
if((state_val_24665 === (65))){
var inst_24598 = (state_24664[(7)]);
var state_24664__$1 = state_24664;
var statearr_24666_24797 = state_24664__$1;
(statearr_24666_24797[(2)] = inst_24598);

(statearr_24666_24797[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (70))){
var inst_24620 = (state_24664[(8)]);
var inst_24628 = cljs.core.drop.call(null,offset,inst_24620);
var state_24664__$1 = state_24664;
var statearr_24667_24798 = state_24664__$1;
(statearr_24667_24798[(2)] = inst_24628);

(statearr_24667_24798[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (62))){
var inst_24598 = (state_24664[(7)]);
var state_24664__$1 = state_24664;
var statearr_24668_24799 = state_24664__$1;
(statearr_24668_24799[(2)] = inst_24598);

(statearr_24668_24799[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (74))){
var inst_24632 = (state_24664[(9)]);
var state_24664__$1 = state_24664;
var statearr_24669_24800 = state_24664__$1;
(statearr_24669_24800[(2)] = inst_24632);

(statearr_24669_24800[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (7))){
var inst_24502 = (state_24664[(10)]);
var state_24664__$1 = state_24664;
var statearr_24670_24801 = state_24664__$1;
(statearr_24670_24801[(2)] = inst_24502);

(statearr_24670_24801[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (59))){
var state_24664__$1 = state_24664;
var statearr_24671_24802 = state_24664__$1;
(statearr_24671_24802[(2)] = offset);

(statearr_24671_24802[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (20))){
var inst_24537 = (state_24664[(11)]);
var inst_24537__$1 = (state_24664[(2)]);
var inst_24539 = (inst_24537__$1 == null);
var inst_24540 = cljs.core.not.call(null,inst_24539);
var state_24664__$1 = (function (){var statearr_24672 = state_24664;
(statearr_24672[(11)] = inst_24537__$1);

return statearr_24672;
})();
if(inst_24540){
var statearr_24673_24803 = state_24664__$1;
(statearr_24673_24803[(1)] = (21));

} else {
var statearr_24674_24804 = state_24664__$1;
(statearr_24674_24804[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (72))){
var inst_24632 = (state_24664[(9)]);
var inst_24631 = (state_24664[(2)]);
var inst_24632__$1 = group_limit;
var state_24664__$1 = (function (){var statearr_24675 = state_24664;
(statearr_24675[(9)] = inst_24632__$1);

(statearr_24675[(12)] = inst_24631);

return statearr_24675;
})();
if(cljs.core.truth_(inst_24632__$1)){
var statearr_24676_24805 = state_24664__$1;
(statearr_24676_24805[(1)] = (73));

} else {
var statearr_24677_24806 = state_24664__$1;
(statearr_24677_24806[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (58))){
var inst_24604 = (state_24664[(13)]);
var state_24664__$1 = state_24664;
var statearr_24678_24807 = state_24664__$1;
(statearr_24678_24807[(2)] = inst_24604);

(statearr_24678_24807[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (60))){
var inst_24608 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
var statearr_24679_24808 = state_24664__$1;
(statearr_24679_24808[(2)] = inst_24608);

(statearr_24679_24808[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (27))){
var inst_24537 = (state_24664[(11)]);
var inst_24555 = cljs.core.apply.call(null,cljs.core.hash_map,inst_24537);
var state_24664__$1 = state_24664;
var statearr_24680_24809 = state_24664__$1;
(statearr_24680_24809[(2)] = inst_24555);

(statearr_24680_24809[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (1))){
var state_24664__$1 = state_24664;
var statearr_24681_24810 = state_24664__$1;
(statearr_24681_24810[(2)] = null);

(statearr_24681_24810[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (69))){
var inst_24626 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
if(cljs.core.truth_(inst_24626)){
var statearr_24682_24811 = state_24664__$1;
(statearr_24682_24811[(1)] = (70));

} else {
var statearr_24683_24812 = state_24664__$1;
(statearr_24683_24812[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (24))){
var state_24664__$1 = state_24664;
var statearr_24684_24813 = state_24664__$1;
(statearr_24684_24813[(2)] = true);

(statearr_24684_24813[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (55))){
var inst_24604 = (state_24664[(13)]);
var inst_24604__$1 = group_limit;
var state_24664__$1 = (function (){var statearr_24685 = state_24664;
(statearr_24685[(13)] = inst_24604__$1);

return statearr_24685;
})();
if(cljs.core.truth_(inst_24604__$1)){
var statearr_24686_24814 = state_24664__$1;
(statearr_24686_24814[(1)] = (58));

} else {
var statearr_24687_24815 = state_24664__$1;
(statearr_24687_24815[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (39))){
var inst_24570 = (state_24664[(14)]);
var state_24664__$1 = state_24664;
var statearr_24688_24816 = state_24664__$1;
(statearr_24688_24816[(2)] = inst_24570);

(statearr_24688_24816[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (46))){
var state_24664__$1 = state_24664;
var statearr_24689_24817 = state_24664__$1;
(statearr_24689_24817[(1)] = (48));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (4))){
var inst_24496 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
var statearr_24691_24818 = state_24664__$1;
(statearr_24691_24818[(2)] = inst_24496);

(statearr_24691_24818[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (77))){
var inst_24631 = (state_24664[(12)]);
var state_24664__$1 = state_24664;
var statearr_24692_24819 = state_24664__$1;
(statearr_24692_24819[(2)] = inst_24631);

(statearr_24692_24819[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (54))){
var inst_24613 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
if(cljs.core.truth_(inst_24613)){
var statearr_24693_24820 = state_24664__$1;
(statearr_24693_24820[(1)] = (61));

} else {
var statearr_24694_24821 = state_24664__$1;
(statearr_24694_24821[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (15))){
var inst_24523 = (state_24664[(15)]);
var inst_24525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_24526 = [inst_24523];
var inst_24527 = (new cljs.core.PersistentVector(null,1,(5),inst_24525,inst_24526,null));
var state_24664__$1 = state_24664;
var statearr_24695_24822 = state_24664__$1;
(statearr_24695_24822[(2)] = inst_24527);

(statearr_24695_24822[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (48))){
var inst_24570 = (state_24664[(14)]);
var state_24664__$1 = state_24664;
var statearr_24696_24823 = state_24664__$1;
(statearr_24696_24823[(2)] = inst_24570);

(statearr_24696_24823[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (50))){
var inst_24587 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
var statearr_24697_24824 = state_24664__$1;
(statearr_24697_24824[(2)] = inst_24587);

(statearr_24697_24824[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (75))){
var inst_24637 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
if(cljs.core.truth_(inst_24637)){
var statearr_24698_24825 = state_24664__$1;
(statearr_24698_24825[(1)] = (76));

} else {
var statearr_24699_24826 = state_24664__$1;
(statearr_24699_24826[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (21))){
var inst_24537 = (state_24664[(11)]);
var inst_24542 = inst_24537.cljs$lang$protocol_mask$partition0$;
var inst_24543 = (inst_24542 & (64));
var inst_24544 = inst_24537.cljs$core$ISeq$;
var inst_24545 = (cljs.core.PROTOCOL_SENTINEL === inst_24544);
var inst_24546 = ((inst_24543) || (inst_24545));
var state_24664__$1 = state_24664;
if(cljs.core.truth_(inst_24546)){
var statearr_24700_24827 = state_24664__$1;
(statearr_24700_24827[(1)] = (24));

} else {
var statearr_24701_24828 = state_24664__$1;
(statearr_24701_24828[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (31))){
var state_24664__$1 = state_24664;
var statearr_24702_24829 = state_24664__$1;
(statearr_24702_24829[(2)] = offset);

(statearr_24702_24829[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (32))){
var inst_24564 = (state_24664[(2)]);
var state_24664__$1 = (function (){var statearr_24703 = state_24664;
(statearr_24703[(16)] = inst_24564);

return statearr_24703;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24704_24830 = state_24664__$1;
(statearr_24704_24830[(1)] = (33));

} else {
var statearr_24705_24831 = state_24664__$1;
(statearr_24705_24831[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (40))){
var inst_24564 = (state_24664[(16)]);
var state_24664__$1 = state_24664;
if(cljs.core.truth_(inst_24564)){
var statearr_24706_24832 = state_24664__$1;
(statearr_24706_24832[(1)] = (42));

} else {
var statearr_24707_24833 = state_24664__$1;
(statearr_24707_24833[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (56))){
var state_24664__$1 = state_24664;
var statearr_24708_24834 = state_24664__$1;
(statearr_24708_24834[(2)] = false);

(statearr_24708_24834[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (33))){
var inst_24560 = (state_24664[(17)]);
var inst_24566 = cljs.core.PersistentHashSet.EMPTY;
var inst_24567 = cljs.core.into.call(null,inst_24566,inst_24560);
var state_24664__$1 = state_24664;
var statearr_24709_24835 = state_24664__$1;
(statearr_24709_24835[(2)] = inst_24567);

(statearr_24709_24835[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (13))){
var inst_24512 = (state_24664[(18)]);
var state_24664__$1 = state_24664;
var statearr_24710_24836 = state_24664__$1;
(statearr_24710_24836[(2)] = inst_24512);

(statearr_24710_24836[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (22))){
var state_24664__$1 = state_24664;
var statearr_24711_24837 = state_24664__$1;
(statearr_24711_24837[(2)] = false);

(statearr_24711_24837[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (36))){
var inst_24564 = (state_24664[(16)]);
var inst_24570 = (state_24664[(14)]);
var inst_24559 = (state_24664[(19)]);
var inst_24572 = fluree.db.query.fql.order_offset_and_limit_results.call(null,inst_24570,inst_24559,orderBy,inst_24564,group_limit);
var state_24664__$1 = state_24664;
var statearr_24712_24838 = state_24664__$1;
(statearr_24712_24838[(2)] = inst_24572);

(statearr_24712_24838[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (41))){
var inst_24591 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
var statearr_24713_24839 = state_24664__$1;
(statearr_24713_24839[(2)] = inst_24591);

(statearr_24713_24839[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (43))){
var state_24664__$1 = state_24664;
var statearr_24714_24840 = state_24664__$1;
(statearr_24714_24840[(2)] = group_limit);

(statearr_24714_24840[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (61))){
var state_24664__$1 = state_24664;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_24715_24841 = state_24664__$1;
(statearr_24715_24841[(1)] = (64));

} else {
var statearr_24716_24842 = state_24664__$1;
(statearr_24716_24842[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (29))){
var inst_24558 = (state_24664[(2)]);
var inst_24559 = cljs.core.get.call(null,inst_24558,new cljs.core.Keyword(null,"headers","headers",-835030129));
var inst_24560 = cljs.core.get.call(null,inst_24558,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var state_24664__$1 = (function (){var statearr_24717 = state_24664;
(statearr_24717[(17)] = inst_24560);

(statearr_24717[(19)] = inst_24559);

return statearr_24717;
})();
if(cljs.core.truth_(groupBy)){
var statearr_24718_24843 = state_24664__$1;
(statearr_24718_24843[(1)] = (30));

} else {
var statearr_24719_24844 = state_24664__$1;
(statearr_24719_24844[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (44))){
var inst_24579 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
if(cljs.core.truth_(inst_24579)){
var statearr_24720_24845 = state_24664__$1;
(statearr_24720_24845[(1)] = (45));

} else {
var statearr_24721_24846 = state_24664__$1;
(statearr_24721_24846[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (6))){
var inst_24504 = cljs.core.count.call(null,select);
var inst_24505 = cljs.core._EQ_.call(null,(1),inst_24504);
var state_24664__$1 = state_24664;
var statearr_24722_24847 = state_24664__$1;
(statearr_24722_24847[(2)] = inst_24505);

(statearr_24722_24847[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (28))){
var inst_24537 = (state_24664[(11)]);
var state_24664__$1 = state_24664;
var statearr_24723_24848 = state_24664__$1;
(statearr_24723_24848[(2)] = inst_24537);

(statearr_24723_24848[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (64))){
var inst_24598 = (state_24664[(7)]);
var inst_24617 = cljs.core.distinct.call(null,inst_24598);
var state_24664__$1 = state_24664;
var statearr_24724_24849 = state_24664__$1;
(statearr_24724_24849[(2)] = inst_24617);

(statearr_24724_24849[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (51))){
var inst_24599 = (state_24664[(20)]);
var inst_24597 = (state_24664[(2)]);
var inst_24598 = fluree.db.util.async.throw_err.call(null,inst_24597);
var inst_24599__$1 = selectDistinct_QMARK_;
var state_24664__$1 = (function (){var statearr_24725 = state_24664;
(statearr_24725[(7)] = inst_24598);

(statearr_24725[(20)] = inst_24599__$1);

return statearr_24725;
})();
if(cljs.core.truth_(inst_24599__$1)){
var statearr_24726_24850 = state_24664__$1;
(statearr_24726_24850[(1)] = (52));

} else {
var statearr_24727_24851 = state_24664__$1;
(statearr_24727_24851[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (25))){
var state_24664__$1 = state_24664;
var statearr_24728_24852 = state_24664__$1;
(statearr_24728_24852[(2)] = false);

(statearr_24728_24852[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (34))){
var inst_24560 = (state_24664[(17)]);
var state_24664__$1 = state_24664;
var statearr_24729_24853 = state_24664__$1;
(statearr_24729_24853[(2)] = inst_24560);

(statearr_24729_24853[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (17))){
var inst_24530 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
var statearr_24730_24854 = state_24664__$1;
(statearr_24730_24854[(2)] = inst_24530);

(statearr_24730_24854[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (3))){
var inst_24662 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_24664__$1,inst_24662);
} else {
if((state_val_24665 === (12))){
var inst_24512 = (state_24664[(18)]);
var inst_24514 = cljs.core.first.call(null,select);
var inst_24515 = new cljs.core.Keyword(null,"as","as",1148689641).cljs$core$IFn$_invoke$arity$1(inst_24514);
var inst_24516 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_24515);
var inst_24517 = cljs.core.subs.call(null,inst_24516,(1));
var inst_24518 = [inst_24517];
var inst_24519 = [inst_24512];
var inst_24520 = cljs.core.PersistentHashMap.fromArrays(inst_24518,inst_24519);
var state_24664__$1 = state_24664;
var statearr_24731_24855 = state_24664__$1;
(statearr_24731_24855[(2)] = inst_24520);

(statearr_24731_24855[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (2))){
var inst_24502 = (state_24664[(10)]);
var _ = (function (){var statearr_24732 = state_24664;
(statearr_24732[(4)] = cljs.core.cons.call(null,(5),(state_24664[(4)])));

return statearr_24732;
})();
var inst_24502__$1 = aggregates;
var state_24664__$1 = (function (){var statearr_24733 = state_24664;
(statearr_24733[(10)] = inst_24502__$1);

return statearr_24733;
})();
if(cljs.core.truth_(inst_24502__$1)){
var statearr_24734_24856 = state_24664__$1;
(statearr_24734_24856[(1)] = (6));

} else {
var statearr_24735_24857 = state_24664__$1;
(statearr_24735_24857[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (66))){
var inst_24621 = (state_24664[(21)]);
var inst_24620 = (state_24664[(2)]);
var inst_24621__$1 = offset;
var state_24664__$1 = (function (){var statearr_24736 = state_24664;
(statearr_24736[(21)] = inst_24621__$1);

(statearr_24736[(8)] = inst_24620);

return statearr_24736;
})();
if(cljs.core.truth_(inst_24621__$1)){
var statearr_24737_24858 = state_24664__$1;
(statearr_24737_24858[(1)] = (67));

} else {
var statearr_24738_24859 = state_24664__$1;
(statearr_24738_24859[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (23))){
var inst_24553 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
if(cljs.core.truth_(inst_24553)){
var statearr_24739_24860 = state_24664__$1;
(statearr_24739_24860[(1)] = (27));

} else {
var statearr_24740_24861 = state_24664__$1;
(statearr_24740_24861[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (47))){
var inst_24589 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
var statearr_24741_24862 = state_24664__$1;
(statearr_24741_24862[(2)] = inst_24589);

(statearr_24741_24862[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (35))){
var inst_24570 = (state_24664[(2)]);
var state_24664__$1 = (function (){var statearr_24742 = state_24664;
(statearr_24742[(14)] = inst_24570);

return statearr_24742;
})();
if(cljs.core.truth_(orderBy)){
var statearr_24743_24863 = state_24664__$1;
(statearr_24743_24863[(1)] = (36));

} else {
var statearr_24744_24864 = state_24664__$1;
(statearr_24744_24864[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (82))){
var inst_24642 = (state_24664[(22)]);
var inst_24650 = cljs.core.PersistentVector.EMPTY;
var inst_24651 = cljs.core.into.call(null,inst_24650,inst_24642);
var state_24664__$1 = state_24664;
var statearr_24745_24865 = state_24664__$1;
(statearr_24745_24865[(2)] = inst_24651);

(statearr_24745_24865[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (76))){
var inst_24631 = (state_24664[(12)]);
var inst_24639 = cljs.core.take.call(null,group_limit,inst_24631);
var state_24664__$1 = state_24664;
var statearr_24746_24866 = state_24664__$1;
(statearr_24746_24866[(2)] = inst_24639);

(statearr_24746_24866[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (19))){
var state_24664__$1 = state_24664;
var statearr_24747_24867 = state_24664__$1;
(statearr_24747_24867[(2)] = res);

(statearr_24747_24867[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (57))){
var inst_24611 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
var statearr_24748_24868 = state_24664__$1;
(statearr_24748_24868[(2)] = inst_24611);

(statearr_24748_24868[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (68))){
var inst_24621 = (state_24664[(21)]);
var state_24664__$1 = state_24664;
var statearr_24749_24869 = state_24664__$1;
(statearr_24749_24869[(2)] = inst_24621);

(statearr_24749_24869[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (11))){
var inst_24659 = (state_24664[(2)]);
var _ = (function (){var statearr_24751 = state_24664;
(statearr_24751[(4)] = cljs.core.rest.call(null,(state_24664[(4)])));

return statearr_24751;
})();
var state_24664__$1 = state_24664;
var statearr_24752_24870 = state_24664__$1;
(statearr_24752_24870[(2)] = inst_24659);

(statearr_24752_24870[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (9))){
var inst_24510 = cljs.core.first.call(null,aggregates);
var inst_24511 = fluree.db.query.analytical.calculate_aggregate.call(null,res,inst_24510);
var inst_24512 = cljs.core.second.call(null,inst_24511);
var state_24664__$1 = (function (){var statearr_24753 = state_24664;
(statearr_24753[(18)] = inst_24512);

return statearr_24753;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_24754_24871 = state_24664__$1;
(statearr_24754_24871[(1)] = (12));

} else {
var statearr_24755_24872 = state_24664__$1;
(statearr_24755_24872[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (5))){
var _ = (function (){var statearr_24756 = state_24664;
(statearr_24756[(4)] = cljs.core.rest.call(null,(state_24664[(4)])));

return statearr_24756;
})();
var state_24664__$1 = state_24664;
var ex24750 = (state_24664__$1[(2)]);
var statearr_24757_24873 = state_24664__$1;
(statearr_24757_24873[(5)] = ex24750);


if((ex24750 instanceof Error)){
var statearr_24758_24874 = state_24664__$1;
(statearr_24758_24874[(1)] = (4));

(statearr_24758_24874[(5)] = null);

} else {
throw ex24750;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (83))){
var inst_24642 = (state_24664[(22)]);
var state_24664__$1 = state_24664;
var statearr_24759_24875 = state_24664__$1;
(statearr_24759_24875[(2)] = inst_24642);

(statearr_24759_24875[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (14))){
var inst_24523 = (state_24664[(2)]);
var state_24664__$1 = (function (){var statearr_24760 = state_24664;
(statearr_24760[(15)] = inst_24523);

return statearr_24760;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_24761_24876 = state_24664__$1;
(statearr_24761_24876[(1)] = (15));

} else {
var statearr_24762_24877 = state_24664__$1;
(statearr_24762_24877[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (45))){
var inst_24564 = (state_24664[(16)]);
var inst_24570 = (state_24664[(14)]);
var inst_24581 = cljs.core.drop.call(null,inst_24564,inst_24570);
var inst_24582 = cljs.core.take.call(null,group_limit,inst_24581);
var state_24664__$1 = state_24664;
var statearr_24763_24878 = state_24664__$1;
(statearr_24763_24878[(2)] = inst_24582);

(statearr_24763_24878[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (53))){
var inst_24602 = cljs.core.not.call(null,orderBy);
var state_24664__$1 = state_24664;
if(inst_24602){
var statearr_24764_24879 = state_24664__$1;
(statearr_24764_24879[(1)] = (55));

} else {
var statearr_24765_24880 = state_24664__$1;
(statearr_24765_24880[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (78))){
var inst_24643 = (state_24664[(23)]);
var inst_24642 = (state_24664[(2)]);
var inst_24643__$1 = inVector_QMARK_;
var state_24664__$1 = (function (){var statearr_24766 = state_24664;
(statearr_24766[(23)] = inst_24643__$1);

(statearr_24766[(22)] = inst_24642);

return statearr_24766;
})();
if(cljs.core.truth_(inst_24643__$1)){
var statearr_24767_24881 = state_24664__$1;
(statearr_24767_24881[(1)] = (79));

} else {
var statearr_24768_24882 = state_24664__$1;
(statearr_24768_24882[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (26))){
var inst_24550 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
var statearr_24769_24883 = state_24664__$1;
(statearr_24769_24883[(2)] = inst_24550);

(statearr_24769_24883[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (16))){
var inst_24523 = (state_24664[(15)]);
var state_24664__$1 = state_24664;
var statearr_24770_24884 = state_24664__$1;
(statearr_24770_24884[(2)] = inst_24523);

(statearr_24770_24884[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (81))){
var inst_24648 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
if(cljs.core.truth_(inst_24648)){
var statearr_24771_24885 = state_24664__$1;
(statearr_24771_24885[(1)] = (82));

} else {
var statearr_24772_24886 = state_24664__$1;
(statearr_24772_24886[(1)] = (83));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (79))){
var inst_24643 = (state_24664[(23)]);
var state_24664__$1 = state_24664;
var statearr_24773_24887 = state_24664__$1;
(statearr_24773_24887[(2)] = inst_24643);

(statearr_24773_24887[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (38))){
var inst_24559 = (state_24664[(19)]);
var inst_24593 = (state_24664[(2)]);
var inst_24594 = cljs.core.dissoc.call(null,opts,new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var inst_24595 = fluree.db.query.fql.format_filter_tuples.call(null,db,inst_24593,select_spec,inst_24559,vars,inst_24594);
var state_24664__$1 = state_24664;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_24664__$1,(51),inst_24595);
} else {
if((state_val_24665 === (30))){
var state_24664__$1 = state_24664;
var statearr_24774_24888 = state_24664__$1;
(statearr_24774_24888[(2)] = (0));

(statearr_24774_24888[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (73))){
var inst_24634 = ((0) < group_limit);
var state_24664__$1 = state_24664;
var statearr_24775_24889 = state_24664__$1;
(statearr_24775_24889[(2)] = inst_24634);

(statearr_24775_24889[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (10))){
var state_24664__$1 = state_24664;
if(cljs.core.truth_(aggregates)){
var statearr_24776_24890 = state_24664__$1;
(statearr_24776_24890[(1)] = (18));

} else {
var statearr_24777_24891 = state_24664__$1;
(statearr_24777_24891[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (18))){
var inst_24534 = fluree.db.query.analytical.add_aggregate_cols.call(null,res,aggregates);
var state_24664__$1 = state_24664;
var statearr_24778_24892 = state_24664__$1;
(statearr_24778_24892[(2)] = inst_24534);

(statearr_24778_24892[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (52))){
var inst_24599 = (state_24664[(20)]);
var state_24664__$1 = state_24664;
var statearr_24779_24893 = state_24664__$1;
(statearr_24779_24893[(2)] = inst_24599);

(statearr_24779_24893[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (67))){
var inst_24623 = ((0) < offset);
var state_24664__$1 = state_24664;
var statearr_24780_24894 = state_24664__$1;
(statearr_24780_24894[(2)] = inst_24623);

(statearr_24780_24894[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (71))){
var inst_24620 = (state_24664[(8)]);
var state_24664__$1 = state_24664;
var statearr_24781_24895 = state_24664__$1;
(statearr_24781_24895[(2)] = inst_24620);

(statearr_24781_24895[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (42))){
var inst_24564 = (state_24664[(16)]);
var state_24664__$1 = state_24664;
var statearr_24782_24896 = state_24664__$1;
(statearr_24782_24896[(2)] = inst_24564);

(statearr_24782_24896[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (80))){
var inst_24598 = (state_24664[(7)]);
var inst_24646 = cljs.core.vector_QMARK_.call(null,inst_24598);
var state_24664__$1 = state_24664;
var statearr_24783_24897 = state_24664__$1;
(statearr_24783_24897[(2)] = inst_24646);

(statearr_24783_24897[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (37))){
var state_24664__$1 = state_24664;
if(cljs.core.truth_(groupBy)){
var statearr_24784_24898 = state_24664__$1;
(statearr_24784_24898[(1)] = (39));

} else {
var statearr_24785_24899 = state_24664__$1;
(statearr_24785_24899[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (63))){
var inst_24657 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
var statearr_24786_24900 = state_24664__$1;
(statearr_24786_24900[(2)] = inst_24657);

(statearr_24786_24900[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (8))){
var inst_24508 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
if(cljs.core.truth_(inst_24508)){
var statearr_24787_24901 = state_24664__$1;
(statearr_24787_24901[(1)] = (9));

} else {
var statearr_24788_24902 = state_24664__$1;
(statearr_24788_24902[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (49))){
var state_24664__$1 = state_24664;
var statearr_24789_24903 = state_24664__$1;
(statearr_24789_24903[(2)] = null);

(statearr_24789_24903[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_24665 === (84))){
var inst_24654 = (state_24664[(2)]);
var state_24664__$1 = state_24664;
var statearr_24790_24904 = state_24664__$1;
(statearr_24790_24904[(2)] = inst_24654);

(statearr_24790_24904[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__2879__auto__ = null;
var fluree$db$query$fql$state_machine__2879__auto____0 = (function (){
var statearr_24791 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_24791[(0)] = fluree$db$query$fql$state_machine__2879__auto__);

(statearr_24791[(1)] = (1));

return statearr_24791;
});
var fluree$db$query$fql$state_machine__2879__auto____1 = (function (state_24664){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_24664);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e24792){var ex__2882__auto__ = e24792;
var statearr_24793_24905 = state_24664;
(statearr_24793_24905[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_24664[(4)]))){
var statearr_24794_24906 = state_24664;
(statearr_24794_24906[(1)] = cljs.core.first.call(null,(state_24664[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__24907 = state_24664;
state_24664 = G__24907;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__2879__auto__ = function(state_24664){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__2879__auto____1.call(this,state_24664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__2879__auto____0;
fluree$db$query$fql$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__2879__auto____1;
return fluree$db$query$fql$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_24795 = f__2902__auto__.call(null);
(statearr_24795[(6)] = c__2901__auto__);

return statearr_24795;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 5);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__24910,groupBy){
var map__24911 = p__24910;
var map__24911__$1 = (((((!((map__24911 == null))))?(((((map__24911.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24911.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24911):map__24911);
var res = map__24911__$1;
var headers = cljs.core.get.call(null,map__24911__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__24911__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__24913 = ((cljs.core.vector_QMARK_.call(null,groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.call(null,cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.call(null,groupBy)], null)], null):(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var inVector_QMARK_ = cljs.core.nth.call(null,vec__24913,(0),null);
var groupBy__$1 = cljs.core.nth.call(null,vec__24913,(1),null);
var group_idxs = cljs.core.map.call(null,(function (p1__24908_SHARP_){
return fluree.db.util.core.index_of.call(null,headers,p1__24908_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.call(null,["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():null);
return cljs.core.reduce.call(null,(function (res__$1,tuple){
var k = cljs.core.map.call(null,(function (p1__24909_SHARP_){
return cljs.core.nth.call(null,tuple,p1__24909_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.call(null,cljs.core.PersistentVector.EMPTY,k):cljs.core.first.call(null,k));
var v = tuple;
return cljs.core.assoc.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.conj.call(null,cljs.core.get.call(null,res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__24916 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.call(null,vec__24916,(0),null);
var sortCriteria = cljs.core.nth.call(null,vec__24916,(1),null);
if(cljs.core._EQ_.call(null,sortCriteria,groupBy)){
if(cljs.core._EQ_.call(null,sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_.call(null,groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of.call(null,groupBy,sortCriteria);
if(cljs.core._EQ_.call(null,"DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn.call(null,cljs.core.nth.call(null,x,orderByIdx),cljs.core.nth.call(null,y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,p__24919,p__24920,opts){
var map__24921 = p__24919;
var map__24921__$1 = (((((!((map__24921 == null))))?(((((map__24921.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24921.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24921):map__24921);
var res = map__24921__$1;
var headers = cljs.core.get.call(null,map__24921__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var vars = cljs.core.get.call(null,map__24921__$1,new cljs.core.Keyword(null,"vars","vars",-2046957217));
var map__24922 = p__24920;
var map__24922__$1 = (((((!((map__24922 == null))))?(((((map__24922.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__24922.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__24922):map__24922);
var select_spec = map__24922__$1;
var groupBy = cljs.core.get.call(null,map__24922__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var orderBy = cljs.core.get.call(null,map__24922__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var limit = cljs.core.get.call(null,map__24922__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var selectOne_QMARK_ = cljs.core.get.call(null,map__24922__$1,new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472));
var selectDistinct_QMARK_ = cljs.core.get.call(null,map__24922__$1,new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731));
var inVector_QMARK_ = cljs.core.get.call(null,map__24922__$1,new cljs.core.Keyword(null,"inVector?","inVector?",1948069375));
var offset = cljs.core.get.call(null,map__24922__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_25139){
var state_val_25140 = (state_25139[(1)]);
if((state_val_25140 === (65))){
var inst_25055 = (state_25139[(7)]);
var inst_25003 = (state_25139[(8)]);
var inst_24994 = (state_25139[(9)]);
var inst_25085 = cljs.core.assoc.call(null,inst_24994,inst_25003,inst_25055);
var state_25139__$1 = state_25139;
var statearr_25141_25270 = state_25139__$1;
(statearr_25141_25270[(2)] = inst_25085);

(statearr_25141_25270[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (70))){
var inst_25110 = (state_25139[(10)]);
var inst_25109 = (state_25139[(2)]);
var inst_25110__$1 = fluree.db.util.async.throw_err.call(null,inst_25109);
var inst_25111 = cljs.core.coll_QMARK_.call(null,inst_25110__$1);
var inst_25112 = (!(inst_25111));
var state_25139__$1 = (function (){var statearr_25142 = state_25139;
(statearr_25142[(10)] = inst_25110__$1);

return statearr_25142;
})();
if(inst_25112){
var statearr_25143_25271 = state_25139__$1;
(statearr_25143_25271[(1)] = (71));

} else {
var statearr_25144_25272 = state_25139__$1;
(statearr_25144_25272[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (62))){
var state_25139__$1 = state_25139;
var statearr_25145_25273 = state_25139__$1;
(statearr_25145_25273[(2)] = null);

(statearr_25145_25273[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (74))){
var inst_25110 = (state_25139[(10)]);
var inst_25115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25116 = [inst_25110];
var inst_25117 = (new cljs.core.PersistentVector(null,1,(5),inst_25115,inst_25116,null));
var state_25139__$1 = state_25139;
var statearr_25146_25274 = state_25139__$1;
(statearr_25146_25274[(2)] = inst_25117);

(statearr_25146_25274[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (7))){
var state_25139__$1 = state_25139;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25147_25275 = state_25139__$1;
(statearr_25147_25275[(1)] = (67));

} else {
var statearr_25148_25276 = state_25139__$1;
(statearr_25148_25276[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (59))){
var state_25139__$1 = state_25139;
var statearr_25149_25277 = state_25139__$1;
(statearr_25149_25277[(1)] = (61));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (20))){
var state_25139__$1 = state_25139;
var statearr_25151_25278 = state_25139__$1;
(statearr_25151_25278[(2)] = (0));

(statearr_25151_25278[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (72))){
var state_25139__$1 = state_25139;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25152_25279 = state_25139__$1;
(statearr_25152_25279[(1)] = (77));

} else {
var statearr_25153_25280 = state_25139__$1;
(statearr_25153_25280[(1)] = (78));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (58))){
var inst_24993 = (state_25139[(11)]);
var inst_25067 = (inst_24993 - (1));
var state_25139__$1 = state_25139;
var statearr_25154_25281 = state_25139__$1;
(statearr_25154_25281[(2)] = inst_25067);

(statearr_25154_25281[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (60))){
var inst_25077 = (state_25139[(2)]);
var state_25139__$1 = state_25139;
var statearr_25155_25282 = state_25139__$1;
(statearr_25155_25282[(2)] = inst_25077);

(statearr_25155_25282[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (27))){
var inst_24992 = (state_25139[(12)]);
var inst_25016 = (inst_24992 < (1));
var state_25139__$1 = state_25139;
var statearr_25156_25283 = state_25139__$1;
(statearr_25156_25283[(2)] = inst_25016);

(statearr_25156_25283[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (1))){
var state_25139__$1 = state_25139;
var statearr_25157_25284 = state_25139__$1;
(statearr_25157_25284[(2)] = null);

(statearr_25157_25284[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (69))){
var inst_25106 = (state_25139[(2)]);
var inst_25107 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,res,select_spec,inst_25106,opts);
var state_25139__$1 = state_25139;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25139__$1,(70),inst_25107);
} else {
if((state_val_25140 === (24))){
var inst_24994 = (state_25139[(9)]);
var state_25139__$1 = state_25139;
var statearr_25158_25285 = state_25139__$1;
(statearr_25158_25285[(2)] = inst_24994);

(statearr_25158_25285[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (55))){
var state_25139__$1 = state_25139;
var statearr_25159_25286 = state_25139__$1;
(statearr_25159_25286[(2)] = (0));

(statearr_25159_25286[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (39))){
var inst_25011 = (state_25139[(13)]);
var inst_25034 = cljs.core.assoc.call(null,select_spec,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),null,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_25035 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"offset","offset",296498311),(0),new cljs.core.Keyword(null,"limit","limit",-1355822363),null);
var inst_25036 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,inst_25011,inst_25034,inst_25035);
var state_25139__$1 = state_25139;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25139__$1,(42),inst_25036);
} else {
if((state_val_25140 === (46))){
var inst_24992 = (state_25139[(12)]);
var inst_25047 = ((0) < inst_24992);
var state_25139__$1 = state_25139;
var statearr_25160_25287 = state_25139__$1;
(statearr_25160_25287[(2)] = inst_25047);

(statearr_25160_25287[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (4))){
var inst_24925 = (state_25139[(2)]);
var state_25139__$1 = state_25139;
var statearr_25161_25288 = state_25139__$1;
(statearr_25161_25288[(2)] = inst_24925);

(statearr_25161_25288[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (77))){
var inst_25110 = (state_25139[(10)]);
var inst_25123 = cljs.core.first.call(null,inst_25110);
var state_25139__$1 = state_25139;
var statearr_25162_25289 = state_25139__$1;
(statearr_25162_25289[(2)] = inst_25123);

(statearr_25162_25289[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (54))){
var inst_24993 = (state_25139[(11)]);
var inst_25062 = (state_25139[(2)]);
var inst_25063 = (inst_24993 <= (0));
var state_25139__$1 = (function (){var statearr_25163 = state_25139;
(statearr_25163[(14)] = inst_25062);

return statearr_25163;
})();
if(cljs.core.truth_(inst_25063)){
var statearr_25164_25290 = state_25139__$1;
(statearr_25164_25290[(1)] = (55));

} else {
var statearr_25165_25291 = state_25139__$1;
(statearr_25165_25291[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (15))){
var inst_24943 = (state_25139[(15)]);
var inst_24951 = (state_25139[(2)]);
var inst_24952 = fluree.db.util.async.throw_err.call(null,inst_24951);
var inst_24953 = [inst_24943];
var inst_24954 = [inst_24952];
var inst_24955 = cljs.core.PersistentHashMap.fromArrays(inst_24953,inst_24954);
var state_25139__$1 = state_25139;
var statearr_25166_25292 = state_25139__$1;
(statearr_25166_25292[(2)] = inst_24955);

(statearr_25166_25292[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (48))){
var inst_25050 = (state_25139[(2)]);
var state_25139__$1 = state_25139;
if(cljs.core.truth_(inst_25050)){
var statearr_25167_25293 = state_25139__$1;
(statearr_25167_25293[(1)] = (49));

} else {
var statearr_25168_25294 = state_25139__$1;
(statearr_25168_25294[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (50))){
var inst_25045 = (state_25139[(16)]);
var state_25139__$1 = state_25139;
var statearr_25169_25295 = state_25139__$1;
(statearr_25169_25295[(2)] = inst_25045);

(statearr_25169_25295[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (75))){
var inst_25110 = (state_25139[(10)]);
var state_25139__$1 = state_25139;
var statearr_25170_25296 = state_25139__$1;
(statearr_25170_25296[(2)] = inst_25110);

(statearr_25170_25296[(1)] = (76));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (21))){
var inst_24975 = (state_25139[(17)]);
var inst_24983 = (state_25139[(18)]);
var inst_24971 = (state_25139[(19)]);
var inst_24988 = (state_25139[(2)]);
var inst_24989 = cljs.core.PersistentHashMap.EMPTY;
var inst_24990 = inst_24971;
var inst_24991 = inst_24975;
var inst_24992 = inst_24983;
var inst_24993 = inst_24988;
var inst_24994 = inst_24989;
var state_25139__$1 = (function (){var statearr_25171 = state_25139;
(statearr_25171[(20)] = inst_24990);

(statearr_25171[(12)] = inst_24992);

(statearr_25171[(21)] = inst_24991);

(statearr_25171[(9)] = inst_24994);

(statearr_25171[(11)] = inst_24993);

return statearr_25171;
})();
var statearr_25172_25297 = state_25139__$1;
(statearr_25172_25297[(2)] = null);

(statearr_25172_25297[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (31))){
var inst_25008 = (state_25139[(22)]);
var inst_24993 = (state_25139[(11)]);
var inst_25022 = (inst_24993 >= inst_25008);
var state_25139__$1 = state_25139;
if(cljs.core.truth_(inst_25022)){
var statearr_25173_25298 = state_25139__$1;
(statearr_25173_25298[(1)] = (33));

} else {
var statearr_25174_25299 = state_25139__$1;
(statearr_25174_25299[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (32))){
var inst_25095 = (state_25139[(2)]);
var state_25139__$1 = state_25139;
var statearr_25175_25300 = state_25139__$1;
(statearr_25175_25300[(2)] = inst_25095);

(statearr_25175_25300[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (40))){
var state_25139__$1 = state_25139;
var statearr_25176_25301 = state_25139__$1;
(statearr_25176_25301[(2)] = null);

(statearr_25176_25301[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (56))){
var state_25139__$1 = state_25139;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25177_25302 = state_25139__$1;
(statearr_25177_25302[(1)] = (58));

} else {
var statearr_25178_25303 = state_25139__$1;
(statearr_25178_25303[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (33))){
var state_25139__$1 = state_25139;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_25179_25304 = state_25139__$1;
(statearr_25179_25304[(1)] = (36));

} else {
var statearr_25180_25305 = state_25139__$1;
(statearr_25180_25305[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (13))){
var inst_24940 = (state_25139[(23)]);
var inst_24975 = (state_25139[(17)]);
var inst_24971 = (state_25139[(19)]);
var inst_24971__$1 = cljs.core.keys.call(null,inst_24940);
var inst_24972 = cljs.core.seq.call(null,inst_24971__$1);
var inst_24973 = cljs.core.first.call(null,inst_24972);
var inst_24974 = cljs.core.next.call(null,inst_24972);
var inst_24975__$1 = cljs.core.vals.call(null,inst_24940);
var inst_24976 = cljs.core.seq.call(null,inst_24975__$1);
var inst_24977 = cljs.core.first.call(null,inst_24976);
var inst_24978 = cljs.core.next.call(null,inst_24976);
var inst_24979 = cljs.core._EQ_.call(null,(0),limit);
var state_25139__$1 = (function (){var statearr_25181 = state_25139;
(statearr_25181[(24)] = inst_24977);

(statearr_25181[(17)] = inst_24975__$1);

(statearr_25181[(25)] = inst_24973);

(statearr_25181[(19)] = inst_24971__$1);

(statearr_25181[(26)] = inst_24974);

(statearr_25181[(27)] = inst_24978);

return statearr_25181;
})();
if(inst_24979){
var statearr_25182_25306 = state_25139__$1;
(statearr_25182_25306[(1)] = (16));

} else {
var statearr_25183_25307 = state_25139__$1;
(statearr_25183_25307[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (22))){
var inst_24990 = (state_25139[(20)]);
var inst_24991 = (state_25139[(21)]);
var inst_25002 = cljs.core.seq.call(null,inst_24990);
var inst_25003 = cljs.core.first.call(null,inst_25002);
var inst_25004 = cljs.core.next.call(null,inst_25002);
var inst_25005 = cljs.core.seq.call(null,inst_24991);
var inst_25006 = cljs.core.first.call(null,inst_25005);
var inst_25007 = cljs.core.next.call(null,inst_25005);
var inst_25008 = cljs.core.count.call(null,inst_25006);
var inst_25009 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_25010 = [headers,vars,inst_25006];
var inst_25011 = cljs.core.PersistentHashMap.fromArrays(inst_25009,inst_25010);
var inst_25012 = (inst_25006 == null);
var state_25139__$1 = (function (){var statearr_25184 = state_25139;
(statearr_25184[(28)] = inst_25004);

(statearr_25184[(22)] = inst_25008);

(statearr_25184[(8)] = inst_25003);

(statearr_25184[(13)] = inst_25011);

(statearr_25184[(29)] = inst_25007);

return statearr_25184;
})();
if(cljs.core.truth_(inst_25012)){
var statearr_25185_25308 = state_25139__$1;
(statearr_25185_25308[(1)] = (24));

} else {
var statearr_25186_25309 = state_25139__$1;
(statearr_25186_25309[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (36))){
var inst_24993 = (state_25139[(11)]);
var inst_25025 = (inst_24993 - (1));
var state_25139__$1 = state_25139;
var statearr_25187_25310 = state_25139__$1;
(statearr_25187_25310[(2)] = inst_25025);

(statearr_25187_25310[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (41))){
var inst_25091 = (state_25139[(2)]);
var state_25139__$1 = state_25139;
var statearr_25188_25311 = state_25139__$1;
(statearr_25188_25311[(2)] = inst_25091);

(statearr_25188_25311[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (43))){
var inst_24993 = (state_25139[(11)]);
var inst_25039 = (state_25139[(30)]);
var inst_25042 = cljs.core.drop.call(null,inst_24993,inst_25039);
var state_25139__$1 = state_25139;
var statearr_25189_25312 = state_25139__$1;
(statearr_25189_25312[(2)] = inst_25042);

(statearr_25189_25312[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (61))){
var inst_25008 = (state_25139[(22)]);
var inst_25055 = (state_25139[(7)]);
var inst_24993 = (state_25139[(11)]);
var inst_25070 = cljs.core.count.call(null,inst_25055);
var inst_25071 = (inst_25008 - inst_25070);
var inst_25072 = (inst_24993 - inst_25071);
var state_25139__$1 = state_25139;
var statearr_25190_25313 = state_25139__$1;
(statearr_25190_25313[(2)] = inst_25072);

(statearr_25190_25313[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (29))){
var inst_25019 = (state_25139[(2)]);
var state_25139__$1 = state_25139;
if(cljs.core.truth_(inst_25019)){
var statearr_25191_25314 = state_25139__$1;
(statearr_25191_25314[(1)] = (30));

} else {
var statearr_25192_25315 = state_25139__$1;
(statearr_25192_25315[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (44))){
var inst_25039 = (state_25139[(30)]);
var state_25139__$1 = state_25139;
var statearr_25193_25316 = state_25139__$1;
(statearr_25193_25316[(2)] = inst_25039);

(statearr_25193_25316[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (6))){
var inst_24932 = (state_25139[(31)]);
var inst_24932__$1 = fluree.db.query.fql.build_order_fn.call(null,orderBy,groupBy);
var inst_24934 = fluree.db.query.fql.ad_hoc_group_by.call(null,res,groupBy);
var state_25139__$1 = (function (){var statearr_25194 = state_25139;
(statearr_25194[(32)] = inst_24934);

(statearr_25194[(31)] = inst_24932__$1);

return statearr_25194;
})();
if(cljs.core.truth_(inst_24932__$1)){
var statearr_25195_25317 = state_25139__$1;
(statearr_25195_25317[(1)] = (9));

} else {
var statearr_25196_25318 = state_25139__$1;
(statearr_25196_25318[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (28))){
var inst_24992 = (state_25139[(12)]);
var state_25139__$1 = state_25139;
var statearr_25197_25319 = state_25139__$1;
(statearr_25197_25319[(2)] = inst_24992);

(statearr_25197_25319[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (64))){
var inst_24994 = (state_25139[(9)]);
var state_25139__$1 = state_25139;
var statearr_25198_25320 = state_25139__$1;
(statearr_25198_25320[(2)] = inst_24994);

(statearr_25198_25320[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (51))){
var inst_24992 = (state_25139[(12)]);
var inst_25055 = (state_25139[(2)]);
var inst_25056 = (inst_24992 == null);
var state_25139__$1 = (function (){var statearr_25199 = state_25139;
(statearr_25199[(7)] = inst_25055);

return statearr_25199;
})();
if(cljs.core.truth_(inst_25056)){
var statearr_25200_25321 = state_25139__$1;
(statearr_25200_25321[(1)] = (52));

} else {
var statearr_25201_25322 = state_25139__$1;
(statearr_25201_25322[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (25))){
var inst_24992 = (state_25139[(12)]);
var state_25139__$1 = state_25139;
if(cljs.core.truth_(inst_24992)){
var statearr_25202_25323 = state_25139__$1;
(statearr_25202_25323[(1)] = (27));

} else {
var statearr_25203_25324 = state_25139__$1;
(statearr_25203_25324[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (34))){
var state_25139__$1 = state_25139;
var statearr_25204_25325 = state_25139__$1;
(statearr_25204_25325[(1)] = (39));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (17))){
var state_25139__$1 = state_25139;
var statearr_25206_25326 = state_25139__$1;
(statearr_25206_25326[(2)] = limit);

(statearr_25206_25326[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (3))){
var inst_25137 = (state_25139[(2)]);
var state_25139__$1 = state_25139;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25139__$1,inst_25137);
} else {
if((state_val_25140 === (12))){
var inst_24940 = (state_25139[(23)]);
var inst_24942 = cljs.core.keys.call(null,inst_24940);
var inst_24943 = cljs.core.first.call(null,inst_24942);
var inst_24944 = [new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.Keyword(null,"vars","vars",-2046957217),new cljs.core.Keyword(null,"tuples","tuples",-676032639)];
var inst_24945 = cljs.core.vals.call(null,inst_24940);
var inst_24946 = cljs.core.first.call(null,inst_24945);
var inst_24947 = [headers,vars,inst_24946];
var inst_24948 = cljs.core.PersistentHashMap.fromArrays(inst_24944,inst_24947);
var inst_24949 = fluree.db.query.fql.process_ad_hoc_group.call(null,db,inst_24948,select_spec,limit,opts);
var state_25139__$1 = (function (){var statearr_25207 = state_25139;
(statearr_25207[(15)] = inst_24943);

return statearr_25207;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25139__$1,(15),inst_24949);
} else {
if((state_val_25140 === (2))){
var _ = (function (){var statearr_25208 = state_25139;
(statearr_25208[(4)] = cljs.core.cons.call(null,(5),(state_25139[(4)])));

return statearr_25208;
})();
var state_25139__$1 = state_25139;
if(cljs.core.truth_(groupBy)){
var statearr_25209_25327 = state_25139__$1;
(statearr_25209_25327[(1)] = (6));

} else {
var statearr_25210_25328 = state_25139__$1;
(statearr_25210_25328[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (66))){
var inst_25004 = (state_25139[(28)]);
var inst_25079 = (state_25139[(33)]);
var inst_25062 = (state_25139[(14)]);
var inst_25007 = (state_25139[(29)]);
var inst_25087 = (state_25139[(2)]);
var inst_24990 = inst_25004;
var inst_24991 = inst_25007;
var inst_24992 = inst_25062;
var inst_24993 = inst_25079;
var inst_24994 = inst_25087;
var state_25139__$1 = (function (){var statearr_25211 = state_25139;
(statearr_25211[(20)] = inst_24990);

(statearr_25211[(12)] = inst_24992);

(statearr_25211[(21)] = inst_24991);

(statearr_25211[(9)] = inst_24994);

(statearr_25211[(11)] = inst_24993);

return statearr_25211;
})();
var statearr_25212_25329 = state_25139__$1;
(statearr_25212_25329[(2)] = null);

(statearr_25212_25329[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (23))){
var inst_25099 = (state_25139[(2)]);
var state_25139__$1 = state_25139;
var statearr_25213_25330 = state_25139__$1;
(statearr_25213_25330[(2)] = inst_25099);

(statearr_25213_25330[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (47))){
var inst_24992 = (state_25139[(12)]);
var state_25139__$1 = state_25139;
var statearr_25214_25331 = state_25139__$1;
(statearr_25214_25331[(2)] = inst_24992);

(statearr_25214_25331[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (35))){
var inst_25093 = (state_25139[(2)]);
var state_25139__$1 = state_25139;
var statearr_25215_25332 = state_25139__$1;
(statearr_25215_25332[(2)] = inst_25093);

(statearr_25215_25332[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (82))){
var inst_25128 = (state_25139[(2)]);
var state_25139__$1 = state_25139;
var statearr_25216_25333 = state_25139__$1;
(statearr_25216_25333[(2)] = inst_25128);

(statearr_25216_25333[(1)] = (79));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (76))){
var inst_25120 = (state_25139[(2)]);
var state_25139__$1 = state_25139;
var statearr_25217_25334 = state_25139__$1;
(statearr_25217_25334[(2)] = inst_25120);

(statearr_25217_25334[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (19))){
var inst_24984 = (state_25139[(34)]);
var state_25139__$1 = state_25139;
var statearr_25218_25335 = state_25139__$1;
(statearr_25218_25335[(2)] = inst_24984);

(statearr_25218_25335[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (57))){
var inst_25055 = (state_25139[(7)]);
var inst_25079 = (state_25139[(2)]);
var inst_25080 = (inst_25055 == null);
var inst_25081 = cljs.core.empty_QMARK_.call(null,inst_25055);
var inst_25082 = ((inst_25080) || (inst_25081));
var state_25139__$1 = (function (){var statearr_25219 = state_25139;
(statearr_25219[(33)] = inst_25079);

return statearr_25219;
})();
if(cljs.core.truth_(inst_25082)){
var statearr_25220_25336 = state_25139__$1;
(statearr_25220_25336[(1)] = (64));

} else {
var statearr_25221_25337 = state_25139__$1;
(statearr_25221_25337[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (68))){
var state_25139__$1 = state_25139;
var statearr_25222_25338 = state_25139__$1;
(statearr_25222_25338[(2)] = limit);

(statearr_25222_25338[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (11))){
var inst_24940 = (state_25139[(2)]);
var state_25139__$1 = (function (){var statearr_25224 = state_25139;
(statearr_25224[(23)] = inst_24940);

return statearr_25224;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_25225_25339 = state_25139__$1;
(statearr_25225_25339[(1)] = (12));

} else {
var statearr_25226_25340 = state_25139__$1;
(statearr_25226_25340[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (9))){
var inst_24934 = (state_25139[(32)]);
var inst_24932 = (state_25139[(31)]);
var inst_24936 = cljs.core.sorted_map_by.call(null,inst_24932);
var inst_24937 = cljs.core.into.call(null,inst_24936,inst_24934);
var state_25139__$1 = state_25139;
var statearr_25227_25341 = state_25139__$1;
(statearr_25227_25341[(2)] = inst_24937);

(statearr_25227_25341[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (5))){
var _ = (function (){var statearr_25228 = state_25139;
(statearr_25228[(4)] = cljs.core.rest.call(null,(state_25139[(4)])));

return statearr_25228;
})();
var state_25139__$1 = state_25139;
var ex25223 = (state_25139__$1[(2)]);
var statearr_25229_25342 = state_25139__$1;
(statearr_25229_25342[(5)] = ex25223);


if((ex25223 instanceof Error)){
var statearr_25230_25343 = state_25139__$1;
(statearr_25230_25343[(1)] = (4));

(statearr_25230_25343[(5)] = null);

} else {
throw ex25223;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (14))){
var inst_25101 = (state_25139[(2)]);
var state_25139__$1 = state_25139;
var statearr_25231_25344 = state_25139__$1;
(statearr_25231_25344[(2)] = inst_25101);

(statearr_25231_25344[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (45))){
var inst_24992 = (state_25139[(12)]);
var inst_25045 = (state_25139[(2)]);
var state_25139__$1 = (function (){var statearr_25232 = state_25139;
(statearr_25232[(16)] = inst_25045);

return statearr_25232;
})();
if(cljs.core.truth_(inst_24992)){
var statearr_25233_25345 = state_25139__$1;
(statearr_25233_25345[(1)] = (46));

} else {
var statearr_25234_25346 = state_25139__$1;
(statearr_25234_25346[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (53))){
var inst_24992 = (state_25139[(12)]);
var inst_25055 = (state_25139[(7)]);
var inst_25059 = cljs.core.count.call(null,inst_25055);
var inst_25060 = (inst_24992 - inst_25059);
var state_25139__$1 = state_25139;
var statearr_25235_25347 = state_25139__$1;
(statearr_25235_25347[(2)] = inst_25060);

(statearr_25235_25347[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (78))){
var state_25139__$1 = state_25139;
var statearr_25236_25348 = state_25139__$1;
(statearr_25236_25348[(1)] = (80));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (26))){
var inst_25097 = (state_25139[(2)]);
var state_25139__$1 = state_25139;
var statearr_25238_25349 = state_25139__$1;
(statearr_25238_25349[(2)] = inst_25097);

(statearr_25238_25349[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (16))){
var state_25139__$1 = state_25139;
var statearr_25239_25350 = state_25139__$1;
(statearr_25239_25350[(2)] = null);

(statearr_25239_25350[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (81))){
var state_25139__$1 = state_25139;
var statearr_25242_25351 = state_25139__$1;
(statearr_25242_25351[(2)] = null);

(statearr_25242_25351[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (79))){
var inst_25130 = (state_25139[(2)]);
var state_25139__$1 = state_25139;
var statearr_25243_25352 = state_25139__$1;
(statearr_25243_25352[(2)] = inst_25130);

(statearr_25243_25352[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (38))){
var inst_25004 = (state_25139[(28)]);
var inst_24992 = (state_25139[(12)]);
var inst_24994 = (state_25139[(9)]);
var inst_25007 = (state_25139[(29)]);
var inst_25029 = (state_25139[(2)]);
var tmp25240 = inst_24992;
var tmp25241 = inst_24994;
var inst_24990 = inst_25004;
var inst_24991 = inst_25007;
var inst_24992__$1 = tmp25240;
var inst_24993 = inst_25029;
var inst_24994__$1 = tmp25241;
var state_25139__$1 = (function (){var statearr_25244 = state_25139;
(statearr_25244[(20)] = inst_24990);

(statearr_25244[(12)] = inst_24992__$1);

(statearr_25244[(21)] = inst_24991);

(statearr_25244[(9)] = inst_24994__$1);

(statearr_25244[(11)] = inst_24993);

return statearr_25244;
})();
var statearr_25245_25353 = state_25139__$1;
(statearr_25245_25353[(2)] = null);

(statearr_25245_25353[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (30))){
var inst_24994 = (state_25139[(9)]);
var state_25139__$1 = state_25139;
var statearr_25246_25354 = state_25139__$1;
(statearr_25246_25354[(2)] = inst_24994);

(statearr_25246_25354[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (73))){
var inst_25132 = (state_25139[(2)]);
var state_25139__$1 = state_25139;
var statearr_25247_25355 = state_25139__$1;
(statearr_25247_25355[(2)] = inst_25132);

(statearr_25247_25355[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (10))){
var inst_24934 = (state_25139[(32)]);
var state_25139__$1 = state_25139;
var statearr_25248_25356 = state_25139__$1;
(statearr_25248_25356[(2)] = inst_24934);

(statearr_25248_25356[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (18))){
var inst_24984 = (state_25139[(34)]);
var inst_24983 = (state_25139[(2)]);
var inst_24984__$1 = offset;
var state_25139__$1 = (function (){var statearr_25249 = state_25139;
(statearr_25249[(34)] = inst_24984__$1);

(statearr_25249[(18)] = inst_24983);

return statearr_25249;
})();
if(cljs.core.truth_(inst_24984__$1)){
var statearr_25250_25357 = state_25139__$1;
(statearr_25250_25357[(1)] = (19));

} else {
var statearr_25251_25358 = state_25139__$1;
(statearr_25251_25358[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (52))){
var state_25139__$1 = state_25139;
var statearr_25252_25359 = state_25139__$1;
(statearr_25252_25359[(2)] = null);

(statearr_25252_25359[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (67))){
var state_25139__$1 = state_25139;
var statearr_25253_25360 = state_25139__$1;
(statearr_25253_25360[(2)] = (1));

(statearr_25253_25360[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (71))){
var state_25139__$1 = state_25139;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_25254_25361 = state_25139__$1;
(statearr_25254_25361[(1)] = (74));

} else {
var statearr_25255_25362 = state_25139__$1;
(statearr_25255_25362[(1)] = (75));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (42))){
var inst_24993 = (state_25139[(11)]);
var inst_25038 = (state_25139[(2)]);
var inst_25039 = fluree.db.util.async.throw_err.call(null,inst_25038);
var inst_25040 = ((0) < inst_24993);
var state_25139__$1 = (function (){var statearr_25256 = state_25139;
(statearr_25256[(30)] = inst_25039);

return statearr_25256;
})();
if(cljs.core.truth_(inst_25040)){
var statearr_25257_25363 = state_25139__$1;
(statearr_25257_25363[(1)] = (43));

} else {
var statearr_25258_25364 = state_25139__$1;
(statearr_25258_25364[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (80))){
var inst_25110 = (state_25139[(10)]);
var state_25139__$1 = state_25139;
var statearr_25259_25365 = state_25139__$1;
(statearr_25259_25365[(2)] = inst_25110);

(statearr_25259_25365[(1)] = (82));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (37))){
var inst_25008 = (state_25139[(22)]);
var inst_24993 = (state_25139[(11)]);
var inst_25027 = (inst_24993 - inst_25008);
var state_25139__$1 = state_25139;
var statearr_25260_25366 = state_25139__$1;
(statearr_25260_25366[(2)] = inst_25027);

(statearr_25260_25366[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (63))){
var inst_25075 = (state_25139[(2)]);
var state_25139__$1 = state_25139;
var statearr_25261_25367 = state_25139__$1;
(statearr_25261_25367[(2)] = inst_25075);

(statearr_25261_25367[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (8))){
var inst_25134 = (state_25139[(2)]);
var _ = (function (){var statearr_25262 = state_25139;
(statearr_25262[(4)] = cljs.core.rest.call(null,(state_25139[(4)])));

return statearr_25262;
})();
var state_25139__$1 = state_25139;
var statearr_25263_25368 = state_25139__$1;
(statearr_25263_25368[(2)] = inst_25134);

(statearr_25263_25368[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25140 === (49))){
var inst_24992 = (state_25139[(12)]);
var inst_25045 = (state_25139[(16)]);
var inst_25052 = cljs.core.take.call(null,inst_24992,inst_25045);
var state_25139__$1 = state_25139;
var statearr_25264_25369 = state_25139__$1;
(statearr_25264_25369[(2)] = inst_25052);

(statearr_25264_25369[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto____0 = (function (){
var statearr_25265 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25265[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto__);

(statearr_25265[(1)] = (1));

return statearr_25265;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto____1 = (function (state_25139){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_25139);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e25266){var ex__2882__auto__ = e25266;
var statearr_25267_25370 = state_25139;
(statearr_25267_25370[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_25139[(4)]))){
var statearr_25268_25371 = state_25139;
(statearr_25268_25371[(1)] = cljs.core.first.call(null,(state_25139[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25372 = state_25139;
state_25139 = G__25372;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto__ = function(state_25139){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto____1.call(this,state_25139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_25269 = f__2902__auto__.call(null);
(statearr_25269[(6)] = c__2901__auto__);

return statearr_25269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__25375,opts){
var map__25376 = p__25375;
var map__25376__$1 = (((((!((map__25376 == null))))?(((((map__25376.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25376.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25376):map__25376);
var selectOne = cljs.core.get.call(null,map__25376__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var select = cljs.core.get.call(null,map__25376__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var selectDistinct = cljs.core.get.call(null,map__25376__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var selectReduced = cljs.core.get.call(null,map__25376__$1,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var select_smt = (function (){var or__4126__auto__ = selectOne;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = select;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
var or__4126__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4126__auto____$2)){
return or__4126__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_.call(null,select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select.call(null,headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.call(null,(function (p1__25373_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__25373_SHARP_,new cljs.core.Keyword(null,"code","code",1586293142));
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some.call(null,(function (p1__25374_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__25374_SHARP_,new cljs.core.Keyword(null,"selection","selection",975998651));
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_.call(null,aggregates))?null:aggregates);
var orderBy = (function (){var temp__5735__auto__ = new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5735__auto__)){
var orderBy = temp__5735__auto__;
if(cljs.core.truth_((function (){var or__4126__auto__ = typeof orderBy === 'string';
if(or__4126__auto__){
return or__4126__auto__;
} else {
if(cljs.core.vector_QMARK_.call(null,orderBy)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null).call(null,cljs.core.first.call(null,orderBy));
} else {
return false;
}
}
})())){
if(cljs.core.vector_QMARK_.call(null,orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.call(null,["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"expandMaps?","expandMaps?",-1946388444),new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311),new cljs.core.Keyword(null,"aggregates","aggregates",-1684250289),new cljs.core.Keyword(null,"selectOne?","selectOne?",-1041343472),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),new cljs.core.Keyword(null,"selectDistinct?","selectDistinct?",-1672346731),new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"inVector?","inVector?",1948069375)],[expandMap_QMARK_,(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (100);
}
})(),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"offset","offset",296498311).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$.call(null,selectOne),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return false;
}
})(),new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667).cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$.call(null,(function (){var or__4126__auto__ = selectDistinct;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__25378,p__25379){
var map__25380 = p__25378;
var map__25380__$1 = (((((!((map__25380 == null))))?(((((map__25380.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25380.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25380):map__25380);
var query_map = map__25380__$1;
var construct = cljs.core.get.call(null,map__25380__$1,new cljs.core.Keyword(null,"construct","construct",692547932));
var map__25381 = p__25379;
var map__25381__$1 = (((((!((map__25381 == null))))?(((((map__25381.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25381.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25381):map__25381);
var where_result = map__25381__$1;
var headers = cljs.core.get.call(null,map__25381__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var tuples = cljs.core.get.call(null,map__25381__$1,new cljs.core.Keyword(null,"tuples","tuples",-676032639));
var vec__25384 = cljs.core.map.call(null,(function (construct_item){
var temp__5733__auto__ = fluree.db.util.core.index_of.call(null,headers,cljs.core.symbol.call(null,construct_item));
if(cljs.core.truth_(temp__5733__auto__)){
var index_of = temp__5733__auto__;
return (function (row){
return cljs.core.nth.call(null,row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.call(null,vec__25384,(0),null);
var fn2 = cljs.core.nth.call(null,vec__25384,(1),null);
var fn3 = cljs.core.nth.call(null,vec__25384,(2),null);
return cljs.core.map.call(null,(function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fn1.call(null,res),fn2.call(null,res),fn3.call(null,res)], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_25417){
var state_val_25418 = (state_25417[(1)]);
if((state_val_25418 === (7))){
var inst_25396 = (state_25417[(7)]);
var state_25417__$1 = state_25417;
var statearr_25419_25442 = state_25417__$1;
(statearr_25419_25442[(2)] = inst_25396);

(statearr_25419_25442[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25418 === (1))){
var state_25417__$1 = state_25417;
var statearr_25420_25443 = state_25417__$1;
(statearr_25420_25443[(2)] = null);

(statearr_25420_25443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25418 === (4))){
var inst_25387 = (state_25417[(2)]);
var state_25417__$1 = state_25417;
var statearr_25421_25444 = state_25417__$1;
(statearr_25421_25444[(2)] = inst_25387);

(statearr_25421_25444[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25418 === (13))){
var inst_25406 = (state_25417[(2)]);
var inst_25407 = fluree.db.util.async.throw_err.call(null,inst_25406);
var state_25417__$1 = state_25417;
var statearr_25422_25445 = state_25417__$1;
(statearr_25422_25445[(2)] = inst_25407);

(statearr_25422_25445[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25418 === (6))){
var inst_25396 = (state_25417[(7)]);
var inst_25395 = (state_25417[(2)]);
var inst_25396__$1 = fluree.db.util.async.throw_err.call(null,inst_25395);
var inst_25397 = fluree.db.util.core.exception_QMARK_.call(null,inst_25396__$1);
var state_25417__$1 = (function (){var statearr_25423 = state_25417;
(statearr_25423[(7)] = inst_25396__$1);

return statearr_25423;
})();
if(inst_25397){
var statearr_25424_25446 = state_25417__$1;
(statearr_25424_25446[(1)] = (7));

} else {
var statearr_25425_25447 = state_25417__$1;
(statearr_25425_25447[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25418 === (3))){
var inst_25415 = (state_25417[(2)]);
var state_25417__$1 = state_25417;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25417__$1,inst_25415);
} else {
if((state_val_25418 === (12))){
var inst_25410 = (state_25417[(2)]);
var state_25417__$1 = state_25417;
var statearr_25426_25448 = state_25417__$1;
(statearr_25426_25448[(2)] = inst_25410);

(statearr_25426_25448[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25418 === (2))){
var _ = (function (){var statearr_25427 = state_25417;
(statearr_25427[(4)] = cljs.core.cons.call(null,(5),(state_25417[(4)])));

return statearr_25427;
})();
var inst_25393 = fluree.db.query.analytical.q.call(null,query_map,fuel,max_fuel,db,opts);
var state_25417__$1 = state_25417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25417__$1,(6),inst_25393);
} else {
if((state_val_25418 === (11))){
var state_25417__$1 = state_25417;
var statearr_25429_25449 = state_25417__$1;
(statearr_25429_25449[(2)] = null);

(statearr_25429_25449[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25418 === (9))){
var inst_25412 = (state_25417[(2)]);
var _ = (function (){var statearr_25430 = state_25417;
(statearr_25430[(4)] = cljs.core.rest.call(null,(state_25417[(4)])));

return statearr_25430;
})();
var state_25417__$1 = state_25417;
var statearr_25431_25450 = state_25417__$1;
(statearr_25431_25450[(2)] = inst_25412);

(statearr_25431_25450[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25418 === (5))){
var _ = (function (){var statearr_25432 = state_25417;
(statearr_25432[(4)] = cljs.core.rest.call(null,(state_25417[(4)])));

return statearr_25432;
})();
var state_25417__$1 = state_25417;
var ex25428 = (state_25417__$1[(2)]);
var statearr_25433_25451 = state_25417__$1;
(statearr_25433_25451[(5)] = ex25428);


if((ex25428 instanceof Error)){
var statearr_25434_25452 = state_25417__$1;
(statearr_25434_25452[(1)] = (4));

(statearr_25434_25452[(5)] = null);

} else {
throw ex25428;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25418 === (10))){
var inst_25396 = (state_25417[(7)]);
var inst_25401 = new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(inst_25396);
var inst_25402 = new cljs.core.Keyword(null,"vars","vars",-2046957217).cljs$core$IFn$_invoke$arity$1(inst_25396);
var inst_25403 = fluree.db.query.fql.get_ad_hoc_select_spec.call(null,inst_25401,inst_25402,query_map,opts);
var inst_25404 = fluree.db.query.fql.process_ad_hoc_res.call(null,db,inst_25396,inst_25403,opts);
var state_25417__$1 = state_25417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25417__$1,(13),inst_25404);
} else {
if((state_val_25418 === (8))){
var state_25417__$1 = state_25417;
var statearr_25435_25453 = state_25417__$1;
(statearr_25435_25453[(1)] = (10));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto____0 = (function (){
var statearr_25437 = [null,null,null,null,null,null,null,null];
(statearr_25437[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto__);

(statearr_25437[(1)] = (1));

return statearr_25437;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto____1 = (function (state_25417){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_25417);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e25438){var ex__2882__auto__ = e25438;
var statearr_25439_25454 = state_25417;
(statearr_25439_25454[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_25417[(4)]))){
var statearr_25440_25455 = state_25417;
(statearr_25440_25455[(1)] = cljs.core.first.call(null,(state_25417[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__25456 = state_25417;
state_25417 = G__25456;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto__ = function(state_25417){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto____1.call(this,state_25417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_25441 = f__2902__auto__.call(null);
(statearr_25441[(6)] = c__2901__auto__);

return statearr_25441;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns core async channel with results
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__25457 = query_map;
var map__25457__$1 = (((((!((map__25457 == null))))?(((((map__25457.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__25457.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__25457):map__25457);
var select = cljs.core.get.call(null,map__25457__$1,new cljs.core.Keyword(null,"select","select",1147833503));
var orderBy = cljs.core.get.call(null,map__25457__$1,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var where = cljs.core.get.call(null,map__25457__$1,new cljs.core.Keyword(null,"where","where",-2044795965));
var limit = cljs.core.get.call(null,map__25457__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var offset = cljs.core.get.call(null,map__25457__$1,new cljs.core.Keyword(null,"offset","offset",296498311));
var component = cljs.core.get.call(null,map__25457__$1,new cljs.core.Keyword(null,"component","component",1555936782));
var selectDistinct = cljs.core.get.call(null,map__25457__$1,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var prettyPrint = cljs.core.get.call(null,map__25457__$1,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var selectOne = cljs.core.get.call(null,map__25457__$1,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var from = cljs.core.get.call(null,map__25457__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var opts = cljs.core.get.call(null,map__25457__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var groupBy = cljs.core.get.call(null,map__25457__$1,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667));
var opts_SINGLEQUOTE_ = (function (){var G__25459 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"limit","limit",-1355822363),limit,new cljs.core.Keyword(null,"offset","offset",296498311),(function (){var or__4126__auto__ = offset;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (0);
}
})(),new cljs.core.Keyword(null,"component","component",1555936782),component,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),orderBy,new cljs.core.Keyword(null,"groupBy","groupBy",-1581230667),groupBy,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),prettyPrint], null),opts);
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.call(null,G__25459,new cljs.core.Keyword(null,"limit","limit",-1355822363),(1));
} else {
return G__25459;
}
})();
var max_fuel = new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012).cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4126__auto__ = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if(cljs.core.truth_((function (){var or__4126__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_.call(null,(0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_.call(null,where)){
return fluree.db.query.fql.ad_hoc_query.call(null,db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_25827){
var state_val_25828 = (state_25827[(1)]);
if((state_val_25828 === (121))){
var inst_25539 = (state_25827[(7)]);
var inst_25768 = (state_25827[(8)]);
var inst_25772 = (state_25827[(9)]);
var inst_25541 = (state_25827[(10)]);
var inst_25776 = (state_25827[(2)]);
var inst_25777 = fluree.db.query.fql.subject_select.call(null,db,inst_25541,fuel,max_fuel,inst_25539,inst_25768,inst_25772,inst_25776);
var state_25827__$1 = state_25827;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25827__$1,(115),inst_25777);
} else {
if((state_val_25828 === (65))){
var inst_25539 = (state_25827[(7)]);
var inst_25541 = (state_25827[(10)]);
var inst_25618 = (state_25827[(11)]);
var inst_25529 = (state_25827[(12)]);
var inst_25632 = (state_25827[(2)]);
var inst_25633 = fluree.db.util.async.throw_err.call(null,inst_25632);
var inst_25634 = cljs.core.sequence.call(null,inst_25618,inst_25633);
var inst_25635 = fluree.db.query.fql.subject_select.call(null,db,inst_25541,fuel,max_fuel,inst_25539,inst_25634,inst_25529);
var state_25827__$1 = state_25827;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25827__$1,(66),inst_25635);
} else {
if((state_val_25828 === (70))){
var inst_25528 = (state_25827[(13)]);
var state_25827__$1 = state_25827;
if(cljs.core.truth_(inst_25528)){
var statearr_25829_26021 = state_25827__$1;
(statearr_25829_26021[(1)] = (73));

} else {
var statearr_25830_26022 = state_25827__$1;
(statearr_25830_26022[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (62))){
var inst_25620 = cljs.core.PersistentHashMap.EMPTY;
var state_25827__$1 = state_25827;
var statearr_25831_26023 = state_25827__$1;
(statearr_25831_26023[(2)] = inst_25620);

(statearr_25831_26023[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (74))){
var inst_25531 = (state_25827[(14)]);
var inst_25529 = (state_25827[(12)]);
var inst_25653 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25654 = [inst_25529,inst_25531];
var inst_25655 = cljs.core.PersistentHashMap.fromArrays(inst_25653,inst_25654);
var state_25827__$1 = state_25827;
var statearr_25832_26024 = state_25827__$1;
(statearr_25832_26024[(2)] = inst_25655);

(statearr_25832_26024[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (110))){
var inst_25736 = (state_25827[(15)]);
var inst_25750 = (state_25827[(2)]);
var inst_25751 = fluree.db.dbproto._subid.call(null,db,inst_25736,false);
var state_25827__$1 = (function (){var statearr_25833 = state_25827;
(statearr_25833[(16)] = inst_25750);

return statearr_25833;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25827__$1,(111),inst_25751);
} else {
if((state_val_25828 === (130))){
var inst_25817 = (state_25827[(2)]);
var state_25827__$1 = state_25827;
if(cljs.core.truth_(inst_25817)){
var statearr_25834_26025 = state_25827__$1;
(statearr_25834_26025[(1)] = (131));

} else {
var statearr_25835_26026 = state_25827__$1;
(statearr_25835_26026[(1)] = (132));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (128))){
var inst_25808 = (state_25827[(17)]);
var inst_25811 = cljs.core.coll_QMARK_.call(null,inst_25808);
var inst_25812 = fluree.db.util.core.exception_QMARK_.call(null,inst_25808);
var inst_25813 = (!(inst_25812));
var inst_25814 = ((inst_25811) && (inst_25813));
var state_25827__$1 = state_25827;
var statearr_25836_26027 = state_25827__$1;
(statearr_25836_26027[(2)] = inst_25814);

(statearr_25836_26027[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (7))){
var inst_25489 = (state_25827[(18)]);
var inst_25489__$1 = selectOne;
var state_25827__$1 = (function (){var statearr_25837 = state_25827;
(statearr_25837[(18)] = inst_25489__$1);

return statearr_25837;
})();
if(cljs.core.truth_(inst_25489__$1)){
var statearr_25838_26028 = state_25827__$1;
(statearr_25838_26028[(1)] = (9));

} else {
var statearr_25839_26029 = state_25827__$1;
(statearr_25839_26029[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (59))){
var inst_25612 = (state_25827[(19)]);
var inst_25614 = cljs.core.distinct.call(null);
var inst_25615 = cljs.core.comp.call(null,inst_25612,inst_25614);
var state_25827__$1 = state_25827;
var statearr_25840_26030 = state_25827__$1;
(statearr_25840_26030[(2)] = inst_25615);

(statearr_25840_26030[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (86))){
var inst_25689 = fluree.db.dbproto._subid.call(null,db,from,false);
var state_25827__$1 = state_25827;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25827__$1,(89),inst_25689);
} else {
if((state_val_25828 === (20))){
var inst_25519 = (state_25827[(2)]);
var state_25827__$1 = state_25827;
var statearr_25841_26031 = state_25827__$1;
(statearr_25841_26031[(2)] = inst_25519);

(statearr_25841_26031[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (72))){
var inst_25799 = (state_25827[(2)]);
var state_25827__$1 = state_25827;
var statearr_25842_26032 = state_25827__$1;
(statearr_25842_26032[(2)] = inst_25799);

(statearr_25842_26032[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (58))){
var inst_25612 = (state_25827[(2)]);
var state_25827__$1 = (function (){var statearr_25843 = state_25827;
(statearr_25843[(19)] = inst_25612);

return statearr_25843;
})();
var statearr_25844_26033 = state_25827__$1;
(statearr_25844_26033[(1)] = (59));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (60))){
var inst_25612 = (state_25827[(19)]);
var state_25827__$1 = state_25827;
var statearr_25846_26034 = state_25827__$1;
(statearr_25846_26034[(2)] = inst_25612);

(statearr_25846_26034[(1)] = (61));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (27))){
var inst_25528 = (state_25827[(13)]);
var inst_25543 = cljs.core.vector_QMARK_.call(null,inst_25528);
var state_25827__$1 = state_25827;
if(inst_25543){
var statearr_25847_26035 = state_25827__$1;
(statearr_25847_26035[(1)] = (30));

} else {
var statearr_25848_26036 = state_25827__$1;
(statearr_25848_26036[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (1))){
var state_25827__$1 = state_25827;
var statearr_25849_26037 = state_25827__$1;
(statearr_25849_26037[(2)] = null);

(statearr_25849_26037[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (69))){
var inst_25648 = (state_25827[(2)]);
var state_25827__$1 = state_25827;
if(cljs.core.truth_(inst_25648)){
var statearr_25850_26038 = state_25827__$1;
(statearr_25850_26038[(1)] = (70));

} else {
var statearr_25851_26039 = state_25827__$1;
(statearr_25851_26039[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (101))){
var inst_25528 = (state_25827[(13)]);
var inst_25766 = (state_25827[(2)]);
var inst_25767 = cljs.core.PersistentVector.EMPTY;
var inst_25768 = cljs.core.into.call(null,inst_25767,inst_25766);
var state_25827__$1 = (function (){var statearr_25852 = state_25827;
(statearr_25852[(8)] = inst_25768);

return statearr_25852;
})();
if(cljs.core.truth_(inst_25528)){
var statearr_25853_26040 = state_25827__$1;
(statearr_25853_26040[(1)] = (116));

} else {
var statearr_25854_26041 = state_25827__$1;
(statearr_25854_26041[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (24))){
var inst_25532 = (state_25827[(20)]);
var inst_25530 = (state_25827[(21)]);
var inst_25536 = cljs.core.assoc.call(null,inst_25532,new cljs.core.Keyword(null,"componentFollow?","componentFollow?",-1486906651),inst_25530);
var state_25827__$1 = state_25827;
var statearr_25855_26042 = state_25827__$1;
(statearr_25855_26042[(2)] = inst_25536);

(statearr_25855_26042[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (102))){
var inst_25730 = (state_25827[(22)]);
var state_25827__$1 = state_25827;
var statearr_25856_26043 = state_25827__$1;
(statearr_25856_26043[(2)] = inst_25730);

(statearr_25856_26043[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (55))){
var inst_25801 = (state_25827[(2)]);
var state_25827__$1 = state_25827;
var statearr_25857_26044 = state_25827__$1;
(statearr_25857_26044[(2)] = inst_25801);

(statearr_25857_26044[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (85))){
var inst_25683 = (state_25827[(2)]);
var inst_25684 = fluree.db.util.async.throw_err.call(null,inst_25683);
var state_25827__$1 = state_25827;
var statearr_25858_26045 = state_25827__$1;
(statearr_25858_26045[(2)] = inst_25684);

(statearr_25858_26045[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (39))){
var inst_25578 = typeof from === 'string';
var state_25827__$1 = state_25827;
if(cljs.core.truth_(inst_25578)){
var statearr_25859_26046 = state_25827__$1;
(statearr_25859_26046[(1)] = (42));

} else {
var statearr_25860_26047 = state_25827__$1;
(statearr_25860_26047[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (88))){
var inst_25795 = (state_25827[(2)]);
var state_25827__$1 = state_25827;
var statearr_25861_26048 = state_25827__$1;
(statearr_25861_26048[(2)] = inst_25795);

(statearr_25861_26048[(1)] = (80));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (46))){
var inst_25597 = (state_25827[(2)]);
var inst_25598 = fluree.db.util.async.throw_err.call(null,inst_25597);
var state_25827__$1 = state_25827;
var statearr_25862_26049 = state_25827__$1;
(statearr_25862_26049[(2)] = inst_25598);

(statearr_25862_26049[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (4))){
var inst_25476 = (state_25827[(2)]);
var state_25827__$1 = state_25827;
var statearr_25863_26050 = state_25827__$1;
(statearr_25863_26050[(2)] = inst_25476);

(statearr_25863_26050[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (77))){
var inst_25664 = (state_25827[(2)]);
var inst_25665 = fluree.db.util.async.throw_err.call(null,inst_25664);
var state_25827__$1 = state_25827;
var statearr_25864_26051 = state_25827__$1;
(statearr_25864_26051[(2)] = inst_25665);

(statearr_25864_26051[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (106))){
var state_25827__$1 = state_25827;
if(cljs.core.truth_(fuel)){
var statearr_25865_26052 = state_25827__$1;
(statearr_25865_26052[(1)] = (108));

} else {
var statearr_25866_26053 = state_25827__$1;
(statearr_25866_26053[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (119))){
var state_25827__$1 = state_25827;
var statearr_25867_26054 = state_25827__$1;
(statearr_25867_26054[(2)] = null);

(statearr_25867_26054[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (95))){
var state_25827__$1 = state_25827;
var statearr_25868_26055 = state_25827__$1;
(statearr_25868_26055[(2)] = null);

(statearr_25868_26055[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (54))){
var inst_25640 = typeof from === 'string';
var state_25827__$1 = state_25827;
if(cljs.core.truth_(inst_25640)){
var statearr_25869_26056 = state_25827__$1;
(statearr_25869_26056[(1)] = (67));

} else {
var statearr_25870_26057 = state_25827__$1;
(statearr_25870_26057[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (92))){
var inst_25531 = (state_25827[(14)]);
var inst_25539 = (state_25827[(7)]);
var inst_25541 = (state_25827[(10)]);
var inst_25529 = (state_25827[(12)]);
var inst_25700 = (state_25827[(2)]);
var inst_25701 = fluree.db.query.fql.subject_select.call(null,db,inst_25541,fuel,max_fuel,inst_25539,inst_25700,inst_25529,inst_25531);
var state_25827__$1 = state_25827;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25827__$1,(93),inst_25701);
} else {
if((state_val_25828 === (104))){
var inst_25764 = (state_25827[(2)]);
var state_25827__$1 = state_25827;
var statearr_25871_26058 = state_25827__$1;
(statearr_25871_26058[(2)] = inst_25764);

(statearr_25871_26058[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (15))){
var inst_25506 = (state_25827[(23)]);
var inst_25511 = inst_25506.cljs$lang$protocol_mask$partition0$;
var inst_25512 = (inst_25511 & (64));
var inst_25513 = inst_25506.cljs$core$ISeq$;
var inst_25514 = (cljs.core.PROTOCOL_SENTINEL === inst_25513);
var inst_25515 = ((inst_25512) || (inst_25514));
var state_25827__$1 = state_25827;
if(cljs.core.truth_(inst_25515)){
var statearr_25872_26059 = state_25827__$1;
(statearr_25872_26059[(1)] = (18));

} else {
var statearr_25873_26060 = state_25827__$1;
(statearr_25873_26060[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (48))){
var inst_25529 = (state_25827[(12)]);
var state_25827__$1 = state_25827;
var statearr_25874_26061 = state_25827__$1;
(statearr_25874_26061[(2)] = inst_25529);

(statearr_25874_26061[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (50))){
var state_25827__$1 = state_25827;
var statearr_25875_26062 = state_25827__$1;
(statearr_25875_26062[(2)] = null);

(statearr_25875_26062[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (116))){
var state_25827__$1 = state_25827;
var statearr_25876_26063 = state_25827__$1;
(statearr_25876_26063[(2)] = null);

(statearr_25876_26063[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (75))){
var inst_25657 = (state_25827[(2)]);
var inst_25658 = fluree.db.query.range._block_or_tx_collection.call(null,db,inst_25657);
var state_25827__$1 = state_25827;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25827__$1,(76),inst_25658);
} else {
if((state_val_25828 === (99))){
var inst_25793 = (state_25827[(2)]);
var state_25827__$1 = state_25827;
var statearr_25877_26064 = state_25827__$1;
(statearr_25877_26064[(2)] = inst_25793);

(statearr_25877_26064[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (21))){
var inst_25506 = (state_25827[(23)]);
var inst_25524 = cljs.core.apply.call(null,cljs.core.hash_map,inst_25506);
var state_25827__$1 = state_25827;
var statearr_25878_26065 = state_25827__$1;
(statearr_25878_26065[(2)] = inst_25524);

(statearr_25878_26065[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (31))){
var inst_25528 = (state_25827[(13)]);
var inst_25551 = typeof inst_25528 === 'string';
var state_25827__$1 = state_25827;
if(cljs.core.truth_(inst_25551)){
var statearr_25879_26066 = state_25827__$1;
(statearr_25879_26066[(1)] = (33));

} else {
var statearr_25880_26067 = state_25827__$1;
(statearr_25880_26067[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (113))){
var inst_25730 = (state_25827[(22)]);
var state_25827__$1 = state_25827;
var statearr_25881_26068 = state_25827__$1;
(statearr_25881_26068[(2)] = inst_25730);

(statearr_25881_26068[(1)] = (114));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (32))){
var inst_25567 = (state_25827[(2)]);
var state_25827__$1 = state_25827;
var statearr_25882_26069 = state_25827__$1;
(statearr_25882_26069[(2)] = inst_25567);

(statearr_25882_26069[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (40))){
var inst_25600 = typeof from === 'string';
var inst_25601 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_25602 = clojure.string.includes_QMARK_.call(null,inst_25601,"/");
var inst_25603 = ((inst_25600) && (inst_25602));
var state_25827__$1 = state_25827;
if(cljs.core.truth_(inst_25603)){
var statearr_25883_26070 = state_25827__$1;
(statearr_25883_26070[(1)] = (53));

} else {
var statearr_25884_26071 = state_25827__$1;
(statearr_25884_26071[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (129))){
var inst_25809 = (state_25827[(24)]);
var state_25827__$1 = state_25827;
var statearr_25885_26072 = state_25827__$1;
(statearr_25885_26072[(2)] = inst_25809);

(statearr_25885_26072[(1)] = (130));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (91))){
var inst_25692 = (state_25827[(25)]);
var inst_25696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25697 = [inst_25692];
var inst_25698 = (new cljs.core.PersistentVector(null,1,(5),inst_25696,inst_25697,null));
var state_25827__$1 = state_25827;
var statearr_25886_26073 = state_25827__$1;
(statearr_25886_26073[(2)] = inst_25698);

(statearr_25886_26073[(1)] = (92));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (117))){
var inst_25529 = (state_25827[(12)]);
var state_25827__$1 = state_25827;
var statearr_25887_26074 = state_25827__$1;
(statearr_25887_26074[(2)] = inst_25529);

(statearr_25887_26074[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (108))){
var inst_25745 = cljs.core._deref.call(null,fuel);
var inst_25746 = (inst_25745 + (1));
var inst_25747 = cljs.core._vreset_BANG_.call(null,fuel,inst_25746);
var state_25827__$1 = state_25827;
var statearr_25888_26075 = state_25827__$1;
(statearr_25888_26075[(2)] = inst_25747);

(statearr_25888_26075[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (56))){
var inst_25606 = (state_25827[(26)]);
var inst_25608 = fluree.db.query.fql.fuel_flake_transducer.call(null,fuel,max_fuel);
var inst_25609 = cljs.core.comp.call(null,inst_25606,inst_25608);
var state_25827__$1 = state_25827;
var statearr_25889_26076 = state_25827__$1;
(statearr_25889_26076[(2)] = inst_25609);

(statearr_25889_26076[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (33))){
var inst_25528 = (state_25827[(13)]);
var inst_25553 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25554 = [inst_25528,"ASC"];
var inst_25555 = (new cljs.core.PersistentVector(null,2,(5),inst_25553,inst_25554,null));
var state_25827__$1 = state_25827;
var statearr_25890_26077 = state_25827__$1;
(statearr_25890_26077[(2)] = inst_25555);

(statearr_25890_26077[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (13))){
var inst_25495 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25496 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25497 = cljs.core.PersistentHashMap.fromArrays(inst_25495,inst_25496);
var inst_25498 = cljs.core.ex_info.call(null,"Query missing :select or :selectOne.",inst_25497);
var inst_25499 = (function(){throw inst_25498})();
var state_25827__$1 = state_25827;
var statearr_25891_26078 = state_25827__$1;
(statearr_25891_26078[(2)] = inst_25499);

(statearr_25891_26078[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (22))){
var inst_25506 = (state_25827[(23)]);
var state_25827__$1 = state_25827;
var statearr_25892_26079 = state_25827__$1;
(statearr_25892_26079[(2)] = inst_25506);

(statearr_25892_26079[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (90))){
var state_25827__$1 = state_25827;
var statearr_25893_26080 = state_25827__$1;
(statearr_25893_26080[(2)] = null);

(statearr_25893_26080[(1)] = (92));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (109))){
var state_25827__$1 = state_25827;
var statearr_25894_26081 = state_25827__$1;
(statearr_25894_26081[(2)] = null);

(statearr_25894_26081[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (36))){
var inst_25558 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25559 = [null,null];
var inst_25560 = (new cljs.core.PersistentVector(null,2,(5),inst_25558,inst_25559,null));
var state_25827__$1 = state_25827;
var statearr_25895_26082 = state_25827__$1;
(statearr_25895_26082[(2)] = inst_25560);

(statearr_25895_26082[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (41))){
var inst_25574 = (state_25827[(27)]);
var inst_25803 = (state_25827[(2)]);
var state_25827__$1 = (function (){var statearr_25896 = state_25827;
(statearr_25896[(28)] = inst_25803);

return statearr_25896;
})();
if(cljs.core.truth_(inst_25574)){
var statearr_25897_26083 = state_25827__$1;
(statearr_25897_26083[(1)] = (125));

} else {
var statearr_25898_26084 = state_25827__$1;
(statearr_25898_26084[(1)] = (126));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (118))){
var inst_25528 = (state_25827[(13)]);
var inst_25772 = (state_25827[(2)]);
var state_25827__$1 = (function (){var statearr_25899 = state_25827;
(statearr_25899[(9)] = inst_25772);

return statearr_25899;
})();
if(cljs.core.truth_(inst_25528)){
var statearr_25900_26085 = state_25827__$1;
(statearr_25900_26085[(1)] = (119));

} else {
var statearr_25901_26086 = state_25827__$1;
(statearr_25901_26086[(1)] = (120));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (89))){
var inst_25692 = (state_25827[(25)]);
var inst_25691 = (state_25827[(2)]);
var inst_25692__$1 = fluree.db.util.async.throw_err.call(null,inst_25691);
var inst_25693 = (inst_25692__$1 == null);
var state_25827__$1 = (function (){var statearr_25902 = state_25827;
(statearr_25902[(25)] = inst_25692__$1);

return statearr_25902;
})();
if(cljs.core.truth_(inst_25693)){
var statearr_25903_26087 = state_25827__$1;
(statearr_25903_26087[(1)] = (90));

} else {
var statearr_25904_26088 = state_25827__$1;
(statearr_25904_26088[(1)] = (91));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (100))){
var inst_25736 = (state_25827[(15)]);
var inst_25729 = (state_25827[(29)]);
var inst_25735 = cljs.core.seq.call(null,inst_25729);
var inst_25736__$1 = cljs.core.first.call(null,inst_25735);
var inst_25737 = cljs.core.next.call(null,inst_25735);
var inst_25738 = cljs.core.not.call(null,inst_25736__$1);
var state_25827__$1 = (function (){var statearr_25905 = state_25827;
(statearr_25905[(15)] = inst_25736__$1);

(statearr_25905[(30)] = inst_25737);

return statearr_25905;
})();
if(inst_25738){
var statearr_25906_26089 = state_25827__$1;
(statearr_25906_26089[(1)] = (102));

} else {
var statearr_25907_26090 = state_25827__$1;
(statearr_25907_26090[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (131))){
var inst_25808 = (state_25827[(17)]);
var inst_25819 = cljs.core.first.call(null,inst_25808);
var state_25827__$1 = state_25827;
var statearr_25908_26091 = state_25827__$1;
(statearr_25908_26091[(2)] = inst_25819);

(statearr_25908_26091[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (122))){
var inst_25783 = cljs.core.pr_str.call(null,query_map);
var inst_25784 = ["Invalid 'from' in query:",inst_25783].join('');
var inst_25785 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_25786 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_25787 = cljs.core.PersistentHashMap.fromArrays(inst_25785,inst_25786);
var inst_25788 = cljs.core.ex_info.call(null,inst_25784,inst_25787);
var state_25827__$1 = state_25827;
var statearr_25909_26092 = state_25827__$1;
(statearr_25909_26092[(2)] = inst_25788);

(statearr_25909_26092[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (43))){
var state_25827__$1 = state_25827;
var statearr_25910_26093 = state_25827__$1;
(statearr_25910_26093[(2)] = null);

(statearr_25910_26093[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (61))){
var inst_25528 = (state_25827[(13)]);
var inst_25618 = (state_25827[(2)]);
var state_25827__$1 = (function (){var statearr_25911 = state_25827;
(statearr_25911[(11)] = inst_25618);

return statearr_25911;
})();
if(cljs.core.truth_(inst_25528)){
var statearr_25912_26094 = state_25827__$1;
(statearr_25912_26094[(1)] = (62));

} else {
var statearr_25913_26095 = state_25827__$1;
(statearr_25913_26095[(1)] = (63));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (29))){
var inst_25573 = (state_25827[(2)]);
var inst_25574 = cljs.core.nth.call(null,inst_25573,(0),null);
var inst_25575 = cljs.core.nth.call(null,inst_25573,(1),null);
var inst_25576 = typeof where === 'string';
var state_25827__$1 = (function (){var statearr_25914 = state_25827;
(statearr_25914[(31)] = inst_25575);

(statearr_25914[(27)] = inst_25574);

return statearr_25914;
})();
if(cljs.core.truth_(inst_25576)){
var statearr_25915_26096 = state_25827__$1;
(statearr_25915_26096[(1)] = (39));

} else {
var statearr_25916_26097 = state_25827__$1;
(statearr_25916_26097[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (44))){
var inst_25582 = (state_25827[(2)]);
var inst_25583 = fluree.db.query.fql.where_filter.call(null,db,where,inst_25582);
var state_25827__$1 = state_25827;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25827__$1,(45),inst_25583);
} else {
if((state_val_25828 === (93))){
var inst_25703 = (state_25827[(2)]);
var inst_25704 = fluree.db.util.async.throw_err.call(null,inst_25703);
var state_25827__$1 = (function (){var statearr_25917 = state_25827;
(statearr_25917[(32)] = inst_25704);

return statearr_25917;
})();
if(cljs.core.truth_(fuel)){
var statearr_25918_26098 = state_25827__$1;
(statearr_25918_26098[(1)] = (94));

} else {
var statearr_25919_26099 = state_25827__$1;
(statearr_25919_26099[(1)] = (95));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (6))){
var inst_25486 = (state_25827[(33)]);
var state_25827__$1 = state_25827;
var statearr_25920_26100 = state_25827__$1;
(statearr_25920_26100[(2)] = inst_25486);

(statearr_25920_26100[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (111))){
var inst_25753 = (state_25827[(2)]);
var inst_25754 = fluree.db.util.async.throw_err.call(null,inst_25753);
var state_25827__$1 = state_25827;
var statearr_25921_26101 = state_25827__$1;
(statearr_25921_26101[(2)] = inst_25754);

(statearr_25921_26101[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (28))){
var inst_25569 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25570 = [null,null];
var inst_25571 = (new cljs.core.PersistentVector(null,2,(5),inst_25569,inst_25570,null));
var state_25827__$1 = state_25827;
var statearr_25922_26102 = state_25827__$1;
(statearr_25922_26102[(2)] = inst_25571);

(statearr_25922_26102[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (64))){
var inst_25626 = (state_25827[(2)]);
var inst_25627 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25628 = [from];
var inst_25629 = (new cljs.core.PersistentVector(null,1,(5),inst_25627,inst_25628,null));
var inst_25630 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_25629,inst_25626);
var state_25827__$1 = state_25827;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25827__$1,(65),inst_25630);
} else {
if((state_val_25828 === (103))){
var inst_25736 = (state_25827[(15)]);
var inst_25741 = cljs.core.int_QMARK_.call(null,inst_25736);
var state_25827__$1 = state_25827;
if(inst_25741){
var statearr_25923_26103 = state_25827__$1;
(statearr_25923_26103[(1)] = (105));

} else {
var statearr_25924_26104 = state_25827__$1;
(statearr_25924_26104[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (51))){
var inst_25531 = (state_25827[(14)]);
var state_25827__$1 = state_25827;
var statearr_25925_26105 = state_25827__$1;
(statearr_25925_26105[(2)] = inst_25531);

(statearr_25925_26105[(1)] = (52));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (25))){
var inst_25532 = (state_25827[(20)]);
var state_25827__$1 = state_25827;
var statearr_25926_26106 = state_25827__$1;
(statearr_25926_26106[(2)] = inst_25532);

(statearr_25926_26106[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (34))){
var state_25827__$1 = state_25827;
var statearr_25927_26107 = state_25827__$1;
(statearr_25927_26107[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (125))){
var inst_25531 = (state_25827[(14)]);
var inst_25575 = (state_25827[(31)]);
var inst_25803 = (state_25827[(28)]);
var inst_25574 = (state_25827[(27)]);
var inst_25529 = (state_25827[(12)]);
var inst_25805 = fluree.db.query.fql.sort_offset_and_limit_res.call(null,inst_25574,inst_25575,inst_25531,inst_25529,inst_25803);
var state_25827__$1 = state_25827;
var statearr_25929_26108 = state_25827__$1;
(statearr_25929_26108[(2)] = inst_25805);

(statearr_25929_26108[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (17))){
var inst_25522 = (state_25827[(2)]);
var state_25827__$1 = state_25827;
if(cljs.core.truth_(inst_25522)){
var statearr_25930_26109 = state_25827__$1;
(statearr_25930_26109[(1)] = (21));

} else {
var statearr_25931_26110 = state_25827__$1;
(statearr_25931_26110[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (3))){
var inst_25825 = (state_25827[(2)]);
var state_25827__$1 = state_25827;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_25827__$1,inst_25825);
} else {
if((state_val_25828 === (12))){
var inst_25492 = (state_25827[(34)]);
var state_25827__$1 = state_25827;
var statearr_25932_26111 = state_25827__$1;
(statearr_25932_26111[(2)] = inst_25492);

(statearr_25932_26111[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (2))){
var inst_25486 = (state_25827[(33)]);
var _ = (function (){var statearr_25933 = state_25827;
(statearr_25933[(4)] = cljs.core.cons.call(null,(5),(state_25827[(4)])));

return statearr_25933;
})();
var inst_25486__$1 = select;
var state_25827__$1 = (function (){var statearr_25934 = state_25827;
(statearr_25934[(33)] = inst_25486__$1);

return statearr_25934;
})();
if(cljs.core.truth_(inst_25486__$1)){
var statearr_25935_26112 = state_25827__$1;
(statearr_25935_26112[(1)] = (6));

} else {
var statearr_25936_26113 = state_25827__$1;
(statearr_25936_26113[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (66))){
var inst_25637 = (state_25827[(2)]);
var inst_25638 = fluree.db.util.async.throw_err.call(null,inst_25637);
var state_25827__$1 = state_25827;
var statearr_25937_26114 = state_25827__$1;
(statearr_25937_26114[(2)] = inst_25638);

(statearr_25937_26114[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (107))){
var inst_25756 = (state_25827[(35)]);
var inst_25756__$1 = (state_25827[(2)]);
var state_25827__$1 = (function (){var statearr_25938 = state_25827;
(statearr_25938[(35)] = inst_25756__$1);

return statearr_25938;
})();
if(cljs.core.truth_(inst_25756__$1)){
var statearr_25939_26115 = state_25827__$1;
(statearr_25939_26115[(1)] = (112));

} else {
var statearr_25940_26116 = state_25827__$1;
(statearr_25940_26116[(1)] = (113));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (23))){
var inst_25530 = (state_25827[(21)]);
var inst_25505 = (state_25827[(36)]);
var inst_25527 = (state_25827[(2)]);
var inst_25528 = cljs.core.get.call(null,inst_25527,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793));
var inst_25529 = cljs.core.get.call(null,inst_25527,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_25530__$1 = cljs.core.get.call(null,inst_25527,new cljs.core.Keyword(null,"component","component",1555936782));
var inst_25531 = cljs.core.get.call(null,inst_25527,new cljs.core.Keyword(null,"offset","offset",296498311));
var inst_25532 = fluree.db.query.fql_parser.parse_db.call(null,db,inst_25505,opts_SINGLEQUOTE_);
var inst_25533 = (inst_25530__$1 == null);
var inst_25534 = cljs.core.not.call(null,inst_25533);
var state_25827__$1 = (function (){var statearr_25941 = state_25827;
(statearr_25941[(20)] = inst_25532);

(statearr_25941[(21)] = inst_25530__$1);

(statearr_25941[(14)] = inst_25531);

(statearr_25941[(13)] = inst_25528);

(statearr_25941[(12)] = inst_25529);

return statearr_25941;
})();
if(inst_25534){
var statearr_25942_26117 = state_25827__$1;
(statearr_25942_26117[(1)] = (24));

} else {
var statearr_25943_26118 = state_25827__$1;
(statearr_25943_26118[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (47))){
var state_25827__$1 = state_25827;
var statearr_25944_26119 = state_25827__$1;
(statearr_25944_26119[(2)] = null);

(statearr_25944_26119[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (35))){
var inst_25565 = (state_25827[(2)]);
var state_25827__$1 = state_25827;
var statearr_25945_26120 = state_25827__$1;
(statearr_25945_26120[(2)] = inst_25565);

(statearr_25945_26120[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (127))){
var inst_25809 = (state_25827[(24)]);
var inst_25808 = (state_25827[(2)]);
var inst_25809__$1 = selectOne;
var state_25827__$1 = (function (){var statearr_25946 = state_25827;
(statearr_25946[(24)] = inst_25809__$1);

(statearr_25946[(17)] = inst_25808);

return statearr_25946;
})();
if(cljs.core.truth_(inst_25809__$1)){
var statearr_25947_26121 = state_25827__$1;
(statearr_25947_26121[(1)] = (128));

} else {
var statearr_25948_26122 = state_25827__$1;
(statearr_25948_26122[(1)] = (129));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (82))){
var inst_25531 = (state_25827[(14)]);
var inst_25529 = (state_25827[(12)]);
var inst_25672 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25673 = [inst_25529,inst_25531];
var inst_25674 = cljs.core.PersistentHashMap.fromArrays(inst_25672,inst_25673);
var state_25827__$1 = state_25827;
var statearr_25949_26123 = state_25827__$1;
(statearr_25949_26123[(2)] = inst_25674);

(statearr_25949_26123[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (76))){
var inst_25539 = (state_25827[(7)]);
var inst_25541 = (state_25827[(10)]);
var inst_25660 = (state_25827[(2)]);
var inst_25661 = fluree.db.util.async.throw_err.call(null,inst_25660);
var inst_25662 = fluree.db.query.fql.flake_select.call(null,db,inst_25541,fuel,max_fuel,inst_25539,inst_25661);
var state_25827__$1 = state_25827;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25827__$1,(77),inst_25662);
} else {
if((state_val_25828 === (97))){
var inst_25724 = from;
var inst_25725 = cljs.core.seq.call(null,inst_25724);
var inst_25726 = cljs.core.first.call(null,inst_25725);
var inst_25727 = cljs.core.next.call(null,inst_25725);
var inst_25728 = cljs.core.PersistentVector.EMPTY;
var inst_25729 = inst_25724;
var inst_25730 = inst_25728;
var state_25827__$1 = (function (){var statearr_25950 = state_25827;
(statearr_25950[(37)] = inst_25727);

(statearr_25950[(38)] = inst_25726);

(statearr_25950[(22)] = inst_25730);

(statearr_25950[(29)] = inst_25729);

return statearr_25950;
})();
var statearr_25951_26124 = state_25827__$1;
(statearr_25951_26124[(2)] = null);

(statearr_25951_26124[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (19))){
var state_25827__$1 = state_25827;
var statearr_25952_26125 = state_25827__$1;
(statearr_25952_26125[(2)] = false);

(statearr_25952_26125[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (57))){
var inst_25606 = (state_25827[(26)]);
var state_25827__$1 = state_25827;
var statearr_25953_26126 = state_25827__$1;
(statearr_25953_26126[(2)] = inst_25606);

(statearr_25953_26126[(1)] = (58));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (68))){
var state_25827__$1 = state_25827;
var statearr_25954_26127 = state_25827__$1;
(statearr_25954_26127[(2)] = false);

(statearr_25954_26127[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (11))){
var inst_25503 = (state_25827[(2)]);
var state_25827__$1 = state_25827;
var statearr_25955_26128 = state_25827__$1;
(statearr_25955_26128[(2)] = inst_25503);

(statearr_25955_26128[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (115))){
var inst_25779 = (state_25827[(2)]);
var inst_25780 = fluree.db.util.async.throw_err.call(null,inst_25779);
var state_25827__$1 = state_25827;
var statearr_25957_26129 = state_25827__$1;
(statearr_25957_26129[(2)] = inst_25780);

(statearr_25957_26129[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (9))){
var inst_25489 = (state_25827[(18)]);
var state_25827__$1 = state_25827;
var statearr_25958_26130 = state_25827__$1;
(statearr_25958_26130[(2)] = inst_25489);

(statearr_25958_26130[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (5))){
var _ = (function (){var statearr_25959 = state_25827;
(statearr_25959[(4)] = cljs.core.rest.call(null,(state_25827[(4)])));

return statearr_25959;
})();
var state_25827__$1 = state_25827;
var ex25956 = (state_25827__$1[(2)]);
var statearr_25960_26131 = state_25827__$1;
(statearr_25960_26131[(5)] = ex25956);


if((ex25956 instanceof Error)){
var statearr_25961_26132 = state_25827__$1;
(statearr_25961_26132[(1)] = (4));

(statearr_25961_26132[(5)] = null);

} else {
throw ex25956;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (112))){
var inst_25756 = (state_25827[(35)]);
var inst_25730 = (state_25827[(22)]);
var inst_25758 = cljs.core.conj.call(null,inst_25730,inst_25756);
var state_25827__$1 = state_25827;
var statearr_25962_26133 = state_25827__$1;
(statearr_25962_26133[(2)] = inst_25758);

(statearr_25962_26133[(1)] = (114));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (83))){
var inst_25676 = (state_25827[(2)]);
var inst_25677 = fluree.db.query.range.collection.call(null,db,from,inst_25676);
var state_25827__$1 = state_25827;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25827__$1,(84),inst_25677);
} else {
if((state_val_25828 === (14))){
var inst_25501 = (state_25827[(2)]);
var state_25827__$1 = state_25827;
var statearr_25963_26134 = state_25827__$1;
(statearr_25963_26134[(2)] = inst_25501);

(statearr_25963_26134[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (45))){
var inst_25528 = (state_25827[(13)]);
var inst_25585 = (state_25827[(2)]);
var inst_25586 = fluree.db.util.async.throw_err.call(null,inst_25585);
var state_25827__$1 = (function (){var statearr_25964 = state_25827;
(statearr_25964[(39)] = inst_25586);

return statearr_25964;
})();
if(cljs.core.truth_(inst_25528)){
var statearr_25965_26135 = state_25827__$1;
(statearr_25965_26135[(1)] = (47));

} else {
var statearr_25966_26136 = state_25827__$1;
(statearr_25966_26136[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (53))){
var inst_25606 = cljs.core.map.call(null,fluree.db.query.fql.s);
var state_25827__$1 = (function (){var statearr_25967 = state_25827;
(statearr_25967[(26)] = inst_25606);

return statearr_25967;
})();
if(cljs.core.truth_(fuel)){
var statearr_25968_26137 = state_25827__$1;
(statearr_25968_26137[(1)] = (56));

} else {
var statearr_25969_26138 = state_25827__$1;
(statearr_25969_26138[(1)] = (57));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (78))){
var inst_25528 = (state_25827[(13)]);
var state_25827__$1 = state_25827;
if(cljs.core.truth_(inst_25528)){
var statearr_25970_26139 = state_25827__$1;
(statearr_25970_26139[(1)] = (81));

} else {
var statearr_25971_26140 = state_25827__$1;
(statearr_25971_26140[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (132))){
var inst_25808 = (state_25827[(17)]);
var state_25827__$1 = state_25827;
var statearr_25972_26141 = state_25827__$1;
(statearr_25972_26141[(2)] = inst_25808);

(statearr_25972_26141[(1)] = (133));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (26))){
var inst_25528 = (state_25827[(13)]);
var inst_25539 = (state_25827[(2)]);
var inst_25540 = cljs.core.PersistentHashMap.EMPTY;
var inst_25541 = cljs.core.volatile_BANG_.call(null,inst_25540);
var state_25827__$1 = (function (){var statearr_25973 = state_25827;
(statearr_25973[(7)] = inst_25539);

(statearr_25973[(10)] = inst_25541);

return statearr_25973;
})();
if(cljs.core.truth_(inst_25528)){
var statearr_25974_26142 = state_25827__$1;
(statearr_25974_26142[(1)] = (27));

} else {
var statearr_25975_26143 = state_25827__$1;
(statearr_25975_26143[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (123))){
var state_25827__$1 = state_25827;
var statearr_25976_26144 = state_25827__$1;
(statearr_25976_26144[(2)] = null);

(statearr_25976_26144[(1)] = (124));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (16))){
var state_25827__$1 = state_25827;
var statearr_25977_26145 = state_25827__$1;
(statearr_25977_26145[(2)] = false);

(statearr_25977_26145[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (133))){
var inst_25822 = (state_25827[(2)]);
var _ = (function (){var statearr_25978 = state_25827;
(statearr_25978[(4)] = cljs.core.rest.call(null,(state_25827[(4)])));

return statearr_25978;
})();
var state_25827__$1 = state_25827;
var statearr_25979_26146 = state_25827__$1;
(statearr_25979_26146[(2)] = inst_25822);

(statearr_25979_26146[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (81))){
var inst_25670 = cljs.core.PersistentHashMap.EMPTY;
var state_25827__$1 = state_25827;
var statearr_25980_26147 = state_25827__$1;
(statearr_25980_26147[(2)] = inst_25670);

(statearr_25980_26147[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (120))){
var inst_25531 = (state_25827[(14)]);
var state_25827__$1 = state_25827;
var statearr_25981_26148 = state_25827__$1;
(statearr_25981_26148[(2)] = inst_25531);

(statearr_25981_26148[(1)] = (121));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (79))){
var inst_25686 = fluree.db.util.core.subj_ident_QMARK_.call(null,from);
var state_25827__$1 = state_25827;
if(inst_25686){
var statearr_25982_26149 = state_25827__$1;
(statearr_25982_26149[(1)] = (86));

} else {
var statearr_25983_26150 = state_25827__$1;
(statearr_25983_26150[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (38))){
var inst_25563 = (state_25827[(2)]);
var state_25827__$1 = state_25827;
var statearr_25984_26151 = state_25827__$1;
(statearr_25984_26151[(2)] = inst_25563);

(statearr_25984_26151[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (126))){
var inst_25803 = (state_25827[(28)]);
var state_25827__$1 = state_25827;
var statearr_25985_26152 = state_25827__$1;
(statearr_25985_26152[(2)] = inst_25803);

(statearr_25985_26152[(1)] = (127));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (98))){
var state_25827__$1 = state_25827;
var statearr_25986_26153 = state_25827__$1;
(statearr_25986_26153[(1)] = (122));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (124))){
var inst_25791 = (state_25827[(2)]);
var state_25827__$1 = state_25827;
var statearr_25988_26154 = state_25827__$1;
(statearr_25988_26154[(2)] = inst_25791);

(statearr_25988_26154[(1)] = (99));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (87))){
var inst_25713 = cljs.core.sequential_QMARK_.call(null,from);
var inst_25714 = cljs.core.every_QMARK_.call(null,fluree.db.util.core.subj_ident_QMARK_,from);
var inst_25715 = ((inst_25713) && (inst_25714));
var state_25827__$1 = state_25827;
if(cljs.core.truth_(inst_25715)){
var statearr_25989_26155 = state_25827__$1;
(statearr_25989_26155[(1)] = (97));

} else {
var statearr_25990_26156 = state_25827__$1;
(statearr_25990_26156[(1)] = (98));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (30))){
var inst_25528 = (state_25827[(13)]);
var inst_25545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25546 = cljs.core.second.call(null,inst_25528);
var inst_25547 = cljs.core.first.call(null,inst_25528);
var inst_25548 = [inst_25546,inst_25547];
var inst_25549 = (new cljs.core.PersistentVector(null,2,(5),inst_25545,inst_25548,null));
var state_25827__$1 = state_25827;
var statearr_25991_26157 = state_25827__$1;
(statearr_25991_26157[(2)] = inst_25549);

(statearr_25991_26157[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (73))){
var inst_25651 = cljs.core.PersistentHashMap.EMPTY;
var state_25827__$1 = state_25827;
var statearr_25992_26158 = state_25827__$1;
(statearr_25992_26158[(2)] = inst_25651);

(statearr_25992_26158[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (96))){
var inst_25704 = (state_25827[(32)]);
var inst_25711 = (state_25827[(2)]);
var state_25827__$1 = (function (){var statearr_25993 = state_25827;
(statearr_25993[(40)] = inst_25711);

return statearr_25993;
})();
var statearr_25994_26159 = state_25827__$1;
(statearr_25994_26159[(2)] = inst_25704);

(statearr_25994_26159[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (10))){
var inst_25492 = (state_25827[(34)]);
var inst_25492__$1 = selectDistinct;
var state_25827__$1 = (function (){var statearr_25995 = state_25827;
(statearr_25995[(34)] = inst_25492__$1);

return statearr_25995;
})();
if(cljs.core.truth_(inst_25492__$1)){
var statearr_25996_26160 = state_25827__$1;
(statearr_25996_26160[(1)] = (12));

} else {
var statearr_25997_26161 = state_25827__$1;
(statearr_25997_26161[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (18))){
var state_25827__$1 = state_25827;
var statearr_25998_26162 = state_25827__$1;
(statearr_25998_26162[(2)] = true);

(statearr_25998_26162[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (105))){
var inst_25736 = (state_25827[(15)]);
var state_25827__$1 = state_25827;
var statearr_25999_26163 = state_25827__$1;
(statearr_25999_26163[(2)] = inst_25736);

(statearr_25999_26163[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (52))){
var inst_25539 = (state_25827[(7)]);
var inst_25541 = (state_25827[(10)]);
var inst_25586 = (state_25827[(39)]);
var inst_25590 = (state_25827[(41)]);
var inst_25594 = (state_25827[(2)]);
var inst_25595 = fluree.db.query.fql.subject_select.call(null,db,inst_25541,fuel,max_fuel,inst_25539,inst_25586,inst_25590,inst_25594);
var state_25827__$1 = state_25827;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25827__$1,(46),inst_25595);
} else {
if((state_val_25828 === (114))){
var inst_25737 = (state_25827[(30)]);
var inst_25761 = (state_25827[(2)]);
var inst_25729 = inst_25737;
var inst_25730 = inst_25761;
var state_25827__$1 = (function (){var statearr_26000 = state_25827;
(statearr_26000[(22)] = inst_25730);

(statearr_26000[(29)] = inst_25729);

return statearr_26000;
})();
var statearr_26001_26164 = state_25827__$1;
(statearr_26001_26164[(2)] = null);

(statearr_26001_26164[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (67))){
var inst_25642 = ["_tx",null,"_block",null];
var inst_25643 = (new cljs.core.PersistentArrayMap(null,2,inst_25642,null));
var inst_25644 = (new cljs.core.PersistentHashSet(null,inst_25643,null));
var inst_25645 = inst_25644.call(null,from);
var state_25827__$1 = state_25827;
var statearr_26002_26165 = state_25827__$1;
(statearr_26002_26165[(2)] = inst_25645);

(statearr_26002_26165[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (71))){
var inst_25667 = typeof from === 'string';
var state_25827__$1 = state_25827;
if(cljs.core.truth_(inst_25667)){
var statearr_26003_26166 = state_25827__$1;
(statearr_26003_26166[(1)] = (78));

} else {
var statearr_26004_26167 = state_25827__$1;
(statearr_26004_26167[(1)] = (79));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (42))){
var state_25827__$1 = state_25827;
var statearr_26005_26168 = state_25827__$1;
(statearr_26005_26168[(2)] = from);

(statearr_26005_26168[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (80))){
var inst_25797 = (state_25827[(2)]);
var state_25827__$1 = state_25827;
var statearr_26006_26169 = state_25827__$1;
(statearr_26006_26169[(2)] = inst_25797);

(statearr_26006_26169[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (37))){
var state_25827__$1 = state_25827;
var statearr_26007_26170 = state_25827__$1;
(statearr_26007_26170[(2)] = null);

(statearr_26007_26170[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (63))){
var inst_25531 = (state_25827[(14)]);
var inst_25529 = (state_25827[(12)]);
var inst_25622 = [new cljs.core.Keyword(null,"limit","limit",-1355822363),new cljs.core.Keyword(null,"offset","offset",296498311)];
var inst_25623 = [inst_25529,inst_25531];
var inst_25624 = cljs.core.PersistentHashMap.fromArrays(inst_25622,inst_25623);
var state_25827__$1 = state_25827;
var statearr_26008_26171 = state_25827__$1;
(statearr_26008_26171[(2)] = inst_25624);

(statearr_26008_26171[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (94))){
var inst_25706 = cljs.core._deref.call(null,fuel);
var inst_25707 = (inst_25706 + (1));
var inst_25708 = cljs.core._vreset_BANG_.call(null,fuel,inst_25707);
var state_25827__$1 = state_25827;
var statearr_26009_26172 = state_25827__$1;
(statearr_26009_26172[(2)] = inst_25708);

(statearr_26009_26172[(1)] = (96));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (8))){
var inst_25506 = (state_25827[(23)]);
var inst_25505 = (state_25827[(2)]);
var inst_25506__$1 = opts_SINGLEQUOTE_;
var inst_25508 = (inst_25506__$1 == null);
var inst_25509 = cljs.core.not.call(null,inst_25508);
var state_25827__$1 = (function (){var statearr_26010 = state_25827;
(statearr_26010[(36)] = inst_25505);

(statearr_26010[(23)] = inst_25506__$1);

return statearr_26010;
})();
if(inst_25509){
var statearr_26011_26173 = state_25827__$1;
(statearr_26011_26173[(1)] = (15));

} else {
var statearr_26012_26174 = state_25827__$1;
(statearr_26012_26174[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (49))){
var inst_25528 = (state_25827[(13)]);
var inst_25590 = (state_25827[(2)]);
var state_25827__$1 = (function (){var statearr_26013 = state_25827;
(statearr_26013[(41)] = inst_25590);

return statearr_26013;
})();
if(cljs.core.truth_(inst_25528)){
var statearr_26014_26175 = state_25827__$1;
(statearr_26014_26175[(1)] = (50));

} else {
var statearr_26015_26176 = state_25827__$1;
(statearr_26015_26176[(1)] = (51));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_25828 === (84))){
var inst_25539 = (state_25827[(7)]);
var inst_25541 = (state_25827[(10)]);
var inst_25679 = (state_25827[(2)]);
var inst_25680 = fluree.db.util.async.throw_err.call(null,inst_25679);
var inst_25681 = fluree.db.query.fql.flake_select.call(null,db,inst_25541,fuel,max_fuel,inst_25539,inst_25680);
var state_25827__$1 = state_25827;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_25827__$1,(85),inst_25681);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__2879__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__2879__auto____0 = (function (){
var statearr_26016 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26016[(0)] = fluree$db$query$fql$query_$_state_machine__2879__auto__);

(statearr_26016[(1)] = (1));

return statearr_26016;
});
var fluree$db$query$fql$query_$_state_machine__2879__auto____1 = (function (state_25827){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_25827);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e26017){var ex__2882__auto__ = e26017;
var statearr_26018_26177 = state_25827;
(statearr_26018_26177[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_25827[(4)]))){
var statearr_26019_26178 = state_25827;
(statearr_26019_26178[(1)] = cljs.core.first.call(null,(state_25827[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__26179 = state_25827;
state_25827 = G__26179;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__2879__auto__ = function(state_25827){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__2879__auto____1.call(this,state_25827);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__2879__auto____0;
fluree$db$query$fql$query_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__2879__auto____1;
return fluree$db$query$fql$query_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_26020 = f__2902__auto__.call(null);
(statearr_26020[(6)] = c__2901__auto__);

return statearr_26020;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}

});
