// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"spot","spot",-1706962147),idx)) && ((!((start_flake.o == null)))) && (cljs.core._EQ_.call(null,start_flake.o,end_flake.o)) && (cljs.core._EQ_.call(null,(-1),start_flake.p)) && (cljs.core._EQ_.call(null,fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4126__auto__ = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__13632 = match;
var p1 = cljs.core.nth.call(null,vec__13632,(0),null);
var p2 = cljs.core.nth.call(null,vec__13632,(1),null);
var p3 = cljs.core.nth.call(null,vec__13632,(2),null);
var t = cljs.core.nth.call(null,vec__13632,(3),null);
var op = cljs.core.nth.call(null,vec__13632,(4),null);
var m = cljs.core.nth.call(null,vec__13632,(5),null);
var G__13635 = idx;
var G__13635__$1 = (((G__13635 instanceof cljs.core.Keyword))?G__13635.fqn:null);
switch (G__13635__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13635__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__13637 = idx;
var G__13637__$1 = (((G__13637 instanceof cljs.core.Keyword))?G__13637.fqn:null);
switch (G__13637__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13637__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__13639 = idx;
var G__13639__$1 = (((G__13639 instanceof cljs.core.Keyword))?G__13639.fqn:null);
switch (G__13639__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__13639__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__13642 = arguments.length;
switch (G__13642) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__13643 = (function (){var pred__13646 = cljs.core.identical_QMARK_;
var expr__13647 = test;
if(cljs.core.truth_(pred__13646.call(null,cljs.core._EQ_,expr__13647))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__13646.call(null,cljs.core._LT_,expr__13647))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__13646.call(null,cljs.core._LT__EQ_,expr__13647))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__13646.call(null,cljs.core._GT_,expr__13647))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__13646.call(null,cljs.core._GT__EQ_,expr__13647))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__13647)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__13643,(0),null);
var start_match = cljs.core.nth.call(null,vec__13643,(1),null);
var end_test = cljs.core.nth.call(null,vec__13643,(2),null);
var end_match = cljs.core.nth.call(null,vec__13643,(3),null);
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_13860){
var state_val_13861 = (state_13860[(1)]);
if((state_val_13861 === (65))){
var inst_13781 = (state_13860[(7)]);
var inst_13813 = (state_13860[(8)]);
var inst_13825 = cljs.core.into.call(null,inst_13813,inst_13781);
var state_13860__$1 = state_13860;
var statearr_13862_13978 = state_13860__$1;
(statearr_13862_13978[(2)] = inst_13825);

(statearr_13862_13978[(1)] = (67));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (70))){
var inst_13843 = (state_13860[(2)]);
var inst_13844 = cljs.core.not.call(null,inst_13843);
var state_13860__$1 = state_13860;
if(inst_13844){
var statearr_13863_13979 = state_13860__$1;
(statearr_13863_13979[(1)] = (71));

} else {
var statearr_13864_13980 = state_13860__$1;
(statearr_13864_13980[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (62))){
var inst_13795 = (state_13860[(9)]);
var inst_13834 = (state_13860[(10)]);
var inst_13834__$1 = (state_13860[(2)]);
var inst_13835 = cljs.core.count.call(null,inst_13834__$1);
var state_13860__$1 = (function (){var statearr_13865 = state_13860;
(statearr_13865[(10)] = inst_13834__$1);

(statearr_13865[(11)] = inst_13835);

return statearr_13865;
})();
if(cljs.core.truth_(inst_13795)){
var statearr_13866_13981 = state_13860__$1;
(statearr_13866_13981[(1)] = (68));

} else {
var statearr_13867_13982 = state_13860__$1;
(statearr_13867_13982[(1)] = (69));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (74))){
var inst_13834 = (state_13860[(10)]);
var inst_13835 = (state_13860[(11)]);
var inst_13849 = (state_13860[(2)]);
var inst_13850 = fluree.db.util.async.throw_err.call(null,inst_13849);
var inst_13779 = inst_13850;
var inst_13780 = inst_13835;
var inst_13781 = inst_13834;
var state_13860__$1 = (function (){var statearr_13868 = state_13860;
(statearr_13868[(7)] = inst_13781);

(statearr_13868[(12)] = inst_13779);

(statearr_13868[(13)] = inst_13780);

return statearr_13868;
})();
var statearr_13869_13983 = state_13860__$1;
(statearr_13869_13983[(2)] = null);

(statearr_13869_13983[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (7))){
var inst_13662 = (state_13860[(14)]);
var state_13860__$1 = state_13860;
var statearr_13870_13984 = state_13860__$1;
(statearr_13870_13984[(2)] = inst_13662);

(statearr_13870_13984[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (59))){
var inst_13779 = (state_13860[(12)]);
var inst_13794 = (state_13860[(2)]);
var inst_13795 = fluree.db.dbproto._rhs.call(null,inst_13779);
var state_13860__$1 = (function (){var statearr_13871 = state_13860;
(statearr_13871[(15)] = inst_13794);

(statearr_13871[(9)] = inst_13795);

return statearr_13871;
})();
var statearr_13872_13985 = state_13860__$1;
(statearr_13872_13985[(1)] = (60));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (20))){
var inst_13663 = (state_13860[(16)]);
var inst_13710 = (state_13860[(2)]);
var inst_13711 = (inst_13663 == null);
var state_13860__$1 = (function (){var statearr_13874 = state_13860;
(statearr_13874[(17)] = inst_13710);

return statearr_13874;
})();
if(cljs.core.truth_(inst_13711)){
var statearr_13875_13986 = state_13860__$1;
(statearr_13875_13986[(1)] = (22));

} else {
var statearr_13876_13987 = state_13860__$1;
(statearr_13876_13987[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (72))){
var inst_13795 = (state_13860[(9)]);
var inst_13774 = (state_13860[(18)]);
var inst_13847 = fluree.db.dbproto._lookup_leaf.call(null,inst_13774,inst_13795);
var state_13860__$1 = state_13860;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13860__$1,(74),inst_13847);
} else {
if((state_val_13861 === (58))){
var inst_13787 = (state_13860[(19)]);
var state_13860__$1 = state_13860;
var statearr_13877_13988 = state_13860__$1;
(statearr_13877_13988[(2)] = inst_13787);

(statearr_13877_13988[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (60))){
var inst_13794 = (state_13860[(15)]);
var inst_13753 = (state_13860[(20)]);
var inst_13781 = (state_13860[(7)]);
var inst_13780 = (state_13860[(13)]);
var inst_13797 = (inst_13753 - inst_13780);
var inst_13798 = fluree.db.flake.take.call(null,inst_13797,inst_13794);
var inst_13799 = cljs.core.into.call(null,inst_13798,inst_13781);
var state_13860__$1 = state_13860;
var statearr_13878_13989 = state_13860__$1;
(statearr_13878_13989[(2)] = inst_13799);

(statearr_13878_13989[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (27))){
var inst_13670 = (state_13860[(21)]);
var inst_13719 = (state_13860[(2)]);
var inst_13720 = (inst_13670 == null);
var state_13860__$1 = (function (){var statearr_13879 = state_13860;
(statearr_13879[(22)] = inst_13719);

return statearr_13879;
})();
if(cljs.core.truth_(inst_13720)){
var statearr_13880_13990 = state_13860__$1;
(statearr_13880_13990[(1)] = (28));

} else {
var statearr_13881_13991 = state_13860__$1;
(statearr_13881_13991[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (1))){
var state_13860__$1 = state_13860;
var statearr_13882_13992 = state_13860__$1;
(statearr_13882_13992[(2)] = null);

(statearr_13882_13992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (69))){
var inst_13795 = (state_13860[(9)]);
var state_13860__$1 = state_13860;
var statearr_13883_13993 = state_13860__$1;
(statearr_13883_13993[(2)] = inst_13795);

(statearr_13883_13993[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (24))){
var inst_13715 = (state_13860[(2)]);
var state_13860__$1 = state_13860;
if(cljs.core.truth_(inst_13715)){
var statearr_13884_13994 = state_13860__$1;
(statearr_13884_13994[(1)] = (25));

} else {
var statearr_13885_13995 = state_13860__$1;
(statearr_13885_13995[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (55))){
var inst_13855 = (state_13860[(2)]);
var _ = (function (){var statearr_13886 = state_13860;
(statearr_13886[(4)] = cljs.core.rest.call(null,(state_13860[(4)])));

return statearr_13886;
})();
var state_13860__$1 = state_13860;
var statearr_13887_13996 = state_13860__$1;
(statearr_13887_13996[(2)] = inst_13855);

(statearr_13887_13996[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (39))){
var inst_13735 = (state_13860[(2)]);
var state_13860__$1 = state_13860;
var statearr_13888_13997 = state_13860__$1;
(statearr_13888_13997[(2)] = inst_13735);

(statearr_13888_13997[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (46))){
var inst_13749 = (state_13860[(23)]);
var state_13860__$1 = state_13860;
var statearr_13889_13998 = state_13860__$1;
(statearr_13889_13998[(2)] = inst_13749);

(statearr_13889_13998[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (4))){
var inst_13649 = (state_13860[(2)]);
var state_13860__$1 = state_13860;
var statearr_13890_13999 = state_13860__$1;
(statearr_13890_13999[(2)] = inst_13649);

(statearr_13890_13999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (54))){
var inst_13765 = (state_13860[(24)]);
var inst_13769 = (state_13860[(25)]);
var inst_13764 = (state_13860[(26)]);
var inst_13779 = (state_13860[(12)]);
var inst_13783 = fluree.db.dbproto._resolve_history_range.call(null,inst_13779,inst_13764,inst_13765,inst_13769);
var state_13860__$1 = state_13860;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13860__$1,(56),inst_13783);
} else {
if((state_val_13861 === (15))){
var inst_13664 = (state_13860[(27)]);
var state_13860__$1 = state_13860;
var statearr_13891_14000 = state_13860__$1;
(statearr_13891_14000[(2)] = inst_13664);

(statearr_13891_14000[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (48))){
var inst_13759 = (state_13860[(28)]);
var inst_13753 = (state_13860[(2)]);
var inst_13754 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_13755 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13756 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_13757 = (new cljs.core.PersistentVector(null,3,(5),inst_13755,inst_13756,null));
var inst_13758 = cljs.core.get_in.call(null,db,inst_13757);
var inst_13759__$1 = new cljs.core.Keyword(null,"from-t","from-t",1730913525).cljs$core$IFn$_invoke$arity$1(opts);
var state_13860__$1 = (function (){var statearr_13892 = state_13860;
(statearr_13892[(20)] = inst_13753);

(statearr_13892[(29)] = inst_13758);

(statearr_13892[(30)] = inst_13754);

(statearr_13892[(28)] = inst_13759__$1);

return statearr_13892;
})();
if(cljs.core.truth_(inst_13759__$1)){
var statearr_13893_14001 = state_13860__$1;
(statearr_13893_14001[(1)] = (49));

} else {
var statearr_13894_14002 = state_13860__$1;
(statearr_13894_14002[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (50))){
var inst_13762 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var state_13860__$1 = state_13860;
var statearr_13895_14003 = state_13860__$1;
(statearr_13895_14003[(2)] = inst_13762);

(statearr_13895_14003[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (21))){
var inst_13706 = (state_13860[(2)]);
var inst_13707 = fluree.db.util.async.throw_err.call(null,inst_13706);
var state_13860__$1 = state_13860;
var statearr_13896_14004 = state_13860__$1;
(statearr_13896_14004[(2)] = inst_13707);

(statearr_13896_14004[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (31))){
var state_13860__$1 = state_13860;
var statearr_13897_14005 = state_13860__$1;
(statearr_13897_14005[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_13897_14005[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (32))){
var inst_13670 = (state_13860[(21)]);
var state_13860__$1 = state_13860;
var statearr_13898_14006 = state_13860__$1;
(statearr_13898_14006[(2)] = inst_13670);

(statearr_13898_14006[(1)] = (33));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (40))){
var inst_13674 = (state_13860[(31)]);
var state_13860__$1 = state_13860;
var statearr_13899_14007 = state_13860__$1;
(statearr_13899_14007[(2)] = inst_13674);

(statearr_13899_14007[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (56))){
var inst_13747 = (state_13860[(32)]);
var inst_13748 = (state_13860[(33)]);
var inst_13786 = (state_13860[(34)]);
var inst_13785 = (state_13860[(2)]);
var inst_13786__$1 = fluree.db.util.async.throw_err.call(null,inst_13785);
var inst_13787 = fluree.db.flake.subrange.call(null,inst_13786__$1,start_test,inst_13747,end_test,inst_13748);
var inst_13788 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_13747,inst_13748);
var state_13860__$1 = (function (){var statearr_13900 = state_13860;
(statearr_13900[(34)] = inst_13786__$1);

(statearr_13900[(19)] = inst_13787);

return statearr_13900;
})();
if(inst_13788){
var statearr_13901_14008 = state_13860__$1;
(statearr_13901_14008[(1)] = (57));

} else {
var statearr_13902_14009 = state_13860__$1;
(statearr_13902_14009[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (33))){
var inst_13667 = (state_13860[(35)]);
var inst_13728 = (state_13860[(2)]);
var state_13860__$1 = (function (){var statearr_13903 = state_13860;
(statearr_13903[(36)] = inst_13728);

return statearr_13903;
})();
if(cljs.core.truth_(inst_13667)){
var statearr_13904_14010 = state_13860__$1;
(statearr_13904_14010[(1)] = (34));

} else {
var statearr_13905_14011 = state_13860__$1;
(statearr_13905_14011[(1)] = (35));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (13))){
var inst_13688 = (state_13860[(2)]);
var inst_13689 = fluree.db.util.async.throw_err.call(null,inst_13688);
var state_13860__$1 = state_13860;
var statearr_13906_14012 = state_13860__$1;
(statearr_13906_14012[(2)] = inst_13689);

(statearr_13906_14012[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (22))){
var inst_13701 = (state_13860[(37)]);
var state_13860__$1 = state_13860;
var statearr_13907_14013 = state_13860__$1;
(statearr_13907_14013[(2)] = inst_13701);

(statearr_13907_14013[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (36))){
var inst_13674 = (state_13860[(31)]);
var inst_13737 = (state_13860[(2)]);
var state_13860__$1 = (function (){var statearr_13908 = state_13860;
(statearr_13908[(38)] = inst_13737);

return statearr_13908;
})();
if(cljs.core.truth_(inst_13674)){
var statearr_13909_14014 = state_13860__$1;
(statearr_13909_14014[(1)] = (40));

} else {
var statearr_13910_14015 = state_13860__$1;
(statearr_13910_14015[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (41))){
var inst_13740 = (cljs.core._LT__EQ_ === end_test);
var state_13860__$1 = state_13860;
if(cljs.core.truth_(inst_13740)){
var statearr_13911_14016 = state_13860__$1;
(statearr_13911_14016[(1)] = (43));

} else {
var statearr_13912_14017 = state_13860__$1;
(statearr_13912_14017[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (43))){
var state_13860__$1 = state_13860;
var statearr_13913_14018 = state_13860__$1;
(statearr_13913_14018[(2)] = (2147483647));

(statearr_13913_14018[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (61))){
var inst_13794 = (state_13860[(15)]);
var inst_13780 = (state_13860[(13)]);
var inst_13808 = cljs.core.seq.call(null,inst_13794);
var inst_13809 = cljs.core.first.call(null,inst_13808);
var inst_13810 = cljs.core.next.call(null,inst_13808);
var inst_13811 = inst_13794;
var inst_13812 = inst_13780;
var inst_13813 = inst_13794;
var state_13860__$1 = (function (){var statearr_13914 = state_13860;
(statearr_13914[(39)] = inst_13809);

(statearr_13914[(40)] = inst_13810);

(statearr_13914[(8)] = inst_13813);

(statearr_13914[(41)] = inst_13811);

(statearr_13914[(42)] = inst_13812);

return statearr_13914;
})();
var statearr_13915_14019 = state_13860__$1;
(statearr_13915_14019[(2)] = null);

(statearr_13915_14019[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (29))){
var state_13860__$1 = state_13860;
var statearr_13916_14020 = state_13860__$1;
(statearr_13916_14020[(2)] = false);

(statearr_13916_14020[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (44))){
var state_13860__$1 = state_13860;
var statearr_13917_14021 = state_13860__$1;
(statearr_13917_14021[(2)] = fluree.db.util.core.min_integer);

(statearr_13917_14021[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (6))){
var inst_13662 = (state_13860[(14)]);
var inst_13677 = fluree.db.dbproto._subid.call(null,db,inst_13662);
var state_13860__$1 = state_13860;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13860__$1,(9),inst_13677);
} else {
if((state_val_13861 === (28))){
var inst_13710 = (state_13860[(17)]);
var state_13860__$1 = state_13860;
var statearr_13918_14022 = state_13860__$1;
(statearr_13918_14022[(2)] = inst_13710);

(statearr_13918_14022[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (64))){
var inst_13832 = (state_13860[(2)]);
var state_13860__$1 = state_13860;
var statearr_13919_14023 = state_13860__$1;
(statearr_13919_14023[(2)] = inst_13832);

(statearr_13919_14023[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (51))){
var inst_13764 = (state_13860[(2)]);
var inst_13765 = new cljs.core.Keyword(null,"to-t","to-t",569467359).cljs$core$IFn$_invoke$arity$1(opts);
var inst_13766 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_13767 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_13768 = (new cljs.core.PersistentVector(null,2,(5),inst_13766,inst_13767,null));
var inst_13769 = cljs.core.get_in.call(null,db,inst_13768);
var inst_13770 = cljs.core.get.call(null,db,idx);
var inst_13771 = fluree.db.dbproto._resolve.call(null,inst_13770);
var state_13860__$1 = (function (){var statearr_13920 = state_13860;
(statearr_13920[(24)] = inst_13765);

(statearr_13920[(25)] = inst_13769);

(statearr_13920[(26)] = inst_13764);

return statearr_13920;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13860__$1,(52),inst_13771);
} else {
if((state_val_13861 === (25))){
var state_13860__$1 = state_13860;
var statearr_13921_14024 = state_13860__$1;
(statearr_13921_14024[(2)] = (-1));

(statearr_13921_14024[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (34))){
var inst_13667 = (state_13860[(35)]);
var state_13860__$1 = state_13860;
var statearr_13922_14025 = state_13860__$1;
(statearr_13922_14025[(2)] = inst_13667);

(statearr_13922_14025[(1)] = (36));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (17))){
var inst_13697 = (state_13860[(2)]);
var inst_13698 = fluree.db.util.async.throw_err.call(null,inst_13697);
var state_13860__$1 = state_13860;
var statearr_13923_14026 = state_13860__$1;
(statearr_13923_14026[(2)] = inst_13698);

(statearr_13923_14026[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (3))){
var inst_13858 = (state_13860[(2)]);
var state_13860__$1 = state_13860;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13860__$1,inst_13858);
} else {
if((state_val_13861 === (12))){
var inst_13664 = (state_13860[(27)]);
var inst_13692 = (state_13860[(2)]);
var inst_13693 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13664);
var state_13860__$1 = (function (){var statearr_13925 = state_13860;
(statearr_13925[(43)] = inst_13692);

return statearr_13925;
})();
if(inst_13693){
var statearr_13926_14027 = state_13860__$1;
(statearr_13926_14027[(1)] = (14));

} else {
var statearr_13927_14028 = state_13860__$1;
(statearr_13927_14028[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (2))){
var inst_13668 = (state_13860[(44)]);
var inst_13662 = (state_13860[(14)]);
var inst_13661 = (state_13860[(45)]);
var _ = (function (){var statearr_13928 = state_13860;
(statearr_13928[(4)] = cljs.core.cons.call(null,(5),(state_13860[(4)])));

return statearr_13928;
})();
var inst_13661__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_13662__$1 = cljs.core.nth.call(null,inst_13661__$1,(0),null);
var inst_13663 = cljs.core.nth.call(null,inst_13661__$1,(1),null);
var inst_13664 = cljs.core.nth.call(null,inst_13661__$1,(2),null);
var inst_13665 = cljs.core.nth.call(null,inst_13661__$1,(3),null);
var inst_13666 = cljs.core.nth.call(null,inst_13661__$1,(4),null);
var inst_13667 = cljs.core.nth.call(null,inst_13661__$1,(5),null);
var inst_13668__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_13669 = cljs.core.nth.call(null,inst_13668__$1,(0),null);
var inst_13670 = cljs.core.nth.call(null,inst_13668__$1,(1),null);
var inst_13671 = cljs.core.nth.call(null,inst_13668__$1,(2),null);
var inst_13672 = cljs.core.nth.call(null,inst_13668__$1,(3),null);
var inst_13673 = cljs.core.nth.call(null,inst_13668__$1,(4),null);
var inst_13674 = cljs.core.nth.call(null,inst_13668__$1,(5),null);
var inst_13675 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13662__$1);
var state_13860__$1 = (function (){var statearr_13929 = state_13860;
(statearr_13929[(31)] = inst_13674);

(statearr_13929[(44)] = inst_13668__$1);

(statearr_13929[(46)] = inst_13671);

(statearr_13929[(14)] = inst_13662__$1);

(statearr_13929[(47)] = inst_13672);

(statearr_13929[(48)] = inst_13665);

(statearr_13929[(35)] = inst_13667);

(statearr_13929[(27)] = inst_13664);

(statearr_13929[(21)] = inst_13670);

(statearr_13929[(49)] = inst_13666);

(statearr_13929[(16)] = inst_13663);

(statearr_13929[(45)] = inst_13661__$1);

(statearr_13929[(50)] = inst_13669);

(statearr_13929[(51)] = inst_13673);

return statearr_13929;
})();
if(inst_13675){
var statearr_13930_14029 = state_13860__$1;
(statearr_13930_14029[(1)] = (6));

} else {
var statearr_13931_14030 = state_13860__$1;
(statearr_13931_14030[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (66))){
var inst_13820 = (state_13860[(52)]);
var inst_13813 = (state_13860[(8)]);
var inst_13812 = (state_13860[(42)]);
var inst_13827 = (inst_13812 + (1));
var tmp13924 = inst_13813;
var inst_13811 = inst_13820;
var inst_13812__$1 = inst_13827;
var inst_13813__$1 = tmp13924;
var state_13860__$1 = (function (){var statearr_13932 = state_13860;
(statearr_13932[(8)] = inst_13813__$1);

(statearr_13932[(41)] = inst_13811);

(statearr_13932[(42)] = inst_13812__$1);

return statearr_13932;
})();
var statearr_13933_14031 = state_13860__$1;
(statearr_13933_14031[(2)] = null);

(statearr_13933_14031[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (23))){
var state_13860__$1 = state_13860;
var statearr_13934_14032 = state_13860__$1;
(statearr_13934_14032[(2)] = false);

(statearr_13934_14032[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (47))){
var state_13860__$1 = state_13860;
var statearr_13935_14033 = state_13860__$1;
(statearr_13935_14033[(2)] = fluree.db.util.core.max_long);

(statearr_13935_14033[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (35))){
var inst_13731 = (cljs.core._GT__EQ_ === start_test);
var state_13860__$1 = state_13860;
if(cljs.core.truth_(inst_13731)){
var statearr_13936_14034 = state_13860__$1;
(statearr_13936_14034[(1)] = (37));

} else {
var statearr_13937_14035 = state_13860__$1;
(statearr_13937_14035[(1)] = (38));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (19))){
var inst_13671 = (state_13860[(46)]);
var state_13860__$1 = state_13860;
var statearr_13938_14036 = state_13860__$1;
(statearr_13938_14036[(2)] = inst_13671);

(statearr_13938_14036[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (57))){
var inst_13737 = (state_13860[(38)]);
var inst_13719 = (state_13860[(22)]);
var inst_13765 = (state_13860[(24)]);
var inst_13769 = (state_13860[(25)]);
var inst_13747 = (state_13860[(32)]);
var inst_13764 = (state_13860[(26)]);
var inst_13753 = (state_13860[(20)]);
var inst_13668 = (state_13860[(44)]);
var inst_13774 = (state_13860[(18)]);
var inst_13781 = (state_13860[(7)]);
var inst_13672 = (state_13860[(47)]);
var inst_13746 = (state_13860[(53)]);
var inst_13748 = (state_13860[(33)]);
var inst_13665 = (state_13860[(48)]);
var inst_13779 = (state_13860[(12)]);
var inst_13786 = (state_13860[(34)]);
var inst_13758 = (state_13860[(29)]);
var inst_13701 = (state_13860[(37)]);
var inst_13780 = (state_13860[(13)]);
var inst_13728 = (state_13860[(36)]);
var inst_13666 = (state_13860[(49)]);
var inst_13787 = (state_13860[(19)]);
var inst_13710 = (state_13860[(17)]);
var inst_13661 = (state_13860[(45)]);
var inst_13683 = (state_13860[(54)]);
var inst_13754 = (state_13860[(30)]);
var inst_13692 = (state_13860[(43)]);
var inst_13673 = (state_13860[(51)]);
var inst_13790 = (function (){var no_filter_QMARK_ = true;
var next_node = inst_13779;
var flakes = inst_13786;
var s1 = inst_13683;
var o2 = inst_13710;
var t1 = inst_13665;
var i = inst_13780;
var m1 = inst_13737;
var root_node = inst_13774;
var to_t = inst_13765;
var s2 = inst_13692;
var p2 = inst_13728;
var permissions = inst_13754;
var limit = inst_13753;
var start_flake = inst_13747;
var acc = inst_13781;
var t2 = inst_13672;
var op1 = inst_13666;
var o1 = inst_13701;
var end_flake = inst_13748;
var base_result = inst_13787;
var p1 = inst_13719;
var vec__13658 = inst_13668;
var idx_compare = inst_13758;
var op2 = inst_13673;
var from_t = inst_13764;
var m2 = inst_13746;
var vec__13655 = inst_13661;
var novelty = inst_13769;
return (function (filtered_result,f){
if(cljs.core._EQ_.call(null,f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.call(null,filtered_result,f);
}
});
})();
var inst_13791 = cljs.core.reduce.call(null,inst_13790,inst_13787,inst_13787);
var state_13860__$1 = state_13860;
var statearr_13939_14037 = state_13860__$1;
(statearr_13939_14037[(2)] = inst_13791);

(statearr_13939_14037[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (68))){
var inst_13753 = (state_13860[(20)]);
var inst_13795 = (state_13860[(9)]);
var inst_13748 = (state_13860[(33)]);
var inst_13758 = (state_13860[(29)]);
var inst_13835 = (state_13860[(11)]);
var inst_13837 = inst_13758.call(null,inst_13795,inst_13748);
var inst_13838 = (inst_13837 < (0));
var inst_13839 = (inst_13835 < inst_13753);
var inst_13840 = ((inst_13838) && (inst_13839));
var state_13860__$1 = state_13860;
var statearr_13940_14038 = state_13860__$1;
(statearr_13940_14038[(2)] = inst_13840);

(statearr_13940_14038[(1)] = (70));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (11))){
var inst_13669 = (state_13860[(50)]);
var state_13860__$1 = state_13860;
var statearr_13942_14039 = state_13860__$1;
(statearr_13942_14039[(2)] = inst_13669);

(statearr_13942_14039[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (9))){
var inst_13679 = (state_13860[(2)]);
var inst_13680 = fluree.db.util.async.throw_err.call(null,inst_13679);
var state_13860__$1 = state_13860;
var statearr_13943_14040 = state_13860__$1;
(statearr_13943_14040[(2)] = inst_13680);

(statearr_13943_14040[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (5))){
var _ = (function (){var statearr_13944 = state_13860;
(statearr_13944[(4)] = cljs.core.rest.call(null,(state_13860[(4)])));

return statearr_13944;
})();
var state_13860__$1 = state_13860;
var ex13941 = (state_13860__$1[(2)]);
var statearr_13945_14041 = state_13860__$1;
(statearr_13945_14041[(5)] = ex13941);


if((ex13941 instanceof Error)){
var statearr_13946_14042 = state_13860__$1;
(statearr_13946_14042[(1)] = (4));

(statearr_13946_14042[(5)] = null);

} else {
throw ex13941;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (14))){
var inst_13664 = (state_13860[(27)]);
var inst_13695 = fluree.db.dbproto._subid.call(null,db,inst_13664);
var state_13860__$1 = state_13860;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13860__$1,(17),inst_13695);
} else {
if((state_val_13861 === (45))){
var inst_13744 = (state_13860[(2)]);
var state_13860__$1 = state_13860;
var statearr_13947_14043 = state_13860__$1;
(statearr_13947_14043[(2)] = inst_13744);

(statearr_13947_14043[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (53))){
var inst_13777 = (state_13860[(2)]);
var inst_13778 = fluree.db.util.async.throw_err.call(null,inst_13777);
var inst_13779 = inst_13778;
var inst_13780 = (0);
var inst_13781 = null;
var state_13860__$1 = (function (){var statearr_13948 = state_13860;
(statearr_13948[(7)] = inst_13781);

(statearr_13948[(12)] = inst_13779);

(statearr_13948[(13)] = inst_13780);

return statearr_13948;
})();
var statearr_13949_14044 = state_13860__$1;
(statearr_13949_14044[(2)] = null);

(statearr_13949_14044[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (26))){
var inst_13663 = (state_13860[(16)]);
var state_13860__$1 = state_13860;
var statearr_13950_14045 = state_13860__$1;
(statearr_13950_14045[(2)] = inst_13663);

(statearr_13950_14045[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (16))){
var inst_13671 = (state_13860[(46)]);
var inst_13701 = (state_13860[(2)]);
var inst_13702 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13671);
var state_13860__$1 = (function (){var statearr_13951 = state_13860;
(statearr_13951[(37)] = inst_13701);

return statearr_13951;
})();
if(inst_13702){
var statearr_13952_14046 = state_13860__$1;
(statearr_13952_14046[(1)] = (18));

} else {
var statearr_13953_14047 = state_13860__$1;
(statearr_13953_14047[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (38))){
var state_13860__$1 = state_13860;
var statearr_13954_14048 = state_13860__$1;
(statearr_13954_14048[(2)] = (2147483647));

(statearr_13954_14048[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (30))){
var inst_13724 = (state_13860[(2)]);
var state_13860__$1 = state_13860;
if(cljs.core.truth_(inst_13724)){
var statearr_13955_14049 = state_13860__$1;
(statearr_13955_14049[(1)] = (31));

} else {
var statearr_13956_14050 = state_13860__$1;
(statearr_13956_14050[(1)] = (32));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (73))){
var inst_13853 = (state_13860[(2)]);
var state_13860__$1 = state_13860;
var statearr_13957_14051 = state_13860__$1;
(statearr_13957_14051[(2)] = inst_13853);

(statearr_13957_14051[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (10))){
var inst_13669 = (state_13860[(50)]);
var inst_13686 = fluree.db.dbproto._subid.call(null,db,inst_13669);
var state_13860__$1 = state_13860;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13860__$1,(13),inst_13686);
} else {
if((state_val_13861 === (18))){
var inst_13671 = (state_13860[(46)]);
var inst_13704 = fluree.db.dbproto._subid.call(null,db,inst_13671);
var state_13860__$1 = state_13860;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13860__$1,(21),inst_13704);
} else {
if((state_val_13861 === (52))){
var inst_13747 = (state_13860[(32)]);
var inst_13774 = (state_13860[(18)]);
var inst_13773 = (state_13860[(2)]);
var inst_13774__$1 = fluree.db.util.async.throw_err.call(null,inst_13773);
var inst_13775 = fluree.db.dbproto._lookup_leaf.call(null,inst_13774__$1,inst_13747);
var state_13860__$1 = (function (){var statearr_13958 = state_13860;
(statearr_13958[(18)] = inst_13774__$1);

return statearr_13958;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13860__$1,(53),inst_13775);
} else {
if((state_val_13861 === (67))){
var inst_13830 = (state_13860[(2)]);
var state_13860__$1 = state_13860;
var statearr_13959_14052 = state_13860__$1;
(statearr_13959_14052[(2)] = inst_13830);

(statearr_13959_14052[(1)] = (64));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (71))){
var inst_13834 = (state_13860[(10)]);
var state_13860__$1 = state_13860;
var statearr_13960_14053 = state_13860__$1;
(statearr_13960_14053[(2)] = inst_13834);

(statearr_13960_14053[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (42))){
var inst_13737 = (state_13860[(38)]);
var inst_13719 = (state_13860[(22)]);
var inst_13672 = (state_13860[(47)]);
var inst_13746 = (state_13860[(53)]);
var inst_13665 = (state_13860[(48)]);
var inst_13701 = (state_13860[(37)]);
var inst_13728 = (state_13860[(36)]);
var inst_13666 = (state_13860[(49)]);
var inst_13710 = (state_13860[(17)]);
var inst_13683 = (state_13860[(54)]);
var inst_13749 = (state_13860[(23)]);
var inst_13692 = (state_13860[(43)]);
var inst_13673 = (state_13860[(51)]);
var inst_13746__$1 = (state_13860[(2)]);
var inst_13747 = fluree.db.flake.__GT_Flake.call(null,inst_13683,inst_13719,inst_13701,inst_13665,inst_13666,inst_13737);
var inst_13748 = fluree.db.flake.__GT_Flake.call(null,inst_13692,inst_13728,inst_13710,inst_13672,inst_13673,inst_13746__$1);
var inst_13749__$1 = new cljs.core.Keyword(null,"limit","limit",-1355822363).cljs$core$IFn$_invoke$arity$1(opts);
var state_13860__$1 = (function (){var statearr_13961 = state_13860;
(statearr_13961[(32)] = inst_13747);

(statearr_13961[(53)] = inst_13746__$1);

(statearr_13961[(33)] = inst_13748);

(statearr_13961[(23)] = inst_13749__$1);

return statearr_13961;
})();
if(cljs.core.truth_(inst_13749__$1)){
var statearr_13962_14054 = state_13860__$1;
(statearr_13962_14054[(1)] = (46));

} else {
var statearr_13963_14055 = state_13860__$1;
(statearr_13963_14055[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (37))){
var state_13860__$1 = state_13860;
var statearr_13964_14056 = state_13860__$1;
(statearr_13964_14056[(2)] = fluree.db.util.core.min_integer);

(statearr_13964_14056[(1)] = (39));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (63))){
var inst_13753 = (state_13860[(20)]);
var inst_13811 = (state_13860[(41)]);
var inst_13812 = (state_13860[(42)]);
var inst_13818 = cljs.core.seq.call(null,inst_13811);
var inst_13819 = cljs.core.first.call(null,inst_13818);
var inst_13820 = cljs.core.next.call(null,inst_13818);
var inst_13821 = (inst_13819 == null);
var inst_13822 = (inst_13812 > inst_13753);
var inst_13823 = ((inst_13821) || (inst_13822));
var state_13860__$1 = (function (){var statearr_13965 = state_13860;
(statearr_13965[(52)] = inst_13820);

return statearr_13965;
})();
if(cljs.core.truth_(inst_13823)){
var statearr_13966_14057 = state_13860__$1;
(statearr_13966_14057[(1)] = (65));

} else {
var statearr_13967_14058 = state_13860__$1;
(statearr_13967_14058[(1)] = (66));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (8))){
var inst_13669 = (state_13860[(50)]);
var inst_13683 = (state_13860[(2)]);
var inst_13684 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_13669);
var state_13860__$1 = (function (){var statearr_13968 = state_13860;
(statearr_13968[(54)] = inst_13683);

return statearr_13968;
})();
if(inst_13684){
var statearr_13969_14059 = state_13860__$1;
(statearr_13969_14059[(1)] = (10));

} else {
var statearr_13970_14060 = state_13860__$1;
(statearr_13970_14060[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13861 === (49))){
var inst_13759 = (state_13860[(28)]);
var state_13860__$1 = state_13860;
var statearr_13971_14061 = state_13860__$1;
(statearr_13971_14061[(2)] = inst_13759);

(statearr_13971_14061[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2879__auto__ = null;
var fluree$db$query$range$state_machine__2879__auto____0 = (function (){
var statearr_13972 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13972[(0)] = fluree$db$query$range$state_machine__2879__auto__);

(statearr_13972[(1)] = (1));

return statearr_13972;
});
var fluree$db$query$range$state_machine__2879__auto____1 = (function (state_13860){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_13860);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e13973){var ex__2882__auto__ = e13973;
var statearr_13974_14062 = state_13860;
(statearr_13974_14062[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_13860[(4)]))){
var statearr_13975_14063 = state_13860;
(statearr_13975_14063[(1)] = cljs.core.first.call(null,(state_13860[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14064 = state_13860;
state_13860 = G__14064;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2879__auto__ = function(state_13860){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2879__auto____1.call(this,state_13860);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2879__auto____0;
fluree$db$query$range$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2879__auto____1;
return fluree$db$query$range$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_13976 = f__2902__auto__.call(null);
(statearr_13976[(6)] = c__2901__auto__);

return statearr_13976;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_14114){
var state_val_14115 = (state_14114[(1)]);
if((state_val_14115 === (7))){
var state_14114__$1 = state_14114;
var statearr_14116_14135 = state_14114__$1;
(statearr_14116_14135[(2)] = (0));

(statearr_14116_14135[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (1))){
var inst_14072 = subject_groups;
var inst_14073 = cljs.core.seq.call(null,inst_14072);
var inst_14074 = cljs.core.first.call(null,inst_14073);
var inst_14075 = cljs.core.next.call(null,inst_14073);
var inst_14076 = flake_start;
var inst_14077 = subject_start;
var inst_14078 = cljs.core.PersistentVector.EMPTY;
var inst_14079 = inst_14072;
var inst_14080 = inst_14076;
var inst_14081 = inst_14077;
var inst_14082 = inst_14078;
var state_14114__$1 = (function (){var statearr_14117 = state_14114;
(statearr_14117[(7)] = inst_14075);

(statearr_14117[(8)] = inst_14082);

(statearr_14117[(9)] = inst_14081);

(statearr_14117[(10)] = inst_14080);

(statearr_14117[(11)] = inst_14079);

(statearr_14117[(12)] = inst_14074);

return statearr_14117;
})();
var statearr_14118_14136 = state_14114__$1;
(statearr_14118_14136[(2)] = null);

(statearr_14118_14136[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (4))){
var inst_14082 = (state_14114[(8)]);
var inst_14081 = (state_14114[(9)]);
var inst_14080 = (state_14114[(10)]);
var inst_14095 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14096 = [inst_14080,inst_14081,inst_14082];
var inst_14097 = (new cljs.core.PersistentVector(null,3,(5),inst_14095,inst_14096,null));
var state_14114__$1 = state_14114;
var statearr_14119_14137 = state_14114__$1;
(statearr_14119_14137[(2)] = inst_14097);

(statearr_14119_14137[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (6))){
var inst_14110 = (state_14114[(2)]);
var state_14114__$1 = state_14114;
var statearr_14120_14138 = state_14114__$1;
(statearr_14120_14138[(2)] = inst_14110);

(statearr_14120_14138[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (3))){
var inst_14112 = (state_14114[(2)]);
var state_14114__$1 = state_14114;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14114__$1,inst_14112);
} else {
if((state_val_14115 === (2))){
var inst_14088 = (state_14114[(13)]);
var inst_14081 = (state_14114[(9)]);
var inst_14080 = (state_14114[(10)]);
var inst_14079 = (state_14114[(11)]);
var inst_14087 = cljs.core.seq.call(null,inst_14079);
var inst_14088__$1 = cljs.core.first.call(null,inst_14087);
var inst_14089 = cljs.core.next.call(null,inst_14087);
var inst_14090 = (inst_14088__$1 == null);
var inst_14091 = (inst_14080 >= flake_limit);
var inst_14092 = (inst_14081 >= subject_limit);
var inst_14093 = ((inst_14090) || (inst_14091) || (inst_14092));
var state_14114__$1 = (function (){var statearr_14121 = state_14114;
(statearr_14121[(13)] = inst_14088__$1);

(statearr_14121[(14)] = inst_14089);

return statearr_14121;
})();
if(cljs.core.truth_(inst_14093)){
var statearr_14122_14139 = state_14114__$1;
(statearr_14122_14139[(1)] = (4));

} else {
var statearr_14123_14140 = state_14114__$1;
(statearr_14123_14140[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (9))){
var inst_14099 = (state_14114[(15)]);
var inst_14088 = (state_14114[(13)]);
var inst_14082 = (state_14114[(8)]);
var inst_14081 = (state_14114[(9)]);
var inst_14080 = (state_14114[(10)]);
var inst_14089 = (state_14114[(14)]);
var inst_14104 = (state_14114[(2)]);
var inst_14105 = (inst_14080 + inst_14099);
var inst_14106 = (inst_14081 + inst_14104);
var inst_14107 = cljs.core.into.call(null,inst_14082,inst_14088);
var inst_14079 = inst_14089;
var inst_14080__$1 = inst_14105;
var inst_14081__$1 = inst_14106;
var inst_14082__$1 = inst_14107;
var state_14114__$1 = (function (){var statearr_14124 = state_14114;
(statearr_14124[(8)] = inst_14082__$1);

(statearr_14124[(9)] = inst_14081__$1);

(statearr_14124[(10)] = inst_14080__$1);

(statearr_14124[(11)] = inst_14079);

return statearr_14124;
})();
var statearr_14125_14141 = state_14114__$1;
(statearr_14125_14141[(2)] = null);

(statearr_14125_14141[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (5))){
var inst_14099 = (state_14114[(15)]);
var inst_14088 = (state_14114[(13)]);
var inst_14099__$1 = cljs.core.count.call(null,inst_14088);
var inst_14100 = cljs.core._EQ_.call(null,(0),inst_14099__$1);
var state_14114__$1 = (function (){var statearr_14126 = state_14114;
(statearr_14126[(15)] = inst_14099__$1);

return statearr_14126;
})();
if(inst_14100){
var statearr_14127_14142 = state_14114__$1;
(statearr_14127_14142[(1)] = (7));

} else {
var statearr_14128_14143 = state_14114__$1;
(statearr_14128_14143[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14115 === (8))){
var state_14114__$1 = state_14114;
var statearr_14129_14144 = state_14114__$1;
(statearr_14129_14144[(2)] = (1));

(statearr_14129_14144[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto____0 = (function (){
var statearr_14130 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14130[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto__);

(statearr_14130[(1)] = (1));

return statearr_14130;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto____1 = (function (state_14114){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_14114);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e14131){var ex__2882__auto__ = e14131;
var statearr_14132_14145 = state_14114;
(statearr_14132_14145[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_14114[(4)]))){
var statearr_14133_14146 = state_14114;
(statearr_14133_14146[(1)] = cljs.core.first.call(null,(state_14114[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14147 = state_14114;
state_14114 = G__14147;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto__ = function(state_14114){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto____1.call(this,state_14114);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_14134 = f__2902__auto__.call(null);
(statearr_14134[(6)] = c__2901__auto__);

return statearr_14134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_14193){
var state_val_14194 = (state_14193[(1)]);
if((state_val_14194 === (7))){
var state_14193__$1 = state_14193;
var statearr_14195_14233 = state_14193__$1;
(statearr_14195_14233[(2)] = null);

(statearr_14195_14233[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14194 === (20))){
var inst_14179 = (state_14193[(2)]);
var inst_14180 = fluree.db.util.async.throw_err.call(null,inst_14179);
var inst_14158 = inst_14180;
var state_14193__$1 = (function (){var statearr_14196 = state_14193;
(statearr_14196[(7)] = inst_14158);

return statearr_14196;
})();
var statearr_14197_14234 = state_14193__$1;
(statearr_14197_14234[(2)] = null);

(statearr_14197_14234[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14194 === (1))){
var state_14193__$1 = state_14193;
var statearr_14198_14235 = state_14193__$1;
(statearr_14198_14235[(2)] = null);

(statearr_14198_14235[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14194 === (4))){
var inst_14148 = (state_14193[(2)]);
var state_14193__$1 = state_14193;
var statearr_14199_14236 = state_14193__$1;
(statearr_14199_14236[(2)] = inst_14148);

(statearr_14199_14236[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14194 === (15))){
var inst_14175 = (state_14193[(8)]);
var inst_14158 = (state_14193[(7)]);
var inst_14175__$1 = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(inst_14158);
var state_14193__$1 = (function (){var statearr_14200 = state_14193;
(statearr_14200[(8)] = inst_14175__$1);

return statearr_14200;
})();
if(cljs.core.truth_(inst_14175__$1)){
var statearr_14201_14237 = state_14193__$1;
(statearr_14201_14237[(1)] = (17));

} else {
var statearr_14202_14238 = state_14193__$1;
(statearr_14202_14238[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14194 === (13))){
var inst_14168 = (state_14193[(2)]);
var inst_14169 = fluree.db.util.async.throw_err.call(null,inst_14168);
var _ = (function (){var statearr_14203 = state_14193;
(statearr_14203[(4)] = cljs.core.rest.call(null,(state_14193[(4)])));

return statearr_14203;
})();
var state_14193__$1 = state_14193;
var statearr_14204_14239 = state_14193__$1;
(statearr_14204_14239[(2)] = inst_14169);

(statearr_14204_14239[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14194 === (6))){
var inst_14156 = (state_14193[(2)]);
var inst_14157 = fluree.db.util.async.throw_err.call(null,inst_14156);
var inst_14158 = inst_14157;
var state_14193__$1 = (function (){var statearr_14205 = state_14193;
(statearr_14205[(7)] = inst_14158);

return statearr_14205;
})();
var statearr_14206_14240 = state_14193__$1;
(statearr_14206_14240[(2)] = null);

(statearr_14206_14240[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14194 === (17))){
var inst_14175 = (state_14193[(8)]);
var inst_14177 = fluree.db.dbproto._lookup_leaf.call(null,root_node,inst_14175);
var state_14193__$1 = state_14193;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14193__$1,(20),inst_14177);
} else {
if((state_val_14194 === (3))){
var inst_14191 = (state_14193[(2)]);
var state_14193__$1 = state_14193;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14193__$1,inst_14191);
} else {
if((state_val_14194 === (12))){
var _ = (function (){var statearr_14208 = state_14193;
(statearr_14208[(4)] = cljs.core.rest.call(null,(state_14193[(4)])));

return statearr_14208;
})();
var state_14193__$1 = state_14193;
var ex14207 = (state_14193__$1[(2)]);
var statearr_14209_14241 = state_14193__$1;
(statearr_14209_14241[(5)] = ex14207);


var statearr_14210_14242 = state_14193__$1;
(statearr_14210_14242[(1)] = (11));

(statearr_14210_14242[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14194 === (2))){
var _ = (function (){var statearr_14211 = state_14193;
(statearr_14211[(4)] = cljs.core.cons.call(null,(5),(state_14193[(4)])));

return statearr_14211;
})();
var inst_14154 = fluree.db.dbproto._lookup_leaf.call(null,root_node,rhs);
var state_14193__$1 = state_14193;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14193__$1,(6),inst_14154);
} else {
if((state_val_14194 === (19))){
var inst_14184 = (state_14193[(2)]);
var state_14193__$1 = state_14193;
var statearr_14212_14243 = state_14193__$1;
(statearr_14212_14243[(2)] = inst_14184);

(statearr_14212_14243[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14194 === (11))){
var inst_14160 = (state_14193[(2)]);
var state_14193__$1 = (function (){var statearr_14214 = state_14193;
(statearr_14214[(9)] = inst_14160);

return statearr_14214;
})();
var statearr_14215_14244 = state_14193__$1;
(statearr_14215_14244[(2)] = null);

(statearr_14215_14244[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14194 === (9))){
var inst_14158 = (state_14193[(7)]);
var _ = (function (){var statearr_14216 = state_14193;
(statearr_14216[(4)] = cljs.core.cons.call(null,(12),(state_14193[(4)])));

return statearr_14216;
})();
var inst_14166 = fluree.db.dbproto._resolve_to_t.call(null,inst_14158,t,novelty,fast_forward_db_QMARK_);
var state_14193__$1 = state_14193;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14193__$1,(13),inst_14166);
} else {
if((state_val_14194 === (5))){
var _ = (function (){var statearr_14217 = state_14193;
(statearr_14217[(4)] = cljs.core.rest.call(null,(state_14193[(4)])));

return statearr_14217;
})();
var state_14193__$1 = state_14193;
var ex14213 = (state_14193__$1[(2)]);
var statearr_14218_14245 = state_14193__$1;
(statearr_14218_14245[(5)] = ex14213);


if((ex14213 instanceof Error)){
var statearr_14219_14246 = state_14193__$1;
(statearr_14219_14246[(1)] = (4));

(statearr_14219_14246[(5)] = null);

} else {
throw ex14213;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14194 === (14))){
var inst_14172 = (state_14193[(10)]);
var state_14193__$1 = state_14193;
var statearr_14220_14247 = state_14193__$1;
(statearr_14220_14247[(2)] = inst_14172);

(statearr_14220_14247[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14194 === (16))){
var inst_14186 = (state_14193[(2)]);
var state_14193__$1 = state_14193;
var statearr_14221_14248 = state_14193__$1;
(statearr_14221_14248[(2)] = inst_14186);

(statearr_14221_14248[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14194 === (10))){
var inst_14172 = (state_14193[(10)]);
var inst_14172__$1 = (state_14193[(2)]);
var state_14193__$1 = (function (){var statearr_14222 = state_14193;
(statearr_14222[(10)] = inst_14172__$1);

return statearr_14222;
})();
if(cljs.core.truth_(inst_14172__$1)){
var statearr_14223_14249 = state_14193__$1;
(statearr_14223_14249[(1)] = (14));

} else {
var statearr_14224_14250 = state_14193__$1;
(statearr_14224_14250[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14194 === (18))){
var state_14193__$1 = state_14193;
var statearr_14225_14251 = state_14193__$1;
(statearr_14225_14251[(2)] = null);

(statearr_14225_14251[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14194 === (8))){
var inst_14188 = (state_14193[(2)]);
var _ = (function (){var statearr_14226 = state_14193;
(statearr_14226[(4)] = cljs.core.rest.call(null,(state_14193[(4)])));

return statearr_14226;
})();
var state_14193__$1 = state_14193;
var statearr_14227_14252 = state_14193__$1;
(statearr_14227_14252[(2)] = inst_14188);

(statearr_14227_14252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto____0 = (function (){
var statearr_14228 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14228[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto__);

(statearr_14228[(1)] = (1));

return statearr_14228;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto____1 = (function (state_14193){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_14193);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e14229){var ex__2882__auto__ = e14229;
var statearr_14230_14253 = state_14193;
(statearr_14230_14253[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_14193[(4)]))){
var statearr_14231_14254 = state_14193;
(statearr_14231_14254[(1)] = cljs.core.first.call(null,(state_14193[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14255 = state_14193;
state_14193 = G__14255;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto__ = function(state_14193){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto____1.call(this,state_14193);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_14232 = f__2902__auto__.call(null);
(statearr_14232[(6)] = c__2901__auto__);

return statearr_14232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__14262 = arguments.length;
switch (G__14262) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.call(null,db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.call(null,db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__14263 = (function (){var pred__14266 = cljs.core.identical_QMARK_;
var expr__14267 = test;
if(cljs.core.truth_(pred__14266.call(null,cljs.core._EQ_,expr__14267))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__14266.call(null,cljs.core._LT_,expr__14267))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_(pred__14266.call(null,cljs.core._LT__EQ_,expr__14267))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match.call(null,idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_(pred__14266.call(null,cljs.core._GT_,expr__14267))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
if(cljs.core.truth_(pred__14266.call(null,cljs.core._GT__EQ_,expr__14267))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match.call(null,idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__14267)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.call(null,vec__14263,(0),null);
var start_match = cljs.core.nth.call(null,vec__14263,(1),null);
var end_test = cljs.core.nth.call(null,vec__14263,(2),null);
var end_match = cljs.core.nth.call(null,vec__14263,(3),null);
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.call(null,db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_14666){
var state_val_14667 = (state_14666[(1)]);
if((state_val_14667 === (121))){
var inst_14527 = (state_14666[(7)]);
var state_14666__$1 = state_14666;
var statearr_14668_14871 = state_14666__$1;
(statearr_14668_14871[(2)] = inst_14527);

(statearr_14668_14871[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (65))){
var state_14666__$1 = state_14666;
var statearr_14669_14872 = state_14666__$1;
(statearr_14669_14872[(2)] = fluree.db.util.core.min_integer);

(statearr_14669_14872[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (70))){
var state_14666__$1 = state_14666;
var statearr_14670_14873 = state_14666__$1;
(statearr_14670_14873[(2)] = true);

(statearr_14670_14873[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (62))){
var inst_14429 = (cljs.core._LT__EQ_ === end_test);
var state_14666__$1 = state_14666;
if(cljs.core.truth_(inst_14429)){
var statearr_14671_14874 = state_14666__$1;
(statearr_14671_14874[(1)] = (64));

} else {
var statearr_14672_14875 = state_14666__$1;
(statearr_14672_14875[(1)] = (65));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (74))){
var inst_14438 = (state_14666[(8)]);
var state_14666__$1 = state_14666;
var statearr_14673_14876 = state_14666__$1;
(statearr_14673_14876[(2)] = inst_14438);

(statearr_14673_14876[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (110))){
var inst_14568 = (state_14666[(9)]);
var inst_14466 = (state_14666[(10)]);
var inst_14560 = (state_14666[(11)]);
var inst_14493 = (state_14666[(12)]);
var inst_14569 = (state_14666[(13)]);
var inst_14570 = (state_14666[(14)]);
var inst_14568__$1 = cljs.core.count.call(null,inst_14560);
var inst_14569__$1 = (inst_14493 + inst_14568__$1);
var inst_14570__$1 = (inst_14569__$1 - inst_14466);
var inst_14571 = cljs.core.pos_int_QMARK_.call(null,inst_14570__$1);
var state_14666__$1 = (function (){var statearr_14674 = state_14666;
(statearr_14674[(9)] = inst_14568__$1);

(statearr_14674[(13)] = inst_14569__$1);

(statearr_14674[(14)] = inst_14570__$1);

return statearr_14674;
})();
if(inst_14571){
var statearr_14675_14877 = state_14666__$1;
(statearr_14675_14877[(1)] = (113));

} else {
var statearr_14676_14878 = state_14666__$1;
(statearr_14676_14878[(1)] = (114));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (130))){
var inst_14629 = (state_14666[(15)]);
var state_14666__$1 = state_14666;
var statearr_14677_14879 = state_14666__$1;
(statearr_14677_14879[(2)] = inst_14629);

(statearr_14677_14879[(1)] = (132));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (128))){
var inst_14638 = (state_14666[(16)]);
var state_14666__$1 = state_14666;
var statearr_14678_14880 = state_14666__$1;
(statearr_14678_14880[(2)] = inst_14638);

(statearr_14678_14880[(1)] = (129));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (7))){
var state_14666__$1 = state_14666;
var statearr_14679_14881 = state_14666__$1;
(statearr_14679_14881[(2)] = false);

(statearr_14679_14881[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (59))){
var state_14666__$1 = state_14666;
var statearr_14680_14882 = state_14666__$1;
(statearr_14680_14882[(2)] = (2147483647));

(statearr_14680_14882[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (86))){
var inst_14436 = (state_14666[(17)]);
var inst_14491 = (state_14666[(18)]);
var inst_14494 = (state_14666[(19)]);
var inst_14466 = (state_14666[(10)]);
var inst_14377 = (state_14666[(20)]);
var inst_14325 = (state_14666[(21)]);
var inst_14426 = (state_14666[(22)]);
var inst_14326 = (state_14666[(23)]);
var inst_14345 = (state_14666[(24)]);
var inst_14473 = (state_14666[(25)]);
var inst_14487 = (state_14666[(26)]);
var inst_14294 = (state_14666[(27)]);
var inst_14490 = (state_14666[(28)]);
var inst_14435 = (state_14666[(29)]);
var inst_14301 = (state_14666[(30)]);
var inst_14408 = (state_14666[(31)]);
var inst_14293 = (state_14666[(32)]);
var inst_14459 = (state_14666[(33)]);
var inst_14467 = (state_14666[(34)]);
var inst_14336 = (state_14666[(35)]);
var inst_14460 = (state_14666[(36)]);
var inst_14289 = (state_14666[(37)]);
var inst_14324 = (state_14666[(38)]);
var inst_14296 = (state_14666[(39)]);
var inst_14399 = (state_14666[(40)]);
var inst_14437 = (state_14666[(41)]);
var inst_14390 = (state_14666[(42)]);
var inst_14472 = (state_14666[(43)]);
var inst_14378 = (state_14666[(44)]);
var inst_14483 = (state_14666[(45)]);
var inst_14493 = (state_14666[(12)]);
var inst_14478 = (state_14666[(46)]);
var inst_14468 = (state_14666[(47)]);
var inst_14492 = (state_14666[(48)]);
var inst_14500 = (state_14666[(49)]);
var inst_14381 = (state_14666[(50)]);
var inst_14477 = (state_14666[(51)]);
var inst_14417 = (state_14666[(52)]);
var inst_14300 = (state_14666[(53)]);
var inst_14504 = (function (){var G__14501 = inst_14500;
var no_filter_QMARK_ = true;
var t = inst_14473;
var max_limit_QMARK_ = inst_14467;
var next_node = inst_14490;
var fast_forward_db_QMARK_ = inst_14478;
var s1 = inst_14336;
var o2 = inst_14399;
var t1 = inst_14293;
var predicate_fn = inst_14326;
var i = inst_14492;
var m1 = inst_14426;
var root_node = inst_14483;
var s2 = inst_14345;
var p2 = inst_14417;
var map__14288 = inst_14459;
var permissions = inst_14468;
var limit = inst_14466;
var start_flake = inst_14436;
var map__14281 = inst_14324;
var flake_limit = inst_14460;
var offset = inst_14491;
var acc = inst_14494;
var t2 = inst_14300;
var op1 = inst_14294;
var o1 = inst_14390;
var end_flake = inst_14437;
var vec__14282 = inst_14377;
var base_result = inst_14500;
var s = inst_14493;
var node_start = inst_14487;
var p1 = inst_14408;
var subject_fn = inst_14325;
var vec__14278 = inst_14296;
var vec__14275 = inst_14289;
var object_fn = inst_14381;
var idx_compare = inst_14472;
var op2 = inst_14301;
var m2 = inst_14435;
var vec__14285 = inst_14378;
var novelty = inst_14477;
return (function (p1__14256_SHARP_){
return cljs.core._EQ_.call(null,p1__14256_SHARP_.o,start_flake.o);
});
})();
var inst_14505 = cljs.core.filter.call(null,inst_14504,inst_14500);
var state_14666__$1 = state_14666;
var statearr_14681_14883 = state_14666__$1;
(statearr_14681_14883[(2)] = inst_14505);

(statearr_14681_14883[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (20))){
var inst_14297 = (state_14666[(54)]);
var state_14666__$1 = state_14666;
var statearr_14682_14884 = state_14666__$1;
(statearr_14682_14884[(2)] = inst_14297);

(statearr_14682_14884[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (72))){
var inst_14451 = (state_14666[(2)]);
var state_14666__$1 = state_14666;
var statearr_14683_14885 = state_14666__$1;
(statearr_14683_14885[(2)] = inst_14451);

(statearr_14683_14885[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (58))){
var state_14666__$1 = state_14666;
var statearr_14684_14886 = state_14666__$1;
(statearr_14684_14886[(2)] = fluree.db.util.core.min_integer);

(statearr_14684_14886[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (60))){
var inst_14424 = (state_14666[(2)]);
var state_14666__$1 = state_14666;
var statearr_14685_14887 = state_14666__$1;
(statearr_14685_14887[(2)] = inst_14424);

(statearr_14685_14887[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (27))){
var state_14666__$1 = state_14666;
var statearr_14686_14888 = state_14666__$1;
(statearr_14686_14888[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (1))){
var state_14666__$1 = state_14666;
var statearr_14688_14889 = state_14666__$1;
(statearr_14688_14889[(2)] = null);

(statearr_14688_14889[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (69))){
var inst_14454 = (state_14666[(2)]);
var state_14666__$1 = state_14666;
if(cljs.core.truth_(inst_14454)){
var statearr_14689_14890 = state_14666__$1;
(statearr_14689_14890[(1)] = (73));

} else {
var statearr_14690_14891 = state_14666__$1;
(statearr_14690_14891[(1)] = (74));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (101))){
var state_14666__$1 = state_14666;
var statearr_14691_14892 = state_14666__$1;
(statearr_14691_14892[(2)] = true);

(statearr_14691_14892[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (24))){
var inst_14299 = (state_14666[(55)]);
var inst_14349 = cljs.core.boolean_QMARK_.call(null,inst_14299);
var state_14666__$1 = state_14666;
if(inst_14349){
var statearr_14692_14893 = state_14666__$1;
(statearr_14692_14893[(1)] = (26));

} else {
var statearr_14693_14894 = state_14666__$1;
(statearr_14693_14894[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (102))){
var state_14666__$1 = state_14666;
var statearr_14694_14895 = state_14666__$1;
(statearr_14694_14895[(2)] = false);

(statearr_14694_14895[(1)] = (103));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (55))){
var inst_14295 = (state_14666[(56)]);
var state_14666__$1 = state_14666;
var statearr_14695_14896 = state_14666__$1;
(statearr_14695_14896[(2)] = inst_14295);

(statearr_14695_14896[(1)] = (57));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (85))){
var inst_14658 = (state_14666[(2)]);
var state_14666__$1 = state_14666;
var statearr_14696_14897 = state_14666__$1;
(statearr_14696_14897[(2)] = inst_14658);

(statearr_14696_14897[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (39))){
var inst_14380 = (state_14666[(57)]);
var inst_14393 = fluree.db.dbproto._subid.call(null,db,inst_14380);
var state_14666__$1 = state_14666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14666__$1,(42),inst_14393);
} else {
if((state_val_14667 === (88))){
var inst_14325 = (state_14666[(21)]);
var inst_14508 = (state_14666[(2)]);
var state_14666__$1 = (function (){var statearr_14697 = state_14666;
(statearr_14697[(58)] = inst_14508);

return statearr_14697;
})();
if(cljs.core.truth_(inst_14325)){
var statearr_14698_14898 = state_14666__$1;
(statearr_14698_14898[(1)] = (89));

} else {
var statearr_14699_14899 = state_14666__$1;
(statearr_14699_14899[(1)] = (90));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (46))){
var state_14666__$1 = state_14666;
var statearr_14700_14900 = state_14666__$1;
(statearr_14700_14900[(2)] = (-1));

(statearr_14700_14900[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (4))){
var inst_14269 = (state_14666[(2)]);
var state_14666__$1 = state_14666;
var statearr_14701_14901 = state_14666__$1;
(statearr_14701_14901[(2)] = inst_14269);

(statearr_14701_14901[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (77))){
var state_14666__$1 = state_14666;
var statearr_14702_14902 = state_14666__$1;
(statearr_14702_14902[(2)] = fluree.db.util.core.max_long);

(statearr_14702_14902[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (106))){
var inst_14527 = (state_14666[(7)]);
var inst_14625 = (state_14666[(2)]);
var inst_14626 = cljs.core.nth.call(null,inst_14625,(0),null);
var inst_14627 = cljs.core.nth.call(null,inst_14625,(1),null);
var inst_14628 = cljs.core.nth.call(null,inst_14625,(2),null);
var inst_14629 = cljs.core.nth.call(null,inst_14625,(3),null);
var state_14666__$1 = (function (){var statearr_14703 = state_14666;
(statearr_14703[(59)] = inst_14627);

(statearr_14703[(60)] = inst_14626);

(statearr_14703[(15)] = inst_14629);

(statearr_14703[(61)] = inst_14628);

return statearr_14703;
})();
if(cljs.core.truth_(inst_14527)){
var statearr_14704_14903 = state_14666__$1;
(statearr_14704_14903[(1)] = (120));

} else {
var statearr_14705_14904 = state_14666__$1;
(statearr_14705_14904[(1)] = (121));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (119))){
var inst_14611 = (state_14666[(2)]);
var inst_14612 = fluree.db.util.async.throw_err.call(null,inst_14611);
var state_14666__$1 = state_14666;
var statearr_14706_14905 = state_14666__$1;
(statearr_14706_14905[(2)] = inst_14612);

(statearr_14706_14905[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (95))){
var inst_14436 = (state_14666[(17)]);
var inst_14491 = (state_14666[(18)]);
var inst_14494 = (state_14666[(19)]);
var inst_14466 = (state_14666[(10)]);
var inst_14377 = (state_14666[(20)]);
var inst_14325 = (state_14666[(21)]);
var inst_14426 = (state_14666[(22)]);
var inst_14326 = (state_14666[(23)]);
var inst_14345 = (state_14666[(24)]);
var inst_14473 = (state_14666[(25)]);
var inst_14487 = (state_14666[(26)]);
var inst_14294 = (state_14666[(27)]);
var inst_14490 = (state_14666[(28)]);
var inst_14435 = (state_14666[(29)]);
var inst_14301 = (state_14666[(30)]);
var inst_14408 = (state_14666[(31)]);
var inst_14293 = (state_14666[(32)]);
var inst_14459 = (state_14666[(33)]);
var inst_14467 = (state_14666[(34)]);
var inst_14336 = (state_14666[(35)]);
var inst_14460 = (state_14666[(36)]);
var inst_14289 = (state_14666[(37)]);
var inst_14324 = (state_14666[(38)]);
var inst_14296 = (state_14666[(39)]);
var inst_14399 = (state_14666[(40)]);
var inst_14437 = (state_14666[(41)]);
var inst_14390 = (state_14666[(42)]);
var inst_14472 = (state_14666[(43)]);
var inst_14378 = (state_14666[(44)]);
var inst_14483 = (state_14666[(45)]);
var inst_14493 = (state_14666[(12)]);
var inst_14478 = (state_14666[(46)]);
var inst_14468 = (state_14666[(47)]);
var inst_14520 = (state_14666[(62)]);
var inst_14492 = (state_14666[(48)]);
var inst_14500 = (state_14666[(49)]);
var inst_14381 = (state_14666[(50)]);
var inst_14477 = (state_14666[(51)]);
var inst_14417 = (state_14666[(52)]);
var inst_14300 = (state_14666[(53)]);
var inst_14522 = (function (){var G__14501 = inst_14520;
var no_filter_QMARK_ = true;
var t = inst_14473;
var max_limit_QMARK_ = inst_14467;
var next_node = inst_14490;
var fast_forward_db_QMARK_ = inst_14478;
var s1 = inst_14336;
var o2 = inst_14399;
var t1 = inst_14293;
var predicate_fn = inst_14326;
var i = inst_14492;
var m1 = inst_14426;
var root_node = inst_14483;
var s2 = inst_14345;
var p2 = inst_14417;
var map__14288 = inst_14459;
var permissions = inst_14468;
var limit = inst_14466;
var start_flake = inst_14436;
var map__14281 = inst_14324;
var flake_limit = inst_14460;
var offset = inst_14491;
var acc = inst_14494;
var t2 = inst_14300;
var op1 = inst_14294;
var o1 = inst_14390;
var end_flake = inst_14437;
var vec__14282 = inst_14377;
var base_result = inst_14500;
var s = inst_14493;
var node_start = inst_14487;
var p1 = inst_14408;
var subject_fn = inst_14325;
var vec__14278 = inst_14296;
var vec__14275 = inst_14289;
var object_fn = inst_14381;
var idx_compare = inst_14472;
var op2 = inst_14301;
var m2 = inst_14435;
var vec__14285 = inst_14378;
var novelty = inst_14477;
return (function (p1__14259_SHARP_){
return object_fn.call(null,p1__14259_SHARP_.o);
});
})();
var inst_14523 = cljs.core.filter.call(null,inst_14522,inst_14520);
var state_14666__$1 = state_14666;
var statearr_14707_14906 = state_14666__$1;
(statearr_14707_14906[(2)] = inst_14523);

(statearr_14707_14906[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (54))){
var inst_14295 = (state_14666[(56)]);
var inst_14417 = (state_14666[(2)]);
var state_14666__$1 = (function (){var statearr_14708 = state_14666;
(statearr_14708[(52)] = inst_14417);

return statearr_14708;
})();
if(cljs.core.truth_(inst_14295)){
var statearr_14709_14907 = state_14666__$1;
(statearr_14709_14907[(1)] = (55));

} else {
var statearr_14710_14908 = state_14666__$1;
(statearr_14710_14908[(1)] = (56));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (92))){
var inst_14436 = (state_14666[(17)]);
var inst_14491 = (state_14666[(18)]);
var inst_14494 = (state_14666[(19)]);
var inst_14466 = (state_14666[(10)]);
var inst_14377 = (state_14666[(20)]);
var inst_14325 = (state_14666[(21)]);
var inst_14514 = (state_14666[(63)]);
var inst_14426 = (state_14666[(22)]);
var inst_14326 = (state_14666[(23)]);
var inst_14345 = (state_14666[(24)]);
var inst_14473 = (state_14666[(25)]);
var inst_14487 = (state_14666[(26)]);
var inst_14294 = (state_14666[(27)]);
var inst_14490 = (state_14666[(28)]);
var inst_14435 = (state_14666[(29)]);
var inst_14301 = (state_14666[(30)]);
var inst_14408 = (state_14666[(31)]);
var inst_14293 = (state_14666[(32)]);
var inst_14459 = (state_14666[(33)]);
var inst_14467 = (state_14666[(34)]);
var inst_14336 = (state_14666[(35)]);
var inst_14460 = (state_14666[(36)]);
var inst_14289 = (state_14666[(37)]);
var inst_14324 = (state_14666[(38)]);
var inst_14296 = (state_14666[(39)]);
var inst_14399 = (state_14666[(40)]);
var inst_14437 = (state_14666[(41)]);
var inst_14390 = (state_14666[(42)]);
var inst_14472 = (state_14666[(43)]);
var inst_14378 = (state_14666[(44)]);
var inst_14483 = (state_14666[(45)]);
var inst_14493 = (state_14666[(12)]);
var inst_14478 = (state_14666[(46)]);
var inst_14468 = (state_14666[(47)]);
var inst_14492 = (state_14666[(48)]);
var inst_14500 = (state_14666[(49)]);
var inst_14381 = (state_14666[(50)]);
var inst_14477 = (state_14666[(51)]);
var inst_14417 = (state_14666[(52)]);
var inst_14300 = (state_14666[(53)]);
var inst_14516 = (function (){var G__14501 = inst_14514;
var no_filter_QMARK_ = true;
var t = inst_14473;
var max_limit_QMARK_ = inst_14467;
var next_node = inst_14490;
var fast_forward_db_QMARK_ = inst_14478;
var s1 = inst_14336;
var o2 = inst_14399;
var t1 = inst_14293;
var predicate_fn = inst_14326;
var i = inst_14492;
var m1 = inst_14426;
var root_node = inst_14483;
var s2 = inst_14345;
var p2 = inst_14417;
var map__14288 = inst_14459;
var permissions = inst_14468;
var limit = inst_14466;
var start_flake = inst_14436;
var map__14281 = inst_14324;
var flake_limit = inst_14460;
var offset = inst_14491;
var acc = inst_14494;
var t2 = inst_14300;
var op1 = inst_14294;
var o1 = inst_14390;
var end_flake = inst_14437;
var vec__14282 = inst_14377;
var base_result = inst_14500;
var s = inst_14493;
var node_start = inst_14487;
var p1 = inst_14408;
var subject_fn = inst_14325;
var vec__14278 = inst_14296;
var vec__14275 = inst_14289;
var object_fn = inst_14381;
var idx_compare = inst_14472;
var op2 = inst_14301;
var m2 = inst_14435;
var vec__14285 = inst_14378;
var novelty = inst_14477;
return (function (p1__14258_SHARP_){
return predicate_fn.call(null,p1__14258_SHARP_.p);
});
})();
var inst_14517 = cljs.core.filter.call(null,inst_14516,inst_14514);
var state_14666__$1 = state_14666;
var statearr_14711_14909 = state_14666__$1;
(statearr_14711_14909[(2)] = inst_14517);

(statearr_14711_14909[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (104))){
var inst_14494 = (state_14666[(19)]);
var inst_14526 = (state_14666[(64)]);
var inst_14460 = (state_14666[(36)]);
var inst_14493 = (state_14666[(12)]);
var inst_14492 = (state_14666[(48)]);
var inst_14538 = cljs.core.count.call(null,inst_14526);
var inst_14539 = (inst_14460 - inst_14492);
var inst_14540 = cljs.core.take.call(null,inst_14539,inst_14526);
var inst_14541 = cljs.core.into.call(null,inst_14494,inst_14540);
var inst_14542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14543 = (inst_14492 + inst_14538);
var inst_14544 = [(0),inst_14543,inst_14493,inst_14541];
var inst_14545 = (new cljs.core.PersistentVector(null,4,(5),inst_14542,inst_14544,null));
var state_14666__$1 = state_14666;
var statearr_14712_14910 = state_14666__$1;
(statearr_14712_14910[(2)] = inst_14545);

(statearr_14712_14910[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (15))){
var inst_14290 = (state_14666[(65)]);
var inst_14330 = fluree.db.dbproto._subid.call(null,db,inst_14290);
var state_14666__$1 = state_14666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14666__$1,(18),inst_14330);
} else {
if((state_val_14667 === (48))){
var inst_14298 = (state_14666[(66)]);
var inst_14408 = (state_14666[(2)]);
var inst_14409 = (inst_14298 == null);
var state_14666__$1 = (function (){var statearr_14713 = state_14666;
(statearr_14713[(31)] = inst_14408);

return statearr_14713;
})();
if(cljs.core.truth_(inst_14409)){
var statearr_14714_14911 = state_14666__$1;
(statearr_14714_14911[(1)] = (49));

} else {
var statearr_14715_14912 = state_14666__$1;
(statearr_14715_14912[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (50))){
var state_14666__$1 = state_14666;
var statearr_14716_14913 = state_14666__$1;
(statearr_14716_14913[(2)] = false);

(statearr_14716_14913[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (116))){
var inst_14588 = (state_14666[(67)]);
var inst_14587 = (state_14666[(68)]);
var inst_14460 = (state_14666[(36)]);
var inst_14586 = (state_14666[(69)]);
var inst_14591 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14592 = (inst_14588 - inst_14460);
var inst_14593 = (inst_14587 - inst_14592);
var inst_14594 = cljs.core.take.call(null,inst_14593,inst_14586);
var inst_14595 = [inst_14460,inst_14594];
var inst_14596 = (new cljs.core.PersistentVector(null,2,(5),inst_14591,inst_14595,null));
var state_14666__$1 = state_14666;
var statearr_14717_14914 = state_14666__$1;
(statearr_14717_14914[(2)] = inst_14596);

(statearr_14717_14914[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (75))){
var inst_14461 = (state_14666[(70)]);
var inst_14459 = (state_14666[(33)]);
var inst_14459__$1 = (state_14666[(2)]);
var inst_14460 = cljs.core.get.call(null,inst_14459__$1,new cljs.core.Keyword(null,"flake-limit","flake-limit",-1060039961),fluree.db.util.core.max_long);
var inst_14461__$1 = cljs.core.get.call(null,inst_14459__$1,new cljs.core.Keyword(null,"limit","limit",-1355822363));
var inst_14462 = cljs.core.get.call(null,inst_14459__$1,new cljs.core.Keyword(null,"offset","offset",296498311),(0));
var state_14666__$1 = (function (){var statearr_14718 = state_14666;
(statearr_14718[(70)] = inst_14461__$1);

(statearr_14718[(33)] = inst_14459__$1);

(statearr_14718[(36)] = inst_14460);

(statearr_14718[(71)] = inst_14462);

return statearr_14718;
})();
if(cljs.core.truth_(inst_14461__$1)){
var statearr_14719_14915 = state_14666__$1;
(statearr_14719_14915[(1)] = (76));

} else {
var statearr_14720_14916 = state_14666__$1;
(statearr_14720_14916[(1)] = (77));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (99))){
var inst_14467 = (state_14666[(34)]);
var state_14666__$1 = state_14666;
var statearr_14721_14917 = state_14666__$1;
(statearr_14721_14917[(2)] = inst_14467);

(statearr_14721_14917[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (21))){
var inst_14292 = (state_14666[(72)]);
var inst_14345 = (state_14666[(2)]);
var inst_14346 = cljs.core.boolean_QMARK_.call(null,inst_14292);
var state_14666__$1 = (function (){var statearr_14722 = state_14666;
(statearr_14722[(24)] = inst_14345);

return statearr_14722;
})();
if(inst_14346){
var statearr_14723_14918 = state_14666__$1;
(statearr_14723_14918[(1)] = (23));

} else {
var statearr_14724_14919 = state_14666__$1;
(statearr_14724_14919[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (31))){
var inst_14355 = (state_14666[(2)]);
var state_14666__$1 = state_14666;
var statearr_14725_14920 = state_14666__$1;
(statearr_14725_14920[(2)] = inst_14355);

(statearr_14725_14920[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (113))){
var inst_14568 = (state_14666[(9)]);
var inst_14466 = (state_14666[(10)]);
var inst_14570 = (state_14666[(14)]);
var inst_14573 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14574 = (inst_14568 - inst_14570);
var inst_14575 = [inst_14466,inst_14574];
var inst_14576 = (new cljs.core.PersistentVector(null,2,(5),inst_14573,inst_14575,null));
var state_14666__$1 = state_14666;
var statearr_14726_14921 = state_14666__$1;
(statearr_14726_14921[(2)] = inst_14576);

(statearr_14726_14921[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (32))){
var inst_14292 = (state_14666[(72)]);
var inst_14327 = (state_14666[(73)]);
var inst_14299 = (state_14666[(55)]);
var inst_14362 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14363 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14364 = [inst_14292,inst_14299];
var inst_14365 = (new cljs.core.PersistentVector(null,2,(5),inst_14363,inst_14364,null));
var inst_14366 = [inst_14365,inst_14327];
var inst_14367 = (new cljs.core.PersistentVector(null,2,(5),inst_14362,inst_14366,null));
var state_14666__$1 = state_14666;
var statearr_14727_14922 = state_14666__$1;
(statearr_14727_14922[(2)] = inst_14367);

(statearr_14727_14922[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (40))){
var inst_14380 = (state_14666[(57)]);
var state_14666__$1 = state_14666;
var statearr_14728_14923 = state_14666__$1;
(statearr_14728_14923[(2)] = inst_14380);

(statearr_14728_14923[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (129))){
var inst_14650 = (state_14666[(2)]);
var inst_14651 = cljs.core.not.call(null,inst_14650);
var state_14666__$1 = state_14666;
if(inst_14651){
var statearr_14729_14924 = state_14666__$1;
(statearr_14729_14924[(1)] = (130));

} else {
var statearr_14730_14925 = state_14666__$1;
(statearr_14730_14925[(1)] = (131));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (91))){
var inst_14326 = (state_14666[(23)]);
var inst_14514 = (state_14666[(2)]);
var state_14666__$1 = (function (){var statearr_14731 = state_14666;
(statearr_14731[(63)] = inst_14514);

return statearr_14731;
})();
if(cljs.core.truth_(inst_14326)){
var statearr_14732_14926 = state_14666__$1;
(statearr_14732_14926[(1)] = (92));

} else {
var statearr_14733_14927 = state_14666__$1;
(statearr_14733_14927[(1)] = (93));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (117))){
var inst_14588 = (state_14666[(67)]);
var inst_14586 = (state_14666[(69)]);
var inst_14598 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14599 = [inst_14588,inst_14586];
var inst_14600 = (new cljs.core.PersistentVector(null,2,(5),inst_14598,inst_14599,null));
var state_14666__$1 = state_14666;
var statearr_14734_14928 = state_14666__$1;
(statearr_14734_14928[(2)] = inst_14600);

(statearr_14734_14928[(1)] = (118));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (108))){
var inst_14491 = (state_14666[(18)]);
var inst_14548 = (state_14666[(74)]);
var inst_14560 = cljs.core.drop.call(null,inst_14491,inst_14548);
var state_14666__$1 = (function (){var statearr_14735 = state_14666;
(statearr_14735[(11)] = inst_14560);

return statearr_14735;
})();
var statearr_14736_14929 = state_14666__$1;
(statearr_14736_14929[(1)] = (110));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (56))){
var inst_14420 = (cljs.core._GT__EQ_ === start_test);
var state_14666__$1 = state_14666;
if(cljs.core.truth_(inst_14420)){
var statearr_14738_14930 = state_14666__$1;
(statearr_14738_14930[(1)] = (58));

} else {
var statearr_14739_14931 = state_14666__$1;
(statearr_14739_14931[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (33))){
var inst_14292 = (state_14666[(72)]);
var inst_14325 = (state_14666[(21)]);
var inst_14326 = (state_14666[(23)]);
var inst_14345 = (state_14666[(24)]);
var inst_14294 = (state_14666[(27)]);
var inst_14298 = (state_14666[(66)]);
var inst_14301 = (state_14666[(30)]);
var inst_14293 = (state_14666[(32)]);
var inst_14336 = (state_14666[(35)]);
var inst_14289 = (state_14666[(37)]);
var inst_14359 = (state_14666[(75)]);
var inst_14324 = (state_14666[(38)]);
var inst_14296 = (state_14666[(39)]);
var inst_14327 = (state_14666[(73)]);
var inst_14291 = (state_14666[(76)]);
var inst_14299 = (state_14666[(55)]);
var inst_14302 = (state_14666[(77)]);
var inst_14295 = (state_14666[(56)]);
var inst_14300 = (state_14666[(53)]);
var inst_14369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14371 = [null,null];
var inst_14372 = (new cljs.core.PersistentVector(null,2,(5),inst_14370,inst_14371,null));
var inst_14373 = (function (){var bool = inst_14359;
var s1 = inst_14336;
var o2 = inst_14299;
var t1 = inst_14293;
var predicate_fn = inst_14326;
var m1 = inst_14295;
var s2 = inst_14345;
var p2 = inst_14298;
var temp__5737__auto__ = inst_14359;
var map__14281 = inst_14324;
var t2 = inst_14300;
var op1 = inst_14294;
var o1 = inst_14292;
var p1 = inst_14291;
var subject_fn = inst_14325;
var vec__14278 = inst_14296;
var vec__14275 = inst_14289;
var object_fn = inst_14327;
var op2 = inst_14301;
var m2 = inst_14302;
return (function (o){
return cljs.core._EQ_.call(null,o,bool);
});
})();
var inst_14374 = [inst_14372,inst_14373];
var inst_14375 = (new cljs.core.PersistentVector(null,2,(5),inst_14369,inst_14374,null));
var state_14666__$1 = state_14666;
var statearr_14740_14932 = state_14666__$1;
(statearr_14740_14932[(2)] = inst_14375);

(statearr_14740_14932[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (13))){
var inst_14303 = (state_14666[(78)]);
var state_14666__$1 = state_14666;
var statearr_14741_14933 = state_14666__$1;
(statearr_14741_14933[(2)] = inst_14303);

(statearr_14741_14933[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (22))){
var inst_14341 = (state_14666[(2)]);
var inst_14342 = fluree.db.util.async.throw_err.call(null,inst_14341);
var state_14666__$1 = state_14666;
var statearr_14742_14934 = state_14666__$1;
(statearr_14742_14934[(2)] = inst_14342);

(statearr_14742_14934[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (90))){
var inst_14508 = (state_14666[(58)]);
var state_14666__$1 = state_14666;
var statearr_14743_14935 = state_14666__$1;
(statearr_14743_14935[(2)] = inst_14508);

(statearr_14743_14935[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (109))){
var inst_14623 = (state_14666[(2)]);
var state_14666__$1 = state_14666;
var statearr_14744_14936 = state_14666__$1;
(statearr_14744_14936[(2)] = inst_14623);

(statearr_14744_14936[(1)] = (106));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (36))){
var inst_14379 = (state_14666[(79)]);
var state_14666__$1 = state_14666;
var statearr_14745_14937 = state_14666__$1;
(statearr_14745_14937[(2)] = inst_14379);

(statearr_14745_14937[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (41))){
var inst_14291 = (state_14666[(76)]);
var inst_14399 = (state_14666[(2)]);
var inst_14400 = (inst_14291 == null);
var state_14666__$1 = (function (){var statearr_14746 = state_14666;
(statearr_14746[(40)] = inst_14399);

return statearr_14746;
})();
if(cljs.core.truth_(inst_14400)){
var statearr_14747_14938 = state_14666__$1;
(statearr_14747_14938[(1)] = (43));

} else {
var statearr_14748_14939 = state_14666__$1;
(statearr_14748_14939[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (118))){
var inst_14583 = (state_14666[(80)]);
var inst_14602 = (state_14666[(2)]);
var inst_14603 = cljs.core.nth.call(null,inst_14602,(0),null);
var inst_14604 = cljs.core.nth.call(null,inst_14602,(1),null);
var inst_14605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14606 = [inst_14603,inst_14583,inst_14604];
var inst_14607 = (new cljs.core.PersistentVector(null,3,(5),inst_14605,inst_14606,null));
var state_14666__$1 = state_14666;
var statearr_14749_14940 = state_14666__$1;
(statearr_14749_14940[(2)] = inst_14607);

(statearr_14749_14940[(1)] = (112));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (89))){
var inst_14436 = (state_14666[(17)]);
var inst_14491 = (state_14666[(18)]);
var inst_14494 = (state_14666[(19)]);
var inst_14466 = (state_14666[(10)]);
var inst_14377 = (state_14666[(20)]);
var inst_14325 = (state_14666[(21)]);
var inst_14426 = (state_14666[(22)]);
var inst_14326 = (state_14666[(23)]);
var inst_14345 = (state_14666[(24)]);
var inst_14473 = (state_14666[(25)]);
var inst_14487 = (state_14666[(26)]);
var inst_14294 = (state_14666[(27)]);
var inst_14508 = (state_14666[(58)]);
var inst_14490 = (state_14666[(28)]);
var inst_14435 = (state_14666[(29)]);
var inst_14301 = (state_14666[(30)]);
var inst_14408 = (state_14666[(31)]);
var inst_14293 = (state_14666[(32)]);
var inst_14459 = (state_14666[(33)]);
var inst_14467 = (state_14666[(34)]);
var inst_14336 = (state_14666[(35)]);
var inst_14460 = (state_14666[(36)]);
var inst_14289 = (state_14666[(37)]);
var inst_14324 = (state_14666[(38)]);
var inst_14296 = (state_14666[(39)]);
var inst_14399 = (state_14666[(40)]);
var inst_14437 = (state_14666[(41)]);
var inst_14390 = (state_14666[(42)]);
var inst_14472 = (state_14666[(43)]);
var inst_14378 = (state_14666[(44)]);
var inst_14483 = (state_14666[(45)]);
var inst_14493 = (state_14666[(12)]);
var inst_14478 = (state_14666[(46)]);
var inst_14468 = (state_14666[(47)]);
var inst_14492 = (state_14666[(48)]);
var inst_14500 = (state_14666[(49)]);
var inst_14381 = (state_14666[(50)]);
var inst_14477 = (state_14666[(51)]);
var inst_14417 = (state_14666[(52)]);
var inst_14300 = (state_14666[(53)]);
var inst_14510 = (function (){var G__14501 = inst_14508;
var no_filter_QMARK_ = true;
var t = inst_14473;
var max_limit_QMARK_ = inst_14467;
var next_node = inst_14490;
var fast_forward_db_QMARK_ = inst_14478;
var s1 = inst_14336;
var o2 = inst_14399;
var t1 = inst_14293;
var predicate_fn = inst_14326;
var i = inst_14492;
var m1 = inst_14426;
var root_node = inst_14483;
var s2 = inst_14345;
var p2 = inst_14417;
var map__14288 = inst_14459;
var permissions = inst_14468;
var limit = inst_14466;
var start_flake = inst_14436;
var map__14281 = inst_14324;
var flake_limit = inst_14460;
var offset = inst_14491;
var acc = inst_14494;
var t2 = inst_14300;
var op1 = inst_14294;
var o1 = inst_14390;
var end_flake = inst_14437;
var vec__14282 = inst_14377;
var base_result = inst_14500;
var s = inst_14493;
var node_start = inst_14487;
var p1 = inst_14408;
var subject_fn = inst_14325;
var vec__14278 = inst_14296;
var vec__14275 = inst_14289;
var object_fn = inst_14381;
var idx_compare = inst_14472;
var op2 = inst_14301;
var m2 = inst_14435;
var vec__14285 = inst_14378;
var novelty = inst_14477;
return (function (p1__14257_SHARP_){
return subject_fn.call(null,p1__14257_SHARP_.s);
});
})();
var inst_14511 = cljs.core.filter.call(null,inst_14510,inst_14508);
var state_14666__$1 = state_14666;
var statearr_14750_14941 = state_14666__$1;
(statearr_14750_14941[(2)] = inst_14511);

(statearr_14750_14941[(1)] = (91));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (100))){
var inst_14536 = (state_14666[(2)]);
var state_14666__$1 = state_14666;
if(cljs.core.truth_(inst_14536)){
var statearr_14751_14942 = state_14666__$1;
(statearr_14751_14942[(1)] = (104));

} else {
var statearr_14752_14943 = state_14666__$1;
(statearr_14752_14943[(1)] = (105));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (131))){
var inst_14627 = (state_14666[(59)]);
var inst_14626 = (state_14666[(60)]);
var inst_14629 = (state_14666[(15)]);
var inst_14628 = (state_14666[(61)]);
var inst_14646 = (state_14666[(81)]);
var inst_14490 = inst_14646;
var inst_14491 = inst_14626;
var inst_14492 = inst_14627;
var inst_14493 = inst_14628;
var inst_14494 = inst_14629;
var state_14666__$1 = (function (){var statearr_14753 = state_14666;
(statearr_14753[(18)] = inst_14491);

(statearr_14753[(19)] = inst_14494);

(statearr_14753[(28)] = inst_14490);

(statearr_14753[(12)] = inst_14493);

(statearr_14753[(48)] = inst_14492);

return statearr_14753;
})();
var statearr_14754_14944 = state_14666__$1;
(statearr_14754_14944[(2)] = null);

(statearr_14754_14944[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (122))){
var inst_14638 = (state_14666[(16)]);
var inst_14638__$1 = (state_14666[(2)]);
var state_14666__$1 = (function (){var statearr_14755 = state_14666;
(statearr_14755[(16)] = inst_14638__$1);

return statearr_14755;
})();
if(cljs.core.truth_(inst_14638__$1)){
var statearr_14756_14945 = state_14666__$1;
(statearr_14756_14945[(1)] = (123));

} else {
var statearr_14757_14946 = state_14666__$1;
(statearr_14757_14946[(1)] = (124));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (43))){
var inst_14390 = (state_14666[(42)]);
var state_14666__$1 = state_14666;
var statearr_14758_14947 = state_14666__$1;
(statearr_14758_14947[(2)] = inst_14390);

(statearr_14758_14947[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (61))){
var inst_14302 = (state_14666[(77)]);
var state_14666__$1 = state_14666;
var statearr_14759_14948 = state_14666__$1;
(statearr_14759_14948[(2)] = inst_14302);

(statearr_14759_14948[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (29))){
var state_14666__$1 = state_14666;
var statearr_14760_14949 = state_14666__$1;
(statearr_14760_14949[(2)] = null);

(statearr_14760_14949[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (44))){
var state_14666__$1 = state_14666;
var statearr_14761_14950 = state_14666__$1;
(statearr_14761_14950[(2)] = false);

(statearr_14761_14950[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (93))){
var inst_14514 = (state_14666[(63)]);
var state_14666__$1 = state_14666;
var statearr_14762_14951 = state_14666__$1;
(statearr_14762_14951[(2)] = inst_14514);

(statearr_14762_14951[(1)] = (94));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (6))){
var inst_14303 = (state_14666[(78)]);
var inst_14308 = inst_14303.cljs$lang$protocol_mask$partition0$;
var inst_14309 = (inst_14308 & (64));
var inst_14310 = inst_14303.cljs$core$ISeq$;
var inst_14311 = (cljs.core.PROTOCOL_SENTINEL === inst_14310);
var inst_14312 = ((inst_14309) || (inst_14311));
var state_14666__$1 = state_14666;
if(cljs.core.truth_(inst_14312)){
var statearr_14763_14952 = state_14666__$1;
(statearr_14763_14952[(1)] = (9));

} else {
var statearr_14764_14953 = state_14666__$1;
(statearr_14764_14953[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (111))){
var inst_14466 = (state_14666[(10)]);
var inst_14560 = (state_14666[(11)]);
var inst_14460 = (state_14666[(36)]);
var inst_14493 = (state_14666[(12)]);
var inst_14492 = (state_14666[(48)]);
var inst_14609 = fluree.db.query.range.subject_groups__GT_allow_flakes.call(null,db,inst_14560,inst_14492,inst_14493,inst_14460,inst_14466);
var state_14666__$1 = state_14666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14666__$1,(119),inst_14609);
} else {
if((state_val_14667 === (28))){
var inst_14357 = (state_14666[(2)]);
var state_14666__$1 = state_14666;
var statearr_14765_14954 = state_14666__$1;
(statearr_14765_14954[(2)] = inst_14357);

(statearr_14765_14954[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (64))){
var state_14666__$1 = state_14666;
var statearr_14766_14955 = state_14666__$1;
(statearr_14766_14955[(2)] = (2147483647));

(statearr_14766_14955[(1)] = (66));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (103))){
var inst_14533 = (state_14666[(2)]);
var state_14666__$1 = state_14666;
var statearr_14767_14956 = state_14666__$1;
(statearr_14767_14956[(2)] = inst_14533);

(statearr_14767_14956[(1)] = (100));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (51))){
var inst_14413 = (state_14666[(2)]);
var state_14666__$1 = state_14666;
if(cljs.core.truth_(inst_14413)){
var statearr_14768_14957 = state_14666__$1;
(statearr_14768_14957[(1)] = (52));

} else {
var statearr_14769_14958 = state_14666__$1;
(statearr_14769_14958[(1)] = (53));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (25))){
var inst_14359 = (state_14666[(75)]);
var inst_14359__$1 = (state_14666[(2)]);
var inst_14360 = (inst_14359__$1 == null);
var state_14666__$1 = (function (){var statearr_14770 = state_14666;
(statearr_14770[(75)] = inst_14359__$1);

return statearr_14770;
})();
if(cljs.core.truth_(inst_14360)){
var statearr_14771_14959 = state_14666__$1;
(statearr_14771_14959[(1)] = (32));

} else {
var statearr_14772_14960 = state_14666__$1;
(statearr_14772_14960[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (34))){
var inst_14377 = (state_14666[(20)]);
var inst_14378 = (state_14666[(44)]);
var inst_14379 = (state_14666[(79)]);
var inst_14377__$1 = (state_14666[(2)]);
var inst_14378__$1 = cljs.core.nth.call(null,inst_14377__$1,(0),null);
var inst_14379__$1 = cljs.core.nth.call(null,inst_14378__$1,(0),null);
var inst_14380 = cljs.core.nth.call(null,inst_14378__$1,(1),null);
var inst_14381 = cljs.core.nth.call(null,inst_14377__$1,(1),null);
var inst_14382 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14379__$1);
var state_14666__$1 = (function (){var statearr_14773 = state_14666;
(statearr_14773[(20)] = inst_14377__$1);

(statearr_14773[(44)] = inst_14378__$1);

(statearr_14773[(57)] = inst_14380);

(statearr_14773[(50)] = inst_14381);

(statearr_14773[(79)] = inst_14379__$1);

return statearr_14773;
})();
if(inst_14382){
var statearr_14774_14961 = state_14666__$1;
(statearr_14774_14961[(1)] = (35));

} else {
var statearr_14775_14962 = state_14666__$1;
(statearr_14775_14962[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (125))){
var inst_14638 = (state_14666[(16)]);
var inst_14646 = (state_14666[(2)]);
var state_14666__$1 = (function (){var statearr_14776 = state_14666;
(statearr_14776[(81)] = inst_14646);

return statearr_14776;
})();
if(cljs.core.truth_(inst_14638)){
var statearr_14777_14963 = state_14666__$1;
(statearr_14777_14963[(1)] = (127));

} else {
var statearr_14778_14964 = state_14666__$1;
(statearr_14778_14964[(1)] = (128));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (17))){
var inst_14297 = (state_14666[(54)]);
var inst_14336 = (state_14666[(2)]);
var inst_14337 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14297);
var state_14666__$1 = (function (){var statearr_14779 = state_14666;
(statearr_14779[(35)] = inst_14336);

return statearr_14779;
})();
if(inst_14337){
var statearr_14780_14965 = state_14666__$1;
(statearr_14780_14965[(1)] = (19));

} else {
var statearr_14781_14966 = state_14666__$1;
(statearr_14781_14966[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (3))){
var inst_14664 = (state_14666[(2)]);
var state_14666__$1 = state_14666;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14666__$1,inst_14664);
} else {
if((state_val_14667 === (12))){
var inst_14303 = (state_14666[(78)]);
var inst_14321 = cljs.core.apply.call(null,cljs.core.hash_map,inst_14303);
var state_14666__$1 = state_14666;
var statearr_14782_14967 = state_14666__$1;
(statearr_14782_14967[(2)] = inst_14321);

(statearr_14782_14967[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (2))){
var inst_14303 = (state_14666[(78)]);
var inst_14289 = (state_14666[(37)]);
var inst_14296 = (state_14666[(39)]);
var _ = (function (){var statearr_14783 = state_14666;
(statearr_14783[(4)] = cljs.core.cons.call(null,(5),(state_14666[(4)])));

return statearr_14783;
})();
var inst_14289__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,start_match);
var inst_14290 = cljs.core.nth.call(null,inst_14289__$1,(0),null);
var inst_14291 = cljs.core.nth.call(null,inst_14289__$1,(1),null);
var inst_14292 = cljs.core.nth.call(null,inst_14289__$1,(2),null);
var inst_14293 = cljs.core.nth.call(null,inst_14289__$1,(3),null);
var inst_14294 = cljs.core.nth.call(null,inst_14289__$1,(4),null);
var inst_14295 = cljs.core.nth.call(null,inst_14289__$1,(5),null);
var inst_14296__$1 = fluree.db.query.range.match__GT_flake_parts.call(null,db,idx,end_match);
var inst_14297 = cljs.core.nth.call(null,inst_14296__$1,(0),null);
var inst_14298 = cljs.core.nth.call(null,inst_14296__$1,(1),null);
var inst_14299 = cljs.core.nth.call(null,inst_14296__$1,(2),null);
var inst_14300 = cljs.core.nth.call(null,inst_14296__$1,(3),null);
var inst_14301 = cljs.core.nth.call(null,inst_14296__$1,(4),null);
var inst_14302 = cljs.core.nth.call(null,inst_14296__$1,(5),null);
var inst_14303__$1 = opts;
var inst_14305 = (inst_14303__$1 == null);
var inst_14306 = cljs.core.not.call(null,inst_14305);
var state_14666__$1 = (function (){var statearr_14784 = state_14666;
(statearr_14784[(72)] = inst_14292);

(statearr_14784[(27)] = inst_14294);

(statearr_14784[(66)] = inst_14298);

(statearr_14784[(30)] = inst_14301);

(statearr_14784[(32)] = inst_14293);

(statearr_14784[(78)] = inst_14303__$1);

(statearr_14784[(37)] = inst_14289__$1);

(statearr_14784[(39)] = inst_14296__$1);

(statearr_14784[(54)] = inst_14297);

(statearr_14784[(76)] = inst_14291);

(statearr_14784[(55)] = inst_14299);

(statearr_14784[(65)] = inst_14290);

(statearr_14784[(77)] = inst_14302);

(statearr_14784[(56)] = inst_14295);

(statearr_14784[(53)] = inst_14300);

return statearr_14784;
})();
if(inst_14306){
var statearr_14785_14968 = state_14666__$1;
(statearr_14785_14968[(1)] = (6));

} else {
var statearr_14786_14969 = state_14666__$1;
(statearr_14786_14969[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (66))){
var inst_14433 = (state_14666[(2)]);
var state_14666__$1 = state_14666;
var statearr_14787_14970 = state_14666__$1;
(statearr_14787_14970[(2)] = inst_14433);

(statearr_14787_14970[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (107))){
var inst_14491 = (state_14666[(18)]);
var inst_14494 = (state_14666[(19)]);
var inst_14549 = (state_14666[(82)]);
var inst_14493 = (state_14666[(12)]);
var inst_14492 = (state_14666[(48)]);
var inst_14552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14553 = (inst_14491 - inst_14549);
var inst_14554 = [inst_14553,inst_14492,inst_14493,inst_14494];
var inst_14555 = (new cljs.core.PersistentVector(null,4,(5),inst_14552,inst_14554,null));
var state_14666__$1 = state_14666;
var statearr_14788_14971 = state_14666__$1;
(statearr_14788_14971[(2)] = inst_14555);

(statearr_14788_14971[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (23))){
var inst_14292 = (state_14666[(72)]);
var state_14666__$1 = state_14666;
var statearr_14789_14972 = state_14666__$1;
(statearr_14789_14972[(2)] = inst_14292);

(statearr_14789_14972[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (47))){
var inst_14291 = (state_14666[(76)]);
var state_14666__$1 = state_14666;
var statearr_14790_14973 = state_14666__$1;
(statearr_14790_14973[(2)] = inst_14291);

(statearr_14790_14973[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (35))){
var inst_14379 = (state_14666[(79)]);
var inst_14384 = fluree.db.dbproto._subid.call(null,db,inst_14379);
var state_14666__$1 = state_14666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14666__$1,(38),inst_14384);
} else {
if((state_val_14667 === (127))){
var inst_14646 = (state_14666[(81)]);
var state_14666__$1 = state_14666;
var statearr_14791_14974 = state_14666__$1;
(statearr_14791_14974[(2)] = inst_14646);

(statearr_14791_14974[(1)] = (129));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (82))){
var state_14666__$1 = state_14666;
var statearr_14792_14975 = state_14666__$1;
(statearr_14792_14975[(2)] = null);

(statearr_14792_14975[(1)] = (83));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (76))){
var inst_14461 = (state_14666[(70)]);
var state_14666__$1 = state_14666;
var statearr_14793_14976 = state_14666__$1;
(statearr_14793_14976[(2)] = inst_14461);

(statearr_14793_14976[(1)] = (78));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (97))){
var inst_14490 = (state_14666[(28)]);
var inst_14467 = (state_14666[(34)]);
var inst_14526 = (state_14666[(2)]);
var inst_14527 = fluree.db.dbproto._rhs.call(null,inst_14490);
var state_14666__$1 = (function (){var statearr_14794 = state_14666;
(statearr_14794[(64)] = inst_14526);

(statearr_14794[(7)] = inst_14527);

return statearr_14794;
})();
if(cljs.core.truth_(inst_14467)){
var statearr_14795_14977 = state_14666__$1;
(statearr_14795_14977[(1)] = (98));

} else {
var statearr_14796_14978 = state_14666__$1;
(statearr_14796_14978[(1)] = (99));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (19))){
var inst_14297 = (state_14666[(54)]);
var inst_14339 = fluree.db.dbproto._subid.call(null,db,inst_14297);
var state_14666__$1 = state_14666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14666__$1,(22),inst_14339);
} else {
if((state_val_14667 === (57))){
var inst_14302 = (state_14666[(77)]);
var inst_14426 = (state_14666[(2)]);
var state_14666__$1 = (function (){var statearr_14797 = state_14666;
(statearr_14797[(22)] = inst_14426);

return statearr_14797;
})();
if(cljs.core.truth_(inst_14302)){
var statearr_14798_14979 = state_14666__$1;
(statearr_14798_14979[(1)] = (61));

} else {
var statearr_14799_14980 = state_14666__$1;
(statearr_14799_14980[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (68))){
var state_14666__$1 = state_14666;
var statearr_14800_14981 = state_14666__$1;
(statearr_14800_14981[(2)] = false);

(statearr_14800_14981[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (11))){
var inst_14316 = (state_14666[(2)]);
var state_14666__$1 = state_14666;
var statearr_14801_14982 = state_14666__$1;
(statearr_14801_14982[(2)] = inst_14316);

(statearr_14801_14982[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (115))){
var inst_14588 = (state_14666[(67)]);
var inst_14560 = (state_14666[(11)]);
var inst_14587 = (state_14666[(68)]);
var inst_14460 = (state_14666[(36)]);
var inst_14492 = (state_14666[(48)]);
var inst_14586 = (state_14666[(69)]);
var inst_14582 = (state_14666[(2)]);
var inst_14583 = cljs.core.nth.call(null,inst_14582,(0),null);
var inst_14584 = cljs.core.nth.call(null,inst_14582,(1),null);
var inst_14585 = cljs.core.take.call(null,inst_14584,inst_14560);
var inst_14586__$1 = cljs.core.apply.call(null,cljs.core.concat,inst_14585);
var inst_14587__$1 = cljs.core.count.call(null,inst_14586__$1);
var inst_14588__$1 = (inst_14492 + inst_14587__$1);
var inst_14589 = (inst_14588__$1 > inst_14460);
var state_14666__$1 = (function (){var statearr_14803 = state_14666;
(statearr_14803[(80)] = inst_14583);

(statearr_14803[(67)] = inst_14588__$1);

(statearr_14803[(68)] = inst_14587__$1);

(statearr_14803[(69)] = inst_14586__$1);

return statearr_14803;
})();
if(cljs.core.truth_(inst_14589)){
var statearr_14804_14983 = state_14666__$1;
(statearr_14804_14983[(1)] = (116));

} else {
var statearr_14805_14984 = state_14666__$1;
(statearr_14805_14984[(1)] = (117));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (9))){
var state_14666__$1 = state_14666;
var statearr_14806_14985 = state_14666__$1;
(statearr_14806_14985[(2)] = true);

(statearr_14806_14985[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (5))){
var _ = (function (){var statearr_14807 = state_14666;
(statearr_14807[(4)] = cljs.core.rest.call(null,(state_14666[(4)])));

return statearr_14807;
})();
var state_14666__$1 = state_14666;
var ex14802 = (state_14666__$1[(2)]);
var statearr_14808_14986 = state_14666__$1;
(statearr_14808_14986[(5)] = ex14802);


if((ex14802 instanceof Error)){
var statearr_14809_14987 = state_14666__$1;
(statearr_14809_14987[(1)] = (4));

(statearr_14809_14987[(5)] = null);

} else {
throw ex14802;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (112))){
var inst_14494 = (state_14666[(19)]);
var inst_14614 = (state_14666[(2)]);
var inst_14615 = cljs.core.nth.call(null,inst_14614,(0),null);
var inst_14616 = cljs.core.nth.call(null,inst_14614,(1),null);
var inst_14617 = cljs.core.nth.call(null,inst_14614,(2),null);
var inst_14618 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14619 = cljs.core.into.call(null,inst_14494,inst_14617);
var inst_14620 = [(0),inst_14615,inst_14616,inst_14619];
var inst_14621 = (new cljs.core.PersistentVector(null,4,(5),inst_14618,inst_14620,null));
var state_14666__$1 = state_14666;
var statearr_14810_14988 = state_14666__$1;
(statearr_14810_14988[(2)] = inst_14621);

(statearr_14810_14988[(1)] = (109));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (83))){
var inst_14661 = (state_14666[(2)]);
var _ = (function (){var statearr_14811 = state_14666;
(statearr_14811[(4)] = cljs.core.rest.call(null,(state_14666[(4)])));

return statearr_14811;
})();
var state_14666__$1 = state_14666;
var statearr_14812_14989 = state_14666__$1;
(statearr_14812_14989[(2)] = inst_14661);

(statearr_14812_14989[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (14))){
var inst_14324 = (state_14666[(38)]);
var inst_14290 = (state_14666[(65)]);
var inst_14324__$1 = (state_14666[(2)]);
var inst_14325 = cljs.core.get.call(null,inst_14324__$1,new cljs.core.Keyword(null,"subject-fn","subject-fn",-581375441));
var inst_14326 = cljs.core.get.call(null,inst_14324__$1,new cljs.core.Keyword(null,"predicate-fn","predicate-fn",418606845));
var inst_14327 = cljs.core.get.call(null,inst_14324__$1,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481));
var inst_14328 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14290);
var state_14666__$1 = (function (){var statearr_14813 = state_14666;
(statearr_14813[(21)] = inst_14325);

(statearr_14813[(23)] = inst_14326);

(statearr_14813[(38)] = inst_14324__$1);

(statearr_14813[(73)] = inst_14327);

return statearr_14813;
})();
if(inst_14328){
var statearr_14814_14990 = state_14666__$1;
(statearr_14814_14990[(1)] = (15));

} else {
var statearr_14815_14991 = state_14666__$1;
(statearr_14815_14991[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (45))){
var inst_14404 = (state_14666[(2)]);
var state_14666__$1 = state_14666;
if(cljs.core.truth_(inst_14404)){
var statearr_14816_14992 = state_14666__$1;
(statearr_14816_14992[(1)] = (46));

} else {
var statearr_14817_14993 = state_14666__$1;
(statearr_14817_14993[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (53))){
var inst_14298 = (state_14666[(66)]);
var state_14666__$1 = state_14666;
var statearr_14818_14994 = state_14666__$1;
(statearr_14818_14994[(2)] = inst_14298);

(statearr_14818_14994[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (78))){
var inst_14466 = (state_14666[(10)]);
var inst_14466__$1 = (state_14666[(2)]);
var inst_14467 = cljs.core._EQ_.call(null,inst_14466__$1,fluree.db.util.core.max_long);
var inst_14468 = new cljs.core.Keyword(null,"permissions","permissions",67803075).cljs$core$IFn$_invoke$arity$1(db);
var inst_14469 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14470 = [new cljs.core.Keyword(null,"index-configs","index-configs",1053959280),idx,new cljs.core.Keyword(null,"comparator","comparator",2144896662)];
var inst_14471 = (new cljs.core.PersistentVector(null,3,(5),inst_14469,inst_14470,null));
var inst_14472 = cljs.core.get_in.call(null,db,inst_14471);
var inst_14473 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_14474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14475 = [new cljs.core.Keyword(null,"novelty","novelty",-1590246024),idx];
var inst_14476 = (new cljs.core.PersistentVector(null,2,(5),inst_14474,inst_14475,null));
var inst_14477 = cljs.core.get_in.call(null,db,inst_14476);
var inst_14478 = new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(db);
var inst_14479 = cljs.core.get.call(null,db,idx);
var inst_14480 = fluree.db.dbproto._resolve.call(null,inst_14479);
var state_14666__$1 = (function (){var statearr_14819 = state_14666;
(statearr_14819[(10)] = inst_14466__$1);

(statearr_14819[(25)] = inst_14473);

(statearr_14819[(34)] = inst_14467);

(statearr_14819[(43)] = inst_14472);

(statearr_14819[(46)] = inst_14478);

(statearr_14819[(47)] = inst_14468);

(statearr_14819[(51)] = inst_14477);

return statearr_14819;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14666__$1,(79),inst_14480);
} else {
if((state_val_14667 === (132))){
var inst_14656 = (state_14666[(2)]);
var state_14666__$1 = state_14666;
var statearr_14820_14995 = state_14666__$1;
(statearr_14820_14995[(2)] = inst_14656);

(statearr_14820_14995[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (26))){
var inst_14299 = (state_14666[(55)]);
var state_14666__$1 = state_14666;
var statearr_14821_14996 = state_14666__$1;
(statearr_14821_14996[(2)] = inst_14299);

(statearr_14821_14996[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (123))){
var inst_14473 = (state_14666[(25)]);
var inst_14527 = (state_14666[(7)]);
var inst_14483 = (state_14666[(45)]);
var inst_14478 = (state_14666[(46)]);
var inst_14477 = (state_14666[(51)]);
var inst_14640 = fluree.db.query.range.find_next_valid_node.call(null,inst_14483,inst_14527,inst_14473,inst_14477,inst_14478);
var state_14666__$1 = state_14666;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14666__$1,(126),inst_14640);
} else {
if((state_val_14667 === (16))){
var inst_14290 = (state_14666[(65)]);
var state_14666__$1 = state_14666;
var statearr_14822_14997 = state_14666__$1;
(statearr_14822_14997[(2)] = inst_14290);

(statearr_14822_14997[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (81))){
var inst_14487 = (state_14666[(26)]);
var inst_14462 = (state_14666[(71)]);
var inst_14489 = cljs.core.PersistentVector.EMPTY;
var inst_14490 = inst_14487;
var inst_14491 = inst_14462;
var inst_14492 = (0);
var inst_14493 = (0);
var inst_14494 = inst_14489;
var state_14666__$1 = (function (){var statearr_14823 = state_14666;
(statearr_14823[(18)] = inst_14491);

(statearr_14823[(19)] = inst_14494);

(statearr_14823[(28)] = inst_14490);

(statearr_14823[(12)] = inst_14493);

(statearr_14823[(48)] = inst_14492);

return statearr_14823;
})();
var statearr_14824_14998 = state_14666__$1;
(statearr_14824_14998[(2)] = null);

(statearr_14824_14998[(1)] = (84));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (120))){
var inst_14466 = (state_14666[(10)]);
var inst_14627 = (state_14666[(59)]);
var inst_14628 = (state_14666[(61)]);
var inst_14460 = (state_14666[(36)]);
var inst_14437 = (state_14666[(41)]);
var inst_14472 = (state_14666[(43)]);
var inst_14527 = (state_14666[(7)]);
var inst_14631 = inst_14472.call(null,inst_14527,inst_14437);
var inst_14632 = (inst_14631 < (0));
var inst_14633 = (inst_14627 < inst_14460);
var inst_14634 = (inst_14628 < inst_14466);
var inst_14635 = ((inst_14632) && (inst_14633) && (inst_14634));
var state_14666__$1 = state_14666;
var statearr_14825_14999 = state_14666__$1;
(statearr_14825_14999[(2)] = inst_14635);

(statearr_14825_14999[(1)] = (122));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (79))){
var inst_14436 = (state_14666[(17)]);
var inst_14473 = (state_14666[(25)]);
var inst_14483 = (state_14666[(45)]);
var inst_14478 = (state_14666[(46)]);
var inst_14477 = (state_14666[(51)]);
var inst_14482 = (state_14666[(2)]);
var inst_14483__$1 = fluree.db.util.async.throw_err.call(null,inst_14482);
var inst_14484 = fluree.db.query.range.find_next_valid_node.call(null,inst_14483__$1,inst_14436,inst_14473,inst_14477,inst_14478);
var state_14666__$1 = (function (){var statearr_14826 = state_14666;
(statearr_14826[(45)] = inst_14483__$1);

return statearr_14826;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14666__$1,(80),inst_14484);
} else {
if((state_val_14667 === (38))){
var inst_14386 = (state_14666[(2)]);
var inst_14387 = fluree.db.util.async.throw_err.call(null,inst_14386);
var state_14666__$1 = state_14666;
var statearr_14827_15000 = state_14666__$1;
(statearr_14827_15000[(2)] = inst_14387);

(statearr_14827_15000[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (126))){
var inst_14642 = (state_14666[(2)]);
var inst_14643 = fluree.db.util.async.throw_err.call(null,inst_14642);
var state_14666__$1 = state_14666;
var statearr_14828_15001 = state_14666__$1;
(statearr_14828_15001[(2)] = inst_14643);

(statearr_14828_15001[(1)] = (125));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (98))){
var inst_14491 = (state_14666[(18)]);
var inst_14529 = cljs.core._EQ_.call(null,(0),inst_14491);
var state_14666__$1 = state_14666;
if(inst_14529){
var statearr_14829_15002 = state_14666__$1;
(statearr_14829_15002[(1)] = (101));

} else {
var statearr_14830_15003 = state_14666__$1;
(statearr_14830_15003[(1)] = (102));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (124))){
var state_14666__$1 = state_14666;
var statearr_14831_15004 = state_14666__$1;
(statearr_14831_15004[(2)] = null);

(statearr_14831_15004[(1)] = (125));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (87))){
var inst_14500 = (state_14666[(49)]);
var state_14666__$1 = state_14666;
var statearr_14832_15005 = state_14666__$1;
(statearr_14832_15005[(2)] = inst_14500);

(statearr_14832_15005[(1)] = (88));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (30))){
var state_14666__$1 = state_14666;
var statearr_14833_15006 = state_14666__$1;
(statearr_14833_15006[(2)] = null);

(statearr_14833_15006[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (73))){
var inst_14438 = (state_14666[(8)]);
var inst_14456 = cljs.core.apply.call(null,cljs.core.hash_map,inst_14438);
var state_14666__$1 = state_14666;
var statearr_14834_15007 = state_14666__$1;
(statearr_14834_15007[(2)] = inst_14456);

(statearr_14834_15007[(1)] = (75));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (96))){
var inst_14520 = (state_14666[(62)]);
var state_14666__$1 = state_14666;
var statearr_14835_15008 = state_14666__$1;
(statearr_14835_15008[(2)] = inst_14520);

(statearr_14835_15008[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (10))){
var state_14666__$1 = state_14666;
var statearr_14836_15009 = state_14666__$1;
(statearr_14836_15009[(2)] = false);

(statearr_14836_15009[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (18))){
var inst_14332 = (state_14666[(2)]);
var inst_14333 = fluree.db.util.async.throw_err.call(null,inst_14332);
var state_14666__$1 = state_14666;
var statearr_14837_15010 = state_14666__$1;
(statearr_14837_15010[(2)] = inst_14333);

(statearr_14837_15010[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (105))){
var inst_14436 = (state_14666[(17)]);
var inst_14491 = (state_14666[(18)]);
var inst_14494 = (state_14666[(19)]);
var inst_14466 = (state_14666[(10)]);
var inst_14377 = (state_14666[(20)]);
var inst_14325 = (state_14666[(21)]);
var inst_14426 = (state_14666[(22)]);
var inst_14326 = (state_14666[(23)]);
var inst_14345 = (state_14666[(24)]);
var inst_14473 = (state_14666[(25)]);
var inst_14487 = (state_14666[(26)]);
var inst_14294 = (state_14666[(27)]);
var inst_14490 = (state_14666[(28)]);
var inst_14435 = (state_14666[(29)]);
var inst_14526 = (state_14666[(64)]);
var inst_14301 = (state_14666[(30)]);
var inst_14408 = (state_14666[(31)]);
var inst_14293 = (state_14666[(32)]);
var inst_14459 = (state_14666[(33)]);
var inst_14467 = (state_14666[(34)]);
var inst_14336 = (state_14666[(35)]);
var inst_14548 = (state_14666[(74)]);
var inst_14460 = (state_14666[(36)]);
var inst_14289 = (state_14666[(37)]);
var inst_14324 = (state_14666[(38)]);
var inst_14296 = (state_14666[(39)]);
var inst_14399 = (state_14666[(40)]);
var inst_14437 = (state_14666[(41)]);
var inst_14549 = (state_14666[(82)]);
var inst_14390 = (state_14666[(42)]);
var inst_14472 = (state_14666[(43)]);
var inst_14527 = (state_14666[(7)]);
var inst_14378 = (state_14666[(44)]);
var inst_14483 = (state_14666[(45)]);
var inst_14493 = (state_14666[(12)]);
var inst_14478 = (state_14666[(46)]);
var inst_14468 = (state_14666[(47)]);
var inst_14492 = (state_14666[(48)]);
var inst_14500 = (state_14666[(49)]);
var inst_14381 = (state_14666[(50)]);
var inst_14477 = (state_14666[(51)]);
var inst_14417 = (state_14666[(52)]);
var inst_14300 = (state_14666[(53)]);
var inst_14547 = (function (){var no_filter_QMARK_ = true;
var base_result_SINGLEQUOTE_ = inst_14526;
var t = inst_14473;
var max_limit_QMARK_ = inst_14467;
var next_node = inst_14490;
var fast_forward_db_QMARK_ = inst_14478;
var s1 = inst_14336;
var o2 = inst_14399;
var t1 = inst_14293;
var predicate_fn = inst_14326;
var i = inst_14492;
var rhs = inst_14527;
var m1 = inst_14426;
var root_node = inst_14483;
var s2 = inst_14345;
var p2 = inst_14417;
var map__14288 = inst_14459;
var permissions = inst_14468;
var limit = inst_14466;
var start_flake = inst_14436;
var map__14281 = inst_14324;
var flake_limit = inst_14460;
var offset = inst_14491;
var acc = inst_14494;
var t2 = inst_14300;
var op1 = inst_14294;
var o1 = inst_14390;
var end_flake = inst_14437;
var vec__14282 = inst_14377;
var base_result = inst_14500;
var s = inst_14493;
var node_start = inst_14487;
var p1 = inst_14408;
var subject_fn = inst_14325;
var vec__14278 = inst_14296;
var vec__14275 = inst_14289;
var object_fn = inst_14381;
var idx_compare = inst_14472;
var op2 = inst_14301;
var m2 = inst_14435;
var vec__14285 = inst_14378;
var novelty = inst_14477;
return (function (p1__14260_SHARP_){
return p1__14260_SHARP_.s;
});
})();
var inst_14548__$1 = cljs.core.partition_by.call(null,inst_14547,inst_14526);
var inst_14549__$1 = cljs.core.count.call(null,inst_14548__$1);
var inst_14550 = (inst_14491 > inst_14549__$1);
var state_14666__$1 = (function (){var statearr_14838 = state_14666;
(statearr_14838[(74)] = inst_14548__$1);

(statearr_14838[(82)] = inst_14549__$1);

return statearr_14838;
})();
if(cljs.core.truth_(inst_14550)){
var statearr_14839_15011 = state_14666__$1;
(statearr_14839_15011[(1)] = (107));

} else {
var statearr_14840_15012 = state_14666__$1;
(statearr_14840_15012[(1)] = (108));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (52))){
var state_14666__$1 = state_14666;
var statearr_14841_15013 = state_14666__$1;
(statearr_14841_15013[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_14841_15013[(1)] = (54));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (114))){
var inst_14569 = (state_14666[(13)]);
var inst_14578 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14579 = [inst_14569,inst_14569];
var inst_14580 = (new cljs.core.PersistentVector(null,2,(5),inst_14578,inst_14579,null));
var state_14666__$1 = state_14666;
var statearr_14842_15014 = state_14666__$1;
(statearr_14842_15014[(2)] = inst_14580);

(statearr_14842_15014[(1)] = (115));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (67))){
var inst_14438 = (state_14666[(8)]);
var inst_14443 = inst_14438.cljs$lang$protocol_mask$partition0$;
var inst_14444 = (inst_14443 & (64));
var inst_14445 = inst_14438.cljs$core$ISeq$;
var inst_14446 = (cljs.core.PROTOCOL_SENTINEL === inst_14445);
var inst_14447 = ((inst_14444) || (inst_14446));
var state_14666__$1 = state_14666;
if(cljs.core.truth_(inst_14447)){
var statearr_14843_15015 = state_14666__$1;
(statearr_14843_15015[(1)] = (70));

} else {
var statearr_14844_15016 = state_14666__$1;
(statearr_14844_15016[(1)] = (71));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (71))){
var state_14666__$1 = state_14666;
var statearr_14845_15017 = state_14666__$1;
(statearr_14845_15017[(2)] = false);

(statearr_14845_15017[(1)] = (72));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (42))){
var inst_14395 = (state_14666[(2)]);
var inst_14396 = fluree.db.util.async.throw_err.call(null,inst_14395);
var state_14666__$1 = state_14666;
var statearr_14846_15018 = state_14666__$1;
(statearr_14846_15018[(2)] = inst_14396);

(statearr_14846_15018[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (80))){
var inst_14487 = (state_14666[(26)]);
var inst_14486 = (state_14666[(2)]);
var inst_14487__$1 = fluree.db.util.async.throw_err.call(null,inst_14486);
var state_14666__$1 = (function (){var statearr_14847 = state_14666;
(statearr_14847[(26)] = inst_14487__$1);

return statearr_14847;
})();
if(cljs.core.truth_(inst_14487__$1)){
var statearr_14848_15019 = state_14666__$1;
(statearr_14848_15019[(1)] = (81));

} else {
var statearr_14849_15020 = state_14666__$1;
(statearr_14849_15020[(1)] = (82));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (37))){
var inst_14380 = (state_14666[(57)]);
var inst_14390 = (state_14666[(2)]);
var inst_14391 = fluree.db.util.core.pred_ident_QMARK_.call(null,inst_14380);
var state_14666__$1 = (function (){var statearr_14850 = state_14666;
(statearr_14850[(42)] = inst_14390);

return statearr_14850;
})();
if(inst_14391){
var statearr_14851_15021 = state_14666__$1;
(statearr_14851_15021[(1)] = (39));

} else {
var statearr_14852_15022 = state_14666__$1;
(statearr_14852_15022[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (63))){
var inst_14426 = (state_14666[(22)]);
var inst_14345 = (state_14666[(24)]);
var inst_14294 = (state_14666[(27)]);
var inst_14435 = (state_14666[(29)]);
var inst_14301 = (state_14666[(30)]);
var inst_14408 = (state_14666[(31)]);
var inst_14293 = (state_14666[(32)]);
var inst_14336 = (state_14666[(35)]);
var inst_14399 = (state_14666[(40)]);
var inst_14390 = (state_14666[(42)]);
var inst_14438 = (state_14666[(8)]);
var inst_14417 = (state_14666[(52)]);
var inst_14300 = (state_14666[(53)]);
var inst_14435__$1 = (state_14666[(2)]);
var inst_14436 = fluree.db.flake.__GT_Flake.call(null,inst_14336,inst_14408,inst_14390,inst_14293,inst_14294,inst_14426);
var inst_14437 = fluree.db.flake.__GT_Flake.call(null,inst_14345,inst_14417,inst_14399,inst_14300,inst_14301,inst_14435__$1);
var inst_14438__$1 = opts;
var inst_14440 = (inst_14438__$1 == null);
var inst_14441 = cljs.core.not.call(null,inst_14440);
var state_14666__$1 = (function (){var statearr_14853 = state_14666;
(statearr_14853[(17)] = inst_14436);

(statearr_14853[(29)] = inst_14435__$1);

(statearr_14853[(41)] = inst_14437);

(statearr_14853[(8)] = inst_14438__$1);

return statearr_14853;
})();
if(inst_14441){
var statearr_14854_15023 = state_14666__$1;
(statearr_14854_15023[(1)] = (67));

} else {
var statearr_14855_15024 = state_14666__$1;
(statearr_14855_15024[(1)] = (68));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (94))){
var inst_14381 = (state_14666[(50)]);
var inst_14520 = (state_14666[(2)]);
var state_14666__$1 = (function (){var statearr_14856 = state_14666;
(statearr_14856[(62)] = inst_14520);

return statearr_14856;
})();
if(cljs.core.truth_(inst_14381)){
var statearr_14857_15025 = state_14666__$1;
(statearr_14857_15025[(1)] = (95));

} else {
var statearr_14858_15026 = state_14666__$1;
(statearr_14858_15026[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (8))){
var inst_14319 = (state_14666[(2)]);
var state_14666__$1 = state_14666;
if(cljs.core.truth_(inst_14319)){
var statearr_14859_15027 = state_14666__$1;
(statearr_14859_15027[(1)] = (12));

} else {
var statearr_14860_15028 = state_14666__$1;
(statearr_14860_15028[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (49))){
var inst_14399 = (state_14666[(40)]);
var state_14666__$1 = state_14666;
var statearr_14861_15029 = state_14666__$1;
(statearr_14861_15029[(2)] = inst_14399);

(statearr_14861_15029[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14667 === (84))){
var inst_14436 = (state_14666[(17)]);
var inst_14490 = (state_14666[(28)]);
var inst_14437 = (state_14666[(41)]);
var inst_14499 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_14490);
var inst_14500 = fluree.db.flake.subrange.call(null,inst_14499,start_test,inst_14436,end_test,inst_14437);
var inst_14502 = fluree.db.query.range.value_with_nil_pred.call(null,idx,inst_14436,inst_14437);
var state_14666__$1 = (function (){var statearr_14862 = state_14666;
(statearr_14862[(49)] = inst_14500);

return statearr_14862;
})();
if(inst_14502){
var statearr_14863_15030 = state_14666__$1;
(statearr_14863_15030[(1)] = (86));

} else {
var statearr_14864_15031 = state_14666__$1;
(statearr_14864_15031[(1)] = (87));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2879__auto__ = null;
var fluree$db$query$range$state_machine__2879__auto____0 = (function (){
var statearr_14865 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14865[(0)] = fluree$db$query$range$state_machine__2879__auto__);

(statearr_14865[(1)] = (1));

return statearr_14865;
});
var fluree$db$query$range$state_machine__2879__auto____1 = (function (state_14666){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_14666);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e14866){var ex__2882__auto__ = e14866;
var statearr_14867_15032 = state_14666;
(statearr_14867_15032[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_14666[(4)]))){
var statearr_14868_15033 = state_14666;
(statearr_14868_15033[(1)] = cljs.core.first.call(null,(state_14666[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15034 = state_14666;
state_14666 = G__15034;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2879__auto__ = function(state_14666){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2879__auto____1.call(this,state_14666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2879__auto____0;
fluree$db$query$range$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2879__auto____1;
return fluree$db$query$range$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_14869 = f__2902__auto__.call(null);
(statearr_14869[(6)] = c__2901__auto__);

return statearr_14869;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_.call(null,o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find.call(null,/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id.call(null,(3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id.call(null,(3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_15090){
var state_val_15091 = (state_15090[(1)]);
if((state_val_15091 === (7))){
var inst_15064 = (state_15090[(7)]);
var inst_15054 = (state_15090[(8)]);
var inst_15062 = fluree.db.flake.Flake__GT_parts.call(null,inst_15054);
var inst_15063 = cljs.core.nth.call(null,inst_15062,(0),null);
var inst_15064__$1 = cljs.core.nth.call(null,inst_15062,(1),null);
var inst_15065 = cljs.core.nth.call(null,inst_15062,(2),null);
var inst_15066 = cljs.core.nth.call(null,inst_15062,(3),null);
var inst_15067 = cljs.core.nth.call(null,inst_15062,(4),null);
var inst_15068 = cljs.core.nth.call(null,inst_15062,(5),null);
var inst_15069 = fluree.db.dbproto._tag.call(null,db,inst_15065,inst_15064__$1);
var state_15090__$1 = (function (){var statearr_15092 = state_15090;
(statearr_15092[(9)] = inst_15068);

(statearr_15092[(7)] = inst_15064__$1);

(statearr_15092[(10)] = inst_15067);

(statearr_15092[(11)] = inst_15063);

(statearr_15092[(12)] = inst_15066);

return statearr_15092;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15090__$1,(10),inst_15069);
} else {
if((state_val_15091 === (1))){
var inst_15042 = flakes;
var inst_15043 = cljs.core.seq.call(null,inst_15042);
var inst_15044 = cljs.core.first.call(null,inst_15043);
var inst_15045 = cljs.core.next.call(null,inst_15043);
var inst_15046 = cljs.core.PersistentVector.EMPTY;
var inst_15047 = inst_15042;
var inst_15048 = inst_15046;
var state_15090__$1 = (function (){var statearr_15093 = state_15090;
(statearr_15093[(13)] = inst_15045);

(statearr_15093[(14)] = inst_15047);

(statearr_15093[(15)] = inst_15048);

(statearr_15093[(16)] = inst_15044);

return statearr_15093;
})();
var statearr_15094_15112 = state_15090__$1;
(statearr_15094_15112[(2)] = null);

(statearr_15094_15112[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15091 === (4))){
var inst_15054 = (state_15090[(8)]);
var inst_15057 = fluree.db.query.range.is_tag_flake_QMARK_.call(null,inst_15054);
var state_15090__$1 = state_15090;
if(inst_15057){
var statearr_15095_15113 = state_15090__$1;
(statearr_15095_15113[(1)] = (7));

} else {
var statearr_15096_15114 = state_15090__$1;
(statearr_15096_15114[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15091 === (6))){
var inst_15086 = (state_15090[(2)]);
var state_15090__$1 = state_15090;
var statearr_15097_15115 = state_15090__$1;
(statearr_15097_15115[(2)] = inst_15086);

(statearr_15097_15115[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15091 === (3))){
var inst_15088 = (state_15090[(2)]);
var state_15090__$1 = state_15090;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15090__$1,inst_15088);
} else {
if((state_val_15091 === (2))){
var inst_15047 = (state_15090[(14)]);
var inst_15054 = (state_15090[(8)]);
var inst_15053 = cljs.core.seq.call(null,inst_15047);
var inst_15054__$1 = cljs.core.first.call(null,inst_15053);
var inst_15055 = cljs.core.next.call(null,inst_15053);
var state_15090__$1 = (function (){var statearr_15098 = state_15090;
(statearr_15098[(8)] = inst_15054__$1);

(statearr_15098[(17)] = inst_15055);

return statearr_15098;
})();
if(cljs.core.truth_(inst_15054__$1)){
var statearr_15099_15116 = state_15090__$1;
(statearr_15099_15116[(1)] = (4));

} else {
var statearr_15100_15117 = state_15090__$1;
(statearr_15100_15117[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15091 === (9))){
var inst_15083 = (state_15090[(2)]);
var state_15090__$1 = state_15090;
var statearr_15101_15118 = state_15090__$1;
(statearr_15101_15118[(2)] = inst_15083);

(statearr_15101_15118[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15091 === (5))){
var inst_15048 = (state_15090[(15)]);
var state_15090__$1 = state_15090;
var statearr_15102_15119 = state_15090__$1;
(statearr_15102_15119[(2)] = inst_15048);

(statearr_15102_15119[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15091 === (10))){
var inst_15068 = (state_15090[(9)]);
var inst_15064 = (state_15090[(7)]);
var inst_15048 = (state_15090[(15)]);
var inst_15067 = (state_15090[(10)]);
var inst_15063 = (state_15090[(11)]);
var inst_15066 = (state_15090[(12)]);
var inst_15055 = (state_15090[(17)]);
var inst_15071 = (state_15090[(2)]);
var inst_15072 = fluree.db.util.async.throw_err.call(null,inst_15071);
var inst_15073 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15074 = [inst_15063,inst_15064,inst_15072,inst_15066,inst_15067,inst_15068];
var inst_15075 = (new cljs.core.PersistentVector(null,6,(5),inst_15073,inst_15074,null));
var inst_15076 = fluree.db.flake.parts__GT_Flake.call(null,inst_15075);
var inst_15077 = cljs.core.conj.call(null,inst_15048,inst_15076);
var inst_15047 = inst_15055;
var inst_15048__$1 = inst_15077;
var state_15090__$1 = (function (){var statearr_15103 = state_15090;
(statearr_15103[(14)] = inst_15047);

(statearr_15103[(15)] = inst_15048__$1);

return statearr_15103;
})();
var statearr_15104_15120 = state_15090__$1;
(statearr_15104_15120[(2)] = null);

(statearr_15104_15120[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15091 === (8))){
var inst_15048 = (state_15090[(15)]);
var inst_15054 = (state_15090[(8)]);
var inst_15055 = (state_15090[(17)]);
var inst_15080 = cljs.core.conj.call(null,inst_15048,inst_15054);
var inst_15047 = inst_15055;
var inst_15048__$1 = inst_15080;
var state_15090__$1 = (function (){var statearr_15105 = state_15090;
(statearr_15105[(14)] = inst_15047);

(statearr_15105[(15)] = inst_15048__$1);

return statearr_15105;
})();
var statearr_15106_15121 = state_15090__$1;
(statearr_15106_15121[(2)] = null);

(statearr_15106_15121[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto____0 = (function (){
var statearr_15107 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15107[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto__);

(statearr_15107[(1)] = (1));

return statearr_15107;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto____1 = (function (state_15090){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_15090);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e15108){var ex__2882__auto__ = e15108;
var statearr_15109_15122 = state_15090;
(statearr_15109_15122[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_15090[(4)]))){
var statearr_15110_15123 = state_15090;
(statearr_15110_15123[(1)] = cljs.core.first.call(null,(state_15090[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15124 = state_15090;
state_15090 = G__15124;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto__ = function(state_15090){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto____1.call(this,state_15090);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_15111 = f__2902__auto__.call(null);
(statearr_15111[(6)] = c__2901__auto__);

return statearr_15111;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__15126 = arguments.length;
switch (G__15126) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.call(null,db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_15277){
var state_val_15278 = (state_15277[(1)]);
if((state_val_15278 === (62))){
var inst_15264 = (state_15277[(7)]);
var state_15277__$1 = state_15277;
var statearr_15279_15368 = state_15277__$1;
(statearr_15279_15368[(2)] = inst_15264);

(statearr_15279_15368[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (7))){
var state_15277__$1 = state_15277;
var statearr_15280_15369 = state_15277__$1;
(statearr_15280_15369[(2)] = false);

(statearr_15280_15369[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (59))){
var inst_15256 = (state_15277[(2)]);
var state_15277__$1 = state_15277;
var statearr_15281_15370 = state_15277__$1;
(statearr_15281_15370[(2)] = inst_15256);

(statearr_15281_15370[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (20))){
var state_15277__$1 = state_15277;
var statearr_15282_15371 = state_15277__$1;
(statearr_15282_15371[(2)] = null);

(statearr_15282_15371[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (58))){
var state_15277__$1 = state_15277;
var statearr_15283_15372 = state_15277__$1;
(statearr_15283_15372[(2)] = null);

(statearr_15283_15372[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (60))){
var inst_15252 = (state_15277[(2)]);
var inst_15253 = fluree.db.util.async.throw_err.call(null,inst_15252);
var state_15277__$1 = state_15277;
var statearr_15284_15373 = state_15277__$1;
(statearr_15284_15373[(2)] = inst_15253);

(statearr_15284_15373[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (27))){
var inst_15177 = (state_15277[(8)]);
var inst_15188 = fluree.db.query.range.non_nil_non_boolean_QMARK_.call(null,inst_15177);
var state_15277__$1 = state_15277;
if(inst_15188){
var statearr_15285_15374 = state_15277__$1;
(statearr_15285_15374[(1)] = (30));

} else {
var statearr_15286_15375 = state_15277__$1;
(statearr_15286_15375[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (1))){
var state_15277__$1 = state_15277;
var statearr_15287_15376 = state_15277__$1;
(statearr_15287_15376[(2)] = null);

(statearr_15287_15376[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (24))){
var inst_15138 = (state_15277[(9)]);
var state_15277__$1 = state_15277;
if(cljs.core.truth_(inst_15138)){
var statearr_15288_15377 = state_15277__$1;
(statearr_15288_15377[(1)] = (27));

} else {
var statearr_15289_15378 = state_15277__$1;
(statearr_15289_15378[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (55))){
var inst_15258 = (state_15277[(2)]);
var state_15277__$1 = state_15277;
var statearr_15290_15379 = state_15277__$1;
(statearr_15290_15379[(2)] = inst_15258);

(statearr_15290_15379[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (39))){
var inst_15208 = (state_15277[(2)]);
var inst_15209 = fluree.db.util.async.throw_err.call(null,inst_15208);
var state_15277__$1 = state_15277;
var statearr_15291_15380 = state_15277__$1;
(statearr_15291_15380[(2)] = inst_15209);

(statearr_15291_15380[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (46))){
var inst_15221 = (state_15277[(10)]);
var inst_15221__$1 = new cljs.core.Keyword(null,"object-fn","object-fn",1425858481).cljs$core$IFn$_invoke$arity$1(opts);
var state_15277__$1 = (function (){var statearr_15292 = state_15277;
(statearr_15292[(10)] = inst_15221__$1);

return statearr_15292;
})();
if(cljs.core.truth_(inst_15221__$1)){
var statearr_15293_15381 = state_15277__$1;
(statearr_15293_15381[(1)] = (49));

} else {
var statearr_15294_15382 = state_15277__$1;
(statearr_15294_15382[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (4))){
var inst_15127 = (state_15277[(2)]);
var state_15277__$1 = state_15277;
var statearr_15295_15383 = state_15277__$1;
(statearr_15295_15383[(2)] = inst_15127);

(statearr_15295_15383[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (54))){
var inst_15177 = (state_15277[(8)]);
var state_15277__$1 = state_15277;
if(cljs.core.truth_(inst_15177)){
var statearr_15296_15384 = state_15277__$1;
(statearr_15296_15384[(1)] = (57));

} else {
var statearr_15297_15385 = state_15277__$1;
(statearr_15297_15385[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (15))){
var inst_15139 = (state_15277[(11)]);
var inst_15158 = fluree.db.dbproto._tag_id.call(null,db,inst_15139);
var state_15277__$1 = state_15277;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15277__$1,(18),inst_15158);
} else {
if((state_val_15278 === (48))){
var inst_15260 = (state_15277[(2)]);
var state_15277__$1 = state_15277;
var statearr_15298_15386 = state_15277__$1;
(statearr_15298_15386[(2)] = inst_15260);

(statearr_15298_15386[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (50))){
var inst_15140 = (state_15277[(12)]);
var inst_15137 = (state_15277[(13)]);
var inst_15141 = (state_15277[(14)]);
var inst_15147 = (state_15277[(15)]);
var inst_15138 = (state_15277[(9)]);
var inst_15136 = (state_15277[(16)]);
var inst_15152 = (state_15277[(17)]);
var inst_15221 = (state_15277[(10)]);
var inst_15177 = (state_15277[(8)]);
var inst_15225 = (function (){var t = inst_15140;
var temp__5733__auto__ = inst_15221;
var vec__15133 = inst_15136;
var p = inst_15138;
var idx_predicate_QMARK_ = inst_15141;
var o = inst_15177;
var tag_predicate_QMARK_ = inst_15147;
var s = inst_15137;
var o_coerce_QMARK_ = inst_15152;
return (function (x){
return cljs.core._EQ_.call(null,x,o);
});
})();
var state_15277__$1 = state_15277;
var statearr_15299_15387 = state_15277__$1;
(statearr_15299_15387[(2)] = inst_15225);

(statearr_15299_15387[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (21))){
var inst_15173 = (state_15277[(2)]);
var state_15277__$1 = state_15277;
var statearr_15300_15388 = state_15277__$1;
(statearr_15300_15388[(2)] = inst_15173);

(statearr_15300_15388[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (31))){
var state_15277__$1 = state_15277;
var statearr_15301_15389 = state_15277__$1;
(statearr_15301_15389[(2)] = false);

(statearr_15301_15389[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (32))){
var inst_15198 = (state_15277[(2)]);
var state_15277__$1 = state_15277;
var statearr_15302_15390 = state_15277__$1;
(statearr_15302_15390[(2)] = inst_15198);

(statearr_15302_15390[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (40))){
var inst_15141 = (state_15277[(14)]);
var inst_15212 = cljs.core.not.call(null,inst_15141);
var state_15277__$1 = state_15277;
if(inst_15212){
var statearr_15303_15391 = state_15277__$1;
(statearr_15303_15391[(1)] = (43));

} else {
var statearr_15304_15392 = state_15277__$1;
(statearr_15304_15392[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (56))){
var inst_15243 = (state_15277[(2)]);
var inst_15244 = fluree.db.util.async.throw_err.call(null,inst_15243);
var state_15277__$1 = state_15277;
var statearr_15305_15393 = state_15277__$1;
(statearr_15305_15393[(2)] = inst_15244);

(statearr_15305_15393[(1)] = (55));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (33))){
var inst_15177 = (state_15277[(8)]);
var inst_15191 = cljs.core.fn_QMARK_.call(null,inst_15177);
var inst_15192 = (!(inst_15191));
var state_15277__$1 = state_15277;
var statearr_15306_15394 = state_15277__$1;
(statearr_15306_15394[(2)] = inst_15192);

(statearr_15306_15394[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (13))){
var inst_15139 = (state_15277[(11)]);
var inst_15156 = fluree.db.query.range.tag_string_QMARK_.call(null,inst_15139);
var state_15277__$1 = state_15277;
if(cljs.core.truth_(inst_15156)){
var statearr_15307_15395 = state_15277__$1;
(statearr_15307_15395[(1)] = (15));

} else {
var statearr_15308_15396 = state_15277__$1;
(statearr_15308_15396[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (22))){
var inst_15169 = (state_15277[(2)]);
var inst_15170 = fluree.db.util.async.throw_err.call(null,inst_15169);
var state_15277__$1 = state_15277;
var statearr_15309_15397 = state_15277__$1;
(statearr_15309_15397[(2)] = inst_15170);

(statearr_15309_15397[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (36))){
var inst_15140 = (state_15277[(12)]);
var inst_15137 = (state_15277[(13)]);
var inst_15138 = (state_15277[(9)]);
var inst_15177 = (state_15277[(8)]);
var inst_15203 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15204 = [inst_15138,inst_15177,inst_15137,inst_15140];
var inst_15205 = (new cljs.core.PersistentVector(null,4,(5),inst_15203,inst_15204,null));
var inst_15206 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"post","post",269697687),cljs.core._EQ_,inst_15205,opts);
var state_15277__$1 = state_15277;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15277__$1,(39),inst_15206);
} else {
if((state_val_15278 === (41))){
var inst_15138 = (state_15277[(9)]);
var state_15277__$1 = state_15277;
var statearr_15310_15398 = state_15277__$1;
(statearr_15310_15398[(2)] = inst_15138);

(statearr_15310_15398[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (43))){
var inst_15177 = (state_15277[(8)]);
var state_15277__$1 = state_15277;
var statearr_15311_15399 = state_15277__$1;
(statearr_15311_15399[(2)] = inst_15177);

(statearr_15311_15399[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (61))){
var inst_15264 = (state_15277[(7)]);
var inst_15266 = fluree.db.query.range.coerce_tag_flakes.call(null,db,inst_15264);
var state_15277__$1 = state_15277;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15277__$1,(64),inst_15266);
} else {
if((state_val_15278 === (29))){
var inst_15201 = (state_15277[(2)]);
var state_15277__$1 = state_15277;
if(cljs.core.truth_(inst_15201)){
var statearr_15312_15400 = state_15277__$1;
(statearr_15312_15400[(1)] = (36));

} else {
var statearr_15313_15401 = state_15277__$1;
(statearr_15313_15401[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (44))){
var state_15277__$1 = state_15277;
var statearr_15314_15402 = state_15277__$1;
(statearr_15314_15402[(2)] = false);

(statearr_15314_15402[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (6))){
var inst_15138 = (state_15277[(9)]);
var inst_15143 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"type","type",1174270348),inst_15138);
var inst_15144 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"tag","tag",-1290361223),inst_15143);
var state_15277__$1 = state_15277;
var statearr_15315_15403 = state_15277__$1;
(statearr_15315_15403[(2)] = inst_15144);

(statearr_15315_15403[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (28))){
var inst_15138 = (state_15277[(9)]);
var state_15277__$1 = state_15277;
var statearr_15316_15404 = state_15277__$1;
(statearr_15316_15404[(2)] = inst_15138);

(statearr_15316_15404[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (64))){
var inst_15268 = (state_15277[(2)]);
var inst_15269 = fluree.db.util.async.throw_err.call(null,inst_15268);
var state_15277__$1 = state_15277;
var statearr_15317_15405 = state_15277__$1;
(statearr_15317_15405[(2)] = inst_15269);

(statearr_15317_15405[(1)] = (63));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (51))){
var inst_15140 = (state_15277[(12)]);
var inst_15137 = (state_15277[(13)]);
var inst_15138 = (state_15277[(9)]);
var inst_15227 = (state_15277[(2)]);
var inst_15228 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15229 = [inst_15138,inst_15137,null,inst_15140];
var inst_15230 = (new cljs.core.PersistentVector(null,4,(5),inst_15228,inst_15229,null));
var inst_15231 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"object-fn","object-fn",1425858481),inst_15227);
var inst_15232 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15230,inst_15231);
var state_15277__$1 = state_15277;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15277__$1,(52),inst_15232);
} else {
if((state_val_15278 === (25))){
var inst_15147 = (state_15277[(15)]);
var inst_15264 = (state_15277[(2)]);
var state_15277__$1 = (function (){var statearr_15318 = state_15277;
(statearr_15318[(7)] = inst_15264);

return statearr_15318;
})();
if(cljs.core.truth_(inst_15147)){
var statearr_15319_15406 = state_15277__$1;
(statearr_15319_15406[(1)] = (61));

} else {
var statearr_15320_15407 = state_15277__$1;
(statearr_15320_15407[(1)] = (62));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (34))){
var inst_15141 = (state_15277[(14)]);
var state_15277__$1 = state_15277;
var statearr_15321_15408 = state_15277__$1;
(statearr_15321_15408[(2)] = inst_15141);

(statearr_15321_15408[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (17))){
var inst_15175 = (state_15277[(2)]);
var state_15277__$1 = state_15277;
var statearr_15322_15409 = state_15277__$1;
(statearr_15322_15409[(2)] = inst_15175);

(statearr_15322_15409[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (3))){
var inst_15275 = (state_15277[(2)]);
var state_15277__$1 = state_15277;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15277__$1,inst_15275);
} else {
if((state_val_15278 === (12))){
var inst_15139 = (state_15277[(11)]);
var state_15277__$1 = state_15277;
var statearr_15323_15410 = state_15277__$1;
(statearr_15323_15410[(2)] = inst_15139);

(statearr_15323_15410[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (2))){
var inst_15138 = (state_15277[(9)]);
var inst_15136 = (state_15277[(16)]);
var _ = (function (){var statearr_15324 = state_15277;
(statearr_15324[(4)] = cljs.core.cons.call(null,(5),(state_15277[(4)])));

return statearr_15324;
})();
var inst_15136__$1 = fparts;
var inst_15137 = cljs.core.nth.call(null,inst_15136__$1,(0),null);
var inst_15138__$1 = cljs.core.nth.call(null,inst_15136__$1,(1),null);
var inst_15139 = cljs.core.nth.call(null,inst_15136__$1,(2),null);
var inst_15140 = cljs.core.nth.call(null,inst_15136__$1,(3),null);
var inst_15141 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"idx?","idx?",-564590377),inst_15138__$1);
var state_15277__$1 = (function (){var statearr_15325 = state_15277;
(statearr_15325[(12)] = inst_15140);

(statearr_15325[(11)] = inst_15139);

(statearr_15325[(13)] = inst_15137);

(statearr_15325[(14)] = inst_15141);

(statearr_15325[(9)] = inst_15138__$1);

(statearr_15325[(16)] = inst_15136__$1);

return statearr_15325;
})();
if(cljs.core.truth_(inst_15138__$1)){
var statearr_15326_15411 = state_15277__$1;
(statearr_15326_15411[(1)] = (6));

} else {
var statearr_15327_15412 = state_15277__$1;
(statearr_15327_15412[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (23))){
var inst_15140 = (state_15277[(12)]);
var inst_15137 = (state_15277[(13)]);
var inst_15138 = (state_15277[(9)]);
var inst_15177 = (state_15277[(8)]);
var inst_15179 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15180 = [inst_15137,inst_15138,inst_15177,inst_15140];
var inst_15181 = (new cljs.core.PersistentVector(null,4,(5),inst_15179,inst_15180,null));
var inst_15182 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_15181,opts);
var state_15277__$1 = state_15277;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15277__$1,(26),inst_15182);
} else {
if((state_val_15278 === (47))){
var inst_15138 = (state_15277[(9)]);
var state_15277__$1 = state_15277;
if(cljs.core.truth_(inst_15138)){
var statearr_15328_15413 = state_15277__$1;
(statearr_15328_15413[(1)] = (53));

} else {
var statearr_15329_15414 = state_15277__$1;
(statearr_15329_15414[(1)] = (54));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (35))){
var inst_15195 = (state_15277[(2)]);
var state_15277__$1 = state_15277;
var statearr_15330_15415 = state_15277__$1;
(statearr_15330_15415[(2)] = inst_15195);

(statearr_15330_15415[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (19))){
var inst_15139 = (state_15277[(11)]);
var inst_15138 = (state_15277[(9)]);
var inst_15165 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_15138);
var inst_15166 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15165),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_15139)].join('');
var inst_15167 = fluree.db.dbproto._tag_id.call(null,db,inst_15166);
var state_15277__$1 = state_15277;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15277__$1,(22),inst_15167);
} else {
if((state_val_15278 === (57))){
var inst_15140 = (state_15277[(12)]);
var inst_15137 = (state_15277[(13)]);
var inst_15138 = (state_15277[(9)]);
var inst_15177 = (state_15277[(8)]);
var inst_15247 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15248 = [inst_15177,inst_15138,inst_15137,inst_15140];
var inst_15249 = (new cljs.core.PersistentVector(null,4,(5),inst_15247,inst_15248,null));
var inst_15250 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"opst","opst",1213963058),cljs.core._EQ_,inst_15249,opts);
var state_15277__$1 = state_15277;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15277__$1,(60),inst_15250);
} else {
if((state_val_15278 === (11))){
var inst_15152 = (state_15277[(17)]);
var inst_15152__$1 = (state_15277[(2)]);
var inst_15153 = cljs.core.not.call(null,inst_15152__$1);
var state_15277__$1 = (function (){var statearr_15332 = state_15277;
(statearr_15332[(17)] = inst_15152__$1);

return statearr_15332;
})();
if(inst_15153){
var statearr_15333_15416 = state_15277__$1;
(statearr_15333_15416[(1)] = (12));

} else {
var statearr_15334_15417 = state_15277__$1;
(statearr_15334_15417[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (9))){
var inst_15139 = (state_15277[(11)]);
var inst_15149 = typeof inst_15139 === 'string';
var state_15277__$1 = state_15277;
var statearr_15335_15418 = state_15277__$1;
(statearr_15335_15418[(2)] = inst_15149);

(statearr_15335_15418[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (5))){
var _ = (function (){var statearr_15336 = state_15277;
(statearr_15336[(4)] = cljs.core.rest.call(null,(state_15277[(4)])));

return statearr_15336;
})();
var state_15277__$1 = state_15277;
var ex15331 = (state_15277__$1[(2)]);
var statearr_15337_15419 = state_15277__$1;
(statearr_15337_15419[(5)] = ex15331);


if((ex15331 instanceof Error)){
var statearr_15338_15420 = state_15277__$1;
(statearr_15338_15420[(1)] = (4));

(statearr_15338_15420[(5)] = null);

} else {
throw ex15331;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (14))){
var inst_15137 = (state_15277[(13)]);
var inst_15177 = (state_15277[(2)]);
var state_15277__$1 = (function (){var statearr_15339 = state_15277;
(statearr_15339[(8)] = inst_15177);

return statearr_15339;
})();
if(cljs.core.truth_(inst_15137)){
var statearr_15340_15421 = state_15277__$1;
(statearr_15340_15421[(1)] = (23));

} else {
var statearr_15341_15422 = state_15277__$1;
(statearr_15341_15422[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (45))){
var inst_15216 = (state_15277[(2)]);
var state_15277__$1 = state_15277;
var statearr_15342_15423 = state_15277__$1;
(statearr_15342_15423[(2)] = inst_15216);

(statearr_15342_15423[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (53))){
var inst_15140 = (state_15277[(12)]);
var inst_15137 = (state_15277[(13)]);
var inst_15138 = (state_15277[(9)]);
var inst_15177 = (state_15277[(8)]);
var inst_15238 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15239 = [inst_15138,inst_15137,inst_15177,inst_15140];
var inst_15240 = (new cljs.core.PersistentVector(null,4,(5),inst_15238,inst_15239,null));
var inst_15241 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_15240,opts);
var state_15277__$1 = state_15277;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15277__$1,(56),inst_15241);
} else {
if((state_val_15278 === (26))){
var inst_15184 = (state_15277[(2)]);
var inst_15185 = fluree.db.util.async.throw_err.call(null,inst_15184);
var state_15277__$1 = state_15277;
var statearr_15343_15424 = state_15277__$1;
(statearr_15343_15424[(2)] = inst_15185);

(statearr_15343_15424[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (16))){
var inst_15139 = (state_15277[(11)]);
var inst_15163 = typeof inst_15139 === 'string';
var state_15277__$1 = state_15277;
if(cljs.core.truth_(inst_15163)){
var statearr_15344_15425 = state_15277__$1;
(statearr_15344_15425[(1)] = (19));

} else {
var statearr_15345_15426 = state_15277__$1;
(statearr_15345_15426[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (38))){
var inst_15262 = (state_15277[(2)]);
var state_15277__$1 = state_15277;
var statearr_15346_15427 = state_15277__$1;
(statearr_15346_15427[(2)] = inst_15262);

(statearr_15346_15427[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (30))){
var inst_15141 = (state_15277[(14)]);
var state_15277__$1 = state_15277;
if(cljs.core.truth_(inst_15141)){
var statearr_15347_15428 = state_15277__$1;
(statearr_15347_15428[(1)] = (33));

} else {
var statearr_15348_15429 = state_15277__$1;
(statearr_15348_15429[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (10))){
var inst_15147 = (state_15277[(15)]);
var state_15277__$1 = state_15277;
var statearr_15349_15430 = state_15277__$1;
(statearr_15349_15430[(2)] = inst_15147);

(statearr_15349_15430[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (18))){
var inst_15160 = (state_15277[(2)]);
var inst_15161 = fluree.db.util.async.throw_err.call(null,inst_15160);
var state_15277__$1 = state_15277;
var statearr_15350_15431 = state_15277__$1;
(statearr_15350_15431[(2)] = inst_15161);

(statearr_15350_15431[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (52))){
var inst_15234 = (state_15277[(2)]);
var inst_15235 = fluree.db.util.async.throw_err.call(null,inst_15234);
var state_15277__$1 = state_15277;
var statearr_15351_15432 = state_15277__$1;
(statearr_15351_15432[(2)] = inst_15235);

(statearr_15351_15432[(1)] = (48));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (42))){
var inst_15219 = (state_15277[(2)]);
var state_15277__$1 = state_15277;
if(cljs.core.truth_(inst_15219)){
var statearr_15352_15433 = state_15277__$1;
(statearr_15352_15433[(1)] = (46));

} else {
var statearr_15353_15434 = state_15277__$1;
(statearr_15353_15434[(1)] = (47));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (37))){
var inst_15138 = (state_15277[(9)]);
var state_15277__$1 = state_15277;
if(cljs.core.truth_(inst_15138)){
var statearr_15354_15435 = state_15277__$1;
(statearr_15354_15435[(1)] = (40));

} else {
var statearr_15355_15436 = state_15277__$1;
(statearr_15355_15436[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (63))){
var inst_15272 = (state_15277[(2)]);
var _ = (function (){var statearr_15356 = state_15277;
(statearr_15356[(4)] = cljs.core.rest.call(null,(state_15277[(4)])));

return statearr_15356;
})();
var state_15277__$1 = state_15277;
var statearr_15357_15437 = state_15277__$1;
(statearr_15357_15437[(2)] = inst_15272);

(statearr_15357_15437[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (8))){
var inst_15147 = (state_15277[(15)]);
var inst_15147__$1 = (state_15277[(2)]);
var state_15277__$1 = (function (){var statearr_15358 = state_15277;
(statearr_15358[(15)] = inst_15147__$1);

return statearr_15358;
})();
if(cljs.core.truth_(inst_15147__$1)){
var statearr_15359_15438 = state_15277__$1;
(statearr_15359_15438[(1)] = (9));

} else {
var statearr_15360_15439 = state_15277__$1;
(statearr_15360_15439[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15278 === (49))){
var inst_15140 = (state_15277[(12)]);
var inst_15137 = (state_15277[(13)]);
var inst_15141 = (state_15277[(14)]);
var inst_15147 = (state_15277[(15)]);
var inst_15138 = (state_15277[(9)]);
var inst_15136 = (state_15277[(16)]);
var inst_15152 = (state_15277[(17)]);
var inst_15221 = (state_15277[(10)]);
var inst_15177 = (state_15277[(8)]);
var inst_15223 = (function (){var obj_fn = inst_15221;
var t = inst_15140;
var temp__5733__auto__ = inst_15221;
var vec__15133 = inst_15136;
var p = inst_15138;
var idx_predicate_QMARK_ = inst_15141;
var o = inst_15177;
var tag_predicate_QMARK_ = inst_15147;
var s = inst_15137;
var o_coerce_QMARK_ = inst_15152;
return (function (x){
var and__4115__auto__ = obj_fn.call(null,x);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.call(null,x,o);
} else {
return and__4115__auto__;
}
});
})();
var state_15277__$1 = state_15277;
var statearr_15361_15440 = state_15277__$1;
(statearr_15361_15440[(2)] = inst_15223);

(statearr_15361_15440[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2879__auto__ = null;
var fluree$db$query$range$state_machine__2879__auto____0 = (function (){
var statearr_15362 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15362[(0)] = fluree$db$query$range$state_machine__2879__auto__);

(statearr_15362[(1)] = (1));

return statearr_15362;
});
var fluree$db$query$range$state_machine__2879__auto____1 = (function (state_15277){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_15277);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e15363){var ex__2882__auto__ = e15363;
var statearr_15364_15441 = state_15277;
(statearr_15364_15441[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_15277[(4)]))){
var statearr_15365_15442 = state_15277;
(statearr_15365_15442[(1)] = cljs.core.first.call(null,(state_15277[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15443 = state_15277;
state_15277 = G__15443;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2879__auto__ = function(state_15277){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2879__auto____1.call(this,state_15277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2879__auto____0;
fluree$db$query$range$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2879__auto____1;
return fluree$db$query$range$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_15366 = f__2902__auto__.call(null);
(statearr_15366[(6)] = c__2901__auto__);

return statearr_15366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__15445 = arguments.length;
switch (G__15445) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.call(null,db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_15480){
var state_val_15481 = (state_15480[(1)]);
if((state_val_15481 === (7))){
var inst_15467 = cljs.core.pr_str.call(null,name);
var inst_15468 = ["Invalid collection name: ",inst_15467].join('');
var inst_15469 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15470 = [(400),new cljs.core.Keyword("db","invalid-collection","db/invalid-collection",1742380218)];
var inst_15471 = cljs.core.PersistentHashMap.fromArrays(inst_15469,inst_15470);
var inst_15472 = cljs.core.ex_info.call(null,inst_15468,inst_15471);
var inst_15473 = (function(){throw inst_15472})();
var state_15480__$1 = state_15480;
var statearr_15482_15502 = state_15480__$1;
(statearr_15482_15502[(2)] = inst_15473);

(statearr_15482_15502[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15481 === (1))){
var state_15480__$1 = state_15480;
var statearr_15483_15503 = state_15480__$1;
(statearr_15483_15503[(2)] = null);

(statearr_15483_15503[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15481 === (4))){
var inst_15446 = (state_15480[(2)]);
var state_15480__$1 = state_15480;
var statearr_15484_15504 = state_15480__$1;
(statearr_15484_15504[(2)] = inst_15446);

(statearr_15484_15504[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15481 === (6))){
var inst_15452 = (state_15480[(7)]);
var inst_15454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15455 = fluree.db.flake.max_subject_id.call(null,inst_15452);
var inst_15456 = [inst_15455];
var inst_15457 = (new cljs.core.PersistentVector(null,1,(5),inst_15454,inst_15456,null));
var inst_15458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15459 = fluree.db.flake.min_subject_id.call(null,inst_15452);
var inst_15460 = [inst_15459];
var inst_15461 = (new cljs.core.PersistentVector(null,1,(5),inst_15458,inst_15460,null));
var inst_15462 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_15457,cljs.core._LT__EQ_,inst_15461,opts);
var state_15480__$1 = state_15480;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_15480__$1,(9),inst_15462);
} else {
if((state_val_15481 === (3))){
var inst_15478 = (state_15480[(2)]);
var state_15480__$1 = state_15480;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15480__$1,inst_15478);
} else {
if((state_val_15481 === (2))){
var inst_15452 = (state_15480[(7)]);
var _ = (function (){var statearr_15486 = state_15480;
(statearr_15486[(4)] = cljs.core.cons.call(null,(5),(state_15480[(4)])));

return statearr_15486;
})();
var inst_15452__$1 = fluree.db.dbproto._c_prop.call(null,db,new cljs.core.Keyword(null,"id","id",-1388402092),name);
var state_15480__$1 = (function (){var statearr_15487 = state_15480;
(statearr_15487[(7)] = inst_15452__$1);

return statearr_15487;
})();
if(cljs.core.truth_(inst_15452__$1)){
var statearr_15488_15505 = state_15480__$1;
(statearr_15488_15505[(1)] = (6));

} else {
var statearr_15489_15506 = state_15480__$1;
(statearr_15489_15506[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15481 === (9))){
var inst_15464 = (state_15480[(2)]);
var inst_15465 = fluree.db.util.async.throw_err.call(null,inst_15464);
var state_15480__$1 = state_15480;
var statearr_15490_15507 = state_15480__$1;
(statearr_15490_15507[(2)] = inst_15465);

(statearr_15490_15507[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15481 === (5))){
var _ = (function (){var statearr_15491 = state_15480;
(statearr_15491[(4)] = cljs.core.rest.call(null,(state_15480[(4)])));

return statearr_15491;
})();
var state_15480__$1 = state_15480;
var ex15485 = (state_15480__$1[(2)]);
var statearr_15492_15508 = state_15480__$1;
(statearr_15492_15508[(5)] = ex15485);


var statearr_15493_15509 = state_15480__$1;
(statearr_15493_15509[(1)] = (4));

(statearr_15493_15509[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15481 === (8))){
var inst_15475 = (state_15480[(2)]);
var _ = (function (){var statearr_15494 = state_15480;
(statearr_15494[(4)] = cljs.core.rest.call(null,(state_15480[(4)])));

return statearr_15494;
})();
var state_15480__$1 = state_15480;
var statearr_15495_15510 = state_15480__$1;
(statearr_15495_15510[(2)] = inst_15475);

(statearr_15495_15510[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__2879__auto__ = null;
var fluree$db$query$range$state_machine__2879__auto____0 = (function (){
var statearr_15496 = [null,null,null,null,null,null,null,null];
(statearr_15496[(0)] = fluree$db$query$range$state_machine__2879__auto__);

(statearr_15496[(1)] = (1));

return statearr_15496;
});
var fluree$db$query$range$state_machine__2879__auto____1 = (function (state_15480){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_15480);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e15497){var ex__2882__auto__ = e15497;
var statearr_15498_15511 = state_15480;
(statearr_15498_15511[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_15480[(4)]))){
var statearr_15499_15512 = state_15480;
(statearr_15499_15512[(1)] = cljs.core.first.call(null,(state_15480[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15513 = state_15480;
state_15480 = G__15513;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__2879__auto__ = function(state_15480){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__2879__auto____1.call(this,state_15480);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__2879__auto____0;
fluree$db$query$range$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__2879__auto____1;
return fluree$db$query$range$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_15500 = f__2902__auto__.call(null);
(statearr_15500[(6)] = c__2901__auto__);

return statearr_15500;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__15517 = flakes;
var vec__15518 = G__15517;
var seq__15519 = cljs.core.seq.call(null,vec__15518);
var first__15520 = cljs.core.first.call(null,seq__15519);
var seq__15519__$1 = cljs.core.next.call(null,seq__15519);
var flake_SINGLEQUOTE_ = first__15520;
var r = seq__15519__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15517__$1 = G__15517;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15527 = G__15517__$1;
var seq__15528 = cljs.core.seq.call(null,vec__15527);
var first__15529 = cljs.core.first.call(null,seq__15528);
var seq__15528__$1 = cljs.core.next.call(null,seq__15528);
var flake_SINGLEQUOTE___$1 = first__15529;
var r__$1 = seq__15528__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse.call(null,obj);
}catch (e15531){var e = e15531;
return null;
}})();
var map__15530 = cmd_map;
var map__15530__$1 = (((((!((map__15530 == null))))?(((((map__15530.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15530.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15530):map__15530);
var type = cljs.core.get.call(null,map__15530__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var db = cljs.core.get.call(null,map__15530__$1,new cljs.core.Keyword(null,"db","db",993250759));
var tx = cljs.core.get.call(null,map__15530__$1,new cljs.core.Keyword(null,"tx","tx",466630418));
var nonce = cljs.core.get.call(null,map__15530__$1,new cljs.core.Keyword(null,"nonce","nonce",564330331));
var auth = cljs.core.get.call(null,map__15530__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var expire = cljs.core.get.call(null,map__15530__$1,new cljs.core.Keyword(null,"expire","expire",-70657108));
var G__15533 = r__$1;
var G__15534 = ((cljs.core._EQ_.call(null,type,"tx"))?cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"tx","tx",466630418),tx,new cljs.core.Keyword(null,"nonce","nonce",564330331),nonce,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"expire","expire",-70657108),expire], null)):result_STAR___$2);
G__15517__$1 = G__15533;
result_STAR___$1 = G__15534;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__15543 = blocks;
var vec__15544 = G__15543;
var seq__15545 = cljs.core.seq.call(null,vec__15544);
var first__15546 = cljs.core.first.call(null,seq__15545);
var seq__15545__$1 = cljs.core.next.call(null,seq__15545);
var block_SINGLEQUOTE_ = first__15546;
var r = seq__15545__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__15543__$1 = G__15543;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__15552 = G__15543__$1;
var seq__15553 = cljs.core.seq.call(null,vec__15552);
var first__15554 = cljs.core.first.call(null,seq__15553);
var seq__15553__$1 = cljs.core.next.call(null,seq__15553);
var block_SINGLEQUOTE___$1 = first__15554;
var r__$1 = seq__15553__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__15555 = block_SINGLEQUOTE___$1;
var map__15555__$1 = (((((!((map__15555 == null))))?(((((map__15555.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15555.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15555):map__15555);
var block = cljs.core.get.call(null,map__15555__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__15555__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__15555__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var prev_hash = cljs.core.some.call(null,((function (G__15543__$1,result_STAR___$1,map__15555,map__15555__$1,block,t,flakes,vec__15552,seq__15553,first__15554,seq__15553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15543,vec__15544,seq__15545,first__15546,seq__15545__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15535_SHARP_){
if(cljs.core._EQ_.call(null,p1__15535_SHARP_.p,(2))){
return p1__15535_SHARP_.o;
} else {
return null;
}
});})(G__15543__$1,result_STAR___$1,map__15555,map__15555__$1,block,t,flakes,vec__15552,seq__15553,first__15554,seq__15553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15543,vec__15544,seq__15545,first__15546,seq__15545__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some.call(null,((function (G__15543__$1,result_STAR___$1,map__15555,map__15555__$1,block,t,flakes,prev_hash,vec__15552,seq__15553,first__15554,seq__15553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15543,vec__15544,seq__15545,first__15546,seq__15545__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15536_SHARP_){
if(cljs.core._EQ_.call(null,p1__15536_SHARP_.p,(1))){
return p1__15536_SHARP_.o;
} else {
return null;
}
});})(G__15543__$1,result_STAR___$1,map__15555,map__15555__$1,block,t,flakes,prev_hash,vec__15552,seq__15553,first__15554,seq__15553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15543,vec__15544,seq__15545,first__15546,seq__15545__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some.call(null,((function (G__15543__$1,result_STAR___$1,map__15555,map__15555__$1,block,t,flakes,prev_hash,hash,vec__15552,seq__15553,first__15554,seq__15553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15543,vec__15544,seq__15545,first__15546,seq__15545__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15537_SHARP_){
if(cljs.core._EQ_.call(null,p1__15537_SHARP_.p,(5))){
return p1__15537_SHARP_.o;
} else {
return null;
}
});})(G__15543__$1,result_STAR___$1,map__15555,map__15555__$1,block,t,flakes,prev_hash,hash,vec__15552,seq__15553,first__15554,seq__15553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15543,vec__15544,seq__15545,first__15546,seq__15545__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some.call(null,((function (G__15543__$1,result_STAR___$1,map__15555,map__15555__$1,block,t,flakes,prev_hash,hash,instant,vec__15552,seq__15553,first__15554,seq__15553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15543,vec__15544,seq__15545,first__15546,seq__15545__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15538_SHARP_){
if(cljs.core._EQ_.call(null,p1__15538_SHARP_.p,(7))){
return p1__15538_SHARP_.o;
} else {
return null;
}
});})(G__15543__$1,result_STAR___$1,map__15555,map__15555__$1,block,t,flakes,prev_hash,hash,instant,vec__15552,seq__15553,first__15554,seq__15553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15543,vec__15544,seq__15545,first__15546,seq__15545__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.call(null,((function (G__15543__$1,result_STAR___$1,map__15555,map__15555__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15552,seq__15553,first__15554,seq__15553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15543,vec__15544,seq__15545,first__15546,seq__15545__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__15539_SHARP_){
return cljs.core._EQ_.call(null,p1__15539_SHARP_.p,(106));
});})(G__15543__$1,result_STAR___$1,map__15555,map__15555__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__15552,seq__15553,first__15554,seq__15553__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__15543,vec__15544,seq__15545,first__15546,seq__15545__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes.call(null,txn_flakes);
var G__15557 = r__$1;
var G__15558 = cljs.core.conj.call(null,result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"prev-hash","prev-hash",209337330),prev_hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"sigs","sigs",-1653119622),sigs,new cljs.core.Keyword(null,"flakes","flakes",1977895739),flakes,new cljs.core.Keyword(null,"txn","txn",-469204789),txn_flakes_SINGLEQUOTE_], null));
G__15543__$1 = G__15557;
result_STAR___$1 = G__15558;
continue;
}
break;
}
});
