// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.call(null,cljs.core.re_find.call(null,/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_18602){
var state_val_18603 = (state_18602[(1)]);
if((state_val_18603 === (1))){
var state_18602__$1 = state_18602;
var statearr_18604_18618 = state_18602__$1;
(statearr_18604_18618[(2)] = null);

(statearr_18604_18618[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18603 === (2))){
var _ = (function (){var statearr_18605 = state_18602;
(statearr_18605[(4)] = cljs.core.cons.call(null,(5),(state_18602[(4)])));

return statearr_18605;
})();
var inst_18593 = fluree.db.dbproto._tag.call(null,db,type_tag_sid,"_predicate/type");
var state_18602__$1 = state_18602;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18602__$1,(6),inst_18593);
} else {
if((state_val_18603 === (3))){
var inst_18600 = (state_18602[(2)]);
var state_18602__$1 = state_18602;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18602__$1,inst_18600);
} else {
if((state_val_18603 === (4))){
var inst_18587 = (state_18602[(2)]);
var state_18602__$1 = state_18602;
var statearr_18607_18619 = state_18602__$1;
(statearr_18607_18619[(2)] = inst_18587);

(statearr_18607_18619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18603 === (5))){
var _ = (function (){var statearr_18608 = state_18602;
(statearr_18608[(4)] = cljs.core.rest.call(null,(state_18602[(4)])));

return statearr_18608;
})();
var state_18602__$1 = state_18602;
var ex18606 = (state_18602__$1[(2)]);
var statearr_18609_18620 = state_18602__$1;
(statearr_18609_18620[(5)] = ex18606);


if((ex18606 instanceof Error)){
var statearr_18610_18621 = state_18602__$1;
(statearr_18610_18621[(1)] = (4));

(statearr_18610_18621[(5)] = null);

} else {
throw ex18606;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18603 === (6))){
var inst_18595 = (state_18602[(2)]);
var inst_18596 = fluree.db.util.async.throw_err.call(null,inst_18595);
var inst_18597 = cljs.core.keyword.call(null,inst_18596);
var _ = (function (){var statearr_18611 = state_18602;
(statearr_18611[(4)] = cljs.core.rest.call(null,(state_18602[(4)])));

return statearr_18611;
})();
var state_18602__$1 = state_18602;
var statearr_18612_18622 = state_18602__$1;
(statearr_18612_18622[(2)] = inst_18597);

(statearr_18612_18622[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto____0 = (function (){
var statearr_18613 = [null,null,null,null,null,null,null];
(statearr_18613[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto__);

(statearr_18613[(1)] = (1));

return statearr_18613;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto____1 = (function (state_18602){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_18602);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e18614){var ex__2882__auto__ = e18614;
var statearr_18615_18623 = state_18602;
(statearr_18615_18623[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_18602[(4)]))){
var statearr_18616_18624 = state_18602;
(statearr_18616_18624[(1)] = cljs.core.first.call(null,(state_18602[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18625 = state_18602;
state_18602 = G__18625;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto__ = function(state_18602){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto____1.call(this,state_18602);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_18617 = f__2902__auto__.call(null);
(statearr_18617[(6)] = c__2901__auto__);

return statearr_18617;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_18657){
var state_val_18658 = (state_18657[(1)]);
if((state_val_18658 === (7))){
var inst_18641 = (state_18657[(7)]);
var inst_18643 = cljs.core.empty_QMARK_.call(null,inst_18641);
var inst_18644 = (!(inst_18643));
var state_18657__$1 = state_18657;
var statearr_18659_18683 = state_18657__$1;
(statearr_18659_18683[(2)] = inst_18644);

(statearr_18659_18683[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18658 === (1))){
var state_18657__$1 = state_18657;
var statearr_18660_18684 = state_18657__$1;
(statearr_18660_18684[(2)] = null);

(statearr_18660_18684[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18658 === (4))){
var inst_18627 = (state_18657[(2)]);
var state_18657__$1 = state_18657;
var statearr_18661_18685 = state_18657__$1;
(statearr_18661_18685[(2)] = inst_18627);

(statearr_18661_18685[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18658 === (6))){
var inst_18641 = (state_18657[(7)]);
var inst_18633 = (state_18657[(8)]);
var inst_18639 = (state_18657[(2)]);
var inst_18640 = fluree.db.util.async.throw_err.call(null,inst_18639);
var inst_18641__$1 = cljs.core.map.call(null,inst_18633,inst_18640);
var state_18657__$1 = (function (){var statearr_18662 = state_18657;
(statearr_18662[(7)] = inst_18641__$1);

return statearr_18662;
})();
if(cljs.core.truth_(inst_18641__$1)){
var statearr_18663_18686 = state_18657__$1;
(statearr_18663_18686[(1)] = (7));

} else {
var statearr_18664_18687 = state_18657__$1;
(statearr_18664_18687[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18658 === (3))){
var inst_18655 = (state_18657[(2)]);
var state_18657__$1 = state_18657;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18657__$1,inst_18655);
} else {
if((state_val_18658 === (12))){
var inst_18652 = (state_18657[(2)]);
var _ = (function (){var statearr_18665 = state_18657;
(statearr_18665[(4)] = cljs.core.rest.call(null,(state_18657[(4)])));

return statearr_18665;
})();
var state_18657__$1 = state_18657;
var statearr_18666_18688 = state_18657__$1;
(statearr_18666_18688[(2)] = inst_18652);

(statearr_18666_18688[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18658 === (2))){
var _ = (function (){var statearr_18667 = state_18657;
(statearr_18667[(4)] = cljs.core.cons.call(null,(5),(state_18657[(4)])));

return statearr_18667;
})();
var inst_18633 = (function (){return (function (p1__18626_SHARP_){
return p1__18626_SHARP_.o;
});
})();
var inst_18634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18635 = [pred_id];
var inst_18636 = (new cljs.core.PersistentVector(null,1,(5),inst_18634,inst_18635,null));
var inst_18637 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"psot","psot",2111653059),cljs.core._EQ_,inst_18636);
var state_18657__$1 = (function (){var statearr_18668 = state_18657;
(statearr_18668[(8)] = inst_18633);

return statearr_18668;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18657__$1,(6),inst_18637);
} else {
if((state_val_18658 === (11))){
var state_18657__$1 = state_18657;
var statearr_18670_18689 = state_18657__$1;
(statearr_18670_18689[(2)] = true);

(statearr_18670_18689[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18658 === (9))){
var inst_18647 = (state_18657[(2)]);
var state_18657__$1 = state_18657;
if(cljs.core.truth_(inst_18647)){
var statearr_18671_18690 = state_18657__$1;
(statearr_18671_18690[(1)] = (10));

} else {
var statearr_18672_18691 = state_18657__$1;
(statearr_18672_18691[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18658 === (5))){
var _ = (function (){var statearr_18673 = state_18657;
(statearr_18673[(4)] = cljs.core.rest.call(null,(state_18657[(4)])));

return statearr_18673;
})();
var state_18657__$1 = state_18657;
var ex18669 = (state_18657__$1[(2)]);
var statearr_18674_18692 = state_18657__$1;
(statearr_18674_18692[(5)] = ex18669);


if((ex18669 instanceof Error)){
var statearr_18675_18693 = state_18657__$1;
(statearr_18675_18693[(1)] = (4));

(statearr_18675_18693[(5)] = null);

} else {
throw ex18669;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18658 === (10))){
var inst_18641 = (state_18657[(7)]);
var inst_18649 = cljs.core.apply.call(null,cljs.core.distinct_QMARK_,inst_18641);
var state_18657__$1 = state_18657;
var statearr_18676_18694 = state_18657__$1;
(statearr_18676_18694[(2)] = inst_18649);

(statearr_18676_18694[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18658 === (8))){
var inst_18641 = (state_18657[(7)]);
var state_18657__$1 = state_18657;
var statearr_18677_18695 = state_18657__$1;
(statearr_18677_18695[(2)] = inst_18641);

(statearr_18677_18695[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto____0 = (function (){
var statearr_18678 = [null,null,null,null,null,null,null,null,null];
(statearr_18678[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto__);

(statearr_18678[(1)] = (1));

return statearr_18678;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto____1 = (function (state_18657){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_18657);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e18679){var ex__2882__auto__ = e18679;
var statearr_18680_18696 = state_18657;
(statearr_18680_18696[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_18657[(4)]))){
var statearr_18681_18697 = state_18657;
(statearr_18681_18697[(1)] = cljs.core.first.call(null,(state_18657[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18698 = state_18657;
state_18657 = G__18698;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto__ = function(state_18657){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto____1.call(this,state_18657);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_18682 = f__2902__auto__.call(null);
(statearr_18682[(6)] = c__2901__auto__);

return statearr_18682;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_18775){
var state_val_18776 = (state_18775[(1)]);
if((state_val_18776 === (7))){
var inst_18770 = (state_18775[(2)]);
var _ = (function (){var statearr_18777 = state_18775;
(statearr_18777[(4)] = cljs.core.rest.call(null,(state_18775[(4)])));

return statearr_18777;
})();
var state_18775__$1 = state_18775;
var statearr_18778_18810 = state_18775__$1;
(statearr_18778_18810[(2)] = inst_18770);

(statearr_18778_18810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18776 === (1))){
var state_18775__$1 = state_18775;
var statearr_18779_18811 = state_18775__$1;
(statearr_18779_18811[(2)] = null);

(statearr_18779_18811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18776 === (4))){
var inst_18701 = (state_18775[(2)]);
var state_18775__$1 = state_18775;
var statearr_18780_18812 = state_18775__$1;
(statearr_18780_18812[(2)] = inst_18701);

(statearr_18780_18812[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18776 === (15))){
var inst_18731 = (state_18775[(7)]);
var inst_18751 = (state_18775[(8)]);
var inst_18738 = (state_18775[(9)]);
var inst_18725 = (state_18775[(10)]);
var inst_18753 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18754 = inst_18731.s;
var inst_18755 = [inst_18754,inst_18738,new cljs.core.Keyword(null,"old","old",-1825222690)];
var inst_18756 = (new cljs.core.PersistentVector(null,3,(5),inst_18753,inst_18755,null));
var inst_18757 = cljs.core.assoc_in.call(null,inst_18725,inst_18756,inst_18751);
var state_18775__$1 = state_18775;
var statearr_18781_18813 = state_18775__$1;
(statearr_18781_18813[(2)] = inst_18757);

(statearr_18781_18813[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18776 === (13))){
var inst_18740 = (state_18775[(11)]);
var inst_18751 = (state_18775[(2)]);
var state_18775__$1 = (function (){var statearr_18782 = state_18775;
(statearr_18782[(8)] = inst_18751);

return statearr_18782;
})();
if(cljs.core.truth_(inst_18740)){
var statearr_18783_18814 = state_18775__$1;
(statearr_18783_18814[(1)] = (15));

} else {
var statearr_18784_18815 = state_18775__$1;
(statearr_18784_18815[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18776 === (6))){
var inst_18731 = (state_18775[(7)]);
var inst_18724 = (state_18775[(12)]);
var inst_18730 = cljs.core.seq.call(null,inst_18724);
var inst_18731__$1 = cljs.core.first.call(null,inst_18730);
var inst_18732 = cljs.core.next.call(null,inst_18730);
var inst_18733 = cljs.core.not.call(null,inst_18731__$1);
var state_18775__$1 = (function (){var statearr_18785 = state_18775;
(statearr_18785[(7)] = inst_18731__$1);

(statearr_18785[(13)] = inst_18732);

return statearr_18785;
})();
if(inst_18733){
var statearr_18786_18816 = state_18775__$1;
(statearr_18786_18816[(1)] = (8));

} else {
var statearr_18787_18817 = state_18775__$1;
(statearr_18787_18817[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18776 === (17))){
var inst_18732 = (state_18775[(13)]);
var inst_18765 = (state_18775[(2)]);
var inst_18724 = inst_18732;
var inst_18725 = inst_18765;
var state_18775__$1 = (function (){var statearr_18788 = state_18775;
(statearr_18788[(12)] = inst_18724);

(statearr_18788[(10)] = inst_18725);

return statearr_18788;
})();
var statearr_18789_18818 = state_18775__$1;
(statearr_18789_18818[(2)] = null);

(statearr_18789_18818[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18776 === (3))){
var inst_18773 = (state_18775[(2)]);
var state_18775__$1 = state_18775;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18775__$1,inst_18773);
} else {
if((state_val_18776 === (12))){
var inst_18731 = (state_18775[(7)]);
var inst_18749 = inst_18731.o;
var state_18775__$1 = state_18775;
var statearr_18790_18819 = state_18775__$1;
(statearr_18790_18819[(2)] = inst_18749);

(statearr_18790_18819[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18776 === (2))){
var _ = (function (){var statearr_18791 = state_18775;
(statearr_18791[(4)] = cljs.core.cons.call(null,(5),(state_18775[(4)])));

return statearr_18791;
})();
var inst_18707 = cljs.core.filter.call(null,fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var inst_18708 = cljs.core.PersistentHashSet.EMPTY;
var inst_18709 = cljs.core.vals.call(null,tempids);
var inst_18710 = cljs.core.into.call(null,inst_18708,inst_18709);
var inst_18711 = (function (){var pred_flakes = inst_18707;
var is_new_QMARK_ = inst_18710;
return (function (p1__18699_SHARP_,p2__18700_SHARP_){
return cljs.core.assoc_in.call(null,p1__18699_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2__18700_SHARP_.s,new cljs.core.Keyword(null,"new?","new?",777958557)], null),cljs.core.boolean$.call(null,is_new_QMARK_.call(null,p2__18700_SHARP_.s)));
});
})();
var inst_18712 = cljs.core.PersistentHashMap.EMPTY;
var inst_18713 = cljs.core.reduce.call(null,inst_18711,inst_18712,inst_18707);
var inst_18721 = cljs.core.seq.call(null,inst_18707);
var inst_18722 = cljs.core.first.call(null,inst_18721);
var inst_18723 = cljs.core.next.call(null,inst_18721);
var inst_18724 = inst_18707;
var inst_18725 = inst_18713;
var state_18775__$1 = (function (){var statearr_18792 = state_18775;
(statearr_18792[(14)] = inst_18722);

(statearr_18792[(15)] = inst_18723);

(statearr_18792[(12)] = inst_18724);

(statearr_18792[(10)] = inst_18725);

return statearr_18792;
})();
var statearr_18793_18820 = state_18775__$1;
(statearr_18793_18820[(2)] = null);

(statearr_18793_18820[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18776 === (11))){
var inst_18731 = (state_18775[(7)]);
var inst_18743 = inst_18731.o;
var inst_18744 = fluree.db.query.schema.convert_type_to_kw.call(null,inst_18743,db);
var state_18775__$1 = state_18775;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18775__$1,(14),inst_18744);
} else {
if((state_val_18776 === (9))){
var inst_18731 = (state_18775[(7)]);
var inst_18738 = (state_18775[(9)]);
var inst_18736 = inst_18731.p;
var inst_18737 = fluree.db.dbproto._p_prop.call(null,db,new cljs.core.Keyword(null,"name","name",1843675177),inst_18736);
var inst_18738__$1 = fluree.db.query.schema.pred_name__GT_keyword.call(null,inst_18737);
var inst_18739 = inst_18731.op;
var inst_18740 = inst_18739 === false;
var inst_18741 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348),inst_18738__$1);
var state_18775__$1 = (function (){var statearr_18795 = state_18775;
(statearr_18795[(9)] = inst_18738__$1);

(statearr_18795[(11)] = inst_18740);

return statearr_18795;
})();
if(inst_18741){
var statearr_18796_18821 = state_18775__$1;
(statearr_18796_18821[(1)] = (11));

} else {
var statearr_18797_18822 = state_18775__$1;
(statearr_18797_18822[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18776 === (5))){
var _ = (function (){var statearr_18798 = state_18775;
(statearr_18798[(4)] = cljs.core.rest.call(null,(state_18775[(4)])));

return statearr_18798;
})();
var state_18775__$1 = state_18775;
var ex18794 = (state_18775__$1[(2)]);
var statearr_18799_18823 = state_18775__$1;
(statearr_18799_18823[(5)] = ex18794);


if((ex18794 instanceof Error)){
var statearr_18800_18824 = state_18775__$1;
(statearr_18800_18824[(1)] = (4));

(statearr_18800_18824[(5)] = null);

} else {
throw ex18794;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18776 === (14))){
var inst_18746 = (state_18775[(2)]);
var inst_18747 = fluree.db.util.async.throw_err.call(null,inst_18746);
var state_18775__$1 = state_18775;
var statearr_18801_18825 = state_18775__$1;
(statearr_18801_18825[(2)] = inst_18747);

(statearr_18801_18825[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18776 === (16))){
var inst_18731 = (state_18775[(7)]);
var inst_18751 = (state_18775[(8)]);
var inst_18738 = (state_18775[(9)]);
var inst_18725 = (state_18775[(10)]);
var inst_18759 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_18760 = inst_18731.s;
var inst_18761 = [inst_18760,inst_18738,new cljs.core.Keyword(null,"new","new",-2085437848)];
var inst_18762 = (new cljs.core.PersistentVector(null,3,(5),inst_18759,inst_18761,null));
var inst_18763 = cljs.core.assoc_in.call(null,inst_18725,inst_18762,inst_18751);
var state_18775__$1 = state_18775;
var statearr_18802_18826 = state_18775__$1;
(statearr_18802_18826[(2)] = inst_18763);

(statearr_18802_18826[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18776 === (10))){
var inst_18768 = (state_18775[(2)]);
var state_18775__$1 = state_18775;
var statearr_18803_18827 = state_18775__$1;
(statearr_18803_18827[(2)] = inst_18768);

(statearr_18803_18827[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18776 === (8))){
var inst_18725 = (state_18775[(10)]);
var state_18775__$1 = state_18775;
var statearr_18804_18828 = state_18775__$1;
(statearr_18804_18828[(2)] = inst_18725);

(statearr_18804_18828[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto____0 = (function (){
var statearr_18805 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18805[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto__);

(statearr_18805[(1)] = (1));

return statearr_18805;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto____1 = (function (state_18775){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_18775);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e18806){var ex__2882__auto__ = e18806;
var statearr_18807_18829 = state_18775;
(statearr_18807_18829[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_18775[(4)]))){
var statearr_18808_18830 = state_18775;
(statearr_18808_18830[(1)] = cljs.core.first.call(null,(state_18775[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18831 = state_18775;
state_18775 = G__18831;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto__ = function(state_18775){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto____1.call(this,state_18775);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_18809 = f__2902__auto__.call(null);
(statearr_18809[(6)] = c__2901__auto__);

return statearr_18809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__18833 = arguments.length;
switch (G__18833) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.call(null,null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name.call(null,current_type)," to ",cljs.core.name.call(null,new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,message,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__18836 = arguments.length;
switch (G__18836) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.call(null,pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_19145){
var state_val_19146 = (state_19145[(1)]);
if((state_val_19146 === (65))){
var inst_19098 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19147_19319 = state_19145__$1;
(statearr_19147_19319[(2)] = inst_19098);

(statearr_19147_19319[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (70))){
var inst_19007 = (state_19145[(7)]);
var inst_19008 = (state_19145[(8)]);
var inst_19020 = [new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_19021 = inst_19008.call(null,cljs.core.PersistentArrayMap,null,2,inst_19020,null);
var inst_19022 = inst_19008.call(null,cljs.core.PersistentHashSet,null,inst_19021,null);
var inst_19023 = inst_19022.call(null,inst_19007);
var state_19145__$1 = state_19145;
if(cljs.core.truth_(inst_19023)){
var statearr_19148_19320 = state_19145__$1;
(statearr_19148_19320[(1)] = (71));

} else {
var statearr_19149_19321 = state_19145__$1;
(statearr_19149_19321[(1)] = (72));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (62))){
var inst_19100 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19150_19322 = state_19145__$1;
(statearr_19150_19322[(2)] = inst_19100);

(statearr_19150_19322[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (74))){
var inst_19007 = (state_19145[(7)]);
var inst_19008 = (state_19145[(8)]);
var inst_19030 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"instant","instant",655498374),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_19031 = inst_19008.call(null,cljs.core.PersistentArrayMap,null,3,inst_19030,null);
var inst_19032 = inst_19008.call(null,cljs.core.PersistentHashSet,null,inst_19031,null);
var inst_19033 = inst_19032.call(null,inst_19007);
var state_19145__$1 = state_19145;
if(cljs.core.truth_(inst_19033)){
var statearr_19151_19323 = state_19145__$1;
(statearr_19151_19323[(1)] = (75));

} else {
var statearr_19152_19324 = state_19145__$1;
(statearr_19152_19324[(1)] = (76));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (110))){
var inst_19132 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19153_19325 = state_19145__$1;
(statearr_19153_19325[(2)] = inst_19132);

(statearr_19153_19325[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (7))){
var inst_19140 = (state_19145[(2)]);
var _ = (function (){var statearr_19154 = state_19145;
(statearr_19154[(4)] = cljs.core.rest.call(null,(state_19145[(4)])));

return statearr_19154;
})();
var state_19145__$1 = state_19145;
var statearr_19155_19326 = state_19145__$1;
(statearr_19155_19326[(2)] = inst_19140);

(statearr_19155_19326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (59))){
var inst_19007 = (state_19145[(7)]);
var inst_19008 = (state_19145[(8)]);
var inst_19006 = (state_19145[(2)]);
var inst_19007__$1 = cljs.core.get.call(null,inst_19006,new cljs.core.Keyword(null,"old","old",-1825222690));
var inst_19008__$1 = cljs.core.get.call(null,inst_19006,new cljs.core.Keyword(null,"new","new",-2085437848));
var inst_19009 = cljs.core._EQ_.call(null,inst_19008__$1,inst_19007__$1);
var state_19145__$1 = (function (){var statearr_19156 = state_19145;
(statearr_19156[(7)] = inst_19007__$1);

(statearr_19156[(8)] = inst_19008__$1);

return statearr_19156;
})();
if(inst_19009){
var statearr_19157_19327 = state_19145__$1;
(statearr_19157_19327[(1)] = (60));

} else {
var statearr_19158_19328 = state_19145__$1;
(statearr_19158_19328[(1)] = (61));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (86))){
var inst_19007 = (state_19145[(7)]);
var inst_19008 = (state_19145[(8)]);
var inst_19060 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"double","double",884886883),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_19061 = inst_19008.call(null,cljs.core.PersistentArrayMap,null,5,inst_19060,null);
var inst_19062 = inst_19008.call(null,cljs.core.PersistentHashSet,null,inst_19061,null);
var inst_19063 = inst_19062.call(null,inst_19007);
var state_19145__$1 = state_19145;
if(cljs.core.truth_(inst_19063)){
var statearr_19159_19329 = state_19145__$1;
(statearr_19159_19329[(1)] = (87));

} else {
var statearr_19160_19330 = state_19145__$1;
(statearr_19160_19330[(1)] = (88));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (20))){
var inst_18876 = (state_19145[(9)]);
var inst_18901 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_18876);
var inst_18902 = inst_18901 === true;
var inst_18903 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18876);
var inst_18904 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18903);
var inst_18905 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"boolean","boolean",-1919418404),inst_18904);
var inst_18906 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_18876);
var inst_18907 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18906);
var inst_18908 = inst_18907 === true;
var inst_18909 = ((inst_18902) && (inst_18905) && (inst_18908));
var state_19145__$1 = state_19145;
var statearr_19161_19331 = state_19145__$1;
(statearr_19161_19331[(2)] = inst_18909);

(statearr_19161_19331[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (72))){
var inst_19007 = (state_19145[(7)]);
var inst_19008 = (state_19145[(8)]);
var inst_19026 = fluree.db.query.schema.type_error.call(null,inst_19007,inst_19008,throw_QMARK_);
var state_19145__$1 = state_19145;
var statearr_19162_19332 = state_19145__$1;
(statearr_19162_19332[(2)] = inst_19026);

(statearr_19162_19332[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (58))){
var inst_18985 = (state_19145[(10)]);
var state_19145__$1 = state_19145;
var statearr_19163_19333 = state_19145__$1;
(statearr_19163_19333[(2)] = inst_18985);

(statearr_19163_19333[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (60))){
var inst_18975 = (state_19145[(11)]);
var state_19145__$1 = state_19145;
var statearr_19164_19334 = state_19145__$1;
(statearr_19164_19334[(2)] = inst_18975);

(statearr_19164_19334[(1)] = (62));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (27))){
var inst_18896 = (state_19145[(12)]);
var state_19145__$1 = state_19145;
var statearr_19165_19335 = state_19145__$1;
(statearr_19165_19335[(2)] = inst_18896);

(statearr_19165_19335[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (1))){
var state_19145__$1 = state_19145;
var statearr_19166_19336 = state_19145__$1;
(statearr_19166_19336[(2)] = null);

(statearr_19166_19336[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (69))){
var inst_19093 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19167_19337 = state_19145__$1;
(statearr_19167_19337[(2)] = inst_19093);

(statearr_19167_19337[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (101))){
var inst_19122 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
if(cljs.core.truth_(inst_19122)){
var statearr_19168_19338 = state_19145__$1;
(statearr_19168_19338[(1)] = (105));

} else {
var statearr_19169_19339 = state_19145__$1;
(statearr_19169_19339[(1)] = (106));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (24))){
var inst_18896 = (state_19145[(12)]);
var state_19145__$1 = state_19145;
var statearr_19170_19340 = state_19145__$1;
(statearr_19170_19340[(2)] = inst_18896);

(statearr_19170_19340[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (102))){
var inst_18876 = (state_19145[(9)]);
var inst_19109 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_18876);
var inst_19110 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_19109);
var inst_19111 = inst_19110 === true;
var inst_19112 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18876);
var inst_19113 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_19112);
var inst_19114 = cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"ref","ref",1289896967),inst_19113);
var inst_19115 = (!(inst_19114));
var inst_19116 = ((inst_19111) && (inst_19115));
var state_19145__$1 = state_19145;
var statearr_19171_19341 = state_19145__$1;
(statearr_19171_19341[(2)] = inst_19116);

(statearr_19171_19341[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (55))){
var state_19145__$1 = state_19145;
var statearr_19172_19342 = state_19145__$1;
(statearr_19172_19342[(2)] = false);

(statearr_19172_19342[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (85))){
var inst_19058 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19173_19343 = state_19145__$1;
(statearr_19173_19343[(2)] = inst_19058);

(statearr_19173_19343[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (39))){
var state_19145__$1 = state_19145;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_19174_19344 = state_19145__$1;
(statearr_19174_19344[(1)] = (42));

} else {
var statearr_19175_19345 = state_19145__$1;
(statearr_19175_19345[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (88))){
var inst_19007 = (state_19145[(7)]);
var inst_19008 = (state_19145[(8)]);
var inst_19066 = fluree.db.query.schema.type_error.call(null,inst_19007,inst_19008,throw_QMARK_);
var state_19145__$1 = state_19145;
var statearr_19176_19346 = state_19145__$1;
(statearr_19176_19346[(2)] = inst_19066);

(statearr_19176_19346[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (46))){
var inst_18976 = (state_19145[(13)]);
var state_19145__$1 = state_19145;
var statearr_19177_19347 = state_19145__$1;
(statearr_19177_19347[(2)] = inst_18976);

(statearr_19177_19347[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (4))){
var inst_18837 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19178_19348 = state_19145__$1;
(statearr_19178_19348[(2)] = inst_18837);

(statearr_19178_19348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (77))){
var inst_19038 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19179_19349 = state_19145__$1;
(statearr_19179_19349[(2)] = inst_19038);

(statearr_19179_19349[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (106))){
var inst_19103 = (state_19145[(14)]);
var state_19145__$1 = state_19145;
var statearr_19180_19350 = state_19145__$1;
(statearr_19180_19350[(2)] = inst_19103);

(statearr_19180_19350[(1)] = (107));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (95))){
var inst_18975 = (state_19145[(11)]);
var state_19145__$1 = state_19145;
var statearr_19181_19351 = state_19145__$1;
(statearr_19181_19351[(2)] = inst_18975);

(statearr_19181_19351[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (54))){
var state_19145__$1 = state_19145;
var statearr_19182_19352 = state_19145__$1;
(statearr_19182_19352[(2)] = true);

(statearr_19182_19352[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (92))){
var inst_19007 = (state_19145[(7)]);
var inst_19008 = (state_19145[(8)]);
var inst_19076 = fluree.db.query.schema.type_error.call(null,inst_19007,inst_19008,throw_QMARK_);
var state_19145__$1 = state_19145;
var statearr_19183_19353 = state_19145__$1;
(statearr_19183_19353[(2)] = inst_19076);

(statearr_19183_19353[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (104))){
var inst_19119 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19184_19354 = state_19145__$1;
(statearr_19184_19354[(2)] = inst_19119);

(statearr_19184_19354[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (15))){
var inst_18864 = (state_19145[(15)]);
var state_19145__$1 = state_19145;
var statearr_19185_19355 = state_19145__$1;
(statearr_19185_19355[(2)] = inst_18864);

(statearr_19185_19355[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (48))){
var inst_18985 = (state_19145[(10)]);
var inst_18876 = (state_19145[(9)]);
var inst_18985__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18876);
var inst_18987 = (inst_18985__$1 == null);
var inst_18988 = cljs.core.not.call(null,inst_18987);
var state_19145__$1 = (function (){var statearr_19186 = state_19145;
(statearr_19186[(10)] = inst_18985__$1);

return statearr_19186;
})();
if(inst_18988){
var statearr_19187_19356 = state_19145__$1;
(statearr_19187_19356[(1)] = (51));

} else {
var statearr_19188_19357 = state_19145__$1;
(statearr_19188_19357[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (50))){
var inst_18876 = (state_19145[(9)]);
var inst_19103 = (state_19145[(2)]);
var inst_19104 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_18876);
var inst_19105 = inst_19104 === true;
var state_19145__$1 = (function (){var statearr_19189 = state_19145;
(statearr_19189[(14)] = inst_19103);

return statearr_19189;
})();
if(cljs.core.truth_(inst_19105)){
var statearr_19190_19358 = state_19145__$1;
(statearr_19190_19358[(1)] = (99));

} else {
var statearr_19191_19359 = state_19145__$1;
(statearr_19191_19359[(1)] = (100));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (75))){
var inst_18975 = (state_19145[(11)]);
var state_19145__$1 = state_19145;
var statearr_19192_19360 = state_19145__$1;
(statearr_19192_19360[(2)] = inst_18975);

(statearr_19192_19360[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (99))){
var inst_19107 = (state_19145[(16)]);
var inst_18876 = (state_19145[(9)]);
var inst_19107__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_18876);
var state_19145__$1 = (function (){var statearr_19193 = state_19145;
(statearr_19193[(16)] = inst_19107__$1);

return statearr_19193;
})();
if(cljs.core.truth_(inst_19107__$1)){
var statearr_19194_19361 = state_19145__$1;
(statearr_19194_19361[(1)] = (102));

} else {
var statearr_19195_19362 = state_19145__$1;
(statearr_19195_19362[(1)] = (103));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (21))){
var inst_18899 = (state_19145[(17)]);
var state_19145__$1 = state_19145;
var statearr_19196_19363 = state_19145__$1;
(statearr_19196_19363[(2)] = inst_18899);

(statearr_19196_19363[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (31))){
var inst_18939 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
if(cljs.core.truth_(inst_18939)){
var statearr_19197_19364 = state_19145__$1;
(statearr_19197_19364[(1)] = (32));

} else {
var statearr_19198_19365 = state_19145__$1;
(statearr_19198_19365[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (32))){
var inst_18928 = (state_19145[(18)]);
var inst_18941 = fluree.db.query.schema.type_error.call(null,inst_18928,"a component","a non-component",throw_QMARK_);
var state_19145__$1 = state_19145;
var statearr_19199_19366 = state_19145__$1;
(statearr_19199_19366[(2)] = inst_18941);

(statearr_19199_19366[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (40))){
var inst_18944 = (state_19145[(19)]);
var state_19145__$1 = state_19145;
var statearr_19200_19367 = state_19145__$1;
(statearr_19200_19367[(2)] = inst_18944);

(statearr_19200_19367[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (91))){
var inst_18975 = (state_19145[(11)]);
var state_19145__$1 = state_19145;
var statearr_19201_19368 = state_19145__$1;
(statearr_19201_19368[(2)] = inst_18975);

(statearr_19201_19368[(1)] = (93));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (108))){
var inst_19125 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19126 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_19127 = cljs.core.PersistentHashMap.fromArrays(inst_19125,inst_19126);
var inst_19128 = cljs.core.ex_info.call(null,"A component _predicate must be of type \"ref.\"",inst_19127);
var inst_19129 = (function(){throw inst_19128})();
var state_19145__$1 = state_19145;
var statearr_19202_19369 = state_19145__$1;
(statearr_19202_19369[(2)] = inst_19129);

(statearr_19202_19369[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (56))){
var inst_18998 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19203_19370 = state_19145__$1;
(statearr_19203_19370[(2)] = inst_18998);

(statearr_19203_19370[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (33))){
var inst_18928 = (state_19145[(18)]);
var state_19145__$1 = state_19145;
var statearr_19204_19371 = state_19145__$1;
(statearr_19204_19371[(2)] = inst_18928);

(statearr_19204_19371[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (13))){
var inst_18891 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
if(cljs.core.truth_(inst_18891)){
var statearr_19205_19372 = state_19145__$1;
(statearr_19205_19372[(1)] = (14));

} else {
var statearr_19206_19373 = state_19145__$1;
(statearr_19206_19373[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (22))){
var inst_18912 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19207_19374 = state_19145__$1;
(statearr_19207_19374[(2)] = inst_18912);

(statearr_19207_19374[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (90))){
var inst_19007 = (state_19145[(7)]);
var inst_19008 = (state_19145[(8)]);
var inst_19070 = [new cljs.core.Keyword(null,"geojson","geojson",-719473398),null,new cljs.core.Keyword(null,"bytes","bytes",1175866680),null,new cljs.core.Keyword(null,"uri","uri",-774711847),null,new cljs.core.Keyword(null,"uuid","uuid",-2145095719),null,new cljs.core.Keyword(null,"json","json",1279968570),null];
var inst_19071 = inst_19008.call(null,cljs.core.PersistentArrayMap,null,5,inst_19070,null);
var inst_19072 = inst_19008.call(null,cljs.core.PersistentHashSet,null,inst_19071,null);
var inst_19073 = inst_19072.call(null,inst_19007);
var state_19145__$1 = state_19145;
if(cljs.core.truth_(inst_19073)){
var statearr_19208_19375 = state_19145__$1;
(statearr_19208_19375[(1)] = (91));

} else {
var statearr_19209_19376 = state_19145__$1;
(statearr_19209_19376[(1)] = (92));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (109))){
var inst_19103 = (state_19145[(14)]);
var state_19145__$1 = state_19145;
var statearr_19210_19377 = state_19145__$1;
(statearr_19210_19377[(2)] = inst_19103);

(statearr_19210_19377[(1)] = (110));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (36))){
var inst_18945 = (state_19145[(20)]);
var state_19145__$1 = state_19145;
var statearr_19211_19378 = state_19145__$1;
(statearr_19211_19378[(2)] = inst_18945);

(statearr_19211_19378[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (41))){
var inst_18976 = (state_19145[(13)]);
var inst_18876 = (state_19145[(9)]);
var inst_18975 = (state_19145[(2)]);
var inst_18976__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18876);
var state_19145__$1 = (function (){var statearr_19212 = state_19145;
(statearr_19212[(13)] = inst_18976__$1);

(statearr_19212[(11)] = inst_18975);

return statearr_19212;
})();
if(cljs.core.truth_(inst_18976__$1)){
var statearr_19213_19379 = state_19145__$1;
(statearr_19213_19379[(1)] = (45));

} else {
var statearr_19214_19380 = state_19145__$1;
(statearr_19214_19380[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (89))){
var inst_19068 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19215_19381 = state_19145__$1;
(statearr_19215_19381[(2)] = inst_19068);

(statearr_19215_19381[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (100))){
var state_19145__$1 = state_19145;
var statearr_19216_19382 = state_19145__$1;
(statearr_19216_19382[(2)] = false);

(statearr_19216_19382[(1)] = (101));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (43))){
var inst_18944 = (state_19145[(19)]);
var state_19145__$1 = state_19145;
var statearr_19217_19383 = state_19145__$1;
(statearr_19217_19383[(2)] = inst_18944);

(statearr_19217_19383[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (61))){
var inst_19007 = (state_19145[(7)]);
var inst_19008 = (state_19145[(8)]);
var inst_19012 = [new cljs.core.Keyword(null,"bigint","bigint",-1710937017),null,new cljs.core.Keyword(null,"string","string",-1989541586),null,new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),null];
var inst_19013 = inst_19008.call(null,cljs.core.PersistentArrayMap,null,3,inst_19012,null);
var inst_19014 = inst_19008.call(null,cljs.core.PersistentHashSet,null,inst_19013,null);
var inst_19015 = inst_19014.call(null,inst_19007);
var state_19145__$1 = state_19145;
if(cljs.core.truth_(inst_19015)){
var statearr_19218_19384 = state_19145__$1;
(statearr_19218_19384[(1)] = (63));

} else {
var statearr_19219_19385 = state_19145__$1;
(statearr_19219_19385[(1)] = (64));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (29))){
var inst_18876 = (state_19145[(9)]);
var inst_18931 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_18876);
var inst_18932 = cljs.core.not.call(null,inst_18931);
var inst_18933 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_18876);
var inst_18934 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18933);
var inst_18935 = inst_18934 === true;
var inst_18936 = ((inst_18932) && (inst_18935));
var state_19145__$1 = state_19145;
var statearr_19220_19386 = state_19145__$1;
(statearr_19220_19386[(2)] = inst_18936);

(statearr_19220_19386[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (44))){
var inst_18972 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19221_19387 = state_19145__$1;
(statearr_19221_19387[(2)] = inst_18972);

(statearr_19221_19387[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (93))){
var inst_19078 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19222_19388 = state_19145__$1;
(statearr_19222_19388[(2)] = inst_19078);

(statearr_19222_19388[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (6))){
var inst_18875 = (state_19145[(21)]);
var inst_18863 = (state_19145[(22)]);
var inst_18872 = cljs.core.seq.call(null,inst_18863);
var inst_18873 = cljs.core.first.call(null,inst_18872);
var inst_18874 = cljs.core.next.call(null,inst_18872);
var inst_18875__$1 = cljs.core.nth.call(null,inst_18873,(0),null);
var inst_18876 = cljs.core.nth.call(null,inst_18873,(1),null);
var inst_18877 = cljs.core.not.call(null,inst_18875__$1);
var state_19145__$1 = (function (){var statearr_19223 = state_19145;
(statearr_19223[(21)] = inst_18875__$1);

(statearr_19223[(23)] = inst_18874);

(statearr_19223[(9)] = inst_18876);

return statearr_19223;
})();
if(inst_18877){
var statearr_19224_19389 = state_19145__$1;
(statearr_19224_19389[(1)] = (8));

} else {
var statearr_19225_19390 = state_19145__$1;
(statearr_19225_19390[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (28))){
var inst_18925 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19226_19391 = state_19145__$1;
(statearr_19226_19391[(2)] = inst_18925);

(statearr_19226_19391[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (64))){
var state_19145__$1 = state_19145;
var statearr_19227_19392 = state_19145__$1;
(statearr_19227_19392[(1)] = (66));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (103))){
var inst_19107 = (state_19145[(16)]);
var state_19145__$1 = state_19145;
var statearr_19229_19393 = state_19145__$1;
(statearr_19229_19393[(2)] = inst_19107);

(statearr_19229_19393[(1)] = (104));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (51))){
var inst_18985 = (state_19145[(10)]);
var inst_18990 = inst_18985.cljs$lang$protocol_mask$partition0$;
var inst_18991 = (inst_18990 & (64));
var inst_18992 = inst_18985.cljs$core$ISeq$;
var inst_18993 = (cljs.core.PROTOCOL_SENTINEL === inst_18992);
var inst_18994 = ((inst_18991) || (inst_18993));
var state_19145__$1 = state_19145;
if(cljs.core.truth_(inst_18994)){
var statearr_19230_19394 = state_19145__$1;
(statearr_19230_19394[(1)] = (54));

} else {
var statearr_19231_19395 = state_19145__$1;
(statearr_19231_19395[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (25))){
var inst_18876 = (state_19145[(9)]);
var inst_18929 = (state_19145[(24)]);
var inst_18928 = (state_19145[(2)]);
var inst_18929__$1 = new cljs.core.Keyword(null,"component","component",1555936782).cljs$core$IFn$_invoke$arity$1(inst_18876);
var state_19145__$1 = (function (){var statearr_19232 = state_19145;
(statearr_19232[(18)] = inst_18928);

(statearr_19232[(24)] = inst_18929__$1);

return statearr_19232;
})();
if(cljs.core.truth_(inst_18929__$1)){
var statearr_19233_19396 = state_19145__$1;
(statearr_19233_19396[(1)] = (29));

} else {
var statearr_19234_19397 = state_19145__$1;
(statearr_19234_19397[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (34))){
var inst_18945 = (state_19145[(20)]);
var inst_18876 = (state_19145[(9)]);
var inst_18944 = (state_19145[(2)]);
var inst_18945__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_18876);
var state_19145__$1 = (function (){var statearr_19235 = state_19145;
(statearr_19235[(19)] = inst_18944);

(statearr_19235[(20)] = inst_18945__$1);

return statearr_19235;
})();
if(cljs.core.truth_(inst_18945__$1)){
var statearr_19236_19398 = state_19145__$1;
(statearr_19236_19398[(1)] = (35));

} else {
var statearr_19237_19399 = state_19145__$1;
(statearr_19237_19399[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (17))){
var inst_18876 = (state_19145[(9)]);
var inst_18899 = (state_19145[(17)]);
var inst_18899__$1 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18876);
var state_19145__$1 = (function (){var statearr_19238 = state_19145;
(statearr_19238[(17)] = inst_18899__$1);

return statearr_19238;
})();
if(cljs.core.truth_(inst_18899__$1)){
var statearr_19239_19400 = state_19145__$1;
(statearr_19239_19400[(1)] = (20));

} else {
var statearr_19240_19401 = state_19145__$1;
(statearr_19240_19401[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (3))){
var inst_19143 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19145__$1,inst_19143);
} else {
if((state_val_19146 === (12))){
var inst_18880 = (state_19145[(25)]);
var state_19145__$1 = state_19145;
var statearr_19241_19402 = state_19145__$1;
(statearr_19241_19402[(2)] = inst_18880);

(statearr_19241_19402[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (2))){
var _ = (function (){var statearr_19242 = state_19145;
(statearr_19242[(4)] = cljs.core.cons.call(null,(5),(state_19145[(4)])));

return statearr_19242;
})();
var inst_18856 = pred_changes;
var inst_18857 = cljs.core.seq.call(null,inst_18856);
var inst_18858 = cljs.core.first.call(null,inst_18857);
var inst_18859 = cljs.core.next.call(null,inst_18857);
var inst_18860 = cljs.core.nth.call(null,inst_18858,(0),null);
var inst_18861 = cljs.core.nth.call(null,inst_18858,(1),null);
var inst_18862 = db;
var inst_18863 = inst_18856;
var inst_18864 = inst_18862;
var state_19145__$1 = (function (){var statearr_19243 = state_19145;
(statearr_19243[(26)] = inst_18860);

(statearr_19243[(15)] = inst_18864);

(statearr_19243[(27)] = inst_18859);

(statearr_19243[(28)] = inst_18861);

(statearr_19243[(22)] = inst_18863);

return statearr_19243;
})();
var statearr_19244_19403 = state_19145__$1;
(statearr_19244_19403[(2)] = null);

(statearr_19244_19403[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (66))){
var inst_19008 = (state_19145[(8)]);
var state_19145__$1 = state_19145;
var G__19245_19404 = inst_19008;
var G__19245_19405__$1 = (((G__19245_19404 instanceof cljs.core.Keyword))?G__19245_19404.fqn:null);
switch (G__19245_19405__$1) {
case "long":
var statearr_19246_19407 = state_19145__$1;
(statearr_19246_19407[(1)] = (70));


break;
case "bigint":
var statearr_19247_19408 = state_19145__$1;
(statearr_19247_19408[(1)] = (74));


break;
case "double":
var statearr_19248_19409 = state_19145__$1;
(statearr_19248_19409[(1)] = (78));


break;
case "float":
var statearr_19249_19410 = state_19145__$1;
(statearr_19249_19410[(1)] = (82));


break;
case "bigdec":
var statearr_19250_19411 = state_19145__$1;
(statearr_19250_19411[(1)] = (86));


break;
case "string":
var statearr_19251_19412 = state_19145__$1;
(statearr_19251_19412[(1)] = (90));


break;
case "instant":
var statearr_19252_19413 = state_19145__$1;
(statearr_19252_19413[(1)] = (94));


break;
default:
var statearr_19253_19414 = state_19145__$1;
(statearr_19253_19414[(1)] = (98));



}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (107))){
var inst_18874 = (state_19145[(23)]);
var inst_19135 = (state_19145[(2)]);
var inst_18863 = inst_18874;
var inst_18864 = inst_19135;
var state_19145__$1 = (function (){var statearr_19254 = state_19145;
(statearr_19254[(15)] = inst_18864);

(statearr_19254[(22)] = inst_18863);

return statearr_19254;
})();
var statearr_19255_19415 = state_19145__$1;
(statearr_19255_19415[(2)] = null);

(statearr_19255_19415[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (23))){
var state_19145__$1 = state_19145;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_19256_19416 = state_19145__$1;
(statearr_19256_19416[(1)] = (26));

} else {
var statearr_19257_19417 = state_19145__$1;
(statearr_19257_19417[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (47))){
var inst_18982 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
if(cljs.core.truth_(inst_18982)){
var statearr_19258_19418 = state_19145__$1;
(statearr_19258_19418[(1)] = (48));

} else {
var statearr_19259_19419 = state_19145__$1;
(statearr_19259_19419[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (35))){
var inst_18864 = (state_19145[(15)]);
var inst_18875 = (state_19145[(21)]);
var inst_18876 = (state_19145[(9)]);
var inst_18947 = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(inst_18876);
var inst_18948 = cljs.core.not.call(null,inst_18947);
var inst_18949 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_18876);
var inst_18950 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18949);
var inst_18951 = inst_18950 === true;
var inst_18952 = fluree.db.query.schema.pred_objects_unique_QMARK_.call(null,inst_18864,inst_18875);
var state_19145__$1 = (function (){var statearr_19260 = state_19145;
(statearr_19260[(29)] = inst_18948);

(statearr_19260[(30)] = inst_18951);

return statearr_19260;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19145__$1,(38),inst_18952);
} else {
if((state_val_19146 === (82))){
var inst_19007 = (state_19145[(7)]);
var inst_19008 = (state_19145[(8)]);
var inst_19050 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_19051 = inst_19008.call(null,cljs.core.PersistentArrayMap,null,3,inst_19050,null);
var inst_19052 = inst_19008.call(null,cljs.core.PersistentHashSet,null,inst_19051,null);
var inst_19053 = inst_19052.call(null,inst_19007);
var state_19145__$1 = state_19145;
if(cljs.core.truth_(inst_19053)){
var statearr_19261_19420 = state_19145__$1;
(statearr_19261_19420[(1)] = (83));

} else {
var statearr_19262_19421 = state_19145__$1;
(statearr_19262_19421[(1)] = (84));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (76))){
var inst_19007 = (state_19145[(7)]);
var inst_19008 = (state_19145[(8)]);
var inst_19036 = fluree.db.query.schema.type_error.call(null,inst_19007,inst_19008,throw_QMARK_);
var state_19145__$1 = state_19145;
var statearr_19263_19422 = state_19145__$1;
(statearr_19263_19422[(2)] = inst_19036);

(statearr_19263_19422[(1)] = (77));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (97))){
var inst_19088 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19264_19423 = state_19145__$1;
(statearr_19264_19423[(2)] = inst_19088);

(statearr_19264_19423[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (19))){
var inst_18915 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
if(cljs.core.truth_(inst_18915)){
var statearr_19265_19424 = state_19145__$1;
(statearr_19265_19424[(1)] = (23));

} else {
var statearr_19266_19425 = state_19145__$1;
(statearr_19266_19425[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (57))){
var inst_18985 = (state_19145[(10)]);
var inst_19003 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18985);
var state_19145__$1 = state_19145;
var statearr_19267_19426 = state_19145__$1;
(statearr_19267_19426[(2)] = inst_19003);

(statearr_19267_19426[(1)] = (59));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (68))){
var inst_19096 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19268_19427 = state_19145__$1;
(statearr_19268_19427[(2)] = inst_19096);

(statearr_19268_19427[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (11))){
var inst_18876 = (state_19145[(9)]);
var inst_18882 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_18876);
var inst_18883 = new cljs.core.Keyword(null,"new","new",-2085437848).cljs$core$IFn$_invoke$arity$1(inst_18882);
var inst_18884 = inst_18883 === false;
var inst_18885 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_18876);
var inst_18886 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_18885);
var inst_18887 = inst_18886 === true;
var inst_18888 = ((inst_18884) && (inst_18887));
var state_19145__$1 = state_19145;
var statearr_19270_19428 = state_19145__$1;
(statearr_19270_19428[(2)] = inst_18888);

(statearr_19270_19428[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (9))){
var inst_18876 = (state_19145[(9)]);
var inst_18880 = (state_19145[(25)]);
var inst_18880__$1 = new cljs.core.Keyword(null,"multi","multi",-190293005).cljs$core$IFn$_invoke$arity$1(inst_18876);
var state_19145__$1 = (function (){var statearr_19271 = state_19145;
(statearr_19271[(25)] = inst_18880__$1);

return statearr_19271;
})();
if(cljs.core.truth_(inst_18880__$1)){
var statearr_19272_19429 = state_19145__$1;
(statearr_19272_19429[(1)] = (11));

} else {
var statearr_19273_19430 = state_19145__$1;
(statearr_19273_19430[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (5))){
var _ = (function (){var statearr_19274 = state_19145;
(statearr_19274[(4)] = cljs.core.rest.call(null,(state_19145[(4)])));

return statearr_19274;
})();
var state_19145__$1 = state_19145;
var ex19269 = (state_19145__$1[(2)]);
var statearr_19275_19431 = state_19145__$1;
(statearr_19275_19431[(5)] = ex19269);


if((ex19269 instanceof Error)){
var statearr_19276_19432 = state_19145__$1;
(statearr_19276_19432[(1)] = (4));

(statearr_19276_19432[(5)] = null);

} else {
throw ex19269;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (83))){
var inst_18975 = (state_19145[(11)]);
var state_19145__$1 = state_19145;
var statearr_19277_19433 = state_19145__$1;
(statearr_19277_19433[(2)] = inst_18975);

(statearr_19277_19433[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (14))){
var inst_18864 = (state_19145[(15)]);
var inst_18893 = fluree.db.query.schema.type_error.call(null,inst_18864,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_19145__$1 = state_19145;
var statearr_19278_19434 = state_19145__$1;
(statearr_19278_19434[(2)] = inst_18893);

(statearr_19278_19434[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (45))){
var inst_18876 = (state_19145[(9)]);
var inst_18978 = new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(inst_18876);
var inst_18979 = new cljs.core.Keyword(null,"old","old",-1825222690).cljs$core$IFn$_invoke$arity$1(inst_18978);
var state_19145__$1 = state_19145;
var statearr_19279_19435 = state_19145__$1;
(statearr_19279_19435[(2)] = inst_18979);

(statearr_19279_19435[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (53))){
var inst_19001 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
if(cljs.core.truth_(inst_19001)){
var statearr_19280_19436 = state_19145__$1;
(statearr_19280_19436[(1)] = (57));

} else {
var statearr_19281_19437 = state_19145__$1;
(statearr_19281_19437[(1)] = (58));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (78))){
var inst_19007 = (state_19145[(7)]);
var inst_19008 = (state_19145[(8)]);
var inst_19040 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null,new cljs.core.Keyword(null,"float","float",-1732389368),null];
var inst_19041 = inst_19008.call(null,cljs.core.PersistentArrayMap,null,3,inst_19040,null);
var inst_19042 = inst_19008.call(null,cljs.core.PersistentHashSet,null,inst_19041,null);
var inst_19043 = inst_19042.call(null,inst_19007);
var state_19145__$1 = state_19145;
if(cljs.core.truth_(inst_19043)){
var statearr_19282_19438 = state_19145__$1;
(statearr_19282_19438[(1)] = (79));

} else {
var statearr_19283_19439 = state_19145__$1;
(statearr_19283_19439[(1)] = (80));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (26))){
var inst_18918 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18919 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_18920 = cljs.core.PersistentHashMap.fromArrays(inst_18918,inst_18919);
var inst_18921 = cljs.core.ex_info.call(null,"A boolean _predicate cannot be unique.",inst_18920);
var inst_18922 = (function(){throw inst_18921})();
var state_19145__$1 = state_19145;
var statearr_19284_19440 = state_19145__$1;
(statearr_19284_19440[(2)] = inst_18922);

(statearr_19284_19440[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (16))){
var inst_18876 = (state_19145[(9)]);
var inst_18897 = (state_19145[(31)]);
var inst_18896 = (state_19145[(2)]);
var inst_18897__$1 = new cljs.core.Keyword(null,"unique","unique",329397282).cljs$core$IFn$_invoke$arity$1(inst_18876);
var state_19145__$1 = (function (){var statearr_19285 = state_19145;
(statearr_19285[(12)] = inst_18896);

(statearr_19285[(31)] = inst_18897__$1);

return statearr_19285;
})();
if(cljs.core.truth_(inst_18897__$1)){
var statearr_19286_19441 = state_19145__$1;
(statearr_19286_19441[(1)] = (17));

} else {
var statearr_19287_19442 = state_19145__$1;
(statearr_19287_19442[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (81))){
var inst_19048 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19288_19443 = state_19145__$1;
(statearr_19288_19443[(2)] = inst_19048);

(statearr_19288_19443[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (79))){
var inst_18975 = (state_19145[(11)]);
var state_19145__$1 = state_19145;
var statearr_19289_19444 = state_19145__$1;
(statearr_19289_19444[(2)] = inst_18975);

(statearr_19289_19444[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (38))){
var inst_18948 = (state_19145[(29)]);
var inst_18951 = (state_19145[(30)]);
var inst_18954 = (state_19145[(2)]);
var inst_18955 = fluree.db.util.async.throw_err.call(null,inst_18954);
var inst_18956 = cljs.core.not.call(null,inst_18955);
var inst_18957 = ((inst_18948) && (inst_18951) && (inst_18956));
var state_19145__$1 = state_19145;
var statearr_19290_19445 = state_19145__$1;
(statearr_19290_19445[(2)] = inst_18957);

(statearr_19290_19445[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (98))){
var inst_19007 = (state_19145[(7)]);
var inst_19008 = (state_19145[(8)]);
var inst_19090 = fluree.db.query.schema.type_error.call(null,inst_19007,inst_19008,throw_QMARK_);
var state_19145__$1 = state_19145;
var statearr_19291_19446 = state_19145__$1;
(statearr_19291_19446[(2)] = inst_19090);

(statearr_19291_19446[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (87))){
var inst_18975 = (state_19145[(11)]);
var state_19145__$1 = state_19145;
var statearr_19292_19447 = state_19145__$1;
(statearr_19292_19447[(2)] = inst_18975);

(statearr_19292_19447[(1)] = (89));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (30))){
var inst_18929 = (state_19145[(24)]);
var state_19145__$1 = state_19145;
var statearr_19293_19448 = state_19145__$1;
(statearr_19293_19448[(2)] = inst_18929);

(statearr_19293_19448[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (73))){
var inst_19028 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19294_19449 = state_19145__$1;
(statearr_19294_19449[(2)] = inst_19028);

(statearr_19294_19449[(1)] = (69));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (96))){
var inst_19007 = (state_19145[(7)]);
var inst_19008 = (state_19145[(8)]);
var inst_19086 = fluree.db.query.schema.type_error.call(null,inst_19007,inst_19008,throw_QMARK_);
var state_19145__$1 = state_19145;
var statearr_19295_19450 = state_19145__$1;
(statearr_19295_19450[(2)] = inst_19086);

(statearr_19295_19450[(1)] = (97));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (10))){
var inst_19138 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
var statearr_19296_19451 = state_19145__$1;
(statearr_19296_19451[(2)] = inst_19138);

(statearr_19296_19451[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (18))){
var inst_18897 = (state_19145[(31)]);
var state_19145__$1 = state_19145;
var statearr_19297_19452 = state_19145__$1;
(statearr_19297_19452[(2)] = inst_18897);

(statearr_19297_19452[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (105))){
var state_19145__$1 = state_19145;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_19298_19453 = state_19145__$1;
(statearr_19298_19453[(1)] = (108));

} else {
var statearr_19299_19454 = state_19145__$1;
(statearr_19299_19454[(1)] = (109));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (52))){
var state_19145__$1 = state_19145;
var statearr_19300_19455 = state_19145__$1;
(statearr_19300_19455[(2)] = false);

(statearr_19300_19455[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (67))){
var state_19145__$1 = state_19145;
var statearr_19301_19456 = state_19145__$1;
(statearr_19301_19456[(2)] = null);

(statearr_19301_19456[(1)] = (68));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (71))){
var inst_18975 = (state_19145[(11)]);
var state_19145__$1 = state_19145;
var statearr_19302_19457 = state_19145__$1;
(statearr_19302_19457[(2)] = inst_18975);

(statearr_19302_19457[(1)] = (73));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (42))){
var inst_18864 = (state_19145[(15)]);
var inst_18875 = (state_19145[(21)]);
var inst_18963 = fluree.db.dbproto._p_prop.call(null,inst_18864,new cljs.core.Keyword(null,"name","name",1843675177),inst_18875);
var inst_18964 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_18963)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_18965 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_18966 = [(400),new cljs.core.Keyword("db","invalid-tx","db/invalid-tx",-2050299645)];
var inst_18967 = cljs.core.PersistentHashMap.fromArrays(inst_18965,inst_18966);
var inst_18968 = cljs.core.ex_info.call(null,inst_18964,inst_18967);
var inst_18969 = (function(){throw inst_18968})();
var state_19145__$1 = state_19145;
var statearr_19303_19458 = state_19145__$1;
(statearr_19303_19458[(2)] = inst_18969);

(statearr_19303_19458[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (80))){
var inst_19007 = (state_19145[(7)]);
var inst_19008 = (state_19145[(8)]);
var inst_19046 = fluree.db.query.schema.type_error.call(null,inst_19007,inst_19008,throw_QMARK_);
var state_19145__$1 = state_19145;
var statearr_19304_19459 = state_19145__$1;
(statearr_19304_19459[(2)] = inst_19046);

(statearr_19304_19459[(1)] = (81));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (37))){
var inst_18960 = (state_19145[(2)]);
var state_19145__$1 = state_19145;
if(cljs.core.truth_(inst_18960)){
var statearr_19305_19460 = state_19145__$1;
(statearr_19305_19460[(1)] = (39));

} else {
var statearr_19306_19461 = state_19145__$1;
(statearr_19306_19461[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (63))){
var inst_19007 = (state_19145[(7)]);
var inst_19008 = (state_19145[(8)]);
var inst_19017 = fluree.db.query.schema.type_error.call(null,inst_19007,inst_19008,throw_QMARK_);
var state_19145__$1 = state_19145;
var statearr_19307_19462 = state_19145__$1;
(statearr_19307_19462[(2)] = inst_19017);

(statearr_19307_19462[(1)] = (65));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (94))){
var inst_19007 = (state_19145[(7)]);
var inst_19008 = (state_19145[(8)]);
var inst_19080 = [new cljs.core.Keyword(null,"long","long",-171452093),null,new cljs.core.Keyword(null,"int","int",-1741416922),null];
var inst_19081 = inst_19008.call(null,cljs.core.PersistentArrayMap,null,2,inst_19080,null);
var inst_19082 = inst_19008.call(null,cljs.core.PersistentHashSet,null,inst_19081,null);
var inst_19083 = inst_19082.call(null,inst_19007);
var state_19145__$1 = state_19145;
if(cljs.core.truth_(inst_19083)){
var statearr_19308_19463 = state_19145__$1;
(statearr_19308_19463[(1)] = (95));

} else {
var statearr_19309_19464 = state_19145__$1;
(statearr_19309_19464[(1)] = (96));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (8))){
var inst_18864 = (state_19145[(15)]);
var state_19145__$1 = state_19145;
var statearr_19310_19465 = state_19145__$1;
(statearr_19310_19465[(2)] = inst_18864);

(statearr_19310_19465[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (49))){
var inst_18975 = (state_19145[(11)]);
var state_19145__$1 = state_19145;
var statearr_19311_19466 = state_19145__$1;
(statearr_19311_19466[(2)] = inst_18975);

(statearr_19311_19466[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19146 === (84))){
var inst_19007 = (state_19145[(7)]);
var inst_19008 = (state_19145[(8)]);
var inst_19056 = fluree.db.query.schema.type_error.call(null,inst_19007,inst_19008,throw_QMARK_);
var state_19145__$1 = state_19145;
var statearr_19312_19467 = state_19145__$1;
(statearr_19312_19467[(2)] = inst_19056);

(statearr_19312_19467[(1)] = (85));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__2879__auto__ = null;
var fluree$db$query$schema$state_machine__2879__auto____0 = (function (){
var statearr_19313 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19313[(0)] = fluree$db$query$schema$state_machine__2879__auto__);

(statearr_19313[(1)] = (1));

return statearr_19313;
});
var fluree$db$query$schema$state_machine__2879__auto____1 = (function (state_19145){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_19145);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e19314){var ex__2882__auto__ = e19314;
var statearr_19315_19468 = state_19145;
(statearr_19315_19468[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_19145[(4)]))){
var statearr_19316_19469 = state_19145;
(statearr_19316_19469[(1)] = cljs.core.first.call(null,(state_19145[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19470 = state_19145;
state_19145 = G__19470;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__2879__auto__ = function(state_19145){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__2879__auto____1.call(this,state_19145);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__2879__auto____0;
fluree$db$query$schema$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__2879__auto____1;
return fluree$db$query$schema$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_19317 = f__2902__auto__.call(null);
(statearr_19317[(6)] = c__2901__auto__);

return statearr_19317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(db,tempids,flakes){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_19494){
var state_val_19495 = (state_19494[(1)]);
if((state_val_19495 === (7))){
var state_19494__$1 = state_19494;
var statearr_19496_19515 = state_19494__$1;
(statearr_19496_19515[(2)] = db);

(statearr_19496_19515[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19495 === (1))){
var state_19494__$1 = state_19494;
var statearr_19497_19516 = state_19494__$1;
(statearr_19497_19516[(2)] = null);

(statearr_19497_19516[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19495 === (4))){
var inst_19471 = (state_19494[(2)]);
var state_19494__$1 = state_19494;
var statearr_19498_19517 = state_19494__$1;
(statearr_19498_19517[(2)] = inst_19471);

(statearr_19498_19517[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19495 === (6))){
var inst_19480 = (state_19494[(7)]);
var inst_19479 = (state_19494[(2)]);
var inst_19480__$1 = fluree.db.util.async.throw_err.call(null,inst_19479);
var inst_19481 = cljs.core.empty_QMARK_.call(null,inst_19480__$1);
var state_19494__$1 = (function (){var statearr_19499 = state_19494;
(statearr_19499[(7)] = inst_19480__$1);

return statearr_19499;
})();
if(inst_19481){
var statearr_19500_19518 = state_19494__$1;
(statearr_19500_19518[(1)] = (7));

} else {
var statearr_19501_19519 = state_19494__$1;
(statearr_19501_19519[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19495 === (3))){
var inst_19492 = (state_19494[(2)]);
var state_19494__$1 = state_19494;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19494__$1,inst_19492);
} else {
if((state_val_19495 === (2))){
var _ = (function (){var statearr_19503 = state_19494;
(statearr_19503[(4)] = cljs.core.cons.call(null,(5),(state_19494[(4)])));

return statearr_19503;
})();
var inst_19477 = fluree.db.query.schema.new_pred_changes.call(null,db,tempids,flakes);
var state_19494__$1 = state_19494;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19494__$1,(6),inst_19477);
} else {
if((state_val_19495 === (9))){
var inst_19489 = (state_19494[(2)]);
var _ = (function (){var statearr_19504 = state_19494;
(statearr_19504[(4)] = cljs.core.rest.call(null,(state_19494[(4)])));

return statearr_19504;
})();
var state_19494__$1 = state_19494;
var statearr_19505_19520 = state_19494__$1;
(statearr_19505_19520[(2)] = inst_19489);

(statearr_19505_19520[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19495 === (5))){
var _ = (function (){var statearr_19506 = state_19494;
(statearr_19506[(4)] = cljs.core.rest.call(null,(state_19494[(4)])));

return statearr_19506;
})();
var state_19494__$1 = state_19494;
var ex19502 = (state_19494__$1[(2)]);
var statearr_19507_19521 = state_19494__$1;
(statearr_19507_19521[(5)] = ex19502);


if((ex19502 instanceof Error)){
var statearr_19508_19522 = state_19494__$1;
(statearr_19508_19522[(1)] = (4));

(statearr_19508_19522[(5)] = null);

} else {
throw ex19502;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19495 === (10))){
var inst_19486 = (state_19494[(2)]);
var inst_19487 = fluree.db.util.async.throw_err.call(null,inst_19486);
var state_19494__$1 = state_19494;
var statearr_19509_19523 = state_19494__$1;
(statearr_19509_19523[(2)] = inst_19487);

(statearr_19509_19523[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19495 === (8))){
var inst_19480 = (state_19494[(7)]);
var inst_19484 = fluree.db.query.schema.predicate_change_error.call(null,inst_19480,db,true);
var state_19494__$1 = state_19494;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19494__$1,(10),inst_19484);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto__ = null;
var fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto____0 = (function (){
var statearr_19510 = [null,null,null,null,null,null,null,null];
(statearr_19510[(0)] = fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto__);

(statearr_19510[(1)] = (1));

return statearr_19510;
});
var fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto____1 = (function (state_19494){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_19494);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e19511){var ex__2882__auto__ = e19511;
var statearr_19512_19524 = state_19494;
(statearr_19512_19524[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_19494[(4)]))){
var statearr_19513_19525 = state_19494;
(statearr_19513_19525[(1)] = cljs.core.first.call(null,(state_19494[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19526 = state_19494;
state_19494 = G__19526;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto__ = function(state_19494){
switch(arguments.length){
case 0:
return fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto____1.call(this,state_19494);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto____0;
fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto____1;
return fluree$db$query$schema$validate_schema_change_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_19514 = f__2902__auto__.call(null);
(statearr_19514[(6)] = c__2901__auto__);

return statearr_19514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__19528 = arguments.length;
switch (G__19528) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.call(null,predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$.call(null,cljs.core.re_matches.call(null,fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__19530 = cljs.core.re_matches.call(null,/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.call(null,vec__19530,(0),null);
var ns = cljs.core.nth.call(null,vec__19530,(1),null);
var name = cljs.core.nth.call(null,vec__19530,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.call(null,"_",cljs.core.nth.call(null,name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.call(null,name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
} else {
throw cljs.core.ex_info.call(null,["Bad predicate name, should be string: ",cljs.core.pr_str.call(null,predicate_name)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-predicate","db/invalid-predicate",1598480850)], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(2)),fluree.db.flake.__GT_sid.call(null,(3),(9)),fluree.db.flake.__GT_sid.call(null,(3),(14)),fluree.db.flake.__GT_sid.call(null,(3),(16)),fluree.db.flake.__GT_sid.call(null,(3),(8)),fluree.db.flake.__GT_sid.call(null,(3),(4)),fluree.db.flake.__GT_sid.call(null,(3),(5)),fluree.db.flake.__GT_sid.call(null,(3),(15)),fluree.db.flake.__GT_sid.call(null,(3),(17)),fluree.db.flake.__GT_sid.call(null,(3),(11)),fluree.db.flake.__GT_sid.call(null,(3),(12)),fluree.db.flake.__GT_sid.call(null,(3),(1)),fluree.db.flake.__GT_sid.call(null,(3),(10)),fluree.db.flake.__GT_sid.call(null,(3),(6)),fluree.db.flake.__GT_sid.call(null,(3),(7)),fluree.db.flake.__GT_sid.call(null,(3),(13))],[new cljs.core.Keyword(null,"ref","ref",1289896967),new cljs.core.Keyword(null,"int","int",-1741416922),new cljs.core.Keyword(null,"bigdec","bigdec",1019443956),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"bytes","bytes",1175866680),new cljs.core.Keyword(null,"boolean","boolean",-1919418404),new cljs.core.Keyword(null,"instant","instant",655498374),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"geojson","geojson",-719473398),new cljs.core.Keyword(null,"bigint","bigint",-1710937017),new cljs.core.Keyword(null,"float","float",-1732389368),new cljs.core.Keyword(null,"string","string",-1989541586),new cljs.core.Keyword(null,"long","long",-171452093),new cljs.core.Keyword(null,"uuid","uuid",-2145095719),new cljs.core.Keyword(null,"uri","uri",-774711847),new cljs.core.Keyword(null,"double","double",884886883)]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid.call(null,(3),(62)),fluree.db.flake.__GT_sid.call(null,(3),(68)),fluree.db.flake.__GT_sid.call(null,(3),(67)),fluree.db.flake.__GT_sid.call(null,(3),(69)),fluree.db.flake.__GT_sid.call(null,(3),(63)),fluree.db.flake.__GT_sid.call(null,(3),(70)),fluree.db.flake.__GT_sid.call(null,(3),(65)),fluree.db.flake.__GT_sid.call(null,(3),(66)),fluree.db.flake.__GT_sid.call(null,(3),(64)),fluree.db.flake.__GT_sid.call(null,(3),(61))],[new cljs.core.Keyword(null,"bn","bn",-1320495310),new cljs.core.Keyword(null,"hi","hi",-1821422114),new cljs.core.Keyword(null,"fr","fr",1577713888),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"br","br",934104792),new cljs.core.Keyword(null,"ru","ru",-1755311210),new cljs.core.Keyword(null,"en","en",88457073),new cljs.core.Keyword(null,"es","es",1831673219),new cljs.core.Keyword(null,"cn","cn",457269822),new cljs.core.Keyword(null,"ar","ar",-2093907980)]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.call(null,(function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.call(null,acc,p);
if(cljs.core.truth_((function (){var and__4115__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.vector_QMARK_.call(null,existing_QMARK_);
} else {
return and__4115__auto__;
}
})())){
return cljs.core.update.call(null,acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.call(null,acc,p,(function (p1__19533_SHARP_,p2__19534_SHARP_){
return cljs.core.vec.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__19533_SHARP_,p2__19534_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.call(null,acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with two keys:
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_19600){
var state_val_19601 = (state_19600[(1)]);
if((state_val_19601 === (1))){
var state_19600__$1 = state_19600;
var statearr_19602_19619 = state_19600__$1;
(statearr_19602_19619[(2)] = null);

(statearr_19602_19619[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19601 === (2))){
var _ = (function (){var statearr_19603 = state_19600;
(statearr_19603[(4)] = cljs.core.cons.call(null,(5),(state_19600[(4)])));

return statearr_19603;
})();
var inst_19552 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19553 = fluree.db.flake.max_subject_id.call(null,(1));
var inst_19554 = [inst_19553];
var inst_19555 = (new cljs.core.PersistentVector(null,1,(5),inst_19552,inst_19554,null));
var inst_19556 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19557 = [(0)];
var inst_19558 = (new cljs.core.PersistentVector(null,1,(5),inst_19556,inst_19557,null));
var inst_19559 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._GT__EQ_,inst_19555,cljs.core._LT__EQ_,inst_19558);
var state_19600__$1 = state_19600;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19600__$1,(6),inst_19559);
} else {
if((state_val_19601 === (3))){
var inst_19598 = (state_19600[(2)]);
var state_19600__$1 = state_19600;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19600__$1,inst_19598);
} else {
if((state_val_19601 === (4))){
var inst_19540 = (state_19600[(2)]);
var state_19600__$1 = state_19600;
var statearr_19605_19620 = state_19600__$1;
(statearr_19605_19620[(2)] = inst_19540);

(statearr_19605_19620[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19601 === (5))){
var _ = (function (){var statearr_19606 = state_19600;
(statearr_19606[(4)] = cljs.core.rest.call(null,(state_19600[(4)])));

return statearr_19606;
})();
var state_19600__$1 = state_19600;
var ex19604 = (state_19600__$1[(2)]);
var statearr_19607_19621 = state_19600__$1;
(statearr_19607_19621[(5)] = ex19604);


if((ex19604 instanceof Error)){
var statearr_19608_19622 = state_19600__$1;
(statearr_19608_19622[(1)] = (4));

(statearr_19608_19622[(5)] = null);

} else {
throw ex19604;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19601 === (6))){
var inst_19561 = (state_19600[(2)]);
var inst_19562 = fluree.db.util.async.throw_err.call(null,inst_19561);
var inst_19563 = (function (){var schema_flakes = inst_19562;
return (function (p1__19535_SHARP_){
return (p1__19535_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_19564 = cljs.core.partition_by.call(null,inst_19563,inst_19562);
var inst_19565 = cljs.core.nth.call(null,inst_19564,(0),null);
var inst_19566 = cljs.core.nth.call(null,inst_19564,(1),null);
var inst_19567 = (function (){var schema_flakes = inst_19562;
var vec__19546 = inst_19564;
var collection_flakes = inst_19565;
var predicate_flakes = inst_19566;
return (function (acc,coll_flakes){
var sid = cljs.core.first.call(null,coll_flakes).s;
var id = fluree.db.flake.sid__GT_i.call(null,sid);
var p__GT_v = cljs.core.reduce.call(null,(function (p1__19537_SHARP_,p2__19538_SHARP_){
return cljs.core.assoc.call(null,p1__19537_SHARP_,p2__19538_SHARP_.p,p2__19538_SHARP_.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var c_name = cljs.core.get.call(null,p__GT_v,(40));
var spec = cljs.core.get.call(null,p__GT_v,(43));
var specDoc = cljs.core.get.call(null,p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),c_name,new cljs.core.Keyword(null,"sid","sid",1815016414),sid,new cljs.core.Keyword(null,"spec","spec",347520401),spec,new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),specDoc,new cljs.core.Keyword(null,"id","id",-1388402092),id], null);
return cljs.core.assoc.call(null,acc,id,c_props,c_name,c_props);
});
})();
var inst_19568 = [(-1),"_tx"];
var inst_19569 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_19570 = ["_tx",(-1),(-1)];
var inst_19571 = cljs.core.PersistentHashMap.fromArrays(inst_19569,inst_19570);
var inst_19572 = [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"sid","sid",1815016414)];
var inst_19573 = ["_tx",(-1),(-1)];
var inst_19574 = cljs.core.PersistentHashMap.fromArrays(inst_19572,inst_19573);
var inst_19575 = [inst_19571,inst_19574];
var inst_19576 = cljs.core.PersistentHashMap.fromArrays(inst_19568,inst_19575);
var inst_19577 = (function (){var schema_flakes = inst_19562;
var vec__19546 = inst_19564;
var collection_flakes = inst_19565;
var predicate_flakes = inst_19566;
return (function (p1__19536_SHARP_){
return p1__19536_SHARP_.s;
});
})();
var inst_19578 = cljs.core.partition_by.call(null,inst_19577,inst_19565);
var inst_19579 = cljs.core.reduce.call(null,inst_19567,inst_19576,inst_19578);
var inst_19581 = (function (){var schema_flakes = inst_19562;
var vec__19546 = inst_19564;
var collection_flakes = inst_19565;
var predicate_flakes = inst_19566;
var coll = inst_19579;
return (function (p__19580,pred_flakes){
var vec__19609 = p__19580;
var pred = cljs.core.nth.call(null,vec__19609,(0),null);
var fullText = cljs.core.nth.call(null,vec__19609,(1),null);
var id = cljs.core.first.call(null,pred_flakes).s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map.call(null,pred_flakes);
var p_name = cljs.core.get.call(null,p__GT_v,(10));
var p_type = cljs.core.get.call(null,fluree.db.query.schema.type_sid__GT_type,cljs.core.get.call(null,p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),null,new cljs.core.Keyword(null,"tag","tag",-1290361223),null], null), null).call(null,p_type));
var idx_QMARK_ = cljs.core.boolean$.call(null,(function (){var or__4126__auto__ = ref_QMARK_;
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core.get.call(null,p__GT_v,(15));
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.get.call(null,p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.call(null,p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"unique","unique",329397282),new cljs.core.Keyword(null,"restrictCollection","restrictCollection",-564261275),new cljs.core.Keyword(null,"index","index",-1531685915),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"noHistory","noHistory",-1975155222),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"txSpec","txSpec",-570527155),new cljs.core.Keyword(null,"component","component",1555936782),new cljs.core.Keyword(null,"txSpecDoc","txSpecDoc",-103492081),new cljs.core.Keyword(null,"spec","spec",347520401),new cljs.core.Keyword(null,"multi","multi",-190293005),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"specDoc","specDoc",-1212731692),new cljs.core.Keyword(null,"idx?","idx?",-564590377),new cljs.core.Keyword(null,"ref?","ref?",1932693720),new cljs.core.Keyword(null,"upsert","upsert",1416724984),new cljs.core.Keyword(null,"restrictTag","restrictTag",-1004793733),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)],[cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(13))),cljs.core.get.call(null,p__GT_v,(19)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(15))),p_name,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(18))),p_type,cljs.core.get.call(null,p__GT_v,(24)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(17))),cljs.core.get.call(null,p__GT_v,(25)),cljs.core.get.call(null,p__GT_v,(20)),cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(14))),id,cljs.core.get.call(null,p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$.call(null,cljs.core.get.call(null,p__GT_v,(16))),cljs.core.get.call(null,p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,pred,id,p_props,p_name,p_props),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.call(null,fullText,id):fullText)], null);
});
})();
var inst_19582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19583 = cljs.core.PersistentHashMap.EMPTY;
var inst_19584 = cljs.core.PersistentHashSet.EMPTY;
var inst_19585 = [inst_19583,inst_19584];
var inst_19586 = (new cljs.core.PersistentVector(null,2,(5),inst_19582,inst_19585,null));
var inst_19587 = (function (){var schema_flakes = inst_19562;
var vec__19546 = inst_19564;
var collection_flakes = inst_19565;
var predicate_flakes = inst_19566;
var coll = inst_19579;
return (function (p1__19539_SHARP_){
return p1__19539_SHARP_.s;
});
})();
var inst_19588 = cljs.core.partition_by.call(null,inst_19587,inst_19566);
var inst_19589 = cljs.core.reduce.call(null,inst_19581,inst_19586,inst_19588);
var inst_19590 = cljs.core.nth.call(null,inst_19589,(0),null);
var inst_19591 = cljs.core.nth.call(null,inst_19589,(1),null);
var inst_19592 = [new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"coll","coll",1647737163),new cljs.core.Keyword(null,"pred","pred",1927423397),new cljs.core.Keyword(null,"fullText","fullText",-1216121061)];
var inst_19593 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(db);
var inst_19594 = [inst_19593,inst_19579,inst_19590,inst_19591];
var inst_19595 = cljs.core.PersistentHashMap.fromArrays(inst_19592,inst_19594);
var _ = (function (){var statearr_19612 = state_19600;
(statearr_19612[(4)] = cljs.core.rest.call(null,(state_19600[(4)])));

return statearr_19612;
})();
var state_19600__$1 = state_19600;
var statearr_19613_19623 = state_19600__$1;
(statearr_19613_19623[(2)] = inst_19595);

(statearr_19613_19623[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__2879__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__2879__auto____0 = (function (){
var statearr_19614 = [null,null,null,null,null,null,null];
(statearr_19614[(0)] = fluree$db$query$schema$schema_map_$_state_machine__2879__auto__);

(statearr_19614[(1)] = (1));

return statearr_19614;
});
var fluree$db$query$schema$schema_map_$_state_machine__2879__auto____1 = (function (state_19600){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_19600);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e19615){var ex__2882__auto__ = e19615;
var statearr_19616_19624 = state_19600;
(statearr_19616_19624[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_19600[(4)]))){
var statearr_19617_19625 = state_19600;
(statearr_19617_19625[(1)] = cljs.core.first.call(null,(state_19600[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19626 = state_19600;
state_19600 = G__19626;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__2879__auto__ = function(state_19600){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__2879__auto____1.call(this,state_19600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__2879__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__2879__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_19618 = f__2902__auto__.call(null);
(statearr_19618[(6)] = c__2901__auto__);

return statearr_19618;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_19668){
var state_val_19669 = (state_19668[(1)]);
if((state_val_19669 === (7))){
var inst_19651 = (state_19668[(2)]);
var inst_19652 = fluree.db.query.schema.flake__GT_pred_map.call(null,inst_19651);
var inst_19653 = [new cljs.core.Keyword(null,"passwords","passwords",-403324634),new cljs.core.Keyword(null,"anonymous","anonymous",447897231),new cljs.core.Keyword(null,"language","language",-1591107564),new cljs.core.Keyword(null,"ledgers","ledgers",-2111050533),new cljs.core.Keyword(null,"txMax","txMax",418352369),new cljs.core.Keyword(null,"consensus","consensus",1370116681)];
var inst_19654 = cljs.core.get.call(null,inst_19652,(114));
var inst_19655 = cljs.core.boolean$.call(null,inst_19654);
var inst_19656 = cljs.core.get.call(null,inst_19652,(110));
var inst_19657 = cljs.core.get.call(null,inst_19652,(117));
var inst_19658 = cljs.core.get.call(null,fluree.db.query.schema.lang_sid__GT_lang,inst_19657);
var inst_19659 = cljs.core.get.call(null,inst_19652,(111));
var inst_19660 = cljs.core.get.call(null,inst_19652,(115));
var inst_19661 = cljs.core.get.call(null,inst_19652,(112));
var inst_19662 = [inst_19655,inst_19656,inst_19658,inst_19659,inst_19660,inst_19661];
var inst_19663 = cljs.core.PersistentHashMap.fromArrays(inst_19653,inst_19662);
var _ = (function (){var statearr_19670 = state_19668;
(statearr_19670[(4)] = cljs.core.rest.call(null,(state_19668[(4)])));

return statearr_19670;
})();
var state_19668__$1 = state_19668;
var statearr_19671_19694 = state_19668__$1;
(statearr_19671_19694[(2)] = inst_19663);

(statearr_19671_19694[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19669 === (1))){
var state_19668__$1 = state_19668;
var statearr_19672_19695 = state_19668__$1;
(statearr_19672_19695[(2)] = null);

(statearr_19672_19695[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19669 === (4))){
var inst_19627 = (state_19668[(2)]);
var state_19668__$1 = state_19668;
var statearr_19673_19696 = state_19668__$1;
(statearr_19673_19696[(2)] = inst_19627);

(statearr_19673_19696[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19669 === (6))){
var _ = (function (){var statearr_19674 = state_19668;
(statearr_19674[(4)] = cljs.core.cons.call(null,(9),(state_19668[(4)])));

return statearr_19674;
})();
var inst_19639 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19641 = ["_setting/id","root"];
var inst_19642 = (new cljs.core.PersistentVector(null,2,(5),inst_19640,inst_19641,null));
var inst_19643 = [inst_19642];
var inst_19644 = (new cljs.core.PersistentVector(null,1,(5),inst_19639,inst_19643,null));
var inst_19645 = fluree.db.query.range.index_range.call(null,db,new cljs.core.Keyword(null,"spot","spot",-1706962147),cljs.core._EQ_,inst_19644);
var state_19668__$1 = state_19668;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19668__$1,(10),inst_19645);
} else {
if((state_val_19669 === (3))){
var inst_19666 = (state_19668[(2)]);
var state_19668__$1 = state_19668;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19668__$1,inst_19666);
} else {
if((state_val_19669 === (2))){
var _ = (function (){var statearr_19677 = state_19668;
(statearr_19677[(4)] = cljs.core.cons.call(null,(5),(state_19668[(4)])));

return statearr_19677;
})();
var state_19668__$1 = state_19668;
var statearr_19678_19697 = state_19668__$1;
(statearr_19678_19697[(2)] = null);

(statearr_19678_19697[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19669 === (9))){
var _ = (function (){var statearr_19679 = state_19668;
(statearr_19679[(4)] = cljs.core.rest.call(null,(state_19668[(4)])));

return statearr_19679;
})();
var state_19668__$1 = state_19668;
var ex19675 = (state_19668__$1[(2)]);
var statearr_19680_19698 = state_19668__$1;
(statearr_19680_19698[(5)] = ex19675);


var statearr_19681_19699 = state_19668__$1;
(statearr_19681_19699[(1)] = (8));

(statearr_19681_19699[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19669 === (5))){
var _ = (function (){var statearr_19682 = state_19668;
(statearr_19682[(4)] = cljs.core.rest.call(null,(state_19668[(4)])));

return statearr_19682;
})();
var state_19668__$1 = state_19668;
var ex19676 = (state_19668__$1[(2)]);
var statearr_19683_19700 = state_19668__$1;
(statearr_19683_19700[(5)] = ex19676);


if((ex19676 instanceof Error)){
var statearr_19684_19701 = state_19668__$1;
(statearr_19684_19701[(1)] = (4));

(statearr_19684_19701[(5)] = null);

} else {
throw ex19676;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19669 === (10))){
var inst_19647 = (state_19668[(2)]);
var inst_19648 = fluree.db.util.async.throw_err.call(null,inst_19647);
var _ = (function (){var statearr_19685 = state_19668;
(statearr_19685[(4)] = cljs.core.rest.call(null,(state_19668[(4)])));

return statearr_19685;
})();
var state_19668__$1 = state_19668;
var statearr_19686_19702 = state_19668__$1;
(statearr_19686_19702[(2)] = inst_19648);

(statearr_19686_19702[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19669 === (8))){
var inst_19633 = (state_19668[(2)]);
var state_19668__$1 = (function (){var statearr_19687 = state_19668;
(statearr_19687[(7)] = inst_19633);

return statearr_19687;
})();
var statearr_19688_19703 = state_19668__$1;
(statearr_19688_19703[(2)] = null);

(statearr_19688_19703[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__2879__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__2879__auto____0 = (function (){
var statearr_19689 = [null,null,null,null,null,null,null,null];
(statearr_19689[(0)] = fluree$db$query$schema$setting_map_$_state_machine__2879__auto__);

(statearr_19689[(1)] = (1));

return statearr_19689;
});
var fluree$db$query$schema$setting_map_$_state_machine__2879__auto____1 = (function (state_19668){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_19668);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e19690){var ex__2882__auto__ = e19690;
var statearr_19691_19704 = state_19668;
(statearr_19691_19704[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_19668[(4)]))){
var statearr_19692_19705 = state_19668;
(statearr_19692_19705[(1)] = cljs.core.first.call(null,(state_19668[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19706 = state_19668;
state_19668 = G__19706;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__2879__auto__ = function(state_19668){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__2879__auto____1.call(this,state_19668);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__2879__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__2879__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_19693 = f__2902__auto__.call(null);
(statearr_19693[(6)] = c__2901__auto__);

return statearr_19693;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"schema","schema",-1582001791),new cljs.core.Keyword(null,"t","t",-1397832519)], null));
});
