// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k27592,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__27596 = k27592;
var G__27596__$1 = (((G__27596 instanceof cljs.core.Keyword))?G__27596.fqn:null);
switch (G__27596__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k27592,else__4383__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__27597){
var vec__27598 = p__27597;
var k__4403__auto__ = cljs.core.nth.call(null,vec__27598,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__27598,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"close","close",1835149582),self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__27591){
var self__ = this;
var G__27591__$1 = this;
return (new cljs.core.RecordIter((0),G__27591__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this27593,other27594){
var self__ = this;
var this27593__$1 = this;
return (((!((other27594 == null)))) && ((this27593__$1.constructor === other27594.constructor)) && (cljs.core._EQ_.call(null,this27593__$1.conn,other27594.conn)) && (cljs.core._EQ_.call(null,this27593__$1.network,other27594.network)) && (cljs.core._EQ_.call(null,this27593__$1.dbid,other27594.dbid)) && (cljs.core._EQ_.call(null,this27593__$1.db_name,other27594.db_name)) && (cljs.core._EQ_.call(null,this27593__$1.update_chan,other27594.update_chan)) && (cljs.core._EQ_.call(null,this27593__$1.transact_chan,other27594.transact_chan)) && (cljs.core._EQ_.call(null,this27593__$1.state,other27594.state)) && (cljs.core._EQ_.call(null,this27593__$1.schema_cache,other27594.schema_cache)) && (cljs.core._EQ_.call(null,this27593__$1.blank_db,other27594.blank_db)) && (cljs.core._EQ_.call(null,this27593__$1.close,other27594.close)) && (cljs.core._EQ_.call(null,this27593__$1.id,other27594.id)) && (cljs.core._EQ_.call(null,this27593__$1.__extmap,other27594.__extmap)));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"close","close",1835149582),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__27591){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__27601 = cljs.core.keyword_identical_QMARK_;
var expr__27602 = k__4388__auto__;
if(cljs.core.truth_(pred__27601.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__27602))){
return (new fluree.db.session.DbSession(G__27591,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27601.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__27602))){
return (new fluree.db.session.DbSession(self__.conn,G__27591,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27601.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__27602))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__27591,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27601.call(null,new cljs.core.Keyword(null,"db-name","db-name",1157928745),expr__27602))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__27591,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27601.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),expr__27602))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__27591,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27601.call(null,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),expr__27602))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__27591,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27601.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__27602))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__27591,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27601.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),expr__27602))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__27591,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27601.call(null,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),expr__27602))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__27591,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27601.call(null,new cljs.core.Keyword(null,"close","close",1835149582),expr__27602))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__27591,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__27601.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__27602))){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__27591,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__27591),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"db-name","db-name",1157928745),self__.db_name,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),self__.update_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),self__.transact_chan,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"state","state",-1988618099),self__.state,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),self__.schema_cache,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),self__.blank_db,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"close","close",1835149582),self__.close,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__27591){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__27591,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"db-name","db-name",-1496507024,null),new cljs.core.Symbol(null,"update-chan","update-chan",776770735,null),new cljs.core.Symbol(null,"transact-chan","transact-chan",366882687,null),new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"schema-cache","schema-cache",1403970302,null),new cljs.core.Symbol(null,"blank-db","blank-db",1165432993,null),new cljs.core.Symbol(null,"close","close",-819286187,null),new cljs.core.Symbol(null,"id","id",252129435,null)], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__27595){
var extmap__4419__auto__ = (function (){var G__27604 = cljs.core.dissoc.call(null,G__27595,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.record_QMARK_.call(null,G__27595)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__27604);
} else {
return G__27604;
}
})();
return (new fluree.db.session.DbSession(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__27595),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__27595),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__27595),new cljs.core.Keyword(null,"db-name","db-name",1157928745).cljs$core$IFn$_invoke$arity$1(G__27595),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(G__27595),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(G__27595),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__27595),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(G__27595),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(G__27595),new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(G__27595),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__27595),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.call(null,fluree.db.session.cache_factory.call(null));
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__27606 = session;
var map__27606__$1 = (((((!((map__27606 == null))))?(((((map__27606.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27606.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27606):map__27606);
var network = cljs.core.get.call(null,map__27606__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__27606__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.call(null,c,cache_key))){
return c;
} else {
return cljs.core.assoc.call(null,c,cache_key,session);
}
}));

return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.call(null,fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_.call(null,fluree.db.session.session_cache,fluree.db.session.cache_factory.call(null));
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.call(null);
var c__2901__auto___27824 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_27751){
var state_val_27752 = (state_27751[(1)]);
if((state_val_27752 === (7))){
var state_27751__$1 = state_27751;
var statearr_27753_27825 = state_27751__$1;
(statearr_27753_27825[(2)] = false);

(statearr_27753_27825[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (20))){
var inst_27648 = (state_27751[(7)]);
var inst_27640 = (state_27751[(8)]);
var inst_27641 = (state_27751[(9)]);
var inst_27657 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27648);
var inst_27658 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27640),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27641)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27657),"."].join('');
var state_27751__$1 = state_27751;
var statearr_27754_27826 = state_27751__$1;
(statearr_27754_27826[(2)] = inst_27658);

(statearr_27754_27826[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (27))){
var inst_27732 = (state_27751[(2)]);
var state_27751__$1 = state_27751;
var statearr_27755_27827 = state_27751__$1;
(statearr_27755_27827[(2)] = inst_27732);

(statearr_27755_27827[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (1))){
var state_27751__$1 = state_27751;
var statearr_27756_27828 = state_27751__$1;
(statearr_27756_27828[(2)] = null);

(statearr_27756_27828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (24))){
var state_27751__$1 = state_27751;
var statearr_27757_27829 = state_27751__$1;
(statearr_27757_27829[(2)] = null);

(statearr_27757_27829[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (39))){
var state_27751__$1 = state_27751;
var statearr_27758_27830 = state_27751__$1;
(statearr_27758_27830[(2)] = false);

(statearr_27758_27830[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (46))){
var inst_27740 = (state_27751[(10)]);
var inst_27743 = (state_27751[(2)]);
var inst_27744 = fluree.db.util.async.throw_err.call(null,inst_27743);
var inst_27745 = cljs.core.assoc.call(null,inst_27740,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_27744);
var inst_27746 = cljs.core.async.put_BANG_.call(null,pc,inst_27745);
var _ = (function (){var statearr_27759 = state_27751;
(statearr_27759[(4)] = cljs.core.rest.call(null,(state_27751[(4)])));

return statearr_27759;
})();
var state_27751__$1 = state_27751;
var statearr_27760_27831 = state_27751__$1;
(statearr_27760_27831[(2)] = inst_27746);

(statearr_27760_27831[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (4))){
var inst_27608 = (state_27751[(2)]);
var inst_27609 = cljs.core.async.put_BANG_.call(null,pc,inst_27608);
var state_27751__$1 = state_27751;
var statearr_27761_27832 = state_27751__$1;
(statearr_27761_27832[(2)] = inst_27609);

(statearr_27761_27832[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (15))){
var inst_27648 = (state_27751[(7)]);
var inst_27647 = (state_27751[(2)]);
var inst_27648__$1 = fluree.db.util.async.throw_err.call(null,inst_27647);
var inst_27649 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_27648__$1);
var inst_27650 = cljs.core.keyword.call(null,inst_27649);
var inst_27651 = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"ready","ready",1086465795),inst_27650);
var state_27751__$1 = (function (){var statearr_27762 = state_27751;
(statearr_27762[(7)] = inst_27648__$1);

return statearr_27762;
})();
if(inst_27651){
var statearr_27763_27833 = state_27751__$1;
(statearr_27763_27833[(1)] = (16));

} else {
var statearr_27764_27834 = state_27751__$1;
(statearr_27764_27834[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (21))){
var inst_27660 = (state_27751[(2)]);
var inst_27661 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27662 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_27663 = cljs.core.PersistentHashMap.fromArrays(inst_27661,inst_27662);
var inst_27664 = cljs.core.ex_info.call(null,inst_27660,inst_27663);
var inst_27665 = (function(){throw inst_27664})();
var state_27751__$1 = state_27751;
var statearr_27765_27835 = state_27751__$1;
(statearr_27765_27835[(2)] = inst_27665);

(statearr_27765_27835[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (31))){
var inst_27687 = (state_27751[(11)]);
var inst_27686 = (state_27751[(2)]);
var inst_27687__$1 = fluree.db.util.async.throw_err.call(null,inst_27686);
var state_27751__$1 = (function (){var statearr_27766 = state_27751;
(statearr_27766[(11)] = inst_27687__$1);

return statearr_27766;
})();
if(cljs.core.truth_(inst_27687__$1)){
var statearr_27767_27836 = state_27751__$1;
(statearr_27767_27836[(1)] = (32));

} else {
var statearr_27768_27837 = state_27751__$1;
(statearr_27768_27837[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (32))){
var inst_27687 = (state_27751[(11)]);
var inst_27691 = (inst_27687 == null);
var inst_27692 = cljs.core.not.call(null,inst_27691);
var state_27751__$1 = state_27751;
if(inst_27692){
var statearr_27769_27838 = state_27751__$1;
(statearr_27769_27838[(1)] = (35));

} else {
var statearr_27770_27839 = state_27751__$1;
(statearr_27770_27839[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (40))){
var inst_27702 = (state_27751[(2)]);
var state_27751__$1 = state_27751;
var statearr_27771_27840 = state_27751__$1;
(statearr_27771_27840[(2)] = inst_27702);

(statearr_27771_27840[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (33))){
var inst_27640 = (state_27751[(8)]);
var inst_27679 = (state_27751[(12)]);
var inst_27641 = (state_27751[(9)]);
var inst_27721 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27679)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27640),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27641),"."].join('');
var inst_27722 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_27723 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_27724 = cljs.core.PersistentHashMap.fromArrays(inst_27722,inst_27723);
var inst_27725 = cljs.core.ex_info.call(null,inst_27721,inst_27724);
var inst_27726 = (function(){throw inst_27725})();
var state_27751__$1 = state_27751;
var statearr_27772_27841 = state_27751__$1;
(statearr_27772_27841[(2)] = inst_27726);

(statearr_27772_27841[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (13))){
var inst_27617 = (state_27751[(13)]);
var state_27751__$1 = state_27751;
var statearr_27773_27842 = state_27751__$1;
(statearr_27773_27842[(2)] = inst_27617);

(statearr_27773_27842[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (22))){
var inst_27648 = (state_27751[(7)]);
var inst_27673 = (state_27751[(14)]);
var inst_27672 = (state_27751[(2)]);
var inst_27673__$1 = fluree.db.util.async.throw_err.call(null,inst_27672);
var inst_27674 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27648);
var state_27751__$1 = (function (){var statearr_27774 = state_27751;
(statearr_27774[(15)] = inst_27674);

(statearr_27774[(14)] = inst_27673__$1);

return statearr_27774;
})();
if(cljs.core.truth_(inst_27673__$1)){
var statearr_27775_27843 = state_27751__$1;
(statearr_27775_27843[(1)] = (23));

} else {
var statearr_27776_27844 = state_27751__$1;
(statearr_27776_27844[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (36))){
var state_27751__$1 = state_27751;
var statearr_27777_27845 = state_27751__$1;
(statearr_27777_27845[(2)] = false);

(statearr_27777_27845[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (41))){
var inst_27687 = (state_27751[(11)]);
var inst_27707 = cljs.core.apply.call(null,cljs.core.hash_map,inst_27687);
var state_27751__$1 = state_27751;
var statearr_27778_27846 = state_27751__$1;
(statearr_27778_27846[(2)] = inst_27707);

(statearr_27778_27846[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (43))){
var inst_27678 = (state_27751[(16)]);
var inst_27710 = (state_27751[(2)]);
var inst_27711 = cljs.core.get.call(null,inst_27710,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_27712 = cljs.core.get.call(null,inst_27710,new cljs.core.Keyword(null,"block","block",664686210));
var inst_27713 = cljs.core.get.call(null,inst_27710,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_27714 = fluree.db.dbproto._with.call(null,inst_27678,inst_27712,inst_27711);
var state_27751__$1 = (function (){var statearr_27779 = state_27751;
(statearr_27779[(17)] = inst_27713);

return statearr_27779;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27751__$1,(44),inst_27714);
} else {
if((state_val_27752 === (29))){
var inst_27639 = (state_27751[(18)]);
var inst_27640 = (state_27751[(8)]);
var inst_27679 = (state_27751[(12)]);
var inst_27641 = (state_27751[(9)]);
var inst_27684 = fluree.db.storage.core.read_block.call(null,inst_27639,inst_27640,inst_27641,inst_27679);
var state_27751__$1 = state_27751;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27751__$1,(31),inst_27684);
} else {
if((state_val_27752 === (44))){
var inst_27679 = (state_27751[(12)]);
var inst_27716 = (state_27751[(2)]);
var inst_27717 = fluree.db.util.async.throw_err.call(null,inst_27716);
var inst_27718 = (inst_27679 + (1));
var inst_27678 = inst_27717;
var inst_27679__$1 = inst_27718;
var state_27751__$1 = (function (){var statearr_27780 = state_27751;
(statearr_27780[(12)] = inst_27679__$1);

(statearr_27780[(16)] = inst_27678);

return statearr_27780;
})();
var statearr_27781_27847 = state_27751__$1;
(statearr_27781_27847[(2)] = null);

(statearr_27781_27847[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (6))){
var inst_27617 = (state_27751[(13)]);
var inst_27622 = inst_27617.cljs$lang$protocol_mask$partition0$;
var inst_27623 = (inst_27622 & (64));
var inst_27624 = inst_27617.cljs$core$ISeq$;
var inst_27625 = (cljs.core.PROTOCOL_SENTINEL === inst_27624);
var inst_27626 = ((inst_27623) || (inst_27625));
var state_27751__$1 = state_27751;
if(cljs.core.truth_(inst_27626)){
var statearr_27782_27848 = state_27751__$1;
(statearr_27782_27848[(1)] = (9));

} else {
var statearr_27783_27849 = state_27751__$1;
(statearr_27783_27849[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (28))){
var inst_27678 = (state_27751[(16)]);
var state_27751__$1 = state_27751;
var statearr_27784_27850 = state_27751__$1;
(statearr_27784_27850[(2)] = inst_27678);

(statearr_27784_27850[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (25))){
var inst_27735 = (state_27751[(19)]);
var inst_27735__$1 = (state_27751[(2)]);
var inst_27736 = fluree.db.query.schema.schema_map.call(null,inst_27735__$1);
var state_27751__$1 = (function (){var statearr_27785 = state_27751;
(statearr_27785[(19)] = inst_27735__$1);

return statearr_27785;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27751__$1,(45),inst_27736);
} else {
if((state_val_27752 === (34))){
var inst_27728 = (state_27751[(2)]);
var state_27751__$1 = state_27751;
var statearr_27786_27851 = state_27751__$1;
(statearr_27786_27851[(2)] = inst_27728);

(statearr_27786_27851[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (17))){
var state_27751__$1 = state_27751;
var statearr_27787_27852 = state_27751__$1;
(statearr_27787_27852[(2)] = null);

(statearr_27787_27852[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (3))){
var inst_27749 = (state_27751[(2)]);
var state_27751__$1 = state_27751;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27751__$1,inst_27749);
} else {
if((state_val_27752 === (12))){
var inst_27617 = (state_27751[(13)]);
var inst_27635 = cljs.core.apply.call(null,cljs.core.hash_map,inst_27617);
var state_27751__$1 = state_27751;
var statearr_27788_27853 = state_27751__$1;
(statearr_27788_27853[(2)] = inst_27635);

(statearr_27788_27853[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (2))){
var inst_27617 = (state_27751[(13)]);
var _ = (function (){var statearr_27789 = state_27751;
(statearr_27789[(4)] = cljs.core.cons.call(null,(5),(state_27751[(4)])));

return statearr_27789;
})();
var inst_27616 = new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
var inst_27617__$1 = session;
var inst_27619 = (inst_27617__$1 == null);
var inst_27620 = cljs.core.not.call(null,inst_27619);
var state_27751__$1 = (function (){var statearr_27790 = state_27751;
(statearr_27790[(13)] = inst_27617__$1);

(statearr_27790[(20)] = inst_27616);

return statearr_27790;
})();
if(inst_27620){
var statearr_27791_27854 = state_27751__$1;
(statearr_27791_27854[(1)] = (6));

} else {
var statearr_27792_27855 = state_27751__$1;
(statearr_27792_27855[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (23))){
var inst_27673 = (state_27751[(14)]);
var inst_27676 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27673);
var inst_27677 = (inst_27676 + (1));
var inst_27678 = inst_27673;
var inst_27679 = inst_27677;
var state_27751__$1 = (function (){var statearr_27793 = state_27751;
(statearr_27793[(12)] = inst_27679);

(statearr_27793[(16)] = inst_27678);

return statearr_27793;
})();
var statearr_27794_27856 = state_27751__$1;
(statearr_27794_27856[(2)] = null);

(statearr_27794_27856[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (35))){
var inst_27687 = (state_27751[(11)]);
var inst_27694 = inst_27687.cljs$lang$protocol_mask$partition0$;
var inst_27695 = (inst_27694 & (64));
var inst_27696 = inst_27687.cljs$core$ISeq$;
var inst_27697 = (cljs.core.PROTOCOL_SENTINEL === inst_27696);
var inst_27698 = ((inst_27695) || (inst_27697));
var state_27751__$1 = state_27751;
if(cljs.core.truth_(inst_27698)){
var statearr_27795_27857 = state_27751__$1;
(statearr_27795_27857[(1)] = (38));

} else {
var statearr_27796_27858 = state_27751__$1;
(statearr_27796_27858[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (19))){
var inst_27640 = (state_27751[(8)]);
var inst_27641 = (state_27751[(9)]);
var inst_27655 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27640),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27641)," is not found on this ledger group."].join('');
var state_27751__$1 = state_27751;
var statearr_27797_27859 = state_27751__$1;
(statearr_27797_27859[(2)] = inst_27655);

(statearr_27797_27859[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (11))){
var inst_27630 = (state_27751[(2)]);
var state_27751__$1 = state_27751;
var statearr_27799_27860 = state_27751__$1;
(statearr_27799_27860[(2)] = inst_27630);

(statearr_27799_27860[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (9))){
var state_27751__$1 = state_27751;
var statearr_27800_27861 = state_27751__$1;
(statearr_27800_27861[(2)] = true);

(statearr_27800_27861[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (5))){
var _ = (function (){var statearr_27801 = state_27751;
(statearr_27801[(4)] = cljs.core.rest.call(null,(state_27751[(4)])));

return statearr_27801;
})();
var state_27751__$1 = state_27751;
var ex27798 = (state_27751__$1[(2)]);
var statearr_27802_27862 = state_27751__$1;
(statearr_27802_27862[(5)] = ex27798);


var statearr_27803_27863 = state_27751__$1;
(statearr_27803_27863[(1)] = (4));

(statearr_27803_27863[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (14))){
var inst_27639 = (state_27751[(18)]);
var inst_27640 = (state_27751[(8)]);
var inst_27641 = (state_27751[(9)]);
var inst_27638 = (state_27751[(2)]);
var inst_27639__$1 = cljs.core.get.call(null,inst_27638,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_27640__$1 = cljs.core.get.call(null,inst_27638,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_27641__$1 = cljs.core.get.call(null,inst_27638,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_27642 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27643 = [inst_27640__$1,inst_27641__$1];
var inst_27644 = (new cljs.core.PersistentVector(null,2,(5),inst_27642,inst_27643,null));
var inst_27645 = fluree.db.operations.ledger_info_async.call(null,inst_27639__$1,inst_27644);
var state_27751__$1 = (function (){var statearr_27804 = state_27751;
(statearr_27804[(18)] = inst_27639__$1);

(statearr_27804[(8)] = inst_27640__$1);

(statearr_27804[(9)] = inst_27641__$1);

return statearr_27804;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27751__$1,(15),inst_27645);
} else {
if((state_val_27752 === (45))){
var inst_27735 = (state_27751[(19)]);
var inst_27740 = (state_27751[(10)]);
var inst_27738 = (state_27751[(2)]);
var inst_27739 = fluree.db.util.async.throw_err.call(null,inst_27738);
var inst_27740__$1 = cljs.core.assoc.call(null,inst_27735,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_27739);
var inst_27741 = fluree.db.query.schema.setting_map.call(null,inst_27740__$1);
var state_27751__$1 = (function (){var statearr_27805 = state_27751;
(statearr_27805[(10)] = inst_27740__$1);

return statearr_27805;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27751__$1,(46),inst_27741);
} else {
if((state_val_27752 === (26))){
var inst_27674 = (state_27751[(15)]);
var inst_27679 = (state_27751[(12)]);
var inst_27681 = (inst_27679 > inst_27674);
var state_27751__$1 = state_27751;
if(cljs.core.truth_(inst_27681)){
var statearr_27806_27864 = state_27751__$1;
(statearr_27806_27864[(1)] = (28));

} else {
var statearr_27807_27865 = state_27751__$1;
(statearr_27807_27865[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (16))){
var inst_27648 = (state_27751[(7)]);
var inst_27653 = cljs.core.empty_QMARK_.call(null,inst_27648);
var state_27751__$1 = state_27751;
if(inst_27653){
var statearr_27808_27866 = state_27751__$1;
(statearr_27808_27866[(1)] = (19));

} else {
var statearr_27809_27867 = state_27751__$1;
(statearr_27809_27867[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (38))){
var state_27751__$1 = state_27751;
var statearr_27810_27868 = state_27751__$1;
(statearr_27810_27868[(2)] = true);

(statearr_27810_27868[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (30))){
var inst_27730 = (state_27751[(2)]);
var state_27751__$1 = state_27751;
var statearr_27811_27869 = state_27751__$1;
(statearr_27811_27869[(2)] = inst_27730);

(statearr_27811_27869[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (10))){
var state_27751__$1 = state_27751;
var statearr_27812_27870 = state_27751__$1;
(statearr_27812_27870[(2)] = false);

(statearr_27812_27870[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (18))){
var inst_27648 = (state_27751[(7)]);
var inst_27639 = (state_27751[(18)]);
var inst_27640 = (state_27751[(8)]);
var inst_27616 = (state_27751[(20)]);
var inst_27641 = (state_27751[(9)]);
var inst_27668 = (state_27751[(2)]);
var inst_27669 = new cljs.core.Keyword(null,"index","index",-1531685915).cljs$core$IFn$_invoke$arity$1(inst_27648);
var inst_27670 = fluree.db.storage.core.reify_db.call(null,inst_27639,inst_27640,inst_27641,inst_27616,inst_27669);
var state_27751__$1 = (function (){var statearr_27813 = state_27751;
(statearr_27813[(21)] = inst_27668);

return statearr_27813;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27751__$1,(22),inst_27670);
} else {
if((state_val_27752 === (42))){
var inst_27687 = (state_27751[(11)]);
var state_27751__$1 = state_27751;
var statearr_27814_27871 = state_27751__$1;
(statearr_27814_27871[(2)] = inst_27687);

(statearr_27814_27871[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (37))){
var inst_27705 = (state_27751[(2)]);
var state_27751__$1 = state_27751;
if(cljs.core.truth_(inst_27705)){
var statearr_27815_27872 = state_27751__$1;
(statearr_27815_27872[(1)] = (41));

} else {
var statearr_27816_27873 = state_27751__$1;
(statearr_27816_27873[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27752 === (8))){
var inst_27633 = (state_27751[(2)]);
var state_27751__$1 = state_27751;
if(cljs.core.truth_(inst_27633)){
var statearr_27817_27874 = state_27751__$1;
(statearr_27817_27874[(1)] = (12));

} else {
var statearr_27818_27875 = state_27751__$1;
(statearr_27818_27875[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__2879__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__2879__auto____0 = (function (){
var statearr_27819 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27819[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__2879__auto__);

(statearr_27819[(1)] = (1));

return statearr_27819;
});
var fluree$db$session$full_load_existing_db_$_state_machine__2879__auto____1 = (function (state_27751){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_27751);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e27820){var ex__2882__auto__ = e27820;
var statearr_27821_27876 = state_27751;
(statearr_27821_27876[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_27751[(4)]))){
var statearr_27822_27877 = state_27751;
(statearr_27822_27877[(1)] = cljs.core.first.call(null,(state_27751[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27878 = state_27751;
state_27751 = G__27878;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__2879__auto__ = function(state_27751){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__2879__auto____1.call(this,state_27751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__2879__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__2879__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_27823 = f__2902__auto__.call(null);
(statearr_27823[(6)] = c__2901__auto___27824);

return statearr_27823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.call(null,old_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.call(null,state,new cljs.core.Keyword("db","db","db/db",993247817),new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.call(null,new_db_ch,new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db.call(null,session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return new cljs.core.Keyword("db","indexed","db/indexed",390759770).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__27879 = s;
if((new cljs.core.Keyword("db","indexing","db/indexing",1754750058).cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.call(null,G__27879,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),block);
} else {
return G__27879;
}
}));

return cljs.core._EQ_.call(null,block,fluree.db.session.indexing_QMARK_.call(null,session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword("db","indexed","db/indexed",390759770),block);
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.call(null,cljs.cache.lru_cache_factory.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"threshold","threshold",204221583),(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(conn,network,alias){
var or__4126__auto__ = cljs.core.get_in.call(null,cljs.core.deref.call(null,fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.call(null,fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_.call(null,ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.call(null,ledger);
var network = cljs.core.namespace.call(null,ledger__$1);
var maybe_alias = cljs.core.name.call(null,ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4115__auto__ = network;
if(cljs.core.truth_(and__4115__auto__)){
return maybe_alias;
} else {
return and__4115__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.call(null,["Invalid ledger identity: ",cljs.core.pr_str.call(null,ledger__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-db","db/invalid-db",1792041482)], null))})());
if(clojure.string.starts_with_QMARK_.call(null,maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.call(null,maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id.call(null,conn,network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),(function (_,___$1,___$2){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_27881){
var state_val_27882 = (state_27881[(1)]);
if((state_val_27882 === (1))){
var state_27881__$1 = state_27881;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27881__$1,new cljs.core.Keyword("fluree.db.session","no-op","fluree.db.session/no-op",1159713170));
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2879__auto__ = null;
var fluree$db$session$state_machine__2879__auto____0 = (function (){
var statearr_27883 = [null,null,null,null,null,null,null];
(statearr_27883[(0)] = fluree$db$session$state_machine__2879__auto__);

(statearr_27883[(1)] = (1));

return statearr_27883;
});
var fluree$db$session$state_machine__2879__auto____1 = (function (state_27881){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_27881);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e27884){var ex__2882__auto__ = e27884;
var statearr_27885_27888 = state_27881;
(statearr_27885_27888[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_27881[(4)]))){
var statearr_27886_27889 = state_27881;
(statearr_27886_27889[(1)] = cljs.core.first.call(null,(state_27881[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27890 = state_27881;
state_27881 = G__27890;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$session$state_machine__2879__auto__ = function(state_27881){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2879__auto____1.call(this,state_27881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2879__auto____0;
fluree$db$session$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2879__auto____1;
return fluree$db$session$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_27887 = f__2902__auto__.call(null);
(statearr_27887[(6)] = c__2901__auto__);

return statearr_27887;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"block","block",664686210),(function (session,event_type,p__27892){
var map__27893 = p__27892;
var map__27893__$1 = (((((!((map__27893 == null))))?(((((map__27893.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__27893.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__27893):map__27893);
var data = map__27893__$1;
var block = cljs.core.get.call(null,map__27893__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__27893__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var flakes = cljs.core.get.call(null,map__27893__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_27953){
var state_val_27954 = (state_27953[(1)]);
if((state_val_27954 === (7))){
var inst_27908 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27909 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27910 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27908),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27909),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_27911 = fluree.db.util.log.info.call(null,inst_27910);
var state_27953__$1 = state_27953;
var statearr_27955_27989 = state_27953__$1;
(statearr_27955_27989[(2)] = inst_27911);

(statearr_27955_27989[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27954 === (1))){
var state_27953__$1 = state_27953;
var statearr_27956_27990 = state_27953__$1;
(statearr_27956_27990[(2)] = null);

(statearr_27956_27990[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27954 === (4))){
var inst_27895 = (state_27953[(2)]);
var state_27953__$1 = state_27953;
var statearr_27957_27991 = state_27953__$1;
(statearr_27957_27991[(2)] = inst_27895);

(statearr_27957_27991[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27954 === (15))){
var inst_27934 = (state_27953[(2)]);
var state_27953__$1 = state_27953;
var statearr_27958_27992 = state_27953__$1;
(statearr_27958_27992[(2)] = inst_27934);

(statearr_27958_27992[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27954 === (13))){
var inst_27925 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(session);
var inst_27926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27927 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27928 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27929 = [inst_27927,inst_27928];
var inst_27930 = (new cljs.core.PersistentVector(null,2,(5),inst_27926,inst_27929,null));
var inst_27931 = fluree.db.conn_events.process_event.call(null,inst_27925,new cljs.core.Keyword(null,"local-ledger-update","local-ledger-update",-2135302117),inst_27930,data);
var state_27953__$1 = state_27953;
var statearr_27959_27993 = state_27953__$1;
(statearr_27959_27993[(2)] = inst_27931);

(statearr_27959_27993[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27954 === (6))){
var inst_27905 = (state_27953[(7)]);
var inst_27904 = (state_27953[(8)]);
var inst_27903 = (state_27953[(2)]);
var inst_27904__$1 = fluree.db.util.async.throw_err.call(null,inst_27903);
var inst_27905__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_27904__$1);
var inst_27906 = (block <= inst_27905__$1);
var state_27953__$1 = (function (){var statearr_27960 = state_27953;
(statearr_27960[(7)] = inst_27905__$1);

(statearr_27960[(8)] = inst_27904__$1);

return statearr_27960;
})();
if(cljs.core.truth_(inst_27906)){
var statearr_27961_27994 = state_27953__$1;
(statearr_27961_27994[(1)] = (7));

} else {
var statearr_27962_27995 = state_27953__$1;
(statearr_27962_27995[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27954 === (17))){
var state_27953__$1 = state_27953;
var statearr_27963_27996 = state_27953__$1;
(statearr_27963_27996[(2)] = null);

(statearr_27963_27996[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27954 === (3))){
var inst_27951 = (state_27953[(2)]);
var state_27953__$1 = state_27953;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27953__$1,inst_27951);
} else {
if((state_val_27954 === (12))){
var inst_27946 = (state_27953[(2)]);
var state_27953__$1 = state_27953;
var statearr_27964_27997 = state_27953__$1;
(statearr_27964_27997[(2)] = inst_27946);

(statearr_27964_27997[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27954 === (2))){
var inst_27901 = (state_27953[(9)]);
var _ = (function (){var statearr_27965 = state_27953;
(statearr_27965[(4)] = cljs.core.cons.call(null,(5),(state_27953[(4)])));

return statearr_27965;
})();
var inst_27901__$1 = fluree.db.session.current_db.call(null,session);
var state_27953__$1 = (function (){var statearr_27966 = state_27953;
(statearr_27966[(9)] = inst_27901__$1);

return statearr_27966;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27953__$1,(6),inst_27901__$1);
} else {
if((state_val_27954 === (11))){
var state_27953__$1 = state_27953;
var statearr_27968_27998 = state_27953__$1;
(statearr_27968_27998[(1)] = (16));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27954 === (9))){
var inst_27948 = (state_27953[(2)]);
var _ = (function (){var statearr_27970 = state_27953;
(statearr_27970[(4)] = cljs.core.rest.call(null,(state_27953[(4)])));

return statearr_27970;
})();
var state_27953__$1 = state_27953;
var statearr_27971_27999 = state_27953__$1;
(statearr_27971_27999[(2)] = inst_27948);

(statearr_27971_27999[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27954 === (5))){
var _ = (function (){var statearr_27972 = state_27953;
(statearr_27972[(4)] = cljs.core.rest.call(null,(state_27953[(4)])));

return statearr_27972;
})();
var state_27953__$1 = state_27953;
var ex27967 = (state_27953__$1[(2)]);
var statearr_27973_28000 = state_27953__$1;
(statearr_27973_28000[(5)] = ex27967);


if((ex27967 instanceof Error)){
var statearr_27974_28001 = state_27953__$1;
(statearr_27974_28001[(1)] = (4));

(statearr_27974_28001[(5)] = null);

} else {
throw ex27967;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27954 === (14))){
var state_27953__$1 = state_27953;
var statearr_27975_28002 = state_27953__$1;
(statearr_27975_28002[(2)] = null);

(statearr_27975_28002[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27954 === (16))){
var inst_27905 = (state_27953[(7)]);
var inst_27937 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27938 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27939 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27937),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27938),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27905),". Forcing a db reload."].join('');
var inst_27940 = fluree.db.util.log.info.call(null,inst_27939);
var inst_27941 = fluree.db.session.reload_db_BANG_.call(null,session);
var state_27953__$1 = (function (){var statearr_27976 = state_27953;
(statearr_27976[(10)] = inst_27940);

return statearr_27976;
})();
var statearr_27977_28003 = state_27953__$1;
(statearr_27977_28003[(2)] = inst_27941);

(statearr_27977_28003[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27954 === (10))){
var inst_27905 = (state_27953[(7)]);
var inst_27901 = (state_27953[(9)]);
var inst_27904 = (state_27953[(8)]);
var inst_27916 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_27917 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_27918 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27916),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27917),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_27919 = fluree.db.util.log.trace.call(null,inst_27918);
var inst_27920 = (function (){var current_db_ch = inst_27901;
var current_db = inst_27904;
var current_block = inst_27905;
return (function (p1__27891_SHARP_){
if((p1__27891_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__27891_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.call(null,p1__27891_SHARP_);
}
});
})();
var inst_27921 = cljs.core.map.call(null,inst_27920,flakes);
var inst_27922 = fluree.db.dbproto._with.call(null,inst_27904,block,inst_27921);
var inst_27923 = fluree.db.session.cas_db_BANG_.call(null,session,inst_27901,inst_27922);
var state_27953__$1 = (function (){var statearr_27978 = state_27953;
(statearr_27978[(11)] = inst_27919);

return statearr_27978;
})();
if(inst_27923){
var statearr_27979_28004 = state_27953__$1;
(statearr_27979_28004[(1)] = (13));

} else {
var statearr_27980_28005 = state_27953__$1;
(statearr_27980_28005[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27954 === (18))){
var inst_27944 = (state_27953[(2)]);
var state_27953__$1 = state_27953;
var statearr_27981_28006 = state_27953__$1;
(statearr_27981_28006[(2)] = inst_27944);

(statearr_27981_28006[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_27954 === (8))){
var inst_27905 = (state_27953[(7)]);
var inst_27913 = ((1) + inst_27905);
var inst_27914 = cljs.core._EQ_.call(null,block,inst_27913);
var state_27953__$1 = state_27953;
if(inst_27914){
var statearr_27982_28007 = state_27953__$1;
(statearr_27982_28007[(1)] = (10));

} else {
var statearr_27983_28008 = state_27953__$1;
(statearr_27983_28008[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2879__auto__ = null;
var fluree$db$session$state_machine__2879__auto____0 = (function (){
var statearr_27984 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27984[(0)] = fluree$db$session$state_machine__2879__auto__);

(statearr_27984[(1)] = (1));

return statearr_27984;
});
var fluree$db$session$state_machine__2879__auto____1 = (function (state_27953){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_27953);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e27985){var ex__2882__auto__ = e27985;
var statearr_27986_28009 = state_27953;
(statearr_27986_28009[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_27953[(4)]))){
var statearr_27987_28010 = state_27953;
(statearr_27987_28010[(1)] = cljs.core.first.call(null,(state_27953[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28011 = state_27953;
state_27953 = G__28011;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$session$state_machine__2879__auto__ = function(state_27953){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2879__auto____1.call(this,state_27953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2879__auto____0;
fluree$db$session$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2879__auto____1;
return fluree$db$session$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_27988 = f__2902__auto__.call(null);
(statearr_27988[(6)] = c__2901__auto__);

return statearr_27988;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));
cljs.core._add_method.call(null,fluree.db.session.process_ledger_update,new cljs.core.Keyword(null,"new-index","new-index",518435631),(function (session,header,block){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_28018){
var state_val_28019 = (state_28018[(1)]);
if((state_val_28019 === (1))){
var inst_28012 = fluree.db.session.clear_db_BANG_.call(null,session);
var inst_28013 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(session);
var inst_28014 = new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(session);
var inst_28015 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28013),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28014)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_28016 = fluree.db.util.log.debug.call(null,inst_28015);
var state_28018__$1 = (function (){var statearr_28020 = state_28018;
(statearr_28020[(7)] = inst_28016);

(statearr_28020[(8)] = inst_28012);

return statearr_28020;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28018__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__2879__auto__ = null;
var fluree$db$session$state_machine__2879__auto____0 = (function (){
var statearr_28021 = [null,null,null,null,null,null,null,null,null];
(statearr_28021[(0)] = fluree$db$session$state_machine__2879__auto__);

(statearr_28021[(1)] = (1));

return statearr_28021;
});
var fluree$db$session$state_machine__2879__auto____1 = (function (state_28018){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_28018);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e28022){var ex__2882__auto__ = e28022;
var statearr_28023_28026 = state_28018;
(statearr_28023_28026[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_28018[(4)]))){
var statearr_28024_28027 = state_28018;
(statearr_28024_28027[(1)] = cljs.core.first.call(null,(state_28018[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28028 = state_28018;
state_28018 = G__28028;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$session$state_machine__2879__auto__ = function(state_28018){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2879__auto____1.call(this,state_28018);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2879__auto____0;
fluree$db$session$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2879__auto____1;
return fluree$db$session$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_28025 = f__2902__auto__.call(null);
(statearr_28025[(6)] = c__2901__auto__);

return statearr_28025;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return new cljs.core.Keyword(null,"closed?","closed?",-1408769040).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__28030 = arguments.length;
switch (G__28030) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_.call(null,session))){
return false;
} else {
var map__28031 = session;
var map__28031__$1 = (((((!((map__28031 == null))))?(((((map__28031.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28031.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28031):map__28031);
var conn = cljs.core.get.call(null,map__28031__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var update_chan = cljs.core.get.call(null,map__28031__$1,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792));
var transact_chan = cljs.core.get.call(null,map__28031__$1,new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840));
var state = cljs.core.get.call(null,map__28031__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var network = cljs.core.get.call(null,map__28031__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__28031__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var id = cljs.core.get.call(null,map__28031__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var closed_QMARK_ = fluree.db.session.closed_QMARK_.call(null,session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

return false;
} else {
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),true);

new cljs.core.Keyword(null,"remove-listener","remove-listener",-418647802).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,dbid,id);

cljs.core.async.close_BANG_.call(null,update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_.call(null,transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_.call(null,network,dbid);

if(cljs.core.fn_QMARK_.call(null,new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session))){
new cljs.core.Keyword(null,"close","close",1835149582).cljs$core$IFn$_invoke$arity$1(session).call(null);
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5733__auto__ = fluree.db.session.from_cache.call(null,network,dbid);
if(cljs.core.truth_(temp__5733__auto__)){
var session = temp__5733__auto__;
return fluree.db.session.close.call(null,session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_28086){
var state_val_28087 = (state_28086[(1)]);
if((state_val_28087 === (7))){
var inst_28082 = (state_28086[(2)]);
var state_28086__$1 = state_28086;
var statearr_28088_28119 = state_28086__$1;
(statearr_28088_28119[(2)] = inst_28082);

(statearr_28088_28119[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28087 === (1))){
var state_28086__$1 = state_28086;
var statearr_28089_28120 = state_28086__$1;
(statearr_28089_28120[(2)] = null);

(statearr_28089_28120[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28087 === (4))){
var inst_28037 = (state_28086[(7)]);
var inst_28036 = (state_28086[(2)]);
var inst_28037__$1 = fluree.db.util.async.throw_err.call(null,inst_28036);
var inst_28038 = fluree.db.session.from_cache.call(null,network,ledger_id);
var inst_28039 = (inst_28037__$1 == null);
var state_28086__$1 = (function (){var statearr_28090 = state_28086;
(statearr_28090[(8)] = inst_28038);

(statearr_28090[(7)] = inst_28037__$1);

return statearr_28090;
})();
if(cljs.core.truth_(inst_28039)){
var statearr_28091_28121 = state_28086__$1;
(statearr_28091_28121[(1)] = (5));

} else {
var statearr_28092_28122 = state_28086__$1;
(statearr_28092_28122[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28087 === (15))){
var inst_28074 = (state_28086[(2)]);
var state_28086__$1 = (function (){var statearr_28093 = state_28086;
(statearr_28093[(9)] = inst_28074);

return statearr_28093;
})();
var statearr_28094_28123 = state_28086__$1;
(statearr_28094_28123[(2)] = null);

(statearr_28094_28123[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28087 === (13))){
var inst_28078 = (state_28086[(2)]);
var state_28086__$1 = state_28086;
var statearr_28096_28124 = state_28086__$1;
(statearr_28096_28124[(2)] = inst_28078);

(statearr_28096_28124[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28087 === (6))){
var inst_28038 = (state_28086[(8)]);
var inst_28044 = (inst_28038 == null);
var state_28086__$1 = state_28086;
if(cljs.core.truth_(inst_28044)){
var statearr_28097_28125 = state_28086__$1;
(statearr_28097_28125[(1)] = (8));

} else {
var statearr_28098_28126 = state_28086__$1;
(statearr_28098_28126[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28087 === (17))){
var _ = (function (){var statearr_28099 = state_28086;
(statearr_28099[(4)] = cljs.core.rest.call(null,(state_28086[(4)])));

return statearr_28099;
})();
var state_28086__$1 = state_28086;
var ex28095 = (state_28086__$1[(2)]);
var statearr_28100_28127 = state_28086__$1;
(statearr_28100_28127[(5)] = ex28095);


var statearr_28101_28128 = state_28086__$1;
(statearr_28101_28128[(1)] = (16));

(statearr_28101_28128[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28087 === (3))){
var inst_28084 = (state_28086[(2)]);
var state_28086__$1 = state_28086;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28086__$1,inst_28084);
} else {
if((state_val_28087 === (12))){
var state_28086__$1 = state_28086;
var statearr_28102_28129 = state_28086__$1;
(statearr_28102_28129[(2)] = null);

(statearr_28102_28129[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28087 === (2))){
var state_28086__$1 = state_28086;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28086__$1,(4),update_chan);
} else {
if((state_val_28087 === (11))){
var state_28086__$1 = state_28086;
var statearr_28103_28130 = state_28086__$1;
(statearr_28103_28130[(2)] = null);

(statearr_28103_28130[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28087 === (9))){
var state_28086__$1 = state_28086;
var statearr_28104_28131 = state_28086__$1;
(statearr_28104_28131[(1)] = (11));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28087 === (5))){
var inst_28041 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_28042 = fluree.db.util.log.info.call(null,inst_28041);
var state_28086__$1 = state_28086;
var statearr_28106_28132 = state_28086__$1;
(statearr_28106_28132[(2)] = inst_28042);

(statearr_28106_28132[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28087 === (14))){
var inst_28038 = (state_28086[(8)]);
var inst_28037 = (state_28086[(7)]);
var _ = (function (){var statearr_28107 = state_28086;
(statearr_28107[(4)] = cljs.core.cons.call(null,(17),(state_28086[(4)])));

return statearr_28107;
})();
var inst_28062 = cljs.core.nth.call(null,inst_28037,(0),null);
var inst_28063 = cljs.core.nth.call(null,inst_28037,(1),null);
var inst_28064 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_28065 = cljs.core.pr_str.call(null,inst_28037);
var inst_28066 = fluree.db.util.core.trunc.call(null,inst_28065,(200));
var inst_28067 = fluree.db.util.log.trace.call(null,inst_28064,inst_28066);
var inst_28068 = fluree.db.session.process_ledger_update.call(null,inst_28038,inst_28062,inst_28063);
var state_28086__$1 = (function (){var statearr_28108 = state_28086;
(statearr_28108[(10)] = inst_28067);

return statearr_28108;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28086__$1,(18),inst_28068);
} else {
if((state_val_28087 === (16))){
var inst_28037 = (state_28086[(7)]);
var inst_28052 = (state_28086[(2)]);
var inst_28053 = fluree.db.util.log.error.call(null,inst_28052,"Exception processing ledger updates for message: ",inst_28037);
var state_28086__$1 = state_28086;
var statearr_28109_28133 = state_28086__$1;
(statearr_28109_28133[(2)] = inst_28053);

(statearr_28109_28133[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28087 === (10))){
var inst_28080 = (state_28086[(2)]);
var state_28086__$1 = state_28086;
var statearr_28110_28134 = state_28086__$1;
(statearr_28110_28134[(2)] = inst_28080);

(statearr_28110_28134[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28087 === (18))){
var inst_28070 = (state_28086[(2)]);
var inst_28071 = fluree.db.util.async.throw_err.call(null,inst_28070);
var _ = (function (){var statearr_28111 = state_28086;
(statearr_28111[(4)] = cljs.core.rest.call(null,(state_28086[(4)])));

return statearr_28111;
})();
var state_28086__$1 = state_28086;
var statearr_28112_28135 = state_28086__$1;
(statearr_28112_28135[(2)] = inst_28071);

(statearr_28112_28135[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28087 === (8))){
var inst_28037 = (state_28086[(7)]);
var inst_28046 = cljs.core.first.call(null,inst_28037);
var inst_28047 = cljs.core.pr_str.call(null,inst_28046);
var inst_28048 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_28047].join('');
var inst_28049 = fluree.db.util.log.warn.call(null,inst_28048);
var state_28086__$1 = state_28086;
var statearr_28113_28136 = state_28086__$1;
(statearr_28113_28136[(2)] = inst_28049);

(statearr_28113_28136[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__2879__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__2879__auto____0 = (function (){
var statearr_28114 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28114[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__2879__auto__);

(statearr_28114[(1)] = (1));

return statearr_28114;
});
var fluree$db$session$process_ledger_updates_$_state_machine__2879__auto____1 = (function (state_28086){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_28086);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e28115){var ex__2882__auto__ = e28115;
var statearr_28116_28137 = state_28086;
(statearr_28116_28137[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_28086[(4)]))){
var statearr_28117_28138 = state_28086;
(statearr_28117_28138[(1)] = cljs.core.first.call(null,(state_28086[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28139 = state_28086;
state_28086 = G__28139;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__2879__auto__ = function(state_28086){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__2879__auto____1.call(this,state_28086);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__2879__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__2879__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_28118 = f__2902__auto__.call(null);
(statearr_28118[(6)] = c__2901__auto__);

return statearr_28118;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__28140){
var map__28141 = p__28140;
var map__28141__$1 = (((((!((map__28141 == null))))?(((((map__28141.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28141.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28141):map__28141);
var network = cljs.core.get.call(null,map__28141__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var conn = cljs.core.get.call(null,map__28141__$1,new cljs.core.Keyword(null,"conn","conn",278309663));
var dbid = cljs.core.get.call(null,map__28141__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var db = cljs.core.get.call(null,map__28141__$1,new cljs.core.Keyword(null,"db","db",993250759));
var transactor_QMARK_ = cljs.core.get.call(null,map__28141__$1,new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057));
var db_name = cljs.core.get.call(null,map__28141__$1,new cljs.core.Keyword(null,"db-name","db-name",1157928745));
var state = cljs.core.get.call(null,map__28141__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var close = cljs.core.get.call(null,map__28141__$1,new cljs.core.Keyword(null,"close","close",1835149582));
var id = cljs.core.get.call(null,map__28141__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var schema_cache = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.call(null);
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.call(null):null);
var state__$1 = cljs.core.atom.call(null,cljs.core.merge.call(null,state,new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword("req","sync","req/sync",-624297648),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("req","count","req/count",2145574363),(0),new cljs.core.Keyword("req","last","req/last",1105783038),null,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword("db","db","db/db",993247817),(cljs.core.truth_(db)?cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),schema_cache):null),new cljs.core.Keyword("db","indexing","db/indexing",1754750058),null,new cljs.core.Keyword(null,"closed?","closed?",-1408769040),false], null)));
var session = fluree.db.session.map__GT_DbSession.call(null,cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"update-chan","update-chan",-863760792),new cljs.core.Keyword(null,"db-name","db-name",1157928745),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"close","close",1835149582),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225),new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),new cljs.core.Keyword(null,"conn","conn",278309663)],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return fluree.db.session.current_db.call(null,session);
});
var blank_db = fluree.db.graphdb.blank_db.call(null,conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.call(null,session,new cljs.core.Keyword(null,"blank-db","blank-db",-475098534),blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__28146 = block_result;
var map__28146__$1 = (((((!((map__28146 == null))))?(((((map__28146.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28146.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28146):map__28146);
var block = cljs.core.get.call(null,map__28146__$1,new cljs.core.Keyword(null,"block","block",664686210));
var hash = cljs.core.get.call(null,map__28146__$1,new cljs.core.Keyword(null,"hash","hash",-13781596));
var instant = cljs.core.get.call(null,map__28146__$1,new cljs.core.Keyword(null,"instant","instant",655498374));
var txns = cljs.core.get.call(null,map__28146__$1,new cljs.core.Keyword(null,"txns","txns",-1492102421));
var flakes = cljs.core.get.call(null,map__28146__$1,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var tx_result = (function (){var or__4126__auto__ = cljs.core.get.call(null,txns,cljs.core.keyword.call(null,txid));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.call(null,txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.call(null,["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597),new cljs.core.Keyword(null,"block","block",664686210),cljs.core.pr_str.call(null,block_result)], null))})());
var map__28147 = tx_result;
var map__28147__$1 = (((((!((map__28147 == null))))?(((((map__28147.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28147.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28147):map__28147);
var t = cljs.core.get.call(null,map__28147__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var status = cljs.core.get.call(null,map__28147__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var t_filter = (((cljs.core.first.call(null,flakes) instanceof fluree.db.flake.Flake))?(function (p1__28143_SHARP_){
return cljs.core._EQ_.call(null,t,p1__28143_SHARP_.t);
}):(function (p1__28144_SHARP_){
return cljs.core._EQ_.call(null,t,cljs.core.nth.call(null,p1__28144_SHARP_,(3)));
}));
var response = cljs.core.assoc.call(null,tx_result,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"hash","hash",-13781596),hash,new cljs.core.Keyword(null,"instant","instant",655498374),instant,new cljs.core.Keyword(null,"flakes","flakes",1977895739),cljs.core.filter.call(null,t_filter,flakes));
if((new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some.call(null,(function (p1__28145_SHARP_){
if(cljs.core._EQ_.call(null,(109),cljs.core.second.call(null,p1__28145_SHARP_))){
return cljs.core.nth.call(null,p1__28145_SHARP_,(2));
} else {
return null;
}
}),new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(response));
var vec__28150 = (cljs.core.truth_(error_msg)?cljs.core.re_find.call(null,/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.call(null,vec__28150,(0),null);
var status__$1 = cljs.core.nth.call(null,vec__28150,(1),null);
var error = cljs.core.nth.call(null,vec__28150,(2),null);
var message = cljs.core.nth.call(null,vec__28150,(3),null);
return cljs.core.ex_info.call(null,(function (){var or__4126__auto__ = message;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response),new cljs.core.Keyword(null,"error","error",-978969032),cljs.core.keyword.call(null,error),new cljs.core.Keyword(null,"meta","meta",1499536964),response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.call(null,"Create and cache session. Opt keys: ",cljs.core.keys.call(null,opts));
var id = cljs.core.keyword.call(null,"session",cljs.core.subs.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid.call(null)),(0),(7)));
var session = fluree.db.session.session_factory.call(null,cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"id","id",-1388402092),id));
var session_STAR_ = fluree.db.session.cache_BANG_.call(null,session);
var new_QMARK_ = cljs.core._EQ_.call(null,id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.call(null,session_STAR_,new cljs.core.Keyword(null,"new?","new?",777958557),true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__28154 = arguments.length;
switch (G__28154) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.call(null,conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__28155){
var map__28156 = p__28155;
var map__28156__$1 = (((((!((map__28156 == null))))?(((((map__28156.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28156.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28156):map__28156);
var state = cljs.core.get.call(null,map__28156__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var connect_QMARK_ = cljs.core.get.call(null,map__28156__$1,new cljs.core.Keyword(null,"connect?","connect?",1326309520));
var auth = cljs.core.get.call(null,map__28156__$1,new cljs.core.Keyword(null,"auth","auth",1389754926));
var jwt = cljs.core.get.call(null,map__28156__$1,new cljs.core.Keyword(null,"jwt","jwt",1504015441));
var vec__28158 = fluree.db.session.resolve_ledger.call(null,conn,ledger);
var network = cljs.core.nth.call(null,vec__28158,(0),null);
var ledger_id = cljs.core.nth.call(null,vec__28158,(1),null);
var ledger_alias = cljs.core.nth.call(null,vec__28158,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057).cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt], null));
var or__4126__auto__ = fluree.db.session.from_cache.call(null,network,ledger_id);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var session = fluree.db.session.create_and_cache_session.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),ledger_id,new cljs.core.Keyword(null,"db-name","db-name",1157928745),null,new cljs.core.Keyword(null,"auth","auth",1389754926),auth,new cljs.core.Keyword(null,"jwt","jwt",1504015441),jwt,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"state","state",-1988618099),(function (){var or__4126__auto____$1 = state;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),new cljs.core.Keyword(null,"transactor?","transactor?",-1901072057),transactor_QMARK_], null));
var new_QMARK_ = new cljs.core.Keyword(null,"new?","new?",777958557).cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.call(null,session,opts);

new cljs.core.Keyword(null,"add-listener","add-listener",313698051).cljs$core$IFn$_invoke$arity$1(conn).call(null,network,ledger_id,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(session),(function (event_type,event_data){
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"block","block",664686210),event_type)){
var temp__5735__auto__ = cljs.core.not_empty.call(null,cljs.core.get.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620)));
if(cljs.core.truth_(temp__5735__auto__)){
var tx_callbacks = temp__5735__auto__;
var tids = cljs.core.keys.call(null,new cljs.core.Keyword(null,"txns","txns",-1492102421).cljs$core$IFn$_invoke$arity$1(event_data));
var seq__28161 = cljs.core.seq.call(null,tids);
var chunk__28162 = null;
var count__28163 = (0);
var i__28164 = (0);
while(true){
if((i__28164 < count__28163)){
var tid = cljs.core._nth.call(null,chunk__28162,i__28164);
var temp__5735__auto___28277__$1 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5735__auto___28277__$1)){
var keyed_callbacks_28278 = temp__5735__auto___28277__$1;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_28279 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__28205_28280 = cljs.core.seq.call(null,keyed_callbacks_28278);
var chunk__28206_28281 = null;
var count__28207_28282 = (0);
var i__28208_28283 = (0);
while(true){
if((i__28208_28283 < count__28207_28282)){
var vec__28217_28284 = cljs.core._nth.call(null,chunk__28206_28281,i__28208_28283);
var k_28285 = cljs.core.nth.call(null,vec__28217_28284,(0),null);
var f_28286 = cljs.core.nth.call(null,vec__28217_28284,(1),null);
try{f_28286.call(null,tx_response_28279);
}catch (e28220){var e_28287 = e28220;
fluree.db.util.log.error.call(null,e_28287,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__28288 = seq__28205_28280;
var G__28289 = chunk__28206_28281;
var G__28290 = count__28207_28282;
var G__28291 = (i__28208_28283 + (1));
seq__28205_28280 = G__28288;
chunk__28206_28281 = G__28289;
count__28207_28282 = G__28290;
i__28208_28283 = G__28291;
continue;
} else {
var temp__5735__auto___28292__$2 = cljs.core.seq.call(null,seq__28205_28280);
if(temp__5735__auto___28292__$2){
var seq__28205_28293__$1 = temp__5735__auto___28292__$2;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28205_28293__$1)){
var c__4556__auto___28294 = cljs.core.chunk_first.call(null,seq__28205_28293__$1);
var G__28295 = cljs.core.chunk_rest.call(null,seq__28205_28293__$1);
var G__28296 = c__4556__auto___28294;
var G__28297 = cljs.core.count.call(null,c__4556__auto___28294);
var G__28298 = (0);
seq__28205_28280 = G__28295;
chunk__28206_28281 = G__28296;
count__28207_28282 = G__28297;
i__28208_28283 = G__28298;
continue;
} else {
var vec__28221_28299 = cljs.core.first.call(null,seq__28205_28293__$1);
var k_28300 = cljs.core.nth.call(null,vec__28221_28299,(0),null);
var f_28301 = cljs.core.nth.call(null,vec__28221_28299,(1),null);
try{f_28301.call(null,tx_response_28279);
}catch (e28224){var e_28302 = e28224;
fluree.db.util.log.error.call(null,e_28302,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__28303 = cljs.core.next.call(null,seq__28205_28293__$1);
var G__28304 = null;
var G__28305 = (0);
var G__28306 = (0);
seq__28205_28280 = G__28303;
chunk__28206_28281 = G__28304;
count__28207_28282 = G__28305;
i__28208_28283 = G__28306;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28307 = seq__28161;
var G__28308 = chunk__28162;
var G__28309 = count__28163;
var G__28310 = (i__28164 + (1));
seq__28161 = G__28307;
chunk__28162 = G__28308;
count__28163 = G__28309;
i__28164 = G__28310;
continue;
} else {
var temp__5735__auto____$1 = cljs.core.seq.call(null,seq__28161);
if(temp__5735__auto____$1){
var seq__28161__$1 = temp__5735__auto____$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28161__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__28161__$1);
var G__28311 = cljs.core.chunk_rest.call(null,seq__28161__$1);
var G__28312 = c__4556__auto__;
var G__28313 = cljs.core.count.call(null,c__4556__auto__);
var G__28314 = (0);
seq__28161 = G__28311;
chunk__28162 = G__28312;
count__28163 = G__28313;
i__28164 = G__28314;
continue;
} else {
var tid = cljs.core.first.call(null,seq__28161__$1);
var temp__5735__auto___28315__$2 = cljs.core.get.call(null,tx_callbacks,fluree.db.util.core.keyword__GT_str.call(null,tid));
if(cljs.core.truth_(temp__5735__auto___28315__$2)){
var keyed_callbacks_28316 = temp__5735__auto___28315__$2;
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),cljs.core.dissoc,fluree.db.util.core.keyword__GT_str.call(null,tid));

var tx_response_28317 = fluree.db.session.block_response__GT_tx_response.call(null,event_data,tid);
var seq__28225_28318 = cljs.core.seq.call(null,keyed_callbacks_28316);
var chunk__28226_28319 = null;
var count__28227_28320 = (0);
var i__28228_28321 = (0);
while(true){
if((i__28228_28321 < count__28227_28320)){
var vec__28237_28322 = cljs.core._nth.call(null,chunk__28226_28319,i__28228_28321);
var k_28323 = cljs.core.nth.call(null,vec__28237_28322,(0),null);
var f_28324 = cljs.core.nth.call(null,vec__28237_28322,(1),null);
try{f_28324.call(null,tx_response_28317);
}catch (e28240){var e_28325 = e28240;
fluree.db.util.log.error.call(null,e_28325,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__28326 = seq__28225_28318;
var G__28327 = chunk__28226_28319;
var G__28328 = count__28227_28320;
var G__28329 = (i__28228_28321 + (1));
seq__28225_28318 = G__28326;
chunk__28226_28319 = G__28327;
count__28227_28320 = G__28328;
i__28228_28321 = G__28329;
continue;
} else {
var temp__5735__auto___28330__$3 = cljs.core.seq.call(null,seq__28225_28318);
if(temp__5735__auto___28330__$3){
var seq__28225_28331__$1 = temp__5735__auto___28330__$3;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28225_28331__$1)){
var c__4556__auto___28332 = cljs.core.chunk_first.call(null,seq__28225_28331__$1);
var G__28333 = cljs.core.chunk_rest.call(null,seq__28225_28331__$1);
var G__28334 = c__4556__auto___28332;
var G__28335 = cljs.core.count.call(null,c__4556__auto___28332);
var G__28336 = (0);
seq__28225_28318 = G__28333;
chunk__28226_28319 = G__28334;
count__28227_28320 = G__28335;
i__28228_28321 = G__28336;
continue;
} else {
var vec__28241_28337 = cljs.core.first.call(null,seq__28225_28331__$1);
var k_28338 = cljs.core.nth.call(null,vec__28241_28337,(0),null);
var f_28339 = cljs.core.nth.call(null,vec__28241_28337,(1),null);
try{f_28339.call(null,tx_response_28317);
}catch (e28244){var e_28340 = e28244;
fluree.db.util.log.error.call(null,e_28340,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join(''));
}

var G__28341 = cljs.core.next.call(null,seq__28225_28331__$1);
var G__28342 = null;
var G__28343 = (0);
var G__28344 = (0);
seq__28225_28318 = G__28341;
chunk__28226_28319 = G__28342;
count__28227_28320 = G__28343;
i__28228_28321 = G__28344;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__28345 = cljs.core.next.call(null,seq__28161__$1);
var G__28346 = null;
var G__28347 = (0);
var G__28348 = (0);
seq__28161 = G__28345;
chunk__28162 = G__28346;
count__28163 = G__28347;
i__28164 = G__28348;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
}));

fluree.db.session.process_ledger_updates.call(null,conn,network,ledger_id,new cljs.core.Keyword(null,"update-chan","update-chan",-863760792).cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_28349 = new cljs.core.Keyword(null,"transact-handler","transact-handler",-745499037).cljs$core$IFn$_invoke$arity$1(conn);
var c__2901__auto___28350 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_28261){
var state_val_28262 = (state_28261[(1)]);
if((state_val_28262 === (1))){
var state_28261__$1 = state_28261;
var statearr_28263_28351 = state_28261__$1;
(statearr_28263_28351[(2)] = null);

(statearr_28263_28351[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28262 === (2))){
var inst_28246 = new cljs.core.Keyword(null,"transact-chan","transact-chan",-1273648840).cljs$core$IFn$_invoke$arity$1(session);
var state_28261__$1 = state_28261;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28261__$1,(4),inst_28246);
} else {
if((state_val_28262 === (3))){
var inst_28259 = (state_28261[(2)]);
var state_28261__$1 = state_28261;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28261__$1,inst_28259);
} else {
if((state_val_28262 === (4))){
var inst_28248 = (state_28261[(7)]);
var inst_28248__$1 = (state_28261[(2)]);
var inst_28249 = (inst_28248__$1 == null);
var state_28261__$1 = (function (){var statearr_28264 = state_28261;
(statearr_28264[(7)] = inst_28248__$1);

return statearr_28264;
})();
if(cljs.core.truth_(inst_28249)){
var statearr_28265_28352 = state_28261__$1;
(statearr_28265_28352[(1)] = (5));

} else {
var statearr_28266_28353 = state_28261__$1;
(statearr_28266_28353[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28262 === (5))){
var inst_28251 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_28252 = fluree.db.util.log.info.call(null,inst_28251);
var state_28261__$1 = state_28261;
var statearr_28267_28354 = state_28261__$1;
(statearr_28267_28354[(2)] = inst_28252);

(statearr_28267_28354[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28262 === (6))){
var inst_28248 = (state_28261[(7)]);
var inst_28254 = transact_handler_28349.call(null,conn,inst_28248);
var state_28261__$1 = (function (){var statearr_28268 = state_28261;
(statearr_28268[(8)] = inst_28254);

return statearr_28268;
})();
var statearr_28269_28355 = state_28261__$1;
(statearr_28269_28355[(2)] = null);

(statearr_28269_28355[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28262 === (7))){
var inst_28257 = (state_28261[(2)]);
var state_28261__$1 = state_28261;
var statearr_28270_28356 = state_28261__$1;
(statearr_28270_28356[(2)] = inst_28257);

(statearr_28270_28356[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__2879__auto__ = null;
var fluree$db$session$state_machine__2879__auto____0 = (function (){
var statearr_28271 = [null,null,null,null,null,null,null,null,null];
(statearr_28271[(0)] = fluree$db$session$state_machine__2879__auto__);

(statearr_28271[(1)] = (1));

return statearr_28271;
});
var fluree$db$session$state_machine__2879__auto____1 = (function (state_28261){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_28261);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e28272){var ex__2882__auto__ = e28272;
var statearr_28273_28357 = state_28261;
(statearr_28273_28357[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_28261[(4)]))){
var statearr_28274_28358 = state_28261;
(statearr_28274_28358[(1)] = cljs.core.first.call(null,(state_28261[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28359 = state_28261;
state_28261 = G__28359;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$session$state_machine__2879__auto__ = function(state_28261){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__2879__auto____1.call(this,state_28261);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__2879__auto____0;
fluree$db$session$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__2879__auto____1;
return fluree$db$session$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_28275 = f__2902__auto__.call(null);
(statearr_28275[(6)] = c__2901__auto___28350);

return statearr_28275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__28360_SHARP_){
return cljs.core.assoc.call(null,p1__28360_SHARP_,new cljs.core.Keyword("req","last","req/last",1105783038),fluree.db.util.core.current_time_millis.call(null),new cljs.core.Keyword("req","count","req/count",2145574363),(new cljs.core.Keyword("req","count","req/count",2145574363).cljs$core$IFn$_invoke$arity$1(p1__28360_SHARP_) + (1)));
}));

var db = new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"schema-cache","schema-cache",-236561225).cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),(function (p1__28361_SHARP_){
return cljs.core.assoc.call(null,p1__28361_SHARP_,new cljs.core.Keyword("db","db","db/db",993247817),fluree.db.session.full_load_existing_db.call(null,session));
}));

return new cljs.core.Keyword("db","db","db/db",993247817).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.call(null,conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"connect?","connect?",1326309520),false], null));
return new cljs.core.Keyword(null,"blank-db","blank-db",-475098534).cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.call(null,conn,ledger,opts);
return fluree.db.session.current_db.call(null,session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__28364 = arguments.length;
switch (G__28364) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.call(null,null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__28365 = cljs.core.vals.call(null,cljs.core.deref.call(null,fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.call(null,(function (p1__28362_SHARP_){
return cljs.core._EQ_.call(null,conn_id,cljs.core.get_in.call(null,p1__28362_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
}),G__28365);
} else {
return G__28365;
}
})();
var seq__28366 = cljs.core.seq.call(null,sessions);
var chunk__28367 = null;
var count__28368 = (0);
var i__28369 = (0);
while(true){
if((i__28369 < count__28368)){
var session = cljs.core._nth.call(null,chunk__28367,i__28369);
fluree.db.session.close.call(null,session);


var G__28371 = seq__28366;
var G__28372 = chunk__28367;
var G__28373 = count__28368;
var G__28374 = (i__28369 + (1));
seq__28366 = G__28371;
chunk__28367 = G__28372;
count__28368 = G__28373;
i__28369 = G__28374;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq.call(null,seq__28366);
if(temp__5735__auto__){
var seq__28366__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__28366__$1)){
var c__4556__auto__ = cljs.core.chunk_first.call(null,seq__28366__$1);
var G__28375 = cljs.core.chunk_rest.call(null,seq__28366__$1);
var G__28376 = c__4556__auto__;
var G__28377 = cljs.core.count.call(null,c__4556__auto__);
var G__28378 = (0);
seq__28366 = G__28375;
chunk__28367 = G__28376;
count__28368 = G__28377;
i__28369 = G__28378;
continue;
} else {
var session = cljs.core.first.call(null,seq__28366__$1);
fluree.db.session.close.call(null,session);


var G__28379 = cljs.core.next.call(null,seq__28366__$1);
var G__28380 = null;
var G__28381 = (0);
var G__28382 = (0);
seq__28366 = G__28379;
chunk__28367 = G__28380;
count__28368 = G__28381;
i__28369 = G__28382;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.call(null,"Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-request","db/invalid-request",-1668472926)], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.call(null,cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),tid,key], null)))){
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,new cljs.core.Keyword("db","pending-tx","db/pending-tx",877151620),(function (pending_txs){
var updated = cljs.core.update.call(null,pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_.call(null,cljs.core.get.call(null,updated,tid))){
return cljs.core.dissoc.call(null,updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
