// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = new cljs.core.Keyword(null,"storage-exists","storage-exists",1403264075).cljs$core$IFn$_invoke$arity$1(conn);
return storage_exists_fn.call(null,key);
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = new cljs.core.Keyword(null,"storage-read","storage-read",-885692537).cljs$core$IFn$_invoke$arity$1(conn);
return storage_read_fn.call(null,key);
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = new cljs.core.Keyword(null,"storage-write","storage-write",595144816).cljs$core$IFn$_invoke$arity$1(conn);
return storage_write_fn.call(null,key,val);
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return new cljs.core.Keyword(null,"serializer","serializer",-875689688).cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name.call(null,idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad.call(null,block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_19942){
var state_val_19943 = (state_19942[(1)]);
if((state_val_19943 === (7))){
var inst_19931 = (state_19942[(7)]);
var inst_19933 = fluree.db.storage.core.serde.call(null,conn);
var inst_19934 = fluree.db.serde.protocol._deserialize_block.call(null,inst_19933,inst_19931);
var state_19942__$1 = state_19942;
var statearr_19944_19963 = state_19942__$1;
(statearr_19944_19963[(2)] = inst_19934);

(statearr_19944_19963[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19943 === (1))){
var state_19942__$1 = state_19942;
var statearr_19945_19964 = state_19942__$1;
(statearr_19945_19964[(2)] = null);

(statearr_19945_19964[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19943 === (4))){
var inst_19921 = (state_19942[(2)]);
var state_19942__$1 = state_19942;
var statearr_19946_19965 = state_19942__$1;
(statearr_19946_19965[(2)] = inst_19921);

(statearr_19946_19965[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19943 === (6))){
var inst_19931 = (state_19942[(7)]);
var inst_19930 = (state_19942[(2)]);
var inst_19931__$1 = fluree.db.util.async.throw_err.call(null,inst_19930);
var state_19942__$1 = (function (){var statearr_19947 = state_19942;
(statearr_19947[(7)] = inst_19931__$1);

return statearr_19947;
})();
if(cljs.core.truth_(inst_19931__$1)){
var statearr_19948_19966 = state_19942__$1;
(statearr_19948_19966[(1)] = (7));

} else {
var statearr_19949_19967 = state_19942__$1;
(statearr_19949_19967[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19943 === (3))){
var inst_19940 = (state_19942[(2)]);
var state_19942__$1 = state_19942;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19942__$1,inst_19940);
} else {
if((state_val_19943 === (2))){
var _ = (function (){var statearr_19951 = state_19942;
(statearr_19951[(4)] = cljs.core.cons.call(null,(5),(state_19942[(4)])));

return statearr_19951;
})();
var inst_19927 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_19928 = fluree.db.storage.core.storage_read.call(null,conn,inst_19927);
var state_19942__$1 = state_19942;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19942__$1,(6),inst_19928);
} else {
if((state_val_19943 === (9))){
var inst_19937 = (state_19942[(2)]);
var _ = (function (){var statearr_19952 = state_19942;
(statearr_19952[(4)] = cljs.core.rest.call(null,(state_19942[(4)])));

return statearr_19952;
})();
var state_19942__$1 = state_19942;
var statearr_19953_19968 = state_19942__$1;
(statearr_19953_19968[(2)] = inst_19937);

(statearr_19953_19968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19943 === (5))){
var _ = (function (){var statearr_19954 = state_19942;
(statearr_19954[(4)] = cljs.core.rest.call(null,(state_19942[(4)])));

return statearr_19954;
})();
var state_19942__$1 = state_19942;
var ex19950 = (state_19942__$1[(2)]);
var statearr_19955_19969 = state_19942__$1;
(statearr_19955_19969[(5)] = ex19950);


if((ex19950 instanceof Error)){
var statearr_19956_19970 = state_19942__$1;
(statearr_19956_19970[(1)] = (4));

(statearr_19956_19970[(5)] = null);

} else {
throw ex19950;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19943 === (8))){
var state_19942__$1 = state_19942;
var statearr_19957_19971 = state_19942__$1;
(statearr_19957_19971[(2)] = null);

(statearr_19957_19971[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__2879__auto____0 = (function (){
var statearr_19958 = [null,null,null,null,null,null,null,null];
(statearr_19958[(0)] = fluree$db$storage$core$read_block_$_state_machine__2879__auto__);

(statearr_19958[(1)] = (1));

return statearr_19958;
});
var fluree$db$storage$core$read_block_$_state_machine__2879__auto____1 = (function (state_19942){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_19942);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e19959){var ex__2882__auto__ = e19959;
var statearr_19960_19972 = state_19942;
(statearr_19960_19972[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_19942[(4)]))){
var statearr_19961_19973 = state_19942;
(statearr_19961_19973[(1)] = cljs.core.first.call(null,(state_19942[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19974 = state_19942;
state_19942 = G__19974;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__2879__auto__ = function(state_19942){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__2879__auto____1.call(this,state_19942);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__2879__auto____0;
fluree$db$storage$core$read_block_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__2879__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_19962 = f__2902__auto__.call(null);
(statearr_19962[(6)] = c__2901__auto__);

return statearr_19962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_19997){
var state_val_19998 = (state_19997[(1)]);
if((state_val_19998 === (7))){
var inst_19986 = (state_19997[(7)]);
var inst_19988 = fluree.db.storage.core.serde.call(null,conn);
var inst_19989 = fluree.db.serde.protocol._deserialize_block.call(null,inst_19988,inst_19986);
var state_19997__$1 = state_19997;
var statearr_19999_20018 = state_19997__$1;
(statearr_19999_20018[(2)] = inst_19989);

(statearr_19999_20018[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19998 === (1))){
var state_19997__$1 = state_19997;
var statearr_20000_20019 = state_19997__$1;
(statearr_20000_20019[(2)] = null);

(statearr_20000_20019[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19998 === (4))){
var inst_19975 = (state_19997[(2)]);
var state_19997__$1 = state_19997;
var statearr_20001_20020 = state_19997__$1;
(statearr_20001_20020[(2)] = inst_19975);

(statearr_20001_20020[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19998 === (6))){
var inst_19986 = (state_19997[(7)]);
var inst_19985 = (state_19997[(2)]);
var inst_19986__$1 = fluree.db.util.async.throw_err.call(null,inst_19985);
var state_19997__$1 = (function (){var statearr_20002 = state_19997;
(statearr_20002[(7)] = inst_19986__$1);

return statearr_20002;
})();
if(cljs.core.truth_(inst_19986__$1)){
var statearr_20003_20021 = state_19997__$1;
(statearr_20003_20021[(1)] = (7));

} else {
var statearr_20004_20022 = state_19997__$1;
(statearr_20004_20022[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19998 === (3))){
var inst_19995 = (state_19997[(2)]);
var state_19997__$1 = state_19997;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19997__$1,inst_19995);
} else {
if((state_val_19998 === (2))){
var _ = (function (){var statearr_20006 = state_19997;
(statearr_20006[(4)] = cljs.core.cons.call(null,(5),(state_19997[(4)])));

return statearr_20006;
})();
var inst_19981 = fluree.db.storage.core.ledger_block_key.call(null,network,ledger_id,block);
var inst_19982 = [inst_19981,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_19983 = fluree.db.storage.core.storage_read.call(null,conn,inst_19982);
var state_19997__$1 = state_19997;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19997__$1,(6),inst_19983);
} else {
if((state_val_19998 === (9))){
var inst_19992 = (state_19997[(2)]);
var _ = (function (){var statearr_20007 = state_19997;
(statearr_20007[(4)] = cljs.core.rest.call(null,(state_19997[(4)])));

return statearr_20007;
})();
var state_19997__$1 = state_19997;
var statearr_20008_20023 = state_19997__$1;
(statearr_20008_20023[(2)] = inst_19992);

(statearr_20008_20023[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19998 === (5))){
var _ = (function (){var statearr_20009 = state_19997;
(statearr_20009[(4)] = cljs.core.rest.call(null,(state_19997[(4)])));

return statearr_20009;
})();
var state_19997__$1 = state_19997;
var ex20005 = (state_19997__$1[(2)]);
var statearr_20010_20024 = state_19997__$1;
(statearr_20010_20024[(5)] = ex20005);


if((ex20005 instanceof Error)){
var statearr_20011_20025 = state_19997__$1;
(statearr_20011_20025[(1)] = (4));

(statearr_20011_20025[(5)] = null);

} else {
throw ex20005;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19998 === (8))){
var state_19997__$1 = state_19997;
var statearr_20012_20026 = state_19997__$1;
(statearr_20012_20026[(2)] = null);

(statearr_20012_20026[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__2879__auto____0 = (function (){
var statearr_20013 = [null,null,null,null,null,null,null,null];
(statearr_20013[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__2879__auto__);

(statearr_20013[(1)] = (1));

return statearr_20013;
});
var fluree$db$storage$core$read_block_version_$_state_machine__2879__auto____1 = (function (state_19997){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_19997);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20014){var ex__2882__auto__ = e20014;
var statearr_20015_20027 = state_19997;
(statearr_20015_20027[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_19997[(4)]))){
var statearr_20016_20028 = state_19997;
(statearr_20016_20028[(1)] = cljs.core.first.call(null,(state_19997[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20029 = state_19997;
state_19997 = G__20029;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__2879__auto__ = function(state_19997){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__2879__auto____1.call(this,state_19997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__2879__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__2879__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20017 = f__2902__auto__.call(null);
(statearr_20017[(6)] = c__2901__auto__);

return statearr_20017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20053){
var state_val_20054 = (state_20053[(1)]);
if((state_val_20054 === (1))){
var state_20053__$1 = state_20053;
var statearr_20055_20069 = state_20053__$1;
(statearr_20055_20069[(2)] = null);

(statearr_20055_20069[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20054 === (2))){
var _ = (function (){var statearr_20056 = state_20053;
(statearr_20056[(4)] = cljs.core.cons.call(null,(5),(state_20053[(4)])));

return statearr_20056;
})();
var inst_20036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20037 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_20038 = (new cljs.core.PersistentVector(null,3,(5),inst_20036,inst_20037,null));
var inst_20039 = cljs.core.select_keys.call(null,block_data,inst_20038);
var inst_20040 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_20039);
var inst_20041 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_20040);
var inst_20042 = [inst_20041,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_20043 = fluree.db.storage.core.serde.call(null,conn);
var inst_20044 = fluree.db.serde.protocol._serialize_block.call(null,inst_20043,inst_20039);
var inst_20045 = fluree.db.storage.core.storage_write.call(null,conn,inst_20042,inst_20044);
var state_20053__$1 = state_20053;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20053__$1,(6),inst_20045);
} else {
if((state_val_20054 === (3))){
var inst_20051 = (state_20053[(2)]);
var state_20053__$1 = state_20053;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20053__$1,inst_20051);
} else {
if((state_val_20054 === (4))){
var inst_20030 = (state_20053[(2)]);
var state_20053__$1 = state_20053;
var statearr_20058_20070 = state_20053__$1;
(statearr_20058_20070[(2)] = inst_20030);

(statearr_20058_20070[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20054 === (5))){
var _ = (function (){var statearr_20059 = state_20053;
(statearr_20059[(4)] = cljs.core.rest.call(null,(state_20053[(4)])));

return statearr_20059;
})();
var state_20053__$1 = state_20053;
var ex20057 = (state_20053__$1[(2)]);
var statearr_20060_20071 = state_20053__$1;
(statearr_20060_20071[(5)] = ex20057);


if((ex20057 instanceof Error)){
var statearr_20061_20072 = state_20053__$1;
(statearr_20061_20072[(1)] = (4));

(statearr_20061_20072[(5)] = null);

} else {
throw ex20057;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20054 === (6))){
var inst_20047 = (state_20053[(2)]);
var inst_20048 = fluree.db.util.async.throw_err.call(null,inst_20047);
var _ = (function (){var statearr_20062 = state_20053;
(statearr_20062[(4)] = cljs.core.rest.call(null,(state_20053[(4)])));

return statearr_20062;
})();
var state_20053__$1 = state_20053;
var statearr_20063_20073 = state_20053__$1;
(statearr_20063_20073[(2)] = inst_20048);

(statearr_20063_20073[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__2879__auto____0 = (function (){
var statearr_20064 = [null,null,null,null,null,null,null];
(statearr_20064[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__2879__auto__);

(statearr_20064[(1)] = (1));

return statearr_20064;
});
var fluree$db$storage$core$write_block_version_$_state_machine__2879__auto____1 = (function (state_20053){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_20053);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20065){var ex__2882__auto__ = e20065;
var statearr_20066_20074 = state_20053;
(statearr_20066_20074[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_20053[(4)]))){
var statearr_20067_20075 = state_20053;
(statearr_20067_20075[(1)] = cljs.core.first.call(null,(state_20053[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20076 = state_20053;
state_20053 = G__20076;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__2879__auto__ = function(state_20053){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__2879__auto____1.call(this,state_20053);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__2879__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__2879__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20068 = f__2902__auto__.call(null);
(statearr_20068[(6)] = c__2901__auto__);

return statearr_20068;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20099){
var state_val_20100 = (state_20099[(1)]);
if((state_val_20100 === (1))){
var state_20099__$1 = state_20099;
var statearr_20101_20115 = state_20099__$1;
(statearr_20101_20115[(2)] = null);

(statearr_20101_20115[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20100 === (2))){
var _ = (function (){var statearr_20102 = state_20099;
(statearr_20102[(4)] = cljs.core.cons.call(null,(5),(state_20099[(4)])));

return statearr_20102;
})();
var inst_20083 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20084 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_20085 = (new cljs.core.PersistentVector(null,3,(5),inst_20083,inst_20084,null));
var inst_20086 = cljs.core.select_keys.call(null,block_data,inst_20085);
var inst_20087 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_20086);
var inst_20088 = fluree.db.storage.core.ledger_block_key.call(null,network,dbid,inst_20087);
var inst_20089 = fluree.db.storage.core.serde.call(null,conn);
var inst_20090 = fluree.db.serde.protocol._serialize_block.call(null,inst_20089,inst_20086);
var inst_20091 = fluree.db.storage.core.storage_write.call(null,conn,inst_20088,inst_20090);
var state_20099__$1 = state_20099;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20099__$1,(6),inst_20091);
} else {
if((state_val_20100 === (3))){
var inst_20097 = (state_20099[(2)]);
var state_20099__$1 = state_20099;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20099__$1,inst_20097);
} else {
if((state_val_20100 === (4))){
var inst_20077 = (state_20099[(2)]);
var state_20099__$1 = state_20099;
var statearr_20104_20116 = state_20099__$1;
(statearr_20104_20116[(2)] = inst_20077);

(statearr_20104_20116[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20100 === (5))){
var _ = (function (){var statearr_20105 = state_20099;
(statearr_20105[(4)] = cljs.core.rest.call(null,(state_20099[(4)])));

return statearr_20105;
})();
var state_20099__$1 = state_20099;
var ex20103 = (state_20099__$1[(2)]);
var statearr_20106_20117 = state_20099__$1;
(statearr_20106_20117[(5)] = ex20103);


if((ex20103 instanceof Error)){
var statearr_20107_20118 = state_20099__$1;
(statearr_20107_20118[(1)] = (4));

(statearr_20107_20118[(5)] = null);

} else {
throw ex20103;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20100 === (6))){
var inst_20093 = (state_20099[(2)]);
var inst_20094 = fluree.db.util.async.throw_err.call(null,inst_20093);
var _ = (function (){var statearr_20108 = state_20099;
(statearr_20108[(4)] = cljs.core.rest.call(null,(state_20099[(4)])));

return statearr_20108;
})();
var state_20099__$1 = state_20099;
var statearr_20109_20119 = state_20099__$1;
(statearr_20109_20119[(2)] = inst_20094);

(statearr_20109_20119[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__2879__auto____0 = (function (){
var statearr_20110 = [null,null,null,null,null,null,null];
(statearr_20110[(0)] = fluree$db$storage$core$write_block_$_state_machine__2879__auto__);

(statearr_20110[(1)] = (1));

return statearr_20110;
});
var fluree$db$storage$core$write_block_$_state_machine__2879__auto____1 = (function (state_20099){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_20099);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20111){var ex__2882__auto__ = e20111;
var statearr_20112_20120 = state_20099;
(statearr_20112_20120[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_20099[(4)]))){
var statearr_20113_20121 = state_20099;
(statearr_20113_20121[(1)] = cljs.core.first.call(null,(state_20099[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20122 = state_20099;
state_20099 = G__20122;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__2879__auto__ = function(state_20099){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__2879__auto____1.call(this,state_20099);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__2879__auto____0;
fluree$db$storage$core$write_block_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__2879__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20114 = f__2902__auto__.call(null);
(statearr_20114[(6)] = c__2901__auto__);

return statearr_20114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys.call(null,child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007)], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20142){
var state_val_20143 = (state_20142[(1)]);
if((state_val_20143 === (1))){
var state_20142__$1 = state_20142;
var statearr_20144_20158 = state_20142__$1;
(statearr_20144_20158[(2)] = null);

(statearr_20144_20158[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20143 === (2))){
var _ = (function (){var statearr_20145 = state_20142;
(statearr_20145[(4)] = cljs.core.cons.call(null,(5),(state_20142[(4)])));

return statearr_20145;
})();
var inst_20129 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_20130 = [history,next_his_key];
var inst_20131 = cljs.core.PersistentHashMap.fromArrays(inst_20129,inst_20130);
var inst_20132 = fluree.db.storage.core.serde.call(null,conn);
var inst_20133 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_20132,inst_20131);
var inst_20134 = fluree.db.storage.core.storage_write.call(null,conn,his_key,inst_20133);
var state_20142__$1 = state_20142;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20142__$1,(6),inst_20134);
} else {
if((state_val_20143 === (3))){
var inst_20140 = (state_20142[(2)]);
var state_20142__$1 = state_20142;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20142__$1,inst_20140);
} else {
if((state_val_20143 === (4))){
var inst_20123 = (state_20142[(2)]);
var state_20142__$1 = state_20142;
var statearr_20147_20159 = state_20142__$1;
(statearr_20147_20159[(2)] = inst_20123);

(statearr_20147_20159[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20143 === (5))){
var _ = (function (){var statearr_20148 = state_20142;
(statearr_20148[(4)] = cljs.core.rest.call(null,(state_20142[(4)])));

return statearr_20148;
})();
var state_20142__$1 = state_20142;
var ex20146 = (state_20142__$1[(2)]);
var statearr_20149_20160 = state_20142__$1;
(statearr_20149_20160[(5)] = ex20146);


if((ex20146 instanceof Error)){
var statearr_20150_20161 = state_20142__$1;
(statearr_20150_20161[(1)] = (4));

(statearr_20150_20161[(5)] = null);

} else {
throw ex20146;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20143 === (6))){
var inst_20136 = (state_20142[(2)]);
var inst_20137 = fluree.db.util.async.throw_err.call(null,inst_20136);
var _ = (function (){var statearr_20151 = state_20142;
(statearr_20151[(4)] = cljs.core.rest.call(null,(state_20142[(4)])));

return statearr_20151;
})();
var state_20142__$1 = state_20142;
var statearr_20152_20162 = state_20142__$1;
(statearr_20152_20162[(2)] = inst_20137);

(statearr_20152_20162[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__2879__auto____0 = (function (){
var statearr_20153 = [null,null,null,null,null,null,null];
(statearr_20153[(0)] = fluree$db$storage$core$write_history_$_state_machine__2879__auto__);

(statearr_20153[(1)] = (1));

return statearr_20153;
});
var fluree$db$storage$core$write_history_$_state_machine__2879__auto____1 = (function (state_20142){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_20142);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20154){var ex__2882__auto__ = e20154;
var statearr_20155_20163 = state_20142;
(statearr_20155_20163[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_20142[(4)]))){
var statearr_20156_20164 = state_20142;
(statearr_20156_20164[(1)] = cljs.core.first.call(null,(state_20142[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20165 = state_20142;
state_20142 = G__20165;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__2879__auto__ = function(state_20142){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__2879__auto____1.call(this,state_20142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__2879__auto____0;
fluree$db$storage$core$write_history_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__2879__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20157 = f__2902__auto__.call(null);
(statearr_20157[(6)] = c__2901__auto__);

return statearr_20157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20191){
var state_val_20192 = (state_20191[(1)]);
if((state_val_20192 === (1))){
var state_20191__$1 = state_20191;
var statearr_20193_20210 = state_20191__$1;
(statearr_20193_20210[(2)] = null);

(statearr_20193_20210[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20192 === (2))){
var inst_20172 = (state_20191[(7)]);
var _ = (function (){var statearr_20194 = state_20191;
(statearr_20194[(4)] = cljs.core.cons.call(null,(5),(state_20191[(4)])));

return statearr_20194;
})();
var inst_20172__$1 = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"l");
var inst_20173 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20172__$1),"-his"].join('');
var inst_20174 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"his","his",-1294347076)];
var inst_20175 = [flakes,inst_20173];
var inst_20176 = cljs.core.PersistentHashMap.fromArrays(inst_20174,inst_20175);
var inst_20177 = fluree.db.storage.core.serde.call(null,conn);
var inst_20178 = fluree.db.serde.protocol._serialize_leaf.call(null,inst_20177,inst_20176);
var inst_20179 = fluree.db.storage.core.write_history.call(null,conn,history,inst_20173,null);
var inst_20180 = fluree.db.storage.core.storage_write.call(null,conn,inst_20172__$1,inst_20178);
var state_20191__$1 = (function (){var statearr_20195 = state_20191;
(statearr_20195[(7)] = inst_20172__$1);

(statearr_20195[(8)] = inst_20180);

return statearr_20195;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20191__$1,(6),inst_20179);
} else {
if((state_val_20192 === (3))){
var inst_20189 = (state_20191[(2)]);
var state_20191__$1 = state_20191;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20191__$1,inst_20189);
} else {
if((state_val_20192 === (4))){
var inst_20166 = (state_20191[(2)]);
var state_20191__$1 = state_20191;
var statearr_20197_20211 = state_20191__$1;
(statearr_20197_20211[(2)] = inst_20166);

(statearr_20197_20211[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20192 === (5))){
var _ = (function (){var statearr_20198 = state_20191;
(statearr_20198[(4)] = cljs.core.rest.call(null,(state_20191[(4)])));

return statearr_20198;
})();
var state_20191__$1 = state_20191;
var ex20196 = (state_20191__$1[(2)]);
var statearr_20199_20212 = state_20191__$1;
(statearr_20199_20212[(5)] = ex20196);


if((ex20196 instanceof Error)){
var statearr_20200_20213 = state_20191__$1;
(statearr_20200_20213[(1)] = (4));

(statearr_20200_20213[(5)] = null);

} else {
throw ex20196;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20192 === (6))){
var inst_20180 = (state_20191[(8)]);
var inst_20182 = (state_20191[(2)]);
var inst_20183 = fluree.db.util.async.throw_err.call(null,inst_20182);
var state_20191__$1 = (function (){var statearr_20201 = state_20191;
(statearr_20201[(9)] = inst_20183);

return statearr_20201;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20191__$1,(7),inst_20180);
} else {
if((state_val_20192 === (7))){
var inst_20172 = (state_20191[(7)]);
var inst_20185 = (state_20191[(2)]);
var inst_20186 = fluree.db.util.async.throw_err.call(null,inst_20185);
var _ = (function (){var statearr_20202 = state_20191;
(statearr_20202[(4)] = cljs.core.rest.call(null,(state_20191[(4)])));

return statearr_20202;
})();
var state_20191__$1 = (function (){var statearr_20203 = state_20191;
(statearr_20203[(10)] = inst_20186);

return statearr_20203;
})();
var statearr_20204_20214 = state_20191__$1;
(statearr_20204_20214[(2)] = inst_20172);

(statearr_20204_20214[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__2879__auto____0 = (function (){
var statearr_20205 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_20205[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__2879__auto__);

(statearr_20205[(1)] = (1));

return statearr_20205;
});
var fluree$db$storage$core$write_leaf_$_state_machine__2879__auto____1 = (function (state_20191){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_20191);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20206){var ex__2882__auto__ = e20206;
var statearr_20207_20215 = state_20191;
(statearr_20207_20215[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_20191[(4)]))){
var statearr_20208_20216 = state_20191;
(statearr_20208_20216[(1)] = cljs.core.first.call(null,(state_20191[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20217 = state_20191;
state_20191 = G__20217;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__2879__auto__ = function(state_20191){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__2879__auto____1.call(this,state_20191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__2879__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__2879__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20209 = f__2902__auto__.call(null);
(statearr_20209[(6)] = c__2901__auto__);

return statearr_20209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20234){
var state_val_20235 = (state_20234[(1)]);
if((state_val_20235 === (1))){
var state_20234__$1 = state_20234;
var statearr_20236_20251 = state_20234__$1;
(statearr_20236_20251[(2)] = null);

(statearr_20236_20251[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20235 === (2))){
var _ = (function (){var statearr_20237 = state_20234;
(statearr_20237[(4)] = cljs.core.cons.call(null,(5),(state_20234[(4)])));

return statearr_20237;
})();
var inst_20224 = fluree.db.storage.core.serde.call(null,conn);
var inst_20225 = fluree.db.serde.protocol._serialize_branch.call(null,inst_20224,data);
var inst_20226 = fluree.db.storage.core.storage_write.call(null,conn,key,inst_20225);
var state_20234__$1 = state_20234;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20234__$1,(6),inst_20226);
} else {
if((state_val_20235 === (3))){
var inst_20232 = (state_20234[(2)]);
var state_20234__$1 = state_20234;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20234__$1,inst_20232);
} else {
if((state_val_20235 === (4))){
var inst_20218 = (state_20234[(2)]);
var state_20234__$1 = state_20234;
var statearr_20239_20252 = state_20234__$1;
(statearr_20239_20252[(2)] = inst_20218);

(statearr_20239_20252[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20235 === (5))){
var _ = (function (){var statearr_20240 = state_20234;
(statearr_20240[(4)] = cljs.core.rest.call(null,(state_20234[(4)])));

return statearr_20240;
})();
var state_20234__$1 = state_20234;
var ex20238 = (state_20234__$1[(2)]);
var statearr_20241_20253 = state_20234__$1;
(statearr_20241_20253[(5)] = ex20238);


if((ex20238 instanceof Error)){
var statearr_20242_20254 = state_20234__$1;
(statearr_20242_20254[(1)] = (4));

(statearr_20242_20254[(5)] = null);

} else {
throw ex20238;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20235 === (6))){
var inst_20228 = (state_20234[(2)]);
var inst_20229 = fluree.db.util.async.throw_err.call(null,inst_20228);
var _ = (function (){var statearr_20243 = state_20234;
(statearr_20243[(4)] = cljs.core.rest.call(null,(state_20234[(4)])));

return statearr_20243;
})();
var state_20234__$1 = (function (){var statearr_20244 = state_20234;
(statearr_20244[(7)] = inst_20229);

return statearr_20244;
})();
var statearr_20245_20255 = state_20234__$1;
(statearr_20245_20255[(2)] = key);

(statearr_20245_20255[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto____0 = (function (){
var statearr_20246 = [null,null,null,null,null,null,null,null];
(statearr_20246[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto__);

(statearr_20246[(1)] = (1));

return statearr_20246;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto____1 = (function (state_20234){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_20234);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20247){var ex__2882__auto__ = e20247;
var statearr_20248_20256 = state_20234;
(statearr_20248_20256[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_20234[(4)]))){
var statearr_20249_20257 = state_20234;
(statearr_20249_20257[(1)] = cljs.core.first.call(null,(state_20234[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20258 = state_20234;
state_20234 = G__20258;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto__ = function(state_20234){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto____1.call(this,state_20234);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20250 = f__2902__auto__.call(null);
(statearr_20250[(6)] = c__2901__auto__);

return statearr_20250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key.call(null,network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.call(null,(function (p1__20259_SHARP_){
return fluree.db.storage.core.child_data.call(null,cljs.core.val.call(null,p1__20259_SHARP_));
}),children);
var rhs = new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"children","children",-940561982),child_vals,new cljs.core.Keyword(null,"rhs","rhs",-229356739),rhs], null);
return fluree.db.storage.core.write_branch_data.call(null,conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__20260){
var map__20261 = p__20260;
var map__20261__$1 = (((((!((map__20261 == null))))?(((((map__20261.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20261.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20261):map__20261);
var progress = map__20261__$1;
var garbage = cljs.core.get.call(null,map__20261__$1,new cljs.core.Keyword(null,"garbage","garbage",-2063107600));
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20310){
var state_val_20311 = (state_20310[(1)]);
if((state_val_20311 === (7))){
var state_20310__$1 = state_20310;
var statearr_20312_20341 = state_20310__$1;
(statearr_20312_20341[(2)] = false);

(statearr_20312_20341[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (1))){
var state_20310__$1 = state_20310;
var statearr_20313_20342 = state_20310__$1;
(statearr_20313_20342[(2)] = null);

(statearr_20313_20342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (4))){
var inst_20263 = (state_20310[(2)]);
var state_20310__$1 = state_20310;
var statearr_20314_20343 = state_20310__$1;
(statearr_20314_20343[(2)] = inst_20263);

(statearr_20314_20343[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (15))){
var inst_20296 = (state_20310[(7)]);
var inst_20304 = (state_20310[(2)]);
var inst_20305 = fluree.db.util.async.throw_err.call(null,inst_20304);
var _ = (function (){var statearr_20315 = state_20310;
(statearr_20315[(4)] = cljs.core.rest.call(null,(state_20310[(4)])));

return statearr_20315;
})();
var state_20310__$1 = (function (){var statearr_20316 = state_20310;
(statearr_20316[(8)] = inst_20305);

return statearr_20316;
})();
var statearr_20317_20344 = state_20310__$1;
(statearr_20317_20344[(2)] = inst_20296);

(statearr_20317_20344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (13))){
var inst_20270 = (state_20310[(9)]);
var state_20310__$1 = state_20310;
var statearr_20318_20345 = state_20310__$1;
(statearr_20318_20345[(2)] = inst_20270);

(statearr_20318_20345[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (6))){
var inst_20270 = (state_20310[(9)]);
var inst_20275 = inst_20270.cljs$lang$protocol_mask$partition0$;
var inst_20276 = (inst_20275 & (64));
var inst_20277 = inst_20270.cljs$core$ISeq$;
var inst_20278 = (cljs.core.PROTOCOL_SENTINEL === inst_20277);
var inst_20279 = ((inst_20276) || (inst_20278));
var state_20310__$1 = state_20310;
if(cljs.core.truth_(inst_20279)){
var statearr_20319_20346 = state_20310__$1;
(statearr_20319_20346[(1)] = (9));

} else {
var statearr_20320_20347 = state_20310__$1;
(statearr_20320_20347[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (3))){
var inst_20308 = (state_20310[(2)]);
var state_20310__$1 = state_20310;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20310__$1,inst_20308);
} else {
if((state_val_20311 === (12))){
var inst_20270 = (state_20310[(9)]);
var inst_20288 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20270);
var state_20310__$1 = state_20310;
var statearr_20321_20348 = state_20310__$1;
(statearr_20321_20348[(2)] = inst_20288);

(statearr_20321_20348[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (2))){
var inst_20270 = (state_20310[(9)]);
var _ = (function (){var statearr_20322 = state_20310;
(statearr_20322[(4)] = cljs.core.cons.call(null,(5),(state_20310[(4)])));

return statearr_20322;
})();
var inst_20270__$1 = db;
var inst_20272 = (inst_20270__$1 == null);
var inst_20273 = cljs.core.not.call(null,inst_20272);
var state_20310__$1 = (function (){var statearr_20323 = state_20310;
(statearr_20323[(9)] = inst_20270__$1);

return statearr_20323;
})();
if(inst_20273){
var statearr_20324_20349 = state_20310__$1;
(statearr_20324_20349[(1)] = (6));

} else {
var statearr_20325_20350 = state_20310__$1;
(statearr_20325_20350[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (11))){
var inst_20283 = (state_20310[(2)]);
var state_20310__$1 = state_20310;
var statearr_20327_20351 = state_20310__$1;
(statearr_20327_20351[(2)] = inst_20283);

(statearr_20327_20351[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (9))){
var state_20310__$1 = state_20310;
var statearr_20328_20352 = state_20310__$1;
(statearr_20328_20352[(2)] = true);

(statearr_20328_20352[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (5))){
var _ = (function (){var statearr_20329 = state_20310;
(statearr_20329[(4)] = cljs.core.rest.call(null,(state_20310[(4)])));

return statearr_20329;
})();
var state_20310__$1 = state_20310;
var ex20326 = (state_20310__$1[(2)]);
var statearr_20330_20353 = state_20310__$1;
(statearr_20330_20353[(5)] = ex20326);


if((ex20326 instanceof Error)){
var statearr_20331_20354 = state_20310__$1;
(statearr_20331_20354[(1)] = (4));

(statearr_20331_20354[(5)] = null);

} else {
throw ex20326;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (14))){
var inst_20296 = (state_20310[(7)]);
var inst_20291 = (state_20310[(2)]);
var inst_20292 = cljs.core.get.call(null,inst_20291,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_20293 = cljs.core.get.call(null,inst_20291,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_20294 = cljs.core.get.call(null,inst_20291,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_20295 = cljs.core.get.call(null,inst_20291,new cljs.core.Keyword(null,"block","block",664686210));
var inst_20296__$1 = fluree.db.storage.core.ledger_garbage_key.call(null,inst_20293,inst_20294,inst_20295);
var inst_20297 = [new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"garbage","garbage",-2063107600)];
var inst_20298 = [inst_20294,inst_20295,garbage];
var inst_20299 = cljs.core.PersistentHashMap.fromArrays(inst_20297,inst_20298);
var inst_20300 = fluree.db.storage.core.serde.call(null,inst_20292);
var inst_20301 = fluree.db.serde.protocol._serialize_garbage.call(null,inst_20300,inst_20299);
var inst_20302 = fluree.db.storage.core.storage_write.call(null,inst_20292,inst_20296__$1,inst_20301);
var state_20310__$1 = (function (){var statearr_20332 = state_20310;
(statearr_20332[(7)] = inst_20296__$1);

return statearr_20332;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20310__$1,(15),inst_20302);
} else {
if((state_val_20311 === (10))){
var state_20310__$1 = state_20310;
var statearr_20333_20355 = state_20310__$1;
(statearr_20333_20355[(2)] = false);

(statearr_20333_20355[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20311 === (8))){
var inst_20286 = (state_20310[(2)]);
var state_20310__$1 = state_20310;
if(cljs.core.truth_(inst_20286)){
var statearr_20334_20356 = state_20310__$1;
(statearr_20334_20356[(1)] = (12));

} else {
var statearr_20335_20357 = state_20310__$1;
(statearr_20335_20357[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__2879__auto____0 = (function (){
var statearr_20336 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20336[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__2879__auto__);

(statearr_20336[(1)] = (1));

return statearr_20336;
});
var fluree$db$storage$core$write_garbage_$_state_machine__2879__auto____1 = (function (state_20310){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_20310);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20337){var ex__2882__auto__ = e20337;
var statearr_20338_20358 = state_20310;
(statearr_20338_20358[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_20310[(4)]))){
var statearr_20339_20359 = state_20310;
(statearr_20339_20359[(1)] = cljs.core.first.call(null,(state_20310[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20360 = state_20310;
state_20310 = G__20360;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__2879__auto__ = function(state_20310){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__2879__auto____1.call(this,state_20310);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__2879__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__2879__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20340 = f__2902__auto__.call(null);
(statearr_20340[(6)] = c__2901__auto__);

return statearr_20340;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__20362 = arguments.length;
switch (G__20362) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.call(null,db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20438){
var state_val_20439 = (state_20438[(1)]);
if((state_val_20439 === (7))){
var state_20438__$1 = state_20438;
var statearr_20440_20479 = state_20438__$1;
(statearr_20440_20479[(2)] = false);

(statearr_20440_20479[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20439 === (20))){
var inst_20402 = (state_20438[(7)]);
var inst_20393 = (state_20438[(8)]);
var inst_20394 = (state_20438[(9)]);
var inst_20404 = (state_20438[(10)]);
var inst_20398 = (state_20438[(11)]);
var inst_20407 = (state_20438[(12)]);
var inst_20403 = (state_20438[(13)]);
var inst_20396 = (state_20438[(14)]);
var inst_20406 = (state_20438[(15)]);
var inst_20412 = (state_20438[(16)]);
var inst_20405 = (state_20438[(17)]);
var inst_20400 = (state_20438[(18)]);
var inst_20397 = (state_20438[(19)]);
var inst_20395 = (state_20438[(20)]);
var inst_20417 = (state_20438[(2)]);
var inst_20418 = fluree.db.storage.core.child_data.call(null,inst_20402);
var inst_20419 = fluree.db.storage.core.child_data.call(null,inst_20404);
var inst_20420 = fluree.db.util.core.current_time_millis.call(null);
var inst_20421 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20422 = [new cljs.core.Keyword(null,"flakes","flakes",1977895739),new cljs.core.Keyword(null,"size","size",1098693007)];
var inst_20423 = (new cljs.core.PersistentVector(null,2,(5),inst_20421,inst_20422,null));
var inst_20424 = cljs.core.select_keys.call(null,inst_20396,inst_20423);
var inst_20425 = fluree.db.storage.core.child_data.call(null,inst_20395);
var inst_20426 = [inst_20398,inst_20407,inst_20400,inst_20412,inst_20417,inst_20418,inst_20419,inst_20393,inst_20420,inst_20394,inst_20403,inst_20424,inst_20425];
var inst_20427 = cljs.core.PersistentHashMap.fromArrays(inst_20406,inst_20426);
var inst_20428 = fluree.db.storage.core.serde.call(null,inst_20397);
var inst_20429 = fluree.db.serde.protocol._serialize_db_root.call(null,inst_20428,inst_20427);
var inst_20430 = fluree.db.storage.core.storage_write.call(null,inst_20397,inst_20405,inst_20429);
var state_20438__$1 = state_20438;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20438__$1,(21),inst_20430);
} else {
if((state_val_20439 === (1))){
var state_20438__$1 = state_20438;
var statearr_20441_20480 = state_20438__$1;
(statearr_20441_20480[(2)] = null);

(statearr_20441_20480[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20439 === (4))){
var inst_20363 = (state_20438[(2)]);
var state_20438__$1 = state_20438;
var statearr_20442_20481 = state_20438__$1;
(statearr_20442_20481[(2)] = inst_20363);

(statearr_20442_20481[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20439 === (15))){
var inst_20408 = (state_20438[(21)]);
var state_20438__$1 = state_20438;
var statearr_20443_20482 = state_20438__$1;
(statearr_20443_20482[(2)] = inst_20408);

(statearr_20443_20482[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20439 === (21))){
var inst_20405 = (state_20438[(17)]);
var inst_20432 = (state_20438[(2)]);
var inst_20433 = fluree.db.util.async.throw_err.call(null,inst_20432);
var _ = (function (){var statearr_20444 = state_20438;
(statearr_20444[(4)] = cljs.core.rest.call(null,(state_20438[(4)])));

return statearr_20444;
})();
var state_20438__$1 = (function (){var statearr_20445 = state_20438;
(statearr_20445[(22)] = inst_20433);

return statearr_20445;
})();
var statearr_20446_20483 = state_20438__$1;
(statearr_20446_20483[(2)] = inst_20405);

(statearr_20446_20483[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20439 === (13))){
var inst_20370 = (state_20438[(23)]);
var state_20438__$1 = state_20438;
var statearr_20447_20484 = state_20438__$1;
(statearr_20447_20484[(2)] = inst_20370);

(statearr_20447_20484[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20439 === (6))){
var inst_20370 = (state_20438[(23)]);
var inst_20375 = inst_20370.cljs$lang$protocol_mask$partition0$;
var inst_20376 = (inst_20375 & (64));
var inst_20377 = inst_20370.cljs$core$ISeq$;
var inst_20378 = (cljs.core.PROTOCOL_SENTINEL === inst_20377);
var inst_20379 = ((inst_20376) || (inst_20378));
var state_20438__$1 = state_20438;
if(cljs.core.truth_(inst_20379)){
var statearr_20448_20485 = state_20438__$1;
(statearr_20448_20485[(1)] = (9));

} else {
var statearr_20449_20486 = state_20438__$1;
(statearr_20449_20486[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20439 === (17))){
var inst_20413 = (state_20438[(24)]);
var inst_20412 = (state_20438[(2)]);
var inst_20413__$1 = custom_ecount;
var state_20438__$1 = (function (){var statearr_20450 = state_20438;
(statearr_20450[(16)] = inst_20412);

(statearr_20450[(24)] = inst_20413__$1);

return statearr_20450;
})();
if(cljs.core.truth_(inst_20413__$1)){
var statearr_20451_20487 = state_20438__$1;
(statearr_20451_20487[(1)] = (18));

} else {
var statearr_20452_20488 = state_20438__$1;
(statearr_20452_20488[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20439 === (3))){
var inst_20436 = (state_20438[(2)]);
var state_20438__$1 = state_20438;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20438__$1,inst_20436);
} else {
if((state_val_20439 === (12))){
var inst_20370 = (state_20438[(23)]);
var inst_20388 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20370);
var state_20438__$1 = state_20438;
var statearr_20453_20489 = state_20438__$1;
(statearr_20453_20489[(2)] = inst_20388);

(statearr_20453_20489[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20439 === (2))){
var inst_20370 = (state_20438[(23)]);
var _ = (function (){var statearr_20454 = state_20438;
(statearr_20454[(4)] = cljs.core.cons.call(null,(5),(state_20438[(4)])));

return statearr_20454;
})();
var inst_20370__$1 = db;
var inst_20372 = (inst_20370__$1 == null);
var inst_20373 = cljs.core.not.call(null,inst_20372);
var state_20438__$1 = (function (){var statearr_20455 = state_20438;
(statearr_20455[(23)] = inst_20370__$1);

return statearr_20455;
})();
if(inst_20373){
var statearr_20456_20490 = state_20438__$1;
(statearr_20456_20490[(1)] = (6));

} else {
var statearr_20457_20491 = state_20438__$1;
(statearr_20457_20491[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20439 === (19))){
var inst_20401 = (state_20438[(25)]);
var state_20438__$1 = state_20438;
var statearr_20458_20492 = state_20438__$1;
(statearr_20458_20492[(2)] = inst_20401);

(statearr_20458_20492[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20439 === (11))){
var inst_20383 = (state_20438[(2)]);
var state_20438__$1 = state_20438;
var statearr_20460_20493 = state_20438__$1;
(statearr_20460_20493[(2)] = inst_20383);

(statearr_20460_20493[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20439 === (9))){
var state_20438__$1 = state_20438;
var statearr_20461_20494 = state_20438__$1;
(statearr_20461_20494[(2)] = true);

(statearr_20461_20494[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20439 === (5))){
var _ = (function (){var statearr_20462 = state_20438;
(statearr_20462[(4)] = cljs.core.rest.call(null,(state_20438[(4)])));

return statearr_20462;
})();
var state_20438__$1 = state_20438;
var ex20459 = (state_20438__$1[(2)]);
var statearr_20463_20495 = state_20438__$1;
(statearr_20463_20495[(5)] = ex20459);


if((ex20459 instanceof Error)){
var statearr_20464_20496 = state_20438__$1;
(statearr_20464_20496[(1)] = (4));

(statearr_20464_20496[(5)] = null);

} else {
throw ex20459;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20439 === (14))){
var inst_20408 = (state_20438[(21)]);
var inst_20398 = (state_20438[(11)]);
var inst_20396 = (state_20438[(14)]);
var inst_20400 = (state_20438[(18)]);
var inst_20391 = (state_20438[(2)]);
var inst_20392 = cljs.core.get.call(null,inst_20391,new cljs.core.Keyword(null,"network","network",2050004697));
var inst_20393 = cljs.core.get.call(null,inst_20391,new cljs.core.Keyword(null,"t","t",-1397832519));
var inst_20394 = cljs.core.get.call(null,inst_20391,new cljs.core.Keyword(null,"fork","fork",1062974235));
var inst_20395 = cljs.core.get.call(null,inst_20391,new cljs.core.Keyword(null,"spot","spot",-1706962147));
var inst_20396__$1 = cljs.core.get.call(null,inst_20391,new cljs.core.Keyword(null,"stats","stats",-85643011));
var inst_20397 = cljs.core.get.call(null,inst_20391,new cljs.core.Keyword(null,"conn","conn",278309663));
var inst_20398__$1 = cljs.core.get.call(null,inst_20391,new cljs.core.Keyword(null,"block","block",664686210));
var inst_20399 = cljs.core.get.call(null,inst_20391,new cljs.core.Keyword(null,"psot","psot",2111653059));
var inst_20400__$1 = cljs.core.get.call(null,inst_20391,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var inst_20401 = cljs.core.get.call(null,inst_20391,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var inst_20402 = cljs.core.get.call(null,inst_20391,new cljs.core.Keyword(null,"opst","opst",1213963058));
var inst_20403 = cljs.core.get.call(null,inst_20391,new cljs.core.Keyword(null,"fork-block","fork-block",178387923));
var inst_20404 = cljs.core.get.call(null,inst_20391,new cljs.core.Keyword(null,"post","post",269697687));
var inst_20405 = fluree.db.storage.core.ledger_root_key.call(null,inst_20392,inst_20400__$1,inst_20398__$1);
var inst_20406 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"prevIndex","prevIndex",-331425114),new cljs.core.Keyword(null,"ecount","ecount",-879380887),new cljs.core.Keyword(null,"opst","opst",1213963058),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"timestamp","timestamp",579478971),new cljs.core.Keyword(null,"fork","fork",1062974235),new cljs.core.Keyword(null,"forkBlock","forkBlock",-19917508),new cljs.core.Keyword(null,"stats","stats",-85643011),new cljs.core.Keyword(null,"spot","spot",-1706962147)];
var inst_20407 = fluree.db.storage.core.child_data.call(null,inst_20399);
var inst_20408__$1 = new cljs.core.Keyword(null,"indexed","indexed",390758624).cljs$core$IFn$_invoke$arity$1(inst_20396__$1);
var state_20438__$1 = (function (){var statearr_20465 = state_20438;
(statearr_20465[(7)] = inst_20402);

(statearr_20465[(8)] = inst_20393);

(statearr_20465[(21)] = inst_20408__$1);

(statearr_20465[(9)] = inst_20394);

(statearr_20465[(10)] = inst_20404);

(statearr_20465[(11)] = inst_20398__$1);

(statearr_20465[(12)] = inst_20407);

(statearr_20465[(13)] = inst_20403);

(statearr_20465[(14)] = inst_20396__$1);

(statearr_20465[(15)] = inst_20406);

(statearr_20465[(17)] = inst_20405);

(statearr_20465[(18)] = inst_20400__$1);

(statearr_20465[(25)] = inst_20401);

(statearr_20465[(19)] = inst_20397);

(statearr_20465[(20)] = inst_20395);

return statearr_20465;
})();
if(cljs.core.truth_(inst_20408__$1)){
var statearr_20466_20497 = state_20438__$1;
(statearr_20466_20497[(1)] = (15));

} else {
var statearr_20467_20498 = state_20438__$1;
(statearr_20467_20498[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20439 === (16))){
var state_20438__$1 = state_20438;
var statearr_20468_20499 = state_20438__$1;
(statearr_20468_20499[(2)] = (0));

(statearr_20468_20499[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20439 === (10))){
var state_20438__$1 = state_20438;
var statearr_20469_20500 = state_20438__$1;
(statearr_20469_20500[(2)] = false);

(statearr_20469_20500[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20439 === (18))){
var inst_20413 = (state_20438[(24)]);
var state_20438__$1 = state_20438;
var statearr_20470_20501 = state_20438__$1;
(statearr_20470_20501[(2)] = inst_20413);

(statearr_20470_20501[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20439 === (8))){
var inst_20386 = (state_20438[(2)]);
var state_20438__$1 = state_20438;
if(cljs.core.truth_(inst_20386)){
var statearr_20471_20502 = state_20438__$1;
(statearr_20471_20502[(1)] = (12));

} else {
var statearr_20472_20503 = state_20438__$1;
(statearr_20472_20503[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2879__auto__ = null;
var fluree$db$storage$core$state_machine__2879__auto____0 = (function (){
var statearr_20473 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20473[(0)] = fluree$db$storage$core$state_machine__2879__auto__);

(statearr_20473[(1)] = (1));

return statearr_20473;
});
var fluree$db$storage$core$state_machine__2879__auto____1 = (function (state_20438){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_20438);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20474){var ex__2882__auto__ = e20474;
var statearr_20475_20504 = state_20438;
(statearr_20475_20504[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_20438[(4)]))){
var statearr_20476_20505 = state_20438;
(statearr_20476_20505[(1)] = cljs.core.first.call(null,(state_20438[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20506 = state_20438;
state_20438 = G__20506;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2879__auto__ = function(state_20438){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2879__auto____1.call(this,state_20438);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2879__auto____0;
fluree$db$storage$core$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2879__auto____1;
return fluree$db$storage$core$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20477 = f__2902__auto__.call(null);
(statearr_20477[(6)] = c__2901__auto__);

return statearr_20477;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__2901__auto___20558 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20536){
var state_val_20537 = (state_20536[(1)]);
if((state_val_20537 === (7))){
var inst_20523 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_20536__$1 = state_20536;
var statearr_20538_20559 = state_20536__$1;
(statearr_20538_20559[(2)] = inst_20523);

(statearr_20538_20559[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (1))){
var state_20536__$1 = state_20536;
var statearr_20539_20560 = state_20536__$1;
(statearr_20539_20560[(2)] = null);

(statearr_20539_20560[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (4))){
var inst_20507 = (state_20536[(2)]);
var inst_20508 = error_fn.call(null);
var inst_20509 = cljs.core.async.put_BANG_.call(null,return_ch,inst_20507);
var inst_20510 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_20536__$1 = (function (){var statearr_20540 = state_20536;
(statearr_20540[(7)] = inst_20509);

(statearr_20540[(8)] = inst_20508);

return statearr_20540;
})();
var statearr_20541_20561 = state_20536__$1;
(statearr_20541_20561[(2)] = inst_20510);

(statearr_20541_20561[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (6))){
var inst_20518 = (state_20536[(9)]);
var inst_20518__$1 = (state_20536[(2)]);
var inst_20519 = (inst_20518__$1 == null);
var inst_20520 = (inst_20518__$1 instanceof Error);
var inst_20521 = ((inst_20519) || (inst_20520));
var state_20536__$1 = (function (){var statearr_20542 = state_20536;
(statearr_20542[(9)] = inst_20518__$1);

return statearr_20542;
})();
if(cljs.core.truth_(inst_20521)){
var statearr_20543_20562 = state_20536__$1;
(statearr_20543_20562[(1)] = (7));

} else {
var statearr_20544_20563 = state_20536__$1;
(statearr_20544_20563[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (3))){
var inst_20534 = (state_20536[(2)]);
var state_20536__$1 = state_20536;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20536__$1,inst_20534);
} else {
if((state_val_20537 === (2))){
var _ = (function (){var statearr_20546 = state_20536;
(statearr_20546[(4)] = cljs.core.cons.call(null,(5),(state_20536[(4)])));

return statearr_20546;
})();
var inst_20516 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_20536__$1 = state_20536;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20536__$1,(6),inst_20516);
} else {
if((state_val_20537 === (9))){
var inst_20531 = (state_20536[(2)]);
var _ = (function (){var statearr_20547 = state_20536;
(statearr_20547[(4)] = cljs.core.rest.call(null,(state_20536[(4)])));

return statearr_20547;
})();
var state_20536__$1 = state_20536;
var statearr_20548_20564 = state_20536__$1;
(statearr_20548_20564[(2)] = inst_20531);

(statearr_20548_20564[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (5))){
var _ = (function (){var statearr_20549 = state_20536;
(statearr_20549[(4)] = cljs.core.rest.call(null,(state_20536[(4)])));

return statearr_20549;
})();
var state_20536__$1 = state_20536;
var ex20545 = (state_20536__$1[(2)]);
var statearr_20550_20565 = state_20536__$1;
(statearr_20550_20565[(5)] = ex20545);


var statearr_20551_20566 = state_20536__$1;
(statearr_20551_20566[(1)] = (4));

(statearr_20551_20566[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20537 === (8))){
var inst_20518 = (state_20536[(9)]);
var inst_20525 = fluree.db.storage.core.serde.call(null,conn);
var inst_20526 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_20525,inst_20518);
var inst_20527 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_20526);
var inst_20528 = cljs.core.sort.call(null,fluree.db.flake.cmp_flakes_history,inst_20527);
var inst_20529 = cljs.core.async.put_BANG_.call(null,return_ch,inst_20528);
var state_20536__$1 = state_20536;
var statearr_20552_20567 = state_20536__$1;
(statearr_20552_20567[(2)] = inst_20529);

(statearr_20552_20567[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__2879__auto____0 = (function (){
var statearr_20553 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20553[(0)] = fluree$db$storage$core$reify_history_$_state_machine__2879__auto__);

(statearr_20553[(1)] = (1));

return statearr_20553;
});
var fluree$db$storage$core$reify_history_$_state_machine__2879__auto____1 = (function (state_20536){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_20536);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20554){var ex__2882__auto__ = e20554;
var statearr_20555_20568 = state_20536;
(statearr_20555_20568[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_20536[(4)]))){
var statearr_20556_20569 = state_20536;
(statearr_20556_20569[(1)] = cljs.core.first.call(null,(state_20536[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20570 = state_20536;
state_20536 = G__20570;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__2879__auto__ = function(state_20536){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__2879__auto____1.call(this,state_20536);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__2879__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__2879__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20557 = f__2902__auto__.call(null);
(statearr_20557[(6)] = c__2901__auto___20558);

return statearr_20557;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__20572 = arguments.length;
switch (G__20572) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.call(null,novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not.call(null,leftmost_QMARK_);
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4115__auto__ = rhs;
if(cljs.core.truth_(and__4115__auto__)){
return leftmost_QMARK_;
} else {
return and__4115__auto__;
}
})())?clojure.data.avl.subrange.call(null,novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not.call(null,leftmost_QMARK_))))?clojure.data.avl.subrange.call(null,novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((((rhs == null))?leftmost_QMARK_:false))?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.call(null,(function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.call(null,novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.call(null);
var c__2901__auto___20682 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20635){
var state_val_20636 = (state_20635[(1)]);
if((state_val_20636 === (7))){
var state_20635__$1 = state_20635;
var statearr_20637_20683 = state_20635__$1;
(statearr_20637_20683[(2)] = new cljs.core.Keyword(null,"novelty","novelty",-1590246024));

(statearr_20637_20683[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (20))){
var inst_20614 = cljs.core.PersistentVector.EMPTY;
var state_20635__$1 = state_20635;
var statearr_20638_20684 = state_20635__$1;
(statearr_20638_20684[(2)] = inst_20614);

(statearr_20638_20684[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (1))){
var state_20635__$1 = state_20635;
var statearr_20639_20685 = state_20635__$1;
(statearr_20639_20685[(2)] = null);

(statearr_20639_20685[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (24))){
var state_20635__$1 = state_20635;
var statearr_20640_20686 = state_20635__$1;
(statearr_20640_20686[(2)] = null);

(statearr_20640_20686[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (4))){
var inst_20575 = (state_20635[(2)]);
var inst_20576 = error_fn.call(null);
var inst_20577 = cljs.core.async.put_BANG_.call(null,result_ch,inst_20575);
var inst_20578 = cljs.core.async.close_BANG_.call(null,result_ch);
var state_20635__$1 = (function (){var statearr_20641 = state_20635;
(statearr_20641[(7)] = inst_20577);

(statearr_20641[(8)] = inst_20576);

return statearr_20641;
})();
var statearr_20642_20687 = state_20635__$1;
(statearr_20642_20687[(2)] = inst_20578);

(statearr_20642_20687[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (15))){
var inst_20600 = (state_20635[(2)]);
var state_20635__$1 = state_20635;
var statearr_20643_20688 = state_20635__$1;
(statearr_20643_20688[(2)] = inst_20600);

(statearr_20643_20688[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (21))){
var inst_20589 = (state_20635[(9)]);
var inst_20588 = (state_20635[(10)]);
var inst_20587 = (state_20635[(11)]);
var inst_20604 = (state_20635[(12)]);
var inst_20617 = (state_20635[(13)]);
var inst_20624 = (state_20635[(2)]);
var inst_20625 = (function (){var base_node = inst_20587;
var first_flake = inst_20588;
var node_t = inst_20589;
var source = inst_20604;
var coll = inst_20617;
var conj_QMARK_ = inst_20624;
return (function (acc,f){
if(cljs.core.truth_((function (){var or__4126__auto__ = remove_preds;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})().call(null,f.p))){
return cljs.core.disj.call(null,acc,f);
} else {
if(cljs.core.truth_(conj_QMARK_.call(null,f))){
return cljs.core.conj.call(null,acc,f);
} else {
return cljs.core.disj.call(null,acc,f);

}
}
});
})();
var inst_20626 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(inst_20587);
var inst_20627 = cljs.core.reduce.call(null,inst_20625,inst_20626,inst_20617);
var inst_20628 = cljs.core.doall.call(null,inst_20627);
var inst_20629 = cljs.core.assoc.call(null,inst_20587,new cljs.core.Keyword(null,"flakes","flakes",1977895739),inst_20628);
var inst_20630 = cljs.core.async.put_BANG_.call(null,result_ch,inst_20629);
var _ = (function (){var statearr_20644 = state_20635;
(statearr_20644[(4)] = cljs.core.rest.call(null,(state_20635[(4)])));

return statearr_20644;
})();
var state_20635__$1 = state_20635;
var statearr_20645_20689 = state_20635__$1;
(statearr_20645_20689[(2)] = inst_20630);

(statearr_20645_20689[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (13))){
var state_20635__$1 = state_20635;
var statearr_20646_20690 = state_20635__$1;
(statearr_20646_20690[(2)] = new cljs.core.Keyword(null,"none","none",1333468478));

(statearr_20646_20690[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (22))){
var inst_20589 = (state_20635[(9)]);
var inst_20588 = (state_20635[(10)]);
var inst_20587 = (state_20635[(11)]);
var inst_20604 = (state_20635[(12)]);
var inst_20617 = (state_20635[(13)]);
var inst_20618 = (function (){var base_node = inst_20587;
var first_flake = inst_20588;
var node_t = inst_20589;
var source = inst_20604;
var coll = inst_20617;
return (function (f){
return f.op === true;
});
})();
var state_20635__$1 = state_20635;
var statearr_20647_20691 = state_20635__$1;
(statearr_20647_20691[(2)] = inst_20618);

(statearr_20647_20691[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (6))){
var inst_20589 = (state_20635[(9)]);
var inst_20587 = (state_20635[(11)]);
var inst_20586 = (state_20635[(2)]);
var inst_20587__$1 = fluree.db.util.async.throw_err.call(null,inst_20586);
var inst_20588 = fluree.db.dbproto._first_flake.call(null,inst_20587__$1);
var inst_20589__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_20587__$1);
var inst_20590 = (inst_20589__$1 > t);
var state_20635__$1 = (function (){var statearr_20648 = state_20635;
(statearr_20648[(9)] = inst_20589__$1);

(statearr_20648[(10)] = inst_20588);

(statearr_20648[(11)] = inst_20587__$1);

return statearr_20648;
})();
if(cljs.core.truth_(inst_20590)){
var statearr_20649_20692 = state_20635__$1;
(statearr_20649_20692[(1)] = (7));

} else {
var statearr_20650_20693 = state_20635__$1;
(statearr_20650_20693[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (17))){
var inst_20588 = (state_20635[(10)]);
var inst_20605 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_20588,rhs,leftmost_QMARK_,t);
var state_20635__$1 = state_20635;
var statearr_20651_20694 = state_20635__$1;
(statearr_20651_20694[(2)] = inst_20605);

(statearr_20651_20694[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (3))){
var inst_20633 = (state_20635[(2)]);
var state_20635__$1 = state_20635;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20635__$1,inst_20633);
} else {
if((state_val_20636 === (12))){
var inst_20602 = (state_20635[(2)]);
var state_20635__$1 = state_20635;
var statearr_20652_20695 = state_20635__$1;
(statearr_20652_20695[(2)] = inst_20602);

(statearr_20652_20695[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (2))){
var _ = (function (){var statearr_20653 = state_20635;
(statearr_20653[(4)] = cljs.core.cons.call(null,(5),(state_20635[(4)])));

return statearr_20653;
})();
var inst_20584 = fluree.db.dbproto._resolve.call(null,node);
var state_20635__$1 = state_20635;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20635__$1,(6),inst_20584);
} else {
if((state_val_20636 === (23))){
var inst_20589 = (state_20635[(9)]);
var inst_20588 = (state_20635[(10)]);
var inst_20587 = (state_20635[(11)]);
var inst_20604 = (state_20635[(12)]);
var inst_20617 = (state_20635[(13)]);
var inst_20620 = (function (){var base_node = inst_20587;
var first_flake = inst_20588;
var node_t = inst_20589;
var source = inst_20604;
var coll = inst_20617;
return (function (f){
return f.op === false;
});
})();
var state_20635__$1 = state_20635;
var statearr_20654_20696 = state_20635__$1;
(statearr_20654_20696[(2)] = inst_20620);

(statearr_20654_20696[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (19))){
var inst_20607 = (state_20635[(14)]);
var inst_20610 = (state_20635[(2)]);
var inst_20611 = fluree.db.util.async.throw_err.call(null,inst_20610);
var inst_20612 = cljs.core.take_while.call(null,inst_20607,inst_20611);
var state_20635__$1 = state_20635;
var statearr_20655_20697 = state_20635__$1;
(statearr_20655_20697[(2)] = inst_20612);

(statearr_20655_20697[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (11))){
var inst_20589 = (state_20635[(9)]);
var inst_20596 = cljs.core._EQ_.call(null,inst_20589,t);
var state_20635__$1 = state_20635;
if(inst_20596){
var statearr_20657_20698 = state_20635__$1;
(statearr_20657_20698[(1)] = (13));

} else {
var statearr_20658_20699 = state_20635__$1;
(statearr_20658_20699[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (9))){
var inst_20604 = (state_20635[(12)]);
var inst_20604__$1 = (state_20635[(2)]);
var state_20635__$1 = (function (){var statearr_20659 = state_20635;
(statearr_20659[(12)] = inst_20604__$1);

return statearr_20659;
})();
var G__20660_20700 = inst_20604__$1;
var G__20660_20701__$1 = (((G__20660_20700 instanceof cljs.core.Keyword))?G__20660_20700.fqn:null);
switch (G__20660_20701__$1) {
case "novelty":
var statearr_20661_20703 = state_20635__$1;
(statearr_20661_20703[(1)] = (17));


break;
case "history":
var statearr_20662_20704 = state_20635__$1;
(statearr_20662_20704[(1)] = (18));


break;
case "none":
var statearr_20663_20705 = state_20635__$1;
(statearr_20663_20705[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__20660_20701__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (5))){
var _ = (function (){var statearr_20664 = state_20635;
(statearr_20664[(4)] = cljs.core.rest.call(null,(state_20635[(4)])));

return statearr_20664;
})();
var state_20635__$1 = state_20635;
var ex20656 = (state_20635__$1[(2)]);
var statearr_20665_20706 = state_20635__$1;
(statearr_20665_20706[(5)] = ex20656);


var statearr_20666_20707 = state_20635__$1;
(statearr_20666_20707[(1)] = (4));

(statearr_20666_20707[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (14))){
var state_20635__$1 = state_20635;
var statearr_20667_20708 = state_20635__$1;
(statearr_20667_20708[(2)] = null);

(statearr_20667_20708[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (16))){
var inst_20604 = (state_20635[(12)]);
var inst_20617 = (state_20635[(2)]);
var state_20635__$1 = (function (){var statearr_20668 = state_20635;
(statearr_20668[(13)] = inst_20617);

return statearr_20668;
})();
var G__20669_20709 = inst_20604;
var G__20669_20710__$1 = (((G__20669_20709 instanceof cljs.core.Keyword))?G__20669_20709.fqn:null);
switch (G__20669_20710__$1) {
case "novelty":
var statearr_20670_20712 = state_20635__$1;
(statearr_20670_20712[(1)] = (22));


break;
case "history":
var statearr_20671_20713 = state_20635__$1;
(statearr_20671_20713[(1)] = (23));


break;
case "none":
var statearr_20672_20714 = state_20635__$1;
(statearr_20672_20714[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__20669_20710__$1)].join('')));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (10))){
var state_20635__$1 = state_20635;
var statearr_20673_20715 = state_20635__$1;
(statearr_20673_20715[(2)] = new cljs.core.Keyword(null,"history","history",-247395220));

(statearr_20673_20715[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20636 === (18))){
var inst_20589 = (state_20635[(9)]);
var inst_20588 = (state_20635[(10)]);
var inst_20587 = (state_20635[(11)]);
var inst_20604 = (state_20635[(12)]);
var inst_20607 = (function (){var base_node = inst_20587;
var first_flake = inst_20588;
var node_t = inst_20589;
var source = inst_20604;
return (function (p1__20574_SHARP_){
return (p1__20574_SHARP_.t <= t);
});
})();
var inst_20608 = fluree.db.dbproto._resolve_history.call(null,node);
var state_20635__$1 = (function (){var statearr_20674 = state_20635;
(statearr_20674[(14)] = inst_20607);

return statearr_20674;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20635__$1,(19),inst_20608);
} else {
if((state_val_20636 === (8))){
var inst_20589 = (state_20635[(9)]);
var inst_20593 = (inst_20589 < t);
var state_20635__$1 = state_20635;
if(cljs.core.truth_(inst_20593)){
var statearr_20675_20716 = state_20635__$1;
(statearr_20675_20716[(1)] = (10));

} else {
var statearr_20676_20717 = state_20635__$1;
(statearr_20676_20717[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__2879__auto____0 = (function (){
var statearr_20677 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20677[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__2879__auto__);

(statearr_20677[(1)] = (1));

return statearr_20677;
});
var fluree$db$storage$core$resolve_t_$_state_machine__2879__auto____1 = (function (state_20635){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_20635);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20678){var ex__2882__auto__ = e20678;
var statearr_20679_20718 = state_20635;
(statearr_20679_20718[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_20635[(4)]))){
var statearr_20680_20719 = state_20635;
(statearr_20680_20719[(1)] = cljs.core.first.call(null,(state_20635[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20720 = state_20635;
state_20635 = G__20720;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__2879__auto__ = function(state_20635){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__2879__auto____1.call(this,state_20635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__2879__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__2879__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20681 = f__2902__auto__.call(null);
(statearr_20681[(6)] = c__2901__auto___20682);

return statearr_20681;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20777){
var state_val_20778 = (state_20777[(1)]);
if((state_val_20778 === (7))){
var state_20777__$1 = state_20777;
var statearr_20779_20815 = state_20777__$1;
(statearr_20779_20815[(2)] = null);

(statearr_20779_20815[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20778 === (1))){
var state_20777__$1 = state_20777;
var statearr_20780_20816 = state_20777__$1;
(statearr_20780_20816[(2)] = null);

(statearr_20780_20816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20778 === (4))){
var inst_20723 = (state_20777[(2)]);
var inst_20724 = fluree.db.util.log.error.call(null,inst_20723);
var inst_20725 = (function(){throw inst_20723})();
var state_20777__$1 = (function (){var statearr_20781 = state_20777;
(statearr_20781[(7)] = inst_20724);

return statearr_20781;
})();
var statearr_20782_20817 = state_20777__$1;
(statearr_20782_20817[(2)] = inst_20725);

(statearr_20782_20817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20778 === (15))){
var inst_20753 = (state_20777[(2)]);
var state_20777__$1 = state_20777;
var statearr_20783_20818 = state_20777__$1;
(statearr_20783_20818[(2)] = inst_20753);

(statearr_20783_20818[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20778 === (13))){
var inst_20731 = (state_20777[(8)]);
var inst_20747 = (state_20777[(9)]);
var inst_20749 = (function (){var node_t = inst_20731;
var G__20736 = inst_20747;
return (function (p1__20722_SHARP_){
return (p1__20722_SHARP_.t <= from_t);
});
})();
var inst_20750 = cljs.core.take_while.call(null,inst_20749,inst_20747);
var state_20777__$1 = state_20777;
var statearr_20784_20819 = state_20777__$1;
(statearr_20784_20819[(2)] = inst_20750);

(statearr_20784_20819[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20778 === (6))){
var inst_20737 = fluree.db.dbproto._resolve_history.call(null,node);
var state_20777__$1 = state_20777;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20777__$1,(9),inst_20737);
} else {
if((state_val_20778 === (17))){
var inst_20762 = new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(node);
var inst_20763 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_20762)].join('');
var inst_20764 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20765 = [(500),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)];
var inst_20766 = cljs.core.PersistentHashMap.fromArrays(inst_20764,inst_20765);
var inst_20767 = cljs.core.ex_info.call(null,inst_20763,inst_20766);
var inst_20768 = (function(){throw inst_20767})();
var state_20777__$1 = state_20777;
var statearr_20785_20820 = state_20777__$1;
(statearr_20785_20820[(2)] = inst_20768);

(statearr_20785_20820[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20778 === (3))){
var inst_20775 = (state_20777[(2)]);
var state_20777__$1 = state_20777;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20777__$1,inst_20775);
} else {
if((state_val_20778 === (12))){
var inst_20747 = (state_20777[(2)]);
var state_20777__$1 = (function (){var statearr_20786 = state_20777;
(statearr_20786[(9)] = inst_20747);

return statearr_20786;
})();
if(cljs.core.truth_(from_t)){
var statearr_20787_20821 = state_20777__$1;
(statearr_20787_20821[(1)] = (13));

} else {
var statearr_20788_20822 = state_20777__$1;
(statearr_20788_20822[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20778 === (2))){
var inst_20731 = (state_20777[(8)]);
var _ = (function (){var statearr_20789 = state_20777;
(statearr_20789[(4)] = cljs.core.cons.call(null,(5),(state_20777[(4)])));

return statearr_20789;
})();
var inst_20731__$1 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(node);
var inst_20732 = (from_t == null);
var inst_20733 = (inst_20731__$1 <= from_t);
var inst_20734 = ((inst_20732) || (inst_20733));
var state_20777__$1 = (function (){var statearr_20790 = state_20777;
(statearr_20790[(8)] = inst_20731__$1);

return statearr_20790;
})();
if(cljs.core.truth_(inst_20734)){
var statearr_20791_20823 = state_20777__$1;
(statearr_20791_20823[(1)] = (6));

} else {
var statearr_20792_20824 = state_20777__$1;
(statearr_20792_20824[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20778 === (11))){
var inst_20740 = (state_20777[(10)]);
var state_20777__$1 = state_20777;
var statearr_20794_20825 = state_20777__$1;
(statearr_20794_20825[(2)] = inst_20740);

(statearr_20794_20825[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20778 === (9))){
var inst_20731 = (state_20777[(8)]);
var inst_20739 = (state_20777[(2)]);
var inst_20740 = fluree.db.util.async.throw_err.call(null,inst_20739);
var inst_20741 = (to_t > inst_20731);
var state_20777__$1 = (function (){var statearr_20795 = state_20777;
(statearr_20795[(10)] = inst_20740);

return statearr_20795;
})();
if(cljs.core.truth_(inst_20741)){
var statearr_20796_20826 = state_20777__$1;
(statearr_20796_20826[(1)] = (10));

} else {
var statearr_20797_20827 = state_20777__$1;
(statearr_20797_20827[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20778 === (5))){
var _ = (function (){var statearr_20798 = state_20777;
(statearr_20798[(4)] = cljs.core.rest.call(null,(state_20777[(4)])));

return statearr_20798;
})();
var state_20777__$1 = state_20777;
var ex20793 = (state_20777__$1[(2)]);
var statearr_20799_20828 = state_20777__$1;
(statearr_20799_20828[(5)] = ex20793);


var statearr_20800_20829 = state_20777__$1;
(statearr_20800_20829[(1)] = (4));

(statearr_20800_20829[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20778 === (14))){
var inst_20747 = (state_20777[(9)]);
var state_20777__$1 = state_20777;
var statearr_20801_20830 = state_20777__$1;
(statearr_20801_20830[(2)] = inst_20747);

(statearr_20801_20830[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20778 === (16))){
var state_20777__$1 = state_20777;
var statearr_20802_20831 = state_20777__$1;
(statearr_20802_20831[(2)] = null);

(statearr_20802_20831[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20778 === (10))){
var inst_20740 = (state_20777[(10)]);
var inst_20731 = (state_20777[(8)]);
var inst_20743 = (function (){var node_t = inst_20731;
var G__20736 = inst_20740;
return (function (p1__20721_SHARP_){
return (p1__20721_SHARP_.t < to_t);
});
})();
var inst_20744 = cljs.core.drop_while.call(null,inst_20743,inst_20740);
var state_20777__$1 = state_20777;
var statearr_20803_20832 = state_20777__$1;
(statearr_20803_20832[(2)] = inst_20744);

(statearr_20803_20832[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20778 === (18))){
var inst_20756 = (state_20777[(11)]);
var inst_20757 = (state_20777[(12)]);
var inst_20758 = (state_20777[(13)]);
var inst_20770 = (state_20777[(2)]);
var inst_20771 = fluree.db.storage.core.source_novelty_t.call(null,idx_novelty,inst_20757,inst_20758,leftmost_QMARK_,to_t);
var inst_20772 = cljs.core.into.call(null,inst_20771,inst_20756);
var _ = (function (){var statearr_20804 = state_20777;
(statearr_20804[(4)] = cljs.core.rest.call(null,(state_20777[(4)])));

return statearr_20804;
})();
var state_20777__$1 = (function (){var statearr_20805 = state_20777;
(statearr_20805[(14)] = inst_20770);

return statearr_20805;
})();
var statearr_20806_20833 = state_20777__$1;
(statearr_20806_20833[(2)] = inst_20772);

(statearr_20806_20833[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20778 === (8))){
var inst_20756 = (state_20777[(2)]);
var inst_20757 = fluree.db.dbproto._first_flake.call(null,node);
var inst_20758 = fluree.db.dbproto._rhs.call(null,node);
var inst_20759 = new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(node);
var state_20777__$1 = (function (){var statearr_20807 = state_20777;
(statearr_20807[(11)] = inst_20756);

(statearr_20807[(12)] = inst_20757);

(statearr_20807[(13)] = inst_20758);

return statearr_20807;
})();
if(cljs.core.truth_(inst_20759)){
var statearr_20808_20834 = state_20777__$1;
(statearr_20808_20834[(1)] = (16));

} else {
var statearr_20809_20835 = state_20777__$1;
(statearr_20809_20835[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto____0 = (function (){
var statearr_20810 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20810[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto__);

(statearr_20810[(1)] = (1));

return statearr_20810;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto____1 = (function (state_20777){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_20777);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20811){var ex__2882__auto__ = e20811;
var statearr_20812_20836 = state_20777;
(statearr_20812_20836[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_20777[(4)]))){
var statearr_20813_20837 = state_20777;
(statearr_20813_20837[(1)] = cljs.core.first.call(null,(state_20777[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20838 = state_20777;
state_20777 = G__20838;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto__ = function(state_20777){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto____1.call(this,state_20777);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20814 = f__2902__auto__.call(null);
(statearr_20814[(6)] = c__2901__auto__);

return statearr_20814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4126__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),id);
}
})())){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_.call(null,remove_preds)))){
object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);

return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
} else {
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),(function (_){
return fluree.db.storage.core.resolve_t.call(null,node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null),null);
}));
}));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20859){
var state_val_20860 = (state_20859[(1)]);
if((state_val_20860 === (7))){
var state_20859__$1 = state_20859;
var statearr_20861_20881 = state_20859__$1;
(statearr_20861_20881[(2)] = null);

(statearr_20861_20881[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20860 === (1))){
var state_20859__$1 = state_20859;
var statearr_20862_20882 = state_20859__$1;
(statearr_20862_20882[(2)] = null);

(statearr_20862_20882[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20860 === (4))){
var inst_20839 = (state_20859[(2)]);
var state_20859__$1 = state_20859;
var statearr_20863_20883 = state_20859__$1;
(statearr_20863_20883[(2)] = inst_20839);

(statearr_20863_20883[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20860 === (6))){
var inst_20845 = (state_20859[(7)]);
var inst_20847 = fluree.db.storage.core.serde.call(null,conn);
var state_20859__$1 = (function (){var statearr_20864 = state_20859;
(statearr_20864[(8)] = inst_20847);

return statearr_20864;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20859__$1,(9),inst_20845);
} else {
if((state_val_20860 === (3))){
var inst_20857 = (state_20859[(2)]);
var state_20859__$1 = state_20859;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20859__$1,inst_20857);
} else {
if((state_val_20860 === (2))){
var inst_20845 = (state_20859[(7)]);
var _ = (function (){var statearr_20866 = state_20859;
(statearr_20866[(4)] = cljs.core.cons.call(null,(5),(state_20859[(4)])));

return statearr_20866;
})();
var inst_20845__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_20859__$1 = (function (){var statearr_20867 = state_20859;
(statearr_20867[(7)] = inst_20845__$1);

return statearr_20867;
})();
if(cljs.core.truth_(inst_20845__$1)){
var statearr_20868_20884 = state_20859__$1;
(statearr_20868_20884[(1)] = (6));

} else {
var statearr_20869_20885 = state_20859__$1;
(statearr_20869_20885[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20860 === (9))){
var inst_20847 = (state_20859[(8)]);
var inst_20849 = (state_20859[(2)]);
var inst_20850 = fluree.db.util.async.throw_err.call(null,inst_20849);
var inst_20851 = fluree.db.serde.protocol._deserialize_branch.call(null,inst_20847,inst_20850);
var state_20859__$1 = state_20859;
var statearr_20870_20886 = state_20859__$1;
(statearr_20870_20886[(2)] = inst_20851);

(statearr_20870_20886[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20860 === (5))){
var _ = (function (){var statearr_20871 = state_20859;
(statearr_20871[(4)] = cljs.core.rest.call(null,(state_20859[(4)])));

return statearr_20871;
})();
var state_20859__$1 = state_20859;
var ex20865 = (state_20859__$1[(2)]);
var statearr_20872_20887 = state_20859__$1;
(statearr_20872_20887[(5)] = ex20865);


if((ex20865 instanceof Error)){
var statearr_20873_20888 = state_20859__$1;
(statearr_20873_20888[(1)] = (4));

(statearr_20873_20888[(5)] = null);

} else {
throw ex20865;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20860 === (8))){
var inst_20854 = (state_20859[(2)]);
var _ = (function (){var statearr_20874 = state_20859;
(statearr_20874[(4)] = cljs.core.rest.call(null,(state_20859[(4)])));

return statearr_20874;
})();
var state_20859__$1 = state_20859;
var statearr_20875_20889 = state_20859__$1;
(statearr_20875_20889[(2)] = inst_20854);

(statearr_20875_20889[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__2879__auto____0 = (function (){
var statearr_20876 = [null,null,null,null,null,null,null,null,null];
(statearr_20876[(0)] = fluree$db$storage$core$read_branch_$_state_machine__2879__auto__);

(statearr_20876[(1)] = (1));

return statearr_20876;
});
var fluree$db$storage$core$read_branch_$_state_machine__2879__auto____1 = (function (state_20859){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_20859);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e20877){var ex__2882__auto__ = e20877;
var statearr_20878_20890 = state_20859;
(statearr_20878_20890[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_20859[(4)]))){
var statearr_20879_20891 = state_20859;
(statearr_20879_20891[(1)] = cljs.core.first.call(null,(state_20859[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20892 = state_20859;
state_20859 = G__20892;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__2879__auto__ = function(state_20859){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__2879__auto____1.call(this,state_20859);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__2879__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__2879__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_20880 = f__2902__auto__.call(null);
(statearr_20880[(6)] = c__2901__auto__);

return statearr_20880;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.call(null);
var c__2901__auto___21038 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_20983){
var state_val_20984 = (state_20983[(1)]);
if((state_val_20984 === (7))){
var inst_20910 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_20911 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_20912 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_20913 = cljs.core.PersistentHashMap.fromArrays(inst_20911,inst_20912);
var inst_20914 = cljs.core.ex_info.call(null,inst_20910,inst_20913);
var inst_20915 = (function(){throw inst_20914})();
var state_20983__$1 = state_20983;
var statearr_20985_21039 = state_20983__$1;
(statearr_20985_21039[(2)] = inst_20915);

(statearr_20985_21039[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (20))){
var inst_20907 = (state_20983[(7)]);
var state_20983__$1 = state_20983;
var statearr_20986_21040 = state_20983__$1;
(statearr_20986_21040[(2)] = inst_20907);

(statearr_20986_21040[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (27))){
var inst_20961 = (state_20983[(2)]);
var state_20983__$1 = state_20983;
var statearr_20987_21041 = state_20983__$1;
(statearr_20987_21041[(2)] = inst_20961);

(statearr_20987_21041[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (1))){
var state_20983__$1 = state_20983;
var statearr_20988_21042 = state_20983__$1;
(statearr_20988_21042[(2)] = null);

(statearr_20988_21042[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (24))){
var inst_20964 = (state_20983[(2)]);
var state_20983__$1 = state_20983;
if(cljs.core.truth_(inst_20964)){
var statearr_20989_21043 = state_20983__$1;
(statearr_20989_21043[(1)] = (28));

} else {
var statearr_20990_21044 = state_20983__$1;
(statearr_20990_21044[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (4))){
var inst_20893 = (state_20983[(2)]);
var inst_20894 = error_fn.call(null);
var inst_20895 = cljs.core.async.put_BANG_.call(null,return_ch,inst_20893);
var inst_20896 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_20983__$1 = (function (){var statearr_20991 = state_20983;
(statearr_20991[(8)] = inst_20895);

(statearr_20991[(9)] = inst_20894);

return statearr_20991;
})();
var statearr_20992_21045 = state_20983__$1;
(statearr_20992_21045[(2)] = inst_20896);

(statearr_20992_21045[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (15))){
var inst_20940 = (state_20983[(2)]);
var state_20983__$1 = state_20983;
if(cljs.core.truth_(inst_20940)){
var statearr_20993_21046 = state_20983__$1;
(statearr_20993_21046[(1)] = (19));

} else {
var statearr_20994_21047 = state_20983__$1;
(statearr_20994_21047[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (21))){
var inst_20945 = (state_20983[(10)]);
var inst_20948 = (state_20983[(11)]);
var inst_20945__$1 = (state_20983[(2)]);
var inst_20946 = cljs.core.get.call(null,inst_20945__$1,new cljs.core.Keyword(null,"children","children",-940561982));
var inst_20947 = cljs.core.get.call(null,inst_20945__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var inst_20948__$1 = config;
var inst_20950 = (inst_20948__$1 == null);
var inst_20951 = cljs.core.not.call(null,inst_20950);
var state_20983__$1 = (function (){var statearr_20995 = state_20983;
(statearr_20995[(10)] = inst_20945__$1);

(statearr_20995[(12)] = inst_20946);

(statearr_20995[(11)] = inst_20948__$1);

(statearr_20995[(13)] = inst_20947);

return statearr_20995;
})();
if(inst_20951){
var statearr_20996_21048 = state_20983__$1;
(statearr_20996_21048[(1)] = (22));

} else {
var statearr_20997_21049 = state_20983__$1;
(statearr_20997_21049[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (13))){
var inst_20907 = (state_20983[(7)]);
var inst_20929 = inst_20907.cljs$lang$protocol_mask$partition0$;
var inst_20930 = (inst_20929 & (64));
var inst_20931 = inst_20907.cljs$core$ISeq$;
var inst_20932 = (cljs.core.PROTOCOL_SENTINEL === inst_20931);
var inst_20933 = ((inst_20930) || (inst_20932));
var state_20983__$1 = state_20983;
if(cljs.core.truth_(inst_20933)){
var statearr_20998_21050 = state_20983__$1;
(statearr_20998_21050[(1)] = (16));

} else {
var statearr_20999_21051 = state_20983__$1;
(statearr_20999_21051[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (22))){
var inst_20948 = (state_20983[(11)]);
var inst_20953 = inst_20948.cljs$lang$protocol_mask$partition0$;
var inst_20954 = (inst_20953 & (64));
var inst_20955 = inst_20948.cljs$core$ISeq$;
var inst_20956 = (cljs.core.PROTOCOL_SENTINEL === inst_20955);
var inst_20957 = ((inst_20954) || (inst_20956));
var state_20983__$1 = state_20983;
if(cljs.core.truth_(inst_20957)){
var statearr_21000_21052 = state_20983__$1;
(statearr_21000_21052[(1)] = (25));

} else {
var statearr_21001_21053 = state_20983__$1;
(statearr_21001_21053[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (29))){
var inst_20948 = (state_20983[(11)]);
var state_20983__$1 = state_20983;
var statearr_21002_21054 = state_20983__$1;
(statearr_21002_21054[(2)] = inst_20948);

(statearr_21002_21054[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (6))){
var inst_20907 = (state_20983[(7)]);
var inst_20906 = (state_20983[(2)]);
var inst_20907__$1 = fluree.db.util.async.throw_err.call(null,inst_20906);
var inst_20908 = (inst_20907__$1 == null);
var state_20983__$1 = (function (){var statearr_21003 = state_20983;
(statearr_21003[(7)] = inst_20907__$1);

return statearr_21003;
})();
if(cljs.core.truth_(inst_20908)){
var statearr_21004_21055 = state_20983__$1;
(statearr_21004_21055[(1)] = (7));

} else {
var statearr_21005_21056 = state_20983__$1;
(statearr_21005_21056[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (28))){
var inst_20948 = (state_20983[(11)]);
var inst_20966 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20948);
var state_20983__$1 = state_20983;
var statearr_21006_21057 = state_20983__$1;
(statearr_21006_21057[(2)] = inst_20966);

(statearr_21006_21057[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (25))){
var state_20983__$1 = state_20983;
var statearr_21007_21058 = state_20983__$1;
(statearr_21007_21058[(2)] = true);

(statearr_21007_21058[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (17))){
var state_20983__$1 = state_20983;
var statearr_21008_21059 = state_20983__$1;
(statearr_21008_21059[(2)] = false);

(statearr_21008_21059[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (3))){
var inst_20981 = (state_20983[(2)]);
var state_20983__$1 = state_20983;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20983__$1,inst_20981);
} else {
if((state_val_20984 === (12))){
var inst_20907 = (state_20983[(7)]);
var inst_20924 = (state_20983[(2)]);
var inst_20926 = (inst_20907 == null);
var inst_20927 = cljs.core.not.call(null,inst_20926);
var state_20983__$1 = (function (){var statearr_21009 = state_20983;
(statearr_21009[(14)] = inst_20924);

return statearr_21009;
})();
if(inst_20927){
var statearr_21010_21060 = state_20983__$1;
(statearr_21010_21060[(1)] = (13));

} else {
var statearr_21011_21061 = state_20983__$1;
(statearr_21011_21061[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (2))){
var _ = (function (){var statearr_21012 = state_20983;
(statearr_21012[(4)] = cljs.core.cons.call(null,(5),(state_20983[(4)])));

return statearr_21012;
})();
var inst_20904 = fluree.db.storage.core.read_branch.call(null,conn,key);
var state_20983__$1 = state_20983;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20983__$1,(6),inst_20904);
} else {
if((state_val_20984 === (23))){
var state_20983__$1 = state_20983;
var statearr_21013_21062 = state_20983__$1;
(statearr_21013_21062[(2)] = false);

(statearr_21013_21062[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (19))){
var inst_20907 = (state_20983[(7)]);
var inst_20942 = cljs.core.apply.call(null,cljs.core.hash_map,inst_20907);
var state_20983__$1 = state_20983;
var statearr_21014_21063 = state_20983__$1;
(statearr_21014_21063[(2)] = inst_20942);

(statearr_21014_21063[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (11))){
var state_20983__$1 = state_20983;
var statearr_21016_21064 = state_20983__$1;
(statearr_21016_21064[(2)] = null);

(statearr_21016_21064[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (9))){
var inst_20907 = (state_20983[(7)]);
var inst_20918 = (state_20983[(2)]);
var inst_20919 = fluree.db.util.core.exception_QMARK_.call(null,inst_20907);
var state_20983__$1 = (function (){var statearr_21017 = state_20983;
(statearr_21017[(15)] = inst_20918);

return statearr_21017;
})();
if(inst_20919){
var statearr_21018_21065 = state_20983__$1;
(statearr_21018_21065[(1)] = (10));

} else {
var statearr_21019_21066 = state_20983__$1;
(statearr_21019_21066[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (5))){
var _ = (function (){var statearr_21020 = state_20983;
(statearr_21020[(4)] = cljs.core.rest.call(null,(state_20983[(4)])));

return statearr_21020;
})();
var state_20983__$1 = state_20983;
var ex21015 = (state_20983__$1[(2)]);
var statearr_21021_21067 = state_20983__$1;
(statearr_21021_21067[(5)] = ex21015);


var statearr_21022_21068 = state_20983__$1;
(statearr_21022_21068[(1)] = (4));

(statearr_21022_21068[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (14))){
var state_20983__$1 = state_20983;
var statearr_21023_21069 = state_20983__$1;
(statearr_21023_21069[(2)] = false);

(statearr_21023_21069[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (26))){
var state_20983__$1 = state_20983;
var statearr_21024_21070 = state_20983__$1;
(statearr_21024_21070[(2)] = false);

(statearr_21024_21070[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (16))){
var state_20983__$1 = state_20983;
var statearr_21025_21071 = state_20983__$1;
(statearr_21025_21071[(2)] = true);

(statearr_21025_21071[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (30))){
var inst_20945 = (state_20983[(10)]);
var inst_20924 = (state_20983[(14)]);
var inst_20946 = (state_20983[(12)]);
var inst_20947 = (state_20983[(13)]);
var inst_20907 = (state_20983[(7)]);
var inst_20969 = (state_20983[(2)]);
var inst_20970 = cljs.core.get.call(null,inst_20969,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_20972 = (function (){var data = inst_20907;
var _ = inst_20924;
var map__20902 = inst_20945;
var children = inst_20946;
var rhs = inst_20947;
var map__20903 = inst_20969;
var comparator = inst_20970;
return (function (idx,p__20971){
var map__21026 = p__20971;
var map__21026__$1 = (((((!((map__21026 == null))))?(((((map__21026.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21026.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21026):map__21026);
var child = map__21026__$1;
var id = cljs.core.get.call(null,map__21026__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var leaf = cljs.core.get.call(null,map__21026__$1,new cljs.core.Keyword(null,"leaf","leaf",1306118732));
var first = cljs.core.get.call(null,map__21026__$1,new cljs.core.Keyword(null,"first","first",-644103046));
var rhs__$1 = cljs.core.get.call(null,map__21026__$1,new cljs.core.Keyword(null,"rhs","rhs",-229356739));
var size = cljs.core.get.call(null,map__21026__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var at_leftmost_QMARK_ = (function (){var and__4115__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return (idx === (0));
} else {
return and__4115__auto__;
}
})();
return fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid);
});
})();
var inst_20973 = cljs.core.map_indexed.call(null,inst_20972,inst_20946);
var inst_20974 = cljs.core.map.call(null,new cljs.core.Keyword(null,"first","first",-644103046),inst_20973);
var inst_20975 = cljs.core.interleave.call(null,inst_20974,inst_20973);
var inst_20976 = cljs.core.apply.call(null,clojure.data.avl.sorted_map_by,inst_20970,inst_20975);
var inst_20977 = fluree.db.index.__GT_IndexNode.call(null,block,t,inst_20947,inst_20976,config,leftmost_QMARK_);
var inst_20978 = cljs.core.async.put_BANG_.call(null,return_ch,inst_20977);
var _ = (function (){var statearr_21028 = state_20983;
(statearr_21028[(4)] = cljs.core.rest.call(null,(state_20983[(4)])));

return statearr_21028;
})();
var state_20983__$1 = state_20983;
var statearr_21029_21072 = state_20983__$1;
(statearr_21029_21072[(2)] = inst_20978);

(statearr_21029_21072[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (10))){
var inst_20907 = (state_20983[(7)]);
var inst_20921 = (function(){throw inst_20907})();
var state_20983__$1 = state_20983;
var statearr_21030_21073 = state_20983__$1;
(statearr_21030_21073[(2)] = inst_20921);

(statearr_21030_21073[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (18))){
var inst_20937 = (state_20983[(2)]);
var state_20983__$1 = state_20983;
var statearr_21031_21074 = state_20983__$1;
(statearr_21031_21074[(2)] = inst_20937);

(statearr_21031_21074[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20984 === (8))){
var state_20983__$1 = state_20983;
var statearr_21032_21075 = state_20983__$1;
(statearr_21032_21075[(2)] = null);

(statearr_21032_21075[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__2879__auto____0 = (function (){
var statearr_21033 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21033[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__2879__auto__);

(statearr_21033[(1)] = (1));

return statearr_21033;
});
var fluree$db$storage$core$reify_branch_$_state_machine__2879__auto____1 = (function (state_20983){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_20983);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21034){var ex__2882__auto__ = e21034;
var statearr_21035_21076 = state_20983;
(statearr_21035_21076[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_20983[(4)]))){
var statearr_21036_21077 = state_20983;
(statearr_21036_21077[(1)] = cljs.core.first.call(null,(state_20983[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21078 = state_20983;
state_20983 = G__21078;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__2879__auto__ = function(state_20983){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__2879__auto____1.call(this,state_20983);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__2879__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__2879__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21037 = f__2902__auto__.call(null);
(statearr_21037[(6)] = c__2901__auto___21038);

return statearr_21037;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_21099){
var state_val_21100 = (state_21099[(1)]);
if((state_val_21100 === (7))){
var state_21099__$1 = state_21099;
var statearr_21101_21121 = state_21099__$1;
(statearr_21101_21121[(2)] = null);

(statearr_21101_21121[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21100 === (1))){
var state_21099__$1 = state_21099;
var statearr_21102_21122 = state_21099__$1;
(statearr_21102_21122[(2)] = null);

(statearr_21102_21122[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21100 === (4))){
var inst_21079 = (state_21099[(2)]);
var state_21099__$1 = state_21099;
var statearr_21103_21123 = state_21099__$1;
(statearr_21103_21123[(2)] = inst_21079);

(statearr_21103_21123[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21100 === (6))){
var inst_21085 = (state_21099[(7)]);
var inst_21087 = fluree.db.storage.core.serde.call(null,conn);
var state_21099__$1 = (function (){var statearr_21104 = state_21099;
(statearr_21104[(8)] = inst_21087);

return statearr_21104;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21099__$1,(9),inst_21085);
} else {
if((state_val_21100 === (3))){
var inst_21097 = (state_21099[(2)]);
var state_21099__$1 = state_21099;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21099__$1,inst_21097);
} else {
if((state_val_21100 === (2))){
var inst_21085 = (state_21099[(7)]);
var _ = (function (){var statearr_21106 = state_21099;
(statearr_21106[(4)] = cljs.core.cons.call(null,(5),(state_21099[(4)])));

return statearr_21106;
})();
var inst_21085__$1 = fluree.db.storage.core.storage_read.call(null,conn,key);
var state_21099__$1 = (function (){var statearr_21107 = state_21099;
(statearr_21107[(7)] = inst_21085__$1);

return statearr_21107;
})();
if(cljs.core.truth_(inst_21085__$1)){
var statearr_21108_21124 = state_21099__$1;
(statearr_21108_21124[(1)] = (6));

} else {
var statearr_21109_21125 = state_21099__$1;
(statearr_21109_21125[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21100 === (9))){
var inst_21087 = (state_21099[(8)]);
var inst_21089 = (state_21099[(2)]);
var inst_21090 = fluree.db.util.async.throw_err.call(null,inst_21089);
var inst_21091 = fluree.db.serde.protocol._deserialize_leaf.call(null,inst_21087,inst_21090);
var state_21099__$1 = state_21099;
var statearr_21110_21126 = state_21099__$1;
(statearr_21110_21126[(2)] = inst_21091);

(statearr_21110_21126[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21100 === (5))){
var _ = (function (){var statearr_21111 = state_21099;
(statearr_21111[(4)] = cljs.core.rest.call(null,(state_21099[(4)])));

return statearr_21111;
})();
var state_21099__$1 = state_21099;
var ex21105 = (state_21099__$1[(2)]);
var statearr_21112_21127 = state_21099__$1;
(statearr_21112_21127[(5)] = ex21105);


if((ex21105 instanceof Error)){
var statearr_21113_21128 = state_21099__$1;
(statearr_21113_21128[(1)] = (4));

(statearr_21113_21128[(5)] = null);

} else {
throw ex21105;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21100 === (8))){
var inst_21094 = (state_21099[(2)]);
var _ = (function (){var statearr_21114 = state_21099;
(statearr_21114[(4)] = cljs.core.rest.call(null,(state_21099[(4)])));

return statearr_21114;
})();
var state_21099__$1 = state_21099;
var statearr_21115_21129 = state_21099__$1;
(statearr_21115_21129[(2)] = inst_21094);

(statearr_21115_21129[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__2879__auto____0 = (function (){
var statearr_21116 = [null,null,null,null,null,null,null,null,null];
(statearr_21116[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__2879__auto__);

(statearr_21116[(1)] = (1));

return statearr_21116;
});
var fluree$db$storage$core$read_leaf_$_state_machine__2879__auto____1 = (function (state_21099){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_21099);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21117){var ex__2882__auto__ = e21117;
var statearr_21118_21130 = state_21099;
(statearr_21118_21130[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_21099[(4)]))){
var statearr_21119_21131 = state_21099;
(statearr_21119_21131[(1)] = cljs.core.first.call(null,(state_21099[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21132 = state_21099;
state_21099 = G__21132;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__2879__auto__ = function(state_21099){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__2879__auto____1.call(this,state_21099);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__2879__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__2879__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21120 = f__2902__auto__.call(null);
(statearr_21120[(6)] = c__2901__auto__);

return statearr_21120;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.call(null,config)].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.call(null);
var c__2901__auto___21270 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_21217){
var state_val_21218 = (state_21217[(1)]);
if((state_val_21218 === (7))){
var inst_21149 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_21150 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21151 = [(500),new cljs.core.Keyword("db","storage-error","db/storage-error",-1318220587)];
var inst_21152 = cljs.core.PersistentHashMap.fromArrays(inst_21150,inst_21151);
var inst_21153 = cljs.core.ex_info.call(null,inst_21149,inst_21152);
var inst_21154 = (function(){throw inst_21153})();
var state_21217__$1 = state_21217;
var statearr_21219_21271 = state_21217__$1;
(statearr_21219_21271[(2)] = inst_21154);

(statearr_21219_21271[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (20))){
var inst_21146 = (state_21217[(7)]);
var state_21217__$1 = state_21217;
var statearr_21220_21272 = state_21217__$1;
(statearr_21220_21272[(2)] = inst_21146);

(statearr_21220_21272[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (27))){
var inst_21200 = (state_21217[(2)]);
var state_21217__$1 = state_21217;
var statearr_21221_21273 = state_21217__$1;
(statearr_21221_21273[(2)] = inst_21200);

(statearr_21221_21273[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (1))){
var state_21217__$1 = state_21217;
var statearr_21222_21274 = state_21217__$1;
(statearr_21222_21274[(2)] = null);

(statearr_21222_21274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (24))){
var inst_21203 = (state_21217[(2)]);
var state_21217__$1 = state_21217;
if(cljs.core.truth_(inst_21203)){
var statearr_21223_21275 = state_21217__$1;
(statearr_21223_21275[(1)] = (28));

} else {
var statearr_21224_21276 = state_21217__$1;
(statearr_21224_21276[(1)] = (29));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (4))){
var inst_21133 = (state_21217[(2)]);
var inst_21134 = error_fn.call(null);
var inst_21135 = cljs.core.async.put_BANG_.call(null,return_ch,inst_21133);
var inst_21136 = cljs.core.async.close_BANG_.call(null,return_ch);
var state_21217__$1 = (function (){var statearr_21225 = state_21217;
(statearr_21225[(8)] = inst_21134);

(statearr_21225[(9)] = inst_21135);

return statearr_21225;
})();
var statearr_21226_21277 = state_21217__$1;
(statearr_21226_21277[(2)] = inst_21136);

(statearr_21226_21277[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (15))){
var inst_21179 = (state_21217[(2)]);
var state_21217__$1 = state_21217;
if(cljs.core.truth_(inst_21179)){
var statearr_21227_21278 = state_21217__$1;
(statearr_21227_21278[(1)] = (19));

} else {
var statearr_21228_21279 = state_21217__$1;
(statearr_21228_21279[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (21))){
var inst_21187 = (state_21217[(10)]);
var inst_21184 = (state_21217[(2)]);
var inst_21185 = cljs.core.get.call(null,inst_21184,new cljs.core.Keyword(null,"flakes","flakes",1977895739));
var inst_21186 = cljs.core.get.call(null,inst_21184,new cljs.core.Keyword(null,"his","his",-1294347076));
var inst_21187__$1 = config;
var inst_21189 = (inst_21187__$1 == null);
var inst_21190 = cljs.core.not.call(null,inst_21189);
var state_21217__$1 = (function (){var statearr_21229 = state_21217;
(statearr_21229[(11)] = inst_21185);

(statearr_21229[(12)] = inst_21186);

(statearr_21229[(10)] = inst_21187__$1);

return statearr_21229;
})();
if(inst_21190){
var statearr_21230_21280 = state_21217__$1;
(statearr_21230_21280[(1)] = (22));

} else {
var statearr_21231_21281 = state_21217__$1;
(statearr_21231_21281[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (13))){
var inst_21146 = (state_21217[(7)]);
var inst_21168 = inst_21146.cljs$lang$protocol_mask$partition0$;
var inst_21169 = (inst_21168 & (64));
var inst_21170 = inst_21146.cljs$core$ISeq$;
var inst_21171 = (cljs.core.PROTOCOL_SENTINEL === inst_21170);
var inst_21172 = ((inst_21169) || (inst_21171));
var state_21217__$1 = state_21217;
if(cljs.core.truth_(inst_21172)){
var statearr_21232_21282 = state_21217__$1;
(statearr_21232_21282[(1)] = (16));

} else {
var statearr_21233_21283 = state_21217__$1;
(statearr_21233_21283[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (22))){
var inst_21187 = (state_21217[(10)]);
var inst_21192 = inst_21187.cljs$lang$protocol_mask$partition0$;
var inst_21193 = (inst_21192 & (64));
var inst_21194 = inst_21187.cljs$core$ISeq$;
var inst_21195 = (cljs.core.PROTOCOL_SENTINEL === inst_21194);
var inst_21196 = ((inst_21193) || (inst_21195));
var state_21217__$1 = state_21217;
if(cljs.core.truth_(inst_21196)){
var statearr_21234_21284 = state_21217__$1;
(statearr_21234_21284[(1)] = (25));

} else {
var statearr_21235_21285 = state_21217__$1;
(statearr_21235_21285[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (29))){
var inst_21187 = (state_21217[(10)]);
var state_21217__$1 = state_21217;
var statearr_21236_21286 = state_21217__$1;
(statearr_21236_21286[(2)] = inst_21187);

(statearr_21236_21286[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (6))){
var inst_21146 = (state_21217[(7)]);
var inst_21146__$1 = (state_21217[(2)]);
var inst_21147 = (inst_21146__$1 == null);
var state_21217__$1 = (function (){var statearr_21237 = state_21217;
(statearr_21237[(7)] = inst_21146__$1);

return statearr_21237;
})();
if(cljs.core.truth_(inst_21147)){
var statearr_21238_21287 = state_21217__$1;
(statearr_21238_21287[(1)] = (7));

} else {
var statearr_21239_21288 = state_21217__$1;
(statearr_21239_21288[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (28))){
var inst_21187 = (state_21217[(10)]);
var inst_21205 = cljs.core.apply.call(null,cljs.core.hash_map,inst_21187);
var state_21217__$1 = state_21217;
var statearr_21240_21289 = state_21217__$1;
(statearr_21240_21289[(2)] = inst_21205);

(statearr_21240_21289[(1)] = (30));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (25))){
var state_21217__$1 = state_21217;
var statearr_21241_21290 = state_21217__$1;
(statearr_21241_21290[(2)] = true);

(statearr_21241_21290[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (17))){
var state_21217__$1 = state_21217;
var statearr_21242_21291 = state_21217__$1;
(statearr_21242_21291[(2)] = false);

(statearr_21242_21291[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (3))){
var inst_21215 = (state_21217[(2)]);
var state_21217__$1 = state_21217;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21217__$1,inst_21215);
} else {
if((state_val_21218 === (12))){
var inst_21146 = (state_21217[(7)]);
var inst_21163 = (state_21217[(2)]);
var inst_21165 = (inst_21146 == null);
var inst_21166 = cljs.core.not.call(null,inst_21165);
var state_21217__$1 = (function (){var statearr_21243 = state_21217;
(statearr_21243[(13)] = inst_21163);

return statearr_21243;
})();
if(inst_21166){
var statearr_21244_21292 = state_21217__$1;
(statearr_21244_21292[(1)] = (13));

} else {
var statearr_21245_21293 = state_21217__$1;
(statearr_21245_21293[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (2))){
var _ = (function (){var statearr_21246 = state_21217;
(statearr_21246[(4)] = cljs.core.cons.call(null,(5),(state_21217[(4)])));

return statearr_21246;
})();
var inst_21144 = fluree.db.storage.core.read_leaf.call(null,conn,key);
var state_21217__$1 = state_21217;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21217__$1,(6),inst_21144);
} else {
if((state_val_21218 === (23))){
var state_21217__$1 = state_21217;
var statearr_21247_21294 = state_21217__$1;
(statearr_21247_21294[(2)] = false);

(statearr_21247_21294[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (19))){
var inst_21146 = (state_21217[(7)]);
var inst_21181 = cljs.core.apply.call(null,cljs.core.hash_map,inst_21146);
var state_21217__$1 = state_21217;
var statearr_21248_21295 = state_21217__$1;
(statearr_21248_21295[(2)] = inst_21181);

(statearr_21248_21295[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (11))){
var state_21217__$1 = state_21217;
var statearr_21250_21296 = state_21217__$1;
(statearr_21250_21296[(2)] = null);

(statearr_21250_21296[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (9))){
var inst_21146 = (state_21217[(7)]);
var inst_21157 = (state_21217[(2)]);
var inst_21158 = fluree.db.util.core.exception_QMARK_.call(null,inst_21146);
var state_21217__$1 = (function (){var statearr_21251 = state_21217;
(statearr_21251[(14)] = inst_21157);

return statearr_21251;
})();
if(inst_21158){
var statearr_21252_21297 = state_21217__$1;
(statearr_21252_21297[(1)] = (10));

} else {
var statearr_21253_21298 = state_21217__$1;
(statearr_21253_21298[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (5))){
var _ = (function (){var statearr_21254 = state_21217;
(statearr_21254[(4)] = cljs.core.rest.call(null,(state_21217[(4)])));

return statearr_21254;
})();
var state_21217__$1 = state_21217;
var ex21249 = (state_21217__$1[(2)]);
var statearr_21255_21299 = state_21217__$1;
(statearr_21255_21299[(5)] = ex21249);


var statearr_21256_21300 = state_21217__$1;
(statearr_21256_21300[(1)] = (4));

(statearr_21256_21300[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (14))){
var state_21217__$1 = state_21217;
var statearr_21257_21301 = state_21217__$1;
(statearr_21257_21301[(2)] = false);

(statearr_21257_21301[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (26))){
var state_21217__$1 = state_21217;
var statearr_21258_21302 = state_21217__$1;
(statearr_21258_21302[(2)] = false);

(statearr_21258_21302[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (16))){
var state_21217__$1 = state_21217;
var statearr_21259_21303 = state_21217__$1;
(statearr_21259_21303[(2)] = true);

(statearr_21259_21303[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (30))){
var inst_21185 = (state_21217[(11)]);
var inst_21208 = (state_21217[(2)]);
var inst_21209 = cljs.core.get.call(null,inst_21208,new cljs.core.Keyword(null,"comparator","comparator",2144896662));
var inst_21210 = cljs.core.apply.call(null,fluree.db.flake.sorted_set_by,inst_21209,inst_21185);
var inst_21211 = fluree.db.index.data_node.call(null,block,t,inst_21210,rhs,config);
var inst_21212 = cljs.core.async.put_BANG_.call(null,return_ch,inst_21211);
var _ = (function (){var statearr_21260 = state_21217;
(statearr_21260[(4)] = cljs.core.rest.call(null,(state_21217[(4)])));

return statearr_21260;
})();
var state_21217__$1 = state_21217;
var statearr_21261_21304 = state_21217__$1;
(statearr_21261_21304[(2)] = inst_21212);

(statearr_21261_21304[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (10))){
var inst_21146 = (state_21217[(7)]);
var inst_21160 = (function(){throw inst_21146})();
var state_21217__$1 = state_21217;
var statearr_21262_21305 = state_21217__$1;
(statearr_21262_21305[(2)] = inst_21160);

(statearr_21262_21305[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (18))){
var inst_21176 = (state_21217[(2)]);
var state_21217__$1 = state_21217;
var statearr_21263_21306 = state_21217__$1;
(statearr_21263_21306[(2)] = inst_21176);

(statearr_21263_21306[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21218 === (8))){
var state_21217__$1 = state_21217;
var statearr_21264_21307 = state_21217__$1;
(statearr_21264_21307[(2)] = null);

(statearr_21264_21307[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto____0 = (function (){
var statearr_21265 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21265[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto__);

(statearr_21265[(1)] = (1));

return statearr_21265;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto____1 = (function (state_21217){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_21217);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21266){var ex__2882__auto__ = e21266;
var statearr_21267_21308 = state_21217;
(statearr_21267_21308[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_21217[(4)]))){
var statearr_21268_21309 = state_21217;
(statearr_21268_21309[(1)] = cljs.core.first.call(null,(state_21217[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21310 = state_21217;
state_21217 = G__21310;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto__ = function(state_21217){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto____1.call(this,state_21217);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21269 = f__2902__auto__.call(null);
(statearr_21269[(6)] = c__2901__auto___21270);

return statearr_21269;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k21312,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__21316 = k21312;
var G__21316__$1 = (((G__21316 instanceof cljs.core.Keyword))?G__21316.fqn:null);
switch (G__21316__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k21312,else__4383__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.call(null,(function (ret__4402__auto__,p__21317){
var vec__21318 = p__21317;
var k__4403__auto__ = cljs.core.nth.call(null,vec__21318,(0),null);
var v__4404__auto__ = cljs.core.nth.call(null,vec__21318,(1),null);
return f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__);
}),init__4401__auto__,this__4399__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer.call(null,writer__4395__auto__,pr_pair__4397__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4396__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"config","config",994861415),self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"network","network",2050004697),self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"id","id",-1388402092),self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"first","first",-644103046),self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"size","size",1098693007),self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"block","block",664686210),self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"t","t",-1397832519),self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__21311){
var self__ = this;
var G__21311__$1 = this;
return (new cljs.core.RecordIter((0),G__21311__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"empty","empty",767870958),self__.id)){
var pc = cljs.core.async.promise_chan.call(null);
cljs.core.async.put_BANG_.call(null,pc,fluree.db.index.data_node.call(null,(0),(0),fluree.db.flake.sorted_set_by.call(null,new cljs.core.Keyword(null,"comparator","comparator",2144896662).cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),(function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf.call(null,self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
} else {
return fluree.db.storage.core.reify_branch.call(null,self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
return object_cache.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null),null);
}));
}
}));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = new cljs.core.Keyword(null,"object-cache","object-cache",-2130324287).cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return object_cache.call(null,history_id,null);
});
return object_cache.call(null,history_id,(function (___$2){
return fluree.db.storage.core.reify_history.call(null,self__.conn,history_id,error_fn);
}));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t.call(null,this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range.call(null,node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (14 + cljs.core.count.call(null,self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll.call(null,coll__4377__auto__));
}).call(null,this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this21313,other21314){
var self__ = this;
var this21313__$1 = this;
return (((!((other21314 == null)))) && ((this21313__$1.constructor === other21314.constructor)) && (cljs.core._EQ_.call(null,this21313__$1.conn,other21314.conn)) && (cljs.core._EQ_.call(null,this21313__$1.config,other21314.config)) && (cljs.core._EQ_.call(null,this21313__$1.network,other21314.network)) && (cljs.core._EQ_.call(null,this21313__$1.dbid,other21314.dbid)) && (cljs.core._EQ_.call(null,this21313__$1.id,other21314.id)) && (cljs.core._EQ_.call(null,this21313__$1.leaf,other21314.leaf)) && (cljs.core._EQ_.call(null,this21313__$1.first,other21314.first)) && (cljs.core._EQ_.call(null,this21313__$1.rhs,other21314.rhs)) && (cljs.core._EQ_.call(null,this21313__$1.size,other21314.size)) && (cljs.core._EQ_.call(null,this21313__$1.block,other21314.block)) && (cljs.core._EQ_.call(null,this21313__$1.t,other21314.t)) && (cljs.core._EQ_.call(null,this21313__$1.tt_id,other21314.tt_id)) && (cljs.core._EQ_.call(null,this21313__$1.leftmost_QMARK_,other21314.leftmost_QMARK_)) && (cljs.core._EQ_.call(null,this21313__$1.tempid,other21314.tempid)) && (cljs.core._EQ_.call(null,this21313__$1.__extmap,other21314.__extmap)));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [new cljs.core.Keyword(null,"block","block",664686210),null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),null,new cljs.core.Keyword(null,"config","config",994861415),null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),null,new cljs.core.Keyword(null,"size","size",1098693007),null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),null,new cljs.core.Keyword(null,"t","t",-1397832519),null,new cljs.core.Keyword(null,"network","network",2050004697),null,new cljs.core.Keyword(null,"first","first",-644103046),null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),null,new cljs.core.Keyword(null,"conn","conn",278309663),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.call(null,cljs.core._with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__4390__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__21311){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__21321 = cljs.core.keyword_identical_QMARK_;
var expr__21322 = k__4388__auto__;
if(cljs.core.truth_(pred__21321.call(null,new cljs.core.Keyword(null,"conn","conn",278309663),expr__21322))){
return (new fluree.db.storage.core.UnresolvedNode(G__21311,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21321.call(null,new cljs.core.Keyword(null,"config","config",994861415),expr__21322))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__21311,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21321.call(null,new cljs.core.Keyword(null,"network","network",2050004697),expr__21322))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__21311,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21321.call(null,new cljs.core.Keyword(null,"dbid","dbid",-196647356),expr__21322))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__21311,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21321.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),expr__21322))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__21311,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21321.call(null,new cljs.core.Keyword(null,"leaf","leaf",1306118732),expr__21322))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__21311,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21321.call(null,new cljs.core.Keyword(null,"first","first",-644103046),expr__21322))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__21311,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21321.call(null,new cljs.core.Keyword(null,"rhs","rhs",-229356739),expr__21322))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__21311,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21321.call(null,new cljs.core.Keyword(null,"size","size",1098693007),expr__21322))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__21311,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21321.call(null,new cljs.core.Keyword(null,"block","block",664686210),expr__21322))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__21311,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21321.call(null,new cljs.core.Keyword(null,"t","t",-1397832519),expr__21322))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__21311,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21321.call(null,new cljs.core.Keyword(null,"tt-id","tt-id",725587484),expr__21322))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__21311,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21321.call(null,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),expr__21322))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__21311,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__21321.call(null,new cljs.core.Keyword(null,"tempid","tempid",1427663222),expr__21322))){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__21311,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__4388__auto__,G__21311),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"conn","conn",278309663),self__.conn,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"config","config",994861415),self__.config,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"network","network",2050004697),self__.network,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"dbid","dbid",-196647356),self__.dbid,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"id","id",-1388402092),self__.id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leaf","leaf",1306118732),self__.leaf,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"first","first",-644103046),self__.first,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"rhs","rhs",-229356739),self__.rhs,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"size","size",1098693007),self__.size,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"block","block",664686210),self__.block,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"t","t",-1397832519),self__.t,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tt-id","tt-id",725587484),self__.tt_id,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"tempid","tempid",1427663222),self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__21311){
var self__ = this;
var this__4379__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__21311,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__4386__auto__,(0)),cljs.core._nth.call(null,entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"conn","conn",1918841190,null),new cljs.core.Symbol(null,"config","config",-1659574354,null),new cljs.core.Symbol(null,"network","network",-604431072,null),new cljs.core.Symbol(null,"dbid","dbid",1443884171,null),new cljs.core.Symbol(null,"id","id",252129435,null),new cljs.core.Symbol(null,"leaf","leaf",-1348317037,null),new cljs.core.Symbol(null,"first","first",996428481,null),new cljs.core.Symbol(null,"rhs","rhs",1411174788,null),new cljs.core.Symbol(null,"size","size",-1555742762,null),new cljs.core.Symbol(null,"block","block",-1989749559,null),new cljs.core.Symbol(null,"t","t",242699008,null),new cljs.core.Symbol(null,"tt-id","tt-id",-1928848285,null),new cljs.core.Symbol(null,"leftmost?","leftmost?",-31657032,null),new cljs.core.Symbol(null,"tempid","tempid",-1226772547,null)], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write.call(null,writer__4424__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__21315){
var extmap__4419__auto__ = (function (){var G__21324 = cljs.core.dissoc.call(null,G__21315,new cljs.core.Keyword(null,"conn","conn",278309663),new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"network","network",2050004697),new cljs.core.Keyword(null,"dbid","dbid",-196647356),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"leaf","leaf",1306118732),new cljs.core.Keyword(null,"first","first",-644103046),new cljs.core.Keyword(null,"rhs","rhs",-229356739),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"tt-id","tt-id",725587484),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),new cljs.core.Keyword(null,"tempid","tempid",1427663222));
if(cljs.core.record_QMARK_.call(null,G__21315)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,G__21324);
} else {
return G__21324;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(G__21315),new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(G__21315),new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(G__21315),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(G__21315),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(G__21315),new cljs.core.Keyword(null,"leaf","leaf",1306118732).cljs$core$IFn$_invoke$arity$1(G__21315),new cljs.core.Keyword(null,"first","first",-644103046).cljs$core$IFn$_invoke$arity$1(G__21315),new cljs.core.Keyword(null,"rhs","rhs",-229356739).cljs$core$IFn$_invoke$arity$1(G__21315),new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(G__21315),new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(G__21315),new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(G__21315),new cljs.core.Keyword(null,"tt-id","tt-id",725587484).cljs$core$IFn$_invoke$arity$1(G__21315),new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559).cljs$core$IFn$_invoke$arity$1(G__21315),new cljs.core.Keyword(null,"tempid","tempid",1427663222).cljs$core$IFn$_invoke$arity$1(G__21315),null,cljs.core.not_empty.call(null,extmap__4419__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4126__auto__ = cljs.core.get.call(null,index_configs,index);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
throw cljs.core.ex_info.call(null,["Internal error reifying db root index: ",cljs.core.pr_str.call(null,index)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(500),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","unexpected-error","db/unexpected-error",1973857597)], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode.call(null,cljs.core.assoc.call(null,index_data,new cljs.core.Keyword(null,"conn","conn",278309663),conn,new cljs.core.Keyword(null,"config","config",994861415),cfg,new cljs.core.Keyword(null,"network","network",2050004697),network,new cljs.core.Keyword(null,"dbid","dbid",-196647356),dbid,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"leftmost?","leftmost?",-1672188559),true));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__21326 = blank_db;
var map__21326__$1 = (((((!((map__21326 == null))))?(((((map__21326.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21326.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21326):map__21326);
var network = cljs.core.get.call(null,map__21326__$1,new cljs.core.Keyword(null,"network","network",2050004697));
var dbid = cljs.core.get.call(null,map__21326__$1,new cljs.core.Keyword(null,"dbid","dbid",-196647356));
var index_configs = cljs.core.get.call(null,map__21326__$1,new cljs.core.Keyword(null,"index-configs","index-configs",1053959280));
var map__21327 = root_data;
var map__21327__$1 = (((((!((map__21327 == null))))?(((((map__21327.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21327.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21327):map__21327);
var block = cljs.core.get.call(null,map__21327__$1,new cljs.core.Keyword(null,"block","block",664686210));
var t = cljs.core.get.call(null,map__21327__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var ecount = cljs.core.get.call(null,map__21327__$1,new cljs.core.Keyword(null,"ecount","ecount",-879380887));
var stats = cljs.core.get.call(null,map__21327__$1,new cljs.core.Keyword(null,"stats","stats",-85643011));
var db_STAR_ = cljs.core.assoc.call(null,blank_db,new cljs.core.Keyword(null,"block","block",664686210),block,new cljs.core.Keyword(null,"t","t",-1397832519),t,new cljs.core.Keyword(null,"ecount","ecount",-879380887),ecount,new cljs.core.Keyword(null,"stats","stats",-85643011),cljs.core.assoc.call(null,stats,new cljs.core.Keyword(null,"indexed","indexed",390758624),block));
return cljs.core.reduce.call(null,(function (db,idx){
return cljs.core.assoc.call(null,db,idx,fluree.db.storage.core.reify_index_root.call(null,conn,index_configs,network,dbid,idx,cljs.core.get.call(null,root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"spot","spot",-1706962147),new cljs.core.Keyword(null,"psot","psot",2111653059),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"opst","opst",1213963058)], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_21351){
var state_val_21352 = (state_21351[(1)]);
if((state_val_21352 === (7))){
var state_21351__$1 = state_21351;
var statearr_21353_21373 = state_21351__$1;
(statearr_21353_21373[(2)] = null);

(statearr_21353_21373[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21352 === (1))){
var state_21351__$1 = state_21351;
var statearr_21354_21374 = state_21351__$1;
(statearr_21354_21374[(2)] = null);

(statearr_21354_21374[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21352 === (4))){
var inst_21330 = (state_21351[(2)]);
var state_21351__$1 = state_21351;
var statearr_21355_21375 = state_21351__$1;
(statearr_21355_21375[(2)] = inst_21330);

(statearr_21355_21375[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21352 === (6))){
var inst_21337 = (state_21351[(7)]);
var inst_21339 = fluree.db.storage.core.serde.call(null,conn);
var state_21351__$1 = (function (){var statearr_21356 = state_21351;
(statearr_21356[(8)] = inst_21339);

return statearr_21356;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21351__$1,(9),inst_21337);
} else {
if((state_val_21352 === (3))){
var inst_21349 = (state_21351[(2)]);
var state_21351__$1 = state_21351;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21351__$1,inst_21349);
} else {
if((state_val_21352 === (2))){
var inst_21337 = (state_21351[(7)]);
var _ = (function (){var statearr_21358 = state_21351;
(statearr_21358[(4)] = cljs.core.cons.call(null,(5),(state_21351[(4)])));

return statearr_21358;
})();
var inst_21336 = fluree.db.storage.core.ledger_garbage_key.call(null,network,dbid,block);
var inst_21337__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_21336);
var state_21351__$1 = (function (){var statearr_21359 = state_21351;
(statearr_21359[(7)] = inst_21337__$1);

return statearr_21359;
})();
if(cljs.core.truth_(inst_21337__$1)){
var statearr_21360_21376 = state_21351__$1;
(statearr_21360_21376[(1)] = (6));

} else {
var statearr_21361_21377 = state_21351__$1;
(statearr_21361_21377[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21352 === (9))){
var inst_21339 = (state_21351[(8)]);
var inst_21341 = (state_21351[(2)]);
var inst_21342 = fluree.db.util.async.throw_err.call(null,inst_21341);
var inst_21343 = fluree.db.serde.protocol._deserialize_garbage.call(null,inst_21339,inst_21342);
var state_21351__$1 = state_21351;
var statearr_21362_21378 = state_21351__$1;
(statearr_21362_21378[(2)] = inst_21343);

(statearr_21362_21378[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21352 === (5))){
var _ = (function (){var statearr_21363 = state_21351;
(statearr_21363[(4)] = cljs.core.rest.call(null,(state_21351[(4)])));

return statearr_21363;
})();
var state_21351__$1 = state_21351;
var ex21357 = (state_21351__$1[(2)]);
var statearr_21364_21379 = state_21351__$1;
(statearr_21364_21379[(5)] = ex21357);


if((ex21357 instanceof Error)){
var statearr_21365_21380 = state_21351__$1;
(statearr_21365_21380[(1)] = (4));

(statearr_21365_21380[(5)] = null);

} else {
throw ex21357;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21352 === (8))){
var inst_21346 = (state_21351[(2)]);
var _ = (function (){var statearr_21366 = state_21351;
(statearr_21366[(4)] = cljs.core.rest.call(null,(state_21351[(4)])));

return statearr_21366;
})();
var state_21351__$1 = state_21351;
var statearr_21367_21381 = state_21351__$1;
(statearr_21367_21381[(2)] = inst_21346);

(statearr_21367_21381[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__2879__auto____0 = (function (){
var statearr_21368 = [null,null,null,null,null,null,null,null,null];
(statearr_21368[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__2879__auto__);

(statearr_21368[(1)] = (1));

return statearr_21368;
});
var fluree$db$storage$core$read_garbage_$_state_machine__2879__auto____1 = (function (state_21351){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_21351);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21369){var ex__2882__auto__ = e21369;
var statearr_21370_21382 = state_21351;
(statearr_21370_21382[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_21351[(4)]))){
var statearr_21371_21383 = state_21351;
(statearr_21371_21383[(1)] = cljs.core.first.call(null,(state_21351[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21384 = state_21351;
state_21351 = G__21384;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__2879__auto__ = function(state_21351){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__2879__auto____1.call(this,state_21351);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__2879__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__2879__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21372 = f__2902__auto__.call(null);
(statearr_21372[(6)] = c__2901__auto__);

return statearr_21372;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_21406){
var state_val_21407 = (state_21406[(1)]);
if((state_val_21407 === (7))){
var state_21406__$1 = state_21406;
var statearr_21408_21428 = state_21406__$1;
(statearr_21408_21428[(2)] = null);

(statearr_21408_21428[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (1))){
var state_21406__$1 = state_21406;
var statearr_21409_21429 = state_21406__$1;
(statearr_21409_21429[(2)] = null);

(statearr_21409_21429[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (4))){
var inst_21385 = (state_21406[(2)]);
var state_21406__$1 = state_21406;
var statearr_21410_21430 = state_21406__$1;
(statearr_21410_21430[(2)] = inst_21385);

(statearr_21410_21430[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (6))){
var inst_21392 = (state_21406[(7)]);
var inst_21394 = fluree.db.storage.core.serde.call(null,conn);
var state_21406__$1 = (function (){var statearr_21411 = state_21406;
(statearr_21411[(8)] = inst_21394);

return statearr_21411;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21406__$1,(9),inst_21392);
} else {
if((state_val_21407 === (3))){
var inst_21404 = (state_21406[(2)]);
var state_21406__$1 = state_21406;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21406__$1,inst_21404);
} else {
if((state_val_21407 === (2))){
var inst_21392 = (state_21406[(7)]);
var _ = (function (){var statearr_21413 = state_21406;
(statearr_21413[(4)] = cljs.core.cons.call(null,(5),(state_21406[(4)])));

return statearr_21413;
})();
var inst_21391 = fluree.db.storage.core.ledger_root_key.call(null,network,dbid,block);
var inst_21392__$1 = fluree.db.storage.core.storage_read.call(null,conn,inst_21391);
var state_21406__$1 = (function (){var statearr_21414 = state_21406;
(statearr_21414[(7)] = inst_21392__$1);

return statearr_21414;
})();
if(cljs.core.truth_(inst_21392__$1)){
var statearr_21415_21431 = state_21406__$1;
(statearr_21415_21431[(1)] = (6));

} else {
var statearr_21416_21432 = state_21406__$1;
(statearr_21416_21432[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (9))){
var inst_21394 = (state_21406[(8)]);
var inst_21396 = (state_21406[(2)]);
var inst_21397 = fluree.db.util.async.throw_err.call(null,inst_21396);
var inst_21398 = fluree.db.serde.protocol._deserialize_db_root.call(null,inst_21394,inst_21397);
var state_21406__$1 = state_21406;
var statearr_21417_21433 = state_21406__$1;
(statearr_21417_21433[(2)] = inst_21398);

(statearr_21417_21433[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (5))){
var _ = (function (){var statearr_21418 = state_21406;
(statearr_21418[(4)] = cljs.core.rest.call(null,(state_21406[(4)])));

return statearr_21418;
})();
var state_21406__$1 = state_21406;
var ex21412 = (state_21406__$1[(2)]);
var statearr_21419_21434 = state_21406__$1;
(statearr_21419_21434[(5)] = ex21412);


if((ex21412 instanceof Error)){
var statearr_21420_21435 = state_21406__$1;
(statearr_21420_21435[(1)] = (4));

(statearr_21420_21435[(5)] = null);

} else {
throw ex21412;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21407 === (8))){
var inst_21401 = (state_21406[(2)]);
var _ = (function (){var statearr_21421 = state_21406;
(statearr_21421[(4)] = cljs.core.rest.call(null,(state_21406[(4)])));

return statearr_21421;
})();
var state_21406__$1 = state_21406;
var statearr_21422_21436 = state_21406__$1;
(statearr_21422_21436[(2)] = inst_21401);

(statearr_21422_21436[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__2879__auto____0 = (function (){
var statearr_21423 = [null,null,null,null,null,null,null,null,null];
(statearr_21423[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__2879__auto__);

(statearr_21423[(1)] = (1));

return statearr_21423;
});
var fluree$db$storage$core$read_db_root_$_state_machine__2879__auto____1 = (function (state_21406){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_21406);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21424){var ex__2882__auto__ = e21424;
var statearr_21425_21437 = state_21406;
(statearr_21425_21437[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_21406[(4)]))){
var statearr_21426_21438 = state_21406;
(statearr_21426_21438[(1)] = cljs.core.first.call(null,(state_21406[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21439 = state_21406;
state_21406 = G__21439;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__2879__auto__ = function(state_21406){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__2879__auto____1.call(this,state_21406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__2879__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__2879__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21427 = f__2902__auto__.call(null);
(statearr_21427[(6)] = c__2901__auto__);

return statearr_21427;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_21475){
var state_val_21476 = (state_21475[(1)]);
if((state_val_21476 === (7))){
var inst_21449 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_21450 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_21451 = [(400),new cljs.core.Keyword("db","unavailable","db/unavailable",1529908237)];
var inst_21452 = cljs.core.PersistentHashMap.fromArrays(inst_21450,inst_21451);
var inst_21453 = cljs.core.ex_info.call(null,inst_21449,inst_21452);
var inst_21454 = (function(){throw inst_21453})();
var state_21475__$1 = state_21475;
var statearr_21477_21499 = state_21475__$1;
(statearr_21477_21499[(2)] = inst_21454);

(statearr_21477_21499[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21476 === (1))){
var state_21475__$1 = state_21475;
var statearr_21478_21500 = state_21475__$1;
(statearr_21478_21500[(2)] = null);

(statearr_21478_21500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21476 === (4))){
var inst_21440 = (state_21475[(2)]);
var state_21475__$1 = state_21475;
var statearr_21479_21501 = state_21475__$1;
(statearr_21479_21501[(2)] = inst_21440);

(statearr_21479_21501[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21476 === (6))){
var state_21475__$1 = state_21475;
var statearr_21480_21502 = state_21475__$1;
(statearr_21480_21502[(2)] = null);

(statearr_21480_21502[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21476 === (3))){
var inst_21473 = (state_21475[(2)]);
var state_21475__$1 = state_21475;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21475__$1,inst_21473);
} else {
if((state_val_21476 === (2))){
var inst_21446 = (state_21475[(7)]);
var _ = (function (){var statearr_21481 = state_21475;
(statearr_21481[(4)] = cljs.core.cons.call(null,(5),(state_21475[(4)])));

return statearr_21481;
})();
var inst_21446__$1 = fluree.db.storage.core.read_db_root.call(null,conn,network,dbid,index);
var state_21475__$1 = (function (){var statearr_21482 = state_21475;
(statearr_21482[(7)] = inst_21446__$1);

return statearr_21482;
})();
if(cljs.core.truth_(inst_21446__$1)){
var statearr_21483_21503 = state_21475__$1;
(statearr_21483_21503[(1)] = (6));

} else {
var statearr_21484_21504 = state_21475__$1;
(statearr_21484_21504[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21476 === (11))){
var inst_21465 = (state_21475[(8)]);
var inst_21468 = (state_21475[(2)]);
var inst_21469 = fluree.db.util.async.throw_err.call(null,inst_21468);
var inst_21470 = cljs.core.assoc.call(null,inst_21465,new cljs.core.Keyword(null,"settings","settings",1556144875),inst_21469);
var _ = (function (){var statearr_21486 = state_21475;
(statearr_21486[(4)] = cljs.core.rest.call(null,(state_21475[(4)])));

return statearr_21486;
})();
var state_21475__$1 = state_21475;
var statearr_21487_21505 = state_21475__$1;
(statearr_21487_21505[(2)] = inst_21470);

(statearr_21487_21505[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21476 === (9))){
var inst_21460 = (state_21475[(9)]);
var inst_21458 = (state_21475[(2)]);
var inst_21459 = fluree.db.util.async.throw_err.call(null,inst_21458);
var inst_21460__$1 = fluree.db.storage.core.reify_db_root.call(null,conn,blank_db,inst_21459);
var inst_21461 = fluree.db.query.schema.schema_map.call(null,inst_21460__$1);
var state_21475__$1 = (function (){var statearr_21488 = state_21475;
(statearr_21488[(9)] = inst_21460__$1);

return statearr_21488;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21475__$1,(10),inst_21461);
} else {
if((state_val_21476 === (5))){
var _ = (function (){var statearr_21489 = state_21475;
(statearr_21489[(4)] = cljs.core.rest.call(null,(state_21475[(4)])));

return statearr_21489;
})();
var state_21475__$1 = state_21475;
var ex21485 = (state_21475__$1[(2)]);
var statearr_21490_21506 = state_21475__$1;
(statearr_21490_21506[(5)] = ex21485);


if((ex21485 instanceof Error)){
var statearr_21491_21507 = state_21475__$1;
(statearr_21491_21507[(1)] = (4));

(statearr_21491_21507[(5)] = null);

} else {
throw ex21485;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21476 === (10))){
var inst_21465 = (state_21475[(8)]);
var inst_21460 = (state_21475[(9)]);
var inst_21463 = (state_21475[(2)]);
var inst_21464 = fluree.db.util.async.throw_err.call(null,inst_21463);
var inst_21465__$1 = cljs.core.assoc.call(null,inst_21460,new cljs.core.Keyword(null,"schema","schema",-1582001791),inst_21464);
var inst_21466 = fluree.db.query.schema.setting_map.call(null,inst_21465__$1);
var state_21475__$1 = (function (){var statearr_21492 = state_21475;
(statearr_21492[(8)] = inst_21465__$1);

return statearr_21492;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21475__$1,(11),inst_21466);
} else {
if((state_val_21476 === (8))){
var inst_21446 = (state_21475[(7)]);
var inst_21456 = (state_21475[(2)]);
var state_21475__$1 = (function (){var statearr_21493 = state_21475;
(statearr_21493[(10)] = inst_21456);

return statearr_21493;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21475__$1,(9),inst_21446);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__2879__auto____0 = (function (){
var statearr_21494 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_21494[(0)] = fluree$db$storage$core$reify_db_$_state_machine__2879__auto__);

(statearr_21494[(1)] = (1));

return statearr_21494;
});
var fluree$db$storage$core$reify_db_$_state_machine__2879__auto____1 = (function (state_21475){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_21475);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21495){var ex__2882__auto__ = e21495;
var statearr_21496_21508 = state_21475;
(statearr_21496_21508[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_21475[(4)]))){
var statearr_21497_21509 = state_21475;
(statearr_21497_21509[(1)] = cljs.core.first.call(null,(state_21475[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21510 = state_21475;
state_21475 = G__21510;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__2879__auto__ = function(state_21475){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__2879__auto____1.call(this,state_21475);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__2879__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__2879__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21498 = f__2902__auto__.call(null);
(statearr_21498[(6)] = c__2901__auto__);

return statearr_21498;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__21512 = arguments.length;
switch (G__21512) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.call(null,conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.call(null,"Block-range request: ",network,dbid,start,end);

var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_21562){
var state_val_21563 = (state_21562[(1)]);
if((state_val_21563 === (7))){
var inst_21522 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_21523 = (new Error(inst_21522));
var inst_21524 = (function(){throw inst_21523})();
var state_21562__$1 = state_21562;
var statearr_21564_21600 = state_21562__$1;
(statearr_21564_21600[(2)] = inst_21524);

(statearr_21564_21600[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21563 === (20))){
var inst_21551 = (state_21562[(2)]);
var state_21562__$1 = state_21562;
var statearr_21565_21601 = state_21562__$1;
(statearr_21565_21601[(2)] = inst_21551);

(statearr_21565_21601[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21563 === (1))){
var state_21562__$1 = state_21562;
var statearr_21566_21602 = state_21562__$1;
(statearr_21566_21602[(2)] = null);

(statearr_21566_21602[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21563 === (4))){
var inst_21513 = (state_21562[(2)]);
var state_21562__$1 = state_21562;
var statearr_21567_21603 = state_21562__$1;
(statearr_21567_21603[(2)] = inst_21513);

(statearr_21567_21603[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21563 === (15))){
var inst_21531 = (state_21562[(7)]);
var inst_21535 = (state_21562[(8)]);
var inst_21543 = cljs.core.conj.call(null,inst_21531,inst_21535);
var state_21562__$1 = state_21562;
var statearr_21568_21604 = state_21562__$1;
(statearr_21568_21604[(2)] = inst_21543);

(statearr_21568_21604[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21563 === (13))){
var inst_21530 = (state_21562[(9)]);
var inst_21541 = cljs.core._EQ_.call(null,inst_21530,end);
var state_21562__$1 = state_21562;
if(inst_21541){
var statearr_21569_21605 = state_21562__$1;
(statearr_21569_21605[(1)] = (15));

} else {
var statearr_21570_21606 = state_21562__$1;
(statearr_21570_21606[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21563 === (6))){
var state_21562__$1 = state_21562;
var statearr_21571_21607 = state_21562__$1;
(statearr_21571_21607[(2)] = null);

(statearr_21571_21607[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21563 === (17))){
var inst_21553 = (state_21562[(2)]);
var state_21562__$1 = state_21562;
var statearr_21572_21608 = state_21562__$1;
(statearr_21572_21608[(2)] = inst_21553);

(statearr_21572_21608[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21563 === (3))){
var inst_21560 = (state_21562[(2)]);
var state_21562__$1 = state_21562;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21562__$1,inst_21560);
} else {
if((state_val_21563 === (12))){
var inst_21531 = (state_21562[(7)]);
var state_21562__$1 = state_21562;
var statearr_21573_21609 = state_21562__$1;
(statearr_21573_21609[(2)] = inst_21531);

(statearr_21573_21609[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21563 === (2))){
var _ = (function (){var statearr_21574 = state_21562;
(statearr_21574[(4)] = cljs.core.cons.call(null,(5),(state_21562[(4)])));

return statearr_21574;
})();
var inst_21519 = (end >= start);
var state_21562__$1 = state_21562;
if(cljs.core.truth_(inst_21519)){
var statearr_21575_21610 = state_21562__$1;
(statearr_21575_21610[(1)] = (6));

} else {
var statearr_21576_21611 = state_21562__$1;
(statearr_21576_21611[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21563 === (19))){
var state_21562__$1 = state_21562;
var statearr_21577_21612 = state_21562__$1;
(statearr_21577_21612[(2)] = null);

(statearr_21577_21612[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21563 === (11))){
var inst_21535 = (state_21562[(8)]);
var inst_21535__$1 = (state_21562[(2)]);
var inst_21536 = (inst_21535__$1 == null);
var inst_21537 = (inst_21535__$1 instanceof Error);
var inst_21538 = ((inst_21536) || (inst_21537));
var state_21562__$1 = (function (){var statearr_21579 = state_21562;
(statearr_21579[(8)] = inst_21535__$1);

return statearr_21579;
})();
if(cljs.core.truth_(inst_21538)){
var statearr_21580_21613 = state_21562__$1;
(statearr_21580_21613[(1)] = (12));

} else {
var statearr_21581_21614 = state_21562__$1;
(statearr_21581_21614[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21563 === (9))){
var inst_21530 = (state_21562[(9)]);
var inst_21533 = fluree.db.storage.core.read_block.call(null,conn,network,dbid,inst_21530);
var state_21562__$1 = state_21562;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21562__$1,(11),inst_21533);
} else {
if((state_val_21563 === (5))){
var _ = (function (){var statearr_21582 = state_21562;
(statearr_21582[(4)] = cljs.core.rest.call(null,(state_21562[(4)])));

return statearr_21582;
})();
var state_21562__$1 = state_21562;
var ex21578 = (state_21562__$1[(2)]);
var statearr_21583_21615 = state_21562__$1;
(statearr_21583_21615[(5)] = ex21578);


if((ex21578 instanceof Error)){
var statearr_21584_21616 = state_21562__$1;
(statearr_21584_21616[(1)] = (4));

(statearr_21584_21616[(5)] = null);

} else {
throw ex21578;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21563 === (14))){
var inst_21555 = (state_21562[(2)]);
var state_21562__$1 = state_21562;
var statearr_21585_21617 = state_21562__$1;
(statearr_21585_21617[(2)] = inst_21555);

(statearr_21585_21617[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21563 === (16))){
var state_21562__$1 = state_21562;
var statearr_21586_21618 = state_21562__$1;
(statearr_21586_21618[(1)] = (18));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21563 === (10))){
var inst_21557 = (state_21562[(2)]);
var _ = (function (){var statearr_21588 = state_21562;
(statearr_21588[(4)] = cljs.core.rest.call(null,(state_21562[(4)])));

return statearr_21588;
})();
var state_21562__$1 = state_21562;
var statearr_21589_21619 = state_21562__$1;
(statearr_21589_21619[(2)] = inst_21557);

(statearr_21589_21619[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21563 === (18))){
var inst_21531 = (state_21562[(7)]);
var inst_21530 = (state_21562[(9)]);
var inst_21535 = (state_21562[(8)]);
var inst_21546 = (inst_21530 + (1));
var inst_21547 = cljs.core.conj.call(null,inst_21531,inst_21535);
var inst_21530__$1 = inst_21546;
var inst_21531__$1 = inst_21547;
var state_21562__$1 = (function (){var statearr_21590 = state_21562;
(statearr_21590[(7)] = inst_21531__$1);

(statearr_21590[(9)] = inst_21530__$1);

return statearr_21590;
})();
var statearr_21591_21620 = state_21562__$1;
(statearr_21591_21620[(2)] = null);

(statearr_21591_21620[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21563 === (8))){
var inst_21526 = (state_21562[(2)]);
var inst_21527 = new cljs.core.Keyword(null,"parallelism","parallelism",-930922333).cljs$core$IFn$_invoke$arity$1(conn);
var inst_21528 = start;
var inst_21529 = cljs.core.PersistentVector.EMPTY;
var inst_21530 = inst_21528;
var inst_21531 = inst_21529;
var state_21562__$1 = (function (){var statearr_21592 = state_21562;
(statearr_21592[(7)] = inst_21531);

(statearr_21592[(10)] = inst_21527);

(statearr_21592[(9)] = inst_21530);

(statearr_21592[(11)] = inst_21526);

return statearr_21592;
})();
var statearr_21593_21621 = state_21562__$1;
(statearr_21593_21621[(2)] = null);

(statearr_21593_21621[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__2879__auto__ = null;
var fluree$db$storage$core$state_machine__2879__auto____0 = (function (){
var statearr_21594 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_21594[(0)] = fluree$db$storage$core$state_machine__2879__auto__);

(statearr_21594[(1)] = (1));

return statearr_21594;
});
var fluree$db$storage$core$state_machine__2879__auto____1 = (function (state_21562){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_21562);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21595){var ex__2882__auto__ = e21595;
var statearr_21596_21622 = state_21562;
(statearr_21596_21622[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_21562[(4)]))){
var statearr_21597_21623 = state_21562;
(statearr_21597_21623[(1)] = cljs.core.first.call(null,(state_21562[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21624 = state_21562;
state_21562 = G__21624;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__2879__auto__ = function(state_21562){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__2879__auto____1.call(this,state_21562);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__2879__auto____0;
fluree$db$storage$core$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__2879__auto____1;
return fluree$db$storage$core$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21598 = f__2902__auto__.call(null);
(statearr_21598[(6)] = c__2901__auto__);

return statearr_21598;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_21640){
var state_val_21641 = (state_21640[(1)]);
if((state_val_21641 === (1))){
var state_21640__$1 = state_21640;
var statearr_21642_21656 = state_21640__$1;
(statearr_21642_21656[(2)] = null);

(statearr_21642_21656[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21641 === (2))){
var _ = (function (){var statearr_21643 = state_21640;
(statearr_21643[(4)] = cljs.core.cons.call(null,(5),(state_21640[(4)])));

return statearr_21643;
})();
var inst_21631 = fluree.db.storage.core.block_range.call(null,conn,network,dbid,block,block);
var state_21640__$1 = state_21640;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_21640__$1,(6),inst_21631);
} else {
if((state_val_21641 === (3))){
var inst_21638 = (state_21640[(2)]);
var state_21640__$1 = state_21640;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_21640__$1,inst_21638);
} else {
if((state_val_21641 === (4))){
var inst_21625 = (state_21640[(2)]);
var state_21640__$1 = state_21640;
var statearr_21645_21657 = state_21640__$1;
(statearr_21645_21657[(2)] = inst_21625);

(statearr_21645_21657[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21641 === (5))){
var _ = (function (){var statearr_21646 = state_21640;
(statearr_21646[(4)] = cljs.core.rest.call(null,(state_21640[(4)])));

return statearr_21646;
})();
var state_21640__$1 = state_21640;
var ex21644 = (state_21640__$1[(2)]);
var statearr_21647_21658 = state_21640__$1;
(statearr_21647_21658[(5)] = ex21644);


if((ex21644 instanceof Error)){
var statearr_21648_21659 = state_21640__$1;
(statearr_21648_21659[(1)] = (4));

(statearr_21648_21659[(5)] = null);

} else {
throw ex21644;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_21641 === (6))){
var inst_21633 = (state_21640[(2)]);
var inst_21634 = fluree.db.util.async.throw_err.call(null,inst_21633);
var inst_21635 = cljs.core.first.call(null,inst_21634);
var _ = (function (){var statearr_21649 = state_21640;
(statearr_21649[(4)] = cljs.core.rest.call(null,(state_21640[(4)])));

return statearr_21649;
})();
var state_21640__$1 = state_21640;
var statearr_21650_21660 = state_21640__$1;
(statearr_21650_21660[(2)] = inst_21635);

(statearr_21650_21660[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__2879__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__2879__auto____0 = (function (){
var statearr_21651 = [null,null,null,null,null,null,null];
(statearr_21651[(0)] = fluree$db$storage$core$block_$_state_machine__2879__auto__);

(statearr_21651[(1)] = (1));

return statearr_21651;
});
var fluree$db$storage$core$block_$_state_machine__2879__auto____1 = (function (state_21640){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_21640);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e21652){var ex__2882__auto__ = e21652;
var statearr_21653_21661 = state_21640;
(statearr_21653_21661[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_21640[(4)]))){
var statearr_21654_21662 = state_21640;
(statearr_21654_21662[(1)] = cljs.core.first.call(null,(state_21640[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__21663 = state_21640;
state_21640 = G__21663;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__2879__auto__ = function(state_21640){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__2879__auto____1.call(this,state_21640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__2879__auto____0;
fluree$db$storage$core$block_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__2879__auto____1;
return fluree$db$storage$core$block_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_21655 = f__2902__auto__.call(null);
(statearr_21655[(6)] = c__2901__auto__);

return statearr_21655;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
