// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4126__auto__ = cljs.core.ex_data.call(null,x);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_11626){
var state_val_11627 = (state_11626[(1)]);
if((state_val_11627 === (7))){
var inst_11621 = (state_11626[(2)]);
var _ = (function (){var statearr_11628 = state_11626;
(statearr_11628[(4)] = cljs.core.rest.call(null,(state_11626[(4)])));

return statearr_11628;
})();
var state_11626__$1 = state_11626;
var statearr_11629_11651 = state_11626__$1;
(statearr_11629_11651[(2)] = inst_11621);

(statearr_11629_11651[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11627 === (1))){
var state_11626__$1 = state_11626;
var statearr_11630_11652 = state_11626__$1;
(statearr_11630_11652[(2)] = null);

(statearr_11630_11652[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11627 === (4))){
var inst_11583 = (state_11626[(2)]);
var state_11626__$1 = state_11626;
var statearr_11631_11653 = state_11626__$1;
(statearr_11631_11653[(2)] = inst_11583);

(statearr_11631_11653[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11627 === (6))){
var inst_11601 = (state_11626[(7)]);
var inst_11608 = (state_11626[(8)]);
var inst_11607 = cljs.core.seq.call(null,inst_11601);
var inst_11608__$1 = cljs.core.first.call(null,inst_11607);
var inst_11609 = cljs.core.next.call(null,inst_11607);
var inst_11610 = cljs.core.not.call(null,inst_11608__$1);
var state_11626__$1 = (function (){var statearr_11632 = state_11626;
(statearr_11632[(9)] = inst_11609);

(statearr_11632[(8)] = inst_11608__$1);

return statearr_11632;
})();
if(inst_11610){
var statearr_11633_11654 = state_11626__$1;
(statearr_11633_11654[(1)] = (8));

} else {
var statearr_11634_11655 = state_11626__$1;
(statearr_11634_11655[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11627 === (3))){
var inst_11624 = (state_11626[(2)]);
var state_11626__$1 = state_11626;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11626__$1,inst_11624);
} else {
if((state_val_11627 === (2))){
var _ = (function (){var statearr_11635 = state_11626;
(statearr_11635[(4)] = cljs.core.cons.call(null,(5),(state_11626[(4)])));

return statearr_11635;
})();
var inst_11596 = chs;
var inst_11597 = cljs.core.seq.call(null,inst_11596);
var inst_11598 = cljs.core.first.call(null,inst_11597);
var inst_11599 = cljs.core.next.call(null,inst_11597);
var inst_11600 = coll;
var inst_11601 = inst_11596;
var inst_11602 = inst_11600;
var state_11626__$1 = (function (){var statearr_11636 = state_11626;
(statearr_11636[(7)] = inst_11601);

(statearr_11636[(10)] = inst_11602);

(statearr_11636[(11)] = inst_11598);

(statearr_11636[(12)] = inst_11599);

return statearr_11636;
})();
var statearr_11637_11656 = state_11626__$1;
(statearr_11637_11656[(2)] = null);

(statearr_11637_11656[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11627 === (11))){
var inst_11609 = (state_11626[(9)]);
var inst_11602 = (state_11626[(10)]);
var inst_11614 = (state_11626[(2)]);
var inst_11615 = fluree.db.util.async.throw_err.call(null,inst_11614);
var inst_11616 = cljs.core.conj.call(null,inst_11602,inst_11615);
var inst_11601 = inst_11609;
var inst_11602__$1 = inst_11616;
var state_11626__$1 = (function (){var statearr_11639 = state_11626;
(statearr_11639[(7)] = inst_11601);

(statearr_11639[(10)] = inst_11602__$1);

return statearr_11639;
})();
var statearr_11640_11657 = state_11626__$1;
(statearr_11640_11657[(2)] = null);

(statearr_11640_11657[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11627 === (9))){
var inst_11608 = (state_11626[(8)]);
var state_11626__$1 = state_11626;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11626__$1,(11),inst_11608);
} else {
if((state_val_11627 === (5))){
var _ = (function (){var statearr_11641 = state_11626;
(statearr_11641[(4)] = cljs.core.rest.call(null,(state_11626[(4)])));

return statearr_11641;
})();
var state_11626__$1 = state_11626;
var ex11638 = (state_11626__$1[(2)]);
var statearr_11642_11658 = state_11626__$1;
(statearr_11642_11658[(5)] = ex11638);


var statearr_11643_11659 = state_11626__$1;
(statearr_11643_11659[(1)] = (4));

(statearr_11643_11659[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11627 === (10))){
var inst_11619 = (state_11626[(2)]);
var state_11626__$1 = state_11626;
var statearr_11644_11660 = state_11626__$1;
(statearr_11644_11660[(2)] = inst_11619);

(statearr_11644_11660[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11627 === (8))){
var inst_11602 = (state_11626[(10)]);
var state_11626__$1 = state_11626;
var statearr_11645_11661 = state_11626__$1;
(statearr_11645_11661[(2)] = inst_11602);

(statearr_11645_11661[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2879__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2879__auto____0 = (function (){
var statearr_11646 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_11646[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__2879__auto__);

(statearr_11646[(1)] = (1));

return statearr_11646;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__2879__auto____1 = (function (state_11626){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_11626);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e11647){var ex__2882__auto__ = e11647;
var statearr_11648_11662 = state_11626;
(statearr_11648_11662[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_11626[(4)]))){
var statearr_11649_11663 = state_11626;
(statearr_11649_11663[(1)] = cljs.core.first.call(null,(state_11626[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11664 = state_11626;
state_11626 = G__11664;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__2879__auto__ = function(state_11626){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2879__auto____1.call(this,state_11626);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2879__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__2879__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_11650 = f__2902__auto__.call(null);
(statearr_11650[(6)] = c__2901__auto__);

return statearr_11650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel insted of results if thee is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__2901__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,(function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_11690){
var state_val_11691 = (state_11690[(1)]);
if((state_val_11691 === (7))){
var inst_11685 = (state_11690[(2)]);
var _ = (function (){var statearr_11692 = state_11690;
(statearr_11692[(4)] = cljs.core.rest.call(null,(state_11690[(4)])));

return statearr_11692;
})();
var state_11690__$1 = state_11690;
var statearr_11693_11715 = state_11690__$1;
(statearr_11693_11715[(2)] = inst_11685);

(statearr_11693_11715[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11691 === (1))){
var state_11690__$1 = state_11690;
var statearr_11694_11716 = state_11690__$1;
(statearr_11694_11716[(2)] = null);

(statearr_11694_11716[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11691 === (4))){
var inst_11665 = (state_11690[(2)]);
var state_11690__$1 = state_11690;
var statearr_11695_11717 = state_11690__$1;
(statearr_11695_11717[(2)] = inst_11665);

(statearr_11695_11717[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11691 === (6))){
var state_11690__$1 = state_11690;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11690__$1,(8),chan);
} else {
if((state_val_11691 === (3))){
var inst_11688 = (state_11690[(2)]);
var state_11690__$1 = state_11690;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11690__$1,inst_11688);
} else {
if((state_val_11691 === (2))){
var _ = (function (){var statearr_11696 = state_11690;
(statearr_11696[(4)] = cljs.core.cons.call(null,(5),(state_11690[(4)])));

return statearr_11696;
})();
var inst_11671 = coll;
var inst_11672 = inst_11671;
var state_11690__$1 = (function (){var statearr_11697 = state_11690;
(statearr_11697[(7)] = inst_11672);

return statearr_11697;
})();
var statearr_11698_11718 = state_11690__$1;
(statearr_11698_11718[(2)] = null);

(statearr_11698_11718[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11691 === (11))){
var inst_11683 = (state_11690[(2)]);
var state_11690__$1 = state_11690;
var statearr_11700_11719 = state_11690__$1;
(statearr_11700_11719[(2)] = inst_11683);

(statearr_11700_11719[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11691 === (9))){
var inst_11672 = (state_11690[(7)]);
var state_11690__$1 = state_11690;
var statearr_11701_11720 = state_11690__$1;
(statearr_11701_11720[(2)] = inst_11672);

(statearr_11701_11720[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11691 === (5))){
var _ = (function (){var statearr_11702 = state_11690;
(statearr_11702[(4)] = cljs.core.rest.call(null,(state_11690[(4)])));

return statearr_11702;
})();
var state_11690__$1 = state_11690;
var ex11699 = (state_11690__$1[(2)]);
var statearr_11703_11721 = state_11690__$1;
(statearr_11703_11721[(5)] = ex11699);


var statearr_11704_11722 = state_11690__$1;
(statearr_11704_11722[(1)] = (4));

(statearr_11704_11722[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11691 === (10))){
var inst_11676 = (state_11690[(8)]);
var inst_11672 = (state_11690[(7)]);
var inst_11680 = cljs.core.conj.call(null,inst_11672,inst_11676);
var inst_11672__$1 = inst_11680;
var state_11690__$1 = (function (){var statearr_11705 = state_11690;
(statearr_11705[(7)] = inst_11672__$1);

return statearr_11705;
})();
var statearr_11706_11723 = state_11690__$1;
(statearr_11706_11723[(2)] = null);

(statearr_11706_11723[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11691 === (8))){
var inst_11676 = (state_11690[(8)]);
var inst_11675 = (state_11690[(2)]);
var inst_11676__$1 = fluree.db.util.async.throw_err.call(null,inst_11675);
var inst_11677 = (inst_11676__$1 == null);
var state_11690__$1 = (function (){var statearr_11707 = state_11690;
(statearr_11707[(8)] = inst_11676__$1);

return statearr_11707;
})();
if(cljs.core.truth_(inst_11677)){
var statearr_11708_11724 = state_11690__$1;
(statearr_11708_11724[(1)] = (9));

} else {
var statearr_11709_11725 = state_11690__$1;
(statearr_11709_11725[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__2879__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__2879__auto____0 = (function (){
var statearr_11710 = [null,null,null,null,null,null,null,null,null];
(statearr_11710[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__2879__auto__);

(statearr_11710[(1)] = (1));

return statearr_11710;
});
var fluree$db$util$async$into_QMARK__$_state_machine__2879__auto____1 = (function (state_11690){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__.call(null,state_11690);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e11711){var ex__2882__auto__ = e11711;
var statearr_11712_11726 = state_11690;
(statearr_11712_11726[(2)] = ex__2882__auto__);


if(cljs.core.seq.call(null,(state_11690[(4)]))){
var statearr_11713_11727 = state_11690;
(statearr_11713_11727[(1)] = cljs.core.first.call(null,(state_11690[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__11728 = state_11690;
state_11690 = G__11728;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__2879__auto__ = function(state_11690){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__2879__auto____1.call(this,state_11690);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__2879__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__2879__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_11714 = f__2902__auto__.call(null);
(statearr_11714[(6)] = c__2901__auto__);

return statearr_11714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.Channel,x);
}
});
