// Compiled by ClojureScript 1.10.773 {:target :nodejs}
goog.provide('fluree.db.util.json');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('fluree.db.util.bytes');
goog.require('fluree.db.util.core');
fluree.db.util.json.clj__GT_js_SINGLEQUOTE_ = (function fluree$db$util$json$clj__GT_js_SINGLEQUOTE_(var_args){
var G__13477 = arguments.length;
switch (G__13477) {
case 1:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.call(null,x,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keyword-fn","keyword-fn",-64566675),fluree.db.util.core.keyword__GT_str], null));
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function (x,options){
var map__13478 = options;
var map__13478__$1 = (((((!((map__13478 == null))))?(((((map__13478.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13478.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13478):map__13478);
var keyword_fn = cljs.core.get.call(null,map__13478__$1,new cljs.core.Keyword(null,"keyword-fn","keyword-fn",-64566675));
var keyfn = (function fluree$db$util$json$keyfn(k){
return cljs.core.key__GT_js.call(null,k,thisfn);
});
var thisfn = (function fluree$db$util$json$thisfn(x__$1){
if((x__$1 == null)){
return null;
} else {
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeJS$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IEncodeJS,x__$1):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IEncodeJS,x__$1))){
return cljs.core._clj__GT_js.call(null,x__$1);
} else {
if((x__$1 instanceof cljs.core.Keyword)){
return keyword_fn.call(null,x__$1);
} else {
if((x__$1 instanceof cljs.core.Symbol)){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x__$1);
} else {
if(cljs.core.map_QMARK_.call(null,x__$1)){
var m = ({});
var seq__13506_13527 = cljs.core.seq.call(null,x__$1);
var chunk__13507_13528 = null;
var count__13508_13529 = (0);
var i__13509_13530 = (0);
while(true){
if((i__13509_13530 < count__13508_13529)){
var vec__13516_13531 = cljs.core._nth.call(null,chunk__13507_13528,i__13509_13530);
var k_13532 = cljs.core.nth.call(null,vec__13516_13531,(0),null);
var v_13533 = cljs.core.nth.call(null,vec__13516_13531,(1),null);
goog.object.set(m,keyfn.call(null,k_13532),fluree$db$util$json$thisfn.call(null,v_13533));


var G__13534 = seq__13506_13527;
var G__13535 = chunk__13507_13528;
var G__13536 = count__13508_13529;
var G__13537 = (i__13509_13530 + (1));
seq__13506_13527 = G__13534;
chunk__13507_13528 = G__13535;
count__13508_13529 = G__13536;
i__13509_13530 = G__13537;
continue;
} else {
var temp__5735__auto___13538 = cljs.core.seq.call(null,seq__13506_13527);
if(temp__5735__auto___13538){
var seq__13506_13539__$1 = temp__5735__auto___13538;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__13506_13539__$1)){
var c__4556__auto___13540 = cljs.core.chunk_first.call(null,seq__13506_13539__$1);
var G__13541 = cljs.core.chunk_rest.call(null,seq__13506_13539__$1);
var G__13542 = c__4556__auto___13540;
var G__13543 = cljs.core.count.call(null,c__4556__auto___13540);
var G__13544 = (0);
seq__13506_13527 = G__13541;
chunk__13507_13528 = G__13542;
count__13508_13529 = G__13543;
i__13509_13530 = G__13544;
continue;
} else {
var vec__13519_13545 = cljs.core.first.call(null,seq__13506_13539__$1);
var k_13546 = cljs.core.nth.call(null,vec__13519_13545,(0),null);
var v_13547 = cljs.core.nth.call(null,vec__13519_13545,(1),null);
goog.object.set(m,keyfn.call(null,k_13546),fluree$db$util$json$thisfn.call(null,v_13547));


var G__13548 = cljs.core.next.call(null,seq__13506_13539__$1);
var G__13549 = null;
var G__13550 = (0);
var G__13551 = (0);
seq__13506_13527 = G__13548;
chunk__13507_13528 = G__13549;
count__13508_13529 = G__13550;
i__13509_13530 = G__13551;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_.call(null,x__$1)){
var arr = [];
var seq__13522_13552 = cljs.core.seq.call(null,cljs.core.map.call(null,fluree$db$util$json$thisfn,x__$1));
var chunk__13523_13553 = null;
var count__13524_13554 = (0);
var i__13525_13555 = (0);
while(true){
if((i__13525_13555 < count__13524_13554)){
var x_13556__$2 = cljs.core._nth.call(null,chunk__13523_13553,i__13525_13555);
arr.push(x_13556__$2);


var G__13557 = seq__13522_13552;
var G__13558 = chunk__13523_13553;
var G__13559 = count__13524_13554;
var G__13560 = (i__13525_13555 + (1));
seq__13522_13552 = G__13557;
chunk__13523_13553 = G__13558;
count__13524_13554 = G__13559;
i__13525_13555 = G__13560;
continue;
} else {
var temp__5735__auto___13561 = cljs.core.seq.call(null,seq__13522_13552);
if(temp__5735__auto___13561){
var seq__13522_13562__$1 = temp__5735__auto___13561;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__13522_13562__$1)){
var c__4556__auto___13563 = cljs.core.chunk_first.call(null,seq__13522_13562__$1);
var G__13564 = cljs.core.chunk_rest.call(null,seq__13522_13562__$1);
var G__13565 = c__4556__auto___13563;
var G__13566 = cljs.core.count.call(null,c__4556__auto___13563);
var G__13567 = (0);
seq__13522_13552 = G__13564;
chunk__13523_13553 = G__13565;
count__13524_13554 = G__13566;
i__13525_13555 = G__13567;
continue;
} else {
var x_13568__$2 = cljs.core.first.call(null,seq__13522_13562__$1);
arr.push(x_13568__$2);


var G__13569 = cljs.core.next.call(null,seq__13522_13562__$1);
var G__13570 = null;
var G__13571 = (0);
var G__13572 = (0);
seq__13522_13552 = G__13569;
chunk__13523_13553 = G__13570;
count__13524_13554 = G__13571;
i__13525_13555 = G__13572;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x__$1;

}
}
}
}
}
}
});
return thisfn.call(null,x);
}));

(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.cljs$lang$maxFixedArity = 2);

fluree.db.util.json.parse = (function fluree$db$util$json$parse(x){
return cljs.core.js__GT_clj.call(null,JSON.parse(((typeof x === 'string')?x:fluree.db.util.bytes.UTF8__GT_string.call(null,x))),new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true);
});
fluree.db.util.json.stringify_preserve_namespace = (function fluree$db$util$json$stringify_preserve_namespace(x){
return JSON.stringify(fluree.db.util.json.clj__GT_js_SINGLEQUOTE_.call(null,x));
});
fluree.db.util.json.stringify = (function fluree$db$util$json$stringify(x){
return JSON.stringify(cljs.core.clj__GT_js.call(null,x));
});
fluree.db.util.json.stringify_UTF8 = (function fluree$db$util$json$stringify_UTF8(x){
return fluree.db.util.bytes.string__GT_UTF8.call(null,fluree.db.util.json.stringify.call(null,x));
});
/**
 * Given a sequence of coordinates, ensure that, for the given depth:
 * 1) they contain only sequences until
 * 2) they contain only numbers at depth 1
 */
fluree.db.util.json.valid_coordinates_QMARK_ = (function fluree$db$util$json$valid_coordinates_QMARK_(depth,coordinates){
if((depth > (0))){
} else {
throw (new Error("Assert failed: (pos? depth)"));
}

if(cljs.core._EQ_.call(null,(1),depth)){
return ((cljs.core.every_QMARK_.call(null,cljs.core.number_QMARK_,coordinates)) && (((2) <= cljs.core.count.call(null,coordinates))));
} else {
return (((!((coordinates == null)))) && (cljs.core.every_QMARK_.call(null,cljs.core.sequential_QMARK_,coordinates)) && (cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,(function (p1__13573_SHARP_){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(depth - (1)),p1__13573_SHARP_);
}),coordinates))));
}
});
/**
 * Checks to make sure that the given coordinates are valid linear rings, which
 * is a requirement for Polygon types.
 */
fluree.db.util.json.linear_ring_QMARK_ = (function fluree$db$util$json$linear_ring_QMARK_(coordinates){
return ((cljs.core.sequential_QMARK_.call(null,coordinates)) && (((4) <= cljs.core.count.call(null,coordinates))) && (cljs.core._EQ_.call(null,cljs.core.first.call(null,coordinates),cljs.core.last.call(null,coordinates))));
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.util !== 'undefined') && (typeof fluree.db.util.json !== 'undefined') && (typeof fluree.db.util.json.valid_geojson_QMARK_ !== 'undefined')){
} else {
fluree.db.util.json.valid_geojson_QMARK_ = (function (){var method_table__4619__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"fluree.db.util.json","valid-geojson?"),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"Feature",(function (geometry){
var and__4115__auto__ = (function (){var or__4126__auto__ = fluree.db.util.json.valid_geojson_QMARK_.call(null,new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(geometry));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (new cljs.core.Keyword(null,"geometry","geometry",-405034994).cljs$core$IFn$_invoke$arity$1(geometry) == null);
}
})();
if(cljs.core.truth_(and__4115__auto__)){
return ((cljs.core.map_QMARK_.call(null,new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(geometry))) || ((new cljs.core.Keyword(null,"properties","properties",685819552).cljs$core$IFn$_invoke$arity$1(geometry) == null)));
} else {
return and__4115__auto__;
}
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"FeatureCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_.call(null,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"features","features",-1146962336).cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"GeometryCollection",(function (geometry){
return ((cljs.core.sequential_QMARK_.call(null,new cljs.core.Keyword(null,"geometries","geometries",-1679297218).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"geometries","geometries",-1679297218).cljs$core$IFn$_invoke$arity$1(geometry)))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"Point",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(1),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"LineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(2),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"Polygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_.call(null,(3),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,fluree.db.util.json.linear_ring_QMARK_,new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"MultiPoint",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(2),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"MultiLineString",(function (geometry){
return fluree.db.util.json.valid_coordinates_QMARK_.call(null,(3),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,"MultiPolygon",(function (geometry){
return ((fluree.db.util.json.valid_coordinates_QMARK_.call(null,(4),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))) && (cljs.core.every_QMARK_.call(null,(function (p1__13574_SHARP_){
return cljs.core.every_QMARK_.call(null,fluree.db.util.json.linear_ring_QMARK_,p1__13574_SHARP_);
}),new cljs.core.Keyword(null,"coordinates","coordinates",-1225332668).cljs$core$IFn$_invoke$arity$1(geometry))));
}));
cljs.core._add_method.call(null,fluree.db.util.json.valid_geojson_QMARK_,new cljs.core.Keyword(null,"default","default",-1987822328),(function (geometry){
return false;
}));
