// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.tools.reader');
goog.require('cljs.env');
goog.require('cljs.analyzer');
goog.require('cljs.source_map');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ecmascript5","ecmascript5",342717552),new cljs.core.Keyword(null,"ecmascript5-strict","ecmascript5-strict",888234811),new cljs.core.Keyword(null,"ecmascript6","ecmascript6",723864898),new cljs.core.Keyword(null,"ecmascript6-strict","ecmascript6-strict",-786049555),new cljs.core.Keyword(null,"ecmascript-2015","ecmascript-2015",-902254444),new cljs.core.Keyword(null,"ecmascript6-typed","ecmascript6-typed",-1978203054),new cljs.core.Keyword(null,"ecmascript-2016","ecmascript-2016",471574729),new cljs.core.Keyword(null,"ecmascript-2017","ecmascript-2017",620145058),new cljs.core.Keyword(null,"ecmascript-next","ecmascript-next",-1935155962)], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__3776 = s;
var map__3776__$1 = (((((!((map__3776 == null))))?(((((map__3776.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3776.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3776):map__3776);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3776__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3776__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var d = (0);
var G__3779 = info;
var map__3780 = G__3779;
var map__3780__$1 = (((((!((map__3780 == null))))?(((((map__3780.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3780.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3780):map__3780);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3780__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
var d__$1 = d;
var G__3779__$1 = G__3779;
while(true){
var d__$2 = d__$1;
var map__3784 = G__3779__$1;
var map__3784__$1 = (((((!((map__3784 == null))))?(((((map__3784.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3784.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3784):map__3784);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3784__$1,new cljs.core.Keyword(null,"shadow","shadow",873231803));
if(cljs.core.truth_(shadow__$1)){
var G__3786 = (d__$2 + (1));
var G__3787 = shadow__$1;
d__$1 = G__3786;
G__3779__$1 = G__3787;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__3788){
var map__3789 = p__3788;
var map__3789__$1 = (((((!((map__3789 == null))))?(((((map__3789.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3789.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3789):map__3789);
var name_var = map__3789__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3789__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3789__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__3791 = info;
var map__3791__$1 = (((((!((map__3791 == null))))?(((((map__3791.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3791.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3791):map__3791);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3791__$1,new cljs.core.Keyword(null,"ns","ns",441598760));
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3791__$1,new cljs.core.Keyword(null,"fn-scope","fn-scope",-865664859));
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,new cljs.core.Keyword(null,"name","name",1843675177)),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__3793 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__3793) : cljs.compiler.munge.call(null,G__3793));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__3795 = arguments.length;
switch (G__3795) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.cljs_map_QMARK_(s)){
var name_var = s;
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(name_var);
var field = new cljs.core.Keyword(null,"field","field",-1302436500).cljs$core$IFn$_invoke$arity$1(name_var);
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(name_var);
if((!((new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531).cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__3796 = new cljs.core.Var(function(){return cljs.core.munge_str;},new cljs.core.Symbol("cljs.core","munge-str","cljs.core/munge-str",-301346665,null),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"private","private",-558947994),new cljs.core.Keyword(null,"ns","ns",441598760),new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"end-column","end-column",1425389514),new cljs.core.Keyword(null,"column","column",2078222095),new cljs.core.Keyword(null,"line","line",212345235),new cljs.core.Keyword(null,"end-line","end-line",1837326455),new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Keyword(null,"arglists","arglists",1661989754),new cljs.core.Keyword(null,"doc","doc",1913296891),new cljs.core.Keyword(null,"test","test",577538877)],[true,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null),new cljs.core.Symbol(null,"munge-str","munge-str",-2042069652,null),"cljs/core.cljs",(25),(1),(11501),(11501),new cljs.core.Symbol(null,"string","string",-349010059,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"name","name",-810760592,null)], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__3796.cljs$core$IFn$_invoke$arity$1 ? fexpr__3796.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__3796.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__3798 = cp;
switch (G__3798) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__3800_3804 = cljs.core.seq(s);
var chunk__3801_3805 = null;
var count__3802_3806 = (0);
var i__3803_3807 = (0);
while(true){
if((i__3803_3807 < count__3802_3806)){
var c_3808 = chunk__3801_3805.cljs$core$IIndexed$_nth$arity$2(null,i__3803_3807);
sb.append(cljs.compiler.escape_char(c_3808));


var G__3809 = seq__3800_3804;
var G__3810 = chunk__3801_3805;
var G__3811 = count__3802_3806;
var G__3812 = (i__3803_3807 + (1));
seq__3800_3804 = G__3809;
chunk__3801_3805 = G__3810;
count__3802_3806 = G__3811;
i__3803_3807 = G__3812;
continue;
} else {
var temp__5735__auto___3813 = cljs.core.seq(seq__3800_3804);
if(temp__5735__auto___3813){
var seq__3800_3814__$1 = temp__5735__auto___3813;
if(cljs.core.chunked_seq_QMARK_(seq__3800_3814__$1)){
var c__4556__auto___3815 = cljs.core.chunk_first(seq__3800_3814__$1);
var G__3816 = cljs.core.chunk_rest(seq__3800_3814__$1);
var G__3817 = c__4556__auto___3815;
var G__3818 = cljs.core.count(c__4556__auto___3815);
var G__3819 = (0);
seq__3800_3804 = G__3816;
chunk__3801_3805 = G__3817;
count__3802_3806 = G__3818;
i__3803_3807 = G__3819;
continue;
} else {
var c_3820 = cljs.core.first(seq__3800_3814__$1);
sb.append(cljs.compiler.escape_char(c_3820));


var G__3821 = cljs.core.next(seq__3800_3814__$1);
var G__3822 = null;
var G__3823 = (0);
var G__3824 = (0);
seq__3800_3804 = G__3821;
chunk__3801_3805 = G__3822;
count__3802_3806 = G__3823;
i__3803_3807 = G__3824;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4619__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__3825 = cljs.core.get_global_hierarchy;
return (fexpr__3825.cljs$core$IFn$_invoke$arity$0 ? fexpr__3825.cljs$core$IFn$_invoke$arity$0() : fexpr__3825.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__3826_3833 = ast;
var map__3826_3834__$1 = (((((!((map__3826_3833 == null))))?(((((map__3826_3833.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3826_3833.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3826_3833):map__3826_3833);
var env_3835 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3826_3834__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core.truth_(new cljs.core.Keyword(null,"line","line",212345235).cljs$core$IFn$_invoke$arity$1(env_3835))){
var map__3828_3836 = env_3835;
var map__3828_3837__$1 = (((((!((map__3828_3836 == null))))?(((((map__3828_3836.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3828_3836.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3828_3836):map__3828_3836);
var line_3838 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3828_3837__$1,new cljs.core.Keyword(null,"line","line",212345235));
var column_3839 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3828_3837__$1,new cljs.core.Keyword(null,"column","column",2078222095));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__3830 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"gcol","gcol",309250807),new cljs.core.Keyword(null,"gen-col","gen-col",1901918303).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"gline","gline",-1086242431),new cljs.core.Keyword(null,"gen-line","gen-line",589592125).cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__3832 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__3831 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"binding","binding",539932593),null,new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__3831.cljs$core$IFn$_invoke$arity$1 ? fexpr__3831.cljs$core$IFn$_invoke$arity$1(G__3832) : fexpr__3831.call(null,G__3832));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__3830,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__3830;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"source-map","source-map",1706252311),(line_3838 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_3839)?(column_3839 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__3848 = arguments.length;
switch (G__3848) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___3855 = arguments.length;
var i__4737__auto___3856 = (0);
while(true){
if((i__4737__auto___3856 < len__4736__auto___3855)){
args_arr__4757__auto__.push((arguments[i__4737__auto___3856]));

var G__3857 = (i__4737__auto___3856 + (1));
i__4737__auto___3856 = G__3857;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4758__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(goog.isFunction(a)){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_3858 = (function (){var G__3849 = a;
if((!(typeof a === 'string'))){
return G__3849.toString();
} else {
return G__3849;
}
})();
var temp__5739__auto___3859 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5739__auto___3859 == null)){
} else {
var sm_data_3860 = temp__5739__auto___3859;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_3860,cljs.core.update,new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(function (p1__3840_SHARP_){
return (p1__3840_SHARP_ + s_3858.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_3858], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__3850 = cljs.core.seq(xs);
var chunk__3851 = null;
var count__3852 = (0);
var i__3853 = (0);
while(true){
if((i__3853 < count__3852)){
var x = chunk__3851.cljs$core$IIndexed$_nth$arity$2(null,i__3853);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__3861 = seq__3850;
var G__3862 = chunk__3851;
var G__3863 = count__3852;
var G__3864 = (i__3853 + (1));
seq__3850 = G__3861;
chunk__3851 = G__3862;
count__3852 = G__3863;
i__3853 = G__3864;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__3850);
if(temp__5735__auto__){
var seq__3850__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__3850__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__3850__$1);
var G__3865 = cljs.core.chunk_rest(seq__3850__$1);
var G__3866 = c__4556__auto__;
var G__3867 = cljs.core.count(c__4556__auto__);
var G__3868 = (0);
seq__3850 = G__3865;
chunk__3851 = G__3866;
count__3852 = G__3867;
i__3853 = G__3868;
continue;
} else {
var x = cljs.core.first(seq__3850__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__3869 = cljs.core.next(seq__3850__$1);
var G__3870 = null;
var G__3871 = (0);
var G__3872 = (0);
seq__3850 = G__3869;
chunk__3851 = G__3870;
count__3852 = G__3871;
i__3853 = G__3872;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq3842){
var G__3843 = cljs.core.first(seq3842);
var seq3842__$1 = cljs.core.next(seq3842);
var G__3844 = cljs.core.first(seq3842__$1);
var seq3842__$2 = cljs.core.next(seq3842__$1);
var G__3845 = cljs.core.first(seq3842__$2);
var seq3842__$3 = cljs.core.next(seq3842__$2);
var G__3846 = cljs.core.first(seq3842__$3);
var seq3842__$4 = cljs.core.next(seq3842__$3);
var G__3847 = cljs.core.first(seq3842__$4);
var seq3842__$5 = cljs.core.next(seq3842__$4);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3843,G__3844,G__3845,G__3846,G__3847,seq3842__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__3873){
var map__3874 = p__3873;
var map__3874__$1 = (((((!((map__3874 == null))))?(((((map__3874.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3874.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3874):map__3874);
var m = map__3874__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3874__$1,new cljs.core.Keyword(null,"gen-line","gen-line",589592125));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,new cljs.core.Keyword(null,"gen-line","gen-line",589592125),(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"gen-col","gen-col",1901918303),(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__3883 = arguments.length;
switch (G__3883) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4757__auto__ = [];
var len__4736__auto___3889 = arguments.length;
var i__4737__auto___3890 = (0);
while(true){
if((i__4737__auto___3890 < len__4736__auto___3889)){
args_arr__4757__auto__.push((arguments[i__4737__auto___3890]));

var G__3891 = (i__4737__auto___3890 + (1));
i__4737__auto___3890 = G__3891;
continue;
} else {
}
break;
}

var argseq__4758__auto__ = (new cljs.core.IndexedSeq(args_arr__4757__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4758__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__3884_3892 = cljs.core.seq(xs);
var chunk__3885_3893 = null;
var count__3886_3894 = (0);
var i__3887_3895 = (0);
while(true){
if((i__3887_3895 < count__3886_3894)){
var x_3896 = chunk__3885_3893.cljs$core$IIndexed$_nth$arity$2(null,i__3887_3895);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_3896);


var G__3897 = seq__3884_3892;
var G__3898 = chunk__3885_3893;
var G__3899 = count__3886_3894;
var G__3900 = (i__3887_3895 + (1));
seq__3884_3892 = G__3897;
chunk__3885_3893 = G__3898;
count__3886_3894 = G__3899;
i__3887_3895 = G__3900;
continue;
} else {
var temp__5735__auto___3901 = cljs.core.seq(seq__3884_3892);
if(temp__5735__auto___3901){
var seq__3884_3902__$1 = temp__5735__auto___3901;
if(cljs.core.chunked_seq_QMARK_(seq__3884_3902__$1)){
var c__4556__auto___3903 = cljs.core.chunk_first(seq__3884_3902__$1);
var G__3904 = cljs.core.chunk_rest(seq__3884_3902__$1);
var G__3905 = c__4556__auto___3903;
var G__3906 = cljs.core.count(c__4556__auto___3903);
var G__3907 = (0);
seq__3884_3892 = G__3904;
chunk__3885_3893 = G__3905;
count__3886_3894 = G__3906;
i__3887_3895 = G__3907;
continue;
} else {
var x_3908 = cljs.core.first(seq__3884_3902__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_3908);


var G__3909 = cljs.core.next(seq__3884_3902__$1);
var G__3910 = null;
var G__3911 = (0);
var G__3912 = (0);
seq__3884_3892 = G__3909;
chunk__3885_3893 = G__3910;
count__3886_3894 = G__3911;
i__3887_3895 = G__3912;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq3877){
var G__3878 = cljs.core.first(seq3877);
var seq3877__$1 = cljs.core.next(seq3877);
var G__3879 = cljs.core.first(seq3877__$1);
var seq3877__$2 = cljs.core.next(seq3877__$1);
var G__3880 = cljs.core.first(seq3877__$2);
var seq3877__$3 = cljs.core.next(seq3877__$2);
var G__3881 = cljs.core.first(seq3877__$3);
var seq3877__$4 = cljs.core.next(seq3877__$3);
var G__3882 = cljs.core.first(seq3877__$4);
var seq3877__$5 = cljs.core.next(seq3877__$4);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3878,G__3879,G__3880,G__3881,G__3882,seq3877__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4667__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__3913_3917 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__3914_3918 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__3915_3919 = true;
var _STAR_print_fn_STAR__temp_val__3916_3920 = (function (x__4668__auto__){
return sb__4667__auto__.append(x__4668__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__3915_3919);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__3916_3920);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__3914_3918);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__3913_3917);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4667__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4619__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4620__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4621__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4622__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4623__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),(function (){var fexpr__3921 = cljs.core.get_global_hierarchy;
return (fexpr__3921.cljs$core$IFn$_invoke$arity$0 ? fexpr__3921.cljs$core$IFn$_invoke$arity$0() : fexpr__3921.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__4623__auto__,method_table__4619__auto__,prefer_table__4620__auto__,method_cache__4621__auto__,cached_hierarchy__4622__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__3922 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3922,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3922,(1),null);
var G__3925 = ns;
var G__3926 = name;
var G__3927 = (function (){
var G__3928 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__3928) : cljs.compiler.emit_constant.call(null,G__3928));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__3925,G__3926,G__3927) : cljs.compiler.emit_record_value.call(null,G__3925,G__3926,G__3927));
} else {
if(cljs.analyzer.cljs_map_QMARK_(x)){
var G__3929 = cljs.core.keys(x);
var G__3930 = cljs.core.vals(x);
var G__3931 = cljs.compiler.emit_constants_comma_sep;
var G__3932 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__3929,G__3930,G__3931,G__3932) : cljs.compiler.emit_map.call(null,G__3929,G__3930,G__3931,G__3932));
} else {
if(cljs.analyzer.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__3933 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__3934 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__3933,G__3934) : cljs.compiler.emit_with_meta.call(null,G__3933,G__3934));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"constant","constant",-379609303),x,new cljs.core.Keyword(null,"type","type",1174270348),cljs.core.type(x),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__3935 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3935,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3935,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3935,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5733__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4115__auto__)){
var G__3938 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__3938) : x.call(null,G__3938));
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5733__auto__ = (function (){var and__4115__auto__ = new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4115__auto__)){
var G__3939 = new cljs.core.Keyword("cljs.analyzer","constant-table","cljs.analyzer/constant-table",-114131889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__3939) : x.call(null,G__3939));
} else {
return and__4115__auto__;
}
})();
if(cljs.core.truth_(temp__5733__auto__)){
var value = temp__5733__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",date.getTime(),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__3941 = items;
var G__3942 = (function (p1__3940_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__3940_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__3941,G__3942) : cljs.compiler.emit_js_object.call(null,G__3941,G__3942));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"no-op","no-op",-93046065),(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__3944){
var map__3945 = p__3944;
var map__3945__$1 = (((((!((map__3945 == null))))?(((((map__3945.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3945.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3945):map__3945);
var ast = map__3945__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3945__$1,new cljs.core.Keyword(null,"info","info",-317069002));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3945__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3945__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var temp__5733__auto__ = new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292).cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5733__auto__)){
var const_expr = temp__5733__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,new cljs.core.Keyword(null,"env","env",-1815813235),env));
} else {
var map__3947 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__3947__$1 = (((((!((map__3947 == null))))?(((((map__3947.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3947.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3947):map__3947);
var cenv = map__3947__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3947__$1,new cljs.core.Keyword(null,"options","options",99638489));
var var_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-module-index","js-module-index",2072061931),cljs.core.name(var_name),new cljs.core.Keyword(null,"name","name",1843675177)], null));
var or__4126__auto__ = js_module_name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(new cljs.core.Keyword(null,"binding-form?","binding-form?",1728940169).cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__3949 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4115__auto__ = (function (){var G__3952 = new cljs.core.Keyword(null,"language-out","language-out",334619882).cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__3952) : cljs.compiler.es5_GT__EQ_.call(null,G__3952));
})();
if(cljs.core.truth_(and__4115__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4115__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__3949,cljs.analyzer.es5_allowed);
} else {
return G__3949;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"js-namespaces","js-namespaces",-471353612),(function (){var or__4126__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__3953 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,new cljs.core.Symbol("js","-Infinity","js/-Infinity",958706333,null))){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__3953,reserved);
} else {
return G__3953;
}
})();
var env__3768__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__3954_3955 = new cljs.core.Keyword(null,"module-type","module-type",1392760304).cljs$core$IFn$_invoke$arity$1(js_module);
var G__3954_3956__$1 = (((G__3954_3955 instanceof cljs.core.Keyword))?G__3954_3955.fqn:null);
switch (G__3954_3956__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4115__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"var","var",-769682797),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"binding","binding",539932593),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"local","local",-1497766724),(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"the-var","the-var",1428415613),(function (p__3958){
var map__3959 = p__3958;
var map__3959__$1 = (((((!((map__3959 == null))))?(((((map__3959.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3959.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3959):map__3959);
var arg = map__3959__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3959__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3959__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3959__$1,new cljs.core.Keyword(null,"sym","sym",-1444860305));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3959__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__3961 = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(var$);
var map__3961__$1 = (((((!((map__3961 == null))))?(((((map__3961.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3961.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3961):map__3961);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3961__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env__3768__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"with-meta","with-meta",-1566856820),(function (p__3963){
var map__3964 = p__3963;
var map__3964__$1 = (((((!((map__3964 == null))))?(((((map__3964.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3964.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3964):map__3964);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3964__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3964__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3964__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__3768__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__3966_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__3966_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__3967 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__3967) : comma_sep.call(null,G__3967));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__3968 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__3968) : comma_sep.call(null,G__3968));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"map","map",1371690461),(function (p__3969){
var map__3970 = p__3969;
var map__3970__$1 = (((((!((map__3970 == null))))?(((((map__3970.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3970.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3970):map__3970);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3970__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3970__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3970__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env__3768__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"vector","vector",1902966158),(function (p__3972){
var map__3973 = p__3972;
var map__3973__$1 = (((((!((map__3973 == null))))?(((((map__3973.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3973.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3973):map__3973);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3973__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3973__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__3768__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__3975_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__3975_SHARP_),new cljs.core.Keyword(null,"const","const",1709929842));
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__3976 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__3976) : comma_sep.call(null,G__3976));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set","set",304602554),(function (p__3977){
var map__3978 = p__3977;
var map__3978__$1 = (((((!((map__3978 == null))))?(((((map__3978.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3978.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__3978):map__3978);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3978__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__3978__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__3768__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5735__auto___4002 = cljs.core.seq(items);
if(temp__5735__auto___4002){
var items_4003__$1 = temp__5735__auto___4002;
var vec__3980_4004 = items_4003__$1;
var seq__3981_4005 = cljs.core.seq(vec__3980_4004);
var first__3982_4006 = cljs.core.first(seq__3981_4005);
var seq__3981_4007__$1 = cljs.core.next(seq__3981_4005);
var vec__3983_4008 = first__3982_4006;
var k_4009 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3983_4008,(0),null);
var v_4010 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3983_4008,(1),null);
var r_4011 = seq__3981_4007__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_4009),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_4010) : emit_js_object_val.call(null,v_4010)));

var seq__3986_4012 = cljs.core.seq(r_4011);
var chunk__3987_4013 = null;
var count__3988_4014 = (0);
var i__3989_4015 = (0);
while(true){
if((i__3989_4015 < count__3988_4014)){
var vec__3996_4016 = chunk__3987_4013.cljs$core$IIndexed$_nth$arity$2(null,i__3989_4015);
var k_4017__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3996_4016,(0),null);
var v_4018__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3996_4016,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_4017__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_4018__$1) : emit_js_object_val.call(null,v_4018__$1)));


var G__4019 = seq__3986_4012;
var G__4020 = chunk__3987_4013;
var G__4021 = count__3988_4014;
var G__4022 = (i__3989_4015 + (1));
seq__3986_4012 = G__4019;
chunk__3987_4013 = G__4020;
count__3988_4014 = G__4021;
i__3989_4015 = G__4022;
continue;
} else {
var temp__5735__auto___4023__$1 = cljs.core.seq(seq__3986_4012);
if(temp__5735__auto___4023__$1){
var seq__3986_4024__$1 = temp__5735__auto___4023__$1;
if(cljs.core.chunked_seq_QMARK_(seq__3986_4024__$1)){
var c__4556__auto___4025 = cljs.core.chunk_first(seq__3986_4024__$1);
var G__4026 = cljs.core.chunk_rest(seq__3986_4024__$1);
var G__4027 = c__4556__auto___4025;
var G__4028 = cljs.core.count(c__4556__auto___4025);
var G__4029 = (0);
seq__3986_4012 = G__4026;
chunk__3987_4013 = G__4027;
count__3988_4014 = G__4028;
i__3989_4015 = G__4029;
continue;
} else {
var vec__3999_4030 = cljs.core.first(seq__3986_4024__$1);
var k_4031__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3999_4030,(0),null);
var v_4032__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3999_4030,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_4031__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_4032__$1) : emit_js_object_val.call(null,v_4032__$1)));


var G__4033 = cljs.core.next(seq__3986_4024__$1);
var G__4034 = null;
var G__4035 = (0);
var G__4036 = (0);
seq__3986_4012 = G__4033;
chunk__3987_4013 = G__4034;
count__3988_4014 = G__4035;
i__3989_4015 = G__4036;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-object","js-object",1830199158),(function (p__4037){
var map__4038 = p__4037;
var map__4038__$1 = (((((!((map__4038 == null))))?(((((map__4038.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4038.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4038):map__4038);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4038__$1,new cljs.core.Keyword(null,"keys","keys",1068423698));
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4038__$1,new cljs.core.Keyword(null,"vals","vals",768058733));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4038__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__3768__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js-array","js-array",-1210185421),(function (p__4040){
var map__4041 = p__4040;
var map__4041__$1 = (((((!((map__4041 == null))))?(((((map__4041.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4041.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4041):map__4041);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4041__$1,new cljs.core.Keyword(null,"items","items",1031954938));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4041__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__3768__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"quote","quote",-262615245),(function (p__4043){
var map__4044 = p__4043;
var map__4044__$1 = (((((!((map__4044 == null))))?(((((map__4044.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4044.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4044):map__4044);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4044__$1,new cljs.core.Keyword(null,"expr","expr",745722291));
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"const","const",1709929842),(function (p__4046){
var map__4047 = p__4046;
var map__4047__$1 = (((((!((map__4047 == null))))?(((((map__4047.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4047.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4047):map__4047);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4047__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4047__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__3768__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__4049 = cljs.analyzer.unwrap_quote(expr);
var map__4049__$1 = (((((!((map__4049 == null))))?(((((map__4049.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4049.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4049):map__4049);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4049__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4049__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4049__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4126__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842)))?(function (){var and__4115__auto__ = form;
if(cljs.core.truth_(and__4115__auto__)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4115__auto__;
}
})():false);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__4051 = cljs.analyzer.unwrap_quote(expr);
var map__4051__$1 = (((((!((map__4051 == null))))?(((((map__4051.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4051.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4051):map__4051);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4051__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4051__$1,new cljs.core.Keyword(null,"form","form",-1624062471));
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4051__$1,new cljs.core.Keyword(null,"const-expr","const-expr",-1379382292));
var or__4126__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,new cljs.core.Keyword(null,"const","const",1709929842))) && (((form === false) || ((form == null)))));
if(or__4126__auto__){
return or__4126__auto__;
} else {
if((!((const_expr == null)))){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return false;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4126__auto__ = (function (){var fexpr__4054 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"seq","seq",-177272256,null),null,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),null], null), null);
return (fexpr__4054.cljs$core$IFn$_invoke$arity$1 ? fexpr__4054.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__4054.call(null,tag));
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"if","if",-458814265),(function (p__4055){
var map__4056 = p__4055;
var map__4056__$1 = (((((!((map__4056 == null))))?(((((map__4056.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4056.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4056):map__4056);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4056__$1,new cljs.core.Keyword(null,"test","test",577538877));
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4056__$1,new cljs.core.Keyword(null,"then","then",460598070));
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4056__$1,new cljs.core.Keyword(null,"else","else",-1508377146));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4056__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4056__$1,new cljs.core.Keyword(null,"unchecked","unchecked",924418378));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4126__auto__ = unchecked;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"case","case",1143702196),(function (p__4058){
var map__4059 = p__4058;
var map__4059__$1 = (((((!((map__4059 == null))))?(((((map__4059.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4059.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4059):map__4059);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4059__$1,new cljs.core.Keyword(null,"test","test",577538877));
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4059__$1,new cljs.core.Keyword(null,"nodes","nodes",-2099585805));
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4059__$1,new cljs.core.Keyword(null,"default","default",-1987822328));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4059__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env),new cljs.core.Keyword(null,"expr","expr",745722291))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__4061_4097 = cljs.core.seq(nodes);
var chunk__4062_4098 = null;
var count__4063_4099 = (0);
var i__4064_4100 = (0);
while(true){
if((i__4064_4100 < count__4063_4099)){
var map__4081_4101 = chunk__4062_4098.cljs$core$IIndexed$_nth$arity$2(null,i__4064_4100);
var map__4081_4102__$1 = (((((!((map__4081_4101 == null))))?(((((map__4081_4101.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4081_4101.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4081_4101):map__4081_4101);
var ts_4103 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4081_4102__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__4082_4104 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4081_4102__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__4082_4105__$1 = (((((!((map__4082_4104 == null))))?(((((map__4082_4104.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4082_4104.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4082_4104):map__4082_4104);
var then_4106 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4082_4105__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__4085_4107 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_4103));
var chunk__4086_4108 = null;
var count__4087_4109 = (0);
var i__4088_4110 = (0);
while(true){
if((i__4088_4110 < count__4087_4109)){
var test_4111 = chunk__4086_4108.cljs$core$IIndexed$_nth$arity$2(null,i__4088_4110);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_4111,":");


var G__4112 = seq__4085_4107;
var G__4113 = chunk__4086_4108;
var G__4114 = count__4087_4109;
var G__4115 = (i__4088_4110 + (1));
seq__4085_4107 = G__4112;
chunk__4086_4108 = G__4113;
count__4087_4109 = G__4114;
i__4088_4110 = G__4115;
continue;
} else {
var temp__5735__auto___4116 = cljs.core.seq(seq__4085_4107);
if(temp__5735__auto___4116){
var seq__4085_4117__$1 = temp__5735__auto___4116;
if(cljs.core.chunked_seq_QMARK_(seq__4085_4117__$1)){
var c__4556__auto___4118 = cljs.core.chunk_first(seq__4085_4117__$1);
var G__4119 = cljs.core.chunk_rest(seq__4085_4117__$1);
var G__4120 = c__4556__auto___4118;
var G__4121 = cljs.core.count(c__4556__auto___4118);
var G__4122 = (0);
seq__4085_4107 = G__4119;
chunk__4086_4108 = G__4120;
count__4087_4109 = G__4121;
i__4088_4110 = G__4122;
continue;
} else {
var test_4123 = cljs.core.first(seq__4085_4117__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_4123,":");


var G__4124 = cljs.core.next(seq__4085_4117__$1);
var G__4125 = null;
var G__4126 = (0);
var G__4127 = (0);
seq__4085_4107 = G__4124;
chunk__4086_4108 = G__4125;
count__4087_4109 = G__4126;
i__4088_4110 = G__4127;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_4106);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_4106);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__4128 = seq__4061_4097;
var G__4129 = chunk__4062_4098;
var G__4130 = count__4063_4099;
var G__4131 = (i__4064_4100 + (1));
seq__4061_4097 = G__4128;
chunk__4062_4098 = G__4129;
count__4063_4099 = G__4130;
i__4064_4100 = G__4131;
continue;
} else {
var temp__5735__auto___4132 = cljs.core.seq(seq__4061_4097);
if(temp__5735__auto___4132){
var seq__4061_4133__$1 = temp__5735__auto___4132;
if(cljs.core.chunked_seq_QMARK_(seq__4061_4133__$1)){
var c__4556__auto___4134 = cljs.core.chunk_first(seq__4061_4133__$1);
var G__4135 = cljs.core.chunk_rest(seq__4061_4133__$1);
var G__4136 = c__4556__auto___4134;
var G__4137 = cljs.core.count(c__4556__auto___4134);
var G__4138 = (0);
seq__4061_4097 = G__4135;
chunk__4062_4098 = G__4136;
count__4063_4099 = G__4137;
i__4064_4100 = G__4138;
continue;
} else {
var map__4089_4139 = cljs.core.first(seq__4061_4133__$1);
var map__4089_4140__$1 = (((((!((map__4089_4139 == null))))?(((((map__4089_4139.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4089_4139.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4089_4139):map__4089_4139);
var ts_4141 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4089_4140__$1,new cljs.core.Keyword(null,"tests","tests",-1041085625));
var map__4090_4142 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4089_4140__$1,new cljs.core.Keyword(null,"then","then",460598070));
var map__4090_4143__$1 = (((((!((map__4090_4142 == null))))?(((((map__4090_4142.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4090_4142.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4090_4142):map__4090_4142);
var then_4144 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4090_4143__$1,new cljs.core.Keyword(null,"then","then",460598070));
var seq__4093_4145 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"test","test",577538877),ts_4141));
var chunk__4094_4146 = null;
var count__4095_4147 = (0);
var i__4096_4148 = (0);
while(true){
if((i__4096_4148 < count__4095_4147)){
var test_4149 = chunk__4094_4146.cljs$core$IIndexed$_nth$arity$2(null,i__4096_4148);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_4149,":");


var G__4150 = seq__4093_4145;
var G__4151 = chunk__4094_4146;
var G__4152 = count__4095_4147;
var G__4153 = (i__4096_4148 + (1));
seq__4093_4145 = G__4150;
chunk__4094_4146 = G__4151;
count__4095_4147 = G__4152;
i__4096_4148 = G__4153;
continue;
} else {
var temp__5735__auto___4154__$1 = cljs.core.seq(seq__4093_4145);
if(temp__5735__auto___4154__$1){
var seq__4093_4155__$1 = temp__5735__auto___4154__$1;
if(cljs.core.chunked_seq_QMARK_(seq__4093_4155__$1)){
var c__4556__auto___4156 = cljs.core.chunk_first(seq__4093_4155__$1);
var G__4157 = cljs.core.chunk_rest(seq__4093_4155__$1);
var G__4158 = c__4556__auto___4156;
var G__4159 = cljs.core.count(c__4556__auto___4156);
var G__4160 = (0);
seq__4093_4145 = G__4157;
chunk__4094_4146 = G__4158;
count__4095_4147 = G__4159;
i__4096_4148 = G__4160;
continue;
} else {
var test_4161 = cljs.core.first(seq__4093_4155__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_4161,":");


var G__4162 = cljs.core.next(seq__4093_4155__$1);
var G__4163 = null;
var G__4164 = (0);
var G__4165 = (0);
seq__4093_4145 = G__4162;
chunk__4094_4146 = G__4163;
count__4095_4147 = G__4164;
i__4096_4148 = G__4165;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_4144);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_4144);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__4166 = cljs.core.next(seq__4061_4133__$1);
var G__4167 = null;
var G__4168 = (0);
var G__4169 = (0);
seq__4061_4097 = G__4166;
chunk__4062_4098 = G__4167;
count__4063_4099 = G__4168;
i__4064_4100 = G__4169;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"throw","throw",-1044625833),(function (p__4170){
var map__4171 = p__4170;
var map__4171__$1 = (((((!((map__4171 == null))))?(((((map__4171.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4171.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4171):map__4171);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4171__$1,new cljs.core.Keyword(null,"exception","exception",-335277064));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4171__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__4176 = env;
var G__4177 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__4176,G__4177) : cljs.compiler.resolve_type.call(null,G__4176,G__4177));
})())].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__4178 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4178,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4178,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__4173_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__4173_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__4173_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__4181 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__4181,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__4181;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__4184 = env;
var G__4185 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__4184,G__4185) : cljs.compiler.resolve_type.call(null,G__4184,G__4185));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__4186_SHARP_){
return cljs.compiler.resolve_type(env,p1__4186_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__4187 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__4188 = cljs.core.seq(vec__4187);
var first__4189 = cljs.core.first(seq__4188);
var seq__4188__$1 = cljs.core.next(seq__4188);
var p = first__4189;
var first__4189__$1 = cljs.core.first(seq__4188__$1);
var seq__4188__$2 = cljs.core.next(seq__4188__$1);
var ts = first__4189__$1;
var first__4189__$2 = cljs.core.first(seq__4188__$2);
var seq__4188__$3 = cljs.core.next(seq__4188__$2);
var n = first__4189__$2;
var xs = seq__4188__$3;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p))?(function (){var and__4115__auto__ = ts;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4115__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__4190 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__4191 = cljs.core.seq(vec__4190);
var first__4192 = cljs.core.first(seq__4191);
var seq__4191__$1 = cljs.core.next(seq__4191);
var p = first__4192;
var first__4192__$1 = cljs.core.first(seq__4191__$1);
var seq__4191__$2 = cljs.core.next(seq__4191__$1);
var ts = first__4192__$1;
var xs = seq__4191__$2;
if(cljs.core.truth_(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p))?(function (){var and__4115__auto__ = ts;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(ts,"{");
} else {
return and__4115__auto__;
}
})():false))){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__4194 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"closure-warnings","closure-warnings",1362834211),new cljs.core.Keyword(null,"check-types","check-types",-833794607)], null));
var fexpr__4193 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
return (fexpr__4193.cljs$core$IFn$_invoke$arity$1 ? fexpr__4193.cljs$core$IFn$_invoke$arity$1(G__4194) : fexpr__4193.call(null,G__4194));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__4197 = arguments.length;
switch (G__4197) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__4205 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__4195_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__4195_SHARP_);
} else {
return p1__4195_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__4206 = cljs.core.seq(vec__4205);
var first__4207 = cljs.core.first(seq__4206);
var seq__4206__$1 = cljs.core.next(seq__4206);
var x = first__4207;
var ys = seq__4206__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__4208 = cljs.core.seq(ys);
var chunk__4209 = null;
var count__4210 = (0);
var i__4211 = (0);
while(true){
if((i__4211 < count__4210)){
var next_line = chunk__4209.cljs$core$IIndexed$_nth$arity$2(null,i__4211);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__4217 = seq__4208;
var G__4218 = chunk__4209;
var G__4219 = count__4210;
var G__4220 = (i__4211 + (1));
seq__4208 = G__4217;
chunk__4209 = G__4218;
count__4210 = G__4219;
i__4211 = G__4220;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__4208);
if(temp__5735__auto__){
var seq__4208__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__4208__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__4208__$1);
var G__4221 = cljs.core.chunk_rest(seq__4208__$1);
var G__4222 = c__4556__auto__;
var G__4223 = cljs.core.count(c__4556__auto__);
var G__4224 = (0);
seq__4208 = G__4221;
chunk__4209 = G__4222;
count__4210 = G__4223;
i__4211 = G__4224;
continue;
} else {
var next_line = cljs.core.first(seq__4208__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__4225 = cljs.core.next(seq__4208__$1);
var G__4226 = null;
var G__4227 = (0);
var G__4228 = (0);
seq__4208 = G__4225;
chunk__4209 = G__4226;
count__4210 = G__4227;
i__4211 = G__4228;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__4212_4229 = cljs.core.seq(docs__$2);
var chunk__4213_4230 = null;
var count__4214_4231 = (0);
var i__4215_4232 = (0);
while(true){
if((i__4215_4232 < count__4214_4231)){
var e_4233 = chunk__4213_4230.cljs$core$IIndexed$_nth$arity$2(null,i__4215_4232);
if(cljs.core.truth_(e_4233)){
print_comment_lines(e_4233);
} else {
}


var G__4234 = seq__4212_4229;
var G__4235 = chunk__4213_4230;
var G__4236 = count__4214_4231;
var G__4237 = (i__4215_4232 + (1));
seq__4212_4229 = G__4234;
chunk__4213_4230 = G__4235;
count__4214_4231 = G__4236;
i__4215_4232 = G__4237;
continue;
} else {
var temp__5735__auto___4238 = cljs.core.seq(seq__4212_4229);
if(temp__5735__auto___4238){
var seq__4212_4239__$1 = temp__5735__auto___4238;
if(cljs.core.chunked_seq_QMARK_(seq__4212_4239__$1)){
var c__4556__auto___4240 = cljs.core.chunk_first(seq__4212_4239__$1);
var G__4241 = cljs.core.chunk_rest(seq__4212_4239__$1);
var G__4242 = c__4556__auto___4240;
var G__4243 = cljs.core.count(c__4556__auto___4240);
var G__4244 = (0);
seq__4212_4229 = G__4241;
chunk__4213_4230 = G__4242;
count__4214_4231 = G__4243;
i__4215_4232 = G__4244;
continue;
} else {
var e_4245 = cljs.core.first(seq__4212_4239__$1);
if(cljs.core.truth_(e_4245)){
print_comment_lines(e_4245);
} else {
}


var G__4246 = cljs.core.next(seq__4212_4239__$1);
var G__4247 = null;
var G__4248 = (0);
var G__4249 = (0);
seq__4212_4229 = G__4246;
chunk__4213_4230 = G__4247;
count__4214_4231 = G__4248;
i__4215_4232 = G__4249;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (x === true) || (x === false) || (typeof x === 'number'));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.Keyword(null,"options","options",99638489));
var and__4115__auto__ = cljs.core.some((function (p1__4251_SHARP_){
return goog.string.startsWith(p1__4251_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4115__auto__)){
var and__4115__auto____$1 = opts;
if(cljs.core.truth_(and__4115__auto____$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"none","none",1333468478))){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"closure-defines","closure-defines",-1213856476),cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return false;
}
} else {
return and__4115__auto____$1;
}
} else {
return and__4115__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"def","def",-1043430536),(function (p__4252){
var map__4253 = p__4252;
var map__4253__$1 = (((((!((map__4253 == null))))?(((((map__4253.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4253.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4253):map__4253);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4253__$1,new cljs.core.Keyword(null,"doc","doc",1913296891));
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4253__$1,new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516));
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4253__$1,new cljs.core.Keyword(null,"test","test",577538877));
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4253__$1,new cljs.core.Keyword(null,"goog-define","goog-define",-1048305441));
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4253__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4253__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4253__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4253__$1,new cljs.core.Keyword(null,"export","export",214356590));
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4253__$1,new cljs.core.Keyword(null,"var","var",-769682797));
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4253__$1,new cljs.core.Keyword(null,"var-ast","var-ast",1200379319));
if(cljs.core.truth_((function (){var or__4126__auto__ = init;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"jsdoc","jsdoc",1745183516).cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5733__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5733__auto__)){
var define = temp__5733__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"def-emits-var","def-emits-var",-1551927320).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"the-var","the-var",1428415613),new cljs.core.Keyword(null,"env","env",-1815813235),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,new cljs.core.Keyword(null,"context","context",-830191113),new cljs.core.Keyword(null,"expr","expr",745722291))], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
return test;
} else {
return and__4115__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__4255){
var map__4256 = p__4255;
var map__4256__$1 = (((((!((map__4256 == null))))?(((((map__4256.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4256.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4256):map__4256);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4256__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4256__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4256__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__4258_4282 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__4259_4283 = null;
var count__4260_4284 = (0);
var i__4261_4285 = (0);
while(true){
if((i__4261_4285 < count__4260_4284)){
var vec__4268_4286 = chunk__4259_4283.cljs$core$IIndexed$_nth$arity$2(null,i__4261_4285);
var i_4287 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4268_4286,(0),null);
var param_4288 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4268_4286,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_4288);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__4289 = seq__4258_4282;
var G__4290 = chunk__4259_4283;
var G__4291 = count__4260_4284;
var G__4292 = (i__4261_4285 + (1));
seq__4258_4282 = G__4289;
chunk__4259_4283 = G__4290;
count__4260_4284 = G__4291;
i__4261_4285 = G__4292;
continue;
} else {
var temp__5735__auto___4293 = cljs.core.seq(seq__4258_4282);
if(temp__5735__auto___4293){
var seq__4258_4294__$1 = temp__5735__auto___4293;
if(cljs.core.chunked_seq_QMARK_(seq__4258_4294__$1)){
var c__4556__auto___4295 = cljs.core.chunk_first(seq__4258_4294__$1);
var G__4296 = cljs.core.chunk_rest(seq__4258_4294__$1);
var G__4297 = c__4556__auto___4295;
var G__4298 = cljs.core.count(c__4556__auto___4295);
var G__4299 = (0);
seq__4258_4282 = G__4296;
chunk__4259_4283 = G__4297;
count__4260_4284 = G__4298;
i__4261_4285 = G__4299;
continue;
} else {
var vec__4271_4300 = cljs.core.first(seq__4258_4294__$1);
var i_4301 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4271_4300,(0),null);
var param_4302 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4271_4300,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_4302);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__4303 = cljs.core.next(seq__4258_4294__$1);
var G__4304 = null;
var G__4305 = (0);
var G__4306 = (0);
seq__4258_4282 = G__4303;
chunk__4259_4283 = G__4304;
count__4260_4284 = G__4305;
i__4261_4285 = G__4306;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__4274_4307 = cljs.core.seq(params);
var chunk__4275_4308 = null;
var count__4276_4309 = (0);
var i__4277_4310 = (0);
while(true){
if((i__4277_4310 < count__4276_4309)){
var param_4311 = chunk__4275_4308.cljs$core$IIndexed$_nth$arity$2(null,i__4277_4310);
cljs.compiler.emit(param_4311);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_4311,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__4312 = seq__4274_4307;
var G__4313 = chunk__4275_4308;
var G__4314 = count__4276_4309;
var G__4315 = (i__4277_4310 + (1));
seq__4274_4307 = G__4312;
chunk__4275_4308 = G__4313;
count__4276_4309 = G__4314;
i__4277_4310 = G__4315;
continue;
} else {
var temp__5735__auto___4316 = cljs.core.seq(seq__4274_4307);
if(temp__5735__auto___4316){
var seq__4274_4317__$1 = temp__5735__auto___4316;
if(cljs.core.chunked_seq_QMARK_(seq__4274_4317__$1)){
var c__4556__auto___4318 = cljs.core.chunk_first(seq__4274_4317__$1);
var G__4319 = cljs.core.chunk_rest(seq__4274_4317__$1);
var G__4320 = c__4556__auto___4318;
var G__4321 = cljs.core.count(c__4556__auto___4318);
var G__4322 = (0);
seq__4274_4307 = G__4319;
chunk__4275_4308 = G__4320;
count__4276_4309 = G__4321;
i__4277_4310 = G__4322;
continue;
} else {
var param_4323 = cljs.core.first(seq__4274_4317__$1);
cljs.compiler.emit(param_4323);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_4323,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__4324 = cljs.core.next(seq__4274_4317__$1);
var G__4325 = null;
var G__4326 = (0);
var G__4327 = (0);
seq__4274_4307 = G__4324;
chunk__4275_4308 = G__4325;
count__4276_4309 = G__4326;
i__4277_4310 = G__4327;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__4278_4328 = cljs.core.seq(params);
var chunk__4279_4329 = null;
var count__4280_4330 = (0);
var i__4281_4331 = (0);
while(true){
if((i__4281_4331 < count__4280_4330)){
var param_4332 = chunk__4279_4329.cljs$core$IIndexed$_nth$arity$2(null,i__4281_4331);
cljs.compiler.emit(param_4332);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_4332,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__4333 = seq__4278_4328;
var G__4334 = chunk__4279_4329;
var G__4335 = count__4280_4330;
var G__4336 = (i__4281_4331 + (1));
seq__4278_4328 = G__4333;
chunk__4279_4329 = G__4334;
count__4280_4330 = G__4335;
i__4281_4331 = G__4336;
continue;
} else {
var temp__5735__auto___4337 = cljs.core.seq(seq__4278_4328);
if(temp__5735__auto___4337){
var seq__4278_4338__$1 = temp__5735__auto___4337;
if(cljs.core.chunked_seq_QMARK_(seq__4278_4338__$1)){
var c__4556__auto___4339 = cljs.core.chunk_first(seq__4278_4338__$1);
var G__4340 = cljs.core.chunk_rest(seq__4278_4338__$1);
var G__4341 = c__4556__auto___4339;
var G__4342 = cljs.core.count(c__4556__auto___4339);
var G__4343 = (0);
seq__4278_4328 = G__4340;
chunk__4279_4329 = G__4341;
count__4280_4330 = G__4342;
i__4281_4331 = G__4343;
continue;
} else {
var param_4344 = cljs.core.first(seq__4278_4338__$1);
cljs.compiler.emit(param_4344);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_4344,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__4345 = cljs.core.next(seq__4278_4338__$1);
var G__4346 = null;
var G__4347 = (0);
var G__4348 = (0);
seq__4278_4328 = G__4345;
chunk__4279_4329 = G__4346;
count__4280_4330 = G__4347;
i__4281_4331 = G__4348;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__4349 = cljs.core.seq(params);
var chunk__4350 = null;
var count__4351 = (0);
var i__4352 = (0);
while(true){
if((i__4352 < count__4351)){
var param = chunk__4350.cljs$core$IIndexed$_nth$arity$2(null,i__4352);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__4353 = seq__4349;
var G__4354 = chunk__4350;
var G__4355 = count__4351;
var G__4356 = (i__4352 + (1));
seq__4349 = G__4353;
chunk__4350 = G__4354;
count__4351 = G__4355;
i__4352 = G__4356;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__4349);
if(temp__5735__auto__){
var seq__4349__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__4349__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__4349__$1);
var G__4357 = cljs.core.chunk_rest(seq__4349__$1);
var G__4358 = c__4556__auto__;
var G__4359 = cljs.core.count(c__4556__auto__);
var G__4360 = (0);
seq__4349 = G__4357;
chunk__4350 = G__4358;
count__4351 = G__4359;
i__4352 = G__4360;
continue;
} else {
var param = cljs.core.first(seq__4349__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__4361 = cljs.core.next(seq__4349__$1);
var G__4362 = null;
var G__4363 = (0);
var G__4364 = (0);
seq__4349 = G__4361;
chunk__4350 = G__4362;
count__4351 = G__4363;
i__4352 = G__4364;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__4365){
var map__4366 = p__4365;
var map__4366__$1 = (((((!((map__4366 == null))))?(((((map__4366.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4366.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4366):map__4366);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4366__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4366__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4366__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4366__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4366__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4366__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__3768__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__4368){
var map__4369 = p__4368;
var map__4369__$1 = (((((!((map__4369 == null))))?(((((map__4369.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4369.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4369):map__4369);
var f = map__4369__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4369__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4369__$1,new cljs.core.Keyword(null,"fixed-arity","fixed-arity",1586445869));
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4369__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4369__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4369__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4369__$1,new cljs.core.Keyword(null,"params","params",710516235));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4369__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4369__$1,new cljs.core.Keyword(null,"recurs","recurs",-1959309309));
var env__3768__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_4379__$1 = (function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_4380 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_4379__$1);
var delegate_name_4381 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_4380),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_4381," = function (");

var seq__4371_4382 = cljs.core.seq(params);
var chunk__4372_4383 = null;
var count__4373_4384 = (0);
var i__4374_4385 = (0);
while(true){
if((i__4374_4385 < count__4373_4384)){
var param_4386 = chunk__4372_4383.cljs$core$IIndexed$_nth$arity$2(null,i__4374_4385);
cljs.compiler.emit(param_4386);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_4386,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__4387 = seq__4371_4382;
var G__4388 = chunk__4372_4383;
var G__4389 = count__4373_4384;
var G__4390 = (i__4374_4385 + (1));
seq__4371_4382 = G__4387;
chunk__4372_4383 = G__4388;
count__4373_4384 = G__4389;
i__4374_4385 = G__4390;
continue;
} else {
var temp__5735__auto___4391 = cljs.core.seq(seq__4371_4382);
if(temp__5735__auto___4391){
var seq__4371_4392__$1 = temp__5735__auto___4391;
if(cljs.core.chunked_seq_QMARK_(seq__4371_4392__$1)){
var c__4556__auto___4393 = cljs.core.chunk_first(seq__4371_4392__$1);
var G__4394 = cljs.core.chunk_rest(seq__4371_4392__$1);
var G__4395 = c__4556__auto___4393;
var G__4396 = cljs.core.count(c__4556__auto___4393);
var G__4397 = (0);
seq__4371_4382 = G__4394;
chunk__4372_4383 = G__4395;
count__4373_4384 = G__4396;
i__4374_4385 = G__4397;
continue;
} else {
var param_4398 = cljs.core.first(seq__4371_4392__$1);
cljs.compiler.emit(param_4398);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_4398,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__4399 = cljs.core.next(seq__4371_4392__$1);
var G__4400 = null;
var G__4401 = (0);
var G__4402 = (0);
seq__4371_4382 = G__4399;
chunk__4372_4383 = G__4400;
count__4373_4384 = G__4401;
i__4374_4385 = G__4402;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_4380," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_4403 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_4403,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_4381,".call(this,");

var seq__4375_4404 = cljs.core.seq(params);
var chunk__4376_4405 = null;
var count__4377_4406 = (0);
var i__4378_4407 = (0);
while(true){
if((i__4378_4407 < count__4377_4406)){
var param_4408 = chunk__4376_4405.cljs$core$IIndexed$_nth$arity$2(null,i__4378_4407);
cljs.compiler.emit(param_4408);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_4408,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__4409 = seq__4375_4404;
var G__4410 = chunk__4376_4405;
var G__4411 = count__4377_4406;
var G__4412 = (i__4378_4407 + (1));
seq__4375_4404 = G__4409;
chunk__4376_4405 = G__4410;
count__4377_4406 = G__4411;
i__4378_4407 = G__4412;
continue;
} else {
var temp__5735__auto___4413 = cljs.core.seq(seq__4375_4404);
if(temp__5735__auto___4413){
var seq__4375_4414__$1 = temp__5735__auto___4413;
if(cljs.core.chunked_seq_QMARK_(seq__4375_4414__$1)){
var c__4556__auto___4415 = cljs.core.chunk_first(seq__4375_4414__$1);
var G__4416 = cljs.core.chunk_rest(seq__4375_4414__$1);
var G__4417 = c__4556__auto___4415;
var G__4418 = cljs.core.count(c__4556__auto___4415);
var G__4419 = (0);
seq__4375_4404 = G__4416;
chunk__4376_4405 = G__4417;
count__4377_4406 = G__4418;
i__4378_4407 = G__4419;
continue;
} else {
var param_4420 = cljs.core.first(seq__4375_4414__$1);
cljs.compiler.emit(param_4420);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_4420,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__4421 = cljs.core.next(seq__4375_4414__$1);
var G__4422 = null;
var G__4423 = (0);
var G__4424 = (0);
seq__4375_4404 = G__4421;
chunk__4376_4405 = G__4422;
count__4377_4406 = G__4423;
i__4378_4407 = G__4424;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_4380,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_4380,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.Keyword(null,"name","name",1843675177),name_4379__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_4380,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_4381,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_4380,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"fn","fn",-1175266204),(function (p__4428){
var map__4429 = p__4428;
var map__4429__$1 = (((((!((map__4429 == null))))?(((((map__4429.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4429.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4429):map__4429);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4429__$1,new cljs.core.Keyword(null,"variadic?","variadic?",584179762));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4429__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4429__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4429__$1,new cljs.core.Keyword(null,"methods","methods",453930866));
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4429__$1,new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543));
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4429__$1,new cljs.core.Keyword(null,"recur-frames","recur-frames",-307205196));
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4429__$1,new cljs.core.Keyword(null,"in-loop","in-loop",-187298246));
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4429__$1,new cljs.core.Keyword(null,"loop-lets","loop-lets",2036794185));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__4425_SHARP_){
var and__4115__auto__ = p1__4425_SHARP_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.deref(new cljs.core.Keyword(null,"flag","flag",1088647881).cljs$core$IFn$_invoke$arity$1(p1__4425_SHARP_));
} else {
return and__4115__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4126__auto__ = in_loop;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"params","params",710516235),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),new cljs.core.Keyword(null,"name","name",1843675177),name));
}
} else {
var name_4482__$1 = (function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_4483 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_4482__$1);
var maxparams_4484 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"params","params",710516235),methods$));
var mmap_4485 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_4483),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_4486 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__4426_SHARP_){
return cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__4426_SHARP_)));
}),cljs.core.seq(mmap_4485));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_4483," = null;");

var seq__4431_4487 = cljs.core.seq(ms_4486);
var chunk__4432_4488 = null;
var count__4433_4489 = (0);
var i__4434_4490 = (0);
while(true){
if((i__4434_4490 < count__4433_4489)){
var vec__4441_4491 = chunk__4432_4488.cljs$core$IIndexed$_nth$arity$2(null,i__4434_4490);
var n_4492 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4441_4491,(0),null);
var meth_4493 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4441_4491,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_4492," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_4493))){
cljs.compiler.emit_variadic_fn_method(meth_4493);
} else {
cljs.compiler.emit_fn_method(meth_4493);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__4494 = seq__4431_4487;
var G__4495 = chunk__4432_4488;
var G__4496 = count__4433_4489;
var G__4497 = (i__4434_4490 + (1));
seq__4431_4487 = G__4494;
chunk__4432_4488 = G__4495;
count__4433_4489 = G__4496;
i__4434_4490 = G__4497;
continue;
} else {
var temp__5735__auto___4498 = cljs.core.seq(seq__4431_4487);
if(temp__5735__auto___4498){
var seq__4431_4499__$1 = temp__5735__auto___4498;
if(cljs.core.chunked_seq_QMARK_(seq__4431_4499__$1)){
var c__4556__auto___4500 = cljs.core.chunk_first(seq__4431_4499__$1);
var G__4501 = cljs.core.chunk_rest(seq__4431_4499__$1);
var G__4502 = c__4556__auto___4500;
var G__4503 = cljs.core.count(c__4556__auto___4500);
var G__4504 = (0);
seq__4431_4487 = G__4501;
chunk__4432_4488 = G__4502;
count__4433_4489 = G__4503;
i__4434_4490 = G__4504;
continue;
} else {
var vec__4444_4505 = cljs.core.first(seq__4431_4499__$1);
var n_4506 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4444_4505,(0),null);
var meth_4507 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4444_4505,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_4506," = ");

if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_4507))){
cljs.compiler.emit_variadic_fn_method(meth_4507);
} else {
cljs.compiler.emit_fn_method(meth_4507);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__4508 = cljs.core.next(seq__4431_4499__$1);
var G__4509 = null;
var G__4510 = (0);
var G__4511 = (0);
seq__4431_4487 = G__4508;
chunk__4432_4488 = G__4509;
count__4433_4489 = G__4510;
i__4434_4490 = G__4511;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_4483," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_4484),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"var_args","var_args",1214280389,null)], null)):maxparams_4484)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_4484));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__4447_4512 = cljs.core.seq(ms_4486);
var chunk__4448_4513 = null;
var count__4449_4514 = (0);
var i__4450_4515 = (0);
while(true){
if((i__4450_4515 < count__4449_4514)){
var vec__4457_4516 = chunk__4448_4513.cljs$core$IIndexed$_nth$arity$2(null,i__4450_4515);
var n_4517 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4457_4516,(0),null);
var meth_4518 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4457_4516,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_4518))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_4519 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_4519," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_4520 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_4519," = new cljs.core.IndexedSeq(",a_4520,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_4517,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_4484)),(((cljs.core.count(maxparams_4484) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_4519,");"], 0));
} else {
var pcnt_4521 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_4518));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_4521,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_4517,".call(this",(((pcnt_4521 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_4521,maxparams_4484)),null,(1),null)),(2),null))),");");
}


var G__4522 = seq__4447_4512;
var G__4523 = chunk__4448_4513;
var G__4524 = count__4449_4514;
var G__4525 = (i__4450_4515 + (1));
seq__4447_4512 = G__4522;
chunk__4448_4513 = G__4523;
count__4449_4514 = G__4524;
i__4450_4515 = G__4525;
continue;
} else {
var temp__5735__auto___4526 = cljs.core.seq(seq__4447_4512);
if(temp__5735__auto___4526){
var seq__4447_4527__$1 = temp__5735__auto___4526;
if(cljs.core.chunked_seq_QMARK_(seq__4447_4527__$1)){
var c__4556__auto___4528 = cljs.core.chunk_first(seq__4447_4527__$1);
var G__4529 = cljs.core.chunk_rest(seq__4447_4527__$1);
var G__4530 = c__4556__auto___4528;
var G__4531 = cljs.core.count(c__4556__auto___4528);
var G__4532 = (0);
seq__4447_4512 = G__4529;
chunk__4448_4513 = G__4530;
count__4449_4514 = G__4531;
i__4450_4515 = G__4532;
continue;
} else {
var vec__4460_4533 = cljs.core.first(seq__4447_4527__$1);
var n_4534 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4460_4533,(0),null);
var meth_4535 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4460_4533,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_4535))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_4536 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_4536," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_4537 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_4536," = new cljs.core.IndexedSeq(",a_4537,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_4534,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_4484)),(((cljs.core.count(maxparams_4484) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_4536,");"], 0));
} else {
var pcnt_4538 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_4535));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_4538,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_4534,".call(this",(((pcnt_4538 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_4538,maxparams_4484)),null,(1),null)),(2),null))),");");
}


var G__4539 = cljs.core.next(seq__4447_4527__$1);
var G__4540 = null;
var G__4541 = (0);
var G__4542 = (0);
seq__4447_4512 = G__4539;
chunk__4448_4513 = G__4540;
count__4449_4514 = G__4541;
i__4450_4515 = G__4542;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_4543 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"self__","self__",-153190816,null),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_4486)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_4543,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_4483,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_4483,".cljs$lang$applyTo = ",cljs.core.some((function (p1__4427_SHARP_){
var vec__4463 = p1__4427_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4463,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4463,(1),null);
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_4486),".cljs$lang$applyTo;");
} else {
}

var seq__4466_4544 = cljs.core.seq(ms_4486);
var chunk__4467_4545 = null;
var count__4468_4546 = (0);
var i__4469_4547 = (0);
while(true){
if((i__4469_4547 < count__4468_4546)){
var vec__4476_4548 = chunk__4467_4545.cljs$core$IIndexed$_nth$arity$2(null,i__4469_4547);
var n_4549 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4476_4548,(0),null);
var meth_4550 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4476_4548,(1),null);
var c_4551 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_4550));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_4550))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_4483,".cljs$core$IFn$_invoke$arity$variadic = ",n_4549,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_4483,".cljs$core$IFn$_invoke$arity$",c_4551," = ",n_4549,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__4552 = seq__4466_4544;
var G__4553 = chunk__4467_4545;
var G__4554 = count__4468_4546;
var G__4555 = (i__4469_4547 + (1));
seq__4466_4544 = G__4552;
chunk__4467_4545 = G__4553;
count__4468_4546 = G__4554;
i__4469_4547 = G__4555;
continue;
} else {
var temp__5735__auto___4556 = cljs.core.seq(seq__4466_4544);
if(temp__5735__auto___4556){
var seq__4466_4557__$1 = temp__5735__auto___4556;
if(cljs.core.chunked_seq_QMARK_(seq__4466_4557__$1)){
var c__4556__auto___4558 = cljs.core.chunk_first(seq__4466_4557__$1);
var G__4559 = cljs.core.chunk_rest(seq__4466_4557__$1);
var G__4560 = c__4556__auto___4558;
var G__4561 = cljs.core.count(c__4556__auto___4558);
var G__4562 = (0);
seq__4466_4544 = G__4559;
chunk__4467_4545 = G__4560;
count__4468_4546 = G__4561;
i__4469_4547 = G__4562;
continue;
} else {
var vec__4479_4563 = cljs.core.first(seq__4466_4557__$1);
var n_4564 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4479_4563,(0),null);
var meth_4565 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4479_4563,(1),null);
var c_4566 = cljs.core.count(new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(meth_4565));
if(cljs.core.truth_(new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(meth_4565))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_4483,".cljs$core$IFn$_invoke$arity$variadic = ",n_4564,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_4483,".cljs$core$IFn$_invoke$arity$",c_4566," = ",n_4564,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__4567 = cljs.core.next(seq__4466_4557__$1);
var G__4568 = null;
var G__4569 = (0);
var G__4570 = (0);
seq__4466_4544 = G__4567;
chunk__4467_4545 = G__4568;
count__4468_4546 = G__4569;
i__4469_4547 = G__4570;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_4483,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"do","do",46310725),(function (p__4571){
var map__4572 = p__4571;
var map__4572__$1 = (((((!((map__4572 == null))))?(((((map__4572.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4572.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4572):map__4572);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4572__$1,new cljs.core.Keyword(null,"statements","statements",600349855));
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4572__$1,new cljs.core.Keyword(null,"ret","ret",-468222814));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4572__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__4574_4578 = cljs.core.seq(statements);
var chunk__4575_4579 = null;
var count__4576_4580 = (0);
var i__4577_4581 = (0);
while(true){
if((i__4577_4581 < count__4576_4580)){
var s_4582 = chunk__4575_4579.cljs$core$IIndexed$_nth$arity$2(null,i__4577_4581);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_4582);


var G__4583 = seq__4574_4578;
var G__4584 = chunk__4575_4579;
var G__4585 = count__4576_4580;
var G__4586 = (i__4577_4581 + (1));
seq__4574_4578 = G__4583;
chunk__4575_4579 = G__4584;
count__4576_4580 = G__4585;
i__4577_4581 = G__4586;
continue;
} else {
var temp__5735__auto___4587 = cljs.core.seq(seq__4574_4578);
if(temp__5735__auto___4587){
var seq__4574_4588__$1 = temp__5735__auto___4587;
if(cljs.core.chunked_seq_QMARK_(seq__4574_4588__$1)){
var c__4556__auto___4589 = cljs.core.chunk_first(seq__4574_4588__$1);
var G__4590 = cljs.core.chunk_rest(seq__4574_4588__$1);
var G__4591 = c__4556__auto___4589;
var G__4592 = cljs.core.count(c__4556__auto___4589);
var G__4593 = (0);
seq__4574_4578 = G__4590;
chunk__4575_4579 = G__4591;
count__4576_4580 = G__4592;
i__4577_4581 = G__4593;
continue;
} else {
var s_4594 = cljs.core.first(seq__4574_4588__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_4594);


var G__4595 = cljs.core.next(seq__4574_4588__$1);
var G__4596 = null;
var G__4597 = (0);
var G__4598 = (0);
seq__4574_4578 = G__4595;
chunk__4575_4579 = G__4596;
count__4576_4580 = G__4597;
i__4577_4581 = G__4598;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"try","try",1380742522),(function (p__4599){
var map__4600 = p__4599;
var map__4600__$1 = (((((!((map__4600 == null))))?(((((map__4600.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4600.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4600):map__4600);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4600__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4600__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4600__$1,new cljs.core.Keyword(null,"catch","catch",1038065524));
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4600__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4600__$1,new cljs.core.Keyword(null,"finally","finally",1589088705));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4126__auto__ = name;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"const","const",1709929842),new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__4602,is_loop){
var map__4603 = p__4602;
var map__4603__$1 = (((((!((map__4603 == null))))?(((((map__4603.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4603.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4603):map__4603);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4603__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4603__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4603__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__4605_4619 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__4606_4620 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"statement","statement",-32780863),context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__4606_4620);

try{var seq__4607_4621 = cljs.core.seq(bindings);
var chunk__4608_4622 = null;
var count__4609_4623 = (0);
var i__4610_4624 = (0);
while(true){
if((i__4610_4624 < count__4609_4623)){
var map__4615_4625 = chunk__4608_4622.cljs$core$IIndexed$_nth$arity$2(null,i__4610_4624);
var map__4615_4626__$1 = (((((!((map__4615_4625 == null))))?(((((map__4615_4625.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4615_4625.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4615_4625):map__4615_4625);
var binding_4627 = map__4615_4626__$1;
var init_4628 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4615_4626__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_4627);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_4628,";");


var G__4629 = seq__4607_4621;
var G__4630 = chunk__4608_4622;
var G__4631 = count__4609_4623;
var G__4632 = (i__4610_4624 + (1));
seq__4607_4621 = G__4629;
chunk__4608_4622 = G__4630;
count__4609_4623 = G__4631;
i__4610_4624 = G__4632;
continue;
} else {
var temp__5735__auto___4633 = cljs.core.seq(seq__4607_4621);
if(temp__5735__auto___4633){
var seq__4607_4634__$1 = temp__5735__auto___4633;
if(cljs.core.chunked_seq_QMARK_(seq__4607_4634__$1)){
var c__4556__auto___4635 = cljs.core.chunk_first(seq__4607_4634__$1);
var G__4636 = cljs.core.chunk_rest(seq__4607_4634__$1);
var G__4637 = c__4556__auto___4635;
var G__4638 = cljs.core.count(c__4556__auto___4635);
var G__4639 = (0);
seq__4607_4621 = G__4636;
chunk__4608_4622 = G__4637;
count__4609_4623 = G__4638;
i__4610_4624 = G__4639;
continue;
} else {
var map__4617_4640 = cljs.core.first(seq__4607_4634__$1);
var map__4617_4641__$1 = (((((!((map__4617_4640 == null))))?(((((map__4617_4640.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4617_4640.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4617_4640):map__4617_4640);
var binding_4642 = map__4617_4641__$1;
var init_4643 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4617_4641__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_4642);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_4643,";");


var G__4644 = cljs.core.next(seq__4607_4634__$1);
var G__4645 = null;
var G__4646 = (0);
var G__4647 = (0);
seq__4607_4621 = G__4644;
chunk__4608_4622 = G__4645;
count__4609_4623 = G__4646;
i__4610_4624 = G__4647;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__4605_4619);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"let","let",-1282412701),(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"loop","loop",-395552849),(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"recur","recur",-437573268),(function (p__4648){
var map__4649 = p__4648;
var map__4649__$1 = (((((!((map__4649 == null))))?(((((map__4649.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4649.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4649):map__4649);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4649__$1,new cljs.core.Keyword(null,"frame","frame",-1711082588));
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4649__$1,new cljs.core.Keyword(null,"exprs","exprs",1795829094));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4649__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(frame);
var n__4613__auto___4651 = cljs.core.count(exprs);
var i_4652 = (0);
while(true){
if((i_4652 < n__4613__auto___4651)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_4652) : temps.call(null,i_4652))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_4652) : exprs.call(null,i_4652)),";");

var G__4653 = (i_4652 + (1));
i_4652 = G__4653;
continue;
} else {
}
break;
}

var n__4613__auto___4654 = cljs.core.count(exprs);
var i_4655 = (0);
while(true){
if((i_4655 < n__4613__auto___4654)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_4655) : params.call(null,i_4655)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_4655) : temps.call(null,i_4655)),";");

var G__4656 = (i_4655 + (1));
i_4655 = G__4656;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"letfn","letfn",-2121022354),(function (p__4657){
var map__4658 = p__4657;
var map__4658__$1 = (((((!((map__4658 == null))))?(((((map__4658.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4658.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4658):map__4658);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4658__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4658__$1,new cljs.core.Keyword(null,"bindings","bindings",1271397192));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4658__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var context = new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__4660_4672 = cljs.core.seq(bindings);
var chunk__4661_4673 = null;
var count__4662_4674 = (0);
var i__4663_4675 = (0);
while(true){
if((i__4663_4675 < count__4662_4674)){
var map__4668_4676 = chunk__4661_4673.cljs$core$IIndexed$_nth$arity$2(null,i__4663_4675);
var map__4668_4677__$1 = (((((!((map__4668_4676 == null))))?(((((map__4668_4676.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4668_4676.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4668_4676):map__4668_4676);
var binding_4678 = map__4668_4677__$1;
var init_4679 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4668_4677__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_4678)," = ",init_4679,";");


var G__4680 = seq__4660_4672;
var G__4681 = chunk__4661_4673;
var G__4682 = count__4662_4674;
var G__4683 = (i__4663_4675 + (1));
seq__4660_4672 = G__4680;
chunk__4661_4673 = G__4681;
count__4662_4674 = G__4682;
i__4663_4675 = G__4683;
continue;
} else {
var temp__5735__auto___4684 = cljs.core.seq(seq__4660_4672);
if(temp__5735__auto___4684){
var seq__4660_4685__$1 = temp__5735__auto___4684;
if(cljs.core.chunked_seq_QMARK_(seq__4660_4685__$1)){
var c__4556__auto___4686 = cljs.core.chunk_first(seq__4660_4685__$1);
var G__4687 = cljs.core.chunk_rest(seq__4660_4685__$1);
var G__4688 = c__4556__auto___4686;
var G__4689 = cljs.core.count(c__4556__auto___4686);
var G__4690 = (0);
seq__4660_4672 = G__4687;
chunk__4661_4673 = G__4688;
count__4662_4674 = G__4689;
i__4663_4675 = G__4690;
continue;
} else {
var map__4670_4691 = cljs.core.first(seq__4660_4685__$1);
var map__4670_4692__$1 = (((((!((map__4670_4691 == null))))?(((((map__4670_4691.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4670_4691.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4670_4691):map__4670_4691);
var binding_4693 = map__4670_4692__$1;
var init_4694 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4670_4692__$1,new cljs.core.Keyword(null,"init","init",-1875481434));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_4693)," = ",init_4694,";");


var G__4695 = cljs.core.next(seq__4660_4685__$1);
var G__4696 = null;
var G__4697 = (0);
var G__4698 = (0);
seq__4660_4672 = G__4695;
chunk__4661_4673 = G__4696;
count__4662_4674 = G__4697;
i__4663_4675 = G__4698;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"invoke","invoke",1145927159),(function (p__4701){
var map__4702 = p__4701;
var map__4702__$1 = (((((!((map__4702 == null))))?(((((map__4702.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4702.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4702):map__4702);
var expr = map__4702__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4702__$1,new cljs.core.Keyword(null,"fn","fn",-1175266204));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4702__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4702__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var info = new cljs.core.Keyword(null,"info","info",-317069002).cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4115__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
if(cljs.core.not(new cljs.core.Keyword(null,"dynamic","dynamic",704819571).cljs$core$IFn$_invoke$arity$1(info))){
return new cljs.core.Keyword(null,"fn-var","fn-var",1086204730).cljs$core$IFn$_invoke$arity$1(info);
} else {
return false;
}
} else {
return and__4115__auto__;
}
})();
var protocol = new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4115__auto__ = protocol;
if(cljs.core.truth_(and__4115__auto__)){
var and__4115__auto____$1 = tag;
if(cljs.core.truth_(and__4115__auto____$1)){
var or__4126__auto__ = (function (){var and__4115__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto____$2)){
var and__4115__auto____$3 = protocol;
if(cljs.core.truth_(and__4115__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,new cljs.core.Symbol(null,"not-native","not-native",-236392494,null));
} else {
return and__4115__auto____$3;
}
} else {
return and__4115__auto____$2;
}
})();
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var and__4115__auto____$2 = (function (){var or__4126__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"protocol-inline","protocol-inline",1550487556).cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4115__auto____$2)){
var or__4126__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4126__auto____$1){
return or__4126__auto____$1;
} else {
if((!(cljs.core.set_QMARK_(tag)))){
if(cljs.core.not((function (){var fexpr__4714 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Symbol(null,"clj","clj",980036099,null),"null",new cljs.core.Symbol(null,"boolean","boolean",-278886877,null),"null",new cljs.core.Symbol(null,"object","object",-1179821820,null),"null",new cljs.core.Symbol(null,"any","any",-948528346,null),"null",new cljs.core.Symbol(null,"js","js",-886355190,null),"null",new cljs.core.Symbol(null,"number","number",-1084057331,null),"null",new cljs.core.Symbol(null,"clj-or-nil","clj-or-nil",-2008798668,null),"null",new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null",new cljs.core.Symbol(null,"function","function",-486723946,null),"null",new cljs.core.Symbol(null,"clj-nil","clj-nil",1321798654,null),"null"], null), null);
return (fexpr__4714.cljs$core$IFn$_invoke$arity$1 ? fexpr__4714.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__4714.call(null,tag));
})())){
var temp__5735__auto__ = new cljs.core.Keyword(null,"protocols","protocols",-5615896).cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,new cljs.core.Keyword("cljs.analyzer","no-resolve","cljs.analyzer/no-resolve",-1872351017),true)));
if(cljs.core.truth_(temp__5735__auto__)){
var ps = temp__5735__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return false;
}
} else {
return false;
}
}
} else {
return and__4115__auto____$2;
}
}
} else {
return and__4115__auto____$1;
}
} else {
return and__4115__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(new cljs.core.Keyword(null,"args","args",1315556576).cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","not","cljs.core/not",100665144,null))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,new cljs.core.Symbol(null,"boolean","boolean",-278886877,null))));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info),new cljs.core.Symbol("cljs.core","count","cljs.core/count",-921270233,null))) && (cljs.core.boolean$((function (){var fexpr__4716 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Symbol(null,"array","array",-440182315,null),"null",new cljs.core.Symbol(null,"string","string",-349010059,null),"null"], null), null);
return (fexpr__4716.cljs$core$IFn$_invoke$arity$1 ? fexpr__4716.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__4716.call(null,first_arg_tag));
})())));
var ns = new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4126__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"js","js",-886355190,null));
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"Math","Math",2033287572,null));
if(or__4126__auto____$1){
return or__4126__auto____$1;
} else {
return new cljs.core.Keyword(null,"foreign","foreign",990521149).cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4126__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,new cljs.core.Symbol(null,"goog","goog",-70603925,null));
if(or__4126__auto__){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = (function (){var temp__5735__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5735__auto__)){
var ns_str = temp__5735__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(new cljs.core.Keyword("cljs.analyzer","namespaces","cljs.analyzer/namespaces",-260788927).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4126__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol("cljs.core","Keyword","cljs.core/Keyword",-451434488,null),ftag);
if(or__4126__auto__){
return or__4126__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1),new cljs.core.Keyword(null,"const","const",1709929842))) && ((new cljs.core.Keyword(null,"form","form",-1624062471).cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__4704 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = new cljs.core.Keyword(null,"variadic?","variadic?",584179762).cljs$core$IFn$_invoke$arity$1(info);
var mps = new cljs.core.Keyword(null,"method-params","method-params",-980792179).cljs$core$IFn$_invoke$arity$1(info);
var mfa = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return (arity > mfa);
} else {
return and__4115__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__4699_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__4699_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543),mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"info","info",-317069002)], null),(function (p1__4700_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__4700_SHARP_,new cljs.core.Keyword(null,"shadow","shadow",873231803)),new cljs.core.Keyword(null,"fn-self-name","fn-self-name",1461143531));
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4704,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4704,(1),null);
var env__3768__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_4719 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_4719,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_4720 = new cljs.core.Keyword(null,"max-fixed-arity","max-fixed-arity",-690205543).cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_4720,args)),(((mfa_4720 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_4720,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
var or__4126__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4126__auto____$1)){
return or__4126__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4115__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4115__auto__)){
var G__4718 = new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__4717 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"var","var",-769682797),null,new cljs.core.Keyword(null,"js-var","js-var",-1177899142),null,new cljs.core.Keyword(null,"local","local",-1497766724),null], null), null);
return (fexpr__4717.cljs$core$IFn$_invoke$arity$1 ? fexpr__4717.cljs$core$IFn$_invoke$arity$1(G__4718) : fexpr__4717.call(null,G__4718));
} else {
return and__4115__auto__;
}
})())){
var fprop_4721 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_4721," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_4721,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_4721," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_4721,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"new","new",-2085437848),(function (p__4722){
var map__4723 = p__4722;
var map__4723__$1 = (((((!((map__4723 == null))))?(((((map__4723.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4723.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4723):map__4723);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4723__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4723__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4723__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__3768__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"set!","set!",-1389817006),(function (p__4725){
var map__4726 = p__4725;
var map__4726__$1 = (((((!((map__4726 == null))))?(((((map__4726.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4726.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4726):map__4726);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4726__$1,new cljs.core.Keyword(null,"target","target",253001721));
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4726__$1,new cljs.core.Keyword(null,"val","val",128701612));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4726__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__3768__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4126__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__4728 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__4728__$1 = (((((!((map__4728 == null))))?(((((map__4728.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4728.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4728):map__4728);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4728__$1,new cljs.core.Keyword(null,"options","options",99638489));
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4728__$1,new cljs.core.Keyword(null,"js-dependency-index","js-dependency-index",-1887042131));
var map__4729 = options;
var map__4729__$1 = (((((!((map__4729 == null))))?(((((map__4729.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4729.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4729):map__4729);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4729__$1,new cljs.core.Keyword(null,"target","target",253001721));
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4729__$1,new cljs.core.Keyword(null,"nodejs-rt","nodejs-rt",-512437071));
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4729__$1,new cljs.core.Keyword(null,"optimizations","optimizations",-2047476854));
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null));
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(new cljs.core.Symbol(null,"cljs.core.*loaded-libs*","cljs.core.*loaded-libs*",-1847086525,null)));
var vec__4730 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"nodejs","nodejs",321212524),target)){
var map__4735 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__4735__$1 = (((((!((map__4735 == null))))?(((((map__4735.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4735.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4735):map__4735);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4735__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4735__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4730,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4730,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__4737_4757 = cljs.core.seq(libs_to_load);
var chunk__4738_4758 = null;
var count__4739_4759 = (0);
var i__4740_4760 = (0);
while(true){
if((i__4740_4760 < count__4739_4759)){
var lib_4761 = chunk__4738_4758.cljs$core$IIndexed$_nth$arity$2(null,i__4740_4760);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_4761)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_4761),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_4761),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_4761),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_4761),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_4761,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_4761),"');");
}

}
}
}


var G__4762 = seq__4737_4757;
var G__4763 = chunk__4738_4758;
var G__4764 = count__4739_4759;
var G__4765 = (i__4740_4760 + (1));
seq__4737_4757 = G__4762;
chunk__4738_4758 = G__4763;
count__4739_4759 = G__4764;
i__4740_4760 = G__4765;
continue;
} else {
var temp__5735__auto___4766 = cljs.core.seq(seq__4737_4757);
if(temp__5735__auto___4766){
var seq__4737_4767__$1 = temp__5735__auto___4766;
if(cljs.core.chunked_seq_QMARK_(seq__4737_4767__$1)){
var c__4556__auto___4768 = cljs.core.chunk_first(seq__4737_4767__$1);
var G__4769 = cljs.core.chunk_rest(seq__4737_4767__$1);
var G__4770 = c__4556__auto___4768;
var G__4771 = cljs.core.count(c__4556__auto___4768);
var G__4772 = (0);
seq__4737_4757 = G__4769;
chunk__4738_4758 = G__4770;
count__4739_4759 = G__4771;
i__4740_4760 = G__4772;
continue;
} else {
var lib_4773 = cljs.core.first(seq__4737_4767__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_4773)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,new cljs.core.Keyword(null,"none","none",1333468478))))))){
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload","reload",863702807).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_4773),new cljs.core.Keyword(null,"reload","reload",863702807));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_4773),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4126__auto__ = new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_4773),new cljs.core.Keyword(null,"reload-all","reload-all",761570200));
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_4773),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_4773,new cljs.core.Symbol(null,"goog","goog",-70603925,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_4773),"');");
}

}
}
}


var G__4774 = cljs.core.next(seq__4737_4767__$1);
var G__4775 = null;
var G__4776 = (0);
var G__4777 = (0);
seq__4737_4757 = G__4774;
chunk__4738_4758 = G__4775;
count__4739_4759 = G__4776;
i__4740_4760 = G__4777;
continue;
}
} else {
}
}
break;
}

var seq__4741_4778 = cljs.core.seq(node_libs);
var chunk__4742_4779 = null;
var count__4743_4780 = (0);
var i__4744_4781 = (0);
while(true){
if((i__4744_4781 < count__4743_4780)){
var lib_4782 = chunk__4742_4779.cljs$core$IIndexed$_nth$arity$2(null,i__4744_4781);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_4782)," = require('",lib_4782,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__4783 = seq__4741_4778;
var G__4784 = chunk__4742_4779;
var G__4785 = count__4743_4780;
var G__4786 = (i__4744_4781 + (1));
seq__4741_4778 = G__4783;
chunk__4742_4779 = G__4784;
count__4743_4780 = G__4785;
i__4744_4781 = G__4786;
continue;
} else {
var temp__5735__auto___4787 = cljs.core.seq(seq__4741_4778);
if(temp__5735__auto___4787){
var seq__4741_4788__$1 = temp__5735__auto___4787;
if(cljs.core.chunked_seq_QMARK_(seq__4741_4788__$1)){
var c__4556__auto___4789 = cljs.core.chunk_first(seq__4741_4788__$1);
var G__4790 = cljs.core.chunk_rest(seq__4741_4788__$1);
var G__4791 = c__4556__auto___4789;
var G__4792 = cljs.core.count(c__4556__auto___4789);
var G__4793 = (0);
seq__4741_4778 = G__4790;
chunk__4742_4779 = G__4791;
count__4743_4780 = G__4792;
i__4744_4781 = G__4793;
continue;
} else {
var lib_4794 = cljs.core.first(seq__4741_4788__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_4794)," = require('",lib_4794,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["');"], 0));


var G__4795 = cljs.core.next(seq__4741_4788__$1);
var G__4796 = null;
var G__4797 = (0);
var G__4798 = (0);
seq__4741_4778 = G__4795;
chunk__4742_4779 = G__4796;
count__4743_4780 = G__4797;
i__4744_4781 = G__4798;
continue;
}
} else {
}
}
break;
}

var seq__4745_4799 = cljs.core.seq(global_exports_libs);
var chunk__4746_4800 = null;
var count__4747_4801 = (0);
var i__4748_4802 = (0);
while(true){
if((i__4748_4802 < count__4747_4801)){
var lib_4803 = chunk__4746_4800.cljs$core$IIndexed$_nth$arity$2(null,i__4748_4802);
var map__4753_4804 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_4803));
var map__4753_4805__$1 = (((((!((map__4753_4804 == null))))?(((((map__4753_4804.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4753_4804.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4753_4804):map__4753_4804);
var global_exports_4806 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4753_4805__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_4806,lib_4803);


var G__4807 = seq__4745_4799;
var G__4808 = chunk__4746_4800;
var G__4809 = count__4747_4801;
var G__4810 = (i__4748_4802 + (1));
seq__4745_4799 = G__4807;
chunk__4746_4800 = G__4808;
count__4747_4801 = G__4809;
i__4748_4802 = G__4810;
continue;
} else {
var temp__5735__auto___4811 = cljs.core.seq(seq__4745_4799);
if(temp__5735__auto___4811){
var seq__4745_4812__$1 = temp__5735__auto___4811;
if(cljs.core.chunked_seq_QMARK_(seq__4745_4812__$1)){
var c__4556__auto___4813 = cljs.core.chunk_first(seq__4745_4812__$1);
var G__4814 = cljs.core.chunk_rest(seq__4745_4812__$1);
var G__4815 = c__4556__auto___4813;
var G__4816 = cljs.core.count(c__4556__auto___4813);
var G__4817 = (0);
seq__4745_4799 = G__4814;
chunk__4746_4800 = G__4815;
count__4747_4801 = G__4816;
i__4748_4802 = G__4817;
continue;
} else {
var lib_4818 = cljs.core.first(seq__4745_4812__$1);
var map__4755_4819 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(lib_4818));
var map__4755_4820__$1 = (((((!((map__4755_4819 == null))))?(((((map__4755_4819.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4755_4819.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4755_4819):map__4755_4819);
var global_exports_4821 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4755_4820__$1,new cljs.core.Keyword(null,"global-exports","global-exports",-1644865592));
cljs.compiler.emit_global_export(ns_name,global_exports_4821,lib_4818);


var G__4822 = cljs.core.next(seq__4745_4812__$1);
var G__4823 = null;
var G__4824 = (0);
var G__4825 = (0);
seq__4745_4799 = G__4822;
chunk__4746_4800 = G__4823;
count__4747_4801 = G__4824;
i__4748_4802 = G__4825;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(new cljs.core.Keyword(null,"reload-all","reload-all",761570200).cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns*","ns*",200417856),(function (p__4826){
var map__4827 = p__4826;
var map__4827__$1 = (((((!((map__4827 == null))))?(((((map__4827.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4827.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4827):map__4827);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4827__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4827__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4827__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4827__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4827__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4827__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4827__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(new cljs.core.Keyword(null,"repl-env","repl-env",-1976503928).cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"ns","ns",441598760),(function (p__4829){
var map__4830 = p__4829;
var map__4830__$1 = (((((!((map__4830 == null))))?(((((map__4830.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4830.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4830):map__4830);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4830__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4830__$1,new cljs.core.Keyword(null,"requires","requires",-1201390927));
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4830__$1,new cljs.core.Keyword(null,"uses","uses",232664692));
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4830__$1,new cljs.core.Keyword(null,"require-macros","require-macros",707947416));
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4830__$1,new cljs.core.Keyword(null,"reloads","reloads",610698522));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4830__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4830__$1,new cljs.core.Keyword(null,"deps","deps",1883360319));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,new cljs.core.Symbol(null,"cljs.core","cljs.core",770546058,null))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(new cljs.core.Keyword(null,"emit-constants","emit-constants",-476585410).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"options","options",99638489).cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,new cljs.core.Keyword(null,"require","require",-468001333).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,new cljs.core.Keyword(null,"use","use",-1846382424).cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"deftype","deftype",340294561),(function (p__4832){
var map__4833 = p__4832;
var map__4833__$1 = (((((!((map__4833 == null))))?(((((map__4833.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4833.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4833):map__4833);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4833__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4833__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4833__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4833__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4833__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__4835_4859 = cljs.core.seq(protocols);
var chunk__4836_4860 = null;
var count__4837_4861 = (0);
var i__4838_4862 = (0);
while(true){
if((i__4838_4862 < count__4837_4861)){
var protocol_4863 = chunk__4836_4860.cljs$core$IIndexed$_nth$arity$2(null,i__4838_4862);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_4863)),"}");


var G__4864 = seq__4835_4859;
var G__4865 = chunk__4836_4860;
var G__4866 = count__4837_4861;
var G__4867 = (i__4838_4862 + (1));
seq__4835_4859 = G__4864;
chunk__4836_4860 = G__4865;
count__4837_4861 = G__4866;
i__4838_4862 = G__4867;
continue;
} else {
var temp__5735__auto___4868 = cljs.core.seq(seq__4835_4859);
if(temp__5735__auto___4868){
var seq__4835_4869__$1 = temp__5735__auto___4868;
if(cljs.core.chunked_seq_QMARK_(seq__4835_4869__$1)){
var c__4556__auto___4870 = cljs.core.chunk_first(seq__4835_4869__$1);
var G__4871 = cljs.core.chunk_rest(seq__4835_4869__$1);
var G__4872 = c__4556__auto___4870;
var G__4873 = cljs.core.count(c__4556__auto___4870);
var G__4874 = (0);
seq__4835_4859 = G__4871;
chunk__4836_4860 = G__4872;
count__4837_4861 = G__4873;
i__4838_4862 = G__4874;
continue;
} else {
var protocol_4875 = cljs.core.first(seq__4835_4869__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_4875)),"}");


var G__4876 = cljs.core.next(seq__4835_4869__$1);
var G__4877 = null;
var G__4878 = (0);
var G__4879 = (0);
seq__4835_4859 = G__4876;
chunk__4836_4860 = G__4877;
count__4837_4861 = G__4878;
i__4838_4862 = G__4879;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__4839_4880 = cljs.core.seq(fields__$1);
var chunk__4840_4881 = null;
var count__4841_4882 = (0);
var i__4842_4883 = (0);
while(true){
if((i__4842_4883 < count__4841_4882)){
var fld_4884 = chunk__4840_4881.cljs$core$IIndexed$_nth$arity$2(null,i__4842_4883);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_4884," = ",fld_4884,";");


var G__4885 = seq__4839_4880;
var G__4886 = chunk__4840_4881;
var G__4887 = count__4841_4882;
var G__4888 = (i__4842_4883 + (1));
seq__4839_4880 = G__4885;
chunk__4840_4881 = G__4886;
count__4841_4882 = G__4887;
i__4842_4883 = G__4888;
continue;
} else {
var temp__5735__auto___4889 = cljs.core.seq(seq__4839_4880);
if(temp__5735__auto___4889){
var seq__4839_4890__$1 = temp__5735__auto___4889;
if(cljs.core.chunked_seq_QMARK_(seq__4839_4890__$1)){
var c__4556__auto___4891 = cljs.core.chunk_first(seq__4839_4890__$1);
var G__4892 = cljs.core.chunk_rest(seq__4839_4890__$1);
var G__4893 = c__4556__auto___4891;
var G__4894 = cljs.core.count(c__4556__auto___4891);
var G__4895 = (0);
seq__4839_4880 = G__4892;
chunk__4840_4881 = G__4893;
count__4841_4882 = G__4894;
i__4842_4883 = G__4895;
continue;
} else {
var fld_4896 = cljs.core.first(seq__4839_4890__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_4896," = ",fld_4896,";");


var G__4897 = cljs.core.next(seq__4839_4890__$1);
var G__4898 = null;
var G__4899 = (0);
var G__4900 = (0);
seq__4839_4880 = G__4897;
chunk__4840_4881 = G__4898;
count__4841_4882 = G__4899;
i__4842_4883 = G__4900;
continue;
}
} else {
}
}
break;
}

var seq__4843_4901 = cljs.core.seq(pmasks);
var chunk__4844_4902 = null;
var count__4845_4903 = (0);
var i__4846_4904 = (0);
while(true){
if((i__4846_4904 < count__4845_4903)){
var vec__4853_4905 = chunk__4844_4902.cljs$core$IIndexed$_nth$arity$2(null,i__4846_4904);
var pno_4906 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4853_4905,(0),null);
var pmask_4907 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4853_4905,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_4906,"$ = ",pmask_4907,";");


var G__4908 = seq__4843_4901;
var G__4909 = chunk__4844_4902;
var G__4910 = count__4845_4903;
var G__4911 = (i__4846_4904 + (1));
seq__4843_4901 = G__4908;
chunk__4844_4902 = G__4909;
count__4845_4903 = G__4910;
i__4846_4904 = G__4911;
continue;
} else {
var temp__5735__auto___4912 = cljs.core.seq(seq__4843_4901);
if(temp__5735__auto___4912){
var seq__4843_4913__$1 = temp__5735__auto___4912;
if(cljs.core.chunked_seq_QMARK_(seq__4843_4913__$1)){
var c__4556__auto___4914 = cljs.core.chunk_first(seq__4843_4913__$1);
var G__4915 = cljs.core.chunk_rest(seq__4843_4913__$1);
var G__4916 = c__4556__auto___4914;
var G__4917 = cljs.core.count(c__4556__auto___4914);
var G__4918 = (0);
seq__4843_4901 = G__4915;
chunk__4844_4902 = G__4916;
count__4845_4903 = G__4917;
i__4846_4904 = G__4918;
continue;
} else {
var vec__4856_4919 = cljs.core.first(seq__4843_4913__$1);
var pno_4920 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4856_4919,(0),null);
var pmask_4921 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4856_4919,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_4920,"$ = ",pmask_4921,";");


var G__4922 = cljs.core.next(seq__4843_4913__$1);
var G__4923 = null;
var G__4924 = (0);
var G__4925 = (0);
seq__4843_4901 = G__4922;
chunk__4844_4902 = G__4923;
count__4845_4903 = G__4924;
i__4846_4904 = G__4925;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"defrecord","defrecord",-1367493418),(function (p__4926){
var map__4927 = p__4926;
var map__4927__$1 = (((((!((map__4927 == null))))?(((((map__4927.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4927.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__4927):map__4927);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4927__$1,new cljs.core.Keyword(null,"t","t",-1397832519));
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4927__$1,new cljs.core.Keyword(null,"fields","fields",-1932066230));
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4927__$1,new cljs.core.Keyword(null,"pmasks","pmasks",-871416698));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4927__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4927__$1,new cljs.core.Keyword(null,"protocols","protocols",-5615896));
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"__meta","__meta",-946752628,null),new cljs.core.Symbol(null,"__extmap","__extmap",-1435580931,null),new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null)], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__4929_4953 = cljs.core.seq(protocols);
var chunk__4930_4954 = null;
var count__4931_4955 = (0);
var i__4932_4956 = (0);
while(true){
if((i__4932_4956 < count__4931_4955)){
var protocol_4957 = chunk__4930_4954.cljs$core$IIndexed$_nth$arity$2(null,i__4932_4956);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_4957)),"}");


var G__4958 = seq__4929_4953;
var G__4959 = chunk__4930_4954;
var G__4960 = count__4931_4955;
var G__4961 = (i__4932_4956 + (1));
seq__4929_4953 = G__4958;
chunk__4930_4954 = G__4959;
count__4931_4955 = G__4960;
i__4932_4956 = G__4961;
continue;
} else {
var temp__5735__auto___4962 = cljs.core.seq(seq__4929_4953);
if(temp__5735__auto___4962){
var seq__4929_4963__$1 = temp__5735__auto___4962;
if(cljs.core.chunked_seq_QMARK_(seq__4929_4963__$1)){
var c__4556__auto___4964 = cljs.core.chunk_first(seq__4929_4963__$1);
var G__4965 = cljs.core.chunk_rest(seq__4929_4963__$1);
var G__4966 = c__4556__auto___4964;
var G__4967 = cljs.core.count(c__4556__auto___4964);
var G__4968 = (0);
seq__4929_4953 = G__4965;
chunk__4930_4954 = G__4966;
count__4931_4955 = G__4967;
i__4932_4956 = G__4968;
continue;
} else {
var protocol_4969 = cljs.core.first(seq__4929_4963__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_4969)),"}");


var G__4970 = cljs.core.next(seq__4929_4963__$1);
var G__4971 = null;
var G__4972 = (0);
var G__4973 = (0);
seq__4929_4953 = G__4970;
chunk__4930_4954 = G__4971;
count__4931_4955 = G__4972;
i__4932_4956 = G__4973;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__4933_4974 = cljs.core.seq(fields__$1);
var chunk__4934_4975 = null;
var count__4935_4976 = (0);
var i__4936_4977 = (0);
while(true){
if((i__4936_4977 < count__4935_4976)){
var fld_4978 = chunk__4934_4975.cljs$core$IIndexed$_nth$arity$2(null,i__4936_4977);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_4978," = ",fld_4978,";");


var G__4979 = seq__4933_4974;
var G__4980 = chunk__4934_4975;
var G__4981 = count__4935_4976;
var G__4982 = (i__4936_4977 + (1));
seq__4933_4974 = G__4979;
chunk__4934_4975 = G__4980;
count__4935_4976 = G__4981;
i__4936_4977 = G__4982;
continue;
} else {
var temp__5735__auto___4983 = cljs.core.seq(seq__4933_4974);
if(temp__5735__auto___4983){
var seq__4933_4984__$1 = temp__5735__auto___4983;
if(cljs.core.chunked_seq_QMARK_(seq__4933_4984__$1)){
var c__4556__auto___4985 = cljs.core.chunk_first(seq__4933_4984__$1);
var G__4986 = cljs.core.chunk_rest(seq__4933_4984__$1);
var G__4987 = c__4556__auto___4985;
var G__4988 = cljs.core.count(c__4556__auto___4985);
var G__4989 = (0);
seq__4933_4974 = G__4986;
chunk__4934_4975 = G__4987;
count__4935_4976 = G__4988;
i__4936_4977 = G__4989;
continue;
} else {
var fld_4990 = cljs.core.first(seq__4933_4984__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_4990," = ",fld_4990,";");


var G__4991 = cljs.core.next(seq__4933_4984__$1);
var G__4992 = null;
var G__4993 = (0);
var G__4994 = (0);
seq__4933_4974 = G__4991;
chunk__4934_4975 = G__4992;
count__4935_4976 = G__4993;
i__4936_4977 = G__4994;
continue;
}
} else {
}
}
break;
}

var seq__4937_4995 = cljs.core.seq(pmasks);
var chunk__4938_4996 = null;
var count__4939_4997 = (0);
var i__4940_4998 = (0);
while(true){
if((i__4940_4998 < count__4939_4997)){
var vec__4947_4999 = chunk__4938_4996.cljs$core$IIndexed$_nth$arity$2(null,i__4940_4998);
var pno_5000 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4947_4999,(0),null);
var pmask_5001 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4947_4999,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_5000,"$ = ",pmask_5001,";");


var G__5002 = seq__4937_4995;
var G__5003 = chunk__4938_4996;
var G__5004 = count__4939_4997;
var G__5005 = (i__4940_4998 + (1));
seq__4937_4995 = G__5002;
chunk__4938_4996 = G__5003;
count__4939_4997 = G__5004;
i__4940_4998 = G__5005;
continue;
} else {
var temp__5735__auto___5006 = cljs.core.seq(seq__4937_4995);
if(temp__5735__auto___5006){
var seq__4937_5007__$1 = temp__5735__auto___5006;
if(cljs.core.chunked_seq_QMARK_(seq__4937_5007__$1)){
var c__4556__auto___5008 = cljs.core.chunk_first(seq__4937_5007__$1);
var G__5009 = cljs.core.chunk_rest(seq__4937_5007__$1);
var G__5010 = c__4556__auto___5008;
var G__5011 = cljs.core.count(c__4556__auto___5008);
var G__5012 = (0);
seq__4937_4995 = G__5009;
chunk__4938_4996 = G__5010;
count__4939_4997 = G__5011;
i__4940_4998 = G__5012;
continue;
} else {
var vec__4950_5013 = cljs.core.first(seq__4937_5007__$1);
var pno_5014 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4950_5013,(0),null);
var pmask_5015 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4950_5013,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_5014,"$ = ",pmask_5015,";");


var G__5016 = cljs.core.next(seq__4937_5007__$1);
var G__5017 = null;
var G__5018 = (0);
var G__5019 = (0);
seq__4937_4995 = G__5016;
chunk__4938_4996 = G__5017;
count__4939_4997 = G__5018;
i__4940_4998 = G__5019;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__5020){
var map__5021 = p__5020;
var map__5021__$1 = (((((!((map__5021 == null))))?(((((map__5021.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5021.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__5021):map__5021);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5021__$1,new cljs.core.Keyword(null,"target","target",253001721));
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5021__$1,new cljs.core.Keyword(null,"field","field",-1302436500));
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5021__$1,new cljs.core.Keyword(null,"method","method",55703592));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5021__$1,new cljs.core.Keyword(null,"args","args",1315556576));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5021__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var env__3768__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-field","host-field",-72662140),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"host-call","host-call",1059629755),(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"js","js",1768080579),(function (p__5023){
var map__5024 = p__5023;
var map__5024__$1 = (((((!((map__5024 == null))))?(((((map__5024.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5024.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__5024):map__5024);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5024__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5024__$1,new cljs.core.Keyword(null,"env","env",-1815813235));
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5024__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5024__$1,new cljs.core.Keyword(null,"segs","segs",-1940299576));
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__5024__$1,new cljs.core.Keyword(null,"args","args",1315556576));
if(cljs.core.truth_((function (){var and__4115__auto__ = code;
if(cljs.core.truth_(and__4115__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__4115__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__3768__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"return","return",-1891502105),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"expr","expr",745722291),new cljs.core.Keyword(null,"context","context",-830191113).cljs$core$IFn$_invoke$arity$1(env__3768__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__5030 = cljs.core.seq(table);
var chunk__5031 = null;
var count__5032 = (0);
var i__5033 = (0);
while(true){
if((i__5033 < count__5032)){
var vec__5040 = chunk__5031.cljs$core$IIndexed$_nth$arity$2(null,i__5033);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5040,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5040,(1),null);
var ns_5046 = cljs.core.namespace(sym);
var name_5047 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__5048 = seq__5030;
var G__5049 = chunk__5031;
var G__5050 = count__5032;
var G__5051 = (i__5033 + (1));
seq__5030 = G__5048;
chunk__5031 = G__5049;
count__5032 = G__5050;
i__5033 = G__5051;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__5030);
if(temp__5735__auto__){
var seq__5030__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__5030__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__5030__$1);
var G__5052 = cljs.core.chunk_rest(seq__5030__$1);
var G__5053 = c__4556__auto__;
var G__5054 = cljs.core.count(c__4556__auto__);
var G__5055 = (0);
seq__5030 = G__5052;
chunk__5031 = G__5053;
count__5032 = G__5054;
i__5033 = G__5055;
continue;
} else {
var vec__5043 = cljs.core.first(seq__5030__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5043,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5043,(1),null);
var ns_5056 = cljs.core.namespace(sym);
var name_5057 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword(null,"invalid-constant-type","invalid-constant-type",1294847471),new cljs.core.Keyword("clojure.error","phase","clojure.error/phase",275140358),new cljs.core.Keyword(null,"compilation","compilation",-1328774561)], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__5058 = cljs.core.next(seq__5030__$1);
var G__5059 = null;
var G__5060 = (0);
var G__5061 = (0);
seq__5030 = G__5058;
chunk__5031 = G__5059;
count__5032 = G__5060;
i__5033 = G__5061;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__5063 = arguments.length;
switch (G__5063) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_5068 = cljs.core.first(ks);
var vec__5064_5069 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_5068);
var top_5070 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5064_5069,(0),null);
var prefix_SINGLEQUOTE__5071 = vec__5064_5069;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.Symbol(null,"prototype","prototype",519166522,null),k_5068)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__5071) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_5070)) || (cljs.core.contains_QMARK_(known_externs,top_5070)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__5071)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_5070);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__5071)),";");
}
} else {
}

var m_5072 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_5068);
if(cljs.core.empty_QMARK_(m_5072)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__5071,m_5072,top_level,known_externs);
}

var G__5073 = cljs.core.next(ks);
ks = G__5073;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

