// Compiled by ClojureScript 1.10.773 {:static-fns true, :optimize-constants false, :target :nodejs}
goog.provide('fluree.db.api.query');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.query.range');
goog.require('fluree.db.query.block');
goog.require('fluree.db.session');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.permissions');
goog.require('fluree.db.auth');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
 * Returns keyword of query type by inspecting flureeQL query.
 * 
 *   Query types are:
 *  :standard - basic or analytical query
 *  :multi - multi-query
 *  :block - block query
 *  :history - history query
 */
fluree.db.api.query.query_type = (function fluree$db$api$query$query_type(flureeQL){
if(cljs.core.truth_(new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectOne","selectOne",1588429876).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"history","history",-247395220).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"history","history",-247395220);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"standard","standard",-1769206695);
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL))){
return new cljs.core.Keyword(null,"block","block",664686210);
} else {
return new cljs.core.Keyword(null,"multi","multi",-190293005);

}
}
}
}
}
}
});
fluree.db.api.query.db_ident_QMARK_ = (function fluree$db$api$query$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.api.query.isolate_ledger_id = (function fluree$db$api$query$isolate_ledger_id(dbid){
return cljs.core.re_find(/[a-z0-9]+\/[a-z0-9]+/,dbid);
});
/**
 * Returns a queryable database as a promise channel from the connection for the specified ledger.
 */
fluree.db.api.query.db = (function fluree$db$api$query$db(var_args){
var G__60627 = arguments.length;
switch (G__60627) {
case 2:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.db(conn,ledger,null);
}));

(fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__2901__auto___60808 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_60734){
var state_val_60735 = (state_60734[(1)]);
if((state_val_60735 === (7))){
var inst_60641 = (state_60734[(7)]);
var inst_60646 = inst_60641.cljs$lang$protocol_mask$partition0$;
var inst_60647 = (inst_60646 & (64));
var inst_60648 = inst_60641.cljs$core$ISeq$;
var inst_60649 = (cljs.core.PROTOCOL_SENTINEL === inst_60648);
var inst_60650 = ((inst_60647) || (inst_60649));
var state_60734__$1 = state_60734;
if(cljs.core.truth_(inst_60650)){
var statearr_60736_60809 = state_60734__$1;
(statearr_60736_60809[(1)] = (10));

} else {
var statearr_60737_60810 = state_60734__$1;
(statearr_60737_60810[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (20))){
var state_60734__$1 = state_60734;
var statearr_60738_60811 = state_60734__$1;
(statearr_60738_60811[(2)] = null);

(statearr_60738_60811[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (27))){
var inst_60689 = (state_60734[(8)]);
var state_60734__$1 = state_60734;
if(cljs.core.truth_(inst_60689)){
var statearr_60739_60812 = state_60734__$1;
(statearr_60739_60812[(1)] = (29));

} else {
var statearr_60740_60813 = state_60734__$1;
(statearr_60740_60813[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (1))){
var state_60734__$1 = state_60734;
var statearr_60741_60814 = state_60734__$1;
(statearr_60741_60814[(2)] = null);

(statearr_60741_60814[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (24))){
var inst_60665 = (state_60734[(9)]);
var inst_60679 = ["Auth id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_60665)," unknown."].join('');
var inst_60680 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60681 = [(401),new cljs.core.Keyword("db","invalid-auth","db/invalid-auth",-1361562568)];
var inst_60682 = cljs.core.PersistentHashMap.fromArrays(inst_60680,inst_60681);
var inst_60683 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60679,inst_60682);
var inst_60684 = (function(){throw inst_60683})();
var state_60734__$1 = state_60734;
var statearr_60742_60815 = state_60734__$1;
(statearr_60742_60815[(2)] = inst_60684);

(statearr_60742_60815[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (39))){
var inst_60711 = (state_60734[(2)]);
var inst_60712 = fluree.db.util.async.throw_err(inst_60711);
var state_60734__$1 = state_60734;
var statearr_60743_60816 = state_60734__$1;
(statearr_60743_60816[(2)] = inst_60712);

(statearr_60743_60816[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (46))){
var inst_60720 = (state_60734[(10)]);
var inst_60723 = (state_60734[(2)]);
var inst_60724 = fluree.db.util.async.throw_err(inst_60723);
var inst_60725 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_60720,new cljs.core.Keyword(null,"permissions","permissions",67803075),inst_60724);
var state_60734__$1 = state_60734;
var statearr_60744_60817 = state_60734__$1;
(statearr_60744_60817[(2)] = inst_60725);

(statearr_60744_60817[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (4))){
var inst_60628 = (state_60734[(2)]);
var inst_60629 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_60628);
var inst_60630 = cljs.core.async.close_BANG_(pc);
var state_60734__$1 = (function (){var statearr_60745 = state_60734;
(statearr_60745[(11)] = inst_60629);

return statearr_60745;
})();
var statearr_60746_60818 = state_60734__$1;
(statearr_60746_60818[(2)] = inst_60630);

(statearr_60746_60818[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (15))){
var inst_60665 = (state_60734[(9)]);
var inst_60662 = (state_60734[(2)]);
var inst_60663 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60662,new cljs.core.Keyword(null,"roles","roles",143379530));
var inst_60664 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60662,new cljs.core.Keyword(null,"user","user",1532431356));
var inst_60665__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60662,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_60666 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_60662,new cljs.core.Keyword(null,"block","block",664686210));
var state_60734__$1 = (function (){var statearr_60747 = state_60734;
(statearr_60747[(12)] = inst_60663);

(statearr_60747[(9)] = inst_60665__$1);

(statearr_60747[(13)] = inst_60664);

(statearr_60747[(14)] = inst_60666);

return statearr_60747;
})();
if(cljs.core.truth_(inst_60665__$1)){
var statearr_60748_60819 = state_60734__$1;
(statearr_60748_60819[(1)] = (16));

} else {
var statearr_60749_60820 = state_60734__$1;
(statearr_60749_60820[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (21))){
var inst_60663 = (state_60734[(12)]);
var inst_60689 = (state_60734[(2)]);
var state_60734__$1 = (function (){var statearr_60750 = state_60734;
(statearr_60750[(8)] = inst_60689);

return statearr_60750;
})();
if(cljs.core.truth_(inst_60663)){
var statearr_60751_60821 = state_60734__$1;
(statearr_60751_60821[(1)] = (26));

} else {
var statearr_60752_60822 = state_60734__$1;
(statearr_60752_60822[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (31))){
var inst_60699 = (state_60734[(2)]);
var state_60734__$1 = state_60734;
var statearr_60753_60823 = state_60734__$1;
(statearr_60753_60823[(2)] = inst_60699);

(statearr_60753_60823[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (32))){
var inst_60695 = (state_60734[(2)]);
var inst_60696 = fluree.db.util.async.throw_err(inst_60695);
var state_60734__$1 = state_60734;
var statearr_60754_60824 = state_60734__$1;
(statearr_60754_60824[(2)] = inst_60696);

(statearr_60754_60824[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (40))){
var inst_60715 = (state_60734[(15)]);
var inst_60665 = (state_60734[(9)]);
var inst_60717 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_60715,new cljs.core.Keyword(null,"auth","auth",1389754926),inst_60665);
var state_60734__$1 = state_60734;
var statearr_60755_60825 = state_60734__$1;
(statearr_60755_60825[(2)] = inst_60717);

(statearr_60755_60825[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (33))){
var inst_60640 = (state_60734[(16)]);
var inst_60701 = (state_60734[(17)]);
var inst_60703 = fluree.db.permissions.permission_map(inst_60640,inst_60701,new cljs.core.Keyword(null,"query","query",-1288509510));
var state_60734__$1 = state_60734;
var statearr_60756_60826 = state_60734__$1;
(statearr_60756_60826[(2)] = inst_60703);

(statearr_60756_60826[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (13))){
var inst_60641 = (state_60734[(7)]);
var inst_60659 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_60641);
var state_60734__$1 = state_60734;
var statearr_60757_60827 = state_60734__$1;
(statearr_60757_60827[(2)] = inst_60659);

(statearr_60757_60827[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (22))){
var inst_60676 = (state_60734[(18)]);
var inst_60675 = (state_60734[(2)]);
var inst_60676__$1 = fluree.db.util.async.throw_err(inst_60675);
var state_60734__$1 = (function (){var statearr_60758 = state_60734;
(statearr_60758[(18)] = inst_60676__$1);

return statearr_60758;
})();
if(cljs.core.truth_(inst_60676__$1)){
var statearr_60759_60828 = state_60734__$1;
(statearr_60759_60828[(1)] = (23));

} else {
var statearr_60760_60829 = state_60734__$1;
(statearr_60760_60829[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (36))){
var inst_60640 = (state_60734[(16)]);
var inst_60708 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(opts);
var inst_60709 = fluree.db.time_travel.as_of_block(inst_60640,inst_60708);
var state_60734__$1 = state_60734;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60734__$1,(39),inst_60709);
} else {
if((state_val_60735 === (41))){
var inst_60715 = (state_60734[(15)]);
var state_60734__$1 = state_60734;
var statearr_60761_60830 = state_60734__$1;
(statearr_60761_60830[(2)] = inst_60715);

(statearr_60761_60830[(1)] = (42));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (43))){
var inst_60706 = (state_60734[(19)]);
var state_60734__$1 = state_60734;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60734__$1,(46),inst_60706);
} else {
if((state_val_60735 === (29))){
var inst_60640 = (state_60734[(16)]);
var inst_60689 = (state_60734[(8)]);
var inst_60693 = fluree.db.auth.roles(inst_60640,inst_60689);
var state_60734__$1 = state_60734;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60734__$1,(32),inst_60693);
} else {
if((state_val_60735 === (44))){
var inst_60720 = (state_60734[(10)]);
var state_60734__$1 = state_60734;
var statearr_60762_60831 = state_60734__$1;
(statearr_60762_60831[(2)] = inst_60720);

(statearr_60762_60831[(1)] = (45));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (6))){
var inst_60641 = (state_60734[(7)]);
var inst_60639 = (state_60734[(2)]);
var inst_60640 = fluree.db.util.async.throw_err(inst_60639);
var inst_60641__$1 = opts;
var inst_60643 = (inst_60641__$1 == null);
var inst_60644 = cljs.core.not(inst_60643);
var state_60734__$1 = (function (){var statearr_60763 = state_60734;
(statearr_60763[(16)] = inst_60640);

(statearr_60763[(7)] = inst_60641__$1);

return statearr_60763;
})();
if(inst_60644){
var statearr_60764_60832 = state_60734__$1;
(statearr_60764_60832[(1)] = (7));

} else {
var statearr_60765_60833 = state_60734__$1;
(statearr_60765_60833[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (28))){
var inst_60701 = (state_60734[(17)]);
var inst_60701__$1 = (state_60734[(2)]);
var state_60734__$1 = (function (){var statearr_60766 = state_60734;
(statearr_60766[(17)] = inst_60701__$1);

return statearr_60766;
})();
if(cljs.core.truth_(inst_60701__$1)){
var statearr_60767_60834 = state_60734__$1;
(statearr_60767_60834[(1)] = (33));

} else {
var statearr_60768_60835 = state_60734__$1;
(statearr_60768_60835[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (25))){
var inst_60686 = (state_60734[(2)]);
var state_60734__$1 = state_60734;
var statearr_60769_60836 = state_60734__$1;
(statearr_60769_60836[(2)] = inst_60686);

(statearr_60769_60836[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (34))){
var state_60734__$1 = state_60734;
var statearr_60770_60837 = state_60734__$1;
(statearr_60770_60837[(2)] = null);

(statearr_60770_60837[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (17))){
var inst_60665 = (state_60734[(9)]);
var state_60734__$1 = state_60734;
var statearr_60771_60838 = state_60734__$1;
(statearr_60771_60838[(2)] = inst_60665);

(statearr_60771_60838[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (3))){
var inst_60732 = (state_60734[(2)]);
var state_60734__$1 = state_60734;
return cljs.core.async.impl.ioc_helpers.return_chan(state_60734__$1,inst_60732);
} else {
if((state_val_60735 === (12))){
var inst_60654 = (state_60734[(2)]);
var state_60734__$1 = state_60734;
var statearr_60772_60839 = state_60734__$1;
(statearr_60772_60839[(2)] = inst_60654);

(statearr_60772_60839[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (2))){
var _ = (function (){var statearr_60773 = state_60734;
(statearr_60773[(4)] = cljs.core.cons((5),(state_60734[(4)])));

return statearr_60773;
})();
var inst_60637 = fluree.db.session.db(conn,ledger,null);
var state_60734__$1 = state_60734;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60734__$1,(6),inst_60637);
} else {
if((state_val_60735 === (23))){
var inst_60676 = (state_60734[(18)]);
var state_60734__$1 = state_60734;
var statearr_60774_60840 = state_60734__$1;
(statearr_60774_60840[(2)] = inst_60676);

(statearr_60774_60840[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (35))){
var inst_60666 = (state_60734[(14)]);
var inst_60706 = (state_60734[(2)]);
var state_60734__$1 = (function (){var statearr_60775 = state_60734;
(statearr_60775[(19)] = inst_60706);

return statearr_60775;
})();
if(cljs.core.truth_(inst_60666)){
var statearr_60776_60841 = state_60734__$1;
(statearr_60776_60841[(1)] = (36));

} else {
var statearr_60777_60842 = state_60734__$1;
(statearr_60777_60842[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (19))){
var inst_60640 = (state_60734[(16)]);
var inst_60665 = (state_60734[(9)]);
var inst_60673 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_60640,inst_60665);
var state_60734__$1 = state_60734;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60734__$1,(22),inst_60673);
} else {
if((state_val_60735 === (11))){
var state_60734__$1 = state_60734;
var statearr_60779_60843 = state_60734__$1;
(statearr_60779_60843[(2)] = false);

(statearr_60779_60843[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (9))){
var inst_60657 = (state_60734[(2)]);
var state_60734__$1 = state_60734;
if(cljs.core.truth_(inst_60657)){
var statearr_60780_60844 = state_60734__$1;
(statearr_60780_60844[(1)] = (13));

} else {
var statearr_60781_60845 = state_60734__$1;
(statearr_60781_60845[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (5))){
var _ = (function (){var statearr_60782 = state_60734;
(statearr_60782[(4)] = cljs.core.rest((state_60734[(4)])));

return statearr_60782;
})();
var state_60734__$1 = state_60734;
var ex60778 = (state_60734__$1[(2)]);
var statearr_60783_60846 = state_60734__$1;
(statearr_60783_60846[(5)] = ex60778);


var statearr_60784_60847 = state_60734__$1;
(statearr_60784_60847[(1)] = (4));

(statearr_60784_60847[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (14))){
var inst_60641 = (state_60734[(7)]);
var state_60734__$1 = state_60734;
var statearr_60785_60848 = state_60734__$1;
(statearr_60785_60848[(2)] = inst_60641);

(statearr_60785_60848[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (45))){
var inst_60728 = (state_60734[(2)]);
var inst_60729 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_60728);
var _ = (function (){var statearr_60786 = state_60734;
(statearr_60786[(4)] = cljs.core.rest((state_60734[(4)])));

return statearr_60786;
})();
var state_60734__$1 = state_60734;
var statearr_60787_60849 = state_60734__$1;
(statearr_60787_60849[(2)] = inst_60729);

(statearr_60787_60849[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (26))){
var inst_60663 = (state_60734[(12)]);
var state_60734__$1 = state_60734;
var statearr_60788_60850 = state_60734__$1;
(statearr_60788_60850[(2)] = inst_60663);

(statearr_60788_60850[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (16))){
var inst_60665 = (state_60734[(9)]);
var inst_60668 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_60665);
var state_60734__$1 = state_60734;
var statearr_60789_60851 = state_60734__$1;
(statearr_60789_60851[(2)] = inst_60668);

(statearr_60789_60851[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (38))){
var inst_60665 = (state_60734[(9)]);
var inst_60715 = (state_60734[(2)]);
var state_60734__$1 = (function (){var statearr_60790 = state_60734;
(statearr_60790[(15)] = inst_60715);

return statearr_60790;
})();
if(cljs.core.truth_(inst_60665)){
var statearr_60791_60852 = state_60734__$1;
(statearr_60791_60852[(1)] = (40));

} else {
var statearr_60792_60853 = state_60734__$1;
(statearr_60792_60853[(1)] = (41));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (30))){
var state_60734__$1 = state_60734;
var statearr_60793_60854 = state_60734__$1;
(statearr_60793_60854[(2)] = null);

(statearr_60793_60854[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (10))){
var state_60734__$1 = state_60734;
var statearr_60794_60855 = state_60734__$1;
(statearr_60794_60855[(2)] = true);

(statearr_60794_60855[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (18))){
var inst_60671 = (state_60734[(2)]);
var state_60734__$1 = state_60734;
if(cljs.core.truth_(inst_60671)){
var statearr_60795_60856 = state_60734__$1;
(statearr_60795_60856[(1)] = (19));

} else {
var statearr_60796_60857 = state_60734__$1;
(statearr_60796_60857[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (42))){
var inst_60701 = (state_60734[(17)]);
var inst_60720 = (state_60734[(2)]);
var state_60734__$1 = (function (){var statearr_60797 = state_60734;
(statearr_60797[(10)] = inst_60720);

return statearr_60797;
})();
if(cljs.core.truth_(inst_60701)){
var statearr_60798_60858 = state_60734__$1;
(statearr_60798_60858[(1)] = (43));

} else {
var statearr_60799_60859 = state_60734__$1;
(statearr_60799_60859[(1)] = (44));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (37))){
var inst_60640 = (state_60734[(16)]);
var state_60734__$1 = state_60734;
var statearr_60800_60860 = state_60734__$1;
(statearr_60800_60860[(2)] = inst_60640);

(statearr_60800_60860[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_60735 === (8))){
var state_60734__$1 = state_60734;
var statearr_60801_60861 = state_60734__$1;
(statearr_60801_60861[(2)] = false);

(statearr_60801_60861[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$state_machine__2879__auto__ = null;
var fluree$db$api$query$state_machine__2879__auto____0 = (function (){
var statearr_60802 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_60802[(0)] = fluree$db$api$query$state_machine__2879__auto__);

(statearr_60802[(1)] = (1));

return statearr_60802;
});
var fluree$db$api$query$state_machine__2879__auto____1 = (function (state_60734){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_60734);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e60803){var ex__2882__auto__ = e60803;
var statearr_60804_60862 = state_60734;
(statearr_60804_60862[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_60734[(4)]))){
var statearr_60805_60863 = state_60734;
(statearr_60805_60863[(1)] = cljs.core.first((state_60734[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__60864 = state_60734;
state_60734 = G__60864;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$state_machine__2879__auto__ = function(state_60734){
switch(arguments.length){
case 0:
return fluree$db$api$query$state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$state_machine__2879__auto____1.call(this,state_60734);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$state_machine__2879__auto____0;
fluree$db$api$query$state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$state_machine__2879__auto____1;
return fluree$db$api$query$state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_60806 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_60806[(6)] = c__2901__auto___60808);

return statearr_60806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));


return pc;
}));

(fluree.db.api.query.db.cljs$lang$maxFixedArity = 3);

fluree.db.api.query.get_sources = (function fluree$db$api$query$get_sources(conn,network,auth,prefixes){
return cljs.core.reduce_kv((function (acc,key,val){
if(cljs.core.truth_(cljs.core.re_matches(/[a-z]+/,fluree.db.util.core.keyword__GT_str(key)))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Source name must be only lowercase letters. Provided: ",fluree.db.util.core.keyword__GT_str(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null));
}

var db_ident_QMARK_ = fluree.db.api.query.db_ident_QMARK_(val);
if(db_ident_QMARK_){
var ledger = fluree.db.api.query.isolate_ledger_id(val);
var opts = (cljs.core.truth_(auth)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"auth","auth",1389754926),auth], null):cljs.core.PersistentArrayMap.EMPTY);
var db = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,val,db);
} else {
return acc;
}
}),cljs.core.PersistentArrayMap.EMPTY,prefixes);
});
fluree.db.api.query.resolve_block_range = (function fluree$db$api$query$resolve_block_range(db,query_map){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_61002){
var state_val_61003 = (state_61002[(1)]);
if((state_val_61003 === (7))){
var inst_60885 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60886 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60887 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60888 = [inst_60886,inst_60887];
var inst_60889 = (new cljs.core.PersistentVector(null,2,(5),inst_60885,inst_60888,null));
var state_61002__$1 = state_61002;
var statearr_61004_61070 = state_61002__$1;
(statearr_61004_61070[(2)] = inst_60889);

(statearr_61004_61070[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (20))){
var inst_60915 = (state_61002[(7)]);
var state_61002__$1 = state_61002;
var statearr_61005_61071 = state_61002__$1;
(statearr_61005_61071[(2)] = inst_60915);

(statearr_61005_61071[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (27))){
var state_61002__$1 = state_61002;
var statearr_61006_61072 = state_61002__$1;
(statearr_61006_61072[(1)] = (29));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (1))){
var state_61002__$1 = state_61002;
var statearr_61008_61073 = state_61002__$1;
(statearr_61008_61073[(2)] = null);

(statearr_61008_61073[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (24))){
var inst_60914 = (state_61002[(8)]);
var state_61002__$1 = state_61002;
if(cljs.core.truth_(inst_60914)){
var statearr_61009_61074 = state_61002__$1;
(statearr_61009_61074[(1)] = (26));

} else {
var statearr_61010_61075 = state_61002__$1;
(statearr_61010_61075[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (39))){
var inst_60989 = (state_61002[(9)]);
var state_61002__$1 = state_61002;
var statearr_61011_61076 = state_61002__$1;
(statearr_61011_61076[(2)] = inst_60989);

(statearr_61011_61076[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (4))){
var inst_60865 = (state_61002[(2)]);
var state_61002__$1 = state_61002;
var statearr_61012_61077 = state_61002__$1;
(statearr_61012_61077[(2)] = inst_60865);

(statearr_61012_61077[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (15))){
var inst_60899 = (state_61002[(10)]);
var inst_60894 = (state_61002[(11)]);
var inst_60908 = (state_61002[(2)]);
var inst_60909 = [inst_60899,inst_60908];
var inst_60910 = (new cljs.core.PersistentVector(null,2,(5),inst_60894,inst_60909,null));
var state_61002__$1 = state_61002;
var statearr_61013_61078 = state_61002__$1;
(statearr_61013_61078[(2)] = inst_60910);

(statearr_61013_61078[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (21))){
var inst_60914 = (state_61002[(8)]);
var state_61002__$1 = state_61002;
var statearr_61014_61079 = state_61002__$1;
(statearr_61014_61079[(2)] = inst_60914);

(statearr_61014_61079[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (31))){
var inst_60955 = (state_61002[(2)]);
var state_61002__$1 = state_61002;
var statearr_61015_61080 = state_61002__$1;
(statearr_61015_61080[(2)] = inst_60955);

(statearr_61015_61080[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (32))){
var inst_60891 = (state_61002[(12)]);
var inst_60967 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60891], 0));
var inst_60968 = ["Invalid block range provided: ",inst_60967].join('');
var inst_60969 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60970 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60971 = cljs.core.PersistentHashMap.fromArrays(inst_60969,inst_60970);
var inst_60972 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60968,inst_60971);
var inst_60973 = (function(){throw inst_60972})();
var state_61002__$1 = state_61002;
var statearr_61016_61081 = state_61002__$1;
(statearr_61016_61081[(2)] = inst_60973);

(statearr_61016_61081[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (40))){
var inst_60988 = (state_61002[(13)]);
var inst_60994 = (state_61002[(2)]);
var inst_60995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60996 = [inst_60988,inst_60994];
var inst_60997 = (new cljs.core.PersistentVector(null,2,(5),inst_60995,inst_60996,null));
var _ = (function (){var statearr_61017 = state_61002;
(statearr_61017[(4)] = cljs.core.rest((state_61002[(4)])));

return statearr_61017;
})();
var state_61002__$1 = state_61002;
var statearr_61018_61082 = state_61002__$1;
(statearr_61018_61082[(2)] = inst_60997);

(statearr_61018_61082[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (33))){
var state_61002__$1 = state_61002;
var statearr_61019_61083 = state_61002__$1;
(statearr_61019_61083[(2)] = null);

(statearr_61019_61083[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (13))){
var inst_60900 = (state_61002[(14)]);
var inst_60902 = fluree.db.time_travel.block_to_int_format(db,inst_60900);
var state_61002__$1 = state_61002;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61002__$1,(16),inst_60902);
} else {
if((state_val_61003 === (22))){
var inst_60933 = (state_61002[(2)]);
var state_61002__$1 = state_61002;
if(cljs.core.truth_(inst_60933)){
var statearr_61020_61084 = state_61002__$1;
(statearr_61020_61084[(1)] = (23));

} else {
var statearr_61021_61085 = state_61002__$1;
(statearr_61021_61085[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (36))){
var inst_60960 = (state_61002[(15)]);
var inst_60961 = (state_61002[(16)]);
var inst_60983 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60984 = [inst_60960,inst_60961];
var inst_60985 = (new cljs.core.PersistentVector(null,2,(5),inst_60983,inst_60984,null));
var state_61002__$1 = state_61002;
var statearr_61022_61086 = state_61002__$1;
(statearr_61022_61086[(2)] = inst_60985);

(statearr_61022_61086[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (29))){
var inst_60891 = (state_61002[(12)]);
var inst_60946 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60891], 0));
var inst_60947 = ["Invalid block range provided: ",inst_60946].join('');
var inst_60948 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60949 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60950 = cljs.core.PersistentHashMap.fromArrays(inst_60948,inst_60949);
var inst_60951 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60947,inst_60950);
var inst_60952 = (function(){throw inst_60951})();
var state_61002__$1 = state_61002;
var statearr_61023_61087 = state_61002__$1;
(statearr_61023_61087[(2)] = inst_60952);

(statearr_61023_61087[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (6))){
var inst_60883 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var state_61002__$1 = state_61002;
var statearr_61024_61088 = state_61002__$1;
(statearr_61024_61088[(2)] = inst_60883);

(statearr_61024_61088[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (28))){
var inst_60957 = (state_61002[(2)]);
var state_61002__$1 = state_61002;
var statearr_61025_61089 = state_61002__$1;
(statearr_61025_61089[(2)] = inst_60957);

(statearr_61025_61089[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (25))){
var inst_60960 = (state_61002[(15)]);
var inst_60961 = (state_61002[(16)]);
var inst_60959 = (state_61002[(2)]);
var inst_60960__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60959,(0),null);
var inst_60961__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60959,(1),null);
var inst_60962 = cljs.core.pos_int_QMARK_(inst_60960__$1);
var inst_60963 = cljs.core.pos_int_QMARK_(inst_60961__$1);
var inst_60964 = ((inst_60962) && (inst_60963));
var inst_60965 = cljs.core.not(inst_60964);
var state_61002__$1 = (function (){var statearr_61026 = state_61002;
(statearr_61026[(15)] = inst_60960__$1);

(statearr_61026[(16)] = inst_60961__$1);

return statearr_61026;
})();
if(inst_60965){
var statearr_61027_61090 = state_61002__$1;
(statearr_61027_61090[(1)] = (32));

} else {
var statearr_61028_61091 = state_61002__$1;
(statearr_61028_61091[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (34))){
var inst_60960 = (state_61002[(15)]);
var inst_60961 = (state_61002[(16)]);
var inst_60976 = (state_61002[(2)]);
var inst_60977 = (inst_60961 < inst_60960);
var state_61002__$1 = (function (){var statearr_61029 = state_61002;
(statearr_61029[(17)] = inst_60976);

return statearr_61029;
})();
if(cljs.core.truth_(inst_60977)){
var statearr_61030_61092 = state_61002__$1;
(statearr_61030_61092[(1)] = (35));

} else {
var statearr_61031_61093 = state_61002__$1;
(statearr_61031_61093[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (17))){
var inst_60914 = (state_61002[(8)]);
var inst_60916 = (state_61002[(18)]);
var inst_60919 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60914], 0));
var inst_60920 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_60916], 0));
var inst_60921 = ["Start block is out of range for this ledger. Start block provided: ",inst_60919,". Database block: ",inst_60920].join('');
var inst_60922 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_60923 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_60924 = cljs.core.PersistentHashMap.fromArrays(inst_60922,inst_60923);
var inst_60925 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_60921,inst_60924);
var inst_60926 = (function(){throw inst_60925})();
var state_61002__$1 = state_61002;
var statearr_61032_61094 = state_61002__$1;
(statearr_61032_61094[(2)] = inst_60926);

(statearr_61032_61094[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (3))){
var inst_61000 = (state_61002[(2)]);
var state_61002__$1 = state_61002;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61002__$1,inst_61000);
} else {
if((state_val_61003 === (12))){
var inst_60891 = (state_61002[(12)]);
var inst_60900 = (state_61002[(14)]);
var inst_60898 = (state_61002[(2)]);
var inst_60899 = fluree.db.util.async.throw_err(inst_60898);
var inst_60900__$1 = cljs.core.second(inst_60891);
var state_61002__$1 = (function (){var statearr_61033 = state_61002;
(statearr_61033[(10)] = inst_60899);

(statearr_61033[(14)] = inst_60900__$1);

return statearr_61033;
})();
if(cljs.core.truth_(inst_60900__$1)){
var statearr_61034_61095 = state_61002__$1;
(statearr_61034_61095[(1)] = (13));

} else {
var statearr_61035_61096 = state_61002__$1;
(statearr_61035_61096[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (2))){
var _ = (function (){var statearr_61036 = state_61002;
(statearr_61036[(4)] = cljs.core.cons((5),(state_61002[(4)])));

return statearr_61036;
})();
var inst_60880 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query_map);
var inst_60881 = cljs.core.sequential_QMARK_(inst_60880);
var state_61002__$1 = state_61002;
if(inst_60881){
var statearr_61037_61097 = state_61002__$1;
(statearr_61037_61097[(1)] = (6));

} else {
var statearr_61038_61098 = state_61002__$1;
(statearr_61038_61098[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (23))){
var inst_60914 = (state_61002[(8)]);
var inst_60915 = (state_61002[(7)]);
var inst_60935 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60936 = [inst_60914,inst_60915];
var inst_60937 = (new cljs.core.PersistentVector(null,2,(5),inst_60935,inst_60936,null));
var state_61002__$1 = state_61002;
var statearr_61039_61099 = state_61002__$1;
(statearr_61039_61099[(2)] = inst_60937);

(statearr_61039_61099[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (35))){
var inst_60960 = (state_61002[(15)]);
var inst_60961 = (state_61002[(16)]);
var inst_60979 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60980 = [inst_60961,inst_60960];
var inst_60981 = (new cljs.core.PersistentVector(null,2,(5),inst_60979,inst_60980,null));
var state_61002__$1 = state_61002;
var statearr_61040_61100 = state_61002__$1;
(statearr_61040_61100[(2)] = inst_60981);

(statearr_61040_61100[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (19))){
var inst_60914 = (state_61002[(8)]);
var inst_60929 = (state_61002[(2)]);
var state_61002__$1 = (function (){var statearr_61041 = state_61002;
(statearr_61041[(19)] = inst_60929);

return statearr_61041;
})();
if(cljs.core.truth_(inst_60914)){
var statearr_61042_61101 = state_61002__$1;
(statearr_61042_61101[(1)] = (20));

} else {
var statearr_61043_61102 = state_61002__$1;
(statearr_61043_61102[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (11))){
var inst_60914 = (state_61002[(8)]);
var inst_60916 = (state_61002[(18)]);
var inst_60913 = (state_61002[(2)]);
var inst_60914__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60913,(0),null);
var inst_60915 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60913,(1),null);
var inst_60916__$1 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_60917 = (inst_60914__$1 > inst_60916__$1);
var state_61002__$1 = (function (){var statearr_61045 = state_61002;
(statearr_61045[(8)] = inst_60914__$1);

(statearr_61045[(18)] = inst_60916__$1);

(statearr_61045[(7)] = inst_60915);

return statearr_61045;
})();
if(cljs.core.truth_(inst_60917)){
var statearr_61046_61103 = state_61002__$1;
(statearr_61046_61103[(1)] = (17));

} else {
var statearr_61047_61104 = state_61002__$1;
(statearr_61047_61104[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (9))){
var inst_60891 = (state_61002[(12)]);
var inst_60894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60895 = cljs.core.first(inst_60891);
var inst_60896 = fluree.db.time_travel.block_to_int_format(db,inst_60895);
var state_61002__$1 = (function (){var statearr_61048 = state_61002;
(statearr_61048[(11)] = inst_60894);

return statearr_61048;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61002__$1,(12),inst_60896);
} else {
if((state_val_61003 === (5))){
var _ = (function (){var statearr_61049 = state_61002;
(statearr_61049[(4)] = cljs.core.rest((state_61002[(4)])));

return statearr_61049;
})();
var state_61002__$1 = state_61002;
var ex61044 = (state_61002__$1[(2)]);
var statearr_61050_61105 = state_61002__$1;
(statearr_61050_61105[(5)] = ex61044);


if((ex61044 instanceof Error)){
var statearr_61051_61106 = state_61002__$1;
(statearr_61051_61106[(1)] = (4));

(statearr_61051_61106[(5)] = null);

} else {
throw ex61044;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (14))){
var state_61002__$1 = state_61002;
var statearr_61052_61107 = state_61002__$1;
(statearr_61052_61107[(2)] = null);

(statearr_61052_61107[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (26))){
var inst_60914 = (state_61002[(8)]);
var inst_60940 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60941 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(db);
var inst_60942 = [inst_60914,inst_60941];
var inst_60943 = (new cljs.core.PersistentVector(null,2,(5),inst_60940,inst_60942,null));
var state_61002__$1 = state_61002;
var statearr_61053_61108 = state_61002__$1;
(statearr_61053_61108[(2)] = inst_60943);

(statearr_61053_61108[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (16))){
var inst_60904 = (state_61002[(2)]);
var inst_60905 = fluree.db.util.async.throw_err(inst_60904);
var state_61002__$1 = state_61002;
var statearr_61054_61109 = state_61002__$1;
(statearr_61054_61109[(2)] = inst_60905);

(statearr_61054_61109[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (38))){
var inst_60916 = (state_61002[(18)]);
var state_61002__$1 = state_61002;
var statearr_61055_61110 = state_61002__$1;
(statearr_61055_61110[(2)] = inst_60916);

(statearr_61055_61110[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (30))){
var state_61002__$1 = state_61002;
var statearr_61056_61111 = state_61002__$1;
(statearr_61056_61111[(2)] = null);

(statearr_61056_61111[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (10))){
var inst_60891 = (state_61002[(12)]);
var state_61002__$1 = state_61002;
var statearr_61057_61112 = state_61002__$1;
(statearr_61057_61112[(2)] = inst_60891);

(statearr_61057_61112[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (18))){
var state_61002__$1 = state_61002;
var statearr_61058_61113 = state_61002__$1;
(statearr_61058_61113[(2)] = null);

(statearr_61058_61113[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (37))){
var inst_60989 = (state_61002[(9)]);
var inst_60916 = (state_61002[(18)]);
var inst_60987 = (state_61002[(2)]);
var inst_60988 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60987,(0),null);
var inst_60989__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_60987,(1),null);
var inst_60990 = (inst_60989__$1 > inst_60916);
var state_61002__$1 = (function (){var statearr_61059 = state_61002;
(statearr_61059[(9)] = inst_60989__$1);

(statearr_61059[(13)] = inst_60988);

return statearr_61059;
})();
if(cljs.core.truth_(inst_60990)){
var statearr_61060_61114 = state_61002__$1;
(statearr_61060_61114[(1)] = (38));

} else {
var statearr_61061_61115 = state_61002__$1;
(statearr_61061_61115[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61003 === (8))){
var inst_60891 = (state_61002[(12)]);
var inst_60891__$1 = (state_61002[(2)]);
var inst_60892 = cljs.core.some(cljs.core.string_QMARK_,inst_60891__$1);
var state_61002__$1 = (function (){var statearr_61062 = state_61002;
(statearr_61062[(12)] = inst_60891__$1);

return statearr_61062;
})();
if(cljs.core.truth_(inst_60892)){
var statearr_61063_61116 = state_61002__$1;
(statearr_61063_61116[(1)] = (9));

} else {
var statearr_61064_61117 = state_61002__$1;
(statearr_61064_61117[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto____0 = (function (){
var statearr_61065 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61065[(0)] = fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto__);

(statearr_61065[(1)] = (1));

return statearr_61065;
});
var fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto____1 = (function (state_61002){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_61002);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e61066){var ex__2882__auto__ = e61066;
var statearr_61067_61118 = state_61002;
(statearr_61067_61118[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_61002[(4)]))){
var statearr_61068_61119 = state_61002;
(statearr_61068_61119[(1)] = cljs.core.first((state_61002[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61120 = state_61002;
state_61002 = G__61120;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto__ = function(state_61002){
switch(arguments.length){
case 0:
return fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto____1.call(this,state_61002);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto____0;
fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto____1;
return fluree$db$api$query$resolve_block_range_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_61069 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_61069[(6)] = c__2901__auto__);

return statearr_61069;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.api.query.format_block_resp_pretty = (function fluree$db$api$query$format_block_resp_pretty(db,curr_block,cache,fuel){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_61270){
var state_val_61271 = (state_61270[(1)]);
if((state_val_61271 === (7))){
var inst_61182 = (state_61270[(2)]);
var inst_61183 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61182,(0),null);
var inst_61184 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61182,(1),null);
var inst_61192 = cljs.core.vals(inst_61184);
var inst_61193 = cljs.core.seq(inst_61192);
var inst_61194 = cljs.core.first(inst_61193);
var inst_61195 = cljs.core.next(inst_61193);
var inst_61196 = cljs.core.PersistentVector.EMPTY;
var inst_61197 = inst_61192;
var inst_61198 = inst_61196;
var state_61270__$1 = (function (){var statearr_61272 = state_61270;
(statearr_61272[(7)] = inst_61198);

(statearr_61272[(8)] = inst_61183);

(statearr_61272[(9)] = inst_61197);

(statearr_61272[(10)] = inst_61194);

(statearr_61272[(11)] = inst_61195);

return statearr_61272;
})();
var statearr_61273_61326 = state_61270__$1;
(statearr_61273_61326[(2)] = null);

(statearr_61273_61326[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (20))){
var inst_61204 = (state_61270[(12)]);
var inst_61209 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_61210 = cljs.core.PersistentHashMap.EMPTY;
var inst_61211 = [true,inst_61210];
var inst_61212 = cljs.core.PersistentHashMap.fromArrays(inst_61209,inst_61211);
var inst_61213 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_61212,inst_61204);
var state_61270__$1 = state_61270;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61270__$1,(22),inst_61213);
} else {
if((state_val_61271 === (27))){
var inst_61258 = (state_61270[(2)]);
var state_61270__$1 = state_61270;
var statearr_61274_61327 = state_61270__$1;
(statearr_61274_61327[(2)] = inst_61258);

(statearr_61274_61327[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (1))){
var state_61270__$1 = state_61270;
var statearr_61275_61328 = state_61270__$1;
(statearr_61275_61328[(2)] = null);

(statearr_61275_61328[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (24))){
var inst_61222 = (state_61270[(13)]);
var inst_61260 = (state_61270[(2)]);
var inst_61261 = [new cljs.core.Keyword(null,"block","block",664686210),new cljs.core.Keyword(null,"t","t",-1397832519),new cljs.core.Keyword(null,"retracted","retracted",-1399687854),new cljs.core.Keyword(null,"asserted","asserted",-1558973611)];
var inst_61262 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_61263 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_61264 = [inst_61262,inst_61263,inst_61222,inst_61260];
var inst_61265 = cljs.core.PersistentHashMap.fromArrays(inst_61261,inst_61264);
var _ = (function (){var statearr_61277 = state_61270;
(statearr_61277[(4)] = cljs.core.rest((state_61270[(4)])));

return statearr_61277;
})();
var state_61270__$1 = state_61270;
var statearr_61278_61329 = state_61270__$1;
(statearr_61278_61329[(2)] = inst_61265);

(statearr_61278_61329[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (4))){
var inst_61123 = (state_61270[(2)]);
var state_61270__$1 = state_61270;
var statearr_61279_61330 = state_61270__$1;
(statearr_61279_61330[(2)] = inst_61123);

(statearr_61279_61330[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (15))){
var inst_61139 = (state_61270[(14)]);
var inst_61142 = (state_61270[(15)]);
var inst_61141 = (state_61270[(16)]);
var inst_61163 = (state_61270[(17)]);
var inst_61168 = (state_61270[(18)]);
var inst_61154 = (state_61270[(19)]);
var inst_61147 = (state_61270[(20)]);
var inst_61146 = (state_61270[(21)]);
var inst_61161 = (state_61270[(22)]);
var inst_61153 = (state_61270[(23)]);
var inst_61145 = (state_61270[(24)]);
var inst_61174 = (function (){var subject = inst_61161;
var flake = inst_61153;
var vec__61149 = inst_61145;
var r = inst_61154;
var asserted_subjects = inst_61146;
var first__61138 = inst_61141;
var G__61135 = inst_61145;
var flake_SINGLEQUOTE_ = inst_61168;
var retracted_subjects = inst_61147;
var seq__61137 = inst_61142;
var first__61151 = inst_61153;
var asserted_QMARK_ = inst_61163;
var seq__61150 = inst_61154;
var vec__61136 = inst_61139;
return (function (p1__61122_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__61122_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_61175 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_61147,inst_61161,inst_61174);
var tmp61276 = inst_61146;
var inst_61145__$1 = inst_61154;
var inst_61146__$1 = tmp61276;
var inst_61147__$1 = inst_61175;
var state_61270__$1 = (function (){var statearr_61280 = state_61270;
(statearr_61280[(20)] = inst_61147__$1);

(statearr_61280[(21)] = inst_61146__$1);

(statearr_61280[(24)] = inst_61145__$1);

return statearr_61280;
})();
var statearr_61281_61331 = state_61270__$1;
(statearr_61281_61331[(2)] = null);

(statearr_61281_61331[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (21))){
var inst_61220 = (state_61270[(2)]);
var state_61270__$1 = state_61270;
var statearr_61282_61332 = state_61270__$1;
(statearr_61282_61332[(2)] = inst_61220);

(statearr_61282_61332[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (13))){
var inst_61163 = (state_61270[(17)]);
var inst_61168 = (state_61270[(2)]);
var state_61270__$1 = (function (){var statearr_61283 = state_61270;
(statearr_61283[(18)] = inst_61168);

return statearr_61283;
})();
if(cljs.core.truth_(inst_61163)){
var statearr_61284_61333 = state_61270__$1;
(statearr_61284_61333[(1)] = (14));

} else {
var statearr_61285_61334 = state_61270__$1;
(statearr_61285_61334[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (22))){
var inst_61205 = (state_61270[(25)]);
var inst_61198 = (state_61270[(7)]);
var inst_61215 = (state_61270[(2)]);
var inst_61216 = fluree.db.util.async.throw_err(inst_61215);
var inst_61217 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_61198,inst_61216);
var inst_61197 = inst_61205;
var inst_61198__$1 = inst_61217;
var state_61270__$1 = (function (){var statearr_61286 = state_61270;
(statearr_61286[(7)] = inst_61198__$1);

(statearr_61286[(9)] = inst_61197);

return statearr_61286;
})();
var statearr_61287_61335 = state_61270__$1;
(statearr_61287_61335[(2)] = null);

(statearr_61287_61335[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (6))){
var inst_61153 = (state_61270[(23)]);
var inst_61145 = (state_61270[(24)]);
var inst_61152 = cljs.core.seq(inst_61145);
var inst_61153__$1 = cljs.core.first(inst_61152);
var inst_61154 = cljs.core.next(inst_61152);
var inst_61155 = cljs.core.not(inst_61153__$1);
var state_61270__$1 = (function (){var statearr_61288 = state_61270;
(statearr_61288[(19)] = inst_61154);

(statearr_61288[(23)] = inst_61153__$1);

return statearr_61288;
})();
if(inst_61155){
var statearr_61289_61336 = state_61270__$1;
(statearr_61289_61336[(1)] = (8));

} else {
var statearr_61290_61337 = state_61270__$1;
(statearr_61290_61337[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (28))){
var inst_61236 = (state_61270[(26)]);
var inst_61243 = (state_61270[(27)]);
var inst_61253 = (state_61270[(2)]);
var inst_61254 = fluree.db.util.async.throw_err(inst_61253);
var inst_61255 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_61236,inst_61254);
var inst_61235 = inst_61243;
var inst_61236__$1 = inst_61255;
var state_61270__$1 = (function (){var statearr_61291 = state_61270;
(statearr_61291[(26)] = inst_61236__$1);

(statearr_61291[(28)] = inst_61235);

return statearr_61291;
})();
var statearr_61292_61338 = state_61270__$1;
(statearr_61292_61338[(2)] = null);

(statearr_61292_61338[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (25))){
var inst_61236 = (state_61270[(26)]);
var state_61270__$1 = state_61270;
var statearr_61293_61339 = state_61270__$1;
(statearr_61293_61339[(2)] = inst_61236);

(statearr_61293_61339[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (17))){
var inst_61197 = (state_61270[(9)]);
var inst_61204 = (state_61270[(12)]);
var inst_61203 = cljs.core.seq(inst_61197);
var inst_61204__$1 = cljs.core.first(inst_61203);
var inst_61205 = cljs.core.next(inst_61203);
var inst_61206 = cljs.core.not(inst_61204__$1);
var state_61270__$1 = (function (){var statearr_61294 = state_61270;
(statearr_61294[(25)] = inst_61205);

(statearr_61294[(12)] = inst_61204__$1);

return statearr_61294;
})();
if(inst_61206){
var statearr_61295_61340 = state_61270__$1;
(statearr_61295_61340[(1)] = (19));

} else {
var statearr_61296_61341 = state_61270__$1;
(statearr_61296_61341[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (3))){
var inst_61268 = (state_61270[(2)]);
var state_61270__$1 = state_61270;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61270__$1,inst_61268);
} else {
if((state_val_61271 === (12))){
var inst_61153 = (state_61270[(23)]);
var inst_61166 = fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1(inst_61153);
var state_61270__$1 = state_61270;
var statearr_61297_61342 = state_61270__$1;
(statearr_61297_61342[(2)] = inst_61166);

(statearr_61297_61342[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (2))){
var inst_61139 = (state_61270[(14)]);
var _ = (function (){var statearr_61298 = state_61270;
(statearr_61298[(4)] = cljs.core.cons((5),(state_61270[(4)])));

return statearr_61298;
})();
var inst_61139__$1 = new cljs.core.Keyword(null,"flakes","flakes",1977895739).cljs$core$IFn$_invoke$arity$1(curr_block);
var inst_61140 = cljs.core.seq(inst_61139__$1);
var inst_61141 = cljs.core.first(inst_61140);
var inst_61142 = cljs.core.next(inst_61140);
var inst_61143 = cljs.core.PersistentHashMap.EMPTY;
var inst_61144 = cljs.core.PersistentHashMap.EMPTY;
var inst_61145 = inst_61139__$1;
var inst_61146 = inst_61143;
var inst_61147 = inst_61144;
var state_61270__$1 = (function (){var statearr_61299 = state_61270;
(statearr_61299[(14)] = inst_61139__$1);

(statearr_61299[(15)] = inst_61142);

(statearr_61299[(16)] = inst_61141);

(statearr_61299[(20)] = inst_61147);

(statearr_61299[(21)] = inst_61146);

(statearr_61299[(24)] = inst_61145);

return statearr_61299;
})();
var statearr_61300_61343 = state_61270__$1;
(statearr_61300_61343[(2)] = null);

(statearr_61300_61343[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (23))){
var inst_61242 = (state_61270[(29)]);
var inst_61235 = (state_61270[(28)]);
var inst_61241 = cljs.core.seq(inst_61235);
var inst_61242__$1 = cljs.core.first(inst_61241);
var inst_61243 = cljs.core.next(inst_61241);
var inst_61244 = cljs.core.not(inst_61242__$1);
var state_61270__$1 = (function (){var statearr_61301 = state_61270;
(statearr_61301[(27)] = inst_61243);

(statearr_61301[(29)] = inst_61242__$1);

return statearr_61301;
})();
if(inst_61244){
var statearr_61302_61344 = state_61270__$1;
(statearr_61302_61344[(1)] = (25));

} else {
var statearr_61303_61345 = state_61270__$1;
(statearr_61303_61345[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (19))){
var inst_61198 = (state_61270[(7)]);
var state_61270__$1 = state_61270;
var statearr_61304_61346 = state_61270__$1;
(statearr_61304_61346[(2)] = inst_61198);

(statearr_61304_61346[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (11))){
var inst_61153 = (state_61270[(23)]);
var state_61270__$1 = state_61270;
var statearr_61306_61347 = state_61270__$1;
(statearr_61306_61347[(2)] = inst_61153);

(statearr_61306_61347[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (9))){
var inst_61163 = (state_61270[(17)]);
var inst_61153 = (state_61270[(23)]);
var inst_61161 = inst_61153.s;
var inst_61162 = inst_61153.op;
var inst_61163__$1 = inst_61162 === true;
var state_61270__$1 = (function (){var statearr_61308 = state_61270;
(statearr_61308[(17)] = inst_61163__$1);

(statearr_61308[(22)] = inst_61161);

return statearr_61308;
})();
if(cljs.core.truth_(inst_61163__$1)){
var statearr_61309_61348 = state_61270__$1;
(statearr_61309_61348[(1)] = (11));

} else {
var statearr_61310_61349 = state_61270__$1;
(statearr_61310_61349[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (5))){
var _ = (function (){var statearr_61311 = state_61270;
(statearr_61311[(4)] = cljs.core.rest((state_61270[(4)])));

return statearr_61311;
})();
var state_61270__$1 = state_61270;
var ex61305 = (state_61270__$1[(2)]);
var statearr_61312_61350 = state_61270__$1;
(statearr_61312_61350[(5)] = ex61305);


if((ex61305 instanceof Error)){
var statearr_61313_61351 = state_61270__$1;
(statearr_61313_61351[(1)] = (4));

(statearr_61313_61351[(5)] = null);

} else {
throw ex61305;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (14))){
var inst_61139 = (state_61270[(14)]);
var inst_61142 = (state_61270[(15)]);
var inst_61141 = (state_61270[(16)]);
var inst_61163 = (state_61270[(17)]);
var inst_61168 = (state_61270[(18)]);
var inst_61154 = (state_61270[(19)]);
var inst_61147 = (state_61270[(20)]);
var inst_61146 = (state_61270[(21)]);
var inst_61161 = (state_61270[(22)]);
var inst_61153 = (state_61270[(23)]);
var inst_61145 = (state_61270[(24)]);
var inst_61170 = (function (){var subject = inst_61161;
var flake = inst_61153;
var vec__61149 = inst_61145;
var r = inst_61154;
var asserted_subjects = inst_61146;
var first__61138 = inst_61141;
var G__61135 = inst_61145;
var flake_SINGLEQUOTE_ = inst_61168;
var retracted_subjects = inst_61147;
var seq__61137 = inst_61142;
var first__61151 = inst_61153;
var asserted_QMARK_ = inst_61163;
var seq__61150 = inst_61154;
var vec__61136 = inst_61139;
return (function (p1__61121_SHARP_){
return cljs.core.vec(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__61121_SHARP_,flake_SINGLEQUOTE_));
});
})();
var inst_61171 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_61146,inst_61161,inst_61170);
var tmp61307 = inst_61147;
var inst_61145__$1 = inst_61154;
var inst_61146__$1 = inst_61171;
var inst_61147__$1 = tmp61307;
var state_61270__$1 = (function (){var statearr_61314 = state_61270;
(statearr_61314[(20)] = inst_61147__$1);

(statearr_61314[(21)] = inst_61146__$1);

(statearr_61314[(24)] = inst_61145__$1);

return statearr_61314;
})();
var statearr_61315_61352 = state_61270__$1;
(statearr_61315_61352[(2)] = null);

(statearr_61315_61352[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (26))){
var inst_61242 = (state_61270[(29)]);
var inst_61247 = [new cljs.core.Keyword(null,"wildcard?","wildcard?",-686044101),new cljs.core.Keyword(null,"select","select",1147833503)];
var inst_61248 = cljs.core.PersistentHashMap.EMPTY;
var inst_61249 = [true,inst_61248];
var inst_61250 = cljs.core.PersistentHashMap.fromArrays(inst_61247,inst_61249);
var inst_61251 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,(1000000),inst_61250,inst_61242);
var state_61270__$1 = state_61270;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61270__$1,(28),inst_61251);
} else {
if((state_val_61271 === (16))){
var inst_61178 = (state_61270[(2)]);
var state_61270__$1 = state_61270;
var statearr_61316_61353 = state_61270__$1;
(statearr_61316_61353[(2)] = inst_61178);

(statearr_61316_61353[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (10))){
var inst_61180 = (state_61270[(2)]);
var state_61270__$1 = state_61270;
var statearr_61317_61354 = state_61270__$1;
(statearr_61317_61354[(2)] = inst_61180);

(statearr_61317_61354[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (18))){
var inst_61183 = (state_61270[(8)]);
var inst_61222 = (state_61270[(2)]);
var inst_61230 = cljs.core.vals(inst_61183);
var inst_61231 = cljs.core.seq(inst_61230);
var inst_61232 = cljs.core.first(inst_61231);
var inst_61233 = cljs.core.next(inst_61231);
var inst_61234 = cljs.core.PersistentVector.EMPTY;
var inst_61235 = inst_61230;
var inst_61236 = inst_61234;
var state_61270__$1 = (function (){var statearr_61318 = state_61270;
(statearr_61318[(26)] = inst_61236);

(statearr_61318[(13)] = inst_61222);

(statearr_61318[(28)] = inst_61235);

(statearr_61318[(30)] = inst_61233);

(statearr_61318[(31)] = inst_61232);

return statearr_61318;
})();
var statearr_61319_61355 = state_61270__$1;
(statearr_61319_61355[(2)] = null);

(statearr_61319_61355[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61271 === (8))){
var inst_61147 = (state_61270[(20)]);
var inst_61146 = (state_61270[(21)]);
var inst_61157 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61158 = [inst_61146,inst_61147];
var inst_61159 = (new cljs.core.PersistentVector(null,2,(5),inst_61157,inst_61158,null));
var state_61270__$1 = state_61270;
var statearr_61320_61356 = state_61270__$1;
(statearr_61320_61356[(2)] = inst_61159);

(statearr_61320_61356[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto____0 = (function (){
var statearr_61321 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61321[(0)] = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto__);

(statearr_61321[(1)] = (1));

return statearr_61321;
});
var fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto____1 = (function (state_61270){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_61270);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e61322){var ex__2882__auto__ = e61322;
var statearr_61323_61357 = state_61270;
(statearr_61323_61357[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_61270[(4)]))){
var statearr_61324_61358 = state_61270;
(statearr_61324_61358[(1)] = cljs.core.first((state_61270[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61359 = state_61270;
state_61270 = G__61359;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto__ = function(state_61270){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto____1.call(this,state_61270);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto____0;
fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto____1;
return fluree$db$api$query$format_block_resp_pretty_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_61325 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_61325[(6)] = c__2901__auto__);

return statearr_61325;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.api.query.format_blocks_resp_pretty = (function fluree$db$api$query$format_blocks_resp_pretty(db,resp){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_61391){
var state_val_61392 = (state_61391[(1)]);
if((state_val_61392 === (1))){
var inst_61360 = cljs.core.volatile_BANG_((0));
var inst_61361 = cljs.core.PersistentHashMap.EMPTY;
var inst_61362 = cljs.core.volatile_BANG_(inst_61361);
var inst_61363 = cljs.core.first(resp);
var inst_61364 = cljs.core.rest(resp);
var inst_61365 = cljs.core.PersistentVector.EMPTY;
var inst_61366 = inst_61360;
var inst_61367 = inst_61362;
var inst_61368 = inst_61363;
var inst_61369 = inst_61364;
var inst_61370 = inst_61365;
var state_61391__$1 = (function (){var statearr_61393 = state_61391;
(statearr_61393[(7)] = inst_61367);

(statearr_61393[(8)] = inst_61370);

(statearr_61393[(9)] = inst_61368);

(statearr_61393[(10)] = inst_61369);

(statearr_61393[(11)] = inst_61366);

return statearr_61393;
})();
var statearr_61394_61409 = state_61391__$1;
(statearr_61394_61409[(2)] = null);

(statearr_61394_61409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61392 === (2))){
var inst_61367 = (state_61391[(7)]);
var inst_61368 = (state_61391[(9)]);
var inst_61366 = (state_61391[(11)]);
var inst_61372 = fluree.db.api.query.format_block_resp_pretty(db,inst_61368,inst_61367,inst_61366);
var state_61391__$1 = state_61391;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61391__$1,(4),inst_61372);
} else {
if((state_val_61392 === (3))){
var inst_61389 = (state_61391[(2)]);
var state_61391__$1 = state_61391;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61391__$1,inst_61389);
} else {
if((state_val_61392 === (4))){
var inst_61370 = (state_61391[(8)]);
var inst_61369 = (state_61391[(10)]);
var inst_61374 = (state_61391[(2)]);
var inst_61375 = fluree.db.util.async.throw_err(inst_61374);
var inst_61376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61377 = [inst_61375];
var inst_61378 = (new cljs.core.PersistentVector(null,1,(5),inst_61376,inst_61377,null));
var inst_61379 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_61370,inst_61378);
var inst_61380 = cljs.core.first(inst_61369);
var state_61391__$1 = (function (){var statearr_61397 = state_61391;
(statearr_61397[(12)] = inst_61379);

return statearr_61397;
})();
if(cljs.core.truth_(inst_61380)){
var statearr_61398_61410 = state_61391__$1;
(statearr_61398_61410[(1)] = (5));

} else {
var statearr_61399_61411 = state_61391__$1;
(statearr_61399_61411[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61392 === (5))){
var inst_61379 = (state_61391[(12)]);
var inst_61367 = (state_61391[(7)]);
var inst_61369 = (state_61391[(10)]);
var inst_61366 = (state_61391[(11)]);
var inst_61382 = cljs.core.first(inst_61369);
var inst_61383 = cljs.core.rest(inst_61369);
var tmp61395 = inst_61367;
var tmp61396 = inst_61366;
var inst_61366__$1 = tmp61396;
var inst_61367__$1 = tmp61395;
var inst_61368 = inst_61382;
var inst_61369__$1 = inst_61383;
var inst_61370 = inst_61379;
var state_61391__$1 = (function (){var statearr_61400 = state_61391;
(statearr_61400[(7)] = inst_61367__$1);

(statearr_61400[(8)] = inst_61370);

(statearr_61400[(9)] = inst_61368);

(statearr_61400[(10)] = inst_61369__$1);

(statearr_61400[(11)] = inst_61366__$1);

return statearr_61400;
})();
var statearr_61401_61412 = state_61391__$1;
(statearr_61401_61412[(2)] = null);

(statearr_61401_61412[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61392 === (6))){
var inst_61379 = (state_61391[(12)]);
var state_61391__$1 = state_61391;
var statearr_61402_61413 = state_61391__$1;
(statearr_61402_61413[(2)] = inst_61379);

(statearr_61402_61413[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61392 === (7))){
var inst_61387 = (state_61391[(2)]);
var state_61391__$1 = state_61391;
var statearr_61403_61414 = state_61391__$1;
(statearr_61403_61414[(2)] = inst_61387);

(statearr_61403_61414[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto____0 = (function (){
var statearr_61404 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61404[(0)] = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto__);

(statearr_61404[(1)] = (1));

return statearr_61404;
});
var fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto____1 = (function (state_61391){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_61391);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e61405){var ex__2882__auto__ = e61405;
var statearr_61406_61415 = state_61391;
(statearr_61406_61415[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_61391[(4)]))){
var statearr_61407_61416 = state_61391;
(statearr_61407_61416[(1)] = cljs.core.first((state_61391[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61417 = state_61391;
state_61391 = G__61417;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto__ = function(state_61391){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto____1.call(this,state_61391);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto____0;
fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto____1;
return fluree$db$api$query$format_blocks_resp_pretty_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_61408 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_61408[(6)] = c__2901__auto__);

return statearr_61408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Returns response time, formatted as string. Must provide start time of request
 * for clj as (System/nanoTime), or for cljs epoch milliseconds
 */
fluree.db.api.query.response_time_formatted = (function fluree$db$api$query$response_time_formatted(start_time){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((fluree.db.util.core.current_time_millis() - start_time)),"ms"].join('');
});
/**
 * Returns a core async channel of blocks from start block (inclusive) to end if provided (exclusive).
 *   Each block is a separate map, containing keys :block, :t and :flakes.
 *   Channel is lazy, continue to take! values as needed.
 */
fluree.db.api.query.block_range = (function fluree$db$api$query$block_range(var_args){
var G__61420 = arguments.length;
switch (G__61420) {
case 2:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$2 = (function (db,start){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,null,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$3 = (function (db,start,end){
return fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(db,start,end,null);
}));

(fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4 = (function (db,start,end,opts){
return fluree.db.query.block.block_range(db,start,end,opts);
}));

(fluree.db.api.query.block_range.cljs$lang$maxFixedArity = 4);

fluree.db.api.query.block_query_async = (function fluree$db$api$query$block_query_async(conn,ledger,p__61422){
var map__61423 = p__61422;
var map__61423__$1 = (((((!((map__61423 == null))))?(((((map__61423.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__61423.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__61423):map__61423);
var query = map__61423__$1;
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__61423__$1,new cljs.core.Keyword(null,"opts","opts",155075701));
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_61509){
var state_val_61510 = (state_61509[(1)]);
if((state_val_61510 === (7))){
var inst_61435 = (state_61509[(7)]);
var inst_61439 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61440 = ["_auth/id",inst_61435];
var inst_61441 = (new cljs.core.PersistentVector(null,2,(5),inst_61439,inst_61440,null));
var state_61509__$1 = state_61509;
var statearr_61511_61555 = state_61509__$1;
(statearr_61511_61555[(2)] = inst_61441);

(statearr_61511_61555[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (20))){
var inst_61489 = (state_61509[(2)]);
var inst_61490 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(opts);
var state_61509__$1 = (function (){var statearr_61512 = state_61509;
(statearr_61512[(8)] = inst_61489);

return statearr_61512;
})();
if(cljs.core.truth_(inst_61490)){
var statearr_61513_61556 = state_61509__$1;
(statearr_61513_61556[(1)] = (22));

} else {
var statearr_61514_61557 = state_61509__$1;
(statearr_61514_61557[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (27))){
var inst_61436 = (state_61509[(9)]);
var inst_61492 = (state_61509[(10)]);
var inst_61498 = (state_61509[(2)]);
var inst_61499 = fluree.db.api.query.response_time_formatted(inst_61436);
var inst_61500 = [(200),inst_61498,(100),inst_61499];
var inst_61501 = cljs.core.PersistentHashMap.fromArrays(inst_61492,inst_61500);
var state_61509__$1 = state_61509;
var statearr_61515_61558 = state_61509__$1;
(statearr_61515_61558[(2)] = inst_61501);

(statearr_61515_61558[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (1))){
var state_61509__$1 = state_61509;
var statearr_61516_61559 = state_61509__$1;
(statearr_61516_61559[(2)] = null);

(statearr_61516_61559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (24))){
var inst_61504 = (state_61509[(2)]);
var _ = (function (){var statearr_61517 = state_61509;
(statearr_61517[(4)] = cljs.core.rest((state_61509[(4)])));

return statearr_61517;
})();
var state_61509__$1 = state_61509;
var statearr_61518_61560 = state_61509__$1;
(statearr_61518_61560[(2)] = inst_61504);

(statearr_61518_61560[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (4))){
var inst_61425 = (state_61509[(2)]);
var state_61509__$1 = state_61509;
var statearr_61519_61561 = state_61509__$1;
(statearr_61519_61561[(2)] = inst_61425);

(statearr_61519_61561[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (15))){
var inst_61476 = (state_61509[(11)]);
var state_61509__$1 = state_61509;
var statearr_61520_61562 = state_61509__$1;
(statearr_61520_61562[(2)] = inst_61476);

(statearr_61520_61562[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (21))){
var inst_61485 = (state_61509[(2)]);
var inst_61486 = fluree.db.util.async.throw_err(inst_61485);
var state_61509__$1 = state_61509;
var statearr_61521_61563 = state_61509__$1;
(statearr_61521_61563[(2)] = inst_61486);

(statearr_61521_61563[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (13))){
var inst_61476 = (state_61509[(11)]);
var inst_61434 = (state_61509[(12)]);
var inst_61475 = (state_61509[(2)]);
var inst_61476__$1 = new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803).cljs$core$IFn$_invoke$arity$1(inst_61434);
var state_61509__$1 = (function (){var statearr_61522 = state_61509;
(statearr_61522[(13)] = inst_61475);

(statearr_61522[(11)] = inst_61476__$1);

return statearr_61522;
})();
if(cljs.core.truth_(inst_61476__$1)){
var statearr_61523_61564 = state_61509__$1;
(statearr_61523_61564[(1)] = (15));

} else {
var statearr_61524_61565 = state_61509__$1;
(statearr_61524_61565[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (22))){
var inst_61489 = (state_61509[(8)]);
var inst_61492 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_61493 = cljs.core.sequential_QMARK_(inst_61489);
var state_61509__$1 = (function (){var statearr_61525 = state_61509;
(statearr_61525[(10)] = inst_61492);

return statearr_61525;
})();
if(inst_61493){
var statearr_61526_61566 = state_61509__$1;
(statearr_61526_61566[(1)] = (25));

} else {
var statearr_61527_61567 = state_61509__$1;
(statearr_61527_61567[(1)] = (26));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (6))){
var inst_61450 = (state_61509[(14)]);
var inst_61434 = (state_61509[(12)]);
var inst_61449 = (state_61509[(2)]);
var inst_61450__$1 = fluree.db.util.async.throw_err(inst_61449);
var inst_61451 = fluree.db.api.query.resolve_block_range(inst_61450__$1,inst_61434);
var state_61509__$1 = (function (){var statearr_61528 = state_61509;
(statearr_61528[(14)] = inst_61450__$1);

return statearr_61528;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61509__$1,(10),inst_61451);
} else {
if((state_val_61510 === (25))){
var inst_61489 = (state_61509[(8)]);
var inst_61495 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_61489);
var state_61509__$1 = state_61509;
var statearr_61529_61568 = state_61509__$1;
(statearr_61529_61568[(2)] = inst_61495);

(statearr_61529_61568[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (17))){
var inst_61481 = (state_61509[(2)]);
var state_61509__$1 = state_61509;
if(cljs.core.truth_(inst_61481)){
var statearr_61530_61569 = state_61509__$1;
(statearr_61530_61569[(1)] = (18));

} else {
var statearr_61531_61570 = state_61509__$1;
(statearr_61531_61570[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (3))){
var inst_61507 = (state_61509[(2)]);
var state_61509__$1 = state_61509;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61509__$1,inst_61507);
} else {
if((state_val_61510 === (12))){
var inst_61434 = (state_61509[(12)]);
var inst_61467 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_61434], 0));
var inst_61468 = ["Block query not properly formatted. It must only have a block key. Provided ",inst_61467].join('');
var inst_61469 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_61470 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_61471 = cljs.core.PersistentHashMap.fromArrays(inst_61469,inst_61470);
var inst_61472 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_61468,inst_61471);
var inst_61473 = (function(){throw inst_61472})();
var state_61509__$1 = state_61509;
var statearr_61532_61571 = state_61509__$1;
(statearr_61532_61571[(2)] = inst_61473);

(statearr_61532_61571[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (2))){
var inst_61435 = (state_61509[(7)]);
var _ = (function (){var statearr_61533 = state_61509;
(statearr_61533[(4)] = cljs.core.cons((5),(state_61509[(4)])));

return statearr_61533;
})();
var inst_61434 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_61435__$1 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(opts);
var inst_61436 = fluree.db.util.core.current_time_millis();
var inst_61437 = [new cljs.core.Keyword(null,"auth","auth",1389754926)];
var state_61509__$1 = (function (){var statearr_61534 = state_61509;
(statearr_61534[(9)] = inst_61436);

(statearr_61534[(15)] = inst_61437);

(statearr_61534[(7)] = inst_61435__$1);

(statearr_61534[(12)] = inst_61434);

return statearr_61534;
})();
if(cljs.core.truth_(inst_61435__$1)){
var statearr_61535_61572 = state_61509__$1;
(statearr_61535_61572[(1)] = (7));

} else {
var statearr_61536_61573 = state_61509__$1;
(statearr_61536_61573[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (23))){
var inst_61489 = (state_61509[(8)]);
var state_61509__$1 = state_61509;
var statearr_61537_61574 = state_61509__$1;
(statearr_61537_61574[(2)] = inst_61489);

(statearr_61537_61574[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (19))){
var inst_61475 = (state_61509[(13)]);
var state_61509__$1 = state_61509;
var statearr_61538_61575 = state_61509__$1;
(statearr_61538_61575[(2)] = inst_61475);

(statearr_61538_61575[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (11))){
var inst_61456 = (state_61509[(16)]);
var inst_61450 = (state_61509[(14)]);
var inst_61455 = (state_61509[(17)]);
var inst_61462 = fluree.db.api.query.block_range.cljs$core$IFn$_invoke$arity$4(inst_61450,inst_61455,inst_61456,opts);
var state_61509__$1 = state_61509;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61509__$1,(14),inst_61462);
} else {
if((state_val_61510 === (9))){
var inst_61437 = (state_61509[(15)]);
var inst_61444 = (state_61509[(2)]);
var inst_61445 = [inst_61444];
var inst_61446 = cljs.core.PersistentHashMap.fromArrays(inst_61437,inst_61445);
var inst_61447 = fluree.db.api.query.db.cljs$core$IFn$_invoke$arity$3(conn,ledger,inst_61446);
var state_61509__$1 = state_61509;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61509__$1,(6),inst_61447);
} else {
if((state_val_61510 === (5))){
var _ = (function (){var statearr_61540 = state_61509;
(statearr_61540[(4)] = cljs.core.rest((state_61509[(4)])));

return statearr_61540;
})();
var state_61509__$1 = state_61509;
var ex61539 = (state_61509__$1[(2)]);
var statearr_61541_61576 = state_61509__$1;
(statearr_61541_61576[(5)] = ex61539);


if((ex61539 instanceof Error)){
var statearr_61542_61577 = state_61509__$1;
(statearr_61542_61577[(1)] = (4));

(statearr_61542_61577[(5)] = null);

} else {
throw ex61539;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (14))){
var inst_61464 = (state_61509[(2)]);
var inst_61465 = fluree.db.util.async.throw_err(inst_61464);
var state_61509__$1 = state_61509;
var statearr_61543_61578 = state_61509__$1;
(statearr_61543_61578[(2)] = inst_61465);

(statearr_61543_61578[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (26))){
var inst_61489 = (state_61509[(8)]);
var state_61509__$1 = state_61509;
var statearr_61544_61579 = state_61509__$1;
(statearr_61544_61579[(2)] = inst_61489);

(statearr_61544_61579[(1)] = (27));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (16))){
var inst_61434 = (state_61509[(12)]);
var inst_61479 = new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013).cljs$core$IFn$_invoke$arity$1(inst_61434);
var state_61509__$1 = state_61509;
var statearr_61545_61580 = state_61509__$1;
(statearr_61545_61580[(2)] = inst_61479);

(statearr_61545_61580[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (10))){
var inst_61434 = (state_61509[(12)]);
var inst_61453 = (state_61509[(2)]);
var inst_61454 = fluree.db.util.async.throw_err(inst_61453);
var inst_61455 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61454,(0),null);
var inst_61456 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_61454,(1),null);
var inst_61457 = cljs.core.list(new cljs.core.Keyword(null,"block","block",664686210));
var inst_61458 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(inst_61434,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803)], 0));
var inst_61459 = cljs.core.keys(inst_61458);
var inst_61460 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_61457,inst_61459);
var state_61509__$1 = (function (){var statearr_61546 = state_61509;
(statearr_61546[(16)] = inst_61456);

(statearr_61546[(17)] = inst_61455);

return statearr_61546;
})();
if(inst_61460){
var statearr_61547_61581 = state_61509__$1;
(statearr_61547_61581[(1)] = (11));

} else {
var statearr_61548_61582 = state_61509__$1;
(statearr_61548_61582[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61510 === (18))){
var inst_61475 = (state_61509[(13)]);
var inst_61450 = (state_61509[(14)]);
var inst_61483 = fluree.db.api.query.format_blocks_resp_pretty(inst_61450,inst_61475);
var state_61509__$1 = state_61509;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61509__$1,(21),inst_61483);
} else {
if((state_val_61510 === (8))){
var state_61509__$1 = state_61509;
var statearr_61549_61583 = state_61509__$1;
(statearr_61549_61583[(2)] = null);

(statearr_61549_61583[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$block_query_async_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$block_query_async_$_state_machine__2879__auto____0 = (function (){
var statearr_61550 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61550[(0)] = fluree$db$api$query$block_query_async_$_state_machine__2879__auto__);

(statearr_61550[(1)] = (1));

return statearr_61550;
});
var fluree$db$api$query$block_query_async_$_state_machine__2879__auto____1 = (function (state_61509){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_61509);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e61551){var ex__2882__auto__ = e61551;
var statearr_61552_61584 = state_61509;
(statearr_61552_61584[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_61509[(4)]))){
var statearr_61553_61585 = state_61509;
(statearr_61553_61585[(1)] = cljs.core.first((state_61509[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61586 = state_61509;
state_61509 = G__61586;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$block_query_async_$_state_machine__2879__auto__ = function(state_61509){
switch(arguments.length){
case 0:
return fluree$db$api$query$block_query_async_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$block_query_async_$_state_machine__2879__auto____1.call(this,state_61509);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$block_query_async_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$block_query_async_$_state_machine__2879__auto____0;
fluree$db$api$query$block_query_async_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$block_query_async_$_state_machine__2879__auto____1;
return fluree$db$api$query$block_query_async_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_61554 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_61554[(6)] = c__2901__auto__);

return statearr_61554;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.api.query.get_history_pattern = (function fluree$db$api$query$get_history_pattern(history){
var subject = ((fluree.db.util.core.subj_ident_QMARK_(history))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [history], null):((cljs.core.sequential_QMARK_(history))?((cljs.core.empty_QMARK_(history))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Please specify an subject for which to search history. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})():history):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
));
var vec__61587 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(0)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(1)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(2)),cljs.core.get.cljs$core$IFn$_invoke$arity$2(subject,(3))], null);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61587,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61587,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61587,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61587,(3),null);
var vec__61590 = (((!((s == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,new cljs.core.Keyword(null,"spot","spot",-1706962147)], null):(((((s == null)) && ((!((p == null)))) && ((o == null))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,s,o,t], null),new cljs.core.Keyword(null,"psot","psot",2111653059)], null):(((((s == null)) && ((!((p == null)))) && ((!((o == null))))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,o,s,t], null),new cljs.core.Keyword(null,"post","post",269697687)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["History query not properly formatted. Must include at least an subject or predicate to query. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(history)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"status","status",-1997798413),(400),new cljs.core.Keyword(null,"error","error",-978969032),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)], null))})()
)));
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61590,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61590,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [pattern,idx], null);
});
fluree.db.api.query.auth_match = (function fluree$db$api$query$auth_match(auth_set,t_map,flake){
var vec__61593 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(t_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.t,new cljs.core.Keyword(null,"auth","auth",1389754926)], null));
var auth = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61593,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__61593,(1),null);
var or__4126__auto__ = (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(auth) : auth_set.call(null,auth));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return (auth_set.cljs$core$IFn$_invoke$arity$1 ? auth_set.cljs$core$IFn$_invoke$arity$1(id) : auth_set.call(null,id));
}
});
fluree.db.api.query.min_safe = (function fluree$db$api$query$min_safe(var_args){
var args__4742__auto__ = [];
var len__4736__auto___61597 = arguments.length;
var i__4737__auto___61598 = (0);
while(true){
if((i__4737__auto___61598 < len__4736__auto___61597)){
args__4742__auto__.push((arguments[i__4737__auto___61598]));

var G__61599 = (i__4737__auto___61598 + (1));
i__4737__auto___61598 = G__61599;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(fluree.db.api.query.min_safe.cljs$core$IFn$_invoke$arity$variadic = (function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,args));
}));

(fluree.db.api.query.min_safe.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.api.query.min_safe.cljs$lang$applyTo = (function (seq61596){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq61596));
}));

fluree.db.api.query.format_history_resp = (function fluree$db$api$query$format_history_resp(db,resp,auth,show_auth){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_61815){
var state_val_61816 = (state_61815[(1)]);
if((state_val_61816 === (7))){
var inst_61715 = (state_61815[(7)]);
var inst_61722 = (state_61815[(8)]);
var inst_61721 = cljs.core.seq(inst_61715);
var inst_61722__$1 = cljs.core.first(inst_61721);
var inst_61723 = cljs.core.next(inst_61721);
var state_61815__$1 = (function (){var statearr_61817 = state_61815;
(statearr_61817[(9)] = inst_61723);

(statearr_61817[(8)] = inst_61722__$1);

return statearr_61817;
})();
if(cljs.core.truth_(inst_61722__$1)){
var statearr_61818_61931 = state_61815__$1;
(statearr_61818_61931[(1)] = (9));

} else {
var statearr_61819_61932 = state_61815__$1;
(statearr_61819_61932[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (20))){
var inst_61805 = (state_61815[(2)]);
var state_61815__$1 = state_61815;
var statearr_61820_61933 = state_61815__$1;
(statearr_61820_61933[(2)] = inst_61805);

(statearr_61820_61933[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (27))){
var inst_61741 = (state_61815[(10)]);
var inst_61759 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_61741);
var state_61815__$1 = state_61815;
var statearr_61821_61934 = state_61815__$1;
(statearr_61821_61934[(2)] = inst_61759);

(statearr_61821_61934[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (1))){
var state_61815__$1 = state_61815;
var statearr_61822_61935 = state_61815__$1;
(statearr_61822_61935[(2)] = null);

(statearr_61822_61935[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (24))){
var state_61815__$1 = state_61815;
var statearr_61823_61936 = state_61815__$1;
(statearr_61823_61936[(2)] = true);

(statearr_61823_61936[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (39))){
var inst_61764 = (state_61815[(11)]);
var inst_61789 = (state_61815[(12)]);
var inst_61763 = (state_61815[(13)]);
var inst_61791 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61792 = [inst_61763,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_61793 = (new cljs.core.PersistentVector(null,2,(5),inst_61791,inst_61792,null));
var inst_61794 = cljs.core.assoc_in(inst_61789,inst_61793,inst_61764);
var state_61815__$1 = state_61815;
var statearr_61825_61937 = state_61815__$1;
(statearr_61825_61937[(2)] = inst_61794);

(statearr_61825_61937[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (4))){
var inst_61601 = (state_61815[(2)]);
var state_61815__$1 = state_61815;
var statearr_61826_61938 = state_61815__$1;
(statearr_61826_61938[(2)] = inst_61601);

(statearr_61826_61938[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (15))){
var inst_61716 = (state_61815[(14)]);
var inst_61723 = (state_61815[(9)]);
var tmp61824 = inst_61716;
var inst_61715 = inst_61723;
var inst_61716__$1 = tmp61824;
var state_61815__$1 = (function (){var statearr_61827 = state_61815;
(statearr_61827[(7)] = inst_61715);

(statearr_61827[(14)] = inst_61716__$1);

return statearr_61827;
})();
var statearr_61828_61939 = state_61815__$1;
(statearr_61828_61939[(2)] = null);

(statearr_61828_61939[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (21))){
var inst_61741 = (state_61815[(10)]);
var inst_61746 = inst_61741.cljs$lang$protocol_mask$partition0$;
var inst_61747 = (inst_61746 & (64));
var inst_61748 = inst_61741.cljs$core$ISeq$;
var inst_61749 = (cljs.core.PROTOCOL_SENTINEL === inst_61748);
var inst_61750 = ((inst_61747) || (inst_61749));
var state_61815__$1 = state_61815;
if(cljs.core.truth_(inst_61750)){
var statearr_61829_61940 = state_61815__$1;
(statearr_61829_61940[(1)] = (24));

} else {
var statearr_61830_61941 = state_61815__$1;
(statearr_61830_61941[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (31))){
var inst_61716 = (state_61815[(14)]);
var state_61815__$1 = state_61815;
var statearr_61831_61942 = state_61815__$1;
(statearr_61831_61942[(2)] = inst_61716);

(statearr_61831_61942[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (32))){
var inst_61773 = (state_61815[(2)]);
var state_61815__$1 = (function (){var statearr_61832 = state_61815;
(statearr_61832[(15)] = inst_61773);

return statearr_61832;
})();
var statearr_61833_61943 = state_61815__$1;
(statearr_61833_61943[(1)] = (33));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (40))){
var inst_61789 = (state_61815[(12)]);
var state_61815__$1 = state_61815;
var statearr_61835_61944 = state_61815__$1;
(statearr_61835_61944[(2)] = inst_61789);

(statearr_61835_61944[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (33))){
var inst_61773 = (state_61815[(15)]);
var inst_61722 = (state_61815[(8)]);
var inst_61763 = (state_61815[(13)]);
var inst_61775 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61776 = [inst_61763,new cljs.core.Keyword(null,"flakes","flakes",1977895739)];
var inst_61777 = (new cljs.core.PersistentVector(null,2,(5),inst_61775,inst_61776,null));
var inst_61778 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_61773,inst_61777,cljs.core.conj,inst_61722);
var state_61815__$1 = state_61815;
var statearr_61836_61945 = state_61815__$1;
(statearr_61836_61945[(2)] = inst_61778);

(statearr_61836_61945[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (13))){
var inst_61725 = (state_61815[(16)]);
var state_61815__$1 = state_61815;
var statearr_61837_61946 = state_61815__$1;
(statearr_61837_61946[(2)] = inst_61725);

(statearr_61837_61946[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (22))){
var state_61815__$1 = state_61815;
var statearr_61838_61947 = state_61815__$1;
(statearr_61838_61947[(2)] = false);

(statearr_61838_61947[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (36))){
var inst_61740 = (state_61815[(17)]);
var inst_61781 = (state_61815[(18)]);
var inst_61763 = (state_61815[(13)]);
var inst_61783 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61784 = [inst_61763,new cljs.core.Keyword(null,"t","t",-1397832519)];
var inst_61785 = (new cljs.core.PersistentVector(null,2,(5),inst_61783,inst_61784,null));
var inst_61786 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_61781,inst_61785,fluree.db.api.query.min_safe,inst_61740);
var state_61815__$1 = state_61815;
var statearr_61839_61948 = state_61815__$1;
(statearr_61839_61948[(2)] = inst_61786);

(statearr_61839_61948[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (41))){
var inst_61723 = (state_61815[(9)]);
var inst_61797 = (state_61815[(2)]);
var inst_61715 = inst_61723;
var inst_61716 = inst_61797;
var state_61815__$1 = (function (){var statearr_61840 = state_61815;
(statearr_61840[(7)] = inst_61715);

(statearr_61840[(14)] = inst_61716);

return statearr_61840;
})();
var statearr_61841_61949 = state_61815__$1;
(statearr_61841_61949[(2)] = null);

(statearr_61841_61949[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (43))){
var state_61815__$1 = state_61815;
var statearr_61842_61950 = state_61815__$1;
(statearr_61842_61950[(2)] = null);

(statearr_61842_61950[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (29))){
var inst_61762 = (state_61815[(2)]);
var inst_61763 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61762,new cljs.core.Keyword(null,"block","block",664686210));
var inst_61764 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61762,new cljs.core.Keyword(null,"auth","auth",1389754926));
var state_61815__$1 = (function (){var statearr_61843 = state_61815;
(statearr_61843[(11)] = inst_61764);

(statearr_61843[(13)] = inst_61763);

return statearr_61843;
})();
var statearr_61844_61951 = state_61815__$1;
(statearr_61844_61951[(1)] = (30));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (44))){
var inst_61803 = (state_61815[(2)]);
var state_61815__$1 = state_61815;
var statearr_61846_61952 = state_61815__$1;
(statearr_61846_61952[(2)] = inst_61803);

(statearr_61846_61952[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (6))){
var inst_61701 = (state_61815[(2)]);
var inst_61702 = fluree.db.util.async.throw_err(inst_61701);
var inst_61710 = resp;
var inst_61711 = cljs.core.seq(inst_61710);
var inst_61712 = cljs.core.first(inst_61711);
var inst_61713 = cljs.core.next(inst_61711);
var inst_61714 = cljs.core.PersistentHashMap.EMPTY;
var inst_61715 = inst_61710;
var inst_61716 = inst_61714;
var state_61815__$1 = (function (){var statearr_61847 = state_61815;
(statearr_61847[(7)] = inst_61715);

(statearr_61847[(14)] = inst_61716);

(statearr_61847[(19)] = inst_61713);

(statearr_61847[(20)] = inst_61702);

(statearr_61847[(21)] = inst_61712);

return statearr_61847;
})();
var statearr_61848_61953 = state_61815__$1;
(statearr_61848_61953[(2)] = null);

(statearr_61848_61953[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (28))){
var inst_61741 = (state_61815[(10)]);
var state_61815__$1 = state_61815;
var statearr_61849_61954 = state_61815__$1;
(statearr_61849_61954[(2)] = inst_61741);

(statearr_61849_61954[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (25))){
var state_61815__$1 = state_61815;
var statearr_61850_61955 = state_61815__$1;
(statearr_61850_61955[(2)] = false);

(statearr_61850_61955[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (34))){
var inst_61773 = (state_61815[(15)]);
var state_61815__$1 = state_61815;
var statearr_61851_61956 = state_61815__$1;
(statearr_61851_61956[(2)] = inst_61773);

(statearr_61851_61956[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (17))){
var inst_61807 = (state_61815[(2)]);
var state_61815__$1 = state_61815;
var statearr_61852_61957 = state_61815__$1;
(statearr_61852_61957[(2)] = inst_61807);

(statearr_61852_61957[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (3))){
var inst_61813 = (state_61815[(2)]);
var state_61815__$1 = state_61815;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61815__$1,inst_61813);
} else {
if((state_val_61816 === (12))){
var inst_61702 = (state_61815[(20)]);
var inst_61722 = (state_61815[(8)]);
var inst_61727 = fluree.db.api.query.auth_match(auth,inst_61702,inst_61722);
var inst_61728 = cljs.core.not(inst_61727);
var state_61815__$1 = state_61815;
var statearr_61853_61958 = state_61815__$1;
(statearr_61853_61958[(2)] = inst_61728);

(statearr_61853_61958[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (2))){
var _ = (function (){var statearr_61854 = state_61815;
(statearr_61854[(4)] = cljs.core.cons((5),(state_61815[(4)])));

return statearr_61854;
})();
var inst_61607 = (function (){return (function (p1__61600_SHARP_){
return p1__61600_SHARP_.t;
});
})();
var inst_61608 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_61607,resp);
var inst_61609 = cljs.core.set(inst_61608);
var inst_61697 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_61698 = (function (){var ts = inst_61609;
var c__2901__auto____$1 = inst_61697;
return (function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_61695){
var state_val_61696 = (state_61695[(1)]);
if((state_val_61696 === (7))){
var inst_61629 = (state_61695[(7)]);
var inst_61641 = (state_61695[(8)]);
var inst_61623 = (state_61695[(9)]);
var inst_61635 = (state_61695[(10)]);
var inst_61634 = (state_61695[(2)]);
var inst_61635__$1 = fluree.db.util.async.throw_err(inst_61634);
var inst_61637 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61638 = [inst_61629,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61639 = (new cljs.core.PersistentVector(null,2,(5),inst_61637,inst_61638,null));
var inst_61640 = cljs.core.assoc_in(inst_61623,inst_61639,inst_61635__$1);
var inst_61641__$1 = auth;
var state_61695__$1 = (function (){var statearr_61855 = state_61695;
(statearr_61855[(8)] = inst_61641__$1);

(statearr_61855[(10)] = inst_61635__$1);

(statearr_61855[(11)] = inst_61640);

return statearr_61855;
})();
if(cljs.core.truth_(inst_61641__$1)){
var statearr_61856_61959 = state_61695__$1;
(statearr_61856_61959[(1)] = (8));

} else {
var statearr_61857_61960 = state_61695__$1;
(statearr_61857_61960[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61696 === (1))){
var inst_61617 = (state_61695[(12)]);
var inst_61617__$1 = ts;
var inst_61618 = cljs.core.seq(inst_61617__$1);
var inst_61619 = cljs.core.first(inst_61618);
var inst_61620 = cljs.core.next(inst_61618);
var inst_61621 = cljs.core.PersistentHashMap.EMPTY;
var inst_61622 = inst_61617__$1;
var inst_61623 = inst_61621;
var state_61695__$1 = (function (){var statearr_61858 = state_61695;
(statearr_61858[(12)] = inst_61617__$1);

(statearr_61858[(13)] = inst_61620);

(statearr_61858[(14)] = inst_61622);

(statearr_61858[(9)] = inst_61623);

(statearr_61858[(15)] = inst_61619);

return statearr_61858;
})();
var statearr_61859_61961 = state_61695__$1;
(statearr_61859_61961[(2)] = null);

(statearr_61859_61961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61696 === (4))){
var inst_61629 = (state_61695[(7)]);
var inst_61632 = fluree.db.time_travel.non_border_t_to_block(db,inst_61629);
var state_61695__$1 = state_61695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61695__$1,(7),inst_61632);
} else {
if((state_val_61696 === (13))){
var inst_61630 = (state_61695[(16)]);
var inst_61687 = (state_61695[(2)]);
var inst_61622 = inst_61630;
var inst_61623 = inst_61687;
var state_61695__$1 = (function (){var statearr_61860 = state_61695;
(statearr_61860[(14)] = inst_61622);

(statearr_61860[(9)] = inst_61623);

return statearr_61860;
})();
var statearr_61861_61962 = state_61695__$1;
(statearr_61861_61962[(2)] = null);

(statearr_61861_61962[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61696 === (6))){
var inst_61691 = (state_61695[(2)]);
var state_61695__$1 = state_61695;
var statearr_61862_61963 = state_61695__$1;
(statearr_61862_61963[(2)] = inst_61691);

(statearr_61862_61963[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61696 === (3))){
var inst_61693 = (state_61695[(2)]);
var state_61695__$1 = state_61695;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61695__$1,inst_61693);
} else {
if((state_val_61696 === (12))){
var inst_61640 = (state_61695[(11)]);
var state_61695__$1 = state_61695;
var statearr_61863_61964 = state_61695__$1;
(statearr_61863_61964[(2)] = inst_61640);

(statearr_61863_61964[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61696 === (2))){
var inst_61629 = (state_61695[(7)]);
var inst_61622 = (state_61695[(14)]);
var inst_61628 = cljs.core.seq(inst_61622);
var inst_61629__$1 = cljs.core.first(inst_61628);
var inst_61630 = cljs.core.next(inst_61628);
var state_61695__$1 = (function (){var statearr_61864 = state_61695;
(statearr_61864[(7)] = inst_61629__$1);

(statearr_61864[(16)] = inst_61630);

return statearr_61864;
})();
if(cljs.core.truth_(inst_61629__$1)){
var statearr_61865_61965 = state_61695__$1;
(statearr_61865_61965[(1)] = (4));

} else {
var statearr_61866_61966 = state_61695__$1;
(statearr_61866_61966[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61696 === (11))){
var inst_61617 = (state_61695[(12)]);
var inst_61620 = (state_61695[(13)]);
var inst_61629 = (state_61695[(7)]);
var inst_61622 = (state_61695[(14)]);
var inst_61623 = (state_61695[(9)]);
var inst_61635 = (state_61695[(10)]);
var inst_61640 = (state_61695[(11)]);
var inst_61619 = (state_61695[(15)]);
var inst_61630 = (state_61695[(16)]);
var inst_61647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61648 = [inst_61629,new cljs.core.Keyword(null,"auth","auth",1389754926)];
var inst_61649 = (new cljs.core.PersistentVector(null,2,(5),inst_61647,inst_61648,null));
var inst_61662 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_61663 = (function (){var t = inst_61629;
var G__61636 = inst_61640;
var vec__61614 = inst_61617;
var first__61616 = inst_61619;
var seq__61615 = inst_61620;
var block = inst_61635;
var r = inst_61630;
var c__2901__auto____$2 = inst_61662;
var acc = inst_61623;
var G__61613 = inst_61622;
var seq__61626 = inst_61630;
var first__61627 = inst_61629;
var vec__61625 = inst_61622;
return (function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_61660){
var state_val_61661 = (state_61660[(1)]);
if((state_val_61661 === (1))){
var state_61660__$1 = state_61660;
var statearr_61867_61967 = state_61660__$1;
(statearr_61867_61967[(2)] = null);

(statearr_61867_61967[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61661 === (2))){
var ___$1 = (function (){var statearr_61868 = state_61660;
(statearr_61868[(4)] = cljs.core.cons((5),(state_61660[(4)])));

return statearr_61868;
})();
var ___$2 = (function (){var statearr_61869 = state_61660;
(statearr_61869[(4)] = cljs.core.rest((state_61660[(4)])));

return statearr_61869;
})();
var state_61660__$1 = state_61660;
var statearr_61870_61968 = state_61660__$1;
(statearr_61870_61968[(2)] = db);

(statearr_61870_61968[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61661 === (3))){
var inst_61658 = (state_61660[(2)]);
var state_61660__$1 = state_61660;
return cljs.core.async.impl.ioc_helpers.return_chan(state_61660__$1,inst_61658);
} else {
if((state_val_61661 === (4))){
var inst_61650 = (state_61660[(2)]);
var state_61660__$1 = state_61660;
var statearr_61872_61969 = state_61660__$1;
(statearr_61872_61969[(2)] = inst_61650);

(statearr_61872_61969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61661 === (5))){
var ___$1 = (function (){var statearr_61873 = state_61660;
(statearr_61873[(4)] = cljs.core.rest((state_61660[(4)])));

return statearr_61873;
})();
var state_61660__$1 = state_61660;
var ex61871 = (state_61660__$1[(2)]);
var statearr_61874_61970 = state_61660__$1;
(statearr_61874_61970[(5)] = ex61871);


if((ex61871 instanceof Error)){
var statearr_61875_61971 = state_61660__$1;
(statearr_61875_61971[(1)] = (4));

(statearr_61875_61971[(5)] = null);

} else {
throw ex61871;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____0 = (function (){
var statearr_61876 = [null,null,null,null,null,null,null];
(statearr_61876[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__);

(statearr_61876[(1)] = (1));

return statearr_61876;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____1 = (function (state_61660){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_61660);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e61877){var ex__2882__auto__ = e61877;
var statearr_61878_61972 = state_61660;
(statearr_61878_61972[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_61660[(4)]))){
var statearr_61879_61973 = state_61660;
(statearr_61879_61973[(1)] = cljs.core.first((state_61660[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61974 = state_61660;
state_61660 = G__61974;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__ = function(state_61660){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____1.call(this,state_61660);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_61880 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_61880[(6)] = c__2901__auto____$2);

return statearr_61880;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
});
})();
var inst_61664 = cljs.core.async.impl.dispatch.run(inst_61663);
var inst_61665 = [new cljs.core.Keyword(null,"selectOne","selectOne",1588429876),new cljs.core.Keyword(null,"where","where",-2044795965)];
var inst_61666 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61667 = ["?auth","?id"];
var inst_61668 = (new cljs.core.PersistentVector(null,2,(5),inst_61666,inst_61667,null));
var inst_61669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61670 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61671 = [inst_61629,"_tx/auth","?auth"];
var inst_61672 = (new cljs.core.PersistentVector(null,3,(5),inst_61670,inst_61671,null));
var inst_61673 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61674 = ["?auth","_auth/id","?id"];
var inst_61675 = (new cljs.core.PersistentVector(null,3,(5),inst_61673,inst_61674,null));
var inst_61676 = [inst_61672,inst_61675];
var inst_61677 = (new cljs.core.PersistentVector(null,2,(5),inst_61669,inst_61676,null));
var inst_61678 = [inst_61668,inst_61677];
var inst_61679 = cljs.core.PersistentHashMap.fromArrays(inst_61665,inst_61678);
var inst_61680 = (fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query_async.cljs$core$IFn$_invoke$arity$2(inst_61662,inst_61679) : fluree.db.api.query.query_async.call(null,inst_61662,inst_61679));
var state_61695__$1 = (function (){var statearr_61881 = state_61695;
(statearr_61881[(17)] = inst_61664);

(statearr_61881[(18)] = inst_61649);

return statearr_61881;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61695__$1,(14),inst_61680);
} else {
if((state_val_61696 === (9))){
var state_61695__$1 = state_61695;
var statearr_61882_61975 = state_61695__$1;
(statearr_61882_61975[(2)] = show_auth);

(statearr_61882_61975[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61696 === (5))){
var inst_61623 = (state_61695[(9)]);
var state_61695__$1 = state_61695;
var statearr_61883_61976 = state_61695__$1;
(statearr_61883_61976[(2)] = inst_61623);

(statearr_61883_61976[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61696 === (14))){
var inst_61640 = (state_61695[(11)]);
var inst_61649 = (state_61695[(18)]);
var inst_61682 = (state_61695[(2)]);
var inst_61683 = fluree.db.util.async.throw_err(inst_61682);
var inst_61684 = cljs.core.assoc_in(inst_61640,inst_61649,inst_61683);
var state_61695__$1 = state_61695;
var statearr_61884_61977 = state_61695__$1;
(statearr_61884_61977[(2)] = inst_61684);

(statearr_61884_61977[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61696 === (10))){
var inst_61645 = (state_61695[(2)]);
var state_61695__$1 = state_61695;
if(cljs.core.truth_(inst_61645)){
var statearr_61885_61978 = state_61695__$1;
(statearr_61885_61978[(1)] = (11));

} else {
var statearr_61886_61979 = state_61695__$1;
(statearr_61886_61979[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61696 === (8))){
var inst_61641 = (state_61695[(8)]);
var state_61695__$1 = state_61695;
var statearr_61887_61980 = state_61695__$1;
(statearr_61887_61980[(2)] = inst_61641);

(statearr_61887_61980[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____0 = (function (){
var statearr_61888 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61888[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__);

(statearr_61888[(1)] = (1));

return statearr_61888;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____1 = (function (state_61695){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_61695);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e61889){var ex__2882__auto__ = e61889;
var statearr_61890_61981 = state_61695;
(statearr_61890_61981[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_61695[(4)]))){
var statearr_61891_61982 = state_61695;
(statearr_61891_61982[(1)] = cljs.core.first((state_61695[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__61983 = state_61695;
state_61695 = G__61983;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__ = function(state_61695){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____1.call(this,state_61695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_61892 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_61892[(6)] = c__2901__auto____$1);

return statearr_61892;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
});
})();
var inst_61699 = cljs.core.async.impl.dispatch.run(inst_61698);
var state_61815__$1 = (function (){var statearr_61893 = state_61815;
(statearr_61893[(22)] = inst_61699);

return statearr_61893;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_61815__$1,(6),inst_61697);
} else {
if((state_val_61816 === (23))){
var inst_61757 = (state_61815[(2)]);
var state_61815__$1 = state_61815;
if(cljs.core.truth_(inst_61757)){
var statearr_61894_61984 = state_61815__$1;
(statearr_61894_61984[(1)] = (27));

} else {
var statearr_61895_61985 = state_61815__$1;
(statearr_61895_61985[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (35))){
var inst_61781 = (state_61815[(2)]);
var state_61815__$1 = (function (){var statearr_61896 = state_61815;
(statearr_61896[(18)] = inst_61781);

return statearr_61896;
})();
var statearr_61897_61986 = state_61815__$1;
(statearr_61897_61986[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (19))){
var state_61815__$1 = state_61815;
var statearr_61899_61987 = state_61815__$1;
(statearr_61899_61987[(1)] = (42));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (11))){
var inst_61734 = (state_61815[(2)]);
var state_61815__$1 = state_61815;
if(cljs.core.truth_(inst_61734)){
var statearr_61902_61988 = state_61815__$1;
(statearr_61902_61988[(1)] = (15));

} else {
var statearr_61903_61989 = state_61815__$1;
(statearr_61903_61989[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (9))){
var inst_61725 = (state_61815[(16)]);
var inst_61725__$1 = auth;
var state_61815__$1 = (function (){var statearr_61904 = state_61815;
(statearr_61904[(16)] = inst_61725__$1);

return statearr_61904;
})();
if(cljs.core.truth_(inst_61725__$1)){
var statearr_61905_61990 = state_61815__$1;
(statearr_61905_61990[(1)] = (12));

} else {
var statearr_61906_61991 = state_61815__$1;
(statearr_61906_61991[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (5))){
var _ = (function (){var statearr_61907 = state_61815;
(statearr_61907[(4)] = cljs.core.rest((state_61815[(4)])));

return statearr_61907;
})();
var state_61815__$1 = state_61815;
var ex61901 = (state_61815__$1[(2)]);
var statearr_61908_61992 = state_61815__$1;
(statearr_61908_61992[(5)] = ex61901);


if((ex61901 instanceof Error)){
var statearr_61909_61993 = state_61815__$1;
(statearr_61909_61993[(1)] = (4));

(statearr_61909_61993[(5)] = null);

} else {
throw ex61901;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (14))){
var inst_61731 = (state_61815[(2)]);
var state_61815__$1 = state_61815;
var statearr_61910_61994 = state_61815__$1;
(statearr_61910_61994[(2)] = inst_61731);

(statearr_61910_61994[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (26))){
var inst_61754 = (state_61815[(2)]);
var state_61815__$1 = state_61815;
var statearr_61911_61995 = state_61815__$1;
(statearr_61911_61995[(2)] = inst_61754);

(statearr_61911_61995[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (16))){
var inst_61722 = (state_61815[(8)]);
var state_61815__$1 = state_61815;
if(cljs.core.truth_(inst_61722)){
var statearr_61912_61996 = state_61815__$1;
(statearr_61912_61996[(1)] = (18));

} else {
var statearr_61913_61997 = state_61815__$1;
(statearr_61913_61997[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (38))){
var inst_61789 = (state_61815[(2)]);
var state_61815__$1 = (function (){var statearr_61914 = state_61815;
(statearr_61914[(12)] = inst_61789);

return statearr_61914;
})();
if(cljs.core.truth_(show_auth)){
var statearr_61915_61998 = state_61815__$1;
(statearr_61915_61998[(1)] = (39));

} else {
var statearr_61916_61999 = state_61815__$1;
(statearr_61916_61999[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (30))){
var inst_61716 = (state_61815[(14)]);
var inst_61763 = (state_61815[(13)]);
var inst_61767 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_61768 = [inst_61763,new cljs.core.Keyword(null,"block","block",664686210)];
var inst_61769 = (new cljs.core.PersistentVector(null,2,(5),inst_61767,inst_61768,null));
var inst_61770 = cljs.core.assoc_in(inst_61716,inst_61769,inst_61763);
var state_61815__$1 = state_61815;
var statearr_61917_62000 = state_61815__$1;
(statearr_61917_62000[(2)] = inst_61770);

(statearr_61917_62000[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (10))){
var inst_61722 = (state_61815[(8)]);
var state_61815__$1 = state_61815;
var statearr_61918_62001 = state_61815__$1;
(statearr_61918_62001[(2)] = inst_61722);

(statearr_61918_62001[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (18))){
var inst_61740 = (state_61815[(17)]);
var inst_61741 = (state_61815[(10)]);
var inst_61702 = (state_61815[(20)]);
var inst_61722 = (state_61815[(8)]);
var inst_61740__$1 = inst_61722.t;
var inst_61741__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_61702,inst_61740__$1);
var inst_61743 = (inst_61741__$1 == null);
var inst_61744 = cljs.core.not(inst_61743);
var state_61815__$1 = (function (){var statearr_61919 = state_61815;
(statearr_61919[(17)] = inst_61740__$1);

(statearr_61919[(10)] = inst_61741__$1);

return statearr_61919;
})();
if(inst_61744){
var statearr_61920_62002 = state_61815__$1;
(statearr_61920_62002[(1)] = (21));

} else {
var statearr_61921_62003 = state_61815__$1;
(statearr_61921_62003[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (42))){
var inst_61716 = (state_61815[(14)]);
var state_61815__$1 = state_61815;
var statearr_61922_62004 = state_61815__$1;
(statearr_61922_62004[(2)] = inst_61716);

(statearr_61922_62004[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (37))){
var inst_61781 = (state_61815[(18)]);
var state_61815__$1 = state_61815;
var statearr_61923_62005 = state_61815__$1;
(statearr_61923_62005[(2)] = inst_61781);

(statearr_61923_62005[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_61816 === (8))){
var inst_61809 = (state_61815[(2)]);
var inst_61810 = cljs.core.vals(inst_61809);
var _ = (function (){var statearr_61924 = state_61815;
(statearr_61924[(4)] = cljs.core.rest((state_61815[(4)])));

return statearr_61924;
})();
var state_61815__$1 = state_61815;
var statearr_61925_62006 = state_61815__$1;
(statearr_61925_62006[(2)] = inst_61810);

(statearr_61925_62006[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____0 = (function (){
var statearr_61926 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_61926[(0)] = fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__);

(statearr_61926[(1)] = (1));

return statearr_61926;
});
var fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____1 = (function (state_61815){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_61815);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e61927){var ex__2882__auto__ = e61927;
var statearr_61928_62007 = state_61815;
(statearr_61928_62007[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_61815[(4)]))){
var statearr_61929_62008 = state_61815;
(statearr_61929_62008[(1)] = cljs.core.first((state_61815[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62009 = state_61815;
state_61815 = G__62009;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__ = function(state_61815){
switch(arguments.length){
case 0:
return fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____1.call(this,state_61815);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____0;
fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$format_history_resp_$_state_machine__2879__auto____1;
return fluree$db$api$query$format_history_resp_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_61930 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_61930[(6)] = c__2901__auto__);

return statearr_61930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
fluree.db.api.query.history_query_async = (function fluree$db$api$query$history_query_async(sources,query_map){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_62155){
var state_val_62156 = (state_62155[(1)]);
if((state_val_62156 === (7))){
var state_62155__$1 = state_62155;
var statearr_62157_62233 = state_62155__$1;
(statearr_62157_62233[(2)] = false);

(statearr_62157_62233[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (20))){
var inst_62061 = (state_62155[(7)]);
var inst_62049 = (state_62155[(8)]);
var inst_62071 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_62049);
var state_62155__$1 = (function (){var statearr_62158 = state_62155;
(statearr_62158[(9)] = inst_62071);

return statearr_62158;
})();
if(cljs.core.truth_(inst_62061)){
var statearr_62159_62234 = state_62155__$1;
(statearr_62159_62234[(1)] = (23));

} else {
var statearr_62160_62235 = state_62155__$1;
(statearr_62160_62235[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (27))){
var state_62155__$1 = state_62155;
var statearr_62161_62236 = state_62155__$1;
(statearr_62161_62236[(2)] = (-1));

(statearr_62161_62236[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (1))){
var state_62155__$1 = state_62155;
var statearr_62162_62237 = state_62155__$1;
(statearr_62162_62237[(2)] = null);

(statearr_62162_62237[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (24))){
var inst_62061 = (state_62155[(7)]);
var state_62155__$1 = state_62155;
var statearr_62163_62238 = state_62155__$1;
(statearr_62163_62238[(2)] = inst_62061);

(statearr_62163_62238[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (39))){
var inst_62047 = (state_62155[(10)]);
var state_62155__$1 = state_62155;
var statearr_62164_62239 = state_62155__$1;
(statearr_62164_62239[(2)] = inst_62047);

(statearr_62164_62239[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (46))){
var inst_62120 = (state_62155[(11)]);
var state_62155__$1 = state_62155;
var statearr_62165_62240 = state_62155__$1;
(statearr_62165_62240[(2)] = inst_62120);

(statearr_62165_62240[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (4))){
var inst_62010 = (state_62155[(2)]);
var state_62155__$1 = state_62155;
var statearr_62166_62241 = state_62155__$1;
(statearr_62166_62241[(2)] = inst_62010);

(statearr_62166_62241[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (15))){
var inst_62042 = (state_62155[(12)]);
var inst_62051 = (state_62155[(2)]);
var inst_62052 = fluree.db.util.async.throw_err(inst_62051);
var state_62155__$1 = (function (){var statearr_62167 = state_62155;
(statearr_62167[(13)] = inst_62052);

return statearr_62167;
})();
if(cljs.core.truth_(inst_62042)){
var statearr_62168_62242 = state_62155__$1;
(statearr_62168_62242[(1)] = (16));

} else {
var statearr_62169_62243 = state_62155__$1;
(statearr_62169_62243[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (48))){
var inst_62128 = (state_62155[(2)]);
var inst_62129 = fluree.db.util.async.throw_err(inst_62128);
var state_62155__$1 = state_62155;
var statearr_62170_62244 = state_62155__$1;
(statearr_62170_62244[(2)] = inst_62129);

(statearr_62170_62244[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (50))){
var inst_62132 = (state_62155[(14)]);
var state_62155__$1 = state_62155;
var statearr_62171_62245 = state_62155__$1;
(statearr_62171_62245[(2)] = inst_62132);

(statearr_62171_62245[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (21))){
var inst_62142 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_62143 = ["History query not properly formatted. Provided ",inst_62142].join('');
var inst_62144 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62145 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_62146 = cljs.core.PersistentHashMap.fromArrays(inst_62144,inst_62145);
var inst_62147 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_62143,inst_62146);
var inst_62148 = (function(){throw inst_62147})();
var state_62155__$1 = state_62155;
var statearr_62172_62246 = state_62155__$1;
(statearr_62172_62246[(2)] = inst_62148);

(statearr_62172_62246[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (31))){
var inst_62052 = (state_62155[(13)]);
var inst_62095 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_62052);
var state_62155__$1 = state_62155;
var statearr_62173_62247 = state_62155__$1;
(statearr_62173_62247[(2)] = inst_62095);

(statearr_62173_62247[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (32))){
var inst_62087 = (state_62155[(15)]);
var inst_62052 = (state_62155[(13)]);
var inst_62043 = (state_62155[(16)]);
var inst_62097 = (state_62155[(2)]);
var inst_62098 = fluree.db.api.query.get_history_pattern(inst_62043);
var inst_62099 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62098,(0),null);
var inst_62100 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62098,(1),null);
var inst_62101 = [new cljs.core.Keyword(null,"from-t","from-t",1730913525),new cljs.core.Keyword(null,"to-t","to-t",569467359)];
var inst_62102 = [inst_62087,inst_62097];
var inst_62103 = cljs.core.PersistentHashMap.fromArrays(inst_62101,inst_62102);
var inst_62104 = fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(inst_62052,inst_62100,cljs.core._EQ_,inst_62099,inst_62103);
var state_62155__$1 = state_62155;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62155__$1,(34),inst_62104);
} else {
if((state_val_62156 === (40))){
var inst_62046 = (state_62155[(17)]);
var state_62155__$1 = state_62155;
var statearr_62174_62248 = state_62155__$1;
(statearr_62174_62248[(2)] = inst_62046);

(statearr_62174_62248[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (33))){
var inst_62091 = (state_62155[(2)]);
var inst_62092 = fluree.db.util.async.throw_err(inst_62091);
var inst_62093 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_62092);
var state_62155__$1 = state_62155;
var statearr_62175_62249 = state_62155__$1;
(statearr_62175_62249[(2)] = inst_62093);

(statearr_62175_62249[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (13))){
var inst_62020 = (state_62155[(18)]);
var state_62155__$1 = state_62155;
var statearr_62176_62250 = state_62155__$1;
(statearr_62176_62250[(2)] = inst_62020);

(statearr_62176_62250[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (22))){
var inst_62150 = (state_62155[(2)]);
var _ = (function (){var statearr_62177 = state_62155;
(statearr_62177[(4)] = cljs.core.rest((state_62155[(4)])));

return statearr_62177;
})();
var state_62155__$1 = state_62155;
var statearr_62178_62251 = state_62155__$1;
(statearr_62178_62251[(2)] = inst_62150);

(statearr_62178_62251[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (36))){
var state_62155__$1 = state_62155;
var statearr_62179_62252 = state_62155__$1;
(statearr_62179_62252[(2)] = null);

(statearr_62179_62252[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (41))){
var inst_62052 = (state_62155[(13)]);
var inst_62107 = (state_62155[(19)]);
var inst_62112 = (state_62155[(20)]);
var inst_62116 = (state_62155[(2)]);
var inst_62117 = fluree.db.api.query.format_history_resp(inst_62052,inst_62107,inst_62112,inst_62116);
var state_62155__$1 = state_62155;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62155__$1,(38),inst_62117);
} else {
if((state_val_62156 === (43))){
var inst_62044 = (state_62155[(21)]);
var state_62155__$1 = state_62155;
var statearr_62180_62253 = state_62155__$1;
(statearr_62180_62253[(2)] = inst_62044);

(statearr_62180_62253[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (29))){
var inst_62081 = (state_62155[(2)]);
var inst_62082 = fluree.db.util.async.throw_err(inst_62081);
var inst_62083 = new cljs.core.Keyword(null,"t","t",-1397832519).cljs$core$IFn$_invoke$arity$1(inst_62082);
var inst_62084 = (inst_62083 - (1));
var state_62155__$1 = state_62155;
var statearr_62181_62254 = state_62155__$1;
(statearr_62181_62254[(2)] = inst_62084);

(statearr_62181_62254[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (44))){
var inst_62124 = (state_62155[(2)]);
var state_62155__$1 = state_62155;
if(cljs.core.truth_(inst_62124)){
var statearr_62182_62255 = state_62155__$1;
(statearr_62182_62255[(1)] = (45));

} else {
var statearr_62183_62256 = state_62155__$1;
(statearr_62183_62256[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (6))){
var inst_62020 = (state_62155[(18)]);
var inst_62025 = inst_62020.cljs$lang$protocol_mask$partition0$;
var inst_62026 = (inst_62025 & (64));
var inst_62027 = inst_62020.cljs$core$ISeq$;
var inst_62028 = (cljs.core.PROTOCOL_SENTINEL === inst_62027);
var inst_62029 = ((inst_62026) || (inst_62028));
var state_62155__$1 = state_62155;
if(cljs.core.truth_(inst_62029)){
var statearr_62184_62257 = state_62155__$1;
(statearr_62184_62257[(1)] = (9));

} else {
var statearr_62185_62258 = state_62155__$1;
(statearr_62185_62258[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (28))){
var inst_62062 = (state_62155[(22)]);
var inst_62087 = (state_62155[(2)]);
var state_62155__$1 = (function (){var statearr_62186 = state_62155;
(statearr_62186[(15)] = inst_62087);

return statearr_62186;
})();
if(cljs.core.truth_(inst_62062)){
var statearr_62187_62259 = state_62155__$1;
(statearr_62187_62259[(1)] = (30));

} else {
var statearr_62188_62260 = state_62155__$1;
(statearr_62188_62260[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (51))){
var inst_62140 = (state_62155[(2)]);
var state_62155__$1 = state_62155;
var statearr_62189_62261 = state_62155__$1;
(statearr_62189_62261[(2)] = inst_62140);

(statearr_62189_62261[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (25))){
var inst_62076 = (state_62155[(2)]);
var state_62155__$1 = state_62155;
if(cljs.core.truth_(inst_62076)){
var statearr_62190_62262 = state_62155__$1;
(statearr_62190_62262[(1)] = (26));

} else {
var statearr_62191_62263 = state_62155__$1;
(statearr_62191_62263[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (34))){
var inst_62048 = (state_62155[(23)]);
var inst_62106 = (state_62155[(2)]);
var inst_62107 = fluree.db.util.async.throw_err(inst_62106);
var state_62155__$1 = (function (){var statearr_62192 = state_62155;
(statearr_62192[(19)] = inst_62107);

return statearr_62192;
})();
if(cljs.core.truth_(inst_62048)){
var statearr_62193_62264 = state_62155__$1;
(statearr_62193_62264[(1)] = (35));

} else {
var statearr_62194_62265 = state_62155__$1;
(statearr_62194_62265[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (17))){
var state_62155__$1 = state_62155;
var statearr_62195_62266 = state_62155__$1;
(statearr_62195_62266[(2)] = null);

(statearr_62195_62266[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (3))){
var inst_62153 = (state_62155[(2)]);
var state_62155__$1 = state_62155;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62155__$1,inst_62153);
} else {
if((state_val_62156 === (12))){
var inst_62020 = (state_62155[(18)]);
var inst_62038 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_62020);
var state_62155__$1 = state_62155;
var statearr_62196_62267 = state_62155__$1;
(statearr_62196_62267[(2)] = inst_62038);

(statearr_62196_62267[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (2))){
var inst_62020 = (state_62155[(18)]);
var _ = (function (){var statearr_62197 = state_62155;
(statearr_62197[(4)] = cljs.core.cons((5),(state_62155[(4)])));

return statearr_62197;
})();
var inst_62020__$1 = query_map;
var inst_62022 = (inst_62020__$1 == null);
var inst_62023 = cljs.core.not(inst_62022);
var state_62155__$1 = (function (){var statearr_62198 = state_62155;
(statearr_62198[(18)] = inst_62020__$1);

return statearr_62198;
})();
if(inst_62023){
var statearr_62199_62268 = state_62155__$1;
(statearr_62199_62268[(1)] = (6));

} else {
var statearr_62200_62269 = state_62155__$1;
(statearr_62200_62269[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (23))){
var inst_62061 = (state_62155[(7)]);
var inst_62073 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_62061);
var state_62155__$1 = state_62155;
var statearr_62201_62270 = state_62155__$1;
(statearr_62201_62270[(2)] = inst_62073);

(statearr_62201_62270[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (47))){
var inst_62071 = (state_62155[(9)]);
var inst_62132 = (state_62155[(2)]);
var state_62155__$1 = (function (){var statearr_62202 = state_62155;
(statearr_62202[(14)] = inst_62132);

return statearr_62202;
})();
if(cljs.core.truth_(inst_62071)){
var statearr_62203_62271 = state_62155__$1;
(statearr_62203_62271[(1)] = (49));

} else {
var statearr_62204_62272 = state_62155__$1;
(statearr_62204_62272[(1)] = (50));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (35))){
var inst_62048 = (state_62155[(23)]);
var inst_62109 = cljs.core.set(inst_62048);
var state_62155__$1 = state_62155;
var statearr_62205_62273 = state_62155__$1;
(statearr_62205_62273[(2)] = inst_62109);

(statearr_62205_62273[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (19))){
var inst_62056 = (state_62155[(2)]);
var inst_62057 = fluree.db.util.async.throw_err(inst_62056);
var state_62155__$1 = state_62155;
var statearr_62206_62274 = state_62155__$1;
(statearr_62206_62274[(2)] = inst_62057);

(statearr_62206_62274[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (11))){
var inst_62033 = (state_62155[(2)]);
var state_62155__$1 = state_62155;
var statearr_62208_62275 = state_62155__$1;
(statearr_62208_62275[(2)] = inst_62033);

(statearr_62208_62275[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (9))){
var state_62155__$1 = state_62155;
var statearr_62209_62276 = state_62155__$1;
(statearr_62209_62276[(2)] = true);

(statearr_62209_62276[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (5))){
var _ = (function (){var statearr_62210 = state_62155;
(statearr_62210[(4)] = cljs.core.rest((state_62155[(4)])));

return statearr_62210;
})();
var state_62155__$1 = state_62155;
var ex62207 = (state_62155__$1[(2)]);
var statearr_62211_62277 = state_62155__$1;
(statearr_62211_62277[(5)] = ex62207);


if((ex62207 instanceof Error)){
var statearr_62212_62278 = state_62155__$1;
(statearr_62212_62278[(1)] = (4));

(statearr_62212_62278[(5)] = null);

} else {
throw ex62207;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (14))){
var inst_62041 = (state_62155[(2)]);
var inst_62042 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62041,new cljs.core.Keyword(null,"block","block",664686210));
var inst_62043 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62041,new cljs.core.Keyword(null,"history","history",-247395220));
var inst_62044 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62041,new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013));
var inst_62045 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62041,new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803));
var inst_62046 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62041,new cljs.core.Keyword(null,"show-auth","show-auth",686103141));
var inst_62047 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62041,new cljs.core.Keyword(null,"showAuth","showAuth",-347871529));
var inst_62048 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62041,new cljs.core.Keyword(null,"auth","auth",1389754926));
var inst_62049 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62041,new cljs.core.Keyword(null,"opts","opts",155075701));
var state_62155__$1 = (function (){var statearr_62213 = state_62155;
(statearr_62213[(21)] = inst_62044);

(statearr_62213[(17)] = inst_62046);

(statearr_62213[(12)] = inst_62042);

(statearr_62213[(24)] = inst_62045);

(statearr_62213[(16)] = inst_62043);

(statearr_62213[(8)] = inst_62049);

(statearr_62213[(10)] = inst_62047);

(statearr_62213[(23)] = inst_62048);

return statearr_62213;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62155__$1,(15),sources);
} else {
if((state_val_62156 === (45))){
var inst_62120 = (state_62155[(11)]);
var inst_62052 = (state_62155[(13)]);
var inst_62126 = fluree.db.api.query.format_blocks_resp_pretty(inst_62052,inst_62120);
var state_62155__$1 = state_62155;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62155__$1,(48),inst_62126);
} else {
if((state_val_62156 === (26))){
var inst_62061 = (state_62155[(7)]);
var inst_62052 = (state_62155[(13)]);
var inst_62078 = (inst_62061 - (1));
var inst_62079 = fluree.db.time_travel.as_of_block(inst_62052,inst_62078);
var state_62155__$1 = state_62155;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62155__$1,(29),inst_62079);
} else {
if((state_val_62156 === (16))){
var inst_62052 = (state_62155[(13)]);
var inst_62054 = fluree.db.api.query.resolve_block_range(inst_62052,query_map);
var state_62155__$1 = state_62155;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62155__$1,(19),inst_62054);
} else {
if((state_val_62156 === (38))){
var inst_62045 = (state_62155[(24)]);
var inst_62119 = (state_62155[(2)]);
var inst_62120 = fluree.db.util.async.throw_err(inst_62119);
var state_62155__$1 = (function (){var statearr_62214 = state_62155;
(statearr_62214[(11)] = inst_62120);

return statearr_62214;
})();
if(cljs.core.truth_(inst_62045)){
var statearr_62215_62279 = state_62155__$1;
(statearr_62215_62279[(1)] = (42));

} else {
var statearr_62216_62280 = state_62155__$1;
(statearr_62216_62280[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (30))){
var inst_62052 = (state_62155[(13)]);
var inst_62062 = (state_62155[(22)]);
var inst_62089 = fluree.db.time_travel.as_of_block(inst_62052,inst_62062);
var state_62155__$1 = state_62155;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62155__$1,(33),inst_62089);
} else {
if((state_val_62156 === (10))){
var state_62155__$1 = state_62155;
var statearr_62217_62281 = state_62155__$1;
(statearr_62217_62281[(2)] = false);

(statearr_62217_62281[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (18))){
var inst_62060 = (state_62155[(2)]);
var inst_62061 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62060,(0),null);
var inst_62062 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62060,(1),null);
var inst_62063 = cljs.core.list(new cljs.core.Keyword(null,"history","history",-247395220));
var inst_62064 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(query_map,new cljs.core.Keyword(null,"block","block",664686210),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"pretty-print","pretty-print",-1314067013),new cljs.core.Keyword(null,"prettyPrint","prettyPrint",215590803),new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"show-auth","show-auth",686103141),new cljs.core.Keyword(null,"showAuth","showAuth",-347871529),new cljs.core.Keyword(null,"opts","opts",155075701)], 0));
var inst_62065 = cljs.core.keys(inst_62064);
var inst_62066 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62063,inst_62065);
var state_62155__$1 = (function (){var statearr_62218 = state_62155;
(statearr_62218[(7)] = inst_62061);

(statearr_62218[(22)] = inst_62062);

return statearr_62218;
})();
if(inst_62066){
var statearr_62219_62282 = state_62155__$1;
(statearr_62219_62282[(1)] = (20));

} else {
var statearr_62220_62283 = state_62155__$1;
(statearr_62220_62283[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (42))){
var inst_62045 = (state_62155[(24)]);
var state_62155__$1 = state_62155;
var statearr_62221_62284 = state_62155__$1;
(statearr_62221_62284[(2)] = inst_62045);

(statearr_62221_62284[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (37))){
var inst_62047 = (state_62155[(10)]);
var inst_62112 = (state_62155[(2)]);
var state_62155__$1 = (function (){var statearr_62222 = state_62155;
(statearr_62222[(20)] = inst_62112);

return statearr_62222;
})();
if(cljs.core.truth_(inst_62047)){
var statearr_62223_62285 = state_62155__$1;
(statearr_62223_62285[(1)] = (39));

} else {
var statearr_62224_62286 = state_62155__$1;
(statearr_62224_62286[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (8))){
var inst_62036 = (state_62155[(2)]);
var state_62155__$1 = state_62155;
if(cljs.core.truth_(inst_62036)){
var statearr_62225_62287 = state_62155__$1;
(statearr_62225_62287[(1)] = (12));

} else {
var statearr_62226_62288 = state_62155__$1;
(statearr_62226_62288[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62156 === (49))){
var inst_62132 = (state_62155[(14)]);
var inst_62107 = (state_62155[(19)]);
var inst_62134 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413)];
var inst_62135 = cljs.core.count(inst_62107);
var inst_62136 = [inst_62132,inst_62135,(200)];
var inst_62137 = cljs.core.PersistentHashMap.fromArrays(inst_62134,inst_62136);
var state_62155__$1 = state_62155;
var statearr_62227_62289 = state_62155__$1;
(statearr_62227_62289[(2)] = inst_62137);

(statearr_62227_62289[(1)] = (51));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$history_query_async_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$history_query_async_$_state_machine__2879__auto____0 = (function (){
var statearr_62228 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62228[(0)] = fluree$db$api$query$history_query_async_$_state_machine__2879__auto__);

(statearr_62228[(1)] = (1));

return statearr_62228;
});
var fluree$db$api$query$history_query_async_$_state_machine__2879__auto____1 = (function (state_62155){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_62155);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e62229){var ex__2882__auto__ = e62229;
var statearr_62230_62290 = state_62155;
(statearr_62230_62290[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_62155[(4)]))){
var statearr_62231_62291 = state_62155;
(statearr_62231_62291[(1)] = cljs.core.first((state_62155[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62292 = state_62155;
state_62155 = G__62292;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$history_query_async_$_state_machine__2879__auto__ = function(state_62155){
switch(arguments.length){
case 0:
return fluree$db$api$query$history_query_async_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$history_query_async_$_state_machine__2879__auto____1.call(this,state_62155);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$history_query_async_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$history_query_async_$_state_machine__2879__auto____0;
fluree$db$api$query$history_query_async_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$history_query_async_$_state_machine__2879__auto____1;
return fluree$db$api$query$history_query_async_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_62232 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_62232[(6)] = c__2901__auto__);

return statearr_62232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Execute a query against a database source, or optionally
 *   additional sources if the query spans multiple data sets.
 *   Returns core async channel containing result.
 */
fluree.db.api.query.query_async = (function fluree$db$api$query$query_async(sources,flureeQL){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_62445){
var state_val_62446 = (state_62445[(1)]);
if((state_val_62446 === (7))){
var state_62445__$1 = state_62445;
var statearr_62447_62539 = state_62445__$1;
(statearr_62447_62539[(2)] = false);

(statearr_62447_62539[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (59))){
var inst_62430 = (state_62445[(7)]);
var state_62445__$1 = state_62445;
var statearr_62448_62540 = state_62445__$1;
(statearr_62448_62540[(2)] = inst_62430);

(statearr_62448_62540[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (20))){
var inst_62327 = (state_62445[(8)]);
var inst_62365 = (state_62445[(2)]);
var state_62445__$1 = (function (){var statearr_62449 = state_62445;
(statearr_62449[(9)] = inst_62365);

return statearr_62449;
})();
if(cljs.core.truth_(inst_62327)){
var statearr_62450_62541 = state_62445__$1;
(statearr_62450_62541[(1)] = (24));

} else {
var statearr_62451_62542 = state_62445__$1;
(statearr_62451_62542[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (58))){
var inst_62385 = (state_62445[(10)]);
var inst_62425 = (state_62445[(11)]);
var inst_62430 = (state_62445[(7)]);
var inst_62365 = (state_62445[(9)]);
var inst_62432 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"time","time",1385887882),new cljs.core.Keyword(null,"block","block",664686210)];
var inst_62433 = cljs.core.deref(inst_62385);
var inst_62434 = fluree.db.api.query.response_time_formatted(inst_62425);
var inst_62435 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(inst_62365);
var inst_62436 = [(200),inst_62430,inst_62433,inst_62434,inst_62435];
var inst_62437 = cljs.core.PersistentHashMap.fromArrays(inst_62432,inst_62436);
var state_62445__$1 = state_62445;
var statearr_62452_62543 = state_62445__$1;
(statearr_62452_62543[(2)] = inst_62437);

(statearr_62452_62543[(1)] = (60));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (60))){
var inst_62440 = (state_62445[(2)]);
var _ = (function (){var statearr_62453 = state_62445;
(statearr_62453[(4)] = cljs.core.rest((state_62445[(4)])));

return statearr_62453;
})();
var state_62445__$1 = state_62445;
var statearr_62454_62544 = state_62445__$1;
(statearr_62454_62544[(2)] = inst_62440);

(statearr_62454_62544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (27))){
var inst_62376 = (state_62445[(12)]);
var state_62445__$1 = state_62445;
var statearr_62455_62545 = state_62445__$1;
(statearr_62455_62545[(2)] = inst_62376);

(statearr_62455_62545[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (1))){
var state_62445__$1 = state_62445;
var statearr_62456_62546 = state_62445__$1;
(statearr_62456_62546[(2)] = null);

(statearr_62456_62546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (24))){
var inst_62327 = (state_62445[(8)]);
var inst_62365 = (state_62445[(9)]);
var inst_62367 = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(inst_62365);
var inst_62368 = new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(inst_62365);
var inst_62369 = new cljs.core.Keyword(null,"auth","auth",1389754926).cljs$core$IFn$_invoke$arity$1(inst_62365);
var inst_62370 = fluree.db.api.query.get_sources(inst_62367,inst_62368,inst_62369,inst_62327);
var state_62445__$1 = state_62445;
var statearr_62457_62547 = state_62445__$1;
(statearr_62457_62547[(2)] = inst_62370);

(statearr_62457_62547[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (55))){
var inst_62418 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62419 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_62420 = cljs.core.PersistentHashMap.fromArrays(inst_62418,inst_62419);
var inst_62421 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Invalid query.",inst_62420);
var inst_62422 = (function(){throw inst_62421})();
var state_62445__$1 = state_62445;
var statearr_62458_62548 = state_62445__$1;
(statearr_62458_62548[(2)] = inst_62422);

(statearr_62458_62548[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (39))){
var inst_62329 = (state_62445[(13)]);
var state_62445__$1 = state_62445;
var statearr_62459_62549 = state_62445__$1;
(statearr_62459_62549[(2)] = inst_62329);

(statearr_62459_62549[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (46))){
var inst_62323 = (state_62445[(14)]);
var state_62445__$1 = state_62445;
var statearr_62460_62550 = state_62445__$1;
(statearr_62460_62550[(2)] = inst_62323);

(statearr_62460_62550[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (4))){
var inst_62294 = (state_62445[(2)]);
var state_62445__$1 = state_62445;
var statearr_62461_62551 = state_62445__$1;
(statearr_62461_62551[(2)] = inst_62294);

(statearr_62461_62551[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (54))){
var state_62445__$1 = state_62445;
var statearr_62462_62552 = state_62445__$1;
(statearr_62462_62552[(2)] = null);

(statearr_62462_62552[(1)] = (56));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (15))){
var state_62445__$1 = state_62445;
var statearr_62463_62553 = state_62445__$1;
(statearr_62463_62553[(2)] = null);

(statearr_62463_62553[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (48))){
var inst_62330 = (state_62445[(15)]);
var state_62445__$1 = state_62445;
if(cljs.core.truth_(inst_62330)){
var statearr_62464_62554 = state_62445__$1;
(statearr_62464_62554[(1)] = (51));

} else {
var statearr_62465_62555 = state_62445__$1;
(statearr_62465_62555[(1)] = (52));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (50))){
var inst_62415 = (state_62445[(2)]);
var state_62445__$1 = state_62445;
if(cljs.core.truth_(inst_62415)){
var statearr_62466_62556 = state_62445__$1;
(statearr_62466_62556[(1)] = (54));

} else {
var statearr_62467_62557 = state_62445__$1;
(statearr_62467_62557[(1)] = (55));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (21))){
var inst_62358 = (state_62445[(2)]);
var inst_62359 = fluree.db.util.async.throw_err(inst_62358);
var state_62445__$1 = state_62445;
var statearr_62468_62558 = state_62445__$1;
(statearr_62468_62558[(2)] = inst_62359);

(statearr_62468_62558[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (31))){
var state_62445__$1 = state_62445;
var statearr_62469_62559 = state_62445__$1;
(statearr_62469_62559[(2)] = null);

(statearr_62469_62559[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (32))){
var inst_62331 = (state_62445[(16)]);
var inst_62386 = (state_62445[(17)]);
var inst_62385 = (state_62445[(2)]);
var inst_62386__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_62331);
var state_62445__$1 = (function (){var statearr_62470 = state_62445;
(statearr_62470[(10)] = inst_62385);

(statearr_62470[(17)] = inst_62386__$1);

return statearr_62470;
})();
if(cljs.core.truth_(inst_62386__$1)){
var statearr_62471_62560 = state_62445__$1;
(statearr_62471_62560[(1)] = (33));

} else {
var statearr_62472_62561 = state_62445__$1;
(statearr_62472_62561[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (40))){
var inst_62328 = (state_62445[(18)]);
var state_62445__$1 = state_62445;
if(cljs.core.truth_(inst_62328)){
var statearr_62473_62562 = state_62445__$1;
(statearr_62473_62562[(1)] = (42));

} else {
var statearr_62474_62563 = state_62445__$1;
(statearr_62474_62563[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (56))){
var inst_62391 = (state_62445[(19)]);
var inst_62365 = (state_62445[(9)]);
var inst_62424 = (state_62445[(2)]);
var inst_62425 = fluree.db.util.core.current_time_millis();
var inst_62426 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),inst_62391);
var inst_62427 = fluree.db.query.fql.query(inst_62365,inst_62426);
var state_62445__$1 = (function (){var statearr_62475 = state_62445;
(statearr_62475[(20)] = inst_62424);

(statearr_62475[(11)] = inst_62425);

return statearr_62475;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62445__$1,(57),inst_62427);
} else {
if((state_val_62446 === (33))){
var inst_62386 = (state_62445[(17)]);
var state_62445__$1 = state_62445;
var statearr_62476_62564 = state_62445__$1;
(statearr_62476_62564[(2)] = inst_62386);

(statearr_62476_62564[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (13))){
var inst_62301 = (state_62445[(21)]);
var state_62445__$1 = state_62445;
var statearr_62477_62565 = state_62445__$1;
(statearr_62477_62565[(2)] = inst_62301);

(statearr_62477_62565[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (22))){
var inst_62325 = (state_62445[(22)]);
var inst_62354 = (state_62445[(2)]);
var inst_62355 = fluree.db.util.async.throw_err(inst_62354);
var inst_62356 = fluree.db.time_travel.as_of_block(inst_62355,inst_62325);
var state_62445__$1 = state_62445;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62445__$1,(21),inst_62356);
} else {
if((state_val_62446 === (36))){
var inst_62324 = (state_62445[(23)]);
var state_62445__$1 = state_62445;
var statearr_62478_62566 = state_62445__$1;
(statearr_62478_62566[(2)] = inst_62324);

(statearr_62478_62566[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (41))){
var inst_62405 = (state_62445[(2)]);
var state_62445__$1 = state_62445;
var statearr_62479_62567 = state_62445__$1;
(statearr_62479_62567[(2)] = inst_62405);

(statearr_62479_62567[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (43))){
var inst_62332 = (state_62445[(24)]);
var state_62445__$1 = state_62445;
if(cljs.core.truth_(inst_62332)){
var statearr_62480_62568 = state_62445__$1;
(statearr_62480_62568[(1)] = (45));

} else {
var statearr_62481_62569 = state_62445__$1;
(statearr_62481_62569[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (29))){
var inst_62380 = (state_62445[(2)]);
var state_62445__$1 = state_62445;
if(cljs.core.truth_(inst_62380)){
var statearr_62482_62570 = state_62445__$1;
(statearr_62482_62570[(1)] = (30));

} else {
var statearr_62483_62571 = state_62445__$1;
(statearr_62483_62571[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (44))){
var inst_62403 = (state_62445[(2)]);
var state_62445__$1 = state_62445;
var statearr_62484_62572 = state_62445__$1;
(statearr_62484_62572[(2)] = inst_62403);

(statearr_62484_62572[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (6))){
var inst_62301 = (state_62445[(21)]);
var inst_62306 = inst_62301.cljs$lang$protocol_mask$partition0$;
var inst_62307 = (inst_62306 & (64));
var inst_62308 = inst_62301.cljs$core$ISeq$;
var inst_62309 = (cljs.core.PROTOCOL_SENTINEL === inst_62308);
var inst_62310 = ((inst_62307) || (inst_62309));
var state_62445__$1 = state_62445;
if(cljs.core.truth_(inst_62310)){
var statearr_62485_62573 = state_62445__$1;
(statearr_62485_62573[(1)] = (9));

} else {
var statearr_62486_62574 = state_62445__$1;
(statearr_62486_62574[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (28))){
var inst_62375 = (state_62445[(25)]);
var state_62445__$1 = state_62445;
var statearr_62487_62575 = state_62445__$1;
(statearr_62487_62575[(2)] = inst_62375);

(statearr_62487_62575[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (51))){
var inst_62330 = (state_62445[(15)]);
var state_62445__$1 = state_62445;
var statearr_62488_62576 = state_62445__$1;
(statearr_62488_62576[(2)] = inst_62330);

(statearr_62488_62576[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (25))){
var inst_62372 = cljs.core.PersistentHashMap.EMPTY;
var state_62445__$1 = state_62445;
var statearr_62489_62577 = state_62445__$1;
(statearr_62489_62577[(2)] = inst_62372);

(statearr_62489_62577[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (34))){
var state_62445__$1 = state_62445;
var statearr_62490_62578 = state_62445__$1;
(statearr_62490_62578[(2)] = (1000000));

(statearr_62490_62578[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (17))){
var inst_62325 = (state_62445[(22)]);
var inst_62350 = (state_62445[(2)]);
var inst_62351 = sources;
var state_62445__$1 = (function (){var statearr_62491 = state_62445;
(statearr_62491[(26)] = inst_62351);

(statearr_62491[(27)] = inst_62350);

return statearr_62491;
})();
if(cljs.core.truth_(inst_62325)){
var statearr_62492_62579 = state_62445__$1;
(statearr_62492_62579[(1)] = (18));

} else {
var statearr_62493_62580 = state_62445__$1;
(statearr_62493_62580[(1)] = (19));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (3))){
var inst_62443 = (state_62445[(2)]);
var state_62445__$1 = state_62445;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62445__$1,inst_62443);
} else {
if((state_val_62446 === (12))){
var inst_62301 = (state_62445[(21)]);
var inst_62319 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_62301);
var state_62445__$1 = state_62445;
var statearr_62494_62581 = state_62445__$1;
(statearr_62494_62581[(2)] = inst_62319);

(statearr_62494_62581[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (2))){
var inst_62301 = (state_62445[(21)]);
var _ = (function (){var statearr_62495 = state_62445;
(statearr_62495[(4)] = cljs.core.cons((5),(state_62445[(4)])));

return statearr_62495;
})();
var inst_62301__$1 = flureeQL;
var inst_62303 = (inst_62301__$1 == null);
var inst_62304 = cljs.core.not(inst_62303);
var state_62445__$1 = (function (){var statearr_62496 = state_62445;
(statearr_62496[(21)] = inst_62301__$1);

return statearr_62496;
})();
if(inst_62304){
var statearr_62497_62582 = state_62445__$1;
(statearr_62497_62582[(1)] = (6));

} else {
var statearr_62498_62583 = state_62445__$1;
(statearr_62498_62583[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (23))){
var inst_62362 = (state_62445[(2)]);
var inst_62363 = fluree.db.util.async.throw_err(inst_62362);
var state_62445__$1 = state_62445;
var statearr_62499_62584 = state_62445__$1;
(statearr_62499_62584[(2)] = inst_62363);

(statearr_62499_62584[(1)] = (20));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (47))){
var inst_62401 = (state_62445[(2)]);
var state_62445__$1 = state_62445;
var statearr_62500_62585 = state_62445__$1;
(statearr_62500_62585[(2)] = inst_62401);

(statearr_62500_62585[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (35))){
var inst_62385 = (state_62445[(10)]);
var inst_62324 = (state_62445[(23)]);
var inst_62331 = (state_62445[(16)]);
var inst_62374 = (state_62445[(28)]);
var inst_62390 = (state_62445[(2)]);
var inst_62391 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_62331,new cljs.core.Keyword(null,"sources","sources",-321166424),inst_62374,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"max-fuel","max-fuel",994681012),inst_62390,new cljs.core.Keyword(null,"fuel","fuel",10405485),inst_62385], 0));
var state_62445__$1 = (function (){var statearr_62501 = state_62445;
(statearr_62501[(19)] = inst_62391);

return statearr_62501;
})();
if(cljs.core.truth_(inst_62324)){
var statearr_62502_62586 = state_62445__$1;
(statearr_62502_62586[(1)] = (36));

} else {
var statearr_62503_62587 = state_62445__$1;
(statearr_62503_62587[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (19))){
var inst_62351 = (state_62445[(26)]);
var state_62445__$1 = state_62445;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62445__$1,(23),inst_62351);
} else {
if((state_val_62446 === (57))){
var inst_62375 = (state_62445[(25)]);
var inst_62429 = (state_62445[(2)]);
var inst_62430 = fluree.db.util.async.throw_err(inst_62429);
var state_62445__$1 = (function (){var statearr_62504 = state_62445;
(statearr_62504[(7)] = inst_62430);

return statearr_62504;
})();
if(cljs.core.truth_(inst_62375)){
var statearr_62505_62588 = state_62445__$1;
(statearr_62505_62588[(1)] = (58));

} else {
var statearr_62506_62589 = state_62445__$1;
(statearr_62506_62589[(1)] = (59));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (11))){
var inst_62314 = (state_62445[(2)]);
var state_62445__$1 = state_62445;
var statearr_62508_62590 = state_62445__$1;
(statearr_62508_62590[(2)] = inst_62314);

(statearr_62508_62590[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (9))){
var state_62445__$1 = state_62445;
var statearr_62509_62591 = state_62445__$1;
(statearr_62509_62591[(2)] = true);

(statearr_62509_62591[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (5))){
var _ = (function (){var statearr_62510 = state_62445;
(statearr_62510[(4)] = cljs.core.rest((state_62445[(4)])));

return statearr_62510;
})();
var state_62445__$1 = state_62445;
var ex62507 = (state_62445__$1[(2)]);
var statearr_62511_62592 = state_62445__$1;
(statearr_62511_62592[(5)] = ex62507);


if((ex62507 instanceof Error)){
var statearr_62512_62593 = state_62445__$1;
(statearr_62512_62593[(1)] = (4));

(statearr_62512_62593[(5)] = null);

} else {
throw ex62507;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (14))){
var inst_62323 = (state_62445[(14)]);
var inst_62325 = (state_62445[(22)]);
var inst_62326 = (state_62445[(29)]);
var inst_62324 = (state_62445[(23)]);
var inst_62329 = (state_62445[(13)]);
var inst_62330 = (state_62445[(15)]);
var inst_62331 = (state_62445[(16)]);
var inst_62332 = (state_62445[(24)]);
var inst_62327 = (state_62445[(8)]);
var inst_62328 = (state_62445[(18)]);
var inst_62322 = (state_62445[(2)]);
var inst_62323__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62322,new cljs.core.Keyword(null,"construct","construct",692547932));
var inst_62324__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62322,new cljs.core.Keyword(null,"select","select",1147833503));
var inst_62325__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62322,new cljs.core.Keyword(null,"block","block",664686210));
var inst_62326__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62322,new cljs.core.Keyword(null,"where","where",-2044795965));
var inst_62327__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62322,new cljs.core.Keyword(null,"prefixes","prefixes",1192472197));
var inst_62328__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62322,new cljs.core.Keyword(null,"selectDistinct","selectDistinct",-1896277872));
var inst_62329__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62322,new cljs.core.Keyword(null,"selectOne","selectOne",1588429876));
var inst_62330__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62322,new cljs.core.Keyword(null,"from","from",1815293044));
var inst_62331__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62322,new cljs.core.Keyword(null,"opts","opts",155075701));
var inst_62332__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62322,new cljs.core.Keyword(null,"selectReduced","selectReduced",212266935));
var inst_62333 = (function (){var construct = inst_62323__$1;
var select = inst_62324__$1;
var block = inst_62325__$1;
var where = inst_62326__$1;
var prefixes = inst_62327__$1;
var selectDistinct = inst_62328__$1;
var map__62300 = inst_62322;
var selectOne = inst_62329__$1;
var from = inst_62330__$1;
var opts = inst_62331__$1;
var selectReduced = inst_62332__$1;
return (function (p1__62293_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__62293_SHARP_);
});
})();
var inst_62334 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62335 = [inst_62324__$1,inst_62329__$1,inst_62328__$1,inst_62332__$1];
var inst_62336 = (new cljs.core.PersistentVector(null,4,(5),inst_62334,inst_62335,null));
var inst_62337 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_62336);
var inst_62338 = cljs.core.count(inst_62337);
var inst_62339 = (inst_62333.cljs$core$IFn$_invoke$arity$1 ? inst_62333.cljs$core$IFn$_invoke$arity$1(inst_62338) : inst_62333.call(null,inst_62338));
var state_62445__$1 = (function (){var statearr_62513 = state_62445;
(statearr_62513[(14)] = inst_62323__$1);

(statearr_62513[(22)] = inst_62325__$1);

(statearr_62513[(29)] = inst_62326__$1);

(statearr_62513[(23)] = inst_62324__$1);

(statearr_62513[(13)] = inst_62329__$1);

(statearr_62513[(15)] = inst_62330__$1);

(statearr_62513[(16)] = inst_62331__$1);

(statearr_62513[(24)] = inst_62332__$1);

(statearr_62513[(8)] = inst_62327__$1);

(statearr_62513[(18)] = inst_62328__$1);

return statearr_62513;
})();
if(cljs.core.truth_(inst_62339)){
var statearr_62514_62594 = state_62445__$1;
(statearr_62514_62594[(1)] = (15));

} else {
var statearr_62515_62595 = state_62445__$1;
(statearr_62515_62595[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (45))){
var inst_62332 = (state_62445[(24)]);
var state_62445__$1 = state_62445;
var statearr_62516_62596 = state_62445__$1;
(statearr_62516_62596[(2)] = inst_62332);

(statearr_62516_62596[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (53))){
var inst_62412 = (state_62445[(2)]);
var state_62445__$1 = state_62445;
var statearr_62517_62597 = state_62445__$1;
(statearr_62517_62597[(2)] = inst_62412);

(statearr_62517_62597[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (26))){
var inst_62331 = (state_62445[(16)]);
var inst_62376 = (state_62445[(12)]);
var inst_62374 = (state_62445[(2)]);
var inst_62375 = new cljs.core.Keyword(null,"meta","meta",1499536964).cljs$core$IFn$_invoke$arity$1(inst_62331);
var inst_62376__$1 = new cljs.core.Keyword(null,"fuel","fuel",10405485).cljs$core$IFn$_invoke$arity$1(inst_62331);
var state_62445__$1 = (function (){var statearr_62518 = state_62445;
(statearr_62518[(25)] = inst_62375);

(statearr_62518[(12)] = inst_62376__$1);

(statearr_62518[(28)] = inst_62374);

return statearr_62518;
})();
if(cljs.core.truth_(inst_62376__$1)){
var statearr_62519_62598 = state_62445__$1;
(statearr_62519_62598[(1)] = (27));

} else {
var statearr_62520_62599 = state_62445__$1;
(statearr_62520_62599[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (16))){
var inst_62342 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flureeQL], 0));
var inst_62343 = ["Only one type of select-key (select, selectOne, selectDistinct, selectReduced) allowed. Provided: ",inst_62342].join('');
var inst_62344 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_62345 = [(400),new cljs.core.Keyword("db","invalid-query","db/invalid-query",-1009699917)];
var inst_62346 = cljs.core.PersistentHashMap.fromArrays(inst_62344,inst_62345);
var inst_62347 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_62343,inst_62346);
var inst_62348 = (function(){throw inst_62347})();
var state_62445__$1 = state_62445;
var statearr_62521_62600 = state_62445__$1;
(statearr_62521_62600[(2)] = inst_62348);

(statearr_62521_62600[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (38))){
var inst_62407 = (state_62445[(30)]);
var inst_62407__$1 = (state_62445[(2)]);
var state_62445__$1 = (function (){var statearr_62522 = state_62445;
(statearr_62522[(30)] = inst_62407__$1);

return statearr_62522;
})();
if(cljs.core.truth_(inst_62407__$1)){
var statearr_62523_62601 = state_62445__$1;
(statearr_62523_62601[(1)] = (48));

} else {
var statearr_62524_62602 = state_62445__$1;
(statearr_62524_62602[(1)] = (49));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (30))){
var inst_62382 = cljs.core.volatile_BANG_((0));
var state_62445__$1 = state_62445;
var statearr_62525_62603 = state_62445__$1;
(statearr_62525_62603[(2)] = inst_62382);

(statearr_62525_62603[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (10))){
var state_62445__$1 = state_62445;
var statearr_62526_62604 = state_62445__$1;
(statearr_62526_62604[(2)] = false);

(statearr_62526_62604[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (18))){
var inst_62351 = (state_62445[(26)]);
var state_62445__$1 = state_62445;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62445__$1,(22),inst_62351);
} else {
if((state_val_62446 === (52))){
var inst_62326 = (state_62445[(29)]);
var state_62445__$1 = state_62445;
var statearr_62527_62605 = state_62445__$1;
(statearr_62527_62605[(2)] = inst_62326);

(statearr_62527_62605[(1)] = (53));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (42))){
var inst_62328 = (state_62445[(18)]);
var state_62445__$1 = state_62445;
var statearr_62528_62606 = state_62445__$1;
(statearr_62528_62606[(2)] = inst_62328);

(statearr_62528_62606[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (37))){
var inst_62329 = (state_62445[(13)]);
var state_62445__$1 = state_62445;
if(cljs.core.truth_(inst_62329)){
var statearr_62529_62607 = state_62445__$1;
(statearr_62529_62607[(1)] = (39));

} else {
var statearr_62530_62608 = state_62445__$1;
(statearr_62530_62608[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (8))){
var inst_62317 = (state_62445[(2)]);
var state_62445__$1 = state_62445;
if(cljs.core.truth_(inst_62317)){
var statearr_62531_62609 = state_62445__$1;
(statearr_62531_62609[(1)] = (12));

} else {
var statearr_62532_62610 = state_62445__$1;
(statearr_62532_62610[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62446 === (49))){
var inst_62407 = (state_62445[(30)]);
var state_62445__$1 = state_62445;
var statearr_62533_62611 = state_62445__$1;
(statearr_62533_62611[(2)] = inst_62407);

(statearr_62533_62611[(1)] = (50));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$query_async_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$query_async_$_state_machine__2879__auto____0 = (function (){
var statearr_62534 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62534[(0)] = fluree$db$api$query$query_async_$_state_machine__2879__auto__);

(statearr_62534[(1)] = (1));

return statearr_62534;
});
var fluree$db$api$query$query_async_$_state_machine__2879__auto____1 = (function (state_62445){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_62445);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e62535){var ex__2882__auto__ = e62535;
var statearr_62536_62612 = state_62445;
(statearr_62536_62612[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_62445[(4)]))){
var statearr_62537_62613 = state_62445;
(statearr_62537_62613[(1)] = cljs.core.first((state_62445[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62614 = state_62445;
state_62445 = G__62614;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$query_async_$_state_machine__2879__auto__ = function(state_62445){
switch(arguments.length){
case 0:
return fluree$db$api$query$query_async_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$query_async_$_state_machine__2879__auto____1.call(this,state_62445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$query_async_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$query_async_$_state_machine__2879__auto____0;
fluree$db$api$query$query_async_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$query_async_$_state_machine__2879__auto____1;
return fluree$db$api$query$query_async_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_62538 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_62538[(6)] = c__2901__auto__);

return statearr_62538;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Performs multiple queries in a map, with the key being the alias for the query
 *   and the value being the query itself - standard, history, and block queries are all supported.
 *   Each query result will be in a response map with its respective alias as the key.
 * 
 *   If a :block is specified at the top level, it will be used as a default for all queries
 * 
 *   If any errors occur, an :errors key will be present with a map of each alias to its error
 *   information. Check for the presence of this key if detection of an error is important.
 * 
 *   An optional :opts key contains options, which for now is limited to:
 * - meta: true or false - If false, will just report out the result as a map.
 *         If true will roll up all status and fuel consumption. Response map will contain keys:
 *         - status - aggregate status (200 all good, 207 some good, or 400+ for differing errors
 *         - fuel   - aggregate fuel for all queries
 *         - result - query result
 *         - errors - map of query alias to their respective error
 */
fluree.db.api.query.multi_query_async = (function fluree$db$api$query$multi_query_async(source,flureeQL){
var c__2901__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2902__auto__ = (function (){var switch__2878__auto__ = (function (state_62768){
var state_val_62769 = (state_62768[(1)]);
if((state_val_62769 === (7))){
var inst_62763 = (state_62768[(2)]);
var _ = (function (){var statearr_62770 = state_62768;
(statearr_62770[(4)] = cljs.core.rest((state_62768[(4)])));

return statearr_62770;
})();
var state_62768__$1 = state_62768;
var statearr_62771_62850 = state_62768__$1;
(statearr_62771_62850[(2)] = inst_62763);

(statearr_62771_62850[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (20))){
var inst_62684 = (state_62768[(7)]);
var inst_62702 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_62684);
var state_62768__$1 = state_62768;
var statearr_62772_62851 = state_62768__$1;
(statearr_62772_62851[(2)] = inst_62702);

(statearr_62772_62851[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (27))){
var inst_62712 = (state_62768[(8)]);
var state_62768__$1 = state_62768;
var statearr_62773_62852 = state_62768__$1;
(statearr_62773_62852[(2)] = inst_62712);

(statearr_62773_62852[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (1))){
var state_62768__$1 = state_62768;
var statearr_62774_62853 = state_62768__$1;
(statearr_62774_62853[(2)] = null);

(statearr_62774_62853[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (24))){
var inst_62654 = (state_62768[(9)]);
var inst_62709 = (state_62768[(10)]);
var inst_62712 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(inst_62709);
var inst_62713 = (inst_62654 == null);
var state_62768__$1 = (function (){var statearr_62775 = state_62768;
(statearr_62775[(8)] = inst_62712);

return statearr_62775;
})();
if(cljs.core.truth_(inst_62713)){
var statearr_62776_62854 = state_62768__$1;
(statearr_62776_62854[(1)] = (27));

} else {
var statearr_62777_62855 = state_62768__$1;
(statearr_62777_62855[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (39))){
var inst_62655 = (state_62768[(11)]);
var inst_62709 = (state_62768[(10)]);
var inst_62740 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_62709,new cljs.core.Keyword(null,"fuel","fuel",10405485),(0));
var inst_62741 = (inst_62655 + inst_62740);
var state_62768__$1 = state_62768;
var statearr_62778_62856 = state_62768__$1;
(statearr_62778_62856[(2)] = inst_62741);

(statearr_62778_62856[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (46))){
var inst_62709 = (state_62768[(10)]);
var state_62768__$1 = state_62768;
var statearr_62779_62857 = state_62768__$1;
(statearr_62779_62857[(2)] = inst_62709);

(statearr_62779_62857[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (4))){
var inst_62615 = (state_62768[(2)]);
var state_62768__$1 = state_62768;
var statearr_62780_62858 = state_62768__$1;
(statearr_62780_62858[(2)] = inst_62615);

(statearr_62780_62858[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (15))){
var state_62768__$1 = state_62768;
var statearr_62781_62859 = state_62768__$1;
(statearr_62781_62859[(2)] = false);

(statearr_62781_62859[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (21))){
var inst_62684 = (state_62768[(7)]);
var state_62768__$1 = state_62768;
var statearr_62782_62860 = state_62768__$1;
(statearr_62782_62860[(2)] = inst_62684);

(statearr_62782_62860[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (31))){
var inst_62654 = (state_62768[(9)]);
var inst_62712 = (state_62768[(8)]);
var inst_62719 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_62712);
var inst_62720 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_62654);
var inst_62721 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((207),inst_62654);
var inst_62722 = ((inst_62719) || (inst_62720) || (inst_62721));
var state_62768__$1 = state_62768;
if(cljs.core.truth_(inst_62722)){
var statearr_62783_62861 = state_62768__$1;
(statearr_62783_62861[(1)] = (33));

} else {
var statearr_62784_62862 = state_62768__$1;
(statearr_62784_62862[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (32))){
var inst_62733 = (state_62768[(2)]);
var state_62768__$1 = state_62768;
var statearr_62785_62863 = state_62768__$1;
(statearr_62785_62863[(2)] = inst_62733);

(statearr_62785_62863[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (40))){
var state_62768__$1 = state_62768;
var statearr_62786_62864 = state_62768__$1;
(statearr_62786_62864[(2)] = null);

(statearr_62786_62864[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (33))){
var state_62768__$1 = state_62768;
var statearr_62787_62865 = state_62768__$1;
(statearr_62787_62865[(2)] = (207));

(statearr_62787_62865[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (13))){
var inst_62678 = (state_62768[(2)]);
var state_62768__$1 = state_62768;
var statearr_62788_62866 = state_62768__$1;
(statearr_62788_62866[(2)] = inst_62678);

(statearr_62788_62866[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (22))){
var inst_62668 = (state_62768[(12)]);
var inst_62705 = (state_62768[(2)]);
var inst_62706 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62705,new cljs.core.Keyword(null,"meta","meta",1499536964));
var inst_62707 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_62705,new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962));
var state_62768__$1 = (function (){var statearr_62789 = state_62768;
(statearr_62789[(13)] = inst_62707);

(statearr_62789[(14)] = inst_62706);

return statearr_62789;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_62768__$1,(23),inst_62668);
} else {
if((state_val_62769 === (36))){
var inst_62654 = (state_62768[(9)]);
var inst_62712 = (state_62768[(8)]);
var inst_62726 = ((inst_62712 > inst_62654) ? inst_62712 : inst_62654);
var state_62768__$1 = state_62768;
var statearr_62790_62867 = state_62768__$1;
(statearr_62790_62867[(2)] = inst_62726);

(statearr_62790_62867[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (41))){
var inst_62710 = (state_62768[(15)]);
var inst_62744 = (state_62768[(2)]);
var state_62768__$1 = (function (){var statearr_62791 = state_62768;
(statearr_62791[(16)] = inst_62744);

return statearr_62791;
})();
if(cljs.core.truth_(inst_62710)){
var statearr_62792_62868 = state_62768__$1;
(statearr_62792_62868[(1)] = (42));

} else {
var statearr_62793_62869 = state_62768__$1;
(statearr_62793_62869[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (43))){
var inst_62707 = (state_62768[(13)]);
var state_62768__$1 = state_62768;
if(cljs.core.truth_(inst_62707)){
var statearr_62794_62870 = state_62768__$1;
(statearr_62794_62870[(1)] = (45));

} else {
var statearr_62795_62871 = state_62768__$1;
(statearr_62795_62871[(1)] = (46));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (29))){
var inst_62735 = (state_62768[(2)]);
var state_62768__$1 = state_62768;
var statearr_62796_62872 = state_62768__$1;
(statearr_62796_62872[(2)] = inst_62735);

(statearr_62796_62872[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (44))){
var inst_62666 = (state_62768[(17)]);
var inst_62744 = (state_62768[(16)]);
var inst_62738 = (state_62768[(18)]);
var inst_62758 = (state_62768[(2)]);
var inst_62653 = inst_62666;
var inst_62654 = inst_62738;
var inst_62655 = inst_62744;
var inst_62656 = inst_62758;
var state_62768__$1 = (function (){var statearr_62797 = state_62768;
(statearr_62797[(9)] = inst_62654);

(statearr_62797[(19)] = inst_62656);

(statearr_62797[(11)] = inst_62655);

(statearr_62797[(20)] = inst_62653);

return statearr_62797;
})();
var statearr_62798_62873 = state_62768__$1;
(statearr_62798_62873[(2)] = null);

(statearr_62798_62873[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (6))){
var inst_62668 = (state_62768[(12)]);
var inst_62653 = (state_62768[(20)]);
var inst_62664 = cljs.core.seq(inst_62653);
var inst_62665 = cljs.core.first(inst_62664);
var inst_62666 = cljs.core.next(inst_62664);
var inst_62667 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62665,(0),null);
var inst_62668__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62665,(1),null);
var inst_62669 = (inst_62668__$1 == null);
var state_62768__$1 = (function (){var statearr_62799 = state_62768;
(statearr_62799[(21)] = inst_62667);

(statearr_62799[(17)] = inst_62666);

(statearr_62799[(12)] = inst_62668__$1);

return statearr_62799;
})();
if(cljs.core.truth_(inst_62669)){
var statearr_62800_62874 = state_62768__$1;
(statearr_62800_62874[(1)] = (8));

} else {
var statearr_62801_62875 = state_62768__$1;
(statearr_62801_62875[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (28))){
var inst_62654 = (state_62768[(9)]);
var inst_62712 = (state_62768[(8)]);
var inst_62716 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_62654,inst_62712);
var state_62768__$1 = state_62768;
if(inst_62716){
var statearr_62802_62876 = state_62768__$1;
(statearr_62802_62876[(1)] = (30));

} else {
var statearr_62803_62877 = state_62768__$1;
(statearr_62803_62877[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (25))){
var state_62768__$1 = state_62768;
var statearr_62804_62878 = state_62768__$1;
(statearr_62804_62878[(2)] = null);

(statearr_62804_62878[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (34))){
var state_62768__$1 = state_62768;
var statearr_62805_62879 = state_62768__$1;
(statearr_62805_62879[(1)] = (36));



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (17))){
var state_62768__$1 = state_62768;
var statearr_62807_62880 = state_62768__$1;
(statearr_62807_62880[(2)] = true);

(statearr_62807_62880[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (3))){
var inst_62766 = (state_62768[(2)]);
var state_62768__$1 = state_62768;
return cljs.core.async.impl.ioc_helpers.return_chan(state_62768__$1,inst_62766);
} else {
if((state_val_62769 === (12))){
var inst_62656 = (state_62768[(19)]);
var state_62768__$1 = state_62768;
var statearr_62808_62881 = state_62768__$1;
(statearr_62808_62881[(2)] = inst_62656);

(statearr_62808_62881[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (2))){
var inst_62629 = (state_62768[(22)]);
var inst_62630 = (state_62768[(23)]);
var inst_62625 = (state_62768[(24)]);
var _ = (function (){var statearr_62809 = state_62768;
(statearr_62809[(4)] = cljs.core.cons((5),(state_62768[(4)])));

return statearr_62809;
})();
var inst_62621 = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(flureeQL);
var inst_62622 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62623 = [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)];
var inst_62624 = (new cljs.core.PersistentVector(null,2,(5),inst_62622,inst_62623,null));
var inst_62625__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(flureeQL,inst_62624);
var inst_62626 = (function (){var global_block = inst_62621;
var global_meta_QMARK_ = inst_62625__$1;
return (function (acc,alias,query){
var query_meta_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(query,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"opts","opts",155075701),new cljs.core.Keyword(null,"meta","meta",1499536964)], null));
var meta_QMARK_ = (function (){var or__4126__auto__ = global_meta_QMARK_;
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return query_meta_QMARK_;
}
})();
var remove_meta_QMARK_ = (function (){var and__4115__auto__ = meta_QMARK_;
if(cljs.core.truth_(and__4115__auto__)){
return cljs.core.not(query_meta_QMARK_);
} else {
return and__4115__auto__;
}
})();
var opts_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.Keyword(null,"opts","opts",155075701).cljs$core$IFn$_invoke$arity$1(query),new cljs.core.Keyword(null,"meta","meta",1499536964),meta_QMARK_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"_remove-meta?","_remove-meta?",-82029962),remove_meta_QMARK_], 0));
var query_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(query,new cljs.core.Keyword(null,"opts","opts",155075701),opts_STAR_,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210),(function (){var or__4126__auto__ = new cljs.core.Keyword(null,"block","block",664686210).cljs$core$IFn$_invoke$arity$1(query);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return global_block;
}
})()], 0));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,alias,query_STAR_);
});
})();
var inst_62627 = cljs.core.PersistentHashMap.EMPTY;
var inst_62628 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(flureeQL,new cljs.core.Keyword(null,"opts","opts",155075701),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"block","block",664686210)], 0));
var inst_62629__$1 = cljs.core.reduce_kv(inst_62626,inst_62627,inst_62628);
var inst_62630__$1 = fluree.db.util.core.current_time_millis();
var inst_62632 = (function (){var global_block = inst_62621;
var global_meta_QMARK_ = inst_62625__$1;
var queries = inst_62629__$1;
var start_time = inst_62630__$1;
return (function (p__62631){
var vec__62810 = p__62631;
var alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62810,(0),null);
var q = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__62810,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [alias,(fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.api.query.query.cljs$core$IFn$_invoke$arity$2(source,q) : fluree.db.api.query.query.call(null,source,q))], null);
});
})();
var inst_62633 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_62632,inst_62629__$1);
var inst_62647 = cljs.core.seq(inst_62633);
var inst_62648 = cljs.core.first(inst_62647);
var inst_62649 = cljs.core.next(inst_62647);
var inst_62650 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62648,(0),null);
var inst_62651 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_62648,(1),null);
var inst_62652 = cljs.core.PersistentHashMap.EMPTY;
var inst_62653 = inst_62633;
var inst_62654 = null;
var inst_62655 = (0);
var inst_62656 = inst_62652;
var state_62768__$1 = (function (){var statearr_62813 = state_62768;
(statearr_62813[(9)] = inst_62654);

(statearr_62813[(22)] = inst_62629__$1);

(statearr_62813[(19)] = inst_62656);

(statearr_62813[(25)] = inst_62650);

(statearr_62813[(11)] = inst_62655);

(statearr_62813[(23)] = inst_62630__$1);

(statearr_62813[(26)] = inst_62651);

(statearr_62813[(27)] = inst_62649);

(statearr_62813[(20)] = inst_62653);

(statearr_62813[(24)] = inst_62625__$1);

return statearr_62813;
})();
var statearr_62814_62882 = state_62768__$1;
(statearr_62814_62882[(2)] = null);

(statearr_62814_62882[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (23))){
var inst_62706 = (state_62768[(14)]);
var inst_62709 = (state_62768[(10)]);
var inst_62709__$1 = (state_62768[(2)]);
var inst_62710 = new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(inst_62709__$1);
var state_62768__$1 = (function (){var statearr_62815 = state_62768;
(statearr_62815[(15)] = inst_62710);

(statearr_62815[(10)] = inst_62709__$1);

return statearr_62815;
})();
if(cljs.core.truth_(inst_62706)){
var statearr_62816_62883 = state_62768__$1;
(statearr_62816_62883[(1)] = (24));

} else {
var statearr_62817_62884 = state_62768__$1;
(statearr_62817_62884[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (47))){
var inst_62667 = (state_62768[(21)]);
var inst_62656 = (state_62768[(19)]);
var inst_62755 = (state_62768[(2)]);
var inst_62756 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_62656,inst_62667,inst_62755);
var state_62768__$1 = state_62768;
var statearr_62818_62885 = state_62768__$1;
(statearr_62818_62885[(2)] = inst_62756);

(statearr_62818_62885[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (35))){
var inst_62731 = (state_62768[(2)]);
var state_62768__$1 = state_62768;
var statearr_62819_62886 = state_62768__$1;
(statearr_62819_62886[(2)] = inst_62731);

(statearr_62819_62886[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (19))){
var inst_62697 = (state_62768[(2)]);
var state_62768__$1 = state_62768;
var statearr_62820_62887 = state_62768__$1;
(statearr_62820_62887[(2)] = inst_62697);

(statearr_62820_62887[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (11))){
var inst_62654 = (state_62768[(9)]);
var inst_62656 = (state_62768[(19)]);
var inst_62655 = (state_62768[(11)]);
var inst_62630 = (state_62768[(23)]);
var inst_62672 = [new cljs.core.Keyword(null,"result","result",1415092211),new cljs.core.Keyword(null,"fuel","fuel",10405485),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"time","time",1385887882)];
var inst_62673 = fluree.db.api.query.response_time_formatted(inst_62630);
var inst_62674 = [inst_62656,inst_62655,inst_62654,inst_62673];
var inst_62675 = cljs.core.PersistentHashMap.fromArrays(inst_62672,inst_62674);
var state_62768__$1 = state_62768;
var statearr_62822_62888 = state_62768__$1;
(statearr_62822_62888[(2)] = inst_62675);

(statearr_62822_62888[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (9))){
var inst_62667 = (state_62768[(21)]);
var inst_62629 = (state_62768[(22)]);
var inst_62684 = (state_62768[(7)]);
var inst_62681 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62682 = [inst_62667,new cljs.core.Keyword(null,"opts","opts",155075701)];
var inst_62683 = (new cljs.core.PersistentVector(null,2,(5),inst_62681,inst_62682,null));
var inst_62684__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_62629,inst_62683);
var inst_62686 = (inst_62684__$1 == null);
var inst_62687 = cljs.core.not(inst_62686);
var state_62768__$1 = (function (){var statearr_62823 = state_62768;
(statearr_62823[(7)] = inst_62684__$1);

return statearr_62823;
})();
if(inst_62687){
var statearr_62824_62889 = state_62768__$1;
(statearr_62824_62889[(1)] = (14));

} else {
var statearr_62825_62890 = state_62768__$1;
(statearr_62825_62890[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (5))){
var _ = (function (){var statearr_62826 = state_62768;
(statearr_62826[(4)] = cljs.core.rest((state_62768[(4)])));

return statearr_62826;
})();
var state_62768__$1 = state_62768;
var ex62821 = (state_62768__$1[(2)]);
var statearr_62827_62891 = state_62768__$1;
(statearr_62827_62891[(5)] = ex62821);


var statearr_62828_62892 = state_62768__$1;
(statearr_62828_62892[(1)] = (4));

(statearr_62828_62892[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (14))){
var inst_62684 = (state_62768[(7)]);
var inst_62689 = inst_62684.cljs$lang$protocol_mask$partition0$;
var inst_62690 = (inst_62689 & (64));
var inst_62691 = inst_62684.cljs$core$ISeq$;
var inst_62692 = (cljs.core.PROTOCOL_SENTINEL === inst_62691);
var inst_62693 = ((inst_62690) || (inst_62692));
var state_62768__$1 = state_62768;
if(cljs.core.truth_(inst_62693)){
var statearr_62829_62893 = state_62768__$1;
(statearr_62829_62893[(1)] = (17));

} else {
var statearr_62830_62894 = state_62768__$1;
(statearr_62830_62894[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (45))){
var inst_62709 = (state_62768[(10)]);
var inst_62752 = new cljs.core.Keyword(null,"result","result",1415092211).cljs$core$IFn$_invoke$arity$1(inst_62709);
var state_62768__$1 = state_62768;
var statearr_62831_62895 = state_62768__$1;
(statearr_62831_62895[(2)] = inst_62752);

(statearr_62831_62895[(1)] = (47));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (26))){
var inst_62706 = (state_62768[(14)]);
var inst_62738 = (state_62768[(2)]);
var state_62768__$1 = (function (){var statearr_62832 = state_62768;
(statearr_62832[(18)] = inst_62738);

return statearr_62832;
})();
if(cljs.core.truth_(inst_62706)){
var statearr_62833_62896 = state_62768__$1;
(statearr_62833_62896[(1)] = (39));

} else {
var statearr_62834_62897 = state_62768__$1;
(statearr_62834_62897[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (16))){
var inst_62700 = (state_62768[(2)]);
var state_62768__$1 = state_62768;
if(cljs.core.truth_(inst_62700)){
var statearr_62835_62898 = state_62768__$1;
(statearr_62835_62898[(1)] = (20));

} else {
var statearr_62836_62899 = state_62768__$1;
(statearr_62836_62899[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (38))){
var inst_62729 = (state_62768[(2)]);
var state_62768__$1 = state_62768;
var statearr_62837_62900 = state_62768__$1;
(statearr_62837_62900[(2)] = inst_62729);

(statearr_62837_62900[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (30))){
var inst_62712 = (state_62768[(8)]);
var state_62768__$1 = state_62768;
var statearr_62838_62901 = state_62768__$1;
(statearr_62838_62901[(2)] = inst_62712);

(statearr_62838_62901[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (10))){
var inst_62761 = (state_62768[(2)]);
var state_62768__$1 = state_62768;
var statearr_62839_62902 = state_62768__$1;
(statearr_62839_62902[(2)] = inst_62761);

(statearr_62839_62902[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (18))){
var state_62768__$1 = state_62768;
var statearr_62840_62903 = state_62768__$1;
(statearr_62840_62903[(2)] = false);

(statearr_62840_62903[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (42))){
var inst_62667 = (state_62768[(21)]);
var inst_62656 = (state_62768[(19)]);
var inst_62709 = (state_62768[(10)]);
var inst_62746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_62747 = [new cljs.core.Keyword(null,"errors","errors",-908790718),inst_62667];
var inst_62748 = (new cljs.core.PersistentVector(null,2,(5),inst_62746,inst_62747,null));
var inst_62749 = cljs.core.assoc_in(inst_62656,inst_62748,inst_62709);
var state_62768__$1 = state_62768;
var statearr_62841_62904 = state_62768__$1;
(statearr_62841_62904[(2)] = inst_62749);

(statearr_62841_62904[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (37))){
var state_62768__$1 = state_62768;
var statearr_62842_62905 = state_62768__$1;
(statearr_62842_62905[(2)] = null);

(statearr_62842_62905[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_62769 === (8))){
var inst_62625 = (state_62768[(24)]);
var state_62768__$1 = state_62768;
if(cljs.core.truth_(inst_62625)){
var statearr_62843_62906 = state_62768__$1;
(statearr_62843_62906[(1)] = (11));

} else {
var statearr_62844_62907 = state_62768__$1;
(statearr_62844_62907[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$api$query$multi_query_async_$_state_machine__2879__auto__ = null;
var fluree$db$api$query$multi_query_async_$_state_machine__2879__auto____0 = (function (){
var statearr_62845 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_62845[(0)] = fluree$db$api$query$multi_query_async_$_state_machine__2879__auto__);

(statearr_62845[(1)] = (1));

return statearr_62845;
});
var fluree$db$api$query$multi_query_async_$_state_machine__2879__auto____1 = (function (state_62768){
while(true){
var ret_value__2880__auto__ = (function (){try{while(true){
var result__2881__auto__ = switch__2878__auto__(state_62768);
if(cljs.core.keyword_identical_QMARK_(result__2881__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2881__auto__;
}
break;
}
}catch (e62846){var ex__2882__auto__ = e62846;
var statearr_62847_62908 = state_62768;
(statearr_62847_62908[(2)] = ex__2882__auto__);


if(cljs.core.seq((state_62768[(4)]))){
var statearr_62848_62909 = state_62768;
(statearr_62848_62909[(1)] = cljs.core.first((state_62768[(4)])));

} else {
throw ex__2882__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2880__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__62910 = state_62768;
state_62768 = G__62910;
continue;
} else {
return ret_value__2880__auto__;
}
break;
}
});
fluree$db$api$query$multi_query_async_$_state_machine__2879__auto__ = function(state_62768){
switch(arguments.length){
case 0:
return fluree$db$api$query$multi_query_async_$_state_machine__2879__auto____0.call(this);
case 1:
return fluree$db$api$query$multi_query_async_$_state_machine__2879__auto____1.call(this,state_62768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$api$query$multi_query_async_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$api$query$multi_query_async_$_state_machine__2879__auto____0;
fluree$db$api$query$multi_query_async_$_state_machine__2879__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$api$query$multi_query_async_$_state_machine__2879__auto____1;
return fluree$db$api$query$multi_query_async_$_state_machine__2879__auto__;
})()
})();
var state__2903__auto__ = (function (){var statearr_62849 = (f__2902__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2902__auto__.cljs$core$IFn$_invoke$arity$0() : f__2902__auto__.call(null));
(statearr_62849[(6)] = c__2901__auto__);

return statearr_62849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2903__auto__);
}));

return c__2901__auto__;
});
/**
 * Generic query interface. Will determine if multi-query, standard query, block or history
 *   and dispatch appropriately.
 * 
 *   For now, sources is expected to be just a db. In the case of a block query, which requires
 *   a conn + ledger, those will be extracted from the db.
 */
fluree.db.api.query.query = (function fluree$db$api$query$query(source,flureeQL){
var query_type = fluree.db.api.query.query_type(flureeQL);
var G__62911 = query_type;
var G__62911__$1 = (((G__62911 instanceof cljs.core.Keyword))?G__62911.fqn:null);
switch (G__62911__$1) {
case "standard":
return fluree.db.api.query.query_async(source,flureeQL);

break;
case "history":
return fluree.db.api.query.history_query_async(source,flureeQL);

break;
case "block":
var conn = new cljs.core.Keyword(null,"conn","conn",278309663).cljs$core$IFn$_invoke$arity$1(source);
var ledger = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"network","network",2050004697).cljs$core$IFn$_invoke$arity$1(source),new cljs.core.Keyword(null,"dbid","dbid",-196647356).cljs$core$IFn$_invoke$arity$1(source));
return fluree.db.api.query.block_query_async(conn,ledger,flureeQL);

break;
case "multi":
return fluree.db.api.query.multi_query_async(source,flureeQL);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__62911__$1)].join('')));

}
});
