// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('cljs.core');
goog.require('goog.math.Long');
goog.require('goog.math.Integer');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.array');
goog.require('goog.Uri');
goog.require('goog.string.StringBuffer');
cljs.core._STAR_clojurescript_version_STAR_ = "1.10.844";
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_unchecked_arrays_STAR_ = false;
cljs.core._STAR_warn_on_infer_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.PROTOCOL_SENTINEL !== 'undefined')){
} else {
cljs.core.PROTOCOL_SENTINEL = ({});
}
cljs.core.MODULE_URIS = null;
cljs.core.MODULE_INFOS = null;

/**
 * Var bound to the name value of the compiler build :target option.
 *   For example, if the compiler build :target is :nodejs, *target* will be bound
 *   to "nodejs". *target* is a Google Closure define and can be set by compiler
 *   :closure-defines option.
 * @define {string}
 */
cljs.core._STAR_target_STAR_ = goog.define("cljs.core._STAR_target_STAR_","default");

/**
 * Manually set the JavaScript global context. Only "window", "self"
 *   , and "global" supported. 
 * @define {string}
 */
cljs.core._STAR_global_STAR_ = goog.define("cljs.core._STAR_global_STAR_","default");
/**
 * Var bound to the current namespace. Only used for bootstrapping.
 * @type {*}
 */
cljs.core._STAR_ns_STAR_ = null;
/**
 * @type {*}
 */
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print output.
 *   Whatever function *print-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = null;
}
/**
 * Arranges to have tap functions executed via the supplied f, a
 *   function of no arguments. Returns true if successful, false otherwise.
 */
cljs.core._STAR_exec_tap_fn_STAR_ = (function cljs$core$_STAR_exec_tap_fn_STAR_(f){
return (((typeof setTimeout !== 'undefined')) && (cljs.core.boolean$(setTimeout(f,(0)))));
});
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_print_err_fn_STAR_ !== 'undefined')){
} else {
/**
 * Each runtime environment provides a different way to print error output.
 *   Whatever function *print-err-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_err_fn_STAR_ = null;
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return (cljs.core._STAR_print_fn_STAR_ = f);
});
/**
 * Set *print-err-fn* to f.
 */
cljs.core.set_print_err_fn_BANG_ = (function cljs$core$set_print_err_fn_BANG_(f){
return (cljs.core._STAR_print_err_fn_STAR_ = f);
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 *   Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 *   This is to work around the implicit newlines emitted by standard JavaScript
 *   console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 *   non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 *   Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 *   be printed in a form that can be read back by the reader.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 *   their type when read in later.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * *print-namespace-maps* controls whether the printer will print
 *   namespace map literal syntax.
 * 
 *   Defaults to false, but the REPL binds it to true.
 */
cljs.core._STAR_print_namespace_maps_STAR_ = false;
/**
 * *print-length* controls how many items of each collection the
 *   printer will print. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   number of items of each collection to print. If a collection contains
 *   more items, the printer will print items up to the limit followed by
 *   '...' to represent the remaining items. The root binding is nil
 *   indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 *   print nested objects. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   level to print. Each argument to print is at level 0; if an argument is a
 *   collection, its items are at level 1; and so on. If an object is a
 *   collection and is at a level greater than or equal to the value bound to
 *   *print-level*, the printer prints '#' to represent it. The root binding
 *   is nil indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_level_STAR_ = null;
/**
 * *print-fns-bodies* controls whether functions print their source or
 *  only their names.
 */
cljs.core._STAR_print_fn_bodies_STAR_ = false;
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined')){
} else {
/**
 * @type {*}
 */
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$flush_DASH_on_DASH_newline,cljs.core._STAR_flush_on_newline_STAR_,cljs.core.cst$kw$readably,cljs.core._STAR_print_readably_STAR_,cljs.core.cst$kw$meta,cljs.core._STAR_print_meta_STAR_,cljs.core.cst$kw$dup,cljs.core._STAR_print_dup_STAR_,cljs.core.cst$kw$print_DASH_length,cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
(cljs.core._STAR_print_newline_STAR_ = false);

cljs.core.set_print_fn_BANG_((function (){
var xs = arguments;
return console.log.apply(console,goog.array.clone(xs));
}));

cljs.core.set_print_err_fn_BANG_((function (){
var xs = arguments;
return console.error.apply(console,goog.array.clone(xs));
}));

return null;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if((x == null)){
return true;
} else {
if(x === false){
return true;
} else {
return false;

}
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return (!((x == null)));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if((!((x == null)))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
return ("string" === goog.typeOf(x));
});
/**
 * Returns true if x is a JavaScript string of length one.
 */
cljs.core.char_QMARK_ = (function cljs$core$char_QMARK_(x){
return ((typeof x === 'string') && (((1) === x.length)));
});
/**
 * Returns true if given any argument.
 */
cljs.core.any_QMARK_ = (function cljs$core$any_QMARK_(x){
return true;
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[goog.typeOf(x__$1)])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever function
 *   *main-cli-fn* is set to will be called with the command-line
 *   argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * A sequence of the supplied command line arguments, or nil if
 *   none were supplied
 */
cljs.core._STAR_command_line_args_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__4149__auto__ = ty;
if(cljs.core.truth_(and__4149__auto__)){
return ty.cljs$lang$type;
} else {
return and__4149__auto__;
}
})())?ty.cljs$lang$ctorStr:goog.typeOf(obj));
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__5751__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__5751__auto__)){
var s = temp__5751__auto__;
return s;
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(ty);
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((((typeof Symbol !== 'undefined')) && ((goog.typeOf(Symbol) === "function")))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * @enum {string}
 */
cljs.core.CHAR_MAP = ({"]": "_RBRACK_", "'": "_SINGLEQUOTE_", "=": "_EQ_", "\"": "_DOUBLEQUOTE_", "!": "_BANG_", "*": "_STAR_", "%": "_PERCENT_", "|": "_BAR_", "~": "_TILDE_", "/": "_SLASH_", "\\": "_BSLASH_", "-": "_", "?": "_QMARK_", "&": "_AMPERSAND_", ":": "_COLON_", "<": "_LT_", "{": "_LBRACE_", "}": "_RBRACE_", "[": "_LBRACK_", "#": "_SHARP_", "^": "_CARET_", "+": "_PLUS_", "@": "_CIRCA_", ">": "_GT_"});
/**
 * @enum {string}
 */
cljs.core.DEMUNGE_MAP = ({"_RBRACE_": "}", "_COLON_": ":", "_BANG_": "!", "_QMARK_": "?", "_BSLASH_": "\\\\", "_SLASH_": "/", "_PERCENT_": "%", "_PLUS_": "+", "_SHARP_": "#", "_LBRACE_": "{", "_BAR_": "|", "_LBRACK_": "[", "_EQ_": "=", "_": "-", "_TILDE_": "~", "_RBRACK_": "]", "_GT_": ">", "_SINGLEQUOTE_": "'", "_CIRCA_": "@", "_AMPERSAND_": "&", "_DOUBLEQUOTE_": "\\\"", "_CARET_": "^", "_LT_": "<", "_STAR_": "*"});
cljs.core.DEMUNGE_PATTERN = null;
/**
 * Returns highest resolution time offered by host in milliseconds.
 */
cljs.core.system_time = (function cljs$core$system_time(){
if((((typeof performance !== 'undefined')) && ((!((performance.now == null)))))){
return performance.now();
} else {
if((((typeof process !== 'undefined')) && ((!((process.hrtime == null)))))){
var t = process.hrtime();
return ((((t[(0)]) * 1.0E9) + (t[(1)])) / 1000000.0);
} else {
return (new Date()).getTime();

}
}
});
/**
 * Construct a JavaScript array of the specified dimensions. Accepts ignored
 *   type argument for compatibility with Clojure. Note that there is no efficient
 *   way to allocate multi-dimensional arrays in JavaScript; as such, this function
 *   will run in polynomial time when called with 3 or more arguments.
 */
cljs.core.make_array = (function cljs$core$make_array(var_args){
var G__3260 = arguments.length;
switch (G__3260) {
case 1:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3262 = arguments.length;
var i__4772__auto___3263 = (0);
while(true){
if((i__4772__auto___3263 < len__4771__auto___3262)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3263]));

var G__3264 = (i__4772__auto___3263 + (1));
i__4772__auto___3263 = G__3264;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = (function (size){
return (new Array(size));
}));

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = (function (type,size){
return (new Array(size));
}));

(cljs.core.make_array.cljs$core$IFn$_invoke$arity$variadic = (function (type,size,more_sizes){
var dims = more_sizes;
var dimarray = (new Array(size));
var n__4648__auto___3265 = dimarray.length;
var i_3266 = (0);
while(true){
if((i_3266 < n__4648__auto___3265)){
(dimarray[i_3266] = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.make_array,null,dims));

var G__3267 = (i_3266 + (1));
i_3266 = G__3267;
continue;
} else {
}
break;
}

return dimarray;
}));

/** @this {Function} */
(cljs.core.make_array.cljs$lang$applyTo = (function (seq3257){
var G__3258 = cljs.core.first(seq3257);
var seq3257__$1 = cljs.core.next(seq3257);
var G__3259 = cljs.core.first(seq3257__$1);
var seq3257__$2 = cljs.core.next(seq3257__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3258,G__3259,seq3257__$2);
}));

(cljs.core.make_array.cljs$lang$maxFixedArity = (2));

/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__4648__auto___3268 = len;
var i_3269 = (0);
while(true){
if((i_3269 < n__4648__auto___3268)){
(new_arr[i_3269] = (arr[i_3269]));

var G__3270 = (i_3269 + (1));
i_3269 = G__3270;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__3271 = (i + (1));
i = G__3271;
continue;
} else {
return a;
}
break;
}
});
cljs.core.maybe_warn = (function cljs$core$maybe_warn(e){
if(cljs.core.truth_(cljs.core._STAR_print_err_fn_STAR_)){
return (cljs.core._STAR_print_err_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_err_fn_STAR_.cljs$core$IFn$_invoke$arity$1(e) : cljs.core._STAR_print_err_fn_STAR_.call(null,e));
} else {
return null;
}
});
cljs.core.checked_aget = (function cljs$core$checked_aget(var_args){
var G__3276 = arguments.length;
switch (G__3276) {
case 2:
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3279 = arguments.length;
var i__4772__auto___3280 = (0);
while(true){
if((i__4772__auto___3280 < len__4771__auto___3279)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3280]));

var G__3281 = (i__4772__auto___3280 + (1));
i__4772__auto___3280 = G__3281;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2 = (function (array,idx){
try{if(cljs.core.truth_((function (){var or__4160__auto__ = cljs.core.array_QMARK_(array);
if(or__4160__auto__){
return or__4160__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e3277){var e_3282 = e3277;
cljs.core.maybe_warn(e_3282);
}
return (array[idx]);
}));

(cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.checked_aget,cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx),idxs);
}));

/** @this {Function} */
(cljs.core.checked_aget.cljs$lang$applyTo = (function (seq3273){
var G__3274 = cljs.core.first(seq3273);
var seq3273__$1 = cljs.core.next(seq3273);
var G__3275 = cljs.core.first(seq3273__$1);
var seq3273__$2 = cljs.core.next(seq3273__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3274,G__3275,seq3273__$2);
}));

(cljs.core.checked_aget.cljs$lang$maxFixedArity = (2));

cljs.core.checked_aset = (function cljs$core$checked_aset(var_args){
var G__3288 = arguments.length;
switch (G__3288) {
case 3:
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3291 = arguments.length;
var i__4772__auto___3292 = (0);
while(true){
if((i__4772__auto___3292 < len__4771__auto___3291)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3292]));

var G__3293 = (i__4772__auto___3292 + (1));
i__4772__auto___3292 = G__3293;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((3)),(0),null));
return cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4793__auto__);

}
});

(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$3 = (function (array,idx,val){
try{if(cljs.core.truth_((function (){var or__4160__auto__ = cljs.core.array_QMARK_(array);
if(or__4160__auto__){
return or__4160__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}
}catch (e3289){var e_3294 = e3289;
cljs.core.maybe_warn(e_3294);
}
return (array[idx] = val);
}));

(cljs.core.checked_aset.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.checked_aset,cljs.core.checked_aget.cljs$core$IFn$_invoke$arity$2(array,idx),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.checked_aset.cljs$lang$applyTo = (function (seq3284){
var G__3285 = cljs.core.first(seq3284);
var seq3284__$1 = cljs.core.next(seq3284);
var G__3286 = cljs.core.first(seq3284__$1);
var seq3284__$2 = cljs.core.next(seq3284__$1);
var G__3287 = cljs.core.first(seq3284__$2);
var seq3284__$3 = cljs.core.next(seq3284__$2);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3285,G__3286,G__3287,seq3284__$3);
}));

(cljs.core.checked_aset.cljs$lang$maxFixedArity = (3));

cljs.core.checked_aget_SINGLEQUOTE_ = (function cljs$core$checked_aget_SINGLEQUOTE_(var_args){
var G__3299 = arguments.length;
switch (G__3299) {
case 2:
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3301 = arguments.length;
var i__4772__auto___3302 = (0);
while(true){
if((i__4772__auto___3302 < len__4771__auto___3301)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3302]));

var G__3303 = (i__4772__auto___3302 + (1));
i__4772__auto___3302 = G__3303;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2 = (function (array,idx){
if(cljs.core.truth_((function (){var or__4160__auto__ = cljs.core.array_QMARK_(array);
if(or__4160__auto__){
return or__4160__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx]);
}));

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.checked_aget_SINGLEQUOTE_,cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx),idxs);
}));

/** @this {Function} */
(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$applyTo = (function (seq3296){
var G__3297 = cljs.core.first(seq3296);
var seq3296__$1 = cljs.core.next(seq3296);
var G__3298 = cljs.core.first(seq3296__$1);
var seq3296__$2 = cljs.core.next(seq3296__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3297,G__3298,seq3296__$2);
}));

(cljs.core.checked_aget_SINGLEQUOTE_.cljs$lang$maxFixedArity = (2));

cljs.core.checked_aset_SINGLEQUOTE_ = (function cljs$core$checked_aset_SINGLEQUOTE_(var_args){
var G__3309 = arguments.length;
switch (G__3309) {
case 3:
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3311 = arguments.length;
var i__4772__auto___3312 = (0);
while(true){
if((i__4772__auto___3312 < len__4771__auto___3311)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3312]));

var G__3313 = (i__4772__auto___3312 + (1));
i__4772__auto___3312 = G__3313;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((3)),(0),null));
return cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4793__auto__);

}
});

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$3 = (function (array,idx,val){
if(cljs.core.truth_((function (){var or__4160__auto__ = cljs.core.array_QMARK_(array);
if(or__4160__auto__){
return or__4160__auto__;
} else {
return goog.isArrayLike(array);
}
})())){
} else {
throw (new Error("Assert failed: (or (array? array) (goog/isArrayLike array))"));
}

if(typeof idx === 'number'){
} else {
throw (new Error("Assert failed: (number? idx)"));
}

if((!((idx < (0))))){
} else {
throw (new Error("Assert failed: (not (neg? idx))"));
}

if((idx < array.length)){
} else {
throw (new Error("Assert failed: (< idx (alength array))"));
}

return (array[idx] = val);
}));

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.checked_aset_SINGLEQUOTE_,cljs.core.checked_aget_SINGLEQUOTE_.cljs$core$IFn$_invoke$arity$2(array,idx),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$applyTo = (function (seq3305){
var G__3306 = cljs.core.first(seq3305);
var seq3305__$1 = cljs.core.next(seq3305);
var G__3307 = cljs.core.first(seq3305__$1);
var seq3305__$2 = cljs.core.next(seq3305__$1);
var G__3308 = cljs.core.first(seq3305__$2);
var seq3305__$3 = cljs.core.next(seq3305__$2);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3306,G__3307,G__3308,seq3305__$3);
}));

(cljs.core.checked_aset_SINGLEQUOTE_.cljs$lang$maxFixedArity = (3));

/**
 * Returns the value at the index/indices. Works on JavaScript arrays.
 */
cljs.core.aget = (function cljs$core$aget(var_args){
var G__3318 = arguments.length;
switch (G__3318) {
case 2:
return cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3320 = arguments.length;
var i__4772__auto___3321 = (0);
while(true){
if((i__4772__auto___3321 < len__4771__auto___3320)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3321]));

var G__3322 = (i__4772__auto___3321 + (1));
i__4772__auto___3321 = G__3322;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = (function (array,idx){
return (array[idx]);
}));

(cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idxs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.aget,(array[idx]),idxs);
}));

/** @this {Function} */
(cljs.core.aget.cljs$lang$applyTo = (function (seq3315){
var G__3316 = cljs.core.first(seq3315);
var seq3315__$1 = cljs.core.next(seq3315);
var G__3317 = cljs.core.first(seq3315__$1);
var seq3315__$2 = cljs.core.next(seq3315__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3316,G__3317,seq3315__$2);
}));

(cljs.core.aget.cljs$lang$maxFixedArity = (2));

/**
 * Sets the value at the index/indices. Works on JavaScript arrays.
 *   Returns val.
 */
cljs.core.aset = (function cljs$core$aset(var_args){
var G__3328 = arguments.length;
switch (G__3328) {
case 3:
return cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3330 = arguments.length;
var i__4772__auto___3331 = (0);
while(true){
if((i__4772__auto___3331 < len__4771__auto___3330)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3331]));

var G__3332 = (i__4772__auto___3331 + (1));
i__4772__auto___3331 = G__3332;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((3)),(0),null));
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4793__auto__);

}
});

(cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = (function (array,idx,val){
return (array[idx] = val);
}));

(cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.aset,(array[idx]),idx2,idxv);
}));

/** @this {Function} */
(cljs.core.aset.cljs$lang$applyTo = (function (seq3324){
var G__3325 = cljs.core.first(seq3324);
var seq3324__$1 = cljs.core.next(seq3324);
var G__3326 = cljs.core.first(seq3324__$1);
var seq3324__$2 = cljs.core.next(seq3324__$1);
var G__3327 = cljs.core.first(seq3324__$2);
var seq3324__$3 = cljs.core.next(seq3324__$2);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3325,G__3326,G__3327,seq3324__$3);
}));

(cljs.core.aset.cljs$lang$maxFixedArity = (3));

/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 *   argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function cljs$core$into_array(var_args){
var G__3334 = arguments.length;
switch (G__3334) {
case 1:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = (function (aseq){
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
}));

(cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = (function (type,aseq){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (a,x){
a.push(x);

return a;
}),[],aseq);
}));

(cljs.core.into_array.cljs$lang$maxFixedArity = 2);

/**
 * Invoke JavaScript object method via string. Needed when the
 *   string is not a valid unquoted property name.
 */
cljs.core.js_invoke = (function cljs$core$js_invoke(var_args){
var args__4777__auto__ = [];
var len__4771__auto___3339 = arguments.length;
var i__4772__auto___3340 = (0);
while(true){
if((i__4772__auto___3340 < len__4771__auto___3339)){
args__4777__auto__.push((arguments[i__4772__auto___3340]));

var G__3341 = (i__4772__auto___3340 + (1));
i__4772__auto___3340 = G__3341;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((2) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((2)),(0),null)):null);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4778__auto__);
});

(cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = (function (obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
}));

(cljs.core.js_invoke.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(cljs.core.js_invoke.cljs$lang$applyTo = (function (seq3336){
var G__3337 = cljs.core.first(seq3336);
var seq3336__$1 = cljs.core.next(seq3336);
var G__3338 = cljs.core.first(seq3336__$1);
var seq3336__$2 = cljs.core.next(seq3336__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3337,G__3338,seq3336__$2);
}));

/**
 * Returns true if x is an instance of Symbol
 */
cljs.core.js_symbol_QMARK_ = (function cljs$core$js_symbol_QMARK_(x){
return (((goog.typeOf(x) === "symbol")) || ((((typeof Symbol !== 'undefined')) && ((x instanceof Symbol)))));
});

/**
 * Marker protocol
 * @interface
 */
cljs.core.Fn = function(){};


/**
 * Protocol for adding the ability to invoke an object as a function.
 *   For example, a vector can also be used to look up a value:
 *   ([1 2 3 4] 1) => 2
 * @interface
 */
cljs.core.IFn = function(){};

var cljs$core$IFn$_invoke$dyn_3344 = (function() {
var G__3345 = null;
var G__3345__1 = (function (this$){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4464__auto__.call(null,this$));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4461__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__2 = (function (this$,a){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__4464__auto__.call(null,this$,a));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__4461__auto__.call(null,this$,a));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__3 = (function (this$,a,b){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__4464__auto__.call(null,this$,a,b));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__4461__auto__.call(null,this$,a,b));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__4 = (function (this$,a,b,c){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__4464__auto__.call(null,this$,a,b,c));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__4461__auto__.call(null,this$,a,b,c));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__5 = (function (this$,a,b,c,d){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__4464__auto__.call(null,this$,a,b,c,d));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__4461__auto__.call(null,this$,a,b,c,d));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__6 = (function (this$,a,b,c,d,e){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$6 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__4464__auto__.call(null,this$,a,b,c,d,e));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$6 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__4461__auto__.call(null,this$,a,b,c,d,e));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__7 = (function (this$,a,b,c,d,e,f){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$7 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__4464__auto__.call(null,this$,a,b,c,d,e,f));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$7 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__4461__auto__.call(null,this$,a,b,c,d,e,f));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__8 = (function (this$,a,b,c,d,e,f,g){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$8 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__4464__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$8 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__4461__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__9 = (function (this$,a,b,c,d,e,f,g,h){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$9 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__4464__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$9 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__4461__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__10 = (function (this$,a,b,c,d,e,f,g,h,i){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$10 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__4464__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$10 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__4461__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$11 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__4464__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$11 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__4461__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$12 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__4464__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$12 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__4461__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$13 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__4464__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$13 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__4461__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$14 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__4464__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$14 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__4461__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$15 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__4464__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$15 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__4461__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$16 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__4464__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$16 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__4461__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$17 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__4464__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$17 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__4461__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$18 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__4464__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$18 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__4461__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$19 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__4464__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$19 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__4461__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$20 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__4464__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$20 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__4461__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$21 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__4464__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$21 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__4461__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
var G__3345__22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._invoke[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$22 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__4464__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
var m__4461__auto__ = (cljs.core._invoke["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$22 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__4461__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
});
G__3345 = function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__3345__1.call(this,this$);
case 2:
return G__3345__2.call(this,this$,a);
case 3:
return G__3345__3.call(this,this$,a,b);
case 4:
return G__3345__4.call(this,this$,a,b,c);
case 5:
return G__3345__5.call(this,this$,a,b,c,d);
case 6:
return G__3345__6.call(this,this$,a,b,c,d,e);
case 7:
return G__3345__7.call(this,this$,a,b,c,d,e,f);
case 8:
return G__3345__8.call(this,this$,a,b,c,d,e,f,g);
case 9:
return G__3345__9.call(this,this$,a,b,c,d,e,f,g,h);
case 10:
return G__3345__10.call(this,this$,a,b,c,d,e,f,g,h,i);
case 11:
return G__3345__11.call(this,this$,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__3345__12.call(this,this$,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__3345__13.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__3345__14.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__3345__15.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__3345__16.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__3345__17.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__3345__18.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__3345__19.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__3345__20.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__3345__21.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__3345__22.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3345.cljs$core$IFn$_invoke$arity$1 = G__3345__1;
G__3345.cljs$core$IFn$_invoke$arity$2 = G__3345__2;
G__3345.cljs$core$IFn$_invoke$arity$3 = G__3345__3;
G__3345.cljs$core$IFn$_invoke$arity$4 = G__3345__4;
G__3345.cljs$core$IFn$_invoke$arity$5 = G__3345__5;
G__3345.cljs$core$IFn$_invoke$arity$6 = G__3345__6;
G__3345.cljs$core$IFn$_invoke$arity$7 = G__3345__7;
G__3345.cljs$core$IFn$_invoke$arity$8 = G__3345__8;
G__3345.cljs$core$IFn$_invoke$arity$9 = G__3345__9;
G__3345.cljs$core$IFn$_invoke$arity$10 = G__3345__10;
G__3345.cljs$core$IFn$_invoke$arity$11 = G__3345__11;
G__3345.cljs$core$IFn$_invoke$arity$12 = G__3345__12;
G__3345.cljs$core$IFn$_invoke$arity$13 = G__3345__13;
G__3345.cljs$core$IFn$_invoke$arity$14 = G__3345__14;
G__3345.cljs$core$IFn$_invoke$arity$15 = G__3345__15;
G__3345.cljs$core$IFn$_invoke$arity$16 = G__3345__16;
G__3345.cljs$core$IFn$_invoke$arity$17 = G__3345__17;
G__3345.cljs$core$IFn$_invoke$arity$18 = G__3345__18;
G__3345.cljs$core$IFn$_invoke$arity$19 = G__3345__19;
G__3345.cljs$core$IFn$_invoke$arity$20 = G__3345__20;
G__3345.cljs$core$IFn$_invoke$arity$21 = G__3345__21;
G__3345.cljs$core$IFn$_invoke$arity$22 = G__3345__22;
return G__3345;
})()
;
cljs.core._invoke = (function cljs$core$_invoke(var_args){
var G__3343 = arguments.length;
switch (G__3343) {
case 1:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case 9:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case 11:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case 12:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case 13:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case 14:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case 15:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case 16:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case 17:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case 18:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case 19:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case 20:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case 21:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case 22:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = (function (this$){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$1 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$1(this$);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = (function (this$,a){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$2 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$2(this$,a);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = (function (this$,a,b){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$3 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$3(this$,a,b);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = (function (this$,a,b,c){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$4 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = (function (this$,a,b,c,d){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$5 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = (function (this$,a,b,c,d,e){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$6 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = (function (this$,a,b,c,d,e,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$7 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = (function (this$,a,b,c,d,e,f,g){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$8 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = (function (this$,a,b,c,d,e,f,g,h){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$9 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$10 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$11 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$12 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$13 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$14 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$15 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$16 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$17 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$18 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$19 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$20 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$21 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}
}));

(cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IFn$_invoke$arity$22 == null)))))){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
return cljs$core$IFn$_invoke$dyn_3344.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
}));

(cljs.core._invoke.cljs$lang$maxFixedArity = 22);



/**
 * Protocol for cloning a value.
 * @interface
 */
cljs.core.ICloneable = function(){};

var cljs$core$ICloneable$_clone$dyn_3347 = (function (value){
var x__4463__auto__ = (((value == null))?null:value);
var m__4464__auto__ = (cljs.core._clone[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__4464__auto__.call(null,value));
} else {
var m__4461__auto__ = (cljs.core._clone["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__4461__auto__.call(null,value));
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
});
/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((((!((value == null)))) && ((!((value.cljs$core$ICloneable$_clone$arity$1 == null)))))){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
return cljs$core$ICloneable$_clone$dyn_3347(value);
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 * @interface
 */
cljs.core.ICounted = function(){};

var cljs$core$ICounted$_count$dyn_3348 = (function (coll){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._count[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4464__auto__.call(null,coll));
} else {
var m__4461__auto__ = (cljs.core._count["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4461__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
});
/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICounted$_count$arity$1 == null)))))){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
return cljs$core$ICounted$_count$dyn_3348(coll);
}
});


/**
 * Protocol for creating an empty collection.
 * @interface
 */
cljs.core.IEmptyableCollection = function(){};

var cljs$core$IEmptyableCollection$_empty$dyn_3349 = (function (coll){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._empty[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4464__auto__.call(null,coll));
} else {
var m__4461__auto__ = (cljs.core._empty["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4461__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
});
/**
 * Returns an empty collection of the same category as coll. Used
 *   by cljs.core/empty.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)))))){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
return cljs$core$IEmptyableCollection$_empty$dyn_3349(coll);
}
});


/**
 * Protocol for adding to a collection.
 * @interface
 */
cljs.core.ICollection = function(){};

var cljs$core$ICollection$_conj$dyn_3350 = (function (coll,o){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._conj[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__4464__auto__.call(null,coll,o));
} else {
var m__4461__auto__ = (cljs.core._conj["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__4461__auto__.call(null,coll,o));
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
});
/**
 * Returns a new collection of coll with o added to it. The new item
 *   should be added to the most efficient place, e.g.
 *   (conj [1 2 3 4] 5) => [1 2 3 4 5]
 *   (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((((!((coll == null)))) && ((!((coll.cljs$core$ICollection$_conj$arity$2 == null)))))){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
return cljs$core$ICollection$_conj$dyn_3350(coll,o);
}
});


/**
 * Protocol for collections to provide indexed-based access to their items.
 * @interface
 */
cljs.core.IIndexed = function(){};

var cljs$core$IIndexed$_nth$dyn_3353 = (function() {
var G__3354 = null;
var G__3354__2 = (function (coll,n){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._nth[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__4464__auto__.call(null,coll,n));
} else {
var m__4461__auto__ = (cljs.core._nth["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__4461__auto__.call(null,coll,n));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
});
var G__3354__3 = (function (coll,n,not_found){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._nth[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__4464__auto__.call(null,coll,n,not_found));
} else {
var m__4461__auto__ = (cljs.core._nth["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__4461__auto__.call(null,coll,n,not_found));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
});
G__3354 = function(coll,n,not_found){
switch(arguments.length){
case 2:
return G__3354__2.call(this,coll,n);
case 3:
return G__3354__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3354.cljs$core$IFn$_invoke$arity$2 = G__3354__2;
G__3354.cljs$core$IFn$_invoke$arity$3 = G__3354__3;
return G__3354;
})()
;
/**
 * Returns the value at the index n in the collection coll.
 *   Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function cljs$core$_nth(var_args){
var G__3352 = arguments.length;
switch (G__3352) {
case 2:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$2 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
return cljs$core$IIndexed$_nth$dyn_3353.cljs$core$IFn$_invoke$arity$2(coll,n);
}
}));

(cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIndexed$_nth$arity$3 == null)))))){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
return cljs$core$IIndexed$_nth$dyn_3353.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
}
}));

(cljs.core._nth.cljs$lang$maxFixedArity = 3);



/**
 * Marker protocol indicating an array sequence.
 * @interface
 */
cljs.core.ASeq = function(){};


/**
 * Protocol for collections to provide access to their items as sequences.
 * @interface
 */
cljs.core.ISeq = function(){};

var cljs$core$ISeq$_first$dyn_3356 = (function (coll){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._first[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4464__auto__.call(null,coll));
} else {
var m__4461__auto__ = (cljs.core._first["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4461__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
});
/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_first$arity$1 == null)))))){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
return cljs$core$ISeq$_first$dyn_3356(coll);
}
});

var cljs$core$ISeq$_rest$dyn_3357 = (function (coll){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._rest[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4464__auto__.call(null,coll));
} else {
var m__4461__auto__ = (cljs.core._rest["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4461__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
});
/**
 * Returns a new collection of coll without the first item. It should
 *   always return a seq, e.g.
 *   (rest []) => ()
 *   (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISeq$_rest$arity$1 == null)))))){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
return cljs$core$ISeq$_rest$dyn_3357(coll);
}
});


/**
 * Protocol for accessing the next items of a collection.
 * @interface
 */
cljs.core.INext = function(){};

var cljs$core$INext$_next$dyn_3358 = (function (coll){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._next[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4464__auto__.call(null,coll));
} else {
var m__4461__auto__ = (cljs.core._next["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4461__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
});
/**
 * Returns a new collection of coll without the first item. In contrast to
 *   rest, it should return nil if there are no more items, e.g.
 *   (next []) => nil
 *   (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$INext$_next$arity$1 == null)))))){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
return cljs$core$INext$_next$dyn_3358(coll);
}
});


/**
 * Protocol for looking up a value in a data structure.
 * @interface
 */
cljs.core.ILookup = function(){};

var cljs$core$ILookup$_lookup$dyn_3361 = (function() {
var G__3362 = null;
var G__3362__2 = (function (o,k){
var x__4463__auto__ = (((o == null))?null:o);
var m__4464__auto__ = (cljs.core._lookup[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__4464__auto__.call(null,o,k));
} else {
var m__4461__auto__ = (cljs.core._lookup["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__4461__auto__.call(null,o,k));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
});
var G__3362__3 = (function (o,k,not_found){
var x__4463__auto__ = (((o == null))?null:o);
var m__4464__auto__ = (cljs.core._lookup[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__4464__auto__.call(null,o,k,not_found));
} else {
var m__4461__auto__ = (cljs.core._lookup["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__4461__auto__.call(null,o,k,not_found));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
});
G__3362 = function(o,k,not_found){
switch(arguments.length){
case 2:
return G__3362__2.call(this,o,k);
case 3:
return G__3362__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3362.cljs$core$IFn$_invoke$arity$2 = G__3362__2;
G__3362.cljs$core$IFn$_invoke$arity$3 = G__3362__3;
return G__3362;
})()
;
/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 *   a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function cljs$core$_lookup(var_args){
var G__3360 = arguments.length;
switch (G__3360) {
case 2:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$2 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
return cljs$core$ILookup$_lookup$dyn_3361.cljs$core$IFn$_invoke$arity$2(o,k);
}
}));

(cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if((((!((o == null)))) && ((!((o.cljs$core$ILookup$_lookup$arity$3 == null)))))){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
return cljs$core$ILookup$_lookup$dyn_3361.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
}
}));

(cljs.core._lookup.cljs$lang$maxFixedArity = 3);



/**
 * Protocol for adding associativity to collections.
 * @interface
 */
cljs.core.IAssociative = function(){};

var cljs$core$IAssociative$_contains_key_QMARK_$dyn_3364 = (function (coll,k){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._contains_key_QMARK_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4464__auto__.call(null,coll,k));
} else {
var m__4461__auto__ = (cljs.core._contains_key_QMARK_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4461__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
});
/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)))))){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
return cljs$core$IAssociative$_contains_key_QMARK_$dyn_3364(coll,k);
}
});

var cljs$core$IAssociative$_assoc$dyn_3365 = (function (coll,k,v){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._assoc[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__4464__auto__.call(null,coll,k,v));
} else {
var m__4461__auto__ = (cljs.core._assoc["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__4461__auto__.call(null,coll,k,v));
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
});
/**
 * Returns a new collection of coll with a mapping from key k to
 *   value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$IAssociative$_assoc$arity$3 == null)))))){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
return cljs$core$IAssociative$_assoc$dyn_3365(coll,k,v);
}
});


/**
 * Protocol for implementing entry finding in collections.
 * @interface
 */
cljs.core.IFind = function(){};

var cljs$core$IFind$_find$dyn_3366 = (function (coll,k){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._find[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4464__auto__.call(null,coll,k));
} else {
var m__4461__auto__ = (cljs.core._find["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4461__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IFind.-find",coll);
}
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core._find = (function cljs$core$_find(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IFind$_find$arity$2 == null)))))){
return coll.cljs$core$IFind$_find$arity$2(coll,k);
} else {
return cljs$core$IFind$_find$dyn_3366(coll,k);
}
});


/**
 * Protocol for adding mapping functionality to collections.
 * @interface
 */
cljs.core.IMap = function(){};

var cljs$core$IMap$_dissoc$dyn_3367 = (function (coll,k){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._dissoc[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4464__auto__.call(null,coll,k));
} else {
var m__4461__auto__ = (cljs.core._dissoc["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__4461__auto__.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
});
/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMap$_dissoc$arity$2 == null)))))){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
return cljs$core$IMap$_dissoc$dyn_3367(coll,k);
}
});


/**
 * Protocol for examining a map entry.
 * @interface
 */
cljs.core.IMapEntry = function(){};

var cljs$core$IMapEntry$_key$dyn_3368 = (function (coll){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._key[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4464__auto__.call(null,coll));
} else {
var m__4461__auto__ = (cljs.core._key["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4461__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_key$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
return cljs$core$IMapEntry$_key$dyn_3368(coll);
}
});

var cljs$core$IMapEntry$_val$dyn_3369 = (function (coll){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._val[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4464__auto__.call(null,coll));
} else {
var m__4461__auto__ = (cljs.core._val["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4461__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
});
/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IMapEntry$_val$arity$1 == null)))))){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
return cljs$core$IMapEntry$_val$dyn_3369(coll);
}
});


/**
 * Protocol for adding set functionality to a collection.
 * @interface
 */
cljs.core.ISet = function(){};

var cljs$core$ISet$_disjoin$dyn_3370 = (function (coll,v){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._disjoin[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__4464__auto__.call(null,coll,v));
} else {
var m__4461__auto__ = (cljs.core._disjoin["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__4461__auto__.call(null,coll,v));
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
});
/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISet$_disjoin$arity$2 == null)))))){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
return cljs$core$ISet$_disjoin$dyn_3370(coll,v);
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 *   of the stack should be accessed in the most efficient way for the different
 *   data structures.
 * @interface
 */
cljs.core.IStack = function(){};

var cljs$core$IStack$_peek$dyn_3371 = (function (coll){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._peek[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4464__auto__.call(null,coll));
} else {
var m__4461__auto__ = (cljs.core._peek["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4461__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
});
/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_peek$arity$1 == null)))))){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
return cljs$core$IStack$_peek$dyn_3371(coll);
}
});

var cljs$core$IStack$_pop$dyn_3372 = (function (coll){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._pop[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4464__auto__.call(null,coll));
} else {
var m__4461__auto__ = (cljs.core._pop["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4461__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
});
/**
 * Returns a new stack without the item on top of the stack. Is used
 *   by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IStack$_pop$arity$1 == null)))))){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
return cljs$core$IStack$_pop$dyn_3372(coll);
}
});


/**
 * Protocol for adding vector functionality to collections.
 * @interface
 */
cljs.core.IVector = function(){};

var cljs$core$IVector$_assoc_n$dyn_3373 = (function (coll,n,val){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._assoc_n[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__4464__auto__.call(null,coll,n,val));
} else {
var m__4461__auto__ = (cljs.core._assoc_n["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__4461__auto__.call(null,coll,n,val));
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
});
/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((((!((coll == null)))) && ((!((coll.cljs$core$IVector$_assoc_n$arity$3 == null)))))){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
return cljs$core$IVector$_assoc_n$dyn_3373(coll,n,val);
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 * @interface
 */
cljs.core.IDeref = function(){};

var cljs$core$IDeref$_deref$dyn_3374 = (function (o){
var x__4463__auto__ = (((o == null))?null:o);
var m__4464__auto__ = (cljs.core._deref[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4464__auto__.call(null,o));
} else {
var m__4461__auto__ = (cljs.core._deref["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4461__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
});
/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((((!((o == null)))) && ((!((o.cljs$core$IDeref$_deref$arity$1 == null)))))){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
return cljs$core$IDeref$_deref$dyn_3374(o);
}
});


/**
 * @interface
 */
cljs.core.IDerefWithTimeout = function(){};

var cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_3375 = (function (o,msec,timeout_val){
var x__4463__auto__ = (((o == null))?null:o);
var m__4464__auto__ = (cljs.core._deref_with_timeout[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__4464__auto__.call(null,o,msec,timeout_val));
} else {
var m__4461__auto__ = (cljs.core._deref_with_timeout["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__4461__auto__.call(null,o,msec,timeout_val));
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
});
cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((((!((o == null)))) && ((!((o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)))))){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
return cljs$core$IDerefWithTimeout$_deref_with_timeout$dyn_3375(o,msec,timeout_val);
}
});


/**
 * Protocol for accessing the metadata of an object.
 * @interface
 */
cljs.core.IMeta = function(){};

var cljs$core$IMeta$_meta$dyn_3376 = (function (o){
var x__4463__auto__ = (((o == null))?null:o);
var m__4464__auto__ = (cljs.core._meta[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4464__auto__.call(null,o));
} else {
var m__4461__auto__ = (cljs.core._meta["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4461__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
});
/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((((!((o == null)))) && ((!((o.cljs$core$IMeta$_meta$arity$1 == null)))))){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
return cljs$core$IMeta$_meta$dyn_3376(o);
}
});


/**
 * Protocol for adding metadata to an object.
 * @interface
 */
cljs.core.IWithMeta = function(){};

var cljs$core$IWithMeta$_with_meta$dyn_3377 = (function (o,meta){
var x__4463__auto__ = (((o == null))?null:o);
var m__4464__auto__ = (cljs.core._with_meta[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__4464__auto__.call(null,o,meta));
} else {
var m__4461__auto__ = (cljs.core._with_meta["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__4461__auto__.call(null,o,meta));
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
});
/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((((!((o == null)))) && ((!((o.cljs$core$IWithMeta$_with_meta$arity$2 == null)))))){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
return cljs$core$IWithMeta$_with_meta$dyn_3377(o,meta);
}
});


/**
 * Protocol for seq types that can reduce themselves.
 *   Called by cljs.core/reduce.
 * @interface
 */
cljs.core.IReduce = function(){};

var cljs$core$IReduce$_reduce$dyn_3380 = (function() {
var G__3381 = null;
var G__3381__2 = (function (coll,f){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._reduce[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__4464__auto__.call(null,coll,f));
} else {
var m__4461__auto__ = (cljs.core._reduce["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__4461__auto__.call(null,coll,f));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
});
var G__3381__3 = (function (coll,f,start){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._reduce[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__4464__auto__.call(null,coll,f,start));
} else {
var m__4461__auto__ = (cljs.core._reduce["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__4461__auto__.call(null,coll,f,start));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
});
G__3381 = function(coll,f,start){
switch(arguments.length){
case 2:
return G__3381__2.call(this,coll,f);
case 3:
return G__3381__3.call(this,coll,f,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3381.cljs$core$IFn$_invoke$arity$2 = G__3381__2;
G__3381.cljs$core$IFn$_invoke$arity$3 = G__3381__3;
return G__3381;
})()
;
/**
 * f should be a function of 2 arguments. If start is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function cljs$core$_reduce(var_args){
var G__3379 = arguments.length;
switch (G__3379) {
case 2:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = (function (coll,f){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$2 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
return cljs$core$IReduce$_reduce$dyn_3380.cljs$core$IFn$_invoke$arity$2(coll,f);
}
}));

(cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = (function (coll,f,start){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReduce$_reduce$arity$3 == null)))))){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
return cljs$core$IReduce$_reduce$dyn_3380.cljs$core$IFn$_invoke$arity$3(coll,f,start);
}
}));

(cljs.core._reduce.cljs$lang$maxFixedArity = 3);



/**
 * Protocol for associative types that can reduce themselves
 *   via a function of key and val. Called by cljs.core/reduce-kv.
 * @interface
 */
cljs.core.IKVReduce = function(){};

var cljs$core$IKVReduce$_kv_reduce$dyn_3383 = (function (coll,f,init){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._kv_reduce[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__4464__auto__.call(null,coll,f,init));
} else {
var m__4461__auto__ = (cljs.core._kv_reduce["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__4461__auto__.call(null,coll,f,init));
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
});
/**
 * Reduces an associative collection and returns the result. f should be
 *   a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((((!((coll == null)))) && ((!((coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)))))){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
return cljs$core$IKVReduce$_kv_reduce$dyn_3383(coll,f,init);
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 * @interface
 */
cljs.core.IEquiv = function(){};

var cljs$core$IEquiv$_equiv$dyn_3384 = (function (o,other){
var x__4463__auto__ = (((o == null))?null:o);
var m__4464__auto__ = (cljs.core._equiv[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__4464__auto__.call(null,o,other));
} else {
var m__4461__auto__ = (cljs.core._equiv["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__4461__auto__.call(null,o,other));
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
});
/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((((!((o == null)))) && ((!((o.cljs$core$IEquiv$_equiv$arity$2 == null)))))){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
return cljs$core$IEquiv$_equiv$dyn_3384(o,other);
}
});


/**
 * Protocol for adding hashing functionality to a type.
 * @interface
 */
cljs.core.IHash = function(){};

var cljs$core$IHash$_hash$dyn_3385 = (function (o){
var x__4463__auto__ = (((o == null))?null:o);
var m__4464__auto__ = (cljs.core._hash[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4464__auto__.call(null,o));
} else {
var m__4461__auto__ = (cljs.core._hash["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4461__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
});
/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((((!((o == null)))) && ((!((o.cljs$core$IHash$_hash$arity$1 == null)))))){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
return cljs$core$IHash$_hash$dyn_3385(o);
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 * @interface
 */
cljs.core.ISeqable = function(){};

var cljs$core$ISeqable$_seq$dyn_3386 = (function (o){
var x__4463__auto__ = (((o == null))?null:o);
var m__4464__auto__ = (cljs.core._seq[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4464__auto__.call(null,o));
} else {
var m__4461__auto__ = (cljs.core._seq["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__4461__auto__.call(null,o));
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
});
/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((((!((o == null)))) && ((!((o.cljs$core$ISeqable$_seq$arity$1 == null)))))){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
return cljs$core$ISeqable$_seq$dyn_3386(o);
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 * @interface
 */
cljs.core.ISequential = function(){};


/**
 * Marker interface indicating a persistent list
 * @interface
 */
cljs.core.IList = function(){};


/**
 * Marker interface indicating a record object
 * @interface
 */
cljs.core.IRecord = function(){};


/**
 * Protocol for reversing a seq.
 * @interface
 */
cljs.core.IReversible = function(){};

var cljs$core$IReversible$_rseq$dyn_3387 = (function (coll){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._rseq[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4464__auto__.call(null,coll));
} else {
var m__4461__auto__ = (cljs.core._rseq["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4461__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
});
/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IReversible$_rseq$arity$1 == null)))))){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
return cljs$core$IReversible$_rseq$dyn_3387(coll);
}
});


/**
 * Protocol for a collection which can represent their items
 *   in a sorted manner. 
 * @interface
 */
cljs.core.ISorted = function(){};

var cljs$core$ISorted$_sorted_seq$dyn_3388 = (function (coll,ascending_QMARK_){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._sorted_seq[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__4464__auto__.call(null,coll,ascending_QMARK_));
} else {
var m__4461__auto__ = (cljs.core._sorted_seq["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__4461__auto__.call(null,coll,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
});
/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
return cljs$core$ISorted$_sorted_seq$dyn_3388(coll,ascending_QMARK_);
}
});

var cljs$core$ISorted$_sorted_seq_from$dyn_3389 = (function (coll,k,ascending_QMARK_){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._sorted_seq_from[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__4464__auto__.call(null,coll,k,ascending_QMARK_));
} else {
var m__4461__auto__ = (cljs.core._sorted_seq_from["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__4461__auto__.call(null,coll,k,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
});
/**
 * Returns a sorted seq from coll in either ascending or descending order.
 *   If ascending is true, the result should contain all items which are > or >=
 *   than k. If ascending is false, the result should contain all items which
 *   are < or <= than k, e.g.
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)))))){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
return cljs$core$ISorted$_sorted_seq_from$dyn_3389(coll,k,ascending_QMARK_);
}
});

var cljs$core$ISorted$_entry_key$dyn_3390 = (function (coll,entry){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._entry_key[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__4464__auto__.call(null,coll,entry));
} else {
var m__4461__auto__ = (cljs.core._entry_key["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__4461__auto__.call(null,coll,entry));
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
});
/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_entry_key$arity$2 == null)))))){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
return cljs$core$ISorted$_entry_key$dyn_3390(coll,entry);
}
});

var cljs$core$ISorted$_comparator$dyn_3391 = (function (coll){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._comparator[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4464__auto__.call(null,coll));
} else {
var m__4461__auto__ = (cljs.core._comparator["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4461__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
});
/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$ISorted$_comparator$arity$1 == null)))))){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
return cljs$core$ISorted$_comparator$dyn_3391(coll);
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 * @interface
 */
cljs.core.IWriter = function(){};

var cljs$core$IWriter$_write$dyn_3392 = (function (writer,s){
var x__4463__auto__ = (((writer == null))?null:writer);
var m__4464__auto__ = (cljs.core._write[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__4464__auto__.call(null,writer,s));
} else {
var m__4461__auto__ = (cljs.core._write["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__4461__auto__.call(null,writer,s));
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
});
/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_write$arity$2 == null)))))){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
return cljs$core$IWriter$_write$dyn_3392(writer,s);
}
});

var cljs$core$IWriter$_flush$dyn_3393 = (function (writer){
var x__4463__auto__ = (((writer == null))?null:writer);
var m__4464__auto__ = (cljs.core._flush[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__4464__auto__.call(null,writer));
} else {
var m__4461__auto__ = (cljs.core._flush["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__4461__auto__.call(null,writer));
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
});
/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((((!((writer == null)))) && ((!((writer.cljs$core$IWriter$_flush$arity$1 == null)))))){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
return cljs$core$IWriter$_flush$dyn_3393(writer);
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 * @interface
 */
cljs.core.IPrintWithWriter = function(){};

var cljs$core$IPrintWithWriter$_pr_writer$dyn_3394 = (function (o,writer,opts){
var x__4463__auto__ = (((o == null))?null:o);
var m__4464__auto__ = (cljs.core._pr_writer[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__4464__auto__.call(null,o,writer,opts));
} else {
var m__4461__auto__ = (cljs.core._pr_writer["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__4461__auto__.call(null,o,writer,opts));
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
});
cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((((!((o == null)))) && ((!((o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)))))){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
return cljs$core$IPrintWithWriter$_pr_writer$dyn_3394(o,writer,opts);
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 *   implemented by Delay and LazySeq.
 * @interface
 */
cljs.core.IPending = function(){};

var cljs$core$IPending$_realized_QMARK_$dyn_3395 = (function (x){
var x__4463__auto__ = (((x == null))?null:x);
var m__4464__auto__ = (cljs.core._realized_QMARK_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4464__auto__.call(null,x));
} else {
var m__4461__auto__ = (cljs.core._realized_QMARK_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4461__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("IPending.-realized?",x);
}
}
});
/**
 * Returns true if a value for x has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(x){
if((((!((x == null)))) && ((!((x.cljs$core$IPending$_realized_QMARK_$arity$1 == null)))))){
return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);
} else {
return cljs$core$IPending$_realized_QMARK_$dyn_3395(x);
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 * @interface
 */
cljs.core.IWatchable = function(){};

var cljs$core$IWatchable$_notify_watches$dyn_3396 = (function (this$,oldval,newval){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._notify_watches[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__4464__auto__.call(null,this$,oldval,newval));
} else {
var m__4461__auto__ = (cljs.core._notify_watches["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__4461__auto__.call(null,this$,oldval,newval));
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
});
/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
return cljs$core$IWatchable$_notify_watches$dyn_3396(this$,oldval,newval);
}
});

var cljs$core$IWatchable$_add_watch$dyn_3397 = (function (this$,key,f){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._add_watch[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__4464__auto__.call(null,this$,key,f));
} else {
var m__4461__auto__ = (cljs.core._add_watch["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__4461__auto__.call(null,this$,key,f));
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
});
/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 *   and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_add_watch$arity$3 == null)))))){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
return cljs$core$IWatchable$_add_watch$dyn_3397(this$,key,f);
}
});

var cljs$core$IWatchable$_remove_watch$dyn_3398 = (function (this$,key){
var x__4463__auto__ = (((this$ == null))?null:this$);
var m__4464__auto__ = (cljs.core._remove_watch[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__4464__auto__.call(null,this$,key));
} else {
var m__4461__auto__ = (cljs.core._remove_watch["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__4461__auto__.call(null,this$,key));
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
});
/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((((!((this$ == null)))) && ((!((this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)))))){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
return cljs$core$IWatchable$_remove_watch$dyn_3398(this$,key);
}
});


/**
 * Protocol for collections which can transformed to transients.
 * @interface
 */
cljs.core.IEditableCollection = function(){};

var cljs$core$IEditableCollection$_as_transient$dyn_3399 = (function (coll){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._as_transient[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4464__auto__.call(null,coll));
} else {
var m__4461__auto__ = (cljs.core._as_transient["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4461__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
});
/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)))))){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
return cljs$core$IEditableCollection$_as_transient$dyn_3399(coll);
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 * @interface
 */
cljs.core.ITransientCollection = function(){};

var cljs$core$ITransientCollection$_conj_BANG_$dyn_3400 = (function (tcoll,val){
var x__4463__auto__ = (((tcoll == null))?null:tcoll);
var m__4464__auto__ = (cljs.core._conj_BANG_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__4464__auto__.call(null,tcoll,val));
} else {
var m__4461__auto__ = (cljs.core._conj_BANG_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__4461__auto__.call(null,tcoll,val));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
});
/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
return cljs$core$ITransientCollection$_conj_BANG_$dyn_3400(tcoll,val);
}
});

var cljs$core$ITransientCollection$_persistent_BANG_$dyn_3401 = (function (tcoll){
var x__4463__auto__ = (((tcoll == null))?null:tcoll);
var m__4464__auto__ = (cljs.core._persistent_BANG_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4464__auto__.call(null,tcoll));
} else {
var m__4461__auto__ = (cljs.core._persistent_BANG_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4461__auto__.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
});
/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
return cljs$core$ITransientCollection$_persistent_BANG_$dyn_3401(tcoll);
}
});


/**
 * Protocol for adding associativity to transient collections.
 * @interface
 */
cljs.core.ITransientAssociative = function(){};

var cljs$core$ITransientAssociative$_assoc_BANG_$dyn_3402 = (function (tcoll,key,val){
var x__4463__auto__ = (((tcoll == null))?null:tcoll);
var m__4464__auto__ = (cljs.core._assoc_BANG_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__4464__auto__.call(null,tcoll,key,val));
} else {
var m__4461__auto__ = (cljs.core._assoc_BANG_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__4461__auto__.call(null,tcoll,key,val));
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
});
/**
 * Returns a new transient collection of tcoll with a mapping from key to
 *   val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
return cljs$core$ITransientAssociative$_assoc_BANG_$dyn_3402(tcoll,key,val);
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 * @interface
 */
cljs.core.ITransientMap = function(){};

var cljs$core$ITransientMap$_dissoc_BANG_$dyn_3403 = (function (tcoll,key){
var x__4463__auto__ = (((tcoll == null))?null:tcoll);
var m__4464__auto__ = (cljs.core._dissoc_BANG_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__4464__auto__.call(null,tcoll,key));
} else {
var m__4461__auto__ = (cljs.core._dissoc_BANG_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__4461__auto__.call(null,tcoll,key));
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
});
/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
return cljs$core$ITransientMap$_dissoc_BANG_$dyn_3403(tcoll,key);
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 * @interface
 */
cljs.core.ITransientVector = function(){};

var cljs$core$ITransientVector$_assoc_n_BANG_$dyn_3404 = (function (tcoll,n,val){
var x__4463__auto__ = (((tcoll == null))?null:tcoll);
var m__4464__auto__ = (cljs.core._assoc_n_BANG_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__4464__auto__.call(null,tcoll,n,val));
} else {
var m__4461__auto__ = (cljs.core._assoc_n_BANG_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__4461__auto__.call(null,tcoll,n,val));
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
});
/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)))))){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
return cljs$core$ITransientVector$_assoc_n_BANG_$dyn_3404(tcoll,n,val);
}
});

var cljs$core$ITransientVector$_pop_BANG_$dyn_3405 = (function (tcoll){
var x__4463__auto__ = (((tcoll == null))?null:tcoll);
var m__4464__auto__ = (cljs.core._pop_BANG_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4464__auto__.call(null,tcoll));
} else {
var m__4461__auto__ = (cljs.core._pop_BANG_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__4461__auto__.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
});
/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)))))){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
return cljs$core$ITransientVector$_pop_BANG_$dyn_3405(tcoll);
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 * @interface
 */
cljs.core.ITransientSet = function(){};

var cljs$core$ITransientSet$_disjoin_BANG_$dyn_3406 = (function (tcoll,v){
var x__4463__auto__ = (((tcoll == null))?null:tcoll);
var m__4464__auto__ = (cljs.core._disjoin_BANG_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__4464__auto__.call(null,tcoll,v));
} else {
var m__4461__auto__ = (cljs.core._disjoin_BANG_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__4461__auto__.call(null,tcoll,v));
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
});
/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((((!((tcoll == null)))) && ((!((tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)))))){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
return cljs$core$ITransientSet$_disjoin_BANG_$dyn_3406(tcoll,v);
}
});


/**
 * Protocol for values that can be compared.
 * @interface
 */
cljs.core.IComparable = function(){};

var cljs$core$IComparable$_compare$dyn_3407 = (function (x,y){
var x__4463__auto__ = (((x == null))?null:x);
var m__4464__auto__ = (cljs.core._compare[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__4464__auto__.call(null,x,y));
} else {
var m__4461__auto__ = (cljs.core._compare["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__4461__auto__.call(null,x,y));
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
});
/**
 * Returns a negative number, zero, or a positive number when x is logically
 *   'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((((!((x == null)))) && ((!((x.cljs$core$IComparable$_compare$arity$2 == null)))))){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
return cljs$core$IComparable$_compare$dyn_3407(x,y);
}
});


/**
 * Protocol for accessing the items of a chunk.
 * @interface
 */
cljs.core.IChunk = function(){};

var cljs$core$IChunk$_drop_first$dyn_3408 = (function (coll){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._drop_first[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4464__auto__.call(null,coll));
} else {
var m__4461__auto__ = (cljs.core._drop_first["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4461__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
});
/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunk$_drop_first$arity$1 == null)))))){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
return cljs$core$IChunk$_drop_first$dyn_3408(coll);
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 * @interface
 */
cljs.core.IChunkedSeq = function(){};

var cljs$core$IChunkedSeq$_chunked_first$dyn_3409 = (function (coll){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._chunked_first[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4464__auto__.call(null,coll));
} else {
var m__4461__auto__ = (cljs.core._chunked_first["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4461__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
});
/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
return cljs$core$IChunkedSeq$_chunked_first$dyn_3409(coll);
}
});

var cljs$core$IChunkedSeq$_chunked_rest$dyn_3410 = (function (coll){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._chunked_rest[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4464__auto__.call(null,coll));
} else {
var m__4461__auto__ = (cljs.core._chunked_rest["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4461__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
});
/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)))))){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
return cljs$core$IChunkedSeq$_chunked_rest$dyn_3410(coll);
}
});


/**
 * Protocol for accessing the chunks of a collection.
 * @interface
 */
cljs.core.IChunkedNext = function(){};

var cljs$core$IChunkedNext$_chunked_next$dyn_3411 = (function (coll){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._chunked_next[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4464__auto__.call(null,coll));
} else {
var m__4461__auto__ = (cljs.core._chunked_next["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4461__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
});
/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)))))){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
return cljs$core$IChunkedNext$_chunked_next$dyn_3411(coll);
}
});


/**
 * Protocol for adding a name.
 * @interface
 */
cljs.core.INamed = function(){};

var cljs$core$INamed$_name$dyn_3412 = (function (x){
var x__4463__auto__ = (((x == null))?null:x);
var m__4464__auto__ = (cljs.core._name[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4464__auto__.call(null,x));
} else {
var m__4461__auto__ = (cljs.core._name["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4461__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
});
/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_name$arity$1 == null)))))){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
return cljs$core$INamed$_name$dyn_3412(x);
}
});

var cljs$core$INamed$_namespace$dyn_3413 = (function (x){
var x__4463__auto__ = (((x == null))?null:x);
var m__4464__auto__ = (cljs.core._namespace[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4464__auto__.call(null,x));
} else {
var m__4461__auto__ = (cljs.core._namespace["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__4461__auto__.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
});
/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((((!((x == null)))) && ((!((x.cljs$core$INamed$_namespace$arity$1 == null)))))){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
return cljs$core$INamed$_namespace$dyn_3413(x);
}
});


/**
 * Marker protocol indicating an atom.
 * @interface
 */
cljs.core.IAtom = function(){};


/**
 * Protocol for adding resetting functionality.
 * @interface
 */
cljs.core.IReset = function(){};

var cljs$core$IReset$_reset_BANG_$dyn_3414 = (function (o,new_value){
var x__4463__auto__ = (((o == null))?null:o);
var m__4464__auto__ = (cljs.core._reset_BANG_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__4464__auto__.call(null,o,new_value));
} else {
var m__4461__auto__ = (cljs.core._reset_BANG_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__4461__auto__.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
});
/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IReset$_reset_BANG_$arity$2 == null)))))){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
return cljs$core$IReset$_reset_BANG_$dyn_3414(o,new_value);
}
});


/**
 * Protocol for adding swapping functionality.
 * @interface
 */
cljs.core.ISwap = function(){};

var cljs$core$ISwap$_swap_BANG_$dyn_3417 = (function() {
var G__3418 = null;
var G__3418__2 = (function (o,f){
var x__4463__auto__ = (((o == null))?null:o);
var m__4464__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__4464__auto__.call(null,o,f));
} else {
var m__4461__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__4461__auto__.call(null,o,f));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var G__3418__3 = (function (o,f,a){
var x__4463__auto__ = (((o == null))?null:o);
var m__4464__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__4464__auto__.call(null,o,f,a));
} else {
var m__4461__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__4461__auto__.call(null,o,f,a));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var G__3418__4 = (function (o,f,a,b){
var x__4463__auto__ = (((o == null))?null:o);
var m__4464__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__4464__auto__.call(null,o,f,a,b));
} else {
var m__4461__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__4461__auto__.call(null,o,f,a,b));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
var G__3418__5 = (function (o,f,a,b,xs){
var x__4463__auto__ = (((o == null))?null:o);
var m__4464__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__4464__auto__.call(null,o,f,a,b,xs));
} else {
var m__4461__auto__ = (cljs.core._swap_BANG_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__4461__auto__.call(null,o,f,a,b,xs));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
});
G__3418 = function(o,f,a,b,xs){
switch(arguments.length){
case 2:
return G__3418__2.call(this,o,f);
case 3:
return G__3418__3.call(this,o,f,a);
case 4:
return G__3418__4.call(this,o,f,a,b);
case 5:
return G__3418__5.call(this,o,f,a,b,xs);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3418.cljs$core$IFn$_invoke$arity$2 = G__3418__2;
G__3418.cljs$core$IFn$_invoke$arity$3 = G__3418__3;
G__3418.cljs$core$IFn$_invoke$arity$4 = G__3418__4;
G__3418.cljs$core$IFn$_invoke$arity$5 = G__3418__5;
return G__3418;
})()
;
/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function cljs$core$_swap_BANG_(var_args){
var G__3416 = arguments.length;
switch (G__3416) {
case 2:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (o,f){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_3417.cljs$core$IFn$_invoke$arity$2(o,f);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (o,f,a){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_3417.cljs$core$IFn$_invoke$arity$3(o,f,a);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (o,f,a,b){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_3417.cljs$core$IFn$_invoke$arity$4(o,f,a,b);
}
}));

(cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (o,f,a,b,xs){
if((((!((o == null)))) && ((!((o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)))))){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
return cljs$core$ISwap$_swap_BANG_$dyn_3417.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs);
}
}));

(cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5);



/**
 * Protocol for adding volatile functionality.
 * @interface
 */
cljs.core.IVolatile = function(){};

var cljs$core$IVolatile$_vreset_BANG_$dyn_3420 = (function (o,new_value){
var x__4463__auto__ = (((o == null))?null:o);
var m__4464__auto__ = (cljs.core._vreset_BANG_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__4464__auto__.call(null,o,new_value));
} else {
var m__4461__auto__ = (cljs.core._vreset_BANG_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__4461__auto__.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
});
/**
 * Sets the value of volatile o to new-value without regard for the
 *   current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((((!((o == null)))) && ((!((o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)))))){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
return cljs$core$IVolatile$_vreset_BANG_$dyn_3420(o,new_value);
}
});


/**
 * Protocol for iterating over a collection.
 * @interface
 */
cljs.core.IIterable = function(){};

var cljs$core$IIterable$_iterator$dyn_3421 = (function (coll){
var x__4463__auto__ = (((coll == null))?null:coll);
var m__4464__auto__ = (cljs.core._iterator[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4464__auto__.call(null,coll));
} else {
var m__4461__auto__ = (cljs.core._iterator["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__4461__auto__.call(null,coll));
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
});
/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((((!((coll == null)))) && ((!((coll.cljs$core$IIterable$_iterator$arity$1 == null)))))){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
return cljs$core$IIterable$_iterator$dyn_3421(coll);
}
});


/**
* @constructor
 * @implements {cljs.core.IWriter}
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
}));

(cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
}));

(cljs.core.StringBufferWriter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sb], null);
}));

(cljs.core.StringBufferWriter.cljs$lang$type = true);

(cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter");

(cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/StringBufferWriter");
}));

/**
 * Positional factory function for cljs.core/StringBufferWriter.
 */
cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb);
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((((typeof Math !== 'undefined') && (typeof Math.imul !== 'undefined')) && ((!((Math.imul((4294967295),(5)) === (0))))))){
cljs.core.imul = (function cljs$core$imul(a,b){
return Math.imul(a,b);
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
return (h1__$6 ^ (h1__$6 >>> (16)));
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__3422 = (i + (2));
var G__3423 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__3422;
h1 = G__3423;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = ({});
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if((!((s == null)))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__3426 = (i + (1));
var G__3427 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__3426;
hash = G__3427;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
goog.object.set(cljs.core.string_hash_cache,k,h);

(cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1)));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
(cljs.core.string_hash_cache = ({}));

(cljs.core.string_hash_cache_count = (0));
} else {
}

if((k == null)){
return (0);
} else {
var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (4194304))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IHash$))))?true:false):false)){
return (o.cljs$core$IHash$_hash$arity$1(null) ^ (0));
} else {
if(typeof o === 'number'){
if(cljs.core.truth_(isFinite(o))){
return (Math.floor(o) % (2147483647));
} else {
var G__3431 = o;
switch (G__3431) {
case Infinity:
return (2146435072);

break;
case -Infinity:
return (-1048576);

break;
default:
return (2146959360);

}
}
} else {
if(o === true){
return (1231);
} else {
if(o === false){
return (1237);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return (o.valueOf() ^ (0));
} else {
if((o == null)){
return (0);
} else {
return (cljs.core._hash(o) ^ (0));

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 *   c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(c,x){
return (x instanceof c);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_(((cljs.core.not(a.ns))?b.ns:false))){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__3433 = a.ns;
var G__3434 = b.ns;
return goog.array.defaultCompare(G__3433,G__3434);
})();
if(((0) === nsc)){
var G__3435 = a.name;
var G__3436 = b.name;
return goog.array.defaultCompare(G__3435,G__3436);
} else {
return nsc;
}
}
} else {
var G__3437 = a.name;
var G__3438 = b.name;
return goog.array.defaultCompare(G__3437,G__3438);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
(cljs.core.Symbol.prototype.toString = (function (){
var self__ = this;
var _ = this;
return self__.str;
}));

(cljs.core.Symbol.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
}));

(cljs.core.Symbol.prototype.call = (function() {
var G__3440 = null;
var G__3440__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym);
});
var G__3440__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});
G__3440 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__3440__2.call(this,self__,coll);
case 3:
return G__3440__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__3440.cljs$core$IFn$_invoke$arity$2 = G__3440__2;
G__3440.cljs$core$IFn$_invoke$arity$3 = G__3440__3;
return G__3440;
})()
);

(cljs.core.Symbol.prototype.apply = (function (self__,args3439){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args3439)));
}));

(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var sym = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym);
}));

(cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var sym = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
}));

(cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
}));

(cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
}));

(cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function (sym){
var self__ = this;
var sym__$1 = this;
var h__4273__auto__ = self__._hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_symbol(sym__$1);
(self__._hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
}));

(cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
}));

(cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
}));

(cljs.core.Symbol.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name,cljs.core.cst$sym$str,cljs.core.with_meta(cljs.core.cst$sym$_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$_meta], null);
}));

(cljs.core.Symbol.cljs$lang$type = true);

(cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol");

(cljs.core.Symbol.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/Symbol");
}));

/**
 * Positional factory function for cljs.core/Symbol.
 */
cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

/**
 * Returns true if v is of type cljs.core.Var
 */
cljs.core.var_QMARK_ = (function cljs$core$var_QMARK_(v){
return (v instanceof cljs.core.Var);
});
/**
 * Returns a Symbol with the given namespace and name. Arity-1 works
 *   on strings, keywords, and vars.
 */
cljs.core.symbol = (function cljs$core$symbol(var_args){
var G__3442 = arguments.length;
switch (G__3442) {
case 1:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = (function (name){
while(true){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
if(typeof name === 'string'){
var idx = name.indexOf("/");
if((idx < (1))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring((0),idx),name.substring((idx + (1)),name.length));
}
} else {
if(cljs.core.var_QMARK_(name)){
return name.sym;
} else {
if((name instanceof cljs.core.Keyword)){
var G__3444 = name.fqn;
name = G__3444;
continue;
} else {
throw (new Error("no conversion to symbol"));

}
}
}
}
break;
}
}));

(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var sym_str = (((!((ns == null))))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
}));

(cljs.core.symbol.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IDeref}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 6717441;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Var.prototype.isMacro = (function (){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;
}));

(cljs.core.Var.prototype.toString = (function (){
var self__ = this;
var _ = this;
return ["#'",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.sym)].join('');
}));

(cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
}));

(cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
}));

(cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Var(self__.val,self__.sym,new_meta));
}));

(cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
if((other instanceof cljs.core.Var)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this$__$1.sym,other.sym);
} else {
return false;
}
}));

(cljs.core.Var.prototype.cljs$core$IHash$_hash$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.hash_symbol(self__.sym);
}));

(cljs.core.Var.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Var.prototype.call = (function() {
var G__3488 = null;
var G__3488__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3446 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3446.cljs$core$IFn$_invoke$arity$0 ? fexpr__3446.cljs$core$IFn$_invoke$arity$0() : fexpr__3446.call(null));
});
var G__3488__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3447 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3447.cljs$core$IFn$_invoke$arity$1 ? fexpr__3447.cljs$core$IFn$_invoke$arity$1(a) : fexpr__3447.call(null,a));
});
var G__3488__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3448 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3448.cljs$core$IFn$_invoke$arity$2 ? fexpr__3448.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__3448.call(null,a,b));
});
var G__3488__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3449 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3449.cljs$core$IFn$_invoke$arity$3 ? fexpr__3449.cljs$core$IFn$_invoke$arity$3(a,b,c) : fexpr__3449.call(null,a,b,c));
});
var G__3488__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3450 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3450.cljs$core$IFn$_invoke$arity$4 ? fexpr__3450.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : fexpr__3450.call(null,a,b,c,d));
});
var G__3488__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3451 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3451.cljs$core$IFn$_invoke$arity$5 ? fexpr__3451.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : fexpr__3451.call(null,a,b,c,d,e));
});
var G__3488__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3452 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3452.cljs$core$IFn$_invoke$arity$6 ? fexpr__3452.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : fexpr__3452.call(null,a,b,c,d,e,f));
});
var G__3488__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3453 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3453.cljs$core$IFn$_invoke$arity$7 ? fexpr__3453.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : fexpr__3453.call(null,a,b,c,d,e,f,g));
});
var G__3488__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3454 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3454.cljs$core$IFn$_invoke$arity$8 ? fexpr__3454.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : fexpr__3454.call(null,a,b,c,d,e,f,g,h));
});
var G__3488__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3455 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3455.cljs$core$IFn$_invoke$arity$9 ? fexpr__3455.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : fexpr__3455.call(null,a,b,c,d,e,f,g,h,i));
});
var G__3488__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3456 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3456.cljs$core$IFn$_invoke$arity$10 ? fexpr__3456.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : fexpr__3456.call(null,a,b,c,d,e,f,g,h,i,j));
});
var G__3488__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3457 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3457.cljs$core$IFn$_invoke$arity$11 ? fexpr__3457.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : fexpr__3457.call(null,a,b,c,d,e,f,g,h,i,j,k));
});
var G__3488__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3458 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3458.cljs$core$IFn$_invoke$arity$12 ? fexpr__3458.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : fexpr__3458.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});
var G__3488__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3459 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3459.cljs$core$IFn$_invoke$arity$13 ? fexpr__3459.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : fexpr__3459.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});
var G__3488__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3460 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3460.cljs$core$IFn$_invoke$arity$14 ? fexpr__3460.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : fexpr__3460.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});
var G__3488__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3461 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3461.cljs$core$IFn$_invoke$arity$15 ? fexpr__3461.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : fexpr__3461.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});
var G__3488__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3462 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3462.cljs$core$IFn$_invoke$arity$16 ? fexpr__3462.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : fexpr__3462.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});
var G__3488__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3463 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3463.cljs$core$IFn$_invoke$arity$17 ? fexpr__3463.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : fexpr__3463.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});
var G__3488__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3464 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3464.cljs$core$IFn$_invoke$arity$18 ? fexpr__3464.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : fexpr__3464.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});
var G__3488__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3465 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3465.cljs$core$IFn$_invoke$arity$19 ? fexpr__3465.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : fexpr__3465.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});
var G__3488__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var fexpr__3466 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3466.cljs$core$IFn$_invoke$arity$20 ? fexpr__3466.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : fexpr__3466.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});
var G__3488__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)),a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
});
G__3488 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__3488__1.call(this,self__);
case 2:
return G__3488__2.call(this,self__,a);
case 3:
return G__3488__3.call(this,self__,a,b);
case 4:
return G__3488__4.call(this,self__,a,b,c);
case 5:
return G__3488__5.call(this,self__,a,b,c,d);
case 6:
return G__3488__6.call(this,self__,a,b,c,d,e);
case 7:
return G__3488__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__3488__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__3488__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__3488__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__3488__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__3488__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__3488__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__3488__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__3488__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__3488__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__3488__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__3488__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__3488__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__3488__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__3488__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__3488__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__3488.cljs$core$IFn$_invoke$arity$1 = G__3488__1;
G__3488.cljs$core$IFn$_invoke$arity$2 = G__3488__2;
G__3488.cljs$core$IFn$_invoke$arity$3 = G__3488__3;
G__3488.cljs$core$IFn$_invoke$arity$4 = G__3488__4;
G__3488.cljs$core$IFn$_invoke$arity$5 = G__3488__5;
G__3488.cljs$core$IFn$_invoke$arity$6 = G__3488__6;
G__3488.cljs$core$IFn$_invoke$arity$7 = G__3488__7;
G__3488.cljs$core$IFn$_invoke$arity$8 = G__3488__8;
G__3488.cljs$core$IFn$_invoke$arity$9 = G__3488__9;
G__3488.cljs$core$IFn$_invoke$arity$10 = G__3488__10;
G__3488.cljs$core$IFn$_invoke$arity$11 = G__3488__11;
G__3488.cljs$core$IFn$_invoke$arity$12 = G__3488__12;
G__3488.cljs$core$IFn$_invoke$arity$13 = G__3488__13;
G__3488.cljs$core$IFn$_invoke$arity$14 = G__3488__14;
G__3488.cljs$core$IFn$_invoke$arity$15 = G__3488__15;
G__3488.cljs$core$IFn$_invoke$arity$16 = G__3488__16;
G__3488.cljs$core$IFn$_invoke$arity$17 = G__3488__17;
G__3488.cljs$core$IFn$_invoke$arity$18 = G__3488__18;
G__3488.cljs$core$IFn$_invoke$arity$19 = G__3488__19;
G__3488.cljs$core$IFn$_invoke$arity$20 = G__3488__20;
G__3488.cljs$core$IFn$_invoke$arity$21 = G__3488__21;
G__3488.cljs$core$IFn$_invoke$arity$22 = G__3488__22;
return G__3488;
})()
);

(cljs.core.Var.prototype.apply = (function (self__,args3445){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args3445)));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
var fexpr__3467 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3467.cljs$core$IFn$_invoke$arity$0 ? fexpr__3467.cljs$core$IFn$_invoke$arity$0() : fexpr__3467.call(null));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
var fexpr__3468 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3468.cljs$core$IFn$_invoke$arity$1 ? fexpr__3468.cljs$core$IFn$_invoke$arity$1(a) : fexpr__3468.call(null,a));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
var fexpr__3469 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3469.cljs$core$IFn$_invoke$arity$2 ? fexpr__3469.cljs$core$IFn$_invoke$arity$2(a,b) : fexpr__3469.call(null,a,b));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
var fexpr__3470 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3470.cljs$core$IFn$_invoke$arity$3 ? fexpr__3470.cljs$core$IFn$_invoke$arity$3(a,b,c) : fexpr__3470.call(null,a,b,c));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
var fexpr__3471 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3471.cljs$core$IFn$_invoke$arity$4 ? fexpr__3471.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : fexpr__3471.call(null,a,b,c,d));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
var fexpr__3472 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3472.cljs$core$IFn$_invoke$arity$5 ? fexpr__3472.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : fexpr__3472.call(null,a,b,c,d,e));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
var fexpr__3473 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3473.cljs$core$IFn$_invoke$arity$6 ? fexpr__3473.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : fexpr__3473.call(null,a,b,c,d,e,f));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
var fexpr__3474 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3474.cljs$core$IFn$_invoke$arity$7 ? fexpr__3474.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : fexpr__3474.call(null,a,b,c,d,e,f,g));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
var fexpr__3475 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3475.cljs$core$IFn$_invoke$arity$8 ? fexpr__3475.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : fexpr__3475.call(null,a,b,c,d,e,f,g,h));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
var fexpr__3476 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3476.cljs$core$IFn$_invoke$arity$9 ? fexpr__3476.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : fexpr__3476.call(null,a,b,c,d,e,f,g,h,i));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
var fexpr__3477 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3477.cljs$core$IFn$_invoke$arity$10 ? fexpr__3477.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : fexpr__3477.call(null,a,b,c,d,e,f,g,h,i,j));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
var fexpr__3478 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3478.cljs$core$IFn$_invoke$arity$11 ? fexpr__3478.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : fexpr__3478.call(null,a,b,c,d,e,f,g,h,i,j,k));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
var fexpr__3479 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3479.cljs$core$IFn$_invoke$arity$12 ? fexpr__3479.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : fexpr__3479.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
var fexpr__3480 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3480.cljs$core$IFn$_invoke$arity$13 ? fexpr__3480.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : fexpr__3480.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
var fexpr__3481 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3481.cljs$core$IFn$_invoke$arity$14 ? fexpr__3481.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : fexpr__3481.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
var fexpr__3482 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3482.cljs$core$IFn$_invoke$arity$15 ? fexpr__3482.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : fexpr__3482.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
var fexpr__3483 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3483.cljs$core$IFn$_invoke$arity$16 ? fexpr__3483.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : fexpr__3483.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
var fexpr__3484 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3484.cljs$core$IFn$_invoke$arity$17 ? fexpr__3484.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : fexpr__3484.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
var fexpr__3485 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3485.cljs$core$IFn$_invoke$arity$18 ? fexpr__3485.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : fexpr__3485.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
var fexpr__3486 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3486.cljs$core$IFn$_invoke$arity$19 ? fexpr__3486.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : fexpr__3486.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
var fexpr__3487 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
return (fexpr__3487.cljs$core$IFn$_invoke$arity$20 ? fexpr__3487.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : fexpr__3487.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
}));

(cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)),a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
}));

(cljs.core.Var.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$val,cljs.core.cst$sym$sym,cljs.core.cst$sym$_meta], null);
}));

(cljs.core.Var.cljs$lang$type = true);

(cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var");

(cljs.core.Var.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/Var");
}));

/**
 * Positional factory function for cljs.core/Var.
 */
cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});



/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIterable$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
}
});
/**
 * Return true if x has a JavaScript iterator property
 */
cljs.core.js_iterable_QMARK_ = (function cljs$core$js_iterable_QMARK_(x){
return (((!((x == null)))) && ((!((x[cljs.core.ITER_SYMBOL] == null)))));
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
if((!((value == null)))){
if((((value.cljs$lang$protocol_mask$partition1$ & (8192))) || ((cljs.core.PROTOCOL_SENTINEL === value.cljs$core$ICloneable$)))){
return true;
} else {
if((!value.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
}
});
/**
 * Returns a seq on the collection. If the collection is
 *   empty, returns nil.  (seq nil) returns nil. seq also works on
 *   Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0),null));
}
} else {
if(cljs.core.js_iterable_QMARK_(coll)){
return cljs.core.es6_iterator_seq(goog.object.get(coll,cljs.core.ITER_SYMBOL).call(coll));
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)," is not ISeqable"].join('')));

}
}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 *   argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 *   argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return s.cljs$core$ISeq$_rest$arity$1(null);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 *   argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 *   numbers and collections in a type-independent manner.  Clojure's immutable data
 *   structures define -equiv (and thus =) as a value, not an identity,
 *   comparison.
 */
cljs.core._EQ_ = (function cljs$core$_EQ_(var_args){
var G__3499 = arguments.length;
switch (G__3499) {
case 1:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3501 = arguments.length;
var i__4772__auto___3502 = (0);
while(true){
if((i__4772__auto___3502 < len__4771__auto___3501)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3502]));

var G__3503 = (i__4772__auto___3502 + (1));
i__4772__auto___3502 = G__3503;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
if((x == null)){
return (y == null);
} else {
return (((x === y)) || (cljs.core._equiv(x,y)));
}
}));

(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__3504 = y;
var G__3505 = cljs.core.first(more);
var G__3506 = cljs.core.next(more);
x = G__3504;
y = G__3505;
more = G__3506;
continue;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._EQ_.cljs$lang$applyTo = (function (seq3496){
var G__3497 = cljs.core.first(seq3496);
var seq3496__$1 = cljs.core.next(seq3496);
var G__3498 = cljs.core.first(seq3496__$1);
var seq3496__$2 = cljs.core.next(seq3496__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3497,G__3498,seq3496__$2);
}));

(cljs.core._EQ_.cljs$lang$maxFixedArity = (2));


/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
});
(cljs.core.ES6Iterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first(self__.s);
(self__.s = cljs.core.next(self__.s));

return ({"value": x, "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6Iterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.ES6Iterator.cljs$lang$type = true);

(cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator");

(cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/ES6Iterator");
}));

/**
 * Positional factory function for cljs.core/ES6Iterator.
 */
cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * EXPERIMENTAL: Return a ES2015 compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.value;
}));

(cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
(self__._rest = cljs.core.es6_iterator_seq(self__.iter));
} else {
}

return self__._rest;
}));

(cljs.core.ES6IteratorSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value,cljs.core.cst$sym$iter,cljs.core.with_meta(cljs.core.cst$sym$_rest,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.ES6IteratorSeq.cljs$lang$type = true);

(cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq");

(cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/ES6IteratorSeq");
}));

/**
 * Positional factory function for cljs.core/ES6IteratorSeq.
 */
cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * EXPERIMENTAL: Given an ES2015 compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return null;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if((!((coll__$1 == null)))){
var G__3507 = (n + (1));
var G__3508 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__3509 = cljs.core.next(coll__$1);
n = G__3507;
hash_code = G__3508;
coll__$1 = G__3509;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 *   (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if((!((coll__$1 == null)))){
var G__3510 = (n + (1));
var G__3511 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__3512 = cljs.core.next(coll__$1);
n = G__3510;
hash_code = G__3511;
coll__$1 = G__3512;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


goog.object.set(cljs.core.ICounted,"null",true);

goog.object.set(cljs.core._count,"null",(function (_){
return (0);
}));
(Date.prototype.cljs$core$IEquiv$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var o__$1 = this;
return (((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf())));
}));

(Date.prototype.cljs$core$IComparable$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof Date)){
var G__3513 = this$__$1.valueOf();
var G__3514 = other.valueOf();
return goog.array.defaultCompare(G__3513,G__3514);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(this$__$1)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(other)].join('')));
}
}));

/**
 * @interface
 */
cljs.core.Inst = function(){};

var cljs$core$Inst$inst_ms_STAR_$dyn_3515 = (function (inst){
var x__4463__auto__ = (((inst == null))?null:inst);
var m__4464__auto__ = (cljs.core.inst_ms_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__4464__auto__.call(null,inst));
} else {
var m__4461__auto__ = (cljs.core.inst_ms_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(inst) : m__4461__auto__.call(null,inst));
} else {
throw cljs.core.missing_protocol("Inst.inst-ms*",inst);
}
}
});
cljs.core.inst_ms_STAR_ = (function cljs$core$inst_ms_STAR_(inst){
if((((!((inst == null)))) && ((!((inst.cljs$core$Inst$inst_ms_STAR_$arity$1 == null)))))){
return inst.cljs$core$Inst$inst_ms_STAR_$arity$1(inst);
} else {
return cljs$core$Inst$inst_ms_STAR_$dyn_3515(inst);
}
});

(Date.prototype.cljs$core$Inst$ = cljs.core.PROTOCOL_SENTINEL);

(Date.prototype.cljs$core$Inst$inst_ms_STAR_$arity$1 = (function (inst){
var inst__$1 = this;
return inst__$1.getTime();
}));
/**
 * Return the number of milliseconds since January 1, 1970, 00:00:00 GMT
 */
cljs.core.inst_ms = (function cljs$core$inst_ms(inst){
return cljs.core.inst_ms_STAR_(inst);
});
/**
 * Return true if x satisfies Inst
 */
cljs.core.inst_QMARK_ = (function cljs$core$inst_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$Inst$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Inst,x);
}
});
goog.object.set(cljs.core.IEquiv,"number",true);

goog.object.set(cljs.core._equiv,"number",(function (x,o){
return (x === o);
}));
goog.object.set(cljs.core.Fn,"function",true);

goog.object.set(cljs.core.IMeta,"function",true);

goog.object.set(cljs.core._meta,"function",(function (_){
return null;
}));
goog.object.set(cljs.core.IHash,"_",true);

goog.object.set(cljs.core._hash,"_",(function (o){
return goog.getUid(o);
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
 * @implements {cljs.core.IDeref}
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return self__.val;
}));

(cljs.core.Reduced.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$val], null);
}));

(cljs.core.Reduced.cljs$lang$type = true);

(cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced");

(cljs.core.Reduced.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/Reduced");
}));

/**
 * Positional factory function for cljs.core/Reduced.
 */
cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
return cljs.core.deref(x);
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function cljs$core$ci_reduce(var_args){
var G__3518 = arguments.length;
switch (G__3518) {
case 2:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = (function (cicoll,f){
var cnt = cicoll.cljs$core$ICounted$_count$arity$1(null);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cicoll.cljs$core$IIndexed$_nth$arity$2(null,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__3519 = val;
var G__3520 = cicoll.cljs$core$IIndexed$_nth$arity$2(null,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__3519,G__3520) : f.call(null,G__3519,G__3520));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__3524 = nval;
var G__3525 = (n + (1));
val = G__3524;
n = G__3525;
continue;
}
} else {
return val;
}
break;
}
}
}));

(cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = (function (cicoll,f,val){
var cnt = cicoll.cljs$core$ICounted$_count$arity$1(null);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__3521 = val__$1;
var G__3522 = cicoll.cljs$core$IIndexed$_nth$arity$2(null,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__3521,G__3522) : f.call(null,G__3521,G__3522));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__3526 = nval;
var G__3527 = (n + (1));
val__$1 = G__3526;
n = G__3527;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.ci_reduce.cljs$lang$maxFixedArity = 3);

cljs.core.array_reduce = (function cljs$core$array_reduce(var_args){
var G__3529 = arguments.length;
switch (G__3529) {
case 2:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = (function (arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__3530 = val;
var G__3531 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__3530,G__3531) : f.call(null,G__3530,G__3531));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__3537 = nval;
var G__3538 = (n + (1));
val = G__3537;
n = G__3538;
continue;
}
} else {
return val;
}
break;
}
}
}));

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = (function (arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__3532 = val__$1;
var G__3533 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__3532,G__3533) : f.call(null,G__3532,G__3533));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__3539 = nval;
var G__3540 = (n + (1));
val__$1 = G__3539;
n = G__3540;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = (function (arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__3534 = val__$1;
var G__3535 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__3534,G__3535) : f.call(null,G__3534,G__3535));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__3541 = nval;
var G__3542 = (n + (1));
val__$1 = G__3541;
n = G__3542;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.array_reduce.cljs$lang$maxFixedArity = 4);







/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICounted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IIndexed$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
}
});
cljs.core._indexOf = (function cljs$core$_indexOf(var_args){
var G__3546 = arguments.length;
switch (G__3546) {
case 2:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
}));

(cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3 = (function (coll,x,start){
var len = cljs.core.count(coll);
if((start >= len)){
return (-1);
} else {
var idx = (((start > (0)))?start:(((start < (0)))?(function (){var x__4249__auto__ = (0);
var y__4250__auto__ = (start + len);
return ((x__4249__auto__ > y__4250__auto__) ? x__4249__auto__ : y__4250__auto__);
})():start
));
while(true){
if((idx < len)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx),x)){
return idx;
} else {
var G__3548 = (idx + (1));
idx = G__3548;
continue;
}
} else {
return (-1);
}
break;
}
}
}));

(cljs.core._indexOf.cljs$lang$maxFixedArity = 3);

cljs.core._lastIndexOf = (function cljs$core$_lastIndexOf(var_args){
var G__3550 = arguments.length;
switch (G__3550) {
case 2:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
}));

(cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3 = (function (coll,x,start){
var len = cljs.core.count(coll);
if((len === (0))){
return (-1);
} else {
var idx = (((start > (0)))?(function (){var x__4252__auto__ = (len - (1));
var y__4253__auto__ = start;
return ((x__4252__auto__ < y__4253__auto__) ? x__4252__auto__ : y__4253__auto__);
})():(((start < (0)))?(len + start):start
));
while(true){
if((idx >= (0))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,idx),x)){
return idx;
} else {
var G__3552 = (idx - (1));
idx = G__3552;
continue;
}
} else {
return (-1);
}
break;
}
}
}));

(cljs.core._lastIndexOf.cljs$lang$maxFixedArity = 3);


/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
});
(cljs.core.IndexedSeqIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
}));

(cljs.core.IndexedSeqIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.IndexedSeqIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.IndexedSeqIterator.cljs$lang$type = true);

(cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator");

(cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/IndexedSeqIterator");
}));

/**
 * Positional factory function for cljs.core/IndexedSeqIterator.
 */
cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.IndexedSeq = (function (arr,i,meta){
this.arr = arr;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 166592766;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(cljs.core.IndexedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.IndexedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.IndexedSeq.prototype.indexOf = (function() {
var G__3553 = null;
var G__3553__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__3553__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__3553 = function(x,start){
switch(arguments.length){
case 1:
return G__3553__1.call(this,x);
case 2:
return G__3553__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3553.cljs$core$IFn$_invoke$arity$1 = G__3553__1;
G__3553.cljs$core$IFn$_invoke$arity$2 = G__3553__2;
return G__3553;
})()
);

(cljs.core.IndexedSeq.prototype.lastIndexOf = (function() {
var G__3554 = null;
var G__3554__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__3554__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__3554 = function(x,start){
switch(arguments.length){
case 1:
return G__3554__1.call(this,x);
case 2:
return G__3554__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3554.cljs$core$IFn$_invoke$arity$1 = G__3554__1;
G__3554.cljs$core$IFn$_invoke$arity$2 = G__3554__2;
return G__3554;
})()
);

(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
throw (new Error("Index out of bounds"));
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if(((((0) <= i__$1)) && ((i__$1 < self__.arr.length)))){
return (self__.arr[i__$1]);
} else {
return not_found;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i,self__.meta));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var x__4249__auto__ = (0);
var y__4250__auto__ = (self__.arr.length - self__.i);
return ((x__4249__auto__ > y__4250__auto__) ? x__4249__auto__ : y__4250__auto__);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var c = coll__$1.cljs$core$ICounted$_count$arity$1(null);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.i < self__.arr.length)){
return this$__$1;
} else {
return null;
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.IndexedSeq(self__.arr,self__.i,new_meta));
}
}));

(cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.IndexedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$meta], null);
}));

(cljs.core.IndexedSeq.cljs$lang$type = true);

(cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq");

(cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/IndexedSeq");
}));

/**
 * Positional factory function for cljs.core/IndexedSeq.
 */
cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i,meta){
return (new cljs.core.IndexedSeq(arr,i,meta));
});

goog.object.set(cljs.core.IndexedSeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function cljs$core$prim_seq(var_args){
var G__3556 = arguments.length;
switch (G__3556) {
case 1:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = (function (prim){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
}));

(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = (function (prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i,null));
} else {
return null;
}
}));

(cljs.core.prim_seq.cljs$lang$maxFixedArity = 2);

/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function cljs$core$array_seq(var_args){
var G__3559 = arguments.length;
switch (G__3559) {
case 1:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = (function (array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
}));

(cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
}));

(cljs.core.array_seq.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.RSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.RSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.RSeq.prototype.indexOf = (function() {
var G__3561 = null;
var G__3561__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__3561__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__3561 = function(x,start){
switch(arguments.length){
case 1:
return G__3561__1.call(this,x);
case 2:
return G__3561__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3561.cljs$core$IFn$_invoke$arity$1 = G__3561__1;
G__3561.cljs$core$IFn$_invoke$arity$2 = G__3561__2;
return G__3561;
})()
);

(cljs.core.RSeq.prototype.lastIndexOf = (function() {
var G__3562 = null;
var G__3562__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__3562__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__3562 = function(x,start){
switch(arguments.length){
case 1:
return G__3562__1.call(this,x);
case 2:
return G__3562__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3562.cljs$core$IFn$_invoke$arity$1 = G__3562__1;
G__3562.cljs$core$IFn$_invoke$arity$2 = G__3562__2;
return G__3562;
})()
);

(cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
}));

(cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
}));

(cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
}));

(cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (col,f){
var self__ = this;
var col__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,col__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (col,f,start){
var self__ = this;
var col__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,col__$1);
}));

(cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
}));

(cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
}
}));

(cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.RSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ci,cljs.core.cst$sym$i,cljs.core.cst$sym$meta], null);
}));

(cljs.core.RSeq.cljs$lang$type = true);

(cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq");

(cljs.core.RSeq.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/RSeq");
}));

/**
 * Positional factory function for cljs.core/RSeq.
 */
cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

goog.object.set(cljs.core.RSeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if((!((sn == null)))){
var G__3563 = sn;
s = G__3563;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
goog.object.set(cljs.core.IEquiv,"_",true);

goog.object.set(cljs.core._equiv,"_",(function (x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 *   'added'. (conj nil item) returns (item).  The 'addition' may
 *   happen at different 'places' depending on the concrete type.
 */
cljs.core.conj = (function cljs$core$conj(var_args){
var G__3568 = arguments.length;
switch (G__3568) {
case 0:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3570 = arguments.length;
var i__4772__auto___3571 = (0);
while(true){
if((i__4772__auto___3571 < len__4771__auto___3570)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3571]));

var G__3572 = (i__4772__auto___3571 + (1));
i__4772__auto___3571 = G__3572;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
if((!((coll == null)))){
return cljs.core._conj(coll,x);
} else {
return (new cljs.core.List(null,x,null,(1),null));
}
}));

(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__3573 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__3574 = cljs.core.first(xs);
var G__3575 = cljs.core.next(xs);
coll = G__3573;
x = G__3574;
xs = G__3575;
continue;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
}));

/** @this {Function} */
(cljs.core.conj.cljs$lang$applyTo = (function (seq3565){
var G__3566 = cljs.core.first(seq3565);
var seq3565__$1 = cljs.core.next(seq3565);
var G__3567 = cljs.core.first(seq3565__$1);
var seq3565__$2 = cljs.core.next(seq3565__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3566,G__3567,seq3565__$2);
}));

(cljs.core.conj.cljs$lang$maxFixedArity = (2));

/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:false):false)){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IEmptyableCollection$))))?true:(((!coll.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEmptyableCollection,coll))){
return cljs.core._empty(coll);
} else {
return null;

}
}
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__3578 = cljs.core.next(s);
var G__3579 = (acc + (1));
s = G__3578;
acc = G__3579;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 *   0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if((!((coll == null)))){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ICounted$))))?true:false):false)){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeqable$))))?true:false):false)){
return cljs.core.accumulating_seq_count(coll);
} else {
return cljs.core._count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function cljs$core$linear_traversal_nth(var_args){
var G__3583 = arguments.length;
switch (G__3583) {
case 2:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__3585 = cljs.core.next(coll);
var G__3586 = (n - (1));
coll = G__3585;
n = G__3586;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
}));

(cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__3587 = cljs.core.next(coll);
var G__3588 = (n - (1));
var G__3589 = not_found;
coll = G__3587;
n = G__3588;
not_found = G__3589;
continue;
} else {
return not_found;

}
}
}
}
break;
}
}));

(cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3);

/**
 * Returns the value at the index. get returns nil if index out of
 *   bounds, nth throws an exception unless not-found is supplied.  nth
 *   also works for strings, arrays, regex Matchers and Lists, and,
 *   in O(n) time, for sequences.
 */
cljs.core.nth = (function cljs$core$nth(var_args){
var G__3591 = arguments.length;
switch (G__3591) {
case 2:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
throw (new Error("Index out of bounds"));
}
} else {
if((function (){var or__4160__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__4160__auto__){
return or__4160__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
throw (new Error("Index out of bounds"));
} else {
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
}));

(cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if((!(typeof n === 'number'))){
throw (new Error("Index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IIndexed$))))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if(((((-1) < n)) && ((n < coll.length)))){
return (coll[(n | (0))]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if(((((-1) < n)) && ((n < coll.length)))){
return coll.charAt((n | (0)));
} else {
return not_found;
}
} else {
if((function (){var or__4160__auto__ = (((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false);
if(or__4160__auto__){
return or__4160__auto__;
} else {
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISequential$)))){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
if((n < (0))){
return not_found;
} else {
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
throw (new Error(["nth not supported on this type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
}));

(cljs.core.nth.cljs$lang$maxFixedArity = 3);

/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
var n__$1 = n;
var xs = coll;
while(true){
var temp__5751__auto__ = (((n__$1 > (0))) && (cljs.core.seq(xs)));
if(temp__5751__auto__){
var xs__$1 = temp__5751__auto__;
var G__3601 = (n__$1 - (1));
var G__3602 = cljs.core.rest(xs__$1);
n__$1 = G__3601;
xs = G__3602;
continue;
} else {
return xs;
}
break;
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present.
 */
cljs.core.get = (function cljs$core$get(var_args){
var G__3604 = arguments.length;
switch (G__3604) {
case 2:
return cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.get.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((o == null)){
return null;
} else {
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(cljs.core.array_QMARK_(o)){
if((((!((k == null)))) && ((k < o.length)))){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return o.charAt((k | (0)));
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
}));

(cljs.core.get.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if((!((o == null)))){
if((((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (256))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$ILookup$))))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return (o[(k | (0))]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((((!((k == null)))) && (((((-1) < k)) && ((k < o.length)))))){
return o.charAt((k | (0)));
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
}));

(cljs.core.get.cljs$lang$maxFixedArity = 3);



/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index. Note - index must be <= (count vector).
 */
cljs.core.assoc = (function cljs$core$assoc(var_args){
var G__3613 = arguments.length;
switch (G__3613) {
case 3:
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3616 = arguments.length;
var i__4772__auto___3617 = (0);
while(true){
if((i__4772__auto___3617 < len__4771__auto___3616)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3617]));

var G__3618 = (i__4772__auto___3617 + (1));
i__4772__auto___3617 = G__3618;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((3)),(0),null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4793__auto__);

}
});

(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = (function (coll,k,v){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IAssociative$))))?true:false):false)){
return coll.cljs$core$IAssociative$_assoc$arity$3(null,k,v);
} else {
if((!((coll == null)))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k,v]);
}
}
}));

(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,v,kvs){
while(true){
var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__3619 = ret;
var G__3620 = cljs.core.first(kvs);
var G__3621 = cljs.core.second(kvs);
var G__3622 = cljs.core.nnext(kvs);
coll = G__3619;
k = G__3620;
v = G__3621;
kvs = G__3622;
continue;
} else {
return ret;
}
break;
}
}));

/** @this {Function} */
(cljs.core.assoc.cljs$lang$applyTo = (function (seq3609){
var G__3610 = cljs.core.first(seq3609);
var seq3609__$1 = cljs.core.next(seq3609);
var G__3611 = cljs.core.first(seq3609__$1);
var seq3609__$2 = cljs.core.next(seq3609__$1);
var G__3612 = cljs.core.first(seq3609__$2);
var seq3609__$3 = cljs.core.next(seq3609__$2);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3610,G__3611,G__3612,seq3609__$3);
}));

(cljs.core.assoc.cljs$lang$maxFixedArity = (3));

/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 *   that does not contain a mapping for key(s).
 */
cljs.core.dissoc = (function cljs$core$dissoc(var_args){
var G__3627 = arguments.length;
switch (G__3627) {
case 1:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3629 = arguments.length;
var i__4772__auto___3630 = (0);
while(true){
if((i__4772__auto___3630 < len__4771__auto___3629)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3630]));

var G__3631 = (i__4772__auto___3630 + (1));
i__4772__auto___3630 = G__3631;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
}));

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
}));

(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__3632 = ret;
var G__3633 = cljs.core.first(ks);
var G__3634 = cljs.core.next(ks);
coll = G__3632;
k = G__3633;
ks = G__3634;
continue;
} else {
return ret;
}
}
break;
}
}));

/** @this {Function} */
(cljs.core.dissoc.cljs$lang$applyTo = (function (seq3624){
var G__3625 = cljs.core.first(seq3624);
var seq3624__$1 = cljs.core.next(seq3624);
var G__3626 = cljs.core.first(seq3624__$1);
var seq3624__$2 = cljs.core.next(seq3624__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3625,G__3626,seq3624__$2);
}));

(cljs.core.dissoc.cljs$lang$maxFixedArity = (2));

/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__4160__auto__ = typeof f === 'function';
if(or__4160__auto__){
return or__4160__auto__;
} else {
if((!((f == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$Fn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
}
}
});

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 393217;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
}));

(cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
}));

(cljs.core.MetaFn.prototype.cljs$core$Fn$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.MetaFn.prototype.call = (function() {
var G__3638 = null;
var G__3638__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var G__3638__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
});
var G__3638__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
});
var G__3638__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
});
var G__3638__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
});
var G__3638__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
});
var G__3638__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
});
var G__3638__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
});
var G__3638__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
});
var G__3638__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
});
var G__3638__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
});
var G__3638__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
});
var G__3638__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});
var G__3638__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});
var G__3638__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});
var G__3638__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});
var G__3638__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});
var G__3638__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});
var G__3638__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});
var G__3638__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});
var G__3638__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});
var G__3638__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.afn,a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
});
G__3638 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__3638__1.call(this,self__);
case 2:
return G__3638__2.call(this,self__,a);
case 3:
return G__3638__3.call(this,self__,a,b);
case 4:
return G__3638__4.call(this,self__,a,b,c);
case 5:
return G__3638__5.call(this,self__,a,b,c,d);
case 6:
return G__3638__6.call(this,self__,a,b,c,d,e);
case 7:
return G__3638__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__3638__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__3638__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__3638__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__3638__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__3638__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__3638__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__3638__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__3638__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__3638__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__3638__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__3638__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__3638__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__3638__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__3638__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__3638__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__3638.cljs$core$IFn$_invoke$arity$1 = G__3638__1;
G__3638.cljs$core$IFn$_invoke$arity$2 = G__3638__2;
G__3638.cljs$core$IFn$_invoke$arity$3 = G__3638__3;
G__3638.cljs$core$IFn$_invoke$arity$4 = G__3638__4;
G__3638.cljs$core$IFn$_invoke$arity$5 = G__3638__5;
G__3638.cljs$core$IFn$_invoke$arity$6 = G__3638__6;
G__3638.cljs$core$IFn$_invoke$arity$7 = G__3638__7;
G__3638.cljs$core$IFn$_invoke$arity$8 = G__3638__8;
G__3638.cljs$core$IFn$_invoke$arity$9 = G__3638__9;
G__3638.cljs$core$IFn$_invoke$arity$10 = G__3638__10;
G__3638.cljs$core$IFn$_invoke$arity$11 = G__3638__11;
G__3638.cljs$core$IFn$_invoke$arity$12 = G__3638__12;
G__3638.cljs$core$IFn$_invoke$arity$13 = G__3638__13;
G__3638.cljs$core$IFn$_invoke$arity$14 = G__3638__14;
G__3638.cljs$core$IFn$_invoke$arity$15 = G__3638__15;
G__3638.cljs$core$IFn$_invoke$arity$16 = G__3638__16;
G__3638.cljs$core$IFn$_invoke$arity$17 = G__3638__17;
G__3638.cljs$core$IFn$_invoke$arity$18 = G__3638__18;
G__3638.cljs$core$IFn$_invoke$arity$19 = G__3638__19;
G__3638.cljs$core$IFn$_invoke$arity$20 = G__3638__20;
G__3638.cljs$core$IFn$_invoke$arity$21 = G__3638__21;
G__3638.cljs$core$IFn$_invoke$arity$22 = G__3638__22;
return G__3638;
})()
);

(cljs.core.MetaFn.prototype.apply = (function (self__,args3637){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args3637)));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
}));

(cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(self__.afn,a,b,c,d,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest], 0));
}));

(cljs.core.MetaFn.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$afn,cljs.core.cst$sym$meta], null);
}));

(cljs.core.MetaFn.cljs$lang$type = true);

(cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn");

(cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/MetaFn");
}));

/**
 * Positional factory function for cljs.core/MetaFn.
 */
cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 *   map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if(typeof o === 'function'){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((((!((o == null))))?(((!((o == null))))?(((((o.cljs$lang$protocol_mask$partition0$ & (131072))) || ((cljs.core.PROTOCOL_SENTINEL === o.cljs$core$IMeta$))))?true:(((!o.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o)):false)){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 *   more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 *   item, for a vector, returns a new vector without the last item.
 *   Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj = (function cljs$core$disj(var_args){
var G__3645 = arguments.length;
switch (G__3645) {
case 1:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3647 = arguments.length;
var i__4772__auto___3648 = (0);
while(true){
if((i__4772__auto___3648 < len__4771__auto___3647)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3648]));

var G__3649 = (i__4772__auto___3648 + (1));
i__4772__auto___3648 = G__3649;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
}));

(cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
}));

(cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__3650 = ret;
var G__3651 = cljs.core.first(ks);
var G__3652 = cljs.core.next(ks);
coll = G__3650;
k = G__3651;
ks = G__3652;
continue;
} else {
return ret;
}
}
break;
}
}));

/** @this {Function} */
(cljs.core.disj.cljs$lang$applyTo = (function (seq3642){
var G__3643 = cljs.core.first(seq3642);
var seq3642__$1 = cljs.core.next(seq3642);
var G__3644 = cljs.core.first(seq3642__$1);
var seq3642__$2 = cljs.core.next(seq3642__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3643,G__3644,seq3642__$2);
}));

(cljs.core.disj.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if coll has no items - same as (not (seq coll)).
 *   Please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
return (((coll == null)) || (cljs.core.not(cljs.core.seq(coll))));
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (8))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ICollection$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISet$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
}
}
});
/**
 * Returns true if coll implements IAssociative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IAssociative$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
}
});
/**
 * Returns true if coll implements IFind
 */
cljs.core.ifind_QMARK_ = (function cljs$core$ifind_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IFind$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFind,x);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISequential$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (268435456))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISorted$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IReduce$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMap$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
}
}
});
/**
 * Return true if x satisfies IRecord
 */
cljs.core.record_QMARK_ = (function cljs$core$record_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (67108864))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IRecord$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (16384))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IVector$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
}
});

/**
 * Return true if x satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition1$ & (512))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IChunkedSeq$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 *   interleaved keys and values.
 */
cljs.core.js_obj = (function cljs$core$js_obj(var_args){
var G__3666 = arguments.length;
switch (G__3666) {
case 0:
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3670 = arguments.length;
var i__4772__auto___3671 = (0);
while(true){
if((i__4772__auto___3671 < len__4771__auto___3670)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3671]));

var G__3672 = (i__4772__auto___3671 + (1));
i__4772__auto___3671 = G__3672;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((0)),(0),null));
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__4793__auto__);

}
});

(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = (function (){
return ({});
}));

(cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(goog.object.create,keyvals);
}));

/** @this {Function} */
(cljs.core.js_obj.cljs$lang$applyTo = (function (seq3665){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq3665));
}));

(cljs.core.js_obj.cljs$lang$maxFixedArity = (0));

/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
return goog.object.getKeys(obj);
});
/**
 * Delete a property from a JavaScript object.
 *   Returns true upon success, false otherwise.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__3673 = (i__$1 + (1));
var G__3674 = (j__$1 + (1));
var G__3675 = (len__$1 - (1));
i__$1 = G__3673;
j__$1 = G__3674;
len__$1 = G__3675;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__3676 = (i__$1 - (1));
var G__3677 = (j__$1 - (1));
var G__3678 = (len__$1 - (1));
i__$1 = G__3676;
j__$1 = G__3677;
len__$1 = G__3678;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = ({});
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Return true if x is a Boolean
 */
cljs.core.boolean_QMARK_ = (function cljs$core$boolean_QMARK_(x){
return ((x === true) || (x === false));
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
if((!((s == null)))){
if((((s.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeq$)))){
return true;
} else {
if((!s.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
}
}
});
/**
 * Return true if the seq function is supported for s
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
var or__4160__auto__ = (s == null);
if(or__4160__auto__){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = (((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$ISeqable$))))?true:(((!s.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s));
if(or__4160__auto____$1){
return or__4160__auto____$1;
} else {
return ((cljs.core.array_QMARK_(s)) || (typeof s === 'string'));
}
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if((x == null)){
return false;
} else {
if(x === false){
return false;
} else {
return true;

}
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__4160__auto__ = cljs.core.fn_QMARK_(f);
if(or__4160__auto__){
return or__4160__auto__;
} else {
if((!((f == null)))){
if((((f.cljs$lang$protocol_mask$partition0$ & (1))) || ((cljs.core.PROTOCOL_SENTINEL === f.cljs$core$IFn$)))){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
}
}
});
/**
 * Returns true if n is a JavaScript number with no decimal part.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return ((typeof n === 'number') && ((!(isNaN(n)))) && ((!((n === Infinity)))) && ((parseFloat(n) === parseInt(n,(10)))));
});
/**
 * Return true if x satisfies integer? or is an instance of goog.math.Integer
 * or goog.math.Long.
 */
cljs.core.int_QMARK_ = (function cljs$core$int_QMARK_(x){
return ((cljs.core.integer_QMARK_(x)) || ((x instanceof goog.math.Integer)) || ((x instanceof goog.math.Long)));
});
/**
 * Return true if x satisfies int? and is positive.
 */
cljs.core.pos_int_QMARK_ = (function cljs$core$pos_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x > (0));
} else {
if((x instanceof goog.math.Integer)){
return ((cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero())));
} else {
if((x instanceof goog.math.Long)){
return ((cljs.core.not(x.isNegative())) && (cljs.core.not(x.isZero())));
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is negative.
 */
cljs.core.neg_int_QMARK_ = (function cljs$core$neg_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (x < (0));
} else {
if((x instanceof goog.math.Integer)){
return x.isNegative();
} else {
if((x instanceof goog.math.Long)){
return x.isNegative();
} else {
return false;

}
}
}
});
/**
 * Return true if x satisfies int? and is a natural integer value.
 */
cljs.core.nat_int_QMARK_ = (function cljs$core$nat_int_QMARK_(x){
if(cljs.core.integer_QMARK_(x)){
return (!((x < (0))));
} else {
if((x instanceof goog.math.Integer)){
return cljs.core.not(x.isNegative());
} else {
if((x instanceof goog.math.Long)){
return cljs.core.not(x.isNegative());
} else {
return false;

}
}
}
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.float_QMARK_ = (function cljs$core$float_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for JavaScript numbers, false otherwise.
 */
cljs.core.double_QMARK_ = (function cljs$core$double_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true for Infinity and -Infinity values.
 */
cljs.core.infinite_QMARK_ = (function cljs$core$infinite_QMARK_(x){
return (((x === Number.POSITIVE_INFINITY)) || ((x === Number.NEGATIVE_INFINITY)));
});
/**
 * Returns true if key is present in the given collection, otherwise
 *   returns false.  Note that for numerically indexed collections like
 *   vectors and arrays, this tests if the numeric key is within the
 *   range of indexes. 'contains?' operates constant or logarithmic time;
 *   it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if(cljs.core.ifind_QMARK_(coll)){
return cljs.core._find(coll,k);
} else {
if((((!((coll == null)))) && (cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k)))){
return (new cljs.core.MapEntry(k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k),null));
} else {
return null;
}
}
});
/**
 * Returns true if no two of the arguments are =
 */
cljs.core.distinct_QMARK_ = (function cljs$core$distinct_QMARK_(var_args){
var G__3691 = arguments.length;
switch (G__3691) {
case 1:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3693 = arguments.length;
var i__4772__auto___3694 = (0);
while(true){
if((i__4772__auto___3694 < len__4771__auto___3693)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3694]));

var G__3695 = (i__4772__auto___3694 + (1));
i__4772__auto___3694 = G__3695;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));
}));

(cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
if((!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)))){
var s = cljs.core.PersistentHashSet.createAsIfByAssoc([x,y]);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__3696 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__3697 = etc;
s = G__3696;
xs = G__3697;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
}));

/** @this {Function} */
(cljs.core.distinct_QMARK_.cljs$lang$applyTo = (function (seq3688){
var G__3689 = cljs.core.first(seq3688);
var seq3688__$1 = cljs.core.next(seq3688);
var G__3690 = cljs.core.first(seq3688__$1);
var seq3688__$2 = cljs.core.next(seq3688__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3689,G__3690,seq3688__$2);
}));

(cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = (2));

/**
 * Comparator. Returns a negative number, zero, or a positive number
 *   when x is logically 'less than', 'equal to', or 'greater than'
 *   y. Uses IComparable if available and google.array.defaultCompare for objects
 *  of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if(typeof x === 'number'){
if(typeof y === 'number'){
return goog.array.defaultCompare(x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}
} else {
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IComparable$))))?true:(((!x.cljs$lang$protocol_mask$partition1$))?cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x))){
return cljs.core._compare(x,y);
} else {
if(((((typeof x === 'string') || (cljs.core.array_QMARK_(x)) || (x === true) || (x === false))) && ((cljs.core.type(x) === cljs.core.type(y))))){
return goog.array.defaultCompare(x,y);
} else {
throw (new Error(["Cannot compare ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)," to ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(y)].join('')));
}

}
}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function cljs$core$compare_indexed(var_args){
var G__3700 = arguments.length;
switch (G__3700) {
case 2:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = (function (xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
if((xl === (0))){
return (0);
} else {
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
}
}));

(cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = (function (xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if((((d === (0))) && (((n + (1)) < len)))){
var G__3702 = xs;
var G__3703 = ys;
var G__3704 = len;
var G__3705 = (n + (1));
xs = G__3702;
ys = G__3703;
len = G__3704;
n = G__3705;
continue;
} else {
return d;
}
break;
}
}));

(cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4);

/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function (x,y){
var r = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y,x) : f.call(null,y,x)))){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function cljs$core$sort(var_args){
var G__3707 = arguments.length;
switch (G__3707) {
case 1:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
}));

(cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = (function (comp,coll){
if(cljs.core.seq(coll)){
var a = cljs.core.to_array(coll);
var G__3708_3711 = a;
var G__3709_3712 = cljs.core.fn__GT_comparator(comp);
goog.array.stableSort(G__3708_3711,G__3709_3712);

return cljs.core.with_meta(cljs.core.seq(a),cljs.core.meta(coll));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.sort.cljs$lang$maxFixedArity = 2);

/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function cljs$core$sort_by(var_args){
var G__3714 = arguments.length;
switch (G__3714) {
case 2:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
}));

(cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = (function (keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){
var G__3716 = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null,x));
var G__3717 = (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null,y));
var fexpr__3715 = cljs.core.fn__GT_comparator(comp);
return (fexpr__3715.cljs$core$IFn$_invoke$arity$2 ? fexpr__3715.cljs$core$IFn$_invoke$arity$2(G__3716,G__3717) : fexpr__3715.call(null,G__3716,G__3717));
}),coll);
}));

(cljs.core.sort_by.cljs$lang$maxFixedArity = 3);

cljs.core.seq_reduce = (function cljs$core$seq_reduce(var_args){
var G__3720 = arguments.length;
switch (G__3720) {
case 2:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var temp__5751__auto__ = cljs.core.seq(coll);
if(temp__5751__auto__){
var s = temp__5751__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.next(s));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__3721 = val__$1;
var G__3722 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__3721,G__3722) : f.call(null,G__3721,G__3722));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__3724 = nval;
var G__3725 = cljs.core.next(coll__$1);
val__$1 = G__3724;
coll__$1 = G__3725;
continue;
}
} else {
return val__$1;
}
break;
}
}));

(cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3);

/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = cljs.core.to_array(coll);
goog.array.shuffle(a);

return cljs.core.vec(a);
});
cljs.core.iter_reduce = (function cljs$core$iter_reduce(var_args){
var G__3727 = arguments.length;
switch (G__3727) {
case 2:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2 = (function (coll,f){
var iter = cljs.core._iterator(coll);
if(cljs.core.truth_(iter.hasNext())){
var init = iter.next();
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = (function (){var G__3728 = acc;
var G__3729 = iter.next();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__3728,G__3729) : f.call(null,G__3728,G__3729));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__3733 = nacc;
acc = G__3733;
continue;
}
} else {
return acc;
}
break;
}
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3 = (function (coll,f,init){
var iter = cljs.core._iterator(coll);
var acc = init;
while(true){
if(iter.hasNext()){
var nacc = (function (){var G__3730 = acc;
var G__3731 = iter.next();
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__3730,G__3731) : f.call(null,G__3730,G__3731));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__3734 = nacc;
acc = G__3734;
continue;
}
} else {
return acc;
}
break;
}
}));

(cljs.core.iter_reduce.cljs$lang$maxFixedArity = 3);

/**
 * f should be a function of 2 arguments. If val is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc. If coll contains no
 *   items, f must accept no arguments as well, and reduce returns the
 *   result of calling f with no arguments.  If coll has only 1 item, it
 *   is returned and f is not called.  If val is supplied, returns the
 *   result of applying f to val and the first item in coll, then
 *   applying f to that result and the 2nd item, etc. If coll contains no
 *   items, returns val and f is not called.
 */
cljs.core.reduce = (function cljs$core$reduce(var_args){
var G__3736 = arguments.length;
switch (G__3736) {
case 2:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
}
}));

(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReduce$))))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
}
}));

(cljs.core.reduce.cljs$lang$maxFixedArity = 3);

/**
 * Reduces an associative collection. f should be a function of 3
 *   arguments. Returns the result of applying f to init, the first key
 *   and the first value in coll, then applying f to that result and the
 *   2nd key and value, etc. If coll contains no entries, returns init
 *   and f is not called. Note that reduce-kv is supported on vectors,
 *   where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if((!((coll == null)))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return init;
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 *   transduce by adding an arity-1 signature that calls cf (default -
 *   identity) on the result argument.
 */
cljs.core.completing = (function cljs$core$completing(var_args){
var G__3741 = arguments.length;
switch (G__3741) {
case 1:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
}));

(cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = (function (f,cf){
return (function() {
var G__3743 = null;
var G__3743__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var G__3743__1 = (function (x){
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null,x));
});
var G__3743__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
});
G__3743 = function(x,y){
switch(arguments.length){
case 0:
return G__3743__0.call(this);
case 1:
return G__3743__1.call(this,x);
case 2:
return G__3743__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__3743.cljs$core$IFn$_invoke$arity$0 = G__3743__0;
G__3743.cljs$core$IFn$_invoke$arity$1 = G__3743__1;
G__3743.cljs$core$IFn$_invoke$arity$2 = G__3743__2;
return G__3743;
})()
}));

(cljs.core.completing.cljs$lang$maxFixedArity = 2);

/**
 * reduce with a transformation of f (xf). If init is not
 *   supplied, (f) will be called to produce it. f should be a reducing
 *   step function that accepts both 1 and 2 arguments, if it accepts
 *   only 2 you can add the arity-1 with 'completing'. Returns the result
 *   of applying (the transformed) xf to init and the first item in coll,
 *   then applying xf to that result and the 2nd item, etc. If coll
 *   contains no items, returns init and f is not called. Note that
 *   certain transforms may inject or skip items.
 */
cljs.core.transduce = (function cljs$core$transduce(var_args){
var G__3745 = arguments.length;
switch (G__3745) {
case 3:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = (function (xform,f,coll){
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),coll);
}));

(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = (function (xform,f,init,coll){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null,ret));
}));

(cljs.core.transduce.cljs$lang$maxFixedArity = 4);

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core._PLUS_ = (function cljs$core$_PLUS_(var_args){
var G__3751 = arguments.length;
switch (G__3751) {
case 0:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3753 = arguments.length;
var i__4772__auto___3754 = (0);
while(true){
if((i__4772__auto___3754 < len__4771__auto___3753)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3754]));

var G__3755 = (i__4772__auto___3754 + (1));
i__4772__auto___3754 = G__3755;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
}));

(cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(x + y),more);
}));

/** @this {Function} */
(cljs.core._PLUS_.cljs$lang$applyTo = (function (seq3748){
var G__3749 = cljs.core.first(seq3748);
var seq3748__$1 = cljs.core.next(seq3748);
var G__3750 = cljs.core.first(seq3748__$1);
var seq3748__$2 = cljs.core.next(seq3748__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3749,G__3750,seq3748__$2);
}));

(cljs.core._PLUS_.cljs$lang$maxFixedArity = (2));

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core._ = (function cljs$core$_(var_args){
var G__3760 = arguments.length;
switch (G__3760) {
case 1:
return cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3762 = arguments.length;
var i__4772__auto___3763 = (0);
while(true){
if((i__4772__auto___3763 < len__4771__auto___3762)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3763]));

var G__3764 = (i__4772__auto___3763 + (1));
i__4772__auto___3763 = G__3764;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core._.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
}));

(cljs.core._.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
}));

(cljs.core._.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,(x - y),more);
}));

/** @this {Function} */
(cljs.core._.cljs$lang$applyTo = (function (seq3757){
var G__3758 = cljs.core.first(seq3757);
var seq3757__$1 = cljs.core.next(seq3757);
var G__3759 = cljs.core.first(seq3757__$1);
var seq3757__$2 = cljs.core.next(seq3757__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3758,G__3759,seq3757__$2);
}));

(cljs.core._.cljs$lang$maxFixedArity = (2));

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core._STAR_ = (function cljs$core$_STAR_(var_args){
var G__3769 = arguments.length;
switch (G__3769) {
case 0:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3771 = arguments.length;
var i__4772__auto___3772 = (0);
while(true){
if((i__4772__auto___3772 < len__4771__auto___3771)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3772]));

var G__3773 = (i__4772__auto___3772 + (1));
i__4772__auto___3772 = G__3773;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
}));

(cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(x * y),more);
}));

/** @this {Function} */
(cljs.core._STAR_.cljs$lang$applyTo = (function (seq3766){
var G__3767 = cljs.core.first(seq3766);
var seq3766__$1 = cljs.core.next(seq3766);
var G__3768 = cljs.core.first(seq3766__$1);
var seq3766__$2 = cljs.core.next(seq3766__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3767,G__3768,seq3766__$2);
}));

(cljs.core._STAR_.cljs$lang$maxFixedArity = (2));

/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core._SLASH_ = (function cljs$core$_SLASH_(var_args){
var G__3778 = arguments.length;
switch (G__3778) {
case 1:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3780 = arguments.length;
var i__4772__auto___3781 = (0);
while(true){
if((i__4772__auto___3781 < len__4771__auto___3780)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3781]));

var G__3782 = (i__4772__auto___3781 + (1));
i__4772__auto___3781 = G__3782;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
}));

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
}));

(cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(x / y),more);
}));

/** @this {Function} */
(cljs.core._SLASH_.cljs$lang$applyTo = (function (seq3775){
var G__3776 = cljs.core.first(seq3775);
var seq3775__$1 = cljs.core.next(seq3775);
var G__3777 = cljs.core.first(seq3775__$1);
var seq3775__$2 = cljs.core.next(seq3775__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3776,G__3777,seq3775__$2);
}));

(cljs.core._SLASH_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically increasing order,
 *   otherwise false.
 */
cljs.core._LT_ = (function cljs$core$_LT_(var_args){
var G__3787 = arguments.length;
switch (G__3787) {
case 1:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3789 = arguments.length;
var i__4772__auto___3790 = (0);
while(true){
if((i__4772__auto___3790 < len__4771__auto___3789)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3790]));

var G__3791 = (i__4772__auto___3790 + (1));
i__4772__auto___3790 = G__3791;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x < y);
}));

(cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__3792 = y;
var G__3793 = cljs.core.first(more);
var G__3794 = cljs.core.next(more);
x = G__3792;
y = G__3793;
more = G__3794;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._LT_.cljs$lang$applyTo = (function (seq3784){
var G__3785 = cljs.core.first(seq3784);
var seq3784__$1 = cljs.core.next(seq3784);
var G__3786 = cljs.core.first(seq3784__$1);
var seq3784__$2 = cljs.core.next(seq3784__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3785,G__3786,seq3784__$2);
}));

(cljs.core._LT_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 *   otherwise false.
 */
cljs.core._LT__EQ_ = (function cljs$core$_LT__EQ_(var_args){
var G__3799 = arguments.length;
switch (G__3799) {
case 1:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3801 = arguments.length;
var i__4772__auto___3802 = (0);
while(true){
if((i__4772__auto___3802 < len__4771__auto___3801)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3802]));

var G__3803 = (i__4772__auto___3802 + (1));
i__4772__auto___3802 = G__3803;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x <= y);
}));

(cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__3804 = y;
var G__3805 = cljs.core.first(more);
var G__3806 = cljs.core.next(more);
x = G__3804;
y = G__3805;
more = G__3806;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._LT__EQ_.cljs$lang$applyTo = (function (seq3796){
var G__3797 = cljs.core.first(seq3796);
var seq3796__$1 = cljs.core.next(seq3796);
var G__3798 = cljs.core.first(seq3796__$1);
var seq3796__$2 = cljs.core.next(seq3796__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3797,G__3798,seq3796__$2);
}));

(cljs.core._LT__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically decreasing order,
 *   otherwise false.
 */
cljs.core._GT_ = (function cljs$core$_GT_(var_args){
var G__3811 = arguments.length;
switch (G__3811) {
case 1:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3813 = arguments.length;
var i__4772__auto___3814 = (0);
while(true){
if((i__4772__auto___3814 < len__4771__auto___3813)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3814]));

var G__3815 = (i__4772__auto___3814 + (1));
i__4772__auto___3814 = G__3815;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x > y);
}));

(cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__3816 = y;
var G__3817 = cljs.core.first(more);
var G__3818 = cljs.core.next(more);
x = G__3816;
y = G__3817;
more = G__3818;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._GT_.cljs$lang$applyTo = (function (seq3808){
var G__3809 = cljs.core.first(seq3808);
var seq3808__$1 = cljs.core.next(seq3808);
var G__3810 = cljs.core.first(seq3808__$1);
var seq3808__$2 = cljs.core.next(seq3808__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3809,G__3810,seq3808__$2);
}));

(cljs.core._GT_.cljs$lang$maxFixedArity = (2));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 *   otherwise false.
 */
cljs.core._GT__EQ_ = (function cljs$core$_GT__EQ_(var_args){
var G__3823 = arguments.length;
switch (G__3823) {
case 1:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3825 = arguments.length;
var i__4772__auto___3826 = (0);
while(true){
if((i__4772__auto___3826 < len__4771__auto___3825)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3826]));

var G__3827 = (i__4772__auto___3826 + (1));
i__4772__auto___3826 = G__3827;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x >= y);
}));

(cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__3828 = y;
var G__3829 = cljs.core.first(more);
var G__3830 = cljs.core.next(more);
x = G__3828;
y = G__3829;
more = G__3830;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._GT__EQ_.cljs$lang$applyTo = (function (seq3820){
var G__3821 = cljs.core.first(seq3820);
var seq3820__$1 = cljs.core.next(seq3820);
var G__3822 = cljs.core.first(seq3820__$1);
var seq3820__$2 = cljs.core.next(seq3820__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3821,G__3822,seq3820__$2);
}));

(cljs.core._GT__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the greatest of the nums.
 */
cljs.core.max = (function cljs$core$max(var_args){
var G__3835 = arguments.length;
switch (G__3835) {
case 1:
return cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3837 = arguments.length;
var i__4772__auto___3838 = (0);
while(true){
if((i__4772__auto___3838 < len__4771__auto___3837)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3838]));

var G__3839 = (i__4772__auto___3838 + (1));
i__4772__auto___3838 = G__3839;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.max.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.max.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__4249__auto__ = x;
var y__4250__auto__ = y;
return ((x__4249__auto__ > y__4250__auto__) ? x__4249__auto__ : y__4250__auto__);
}));

(cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(function (){var x__4249__auto__ = x;
var y__4250__auto__ = y;
return ((x__4249__auto__ > y__4250__auto__) ? x__4249__auto__ : y__4250__auto__);
})(),more);
}));

/** @this {Function} */
(cljs.core.max.cljs$lang$applyTo = (function (seq3832){
var G__3833 = cljs.core.first(seq3832);
var seq3832__$1 = cljs.core.next(seq3832);
var G__3834 = cljs.core.first(seq3832__$1);
var seq3832__$2 = cljs.core.next(seq3832__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3833,G__3834,seq3832__$2);
}));

(cljs.core.max.cljs$lang$maxFixedArity = (2));

/**
 * Returns the least of the nums.
 */
cljs.core.min = (function cljs$core$min(var_args){
var G__3844 = arguments.length;
switch (G__3844) {
case 1:
return cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3846 = arguments.length;
var i__4772__auto___3847 = (0);
while(true){
if((i__4772__auto___3847 < len__4771__auto___3846)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3847]));

var G__3848 = (i__4772__auto___3847 + (1));
i__4772__auto___3847 = G__3848;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.min.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.min.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__4252__auto__ = x;
var y__4253__auto__ = y;
return ((x__4252__auto__ < y__4253__auto__) ? x__4252__auto__ : y__4253__auto__);
}));

(cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(function (){var x__4252__auto__ = x;
var y__4253__auto__ = y;
return ((x__4252__auto__ < y__4253__auto__) ? x__4252__auto__ : y__4253__auto__);
})(),more);
}));

/** @this {Function} */
(cljs.core.min.cljs$lang$applyTo = (function (seq3841){
var G__3842 = cljs.core.first(seq3841);
var seq3841__$1 = cljs.core.next(seq3841);
var G__3843 = cljs.core.first(seq3841__$1);
var seq3841__$2 = cljs.core.next(seq3841__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3842,G__3843,seq3841__$2);
}));

(cljs.core.min.cljs$lang$maxFixedArity = (2));

cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if(((typeof x === 'string') && ((x.length === (1))))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add = (function cljs$core$unchecked_add(var_args){
var G__3853 = arguments.length;
switch (G__3853) {
case 0:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3855 = arguments.length;
var i__4772__auto___3856 = (0);
while(true){
if((i__4772__auto___3856 < len__4771__auto___3855)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3856]));

var G__3857 = (i__4772__auto___3856 + (1));
i__4772__auto___3856 = G__3857;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
}));

(cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,(x + y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_add.cljs$lang$applyTo = (function (seq3850){
var G__3851 = cljs.core.first(seq3850);
var seq3850__$1 = cljs.core.next(seq3850);
var G__3852 = cljs.core.first(seq3850__$1);
var seq3850__$2 = cljs.core.next(seq3850__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3851,G__3852,seq3850__$2);
}));

(cljs.core.unchecked_add.cljs$lang$maxFixedArity = (2));

/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add_int = (function cljs$core$unchecked_add_int(var_args){
var G__3862 = arguments.length;
switch (G__3862) {
case 0:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3864 = arguments.length;
var i__4772__auto___3865 = (0);
while(true){
if((i__4772__auto___3865 < len__4771__auto___3864)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3865]));

var G__3866 = (i__4772__auto___3865 + (1));
i__4772__auto___3865 = G__3866;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
}));

(cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,(x + y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_add_int.cljs$lang$applyTo = (function (seq3859){
var G__3860 = cljs.core.first(seq3859);
var seq3859__$1 = cljs.core.next(seq3859);
var G__3861 = cljs.core.first(seq3859__$1);
var seq3859__$2 = cljs.core.next(seq3859__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3860,G__3861,seq3859__$2);
}));

(cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = (2));

/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core.unchecked_divide_int = (function cljs$core$unchecked_divide_int(var_args){
var G__3871 = arguments.length;
switch (G__3871) {
case 1:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3873 = arguments.length;
var i__4772__auto___3874 = (0);
while(true){
if((i__4772__auto___3874 < len__4771__auto___3873)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3874]));

var G__3875 = (i__4772__auto___3874 + (1));
i__4772__auto___3874 = G__3875;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
}));

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
}));

(cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,(x / y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_divide_int.cljs$lang$applyTo = (function (seq3868){
var G__3869 = cljs.core.first(seq3868);
var seq3868__$1 = cljs.core.next(seq3868);
var G__3870 = cljs.core.first(seq3868__$1);
var seq3868__$2 = cljs.core.next(seq3868__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3869,G__3870,seq3868__$2);
}));

(cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = (2));

cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply = (function cljs$core$unchecked_multiply(var_args){
var G__3880 = arguments.length;
switch (G__3880) {
case 0:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3882 = arguments.length;
var i__4772__auto___3883 = (0);
while(true){
if((i__4772__auto___3883 < len__4771__auto___3882)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3883]));

var G__3884 = (i__4772__auto___3883 + (1));
i__4772__auto___3883 = G__3884;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
}));

(cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,(x * y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_multiply.cljs$lang$applyTo = (function (seq3877){
var G__3878 = cljs.core.first(seq3877);
var seq3877__$1 = cljs.core.next(seq3877);
var G__3879 = cljs.core.first(seq3877__$1);
var seq3877__$2 = cljs.core.next(seq3877__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3878,G__3879,seq3877__$2);
}));

(cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = (2));

/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply_int = (function cljs$core$unchecked_multiply_int(var_args){
var G__3889 = arguments.length;
switch (G__3889) {
case 0:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3891 = arguments.length;
var i__4772__auto___3892 = (0);
while(true){
if((i__4772__auto___3892 < len__4771__auto___3891)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3892]));

var G__3893 = (i__4772__auto___3892 + (1));
i__4772__auto___3892 = G__3893;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
}));

(cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,(x * y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_multiply_int.cljs$lang$applyTo = (function (seq3886){
var G__3887 = cljs.core.first(seq3886);
var seq3886__$1 = cljs.core.next(seq3886);
var G__3888 = cljs.core.first(seq3886__$1);
var seq3886__$2 = cljs.core.next(seq3886__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3887,G__3888,seq3886__$2);
}));

(cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = (2));

cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
return cljs.core.mod(x,n);
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract = (function cljs$core$unchecked_subtract(var_args){
var G__3898 = arguments.length;
switch (G__3898) {
case 1:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3900 = arguments.length;
var i__4772__auto___3901 = (0);
while(true){
if((i__4772__auto___3901 < len__4771__auto___3900)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3901]));

var G__3902 = (i__4772__auto___3901 + (1));
i__4772__auto___3901 = G__3902;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
}));

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
}));

(cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,(x - y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_subtract.cljs$lang$applyTo = (function (seq3895){
var G__3896 = cljs.core.first(seq3895);
var seq3895__$1 = cljs.core.next(seq3895);
var G__3897 = cljs.core.first(seq3895__$1);
var seq3895__$2 = cljs.core.next(seq3895__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3896,G__3897,seq3895__$2);
}));

(cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = (2));

/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract_int = (function cljs$core$unchecked_subtract_int(var_args){
var G__3907 = arguments.length;
switch (G__3907) {
case 1:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3909 = arguments.length;
var i__4772__auto___3910 = (0);
while(true){
if((i__4772__auto___3910 < len__4771__auto___3909)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3910]));

var G__3911 = (i__4772__auto___3910 + (1));
i__4772__auto___3910 = G__3911;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
}));

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
}));

(cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,(x - y),more);
}));

/** @this {Function} */
(cljs.core.unchecked_subtract_int.cljs$lang$applyTo = (function (seq3904){
var G__3905 = cljs.core.first(seq3904);
var seq3904__$1 = cljs.core.next(seq3904);
var G__3906 = cljs.core.first(seq3904__$1);
var seq3904__$2 = cljs.core.next(seq3904__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3905,G__3906,seq3904__$2);
}));

(cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = (2));

cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
return Math.floor(q);
} else {
return Math.ceil(q);
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 */
cljs.core.bit_xor = (function cljs$core$bit_xor(var_args){
var G__3916 = arguments.length;
switch (G__3916) {
case 2:
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3918 = arguments.length;
var i__4772__auto___3919 = (0);
while(true){
if((i__4772__auto___3919 < len__4771__auto___3918)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3919]));

var G__3920 = (i__4772__auto___3919 + (1));
i__4772__auto___3919 = G__3920;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x ^ y);
}));

(cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,(x ^ y),more);
}));

/** @this {Function} */
(cljs.core.bit_xor.cljs$lang$applyTo = (function (seq3913){
var G__3914 = cljs.core.first(seq3913);
var seq3913__$1 = cljs.core.next(seq3913);
var G__3915 = cljs.core.first(seq3913__$1);
var seq3913__$2 = cljs.core.next(seq3913__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3914,G__3915,seq3913__$2);
}));

(cljs.core.bit_xor.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise and
 */
cljs.core.bit_and = (function cljs$core$bit_and(var_args){
var G__3925 = arguments.length;
switch (G__3925) {
case 2:
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3927 = arguments.length;
var i__4772__auto___3928 = (0);
while(true){
if((i__4772__auto___3928 < len__4771__auto___3927)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3928]));

var G__3929 = (i__4772__auto___3928 + (1));
i__4772__auto___3928 = G__3929;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & y);
}));

(cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,(x & y),more);
}));

/** @this {Function} */
(cljs.core.bit_and.cljs$lang$applyTo = (function (seq3922){
var G__3923 = cljs.core.first(seq3922);
var seq3922__$1 = cljs.core.next(seq3922);
var G__3924 = cljs.core.first(seq3922__$1);
var seq3922__$2 = cljs.core.next(seq3922__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3923,G__3924,seq3922__$2);
}));

(cljs.core.bit_and.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise or
 */
cljs.core.bit_or = (function cljs$core$bit_or(var_args){
var G__3934 = arguments.length;
switch (G__3934) {
case 2:
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3936 = arguments.length;
var i__4772__auto___3937 = (0);
while(true){
if((i__4772__auto___3937 < len__4771__auto___3936)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3937]));

var G__3938 = (i__4772__auto___3937 + (1));
i__4772__auto___3937 = G__3938;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x | y);
}));

(cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,(x | y),more);
}));

/** @this {Function} */
(cljs.core.bit_or.cljs$lang$applyTo = (function (seq3931){
var G__3932 = cljs.core.first(seq3931);
var seq3931__$1 = cljs.core.next(seq3931);
var G__3933 = cljs.core.first(seq3931__$1);
var seq3931__$2 = cljs.core.next(seq3931__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3932,G__3933,seq3931__$2);
}));

(cljs.core.bit_or.cljs$lang$maxFixedArity = (2));

/**
 * Bitwise and with complement
 */
cljs.core.bit_and_not = (function cljs$core$bit_and_not(var_args){
var G__3943 = arguments.length;
switch (G__3943) {
case 2:
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3945 = arguments.length;
var i__4772__auto___3946 = (0);
while(true){
if((i__4772__auto___3946 < len__4771__auto___3945)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3946]));

var G__3947 = (i__4772__auto___3946 + (1));
i__4772__auto___3946 = G__3947;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & ~y);
}));

(cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,(x & ~y),more);
}));

/** @this {Function} */
(cljs.core.bit_and_not.cljs$lang$applyTo = (function (seq3940){
var G__3941 = cljs.core.first(seq3940);
var seq3940__$1 = cljs.core.next(seq3940);
var G__3942 = cljs.core.first(seq3940__$1);
var seq3940__$2 = cljs.core.next(seq3940__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3941,G__3942,seq3940__$2);
}));

(cljs.core.bit_and_not.cljs$lang$maxFixedArity = (2));

/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 *   value, otherwise false. Behavior on non nums is
 *   undefined.
 */
cljs.core._EQ__EQ_ = (function cljs$core$_EQ__EQ_(var_args){
var G__3952 = arguments.length;
switch (G__3952) {
case 1:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3954 = arguments.length;
var i__4772__auto___3955 = (0);
while(true){
if((i__4772__auto___3955 < len__4771__auto___3954)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3955]));

var G__3956 = (i__4772__auto___3955 + (1));
i__4772__auto___3955 = G__3956;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
}));

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return cljs.core._equiv(x,y);
}));

(cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x === y)){
if(cljs.core.next(more)){
var G__3957 = y;
var G__3958 = cljs.core.first(more);
var G__3959 = cljs.core.next(more);
x = G__3957;
y = G__3958;
more = G__3959;
continue;
} else {
return (y === cljs.core.first(more));
}
} else {
return false;
}
break;
}
}));

/** @this {Function} */
(cljs.core._EQ__EQ_.cljs$lang$applyTo = (function (seq3949){
var G__3950 = cljs.core.first(seq3949);
var seq3949__$1 = cljs.core.next(seq3949);
var G__3951 = cljs.core.first(seq3949__$1);
var seq3949__$2 = cljs.core.next(seq3949__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3950,G__3951,seq3949__$2);
}));

(cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(x){
return (x > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(x){
return (x === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if(((xs) && ((n__$1 > (0))))){
var G__3960 = (n__$1 - (1));
var G__3961 = cljs.core.next(xs);
n__$1 = G__3960;
xs = G__3961;
continue;
} else {
return xs;
}
break;
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 *   x.toString().  (str nil) returns the empty string. With more than
 *   one arg, returns the concatenation of the str values of the args.
 */
cljs.core.str = (function cljs$core$str(var_args){
var G__3965 = arguments.length;
switch (G__3965) {
case 0:
return cljs.core.str.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___3967 = arguments.length;
var i__4772__auto___3968 = (0);
while(true){
if((i__4772__auto___3968 < len__4771__auto___3967)){
args_arr__4792__auto__.push((arguments[i__4772__auto___3968]));

var G__3969 = (i__4772__auto___3968 + (1));
i__4772__auto___3968 = G__3969;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((1)),(0),null));
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4793__auto__);

}
});

(cljs.core.str.cljs$core$IFn$_invoke$arity$0 = (function (){
return "";
}));

(cljs.core.str.cljs$core$IFn$_invoke$arity$1 = (function (x){
if((x == null)){
return "";
} else {
return [x].join("");
}
}));

(cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = (function (x,ys){
var sb = (new goog.string.StringBuffer(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__3970 = sb.append(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more)));
var G__3971 = cljs.core.next(more);
sb = G__3970;
more = G__3971;
continue;
} else {
return sb.toString();
}
break;
}
}));

/** @this {Function} */
(cljs.core.str.cljs$lang$applyTo = (function (seq3963){
var G__3964 = cljs.core.first(seq3963);
var seq3963__$1 = cljs.core.next(seq3963);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3964,seq3963__$1);
}));

(cljs.core.str.cljs$lang$maxFixedArity = (1));

/**
 * Returns the substring of s beginning at start inclusive, and ending
 *   at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function cljs$core$subs(var_args){
var G__3973 = arguments.length;
switch (G__3973) {
case 2:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = (function (s,start){
return s.substring(start);
}));

(cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = (function (s,start,end){
return s.substring(start,end);
}));

(cljs.core.subs.cljs$lang$maxFixedArity = 3);


/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 *   returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?((((cljs.core.counted_QMARK_(x)) && (cljs.core.counted_QMARK_(y)) && ((!((cljs.core.count(x) === cljs.core.count(y)))))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__3975 = cljs.core.next(xs);
var G__3976 = cljs.core.next(ys);
xs = G__3975;
ys = G__3976;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__3977 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__3978 = cljs.core.next(s);
res = G__3977;
s = G__3978;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__3979 = ((h + (cljs.core.hash(cljs.core.key(e)) ^ cljs.core.hash(cljs.core.val(e)))) % (4503599627370496));
var G__3980 = cljs.core.next(s);
h = G__3979;
s = G__3980;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__3981 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__3982 = cljs.core.next(s__$1);
h = G__3981;
s__$1 = G__3982;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 *   attaches said functions as methods on the object.  Any references to
 *   JavaScript's implicit this (via the this-as macro) will resolve to the
 *   object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__3983_3999 = cljs.core.seq(fn_map);
var chunk__3984_4000 = null;
var count__3985_4001 = (0);
var i__3986_4002 = (0);
while(true){
if((i__3986_4002 < count__3985_4001)){
var vec__3993_4003 = chunk__3984_4000.cljs$core$IIndexed$_nth$arity$2(null,i__3986_4002);
var key_name_4004 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3993_4003,(0),null);
var f_4005 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3993_4003,(1),null);
var str_name_4006 = cljs.core.name(key_name_4004);
goog.object.set(obj,str_name_4006,f_4005);


var G__4007 = seq__3983_3999;
var G__4008 = chunk__3984_4000;
var G__4009 = count__3985_4001;
var G__4010 = (i__3986_4002 + (1));
seq__3983_3999 = G__4007;
chunk__3984_4000 = G__4008;
count__3985_4001 = G__4009;
i__3986_4002 = G__4010;
continue;
} else {
var temp__5753__auto___4011 = cljs.core.seq(seq__3983_3999);
if(temp__5753__auto___4011){
var seq__3983_4012__$1 = temp__5753__auto___4011;
if(cljs.core.chunked_seq_QMARK_(seq__3983_4012__$1)){
var c__4591__auto___4013 = cljs.core.chunk_first(seq__3983_4012__$1);
var G__4014 = cljs.core.chunk_rest(seq__3983_4012__$1);
var G__4015 = c__4591__auto___4013;
var G__4016 = cljs.core.count(c__4591__auto___4013);
var G__4017 = (0);
seq__3983_3999 = G__4014;
chunk__3984_4000 = G__4015;
count__3985_4001 = G__4016;
i__3986_4002 = G__4017;
continue;
} else {
var vec__3996_4018 = cljs.core.first(seq__3983_4012__$1);
var key_name_4019 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3996_4018,(0),null);
var f_4020 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__3996_4018,(1),null);
var str_name_4021 = cljs.core.name(key_name_4019);
goog.object.set(obj,str_name_4021,f_4020);


var G__4022 = cljs.core.next(seq__3983_4012__$1);
var G__4023 = null;
var G__4024 = (0);
var G__4025 = (0);
seq__3983_3999 = G__4022;
chunk__3984_4000 = G__4023;
count__3985_4001 = G__4024;
i__3986_4002 = G__4025;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.List.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.List.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.List.prototype.indexOf = (function() {
var G__4026 = null;
var G__4026__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4026__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4026 = function(x,start){
switch(arguments.length){
case 1:
return G__4026__1.call(this,x);
case 2:
return G__4026__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4026.cljs$core$IFn$_invoke$arity$1 = G__4026__1;
G__4026.cljs$core$IFn$_invoke$arity$2 = G__4026__2;
return G__4026;
})()
);

(cljs.core.List.prototype.lastIndexOf = (function() {
var G__4027 = null;
var G__4027__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var G__4027__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4027 = function(x,start){
switch(arguments.length){
case 1:
return G__4027__1.call(this,x);
case 2:
return G__4027__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4027.cljs$core$IFn$_invoke$arity$1 = G__4027__1;
G__4027.cljs$core$IFn$_invoke$arity$2 = G__4027__2;
return G__4027;
})()
);

(cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
}));

(cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
}));

(cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
}));

(cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
}));

(cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.List(new_meta,self__.first,self__.rest,self__.count,self__.__hash));
}
}));

(cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
}));

(cljs.core.List.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$first,cljs.core.cst$sym$rest,cljs.core.cst$sym$count,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.List.cljs$lang$type = true);

(cljs.core.List.cljs$lang$ctorStr = "cljs.core/List");

(cljs.core.List.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/List");
}));

/**
 * Positional factory function for cljs.core/List.
 */
cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (33554432))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IList$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
}
});
goog.object.set(cljs.core.List.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.EmptyList.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.EmptyList.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.EmptyList.prototype.indexOf = (function() {
var G__4029 = null;
var G__4029__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4029__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4029 = function(x,start){
switch(arguments.length){
case 1:
return G__4029__1.call(this,x);
case 2:
return G__4029__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4029.cljs$core$IFn$_invoke$arity$1 = G__4029__1;
G__4029.cljs$core$IFn$_invoke$arity$2 = G__4029__2;
return G__4029;
})()
);

(cljs.core.EmptyList.prototype.lastIndexOf = (function() {
var G__4030 = null;
var G__4030__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4030__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4030 = function(x,start){
switch(arguments.length){
case 1:
return G__4030__1.call(this,x);
case 2:
return G__4030__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4030.cljs$core$IFn$_invoke$arity$1 = G__4030__1;
G__4030.cljs$core$IFn$_invoke$arity$2 = G__4030__2;
return G__4030;
})()
);

(cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
}));

(cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (0);
}));

(cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
}));

(cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
}));

(cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.list_QMARK_(other)) || (cljs.core.sequential_QMARK_(other)))){
return (cljs.core.seq(other) == null);
} else {
return false;
}
}));

(cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
}));

(cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.EmptyList(new_meta));
}
}));

(cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
}));

(cljs.core.EmptyList.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta], null);
}));

(cljs.core.EmptyList.cljs$lang$type = true);

(cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList");

(cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/EmptyList");
}));

/**
 * Positional factory function for cljs.core/EmptyList.
 */
cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

(cljs.core.List.EMPTY = (new cljs.core.EmptyList(null)));
goog.object.set(cljs.core.EmptyList.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
if((!((coll == null)))){
if((((coll.cljs$lang$protocol_mask$partition0$ & (134217728))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$IReversible$)))){
return true;
} else {
if((!coll.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 *   can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(rev){
return cljs.core._rseq(rev);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
var or__4160__auto__ = cljs.core.rseq(coll);
if(or__4160__auto__){
return or__4160__auto__;
} else {
return cljs.core.List.EMPTY;
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 */
cljs.core.list = (function cljs$core$list(var_args){
var args__4777__auto__ = [];
var len__4771__auto___4033 = arguments.length;
var i__4772__auto___4034 = (0);
while(true){
if((i__4772__auto___4034 < len__4771__auto___4033)){
args__4777__auto__.push((arguments[i__4772__auto___4034]));

var G__4035 = (i__4772__auto___4034 + (1));
i__4772__auto___4034 = G__4035;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var arr = (((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0)))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if((!((xs__$1 == null)))){
arr.push(cljs.core._first(xs__$1));

var G__4036 = cljs.core._next(xs__$1);
xs__$1 = G__4036;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__4037 = (i - (1));
var G__4038 = cljs.core._conj(r,(arr[(i - (1))]));
i = G__4037;
r = G__4038;
continue;
} else {
return r;
}
break;
}
}));

(cljs.core.list.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.list.cljs$lang$applyTo = (function (seq4032){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq4032));
}));


/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.Cons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Cons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Cons.prototype.indexOf = (function() {
var G__4039 = null;
var G__4039__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4039__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4039 = function(x,start){
switch(arguments.length){
case 1:
return G__4039__1.call(this,x);
case 2:
return G__4039__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4039.cljs$core$IFn$_invoke$arity$1 = G__4039__1;
G__4039.cljs$core$IFn$_invoke$arity$2 = G__4039__2;
return G__4039;
})()
);

(cljs.core.Cons.prototype.lastIndexOf = (function() {
var G__4040 = null;
var G__4040__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4040__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4040 = function(x,start){
switch(arguments.length){
case 1:
return G__4040__1.call(this,x);
case 2:
return G__4040__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4040.cljs$core$IFn$_invoke$arity$1 = G__4040__1;
G__4040.cljs$core$IFn$_invoke$arity$2 = G__4040__2;
return G__4040;
})()
);

(cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
}));

(cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
}));

(cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
}));

(cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
}));

(cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cons(new_meta,self__.first,self__.rest,self__.__hash));
}
}));

(cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,null));
}));

(cljs.core.Cons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$first,cljs.core.cst$sym$rest,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.Cons.cljs$lang$type = true);

(cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons");

(cljs.core.Cons.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/Cons");
}));

/**
 * Positional factory function for cljs.core/Cons.
 */
cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

goog.object.set(cljs.core.Cons.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));
/**
 * Returns a new seq where x is the first element and coll is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((coll == null)){
return (new cljs.core.List(null,x,null,(1),null));
} else {
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$ISeq$))))?true:false):false)){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));

}
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_(((cljs.core.not(a.ns))?b.ns:false))){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__4042 = a.ns;
var G__4043 = b.ns;
return goog.array.defaultCompare(G__4042,G__4043);
})();
if(((0) === nsc)){
var G__4044 = a.name;
var G__4045 = b.name;
return goog.array.defaultCompare(G__4044,G__4045);
} else {
return nsc;
}
}
} else {
var G__4046 = a.name;
var G__4047 = b.name;
return goog.array.defaultCompare(G__4046,G__4047);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IPrintWithWriter}
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
});
(cljs.core.Keyword.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join('');
}));

(cljs.core.Keyword.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
}));

(cljs.core.Keyword.prototype.call = (function() {
var G__4049 = null;
var G__4049__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var G__4049__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
G__4049 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__4049__2.call(this,self__,coll);
case 3:
return G__4049__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4049.cljs$core$IFn$_invoke$arity$2 = G__4049__2;
G__4049.cljs$core$IFn$_invoke$arity$3 = G__4049__3;
return G__4049;
})()
);

(cljs.core.Keyword.prototype.apply = (function (self__,args4048){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4048)));
}));

(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
}));

(cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
}));

(cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4273__auto__ = self__._hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_keyword(this$__$1);
(self__._hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
}));

(cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
}));

(cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.fqn)].join(''));
}));

(cljs.core.Keyword.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name,cljs.core.cst$sym$fqn,cljs.core.with_meta(cljs.core.cst$sym$_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.Keyword.cljs$lang$type = true);

(cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword");

(cljs.core.Keyword.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/Keyword");
}));

/**
 * Positional factory function for cljs.core/Keyword.
 */
cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword)))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Efficient test to determine that two symbols are identical.
 */
cljs.core.symbol_identical_QMARK_ = (function cljs$core$symbol_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if((((x instanceof cljs.core.Symbol)) && ((y instanceof cljs.core.Symbol)))){
return (x.str === y.str);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$))))?true:false):false)){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error(["Doesn't support namespace: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('')));
}
});
/**
 * Return true if x is a symbol or keyword
 */
cljs.core.ident_QMARK_ = (function cljs$core$ident_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) || ((x instanceof cljs.core.Symbol)));
});
/**
 * Return true if x is a symbol or keyword without a namespace
 */
cljs.core.simple_ident_QMARK_ = (function cljs$core$simple_ident_QMARK_(x){
return ((cljs.core.ident_QMARK_(x)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a symbol or keyword with a namespace
 */
cljs.core.qualified_ident_QMARK_ = (function cljs$core$qualified_ident_QMARK_(x){
return cljs.core.boolean$(((cljs.core.ident_QMARK_(x))?(function (){var and__4149__auto__ = cljs.core.namespace(x);
if(cljs.core.truth_(and__4149__auto__)){
return true;
} else {
return and__4149__auto__;
}
})():false));
});
/**
 * Return true if x is a symbol without a namespace
 */
cljs.core.simple_symbol_QMARK_ = (function cljs$core$simple_symbol_QMARK_(x){
return (((x instanceof cljs.core.Symbol)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a symbol with a namespace
 */
cljs.core.qualified_symbol_QMARK_ = (function cljs$core$qualified_symbol_QMARK_(x){
return cljs.core.boolean$((((x instanceof cljs.core.Symbol))?(function (){var and__4149__auto__ = cljs.core.namespace(x);
if(cljs.core.truth_(and__4149__auto__)){
return true;
} else {
return and__4149__auto__;
}
})():false));
});
/**
 * Return true if x is a keyword without a namespace
 */
cljs.core.simple_keyword_QMARK_ = (function cljs$core$simple_keyword_QMARK_(x){
return (((x instanceof cljs.core.Keyword)) && ((cljs.core.namespace(x) == null)));
});
/**
 * Return true if x is a keyword with a namespace
 */
cljs.core.qualified_keyword_QMARK_ = (function cljs$core$qualified_keyword_QMARK_(x){
return cljs.core.boolean$((((x instanceof cljs.core.Keyword))?(function (){var and__4149__auto__ = cljs.core.namespace(x);
if(cljs.core.truth_(and__4149__auto__)){
return true;
} else {
return and__4149__auto__;
}
})():false));
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 *   in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function cljs$core$keyword(var_args){
var G__4052 = arguments.length;
switch (G__4052) {
case 1:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),cljs.core.name(name),name.str,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("/",name)){
return (new cljs.core.Keyword(null,name,name,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
}
}));

(cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var ns__$1 = (((ns instanceof cljs.core.Keyword))?cljs.core.name(ns):(((ns instanceof cljs.core.Symbol))?cljs.core.name(ns):ns
));
var name__$1 = (((name instanceof cljs.core.Keyword))?cljs.core.name(name):(((name instanceof cljs.core.Symbol))?cljs.core.name(name):name
));
return (new cljs.core.Keyword(ns__$1,name__$1,[(cljs.core.truth_(ns__$1)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns__$1),"/"].join(''):null),cljs.core.str.cljs$core$IFn$_invoke$arity$1(name__$1)].join(''),null));
}));

(cljs.core.keyword.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.LazySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.LazySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.LazySeq.prototype.sval = (function (){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
(self__.s = (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null)));

(self__.fn = null);

return self__.s;
}
}));

(cljs.core.LazySeq.prototype.indexOf = (function() {
var G__4054 = null;
var G__4054__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4054__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4054 = function(x,start){
switch(arguments.length){
case 1:
return G__4054__1.call(this,x);
case 2:
return G__4054__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4054.cljs$core$IFn$_invoke$arity$1 = G__4054__1;
G__4054.cljs$core$IFn$_invoke$arity$2 = G__4054__2;
return G__4054;
})()
);

(cljs.core.LazySeq.prototype.lastIndexOf = (function() {
var G__4055 = null;
var G__4055__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4055__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4055 = function(x,start){
switch(arguments.length){
case 1:
return G__4055__1.call(this,x);
case 2:
return G__4055__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4055.cljs$core$IFn$_invoke$arity$1 = G__4055__1;
G__4055.cljs$core$IFn$_invoke$arity$2 = G__4055__2;
return G__4055;
})()
);

(cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.not(self__.fn);
}));

(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.cljs$core$ISeqable$_seq$arity$1(null);

if((!((self__.s == null)))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__4056 = ls.sval();
ls = G__4056;
continue;
} else {
(self__.s = ls);

return cljs.core.seq(self__.s);
}
break;
}
}
}));

(cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.LazySeq(new_meta,(function (){
return coll__$1.cljs$core$ISeqable$_seq$arity$1(null);
}),null,self__.__hash));
}
}));

(cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.LazySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$fn,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.LazySeq.cljs$lang$type = true);

(cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq");

(cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/LazySeq");
}));

/**
 * Positional factory function for cljs.core/LazySeq.
 */
cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

goog.object.set(cljs.core.LazySeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ICounted}
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 2;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ChunkBuffer.prototype.add = (function (o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return (self__.end = (self__.end + (1)));
}));

(cljs.core.ChunkBuffer.prototype.chunk = (function (){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
(self__.buf = null);

return ret;
}));

(cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.end;
}));

(cljs.core.ChunkBuffer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$buf,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$end,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.ChunkBuffer.cljs$lang$type = true);

(cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer");

(cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/ChunkBuffer");
}));

/**
 * Positional factory function for cljs.core/ChunkBuffer.
 */
cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.IChunk}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 524306;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if((((i >= (0))) && ((i < (self__.end - self__.off))))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
}));

(cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
}));

(cljs.core.ArrayChunk.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off,cljs.core.cst$sym$end], null);
}));

(cljs.core.ArrayChunk.cljs$lang$type = true);

(cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk");

(cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/ArrayChunk");
}));

/**
 * Positional factory function for cljs.core/ArrayChunk.
 */
cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function cljs$core$array_chunk(var_args){
var G__4058 = arguments.length;
switch (G__4058) {
case 1:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = (function (arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
}));

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = (function (arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
}));

(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
}));

(cljs.core.array_chunk.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
});
(cljs.core.ChunkedCons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ChunkedCons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ChunkedCons.prototype.indexOf = (function() {
var G__4060 = null;
var G__4060__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4060__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4060 = function(x,start){
switch(arguments.length){
case 1:
return G__4060__1.call(this,x);
case 2:
return G__4060__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4060.cljs$core$IFn$_invoke$arity$1 = G__4060__1;
G__4060.cljs$core$IFn$_invoke$arity$2 = G__4060__2;
return G__4060;
})()
);

(cljs.core.ChunkedCons.prototype.lastIndexOf = (function() {
var G__4061 = null;
var G__4061__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4061__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4061 = function(x,start){
switch(arguments.length){
case 1:
return G__4061__1.call(this,x);
case 2:
return G__4061__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4061.cljs$core$IFn$_invoke$arity$1 = G__4061__1;
G__4061.cljs$core$IFn$_invoke$arity$2 = G__4061__2;
return G__4061;
})()
);

(cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return null;
} else {
return cljs.core._seq(self__.more);
}
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,null,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,new_meta,self__.__hash));
}
}));

(cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
}));

(cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
}));

(cljs.core.ChunkedCons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$chunk,cljs.core.cst$sym$more,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.ChunkedCons.cljs$lang$type = true);

(cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons");

(cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/ChunkedCons");
}));

/**
 * Positional factory function for cljs.core/ChunkedCons.
 */
cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

goog.object.set(cljs.core.ChunkedCons.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if((((!((s == null))))?(((((s.cljs$lang$protocol_mask$partition1$ & (1024))) || ((cljs.core.PROTOCOL_SENTINEL === s.cljs$core$IChunkedNext$))))?true:false):false)){
return s.cljs$core$IChunkedNext$_chunked_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Returns an array containing the contents of coll.
 */
cljs.core.to_array = (function cljs$core$to_array(coll){
var ary = [];
var s = cljs.core.seq(coll);
while(true){
if((!((s == null)))){
ary.push(cljs.core.first(s));

var G__4063 = cljs.core.next(s);
s = G__4063;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 *   containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_4064 = (0);
var xs_4065 = cljs.core.seq(coll);
while(true){
if((xs_4065 == null)){
} else {
(ret[i_4064] = cljs.core.to_array(cljs.core.first(xs_4065)));

var G__4066 = (i_4064 + (1));
var G__4067 = cljs.core.next(xs_4065);
i_4064 = G__4066;
xs_4065 = G__4067;
continue;
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.int_array = (function cljs$core$int_array(var_args){
var G__4069 = arguments.length;
switch (G__4069) {
case 1:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__4071 = (i + (1));
var G__4072 = cljs.core.next(s__$1);
i = G__4071;
s__$1 = G__4072;
continue;
} else {
return a;
}
break;
}
} else {
var n__4648__auto___4073 = size;
var i_4074 = (0);
while(true){
if((i_4074 < n__4648__auto___4073)){
(a[i_4074] = init_val_or_seq);

var G__4075 = (i_4074 + (1));
i_4074 = G__4075;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.int_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.long_array = (function cljs$core$long_array(var_args){
var G__4077 = arguments.length;
switch (G__4077) {
case 1:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__4079 = (i + (1));
var G__4080 = cljs.core.next(s__$1);
i = G__4079;
s__$1 = G__4080;
continue;
} else {
return a;
}
break;
}
} else {
var n__4648__auto___4081 = size;
var i_4082 = (0);
while(true){
if((i_4082 < n__4648__auto___4081)){
(a[i_4082] = init_val_or_seq);

var G__4083 = (i_4082 + (1));
i_4082 = G__4083;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.long_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.double_array = (function cljs$core$double_array(var_args){
var G__4085 = arguments.length;
switch (G__4085) {
case 1:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__4087 = (i + (1));
var G__4088 = cljs.core.next(s__$1);
i = G__4087;
s__$1 = G__4088;
continue;
} else {
return a;
}
break;
}
} else {
var n__4648__auto___4089 = size;
var i_4090 = (0);
while(true){
if((i_4090 < n__4648__auto___4089)){
(a[i_4090] = init_val_or_seq);

var G__4091 = (i_4090 + (1));
i_4090 = G__4091;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.double_array.cljs$lang$maxFixedArity = 2);

/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.object_array = (function cljs$core$object_array(var_args){
var G__4093 = arguments.length;
switch (G__4093) {
case 1:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
}));

(cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if(((s__$1) && ((i < size)))){
(a[i] = cljs.core.first(s__$1));

var G__4095 = (i + (1));
var G__4096 = cljs.core.next(s__$1);
i = G__4095;
s__$1 = G__4096;
continue;
} else {
return a;
}
break;
}
} else {
var n__4648__auto___4097 = size;
var i_4098 = (0);
while(true){
if((i_4098 < n__4648__auto___4097)){
(a[i_4098] = init_val_or_seq);

var G__4099 = (i_4098 + (1));
i_4098 = G__4099;
continue;
} else {
}
break;
}

return a;
}
}));

(cljs.core.object_array.cljs$lang$maxFixedArity = 2);

/**
 * If coll is counted? returns its count, else will count at most the first n
 * elements of coll using its seq
 */
cljs.core.bounded_count = (function cljs$core$bounded_count(n,coll){
if(cljs.core.counted_QMARK_(coll)){
return cljs.core.count(coll);
} else {
var i = (0);
var s = cljs.core.seq(coll);
while(true){
if((((!((s == null)))) && ((i < n)))){
var G__4100 = (i + (1));
var G__4101 = cljs.core.next(s);
i = G__4100;
s = G__4101;
continue;
} else {
return i;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
var n = cljs.core.next(arglist);
if((n == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),(cljs.core.spread.cljs$core$IFn$_invoke$arity$1 ? cljs.core.spread.cljs$core$IFn$_invoke$arity$1(n) : cljs.core.spread.call(null,n)));
}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 */
cljs.core.concat = (function cljs$core$concat(var_args){
var G__4106 = arguments.length;
switch (G__4106) {
case 0:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4108 = arguments.length;
var i__4772__auto___4109 = (0);
while(true){
if((i__4772__auto___4109 < len__4771__auto___4108)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4109]));

var G__4110 = (i__4772__auto___4109 + (1));
i__4772__auto___4109 = G__4110;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = (function (){
return (new cljs.core.LazySeq(null,(function (){
return null;
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return x;
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (new cljs.core.LazySeq(null,(function (){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
}));

(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,zs){
var cat = (function cljs$core$cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function (){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
}));

/** @this {Function} */
(cljs.core.concat.cljs$lang$applyTo = (function (seq4103){
var G__4104 = cljs.core.first(seq4103);
var seq4103__$1 = cljs.core.next(seq4103);
var G__4105 = cljs.core.first(seq4103__$1);
var seq4103__$2 = cljs.core.next(seq4103__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4104,G__4105,seq4103__$2);
}));

(cljs.core.concat.cljs$lang$maxFixedArity = (2));

/**
 * Creates a new list containing the items prepended to the rest, the
 *   last of which will be treated as a sequence.
 */
cljs.core.list_STAR_ = (function cljs$core$list_STAR_(var_args){
var G__4117 = arguments.length;
switch (G__4117) {
case 1:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4119 = arguments.length;
var i__4772__auto___4120 = (0);
while(true){
if((i__4772__auto___4120 < len__4771__auto___4119)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4120]));

var G__4121 = (i__4772__auto___4120 + (1));
i__4772__auto___4120 = G__4121;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((4)),(0),null));
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4793__auto__);

}
});

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (args){
return cljs.core.seq(args);
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (a,args){
return cljs.core.cons(a,args);
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
}));

(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
}));

/** @this {Function} */
(cljs.core.list_STAR_.cljs$lang$applyTo = (function (seq4112){
var G__4113 = cljs.core.first(seq4112);
var seq4112__$1 = cljs.core.next(seq4112);
var G__4114 = cljs.core.first(seq4112__$1);
var seq4112__$2 = cljs.core.next(seq4112__$1);
var G__4115 = cljs.core.first(seq4112__$2);
var seq4112__$3 = cljs.core.next(seq4112__$2);
var G__4116 = cljs.core.first(seq4112__$3);
var seq4112__$4 = cljs.core.next(seq4112__$3);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4113,G__4114,G__4115,G__4116,seq4112__$4);
}));

(cljs.core.list_STAR_.cljs$lang$maxFixedArity = (4));

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 *   constant time. The transient collection cannot be used after this
 *   call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds val to the transient collection, and return tcoll. The 'addition'
 *   may happen at different 'places' depending on the concrete type.
 */
cljs.core.conj_BANG_ = (function cljs$core$conj_BANG_(var_args){
var G__4126 = arguments.length;
switch (G__4126) {
case 0:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4128 = arguments.length;
var i__4772__auto___4129 = (0);
while(true){
if((i__4772__auto___4129 < len__4771__auto___4128)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4129]));

var G__4130 = (i__4772__auto___4129 + (1));
i__4772__auto___4129 = G__4130;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (tcoll){
return tcoll;
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
}));

(cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__4131 = ntcoll;
var G__4132 = cljs.core.first(vals);
var G__4133 = cljs.core.next(vals);
tcoll = G__4131;
val = G__4132;
vals = G__4133;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.conj_BANG_.cljs$lang$applyTo = (function (seq4123){
var G__4124 = cljs.core.first(seq4123);
var seq4123__$1 = cljs.core.next(seq4123);
var G__4125 = cljs.core.first(seq4123__$1);
var seq4123__$2 = cljs.core.next(seq4123__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4124,G__4125,seq4123__$2);
}));

(cljs.core.conj_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * When applied to a transient map, adds mapping of key(s) to
 *   val(s). When applied to a transient vector, sets the val at index.
 *   Note - index must be <= (count vector). Returns coll.
 */
cljs.core.assoc_BANG_ = (function cljs$core$assoc_BANG_(var_args){
var G__4139 = arguments.length;
switch (G__4139) {
case 3:
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4141 = arguments.length;
var i__4772__auto___4142 = (0);
while(true){
if((i__4772__auto___4142 < len__4771__auto___4141)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4142]));

var G__4143 = (i__4772__auto___4142 + (1));
i__4772__auto___4142 = G__4143;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((3)),(0),null));
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4793__auto__);

}
});

(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
}));

(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__4144 = ntcoll;
var G__4145 = cljs.core.first(kvs);
var G__4146 = cljs.core.second(kvs);
var G__4147 = cljs.core.nnext(kvs);
tcoll = G__4144;
key = G__4145;
val = G__4146;
kvs = G__4147;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.assoc_BANG_.cljs$lang$applyTo = (function (seq4135){
var G__4136 = cljs.core.first(seq4135);
var seq4135__$1 = cljs.core.next(seq4135);
var G__4137 = cljs.core.first(seq4135__$1);
var seq4135__$2 = cljs.core.next(seq4135__$1);
var G__4138 = cljs.core.first(seq4135__$2);
var seq4135__$3 = cljs.core.next(seq4135__$2);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4136,G__4137,G__4138,seq4135__$3);
}));

(cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = (3));

/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 */
cljs.core.dissoc_BANG_ = (function cljs$core$dissoc_BANG_(var_args){
var G__4152 = arguments.length;
switch (G__4152) {
case 2:
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4154 = arguments.length;
var i__4772__auto___4155 = (0);
while(true){
if((i__4772__auto___4155 < len__4771__auto___4154)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4155]));

var G__4156 = (i__4772__auto___4155 + (1));
i__4772__auto___4155 = G__4156;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
}));

(cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__4157 = ntcoll;
var G__4158 = cljs.core.first(ks);
var G__4159 = cljs.core.next(ks);
tcoll = G__4157;
key = G__4158;
ks = G__4159;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.dissoc_BANG_.cljs$lang$applyTo = (function (seq4149){
var G__4150 = cljs.core.first(seq4149);
var seq4149__$1 = cljs.core.next(seq4149);
var G__4151 = cljs.core.first(seq4149__$1);
var seq4149__$2 = cljs.core.next(seq4149__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4150,G__4151,seq4149__$2);
}));

(cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = (2));

/**
 * Removes the last item from a transient vector. If
 *   the collection is empty, throws an exception. Returns tcoll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj_BANG_ = (function cljs$core$disj_BANG_(var_args){
var G__4164 = arguments.length;
switch (G__4164) {
case 2:
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4166 = arguments.length;
var i__4772__auto___4167 = (0);
while(true){
if((i__4772__auto___4167 < len__4771__auto___4166)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4167]));

var G__4168 = (i__4772__auto___4167 + (1));
i__4772__auto___4167 = G__4168;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
}));

(cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__4169 = ntcoll;
var G__4170 = cljs.core.first(vals);
var G__4171 = cljs.core.next(vals);
tcoll = G__4169;
val = G__4170;
vals = G__4171;
continue;
} else {
return ntcoll;
}
break;
}
}));

/** @this {Function} */
(cljs.core.disj_BANG_.cljs$lang$applyTo = (function (seq4161){
var G__4162 = cljs.core.first(seq4161);
var seq4161__$1 = cljs.core.next(seq4161);
var G__4163 = cljs.core.first(seq4161__$1);
var seq4161__$2 = cljs.core.next(seq4161__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4162,G__4163,seq4161__$2);
}));

(cljs.core.disj_BANG_.cljs$lang$maxFixedArity = (2));


cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a970 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a970) : f.call(null,a970));
} else {
var b971 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a970,b971) : f.call(null,a970,b971));
} else {
var c972 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a970,b971,c972) : f.call(null,a970,b971,c972));
} else {
var d973 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a970,b971,c972,d973) : f.call(null,a970,b971,c972,d973));
} else {
var e974 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a970,b971,c972,d973,e974) : f.call(null,a970,b971,c972,d973,e974));
} else {
var f975 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a970,b971,c972,d973,e974,f975) : f.call(null,a970,b971,c972,d973,e974,f975));
} else {
var g976 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a970,b971,c972,d973,e974,f975,g976) : f.call(null,a970,b971,c972,d973,e974,f975,g976));
} else {
var h977 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a970,b971,c972,d973,e974,f975,g976,h977) : f.call(null,a970,b971,c972,d973,e974,f975,g976,h977));
} else {
var i978 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a970,b971,c972,d973,e974,f975,g976,h977,i978) : f.call(null,a970,b971,c972,d973,e974,f975,g976,h977,i978));
} else {
var j979 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a970,b971,c972,d973,e974,f975,g976,h977,i978,j979) : f.call(null,a970,b971,c972,d973,e974,f975,g976,h977,i978,j979));
} else {
var k980 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980) : f.call(null,a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980));
} else {
var l981 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980,l981) : f.call(null,a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980,l981));
} else {
var m982 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980,l981,m982) : f.call(null,a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980,l981,m982));
} else {
var n983 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980,l981,m982,n983) : f.call(null,a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980,l981,m982,n983));
} else {
var o984 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980,l981,m982,n983,o984) : f.call(null,a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980,l981,m982,n983,o984));
} else {
var p985 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980,l981,m982,n983,o984,p985) : f.call(null,a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980,l981,m982,n983,o984,p985));
} else {
var q986 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980,l981,m982,n983,o984,p985,q986) : f.call(null,a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980,l981,m982,n983,o984,p985,q986));
} else {
var r987 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980,l981,m982,n983,o984,p985,q986,r987) : f.call(null,a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980,l981,m982,n983,o984,p985,q986,r987));
} else {
var s988 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980,l981,m982,n983,o984,p985,q986,r987,s988) : f.call(null,a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980,l981,m982,n983,o984,p985,q986,r987,s988));
} else {
var t989 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980,l981,m982,n983,o984,p985,q986,r987,s988,t989) : f.call(null,a970,b971,c972,d973,e974,f975,g976,h977,i978,j979,k980,l981,m982,n983,o984,p985,q986,r987,s988,t989));
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Internal. DO NOT USE! Next without the nil? check.
 */
cljs.core.next_STAR_ = (function cljs$core$next_STAR_(coll){
if((((!((coll == null))))?(((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === coll.cljs$core$INext$))))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
});
/**
 * Internal. DO NOT USE!
 *   Assumes args was already called with seq beforehand!
 */
cljs.core.apply_to_simple = (function cljs$core$apply_to_simple(var_args){
var G__4174 = arguments.length;
switch (G__4174) {
case 2:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2 = (function (f,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$0){
return f.cljs$core$IFn$_invoke$arity$0();
} else {
return f.call(f);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3 = (function (f,a0,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a0);
} else {
return f.call(f,a0);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,a0,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4 = (function (f,a0,a1,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a0,a1);
} else {
return f.call(f,a0,a1);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,a0,a1,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5 = (function (f,a0,a1,a2,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a0,a1,a2);
} else {
return f.call(f,a0,a1,a2);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a0,a1,a2,cljs.core._first(args),cljs.core.next_STAR_(args));
}
}));

(cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6 = (function (f,a0,a1,a2,a3,args){
if((args == null)){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a0,a1,a2,a3);
} else {
return f.call(f,a0,a1,a2,a3);
}
} else {
var a4 = cljs.core._first(args);
var next_4 = cljs.core.next(args);
if((next_4 == null)){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a0,a1,a2,a3,a4);
} else {
return f.call(f,a0,a1,a2,a3,a4);
}
} else {
var a5 = cljs.core._first(next_4);
var next_5 = cljs.core.next(next_4);
if((next_5 == null)){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a0,a1,a2,a3,a4,a5);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5);
}
} else {
var a6 = cljs.core._first(next_5);
var next_6 = cljs.core.next(next_5);
if((next_6 == null)){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a0,a1,a2,a3,a4,a5,a6);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6);
}
} else {
var a7 = cljs.core._first(next_6);
var next_7 = cljs.core.next(next_6);
if((next_7 == null)){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a0,a1,a2,a3,a4,a5,a6,a7);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7);
}
} else {
var a8 = cljs.core._first(next_7);
var next_8 = cljs.core.next(next_7);
if((next_8 == null)){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a0,a1,a2,a3,a4,a5,a6,a7,a8);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8);
}
} else {
var a9 = cljs.core._first(next_8);
var next_9 = cljs.core.next(next_8);
if((next_9 == null)){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);
}
} else {
var a10 = cljs.core._first(next_9);
var next_10 = cljs.core.next(next_9);
if((next_10 == null)){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
}
} else {
var a11 = cljs.core._first(next_10);
var next_11 = cljs.core.next(next_10);
if((next_11 == null)){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
}
} else {
var a12 = cljs.core._first(next_11);
var next_12 = cljs.core.next(next_11);
if((next_12 == null)){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
}
} else {
var a13 = cljs.core._first(next_12);
var next_13 = cljs.core.next(next_12);
if((next_13 == null)){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
}
} else {
var a14 = cljs.core._first(next_13);
var next_14 = cljs.core.next(next_13);
if((next_14 == null)){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14);
}
} else {
var a15 = cljs.core._first(next_14);
var next_15 = cljs.core.next(next_14);
if((next_15 == null)){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15);
}
} else {
var a16 = cljs.core._first(next_15);
var next_16 = cljs.core.next(next_15);
if((next_16 == null)){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16);
}
} else {
var a17 = cljs.core._first(next_16);
var next_17 = cljs.core.next(next_16);
if((next_17 == null)){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17);
}
} else {
var a18 = cljs.core._first(next_17);
var next_18 = cljs.core.next(next_17);
if((next_18 == null)){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18);
}
} else {
var a19 = cljs.core._first(next_18);
var next_19 = cljs.core.next(next_18);
if((next_19 == null)){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
} else {
return f.call(f,a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19);
}
} else {
var arr__4696__auto__ = [a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13,a14,a15,a16,a17,a18,a19];
var s__4697__auto___4176 = next_19;
while(true){
if(s__4697__auto___4176){
arr__4696__auto__.push(cljs.core._first(s__4697__auto___4176));

var G__4177 = cljs.core.next(s__4697__auto___4176);
s__4697__auto___4176 = G__4177;
continue;
} else {
}
break;
}

return f.apply(f,arr__4696__auto__);
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(cljs.core.apply_to_simple.cljs$lang$maxFixedArity = 6);

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 */
cljs.core.apply = (function cljs$core$apply(var_args){
var G__4185 = arguments.length;
switch (G__4185) {
case 2:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4187 = arguments.length;
var i__4772__auto___4188 = (0);
while(true){
if((i__4772__auto___4188 < len__4771__auto___4187)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4188]));

var G__4189 = (i__4772__auto___4188 + (1));
i__4772__auto___4188 = G__4189;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((5)),(0),null));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4793__auto__);

}
});

(cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = (function (f,args){
if(f.cljs$lang$applyTo){
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = cljs.core.bounded_count((fixed_arity + (1)),args);
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = (function (f,x,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = (cljs.core.bounded_count(fixed_arity,args) + (1));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$3(f,x,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((2) + cljs.core.bounded_count((fixed_arity - (1)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$4(f,x,y,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = (function (f,x,y,z,args){
if(f.cljs$lang$applyTo){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((3) + cljs.core.bounded_count((fixed_arity - (2)),args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$5(f,x,y,z,cljs.core.seq(args));
}
}));

(cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = (function (f,a,b,c,d,args){
if(f.cljs$lang$applyTo){
var spread_args = cljs.core.spread(args);
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,spread_args))));
var fixed_arity = f.cljs$lang$maxFixedArity;
var bc = ((4) + cljs.core.bounded_count((fixed_arity - (3)),spread_args));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return cljs.core.apply_to_simple.cljs$core$IFn$_invoke$arity$6(f,a,b,c,d,cljs.core.spread(args));
}
}));

/** @this {Function} */
(cljs.core.apply.cljs$lang$applyTo = (function (seq4179){
var G__4180 = cljs.core.first(seq4179);
var seq4179__$1 = cljs.core.next(seq4179);
var G__4181 = cljs.core.first(seq4179__$1);
var seq4179__$2 = cljs.core.next(seq4179__$1);
var G__4182 = cljs.core.first(seq4179__$2);
var seq4179__$3 = cljs.core.next(seq4179__$2);
var G__4183 = cljs.core.first(seq4179__$3);
var seq4179__$4 = cljs.core.next(seq4179__$3);
var G__4184 = cljs.core.first(seq4179__$4);
var seq4179__$5 = cljs.core.next(seq4179__$4);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4180,G__4181,G__4182,G__4183,G__4184,seq4179__$5);
}));

(cljs.core.apply.cljs$lang$maxFixedArity = (5));

cljs.core.__destructure_map = (function cljs$core$__destructure_map(x){
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$ISeq$))))?true:false):false)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,x);
} else {
return x;
}
});
/**
 * Returns an object of the same type and value as obj, with
 *   (apply f (meta obj) args) as its metadata.
 */
cljs.core.vary_meta = (function cljs$core$vary_meta(var_args){
var G__4199 = arguments.length;
switch (G__4199) {
case 2:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4216 = arguments.length;
var i__4772__auto___4217 = (0);
while(true){
if((i__4772__auto___4217 < len__4771__auto___4216)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4217]));

var G__4218 = (i__4772__auto___4217 + (1));
i__4772__auto___4217 = G__4218;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((6)),(0),null));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__4793__auto__);

}
});

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = (function (obj,f){
return cljs.core.with_meta(obj,(function (){var G__4200 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4200) : f.call(null,G__4200));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = (function (obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__4201 = cljs.core.meta(obj);
var G__4202 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4201,G__4202) : f.call(null,G__4201,G__4202));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = (function (obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__4203 = cljs.core.meta(obj);
var G__4204 = a;
var G__4205 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4203,G__4204,G__4205) : f.call(null,G__4203,G__4204,G__4205));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = (function (obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__4206 = cljs.core.meta(obj);
var G__4207 = a;
var G__4208 = b;
var G__4209 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__4206,G__4207,G__4208,G__4209) : f.call(null,G__4206,G__4207,G__4208,G__4209));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = (function (obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__4210 = cljs.core.meta(obj);
var G__4211 = a;
var G__4212 = b;
var G__4213 = c;
var G__4214 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__4210,G__4211,G__4212,G__4213,G__4214) : f.call(null,G__4210,G__4211,G__4212,G__4213,G__4214));
})());
}));

(cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = (function (obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([d,args], 0)));
}));

/** @this {Function} */
(cljs.core.vary_meta.cljs$lang$applyTo = (function (seq4192){
var G__4193 = cljs.core.first(seq4192);
var seq4192__$1 = cljs.core.next(seq4192);
var G__4194 = cljs.core.first(seq4192__$1);
var seq4192__$2 = cljs.core.next(seq4192__$1);
var G__4195 = cljs.core.first(seq4192__$2);
var seq4192__$3 = cljs.core.next(seq4192__$2);
var G__4196 = cljs.core.first(seq4192__$3);
var seq4192__$4 = cljs.core.next(seq4192__$3);
var G__4197 = cljs.core.first(seq4192__$4);
var seq4192__$5 = cljs.core.next(seq4192__$4);
var G__4198 = cljs.core.first(seq4192__$5);
var seq4192__$6 = cljs.core.next(seq4192__$5);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4193,G__4194,G__4195,G__4196,G__4197,G__4198,seq4192__$6);
}));

(cljs.core.vary_meta.cljs$lang$maxFixedArity = (6));

/**
 * Same as (not (= obj1 obj2))
 */
cljs.core.not_EQ_ = (function cljs$core$not_EQ_(var_args){
var G__4223 = arguments.length;
switch (G__4223) {
case 1:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4225 = arguments.length;
var i__4772__auto___4226 = (0);
while(true){
if((i__4772__auto___4226 < len__4771__auto___4225)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4226]));

var G__4227 = (i__4772__auto___4226 + (1));
i__4772__auto___4226 = G__4227;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return false;
}));

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)));
}));

(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
}));

/** @this {Function} */
(cljs.core.not_EQ_.cljs$lang$applyTo = (function (seq4220){
var G__4221 = cljs.core.first(seq4220);
var seq4220__$1 = cljs.core.next(seq4220);
var G__4222 = cljs.core.first(seq4220__$1);
var seq4220__$2 = cljs.core.next(seq4220__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4221,G__4222,seq4220__$2);
}));

(cljs.core.not_EQ_.cljs$lang$maxFixedArity = (2));

/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function cljs$core$nil_iter(){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.t_cljs$core4228 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.t_cljs$core4228 = (function (meta4229){
this.meta4229 = meta4229;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.t_cljs$core4228.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_4230,meta4229__$1){
var self__ = this;
var _4230__$1 = this;
return (new cljs.core.t_cljs$core4228(meta4229__$1));
}));

(cljs.core.t_cljs$core4228.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_4230){
var self__ = this;
var _4230__$1 = this;
return self__.meta4229;
}));

(cljs.core.t_cljs$core4228.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return false;
}));

(cljs.core.t_cljs$core4228.prototype.next = (function (){
var self__ = this;
var _ = this;
return (new Error("No such element"));
}));

(cljs.core.t_cljs$core4228.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.t_cljs$core4228.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta4229], null);
}));

(cljs.core.t_cljs$core4228.cljs$lang$type = true);

(cljs.core.t_cljs$core4228.cljs$lang$ctorStr = "cljs.core/t_cljs$core4228");

(cljs.core.t_cljs$core4228.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/t_cljs$core4228");
}));

/**
 * Positional factory function for cljs.core/t_cljs$core4228.
 */
cljs.core.__GT_t_cljs$core4228 = (function cljs$core$nil_iter_$___GT_t_cljs$core4228(meta4229){
return (new cljs.core.t_cljs$core4228(meta4229));
});

}

return (new cljs.core.t_cljs$core4228(cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
});
(cljs.core.StringIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
}));

(cljs.core.StringIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.StringIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.StringIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.StringIter.cljs$lang$type = true);

(cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter");

(cljs.core.StringIter.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/StringIter");
}));

/**
 * Positional factory function for cljs.core/StringIter.
 */
cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
});
(cljs.core.ArrayIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
}));

(cljs.core.ArrayIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.ArrayIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.ArrayIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.ArrayIter.cljs$lang$type = true);

(cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter");

(cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/ArrayIter");
}));

/**
 * Positional factory function for cljs.core/ArrayIter.
 */
cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = ({});
cljs.core.START = ({});

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
});
(cljs.core.SeqIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
(self__._seq = cljs.core.START);

(self__._next = cljs.core.seq(self__._next));
} else {
if((self__._seq === self__._next)){
(self__._next = cljs.core.next(self__._seq));
} else {
}
}

return (!((self__._next == null)));
}));

(cljs.core.SeqIter.prototype.next = (function (){
var self__ = this;
var this$ = this;
if((!(this$.hasNext()))){
throw (new Error("No such element"));
} else {
(self__._seq = self__._next);

return cljs.core.first(self__._next);
}
}));

(cljs.core.SeqIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.SeqIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$_seq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.SeqIter.cljs$lang$type = true);

(cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter");

(cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/SeqIter");
}));

/**
 * Positional factory function for cljs.core/SeqIter.
 */
cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core._iterator(coll);
} else {
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error(["Cannot create iterator from ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll)].join('')));

}
}
}
}
}
});

/**
* @constructor
*/
cljs.core.Many = (function (vals){
this.vals = vals;
});
(cljs.core.Many.prototype.add = (function (o){
var self__ = this;
var this$ = this;
self__.vals.push(o);

return this$;
}));

(cljs.core.Many.prototype.remove = (function (){
var self__ = this;
var this$ = this;
return self__.vals.shift();
}));

(cljs.core.Many.prototype.isEmpty = (function (){
var self__ = this;
var this$ = this;
return (self__.vals.length === (0));
}));

(cljs.core.Many.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return ["Many: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.vals)].join('');
}));

(cljs.core.Many.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vals], null);
}));

(cljs.core.Many.cljs$lang$type = true);

(cljs.core.Many.cljs$lang$ctorStr = "cljs.core/Many");

(cljs.core.Many.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/Many");
}));

/**
 * Positional factory function for cljs.core/Many.
 */
cljs.core.__GT_Many = (function cljs$core$__GT_Many(vals){
return (new cljs.core.Many(vals));
});

cljs.core.NONE = ({});

/**
* @constructor
*/
cljs.core.Single = (function (val){
this.val = val;
});
(cljs.core.Single.prototype.add = (function (o){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
(self__.val = o);

return this$;
} else {
return (new cljs.core.Many([self__.val,o]));
}
}));

(cljs.core.Single.prototype.remove = (function (){
var self__ = this;
var this$ = this;
if((self__.val === cljs.core.NONE)){
throw (new Error("Removing object from empty buffer"));
} else {
var ret = self__.val;
(self__.val = cljs.core.NONE);

return ret;
}
}));

(cljs.core.Single.prototype.isEmpty = (function (){
var self__ = this;
var this$ = this;
return (self__.val === cljs.core.NONE);
}));

(cljs.core.Single.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return ["Single: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.val)].join('');
}));

(cljs.core.Single.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.Single.cljs$lang$type = true);

(cljs.core.Single.cljs$lang$ctorStr = "cljs.core/Single");

(cljs.core.Single.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/Single");
}));

/**
 * Positional factory function for cljs.core/Single.
 */
cljs.core.__GT_Single = (function cljs$core$__GT_Single(val){
return (new cljs.core.Single(val));
});


/**
* @constructor
*/
cljs.core.Empty = (function (){
});
(cljs.core.Empty.prototype.add = (function (o){
var self__ = this;
var this$ = this;
return (new cljs.core.Single(o));
}));

(cljs.core.Empty.prototype.remove = (function (){
var self__ = this;
var this$ = this;
throw (new Error("Removing object from empty buffer"));
}));

(cljs.core.Empty.prototype.isEmpty = (function (){
var self__ = this;
var this$ = this;
return true;
}));

(cljs.core.Empty.prototype.toString = (function (){
var self__ = this;
var this$ = this;
return "Empty";
}));

(cljs.core.Empty.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.Empty.cljs$lang$type = true);

(cljs.core.Empty.cljs$lang$ctorStr = "cljs.core/Empty");

(cljs.core.Empty.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/Empty");
}));

/**
 * Positional factory function for cljs.core/Empty.
 */
cljs.core.__GT_Empty = (function cljs$core$__GT_Empty(){
return (new cljs.core.Empty());
});

cljs.core.EMPTY = (new cljs.core.Empty());

/**
* @constructor
*/
cljs.core.MultiIterator = (function (iters){
this.iters = iters;
});
(cljs.core.MultiIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if((!((iters__$1 == null)))){
var iter = cljs.core.first(iters__$1);
if((!(iter.hasNext()))){
return false;
} else {
var G__4231 = cljs.core.next(iters__$1);
iters__$1 = G__4231;
continue;
}
} else {
return true;
}
break;
}
}));

(cljs.core.MultiIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var nexts = [];
var n__4648__auto___4232 = self__.iters.length;
var i_4233 = (0);
while(true){
if((i_4233 < n__4648__auto___4232)){
(nexts[i_4233] = (self__.iters[i_4233]).next());

var G__4234 = (i_4233 + (1));
i_4233 = G__4234;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(nexts,(0));
}));

(cljs.core.MultiIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iters], null);
}));

(cljs.core.MultiIterator.cljs$lang$type = true);

(cljs.core.MultiIterator.cljs$lang$ctorStr = "cljs.core/MultiIterator");

(cljs.core.MultiIterator.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/MultiIterator");
}));

/**
 * Positional factory function for cljs.core/MultiIterator.
 */
cljs.core.__GT_MultiIterator = (function cljs$core$__GT_MultiIterator(iters){
return (new cljs.core.MultiIterator(iters));
});

cljs.core.chunkIteratorSeq = (function cljs$core$chunkIteratorSeq(iter){
return (new cljs.core.LazySeq(null,(function (){
if(iter.hasNext()){
var arr = [];
var n = (0);
while(true){
if(cljs.core.truth_((function (){var and__4149__auto__ = iter.hasNext();
if(cljs.core.truth_(and__4149__auto__)){
return (n < (32));
} else {
return and__4149__auto__;
}
})())){
(arr[n] = iter.next());

var G__4235 = (n + (1));
n = G__4235;
continue;
} else {
return cljs.core.chunk_cons(cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3(arr,(0),n),(cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunkIteratorSeq.cljs$core$IFn$_invoke$arity$1(iter) : cljs.core.chunkIteratorSeq.call(null,iter)));
}
break;
}
} else {
return null;
}
}),null,null));
});

/**
* @constructor
*/
cljs.core.TransformerIterator = (function (buffer,_next,completed,xf,sourceIter,multi){
this.buffer = buffer;
this._next = _next;
this.completed = completed;
this.xf = xf;
this.sourceIter = sourceIter;
this.multi = multi;
});
(cljs.core.TransformerIterator.prototype.step = (function (){
var self__ = this;
var this$ = this;
if((!((self__._next === cljs.core.NONE)))){
return true;
} else {
while(true){
if((self__._next === cljs.core.NONE)){
if(self__.buffer.isEmpty()){
if(self__.completed){
return false;
} else {
if(self__.sourceIter.hasNext()){
var iter = ((self__.multi)?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xf,cljs.core.cons(null,self__.sourceIter.next())):(function (){var G__4236 = null;
var G__4237 = self__.sourceIter.next();
return (self__.xf.cljs$core$IFn$_invoke$arity$2 ? self__.xf.cljs$core$IFn$_invoke$arity$2(G__4236,G__4237) : self__.xf.call(null,G__4236,G__4237));
})());
if(cljs.core.reduced_QMARK_(iter)){
(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null,null));

(self__.completed = true);
} else {
}

continue;
} else {
(self__.xf.cljs$core$IFn$_invoke$arity$1 ? self__.xf.cljs$core$IFn$_invoke$arity$1(null) : self__.xf.call(null,null));

(self__.completed = true);

continue;
}
}
} else {
(self__._next = self__.buffer.remove());

continue;
}
} else {
return true;
}
break;
}
}
}));

(cljs.core.TransformerIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return this$.step();
}));

(cljs.core.TransformerIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
var ret = self__._next;
(self__._next = cljs.core.NONE);

return ret;
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.TransformerIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.TransformerIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$buffer,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$completed,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$xf,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$sourceIter,cljs.core.cst$sym$multi], null);
}));

(cljs.core.TransformerIterator.cljs$lang$type = true);

(cljs.core.TransformerIterator.cljs$lang$ctorStr = "cljs.core/TransformerIterator");

(cljs.core.TransformerIterator.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/TransformerIterator");
}));

/**
 * Positional factory function for cljs.core/TransformerIterator.
 */
cljs.core.__GT_TransformerIterator = (function cljs$core$__GT_TransformerIterator(buffer,_next,completed,xf,sourceIter,multi){
return (new cljs.core.TransformerIterator(buffer,_next,completed,xf,sourceIter,multi));
});

goog.object.set(cljs.core.TransformerIterator.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));
cljs.core.transformer_iterator = (function cljs$core$transformer_iterator(xform,sourceIter,multi){
var iterator = (new cljs.core.TransformerIterator(cljs.core.EMPTY,cljs.core.NONE,false,null,sourceIter,multi));
(iterator.xf = (function (){var G__4238 = (function() {
var G__4239 = null;
var G__4239__0 = (function (){
return null;
});
var G__4239__1 = (function (acc){
return acc;
});
var G__4239__2 = (function (acc,o){
(iterator.buffer = iterator.buffer.add(o));

return acc;
});
G__4239 = function(acc,o){
switch(arguments.length){
case 0:
return G__4239__0.call(this);
case 1:
return G__4239__1.call(this,acc);
case 2:
return G__4239__2.call(this,acc,o);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4239.cljs$core$IFn$_invoke$arity$0 = G__4239__0;
G__4239.cljs$core$IFn$_invoke$arity$1 = G__4239__1;
G__4239.cljs$core$IFn$_invoke$arity$2 = G__4239__2;
return G__4239;
})()
;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__4238) : xform.call(null,G__4238));
})());

return iterator;
});
(cljs.core.TransformerIterator.create = (function (xform,source){
return cljs.core.transformer_iterator(xform,source,false);
}));
(cljs.core.TransformerIterator.createMulti = (function (xform,sources){
return cljs.core.transformer_iterator(xform,(new cljs.core.MultiIterator(cljs.core.to_array(sources))),true);
}));
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 *   one. Will not force a lazy seq. (sequence nil) yields (), When a
 *   transducer is supplied, returns a lazy sequence of applications of
 *   the transform to the items in coll(s), i.e. to the set of first
 *   items of each coll, followed by the set of second
 *   items in each coll, until any one of the colls is exhausted.  Any
 *   remaining items in other colls are ignored. The transform should accept
 *   number-of-colls arguments
 */
cljs.core.sequence = (function cljs$core$sequence(var_args){
var G__4244 = arguments.length;
switch (G__4244) {
case 1:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4246 = arguments.length;
var i__4772__auto___4247 = (0);
while(true){
if((i__4772__auto___4247 < len__4771__auto___4246)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4247]));

var G__4248 = (i__4772__auto___4247 + (1));
i__4772__auto___4247 = G__4248;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = (function (coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__4160__auto__ = cljs.core.seq(coll);
if(or__4160__auto__){
return or__4160__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
}));

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = (function (xform,coll){
var or__4160__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.create(xform,cljs.core.iter(coll)));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = (function (xform,coll,colls){
var or__4160__auto__ = cljs.core.chunkIteratorSeq(cljs.core.TransformerIterator.createMulti(xform,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.iter,cljs.core.cons(coll,colls))));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.List.EMPTY;
}
}));

/** @this {Function} */
(cljs.core.sequence.cljs$lang$applyTo = (function (seq4241){
var G__4242 = cljs.core.first(seq4241);
var seq4241__$1 = cljs.core.next(seq4241);
var G__4243 = cljs.core.first(seq4241__$1);
var seq4241__$2 = cljs.core.next(seq4241__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4242,G__4243,seq4241__$2);
}));

(cljs.core.sequence.cljs$lang$maxFixedArity = (2));

/**
 * Returns true if (pred x) is logical true for every x in coll, else
 *   false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__4249 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__4249) : pred.call(null,G__4249));
})())){
var G__4250 = pred;
var G__4251 = cljs.core.next(coll);
pred = G__4250;
coll = G__4251;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 *   coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return (!(cljs.core.every_QMARK_(pred,coll)));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 *   else nil.  One common idiom is to use a set as pred, for example
 *   this will return :fred if :fred is in the sequence, otherwise nil:
 *   (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
var temp__5753__auto__ = cljs.core.seq(coll);
if(temp__5753__auto__){
var s = temp__5753__auto__;
var or__4160__auto__ = (function (){var G__4253 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__4253) : pred.call(null,G__4253));
})();
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var G__4254 = pred;
var G__4255 = cljs.core.next(s);
pred = G__4254;
coll = G__4255;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 *   else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error(["Argument must be an integer: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return (!(cljs.core.even_QMARK_(n)));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 *   has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var G__4256 = null;
var G__4256__0 = (function (){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});
var G__4256__1 = (function (x){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)));
});
var G__4256__2 = (function (x,y){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)));
});
var G__4256__3 = (function() { 
var G__4257__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__4257 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__4258__i = 0, G__4258__a = new Array(arguments.length -  2);
while (G__4258__i < G__4258__a.length) {G__4258__a[G__4258__i] = arguments[G__4258__i + 2]; ++G__4258__i;}
  zs = new cljs.core.IndexedSeq(G__4258__a,0,null);
} 
return G__4257__delegate.call(this,x,y,zs);};
G__4257.cljs$lang$maxFixedArity = 2;
G__4257.cljs$lang$applyTo = (function (arglist__4259){
var x = cljs.core.first(arglist__4259);
arglist__4259 = cljs.core.next(arglist__4259);
var y = cljs.core.first(arglist__4259);
var zs = cljs.core.rest(arglist__4259);
return G__4257__delegate(x,y,zs);
});
G__4257.cljs$core$IFn$_invoke$arity$variadic = G__4257__delegate;
return G__4257;
})()
;
G__4256 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__4256__0.call(this);
case 1:
return G__4256__1.call(this,x);
case 2:
return G__4256__2.call(this,x,y);
default:
var G__4260 = null;
if (arguments.length > 2) {
var G__4261__i = 0, G__4261__a = new Array(arguments.length -  2);
while (G__4261__i < G__4261__a.length) {G__4261__a[G__4261__i] = arguments[G__4261__i + 2]; ++G__4261__i;}
G__4260 = new cljs.core.IndexedSeq(G__4261__a,0,null);
}
return G__4256__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__4260);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4256.cljs$lang$maxFixedArity = 2;
G__4256.cljs$lang$applyTo = G__4256__3.cljs$lang$applyTo;
G__4256.cljs$core$IFn$_invoke$arity$0 = G__4256__0;
G__4256.cljs$core$IFn$_invoke$arity$1 = G__4256__1;
G__4256.cljs$core$IFn$_invoke$arity$2 = G__4256__2;
G__4256.cljs$core$IFn$_invoke$arity$variadic = G__4256__3.cljs$core$IFn$_invoke$arity$variadic;
return G__4256;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var G__4262__delegate = function (args){
return x;
};
var G__4262 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__4263__i = 0, G__4263__a = new Array(arguments.length -  0);
while (G__4263__i < G__4263__a.length) {G__4263__a[G__4263__i] = arguments[G__4263__i + 0]; ++G__4263__i;}
  args = new cljs.core.IndexedSeq(G__4263__a,0,null);
} 
return G__4262__delegate.call(this,args);};
G__4262.cljs$lang$maxFixedArity = 0;
G__4262.cljs$lang$applyTo = (function (arglist__4264){
var args = cljs.core.seq(arglist__4264);
return G__4262__delegate(args);
});
G__4262.cljs$core$IFn$_invoke$arity$variadic = G__4262__delegate;
return G__4262;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 *   of those fns.  The returned fn takes a variable number of args,
 *   applies the rightmost of fns to the args, the next
 *   fn (right-to-left) to the result, etc.
 */
cljs.core.comp = (function cljs$core$comp(var_args){
var G__4270 = arguments.length;
switch (G__4270) {
case 0:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4288 = arguments.length;
var i__4772__auto___4289 = (0);
while(true){
if((i__4772__auto___4289 < len__4771__auto___4288)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4289]));

var G__4290 = (i__4772__auto___4289 + (1));
i__4772__auto___4289 = G__4290;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((3)),(0),null));
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4793__auto__);

}
});

(cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.identity;
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__4291 = null;
var G__4291__0 = (function (){
var G__4271 = (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4271) : f.call(null,G__4271));
});
var G__4291__1 = (function (x){
var G__4272 = (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4272) : f.call(null,G__4272));
});
var G__4291__2 = (function (x,y){
var G__4273 = (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4273) : f.call(null,G__4273));
});
var G__4291__3 = (function (x,y,z){
var G__4274 = (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4274) : f.call(null,G__4274));
});
var G__4291__4 = (function() { 
var G__4292__delegate = function (x,y,z,args){
var G__4275 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4275) : f.call(null,G__4275));
};
var G__4292 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4293__i = 0, G__4293__a = new Array(arguments.length -  3);
while (G__4293__i < G__4293__a.length) {G__4293__a[G__4293__i] = arguments[G__4293__i + 3]; ++G__4293__i;}
  args = new cljs.core.IndexedSeq(G__4293__a,0,null);
} 
return G__4292__delegate.call(this,x,y,z,args);};
G__4292.cljs$lang$maxFixedArity = 3;
G__4292.cljs$lang$applyTo = (function (arglist__4294){
var x = cljs.core.first(arglist__4294);
arglist__4294 = cljs.core.next(arglist__4294);
var y = cljs.core.first(arglist__4294);
arglist__4294 = cljs.core.next(arglist__4294);
var z = cljs.core.first(arglist__4294);
var args = cljs.core.rest(arglist__4294);
return G__4292__delegate(x,y,z,args);
});
G__4292.cljs$core$IFn$_invoke$arity$variadic = G__4292__delegate;
return G__4292;
})()
;
G__4291 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__4291__0.call(this);
case 1:
return G__4291__1.call(this,x);
case 2:
return G__4291__2.call(this,x,y);
case 3:
return G__4291__3.call(this,x,y,z);
default:
var G__4295 = null;
if (arguments.length > 3) {
var G__4296__i = 0, G__4296__a = new Array(arguments.length -  3);
while (G__4296__i < G__4296__a.length) {G__4296__a[G__4296__i] = arguments[G__4296__i + 3]; ++G__4296__i;}
G__4295 = new cljs.core.IndexedSeq(G__4296__a,0,null);
}
return G__4291__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4291.cljs$lang$maxFixedArity = 3;
G__4291.cljs$lang$applyTo = G__4291__4.cljs$lang$applyTo;
G__4291.cljs$core$IFn$_invoke$arity$0 = G__4291__0;
G__4291.cljs$core$IFn$_invoke$arity$1 = G__4291__1;
G__4291.cljs$core$IFn$_invoke$arity$2 = G__4291__2;
G__4291.cljs$core$IFn$_invoke$arity$3 = G__4291__3;
G__4291.cljs$core$IFn$_invoke$arity$variadic = G__4291__4.cljs$core$IFn$_invoke$arity$variadic;
return G__4291;
})()
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__4297 = null;
var G__4297__0 = (function (){
var G__4276 = (function (){var G__4277 = (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__4277) : g.call(null,G__4277));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4276) : f.call(null,G__4276));
});
var G__4297__1 = (function (x){
var G__4278 = (function (){var G__4279 = (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null,x));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__4279) : g.call(null,G__4279));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4278) : f.call(null,G__4278));
});
var G__4297__2 = (function (x,y){
var G__4280 = (function (){var G__4281 = (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null,x,y));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__4281) : g.call(null,G__4281));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4280) : f.call(null,G__4280));
});
var G__4297__3 = (function (x,y,z){
var G__4282 = (function (){var G__4283 = (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null,x,y,z));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__4283) : g.call(null,G__4283));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4282) : f.call(null,G__4282));
});
var G__4297__4 = (function() { 
var G__4298__delegate = function (x,y,z,args){
var G__4284 = (function (){var G__4285 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__4285) : g.call(null,G__4285));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4284) : f.call(null,G__4284));
};
var G__4298 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4299__i = 0, G__4299__a = new Array(arguments.length -  3);
while (G__4299__i < G__4299__a.length) {G__4299__a[G__4299__i] = arguments[G__4299__i + 3]; ++G__4299__i;}
  args = new cljs.core.IndexedSeq(G__4299__a,0,null);
} 
return G__4298__delegate.call(this,x,y,z,args);};
G__4298.cljs$lang$maxFixedArity = 3;
G__4298.cljs$lang$applyTo = (function (arglist__4300){
var x = cljs.core.first(arglist__4300);
arglist__4300 = cljs.core.next(arglist__4300);
var y = cljs.core.first(arglist__4300);
arglist__4300 = cljs.core.next(arglist__4300);
var z = cljs.core.first(arglist__4300);
var args = cljs.core.rest(arglist__4300);
return G__4298__delegate(x,y,z,args);
});
G__4298.cljs$core$IFn$_invoke$arity$variadic = G__4298__delegate;
return G__4298;
})()
;
G__4297 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__4297__0.call(this);
case 1:
return G__4297__1.call(this,x);
case 2:
return G__4297__2.call(this,x,y);
case 3:
return G__4297__3.call(this,x,y,z);
default:
var G__4301 = null;
if (arguments.length > 3) {
var G__4302__i = 0, G__4302__a = new Array(arguments.length -  3);
while (G__4302__i < G__4302__a.length) {G__4302__a[G__4302__i] = arguments[G__4302__i + 3]; ++G__4302__i;}
G__4301 = new cljs.core.IndexedSeq(G__4302__a,0,null);
}
return G__4297__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4301);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4297.cljs$lang$maxFixedArity = 3;
G__4297.cljs$lang$applyTo = G__4297__4.cljs$lang$applyTo;
G__4297.cljs$core$IFn$_invoke$arity$0 = G__4297__0;
G__4297.cljs$core$IFn$_invoke$arity$1 = G__4297__1;
G__4297.cljs$core$IFn$_invoke$arity$2 = G__4297__2;
G__4297.cljs$core$IFn$_invoke$arity$3 = G__4297__3;
G__4297.cljs$core$IFn$_invoke$arity$variadic = G__4297__4.cljs$core$IFn$_invoke$arity$variadic;
return G__4297;
})()
}));

(cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = (function (f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return (function() { 
var G__4303__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__4304 = (function (){var fexpr__4286 = cljs.core.first(fs__$2);
return (fexpr__4286.cljs$core$IFn$_invoke$arity$1 ? fexpr__4286.cljs$core$IFn$_invoke$arity$1(ret) : fexpr__4286.call(null,ret));
})();
var G__4305 = cljs.core.next(fs__$2);
ret = G__4304;
fs__$2 = G__4305;
continue;
} else {
return ret;
}
break;
}
};
var G__4303 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__4306__i = 0, G__4306__a = new Array(arguments.length -  0);
while (G__4306__i < G__4306__a.length) {G__4306__a[G__4306__i] = arguments[G__4306__i + 0]; ++G__4306__i;}
  args = new cljs.core.IndexedSeq(G__4306__a,0,null);
} 
return G__4303__delegate.call(this,args);};
G__4303.cljs$lang$maxFixedArity = 0;
G__4303.cljs$lang$applyTo = (function (arglist__4307){
var args = cljs.core.seq(arglist__4307);
return G__4303__delegate(args);
});
G__4303.cljs$core$IFn$_invoke$arity$variadic = G__4303__delegate;
return G__4303;
})()
;
}));

/** @this {Function} */
(cljs.core.comp.cljs$lang$applyTo = (function (seq4266){
var G__4267 = cljs.core.first(seq4266);
var seq4266__$1 = cljs.core.next(seq4266);
var G__4268 = cljs.core.first(seq4266__$1);
var seq4266__$2 = cljs.core.next(seq4266__$1);
var G__4269 = cljs.core.first(seq4266__$2);
var seq4266__$3 = cljs.core.next(seq4266__$2);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4267,G__4268,G__4269,seq4266__$3);
}));

(cljs.core.comp.cljs$lang$maxFixedArity = (3));

/**
 * Takes a function f and fewer than the normal arguments to f, and
 *   returns a fn that takes a variable number of additional args. When
 *   called, the returned function calls f with args + additional args.
 */
cljs.core.partial = (function cljs$core$partial(var_args){
var G__4314 = arguments.length;
switch (G__4314) {
case 1:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4316 = arguments.length;
var i__4772__auto___4317 = (0);
while(true){
if((i__4772__auto___4317 < len__4771__auto___4316)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4317]));

var G__4318 = (i__4772__auto___4317 + (1));
i__4772__auto___4317 = G__4318;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((4)),(0),null));
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4793__auto__);

}
});

(cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = (function (f,arg1){
return (function() {
var G__4319 = null;
var G__4319__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null,arg1));
});
var G__4319__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,x) : f.call(null,arg1,x));
});
var G__4319__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,x,y) : f.call(null,arg1,x,y));
});
var G__4319__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,x,y,z) : f.call(null,arg1,x,y,z));
});
var G__4319__4 = (function() { 
var G__4320__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
};
var G__4320 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4321__i = 0, G__4321__a = new Array(arguments.length -  3);
while (G__4321__i < G__4321__a.length) {G__4321__a[G__4321__i] = arguments[G__4321__i + 3]; ++G__4321__i;}
  args = new cljs.core.IndexedSeq(G__4321__a,0,null);
} 
return G__4320__delegate.call(this,x,y,z,args);};
G__4320.cljs$lang$maxFixedArity = 3;
G__4320.cljs$lang$applyTo = (function (arglist__4322){
var x = cljs.core.first(arglist__4322);
arglist__4322 = cljs.core.next(arglist__4322);
var y = cljs.core.first(arglist__4322);
arglist__4322 = cljs.core.next(arglist__4322);
var z = cljs.core.first(arglist__4322);
var args = cljs.core.rest(arglist__4322);
return G__4320__delegate(x,y,z,args);
});
G__4320.cljs$core$IFn$_invoke$arity$variadic = G__4320__delegate;
return G__4320;
})()
;
G__4319 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__4319__0.call(this);
case 1:
return G__4319__1.call(this,x);
case 2:
return G__4319__2.call(this,x,y);
case 3:
return G__4319__3.call(this,x,y,z);
default:
var G__4323 = null;
if (arguments.length > 3) {
var G__4324__i = 0, G__4324__a = new Array(arguments.length -  3);
while (G__4324__i < G__4324__a.length) {G__4324__a[G__4324__i] = arguments[G__4324__i + 3]; ++G__4324__i;}
G__4323 = new cljs.core.IndexedSeq(G__4324__a,0,null);
}
return G__4319__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4319.cljs$lang$maxFixedArity = 3;
G__4319.cljs$lang$applyTo = G__4319__4.cljs$lang$applyTo;
G__4319.cljs$core$IFn$_invoke$arity$0 = G__4319__0;
G__4319.cljs$core$IFn$_invoke$arity$1 = G__4319__1;
G__4319.cljs$core$IFn$_invoke$arity$2 = G__4319__2;
G__4319.cljs$core$IFn$_invoke$arity$3 = G__4319__3;
G__4319.cljs$core$IFn$_invoke$arity$variadic = G__4319__4.cljs$core$IFn$_invoke$arity$variadic;
return G__4319;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = (function (f,arg1,arg2){
return (function() {
var G__4325 = null;
var G__4325__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,arg2) : f.call(null,arg1,arg2));
});
var G__4325__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,x) : f.call(null,arg1,arg2,x));
});
var G__4325__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,x,y) : f.call(null,arg1,arg2,x,y));
});
var G__4325__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,x,y,z) : f.call(null,arg1,arg2,x,y,z));
});
var G__4325__4 = (function() { 
var G__4326__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([z,args], 0));
};
var G__4326 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4327__i = 0, G__4327__a = new Array(arguments.length -  3);
while (G__4327__i < G__4327__a.length) {G__4327__a[G__4327__i] = arguments[G__4327__i + 3]; ++G__4327__i;}
  args = new cljs.core.IndexedSeq(G__4327__a,0,null);
} 
return G__4326__delegate.call(this,x,y,z,args);};
G__4326.cljs$lang$maxFixedArity = 3;
G__4326.cljs$lang$applyTo = (function (arglist__4328){
var x = cljs.core.first(arglist__4328);
arglist__4328 = cljs.core.next(arglist__4328);
var y = cljs.core.first(arglist__4328);
arglist__4328 = cljs.core.next(arglist__4328);
var z = cljs.core.first(arglist__4328);
var args = cljs.core.rest(arglist__4328);
return G__4326__delegate(x,y,z,args);
});
G__4326.cljs$core$IFn$_invoke$arity$variadic = G__4326__delegate;
return G__4326;
})()
;
G__4325 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__4325__0.call(this);
case 1:
return G__4325__1.call(this,x);
case 2:
return G__4325__2.call(this,x,y);
case 3:
return G__4325__3.call(this,x,y,z);
default:
var G__4329 = null;
if (arguments.length > 3) {
var G__4330__i = 0, G__4330__a = new Array(arguments.length -  3);
while (G__4330__i < G__4330__a.length) {G__4330__a[G__4330__i] = arguments[G__4330__i + 3]; ++G__4330__i;}
G__4329 = new cljs.core.IndexedSeq(G__4330__a,0,null);
}
return G__4325__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4325.cljs$lang$maxFixedArity = 3;
G__4325.cljs$lang$applyTo = G__4325__4.cljs$lang$applyTo;
G__4325.cljs$core$IFn$_invoke$arity$0 = G__4325__0;
G__4325.cljs$core$IFn$_invoke$arity$1 = G__4325__1;
G__4325.cljs$core$IFn$_invoke$arity$2 = G__4325__2;
G__4325.cljs$core$IFn$_invoke$arity$3 = G__4325__3;
G__4325.cljs$core$IFn$_invoke$arity$variadic = G__4325__4.cljs$core$IFn$_invoke$arity$variadic;
return G__4325;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = (function (f,arg1,arg2,arg3){
return (function() {
var G__4331 = null;
var G__4331__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,arg3) : f.call(null,arg1,arg2,arg3));
});
var G__4331__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,arg3,x) : f.call(null,arg1,arg2,arg3,x));
});
var G__4331__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,arg3,x,y) : f.call(null,arg1,arg2,arg3,x,y));
});
var G__4331__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1,arg2,arg3,x,y,z) : f.call(null,arg1,arg2,arg3,x,y,z));
});
var G__4331__4 = (function() { 
var G__4332__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([y,z,args], 0));
};
var G__4332 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4333__i = 0, G__4333__a = new Array(arguments.length -  3);
while (G__4333__i < G__4333__a.length) {G__4333__a[G__4333__i] = arguments[G__4333__i + 3]; ++G__4333__i;}
  args = new cljs.core.IndexedSeq(G__4333__a,0,null);
} 
return G__4332__delegate.call(this,x,y,z,args);};
G__4332.cljs$lang$maxFixedArity = 3;
G__4332.cljs$lang$applyTo = (function (arglist__4334){
var x = cljs.core.first(arglist__4334);
arglist__4334 = cljs.core.next(arglist__4334);
var y = cljs.core.first(arglist__4334);
arglist__4334 = cljs.core.next(arglist__4334);
var z = cljs.core.first(arglist__4334);
var args = cljs.core.rest(arglist__4334);
return G__4332__delegate(x,y,z,args);
});
G__4332.cljs$core$IFn$_invoke$arity$variadic = G__4332__delegate;
return G__4332;
})()
;
G__4331 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__4331__0.call(this);
case 1:
return G__4331__1.call(this,x);
case 2:
return G__4331__2.call(this,x,y);
case 3:
return G__4331__3.call(this,x,y,z);
default:
var G__4335 = null;
if (arguments.length > 3) {
var G__4336__i = 0, G__4336__a = new Array(arguments.length -  3);
while (G__4336__i < G__4336__a.length) {G__4336__a[G__4336__i] = arguments[G__4336__i + 3]; ++G__4336__i;}
G__4335 = new cljs.core.IndexedSeq(G__4336__a,0,null);
}
return G__4331__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4335);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4331.cljs$lang$maxFixedArity = 3;
G__4331.cljs$lang$applyTo = G__4331__4.cljs$lang$applyTo;
G__4331.cljs$core$IFn$_invoke$arity$0 = G__4331__0;
G__4331.cljs$core$IFn$_invoke$arity$1 = G__4331__1;
G__4331.cljs$core$IFn$_invoke$arity$2 = G__4331__2;
G__4331.cljs$core$IFn$_invoke$arity$3 = G__4331__3;
G__4331.cljs$core$IFn$_invoke$arity$variadic = G__4331__4.cljs$core$IFn$_invoke$arity$variadic;
return G__4331;
})()
}));

(cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = (function (f,arg1,arg2,arg3,more){
return (function() { 
var G__4337__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var G__4337 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__4338__i = 0, G__4338__a = new Array(arguments.length -  0);
while (G__4338__i < G__4338__a.length) {G__4338__a[G__4338__i] = arguments[G__4338__i + 0]; ++G__4338__i;}
  args = new cljs.core.IndexedSeq(G__4338__a,0,null);
} 
return G__4337__delegate.call(this,args);};
G__4337.cljs$lang$maxFixedArity = 0;
G__4337.cljs$lang$applyTo = (function (arglist__4339){
var args = cljs.core.seq(arglist__4339);
return G__4337__delegate(args);
});
G__4337.cljs$core$IFn$_invoke$arity$variadic = G__4337__delegate;
return G__4337;
})()
;
}));

/** @this {Function} */
(cljs.core.partial.cljs$lang$applyTo = (function (seq4309){
var G__4310 = cljs.core.first(seq4309);
var seq4309__$1 = cljs.core.next(seq4309);
var G__4311 = cljs.core.first(seq4309__$1);
var seq4309__$2 = cljs.core.next(seq4309__$1);
var G__4312 = cljs.core.first(seq4309__$2);
var seq4309__$3 = cljs.core.next(seq4309__$2);
var G__4313 = cljs.core.first(seq4309__$3);
var seq4309__$4 = cljs.core.next(seq4309__$3);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4310,G__4311,G__4312,G__4313,seq4309__$4);
}));

(cljs.core.partial.cljs$lang$maxFixedArity = (4));

/**
 * Takes a function f, and returns a function that calls f, replacing
 *   a nil first argument to f with the supplied value x. Higher arity
 *   versions can replace arguments in the second and third
 *   positions (y, z). Note that the function f can take any number of
 *   arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function cljs$core$fnil(var_args){
var G__4341 = arguments.length;
switch (G__4341) {
case 2:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = (function (f,x){
return (function() {
var G__4359 = null;
var G__4359__1 = (function (a){
var G__4342 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4342) : f.call(null,G__4342));
});
var G__4359__2 = (function (a,b){
var G__4343 = (((a == null))?x:a);
var G__4344 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4343,G__4344) : f.call(null,G__4343,G__4344));
});
var G__4359__3 = (function (a,b,c){
var G__4345 = (((a == null))?x:a);
var G__4346 = b;
var G__4347 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4345,G__4346,G__4347) : f.call(null,G__4345,G__4346,G__4347));
});
var G__4359__4 = (function() { 
var G__4360__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__4360 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__4361__i = 0, G__4361__a = new Array(arguments.length -  3);
while (G__4361__i < G__4361__a.length) {G__4361__a[G__4361__i] = arguments[G__4361__i + 3]; ++G__4361__i;}
  ds = new cljs.core.IndexedSeq(G__4361__a,0,null);
} 
return G__4360__delegate.call(this,a,b,c,ds);};
G__4360.cljs$lang$maxFixedArity = 3;
G__4360.cljs$lang$applyTo = (function (arglist__4362){
var a = cljs.core.first(arglist__4362);
arglist__4362 = cljs.core.next(arglist__4362);
var b = cljs.core.first(arglist__4362);
arglist__4362 = cljs.core.next(arglist__4362);
var c = cljs.core.first(arglist__4362);
var ds = cljs.core.rest(arglist__4362);
return G__4360__delegate(a,b,c,ds);
});
G__4360.cljs$core$IFn$_invoke$arity$variadic = G__4360__delegate;
return G__4360;
})()
;
G__4359 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__4359__1.call(this,a);
case 2:
return G__4359__2.call(this,a,b);
case 3:
return G__4359__3.call(this,a,b,c);
default:
var G__4363 = null;
if (arguments.length > 3) {
var G__4364__i = 0, G__4364__a = new Array(arguments.length -  3);
while (G__4364__i < G__4364__a.length) {G__4364__a[G__4364__i] = arguments[G__4364__i + 3]; ++G__4364__i;}
G__4363 = new cljs.core.IndexedSeq(G__4364__a,0,null);
}
return G__4359__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__4363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4359.cljs$lang$maxFixedArity = 3;
G__4359.cljs$lang$applyTo = G__4359__4.cljs$lang$applyTo;
G__4359.cljs$core$IFn$_invoke$arity$1 = G__4359__1;
G__4359.cljs$core$IFn$_invoke$arity$2 = G__4359__2;
G__4359.cljs$core$IFn$_invoke$arity$3 = G__4359__3;
G__4359.cljs$core$IFn$_invoke$arity$variadic = G__4359__4.cljs$core$IFn$_invoke$arity$variadic;
return G__4359;
})()
}));

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = (function (f,x,y){
return (function() {
var G__4365 = null;
var G__4365__2 = (function (a,b){
var G__4348 = (((a == null))?x:a);
var G__4349 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4348,G__4349) : f.call(null,G__4348,G__4349));
});
var G__4365__3 = (function (a,b,c){
var G__4350 = (((a == null))?x:a);
var G__4351 = (((b == null))?y:b);
var G__4352 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4350,G__4351,G__4352) : f.call(null,G__4350,G__4351,G__4352));
});
var G__4365__4 = (function() { 
var G__4366__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__4366 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__4367__i = 0, G__4367__a = new Array(arguments.length -  3);
while (G__4367__i < G__4367__a.length) {G__4367__a[G__4367__i] = arguments[G__4367__i + 3]; ++G__4367__i;}
  ds = new cljs.core.IndexedSeq(G__4367__a,0,null);
} 
return G__4366__delegate.call(this,a,b,c,ds);};
G__4366.cljs$lang$maxFixedArity = 3;
G__4366.cljs$lang$applyTo = (function (arglist__4368){
var a = cljs.core.first(arglist__4368);
arglist__4368 = cljs.core.next(arglist__4368);
var b = cljs.core.first(arglist__4368);
arglist__4368 = cljs.core.next(arglist__4368);
var c = cljs.core.first(arglist__4368);
var ds = cljs.core.rest(arglist__4368);
return G__4366__delegate(a,b,c,ds);
});
G__4366.cljs$core$IFn$_invoke$arity$variadic = G__4366__delegate;
return G__4366;
})()
;
G__4365 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__4365__2.call(this,a,b);
case 3:
return G__4365__3.call(this,a,b,c);
default:
var G__4369 = null;
if (arguments.length > 3) {
var G__4370__i = 0, G__4370__a = new Array(arguments.length -  3);
while (G__4370__i < G__4370__a.length) {G__4370__a[G__4370__i] = arguments[G__4370__i + 3]; ++G__4370__i;}
G__4369 = new cljs.core.IndexedSeq(G__4370__a,0,null);
}
return G__4365__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__4369);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4365.cljs$lang$maxFixedArity = 3;
G__4365.cljs$lang$applyTo = G__4365__4.cljs$lang$applyTo;
G__4365.cljs$core$IFn$_invoke$arity$2 = G__4365__2;
G__4365.cljs$core$IFn$_invoke$arity$3 = G__4365__3;
G__4365.cljs$core$IFn$_invoke$arity$variadic = G__4365__4.cljs$core$IFn$_invoke$arity$variadic;
return G__4365;
})()
}));

(cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,z){
return (function() {
var G__4371 = null;
var G__4371__2 = (function (a,b){
var G__4353 = (((a == null))?x:a);
var G__4354 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4353,G__4354) : f.call(null,G__4353,G__4354));
});
var G__4371__3 = (function (a,b,c){
var G__4355 = (((a == null))?x:a);
var G__4356 = (((b == null))?y:b);
var G__4357 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4355,G__4356,G__4357) : f.call(null,G__4355,G__4356,G__4357));
});
var G__4371__4 = (function() { 
var G__4372__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__4372 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__4373__i = 0, G__4373__a = new Array(arguments.length -  3);
while (G__4373__i < G__4373__a.length) {G__4373__a[G__4373__i] = arguments[G__4373__i + 3]; ++G__4373__i;}
  ds = new cljs.core.IndexedSeq(G__4373__a,0,null);
} 
return G__4372__delegate.call(this,a,b,c,ds);};
G__4372.cljs$lang$maxFixedArity = 3;
G__4372.cljs$lang$applyTo = (function (arglist__4374){
var a = cljs.core.first(arglist__4374);
arglist__4374 = cljs.core.next(arglist__4374);
var b = cljs.core.first(arglist__4374);
arglist__4374 = cljs.core.next(arglist__4374);
var c = cljs.core.first(arglist__4374);
var ds = cljs.core.rest(arglist__4374);
return G__4372__delegate(a,b,c,ds);
});
G__4372.cljs$core$IFn$_invoke$arity$variadic = G__4372__delegate;
return G__4372;
})()
;
G__4371 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__4371__2.call(this,a,b);
case 3:
return G__4371__3.call(this,a,b,c);
default:
var G__4375 = null;
if (arguments.length > 3) {
var G__4376__i = 0, G__4376__a = new Array(arguments.length -  3);
while (G__4376__i < G__4376__a.length) {G__4376__a[G__4376__i] = arguments[G__4376__i + 3]; ++G__4376__i;}
G__4375 = new cljs.core.IndexedSeq(G__4376__a,0,null);
}
return G__4371__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__4375);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4371.cljs$lang$maxFixedArity = 3;
G__4371.cljs$lang$applyTo = G__4371__4.cljs$lang$applyTo;
G__4371.cljs$core$IFn$_invoke$arity$2 = G__4371__2;
G__4371.cljs$core$IFn$_invoke$arity$3 = G__4371__3;
G__4371.cljs$core$IFn$_invoke$arity$variadic = G__4371__4.cljs$core$IFn$_invoke$arity$variadic;
return G__4371;
})()
}));

(cljs.core.fnil.cljs$lang$maxFixedArity = 4);

/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 *   and the first item of coll, followed by applying f to 1 and the second
 *   item in coll, etc, until coll is exhausted. Thus function f should
 *   accept 2 arguments, index and item. Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.map_indexed = (function cljs$core$map_indexed(var_args){
var G__4378 = arguments.length;
switch (G__4378) {
case 1:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var i = cljs.core.volatile_BANG_((-1));
return (function() {
var G__4392 = null;
var G__4392__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__4392__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__4392__2 = (function (result,input){
var G__4379 = result;
var G__4380 = (function (){var G__4381 = i.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(i.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var G__4382 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4381,G__4382) : f.call(null,G__4381,G__4382));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__4379,G__4380) : rf.call(null,G__4379,G__4380));
});
G__4392 = function(result,input){
switch(arguments.length){
case 0:
return G__4392__0.call(this);
case 1:
return G__4392__1.call(this,result);
case 2:
return G__4392__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4392.cljs$core$IFn$_invoke$arity$0 = G__4392__0;
G__4392.cljs$core$IFn$_invoke$arity$1 = G__4392__1;
G__4392.cljs$core$IFn$_invoke$arity$2 = G__4392__2;
return G__4392;
})()
});
}));

(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var mapi = (function cljs$core$mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__5753__auto__ = cljs.core.seq(coll__$1);
if(temp__5753__auto__){
var s = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4648__auto___4393 = size;
var i_4394 = (0);
while(true){
if((i_4394 < n__4648__auto___4393)){
cljs.core.chunk_append(b,(function (){var G__4387 = (idx + i_4394);
var G__4388 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_4394);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4387,G__4388) : f.call(null,G__4387,G__4388));
})());

var G__4395 = (i_4394 + (1));
i_4394 = G__4395;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__4389 = idx;
var G__4390 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4389,G__4390) : f.call(null,G__4389,G__4390));
})(),cljs$core$mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
}));

(cljs.core.map_indexed.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function cljs$core$keep(var_args){
var G__4397 = arguments.length;
switch (G__4397) {
case 1:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__4401 = null;
var G__4401__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__4401__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__4401__2 = (function (result,input){
var v = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
G__4401 = function(result,input){
switch(arguments.length){
case 0:
return G__4401__0.call(this);
case 1:
return G__4401__1.call(this,result);
case 2:
return G__4401__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4401.cljs$core$IFn$_invoke$arity$0 = G__4401__0;
G__4401.cljs$core$IFn$_invoke$arity$1 = G__4401__1;
G__4401.cljs$core$IFn$_invoke$arity$2 = G__4401__2;
return G__4401;
})()
});
}));

(cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5753__auto__ = cljs.core.seq(coll);
if(temp__5753__auto__){
var s = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4648__auto___4402 = size;
var i_4403 = (0);
while(true){
if((i_4403 < n__4648__auto___4402)){
var x_4404 = (function (){var G__4398 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_4403);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4398) : f.call(null,G__4398));
})();
if((x_4404 == null)){
} else {
cljs.core.chunk_append(b,x_4404);
}

var G__4405 = (i_4403 + (1));
i_4403 = G__4405;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__4399 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4399) : f.call(null,G__4399));
})();
if((x == null)){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.keep.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IAtom}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition1$ = 16386;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
});
(cljs.core.Atom.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
}));

(cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
}));

(cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__4406 = cljs.core.seq(self__.watches);
var chunk__4407 = null;
var count__4408 = (0);
var i__4409 = (0);
while(true){
if((i__4409 < count__4408)){
var vec__4416 = chunk__4407.cljs$core$IIndexed$_nth$arity$2(null,i__4409);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4416,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4416,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));


var G__4422 = seq__4406;
var G__4423 = chunk__4407;
var G__4424 = count__4408;
var G__4425 = (i__4409 + (1));
seq__4406 = G__4422;
chunk__4407 = G__4423;
count__4408 = G__4424;
i__4409 = G__4425;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__4406);
if(temp__5753__auto__){
var seq__4406__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__4406__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__4406__$1);
var G__4426 = cljs.core.chunk_rest(seq__4406__$1);
var G__4427 = c__4591__auto__;
var G__4428 = cljs.core.count(c__4591__auto__);
var G__4429 = (0);
seq__4406 = G__4426;
chunk__4407 = G__4427;
count__4408 = G__4428;
i__4409 = G__4429;
continue;
} else {
var vec__4419 = cljs.core.first(seq__4406__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4419,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4419,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));


var G__4430 = cljs.core.next(seq__4406__$1);
var G__4431 = null;
var G__4432 = (0);
var G__4433 = (0);
seq__4406 = G__4430;
chunk__4407 = G__4431;
count__4408 = G__4432;
i__4409 = G__4433;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
(this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f));

return this$__$1;
}));

(cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return (this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key));
}));

(cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return goog.getUid(this$__$1);
}));

(cljs.core.Atom.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$state,cljs.core.cst$sym$meta,cljs.core.cst$sym$validator,cljs.core.cst$sym$watches], null);
}));

(cljs.core.Atom.cljs$lang$type = true);

(cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom");

(cljs.core.Atom.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/Atom");
}));

/**
 * Positional factory function for cljs.core/Atom.
 */
cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 *   more options (in any order):
 * 
 *   :meta metadata-map
 * 
 *   :validator validate-fn
 * 
 *   If metadata-map is supplied, it will become the metadata on the
 *   atom. validate-fn must be nil or a side-effect-free fn of one
 *   argument, which will be passed the intended new state on any state
 *   change. If the new state is unacceptable, the validate-fn should
 *   return false or throw an Error.  If either of these error conditions
 *   occur, then the value of the atom will not change.
 */
cljs.core.atom = (function cljs$core$atom(var_args){
var G__4437 = arguments.length;
switch (G__4437) {
case 1:
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4441 = arguments.length;
var i__4772__auto___4442 = (0);
while(true){
if((i__4772__auto___4442 < len__4771__auto___4441)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4442]));

var G__4443 = (i__4772__auto___4442 + (1));
i__4772__auto___4442 = G__4443;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((1)),(0),null));
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4793__auto__);

}
});

(cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
}));

(cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__4438){
var map__4439 = p__4438;
var map__4439__$1 = cljs.core.__destructure_map(map__4439);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4439__$1,cljs.core.cst$kw$meta);
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__4439__$1,cljs.core.cst$kw$validator);
return (new cljs.core.Atom(x,meta,validator,null));
}));

/** @this {Function} */
(cljs.core.atom.cljs$lang$applyTo = (function (seq4435){
var G__4436 = cljs.core.first(seq4435);
var seq4435__$1 = cljs.core.next(seq4435);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4436,seq4435__$1);
}));

(cljs.core.atom.cljs$lang$maxFixedArity = (1));

/**
 * Sets the value of atom to newval without regard for the
 *   current value. Returns new-value.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
(a.state = new_value);

if((a.watches == null)){
} else {
a.cljs$core$IWatchable$_notify_watches$arity$3(null,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Sets the value of atom to newval. Returns [old new], the value of the
 * atom before and after the reset.
 */
cljs.core.reset_vals_BANG_ = (function cljs$core$reset_vals_BANG_(a,new_value){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error("Validator rejected reference state"));
}
}

var old_value = a.state;
(a.state = new_value);

if((a.watches == null)){
} else {
cljs.core._notify_watches(a,old_value,new_value);
}

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_value,new_value], null);
});
/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.  Returns
 *   the value that was swapped in.
 */
cljs.core.swap_BANG_ = (function cljs$core$swap_BANG_(var_args){
var G__4450 = arguments.length;
switch (G__4450) {
case 2:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4458 = arguments.length;
var i__4772__auto___4459 = (0);
while(true){
if((i__4772__auto___4459 < len__4771__auto___4458)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4459]));

var G__4460 = (i__4772__auto___4459 + (1));
i__4772__auto___4459 = G__4460;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((4)),(0),null));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4793__auto__);

}
});

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__4451 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4451) : f.call(null,G__4451));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__4452 = a.state;
var G__4453 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4452,G__4453) : f.call(null,G__4452,G__4453));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__4454 = a.state;
var G__4455 = x;
var G__4456 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4454,G__4455,G__4456) : f.call(null,G__4454,G__4455,G__4456));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
}));

(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
}));

/** @this {Function} */
(cljs.core.swap_BANG_.cljs$lang$applyTo = (function (seq4445){
var G__4446 = cljs.core.first(seq4445);
var seq4445__$1 = cljs.core.next(seq4445);
var G__4447 = cljs.core.first(seq4445__$1);
var seq4445__$2 = cljs.core.next(seq4445__$1);
var G__4448 = cljs.core.first(seq4445__$2);
var seq4445__$3 = cljs.core.next(seq4445__$2);
var G__4449 = cljs.core.first(seq4445__$3);
var seq4445__$4 = cljs.core.next(seq4445__$3);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4446,G__4447,G__4448,G__4449,seq4445__$4);
}));

(cljs.core.swap_BANG_.cljs$lang$maxFixedArity = (4));

/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.
 *   Returns [old new], the value of the atom before and after the swap.
 */
cljs.core.swap_vals_BANG_ = (function cljs$core$swap_vals_BANG_(var_args){
var G__4467 = arguments.length;
switch (G__4467) {
case 2:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4475 = arguments.length;
var i__4772__auto___4476 = (0);
while(true){
if((i__4772__auto___4476 < len__4771__auto___4475)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4476]));

var G__4477 = (i__4772__auto___4476 + (1));
i__4772__auto___4476 = G__4477;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((4)),(0),null));
return cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4793__auto__);

}
});

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
return cljs.core.reset_vals_BANG_(a,(function (){var G__4468 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4468) : f.call(null,G__4468));
})());
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (a,f,x){
return cljs.core.reset_vals_BANG_(a,(function (){var G__4469 = a.state;
var G__4470 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4469,G__4470) : f.call(null,G__4469,G__4470));
})());
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (a,f,x,y){
return cljs.core.reset_vals_BANG_(a,(function (){var G__4471 = a.state;
var G__4472 = x;
var G__4473 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4471,G__4472,G__4473) : f.call(null,G__4471,G__4472,G__4473));
})());
}));

(cljs.core.swap_vals_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,x,y,more){
return cljs.core.reset_vals_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
}));

/** @this {Function} */
(cljs.core.swap_vals_BANG_.cljs$lang$applyTo = (function (seq4462){
var G__4463 = cljs.core.first(seq4462);
var seq4462__$1 = cljs.core.next(seq4462);
var G__4464 = cljs.core.first(seq4462__$1);
var seq4462__$2 = cljs.core.next(seq4462__$1);
var G__4465 = cljs.core.first(seq4462__$2);
var seq4462__$3 = cljs.core.next(seq4462__$2);
var G__4466 = cljs.core.first(seq4462__$3);
var seq4462__$4 = cljs.core.next(seq4462__$3);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4463,G__4464,G__4465,G__4466,seq4462__$4);
}));

(cljs.core.swap_vals_BANG_.cljs$lang$maxFixedArity = (4));

/**
 * Atomically sets the value of atom to newval if and only if the
 *   current value of the atom is equal to oldval. Returns true if
 *   set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 *   side-effect-free fn of one argument, which will be passed the intended
 *   new state on any state change. If the new state is unacceptable, the
 *   validator-fn should return false or throw an Error. If the current state
 *   is not acceptable to the new validator, an Error will be thrown and the
 *   validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
if((((!((val == null)))) && (cljs.core.not((function (){var G__4479 = cljs.core._deref(iref);
return (val.cljs$core$IFn$_invoke$arity$1 ? val.cljs$core$IFn$_invoke$arity$1(G__4479) : val.call(null,G__4479));
})())))){
throw (new Error("Validator rejected reference state"));
} else {
}

return (iref.validator = val);
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
 * @implements {cljs.core.IVolatile}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.Volatile.prototype.cljs$core$IVolatile$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function (_,new_state){
var self__ = this;
var ___$1 = this;
return (self__.state = new_state);
}));

(cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
}));

(cljs.core.Volatile.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.Volatile.cljs$lang$type = true);

(cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile");

(cljs.core.Volatile.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/Volatile");
}));

/**
 * Positional factory function for cljs.core/Volatile.
 */
cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a stateful transducer when no collection is
 *   provided.
 */
cljs.core.keep_indexed = (function cljs$core$keep_indexed(var_args){
var G__4481 = arguments.length;
switch (G__4481) {
case 1:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return (function() {
var G__4491 = null;
var G__4491__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__4491__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__4491__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var v = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(i,input) : f.call(null,i,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
G__4491 = function(result,input){
switch(arguments.length){
case 0:
return G__4491__0.call(this);
case 1:
return G__4491__1.call(this,result);
case 2:
return G__4491__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4491.cljs$core$IFn$_invoke$arity$0 = G__4491__0;
G__4491.cljs$core$IFn$_invoke$arity$1 = G__4491__1;
G__4491.cljs$core$IFn$_invoke$arity$2 = G__4491__2;
return G__4491;
})()
});
}));

(cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var keepi = (function cljs$core$keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__5753__auto__ = cljs.core.seq(coll__$1);
if(temp__5753__auto__){
var s = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4648__auto___4492 = size;
var i_4493 = (0);
while(true){
if((i_4493 < n__4648__auto___4492)){
var x_4494 = (function (){var G__4486 = (idx + i_4493);
var G__4487 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_4493);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4486,G__4487) : f.call(null,G__4486,G__4487));
})();
if((x_4494 == null)){
} else {
cljs.core.chunk_append(b,x_4494);
}

var G__4495 = (i_4493 + (1));
i_4493 = G__4495;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__4488 = idx;
var G__4489 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4488,G__4489) : f.call(null,G__4488,G__4489));
})();
if((x == null)){
return cljs$core$keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
}));

(cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2);

/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 *   composing predicates return a logical true value against all of its arguments, else it returns
 *   false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical false result against the original predicates.
 */
cljs.core.every_pred = (function cljs$core$every_pred(var_args){
var G__4507 = arguments.length;
switch (G__4507) {
case 1:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4509 = arguments.length;
var i__4772__auto___4510 = (0);
while(true){
if((i__4772__auto___4510 < len__4771__auto___4509)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4510]));

var G__4511 = (i__4772__auto___4510 + (1));
i__4772__auto___4510 = G__4511;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((3)),(0),null));
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4793__auto__);

}
});

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$ep1 = null;
var cljs$core$ep1__0 = (function (){
return true;
});
var cljs$core$ep1__1 = (function (x){
return cljs.core.boolean$((p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x)));
});
var cljs$core$ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__4149__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__4149__auto__)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
} else {
return and__4149__auto__;
}
})());
});
var cljs$core$ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__4149__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__4149__auto__)){
var and__4149__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(and__4149__auto____$1)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
} else {
return and__4149__auto____$1;
}
} else {
return and__4149__auto__;
}
})());
});
var cljs$core$ep1__4 = (function() { 
var G__4512__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__4149__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core.every_QMARK_(p,args);
} else {
return and__4149__auto__;
}
})());
};
var G__4512 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4513__i = 0, G__4513__a = new Array(arguments.length -  3);
while (G__4513__i < G__4513__a.length) {G__4513__a[G__4513__i] = arguments[G__4513__i + 3]; ++G__4513__i;}
  args = new cljs.core.IndexedSeq(G__4513__a,0,null);
} 
return G__4512__delegate.call(this,x,y,z,args);};
G__4512.cljs$lang$maxFixedArity = 3;
G__4512.cljs$lang$applyTo = (function (arglist__4514){
var x = cljs.core.first(arglist__4514);
arglist__4514 = cljs.core.next(arglist__4514);
var y = cljs.core.first(arglist__4514);
arglist__4514 = cljs.core.next(arglist__4514);
var z = cljs.core.first(arglist__4514);
var args = cljs.core.rest(arglist__4514);
return G__4512__delegate(x,y,z,args);
});
G__4512.cljs$core$IFn$_invoke$arity$variadic = G__4512__delegate;
return G__4512;
})()
;
cljs$core$ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep1__0.call(this);
case 1:
return cljs$core$ep1__1.call(this,x);
case 2:
return cljs$core$ep1__2.call(this,x,y);
case 3:
return cljs$core$ep1__3.call(this,x,y,z);
default:
var G__4515 = null;
if (arguments.length > 3) {
var G__4516__i = 0, G__4516__a = new Array(arguments.length -  3);
while (G__4516__i < G__4516__a.length) {G__4516__a[G__4516__i] = arguments[G__4516__i + 3]; ++G__4516__i;}
G__4515 = new cljs.core.IndexedSeq(G__4516__a,0,null);
}
return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep1.cljs$lang$maxFixedArity = 3;
cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep1;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$ep2 = null;
var cljs$core$ep2__0 = (function (){
return true;
});
var cljs$core$ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__4149__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__4149__auto__)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
} else {
return and__4149__auto__;
}
})());
});
var cljs$core$ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__4149__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__4149__auto__)){
var and__4149__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__4149__auto____$1)){
var and__4149__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__4149__auto____$2)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
} else {
return and__4149__auto____$2;
}
} else {
return and__4149__auto____$1;
}
} else {
return and__4149__auto__;
}
})());
});
var cljs$core$ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__4149__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__4149__auto__)){
var and__4149__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__4149__auto____$1)){
var and__4149__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__4149__auto____$2)){
var and__4149__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__4149__auto____$3)){
var and__4149__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__4149__auto____$4)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
} else {
return and__4149__auto____$4;
}
} else {
return and__4149__auto____$3;
}
} else {
return and__4149__auto____$2;
}
} else {
return and__4149__auto____$1;
}
} else {
return and__4149__auto__;
}
})());
});
var cljs$core$ep2__4 = (function() { 
var G__4517__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__4149__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core.every_QMARK_((function (p1__4496_SHARP_){
var and__4149__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__4496_SHARP_) : p1.call(null,p1__4496_SHARP_));
if(cljs.core.truth_(and__4149__auto____$1)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__4496_SHARP_) : p2.call(null,p1__4496_SHARP_));
} else {
return and__4149__auto____$1;
}
}),args);
} else {
return and__4149__auto__;
}
})());
};
var G__4517 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4518__i = 0, G__4518__a = new Array(arguments.length -  3);
while (G__4518__i < G__4518__a.length) {G__4518__a[G__4518__i] = arguments[G__4518__i + 3]; ++G__4518__i;}
  args = new cljs.core.IndexedSeq(G__4518__a,0,null);
} 
return G__4517__delegate.call(this,x,y,z,args);};
G__4517.cljs$lang$maxFixedArity = 3;
G__4517.cljs$lang$applyTo = (function (arglist__4519){
var x = cljs.core.first(arglist__4519);
arglist__4519 = cljs.core.next(arglist__4519);
var y = cljs.core.first(arglist__4519);
arglist__4519 = cljs.core.next(arglist__4519);
var z = cljs.core.first(arglist__4519);
var args = cljs.core.rest(arglist__4519);
return G__4517__delegate(x,y,z,args);
});
G__4517.cljs$core$IFn$_invoke$arity$variadic = G__4517__delegate;
return G__4517;
})()
;
cljs$core$ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep2__0.call(this);
case 1:
return cljs$core$ep2__1.call(this,x);
case 2:
return cljs$core$ep2__2.call(this,x,y);
case 3:
return cljs$core$ep2__3.call(this,x,y,z);
default:
var G__4520 = null;
if (arguments.length > 3) {
var G__4521__i = 0, G__4521__a = new Array(arguments.length -  3);
while (G__4521__i < G__4521__a.length) {G__4521__a[G__4521__i] = arguments[G__4521__i + 3]; ++G__4521__i;}
G__4520 = new cljs.core.IndexedSeq(G__4521__a,0,null);
}
return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4520);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep2.cljs$lang$maxFixedArity = 3;
cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep2;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$ep3 = null;
var cljs$core$ep3__0 = (function (){
return true;
});
var cljs$core$ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__4149__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__4149__auto__)){
var and__4149__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__4149__auto____$1)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
} else {
return and__4149__auto____$1;
}
} else {
return and__4149__auto__;
}
})());
});
var cljs$core$ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__4149__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__4149__auto__)){
var and__4149__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__4149__auto____$1)){
var and__4149__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__4149__auto____$2)){
var and__4149__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__4149__auto____$3)){
var and__4149__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__4149__auto____$4)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
} else {
return and__4149__auto____$4;
}
} else {
return and__4149__auto____$3;
}
} else {
return and__4149__auto____$2;
}
} else {
return and__4149__auto____$1;
}
} else {
return and__4149__auto__;
}
})());
});
var cljs$core$ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__4149__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__4149__auto__)){
var and__4149__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__4149__auto____$1)){
var and__4149__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__4149__auto____$2)){
var and__4149__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__4149__auto____$3)){
var and__4149__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__4149__auto____$4)){
var and__4149__auto____$5 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(and__4149__auto____$5)){
var and__4149__auto____$6 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__4149__auto____$6)){
var and__4149__auto____$7 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(and__4149__auto____$7)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
} else {
return and__4149__auto____$7;
}
} else {
return and__4149__auto____$6;
}
} else {
return and__4149__auto____$5;
}
} else {
return and__4149__auto____$4;
}
} else {
return and__4149__auto____$3;
}
} else {
return and__4149__auto____$2;
}
} else {
return and__4149__auto____$1;
}
} else {
return and__4149__auto__;
}
})());
});
var cljs$core$ep3__4 = (function() { 
var G__4522__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__4149__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core.every_QMARK_((function (p1__4497_SHARP_){
var and__4149__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__4497_SHARP_) : p1.call(null,p1__4497_SHARP_));
if(cljs.core.truth_(and__4149__auto____$1)){
var and__4149__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__4497_SHARP_) : p2.call(null,p1__4497_SHARP_));
if(cljs.core.truth_(and__4149__auto____$2)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__4497_SHARP_) : p3.call(null,p1__4497_SHARP_));
} else {
return and__4149__auto____$2;
}
} else {
return and__4149__auto____$1;
}
}),args);
} else {
return and__4149__auto__;
}
})());
};
var G__4522 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4523__i = 0, G__4523__a = new Array(arguments.length -  3);
while (G__4523__i < G__4523__a.length) {G__4523__a[G__4523__i] = arguments[G__4523__i + 3]; ++G__4523__i;}
  args = new cljs.core.IndexedSeq(G__4523__a,0,null);
} 
return G__4522__delegate.call(this,x,y,z,args);};
G__4522.cljs$lang$maxFixedArity = 3;
G__4522.cljs$lang$applyTo = (function (arglist__4524){
var x = cljs.core.first(arglist__4524);
arglist__4524 = cljs.core.next(arglist__4524);
var y = cljs.core.first(arglist__4524);
arglist__4524 = cljs.core.next(arglist__4524);
var z = cljs.core.first(arglist__4524);
var args = cljs.core.rest(arglist__4524);
return G__4522__delegate(x,y,z,args);
});
G__4522.cljs$core$IFn$_invoke$arity$variadic = G__4522__delegate;
return G__4522;
})()
;
cljs$core$ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep3__0.call(this);
case 1:
return cljs$core$ep3__1.call(this,x);
case 2:
return cljs$core$ep3__2.call(this,x,y);
case 3:
return cljs$core$ep3__3.call(this,x,y,z);
default:
var G__4525 = null;
if (arguments.length > 3) {
var G__4526__i = 0, G__4526__a = new Array(arguments.length -  3);
while (G__4526__i < G__4526__a.length) {G__4526__a[G__4526__i] = arguments[G__4526__i + 3]; ++G__4526__i;}
G__4525 = new cljs.core.IndexedSeq(G__4526__a,0,null);
}
return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4525);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep3.cljs$lang$maxFixedArity = 3;
cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep3;
})()
}));

(cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return (function() {
var cljs$core$epn = null;
var cljs$core$epn__0 = (function (){
return true;
});
var cljs$core$epn__1 = (function (x){
return cljs.core.every_QMARK_((function (p1__4498_SHARP_){
return (p1__4498_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4498_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__4498_SHARP_.call(null,x));
}),ps__$1);
});
var cljs$core$epn__2 = (function (x,y){
return cljs.core.every_QMARK_((function (p1__4499_SHARP_){
var and__4149__auto__ = (p1__4499_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4499_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__4499_SHARP_.call(null,x));
if(cljs.core.truth_(and__4149__auto__)){
return (p1__4499_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4499_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__4499_SHARP_.call(null,y));
} else {
return and__4149__auto__;
}
}),ps__$1);
});
var cljs$core$epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_((function (p1__4500_SHARP_){
var and__4149__auto__ = (p1__4500_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4500_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__4500_SHARP_.call(null,x));
if(cljs.core.truth_(and__4149__auto__)){
var and__4149__auto____$1 = (p1__4500_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4500_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__4500_SHARP_.call(null,y));
if(cljs.core.truth_(and__4149__auto____$1)){
return (p1__4500_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4500_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__4500_SHARP_.call(null,z));
} else {
return and__4149__auto____$1;
}
} else {
return and__4149__auto__;
}
}),ps__$1);
});
var cljs$core$epn__4 = (function() { 
var G__4527__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__4149__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core.every_QMARK_((function (p1__4501_SHARP_){
return cljs.core.every_QMARK_(p1__4501_SHARP_,args);
}),ps__$1);
} else {
return and__4149__auto__;
}
})());
};
var G__4527 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4528__i = 0, G__4528__a = new Array(arguments.length -  3);
while (G__4528__i < G__4528__a.length) {G__4528__a[G__4528__i] = arguments[G__4528__i + 3]; ++G__4528__i;}
  args = new cljs.core.IndexedSeq(G__4528__a,0,null);
} 
return G__4527__delegate.call(this,x,y,z,args);};
G__4527.cljs$lang$maxFixedArity = 3;
G__4527.cljs$lang$applyTo = (function (arglist__4529){
var x = cljs.core.first(arglist__4529);
arglist__4529 = cljs.core.next(arglist__4529);
var y = cljs.core.first(arglist__4529);
arglist__4529 = cljs.core.next(arglist__4529);
var z = cljs.core.first(arglist__4529);
var args = cljs.core.rest(arglist__4529);
return G__4527__delegate(x,y,z,args);
});
G__4527.cljs$core$IFn$_invoke$arity$variadic = G__4527__delegate;
return G__4527;
})()
;
cljs$core$epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$epn__0.call(this);
case 1:
return cljs$core$epn__1.call(this,x);
case 2:
return cljs$core$epn__2.call(this,x,y);
case 3:
return cljs$core$epn__3.call(this,x,y,z);
default:
var G__4530 = null;
if (arguments.length > 3) {
var G__4531__i = 0, G__4531__a = new Array(arguments.length -  3);
while (G__4531__i < G__4531__a.length) {G__4531__a[G__4531__i] = arguments[G__4531__i + 3]; ++G__4531__i;}
G__4530 = new cljs.core.IndexedSeq(G__4531__a,0,null);
}
return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4530);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$epn.cljs$lang$maxFixedArity = 3;
cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$epn;
})()
}));

/** @this {Function} */
(cljs.core.every_pred.cljs$lang$applyTo = (function (seq4503){
var G__4504 = cljs.core.first(seq4503);
var seq4503__$1 = cljs.core.next(seq4503);
var G__4505 = cljs.core.first(seq4503__$1);
var seq4503__$2 = cljs.core.next(seq4503__$1);
var G__4506 = cljs.core.first(seq4503__$2);
var seq4503__$3 = cljs.core.next(seq4503__$2);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4504,G__4505,G__4506,seq4503__$3);
}));

(cljs.core.every_pred.cljs$lang$maxFixedArity = (3));

/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 *   returned by one of its composing predicates against any of its arguments, else it returns
 *   logical false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical true result against the original predicates.
 */
cljs.core.some_fn = (function cljs$core$some_fn(var_args){
var G__4543 = arguments.length;
switch (G__4543) {
case 1:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4545 = arguments.length;
var i__4772__auto___4546 = (0);
while(true){
if((i__4772__auto___4546 < len__4771__auto___4545)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4546]));

var G__4547 = (i__4772__auto___4546 + (1));
i__4772__auto___4546 = G__4547;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((3)),(0),null));
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4793__auto__);

}
});

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$sp1 = null;
var cljs$core$sp1__0 = (function (){
return null;
});
var cljs$core$sp1__1 = (function (x){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
});
var cljs$core$sp1__2 = (function (x,y){
var or__4160__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
}
});
var cljs$core$sp1__3 = (function (x,y,z){
var or__4160__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
}
}
});
var cljs$core$sp1__4 = (function() { 
var G__4548__delegate = function (x,y,z,args){
var or__4160__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__4548 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4549__i = 0, G__4549__a = new Array(arguments.length -  3);
while (G__4549__i < G__4549__a.length) {G__4549__a[G__4549__i] = arguments[G__4549__i + 3]; ++G__4549__i;}
  args = new cljs.core.IndexedSeq(G__4549__a,0,null);
} 
return G__4548__delegate.call(this,x,y,z,args);};
G__4548.cljs$lang$maxFixedArity = 3;
G__4548.cljs$lang$applyTo = (function (arglist__4550){
var x = cljs.core.first(arglist__4550);
arglist__4550 = cljs.core.next(arglist__4550);
var y = cljs.core.first(arglist__4550);
arglist__4550 = cljs.core.next(arglist__4550);
var z = cljs.core.first(arglist__4550);
var args = cljs.core.rest(arglist__4550);
return G__4548__delegate(x,y,z,args);
});
G__4548.cljs$core$IFn$_invoke$arity$variadic = G__4548__delegate;
return G__4548;
})()
;
cljs$core$sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp1__0.call(this);
case 1:
return cljs$core$sp1__1.call(this,x);
case 2:
return cljs$core$sp1__2.call(this,x,y);
case 3:
return cljs$core$sp1__3.call(this,x,y,z);
default:
var G__4551 = null;
if (arguments.length > 3) {
var G__4552__i = 0, G__4552__a = new Array(arguments.length -  3);
while (G__4552__i < G__4552__a.length) {G__4552__a[G__4552__i] = arguments[G__4552__i + 3]; ++G__4552__i;}
G__4551 = new cljs.core.IndexedSeq(G__4552__a,0,null);
}
return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4551);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp1.cljs$lang$maxFixedArity = 3;
cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp1;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$sp2 = null;
var cljs$core$sp2__0 = (function (){
return null;
});
var cljs$core$sp2__1 = (function (x){
var or__4160__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
}
});
var cljs$core$sp2__2 = (function (x,y){
var or__4160__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
var or__4160__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__4160__auto____$2)){
return or__4160__auto____$2;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
}
}
}
});
var cljs$core$sp2__3 = (function (x,y,z){
var or__4160__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
var or__4160__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__4160__auto____$2)){
return or__4160__auto____$2;
} else {
var or__4160__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__4160__auto____$3)){
return or__4160__auto____$3;
} else {
var or__4160__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__4160__auto____$4)){
return or__4160__auto____$4;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
}
}
}
}
}
});
var cljs$core$sp2__4 = (function() { 
var G__4553__delegate = function (x,y,z,args){
var or__4160__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.some((function (p1__4532_SHARP_){
var or__4160__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__4532_SHARP_) : p1.call(null,p1__4532_SHARP_));
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__4532_SHARP_) : p2.call(null,p1__4532_SHARP_));
}
}),args);
}
};
var G__4553 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4554__i = 0, G__4554__a = new Array(arguments.length -  3);
while (G__4554__i < G__4554__a.length) {G__4554__a[G__4554__i] = arguments[G__4554__i + 3]; ++G__4554__i;}
  args = new cljs.core.IndexedSeq(G__4554__a,0,null);
} 
return G__4553__delegate.call(this,x,y,z,args);};
G__4553.cljs$lang$maxFixedArity = 3;
G__4553.cljs$lang$applyTo = (function (arglist__4555){
var x = cljs.core.first(arglist__4555);
arglist__4555 = cljs.core.next(arglist__4555);
var y = cljs.core.first(arglist__4555);
arglist__4555 = cljs.core.next(arglist__4555);
var z = cljs.core.first(arglist__4555);
var args = cljs.core.rest(arglist__4555);
return G__4553__delegate(x,y,z,args);
});
G__4553.cljs$core$IFn$_invoke$arity$variadic = G__4553__delegate;
return G__4553;
})()
;
cljs$core$sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp2__0.call(this);
case 1:
return cljs$core$sp2__1.call(this,x);
case 2:
return cljs$core$sp2__2.call(this,x,y);
case 3:
return cljs$core$sp2__3.call(this,x,y,z);
default:
var G__4556 = null;
if (arguments.length > 3) {
var G__4557__i = 0, G__4557__a = new Array(arguments.length -  3);
while (G__4557__i < G__4557__a.length) {G__4557__a[G__4557__i] = arguments[G__4557__i + 3]; ++G__4557__i;}
G__4556 = new cljs.core.IndexedSeq(G__4557__a,0,null);
}
return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4556);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp2.cljs$lang$maxFixedArity = 3;
cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp2;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$sp3 = null;
var cljs$core$sp3__0 = (function (){
return null;
});
var cljs$core$sp3__1 = (function (x){
var or__4160__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
}
}
});
var cljs$core$sp3__2 = (function (x,y){
var or__4160__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
var or__4160__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__4160__auto____$2)){
return or__4160__auto____$2;
} else {
var or__4160__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__4160__auto____$3)){
return or__4160__auto____$3;
} else {
var or__4160__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__4160__auto____$4)){
return or__4160__auto____$4;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
}
}
}
}
}
});
var cljs$core$sp3__3 = (function (x,y,z){
var or__4160__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
var or__4160__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__4160__auto____$2)){
return or__4160__auto____$2;
} else {
var or__4160__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__4160__auto____$3)){
return or__4160__auto____$3;
} else {
var or__4160__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__4160__auto____$4)){
return or__4160__auto____$4;
} else {
var or__4160__auto____$5 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(or__4160__auto____$5)){
return or__4160__auto____$5;
} else {
var or__4160__auto____$6 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__4160__auto____$6)){
return or__4160__auto____$6;
} else {
var or__4160__auto____$7 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(or__4160__auto____$7)){
return or__4160__auto____$7;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
}
}
}
}
}
}
}
}
});
var cljs$core$sp3__4 = (function() { 
var G__4558__delegate = function (x,y,z,args){
var or__4160__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.some((function (p1__4533_SHARP_){
var or__4160__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__4533_SHARP_) : p1.call(null,p1__4533_SHARP_));
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
var or__4160__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__4533_SHARP_) : p2.call(null,p1__4533_SHARP_));
if(cljs.core.truth_(or__4160__auto____$2)){
return or__4160__auto____$2;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__4533_SHARP_) : p3.call(null,p1__4533_SHARP_));
}
}
}),args);
}
};
var G__4558 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4559__i = 0, G__4559__a = new Array(arguments.length -  3);
while (G__4559__i < G__4559__a.length) {G__4559__a[G__4559__i] = arguments[G__4559__i + 3]; ++G__4559__i;}
  args = new cljs.core.IndexedSeq(G__4559__a,0,null);
} 
return G__4558__delegate.call(this,x,y,z,args);};
G__4558.cljs$lang$maxFixedArity = 3;
G__4558.cljs$lang$applyTo = (function (arglist__4560){
var x = cljs.core.first(arglist__4560);
arglist__4560 = cljs.core.next(arglist__4560);
var y = cljs.core.first(arglist__4560);
arglist__4560 = cljs.core.next(arglist__4560);
var z = cljs.core.first(arglist__4560);
var args = cljs.core.rest(arglist__4560);
return G__4558__delegate(x,y,z,args);
});
G__4558.cljs$core$IFn$_invoke$arity$variadic = G__4558__delegate;
return G__4558;
})()
;
cljs$core$sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp3__0.call(this);
case 1:
return cljs$core$sp3__1.call(this,x);
case 2:
return cljs$core$sp3__2.call(this,x,y);
case 3:
return cljs$core$sp3__3.call(this,x,y,z);
default:
var G__4561 = null;
if (arguments.length > 3) {
var G__4562__i = 0, G__4562__a = new Array(arguments.length -  3);
while (G__4562__i < G__4562__a.length) {G__4562__a[G__4562__i] = arguments[G__4562__i + 3]; ++G__4562__i;}
G__4561 = new cljs.core.IndexedSeq(G__4562__a,0,null);
}
return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp3.cljs$lang$maxFixedArity = 3;
cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp3;
})()
}));

(cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return (function() {
var cljs$core$spn = null;
var cljs$core$spn__0 = (function (){
return null;
});
var cljs$core$spn__1 = (function (x){
return cljs.core.some((function (p1__4534_SHARP_){
return (p1__4534_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4534_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__4534_SHARP_.call(null,x));
}),ps__$1);
});
var cljs$core$spn__2 = (function (x,y){
return cljs.core.some((function (p1__4535_SHARP_){
var or__4160__auto__ = (p1__4535_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4535_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__4535_SHARP_.call(null,x));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return (p1__4535_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4535_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__4535_SHARP_.call(null,y));
}
}),ps__$1);
});
var cljs$core$spn__3 = (function (x,y,z){
return cljs.core.some((function (p1__4536_SHARP_){
var or__4160__auto__ = (p1__4536_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4536_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__4536_SHARP_.call(null,x));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = (p1__4536_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4536_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__4536_SHARP_.call(null,y));
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
return (p1__4536_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__4536_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__4536_SHARP_.call(null,z));
}
}
}),ps__$1);
});
var cljs$core$spn__4 = (function() { 
var G__4563__delegate = function (x,y,z,args){
var or__4160__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.some((function (p1__4537_SHARP_){
return cljs.core.some(p1__4537_SHARP_,args);
}),ps__$1);
}
};
var G__4563 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__4564__i = 0, G__4564__a = new Array(arguments.length -  3);
while (G__4564__i < G__4564__a.length) {G__4564__a[G__4564__i] = arguments[G__4564__i + 3]; ++G__4564__i;}
  args = new cljs.core.IndexedSeq(G__4564__a,0,null);
} 
return G__4563__delegate.call(this,x,y,z,args);};
G__4563.cljs$lang$maxFixedArity = 3;
G__4563.cljs$lang$applyTo = (function (arglist__4565){
var x = cljs.core.first(arglist__4565);
arglist__4565 = cljs.core.next(arglist__4565);
var y = cljs.core.first(arglist__4565);
arglist__4565 = cljs.core.next(arglist__4565);
var z = cljs.core.first(arglist__4565);
var args = cljs.core.rest(arglist__4565);
return G__4563__delegate(x,y,z,args);
});
G__4563.cljs$core$IFn$_invoke$arity$variadic = G__4563__delegate;
return G__4563;
})()
;
cljs$core$spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$spn__0.call(this);
case 1:
return cljs$core$spn__1.call(this,x);
case 2:
return cljs$core$spn__2.call(this,x,y);
case 3:
return cljs$core$spn__3.call(this,x,y,z);
default:
var G__4566 = null;
if (arguments.length > 3) {
var G__4567__i = 0, G__4567__a = new Array(arguments.length -  3);
while (G__4567__i < G__4567__a.length) {G__4567__a[G__4567__i] = arguments[G__4567__i + 3]; ++G__4567__i;}
G__4566 = new cljs.core.IndexedSeq(G__4567__a,0,null);
}
return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__4566);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$spn.cljs$lang$maxFixedArity = 3;
cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$spn;
})()
}));

/** @this {Function} */
(cljs.core.some_fn.cljs$lang$applyTo = (function (seq4539){
var G__4540 = cljs.core.first(seq4539);
var seq4539__$1 = cljs.core.next(seq4539);
var G__4541 = cljs.core.first(seq4539__$1);
var seq4539__$2 = cljs.core.next(seq4539__$1);
var G__4542 = cljs.core.first(seq4539__$2);
var seq4539__$3 = cljs.core.next(seq4539__$2);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4540,G__4541,G__4542,seq4539__$3);
}));

(cljs.core.some_fn.cljs$lang$maxFixedArity = (3));

/**
 * Returns a lazy sequence consisting of the result of applying f to
 *   the set of first items of each coll, followed by applying f to the
 *   set of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments. Returns a transducer when
 *   no collection is provided.
 */
cljs.core.map = (function cljs$core$map(var_args){
var G__4575 = arguments.length;
switch (G__4575) {
case 1:
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.map.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4588 = arguments.length;
var i__4772__auto___4589 = (0);
while(true){
if((i__4772__auto___4589 < len__4771__auto___4588)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4589]));

var G__4590 = (i__4772__auto___4589 + (1));
i__4772__auto___4589 = G__4590;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((4)),(0),null));
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4793__auto__);

}
});

(cljs.core.map.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__4591 = null;
var G__4591__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__4591__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__4591__2 = (function (result,input){
var G__4576 = result;
var G__4577 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__4576,G__4577) : rf.call(null,G__4576,G__4577));
});
var G__4591__3 = (function() { 
var G__4592__delegate = function (result,input,inputs){
var G__4578 = result;
var G__4579 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__4578,G__4579) : rf.call(null,G__4578,G__4579));
};
var G__4592 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__4593__i = 0, G__4593__a = new Array(arguments.length -  2);
while (G__4593__i < G__4593__a.length) {G__4593__a[G__4593__i] = arguments[G__4593__i + 2]; ++G__4593__i;}
  inputs = new cljs.core.IndexedSeq(G__4593__a,0,null);
} 
return G__4592__delegate.call(this,result,input,inputs);};
G__4592.cljs$lang$maxFixedArity = 2;
G__4592.cljs$lang$applyTo = (function (arglist__4594){
var result = cljs.core.first(arglist__4594);
arglist__4594 = cljs.core.next(arglist__4594);
var input = cljs.core.first(arglist__4594);
var inputs = cljs.core.rest(arglist__4594);
return G__4592__delegate(result,input,inputs);
});
G__4592.cljs$core$IFn$_invoke$arity$variadic = G__4592__delegate;
return G__4592;
})()
;
G__4591 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return G__4591__0.call(this);
case 1:
return G__4591__1.call(this,result);
case 2:
return G__4591__2.call(this,result,input);
default:
var G__4595 = null;
if (arguments.length > 2) {
var G__4596__i = 0, G__4596__a = new Array(arguments.length -  2);
while (G__4596__i < G__4596__a.length) {G__4596__a[G__4596__i] = arguments[G__4596__i + 2]; ++G__4596__i;}
G__4595 = new cljs.core.IndexedSeq(G__4596__a,0,null);
}
return G__4591__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__4595);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4591.cljs$lang$maxFixedArity = 2;
G__4591.cljs$lang$applyTo = G__4591__3.cljs$lang$applyTo;
G__4591.cljs$core$IFn$_invoke$arity$0 = G__4591__0;
G__4591.cljs$core$IFn$_invoke$arity$1 = G__4591__1;
G__4591.cljs$core$IFn$_invoke$arity$2 = G__4591__2;
G__4591.cljs$core$IFn$_invoke$arity$variadic = G__4591__3.cljs$core$IFn$_invoke$arity$variadic;
return G__4591;
})()
});
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5753__auto__ = cljs.core.seq(coll);
if(temp__5753__auto__){
var s = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4648__auto___4597 = size;
var i_4598 = (0);
while(true){
if((i_4598 < n__4648__auto___4597)){
cljs.core.chunk_append(b,(function (){var G__4580 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_4598);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4580) : f.call(null,G__4580));
})());

var G__4599 = (i_4598 + (1));
i_4598 = G__4599;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__4581 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4581) : f.call(null,G__4581));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if(((s1) && (s2))){
return cljs.core.cons((function (){var G__4582 = cljs.core.first(s1);
var G__4583 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4582,G__4583) : f.call(null,G__4582,G__4583));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if(((s1) && (s2) && (s3))){
return cljs.core.cons((function (){var G__4584 = cljs.core.first(s1);
var G__4585 = cljs.core.first(s2);
var G__4586 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4584,G__4585,G__4586) : f.call(null,G__4584,G__4585,G__4586));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
}));

(cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
var step = (function cljs$core$step(cs){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__4568_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__4568_SHARP_);
}),step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c2,c1], 0))));
}));

/** @this {Function} */
(cljs.core.map.cljs$lang$applyTo = (function (seq4570){
var G__4571 = cljs.core.first(seq4570);
var seq4570__$1 = cljs.core.next(seq4570);
var G__4572 = cljs.core.first(seq4570__$1);
var seq4570__$2 = cljs.core.next(seq4570__$1);
var G__4573 = cljs.core.first(seq4570__$2);
var seq4570__$3 = cljs.core.next(seq4570__$2);
var G__4574 = cljs.core.first(seq4570__$3);
var seq4570__$4 = cljs.core.next(seq4570__$3);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4571,G__4572,G__4573,G__4574,seq4570__$4);
}));

(cljs.core.map.cljs$lang$maxFixedArity = (4));

/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 *   there are fewer than n.  Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.take = (function cljs$core$take(var_args){
var G__4601 = arguments.length;
switch (G__4601) {
case 1:
return cljs.core.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.take.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return (function() {
var G__4603 = null;
var G__4603__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__4603__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__4603__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));
var result__$1 = (((n__$1 > (0)))?(rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input)):result);
if((!((nn > (0))))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
G__4603 = function(result,input){
switch(arguments.length){
case 0:
return G__4603__0.call(this);
case 1:
return G__4603__1.call(this,result);
case 2:
return G__4603__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4603.cljs$core$IFn$_invoke$arity$0 = G__4603__0;
G__4603.cljs$core$IFn$_invoke$arity$1 = G__4603__1;
G__4603.cljs$core$IFn$_invoke$arity$2 = G__4603__2;
return G__4603;
})()
});
}));

(cljs.core.take.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (new cljs.core.LazySeq(null,(function (){
if((n > (0))){
var temp__5753__auto__ = cljs.core.seq(coll);
if(temp__5753__auto__){
var s = temp__5753__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.take.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of all but the first n items in coll.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function cljs$core$drop(var_args){
var G__4605 = arguments.length;
switch (G__4605) {
case 1:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return (function() {
var G__4607 = null;
var G__4607__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__4607__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__4607__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));

if((n__$1 > (0))){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__4607 = function(result,input){
switch(arguments.length){
case 0:
return G__4607__0.call(this);
case 1:
return G__4607__1.call(this,result);
case 2:
return G__4607__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4607.cljs$core$IFn$_invoke$arity$0 = G__4607__0;
G__4607.cljs$core$IFn$_invoke$arity$1 = G__4607__1;
G__4607.cljs$core$IFn$_invoke$arity$2 = G__4607__2;
return G__4607;
})()
});
}));

(cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error("Assert failed: (number? n)"));
}

var step = (function (n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if((((n__$1 > (0))) && (s))){
var G__4608 = (n__$1 - (1));
var G__4609 = cljs.core.rest(s);
n__$1 = G__4608;
coll__$1 = G__4609;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,(function (){
return step(n,coll);
}),null,null));
}));

(cljs.core.drop.cljs$lang$maxFixedArity = 2);

/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function cljs$core$drop_last(var_args){
var G__4611 = arguments.length;
switch (G__4611) {
case 1:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
}));

(cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = (function (n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
}));

(cljs.core.drop_last.cljs$lang$maxFixedArity = 2);

/**
 * Returns a seq of the last n items in coll.  Depending on the type
 *   of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__4613 = cljs.core.next(s);
var G__4614 = cljs.core.next(lead);
s = G__4613;
lead = G__4614;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 *   first item for which (pred item) returns logical false.  Returns a
 *   stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function cljs$core$drop_while(var_args){
var G__4616 = arguments.length;
switch (G__4616) {
case 1:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
var da = cljs.core.volatile_BANG_(true);
return (function() {
var G__4620 = null;
var G__4620__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__4620__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__4620__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__4149__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__4149__auto__)){
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input));
} else {
return and__4149__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__4620 = function(result,input){
switch(arguments.length){
case 0:
return G__4620__0.call(this);
case 1:
return G__4620__1.call(this,result);
case 2:
return G__4620__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4620.cljs$core$IFn$_invoke$arity$0 = G__4620__0;
G__4620.cljs$core$IFn$_invoke$arity$1 = G__4620__1;
G__4620.cljs$core$IFn$_invoke$arity$2 = G__4620__2;
return G__4620;
})()
});
}));

(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
var step = (function (pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__4149__auto__ = s;
if(and__4149__auto__){
var G__4618 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__4618) : pred__$1.call(null,G__4618));
} else {
return and__4149__auto__;
}
})())){
var G__4621 = pred__$1;
var G__4622 = cljs.core.rest(s);
pred__$1 = G__4621;
coll__$1 = G__4622;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,(function (){
return step(pred,coll);
}),null,null));
}));

(cljs.core.drop_while.cljs$lang$maxFixedArity = 2);


/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cycle = (function (meta,all,prev,current,_next){
this.meta = meta;
this.all = all;
this.prev = prev;
this.current = current;
this._next = _next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Cycle.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Cycle.prototype.currentval = (function (){
var self__ = this;
var coll = this;
if(self__.current){
} else {
var temp__5751__auto___4629 = cljs.core.next(self__.prev);
if(temp__5751__auto___4629){
var c_4630 = temp__5751__auto___4629;
(self__.current = c_4630);
} else {
(self__.current = self__.all);
}
}

return self__.current;
}));

(cljs.core.Cycle.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Cycle.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.Cycle.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Cycle.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.current == null)));
}));

(cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = cljs.core.first(s);
while(true){
var s__$1 = (function (){var or__4160__auto__ = cljs.core.next(s);
if(or__4160__auto__){
return or__4160__auto__;
} else {
return self__.all;
}
})();
var ret__$1 = (function (){var G__4625 = ret;
var G__4626 = cljs.core.first(s__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4625,G__4626) : f.call(null,G__4625,G__4626));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__4631 = s__$1;
var G__4632 = ret__$1;
s = G__4631;
ret = G__4632;
continue;
}
break;
}
}));

(cljs.core.Cycle.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
var s = coll__$1.currentval();
var ret = start;
while(true){
var ret__$1 = (function (){var G__4627 = ret;
var G__4628 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4627,G__4628) : f.call(null,G__4627,G__4628));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__4633 = (function (){var or__4160__auto__ = cljs.core.next(s);
if(or__4160__auto__){
return or__4160__auto__;
} else {
return self__.all;
}
})();
var G__4634 = ret__$1;
s = G__4633;
ret = G__4634;
continue;
}
break;
}
}));

(cljs.core.Cycle.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(coll__$1.currentval());
}));

(cljs.core.Cycle.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__._next == null)){
(self__._next = (new cljs.core.Cycle(null,self__.all,coll__$1.currentval(),null,null)));
} else {
}

return self__._next;
}));

(cljs.core.Cycle.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Cycle.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Cycle(new_meta,self__.all,self__.prev,self__.current,self__._next));
}
}));

(cljs.core.Cycle.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Cycle.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$all,cljs.core.cst$sym$prev,cljs.core.with_meta(cljs.core.cst$sym$current,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.Cycle.cljs$lang$type = true);

(cljs.core.Cycle.cljs$lang$ctorStr = "cljs.core/Cycle");

(cljs.core.Cycle.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/Cycle");
}));

/**
 * Positional factory function for cljs.core/Cycle.
 */
cljs.core.__GT_Cycle = (function cljs$core$__GT_Cycle(meta,all,prev,current,_next){
return (new cljs.core.Cycle(meta,all,prev,current,_next));
});

/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
var temp__5751__auto__ = cljs.core.seq(coll);
if(temp__5751__auto__){
var vals = temp__5751__auto__;
return (new cljs.core.Cycle(null,vals,null,vals,null));
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Repeat = (function (meta,count,val,next,__hash){
this.meta = meta;
this.count = count;
this.val = val;
this.next = next;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Repeat.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Repeat.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Repeat.prototype.indexOf = (function() {
var G__4635 = null;
var G__4635__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4635__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4635 = function(x,start){
switch(arguments.length){
case 1:
return G__4635__1.call(this,x);
case 2:
return G__4635__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4635.cljs$core$IFn$_invoke$arity$1 = G__4635__1;
G__4635.cljs$core$IFn$_invoke$arity$2 = G__4635__2;
return G__4635;
})()
);

(cljs.core.Repeat.prototype.lastIndexOf = (function() {
var G__4636 = null;
var G__4636__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,self__.count);
});
var G__4636__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4636 = function(x,start){
switch(arguments.length){
case 1:
return G__4636__1.call(this,x);
case 2:
return G__4636__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4636.cljs$core$IFn$_invoke$arity$1 = G__4636__1;
G__4636.cljs$core$IFn$_invoke$arity$2 = G__4636__2;
return G__4636;
})()
);

(cljs.core.Repeat.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Repeat.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
(self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null)));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return null;
}
}
} else {
return self__.next;
}
}));

(cljs.core.Repeat.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.Repeat.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Repeat.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Repeat.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return false;
}));

(cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(self__.val,self__.val) : f.call(null,self__.val,self__.val));
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var G__4637 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
ret = G__4637;
continue;
}
break;
}
} else {
var i = (1);
var ret = self__.val;
while(true){
if((i < self__.count)){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__4638 = (i + (1));
var G__4639 = ret__$1;
i = G__4638;
ret = G__4639;
continue;
}
} else {
return ret;
}
break;
}
}
}));

(cljs.core.Repeat.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
if((self__.count === (-1))){
var ret = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(start,self__.val) : f.call(null,start,self__.val));
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var G__4640 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
ret = G__4640;
continue;
}
break;
}
} else {
var i = (0);
var ret = start;
while(true){
if((i < self__.count)){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,self__.val) : f.call(null,ret,self__.val));
if(cljs.core.reduced_QMARK_(ret__$1)){
return cljs.core.deref(ret__$1);
} else {
var G__4641 = (i + (1));
var G__4642 = ret__$1;
i = G__4641;
ret = G__4642;
continue;
}
} else {
return ret;
}
break;
}
}
}));

(cljs.core.Repeat.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.val;
}));

(cljs.core.Repeat.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
if((self__.count > (1))){
(self__.next = (new cljs.core.Repeat(null,(self__.count - (1)),self__.val,null,null)));

return self__.next;
} else {
if(((-1) === self__.count)){
return coll__$1;
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return self__.next;
}
}));

(cljs.core.Repeat.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Repeat.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Repeat(new_meta,self__.count,self__.val,self__.next,null));
}
}));

(cljs.core.Repeat.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Repeat.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$count,cljs.core.cst$sym$val,cljs.core.with_meta(cljs.core.cst$sym$next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.Repeat.cljs$lang$type = true);

(cljs.core.Repeat.cljs$lang$ctorStr = "cljs.core/Repeat");

(cljs.core.Repeat.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/Repeat");
}));

/**
 * Positional factory function for cljs.core/Repeat.
 */
cljs.core.__GT_Repeat = (function cljs$core$__GT_Repeat(meta,count,val,next,__hash){
return (new cljs.core.Repeat(meta,count,val,next,__hash));
});

/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function cljs$core$repeat(var_args){
var G__4644 = arguments.length;
switch (G__4644) {
case 1:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.Repeat(null,(-1),x,null,null));
}));

(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = (function (n,x){
if((n > (0))){
return (new cljs.core.Repeat(null,n,x,null,null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.repeat.cljs$lang$maxFixedArity = 2);

/**
 * DEPRECATED: Use 'repeat' instead.
 *   Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 *   returns an infinite (or length n if supplied) lazy sequence of calls
 *   to it
 */
cljs.core.repeatedly = (function cljs$core$repeatedly(var_args){
var G__4647 = arguments.length;
switch (G__4647) {
case 1:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
}));

(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = (function (n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}));

(cljs.core.repeatedly.cljs$lang$maxFixedArity = 2);

cljs.core.UNREALIZED_SEED = ({});

/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Iterate = (function (meta,f,prev_seed,seed,next){
this.meta = meta;
this.f = f;
this.prev_seed = prev_seed;
this.seed = seed;
this.next = next;
this.cljs$lang$protocol_mask$partition0$ = 26083532;
this.cljs$lang$protocol_mask$partition1$ = 1;
});
(cljs.core.Iterate.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Iterate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Iterate.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ISeq$_rest$arity$1(null);
}));

(cljs.core.Iterate.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.Iterate.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (!((self__.seed === cljs.core.UNREALIZED_SEED)));
}));

(cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,rf){
var self__ = this;
var coll__$1 = this;
var first = coll__$1.cljs$core$ISeq$_first$arity$1(null);
var v = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(first) : self__.f.call(null,first));
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(first,v) : rf.call(null,first,v));
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var v__$2 = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null,v__$1));
var G__4649 = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret,v__$2) : rf.call(null,ret,v__$2));
var G__4650 = v__$2;
ret = G__4649;
v__$1 = G__4650;
continue;
}
break;
}
}));

(cljs.core.Iterate.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,rf,start){
var self__ = this;
var coll__$1 = this;
var v = coll__$1.cljs$core$ISeq$_first$arity$1(null);
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(start,v) : rf.call(null,start,v));
var v__$1 = v;
while(true){
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.deref(ret);
} else {
var v__$2 = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(v__$1) : self__.f.call(null,v__$1));
var G__4651 = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(ret,v__$2) : rf.call(null,ret,v__$2));
var G__4652 = v__$2;
ret = G__4651;
v__$1 = G__4652;
continue;
}
break;
}
}));

(cljs.core.Iterate.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.UNREALIZED_SEED === self__.seed)){
(self__.seed = (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(self__.prev_seed) : self__.f.call(null,self__.prev_seed)));
} else {
}

return self__.seed;
}));

(cljs.core.Iterate.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.next == null)){
(self__.next = (new cljs.core.Iterate(null,self__.f,coll__$1.cljs$core$ISeq$_first$arity$1(null),cljs.core.UNREALIZED_SEED,null)));
} else {
}

return self__.next;
}));

(cljs.core.Iterate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.Iterate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.Iterate(new_meta,self__.f,self__.prev_seed,self__.seed,self__.next));
}
}));

(cljs.core.Iterate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.Iterate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$f,cljs.core.cst$sym$prev_DASH_seed,cljs.core.with_meta(cljs.core.cst$sym$seed,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.Iterate.cljs$lang$type = true);

(cljs.core.Iterate.cljs$lang$ctorStr = "cljs.core/Iterate");

(cljs.core.Iterate.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/Iterate");
}));

/**
 * Positional factory function for cljs.core/Iterate.
 */
cljs.core.__GT_Iterate = (function cljs$core$__GT_Iterate(meta,f,prev_seed,seed,next){
return (new cljs.core.Iterate(meta,f,prev_seed,seed,next));
});

/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return (new cljs.core.Iterate(null,f,null,x,null));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 */
cljs.core.interleave = (function cljs$core$interleave(var_args){
var G__4657 = arguments.length;
switch (G__4657) {
case 0:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4659 = arguments.length;
var i__4772__auto___4660 = (0);
while(true){
if((i__4772__auto___4660 < len__4771__auto___4659)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4660]));

var G__4661 = (i__4772__auto___4660 + (1));
i__4772__auto___4660 = G__4661;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((2)),(0),null));
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4793__auto__);

}
});

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.List.EMPTY;
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$1 = (function (c1){
return (new cljs.core.LazySeq(null,(function (){
return c1;
}),null,null));
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if(((s1) && (s2))){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
}));

(cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = (function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
}));

/** @this {Function} */
(cljs.core.interleave.cljs$lang$applyTo = (function (seq4654){
var G__4655 = cljs.core.first(seq4654);
var seq4654__$1 = cljs.core.next(seq4654);
var G__4656 = cljs.core.first(seq4654__$1);
var seq4654__$2 = cljs.core.next(seq4654__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4655,G__4656,seq4654__$2);
}));

(cljs.core.interleave.cljs$lang$maxFixedArity = (2));

/**
 * Returns a lazy seq of the elements of coll separated by sep.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.interpose = (function cljs$core$interpose(var_args){
var G__4663 = arguments.length;
switch (G__4663) {
case 1:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = (function (sep){
return (function (rf){
var started = cljs.core.volatile_BANG_(false);
return (function() {
var G__4665 = null;
var G__4665__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__4665__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__4665__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,sep) : rf.call(null,result,sep));
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(sepr,input) : rf.call(null,sepr,input));
}
} else {
cljs.core.vreset_BANG_(started,true);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__4665 = function(result,input){
switch(arguments.length){
case 0:
return G__4665__0.call(this);
case 1:
return G__4665__1.call(this,result);
case 2:
return G__4665__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4665.cljs$core$IFn$_invoke$arity$0 = G__4665__0;
G__4665.cljs$core$IFn$_invoke$arity$1 = G__4665__1;
G__4665.cljs$core$IFn$_invoke$arity$2 = G__4665__2;
return G__4665;
})()
});
}));

(cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = (function (sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
}));

(cljs.core.interpose.cljs$lang$maxFixedArity = 2);

/**
 * Take a collection of collections, and return a lazy seq
 *   of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__5751__auto__ = cljs.core.seq(coll);
if(temp__5751__auto__){
var coll__$1 = temp__5751__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 *   to f and colls.  Thus function f should return a collection. Returns
 *   a transducer when no collections are provided
 */
cljs.core.mapcat = (function cljs$core$mapcat(var_args){
var G__4669 = arguments.length;
switch (G__4669) {
case 1:
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4671 = arguments.length;
var i__4772__auto___4672 = (0);
while(true){
if((i__4772__auto___4672 < len__4771__auto___4671)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4672]));

var G__4673 = (i__4772__auto___4672 + (1));
i__4772__auto___4672 = G__4673;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((1)),(0),null));
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4793__auto__);

}
});

(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
}));

(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = (function (f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
}));

/** @this {Function} */
(cljs.core.mapcat.cljs$lang$applyTo = (function (seq4667){
var G__4668 = cljs.core.first(seq4667);
var seq4667__$1 = cljs.core.next(seq4667);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4668,seq4667__$1);
}));

(cljs.core.mapcat.cljs$lang$maxFixedArity = (1));

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function cljs$core$filter(var_args){
var G__4675 = arguments.length;
switch (G__4675) {
case 1:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__4678 = null;
var G__4678__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__4678__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__4678__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return result;
}
});
G__4678 = function(result,input){
switch(arguments.length){
case 0:
return G__4678__0.call(this);
case 1:
return G__4678__1.call(this,result);
case 2:
return G__4678__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4678.cljs$core$IFn$_invoke$arity$0 = G__4678__0;
G__4678.cljs$core$IFn$_invoke$arity$1 = G__4678__1;
G__4678.cljs$core$IFn$_invoke$arity$2 = G__4678__2;
return G__4678;
})()
});
}));

(cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5753__auto__ = cljs.core.seq(coll);
if(temp__5753__auto__){
var s = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4648__auto___4679 = size;
var i_4680 = (0);
while(true){
if((i_4680 < n__4648__auto___4679)){
if(cljs.core.truth_((function (){var G__4676 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_4680);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__4676) : pred.call(null,G__4676));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_4680));
} else {
}

var G__4681 = (i_4680 + (1));
i_4680 = G__4681;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(f) : pred.call(null,f)))){
return cljs.core.cons(f,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.filter.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns logical false. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function cljs$core$remove(var_args){
var G__4683 = arguments.length;
switch (G__4683) {
case 1:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
}));

(cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
}));

(cljs.core.remove.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 *   branch? must be a fn of one arg that returns true if passed a node
 *   that can have children (but may not).  children must be a fn of one
 *   arg that returns a sequence of the children. Will only be called on
 *   nodes for which branch? returns true. Root is the root node of the
 *   tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(node,(cljs.core.truth_((branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : branch_QMARK_.call(null,node)))?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(node) : children.call(null,node))], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 *   etc.) and returns their contents as a single, flat sequence.
 *   (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__4685_SHARP_){
return (!(cljs.core.sequential_QMARK_(p1__4685_SHARP_)));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 *   from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function cljs$core$into(var_args){
var G__4687 = arguments.length;
switch (G__4687) {
case 0:
return cljs.core.into.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.into.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.into.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$1 = (function (to){
return to;
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
if((!((to == null)))){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,to,from);
}
}));

(cljs.core.into.cljs$core$IFn$_invoke$arity$3 = (function (to,xform,from){
if((((!((to == null))))?(((((to.cljs$lang$protocol_mask$partition1$ & (4))) || ((cljs.core.PROTOCOL_SENTINEL === to.cljs$core$IEditableCollection$))))?true:false):false)){
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
}));

(cljs.core.into.cljs$lang$maxFixedArity = 3);

/**
 * Returns a vector consisting of the result of applying f to the
 *   set of first items of each coll, followed by applying f to the set
 *   of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments.
 */
cljs.core.mapv = (function cljs$core$mapv(var_args){
var G__4697 = arguments.length;
switch (G__4697) {
case 2:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4699 = arguments.length;
var i__4772__auto___4700 = (0);
while(true){
if((i__4772__auto___4700 < len__4771__auto___4699)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4700]));

var G__4701 = (i__4772__auto___4700 + (1));
i__4772__auto___4700 = G__4701;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((4)),(0),null));
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4793__auto__);

}
});

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(o) : f.call(null,o)));
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
}));

(cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([colls], 0)));
}));

/** @this {Function} */
(cljs.core.mapv.cljs$lang$applyTo = (function (seq4692){
var G__4693 = cljs.core.first(seq4692);
var seq4692__$1 = cljs.core.next(seq4692);
var G__4694 = cljs.core.first(seq4692__$1);
var seq4692__$2 = cljs.core.next(seq4692__$1);
var G__4695 = cljs.core.first(seq4692__$2);
var seq4692__$3 = cljs.core.next(seq4692__$2);
var G__4696 = cljs.core.first(seq4692__$3);
var seq4692__$4 = cljs.core.next(seq4692__$3);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4693,G__4694,G__4695,G__4696,seq4692__$4);
}));

(cljs.core.mapv.cljs$lang$maxFixedArity = (4));

/**
 * Returns a vector of the items in coll for which
 *   (pred item) returns logical true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(o) : pred.call(null,o)))){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 *   apart. If step is not supplied, defaults to n, i.e. the partitions
 *   do not overlap. If a pad collection is supplied, use its elements as
 *   necessary to complete last partition up to n items. In case there are
 *   not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function cljs$core$partition(var_args){
var G__4703 = arguments.length;
switch (G__4703) {
case 2:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
}));

(cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5753__auto__ = cljs.core.seq(coll);
if(temp__5753__auto__){
var s = temp__5753__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__5753__auto__ = cljs.core.seq(coll);
if(temp__5753__auto__){
var s = temp__5753__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return (new cljs.core.List(null,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)),null,(1),null));
}
} else {
return null;
}
}),null,null));
}));

(cljs.core.partition.cljs$lang$maxFixedArity = 4);

/**
 * Returns the value in a nested associative structure,
 *   where ks is a sequence of keys. Returns nil if the key is not present,
 *   or the not-found value if supplied.
 */
cljs.core.get_in = (function cljs$core$get_in(var_args){
var G__4706 = arguments.length;
switch (G__4706) {
case 2:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = (function (m,ks){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.get,m,ks);
}));

(cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = (function (m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if((!((ks__$1 == null)))){
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__4708 = sentinel;
var G__4709 = m__$2;
var G__4710 = cljs.core.next(ks__$1);
sentinel = G__4708;
m__$1 = G__4709;
ks__$1 = G__4710;
continue;
}
} else {
return m__$1;
}
break;
}
}));

(cljs.core.get_in.cljs$lang$maxFixedArity = 3);

/**
 * Associates a value in a nested associative structure, where ks is a
 *   sequence of keys and v is the new value and returns a new nested structure.
 *   If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__4711,v){
var vec__4712 = p__4711;
var seq__4713 = cljs.core.seq(vec__4712);
var first__4714 = cljs.core.first(seq__4713);
var seq__4713__$1 = cljs.core.next(seq__4713);
var k = first__4714;
var ks = seq__4713__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__4715 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__4716 = ks;
var G__4717 = v;
return (cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3 ? cljs.core.assoc_in.cljs$core$IFn$_invoke$arity$3(G__4715,G__4716,G__4717) : cljs.core.assoc_in.call(null,G__4715,G__4716,G__4717));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 *   sequence of keys and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   nested structure.  If any levels do not exist, hash-maps will be
 *   created.
 */
cljs.core.update_in = (function cljs$core$update_in(var_args){
var G__4726 = arguments.length;
switch (G__4726) {
case 3:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4758 = arguments.length;
var i__4772__auto___4759 = (0);
while(true){
if((i__4772__auto___4759 < len__4771__auto___4758)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4759]));

var G__4760 = (i__4772__auto___4759 + (1));
i__4772__auto___4759 = G__4760;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((6)),(0),null));
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__4793__auto__);

}
});

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = (function (m,p__4727,f){
var vec__4728 = p__4727;
var seq__4729 = cljs.core.seq(vec__4728);
var first__4730 = cljs.core.first(seq__4729);
var seq__4729__$1 = cljs.core.next(seq__4729);
var k = first__4730;
var ks = seq__4729__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__4731 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4731) : f.call(null,G__4731));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = (function (m,p__4732,f,a){
var vec__4733 = p__4732;
var seq__4734 = cljs.core.seq(vec__4733);
var first__4735 = cljs.core.first(seq__4734);
var seq__4734__$1 = cljs.core.next(seq__4734);
var k = first__4735;
var ks = seq__4734__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__4736 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__4737 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4736,G__4737) : f.call(null,G__4736,G__4737));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = (function (m,p__4738,f,a,b){
var vec__4739 = p__4738;
var seq__4740 = cljs.core.seq(vec__4739);
var first__4741 = cljs.core.first(seq__4740);
var seq__4740__$1 = cljs.core.next(seq__4740);
var k = first__4741;
var ks = seq__4740__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__4742 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__4743 = a;
var G__4744 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4742,G__4743,G__4744) : f.call(null,G__4742,G__4743,G__4744));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = (function (m,p__4745,f,a,b,c){
var vec__4746 = p__4745;
var seq__4747 = cljs.core.seq(vec__4746);
var first__4748 = cljs.core.first(seq__4747);
var seq__4747__$1 = cljs.core.next(seq__4747);
var k = first__4748;
var ks = seq__4747__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__4749 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__4750 = a;
var G__4751 = b;
var G__4752 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__4749,G__4750,G__4751,G__4752) : f.call(null,G__4749,G__4750,G__4751,G__4752));
})());
}
}));

(cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,p__4753,f,a,b,c,args){
var vec__4754 = p__4753;
var seq__4755 = cljs.core.seq(vec__4754);
var first__4756 = cljs.core.first(seq__4755);
var seq__4755__$1 = cljs.core.next(seq__4755);
var k = first__4756;
var ks = seq__4755__$1;
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0)));
}
}));

/** @this {Function} */
(cljs.core.update_in.cljs$lang$applyTo = (function (seq4719){
var G__4720 = cljs.core.first(seq4719);
var seq4719__$1 = cljs.core.next(seq4719);
var G__4721 = cljs.core.first(seq4719__$1);
var seq4719__$2 = cljs.core.next(seq4719__$1);
var G__4722 = cljs.core.first(seq4719__$2);
var seq4719__$3 = cljs.core.next(seq4719__$2);
var G__4723 = cljs.core.first(seq4719__$3);
var seq4719__$4 = cljs.core.next(seq4719__$3);
var G__4724 = cljs.core.first(seq4719__$4);
var seq4719__$5 = cljs.core.next(seq4719__$4);
var G__4725 = cljs.core.first(seq4719__$5);
var seq4719__$6 = cljs.core.next(seq4719__$5);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4720,G__4721,G__4722,G__4723,G__4724,G__4725,seq4719__$6);
}));

(cljs.core.update_in.cljs$lang$maxFixedArity = (6));

/**
 * 'Updates' a value in an associative structure, where k is a
 *   key and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   structure.  If the key does not exist, nil is passed as the old value.
 */
cljs.core.update = (function cljs$core$update(var_args){
var G__4769 = arguments.length;
switch (G__4769) {
case 3:
return cljs.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___4781 = arguments.length;
var i__4772__auto___4782 = (0);
while(true){
if((i__4772__auto___4782 < len__4771__auto___4781)){
args_arr__4792__auto__.push((arguments[i__4772__auto___4782]));

var G__4783 = (i__4772__auto___4782 + (1));
i__4772__auto___4782 = G__4783;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((6)),(0),null));
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__4793__auto__);

}
});

(cljs.core.update.cljs$core$IFn$_invoke$arity$3 = (function (m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__4770 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__4770) : f.call(null,G__4770));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$4 = (function (m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__4771 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__4772 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4771,G__4772) : f.call(null,G__4771,G__4772));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$5 = (function (m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__4773 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__4774 = x;
var G__4775 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4773,G__4774,G__4775) : f.call(null,G__4773,G__4774,G__4775));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$6 = (function (m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__4776 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__4777 = x;
var G__4778 = y;
var G__4779 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__4776,G__4777,G__4778,G__4779) : f.call(null,G__4776,G__4777,G__4778,G__4779));
})());
}));

(cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([more], 0)));
}));

/** @this {Function} */
(cljs.core.update.cljs$lang$applyTo = (function (seq4762){
var G__4763 = cljs.core.first(seq4762);
var seq4762__$1 = cljs.core.next(seq4762);
var G__4764 = cljs.core.first(seq4762__$1);
var seq4762__$2 = cljs.core.next(seq4762__$1);
var G__4765 = cljs.core.first(seq4762__$2);
var seq4762__$3 = cljs.core.next(seq4762__$2);
var G__4766 = cljs.core.first(seq4762__$3);
var seq4762__$4 = cljs.core.next(seq4762__$3);
var G__4767 = cljs.core.first(seq4762__$4);
var seq4762__$5 = cljs.core.next(seq4762__$4);
var G__4768 = cljs.core.first(seq4762__$5);
var seq4762__$6 = cljs.core.next(seq4762__$5);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4763,G__4764,G__4765,G__4766,G__4767,G__4768,seq4762__$6);
}));

(cljs.core.update.cljs$lang$maxFixedArity = (6));


/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
});

(cljs.core.VectorNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$arr], null);
}));

(cljs.core.VectorNode.cljs$lang$type = true);

(cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode");

(cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/VectorNode");
}));

/**
 * Positional factory function for cljs.core/VectorNode.
 */
cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__4784 = (ll - (5));
var G__4785 = r;
ll = G__4784;
ret = G__4785;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if((!((child == null)))){
var node_to_insert = (function (){var G__4786 = pv;
var G__4787 = (level - (5));
var G__4788 = child;
var G__4789 = tailnode;
return (cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.push_tail.cljs$core$IFn$_invoke$arity$4(G__4786,G__4787,G__4788,G__4789) : cljs.core.push_tail.call(null,G__4786,G__4787,G__4788,G__4789));
})();
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error(["No item ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i)," in vector of length ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__4790 = cljs.core.pv_aget(node,(0));
var G__4791 = (level - (5));
node = G__4790;
level = G__4791;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__4792 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__4793 = (level - (5));
node = G__4792;
level = G__4793;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if(((((0) <= i)) && ((i < pv.cnt)))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(function (){var G__4794 = pv;
var G__4795 = (level - (5));
var G__4796 = cljs.core.pv_aget(node,subidx);
var G__4797 = i;
var G__4798 = val;
return (cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5 ? cljs.core.do_assoc.cljs$core$IFn$_invoke$arity$5(G__4794,G__4795,G__4796,G__4797,G__4798) : cljs.core.do_assoc.call(null,G__4794,G__4795,G__4796,G__4797,G__4798));
})());

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__4799 = pv;
var G__4800 = (level - (5));
var G__4801 = cljs.core.pv_aget(node,subidx);
return (cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pop_tail.cljs$core$IFn$_invoke$arity$3(G__4799,G__4800,G__4801) : cljs.core.pop_tail.call(null,G__4799,G__4800,G__4801));
})();
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
});
(cljs.core.RangedIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
}));

(cljs.core.RangedIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
(self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i));

(self__.base = (self__.base + (32)));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
(self__.i = (self__.i + (1)));

return ret;
}));

(cljs.core.RangedIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$base,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$v,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null);
}));

(cljs.core.RangedIterator.cljs$lang$type = true);

(cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator");

(cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/RangedIterator");
}));

/**
 * Positional factory function for cljs.core/RangedIterator.
 */
cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});
cljs.core.pv_reduce = (function cljs$core$pv_reduce(var_args){
var G__4803 = arguments.length;
switch (G__4803) {
case 4:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4 = (function (pv,f,start,end){
if((start < end)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(pv,f,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pv,start),(start + (1)),end);
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
}));

(cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5 = (function (pv,f,init,start,end){
var acc = init;
var i = start;
var arr = cljs.core.unchecked_array_for(pv,start);
while(true){
if((i < end)){
var j = (i & (31));
var arr__$1 = (((j === (0)))?cljs.core.unchecked_array_for(pv,i):arr);
var nacc = (function (){var G__4804 = acc;
var G__4805 = (arr__$1[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4804,G__4805) : f.call(null,G__4804,G__4805));
})();
if(cljs.core.reduced_QMARK_(nacc)){
return cljs.core.deref(nacc);
} else {
var G__4807 = nacc;
var G__4808 = (i + (1));
var G__4809 = arr__$1;
acc = G__4807;
i = G__4808;
arr = G__4809;
continue;
}
} else {
return acc;
}
break;
}
}));

(cljs.core.pv_reduce.cljs$lang$maxFixedArity = 5);








/**
 * Marker protocol
 * @interface
 */
cljs.core.APersistentVector = function(){};


/**
* @constructor
 * @implements {cljs.core.APersistentVector}
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
(cljs.core.PersistentVector.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (new cljs.core.MapEntry(n,(cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]),null));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentVector.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentVector.prototype.indexOf = (function() {
var G__4816 = null;
var G__4816__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4816__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4816 = function(x,start){
switch(arguments.length){
case 1:
return G__4816__1.call(this,x);
case 2:
return G__4816__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4816.cljs$core$IFn$_invoke$arity$1 = G__4816__1;
G__4816.cljs$core$IFn$_invoke$arity$2 = G__4816__2;
return G__4816;
})()
);

(cljs.core.PersistentVector.prototype.lastIndexOf = (function() {
var G__4817 = null;
var G__4817__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4817__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4817 = function(x,start){
switch(arguments.length){
case 1:
return G__4817__1.call(this,x);
case 2:
return G__4817__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4817.cljs$core$IFn$_invoke$arity$1 = G__4817__1;
G__4817.cljs$core$IFn$_invoke$arity$2 = G__4817__2;
return G__4817;
})()
);

(cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__4811 = init__$2;
var G__4812 = (j + i);
var G__4813 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4811,G__4812,G__4813) : f.call(null,G__4811,G__4812,G__4813));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__4818 = (j + (1));
var G__4819 = init__$3;
j = G__4818;
init__$2 = G__4819;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__4820 = (i + len);
var G__4821 = init__$2;
i = G__4820;
init__$1 = G__4821;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$APersistentVector$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return coll__$1.cljs$core$ICollection$_conj$arity$2(null,val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds  [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt),"]"].join('')));

}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,(self__.cnt - (1)));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if(((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null)))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = coll__$1.cljs$core$IIterable$_iterator$arity$1(null);
var you_iter = other.cljs$core$IIterable$_iterator$arity$1(null);
while(true){
if(me_iter.hasNext()){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,cljs.core.tv_editable_root(self__.root),cljs.core.tv_editable_tail(self__.tail)));
}));

(cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(v__$1,f,(0),self__.cnt);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__4814 = init__$2;
var G__4815 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__4814,G__4815) : f.call(null,G__4814,G__4815));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__4822 = (j + (1));
var G__4823 = init__$3;
j = G__4822;
init__$2 = G__4823;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__4824 = (i + len);
var G__4825 = init__$2;
i = G__4824;
init__$1 = G__4825;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.integer_QMARK_(k)){
return ((((0) <= k)) && ((k < self__.cnt)));
} else {
return false;
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0),null));
} else {
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(coll__$1,cljs.core.first_array_for_longvec(coll__$1),(0),(0));

}
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentVector(new_meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
}
}));

(cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__4648__auto___4826 = len;
var i_4827 = (0);
while(true){
if((i_4827 < n__4648__auto___4826)){
(new_tail[i_4827] = (self__.tail[i_4827]));

var G__4828 = (i_4827 + (1));
i_4827 = G__4828;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
}));

(cljs.core.PersistentVector.prototype.call = (function() {
var G__4829 = null;
var G__4829__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__4829__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__4829 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__4829__2.call(this,self__,k);
case 3:
return G__4829__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4829.cljs$core$IFn$_invoke$arity$2 = G__4829__2;
G__4829.cljs$core$IFn$_invoke$arity$3 = G__4829__3;
return G__4829;
})()
);

(cljs.core.PersistentVector.prototype.apply = (function (self__,args4810){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4810)));
}));

(cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.PersistentVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$shift,cljs.core.cst$sym$root,cljs.core.cst$sym$tail,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.PersistentVector.cljs$lang$type = true);

(cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector");

(cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/PersistentVector");
}));

/**
 * Positional factory function for cljs.core/PersistentVector.
 */
cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

(cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null])));
(cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash)));
(cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__4830 = (i + (1));
var G__4831 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__4830;
out = G__4831;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
}));
goog.object.set(cljs.core.PersistentVector.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 *   will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.map_entry_QMARK_(coll)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.key(coll),cljs.core.val(coll)], null);
} else {
if(cljs.core.vector_QMARK_(coll)){
return cljs.core.with_meta(coll,null);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));

}
}
}
});
/**
 * Creates a new vector containing the args.
 */
cljs.core.vector = (function cljs$core$vector(var_args){
var args__4777__auto__ = [];
var len__4771__auto___4833 = arguments.length;
var i__4772__auto___4834 = (0);
while(true){
if((i__4772__auto___4834 < len__4771__auto___4833)){
args__4777__auto__.push((arguments[i__4772__auto___4834]));

var G__4835 = (i__4772__auto___4834 + (1));
i__4772__auto___4834 = G__4835;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if((((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0))))){
return cljs.core.PersistentVector.fromArray(args.arr,(!(cljs.core.array_QMARK_(args.arr))));
} else {
return cljs.core.vec(args);
}
}));

(cljs.core.vector.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.vector.cljs$lang$applyTo = (function (seq4832){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq4832));
}));


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 1536;
});
(cljs.core.ChunkedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ChunkedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ChunkedSeq.prototype.indexOf = (function() {
var G__4836 = null;
var G__4836__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4836__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4836 = function(x,start){
switch(arguments.length){
case 1:
return G__4836__1.call(this,x);
case 2:
return G__4836__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4836.cljs$core$IFn$_invoke$arity$1 = G__4836__1;
G__4836.cljs$core$IFn$_invoke$arity$2 = G__4836__2;
return G__4836;
})()
);

(cljs.core.ChunkedSeq.prototype.lastIndexOf = (function() {
var G__4837 = null;
var G__4837__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4837__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4837 = function(x,start){
switch(arguments.length){
case 1:
return G__4837__1.call(this,x);
case 2:
return G__4837__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4837.cljs$core$IFn$_invoke$arity$1 = G__4837__1;
G__4837.cljs$core$IFn$_invoke$arity$2 = G__4837__2;
return G__4837;
})()
);

(cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,(self__.off + (1)));
if((s == null)){
return null;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedNext$_chunked_next$arity$1(null);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.vec,f,(self__.i + self__.off),cljs.core.count(self__.vec));
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.vec,f,start,(self__.i + self__.off),cljs.core.count(self__.vec));
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,self__.node,self__.i,(self__.off + (1)));
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return coll__$1.cljs$core$IChunkedSeq$_chunked_rest$arity$1(null);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,end),end,(0));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec,self__.node,self__.i,self__.off,new_meta);
}
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(self__.vec,cljs.core.unchecked_array_for(self__.vec,end),end,(0));
} else {
return null;
}
}));

(cljs.core.ChunkedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vec,cljs.core.cst$sym$node,cljs.core.cst$sym$i,cljs.core.cst$sym$off,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.ChunkedSeq.cljs$lang$type = true);

(cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq");

(cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/ChunkedSeq");
}));

/**
 * Positional factory function for cljs.core/ChunkedSeq.
 */
cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

goog.object.set(cljs.core.ChunkedSeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));
cljs.core.chunked_seq = (function cljs$core$chunked_seq(var_args){
var G__4839 = arguments.length;
switch (G__4839) {
case 3:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = (function (vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
}));

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = (function (vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
}));

(cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
}));

(cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5);


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(cljs.core.Subvec.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Subvec.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if((n < (0))){
return null;
} else {
var idx = (self__.start + n);
if((idx < self__.end)){
return (new cljs.core.MapEntry(n,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.v,idx),null));
} else {
return null;
}
}
}));

(cljs.core.Subvec.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.Subvec.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.Subvec.prototype.indexOf = (function() {
var G__4848 = null;
var G__4848__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4848__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__4848 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__4848__1.call(this,x);
case 2:
return G__4848__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4848.cljs$core$IFn$_invoke$arity$1 = G__4848__1;
G__4848.cljs$core$IFn$_invoke$arity$2 = G__4848__2;
return G__4848;
})()
);

(cljs.core.Subvec.prototype.lastIndexOf = (function() {
var G__4849 = null;
var G__4849__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4849__2 = (function (x,start__$1){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start__$1);
});
G__4849 = function(x,start__$1){
switch(arguments.length){
case 1:
return G__4849__1.call(this,x);
case 2:
return G__4849__2.call(this,x,start__$1);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4849.cljs$core$IFn$_invoke$arity$1 = G__4849__1;
G__4849.cljs$core$IFn$_invoke$arity$2 = G__4849__2;
return G__4849;
})()
);

(cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__4842 = init__$1;
var G__4843 = j;
var G__4844 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4842,G__4843,G__4844) : f.call(null,G__4842,G__4843,G__4844));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__4850 = (i + (1));
var G__4851 = (j + (1));
var G__4852 = init__$2;
i = G__4850;
j = G__4851;
init__$1 = G__4852;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((n < (0))) || ((self__.end <= (self__.start + n))))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
if((((n < (0))) || (((self__.end + (1)) <= v_pos)))){
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds [0,",cljs.core.str.cljs$core$IFn$_invoke$arity$1(coll__$1.cljs$core$ICounted$_count$arity$1(null)),"]"].join('')));
} else {
return cljs.core.build_subvec(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val),self__.start,(function (){var x__4249__auto__ = self__.end;
var y__4250__auto__ = (v_pos + (1));
return ((x__4249__auto__ > y__4250__auto__) ? x__4249__auto__ : y__4250__auto__);
})(),null);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.ranged_iterator(self__.v,self__.start,self__.end);
} else {
return cljs.core.seq_iter(coll__$1);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
}));

(cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
}));

(cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
return null;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
}
}));

(cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
return cljs.core.build_subvec(self__.meta,self__.v,self__.start,(self__.end - (1)),null);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((!((self__.start === self__.end)))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
}));

(cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$4(self__.v,f,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if((((!((self__.v == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === self__.v.cljs$core$APersistentVector$))))?true:false):false)){
return cljs.core.pv_reduce.cljs$core$IFn$_invoke$arity$5(self__.v,f,init,self__.start,self__.end);
} else {
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,init);
}
}));

(cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return coll__$1.cljs$core$IVector$_assoc_n$arity$3(null,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
}));

(cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = (function cljs$core$subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,(function (){
return cljs$core$subvec_seq((i + (1)));
}),null,null)));
}
});
return subvec_seq(self__.start);
}));

(cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return cljs.core.build_subvec(new_meta,self__.v,self__.start,self__.end,self__.__hash);
}
}));

(cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.build_subvec(self__.meta,cljs.core._assoc_n(self__.v,self__.end,o),self__.start,(self__.end + (1)),null);
}));

(cljs.core.Subvec.prototype.call = (function() {
var G__4853 = null;
var G__4853__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__4853__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__4853 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__4853__2.call(this,self__,k);
case 3:
return G__4853__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4853.cljs$core$IFn$_invoke$arity$2 = G__4853__2;
G__4853.cljs$core$IFn$_invoke$arity$3 = G__4853__3;
return G__4853;
})()
);

(cljs.core.Subvec.prototype.apply = (function (self__,args4841){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4841)));
}));

(cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.Subvec.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$v,cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.Subvec.cljs$lang$type = true);

(cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec");

(cljs.core.Subvec.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/Subvec");
}));

/**
 * Positional factory function for cljs.core/Subvec.
 */
cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

goog.object.set(cljs.core.Subvec.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__4854 = meta;
var G__4855 = v.v;
var G__4856 = (v.start + start);
var G__4857 = (v.start + end);
var G__4858 = __hash;
meta = G__4854;
v = G__4855;
start = G__4856;
end = G__4857;
__hash = G__4858;
continue;
} else {
if(cljs.core.vector_QMARK_(v)){
} else {
throw (new Error("v must satisfy IVector"));
}

if((((start < (0))) || ((end < start)) || ((end > cljs.core.count(v))))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 *   start (inclusive) to end (exclusive).  If end is not supplied,
 *   defaults to (count vector). This operation is O(1) and very fast, as
 *   the resulting vector shares structure with the original and no
 *   trimming is done.
 */
cljs.core.subvec = (function cljs$core$subvec(var_args){
var G__4860 = arguments.length;
switch (G__4860) {
case 2:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = (function (v,start){
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
}));

(cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = (function (v,start,end){
if((((!((start == null)))) && ((!((end == null)))))){
} else {
throw (new Error("Assert failed: (and (not (nil? start)) (not (nil? end)))"));
}

return cljs.core.build_subvec(null,v,(start | (0)),(end | (0)),null);
}));

(cljs.core.subvec.cljs$lang$maxFixedArity = 3);

cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode(({}),cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if((!((child == null)))){
var G__4864 = tv;
var G__4865 = (level - (5));
var G__4866 = child;
var G__4867 = tail_node;
return (cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tv_push_tail.cljs$core$IFn$_invoke$arity$4(G__4864,G__4865,G__4866,G__4867) : cljs.core.tv_push_tail.call(null,G__4864,G__4865,G__4866,G__4867));
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = (function (){var G__4868 = tv;
var G__4869 = (level - (5));
var G__4870 = cljs.core.pv_aget(node__$1,subidx);
return (cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tv_pop_tail.cljs$core$IFn$_invoke$arity$3(G__4868,G__4869,G__4870) : cljs.core.tv_pop_tail.call(null,G__4868,G__4869,G__4870));
})();
if((((new_child == null)) && ((subidx === (0))))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__4871 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__4872 = (level - (5));
node = G__4871;
level = G__4872;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientVector}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition1$ = 88;
this.cljs$lang$protocol_mask$partition0$ = 275;
});
(cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

(self__.tail = new_tail);

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

(self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array)));

(self__.shift = new_shift);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
(self__.root = new_root);

(self__.cnt = (self__.cnt + (1)));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
(self__.root.edit = null);

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return tcoll__$1.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(null,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((((0) <= n)) && ((n < self__.cnt)))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = (function (){var fexpr__4874 = (function cljs$core$go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});
return fexpr__4874(self__.shift,self__.root);
})();
(self__.root = new_root);

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return tcoll__$1.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,val);
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(n)," out of bounds for TransientVector of length",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
(self__.cnt = (0));

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
(self__.cnt = (self__.cnt - (1)));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if((!((nr == null)))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if(((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null)))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
(self__.root = new_root__$1);

(self__.shift = (self__.shift - (5)));

(self__.cnt = (self__.cnt - (1)));

(self__.tail = new_tail);

return tcoll__$1;
} else {
(self__.root = new_root);

(self__.cnt = (self__.cnt - (1)));

(self__.tail = new_tail);

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
}));

(cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((((0) <= n)) && ((n < self__.cnt)))){
return coll__$1.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
return not_found;
}
}));

(cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((!(self__.root.edit))){
throw (new Error("lookup after persistent!"));
} else {
if(typeof k === 'number'){
return coll__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
} else {
return not_found;

}
}
}));

(cljs.core.TransientVector.prototype.call = (function() {
var G__4875 = null;
var G__4875__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__4875__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__4875 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__4875__2.call(this,self__,k);
case 3:
return G__4875__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4875.cljs$core$IFn$_invoke$arity$2 = G__4875__2;
G__4875.cljs$core$IFn$_invoke$arity$3 = G__4875__3;
return G__4875;
})()
);

(cljs.core.TransientVector.prototype.apply = (function (self__,args4873){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4873)));
}));

(cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.TransientVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$shift,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$root,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$tail,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.TransientVector.cljs$lang$type = true);

(cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector");

(cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/TransientVector");
}));

/**
 * Positional factory function for cljs.core/TransientVector.
 */
cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueIter = (function (fseq,riter){
this.fseq = fseq;
this.riter = riter;
});
(cljs.core.PersistentQueueIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__4160__auto__ = (((!((self__.fseq == null)))) && (cljs.core.seq(self__.fseq)));
if(or__4160__auto__){
return or__4160__auto__;
} else {
if((!((self__.riter == null)))){
return self__.riter.hasNext();
} else {
return false;
}
}
}));

(cljs.core.PersistentQueueIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.fseq == null)))){
var ret = cljs.core.first(self__.fseq);
(self__.fseq = cljs.core.next(self__.fseq));

return ret;
} else {
if((((!((self__.riter == null)))) && (self__.riter.hasNext()))){
return self__.riter.next();
} else {
throw (new Error("No such element"));

}
}
}));

(cljs.core.PersistentQueueIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.PersistentQueueIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$fseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$riter], null);
}));

(cljs.core.PersistentQueueIter.cljs$lang$type = true);

(cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter");

(cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/PersistentQueueIter");
}));

/**
 * Positional factory function for cljs.core/PersistentQueueIter.
 */
cljs.core.__GT_PersistentQueueIter = (function cljs$core$__GT_PersistentQueueIter(fseq,riter){
return (new cljs.core.PersistentQueueIter(fseq,riter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850700;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentQueueSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentQueueSeq.prototype.indexOf = (function() {
var G__4876 = null;
var G__4876__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4876__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4876 = function(x,start){
switch(arguments.length){
case 1:
return G__4876__1.call(this,x);
case 2:
return G__4876__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4876.cljs$core$IFn$_invoke$arity$1 = G__4876__1;
G__4876.cljs$core$IFn$_invoke$arity$2 = G__4876__2;
return G__4876;
})()
);

(cljs.core.PersistentQueueSeq.prototype.lastIndexOf = (function() {
var G__4877 = null;
var G__4877__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4877__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4877 = function(x,start){
switch(arguments.length){
case 1:
return G__4877__1.call(this,x);
case 2:
return G__4877__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4877.cljs$core$IFn$_invoke$arity$1 = G__4877__1;
G__4877.cljs$core$IFn$_invoke$arity$2 = G__4877__2;
return G__4877;
})()
);

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__5751__auto__ = cljs.core.next(self__.front);
if(temp__5751__auto__){
var f1 = temp__5751__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((!((self__.rear == null)))){
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
} else {
return null;
}
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__5751__auto__ = cljs.core.next(self__.front);
if(temp__5751__auto__){
var f1 = temp__5751__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueueSeq(new_meta,self__.front,self__.rear,self__.__hash));
}
}));

(cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentQueueSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$front,cljs.core.cst$sym$rear,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.PersistentQueueSeq.cljs$lang$type = true);

(cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq");

(cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/PersistentQueueSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentQueueSeq.
 */
cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

goog.object.set(cljs.core.PersistentQueueSeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 139264;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
});
(cljs.core.PersistentQueue.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentQueue.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentQueue.prototype.indexOf = (function() {
var G__4878 = null;
var G__4878__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4878__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4878 = function(x,start){
switch(arguments.length){
case 1:
return G__4878__1.call(this,x);
case 2:
return G__4878__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4878.cljs$core$IFn$_invoke$arity$1 = G__4878__1;
G__4878.cljs$core$IFn$_invoke$arity$2 = G__4878__2;
return G__4878;
})()
);

(cljs.core.PersistentQueue.prototype.lastIndexOf = (function() {
var G__4879 = null;
var G__4879__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(self__.count.cljs$core$IFn$_invoke$arity$1 ? self__.count.cljs$core$IFn$_invoke$arity$1(coll) : self__.count.call(null,coll)));
});
var G__4879__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4879 = function(x,start){
switch(arguments.length){
case 1:
return G__4879__1.call(this,x);
case 2:
return G__4879__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4879.cljs$core$IFn$_invoke$arity$1 = G__4879__1;
G__4879.cljs$core$IFn$_invoke$arity$2 = G__4879__2;
return G__4879;
})()
);

(cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueIter(self__.front,cljs.core._iterator(self__.rear)));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__5751__auto__ = cljs.core.next(self__.front);
if(temp__5751__auto__){
var f1 = temp__5751__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__4160__auto__ = self__.front;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentQueue(new_meta,self__.count,self__.front,self__.rear,self__.__hash));
}
}));

(cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4160__auto__ = self__.rear;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
}));

(cljs.core.PersistentQueue.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$count,cljs.core.cst$sym$front,cljs.core.cst$sym$rear,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.PersistentQueue.cljs$lang$type = true);

(cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue");

(cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/PersistentQueue");
}));

/**
 * Positional factory function for cljs.core/PersistentQueue.
 */
cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

(cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash)));
goog.object.set(cljs.core.PersistentQueue.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition0$ = 2097152;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.NeverEquiv.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return false;
}));

(cljs.core.NeverEquiv.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
}));

(cljs.core.NeverEquiv.cljs$lang$type = true);

(cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv");

(cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/NeverEquiv");
}));

/**
 * Positional factory function for cljs.core/NeverEquiv.
 */
cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Test map equivalence. Returns true if x equals y, otherwise returns false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((((cljs.core.map_QMARK_(y)) && ((!(cljs.core.record_QMARK_(y))))))?(((cljs.core.count(x) === cljs.core.count(y)))?(((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition0$ & (1048576))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IKVReduce$))))?true:(((!x.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IKVReduce,x)))?cljs.core.reduce_kv((function (_,k,v){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,k,cljs.core.never_equiv),v)){
return true;
} else {
return cljs.core.reduced(false);
}
}),true,x):cljs.core.every_QMARK_((function (xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__4881 = (i + incr);
i = G__4881;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__4882 = (i + (1));
var G__4883 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,goog.object.get(so,k__$1));
i = G__4882;
out = G__4883;
continue;
} else {
return cljs.core._with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = ({});
var l = ks.length;
var i_4886 = (0);
while(true){
if((i_4886 < l)){
var k_4887 = (ks[i_4886]);
goog.object.set(new_obj,k_4887,goog.object.get(obj,k_4887));

var G__4888 = (i_4886 + (1));
i_4886 = G__4888;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
});
(cljs.core.ObjMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.ObjMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return (new cljs.core.MapEntry(k,(self__.strobj[k]),null));
} else {
return null;
}
}));

(cljs.core.ObjMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ObjMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return (self__.strobj[k]);
} else {
return not_found;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__4891 = init__$1;
var G__4892 = k;
var G__4893 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4891,G__4892,G__4893) : f.call(null,G__4891,G__4892,G__4893));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__4894 = cljs.core.rest(keys__$1);
var G__4895 = init__$2;
keys__$1 = G__4894;
init__$1 = G__4895;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
}));

(cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
}));

(cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
}));

(cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
}));

(cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'string'){
if((((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD)))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if((!((cljs.core.scan_array((1),k,self__.keys) == null)))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
goog.object.set(new_strobj,k,v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
goog.object.set(new_strobj,k,v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(((typeof k === 'string') && ((!((cljs.core.scan_array((1),k,self__.keys) == null)))))){
return true;
} else {
return false;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__4889_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__4889_SHARP_,(self__.strobj[p1__4889_SHARP_])],null));
}),self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
}));

(cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ObjMap(new_meta,self__.keys,self__.strobj,self__.update_count,self__.__hash));
}
}));

(cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
}));

(cljs.core.ObjMap.prototype.call = (function() {
var G__4896 = null;
var G__4896__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__4896__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__4896 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__4896__2.call(this,self__,k);
case 3:
return G__4896__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4896.cljs$core$IFn$_invoke$arity$2 = G__4896__2;
G__4896.cljs$core$IFn$_invoke$arity$3 = G__4896__3;
return G__4896;
})()
);

(cljs.core.ObjMap.prototype.apply = (function (self__,args4890){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4890)));
}));

(cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.ObjMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$keys,cljs.core.cst$sym$strobj,cljs.core.cst$sym$update_DASH_count,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.ObjMap.cljs$lang$type = true);

(cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap");

(cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/ObjMap");
}));

/**
 * Positional factory function for cljs.core/ObjMap.
 */
cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

(cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],({}),(0),cljs.core.empty_unordered_hash)));
(cljs.core.ObjMap.HASHMAP_THRESHOLD = (8));
(cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
}));

/**
* @constructor
*/
cljs.core.RecordIter = (function (i,record,base_count,fields,ext_map_iter){
this.i = i;
this.record = record;
this.base_count = base_count;
this.fields = fields;
this.ext_map_iter = ext_map_iter;
});
(cljs.core.RecordIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__4160__auto__ = (self__.i < self__.base_count);
if(or__4160__auto__){
return or__4160__auto__;
} else {
return self__.ext_map_iter.hasNext();
}
}));

(cljs.core.RecordIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((self__.i < self__.base_count)){
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.fields,self__.i);
(self__.i = (self__.i + (1)));

return (new cljs.core.MapEntry(k,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.record,k),null));
} else {
return self__.ext_map_iter.next();
}
}));

(cljs.core.RecordIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.RecordIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$record,cljs.core.cst$sym$base_DASH_count,cljs.core.cst$sym$fields,cljs.core.cst$sym$ext_DASH_map_DASH_iter], null);
}));

(cljs.core.RecordIter.cljs$lang$type = true);

(cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter");

(cljs.core.RecordIter.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/RecordIter");
}));

/**
 * Positional factory function for cljs.core/RecordIter.
 */
cljs.core.__GT_RecordIter = (function cljs$core$__GT_RecordIter(i,record,base_count,fields,ext_map_iter){
return (new cljs.core.RecordIter(i,record,base_count,fields,ext_map_iter));
});


/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
});
(cljs.core.ES6EntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var vec__4899 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4899,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4899,(1),null);
(self__.s = cljs.core.next(self__.s));

return ({"value": [k,v], "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6EntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.ES6EntriesIterator.cljs$lang$type = true);

(cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator");

(cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/ES6EntriesIterator");
}));

/**
 * Positional factory function for cljs.core/ES6EntriesIterator.
 */
cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
});
(cljs.core.ES6SetEntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!((self__.s == null)))){
var x = cljs.core.first(self__.s);
(self__.s = cljs.core.next(self__.s));

return ({"value": [x,x], "done": false});
} else {
return ({"value": null, "done": true});
}
}));

(cljs.core.ES6SetEntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.ES6SetEntriesIterator.cljs$lang$type = true);

(cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator");

(cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/ES6SetEntriesIterator");
}));

/**
 * Positional factory function for cljs.core/ES6SetEntriesIterator.
 */
cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_index_of_nil_QMARK_ = (function cljs$core$array_index_of_nil_QMARK_(arr){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__4902 = (i + (2));
i = G__4902;
continue;

}
}
break;
}
});
cljs.core.array_index_of_keyword_QMARK_ = (function cljs$core$array_index_of_keyword_QMARK_(arr,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Keyword)) && ((kstr === (arr[i]).fqn)))){
return i;
} else {
var G__4903 = (i + (2));
i = G__4903;
continue;

}
}
break;
}
});
cljs.core.array_index_of_symbol_QMARK_ = (function cljs$core$array_index_of_symbol_QMARK_(arr,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((((arr[i]) instanceof cljs.core.Symbol)) && ((kstr === (arr[i]).str)))){
return i;
} else {
var G__4904 = (i + (2));
i = G__4904;
continue;

}
}
break;
}
});
cljs.core.array_index_of_identical_QMARK_ = (function cljs$core$array_index_of_identical_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__4905 = (i + (2));
i = G__4905;
continue;

}
}
break;
}
});
cljs.core.array_index_of_equiv_QMARK_ = (function cljs$core$array_index_of_equiv_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__4906 = (i + (2));
i = G__4906;
continue;

}
}
break;
}
});
cljs.core.array_index_of = (function cljs$core$array_index_of(arr,k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_index_of_keyword_QMARK_(arr,k);
} else {
if(((typeof k === 'string') || (typeof k === 'number'))){
return cljs.core.array_index_of_identical_QMARK_(arr,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_index_of_symbol_QMARK_(arr,k);
} else {
if((k == null)){
return cljs.core.array_index_of_nil_QMARK_(arr);
} else {
return cljs.core.array_index_of_equiv_QMARK_(arr,k);

}
}
}
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
return cljs.core.array_index_of(m.arr,k);
});
cljs.core.array_extend_kv = (function cljs$core$array_extend_kv(arr,k,v){
var l = arr.length;
var narr = (new Array((l + (2))));
var i_4907 = (0);
while(true){
if((i_4907 < l)){
(narr[i_4907] = (arr[i_4907]));

var G__4908 = (i_4907 + (1));
i_4907 = G__4908;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
return cljs.core.array_extend_kv(m.arr,k,v);
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.MapEntry = (function (key,val,__hash){
this.key = key;
this.val = val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.MapEntry.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.MapEntry.prototype.cljs$core$IFind$_find$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
var G__4910 = k;
switch (G__4910) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.MapEntry.prototype.indexOf = (function() {
var G__4912 = null;
var G__4912__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4912__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4912 = function(x,start){
switch(arguments.length){
case 1:
return G__4912__1.call(this,x);
case 2:
return G__4912__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4912.cljs$core$IFn$_invoke$arity$1 = G__4912__1;
G__4912.cljs$core$IFn$_invoke$arity$2 = G__4912__2;
return G__4912;
})()
);

(cljs.core.MapEntry.prototype.lastIndexOf = (function() {
var G__4913 = null;
var G__4913__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4913__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4913 = function(x,start){
switch(arguments.length){
case 1:
return G__4913__1.call(this,x);
case 2:
return G__4913__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4913.cljs$core$IFn$_invoke$arity$1 = G__4913__1;
G__4913.cljs$core$IFn$_invoke$arity$2 = G__4913__2;
return G__4913;
})()
);

(cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.MapEntry.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.MapEntry.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.MapEntry.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.MapEntry.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.MapEntry.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.MapEntry.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.MapEntry.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.MapEntry.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.MapEntry.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.MapEntry.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.MapEntry.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.MapEntry.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.MapEntry.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.MapEntry.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.MapEntry.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.MapEntry.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.MapEntry.prototype.call = (function() {
var G__4914 = null;
var G__4914__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__4914__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__4914 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__4914__2.call(this,self__,k);
case 3:
return G__4914__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4914.cljs$core$IFn$_invoke$arity$2 = G__4914__2;
G__4914.cljs$core$IFn$_invoke$arity$3 = G__4914__3;
return G__4914;
})()
);

(cljs.core.MapEntry.prototype.apply = (function (self__,args4909){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4909)));
}));

(cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.MapEntry.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.MapEntry.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.MapEntry.cljs$lang$type = true);

(cljs.core.MapEntry.cljs$lang$ctorStr = "cljs.core/MapEntry");

(cljs.core.MapEntry.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/MapEntry");
}));

/**
 * Positional factory function for cljs.core/MapEntry.
 */
cljs.core.__GT_MapEntry = (function cljs$core$__GT_MapEntry(key,val,__hash){
return (new cljs.core.MapEntry(key,val,__hash));
});

/**
 * Returns true if x satisfies IMapEntry
 */
cljs.core.map_entry_QMARK_ = (function cljs$core$map_entry_QMARK_(x){
if((!((x == null)))){
if((((x.cljs$lang$protocol_mask$partition0$ & (2048))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$IMapEntry$)))){
return true;
} else {
return false;
}
} else {
return false;
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentArrayMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentArrayMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentArrayMapSeq.prototype.indexOf = (function() {
var G__4916 = null;
var G__4916__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__4916__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4916 = function(x,start){
switch(arguments.length){
case 1:
return G__4916__1.call(this,x);
case 2:
return G__4916__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4916.cljs$core$IFn$_invoke$arity$1 = G__4916__1;
G__4916.cljs$core$IFn$_invoke$arity$2 = G__4916__2;
return G__4916;
})()
);

(cljs.core.PersistentArrayMapSeq.prototype.lastIndexOf = (function() {
var G__4917 = null;
var G__4917__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__4917__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__4917 = function(x,start){
switch(arguments.length){
case 1:
return G__4917__1.call(this,x);
case 2:
return G__4917__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__4917.cljs$core$IFn$_invoke$arity$1 = G__4917__1;
G__4917.cljs$core$IFn$_invoke$arity$2 = G__4917__2;
return G__4917;
})()
);

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return null;
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
}
}));

(cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentArrayMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$_meta], null);
}));

(cljs.core.PersistentArrayMapSeq.cljs$lang$type = true);

(cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq");

(cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/PersistentArrayMapSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMapSeq.
 */
cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

goog.object.set(cljs.core.PersistentArrayMapSeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
});
(cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
}));

(cljs.core.PersistentArrayMapIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (new cljs.core.MapEntry((self__.arr[self__.i]),(self__.arr[(self__.i + (1))]),null));
(self__.i = (self__.i + (2)));

return ret;
}));

(cljs.core.PersistentArrayMapIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$cnt], null);
}));

(cljs.core.PersistentArrayMapIterator.cljs$lang$type = true);

(cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator");

(cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/PersistentArrayMapIterator");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMapIterator.
 */
cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
(cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return null;
} else {
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));
}
}));

(cljs.core.PersistentArrayMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentArrayMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentArrayMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.keys(coll));
}));

(cljs.core.PersistentArrayMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentArrayMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.vals(coll));
}));

(cljs.core.PersistentArrayMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentArrayMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentArrayMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__4919 = cljs.core.seq(coll);
var chunk__4920 = null;
var count__4921 = (0);
var i__4922 = (0);
while(true){
if((i__4922 < count__4921)){
var vec__4929 = chunk__4920.cljs$core$IIndexed$_nth$arity$2(null,i__4922);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4929,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4929,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__4941 = seq__4919;
var G__4942 = chunk__4920;
var G__4943 = count__4921;
var G__4944 = (i__4922 + (1));
seq__4919 = G__4941;
chunk__4920 = G__4942;
count__4921 = G__4943;
i__4922 = G__4944;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__4919);
if(temp__5753__auto__){
var seq__4919__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__4919__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__4919__$1);
var G__4945 = cljs.core.chunk_rest(seq__4919__$1);
var G__4946 = c__4591__auto__;
var G__4947 = cljs.core.count(c__4591__auto__);
var G__4948 = (0);
seq__4919 = G__4945;
chunk__4920 = G__4946;
count__4921 = G__4947;
i__4922 = G__4948;
continue;
} else {
var vec__4932 = cljs.core.first(seq__4919__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4932,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__4932,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__4949 = cljs.core.next(seq__4919__$1);
var G__4950 = null;
var G__4951 = (0);
var G__4952 = (0);
seq__4919 = G__4949;
chunk__4920 = G__4950;
count__4921 = G__4951;
i__4922 = G__4952;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__4935 = init__$1;
var G__4936 = (self__.arr[i]);
var G__4937 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4935,G__4936,G__4937) : f.call(null,G__4935,G__4936,G__4937));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return cljs.core.deref(init__$2);
} else {
var G__4953 = (i + (2));
var G__4954 = init__$2;
i = G__4953;
init__$1 = G__4954;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if(((cljs.core.map_QMARK_(other)) && ((!(cljs.core.record_QMARK_(other)))))){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if((!((v === cljs.core.lookup_sentinel)))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__4955 = (i + (2));
i = G__4955;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return false;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap(({}),self__.arr.length,cljs.core.aclone(self__.arr)));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.iter_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return coll__$1.cljs$core$IEmptyableCollection$_empty$arity$1(null);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__4956 = (s + (2));
var G__4957 = d;
s = G__4956;
d = G__4957;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__4958 = (s + (2));
var G__4959 = (d + (2));
s = G__4958;
d = G__4959;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__4940 = cljs.core.aclone(self__.arr);
(G__4940[(idx + (1))] = v);

return G__4940;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return (!((cljs.core.array_map_index_of(coll__$1,k) === (-1))));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentArrayMap(new_meta,self__.cnt,self__.arr,self__.__hash));
}
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__4960 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__4961 = cljs.core.next(es);
ret = G__4960;
es = G__4961;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentArrayMap.prototype.call = (function() {
var G__4962 = null;
var G__4962__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__4962__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__4962 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__4962__2.call(this,self__,k);
case 3:
return G__4962__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4962.cljs$core$IFn$_invoke$arity$2 = G__4962__2;
G__4962.cljs$core$IFn$_invoke$arity$3 = G__4962__3;
return G__4962;
})()
);

(cljs.core.PersistentArrayMap.prototype.apply = (function (self__,args4918){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4918)));
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.PersistentArrayMap.cljs$lang$type = true);

(cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap");

(cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/PersistentArrayMap");
}));

/**
 * Positional factory function for cljs.core/PersistentArrayMap.
 */
cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

(cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash)));
(cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8));
(cljs.core.PersistentArrayMap.fromArray = (function (arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var arr__$2 = ((no_check)?arr__$1:(function (){var ret = [];
var i_4963 = (0);
while(true){
if((i_4963 < arr__$1.length)){
var k_4964 = (arr__$1[i_4963]);
var v_4965 = (arr__$1[(i_4963 + (1))]);
var idx_4966 = cljs.core.array_index_of(ret,k_4964);
if((idx_4966 === (-1))){
ret.push(k_4964);

ret.push(v_4965);
} else {
}

var G__4967 = (i_4963 + (2));
i_4963 = G__4967;
continue;
} else {
}
break;
}

return ret;
})());
var cnt = (arr__$2.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$2,null));
}));
(cljs.core.PersistentArrayMap.createWithCheck = (function (arr){
var ret = [];
var i_4969 = (0);
while(true){
if((i_4969 < arr.length)){
var k_4970 = (arr[i_4969]);
var v_4971 = (arr[(i_4969 + (1))]);
var idx_4972 = cljs.core.array_index_of(ret,k_4970);
if((idx_4972 === (-1))){
var G__4968_4973 = ret;
G__4968_4973.push(k_4970);

G__4968_4973.push(v_4971);

} else {
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k_4970)].join('')));
}

var G__4974 = (i_4969 + (2));
i_4969 = G__4974;
continue;
} else {
}
break;
}

var cnt = (arr.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr,null));
}));
(cljs.core.PersistentArrayMap.createAsIfByAssoc = (function (arr){
var ret = [];
var i_4976 = (0);
while(true){
if((i_4976 < arr.length)){
var k_4977 = (arr[i_4976]);
var v_4978 = (arr[(i_4976 + (1))]);
var idx_4979 = cljs.core.array_index_of(ret,k_4977);
if((idx_4979 === (-1))){
var G__4975_4980 = ret;
G__4975_4980.push(k_4977);

G__4975_4980.push(v_4978);

} else {
(ret[(idx_4979 + (1))] = v_4978);
}

var G__4981 = (i_4976 + (2));
i_4976 = G__4981;
continue;
} else {
}
break;
}

return (new cljs.core.PersistentArrayMap(null,(ret.length / (2)),ret,null));
}));
goog.object.set(cljs.core.PersistentArrayMap.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
(cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
if(cljs.core.map_entry_QMARK_(o)){
return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,cljs.core.key(o),cljs.core.val(o));
} else {
if(cljs.core.vector_QMARK_(o)){
return tcoll__$1.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((0)) : o.call(null,(0))),(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((1)) : o.call(null,(1))));
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__5751__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__5751__auto__)){
var e = temp__5751__auto__;
var G__4984 = cljs.core.next(es);
var G__4985 = cljs.core._assoc_BANG_(tcoll__$2,cljs.core.key(e),cljs.core.val(e));
es = G__4984;
tcoll__$2 = G__4985;
continue;
} else {
return tcoll__$2;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
(self__.editable_QMARK_ = false);

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
(self__.len = (self__.len + (2)));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(cljs.core.array__GT_transient_hash_map(self__.len,self__.arr),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(self__.editable_QMARK_){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__4983_4986 = self__.arr;
G__4983_4986.pop();

G__4983_4986.pop();


(self__.len = (self__.len - (2)));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
}));

(cljs.core.TransientArrayMap.prototype.call = (function() {
var G__4987 = null;
var G__4987__2 = (function (self__,key){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,null);
});
var G__4987__3 = (function (self__,key,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
});
G__4987 = function(self__,key,not_found){
switch(arguments.length){
case 2:
return G__4987__2.call(this,self__,key);
case 3:
return G__4987__3.call(this,self__,key,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__4987.cljs$core$IFn$_invoke$arity$2 = G__4987__2;
G__4987.cljs$core$IFn$_invoke$arity$3 = G__4987__3;
return G__4987;
})()
);

(cljs.core.TransientArrayMap.prototype.apply = (function (self__,args4982){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args4982)));
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (key){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,null);
}));

(cljs.core.TransientArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (key,not_found){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
}));

(cljs.core.TransientArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$editable_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$len,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$arr], null);
}));

(cljs.core.TransientArrayMap.cljs$lang$type = true);

(cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap");

(cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/TransientArrayMap");
}));

/**
 * Positional factory function for cljs.core/TransientArrayMap.
 */
cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});

cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__4988 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__4989 = (i + (2));
out = G__4988;
i = G__4989;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
});

(cljs.core.Box.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.Box.cljs$lang$type = true);

(cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box");

(cljs.core.Box.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/Box");
}));

/**
 * Positional factory function for cljs.core/Box.
 */
cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});






cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function cljs$core$clone_and_set(var_args){
var G__4991 = arguments.length;
switch (G__4991) {
case 3:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = (function (arr,i,a){
var G__4992 = cljs.core.aclone(arr);
(G__4992[i] = a);

return G__4992;
}));

(cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = (function (arr,i,a,j,b){
var G__4993 = cljs.core.aclone(arr);
(G__4993[i] = a);

(G__4993[j] = b);

return G__4993;
}));

(cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5);

cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function cljs$core$edit_and_set(var_args){
var G__4996 = arguments.length;
switch (G__4996) {
case 4:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = (function (inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
}));

(cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = (function (inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
}));

(cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6);

cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if((!((k == null)))){
var G__4998 = init__$1;
var G__4999 = k;
var G__5000 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__4998,G__4999,G__5000) : f.call(null,G__4998,G__4999,G__5000));
} else {
var node = (arr[(i + (1))]);
if((!((node == null)))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
var G__5001 = (i + (2));
var G__5002 = init__$2;
i = G__5001;
init__$1 = G__5002;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.NodeIterator = (function (arr,i,next_entry,next_iter){
this.arr = arr;
this.i = i;
this.next_entry = next_entry;
this.next_iter = next_iter;
});
(cljs.core.NodeIterator.prototype.advance = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((self__.i < len)){
var key = (self__.arr[self__.i]);
var node_or_val = (self__.arr[(self__.i + (1))]);
var found = (((!((key == null))))?(self__.next_entry = (new cljs.core.MapEntry(key,node_or_val,null))):(((!((node_or_val == null))))?(function (){var new_iter = cljs.core._iterator(node_or_val);
if(new_iter.hasNext()){
return (self__.next_iter = new_iter);
} else {
return false;
}
})():false
));
(self__.i = (self__.i + (2)));

if(found){
return true;
} else {
continue;
}
} else {
return false;
}
break;
}
}));

(cljs.core.NodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var or__4160__auto__ = (!((self__.next_entry == null)));
if(or__4160__auto__){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = (!((self__.next_iter == null)));
if(or__4160__auto____$1){
return or__4160__auto____$1;
} else {
return this$.advance();
}
}
}));

(cljs.core.NodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if((!((self__.next_entry == null)))){
var ret = self__.next_entry;
(self__.next_entry = null);

return ret;
} else {
if((!((self__.next_iter == null)))){
var ret = self__.next_iter.next();
if(self__.next_iter.hasNext()){
} else {
(self__.next_iter = null);
}

return ret;
} else {
if(this$.advance()){
return this$.next();
} else {
throw (new Error("No such element"));

}
}
}
}));

(cljs.core.NodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.NodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_entry,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.NodeIterator.cljs$lang$type = true);

(cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator");

(cljs.core.NodeIterator.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/NodeIterator");
}));

/**
 * Positional factory function for cljs.core/NodeIterator.
 */
cljs.core.__GT_NodeIterator = (function cljs$core$__GT_NodeIterator(arr,i,next_entry,next_iter){
return (new cljs.core.NodeIterator(arr,i,next_entry,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_.val = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
(editable.bitmap = (bit ^ editable.bitmap));

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
}));

(cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
}));

(cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(added_leaf_QMARK_.val = true);

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

(editable.bitmap = (editable.bitmap | bit));

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_5003 = (0);
var j_5004 = (0);
while(true){
if((i_5003 < (32))){
if((((self__.bitmap >>> i_5003) & (1)) === (0))){
var G__5005 = (i_5003 + (1));
var G__5006 = j_5004;
i_5003 = G__5005;
j_5004 = G__5006;
continue;
} else {
(nodes[i_5003] = (((!(((self__.arr[j_5004]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_5004])),(self__.arr[j_5004]),(self__.arr[(j_5004 + (1))]),added_leaf_QMARK_):(self__.arr[(j_5004 + (1))])));

var G__5007 = (i_5003 + (1));
var G__5008 = (j_5004 + (2));
i_5003 = G__5007;
j_5004 = G__5008;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

(added_leaf_QMARK_.val = true);

var editable = inode.ensure_editable(edit__$1);
(editable.arr = new_arr);

(editable.bitmap = (editable.bitmap | bit));

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
(added_leaf_QMARK_.val = true);

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(edit__$1,(shift + (5)),key_or_nil,val_or_node,hash,key,val));

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_5009 = (0);
var j_5010 = (0);
while(true){
if((i_5009 < (32))){
if((((self__.bitmap >>> i_5009) & (1)) === (0))){
var G__5011 = (i_5009 + (1));
var G__5012 = j_5010;
i_5009 = G__5011;
j_5010 = G__5012;
continue;
} else {
(nodes[i_5009] = (((!(((self__.arr[j_5010]) == null))))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_5010])),(self__.arr[j_5010]),(self__.arr[(j_5010 + (1))]),added_leaf_QMARK_):(self__.arr[(j_5010 + (1))])));

var G__5013 = (i_5009 + (1));
var G__5014 = (j_5010 + (2));
i_5009 = G__5013;
j_5010 = G__5014;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

(added_leaf_QMARK_.val = true);

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
(added_leaf_QMARK_.val = true);

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((shift + (5)),key_or_nil,val_or_node,hash,key,val))));

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.MapEntry(key_or_nil,val_or_node,null));
} else {
return not_found;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if((!((n == null)))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
} else {
return inode;

}
}
}
}));

(cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
}));

(cljs.core.BitmapIndexedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$bitmap,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.BitmapIndexedNode.cljs$lang$type = true);

(cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode");

(cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/BitmapIndexedNode");
}));

/**
 * Positional factory function for cljs.core/BitmapIndexedNode.
 */
cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

(cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[])));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((((!((i === idx)))) && ((!(((arr[i]) == null)))))){
(new_arr[j] = (arr[i]));

var G__5015 = (i + (1));
var G__5016 = (j + (2));
var G__5017 = (bitmap | ((1) << i));
i = G__5015;
j = G__5016;
bitmap = G__5017;
continue;
} else {
var G__5018 = (i + (1));
var G__5019 = j;
var G__5020 = bitmap;
i = G__5018;
j = G__5019;
bitmap = G__5020;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNodeIterator = (function (arr,i,next_iter){
this.arr = arr;
this.i = i;
this.next_iter = next_iter;
});
(cljs.core.ArrayNodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((!((((!((self__.next_iter == null)))) && (self__.next_iter.hasNext()))))){
if((self__.i < len)){
var node = (self__.arr[self__.i]);
(self__.i = (self__.i + (1)));

if((!((node == null)))){
(self__.next_iter = cljs.core._iterator(node));
} else {
}

continue;
} else {
return false;
}
} else {
return true;
}
break;
}
}));

(cljs.core.ArrayNodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
return self__.next_iter.next();
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.ArrayNodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.ArrayNodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.ArrayNodeIterator.cljs$lang$type = true);

(cljs.core.ArrayNodeIterator.cljs$lang$ctorStr = "cljs.core/ArrayNodeIterator");

(cljs.core.ArrayNodeIterator.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/ArrayNodeIterator");
}));

/**
 * Positional factory function for cljs.core/ArrayNodeIterator.
 */
cljs.core.__GT_ArrayNodeIterator = (function cljs$core$__GT_ArrayNodeIterator(arr,i,next_iter){
return (new cljs.core.ArrayNodeIterator(arr,i,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
}));

(cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
(editable.cnt = (editable.cnt - (1)));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
}));

(cljs.core.ArrayNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
}));

(cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if((!((node == null)))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
var G__5021 = (i + (1));
var G__5022 = init__$2;
i = G__5021;
init__$1 = G__5022;
continue;
}
} else {
var G__5023 = (i + (1));
var G__5024 = init__$1;
i = G__5023;
init__$1 = G__5024;
continue;
}
} else {
return init__$1;
}
break;
}
}));

(cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
}));

(cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
(editable.cnt = (editable.cnt + (1)));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
}));

(cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
}));

(cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
}));

(cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((!((node == null)))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
}));

(cljs.core.ArrayNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeIterator(self__.arr,(0),null));
}));

(cljs.core.ArrayNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.ArrayNode.cljs$lang$type = true);

(cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode");

(cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/ArrayNode");
}));

/**
 * Positional factory function for cljs.core/ArrayNode.
 */
cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__5025 = (i + (2));
i = G__5025;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 131072;
this.cljs$lang$protocol_mask$partition0$ = 0;
});
(cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
}));

(cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_.val = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

(editable.cnt = (editable.cnt - (1)));

return editable;
}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr);
}));

(cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
}));

(cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
(added_leaf_QMARK_.val = true);

(editable.cnt = (editable.cnt + (1)));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

(added_leaf_QMARK_.val = true);

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
}));

(cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

(added_leaf_QMARK_.val = true);

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(idx + (1))]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
}));

(cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
(self__.arr = array);

(self__.cnt = count);

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
}));

(cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (new cljs.core.MapEntry((self__.arr[idx]),(self__.arr[(idx + (1))]),null));
} else {
return not_found;

}
}
}));

(cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
}));

(cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
}));

(cljs.core.HashCollisionNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$collision_DASH_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.HashCollisionNode.cljs$lang$type = true);

(cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode");

(cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/HashCollisionNode");
}));

/**
 * Positional factory function for cljs.core/HashCollisionNode.
 */
cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function cljs$core$create_node(var_args){
var G__5027 = arguments.length;
switch (G__5027) {
case 6:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
}));

(cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
}));

(cljs.core.create_node.cljs$lang$maxFixedArity = 7);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.NodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.NodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.NodeSeq.prototype.indexOf = (function() {
var G__5029 = null;
var G__5029__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__5029__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__5029 = function(x,start){
switch(arguments.length){
case 1:
return G__5029__1.call(this,x);
case 2:
return G__5029__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5029.cljs$core$IFn$_invoke$arity$1 = G__5029__1;
G__5029.cljs$core$IFn$_invoke$arity$2 = G__5029__2;
return G__5029;
})()
);

(cljs.core.NodeSeq.prototype.lastIndexOf = (function() {
var G__5030 = null;
var G__5030__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__5030__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__5030 = function(x,start){
switch(arguments.length){
case 1:
return G__5030__1.call(this,x);
case 2:
return G__5030__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5030.cljs$core$IFn$_invoke$arity$1 = G__5030__1;
G__5030.cljs$core$IFn$_invoke$arity$2 = G__5030__2;
return G__5030;
})()
);

(cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.NodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,(self__.i + (2)),null);
} else {
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return (new cljs.core.MapEntry((self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))]),null));
} else {
return cljs.core.first(self__.s);
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var ret = (((self__.s == null))?cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,(self__.i + (2)),null):cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s)));
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.NodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
}));

(cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.NodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$nodes,cljs.core.cst$sym$i,cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.NodeSeq.cljs$lang$type = true);

(cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq");

(cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/NodeSeq");
}));

/**
 * Positional factory function for cljs.core/NodeSeq.
 */
cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

goog.object.set(cljs.core.NodeSeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));
cljs.core.create_inode_seq = (function cljs$core$create_inode_seq(var_args){
var G__5032 = arguments.length;
switch (G__5032) {
case 1:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
}));

(cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if((!(((nodes[j]) == null)))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__5751__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__5751__auto__)){
var node = temp__5751__auto__;
var temp__5751__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__5751__auto____$1)){
var node_seq = temp__5751__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__5034 = (j + (2));
j = G__5034;
continue;
}
} else {
var G__5035 = (j + (2));
j = G__5035;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
}));

(cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ArrayNodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ArrayNodeSeq.prototype.indexOf = (function() {
var G__5036 = null;
var G__5036__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__5036__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__5036 = function(x,start){
switch(arguments.length){
case 1:
return G__5036__1.call(this,x);
case 2:
return G__5036__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5036.cljs$core$IFn$_invoke$arity$1 = G__5036__1;
G__5036.cljs$core$IFn$_invoke$arity$2 = G__5036__2;
return G__5036;
})()
);

(cljs.core.ArrayNodeSeq.prototype.lastIndexOf = (function() {
var G__5037 = null;
var G__5037__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__5037__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__5037 = function(x,start){
switch(arguments.length){
case 1:
return G__5037__1.call(this,x);
case 2:
return G__5037__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5037.cljs$core$IFn$_invoke$arity$1 = G__5037__1;
G__5037.cljs$core$IFn$_invoke$arity$2 = G__5037__2;
return G__5037;
})()
);

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var ret = cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(self__.nodes,self__.i,cljs.core.next(self__.s));
if((!((ret == null)))){
return ret;
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.ArrayNodeSeq(new_meta,self__.nodes,self__.i,self__.s,self__.__hash));
}
}));

(cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.ArrayNodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$nodes,cljs.core.cst$sym$i,cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.ArrayNodeSeq.cljs$lang$type = true);

(cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq");

(cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/ArrayNodeSeq");
}));

/**
 * Positional factory function for cljs.core/ArrayNodeSeq.
 */
cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

goog.object.set(cljs.core.ArrayNodeSeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));
cljs.core.create_array_node_seq = (function cljs$core$create_array_node_seq(var_args){
var G__5039 = arguments.length;
switch (G__5039) {
case 1:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
}));

(cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__5751__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__5751__auto__)){
var nj = temp__5751__auto__;
var temp__5751__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__5751__auto____$1)){
var ns = temp__5751__auto____$1;
return (new cljs.core.ArrayNodeSeq(null,nodes,(j + (1)),ns,null));
} else {
var G__5041 = (j + (1));
j = G__5041;
continue;
}
} else {
var G__5042 = (j + (1));
j = G__5042;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(null,nodes,i,s,null));
}
}));

(cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 3);


/**
* @constructor
*/
cljs.core.HashMapIter = (function (nil_val,root_iter,seen){
this.nil_val = nil_val;
this.root_iter = root_iter;
this.seen = seen;
});
(cljs.core.HashMapIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (((!(self__.seen))) || (self__.root_iter.hasNext()));
}));

(cljs.core.HashMapIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((!(self__.seen))){
(self__.seen = true);

return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return self__.root_iter.next();
}
}));

(cljs.core.HashMapIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.HashMapIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$nil_DASH_val,cljs.core.cst$sym$root_DASH_iter,cljs.core.with_meta(cljs.core.cst$sym$seen,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.HashMapIter.cljs$lang$type = true);

(cljs.core.HashMapIter.cljs$lang$ctorStr = "cljs.core/HashMapIter");

(cljs.core.HashMapIter.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/HashMapIter");
}));

/**
 * Positional factory function for cljs.core/HashMapIter.
 */
cljs.core.__GT_HashMapIter = (function cljs$core$__GT_HashMapIter(nil_val,root_iter,seen){
return (new cljs.core.HashMapIter(nil_val,root_iter,seen));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
(cljs.core.PersistentHashMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentHashMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.MapEntry(null,self__.nil_val,null));
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_find((0),cljs.core.hash(k),k,null);

}
}
}));

(cljs.core.PersistentHashMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentHashMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentHashMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.keys(coll));
}));

(cljs.core.PersistentHashMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentHashMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.vals(coll));
}));

(cljs.core.PersistentHashMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentHashMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentHashMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__5044 = cljs.core.seq(coll);
var chunk__5045 = null;
var count__5046 = (0);
var i__5047 = (0);
while(true){
if((i__5047 < count__5046)){
var vec__5054 = chunk__5045.cljs$core$IIndexed$_nth$arity$2(null,i__5047);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5054,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5054,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__5062 = seq__5044;
var G__5063 = chunk__5045;
var G__5064 = count__5046;
var G__5065 = (i__5047 + (1));
seq__5044 = G__5062;
chunk__5045 = G__5063;
count__5046 = G__5064;
i__5047 = G__5065;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__5044);
if(temp__5753__auto__){
var seq__5044__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__5044__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__5044__$1);
var G__5066 = cljs.core.chunk_rest(seq__5044__$1);
var G__5067 = c__4591__auto__;
var G__5068 = cljs.core.count(c__4591__auto__);
var G__5069 = (0);
seq__5044 = G__5066;
chunk__5045 = G__5067;
count__5046 = G__5068;
i__5047 = G__5069;
continue;
} else {
var vec__5057 = cljs.core.first(seq__5044__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5057,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5057,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__5070 = cljs.core.next(seq__5044__$1);
var G__5071 = null;
var G__5072 = (0);
var G__5073 = (0);
seq__5044 = G__5070;
chunk__5045 = G__5071;
count__5046 = G__5072;
i__5047 = G__5073;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(init,null,self__.nil_val) : f.call(null,init,null,self__.nil_val)):init);
if(cljs.core.reduced_QMARK_(init__$1)){
return cljs.core.deref(init__$1);
} else {
if((!((self__.root == null)))){
return cljs.core.unreduced(self__.root.kv_reduce(f,init__$1));
} else {
return init__$1;

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var root_iter = ((self__.root)?cljs.core._iterator(self__.root):cljs.core.nil_iter());
if(self__.has_nil_QMARK_){
return (new cljs.core.HashMapIter(self__.nil_val,root_iter,false));
} else {
return root_iter;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap(({}),self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(((self__.has_nil_QMARK_) && ((v === self__.nil_val)))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return (!((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)));

}
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = (((!((self__.root == null))))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons((new cljs.core.MapEntry(null,self__.nil_val,null)),s);
} else {
return s;
}
} else {
return null;
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(new_meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
}
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__5074 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__5075 = cljs.core.next(es);
ret = G__5074;
es = G__5075;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentHashMap.prototype.call = (function() {
var G__5076 = null;
var G__5076__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__5076__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__5076 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__5076__2.call(this,self__,k);
case 3:
return G__5076__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__5076.cljs$core$IFn$_invoke$arity$2 = G__5076__2;
G__5076.cljs$core$IFn$_invoke$arity$3 = G__5076__3;
return G__5076;
})()
);

(cljs.core.PersistentHashMap.prototype.apply = (function (self__,args5043){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args5043)));
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$root,cljs.core.with_meta(cljs.core.cst$sym$has_DASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)),cljs.core.cst$sym$nil_DASH_val,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.PersistentHashMap.cljs$lang$type = true);

(cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap");

(cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/PersistentHashMap");
}));

/**
 * Positional factory function for cljs.core/PersistentHashMap.
 */
cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

(cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash)));
(cljs.core.PersistentHashMap.fromArray = (function (arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__5077 = (i + (2));
var G__5078 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__5077;
ret = G__5078;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
}));
(cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__5079 = (i + (1));
var G__5080 = cljs.core._assoc_BANG_(out,(ks[i]),(vs[i]));
i = G__5079;
out = G__5080;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}));
(cljs.core.PersistentHashMap.createWithCheck = (function (arr){
var len = arr.length;
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i_5081 = (0);
while(true){
if((i_5081 < len)){
cljs.core._assoc_BANG_(ret,(arr[i_5081]),(arr[(i_5081 + (1))]));

if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core._count(ret),((i_5081 / (2)) + (1)))){
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((arr[i_5081]))].join('')));
} else {
var G__5082 = (i_5081 + (2));
i_5081 = G__5082;
continue;
}
} else {
}
break;
}

return cljs.core._persistent_BANG_(ret);
}));
goog.object.set(cljs.core.PersistentHashMap.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 56;
});
(cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if(cljs.core.map_entry_QMARK_(o)){
return tcoll.assoc_BANG_(cljs.core.key(o),cljs.core.val(o));
} else {
if(cljs.core.vector_QMARK_(o)){
return tcoll.assoc_BANG_((o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((0)) : o.call(null,(0))),(o.cljs$core$IFn$_invoke$arity$1 ? o.cljs$core$IFn$_invoke$arity$1((1)) : o.call(null,(1))));
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__5751__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__5751__auto__)){
var e = temp__5751__auto__;
var G__5084 = cljs.core.next(es);
var G__5085 = tcoll__$1.assoc_BANG_(cljs.core.key(e),cljs.core.val(e));
es = G__5084;
tcoll__$1 = G__5085;
continue;
} else {
return tcoll__$1;
}
break;
}

}
}
} else {
throw (new Error("conj! after persistent"));
}
}));

(cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
(self__.nil_val = v);
}

if(self__.has_nil_QMARK_){
} else {
(self__.count = (self__.count + (1)));

(self__.has_nil_QMARK_ = true);
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
(self__.root = node);
}

if(added_leaf_QMARK_.val){
(self__.count = (self__.count + (1)));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
(self__.has_nil_QMARK_ = false);

(self__.nil_val = null);

(self__.count = (self__.count - (1)));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
(self__.root = node);
}

if(removed_leaf_QMARK_.val){
(self__.count = (self__.count - (1)));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var self__ = this;
var tcoll = this;
if(self__.edit){
(self__.edit = null);

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
}));

(cljs.core.TransientHashMap.prototype.call = (function() {
var G__5086 = null;
var G__5086__2 = (function (self__,key){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$2(null,key);
});
var G__5086__3 = (function (self__,key,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
});
G__5086 = function(self__,key,not_found){
switch(arguments.length){
case 2:
return G__5086__2.call(this,self__,key);
case 3:
return G__5086__3.call(this,self__,key,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__5086.cljs$core$IFn$_invoke$arity$2 = G__5086__2;
G__5086.cljs$core$IFn$_invoke$arity$3 = G__5086__3;
return G__5086;
})()
);

(cljs.core.TransientHashMap.prototype.apply = (function (self__,args5083){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args5083)));
}));

(cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (key){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$2(null,key);
}));

(cljs.core.TransientHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (key,not_found){
var self__ = this;
var tcoll = this;
return tcoll.cljs$core$ILookup$_lookup$arity$3(null,key,not_found);
}));

(cljs.core.TransientHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$edit,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$root,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$has_DASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$nil_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.TransientHashMap.cljs$lang$type = true);

(cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap");

(cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/TransientHashMap");
}));

/**
 * Positional factory function for cljs.core/TransientHashMap.
 */
cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if((!((t == null)))){
var G__5087 = ((ascending_QMARK_)?t.left:t.right);
var G__5088 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__5087;
stack__$1 = G__5088;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentTreeMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentTreeMapSeq.prototype.indexOf = (function() {
var G__5089 = null;
var G__5089__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__5089__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__5089 = function(x,start){
switch(arguments.length){
case 1:
return G__5089__1.call(this,x);
case 2:
return G__5089__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5089.cljs$core$IFn$_invoke$arity$1 = G__5089__1;
G__5089.cljs$core$IFn$_invoke$arity$2 = G__5089__2;
return G__5089;
})()
);

(cljs.core.PersistentTreeMapSeq.prototype.lastIndexOf = (function() {
var G__5090 = null;
var G__5090__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__5090__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__5090 = function(x,start){
switch(arguments.length){
case 1:
return G__5090__1.call(this,x);
case 2:
return G__5090__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5090.cljs$core$IFn$_invoke$arity$1 = G__5090__1;
G__5090.cljs$core$IFn$_invoke$arity$2 = G__5090__2;
return G__5090;
})()
);

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if((next_stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if((!((next_stack == null)))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMapSeq(new_meta,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
}
}));

(cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.PersistentTreeMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$stack,cljs.core.with_meta(cljs.core.cst$sym$ascending_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)),cljs.core.cst$sym$cnt,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.PersistentTreeMapSeq.cljs$lang$type = true);

(cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq");

(cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/PersistentTreeMapSeq");
}));

/**
 * Positional factory function for cljs.core/PersistentTreeMapSeq.
 */
cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

goog.object.set(cljs.core.PersistentTreeMapSeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if((((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if((((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode)))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = (((!((node.left == null))))?(function (){var G__5091 = node.left;
var G__5092 = f;
var G__5093 = init;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__5091,G__5092,G__5093) : cljs.core.tree_map_kv_reduce.call(null,G__5091,G__5092,G__5093));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
return init__$1;
} else {
var init__$2 = (function (){var G__5094 = init__$1;
var G__5095 = node.key;
var G__5096 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__5094,G__5095,G__5096) : f.call(null,G__5094,G__5095,G__5096));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return init__$2;
} else {
if((!((node.right == null)))){
var G__5097 = node.right;
var G__5098 = f;
var G__5099 = init__$2;
return (cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.tree_map_kv_reduce.cljs$core$IFn$_invoke$arity$3(G__5097,G__5098,G__5099) : cljs.core.tree_map_kv_reduce.call(null,G__5097,G__5098,G__5099));
} else {
return init__$2;
}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.BlackNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.BlackNode.prototype.cljs$core$IFind$_find$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
var G__5101 = k;
switch (G__5101) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.BlackNode.prototype.lastIndexOf = (function() {
var G__5103 = null;
var G__5103__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__5103__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__5103 = function(x,start){
switch(arguments.length){
case 1:
return G__5103__1.call(this,x);
case 2:
return G__5103__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5103.cljs$core$IFn$_invoke$arity$1 = G__5103__1;
G__5103.cljs$core$IFn$_invoke$arity$2 = G__5103__2;
return G__5103;
})()
);

(cljs.core.BlackNode.prototype.indexOf = (function() {
var G__5104 = null;
var G__5104__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__5104__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__5104 = function(x,start){
switch(arguments.length){
case 1:
return G__5104__1.call(this,x);
case 2:
return G__5104__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5104.cljs$core$IFn$_invoke$arity$1 = G__5104__1;
G__5104.cljs$core$IFn$_invoke$arity$2 = G__5104__2;
return G__5104;
})()
);

(cljs.core.BlackNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
}));

(cljs.core.BlackNode.prototype.redden = (function (){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
}));

(cljs.core.BlackNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return node;
}));

(cljs.core.BlackNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
}));

(cljs.core.BlackNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
}));

(cljs.core.BlackNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
}));

(cljs.core.BlackNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
}));

(cljs.core.BlackNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
}));

(cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
}));

(cljs.core.BlackNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
}));

(cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.BlackNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.BlackNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.BlackNode.prototype.call = (function() {
var G__5105 = null;
var G__5105__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__5105__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__5105 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__5105__2.call(this,self__,k);
case 3:
return G__5105__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__5105.cljs$core$IFn$_invoke$arity$2 = G__5105__2;
G__5105.cljs$core$IFn$_invoke$arity$3 = G__5105__3;
return G__5105;
})()
);

(cljs.core.BlackNode.prototype.apply = (function (self__,args5100){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args5100)));
}));

(cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.BlackNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$left,cljs.core.cst$sym$right,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.BlackNode.cljs$lang$type = true);

(cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode");

(cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/BlackNode");
}));

/**
 * Positional factory function for cljs.core/BlackNode.
 */
cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

goog.object.set(cljs.core.BlackNode.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 166619935;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.RedNode.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.RedNode.prototype.cljs$core$IFind$_find$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
var G__5107 = k;
switch (G__5107) {
case (0):
return (new cljs.core.MapEntry((0),self__.key,null));

break;
case (1):
return (new cljs.core.MapEntry((1),self__.val,null));

break;
default:
return null;

}
}));

(cljs.core.RedNode.prototype.lastIndexOf = (function() {
var G__5109 = null;
var G__5109__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__5109__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__5109 = function(x,start){
switch(arguments.length){
case 1:
return G__5109__1.call(this,x);
case 2:
return G__5109__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5109.cljs$core$IFn$_invoke$arity$1 = G__5109__1;
G__5109.cljs$core$IFn$_invoke$arity$2 = G__5109__2;
return G__5109;
})()
);

(cljs.core.RedNode.prototype.indexOf = (function() {
var G__5110 = null;
var G__5110__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__5110__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__5110 = function(x,start){
switch(arguments.length){
case 1:
return G__5110__1.call(this,x);
case 2:
return G__5110__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5110.cljs$core$IFn$_invoke$arity$1 = G__5110__1;
G__5110.cljs$core$IFn$_invoke$arity$2 = G__5110__2;
return G__5110;
})()
);

(cljs.core.RedNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
}));

(cljs.core.RedNode.prototype.redden = (function (){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
}));

(cljs.core.RedNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
}));

(cljs.core.RedNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
}));

(cljs.core.RedNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
}));

(cljs.core.RedNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
}));

(cljs.core.RedNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
}));

(cljs.core.RedNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
}));

(cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
}));

(cljs.core.RedNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
}));

(cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,null);
}));

(cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return node__$1.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
throw (new Error("Index out of bounds"));

}
}
}));

(cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
}));

(cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
}));

(cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
}));

(cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
}));

(cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
}));

(cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
}));

(cljs.core.RedNode.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.val,self__.key],(0),null));
}));

(cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
}));

(cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
}));

(cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
}));

(cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
}));

(cljs.core.RedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return (((k === (0))) || ((k === (1))));
}));

(cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (new cljs.core.IndexedSeq([self__.key,self__.val],(0),null));
}));

(cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core._with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
}));

(cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
}));

(cljs.core.RedNode.prototype.call = (function() {
var G__5111 = null;
var G__5111__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__5111__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__5111 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__5111__2.call(this,self__,k);
case 3:
return G__5111__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__5111.cljs$core$IFn$_invoke$arity$2 = G__5111__2;
G__5111.cljs$core$IFn$_invoke$arity$3 = G__5111__3;
return G__5111;
})()
);

(cljs.core.RedNode.prototype.apply = (function (self__,args5106){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args5106)));
}));

(cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$2(null,k);
}));

(cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
}));

(cljs.core.RedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$left,cljs.core.cst$sym$right,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.RedNode.cljs$lang$type = true);

(cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode");

(cljs.core.RedNode.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/RedNode");
}));

/**
 * Positional factory function for cljs.core/RedNode.
 */
cljs.core.__GT_RedNode = (function cljs$core$__GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

goog.object.set(cljs.core.RedNode.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));
cljs.core.tree_map_add = (function cljs$core$tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = (function (){var G__5112 = k;
var G__5113 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__5112,G__5113) : comp.call(null,G__5112,G__5113));
})();
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = (function (){var G__5114 = comp;
var G__5115 = tree.left;
var G__5116 = k;
var G__5117 = v;
var G__5118 = found;
return (cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5 ? cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5(G__5114,G__5115,G__5116,G__5117,G__5118) : cljs.core.tree_map_add.call(null,G__5114,G__5115,G__5116,G__5117,G__5118));
})();
if((!((ins == null)))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = (function (){var G__5119 = comp;
var G__5120 = tree.right;
var G__5121 = k;
var G__5122 = v;
var G__5123 = found;
return (cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5 ? cljs.core.tree_map_add.cljs$core$IFn$_invoke$arity$5(G__5119,G__5120,G__5121,G__5122,G__5123) : cljs.core.tree_map_add.call(null,G__5119,G__5120,G__5121,G__5122,G__5123));
})();
if((!((ins == null)))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function cljs$core$tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = (function (){var G__5124 = left.right;
var G__5125 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__5124,G__5125) : cljs.core.tree_map_append.call(null,G__5124,G__5125));
})();
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(function (){var G__5126 = left.right;
var G__5127 = right;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__5126,G__5127) : cljs.core.tree_map_append.call(null,G__5126,G__5127));
})(),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,(function (){var G__5128 = left;
var G__5129 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__5128,G__5129) : cljs.core.tree_map_append.call(null,G__5128,G__5129));
})(),right.right,null));
} else {
var app = (function (){var G__5130 = left.right;
var G__5131 = right.left;
return (cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2 ? cljs.core.tree_map_append.cljs$core$IFn$_invoke$arity$2(G__5130,G__5131) : cljs.core.tree_map_append.call(null,G__5130,G__5131));
})();
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del(left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function cljs$core$tree_map_remove(comp,tree,k,found){
if((!((tree == null)))){
var c = (function (){var G__5132 = k;
var G__5133 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__5132,G__5133) : comp.call(null,G__5132,G__5133));
})();
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append(tree.left,tree.right);
} else {
if((c < (0))){
var del = (function (){var G__5134 = comp;
var G__5135 = tree.left;
var G__5136 = k;
var G__5137 = found;
return (cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4(G__5134,G__5135,G__5136,G__5137) : cljs.core.tree_map_remove.call(null,G__5134,G__5135,G__5136,G__5137));
})();
if((((!((del == null)))) || ((!(((found[(0)]) == null)))))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del(tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = (function (){var G__5138 = comp;
var G__5139 = tree.right;
var G__5140 = k;
var G__5141 = found;
return (cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_remove.cljs$core$IFn$_invoke$arity$4(G__5138,G__5139,G__5140,G__5141) : cljs.core.tree_map_remove.call(null,G__5138,G__5139,G__5140,G__5141));
})();
if((((!((del == null)))) || ((!(((found[(0)]) == null)))))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del(tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function cljs$core$tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(k,tk) : comp.call(null,k,tk));
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,(function (){var G__5142 = comp;
var G__5143 = tree.left;
var G__5144 = k;
var G__5145 = v;
return (cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4(G__5142,G__5143,G__5144,G__5145) : cljs.core.tree_map_replace.call(null,G__5142,G__5143,G__5144,G__5145));
})(),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,(function (){var G__5146 = comp;
var G__5147 = tree.right;
var G__5148 = k;
var G__5149 = v;
return (cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4 ? cljs.core.tree_map_replace.cljs$core$IFn$_invoke$arity$4(G__5146,G__5147,G__5148,G__5149) : cljs.core.tree_map_replace.call(null,G__5146,G__5147,G__5148,G__5149));
})());

}
}
});

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IFind}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.PersistentTreeMap.prototype.cljs$core$IFind$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentTreeMap.prototype.cljs$core$IFind$_find$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.entry_at(k);
}));

(cljs.core.PersistentTreeMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__5151 = cljs.core.seq(coll);
var chunk__5152 = null;
var count__5153 = (0);
var i__5154 = (0);
while(true){
if((i__5154 < count__5153)){
var vec__5161 = chunk__5152.cljs$core$IIndexed$_nth$arity$2(null,i__5154);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5161,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5161,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__5173 = seq__5151;
var G__5174 = chunk__5152;
var G__5175 = count__5153;
var G__5176 = (i__5154 + (1));
seq__5151 = G__5173;
chunk__5152 = G__5174;
count__5153 = G__5175;
i__5154 = G__5176;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__5151);
if(temp__5753__auto__){
var seq__5151__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__5151__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__5151__$1);
var G__5177 = cljs.core.chunk_rest(seq__5151__$1);
var G__5178 = c__4591__auto__;
var G__5179 = cljs.core.count(c__4591__auto__);
var G__5180 = (0);
seq__5151 = G__5177;
chunk__5152 = G__5178;
count__5153 = G__5179;
i__5154 = G__5180;
continue;
} else {
var vec__5164 = cljs.core.first(seq__5151__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5164,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5164,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__5181 = cljs.core.next(seq__5151__$1);
var G__5182 = null;
var G__5183 = (0);
var G__5184 = (0);
seq__5151 = G__5181;
chunk__5152 = G__5182;
count__5153 = G__5183;
i__5154 = G__5184;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentTreeMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentTreeMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentTreeMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentTreeMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.keys(coll));
}));

(cljs.core.PersistentTreeMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.vals(coll));
}));

(cljs.core.PersistentTreeMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var self__ = this;
var coll = this;
var t = self__.tree;
while(true){
if((!((t == null)))){
var c = (function (){var G__5167 = k;
var G__5168 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__5167,G__5168) : self__.comp.call(null,G__5167,G__5168));
})();
if((c === (0))){
return t;
} else {
if((c < (0))){
var G__5185 = t.left;
t = G__5185;
continue;
} else {
var G__5186 = t.right;
t = G__5186;
continue;

}
}
} else {
return null;
}
break;
}
}));

(cljs.core.PersistentTreeMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,k,null);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var n = coll__$1.entry_at(k);
if((!((n == null)))){
return n.val;
} else {
return not_found;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if((!((self__.tree == null)))){
return cljs.core.unreduced(cljs.core.tree_map_kv_reduce(self__.tree,f,init));
} else {
return init;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,self__.meta,self__.__hash));
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,false,self__.cnt);
} else {
return null;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,(0)));
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_remove(self__.comp,self__.tree,k,found);
if((t == null)){
if((cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0)) == null)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt - (1)),self__.meta,null));
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_add(self__.comp,self__.tree,k,v,found);
if((t == null)){
var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,found_node.val)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,cljs.core.tree_map_replace(self__.comp,self__.tree,k,v),self__.cnt,self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt + (1)),self__.meta,null));
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return (!((coll__$1.entry_at(k) == null)));
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,true,self__.cnt);
} else {
return null;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,new_meta,self__.__hash));
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return coll__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__5187 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__5188 = cljs.core.next(es);
ret = G__5187;
es = G__5188;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
}));

(cljs.core.PersistentTreeMap.prototype.call = (function() {
var G__5189 = null;
var G__5189__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__5189__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__5189 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__5189__2.call(this,self__,k);
case 3:
return G__5189__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__5189.cljs$core$IFn$_invoke$arity$2 = G__5189__2;
G__5189.cljs$core$IFn$_invoke$arity$3 = G__5189__3;
return G__5189;
})()
);

(cljs.core.PersistentTreeMap.prototype.apply = (function (self__,args5150){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args5150)));
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if((!((t == null)))){
var c = (function (){var G__5171 = k;
var G__5172 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__5171,G__5172) : self__.comp.call(null,G__5171,G__5172));
})();
if((c === (0))){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__5190 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__5191 = t.left;
stack = G__5190;
t = G__5191;
continue;
} else {
var G__5192 = stack;
var G__5193 = t.right;
stack = G__5192;
t = G__5193;
continue;
}
} else {
if((c > (0))){
var G__5194 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__5195 = t.right;
stack = G__5194;
t = G__5195;
continue;
} else {
var G__5196 = stack;
var G__5197 = t.left;
stack = G__5196;
t = G__5197;
continue;
}

}
}
} else {
if((stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,stack,ascending_QMARK_,(-1),null));
}
}
break;
}
} else {
return null;
}
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return cljs.core.key(entry);
}));

(cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.comp;
}));

(cljs.core.PersistentTreeMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$tree,cljs.core.cst$sym$cnt,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.PersistentTreeMap.cljs$lang$type = true);

(cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap");

(cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/PersistentTreeMap");
}));

/**
 * Positional factory function for cljs.core/PersistentTreeMap.
 */
cljs.core.__GT_PersistentTreeMap = (function cljs$core$__GT_PersistentTreeMap(comp,tree,cnt,meta,__hash){
return (new cljs.core.PersistentTreeMap(comp,tree,cnt,meta,__hash));
});

(cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,(0),null,cljs.core.empty_unordered_hash)));
goog.object.set(cljs.core.PersistentTreeMap.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));
/**
 * keyval => key val
 *   Returns a new hash map with supplied mappings.
 */
cljs.core.hash_map = (function cljs$core$hash_map(var_args){
var args__4777__auto__ = [];
var len__4771__auto___5199 = arguments.length;
var i__4772__auto___5200 = (0);
while(true){
if((i__4772__auto___5200 < len__4771__auto___5199)){
args__4777__auto__.push((arguments[i__4772__auto___5200]));

var G__5201 = (i__4772__auto___5200 + (1));
i__4772__auto___5200 = G__5201;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in$){
var G__5202 = cljs.core.nnext(in$);
var G__5203 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__5202;
out = G__5203;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}));

(cljs.core.hash_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.hash_map.cljs$lang$applyTo = (function (seq5198){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq5198));
}));

/**
 * keyval => key val
 *   Returns a new array map with supplied mappings.
 */
cljs.core.array_map = (function cljs$core$array_map(var_args){
var args__4777__auto__ = [];
var len__4771__auto___5205 = arguments.length;
var i__4772__auto___5206 = (0);
while(true){
if((i__4772__auto___5206 < len__4771__auto___5205)){
args__4777__auto__.push((arguments[i__4772__auto___5206]));

var G__5207 = (i__4772__auto___5206 + (1));
i__4772__auto___5206 = G__5207;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var arr = (((((keyvals instanceof cljs.core.IndexedSeq)) && ((keyvals.i === (0)))))?keyvals.arr:cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(keyvals));
return cljs.core.PersistentArrayMap.createAsIfByAssoc(arr);
}));

(cljs.core.array_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.array_map.cljs$lang$applyTo = (function (seq5204){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq5204));
}));

/**
 * keyval => key val
 *   Returns a new object map with supplied mappings.
 */
cljs.core.obj_map = (function cljs$core$obj_map(var_args){
var args__4777__auto__ = [];
var len__4771__auto___5211 = arguments.length;
var i__4772__auto___5212 = (0);
while(true){
if((i__4772__auto___5212 < len__4771__auto___5211)){
args__4777__auto__.push((arguments[i__4772__auto___5212]));

var G__5213 = (i__4772__auto___5212 + (1));
i__4772__auto___5212 = G__5213;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var ks = [];
var obj = ({});
var kvs = cljs.core.seq(keyvals);
while(true){
if(kvs){
ks.push(cljs.core.first(kvs));

goog.object.set(obj,cljs.core.first(kvs),cljs.core.second(kvs));

var G__5214 = cljs.core.nnext(kvs);
kvs = G__5214;
continue;
} else {
return cljs.core.ObjMap.fromObject(ks,obj);
}
break;
}
}));

(cljs.core.obj_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.obj_map.cljs$lang$applyTo = (function (seq5208){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq5208));
}));

/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings.
 */
cljs.core.sorted_map = (function cljs$core$sorted_map(var_args){
var args__4777__auto__ = [];
var len__4771__auto___5216 = arguments.length;
var i__4772__auto___5217 = (0);
while(true){
if((i__4772__auto___5217 < len__4771__auto___5216)){
args__4777__auto__.push((arguments[i__4772__auto___5217]));

var G__5218 = (i__4772__auto___5217 + (1));
i__4772__auto___5217 = G__5218;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in$){
var G__5219 = cljs.core.nnext(in$);
var G__5220 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__5219;
out = G__5220;
continue;
} else {
return out;
}
break;
}
}));

(cljs.core.sorted_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.sorted_map.cljs$lang$applyTo = (function (seq5215){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq5215));
}));

/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings, using the supplied comparator.
 */
cljs.core.sorted_map_by = (function cljs$core$sorted_map_by(var_args){
var args__4777__auto__ = [];
var len__4771__auto___5223 = arguments.length;
var i__4772__auto___5224 = (0);
while(true){
if((i__4772__auto___5224 < len__4771__auto___5223)){
args__4777__auto__.push((arguments[i__4772__auto___5224]));

var G__5225 = (i__4772__auto___5224 + (1));
i__4772__auto___5224 = G__5225;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = (new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator),null,(0),null,(0)));
while(true){
if(in$){
var G__5226 = cljs.core.nnext(in$);
var G__5227 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__5226;
out = G__5227;
continue;
} else {
return out;
}
break;
}
}));

(cljs.core.sorted_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.sorted_map_by.cljs$lang$applyTo = (function (seq5221){
var G__5222 = cljs.core.first(seq5221);
var seq5221__$1 = cljs.core.next(seq5221);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5222,seq5221__$1);
}));


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.KeySeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.KeySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.KeySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.KeySeq.prototype.indexOf = (function() {
var G__5230 = null;
var G__5230__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__5230__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__5230 = function(x,start){
switch(arguments.length){
case 1:
return G__5230__1.call(this,x);
case 2:
return G__5230__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5230.cljs$core$IFn$_invoke$arity$1 = G__5230__1;
G__5230.cljs$core$IFn$_invoke$arity$2 = G__5230__2;
return G__5230;
})()
);

(cljs.core.KeySeq.prototype.lastIndexOf = (function() {
var G__5231 = null;
var G__5231__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__5231__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__5231 = function(x,start){
switch(arguments.length){
case 1:
return G__5231__1.call(this,x);
case 2:
return G__5231__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5231.cljs$core$IFn$_invoke$arity$1 = G__5231__1;
G__5231.cljs$core$IFn$_invoke$arity$2 = G__5231__2;
return G__5231;
})()
);

(cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
}));

(cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.KeySeq(nseq,null));
}
}));

(cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_key$arity$1(null);
}));

(cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((!((nseq == null)))){
return (new cljs.core.KeySeq(nseq,null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.KeySeq(self__.mseq,new_meta));
}
}));

(cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.KeySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$_meta], null);
}));

(cljs.core.KeySeq.cljs$lang$type = true);

(cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq");

(cljs.core.KeySeq.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/KeySeq");
}));

/**
 * Positional factory function for cljs.core/KeySeq.
 */
cljs.core.__GT_KeySeq = (function cljs$core$__GT_KeySeq(mseq,_meta){
return (new cljs.core.KeySeq(mseq,_meta));
});

goog.object.set(cljs.core.KeySeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));
/**
 * Returns a sequence of the map's keys, in the same order as (seq map).
 */
cljs.core.keys = (function cljs$core$keys(map){
var temp__5753__auto__ = cljs.core.seq(map);
if(temp__5753__auto__){
var mseq = temp__5753__auto__;
return (new cljs.core.KeySeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core.key = (function cljs$core$key(map_entry){
return cljs.core._key(map_entry);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ValSeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.ValSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.ValSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.ValSeq.prototype.indexOf = (function() {
var G__5234 = null;
var G__5234__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,(0));
});
var G__5234__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._indexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__5234 = function(x,start){
switch(arguments.length){
case 1:
return G__5234__1.call(this,x);
case 2:
return G__5234__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5234.cljs$core$IFn$_invoke$arity$1 = G__5234__1;
G__5234.cljs$core$IFn$_invoke$arity$2 = G__5234__2;
return G__5234;
})()
);

(cljs.core.ValSeq.prototype.lastIndexOf = (function() {
var G__5235 = null;
var G__5235__1 = (function (x){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,cljs.core.count(coll));
});
var G__5235__2 = (function (x,start){
var self__ = this;
var coll = this;
return cljs.core._lastIndexOf.cljs$core$IFn$_invoke$arity$3(coll,x,start);
});
G__5235 = function(x,start){
switch(arguments.length){
case 1:
return G__5235__1.call(this,x);
case 2:
return G__5235__2.call(this,x,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5235.cljs$core$IFn$_invoke$arity$1 = G__5235__1;
G__5235.cljs$core$IFn$_invoke$arity$2 = G__5235__2;
return G__5235;
})()
);

(cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
}));

(cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.ValSeq(nseq,null));
}
}));

(cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
}));

(cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
}));

(cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
}));

(cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
}));

(cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
}));

(cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_val$arity$1(null);
}));

(cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((((!((self__.mseq == null))))?(((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || ((cljs.core.PROTOCOL_SENTINEL === self__.mseq.cljs$core$INext$))))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((!((nseq == null)))){
return (new cljs.core.ValSeq(nseq,null));
} else {
return cljs.core.List.EMPTY;
}
}));

(cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
}));

(cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__._meta)){
return coll__$1;
} else {
return (new cljs.core.ValSeq(self__.mseq,new_meta));
}
}));

(cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
}));

(cljs.core.ValSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$_meta], null);
}));

(cljs.core.ValSeq.cljs$lang$type = true);

(cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq");

(cljs.core.ValSeq.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/ValSeq");
}));

/**
 * Positional factory function for cljs.core/ValSeq.
 */
cljs.core.__GT_ValSeq = (function cljs$core$__GT_ValSeq(mseq,_meta){
return (new cljs.core.ValSeq(mseq,_meta));
});

goog.object.set(cljs.core.ValSeq.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));
/**
 * Returns a sequence of the map's values, in the same order as (seq map).
 */
cljs.core.vals = (function cljs$core$vals(map){
var temp__5753__auto__ = cljs.core.seq(map);
if(temp__5753__auto__){
var mseq = temp__5753__auto__;
return (new cljs.core.ValSeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the value in the map entry.
 */
cljs.core.val = (function cljs$core$val(map_entry){
return cljs.core._val(map_entry);
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping from
 *   the latter (left-to-right) will be the mapping in the result.
 */
cljs.core.merge = (function cljs$core$merge(var_args){
var args__4777__auto__ = [];
var len__4771__auto___5239 = arguments.length;
var i__4772__auto___5240 = (0);
while(true){
if((i__4772__auto___5240 < len__4771__auto___5239)){
args__4777__auto__.push((arguments[i__4772__auto___5240]));

var G__5241 = (i__4772__auto___5240 + (1));
i__4772__auto___5240 = G__5241;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__5236_SHARP_,p2__5237_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4160__auto__ = p1__5236_SHARP_;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),p2__5237_SHARP_);
}),maps);
} else {
return null;
}
}));

(cljs.core.merge.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.merge.cljs$lang$applyTo = (function (seq5238){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq5238));
}));

/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping(s)
 *   from the latter (left-to-right) will be combined with the mapping in
 *   the result by calling (f val-in-result val-in-latter).
 */
cljs.core.merge_with = (function cljs$core$merge_with(var_args){
var args__4777__auto__ = [];
var len__4771__auto___5246 = arguments.length;
var i__4772__auto___5247 = (0);
while(true){
if((i__4772__auto___5247 < len__4771__auto___5246)){
args__4777__auto__.push((arguments[i__4772__auto___5247]));

var G__5248 = (i__4772__auto___5247 + (1));
i__4772__auto___5247 = G__5248;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.key(e);
var v = cljs.core.val(e);
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__5244 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__5245 = v;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5244,G__5245) : f.call(null,G__5244,G__5245));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
var merge2 = (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__4160__auto__ = m1;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
}));

(cljs.core.merge_with.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.merge_with.cljs$lang$applyTo = (function (seq5242){
var G__5243 = cljs.core.first(seq5242);
var seq5242__$1 = cljs.core.next(seq5242);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5243,seq5242__$1);
}));

/**
 * Returns a map containing only those entries in map whose key is in keys
 */
cljs.core.select_keys = (function cljs$core$select_keys(map,keyseq){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var keys = cljs.core.seq(keyseq);
while(true){
if(keys){
var key = cljs.core.first(keys);
var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map,key,cljs.core.cst$kw$cljs$core_SLASH_not_DASH_found);
var G__5249 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry,cljs.core.cst$kw$cljs$core_SLASH_not_DASH_found))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,key,entry):ret);
var G__5250 = cljs.core.next(keys);
ret = G__5249;
keys = G__5250;
continue;
} else {
return cljs.core._with_meta(ret,cljs.core.meta(map));
}
break;
}
});

/**
* @constructor
*/
cljs.core.HashSetIter = (function (iter){
this.iter = iter;
});
(cljs.core.HashSetIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return self__.iter.hasNext();
}));

(cljs.core.HashSetIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(self__.iter.hasNext()){
return self__.iter.next().key;
} else {
throw (new Error("No such element"));
}
}));

(cljs.core.HashSetIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
}));

(cljs.core.HashSetIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iter], null);
}));

(cljs.core.HashSetIter.cljs$lang$type = true);

(cljs.core.HashSetIter.cljs$lang$ctorStr = "cljs.core/HashSetIter");

(cljs.core.HashSetIter.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/HashSetIter");
}));

/**
 * Positional factory function for cljs.core/HashSetIter.
 */
cljs.core.__GT_HashSetIter = (function cljs$core$__GT_HashSetIter(iter){
return (new cljs.core.HashSetIter(iter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.ISet}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
this.cljs$lang$protocol_mask$partition1$ = 139268;
});
(cljs.core.PersistentHashSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentHashSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentHashSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentHashSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentHashSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentHashSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentHashSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__5254 = cljs.core.seq(coll);
var chunk__5255 = null;
var count__5256 = (0);
var i__5257 = (0);
while(true){
if((i__5257 < count__5256)){
var vec__5264 = chunk__5255.cljs$core$IIndexed$_nth$arity$2(null,i__5257);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5264,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5264,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__5273 = seq__5254;
var G__5274 = chunk__5255;
var G__5275 = count__5256;
var G__5276 = (i__5257 + (1));
seq__5254 = G__5273;
chunk__5255 = G__5274;
count__5256 = G__5275;
i__5257 = G__5276;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__5254);
if(temp__5753__auto__){
var seq__5254__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__5254__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__5254__$1);
var G__5277 = cljs.core.chunk_rest(seq__5254__$1);
var G__5278 = c__4591__auto__;
var G__5279 = cljs.core.count(c__4591__auto__);
var G__5280 = (0);
seq__5254 = G__5277;
chunk__5255 = G__5278;
count__5256 = G__5279;
i__5257 = G__5280;
continue;
} else {
var vec__5267 = cljs.core.first(seq__5254__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5267,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5267,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__5281 = cljs.core.next(seq__5254__$1);
var G__5282 = null;
var G__5283 = (0);
var G__5284 = (0);
seq__5254 = G__5281;
chunk__5255 = G__5282;
count__5256 = G__5283;
i__5257 = G__5284;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,v,null);
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var temp__5751__auto__ = cljs.core._find(self__.hash_map,v);
if(cljs.core.truth_(temp__5751__auto__)){
var entry = temp__5751__auto__;
return cljs.core.key(entry);
} else {
return not_found;
}
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.HashSetIter(cljs.core._iterator(self__.hash_map)));
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,self__.hash_map,self__.__hash));
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._count(self__.hash_map);
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if(cljs.core.set_QMARK_(other)){
if((cljs.core.count(coll__$1) === cljs.core.count(other))){
try{return cljs.core.reduce_kv((function (p1__5252_SHARP_,p2__5251_SHARP_){
var or__4160__auto__ = cljs.core.contains_QMARK_(other,p2__5251_SHARP_);
if(or__4160__auto__){
return or__4160__auto__;
} else {
return cljs.core.reduced(false);
}
}),true,self__.hash_map);
}catch (e5272){if((e5272 instanceof Error)){
var ex = e5272;
return false;
} else {
throw e5272;

}
}} else {
return false;
}
} else {
return false;
}
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map)));
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashSet.EMPTY,self__.meta);
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core._dissoc(self__.hash_map,v),null));
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.hash_map);
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashSet(new_meta,self__.hash_map,self__.__hash));
}
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map,o,null),null));
}));

(cljs.core.PersistentHashSet.prototype.call = (function() {
var G__5285 = null;
var G__5285__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__5285__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__5285 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__5285__2.call(this,self__,k);
case 3:
return G__5285__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__5285.cljs$core$IFn$_invoke$arity$2 = G__5285__2;
G__5285.cljs$core$IFn$_invoke$arity$3 = G__5285__3;
return G__5285;
})()
);

(cljs.core.PersistentHashSet.prototype.apply = (function (self__,args5253){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args5253)));
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentHashSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$hash_DASH_map,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.PersistentHashSet.cljs$lang$type = true);

(cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet");

(cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/PersistentHashSet");
}));

/**
 * Positional factory function for cljs.core/PersistentHashSet.
 */
cljs.core.__GT_PersistentHashSet = (function cljs$core$__GT_PersistentHashSet(meta,hash_map,__hash){
return (new cljs.core.PersistentHashSet(meta,hash_map,__hash));
});

(cljs.core.PersistentHashSet.EMPTY = (new cljs.core.PersistentHashSet(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.empty_unordered_hash)));
(cljs.core.PersistentHashSet.fromArray = (function (items,no_clone){
var len = items.length;
if((len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr = ((no_clone)?items:cljs.core.aclone(items));
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__5286 = (i + (1));
var G__5287 = cljs.core._assoc_BANG_(out,(items[i]),null);
i = G__5286;
out = G__5287;
continue;
} else {
return (new cljs.core.PersistentHashSet(null,cljs.core._persistent_BANG_(out),null));
}
break;
}
} else {
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < len)){
var G__5288 = (i + (1));
var G__5289 = cljs.core._conj_BANG_(out,(items[i]));
i = G__5288;
out = G__5289;
continue;
} else {
return cljs.core._persistent_BANG_(out);
}
break;
}
}
}));
(cljs.core.PersistentHashSet.createWithCheck = (function (items){
var len = items.length;
var t = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
var n__4648__auto___5290 = len;
var i_5291 = (0);
while(true){
if((i_5291 < n__4648__auto___5290)){
cljs.core._conj_BANG_(t,(items[i_5291]));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(t),(i_5291 + (1)))){
} else {
throw (new Error(["Duplicate key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((items[i_5291]))].join('')));
}

var G__5292 = (i_5291 + (1));
i_5291 = G__5292;
continue;
} else {
}
break;
}

return cljs.core._persistent_BANG_(t);
}));
(cljs.core.PersistentHashSet.createAsIfByAssoc = (function (items){
var len = items.length;
var t = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
var n__4648__auto___5293 = len;
var i_5294 = (0);
while(true){
if((i_5294 < n__4648__auto___5293)){
cljs.core._conj_BANG_(t,(items[i_5294]));

var G__5295 = (i_5294 + (1));
i_5294 = G__5295;
continue;
} else {
}
break;
}

return cljs.core._persistent_BANG_(t);
}));
goog.object.set(cljs.core.PersistentHashSet.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ITransientSet}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashSet = (function (transient_map){
this.transient_map = transient_map;
this.cljs$lang$protocol_mask$partition1$ = 136;
this.cljs$lang$protocol_mask$partition0$ = 259;
});
(cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
(self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map,o,null));

return tcoll__$1;
}));

(cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return (new cljs.core.PersistentHashSet(null,cljs.core.persistent_BANG_(self__.transient_map),null));
}));

(cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
(self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map,v));

return tcoll__$1;
}));

(cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return cljs.core.count(self__.transient_map);
}));

(cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.cljs$core$ILookup$_lookup$arity$3(null,v,null);
}));

(cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,v,not_found){
var self__ = this;
var tcoll__$1 = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return v;
}
}));

(cljs.core.TransientHashSet.prototype.call = (function() {
var G__5297 = null;
var G__5297__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});
var G__5297__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});
G__5297 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__5297__2.call(this,self__,k);
case 3:
return G__5297__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__5297.cljs$core$IFn$_invoke$arity$2 = G__5297__2;
G__5297.cljs$core$IFn$_invoke$arity$3 = G__5297__3;
return G__5297;
})()
);

(cljs.core.TransientHashSet.prototype.apply = (function (self__,args5296){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args5296)));
}));

(cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
}));

(cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
}));

(cljs.core.TransientHashSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$transient_DASH_map,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.TransientHashSet.cljs$lang$type = true);

(cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet");

(cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/TransientHashSet");
}));

/**
 * Positional factory function for cljs.core/TransientHashSet.
 */
cljs.core.__GT_TransientHashSet = (function cljs$core$__GT_TransientHashSet(transient_map){
return (new cljs.core.TransientHashSet(transient_map));
});


/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ISet}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentTreeSet = (function (meta,tree_map,__hash){
this.meta = meta;
this.tree_map = tree_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 417730831;
this.cljs$lang$protocol_mask$partition1$ = 8192;
});
(cljs.core.PersistentTreeSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
}));

(cljs.core.PersistentTreeSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
}));

(cljs.core.PersistentTreeSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentTreeSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentTreeSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
}));

(cljs.core.PersistentTreeSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
}));

(cljs.core.PersistentTreeSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__5301 = cljs.core.seq(coll);
var chunk__5302 = null;
var count__5303 = (0);
var i__5304 = (0);
while(true){
if((i__5304 < count__5303)){
var vec__5311 = chunk__5302.cljs$core$IIndexed$_nth$arity$2(null,i__5304);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5311,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5311,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__5320 = seq__5301;
var G__5321 = chunk__5302;
var G__5322 = count__5303;
var G__5323 = (i__5304 + (1));
seq__5301 = G__5320;
chunk__5302 = G__5321;
count__5303 = G__5322;
i__5304 = G__5323;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__5301);
if(temp__5753__auto__){
var seq__5301__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__5301__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__5301__$1);
var G__5324 = cljs.core.chunk_rest(seq__5301__$1);
var G__5325 = c__4591__auto__;
var G__5326 = cljs.core.count(c__4591__auto__);
var G__5327 = (0);
seq__5301 = G__5324;
chunk__5302 = G__5325;
count__5303 = G__5326;
i__5304 = G__5327;
continue;
} else {
var vec__5314 = cljs.core.first(seq__5301__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5314,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5314,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));


var G__5328 = cljs.core.next(seq__5301__$1);
var G__5329 = null;
var G__5330 = (0);
var G__5331 = (0);
seq__5301 = G__5328;
chunk__5302 = G__5329;
count__5303 = G__5330;
i__5304 = G__5331;
continue;
}
} else {
return null;
}
}
break;
}
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return coll__$1.cljs$core$ILookup$_lookup$arity$3(null,v,null);
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var n = self__.tree_map.entry_at(v);
if((!((n == null)))){
return n.key;
} else {
return not_found;
}
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,self__.tree_map,self__.__hash));
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.count(self__.tree_map);
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.count(self__.tree_map) > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.rseq(self__.tree_map));
} else {
return null;
}
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if(cljs.core.set_QMARK_(other)){
if((cljs.core.count(coll__$1) === cljs.core.count(other))){
try{return cljs.core.reduce_kv((function (p1__5299_SHARP_,p2__5298_SHARP_){
var or__4160__auto__ = cljs.core.contains_QMARK_(other,p2__5298_SHARP_);
if(or__4160__auto__){
return or__4160__auto__;
} else {
return cljs.core.reduced(false);
}
}),true,self__.tree_map);
}catch (e5319){if((e5319 instanceof Error)){
var ex = e5319;
return false;
} else {
throw e5319;

}
}} else {
return false;
}
} else {
return false;
}
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core._empty(self__.tree_map),(0)));
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map,v),null));
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.tree_map);
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
if((new_meta === self__.meta)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeSet(new_meta,self__.tree_map,self__.__hash));
}
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map,o,null),null));
}));

(cljs.core.PersistentTreeSet.prototype.call = (function() {
var G__5332 = null;
var G__5332__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__5332__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__5332 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__5332__2.call(this,self__,k);
case 3:
return G__5332__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__5332.cljs$core$IFn$_invoke$arity$2 = G__5332__2;
G__5332.cljs$core$IFn$_invoke$arity$3 = G__5332__3;
return G__5332;
})()
);

(cljs.core.PersistentTreeSet.prototype.apply = (function (self__,args5300){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args5300)));
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq(self__.tree_map,ascending_QMARK_));
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq_from(self__.tree_map,k,ascending_QMARK_));
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return entry;
}));

(cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._comparator(self__.tree_map);
}));

(cljs.core.PersistentTreeSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$tree_DASH_map,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(cljs.core.PersistentTreeSet.cljs$lang$type = true);

(cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet");

(cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core/PersistentTreeSet");
}));

/**
 * Positional factory function for cljs.core/PersistentTreeSet.
 */
cljs.core.__GT_PersistentTreeSet = (function cljs$core$__GT_PersistentTreeSet(meta,tree_map,__hash){
return (new cljs.core.PersistentTreeSet(meta,tree_map,__hash));
});

(cljs.core.PersistentTreeSet.EMPTY = (new cljs.core.PersistentTreeSet(null,cljs.core.PersistentTreeMap.EMPTY,cljs.core.empty_unordered_hash)));
goog.object.set(cljs.core.PersistentTreeSet.prototype,cljs.core.ITER_SYMBOL,(function (){
var this__4710__auto__ = this;
return cljs.core.es6_iterator(this__4710__auto__);
}));
cljs.core.set_from_indexed_seq = (function cljs$core$set_from_indexed_seq(iseq){
var arr = iseq.arr;
var ret = (function (){var a__4645__auto__ = arr;
var l__4646__auto__ = a__4645__auto__.length;
var i = (0);
var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < l__4646__auto__)){
var G__5333 = (i + (1));
var G__5334 = cljs.core._conj_BANG_(res,(arr[i]));
i = G__5333;
res = G__5334;
continue;
} else {
return res;
}
break;
}
})();
return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
});
/**
 * Returns a set of the distinct elements of coll.
 */
cljs.core.set = (function cljs$core$set(coll){
if(cljs.core.set_QMARK_(coll)){
return cljs.core.with_meta(coll,null);
} else {
var in$ = cljs.core.seq(coll);
if((in$ == null)){
return cljs.core.PersistentHashSet.EMPTY;
} else {
if((((in$ instanceof cljs.core.IndexedSeq)) && ((in$.i === (0))))){
return cljs.core.PersistentHashSet.createAsIfByAssoc(in$.arr);
} else {
var in$__$1 = in$;
var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((!((in$__$1 == null)))){
var G__5335 = cljs.core.next(in$__$1);
var G__5336 = cljs.core._conj_BANG_(out,cljs.core._first(in$__$1));
in$__$1 = G__5335;
out = G__5336;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}

}
}
}
});
/**
 * Returns a new hash set with supplied keys.  Any equal keys are
 *   handled as if by repeated uses of conj.
 */
cljs.core.hash_set = (function cljs$core$hash_set(var_args){
var G__5339 = arguments.length;
switch (G__5339) {
case 0:
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0();

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___5341 = arguments.length;
var i__4772__auto___5342 = (0);
while(true){
if((i__4772__auto___5342 < len__4771__auto___5341)){
args_arr__4792__auto__.push((arguments[i__4772__auto___5342]));

var G__5343 = (i__4772__auto___5342 + (1));
i__4772__auto___5342 = G__5343;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((0)),(0),null));
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4793__auto__);

}
});

(cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentHashSet.EMPTY;
}));

(cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.set(keys);
}));

/** @this {Function} */
(cljs.core.hash_set.cljs$lang$applyTo = (function (seq5338){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq5338));
}));

(cljs.core.hash_set.cljs$lang$maxFixedArity = (0));

/**
 * Returns a new sorted set with supplied keys.
 */
cljs.core.sorted_set = (function cljs$core$sorted_set(var_args){
var args__4777__auto__ = [];
var len__4771__auto___5345 = arguments.length;
var i__4772__auto___5346 = (0);
while(true){
if((i__4772__auto___5346 < len__4771__auto___5345)){
args__4777__auto__.push((arguments[i__4772__auto___5346]));

var G__5347 = (i__4772__auto___5346 + (1));
i__4772__auto___5346 = G__5347;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,cljs.core.PersistentTreeSet.EMPTY,keys);
}));

(cljs.core.sorted_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(cljs.core.sorted_set.cljs$lang$applyTo = (function (seq5344){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq5344));
}));

/**
 * Returns a new sorted set with supplied keys, using the supplied comparator.
 */
cljs.core.sorted_set_by = (function cljs$core$sorted_set_by(var_args){
var args__4777__auto__ = [];
var len__4771__auto___5350 = arguments.length;
var i__4772__auto___5351 = (0);
while(true){
if((i__4772__auto___5351 < len__4771__auto___5350)){
args__4777__auto__.push((arguments[i__4772__auto___5351]));

var G__5352 = (i__4772__auto___5351 + (1));
i__4772__auto___5351 = G__5352;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,(new cljs.core.PersistentTreeSet(null,cljs.core.sorted_map_by(comparator),(0))),keys);
}));

(cljs.core.sorted_set_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.sorted_set_by.cljs$lang$applyTo = (function (seq5348){
var G__5349 = cljs.core.first(seq5348);
var seq5348__$1 = cljs.core.next(seq5348);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5349,seq5348__$1);
}));

/**
 * Given a map of replacement pairs and a vector/collection, returns a
 *   vector/seq with any elements = a key in smap replaced with the
 *   corresponding val in smap.  Returns a transducer when no collection
 *   is provided.
 */
cljs.core.replace = (function cljs$core$replace(var_args){
var G__5356 = arguments.length;
switch (G__5356) {
case 1:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.replace.cljs$core$IFn$_invoke$arity$1 = (function (smap){
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__5353_SHARP_){
var temp__5751__auto__ = cljs.core.find(smap,p1__5353_SHARP_);
if(cljs.core.truth_(temp__5751__auto__)){
var e = temp__5751__auto__;
return cljs.core.val(e);
} else {
return p1__5353_SHARP_;
}
}));
}));

(cljs.core.replace.cljs$core$IFn$_invoke$arity$2 = (function (smap,coll){
if(cljs.core.vector_QMARK_(coll)){
var n = cljs.core.count(coll);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,i){
var temp__5751__auto__ = cljs.core.find(smap,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v,i));
if(cljs.core.truth_(temp__5751__auto__)){
var e = temp__5751__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,i,cljs.core.second(e));
} else {
return v;
}
}),coll,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.iterate(cljs.core.inc,(0))));
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__5354_SHARP_){
var temp__5751__auto__ = cljs.core.find(smap,p1__5354_SHARP_);
if(cljs.core.truth_(temp__5751__auto__)){
var e = temp__5751__auto__;
return cljs.core.second(e);
} else {
return p1__5354_SHARP_;
}
}),coll);
}
}));

(cljs.core.replace.cljs$lang$maxFixedArity = 2);

/**
 * Returns a lazy sequence of the elements of coll with duplicates removed.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.distinct = (function cljs$core$distinct(var_args){
var G__5359 = arguments.length;
switch (G__5359) {
case 0:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.distinct.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
return (function() {
var G__5370 = null;
var G__5370__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__5370__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__5370__2 = (function (result,input){
if(cljs.core.contains_QMARK_(cljs.core.deref(seen),input)){
return result;
} else {
seen.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen.cljs$core$IDeref$_deref$arity$1(null),input));

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__5370 = function(result,input){
switch(arguments.length){
case 0:
return G__5370__0.call(this);
case 1:
return G__5370__1.call(this,result);
case 2:
return G__5370__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5370.cljs$core$IFn$_invoke$arity$0 = G__5370__0;
G__5370.cljs$core$IFn$_invoke$arity$1 = G__5370__1;
G__5370.cljs$core$IFn$_invoke$arity$2 = G__5370__2;
return G__5370;
})()
});
}));

(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var step = (function cljs$core$step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
var fexpr__5364 = (function (p__5365,seen__$1){
while(true){
var vec__5366 = p__5365;
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__5366,(0),null);
var xs__$1 = vec__5366;
var temp__5753__auto__ = cljs.core.seq(xs__$1);
if(temp__5753__auto__){
var s = temp__5753__auto__;
if(cljs.core.contains_QMARK_(seen__$1,f)){
var G__5371 = cljs.core.rest(s);
var G__5372 = seen__$1;
p__5365 = G__5371;
seen__$1 = G__5372;
continue;
} else {
return cljs.core.cons(f,cljs$core$step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,f)));
}
} else {
return null;
}
break;
}
});
return fexpr__5364(xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
}));

(cljs.core.distinct.cljs$lang$maxFixedArity = 1);

/**
 * Return a seq of all but the last item in coll, in linear time
 */
cljs.core.butlast = (function cljs$core$butlast(s){
var ret = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
while(true){
if(cljs.core.next(s__$1)){
var G__5373 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,cljs.core.first(s__$1));
var G__5374 = cljs.core.next(s__$1);
ret = G__5373;
s__$1 = G__5374;
continue;
} else {
return cljs.core.seq(ret);
}
break;
}
});
/**
 * Returns the name String of a string, symbol or keyword.
 */
cljs.core.name = (function cljs$core$name(x){
if((((!((x == null))))?(((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$INamed$))))?true:false):false)){
return x.cljs$core$INamed$_name$arity$1(null);
} else {
if(typeof x === 'string'){
return x;
} else {
throw (new Error(["Doesn't support name: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('')));
}
}
});
/**
 * Returns a map with the keys mapped to the corresponding vals.
 */
cljs.core.zipmap = (function cljs$core$zipmap(keys,vals){
var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks = cljs.core.seq(keys);
var vs = cljs.core.seq(vals);
while(true){
if(((ks) && (vs))){
var G__5376 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map,cljs.core.first(ks),cljs.core.first(vs));
var G__5377 = cljs.core.next(ks);
var G__5378 = cljs.core.next(vs);
map = G__5376;
ks = G__5377;
vs = G__5378;
continue;
} else {
return cljs.core.persistent_BANG_(map);
}
break;
}
});
/**
 * Returns the x for which (k x), a number, is greatest.
 * 
 *   If there are multiple such xs, the last one is returned.
 */
cljs.core.max_key = (function cljs$core$max_key(var_args){
var G__5386 = arguments.length;
switch (G__5386) {
case 2:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4792__auto__ = [];
var len__4771__auto___5388 = arguments.length;
var i__4772__auto___5389 = (0);
while(true){
if((i__4772__auto___5389 < len__4771__auto___5388)){
args_arr__4792__auto__.push((arguments[i__4772__auto___5389]));

var G__5390 = (i__4772__auto___5389 + (1));
i__4772__auto___5389 = G__5390;
continue;
} else {
}
break;
}

var argseq__4793__auto__ = (new cljs.core.IndexedSeq(args_arr__4792__auto__.slice((3)),(0),null));
return cljs.core.max_key.cljs$core$IFn$_invoke$a