// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__14017 = arguments.length;
switch (G__14017) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async14018 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14018 = (function (f,blockable,meta14019){
this.f = f;
this.blockable = blockable;
this.meta14019 = meta14019;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14018.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14020,meta14019__$1){
var self__ = this;
var _14020__$1 = this;
return (new cljs.core.async.t_cljs$core$async14018(self__.f,self__.blockable,meta14019__$1));
}));

(cljs.core.async.t_cljs$core$async14018.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14020){
var self__ = this;
var _14020__$1 = this;
return self__.meta14019;
}));

(cljs.core.async.t_cljs$core$async14018.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14018.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async14018.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async14018.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async14018.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta14019], null);
}));

(cljs.core.async.t_cljs$core$async14018.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14018.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14018");

(cljs.core.async.t_cljs$core$async14018.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async14018");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14018.
 */
cljs.core.async.__GT_t_cljs$core$async14018 = (function cljs$core$async$__GT_t_cljs$core$async14018(f__$1,blockable__$1,meta14019){
return (new cljs.core.async.t_cljs$core$async14018(f__$1,blockable__$1,meta14019));
});

}

return (new cljs.core.async.t_cljs$core$async14018(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__14024 = arguments.length;
switch (G__14024) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__14027 = arguments.length;
switch (G__14027) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__14030 = arguments.length;
switch (G__14030) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_14032 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_14032) : fn1.call(null,val_14032));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_14032) : fn1.call(null,val_14032));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__14034 = arguments.length;
switch (G__14034) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4648__auto___14036 = n;
var x_14037 = (0);
while(true){
if((x_14037 < n__4648__auto___14036)){
(a[x_14037] = x_14037);

var G__14038 = (x_14037 + (1));
x_14037 = G__14038;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async14039 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14039 = (function (flag,meta14040){
this.flag = flag;
this.meta14040 = meta14040;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14039.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14041,meta14040__$1){
var self__ = this;
var _14041__$1 = this;
return (new cljs.core.async.t_cljs$core$async14039(self__.flag,meta14040__$1));
}));

(cljs.core.async.t_cljs$core$async14039.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14041){
var self__ = this;
var _14041__$1 = this;
return self__.meta14040;
}));

(cljs.core.async.t_cljs$core$async14039.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14039.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async14039.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async14039.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async14039.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta14040], null);
}));

(cljs.core.async.t_cljs$core$async14039.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14039.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14039");

(cljs.core.async.t_cljs$core$async14039.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async14039");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14039.
 */
cljs.core.async.__GT_t_cljs$core$async14039 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async14039(flag__$1,meta14040){
return (new cljs.core.async.t_cljs$core$async14039(flag__$1,meta14040));
});

}

return (new cljs.core.async.t_cljs$core$async14039(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async14042 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14042 = (function (flag,cb,meta14043){
this.flag = flag;
this.cb = cb;
this.meta14043 = meta14043;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14042.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14044,meta14043__$1){
var self__ = this;
var _14044__$1 = this;
return (new cljs.core.async.t_cljs$core$async14042(self__.flag,self__.cb,meta14043__$1));
}));

(cljs.core.async.t_cljs$core$async14042.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14044){
var self__ = this;
var _14044__$1 = this;
return self__.meta14043;
}));

(cljs.core.async.t_cljs$core$async14042.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14042.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async14042.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async14042.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async14042.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta14043], null);
}));

(cljs.core.async.t_cljs$core$async14042.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14042.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14042");

(cljs.core.async.t_cljs$core$async14042.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async14042");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14042.
 */
cljs.core.async.__GT_t_cljs$core$async14042 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async14042(flag__$1,cb__$1,meta14043){
return (new cljs.core.async.t_cljs$core$async14042(flag__$1,cb__$1,meta14043));
});

}

return (new cljs.core.async.t_cljs$core$async14042(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14045_SHARP_){
var G__14047 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14045_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__14047) : fret.call(null,G__14047));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__14046_SHARP_){
var G__14048 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__14046_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__14048) : fret.call(null,G__14048));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4160__auto__ = wport;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return port;
}
})()], null));
} else {
var G__14049 = (i + (1));
i = G__14049;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4160__auto__ = ret;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5753__auto__ = (function (){var and__4149__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4149__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4149__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___14054 = arguments.length;
var i__4772__auto___14055 = (0);
while(true){
if((i__4772__auto___14055 < len__4771__auto___14054)){
args__4777__auto__.push((arguments[i__4772__auto___14055]));

var G__14056 = (i__4772__auto___14055 + (1));
i__4772__auto___14055 = G__14056;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__14052){
var map__14053 = p__14052;
var map__14053__$1 = cljs.core.__destructure_map(map__14053);
var opts = map__14053__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq14050){
var G__14051 = cljs.core.first(seq14050);
var seq14050__$1 = cljs.core.next(seq14050);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14051,seq14050__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__14058 = arguments.length;
switch (G__14058) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__13957__auto___14105 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_14082){
var state_val_14083 = (state_14082[(1)]);
if((state_val_14083 === (7))){
var inst_14078 = (state_14082[(2)]);
var state_14082__$1 = state_14082;
var statearr_14084_14106 = state_14082__$1;
(statearr_14084_14106[(2)] = inst_14078);

(statearr_14084_14106[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14083 === (1))){
var state_14082__$1 = state_14082;
var statearr_14085_14107 = state_14082__$1;
(statearr_14085_14107[(2)] = null);

(statearr_14085_14107[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14083 === (4))){
var inst_14061 = (state_14082[(7)]);
var inst_14061__$1 = (state_14082[(2)]);
var inst_14062 = (inst_14061__$1 == null);
var state_14082__$1 = (function (){var statearr_14086 = state_14082;
(statearr_14086[(7)] = inst_14061__$1);

return statearr_14086;
})();
if(cljs.core.truth_(inst_14062)){
var statearr_14087_14108 = state_14082__$1;
(statearr_14087_14108[(1)] = (5));

} else {
var statearr_14088_14109 = state_14082__$1;
(statearr_14088_14109[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14083 === (13))){
var state_14082__$1 = state_14082;
var statearr_14089_14110 = state_14082__$1;
(statearr_14089_14110[(2)] = null);

(statearr_14089_14110[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14083 === (6))){
var inst_14061 = (state_14082[(7)]);
var state_14082__$1 = state_14082;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14082__$1,(11),to,inst_14061);
} else {
if((state_val_14083 === (3))){
var inst_14080 = (state_14082[(2)]);
var state_14082__$1 = state_14082;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14082__$1,inst_14080);
} else {
if((state_val_14083 === (12))){
var state_14082__$1 = state_14082;
var statearr_14090_14111 = state_14082__$1;
(statearr_14090_14111[(2)] = null);

(statearr_14090_14111[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14083 === (2))){
var state_14082__$1 = state_14082;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14082__$1,(4),from);
} else {
if((state_val_14083 === (11))){
var inst_14071 = (state_14082[(2)]);
var state_14082__$1 = state_14082;
if(cljs.core.truth_(inst_14071)){
var statearr_14091_14112 = state_14082__$1;
(statearr_14091_14112[(1)] = (12));

} else {
var statearr_14092_14113 = state_14082__$1;
(statearr_14092_14113[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14083 === (9))){
var state_14082__$1 = state_14082;
var statearr_14093_14114 = state_14082__$1;
(statearr_14093_14114[(2)] = null);

(statearr_14093_14114[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14083 === (5))){
var state_14082__$1 = state_14082;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14094_14115 = state_14082__$1;
(statearr_14094_14115[(1)] = (8));

} else {
var statearr_14095_14116 = state_14082__$1;
(statearr_14095_14116[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14083 === (14))){
var inst_14076 = (state_14082[(2)]);
var state_14082__$1 = state_14082;
var statearr_14096_14117 = state_14082__$1;
(statearr_14096_14117[(2)] = inst_14076);

(statearr_14096_14117[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14083 === (10))){
var inst_14068 = (state_14082[(2)]);
var state_14082__$1 = state_14082;
var statearr_14097_14118 = state_14082__$1;
(statearr_14097_14118[(2)] = inst_14068);

(statearr_14097_14118[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14083 === (8))){
var inst_14065 = cljs.core.async.close_BANG_(to);
var state_14082__$1 = state_14082;
var statearr_14098_14119 = state_14082__$1;
(statearr_14098_14119[(2)] = inst_14065);

(statearr_14098_14119[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13883__auto__ = null;
var cljs$core$async$state_machine__13883__auto____0 = (function (){
var statearr_14099 = [null,null,null,null,null,null,null,null];
(statearr_14099[(0)] = cljs$core$async$state_machine__13883__auto__);

(statearr_14099[(1)] = (1));

return statearr_14099;
});
var cljs$core$async$state_machine__13883__auto____1 = (function (state_14082){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_14082);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e14100){var ex__13886__auto__ = e14100;
var statearr_14101_14120 = state_14082;
(statearr_14101_14120[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_14082[(4)]))){
var statearr_14102_14121 = state_14082;
(statearr_14102_14121[(1)] = cljs.core.first((state_14082[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__14122 = state_14082;
state_14082 = G__14122;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$state_machine__13883__auto__ = function(state_14082){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13883__auto____1.call(this,state_14082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13883__auto____0;
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13883__auto____1;
return cljs$core$async$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_14103 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_14103[(6)] = c__13957__auto___14105);

return statearr_14103;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__14123){
var vec__14124 = p__14123;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14124,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14124,(1),null);
var job = vec__14124;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__13957__auto___14300 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_14131){
var state_val_14132 = (state_14131[(1)]);
if((state_val_14132 === (1))){
var state_14131__$1 = state_14131;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14131__$1,(2),res,v);
} else {
if((state_val_14132 === (2))){
var inst_14128 = (state_14131[(2)]);
var inst_14129 = cljs.core.async.close_BANG_(res);
var state_14131__$1 = (function (){var statearr_14133 = state_14131;
(statearr_14133[(7)] = inst_14128);

return statearr_14133;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_14131__$1,inst_14129);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____0 = (function (){
var statearr_14134 = [null,null,null,null,null,null,null,null];
(statearr_14134[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__);

(statearr_14134[(1)] = (1));

return statearr_14134;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____1 = (function (state_14131){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_14131);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e14135){var ex__13886__auto__ = e14135;
var statearr_14136_14301 = state_14131;
(statearr_14136_14301[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_14131[(4)]))){
var statearr_14137_14302 = state_14131;
(statearr_14137_14302[(1)] = cljs.core.first((state_14131[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__14303 = state_14131;
state_14131 = G__14303;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__ = function(state_14131){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____1.call(this,state_14131);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_14138 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_14138[(6)] = c__13957__auto___14300);

return statearr_14138;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__14139){
var vec__14140 = p__14139;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14140,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__14140,(1),null);
var job = vec__14140;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4648__auto___14304 = n;
var __14305 = (0);
while(true){
if((__14305 < n__4648__auto___14304)){
var G__14143_14306 = type;
var G__14143_14307__$1 = (((G__14143_14306 instanceof cljs.core.Keyword))?G__14143_14306.fqn:null);
switch (G__14143_14307__$1) {
case "compute":
var c__13957__auto___14309 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__14305,c__13957__auto___14309,G__14143_14306,G__14143_14307__$1,n__4648__auto___14304,jobs,results,process,async){
return (function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = ((function (__14305,c__13957__auto___14309,G__14143_14306,G__14143_14307__$1,n__4648__auto___14304,jobs,results,process,async){
return (function (state_14156){
var state_val_14157 = (state_14156[(1)]);
if((state_val_14157 === (1))){
var state_14156__$1 = state_14156;
var statearr_14158_14310 = state_14156__$1;
(statearr_14158_14310[(2)] = null);

(statearr_14158_14310[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14157 === (2))){
var state_14156__$1 = state_14156;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14156__$1,(4),jobs);
} else {
if((state_val_14157 === (3))){
var inst_14154 = (state_14156[(2)]);
var state_14156__$1 = state_14156;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14156__$1,inst_14154);
} else {
if((state_val_14157 === (4))){
var inst_14146 = (state_14156[(2)]);
var inst_14147 = process(inst_14146);
var state_14156__$1 = state_14156;
if(cljs.core.truth_(inst_14147)){
var statearr_14159_14311 = state_14156__$1;
(statearr_14159_14311[(1)] = (5));

} else {
var statearr_14160_14312 = state_14156__$1;
(statearr_14160_14312[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14157 === (5))){
var state_14156__$1 = state_14156;
var statearr_14161_14313 = state_14156__$1;
(statearr_14161_14313[(2)] = null);

(statearr_14161_14313[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14157 === (6))){
var state_14156__$1 = state_14156;
var statearr_14162_14314 = state_14156__$1;
(statearr_14162_14314[(2)] = null);

(statearr_14162_14314[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14157 === (7))){
var inst_14152 = (state_14156[(2)]);
var state_14156__$1 = state_14156;
var statearr_14163_14315 = state_14156__$1;
(statearr_14163_14315[(2)] = inst_14152);

(statearr_14163_14315[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__14305,c__13957__auto___14309,G__14143_14306,G__14143_14307__$1,n__4648__auto___14304,jobs,results,process,async))
;
return ((function (__14305,switch__13882__auto__,c__13957__auto___14309,G__14143_14306,G__14143_14307__$1,n__4648__auto___14304,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____0 = (function (){
var statearr_14164 = [null,null,null,null,null,null,null];
(statearr_14164[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__);

(statearr_14164[(1)] = (1));

return statearr_14164;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____1 = (function (state_14156){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_14156);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e14165){var ex__13886__auto__ = e14165;
var statearr_14166_14316 = state_14156;
(statearr_14166_14316[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_14156[(4)]))){
var statearr_14167_14317 = state_14156;
(statearr_14167_14317[(1)] = cljs.core.first((state_14156[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__14318 = state_14156;
state_14156 = G__14318;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__ = function(state_14156){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____1.call(this,state_14156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__;
})()
;})(__14305,switch__13882__auto__,c__13957__auto___14309,G__14143_14306,G__14143_14307__$1,n__4648__auto___14304,jobs,results,process,async))
})();
var state__13959__auto__ = (function (){var statearr_14168 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_14168[(6)] = c__13957__auto___14309);

return statearr_14168;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
});})(__14305,c__13957__auto___14309,G__14143_14306,G__14143_14307__$1,n__4648__auto___14304,jobs,results,process,async))
);


break;
case "async":
var c__13957__auto___14319 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__14305,c__13957__auto___14319,G__14143_14306,G__14143_14307__$1,n__4648__auto___14304,jobs,results,process,async){
return (function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = ((function (__14305,c__13957__auto___14319,G__14143_14306,G__14143_14307__$1,n__4648__auto___14304,jobs,results,process,async){
return (function (state_14181){
var state_val_14182 = (state_14181[(1)]);
if((state_val_14182 === (1))){
var state_14181__$1 = state_14181;
var statearr_14183_14320 = state_14181__$1;
(statearr_14183_14320[(2)] = null);

(statearr_14183_14320[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14182 === (2))){
var state_14181__$1 = state_14181;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14181__$1,(4),jobs);
} else {
if((state_val_14182 === (3))){
var inst_14179 = (state_14181[(2)]);
var state_14181__$1 = state_14181;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14181__$1,inst_14179);
} else {
if((state_val_14182 === (4))){
var inst_14171 = (state_14181[(2)]);
var inst_14172 = async(inst_14171);
var state_14181__$1 = state_14181;
if(cljs.core.truth_(inst_14172)){
var statearr_14184_14321 = state_14181__$1;
(statearr_14184_14321[(1)] = (5));

} else {
var statearr_14185_14322 = state_14181__$1;
(statearr_14185_14322[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14182 === (5))){
var state_14181__$1 = state_14181;
var statearr_14186_14323 = state_14181__$1;
(statearr_14186_14323[(2)] = null);

(statearr_14186_14323[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14182 === (6))){
var state_14181__$1 = state_14181;
var statearr_14187_14324 = state_14181__$1;
(statearr_14187_14324[(2)] = null);

(statearr_14187_14324[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14182 === (7))){
var inst_14177 = (state_14181[(2)]);
var state_14181__$1 = state_14181;
var statearr_14188_14325 = state_14181__$1;
(statearr_14188_14325[(2)] = inst_14177);

(statearr_14188_14325[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__14305,c__13957__auto___14319,G__14143_14306,G__14143_14307__$1,n__4648__auto___14304,jobs,results,process,async))
;
return ((function (__14305,switch__13882__auto__,c__13957__auto___14319,G__14143_14306,G__14143_14307__$1,n__4648__auto___14304,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____0 = (function (){
var statearr_14189 = [null,null,null,null,null,null,null];
(statearr_14189[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__);

(statearr_14189[(1)] = (1));

return statearr_14189;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____1 = (function (state_14181){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_14181);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e14190){var ex__13886__auto__ = e14190;
var statearr_14191_14326 = state_14181;
(statearr_14191_14326[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_14181[(4)]))){
var statearr_14192_14327 = state_14181;
(statearr_14192_14327[(1)] = cljs.core.first((state_14181[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__14328 = state_14181;
state_14181 = G__14328;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__ = function(state_14181){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____1.call(this,state_14181);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__;
})()
;})(__14305,switch__13882__auto__,c__13957__auto___14319,G__14143_14306,G__14143_14307__$1,n__4648__auto___14304,jobs,results,process,async))
})();
var state__13959__auto__ = (function (){var statearr_14193 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_14193[(6)] = c__13957__auto___14319);

return statearr_14193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
});})(__14305,c__13957__auto___14319,G__14143_14306,G__14143_14307__$1,n__4648__auto___14304,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__14143_14307__$1)].join('')));

}

var G__14329 = (__14305 + (1));
__14305 = G__14329;
continue;
} else {
}
break;
}

var c__13957__auto___14330 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_14215){
var state_val_14216 = (state_14215[(1)]);
if((state_val_14216 === (7))){
var inst_14211 = (state_14215[(2)]);
var state_14215__$1 = state_14215;
var statearr_14217_14331 = state_14215__$1;
(statearr_14217_14331[(2)] = inst_14211);

(statearr_14217_14331[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14216 === (1))){
var state_14215__$1 = state_14215;
var statearr_14218_14332 = state_14215__$1;
(statearr_14218_14332[(2)] = null);

(statearr_14218_14332[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14216 === (4))){
var inst_14196 = (state_14215[(7)]);
var inst_14196__$1 = (state_14215[(2)]);
var inst_14197 = (inst_14196__$1 == null);
var state_14215__$1 = (function (){var statearr_14219 = state_14215;
(statearr_14219[(7)] = inst_14196__$1);

return statearr_14219;
})();
if(cljs.core.truth_(inst_14197)){
var statearr_14220_14333 = state_14215__$1;
(statearr_14220_14333[(1)] = (5));

} else {
var statearr_14221_14334 = state_14215__$1;
(statearr_14221_14334[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14216 === (6))){
var inst_14196 = (state_14215[(7)]);
var inst_14201 = (state_14215[(8)]);
var inst_14201__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_14202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_14203 = [inst_14196,inst_14201__$1];
var inst_14204 = (new cljs.core.PersistentVector(null,2,(5),inst_14202,inst_14203,null));
var state_14215__$1 = (function (){var statearr_14222 = state_14215;
(statearr_14222[(8)] = inst_14201__$1);

return statearr_14222;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14215__$1,(8),jobs,inst_14204);
} else {
if((state_val_14216 === (3))){
var inst_14213 = (state_14215[(2)]);
var state_14215__$1 = state_14215;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14215__$1,inst_14213);
} else {
if((state_val_14216 === (2))){
var state_14215__$1 = state_14215;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14215__$1,(4),from);
} else {
if((state_val_14216 === (9))){
var inst_14208 = (state_14215[(2)]);
var state_14215__$1 = (function (){var statearr_14223 = state_14215;
(statearr_14223[(9)] = inst_14208);

return statearr_14223;
})();
var statearr_14224_14335 = state_14215__$1;
(statearr_14224_14335[(2)] = null);

(statearr_14224_14335[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14216 === (5))){
var inst_14199 = cljs.core.async.close_BANG_(jobs);
var state_14215__$1 = state_14215;
var statearr_14225_14336 = state_14215__$1;
(statearr_14225_14336[(2)] = inst_14199);

(statearr_14225_14336[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14216 === (8))){
var inst_14201 = (state_14215[(8)]);
var inst_14206 = (state_14215[(2)]);
var state_14215__$1 = (function (){var statearr_14226 = state_14215;
(statearr_14226[(10)] = inst_14206);

return statearr_14226;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14215__$1,(9),results,inst_14201);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____0 = (function (){
var statearr_14227 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14227[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__);

(statearr_14227[(1)] = (1));

return statearr_14227;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____1 = (function (state_14215){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_14215);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e14228){var ex__13886__auto__ = e14228;
var statearr_14229_14337 = state_14215;
(statearr_14229_14337[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_14215[(4)]))){
var statearr_14230_14338 = state_14215;
(statearr_14230_14338[(1)] = cljs.core.first((state_14215[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__14339 = state_14215;
state_14215 = G__14339;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__ = function(state_14215){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____1.call(this,state_14215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_14231 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_14231[(6)] = c__13957__auto___14330);

return statearr_14231;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_14269){
var state_val_14270 = (state_14269[(1)]);
if((state_val_14270 === (7))){
var inst_14265 = (state_14269[(2)]);
var state_14269__$1 = state_14269;
var statearr_14271_14340 = state_14269__$1;
(statearr_14271_14340[(2)] = inst_14265);

(statearr_14271_14340[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14270 === (20))){
var state_14269__$1 = state_14269;
var statearr_14272_14341 = state_14269__$1;
(statearr_14272_14341[(2)] = null);

(statearr_14272_14341[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14270 === (1))){
var state_14269__$1 = state_14269;
var statearr_14273_14342 = state_14269__$1;
(statearr_14273_14342[(2)] = null);

(statearr_14273_14342[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14270 === (4))){
var inst_14234 = (state_14269[(7)]);
var inst_14234__$1 = (state_14269[(2)]);
var inst_14235 = (inst_14234__$1 == null);
var state_14269__$1 = (function (){var statearr_14274 = state_14269;
(statearr_14274[(7)] = inst_14234__$1);

return statearr_14274;
})();
if(cljs.core.truth_(inst_14235)){
var statearr_14275_14343 = state_14269__$1;
(statearr_14275_14343[(1)] = (5));

} else {
var statearr_14276_14344 = state_14269__$1;
(statearr_14276_14344[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14270 === (15))){
var inst_14247 = (state_14269[(8)]);
var state_14269__$1 = state_14269;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14269__$1,(18),to,inst_14247);
} else {
if((state_val_14270 === (21))){
var inst_14260 = (state_14269[(2)]);
var state_14269__$1 = state_14269;
var statearr_14277_14345 = state_14269__$1;
(statearr_14277_14345[(2)] = inst_14260);

(statearr_14277_14345[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14270 === (13))){
var inst_14262 = (state_14269[(2)]);
var state_14269__$1 = (function (){var statearr_14278 = state_14269;
(statearr_14278[(9)] = inst_14262);

return statearr_14278;
})();
var statearr_14279_14346 = state_14269__$1;
(statearr_14279_14346[(2)] = null);

(statearr_14279_14346[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14270 === (6))){
var inst_14234 = (state_14269[(7)]);
var state_14269__$1 = state_14269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14269__$1,(11),inst_14234);
} else {
if((state_val_14270 === (17))){
var inst_14255 = (state_14269[(2)]);
var state_14269__$1 = state_14269;
if(cljs.core.truth_(inst_14255)){
var statearr_14280_14347 = state_14269__$1;
(statearr_14280_14347[(1)] = (19));

} else {
var statearr_14281_14348 = state_14269__$1;
(statearr_14281_14348[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14270 === (3))){
var inst_14267 = (state_14269[(2)]);
var state_14269__$1 = state_14269;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14269__$1,inst_14267);
} else {
if((state_val_14270 === (12))){
var inst_14244 = (state_14269[(10)]);
var state_14269__$1 = state_14269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14269__$1,(14),inst_14244);
} else {
if((state_val_14270 === (2))){
var state_14269__$1 = state_14269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14269__$1,(4),results);
} else {
if((state_val_14270 === (19))){
var state_14269__$1 = state_14269;
var statearr_14282_14349 = state_14269__$1;
(statearr_14282_14349[(2)] = null);

(statearr_14282_14349[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14270 === (11))){
var inst_14244 = (state_14269[(2)]);
var state_14269__$1 = (function (){var statearr_14283 = state_14269;
(statearr_14283[(10)] = inst_14244);

return statearr_14283;
})();
var statearr_14284_14350 = state_14269__$1;
(statearr_14284_14350[(2)] = null);

(statearr_14284_14350[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14270 === (9))){
var state_14269__$1 = state_14269;
var statearr_14285_14351 = state_14269__$1;
(statearr_14285_14351[(2)] = null);

(statearr_14285_14351[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14270 === (5))){
var state_14269__$1 = state_14269;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14286_14352 = state_14269__$1;
(statearr_14286_14352[(1)] = (8));

} else {
var statearr_14287_14353 = state_14269__$1;
(statearr_14287_14353[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14270 === (14))){
var inst_14247 = (state_14269[(8)]);
var inst_14247__$1 = (state_14269[(2)]);
var inst_14248 = (inst_14247__$1 == null);
var inst_14249 = cljs.core.not(inst_14248);
var state_14269__$1 = (function (){var statearr_14288 = state_14269;
(statearr_14288[(8)] = inst_14247__$1);

return statearr_14288;
})();
if(inst_14249){
var statearr_14289_14354 = state_14269__$1;
(statearr_14289_14354[(1)] = (15));

} else {
var statearr_14290_14355 = state_14269__$1;
(statearr_14290_14355[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14270 === (16))){
var state_14269__$1 = state_14269;
var statearr_14291_14356 = state_14269__$1;
(statearr_14291_14356[(2)] = false);

(statearr_14291_14356[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14270 === (10))){
var inst_14241 = (state_14269[(2)]);
var state_14269__$1 = state_14269;
var statearr_14292_14357 = state_14269__$1;
(statearr_14292_14357[(2)] = inst_14241);

(statearr_14292_14357[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14270 === (18))){
var inst_14252 = (state_14269[(2)]);
var state_14269__$1 = state_14269;
var statearr_14293_14358 = state_14269__$1;
(statearr_14293_14358[(2)] = inst_14252);

(statearr_14293_14358[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14270 === (8))){
var inst_14238 = cljs.core.async.close_BANG_(to);
var state_14269__$1 = state_14269;
var statearr_14294_14359 = state_14269__$1;
(statearr_14294_14359[(2)] = inst_14238);

(statearr_14294_14359[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____0 = (function (){
var statearr_14295 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14295[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__);

(statearr_14295[(1)] = (1));

return statearr_14295;
});
var cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____1 = (function (state_14269){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_14269);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e14296){var ex__13886__auto__ = e14296;
var statearr_14297_14360 = state_14269;
(statearr_14297_14360[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_14269[(4)]))){
var statearr_14298_14361 = state_14269;
(statearr_14298_14361[(1)] = cljs.core.first((state_14269[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__14362 = state_14269;
state_14269 = G__14362;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__ = function(state_14269){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____1.call(this,state_14269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__13883__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_14299 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_14299[(6)] = c__13957__auto__);

return statearr_14299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__14364 = arguments.length;
switch (G__14364) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__14367 = arguments.length;
switch (G__14367) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__14370 = arguments.length;
switch (G__14370) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__13957__auto___14420 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_14396){
var state_val_14397 = (state_14396[(1)]);
if((state_val_14397 === (7))){
var inst_14392 = (state_14396[(2)]);
var state_14396__$1 = state_14396;
var statearr_14398_14421 = state_14396__$1;
(statearr_14398_14421[(2)] = inst_14392);

(statearr_14398_14421[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14397 === (1))){
var state_14396__$1 = state_14396;
var statearr_14399_14422 = state_14396__$1;
(statearr_14399_14422[(2)] = null);

(statearr_14399_14422[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14397 === (4))){
var inst_14373 = (state_14396[(7)]);
var inst_14373__$1 = (state_14396[(2)]);
var inst_14374 = (inst_14373__$1 == null);
var state_14396__$1 = (function (){var statearr_14400 = state_14396;
(statearr_14400[(7)] = inst_14373__$1);

return statearr_14400;
})();
if(cljs.core.truth_(inst_14374)){
var statearr_14401_14423 = state_14396__$1;
(statearr_14401_14423[(1)] = (5));

} else {
var statearr_14402_14424 = state_14396__$1;
(statearr_14402_14424[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14397 === (13))){
var state_14396__$1 = state_14396;
var statearr_14403_14425 = state_14396__$1;
(statearr_14403_14425[(2)] = null);

(statearr_14403_14425[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14397 === (6))){
var inst_14373 = (state_14396[(7)]);
var inst_14379 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_14373) : p.call(null,inst_14373));
var state_14396__$1 = state_14396;
if(cljs.core.truth_(inst_14379)){
var statearr_14404_14426 = state_14396__$1;
(statearr_14404_14426[(1)] = (9));

} else {
var statearr_14405_14427 = state_14396__$1;
(statearr_14405_14427[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14397 === (3))){
var inst_14394 = (state_14396[(2)]);
var state_14396__$1 = state_14396;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14396__$1,inst_14394);
} else {
if((state_val_14397 === (12))){
var state_14396__$1 = state_14396;
var statearr_14406_14428 = state_14396__$1;
(statearr_14406_14428[(2)] = null);

(statearr_14406_14428[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14397 === (2))){
var state_14396__$1 = state_14396;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14396__$1,(4),ch);
} else {
if((state_val_14397 === (11))){
var inst_14373 = (state_14396[(7)]);
var inst_14383 = (state_14396[(2)]);
var state_14396__$1 = state_14396;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14396__$1,(8),inst_14383,inst_14373);
} else {
if((state_val_14397 === (9))){
var state_14396__$1 = state_14396;
var statearr_14407_14429 = state_14396__$1;
(statearr_14407_14429[(2)] = tc);

(statearr_14407_14429[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14397 === (5))){
var inst_14376 = cljs.core.async.close_BANG_(tc);
var inst_14377 = cljs.core.async.close_BANG_(fc);
var state_14396__$1 = (function (){var statearr_14408 = state_14396;
(statearr_14408[(8)] = inst_14376);

return statearr_14408;
})();
var statearr_14409_14430 = state_14396__$1;
(statearr_14409_14430[(2)] = inst_14377);

(statearr_14409_14430[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14397 === (14))){
var inst_14390 = (state_14396[(2)]);
var state_14396__$1 = state_14396;
var statearr_14410_14431 = state_14396__$1;
(statearr_14410_14431[(2)] = inst_14390);

(statearr_14410_14431[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14397 === (10))){
var state_14396__$1 = state_14396;
var statearr_14411_14432 = state_14396__$1;
(statearr_14411_14432[(2)] = fc);

(statearr_14411_14432[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14397 === (8))){
var inst_14385 = (state_14396[(2)]);
var state_14396__$1 = state_14396;
if(cljs.core.truth_(inst_14385)){
var statearr_14412_14433 = state_14396__$1;
(statearr_14412_14433[(1)] = (12));

} else {
var statearr_14413_14434 = state_14396__$1;
(statearr_14413_14434[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13883__auto__ = null;
var cljs$core$async$state_machine__13883__auto____0 = (function (){
var statearr_14414 = [null,null,null,null,null,null,null,null,null];
(statearr_14414[(0)] = cljs$core$async$state_machine__13883__auto__);

(statearr_14414[(1)] = (1));

return statearr_14414;
});
var cljs$core$async$state_machine__13883__auto____1 = (function (state_14396){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_14396);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e14415){var ex__13886__auto__ = e14415;
var statearr_14416_14435 = state_14396;
(statearr_14416_14435[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_14396[(4)]))){
var statearr_14417_14436 = state_14396;
(statearr_14417_14436[(1)] = cljs.core.first((state_14396[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__14437 = state_14396;
state_14396 = G__14437;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$state_machine__13883__auto__ = function(state_14396){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13883__auto____1.call(this,state_14396);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13883__auto____0;
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13883__auto____1;
return cljs$core$async$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_14418 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_14418[(6)] = c__13957__auto___14420);

return statearr_14418;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_14459){
var state_val_14460 = (state_14459[(1)]);
if((state_val_14460 === (7))){
var inst_14455 = (state_14459[(2)]);
var state_14459__$1 = state_14459;
var statearr_14461_14480 = state_14459__$1;
(statearr_14461_14480[(2)] = inst_14455);

(statearr_14461_14480[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14460 === (1))){
var inst_14438 = init;
var inst_14439 = inst_14438;
var state_14459__$1 = (function (){var statearr_14462 = state_14459;
(statearr_14462[(7)] = inst_14439);

return statearr_14462;
})();
var statearr_14463_14481 = state_14459__$1;
(statearr_14463_14481[(2)] = null);

(statearr_14463_14481[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14460 === (4))){
var inst_14442 = (state_14459[(8)]);
var inst_14442__$1 = (state_14459[(2)]);
var inst_14443 = (inst_14442__$1 == null);
var state_14459__$1 = (function (){var statearr_14464 = state_14459;
(statearr_14464[(8)] = inst_14442__$1);

return statearr_14464;
})();
if(cljs.core.truth_(inst_14443)){
var statearr_14465_14482 = state_14459__$1;
(statearr_14465_14482[(1)] = (5));

} else {
var statearr_14466_14483 = state_14459__$1;
(statearr_14466_14483[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14460 === (6))){
var inst_14439 = (state_14459[(7)]);
var inst_14446 = (state_14459[(9)]);
var inst_14442 = (state_14459[(8)]);
var inst_14446__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_14439,inst_14442) : f.call(null,inst_14439,inst_14442));
var inst_14447 = cljs.core.reduced_QMARK_(inst_14446__$1);
var state_14459__$1 = (function (){var statearr_14467 = state_14459;
(statearr_14467[(9)] = inst_14446__$1);

return statearr_14467;
})();
if(inst_14447){
var statearr_14468_14484 = state_14459__$1;
(statearr_14468_14484[(1)] = (8));

} else {
var statearr_14469_14485 = state_14459__$1;
(statearr_14469_14485[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14460 === (3))){
var inst_14457 = (state_14459[(2)]);
var state_14459__$1 = state_14459;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14459__$1,inst_14457);
} else {
if((state_val_14460 === (2))){
var state_14459__$1 = state_14459;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14459__$1,(4),ch);
} else {
if((state_val_14460 === (9))){
var inst_14446 = (state_14459[(9)]);
var inst_14439 = inst_14446;
var state_14459__$1 = (function (){var statearr_14470 = state_14459;
(statearr_14470[(7)] = inst_14439);

return statearr_14470;
})();
var statearr_14471_14486 = state_14459__$1;
(statearr_14471_14486[(2)] = null);

(statearr_14471_14486[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14460 === (5))){
var inst_14439 = (state_14459[(7)]);
var state_14459__$1 = state_14459;
var statearr_14472_14487 = state_14459__$1;
(statearr_14472_14487[(2)] = inst_14439);

(statearr_14472_14487[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14460 === (10))){
var inst_14453 = (state_14459[(2)]);
var state_14459__$1 = state_14459;
var statearr_14473_14488 = state_14459__$1;
(statearr_14473_14488[(2)] = inst_14453);

(statearr_14473_14488[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14460 === (8))){
var inst_14446 = (state_14459[(9)]);
var inst_14449 = cljs.core.deref(inst_14446);
var state_14459__$1 = state_14459;
var statearr_14474_14489 = state_14459__$1;
(statearr_14474_14489[(2)] = inst_14449);

(statearr_14474_14489[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__13883__auto__ = null;
var cljs$core$async$reduce_$_state_machine__13883__auto____0 = (function (){
var statearr_14475 = [null,null,null,null,null,null,null,null,null,null];
(statearr_14475[(0)] = cljs$core$async$reduce_$_state_machine__13883__auto__);

(statearr_14475[(1)] = (1));

return statearr_14475;
});
var cljs$core$async$reduce_$_state_machine__13883__auto____1 = (function (state_14459){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_14459);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e14476){var ex__13886__auto__ = e14476;
var statearr_14477_14490 = state_14459;
(statearr_14477_14490[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_14459[(4)]))){
var statearr_14478_14491 = state_14459;
(statearr_14478_14491[(1)] = cljs.core.first((state_14459[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__14492 = state_14459;
state_14459 = G__14492;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__13883__auto__ = function(state_14459){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__13883__auto____1.call(this,state_14459);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__13883__auto____0;
cljs$core$async$reduce_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__13883__auto____1;
return cljs$core$async$reduce_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_14479 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_14479[(6)] = c__13957__auto__);

return statearr_14479;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_14498){
var state_val_14499 = (state_14498[(1)]);
if((state_val_14499 === (1))){
var inst_14493 = cljs.core.async.reduce(f__$1,init,ch);
var state_14498__$1 = state_14498;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14498__$1,(2),inst_14493);
} else {
if((state_val_14499 === (2))){
var inst_14495 = (state_14498[(2)]);
var inst_14496 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_14495) : f__$1.call(null,inst_14495));
var state_14498__$1 = state_14498;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14498__$1,inst_14496);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__13883__auto__ = null;
var cljs$core$async$transduce_$_state_machine__13883__auto____0 = (function (){
var statearr_14500 = [null,null,null,null,null,null,null];
(statearr_14500[(0)] = cljs$core$async$transduce_$_state_machine__13883__auto__);

(statearr_14500[(1)] = (1));

return statearr_14500;
});
var cljs$core$async$transduce_$_state_machine__13883__auto____1 = (function (state_14498){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_14498);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e14501){var ex__13886__auto__ = e14501;
var statearr_14502_14505 = state_14498;
(statearr_14502_14505[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_14498[(4)]))){
var statearr_14503_14506 = state_14498;
(statearr_14503_14506[(1)] = cljs.core.first((state_14498[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__14507 = state_14498;
state_14498 = G__14507;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__13883__auto__ = function(state_14498){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__13883__auto____1.call(this,state_14498);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__13883__auto____0;
cljs$core$async$transduce_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__13883__auto____1;
return cljs$core$async$transduce_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_14504 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_14504[(6)] = c__13957__auto__);

return statearr_14504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__14509 = arguments.length;
switch (G__14509) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_14534){
var state_val_14535 = (state_14534[(1)]);
if((state_val_14535 === (7))){
var inst_14516 = (state_14534[(2)]);
var state_14534__$1 = state_14534;
var statearr_14536_14558 = state_14534__$1;
(statearr_14536_14558[(2)] = inst_14516);

(statearr_14536_14558[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14535 === (1))){
var inst_14510 = cljs.core.seq(coll);
var inst_14511 = inst_14510;
var state_14534__$1 = (function (){var statearr_14537 = state_14534;
(statearr_14537[(7)] = inst_14511);

return statearr_14537;
})();
var statearr_14538_14559 = state_14534__$1;
(statearr_14538_14559[(2)] = null);

(statearr_14538_14559[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14535 === (4))){
var inst_14511 = (state_14534[(7)]);
var inst_14514 = cljs.core.first(inst_14511);
var state_14534__$1 = state_14534;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14534__$1,(7),ch,inst_14514);
} else {
if((state_val_14535 === (13))){
var inst_14528 = (state_14534[(2)]);
var state_14534__$1 = state_14534;
var statearr_14539_14560 = state_14534__$1;
(statearr_14539_14560[(2)] = inst_14528);

(statearr_14539_14560[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14535 === (6))){
var inst_14519 = (state_14534[(2)]);
var state_14534__$1 = state_14534;
if(cljs.core.truth_(inst_14519)){
var statearr_14540_14561 = state_14534__$1;
(statearr_14540_14561[(1)] = (8));

} else {
var statearr_14541_14562 = state_14534__$1;
(statearr_14541_14562[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14535 === (3))){
var inst_14532 = (state_14534[(2)]);
var state_14534__$1 = state_14534;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14534__$1,inst_14532);
} else {
if((state_val_14535 === (12))){
var state_14534__$1 = state_14534;
var statearr_14542_14563 = state_14534__$1;
(statearr_14542_14563[(2)] = null);

(statearr_14542_14563[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14535 === (2))){
var inst_14511 = (state_14534[(7)]);
var state_14534__$1 = state_14534;
if(cljs.core.truth_(inst_14511)){
var statearr_14543_14564 = state_14534__$1;
(statearr_14543_14564[(1)] = (4));

} else {
var statearr_14544_14565 = state_14534__$1;
(statearr_14544_14565[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14535 === (11))){
var inst_14525 = cljs.core.async.close_BANG_(ch);
var state_14534__$1 = state_14534;
var statearr_14545_14566 = state_14534__$1;
(statearr_14545_14566[(2)] = inst_14525);

(statearr_14545_14566[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14535 === (9))){
var state_14534__$1 = state_14534;
if(cljs.core.truth_(close_QMARK_)){
var statearr_14546_14567 = state_14534__$1;
(statearr_14546_14567[(1)] = (11));

} else {
var statearr_14547_14568 = state_14534__$1;
(statearr_14547_14568[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14535 === (5))){
var inst_14511 = (state_14534[(7)]);
var state_14534__$1 = state_14534;
var statearr_14548_14569 = state_14534__$1;
(statearr_14548_14569[(2)] = inst_14511);

(statearr_14548_14569[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14535 === (10))){
var inst_14530 = (state_14534[(2)]);
var state_14534__$1 = state_14534;
var statearr_14549_14570 = state_14534__$1;
(statearr_14549_14570[(2)] = inst_14530);

(statearr_14549_14570[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14535 === (8))){
var inst_14511 = (state_14534[(7)]);
var inst_14521 = cljs.core.next(inst_14511);
var inst_14511__$1 = inst_14521;
var state_14534__$1 = (function (){var statearr_14550 = state_14534;
(statearr_14550[(7)] = inst_14511__$1);

return statearr_14550;
})();
var statearr_14551_14571 = state_14534__$1;
(statearr_14551_14571[(2)] = null);

(statearr_14551_14571[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13883__auto__ = null;
var cljs$core$async$state_machine__13883__auto____0 = (function (){
var statearr_14552 = [null,null,null,null,null,null,null,null];
(statearr_14552[(0)] = cljs$core$async$state_machine__13883__auto__);

(statearr_14552[(1)] = (1));

return statearr_14552;
});
var cljs$core$async$state_machine__13883__auto____1 = (function (state_14534){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_14534);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e14553){var ex__13886__auto__ = e14553;
var statearr_14554_14572 = state_14534;
(statearr_14554_14572[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_14534[(4)]))){
var statearr_14555_14573 = state_14534;
(statearr_14555_14573[(1)] = cljs.core.first((state_14534[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__14574 = state_14534;
state_14534 = G__14574;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$state_machine__13883__auto__ = function(state_14534){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13883__auto____1.call(this,state_14534);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13883__auto____0;
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13883__auto____1;
return cljs$core$async$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_14556 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_14556[(6)] = c__13957__auto__);

return statearr_14556;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__14576 = arguments.length;
switch (G__14576) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_14578 = (function (_){
var x__4463__auto__ = (((_ == null))?null:_);
var m__4464__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4464__auto__.call(null,_));
} else {
var m__4461__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4461__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_14578(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_14579 = (function (m,ch,close_QMARK_){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4464__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4461__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4461__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_14579(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_14580 = (function (m,ch){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4464__auto__.call(null,m,ch));
} else {
var m__4461__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4461__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_14580(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_14581 = (function (m){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4464__auto__.call(null,m));
} else {
var m__4461__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4461__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_14581(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async14582 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14582 = (function (ch,cs,meta14583){
this.ch = ch;
this.cs = cs;
this.meta14583 = meta14583;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14582.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14584,meta14583__$1){
var self__ = this;
var _14584__$1 = this;
return (new cljs.core.async.t_cljs$core$async14582(self__.ch,self__.cs,meta14583__$1));
}));

(cljs.core.async.t_cljs$core$async14582.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14584){
var self__ = this;
var _14584__$1 = this;
return self__.meta14583;
}));

(cljs.core.async.t_cljs$core$async14582.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14582.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async14582.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14582.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async14582.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async14582.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async14582.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta14583], null);
}));

(cljs.core.async.t_cljs$core$async14582.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14582.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14582");

(cljs.core.async.t_cljs$core$async14582.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async14582");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14582.
 */
cljs.core.async.__GT_t_cljs$core$async14582 = (function cljs$core$async$mult_$___GT_t_cljs$core$async14582(ch__$1,cs__$1,meta14583){
return (new cljs.core.async.t_cljs$core$async14582(ch__$1,cs__$1,meta14583));
});

}

return (new cljs.core.async.t_cljs$core$async14582(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__13957__auto___14801 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_14717){
var state_val_14718 = (state_14717[(1)]);
if((state_val_14718 === (7))){
var inst_14713 = (state_14717[(2)]);
var state_14717__$1 = state_14717;
var statearr_14719_14802 = state_14717__$1;
(statearr_14719_14802[(2)] = inst_14713);

(statearr_14719_14802[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (20))){
var inst_14618 = (state_14717[(7)]);
var inst_14630 = cljs.core.first(inst_14618);
var inst_14631 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14630,(0),null);
var inst_14632 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14630,(1),null);
var state_14717__$1 = (function (){var statearr_14720 = state_14717;
(statearr_14720[(8)] = inst_14631);

return statearr_14720;
})();
if(cljs.core.truth_(inst_14632)){
var statearr_14721_14803 = state_14717__$1;
(statearr_14721_14803[(1)] = (22));

} else {
var statearr_14722_14804 = state_14717__$1;
(statearr_14722_14804[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (27))){
var inst_14662 = (state_14717[(9)]);
var inst_14587 = (state_14717[(10)]);
var inst_14667 = (state_14717[(11)]);
var inst_14660 = (state_14717[(12)]);
var inst_14667__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_14660,inst_14662);
var inst_14668 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_14667__$1,inst_14587,done);
var state_14717__$1 = (function (){var statearr_14723 = state_14717;
(statearr_14723[(11)] = inst_14667__$1);

return statearr_14723;
})();
if(cljs.core.truth_(inst_14668)){
var statearr_14724_14805 = state_14717__$1;
(statearr_14724_14805[(1)] = (30));

} else {
var statearr_14725_14806 = state_14717__$1;
(statearr_14725_14806[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (1))){
var state_14717__$1 = state_14717;
var statearr_14726_14807 = state_14717__$1;
(statearr_14726_14807[(2)] = null);

(statearr_14726_14807[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (24))){
var inst_14618 = (state_14717[(7)]);
var inst_14637 = (state_14717[(2)]);
var inst_14638 = cljs.core.next(inst_14618);
var inst_14596 = inst_14638;
var inst_14597 = null;
var inst_14598 = (0);
var inst_14599 = (0);
var state_14717__$1 = (function (){var statearr_14727 = state_14717;
(statearr_14727[(13)] = inst_14596);

(statearr_14727[(14)] = inst_14599);

(statearr_14727[(15)] = inst_14597);

(statearr_14727[(16)] = inst_14637);

(statearr_14727[(17)] = inst_14598);

return statearr_14727;
})();
var statearr_14728_14808 = state_14717__$1;
(statearr_14728_14808[(2)] = null);

(statearr_14728_14808[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (39))){
var state_14717__$1 = state_14717;
var statearr_14732_14809 = state_14717__$1;
(statearr_14732_14809[(2)] = null);

(statearr_14732_14809[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (4))){
var inst_14587 = (state_14717[(10)]);
var inst_14587__$1 = (state_14717[(2)]);
var inst_14588 = (inst_14587__$1 == null);
var state_14717__$1 = (function (){var statearr_14733 = state_14717;
(statearr_14733[(10)] = inst_14587__$1);

return statearr_14733;
})();
if(cljs.core.truth_(inst_14588)){
var statearr_14734_14810 = state_14717__$1;
(statearr_14734_14810[(1)] = (5));

} else {
var statearr_14735_14811 = state_14717__$1;
(statearr_14735_14811[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (15))){
var inst_14596 = (state_14717[(13)]);
var inst_14599 = (state_14717[(14)]);
var inst_14597 = (state_14717[(15)]);
var inst_14598 = (state_14717[(17)]);
var inst_14614 = (state_14717[(2)]);
var inst_14615 = (inst_14599 + (1));
var tmp14729 = inst_14596;
var tmp14730 = inst_14597;
var tmp14731 = inst_14598;
var inst_14596__$1 = tmp14729;
var inst_14597__$1 = tmp14730;
var inst_14598__$1 = tmp14731;
var inst_14599__$1 = inst_14615;
var state_14717__$1 = (function (){var statearr_14736 = state_14717;
(statearr_14736[(18)] = inst_14614);

(statearr_14736[(13)] = inst_14596__$1);

(statearr_14736[(14)] = inst_14599__$1);

(statearr_14736[(15)] = inst_14597__$1);

(statearr_14736[(17)] = inst_14598__$1);

return statearr_14736;
})();
var statearr_14737_14812 = state_14717__$1;
(statearr_14737_14812[(2)] = null);

(statearr_14737_14812[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (21))){
var inst_14641 = (state_14717[(2)]);
var state_14717__$1 = state_14717;
var statearr_14741_14813 = state_14717__$1;
(statearr_14741_14813[(2)] = inst_14641);

(statearr_14741_14813[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (31))){
var inst_14667 = (state_14717[(11)]);
var inst_14671 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_14667);
var state_14717__$1 = state_14717;
var statearr_14742_14814 = state_14717__$1;
(statearr_14742_14814[(2)] = inst_14671);

(statearr_14742_14814[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (32))){
var inst_14662 = (state_14717[(9)]);
var inst_14661 = (state_14717[(19)]);
var inst_14659 = (state_14717[(20)]);
var inst_14660 = (state_14717[(12)]);
var inst_14673 = (state_14717[(2)]);
var inst_14674 = (inst_14662 + (1));
var tmp14738 = inst_14661;
var tmp14739 = inst_14659;
var tmp14740 = inst_14660;
var inst_14659__$1 = tmp14739;
var inst_14660__$1 = tmp14740;
var inst_14661__$1 = tmp14738;
var inst_14662__$1 = inst_14674;
var state_14717__$1 = (function (){var statearr_14743 = state_14717;
(statearr_14743[(9)] = inst_14662__$1);

(statearr_14743[(19)] = inst_14661__$1);

(statearr_14743[(20)] = inst_14659__$1);

(statearr_14743[(12)] = inst_14660__$1);

(statearr_14743[(21)] = inst_14673);

return statearr_14743;
})();
var statearr_14744_14815 = state_14717__$1;
(statearr_14744_14815[(2)] = null);

(statearr_14744_14815[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (40))){
var inst_14686 = (state_14717[(22)]);
var inst_14690 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_14686);
var state_14717__$1 = state_14717;
var statearr_14745_14816 = state_14717__$1;
(statearr_14745_14816[(2)] = inst_14690);

(statearr_14745_14816[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (33))){
var inst_14677 = (state_14717[(23)]);
var inst_14679 = cljs.core.chunked_seq_QMARK_(inst_14677);
var state_14717__$1 = state_14717;
if(inst_14679){
var statearr_14746_14817 = state_14717__$1;
(statearr_14746_14817[(1)] = (36));

} else {
var statearr_14747_14818 = state_14717__$1;
(statearr_14747_14818[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (13))){
var inst_14608 = (state_14717[(24)]);
var inst_14611 = cljs.core.async.close_BANG_(inst_14608);
var state_14717__$1 = state_14717;
var statearr_14748_14819 = state_14717__$1;
(statearr_14748_14819[(2)] = inst_14611);

(statearr_14748_14819[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (22))){
var inst_14631 = (state_14717[(8)]);
var inst_14634 = cljs.core.async.close_BANG_(inst_14631);
var state_14717__$1 = state_14717;
var statearr_14749_14820 = state_14717__$1;
(statearr_14749_14820[(2)] = inst_14634);

(statearr_14749_14820[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (36))){
var inst_14677 = (state_14717[(23)]);
var inst_14681 = cljs.core.chunk_first(inst_14677);
var inst_14682 = cljs.core.chunk_rest(inst_14677);
var inst_14683 = cljs.core.count(inst_14681);
var inst_14659 = inst_14682;
var inst_14660 = inst_14681;
var inst_14661 = inst_14683;
var inst_14662 = (0);
var state_14717__$1 = (function (){var statearr_14750 = state_14717;
(statearr_14750[(9)] = inst_14662);

(statearr_14750[(19)] = inst_14661);

(statearr_14750[(20)] = inst_14659);

(statearr_14750[(12)] = inst_14660);

return statearr_14750;
})();
var statearr_14751_14821 = state_14717__$1;
(statearr_14751_14821[(2)] = null);

(statearr_14751_14821[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (41))){
var inst_14677 = (state_14717[(23)]);
var inst_14692 = (state_14717[(2)]);
var inst_14693 = cljs.core.next(inst_14677);
var inst_14659 = inst_14693;
var inst_14660 = null;
var inst_14661 = (0);
var inst_14662 = (0);
var state_14717__$1 = (function (){var statearr_14752 = state_14717;
(statearr_14752[(9)] = inst_14662);

(statearr_14752[(19)] = inst_14661);

(statearr_14752[(20)] = inst_14659);

(statearr_14752[(25)] = inst_14692);

(statearr_14752[(12)] = inst_14660);

return statearr_14752;
})();
var statearr_14753_14822 = state_14717__$1;
(statearr_14753_14822[(2)] = null);

(statearr_14753_14822[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (43))){
var state_14717__$1 = state_14717;
var statearr_14754_14823 = state_14717__$1;
(statearr_14754_14823[(2)] = null);

(statearr_14754_14823[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (29))){
var inst_14701 = (state_14717[(2)]);
var state_14717__$1 = state_14717;
var statearr_14755_14824 = state_14717__$1;
(statearr_14755_14824[(2)] = inst_14701);

(statearr_14755_14824[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (44))){
var inst_14710 = (state_14717[(2)]);
var state_14717__$1 = (function (){var statearr_14756 = state_14717;
(statearr_14756[(26)] = inst_14710);

return statearr_14756;
})();
var statearr_14757_14825 = state_14717__$1;
(statearr_14757_14825[(2)] = null);

(statearr_14757_14825[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (6))){
var inst_14651 = (state_14717[(27)]);
var inst_14650 = cljs.core.deref(cs);
var inst_14651__$1 = cljs.core.keys(inst_14650);
var inst_14652 = cljs.core.count(inst_14651__$1);
var inst_14653 = cljs.core.reset_BANG_(dctr,inst_14652);
var inst_14658 = cljs.core.seq(inst_14651__$1);
var inst_14659 = inst_14658;
var inst_14660 = null;
var inst_14661 = (0);
var inst_14662 = (0);
var state_14717__$1 = (function (){var statearr_14758 = state_14717;
(statearr_14758[(9)] = inst_14662);

(statearr_14758[(19)] = inst_14661);

(statearr_14758[(28)] = inst_14653);

(statearr_14758[(20)] = inst_14659);

(statearr_14758[(12)] = inst_14660);

(statearr_14758[(27)] = inst_14651__$1);

return statearr_14758;
})();
var statearr_14759_14826 = state_14717__$1;
(statearr_14759_14826[(2)] = null);

(statearr_14759_14826[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (28))){
var inst_14659 = (state_14717[(20)]);
var inst_14677 = (state_14717[(23)]);
var inst_14677__$1 = cljs.core.seq(inst_14659);
var state_14717__$1 = (function (){var statearr_14760 = state_14717;
(statearr_14760[(23)] = inst_14677__$1);

return statearr_14760;
})();
if(inst_14677__$1){
var statearr_14761_14827 = state_14717__$1;
(statearr_14761_14827[(1)] = (33));

} else {
var statearr_14762_14828 = state_14717__$1;
(statearr_14762_14828[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (25))){
var inst_14662 = (state_14717[(9)]);
var inst_14661 = (state_14717[(19)]);
var inst_14664 = (inst_14662 < inst_14661);
var inst_14665 = inst_14664;
var state_14717__$1 = state_14717;
if(cljs.core.truth_(inst_14665)){
var statearr_14763_14829 = state_14717__$1;
(statearr_14763_14829[(1)] = (27));

} else {
var statearr_14764_14830 = state_14717__$1;
(statearr_14764_14830[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (34))){
var state_14717__$1 = state_14717;
var statearr_14765_14831 = state_14717__$1;
(statearr_14765_14831[(2)] = null);

(statearr_14765_14831[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (17))){
var state_14717__$1 = state_14717;
var statearr_14766_14832 = state_14717__$1;
(statearr_14766_14832[(2)] = null);

(statearr_14766_14832[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (3))){
var inst_14715 = (state_14717[(2)]);
var state_14717__$1 = state_14717;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14717__$1,inst_14715);
} else {
if((state_val_14718 === (12))){
var inst_14646 = (state_14717[(2)]);
var state_14717__$1 = state_14717;
var statearr_14767_14833 = state_14717__$1;
(statearr_14767_14833[(2)] = inst_14646);

(statearr_14767_14833[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (2))){
var state_14717__$1 = state_14717;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14717__$1,(4),ch);
} else {
if((state_val_14718 === (23))){
var state_14717__$1 = state_14717;
var statearr_14768_14834 = state_14717__$1;
(statearr_14768_14834[(2)] = null);

(statearr_14768_14834[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (35))){
var inst_14699 = (state_14717[(2)]);
var state_14717__$1 = state_14717;
var statearr_14769_14835 = state_14717__$1;
(statearr_14769_14835[(2)] = inst_14699);

(statearr_14769_14835[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (19))){
var inst_14618 = (state_14717[(7)]);
var inst_14622 = cljs.core.chunk_first(inst_14618);
var inst_14623 = cljs.core.chunk_rest(inst_14618);
var inst_14624 = cljs.core.count(inst_14622);
var inst_14596 = inst_14623;
var inst_14597 = inst_14622;
var inst_14598 = inst_14624;
var inst_14599 = (0);
var state_14717__$1 = (function (){var statearr_14770 = state_14717;
(statearr_14770[(13)] = inst_14596);

(statearr_14770[(14)] = inst_14599);

(statearr_14770[(15)] = inst_14597);

(statearr_14770[(17)] = inst_14598);

return statearr_14770;
})();
var statearr_14771_14836 = state_14717__$1;
(statearr_14771_14836[(2)] = null);

(statearr_14771_14836[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (11))){
var inst_14596 = (state_14717[(13)]);
var inst_14618 = (state_14717[(7)]);
var inst_14618__$1 = cljs.core.seq(inst_14596);
var state_14717__$1 = (function (){var statearr_14772 = state_14717;
(statearr_14772[(7)] = inst_14618__$1);

return statearr_14772;
})();
if(inst_14618__$1){
var statearr_14773_14837 = state_14717__$1;
(statearr_14773_14837[(1)] = (16));

} else {
var statearr_14774_14838 = state_14717__$1;
(statearr_14774_14838[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (9))){
var inst_14648 = (state_14717[(2)]);
var state_14717__$1 = state_14717;
var statearr_14775_14839 = state_14717__$1;
(statearr_14775_14839[(2)] = inst_14648);

(statearr_14775_14839[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (5))){
var inst_14594 = cljs.core.deref(cs);
var inst_14595 = cljs.core.seq(inst_14594);
var inst_14596 = inst_14595;
var inst_14597 = null;
var inst_14598 = (0);
var inst_14599 = (0);
var state_14717__$1 = (function (){var statearr_14776 = state_14717;
(statearr_14776[(13)] = inst_14596);

(statearr_14776[(14)] = inst_14599);

(statearr_14776[(15)] = inst_14597);

(statearr_14776[(17)] = inst_14598);

return statearr_14776;
})();
var statearr_14777_14840 = state_14717__$1;
(statearr_14777_14840[(2)] = null);

(statearr_14777_14840[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (14))){
var state_14717__$1 = state_14717;
var statearr_14778_14841 = state_14717__$1;
(statearr_14778_14841[(2)] = null);

(statearr_14778_14841[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (45))){
var inst_14707 = (state_14717[(2)]);
var state_14717__$1 = state_14717;
var statearr_14779_14842 = state_14717__$1;
(statearr_14779_14842[(2)] = inst_14707);

(statearr_14779_14842[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (26))){
var inst_14651 = (state_14717[(27)]);
var inst_14703 = (state_14717[(2)]);
var inst_14704 = cljs.core.seq(inst_14651);
var state_14717__$1 = (function (){var statearr_14780 = state_14717;
(statearr_14780[(29)] = inst_14703);

return statearr_14780;
})();
if(inst_14704){
var statearr_14781_14843 = state_14717__$1;
(statearr_14781_14843[(1)] = (42));

} else {
var statearr_14782_14844 = state_14717__$1;
(statearr_14782_14844[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (16))){
var inst_14618 = (state_14717[(7)]);
var inst_14620 = cljs.core.chunked_seq_QMARK_(inst_14618);
var state_14717__$1 = state_14717;
if(inst_14620){
var statearr_14783_14845 = state_14717__$1;
(statearr_14783_14845[(1)] = (19));

} else {
var statearr_14784_14846 = state_14717__$1;
(statearr_14784_14846[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (38))){
var inst_14696 = (state_14717[(2)]);
var state_14717__$1 = state_14717;
var statearr_14785_14847 = state_14717__$1;
(statearr_14785_14847[(2)] = inst_14696);

(statearr_14785_14847[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (30))){
var state_14717__$1 = state_14717;
var statearr_14786_14848 = state_14717__$1;
(statearr_14786_14848[(2)] = null);

(statearr_14786_14848[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (10))){
var inst_14599 = (state_14717[(14)]);
var inst_14597 = (state_14717[(15)]);
var inst_14607 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_14597,inst_14599);
var inst_14608 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14607,(0),null);
var inst_14609 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14607,(1),null);
var state_14717__$1 = (function (){var statearr_14787 = state_14717;
(statearr_14787[(24)] = inst_14608);

return statearr_14787;
})();
if(cljs.core.truth_(inst_14609)){
var statearr_14788_14849 = state_14717__$1;
(statearr_14788_14849[(1)] = (13));

} else {
var statearr_14789_14850 = state_14717__$1;
(statearr_14789_14850[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (18))){
var inst_14644 = (state_14717[(2)]);
var state_14717__$1 = state_14717;
var statearr_14790_14851 = state_14717__$1;
(statearr_14790_14851[(2)] = inst_14644);

(statearr_14790_14851[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (42))){
var state_14717__$1 = state_14717;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_14717__$1,(45),dchan);
} else {
if((state_val_14718 === (37))){
var inst_14587 = (state_14717[(10)]);
var inst_14677 = (state_14717[(23)]);
var inst_14686 = (state_14717[(22)]);
var inst_14686__$1 = cljs.core.first(inst_14677);
var inst_14687 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_14686__$1,inst_14587,done);
var state_14717__$1 = (function (){var statearr_14791 = state_14717;
(statearr_14791[(22)] = inst_14686__$1);

return statearr_14791;
})();
if(cljs.core.truth_(inst_14687)){
var statearr_14792_14852 = state_14717__$1;
(statearr_14792_14852[(1)] = (39));

} else {
var statearr_14793_14853 = state_14717__$1;
(statearr_14793_14853[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14718 === (8))){
var inst_14599 = (state_14717[(14)]);
var inst_14598 = (state_14717[(17)]);
var inst_14601 = (inst_14599 < inst_14598);
var inst_14602 = inst_14601;
var state_14717__$1 = state_14717;
if(cljs.core.truth_(inst_14602)){
var statearr_14794_14854 = state_14717__$1;
(statearr_14794_14854[(1)] = (10));

} else {
var statearr_14795_14855 = state_14717__$1;
(statearr_14795_14855[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__13883__auto__ = null;
var cljs$core$async$mult_$_state_machine__13883__auto____0 = (function (){
var statearr_14796 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14796[(0)] = cljs$core$async$mult_$_state_machine__13883__auto__);

(statearr_14796[(1)] = (1));

return statearr_14796;
});
var cljs$core$async$mult_$_state_machine__13883__auto____1 = (function (state_14717){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_14717);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e14797){var ex__13886__auto__ = e14797;
var statearr_14798_14856 = state_14717;
(statearr_14798_14856[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_14717[(4)]))){
var statearr_14799_14857 = state_14717;
(statearr_14799_14857[(1)] = cljs.core.first((state_14717[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__14858 = state_14717;
state_14717 = G__14858;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__13883__auto__ = function(state_14717){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__13883__auto____1.call(this,state_14717);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__13883__auto____0;
cljs$core$async$mult_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__13883__auto____1;
return cljs$core$async$mult_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_14800 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_14800[(6)] = c__13957__auto___14801);

return statearr_14800;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__14860 = arguments.length;
switch (G__14860) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_14862 = (function (m,ch){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4464__auto__.call(null,m,ch));
} else {
var m__4461__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4461__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_14862(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_14863 = (function (m,ch){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4464__auto__.call(null,m,ch));
} else {
var m__4461__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4461__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_14863(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_14864 = (function (m){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4464__auto__.call(null,m));
} else {
var m__4461__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4461__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_14864(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_14865 = (function (m,state_map){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4464__auto__.call(null,m,state_map));
} else {
var m__4461__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4461__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_14865(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_14866 = (function (m,mode){
var x__4463__auto__ = (((m == null))?null:m);
var m__4464__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4464__auto__.call(null,m,mode));
} else {
var m__4461__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4461__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_14866(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4777__auto__ = [];
var len__4771__auto___14876 = arguments.length;
var i__4772__auto___14877 = (0);
while(true){
if((i__4772__auto___14877 < len__4771__auto___14876)){
args__4777__auto__.push((arguments[i__4772__auto___14877]));

var G__14878 = (i__4772__auto___14877 + (1));
i__4772__auto___14877 = G__14878;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((3) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4778__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__14871){
var map__14872 = p__14871;
var map__14872__$1 = cljs.core.__destructure_map(map__14872);
var opts = map__14872__$1;
var statearr_14873_14879 = state;
(statearr_14873_14879[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_14874_14880 = state;
(statearr_14874_14880[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_14875_14881 = state;
(statearr_14875_14881[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq14867){
var G__14868 = cljs.core.first(seq14867);
var seq14867__$1 = cljs.core.next(seq14867);
var G__14869 = cljs.core.first(seq14867__$1);
var seq14867__$2 = cljs.core.next(seq14867__$1);
var G__14870 = cljs.core.first(seq14867__$2);
var seq14867__$3 = cljs.core.next(seq14867__$2);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__14868,G__14869,G__14870,seq14867__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async14882 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14882 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta14883){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta14883 = meta14883;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async14882.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14884,meta14883__$1){
var self__ = this;
var _14884__$1 = this;
return (new cljs.core.async.t_cljs$core$async14882(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta14883__$1));
}));

(cljs.core.async.t_cljs$core$async14882.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14884){
var self__ = this;
var _14884__$1 = this;
return self__.meta14883;
}));

(cljs.core.async.t_cljs$core$async14882.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14882.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async14882.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async14882.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async14882.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async14882.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async14882.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async14882.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async14882.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta14883], null);
}));

(cljs.core.async.t_cljs$core$async14882.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async14882.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14882");

(cljs.core.async.t_cljs$core$async14882.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async14882");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async14882.
 */
cljs.core.async.__GT_t_cljs$core$async14882 = (function cljs$core$async$mix_$___GT_t_cljs$core$async14882(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta14883){
return (new cljs.core.async.t_cljs$core$async14882(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta14883));
});

}

return (new cljs.core.async.t_cljs$core$async14882(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__13957__auto___14982 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_14946){
var state_val_14947 = (state_14946[(1)]);
if((state_val_14947 === (7))){
var inst_14942 = (state_14946[(2)]);
var state_14946__$1 = state_14946;
var statearr_14948_14983 = state_14946__$1;
(statearr_14948_14983[(2)] = inst_14942);

(statearr_14948_14983[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14947 === (20))){
var inst_14936 = (state_14946[(2)]);
var state_14946__$1 = state_14946;
var statearr_14949_14984 = state_14946__$1;
(statearr_14949_14984[(2)] = inst_14936);

(statearr_14949_14984[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14947 === (1))){
var inst_14888 = calc_state();
var inst_14889 = cljs.core.__destructure_map(inst_14888);
var inst_14890 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14889,cljs.core.cst$kw$solos);
var inst_14891 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14889,cljs.core.cst$kw$mutes);
var inst_14892 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14889,cljs.core.cst$kw$reads);
var inst_14893 = inst_14888;
var state_14946__$1 = (function (){var statearr_14950 = state_14946;
(statearr_14950[(7)] = inst_14891);

(statearr_14950[(8)] = inst_14892);

(statearr_14950[(9)] = inst_14893);

(statearr_14950[(10)] = inst_14890);

return statearr_14950;
})();
var statearr_14951_14985 = state_14946__$1;
(statearr_14951_14985[(2)] = null);

(statearr_14951_14985[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14947 === (4))){
var inst_14906 = (state_14946[(11)]);
var inst_14905 = (state_14946[(12)]);
var inst_14904 = (state_14946[(2)]);
var inst_14905__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14904,(0),null);
var inst_14906__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_14904,(1),null);
var inst_14907 = (inst_14905__$1 == null);
var inst_14908 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_14906__$1,change);
var inst_14909 = ((inst_14907) || (inst_14908));
var state_14946__$1 = (function (){var statearr_14952 = state_14946;
(statearr_14952[(11)] = inst_14906__$1);

(statearr_14952[(12)] = inst_14905__$1);

return statearr_14952;
})();
if(cljs.core.truth_(inst_14909)){
var statearr_14953_14986 = state_14946__$1;
(statearr_14953_14986[(1)] = (5));

} else {
var statearr_14954_14987 = state_14946__$1;
(statearr_14954_14987[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14947 === (15))){
var inst_14896 = (state_14946[(13)]);
var inst_14893 = inst_14896;
var state_14946__$1 = (function (){var statearr_14955 = state_14946;
(statearr_14955[(9)] = inst_14893);

return statearr_14955;
})();
var statearr_14956_14988 = state_14946__$1;
(statearr_14956_14988[(2)] = null);

(statearr_14956_14988[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14947 === (13))){
var inst_14928 = (state_14946[(2)]);
var state_14946__$1 = state_14946;
if(cljs.core.truth_(inst_14928)){
var statearr_14957_14989 = state_14946__$1;
(statearr_14957_14989[(1)] = (14));

} else {
var statearr_14958_14990 = state_14946__$1;
(statearr_14958_14990[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14947 === (6))){
var inst_14906 = (state_14946[(11)]);
var inst_14897 = (state_14946[(14)]);
var inst_14920 = (state_14946[(15)]);
var inst_14920__$1 = (inst_14897.cljs$core$IFn$_invoke$arity$1 ? inst_14897.cljs$core$IFn$_invoke$arity$1(inst_14906) : inst_14897.call(null,inst_14906));
var state_14946__$1 = (function (){var statearr_14959 = state_14946;
(statearr_14959[(15)] = inst_14920__$1);

return statearr_14959;
})();
if(cljs.core.truth_(inst_14920__$1)){
var statearr_14960_14991 = state_14946__$1;
(statearr_14960_14991[(1)] = (11));

} else {
var statearr_14961_14992 = state_14946__$1;
(statearr_14961_14992[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14947 === (17))){
var inst_14931 = (state_14946[(2)]);
var state_14946__$1 = state_14946;
if(cljs.core.truth_(inst_14931)){
var statearr_14962_14993 = state_14946__$1;
(statearr_14962_14993[(1)] = (18));

} else {
var statearr_14963_14994 = state_14946__$1;
(statearr_14963_14994[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14947 === (3))){
var inst_14944 = (state_14946[(2)]);
var state_14946__$1 = state_14946;
return cljs.core.async.impl.ioc_helpers.return_chan(state_14946__$1,inst_14944);
} else {
if((state_val_14947 === (12))){
var inst_14898 = (state_14946[(16)]);
var inst_14906 = (state_14946[(11)]);
var inst_14897 = (state_14946[(14)]);
var inst_14923 = cljs.core.empty_QMARK_(inst_14897);
var inst_14924 = (inst_14898.cljs$core$IFn$_invoke$arity$1 ? inst_14898.cljs$core$IFn$_invoke$arity$1(inst_14906) : inst_14898.call(null,inst_14906));
var inst_14925 = cljs.core.not(inst_14924);
var inst_14926 = ((inst_14923) && (inst_14925));
var state_14946__$1 = state_14946;
var statearr_14964_14995 = state_14946__$1;
(statearr_14964_14995[(2)] = inst_14926);

(statearr_14964_14995[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14947 === (2))){
var inst_14896 = (state_14946[(13)]);
var inst_14893 = (state_14946[(9)]);
var inst_14896__$1 = cljs.core.__destructure_map(inst_14893);
var inst_14897 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14896__$1,cljs.core.cst$kw$solos);
var inst_14898 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14896__$1,cljs.core.cst$kw$mutes);
var inst_14899 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_14896__$1,cljs.core.cst$kw$reads);
var state_14946__$1 = (function (){var statearr_14965 = state_14946;
(statearr_14965[(16)] = inst_14898);

(statearr_14965[(13)] = inst_14896__$1);

(statearr_14965[(14)] = inst_14897);

return statearr_14965;
})();
return cljs.core.async.ioc_alts_BANG_(state_14946__$1,(4),inst_14899);
} else {
if((state_val_14947 === (19))){
var state_14946__$1 = state_14946;
var statearr_14966_14996 = state_14946__$1;
(statearr_14966_14996[(2)] = null);

(statearr_14966_14996[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14947 === (11))){
var inst_14920 = (state_14946[(15)]);
var state_14946__$1 = state_14946;
var statearr_14967_14997 = state_14946__$1;
(statearr_14967_14997[(2)] = inst_14920);

(statearr_14967_14997[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14947 === (9))){
var state_14946__$1 = state_14946;
var statearr_14968_14998 = state_14946__$1;
(statearr_14968_14998[(2)] = null);

(statearr_14968_14998[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14947 === (5))){
var inst_14905 = (state_14946[(12)]);
var inst_14911 = (inst_14905 == null);
var state_14946__$1 = state_14946;
if(cljs.core.truth_(inst_14911)){
var statearr_14969_14999 = state_14946__$1;
(statearr_14969_14999[(1)] = (8));

} else {
var statearr_14970_15000 = state_14946__$1;
(statearr_14970_15000[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_14947 === (14))){
var inst_14905 = (state_14946[(12)]);
var state_14946__$1 = state_14946;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_14946__$1,(17),out,inst_14905);
} else {
if((state_val_14947 === (16))){
var inst_14940 = (state_14946[(2)]);
var state_14946__$1 = state_14946;
var statearr_14971_15001 = state_14946__$1;
(statearr_14971_15001[(2)] = inst_14940);

(statearr_14971_15001[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14947 === (10))){
var inst_14916 = (state_14946[(2)]);
var inst_14917 = calc_state();
var inst_14893 = inst_14917;
var state_14946__$1 = (function (){var statearr_14972 = state_14946;
(statearr_14972[(9)] = inst_14893);

(statearr_14972[(17)] = inst_14916);

return statearr_14972;
})();
var statearr_14973_15002 = state_14946__$1;
(statearr_14973_15002[(2)] = null);

(statearr_14973_15002[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14947 === (18))){
var inst_14896 = (state_14946[(13)]);
var inst_14893 = inst_14896;
var state_14946__$1 = (function (){var statearr_14974 = state_14946;
(statearr_14974[(9)] = inst_14893);

return statearr_14974;
})();
var statearr_14975_15003 = state_14946__$1;
(statearr_14975_15003[(2)] = null);

(statearr_14975_15003[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_14947 === (8))){
var inst_14906 = (state_14946[(11)]);
var inst_14913 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_14906);
var state_14946__$1 = state_14946;
var statearr_14976_15004 = state_14946__$1;
(statearr_14976_15004[(2)] = inst_14913);

(statearr_14976_15004[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__13883__auto__ = null;
var cljs$core$async$mix_$_state_machine__13883__auto____0 = (function (){
var statearr_14977 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14977[(0)] = cljs$core$async$mix_$_state_machine__13883__auto__);

(statearr_14977[(1)] = (1));

return statearr_14977;
});
var cljs$core$async$mix_$_state_machine__13883__auto____1 = (function (state_14946){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_14946);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e14978){var ex__13886__auto__ = e14978;
var statearr_14979_15005 = state_14946;
(statearr_14979_15005[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_14946[(4)]))){
var statearr_14980_15006 = state_14946;
(statearr_14980_15006[(1)] = cljs.core.first((state_14946[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__15007 = state_14946;
state_14946 = G__15007;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__13883__auto__ = function(state_14946){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__13883__auto____1.call(this,state_14946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__13883__auto____0;
cljs$core$async$mix_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__13883__auto____1;
return cljs$core$async$mix_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_14981 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_14981[(6)] = c__13957__auto___14982);

return statearr_14981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_15010 = (function (p,v,ch,close_QMARK_){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4464__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4461__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4461__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_15010(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_15011 = (function (p,v,ch){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4464__auto__.call(null,p,v,ch));
} else {
var m__4461__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4461__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_15011(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_15012 = (function() {
var G__15013 = null;
var G__15013__1 = (function (p){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4464__auto__.call(null,p));
} else {
var m__4461__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4461__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__15013__2 = (function (p,v){
var x__4463__auto__ = (((p == null))?null:p);
var m__4464__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4463__auto__)]);
if((!((m__4464__auto__ == null)))){
return (m__4464__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4464__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4464__auto__.call(null,p,v));
} else {
var m__4461__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4461__auto__ == null)))){
return (m__4461__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4461__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4461__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__15013 = function(p,v){
switch(arguments.length){
case 1:
return G__15013__1.call(this,p);
case 2:
return G__15013__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__15013.cljs$core$IFn$_invoke$arity$1 = G__15013__1;
G__15013.cljs$core$IFn$_invoke$arity$2 = G__15013__2;
return G__15013;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__15009 = arguments.length;
switch (G__15009) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_15012.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_15012.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__15017 = arguments.length;
switch (G__15017) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4160__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__15015_SHARP_){
if(cljs.core.truth_((p1__15015_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__15015_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__15015_SHARP_.call(null,topic)))){
return p1__15015_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__15015_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15018 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15018 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta15019){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta15019 = meta15019;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15018.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15020,meta15019__$1){
var self__ = this;
var _15020__$1 = this;
return (new cljs.core.async.t_cljs$core$async15018(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta15019__$1));
}));

(cljs.core.async.t_cljs$core$async15018.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15020){
var self__ = this;
var _15020__$1 = this;
return self__.meta15019;
}));

(cljs.core.async.t_cljs$core$async15018.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15018.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async15018.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15018.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async15018.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async15018.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async15018.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async15018.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta15019], null);
}));

(cljs.core.async.t_cljs$core$async15018.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15018.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15018");

(cljs.core.async.t_cljs$core$async15018.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async15018");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15018.
 */
cljs.core.async.__GT_t_cljs$core$async15018 = (function cljs$core$async$__GT_t_cljs$core$async15018(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15019){
return (new cljs.core.async.t_cljs$core$async15018(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta15019));
});

}

return (new cljs.core.async.t_cljs$core$async15018(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__13957__auto___15139 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_15092){
var state_val_15093 = (state_15092[(1)]);
if((state_val_15093 === (7))){
var inst_15088 = (state_15092[(2)]);
var state_15092__$1 = state_15092;
var statearr_15094_15140 = state_15092__$1;
(statearr_15094_15140[(2)] = inst_15088);

(statearr_15094_15140[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (20))){
var state_15092__$1 = state_15092;
var statearr_15095_15141 = state_15092__$1;
(statearr_15095_15141[(2)] = null);

(statearr_15095_15141[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (1))){
var state_15092__$1 = state_15092;
var statearr_15096_15142 = state_15092__$1;
(statearr_15096_15142[(2)] = null);

(statearr_15096_15142[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (24))){
var inst_15071 = (state_15092[(7)]);
var inst_15080 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_15071);
var state_15092__$1 = state_15092;
var statearr_15097_15143 = state_15092__$1;
(statearr_15097_15143[(2)] = inst_15080);

(statearr_15097_15143[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (4))){
var inst_15023 = (state_15092[(8)]);
var inst_15023__$1 = (state_15092[(2)]);
var inst_15024 = (inst_15023__$1 == null);
var state_15092__$1 = (function (){var statearr_15098 = state_15092;
(statearr_15098[(8)] = inst_15023__$1);

return statearr_15098;
})();
if(cljs.core.truth_(inst_15024)){
var statearr_15099_15144 = state_15092__$1;
(statearr_15099_15144[(1)] = (5));

} else {
var statearr_15100_15145 = state_15092__$1;
(statearr_15100_15145[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (15))){
var inst_15065 = (state_15092[(2)]);
var state_15092__$1 = state_15092;
var statearr_15101_15146 = state_15092__$1;
(statearr_15101_15146[(2)] = inst_15065);

(statearr_15101_15146[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (21))){
var inst_15085 = (state_15092[(2)]);
var state_15092__$1 = (function (){var statearr_15102 = state_15092;
(statearr_15102[(9)] = inst_15085);

return statearr_15102;
})();
var statearr_15103_15147 = state_15092__$1;
(statearr_15103_15147[(2)] = null);

(statearr_15103_15147[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (13))){
var inst_15047 = (state_15092[(10)]);
var inst_15049 = cljs.core.chunked_seq_QMARK_(inst_15047);
var state_15092__$1 = state_15092;
if(inst_15049){
var statearr_15104_15148 = state_15092__$1;
(statearr_15104_15148[(1)] = (16));

} else {
var statearr_15105_15149 = state_15092__$1;
(statearr_15105_15149[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (22))){
var inst_15077 = (state_15092[(2)]);
var state_15092__$1 = state_15092;
if(cljs.core.truth_(inst_15077)){
var statearr_15106_15150 = state_15092__$1;
(statearr_15106_15150[(1)] = (23));

} else {
var statearr_15107_15151 = state_15092__$1;
(statearr_15107_15151[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (6))){
var inst_15023 = (state_15092[(8)]);
var inst_15071 = (state_15092[(7)]);
var inst_15073 = (state_15092[(11)]);
var inst_15071__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_15023) : topic_fn.call(null,inst_15023));
var inst_15072 = cljs.core.deref(mults);
var inst_15073__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_15072,inst_15071__$1);
var state_15092__$1 = (function (){var statearr_15108 = state_15092;
(statearr_15108[(7)] = inst_15071__$1);

(statearr_15108[(11)] = inst_15073__$1);

return statearr_15108;
})();
if(cljs.core.truth_(inst_15073__$1)){
var statearr_15109_15152 = state_15092__$1;
(statearr_15109_15152[(1)] = (19));

} else {
var statearr_15110_15153 = state_15092__$1;
(statearr_15110_15153[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (25))){
var inst_15082 = (state_15092[(2)]);
var state_15092__$1 = state_15092;
var statearr_15111_15154 = state_15092__$1;
(statearr_15111_15154[(2)] = inst_15082);

(statearr_15111_15154[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (17))){
var inst_15047 = (state_15092[(10)]);
var inst_15056 = cljs.core.first(inst_15047);
var inst_15057 = cljs.core.async.muxch_STAR_(inst_15056);
var inst_15058 = cljs.core.async.close_BANG_(inst_15057);
var inst_15059 = cljs.core.next(inst_15047);
var inst_15033 = inst_15059;
var inst_15034 = null;
var inst_15035 = (0);
var inst_15036 = (0);
var state_15092__$1 = (function (){var statearr_15112 = state_15092;
(statearr_15112[(12)] = inst_15033);

(statearr_15112[(13)] = inst_15058);

(statearr_15112[(14)] = inst_15036);

(statearr_15112[(15)] = inst_15035);

(statearr_15112[(16)] = inst_15034);

return statearr_15112;
})();
var statearr_15113_15155 = state_15092__$1;
(statearr_15113_15155[(2)] = null);

(statearr_15113_15155[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (3))){
var inst_15090 = (state_15092[(2)]);
var state_15092__$1 = state_15092;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15092__$1,inst_15090);
} else {
if((state_val_15093 === (12))){
var inst_15067 = (state_15092[(2)]);
var state_15092__$1 = state_15092;
var statearr_15114_15156 = state_15092__$1;
(statearr_15114_15156[(2)] = inst_15067);

(statearr_15114_15156[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (2))){
var state_15092__$1 = state_15092;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15092__$1,(4),ch);
} else {
if((state_val_15093 === (23))){
var state_15092__$1 = state_15092;
var statearr_15115_15157 = state_15092__$1;
(statearr_15115_15157[(2)] = null);

(statearr_15115_15157[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (19))){
var inst_15023 = (state_15092[(8)]);
var inst_15073 = (state_15092[(11)]);
var inst_15075 = cljs.core.async.muxch_STAR_(inst_15073);
var state_15092__$1 = state_15092;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15092__$1,(22),inst_15075,inst_15023);
} else {
if((state_val_15093 === (11))){
var inst_15047 = (state_15092[(10)]);
var inst_15033 = (state_15092[(12)]);
var inst_15047__$1 = cljs.core.seq(inst_15033);
var state_15092__$1 = (function (){var statearr_15116 = state_15092;
(statearr_15116[(10)] = inst_15047__$1);

return statearr_15116;
})();
if(inst_15047__$1){
var statearr_15117_15158 = state_15092__$1;
(statearr_15117_15158[(1)] = (13));

} else {
var statearr_15118_15159 = state_15092__$1;
(statearr_15118_15159[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (9))){
var inst_15069 = (state_15092[(2)]);
var state_15092__$1 = state_15092;
var statearr_15119_15160 = state_15092__$1;
(statearr_15119_15160[(2)] = inst_15069);

(statearr_15119_15160[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (5))){
var inst_15030 = cljs.core.deref(mults);
var inst_15031 = cljs.core.vals(inst_15030);
var inst_15032 = cljs.core.seq(inst_15031);
var inst_15033 = inst_15032;
var inst_15034 = null;
var inst_15035 = (0);
var inst_15036 = (0);
var state_15092__$1 = (function (){var statearr_15120 = state_15092;
(statearr_15120[(12)] = inst_15033);

(statearr_15120[(14)] = inst_15036);

(statearr_15120[(15)] = inst_15035);

(statearr_15120[(16)] = inst_15034);

return statearr_15120;
})();
var statearr_15121_15161 = state_15092__$1;
(statearr_15121_15161[(2)] = null);

(statearr_15121_15161[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (14))){
var state_15092__$1 = state_15092;
var statearr_15125_15162 = state_15092__$1;
(statearr_15125_15162[(2)] = null);

(statearr_15125_15162[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (16))){
var inst_15047 = (state_15092[(10)]);
var inst_15051 = cljs.core.chunk_first(inst_15047);
var inst_15052 = cljs.core.chunk_rest(inst_15047);
var inst_15053 = cljs.core.count(inst_15051);
var inst_15033 = inst_15052;
var inst_15034 = inst_15051;
var inst_15035 = inst_15053;
var inst_15036 = (0);
var state_15092__$1 = (function (){var statearr_15126 = state_15092;
(statearr_15126[(12)] = inst_15033);

(statearr_15126[(14)] = inst_15036);

(statearr_15126[(15)] = inst_15035);

(statearr_15126[(16)] = inst_15034);

return statearr_15126;
})();
var statearr_15127_15163 = state_15092__$1;
(statearr_15127_15163[(2)] = null);

(statearr_15127_15163[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (10))){
var inst_15033 = (state_15092[(12)]);
var inst_15036 = (state_15092[(14)]);
var inst_15035 = (state_15092[(15)]);
var inst_15034 = (state_15092[(16)]);
var inst_15041 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_15034,inst_15036);
var inst_15042 = cljs.core.async.muxch_STAR_(inst_15041);
var inst_15043 = cljs.core.async.close_BANG_(inst_15042);
var inst_15044 = (inst_15036 + (1));
var tmp15122 = inst_15033;
var tmp15123 = inst_15035;
var tmp15124 = inst_15034;
var inst_15033__$1 = tmp15122;
var inst_15034__$1 = tmp15124;
var inst_15035__$1 = tmp15123;
var inst_15036__$1 = inst_15044;
var state_15092__$1 = (function (){var statearr_15128 = state_15092;
(statearr_15128[(12)] = inst_15033__$1);

(statearr_15128[(14)] = inst_15036__$1);

(statearr_15128[(15)] = inst_15035__$1);

(statearr_15128[(16)] = inst_15034__$1);

(statearr_15128[(17)] = inst_15043);

return statearr_15128;
})();
var statearr_15129_15164 = state_15092__$1;
(statearr_15129_15164[(2)] = null);

(statearr_15129_15164[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (18))){
var inst_15062 = (state_15092[(2)]);
var state_15092__$1 = state_15092;
var statearr_15130_15165 = state_15092__$1;
(statearr_15130_15165[(2)] = inst_15062);

(statearr_15130_15165[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15093 === (8))){
var inst_15036 = (state_15092[(14)]);
var inst_15035 = (state_15092[(15)]);
var inst_15038 = (inst_15036 < inst_15035);
var inst_15039 = inst_15038;
var state_15092__$1 = state_15092;
if(cljs.core.truth_(inst_15039)){
var statearr_15131_15166 = state_15092__$1;
(statearr_15131_15166[(1)] = (10));

} else {
var statearr_15132_15167 = state_15092__$1;
(statearr_15132_15167[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13883__auto__ = null;
var cljs$core$async$state_machine__13883__auto____0 = (function (){
var statearr_15133 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15133[(0)] = cljs$core$async$state_machine__13883__auto__);

(statearr_15133[(1)] = (1));

return statearr_15133;
});
var cljs$core$async$state_machine__13883__auto____1 = (function (state_15092){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_15092);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e15134){var ex__13886__auto__ = e15134;
var statearr_15135_15168 = state_15092;
(statearr_15135_15168[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_15092[(4)]))){
var statearr_15136_15169 = state_15092;
(statearr_15136_15169[(1)] = cljs.core.first((state_15092[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__15170 = state_15092;
state_15092 = G__15170;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$state_machine__13883__auto__ = function(state_15092){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13883__auto____1.call(this,state_15092);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13883__auto____0;
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13883__auto____1;
return cljs$core$async$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_15137 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_15137[(6)] = c__13957__auto___15139);

return statearr_15137;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__15172 = arguments.length;
switch (G__15172) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__15175 = arguments.length;
switch (G__15175) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__15178 = arguments.length;
switch (G__15178) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__13957__auto___15256 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_15221){
var state_val_15222 = (state_15221[(1)]);
if((state_val_15222 === (7))){
var state_15221__$1 = state_15221;
var statearr_15223_15257 = state_15221__$1;
(statearr_15223_15257[(2)] = null);

(statearr_15223_15257[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15222 === (1))){
var state_15221__$1 = state_15221;
var statearr_15224_15258 = state_15221__$1;
(statearr_15224_15258[(2)] = null);

(statearr_15224_15258[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15222 === (4))){
var inst_15181 = (state_15221[(7)]);
var inst_15182 = (state_15221[(8)]);
var inst_15184 = (inst_15182 < inst_15181);
var state_15221__$1 = state_15221;
if(cljs.core.truth_(inst_15184)){
var statearr_15225_15259 = state_15221__$1;
(statearr_15225_15259[(1)] = (6));

} else {
var statearr_15226_15260 = state_15221__$1;
(statearr_15226_15260[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15222 === (15))){
var inst_15207 = (state_15221[(9)]);
var inst_15212 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_15207);
var state_15221__$1 = state_15221;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15221__$1,(17),out,inst_15212);
} else {
if((state_val_15222 === (13))){
var inst_15207 = (state_15221[(9)]);
var inst_15207__$1 = (state_15221[(2)]);
var inst_15208 = cljs.core.some(cljs.core.nil_QMARK_,inst_15207__$1);
var state_15221__$1 = (function (){var statearr_15227 = state_15221;
(statearr_15227[(9)] = inst_15207__$1);

return statearr_15227;
})();
if(cljs.core.truth_(inst_15208)){
var statearr_15228_15261 = state_15221__$1;
(statearr_15228_15261[(1)] = (14));

} else {
var statearr_15229_15262 = state_15221__$1;
(statearr_15229_15262[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15222 === (6))){
var state_15221__$1 = state_15221;
var statearr_15230_15263 = state_15221__$1;
(statearr_15230_15263[(2)] = null);

(statearr_15230_15263[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15222 === (17))){
var inst_15214 = (state_15221[(2)]);
var state_15221__$1 = (function (){var statearr_15232 = state_15221;
(statearr_15232[(10)] = inst_15214);

return statearr_15232;
})();
var statearr_15233_15264 = state_15221__$1;
(statearr_15233_15264[(2)] = null);

(statearr_15233_15264[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15222 === (3))){
var inst_15219 = (state_15221[(2)]);
var state_15221__$1 = state_15221;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15221__$1,inst_15219);
} else {
if((state_val_15222 === (12))){
var _ = (function (){var statearr_15234 = state_15221;
(statearr_15234[(4)] = cljs.core.rest((state_15221[(4)])));

return statearr_15234;
})();
var state_15221__$1 = state_15221;
var ex15231 = (state_15221__$1[(2)]);
var statearr_15235_15265 = state_15221__$1;
(statearr_15235_15265[(5)] = ex15231);


if((ex15231 instanceof Object)){
var statearr_15236_15266 = state_15221__$1;
(statearr_15236_15266[(1)] = (11));

(statearr_15236_15266[(5)] = null);

} else {
throw ex15231;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15222 === (2))){
var inst_15180 = cljs.core.reset_BANG_(dctr,cnt);
var inst_15181 = cnt;
var inst_15182 = (0);
var state_15221__$1 = (function (){var statearr_15237 = state_15221;
(statearr_15237[(7)] = inst_15181);

(statearr_15237[(8)] = inst_15182);

(statearr_15237[(11)] = inst_15180);

return statearr_15237;
})();
var statearr_15238_15267 = state_15221__$1;
(statearr_15238_15267[(2)] = null);

(statearr_15238_15267[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15222 === (11))){
var inst_15186 = (state_15221[(2)]);
var inst_15187 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_15221__$1 = (function (){var statearr_15239 = state_15221;
(statearr_15239[(12)] = inst_15186);

return statearr_15239;
})();
var statearr_15240_15268 = state_15221__$1;
(statearr_15240_15268[(2)] = inst_15187);

(statearr_15240_15268[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15222 === (9))){
var inst_15182 = (state_15221[(8)]);
var _ = (function (){var statearr_15241 = state_15221;
(statearr_15241[(4)] = cljs.core.cons((12),(state_15221[(4)])));

return statearr_15241;
})();
var inst_15193 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_15182) : chs__$1.call(null,inst_15182));
var inst_15194 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_15182) : done.call(null,inst_15182));
var inst_15195 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_15193,inst_15194);
var ___$1 = (function (){var statearr_15242 = state_15221;
(statearr_15242[(4)] = cljs.core.rest((state_15221[(4)])));

return statearr_15242;
})();
var state_15221__$1 = state_15221;
var statearr_15243_15269 = state_15221__$1;
(statearr_15243_15269[(2)] = inst_15195);

(statearr_15243_15269[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15222 === (5))){
var inst_15205 = (state_15221[(2)]);
var state_15221__$1 = (function (){var statearr_15244 = state_15221;
(statearr_15244[(13)] = inst_15205);

return statearr_15244;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15221__$1,(13),dchan);
} else {
if((state_val_15222 === (14))){
var inst_15210 = cljs.core.async.close_BANG_(out);
var state_15221__$1 = state_15221;
var statearr_15245_15270 = state_15221__$1;
(statearr_15245_15270[(2)] = inst_15210);

(statearr_15245_15270[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15222 === (16))){
var inst_15217 = (state_15221[(2)]);
var state_15221__$1 = state_15221;
var statearr_15246_15271 = state_15221__$1;
(statearr_15246_15271[(2)] = inst_15217);

(statearr_15246_15271[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15222 === (10))){
var inst_15182 = (state_15221[(8)]);
var inst_15198 = (state_15221[(2)]);
var inst_15199 = (inst_15182 + (1));
var inst_15182__$1 = inst_15199;
var state_15221__$1 = (function (){var statearr_15247 = state_15221;
(statearr_15247[(14)] = inst_15198);

(statearr_15247[(8)] = inst_15182__$1);

return statearr_15247;
})();
var statearr_15248_15272 = state_15221__$1;
(statearr_15248_15272[(2)] = null);

(statearr_15248_15272[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15222 === (8))){
var inst_15203 = (state_15221[(2)]);
var state_15221__$1 = state_15221;
var statearr_15249_15273 = state_15221__$1;
(statearr_15249_15273[(2)] = inst_15203);

(statearr_15249_15273[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13883__auto__ = null;
var cljs$core$async$state_machine__13883__auto____0 = (function (){
var statearr_15250 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15250[(0)] = cljs$core$async$state_machine__13883__auto__);

(statearr_15250[(1)] = (1));

return statearr_15250;
});
var cljs$core$async$state_machine__13883__auto____1 = (function (state_15221){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_15221);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e15251){var ex__13886__auto__ = e15251;
var statearr_15252_15274 = state_15221;
(statearr_15252_15274[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_15221[(4)]))){
var statearr_15253_15275 = state_15221;
(statearr_15253_15275[(1)] = cljs.core.first((state_15221[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__15276 = state_15221;
state_15221 = G__15276;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$state_machine__13883__auto__ = function(state_15221){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13883__auto____1.call(this,state_15221);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13883__auto____0;
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13883__auto____1;
return cljs$core$async$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_15254 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_15254[(6)] = c__13957__auto___15256);

return statearr_15254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__15279 = arguments.length;
switch (G__15279) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13957__auto___15334 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_15311){
var state_val_15312 = (state_15311[(1)]);
if((state_val_15312 === (7))){
var inst_15291 = (state_15311[(7)]);
var inst_15290 = (state_15311[(8)]);
var inst_15290__$1 = (state_15311[(2)]);
var inst_15291__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15290__$1,(0),null);
var inst_15292 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_15290__$1,(1),null);
var inst_15293 = (inst_15291__$1 == null);
var state_15311__$1 = (function (){var statearr_15313 = state_15311;
(statearr_15313[(7)] = inst_15291__$1);

(statearr_15313[(8)] = inst_15290__$1);

(statearr_15313[(9)] = inst_15292);

return statearr_15313;
})();
if(cljs.core.truth_(inst_15293)){
var statearr_15314_15335 = state_15311__$1;
(statearr_15314_15335[(1)] = (8));

} else {
var statearr_15315_15336 = state_15311__$1;
(statearr_15315_15336[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15312 === (1))){
var inst_15280 = cljs.core.vec(chs);
var inst_15281 = inst_15280;
var state_15311__$1 = (function (){var statearr_15316 = state_15311;
(statearr_15316[(10)] = inst_15281);

return statearr_15316;
})();
var statearr_15317_15337 = state_15311__$1;
(statearr_15317_15337[(2)] = null);

(statearr_15317_15337[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15312 === (4))){
var inst_15281 = (state_15311[(10)]);
var state_15311__$1 = state_15311;
return cljs.core.async.ioc_alts_BANG_(state_15311__$1,(7),inst_15281);
} else {
if((state_val_15312 === (6))){
var inst_15307 = (state_15311[(2)]);
var state_15311__$1 = state_15311;
var statearr_15318_15338 = state_15311__$1;
(statearr_15318_15338[(2)] = inst_15307);

(statearr_15318_15338[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15312 === (3))){
var inst_15309 = (state_15311[(2)]);
var state_15311__$1 = state_15311;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15311__$1,inst_15309);
} else {
if((state_val_15312 === (2))){
var inst_15281 = (state_15311[(10)]);
var inst_15283 = cljs.core.count(inst_15281);
var inst_15284 = (inst_15283 > (0));
var state_15311__$1 = state_15311;
if(cljs.core.truth_(inst_15284)){
var statearr_15320_15339 = state_15311__$1;
(statearr_15320_15339[(1)] = (4));

} else {
var statearr_15321_15340 = state_15311__$1;
(statearr_15321_15340[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15312 === (11))){
var inst_15281 = (state_15311[(10)]);
var inst_15300 = (state_15311[(2)]);
var tmp15319 = inst_15281;
var inst_15281__$1 = tmp15319;
var state_15311__$1 = (function (){var statearr_15322 = state_15311;
(statearr_15322[(11)] = inst_15300);

(statearr_15322[(10)] = inst_15281__$1);

return statearr_15322;
})();
var statearr_15323_15341 = state_15311__$1;
(statearr_15323_15341[(2)] = null);

(statearr_15323_15341[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15312 === (9))){
var inst_15291 = (state_15311[(7)]);
var state_15311__$1 = state_15311;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15311__$1,(11),out,inst_15291);
} else {
if((state_val_15312 === (5))){
var inst_15305 = cljs.core.async.close_BANG_(out);
var state_15311__$1 = state_15311;
var statearr_15324_15342 = state_15311__$1;
(statearr_15324_15342[(2)] = inst_15305);

(statearr_15324_15342[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15312 === (10))){
var inst_15303 = (state_15311[(2)]);
var state_15311__$1 = state_15311;
var statearr_15325_15343 = state_15311__$1;
(statearr_15325_15343[(2)] = inst_15303);

(statearr_15325_15343[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15312 === (8))){
var inst_15291 = (state_15311[(7)]);
var inst_15290 = (state_15311[(8)]);
var inst_15281 = (state_15311[(10)]);
var inst_15292 = (state_15311[(9)]);
var inst_15295 = (function (){var cs = inst_15281;
var vec__15286 = inst_15290;
var v = inst_15291;
var c = inst_15292;
return (function (p1__15277_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__15277_SHARP_);
});
})();
var inst_15296 = cljs.core.filterv(inst_15295,inst_15281);
var inst_15281__$1 = inst_15296;
var state_15311__$1 = (function (){var statearr_15326 = state_15311;
(statearr_15326[(10)] = inst_15281__$1);

return statearr_15326;
})();
var statearr_15327_15344 = state_15311__$1;
(statearr_15327_15344[(2)] = null);

(statearr_15327_15344[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13883__auto__ = null;
var cljs$core$async$state_machine__13883__auto____0 = (function (){
var statearr_15328 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15328[(0)] = cljs$core$async$state_machine__13883__auto__);

(statearr_15328[(1)] = (1));

return statearr_15328;
});
var cljs$core$async$state_machine__13883__auto____1 = (function (state_15311){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_15311);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e15329){var ex__13886__auto__ = e15329;
var statearr_15330_15345 = state_15311;
(statearr_15330_15345[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_15311[(4)]))){
var statearr_15331_15346 = state_15311;
(statearr_15331_15346[(1)] = cljs.core.first((state_15311[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__15347 = state_15311;
state_15311 = G__15347;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$state_machine__13883__auto__ = function(state_15311){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13883__auto____1.call(this,state_15311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13883__auto____0;
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13883__auto____1;
return cljs$core$async$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_15332 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_15332[(6)] = c__13957__auto___15334);

return statearr_15332;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__15349 = arguments.length;
switch (G__15349) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13957__auto___15395 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_15373){
var state_val_15374 = (state_15373[(1)]);
if((state_val_15374 === (7))){
var inst_15355 = (state_15373[(7)]);
var inst_15355__$1 = (state_15373[(2)]);
var inst_15356 = (inst_15355__$1 == null);
var inst_15357 = cljs.core.not(inst_15356);
var state_15373__$1 = (function (){var statearr_15375 = state_15373;
(statearr_15375[(7)] = inst_15355__$1);

return statearr_15375;
})();
if(inst_15357){
var statearr_15376_15396 = state_15373__$1;
(statearr_15376_15396[(1)] = (8));

} else {
var statearr_15377_15397 = state_15373__$1;
(statearr_15377_15397[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15374 === (1))){
var inst_15350 = (0);
var state_15373__$1 = (function (){var statearr_15378 = state_15373;
(statearr_15378[(8)] = inst_15350);

return statearr_15378;
})();
var statearr_15379_15398 = state_15373__$1;
(statearr_15379_15398[(2)] = null);

(statearr_15379_15398[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15374 === (4))){
var state_15373__$1 = state_15373;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15373__$1,(7),ch);
} else {
if((state_val_15374 === (6))){
var inst_15368 = (state_15373[(2)]);
var state_15373__$1 = state_15373;
var statearr_15380_15399 = state_15373__$1;
(statearr_15380_15399[(2)] = inst_15368);

(statearr_15380_15399[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15374 === (3))){
var inst_15370 = (state_15373[(2)]);
var inst_15371 = cljs.core.async.close_BANG_(out);
var state_15373__$1 = (function (){var statearr_15381 = state_15373;
(statearr_15381[(9)] = inst_15370);

return statearr_15381;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_15373__$1,inst_15371);
} else {
if((state_val_15374 === (2))){
var inst_15350 = (state_15373[(8)]);
var inst_15352 = (inst_15350 < n);
var state_15373__$1 = state_15373;
if(cljs.core.truth_(inst_15352)){
var statearr_15382_15400 = state_15373__$1;
(statearr_15382_15400[(1)] = (4));

} else {
var statearr_15383_15401 = state_15373__$1;
(statearr_15383_15401[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15374 === (11))){
var inst_15350 = (state_15373[(8)]);
var inst_15360 = (state_15373[(2)]);
var inst_15361 = (inst_15350 + (1));
var inst_15350__$1 = inst_15361;
var state_15373__$1 = (function (){var statearr_15384 = state_15373;
(statearr_15384[(10)] = inst_15360);

(statearr_15384[(8)] = inst_15350__$1);

return statearr_15384;
})();
var statearr_15385_15402 = state_15373__$1;
(statearr_15385_15402[(2)] = null);

(statearr_15385_15402[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15374 === (9))){
var state_15373__$1 = state_15373;
var statearr_15386_15403 = state_15373__$1;
(statearr_15386_15403[(2)] = null);

(statearr_15386_15403[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15374 === (5))){
var state_15373__$1 = state_15373;
var statearr_15387_15404 = state_15373__$1;
(statearr_15387_15404[(2)] = null);

(statearr_15387_15404[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15374 === (10))){
var inst_15365 = (state_15373[(2)]);
var state_15373__$1 = state_15373;
var statearr_15388_15405 = state_15373__$1;
(statearr_15388_15405[(2)] = inst_15365);

(statearr_15388_15405[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15374 === (8))){
var inst_15355 = (state_15373[(7)]);
var state_15373__$1 = state_15373;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15373__$1,(11),out,inst_15355);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13883__auto__ = null;
var cljs$core$async$state_machine__13883__auto____0 = (function (){
var statearr_15389 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15389[(0)] = cljs$core$async$state_machine__13883__auto__);

(statearr_15389[(1)] = (1));

return statearr_15389;
});
var cljs$core$async$state_machine__13883__auto____1 = (function (state_15373){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_15373);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e15390){var ex__13886__auto__ = e15390;
var statearr_15391_15406 = state_15373;
(statearr_15391_15406[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_15373[(4)]))){
var statearr_15392_15407 = state_15373;
(statearr_15392_15407[(1)] = cljs.core.first((state_15373[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__15408 = state_15373;
state_15373 = G__15408;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$state_machine__13883__auto__ = function(state_15373){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13883__auto____1.call(this,state_15373);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13883__auto____0;
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13883__auto____1;
return cljs$core$async$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_15393 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_15393[(6)] = c__13957__auto___15395);

return statearr_15393;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15410 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15410 = (function (f,ch,meta15411){
this.f = f;
this.ch = ch;
this.meta15411 = meta15411;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15410.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15412,meta15411__$1){
var self__ = this;
var _15412__$1 = this;
return (new cljs.core.async.t_cljs$core$async15410(self__.f,self__.ch,meta15411__$1));
}));

(cljs.core.async.t_cljs$core$async15410.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15412){
var self__ = this;
var _15412__$1 = this;
return self__.meta15411;
}));

(cljs.core.async.t_cljs$core$async15410.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15410.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async15410.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async15410.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15410.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15413 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15413 = (function (f,ch,meta15411,_,fn1,meta15414){
this.f = f;
this.ch = ch;
this.meta15411 = meta15411;
this._ = _;
this.fn1 = fn1;
this.meta15414 = meta15414;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15413.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15415,meta15414__$1){
var self__ = this;
var _15415__$1 = this;
return (new cljs.core.async.t_cljs$core$async15413(self__.f,self__.ch,self__.meta15411,self__._,self__.fn1,meta15414__$1));
}));

(cljs.core.async.t_cljs$core$async15413.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15415){
var self__ = this;
var _15415__$1 = this;
return self__.meta15414;
}));

(cljs.core.async.t_cljs$core$async15413.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15413.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async15413.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async15413.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__15409_SHARP_){
var G__15416 = (((p1__15409_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__15409_SHARP_) : self__.f.call(null,p1__15409_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__15416) : f1.call(null,G__15416));
});
}));

(cljs.core.async.t_cljs$core$async15413.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta15411,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async15410], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta15414], null);
}));

(cljs.core.async.t_cljs$core$async15413.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15413.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15413");

(cljs.core.async.t_cljs$core$async15413.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async15413");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15413.
 */
cljs.core.async.__GT_t_cljs$core$async15413 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async15413(f__$1,ch__$1,meta15411__$1,___$2,fn1__$1,meta15414){
return (new cljs.core.async.t_cljs$core$async15413(f__$1,ch__$1,meta15411__$1,___$2,fn1__$1,meta15414));
});

}

return (new cljs.core.async.t_cljs$core$async15413(self__.f,self__.ch,self__.meta15411,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4149__auto__ = ret;
if(cljs.core.truth_(and__4149__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4149__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__15417 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__15417) : self__.f.call(null,G__15417));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async15410.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15410.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async15410.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta15411], null);
}));

(cljs.core.async.t_cljs$core$async15410.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15410.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15410");

(cljs.core.async.t_cljs$core$async15410.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async15410");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15410.
 */
cljs.core.async.__GT_t_cljs$core$async15410 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async15410(f__$1,ch__$1,meta15411){
return (new cljs.core.async.t_cljs$core$async15410(f__$1,ch__$1,meta15411));
});

}

return (new cljs.core.async.t_cljs$core$async15410(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15418 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15418 = (function (f,ch,meta15419){
this.f = f;
this.ch = ch;
this.meta15419 = meta15419;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15418.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15420,meta15419__$1){
var self__ = this;
var _15420__$1 = this;
return (new cljs.core.async.t_cljs$core$async15418(self__.f,self__.ch,meta15419__$1));
}));

(cljs.core.async.t_cljs$core$async15418.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15420){
var self__ = this;
var _15420__$1 = this;
return self__.meta15419;
}));

(cljs.core.async.t_cljs$core$async15418.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15418.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async15418.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15418.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async15418.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15418.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async15418.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta15419], null);
}));

(cljs.core.async.t_cljs$core$async15418.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15418.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15418");

(cljs.core.async.t_cljs$core$async15418.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async15418");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15418.
 */
cljs.core.async.__GT_t_cljs$core$async15418 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async15418(f__$1,ch__$1,meta15419){
return (new cljs.core.async.t_cljs$core$async15418(f__$1,ch__$1,meta15419));
});

}

return (new cljs.core.async.t_cljs$core$async15418(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async15421 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async15421 = (function (p,ch,meta15422){
this.p = p;
this.ch = ch;
this.meta15422 = meta15422;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async15421.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_15423,meta15422__$1){
var self__ = this;
var _15423__$1 = this;
return (new cljs.core.async.t_cljs$core$async15421(self__.p,self__.ch,meta15422__$1));
}));

(cljs.core.async.t_cljs$core$async15421.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_15423){
var self__ = this;
var _15423__$1 = this;
return self__.meta15422;
}));

(cljs.core.async.t_cljs$core$async15421.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15421.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async15421.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async15421.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15421.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async15421.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async15421.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async15421.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta15422], null);
}));

(cljs.core.async.t_cljs$core$async15421.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async15421.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async15421");

(cljs.core.async.t_cljs$core$async15421.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"cljs.core.async/t_cljs$core$async15421");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async15421.
 */
cljs.core.async.__GT_t_cljs$core$async15421 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async15421(p__$1,ch__$1,meta15422){
return (new cljs.core.async.t_cljs$core$async15421(p__$1,ch__$1,meta15422));
});

}

return (new cljs.core.async.t_cljs$core$async15421(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__15425 = arguments.length;
switch (G__15425) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13957__auto___15466 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_15446){
var state_val_15447 = (state_15446[(1)]);
if((state_val_15447 === (7))){
var inst_15442 = (state_15446[(2)]);
var state_15446__$1 = state_15446;
var statearr_15448_15467 = state_15446__$1;
(statearr_15448_15467[(2)] = inst_15442);

(statearr_15448_15467[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15447 === (1))){
var state_15446__$1 = state_15446;
var statearr_15449_15468 = state_15446__$1;
(statearr_15449_15468[(2)] = null);

(statearr_15449_15468[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15447 === (4))){
var inst_15428 = (state_15446[(7)]);
var inst_15428__$1 = (state_15446[(2)]);
var inst_15429 = (inst_15428__$1 == null);
var state_15446__$1 = (function (){var statearr_15450 = state_15446;
(statearr_15450[(7)] = inst_15428__$1);

return statearr_15450;
})();
if(cljs.core.truth_(inst_15429)){
var statearr_15451_15469 = state_15446__$1;
(statearr_15451_15469[(1)] = (5));

} else {
var statearr_15452_15470 = state_15446__$1;
(statearr_15452_15470[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15447 === (6))){
var inst_15428 = (state_15446[(7)]);
var inst_15433 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_15428) : p.call(null,inst_15428));
var state_15446__$1 = state_15446;
if(cljs.core.truth_(inst_15433)){
var statearr_15453_15471 = state_15446__$1;
(statearr_15453_15471[(1)] = (8));

} else {
var statearr_15454_15472 = state_15446__$1;
(statearr_15454_15472[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15447 === (3))){
var inst_15444 = (state_15446[(2)]);
var state_15446__$1 = state_15446;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15446__$1,inst_15444);
} else {
if((state_val_15447 === (2))){
var state_15446__$1 = state_15446;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15446__$1,(4),ch);
} else {
if((state_val_15447 === (11))){
var inst_15436 = (state_15446[(2)]);
var state_15446__$1 = state_15446;
var statearr_15455_15473 = state_15446__$1;
(statearr_15455_15473[(2)] = inst_15436);

(statearr_15455_15473[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15447 === (9))){
var state_15446__$1 = state_15446;
var statearr_15456_15474 = state_15446__$1;
(statearr_15456_15474[(2)] = null);

(statearr_15456_15474[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15447 === (5))){
var inst_15431 = cljs.core.async.close_BANG_(out);
var state_15446__$1 = state_15446;
var statearr_15457_15475 = state_15446__$1;
(statearr_15457_15475[(2)] = inst_15431);

(statearr_15457_15475[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15447 === (10))){
var inst_15439 = (state_15446[(2)]);
var state_15446__$1 = (function (){var statearr_15458 = state_15446;
(statearr_15458[(8)] = inst_15439);

return statearr_15458;
})();
var statearr_15459_15476 = state_15446__$1;
(statearr_15459_15476[(2)] = null);

(statearr_15459_15476[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15447 === (8))){
var inst_15428 = (state_15446[(7)]);
var state_15446__$1 = state_15446;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15446__$1,(11),out,inst_15428);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13883__auto__ = null;
var cljs$core$async$state_machine__13883__auto____0 = (function (){
var statearr_15460 = [null,null,null,null,null,null,null,null,null];
(statearr_15460[(0)] = cljs$core$async$state_machine__13883__auto__);

(statearr_15460[(1)] = (1));

return statearr_15460;
});
var cljs$core$async$state_machine__13883__auto____1 = (function (state_15446){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_15446);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e15461){var ex__13886__auto__ = e15461;
var statearr_15462_15477 = state_15446;
(statearr_15462_15477[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_15446[(4)]))){
var statearr_15463_15478 = state_15446;
(statearr_15463_15478[(1)] = cljs.core.first((state_15446[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__15479 = state_15446;
state_15446 = G__15479;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$state_machine__13883__auto__ = function(state_15446){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13883__auto____1.call(this,state_15446);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13883__auto____0;
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13883__auto____1;
return cljs$core$async$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_15464 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_15464[(6)] = c__13957__auto___15466);

return statearr_15464;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__15481 = arguments.length;
switch (G__15481) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_15544){
var state_val_15545 = (state_15544[(1)]);
if((state_val_15545 === (7))){
var inst_15540 = (state_15544[(2)]);
var state_15544__$1 = state_15544;
var statearr_15546_15585 = state_15544__$1;
(statearr_15546_15585[(2)] = inst_15540);

(statearr_15546_15585[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15545 === (20))){
var inst_15510 = (state_15544[(7)]);
var inst_15521 = (state_15544[(2)]);
var inst_15522 = cljs.core.next(inst_15510);
var inst_15496 = inst_15522;
var inst_15497 = null;
var inst_15498 = (0);
var inst_15499 = (0);
var state_15544__$1 = (function (){var statearr_15547 = state_15544;
(statearr_15547[(8)] = inst_15497);

(statearr_15547[(9)] = inst_15496);

(statearr_15547[(10)] = inst_15499);

(statearr_15547[(11)] = inst_15498);

(statearr_15547[(12)] = inst_15521);

return statearr_15547;
})();
var statearr_15548_15586 = state_15544__$1;
(statearr_15548_15586[(2)] = null);

(statearr_15548_15586[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15545 === (1))){
var state_15544__$1 = state_15544;
var statearr_15549_15587 = state_15544__$1;
(statearr_15549_15587[(2)] = null);

(statearr_15549_15587[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15545 === (4))){
var inst_15485 = (state_15544[(13)]);
var inst_15485__$1 = (state_15544[(2)]);
var inst_15486 = (inst_15485__$1 == null);
var state_15544__$1 = (function (){var statearr_15550 = state_15544;
(statearr_15550[(13)] = inst_15485__$1);

return statearr_15550;
})();
if(cljs.core.truth_(inst_15486)){
var statearr_15551_15588 = state_15544__$1;
(statearr_15551_15588[(1)] = (5));

} else {
var statearr_15552_15589 = state_15544__$1;
(statearr_15552_15589[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15545 === (15))){
var state_15544__$1 = state_15544;
var statearr_15556_15590 = state_15544__$1;
(statearr_15556_15590[(2)] = null);

(statearr_15556_15590[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15545 === (21))){
var state_15544__$1 = state_15544;
var statearr_15557_15591 = state_15544__$1;
(statearr_15557_15591[(2)] = null);

(statearr_15557_15591[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15545 === (13))){
var inst_15497 = (state_15544[(8)]);
var inst_15496 = (state_15544[(9)]);
var inst_15499 = (state_15544[(10)]);
var inst_15498 = (state_15544[(11)]);
var inst_15506 = (state_15544[(2)]);
var inst_15507 = (inst_15499 + (1));
var tmp15553 = inst_15497;
var tmp15554 = inst_15496;
var tmp15555 = inst_15498;
var inst_15496__$1 = tmp15554;
var inst_15497__$1 = tmp15553;
var inst_15498__$1 = tmp15555;
var inst_15499__$1 = inst_15507;
var state_15544__$1 = (function (){var statearr_15558 = state_15544;
(statearr_15558[(8)] = inst_15497__$1);

(statearr_15558[(14)] = inst_15506);

(statearr_15558[(9)] = inst_15496__$1);

(statearr_15558[(10)] = inst_15499__$1);

(statearr_15558[(11)] = inst_15498__$1);

return statearr_15558;
})();
var statearr_15559_15592 = state_15544__$1;
(statearr_15559_15592[(2)] = null);

(statearr_15559_15592[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15545 === (22))){
var state_15544__$1 = state_15544;
var statearr_15560_15593 = state_15544__$1;
(statearr_15560_15593[(2)] = null);

(statearr_15560_15593[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15545 === (6))){
var inst_15485 = (state_15544[(13)]);
var inst_15494 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_15485) : f.call(null,inst_15485));
var inst_15495 = cljs.core.seq(inst_15494);
var inst_15496 = inst_15495;
var inst_15497 = null;
var inst_15498 = (0);
var inst_15499 = (0);
var state_15544__$1 = (function (){var statearr_15561 = state_15544;
(statearr_15561[(8)] = inst_15497);

(statearr_15561[(9)] = inst_15496);

(statearr_15561[(10)] = inst_15499);

(statearr_15561[(11)] = inst_15498);

return statearr_15561;
})();
var statearr_15562_15594 = state_15544__$1;
(statearr_15562_15594[(2)] = null);

(statearr_15562_15594[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15545 === (17))){
var inst_15510 = (state_15544[(7)]);
var inst_15514 = cljs.core.chunk_first(inst_15510);
var inst_15515 = cljs.core.chunk_rest(inst_15510);
var inst_15516 = cljs.core.count(inst_15514);
var inst_15496 = inst_15515;
var inst_15497 = inst_15514;
var inst_15498 = inst_15516;
var inst_15499 = (0);
var state_15544__$1 = (function (){var statearr_15563 = state_15544;
(statearr_15563[(8)] = inst_15497);

(statearr_15563[(9)] = inst_15496);

(statearr_15563[(10)] = inst_15499);

(statearr_15563[(11)] = inst_15498);

return statearr_15563;
})();
var statearr_15564_15595 = state_15544__$1;
(statearr_15564_15595[(2)] = null);

(statearr_15564_15595[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15545 === (3))){
var inst_15542 = (state_15544[(2)]);
var state_15544__$1 = state_15544;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15544__$1,inst_15542);
} else {
if((state_val_15545 === (12))){
var inst_15530 = (state_15544[(2)]);
var state_15544__$1 = state_15544;
var statearr_15565_15596 = state_15544__$1;
(statearr_15565_15596[(2)] = inst_15530);

(statearr_15565_15596[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15545 === (2))){
var state_15544__$1 = state_15544;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15544__$1,(4),in$);
} else {
if((state_val_15545 === (23))){
var inst_15538 = (state_15544[(2)]);
var state_15544__$1 = state_15544;
var statearr_15566_15597 = state_15544__$1;
(statearr_15566_15597[(2)] = inst_15538);

(statearr_15566_15597[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15545 === (19))){
var inst_15525 = (state_15544[(2)]);
var state_15544__$1 = state_15544;
var statearr_15567_15598 = state_15544__$1;
(statearr_15567_15598[(2)] = inst_15525);

(statearr_15567_15598[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15545 === (11))){
var inst_15496 = (state_15544[(9)]);
var inst_15510 = (state_15544[(7)]);
var inst_15510__$1 = cljs.core.seq(inst_15496);
var state_15544__$1 = (function (){var statearr_15568 = state_15544;
(statearr_15568[(7)] = inst_15510__$1);

return statearr_15568;
})();
if(inst_15510__$1){
var statearr_15569_15599 = state_15544__$1;
(statearr_15569_15599[(1)] = (14));

} else {
var statearr_15570_15600 = state_15544__$1;
(statearr_15570_15600[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15545 === (9))){
var inst_15532 = (state_15544[(2)]);
var inst_15533 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_15544__$1 = (function (){var statearr_15571 = state_15544;
(statearr_15571[(15)] = inst_15532);

return statearr_15571;
})();
if(cljs.core.truth_(inst_15533)){
var statearr_15572_15601 = state_15544__$1;
(statearr_15572_15601[(1)] = (21));

} else {
var statearr_15573_15602 = state_15544__$1;
(statearr_15573_15602[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15545 === (5))){
var inst_15488 = cljs.core.async.close_BANG_(out);
var state_15544__$1 = state_15544;
var statearr_15574_15603 = state_15544__$1;
(statearr_15574_15603[(2)] = inst_15488);

(statearr_15574_15603[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15545 === (14))){
var inst_15510 = (state_15544[(7)]);
var inst_15512 = cljs.core.chunked_seq_QMARK_(inst_15510);
var state_15544__$1 = state_15544;
if(inst_15512){
var statearr_15575_15604 = state_15544__$1;
(statearr_15575_15604[(1)] = (17));

} else {
var statearr_15576_15605 = state_15544__$1;
(statearr_15576_15605[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15545 === (16))){
var inst_15528 = (state_15544[(2)]);
var state_15544__$1 = state_15544;
var statearr_15577_15606 = state_15544__$1;
(statearr_15577_15606[(2)] = inst_15528);

(statearr_15577_15606[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15545 === (10))){
var inst_15497 = (state_15544[(8)]);
var inst_15499 = (state_15544[(10)]);
var inst_15504 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_15497,inst_15499);
var state_15544__$1 = state_15544;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15544__$1,(13),out,inst_15504);
} else {
if((state_val_15545 === (18))){
var inst_15510 = (state_15544[(7)]);
var inst_15519 = cljs.core.first(inst_15510);
var state_15544__$1 = state_15544;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15544__$1,(20),out,inst_15519);
} else {
if((state_val_15545 === (8))){
var inst_15499 = (state_15544[(10)]);
var inst_15498 = (state_15544[(11)]);
var inst_15501 = (inst_15499 < inst_15498);
var inst_15502 = inst_15501;
var state_15544__$1 = state_15544;
if(cljs.core.truth_(inst_15502)){
var statearr_15578_15607 = state_15544__$1;
(statearr_15578_15607[(1)] = (10));

} else {
var statearr_15579_15608 = state_15544__$1;
(statearr_15579_15608[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__13883__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__13883__auto____0 = (function (){
var statearr_15580 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15580[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__13883__auto__);

(statearr_15580[(1)] = (1));

return statearr_15580;
});
var cljs$core$async$mapcat_STAR__$_state_machine__13883__auto____1 = (function (state_15544){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_15544);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e15581){var ex__13886__auto__ = e15581;
var statearr_15582_15609 = state_15544;
(statearr_15582_15609[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_15544[(4)]))){
var statearr_15583_15610 = state_15544;
(statearr_15583_15610[(1)] = cljs.core.first((state_15544[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__15611 = state_15544;
state_15544 = G__15611;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__13883__auto__ = function(state_15544){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__13883__auto____1.call(this,state_15544);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__13883__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__13883__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_15584 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_15584[(6)] = c__13957__auto__);

return statearr_15584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__15613 = arguments.length;
switch (G__15613) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__15616 = arguments.length;
switch (G__15616) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__15619 = arguments.length;
switch (G__15619) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13957__auto___15667 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_15643){
var state_val_15644 = (state_15643[(1)]);
if((state_val_15644 === (7))){
var inst_15638 = (state_15643[(2)]);
var state_15643__$1 = state_15643;
var statearr_15645_15668 = state_15643__$1;
(statearr_15645_15668[(2)] = inst_15638);

(statearr_15645_15668[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15644 === (1))){
var inst_15620 = null;
var state_15643__$1 = (function (){var statearr_15646 = state_15643;
(statearr_15646[(7)] = inst_15620);

return statearr_15646;
})();
var statearr_15647_15669 = state_15643__$1;
(statearr_15647_15669[(2)] = null);

(statearr_15647_15669[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15644 === (4))){
var inst_15623 = (state_15643[(8)]);
var inst_15623__$1 = (state_15643[(2)]);
var inst_15624 = (inst_15623__$1 == null);
var inst_15625 = cljs.core.not(inst_15624);
var state_15643__$1 = (function (){var statearr_15648 = state_15643;
(statearr_15648[(8)] = inst_15623__$1);

return statearr_15648;
})();
if(inst_15625){
var statearr_15649_15670 = state_15643__$1;
(statearr_15649_15670[(1)] = (5));

} else {
var statearr_15650_15671 = state_15643__$1;
(statearr_15650_15671[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15644 === (6))){
var state_15643__$1 = state_15643;
var statearr_15651_15672 = state_15643__$1;
(statearr_15651_15672[(2)] = null);

(statearr_15651_15672[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15644 === (3))){
var inst_15640 = (state_15643[(2)]);
var inst_15641 = cljs.core.async.close_BANG_(out);
var state_15643__$1 = (function (){var statearr_15652 = state_15643;
(statearr_15652[(9)] = inst_15640);

return statearr_15652;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_15643__$1,inst_15641);
} else {
if((state_val_15644 === (2))){
var state_15643__$1 = state_15643;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15643__$1,(4),ch);
} else {
if((state_val_15644 === (11))){
var inst_15623 = (state_15643[(8)]);
var inst_15632 = (state_15643[(2)]);
var inst_15620 = inst_15623;
var state_15643__$1 = (function (){var statearr_15653 = state_15643;
(statearr_15653[(7)] = inst_15620);

(statearr_15653[(10)] = inst_15632);

return statearr_15653;
})();
var statearr_15654_15673 = state_15643__$1;
(statearr_15654_15673[(2)] = null);

(statearr_15654_15673[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15644 === (9))){
var inst_15623 = (state_15643[(8)]);
var state_15643__$1 = state_15643;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15643__$1,(11),out,inst_15623);
} else {
if((state_val_15644 === (5))){
var inst_15623 = (state_15643[(8)]);
var inst_15620 = (state_15643[(7)]);
var inst_15627 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15623,inst_15620);
var state_15643__$1 = state_15643;
if(inst_15627){
var statearr_15656_15674 = state_15643__$1;
(statearr_15656_15674[(1)] = (8));

} else {
var statearr_15657_15675 = state_15643__$1;
(statearr_15657_15675[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15644 === (10))){
var inst_15635 = (state_15643[(2)]);
var state_15643__$1 = state_15643;
var statearr_15658_15676 = state_15643__$1;
(statearr_15658_15676[(2)] = inst_15635);

(statearr_15658_15676[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15644 === (8))){
var inst_15620 = (state_15643[(7)]);
var tmp15655 = inst_15620;
var inst_15620__$1 = tmp15655;
var state_15643__$1 = (function (){var statearr_15659 = state_15643;
(statearr_15659[(7)] = inst_15620__$1);

return statearr_15659;
})();
var statearr_15660_15677 = state_15643__$1;
(statearr_15660_15677[(2)] = null);

(statearr_15660_15677[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13883__auto__ = null;
var cljs$core$async$state_machine__13883__auto____0 = (function (){
var statearr_15661 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_15661[(0)] = cljs$core$async$state_machine__13883__auto__);

(statearr_15661[(1)] = (1));

return statearr_15661;
});
var cljs$core$async$state_machine__13883__auto____1 = (function (state_15643){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_15643);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e15662){var ex__13886__auto__ = e15662;
var statearr_15663_15678 = state_15643;
(statearr_15663_15678[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_15643[(4)]))){
var statearr_15664_15679 = state_15643;
(statearr_15664_15679[(1)] = cljs.core.first((state_15643[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__15680 = state_15643;
state_15643 = G__15680;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$state_machine__13883__auto__ = function(state_15643){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13883__auto____1.call(this,state_15643);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13883__auto____0;
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13883__auto____1;
return cljs$core$async$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_15665 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_15665[(6)] = c__13957__auto___15667);

return statearr_15665;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__15682 = arguments.length;
switch (G__15682) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13957__auto___15749 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_15720){
var state_val_15721 = (state_15720[(1)]);
if((state_val_15721 === (7))){
var inst_15716 = (state_15720[(2)]);
var state_15720__$1 = state_15720;
var statearr_15722_15750 = state_15720__$1;
(statearr_15722_15750[(2)] = inst_15716);

(statearr_15722_15750[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15721 === (1))){
var inst_15683 = (new Array(n));
var inst_15684 = inst_15683;
var inst_15685 = (0);
var state_15720__$1 = (function (){var statearr_15723 = state_15720;
(statearr_15723[(7)] = inst_15685);

(statearr_15723[(8)] = inst_15684);

return statearr_15723;
})();
var statearr_15724_15751 = state_15720__$1;
(statearr_15724_15751[(2)] = null);

(statearr_15724_15751[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15721 === (4))){
var inst_15688 = (state_15720[(9)]);
var inst_15688__$1 = (state_15720[(2)]);
var inst_15689 = (inst_15688__$1 == null);
var inst_15690 = cljs.core.not(inst_15689);
var state_15720__$1 = (function (){var statearr_15725 = state_15720;
(statearr_15725[(9)] = inst_15688__$1);

return statearr_15725;
})();
if(inst_15690){
var statearr_15726_15752 = state_15720__$1;
(statearr_15726_15752[(1)] = (5));

} else {
var statearr_15727_15753 = state_15720__$1;
(statearr_15727_15753[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15721 === (15))){
var inst_15710 = (state_15720[(2)]);
var state_15720__$1 = state_15720;
var statearr_15728_15754 = state_15720__$1;
(statearr_15728_15754[(2)] = inst_15710);

(statearr_15728_15754[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15721 === (13))){
var state_15720__$1 = state_15720;
var statearr_15729_15755 = state_15720__$1;
(statearr_15729_15755[(2)] = null);

(statearr_15729_15755[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15721 === (6))){
var inst_15685 = (state_15720[(7)]);
var inst_15706 = (inst_15685 > (0));
var state_15720__$1 = state_15720;
if(cljs.core.truth_(inst_15706)){
var statearr_15730_15756 = state_15720__$1;
(statearr_15730_15756[(1)] = (12));

} else {
var statearr_15731_15757 = state_15720__$1;
(statearr_15731_15757[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15721 === (3))){
var inst_15718 = (state_15720[(2)]);
var state_15720__$1 = state_15720;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15720__$1,inst_15718);
} else {
if((state_val_15721 === (12))){
var inst_15684 = (state_15720[(8)]);
var inst_15708 = cljs.core.vec(inst_15684);
var state_15720__$1 = state_15720;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15720__$1,(15),out,inst_15708);
} else {
if((state_val_15721 === (2))){
var state_15720__$1 = state_15720;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15720__$1,(4),ch);
} else {
if((state_val_15721 === (11))){
var inst_15700 = (state_15720[(2)]);
var inst_15701 = (new Array(n));
var inst_15684 = inst_15701;
var inst_15685 = (0);
var state_15720__$1 = (function (){var statearr_15732 = state_15720;
(statearr_15732[(10)] = inst_15700);

(statearr_15732[(7)] = inst_15685);

(statearr_15732[(8)] = inst_15684);

return statearr_15732;
})();
var statearr_15733_15758 = state_15720__$1;
(statearr_15733_15758[(2)] = null);

(statearr_15733_15758[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15721 === (9))){
var inst_15684 = (state_15720[(8)]);
var inst_15698 = cljs.core.vec(inst_15684);
var state_15720__$1 = state_15720;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15720__$1,(11),out,inst_15698);
} else {
if((state_val_15721 === (5))){
var inst_15688 = (state_15720[(9)]);
var inst_15685 = (state_15720[(7)]);
var inst_15693 = (state_15720[(11)]);
var inst_15684 = (state_15720[(8)]);
var inst_15692 = (inst_15684[inst_15685] = inst_15688);
var inst_15693__$1 = (inst_15685 + (1));
var inst_15694 = (inst_15693__$1 < n);
var state_15720__$1 = (function (){var statearr_15734 = state_15720;
(statearr_15734[(12)] = inst_15692);

(statearr_15734[(11)] = inst_15693__$1);

return statearr_15734;
})();
if(cljs.core.truth_(inst_15694)){
var statearr_15735_15759 = state_15720__$1;
(statearr_15735_15759[(1)] = (8));

} else {
var statearr_15736_15760 = state_15720__$1;
(statearr_15736_15760[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15721 === (14))){
var inst_15713 = (state_15720[(2)]);
var inst_15714 = cljs.core.async.close_BANG_(out);
var state_15720__$1 = (function (){var statearr_15738 = state_15720;
(statearr_15738[(13)] = inst_15713);

return statearr_15738;
})();
var statearr_15739_15761 = state_15720__$1;
(statearr_15739_15761[(2)] = inst_15714);

(statearr_15739_15761[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15721 === (10))){
var inst_15704 = (state_15720[(2)]);
var state_15720__$1 = state_15720;
var statearr_15740_15762 = state_15720__$1;
(statearr_15740_15762[(2)] = inst_15704);

(statearr_15740_15762[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15721 === (8))){
var inst_15693 = (state_15720[(11)]);
var inst_15684 = (state_15720[(8)]);
var tmp15737 = inst_15684;
var inst_15684__$1 = tmp15737;
var inst_15685 = inst_15693;
var state_15720__$1 = (function (){var statearr_15741 = state_15720;
(statearr_15741[(7)] = inst_15685);

(statearr_15741[(8)] = inst_15684__$1);

return statearr_15741;
})();
var statearr_15742_15763 = state_15720__$1;
(statearr_15742_15763[(2)] = null);

(statearr_15742_15763[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13883__auto__ = null;
var cljs$core$async$state_machine__13883__auto____0 = (function (){
var statearr_15743 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15743[(0)] = cljs$core$async$state_machine__13883__auto__);

(statearr_15743[(1)] = (1));

return statearr_15743;
});
var cljs$core$async$state_machine__13883__auto____1 = (function (state_15720){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_15720);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e15744){var ex__13886__auto__ = e15744;
var statearr_15745_15764 = state_15720;
(statearr_15745_15764[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_15720[(4)]))){
var statearr_15746_15765 = state_15720;
(statearr_15746_15765[(1)] = cljs.core.first((state_15720[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__15766 = state_15720;
state_15720 = G__15766;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$state_machine__13883__auto__ = function(state_15720){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13883__auto____1.call(this,state_15720);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13883__auto____0;
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13883__auto____1;
return cljs$core$async$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_15747 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_15747[(6)] = c__13957__auto___15749);

return statearr_15747;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__15768 = arguments.length;
switch (G__15768) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__13957__auto___15839 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_15810){
var state_val_15811 = (state_15810[(1)]);
if((state_val_15811 === (7))){
var inst_15806 = (state_15810[(2)]);
var state_15810__$1 = state_15810;
var statearr_15812_15840 = state_15810__$1;
(statearr_15812_15840[(2)] = inst_15806);

(statearr_15812_15840[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15811 === (1))){
var inst_15769 = [];
var inst_15770 = inst_15769;
var inst_15771 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_15810__$1 = (function (){var statearr_15813 = state_15810;
(statearr_15813[(7)] = inst_15771);

(statearr_15813[(8)] = inst_15770);

return statearr_15813;
})();
var statearr_15814_15841 = state_15810__$1;
(statearr_15814_15841[(2)] = null);

(statearr_15814_15841[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15811 === (4))){
var inst_15774 = (state_15810[(9)]);
var inst_15774__$1 = (state_15810[(2)]);
var inst_15775 = (inst_15774__$1 == null);
var inst_15776 = cljs.core.not(inst_15775);
var state_15810__$1 = (function (){var statearr_15815 = state_15810;
(statearr_15815[(9)] = inst_15774__$1);

return statearr_15815;
})();
if(inst_15776){
var statearr_15816_15842 = state_15810__$1;
(statearr_15816_15842[(1)] = (5));

} else {
var statearr_15817_15843 = state_15810__$1;
(statearr_15817_15843[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15811 === (15))){
var inst_15800 = (state_15810[(2)]);
var state_15810__$1 = state_15810;
var statearr_15818_15844 = state_15810__$1;
(statearr_15818_15844[(2)] = inst_15800);

(statearr_15818_15844[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15811 === (13))){
var state_15810__$1 = state_15810;
var statearr_15819_15845 = state_15810__$1;
(statearr_15819_15845[(2)] = null);

(statearr_15819_15845[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15811 === (6))){
var inst_15770 = (state_15810[(8)]);
var inst_15795 = inst_15770.length;
var inst_15796 = (inst_15795 > (0));
var state_15810__$1 = state_15810;
if(cljs.core.truth_(inst_15796)){
var statearr_15820_15846 = state_15810__$1;
(statearr_15820_15846[(1)] = (12));

} else {
var statearr_15821_15847 = state_15810__$1;
(statearr_15821_15847[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15811 === (3))){
var inst_15808 = (state_15810[(2)]);
var state_15810__$1 = state_15810;
return cljs.core.async.impl.ioc_helpers.return_chan(state_15810__$1,inst_15808);
} else {
if((state_val_15811 === (12))){
var inst_15770 = (state_15810[(8)]);
var inst_15798 = cljs.core.vec(inst_15770);
var state_15810__$1 = state_15810;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15810__$1,(15),out,inst_15798);
} else {
if((state_val_15811 === (2))){
var state_15810__$1 = state_15810;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_15810__$1,(4),ch);
} else {
if((state_val_15811 === (11))){
var inst_15774 = (state_15810[(9)]);
var inst_15778 = (state_15810[(10)]);
var inst_15788 = (state_15810[(2)]);
var inst_15789 = [];
var inst_15790 = inst_15789.push(inst_15774);
var inst_15770 = inst_15789;
var inst_15771 = inst_15778;
var state_15810__$1 = (function (){var statearr_15822 = state_15810;
(statearr_15822[(7)] = inst_15771);

(statearr_15822[(11)] = inst_15790);

(statearr_15822[(12)] = inst_15788);

(statearr_15822[(8)] = inst_15770);

return statearr_15822;
})();
var statearr_15823_15848 = state_15810__$1;
(statearr_15823_15848[(2)] = null);

(statearr_15823_15848[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15811 === (9))){
var inst_15770 = (state_15810[(8)]);
var inst_15786 = cljs.core.vec(inst_15770);
var state_15810__$1 = state_15810;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_15810__$1,(11),out,inst_15786);
} else {
if((state_val_15811 === (5))){
var inst_15774 = (state_15810[(9)]);
var inst_15771 = (state_15810[(7)]);
var inst_15778 = (state_15810[(10)]);
var inst_15778__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_15774) : f.call(null,inst_15774));
var inst_15779 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_15778__$1,inst_15771);
var inst_15780 = cljs.core.keyword_identical_QMARK_(inst_15771,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_15781 = ((inst_15779) || (inst_15780));
var state_15810__$1 = (function (){var statearr_15824 = state_15810;
(statearr_15824[(10)] = inst_15778__$1);

return statearr_15824;
})();
if(cljs.core.truth_(inst_15781)){
var statearr_15825_15849 = state_15810__$1;
(statearr_15825_15849[(1)] = (8));

} else {
var statearr_15826_15850 = state_15810__$1;
(statearr_15826_15850[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_15811 === (14))){
var inst_15803 = (state_15810[(2)]);
var inst_15804 = cljs.core.async.close_BANG_(out);
var state_15810__$1 = (function (){var statearr_15828 = state_15810;
(statearr_15828[(13)] = inst_15803);

return statearr_15828;
})();
var statearr_15829_15851 = state_15810__$1;
(statearr_15829_15851[(2)] = inst_15804);

(statearr_15829_15851[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15811 === (10))){
var inst_15793 = (state_15810[(2)]);
var state_15810__$1 = state_15810;
var statearr_15830_15852 = state_15810__$1;
(statearr_15830_15852[(2)] = inst_15793);

(statearr_15830_15852[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_15811 === (8))){
var inst_15774 = (state_15810[(9)]);
var inst_15778 = (state_15810[(10)]);
var inst_15770 = (state_15810[(8)]);
var inst_15783 = inst_15770.push(inst_15774);
var tmp15827 = inst_15770;
var inst_15770__$1 = tmp15827;
var inst_15771 = inst_15778;
var state_15810__$1 = (function (){var statearr_15831 = state_15810;
(statearr_15831[(7)] = inst_15771);

(statearr_15831[(14)] = inst_15783);

(statearr_15831[(8)] = inst_15770__$1);

return statearr_15831;
})();
var statearr_15832_15853 = state_15810__$1;
(statearr_15832_15853[(2)] = null);

(statearr_15832_15853[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__13883__auto__ = null;
var cljs$core$async$state_machine__13883__auto____0 = (function (){
var statearr_15833 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15833[(0)] = cljs$core$async$state_machine__13883__auto__);

(statearr_15833[(1)] = (1));

return statearr_15833;
});
var cljs$core$async$state_machine__13883__auto____1 = (function (state_15810){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_15810);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e15834){var ex__13886__auto__ = e15834;
var statearr_15835_15854 = state_15810;
(statearr_15835_15854[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_15810[(4)]))){
var statearr_15836_15855 = state_15810;
(statearr_15836_15855[(1)] = cljs.core.first((state_15810[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__15856 = state_15810;
state_15810 = G__15856;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
cljs$core$async$state_machine__13883__auto__ = function(state_15810){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__13883__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__13883__auto____1.call(this,state_15810);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__13883__auto____0;
cljs$core$async$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__13883__auto____1;
return cljs$core$async$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_15837 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_15837[(6)] = c__13957__auto___15839);

return statearr_15837;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

