// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__7922){
var vec__7923 = p__7922;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7923,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7923,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__7926 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7926,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7926,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7926,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7926,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7926,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$gcol,gcol,cljs.core.cst$kw$source,(goog.object.get(source_map,"sources")[source]),cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$name,(function (){var temp__5753__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5753__auto__)){
var name__$1 = temp__5753__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__7929 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7929,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7929,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7929,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7929,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7929,(4),null);
var vec__7932 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7932,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7932,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7932,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7932,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7932,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4160__auto__ = source;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4160__auto__ = line;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4160__auto__ = col;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4160__auto__ = name;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name,(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__7935 = segmap;
var map__7935__$1 = cljs.core.__destructure_map(map__7935);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7935__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7935__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7935__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7935__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7935__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gline,gline,cljs.core.cst$kw$gcol,gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__7937 = arguments.length;
switch (G__7937) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__7941 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__7945 = cljs.core.next(segs__$1);
var G__7946 = nrelseg;
var G__7947 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__7945;
relseg__$1 = G__7946;
result__$1 = G__7947;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7941,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7941,(1),null);
var G__7948 = (gline + (1));
var G__7949 = cljs.core.next(lines__$1);
var G__7950 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__7951 = result__$1;
gline = G__7948;
lines__$1 = G__7949;
relseg = G__7950;
result = G__7951;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__7953 = segmap;
var map__7953__$1 = cljs.core.__destructure_map(map__7953);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7953__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7953__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7953__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7953__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7953__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$source,source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__7952_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__7952_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__7955 = arguments.length;
switch (G__7955) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__7959 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__7963 = cljs.core.next(segs__$1);
var G__7964 = nrelseg;
var G__7965 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__7963;
relseg__$1 = G__7964;
result__$1 = G__7965;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7959,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7959,(1),null);
var G__7966 = (gline + (1));
var G__7967 = cljs.core.next(lines__$1);
var G__7968 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__7969 = result__$1;
gline = G__7966;
lines__$1 = G__7967;
relseg = G__7968;
result = G__7969;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__7970){
var vec__7971 = p__7970;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7971,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7971,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7971,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7971,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7971,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__7974){
var vec__7975 = p__7974;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7975,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7975,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7975,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7975,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7975,(4),null);
var seg = vec__7975;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__7978){
var vec__7979 = p__7978;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7979,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7979,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7979,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7979,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7979,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4160__auto__ = name;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4160__auto__ = cljs.core.cst$kw$preamble_DASH_line_DASH_count.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$gcol.cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5751__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5751__auto__)){
var name = temp__5751__auto__;
var idx = (function (){var temp__5751__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5751__auto____$1)){
var idx = temp__5751__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__7985 = cljs.core.seq(infos);
var chunk__7986 = null;
var count__7987 = (0);
var i__7988 = (0);
while(true){
if((i__7988 < count__7987)){
var info = chunk__7986.cljs$core$IIndexed$_nth$arity$2(null,i__7988);
var segv_8339 = info__GT_segv(info,source_idx,line,col);
var gline_8340 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_8341 = cljs.core.count(cljs.core.deref(lines));
if((gline_8340 > (lc_8341 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__7985,chunk__7986,count__7987,i__7988,segv_8339,gline_8340,lc_8341,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_8340 - (lc_8341 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_8339], null));
});})(seq__7985,chunk__7986,count__7987,i__7988,segv_8339,gline_8340,lc_8341,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__7985,chunk__7986,count__7987,i__7988,segv_8339,gline_8340,lc_8341,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8340], null),cljs.core.conj,segv_8339);
});})(seq__7985,chunk__7986,count__7987,i__7988,segv_8339,gline_8340,lc_8341,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__8342 = seq__7985;
var G__8343 = chunk__7986;
var G__8344 = count__7987;
var G__8345 = (i__7988 + (1));
seq__7985 = G__8342;
chunk__7986 = G__8343;
count__7987 = G__8344;
i__7988 = G__8345;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__7985);
if(temp__5753__auto__){
var seq__7985__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7985__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__7985__$1);
var G__8346 = cljs.core.chunk_rest(seq__7985__$1);
var G__8347 = c__4591__auto__;
var G__8348 = cljs.core.count(c__4591__auto__);
var G__8349 = (0);
seq__7985 = G__8346;
chunk__7986 = G__8347;
count__7987 = G__8348;
i__7988 = G__8349;
continue;
} else {
var info = cljs.core.first(seq__7985__$1);
var segv_8350 = info__GT_segv(info,source_idx,line,col);
var gline_8351 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_8352 = cljs.core.count(cljs.core.deref(lines));
if((gline_8351 > (lc_8352 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__7985,chunk__7986,count__7987,i__7988,segv_8350,gline_8351,lc_8352,info,seq__7985__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_8351 - (lc_8352 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_8350], null));
});})(seq__7985,chunk__7986,count__7987,i__7988,segv_8350,gline_8351,lc_8352,info,seq__7985__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__7985,chunk__7986,count__7987,i__7988,segv_8350,gline_8351,lc_8352,info,seq__7985__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8351], null),cljs.core.conj,segv_8350);
});})(seq__7985,chunk__7986,count__7987,i__7988,segv_8350,gline_8351,lc_8352,info,seq__7985__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__8353 = cljs.core.next(seq__7985__$1);
var G__8354 = null;
var G__8355 = (0);
var G__8356 = (0);
seq__7985 = G__8353;
chunk__7986 = G__8354;
count__7987 = G__8355;
i__7988 = G__8356;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__7989_8357 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__7990_8358 = null;
var count__7991_8359 = (0);
var i__7992_8360 = (0);
while(true){
if((i__7992_8360 < count__7991_8359)){
var vec__8165_8361 = chunk__7990_8358.cljs$core$IIndexed$_nth$arity$2(null,i__7992_8360);
var source_idx_8362 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8165_8361,(0),null);
var vec__8168_8363 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8165_8361,(1),null);
var __8364 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8168_8363,(0),null);
var lines_8365__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8168_8363,(1),null);
var seq__8171_8366 = cljs.core.seq(lines_8365__$1);
var chunk__8172_8367 = null;
var count__8173_8368 = (0);
var i__8174_8369 = (0);
while(true){
if((i__8174_8369 < count__8173_8368)){
var vec__8213_8370 = chunk__8172_8367.cljs$core$IIndexed$_nth$arity$2(null,i__8174_8369);
var line_8371 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8213_8370,(0),null);
var cols_8372 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8213_8370,(1),null);
var seq__8216_8373 = cljs.core.seq(cols_8372);
var chunk__8217_8374 = null;
var count__8218_8375 = (0);
var i__8219_8376 = (0);
while(true){
if((i__8219_8376 < count__8218_8375)){
var vec__8226_8377 = chunk__8217_8374.cljs$core$IIndexed$_nth$arity$2(null,i__8219_8376);
var col_8378 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8226_8377,(0),null);
var infos_8379 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8226_8377,(1),null);
encode_cols(infos_8379,source_idx_8362,line_8371,col_8378);


var G__8380 = seq__8216_8373;
var G__8381 = chunk__8217_8374;
var G__8382 = count__8218_8375;
var G__8383 = (i__8219_8376 + (1));
seq__8216_8373 = G__8380;
chunk__8217_8374 = G__8381;
count__8218_8375 = G__8382;
i__8219_8376 = G__8383;
continue;
} else {
var temp__5753__auto___8384 = cljs.core.seq(seq__8216_8373);
if(temp__5753__auto___8384){
var seq__8216_8385__$1 = temp__5753__auto___8384;
if(cljs.core.chunked_seq_QMARK_(seq__8216_8385__$1)){
var c__4591__auto___8386 = cljs.core.chunk_first(seq__8216_8385__$1);
var G__8387 = cljs.core.chunk_rest(seq__8216_8385__$1);
var G__8388 = c__4591__auto___8386;
var G__8389 = cljs.core.count(c__4591__auto___8386);
var G__8390 = (0);
seq__8216_8373 = G__8387;
chunk__8217_8374 = G__8388;
count__8218_8375 = G__8389;
i__8219_8376 = G__8390;
continue;
} else {
var vec__8229_8391 = cljs.core.first(seq__8216_8385__$1);
var col_8392 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8229_8391,(0),null);
var infos_8393 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8229_8391,(1),null);
encode_cols(infos_8393,source_idx_8362,line_8371,col_8392);


var G__8394 = cljs.core.next(seq__8216_8385__$1);
var G__8395 = null;
var G__8396 = (0);
var G__8397 = (0);
seq__8216_8373 = G__8394;
chunk__8217_8374 = G__8395;
count__8218_8375 = G__8396;
i__8219_8376 = G__8397;
continue;
}
} else {
}
}
break;
}


var G__8398 = seq__8171_8366;
var G__8399 = chunk__8172_8367;
var G__8400 = count__8173_8368;
var G__8401 = (i__8174_8369 + (1));
seq__8171_8366 = G__8398;
chunk__8172_8367 = G__8399;
count__8173_8368 = G__8400;
i__8174_8369 = G__8401;
continue;
} else {
var temp__5753__auto___8402 = cljs.core.seq(seq__8171_8366);
if(temp__5753__auto___8402){
var seq__8171_8403__$1 = temp__5753__auto___8402;
if(cljs.core.chunked_seq_QMARK_(seq__8171_8403__$1)){
var c__4591__auto___8404 = cljs.core.chunk_first(seq__8171_8403__$1);
var G__8405 = cljs.core.chunk_rest(seq__8171_8403__$1);
var G__8406 = c__4591__auto___8404;
var G__8407 = cljs.core.count(c__4591__auto___8404);
var G__8408 = (0);
seq__8171_8366 = G__8405;
chunk__8172_8367 = G__8406;
count__8173_8368 = G__8407;
i__8174_8369 = G__8408;
continue;
} else {
var vec__8232_8409 = cljs.core.first(seq__8171_8403__$1);
var line_8410 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8232_8409,(0),null);
var cols_8411 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8232_8409,(1),null);
var seq__8235_8412 = cljs.core.seq(cols_8411);
var chunk__8236_8413 = null;
var count__8237_8414 = (0);
var i__8238_8415 = (0);
while(true){
if((i__8238_8415 < count__8237_8414)){
var vec__8245_8416 = chunk__8236_8413.cljs$core$IIndexed$_nth$arity$2(null,i__8238_8415);
var col_8417 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8245_8416,(0),null);
var infos_8418 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8245_8416,(1),null);
encode_cols(infos_8418,source_idx_8362,line_8410,col_8417);


var G__8419 = seq__8235_8412;
var G__8420 = chunk__8236_8413;
var G__8421 = count__8237_8414;
var G__8422 = (i__8238_8415 + (1));
seq__8235_8412 = G__8419;
chunk__8236_8413 = G__8420;
count__8237_8414 = G__8421;
i__8238_8415 = G__8422;
continue;
} else {
var temp__5753__auto___8423__$1 = cljs.core.seq(seq__8235_8412);
if(temp__5753__auto___8423__$1){
var seq__8235_8424__$1 = temp__5753__auto___8423__$1;
if(cljs.core.chunked_seq_QMARK_(seq__8235_8424__$1)){
var c__4591__auto___8425 = cljs.core.chunk_first(seq__8235_8424__$1);
var G__8426 = cljs.core.chunk_rest(seq__8235_8424__$1);
var G__8427 = c__4591__auto___8425;
var G__8428 = cljs.core.count(c__4591__auto___8425);
var G__8429 = (0);
seq__8235_8412 = G__8426;
chunk__8236_8413 = G__8427;
count__8237_8414 = G__8428;
i__8238_8415 = G__8429;
continue;
} else {
var vec__8248_8430 = cljs.core.first(seq__8235_8424__$1);
var col_8431 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8248_8430,(0),null);
var infos_8432 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8248_8430,(1),null);
encode_cols(infos_8432,source_idx_8362,line_8410,col_8431);


var G__8433 = cljs.core.next(seq__8235_8424__$1);
var G__8434 = null;
var G__8435 = (0);
var G__8436 = (0);
seq__8235_8412 = G__8433;
chunk__8236_8413 = G__8434;
count__8237_8414 = G__8435;
i__8238_8415 = G__8436;
continue;
}
} else {
}
}
break;
}


var G__8437 = cljs.core.next(seq__8171_8403__$1);
var G__8438 = null;
var G__8439 = (0);
var G__8440 = (0);
seq__8171_8366 = G__8437;
chunk__8172_8367 = G__8438;
count__8173_8368 = G__8439;
i__8174_8369 = G__8440;
continue;
}
} else {
}
}
break;
}


var G__8441 = seq__7989_8357;
var G__8442 = chunk__7990_8358;
var G__8443 = count__7991_8359;
var G__8444 = (i__7992_8360 + (1));
seq__7989_8357 = G__8441;
chunk__7990_8358 = G__8442;
count__7991_8359 = G__8443;
i__7992_8360 = G__8444;
continue;
} else {
var temp__5753__auto___8445 = cljs.core.seq(seq__7989_8357);
if(temp__5753__auto___8445){
var seq__7989_8446__$1 = temp__5753__auto___8445;
if(cljs.core.chunked_seq_QMARK_(seq__7989_8446__$1)){
var c__4591__auto___8447 = cljs.core.chunk_first(seq__7989_8446__$1);
var G__8448 = cljs.core.chunk_rest(seq__7989_8446__$1);
var G__8449 = c__4591__auto___8447;
var G__8450 = cljs.core.count(c__4591__auto___8447);
var G__8451 = (0);
seq__7989_8357 = G__8448;
chunk__7990_8358 = G__8449;
count__7991_8359 = G__8450;
i__7992_8360 = G__8451;
continue;
} else {
var vec__8251_8452 = cljs.core.first(seq__7989_8446__$1);
var source_idx_8453 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8251_8452,(0),null);
var vec__8254_8454 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8251_8452,(1),null);
var __8455 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8254_8454,(0),null);
var lines_8456__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8254_8454,(1),null);
var seq__8257_8457 = cljs.core.seq(lines_8456__$1);
var chunk__8258_8458 = null;
var count__8259_8459 = (0);
var i__8260_8460 = (0);
while(true){
if((i__8260_8460 < count__8259_8459)){
var vec__8299_8461 = chunk__8258_8458.cljs$core$IIndexed$_nth$arity$2(null,i__8260_8460);
var line_8462 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8299_8461,(0),null);
var cols_8463 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8299_8461,(1),null);
var seq__8302_8464 = cljs.core.seq(cols_8463);
var chunk__8303_8465 = null;
var count__8304_8466 = (0);
var i__8305_8467 = (0);
while(true){
if((i__8305_8467 < count__8304_8466)){
var vec__8312_8468 = chunk__8303_8465.cljs$core$IIndexed$_nth$arity$2(null,i__8305_8467);
var col_8469 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8312_8468,(0),null);
var infos_8470 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8312_8468,(1),null);
encode_cols(infos_8470,source_idx_8453,line_8462,col_8469);


var G__8471 = seq__8302_8464;
var G__8472 = chunk__8303_8465;
var G__8473 = count__8304_8466;
var G__8474 = (i__8305_8467 + (1));
seq__8302_8464 = G__8471;
chunk__8303_8465 = G__8472;
count__8304_8466 = G__8473;
i__8305_8467 = G__8474;
continue;
} else {
var temp__5753__auto___8475__$1 = cljs.core.seq(seq__8302_8464);
if(temp__5753__auto___8475__$1){
var seq__8302_8476__$1 = temp__5753__auto___8475__$1;
if(cljs.core.chunked_seq_QMARK_(seq__8302_8476__$1)){
var c__4591__auto___8477 = cljs.core.chunk_first(seq__8302_8476__$1);
var G__8478 = cljs.core.chunk_rest(seq__8302_8476__$1);
var G__8479 = c__4591__auto___8477;
var G__8480 = cljs.core.count(c__4591__auto___8477);
var G__8481 = (0);
seq__8302_8464 = G__8478;
chunk__8303_8465 = G__8479;
count__8304_8466 = G__8480;
i__8305_8467 = G__8481;
continue;
} else {
var vec__8315_8482 = cljs.core.first(seq__8302_8476__$1);
var col_8483 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8315_8482,(0),null);
var infos_8484 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8315_8482,(1),null);
encode_cols(infos_8484,source_idx_8453,line_8462,col_8483);


var G__8485 = cljs.core.next(seq__8302_8476__$1);
var G__8486 = null;
var G__8487 = (0);
var G__8488 = (0);
seq__8302_8464 = G__8485;
chunk__8303_8465 = G__8486;
count__8304_8466 = G__8487;
i__8305_8467 = G__8488;
continue;
}
} else {
}
}
break;
}


var G__8489 = seq__8257_8457;
var G__8490 = chunk__8258_8458;
var G__8491 = count__8259_8459;
var G__8492 = (i__8260_8460 + (1));
seq__8257_8457 = G__8489;
chunk__8258_8458 = G__8490;
count__8259_8459 = G__8491;
i__8260_8460 = G__8492;
continue;
} else {
var temp__5753__auto___8493__$1 = cljs.core.seq(seq__8257_8457);
if(temp__5753__auto___8493__$1){
var seq__8257_8494__$1 = temp__5753__auto___8493__$1;
if(cljs.core.chunked_seq_QMARK_(seq__8257_8494__$1)){
var c__4591__auto___8495 = cljs.core.chunk_first(seq__8257_8494__$1);
var G__8496 = cljs.core.chunk_rest(seq__8257_8494__$1);
var G__8497 = c__4591__auto___8495;
var G__8498 = cljs.core.count(c__4591__auto___8495);
var G__8499 = (0);
seq__8257_8457 = G__8496;
chunk__8258_8458 = G__8497;
count__8259_8459 = G__8498;
i__8260_8460 = G__8499;
continue;
} else {
var vec__8318_8500 = cljs.core.first(seq__8257_8494__$1);
var line_8501 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8318_8500,(0),null);
var cols_8502 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8318_8500,(1),null);
var seq__8321_8503 = cljs.core.seq(cols_8502);
var chunk__8322_8504 = null;
var count__8323_8505 = (0);
var i__8324_8506 = (0);
while(true){
if((i__8324_8506 < count__8323_8505)){
var vec__8331_8507 = chunk__8322_8504.cljs$core$IIndexed$_nth$arity$2(null,i__8324_8506);
var col_8508 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8331_8507,(0),null);
var infos_8509 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8331_8507,(1),null);
encode_cols(infos_8509,source_idx_8453,line_8501,col_8508);


var G__8510 = seq__8321_8503;
var G__8511 = chunk__8322_8504;
var G__8512 = count__8323_8505;
var G__8513 = (i__8324_8506 + (1));
seq__8321_8503 = G__8510;
chunk__8322_8504 = G__8511;
count__8323_8505 = G__8512;
i__8324_8506 = G__8513;
continue;
} else {
var temp__5753__auto___8514__$2 = cljs.core.seq(seq__8321_8503);
if(temp__5753__auto___8514__$2){
var seq__8321_8515__$1 = temp__5753__auto___8514__$2;
if(cljs.core.chunked_seq_QMARK_(seq__8321_8515__$1)){
var c__4591__auto___8516 = cljs.core.chunk_first(seq__8321_8515__$1);
var G__8517 = cljs.core.chunk_rest(seq__8321_8515__$1);
var G__8518 = c__4591__auto___8516;
var G__8519 = cljs.core.count(c__4591__auto___8516);
var G__8520 = (0);
seq__8321_8503 = G__8517;
chunk__8322_8504 = G__8518;
count__8323_8505 = G__8519;
i__8324_8506 = G__8520;
continue;
} else {
var vec__8334_8521 = cljs.core.first(seq__8321_8515__$1);
var col_8522 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8334_8521,(0),null);
var infos_8523 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8334_8521,(1),null);
encode_cols(infos_8523,source_idx_8453,line_8501,col_8522);


var G__8524 = cljs.core.next(seq__8321_8515__$1);
var G__8525 = null;
var G__8526 = (0);
var G__8527 = (0);
seq__8321_8503 = G__8524;
chunk__8322_8504 = G__8525;
count__8323_8505 = G__8526;
i__8324_8506 = G__8527;
continue;
}
} else {
}
}
break;
}


var G__8528 = cljs.core.next(seq__8257_8494__$1);
var G__8529 = null;
var G__8530 = (0);
var G__8531 = (0);
seq__8257_8457 = G__8528;
chunk__8258_8458 = G__8529;
count__8259_8459 = G__8530;
i__8260_8460 = G__8531;
continue;
}
} else {
}
}
break;
}


var G__8532 = cljs.core.next(seq__7989_8446__$1);
var G__8533 = null;
var G__8534 = (0);
var G__8535 = (0);
seq__7989_8357 = G__8532;
chunk__7990_8358 = G__8533;
count__7991_8359 = G__8534;
i__7992_8360 = G__8535;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__8337 = ({"version": (3), "file": cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((cljs.core.cst$kw$source_DASH_map_DASH_timestamp.cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__7982_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__7982_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__7983_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__7983_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": cljs.core.cst$kw$lines.cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__7984_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__7984_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts))){
var G__8338 = G__8337;
goog.object.set(G__8338,"sourcesContent",cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts)));

return G__8338;
} else {
return G__8337;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__8536 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8536,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8536,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__8539 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8539,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8539,(1),null);
var G__8544 = cljs.core.next(col_map_seq);
var G__8545 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__8539,col,infos,vec__8536,line,col_map){
return (function (v,p__8542){
var map__8543 = p__8542;
var map__8543__$1 = cljs.core.__destructure_map(map__8543);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8543__$1,cljs.core.cst$kw$gline);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8543__$1,cljs.core.cst$kw$gcol);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__8539,col,infos,vec__8536,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__8544;
new_cols = G__8545;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__8546 = cljs.core.next(line_map_seq);
var G__8547 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__8546;
new_lines = G__8547;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__8548_8756 = cljs.core.seq(reverse_map);
var chunk__8549_8757 = null;
var count__8550_8758 = (0);
var i__8551_8759 = (0);
while(true){
if((i__8551_8759 < count__8550_8758)){
var vec__8654_8760 = chunk__8549_8757.cljs$core$IIndexed$_nth$arity$2(null,i__8551_8759);
var line_8761 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8654_8760,(0),null);
var columns_8762 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8654_8760,(1),null);
var seq__8657_8763 = cljs.core.seq(columns_8762);
var chunk__8658_8764 = null;
var count__8659_8765 = (0);
var i__8660_8766 = (0);
while(true){
if((i__8660_8766 < count__8659_8765)){
var vec__8683_8767 = chunk__8658_8764.cljs$core$IIndexed$_nth$arity$2(null,i__8660_8766);
var column_8768 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8683_8767,(0),null);
var column_info_8769 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8683_8767,(1),null);
var seq__8686_8770 = cljs.core.seq(column_info_8769);
var chunk__8687_8771 = null;
var count__8688_8772 = (0);
var i__8689_8773 = (0);
while(true){
if((i__8689_8773 < count__8688_8772)){
var map__8692_8774 = chunk__8687_8771.cljs$core$IIndexed$_nth$arity$2(null,i__8689_8773);
var map__8692_8775__$1 = cljs.core.__destructure_map(map__8692_8774);
var gline_8776 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8692_8775__$1,cljs.core.cst$kw$gline);
var gcol_8777 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8692_8775__$1,cljs.core.cst$kw$gcol);
var name_8778 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8692_8775__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8776], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__8686_8770,chunk__8687_8771,count__8688_8772,i__8689_8773,seq__8657_8763,chunk__8658_8764,count__8659_8765,i__8660_8766,seq__8548_8756,chunk__8549_8757,count__8550_8758,i__8551_8759,map__8692_8774,map__8692_8775__$1,gline_8776,gcol_8777,name_8778,vec__8683_8767,column_8768,column_info_8769,vec__8654_8760,line_8761,columns_8762,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_8777], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_8761,cljs.core.cst$kw$col,column_8768,cljs.core.cst$kw$name,name_8778], null));
});})(seq__8686_8770,chunk__8687_8771,count__8688_8772,i__8689_8773,seq__8657_8763,chunk__8658_8764,count__8659_8765,i__8660_8766,seq__8548_8756,chunk__8549_8757,count__8550_8758,i__8551_8759,map__8692_8774,map__8692_8775__$1,gline_8776,gcol_8777,name_8778,vec__8683_8767,column_8768,column_info_8769,vec__8654_8760,line_8761,columns_8762,inverted))
,cljs.core.sorted_map()));


var G__8779 = seq__8686_8770;
var G__8780 = chunk__8687_8771;
var G__8781 = count__8688_8772;
var G__8782 = (i__8689_8773 + (1));
seq__8686_8770 = G__8779;
chunk__8687_8771 = G__8780;
count__8688_8772 = G__8781;
i__8689_8773 = G__8782;
continue;
} else {
var temp__5753__auto___8783 = cljs.core.seq(seq__8686_8770);
if(temp__5753__auto___8783){
var seq__8686_8784__$1 = temp__5753__auto___8783;
if(cljs.core.chunked_seq_QMARK_(seq__8686_8784__$1)){
var c__4591__auto___8785 = cljs.core.chunk_first(seq__8686_8784__$1);
var G__8786 = cljs.core.chunk_rest(seq__8686_8784__$1);
var G__8787 = c__4591__auto___8785;
var G__8788 = cljs.core.count(c__4591__auto___8785);
var G__8789 = (0);
seq__8686_8770 = G__8786;
chunk__8687_8771 = G__8787;
count__8688_8772 = G__8788;
i__8689_8773 = G__8789;
continue;
} else {
var map__8693_8790 = cljs.core.first(seq__8686_8784__$1);
var map__8693_8791__$1 = cljs.core.__destructure_map(map__8693_8790);
var gline_8792 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8693_8791__$1,cljs.core.cst$kw$gline);
var gcol_8793 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8693_8791__$1,cljs.core.cst$kw$gcol);
var name_8794 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8693_8791__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8792], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__8686_8770,chunk__8687_8771,count__8688_8772,i__8689_8773,seq__8657_8763,chunk__8658_8764,count__8659_8765,i__8660_8766,seq__8548_8756,chunk__8549_8757,count__8550_8758,i__8551_8759,map__8693_8790,map__8693_8791__$1,gline_8792,gcol_8793,name_8794,seq__8686_8784__$1,temp__5753__auto___8783,vec__8683_8767,column_8768,column_info_8769,vec__8654_8760,line_8761,columns_8762,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_8793], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_8761,cljs.core.cst$kw$col,column_8768,cljs.core.cst$kw$name,name_8794], null));
});})(seq__8686_8770,chunk__8687_8771,count__8688_8772,i__8689_8773,seq__8657_8763,chunk__8658_8764,count__8659_8765,i__8660_8766,seq__8548_8756,chunk__8549_8757,count__8550_8758,i__8551_8759,map__8693_8790,map__8693_8791__$1,gline_8792,gcol_8793,name_8794,seq__8686_8784__$1,temp__5753__auto___8783,vec__8683_8767,column_8768,column_info_8769,vec__8654_8760,line_8761,columns_8762,inverted))
,cljs.core.sorted_map()));


var G__8795 = cljs.core.next(seq__8686_8784__$1);
var G__8796 = null;
var G__8797 = (0);
var G__8798 = (0);
seq__8686_8770 = G__8795;
chunk__8687_8771 = G__8796;
count__8688_8772 = G__8797;
i__8689_8773 = G__8798;
continue;
}
} else {
}
}
break;
}


var G__8799 = seq__8657_8763;
var G__8800 = chunk__8658_8764;
var G__8801 = count__8659_8765;
var G__8802 = (i__8660_8766 + (1));
seq__8657_8763 = G__8799;
chunk__8658_8764 = G__8800;
count__8659_8765 = G__8801;
i__8660_8766 = G__8802;
continue;
} else {
var temp__5753__auto___8803 = cljs.core.seq(seq__8657_8763);
if(temp__5753__auto___8803){
var seq__8657_8804__$1 = temp__5753__auto___8803;
if(cljs.core.chunked_seq_QMARK_(seq__8657_8804__$1)){
var c__4591__auto___8805 = cljs.core.chunk_first(seq__8657_8804__$1);
var G__8806 = cljs.core.chunk_rest(seq__8657_8804__$1);
var G__8807 = c__4591__auto___8805;
var G__8808 = cljs.core.count(c__4591__auto___8805);
var G__8809 = (0);
seq__8657_8763 = G__8806;
chunk__8658_8764 = G__8807;
count__8659_8765 = G__8808;
i__8660_8766 = G__8809;
continue;
} else {
var vec__8694_8810 = cljs.core.first(seq__8657_8804__$1);
var column_8811 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8694_8810,(0),null);
var column_info_8812 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8694_8810,(1),null);
var seq__8697_8813 = cljs.core.seq(column_info_8812);
var chunk__8698_8814 = null;
var count__8699_8815 = (0);
var i__8700_8816 = (0);
while(true){
if((i__8700_8816 < count__8699_8815)){
var map__8703_8817 = chunk__8698_8814.cljs$core$IIndexed$_nth$arity$2(null,i__8700_8816);
var map__8703_8818__$1 = cljs.core.__destructure_map(map__8703_8817);
var gline_8819 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8703_8818__$1,cljs.core.cst$kw$gline);
var gcol_8820 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8703_8818__$1,cljs.core.cst$kw$gcol);
var name_8821 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8703_8818__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8819], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__8697_8813,chunk__8698_8814,count__8699_8815,i__8700_8816,seq__8657_8763,chunk__8658_8764,count__8659_8765,i__8660_8766,seq__8548_8756,chunk__8549_8757,count__8550_8758,i__8551_8759,map__8703_8817,map__8703_8818__$1,gline_8819,gcol_8820,name_8821,vec__8694_8810,column_8811,column_info_8812,seq__8657_8804__$1,temp__5753__auto___8803,vec__8654_8760,line_8761,columns_8762,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_8820], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_8761,cljs.core.cst$kw$col,column_8811,cljs.core.cst$kw$name,name_8821], null));
});})(seq__8697_8813,chunk__8698_8814,count__8699_8815,i__8700_8816,seq__8657_8763,chunk__8658_8764,count__8659_8765,i__8660_8766,seq__8548_8756,chunk__8549_8757,count__8550_8758,i__8551_8759,map__8703_8817,map__8703_8818__$1,gline_8819,gcol_8820,name_8821,vec__8694_8810,column_8811,column_info_8812,seq__8657_8804__$1,temp__5753__auto___8803,vec__8654_8760,line_8761,columns_8762,inverted))
,cljs.core.sorted_map()));


var G__8822 = seq__8697_8813;
var G__8823 = chunk__8698_8814;
var G__8824 = count__8699_8815;
var G__8825 = (i__8700_8816 + (1));
seq__8697_8813 = G__8822;
chunk__8698_8814 = G__8823;
count__8699_8815 = G__8824;
i__8700_8816 = G__8825;
continue;
} else {
var temp__5753__auto___8826__$1 = cljs.core.seq(seq__8697_8813);
if(temp__5753__auto___8826__$1){
var seq__8697_8827__$1 = temp__5753__auto___8826__$1;
if(cljs.core.chunked_seq_QMARK_(seq__8697_8827__$1)){
var c__4591__auto___8828 = cljs.core.chunk_first(seq__8697_8827__$1);
var G__8829 = cljs.core.chunk_rest(seq__8697_8827__$1);
var G__8830 = c__4591__auto___8828;
var G__8831 = cljs.core.count(c__4591__auto___8828);
var G__8832 = (0);
seq__8697_8813 = G__8829;
chunk__8698_8814 = G__8830;
count__8699_8815 = G__8831;
i__8700_8816 = G__8832;
continue;
} else {
var map__8704_8833 = cljs.core.first(seq__8697_8827__$1);
var map__8704_8834__$1 = cljs.core.__destructure_map(map__8704_8833);
var gline_8835 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8704_8834__$1,cljs.core.cst$kw$gline);
var gcol_8836 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8704_8834__$1,cljs.core.cst$kw$gcol);
var name_8837 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8704_8834__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8835], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__8697_8813,chunk__8698_8814,count__8699_8815,i__8700_8816,seq__8657_8763,chunk__8658_8764,count__8659_8765,i__8660_8766,seq__8548_8756,chunk__8549_8757,count__8550_8758,i__8551_8759,map__8704_8833,map__8704_8834__$1,gline_8835,gcol_8836,name_8837,seq__8697_8827__$1,temp__5753__auto___8826__$1,vec__8694_8810,column_8811,column_info_8812,seq__8657_8804__$1,temp__5753__auto___8803,vec__8654_8760,line_8761,columns_8762,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_8836], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_8761,cljs.core.cst$kw$col,column_8811,cljs.core.cst$kw$name,name_8837], null));
});})(seq__8697_8813,chunk__8698_8814,count__8699_8815,i__8700_8816,seq__8657_8763,chunk__8658_8764,count__8659_8765,i__8660_8766,seq__8548_8756,chunk__8549_8757,count__8550_8758,i__8551_8759,map__8704_8833,map__8704_8834__$1,gline_8835,gcol_8836,name_8837,seq__8697_8827__$1,temp__5753__auto___8826__$1,vec__8694_8810,column_8811,column_info_8812,seq__8657_8804__$1,temp__5753__auto___8803,vec__8654_8760,line_8761,columns_8762,inverted))
,cljs.core.sorted_map()));


var G__8838 = cljs.core.next(seq__8697_8827__$1);
var G__8839 = null;
var G__8840 = (0);
var G__8841 = (0);
seq__8697_8813 = G__8838;
chunk__8698_8814 = G__8839;
count__8699_8815 = G__8840;
i__8700_8816 = G__8841;
continue;
}
} else {
}
}
break;
}


var G__8842 = cljs.core.next(seq__8657_8804__$1);
var G__8843 = null;
var G__8844 = (0);
var G__8845 = (0);
seq__8657_8763 = G__8842;
chunk__8658_8764 = G__8843;
count__8659_8765 = G__8844;
i__8660_8766 = G__8845;
continue;
}
} else {
}
}
break;
}


var G__8846 = seq__8548_8756;
var G__8847 = chunk__8549_8757;
var G__8848 = count__8550_8758;
var G__8849 = (i__8551_8759 + (1));
seq__8548_8756 = G__8846;
chunk__8549_8757 = G__8847;
count__8550_8758 = G__8848;
i__8551_8759 = G__8849;
continue;
} else {
var temp__5753__auto___8850 = cljs.core.seq(seq__8548_8756);
if(temp__5753__auto___8850){
var seq__8548_8851__$1 = temp__5753__auto___8850;
if(cljs.core.chunked_seq_QMARK_(seq__8548_8851__$1)){
var c__4591__auto___8852 = cljs.core.chunk_first(seq__8548_8851__$1);
var G__8853 = cljs.core.chunk_rest(seq__8548_8851__$1);
var G__8854 = c__4591__auto___8852;
var G__8855 = cljs.core.count(c__4591__auto___8852);
var G__8856 = (0);
seq__8548_8756 = G__8853;
chunk__8549_8757 = G__8854;
count__8550_8758 = G__8855;
i__8551_8759 = G__8856;
continue;
} else {
var vec__8705_8857 = cljs.core.first(seq__8548_8851__$1);
var line_8858 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8705_8857,(0),null);
var columns_8859 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8705_8857,(1),null);
var seq__8708_8860 = cljs.core.seq(columns_8859);
var chunk__8709_8861 = null;
var count__8710_8862 = (0);
var i__8711_8863 = (0);
while(true){
if((i__8711_8863 < count__8710_8862)){
var vec__8734_8864 = chunk__8709_8861.cljs$core$IIndexed$_nth$arity$2(null,i__8711_8863);
var column_8865 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8734_8864,(0),null);
var column_info_8866 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8734_8864,(1),null);
var seq__8737_8867 = cljs.core.seq(column_info_8866);
var chunk__8738_8868 = null;
var count__8739_8869 = (0);
var i__8740_8870 = (0);
while(true){
if((i__8740_8870 < count__8739_8869)){
var map__8743_8871 = chunk__8738_8868.cljs$core$IIndexed$_nth$arity$2(null,i__8740_8870);
var map__8743_8872__$1 = cljs.core.__destructure_map(map__8743_8871);
var gline_8873 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8743_8872__$1,cljs.core.cst$kw$gline);
var gcol_8874 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8743_8872__$1,cljs.core.cst$kw$gcol);
var name_8875 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8743_8872__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8873], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__8737_8867,chunk__8738_8868,count__8739_8869,i__8740_8870,seq__8708_8860,chunk__8709_8861,count__8710_8862,i__8711_8863,seq__8548_8756,chunk__8549_8757,count__8550_8758,i__8551_8759,map__8743_8871,map__8743_8872__$1,gline_8873,gcol_8874,name_8875,vec__8734_8864,column_8865,column_info_8866,vec__8705_8857,line_8858,columns_8859,seq__8548_8851__$1,temp__5753__auto___8850,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_8874], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_8858,cljs.core.cst$kw$col,column_8865,cljs.core.cst$kw$name,name_8875], null));
});})(seq__8737_8867,chunk__8738_8868,count__8739_8869,i__8740_8870,seq__8708_8860,chunk__8709_8861,count__8710_8862,i__8711_8863,seq__8548_8756,chunk__8549_8757,count__8550_8758,i__8551_8759,map__8743_8871,map__8743_8872__$1,gline_8873,gcol_8874,name_8875,vec__8734_8864,column_8865,column_info_8866,vec__8705_8857,line_8858,columns_8859,seq__8548_8851__$1,temp__5753__auto___8850,inverted))
,cljs.core.sorted_map()));


var G__8876 = seq__8737_8867;
var G__8877 = chunk__8738_8868;
var G__8878 = count__8739_8869;
var G__8879 = (i__8740_8870 + (1));
seq__8737_8867 = G__8876;
chunk__8738_8868 = G__8877;
count__8739_8869 = G__8878;
i__8740_8870 = G__8879;
continue;
} else {
var temp__5753__auto___8880__$1 = cljs.core.seq(seq__8737_8867);
if(temp__5753__auto___8880__$1){
var seq__8737_8881__$1 = temp__5753__auto___8880__$1;
if(cljs.core.chunked_seq_QMARK_(seq__8737_8881__$1)){
var c__4591__auto___8882 = cljs.core.chunk_first(seq__8737_8881__$1);
var G__8883 = cljs.core.chunk_rest(seq__8737_8881__$1);
var G__8884 = c__4591__auto___8882;
var G__8885 = cljs.core.count(c__4591__auto___8882);
var G__8886 = (0);
seq__8737_8867 = G__8883;
chunk__8738_8868 = G__8884;
count__8739_8869 = G__8885;
i__8740_8870 = G__8886;
continue;
} else {
var map__8744_8887 = cljs.core.first(seq__8737_8881__$1);
var map__8744_8888__$1 = cljs.core.__destructure_map(map__8744_8887);
var gline_8889 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8744_8888__$1,cljs.core.cst$kw$gline);
var gcol_8890 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8744_8888__$1,cljs.core.cst$kw$gcol);
var name_8891 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8744_8888__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8889], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__8737_8867,chunk__8738_8868,count__8739_8869,i__8740_8870,seq__8708_8860,chunk__8709_8861,count__8710_8862,i__8711_8863,seq__8548_8756,chunk__8549_8757,count__8550_8758,i__8551_8759,map__8744_8887,map__8744_8888__$1,gline_8889,gcol_8890,name_8891,seq__8737_8881__$1,temp__5753__auto___8880__$1,vec__8734_8864,column_8865,column_info_8866,vec__8705_8857,line_8858,columns_8859,seq__8548_8851__$1,temp__5753__auto___8850,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_8890], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_8858,cljs.core.cst$kw$col,column_8865,cljs.core.cst$kw$name,name_8891], null));
});})(seq__8737_8867,chunk__8738_8868,count__8739_8869,i__8740_8870,seq__8708_8860,chunk__8709_8861,count__8710_8862,i__8711_8863,seq__8548_8756,chunk__8549_8757,count__8550_8758,i__8551_8759,map__8744_8887,map__8744_8888__$1,gline_8889,gcol_8890,name_8891,seq__8737_8881__$1,temp__5753__auto___8880__$1,vec__8734_8864,column_8865,column_info_8866,vec__8705_8857,line_8858,columns_8859,seq__8548_8851__$1,temp__5753__auto___8850,inverted))
,cljs.core.sorted_map()));


var G__8892 = cljs.core.next(seq__8737_8881__$1);
var G__8893 = null;
var G__8894 = (0);
var G__8895 = (0);
seq__8737_8867 = G__8892;
chunk__8738_8868 = G__8893;
count__8739_8869 = G__8894;
i__8740_8870 = G__8895;
continue;
}
} else {
}
}
break;
}


var G__8896 = seq__8708_8860;
var G__8897 = chunk__8709_8861;
var G__8898 = count__8710_8862;
var G__8899 = (i__8711_8863 + (1));
seq__8708_8860 = G__8896;
chunk__8709_8861 = G__8897;
count__8710_8862 = G__8898;
i__8711_8863 = G__8899;
continue;
} else {
var temp__5753__auto___8900__$1 = cljs.core.seq(seq__8708_8860);
if(temp__5753__auto___8900__$1){
var seq__8708_8901__$1 = temp__5753__auto___8900__$1;
if(cljs.core.chunked_seq_QMARK_(seq__8708_8901__$1)){
var c__4591__auto___8902 = cljs.core.chunk_first(seq__8708_8901__$1);
var G__8903 = cljs.core.chunk_rest(seq__8708_8901__$1);
var G__8904 = c__4591__auto___8902;
var G__8905 = cljs.core.count(c__4591__auto___8902);
var G__8906 = (0);
seq__8708_8860 = G__8903;
chunk__8709_8861 = G__8904;
count__8710_8862 = G__8905;
i__8711_8863 = G__8906;
continue;
} else {
var vec__8745_8907 = cljs.core.first(seq__8708_8901__$1);
var column_8908 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8745_8907,(0),null);
var column_info_8909 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8745_8907,(1),null);
var seq__8748_8910 = cljs.core.seq(column_info_8909);
var chunk__8749_8911 = null;
var count__8750_8912 = (0);
var i__8751_8913 = (0);
while(true){
if((i__8751_8913 < count__8750_8912)){
var map__8754_8914 = chunk__8749_8911.cljs$core$IIndexed$_nth$arity$2(null,i__8751_8913);
var map__8754_8915__$1 = cljs.core.__destructure_map(map__8754_8914);
var gline_8916 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8754_8915__$1,cljs.core.cst$kw$gline);
var gcol_8917 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8754_8915__$1,cljs.core.cst$kw$gcol);
var name_8918 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8754_8915__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8916], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__8748_8910,chunk__8749_8911,count__8750_8912,i__8751_8913,seq__8708_8860,chunk__8709_8861,count__8710_8862,i__8711_8863,seq__8548_8756,chunk__8549_8757,count__8550_8758,i__8551_8759,map__8754_8914,map__8754_8915__$1,gline_8916,gcol_8917,name_8918,vec__8745_8907,column_8908,column_info_8909,seq__8708_8901__$1,temp__5753__auto___8900__$1,vec__8705_8857,line_8858,columns_8859,seq__8548_8851__$1,temp__5753__auto___8850,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_8917], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_8858,cljs.core.cst$kw$col,column_8908,cljs.core.cst$kw$name,name_8918], null));
});})(seq__8748_8910,chunk__8749_8911,count__8750_8912,i__8751_8913,seq__8708_8860,chunk__8709_8861,count__8710_8862,i__8711_8863,seq__8548_8756,chunk__8549_8757,count__8550_8758,i__8551_8759,map__8754_8914,map__8754_8915__$1,gline_8916,gcol_8917,name_8918,vec__8745_8907,column_8908,column_info_8909,seq__8708_8901__$1,temp__5753__auto___8900__$1,vec__8705_8857,line_8858,columns_8859,seq__8548_8851__$1,temp__5753__auto___8850,inverted))
,cljs.core.sorted_map()));


var G__8919 = seq__8748_8910;
var G__8920 = chunk__8749_8911;
var G__8921 = count__8750_8912;
var G__8922 = (i__8751_8913 + (1));
seq__8748_8910 = G__8919;
chunk__8749_8911 = G__8920;
count__8750_8912 = G__8921;
i__8751_8913 = G__8922;
continue;
} else {
var temp__5753__auto___8923__$2 = cljs.core.seq(seq__8748_8910);
if(temp__5753__auto___8923__$2){
var seq__8748_8924__$1 = temp__5753__auto___8923__$2;
if(cljs.core.chunked_seq_QMARK_(seq__8748_8924__$1)){
var c__4591__auto___8925 = cljs.core.chunk_first(seq__8748_8924__$1);
var G__8926 = cljs.core.chunk_rest(seq__8748_8924__$1);
var G__8927 = c__4591__auto___8925;
var G__8928 = cljs.core.count(c__4591__auto___8925);
var G__8929 = (0);
seq__8748_8910 = G__8926;
chunk__8749_8911 = G__8927;
count__8750_8912 = G__8928;
i__8751_8913 = G__8929;
continue;
} else {
var map__8755_8930 = cljs.core.first(seq__8748_8924__$1);
var map__8755_8931__$1 = cljs.core.__destructure_map(map__8755_8930);
var gline_8932 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8755_8931__$1,cljs.core.cst$kw$gline);
var gcol_8933 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8755_8931__$1,cljs.core.cst$kw$gcol);
var name_8934 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8755_8931__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_8932], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__8748_8910,chunk__8749_8911,count__8750_8912,i__8751_8913,seq__8708_8860,chunk__8709_8861,count__8710_8862,i__8711_8863,seq__8548_8756,chunk__8549_8757,count__8550_8758,i__8551_8759,map__8755_8930,map__8755_8931__$1,gline_8932,gcol_8933,name_8934,seq__8748_8924__$1,temp__5753__auto___8923__$2,vec__8745_8907,column_8908,column_info_8909,seq__8708_8901__$1,temp__5753__auto___8900__$1,vec__8705_8857,line_8858,columns_8859,seq__8548_8851__$1,temp__5753__auto___8850,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_8933], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_8858,cljs.core.cst$kw$col,column_8908,cljs.core.cst$kw$name,name_8934], null));
});})(seq__8748_8910,chunk__8749_8911,count__8750_8912,i__8751_8913,seq__8708_8860,chunk__8709_8861,count__8710_8862,i__8711_8863,seq__8548_8756,chunk__8549_8757,count__8550_8758,i__8551_8759,map__8755_8930,map__8755_8931__$1,gline_8932,gcol_8933,name_8934,seq__8748_8924__$1,temp__5753__auto___8923__$2,vec__8745_8907,column_8908,column_info_8909,seq__8708_8901__$1,temp__5753__auto___8900__$1,vec__8705_8857,line_8858,columns_8859,seq__8548_8851__$1,temp__5753__auto___8850,inverted))
,cljs.core.sorted_map()));


var G__8935 = cljs.core.next(seq__8748_8924__$1);
var G__8936 = null;
var G__8937 = (0);
var G__8938 = (0);
seq__8748_8910 = G__8935;
chunk__8749_8911 = G__8936;
count__8750_8912 = G__8937;
i__8751_8913 = G__8938;
continue;
}
} else {
}
}
break;
}


var G__8939 = cljs.core.next(seq__8708_8901__$1);
var G__8940 = null;
var G__8941 = (0);
var G__8942 = (0);
seq__8708_8860 = G__8939;
chunk__8709_8861 = G__8940;
count__8710_8862 = G__8941;
i__8711_8863 = G__8942;
continue;
}
} else {
}
}
break;
}


var G__8943 = cljs.core.next(seq__8548_8851__$1);
var G__8944 = null;
var G__8945 = (0);
var G__8946 = (0);
seq__8548_8756 = G__8943;
chunk__8549_8757 = G__8944;
count__8550_8758 = G__8945;
i__8551_8759 = G__8946;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
