// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.crypto.aes');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('alphabase.core');
goog.require('fluree.crypto.util');
goog.require('goog.crypt.Aes');
goog.require('goog.crypt.Cbc');
goog.require('fluree.crypto.pkcs7');
fluree.crypto.aes.encrypt_STAR_ = (function fluree$crypto$aes$encrypt_STAR_(iv,key_ba,ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
var padded = fluree.crypto.pkcs7.encode((16),ba);
return cbc.encrypt(padded,cljs.core.clj__GT_js(iv));
});
/**
 * Encrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out
 *   of key (requires Unlimited Strength crypto to be enabled).
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.encrypt = (function fluree$crypto$aes$encrypt(var_args){
var args__4777__auto__ = [];
var len__4771__auto___43948 = arguments.length;
var i__4772__auto___43949 = (0);
while(true){
if((i__4772__auto___43949 < len__4771__auto___43948)){
args__4777__auto__.push((arguments[i__4772__auto___43949]));

var G__43950 = (i__4772__auto___43949 + (1));
i__4772__auto___43949 = G__43950;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((2) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4778__auto__);
});
goog.exportSymbol('fluree.crypto.aes.encrypt', fluree.crypto.aes.encrypt);

(fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__43942){
var vec__43943 = p__43942;
var map__43946 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43943,(0),null);
var map__43946__$1 = cljs.core.__destructure_map(map__43946);
var iv = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__43946__$1,cljs.core.cst$kw$iv,new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__43946__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$hex);
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key(key,(32)):key);
var ba = ((typeof x === 'string')?alphabase.core.string__GT_bytes(x):x);
var encrypted = fluree.crypto.aes.encrypt_STAR_(iv,key_ba,ba);
var G__43947 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format);
var G__43947__$1 = (((G__43947 instanceof cljs.core.Keyword))?G__43947.fqn:null);
switch (G__43947__$1) {
case "none":
return encrypted;

break;
case "hex":
return alphabase.core.bytes__GT_hex(encrypted);

break;
case "base64":
return alphabase.core.bytes__GT_base64(encrypted);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__43947__$1)].join('')));

}
}));

(fluree.crypto.aes.encrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.encrypt.cljs$lang$applyTo = (function (seq43939){
var G__43940 = cljs.core.first(seq43939);
var seq43939__$1 = cljs.core.next(seq43939);
var G__43941 = cljs.core.first(seq43939__$1);
var seq43939__$2 = cljs.core.next(seq43939__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43940,G__43941,seq43939__$2);
}));

fluree.crypto.aes.decrypt_STAR_ = (function fluree$crypto$aes$decrypt_STAR_(iv,key_ba,x_ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
return fluree.crypto.pkcs7.decode((16),cbc.decrypt(x_ba,cljs.core.clj__GT_js(iv)));
});
/**
 * Decrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out of key.
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.decrypt = (function fluree$crypto$aes$decrypt(var_args){
var args__4777__auto__ = [];
var len__4771__auto___43963 = arguments.length;
var i__4772__auto___43964 = (0);
while(true){
if((i__4772__auto___43964 < len__4771__auto___43963)){
args__4777__auto__.push((arguments[i__4772__auto___43964]));

var G__43965 = (i__4772__auto___43964 + (1));
i__4772__auto___43964 = G__43965;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((2) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4778__auto__);
});
goog.exportSymbol('fluree.crypto.aes.decrypt', fluree.crypto.aes.decrypt);

(fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__43956){
var vec__43957 = p__43956;
var map__43960 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43957,(0),null);
var map__43960__$1 = cljs.core.__destructure_map(map__43960);
var iv = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__43960__$1,cljs.core.cst$kw$iv,new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var input_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__43960__$1,cljs.core.cst$kw$input_DASH_format,cljs.core.cst$kw$hex);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__43960__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$string);
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key(key,(32)):key);
var x_ba = ((typeof x === 'string')?(function (){var G__43961 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(input_format);
var G__43961__$1 = (((G__43961 instanceof cljs.core.Keyword))?G__43961.fqn:null);
switch (G__43961__$1) {
case "hex":
return alphabase.core.hex__GT_bytes(x);

break;
case "base64":
return alphabase.core.base64__GT_bytes(x);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__43961__$1)].join('')));

}
})():x);
var decrypt_ba = fluree.crypto.aes.decrypt_STAR_(iv,key_ba,x_ba);
var G__43962 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format);
var G__43962__$1 = (((G__43962 instanceof cljs.core.Keyword))?G__43962.fqn:null);
switch (G__43962__$1) {
case "none":
return decrypt_ba;

break;
case "hex":
return alphabase.core.bytes__GT_hex(decrypt_ba);

break;
case "string":
return alphabase.core.bytes__GT_string(decrypt_ba);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__43962__$1)].join('')));

}
}));

(fluree.crypto.aes.decrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.decrypt.cljs$lang$applyTo = (function (seq43953){
var G__43954 = cljs.core.first(seq43953);
var seq43953__$1 = cljs.core.next(seq43953);
var G__43955 = cljs.core.first(seq43953__$1);
var seq43953__$2 = cljs.core.next(seq43953__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43954,G__43955,seq43953__$2);
}));

