// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__74428_74597 = cljs.core.seq(servers);
var chunk__74429_74598 = null;
var count__74430_74599 = (0);
var i__74431_74600 = (0);
while(true){
if((i__74431_74600 < count__74430_74599)){
var server_74601 = chunk__74429_74598.cljs$core$IIndexed$_nth$arity$2(null,i__74431_74600);
var healthcheck_uri_74602 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_74601),"/fdb/health"].join('');
var resp_chan_74603 = fluree.db.util.xhttp.post_json(healthcheck_uri_74602,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__13957__auto___74604 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__74428_74597,chunk__74429_74598,count__74430_74599,i__74431_74600,c__13957__auto___74604,healthcheck_uri_74602,resp_chan_74603,server_74601){
return (function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = ((function (seq__74428_74597,chunk__74429_74598,count__74430_74599,i__74431_74600,c__13957__auto___74604,healthcheck_uri_74602,resp_chan_74603,server_74601){
return (function (state_74492){
var state_val_74493 = (state_74492[(1)]);
if((state_val_74493 === (1))){
var state_74492__$1 = state_74492;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74492__$1,(2),resp_chan_74603);
} else {
if((state_val_74493 === (2))){
var inst_74481 = (state_74492[(7)]);
var inst_74481__$1 = (state_74492[(2)]);
var inst_74482 = fluree.db.util.core.exception_QMARK_(inst_74481__$1);
var state_74492__$1 = (function (){var statearr_74494 = state_74492;
(statearr_74494[(7)] = inst_74481__$1);

return statearr_74494;
})();
if(inst_74482){
var statearr_74495_74605 = state_74492__$1;
(statearr_74495_74605[(1)] = (3));

} else {
var statearr_74496_74606 = state_74492__$1;
(statearr_74496_74606[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74493 === (3))){
var inst_74481 = (state_74492[(7)]);
var inst_74484 = cljs.core.ex_message(inst_74481);
var inst_74485 = cljs.core.ex_data(inst_74481);
var inst_74486 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_74484,inst_74485], 0));
var state_74492__$1 = state_74492;
var statearr_74497_74607 = state_74492__$1;
(statearr_74497_74607[(2)] = inst_74486);

(statearr_74497_74607[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74493 === (4))){
var inst_74488 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_74601);
var state_74492__$1 = state_74492;
var statearr_74498_74608 = state_74492__$1;
(statearr_74498_74608[(2)] = inst_74488);

(statearr_74498_74608[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74493 === (5))){
var inst_74490 = (state_74492[(2)]);
var state_74492__$1 = state_74492;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74492__$1,inst_74490);
} else {
return null;
}
}
}
}
}
});})(seq__74428_74597,chunk__74429_74598,count__74430_74599,i__74431_74600,c__13957__auto___74604,healthcheck_uri_74602,resp_chan_74603,server_74601))
;
return ((function (seq__74428_74597,chunk__74429_74598,count__74430_74599,i__74431_74600,switch__13882__auto__,c__13957__auto___74604,healthcheck_uri_74602,resp_chan_74603,server_74601){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____0 = (function (){
var statearr_74499 = [null,null,null,null,null,null,null,null];
(statearr_74499[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__);

(statearr_74499[(1)] = (1));

return statearr_74499;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____1 = (function (state_74492){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_74492);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e74500){var ex__13886__auto__ = e74500;
var statearr_74501_74609 = state_74492;
(statearr_74501_74609[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_74492[(4)]))){
var statearr_74502_74610 = state_74492;
(statearr_74502_74610[(1)] = cljs.core.first((state_74492[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__74611 = state_74492;
state_74492 = G__74611;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__ = function(state_74492){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____1.call(this,state_74492);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__;
})()
;})(seq__74428_74597,chunk__74429_74598,count__74430_74599,i__74431_74600,switch__13882__auto__,c__13957__auto___74604,healthcheck_uri_74602,resp_chan_74603,server_74601))
})();
var state__13959__auto__ = (function (){var statearr_74503 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_74503[(6)] = c__13957__auto___74604);

return statearr_74503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
});})(seq__74428_74597,chunk__74429_74598,count__74430_74599,i__74431_74600,c__13957__auto___74604,healthcheck_uri_74602,resp_chan_74603,server_74601))
);



var G__74612 = seq__74428_74597;
var G__74613 = chunk__74429_74598;
var G__74614 = count__74430_74599;
var G__74615 = (i__74431_74600 + (1));
seq__74428_74597 = G__74612;
chunk__74429_74598 = G__74613;
count__74430_74599 = G__74614;
i__74431_74600 = G__74615;
continue;
} else {
var temp__5753__auto___74616 = cljs.core.seq(seq__74428_74597);
if(temp__5753__auto___74616){
var seq__74428_74617__$1 = temp__5753__auto___74616;
if(cljs.core.chunked_seq_QMARK_(seq__74428_74617__$1)){
var c__4591__auto___74618 = cljs.core.chunk_first(seq__74428_74617__$1);
var G__74619 = cljs.core.chunk_rest(seq__74428_74617__$1);
var G__74620 = c__4591__auto___74618;
var G__74621 = cljs.core.count(c__4591__auto___74618);
var G__74622 = (0);
seq__74428_74597 = G__74619;
chunk__74429_74598 = G__74620;
count__74430_74599 = G__74621;
i__74431_74600 = G__74622;
continue;
} else {
var server_74623 = cljs.core.first(seq__74428_74617__$1);
var healthcheck_uri_74624 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_74623),"/fdb/health"].join('');
var resp_chan_74625 = fluree.db.util.xhttp.post_json(healthcheck_uri_74624,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__13957__auto___74626 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__74428_74597,chunk__74429_74598,count__74430_74599,i__74431_74600,c__13957__auto___74626,healthcheck_uri_74624,resp_chan_74625,server_74623,seq__74428_74617__$1,temp__5753__auto___74616){
return (function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = ((function (seq__74428_74597,chunk__74429_74598,count__74430_74599,i__74431_74600,c__13957__auto___74626,healthcheck_uri_74624,resp_chan_74625,server_74623,seq__74428_74617__$1,temp__5753__auto___74616){
return (function (state_74516){
var state_val_74517 = (state_74516[(1)]);
if((state_val_74517 === (1))){
var state_74516__$1 = state_74516;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74516__$1,(2),resp_chan_74625);
} else {
if((state_val_74517 === (2))){
var inst_74505 = (state_74516[(7)]);
var inst_74505__$1 = (state_74516[(2)]);
var inst_74506 = fluree.db.util.core.exception_QMARK_(inst_74505__$1);
var state_74516__$1 = (function (){var statearr_74518 = state_74516;
(statearr_74518[(7)] = inst_74505__$1);

return statearr_74518;
})();
if(inst_74506){
var statearr_74519_74627 = state_74516__$1;
(statearr_74519_74627[(1)] = (3));

} else {
var statearr_74520_74628 = state_74516__$1;
(statearr_74520_74628[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74517 === (3))){
var inst_74505 = (state_74516[(7)]);
var inst_74508 = cljs.core.ex_message(inst_74505);
var inst_74509 = cljs.core.ex_data(inst_74505);
var inst_74510 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_74508,inst_74509], 0));
var state_74516__$1 = state_74516;
var statearr_74521_74629 = state_74516__$1;
(statearr_74521_74629[(2)] = inst_74510);

(statearr_74521_74629[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74517 === (4))){
var inst_74512 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_74623);
var state_74516__$1 = state_74516;
var statearr_74522_74630 = state_74516__$1;
(statearr_74522_74630[(2)] = inst_74512);

(statearr_74522_74630[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74517 === (5))){
var inst_74514 = (state_74516[(2)]);
var state_74516__$1 = state_74516;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74516__$1,inst_74514);
} else {
return null;
}
}
}
}
}
});})(seq__74428_74597,chunk__74429_74598,count__74430_74599,i__74431_74600,c__13957__auto___74626,healthcheck_uri_74624,resp_chan_74625,server_74623,seq__74428_74617__$1,temp__5753__auto___74616))
;
return ((function (seq__74428_74597,chunk__74429_74598,count__74430_74599,i__74431_74600,switch__13882__auto__,c__13957__auto___74626,healthcheck_uri_74624,resp_chan_74625,server_74623,seq__74428_74617__$1,temp__5753__auto___74616){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____0 = (function (){
var statearr_74523 = [null,null,null,null,null,null,null,null];
(statearr_74523[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__);

(statearr_74523[(1)] = (1));

return statearr_74523;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____1 = (function (state_74516){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_74516);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e74524){var ex__13886__auto__ = e74524;
var statearr_74525_74631 = state_74516;
(statearr_74525_74631[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_74516[(4)]))){
var statearr_74526_74632 = state_74516;
(statearr_74526_74632[(1)] = cljs.core.first((state_74516[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__74633 = state_74516;
state_74516 = G__74633;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__ = function(state_74516){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____1.call(this,state_74516);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__;
})()
;})(seq__74428_74597,chunk__74429_74598,count__74430_74599,i__74431_74600,switch__13882__auto__,c__13957__auto___74626,healthcheck_uri_74624,resp_chan_74625,server_74623,seq__74428_74617__$1,temp__5753__auto___74616))
})();
var state__13959__auto__ = (function (){var statearr_74527 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_74527[(6)] = c__13957__auto___74626);

return statearr_74527;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
});})(seq__74428_74597,chunk__74429_74598,count__74430_74599,i__74431_74600,c__13957__auto___74626,healthcheck_uri_74624,resp_chan_74625,server_74623,seq__74428_74617__$1,temp__5753__auto___74616))
);



var G__74634 = cljs.core.next(seq__74428_74617__$1);
var G__74635 = null;
var G__74636 = (0);
var G__74637 = (0);
seq__74428_74597 = G__74634;
chunk__74429_74598 = G__74635;
count__74430_74599 = G__74636;
i__74431_74600 = G__74637;
continue;
}
} else {
}
}
break;
}

var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_74571){
var state_val_74572 = (state_74571[(1)]);
if((state_val_74572 === (7))){
var inst_74543 = (state_74571[(7)]);
var inst_74550 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74543,cljs.core.cst$kw$default);
var state_74571__$1 = state_74571;
if(inst_74550){
var statearr_74573_74638 = state_74571__$1;
(statearr_74573_74638[(1)] = (9));

} else {
var statearr_74574_74639 = state_74571__$1;
(statearr_74574_74639[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74572 === (1))){
var inst_74535 = (state_74571[(8)]);
var inst_74536 = (state_74571[(9)]);
var inst_74535__$1 = promise_chan;
var inst_74536__$1 = cljs.core.async.timeout((60000));
var inst_74537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74538 = [inst_74535__$1,inst_74536__$1];
var inst_74539 = (new cljs.core.PersistentVector(null,2,(5),inst_74537,inst_74538,null));
var state_74571__$1 = (function (){var statearr_74575 = state_74571;
(statearr_74575[(8)] = inst_74535__$1);

(statearr_74575[(9)] = inst_74536__$1);

return statearr_74575;
})();
return cljs.core.async.ioc_alts_BANG_(state_74571__$1,(2),inst_74539);
} else {
if((state_val_74572 === (4))){
var inst_74543 = (state_74571[(7)]);
var inst_74536 = (state_74571[(9)]);
var inst_74547 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74543,inst_74536);
var state_74571__$1 = state_74571;
if(inst_74547){
var statearr_74576_74640 = state_74571__$1;
(statearr_74576_74640[(1)] = (6));

} else {
var statearr_74577_74641 = state_74571__$1;
(statearr_74577_74641[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74572 === (13))){
var state_74571__$1 = state_74571;
var statearr_74578_74642 = state_74571__$1;
(statearr_74578_74642[(2)] = null);

(statearr_74578_74642[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74572 === (6))){
var state_74571__$1 = state_74571;
var statearr_74579_74643 = state_74571__$1;
(statearr_74579_74643[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_timeout);

(statearr_74579_74643[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74572 === (3))){
var state_74571__$1 = state_74571;
var statearr_74580_74644 = state_74571__$1;
(statearr_74580_74644[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_server_DASH_found);

(statearr_74580_74644[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74572 === (12))){
var inst_74561 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$server], 0));
var inst_74562 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_74563 = [(500),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_74564 = cljs.core.PersistentHashMap.fromArrays(inst_74562,inst_74563);
var inst_74565 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_74564);
var inst_74566 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_74565);
var state_74571__$1 = (function (){var statearr_74581 = state_74571;
(statearr_74581[(10)] = inst_74561);

return statearr_74581;
})();
var statearr_74582_74645 = state_74571__$1;
(statearr_74582_74645[(2)] = inst_74566);

(statearr_74582_74645[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74572 === (2))){
var inst_74535 = (state_74571[(8)]);
var inst_74543 = (state_74571[(7)]);
var inst_74541 = (state_74571[(2)]);
var inst_74542 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74541,(0),null);
var inst_74543__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74541,(1),null);
var inst_74544 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74543__$1,inst_74535);
var state_74571__$1 = (function (){var statearr_74583 = state_74571;
(statearr_74583[(11)] = inst_74542);

(statearr_74583[(7)] = inst_74543__$1);

return statearr_74583;
})();
if(inst_74544){
var statearr_74584_74646 = state_74571__$1;
(statearr_74584_74646[(1)] = (3));

} else {
var statearr_74585_74647 = state_74571__$1;
(statearr_74585_74647[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74572 === (11))){
var inst_74554 = (state_74571[(2)]);
var state_74571__$1 = state_74571;
var statearr_74586_74648 = state_74571__$1;
(statearr_74586_74648[(2)] = inst_74554);

(statearr_74586_74648[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74572 === (9))){
var inst_74542 = (state_74571[(11)]);
var state_74571__$1 = state_74571;
var statearr_74587_74649 = state_74571__$1;
(statearr_74587_74649[(2)] = inst_74542);

(statearr_74587_74649[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74572 === (5))){
var inst_74558 = (state_74571[(2)]);
var inst_74559 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$fluree$db$connection_SLASH_timeout,inst_74558);
var state_74571__$1 = state_74571;
if(inst_74559){
var statearr_74588_74650 = state_74571__$1;
(statearr_74588_74650[(1)] = (12));

} else {
var statearr_74589_74651 = state_74571__$1;
(statearr_74589_74651[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74572 === (14))){
var inst_74569 = (state_74571[(2)]);
var state_74571__$1 = state_74571;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74571__$1,inst_74569);
} else {
if((state_val_74572 === (10))){
var state_74571__$1 = state_74571;
var statearr_74590_74652 = state_74571__$1;
(statearr_74590_74652[(2)] = null);

(statearr_74590_74652[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74572 === (8))){
var inst_74556 = (state_74571[(2)]);
var state_74571__$1 = state_74571;
var statearr_74591_74653 = state_74571__$1;
(statearr_74591_74653[(2)] = inst_74556);

(statearr_74591_74653[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____0 = (function (){
var statearr_74592 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74592[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__);

(statearr_74592[(1)] = (1));

return statearr_74592;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____1 = (function (state_74571){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_74571);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e74593){var ex__13886__auto__ = e74593;
var statearr_74594_74654 = state_74571;
(statearr_74594_74654[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_74571[(4)]))){
var statearr_74595_74655 = state_74571;
(statearr_74595_74655[(1)] = cljs.core.first((state_74571[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__74656 = state_74571;
state_74571 = G__74656;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__ = function(state_74571){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____1.call(this,state_74571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_74596 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_74596[(6)] = c__13957__auto__);

return statearr_74596;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$chan,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$lock_DASH_id], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_74700){
var state_val_74701 = (state_74700[(1)]);
if((state_val_74701 === (7))){
var state_74700__$1 = state_74700;
var statearr_74702_74728 = state_74700__$1;
(statearr_74702_74728[(2)] = null);

(statearr_74702_74728[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74701 === (1))){
var state_74700__$1 = state_74700;
var statearr_74703_74729 = state_74700__$1;
(statearr_74703_74729[(2)] = null);

(statearr_74703_74729[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74701 === (4))){
var inst_74657 = (state_74700[(2)]);
var state_74700__$1 = state_74700;
var statearr_74704_74730 = state_74700__$1;
(statearr_74704_74730[(2)] = inst_74657);

(statearr_74704_74730[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74701 === (6))){
var inst_74679 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_74700__$1 = state_74700;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74700__$1,(9),inst_74679);
} else {
if((state_val_74701 === (3))){
var inst_74698 = (state_74700[(2)]);
var state_74700__$1 = state_74700;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74700__$1,inst_74698);
} else {
if((state_val_74701 === (12))){
var inst_74692 = (state_74700[(2)]);
var state_74700__$1 = state_74700;
var statearr_74705_74731 = state_74700__$1;
(statearr_74705_74731[(2)] = inst_74692);

(statearr_74705_74731[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74701 === (2))){
var inst_74663 = (state_74700[(7)]);
var inst_74668 = (state_74700[(8)]);
var inst_74673 = (state_74700[(9)]);
var _ = (function (){var statearr_74706 = state_74700;
(statearr_74706[(4)] = cljs.core.cons((5),(state_74700[(4)])));

return statearr_74706;
})();
var inst_74663__$1 = fluree.db.util.core.random_uuid();
var inst_74664 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74665 = [conn_id,cljs.core.cst$kw$ws];
var inst_74666 = (new cljs.core.PersistentVector(null,2,(5),inst_74664,inst_74665,null));
var inst_74667 = (function (){var lock_id = inst_74663__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$socket,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_74668__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_74666,inst_74667);
var inst_74669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74670 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$lock_DASH_id];
var inst_74671 = (new cljs.core.PersistentVector(null,3,(5),inst_74669,inst_74670,null));
var inst_74672 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_74668__$1,inst_74671);
var inst_74673__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74663__$1,inst_74672);
var inst_74674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74675 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_74676 = (new cljs.core.PersistentVector(null,3,(5),inst_74674,inst_74675,null));
var inst_74677 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_74668__$1,inst_74676);
var state_74700__$1 = (function (){var statearr_74707 = state_74700;
(statearr_74707[(7)] = inst_74663__$1);

(statearr_74707[(8)] = inst_74668__$1);

(statearr_74707[(9)] = inst_74673__$1);

(statearr_74707[(10)] = inst_74677);

return statearr_74707;
})();
if(inst_74673__$1){
var statearr_74708_74732 = state_74700__$1;
(statearr_74708_74732[(1)] = (6));

} else {
var statearr_74709_74733 = state_74700__$1;
(statearr_74709_74733[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74701 === (11))){
var inst_74684 = (state_74700[(11)]);
var inst_74683 = (state_74700[(12)]);
var inst_74677 = (state_74700[(10)]);
var inst_74690 = fluree.db.util.xhttp.try_socket(inst_74683,sub_chan,pub_chan,inst_74677,(60000),inst_74684);
var state_74700__$1 = state_74700;
var statearr_74711_74734 = state_74700__$1;
(statearr_74711_74734[(2)] = inst_74690);

(statearr_74711_74734[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74701 === (9))){
var inst_74683 = (state_74700[(12)]);
var inst_74663 = (state_74700[(7)]);
var inst_74681 = (state_74700[(13)]);
var inst_74668 = (state_74700[(8)]);
var inst_74673 = (state_74700[(9)]);
var inst_74677 = (state_74700[(10)]);
var inst_74681__$1 = (state_74700[(2)]);
var inst_74682 = clojure.string.replace(inst_74681__$1,"http","ws");
var inst_74683__$1 = [inst_74682,"/fdb/ws"].join('');
var inst_74684 = (function (){var lock_id = inst_74663;
var state = inst_74668;
var have_lock_QMARK_ = inst_74673;
var resp_chan = inst_74677;
var healthy_server = inst_74681__$1;
var ws_url = inst_74683__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_74685 = fluree.db.util.core.exception_QMARK_(inst_74681__$1);
var state_74700__$1 = (function (){var statearr_74712 = state_74700;
(statearr_74712[(11)] = inst_74684);

(statearr_74712[(12)] = inst_74683__$1);

(statearr_74712[(13)] = inst_74681__$1);

return statearr_74712;
})();
if(inst_74685){
var statearr_74713_74735 = state_74700__$1;
(statearr_74713_74735[(1)] = (10));

} else {
var statearr_74714_74736 = state_74700__$1;
(statearr_74714_74736[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74701 === (5))){
var _ = (function (){var statearr_74715 = state_74700;
(statearr_74715[(4)] = cljs.core.rest((state_74700[(4)])));

return statearr_74715;
})();
var state_74700__$1 = state_74700;
var ex74710 = (state_74700__$1[(2)]);
var statearr_74716_74737 = state_74700__$1;
(statearr_74716_74737[(5)] = ex74710);


if((ex74710 instanceof Error)){
var statearr_74717_74738 = state_74700__$1;
(statearr_74717_74738[(1)] = (4));

(statearr_74717_74738[(5)] = null);

} else {
throw ex74710;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74701 === (10))){
var inst_74681 = (state_74700[(13)]);
var inst_74677 = (state_74700[(10)]);
var inst_74687 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ws], 0));
var inst_74688 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74677,inst_74681);
var state_74700__$1 = (function (){var statearr_74718 = state_74700;
(statearr_74718[(14)] = inst_74687);

return statearr_74718;
})();
var statearr_74719_74739 = state_74700__$1;
(statearr_74719_74739[(2)] = inst_74688);

(statearr_74719_74739[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74701 === (8))){
var inst_74677 = (state_74700[(10)]);
var inst_74695 = (state_74700[(2)]);
var _ = (function (){var statearr_74720 = state_74700;
(statearr_74720[(4)] = cljs.core.rest((state_74700[(4)])));

return statearr_74720;
})();
var state_74700__$1 = (function (){var statearr_74721 = state_74700;
(statearr_74721[(15)] = inst_74695);

return statearr_74721;
})();
var statearr_74722_74740 = state_74700__$1;
(statearr_74722_74740[(2)] = inst_74677);

(statearr_74722_74740[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__13883__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__13883__auto____0 = (function (){
var statearr_74723 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74723[(0)] = fluree$db$connection$establish_socket_$_state_machine__13883__auto__);

(statearr_74723[(1)] = (1));

return statearr_74723;
});
var fluree$db$connection$establish_socket_$_state_machine__13883__auto____1 = (function (state_74700){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_74700);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e74724){var ex__13886__auto__ = e74724;
var statearr_74725_74741 = state_74700;
(statearr_74725_74741[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_74700[(4)]))){
var statearr_74726_74742 = state_74700;
(statearr_74726_74742[(1)] = cljs.core.first((state_74700[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__74743 = state_74700;
state_74700 = G__74743;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__13883__auto__ = function(state_74700){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__13883__auto____1.call(this,state_74700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__13883__auto____0;
fluree$db$connection$establish_socket_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__13883__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_74727 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_74727[(6)] = c__13957__auto__);

return statearr_74727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k74745,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__74749 = k74745;
var G__74749__$1 = (((G__74749 instanceof cljs.core.Keyword))?G__74749.fqn:null);
switch (G__74749__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k74745,else__4418__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__74750){
var vec__74751 = p__74750;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74751,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74751,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$servers,self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$req_DASH_chan,self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_read,self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_write,self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$object_DASH_cache,self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$parallelism,self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$serializer,self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$default_DASH_network,self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$publish,self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$meta,self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$add_DASH_listener,self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__74744){
var self__ = this;
var G__74744__$1 = this;
return (new cljs.core.RecordIter((0),G__74744__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (){var fexpr__74754 = (function (coll__4412__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
});
return fexpr__74754(this__4411__auto____$1);
})();
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this74746,other74747){
var self__ = this;
var this74746__$1 = this;
return (((!((other74747 == null)))) && ((this74746__$1.constructor === other74747.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.id,other74747.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.servers,other74747.servers)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.state,other74747.state)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.req_chan,other74747.req_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.sub_chan,other74747.sub_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.pub_chan,other74747.pub_chan)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.storage_read,other74747.storage_read)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.storage_write,other74747.storage_write)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.object_cache,other74747.object_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.parallelism,other74747.parallelism)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.serializer,other74747.serializer)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.default_network,other74747.default_network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.transactor_QMARK_,other74747.transactor_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.publish,other74747.publish)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.transact_handler,other74747.transact_handler)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.tx_private_key,other74747.tx_private_key)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.tx_key_id,other74747.tx_key_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.meta,other74747.meta)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.add_listener,other74747.add_listener)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.remove_listener,other74747.remove_listener)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.close,other74747.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74746__$1.__extmap,other74747.__extmap)));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [cljs.core.cst$kw$object_DASH_cache,null,cljs.core.cst$kw$default_DASH_network,null,cljs.core.cst$kw$parallelism,null,cljs.core.cst$kw$transact_DASH_handler,null,cljs.core.cst$kw$add_DASH_listener,null,cljs.core.cst$kw$meta,null,cljs.core.cst$kw$tx_DASH_private_DASH_key,null,cljs.core.cst$kw$remove_DASH_listener,null,cljs.core.cst$kw$transactor_QMARK_,null,cljs.core.cst$kw$storage_DASH_read,null,cljs.core.cst$kw$serializer,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$tx_DASH_key_DASH_id,null,cljs.core.cst$kw$storage_DASH_write,null,cljs.core.cst$kw$req_DASH_chan,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$servers,null,cljs.core.cst$kw$pub_DASH_chan,null,cljs.core.cst$kw$sub_DASH_chan,null,cljs.core.cst$kw$publish,null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__74744){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__74755 = cljs.core.keyword_identical_QMARK_;
var expr__74756 = k__4423__auto__;
if(cljs.core.truth_((function (){var G__74758 = cljs.core.cst$kw$id;
var G__74759 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74758,G__74759) : pred__74755.call(null,G__74758,G__74759));
})())){
return (new fluree.db.connection.Connection(G__74744,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74760 = cljs.core.cst$kw$servers;
var G__74761 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74760,G__74761) : pred__74755.call(null,G__74760,G__74761));
})())){
return (new fluree.db.connection.Connection(self__.id,G__74744,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74762 = cljs.core.cst$kw$state;
var G__74763 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74762,G__74763) : pred__74755.call(null,G__74762,G__74763));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__74744,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74764 = cljs.core.cst$kw$req_DASH_chan;
var G__74765 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74764,G__74765) : pred__74755.call(null,G__74764,G__74765));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__74744,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74766 = cljs.core.cst$kw$sub_DASH_chan;
var G__74767 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74766,G__74767) : pred__74755.call(null,G__74766,G__74767));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__74744,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74768 = cljs.core.cst$kw$pub_DASH_chan;
var G__74769 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74768,G__74769) : pred__74755.call(null,G__74768,G__74769));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__74744,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74770 = cljs.core.cst$kw$storage_DASH_read;
var G__74771 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74770,G__74771) : pred__74755.call(null,G__74770,G__74771));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__74744,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74772 = cljs.core.cst$kw$storage_DASH_write;
var G__74773 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74772,G__74773) : pred__74755.call(null,G__74772,G__74773));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__74744,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74774 = cljs.core.cst$kw$object_DASH_cache;
var G__74775 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74774,G__74775) : pred__74755.call(null,G__74774,G__74775));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__74744,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74776 = cljs.core.cst$kw$parallelism;
var G__74777 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74776,G__74777) : pred__74755.call(null,G__74776,G__74777));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__74744,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74778 = cljs.core.cst$kw$serializer;
var G__74779 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74778,G__74779) : pred__74755.call(null,G__74778,G__74779));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__74744,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74780 = cljs.core.cst$kw$default_DASH_network;
var G__74781 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74780,G__74781) : pred__74755.call(null,G__74780,G__74781));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__74744,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74782 = cljs.core.cst$kw$transactor_QMARK_;
var G__74783 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74782,G__74783) : pred__74755.call(null,G__74782,G__74783));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__74744,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74784 = cljs.core.cst$kw$publish;
var G__74785 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74784,G__74785) : pred__74755.call(null,G__74784,G__74785));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__74744,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74786 = cljs.core.cst$kw$transact_DASH_handler;
var G__74787 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74786,G__74787) : pred__74755.call(null,G__74786,G__74787));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__74744,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74788 = cljs.core.cst$kw$tx_DASH_private_DASH_key;
var G__74789 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74788,G__74789) : pred__74755.call(null,G__74788,G__74789));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__74744,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74790 = cljs.core.cst$kw$tx_DASH_key_DASH_id;
var G__74791 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74790,G__74791) : pred__74755.call(null,G__74790,G__74791));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__74744,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74792 = cljs.core.cst$kw$meta;
var G__74793 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74792,G__74793) : pred__74755.call(null,G__74792,G__74793));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__74744,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74794 = cljs.core.cst$kw$add_DASH_listener;
var G__74795 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74794,G__74795) : pred__74755.call(null,G__74794,G__74795));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__74744,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74796 = cljs.core.cst$kw$remove_DASH_listener;
var G__74797 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74796,G__74797) : pred__74755.call(null,G__74796,G__74797));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__74744,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74798 = cljs.core.cst$kw$close;
var G__74799 = expr__74756;
return (pred__74755.cljs$core$IFn$_invoke$arity$2 ? pred__74755.cljs$core$IFn$_invoke$arity$2(G__74798,G__74799) : pred__74755.call(null,G__74798,G__74799));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__74744,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__74744),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$servers,self__.servers,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$req_DASH_chan,self__.req_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_read,self__.storage_read,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_write,self__.storage_write,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$object_DASH_cache,self__.object_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$parallelism,self__.parallelism,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$serializer,self__.serializer,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$default_DASH_network,self__.default_network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$publish,self__.publish,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$meta,self__.meta,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$add_DASH_listener,self__.add_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__74744){
var self__ = this;
var this__4414__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__74744,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$id,cljs.core.cst$sym$servers,cljs.core.cst$sym$state,cljs.core.cst$sym$req_DASH_chan,cljs.core.cst$sym$sub_DASH_chan,cljs.core.cst$sym$pub_DASH_chan,cljs.core.cst$sym$storage_DASH_read,cljs.core.cst$sym$storage_DASH_write,cljs.core.cst$sym$object_DASH_cache,cljs.core.cst$sym$parallelism,cljs.core.cst$sym$serializer,cljs.core.cst$sym$default_DASH_network,cljs.core.cst$sym$transactor_QMARK_,cljs.core.cst$sym$publish,cljs.core.cst$sym$transact_DASH_handler,cljs.core.cst$sym$tx_DASH_private_DASH_key,cljs.core.cst$sym$tx_DASH_key_DASH_id,cljs.core.cst$sym$meta,cljs.core.cst$sym$add_DASH_listener,cljs.core.cst$sym$remove_DASH_listener,cljs.core.cst$sym$close], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__74748){
var extmap__4454__auto__ = (function (){var G__74800 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__74748,cljs.core.cst$kw$id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], 0));
if(cljs.core.record_QMARK_(G__74748)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__74800);
} else {
return G__74800;
}
})();
return (new fluree.db.connection.Connection(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$default_DASH_network.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$tx_DASH_private_DASH_key.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$tx_DASH_key_DASH_id.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__74748),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__74748),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__74805 = servers_STAR_;
var vec__74806 = G__74805;
var seq__74807 = cljs.core.seq(vec__74806);
var first__74808 = cljs.core.first(seq__74807);
var seq__74807__$1 = cljs.core.next(seq__74807);
var server = first__74808;
var r = seq__74807__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__74805__$1 = G__74805;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__74812 = G__74805__$1;
var seq__74813 = cljs.core.seq(vec__74812);
var first__74814 = cljs.core.first(seq__74813);
var seq__74813__$1 = cljs.core.next(seq__74813);
var server__$1 = first__74814;
var r__$1 = seq__74813__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

if(cljs.core.truth_((function (){var and__4149__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4149__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__74815 = r__$1;
var G__74816 = is_https_QMARK_;
var G__74817 = result_STAR_;
G__74805__$1 = G__74815;
https_QMARK___$1 = G__74816;
result__$1 = G__74817;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__74818 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket], null));
if((G__74818 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__74818);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_74847){
var state_val_74848 = (state_74847[(1)]);
if((state_val_74848 === (7))){
var inst_74833 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74834 = cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74835 = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74836 = cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74837 = fluree.db.connection.establish_socket(inst_74833,inst_74834,inst_74835,inst_74836);
var state_74847__$1 = state_74847;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74847__$1,(9),inst_74837);
} else {
if((state_val_74848 === (1))){
var state_74847__$1 = state_74847;
var statearr_74849_74868 = state_74847__$1;
(statearr_74849_74868[(2)] = null);

(statearr_74849_74868[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74848 === (4))){
var inst_74819 = (state_74847[(2)]);
var state_74847__$1 = state_74847;
var statearr_74850_74869 = state_74847__$1;
(statearr_74850_74869[(2)] = inst_74819);

(statearr_74850_74869[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74848 === (6))){
var inst_74830 = (state_74847[(7)]);
var state_74847__$1 = state_74847;
var statearr_74851_74870 = state_74847__$1;
(statearr_74851_74870[(2)] = inst_74830);

(statearr_74851_74870[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74848 === (3))){
var inst_74845 = (state_74847[(2)]);
var state_74847__$1 = state_74847;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74847__$1,inst_74845);
} else {
if((state_val_74848 === (2))){
var inst_74830 = (state_74847[(7)]);
var _ = (function (){var statearr_74853 = state_74847;
(statearr_74853[(4)] = cljs.core.cons((5),(state_74847[(4)])));

return statearr_74853;
})();
var inst_74825 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_74826 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74827 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74828 = [inst_74827,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_74829 = (new cljs.core.PersistentVector(null,3,(5),inst_74826,inst_74828,null));
var inst_74830__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_74825,inst_74829);
var state_74847__$1 = (function (){var statearr_74854 = state_74847;
(statearr_74854[(7)] = inst_74830__$1);

return statearr_74854;
})();
if(cljs.core.truth_(inst_74830__$1)){
var statearr_74855_74871 = state_74847__$1;
(statearr_74855_74871[(1)] = (6));

} else {
var statearr_74856_74872 = state_74847__$1;
(statearr_74856_74872[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74848 === (9))){
var inst_74839 = (state_74847[(2)]);
var inst_74840 = fluree.db.util.async.throw_err(inst_74839);
var state_74847__$1 = state_74847;
var statearr_74857_74873 = state_74847__$1;
(statearr_74857_74873[(2)] = inst_74840);

(statearr_74857_74873[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74848 === (5))){
var _ = (function (){var statearr_74858 = state_74847;
(statearr_74858[(4)] = cljs.core.rest((state_74847[(4)])));

return statearr_74858;
})();
var state_74847__$1 = state_74847;
var ex74852 = (state_74847__$1[(2)]);
var statearr_74859_74874 = state_74847__$1;
(statearr_74859_74874[(5)] = ex74852);


if((ex74852 instanceof Error)){
var statearr_74860_74875 = state_74847__$1;
(statearr_74860_74875[(1)] = (4));

(statearr_74860_74875[(5)] = null);

} else {
throw ex74852;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74848 === (8))){
var inst_74842 = (state_74847[(2)]);
var _ = (function (){var statearr_74861 = state_74847;
(statearr_74861[(4)] = cljs.core.rest((state_74847[(4)])));

return statearr_74861;
})();
var state_74847__$1 = state_74847;
var statearr_74862_74876 = state_74847__$1;
(statearr_74862_74876[(2)] = inst_74842);

(statearr_74862_74876[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__13883__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__13883__auto____0 = (function (){
var statearr_74863 = [null,null,null,null,null,null,null,null];
(statearr_74863[(0)] = fluree$db$connection$get_socket_$_state_machine__13883__auto__);

(statearr_74863[(1)] = (1));

return statearr_74863;
});
var fluree$db$connection$get_socket_$_state_machine__13883__auto____1 = (function (state_74847){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_74847);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e74864){var ex__13886__auto__ = e74864;
var statearr_74865_74877 = state_74847;
(statearr_74865_74877[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_74847[(4)]))){
var statearr_74866_74878 = state_74847;
(statearr_74866_74878[(1)] = cljs.core.first((state_74847[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__74879 = state_74847;
state_74847 = G__74879;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__13883__auto__ = function(state_74847){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__13883__auto____1.call(this,state_74847);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__13883__auto____0;
fluree$db$connection$get_socket_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__13883__auto____1;
return fluree$db$connection$get_socket_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_74867 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_74867[(6)] = c__13957__auto__);

return statearr_74867;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4160__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e74880){var e = e74880;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4160__auto__ = cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_75007){
var state_val_75008 = (state_75007[(1)]);
if((state_val_75008 === (7))){
var inst_75003 = (state_75007[(2)]);
var state_75007__$1 = state_75007;
var statearr_75010_75080 = state_75007__$1;
(statearr_75010_75080[(2)] = inst_75003);

(statearr_75010_75080[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (20))){
var _ = (function (){var statearr_75011 = state_75007;
(statearr_75011[(4)] = cljs.core.rest((state_75007[(4)])));

return statearr_75011;
})();
var state_75007__$1 = state_75007;
var ex75009 = (state_75007__$1[(2)]);
var statearr_75012_75081 = state_75007__$1;
(statearr_75012_75081[(5)] = ex75009);


var statearr_75013_75082 = state_75007__$1;
(statearr_75013_75082[(1)] = (10));

(statearr_75013_75082[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (27))){
var inst_74995 = (state_75007[(2)]);
var _ = (function (){var statearr_75014 = state_75007;
(statearr_75014[(4)] = cljs.core.rest((state_75007[(4)])));

return statearr_75014;
})();
var state_75007__$1 = state_75007;
var statearr_75015_75083 = state_75007__$1;
(statearr_75015_75083[(2)] = inst_74995);

(statearr_75015_75083[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (1))){
var inst_74882 = (0);
var state_75007__$1 = (function (){var statearr_75016 = state_75007;
(statearr_75016[(7)] = inst_74882);

return statearr_75016;
})();
var statearr_75017_75084 = state_75007__$1;
(statearr_75017_75084[(2)] = null);

(statearr_75017_75084[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (24))){
var inst_74973 = (state_75007[(8)]);
var inst_74973__$1 = (state_75007[(2)]);
var inst_74974 = inst_74973__$1 === true;
var state_75007__$1 = (function (){var statearr_75018 = state_75007;
(statearr_75018[(8)] = inst_74973__$1);

return statearr_75018;
})();
if(cljs.core.truth_(inst_74974)){
var statearr_75019_75085 = state_75007__$1;
(statearr_75019_75085[(1)] = (25));

} else {
var statearr_75020_75086 = state_75007__$1;
(statearr_75020_75086[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (4))){
var inst_74885 = (state_75007[(9)]);
var inst_74885__$1 = (state_75007[(2)]);
var state_75007__$1 = (function (){var statearr_75021 = state_75007;
(statearr_75021[(9)] = inst_74885__$1);

return statearr_75021;
})();
if(cljs.core.truth_(inst_74885__$1)){
var statearr_75022_75087 = state_75007__$1;
(statearr_75022_75087[(1)] = (5));

} else {
var statearr_75023_75088 = state_75007__$1;
(statearr_75023_75088[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (15))){
var inst_74898 = (state_75007[(10)]);
var state_75007__$1 = state_75007;
var statearr_75024_75089 = state_75007__$1;
(statearr_75024_75089[(2)] = inst_74898);

(statearr_75024_75089[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (21))){
var inst_74926 = (state_75007[(11)]);
var inst_74882 = (state_75007[(7)]);
var inst_74930 = (state_75007[(12)]);
var inst_74921 = (state_75007[(13)]);
var inst_74923 = (state_75007[(14)]);
var inst_74929 = (state_75007[(15)]);
var inst_74925 = (state_75007[(16)]);
var inst_74885 = (state_75007[(9)]);
var inst_74922 = (state_75007[(17)]);
var inst_74924 = (state_75007[(18)]);
var inst_74932 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74933 = [cljs.core.cst$kw$pending_DASH_req,inst_74929];
var inst_74934 = (new cljs.core.PersistentVector(null,2,(5),inst_74932,inst_74933,null));
var inst_74935 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_74934,inst_74924);
var inst_74962 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_74963 = (function (){var resp_chan = inst_74924;
var timeout = inst_74930;
var i = inst_74882;
var vec__74917 = inst_74885;
var data = inst_74923;
var map__74920 = inst_74926;
var _ = inst_74921;
var req_id = inst_74929;
var operation = inst_74922;
var c__13957__auto____$1 = inst_74962;
var msg = inst_74885;
var opts = inst_74925;
return (function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_74960){
var state_val_74961 = (state_74960[(1)]);
if((state_val_74961 === (1))){
var inst_74939 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74940 = cljs.core.async.timeout(timeout);
var inst_74941 = [resp_chan,inst_74940];
var inst_74942 = (new cljs.core.PersistentVector(null,2,(5),inst_74939,inst_74941,null));
var state_74960__$1 = state_74960;
return cljs.core.async.ioc_alts_BANG_(state_74960__$1,(2),inst_74942);
} else {
if((state_val_74961 === (2))){
var inst_74945 = (state_74960[(7)]);
var inst_74944 = (state_74960[(2)]);
var inst_74945__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74944,(0),null);
var inst_74946 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74944,(1),null);
var inst_74947 = (function (){var vec__74936 = inst_74944;
var resp = inst_74945__$1;
var c = inst_74946;
return (function (p1__74881_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__74881_SHARP_,req_id);
});
})();
var inst_74948 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$pending_DASH_req,inst_74947);
var inst_74949 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74946,resp_chan);
var state_74960__$1 = (function (){var statearr_75025 = state_74960;
(statearr_75025[(7)] = inst_74945__$1);

(statearr_75025[(8)] = inst_74948);

return statearr_75025;
})();
if(inst_74949){
var statearr_75026_75090 = state_74960__$1;
(statearr_75026_75090[(1)] = (3));

} else {
var statearr_75027_75091 = state_74960__$1;
(statearr_75027_75091[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74961 === (3))){
var inst_74945 = (state_74960[(7)]);
var state_74960__$1 = state_74960;
var statearr_75028_75092 = state_74960__$1;
(statearr_75028_75092[(2)] = inst_74945);

(statearr_75028_75092[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74961 === (4))){
var inst_74952 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_74953 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_74954 = [(408),cljs.core.cst$kw$db_SLASH_timeout];
var inst_74955 = cljs.core.PersistentHashMap.fromArrays(inst_74953,inst_74954);
var inst_74956 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74952,inst_74955);
var state_74960__$1 = state_74960;
var statearr_75029_75093 = state_74960__$1;
(statearr_75029_75093[(2)] = inst_74956);

(statearr_75029_75093[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74961 === (5))){
var inst_74958 = (state_74960[(2)]);
var state_74960__$1 = state_74960;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74960__$1,inst_74958);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__13883__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__13883__auto____0 = (function (){
var statearr_75030 = [null,null,null,null,null,null,null,null,null];
(statearr_75030[(0)] = fluree$db$connection$msg_producer_$_state_machine__13883__auto__);

(statearr_75030[(1)] = (1));

return statearr_75030;
});
var fluree$db$connection$msg_producer_$_state_machine__13883__auto____1 = (function (state_74960){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_74960);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e75031){var ex__13886__auto__ = e75031;
var statearr_75032_75094 = state_74960;
(statearr_75032_75094[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_74960[(4)]))){
var statearr_75033_75095 = state_74960;
(statearr_75033_75095[(1)] = cljs.core.first((state_74960[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__75096 = state_74960;
state_74960 = G__75096;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__13883__auto__ = function(state_74960){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__13883__auto____1.call(this,state_74960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__13883__auto____0;
fluree$db$connection$msg_producer_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__13883__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_75034 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_75034[(6)] = c__13957__auto____$1);

return statearr_75034;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
});
})();
var inst_74964 = cljs.core.async.impl.dispatch.run(inst_74963);
var state_75007__$1 = (function (){var statearr_75035 = state_75007;
(statearr_75035[(19)] = inst_74935);

(statearr_75035[(20)] = inst_74964);

return statearr_75035;
})();
var statearr_75036_75097 = state_75007__$1;
(statearr_75036_75097[(2)] = inst_74962);

(statearr_75036_75097[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (31))){
var inst_74983 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_75007__$1 = state_75007;
var statearr_75037_75098 = state_75007__$1;
(statearr_75037_75098[(2)] = inst_74983);

(statearr_75037_75098[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (32))){
var state_75007__$1 = state_75007;
var statearr_75038_75099 = state_75007__$1;
(statearr_75038_75099[(1)] = (34));



return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (33))){
var inst_74991 = (state_75007[(2)]);
var state_75007__$1 = state_75007;
var statearr_75040_75100 = state_75007__$1;
(statearr_75040_75100[(2)] = inst_74991);

(statearr_75040_75100[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (13))){
var inst_74898 = (state_75007[(10)]);
var inst_74895 = (state_75007[(2)]);
var inst_74896 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74895,(0),null);
var inst_74897 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74895,(1),null);
var inst_74898__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74895,(2),null);
var state_75007__$1 = (function (){var statearr_75041 = state_75007;
(statearr_75041[(10)] = inst_74898__$1);

(statearr_75041[(21)] = inst_74897);

(statearr_75041[(22)] = inst_74896);

return statearr_75041;
})();
if(cljs.core.truth_(inst_74898__$1)){
var statearr_75042_75101 = state_75007__$1;
(statearr_75042_75101[(1)] = (14));

} else {
var statearr_75043_75102 = state_75007__$1;
(statearr_75043_75102[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (22))){
var state_75007__$1 = state_75007;
var statearr_75044_75103 = state_75007__$1;
(statearr_75044_75103[(2)] = null);

(statearr_75044_75103[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (36))){
var inst_74989 = (state_75007[(2)]);
var state_75007__$1 = state_75007;
var statearr_75045_75104 = state_75007__$1;
(statearr_75045_75104[(2)] = inst_74989);

(statearr_75045_75104[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (29))){
var inst_74973 = (state_75007[(8)]);
var inst_74981 = (inst_74973 == null);
var state_75007__$1 = state_75007;
if(cljs.core.truth_(inst_74981)){
var statearr_75046_75105 = state_75007__$1;
(statearr_75046_75105[(1)] = (31));

} else {
var statearr_75047_75106 = state_75007__$1;
(statearr_75047_75106[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (6))){
var state_75007__$1 = state_75007;
var statearr_75048_75107 = state_75007__$1;
(statearr_75048_75107[(2)] = null);

(statearr_75048_75107[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (28))){
var inst_74973 = (state_75007[(8)]);
var inst_74979 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74973,"Error processing message in producer."], 0));
var state_75007__$1 = state_75007;
var statearr_75049_75108 = state_75007__$1;
(statearr_75049_75108[(2)] = inst_74979);

(statearr_75049_75108[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (25))){
var state_75007__$1 = state_75007;
var statearr_75050_75109 = state_75007__$1;
(statearr_75050_75109[(2)] = null);

(statearr_75050_75109[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (34))){
var inst_74973 = (state_75007[(8)]);
var inst_74986 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_74973], 0));
var state_75007__$1 = state_75007;
var statearr_75051_75110 = state_75007__$1;
(statearr_75051_75110[(2)] = inst_74986);

(statearr_75051_75110[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (17))){
var inst_74898 = (state_75007[(10)]);
var inst_74887 = (state_75007[(23)]);
var inst_74905 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74898,inst_74887);
var state_75007__$1 = state_75007;
var statearr_75052_75111 = state_75007__$1;
(statearr_75052_75111[(2)] = inst_74905);

(statearr_75052_75111[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (3))){
var inst_75005 = (state_75007[(2)]);
var state_75007__$1 = state_75007;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75007__$1,inst_75005);
} else {
if((state_val_75008 === (12))){
var state_75007__$1 = state_75007;
var statearr_75053_75112 = state_75007__$1;
(statearr_75053_75112[(2)] = null);

(statearr_75053_75112[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (2))){
var state_75007__$1 = state_75007;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75007__$1,(4),req_chan);
} else {
if((state_val_75008 === (23))){
var inst_74923 = (state_75007[(14)]);
var inst_74929 = (state_75007[(15)]);
var inst_74922 = (state_75007[(17)]);
var inst_74967 = (state_75007[(2)]);
var inst_74968 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74969 = [inst_74922,inst_74929,inst_74923];
var inst_74970 = (new cljs.core.PersistentVector(null,3,(5),inst_74968,inst_74969,null));
var inst_74971 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_74970) : publish_fn.call(null,conn,inst_74970));
var state_75007__$1 = (function (){var statearr_75054 = state_75007;
(statearr_75054[(24)] = inst_74967);

return statearr_75054;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75007__$1,(24),inst_74971);
} else {
if((state_val_75008 === (35))){
var state_75007__$1 = state_75007;
var statearr_75055_75113 = state_75007__$1;
(statearr_75055_75113[(2)] = null);

(statearr_75055_75113[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (19))){
var inst_74911 = (state_75007[(2)]);
var state_75007__$1 = state_75007;
var statearr_75056_75114 = state_75007__$1;
(statearr_75056_75114[(2)] = inst_74911);

(statearr_75056_75114[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (11))){
var inst_74885 = (state_75007[(9)]);
var state_75007__$1 = state_75007;
var statearr_75057_75115 = state_75007__$1;
(statearr_75057_75115[(2)] = inst_74885);

(statearr_75057_75115[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (9))){
var inst_74882 = (state_75007[(7)]);
var inst_74998 = (state_75007[(2)]);
var inst_74999 = (inst_74882 + (1));
var inst_74882__$1 = inst_74999;
var state_75007__$1 = (function (){var statearr_75058 = state_75007;
(statearr_75058[(7)] = inst_74882__$1);

(statearr_75058[(25)] = inst_74998);

return statearr_75058;
})();
var statearr_75059_75116 = state_75007__$1;
(statearr_75059_75116[(2)] = null);

(statearr_75059_75116[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (5))){
var state_75007__$1 = state_75007;
var statearr_75060_75117 = state_75007__$1;
(statearr_75060_75117[(2)] = null);

(statearr_75060_75117[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (14))){
var inst_74898 = (state_75007[(10)]);
var inst_74900 = fluree.db.util.async.channel_QMARK_(inst_74898);
var state_75007__$1 = state_75007;
var statearr_75061_75118 = state_75007__$1;
(statearr_75061_75118[(2)] = inst_74900);

(statearr_75061_75118[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (26))){
var inst_74973 = (state_75007[(8)]);
var inst_74977 = fluree.db.util.core.exception_QMARK_(inst_74973);
var state_75007__$1 = state_75007;
if(inst_74977){
var statearr_75062_75119 = state_75007__$1;
(statearr_75062_75119[(1)] = (28));

} else {
var statearr_75063_75120 = state_75007__$1;
(statearr_75063_75120[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (16))){
var inst_74903 = (state_75007[(2)]);
var state_75007__$1 = state_75007;
if(cljs.core.truth_(inst_74903)){
var statearr_75064_75121 = state_75007__$1;
(statearr_75064_75121[(1)] = (17));

} else {
var statearr_75065_75122 = state_75007__$1;
(statearr_75065_75122[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (30))){
var inst_74993 = (state_75007[(2)]);
var state_75007__$1 = state_75007;
var statearr_75066_75123 = state_75007__$1;
(statearr_75066_75123[(2)] = inst_74993);

(statearr_75066_75123[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (10))){
var inst_74885 = (state_75007[(9)]);
var inst_74887 = (state_75007[(2)]);
var inst_74891 = cljs.core.sequential_QMARK_(inst_74885);
var state_75007__$1 = (function (){var statearr_75067 = state_75007;
(statearr_75067[(23)] = inst_74887);

return statearr_75067;
})();
if(inst_74891){
var statearr_75068_75124 = state_75007__$1;
(statearr_75068_75124[(1)] = (11));

} else {
var statearr_75069_75125 = state_75007__$1;
(statearr_75069_75125[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (18))){
var inst_74887 = (state_75007[(23)]);
var inst_74885 = (state_75007[(9)]);
var inst_74907 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74885], 0));
var inst_74908 = ["Error processing ledger request, no valid return channel: ",inst_74907].join('');
var inst_74909 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74887,inst_74908], 0));
var state_75007__$1 = state_75007;
var statearr_75070_75126 = state_75007__$1;
(statearr_75070_75126[(2)] = inst_74909);

(statearr_75070_75126[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75008 === (8))){
var inst_74926 = (state_75007[(11)]);
var inst_74925 = (state_75007[(16)]);
var inst_74885 = (state_75007[(9)]);
var inst_74924 = (state_75007[(18)]);
var _ = (function (){var statearr_75071 = state_75007;
(statearr_75071[(4)] = cljs.core.cons((20),(state_75007[(4)])));

return statearr_75071;
})();
var inst_74921 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_74885], 0));
var inst_74922 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74885,(0),null);
var inst_74923 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74885,(1),null);
var inst_74924__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74885,(2),null);
var inst_74925__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74885,(3),null);
var inst_74926__$1 = cljs.core.__destructure_map(inst_74925__$1);
var inst_74927 = fluree.db.util.core.random_uuid();
var inst_74928 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74927);
var inst_74929 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_74926__$1,cljs.core.cst$kw$req_DASH_id,inst_74928);
var inst_74930 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_74926__$1,cljs.core.cst$kw$timeout,(60000));
var state_75007__$1 = (function (){var statearr_75072 = state_75007;
(statearr_75072[(11)] = inst_74926__$1);

(statearr_75072[(12)] = inst_74930);

(statearr_75072[(13)] = inst_74921);

(statearr_75072[(14)] = inst_74923);

(statearr_75072[(15)] = inst_74929);

(statearr_75072[(16)] = inst_74925__$1);

(statearr_75072[(17)] = inst_74922);

(statearr_75072[(18)] = inst_74924__$1);

return statearr_75072;
})();
if(cljs.core.truth_(inst_74924__$1)){
var statearr_75073_75127 = state_75007__$1;
(statearr_75073_75127[(1)] = (21));

} else {
var statearr_75074_75128 = state_75007__$1;
(statearr_75074_75128[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__13883__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__13883__auto____0 = (function (){
var statearr_75075 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75075[(0)] = fluree$db$connection$msg_producer_$_state_machine__13883__auto__);

(statearr_75075[(1)] = (1));

return statearr_75075;
});
var fluree$db$connection$msg_producer_$_state_machine__13883__auto____1 = (function (state_75007){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_75007);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e75076){var ex__13886__auto__ = e75076;
var statearr_75077_75129 = state_75007;
(statearr_75077_75129[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_75007[(4)]))){
var statearr_75078_75130 = state_75007;
(statearr_75078_75130[(1)] = cljs.core.first((state_75007[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__75131 = state_75007;
state_75007 = G__75131;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__13883__auto__ = function(state_75007){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__13883__auto____1.call(this,state_75007);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__13883__auto____0;
fluree$db$connection$msg_producer_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__13883__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_75079 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_75079[(6)] = c__13957__auto__);

return statearr_75079;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ping,true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__75132 = conn;
var map__75132__$1 = cljs.core.__destructure_map(map__75132);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75132__$1,cljs.core.cst$kw$sub_DASH_chan);
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_75214){
var state_val_75215 = (state_75214[(1)]);
if((state_val_75215 === (7))){
var inst_75210 = (state_75214[(2)]);
var state_75214__$1 = state_75214;
var statearr_75216_75267 = state_75214__$1;
(statearr_75216_75267[(2)] = inst_75210);

(statearr_75216_75267[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (20))){
var inst_75151 = (state_75214[(7)]);
var inst_75165 = [cljs.core.cst$kw$keep_DASH_alive_DASH_fn];
var inst_75166 = [inst_75151];
var inst_75167 = cljs.core.PersistentHashMap.fromArrays(inst_75165,inst_75166);
var inst_75168 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_75167], 0));
var state_75214__$1 = state_75214;
var statearr_75217_75268 = state_75214__$1;
(statearr_75217_75268[(2)] = inst_75168);

(statearr_75217_75268[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (27))){
var state_75214__$1 = state_75214;
var statearr_75218_75269 = state_75214__$1;
(statearr_75218_75269[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (1))){
var inst_75133 = (0);
var state_75214__$1 = (function (){var statearr_75220 = state_75214;
(statearr_75220[(8)] = inst_75133);

return statearr_75220;
})();
var statearr_75221_75270 = state_75214__$1;
(statearr_75221_75270[(2)] = null);

(statearr_75221_75270[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (24))){
var inst_75144 = (state_75214[(9)]);
var inst_75193 = fluree.db.util.core.exception_QMARK_(inst_75144);
var state_75214__$1 = state_75214;
if(inst_75193){
var statearr_75222_75271 = state_75214__$1;
(statearr_75222_75271[(1)] = (26));

} else {
var statearr_75223_75272 = state_75214__$1;
(statearr_75223_75272[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (4))){
var inst_75138 = (state_75214[(10)]);
var inst_75143 = (state_75214[(2)]);
var inst_75144 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75143,(0),null);
var inst_75145 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_75143,(1),null);
var inst_75146 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_75145,inst_75138);
var state_75214__$1 = (function (){var statearr_75224 = state_75214;
(statearr_75224[(9)] = inst_75144);

return statearr_75224;
})();
if(inst_75146){
var statearr_75225_75273 = state_75214__$1;
(statearr_75225_75273[(1)] = (5));

} else {
var statearr_75226_75274 = state_75214__$1;
(statearr_75226_75274[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (15))){
var inst_75151 = (state_75214[(7)]);
var inst_75160 = typeof inst_75151 === 'string';
var state_75214__$1 = state_75214;
if(cljs.core.truth_(inst_75160)){
var statearr_75227_75275 = state_75214__$1;
(statearr_75227_75275[(1)] = (17));

} else {
var statearr_75228_75276 = state_75214__$1;
(statearr_75228_75276[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (21))){
var state_75214__$1 = state_75214;
var statearr_75229_75277 = state_75214__$1;
(statearr_75229_75277[(2)] = null);

(statearr_75229_75277[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (31))){
var inst_75204 = (state_75214[(2)]);
var state_75214__$1 = state_75214;
var statearr_75230_75278 = state_75214__$1;
(statearr_75230_75278[(2)] = inst_75204);

(statearr_75230_75278[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (13))){
var inst_75177 = (state_75214[(2)]);
var inst_75178 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_75179 = fluree.db.connection.close_websocket(inst_75178);
var inst_75180 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_75181 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_75180);
var state_75214__$1 = (function (){var statearr_75231 = state_75214;
(statearr_75231[(11)] = inst_75179);

(statearr_75231[(12)] = inst_75177);

return statearr_75231;
})();
var statearr_75232_75279 = state_75214__$1;
(statearr_75232_75279[(2)] = inst_75181);

(statearr_75232_75279[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (22))){
var inst_75171 = (state_75214[(2)]);
var state_75214__$1 = state_75214;
var statearr_75233_75280 = state_75214__$1;
(statearr_75233_75280[(2)] = inst_75171);

(statearr_75233_75280[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (29))){
var inst_75144 = (state_75214[(9)]);
var inst_75199 = fluree.db.util.json.parse(inst_75144);
var inst_75200 = fluree.db.conn_events.process_events(conn,inst_75199);
var inst_75133 = (0);
var state_75214__$1 = (function (){var statearr_75234 = state_75214;
(statearr_75234[(13)] = inst_75200);

(statearr_75234[(8)] = inst_75133);

return statearr_75234;
})();
var statearr_75235_75281 = state_75214__$1;
(statearr_75235_75281[(2)] = null);

(statearr_75235_75281[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (6))){
var inst_75144 = (state_75214[(9)]);
var inst_75189 = (inst_75144 == null);
var state_75214__$1 = state_75214;
if(cljs.core.truth_(inst_75189)){
var statearr_75236_75282 = state_75214__$1;
(statearr_75236_75282[(1)] = (23));

} else {
var statearr_75237_75283 = state_75214__$1;
(statearr_75237_75283[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (28))){
var inst_75206 = (state_75214[(2)]);
var state_75214__$1 = state_75214;
var statearr_75238_75284 = state_75214__$1;
(statearr_75238_75284[(2)] = inst_75206);

(statearr_75238_75284[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (25))){
var inst_75208 = (state_75214[(2)]);
var state_75214__$1 = state_75214;
var statearr_75239_75285 = state_75214__$1;
(statearr_75239_75285[(2)] = inst_75208);

(statearr_75239_75285[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (17))){
var inst_75151 = (state_75214[(7)]);
var inst_75162 = cljs.core.eval(inst_75151);
var state_75214__$1 = state_75214;
var statearr_75240_75286 = state_75214__$1;
(statearr_75240_75286[(2)] = inst_75162);

(statearr_75240_75286[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (3))){
var inst_75212 = (state_75214[(2)]);
var state_75214__$1 = state_75214;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75214__$1,inst_75212);
} else {
if((state_val_75215 === (12))){
var inst_75151 = (state_75214[(7)]);
var inst_75156 = cljs.core.fn_QMARK_(inst_75151);
var state_75214__$1 = state_75214;
if(inst_75156){
var statearr_75241_75287 = state_75214__$1;
(statearr_75241_75287[(1)] = (14));

} else {
var statearr_75242_75288 = state_75214__$1;
(statearr_75242_75288[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (2))){
var inst_75138 = (state_75214[(10)]);
var inst_75138__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_75139 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75140 = [sub_chan,inst_75138__$1];
var inst_75141 = (new cljs.core.PersistentVector(null,2,(5),inst_75139,inst_75140,null));
var state_75214__$1 = (function (){var statearr_75243 = state_75214;
(statearr_75243[(10)] = inst_75138__$1);

return statearr_75243;
})();
return cljs.core.async.ioc_alts_BANG_(state_75214__$1,(4),inst_75141);
} else {
if((state_val_75215 === (23))){
var inst_75191 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_75214__$1 = state_75214;
var statearr_75244_75289 = state_75214__$1;
(statearr_75244_75289[(2)] = inst_75191);

(statearr_75244_75289[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (19))){
var inst_75173 = (state_75214[(2)]);
var state_75214__$1 = state_75214;
var statearr_75245_75290 = state_75214__$1;
(statearr_75245_75290[(2)] = inst_75173);

(statearr_75245_75290[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (11))){
var inst_75154 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_75214__$1 = state_75214;
var statearr_75246_75291 = state_75214__$1;
(statearr_75246_75291[(2)] = inst_75154);

(statearr_75246_75291[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (9))){
var inst_75133 = (state_75214[(8)]);
var inst_75183 = fluree.db.connection.ping_transactor(conn);
var inst_75184 = (inst_75133 + (1));
var inst_75133__$1 = inst_75184;
var state_75214__$1 = (function (){var statearr_75247 = state_75214;
(statearr_75247[(8)] = inst_75133__$1);

(statearr_75247[(14)] = inst_75183);

return statearr_75247;
})();
var statearr_75248_75292 = state_75214__$1;
(statearr_75248_75292[(2)] = null);

(statearr_75248_75292[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (5))){
var inst_75133 = (state_75214[(8)]);
var inst_75148 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_75133);
var state_75214__$1 = state_75214;
if(inst_75148){
var statearr_75249_75293 = state_75214__$1;
(statearr_75249_75293[(1)] = (8));

} else {
var statearr_75250_75294 = state_75214__$1;
(statearr_75250_75294[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (14))){
var inst_75151 = (state_75214[(7)]);
var inst_75158 = (inst_75151.cljs$core$IFn$_invoke$arity$0 ? inst_75151.cljs$core$IFn$_invoke$arity$0() : inst_75151.call(null));
var state_75214__$1 = state_75214;
var statearr_75251_75295 = state_75214__$1;
(statearr_75251_75295[(2)] = inst_75158);

(statearr_75251_75295[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (26))){
var inst_75144 = (state_75214[(9)]);
var inst_75195 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_75144], 0));
var inst_75133 = (0);
var state_75214__$1 = (function (){var statearr_75252 = state_75214;
(statearr_75252[(8)] = inst_75133);

(statearr_75252[(15)] = inst_75195);

return statearr_75252;
})();
var statearr_75253_75296 = state_75214__$1;
(statearr_75253_75296[(2)] = null);

(statearr_75253_75296[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (16))){
var inst_75175 = (state_75214[(2)]);
var state_75214__$1 = state_75214;
var statearr_75254_75297 = state_75214__$1;
(statearr_75254_75297[(2)] = inst_75175);

(statearr_75254_75297[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (30))){
var state_75214__$1 = state_75214;
var statearr_75255_75298 = state_75214__$1;
(statearr_75255_75298[(2)] = null);

(statearr_75255_75298[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (10))){
var inst_75187 = (state_75214[(2)]);
var state_75214__$1 = state_75214;
var statearr_75256_75299 = state_75214__$1;
(statearr_75256_75299[(2)] = inst_75187);

(statearr_75256_75299[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (18))){
var state_75214__$1 = state_75214;
var statearr_75257_75300 = state_75214__$1;
(statearr_75257_75300[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_75215 === (8))){
var inst_75151 = (state_75214[(7)]);
var inst_75150 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_75151__$1 = cljs.core.cst$kw$keep_DASH_alive_DASH_fn.cljs$core$IFn$_invoke$arity$1(conn);
var inst_75152 = (inst_75151__$1 == null);
var state_75214__$1 = (function (){var statearr_75259 = state_75214;
(statearr_75259[(7)] = inst_75151__$1);

(statearr_75259[(16)] = inst_75150);

return statearr_75259;
})();
if(cljs.core.truth_(inst_75152)){
var statearr_75260_75301 = state_75214__$1;
(statearr_75260_75301[(1)] = (11));

} else {
var statearr_75261_75302 = state_75214__$1;
(statearr_75261_75302[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__13883__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__13883__auto____0 = (function (){
var statearr_75262 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75262[(0)] = fluree$db$connection$msg_consumer_$_state_machine__13883__auto__);

(statearr_75262[(1)] = (1));

return statearr_75262;
});
var fluree$db$connection$msg_consumer_$_state_machine__13883__auto____1 = (function (state_75214){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_75214);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e75263){var ex__13886__auto__ = e75263;
var statearr_75264_75303 = state_75214;
(statearr_75264_75303[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_75214[(4)]))){
var statearr_75265_75304 = state_75214;
(statearr_75265_75304[(1)] = cljs.core.first((state_75214[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__75305 = state_75214;
state_75214 = G__75305;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__13883__auto__ = function(state_75214){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__13883__auto____1.call(this,state_75214);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__13883__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__13883__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_75266 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_75266[(6)] = c__13957__auto__);

return statearr_75266;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__75307 = arguments.length;
switch (G__75307) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__75308 = opts;
var map__75308__$1 = cljs.core.__destructure_map(map__75308);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75308__$1,cljs.core.cst$kw$private);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75308__$1,cljs.core.cst$kw$jwt);
return (function (k){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_75360){
var state_val_75361 = (state_75360[(1)]);
if((state_val_75361 === (7))){
var inst_75318 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_75319 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_75320 = [conn_id,cljs.core.cst$kw$token];
var inst_75321 = (new cljs.core.PersistentVector(null,2,(5),inst_75319,inst_75320,null));
var inst_75322 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_75318,inst_75321);
var state_75360__$1 = state_75360;
var statearr_75362_75393 = state_75360__$1;
(statearr_75362_75393[(2)] = inst_75322);

(statearr_75362_75393[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75361 === (1))){
var state_75360__$1 = state_75360;
var statearr_75363_75394 = state_75360__$1;
(statearr_75363_75394[(2)] = null);

(statearr_75363_75394[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75361 === (4))){
var inst_75309 = (state_75360[(2)]);
var state_75360__$1 = state_75360;
var statearr_75364_75395 = state_75360__$1;
(statearr_75364_75395[(2)] = inst_75309);

(statearr_75364_75395[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75361 === (15))){
var inst_75329 = (state_75360[(7)]);
var inst_75348 = (state_75360[(2)]);
var inst_75349 = [cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$headers,cljs.core.cst$kw$output_DASH_format];
var inst_75350 = [(5000),inst_75348,cljs.core.cst$kw$text];
var inst_75351 = cljs.core.PersistentHashMap.fromArrays(inst_75349,inst_75350);
var inst_75352 = fluree.db.util.xhttp.get(inst_75329,inst_75351);
var state_75360__$1 = state_75360;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75360__$1,(16),inst_75352);
} else {
if((state_val_75361 === (13))){
var inst_75339 = (state_75360[(8)]);
var inst_75329 = (state_75360[(7)]);
var inst_75341 = [cljs.core.cst$kw$headers];
var inst_75342 = [inst_75339];
var inst_75343 = cljs.core.PersistentHashMap.fromArrays(inst_75341,inst_75342);
var inst_75344 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_75329,inst_75343,private$);
var inst_75345 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_75344);
var state_75360__$1 = state_75360;
var statearr_75365_75396 = state_75360__$1;
(statearr_75365_75396[(2)] = inst_75345);

(statearr_75365_75396[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75361 === (6))){
var inst_75315 = (state_75360[(9)]);
var state_75360__$1 = state_75360;
var statearr_75366_75397 = state_75360__$1;
(statearr_75366_75397[(2)] = inst_75315);

(statearr_75366_75397[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75361 === (3))){
var inst_75358 = (state_75360[(2)]);
var state_75360__$1 = state_75360;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75360__$1,inst_75358);
} else {
if((state_val_75361 === (12))){
var inst_75339 = (state_75360[(2)]);
var state_75360__$1 = (function (){var statearr_75367 = state_75360;
(statearr_75367[(8)] = inst_75339);

return statearr_75367;
})();
if(cljs.core.truth_(private$)){
var statearr_75368_75398 = state_75360__$1;
(statearr_75368_75398[(1)] = (13));

} else {
var statearr_75369_75399 = state_75360__$1;
(statearr_75369_75399[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75361 === (2))){
var inst_75315 = (state_75360[(9)]);
var _ = (function (){var statearr_75370 = state_75360;
(statearr_75370[(4)] = cljs.core.cons((5),(state_75360[(4)])));

return statearr_75370;
})();
var inst_75315__$1 = jwt;
var state_75360__$1 = (function (){var statearr_75371 = state_75360;
(statearr_75371[(9)] = inst_75315__$1);

return statearr_75371;
})();
if(cljs.core.truth_(inst_75315__$1)){
var statearr_75372_75400 = state_75360__$1;
(statearr_75372_75400[(1)] = (6));

} else {
var statearr_75373_75401 = state_75360__$1;
(statearr_75373_75401[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75361 === (11))){
var inst_75333 = (state_75360[(10)]);
var state_75360__$1 = state_75360;
var statearr_75375_75402 = state_75360__$1;
(statearr_75375_75402[(2)] = inst_75333);

(statearr_75375_75402[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75361 === (9))){
var inst_75325 = (state_75360[(11)]);
var inst_75324 = (state_75360[(12)]);
var inst_75328 = (state_75360[(2)]);
var inst_75329 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75328),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75325)].join('');
var inst_75331 = ["Accept"];
var inst_75332 = ["application/json"];
var inst_75333 = cljs.core.PersistentHashMap.fromArrays(inst_75331,inst_75332);
var state_75360__$1 = (function (){var statearr_75376 = state_75360;
(statearr_75376[(7)] = inst_75329);

(statearr_75376[(10)] = inst_75333);

return statearr_75376;
})();
if(cljs.core.truth_(inst_75324)){
var statearr_75377_75403 = state_75360__$1;
(statearr_75377_75403[(1)] = (10));

} else {
var statearr_75378_75404 = state_75360__$1;
(statearr_75378_75404[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75361 === (5))){
var _ = (function (){var statearr_75379 = state_75360;
(statearr_75379[(4)] = cljs.core.rest((state_75360[(4)])));

return statearr_75379;
})();
var state_75360__$1 = state_75360;
var ex75374 = (state_75360__$1[(2)]);
var statearr_75380_75405 = state_75360__$1;
(statearr_75380_75405[(5)] = ex75374);


if((ex75374 instanceof Error)){
var statearr_75381_75406 = state_75360__$1;
(statearr_75381_75406[(1)] = (4));

(statearr_75381_75406[(5)] = null);

} else {
throw ex75374;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75361 === (14))){
var inst_75339 = (state_75360[(8)]);
var state_75360__$1 = state_75360;
var statearr_75382_75407 = state_75360__$1;
(statearr_75382_75407[(2)] = inst_75339);

(statearr_75382_75407[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75361 === (16))){
var inst_75354 = (state_75360[(2)]);
var inst_75355 = fluree.db.util.async.throw_err(inst_75354);
var _ = (function (){var statearr_75383 = state_75360;
(statearr_75383[(4)] = cljs.core.rest((state_75360[(4)])));

return statearr_75383;
})();
var state_75360__$1 = state_75360;
var statearr_75384_75408 = state_75360__$1;
(statearr_75384_75408[(2)] = inst_75355);

(statearr_75384_75408[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75361 === (10))){
var inst_75324 = (state_75360[(12)]);
var inst_75333 = (state_75360[(10)]);
var inst_75335 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_75324)].join('');
var inst_75336 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_75333,"Authorization",inst_75335);
var state_75360__$1 = state_75360;
var statearr_75385_75409 = state_75360__$1;
(statearr_75385_75409[(2)] = inst_75336);

(statearr_75385_75409[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75361 === (8))){
var inst_75324 = (state_75360[(2)]);
var inst_75325 = clojure.string.replace(k,"_","/");
var inst_75326 = fluree.db.connection.get_server(conn_id,servers);
var state_75360__$1 = (function (){var statearr_75386 = state_75360;
(statearr_75386[(11)] = inst_75325);

(statearr_75386[(12)] = inst_75324);

return statearr_75386;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75360__$1,(9),inst_75326);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__13883__auto__ = null;
var fluree$db$connection$state_machine__13883__auto____0 = (function (){
var statearr_75387 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_75387[(0)] = fluree$db$connection$state_machine__13883__auto__);

(statearr_75387[(1)] = (1));

return statearr_75387;
});
var fluree$db$connection$state_machine__13883__auto____1 = (function (state_75360){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_75360);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e75388){var ex__13886__auto__ = e75388;
var statearr_75389_75410 = state_75360;
(statearr_75389_75410[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_75360[(4)]))){
var statearr_75390_75411 = state_75360;
(statearr_75390_75411[(1)] = cljs.core.first((state_75360[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__75412 = state_75360;
state_75360 = G__75412;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$state_machine__13883__auto__ = function(state_75360){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__13883__auto____1.call(this,state_75360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__13883__auto____0;
fluree$db$connection$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__13883__auto____1;
return fluree$db$connection$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_75391 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_75391[(6)] = c__13957__auto__);

return statearr_75391;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return cljs.core.cst$kw$listeners.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__75413_SHARP_){
if(cljs.core.truth_(p1__75413_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$token], null),(function (p1__75414_SHARP_){
var or__4160__auto__ = p1__75414_SHARP_;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return token;
}
}));

return true;
}catch (e75415){var e = e75415;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$close_QMARK_,false,cljs.core.cst$kw$health,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$connected_DASH_to,null,cljs.core.cst$kw$socket,null,cljs.core.cst$kw$socket_DASH_id,null,cljs.core.cst$kw$pending_DASH_req,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$listeners,cljs.core.PersistentArrayMap.EMPTY], null));
var map__75416 = opts;
var map__75416__$1 = cljs.core.__destructure_map(map__75416);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75416__$1,cljs.core.cst$kw$sub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75416__$1,cljs.core.cst$kw$storage_DASH_rename);
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75416__$1,cljs.core.cst$kw$keep_DASH_alive_DASH_fn);
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75416__$1,cljs.core.cst$kw$publish);
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75416__$1,cljs.core.cst$kw$close_DASH_fn);
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75416__$1,cljs.core.cst$kw$default_DASH_network);
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75416__$1,cljs.core.cst$kw$object_DASH_cache);
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75416__$1,cljs.core.cst$kw$transact_DASH_handler);
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75416__$1,cljs.core.cst$kw$parallelism,(4));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75416__$1,cljs.core.cst$kw$meta);
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75416__$1,cljs.core.cst$kw$tx_DASH_private_DASH_key);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75416__$1,cljs.core.cst$kw$private);
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75416__$1,cljs.core.cst$kw$storage_DASH_read);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75416__$1,cljs.core.cst$kw$transactor_QMARK_,false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75416__$1,cljs.core.cst$kw$serializer,fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75416__$1,cljs.core.cst$kw$memory,(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75416__$1,cljs.core.cst$kw$storage_DASH_exists);
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75416__$1,cljs.core.cst$kw$storage_DASH_write,(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75416__$1,cljs.core.cst$kw$memory_QMARK_,false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75416__$1,cljs.core.cst$kw$req_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75416__$1,cljs.core.cst$kw$pub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__75416__$1,cljs.core.cst$kw$private_DASH_key_DASH_file,"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__75416__$1,cljs.core.cst$kw$storage_DASH_list);
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_configuration], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4160__auto__ = object_cache;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,cljs.core.cst$kw$close_QMARK_,true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$conn_DASH_closed], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4160__auto__ = storage_read;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4160__auto__ = storage_exists;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = storage_read;
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4149__auto__ = storage_write;
if(cljs.core.truth_(and__4149__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4149__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$meta,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$serializer,cljs.core.cst$kw$memory,cljs.core.cst$kw$storage_DASH_exists,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_list,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$storage_DASH_rename,cljs.core.cst$kw$keep_DASH_alive_DASH_fn,cljs.core.cst$kw$publish],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__75417_75418 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__75417_75418.cljs$core$IFn$_invoke$arity$0 ? fexpr__75417_75418.cljs$core$IFn$_invoke$arity$0() : fexpr__75417_75418.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4777__auto__ = [];
var len__4771__auto___75451 = arguments.length;
var i__4772__auto___75452 = (0);
while(true){
if((i__4772__auto___75452 < len__4771__auto___75451)){
args__4777__auto__.push((arguments[i__4772__auto___75452]));

var G__75453 = (i__4772__auto___75452 + (1));
i__4772__auto___75452 = G__75453;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__75421){
var vec__75422 = p__75421;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__75422,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(opts);
var dev_QMARK_ = cljs.core.cst$kw$dev_QMARK_.cljs$core$IFn$_invoke$arity$1(conn.meta);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__13957__auto___75454 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_75439){
var state_val_75440 = (state_75439[(1)]);
if((state_val_75440 === (1))){
var inst_75425 = fluree.db.connection.get_socket(conn);
var state_75439__$1 = state_75439;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_75439__$1,(2),inst_75425);
} else {
if((state_val_75440 === (2))){
var inst_75427 = (state_75439[(2)]);
var inst_75428 = (inst_75427 == null);
var inst_75429 = fluree.db.util.core.exception_QMARK_(inst_75427);
var inst_75430 = ((inst_75428) || (inst_75429));
var state_75439__$1 = state_75439;
if(cljs.core.truth_(inst_75430)){
var statearr_75441_75455 = state_75439__$1;
(statearr_75441_75455[(1)] = (3));

} else {
var statearr_75442_75456 = state_75439__$1;
(statearr_75442_75456[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_75440 === (3))){
var inst_75432 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_75433 = cljs.core.async.close_BANG_(conn);
var state_75439__$1 = (function (){var statearr_75443 = state_75439;
(statearr_75443[(7)] = inst_75432);

return statearr_75443;
})();
var statearr_75444_75457 = state_75439__$1;
(statearr_75444_75457[(2)] = inst_75433);

(statearr_75444_75457[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75440 === (4))){
var inst_75435 = fluree.db.connection.msg_consumer(conn);
var state_75439__$1 = state_75439;
var statearr_75445_75458 = state_75439__$1;
(statearr_75445_75458[(2)] = inst_75435);

(statearr_75445_75458[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_75440 === (5))){
var inst_75437 = (state_75439[(2)]);
var state_75439__$1 = state_75439;
return cljs.core.async.impl.ioc_helpers.return_chan(state_75439__$1,inst_75437);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__13883__auto__ = null;
var fluree$db$connection$state_machine__13883__auto____0 = (function (){
var statearr_75446 = [null,null,null,null,null,null,null,null];
(statearr_75446[(0)] = fluree$db$connection$state_machine__13883__auto__);

(statearr_75446[(1)] = (1));

return statearr_75446;
});
var fluree$db$connection$state_machine__13883__auto____1 = (function (state_75439){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_75439);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e75447){var ex__13886__auto__ = e75447;
var statearr_75448_75459 = state_75439;
(statearr_75448_75459[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_75439[(4)]))){
var statearr_75449_75460 = state_75439;
(statearr_75449_75460[(1)] = cljs.core.first((state_75439[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__75461 = state_75439;
state_75439 = G__75461;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$connection$state_machine__13883__auto__ = function(state_75439){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__13883__auto____1.call(this,state_75439);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__13883__auto____0;
fluree$db$connection$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__13883__auto____1;
return fluree$db$connection$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_75450 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_75450[(6)] = c__13957__auto___75454);

return statearr_75450;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq75419){
var G__75420 = cljs.core.first(seq75419);
var seq75419__$1 = cljs.core.next(seq75419);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__75420,seq75419__$1);
}));

