// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__38767 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38767,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38767,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38767,(2),null);
if(cljs.core.truth_((function (){var and__4149__auto__ = network;
if(cljs.core.truth_(and__4149__auto__)){
return maybe_alias;
} else {
return and__4149__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_ledger_DASH_name], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__38770){
var map__38771 = p__38770;
var map__38771__$1 = cljs.core.__destructure_map(map__38771);
var opts = map__38771__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38771__$1,cljs.core.cst$kw$reindex_QMARK_);
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_38828){
var state_val_38829 = (state_38828[(1)]);
if((state_val_38829 === (7))){
var inst_38804 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_38805 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_38806 = [cljs.core.cst$kw$db_SLASH_max_DASH_novelty_DASH_size,(400)];
var inst_38807 = cljs.core.PersistentHashMap.fromArrays(inst_38805,inst_38806);
var inst_38808 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38804,inst_38807);
var inst_38809 = (function(){throw inst_38808})();
var state_38828__$1 = state_38828;
var statearr_38830_38850 = state_38828__$1;
(statearr_38830_38850[(2)] = inst_38809);

(statearr_38830_38850[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38829 === (1))){
var state_38828__$1 = state_38828;
var statearr_38831_38851 = state_38828__$1;
(statearr_38831_38851[(2)] = null);

(statearr_38831_38851[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38829 === (4))){
var inst_38772 = (state_38828[(2)]);
var state_38828__$1 = state_38828;
var statearr_38832_38852 = state_38828__$1;
(statearr_38832_38852[(2)] = inst_38772);

(statearr_38832_38852[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38829 === (6))){
var inst_38786 = (state_38828[(7)]);
var inst_38792 = (state_38828[(8)]);
var inst_38785 = (state_38828[(2)]);
var inst_38786__$1 = fluree.db.util.async.throw_err(inst_38785);
var inst_38787 = cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(db);
var inst_38788 = cljs.core.__destructure_map(inst_38787);
var inst_38789 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38788,cljs.core.cst$kw$post);
var inst_38790 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38788,cljs.core.cst$kw$size);
var inst_38791 = fluree.db.flake.size_bytes(inst_38786__$1);
var inst_38792__$1 = (inst_38790 + inst_38791);
var inst_38793 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38794 = [cljs.core.cst$kw$conn,cljs.core.cst$kw$meta];
var inst_38795 = (new cljs.core.PersistentVector(null,2,(5),inst_38793,inst_38794,null));
var inst_38796 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_38795);
var inst_38797 = cljs.core.__destructure_map(inst_38796);
var inst_38798 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38797,cljs.core.cst$kw$novelty_DASH_min);
var inst_38799 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38797,cljs.core.cst$kw$novelty_DASH_max);
var inst_38800 = (inst_38792__$1 > inst_38799);
var inst_38801 = cljs.core.not(reindex_QMARK_);
var inst_38802 = ((inst_38800) && (inst_38801));
var state_38828__$1 = (function (){var statearr_38833 = state_38828;
(statearr_38833[(9)] = inst_38789);

(statearr_38833[(7)] = inst_38786__$1);

(statearr_38833[(8)] = inst_38792__$1);

(statearr_38833[(10)] = inst_38798);

return statearr_38833;
})();
if(cljs.core.truth_(inst_38802)){
var statearr_38834_38853 = state_38828__$1;
(statearr_38834_38853[(1)] = (7));

} else {
var statearr_38835_38854 = state_38828__$1;
(statearr_38835_38854[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38829 === (3))){
var inst_38826 = (state_38828[(2)]);
var state_38828__$1 = state_38828;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38828__$1,inst_38826);
} else {
if((state_val_38829 === (2))){
var _ = (function (){var statearr_38837 = state_38828;
(statearr_38837[(4)] = cljs.core.cons((5),(state_38828[(4)])));

return statearr_38837;
})();
var inst_38780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38781 = [pred_id];
var inst_38782 = (new cljs.core.PersistentVector(null,1,(5),inst_38780,inst_38781,null));
var inst_38783 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_38782);
var state_38828__$1 = state_38828;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38828__$1,(6),inst_38783);
} else {
if((state_val_38829 === (9))){
var inst_38789 = (state_38828[(9)]);
var inst_38786 = (state_38828[(7)]);
var inst_38792 = (state_38828[(8)]);
var inst_38812 = (state_38828[(2)]);
var inst_38813 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38789,inst_38786);
var inst_38814 = cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(db);
var inst_38815 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_38814,cljs.core.empty);
var inst_38816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38817 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_38818 = (new cljs.core.PersistentVector(null,2,(5),inst_38816,inst_38817,null));
var inst_38819 = cljs.core.assoc_in(db,inst_38818,inst_38813);
var inst_38820 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38821 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_38822 = (new cljs.core.PersistentVector(null,2,(5),inst_38820,inst_38821,null));
var inst_38823 = cljs.core.assoc_in(inst_38819,inst_38822,inst_38792);
var _ = (function (){var statearr_38838 = state_38828;
(statearr_38838[(4)] = cljs.core.rest((state_38828[(4)])));

return statearr_38838;
})();
var state_38828__$1 = (function (){var statearr_38839 = state_38828;
(statearr_38839[(11)] = inst_38815);

(statearr_38839[(12)] = inst_38812);

return statearr_38839;
})();
var statearr_38840_38855 = state_38828__$1;
(statearr_38840_38855[(2)] = inst_38823);

(statearr_38840_38855[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38829 === (5))){
var _ = (function (){var statearr_38841 = state_38828;
(statearr_38841[(4)] = cljs.core.rest((state_38828[(4)])));

return statearr_38841;
})();
var state_38828__$1 = state_38828;
var ex38836 = (state_38828__$1[(2)]);
var statearr_38842_38856 = state_38828__$1;
(statearr_38842_38856[(5)] = ex38836);


if((ex38836 instanceof Error)){
var statearr_38843_38857 = state_38828__$1;
(statearr_38843_38857[(1)] = (4));

(statearr_38843_38857[(5)] = null);

} else {
throw ex38836;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38829 === (8))){
var state_38828__$1 = state_38828;
var statearr_38844_38858 = state_38828__$1;
(statearr_38844_38858[(2)] = null);

(statearr_38844_38858[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto____0 = (function (){
var statearr_38845 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38845[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto__);

(statearr_38845[(1)] = (1));

return statearr_38845;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto____1 = (function (state_38828){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_38828);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e38846){var ex__13886__auto__ = e38846;
var statearr_38847_38859 = state_38828;
(statearr_38847_38859[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_38828[(4)]))){
var statearr_38848_38860 = state_38828;
(statearr_38848_38860[(1)] = cljs.core.first((state_38828[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__38861 = state_38828;
state_38828 = G__38861;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto__ = function(state_38828){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto____1.call(this,state_38828);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_38849 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_38849[(6)] = c__13957__auto__);

return statearr_38849;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__38866 = arguments.length;
switch (G__38866) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_39062){
var state_val_39063 = (state_39062[(1)]);
if((state_val_39063 === (7))){
var state_39062__$1 = state_39062;
var statearr_39064_39132 = state_39062__$1;
(statearr_39064_39132[(2)] = null);

(statearr_39064_39132[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (20))){
var inst_38988 = (state_39062[(7)]);
var inst_38984 = (state_39062[(8)]);
var inst_38986 = (state_39062[(9)]);
var inst_38955 = (state_39062[(10)]);
var inst_38987 = (state_39062[(11)]);
var inst_38985 = (state_39062[(12)]);
var inst_38904 = (state_39062[(13)]);
var inst_38905 = (state_39062[(14)]);
var inst_38998 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$size];
var inst_38999 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39000 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_39001 = (new cljs.core.PersistentVector(null,2,(5),inst_38999,inst_39000,null));
var inst_39002 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38955,inst_39001);
var inst_39003 = (inst_38904 + inst_39002);
var inst_39004 = [inst_38984,inst_38985,inst_38986,inst_38987,inst_39003];
var inst_39005 = cljs.core.PersistentHashMap.fromArrays(inst_38998,inst_39004);
var inst_39006 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_38955,cljs.core.cst$kw$ecount,inst_38988,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$novelty,inst_39005], 0));
var state_39062__$1 = (function (){var statearr_39065 = state_39062;
(statearr_39065[(15)] = inst_39006);

return statearr_39065;
})();
if(cljs.core.truth_(inst_38905)){
var statearr_39066_39133 = state_39062__$1;
(statearr_39066_39133[(1)] = (23));

} else {
var statearr_39067_39134 = state_39062__$1;
(statearr_39067_39134[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (27))){
var inst_39006 = (state_39062[(15)]);
var state_39062__$1 = state_39062;
var statearr_39068_39135 = state_39062__$1;
(statearr_39068_39135[(2)] = inst_39006);

(statearr_39068_39135[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (1))){
var state_39062__$1 = state_39062;
var statearr_39069_39136 = state_39062__$1;
(statearr_39069_39136[(2)] = null);

(statearr_39069_39136[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (24))){
var inst_39006 = (state_39062[(15)]);
var inst_39009 = cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(inst_39006);
var inst_39010 = (inst_39009 == null);
var state_39062__$1 = state_39062;
var statearr_39070_39137 = state_39062__$1;
(statearr_39070_39137[(2)] = inst_39010);

(statearr_39070_39137[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (39))){
var inst_38995 = (state_39062[(16)]);
var inst_39038 = (state_39062[(17)]);
var inst_39045 = (state_39062[(18)]);
var inst_39037 = (state_39062[(19)]);
var inst_39036 = (state_39062[(20)]);
var inst_39052 = (state_39062[(2)]);
var inst_38983 = inst_38995;
var inst_38984 = inst_39037;
var inst_38985 = inst_39038;
var inst_38986 = inst_39045;
var inst_38987 = inst_39052;
var inst_38988 = inst_39036;
var state_39062__$1 = (function (){var statearr_39071 = state_39062;
(statearr_39071[(21)] = inst_38983);

(statearr_39071[(7)] = inst_38988);

(statearr_39071[(8)] = inst_38984);

(statearr_39071[(9)] = inst_38986);

(statearr_39071[(11)] = inst_38987);

(statearr_39071[(12)] = inst_38985);

return statearr_39071;
})();
var statearr_39072_39138 = state_39062__$1;
(statearr_39072_39138[(2)] = null);

(statearr_39072_39138[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (4))){
var inst_38867 = (state_39062[(2)]);
var state_39062__$1 = state_39062;
var statearr_39073_39139 = state_39062__$1;
(statearr_39073_39139[(2)] = inst_38867);

(statearr_39073_39139[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (15))){
var inst_38927 = (state_39062[(22)]);
var state_39062__$1 = state_39062;
var statearr_39074_39140 = state_39062__$1;
(statearr_39074_39140[(2)] = inst_38927);

(statearr_39074_39140[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (21))){
var inst_38983 = (state_39062[(21)]);
var inst_38988 = (state_39062[(7)]);
var inst_38874 = (state_39062[(23)]);
var inst_38908 = (state_39062[(24)]);
var inst_38889 = (state_39062[(25)]);
var inst_38964 = (state_39062[(26)]);
var inst_38984 = (state_39062[(8)]);
var inst_38891 = (state_39062[(27)]);
var inst_38986 = (state_39062[(9)]);
var inst_38955 = (state_39062[(10)]);
var inst_38995 = (state_39062[(16)]);
var inst_38906 = (state_39062[(28)]);
var inst_38994 = (state_39062[(29)]);
var inst_38987 = (state_39062[(11)]);
var inst_38985 = (state_39062[(12)]);
var inst_38904 = (state_39062[(13)]);
var inst_38903 = (state_39062[(30)]);
var inst_38899 = (state_39062[(31)]);
var inst_38914 = (state_39062[(32)]);
var inst_38905 = (state_39062[(14)]);
var inst_38965 = (state_39062[(33)]);
var inst_38895 = (state_39062[(34)]);
var inst_39033 = inst_38994.s;
var inst_39034 = fluree.db.flake.sid__GT_cid(inst_39033);
var inst_39035 = (function (){var flakes_bytes = inst_38904;
var t = inst_38874;
var spot = inst_38984;
var add_flakes = inst_38891;
var G__38959 = inst_38983;
var root_setting_change_QMARK_ = inst_38906;
var ref_QMARK__map = inst_38903;
var r = inst_38995;
var seq__38961 = inst_38965;
var psot = inst_38985;
var add_pred_to_idx_QMARK_ = inst_38914;
var _ = inst_38889;
var cid = inst_39034;
var ecount = inst_38988;
var pred_ecount = inst_38908;
var seq__38991 = inst_38995;
var db_STAR_ = inst_38955;
var schema_change_QMARK_ = inst_38905;
var add_preds = inst_38895;
var opst = inst_38987;
var first__38962 = inst_38964;
var first__38992 = inst_38994;
var idx_QMARK__map = inst_38899;
var vec__38990 = inst_38983;
var post = inst_38986;
var vec__38960 = inst_38891;
var f = inst_38994;
return (function (p1__38864_SHARP_){
if(cljs.core.truth_(p1__38864_SHARP_)){
var x__4249__auto__ = p1__38864_SHARP_;
var y__4250__auto__ = f.s;
return ((x__4249__auto__ > y__4250__auto__) ? x__4249__auto__ : y__4250__auto__);
} else {
return f.s;
}
});
})();
var inst_39036 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_38988,inst_39034,inst_39035);
var inst_39037 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38984,inst_38994);
var inst_39038 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38985,inst_38994);
var inst_39039 = inst_38994.p;
var inst_39040 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38899,inst_39039);
var state_39062__$1 = (function (){var statearr_39075 = state_39062;
(statearr_39075[(17)] = inst_39038);

(statearr_39075[(19)] = inst_39037);

(statearr_39075[(20)] = inst_39036);

return statearr_39075;
})();
if(cljs.core.truth_(inst_39040)){
var statearr_39076_39141 = state_39062__$1;
(statearr_39076_39141[(1)] = (34));

} else {
var statearr_39077_39142 = state_39062__$1;
(statearr_39077_39142[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (31))){
var inst_39021 = (state_39062[(35)]);
var state_39062__$1 = state_39062;
var statearr_39078_39143 = state_39062__$1;
(statearr_39078_39143[(2)] = inst_39021);

(statearr_39078_39143[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (32))){
var inst_39031 = (state_39062[(2)]);
var state_39062__$1 = state_39062;
var statearr_39079_39144 = state_39062__$1;
(statearr_39079_39144[(2)] = inst_39031);

(statearr_39079_39144[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (33))){
var inst_39021 = (state_39062[(35)]);
var inst_39026 = (state_39062[(2)]);
var inst_39027 = fluree.db.util.async.throw_err(inst_39026);
var inst_39028 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39021,cljs.core.cst$kw$settings,inst_39027);
var state_39062__$1 = state_39062;
var statearr_39080_39145 = state_39062__$1;
(statearr_39080_39145[(2)] = inst_39028);

(statearr_39080_39145[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (13))){
var inst_38874 = (state_39062[(23)]);
var inst_38891 = (state_39062[(27)]);
var inst_38955 = (state_39062[(10)]);
var inst_38904 = (state_39062[(13)]);
var inst_38945 = (state_39062[(2)]);
var inst_38946 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38945,cljs.core.cst$kw$t,inst_38874);
var inst_38947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38948 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$size];
var inst_38949 = (new cljs.core.PersistentVector(null,2,(5),inst_38947,inst_38948,null));
var inst_38950 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_38946,inst_38949,cljs.core._PLUS_,inst_38904);
var inst_38951 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38952 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$flakes];
var inst_38953 = (new cljs.core.PersistentVector(null,2,(5),inst_38951,inst_38952,null));
var inst_38954 = cljs.core.count(inst_38891);
var inst_38955__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_38950,inst_38953,cljs.core._PLUS_,inst_38954);
var inst_38963 = cljs.core.seq(inst_38891);
var inst_38964 = cljs.core.first(inst_38963);
var inst_38965 = cljs.core.next(inst_38963);
var inst_38966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38967 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$spot];
var inst_38968 = (new cljs.core.PersistentVector(null,2,(5),inst_38966,inst_38967,null));
var inst_38969 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38955__$1,inst_38968);
var inst_38970 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38971 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$psot];
var inst_38972 = (new cljs.core.PersistentVector(null,2,(5),inst_38970,inst_38971,null));
var inst_38973 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38955__$1,inst_38972);
var inst_38974 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38975 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_38976 = (new cljs.core.PersistentVector(null,2,(5),inst_38974,inst_38975,null));
var inst_38977 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38955__$1,inst_38976);
var inst_38978 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38979 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$opst];
var inst_38980 = (new cljs.core.PersistentVector(null,2,(5),inst_38978,inst_38979,null));
var inst_38981 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38955__$1,inst_38980);
var inst_38982 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_38983 = inst_38891;
var inst_38984 = inst_38969;
var inst_38985 = inst_38973;
var inst_38986 = inst_38977;
var inst_38987 = inst_38981;
var inst_38988 = inst_38982;
var state_39062__$1 = (function (){var statearr_39081 = state_39062;
(statearr_39081[(21)] = inst_38983);

(statearr_39081[(7)] = inst_38988);

(statearr_39081[(26)] = inst_38964);

(statearr_39081[(8)] = inst_38984);

(statearr_39081[(9)] = inst_38986);

(statearr_39081[(10)] = inst_38955__$1);

(statearr_39081[(11)] = inst_38987);

(statearr_39081[(12)] = inst_38985);

(statearr_39081[(33)] = inst_38965);

return statearr_39081;
})();
var statearr_39082_39146 = state_39062__$1;
(statearr_39082_39146[(2)] = null);

(statearr_39082_39146[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (22))){
var inst_39055 = (state_39062[(2)]);
var state_39062__$1 = state_39062;
var statearr_39083_39147 = state_39062__$1;
(statearr_39083_39147[(2)] = inst_39055);

(statearr_39083_39147[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (36))){
var inst_38994 = (state_39062[(29)]);
var inst_38903 = (state_39062[(30)]);
var inst_39045 = (state_39062[(2)]);
var inst_39046 = inst_38994.p;
var inst_39047 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38903,inst_39046);
var state_39062__$1 = (function (){var statearr_39084 = state_39062;
(statearr_39084[(18)] = inst_39045);

return statearr_39084;
})();
if(cljs.core.truth_(inst_39047)){
var statearr_39085_39148 = state_39062__$1;
(statearr_39085_39148[(1)] = (37));

} else {
var statearr_39086_39149 = state_39062__$1;
(statearr_39086_39149[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (29))){
var inst_39006 = (state_39062[(15)]);
var inst_39016 = (state_39062[(2)]);
var inst_39017 = fluree.db.util.async.throw_err(inst_39016);
var inst_39018 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39006,cljs.core.cst$kw$schema,inst_39017);
var state_39062__$1 = state_39062;
var statearr_39087_39150 = state_39062__$1;
(statearr_39087_39150[(2)] = inst_39018);

(statearr_39087_39150[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (6))){
var inst_38874 = (state_39062[(23)]);
var inst_38879 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_38880 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_38881 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38879)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38880)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38874),"."].join('');
var inst_38882 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38883 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_38884 = cljs.core.PersistentHashMap.fromArrays(inst_38882,inst_38883);
var inst_38885 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38881,inst_38884);
var inst_38886 = (function(){throw inst_38885})();
var state_39062__$1 = state_39062;
var statearr_39088_39151 = state_39062__$1;
(statearr_39088_39151[(2)] = inst_38886);

(statearr_39088_39151[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (28))){
var inst_38906 = (state_39062[(28)]);
var inst_39021 = (state_39062[(2)]);
var state_39062__$1 = (function (){var statearr_39089 = state_39062;
(statearr_39089[(35)] = inst_39021);

return statearr_39089;
})();
if(cljs.core.truth_(inst_38906)){
var statearr_39090_39152 = state_39062__$1;
(statearr_39090_39152[(1)] = (30));

} else {
var statearr_39091_39153 = state_39062__$1;
(statearr_39091_39153[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (25))){
var inst_39012 = (state_39062[(2)]);
var state_39062__$1 = state_39062;
if(cljs.core.truth_(inst_39012)){
var statearr_39092_39154 = state_39062__$1;
(statearr_39092_39154[(1)] = (26));

} else {
var statearr_39093_39155 = state_39062__$1;
(statearr_39093_39155[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (34))){
var inst_38986 = (state_39062[(9)]);
var inst_38994 = (state_39062[(29)]);
var inst_39042 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38986,inst_38994);
var state_39062__$1 = state_39062;
var statearr_39094_39156 = state_39062__$1;
(statearr_39094_39156[(2)] = inst_39042);

(statearr_39094_39156[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (17))){
var inst_38934 = (state_39062[(36)]);
var inst_38938 = (state_39062[(2)]);
var inst_38939 = fluree.db.util.async.throw_err(inst_38938);
var inst_38926 = inst_38934;
var inst_38927 = inst_38939;
var state_39062__$1 = (function (){var statearr_39095 = state_39062;
(statearr_39095[(37)] = inst_38926);

(statearr_39095[(22)] = inst_38927);

return statearr_39095;
})();
var statearr_39096_39157 = state_39062__$1;
(statearr_39096_39157[(2)] = null);

(statearr_39096_39157[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (3))){
var inst_39060 = (state_39062[(2)]);
var state_39062__$1 = state_39062;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39062__$1,inst_39060);
} else {
if((state_val_39063 === (12))){
var inst_38926 = (state_39062[(37)]);
var inst_38933 = (state_39062[(38)]);
var inst_38932 = cljs.core.seq(inst_38926);
var inst_38933__$1 = cljs.core.first(inst_38932);
var inst_38934 = cljs.core.next(inst_38932);
var state_39062__$1 = (function (){var statearr_39097 = state_39062;
(statearr_39097[(36)] = inst_38934);

(statearr_39097[(38)] = inst_38933__$1);

return statearr_39097;
})();
if(cljs.core.truth_(inst_38933__$1)){
var statearr_39098_39158 = state_39062__$1;
(statearr_39098_39158[(1)] = (14));

} else {
var statearr_39099_39159 = state_39062__$1;
(statearr_39099_39159[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (2))){
var inst_38874 = (state_39062[(23)]);
var _ = (function (){var statearr_39100 = state_39062;
(statearr_39100[(4)] = cljs.core.cons((5),(state_39062[(4)])));

return statearr_39100;
})();
var inst_38873 = cljs.core.first(flakes);
var inst_38874__$1 = inst_38873.t;
var inst_38875 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_38876 = (inst_38875 - (1));
var inst_38877 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_38874__$1,inst_38876);
var state_39062__$1 = (function (){var statearr_39101 = state_39062;
(statearr_39101[(23)] = inst_38874__$1);

return statearr_39101;
})();
if(inst_38877){
var statearr_39102_39160 = state_39062__$1;
(statearr_39102_39160[(1)] = (6));

} else {
var statearr_39103_39161 = state_39062__$1;
(statearr_39103_39161[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (23))){
var inst_38905 = (state_39062[(14)]);
var state_39062__$1 = state_39062;
var statearr_39104_39162 = state_39062__$1;
(statearr_39104_39162[(2)] = inst_38905);

(statearr_39104_39162[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (35))){
var inst_38986 = (state_39062[(9)]);
var state_39062__$1 = state_39062;
var statearr_39105_39163 = state_39062__$1;
(statearr_39105_39163[(2)] = inst_38986);

(statearr_39105_39163[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (19))){
var inst_39057 = (state_39062[(2)]);
var _ = (function (){var statearr_39106 = state_39062;
(statearr_39106[(4)] = cljs.core.rest((state_39062[(4)])));

return statearr_39106;
})();
var state_39062__$1 = state_39062;
var statearr_39107_39164 = state_39062__$1;
(statearr_39107_39164[(2)] = inst_39057);

(statearr_39107_39164[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (11))){
var inst_38914 = (state_39062[(32)]);
var inst_38914__$1 = (state_39062[(2)]);
var inst_38922 = cljs.core.seq(inst_38914__$1);
var inst_38923 = cljs.core.first(inst_38922);
var inst_38924 = cljs.core.next(inst_38922);
var inst_38925 = db;
var inst_38926 = inst_38914__$1;
var inst_38927 = inst_38925;
var state_39062__$1 = (function (){var statearr_39109 = state_39062;
(statearr_39109[(37)] = inst_38926);

(statearr_39109[(39)] = inst_38923);

(statearr_39109[(22)] = inst_38927);

(statearr_39109[(32)] = inst_38914__$1);

(statearr_39109[(40)] = inst_38924);

return statearr_39109;
})();
var statearr_39110_39165 = state_39062__$1;
(statearr_39110_39165[(2)] = null);

(statearr_39110_39165[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (9))){
var inst_38908 = (state_39062[(24)]);
var inst_38891 = (state_39062[(27)]);
var inst_38910 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_38891,inst_38908);
var state_39062__$1 = state_39062;
var statearr_39111_39166 = state_39062__$1;
(statearr_39111_39166[(2)] = inst_38910);

(statearr_39111_39166[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (5))){
var _ = (function (){var statearr_39112 = state_39062;
(statearr_39112[(4)] = cljs.core.rest((state_39062[(4)])));

return statearr_39112;
})();
var state_39062__$1 = state_39062;
var ex39108 = (state_39062__$1[(2)]);
var statearr_39113_39167 = state_39062__$1;
(statearr_39113_39167[(5)] = ex39108);


if((ex39108 instanceof Error)){
var statearr_39114_39168 = state_39062__$1;
(statearr_39114_39168[(1)] = (4));

(statearr_39114_39168[(5)] = null);

} else {
throw ex39108;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (14))){
var inst_38927 = (state_39062[(22)]);
var inst_38933 = (state_39062[(38)]);
var inst_38936 = fluree.db.graphdb.add_predicate_to_idx(inst_38927,inst_38933,opts);
var state_39062__$1 = state_39062;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39062__$1,(17),inst_38936);
} else {
if((state_val_39063 === (26))){
var inst_39006 = (state_39062[(15)]);
var inst_39014 = fluree.db.query.schema.schema_map(inst_39006);
var state_39062__$1 = state_39062;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39062__$1,(29),inst_39014);
} else {
if((state_val_39063 === (16))){
var inst_38943 = (state_39062[(2)]);
var state_39062__$1 = state_39062;
var statearr_39115_39169 = state_39062__$1;
(statearr_39115_39169[(2)] = inst_38943);

(statearr_39115_39169[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (38))){
var inst_38987 = (state_39062[(11)]);
var state_39062__$1 = state_39062;
var statearr_39116_39170 = state_39062__$1;
(statearr_39116_39170[(2)] = inst_38987);

(statearr_39116_39170[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (30))){
var inst_39021 = (state_39062[(35)]);
var inst_39024 = fluree.db.query.schema.setting_map(inst_39021);
var state_39062__$1 = state_39062;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39062__$1,(33),inst_39024);
} else {
if((state_val_39063 === (10))){
var inst_38912 = cljs.core.PersistentVector.EMPTY;
var state_39062__$1 = state_39062;
var statearr_39117_39171 = state_39062__$1;
(statearr_39117_39171[(2)] = inst_38912);

(statearr_39117_39171[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (18))){
var inst_38983 = (state_39062[(21)]);
var inst_38994 = (state_39062[(29)]);
var inst_38993 = cljs.core.seq(inst_38983);
var inst_38994__$1 = cljs.core.first(inst_38993);
var inst_38995 = cljs.core.next(inst_38993);
var inst_38996 = cljs.core.not(inst_38994__$1);
var state_39062__$1 = (function (){var statearr_39118 = state_39062;
(statearr_39118[(16)] = inst_38995);

(statearr_39118[(29)] = inst_38994__$1);

return statearr_39118;
})();
if(inst_38996){
var statearr_39119_39172 = state_39062__$1;
(statearr_39119_39172[(1)] = (20));

} else {
var statearr_39120_39173 = state_39062__$1;
(statearr_39120_39173[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (37))){
var inst_38994 = (state_39062[(29)]);
var inst_38987 = (state_39062[(11)]);
var inst_39049 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38987,inst_38994);
var state_39062__$1 = state_39062;
var statearr_39121_39174 = state_39062__$1;
(statearr_39121_39174[(2)] = inst_39049);

(statearr_39121_39174[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39063 === (8))){
var inst_38874 = (state_39062[(23)]);
var inst_38889 = (state_39062[(25)]);
var inst_38891 = (state_39062[(27)]);
var inst_38899 = (state_39062[(31)]);
var inst_38905 = (state_39062[(14)]);
var inst_38895 = (state_39062[(34)]);
var inst_38889__$1 = (state_39062[(2)]);
var inst_38890 = (function (){var t = inst_38874;
var _ = inst_38889__$1;
return (function (p1__38862_SHARP_){
return cljs.core.not((function (){var G__39122 = p1__38862_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__39122) : fluree.db.graphdb.exclude_predicates.call(null,G__39122));
})());
});
})();
var inst_38891__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_38890,flakes);
var inst_38892 = cljs.core.PersistentHashSet.EMPTY;
var inst_38893 = (function (){var t = inst_38874;
var _ = inst_38889__$1;
var add_flakes = inst_38891__$1;
return (function (p1__38863_SHARP_){
return p1__38863_SHARP_.p;
});
})();
var inst_38894 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_38893,inst_38891__$1);
var inst_38895__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38892,inst_38894);
var inst_38896 = cljs.core.PersistentHashMap.EMPTY;
var inst_38897 = (function (){var t = inst_38874;
var _ = inst_38889__$1;
var add_flakes = inst_38891__$1;
var add_preds = inst_38895__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p)], null);
});
})();
var inst_38898 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_38897,inst_38895__$1);
var inst_38899__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38896,inst_38898);
var inst_38900 = cljs.core.PersistentHashMap.EMPTY;
var inst_38901 = (function (){var t = inst_38874;
var _ = inst_38889__$1;
var add_flakes = inst_38891__$1;
var add_preds = inst_38895__$1;
var idx_QMARK__map = inst_38899__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p)], null);
});
})();
var inst_38902 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_38901,inst_38895__$1);
var inst_38903 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38900,inst_38902);
var inst_38904 = fluree.db.flake.size_bytes(inst_38891__$1);
var inst_38905__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_38891__$1);
var inst_38906 = fluree.db.util.schema.setting_change_QMARK_(inst_38891__$1);
var inst_38907 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_38908 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38907,(0));
var state_39062__$1 = (function (){var statearr_39123 = state_39062;
(statearr_39123[(24)] = inst_38908);

(statearr_39123[(25)] = inst_38889__$1);

(statearr_39123[(27)] = inst_38891__$1);

(statearr_39123[(28)] = inst_38906);

(statearr_39123[(13)] = inst_38904);

(statearr_39123[(30)] = inst_38903);

(statearr_39123[(31)] = inst_38899__$1);

(statearr_39123[(14)] = inst_38905__$1);

(statearr_39123[(34)] = inst_38895__$1);

return statearr_39123;
})();
if(cljs.core.truth_(inst_38905__$1)){
var statearr_39124_39175 = state_39062__$1;
(statearr_39124_39175[(1)] = (9));

} else {
var statearr_39125_39176 = state_39062__$1;
(statearr_39125_39176[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__13883__auto__ = null;
var fluree$db$graphdb$state_machine__13883__auto____0 = (function (){
var statearr_39126 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39126[(0)] = fluree$db$graphdb$state_machine__13883__auto__);

(statearr_39126[(1)] = (1));

return statearr_39126;
});
var fluree$db$graphdb$state_machine__13883__auto____1 = (function (state_39062){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_39062);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e39127){var ex__13886__auto__ = e39127;
var statearr_39128_39177 = state_39062;
(statearr_39128_39177[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_39062[(4)]))){
var statearr_39129_39178 = state_39062;
(statearr_39129_39178[(1)] = cljs.core.first((state_39062[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__39179 = state_39062;
state_39062 = G__39179;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__13883__auto__ = function(state_39062){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__13883__auto____1.call(this,state_39062);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__13883__auto____0;
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__13883__auto____1;
return fluree$db$graphdb$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_39130 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_39130[(6)] = c__13957__auto__);

return statearr_39130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__39181 = arguments.length;
switch (G__39181) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__13957__auto___39328 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_39277){
var state_val_39278 = (state_39277[(1)]);
if((state_val_39278 === (7))){
var state_39277__$1 = state_39277;
var statearr_39279_39329 = state_39277__$1;
(statearr_39279_39329[(2)] = null);

(statearr_39279_39329[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (20))){
var inst_39227 = (state_39277[(7)]);
var inst_39225 = (state_39277[(8)]);
var inst_39226 = (state_39277[(9)]);
var inst_39246 = (inst_39225 + (1));
var inst_39247 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39227,cljs.core.cst$kw$t,inst_39246);
var inst_39248 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_39247,inst_39226,opts);
var state_39277__$1 = state_39277;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39277__$1,(23),inst_39248);
} else {
if((state_val_39278 === (1))){
var state_39277__$1 = state_39277;
var statearr_39280_39330 = state_39277__$1;
(statearr_39280_39330[(2)] = null);

(statearr_39280_39330[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (24))){
var inst_39251 = (state_39277[(10)]);
var inst_39254 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39251,cljs.core.cst$kw$block,block);
var state_39277__$1 = state_39277;
var statearr_39281_39331 = state_39277__$1;
(statearr_39281_39331[(2)] = inst_39254);

(statearr_39281_39331[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (4))){
var inst_39182 = (state_39277[(2)]);
var inst_39183 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_39182);
var state_39277__$1 = state_39277;
var statearr_39282_39332 = state_39277__$1;
(statearr_39282_39332[(2)] = inst_39183);

(statearr_39282_39332[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (15))){
var inst_39233 = (state_39277[(11)]);
var state_39277__$1 = state_39277;
var statearr_39283_39333 = state_39277__$1;
(statearr_39283_39333[(2)] = inst_39233);

(statearr_39283_39333[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (21))){
var state_39277__$1 = state_39277;
var statearr_39284_39334 = state_39277__$1;
(statearr_39284_39334[(2)] = null);

(statearr_39284_39334[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (13))){
var inst_39269 = (state_39277[(2)]);
var inst_39270 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_39269);
var state_39277__$1 = state_39277;
var statearr_39285_39335 = state_39277__$1;
(statearr_39285_39335[(2)] = inst_39270);

(statearr_39285_39335[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (22))){
var inst_39265 = (state_39277[(2)]);
var state_39277__$1 = state_39277;
var statearr_39286_39336 = state_39277__$1;
(statearr_39286_39336[(2)] = inst_39265);

(statearr_39286_39336[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (6))){
var inst_39193 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_39194 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_39195 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39193)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39194)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_39196 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39197 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_39198 = cljs.core.PersistentHashMap.fromArrays(inst_39196,inst_39197);
var inst_39199 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39195,inst_39198);
var inst_39200 = (function(){throw inst_39199})();
var state_39277__$1 = state_39277;
var statearr_39289_39337 = state_39277__$1;
(statearr_39289_39337[(2)] = inst_39200);

(statearr_39289_39337[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (25))){
var inst_39234 = (state_39277[(12)]);
var inst_39233 = (state_39277[(11)]);
var inst_39251 = (state_39277[(10)]);
var inst_39256 = inst_39233.t;
var inst_39257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39258 = [inst_39233];
var inst_39259 = (new cljs.core.PersistentVector(null,1,(5),inst_39257,inst_39258,null));
var inst_39224 = inst_39234;
var inst_39225 = inst_39256;
var inst_39226 = inst_39259;
var inst_39227 = inst_39251;
var state_39277__$1 = (function (){var statearr_39290 = state_39277;
(statearr_39290[(7)] = inst_39227);

(statearr_39290[(8)] = inst_39225);

(statearr_39290[(9)] = inst_39226);

(statearr_39290[(13)] = inst_39224);

return statearr_39290;
})();
var statearr_39291_39338 = state_39277__$1;
(statearr_39291_39338[(2)] = null);

(statearr_39291_39338[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (17))){
var inst_39234 = (state_39277[(12)]);
var inst_39233 = (state_39277[(11)]);
var inst_39227 = (state_39277[(7)]);
var inst_39225 = (state_39277[(8)]);
var inst_39226 = (state_39277[(9)]);
var inst_39242 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39226,inst_39233);
var tmp39287 = inst_39227;
var tmp39288 = inst_39225;
var inst_39224 = inst_39234;
var inst_39225__$1 = tmp39288;
var inst_39226__$1 = inst_39242;
var inst_39227__$1 = tmp39287;
var state_39277__$1 = (function (){var statearr_39292 = state_39277;
(statearr_39292[(7)] = inst_39227__$1);

(statearr_39292[(8)] = inst_39225__$1);

(statearr_39292[(9)] = inst_39226__$1);

(statearr_39292[(13)] = inst_39224);

return statearr_39292;
})();
var statearr_39293_39339 = state_39277__$1;
(statearr_39293_39339[(2)] = null);

(statearr_39293_39339[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (3))){
var inst_39275 = (state_39277[(2)]);
var state_39277__$1 = state_39277;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39277__$1,inst_39275);
} else {
if((state_val_39278 === (12))){
var inst_39233 = (state_39277[(11)]);
var inst_39224 = (state_39277[(13)]);
var inst_39232 = cljs.core.seq(inst_39224);
var inst_39233__$1 = cljs.core.first(inst_39232);
var inst_39234 = cljs.core.next(inst_39232);
var state_39277__$1 = (function (){var statearr_39294 = state_39277;
(statearr_39294[(12)] = inst_39234);

(statearr_39294[(11)] = inst_39233__$1);

return statearr_39294;
})();
if(cljs.core.truth_(inst_39233__$1)){
var statearr_39295_39340 = state_39277__$1;
(statearr_39295_39340[(1)] = (14));

} else {
var statearr_39296_39341 = state_39277__$1;
(statearr_39296_39341[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (2))){
var _ = (function (){var statearr_39297 = state_39277;
(statearr_39297[(4)] = cljs.core.cons((5),(state_39277[(4)])));

return statearr_39297;
})();
var inst_39189 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_39190 = (inst_39189 + (1));
var inst_39191 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_39190);
var state_39277__$1 = state_39277;
if(inst_39191){
var statearr_39298_39342 = state_39277__$1;
(statearr_39298_39342[(1)] = (6));

} else {
var statearr_39299_39343 = state_39277__$1;
(statearr_39299_39343[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (23))){
var inst_39233 = (state_39277[(11)]);
var inst_39250 = (state_39277[(2)]);
var inst_39251 = fluree.db.util.async.throw_err(inst_39250);
var inst_39252 = (inst_39233 == null);
var state_39277__$1 = (function (){var statearr_39300 = state_39277;
(statearr_39300[(10)] = inst_39251);

return statearr_39300;
})();
if(cljs.core.truth_(inst_39252)){
var statearr_39301_39344 = state_39277__$1;
(statearr_39301_39344[(1)] = (24));

} else {
var statearr_39302_39345 = state_39277__$1;
(statearr_39302_39345[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (19))){
var inst_39267 = (state_39277[(2)]);
var state_39277__$1 = state_39277;
var statearr_39303_39346 = state_39277__$1;
(statearr_39303_39346[(2)] = inst_39267);

(statearr_39303_39346[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (11))){
var inst_39272 = (state_39277[(2)]);
var _ = (function (){var statearr_39305 = state_39277;
(statearr_39305[(4)] = cljs.core.rest((state_39277[(4)])));

return statearr_39305;
})();
var state_39277__$1 = state_39277;
var statearr_39306_39347 = state_39277__$1;
(statearr_39306_39347[(2)] = inst_39272);

(statearr_39306_39347[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (9))){
var inst_39206 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$block,block);
var inst_39207 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_39206);
var state_39277__$1 = state_39277;
var statearr_39307_39348 = state_39277__$1;
(statearr_39307_39348[(2)] = inst_39207);

(statearr_39307_39348[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (5))){
var _ = (function (){var statearr_39308 = state_39277;
(statearr_39308[(4)] = cljs.core.rest((state_39277[(4)])));

return statearr_39308;
})();
var state_39277__$1 = state_39277;
var ex39304 = (state_39277__$1[(2)]);
var statearr_39309_39349 = state_39277__$1;
(statearr_39309_39349[(5)] = ex39304);


var statearr_39310_39350 = state_39277__$1;
(statearr_39310_39350[(1)] = (4));

(statearr_39310_39350[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (14))){
var inst_39233 = (state_39277[(11)]);
var inst_39225 = (state_39277[(8)]);
var inst_39236 = inst_39233.t;
var inst_39237 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_39225,inst_39236);
var state_39277__$1 = state_39277;
var statearr_39311_39351 = state_39277__$1;
(statearr_39311_39351[(2)] = inst_39237);

(statearr_39311_39351[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (26))){
var inst_39262 = (state_39277[(2)]);
var state_39277__$1 = state_39277;
var statearr_39312_39352 = state_39277__$1;
(statearr_39312_39352[(2)] = inst_39262);

(statearr_39312_39352[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (16))){
var inst_39240 = (state_39277[(2)]);
var state_39277__$1 = state_39277;
if(cljs.core.truth_(inst_39240)){
var statearr_39313_39353 = state_39277__$1;
(statearr_39313_39353[(1)] = (17));

} else {
var statearr_39314_39354 = state_39277__$1;
(statearr_39314_39354[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (10))){
var inst_39209 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_39217 = cljs.core.seq(inst_39209);
var inst_39218 = cljs.core.first(inst_39217);
var inst_39219 = cljs.core.next(inst_39217);
var inst_39220 = cljs.core.first(inst_39209);
var inst_39221 = inst_39220.t;
var inst_39222 = cljs.core.PersistentVector.EMPTY;
var inst_39223 = db;
var inst_39224 = inst_39209;
var inst_39225 = inst_39221;
var inst_39226 = inst_39222;
var inst_39227 = inst_39223;
var state_39277__$1 = (function (){var statearr_39315 = state_39277;
(statearr_39315[(14)] = inst_39219);

(statearr_39315[(7)] = inst_39227);

(statearr_39315[(8)] = inst_39225);

(statearr_39315[(9)] = inst_39226);

(statearr_39315[(15)] = inst_39218);

(statearr_39315[(13)] = inst_39224);

return statearr_39315;
})();
var statearr_39316_39355 = state_39277__$1;
(statearr_39316_39355[(2)] = null);

(statearr_39316_39355[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (18))){
var state_39277__$1 = state_39277;
var statearr_39317_39356 = state_39277__$1;
(statearr_39317_39356[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39278 === (8))){
var inst_39203 = (state_39277[(2)]);
var inst_39204 = cljs.core.empty_QMARK_(flakes);
var state_39277__$1 = (function (){var statearr_39319 = state_39277;
(statearr_39319[(16)] = inst_39203);

return statearr_39319;
})();
if(inst_39204){
var statearr_39320_39357 = state_39277__$1;
(statearr_39320_39357[(1)] = (9));

} else {
var statearr_39321_39358 = state_39277__$1;
(statearr_39321_39358[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__13883__auto__ = null;
var fluree$db$graphdb$state_machine__13883__auto____0 = (function (){
var statearr_39322 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39322[(0)] = fluree$db$graphdb$state_machine__13883__auto__);

(statearr_39322[(1)] = (1));

return statearr_39322;
});
var fluree$db$graphdb$state_machine__13883__auto____1 = (function (state_39277){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_39277);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e39323){var ex__13886__auto__ = e39323;
var statearr_39324_39359 = state_39277;
(statearr_39324_39359[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_39277[(4)]))){
var statearr_39325_39360 = state_39277;
(statearr_39325_39360[(1)] = cljs.core.first((state_39277[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__39361 = state_39277;
state_39277 = G__39361;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__13883__auto__ = function(state_39277){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__13883__auto____1.call(this,state_39277);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__13883__auto____0;
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__13883__auto____1;
return fluree$db$graphdb$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_39326 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_39326[(6)] = c__13957__auto___39328);

return statearr_39326;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_39417){
var state_val_39418 = (state_39417[(1)]);
if((state_val_39418 === (7))){
var state_39417__$1 = state_39417;
var statearr_39419_39446 = state_39417__$1;
(statearr_39419_39446[(2)] = tt_id);

(statearr_39419_39446[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39418 === (1))){
var state_39417__$1 = state_39417;
var statearr_39420_39447 = state_39417__$1;
(statearr_39420_39447[(2)] = null);

(statearr_39420_39447[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39418 === (4))){
var inst_39362 = (state_39417[(2)]);
var state_39417__$1 = state_39417;
var statearr_39421_39448 = state_39417__$1;
(statearr_39421_39448[(2)] = inst_39362);

(statearr_39421_39448[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39418 === (13))){
var inst_39410 = (state_39417[(2)]);
var state_39417__$1 = state_39417;
var statearr_39422_39449 = state_39417__$1;
(statearr_39422_39449[(2)] = inst_39410);

(statearr_39422_39449[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39418 === (6))){
var inst_39370 = fluree.db.util.core.random_uuid();
var state_39417__$1 = state_39417;
var statearr_39423_39450 = state_39417__$1;
(statearr_39423_39450[(2)] = inst_39370);

(statearr_39423_39450[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39418 === (3))){
var inst_39415 = (state_39417[(2)]);
var state_39417__$1 = state_39417;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39417__$1,inst_39415);
} else {
if((state_val_39418 === (12))){
var inst_39393 = (state_39417[(7)]);
var state_39417__$1 = state_39417;
var statearr_39424_39451 = state_39417__$1;
(statearr_39424_39451[(2)] = inst_39393);

(statearr_39424_39451[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39418 === (2))){
var _ = (function (){var statearr_39425 = state_39417;
(statearr_39425[(4)] = cljs.core.cons((5),(state_39417[(4)])));

return statearr_39425;
})();
var inst_39368 = (tt_id == null);
var state_39417__$1 = state_39417;
if(cljs.core.truth_(inst_39368)){
var statearr_39426_39452 = state_39417__$1;
(statearr_39426_39452[(1)] = (6));

} else {
var statearr_39427_39453 = state_39417__$1;
(statearr_39427_39453[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39418 === (11))){
var inst_39400 = (state_39417[(8)]);
var inst_39393 = (state_39417[(7)]);
var inst_39403 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_39393,inst_39400);
var state_39417__$1 = state_39417;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39417__$1,(14),inst_39403);
} else {
if((state_val_39418 === (9))){
var inst_39400 = (state_39417[(8)]);
var inst_39394 = (state_39417[(9)]);
var inst_39399 = cljs.core.seq(inst_39394);
var inst_39400__$1 = cljs.core.first(inst_39399);
var inst_39401 = cljs.core.next(inst_39399);
var state_39417__$1 = (function (){var statearr_39429 = state_39417;
(statearr_39429[(10)] = inst_39401);

(statearr_39429[(8)] = inst_39400__$1);

return statearr_39429;
})();
if(cljs.core.truth_(inst_39400__$1)){
var statearr_39430_39454 = state_39417__$1;
(statearr_39430_39454[(1)] = (11));

} else {
var statearr_39431_39455 = state_39417__$1;
(statearr_39431_39455[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39418 === (5))){
var _ = (function (){var statearr_39432 = state_39417;
(statearr_39432[(4)] = cljs.core.rest((state_39417[(4)])));

return statearr_39432;
})();
var state_39417__$1 = state_39417;
var ex39428 = (state_39417__$1[(2)]);
var statearr_39433_39456 = state_39417__$1;
(statearr_39433_39456[(5)] = ex39428);


if((ex39428 instanceof Error)){
var statearr_39434_39457 = state_39417__$1;
(statearr_39434_39457[(1)] = (4));

(statearr_39434_39457[(5)] = null);

} else {
throw ex39428;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39418 === (14))){
var inst_39401 = (state_39417[(10)]);
var inst_39405 = (state_39417[(2)]);
var inst_39406 = fluree.db.util.async.throw_err(inst_39405);
var inst_39393 = inst_39406;
var inst_39394 = inst_39401;
var state_39417__$1 = (function (){var statearr_39435 = state_39417;
(statearr_39435[(9)] = inst_39394);

(statearr_39435[(7)] = inst_39393);

return statearr_39435;
})();
var statearr_39436_39458 = state_39417__$1;
(statearr_39436_39458[(2)] = null);

(statearr_39436_39458[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39418 === (10))){
var inst_39412 = (state_39417[(2)]);
var _ = (function (){var statearr_39437 = state_39417;
(statearr_39437[(4)] = cljs.core.rest((state_39417[(4)])));

return statearr_39437;
})();
var state_39417__$1 = state_39417;
var statearr_39438_39459 = state_39417__$1;
(statearr_39438_39459[(2)] = inst_39412);

(statearr_39438_39459[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39418 === (8))){
var inst_39373 = (state_39417[(2)]);
var inst_39374 = (function (){var tt_id_SINGLEQUOTE_ = inst_39373;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),cljs.core.cst$kw$tt_DASH_id,tt_id_SINGLEQUOTE_));
});
})();
var inst_39375 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$tt_DASH_id,inst_39373);
var inst_39376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39377 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst];
var inst_39378 = (new cljs.core.PersistentVector(null,4,(5),inst_39376,inst_39377,null));
var inst_39379 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_39374,inst_39375,inst_39378);
var inst_39380 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,flakes);
var inst_39381 = cljs.core.reverse(inst_39380);
var inst_39382 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,inst_39381);
var inst_39390 = cljs.core.seq(inst_39382);
var inst_39391 = cljs.core.first(inst_39390);
var inst_39392 = cljs.core.next(inst_39390);
var inst_39393 = inst_39379;
var inst_39394 = inst_39382;
var state_39417__$1 = (function (){var statearr_39439 = state_39417;
(statearr_39439[(9)] = inst_39394);

(statearr_39439[(11)] = inst_39392);

(statearr_39439[(7)] = inst_39393);

(statearr_39439[(12)] = inst_39391);

return statearr_39439;
})();
var statearr_39440_39460 = state_39417__$1;
(statearr_39440_39460[(2)] = null);

(statearr_39440_39460[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto____0 = (function (){
var statearr_39441 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39441[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto__);

(statearr_39441[(1)] = (1));

return statearr_39441;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto____1 = (function (state_39417){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_39417);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e39442){var ex__13886__auto__ = e39442;
var statearr_39443_39461 = state_39417;
(statearr_39443_39461[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_39417[(4)]))){
var statearr_39444_39462 = state_39417;
(statearr_39444_39462[(1)] = cljs.core.first((state_39417[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__39463 = state_39417;
state_39417 = G__39463;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto__ = function(state_39417){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto____1.call(this,state_39417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_39445 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_39445[(6)] = c__13957__auto__);

return statearr_39445;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__13957__auto___39641 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_39578){
var state_val_39579 = (state_39578[(1)]);
if((state_val_39579 === (7))){
var inst_39491 = fluree.db.util.core.pred_ident_QMARK_(ident);
var inst_39492 = cljs.core.first(ident);
var inst_39493 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_39492);
var inst_39494 = (inst_39493 == null);
var inst_39495 = ((inst_39491) && (inst_39494));
var state_39578__$1 = state_39578;
if(cljs.core.truth_(inst_39495)){
var statearr_39580_39642 = state_39578__$1;
(statearr_39580_39642[(1)] = (13));

} else {
var statearr_39581_39643 = state_39578__$1;
(statearr_39581_39643[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (20))){
var state_39578__$1 = state_39578;
var statearr_39582_39644 = state_39578__$1;
(statearr_39582_39644[(2)] = null);

(statearr_39582_39644[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (27))){
var state_39578__$1 = state_39578;
var statearr_39583_39645 = state_39578__$1;
(statearr_39583_39645[(2)] = null);

(statearr_39583_39645[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (1))){
var state_39578__$1 = state_39578;
var statearr_39584_39646 = state_39578__$1;
(statearr_39584_39646[(2)] = null);

(statearr_39584_39646[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (24))){
var inst_39524 = (state_39578[(7)]);
var inst_39528 = inst_39524.s;
var state_39578__$1 = state_39578;
var statearr_39585_39647 = state_39578__$1;
(statearr_39585_39647[(2)] = inst_39528);

(statearr_39585_39647[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (39))){
var state_39578__$1 = state_39578;
var statearr_39586_39648 = state_39578__$1;
(statearr_39586_39648[(2)] = null);

(statearr_39586_39648[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (4))){
var inst_39464 = (state_39578[(2)]);
var inst_39465 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_39466 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39467 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_39468 = cljs.core.PersistentHashMap.fromArrays(inst_39466,inst_39467);
var inst_39469 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_39465,inst_39468,inst_39464);
var inst_39470 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_39469);
var state_39578__$1 = state_39578;
var statearr_39587_39649 = state_39578__$1;
(statearr_39587_39649[(2)] = inst_39470);

(statearr_39587_39649[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (15))){
var inst_39546 = (state_39578[(2)]);
var state_39578__$1 = state_39578;
var statearr_39588_39650 = state_39578__$1;
(statearr_39588_39650[(2)] = inst_39546);

(statearr_39588_39650[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (21))){
var inst_39518 = (state_39578[(8)]);
var inst_39522 = cljs.core.first(inst_39518);
var state_39578__$1 = state_39578;
var statearr_39589_39651 = state_39578__$1;
(statearr_39589_39651[(2)] = inst_39522);

(statearr_39589_39651[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (31))){
var inst_39573 = (state_39578[(2)]);
var _ = (function (){var statearr_39590 = state_39578;
(statearr_39590[(4)] = cljs.core.rest((state_39578[(4)])));

return statearr_39590;
})();
var state_39578__$1 = state_39578;
var statearr_39591_39652 = state_39578__$1;
(statearr_39591_39652[(2)] = inst_39573);

(statearr_39591_39652[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (32))){
var state_39578__$1 = state_39578;
var statearr_39592_39653 = state_39578__$1;
(statearr_39592_39653[(2)] = strict_QMARK_);

(statearr_39592_39653[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (40))){
var inst_39569 = (state_39578[(2)]);
var state_39578__$1 = state_39578;
var statearr_39593_39654 = state_39578__$1;
(statearr_39593_39654[(2)] = inst_39569);

(statearr_39593_39654[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (33))){
var state_39578__$1 = state_39578;
var statearr_39594_39655 = state_39578__$1;
(statearr_39594_39655[(2)] = false);

(statearr_39594_39655[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (13))){
var inst_39497 = cljs.core.first(ident);
var inst_39498 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39497], 0));
var inst_39499 = ["Subject ID lookup failed. The predicate ",inst_39498," does not exist."].join('');
var inst_39500 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39501 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_39502 = cljs.core.PersistentHashMap.fromArrays(inst_39500,inst_39501);
var inst_39503 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39499,inst_39502);
var inst_39504 = (function(){throw inst_39503})();
var state_39578__$1 = state_39578;
var statearr_39595_39656 = state_39578__$1;
(statearr_39595_39656[(2)] = inst_39504);

(statearr_39595_39656[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (22))){
var inst_39524 = (state_39578[(7)]);
var inst_39524__$1 = (state_39578[(2)]);
var inst_39525 = (inst_39524__$1 == null);
var state_39578__$1 = (function (){var statearr_39596 = state_39578;
(statearr_39596[(7)] = inst_39524__$1);

return statearr_39596;
})();
if(cljs.core.truth_(inst_39525)){
var statearr_39597_39657 = state_39578__$1;
(statearr_39597_39657[(1)] = (23));

} else {
var statearr_39598_39658 = state_39578__$1;
(statearr_39598_39658[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (36))){
var state_39578__$1 = state_39578;
var statearr_39599_39659 = state_39578__$1;
(statearr_39599_39659[(1)] = (38));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (29))){
var inst_39548 = (state_39578[(9)]);
var inst_39550 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_39548);
var state_39578__$1 = state_39578;
var statearr_39601_39660 = state_39578__$1;
(statearr_39601_39660[(2)] = inst_39550);

(statearr_39601_39660[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (6))){
var inst_39478 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39479 = [ident];
var inst_39480 = (new cljs.core.PersistentVector(null,1,(5),inst_39478,inst_39479,null));
var inst_39481 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_39480);
var state_39578__$1 = state_39578;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39578__$1,(9),inst_39481);
} else {
if((state_val_39579 === (28))){
var inst_39542 = (state_39578[(2)]);
var state_39578__$1 = state_39578;
var statearr_39602_39661 = state_39578__$1;
(statearr_39602_39661[(2)] = inst_39542);

(statearr_39602_39661[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (25))){
var inst_39530 = (state_39578[(2)]);
var state_39578__$1 = state_39578;
var statearr_39603_39662 = state_39578__$1;
(statearr_39603_39662[(2)] = inst_39530);

(statearr_39603_39662[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (34))){
var inst_39556 = (state_39578[(2)]);
var state_39578__$1 = state_39578;
if(cljs.core.truth_(inst_39556)){
var statearr_39604_39663 = state_39578__$1;
(statearr_39604_39663[(1)] = (35));

} else {
var statearr_39605_39664 = state_39578__$1;
(statearr_39605_39664[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (17))){
var state_39578__$1 = state_39578;
var statearr_39606_39665 = state_39578__$1;
(statearr_39606_39665[(1)] = (26));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (3))){
var inst_39576 = (state_39578[(2)]);
var state_39578__$1 = state_39578;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39578__$1,inst_39576);
} else {
if((state_val_39579 === (12))){
var inst_39489 = (state_39578[(2)]);
var state_39578__$1 = state_39578;
var statearr_39608_39666 = state_39578__$1;
(statearr_39608_39666[(2)] = inst_39489);

(statearr_39608_39666[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (2))){
var _ = (function (){var statearr_39609 = state_39578;
(statearr_39609[(4)] = cljs.core.cons((5),(state_39578[(4)])));

return statearr_39609;
})();
var inst_39476 = typeof ident === 'number';
var state_39578__$1 = state_39578;
if(cljs.core.truth_(inst_39476)){
var statearr_39610_39667 = state_39578__$1;
(statearr_39610_39667[(1)] = (6));

} else {
var statearr_39611_39668 = state_39578__$1;
(statearr_39611_39668[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (23))){
var state_39578__$1 = state_39578;
var statearr_39612_39669 = state_39578__$1;
(statearr_39612_39669[(2)] = null);

(statearr_39612_39669[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (35))){
var inst_39558 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_39559 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39560 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_39561 = cljs.core.PersistentHashMap.fromArrays(inst_39559,inst_39560);
var inst_39562 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39558,inst_39561);
var inst_39563 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_39562);
var state_39578__$1 = state_39578;
var statearr_39613_39670 = state_39578__$1;
(statearr_39613_39670[(2)] = inst_39563);

(statearr_39613_39670[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (19))){
var inst_39518 = (state_39578[(8)]);
var inst_39517 = (state_39578[(2)]);
var inst_39518__$1 = fluree.db.util.async.throw_err(inst_39517);
var inst_39519 = (inst_39518__$1 == null);
var state_39578__$1 = (function (){var statearr_39614 = state_39578;
(statearr_39614[(8)] = inst_39518__$1);

return statearr_39614;
})();
if(cljs.core.truth_(inst_39519)){
var statearr_39615_39671 = state_39578__$1;
(statearr_39615_39671[(1)] = (20));

} else {
var statearr_39616_39672 = state_39578__$1;
(statearr_39616_39672[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (11))){
var state_39578__$1 = state_39578;
var statearr_39618_39673 = state_39578__$1;
(statearr_39618_39673[(2)] = null);

(statearr_39618_39673[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (9))){
var inst_39483 = (state_39578[(2)]);
var inst_39484 = fluree.db.util.async.throw_err(inst_39483);
var inst_39485 = cljs.core.not_empty(inst_39484);
var state_39578__$1 = state_39578;
if(cljs.core.truth_(inst_39485)){
var statearr_39619_39674 = state_39578__$1;
(statearr_39619_39674[(1)] = (10));

} else {
var statearr_39620_39675 = state_39578__$1;
(statearr_39620_39675[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (5))){
var _ = (function (){var statearr_39621 = state_39578;
(statearr_39621[(4)] = cljs.core.rest((state_39578[(4)])));

return statearr_39621;
})();
var state_39578__$1 = state_39578;
var ex39617 = (state_39578__$1[(2)]);
var statearr_39622_39676 = state_39578__$1;
(statearr_39622_39676[(5)] = ex39617);


var statearr_39623_39677 = state_39578__$1;
(statearr_39623_39677[(1)] = (4));

(statearr_39623_39677[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (14))){
var inst_39506 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_39578__$1 = state_39578;
if(inst_39506){
var statearr_39624_39678 = state_39578__$1;
(statearr_39624_39678[(1)] = (16));

} else {
var statearr_39625_39679 = state_39578__$1;
(statearr_39625_39679[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (26))){
var inst_39533 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_39534 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_39533].join('');
var inst_39535 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39536 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_39537 = cljs.core.PersistentHashMap.fromArrays(inst_39535,inst_39536);
var inst_39538 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39534,inst_39537);
var inst_39539 = (function(){throw inst_39538})();
var state_39578__$1 = state_39578;
var statearr_39626_39680 = state_39578__$1;
(statearr_39626_39680[(2)] = inst_39539);

(statearr_39626_39680[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (16))){
var inst_39509 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39510 = cljs.core.first(ident);
var inst_39511 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_39510);
var inst_39512 = cljs.core.second(ident);
var inst_39513 = [inst_39511,inst_39512];
var inst_39514 = (new cljs.core.PersistentVector(null,2,(5),inst_39509,inst_39513,null));
var inst_39515 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_39514);
var state_39578__$1 = state_39578;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39578__$1,(19),inst_39515);
} else {
if((state_val_39579 === (38))){
var inst_39566 = cljs.core.async.close_BANG_(return_chan);
var state_39578__$1 = state_39578;
var statearr_39627_39681 = state_39578__$1;
(statearr_39627_39681[(2)] = inst_39566);

(statearr_39627_39681[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (30))){
var inst_39548 = (state_39578[(9)]);
var inst_39552 = (inst_39548 == null);
var state_39578__$1 = state_39578;
if(cljs.core.truth_(inst_39552)){
var statearr_39628_39682 = state_39578__$1;
(statearr_39628_39682[(1)] = (32));

} else {
var statearr_39629_39683 = state_39578__$1;
(statearr_39629_39683[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (10))){
var state_39578__$1 = state_39578;
var statearr_39630_39684 = state_39578__$1;
(statearr_39630_39684[(2)] = ident);

(statearr_39630_39684[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (18))){
var inst_39544 = (state_39578[(2)]);
var state_39578__$1 = state_39578;
var statearr_39631_39685 = state_39578__$1;
(statearr_39631_39685[(2)] = inst_39544);

(statearr_39631_39685[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (37))){
var inst_39571 = (state_39578[(2)]);
var state_39578__$1 = state_39578;
var statearr_39632_39686 = state_39578__$1;
(statearr_39632_39686[(2)] = inst_39571);

(statearr_39632_39686[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39579 === (8))){
var inst_39548 = (state_39578[(9)]);
var inst_39548__$1 = (state_39578[(2)]);
var state_39578__$1 = (function (){var statearr_39633 = state_39578;
(statearr_39633[(9)] = inst_39548__$1);

return statearr_39633;
})();
if(cljs.core.truth_(inst_39548__$1)){
var statearr_39634_39687 = state_39578__$1;
(statearr_39634_39687[(1)] = (29));

} else {
var statearr_39635_39688 = state_39578__$1;
(statearr_39635_39688[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__13883__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__13883__auto____0 = (function (){
var statearr_39636 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39636[(0)] = fluree$db$graphdb$subid_$_state_machine__13883__auto__);

(statearr_39636[(1)] = (1));

return statearr_39636;
});
var fluree$db$graphdb$subid_$_state_machine__13883__auto____1 = (function (state_39578){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_39578);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e39637){var ex__13886__auto__ = e39637;
var statearr_39638_39689 = state_39578;
(statearr_39638_39689[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_39578[(4)]))){
var statearr_39639_39690 = state_39578;
(statearr_39639_39690[(1)] = cljs.core.first((state_39578[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__39691 = state_39578;
state_39578 = G__39691;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__13883__auto__ = function(state_39578){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__13883__auto____1.call(this,state_39578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__13883__auto____0;
fluree$db$graphdb$subid_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__13883__auto____1;
return fluree$db$graphdb$subid_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_39640 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_39640[(6)] = c__13957__auto___39641);

return statearr_39640;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k39693,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__39697 = k39693;
var G__39697__$1 = (((G__39697 instanceof cljs.core.Keyword))?G__39697.fqn:null);
switch (G__39697__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k39693,else__4418__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__39698){
var vec__39699 = p__39698;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39699,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39699,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$stats,self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$spot,self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$psot,self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$post,self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$opst,self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema,self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$settings,self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_configs,self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$novelty,self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$permissions,self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork,self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork_DASH_block,self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39692){
var self__ = this;
var G__39692__$1 = this;
return (new cljs.core.RecordIter((0),G__39692__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (){var fexpr__39702 = (function (coll__4412__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
});
return fexpr__39702(this__4411__auto____$1);
})();
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this39694,other39695){
var self__ = this;
var this39694__$1 = this;
return (((!((other39695 == null)))) && ((this39694__$1.constructor === other39695.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.conn,other39695.conn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.network,other39695.network)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.dbid,other39695.dbid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.block,other39695.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.t,other39695.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.tt_id,other39695.tt_id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.stats,other39695.stats)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.spot,other39695.spot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.psot,other39695.psot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.post,other39695.post)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.opst,other39695.opst)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.schema,other39695.schema)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.settings,other39695.settings)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.index_configs,other39695.index_configs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.schema_cache,other39695.schema_cache)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.novelty,other39695.novelty)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.permissions,other39695.permissions)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.fork,other39695.fork)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.fork_block,other39695.fork_block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.current_db_fn,other39695.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39694__$1.__extmap,other39695.__extmap)));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$kw$current_DASH_db_DASH_fn,null,cljs.core.cst$kw$schema,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$psot,null,cljs.core.cst$kw$permissions,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$settings,null,cljs.core.cst$kw$index_DASH_configs,null,cljs.core.cst$kw$opst,null,cljs.core.cst$kw$fork_DASH_block,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$novelty,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$fork,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$stats,null,cljs.core.cst$kw$spot,null,cljs.core.cst$kw$conn,null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__39692){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__39703 = cljs.core.keyword_identical_QMARK_;
var expr__39704 = k__4423__auto__;
if(cljs.core.truth_((function (){var G__39706 = cljs.core.cst$kw$conn;
var G__39707 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39706,G__39707) : pred__39703.call(null,G__39706,G__39707));
})())){
return (new fluree.db.graphdb.GraphDb(G__39692,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39708 = cljs.core.cst$kw$network;
var G__39709 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39708,G__39709) : pred__39703.call(null,G__39708,G__39709));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__39692,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39710 = cljs.core.cst$kw$dbid;
var G__39711 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39710,G__39711) : pred__39703.call(null,G__39710,G__39711));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__39692,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39712 = cljs.core.cst$kw$block;
var G__39713 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39712,G__39713) : pred__39703.call(null,G__39712,G__39713));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__39692,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39714 = cljs.core.cst$kw$t;
var G__39715 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39714,G__39715) : pred__39703.call(null,G__39714,G__39715));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__39692,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39716 = cljs.core.cst$kw$tt_DASH_id;
var G__39717 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39716,G__39717) : pred__39703.call(null,G__39716,G__39717));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__39692,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39718 = cljs.core.cst$kw$stats;
var G__39719 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39718,G__39719) : pred__39703.call(null,G__39718,G__39719));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__39692,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39720 = cljs.core.cst$kw$spot;
var G__39721 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39720,G__39721) : pred__39703.call(null,G__39720,G__39721));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__39692,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39722 = cljs.core.cst$kw$psot;
var G__39723 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39722,G__39723) : pred__39703.call(null,G__39722,G__39723));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__39692,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39724 = cljs.core.cst$kw$post;
var G__39725 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39724,G__39725) : pred__39703.call(null,G__39724,G__39725));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__39692,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39726 = cljs.core.cst$kw$opst;
var G__39727 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39726,G__39727) : pred__39703.call(null,G__39726,G__39727));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__39692,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39728 = cljs.core.cst$kw$schema;
var G__39729 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39728,G__39729) : pred__39703.call(null,G__39728,G__39729));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__39692,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39730 = cljs.core.cst$kw$settings;
var G__39731 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39730,G__39731) : pred__39703.call(null,G__39730,G__39731));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__39692,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39732 = cljs.core.cst$kw$index_DASH_configs;
var G__39733 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39732,G__39733) : pred__39703.call(null,G__39732,G__39733));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__39692,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39734 = cljs.core.cst$kw$schema_DASH_cache;
var G__39735 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39734,G__39735) : pred__39703.call(null,G__39734,G__39735));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__39692,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39736 = cljs.core.cst$kw$novelty;
var G__39737 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39736,G__39737) : pred__39703.call(null,G__39736,G__39737));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__39692,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39738 = cljs.core.cst$kw$permissions;
var G__39739 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39738,G__39739) : pred__39703.call(null,G__39738,G__39739));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__39692,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39740 = cljs.core.cst$kw$fork;
var G__39741 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39740,G__39741) : pred__39703.call(null,G__39740,G__39741));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__39692,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39742 = cljs.core.cst$kw$fork_DASH_block;
var G__39743 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39742,G__39743) : pred__39703.call(null,G__39742,G__39743));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__39692,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39744 = cljs.core.cst$kw$current_DASH_db_DASH_fn;
var G__39745 = expr__39704;
return (pred__39703.cljs$core$IFn$_invoke$arity$2 ? pred__39703.cljs$core$IFn$_invoke$arity$2(G__39744,G__39745) : pred__39703.call(null,G__39744,G__39745));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__39692,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__39692),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$stats,self__.stats,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$spot,self__.spot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$psot,self__.psot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$post,self__.post,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$opst,self__.opst,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema,self__.schema,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$settings,self__.settings,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_configs,self__.index_configs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$novelty,self__.novelty,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$permissions,self__.permissions,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork,self__.fork,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork_DASH_block,self__.fork_block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__39692){
var self__ = this;
var this__4414__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__39692,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_39761){
var state_val_39762 = (state_39761[(1)]);
if((state_val_39762 === (1))){
var state_39761__$1 = state_39761;
var statearr_39763_40028 = state_39761__$1;
(statearr_39763_40028[(2)] = null);

(statearr_39763_40028[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39762 === (2))){
var _ = (function (){var statearr_39764 = state_39761;
(statearr_39764[(4)] = cljs.core.cons((5),(state_39761[(4)])));

return statearr_39764;
})();
var inst_39752 = (self__.current_db_fn.cljs$core$IFn$_invoke$arity$0 ? self__.current_db_fn.cljs$core$IFn$_invoke$arity$0() : self__.current_db_fn.call(null));
var state_39761__$1 = state_39761;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39761__$1,(6),inst_39752);
} else {
if((state_val_39762 === (3))){
var inst_39759 = (state_39761[(2)]);
var state_39761__$1 = state_39761;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39761__$1,inst_39759);
} else {
if((state_val_39762 === (4))){
var inst_39746 = (state_39761[(2)]);
var state_39761__$1 = state_39761;
var statearr_39766_40029 = state_39761__$1;
(statearr_39766_40029[(2)] = inst_39746);

(statearr_39766_40029[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39762 === (5))){
var _ = (function (){var statearr_39767 = state_39761;
(statearr_39767[(4)] = cljs.core.rest((state_39761[(4)])));

return statearr_39767;
})();
var state_39761__$1 = state_39761;
var ex39765 = (state_39761__$1[(2)]);
var statearr_39768_40030 = state_39761__$1;
(statearr_39768_40030[(5)] = ex39765);


if((ex39765 instanceof Error)){
var statearr_39769_40031 = state_39761__$1;
(statearr_39769_40031[(1)] = (4));

(statearr_39769_40031[(5)] = null);

} else {
throw ex39765;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39762 === (6))){
var inst_39754 = (state_39761[(2)]);
var inst_39755 = fluree.db.util.async.throw_err(inst_39754);
var inst_39756 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39755,cljs.core.cst$kw$permissions,self__.permissions);
var _ = (function (){var statearr_39770 = state_39761;
(statearr_39770[(4)] = cljs.core.rest((state_39761[(4)])));

return statearr_39770;
})();
var state_39761__$1 = state_39761;
var statearr_39771_40032 = state_39761__$1;
(statearr_39771_40032[(2)] = inst_39756);

(statearr_39771_40032[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__13883__auto__ = null;
var fluree$db$graphdb$state_machine__13883__auto____0 = (function (){
var statearr_39772 = [null,null,null,null,null,null,null];
(statearr_39772[(0)] = fluree$db$graphdb$state_machine__13883__auto__);

(statearr_39772[(1)] = (1));

return statearr_39772;
});
var fluree$db$graphdb$state_machine__13883__auto____1 = (function (state_39761){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_39761);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e39773){var ex__13886__auto__ = e39773;
var statearr_39774_40033 = state_39761;
(statearr_39774_40033[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_39761[(4)]))){
var statearr_39775_40034 = state_39761;
(statearr_39775_40034[(1)] = cljs.core.first((state_39761[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40035 = state_39761;
state_39761 = G__40035;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__13883__auto__ = function(state_39761){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__13883__auto____1.call(this,state_39761);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__13883__auto____0;
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__13883__auto____1;
return fluree$db$graphdb$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_39776 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_39776[(6)] = c__13957__auto__);

return statearr_39776;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__39777 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$name,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$sid,null], null), null);
return (fexpr__39777.cljs$core$IFn$_invoke$arity$1 ? fexpr__39777.cljs$core$IFn$_invoke$arity$1(property) : fexpr__39777.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :id :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__39778 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 17, [cljs.core.cst$kw$unique,null,cljs.core.cst$kw$restrictCollection,null,cljs.core.cst$kw$index,null,cljs.core.cst$kw$name,null,cljs.core.cst$kw$noHistory,null,cljs.core.cst$kw$type,null,cljs.core.cst$kw$txSpec,null,cljs.core.cst$kw$component,null,cljs.core.cst$kw$txSpecDoc,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$multi,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$idx_QMARK_,null,cljs.core.cst$kw$ref_QMARK_,null,cljs.core.cst$kw$upsert,null,cljs.core.cst$kw$restrictTag,null], null), null);
return (fexpr__39778.cljs$core$IFn$_invoke$arity$1 ? fexpr__39778.cljs$core$IFn$_invoke$arity$1(property) : fexpr__39778.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :restrictTag} property)"].join('')));
}

var G__39779 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred,predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$restrictCollection,property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,cljs.core.cst$kw$id,G__39779);
} else {
return G__39779;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$__$1,cljs.core.cst$kw$permissions,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$root_QMARK_,true,cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_39811){
var state_val_39812 = (state_39811[(1)]);
if((state_val_39812 === (7))){
var state_39811__$1 = state_39811;
var statearr_39813_40036 = state_39811__$1;
(statearr_39813_40036[(2)] = null);

(statearr_39813_40036[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39812 === (1))){
var state_39811__$1 = state_39811;
var statearr_39814_40037 = state_39811__$1;
(statearr_39814_40037[(2)] = null);

(statearr_39814_40037[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39812 === (4))){
var inst_39780 = (state_39811[(2)]);
var state_39811__$1 = state_39811;
var statearr_39815_40038 = state_39811__$1;
(statearr_39815_40038[(2)] = inst_39780);

(statearr_39815_40038[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39812 === (6))){
var inst_39794 = (state_39811[(7)]);
var inst_39793 = (state_39811[(2)]);
var inst_39794__$1 = fluree.db.util.async.throw_err(inst_39793);
var inst_39795 = (inst_39794__$1 == null);
var state_39811__$1 = (function (){var statearr_39816 = state_39811;
(statearr_39816[(7)] = inst_39794__$1);

return statearr_39816;
})();
if(cljs.core.truth_(inst_39795)){
var statearr_39817_40039 = state_39811__$1;
(statearr_39817_40039[(1)] = (7));

} else {
var statearr_39818_40040 = state_39811__$1;
(statearr_39818_40040[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39812 === (3))){
var inst_39809 = (state_39811[(2)]);
var state_39811__$1 = state_39811;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39811__$1,inst_39809);
} else {
if((state_val_39812 === (12))){
var inst_39806 = (state_39811[(2)]);
var _ = (function (){var statearr_39819 = state_39811;
(statearr_39819[(4)] = cljs.core.rest((state_39811[(4)])));

return statearr_39819;
})();
var state_39811__$1 = state_39811;
var statearr_39820_40041 = state_39811__$1;
(statearr_39820_40041[(2)] = inst_39806);

(statearr_39820_40041[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39812 === (2))){
var _ = (function (){var statearr_39821 = state_39811;
(statearr_39821[(4)] = cljs.core.cons((5),(state_39811[(4)])));

return statearr_39821;
})();
var inst_39787 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_39788 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39789 = [tag_id,(30)];
var inst_39790 = (new cljs.core.PersistentVector(null,2,(5),inst_39788,inst_39789,null));
var inst_39791 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_39787,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_39790);
var state_39811__$1 = state_39811;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39811__$1,(6),inst_39791);
} else {
if((state_val_39812 === (11))){
var inst_39800 = (state_39811[(8)]);
var inst_39804 = inst_39800.o;
var state_39811__$1 = state_39811;
var statearr_39823_40042 = state_39811__$1;
(statearr_39823_40042[(2)] = inst_39804);

(statearr_39823_40042[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39812 === (9))){
var inst_39800 = (state_39811[(8)]);
var inst_39800__$1 = (state_39811[(2)]);
var inst_39801 = (inst_39800__$1 == null);
var state_39811__$1 = (function (){var statearr_39824 = state_39811;
(statearr_39824[(8)] = inst_39800__$1);

return statearr_39824;
})();
if(cljs.core.truth_(inst_39801)){
var statearr_39825_40043 = state_39811__$1;
(statearr_39825_40043[(1)] = (10));

} else {
var statearr_39826_40044 = state_39811__$1;
(statearr_39826_40044[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39812 === (5))){
var _ = (function (){var statearr_39827 = state_39811;
(statearr_39827[(4)] = cljs.core.rest((state_39811[(4)])));

return statearr_39827;
})();
var state_39811__$1 = state_39811;
var ex39822 = (state_39811__$1[(2)]);
var statearr_39828_40045 = state_39811__$1;
(statearr_39828_40045[(5)] = ex39822);


if((ex39822 instanceof Error)){
var statearr_39829_40046 = state_39811__$1;
(statearr_39829_40046[(1)] = (4));

(statearr_39829_40046[(5)] = null);

} else {
throw ex39822;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39812 === (10))){
var state_39811__$1 = state_39811;
var statearr_39830_40047 = state_39811__$1;
(statearr_39830_40047[(2)] = null);

(statearr_39830_40047[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39812 === (8))){
var inst_39794 = (state_39811[(7)]);
var inst_39798 = cljs.core.first(inst_39794);
var state_39811__$1 = state_39811;
var statearr_39831_40048 = state_39811__$1;
(statearr_39831_40048[(2)] = inst_39798);

(statearr_39831_40048[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__13883__auto__ = null;
var fluree$db$graphdb$state_machine__13883__auto____0 = (function (){
var statearr_39832 = [null,null,null,null,null,null,null,null,null];
(statearr_39832[(0)] = fluree$db$graphdb$state_machine__13883__auto__);

(statearr_39832[(1)] = (1));

return statearr_39832;
});
var fluree$db$graphdb$state_machine__13883__auto____1 = (function (state_39811){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_39811);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e39833){var ex__13886__auto__ = e39833;
var statearr_39834_40049 = state_39811;
(statearr_39834_40049[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_39811[(4)]))){
var statearr_39835_40050 = state_39811;
(statearr_39835_40050[(1)] = cljs.core.first((state_39811[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40051 = state_39811;
state_39811 = G__40051;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__13883__auto__ = function(state_39811){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__13883__auto____1.call(this,state_39811);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__13883__auto____0;
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__13883__auto____1;
return fluree$db$graphdb$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_39836 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_39836[(6)] = c__13957__auto__);

return statearr_39836;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_39872){
var state_val_39873 = (state_39872[(1)]);
if((state_val_39873 === (7))){
var inst_39846 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_39872__$1 = state_39872;
var statearr_39874_40052 = state_39872__$1;
(statearr_39874_40052[(2)] = inst_39846);

(statearr_39874_40052[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39873 === (1))){
var state_39872__$1 = state_39872;
var statearr_39875_40053 = state_39872__$1;
(statearr_39875_40053[(2)] = null);

(statearr_39875_40053[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39873 === (4))){
var inst_39837 = (state_39872[(2)]);
var state_39872__$1 = state_39872;
var statearr_39876_40054 = state_39872__$1;
(statearr_39876_40054[(2)] = inst_39837);

(statearr_39876_40054[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39873 === (15))){
var inst_39867 = (state_39872[(2)]);
var _ = (function (){var statearr_39877 = state_39872;
(statearr_39877[(4)] = cljs.core.rest((state_39872[(4)])));

return statearr_39877;
})();
var state_39872__$1 = state_39872;
var statearr_39878_40055 = state_39872__$1;
(statearr_39878_40055[(2)] = inst_39867);

(statearr_39878_40055[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39873 === (13))){
var inst_39852 = (state_39872[(7)]);
var inst_39858 = clojure.string.includes_QMARK_(inst_39852,":");
var state_39872__$1 = state_39872;
if(inst_39858){
var statearr_39879_40056 = state_39872__$1;
(statearr_39879_40056[(1)] = (16));

} else {
var statearr_39880_40057 = state_39872__$1;
(statearr_39880_40057[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39873 === (6))){
var state_39872__$1 = state_39872;
var statearr_39881_40058 = state_39872__$1;
(statearr_39881_40058[(2)] = pred);

(statearr_39881_40058[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39873 === (17))){
var inst_39852 = (state_39872[(7)]);
var state_39872__$1 = state_39872;
var statearr_39882_40059 = state_39872__$1;
(statearr_39882_40059[(2)] = inst_39852);

(statearr_39882_40059[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39873 === (3))){
var inst_39870 = (state_39872[(2)]);
var state_39872__$1 = state_39872;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39872__$1,inst_39870);
} else {
if((state_val_39873 === (12))){
var inst_39856 = (state_39872[(2)]);
var state_39872__$1 = state_39872;
if(cljs.core.truth_(inst_39856)){
var statearr_39883_40060 = state_39872__$1;
(statearr_39883_40060[(1)] = (13));

} else {
var statearr_39884_40061 = state_39872__$1;
(statearr_39884_40061[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39873 === (2))){
var _ = (function (){var statearr_39885 = state_39872;
(statearr_39885[(4)] = cljs.core.cons((5),(state_39872[(4)])));

return statearr_39885;
})();
var inst_39843 = typeof pred === 'string';
var state_39872__$1 = state_39872;
if(cljs.core.truth_(inst_39843)){
var statearr_39886_40062 = state_39872__$1;
(statearr_39886_40062[(1)] = (6));

} else {
var statearr_39887_40063 = state_39872__$1;
(statearr_39887_40063[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39873 === (11))){
var inst_39848 = (state_39872[(8)]);
var state_39872__$1 = state_39872;
var statearr_39889_40064 = state_39872__$1;
(statearr_39889_40064[(2)] = inst_39848);

(statearr_39889_40064[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39873 === (9))){
var inst_39848 = (state_39872[(8)]);
var inst_39851 = (state_39872[(2)]);
var inst_39852 = fluree.db.util.async.throw_err(inst_39851);
var state_39872__$1 = (function (){var statearr_39890 = state_39872;
(statearr_39890[(7)] = inst_39852);

return statearr_39890;
})();
if(cljs.core.truth_(inst_39848)){
var statearr_39891_40065 = state_39872__$1;
(statearr_39891_40065[(1)] = (10));

} else {
var statearr_39892_40066 = state_39872__$1;
(statearr_39892_40066[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39873 === (5))){
var _ = (function (){var statearr_39893 = state_39872;
(statearr_39893[(4)] = cljs.core.rest((state_39872[(4)])));

return statearr_39893;
})();
var state_39872__$1 = state_39872;
var ex39888 = (state_39872__$1[(2)]);
var statearr_39894_40067 = state_39872__$1;
(statearr_39894_40067[(5)] = ex39888);


if((ex39888 instanceof Error)){
var statearr_39895_40068 = state_39872__$1;
(statearr_39895_40068[(1)] = (4));

(statearr_39895_40068[(5)] = null);

} else {
throw ex39888;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39873 === (14))){
var state_39872__$1 = state_39872;
var statearr_39896_40069 = state_39872__$1;
(statearr_39896_40069[(2)] = null);

(statearr_39896_40069[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39873 === (16))){
var inst_39852 = (state_39872[(7)]);
var inst_39860 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_39852,/:/);
var inst_39861 = cljs.core.second(inst_39860);
var state_39872__$1 = state_39872;
var statearr_39897_40070 = state_39872__$1;
(statearr_39897_40070[(2)] = inst_39861);

(statearr_39897_40070[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39873 === (10))){
var inst_39852 = (state_39872[(7)]);
var state_39872__$1 = state_39872;
var statearr_39898_40071 = state_39872__$1;
(statearr_39898_40071[(2)] = inst_39852);

(statearr_39898_40071[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39873 === (18))){
var inst_39864 = (state_39872[(2)]);
var state_39872__$1 = state_39872;
var statearr_39899_40072 = state_39872__$1;
(statearr_39899_40072[(2)] = inst_39864);

(statearr_39899_40072[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39873 === (8))){
var inst_39848 = (state_39872[(2)]);
var inst_39849 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag$arity$2(null,tag_id);
var state_39872__$1 = (function (){var statearr_39900 = state_39872;
(statearr_39900[(8)] = inst_39848);

return statearr_39900;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39872__$1,(9),inst_39849);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__13883__auto__ = null;
var fluree$db$graphdb$state_machine__13883__auto____0 = (function (){
var statearr_39901 = [null,null,null,null,null,null,null,null,null];
(statearr_39901[(0)] = fluree$db$graphdb$state_machine__13883__auto__);

(statearr_39901[(1)] = (1));

return statearr_39901;
});
var fluree$db$graphdb$state_machine__13883__auto____1 = (function (state_39872){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_39872);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e39902){var ex__13886__auto__ = e39902;
var statearr_39903_40073 = state_39872;
(statearr_39903_40073[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_39872[(4)]))){
var statearr_39904_40074 = state_39872;
(statearr_39904_40074[(1)] = cljs.core.first((state_39872[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40075 = state_39872;
state_39872 = G__40075;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__13883__auto__ = function(state_39872){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__13883__auto____1.call(this,state_39872);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__13883__auto____0;
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__13883__auto____1;
return fluree$db$graphdb$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_39905 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_39905[(6)] = c__13957__auto__);

return statearr_39905;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_39937){
var state_val_39938 = (state_39937[(1)]);
if((state_val_39938 === (7))){
var state_39937__$1 = state_39937;
var statearr_39939_40076 = state_39937__$1;
(statearr_39939_40076[(2)] = null);

(statearr_39939_40076[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39938 === (1))){
var state_39937__$1 = state_39937;
var statearr_39940_40077 = state_39937__$1;
(statearr_39940_40077[(2)] = null);

(statearr_39940_40077[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39938 === (4))){
var inst_39906 = (state_39937[(2)]);
var state_39937__$1 = state_39937;
var statearr_39941_40078 = state_39937__$1;
(statearr_39941_40078[(2)] = inst_39906);

(statearr_39941_40078[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39938 === (6))){
var inst_39920 = (state_39937[(7)]);
var inst_39919 = (state_39937[(2)]);
var inst_39920__$1 = fluree.db.util.async.throw_err(inst_39919);
var inst_39921 = (inst_39920__$1 == null);
var state_39937__$1 = (function (){var statearr_39942 = state_39937;
(statearr_39942[(7)] = inst_39920__$1);

return statearr_39942;
})();
if(cljs.core.truth_(inst_39921)){
var statearr_39943_40079 = state_39937__$1;
(statearr_39943_40079[(1)] = (7));

} else {
var statearr_39944_40080 = state_39937__$1;
(statearr_39944_40080[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39938 === (3))){
var inst_39935 = (state_39937[(2)]);
var state_39937__$1 = state_39937;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39937__$1,inst_39935);
} else {
if((state_val_39938 === (12))){
var inst_39932 = (state_39937[(2)]);
var _ = (function (){var statearr_39945 = state_39937;
(statearr_39945[(4)] = cljs.core.rest((state_39937[(4)])));

return statearr_39945;
})();
var state_39937__$1 = state_39937;
var statearr_39946_40081 = state_39937__$1;
(statearr_39946_40081[(2)] = inst_39932);

(statearr_39946_40081[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39938 === (2))){
var _ = (function (){var statearr_39947 = state_39937;
(statearr_39947[(4)] = cljs.core.cons((5),(state_39937[(4)])));

return statearr_39947;
})();
var inst_39913 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_39914 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39915 = [(30),tag_name];
var inst_39916 = (new cljs.core.PersistentVector(null,2,(5),inst_39914,inst_39915,null));
var inst_39917 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_39913,cljs.core.cst$kw$post,cljs.core._EQ_,inst_39916);
var state_39937__$1 = state_39937;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39937__$1,(6),inst_39917);
} else {
if((state_val_39938 === (11))){
var inst_39926 = (state_39937[(8)]);
var inst_39930 = inst_39926.s;
var state_39937__$1 = state_39937;
var statearr_39949_40082 = state_39937__$1;
(statearr_39949_40082[(2)] = inst_39930);

(statearr_39949_40082[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39938 === (9))){
var inst_39926 = (state_39937[(8)]);
var inst_39926__$1 = (state_39937[(2)]);
var inst_39927 = (inst_39926__$1 == null);
var state_39937__$1 = (function (){var statearr_39950 = state_39937;
(statearr_39950[(8)] = inst_39926__$1);

return statearr_39950;
})();
if(cljs.core.truth_(inst_39927)){
var statearr_39951_40083 = state_39937__$1;
(statearr_39951_40083[(1)] = (10));

} else {
var statearr_39952_40084 = state_39937__$1;
(statearr_39952_40084[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39938 === (5))){
var _ = (function (){var statearr_39953 = state_39937;
(statearr_39953[(4)] = cljs.core.rest((state_39937[(4)])));

return statearr_39953;
})();
var state_39937__$1 = state_39937;
var ex39948 = (state_39937__$1[(2)]);
var statearr_39954_40085 = state_39937__$1;
(statearr_39954_40085[(5)] = ex39948);


if((ex39948 instanceof Error)){
var statearr_39955_40086 = state_39937__$1;
(statearr_39955_40086[(1)] = (4));

(statearr_39955_40086[(5)] = null);

} else {
throw ex39948;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39938 === (10))){
var state_39937__$1 = state_39937;
var statearr_39956_40087 = state_39937__$1;
(statearr_39956_40087[(2)] = null);

(statearr_39956_40087[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39938 === (8))){
var inst_39920 = (state_39937[(7)]);
var inst_39924 = cljs.core.first(inst_39920);
var state_39937__$1 = state_39937;
var statearr_39957_40088 = state_39937__$1;
(statearr_39957_40088[(2)] = inst_39924);

(statearr_39957_40088[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__13883__auto__ = null;
var fluree$db$graphdb$state_machine__13883__auto____0 = (function (){
var statearr_39958 = [null,null,null,null,null,null,null,null,null];
(statearr_39958[(0)] = fluree$db$graphdb$state_machine__13883__auto__);

(statearr_39958[(1)] = (1));

return statearr_39958;
});
var fluree$db$graphdb$state_machine__13883__auto____1 = (function (state_39937){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_39937);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e39959){var ex__13886__auto__ = e39959;
var statearr_39960_40089 = state_39937;
(statearr_39960_40089[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_39937[(4)]))){
var statearr_39961_40090 = state_39937;
(statearr_39961_40090[(1)] = cljs.core.first((state_39937[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40091 = state_39937;
state_39937 = G__40091;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__13883__auto__ = function(state_39937){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__13883__auto____1.call(this,state_39937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__13883__auto____0;
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__13883__auto____1;
return fluree$db$graphdb$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_39962 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_39962[(6)] = c__13957__auto__);

return statearr_39962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_39997){
var state_val_39998 = (state_39997[(1)]);
if((state_val_39998 === (7))){
var inst_39976 = typeof pred === 'string';
var state_39997__$1 = state_39997;
if(cljs.core.truth_(inst_39976)){
var statearr_39999_40092 = state_39997__$1;
(statearr_39999_40092[(1)] = (10));

} else {
var statearr_40000_40093 = state_39997__$1;
(statearr_40000_40093[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39998 === (1))){
var state_39997__$1 = state_39997;
var statearr_40001_40094 = state_39997__$1;
(statearr_40001_40094[(2)] = null);

(statearr_40001_40094[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39998 === (4))){
var inst_39963 = (state_39997[(2)]);
var state_39997__$1 = state_39997;
var statearr_40002_40095 = state_39997__$1;
(statearr_40002_40095[(2)] = inst_39963);

(statearr_40002_40095[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39998 === (15))){
var inst_39990 = (state_39997[(2)]);
var state_39997__$1 = state_39997;
var statearr_40003_40096 = state_39997__$1;
(statearr_40003_40096[(2)] = inst_39990);

(statearr_40003_40096[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39998 === (13))){
var inst_39981 = (state_39997[(7)]);
var inst_39983 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39981),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_39984 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,inst_39983);
var state_39997__$1 = state_39997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39997__$1,(16),inst_39984);
} else {
if((state_val_39998 === (6))){
var inst_39971 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,tag_name);
var state_39997__$1 = state_39997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39997__$1,(9),inst_39971);
} else {
if((state_val_39998 === (3))){
var inst_39995 = (state_39997[(2)]);
var state_39997__$1 = state_39997;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39997__$1,inst_39995);
} else {
if((state_val_39998 === (12))){
var inst_39981 = (state_39997[(7)]);
var inst_39981__$1 = (state_39997[(2)]);
var state_39997__$1 = (function (){var statearr_40004 = state_39997;
(statearr_40004[(7)] = inst_39981__$1);

return statearr_40004;
})();
if(cljs.core.truth_(inst_39981__$1)){
var statearr_40005_40097 = state_39997__$1;
(statearr_40005_40097[(1)] = (13));

} else {
var statearr_40006_40098 = state_39997__$1;
(statearr_40006_40098[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39998 === (2))){
var _ = (function (){var statearr_40007 = state_39997;
(statearr_40007[(4)] = cljs.core.cons((5),(state_39997[(4)])));

return statearr_40007;
})();
var inst_39969 = clojure.string.includes_QMARK_(tag_name,"/");
var state_39997__$1 = state_39997;
if(inst_39969){
var statearr_40008_40099 = state_39997__$1;
(statearr_40008_40099[(1)] = (6));

} else {
var statearr_40009_40100 = state_39997__$1;
(statearr_40009_40100[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39998 === (11))){
var inst_39979 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_39997__$1 = state_39997;
var statearr_40011_40101 = state_39997__$1;
(statearr_40011_40101[(2)] = inst_39979);

(statearr_40011_40101[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39998 === (9))){
var inst_39973 = (state_39997[(2)]);
var inst_39974 = fluree.db.util.async.throw_err(inst_39973);
var state_39997__$1 = state_39997;
var statearr_40012_40102 = state_39997__$1;
(statearr_40012_40102[(2)] = inst_39974);

(statearr_40012_40102[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39998 === (5))){
var _ = (function (){var statearr_40013 = state_39997;
(statearr_40013[(4)] = cljs.core.rest((state_39997[(4)])));

return statearr_40013;
})();
var state_39997__$1 = state_39997;
var ex40010 = (state_39997__$1[(2)]);
var statearr_40014_40103 = state_39997__$1;
(statearr_40014_40103[(5)] = ex40010);


if((ex40010 instanceof Error)){
var statearr_40015_40104 = state_39997__$1;
(statearr_40015_40104[(1)] = (4));

(statearr_40015_40104[(5)] = null);

} else {
throw ex40010;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39998 === (14))){
var state_39997__$1 = state_39997;
var statearr_40016_40105 = state_39997__$1;
(statearr_40016_40105[(2)] = null);

(statearr_40016_40105[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39998 === (16))){
var inst_39986 = (state_39997[(2)]);
var inst_39987 = fluree.db.util.async.throw_err(inst_39986);
var state_39997__$1 = state_39997;
var statearr_40017_40106 = state_39997__$1;
(statearr_40017_40106[(2)] = inst_39987);

(statearr_40017_40106[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39998 === (10))){
var state_39997__$1 = state_39997;
var statearr_40018_40107 = state_39997__$1;
(statearr_40018_40107[(2)] = pred);

(statearr_40018_40107[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39998 === (8))){
var inst_39992 = (state_39997[(2)]);
var _ = (function (){var statearr_40019 = state_39997;
(statearr_40019[(4)] = cljs.core.rest((state_39997[(4)])));

return statearr_40019;
})();
var state_39997__$1 = state_39997;
var statearr_40020_40108 = state_39997__$1;
(statearr_40020_40108[(2)] = inst_39992);

(statearr_40020_40108[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__13883__auto__ = null;
var fluree$db$graphdb$state_machine__13883__auto____0 = (function (){
var statearr_40021 = [null,null,null,null,null,null,null,null];
(statearr_40021[(0)] = fluree$db$graphdb$state_machine__13883__auto__);

(statearr_40021[(1)] = (1));

return statearr_40021;
});
var fluree$db$graphdb$state_machine__13883__auto____1 = (function (state_39997){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_39997);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e40022){var ex__13886__auto__ = e40022;
var statearr_40023_40109 = state_39997;
(statearr_40023_40109[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_39997[(4)]))){
var statearr_40024_40110 = state_39997;
(statearr_40024_40110[(1)] = cljs.core.first((state_39997[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40111 = state_39997;
state_39997 = G__40111;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__13883__auto__ = function(state_39997){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__13883__auto____1.call(this,state_39997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__13883__auto____0;
fluree$db$graphdb$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__13883__auto____1;
return fluree$db$graphdb$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_40025 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_40025[(6)] = c__13957__auto__);

return statearr_40025;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$stats,cljs.core.cst$sym$spot,cljs.core.cst$sym$psot,cljs.core.cst$sym$post,cljs.core.cst$sym$opst,cljs.core.cst$sym$schema,cljs.core.cst$sym$settings,cljs.core.cst$sym$index_DASH_configs,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$novelty,cljs.core.cst$sym$permissions,cljs.core.cst$sym$fork,cljs.core.cst$sym$fork_DASH_block,cljs.core.cst$sym$current_DASH_db_DASH_fn], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__39696){
var extmap__4454__auto__ = (function (){var G__40026 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__39696,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], 0));
if(cljs.core.record_QMARK_(G__39696)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__40026);
} else {
return G__40026;
}
})();
return (new fluree.db.graphdb.GraphDb(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__39696),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__39696),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__39696),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__39696),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__39696),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__39696),cljs.core.cst$kw$stats.cljs$core$IFn$_invoke$arity$1(G__39696),cljs.core.cst$kw$spot.cljs$core$IFn$_invoke$arity$1(G__39696),cljs.core.cst$kw$psot.cljs$core$IFn$_invoke$arity$1(G__39696),cljs.core.cst$kw$post.cljs$core$IFn$_invoke$arity$1(G__39696),cljs.core.cst$kw$opst.cljs$core$IFn$_invoke$arity$1(G__39696),cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(G__39696),cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(G__39696),cljs.core.cst$kw$index_DASH_configs.cljs$core$IFn$_invoke$arity$1(G__39696),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__39696),cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(G__39696),cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(G__39696),cljs.core.cst$kw$fork.cljs$core$IFn$_invoke$arity$1(G__39696),cljs.core.cst$kw$fork_DASH_block.cljs$core$IFn$_invoke$arity$1(G__39696),cljs.core.cst$kw$current_DASH_db_DASH_fn.cljs$core$IFn$_invoke$arity$1(G__39696),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$network,db__$1.network,cljs.core.cst$kw$dbid,db__$1.dbid,cljs.core.cst$kw$block,db__$1.block,cljs.core.cst$kw$t,db__$1.t,cljs.core.cst$kw$stats,db__$1.stats,cljs.core.cst$kw$permissions,db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,cljs.core.cst$kw$historyComparator], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$size,(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$block,cljs.core.cst$kw$dbid,cljs.core.cst$kw$config,cljs.core.cst$kw$leaf,cljs.core.cst$kw$size,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$id,cljs.core.cst$kw$t,cljs.core.cst$kw$network,cljs.core.cst$kw$first,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$rhs,cljs.core.cst$kw$conn],[(0),dbid,index_config,true,(0),true,cljs.core.cst$kw$empty,(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$spot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$spot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_spot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_spot_novelty], null)),cljs.core.cst$kw$psot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$psot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_psot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_psot_novelty], null)),cljs.core.cst$kw$post,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$post,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_post,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_post_novelty], null)),cljs.core.cst$kw$opst,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$opst,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_opst,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,false], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$root_QMARK_,true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$spot);
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$psot);
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$post);
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$opst);
var stats = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$flakes,(0),cljs.core.cst$kw$size,(0),cljs.core.cst$kw$indexed,(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
