// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k37016,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__37020 = k37016;
var G__37020__$1 = (((G__37020 instanceof cljs.core.Keyword))?G__37020.fqn:null);
switch (G__37020__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k37016,else__4418__auto__);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__37021){
var vec__37022 = p__37021;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37022,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37022,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_type,self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$comparator,self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$historyComparator,self__.historyComparator],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__37015){
var self__ = this;
var G__37015__$1 = this;
return (new cljs.core.RecordIter((0),G__37015__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (){var fexpr__37025 = (function (coll__4412__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
});
return fexpr__37025(this__4411__auto____$1);
})();
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this37017,other37018){
var self__ = this;
var this37017__$1 = this;
return (((!((other37018 == null)))) && ((this37017__$1.constructor === other37018.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37017__$1.index_type,other37018.index_type)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37017__$1.comparator,other37018.comparator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37017__$1.historyComparator,other37018.historyComparator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37017__$1.__extmap,other37018.__extmap)));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$historyComparator,null,cljs.core.cst$kw$comparator,null,cljs.core.cst$kw$index_DASH_type,null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__37015){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__37026 = cljs.core.keyword_identical_QMARK_;
var expr__37027 = k__4423__auto__;
if(cljs.core.truth_((function (){var G__37029 = cljs.core.cst$kw$index_DASH_type;
var G__37030 = expr__37027;
return (pred__37026.cljs$core$IFn$_invoke$arity$2 ? pred__37026.cljs$core$IFn$_invoke$arity$2(G__37029,G__37030) : pred__37026.call(null,G__37029,G__37030));
})())){
return (new fluree.db.index.IndexConfig(G__37015,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37031 = cljs.core.cst$kw$comparator;
var G__37032 = expr__37027;
return (pred__37026.cljs$core$IFn$_invoke$arity$2 ? pred__37026.cljs$core$IFn$_invoke$arity$2(G__37031,G__37032) : pred__37026.call(null,G__37031,G__37032));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,G__37015,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37033 = cljs.core.cst$kw$historyComparator;
var G__37034 = expr__37027;
return (pred__37026.cljs$core$IFn$_invoke$arity$2 ? pred__37026.cljs$core$IFn$_invoke$arity$2(G__37033,G__37034) : pred__37026.call(null,G__37033,G__37034));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__37015,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__37015),null));
}
}
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_type,self__.index_type,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$comparator,self__.comparator,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$historyComparator,self__.historyComparator,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__37015){
var self__ = this;
var this__4414__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__37015,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$index_DASH_type,cljs.core.cst$sym$comparator,cljs.core.cst$sym$historyComparator], null);
}));

(fluree.db.index.IndexConfig.cljs$lang$type = true);

(fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
}));

(fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"fluree.db.index/IndexConfig");
}));

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__37019){
var extmap__4454__auto__ = (function (){var G__37035 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__37019,cljs.core.cst$kw$index_DASH_type,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], 0));
if(cljs.core.record_QMARK_(G__37019)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__37035);
} else {
return G__37035;
}
})();
return (new fluree.db.index.IndexConfig(cljs.core.cst$kw$index_DASH_type.cljs$core$IFn$_invoke$arity$1(G__37019),cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(G__37019),cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(G__37019),null,cljs.core.not_empty(extmap__4454__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k37038,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__37042 = k37038;
var G__37042__$1 = (((G__37042 instanceof cljs.core.Keyword))?G__37042.fqn:null);
switch (G__37042__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k37038,else__4418__auto__);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__37043){
var vec__37044 = p__37043;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37044,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37044,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$children,self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__37037){
var self__ = this;
var G__37037__$1 = this;
return (new cljs.core.RecordIter((0),G__37037__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37048){
var state_val_37049 = (state_37048[(1)]);
if((state_val_37049 === (1))){
var state_37048__$1 = state_37048;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37048__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__13883__auto__ = null;
var fluree$db$index$state_machine__13883__auto____0 = (function (){
var statearr_37050 = [null,null,null,null,null,null,null];
(statearr_37050[(0)] = fluree$db$index$state_machine__13883__auto__);

(statearr_37050[(1)] = (1));

return statearr_37050;
});
var fluree$db$index$state_machine__13883__auto____1 = (function (state_37048){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37048);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37051){var ex__13886__auto__ = e37051;
var statearr_37052_37163 = state_37048;
(statearr_37052_37163[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37048[(4)]))){
var statearr_37053_37164 = state_37048;
(statearr_37053_37164[(1)] = cljs.core.first((state_37048[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37165 = state_37048;
state_37048 = G__37165;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$index$state_machine__13883__auto__ = function(state_37048){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__13883__auto____1.call(this,state_37048);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__13883__auto____0;
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__13883__auto____1;
return fluree$db$index$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37054 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37054[(6)] = c__13957__auto__);

return statearr_37054;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key(cljs.core.first(self__.children));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (6 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val((function (){var or__4160__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.first(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val((function (){var or__4160__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.last(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37079){
var state_val_37080 = (state_37079[(1)]);
if((state_val_37080 === (7))){
var inst_37061 = (state_37079[(7)]);
var inst_37065 = fluree.db.dbproto._resolve(inst_37061);
var state_37079__$1 = state_37079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37079__$1,(10),inst_37065);
} else {
if((state_val_37080 === (1))){
var state_37079__$1 = state_37079;
var statearr_37081_37166 = state_37079__$1;
(statearr_37081_37166[(2)] = null);

(statearr_37081_37166[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37080 === (4))){
var inst_37055 = (state_37079[(2)]);
var state_37079__$1 = state_37079;
var statearr_37082_37167 = state_37079__$1;
(statearr_37082_37167[(2)] = inst_37055);

(statearr_37082_37167[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37080 === (6))){
var inst_37061 = (state_37079[(7)]);
var state_37079__$1 = state_37079;
var statearr_37083_37168 = state_37079__$1;
(statearr_37083_37168[(2)] = inst_37061);

(statearr_37083_37168[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37080 === (3))){
var inst_37077 = (state_37079[(2)]);
var state_37079__$1 = state_37079;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37079__$1,inst_37077);
} else {
if((state_val_37080 === (2))){
var inst_37061 = (state_37079[(7)]);
var _ = (function (){var statearr_37085 = state_37079;
(statearr_37085[(4)] = cljs.core.cons((5),(state_37079[(4)])));

return statearr_37085;
})();
var inst_37061__$1 = this$__$1.fluree$db$dbproto$INode$_lookup$arity$2(null,flake);
var inst_37062 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_37061__$1);
var state_37079__$1 = (function (){var statearr_37086 = state_37079;
(statearr_37086[(7)] = inst_37061__$1);

return statearr_37086;
})();
if(cljs.core.truth_(inst_37062)){
var statearr_37087_37169 = state_37079__$1;
(statearr_37087_37169[(1)] = (6));

} else {
var statearr_37088_37170 = state_37079__$1;
(statearr_37088_37170[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37080 === (9))){
var inst_37071 = (state_37079[(2)]);
var inst_37072 = fluree.db.util.async.throw_err(inst_37071);
var state_37079__$1 = state_37079;
var statearr_37089_37171 = state_37079__$1;
(statearr_37089_37171[(2)] = inst_37072);

(statearr_37089_37171[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37080 === (5))){
var _ = (function (){var statearr_37090 = state_37079;
(statearr_37090[(4)] = cljs.core.rest((state_37079[(4)])));

return statearr_37090;
})();
var state_37079__$1 = state_37079;
var ex37084 = (state_37079__$1[(2)]);
var statearr_37091_37172 = state_37079__$1;
(statearr_37091_37172[(5)] = ex37084);


if((ex37084 instanceof Error)){
var statearr_37092_37173 = state_37079__$1;
(statearr_37092_37173[(1)] = (4));

(statearr_37092_37173[(5)] = null);

} else {
throw ex37084;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37080 === (10))){
var inst_37067 = (state_37079[(2)]);
var inst_37068 = fluree.db.util.async.throw_err(inst_37067);
var inst_37069 = fluree.db.dbproto._lookup_leaf(inst_37068,flake);
var state_37079__$1 = state_37079;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37079__$1,(9),inst_37069);
} else {
if((state_val_37080 === (8))){
var inst_37074 = (state_37079[(2)]);
var _ = (function (){var statearr_37093 = state_37079;
(statearr_37093[(4)] = cljs.core.rest((state_37079[(4)])));

return statearr_37093;
})();
var state_37079__$1 = state_37079;
var statearr_37094_37174 = state_37079__$1;
(statearr_37094_37174[(2)] = inst_37074);

(statearr_37094_37174[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__13883__auto__ = null;
var fluree$db$index$state_machine__13883__auto____0 = (function (){
var statearr_37095 = [null,null,null,null,null,null,null,null];
(statearr_37095[(0)] = fluree$db$index$state_machine__13883__auto__);

(statearr_37095[(1)] = (1));

return statearr_37095;
});
var fluree$db$index$state_machine__13883__auto____1 = (function (state_37079){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37079);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37096){var ex__13886__auto__ = e37096;
var statearr_37097_37175 = state_37079;
(statearr_37097_37175[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37079[(4)]))){
var statearr_37098_37176 = state_37079;
(statearr_37098_37176[(1)] = cljs.core.first((state_37079[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37177 = state_37079;
state_37079 = G__37177;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$index$state_machine__13883__auto__ = function(state_37079){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__13883__auto____1.call(this,state_37079);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__13883__auto____0;
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__13883__auto____1;
return fluree$db$index$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37099 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37099[(6)] = c__13957__auto__);

return statearr_37099;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37124){
var state_val_37125 = (state_37124[(1)]);
if((state_val_37125 === (7))){
var inst_37106 = (state_37124[(7)]);
var inst_37110 = fluree.db.dbproto._resolve(inst_37106);
var state_37124__$1 = state_37124;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37124__$1,(10),inst_37110);
} else {
if((state_val_37125 === (1))){
var state_37124__$1 = state_37124;
var statearr_37126_37178 = state_37124__$1;
(statearr_37126_37178[(2)] = null);

(statearr_37126_37178[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37125 === (4))){
var inst_37100 = (state_37124[(2)]);
var state_37124__$1 = state_37124;
var statearr_37127_37179 = state_37124__$1;
(statearr_37127_37179[(2)] = inst_37100);

(statearr_37127_37179[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37125 === (6))){
var inst_37106 = (state_37124[(7)]);
var state_37124__$1 = state_37124;
var statearr_37128_37180 = state_37124__$1;
(statearr_37128_37180[(2)] = inst_37106);

(statearr_37128_37180[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37125 === (3))){
var inst_37122 = (state_37124[(2)]);
var state_37124__$1 = state_37124;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37124__$1,inst_37122);
} else {
if((state_val_37125 === (2))){
var inst_37106 = (state_37124[(7)]);
var _ = (function (){var statearr_37130 = state_37124;
(statearr_37130[(4)] = cljs.core.cons((5),(state_37124[(4)])));

return statearr_37130;
})();
var inst_37106__$1 = this$__$1.fluree$db$dbproto$INode$_lookup_after$arity$2(null,flake);
var inst_37107 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_37106__$1);
var state_37124__$1 = (function (){var statearr_37131 = state_37124;
(statearr_37131[(7)] = inst_37106__$1);

return statearr_37131;
})();
if(cljs.core.truth_(inst_37107)){
var statearr_37132_37181 = state_37124__$1;
(statearr_37132_37181[(1)] = (6));

} else {
var statearr_37133_37182 = state_37124__$1;
(statearr_37133_37182[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37125 === (9))){
var inst_37116 = (state_37124[(2)]);
var inst_37117 = fluree.db.util.async.throw_err(inst_37116);
var state_37124__$1 = state_37124;
var statearr_37134_37183 = state_37124__$1;
(statearr_37134_37183[(2)] = inst_37117);

(statearr_37134_37183[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37125 === (5))){
var _ = (function (){var statearr_37135 = state_37124;
(statearr_37135[(4)] = cljs.core.rest((state_37124[(4)])));

return statearr_37135;
})();
var state_37124__$1 = state_37124;
var ex37129 = (state_37124__$1[(2)]);
var statearr_37136_37184 = state_37124__$1;
(statearr_37136_37184[(5)] = ex37129);


if((ex37129 instanceof Error)){
var statearr_37137_37185 = state_37124__$1;
(statearr_37137_37185[(1)] = (4));

(statearr_37137_37185[(5)] = null);

} else {
throw ex37129;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37125 === (10))){
var inst_37112 = (state_37124[(2)]);
var inst_37113 = fluree.db.util.async.throw_err(inst_37112);
var inst_37114 = fluree.db.dbproto._lookup_leaf_after(inst_37113,flake);
var state_37124__$1 = state_37124;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37124__$1,(9),inst_37114);
} else {
if((state_val_37125 === (8))){
var inst_37119 = (state_37124[(2)]);
var _ = (function (){var statearr_37138 = state_37124;
(statearr_37138[(4)] = cljs.core.rest((state_37124[(4)])));

return statearr_37138;
})();
var state_37124__$1 = state_37124;
var statearr_37139_37186 = state_37124__$1;
(statearr_37139_37186[(2)] = inst_37119);

(statearr_37139_37186[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__13883__auto__ = null;
var fluree$db$index$state_machine__13883__auto____0 = (function (){
var statearr_37140 = [null,null,null,null,null,null,null,null];
(statearr_37140[(0)] = fluree$db$index$state_machine__13883__auto__);

(statearr_37140[(1)] = (1));

return statearr_37140;
});
var fluree$db$index$state_machine__13883__auto____1 = (function (state_37124){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37124);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37141){var ex__13886__auto__ = e37141;
var statearr_37142_37187 = state_37124;
(statearr_37142_37187[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37124[(4)]))){
var statearr_37143_37188 = state_37124;
(statearr_37143_37188[(1)] = cljs.core.first((state_37124[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37189 = state_37124;
state_37124 = G__37189;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$index$state_machine__13883__auto__ = function(state_37124){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__13883__auto____1.call(this,state_37124);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__13883__auto____0;
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__13883__auto____1;
return fluree$db$index$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37144 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37144[(6)] = c__13957__auto__);

return statearr_37144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (){var fexpr__37145 = (function (coll__4412__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
});
return fexpr__37145(this__4411__auto____$1);
})();
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this37039,other37040){
var self__ = this;
var this37039__$1 = this;
return (((!((other37040 == null)))) && ((this37039__$1.constructor === other37040.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37039__$1.block,other37040.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37039__$1.t,other37040.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37039__$1.rhs,other37040.rhs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37039__$1.children,other37040.children)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37039__$1.config,other37040.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37039__$1.leftmost_QMARK_,other37040.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37039__$1.__extmap,other37040.__extmap)));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$children,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$rhs,null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__37037){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__37146 = cljs.core.keyword_identical_QMARK_;
var expr__37147 = k__4423__auto__;
if(cljs.core.truth_((function (){var G__37149 = cljs.core.cst$kw$block;
var G__37150 = expr__37147;
return (pred__37146.cljs$core$IFn$_invoke$arity$2 ? pred__37146.cljs$core$IFn$_invoke$arity$2(G__37149,G__37150) : pred__37146.call(null,G__37149,G__37150));
})())){
return (new fluree.db.index.IndexNode(G__37037,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37151 = cljs.core.cst$kw$t;
var G__37152 = expr__37147;
return (pred__37146.cljs$core$IFn$_invoke$arity$2 ? pred__37146.cljs$core$IFn$_invoke$arity$2(G__37151,G__37152) : pred__37146.call(null,G__37151,G__37152));
})())){
return (new fluree.db.index.IndexNode(self__.block,G__37037,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37153 = cljs.core.cst$kw$rhs;
var G__37154 = expr__37147;
return (pred__37146.cljs$core$IFn$_invoke$arity$2 ? pred__37146.cljs$core$IFn$_invoke$arity$2(G__37153,G__37154) : pred__37146.call(null,G__37153,G__37154));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__37037,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37155 = cljs.core.cst$kw$children;
var G__37156 = expr__37147;
return (pred__37146.cljs$core$IFn$_invoke$arity$2 ? pred__37146.cljs$core$IFn$_invoke$arity$2(G__37155,G__37156) : pred__37146.call(null,G__37155,G__37156));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__37037,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37157 = cljs.core.cst$kw$config;
var G__37158 = expr__37147;
return (pred__37146.cljs$core$IFn$_invoke$arity$2 ? pred__37146.cljs$core$IFn$_invoke$arity$2(G__37157,G__37158) : pred__37146.call(null,G__37157,G__37158));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__37037,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37159 = cljs.core.cst$kw$leftmost_QMARK_;
var G__37160 = expr__37147;
return (pred__37146.cljs$core$IFn$_invoke$arity$2 ? pred__37146.cljs$core$IFn$_invoke$arity$2(G__37159,G__37160) : pred__37146.call(null,G__37159,G__37160));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__37037,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__37037),null));
}
}
}
}
}
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$children,self__.children,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__37037){
var self__ = this;
var this__4414__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__37037,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$rhs,cljs.core.cst$sym$children,cljs.core.cst$sym$config,cljs.core.cst$sym$leftmost_QMARK_], null);
}));

(fluree.db.index.IndexNode.cljs$lang$type = true);

(fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
}));

(fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"fluree.db.index/IndexNode");
}));

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__37041){
var extmap__4454__auto__ = (function (){var G__37161 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__37041,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], 0));
if(cljs.core.record_QMARK_(G__37041)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__37161);
} else {
return G__37161;
}
})();
return (new fluree.db.index.IndexNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__37041),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__37041),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__37041),cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(G__37041),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__37041),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__37041),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4415__auto__,k__4416__auto__){
var self__ = this;
var this__4415__auto____$1 = this;
return this__4415__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4416__auto__,null);
}));

(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4417__auto__,k37191,else__4418__auto__){
var self__ = this;
var this__4417__auto____$1 = this;
var G__37195 = k37191;
var G__37195__$1 = (((G__37195 instanceof cljs.core.Keyword))?G__37195.fqn:null);
switch (G__37195__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k37191,else__4418__auto__);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4434__auto__,f__4435__auto__,init__4436__auto__){
var self__ = this;
var this__4434__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4437__auto__,p__37196){
var vec__37197 = p__37196;
var k__4438__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37197,(0),null);
var v__4439__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37197,(1),null);
return (f__4435__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4435__auto__.cljs$core$IFn$_invoke$arity$3(ret__4437__auto__,k__4438__auto__,v__4439__auto__) : f__4435__auto__.call(null,ret__4437__auto__,k__4438__auto__,v__4439__auto__));
}),init__4436__auto__,this__4434__auto____$1);
}));

(fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4429__auto__,writer__4430__auto__,opts__4431__auto__){
var self__ = this;
var this__4429__auto____$1 = this;
var pr_pair__4432__auto__ = (function (keyval__4433__auto__){
return cljs.core.pr_sequential_writer(writer__4430__auto__,cljs.core.pr_writer,""," ","",opts__4431__auto__,keyval__4433__auto__);
});
return cljs.core.pr_sequential_writer(writer__4430__auto__,pr_pair__4432__auto__,"#fluree.db.index.DataNode{",", ","}",opts__4431__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$flakes,self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__37190){
var self__ = this;
var G__37190__$1 = this;
return (new cljs.core.RecordIter((0),G__37190__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37201){
var state_val_37202 = (state_37201[(1)]);
if((state_val_37202 === (1))){
var state_37201__$1 = state_37201;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37201__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__13883__auto__ = null;
var fluree$db$index$state_machine__13883__auto____0 = (function (){
var statearr_37203 = [null,null,null,null,null,null,null];
(statearr_37203[(0)] = fluree$db$index$state_machine__13883__auto__);

(statearr_37203[(1)] = (1));

return statearr_37203;
});
var fluree$db$index$state_machine__13883__auto____1 = (function (state_37201){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37201);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37204){var ex__13886__auto__ = e37204;
var statearr_37205_37236 = state_37201;
(statearr_37205_37236[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37201[(4)]))){
var statearr_37206_37237 = state_37201;
(statearr_37206_37237[(1)] = cljs.core.first((state_37201[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37238 = state_37201;
state_37201 = G__37238;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$index$state_machine__13883__auto__ = function(state_37201){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__13883__auto____1.call(this,state_37201);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__13883__auto____0;
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__13883__auto____1;
return fluree$db$index$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37207 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37207[(6)] = c__13957__auto__);

return statearr_37207;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first(self__.flakes);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4413__auto__){
var self__ = this;
var this__4413__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4410__auto__){
var self__ = this;
var this__4410__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4419__auto__){
var self__ = this;
var this__4419__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["-lookup-leaf was called on a data node, which shouldn't happen!"], 0));

var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_37213){
var state_val_37214 = (state_37213[(1)]);
if((state_val_37214 === (1))){
var inst_37208 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_37209 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_37210 = cljs.core.PersistentHashMap.fromArrays(inst_37208,inst_37209);
var inst_37211 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup-leaf was called on a data node, which shouldn't happen!",inst_37210);
var state_37213__$1 = state_37213;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37213__$1,inst_37211);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__13883__auto__ = null;
var fluree$db$index$state_machine__13883__auto____0 = (function (){
var statearr_37215 = [null,null,null,null,null,null,null];
(statearr_37215[(0)] = fluree$db$index$state_machine__13883__auto__);

(statearr_37215[(1)] = (1));

return statearr_37215;
});
var fluree$db$index$state_machine__13883__auto____1 = (function (state_37213){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_37213);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e37216){var ex__13886__auto__ = e37216;
var statearr_37217_37239 = state_37213;
(statearr_37217_37239[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_37213[(4)]))){
var statearr_37218_37240 = state_37213;
(statearr_37218_37240[(1)] = cljs.core.first((state_37213[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__37241 = state_37213;
state_37213 = G__37241;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$index$state_machine__13883__auto__ = function(state_37213){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__13883__auto____1.call(this,state_37213);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__13883__auto____0;
fluree$db$index$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__13883__auto____1;
return fluree$db$index$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_37219 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_37219[(6)] = c__13957__auto__);

return statearr_37219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4411__auto__){
var self__ = this;
var this__4411__auto____$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = (function (){var fexpr__37220 = (function (coll__4412__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll(coll__4412__auto__));
});
return fexpr__37220(this__4411__auto____$1);
})();
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this37192,other37193){
var self__ = this;
var this37192__$1 = this;
return (((!((other37193 == null)))) && ((this37192__$1.constructor === other37193.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37192__$1.block,other37193.block)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37192__$1.t,other37193.t)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37192__$1.flakes,other37193.flakes)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37192__$1.rhs,other37193.rhs)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37192__$1.config,other37193.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this37192__$1.__extmap,other37193.__extmap)));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4424__auto__,k__4425__auto__){
var self__ = this;
var this__4424__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$flakes,null,cljs.core.cst$kw$rhs,null], null), null),k__4425__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4424__auto____$1),self__.__meta),k__4425__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4425__auto__)),null));
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4422__auto__,k__4423__auto__,G__37190){
var self__ = this;
var this__4422__auto____$1 = this;
var pred__37221 = cljs.core.keyword_identical_QMARK_;
var expr__37222 = k__4423__auto__;
if(cljs.core.truth_((function (){var G__37224 = cljs.core.cst$kw$block;
var G__37225 = expr__37222;
return (pred__37221.cljs$core$IFn$_invoke$arity$2 ? pred__37221.cljs$core$IFn$_invoke$arity$2(G__37224,G__37225) : pred__37221.call(null,G__37224,G__37225));
})())){
return (new fluree.db.index.DataNode(G__37190,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37226 = cljs.core.cst$kw$t;
var G__37227 = expr__37222;
return (pred__37221.cljs$core$IFn$_invoke$arity$2 ? pred__37221.cljs$core$IFn$_invoke$arity$2(G__37226,G__37227) : pred__37221.call(null,G__37226,G__37227));
})())){
return (new fluree.db.index.DataNode(self__.block,G__37190,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37228 = cljs.core.cst$kw$flakes;
var G__37229 = expr__37222;
return (pred__37221.cljs$core$IFn$_invoke$arity$2 ? pred__37221.cljs$core$IFn$_invoke$arity$2(G__37228,G__37229) : pred__37221.call(null,G__37228,G__37229));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__37190,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37230 = cljs.core.cst$kw$rhs;
var G__37231 = expr__37222;
return (pred__37221.cljs$core$IFn$_invoke$arity$2 ? pred__37221.cljs$core$IFn$_invoke$arity$2(G__37230,G__37231) : pred__37221.call(null,G__37230,G__37231));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__37190,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__37232 = cljs.core.cst$kw$config;
var G__37233 = expr__37222;
return (pred__37221.cljs$core$IFn$_invoke$arity$2 ? pred__37221.cljs$core$IFn$_invoke$arity$2(G__37232,G__37233) : pred__37221.call(null,G__37232,G__37233));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__37190,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4423__auto__,G__37190),null));
}
}
}
}
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4427__auto__){
var self__ = this;
var this__4427__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$flakes,self__.flakes,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4414__auto__,G__37190){
var self__ = this;
var this__4414__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__37190,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4420__auto__,entry__4421__auto__){
var self__ = this;
var this__4420__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4421__auto__)){
return this__4420__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4421__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4420__auto____$1,entry__4421__auto__);
}
}));

(fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$flakes,cljs.core.cst$sym$rhs,cljs.core.cst$sym$config], null);
}));

(fluree.db.index.DataNode.cljs$lang$type = true);

(fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__4458__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
}));

(fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__4458__auto__,writer__4459__auto__){
return cljs.core._write(writer__4459__auto__,"fluree.db.index/DataNode");
}));

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__37194){
var extmap__4454__auto__ = (function (){var G__37234 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__37194,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], 0));
if(cljs.core.record_QMARK_(G__37194)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__37234);
} else {
return G__37234;
}
})();
return (new fluree.db.index.DataNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__37194),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__37194),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(G__37194),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__37194),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__37194),null,cljs.core.not_empty(extmap__4454__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode(block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});
