// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__40178 = arguments.length;
switch (G__40178) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$op,operation,cljs.core.cst$kw$req_DASH_id,req_id,cljs.core.cst$kw$timestamp,fluree.db.util.core.current_time_millis(),cljs.core.cst$kw$timeout,timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__40181 = arguments.length;
switch (G__40181) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__13957__auto___40234 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_40212){
var state_val_40213 = (state_40212[(1)]);
if((state_val_40213 === (1))){
var state_40212__$1 = state_40212;
var statearr_40214_40235 = state_40212__$1;
(statearr_40214_40235[(2)] = null);

(statearr_40214_40235[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40213 === (2))){
var _ = (function (){var statearr_40215 = state_40212;
(statearr_40215[(4)] = cljs.core.cons((5),(state_40212[(4)])));

return statearr_40215;
})();
var inst_40189 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_40212__$1 = state_40212;
if(cljs.core.truth_(inst_40189)){
var statearr_40216_40236 = state_40212__$1;
(statearr_40216_40236[(1)] = (6));

} else {
var statearr_40217_40237 = state_40212__$1;
(statearr_40217_40237[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40213 === (3))){
var inst_40210 = (state_40212[(2)]);
var state_40212__$1 = state_40212;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40212__$1,inst_40210);
} else {
if((state_val_40213 === (4))){
var inst_40182 = (state_40212[(2)]);
var inst_40183 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_40182);
var state_40212__$1 = state_40212;
var statearr_40219_40238 = state_40212__$1;
(statearr_40219_40238[(2)] = inst_40183);

(statearr_40219_40238[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40213 === (5))){
var _ = (function (){var statearr_40220 = state_40212;
(statearr_40220[(4)] = cljs.core.rest((state_40212[(4)])));

return statearr_40220;
})();
var state_40212__$1 = state_40212;
var ex40218 = (state_40212__$1[(2)]);
var statearr_40221_40239 = state_40212__$1;
(statearr_40221_40239[(5)] = ex40218);


var statearr_40222_40240 = state_40212__$1;
(statearr_40222_40240[(1)] = (4));

(statearr_40222_40240[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_40213 === (6))){
var inst_40191 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_40192 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_connection];
var inst_40193 = cljs.core.PersistentHashMap.fromArrays(inst_40191,inst_40192);
var inst_40194 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_40193);
var inst_40195 = (function(){throw inst_40194})();
var state_40212__$1 = state_40212;
var statearr_40223_40241 = state_40212__$1;
(statearr_40223_40241[(2)] = inst_40195);

(statearr_40223_40241[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40213 === (7))){
var inst_40197 = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_40198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40199 = [operation,data,pc,opts];
var inst_40200 = (new cljs.core.PersistentVector(null,4,(5),inst_40198,inst_40199,null));
var inst_40201 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_40197,inst_40200);
var inst_40202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40203 = [operation,data,pc,opts];
var inst_40204 = (new cljs.core.PersistentVector(null,4,(5),inst_40202,inst_40203,null));
var inst_40205 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_40204], 0));
var state_40212__$1 = (function (){var statearr_40224 = state_40212;
(statearr_40224[(7)] = inst_40201);

return statearr_40224;
})();
var statearr_40225_40242 = state_40212__$1;
(statearr_40225_40242[(2)] = inst_40205);

(statearr_40225_40242[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40213 === (8))){
var inst_40207 = (state_40212[(2)]);
var _ = (function (){var statearr_40226 = state_40212;
(statearr_40226[(4)] = cljs.core.rest((state_40212[(4)])));

return statearr_40226;
})();
var state_40212__$1 = state_40212;
var statearr_40227_40243 = state_40212__$1;
(statearr_40227_40243[(2)] = inst_40207);

(statearr_40227_40243[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__13883__auto__ = null;
var fluree$db$operations$state_machine__13883__auto____0 = (function (){
var statearr_40228 = [null,null,null,null,null,null,null,null];
(statearr_40228[(0)] = fluree$db$operations$state_machine__13883__auto__);

(statearr_40228[(1)] = (1));

return statearr_40228;
});
var fluree$db$operations$state_machine__13883__auto____1 = (function (state_40212){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_40212);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e40229){var ex__13886__auto__ = e40229;
var statearr_40230_40244 = state_40212;
(statearr_40230_40244[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_40212[(4)]))){
var statearr_40231_40245 = state_40212;
(statearr_40231_40245[(1)] = cljs.core.first((state_40212[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40246 = state_40212;
state_40212 = G__40246;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$operations$state_machine__13883__auto__ = function(state_40212){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__13883__auto____1.call(this,state_40212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__13883__auto____0;
fluree$db$operations$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__13883__auto____1;
return fluree$db$operations$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_40232 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_40232[(6)] = c__13957__auto___40234);

return statearr_40232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__40248 = arguments.length;
switch (G__40248) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__40249){
var map__40250 = p__40249;
var map__40250__$1 = cljs.core.__destructure_map(map__40250);
var opts = map__40250__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40250__$1,cljs.core.cst$kw$snapshot_QMARK_);
var map__40251 = session;
var map__40251__$1 = cljs.core.__destructure_map(map__40251);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40251__$1,cljs.core.cst$kw$dbid);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40251__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40251__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$delete_DASH_db,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$snapshot_QMARK_,snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4777__auto__ = [];
var len__4771__auto___40278 = arguments.length;
var i__4772__auto___40279 = (0);
while(true){
if((i__4772__auto___40279 < len__4771__auto___40278)){
args__4777__auto__.push((arguments[i__4772__auto___40279]));

var G__40280 = (i__4772__auto___40279 + (1));
i__4772__auto___40279 = G__40280;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__40255){
var vec__40256 = p__40255;
var map__40259 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40256,(0),null);
var map__40259__$1 = cljs.core.__destructure_map(map__40259);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40259__$1,cljs.core.cst$kw$toBlock);
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40259__$1,cljs.core.cst$kw$toTime);
var opts = vec__40256;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_40271){
var state_val_40272 = (state_40271[(1)]);
if((state_val_40272 === (1))){
var inst_40261 = session;
var inst_40262 = cljs.core.__destructure_map(inst_40261);
var inst_40263 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40262,cljs.core.cst$kw$network);
var inst_40264 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40262,cljs.core.cst$kw$dbid);
var inst_40265 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40262,cljs.core.cst$kw$conn);
var inst_40266 = [cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$toBlock,cljs.core.cst$kw$toTime];
var inst_40267 = [inst_40263,inst_40264,toBlock,toTime];
var inst_40268 = cljs.core.PersistentHashMap.fromArrays(inst_40266,inst_40267);
var inst_40269 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_40265,cljs.core.cst$kw$garbage,inst_40268);
var state_40271__$1 = state_40271;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40271__$1,inst_40269);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__13883__auto__ = null;
var fluree$db$operations$state_machine__13883__auto____0 = (function (){
var statearr_40273 = [null,null,null,null,null,null,null];
(statearr_40273[(0)] = fluree$db$operations$state_machine__13883__auto__);

(statearr_40273[(1)] = (1));

return statearr_40273;
});
var fluree$db$operations$state_machine__13883__auto____1 = (function (state_40271){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_40271);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e40274){var ex__13886__auto__ = e40274;
var statearr_40275_40281 = state_40271;
(statearr_40275_40281[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_40271[(4)]))){
var statearr_40276_40282 = state_40271;
(statearr_40276_40282[(1)] = cljs.core.first((state_40271[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__40283 = state_40271;
state_40271 = G__40283;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$operations$state_machine__13883__auto__ = function(state_40271){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__13883__auto____1.call(this,state_40271);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__13883__auto____0;
fluree$db$operations$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__13883__auto____1;
return fluree$db$operations$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_40277 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_40277[(6)] = c__13957__auto__);

return statearr_40277;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq40253){
var G__40254 = cljs.core.first(seq40253);
var seq40253__$1 = cljs.core.next(seq40253);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__40254,seq40253__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__40284 = session;
var map__40284__$1 = cljs.core.__destructure_map(map__40284);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40284__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40284__$1,cljs.core.cst$kw$dbid);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40284__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$snapshot_DASH_db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$cmd,cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsigned_DASH_cmd,unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_stats,ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$db_DASH_list,null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$tx,tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__40286 = arguments.length;
switch (G__40286) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__40287 = opts;
var map__40287__$1 = cljs.core.__destructure_map(map__40287);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40287__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40287__$1,cljs.core.cst$kw$jwt);
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4160__auto__ = auth;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$subscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsbuscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null));
});
