// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__33235 = arguments.length;
switch (G__33235) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__33237 = null;
var G__33237__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__33237__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__33237__2 = (function (result,flake){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + fuel_per));

if(cljs.core.truth_((function (){var and__4149__auto__ = max_fuel;
if(cljs.core.truth_(and__4149__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4149__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__33237 = function(result,flake){
switch(arguments.length){
case 0:
return G__33237__0.call(this);
case 1:
return G__33237__1.call(this,result);
case 2:
return G__33237__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33237.cljs$core$IFn$_invoke$arity$0 = G__33237__0;
G__33237.cljs$core$IFn$_invoke$arity$1 = G__33237__1;
G__33237.cljs$core$IFn$_invoke$arity$2 = G__33237__2;
return G__33237;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__33238 = null;
var G__33238__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__33238__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__33238__2 = (function (result,flakes){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + cljs.core.count(flakes)));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__33238 = function(result,flakes){
switch(arguments.length){
case 0:
return G__33238__0.call(this);
case 1:
return G__33238__1.call(this,result);
case 2:
return G__33238__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33238.cljs$core$IFn$_invoke$arity$0 = G__33238__0;
G__33238.cljs$core$IFn$_invoke$arity$1 = G__33238__1;
G__33238.cljs$core$IFn$_invoke$arity$2 = G__33238__2;
return G__33238;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + n));

if(cljs.core.truth_((function (){var and__4149__auto__ = max_fuel;
if(cljs.core.truth_(and__4149__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4149__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4160__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
cljs.core._vreset_BANG_(cache,cljs.core.assoc_in(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map));

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__33240 = res;
var G__33240__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__33239_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__33239_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__33240):G__33240);
var G__33240__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__33240__$1):G__33240__$1);
var G__33240__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__33240__$2):G__33240__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__33240__$3);
} else {
return G__33240__$3;
}
} else {
return res;
}
});
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__33242 = arguments.length;
switch (G__33242) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flake,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_33525){
var state_val_33526 = (state_33525[(1)]);
if((state_val_33526 === (65))){
var inst_33410 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
if(cljs.core.truth_(inst_33410)){
var statearr_33527_33681 = state_33525__$1;
(statearr_33527_33681[(1)] = (66));

} else {
var statearr_33528_33682 = state_33525__$1;
(statearr_33528_33682[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (70))){
var inst_33426 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33427 = [cljs.core.cst$kw$_id];
var inst_33428 = flake.o;
var inst_33429 = [inst_33428];
var inst_33430 = cljs.core.PersistentHashMap.fromArrays(inst_33427,inst_33429);
var inst_33431 = [inst_33430,offset_map];
var inst_33432 = (new cljs.core.PersistentVector(null,2,(5),inst_33426,inst_33431,null));
var state_33525__$1 = state_33525;
var statearr_33529_33683 = state_33525__$1;
(statearr_33529_33683[(2)] = inst_33432);

(statearr_33529_33683[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (62))){
var inst_33272 = (state_33525[(7)]);
var inst_33390 = (state_33525[(2)]);
var inst_33391 = fluree.db.util.async.throw_err(inst_33390);
var inst_33392 = cljs.core._deref(cache);
var inst_33393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33394 = flake.o;
var inst_33395 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_33272);
var inst_33396 = [inst_33394,inst_33395];
var inst_33397 = (new cljs.core.PersistentVector(null,2,(5),inst_33393,inst_33396,null));
var inst_33398 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33392,inst_33397,inst_33391);
var inst_33399 = cljs.core._vreset_BANG_(cache,inst_33398);
var state_33525__$1 = (function (){var statearr_33530 = state_33525;
(statearr_33530[(8)] = inst_33399);

return statearr_33530;
})();
var statearr_33531_33684 = state_33525__$1;
(statearr_33531_33684[(2)] = inst_33391);

(statearr_33531_33684[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (74))){
var inst_33423 = (state_33525[(9)]);
var inst_33437 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_33438 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_33437,inst_33423);
var state_33525__$1 = state_33525;
var statearr_33532_33685 = state_33525__$1;
(statearr_33532_33685[(2)] = inst_33438);

(statearr_33532_33685[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (7))){
var inst_33253 = (state_33525[(10)]);
var state_33525__$1 = state_33525;
var statearr_33533_33686 = state_33525__$1;
(statearr_33533_33686[(2)] = inst_33253);

(statearr_33533_33686[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (59))){
var inst_33383 = (state_33525[(11)]);
var state_33525__$1 = state_33525;
var statearr_33534_33687 = state_33525__$1;
(statearr_33534_33687[(2)] = inst_33383);

(statearr_33534_33687[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (86))){
var inst_33285 = (state_33525[(12)]);
var state_33525__$1 = state_33525;
var statearr_33535_33688 = state_33525__$1;
(statearr_33535_33688[(2)] = inst_33285);

(statearr_33535_33688[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (20))){
var inst_33281 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
var statearr_33536_33689 = state_33525__$1;
(statearr_33536_33689[(2)] = inst_33281);

(statearr_33536_33689[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (72))){
var inst_33454 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
var statearr_33537_33690 = state_33525__$1;
(statearr_33537_33690[(2)] = inst_33454);

(statearr_33537_33690[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (58))){
var inst_33478 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
var statearr_33538_33691 = state_33525__$1;
(statearr_33538_33691[(2)] = inst_33478);

(statearr_33538_33691[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (60))){
var inst_33272 = (state_33525[(7)]);
var inst_33386 = flake.o;
var inst_33387 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_33272);
var inst_33388 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_33386,inst_33387);
var state_33525__$1 = state_33525;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33525__$1,(62),inst_33388);
} else {
if((state_val_33526 === (27))){
var inst_33290 = (state_33525[(13)]);
var inst_33304 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33305 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_33290);
var state_33525__$1 = (function (){var statearr_33539 = state_33525;
(statearr_33539[(14)] = inst_33304);

return statearr_33539;
})();
if(cljs.core.truth_(inst_33305)){
var statearr_33540_33692 = state_33525__$1;
(statearr_33540_33692[(1)] = (30));

} else {
var statearr_33541_33693 = state_33525__$1;
(statearr_33541_33693[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (1))){
var state_33525__$1 = state_33525;
var statearr_33542_33694 = state_33525__$1;
(statearr_33542_33694[(2)] = null);

(statearr_33542_33694[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (69))){
var inst_33423 = (state_33525[(9)]);
var inst_33422 = (state_33525[(2)]);
var inst_33423__$1 = fluree.db.util.async.throw_err(inst_33422);
var inst_33424 = cljs.core.empty_QMARK_(inst_33423__$1);
var state_33525__$1 = (function (){var statearr_33543 = state_33525;
(statearr_33543[(9)] = inst_33423__$1);

return statearr_33543;
})();
if(inst_33424){
var statearr_33544_33695 = state_33525__$1;
(statearr_33544_33695[(1)] = (70));

} else {
var statearr_33545_33696 = state_33525__$1;
(statearr_33545_33696[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (24))){
var inst_33290 = (state_33525[(13)]);
var inst_33289 = (state_33525[(15)]);
var inst_33293 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_33289);
var inst_33294 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_33290);
var inst_33295 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_33294);
var inst_33296 = ((inst_33293) && (inst_33295));
var state_33525__$1 = state_33525;
var statearr_33546_33697 = state_33525__$1;
(statearr_33546_33697[(2)] = inst_33296);

(statearr_33546_33697[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (55))){
var inst_33367 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33525__$1,(48),inst_33367);
} else {
if((state_val_33526 === (85))){
var inst_33472 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
var statearr_33547_33698 = state_33525__$1;
(statearr_33547_33698[(2)] = inst_33472);

(statearr_33547_33698[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (39))){
var inst_33332 = (state_33525[(16)]);
var inst_33272 = (state_33525[(7)]);
var inst_33332__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_33272);
var state_33525__$1 = (function (){var statearr_33548 = state_33525;
(statearr_33548[(16)] = inst_33332__$1);

return statearr_33548;
})();
if(cljs.core.truth_(inst_33332__$1)){
var statearr_33549_33699 = state_33525__$1;
(statearr_33549_33699[(1)] = (42));

} else {
var statearr_33550_33700 = state_33525__$1;
(statearr_33550_33700[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (88))){
var inst_33492 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
if(cljs.core.truth_(inst_33492)){
var statearr_33551_33701 = state_33525__$1;
(statearr_33551_33701[(1)] = (89));

} else {
var statearr_33552_33702 = state_33525__$1;
(statearr_33552_33702[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (46))){
var inst_33272 = (state_33525[(7)]);
var inst_33374 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_33272);
var state_33525__$1 = state_33525;
if(cljs.core.truth_(inst_33374)){
var statearr_33553_33703 = state_33525__$1;
(statearr_33553_33703[(1)] = (56));

} else {
var statearr_33554_33704 = state_33525__$1;
(statearr_33554_33704[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (4))){
var inst_33243 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
var statearr_33555_33705 = state_33525__$1;
(statearr_33555_33705[(2)] = inst_33243);

(statearr_33555_33705[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (77))){
var inst_33288 = (state_33525[(17)]);
var inst_33266 = (state_33525[(18)]);
var inst_33287 = (state_33525[(19)]);
var inst_33290 = (state_33525[(13)]);
var inst_33289 = (state_33525[(15)]);
var inst_33283 = (state_33525[(20)]);
var inst_33272 = (state_33525[(7)]);
var inst_33286 = (state_33525[(21)]);
var inst_33285 = (state_33525[(12)]);
var inst_33441 = (state_33525[(22)]);
var inst_33423 = (state_33525[(9)]);
var inst_33284 = (state_33525[(23)]);
var inst_33443 = (function (){var map__33249 = inst_33284;
var p = inst_33290;
var pred_spec__$1 = inst_33266;
var orderBy = inst_33288;
var children = inst_33423;
var multi_QMARK_ = inst_33285;
var limit = inst_33287;
var offset = inst_33289;
var G__33435 = inst_33441;
var k = inst_33283;
var pred_spec_SINGLEQUOTE_ = inst_33272;
var ref_QMARK_ = inst_33286;
return (function (n){
var G__33556 = db;
var G__33557 = cache;
var G__33558 = fuel;
var G__33559 = max_fuel;
var G__33560 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$wildcard_QMARK_,true], null);
var G__33561 = n;
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(G__33556,G__33557,G__33558,G__33559,G__33560,G__33561) : fluree.db.query.fql.flakes__GT_res.call(null,G__33556,G__33557,G__33558,G__33559,G__33560,G__33561));
});
})();
var inst_33444 = (inst_33443.cljs$core$IFn$_invoke$arity$1 ? inst_33443.cljs$core$IFn$_invoke$arity$1(inst_33441) : inst_33443.call(null,inst_33441));
var state_33525__$1 = state_33525;
var statearr_33562_33706 = state_33525__$1;
(statearr_33562_33706[(2)] = inst_33444);

(statearr_33562_33706[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (95))){
var inst_33486 = (state_33525[(24)]);
var inst_33511 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33512 = [acc,inst_33486];
var inst_33513 = (new cljs.core.PersistentVector(null,2,(5),inst_33511,inst_33512,null));
var state_33525__$1 = state_33525;
var statearr_33563_33707 = state_33525__$1;
(statearr_33563_33707[(2)] = inst_33513);

(statearr_33563_33707[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (54))){
var inst_33361 = (state_33525[(25)]);
var state_33525__$1 = state_33525;
var statearr_33564_33708 = state_33525__$1;
(statearr_33564_33708[(2)] = inst_33361);

(statearr_33564_33708[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (92))){
var inst_33283 = (state_33525[(20)]);
var inst_33485 = (state_33525[(26)]);
var inst_33486 = (state_33525[(24)]);
var inst_33505 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33506 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_33283,inst_33485);
var inst_33507 = [inst_33506,inst_33486];
var inst_33508 = (new cljs.core.PersistentVector(null,2,(5),inst_33505,inst_33507,null));
var state_33525__$1 = state_33525;
var statearr_33565_33709 = state_33525__$1;
(statearr_33565_33709[(2)] = inst_33508);

(statearr_33565_33709[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (15))){
var inst_33273 = (state_33525[(27)]);
var state_33525__$1 = state_33525;
var statearr_33566_33710 = state_33525__$1;
(statearr_33566_33710[(2)] = inst_33273);

(statearr_33566_33710[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (48))){
var inst_33346 = (state_33525[(28)]);
var inst_33369 = (state_33525[(2)]);
var inst_33370 = fluree.db.util.async.throw_err(inst_33369);
var inst_33371 = [inst_33370,offset_map];
var inst_33372 = (new cljs.core.PersistentVector(null,2,(5),inst_33346,inst_33371,null));
var state_33525__$1 = state_33525;
var statearr_33567_33711 = state_33525__$1;
(statearr_33567_33711[(2)] = inst_33372);

(statearr_33567_33711[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (50))){
var inst_33355 = (state_33525[(29)]);
var inst_33357 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_33358 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_33357,inst_33355);
var state_33525__$1 = state_33525;
var statearr_33568_33712 = state_33525__$1;
(statearr_33568_33712[(2)] = inst_33358);

(statearr_33568_33712[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (75))){
var inst_33423 = (state_33525[(9)]);
var state_33525__$1 = state_33525;
var statearr_33569_33713 = state_33525__$1;
(statearr_33569_33713[(2)] = inst_33423);

(statearr_33569_33713[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (21))){
var inst_33289 = (state_33525[(15)]);
var state_33525__$1 = state_33525;
if(cljs.core.truth_(inst_33289)){
var statearr_33570_33714 = state_33525__$1;
(statearr_33570_33714[(1)] = (24));

} else {
var statearr_33571_33715 = state_33525__$1;
(statearr_33571_33715[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (31))){
var inst_33290 = (state_33525[(13)]);
var inst_33289 = (state_33525[(15)]);
var inst_33309 = (inst_33289 - (1));
var inst_33310 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_33290,inst_33309);
var state_33525__$1 = state_33525;
var statearr_33572_33716 = state_33525__$1;
(statearr_33572_33716[(2)] = inst_33310);

(statearr_33572_33716[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (32))){
var inst_33304 = (state_33525[(14)]);
var inst_33312 = (state_33525[(2)]);
var inst_33313 = [null,inst_33312];
var inst_33314 = (new cljs.core.PersistentVector(null,2,(5),inst_33304,inst_33313,null));
var state_33525__$1 = state_33525;
var statearr_33573_33717 = state_33525__$1;
(statearr_33573_33717[(2)] = inst_33314);

(statearr_33573_33717[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (40))){
var state_33525__$1 = state_33525;
var statearr_33574_33718 = state_33525__$1;
(statearr_33574_33718[(2)] = false);

(statearr_33574_33718[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (91))){
var inst_33520 = (state_33525[(2)]);
var _ = (function (){var statearr_33575 = state_33525;
(statearr_33575[(4)] = cljs.core.rest((state_33525[(4)])));

return statearr_33575;
})();
var state_33525__$1 = state_33525;
var statearr_33576_33719 = state_33525__$1;
(statearr_33576_33719[(2)] = inst_33520);

(statearr_33576_33719[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (56))){
var inst_33383 = (state_33525[(11)]);
var inst_33272 = (state_33525[(7)]);
var inst_33376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33377 = cljs.core.deref(cache);
var inst_33378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33379 = flake.o;
var inst_33380 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_33272);
var inst_33381 = [inst_33379,inst_33380];
var inst_33382 = (new cljs.core.PersistentVector(null,2,(5),inst_33378,inst_33381,null));
var inst_33383__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33377,inst_33382);
var state_33525__$1 = (function (){var statearr_33577 = state_33525;
(statearr_33577[(11)] = inst_33383__$1);

(statearr_33577[(30)] = inst_33376);

return statearr_33577;
})();
if(cljs.core.truth_(inst_33383__$1)){
var statearr_33578_33720 = state_33525__$1;
(statearr_33578_33720[(1)] = (59));

} else {
var statearr_33579_33721 = state_33525__$1;
(statearr_33579_33721[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (33))){
var inst_33288 = (state_33525[(17)]);
var inst_33287 = (state_33525[(19)]);
var inst_33283 = (state_33525[(20)]);
var inst_33317 = cljs.core.not(inst_33288);
var inst_33318 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_33283);
var inst_33319 = cljs.core.count(inst_33318);
var inst_33320 = (inst_33319 >= inst_33287);
var inst_33321 = ((inst_33317) && (inst_33320));
var state_33525__$1 = state_33525;
var statearr_33580_33722 = state_33525__$1;
(statearr_33580_33722[(2)] = inst_33321);

(statearr_33580_33722[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (13))){
var inst_33266 = (state_33525[(18)]);
var inst_33270 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33266,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_33525__$1 = state_33525;
var statearr_33581_33723 = state_33525__$1;
(statearr_33581_33723[(2)] = inst_33270);

(statearr_33581_33723[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (22))){
var inst_33285 = (state_33525[(12)]);
var state_33525__$1 = state_33525;
var statearr_33582_33724 = state_33525__$1;
(statearr_33582_33724[(2)] = inst_33285);

(statearr_33582_33724[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (90))){
var inst_33485 = (state_33525[(26)]);
var inst_33502 = (inst_33485 == null);
var inst_33503 = cljs.core.not(inst_33502);
var state_33525__$1 = state_33525;
if(inst_33503){
var statearr_33583_33725 = state_33525__$1;
(statearr_33583_33725[(1)] = (92));

} else {
var statearr_33584_33726 = state_33525__$1;
(statearr_33584_33726[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (36))){
var inst_33326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33327 = [null,offset_map];
var inst_33328 = (new cljs.core.PersistentVector(null,2,(5),inst_33326,inst_33327,null));
var state_33525__$1 = state_33525;
var statearr_33585_33727 = state_33525__$1;
(statearr_33585_33727[(2)] = inst_33328);

(statearr_33585_33727[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (41))){
var inst_33340 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
if(cljs.core.truth_(inst_33340)){
var statearr_33586_33728 = state_33525__$1;
(statearr_33586_33728[(1)] = (45));

} else {
var statearr_33587_33729 = state_33525__$1;
(statearr_33587_33729[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (89))){
var inst_33283 = (state_33525[(20)]);
var inst_33485 = (state_33525[(26)]);
var inst_33486 = (state_33525[(24)]);
var inst_33494 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33495 = cljs.core.PersistentVector.EMPTY;
var inst_33496 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(acc,inst_33283,inst_33495);
var inst_33497 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33496,inst_33485);
var inst_33498 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_33283,inst_33497);
var inst_33499 = [inst_33498,inst_33486];
var inst_33500 = (new cljs.core.PersistentVector(null,2,(5),inst_33494,inst_33499,null));
var state_33525__$1 = state_33525;
var statearr_33588_33730 = state_33525__$1;
(statearr_33588_33730[(2)] = inst_33500);

(statearr_33588_33730[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (43))){
var inst_33272 = (state_33525[(7)]);
var inst_33335 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_33272);
var state_33525__$1 = state_33525;
var statearr_33589_33731 = state_33525__$1;
(statearr_33589_33731[(2)] = inst_33335);

(statearr_33589_33731[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (61))){
var inst_33376 = (state_33525[(30)]);
var inst_33401 = (state_33525[(2)]);
var inst_33402 = [inst_33401,offset_map];
var inst_33403 = (new cljs.core.PersistentVector(null,2,(5),inst_33376,inst_33402,null));
var state_33525__$1 = state_33525;
var statearr_33590_33732 = state_33525__$1;
(statearr_33590_33732[(2)] = inst_33403);

(statearr_33590_33732[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (29))){
var inst_33485 = (state_33525[(26)]);
var inst_33484 = (state_33525[(2)]);
var inst_33485__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33484,(0),null);
var inst_33486 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33484,(1),null);
var inst_33487 = (inst_33485__$1 == null);
var inst_33488 = cljs.core.not(inst_33487);
var state_33525__$1 = (function (){var statearr_33591 = state_33525;
(statearr_33591[(26)] = inst_33485__$1);

(statearr_33591[(24)] = inst_33486);

return statearr_33591;
})();
if(inst_33488){
var statearr_33592_33733 = state_33525__$1;
(statearr_33592_33733[(1)] = (86));

} else {
var statearr_33593_33734 = state_33525__$1;
(statearr_33593_33734[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (44))){
var inst_33337 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
var statearr_33594_33735 = state_33525__$1;
(statearr_33594_33735[(2)] = inst_33337);

(statearr_33594_33735[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (93))){
var state_33525__$1 = state_33525;
var statearr_33595_33736 = state_33525__$1;
(statearr_33595_33736[(1)] = (95));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (6))){
var inst_33255 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_33256 = (inst_33255 == null);
var state_33525__$1 = state_33525;
var statearr_33597_33737 = state_33525__$1;
(statearr_33597_33737[(2)] = inst_33256);

(statearr_33597_33737[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (28))){
var inst_33285 = (state_33525[(12)]);
var state_33525__$1 = state_33525;
if(cljs.core.truth_(inst_33285)){
var statearr_33598_33738 = state_33525__$1;
(statearr_33598_33738[(1)] = (33));

} else {
var statearr_33599_33739 = state_33525__$1;
(statearr_33599_33739[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (64))){
var inst_33405 = (state_33525[(31)]);
var state_33525__$1 = state_33525;
var statearr_33600_33740 = state_33525__$1;
(statearr_33600_33740[(2)] = inst_33405);

(statearr_33600_33740[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (51))){
var inst_33355 = (state_33525[(29)]);
var state_33525__$1 = state_33525;
var statearr_33601_33741 = state_33525__$1;
(statearr_33601_33741[(2)] = inst_33355);

(statearr_33601_33741[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (25))){
var inst_33289 = (state_33525[(15)]);
var state_33525__$1 = state_33525;
var statearr_33602_33742 = state_33525__$1;
(statearr_33602_33742[(2)] = inst_33289);

(statearr_33602_33742[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (34))){
var inst_33285 = (state_33525[(12)]);
var state_33525__$1 = state_33525;
var statearr_33603_33743 = state_33525__$1;
(statearr_33603_33743[(2)] = inst_33285);

(statearr_33603_33743[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (17))){
var inst_33272 = (state_33525[(7)]);
var inst_33285 = (state_33525[(12)]);
var inst_33284 = (state_33525[(23)]);
var inst_33283 = (state_33525[(2)]);
var inst_33284__$1 = cljs.core.__destructure_map(inst_33272);
var inst_33285__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33284__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_33286 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33284__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_33287 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33284__$1,cljs.core.cst$kw$limit);
var inst_33288 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33284__$1,cljs.core.cst$kw$orderBy);
var inst_33289 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33284__$1,cljs.core.cst$kw$offset);
var inst_33290 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33284__$1,cljs.core.cst$kw$p);
var state_33525__$1 = (function (){var statearr_33604 = state_33525;
(statearr_33604[(17)] = inst_33288);

(statearr_33604[(19)] = inst_33287);

(statearr_33604[(13)] = inst_33290);

(statearr_33604[(15)] = inst_33289);

(statearr_33604[(20)] = inst_33283);

(statearr_33604[(21)] = inst_33286);

(statearr_33604[(12)] = inst_33285__$1);

(statearr_33604[(23)] = inst_33284__$1);

return statearr_33604;
})();
if(cljs.core.truth_(inst_33285__$1)){
var statearr_33605_33744 = state_33525__$1;
(statearr_33605_33744[(1)] = (21));

} else {
var statearr_33606_33745 = state_33525__$1;
(statearr_33606_33745[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (3))){
var inst_33523 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33525__$1,inst_33523);
} else {
if((state_val_33526 === (12))){
var inst_33266 = (state_33525[(18)]);
var state_33525__$1 = state_33525;
var statearr_33607_33746 = state_33525__$1;
(statearr_33607_33746[(2)] = inst_33266);

(statearr_33607_33746[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (2))){
var inst_33253 = (state_33525[(10)]);
var _ = (function (){var statearr_33608 = state_33525;
(statearr_33608[(4)] = cljs.core.cons((5),(state_33525[(4)])));

return statearr_33608;
})();
var inst_33253__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_33525__$1 = (function (){var statearr_33609 = state_33525;
(statearr_33609[(10)] = inst_33253__$1);

return statearr_33609;
})();
if(cljs.core.truth_(inst_33253__$1)){
var statearr_33610_33747 = state_33525__$1;
(statearr_33610_33747[(1)] = (6));

} else {
var statearr_33611_33748 = state_33525__$1;
(statearr_33611_33748[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (66))){
var inst_33272 = (state_33525[(7)]);
var inst_33412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33413 = flake.o;
var inst_33414 = [inst_33413];
var inst_33415 = (new cljs.core.PersistentVector(null,1,(5),inst_33412,inst_33414,null));
var inst_33416 = [cljs.core.cst$kw$limit];
var inst_33417 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_33272);
var inst_33418 = [inst_33417];
var inst_33419 = cljs.core.PersistentHashMap.fromArrays(inst_33416,inst_33418);
var inst_33420 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_33415,inst_33419);
var state_33525__$1 = state_33525;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33525__$1,(69),inst_33420);
} else {
if((state_val_33526 === (23))){
var inst_33302 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
if(cljs.core.truth_(inst_33302)){
var statearr_33612_33749 = state_33525__$1;
(statearr_33612_33749[(1)] = (27));

} else {
var statearr_33613_33750 = state_33525__$1;
(statearr_33613_33750[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (47))){
var inst_33480 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
var statearr_33614_33751 = state_33525__$1;
(statearr_33614_33751[(2)] = inst_33480);

(statearr_33614_33751[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (35))){
var inst_33324 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
if(cljs.core.truth_(inst_33324)){
var statearr_33615_33752 = state_33525__$1;
(statearr_33615_33752[(1)] = (36));

} else {
var statearr_33616_33753 = state_33525__$1;
(statearr_33616_33753[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (82))){
var inst_33474 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
var statearr_33617_33754 = state_33525__$1;
(statearr_33617_33754[(2)] = inst_33474);

(statearr_33617_33754[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (76))){
var inst_33441 = (state_33525[(2)]);
var state_33525__$1 = (function (){var statearr_33618 = state_33525;
(statearr_33618[(22)] = inst_33441);

return statearr_33618;
})();
var statearr_33619_33755 = state_33525__$1;
(statearr_33619_33755[(1)] = (77));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (97))){
var inst_33516 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
var statearr_33621_33756 = state_33525__$1;
(statearr_33621_33756[(2)] = inst_33516);

(statearr_33621_33756[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (19))){
var inst_33272 = (state_33525[(7)]);
var inst_33279 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_33272);
var state_33525__$1 = state_33525;
var statearr_33622_33757 = state_33525__$1;
(statearr_33622_33757[(2)] = inst_33279);

(statearr_33622_33757[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (57))){
var inst_33405 = (state_33525[(31)]);
var inst_33405__$1 = componentFollow_QMARK_;
var state_33525__$1 = (function (){var statearr_33623 = state_33525;
(statearr_33623[(31)] = inst_33405__$1);

return statearr_33623;
})();
if(cljs.core.truth_(inst_33405__$1)){
var statearr_33624_33758 = state_33525__$1;
(statearr_33624_33758[(1)] = (63));

} else {
var statearr_33625_33759 = state_33525__$1;
(statearr_33625_33759[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (68))){
var inst_33476 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
var statearr_33626_33760 = state_33525__$1;
(statearr_33626_33760[(2)] = inst_33476);

(statearr_33626_33760[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (11))){
var inst_33266 = (state_33525[(18)]);
var inst_33266__$1 = (state_33525[(2)]);
var inst_33267 = cljs.core.contains_QMARK_(inst_33266__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var state_33525__$1 = (function (){var statearr_33628 = state_33525;
(statearr_33628[(18)] = inst_33266__$1);

return statearr_33628;
})();
if(inst_33267){
var statearr_33629_33761 = state_33525__$1;
(statearr_33629_33761[(1)] = (12));

} else {
var statearr_33630_33762 = state_33525__$1;
(statearr_33630_33762[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (9))){
var inst_33261 = flake.p;
var inst_33262 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_33263 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_33261,inst_33262);
var state_33525__$1 = state_33525;
var statearr_33631_33763 = state_33525__$1;
(statearr_33631_33763[(2)] = inst_33263);

(statearr_33631_33763[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (5))){
var _ = (function (){var statearr_33632 = state_33525;
(statearr_33632[(4)] = cljs.core.rest((state_33525[(4)])));

return statearr_33632;
})();
var state_33525__$1 = state_33525;
var ex33627 = (state_33525__$1[(2)]);
var statearr_33633_33764 = state_33525__$1;
(statearr_33633_33764[(5)] = ex33627);


if((ex33627 instanceof Error)){
var statearr_33634_33765 = state_33525__$1;
(statearr_33634_33765[(1)] = (4));

(statearr_33634_33765[(5)] = null);

} else {
throw ex33627;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (83))){
var inst_33466 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33467 = flake.o;
var inst_33468 = [inst_33467,offset_map];
var inst_33469 = (new cljs.core.PersistentVector(null,2,(5),inst_33466,inst_33468,null));
var state_33525__$1 = state_33525;
var statearr_33635_33766 = state_33525__$1;
(statearr_33635_33766[(2)] = inst_33469);

(statearr_33635_33766[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (14))){
var inst_33273 = (state_33525[(27)]);
var inst_33272 = (state_33525[(7)]);
var inst_33272__$1 = (state_33525[(2)]);
var inst_33273__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_33272__$1);
var state_33525__$1 = (function (){var statearr_33636 = state_33525;
(statearr_33636[(27)] = inst_33273__$1);

(statearr_33636[(7)] = inst_33272__$1);

return statearr_33636;
})();
if(cljs.core.truth_(inst_33273__$1)){
var statearr_33637_33767 = state_33525__$1;
(statearr_33637_33767[(1)] = (15));

} else {
var statearr_33638_33768 = state_33525__$1;
(statearr_33638_33768[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (45))){
var inst_33272 = (state_33525[(7)]);
var inst_33342 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33343 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_33344 = (new cljs.core.PersistentVector(null,3,(5),inst_33342,inst_33343,null));
var inst_33345 = cljs.core.select_keys(inst_33272,inst_33344);
var inst_33346 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33348 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33349 = flake.o;
var inst_33350 = [inst_33349];
var inst_33351 = (new cljs.core.PersistentVector(null,1,(5),inst_33348,inst_33350,null));
var inst_33352 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_33351);
var state_33525__$1 = (function (){var statearr_33639 = state_33525;
(statearr_33639[(28)] = inst_33346);

(statearr_33639[(32)] = inst_33345);

return statearr_33639;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33525__$1,(49),inst_33352);
} else {
if((state_val_33526 === (53))){
var inst_33288 = (state_33525[(17)]);
var inst_33266 = (state_33525[(18)]);
var inst_33287 = (state_33525[(19)]);
var inst_33290 = (state_33525[(13)]);
var inst_33289 = (state_33525[(15)]);
var inst_33283 = (state_33525[(20)]);
var inst_33272 = (state_33525[(7)]);
var inst_33286 = (state_33525[(21)]);
var inst_33285 = (state_33525[(12)]);
var inst_33361 = (state_33525[(25)]);
var inst_33345 = (state_33525[(32)]);
var inst_33284 = (state_33525[(23)]);
var inst_33363 = (function (){var map__33249 = inst_33284;
var p = inst_33290;
var pred_spec__$1 = inst_33266;
var orderBy = inst_33288;
var nested_select_spec = inst_33345;
var multi_QMARK_ = inst_33285;
var limit = inst_33287;
var offset = inst_33289;
var G__33347 = inst_33361;
var k = inst_33283;
var pred_spec_SINGLEQUOTE_ = inst_33272;
var ref_QMARK_ = inst_33286;
return (function (n){
return (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,nested_select_spec,n) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,nested_select_spec,n));
});
})();
var inst_33364 = (inst_33363.cljs$core$IFn$_invoke$arity$1 ? inst_33363.cljs$core$IFn$_invoke$arity$1(inst_33361) : inst_33363.call(null,inst_33361));
var state_33525__$1 = state_33525;
var statearr_33640_33769 = state_33525__$1;
(statearr_33640_33769[(2)] = inst_33364);

(statearr_33640_33769[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (78))){
var inst_33441 = (state_33525[(22)]);
var state_33525__$1 = state_33525;
var statearr_33641_33770 = state_33525__$1;
(statearr_33641_33770[(2)] = inst_33441);

(statearr_33641_33770[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (26))){
var inst_33299 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
var statearr_33642_33771 = state_33525__$1;
(statearr_33642_33771[(2)] = inst_33299);

(statearr_33642_33771[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (16))){
var inst_33276 = (state_33525[(33)]);
var inst_33272 = (state_33525[(7)]);
var inst_33276__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_33272);
var state_33525__$1 = (function (){var statearr_33643 = state_33525;
(statearr_33643[(33)] = inst_33276__$1);

return statearr_33643;
})();
if(cljs.core.truth_(inst_33276__$1)){
var statearr_33644_33772 = state_33525__$1;
(statearr_33644_33772[(1)] = (18));

} else {
var statearr_33645_33773 = state_33525__$1;
(statearr_33645_33773[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (81))){
var state_33525__$1 = state_33525;
var statearr_33646_33774 = state_33525__$1;
(statearr_33646_33774[(1)] = (83));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (79))){
var inst_33447 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33525__$1,(73),inst_33447);
} else {
if((state_val_33526 === (38))){
var inst_33482 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
var statearr_33648_33775 = state_33525__$1;
(statearr_33648_33775[(2)] = inst_33482);

(statearr_33648_33775[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (87))){
var state_33525__$1 = state_33525;
var statearr_33649_33776 = state_33525__$1;
(statearr_33649_33776[(2)] = false);

(statearr_33649_33776[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (30))){
var inst_33290 = (state_33525[(13)]);
var inst_33307 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_33290,cljs.core.dec);
var state_33525__$1 = state_33525;
var statearr_33650_33777 = state_33525__$1;
(statearr_33650_33777[(2)] = inst_33307);

(statearr_33650_33777[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (73))){
var inst_33434 = (state_33525[(34)]);
var inst_33449 = (state_33525[(2)]);
var inst_33450 = fluree.db.util.async.throw_err(inst_33449);
var inst_33451 = [inst_33450,offset_map];
var inst_33452 = (new cljs.core.PersistentVector(null,2,(5),inst_33434,inst_33451,null));
var state_33525__$1 = state_33525;
var statearr_33651_33778 = state_33525__$1;
(statearr_33651_33778[(2)] = inst_33452);

(statearr_33651_33778[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (96))){
var state_33525__$1 = state_33525;
var statearr_33652_33779 = state_33525__$1;
(statearr_33652_33779[(2)] = null);

(statearr_33652_33779[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (10))){
var state_33525__$1 = state_33525;
var statearr_33653_33780 = state_33525__$1;
(statearr_33653_33780[(2)] = pred_spec);

(statearr_33653_33780[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (18))){
var inst_33276 = (state_33525[(33)]);
var state_33525__$1 = state_33525;
var statearr_33654_33781 = state_33525__$1;
(statearr_33654_33781[(2)] = inst_33276);

(statearr_33654_33781[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (52))){
var inst_33361 = (state_33525[(2)]);
var state_33525__$1 = (function (){var statearr_33655 = state_33525;
(statearr_33655[(25)] = inst_33361);

return statearr_33655;
})();
var statearr_33656_33782 = state_33525__$1;
(statearr_33656_33782[(1)] = (53));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (67))){
var inst_33286 = (state_33525[(21)]);
var state_33525__$1 = state_33525;
if(cljs.core.truth_(inst_33286)){
var statearr_33658_33783 = state_33525__$1;
(statearr_33658_33783[(1)] = (80));

} else {
var statearr_33659_33784 = state_33525__$1;
(statearr_33659_33784[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (71))){
var inst_33434 = cljs.core.PersistentVector.EMPTY_NODE;
var state_33525__$1 = (function (){var statearr_33660 = state_33525;
(statearr_33660[(34)] = inst_33434);

return statearr_33660;
})();
if(cljs.core.truth_(fuel)){
var statearr_33661_33785 = state_33525__$1;
(statearr_33661_33785[(1)] = (74));

} else {
var statearr_33662_33786 = state_33525__$1;
(statearr_33662_33786[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (42))){
var inst_33332 = (state_33525[(16)]);
var state_33525__$1 = state_33525;
var statearr_33663_33787 = state_33525__$1;
(statearr_33663_33787[(2)] = inst_33332);

(statearr_33663_33787[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (80))){
var inst_33457 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33458 = [cljs.core.cst$kw$_id];
var inst_33459 = flake.o;
var inst_33460 = [inst_33459];
var inst_33461 = cljs.core.PersistentHashMap.fromArrays(inst_33458,inst_33460);
var inst_33462 = [inst_33461,offset_map];
var inst_33463 = (new cljs.core.PersistentVector(null,2,(5),inst_33457,inst_33462,null));
var state_33525__$1 = state_33525;
var statearr_33664_33788 = state_33525__$1;
(statearr_33664_33788[(2)] = inst_33463);

(statearr_33664_33788[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (37))){
var inst_33330 = cljs.core.not(recur_QMARK_);
var state_33525__$1 = state_33525;
if(inst_33330){
var statearr_33665_33789 = state_33525__$1;
(statearr_33665_33789[(1)] = (39));

} else {
var statearr_33666_33790 = state_33525__$1;
(statearr_33666_33790[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (63))){
var inst_33272 = (state_33525[(7)]);
var inst_33407 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_33272);
var state_33525__$1 = state_33525;
var statearr_33667_33791 = state_33525__$1;
(statearr_33667_33791[(2)] = inst_33407);

(statearr_33667_33791[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (94))){
var inst_33518 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
var statearr_33668_33792 = state_33525__$1;
(statearr_33668_33792[(2)] = inst_33518);

(statearr_33668_33792[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (8))){
var inst_33259 = (state_33525[(2)]);
var state_33525__$1 = state_33525;
if(cljs.core.truth_(inst_33259)){
var statearr_33669_33793 = state_33525__$1;
(statearr_33669_33793[(1)] = (9));

} else {
var statearr_33670_33794 = state_33525__$1;
(statearr_33670_33794[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (49))){
var inst_33354 = (state_33525[(2)]);
var inst_33355 = fluree.db.util.async.throw_err(inst_33354);
var state_33525__$1 = (function (){var statearr_33671 = state_33525;
(statearr_33671[(29)] = inst_33355);

return statearr_33671;
})();
if(cljs.core.truth_(fuel)){
var statearr_33672_33795 = state_33525__$1;
(statearr_33672_33795[(1)] = (50));

} else {
var statearr_33673_33796 = state_33525__$1;
(statearr_33673_33796[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33526 === (84))){
var state_33525__$1 = state_33525;
var statearr_33674_33797 = state_33525__$1;
(statearr_33674_33797[(2)] = null);

(statearr_33674_33797[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__13883__auto__ = null;
var fluree$db$query$fql$state_machine__13883__auto____0 = (function (){
var statearr_33675 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33675[(0)] = fluree$db$query$fql$state_machine__13883__auto__);

(statearr_33675[(1)] = (1));

return statearr_33675;
});
var fluree$db$query$fql$state_machine__13883__auto____1 = (function (state_33525){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_33525);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e33676){var ex__13886__auto__ = e33676;
var statearr_33677_33798 = state_33525;
(statearr_33677_33798[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_33525[(4)]))){
var statearr_33678_33799 = state_33525;
(statearr_33678_33799[(1)] = cljs.core.first((state_33525[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__33800 = state_33525;
state_33525 = G__33800;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__13883__auto__ = function(state_33525){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__13883__auto____1.call(this,state_33525);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__13883__auto____0;
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__13883__auto____1;
return fluree$db$query$fql$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_33679 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_33679[(6)] = c__13957__auto__);

return statearr_33679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4160__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
}));
cljs.core._vreset_BANG_(cache,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core._deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec));

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_33960){
var state_val_33961 = (state_33960[(1)]);
if((state_val_33961 === (7))){
var inst_33955 = (state_33960[(2)]);
var _ = (function (){var statearr_33962 = state_33960;
(statearr_33962[(4)] = cljs.core.rest((state_33960[(4)])));

return statearr_33962;
})();
var state_33960__$1 = state_33960;
var statearr_33963_34045 = state_33960__$1;
(statearr_33963_34045[(2)] = inst_33955);

(statearr_33963_34045[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (20))){
var inst_33882 = (state_33960[(7)]);
var state_33960__$1 = state_33960;
var statearr_33964_34046 = state_33960__$1;
(statearr_33964_34046[(2)] = inst_33882);

(statearr_33964_34046[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (27))){
var inst_33837 = (state_33960[(8)]);
var state_33960__$1 = state_33960;
if(cljs.core.truth_(inst_33837)){
var statearr_33965_34047 = state_33960__$1;
(statearr_33965_34047[(1)] = (29));

} else {
var statearr_33966_34048 = state_33960__$1;
(statearr_33966_34048[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (1))){
var state_33960__$1 = state_33960;
var statearr_33967_34049 = state_33960__$1;
(statearr_33967_34049[(2)] = null);

(statearr_33967_34049[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (24))){
var inst_33838 = (state_33960[(9)]);
var state_33960__$1 = state_33960;
var statearr_33968_34050 = state_33960__$1;
(statearr_33968_34050[(2)] = inst_33838);

(statearr_33968_34050[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (39))){
var inst_33874 = (state_33960[(10)]);
var state_33960__$1 = state_33960;
var statearr_33969_34051 = state_33960__$1;
(statearr_33969_34051[(2)] = inst_33874);

(statearr_33969_34051[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (46))){
var inst_33839 = (state_33960[(11)]);
var state_33960__$1 = state_33960;
var statearr_33970_34052 = state_33960__$1;
(statearr_33970_34052[(2)] = inst_33839);

(statearr_33970_34052[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (4))){
var inst_33801 = (state_33960[(2)]);
var state_33960__$1 = state_33960;
var statearr_33971_34053 = state_33960__$1;
(statearr_33971_34053[(2)] = inst_33801);

(statearr_33971_34053[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (15))){
var inst_33850 = (state_33960[(12)]);
var inst_33856 = cljs.core.count(inst_33850);
var inst_33857 = fluree.db.query.fql.add_fuel(fuel,inst_33856,max_fuel);
var state_33960__$1 = state_33960;
var statearr_33972_34054 = state_33960__$1;
(statearr_33972_34054[(2)] = inst_33857);

(statearr_33972_34054[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (48))){
var inst_33826 = (state_33960[(13)]);
var inst_33941 = (state_33960[(14)]);
var inst_33819 = (state_33960[(15)]);
var inst_33949 = (state_33960[(2)]);
var inst_33950 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33819,inst_33949,inst_33941);
var inst_33818 = inst_33826;
var inst_33819__$1 = inst_33950;
var state_33960__$1 = (function (){var statearr_33973 = state_33960;
(statearr_33973[(16)] = inst_33818);

(statearr_33973[(15)] = inst_33819__$1);

return statearr_33973;
})();
var statearr_33974_34055 = state_33960__$1;
(statearr_33974_34055[(2)] = null);

(statearr_33974_34055[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (50))){
var inst_33841 = (state_33960[(17)]);
var state_33960__$1 = state_33960;
var statearr_33975_34056 = state_33960__$1;
(statearr_33975_34056[(2)] = inst_33841);

(statearr_33975_34056[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (21))){
var inst_33838 = (state_33960[(9)]);
var state_33960__$1 = state_33960;
if(cljs.core.truth_(inst_33838)){
var statearr_33977_34057 = state_33960__$1;
(statearr_33977_34057[(1)] = (23));

} else {
var statearr_33978_34058 = state_33960__$1;
(statearr_33978_34058[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (31))){
var inst_33898 = (state_33960[(2)]);
var state_33960__$1 = state_33960;
if(cljs.core.truth_(inst_33898)){
var statearr_33979_34059 = state_33960__$1;
(statearr_33979_34059[(1)] = (32));

} else {
var statearr_33980_34060 = state_33960__$1;
(statearr_33980_34060[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (32))){
var inst_33881 = (state_33960[(18)]);
var inst_33873 = (state_33960[(19)]);
var inst_33874 = (state_33960[(10)]);
var inst_33900 = (inst_33873 + (1));
var tmp33976 = inst_33874;
var inst_33872 = inst_33881;
var inst_33873__$1 = inst_33900;
var inst_33874__$1 = tmp33976;
var state_33960__$1 = (function (){var statearr_33981 = state_33960;
(statearr_33981[(20)] = inst_33872);

(statearr_33981[(19)] = inst_33873__$1);

(statearr_33981[(10)] = inst_33874__$1);

return statearr_33981;
})();
var statearr_33982_34061 = state_33960__$1;
(statearr_33982_34061[(2)] = null);

(statearr_33982_34061[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (40))){
var state_33960__$1 = state_33960;
if(cljs.core.truth_(fuel)){
var statearr_33983_34062 = state_33960__$1;
(statearr_33983_34062[(1)] = (42));

} else {
var statearr_33984_34063 = state_33960__$1;
(statearr_33984_34063[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (33))){
var state_33960__$1 = state_33960;
var statearr_33985_34064 = state_33960__$1;
(statearr_33985_34064[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (13))){
var inst_33850 = (state_33960[(12)]);
var state_33960__$1 = state_33960;
var statearr_33987_34065 = state_33960__$1;
(statearr_33987_34065[(2)] = inst_33850);

(statearr_33987_34065[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (22))){
var inst_33891 = (state_33960[(2)]);
var state_33960__$1 = state_33960;
if(cljs.core.truth_(inst_33891)){
var statearr_33988_34066 = state_33960__$1;
(statearr_33988_34066[(1)] = (26));

} else {
var statearr_33989_34067 = state_33960__$1;
(statearr_33989_34067[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (36))){
var state_33960__$1 = state_33960;
var statearr_33990_34068 = state_33960__$1;
(statearr_33990_34068[(2)] = null);

(statearr_33990_34068[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (41))){
var inst_33881 = (state_33960[(18)]);
var inst_33873 = (state_33960[(19)]);
var inst_33930 = (state_33960[(2)]);
var inst_33931 = (inst_33873 + (1));
var inst_33872 = inst_33881;
var inst_33873__$1 = inst_33931;
var inst_33874 = inst_33930;
var state_33960__$1 = (function (){var statearr_33991 = state_33960;
(statearr_33991[(20)] = inst_33872);

(statearr_33991[(19)] = inst_33873__$1);

(statearr_33991[(10)] = inst_33874);

return statearr_33991;
})();
var statearr_33992_34069 = state_33960__$1;
(statearr_33992_34069[(2)] = null);

(statearr_33992_34069[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (43))){
var state_33960__$1 = state_33960;
var statearr_33993_34070 = state_33960__$1;
(statearr_33993_34070[(2)] = null);

(statearr_33993_34070[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (29))){
var inst_33837 = (state_33960[(8)]);
var inst_33873 = (state_33960[(19)]);
var inst_33895 = (inst_33873 < inst_33837);
var state_33960__$1 = state_33960;
var statearr_33994_34071 = state_33960__$1;
(statearr_33994_34071[(2)] = inst_33895);

(statearr_33994_34071[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (44))){
var inst_33914 = (state_33960[(21)]);
var inst_33910 = (state_33960[(22)]);
var inst_33923 = (state_33960[(2)]);
var inst_33924 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_33914,inst_33910) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_33914,inst_33910));
var state_33960__$1 = (function (){var statearr_33995 = state_33960;
(statearr_33995[(23)] = inst_33923);

return statearr_33995;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33960__$1,(45),inst_33924);
} else {
if((state_val_33961 === (6))){
var inst_33818 = (state_33960[(16)]);
var inst_33825 = (state_33960[(24)]);
var inst_33824 = cljs.core.seq(inst_33818);
var inst_33825__$1 = cljs.core.first(inst_33824);
var inst_33826 = cljs.core.next(inst_33824);
var inst_33827 = cljs.core.not(inst_33825__$1);
var state_33960__$1 = (function (){var statearr_33996 = state_33960;
(statearr_33996[(13)] = inst_33826);

(statearr_33996[(24)] = inst_33825__$1);

return statearr_33996;
})();
if(inst_33827){
var statearr_33997_34072 = state_33960__$1;
(statearr_33997_34072[(1)] = (8));

} else {
var statearr_33998_34073 = state_33960__$1;
(statearr_33998_34073[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (28))){
var inst_33939 = (state_33960[(2)]);
var state_33960__$1 = state_33960;
var statearr_33999_34074 = state_33960__$1;
(statearr_33999_34074[(2)] = inst_33939);

(statearr_33999_34074[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (51))){
var inst_33947 = (state_33960[(2)]);
var state_33960__$1 = state_33960;
var statearr_34000_34075 = state_33960__$1;
(statearr_34000_34075[(2)] = inst_33947);

(statearr_34000_34075[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (25))){
var inst_33889 = (state_33960[(2)]);
var state_33960__$1 = state_33960;
var statearr_34001_34076 = state_33960__$1;
(statearr_34001_34076[(2)] = inst_33889);

(statearr_34001_34076[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (34))){
var inst_33937 = (state_33960[(2)]);
var state_33960__$1 = state_33960;
var statearr_34002_34077 = state_33960__$1;
(statearr_34002_34077[(2)] = inst_33937);

(statearr_34002_34077[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (17))){
var inst_33850 = (state_33960[(12)]);
var inst_33860 = (state_33960[(2)]);
var inst_33868 = cljs.core.seq(inst_33850);
var inst_33869 = cljs.core.first(inst_33868);
var inst_33870 = cljs.core.next(inst_33868);
var inst_33871 = cljs.core.PersistentVector.EMPTY;
var inst_33872 = inst_33850;
var inst_33873 = (0);
var inst_33874 = inst_33871;
var state_33960__$1 = (function (){var statearr_34003 = state_33960;
(statearr_34003[(25)] = inst_33860);

(statearr_34003[(20)] = inst_33872);

(statearr_34003[(26)] = inst_33869);

(statearr_34003[(19)] = inst_33873);

(statearr_34003[(10)] = inst_33874);

(statearr_34003[(27)] = inst_33870);

return statearr_34003;
})();
var statearr_34004_34078 = state_33960__$1;
(statearr_34004_34078[(2)] = null);

(statearr_34004_34078[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (3))){
var inst_33958 = (state_33960[(2)]);
var state_33960__$1 = state_33960;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33960__$1,inst_33958);
} else {
if((state_val_33961 === (12))){
var state_33960__$1 = state_33960;
var statearr_34005_34079 = state_33960__$1;
(statearr_34005_34079[(2)] = fuel);

(statearr_34005_34079[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (2))){
var _ = (function (){var statearr_34006 = state_33960;
(statearr_34006[(4)] = cljs.core.cons((5),(state_33960[(4)])));

return statearr_34006;
})();
var inst_33814 = reverse_refs_specs;
var inst_33815 = cljs.core.seq(inst_33814);
var inst_33816 = cljs.core.first(inst_33815);
var inst_33817 = cljs.core.next(inst_33815);
var inst_33818 = inst_33814;
var inst_33819 = null;
var state_33960__$1 = (function (){var statearr_34007 = state_33960;
(statearr_34007[(28)] = inst_33816);

(statearr_34007[(16)] = inst_33818);

(statearr_34007[(29)] = inst_33817);

(statearr_34007[(15)] = inst_33819);

return statearr_34007;
})();
var statearr_34008_34080 = state_33960__$1;
(statearr_34008_34080[(2)] = null);

(statearr_34008_34080[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (23))){
var inst_33873 = (state_33960[(19)]);
var inst_33838 = (state_33960[(9)]);
var inst_33886 = (inst_33873 >= inst_33838);
var state_33960__$1 = state_33960;
var statearr_34009_34081 = state_33960__$1;
(statearr_34009_34081[(2)] = inst_33886);

(statearr_34009_34081[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (47))){
var inst_33840 = (state_33960[(30)]);
var state_33960__$1 = state_33960;
if(cljs.core.truth_(inst_33840)){
var statearr_34010_34082 = state_33960__$1;
(statearr_34010_34082[(1)] = (49));

} else {
var statearr_34011_34083 = state_33960__$1;
(statearr_34011_34083[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (35))){
var inst_33880 = (state_33960[(31)]);
var inst_33904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33905 = [inst_33880];
var inst_33906 = (new cljs.core.PersistentVector(null,1,(5),inst_33904,inst_33905,null));
var inst_33907 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_33906);
var state_33960__$1 = state_33960;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33960__$1,(38),inst_33907);
} else {
if((state_val_33961 === (19))){
var inst_33839 = (state_33960[(11)]);
var inst_33941 = (state_33960[(2)]);
var state_33960__$1 = (function (){var statearr_34012 = state_33960;
(statearr_34012[(14)] = inst_33941);

return statearr_34012;
})();
if(cljs.core.truth_(inst_33839)){
var statearr_34013_34084 = state_33960__$1;
(statearr_34013_34084[(1)] = (46));

} else {
var statearr_34014_34085 = state_33960__$1;
(statearr_34014_34085[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (11))){
var inst_33850 = (state_33960[(12)]);
var inst_33847 = (state_33960[(2)]);
var inst_33848 = fluree.db.util.async.throw_err(inst_33847);
var inst_33849 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_33848);
var inst_33850__$1 = cljs.core.not_empty(inst_33849);
var state_33960__$1 = (function (){var statearr_34016 = state_33960;
(statearr_34016[(12)] = inst_33850__$1);

return statearr_34016;
})();
if(cljs.core.truth_(inst_33850__$1)){
var statearr_34017_34086 = state_33960__$1;
(statearr_34017_34086[(1)] = (12));

} else {
var statearr_34018_34087 = state_33960__$1;
(statearr_34018_34087[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (9))){
var inst_33835 = (state_33960[(32)]);
var inst_33825 = (state_33960[(24)]);
var inst_33834 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33825,(0),null);
var inst_33835__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33825,(1),null);
var inst_33836 = cljs.core.__destructure_map(inst_33835__$1);
var inst_33837 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33836,cljs.core.cst$kw$offset);
var inst_33838 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33836,cljs.core.cst$kw$limit);
var inst_33839 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33836,cljs.core.cst$kw$as);
var inst_33840 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33836,cljs.core.cst$kw$name);
var inst_33841 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33836,cljs.core.cst$kw$p);
var inst_33842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33843 = [subject_id,inst_33834];
var inst_33844 = (new cljs.core.PersistentVector(null,2,(5),inst_33842,inst_33843,null));
var inst_33845 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_33844);
var state_33960__$1 = (function (){var statearr_34019 = state_33960;
(statearr_34019[(11)] = inst_33839);

(statearr_34019[(8)] = inst_33837);

(statearr_34019[(30)] = inst_33840);

(statearr_34019[(17)] = inst_33841);

(statearr_34019[(9)] = inst_33838);

(statearr_34019[(32)] = inst_33835__$1);

return statearr_34019;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33960__$1,(11),inst_33845);
} else {
if((state_val_33961 === (5))){
var _ = (function (){var statearr_34020 = state_33960;
(statearr_34020[(4)] = cljs.core.rest((state_33960[(4)])));

return statearr_34020;
})();
var state_33960__$1 = state_33960;
var ex34015 = (state_33960__$1[(2)]);
var statearr_34021_34088 = state_33960__$1;
(statearr_34021_34088[(5)] = ex34015);


if((ex34015 instanceof Error)){
var statearr_34022_34089 = state_33960__$1;
(statearr_34022_34089[(1)] = (4));

(statearr_34022_34089[(5)] = null);

} else {
throw ex34015;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (14))){
var inst_33854 = (state_33960[(2)]);
var state_33960__$1 = state_33960;
if(cljs.core.truth_(inst_33854)){
var statearr_34023_34090 = state_33960__$1;
(statearr_34023_34090[(1)] = (15));

} else {
var statearr_34024_34091 = state_33960__$1;
(statearr_34024_34091[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (45))){
var inst_33874 = (state_33960[(10)]);
var inst_33926 = (state_33960[(2)]);
var inst_33927 = fluree.db.util.async.throw_err(inst_33926);
var inst_33928 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_33874,inst_33927);
var state_33960__$1 = state_33960;
var statearr_34025_34092 = state_33960__$1;
(statearr_34025_34092[(2)] = inst_33928);

(statearr_34025_34092[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (26))){
var inst_33874 = (state_33960[(10)]);
var state_33960__$1 = state_33960;
var statearr_34026_34093 = state_33960__$1;
(statearr_34026_34093[(2)] = inst_33874);

(statearr_34026_34093[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (16))){
var state_33960__$1 = state_33960;
var statearr_34027_34094 = state_33960__$1;
(statearr_34027_34094[(2)] = null);

(statearr_34027_34094[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (38))){
var inst_33835 = (state_33960[(32)]);
var inst_33910 = (state_33960[(22)]);
var inst_33909 = (state_33960[(2)]);
var inst_33910__$1 = fluree.db.util.async.throw_err(inst_33909);
var inst_33911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33912 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_33913 = (new cljs.core.PersistentVector(null,4,(5),inst_33911,inst_33912,null));
var inst_33914 = cljs.core.select_keys(inst_33835,inst_33913);
var inst_33915 = cljs.core.empty_QMARK_(inst_33910__$1);
var state_33960__$1 = (function (){var statearr_34028 = state_33960;
(statearr_34028[(21)] = inst_33914);

(statearr_34028[(22)] = inst_33910__$1);

return statearr_34028;
})();
if(inst_33915){
var statearr_34029_34095 = state_33960__$1;
(statearr_34029_34095[(1)] = (39));

} else {
var statearr_34030_34096 = state_33960__$1;
(statearr_34030_34096[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (30))){
var inst_33837 = (state_33960[(8)]);
var state_33960__$1 = state_33960;
var statearr_34031_34097 = state_33960__$1;
(statearr_34031_34097[(2)] = inst_33837);

(statearr_34031_34097[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (10))){
var inst_33953 = (state_33960[(2)]);
var state_33960__$1 = state_33960;
var statearr_34032_34098 = state_33960__$1;
(statearr_34032_34098[(2)] = inst_33953);

(statearr_34032_34098[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (18))){
var inst_33872 = (state_33960[(20)]);
var inst_33882 = (state_33960[(7)]);
var inst_33880 = (state_33960[(31)]);
var inst_33879 = cljs.core.seq(inst_33872);
var inst_33880__$1 = cljs.core.first(inst_33879);
var inst_33881 = cljs.core.next(inst_33879);
var inst_33882__$1 = cljs.core.not(inst_33880__$1);
var state_33960__$1 = (function (){var statearr_34033 = state_33960;
(statearr_34033[(18)] = inst_33881);

(statearr_34033[(7)] = inst_33882__$1);

(statearr_34033[(31)] = inst_33880__$1);

return statearr_34033;
})();
if(inst_33882__$1){
var statearr_34034_34099 = state_33960__$1;
(statearr_34034_34099[(1)] = (20));

} else {
var statearr_34035_34100 = state_33960__$1;
(statearr_34035_34100[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (42))){
var inst_33910 = (state_33960[(22)]);
var inst_33919 = cljs.core.count(inst_33910);
var inst_33920 = fluree.db.query.fql.add_fuel(fuel,inst_33919,max_fuel);
var state_33960__$1 = state_33960;
var statearr_34036_34101 = state_33960__$1;
(statearr_34036_34101[(2)] = inst_33920);

(statearr_34036_34101[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (37))){
var inst_33935 = (state_33960[(2)]);
var state_33960__$1 = state_33960;
var statearr_34037_34102 = state_33960__$1;
(statearr_34037_34102[(2)] = inst_33935);

(statearr_34037_34102[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (8))){
var inst_33819 = (state_33960[(15)]);
var state_33960__$1 = state_33960;
var statearr_34038_34103 = state_33960__$1;
(statearr_34038_34103[(2)] = inst_33819);

(statearr_34038_34103[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33961 === (49))){
var inst_33840 = (state_33960[(30)]);
var state_33960__$1 = state_33960;
var statearr_34039_34104 = state_33960__$1;
(statearr_34039_34104[(2)] = inst_33840);

(statearr_34039_34104[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto____0 = (function (){
var statearr_34040 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34040[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto__);

(statearr_34040[(1)] = (1));

return statearr_34040;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto____1 = (function (state_33960){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_33960);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e34041){var ex__13886__auto__ = e34041;
var statearr_34042_34105 = state_33960;
(statearr_34042_34105[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_33960[(4)]))){
var statearr_34043_34106 = state_33960;
(statearr_34043_34106[(1)] = cljs.core.first((state_33960[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__34107 = state_33960;
state_33960 = G__34107;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto__ = function(state_33960){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto____1.call(this,state_33960);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_34044 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_34044[(6)] = c__13957__auto__);

return statearr_34044;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4160__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__34108 = select_spec;
var map__34108__$1 = cljs.core.__destructure_map(map__34108);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34108__$1,cljs.core.cst$kw$recur_DASH_seen);
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34108__$1,cljs.core.cst$kw$recur_DASH_depth);
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_depth], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_seen], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$compact_QMARK_], null));
});
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flake,select_spec,acc,fuel,max_fuel,cache){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_34170){
var state_val_34171 = (state_34170[(1)]);
if((state_val_34171 === (7))){
var inst_34134 = (state_34170[(7)]);
var inst_34136 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_34137 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_34136,inst_34134);
var state_34170__$1 = state_34170;
var statearr_34172_34211 = state_34170__$1;
(statearr_34172_34211[(2)] = inst_34137);

(statearr_34172_34211[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34171 === (20))){
var inst_34140 = (state_34170[(8)]);
var inst_34158 = fluree.db.query.fql.recur_select_spec(select_spec,flake);
var inst_34159 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_34158,inst_34140) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_34158,inst_34140));
var state_34170__$1 = state_34170;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34170__$1,(22),inst_34159);
} else {
if((state_val_34171 === (1))){
var state_34170__$1 = state_34170;
var statearr_34173_34212 = state_34170__$1;
(statearr_34173_34212[(2)] = null);

(statearr_34173_34212[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34171 === (4))){
var inst_34109 = (state_34170[(2)]);
var state_34170__$1 = state_34170;
var statearr_34174_34213 = state_34170__$1;
(statearr_34174_34213[(2)] = inst_34109);

(statearr_34174_34213[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34171 === (15))){
var inst_34147 = (state_34170[(2)]);
var state_34170__$1 = state_34170;
var statearr_34175_34214 = state_34170__$1;
(statearr_34175_34214[(2)] = inst_34147);

(statearr_34175_34214[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34171 === (21))){
var inst_34165 = (state_34170[(2)]);
var _ = (function (){var statearr_34176 = state_34170;
(statearr_34176[(4)] = cljs.core.rest((state_34170[(4)])));

return statearr_34176;
})();
var state_34170__$1 = state_34170;
var statearr_34177_34215 = state_34170__$1;
(statearr_34177_34215[(2)] = inst_34165);

(statearr_34177_34215[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34171 === (13))){
var inst_34126 = (state_34170[(9)]);
var state_34170__$1 = state_34170;
var statearr_34178_34216 = state_34170__$1;
(statearr_34178_34216[(2)] = inst_34126);

(statearr_34178_34216[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34171 === (22))){
var inst_34155 = (state_34170[(10)]);
var inst_34120 = (state_34170[(11)]);
var inst_34161 = (state_34170[(2)]);
var inst_34162 = fluree.db.util.async.throw_err(inst_34161);
var inst_34163 = (inst_34155.cljs$core$IFn$_invoke$arity$3 ? inst_34155.cljs$core$IFn$_invoke$arity$3(acc,inst_34120,inst_34162) : inst_34155.call(null,acc,inst_34120,inst_34162));
var state_34170__$1 = state_34170;
var statearr_34179_34217 = state_34170__$1;
(statearr_34179_34217[(2)] = inst_34163);

(statearr_34179_34217[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34171 === (6))){
var inst_34133 = (state_34170[(2)]);
var inst_34134 = fluree.db.util.async.throw_err(inst_34133);
var state_34170__$1 = (function (){var statearr_34180 = state_34170;
(statearr_34180[(7)] = inst_34134);

return statearr_34180;
})();
if(cljs.core.truth_(fuel)){
var statearr_34181_34218 = state_34170__$1;
(statearr_34181_34218[(1)] = (7));

} else {
var statearr_34182_34219 = state_34170__$1;
(statearr_34182_34219[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34171 === (17))){
var inst_34116 = (state_34170[(12)]);
var inst_34149 = (state_34170[(13)]);
var inst_34122 = (state_34170[(14)]);
var inst_34121 = (state_34170[(15)]);
var inst_34123 = (state_34170[(16)]);
var inst_34126 = (state_34170[(9)]);
var inst_34140 = (state_34170[(8)]);
var inst_34124 = (state_34170[(17)]);
var inst_34118 = (state_34170[(18)]);
var inst_34119 = (state_34170[(19)]);
var inst_34125 = (state_34170[(20)]);
var inst_34120 = (state_34170[(11)]);
var inst_34153 = (function (){var recur_seen = inst_34122;
var recur_subject = inst_34116;
var map__34115 = inst_34118;
var sub_flakes = inst_34140;
var seen_QMARK_ = inst_34125;
var multi_QMARK_ = inst_34119;
var limit = inst_34124;
var recur_depth = inst_34123;
var as = inst_34120;
var max_depth_QMARK_ = inst_34126;
var recur = inst_34121;
var stop_QMARK_ = inst_34149;
return (function (results,as__$1,new_result){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,as__$1,new_result);
});
})();
var state_34170__$1 = state_34170;
var statearr_34183_34220 = state_34170__$1;
(statearr_34183_34220[(2)] = inst_34153);

(statearr_34183_34220[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34171 === (3))){
var inst_34168 = (state_34170[(2)]);
var state_34170__$1 = state_34170;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34170__$1,inst_34168);
} else {
if((state_val_34171 === (12))){
var inst_34119 = (state_34170[(19)]);
var inst_34149 = (state_34170[(2)]);
var state_34170__$1 = (function (){var statearr_34184 = state_34170;
(statearr_34184[(13)] = inst_34149);

return statearr_34184;
})();
if(cljs.core.truth_(inst_34119)){
var statearr_34185_34221 = state_34170__$1;
(statearr_34185_34221[(1)] = (16));

} else {
var statearr_34186_34222 = state_34170__$1;
(statearr_34186_34222[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34171 === (2))){
var inst_34116 = (state_34170[(12)]);
var inst_34122 = (state_34170[(14)]);
var inst_34121 = (state_34170[(15)]);
var inst_34123 = (state_34170[(16)]);
var inst_34118 = (state_34170[(18)]);
var _ = (function (){var statearr_34187 = state_34170;
(statearr_34187[(4)] = cljs.core.cons((5),(state_34170[(4)])));

return statearr_34187;
})();
var inst_34116__$1 = flake.o;
var inst_34117 = select_spec;
var inst_34118__$1 = cljs.core.__destructure_map(inst_34117);
var inst_34119 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34118__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_34120 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34118__$1,cljs.core.cst$kw$as);
var inst_34121__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34118__$1,cljs.core.cst$kw$recur);
var inst_34122__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34118__$1,cljs.core.cst$kw$recur_DASH_seen);
var inst_34123__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34118__$1,cljs.core.cst$kw$recur_DASH_depth);
var inst_34124 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34118__$1,cljs.core.cst$kw$limit);
var inst_34125 = cljs.core.contains_QMARK_(inst_34122__$1,inst_34116__$1);
var inst_34126 = (inst_34123__$1 > inst_34121__$1);
var inst_34128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34129 = [inst_34116__$1];
var inst_34130 = (new cljs.core.PersistentVector(null,1,(5),inst_34128,inst_34129,null));
var inst_34131 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_34130);
var state_34170__$1 = (function (){var statearr_34188 = state_34170;
(statearr_34188[(12)] = inst_34116__$1);

(statearr_34188[(14)] = inst_34122__$1);

(statearr_34188[(15)] = inst_34121__$1);

(statearr_34188[(16)] = inst_34123__$1);

(statearr_34188[(9)] = inst_34126);

(statearr_34188[(17)] = inst_34124);

(statearr_34188[(18)] = inst_34118__$1);

(statearr_34188[(19)] = inst_34119);

(statearr_34188[(20)] = inst_34125);

(statearr_34188[(11)] = inst_34120);

return statearr_34188;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34170__$1,(6),inst_34131);
} else {
if((state_val_34171 === (19))){
var state_34170__$1 = state_34170;
var statearr_34189_34223 = state_34170__$1;
(statearr_34189_34223[(2)] = acc);

(statearr_34189_34223[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34171 === (11))){
var inst_34126 = (state_34170[(9)]);
var state_34170__$1 = state_34170;
if(cljs.core.truth_(inst_34126)){
var statearr_34191_34224 = state_34170__$1;
(statearr_34191_34224[(1)] = (13));

} else {
var statearr_34192_34225 = state_34170__$1;
(statearr_34192_34225[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34171 === (9))){
var inst_34125 = (state_34170[(20)]);
var inst_34140 = (state_34170[(2)]);
var state_34170__$1 = (function (){var statearr_34193 = state_34170;
(statearr_34193[(8)] = inst_34140);

return statearr_34193;
})();
if(cljs.core.truth_(inst_34125)){
var statearr_34194_34226 = state_34170__$1;
(statearr_34194_34226[(1)] = (10));

} else {
var statearr_34195_34227 = state_34170__$1;
(statearr_34195_34227[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34171 === (5))){
var _ = (function (){var statearr_34196 = state_34170;
(statearr_34196[(4)] = cljs.core.rest((state_34170[(4)])));

return statearr_34196;
})();
var state_34170__$1 = state_34170;
var ex34190 = (state_34170__$1[(2)]);
var statearr_34197_34228 = state_34170__$1;
(statearr_34197_34228[(5)] = ex34190);


if((ex34190 instanceof Error)){
var statearr_34198_34229 = state_34170__$1;
(statearr_34198_34229[(1)] = (4));

(statearr_34198_34229[(5)] = null);

} else {
throw ex34190;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34171 === (14))){
var inst_34140 = (state_34170[(8)]);
var inst_34145 = cljs.core.empty_QMARK_(inst_34140);
var state_34170__$1 = state_34170;
var statearr_34199_34230 = state_34170__$1;
(statearr_34199_34230[(2)] = inst_34145);

(statearr_34199_34230[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34171 === (16))){
var inst_34116 = (state_34170[(12)]);
var inst_34149 = (state_34170[(13)]);
var inst_34122 = (state_34170[(14)]);
var inst_34121 = (state_34170[(15)]);
var inst_34123 = (state_34170[(16)]);
var inst_34126 = (state_34170[(9)]);
var inst_34140 = (state_34170[(8)]);
var inst_34124 = (state_34170[(17)]);
var inst_34118 = (state_34170[(18)]);
var inst_34119 = (state_34170[(19)]);
var inst_34125 = (state_34170[(20)]);
var inst_34120 = (state_34170[(11)]);
var inst_34151 = (function (){var recur_seen = inst_34122;
var recur_subject = inst_34116;
var map__34115 = inst_34118;
var sub_flakes = inst_34140;
var seen_QMARK_ = inst_34125;
var multi_QMARK_ = inst_34119;
var limit = inst_34124;
var recur_depth = inst_34123;
var as = inst_34120;
var max_depth_QMARK_ = inst_34126;
var recur = inst_34121;
var stop_QMARK_ = inst_34149;
return (function (results,as__$1,new_result){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(results,as__$1,fluree.db.query.fql.conjv,new_result);
});
})();
var state_34170__$1 = state_34170;
var statearr_34200_34231 = state_34170__$1;
(statearr_34200_34231[(2)] = inst_34151);

(statearr_34200_34231[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34171 === (10))){
var inst_34125 = (state_34170[(20)]);
var state_34170__$1 = state_34170;
var statearr_34201_34232 = state_34170__$1;
(statearr_34201_34232[(2)] = inst_34125);

(statearr_34201_34232[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34171 === (18))){
var inst_34149 = (state_34170[(13)]);
var inst_34155 = (state_34170[(2)]);
var state_34170__$1 = (function (){var statearr_34202 = state_34170;
(statearr_34202[(10)] = inst_34155);

return statearr_34202;
})();
if(cljs.core.truth_(inst_34149)){
var statearr_34203_34233 = state_34170__$1;
(statearr_34203_34233[(1)] = (19));

} else {
var statearr_34204_34234 = state_34170__$1;
(statearr_34204_34234[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34171 === (8))){
var inst_34134 = (state_34170[(7)]);
var state_34170__$1 = state_34170;
var statearr_34205_34235 = state_34170__$1;
(statearr_34205_34235[(2)] = inst_34134);

(statearr_34205_34235[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto____0 = (function (){
var statearr_34206 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34206[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto__);

(statearr_34206[(1)] = (1));

return statearr_34206;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto____1 = (function (state_34170){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_34170);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e34207){var ex__13886__auto__ = e34207;
var statearr_34208_34236 = state_34170;
(statearr_34208_34236[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_34170[(4)]))){
var statearr_34209_34237 = state_34170;
(statearr_34209_34237[(1)] = cljs.core.first((state_34170[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__34238 = state_34170;
state_34170 = G__34238;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto__ = function(state_34170){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto____1.call(this,state_34170);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_34210 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_34210[(6)] = c__13957__auto__);

return statearr_34210;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_34416){
var state_val_34417 = (state_34416[(1)]);
if((state_val_34417 === (7))){
var state_34416__$1 = state_34416;
var statearr_34418_34503 = state_34416__$1;
(statearr_34418_34503[(2)] = null);

(statearr_34418_34503[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (20))){
var inst_34277 = cljs.core.PersistentHashMap.EMPTY;
var state_34416__$1 = state_34416;
var statearr_34419_34504 = state_34416__$1;
(statearr_34419_34504[(2)] = inst_34277);

(statearr_34419_34504[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (27))){
var inst_34259 = (state_34416[(7)]);
var inst_34265 = (state_34416[(8)]);
var inst_34295 = (state_34416[(9)]);
var inst_34279 = (state_34416[(10)]);
var inst_34395 = (state_34416[(2)]);
var inst_34396 = (function (){var top_level_subject = inst_34259;
var select_spec = inst_34265;
var base_acc = inst_34279;
var acc_PLUS_refs = inst_34295;
var result = inst_34395;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4160__auto__ = (function (){var and__4149__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4149__auto__;
}
})();
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var and__4149__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4149__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4149__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_34397 = cljs.core.PersistentVector.EMPTY;
var inst_34398 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_34265);
var inst_34399 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_34398);
var inst_34400 = cljs.core.vals(inst_34399);
var inst_34401 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_34265);
var inst_34402 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_34401);
var inst_34403 = cljs.core.vals(inst_34402);
var inst_34404 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_34400,inst_34403);
var inst_34405 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_34396,inst_34397,inst_34404);
var inst_34407 = (function (){var top_level_subject = inst_34259;
var select_spec = inst_34265;
var base_acc = inst_34279;
var acc_PLUS_refs = inst_34295;
var result = inst_34395;
var sort_preds = inst_34405;
return (function (acc,p__34406){
var vec__34420 = p__34406;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34420,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34420,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34420,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34420,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_34408 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_34407,inst_34395,inst_34405);
var state_34416__$1 = state_34416;
var statearr_34423_34505 = state_34416__$1;
(statearr_34423_34505[(2)] = inst_34408);

(statearr_34423_34505[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (1))){
var state_34416__$1 = state_34416;
var statearr_34424_34506 = state_34416__$1;
(statearr_34424_34506[(2)] = null);

(statearr_34424_34506[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (24))){
var inst_34295 = (state_34416[(9)]);
var inst_34295__$1 = (state_34416[(2)]);
var inst_34296 = flakes;
var inst_34297 = cljs.core.PersistentHashMap.EMPTY;
var inst_34298 = inst_34296;
var inst_34299 = inst_34295__$1;
var inst_34300 = inst_34297;
var state_34416__$1 = (function (){var statearr_34425 = state_34416;
(statearr_34425[(11)] = inst_34298);

(statearr_34425[(12)] = inst_34299);

(statearr_34425[(9)] = inst_34295__$1);

(statearr_34425[(13)] = inst_34300);

return statearr_34425;
})();
var statearr_34426_34507 = state_34416__$1;
(statearr_34426_34507[(2)] = null);

(statearr_34426_34507[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (39))){
var inst_34308 = (state_34416[(14)]);
var inst_34265 = (state_34416[(8)]);
var inst_34314 = (state_34416[(15)]);
var inst_34299 = (state_34416[(12)]);
var inst_34343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34344 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_34299,inst_34265,inst_34308,inst_34314,false);
var state_34416__$1 = (function (){var statearr_34427 = state_34416;
(statearr_34427[(16)] = inst_34343);

return statearr_34427;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34416__$1,(42),inst_34344);
} else {
if((state_val_34417 === (46))){
var inst_34308 = (state_34416[(14)]);
var inst_34298 = (state_34416[(11)]);
var inst_34300 = (state_34416[(13)]);
var inst_34361 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34362 = [cljs.core.cst$kw$_id];
var inst_34363 = inst_34308.s;
var inst_34364 = [inst_34363];
var inst_34365 = cljs.core.PersistentHashMap.fromArrays(inst_34362,inst_34364);
var inst_34366 = cljs.core.rest(inst_34298);
var inst_34367 = [inst_34365,inst_34366,inst_34300];
var inst_34368 = (new cljs.core.PersistentVector(null,3,(5),inst_34361,inst_34367,null));
var state_34416__$1 = state_34416;
var statearr_34428_34508 = state_34416__$1;
(statearr_34428_34508[(2)] = inst_34368);

(statearr_34428_34508[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (4))){
var inst_34239 = (state_34416[(2)]);
var state_34416__$1 = state_34416;
var statearr_34429_34509 = state_34416__$1;
(statearr_34429_34509[(2)] = inst_34239);

(statearr_34429_34509[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (15))){
var inst_34266 = (state_34416[(17)]);
var inst_34265 = (state_34416[(8)]);
var inst_34265__$1 = (state_34416[(2)]);
var inst_34266__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_34265__$1);
var state_34416__$1 = (function (){var statearr_34430 = state_34416;
(statearr_34430[(17)] = inst_34266__$1);

(statearr_34430[(8)] = inst_34265__$1);

return statearr_34430;
})();
if(cljs.core.truth_(inst_34266__$1)){
var statearr_34431_34510 = state_34416__$1;
(statearr_34431_34510[(1)] = (16));

} else {
var statearr_34432_34511 = state_34416__$1;
(statearr_34432_34511[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (48))){
var inst_34379 = (state_34416[(2)]);
var state_34416__$1 = state_34416;
var statearr_34433_34512 = state_34416__$1;
(statearr_34433_34512[(2)] = inst_34379);

(statearr_34433_34512[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (50))){
var state_34416__$1 = state_34416;
var statearr_34434_34513 = state_34416__$1;
(statearr_34434_34513[(2)] = null);

(statearr_34434_34513[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (21))){
var inst_34265 = (state_34416[(8)]);
var inst_34279 = (state_34416[(2)]);
var inst_34280 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34281 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_34282 = (new cljs.core.PersistentVector(null,2,(5),inst_34280,inst_34281,null));
var inst_34283 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_34265,inst_34282);
var state_34416__$1 = (function (){var statearr_34435 = state_34416;
(statearr_34435[(10)] = inst_34279);

return statearr_34435;
})();
if(cljs.core.truth_(inst_34283)){
var statearr_34436_34514 = state_34416__$1;
(statearr_34436_34514[(1)] = (22));

} else {
var statearr_34437_34515 = state_34416__$1;
(statearr_34437_34515[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (31))){
var inst_34308 = (state_34416[(14)]);
var inst_34313 = (state_34416[(18)]);
var inst_34299 = (state_34416[(12)]);
var inst_34317 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34318 = fluree.db.query.fql.flake__GT_recur(db,inst_34308,inst_34313,inst_34299,fuel,max_fuel,cache);
var state_34416__$1 = (function (){var statearr_34438 = state_34416;
(statearr_34438[(19)] = inst_34317);

return statearr_34438;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34416__$1,(34),inst_34318);
} else {
if((state_val_34417 === (32))){
var inst_34313 = (state_34416[(18)]);
var state_34416__$1 = state_34416;
if(cljs.core.truth_(inst_34313)){
var statearr_34439_34516 = state_34416__$1;
(statearr_34439_34516[(1)] = (35));

} else {
var statearr_34440_34517 = state_34416__$1;
(statearr_34440_34517[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (40))){
var inst_34265 = (state_34416[(8)]);
var inst_34353 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_34265);
var inst_34354 = cljs.core.empty_QMARK_(inst_34353);
var state_34416__$1 = state_34416;
if(inst_34354){
var statearr_34441_34518 = state_34416__$1;
(statearr_34441_34518[(1)] = (43));

} else {
var statearr_34442_34519 = state_34416__$1;
(statearr_34442_34519[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (33))){
var inst_34308 = (state_34416[(14)]);
var inst_34385 = (state_34416[(2)]);
var inst_34386 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34385,(0),null);
var inst_34387 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34385,(1),null);
var inst_34388 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34385,(2),null);
var inst_34389 = inst_34308.s;
var inst_34390 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34386,cljs.core.cst$kw$_id,inst_34389);
var inst_34298 = inst_34387;
var inst_34299 = inst_34390;
var inst_34300 = inst_34388;
var state_34416__$1 = (function (){var statearr_34443 = state_34416;
(statearr_34443[(11)] = inst_34298);

(statearr_34443[(12)] = inst_34299);

(statearr_34443[(13)] = inst_34300);

return statearr_34443;
})();
var statearr_34444_34520 = state_34416__$1;
(statearr_34444_34520[(2)] = null);

(statearr_34444_34520[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (13))){
var inst_34259 = (state_34416[(7)]);
var inst_34262 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_34259);
var state_34416__$1 = state_34416;
var statearr_34445_34521 = state_34416__$1;
(statearr_34445_34521[(2)] = inst_34262);

(statearr_34445_34521[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (22))){
var inst_34265 = (state_34416[(8)]);
var inst_34285 = cljs.core.first(flakes);
var inst_34286 = fluree.db.query.fql.s(inst_34285);
var inst_34287 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_34265);
var inst_34288 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_34286,inst_34287);
var state_34416__$1 = state_34416;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34416__$1,(25),inst_34288);
} else {
if((state_val_34417 === (36))){
var inst_34265 = (state_34416[(8)]);
var inst_34341 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_34265);
var state_34416__$1 = state_34416;
if(cljs.core.truth_(inst_34341)){
var statearr_34446_34522 = state_34416__$1;
(statearr_34446_34522[(1)] = (39));

} else {
var statearr_34447_34523 = state_34416__$1;
(statearr_34447_34523[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (41))){
var inst_34381 = (state_34416[(2)]);
var state_34416__$1 = state_34416;
var statearr_34448_34524 = state_34416__$1;
(statearr_34448_34524[(2)] = inst_34381);

(statearr_34448_34524[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (43))){
var inst_34265 = (state_34416[(8)]);
var inst_34356 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_34265);
var state_34416__$1 = state_34416;
var statearr_34449_34525 = state_34416__$1;
(statearr_34449_34525[(2)] = inst_34356);

(statearr_34449_34525[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (29))){
var inst_34308 = (state_34416[(14)]);
var inst_34265 = (state_34416[(8)]);
var inst_34298 = (state_34416[(11)]);
var inst_34313 = (state_34416[(18)]);
var inst_34308__$1 = cljs.core.first(inst_34298);
var inst_34309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34310 = inst_34308__$1.p;
var inst_34311 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_34310];
var inst_34312 = (new cljs.core.PersistentVector(null,3,(5),inst_34309,inst_34311,null));
var inst_34313__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_34265,inst_34312);
var inst_34314 = fluree.db.query.fql.component_follow_QMARK_(inst_34313__$1,inst_34265);
var inst_34315 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_34313__$1);
var state_34416__$1 = (function (){var statearr_34450 = state_34416;
(statearr_34450[(14)] = inst_34308__$1);

(statearr_34450[(18)] = inst_34313__$1);

(statearr_34450[(15)] = inst_34314);

return statearr_34450;
})();
if(cljs.core.truth_(inst_34315)){
var statearr_34451_34526 = state_34416__$1;
(statearr_34451_34526[(1)] = (31));

} else {
var statearr_34452_34527 = state_34416__$1;
(statearr_34452_34527[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (44))){
var state_34416__$1 = state_34416;
var statearr_34453_34528 = state_34416__$1;
(statearr_34453_34528[(2)] = false);

(statearr_34453_34528[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (6))){
var state_34416__$1 = state_34416;
var statearr_34454_34529 = state_34416__$1;
(statearr_34454_34529[(2)] = null);

(statearr_34454_34529[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (28))){
var inst_34299 = (state_34416[(12)]);
var state_34416__$1 = state_34416;
var statearr_34455_34530 = state_34416__$1;
(statearr_34455_34530[(2)] = inst_34299);

(statearr_34455_34530[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (51))){
var inst_34377 = (state_34416[(2)]);
var state_34416__$1 = state_34416;
var statearr_34456_34531 = state_34416__$1;
(statearr_34456_34531[(2)] = inst_34377);

(statearr_34456_34531[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (25))){
var inst_34279 = (state_34416[(10)]);
var inst_34290 = (state_34416[(2)]);
var inst_34291 = fluree.db.util.async.throw_err(inst_34290);
var inst_34292 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_34279,inst_34291], 0));
var state_34416__$1 = state_34416;
var statearr_34457_34532 = state_34416__$1;
(statearr_34457_34532[(2)] = inst_34292);

(statearr_34457_34532[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (34))){
var inst_34317 = (state_34416[(19)]);
var inst_34298 = (state_34416[(11)]);
var inst_34300 = (state_34416[(13)]);
var inst_34320 = (state_34416[(2)]);
var inst_34321 = fluree.db.util.async.throw_err(inst_34320);
var inst_34322 = cljs.core.rest(inst_34298);
var inst_34323 = [inst_34321,inst_34322,inst_34300];
var inst_34324 = (new cljs.core.PersistentVector(null,3,(5),inst_34317,inst_34323,null));
var state_34416__$1 = state_34416;
var statearr_34458_34533 = state_34416__$1;
(statearr_34458_34533[(2)] = inst_34324);

(statearr_34458_34533[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (17))){
var inst_34265 = (state_34416[(8)]);
var inst_34269 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_34265);
var state_34416__$1 = state_34416;
var statearr_34460_34534 = state_34416__$1;
(statearr_34460_34534[(2)] = inst_34269);

(statearr_34460_34534[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (3))){
var inst_34414 = (state_34416[(2)]);
var state_34416__$1 = state_34416;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34416__$1,inst_34414);
} else {
if((state_val_34417 === (12))){
var _ = (function (){var statearr_34461 = state_34416;
(statearr_34461[(4)] = cljs.core.rest((state_34416[(4)])));

return statearr_34461;
})();
var state_34416__$1 = state_34416;
var ex34459 = (state_34416__$1[(2)]);
var statearr_34462_34535 = state_34416__$1;
(statearr_34462_34535[(5)] = ex34459);


var statearr_34463_34536 = state_34416__$1;
(statearr_34463_34536[(1)] = (11));

(statearr_34463_34536[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (2))){
var _ = (function (){var statearr_34464 = state_34416;
(statearr_34464[(4)] = cljs.core.cons((5),(state_34416[(4)])));

return statearr_34464;
})();
var inst_34245 = cljs.core.not_empty(flakes);
var state_34416__$1 = state_34416;
if(cljs.core.truth_(inst_34245)){
var statearr_34465_34537 = state_34416__$1;
(statearr_34465_34537[(1)] = (6));

} else {
var statearr_34466_34538 = state_34416__$1;
(statearr_34466_34538[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (23))){
var inst_34279 = (state_34416[(10)]);
var state_34416__$1 = state_34416;
var statearr_34467_34539 = state_34416__$1;
(statearr_34467_34539[(2)] = inst_34279);

(statearr_34467_34539[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (47))){
var state_34416__$1 = state_34416;
var statearr_34468_34540 = state_34416__$1;
(statearr_34468_34540[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (35))){
var inst_34308 = (state_34416[(14)]);
var inst_34313 = (state_34416[(18)]);
var inst_34314 = (state_34416[(15)]);
var inst_34299 = (state_34416[(12)]);
var inst_34300 = (state_34416[(13)]);
var inst_34330 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_34299,inst_34313,inst_34308,inst_34314,false,inst_34300);
var state_34416__$1 = state_34416;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34416__$1,(38),inst_34330);
} else {
if((state_val_34417 === (19))){
var inst_34259 = (state_34416[(7)]);
var inst_34273 = [cljs.core.cst$kw$_id];
var inst_34274 = [inst_34259];
var inst_34275 = cljs.core.PersistentHashMap.fromArrays(inst_34273,inst_34274);
var state_34416__$1 = state_34416;
var statearr_34470_34541 = state_34416__$1;
(statearr_34470_34541[(2)] = inst_34275);

(statearr_34470_34541[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (11))){
var inst_34247 = (state_34416[(2)]);
var inst_34248 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_34247], 0));
var inst_34249 = (function(){throw inst_34247})();
var state_34416__$1 = (function (){var statearr_34472 = state_34416;
(statearr_34472[(20)] = inst_34248);

return statearr_34472;
})();
var statearr_34473_34542 = state_34416__$1;
(statearr_34473_34542[(2)] = inst_34249);

(statearr_34473_34542[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (9))){
var _ = (function (){var statearr_34474 = state_34416;
(statearr_34474[(4)] = cljs.core.cons((12),(state_34416[(4)])));

return statearr_34474;
})();
var inst_34255 = cljs.core.first(flakes);
var inst_34256 = fluree.db.query.fql.s(inst_34255);
var ___$1 = (function (){var statearr_34475 = state_34416;
(statearr_34475[(4)] = cljs.core.rest((state_34416[(4)])));

return statearr_34475;
})();
var state_34416__$1 = state_34416;
var statearr_34476_34543 = state_34416__$1;
(statearr_34476_34543[(2)] = inst_34256);

(statearr_34476_34543[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (5))){
var _ = (function (){var statearr_34477 = state_34416;
(statearr_34477[(4)] = cljs.core.rest((state_34416[(4)])));

return statearr_34477;
})();
var state_34416__$1 = state_34416;
var ex34471 = (state_34416__$1[(2)]);
var statearr_34478_34544 = state_34416__$1;
(statearr_34478_34544[(5)] = ex34471);


if((ex34471 instanceof Error)){
var statearr_34479_34545 = state_34416__$1;
(statearr_34479_34545[(1)] = (4));

(statearr_34479_34545[(5)] = null);

} else {
throw ex34471;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (14))){
var state_34416__$1 = state_34416;
var statearr_34480_34546 = state_34416__$1;
(statearr_34480_34546[(2)] = base_select_spec);

(statearr_34480_34546[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (45))){
var inst_34359 = (state_34416[(2)]);
var state_34416__$1 = state_34416;
if(cljs.core.truth_(inst_34359)){
var statearr_34481_34547 = state_34416__$1;
(statearr_34481_34547[(1)] = (46));

} else {
var statearr_34482_34548 = state_34416__$1;
(statearr_34482_34548[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (26))){
var inst_34298 = (state_34416[(11)]);
var inst_34302 = cljs.core.empty_QMARK_(inst_34298);
var state_34416__$1 = state_34416;
if(inst_34302){
var statearr_34483_34549 = state_34416__$1;
(statearr_34483_34549[(1)] = (28));

} else {
var statearr_34484_34550 = state_34416__$1;
(statearr_34484_34550[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (16))){
var inst_34266 = (state_34416[(17)]);
var state_34416__$1 = state_34416;
var statearr_34485_34551 = state_34416__$1;
(statearr_34485_34551[(2)] = inst_34266);

(statearr_34485_34551[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (38))){
var inst_34298 = (state_34416[(11)]);
var inst_34332 = (state_34416[(2)]);
var inst_34333 = fluree.db.util.async.throw_err(inst_34332);
var inst_34334 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34333,(0),null);
var inst_34335 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34333,(1),null);
var inst_34336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34337 = cljs.core.rest(inst_34298);
var inst_34338 = [inst_34334,inst_34337,inst_34335];
var inst_34339 = (new cljs.core.PersistentVector(null,3,(5),inst_34336,inst_34338,null));
var state_34416__$1 = state_34416;
var statearr_34486_34552 = state_34416__$1;
(statearr_34486_34552[(2)] = inst_34339);

(statearr_34486_34552[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (30))){
var inst_34393 = (state_34416[(2)]);
var state_34416__$1 = state_34416;
var statearr_34487_34553 = state_34416__$1;
(statearr_34487_34553[(2)] = inst_34393);

(statearr_34487_34553[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (10))){
var inst_34259 = (state_34416[(2)]);
var inst_34260 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_34416__$1 = (function (){var statearr_34488 = state_34416;
(statearr_34488[(7)] = inst_34259);

return statearr_34488;
})();
if(cljs.core.truth_(inst_34260)){
var statearr_34489_34554 = state_34416__$1;
(statearr_34489_34554[(1)] = (13));

} else {
var statearr_34490_34555 = state_34416__$1;
(statearr_34490_34555[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (18))){
var inst_34271 = (state_34416[(2)]);
var state_34416__$1 = state_34416;
if(cljs.core.truth_(inst_34271)){
var statearr_34491_34556 = state_34416__$1;
(statearr_34491_34556[(1)] = (19));

} else {
var statearr_34492_34557 = state_34416__$1;
(statearr_34492_34557[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (42))){
var inst_34298 = (state_34416[(11)]);
var inst_34343 = (state_34416[(16)]);
var inst_34300 = (state_34416[(13)]);
var inst_34346 = (state_34416[(2)]);
var inst_34347 = fluree.db.util.async.throw_err(inst_34346);
var inst_34348 = cljs.core.first(inst_34347);
var inst_34349 = cljs.core.rest(inst_34298);
var inst_34350 = [inst_34348,inst_34349,inst_34300];
var inst_34351 = (new cljs.core.PersistentVector(null,3,(5),inst_34343,inst_34350,null));
var state_34416__$1 = state_34416;
var statearr_34493_34558 = state_34416__$1;
(statearr_34493_34558[(2)] = inst_34351);

(statearr_34493_34558[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (37))){
var inst_34383 = (state_34416[(2)]);
var state_34416__$1 = state_34416;
var statearr_34494_34559 = state_34416__$1;
(statearr_34494_34559[(2)] = inst_34383);

(statearr_34494_34559[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (8))){
var inst_34411 = (state_34416[(2)]);
var _ = (function (){var statearr_34495 = state_34416;
(statearr_34495[(4)] = cljs.core.rest((state_34416[(4)])));

return statearr_34495;
})();
var state_34416__$1 = state_34416;
var statearr_34496_34560 = state_34416__$1;
(statearr_34496_34560[(2)] = inst_34411);

(statearr_34496_34560[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34417 === (49))){
var inst_34298 = (state_34416[(11)]);
var inst_34299 = (state_34416[(12)]);
var inst_34300 = (state_34416[(13)]);
var inst_34371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34372 = cljs.core.rest(inst_34298);
var inst_34373 = [inst_34299,inst_34372,inst_34300];
var inst_34374 = (new cljs.core.PersistentVector(null,3,(5),inst_34371,inst_34373,null));
var state_34416__$1 = state_34416;
var statearr_34497_34561 = state_34416__$1;
(statearr_34497_34561[(2)] = inst_34374);

(statearr_34497_34561[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto____0 = (function (){
var statearr_34498 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34498[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto__);

(statearr_34498[(1)] = (1));

return statearr_34498;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto____1 = (function (state_34416){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_34416);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e34499){var ex__13886__auto__ = e34499;
var statearr_34500_34562 = state_34416;
(statearr_34500_34562[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_34416[(4)]))){
var statearr_34501_34563 = state_34416;
(statearr_34501_34563[(1)] = cljs.core.first((state_34416[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__34564 = state_34416;
state_34416 = G__34564;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto__ = function(state_34416){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto____1.call(this,state_34416);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_34502 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_34502[(6)] = c__13957__auto__);

return statearr_34502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__34567 = arguments.length;
switch (G__34567) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_34609){
var state_val_34610 = (state_34609[(1)]);
if((state_val_34610 === (7))){
var inst_34575 = (state_34609[(7)]);
var state_34609__$1 = state_34609;
var statearr_34611_34641 = state_34609__$1;
(statearr_34611_34641[(2)] = inst_34575);

(statearr_34611_34641[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34610 === (1))){
var state_34609__$1 = state_34609;
var statearr_34612_34642 = state_34609__$1;
(statearr_34612_34642[(2)] = null);

(statearr_34612_34642[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34610 === (4))){
var inst_34568 = (state_34609[(2)]);
var state_34609__$1 = state_34609;
var statearr_34613_34643 = state_34609__$1;
(statearr_34613_34643[(2)] = inst_34568);

(statearr_34613_34643[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34610 === (15))){
var inst_34603 = (state_34609[(2)]);
var inst_34604 = fluree.db.util.async.throw_err(inst_34603);
var _ = (function (){var statearr_34614 = state_34609;
(statearr_34614[(4)] = cljs.core.rest((state_34609[(4)])));

return statearr_34614;
})();
var state_34609__$1 = state_34609;
var statearr_34615_34644 = state_34609__$1;
(statearr_34615_34644[(2)] = inst_34604);

(statearr_34615_34644[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34610 === (13))){
var inst_34587 = (state_34609[(8)]);
var state_34609__$1 = state_34609;
var statearr_34616_34645 = state_34609__$1;
(statearr_34616_34645[(2)] = inst_34587);

(statearr_34616_34645[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34610 === (6))){
var inst_34575 = (state_34609[(7)]);
var inst_34577 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_34578 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_34575,inst_34577);
var state_34609__$1 = state_34609;
var statearr_34617_34646 = state_34609__$1;
(statearr_34617_34646[(2)] = inst_34578);

(statearr_34617_34646[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34610 === (3))){
var inst_34607 = (state_34609[(2)]);
var state_34609__$1 = state_34609;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34609__$1,inst_34607);
} else {
if((state_val_34610 === (12))){
var inst_34587 = (state_34609[(8)]);
var inst_34589 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_34590 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_34587,inst_34589);
var state_34609__$1 = state_34609;
var statearr_34618_34647 = state_34609__$1;
(statearr_34618_34647[(2)] = inst_34590);

(statearr_34618_34647[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34610 === (2))){
var _ = (function (){var statearr_34619 = state_34609;
(statearr_34619[(4)] = cljs.core.cons((5),(state_34609[(4)])));

return statearr_34619;
})();
var inst_34575 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_34609__$1 = (function (){var statearr_34620 = state_34609;
(statearr_34620[(7)] = inst_34575);

return statearr_34620;
})();
if(cljs.core.truth_(fuel)){
var statearr_34621_34648 = state_34609__$1;
(statearr_34621_34648[(1)] = (6));

} else {
var statearr_34622_34649 = state_34609__$1;
(statearr_34622_34649[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34610 === (11))){
var inst_34587 = (state_34609[(2)]);
var state_34609__$1 = (function (){var statearr_34624 = state_34609;
(statearr_34624[(8)] = inst_34587);

return statearr_34624;
})();
if(cljs.core.truth_(limit)){
var statearr_34625_34650 = state_34609__$1;
(statearr_34625_34650[(1)] = (12));

} else {
var statearr_34626_34651 = state_34609__$1;
(statearr_34626_34651[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34610 === (9))){
var inst_34581 = (state_34609[(9)]);
var inst_34583 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_34584 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_34581,inst_34583);
var state_34609__$1 = state_34609;
var statearr_34627_34652 = state_34609__$1;
(statearr_34627_34652[(2)] = inst_34584);

(statearr_34627_34652[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34610 === (5))){
var _ = (function (){var statearr_34628 = state_34609;
(statearr_34628[(4)] = cljs.core.rest((state_34609[(4)])));

return statearr_34628;
})();
var state_34609__$1 = state_34609;
var ex34623 = (state_34609__$1[(2)]);
var statearr_34629_34653 = state_34609__$1;
(statearr_34629_34653[(5)] = ex34623);


if((ex34623 instanceof Error)){
var statearr_34630_34654 = state_34609__$1;
(statearr_34630_34654[(1)] = (4));

(statearr_34630_34654[(5)] = null);

} else {
throw ex34623;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34610 === (14))){
var inst_34593 = (state_34609[(2)]);
var inst_34594 = (function (){return (function (x){
var and__4149__auto__ = max_fuel;
if(cljs.core.truth_(and__4149__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4149__auto__;
}
});
})();
var inst_34595 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_34594);
var inst_34596 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_34593,inst_34595);
var inst_34597 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_34596,flakes);
var inst_34598 = cljs.core.PersistentVector.EMPTY;
var inst_34599 = (function (){var xf = inst_34596;
var flakes_by_sub = inst_34597;
return (function (p1__34565_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__34565_SHARP_);
});
})();
var inst_34600 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_34599,inst_34597);
var inst_34601 = fluree.db.util.async.merge_into_QMARK_(inst_34598,inst_34600);
var state_34609__$1 = state_34609;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34609__$1,(15),inst_34601);
} else {
if((state_val_34610 === (10))){
var inst_34581 = (state_34609[(9)]);
var state_34609__$1 = state_34609;
var statearr_34631_34655 = state_34609__$1;
(statearr_34631_34655[(2)] = inst_34581);

(statearr_34631_34655[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34610 === (8))){
var inst_34581 = (state_34609[(2)]);
var state_34609__$1 = (function (){var statearr_34632 = state_34609;
(statearr_34632[(9)] = inst_34581);

return statearr_34632;
})();
if(cljs.core.truth_(offset)){
var statearr_34633_34656 = state_34609__$1;
(statearr_34633_34656[(1)] = (9));

} else {
var statearr_34634_34657 = state_34609__$1;
(statearr_34634_34657[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__13883__auto__ = null;
var fluree$db$query$fql$state_machine__13883__auto____0 = (function (){
var statearr_34635 = [null,null,null,null,null,null,null,null,null,null];
(statearr_34635[(0)] = fluree$db$query$fql$state_machine__13883__auto__);

(statearr_34635[(1)] = (1));

return statearr_34635;
});
var fluree$db$query$fql$state_machine__13883__auto____1 = (function (state_34609){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_34609);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e34636){var ex__13886__auto__ = e34636;
var statearr_34637_34658 = state_34609;
(statearr_34637_34658[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_34609[(4)]))){
var statearr_34638_34659 = state_34609;
(statearr_34638_34659[(1)] = cljs.core.first((state_34609[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__34660 = state_34609;
state_34609 = G__34660;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__13883__auto__ = function(state_34609){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__13883__auto____1.call(this,state_34609);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__13883__auto____0;
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__13883__auto____1;
return fluree$db$query$fql$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_34639 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_34639[(6)] = c__13957__auto__);

return statearr_34639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__34662 = arguments.length;
switch (G__34662) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_34743){
var state_val_34744 = (state_34743[(1)]);
if((state_val_34744 === (7))){
var inst_34738 = (state_34743[(2)]);
var _ = (function (){var statearr_34746 = state_34743;
(statearr_34746[(4)] = cljs.core.rest((state_34743[(4)])));

return statearr_34746;
})();
var state_34743__$1 = state_34743;
var statearr_34747_34794 = state_34743__$1;
(statearr_34747_34794[(2)] = inst_34738);

(statearr_34747_34794[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (20))){
var inst_34683 = (state_34743[(7)]);
var inst_34690 = (state_34743[(8)]);
var inst_34682 = (state_34743[(9)]);
var inst_34711 = (inst_34682 + (1));
var tmp34745 = inst_34683;
var inst_34681 = inst_34690;
var inst_34682__$1 = inst_34711;
var inst_34683__$1 = tmp34745;
var state_34743__$1 = (function (){var statearr_34748 = state_34743;
(statearr_34748[(7)] = inst_34683__$1);

(statearr_34748[(10)] = inst_34681);

(statearr_34748[(9)] = inst_34682__$1);

return statearr_34748;
})();
var statearr_34749_34795 = state_34743__$1;
(statearr_34749_34795[(2)] = null);

(statearr_34749_34795[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (27))){
var inst_34716 = (state_34743[(11)]);
var inst_34722 = (state_34743[(2)]);
var inst_34723 = fluree.db.util.async.throw_err(inst_34722);
var inst_34724 = (inst_34716.cljs$core$IFn$_invoke$arity$1 ? inst_34716.cljs$core$IFn$_invoke$arity$1(inst_34723) : inst_34716.call(null,inst_34723));
var state_34743__$1 = state_34743;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34743__$1,(26),inst_34724);
} else {
if((state_val_34744 === (1))){
var state_34743__$1 = state_34743;
var statearr_34750_34796 = state_34743__$1;
(statearr_34750_34796[(2)] = null);

(statearr_34750_34796[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (24))){
var state_34743__$1 = state_34743;
var statearr_34751_34797 = state_34743__$1;
(statearr_34751_34797[(2)] = null);

(statearr_34751_34797[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (4))){
var inst_34663 = (state_34743[(2)]);
var state_34743__$1 = state_34743;
var statearr_34752_34798 = state_34743__$1;
(statearr_34752_34798[(2)] = inst_34663);

(statearr_34752_34798[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (15))){
var inst_34704 = (state_34743[(12)]);
var inst_34704__$1 = offset;
var state_34743__$1 = (function (){var statearr_34753 = state_34743;
(statearr_34753[(12)] = inst_34704__$1);

return statearr_34753;
})();
if(cljs.core.truth_(inst_34704__$1)){
var statearr_34754_34799 = state_34743__$1;
(statearr_34754_34799[(1)] = (17));

} else {
var statearr_34755_34800 = state_34743__$1;
(statearr_34755_34800[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (21))){
var state_34743__$1 = state_34743;
var statearr_34756_34801 = state_34743__$1;
(statearr_34756_34801[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (13))){
var inst_34699 = (state_34743[(2)]);
var state_34743__$1 = state_34743;
var statearr_34758_34802 = state_34743__$1;
(statearr_34758_34802[(2)] = inst_34699);

(statearr_34758_34802[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (22))){
var inst_34734 = (state_34743[(2)]);
var state_34743__$1 = state_34743;
var statearr_34759_34803 = state_34743__$1;
(statearr_34759_34803[(2)] = inst_34734);

(statearr_34759_34803[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (6))){
var inst_34681 = (state_34743[(10)]);
var inst_34689 = (state_34743[(13)]);
var inst_34691 = (state_34743[(14)]);
var inst_34688 = cljs.core.seq(inst_34681);
var inst_34689__$1 = cljs.core.first(inst_34688);
var inst_34690 = cljs.core.next(inst_34688);
var inst_34691__$1 = (inst_34689__$1 == null);
var state_34743__$1 = (function (){var statearr_34760 = state_34743;
(statearr_34760[(8)] = inst_34690);

(statearr_34760[(13)] = inst_34689__$1);

(statearr_34760[(14)] = inst_34691__$1);

return statearr_34760;
})();
if(cljs.core.truth_(inst_34691__$1)){
var statearr_34761_34804 = state_34743__$1;
(statearr_34761_34804[(1)] = (8));

} else {
var statearr_34762_34805 = state_34743__$1;
(statearr_34762_34805[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (25))){
var inst_34732 = (state_34743[(2)]);
var state_34743__$1 = state_34743;
var statearr_34763_34806 = state_34743__$1;
(statearr_34763_34806[(2)] = inst_34732);

(statearr_34763_34806[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (17))){
var inst_34682 = (state_34743[(9)]);
var inst_34706 = (inst_34682 < offset);
var state_34743__$1 = state_34743;
var statearr_34764_34807 = state_34743__$1;
(statearr_34764_34807[(2)] = inst_34706);

(statearr_34764_34807[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (3))){
var inst_34741 = (state_34743[(2)]);
var state_34743__$1 = state_34743;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34743__$1,inst_34741);
} else {
if((state_val_34744 === (12))){
var inst_34694 = (state_34743[(15)]);
var state_34743__$1 = state_34743;
var statearr_34765_34808 = state_34743__$1;
(statearr_34765_34808[(2)] = inst_34694);

(statearr_34765_34808[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (2))){
var inst_34676 = (state_34743[(16)]);
var _ = (function (){var statearr_34766 = state_34743;
(statearr_34766[(4)] = cljs.core.cons((5),(state_34743[(4)])));

return statearr_34766;
})();
var inst_34676__$1 = subjects;
var inst_34677 = cljs.core.seq(inst_34676__$1);
var inst_34678 = cljs.core.first(inst_34677);
var inst_34679 = cljs.core.next(inst_34677);
var inst_34680 = cljs.core.PersistentVector.EMPTY;
var inst_34681 = inst_34676__$1;
var inst_34682 = (0);
var inst_34683 = inst_34680;
var state_34743__$1 = (function (){var statearr_34767 = state_34743;
(statearr_34767[(7)] = inst_34683);

(statearr_34767[(10)] = inst_34681);

(statearr_34767[(17)] = inst_34679);

(statearr_34767[(18)] = inst_34678);

(statearr_34767[(16)] = inst_34676__$1);

(statearr_34767[(9)] = inst_34682);

return statearr_34767;
})();
var statearr_34768_34809 = state_34743__$1;
(statearr_34768_34809[(2)] = null);

(statearr_34768_34809[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (23))){
var inst_34683 = (state_34743[(7)]);
var inst_34681 = (state_34743[(10)]);
var inst_34690 = (state_34743[(8)]);
var inst_34679 = (state_34743[(17)]);
var inst_34689 = (state_34743[(13)]);
var inst_34678 = (state_34743[(18)]);
var inst_34676 = (state_34743[(16)]);
var inst_34682 = (state_34743[(9)]);
var inst_34715 = (inst_34682 + (1));
var inst_34716 = (function (){var first__34675 = inst_34678;
var seq__34686 = inst_34690;
var r = inst_34690;
var first__34687 = inst_34689;
var acc = inst_34683;
var n = inst_34682;
var G__34672 = inst_34681;
var vec__34673 = inst_34676;
var vec__34685 = inst_34681;
var s = inst_34689;
var seq__34674 = inst_34679;
return (function (n__$1){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,n__$1);
});
})();
var inst_34717 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34718 = [inst_34689];
var inst_34719 = (new cljs.core.PersistentVector(null,1,(5),inst_34717,inst_34718,null));
var inst_34720 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_34719);
var state_34743__$1 = (function (){var statearr_34769 = state_34743;
(statearr_34769[(11)] = inst_34716);

(statearr_34769[(19)] = inst_34715);

return statearr_34769;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34743__$1,(27),inst_34720);
} else {
if((state_val_34744 === (19))){
var inst_34709 = (state_34743[(2)]);
var state_34743__$1 = state_34743;
if(cljs.core.truth_(inst_34709)){
var statearr_34770_34810 = state_34743__$1;
(statearr_34770_34810[(1)] = (20));

} else {
var statearr_34771_34811 = state_34743__$1;
(statearr_34771_34811[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (11))){
var inst_34682 = (state_34743[(9)]);
var inst_34696 = (inst_34682 > limit);
var state_34743__$1 = state_34743;
var statearr_34773_34812 = state_34743__$1;
(statearr_34773_34812[(2)] = inst_34696);

(statearr_34773_34812[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (9))){
var inst_34694 = (state_34743[(15)]);
var inst_34694__$1 = limit;
var state_34743__$1 = (function (){var statearr_34774 = state_34743;
(statearr_34774[(15)] = inst_34694__$1);

return statearr_34774;
})();
if(cljs.core.truth_(inst_34694__$1)){
var statearr_34775_34813 = state_34743__$1;
(statearr_34775_34813[(1)] = (11));

} else {
var statearr_34776_34814 = state_34743__$1;
(statearr_34776_34814[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (5))){
var _ = (function (){var statearr_34777 = state_34743;
(statearr_34777[(4)] = cljs.core.rest((state_34743[(4)])));

return statearr_34777;
})();
var state_34743__$1 = state_34743;
var ex34772 = (state_34743__$1[(2)]);
var statearr_34778_34815 = state_34743__$1;
(statearr_34778_34815[(5)] = ex34772);


if((ex34772 instanceof Error)){
var statearr_34779_34816 = state_34743__$1;
(statearr_34779_34816[(1)] = (4));

(statearr_34779_34816[(5)] = null);

} else {
throw ex34772;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (14))){
var inst_34683 = (state_34743[(7)]);
var state_34743__$1 = state_34743;
var statearr_34780_34817 = state_34743__$1;
(statearr_34780_34817[(2)] = inst_34683);

(statearr_34780_34817[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (26))){
var inst_34683 = (state_34743[(7)]);
var inst_34690 = (state_34743[(8)]);
var inst_34715 = (state_34743[(19)]);
var inst_34726 = (state_34743[(2)]);
var inst_34727 = fluree.db.util.async.throw_err(inst_34726);
var inst_34728 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34683,inst_34727);
var inst_34681 = inst_34690;
var inst_34682 = inst_34715;
var inst_34683__$1 = inst_34728;
var state_34743__$1 = (function (){var statearr_34781 = state_34743;
(statearr_34781[(7)] = inst_34683__$1);

(statearr_34781[(10)] = inst_34681);

(statearr_34781[(9)] = inst_34682);

return statearr_34781;
})();
var statearr_34782_34818 = state_34743__$1;
(statearr_34782_34818[(2)] = null);

(statearr_34782_34818[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (16))){
var inst_34736 = (state_34743[(2)]);
var state_34743__$1 = state_34743;
var statearr_34783_34819 = state_34743__$1;
(statearr_34783_34819[(2)] = inst_34736);

(statearr_34783_34819[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (10))){
var inst_34701 = (state_34743[(2)]);
var state_34743__$1 = state_34743;
if(cljs.core.truth_(inst_34701)){
var statearr_34784_34820 = state_34743__$1;
(statearr_34784_34820[(1)] = (14));

} else {
var statearr_34785_34821 = state_34743__$1;
(statearr_34785_34821[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (18))){
var inst_34704 = (state_34743[(12)]);
var state_34743__$1 = state_34743;
var statearr_34786_34822 = state_34743__$1;
(statearr_34786_34822[(2)] = inst_34704);

(statearr_34786_34822[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34744 === (8))){
var inst_34691 = (state_34743[(14)]);
var state_34743__$1 = state_34743;
var statearr_34787_34823 = state_34743__$1;
(statearr_34787_34823[(2)] = inst_34691);

(statearr_34787_34823[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__13883__auto__ = null;
var fluree$db$query$fql$state_machine__13883__auto____0 = (function (){
var statearr_34788 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34788[(0)] = fluree$db$query$fql$state_machine__13883__auto__);

(statearr_34788[(1)] = (1));

return statearr_34788;
});
var fluree$db$query$fql$state_machine__13883__auto____1 = (function (state_34743){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_34743);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e34789){var ex__13886__auto__ = e34789;
var statearr_34790_34824 = state_34743;
(statearr_34790_34824[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_34743[(4)]))){
var statearr_34791_34825 = state_34743;
(statearr_34791_34825[(1)] = cljs.core.first((state_34743[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__34826 = state_34743;
state_34743 = G__34826;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__13883__auto__ = function(state_34743){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__13883__auto____1.call(this,state_34743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__13883__auto____0;
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__13883__auto____1;
return fluree$db$query$fql$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_34792 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_34792[(6)] = c__13957__auto__);

return statearr_34792;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4160__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__34828 = arguments.length;
switch (G__34828) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_35016){
var state_val_35017 = (state_35016[(1)]);
if((state_val_35017 === (7))){
var state_35016__$1 = state_35016;
var statearr_35018_35089 = state_35016__$1;
(statearr_35018_35089[(2)] = null);

(statearr_35018_35089[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (20))){
var inst_34869 = (state_35016[(7)]);
var inst_34871 = (state_35016[(8)]);
var inst_34899 = (state_35016[(2)]);
var inst_34900 = fluree.db.util.async.throw_err(inst_34899);
var inst_34901 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34902 = [inst_34869];
var inst_34903 = (new cljs.core.PersistentVector(null,1,(5),inst_34901,inst_34902,null));
var inst_34904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34905 = [inst_34869,inst_34871];
var inst_34906 = (new cljs.core.PersistentVector(null,2,(5),inst_34904,inst_34905,null));
var inst_34907 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_34903,cljs.core._LT_,inst_34906);
var state_35016__$1 = (function (){var statearr_35019 = state_35016;
(statearr_35019[(9)] = inst_34900);

return statearr_35019;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35016__$1,(21),inst_34907);
} else {
if((state_val_35017 === (27))){
var inst_34870 = (state_35016[(10)]);
var inst_34888 = (state_35016[(11)]);
var inst_34936 = (inst_34888.cljs$core$IFn$_invoke$arity$2 ? inst_34888.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_34870) : inst_34888.call(null,cljs.core._GT__EQ_,inst_34870));
var state_35016__$1 = state_35016;
if(cljs.core.truth_(inst_34936)){
var statearr_35020_35090 = state_35016__$1;
(statearr_35020_35090[(1)] = (30));

} else {
var statearr_35021_35091 = state_35016__$1;
(statearr_35021_35091[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (1))){
var state_35016__$1 = state_35016;
var statearr_35022_35092 = state_35016__$1;
(statearr_35022_35092[(2)] = null);

(statearr_35022_35092[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (24))){
var inst_34985 = (state_35016[(2)]);
var state_35016__$1 = state_35016;
var statearr_35023_35093 = state_35016__$1;
(statearr_35023_35093[(2)] = inst_34985);

(statearr_35023_35093[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (39))){
var inst_34975 = null;
var state_35016__$1 = state_35016;
var statearr_35024_35094 = state_35016__$1;
(statearr_35024_35094[(2)] = inst_34975);

(statearr_35024_35094[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (46))){
var inst_34862 = (state_35016[(12)]);
var inst_34996 = (state_35016[(13)]);
var inst_34854 = inst_34862;
var inst_34855 = inst_34996;
var state_35016__$1 = (function (){var statearr_35025 = state_35016;
(statearr_35025[(14)] = inst_34855);

(statearr_35025[(15)] = inst_34854);

return statearr_35025;
})();
var statearr_35026_35095 = state_35016__$1;
(statearr_35026_35095[(2)] = null);

(statearr_35026_35095[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (4))){
var inst_34829 = (state_35016[(2)]);
var state_35016__$1 = state_35016;
var statearr_35027_35096 = state_35016__$1;
(statearr_35027_35096[(2)] = inst_34829);

(statearr_35027_35096[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (15))){
var state_35016__$1 = state_35016;
var statearr_35028_35097 = state_35016__$1;
(statearr_35028_35097[(2)] = null);

(statearr_35028_35097[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (21))){
var inst_34900 = (state_35016[(9)]);
var inst_34909 = (state_35016[(2)]);
var inst_34910 = fluree.db.util.async.throw_err(inst_34909);
var inst_34911 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_34900,inst_34910);
var state_35016__$1 = state_35016;
var statearr_35029_35098 = state_35016__$1;
(statearr_35029_35098[(2)] = inst_34911);

(statearr_35029_35098[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (31))){
var inst_34870 = (state_35016[(10)]);
var inst_34888 = (state_35016[(11)]);
var inst_34949 = (inst_34888.cljs$core$IFn$_invoke$arity$2 ? inst_34888.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_34870) : inst_34888.call(null,cljs.core._LT_,inst_34870));
var state_35016__$1 = state_35016;
if(cljs.core.truth_(inst_34949)){
var statearr_35030_35099 = state_35016__$1;
(statearr_35030_35099[(1)] = (34));

} else {
var statearr_35031_35100 = state_35016__$1;
(statearr_35031_35100[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (32))){
var inst_34981 = (state_35016[(2)]);
var state_35016__$1 = state_35016;
var statearr_35032_35101 = state_35016__$1;
(statearr_35032_35101[(2)] = inst_34981);

(statearr_35032_35101[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (40))){
var inst_34977 = (state_35016[(2)]);
var state_35016__$1 = state_35016;
var statearr_35033_35102 = state_35016__$1;
(statearr_35033_35102[(2)] = inst_34977);

(statearr_35033_35102[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (33))){
var inst_34946 = (state_35016[(2)]);
var inst_34947 = fluree.db.util.async.throw_err(inst_34946);
var state_35016__$1 = state_35016;
var statearr_35034_35103 = state_35016__$1;
(statearr_35034_35103[(2)] = inst_34947);

(statearr_35034_35103[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (13))){
var inst_35006 = (state_35016[(2)]);
var state_35016__$1 = state_35016;
var statearr_35035_35104 = state_35016__$1;
(statearr_35035_35104[(2)] = inst_35006);

(statearr_35035_35104[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (22))){
var inst_34869 = (state_35016[(7)]);
var inst_34871 = (state_35016[(8)]);
var inst_34915 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34916 = [inst_34869,inst_34871];
var inst_34917 = (new cljs.core.PersistentVector(null,2,(5),inst_34915,inst_34916,null));
var inst_34918 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_34917);
var state_35016__$1 = state_35016;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35016__$1,(25),inst_34918);
} else {
if((state_val_35017 === (36))){
var inst_34979 = (state_35016[(2)]);
var state_35016__$1 = state_35016;
var statearr_35036_35105 = state_35016__$1;
(statearr_35036_35105[(2)] = inst_34979);

(statearr_35036_35105[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (41))){
var inst_34972 = (state_35016[(2)]);
var inst_34973 = fluree.db.util.async.throw_err(inst_34972);
var state_35016__$1 = state_35016;
var statearr_35037_35106 = state_35016__$1;
(statearr_35037_35106[(2)] = inst_34973);

(statearr_35037_35106[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (43))){
var inst_34988 = (state_35016[(16)]);
var inst_34855 = (state_35016[(14)]);
var inst_34989 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34855,inst_34988);
var state_35016__$1 = state_35016;
var statearr_35038_35107 = state_35016__$1;
(statearr_35038_35107[(2)] = inst_34989);

(statearr_35038_35107[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (29))){
var inst_34933 = (state_35016[(2)]);
var inst_34934 = fluree.db.util.async.throw_err(inst_34933);
var state_35016__$1 = state_35016;
var statearr_35039_35108 = state_35016__$1;
(statearr_35039_35108[(2)] = inst_34934);

(statearr_35039_35108[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (44))){
var inst_34988 = (state_35016[(16)]);
var inst_34855 = (state_35016[(14)]);
var inst_34991 = cljs.core.PersistentHashSet.EMPTY;
var inst_34992 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_34991,inst_34988);
var inst_34993 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_34855,inst_34992);
var state_35016__$1 = state_35016;
var statearr_35040_35109 = state_35016__$1;
(statearr_35040_35109[(2)] = inst_34993);

(statearr_35040_35109[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (6))){
var inst_34840 = (state_35016[(17)]);
var inst_34850 = cljs.core.seq(inst_34840);
var inst_34851 = cljs.core.first(inst_34850);
var inst_34852 = cljs.core.next(inst_34850);
var inst_34853 = cljs.core.PersistentHashSet.EMPTY;
var inst_34854 = inst_34840;
var inst_34855 = inst_34853;
var state_35016__$1 = (function (){var statearr_35041 = state_35016;
(statearr_35041[(18)] = inst_34852);

(statearr_35041[(19)] = inst_34851);

(statearr_35041[(14)] = inst_34855);

(statearr_35041[(15)] = inst_34854);

return statearr_35041;
})();
var statearr_35042_35110 = state_35016__$1;
(statearr_35042_35110[(2)] = null);

(statearr_35042_35110[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (28))){
var inst_34983 = (state_35016[(2)]);
var state_35016__$1 = state_35016;
var statearr_35043_35111 = state_35016__$1;
(statearr_35043_35111[(2)] = inst_34983);

(statearr_35043_35111[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (25))){
var inst_34920 = (state_35016[(2)]);
var inst_34921 = fluree.db.util.async.throw_err(inst_34920);
var state_35016__$1 = state_35016;
var statearr_35044_35112 = state_35016__$1;
(statearr_35044_35112[(2)] = inst_34921);

(statearr_35044_35112[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (34))){
var inst_34869 = (state_35016[(7)]);
var inst_34871 = (state_35016[(8)]);
var inst_34951 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34952 = [inst_34869];
var inst_34953 = (new cljs.core.PersistentVector(null,1,(5),inst_34951,inst_34952,null));
var inst_34954 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34955 = [inst_34869,inst_34871];
var inst_34956 = (new cljs.core.PersistentVector(null,2,(5),inst_34954,inst_34955,null));
var inst_34957 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_34953,cljs.core._LT_,inst_34956);
var state_35016__$1 = state_35016;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35016__$1,(37),inst_34957);
} else {
if((state_val_35017 === (17))){
var inst_34869 = (state_35016[(7)]);
var inst_34871 = (state_35016[(8)]);
var inst_34891 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34892 = [inst_34869,inst_34871];
var inst_34893 = (new cljs.core.PersistentVector(null,2,(5),inst_34891,inst_34892,null));
var inst_34894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34895 = [inst_34869];
var inst_34896 = (new cljs.core.PersistentVector(null,1,(5),inst_34894,inst_34895,null));
var inst_34897 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_34893,cljs.core._LT__EQ_,inst_34896);
var state_35016__$1 = state_35016;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35016__$1,(20),inst_34897);
} else {
if((state_val_35017 === (3))){
var inst_35014 = (state_35016[(2)]);
var state_35016__$1 = state_35016;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35016__$1,inst_35014);
} else {
if((state_val_35017 === (12))){
var inst_34869 = (state_35016[(7)]);
var inst_34861 = (state_35016[(20)]);
var inst_34869__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34861,(0),null);
var inst_34870 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34861,(1),null);
var inst_34871 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34861,(2),null);
var inst_34872 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_34869__$1);
var inst_34873 = cljs.core.not(inst_34872);
var state_35016__$1 = (function (){var statearr_35045 = state_35016;
(statearr_35045[(7)] = inst_34869__$1);

(statearr_35045[(10)] = inst_34870);

(statearr_35045[(8)] = inst_34871);

return statearr_35045;
})();
if(inst_34873){
var statearr_35046_35113 = state_35016__$1;
(statearr_35046_35113[(1)] = (14));

} else {
var statearr_35047_35114 = state_35016__$1;
(statearr_35047_35114[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (2))){
var inst_34840 = (state_35016[(17)]);
var _ = (function (){var statearr_35048 = state_35016;
(statearr_35048[(4)] = cljs.core.cons((5),(state_35016[(4)])));

return statearr_35048;
})();
var inst_34838 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_34839 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34838,(0),null);
var inst_34840__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34838,(1),null);
var inst_34841 = cljs.core.not_empty(inst_34840__$1);
var state_35016__$1 = (function (){var statearr_35049 = state_35016;
(statearr_35049[(17)] = inst_34840__$1);

(statearr_35049[(21)] = inst_34839);

return statearr_35049;
})();
if(cljs.core.truth_(inst_34841)){
var statearr_35050_35115 = state_35016__$1;
(statearr_35050_35115[(1)] = (6));

} else {
var statearr_35051_35116 = state_35016__$1;
(statearr_35051_35116[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (23))){
var inst_34870 = (state_35016[(10)]);
var inst_34888 = (state_35016[(11)]);
var inst_34923 = (inst_34888.cljs$core$IFn$_invoke$arity$2 ? inst_34888.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_34870) : inst_34888.call(null,cljs.core._GT_,inst_34870));
var state_35016__$1 = state_35016;
if(cljs.core.truth_(inst_34923)){
var statearr_35052_35117 = state_35016__$1;
(statearr_35052_35117[(1)] = (26));

} else {
var statearr_35053_35118 = state_35016__$1;
(statearr_35053_35118[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (47))){
var inst_35004 = (state_35016[(2)]);
var state_35016__$1 = state_35016;
var statearr_35054_35119 = state_35016__$1;
(statearr_35054_35119[(2)] = inst_35004);

(statearr_35054_35119[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (35))){
var inst_34870 = (state_35016[(10)]);
var inst_34888 = (state_35016[(11)]);
var inst_34962 = (inst_34888.cljs$core$IFn$_invoke$arity$2 ? inst_34888.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_34870) : inst_34888.call(null,cljs.core._LT__EQ_,inst_34870));
var state_35016__$1 = state_35016;
if(cljs.core.truth_(inst_34962)){
var statearr_35055_35120 = state_35016__$1;
(statearr_35055_35120[(1)] = (38));

} else {
var statearr_35056_35121 = state_35016__$1;
(statearr_35056_35121[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (19))){
var inst_34839 = (state_35016[(21)]);
var inst_34987 = (state_35016[(2)]);
var inst_34988 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_34987);
var state_35016__$1 = (function (){var statearr_35057 = state_35016;
(statearr_35057[(16)] = inst_34988);

return statearr_35057;
})();
var G__35058_35122 = inst_34839;
var G__35058_35123__$1 = (((G__35058_35122 instanceof cljs.core.Keyword))?G__35058_35122.fqn:null);
switch (G__35058_35123__$1) {
case "or":
var statearr_35059_35125 = state_35016__$1;
(statearr_35059_35125[(1)] = (43));


break;
case "and":
var statearr_35060_35126 = state_35016__$1;
(statearr_35060_35126[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__35058_35123__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (11))){
var inst_34855 = (state_35016[(14)]);
var state_35016__$1 = state_35016;
var statearr_35062_35127 = state_35016__$1;
(statearr_35062_35127[(2)] = inst_34855);

(statearr_35062_35127[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (9))){
var inst_34861 = (state_35016[(20)]);
var inst_34854 = (state_35016[(15)]);
var inst_34860 = cljs.core.seq(inst_34854);
var inst_34861__$1 = cljs.core.first(inst_34860);
var inst_34862 = cljs.core.next(inst_34860);
var inst_34863 = cljs.core.not(inst_34861__$1);
var state_35016__$1 = (function (){var statearr_35063 = state_35016;
(statearr_35063[(12)] = inst_34862);

(statearr_35063[(20)] = inst_34861__$1);

return statearr_35063;
})();
if(inst_34863){
var statearr_35064_35128 = state_35016__$1;
(statearr_35064_35128[(1)] = (11));

} else {
var statearr_35065_35129 = state_35016__$1;
(statearr_35065_35129[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (5))){
var _ = (function (){var statearr_35066 = state_35016;
(statearr_35066[(4)] = cljs.core.rest((state_35016[(4)])));

return statearr_35066;
})();
var state_35016__$1 = state_35016;
var ex35061 = (state_35016__$1[(2)]);
var statearr_35067_35130 = state_35016__$1;
(statearr_35067_35130[(5)] = ex35061);


if((ex35061 instanceof Error)){
var statearr_35068_35131 = state_35016__$1;
(statearr_35068_35131[(1)] = (4));

(statearr_35068_35131[(5)] = null);

} else {
throw ex35061;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (14))){
var inst_34869 = (state_35016[(7)]);
var inst_34875 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_34869);
var inst_34876 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_34875)].join('');
var inst_34877 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34878 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_34879 = cljs.core.PersistentHashMap.fromArrays(inst_34877,inst_34878);
var inst_34880 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34876,inst_34879);
var inst_34881 = (function(){throw inst_34880})();
var state_35016__$1 = state_35016;
var statearr_35069_35132 = state_35016__$1;
(statearr_35069_35132[(2)] = inst_34881);

(statearr_35069_35132[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (45))){
var inst_34996 = (state_35016[(13)]);
var state_35016__$1 = state_35016;
var statearr_35070_35133 = state_35016__$1;
(statearr_35070_35133[(2)] = inst_34996);

(statearr_35070_35133[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (26))){
var inst_34869 = (state_35016[(7)]);
var inst_34871 = (state_35016[(8)]);
var inst_34925 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34926 = [inst_34869,inst_34871];
var inst_34927 = (new cljs.core.PersistentVector(null,2,(5),inst_34925,inst_34926,null));
var inst_34928 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34929 = [inst_34869];
var inst_34930 = (new cljs.core.PersistentVector(null,1,(5),inst_34928,inst_34929,null));
var inst_34931 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_34927,cljs.core._LT__EQ_,inst_34930);
var state_35016__$1 = state_35016;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35016__$1,(29),inst_34931);
} else {
if((state_val_35017 === (16))){
var inst_34870 = (state_35016[(10)]);
var inst_34888 = (state_35016[(11)]);
var inst_34884 = (state_35016[(2)]);
var inst_34888__$1 = cljs.core.identical_QMARK_;
var inst_34889 = (inst_34888__$1.cljs$core$IFn$_invoke$arity$2 ? inst_34888__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_34870) : inst_34888__$1.call(null,cljs.core.not_EQ_,inst_34870));
var state_35016__$1 = (function (){var statearr_35071 = state_35016;
(statearr_35071[(11)] = inst_34888__$1);

(statearr_35071[(22)] = inst_34884);

return statearr_35071;
})();
if(cljs.core.truth_(inst_34889)){
var statearr_35072_35134 = state_35016__$1;
(statearr_35072_35134[(1)] = (17));

} else {
var statearr_35073_35135 = state_35016__$1;
(statearr_35073_35135[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (38))){
var inst_34869 = (state_35016[(7)]);
var inst_34871 = (state_35016[(8)]);
var inst_34964 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34965 = [inst_34869];
var inst_34966 = (new cljs.core.PersistentVector(null,1,(5),inst_34964,inst_34965,null));
var inst_34967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34968 = [inst_34869,inst_34871];
var inst_34969 = (new cljs.core.PersistentVector(null,2,(5),inst_34967,inst_34968,null));
var inst_34970 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_34966,cljs.core._LT__EQ_,inst_34969);
var state_35016__$1 = state_35016;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35016__$1,(41),inst_34970);
} else {
if((state_val_35017 === (30))){
var inst_34869 = (state_35016[(7)]);
var inst_34871 = (state_35016[(8)]);
var inst_34938 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34939 = [inst_34869,inst_34871];
var inst_34940 = (new cljs.core.PersistentVector(null,2,(5),inst_34938,inst_34939,null));
var inst_34941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34942 = [inst_34869];
var inst_34943 = (new cljs.core.PersistentVector(null,1,(5),inst_34941,inst_34942,null));
var inst_34944 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_34940,cljs.core._LT__EQ_,inst_34943);
var state_35016__$1 = state_35016;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35016__$1,(33),inst_34944);
} else {
if((state_val_35017 === (10))){
var inst_35008 = (state_35016[(2)]);
var state_35016__$1 = state_35016;
var statearr_35074_35136 = state_35016__$1;
(statearr_35074_35136[(2)] = inst_35008);

(statearr_35074_35136[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (18))){
var inst_34870 = (state_35016[(10)]);
var inst_34888 = (state_35016[(11)]);
var inst_34913 = (inst_34888.cljs$core$IFn$_invoke$arity$2 ? inst_34888.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_34870) : inst_34888.call(null,cljs.core._EQ_,inst_34870));
var state_35016__$1 = state_35016;
if(cljs.core.truth_(inst_34913)){
var statearr_35075_35137 = state_35016__$1;
(statearr_35075_35137[(1)] = (22));

} else {
var statearr_35076_35138 = state_35016__$1;
(statearr_35076_35138[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (42))){
var inst_34996 = (state_35016[(13)]);
var inst_34839 = (state_35016[(21)]);
var inst_34996__$1 = (state_35016[(2)]);
var inst_34997 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_34839);
var inst_34998 = cljs.core.empty_QMARK_(inst_34996__$1);
var inst_34999 = ((inst_34997) && (inst_34998));
var state_35016__$1 = (function (){var statearr_35077 = state_35016;
(statearr_35077[(13)] = inst_34996__$1);

return statearr_35077;
})();
if(cljs.core.truth_(inst_34999)){
var statearr_35078_35139 = state_35016__$1;
(statearr_35078_35139[(1)] = (45));

} else {
var statearr_35079_35140 = state_35016__$1;
(statearr_35079_35140[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (37))){
var inst_34959 = (state_35016[(2)]);
var inst_34960 = fluree.db.util.async.throw_err(inst_34959);
var state_35016__$1 = state_35016;
var statearr_35080_35141 = state_35016__$1;
(statearr_35080_35141[(2)] = inst_34960);

(statearr_35080_35141[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35017 === (8))){
var inst_35011 = (state_35016[(2)]);
var _ = (function (){var statearr_35081 = state_35016;
(statearr_35081[(4)] = cljs.core.rest((state_35016[(4)])));

return statearr_35081;
})();
var state_35016__$1 = state_35016;
var statearr_35082_35142 = state_35016__$1;
(statearr_35082_35142[(2)] = inst_35011);

(statearr_35082_35142[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__13883__auto__ = null;
var fluree$db$query$fql$state_machine__13883__auto____0 = (function (){
var statearr_35083 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35083[(0)] = fluree$db$query$fql$state_machine__13883__auto__);

(statearr_35083[(1)] = (1));

return statearr_35083;
});
var fluree$db$query$fql$state_machine__13883__auto____1 = (function (state_35016){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_35016);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e35084){var ex__13886__auto__ = e35084;
var statearr_35085_35143 = state_35016;
(statearr_35085_35143[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_35016[(4)]))){
var statearr_35086_35144 = state_35016;
(statearr_35086_35144[(1)] = cljs.core.first((state_35016[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__35145 = state_35016;
state_35016 = G__35145;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__13883__auto__ = function(state_35016){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__13883__auto____1.call(this,state_35016);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__13883__auto____0;
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__13883__auto____1;
return fluree$db$query$fql$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_35087 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_35087[(6)] = c__13957__auto__);

return statearr_35087;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4160__auto__ = cljs.core.every_QMARK_((function (p1__35146_SHARP_){
return ((typeof p1__35146_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__35146_SHARP_)));
}),select_smt);
if(or__4160__auto__){
return or__4160__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__35147_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__35147_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__35151 = vars;
var vec__35152 = G__35151;
var seq__35153 = cljs.core.seq(vec__35152);
var first__35154 = cljs.core.first(seq__35153);
var seq__35153__$1 = cljs.core.next(seq__35153);
var var$ = first__35154;
var r = seq__35153__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__35151__$1 = G__35151;
var all_vars__$1 = all_vars;
while(true){
var vec__35159 = G__35151__$1;
var seq__35160 = cljs.core.seq(vec__35159);
var first__35161 = cljs.core.first(seq__35160);
var seq__35160__$1 = cljs.core.next(seq__35160);
var var$__$1 = first__35161;
var r__$1 = seq__35160__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__35162 = cljs.core.set(all_vars__$2);
return (fexpr__35162.cljs$core$IFn$_invoke$arity$1 ? fexpr__35162.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__35162.call(null,var$__$1));
})())){
var G__35163 = r__$1;
var G__35164 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__35151__$1 = G__35163;
all_vars__$1 = G__35164;
continue;
} else {
var G__35165 = r__$1;
var G__35166 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__35151__$1 = G__35165;
all_vars__$1 = G__35166;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_35201){
var state_val_35202 = (state_35201[(1)]);
if((state_val_35202 === (1))){
var inst_35174 = functionArray;
var inst_35175 = cljs.core.seq(inst_35174);
var inst_35176 = cljs.core.first(inst_35175);
var inst_35177 = cljs.core.next(inst_35175);
var inst_35178 = cljs.core.PersistentVector.EMPTY;
var inst_35179 = inst_35174;
var inst_35180 = inst_35178;
var state_35201__$1 = (function (){var statearr_35203 = state_35201;
(statearr_35203[(7)] = inst_35177);

(statearr_35203[(8)] = inst_35180);

(statearr_35203[(9)] = inst_35179);

(statearr_35203[(10)] = inst_35176);

return statearr_35203;
})();
var statearr_35204_35217 = state_35201__$1;
(statearr_35204_35217[(2)] = null);

(statearr_35204_35217[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35202 === (2))){
var inst_35179 = (state_35201[(9)]);
var inst_35186 = (state_35201[(11)]);
var inst_35185 = cljs.core.seq(inst_35179);
var inst_35186__$1 = cljs.core.first(inst_35185);
var inst_35187 = cljs.core.next(inst_35185);
var state_35201__$1 = (function (){var statearr_35205 = state_35201;
(statearr_35205[(12)] = inst_35187);

(statearr_35205[(11)] = inst_35186__$1);

return statearr_35205;
})();
if(cljs.core.truth_(inst_35186__$1)){
var statearr_35206_35218 = state_35201__$1;
(statearr_35206_35218[(1)] = (4));

} else {
var statearr_35207_35219 = state_35201__$1;
(statearr_35207_35219[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35202 === (3))){
var inst_35199 = (state_35201[(2)]);
var state_35201__$1 = state_35201;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35201__$1,inst_35199);
} else {
if((state_val_35202 === (4))){
var inst_35186 = (state_35201[(11)]);
var inst_35189 = (inst_35186.cljs$core$IFn$_invoke$arity$1 ? inst_35186.cljs$core$IFn$_invoke$arity$1(tuple) : inst_35186.call(null,tuple));
var state_35201__$1 = state_35201;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35201__$1,(7),inst_35189);
} else {
if((state_val_35202 === (5))){
var inst_35180 = (state_35201[(8)]);
var state_35201__$1 = state_35201;
var statearr_35208_35220 = state_35201__$1;
(statearr_35208_35220[(2)] = inst_35180);

(statearr_35208_35220[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35202 === (6))){
var inst_35197 = (state_35201[(2)]);
var state_35201__$1 = state_35201;
var statearr_35209_35221 = state_35201__$1;
(statearr_35209_35221[(2)] = inst_35197);

(statearr_35209_35221[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35202 === (7))){
var inst_35187 = (state_35201[(12)]);
var inst_35180 = (state_35201[(8)]);
var inst_35191 = (state_35201[(2)]);
var inst_35192 = fluree.db.util.async.throw_err(inst_35191);
var inst_35193 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35180,inst_35192);
var inst_35179 = inst_35187;
var inst_35180__$1 = inst_35193;
var state_35201__$1 = (function (){var statearr_35210 = state_35201;
(statearr_35210[(8)] = inst_35180__$1);

(statearr_35210[(9)] = inst_35179);

return statearr_35210;
})();
var statearr_35211_35222 = state_35201__$1;
(statearr_35211_35222[(2)] = null);

(statearr_35211_35222[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__13883__auto____0 = (function (){
var statearr_35212 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35212[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__13883__auto__);

(statearr_35212[(1)] = (1));

return statearr_35212;
});
var fluree$db$query$fql$format_tuple_$_state_machine__13883__auto____1 = (function (state_35201){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_35201);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e35213){var ex__13886__auto__ = e35213;
var statearr_35214_35223 = state_35201;
(statearr_35214_35223[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_35201[(4)]))){
var statearr_35215_35224 = state_35201;
(statearr_35215_35224[(1)] = cljs.core.first((state_35201[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__35225 = state_35201;
state_35201 = G__35225;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__13883__auto__ = function(state_35201){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__13883__auto____1.call(this,state_35201);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__13883__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__13883__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_35216 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_35216[(6)] = c__13957__auto__);

return statearr_35216;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5753__auto__ = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__35226){
var vec__35227 = p__35226;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35227,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35227,(1),null);
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_35241){
var state_val_35242 = (state_35241[(1)]);
if((state_val_35242 === (1))){
var inst_35230 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35231 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_35232 = [query_map,_id,query_opts];
var inst_35233 = cljs.core.PersistentHashMap.fromArrays(inst_35231,inst_35232);
var inst_35234 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_35233) : fluree.db.query.fql.query.call(null,db,inst_35233));
var state_35241__$1 = (function (){var statearr_35243 = state_35241;
(statearr_35243[(7)] = inst_35230);

return statearr_35243;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35241__$1,(2),inst_35234);
} else {
if((state_val_35242 === (2))){
var inst_35230 = (state_35241[(7)]);
var inst_35236 = (state_35241[(2)]);
var inst_35237 = fluree.db.util.async.throw_err(inst_35236);
var inst_35238 = [tuple_index,inst_35237];
var inst_35239 = (new cljs.core.PersistentVector(null,2,(5),inst_35230,inst_35238,null));
var state_35241__$1 = state_35241;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35241__$1,inst_35239);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__13883__auto____0 = (function (){
var statearr_35244 = [null,null,null,null,null,null,null,null];
(statearr_35244[(0)] = fluree$db$query$fql$expand_map_$_state_machine__13883__auto__);

(statearr_35244[(1)] = (1));

return statearr_35244;
});
var fluree$db$query$fql$expand_map_$_state_machine__13883__auto____1 = (function (state_35241){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_35241);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e35245){var ex__13886__auto__ = e35245;
var statearr_35246_35249 = state_35241;
(statearr_35246_35249[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_35241[(4)]))){
var statearr_35247_35250 = state_35241;
(statearr_35247_35250[(1)] = cljs.core.first((state_35241[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__35251 = state_35241;
state_35241 = G__35251;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__13883__auto__ = function(state_35241){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__13883__auto____1.call(this,state_35241);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__13883__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__13883__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_35248 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_35248[(6)] = c__13957__auto__);

return statearr_35248;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__35252 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35252,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35252,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_35317){
var state_val_35318 = (state_35317[(1)]);
if((state_val_35318 === (7))){
var inst_35312 = (state_35317[(2)]);
var _ = (function (){var statearr_35319 = state_35317;
(statearr_35319[(4)] = cljs.core.rest((state_35317[(4)])));

return statearr_35319;
})();
var state_35317__$1 = state_35317;
var statearr_35320_35411 = state_35317__$1;
(statearr_35320_35411[(2)] = inst_35312);

(statearr_35320_35411[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35318 === (20))){
var inst_35303 = (state_35317[(2)]);
var state_35317__$1 = state_35317;
var statearr_35321_35412 = state_35317__$1;
(statearr_35321_35412[(2)] = inst_35303);

(statearr_35321_35412[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35318 === (1))){
var state_35317__$1 = state_35317;
var statearr_35322_35413 = state_35317__$1;
(statearr_35322_35413[(2)] = null);

(statearr_35322_35413[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35318 === (4))){
var inst_35257 = (state_35317[(2)]);
var state_35317__$1 = state_35317;
var statearr_35323_35414 = state_35317__$1;
(statearr_35323_35414[(2)] = inst_35257);

(statearr_35323_35414[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35318 === (15))){
var inst_35277 = (state_35317[(7)]);
var inst_35286 = cljs.core._deref(fuel);
var inst_35287 = cljs.core.second(inst_35277);
var inst_35288 = (inst_35286 + inst_35287);
var inst_35289 = cljs.core._vreset_BANG_(fuel,inst_35288);
var inst_35290 = (inst_35289 > max_fuel);
var state_35317__$1 = state_35317;
if(cljs.core.truth_(inst_35290)){
var statearr_35324_35415 = state_35317__$1;
(statearr_35324_35415[(1)] = (18));

} else {
var statearr_35325_35416 = state_35317__$1;
(statearr_35325_35416[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35318 === (13))){
var state_35317__$1 = state_35317;
var statearr_35326_35417 = state_35317__$1;
(statearr_35326_35417[(1)] = (15));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35318 === (6))){
var inst_35265 = (state_35317[(8)]);
var state_35317__$1 = state_35317;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35317__$1,(8),inst_35265);
} else {
if((state_val_35318 === (17))){
var inst_35306 = (state_35317[(2)]);
var state_35317__$1 = state_35317;
var statearr_35328_35418 = state_35317__$1;
(statearr_35328_35418[(2)] = inst_35306);

(statearr_35328_35418[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35318 === (3))){
var inst_35315 = (state_35317[(2)]);
var state_35317__$1 = state_35317;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35317__$1,inst_35315);
} else {
if((state_val_35318 === (12))){
var inst_35266 = (state_35317[(9)]);
var inst_35277 = (state_35317[(7)]);
var inst_35283 = (inst_35266.cljs$core$IFn$_invoke$arity$0 ? inst_35266.cljs$core$IFn$_invoke$arity$0() : inst_35266.call(null));
var state_35317__$1 = (function (){var statearr_35329 = state_35317;
(statearr_35329[(10)] = inst_35283);

return statearr_35329;
})();
var statearr_35330_35419 = state_35317__$1;
(statearr_35330_35419[(2)] = inst_35277);

(statearr_35330_35419[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35318 === (2))){
var inst_35265 = (state_35317[(8)]);
var inst_35266 = (state_35317[(9)]);
var _ = (function (){var statearr_35331 = state_35317;
(statearr_35331[(4)] = cljs.core.cons((5),(state_35317[(4)])));

return statearr_35331;
})();
var inst_35263 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_35264 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_35265__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_35266__$1 = (function (){var expandMaps = inst_35263;
var queue_ch = inst_35264;
var res_ch = inst_35265__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_35267 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$limit,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$groupBy], 0));
var inst_35268 = cljs.core.volatile_BANG_((0));
var inst_35269 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35267,cljs.core.cst$kw$fuel,inst_35268);
var inst_35270 = (function (){var expandMaps = inst_35263;
var queue_ch = inst_35264;
var res_ch = inst_35265__$1;
var stop_BANG_ = inst_35266__$1;
var opts_STAR_ = inst_35269;
return (function (tuple_res,port){
var c__13957__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_35364){
var state_val_35365 = (state_35364[(1)]);
if((state_val_35365 === (7))){
var state_35364__$1 = state_35364;
var statearr_35366_35420 = state_35364__$1;
(statearr_35366_35420[(2)] = tuple_res);

(statearr_35366_35420[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (1))){
var state_35364__$1 = state_35364;
var statearr_35367_35421 = state_35364__$1;
(statearr_35367_35421[(2)] = null);

(statearr_35367_35421[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (4))){
var inst_35332 = (state_35364[(2)]);
var inst_35333 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_35332);
var inst_35334 = cljs.core.async.close_BANG_(port);
var state_35364__$1 = (function (){var statearr_35368 = state_35364;
(statearr_35368[(7)] = inst_35333);

return statearr_35368;
})();
var statearr_35369_35422 = state_35364__$1;
(statearr_35369_35422[(2)] = inst_35334);

(statearr_35369_35422[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (6))){
var inst_35341 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35342 = [tuple_res];
var inst_35343 = (new cljs.core.PersistentVector(null,1,(5),inst_35341,inst_35342,null));
var state_35364__$1 = state_35364;
var statearr_35370_35423 = state_35364__$1;
(statearr_35370_35423[(2)] = inst_35343);

(statearr_35370_35423[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (3))){
var inst_35362 = (state_35364[(2)]);
var state_35364__$1 = state_35364;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35364__$1,inst_35362);
} else {
if((state_val_35365 === (2))){
var ___$1 = (function (){var statearr_35372 = state_35364;
(statearr_35372[(4)] = cljs.core.cons((5),(state_35364[(4)])));

return statearr_35372;
})();
var state_35364__$1 = state_35364;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_35373_35424 = state_35364__$1;
(statearr_35373_35424[(1)] = (6));

} else {
var statearr_35374_35425 = state_35364__$1;
(statearr_35374_35425[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (9))){
var inst_35346 = (state_35364[(8)]);
var inst_35348 = (state_35364[(9)]);
var inst_35355 = (state_35364[(2)]);
var inst_35356 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_35346,inst_35355);
var inst_35357 = (inst_35348.cljs$core$IFn$_invoke$arity$1 ? inst_35348.cljs$core$IFn$_invoke$arity$1(inst_35356) : inst_35348.call(null,inst_35356));
var inst_35358 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_35357);
var inst_35359 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_35375 = state_35364;
(statearr_35375[(4)] = cljs.core.rest((state_35364[(4)])));

return statearr_35375;
})();
var state_35364__$1 = (function (){var statearr_35376 = state_35364;
(statearr_35376[(10)] = inst_35358);

return statearr_35376;
})();
var statearr_35377_35426 = state_35364__$1;
(statearr_35377_35426[(2)] = inst_35359);

(statearr_35377_35426[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (5))){
var ___$1 = (function (){var statearr_35378 = state_35364;
(statearr_35378[(4)] = cljs.core.rest((state_35364[(4)])));

return statearr_35378;
})();
var state_35364__$1 = state_35364;
var ex35371 = (state_35364__$1[(2)]);
var statearr_35379_35427 = state_35364__$1;
(statearr_35379_35427[(5)] = ex35371);


var statearr_35380_35428 = state_35364__$1;
(statearr_35380_35428[(1)] = (4));

(statearr_35380_35428[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_35365 === (8))){
var inst_35346 = (state_35364[(8)]);
var inst_35346__$1 = (state_35364[(2)]);
var inst_35347 = cljs.core.volatile_BANG_((0));
var inst_35348 = (function (){var tuple_res_SINGLEQUOTE_ = inst_35346__$1;
var query_fuel = inst_35347;
return (function (p1__35256_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__35256_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__35256_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_35349 = cljs.core.PersistentVector.EMPTY;
var inst_35350 = (function (){var tuple_res_SINGLEQUOTE_ = inst_35346__$1;
var query_fuel = inst_35347;
return (function (p1__35255_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,cljs.core.cst$kw$fuel,fuel),tuple_res_SINGLEQUOTE_,p1__35255_SHARP_);
});
})();
var inst_35351 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_35350,expandMaps);
var inst_35352 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_35351);
var inst_35353 = cljs.core.async.into(inst_35349,inst_35352);
var state_35364__$1 = (function (){var statearr_35381 = state_35364;
(statearr_35381[(8)] = inst_35346__$1);

(statearr_35381[(9)] = inst_35348);

return statearr_35381;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35364__$1,(9),inst_35353);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____0 = (function (){
var statearr_35382 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_35382[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__);

(statearr_35382[(1)] = (1));

return statearr_35382;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____1 = (function (state_35364){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_35364);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e35383){var ex__13886__auto__ = e35383;
var statearr_35384_35429 = state_35364;
(statearr_35384_35429[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_35364[(4)]))){
var statearr_35385_35430 = state_35364;
(statearr_35385_35430[(1)] = cljs.core.first((state_35364[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__35431 = state_35364;
state_35364 = G__35431;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__ = function(state_35364){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____1.call(this,state_35364);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_35386 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_35386[(6)] = c__13957__auto____$1);

return statearr_35386;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto____$1;
});
})();
var inst_35271 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_35264,tuples_res);
var inst_35272 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_35265__$1,inst_35270,inst_35264);
var inst_35273 = cljs.core.PersistentVector.EMPTY;
var inst_35274 = inst_35273;
var state_35317__$1 = (function (){var statearr_35387 = state_35317;
(statearr_35387[(8)] = inst_35265__$1);

(statearr_35387[(9)] = inst_35266__$1);

(statearr_35387[(11)] = inst_35271);

(statearr_35387[(12)] = inst_35274);

(statearr_35387[(13)] = inst_35272);

return statearr_35387;
})();
var statearr_35388_35432 = state_35317__$1;
(statearr_35388_35432[(2)] = null);

(statearr_35388_35432[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35318 === (19))){
var inst_35274 = (state_35317[(12)]);
var inst_35277 = (state_35317[(7)]);
var inst_35299 = cljs.core.first(inst_35277);
var inst_35300 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35274,inst_35299);
var inst_35274__$1 = inst_35300;
var state_35317__$1 = (function (){var statearr_35389 = state_35317;
(statearr_35389[(12)] = inst_35274__$1);

return statearr_35389;
})();
var statearr_35390_35433 = state_35317__$1;
(statearr_35390_35433[(2)] = null);

(statearr_35390_35433[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35318 === (11))){
var inst_35310 = (state_35317[(2)]);
var state_35317__$1 = state_35317;
var statearr_35392_35434 = state_35317__$1;
(statearr_35392_35434[(2)] = inst_35310);

(statearr_35392_35434[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35318 === (9))){
var inst_35274 = (state_35317[(12)]);
var state_35317__$1 = state_35317;
var statearr_35393_35435 = state_35317__$1;
(statearr_35393_35435[(2)] = inst_35274);

(statearr_35393_35435[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35318 === (5))){
var _ = (function (){var statearr_35394 = state_35317;
(statearr_35394[(4)] = cljs.core.rest((state_35317[(4)])));

return statearr_35394;
})();
var state_35317__$1 = state_35317;
var ex35391 = (state_35317__$1[(2)]);
var statearr_35395_35436 = state_35317__$1;
(statearr_35395_35436[(5)] = ex35391);


if((ex35391 instanceof Error)){
var statearr_35396_35437 = state_35317__$1;
(statearr_35396_35437[(1)] = (4));

(statearr_35396_35437[(5)] = null);

} else {
throw ex35391;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35318 === (14))){
var inst_35308 = (state_35317[(2)]);
var state_35317__$1 = state_35317;
var statearr_35397_35438 = state_35317__$1;
(statearr_35397_35438[(2)] = inst_35308);

(statearr_35397_35438[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35318 === (16))){
var state_35317__$1 = state_35317;
var statearr_35398_35439 = state_35317__$1;
(statearr_35398_35439[(2)] = null);

(statearr_35398_35439[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35318 === (10))){
var inst_35277 = (state_35317[(7)]);
var inst_35281 = fluree.db.util.core.exception_QMARK_(inst_35277);
var state_35317__$1 = state_35317;
if(inst_35281){
var statearr_35399_35440 = state_35317__$1;
(statearr_35399_35440[(1)] = (12));

} else {
var statearr_35400_35441 = state_35317__$1;
(statearr_35400_35441[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35318 === (18))){
var inst_35266 = (state_35317[(9)]);
var inst_35292 = (inst_35266.cljs$core$IFn$_invoke$arity$0 ? inst_35266.cljs$core$IFn$_invoke$arity$0() : inst_35266.call(null));
var inst_35293 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_35294 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_35295 = [cljs.core.cst$kw$db_SLASH_insufficient_DASH_fuel,(400)];
var inst_35296 = cljs.core.PersistentHashMap.fromArrays(inst_35294,inst_35295);
var inst_35297 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35293,inst_35296);
var state_35317__$1 = (function (){var statearr_35401 = state_35317;
(statearr_35401[(14)] = inst_35292);

return statearr_35401;
})();
var statearr_35402_35442 = state_35317__$1;
(statearr_35402_35442[(2)] = inst_35297);

(statearr_35402_35442[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35318 === (8))){
var inst_35277 = (state_35317[(7)]);
var inst_35277__$1 = (state_35317[(2)]);
var inst_35278 = (inst_35277__$1 == null);
var state_35317__$1 = (function (){var statearr_35403 = state_35317;
(statearr_35403[(7)] = inst_35277__$1);

return statearr_35403;
})();
if(cljs.core.truth_(inst_35278)){
var statearr_35404_35443 = state_35317__$1;
(statearr_35404_35443[(1)] = (9));

} else {
var statearr_35405_35444 = state_35317__$1;
(statearr_35405_35444[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____0 = (function (){
var statearr_35406 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35406[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__);

(statearr_35406[(1)] = (1));

return statearr_35406;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____1 = (function (state_35317){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_35317);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e35407){var ex__13886__auto__ = e35407;
var statearr_35408_35445 = state_35317;
(statearr_35408_35445[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_35317[(4)]))){
var statearr_35409_35446 = state_35317;
(statearr_35409_35446[(1)] = cljs.core.first((state_35317[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__35447 = state_35317;
state_35317 = G__35447;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__ = function(state_35317){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____1.call(this,state_35317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_35410 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_35410[(6)] = c__13957__auto__);

return statearr_35410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__35448 = select;
var map__35448__$1 = cljs.core.__destructure_map(map__35448);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35448__$1,cljs.core.cst$kw$as);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35448__$1,cljs.core.cst$kw$variable);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35448__$1,cljs.core.cst$kw$value);
var select_val = (function (){var or__4160__auto__ = as;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__35451 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35451,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35451,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35451,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__35449_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__35449_SHARP_,compare_idx));
}):(function (p1__35450_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__35450_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + (((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples))));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__35456 = arguments.length;
switch (G__35456) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__35457,p__35458,group_limit,opts){
var map__35459 = p__35457;
var map__35459__$1 = cljs.core.__destructure_map(map__35459);
var res = map__35459__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35459__$1,cljs.core.cst$kw$vars);
var map__35460 = p__35458;
var map__35460__$1 = cljs.core.__destructure_map(map__35460);
var select_spec = map__35460__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35460__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35460__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35460__$1,cljs.core.cst$kw$orderBy);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35460__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35460__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35460__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35460__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35460__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35460__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35460__$1,cljs.core.cst$kw$groupBy);
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_35594){
var state_val_35595 = (state_35594[(1)]);
if((state_val_35595 === (7))){
var inst_35467 = (state_35594[(7)]);
var state_35594__$1 = state_35594;
var statearr_35596_35693 = state_35594__$1;
(statearr_35596_35693[(2)] = inst_35467);

(statearr_35596_35693[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (20))){
var inst_35503 = (state_35594[(8)]);
var inst_35506 = (state_35594[(9)]);
var inst_35502 = (state_35594[(2)]);
var inst_35503__$1 = cljs.core.__destructure_map(inst_35502);
var inst_35504 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35503__$1,cljs.core.cst$kw$headers);
var inst_35505 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_35503__$1,cljs.core.cst$kw$tuples);
var inst_35506__$1 = offset;
var state_35594__$1 = (function (){var statearr_35597 = state_35594;
(statearr_35597[(8)] = inst_35503__$1);

(statearr_35597[(9)] = inst_35506__$1);

(statearr_35597[(10)] = inst_35504);

(statearr_35597[(11)] = inst_35505);

return statearr_35597;
})();
if(cljs.core.truth_(inst_35506__$1)){
var statearr_35598_35694 = state_35594__$1;
(statearr_35598_35694[(1)] = (21));

} else {
var statearr_35599_35695 = state_35594__$1;
(statearr_35599_35695[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (27))){
var inst_35520 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_35594__$1 = state_35594;
var statearr_35600_35696 = state_35594__$1;
(statearr_35600_35696[(2)] = inst_35520);

(statearr_35600_35696[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (1))){
var state_35594__$1 = state_35594;
var statearr_35601_35697 = state_35594__$1;
(statearr_35601_35697[(2)] = null);

(statearr_35601_35697[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (24))){
var state_35594__$1 = state_35594;
var statearr_35602_35698 = state_35594__$1;
(statearr_35602_35698[(2)] = offset);

(statearr_35602_35698[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (55))){
var inst_35579 = (state_35594[(12)]);
var state_35594__$1 = state_35594;
var statearr_35603_35699 = state_35594__$1;
(statearr_35603_35699[(2)] = inst_35579);

(statearr_35603_35699[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (39))){
var inst_35515 = (state_35594[(13)]);
var inst_35547 = (state_35594[(14)]);
var inst_35549 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_35515);
var inst_35550 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35547,inst_35549);
var state_35594__$1 = state_35594;
var statearr_35604_35700 = state_35594__$1;
(statearr_35604_35700[(2)] = inst_35550);

(statearr_35604_35700[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (46))){
var inst_35559 = (state_35594[(15)]);
var state_35594__$1 = state_35594;
var statearr_35605_35701 = state_35594__$1;
(statearr_35605_35701[(2)] = inst_35559);

(statearr_35605_35701[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (4))){
var inst_35461 = (state_35594[(2)]);
var state_35594__$1 = state_35594;
var statearr_35606_35702 = state_35594__$1;
(statearr_35606_35702[(2)] = inst_35461);

(statearr_35606_35702[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (54))){
var inst_35518 = (state_35594[(16)]);
var inst_35523 = (state_35594[(17)]);
var inst_35579 = (state_35594[(12)]);
var inst_35581 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_35523,inst_35518,db,fuel,max_fuel,opts,(8),inst_35579);
var state_35594__$1 = state_35594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35594__$1,(57),inst_35581);
} else {
if((state_val_35595 === (15))){
var inst_35488 = (state_35594[(18)]);
var inst_35490 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35491 = [inst_35488];
var inst_35492 = (new cljs.core.PersistentVector(null,1,(5),inst_35490,inst_35491,null));
var state_35594__$1 = state_35594;
var statearr_35607_35703 = state_35594__$1;
(statearr_35607_35703[(2)] = inst_35492);

(statearr_35607_35703[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (48))){
var inst_35504 = (state_35594[(10)]);
var inst_35505 = (state_35594[(11)]);
var inst_35570 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_35504,orderBy,inst_35505);
var state_35594__$1 = state_35594;
var statearr_35608_35704 = state_35594__$1;
(statearr_35608_35704[(2)] = inst_35570);

(statearr_35608_35704[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (50))){
var inst_35573 = (state_35594[(2)]);
var state_35594__$1 = (function (){var statearr_35609 = state_35594;
(statearr_35609[(19)] = inst_35573);

return statearr_35609;
})();
var statearr_35610_35705 = state_35594__$1;
(statearr_35610_35705[(1)] = (51));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (21))){
var inst_35508 = cljs.core.not(groupBy);
var state_35594__$1 = state_35594;
var statearr_35612_35706 = state_35594__$1;
(statearr_35612_35706[(2)] = inst_35508);

(statearr_35612_35706[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (31))){
var inst_35529 = (state_35594[(20)]);
var state_35594__$1 = state_35594;
var statearr_35613_35707 = state_35594__$1;
(statearr_35613_35707[(2)] = inst_35529);

(statearr_35613_35707[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (32))){
var inst_35535 = (state_35594[(2)]);
var state_35594__$1 = (function (){var statearr_35614 = state_35594;
(statearr_35614[(21)] = inst_35535);

return statearr_35614;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_35615_35708 = state_35594__$1;
(statearr_35615_35708[(1)] = (33));

} else {
var statearr_35616_35709 = state_35594__$1;
(statearr_35616_35709[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (40))){
var inst_35547 = (state_35594[(14)]);
var state_35594__$1 = state_35594;
var statearr_35617_35710 = state_35594__$1;
(statearr_35617_35710[(2)] = inst_35547);

(statearr_35617_35710[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (56))){
var inst_35587 = (state_35594[(2)]);
var state_35594__$1 = state_35594;
var statearr_35618_35711 = state_35594__$1;
(statearr_35618_35711[(2)] = inst_35587);

(statearr_35618_35711[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (33))){
var inst_35535 = (state_35594[(21)]);
var inst_35537 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_35538 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35535,inst_35537);
var state_35594__$1 = state_35594;
var statearr_35619_35712 = state_35594__$1;
(statearr_35619_35712[(2)] = inst_35538);

(statearr_35619_35712[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (13))){
var inst_35477 = (state_35594[(22)]);
var state_35594__$1 = state_35594;
var statearr_35620_35713 = state_35594__$1;
(statearr_35620_35713[(2)] = inst_35477);

(statearr_35620_35713[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (22))){
var inst_35506 = (state_35594[(9)]);
var state_35594__$1 = state_35594;
var statearr_35621_35714 = state_35594__$1;
(statearr_35621_35714[(2)] = inst_35506);

(statearr_35621_35714[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (36))){
var inst_35541 = (state_35594[(23)]);
var inst_35543 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_35544 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35541,inst_35543);
var state_35594__$1 = state_35594;
var statearr_35622_35715 = state_35594__$1;
(statearr_35622_35715[(2)] = inst_35544);

(statearr_35622_35715[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (41))){
var inst_35553 = (state_35594[(2)]);
var state_35594__$1 = (function (){var statearr_35623 = state_35594;
(statearr_35623[(24)] = inst_35553);

return statearr_35623;
})();
if(cljs.core.truth_(group_limit)){
var statearr_35624_35716 = state_35594__$1;
(statearr_35624_35716[(1)] = (42));

} else {
var statearr_35625_35717 = state_35594__$1;
(statearr_35625_35717[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (43))){
var inst_35553 = (state_35594[(24)]);
var state_35594__$1 = state_35594;
var statearr_35626_35718 = state_35594__$1;
(statearr_35626_35718[(2)] = inst_35553);

(statearr_35626_35718[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (29))){
var inst_35504 = (state_35594[(10)]);
var inst_35518 = (state_35594[(16)]);
var inst_35523 = (state_35594[(2)]);
var inst_35525 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35526 = fluree.db.query.fql.select_tuples_fn(inst_35504,vars,select);
var inst_35527 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_35526);
var inst_35528 = [inst_35527];
var inst_35529 = (new cljs.core.PersistentVector(null,1,(5),inst_35525,inst_35528,null));
var state_35594__$1 = (function (){var statearr_35627 = state_35594;
(statearr_35627[(20)] = inst_35529);

(statearr_35627[(17)] = inst_35523);

return statearr_35627;
})();
if(cljs.core.truth_(inst_35518)){
var statearr_35628_35719 = state_35594__$1;
(statearr_35628_35719[(1)] = (30));

} else {
var statearr_35629_35720 = state_35594__$1;
(statearr_35629_35720[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (44))){
var inst_35559 = (state_35594[(2)]);
var state_35594__$1 = (function (){var statearr_35630 = state_35594;
(statearr_35630[(15)] = inst_35559);

return statearr_35630;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_35631_35721 = state_35594__$1;
(statearr_35631_35721[(1)] = (45));

} else {
var statearr_35632_35722 = state_35594__$1;
(statearr_35632_35722[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (6))){
var inst_35469 = cljs.core.count(select);
var inst_35470 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_35469);
var state_35594__$1 = state_35594;
var statearr_35633_35723 = state_35594__$1;
(statearr_35633_35723[(2)] = inst_35470);

(statearr_35633_35723[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (28))){
var state_35594__$1 = state_35594;
var statearr_35634_35724 = state_35594__$1;
(statearr_35634_35724[(2)] = null);

(statearr_35634_35724[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (51))){
var inst_35573 = (state_35594[(19)]);
var inst_35567 = (state_35594[(25)]);
var inst_35575 = cljs.core.PersistentVector.EMPTY;
var inst_35576 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_35575,inst_35567,inst_35573);
var state_35594__$1 = state_35594;
var statearr_35635_35725 = state_35594__$1;
(statearr_35635_35725[(2)] = inst_35576);

(statearr_35635_35725[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (25))){
var state_35594__$1 = state_35594;
var statearr_35636_35726 = state_35594__$1;
(statearr_35636_35726[(2)] = null);

(statearr_35636_35726[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (34))){
var inst_35535 = (state_35594[(21)]);
var state_35594__$1 = state_35594;
var statearr_35637_35727 = state_35594__$1;
(statearr_35637_35727[(2)] = inst_35535);

(statearr_35637_35727[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (17))){
var inst_35495 = (state_35594[(2)]);
var state_35594__$1 = state_35594;
var statearr_35638_35728 = state_35594__$1;
(statearr_35638_35728[(2)] = inst_35495);

(statearr_35638_35728[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (3))){
var inst_35592 = (state_35594[(2)]);
var state_35594__$1 = state_35594;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35594__$1,inst_35592);
} else {
if((state_val_35595 === (12))){
var inst_35477 = (state_35594[(22)]);
var inst_35479 = cljs.core.first(select);
var inst_35480 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_35479);
var inst_35481 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35480);
var inst_35482 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_35481,(1));
var inst_35483 = [inst_35482];
var inst_35484 = [inst_35477];
var inst_35485 = cljs.core.PersistentHashMap.fromArrays(inst_35483,inst_35484);
var state_35594__$1 = state_35594;
var statearr_35639_35729 = state_35594__$1;
(statearr_35639_35729[(2)] = inst_35485);

(statearr_35639_35729[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (2))){
var inst_35467 = (state_35594[(7)]);
var _ = (function (){var statearr_35640 = state_35594;
(statearr_35640[(4)] = cljs.core.cons((5),(state_35594[(4)])));

return statearr_35640;
})();
var inst_35467__$1 = aggregates;
var state_35594__$1 = (function (){var statearr_35641 = state_35594;
(statearr_35641[(7)] = inst_35467__$1);

return statearr_35641;
})();
if(cljs.core.truth_(inst_35467__$1)){
var statearr_35642_35730 = state_35594__$1;
(statearr_35642_35730[(1)] = (6));

} else {
var statearr_35643_35731 = state_35594__$1;
(statearr_35643_35731[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (23))){
var inst_35511 = (state_35594[(2)]);
var state_35594__$1 = state_35594;
if(cljs.core.truth_(inst_35511)){
var statearr_35644_35732 = state_35594__$1;
(statearr_35644_35732[(1)] = (24));

} else {
var statearr_35645_35733 = state_35594__$1;
(statearr_35645_35733[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (47))){
var inst_35566 = (state_35594[(2)]);
var inst_35567 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_35566);
var state_35594__$1 = (function (){var statearr_35646 = state_35594;
(statearr_35646[(25)] = inst_35567);

return statearr_35646;
})();
if(cljs.core.truth_(orderBy)){
var statearr_35647_35734 = state_35594__$1;
(statearr_35647_35734[(1)] = (48));

} else {
var statearr_35648_35735 = state_35594__$1;
(statearr_35648_35735[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (35))){
var inst_35541 = (state_35594[(2)]);
var state_35594__$1 = (function (){var statearr_35649 = state_35594;
(statearr_35649[(23)] = inst_35541);

return statearr_35649;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_35650_35736 = state_35594__$1;
(statearr_35650_35736[(1)] = (36));

} else {
var statearr_35651_35737 = state_35594__$1;
(statearr_35651_35737[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (19))){
var state_35594__$1 = state_35594;
var statearr_35652_35738 = state_35594__$1;
(statearr_35652_35738[(2)] = res);

(statearr_35652_35738[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (57))){
var inst_35583 = (state_35594[(2)]);
var inst_35584 = fluree.db.util.async.throw_err(inst_35583);
var state_35594__$1 = state_35594;
var statearr_35653_35739 = state_35594__$1;
(statearr_35653_35739[(2)] = inst_35584);

(statearr_35653_35739[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (11))){
var inst_35589 = (state_35594[(2)]);
var _ = (function (){var statearr_35655 = state_35594;
(statearr_35655[(4)] = cljs.core.rest((state_35594[(4)])));

return statearr_35655;
})();
var state_35594__$1 = state_35594;
var statearr_35656_35740 = state_35594__$1;
(statearr_35656_35740[(2)] = inst_35589);

(statearr_35656_35740[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (9))){
var inst_35475 = cljs.core.first(aggregates);
var inst_35476 = fluree.db.query.analytical.calculate_aggregate(res,inst_35475);
var inst_35477 = cljs.core.second(inst_35476);
var state_35594__$1 = (function (){var statearr_35657 = state_35594;
(statearr_35657[(22)] = inst_35477);

return statearr_35657;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_35658_35741 = state_35594__$1;
(statearr_35658_35741[(1)] = (12));

} else {
var statearr_35659_35742 = state_35594__$1;
(statearr_35659_35742[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (5))){
var _ = (function (){var statearr_35660 = state_35594;
(statearr_35660[(4)] = cljs.core.rest((state_35594[(4)])));

return statearr_35660;
})();
var state_35594__$1 = state_35594;
var ex35654 = (state_35594__$1[(2)]);
var statearr_35661_35743 = state_35594__$1;
(statearr_35661_35743[(5)] = ex35654);


if((ex35654 instanceof Error)){
var statearr_35662_35744 = state_35594__$1;
(statearr_35662_35744[(1)] = (4));

(statearr_35662_35744[(5)] = null);

} else {
throw ex35654;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (14))){
var inst_35488 = (state_35594[(2)]);
var state_35594__$1 = (function (){var statearr_35663 = state_35594;
(statearr_35663[(18)] = inst_35488);

return statearr_35663;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_35664_35745 = state_35594__$1;
(statearr_35664_35745[(1)] = (15));

} else {
var statearr_35665_35746 = state_35594__$1;
(statearr_35665_35746[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (45))){
var inst_35503 = (state_35594[(8)]);
var inst_35559 = (state_35594[(15)]);
var inst_35515 = (state_35594[(13)]);
var inst_35504 = (state_35594[(10)]);
var inst_35518 = (state_35594[(16)]);
var inst_35523 = (state_35594[(17)]);
var inst_35505 = (state_35594[(11)]);
var inst_35561 = (function (){var map__35497 = inst_35503;
var headers = inst_35504;
var tuples = inst_35505;
var offset_SINGLEQUOTE_ = inst_35515;
var single_result_QMARK_ = inst_35518;
var pp_keys = inst_35523;
var G__35524 = inst_35559;
return (function (p1__35454_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__35454_SHARP_);
});
})();
var inst_35562 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_35561);
var inst_35563 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35559,inst_35562);
var state_35594__$1 = state_35594;
var statearr_35666_35747 = state_35594__$1;
(statearr_35666_35747[(2)] = inst_35563);

(statearr_35666_35747[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (53))){
var inst_35579 = (state_35594[(2)]);
var state_35594__$1 = (function (){var statearr_35667 = state_35594;
(statearr_35667[(12)] = inst_35579);

return statearr_35667;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_35668_35748 = state_35594__$1;
(statearr_35668_35748[(1)] = (54));

} else {
var statearr_35669_35749 = state_35594__$1;
(statearr_35669_35749[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (26))){
var inst_35515 = (state_35594[(2)]);
var inst_35516 = cljs.core.not(prettyPrint);
var inst_35517 = cljs.core.not(inVector_QMARK_);
var inst_35518 = ((inst_35516) && (inst_35517));
var state_35594__$1 = (function (){var statearr_35670 = state_35594;
(statearr_35670[(13)] = inst_35515);

(statearr_35670[(16)] = inst_35518);

return statearr_35670;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_35671_35750 = state_35594__$1;
(statearr_35671_35750[(1)] = (27));

} else {
var statearr_35672_35751 = state_35594__$1;
(statearr_35672_35751[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (16))){
var inst_35488 = (state_35594[(18)]);
var state_35594__$1 = state_35594;
var statearr_35673_35752 = state_35594__$1;
(statearr_35673_35752[(2)] = inst_35488);

(statearr_35673_35752[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (38))){
var inst_35515 = (state_35594[(13)]);
var inst_35547 = (state_35594[(2)]);
var state_35594__$1 = (function (){var statearr_35674 = state_35594;
(statearr_35674[(14)] = inst_35547);

return statearr_35674;
})();
if(cljs.core.truth_(inst_35515)){
var statearr_35675_35753 = state_35594__$1;
(statearr_35675_35753[(1)] = (39));

} else {
var statearr_35676_35754 = state_35594__$1;
(statearr_35676_35754[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (30))){
var inst_35529 = (state_35594[(20)]);
var inst_35531 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_35532 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35529,inst_35531);
var state_35594__$1 = state_35594;
var statearr_35677_35755 = state_35594__$1;
(statearr_35677_35755[(2)] = inst_35532);

(statearr_35677_35755[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (10))){
var state_35594__$1 = state_35594;
if(cljs.core.truth_(aggregates)){
var statearr_35678_35756 = state_35594__$1;
(statearr_35678_35756[(1)] = (18));

} else {
var statearr_35679_35757 = state_35594__$1;
(statearr_35679_35757[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (18))){
var inst_35499 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_35594__$1 = state_35594;
var statearr_35680_35758 = state_35594__$1;
(statearr_35680_35758[(2)] = inst_35499);

(statearr_35680_35758[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (52))){
var inst_35573 = (state_35594[(19)]);
var state_35594__$1 = state_35594;
var statearr_35681_35759 = state_35594__$1;
(statearr_35681_35759[(2)] = inst_35573);

(statearr_35681_35759[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (42))){
var inst_35553 = (state_35594[(24)]);
var inst_35555 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_35556 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35553,inst_35555);
var state_35594__$1 = state_35594;
var statearr_35682_35760 = state_35594__$1;
(statearr_35682_35760[(2)] = inst_35556);

(statearr_35682_35760[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (37))){
var inst_35541 = (state_35594[(23)]);
var state_35594__$1 = state_35594;
var statearr_35683_35761 = state_35594__$1;
(statearr_35683_35761[(2)] = inst_35541);

(statearr_35683_35761[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (8))){
var inst_35473 = (state_35594[(2)]);
var state_35594__$1 = state_35594;
if(cljs.core.truth_(inst_35473)){
var statearr_35684_35762 = state_35594__$1;
(statearr_35684_35762[(1)] = (9));

} else {
var statearr_35685_35763 = state_35594__$1;
(statearr_35685_35763[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35595 === (49))){
var inst_35505 = (state_35594[(11)]);
var state_35594__$1 = state_35594;
var statearr_35686_35764 = state_35594__$1;
(statearr_35686_35764[(2)] = inst_35505);

(statearr_35686_35764[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__13883__auto__ = null;
var fluree$db$query$fql$state_machine__13883__auto____0 = (function (){
var statearr_35687 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35687[(0)] = fluree$db$query$fql$state_machine__13883__auto__);

(statearr_35687[(1)] = (1));

return statearr_35687;
});
var fluree$db$query$fql$state_machine__13883__auto____1 = (function (state_35594){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_35594);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e35688){var ex__13886__auto__ = e35688;
var statearr_35689_35765 = state_35594;
(statearr_35689_35765[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_35594[(4)]))){
var statearr_35690_35766 = state_35594;
(statearr_35690_35766[(1)] = cljs.core.first((state_35594[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__35767 = state_35594;
state_35594 = G__35767;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__13883__auto__ = function(state_35594){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__13883__auto____1.call(this,state_35594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__13883__auto____0;
fluree$db$query$fql$state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__13883__auto____1;
return fluree$db$query$fql$state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_35691 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_35691[(6)] = c__13957__auto__);

return statearr_35691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__35770,groupBy){
var map__35771 = p__35770;
var map__35771__$1 = cljs.core.__destructure_map(map__35771);
var res = map__35771__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35771__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35771__$1,cljs.core.cst$kw$tuples);
var vec__35772 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35772,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35772,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35768_SHARP_){
return fluree.db.util.core.index_of(headers,p1__35768_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35769_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__35769_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__35775 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35775,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35775,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__35778,p__35779,opts){
var map__35780 = p__35778;
var map__35780__$1 = cljs.core.__destructure_map(map__35780);
var res = map__35780__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35780__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35780__$1,cljs.core.cst$kw$vars);
var map__35781 = p__35779;
var map__35781__$1 = cljs.core.__destructure_map(map__35781);
var select_spec = map__35781__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35781__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35781__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35781__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35781__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35781__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35781__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35781__$1,cljs.core.cst$kw$offset);
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_35996){
var state_val_35997 = (state_35996[(1)]);
if((state_val_35997 === (65))){
var inst_35912 = (state_35996[(7)]);
var inst_35851 = (state_35996[(8)]);
var inst_35860 = (state_35996[(9)]);
var inst_35942 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35851,inst_35860,inst_35912);
var state_35996__$1 = state_35996;
var statearr_35998_36127 = state_35996__$1;
(statearr_35998_36127[(2)] = inst_35942);

(statearr_35998_36127[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (70))){
var inst_35967 = (state_35996[(10)]);
var inst_35966 = (state_35996[(2)]);
var inst_35967__$1 = fluree.db.util.async.throw_err(inst_35966);
var inst_35968 = cljs.core.coll_QMARK_(inst_35967__$1);
var inst_35969 = (!(inst_35968));
var state_35996__$1 = (function (){var statearr_35999 = state_35996;
(statearr_35999[(10)] = inst_35967__$1);

return statearr_35999;
})();
if(inst_35969){
var statearr_36000_36128 = state_35996__$1;
(statearr_36000_36128[(1)] = (71));

} else {
var statearr_36001_36129 = state_35996__$1;
(statearr_36001_36129[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (62))){
var state_35996__$1 = state_35996;
var statearr_36002_36130 = state_35996__$1;
(statearr_36002_36130[(2)] = null);

(statearr_36002_36130[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (74))){
var inst_35967 = (state_35996[(10)]);
var inst_35972 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35973 = [inst_35967];
var inst_35974 = (new cljs.core.PersistentVector(null,1,(5),inst_35972,inst_35973,null));
var state_35996__$1 = state_35996;
var statearr_36003_36131 = state_35996__$1;
(statearr_36003_36131[(2)] = inst_35974);

(statearr_36003_36131[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (7))){
var state_35996__$1 = state_35996;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_36004_36132 = state_35996__$1;
(statearr_36004_36132[(1)] = (67));

} else {
var statearr_36005_36133 = state_35996__$1;
(statearr_36005_36133[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (59))){
var state_35996__$1 = state_35996;
var statearr_36006_36134 = state_35996__$1;
(statearr_36006_36134[(1)] = (61));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (20))){
var state_35996__$1 = state_35996;
var statearr_36008_36135 = state_35996__$1;
(statearr_36008_36135[(2)] = (0));

(statearr_36008_36135[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (72))){
var state_35996__$1 = state_35996;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_36009_36136 = state_35996__$1;
(statearr_36009_36136[(1)] = (77));

} else {
var statearr_36010_36137 = state_35996__$1;
(statearr_36010_36137[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (58))){
var inst_35850 = (state_35996[(11)]);
var inst_35924 = (inst_35850 - (1));
var state_35996__$1 = state_35996;
var statearr_36011_36138 = state_35996__$1;
(statearr_36011_36138[(2)] = inst_35924);

(statearr_36011_36138[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (60))){
var inst_35934 = (state_35996[(2)]);
var state_35996__$1 = state_35996;
var statearr_36012_36139 = state_35996__$1;
(statearr_36012_36139[(2)] = inst_35934);

(statearr_36012_36139[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (27))){
var inst_35849 = (state_35996[(12)]);
var inst_35873 = (inst_35849 < (1));
var state_35996__$1 = state_35996;
var statearr_36013_36140 = state_35996__$1;
(statearr_36013_36140[(2)] = inst_35873);

(statearr_36013_36140[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (1))){
var state_35996__$1 = state_35996;
var statearr_36014_36141 = state_35996__$1;
(statearr_36014_36141[(2)] = null);

(statearr_36014_36141[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (69))){
var inst_35963 = (state_35996[(2)]);
var inst_35964 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_35963,opts);
var state_35996__$1 = state_35996;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35996__$1,(70),inst_35964);
} else {
if((state_val_35997 === (24))){
var inst_35851 = (state_35996[(8)]);
var state_35996__$1 = state_35996;
var statearr_36015_36142 = state_35996__$1;
(statearr_36015_36142[(2)] = inst_35851);

(statearr_36015_36142[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (55))){
var state_35996__$1 = state_35996;
var statearr_36016_36143 = state_35996__$1;
(statearr_36016_36143[(2)] = (0));

(statearr_36016_36143[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (39))){
var inst_35868 = (state_35996[(13)]);
var inst_35891 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,cljs.core.cst$kw$orderBy,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$limit,null], 0));
var inst_35892 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$offset,(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$limit,null], 0));
var inst_35893 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_35868,inst_35891,inst_35892);
var state_35996__$1 = state_35996;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35996__$1,(42),inst_35893);
} else {
if((state_val_35997 === (46))){
var inst_35849 = (state_35996[(12)]);
var inst_35904 = ((0) < inst_35849);
var state_35996__$1 = state_35996;
var statearr_36017_36144 = state_35996__$1;
(statearr_36017_36144[(2)] = inst_35904);

(statearr_36017_36144[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (4))){
var inst_35782 = (state_35996[(2)]);
var state_35996__$1 = state_35996;
var statearr_36018_36145 = state_35996__$1;
(statearr_36018_36145[(2)] = inst_35782);

(statearr_36018_36145[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (77))){
var inst_35967 = (state_35996[(10)]);
var inst_35980 = cljs.core.first(inst_35967);
var state_35996__$1 = state_35996;
var statearr_36019_36146 = state_35996__$1;
(statearr_36019_36146[(2)] = inst_35980);

(statearr_36019_36146[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (54))){
var inst_35850 = (state_35996[(11)]);
var inst_35919 = (state_35996[(2)]);
var inst_35920 = (inst_35850 <= (0));
var state_35996__$1 = (function (){var statearr_36020 = state_35996;
(statearr_36020[(14)] = inst_35919);

return statearr_36020;
})();
if(cljs.core.truth_(inst_35920)){
var statearr_36021_36147 = state_35996__$1;
(statearr_36021_36147[(1)] = (55));

} else {
var statearr_36022_36148 = state_35996__$1;
(statearr_36022_36148[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (15))){
var inst_35800 = (state_35996[(15)]);
var inst_35808 = (state_35996[(2)]);
var inst_35809 = fluree.db.util.async.throw_err(inst_35808);
var inst_35810 = [inst_35800];
var inst_35811 = [inst_35809];
var inst_35812 = cljs.core.PersistentHashMap.fromArrays(inst_35810,inst_35811);
var state_35996__$1 = state_35996;
var statearr_36023_36149 = state_35996__$1;
(statearr_36023_36149[(2)] = inst_35812);

(statearr_36023_36149[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (48))){
var inst_35907 = (state_35996[(2)]);
var state_35996__$1 = state_35996;
if(cljs.core.truth_(inst_35907)){
var statearr_36024_36150 = state_35996__$1;
(statearr_36024_36150[(1)] = (49));

} else {
var statearr_36025_36151 = state_35996__$1;
(statearr_36025_36151[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (50))){
var inst_35902 = (state_35996[(16)]);
var state_35996__$1 = state_35996;
var statearr_36026_36152 = state_35996__$1;
(statearr_36026_36152[(2)] = inst_35902);

(statearr_36026_36152[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (75))){
var inst_35967 = (state_35996[(10)]);
var state_35996__$1 = state_35996;
var statearr_36027_36153 = state_35996__$1;
(statearr_36027_36153[(2)] = inst_35967);

(statearr_36027_36153[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (21))){
var inst_35828 = (state_35996[(17)]);
var inst_35832 = (state_35996[(18)]);
var inst_35840 = (state_35996[(19)]);
var inst_35845 = (state_35996[(2)]);
var inst_35846 = cljs.core.PersistentHashMap.EMPTY;
var inst_35847 = inst_35828;
var inst_35848 = inst_35832;
var inst_35849 = inst_35840;
var inst_35850 = inst_35845;
var inst_35851 = inst_35846;
var state_35996__$1 = (function (){var statearr_36028 = state_35996;
(statearr_36028[(20)] = inst_35847);

(statearr_36028[(8)] = inst_35851);

(statearr_36028[(12)] = inst_35849);

(statearr_36028[(21)] = inst_35848);

(statearr_36028[(11)] = inst_35850);

return statearr_36028;
})();
var statearr_36029_36154 = state_35996__$1;
(statearr_36029_36154[(2)] = null);

(statearr_36029_36154[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (31))){
var inst_35865 = (state_35996[(22)]);
var inst_35850 = (state_35996[(11)]);
var inst_35879 = (inst_35850 >= inst_35865);
var state_35996__$1 = state_35996;
if(cljs.core.truth_(inst_35879)){
var statearr_36030_36155 = state_35996__$1;
(statearr_36030_36155[(1)] = (33));

} else {
var statearr_36031_36156 = state_35996__$1;
(statearr_36031_36156[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (32))){
var inst_35952 = (state_35996[(2)]);
var state_35996__$1 = state_35996;
var statearr_36032_36157 = state_35996__$1;
(statearr_36032_36157[(2)] = inst_35952);

(statearr_36032_36157[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (40))){
var state_35996__$1 = state_35996;
var statearr_36033_36158 = state_35996__$1;
(statearr_36033_36158[(2)] = null);

(statearr_36033_36158[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (56))){
var state_35996__$1 = state_35996;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_36034_36159 = state_35996__$1;
(statearr_36034_36159[(1)] = (58));

} else {
var statearr_36035_36160 = state_35996__$1;
(statearr_36035_36160[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (33))){
var state_35996__$1 = state_35996;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_36036_36161 = state_35996__$1;
(statearr_36036_36161[(1)] = (36));

} else {
var statearr_36037_36162 = state_35996__$1;
(statearr_36037_36162[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (13))){
var inst_35797 = (state_35996[(23)]);
var inst_35828 = (state_35996[(17)]);
var inst_35832 = (state_35996[(18)]);
var inst_35828__$1 = cljs.core.keys(inst_35797);
var inst_35829 = cljs.core.seq(inst_35828__$1);
var inst_35830 = cljs.core.first(inst_35829);
var inst_35831 = cljs.core.next(inst_35829);
var inst_35832__$1 = cljs.core.vals(inst_35797);
var inst_35833 = cljs.core.seq(inst_35832__$1);
var inst_35834 = cljs.core.first(inst_35833);
var inst_35835 = cljs.core.next(inst_35833);
var inst_35836 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_35996__$1 = (function (){var statearr_36038 = state_35996;
(statearr_36038[(24)] = inst_35831);

(statearr_36038[(25)] = inst_35835);

(statearr_36038[(26)] = inst_35834);

(statearr_36038[(17)] = inst_35828__$1);

(statearr_36038[(27)] = inst_35830);

(statearr_36038[(18)] = inst_35832__$1);

return statearr_36038;
})();
if(inst_35836){
var statearr_36039_36163 = state_35996__$1;
(statearr_36039_36163[(1)] = (16));

} else {
var statearr_36040_36164 = state_35996__$1;
(statearr_36040_36164[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (22))){
var inst_35847 = (state_35996[(20)]);
var inst_35848 = (state_35996[(21)]);
var inst_35859 = cljs.core.seq(inst_35847);
var inst_35860 = cljs.core.first(inst_35859);
var inst_35861 = cljs.core.next(inst_35859);
var inst_35862 = cljs.core.seq(inst_35848);
var inst_35863 = cljs.core.first(inst_35862);
var inst_35864 = cljs.core.next(inst_35862);
var inst_35865 = cljs.core.count(inst_35863);
var inst_35866 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_35867 = [headers,vars,inst_35863];
var inst_35868 = cljs.core.PersistentHashMap.fromArrays(inst_35866,inst_35867);
var inst_35869 = (inst_35863 == null);
var state_35996__$1 = (function (){var statearr_36041 = state_35996;
(statearr_36041[(28)] = inst_35861);

(statearr_36041[(22)] = inst_35865);

(statearr_36041[(9)] = inst_35860);

(statearr_36041[(13)] = inst_35868);

(statearr_36041[(29)] = inst_35864);

return statearr_36041;
})();
if(cljs.core.truth_(inst_35869)){
var statearr_36042_36165 = state_35996__$1;
(statearr_36042_36165[(1)] = (24));

} else {
var statearr_36043_36166 = state_35996__$1;
(statearr_36043_36166[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (36))){
var inst_35850 = (state_35996[(11)]);
var inst_35882 = (inst_35850 - (1));
var state_35996__$1 = state_35996;
var statearr_36044_36167 = state_35996__$1;
(statearr_36044_36167[(2)] = inst_35882);

(statearr_36044_36167[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (41))){
var inst_35948 = (state_35996[(2)]);
var state_35996__$1 = state_35996;
var statearr_36045_36168 = state_35996__$1;
(statearr_36045_36168[(2)] = inst_35948);

(statearr_36045_36168[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (43))){
var inst_35896 = (state_35996[(30)]);
var inst_35850 = (state_35996[(11)]);
var inst_35899 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_35850,inst_35896);
var state_35996__$1 = state_35996;
var statearr_36046_36169 = state_35996__$1;
(statearr_36046_36169[(2)] = inst_35899);

(statearr_36046_36169[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (61))){
var inst_35912 = (state_35996[(7)]);
var inst_35865 = (state_35996[(22)]);
var inst_35850 = (state_35996[(11)]);
var inst_35927 = cljs.core.count(inst_35912);
var inst_35928 = (inst_35865 - inst_35927);
var inst_35929 = (inst_35850 - inst_35928);
var state_35996__$1 = state_35996;
var statearr_36047_36170 = state_35996__$1;
(statearr_36047_36170[(2)] = inst_35929);

(statearr_36047_36170[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (29))){
var inst_35876 = (state_35996[(2)]);
var state_35996__$1 = state_35996;
if(cljs.core.truth_(inst_35876)){
var statearr_36048_36171 = state_35996__$1;
(statearr_36048_36171[(1)] = (30));

} else {
var statearr_36049_36172 = state_35996__$1;
(statearr_36049_36172[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (44))){
var inst_35896 = (state_35996[(30)]);
var state_35996__$1 = state_35996;
var statearr_36050_36173 = state_35996__$1;
(statearr_36050_36173[(2)] = inst_35896);

(statearr_36050_36173[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (6))){
var inst_35789 = (state_35996[(31)]);
var inst_35789__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_35791 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_35996__$1 = (function (){var statearr_36051 = state_35996;
(statearr_36051[(32)] = inst_35791);

(statearr_36051[(31)] = inst_35789__$1);

return statearr_36051;
})();
if(cljs.core.truth_(inst_35789__$1)){
var statearr_36052_36174 = state_35996__$1;
(statearr_36052_36174[(1)] = (9));

} else {
var statearr_36053_36175 = state_35996__$1;
(statearr_36053_36175[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (28))){
var inst_35849 = (state_35996[(12)]);
var state_35996__$1 = state_35996;
var statearr_36054_36176 = state_35996__$1;
(statearr_36054_36176[(2)] = inst_35849);

(statearr_36054_36176[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (64))){
var inst_35851 = (state_35996[(8)]);
var state_35996__$1 = state_35996;
var statearr_36055_36177 = state_35996__$1;
(statearr_36055_36177[(2)] = inst_35851);

(statearr_36055_36177[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (51))){
var inst_35849 = (state_35996[(12)]);
var inst_35912 = (state_35996[(2)]);
var inst_35913 = (inst_35849 == null);
var state_35996__$1 = (function (){var statearr_36056 = state_35996;
(statearr_36056[(7)] = inst_35912);

return statearr_36056;
})();
if(cljs.core.truth_(inst_35913)){
var statearr_36057_36178 = state_35996__$1;
(statearr_36057_36178[(1)] = (52));

} else {
var statearr_36058_36179 = state_35996__$1;
(statearr_36058_36179[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (25))){
var inst_35849 = (state_35996[(12)]);
var state_35996__$1 = state_35996;
if(cljs.core.truth_(inst_35849)){
var statearr_36059_36180 = state_35996__$1;
(statearr_36059_36180[(1)] = (27));

} else {
var statearr_36060_36181 = state_35996__$1;
(statearr_36060_36181[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (34))){
var state_35996__$1 = state_35996;
var statearr_36061_36182 = state_35996__$1;
(statearr_36061_36182[(1)] = (39));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (17))){
var state_35996__$1 = state_35996;
var statearr_36063_36183 = state_35996__$1;
(statearr_36063_36183[(2)] = limit);

(statearr_36063_36183[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (3))){
var inst_35994 = (state_35996[(2)]);
var state_35996__$1 = state_35996;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35996__$1,inst_35994);
} else {
if((state_val_35997 === (12))){
var inst_35797 = (state_35996[(23)]);
var inst_35799 = cljs.core.keys(inst_35797);
var inst_35800 = cljs.core.first(inst_35799);
var inst_35801 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_35802 = cljs.core.vals(inst_35797);
var inst_35803 = cljs.core.first(inst_35802);
var inst_35804 = [headers,vars,inst_35803];
var inst_35805 = cljs.core.PersistentHashMap.fromArrays(inst_35801,inst_35804);
var inst_35806 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_35805,select_spec,limit,opts);
var state_35996__$1 = (function (){var statearr_36064 = state_35996;
(statearr_36064[(15)] = inst_35800);

return statearr_36064;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35996__$1,(15),inst_35806);
} else {
if((state_val_35997 === (2))){
var _ = (function (){var statearr_36065 = state_35996;
(statearr_36065[(4)] = cljs.core.cons((5),(state_35996[(4)])));

return statearr_36065;
})();
var state_35996__$1 = state_35996;
if(cljs.core.truth_(groupBy)){
var statearr_36066_36184 = state_35996__$1;
(statearr_36066_36184[(1)] = (6));

} else {
var statearr_36067_36185 = state_35996__$1;
(statearr_36067_36185[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (66))){
var inst_35861 = (state_35996[(28)]);
var inst_35936 = (state_35996[(33)]);
var inst_35919 = (state_35996[(14)]);
var inst_35864 = (state_35996[(29)]);
var inst_35944 = (state_35996[(2)]);
var inst_35847 = inst_35861;
var inst_35848 = inst_35864;
var inst_35849 = inst_35919;
var inst_35850 = inst_35936;
var inst_35851 = inst_35944;
var state_35996__$1 = (function (){var statearr_36068 = state_35996;
(statearr_36068[(20)] = inst_35847);

(statearr_36068[(8)] = inst_35851);

(statearr_36068[(12)] = inst_35849);

(statearr_36068[(21)] = inst_35848);

(statearr_36068[(11)] = inst_35850);

return statearr_36068;
})();
var statearr_36069_36186 = state_35996__$1;
(statearr_36069_36186[(2)] = null);

(statearr_36069_36186[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (23))){
var inst_35956 = (state_35996[(2)]);
var state_35996__$1 = state_35996;
var statearr_36070_36187 = state_35996__$1;
(statearr_36070_36187[(2)] = inst_35956);

(statearr_36070_36187[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (47))){
var inst_35849 = (state_35996[(12)]);
var state_35996__$1 = state_35996;
var statearr_36071_36188 = state_35996__$1;
(statearr_36071_36188[(2)] = inst_35849);

(statearr_36071_36188[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (35))){
var inst_35950 = (state_35996[(2)]);
var state_35996__$1 = state_35996;
var statearr_36072_36189 = state_35996__$1;
(statearr_36072_36189[(2)] = inst_35950);

(statearr_36072_36189[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (82))){
var inst_35985 = (state_35996[(2)]);
var state_35996__$1 = state_35996;
var statearr_36073_36190 = state_35996__$1;
(statearr_36073_36190[(2)] = inst_35985);

(statearr_36073_36190[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (76))){
var inst_35977 = (state_35996[(2)]);
var state_35996__$1 = state_35996;
var statearr_36074_36191 = state_35996__$1;
(statearr_36074_36191[(2)] = inst_35977);

(statearr_36074_36191[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (19))){
var inst_35841 = (state_35996[(34)]);
var state_35996__$1 = state_35996;
var statearr_36075_36192 = state_35996__$1;
(statearr_36075_36192[(2)] = inst_35841);

(statearr_36075_36192[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (57))){
var inst_35912 = (state_35996[(7)]);
var inst_35936 = (state_35996[(2)]);
var inst_35937 = (inst_35912 == null);
var inst_35938 = cljs.core.empty_QMARK_(inst_35912);
var inst_35939 = ((inst_35937) || (inst_35938));
var state_35996__$1 = (function (){var statearr_36076 = state_35996;
(statearr_36076[(33)] = inst_35936);

return statearr_36076;
})();
if(cljs.core.truth_(inst_35939)){
var statearr_36077_36193 = state_35996__$1;
(statearr_36077_36193[(1)] = (64));

} else {
var statearr_36078_36194 = state_35996__$1;
(statearr_36078_36194[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (68))){
var state_35996__$1 = state_35996;
var statearr_36079_36195 = state_35996__$1;
(statearr_36079_36195[(2)] = limit);

(statearr_36079_36195[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (11))){
var inst_35797 = (state_35996[(2)]);
var state_35996__$1 = (function (){var statearr_36081 = state_35996;
(statearr_36081[(23)] = inst_35797);

return statearr_36081;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_36082_36196 = state_35996__$1;
(statearr_36082_36196[(1)] = (12));

} else {
var statearr_36083_36197 = state_35996__$1;
(statearr_36083_36197[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (9))){
var inst_35791 = (state_35996[(32)]);
var inst_35789 = (state_35996[(31)]);
var inst_35793 = cljs.core.sorted_map_by(inst_35789);
var inst_35794 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35793,inst_35791);
var state_35996__$1 = state_35996;
var statearr_36084_36198 = state_35996__$1;
(statearr_36084_36198[(2)] = inst_35794);

(statearr_36084_36198[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (5))){
var _ = (function (){var statearr_36085 = state_35996;
(statearr_36085[(4)] = cljs.core.rest((state_35996[(4)])));

return statearr_36085;
})();
var state_35996__$1 = state_35996;
var ex36080 = (state_35996__$1[(2)]);
var statearr_36086_36199 = state_35996__$1;
(statearr_36086_36199[(5)] = ex36080);


if((ex36080 instanceof Error)){
var statearr_36087_36200 = state_35996__$1;
(statearr_36087_36200[(1)] = (4));

(statearr_36087_36200[(5)] = null);

} else {
throw ex36080;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (14))){
var inst_35958 = (state_35996[(2)]);
var state_35996__$1 = state_35996;
var statearr_36088_36201 = state_35996__$1;
(statearr_36088_36201[(2)] = inst_35958);

(statearr_36088_36201[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (45))){
var inst_35849 = (state_35996[(12)]);
var inst_35902 = (state_35996[(2)]);
var state_35996__$1 = (function (){var statearr_36089 = state_35996;
(statearr_36089[(16)] = inst_35902);

return statearr_36089;
})();
if(cljs.core.truth_(inst_35849)){
var statearr_36090_36202 = state_35996__$1;
(statearr_36090_36202[(1)] = (46));

} else {
var statearr_36091_36203 = state_35996__$1;
(statearr_36091_36203[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (53))){
var inst_35912 = (state_35996[(7)]);
var inst_35849 = (state_35996[(12)]);
var inst_35916 = cljs.core.count(inst_35912);
var inst_35917 = (inst_35849 - inst_35916);
var state_35996__$1 = state_35996;
var statearr_36092_36204 = state_35996__$1;
(statearr_36092_36204[(2)] = inst_35917);

(statearr_36092_36204[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (78))){
var state_35996__$1 = state_35996;
var statearr_36093_36205 = state_35996__$1;
(statearr_36093_36205[(1)] = (80));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (26))){
var inst_35954 = (state_35996[(2)]);
var state_35996__$1 = state_35996;
var statearr_36095_36206 = state_35996__$1;
(statearr_36095_36206[(2)] = inst_35954);

(statearr_36095_36206[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (16))){
var state_35996__$1 = state_35996;
var statearr_36096_36207 = state_35996__$1;
(statearr_36096_36207[(2)] = null);

(statearr_36096_36207[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (81))){
var state_35996__$1 = state_35996;
var statearr_36099_36208 = state_35996__$1;
(statearr_36099_36208[(2)] = null);

(statearr_36099_36208[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (79))){
var inst_35987 = (state_35996[(2)]);
var state_35996__$1 = state_35996;
var statearr_36100_36209 = state_35996__$1;
(statearr_36100_36209[(2)] = inst_35987);

(statearr_36100_36209[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (38))){
var inst_35861 = (state_35996[(28)]);
var inst_35851 = (state_35996[(8)]);
var inst_35864 = (state_35996[(29)]);
var inst_35849 = (state_35996[(12)]);
var inst_35886 = (state_35996[(2)]);
var tmp36097 = inst_35851;
var tmp36098 = inst_35849;
var inst_35847 = inst_35861;
var inst_35848 = inst_35864;
var inst_35849__$1 = tmp36098;
var inst_35850 = inst_35886;
var inst_35851__$1 = tmp36097;
var state_35996__$1 = (function (){var statearr_36101 = state_35996;
(statearr_36101[(20)] = inst_35847);

(statearr_36101[(8)] = inst_35851__$1);

(statearr_36101[(12)] = inst_35849__$1);

(statearr_36101[(21)] = inst_35848);

(statearr_36101[(11)] = inst_35850);

return statearr_36101;
})();
var statearr_36102_36210 = state_35996__$1;
(statearr_36102_36210[(2)] = null);

(statearr_36102_36210[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (30))){
var inst_35851 = (state_35996[(8)]);
var state_35996__$1 = state_35996;
var statearr_36103_36211 = state_35996__$1;
(statearr_36103_36211[(2)] = inst_35851);

(statearr_36103_36211[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (73))){
var inst_35989 = (state_35996[(2)]);
var state_35996__$1 = state_35996;
var statearr_36104_36212 = state_35996__$1;
(statearr_36104_36212[(2)] = inst_35989);

(statearr_36104_36212[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (10))){
var inst_35791 = (state_35996[(32)]);
var state_35996__$1 = state_35996;
var statearr_36105_36213 = state_35996__$1;
(statearr_36105_36213[(2)] = inst_35791);

(statearr_36105_36213[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (18))){
var inst_35841 = (state_35996[(34)]);
var inst_35840 = (state_35996[(2)]);
var inst_35841__$1 = offset;
var state_35996__$1 = (function (){var statearr_36106 = state_35996;
(statearr_36106[(34)] = inst_35841__$1);

(statearr_36106[(19)] = inst_35840);

return statearr_36106;
})();
if(cljs.core.truth_(inst_35841__$1)){
var statearr_36107_36214 = state_35996__$1;
(statearr_36107_36214[(1)] = (19));

} else {
var statearr_36108_36215 = state_35996__$1;
(statearr_36108_36215[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (52))){
var state_35996__$1 = state_35996;
var statearr_36109_36216 = state_35996__$1;
(statearr_36109_36216[(2)] = null);

(statearr_36109_36216[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (67))){
var state_35996__$1 = state_35996;
var statearr_36110_36217 = state_35996__$1;
(statearr_36110_36217[(2)] = (1));

(statearr_36110_36217[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (71))){
var state_35996__$1 = state_35996;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_36111_36218 = state_35996__$1;
(statearr_36111_36218[(1)] = (74));

} else {
var statearr_36112_36219 = state_35996__$1;
(statearr_36112_36219[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (42))){
var inst_35850 = (state_35996[(11)]);
var inst_35895 = (state_35996[(2)]);
var inst_35896 = fluree.db.util.async.throw_err(inst_35895);
var inst_35897 = ((0) < inst_35850);
var state_35996__$1 = (function (){var statearr_36113 = state_35996;
(statearr_36113[(30)] = inst_35896);

return statearr_36113;
})();
if(cljs.core.truth_(inst_35897)){
var statearr_36114_36220 = state_35996__$1;
(statearr_36114_36220[(1)] = (43));

} else {
var statearr_36115_36221 = state_35996__$1;
(statearr_36115_36221[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (80))){
var inst_35967 = (state_35996[(10)]);
var state_35996__$1 = state_35996;
var statearr_36116_36222 = state_35996__$1;
(statearr_36116_36222[(2)] = inst_35967);

(statearr_36116_36222[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (37))){
var inst_35865 = (state_35996[(22)]);
var inst_35850 = (state_35996[(11)]);
var inst_35884 = (inst_35850 - inst_35865);
var state_35996__$1 = state_35996;
var statearr_36117_36223 = state_35996__$1;
(statearr_36117_36223[(2)] = inst_35884);

(statearr_36117_36223[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (63))){
var inst_35932 = (state_35996[(2)]);
var state_35996__$1 = state_35996;
var statearr_36118_36224 = state_35996__$1;
(statearr_36118_36224[(2)] = inst_35932);

(statearr_36118_36224[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (8))){
var inst_35991 = (state_35996[(2)]);
var _ = (function (){var statearr_36119 = state_35996;
(statearr_36119[(4)] = cljs.core.rest((state_35996[(4)])));

return statearr_36119;
})();
var state_35996__$1 = state_35996;
var statearr_36120_36225 = state_35996__$1;
(statearr_36120_36225[(2)] = inst_35991);

(statearr_36120_36225[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35997 === (49))){
var inst_35849 = (state_35996[(12)]);
var inst_35902 = (state_35996[(16)]);
var inst_35909 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_35849,inst_35902);
var state_35996__$1 = state_35996;
var statearr_36121_36226 = state_35996__$1;
(statearr_36121_36226[(2)] = inst_35909);

(statearr_36121_36226[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto____0 = (function (){
var statearr_36122 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36122[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto__);

(statearr_36122[(1)] = (1));

return statearr_36122;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto____1 = (function (state_35996){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_35996);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e36123){var ex__13886__auto__ = e36123;
var statearr_36124_36227 = state_35996;
(statearr_36124_36227[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_35996[(4)]))){
var statearr_36125_36228 = state_35996;
(statearr_36125_36228[(1)] = cljs.core.first((state_35996[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__36229 = state_35996;
state_35996 = G__36229;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto__ = function(state_35996){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto____1.call(this,state_35996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_36126 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_36126[(6)] = c__13957__auto__);

return statearr_36126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__36232,opts){
var map__36233 = p__36232;
var map__36233__$1 = cljs.core.__destructure_map(map__36233);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36233__$1,cljs.core.cst$kw$selectOne);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36233__$1,cljs.core.cst$kw$select);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36233__$1,cljs.core.cst$kw$selectDistinct);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36233__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__4160__auto__ = selectOne;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
var or__4160__auto____$1 = select;
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
var or__4160__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4160__auto____$2)){
return or__4160__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__36230_SHARP_){
return cljs.core.contains_QMARK_(p1__36230_SHARP_,cljs.core.cst$kw$code);
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__36231_SHARP_){
return cljs.core.contains_QMARK_(p1__36231_SHARP_,cljs.core.cst$kw$selection);
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4160__auto__ = typeof orderBy === 'string';
if(or__4160__auto__){
return or__4160__auto__;
} else {
if(cljs.core.vector_QMARK_(orderBy)){
var G__36241 = cljs.core.first(orderBy);
var fexpr__36240 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__36240.cljs$core$IFn$_invoke$arity$1 ? fexpr__36240.cljs$core$IFn$_invoke$arity$1(G__36241) : fexpr__36240.call(null,G__36241));
} else {
return false;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__4160__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return (100);
}
})(),(function (){var or__4160__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4160__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4160__auto__ = selectDistinct;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__36242,p__36243){
var map__36244 = p__36242;
var map__36244__$1 = cljs.core.__destructure_map(map__36244);
var query_map = map__36244__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36244__$1,cljs.core.cst$kw$construct);
var map__36245 = p__36243;
var map__36245__$1 = cljs.core.__destructure_map(map__36245);
var where_result = map__36245__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36245__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36245__$1,cljs.core.cst$kw$tuples);
var vec__36246 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36246,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36246,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36246,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_36279){
var state_val_36280 = (state_36279[(1)]);
if((state_val_36280 === (7))){
var inst_36258 = (state_36279[(7)]);
var state_36279__$1 = state_36279;
var statearr_36281_36304 = state_36279__$1;
(statearr_36281_36304[(2)] = inst_36258);

(statearr_36281_36304[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36280 === (1))){
var state_36279__$1 = state_36279;
var statearr_36282_36305 = state_36279__$1;
(statearr_36282_36305[(2)] = null);

(statearr_36282_36305[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36280 === (4))){
var inst_36249 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
var statearr_36283_36306 = state_36279__$1;
(statearr_36283_36306[(2)] = inst_36249);

(statearr_36283_36306[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36280 === (13))){
var inst_36268 = (state_36279[(2)]);
var inst_36269 = fluree.db.util.async.throw_err(inst_36268);
var state_36279__$1 = state_36279;
var statearr_36284_36307 = state_36279__$1;
(statearr_36284_36307[(2)] = inst_36269);

(statearr_36284_36307[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36280 === (6))){
var inst_36258 = (state_36279[(7)]);
var inst_36257 = (state_36279[(2)]);
var inst_36258__$1 = fluree.db.util.async.throw_err(inst_36257);
var inst_36259 = fluree.db.util.core.exception_QMARK_(inst_36258__$1);
var state_36279__$1 = (function (){var statearr_36285 = state_36279;
(statearr_36285[(7)] = inst_36258__$1);

return statearr_36285;
})();
if(inst_36259){
var statearr_36286_36308 = state_36279__$1;
(statearr_36286_36308[(1)] = (7));

} else {
var statearr_36287_36309 = state_36279__$1;
(statearr_36287_36309[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36280 === (3))){
var inst_36277 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36279__$1,inst_36277);
} else {
if((state_val_36280 === (12))){
var inst_36272 = (state_36279[(2)]);
var state_36279__$1 = state_36279;
var statearr_36288_36310 = state_36279__$1;
(statearr_36288_36310[(2)] = inst_36272);

(statearr_36288_36310[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36280 === (2))){
var _ = (function (){var statearr_36289 = state_36279;
(statearr_36289[(4)] = cljs.core.cons((5),(state_36279[(4)])));

return statearr_36289;
})();
var inst_36255 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_36279__$1 = state_36279;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36279__$1,(6),inst_36255);
} else {
if((state_val_36280 === (11))){
var state_36279__$1 = state_36279;
var statearr_36291_36311 = state_36279__$1;
(statearr_36291_36311[(2)] = null);

(statearr_36291_36311[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36280 === (9))){
var inst_36274 = (state_36279[(2)]);
var _ = (function (){var statearr_36292 = state_36279;
(statearr_36292[(4)] = cljs.core.rest((state_36279[(4)])));

return statearr_36292;
})();
var state_36279__$1 = state_36279;
var statearr_36293_36312 = state_36279__$1;
(statearr_36293_36312[(2)] = inst_36274);

(statearr_36293_36312[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36280 === (5))){
var _ = (function (){var statearr_36294 = state_36279;
(statearr_36294[(4)] = cljs.core.rest((state_36279[(4)])));

return statearr_36294;
})();
var state_36279__$1 = state_36279;
var ex36290 = (state_36279__$1[(2)]);
var statearr_36295_36313 = state_36279__$1;
(statearr_36295_36313[(5)] = ex36290);


if((ex36290 instanceof Error)){
var statearr_36296_36314 = state_36279__$1;
(statearr_36296_36314[(1)] = (4));

(statearr_36296_36314[(5)] = null);

} else {
throw ex36290;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36280 === (10))){
var inst_36258 = (state_36279[(7)]);
var inst_36263 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_36258);
var inst_36264 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_36258);
var inst_36265 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_36263,inst_36264,query_map,opts);
var inst_36266 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_36258,inst_36265,opts);
var state_36279__$1 = state_36279;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36279__$1,(13),inst_36266);
} else {
if((state_val_36280 === (8))){
var state_36279__$1 = state_36279;
var statearr_36297_36315 = state_36279__$1;
(statearr_36297_36315[(1)] = (10));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto____0 = (function (){
var statearr_36299 = [null,null,null,null,null,null,null,null];
(statearr_36299[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto__);

(statearr_36299[(1)] = (1));

return statearr_36299;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto____1 = (function (state_36279){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_36279);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e36300){var ex__13886__auto__ = e36300;
var statearr_36301_36316 = state_36279;
(statearr_36301_36316[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_36279[(4)]))){
var statearr_36302_36317 = state_36279;
(statearr_36302_36317[(1)] = cljs.core.first((state_36279[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__36318 = state_36279;
state_36279 = G__36318;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto__ = function(state_36279){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto____1.call(this,state_36279);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_36303 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_36303[(6)] = c__13957__auto__);

return statearr_36303;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
var map__36319 = query_map;
var map__36319__$1 = cljs.core.__destructure_map(map__36319);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36319__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36319__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36319__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36319__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36319__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36319__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36319__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36319__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36319__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36319__$1,cljs.core.cst$kw$from);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36319__$1,cljs.core.cst$kw$opts);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36319__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = (function (){var G__36320 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__4160__auto__ = offset;
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__36320,cljs.core.cst$kw$limit,(1));
} else {
return G__36320;
}
})();
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4160__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4160__auto__)){
return or__4160__auto__;
} else {
if(cljs.core.truth_((function (){var or__4160__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4160__auto____$1)){
return or__4160__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__13957__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__13958__auto__ = (function (){var switch__13882__auto__ = (function (state_36671){
var state_val_36672 = (state_36671[(1)]);
if((state_val_36672 === (121))){
var inst_36661 = (state_36671[(2)]);
var state_36671__$1 = state_36671;
if(cljs.core.truth_(inst_36661)){
var statearr_36673_36852 = state_36671__$1;
(statearr_36673_36852[(1)] = (122));

} else {
var statearr_36674_36853 = state_36671__$1;
(statearr_36674_36853[(1)] = (123));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (65))){
var inst_36374 = (state_36671[(7)]);
var inst_36372 = (state_36671[(8)]);
var inst_36497 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_36498 = [inst_36372,inst_36374];
var inst_36499 = cljs.core.PersistentHashMap.fromArrays(inst_36497,inst_36498);
var state_36671__$1 = state_36671;
var statearr_36675_36854 = state_36671__$1;
(statearr_36675_36854[(2)] = inst_36499);

(statearr_36675_36854[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (70))){
var inst_36530 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_36671__$1 = state_36671;
if(inst_36530){
var statearr_36676_36855 = state_36671__$1;
(statearr_36676_36855[(1)] = (77));

} else {
var statearr_36677_36856 = state_36671__$1;
(statearr_36677_36856[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (62))){
var inst_36511 = typeof from === 'string';
var state_36671__$1 = state_36671;
if(cljs.core.truth_(inst_36511)){
var statearr_36678_36857 = state_36671__$1;
(statearr_36678_36857[(1)] = (69));

} else {
var statearr_36679_36858 = state_36671__$1;
(statearr_36679_36858[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (74))){
var inst_36520 = (state_36671[(2)]);
var inst_36521 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_36520);
var state_36671__$1 = state_36671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36671__$1,(75),inst_36521);
} else {
if((state_val_36672 === (110))){
var state_36671__$1 = state_36671;
var statearr_36680_36859 = state_36671__$1;
(statearr_36680_36859[(2)] = null);

(statearr_36680_36859[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (7))){
var inst_36352 = (state_36671[(9)]);
var inst_36352__$1 = selectOne;
var state_36671__$1 = (function (){var statearr_36681 = state_36671;
(statearr_36681[(9)] = inst_36352__$1);

return statearr_36681;
})();
if(cljs.core.truth_(inst_36352__$1)){
var statearr_36682_36860 = state_36671__$1;
(statearr_36682_36860[(1)] = (9));

} else {
var statearr_36683_36861 = state_36671__$1;
(statearr_36683_36861[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (59))){
var state_36671__$1 = state_36671;
var statearr_36684_36862 = state_36671__$1;
(statearr_36684_36862[(2)] = false);

(statearr_36684_36862[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (86))){
var state_36671__$1 = state_36671;
var statearr_36685_36863 = state_36671__$1;
(statearr_36685_36863[(2)] = null);

(statearr_36685_36863[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (20))){
var inst_36416 = (state_36671[(2)]);
var inst_36417 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36416,(0),null);
var inst_36418 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36416,(1),null);
var inst_36419 = typeof where === 'string';
var state_36671__$1 = (function (){var statearr_36686 = state_36671;
(statearr_36686[(10)] = inst_36418);

(statearr_36686[(11)] = inst_36417);

return statearr_36686;
})();
if(cljs.core.truth_(inst_36419)){
var statearr_36687_36864 = state_36671__$1;
(statearr_36687_36864[(1)] = (30));

} else {
var statearr_36688_36865 = state_36671__$1;
(statearr_36688_36865[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (72))){
var inst_36514 = cljs.core.PersistentHashMap.EMPTY;
var state_36671__$1 = state_36671;
var statearr_36689_36866 = state_36671__$1;
(statearr_36689_36866[(2)] = inst_36514);

(statearr_36689_36866[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (58))){
var inst_36486 = ["_tx",null,"_block",null];
var inst_36487 = (new cljs.core.PersistentArrayMap(null,2,inst_36486,null));
var inst_36488 = (new cljs.core.PersistentHashSet(null,inst_36487,null));
var inst_36489 = (inst_36488.cljs$core$IFn$_invoke$arity$1 ? inst_36488.cljs$core$IFn$_invoke$arity$1(from) : inst_36488.call(null,from));
var state_36671__$1 = state_36671;
var statearr_36690_36867 = state_36671__$1;
(statearr_36690_36867[(2)] = inst_36489);

(statearr_36690_36867[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (60))){
var inst_36492 = (state_36671[(2)]);
var state_36671__$1 = state_36671;
if(cljs.core.truth_(inst_36492)){
var statearr_36691_36868 = state_36671__$1;
(statearr_36691_36868[(1)] = (61));

} else {
var statearr_36692_36869 = state_36671__$1;
(statearr_36692_36869[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (27))){
var inst_36401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36402 = [null,null];
var inst_36403 = (new cljs.core.PersistentVector(null,2,(5),inst_36401,inst_36402,null));
var state_36671__$1 = state_36671;
var statearr_36693_36870 = state_36671__$1;
(statearr_36693_36870[(2)] = inst_36403);

(statearr_36693_36870[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (1))){
var state_36671__$1 = state_36671;
var statearr_36694_36871 = state_36671__$1;
(statearr_36694_36871[(2)] = null);

(statearr_36694_36871[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (69))){
var inst_36371 = (state_36671[(12)]);
var state_36671__$1 = state_36671;
if(cljs.core.truth_(inst_36371)){
var statearr_36695_36872 = state_36671__$1;
(statearr_36695_36872[(1)] = (72));

} else {
var statearr_36696_36873 = state_36671__$1;
(statearr_36696_36873[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (101))){
var inst_36580 = (state_36671[(13)]);
var inst_36594 = (state_36671[(2)]);
var inst_36595 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_36580,false);
var state_36671__$1 = (function (){var statearr_36697 = state_36671;
(statearr_36697[(14)] = inst_36594);

return statearr_36697;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36671__$1,(102),inst_36595);
} else {
if((state_val_36672 === (24))){
var inst_36371 = (state_36671[(12)]);
var inst_36396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36397 = [inst_36371,"ASC"];
var inst_36398 = (new cljs.core.PersistentVector(null,2,(5),inst_36396,inst_36397,null));
var state_36671__$1 = state_36671;
var statearr_36698_36874 = state_36671__$1;
(statearr_36698_36874[(2)] = inst_36398);

(statearr_36698_36874[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (102))){
var inst_36597 = (state_36671[(2)]);
var inst_36598 = fluree.db.util.async.throw_err(inst_36597);
var state_36671__$1 = state_36671;
var statearr_36699_36875 = state_36671__$1;
(statearr_36699_36875[(2)] = inst_36598);

(statearr_36699_36875[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (55))){
var inst_36469 = (state_36671[(2)]);
var inst_36470 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36471 = [from];
var inst_36472 = (new cljs.core.PersistentVector(null,1,(5),inst_36470,inst_36471,null));
var inst_36473 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_36472,inst_36469);
var state_36671__$1 = state_36671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36671__$1,(56),inst_36473);
} else {
if((state_val_36672 === (85))){
var inst_36550 = cljs.core._deref(fuel);
var inst_36551 = (inst_36550 + (1));
var inst_36552 = cljs.core._vreset_BANG_(fuel,inst_36551);
var state_36671__$1 = state_36671;
var statearr_36700_36876 = state_36671__$1;
(statearr_36700_36876[(2)] = inst_36552);

(statearr_36700_36876[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (39))){
var inst_36372 = (state_36671[(8)]);
var state_36671__$1 = state_36671;
var statearr_36701_36877 = state_36671__$1;
(statearr_36701_36877[(2)] = inst_36372);

(statearr_36701_36877[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (88))){
var inst_36568 = from;
var inst_36569 = cljs.core.seq(inst_36568);
var inst_36570 = cljs.core.first(inst_36569);
var inst_36571 = cljs.core.next(inst_36569);
var inst_36572 = cljs.core.PersistentVector.EMPTY;
var inst_36573 = inst_36568;
var inst_36574 = inst_36572;
var state_36671__$1 = (function (){var statearr_36702 = state_36671;
(statearr_36702[(15)] = inst_36574);

(statearr_36702[(16)] = inst_36571);

(statearr_36702[(17)] = inst_36573);

(statearr_36702[(18)] = inst_36570);

return statearr_36702;
})();
var statearr_36703_36878 = state_36671__$1;
(statearr_36703_36878[(2)] = null);

(statearr_36703_36878[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (46))){
var inst_36645 = (state_36671[(2)]);
var state_36671__$1 = state_36671;
var statearr_36704_36879 = state_36671__$1;
(statearr_36704_36879[(2)] = inst_36645);

(statearr_36704_36879[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (4))){
var inst_36339 = (state_36671[(2)]);
var state_36671__$1 = state_36671;
var statearr_36705_36880 = state_36671__$1;
(statearr_36705_36880[(2)] = inst_36339);

(statearr_36705_36880[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (77))){
var inst_36533 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_36671__$1 = state_36671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36671__$1,(80),inst_36533);
} else {
if((state_val_36672 === (106))){
var inst_36623 = (state_36671[(2)]);
var inst_36624 = fluree.db.util.async.throw_err(inst_36623);
var state_36671__$1 = state_36671;
var statearr_36706_36881 = state_36671__$1;
(statearr_36706_36881[(2)] = inst_36624);

(statearr_36706_36881[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (119))){
var inst_36652 = (state_36671[(19)]);
var inst_36655 = cljs.core.coll_QMARK_(inst_36652);
var inst_36656 = fluree.db.util.core.exception_QMARK_(inst_36652);
var inst_36657 = (!(inst_36656));
var inst_36658 = ((inst_36655) && (inst_36657));
var state_36671__$1 = state_36671;
var statearr_36707_36882 = state_36671__$1;
(statearr_36707_36882[(2)] = inst_36658);

(statearr_36707_36882[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (95))){
var inst_36608 = (state_36671[(2)]);
var state_36671__$1 = state_36671;
var statearr_36708_36883 = state_36671__$1;
(statearr_36708_36883[(2)] = inst_36608);

(statearr_36708_36883[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (54))){
var inst_36374 = (state_36671[(7)]);
var inst_36372 = (state_36671[(8)]);
var inst_36465 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_36466 = [inst_36372,inst_36374];
var inst_36467 = cljs.core.PersistentHashMap.fromArrays(inst_36465,inst_36466);
var state_36671__$1 = state_36671;
var statearr_36709_36884 = state_36671__$1;
(statearr_36709_36884[(2)] = inst_36467);

(statearr_36709_36884[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (92))){
var inst_36371 = (state_36671[(12)]);
var inst_36610 = (state_36671[(2)]);
var inst_36611 = cljs.core.PersistentVector.EMPTY;
var inst_36612 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36611,inst_36610);
var state_36671__$1 = (function (){var statearr_36710 = state_36671;
(statearr_36710[(20)] = inst_36612);

return statearr_36710;
})();
if(cljs.core.truth_(inst_36371)){
var statearr_36711_36885 = state_36671__$1;
(statearr_36711_36885[(1)] = (107));

} else {
var statearr_36712_36886 = state_36671__$1;
(statearr_36712_36886[(1)] = (108));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (104))){
var inst_36574 = (state_36671[(15)]);
var state_36671__$1 = state_36671;
var statearr_36713_36887 = state_36671__$1;
(statearr_36713_36887[(2)] = inst_36574);

(statearr_36713_36887[(1)] = (105));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (15))){
var inst_36375 = (state_36671[(21)]);
var inst_36373 = (state_36671[(22)]);
var inst_36379 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36375,cljs.core.cst$kw$componentFollow_QMARK_,inst_36373);
var state_36671__$1 = state_36671;
var statearr_36714_36888 = state_36671__$1;
(statearr_36714_36888[(2)] = inst_36379);

(statearr_36714_36888[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (48))){
var inst_36449 = (state_36671[(23)]);
var state_36671__$1 = state_36671;
var statearr_36715_36889 = state_36671__$1;
(statearr_36715_36889[(2)] = inst_36449);

(statearr_36715_36889[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (50))){
var inst_36455 = (state_36671[(24)]);
var inst_36457 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_36458 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_36455,inst_36457);
var state_36671__$1 = state_36671;
var statearr_36716_36890 = state_36671__$1;
(statearr_36716_36890[(2)] = inst_36458);

(statearr_36716_36890[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (116))){
var inst_36418 = (state_36671[(10)]);
var inst_36374 = (state_36671[(7)]);
var inst_36372 = (state_36671[(8)]);
var inst_36647 = (state_36671[(25)]);
var inst_36417 = (state_36671[(11)]);
var inst_36649 = fluree.db.query.fql.sort_offset_and_limit_res(inst_36417,inst_36418,inst_36374,inst_36372,inst_36647);
var state_36671__$1 = state_36671;
var statearr_36717_36891 = state_36671__$1;
(statearr_36717_36891[(2)] = inst_36649);

(statearr_36717_36891[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (75))){
var inst_36382 = (state_36671[(26)]);
var inst_36384 = (state_36671[(27)]);
var inst_36523 = (state_36671[(2)]);
var inst_36524 = fluree.db.util.async.throw_err(inst_36523);
var inst_36525 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_36384,fuel,max_fuel,inst_36382,inst_36524);
var state_36671__$1 = state_36671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36671__$1,(76),inst_36525);
} else {
if((state_val_36672 === (99))){
var inst_36589 = cljs.core._deref(fuel);
var inst_36590 = (inst_36589 + (1));
var inst_36591 = cljs.core._vreset_BANG_(fuel,inst_36590);
var state_36671__$1 = state_36671;
var statearr_36718_36892 = state_36671__$1;
(statearr_36718_36892[(2)] = inst_36591);

(statearr_36718_36892[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (21))){
var inst_36371 = (state_36671[(12)]);
var inst_36388 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36389 = cljs.core.second(inst_36371);
var inst_36390 = cljs.core.first(inst_36371);
var inst_36391 = [inst_36389,inst_36390];
var inst_36392 = (new cljs.core.PersistentVector(null,2,(5),inst_36388,inst_36391,null));
var state_36671__$1 = state_36671;
var statearr_36719_36893 = state_36671__$1;
(statearr_36719_36893[(2)] = inst_36392);

(statearr_36719_36893[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (31))){
var inst_36443 = typeof from === 'string';
var inst_36444 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_36445 = clojure.string.includes_QMARK_(inst_36444,"/");
var inst_36446 = ((inst_36443) && (inst_36445));
var state_36671__$1 = state_36671;
if(cljs.core.truth_(inst_36446)){
var statearr_36720_36894 = state_36671__$1;
(statearr_36720_36894[(1)] = (44));

} else {
var statearr_36721_36895 = state_36671__$1;
(statearr_36721_36895[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (113))){
var inst_36627 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_36628 = ["Invalid 'from' in query:",inst_36627].join('');
var inst_36629 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36630 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_36631 = cljs.core.PersistentHashMap.fromArrays(inst_36629,inst_36630);
var inst_36632 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36628,inst_36631);
var state_36671__$1 = state_36671;
var statearr_36722_36896 = state_36671__$1;
(statearr_36722_36896[(2)] = inst_36632);

(statearr_36722_36896[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (32))){
var inst_36417 = (state_36671[(11)]);
var inst_36647 = (state_36671[(2)]);
var state_36671__$1 = (function (){var statearr_36723 = state_36671;
(statearr_36723[(25)] = inst_36647);

return statearr_36723;
})();
if(cljs.core.truth_(inst_36417)){
var statearr_36724_36897 = state_36671__$1;
(statearr_36724_36897[(1)] = (116));

} else {
var statearr_36725_36898 = state_36671__$1;
(statearr_36725_36898[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (40))){
var inst_36371 = (state_36671[(12)]);
var inst_36433 = (state_36671[(2)]);
var state_36671__$1 = (function (){var statearr_36726 = state_36671;
(statearr_36726[(28)] = inst_36433);

return statearr_36726;
})();
if(cljs.core.truth_(inst_36371)){
var statearr_36727_36899 = state_36671__$1;
(statearr_36727_36899[(1)] = (41));

} else {
var statearr_36728_36900 = state_36671__$1;
(statearr_36728_36900[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (91))){
var inst_36573 = (state_36671[(17)]);
var inst_36580 = (state_36671[(13)]);
var inst_36579 = cljs.core.seq(inst_36573);
var inst_36580__$1 = cljs.core.first(inst_36579);
var inst_36581 = cljs.core.next(inst_36579);
var inst_36582 = cljs.core.not(inst_36580__$1);
var state_36671__$1 = (function (){var statearr_36729 = state_36671;
(statearr_36729[(13)] = inst_36580__$1);

(statearr_36729[(29)] = inst_36581);

return statearr_36729;
})();
if(inst_36582){
var statearr_36730_36901 = state_36671__$1;
(statearr_36730_36901[(1)] = (93));

} else {
var statearr_36731_36902 = state_36671__$1;
(statearr_36731_36902[(1)] = (94));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (117))){
var inst_36647 = (state_36671[(25)]);
var state_36671__$1 = state_36671;
var statearr_36732_36903 = state_36671__$1;
(statearr_36732_36903[(2)] = inst_36647);

(statearr_36732_36903[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (108))){
var inst_36372 = (state_36671[(8)]);
var state_36671__$1 = state_36671;
var statearr_36733_36904 = state_36671__$1;
(statearr_36733_36904[(2)] = inst_36372);

(statearr_36733_36904[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (56))){
var inst_36382 = (state_36671[(26)]);
var inst_36372 = (state_36671[(8)]);
var inst_36384 = (state_36671[(27)]);
var inst_36461 = (state_36671[(30)]);
var inst_36475 = (state_36671[(2)]);
var inst_36476 = fluree.db.util.async.throw_err(inst_36475);
var inst_36477 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_36461,inst_36476);
var inst_36478 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_36384,fuel,max_fuel,inst_36382,inst_36477,inst_36372);
var state_36671__$1 = state_36671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36671__$1,(57),inst_36478);
} else {
if((state_val_36672 === (33))){
var state_36671__$1 = state_36671;
var statearr_36734_36905 = state_36671__$1;
(statearr_36734_36905[(2)] = from);

(statearr_36734_36905[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (13))){
var inst_36358 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36359 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_36360 = cljs.core.PersistentHashMap.fromArrays(inst_36358,inst_36359);
var inst_36361 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_36360);
var inst_36362 = (function(){throw inst_36361})();
var state_36671__$1 = state_36671;
var statearr_36735_36906 = state_36671__$1;
(statearr_36735_36906[(2)] = inst_36362);

(statearr_36735_36906[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (22))){
var inst_36371 = (state_36671[(12)]);
var inst_36394 = typeof inst_36371 === 'string';
var state_36671__$1 = state_36671;
if(cljs.core.truth_(inst_36394)){
var statearr_36736_36907 = state_36671__$1;
(statearr_36736_36907[(1)] = (24));

} else {
var statearr_36737_36908 = state_36671__$1;
(statearr_36737_36908[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (90))){
var inst_36637 = (state_36671[(2)]);
var state_36671__$1 = state_36671;
var statearr_36738_36909 = state_36671__$1;
(statearr_36738_36909[(2)] = inst_36637);

(statearr_36738_36909[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (109))){
var inst_36371 = (state_36671[(12)]);
var inst_36616 = (state_36671[(2)]);
var state_36671__$1 = (function (){var statearr_36739 = state_36671;
(statearr_36739[(31)] = inst_36616);

return statearr_36739;
})();
if(cljs.core.truth_(inst_36371)){
var statearr_36740_36910 = state_36671__$1;
(statearr_36740_36910[(1)] = (110));

} else {
var statearr_36741_36911 = state_36671__$1;
(statearr_36741_36911[(1)] = (111));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (36))){
var inst_36371 = (state_36671[(12)]);
var inst_36428 = (state_36671[(2)]);
var inst_36429 = fluree.db.util.async.throw_err(inst_36428);
var state_36671__$1 = (function (){var statearr_36742 = state_36671;
(statearr_36742[(32)] = inst_36429);

return statearr_36742;
})();
if(cljs.core.truth_(inst_36371)){
var statearr_36743_36912 = state_36671__$1;
(statearr_36743_36912[(1)] = (38));

} else {
var statearr_36744_36913 = state_36671__$1;
(statearr_36744_36913[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (41))){
var state_36671__$1 = state_36671;
var statearr_36745_36914 = state_36671__$1;
(statearr_36745_36914[(2)] = null);

(statearr_36745_36914[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (118))){
var inst_36653 = (state_36671[(33)]);
var inst_36652 = (state_36671[(2)]);
var inst_36653__$1 = selectOne;
var state_36671__$1 = (function (){var statearr_36746 = state_36671;
(statearr_36746[(33)] = inst_36653__$1);

(statearr_36746[(19)] = inst_36652);

return statearr_36746;
})();
if(cljs.core.truth_(inst_36653__$1)){
var statearr_36747_36915 = state_36671__$1;
(statearr_36747_36915[(1)] = (119));

} else {
var statearr_36748_36916 = state_36671__$1;
(statearr_36748_36916[(1)] = (120));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (89))){
var state_36671__$1 = state_36671;
var statearr_36749_36917 = state_36671__$1;
(statearr_36749_36917[(1)] = (113));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (100))){
var state_36671__$1 = state_36671;
var statearr_36751_36918 = state_36671__$1;
(statearr_36751_36918[(2)] = null);

(statearr_36751_36918[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (122))){
var inst_36652 = (state_36671[(19)]);
var inst_36663 = cljs.core.first(inst_36652);
var state_36671__$1 = state_36671;
var statearr_36752_36919 = state_36671__$1;
(statearr_36752_36919[(2)] = inst_36663);

(statearr_36752_36919[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (43))){
var inst_36382 = (state_36671[(26)]);
var inst_36433 = (state_36671[(28)]);
var inst_36384 = (state_36671[(27)]);
var inst_36429 = (state_36671[(32)]);
var inst_36437 = (state_36671[(2)]);
var inst_36438 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_36384,fuel,max_fuel,inst_36382,inst_36429,inst_36433,inst_36437);
var state_36671__$1 = state_36671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36671__$1,(37),inst_36438);
} else {
if((state_val_36672 === (61))){
var inst_36371 = (state_36671[(12)]);
var state_36671__$1 = state_36671;
if(cljs.core.truth_(inst_36371)){
var statearr_36753_36920 = state_36671__$1;
(statearr_36753_36920[(1)] = (64));

} else {
var statearr_36754_36921 = state_36671__$1;
(statearr_36754_36921[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (29))){
var inst_36406 = (state_36671[(2)]);
var state_36671__$1 = state_36671;
var statearr_36755_36922 = state_36671__$1;
(statearr_36755_36922[(2)] = inst_36406);

(statearr_36755_36922[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (44))){
var inst_36449 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_36671__$1 = (function (){var statearr_36756 = state_36671;
(statearr_36756[(23)] = inst_36449);

return statearr_36756;
})();
if(cljs.core.truth_(fuel)){
var statearr_36757_36923 = state_36671__$1;
(statearr_36757_36923[(1)] = (47));

} else {
var statearr_36758_36924 = state_36671__$1;
(statearr_36758_36924[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (93))){
var inst_36574 = (state_36671[(15)]);
var state_36671__$1 = state_36671;
var statearr_36759_36925 = state_36671__$1;
(statearr_36759_36925[(2)] = inst_36574);

(statearr_36759_36925[(1)] = (95));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (6))){
var inst_36349 = (state_36671[(34)]);
var state_36671__$1 = state_36671;
var statearr_36760_36926 = state_36671__$1;
(statearr_36760_36926[(2)] = inst_36349);

(statearr_36760_36926[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (111))){
var inst_36374 = (state_36671[(7)]);
var state_36671__$1 = state_36671;
var statearr_36761_36927 = state_36671__$1;
(statearr_36761_36927[(2)] = inst_36374);

(statearr_36761_36927[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (28))){
var state_36671__$1 = state_36671;
var statearr_36762_36928 = state_36671__$1;
(statearr_36762_36928[(2)] = null);

(statearr_36762_36928[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (64))){
var inst_36495 = cljs.core.PersistentHashMap.EMPTY;
var state_36671__$1 = state_36671;
var statearr_36763_36929 = state_36671__$1;
(statearr_36763_36929[(2)] = inst_36495);

(statearr_36763_36929[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (103))){
var inst_36574 = (state_36671[(15)]);
var inst_36600 = (state_36671[(35)]);
var inst_36602 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36574,inst_36600);
var state_36671__$1 = state_36671;
var statearr_36764_36930 = state_36671__$1;
(statearr_36764_36930[(2)] = inst_36602);

(statearr_36764_36930[(1)] = (105));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (51))){
var inst_36455 = (state_36671[(24)]);
var state_36671__$1 = state_36671;
var statearr_36765_36931 = state_36671__$1;
(statearr_36765_36931[(2)] = inst_36455);

(statearr_36765_36931[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (25))){
var state_36671__$1 = state_36671;
var statearr_36766_36932 = state_36671__$1;
(statearr_36766_36932[(1)] = (27));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (34))){
var state_36671__$1 = state_36671;
var statearr_36768_36933 = state_36671__$1;
(statearr_36768_36933[(2)] = null);

(statearr_36768_36933[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (17))){
var inst_36371 = (state_36671[(12)]);
var inst_36382 = (state_36671[(2)]);
var inst_36383 = cljs.core.PersistentHashMap.EMPTY;
var inst_36384 = cljs.core.volatile_BANG_(inst_36383);
var state_36671__$1 = (function (){var statearr_36769 = state_36671;
(statearr_36769[(26)] = inst_36382);

(statearr_36769[(27)] = inst_36384);

return statearr_36769;
})();
if(cljs.core.truth_(inst_36371)){
var statearr_36770_36934 = state_36671__$1;
(statearr_36770_36934[(1)] = (18));

} else {
var statearr_36771_36935 = state_36671__$1;
(statearr_36771_36935[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (3))){
var inst_36669 = (state_36671[(2)]);
var state_36671__$1 = state_36671;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36671__$1,inst_36669);
} else {
if((state_val_36672 === (12))){
var inst_36355 = (state_36671[(36)]);
var state_36671__$1 = state_36671;
var statearr_36772_36936 = state_36671__$1;
(statearr_36772_36936[(2)] = inst_36355);

(statearr_36772_36936[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (2))){
var inst_36349 = (state_36671[(34)]);
var _ = (function (){var statearr_36773 = state_36671;
(statearr_36773[(4)] = cljs.core.cons((5),(state_36671[(4)])));

return statearr_36773;
})();
var inst_36349__$1 = select;
var state_36671__$1 = (function (){var statearr_36774 = state_36671;
(statearr_36774[(34)] = inst_36349__$1);

return statearr_36774;
})();
if(cljs.core.truth_(inst_36349__$1)){
var statearr_36775_36937 = state_36671__$1;
(statearr_36775_36937[(1)] = (6));

} else {
var statearr_36776_36938 = state_36671__$1;
(statearr_36776_36938[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (66))){
var inst_36501 = (state_36671[(2)]);
var inst_36502 = fluree.db.query.range._block_or_tx_collection(db,inst_36501);
var state_36671__$1 = state_36671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36671__$1,(67),inst_36502);
} else {
if((state_val_36672 === (107))){
var state_36671__$1 = state_36671;
var statearr_36777_36939 = state_36671__$1;
(statearr_36777_36939[(2)] = null);

(statearr_36777_36939[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (23))){
var inst_36410 = (state_36671[(2)]);
var state_36671__$1 = state_36671;
var statearr_36778_36940 = state_36671__$1;
(statearr_36778_36940[(2)] = inst_36410);

(statearr_36778_36940[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (47))){
var inst_36449 = (state_36671[(23)]);
var inst_36451 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_36452 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_36449,inst_36451);
var state_36671__$1 = state_36671;
var statearr_36779_36941 = state_36671__$1;
(statearr_36779_36941[(2)] = inst_36452);

(statearr_36779_36941[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (35))){
var inst_36425 = (state_36671[(2)]);
var inst_36426 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_36425);
var state_36671__$1 = state_36671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36671__$1,(36),inst_36426);
} else {
if((state_val_36672 === (82))){
var inst_36536 = (state_36671[(37)]);
var inst_36540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36541 = [inst_36536];
var inst_36542 = (new cljs.core.PersistentVector(null,1,(5),inst_36540,inst_36541,null));
var state_36671__$1 = state_36671;
var statearr_36780_36942 = state_36671__$1;
(statearr_36780_36942[(2)] = inst_36542);

(statearr_36780_36942[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (76))){
var inst_36527 = (state_36671[(2)]);
var inst_36528 = fluree.db.util.async.throw_err(inst_36527);
var state_36671__$1 = state_36671;
var statearr_36781_36943 = state_36671__$1;
(statearr_36781_36943[(2)] = inst_36528);

(statearr_36781_36943[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (97))){
var state_36671__$1 = state_36671;
if(cljs.core.truth_(fuel)){
var statearr_36782_36944 = state_36671__$1;
(statearr_36782_36944[(1)] = (99));

} else {
var statearr_36783_36945 = state_36671__$1;
(statearr_36783_36945[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (19))){
var inst_36412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36413 = [null,null];
var inst_36414 = (new cljs.core.PersistentVector(null,2,(5),inst_36412,inst_36413,null));
var state_36671__$1 = state_36671;
var statearr_36784_36946 = state_36671__$1;
(statearr_36784_36946[(2)] = inst_36414);

(statearr_36784_36946[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (57))){
var inst_36480 = (state_36671[(2)]);
var inst_36481 = fluree.db.util.async.throw_err(inst_36480);
var state_36671__$1 = state_36671;
var statearr_36785_36947 = state_36671__$1;
(statearr_36785_36947[(2)] = inst_36481);

(statearr_36785_36947[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (68))){
var inst_36508 = (state_36671[(2)]);
var inst_36509 = fluree.db.util.async.throw_err(inst_36508);
var state_36671__$1 = state_36671;
var statearr_36786_36948 = state_36671__$1;
(statearr_36786_36948[(2)] = inst_36509);

(statearr_36786_36948[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (11))){
var inst_36366 = (state_36671[(2)]);
var state_36671__$1 = state_36671;
var statearr_36787_36949 = state_36671__$1;
(statearr_36787_36949[(2)] = inst_36366);

(statearr_36787_36949[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (115))){
var inst_36635 = (state_36671[(2)]);
var state_36671__$1 = state_36671;
var statearr_36789_36950 = state_36671__$1;
(statearr_36789_36950[(2)] = inst_36635);

(statearr_36789_36950[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (9))){
var inst_36352 = (state_36671[(9)]);
var state_36671__$1 = state_36671;
var statearr_36790_36951 = state_36671__$1;
(statearr_36790_36951[(2)] = inst_36352);

(statearr_36790_36951[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (5))){
var _ = (function (){var statearr_36791 = state_36671;
(statearr_36791[(4)] = cljs.core.rest((state_36671[(4)])));

return statearr_36791;
})();
var state_36671__$1 = state_36671;
var ex36788 = (state_36671__$1[(2)]);
var statearr_36792_36952 = state_36671__$1;
(statearr_36792_36952[(5)] = ex36788);


if((ex36788 instanceof Error)){
var statearr_36793_36953 = state_36671__$1;
(statearr_36793_36953[(1)] = (4));

(statearr_36793_36953[(5)] = null);

} else {
throw ex36788;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (112))){
var inst_36382 = (state_36671[(26)]);
var inst_36616 = (state_36671[(31)]);
var inst_36384 = (state_36671[(27)]);
var inst_36612 = (state_36671[(20)]);
var inst_36620 = (state_36671[(2)]);
var inst_36621 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_36384,fuel,max_fuel,inst_36382,inst_36612,inst_36616,inst_36620);
var state_36671__$1 = state_36671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36671__$1,(106),inst_36621);
} else {
if((state_val_36672 === (83))){
var inst_36382 = (state_36671[(26)]);
var inst_36374 = (state_36671[(7)]);
var inst_36372 = (state_36671[(8)]);
var inst_36384 = (state_36671[(27)]);
var inst_36544 = (state_36671[(2)]);
var inst_36545 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_36384,fuel,max_fuel,inst_36382,inst_36544,inst_36372,inst_36374);
var state_36671__$1 = state_36671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36671__$1,(84),inst_36545);
} else {
if((state_val_36672 === (14))){
var inst_36364 = (state_36671[(2)]);
var state_36671__$1 = state_36671;
var statearr_36794_36954 = state_36671__$1;
(statearr_36794_36954[(2)] = inst_36364);

(statearr_36794_36954[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (45))){
var inst_36484 = typeof from === 'string';
var state_36671__$1 = state_36671;
if(cljs.core.truth_(inst_36484)){
var statearr_36795_36955 = state_36671__$1;
(statearr_36795_36955[(1)] = (58));

} else {
var statearr_36796_36956 = state_36671__$1;
(statearr_36796_36956[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (53))){
var inst_36463 = cljs.core.PersistentHashMap.EMPTY;
var state_36671__$1 = state_36671;
var statearr_36797_36957 = state_36671__$1;
(statearr_36797_36957[(2)] = inst_36463);

(statearr_36797_36957[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (78))){
var inst_36557 = cljs.core.sequential_QMARK_(from);
var inst_36558 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var inst_36559 = ((inst_36557) && (inst_36558));
var state_36671__$1 = state_36671;
if(cljs.core.truth_(inst_36559)){
var statearr_36798_36958 = state_36671__$1;
(statearr_36798_36958[(1)] = (88));

} else {
var statearr_36799_36959 = state_36671__$1;
(statearr_36799_36959[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (26))){
var inst_36408 = (state_36671[(2)]);
var state_36671__$1 = state_36671;
var statearr_36800_36960 = state_36671__$1;
(statearr_36800_36960[(2)] = inst_36408);

(statearr_36800_36960[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (123))){
var inst_36652 = (state_36671[(19)]);
var state_36671__$1 = state_36671;
var statearr_36801_36961 = state_36671__$1;
(statearr_36801_36961[(2)] = inst_36652);

(statearr_36801_36961[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (16))){
var inst_36375 = (state_36671[(21)]);
var state_36671__$1 = state_36671;
var statearr_36802_36962 = state_36671__$1;
(statearr_36802_36962[(2)] = inst_36375);

(statearr_36802_36962[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (81))){
var state_36671__$1 = state_36671;
var statearr_36803_36963 = state_36671__$1;
(statearr_36803_36963[(2)] = null);

(statearr_36803_36963[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (120))){
var inst_36653 = (state_36671[(33)]);
var state_36671__$1 = state_36671;
var statearr_36804_36964 = state_36671__$1;
(statearr_36804_36964[(2)] = inst_36653);

(statearr_36804_36964[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (79))){
var inst_36639 = (state_36671[(2)]);
var state_36671__$1 = state_36671;
var statearr_36805_36965 = state_36671__$1;
(statearr_36805_36965[(2)] = inst_36639);

(statearr_36805_36965[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (38))){
var state_36671__$1 = state_36671;
var statearr_36806_36966 = state_36671__$1;
(statearr_36806_36966[(2)] = null);

(statearr_36806_36966[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (98))){
var inst_36600 = (state_36671[(35)]);
var inst_36600__$1 = (state_36671[(2)]);
var state_36671__$1 = (function (){var statearr_36807 = state_36671;
(statearr_36807[(35)] = inst_36600__$1);

return statearr_36807;
})();
if(cljs.core.truth_(inst_36600__$1)){
var statearr_36808_36967 = state_36671__$1;
(statearr_36808_36967[(1)] = (103));

} else {
var statearr_36809_36968 = state_36671__$1;
(statearr_36809_36968[(1)] = (104));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (124))){
var inst_36666 = (state_36671[(2)]);
var _ = (function (){var statearr_36810 = state_36671;
(statearr_36810[(4)] = cljs.core.rest((state_36671[(4)])));

return statearr_36810;
})();
var state_36671__$1 = state_36671;
var statearr_36811_36969 = state_36671__$1;
(statearr_36811_36969[(2)] = inst_36666);

(statearr_36811_36969[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (87))){
var inst_36548 = (state_36671[(38)]);
var inst_36555 = (state_36671[(2)]);
var state_36671__$1 = (function (){var statearr_36812 = state_36671;
(statearr_36812[(39)] = inst_36555);

return statearr_36812;
})();
var statearr_36813_36970 = state_36671__$1;
(statearr_36813_36970[(2)] = inst_36548);

(statearr_36813_36970[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (30))){
var inst_36421 = typeof from === 'string';
var state_36671__$1 = state_36671;
if(cljs.core.truth_(inst_36421)){
var statearr_36814_36971 = state_36671__$1;
(statearr_36814_36971[(1)] = (33));

} else {
var statearr_36815_36972 = state_36671__$1;
(statearr_36815_36972[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (73))){
var inst_36374 = (state_36671[(7)]);
var inst_36372 = (state_36671[(8)]);
var inst_36516 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_36517 = [inst_36372,inst_36374];
var inst_36518 = cljs.core.PersistentHashMap.fromArrays(inst_36516,inst_36517);
var state_36671__$1 = state_36671;
var statearr_36816_36973 = state_36671__$1;
(statearr_36816_36973[(2)] = inst_36518);

(statearr_36816_36973[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (96))){
var inst_36580 = (state_36671[(13)]);
var state_36671__$1 = state_36671;
var statearr_36817_36974 = state_36671__$1;
(statearr_36817_36974[(2)] = inst_36580);

(statearr_36817_36974[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (10))){
var inst_36355 = (state_36671[(36)]);
var inst_36355__$1 = selectDistinct;
var state_36671__$1 = (function (){var statearr_36818 = state_36671;
(statearr_36818[(36)] = inst_36355__$1);

return statearr_36818;
})();
if(cljs.core.truth_(inst_36355__$1)){
var statearr_36819_36975 = state_36671__$1;
(statearr_36819_36975[(1)] = (12));

} else {
var statearr_36820_36976 = state_36671__$1;
(statearr_36820_36976[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (18))){
var inst_36371 = (state_36671[(12)]);
var inst_36386 = cljs.core.vector_QMARK_(inst_36371);
var state_36671__$1 = state_36671;
if(inst_36386){
var statearr_36821_36977 = state_36671__$1;
(statearr_36821_36977[(1)] = (21));

} else {
var statearr_36822_36978 = state_36671__$1;
(statearr_36822_36978[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (105))){
var inst_36581 = (state_36671[(29)]);
var inst_36605 = (state_36671[(2)]);
var inst_36573 = inst_36581;
var inst_36574 = inst_36605;
var state_36671__$1 = (function (){var statearr_36823 = state_36671;
(statearr_36823[(15)] = inst_36574);

(statearr_36823[(17)] = inst_36573);

return statearr_36823;
})();
var statearr_36824_36979 = state_36671__$1;
(statearr_36824_36979[(2)] = null);

(statearr_36824_36979[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (52))){
var inst_36371 = (state_36671[(12)]);
var inst_36461 = (state_36671[(2)]);
var state_36671__$1 = (function (){var statearr_36825 = state_36671;
(statearr_36825[(30)] = inst_36461);

return statearr_36825;
})();
if(cljs.core.truth_(inst_36371)){
var statearr_36826_36980 = state_36671__$1;
(statearr_36826_36980[(1)] = (53));

} else {
var statearr_36827_36981 = state_36671__$1;
(statearr_36827_36981[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (114))){
var state_36671__$1 = state_36671;
var statearr_36828_36982 = state_36671__$1;
(statearr_36828_36982[(2)] = null);

(statearr_36828_36982[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (67))){
var inst_36382 = (state_36671[(26)]);
var inst_36384 = (state_36671[(27)]);
var inst_36504 = (state_36671[(2)]);
var inst_36505 = fluree.db.util.async.throw_err(inst_36504);
var inst_36506 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_36384,fuel,max_fuel,inst_36382,inst_36505);
var state_36671__$1 = state_36671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36671__$1,(68),inst_36506);
} else {
if((state_val_36672 === (71))){
var inst_36641 = (state_36671[(2)]);
var state_36671__$1 = state_36671;
var statearr_36829_36983 = state_36671__$1;
(statearr_36829_36983[(2)] = inst_36641);

(statearr_36829_36983[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (42))){
var inst_36374 = (state_36671[(7)]);
var state_36671__$1 = state_36671;
var statearr_36830_36984 = state_36671__$1;
(statearr_36830_36984[(2)] = inst_36374);

(statearr_36830_36984[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (80))){
var inst_36536 = (state_36671[(37)]);
var inst_36535 = (state_36671[(2)]);
var inst_36536__$1 = fluree.db.util.async.throw_err(inst_36535);
var inst_36537 = (inst_36536__$1 == null);
var state_36671__$1 = (function (){var statearr_36831 = state_36671;
(statearr_36831[(37)] = inst_36536__$1);

return statearr_36831;
})();
if(cljs.core.truth_(inst_36537)){
var statearr_36832_36985 = state_36671__$1;
(statearr_36832_36985[(1)] = (81));

} else {
var statearr_36833_36986 = state_36671__$1;
(statearr_36833_36986[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (37))){
var inst_36440 = (state_36671[(2)]);
var inst_36441 = fluree.db.util.async.throw_err(inst_36440);
var state_36671__$1 = state_36671;
var statearr_36834_36987 = state_36671__$1;
(statearr_36834_36987[(2)] = inst_36441);

(statearr_36834_36987[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (63))){
var inst_36643 = (state_36671[(2)]);
var state_36671__$1 = state_36671;
var statearr_36835_36988 = state_36671__$1;
(statearr_36835_36988[(2)] = inst_36643);

(statearr_36835_36988[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (94))){
var inst_36580 = (state_36671[(13)]);
var inst_36585 = cljs.core.int_QMARK_(inst_36580);
var state_36671__$1 = state_36671;
if(inst_36585){
var statearr_36836_36989 = state_36671__$1;
(statearr_36836_36989[(1)] = (96));

} else {
var statearr_36837_36990 = state_36671__$1;
(statearr_36837_36990[(1)] = (97));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (8))){
var inst_36373 = (state_36671[(22)]);
var inst_36368 = (state_36671[(2)]);
var inst_36369 = opts_SINGLEQUOTE_;
var inst_36370 = cljs.core.__destructure_map(inst_36369);
var inst_36371 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36370,cljs.core.cst$kw$orderBy);
var inst_36372 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36370,cljs.core.cst$kw$limit);
var inst_36373__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36370,cljs.core.cst$kw$component);
var inst_36374 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36370,cljs.core.cst$kw$offset);
var inst_36375 = fluree.db.query.fql_parser.parse_db(db,inst_36368,opts_SINGLEQUOTE_);
var inst_36376 = (inst_36373__$1 == null);
var inst_36377 = cljs.core.not(inst_36376);
var state_36671__$1 = (function (){var statearr_36838 = state_36671;
(statearr_36838[(21)] = inst_36375);

(statearr_36838[(12)] = inst_36371);

(statearr_36838[(22)] = inst_36373__$1);

(statearr_36838[(7)] = inst_36374);

(statearr_36838[(8)] = inst_36372);

return statearr_36838;
})();
if(inst_36377){
var statearr_36839_36991 = state_36671__$1;
(statearr_36839_36991[(1)] = (15));

} else {
var statearr_36840_36992 = state_36671__$1;
(statearr_36840_36992[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (49))){
var inst_36455 = (state_36671[(2)]);
var state_36671__$1 = (function (){var statearr_36841 = state_36671;
(statearr_36841[(24)] = inst_36455);

return statearr_36841;
})();
var statearr_36842_36993 = state_36671__$1;
(statearr_36842_36993[(1)] = (50));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36672 === (84))){
var inst_36547 = (state_36671[(2)]);
var inst_36548 = fluree.db.util.async.throw_err(inst_36547);
var state_36671__$1 = (function (){var statearr_36844 = state_36671;
(statearr_36844[(38)] = inst_36548);

return statearr_36844;
})();
if(cljs.core.truth_(fuel)){
var statearr_36845_36994 = state_36671__$1;
(statearr_36845_36994[(1)] = (85));

} else {
var statearr_36846_36995 = state_36671__$1;
(statearr_36846_36995[(1)] = (86));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__13883__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__13883__auto____0 = (function (){
var statearr_36847 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36847[(0)] = fluree$db$query$fql$query_$_state_machine__13883__auto__);

(statearr_36847[(1)] = (1));

return statearr_36847;
});
var fluree$db$query$fql$query_$_state_machine__13883__auto____1 = (function (state_36671){
while(true){
var ret_value__13884__auto__ = (function (){try{while(true){
var result__13885__auto__ = switch__13882__auto__(state_36671);
if(cljs.core.keyword_identical_QMARK_(result__13885__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__13885__auto__;
}
break;
}
}catch (e36848){var ex__13886__auto__ = e36848;
var statearr_36849_36996 = state_36671;
(statearr_36849_36996[(2)] = ex__13886__auto__);


if(cljs.core.seq((state_36671[(4)]))){
var statearr_36850_36997 = state_36671;
(statearr_36850_36997[(1)] = cljs.core.first((state_36671[(4)])));

} else {
throw ex__13886__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__13884__auto__,cljs.core.cst$kw$recur)){
var G__36998 = state_36671;
state_36671 = G__36998;
continue;
} else {
return ret_value__13884__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__13883__auto__ = function(state_36671){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__13883__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__13883__auto____1.call(this,state_36671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__13883__auto____0;
fluree$db$query$fql$query_$_state_machine__13883__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__13883__auto____1;
return fluree$db$query$fql$query_$_state_machine__13883__auto__;
})()
})();
var state__13959__auto__ = (function (){var statearr_36851 = (f__13958__auto__.cljs$core$IFn$_invoke$arity$0 ? f__13958__auto__.cljs$core$IFn$_invoke$arity$0() : f__13958__auto__.call(null));
(statearr_36851[(6)] = c__13957__auto__);

return statearr_36851;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__13959__auto__);
}));

return c__13957__auto__;
}

});
