// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$column,col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__77207 = (line + (1));
var G__77208 = (1);
var G__77209 = (counter + (1));
line = G__77207;
col = G__77208;
counter = G__77209;
continue;
} else {
var G__77210 = line;
var G__77211 = (col + (1));
var G__77212 = (counter + (1));
line = G__77210;
col = G__77211;
counter = G__77212;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__77213 = cljs.core.next(chars);
var G__77214 = (n__$1 - (1));
chars = G__77213;
n__$1 = G__77214;
continue;
} else {
var G__77215 = cljs.core.next(chars);
var G__77216 = n__$1;
chars = G__77215;
n__$1 = G__77216;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$text,instaparse.failure.get_line(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$char_DASH_range.cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__77217){
var map__77218 = p__77217;
var map__77218__$1 = cljs.core.__destructure_map(map__77218);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77218__$1,cljs.core.cst$kw$line);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77218__$1,cljs.core.cst$kw$column);
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77218__$1,cljs.core.cst$kw$text);
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__77218__$1,cljs.core.cst$kw$reason);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full,reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.cst$kw$full),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__77219_77227 = cljs.core.seq(full_reasons);
var chunk__77220_77228 = null;
var count__77221_77229 = (0);
var i__77222_77230 = (0);
while(true){
if((i__77222_77230 < count__77221_77229)){
var r_77231 = chunk__77220_77228.cljs$core$IIndexed$_nth$arity$2(null,i__77222_77230);
instaparse.failure.print_reason(r_77231);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__77232 = seq__77219_77227;
var G__77233 = chunk__77220_77228;
var G__77234 = count__77221_77229;
var G__77235 = (i__77222_77230 + (1));
seq__77219_77227 = G__77232;
chunk__77220_77228 = G__77233;
count__77221_77229 = G__77234;
i__77222_77230 = G__77235;
continue;
} else {
var temp__5753__auto___77236 = cljs.core.seq(seq__77219_77227);
if(temp__5753__auto___77236){
var seq__77219_77237__$1 = temp__5753__auto___77236;
if(cljs.core.chunked_seq_QMARK_(seq__77219_77237__$1)){
var c__4591__auto___77238 = cljs.core.chunk_first(seq__77219_77237__$1);
var G__77239 = cljs.core.chunk_rest(seq__77219_77237__$1);
var G__77240 = c__4591__auto___77238;
var G__77241 = cljs.core.count(c__4591__auto___77238);
var G__77242 = (0);
seq__77219_77227 = G__77239;
chunk__77220_77228 = G__77240;
count__77221_77229 = G__77241;
i__77222_77230 = G__77242;
continue;
} else {
var r_77243 = cljs.core.first(seq__77219_77237__$1);
instaparse.failure.print_reason(r_77243);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__77244 = cljs.core.next(seq__77219_77237__$1);
var G__77245 = null;
var G__77246 = (0);
var G__77247 = (0);
seq__77219_77227 = G__77244;
chunk__77220_77228 = G__77245;
count__77221_77229 = G__77246;
i__77222_77230 = G__77247;
continue;
}
} else {
}
}
break;
}

var seq__77223 = cljs.core.seq(partial_reasons);
var chunk__77224 = null;
var count__77225 = (0);
var i__77226 = (0);
while(true){
if((i__77226 < count__77225)){
var r = chunk__77224.cljs$core$IIndexed$_nth$arity$2(null,i__77226);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__77248 = seq__77223;
var G__77249 = chunk__77224;
var G__77250 = count__77225;
var G__77251 = (i__77226 + (1));
seq__77223 = G__77248;
chunk__77224 = G__77249;
count__77225 = G__77250;
i__77226 = G__77251;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__77223);
if(temp__5753__auto__){
var seq__77223__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__77223__$1)){
var c__4591__auto__ = cljs.core.chunk_first(seq__77223__$1);
var G__77252 = cljs.core.chunk_rest(seq__77223__$1);
var G__77253 = c__4591__auto__;
var G__77254 = cljs.core.count(c__4591__auto__);
var G__77255 = (0);
seq__77223 = G__77252;
chunk__77224 = G__77253;
count__77225 = G__77254;
i__77226 = G__77255;
continue;
} else {
var r = cljs.core.first(seq__77223__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__77256 = cljs.core.next(seq__77223__$1);
var G__77257 = null;
var G__77258 = (0);
var G__77259 = (0);
seq__77223 = G__77256;
chunk__77224 = G__77257;
count__77225 = G__77258;
i__77226 = G__77259;
continue;
}
} else {
return null;
}
}
break;
}
});
