// Compiled by ClojureScript 1.10.844 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer(writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count(self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item = cljs.core.first(cljs.core.val(f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key(f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item_set = cljs.core.val(f);
var item = cljs.core.first(item_set);
var priority_key = cljs.core.key(f);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4564__auto__ = (function tailrecursion$priority_map$iter__40292(s__40293){
return (new cljs.core.LazySeq(null,(function (){
var s__40293__$1 = s__40293;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__40293__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__40298 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40298,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40298,(1),null);
var iterys__4560__auto__ = ((function (s__40293__$1,vec__40298,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__40292_$_iter__40294(s__40295){
return (new cljs.core.LazySeq(null,((function (s__40293__$1,vec__40298,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__40295__$1 = s__40295;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__40295__$1);
if(temp__5753__auto____$1){
var s__40295__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__40295__$2)){
var c__4562__auto__ = cljs.core.chunk_first(s__40295__$2);
var size__4563__auto__ = cljs.core.count(c__4562__auto__);
var b__40297 = cljs.core.chunk_buffer(size__4563__auto__);
if((function (){var i__40296 = (0);
while(true){
if((i__40296 < size__4563__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4562__auto__,i__40296);
cljs.core.chunk_append(b__40297,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__40350 = (i__40296 + (1));
i__40296 = G__40350;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40297),tailrecursion$priority_map$iter__40292_$_iter__40294(cljs.core.chunk_rest(s__40295__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40297),null);
}
} else {
var item = cljs.core.first(s__40295__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__40292_$_iter__40294(cljs.core.rest(s__40295__$2)));
}
} else {
return null;
}
break;
}
});})(s__40293__$1,vec__40298,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__40293__$1,vec__40298,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4561__auto__ = cljs.core.seq(iterys__4560__auto__(item_set));
if(fs__4561__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4561__auto__,tailrecursion$priority_map$iter__40292(cljs.core.rest(s__40293__$1)));
} else {
var G__40351 = cljs.core.rest(s__40293__$1);
s__40293__$1 = G__40351;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4564__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq((function (){var iter__4564__auto__ = (function tailrecursion$priority_map$iter__40301(s__40302){
return (new cljs.core.LazySeq(null,(function (){
var s__40302__$1 = s__40302;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__40302__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__40307 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40307,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40307,(1),null);
var iterys__4560__auto__ = ((function (s__40302__$1,vec__40307,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__40301_$_iter__40303(s__40304){
return (new cljs.core.LazySeq(null,((function (s__40302__$1,vec__40307,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__40304__$1 = s__40304;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__40304__$1);
if(temp__5753__auto____$1){
var s__40304__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__40304__$2)){
var c__4562__auto__ = cljs.core.chunk_first(s__40304__$2);
var size__4563__auto__ = cljs.core.count(c__4562__auto__);
var b__40306 = cljs.core.chunk_buffer(size__4563__auto__);
if((function (){var i__40305 = (0);
while(true){
if((i__40305 < size__4563__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4562__auto__,i__40305);
cljs.core.chunk_append(b__40306,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__40352 = (i__40305 + (1));
i__40305 = G__40352;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40306),tailrecursion$priority_map$iter__40301_$_iter__40303(cljs.core.chunk_rest(s__40304__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40306),null);
}
} else {
var item = cljs.core.first(s__40304__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__40301_$_iter__40303(cljs.core.rest(s__40304__$2)));
}
} else {
return null;
}
break;
}
});})(s__40302__$1,vec__40307,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__40302__$1,vec__40307,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4561__auto__ = cljs.core.seq(iterys__4560__auto__(item_set));
if(fs__4561__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4561__auto__,tailrecursion$priority_map$iter__40301(cljs.core.rest(s__40302__$1)));
} else {
var G__40353 = cljs.core.rest(s__40302__$1);
s__40302__$1 = G__40353;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4564__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4273__auto__ = self__.__hash;
if((!((h__4273__auto__ == null)))){
return h__4273__auto__;
} else {
var h__4273__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
(self__.__hash = h__4273__auto____$1);

return h__4273__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv(self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = (function (){var G__40310 = item;
var G__40311 = cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found;
return (self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2(G__40310,G__40311) : self__.item__GT_priority.call(null,G__40310,G__40311));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(priority,cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var item_set = (self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1 ? self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1(priority_key) : self__.priority__GT_set_of_items.call(null,priority_key));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5751__auto__)){
var current_priority = temp__5751__auto__;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_priority,priority)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var current_priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(current_priority) : self__.keyfn.call(null,current_priority));
var item_set = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),item),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)], 0)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4564__auto__ = (function tailrecursion$priority_map$iter__40312(s__40313){
return (new cljs.core.LazySeq(null,(function (){
var s__40313__$1 = s__40313;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__40313__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__40318 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40318,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40318,(1),null);
var iterys__4560__auto__ = ((function (s__40313__$1,vec__40318,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__40312_$_iter__40314(s__40315){
return (new cljs.core.LazySeq(null,((function (s__40313__$1,vec__40318,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__40315__$1 = s__40315;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__40315__$1);
if(temp__5753__auto____$1){
var s__40315__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__40315__$2)){
var c__4562__auto__ = cljs.core.chunk_first(s__40315__$2);
var size__4563__auto__ = cljs.core.count(c__4562__auto__);
var b__40317 = cljs.core.chunk_buffer(size__4563__auto__);
if((function (){var i__40316 = (0);
while(true){
if((i__40316 < size__4563__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4562__auto__,i__40316);
cljs.core.chunk_append(b__40317,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__40354 = (i__40316 + (1));
i__40316 = G__40354;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40317),tailrecursion$priority_map$iter__40312_$_iter__40314(cljs.core.chunk_rest(s__40315__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40317),null);
}
} else {
var item = cljs.core.first(s__40315__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__40312_$_iter__40314(cljs.core.rest(s__40315__$2)));
}
} else {
return null;
}
break;
}
});})(s__40313__$1,vec__40318,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__40313__$1,vec__40318,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4561__auto__ = cljs.core.seq(iterys__4560__auto__(item_set));
if(fs__4561__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4561__auto__,tailrecursion$priority_map$iter__40312(cljs.core.rest(s__40313__$1)));
} else {
var G__40355 = cljs.core.rest(s__40313__$1);
s__40313__$1 = G__40355;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4564__auto__(self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq((function (){var iter__4564__auto__ = (function tailrecursion$priority_map$iter__40321(s__40322){
return (new cljs.core.LazySeq(null,(function (){
var s__40322__$1 = s__40322;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__40322__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__40327 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40327,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40327,(1),null);
var iterys__4560__auto__ = ((function (s__40322__$1,vec__40327,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__40321_$_iter__40323(s__40324){
return (new cljs.core.LazySeq(null,((function (s__40322__$1,vec__40327,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__40324__$1 = s__40324;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__40324__$1);
if(temp__5753__auto____$1){
var s__40324__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__40324__$2)){
var c__4562__auto__ = cljs.core.chunk_first(s__40324__$2);
var size__4563__auto__ = cljs.core.count(c__4562__auto__);
var b__40326 = cljs.core.chunk_buffer(size__4563__auto__);
if((function (){var i__40325 = (0);
while(true){
if((i__40325 < size__4563__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4562__auto__,i__40325);
cljs.core.chunk_append(b__40326,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__40356 = (i__40325 + (1));
i__40325 = G__40356;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40326),tailrecursion$priority_map$iter__40321_$_iter__40323(cljs.core.chunk_rest(s__40324__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40326),null);
}
} else {
var item = cljs.core.first(s__40324__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__40321_$_iter__40323(cljs.core.rest(s__40324__$2)));
}
} else {
return null;
}
break;
}
});})(s__40322__$1,vec__40327,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__40322__$1,vec__40327,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4561__auto__ = cljs.core.seq(iterys__4560__auto__(item_set));
if(fs__4561__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4561__auto__,tailrecursion$priority_map$iter__40321(cljs.core.rest(s__40322__$1)));
} else {
var G__40357 = cljs.core.rest(s__40322__$1);
s__40322__$1 = G__40357;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4564__auto__(self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return this$__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__40358 = null;
var G__40358__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
});
var G__40358__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
});
G__40358 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__40358__2.call(this,self__,item);
case 3:
return G__40358__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__40358.cljs$core$IFn$_invoke$arity$2 = G__40358__2;
G__40358.cljs$core$IFn$_invoke$arity$3 = G__40358__3;
return G__40358;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args40291){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args40291)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var fexpr__40330 = (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq);
return (fexpr__40330.cljs$core$IFn$_invoke$arity$1 ? fexpr__40330.cljs$core$IFn$_invoke$arity$1(this$__$1) : fexpr__40330.call(null,this$__$1));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4564__auto__ = (function tailrecursion$priority_map$iter__40331(s__40332){
return (new cljs.core.LazySeq(null,(function (){
var s__40332__$1 = s__40332;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__40332__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__40337 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40337,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40337,(1),null);
var iterys__4560__auto__ = ((function (s__40332__$1,vec__40337,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__40331_$_iter__40333(s__40334){
return (new cljs.core.LazySeq(null,((function (s__40332__$1,vec__40337,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__40334__$1 = s__40334;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__40334__$1);
if(temp__5753__auto____$1){
var s__40334__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__40334__$2)){
var c__4562__auto__ = cljs.core.chunk_first(s__40334__$2);
var size__4563__auto__ = cljs.core.count(c__4562__auto__);
var b__40336 = cljs.core.chunk_buffer(size__4563__auto__);
if((function (){var i__40335 = (0);
while(true){
if((i__40335 < size__4563__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4562__auto__,i__40335);
cljs.core.chunk_append(b__40336,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__40359 = (i__40335 + (1));
i__40335 = G__40359;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40336),tailrecursion$priority_map$iter__40331_$_iter__40333(cljs.core.chunk_rest(s__40334__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40336),null);
}
} else {
var item = cljs.core.first(s__40334__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__40331_$_iter__40333(cljs.core.rest(s__40334__$2)));
}
} else {
return null;
}
break;
}
});})(s__40332__$1,vec__40337,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__40332__$1,vec__40337,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4561__auto__ = cljs.core.seq(iterys__4560__auto__(item_set));
if(fs__4561__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4561__auto__,tailrecursion$priority_map$iter__40331(cljs.core.rest(s__40332__$1)));
} else {
var G__40360 = cljs.core.rest(s__40332__$1);
s__40332__$1 = G__40360;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4564__auto__(sets);
})());
} else {
return cljs.core.seq((function (){var iter__4564__auto__ = (function tailrecursion$priority_map$iter__40340(s__40341){
return (new cljs.core.LazySeq(null,(function (){
var s__40341__$1 = s__40341;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__40341__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__40346 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40346,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40346,(1),null);
var iterys__4560__auto__ = ((function (s__40341__$1,vec__40346,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__40340_$_iter__40342(s__40343){
return (new cljs.core.LazySeq(null,((function (s__40341__$1,vec__40346,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__40343__$1 = s__40343;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__40343__$1);
if(temp__5753__auto____$1){
var s__40343__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__40343__$2)){
var c__4562__auto__ = cljs.core.chunk_first(s__40343__$2);
var size__4563__auto__ = cljs.core.count(c__4562__auto__);
var b__40345 = cljs.core.chunk_buffer(size__4563__auto__);
if((function (){var i__40344 = (0);
while(true){
if((i__40344 < size__4563__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4562__auto__,i__40344);
cljs.core.chunk_append(b__40345,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__40361 = (i__40344 + (1));
i__40344 = G__40361;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40345),tailrecursion$priority_map$iter__40340_$_iter__40342(cljs.core.chunk_rest(s__40343__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40345),null);
}
} else {
var item = cljs.core.first(s__40343__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__40340_$_iter__40342(cljs.core.rest(s__40343__$2)));
}
} else {
return null;
}
break;
}
});})(s__40341__$1,vec__40346,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__40341__$1,vec__40346,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4561__auto__ = cljs.core.seq(iterys__4560__auto__(item_set));
if(fs__4561__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4561__auto__,tailrecursion$priority_map$iter__40340(cljs.core.rest(s__40341__$1)));
} else {
var G__40362 = cljs.core.rest(s__40341__$1);
s__40341__$1 = G__40362;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4564__auto__(sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
var G__40349 = cljs.core.val(entry);
return (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(G__40349) : self__.keyfn.call(null,G__40349));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$priority_DASH__GT_set_DASH_of_DASH_items,cljs.core.cst$sym$item_DASH__GT_priority,cljs.core.cst$sym$meta,cljs.core.cst$sym$keyfn,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4404__auto__,writer__4405__auto__,opt__4406__auto__){
return cljs.core._write(writer__4405__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__40364 = arguments.length;
switch (G__40364) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_(elems)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_("tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4777__auto__ = [];
var len__4771__auto___40367 = arguments.length;
var i__4772__auto___40368 = (0);
while(true){
if((i__4772__auto___40368 < len__4771__auto___40367)){
args__4777__auto__.push((arguments[i__4772__auto___40368]));

var G__40369 = (i__4772__auto___40368 + (1));
i__4772__auto___40368 = G__40369;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((0) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4778__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__40370 = cljs.core.nnext(in$);
var G__40371 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__40370;
out = G__40371;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq40366){
var self__4759__auto__ = this;
return self__4759__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40366));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4777__auto__ = [];
var len__4771__auto___40374 = arguments.length;
var i__4772__auto___40375 = (0);
while(true){
if((i__4772__auto___40375 < len__4771__auto___40374)){
args__4777__auto__.push((arguments[i__4772__auto___40375]));

var G__40376 = (i__4772__auto___40375 + (1));
i__4772__auto___40375 = G__40376;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_by(comparator);
while(true){
if(in$){
var G__40377 = cljs.core.nnext(in$);
var G__40378 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__40377;
out = G__40378;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq40372){
var G__40373 = cljs.core.first(seq40372);
var seq40372__$1 = cljs.core.next(seq40372);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__40373,seq40372__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4777__auto__ = [];
var len__4771__auto___40381 = arguments.length;
var i__4772__auto___40382 = (0);
while(true){
if((i__4772__auto___40382 < len__4771__auto___40381)){
args__4777__auto__.push((arguments[i__4772__auto___40382]));

var G__40383 = (i__4772__auto___40382 + (1));
i__4772__auto___40382 = G__40383;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((1) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4778__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1(keyfn);
while(true){
if(in$){
var G__40384 = cljs.core.nnext(in$);
var G__40385 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__40384;
out = G__40385;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq40379){
var G__40380 = cljs.core.first(seq40379);
var seq40379__$1 = cljs.core.next(seq40379);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__40380,seq40379__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4777__auto__ = [];
var len__4771__auto___40389 = arguments.length;
var i__4772__auto___40390 = (0);
while(true){
if((i__4772__auto___40390 < len__4771__auto___40389)){
args__4777__auto__.push((arguments[i__4772__auto___40390]));

var G__40391 = (i__4772__auto___40390 + (1));
i__4772__auto___40390 = G__40391;
continue;
} else {
}
break;
}

var argseq__4778__auto__ = ((((2) < args__4777__auto__.length))?(new cljs.core.IndexedSeq(args__4777__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4778__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2(keyfn,comparator);
while(true){
if(in$){
var G__40392 = cljs.core.nnext(in$);
var G__40393 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__40392;
out = G__40393;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq40386){
var G__40387 = cljs.core.first(seq40386);
var seq40386__$1 = cljs.core.next(seq40386);
var G__40388 = cljs.core.first(seq40386__$1);
var seq40386__$2 = cljs.core.next(seq40386__$1);
var self__4758__auto__ = this;
return self__4758__auto__.cljs$core$IFn$_invoke$arity$variadic(G__40387,G__40388,seq40386__$2);
}));

