// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.auth');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.async');
/**
 * Given an _auth identity, returns associated roles.
 *   First returns roles directly associated with auth ident.
 *   If none exist, attempts to retrieve default roles for associated
 *   user, if they exist.
 */
fluree.db.auth.roles = (function fluree$db$auth$roles(db,auth_id){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_132347){
var state_val_132348 = (state_132347[(1)]);
if((state_val_132348 === (7))){
var inst_132343 = (state_132347[(2)]);
var state_132347__$1 = state_132347;
var statearr_132349_132366 = state_132347__$1;
(statearr_132349_132366[(2)] = inst_132343);


cljs.core.async.impl.ioc_helpers.process_exception(state_132347__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_132348 === (1))){
var state_132347__$1 = state_132347;
var statearr_132350_132367 = state_132347__$1;
(statearr_132350_132367[(2)] = null);

(statearr_132350_132367[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132348 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_132347,(3),Error,null,(2));
var inst_132304 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),auth_id);
var state_132347__$1 = state_132347;
if(inst_132304){
var statearr_132351_132368 = state_132347__$1;
(statearr_132351_132368[(1)] = (5));

} else {
var statearr_132352_132369 = state_132347__$1;
(statearr_132352_132369[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132348 === (6))){
var inst_132308 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_132309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132310 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132311 = [auth_id,"_auth/roles","?roles"];
var inst_132312 = (new cljs.core.PersistentVector(null,3,(5),inst_132310,inst_132311,null));
var inst_132313 = [inst_132312];
var inst_132314 = (new cljs.core.PersistentVector(null,1,(5),inst_132309,inst_132313,null));
var inst_132315 = ["?roles",inst_132314];
var inst_132316 = cljs.core.PersistentHashMap.fromArrays(inst_132308,inst_132315);
var inst_132317 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_132316);
var inst_132318 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_132319 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132320 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132321 = ["?user","_user/auth",auth_id];
var inst_132322 = (new cljs.core.PersistentVector(null,3,(5),inst_132320,inst_132321,null));
var inst_132323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132324 = ["?user","_user/roles","?roles"];
var inst_132325 = (new cljs.core.PersistentVector(null,3,(5),inst_132323,inst_132324,null));
var inst_132326 = [inst_132322,inst_132325];
var inst_132327 = (new cljs.core.PersistentVector(null,2,(5),inst_132319,inst_132326,null));
var inst_132328 = ["?roles",inst_132327];
var inst_132329 = cljs.core.PersistentHashMap.fromArrays(inst_132318,inst_132328);
var inst_132330 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_132329);
var state_132347__$1 = (function (){var statearr_132353 = state_132347;
(statearr_132353[(7)] = inst_132330);

return statearr_132353;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_132347__$1,(8),inst_132317);
} else {
if((state_val_132348 === (3))){
var inst_132300 = (state_132347[(2)]);
var state_132347__$1 = state_132347;
var statearr_132354_132370 = state_132347__$1;
(statearr_132354_132370[(2)] = inst_132300);


cljs.core.async.impl.ioc_helpers.process_exception(state_132347__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_132348 === (12))){
var inst_132338 = (state_132347[(2)]);
var inst_132339 = fluree.db.util.async.throw_err(inst_132338);
var state_132347__$1 = state_132347;
var statearr_132355_132371 = state_132347__$1;
(statearr_132355_132371[(2)] = inst_132339);

(statearr_132355_132371[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132348 === (2))){
var inst_132345 = (state_132347[(2)]);
var state_132347__$1 = state_132347;
return cljs.core.async.impl.ioc_helpers.return_chan(state_132347__$1,inst_132345);
} else {
if((state_val_132348 === (11))){
var inst_132341 = (state_132347[(2)]);
var state_132347__$1 = state_132347;
var statearr_132356_132372 = state_132347__$1;
(statearr_132356_132372[(2)] = inst_132341);

(statearr_132356_132372[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132348 === (9))){
var inst_132334 = (state_132347[(8)]);
var state_132347__$1 = state_132347;
var statearr_132357_132373 = state_132347__$1;
(statearr_132357_132373[(2)] = inst_132334);

(statearr_132357_132373[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132348 === (5))){
var inst_132306 = cljs.core.PersistentVector.EMPTY;
var state_132347__$1 = state_132347;
var statearr_132358_132374 = state_132347__$1;
(statearr_132358_132374[(2)] = inst_132306);

(statearr_132358_132374[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132348 === (10))){
var inst_132330 = (state_132347[(7)]);
var state_132347__$1 = state_132347;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_132347__$1,(12),inst_132330);
} else {
if((state_val_132348 === (8))){
var inst_132334 = (state_132347[(8)]);
var inst_132332 = (state_132347[(2)]);
var inst_132333 = fluree.db.util.async.throw_err(inst_132332);
var inst_132334__$1 = cljs.core.not_empty(inst_132333);
var state_132347__$1 = (function (){var statearr_132359 = state_132347;
(statearr_132359[(8)] = inst_132334__$1);

return statearr_132359;
})();
if(cljs.core.truth_(inst_132334__$1)){
var statearr_132360_132375 = state_132347__$1;
(statearr_132360_132375[(1)] = (9));

} else {
var statearr_132361_132376 = state_132347__$1;
(statearr_132361_132376[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$auth$roles_$_state_machine__109971__auto__ = null;
var fluree$db$auth$roles_$_state_machine__109971__auto____0 = (function (){
var statearr_132362 = [null,null,null,null,null,null,null,null,null];
(statearr_132362[(0)] = fluree$db$auth$roles_$_state_machine__109971__auto__);

(statearr_132362[(1)] = (1));

return statearr_132362;
});
var fluree$db$auth$roles_$_state_machine__109971__auto____1 = (function (state_132347){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_132347);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e132363){if((e132363 instanceof Object)){
var ex__109974__auto__ = e132363;
var statearr_132364_132377 = state_132347;
(statearr_132364_132377[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_132347);

return cljs.core.cst$kw$recur;
} else {
throw e132363;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__132378 = state_132347;
state_132347 = G__132378;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$auth$roles_$_state_machine__109971__auto__ = function(state_132347){
switch(arguments.length){
case 0:
return fluree$db$auth$roles_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$auth$roles_$_state_machine__109971__auto____1.call(this,state_132347);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$auth$roles_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$auth$roles_$_state_machine__109971__auto____0;
fluree$db$auth$roles_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$auth$roles_$_state_machine__109971__auto____1;
return fluree$db$auth$roles_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_132365 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_132365[(6)] = c__110077__auto__);

return statearr_132365;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Given an _auth identity, returns roles directly associated
 *   with the auth ident.  If none found, attempts to retrieve
 *   default roles for an associated user.
 */
fluree.db.auth.root_role_QMARK_ = (function fluree$db$auth$root_role_QMARK_(db,auth_id){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_132477){
var state_val_132478 = (state_132477[(1)]);
if((state_val_132478 === (7))){
var inst_132473 = (state_132477[(2)]);
var state_132477__$1 = state_132477;
var statearr_132479_132505 = state_132477__$1;
(statearr_132479_132505[(2)] = inst_132473);


cljs.core.async.impl.ioc_helpers.process_exception(state_132477__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_132478 === (1))){
var state_132477__$1 = state_132477;
var statearr_132480_132506 = state_132477__$1;
(statearr_132480_132506[(2)] = null);

(statearr_132480_132506[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132478 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_132477,(3),Error,null,(2));
var inst_132383 = (auth_id == null);
var state_132477__$1 = state_132477;
if(cljs.core.truth_(inst_132383)){
var statearr_132481_132507 = state_132477__$1;
(statearr_132481_132507[(1)] = (5));

} else {
var statearr_132482_132508 = state_132477__$1;
(statearr_132482_132508[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132478 === (15))){
var inst_132463 = (state_132477[(7)]);
var state_132477__$1 = state_132477;
var statearr_132483_132509 = state_132477__$1;
(statearr_132483_132509[(2)] = inst_132463);

(statearr_132483_132509[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132478 === (13))){
var inst_132419 = (state_132477[(8)]);
var inst_132459 = (state_132477[(2)]);
var state_132477__$1 = (function (){var statearr_132484 = state_132477;
(statearr_132484[(9)] = inst_132459);

return statearr_132484;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_132477__$1,(14),inst_132419);
} else {
if((state_val_132478 === (6))){
var inst_132386 = typeof auth_id === 'number';
var state_132477__$1 = state_132477;
if(cljs.core.truth_(inst_132386)){
var statearr_132485_132510 = state_132477__$1;
(statearr_132485_132510[(1)] = (8));

} else {
var statearr_132486_132511 = state_132477__$1;
(statearr_132486_132511[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132478 === (17))){
var inst_132471 = (state_132477[(2)]);
var state_132477__$1 = state_132477;
var statearr_132487_132512 = state_132477__$1;
(statearr_132487_132512[(2)] = inst_132471);

(statearr_132487_132512[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132478 === (3))){
var inst_132379 = (state_132477[(2)]);
var state_132477__$1 = state_132477;
var statearr_132488_132513 = state_132477__$1;
(statearr_132488_132513[(2)] = inst_132379);


cljs.core.async.impl.ioc_helpers.process_exception(state_132477__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_132478 === (12))){
var inst_132439 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_132440 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132441 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132442 = ["?role","_role/id","root"];
var inst_132443 = (new cljs.core.PersistentVector(null,3,(5),inst_132441,inst_132442,null));
var inst_132444 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132445 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132446 = ["_auth/id",auth_id];
var inst_132447 = (new cljs.core.PersistentVector(null,2,(5),inst_132445,inst_132446,null));
var inst_132448 = ["?user","_user/auth",inst_132447];
var inst_132449 = (new cljs.core.PersistentVector(null,3,(5),inst_132444,inst_132448,null));
var inst_132450 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132451 = ["?user","_user/roles","?roles"];
var inst_132452 = (new cljs.core.PersistentVector(null,3,(5),inst_132450,inst_132451,null));
var inst_132453 = [inst_132443,inst_132449,inst_132452];
var inst_132454 = (new cljs.core.PersistentVector(null,3,(5),inst_132440,inst_132453,null));
var inst_132455 = ["?role",inst_132454];
var inst_132456 = cljs.core.PersistentHashMap.fromArrays(inst_132439,inst_132455);
var inst_132457 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_132456);
var state_132477__$1 = state_132477;
var statearr_132489_132514 = state_132477__$1;
(statearr_132489_132514[(2)] = inst_132457);

(statearr_132489_132514[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132478 === (2))){
var inst_132475 = (state_132477[(2)]);
var state_132477__$1 = state_132477;
return cljs.core.async.impl.ioc_helpers.return_chan(state_132477__$1,inst_132475);
} else {
if((state_val_132478 === (11))){
var inst_132422 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_132423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132425 = ["?role","_role/id","root"];
var inst_132426 = (new cljs.core.PersistentVector(null,3,(5),inst_132424,inst_132425,null));
var inst_132427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132428 = ["?user","_user/auth",auth_id];
var inst_132429 = (new cljs.core.PersistentVector(null,3,(5),inst_132427,inst_132428,null));
var inst_132430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132431 = ["?user","_user/roles","?roles"];
var inst_132432 = (new cljs.core.PersistentVector(null,3,(5),inst_132430,inst_132431,null));
var inst_132433 = [inst_132426,inst_132429,inst_132432];
var inst_132434 = (new cljs.core.PersistentVector(null,3,(5),inst_132423,inst_132433,null));
var inst_132435 = ["?role",inst_132434];
var inst_132436 = cljs.core.PersistentHashMap.fromArrays(inst_132422,inst_132435);
var inst_132437 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_132436);
var state_132477__$1 = state_132477;
var statearr_132490_132515 = state_132477__$1;
(statearr_132490_132515[(2)] = inst_132437);

(statearr_132490_132515[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132478 === (9))){
var inst_132402 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_132403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132404 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132405 = ["?role","_role/id","root"];
var inst_132406 = (new cljs.core.PersistentVector(null,3,(5),inst_132404,inst_132405,null));
var inst_132407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132408 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132409 = ["_auth/id",auth_id];
var inst_132410 = (new cljs.core.PersistentVector(null,2,(5),inst_132408,inst_132409,null));
var inst_132411 = [inst_132410,"_auth/roles","?role"];
var inst_132412 = (new cljs.core.PersistentVector(null,3,(5),inst_132407,inst_132411,null));
var inst_132413 = [inst_132406,inst_132412];
var inst_132414 = (new cljs.core.PersistentVector(null,2,(5),inst_132403,inst_132413,null));
var inst_132415 = ["?role",inst_132414];
var inst_132416 = cljs.core.PersistentHashMap.fromArrays(inst_132402,inst_132415);
var inst_132417 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_132416);
var state_132477__$1 = state_132477;
var statearr_132491_132516 = state_132477__$1;
(statearr_132491_132516[(2)] = inst_132417);

(statearr_132491_132516[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132478 === (5))){
var state_132477__$1 = state_132477;
var statearr_132492_132517 = state_132477__$1;
(statearr_132492_132517[(2)] = false);

(statearr_132492_132517[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132478 === (14))){
var inst_132463 = (state_132477[(7)]);
var inst_132461 = (state_132477[(2)]);
var inst_132462 = fluree.db.util.async.throw_err(inst_132461);
var inst_132463__$1 = cljs.core.not_empty(inst_132462);
var state_132477__$1 = (function (){var statearr_132493 = state_132477;
(statearr_132493[(7)] = inst_132463__$1);

return statearr_132493;
})();
if(cljs.core.truth_(inst_132463__$1)){
var statearr_132494_132518 = state_132477__$1;
(statearr_132494_132518[(1)] = (15));

} else {
var statearr_132495_132519 = state_132477__$1;
(statearr_132495_132519[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132478 === (16))){
var inst_132459 = (state_132477[(9)]);
var state_132477__$1 = state_132477;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_132477__$1,(18),inst_132459);
} else {
if((state_val_132478 === (10))){
var inst_132419 = (state_132477[(2)]);
var inst_132420 = typeof auth_id === 'number';
var state_132477__$1 = (function (){var statearr_132496 = state_132477;
(statearr_132496[(8)] = inst_132419);

return statearr_132496;
})();
if(cljs.core.truth_(inst_132420)){
var statearr_132497_132520 = state_132477__$1;
(statearr_132497_132520[(1)] = (11));

} else {
var statearr_132498_132521 = state_132477__$1;
(statearr_132498_132521[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132478 === (18))){
var inst_132467 = (state_132477[(2)]);
var inst_132468 = fluree.db.util.async.throw_err(inst_132467);
var inst_132469 = cljs.core.not_empty(inst_132468);
var state_132477__$1 = state_132477;
var statearr_132499_132522 = state_132477__$1;
(statearr_132499_132522[(2)] = inst_132469);

(statearr_132499_132522[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132478 === (8))){
var inst_132388 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_132389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132391 = ["?role","_role/id","root"];
var inst_132392 = (new cljs.core.PersistentVector(null,3,(5),inst_132390,inst_132391,null));
var inst_132393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132394 = [auth_id,"_auth/roles","?role"];
var inst_132395 = (new cljs.core.PersistentVector(null,3,(5),inst_132393,inst_132394,null));
var inst_132396 = [inst_132392,inst_132395];
var inst_132397 = (new cljs.core.PersistentVector(null,2,(5),inst_132389,inst_132396,null));
var inst_132398 = ["?role",inst_132397];
var inst_132399 = cljs.core.PersistentHashMap.fromArrays(inst_132388,inst_132398);
var inst_132400 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_132399);
var state_132477__$1 = state_132477;
var statearr_132500_132523 = state_132477__$1;
(statearr_132500_132523[(2)] = inst_132400);

(statearr_132500_132523[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$auth$root_role_QMARK__$_state_machine__109971__auto__ = null;
var fluree$db$auth$root_role_QMARK__$_state_machine__109971__auto____0 = (function (){
var statearr_132501 = [null,null,null,null,null,null,null,null,null,null];
(statearr_132501[(0)] = fluree$db$auth$root_role_QMARK__$_state_machine__109971__auto__);

(statearr_132501[(1)] = (1));

return statearr_132501;
});
var fluree$db$auth$root_role_QMARK__$_state_machine__109971__auto____1 = (function (state_132477){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_132477);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e132502){if((e132502 instanceof Object)){
var ex__109974__auto__ = e132502;
var statearr_132503_132524 = state_132477;
(statearr_132503_132524[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_132477);

return cljs.core.cst$kw$recur;
} else {
throw e132502;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__132525 = state_132477;
state_132477 = G__132525;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$auth$root_role_QMARK__$_state_machine__109971__auto__ = function(state_132477){
switch(arguments.length){
case 0:
return fluree$db$auth$root_role_QMARK__$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$auth$root_role_QMARK__$_state_machine__109971__auto____1.call(this,state_132477);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$auth$root_role_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$auth$root_role_QMARK__$_state_machine__109971__auto____0;
fluree$db$auth$root_role_QMARK__$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$auth$root_role_QMARK__$_state_machine__109971__auto____1;
return fluree$db$auth$root_role_QMARK__$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_132504 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_132504[(6)] = c__110077__auto__);

return statearr_132504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
