// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__117247 = arguments.length;
switch (G__117247) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
});

fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$op,operation,cljs.core.cst$kw$req_DASH_id,req_id,cljs.core.cst$kw$timestamp,fluree.db.util.core.current_time_millis(),cljs.core.cst$kw$timeout,timeout], null);
return header;
});

fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3;

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__117250 = arguments.length;
switch (G__117250) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
});

fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__110077__auto___117293 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto___117293,pc){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto___117293,pc){
return (function (state_117278){
var state_val_117279 = (state_117278[(1)]);
if((state_val_117279 === (1))){
var state_117278__$1 = state_117278;
var statearr_117280_117294 = state_117278__$1;
(statearr_117280_117294[(2)] = null);

(statearr_117280_117294[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117279 === (2))){
var inst_117276 = (state_117278[(2)]);
var state_117278__$1 = state_117278;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117278__$1,inst_117276);
} else {
if((state_val_117279 === (3))){
var inst_117251 = (state_117278[(2)]);
var inst_117252 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_117251);
var state_117278__$1 = state_117278;
var statearr_117281_117295 = state_117278__$1;
(statearr_117281_117295[(2)] = inst_117252);


cljs.core.async.impl.ioc_helpers.process_exception(state_117278__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_117279 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_117278,(3),java.lang.Exception,null,(2));
var inst_117256 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_117278__$1 = state_117278;
if(cljs.core.truth_(inst_117256)){
var statearr_117282_117296 = state_117278__$1;
(statearr_117282_117296[(1)] = (5));

} else {
var statearr_117283_117297 = state_117278__$1;
(statearr_117283_117297[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117279 === (5))){
var inst_117258 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_117259 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_connection];
var inst_117260 = cljs.core.PersistentHashMap.fromArrays(inst_117258,inst_117259);
var inst_117261 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_117260);
var inst_117262 = (function(){throw inst_117261})();
var state_117278__$1 = state_117278;
var statearr_117284_117298 = state_117278__$1;
(statearr_117284_117298[(2)] = inst_117262);

(statearr_117284_117298[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117279 === (6))){
var inst_117264 = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_117265 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_117266 = [operation,data,pc,opts];
var inst_117267 = (new cljs.core.PersistentVector(null,4,(5),inst_117265,inst_117266,null));
var inst_117268 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_117264,inst_117267);
var inst_117269 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_117270 = [operation,data,pc,opts];
var inst_117271 = (new cljs.core.PersistentVector(null,4,(5),inst_117269,inst_117270,null));
var inst_117272 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_117271], 0));
var state_117278__$1 = (function (){var statearr_117285 = state_117278;
(statearr_117285[(7)] = inst_117268);

return statearr_117285;
})();
var statearr_117286_117299 = state_117278__$1;
(statearr_117286_117299[(2)] = inst_117272);

(statearr_117286_117299[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117279 === (7))){
var inst_117274 = (state_117278[(2)]);
var state_117278__$1 = state_117278;
var statearr_117287_117300 = state_117278__$1;
(statearr_117287_117300[(2)] = inst_117274);


cljs.core.async.impl.ioc_helpers.process_exception(state_117278__$1);

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__110077__auto___117293,pc))
;
return ((function (switch__109970__auto__,c__110077__auto___117293,pc){
return (function() {
var fluree$db$operations$state_machine__109971__auto__ = null;
var fluree$db$operations$state_machine__109971__auto____0 = (function (){
var statearr_117288 = [null,null,null,null,null,null,null,null];
(statearr_117288[(0)] = fluree$db$operations$state_machine__109971__auto__);

(statearr_117288[(1)] = (1));

return statearr_117288;
});
var fluree$db$operations$state_machine__109971__auto____1 = (function (state_117278){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_117278);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e117289){if((e117289 instanceof Object)){
var ex__109974__auto__ = e117289;
var statearr_117290_117301 = state_117278;
(statearr_117290_117301[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117278);

return cljs.core.cst$kw$recur;
} else {
throw e117289;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__117302 = state_117278;
state_117278 = G__117302;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$operations$state_machine__109971__auto__ = function(state_117278){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__109971__auto____1.call(this,state_117278);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__109971__auto____0;
fluree$db$operations$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__109971__auto____1;
return fluree$db$operations$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto___117293,pc))
})();
var state__110079__auto__ = (function (){var statearr_117291 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_117291[(6)] = c__110077__auto___117293);

return statearr_117291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto___117293,pc))
);


return pc;
});

fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4;

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__117304 = arguments.length;
switch (G__117304) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
});

fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__117305){
var map__117306 = p__117305;
var map__117306__$1 = (((((!((map__117306 == null))))?(((((map__117306.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__117306.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__117306):map__117306);
var opts = map__117306__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__117306__$1,cljs.core.cst$kw$snapshot_QMARK_);
var map__117308 = session;
var map__117308__$1 = (((((!((map__117308 == null))))?(((((map__117308.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__117308.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__117308):map__117308);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__117308__$1,cljs.core.cst$kw$dbid);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__117308__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__117308__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$delete_DASH_db,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$snapshot_QMARK_,snapshot_QMARK_], null));
});

fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2;

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4736__auto__ = [];
var len__4730__auto___117367 = arguments.length;
var i__4731__auto___117368 = (0);
while(true){
if((i__4731__auto___117368 < len__4730__auto___117367)){
args__4736__auto__.push((arguments[i__4731__auto___117368]));

var G__117369 = (i__4731__auto___117368 + (1));
i__4731__auto___117368 = G__117369;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__117313){
var vec__117314 = p__117313;
var map__117317 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__117314,(0),null);
var map__117317__$1 = (((((!((map__117317 == null))))?(((((map__117317.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__117317.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__117317):map__117317);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__117317__$1,cljs.core.cst$kw$toBlock);
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__117317__$1,cljs.core.cst$kw$toTime);
var opts = vec__117314;
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__,vec__117314,map__117317,map__117317__$1,toBlock,toTime,opts){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__,vec__117314,map__117317,map__117317__$1,toBlock,toTime,opts){
return (function (state_117349){
var state_val_117350 = (state_117349[(1)]);
if((state_val_117350 === (7))){
var inst_117332 = (state_117349[(2)]);
var state_117349__$1 = state_117349;
var statearr_117351_117370 = state_117349__$1;
(statearr_117351_117370[(2)] = inst_117332);

(statearr_117351_117370[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (1))){
var inst_117321 = (session == null);
var inst_117322 = cljs.core.not(inst_117321);
var state_117349__$1 = state_117349;
if(inst_117322){
var statearr_117352_117371 = state_117349__$1;
(statearr_117352_117371[(1)] = (2));

} else {
var statearr_117353_117372 = state_117349__$1;
(statearr_117353_117372[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (4))){
var inst_117335 = (state_117349[(2)]);
var state_117349__$1 = state_117349;
if(cljs.core.truth_(inst_117335)){
var statearr_117354_117373 = state_117349__$1;
(statearr_117354_117373[(1)] = (8));

} else {
var statearr_117355_117374 = state_117349__$1;
(statearr_117355_117374[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (6))){
var state_117349__$1 = state_117349;
var statearr_117356_117375 = state_117349__$1;
(statearr_117356_117375[(2)] = false);

(statearr_117356_117375[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (3))){
var state_117349__$1 = state_117349;
var statearr_117357_117376 = state_117349__$1;
(statearr_117357_117376[(2)] = false);

(statearr_117357_117376[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (2))){
var inst_117324 = session.cljs$lang$protocol_mask$partition0$;
var inst_117325 = (inst_117324 & (64));
var inst_117326 = session.cljs$core$ISeq$;
var inst_117327 = (cljs.core.PROTOCOL_SENTINEL === inst_117326);
var inst_117328 = ((inst_117325) || (inst_117327));
var state_117349__$1 = state_117349;
if(cljs.core.truth_(inst_117328)){
var statearr_117358_117377 = state_117349__$1;
(statearr_117358_117377[(1)] = (5));

} else {
var statearr_117359_117378 = state_117349__$1;
(statearr_117359_117378[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (9))){
var state_117349__$1 = state_117349;
var statearr_117360_117379 = state_117349__$1;
(statearr_117360_117379[(2)] = session);

(statearr_117360_117379[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (5))){
var state_117349__$1 = state_117349;
var statearr_117361_117380 = state_117349__$1;
(statearr_117361_117380[(2)] = true);

(statearr_117361_117380[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_117350 === (10))){
var inst_117340 = (state_117349[(2)]);
var inst_117341 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_117340,cljs.core.cst$kw$network);
var inst_117342 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_117340,cljs.core.cst$kw$dbid);
var inst_117343 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_117340,cljs.core.cst$kw$conn);
var inst_117344 = [cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$toBlock,cljs.core.cst$kw$toTime];
var inst_117345 = [inst_117341,inst_117342,toBlock,toTime];
var inst_117346 = cljs.core.PersistentHashMap.fromArrays(inst_117344,inst_117345);
var inst_117347 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_117343,cljs.core.cst$kw$garbage,inst_117346);
var state_117349__$1 = state_117349;
return cljs.core.async.impl.ioc_helpers.return_chan(state_117349__$1,inst_117347);
} else {
if((state_val_117350 === (8))){
var inst_117337 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,session);
var state_117349__$1 = state_117349;
var statearr_117362_117381 = state_117349__$1;
(statearr_117362_117381[(2)] = inst_117337);

(statearr_117362_117381[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__,vec__117314,map__117317,map__117317__$1,toBlock,toTime,opts))
;
return ((function (switch__109970__auto__,c__110077__auto__,vec__117314,map__117317,map__117317__$1,toBlock,toTime,opts){
return (function() {
var fluree$db$operations$state_machine__109971__auto__ = null;
var fluree$db$operations$state_machine__109971__auto____0 = (function (){
var statearr_117363 = [null,null,null,null,null,null,null];
(statearr_117363[(0)] = fluree$db$operations$state_machine__109971__auto__);

(statearr_117363[(1)] = (1));

return statearr_117363;
});
var fluree$db$operations$state_machine__109971__auto____1 = (function (state_117349){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_117349);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e117364){if((e117364 instanceof Object)){
var ex__109974__auto__ = e117364;
var statearr_117365_117382 = state_117349;
(statearr_117365_117382[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_117349);

return cljs.core.cst$kw$recur;
} else {
throw e117364;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__117383 = state_117349;
state_117349 = G__117383;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$operations$state_machine__109971__auto__ = function(state_117349){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__109971__auto____1.call(this,state_117349);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__109971__auto____0;
fluree$db$operations$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__109971__auto____1;
return fluree$db$operations$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__,vec__117314,map__117317,map__117317__$1,toBlock,toTime,opts))
})();
var state__110079__auto__ = (function (){var statearr_117366 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_117366[(6)] = c__110077__auto__);

return statearr_117366;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__,vec__117314,map__117317,map__117317__$1,toBlock,toTime,opts))
);

return c__110077__auto__;
});

fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq117311){
var G__117312 = cljs.core.first(seq117311);
var seq117311__$1 = cljs.core.next(seq117311);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__117312,seq117311__$1);
});

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__117384 = session;
var map__117384__$1 = (((((!((map__117384 == null))))?(((((map__117384.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__117384.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__117384):map__117384);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__117384__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__117384__$1,cljs.core.cst$kw$dbid);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__117384__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$snapshot_DASH_db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$cmd,cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsigned_DASH_cmd,unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_stats,ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$db_DASH_list,null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$tx,tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__117387 = arguments.length;
switch (G__117387) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
});

fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__117388 = opts;
var map__117388__$1 = (((((!((map__117388 == null))))?(((((map__117388.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__117388.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__117388):map__117388);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__117388__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__117388__$1,cljs.core.cst$kw$jwt);
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4131__auto__ = auth;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$subscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
});

fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2;

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsbuscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null));
});
