// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.permissions');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
fluree.db.permissions.rule_fn_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,(300)], 0)));
fluree.db.permissions.parse_fn = (function fluree$db$permissions$parse_fn(var_args){
var G__131470 = arguments.length;
switch (G__131470) {
case 2:
return fluree.db.permissions.parse_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.permissions.parse_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.permissions.parse_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_str){
return fluree.db.permissions.parse_fn.cljs$core$IFn$_invoke$arity$3(db,fn_str,null);
});

fluree.db.permissions.parse_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,params){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_131518){
var state_val_131519 = (state_131518[(1)]);
if((state_val_131519 === (7))){
var inst_131514 = (state_131518[(2)]);
var state_131518__$1 = state_131518;
var statearr_131520_131550 = state_131518__$1;
(statearr_131520_131550[(2)] = inst_131514);


cljs.core.async.impl.ioc_helpers.process_exception(state_131518__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_131519 === (20))){
var inst_131506 = (state_131518[(2)]);
var state_131518__$1 = state_131518;
var statearr_131521_131551 = state_131518__$1;
(statearr_131521_131551[(2)] = inst_131506);

(statearr_131521_131551[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131519 === (1))){
var state_131518__$1 = state_131518;
var statearr_131522_131552 = state_131518__$1;
(statearr_131522_131552[(2)] = null);

(statearr_131522_131552[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131519 === (4))){
var inst_131476 = (state_131518[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_131518,(3),Error,null,(2));
var inst_131475 = cljs.core.deref(fluree.db.permissions.rule_fn_cache);
var inst_131476__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_131475,fn_str);
var state_131518__$1 = (function (){var statearr_131523 = state_131518;
(statearr_131523[(7)] = inst_131476__$1);

return statearr_131523;
})();
if(cljs.core.truth_(inst_131476__$1)){
var statearr_131524_131553 = state_131518__$1;
(statearr_131524_131553[(1)] = (5));

} else {
var statearr_131525_131554 = state_131518__$1;
(statearr_131525_131554[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131519 === (15))){
var state_131518__$1 = state_131518;
var statearr_131526_131555 = state_131518__$1;
(statearr_131526_131555[(1)] = (18));



return cljs.core.cst$kw$recur;
} else {
if((state_val_131519 === (13))){
var inst_131510 = (state_131518[(2)]);
var state_131518__$1 = state_131518;
var statearr_131528_131556 = state_131518__$1;
(statearr_131528_131556[(2)] = inst_131510);

(statearr_131528_131556[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131519 === (6))){
var inst_131479 = fn_str === true;
var inst_131480 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("true",fn_str);
var inst_131481 = ((inst_131479) || (inst_131480));
var state_131518__$1 = state_131518;
if(cljs.core.truth_(inst_131481)){
var statearr_131529_131557 = state_131518__$1;
(statearr_131529_131557[(1)] = (8));

} else {
var statearr_131530_131558 = state_131518__$1;
(statearr_131530_131558[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131519 === (17))){
var inst_131493 = (state_131518[(2)]);
var inst_131494 = fluree.db.util.async.throw_err(inst_131493);
var inst_131495 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.permissions.rule_fn_cache,cljs.core.assoc,fn_str,inst_131494);
var state_131518__$1 = (function (){var statearr_131531 = state_131518;
(statearr_131531[(8)] = inst_131495);

return statearr_131531;
})();
var statearr_131532_131559 = state_131518__$1;
(statearr_131532_131559[(2)] = inst_131494);

(statearr_131532_131559[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131519 === (3))){
var inst_131471 = (state_131518[(2)]);
var state_131518__$1 = state_131518;
var statearr_131533_131560 = state_131518__$1;
(statearr_131533_131560[(2)] = inst_131471);


cljs.core.async.impl.ioc_helpers.process_exception(state_131518__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_131519 === (12))){
var inst_131489 = cljs.core.re_matches(/^\(.+\)$/,fn_str);
var state_131518__$1 = state_131518;
if(cljs.core.truth_(inst_131489)){
var statearr_131534_131561 = state_131518__$1;
(statearr_131534_131561[(1)] = (14));

} else {
var statearr_131535_131562 = state_131518__$1;
(statearr_131535_131562[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131519 === (2))){
var inst_131516 = (state_131518[(2)]);
var state_131518__$1 = state_131518;
return cljs.core.async.impl.ioc_helpers.return_chan(state_131518__$1,inst_131516);
} else {
if((state_val_131519 === (19))){
var state_131518__$1 = state_131518;
var statearr_131536_131563 = state_131518__$1;
(statearr_131536_131563[(2)] = null);

(statearr_131536_131563[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131519 === (11))){
var state_131518__$1 = state_131518;
var statearr_131537_131564 = state_131518__$1;
(statearr_131537_131564[(2)] = false);

(statearr_131537_131564[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131519 === (9))){
var inst_131484 = fn_str === false;
var inst_131485 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("false",fn_str);
var inst_131486 = ((inst_131484) || (inst_131485));
var state_131518__$1 = state_131518;
if(cljs.core.truth_(inst_131486)){
var statearr_131538_131565 = state_131518__$1;
(statearr_131538_131565[(1)] = (11));

} else {
var statearr_131539_131566 = state_131518__$1;
(statearr_131539_131566[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131519 === (5))){
var inst_131476 = (state_131518[(7)]);
var state_131518__$1 = state_131518;
var statearr_131540_131567 = state_131518__$1;
(statearr_131540_131567[(2)] = inst_131476);

(statearr_131540_131567[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131519 === (14))){
var inst_131491 = fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,"functionDec",params);
var state_131518__$1 = state_131518;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_131518__$1,(17),inst_131491);
} else {
if((state_val_131519 === (16))){
var inst_131508 = (state_131518[(2)]);
var state_131518__$1 = state_131518;
var statearr_131541_131568 = state_131518__$1;
(statearr_131541_131568[(2)] = inst_131508);

(statearr_131541_131568[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131519 === (10))){
var inst_131512 = (state_131518[(2)]);
var state_131518__$1 = state_131518;
var statearr_131542_131569 = state_131518__$1;
(statearr_131542_131569[(2)] = inst_131512);

(statearr_131542_131569[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131519 === (18))){
var inst_131498 = ["Invalid rule function provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join('');
var inst_131499 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_131500 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_131501 = cljs.core.PersistentHashMap.fromArrays(inst_131499,inst_131500);
var inst_131502 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_131498,inst_131501);
var inst_131503 = (function(){throw inst_131502})();
var state_131518__$1 = state_131518;
var statearr_131543_131570 = state_131518__$1;
(statearr_131543_131570[(2)] = inst_131503);

(statearr_131543_131570[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131519 === (8))){
var state_131518__$1 = state_131518;
var statearr_131544_131571 = state_131518__$1;
(statearr_131544_131571[(2)] = true);

(statearr_131544_131571[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$permissions$state_machine__109971__auto__ = null;
var fluree$db$permissions$state_machine__109971__auto____0 = (function (){
var statearr_131545 = [null,null,null,null,null,null,null,null,null];
(statearr_131545[(0)] = fluree$db$permissions$state_machine__109971__auto__);

(statearr_131545[(1)] = (1));

return statearr_131545;
});
var fluree$db$permissions$state_machine__109971__auto____1 = (function (state_131518){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_131518);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e131546){if((e131546 instanceof Object)){
var ex__109974__auto__ = e131546;
var statearr_131547_131572 = state_131518;
(statearr_131547_131572[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_131518);

return cljs.core.cst$kw$recur;
} else {
throw e131546;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__131573 = state_131518;
state_131518 = G__131573;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$permissions$state_machine__109971__auto__ = function(state_131518){
switch(arguments.length){
case 0:
return fluree$db$permissions$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$permissions$state_machine__109971__auto____1.call(this,state_131518);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$permissions$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$permissions$state_machine__109971__auto____0;
fluree$db$permissions$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$permissions$state_machine__109971__auto____1;
return fluree$db$permissions$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_131548 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_131548[(6)] = c__110077__auto__);

return statearr_131548;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.permissions.parse_fn.cljs$lang$maxFixedArity = 3;

/**
 * Determine which collections, predicates, and operations this rule applies to. Then fetch all function refs
 *   from _rule/fns, and apply to all relevant 
 */
fluree.db.permissions.parse_rules = (function fluree$db$permissions$parse_rules(db,rule){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_131785){
var state_val_131786 = (state_131785[(1)]);
if((state_val_131786 === (65))){
var inst_131671 = (state_131785[(7)]);
var inst_131686 = (state_131785[(8)]);
var inst_131746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_131747 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_131748 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_131749 = [cljs.core.cst$kw$collection,inst_131686,cljs.core.cst$kw$default];
var inst_131750 = (new cljs.core.PersistentVector(null,3,(5),inst_131748,inst_131749,null));
var inst_131751 = [inst_131750,inst_131671];
var inst_131752 = (new cljs.core.PersistentVector(null,2,(5),inst_131747,inst_131751,null));
var inst_131753 = [inst_131752];
var inst_131754 = (new cljs.core.PersistentVector(null,1,(5),inst_131746,inst_131753,null));
var state_131785__$1 = state_131785;
var statearr_131787_131892 = state_131785__$1;
(statearr_131787_131892[(2)] = inst_131754);

(statearr_131787_131892[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (70))){
var inst_131773 = (state_131785[(2)]);
var state_131785__$1 = state_131785;
var statearr_131788_131893 = state_131785__$1;
(statearr_131788_131893[(2)] = inst_131773);

(statearr_131788_131893[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (62))){
var inst_131587 = (state_131785[(9)]);
var state_131785__$1 = state_131785;
if(cljs.core.truth_(inst_131587)){
var statearr_131789_131894 = state_131785__$1;
(statearr_131789_131894[(1)] = (65));

} else {
var statearr_131790_131895 = state_131785__$1;
(statearr_131790_131895[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (7))){
var inst_131601 = (state_131785[(10)]);
var inst_131602 = (state_131785[(11)]);
var inst_131612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_131613 = [inst_131601,inst_131602];
var inst_131614 = (new cljs.core.PersistentVector(null,2,(5),inst_131612,inst_131613,null));
var state_131785__$1 = state_131785;
var statearr_131791_131896 = state_131785__$1;
(statearr_131791_131896[(2)] = inst_131614);

(statearr_131791_131896[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (59))){
var inst_131681 = (state_131785[(12)]);
var state_131785__$1 = state_131785;
var statearr_131792_131897 = state_131785__$1;
(statearr_131792_131897[(2)] = inst_131681);

(statearr_131792_131897[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (20))){
var inst_131638 = (state_131785[(13)]);
var state_131785__$1 = state_131785;
var statearr_131793_131898 = state_131785__$1;
(statearr_131793_131898[(2)] = inst_131638);

(statearr_131793_131898[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (58))){
var inst_131777 = (state_131785[(2)]);
var state_131785__$1 = state_131785;
var statearr_131794_131899 = state_131785__$1;
(statearr_131794_131899[(2)] = inst_131777);

(statearr_131794_131899[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (60))){
var inst_131739 = (state_131785[(14)]);
var state_131785__$1 = state_131785;
var statearr_131795_131900 = state_131785__$1;
(statearr_131795_131900[(2)] = inst_131739);

(statearr_131795_131900[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (27))){
var inst_131638 = (state_131785[(13)]);
var inst_131667 = (state_131785[(2)]);
var inst_131668 = fluree.db.permissions.parse_fn.cljs$core$IFn$_invoke$arity$3(db,inst_131638,null);
var state_131785__$1 = (function (){var statearr_131796 = state_131785;
(statearr_131796[(15)] = inst_131667);

return statearr_131796;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_131785__$1,(28),inst_131668);
} else {
if((state_val_131786 === (1))){
var state_131785__$1 = state_131785;
var statearr_131797_131901 = state_131785__$1;
(statearr_131797_131901[(2)] = null);

(statearr_131797_131901[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (69))){
var state_131785__$1 = state_131785;
var statearr_131798_131902 = state_131785__$1;
(statearr_131798_131902[(2)] = null);

(statearr_131798_131902[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (24))){
var inst_131646 = (state_131785[(2)]);
var state_131785__$1 = state_131785;
var statearr_131799_131903 = state_131785__$1;
(statearr_131799_131903[(2)] = inst_131646);

(statearr_131799_131903[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (55))){
var inst_131734 = (state_131785[(2)]);
var state_131785__$1 = state_131785;
if(cljs.core.truth_(inst_131734)){
var statearr_131800_131904 = state_131785__$1;
(statearr_131800_131904[(1)] = (56));

} else {
var statearr_131801_131905 = state_131785__$1;
(statearr_131801_131905[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (39))){
var inst_131674 = (state_131785[(16)]);
var state_131785__$1 = state_131785;
var statearr_131802_131906 = state_131785__$1;
(statearr_131802_131906[(2)] = inst_131674);

(statearr_131802_131906[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (46))){
var inst_131781 = (state_131785[(2)]);
var state_131785__$1 = state_131785;
var statearr_131803_131907 = state_131785__$1;
(statearr_131803_131907[(2)] = inst_131781);


cljs.core.async.impl.ioc_helpers.process_exception(state_131785__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (4))){
var inst_131586 = (state_131785[(17)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_131785,(3),Error,null,(2));
var inst_131583 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(rule,"_rule/ops");
var inst_131584 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(rule,"_rule/collection");
var inst_131585 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(rule,"_rule/predicates");
var inst_131586__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(rule,"_rule/fns");
var inst_131587 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(rule,"_rule/collectionDefault");
var inst_131595 = cljs.core.seq(inst_131586__$1);
var inst_131596 = cljs.core.first(inst_131595);
var inst_131597 = cljs.core.next(inst_131595);
var inst_131598 = cljs.core.PersistentVector.EMPTY;
var inst_131599 = cljs.core.PersistentVector.EMPTY;
var inst_131600 = inst_131586__$1;
var inst_131601 = inst_131598;
var inst_131602 = inst_131599;
var state_131785__$1 = (function (){var statearr_131804 = state_131785;
(statearr_131804[(18)] = inst_131583);

(statearr_131804[(19)] = inst_131596);

(statearr_131804[(10)] = inst_131601);

(statearr_131804[(11)] = inst_131602);

(statearr_131804[(20)] = inst_131597);

(statearr_131804[(17)] = inst_131586__$1);

(statearr_131804[(21)] = inst_131584);

(statearr_131804[(22)] = inst_131585);

(statearr_131804[(23)] = inst_131600);

(statearr_131804[(9)] = inst_131587);

return statearr_131804;
})();
var statearr_131805_131908 = state_131785__$1;
(statearr_131805_131908[(2)] = null);

(statearr_131805_131908[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (54))){
var inst_131674 = (state_131785[(16)]);
var state_131785__$1 = state_131785;
var statearr_131806_131909 = state_131785__$1;
(statearr_131806_131909[(2)] = inst_131674);

(statearr_131806_131909[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (15))){
var inst_131655 = (state_131785[(2)]);
var state_131785__$1 = state_131785;
if(cljs.core.truth_(inst_131655)){
var statearr_131807_131910 = state_131785__$1;
(statearr_131807_131910[(1)] = (25));

} else {
var statearr_131808_131911 = state_131785__$1;
(statearr_131808_131911[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (48))){
var inst_131587 = (state_131785[(9)]);
var state_131785__$1 = state_131785;
var statearr_131809_131912 = state_131785__$1;
(statearr_131809_131912[(2)] = inst_131587);

(statearr_131809_131912[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (50))){
var inst_131671 = (state_131785[(7)]);
var inst_131720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_131721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_131722 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_131723 = [cljs.core.cst$kw$collection,cljs.core.cst$kw$default];
var inst_131724 = (new cljs.core.PersistentVector(null,2,(5),inst_131722,inst_131723,null));
var inst_131725 = [inst_131724,inst_131671];
var inst_131726 = (new cljs.core.PersistentVector(null,2,(5),inst_131721,inst_131725,null));
var inst_131727 = [inst_131726];
var inst_131728 = (new cljs.core.PersistentVector(null,1,(5),inst_131720,inst_131727,null));
var state_131785__$1 = state_131785;
var statearr_131810_131913 = state_131785__$1;
(statearr_131810_131913[(2)] = inst_131728);

(statearr_131810_131913[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (21))){
var inst_131649 = (state_131785[(2)]);
var state_131785__$1 = state_131785;
var statearr_131811_131914 = state_131785__$1;
(statearr_131811_131914[(2)] = inst_131649);

(statearr_131811_131914[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (31))){
var inst_131674 = (state_131785[(16)]);
var inst_131681 = (state_131785[(2)]);
var state_131785__$1 = (function (){var statearr_131812 = state_131785;
(statearr_131812[(12)] = inst_131681);

return statearr_131812;
})();
if(cljs.core.truth_(inst_131674)){
var statearr_131813_131915 = state_131785__$1;
(statearr_131813_131915[(1)] = (32));

} else {
var statearr_131814_131916 = state_131785__$1;
(statearr_131814_131916[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (32))){
var state_131785__$1 = state_131785;
var statearr_131815_131917 = state_131785__$1;
(statearr_131815_131917[(2)] = null);

(statearr_131815_131917[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (40))){
var inst_131703 = (state_131785[(2)]);
var state_131785__$1 = state_131785;
if(cljs.core.truth_(inst_131703)){
var statearr_131816_131918 = state_131785__$1;
(statearr_131816_131918[(1)] = (44));

} else {
var statearr_131817_131919 = state_131785__$1;
(statearr_131817_131919[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (56))){
var inst_131624 = (state_131785[(24)]);
var inst_131583 = (state_131785[(18)]);
var inst_131671 = (state_131785[(7)]);
var inst_131586 = (state_131785[(17)]);
var inst_131667 = (state_131785[(15)]);
var inst_131584 = (state_131785[(21)]);
var inst_131585 = (state_131785[(22)]);
var inst_131686 = (state_131785[(8)]);
var inst_131692 = (state_131785[(25)]);
var inst_131627 = (state_131785[(26)]);
var inst_131681 = (state_131785[(12)]);
var inst_131674 = (state_131785[(16)]);
var inst_131626 = (state_131785[(27)]);
var inst_131625 = (state_131785[(28)]);
var inst_131638 = (state_131785[(13)]);
var inst_131587 = (state_131785[(9)]);
var inst_131736 = (function (){var params_STAR_ = inst_131627;
var vec__131580 = inst_131624;
var collection = inst_131584;
var fn_str = inst_131638;
var fun = inst_131671;
var collection_id = inst_131686;
var _ = inst_131667;
var predicate_ids = inst_131692;
var fn_refs = inst_131586;
var params = inst_131625;
var wild_predicate_QMARK_ = inst_131681;
var wild_collection_QMARK_ = inst_131674;
var fn_strs = inst_131626;
var ops = inst_131583;
var default_QMARK_ = inst_131587;
var predicates = inst_131585;
return ((function (params_STAR_,vec__131580,collection,fn_str,fun,collection_id,_,predicate_ids,fn_refs,params,wild_predicate_QMARK_,wild_collection_QMARK_,fn_strs,ops,default_QMARK_,predicates,inst_131624,inst_131583,inst_131671,inst_131586,inst_131667,inst_131584,inst_131585,inst_131686,inst_131692,inst_131627,inst_131681,inst_131674,inst_131626,inst_131625,inst_131638,inst_131587,state_val_131786,c__110077__auto__){
return (function (pred_id){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$predicate,pred_id], null),fun], null);
});
;})(params_STAR_,vec__131580,collection,fn_str,fun,collection_id,_,predicate_ids,fn_refs,params,wild_predicate_QMARK_,wild_collection_QMARK_,fn_strs,ops,default_QMARK_,predicates,inst_131624,inst_131583,inst_131671,inst_131586,inst_131667,inst_131584,inst_131585,inst_131686,inst_131692,inst_131627,inst_131681,inst_131674,inst_131626,inst_131625,inst_131638,inst_131587,state_val_131786,c__110077__auto__))
})();
var inst_131737 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_131736,inst_131692);
var state_131785__$1 = state_131785;
var statearr_131818_131920 = state_131785__$1;
(statearr_131818_131920[(2)] = inst_131737);

(statearr_131818_131920[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (33))){
var inst_131584 = (state_131785[(21)]);
var inst_131684 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$id,inst_131584);
var state_131785__$1 = state_131785;
var statearr_131819_131921 = state_131785__$1;
(statearr_131819_131921[(2)] = inst_131684);

(statearr_131819_131921[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (13))){
var inst_131584 = (state_131785[(21)]);
var state_131785__$1 = state_131785;
if(cljs.core.truth_(inst_131584)){
var statearr_131820_131922 = state_131785__$1;
(statearr_131820_131922[(1)] = (16));

} else {
var statearr_131821_131923 = state_131785__$1;
(statearr_131821_131923[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (22))){
var inst_131642 = (state_131785[(29)]);
var state_131785__$1 = state_131785;
var statearr_131822_131924 = state_131785__$1;
(statearr_131822_131924[(2)] = inst_131642);

(statearr_131822_131924[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (36))){
var inst_131624 = (state_131785[(24)]);
var inst_131583 = (state_131785[(18)]);
var inst_131671 = (state_131785[(7)]);
var inst_131586 = (state_131785[(17)]);
var inst_131667 = (state_131785[(15)]);
var inst_131584 = (state_131785[(21)]);
var inst_131585 = (state_131785[(22)]);
var inst_131686 = (state_131785[(8)]);
var inst_131627 = (state_131785[(26)]);
var inst_131681 = (state_131785[(12)]);
var inst_131674 = (state_131785[(16)]);
var inst_131626 = (state_131785[(27)]);
var inst_131625 = (state_131785[(28)]);
var inst_131638 = (state_131785[(13)]);
var inst_131587 = (state_131785[(9)]);
var inst_131689 = (function (){var params_STAR_ = inst_131627;
var vec__131580 = inst_131624;
var collection = inst_131584;
var fn_str = inst_131638;
var fun = inst_131671;
var collection_id = inst_131686;
var _ = inst_131667;
var fn_refs = inst_131586;
var params = inst_131625;
var wild_predicate_QMARK_ = inst_131681;
var wild_collection_QMARK_ = inst_131674;
var fn_strs = inst_131626;
var ops = inst_131583;
var default_QMARK_ = inst_131587;
var predicates = inst_131585;
return ((function (params_STAR_,vec__131580,collection,fn_str,fun,collection_id,_,fn_refs,params,wild_predicate_QMARK_,wild_collection_QMARK_,fn_strs,ops,default_QMARK_,predicates,inst_131624,inst_131583,inst_131671,inst_131586,inst_131667,inst_131584,inst_131585,inst_131686,inst_131627,inst_131681,inst_131674,inst_131626,inst_131625,inst_131638,inst_131587,state_val_131786,c__110077__auto__){
return (function (p1__131575_SHARP_){
return fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1__131575_SHARP_);
});
;})(params_STAR_,vec__131580,collection,fn_str,fun,collection_id,_,fn_refs,params,wild_predicate_QMARK_,wild_collection_QMARK_,fn_strs,ops,default_QMARK_,predicates,inst_131624,inst_131583,inst_131671,inst_131586,inst_131667,inst_131584,inst_131585,inst_131686,inst_131627,inst_131681,inst_131674,inst_131626,inst_131625,inst_131638,inst_131587,state_val_131786,c__110077__auto__))
})();
var inst_131690 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_131689,inst_131585);
var state_131785__$1 = state_131785;
var statearr_131823_131925 = state_131785__$1;
(statearr_131823_131925[(2)] = inst_131690);

(statearr_131823_131925[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (41))){
var inst_131671 = (state_131785[(7)]);
var inst_131587 = (state_131785[(9)]);
var inst_131695 = cljs.core.not(inst_131587);
var inst_131696 = inst_131671 === true;
var inst_131697 = ((inst_131695) && (inst_131696));
var state_131785__$1 = state_131785;
var statearr_131824_131926 = state_131785__$1;
(statearr_131824_131926[(2)] = inst_131697);

(statearr_131824_131926[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (43))){
var inst_131700 = (state_131785[(2)]);
var state_131785__$1 = state_131785;
var statearr_131825_131927 = state_131785__$1;
(statearr_131825_131927[(2)] = inst_131700);

(statearr_131825_131927[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (61))){
var inst_131743 = (state_131785[(2)]);
var state_131785__$1 = state_131785;
if(cljs.core.truth_(inst_131743)){
var statearr_131826_131928 = state_131785__$1;
(statearr_131826_131928[(1)] = (62));

} else {
var statearr_131827_131929 = state_131785__$1;
(statearr_131827_131929[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (29))){
var inst_131675 = (state_131785[(30)]);
var state_131785__$1 = state_131785;
var statearr_131828_131930 = state_131785__$1;
(statearr_131828_131930[(2)] = inst_131675);

(statearr_131828_131930[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (44))){
var inst_131705 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_131706 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_131707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_131708 = [cljs.core.cst$kw$root_QMARK_];
var inst_131709 = (new cljs.core.PersistentVector(null,1,(5),inst_131707,inst_131708,null));
var inst_131710 = [inst_131709,true];
var inst_131711 = (new cljs.core.PersistentVector(null,2,(5),inst_131706,inst_131710,null));
var inst_131712 = [inst_131711];
var inst_131713 = (new cljs.core.PersistentVector(null,1,(5),inst_131705,inst_131712,null));
var state_131785__$1 = state_131785;
var statearr_131829_131931 = state_131785__$1;
(statearr_131829_131931[(2)] = inst_131713);

(statearr_131829_131931[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (6))){
var inst_131624 = (state_131785[(24)]);
var inst_131627 = (state_131785[(26)]);
var inst_131625 = (state_131785[(28)]);
var inst_131624__$1 = (state_131785[(2)]);
var inst_131625__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_131624__$1,(0),null);
var inst_131626 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_131624__$1,(1),null);
var inst_131627__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.empty_QMARK_,inst_131625__$1);
var inst_131628 = cljs.core.empty_QMARK_(inst_131627__$1);
var state_131785__$1 = (function (){var statearr_131830 = state_131785;
(statearr_131830[(24)] = inst_131624__$1);

(statearr_131830[(26)] = inst_131627__$1);

(statearr_131830[(27)] = inst_131626);

(statearr_131830[(28)] = inst_131625__$1);

return statearr_131830;
})();
if(inst_131628){
var statearr_131831_131932 = state_131785__$1;
(statearr_131831_131932[(1)] = (10));

} else {
var statearr_131832_131933 = state_131785__$1;
(statearr_131832_131933[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (28))){
var inst_131584 = (state_131785[(21)]);
var inst_131585 = (state_131785[(22)]);
var inst_131675 = (state_131785[(30)]);
var inst_131670 = (state_131785[(2)]);
var inst_131671 = fluree.db.util.async.throw_err(inst_131670);
var inst_131672 = (inst_131584 == null);
var inst_131673 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("*",inst_131584);
var inst_131674 = ((inst_131672) || (inst_131673));
var inst_131675__$1 = cljs.core.empty_QMARK_(inst_131585);
var state_131785__$1 = (function (){var statearr_131833 = state_131785;
(statearr_131833[(7)] = inst_131671);

(statearr_131833[(30)] = inst_131675__$1);

(statearr_131833[(16)] = inst_131674);

return statearr_131833;
})();
if(inst_131675__$1){
var statearr_131834_131934 = state_131785__$1;
(statearr_131834_131934[(1)] = (29));

} else {
var statearr_131835_131935 = state_131785__$1;
(statearr_131835_131935[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (64))){
var inst_131775 = (state_131785[(2)]);
var state_131785__$1 = state_131785;
var statearr_131836_131936 = state_131785__$1;
(statearr_131836_131936[(2)] = inst_131775);

(statearr_131836_131936[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (51))){
var inst_131674 = (state_131785[(16)]);
var state_131785__$1 = state_131785;
if(cljs.core.truth_(inst_131674)){
var statearr_131837_131937 = state_131785__$1;
(statearr_131837_131937[(1)] = (53));

} else {
var statearr_131838_131938 = state_131785__$1;
(statearr_131838_131938[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (25))){
var state_131785__$1 = state_131785;
var statearr_131839_131939 = state_131785__$1;
(statearr_131839_131939[(2)] = null);

(statearr_131839_131939[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (34))){
var inst_131681 = (state_131785[(12)]);
var inst_131686 = (state_131785[(2)]);
var state_131785__$1 = (function (){var statearr_131840 = state_131785;
(statearr_131840[(8)] = inst_131686);

return statearr_131840;
})();
if(cljs.core.truth_(inst_131681)){
var statearr_131841_131940 = state_131785__$1;
(statearr_131841_131940[(1)] = (35));

} else {
var statearr_131842_131941 = state_131785__$1;
(statearr_131842_131941[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (17))){
var inst_131584 = (state_131785[(21)]);
var state_131785__$1 = state_131785;
var statearr_131843_131942 = state_131785__$1;
(statearr_131843_131942[(2)] = inst_131584);

(statearr_131843_131942[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (3))){
var inst_131576 = (state_131785[(2)]);
var state_131785__$1 = state_131785;
var statearr_131844_131943 = state_131785__$1;
(statearr_131844_131943[(2)] = inst_131576);


cljs.core.async.impl.ioc_helpers.process_exception(state_131785__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (12))){
var inst_131583 = (state_131785[(18)]);
var inst_131626 = (state_131785[(27)]);
var inst_131637 = (state_131785[(2)]);
var inst_131638 = fluree.db.dbfunctions.core.combine_fns(inst_131626);
var state_131785__$1 = (function (){var statearr_131845 = state_131785;
(statearr_131845[(31)] = inst_131637);

(statearr_131845[(13)] = inst_131638);

return statearr_131845;
})();
if(cljs.core.truth_(inst_131583)){
var statearr_131846_131944 = state_131785__$1;
(statearr_131846_131944[(1)] = (13));

} else {
var statearr_131847_131945 = state_131785__$1;
(statearr_131847_131945[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (2))){
var inst_131783 = (state_131785[(2)]);
var state_131785__$1 = state_131785;
return cljs.core.async.impl.ioc_helpers.return_chan(state_131785__$1,inst_131783);
} else {
if((state_val_131786 === (66))){
var inst_131671 = (state_131785[(7)]);
var inst_131686 = (state_131785[(8)]);
var inst_131756 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_131757 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_131758 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_131759 = [cljs.core.cst$kw$collection,inst_131686,cljs.core.cst$kw$all];
var inst_131760 = (new cljs.core.PersistentVector(null,3,(5),inst_131758,inst_131759,null));
var inst_131761 = [inst_131760,inst_131671];
var inst_131762 = (new cljs.core.PersistentVector(null,2,(5),inst_131757,inst_131761,null));
var inst_131763 = [inst_131762];
var inst_131764 = (new cljs.core.PersistentVector(null,1,(5),inst_131756,inst_131763,null));
var state_131785__$1 = state_131785;
var statearr_131848_131946 = state_131785__$1;
(statearr_131848_131946[(2)] = inst_131764);

(statearr_131848_131946[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (23))){
var inst_131587 = (state_131785[(9)]);
var state_131785__$1 = state_131785;
var statearr_131849_131947 = state_131785__$1;
(statearr_131849_131947[(2)] = inst_131587);

(statearr_131849_131947[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (47))){
var inst_131674 = (state_131785[(16)]);
var state_131785__$1 = state_131785;
var statearr_131850_131948 = state_131785__$1;
(statearr_131850_131948[(2)] = inst_131674);

(statearr_131850_131948[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (35))){
var state_131785__$1 = state_131785;
var statearr_131851_131949 = state_131785__$1;
(statearr_131851_131949[(2)] = null);

(statearr_131851_131949[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (19))){
var inst_131642 = (state_131785[(29)]);
var inst_131585 = (state_131785[(22)]);
var inst_131642__$1 = cljs.core.not_empty(inst_131585);
var state_131785__$1 = (function (){var statearr_131852 = state_131785;
(statearr_131852[(29)] = inst_131642__$1);

return statearr_131852;
})();
if(cljs.core.truth_(inst_131642__$1)){
var statearr_131853_131950 = state_131785__$1;
(statearr_131853_131950[(1)] = (22));

} else {
var statearr_131854_131951 = state_131785__$1;
(statearr_131854_131951[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (57))){
var inst_131739 = (state_131785[(14)]);
var inst_131674 = (state_131785[(16)]);
var inst_131739__$1 = cljs.core.not(inst_131674);
var state_131785__$1 = (function (){var statearr_131855 = state_131785;
(statearr_131855[(14)] = inst_131739__$1);

return statearr_131855;
})();
if(inst_131739__$1){
var statearr_131856_131952 = state_131785__$1;
(statearr_131856_131952[(1)] = (59));

} else {
var statearr_131857_131953 = state_131785__$1;
(statearr_131857_131953[(1)] = (60));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (68))){
var inst_131624 = (state_131785[(24)]);
var inst_131583 = (state_131785[(18)]);
var inst_131671 = (state_131785[(7)]);
var inst_131586 = (state_131785[(17)]);
var inst_131667 = (state_131785[(15)]);
var inst_131584 = (state_131785[(21)]);
var inst_131585 = (state_131785[(22)]);
var inst_131686 = (state_131785[(8)]);
var inst_131692 = (state_131785[(25)]);
var inst_131627 = (state_131785[(26)]);
var inst_131681 = (state_131785[(12)]);
var inst_131674 = (state_131785[(16)]);
var inst_131626 = (state_131785[(27)]);
var inst_131625 = (state_131785[(28)]);
var inst_131638 = (state_131785[(13)]);
var inst_131587 = (state_131785[(9)]);
var inst_131769 = (function (){var params_STAR_ = inst_131627;
var vec__131580 = inst_131624;
var collection = inst_131584;
var fn_str = inst_131638;
var fun = inst_131671;
var collection_id = inst_131686;
var _ = inst_131667;
var predicate_ids = inst_131692;
var fn_refs = inst_131586;
var params = inst_131625;
var wild_predicate_QMARK_ = inst_131681;
var wild_collection_QMARK_ = inst_131674;
var fn_strs = inst_131626;
var ops = inst_131583;
var default_QMARK_ = inst_131587;
var predicates = inst_131585;
return ((function (params_STAR_,vec__131580,collection,fn_str,fun,collection_id,_,predicate_ids,fn_refs,params,wild_predicate_QMARK_,wild_collection_QMARK_,fn_strs,ops,default_QMARK_,predicates,inst_131624,inst_131583,inst_131671,inst_131586,inst_131667,inst_131584,inst_131585,inst_131686,inst_131692,inst_131627,inst_131681,inst_131674,inst_131626,inst_131625,inst_131638,inst_131587,state_val_131786,c__110077__auto__){
return (function (pred_id){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$collection,collection_id,pred_id], null),fun], null);
});
;})(params_STAR_,vec__131580,collection,fn_str,fun,collection_id,_,predicate_ids,fn_refs,params,wild_predicate_QMARK_,wild_collection_QMARK_,fn_strs,ops,default_QMARK_,predicates,inst_131624,inst_131583,inst_131671,inst_131586,inst_131667,inst_131584,inst_131585,inst_131686,inst_131692,inst_131627,inst_131681,inst_131674,inst_131626,inst_131625,inst_131638,inst_131587,state_val_131786,c__110077__auto__))
})();
var inst_131770 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_131769,inst_131692);
var state_131785__$1 = state_131785;
var statearr_131858_131954 = state_131785__$1;
(statearr_131858_131954[(2)] = inst_131770);

(statearr_131858_131954[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (11))){
var inst_131631 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_131632 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_131633 = cljs.core.PersistentHashMap.fromArrays(inst_131631,inst_131632);
var inst_131634 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("You can only use functions with additional parameters in transactions functions. ",inst_131633);
var inst_131635 = (function(){throw inst_131634})();
var state_131785__$1 = state_131785;
var statearr_131859_131955 = state_131785__$1;
(statearr_131859_131955[(2)] = inst_131635);

(statearr_131859_131955[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (9))){
var inst_131622 = (state_131785[(2)]);
var state_131785__$1 = state_131785;
var statearr_131860_131956 = state_131785__$1;
(statearr_131860_131956[(2)] = inst_131622);

(statearr_131860_131956[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (5))){
var inst_131600 = (state_131785[(23)]);
var inst_131608 = (state_131785[(32)]);
var inst_131607 = cljs.core.seq(inst_131600);
var inst_131608__$1 = cljs.core.first(inst_131607);
var inst_131609 = cljs.core.next(inst_131607);
var inst_131610 = cljs.core.not(inst_131608__$1);
var state_131785__$1 = (function (){var statearr_131861 = state_131785;
(statearr_131861[(33)] = inst_131609);

(statearr_131861[(32)] = inst_131608__$1);

return statearr_131861;
})();
if(inst_131610){
var statearr_131862_131957 = state_131785__$1;
(statearr_131862_131957[(1)] = (7));

} else {
var statearr_131863_131958 = state_131785__$1;
(statearr_131863_131958[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (14))){
var inst_131583 = (state_131785[(18)]);
var state_131785__$1 = state_131785;
var statearr_131864_131959 = state_131785__$1;
(statearr_131864_131959[(2)] = inst_131583);

(statearr_131864_131959[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (45))){
var inst_131587 = (state_131785[(9)]);
var state_131785__$1 = state_131785;
if(cljs.core.truth_(inst_131587)){
var statearr_131865_131960 = state_131785__$1;
(statearr_131865_131960[(1)] = (47));

} else {
var statearr_131866_131961 = state_131785__$1;
(statearr_131866_131961[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (53))){
var inst_131681 = (state_131785[(12)]);
var inst_131731 = cljs.core.not(inst_131681);
var state_131785__$1 = state_131785;
var statearr_131867_131962 = state_131785__$1;
(statearr_131867_131962[(2)] = inst_131731);

(statearr_131867_131962[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (26))){
var inst_131658 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(rule,"_id");
var inst_131659 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_131658], 0));
var inst_131660 = ["Incomplete rule, does not contain all required predicates for rule id:",inst_131659].join('');
var inst_131661 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_131662 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_rule];
var inst_131663 = cljs.core.PersistentHashMap.fromArrays(inst_131661,inst_131662);
var inst_131664 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_131660,inst_131663);
var inst_131665 = (function(){throw inst_131664})();
var state_131785__$1 = state_131785;
var statearr_131868_131963 = state_131785__$1;
(statearr_131868_131963[(2)] = inst_131665);

(statearr_131868_131963[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (16))){
var inst_131638 = (state_131785[(13)]);
var state_131785__$1 = state_131785;
if(cljs.core.truth_(inst_131638)){
var statearr_131869_131964 = state_131785__$1;
(statearr_131869_131964[(1)] = (19));

} else {
var statearr_131870_131965 = state_131785__$1;
(statearr_131870_131965[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (38))){
var inst_131681 = (state_131785[(12)]);
var state_131785__$1 = state_131785;
if(cljs.core.truth_(inst_131681)){
var statearr_131871_131966 = state_131785__$1;
(statearr_131871_131966[(1)] = (41));

} else {
var statearr_131872_131967 = state_131785__$1;
(statearr_131872_131967[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (30))){
var inst_131624 = (state_131785[(24)]);
var inst_131583 = (state_131785[(18)]);
var inst_131671 = (state_131785[(7)]);
var inst_131586 = (state_131785[(17)]);
var inst_131667 = (state_131785[(15)]);
var inst_131584 = (state_131785[(21)]);
var inst_131585 = (state_131785[(22)]);
var inst_131675 = (state_131785[(30)]);
var inst_131627 = (state_131785[(26)]);
var inst_131674 = (state_131785[(16)]);
var inst_131626 = (state_131785[(27)]);
var inst_131625 = (state_131785[(28)]);
var inst_131638 = (state_131785[(13)]);
var inst_131587 = (state_131785[(9)]);
var inst_131678 = (function (){var params_STAR_ = inst_131627;
var vec__131580 = inst_131624;
var collection = inst_131584;
var fn_str = inst_131638;
var fun = inst_131671;
var _ = inst_131667;
var fn_refs = inst_131586;
var params = inst_131625;
var wild_collection_QMARK_ = inst_131674;
var fn_strs = inst_131626;
var ops = inst_131583;
var default_QMARK_ = inst_131587;
var or__4131__auto__ = inst_131675;
var predicates = inst_131585;
return ((function (params_STAR_,vec__131580,collection,fn_str,fun,_,fn_refs,params,wild_collection_QMARK_,fn_strs,ops,default_QMARK_,or__4131__auto__,predicates,inst_131624,inst_131583,inst_131671,inst_131586,inst_131667,inst_131584,inst_131585,inst_131675,inst_131627,inst_131674,inst_131626,inst_131625,inst_131638,inst_131587,state_val_131786,c__110077__auto__){
return (function (p1__131574_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("*",p1__131574_SHARP_);
});
;})(params_STAR_,vec__131580,collection,fn_str,fun,_,fn_refs,params,wild_collection_QMARK_,fn_strs,ops,default_QMARK_,or__4131__auto__,predicates,inst_131624,inst_131583,inst_131671,inst_131586,inst_131667,inst_131584,inst_131585,inst_131675,inst_131627,inst_131674,inst_131626,inst_131625,inst_131638,inst_131587,state_val_131786,c__110077__auto__))
})();
var inst_131679 = cljs.core.some(inst_131678,inst_131585);
var state_131785__$1 = state_131785;
var statearr_131873_131968 = state_131785__$1;
(statearr_131873_131968[(2)] = inst_131679);

(statearr_131873_131968[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (10))){
var state_131785__$1 = state_131785;
var statearr_131874_131969 = state_131785__$1;
(statearr_131874_131969[(2)] = null);

(statearr_131874_131969[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (18))){
var inst_131652 = (state_131785[(2)]);
var state_131785__$1 = state_131785;
var statearr_131875_131970 = state_131785__$1;
(statearr_131875_131970[(2)] = inst_131652);

(statearr_131875_131970[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (52))){
var inst_131779 = (state_131785[(2)]);
var state_131785__$1 = state_131785;
var statearr_131876_131971 = state_131785__$1;
(statearr_131876_131971[(2)] = inst_131779);

(statearr_131876_131971[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (67))){
var inst_131766 = (state_131785[(2)]);
var state_131785__$1 = state_131785;
var statearr_131877_131972 = state_131785__$1;
(statearr_131877_131972[(2)] = inst_131766);

(statearr_131877_131972[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (42))){
var inst_131681 = (state_131785[(12)]);
var state_131785__$1 = state_131785;
var statearr_131878_131973 = state_131785__$1;
(statearr_131878_131973[(2)] = inst_131681);

(statearr_131878_131973[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (37))){
var inst_131674 = (state_131785[(16)]);
var inst_131692 = (state_131785[(2)]);
var state_131785__$1 = (function (){var statearr_131879 = state_131785;
(statearr_131879[(25)] = inst_131692);

return statearr_131879;
})();
if(cljs.core.truth_(inst_131674)){
var statearr_131880_131974 = state_131785__$1;
(statearr_131880_131974[(1)] = (38));

} else {
var statearr_131881_131975 = state_131785__$1;
(statearr_131881_131975[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (63))){
var state_131785__$1 = state_131785;
var statearr_131882_131976 = state_131785__$1;
(statearr_131882_131976[(1)] = (68));



return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (8))){
var inst_131601 = (state_131785[(10)]);
var inst_131602 = (state_131785[(11)]);
var inst_131609 = (state_131785[(33)]);
var inst_131608 = (state_131785[(32)]);
var inst_131616 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_131608,"_fn/params");
var inst_131617 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_131601,inst_131616);
var inst_131618 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_131608,"_fn/code");
var inst_131619 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_131602,inst_131618);
var inst_131600 = inst_131609;
var inst_131601__$1 = inst_131617;
var inst_131602__$1 = inst_131619;
var state_131785__$1 = (function (){var statearr_131884 = state_131785;
(statearr_131884[(10)] = inst_131601__$1);

(statearr_131884[(11)] = inst_131602__$1);

(statearr_131884[(23)] = inst_131600);

return statearr_131884;
})();
var statearr_131885_131977 = state_131785__$1;
(statearr_131885_131977[(2)] = null);

(statearr_131885_131977[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_131786 === (49))){
var inst_131718 = (state_131785[(2)]);
var state_131785__$1 = state_131785;
if(cljs.core.truth_(inst_131718)){
var statearr_131886_131978 = state_131785__$1;
(statearr_131886_131978[(1)] = (50));

} else {
var statearr_131887_131979 = state_131785__$1;
(statearr_131887_131979[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$permissions$parse_rules_$_state_machine__109971__auto__ = null;
var fluree$db$permissions$parse_rules_$_state_machine__109971__auto____0 = (function (){
var statearr_131888 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_131888[(0)] = fluree$db$permissions$parse_rules_$_state_machine__109971__auto__);

(statearr_131888[(1)] = (1));

return statearr_131888;
});
var fluree$db$permissions$parse_rules_$_state_machine__109971__auto____1 = (function (state_131785){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_131785);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e131889){if((e131889 instanceof Object)){
var ex__109974__auto__ = e131889;
var statearr_131890_131980 = state_131785;
(statearr_131890_131980[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_131785);

return cljs.core.cst$kw$recur;
} else {
throw e131889;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__131981 = state_131785;
state_131785 = G__131981;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$permissions$parse_rules_$_state_machine__109971__auto__ = function(state_131785){
switch(arguments.length){
case 0:
return fluree$db$permissions$parse_rules_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$permissions$parse_rules_$_state_machine__109971__auto____1.call(this,state_131785);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$permissions$parse_rules_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$permissions$parse_rules_$_state_machine__109971__auto____0;
fluree$db$permissions$parse_rules_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$permissions$parse_rules_$_state_machine__109971__auto____1;
return fluree$db$permissions$parse_rules_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_131891 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_131891[(6)] = c__110077__auto__);

return statearr_131891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
/**
 * Given a role, returns rules associated with it. Optionally can filter by
 *   a specific '_rule/ops' type as a keyword, i.e. :all, :query, :transact, :token.
 */
fluree.db.permissions.rules_from_role = (function fluree$db$permissions$rules_from_role(var_args){
var G__131984 = arguments.length;
switch (G__131984) {
case 2:
return fluree.db.permissions.rules_from_role.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.permissions.rules_from_role.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

fluree.db.permissions.rules_from_role.cljs$core$IFn$_invoke$arity$2 = (function (db,role){
return fluree.db.permissions.rules_from_role.cljs$core$IFn$_invoke$arity$3(db,role,cljs.core.cst$kw$all);
});

fluree.db.permissions.rules_from_role.cljs$core$IFn$_invoke$arity$3 = (function (db,role,filter_op_type){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_132042){
var state_val_132043 = (state_132042[(1)]);
if((state_val_132043 === (7))){
var inst_132013 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([role], 0));
var inst_132014 = ["Invalid role ident, doesn't exist: ",inst_132013].join('');
var inst_132015 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_132016 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_role];
var inst_132017 = cljs.core.PersistentHashMap.fromArrays(inst_132015,inst_132016);
var inst_132018 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_132014,inst_132017);
var inst_132019 = (function(){throw inst_132018})();
var state_132042__$1 = state_132042;
var statearr_132044_132067 = state_132042__$1;
(statearr_132044_132067[(2)] = inst_132019);

(statearr_132044_132067[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132043 === (1))){
var state_132042__$1 = state_132042;
var statearr_132045_132068 = state_132042__$1;
(statearr_132045_132068[(2)] = null);

(statearr_132045_132068[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132043 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_132042,(3),Error,null,(2));
var inst_131989 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from];
var inst_131990 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_131991 = ["_role/rules"];
var inst_131992 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_131993 = ["_rule/fns"];
var inst_131994 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_131995 = ["_fn/code","_fn/params"];
var inst_131996 = (new cljs.core.PersistentVector(null,2,(5),inst_131994,inst_131995,null));
var inst_131997 = [inst_131996];
var inst_131998 = cljs.core.PersistentHashMap.fromArrays(inst_131993,inst_131997);
var inst_131999 = ["*",inst_131998];
var inst_132000 = (new cljs.core.PersistentVector(null,2,(5),inst_131992,inst_131999,null));
var inst_132001 = [inst_132000];
var inst_132002 = cljs.core.PersistentHashMap.fromArrays(inst_131991,inst_132001);
var inst_132003 = [inst_132002];
var inst_132004 = (new cljs.core.PersistentVector(null,1,(5),inst_131990,inst_132003,null));
var inst_132005 = [inst_132004,role];
var inst_132006 = cljs.core.PersistentHashMap.fromArrays(inst_131989,inst_132005);
var inst_132007 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_132006);
var state_132042__$1 = state_132042;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_132042__$1,(5),inst_132007);
} else {
if((state_val_132043 === (13))){
var inst_132022 = (state_132042[(7)]);
var state_132042__$1 = state_132042;
var statearr_132046_132069 = state_132042__$1;
(statearr_132046_132069[(2)] = inst_132022);

(statearr_132046_132069[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132043 === (6))){
var state_132042__$1 = state_132042;
var statearr_132047_132070 = state_132042__$1;
(statearr_132047_132070[(2)] = null);

(statearr_132047_132070[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132043 === (3))){
var inst_131985 = (state_132042[(2)]);
var state_132042__$1 = state_132042;
var statearr_132048_132071 = state_132042__$1;
(statearr_132048_132071[(2)] = inst_131985);


cljs.core.async.impl.ioc_helpers.process_exception(state_132042__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_132043 === (12))){
var inst_132010 = (state_132042[(8)]);
var inst_132022 = (state_132042[(7)]);
var inst_132032 = (state_132042[(9)]);
var inst_132021 = (state_132042[(10)]);
var inst_132034 = (function (){var rules_res = inst_132010;
var _ = inst_132021;
var rules = inst_132022;
var op_filter = inst_132032;
return ((function (rules_res,_,rules,op_filter,inst_132010,inst_132022,inst_132032,inst_132021,state_val_132043,c__110077__auto__){
return (function (p1__131982_SHARP_){
return cljs.core.some(((function (rules_res,_,rules,op_filter,inst_132010,inst_132022,inst_132032,inst_132021,state_val_132043,c__110077__auto__){
return (function (op){
return (op_filter.cljs$core$IFn$_invoke$arity$1 ? op_filter.cljs$core$IFn$_invoke$arity$1(op) : op_filter.call(null,op));
});})(rules_res,_,rules,op_filter,inst_132010,inst_132022,inst_132032,inst_132021,state_val_132043,c__110077__auto__))
,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__131982_SHARP_,"_rule/ops"));
});
;})(rules_res,_,rules,op_filter,inst_132010,inst_132022,inst_132032,inst_132021,state_val_132043,c__110077__auto__))
})();
var inst_132035 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_132034,inst_132022);
var state_132042__$1 = state_132042;
var statearr_132049_132072 = state_132042__$1;
(statearr_132049_132072[(2)] = inst_132035);

(statearr_132049_132072[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132043 === (2))){
var inst_132040 = (state_132042[(2)]);
var state_132042__$1 = state_132042;
return cljs.core.async.impl.ioc_helpers.return_chan(state_132042__$1,inst_132040);
} else {
if((state_val_132043 === (11))){
var inst_132032 = (state_132042[(9)]);
var inst_132032__$1 = (state_132042[(2)]);
var state_132042__$1 = (function (){var statearr_132050 = state_132042;
(statearr_132050[(9)] = inst_132032__$1);

return statearr_132050;
})();
if(cljs.core.truth_(inst_132032__$1)){
var statearr_132051_132073 = state_132042__$1;
(statearr_132051_132073[(1)] = (12));

} else {
var statearr_132052_132074 = state_132042__$1;
(statearr_132052_132074[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132043 === (9))){
var state_132042__$1 = state_132042;
var statearr_132053_132075 = state_132042__$1;
(statearr_132053_132075[(2)] = null);

(statearr_132053_132075[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132043 === (5))){
var inst_132010 = (state_132042[(8)]);
var inst_132009 = (state_132042[(2)]);
var inst_132010__$1 = fluree.db.util.async.throw_err(inst_132009);
var state_132042__$1 = (function (){var statearr_132054 = state_132042;
(statearr_132054[(8)] = inst_132010__$1);

return statearr_132054;
})();
if(cljs.core.truth_(inst_132010__$1)){
var statearr_132055_132076 = state_132042__$1;
(statearr_132055_132076[(1)] = (6));

} else {
var statearr_132056_132077 = state_132042__$1;
(statearr_132056_132077[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132043 === (14))){
var inst_132038 = (state_132042[(2)]);
var state_132042__$1 = state_132042;
var statearr_132057_132078 = state_132042__$1;
(statearr_132057_132078[(2)] = inst_132038);


cljs.core.async.impl.ioc_helpers.process_exception(state_132042__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_132043 === (10))){
var inst_132026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132027 = cljs.core.name(filter_op_type);
var inst_132028 = ["all",inst_132027];
var inst_132029 = (new cljs.core.PersistentVector(null,2,(5),inst_132026,inst_132028,null));
var inst_132030 = cljs.core.set(inst_132029);
var state_132042__$1 = state_132042;
var statearr_132058_132079 = state_132042__$1;
(statearr_132058_132079[(2)] = inst_132030);

(statearr_132058_132079[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132043 === (8))){
var inst_132010 = (state_132042[(8)]);
var inst_132021 = (state_132042[(2)]);
var inst_132022 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_132010,"_role/rules");
var inst_132023 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$all,filter_op_type);
var state_132042__$1 = (function (){var statearr_132059 = state_132042;
(statearr_132059[(7)] = inst_132022);

(statearr_132059[(10)] = inst_132021);

return statearr_132059;
})();
if(inst_132023){
var statearr_132060_132080 = state_132042__$1;
(statearr_132060_132080[(1)] = (9));

} else {
var statearr_132061_132081 = state_132042__$1;
(statearr_132061_132081[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$permissions$state_machine__109971__auto__ = null;
var fluree$db$permissions$state_machine__109971__auto____0 = (function (){
var statearr_132062 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_132062[(0)] = fluree$db$permissions$state_machine__109971__auto__);

(statearr_132062[(1)] = (1));

return statearr_132062;
});
var fluree$db$permissions$state_machine__109971__auto____1 = (function (state_132042){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_132042);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e132063){if((e132063 instanceof Object)){
var ex__109974__auto__ = e132063;
var statearr_132064_132082 = state_132042;
(statearr_132064_132082[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_132042);

return cljs.core.cst$kw$recur;
} else {
throw e132063;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__132083 = state_132042;
state_132042 = G__132083;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$permissions$state_machine__109971__auto__ = function(state_132042){
switch(arguments.length){
case 0:
return fluree$db$permissions$state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$permissions$state_machine__109971__auto____1.call(this,state_132042);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$permissions$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$permissions$state_machine__109971__auto____0;
fluree$db$permissions$state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$permissions$state_machine__109971__auto____1;
return fluree$db$permissions$state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_132065 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_132065[(6)] = c__110077__auto__);

return statearr_132065;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});

fluree.db.permissions.rules_from_role.cljs$lang$maxFixedArity = 3;

fluree.db.permissions.role_permission_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.ttl_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ttl,(((5) * (60)) * (1000))], 0)));
fluree.db.permissions.role_permissions = (function fluree$db$permissions$role_permissions(db,role_ident,permission_type){

var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_132165){
var state_val_132166 = (state_132165[(1)]);
if((state_val_132166 === (7))){
var inst_132099 = (state_132165[(7)]);
var inst_132099__$1 = (state_132165[(2)]);
var state_132165__$1 = (function (){var statearr_132167 = state_132165;
(statearr_132167[(7)] = inst_132099__$1);

return statearr_132167;
})();
if(cljs.core.truth_(inst_132099__$1)){
var statearr_132168_132198 = state_132165__$1;
(statearr_132168_132198[(1)] = (8));

} else {
var statearr_132169_132199 = state_132165__$1;
(statearr_132169_132199[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132166 === (20))){
var inst_132140 = (state_132165[(8)]);
var inst_132133 = (state_132165[(9)]);
var inst_132146 = (state_132165[(2)]);
var inst_132147 = fluree.db.util.async.throw_err(inst_132146);
var inst_132148 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_132133,inst_132147);
var inst_132132 = inst_132140;
var inst_132133__$1 = inst_132148;
var state_132165__$1 = (function (){var statearr_132170 = state_132165;
(statearr_132170[(10)] = inst_132132);

(statearr_132170[(9)] = inst_132133__$1);

return statearr_132170;
})();
var statearr_132171_132200 = state_132165__$1;
(statearr_132171_132200[(2)] = null);

(statearr_132171_132200[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132166 === (1))){
var state_132165__$1 = state_132165;
var statearr_132172_132201 = state_132165__$1;
(statearr_132172_132201[(2)] = null);

(statearr_132172_132201[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132166 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_132165,(3),Error,null,(2));
var inst_132088 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var state_132165__$1 = state_132165;
if(cljs.core.truth_(inst_132088)){
var statearr_132173_132202 = state_132165__$1;
(statearr_132173_132202[(1)] = (5));

} else {
var statearr_132174_132203 = state_132165__$1;
(statearr_132174_132203[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132166 === (15))){
var inst_132132 = (state_132165[(10)]);
var inst_132139 = (state_132165[(11)]);
var inst_132138 = cljs.core.seq(inst_132132);
var inst_132139__$1 = cljs.core.first(inst_132138);
var inst_132140 = cljs.core.next(inst_132138);
var inst_132141 = cljs.core.not(inst_132139__$1);
var state_132165__$1 = (function (){var statearr_132175 = state_132165;
(statearr_132175[(8)] = inst_132140);

(statearr_132175[(11)] = inst_132139__$1);

return statearr_132175;
})();
if(inst_132141){
var statearr_132176_132204 = state_132165__$1;
(statearr_132176_132204[(1)] = (17));

} else {
var statearr_132177_132205 = state_132165__$1;
(statearr_132177_132205[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132166 === (13))){
var inst_132116 = (state_132165[(2)]);
var inst_132117 = fluree.db.permissions.rules_from_role.cljs$core$IFn$_invoke$arity$3(db,role_ident,permission_type);
var state_132165__$1 = (function (){var statearr_132178 = state_132165;
(statearr_132178[(12)] = inst_132116);

return statearr_132178;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_132165__$1,(14),inst_132117);
} else {
if((state_val_132166 === (6))){
var inst_132091 = cljs.core.deref(fluree.db.permissions.role_permission_cache);
var inst_132092 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132093 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_132094 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_132095 = [inst_132093,inst_132094,role_ident,permission_type];
var inst_132096 = (new cljs.core.PersistentVector(null,4,(5),inst_132092,inst_132095,null));
var inst_132097 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_132091,inst_132096);
var state_132165__$1 = state_132165;
var statearr_132179_132206 = state_132165__$1;
(statearr_132179_132206[(2)] = inst_132097);

(statearr_132179_132206[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132166 === (17))){
var inst_132133 = (state_132165[(9)]);
var state_132165__$1 = state_132165;
var statearr_132180_132207 = state_132165__$1;
(statearr_132180_132207[(2)] = inst_132133);

(statearr_132180_132207[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132166 === (3))){
var inst_132084 = (state_132165[(2)]);
var state_132165__$1 = state_132165;
var statearr_132181_132208 = state_132165__$1;
(statearr_132181_132208[(2)] = inst_132084);


cljs.core.async.impl.ioc_helpers.process_exception(state_132165__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_132166 === (12))){
var inst_132108 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([permission_type], 0));
var inst_132109 = ["Invalid permission op type:",inst_132108].join('');
var inst_132110 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_132111 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_role];
var inst_132112 = cljs.core.PersistentHashMap.fromArrays(inst_132110,inst_132111);
var inst_132113 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_132109,inst_132112);
var inst_132114 = (function(){throw inst_132113})();
var state_132165__$1 = state_132165;
var statearr_132182_132209 = state_132165__$1;
(statearr_132182_132209[(2)] = inst_132114);

(statearr_132182_132209[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132166 === (2))){
var inst_132163 = (state_132165[(2)]);
var state_132165__$1 = state_132165;
return cljs.core.async.impl.ioc_helpers.return_chan(state_132165__$1,inst_132163);
} else {
if((state_val_132166 === (19))){
var inst_132151 = (state_132165[(2)]);
var state_132165__$1 = state_132165;
var statearr_132183_132210 = state_132165__$1;
(statearr_132183_132210[(2)] = inst_132151);

(statearr_132183_132210[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132166 === (11))){
var state_132165__$1 = state_132165;
var statearr_132184_132211 = state_132165__$1;
(statearr_132184_132211[(2)] = null);

(statearr_132184_132211[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132166 === (9))){
var inst_132102 = [cljs.core.cst$kw$token,null,cljs.core.cst$kw$transact,null,cljs.core.cst$kw$query,null];
var inst_132103 = (new cljs.core.PersistentArrayMap(null,3,inst_132102,null));
var inst_132104 = (new cljs.core.PersistentHashSet(null,inst_132103,null));
var inst_132105 = (inst_132104.cljs$core$IFn$_invoke$arity$1 ? inst_132104.cljs$core$IFn$_invoke$arity$1(permission_type) : inst_132104.call(null,permission_type));
var state_132165__$1 = state_132165;
if(cljs.core.truth_(inst_132105)){
var statearr_132185_132212 = state_132165__$1;
(statearr_132185_132212[(1)] = (11));

} else {
var statearr_132186_132213 = state_132165__$1;
(statearr_132186_132213[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132166 === (5))){
var state_132165__$1 = state_132165;
var statearr_132187_132214 = state_132165__$1;
(statearr_132187_132214[(2)] = null);

(statearr_132187_132214[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132166 === (14))){
var inst_132119 = (state_132165[(2)]);
var inst_132120 = fluree.db.util.async.throw_err(inst_132119);
var inst_132128 = cljs.core.seq(inst_132120);
var inst_132129 = cljs.core.first(inst_132128);
var inst_132130 = cljs.core.next(inst_132128);
var inst_132131 = cljs.core.PersistentVector.EMPTY;
var inst_132132 = inst_132120;
var inst_132133 = inst_132131;
var state_132165__$1 = (function (){var statearr_132188 = state_132165;
(statearr_132188[(13)] = inst_132130);

(statearr_132188[(14)] = inst_132129);

(statearr_132188[(10)] = inst_132132);

(statearr_132188[(9)] = inst_132133);

return statearr_132188;
})();
var statearr_132189_132215 = state_132165__$1;
(statearr_132189_132215[(2)] = null);

(statearr_132189_132215[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132166 === (16))){
var inst_132153 = (state_132165[(2)]);
var inst_132154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_132155 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_132156 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_132157 = [inst_132155,inst_132156,role_ident,permission_type];
var inst_132158 = (new cljs.core.PersistentVector(null,4,(5),inst_132154,inst_132157,null));
var inst_132159 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.permissions.role_permission_cache,cljs.core.assoc,inst_132158,inst_132153);
var state_132165__$1 = (function (){var statearr_132190 = state_132165;
(statearr_132190[(15)] = inst_132159);

return statearr_132190;
})();
var statearr_132191_132216 = state_132165__$1;
(statearr_132191_132216[(2)] = inst_132153);

(statearr_132191_132216[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132166 === (10))){
var inst_132161 = (state_132165[(2)]);
var state_132165__$1 = state_132165;
var statearr_132192_132217 = state_132165__$1;
(statearr_132192_132217[(2)] = inst_132161);


cljs.core.async.impl.ioc_helpers.process_exception(state_132165__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_132166 === (18))){
var inst_132139 = (state_132165[(11)]);
var inst_132144 = fluree.db.permissions.parse_rules(db,inst_132139);
var state_132165__$1 = state_132165;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_132165__$1,(20),inst_132144);
} else {
if((state_val_132166 === (8))){
var inst_132099 = (state_132165[(7)]);
var state_132165__$1 = state_132165;
var statearr_132193_132218 = state_132165__$1;
(statearr_132193_132218[(2)] = inst_132099);

(statearr_132193_132218[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$permissions$role_permissions_$_state_machine__109971__auto__ = null;
var fluree$db$permissions$role_permissions_$_state_machine__109971__auto____0 = (function (){
var statearr_132194 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_132194[(0)] = fluree$db$permissions$role_permissions_$_state_machine__109971__auto__);

(statearr_132194[(1)] = (1));

return statearr_132194;
});
var fluree$db$permissions$role_permissions_$_state_machine__109971__auto____1 = (function (state_132165){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_132165);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e132195){if((e132195 instanceof Object)){
var ex__109974__auto__ = e132195;
var statearr_132196_132219 = state_132165;
(statearr_132196_132219[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_132165);

return cljs.core.cst$kw$recur;
} else {
throw e132195;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__132220 = state_132165;
state_132165 = G__132220;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$permissions$role_permissions_$_state_machine__109971__auto__ = function(state_132165){
switch(arguments.length){
case 0:
return fluree$db$permissions$role_permissions_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$permissions$role_permissions_$_state_machine__109971__auto____1.call(this,state_132165);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$permissions$role_permissions_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$permissions$role_permissions_$_state_machine__109971__auto____0;
fluree$db$permissions$role_permissions_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$permissions$role_permissions_$_state_machine__109971__auto____1;
return fluree$db$permissions$role_permissions_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_132197 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_132197[(6)] = c__110077__auto__);

return statearr_132197;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.permissions.permission_map = (function fluree$db$permissions$permission_map(db,roles,permission_type){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_132267){
var state_val_132268 = (state_132267[(1)]);
if((state_val_132268 === (7))){
var inst_132238 = (state_132267[(7)]);
var state_132267__$1 = state_132267;
var statearr_132269_132287 = state_132267__$1;
(statearr_132269_132287[(2)] = inst_132238);

(statearr_132269_132287[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132268 === (1))){
var state_132267__$1 = state_132267;
var statearr_132270_132288 = state_132267__$1;
(statearr_132270_132288[(2)] = null);

(statearr_132270_132288[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132268 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_132267,(3),Error,null,(2));
var inst_132233 = cljs.core.seq(roles);
var inst_132234 = cljs.core.first(inst_132233);
var inst_132235 = cljs.core.next(inst_132233);
var inst_132236 = cljs.core.PersistentVector.EMPTY;
var inst_132237 = roles;
var inst_132238 = inst_132236;
var state_132267__$1 = (function (){var statearr_132271 = state_132267;
(statearr_132271[(8)] = inst_132235);

(statearr_132271[(9)] = inst_132237);

(statearr_132271[(7)] = inst_132238);

(statearr_132271[(10)] = inst_132234);

return statearr_132271;
})();
var statearr_132272_132289 = state_132267__$1;
(statearr_132272_132289[(2)] = null);

(statearr_132272_132289[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132268 === (6))){
var inst_132257 = (state_132267[(2)]);
var inst_132259 = (function (){var all_parsed_rules = inst_132257;
return ((function (all_parsed_rules,inst_132257,state_val_132268,c__110077__auto__){
return (function (acc,p__132258){
var vec__132273 = p__132258;
var path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__132273,(0),null);
var function$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__132273,(1),null);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc,path,((function (vec__132273,path,function$,all_parsed_rules,inst_132257,state_val_132268,c__110077__auto__){
return (function (p1__132221_SHARP_){
if((p1__132221_SHARP_ == null)){
if(cljs.core.boolean_QMARK_(function$)){
return function$;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [function$], null);
}
} else {
if(((p1__132221_SHARP_ === true) || (function$ === true))){
return true;
} else {
if(((p1__132221_SHARP_ === false) && (function$ === false))){
return false;
} else {
if(cljs.core.vector_QMARK_(p1__132221_SHARP_)){
if(function$ === false){
return p1__132221_SHARP_;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__132221_SHARP_,function$);
}
} else {
if((p1__132221_SHARP_ == null)){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [function$], null);
} else {
return null;
}
}
}
}
}
});})(vec__132273,path,function$,all_parsed_rules,inst_132257,state_val_132268,c__110077__auto__))
);
});
;})(all_parsed_rules,inst_132257,state_val_132268,c__110077__auto__))
})();
var inst_132260 = [cljs.core.cst$kw$root_QMARK_];
var inst_132261 = [false];
var inst_132262 = cljs.core.PersistentHashMap.fromArrays(inst_132260,inst_132261);
var inst_132263 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_132259,inst_132262,inst_132257);
var state_132267__$1 = state_132267;
var statearr_132276_132290 = state_132267__$1;
(statearr_132276_132290[(2)] = inst_132263);


cljs.core.async.impl.ioc_helpers.process_exception(state_132267__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_132268 === (3))){
var inst_132222 = (state_132267[(2)]);
var state_132267__$1 = state_132267;
var statearr_132277_132291 = state_132267__$1;
(statearr_132277_132291[(2)] = inst_132222);


cljs.core.async.impl.ioc_helpers.process_exception(state_132267__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_132268 === (2))){
var inst_132265 = (state_132267[(2)]);
var state_132267__$1 = state_132267;
return cljs.core.async.impl.ioc_helpers.return_chan(state_132267__$1,inst_132265);
} else {
if((state_val_132268 === (9))){
var inst_132255 = (state_132267[(2)]);
var state_132267__$1 = state_132267;
var statearr_132278_132292 = state_132267__$1;
(statearr_132278_132292[(2)] = inst_132255);

(statearr_132278_132292[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132268 === (5))){
var inst_132244 = (state_132267[(11)]);
var inst_132237 = (state_132267[(9)]);
var inst_132243 = cljs.core.seq(inst_132237);
var inst_132244__$1 = cljs.core.first(inst_132243);
var inst_132245 = cljs.core.next(inst_132243);
var inst_132246 = cljs.core.not(inst_132244__$1);
var state_132267__$1 = (function (){var statearr_132279 = state_132267;
(statearr_132279[(11)] = inst_132244__$1);

(statearr_132279[(12)] = inst_132245);

return statearr_132279;
})();
if(inst_132246){
var statearr_132280_132293 = state_132267__$1;
(statearr_132280_132293[(1)] = (7));

} else {
var statearr_132281_132294 = state_132267__$1;
(statearr_132281_132294[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_132268 === (10))){
var inst_132238 = (state_132267[(7)]);
var inst_132251 = (state_132267[(2)]);
var inst_132252 = fluree.db.util.async.throw_err(inst_132251);
var inst_132253 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_132238,inst_132252);
var state_132267__$1 = state_132267;
var statearr_132282_132295 = state_132267__$1;
(statearr_132282_132295[(2)] = inst_132253);

(statearr_132282_132295[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_132268 === (8))){
var inst_132244 = (state_132267[(11)]);
var inst_132249 = fluree.db.permissions.role_permissions(db,inst_132244,permission_type);
var state_132267__$1 = state_132267;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_132267__$1,(10),inst_132249);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$permissions$permission_map_$_state_machine__109971__auto__ = null;
var fluree$db$permissions$permission_map_$_state_machine__109971__auto____0 = (function (){
var statearr_132283 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_132283[(0)] = fluree$db$permissions$permission_map_$_state_machine__109971__auto__);

(statearr_132283[(1)] = (1));

return statearr_132283;
});
var fluree$db$permissions$permission_map_$_state_machine__109971__auto____1 = (function (state_132267){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_132267);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e132284){if((e132284 instanceof Object)){
var ex__109974__auto__ = e132284;
var statearr_132285_132296 = state_132267;
(statearr_132285_132296[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_132267);

return cljs.core.cst$kw$recur;
} else {
throw e132284;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__132297 = state_132267;
state_132267 = G__132297;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$permissions$permission_map_$_state_machine__109971__auto__ = function(state_132267){
switch(arguments.length){
case 0:
return fluree$db$permissions$permission_map_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$permissions$permission_map_$_state_machine__109971__auto____1.call(this,state_132267);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$permissions$permission_map_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$permissions$permission_map_$_state_machine__109971__auto____0;
fluree$db$permissions$permission_map_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$permissions$permission_map_$_state_machine__109971__auto____1;
return fluree$db$permissions$permission_map_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_132286 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_132286[(6)] = c__110077__auto__);

return statearr_132286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
