// Compiled by ClojureScript 1.10.520 {:static-fns true, :optimize-constants true}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__118261_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__118261_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(joined_group)," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars))," ) { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_group_str)," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__118265 = coll;
var vec__118266 = G__118265;
var seq__118267 = cljs.core.seq(vec__118266);
var first__118268 = cljs.core.first(seq__118267);
var seq__118267__$1 = cljs.core.next(seq__118267);
var clause = first__118268;
var r = seq__118267__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__118265__$1 = G__118265;
var res__$1 = res;
while(true){
var vec__118272 = G__118265__$1;
var seq__118273 = cljs.core.seq(vec__118272);
var first__118274 = cljs.core.first(seq__118273);
var seq__118273__$1 = cljs.core.next(seq__118273);
var clause__$1 = first__118274;
var r__$1 = seq__118273__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__118275 = r__$1;
var G__118276 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__118265__$1 = G__118275;
res__$1 = G__118276;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__118280 = coll;
var vec__118281 = G__118280;
var seq__118282 = cljs.core.seq(vec__118281);
var first__118283 = cljs.core.first(seq__118282);
var seq__118282__$1 = cljs.core.next(seq__118282);
var clause = first__118283;
var r = seq__118282__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__118280__$1 = G__118280;
var res__$1 = res;
while(true){
var vec__118287 = G__118280__$1;
var seq__118288 = cljs.core.seq(vec__118287);
var first__118289 = cljs.core.first(seq__118288);
var seq__118288__$1 = cljs.core.next(seq__118288);
var clause__$1 = first__118289;
var r__$1 = seq__118288__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__118290 = r__$1;
var G__118291 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__118280__$1 = G__118290;
res__$1 = G__118291;
continue;
} else {
var G__118292 = r__$1;
var G__118293 = res__$2;
G__118280__$1 = G__118292;
res__$1 = G__118293;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__118297 = coll;
var vec__118298 = G__118297;
var seq__118299 = cljs.core.seq(vec__118298);
var first__118300 = cljs.core.first(seq__118299);
var seq__118299__$1 = cljs.core.next(seq__118299);
var clause = first__118300;
var r = seq__118299__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__118297__$1 = G__118297;
var res__$1 = res;
while(true){
var vec__118304 = G__118297__$1;
var seq__118305 = cljs.core.seq(vec__118304);
var first__118306 = cljs.core.first(seq__118305);
var seq__118305__$1 = cljs.core.next(seq__118305);
var clause__$1 = first__118306;
var r__$1 = seq__118305__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__118307 = r__$1;
var G__118308 = res__$2;
G__118297__$1 = G__118307;
res__$1 = G__118308;
continue;
} else {
var G__118309 = r__$1;
var G__118310 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__118297__$1 = G__118309;
res__$1 = G__118310;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_((function (){var and__4120__auto__ = typeof string === 'string';
if(and__4120__auto__){
return cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string);
} else {
return and__4120__auto__;
}
})())){
cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
["\"",string,"\""].join('');
} else {
}
}


return string;
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var clause_str = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,clause))),"."].join('');
if(cljs.core.truth_(optional_QMARK_)){
return ["OPTIONAL {",clause_str,"}"].join('');
} else {
return clause_str;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix))),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var _ = (cljs.core.truth_(cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map))?fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["The Wikidata query option map should be included in the opts map. Top-level options are being deprecated. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([q_map], 0))].join('')], 0)):null);
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$limit,(100),cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$distinct,false,cljs.core.cst$kw$language,"en"], null),cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$wikidataOpts], null),q_map)], 0));
var map__118314 = opts;
var map__118314__$1 = (((((!((map__118314 == null))))?(((((map__118314.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__118314.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__118314):map__118314);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118314__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118314__$1,cljs.core.cst$kw$offset);
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118314__$1,cljs.core.cst$kw$distinct);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118314__$1,cljs.core.cst$kw$language);
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__118314__$1,cljs.core.cst$kw$prefixes);
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (_,opts,map__118314,map__118314__$1,limit,offset,distinct,language,prefixes,prefixes__$1){
return (function (p1__118311_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__118311_SHARP_),"Label"].join('');
});})(_,opts,map__118314,map__118314__$1,limit,offset,distinct,language,prefixes,prefixes__$1))
,select_vars)))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars))].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (_,opts,map__118314,map__118314__$1,limit,offset,distinct,language,prefixes,prefixes__$1,select_smt){
return (function (p1__118312_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__118312_SHARP_,false);
});})(_,opts,map__118314,map__118314__$1,limit,offset,distinct,language,prefixes,prefixes__$1,select_smt))
,clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (_,opts,map__118314,map__118314__$1,limit,offset,distinct,language,prefixes,prefixes__$1,select_smt,where_smt){
return (function (p1__118313_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__118313_SHARP_,true);
});})(_,opts,map__118314,map__118314__$1,limit,offset,distinct,language,prefixes,prefixes__$1,select_smt,where_smt))
,optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = language;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(where_smt)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(optional_smt)," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_118329){
var state_val_118330 = (state_118329[(1)]);
if((state_val_118330 === (1))){
var inst_118316 = fluree.db.util.core.url_encode(query);
var inst_118317 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_118316)].join('');
var inst_118318 = ["User-Agent","Accept"];
var inst_118319 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_118320 = cljs.core.PersistentHashMap.fromArrays(inst_118318,inst_118319);
var inst_118321 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$output_DASH_format];
var inst_118322 = [inst_118320,(30000),cljs.core.cst$kw$wikidata];
var inst_118323 = cljs.core.PersistentHashMap.fromArrays(inst_118321,inst_118322);
var inst_118324 = fluree.db.util.xhttp.get(inst_118317,inst_118323);
var state_118329__$1 = state_118329;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118329__$1,(2),inst_118324);
} else {
if((state_val_118330 === (2))){
var inst_118326 = (state_118329[(2)]);
var inst_118327 = fluree.db.util.async.throw_err(inst_118326);
var state_118329__$1 = state_118329;
return cljs.core.async.impl.ioc_helpers.return_chan(state_118329__$1,inst_118327);
} else {
return null;
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__109971__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__109971__auto____0 = (function (){
var statearr_118331 = [null,null,null,null,null,null,null];
(statearr_118331[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__109971__auto__);

(statearr_118331[(1)] = (1));

return statearr_118331;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__109971__auto____1 = (function (state_118329){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_118329);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e118332){if((e118332 instanceof Object)){
var ex__109974__auto__ = e118332;
var statearr_118333_118335 = state_118329;
(statearr_118333_118335[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_118329);

return cljs.core.cst$kw$recur;
} else {
throw e118332;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__118336 = state_118329;
state_118329 = G__118336;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__109971__auto__ = function(state_118329){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__109971__auto____1.call(this,state_118329);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__109971__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__109971__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_118334 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_118334[(6)] = c__110077__auto__);

return statearr_118334;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_118354){
var state_val_118355 = (state_118354[(1)]);
if((state_val_118355 === (1))){
var inst_118337 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_118354__$1 = state_118354;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118354__$1,(2),inst_118337);
} else {
if((state_val_118355 === (2))){
var inst_118340 = (state_118354[(7)]);
var inst_118339 = (state_118354[(2)]);
var inst_118340__$1 = fluree.db.util.async.throw_err(inst_118339);
var inst_118341 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_118340__$1);
var inst_118342 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_118341);
var state_118354__$1 = (function (){var statearr_118356 = state_118354;
(statearr_118356[(7)] = inst_118340__$1);

return statearr_118356;
})();
if(inst_118342){
var statearr_118357_118365 = state_118354__$1;
(statearr_118357_118365[(1)] = (3));

} else {
var statearr_118358_118366 = state_118354__$1;
(statearr_118358_118366[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118355 === (3))){
var inst_118340 = (state_118354[(7)]);
var state_118354__$1 = state_118354;
var statearr_118359_118367 = state_118354__$1;
(statearr_118359_118367[(2)] = inst_118340);

(statearr_118359_118367[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118355 === (4))){
var inst_118340 = (state_118354[(7)]);
var inst_118345 = (function (){var body = inst_118340;
return ((function (body,inst_118340,state_val_118355,c__110077__auto__){
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (body,inst_118340,state_val_118355,c__110077__auto__){
return (function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
});})(body,inst_118340,state_val_118355,c__110077__auto__))
,cljs.core.PersistentArrayMap.EMPTY,item);
});
;})(body,inst_118340,state_val_118355,c__110077__auto__))
})();
var inst_118346 = cljs.core.second(inst_118340);
var inst_118347 = cljs.core.second(inst_118346);
var inst_118348 = cljs.core.first(inst_118347);
var inst_118349 = cljs.core.second(inst_118348);
var inst_118350 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_118345,inst_118349);
var state_118354__$1 = state_118354;
var statearr_118360_118368 = state_118354__$1;
(statearr_118360_118368[(2)] = inst_118350);

(statearr_118360_118368[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118355 === (5))){
var inst_118352 = (state_118354[(2)]);
var state_118354__$1 = state_118354;
return cljs.core.async.impl.ioc_helpers.return_chan(state_118354__$1,inst_118352);
} else {
return null;
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__109971__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__109971__auto____0 = (function (){
var statearr_118361 = [null,null,null,null,null,null,null,null];
(statearr_118361[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__109971__auto__);

(statearr_118361[(1)] = (1));

return statearr_118361;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__109971__auto____1 = (function (state_118354){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_118354);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e118362){if((e118362 instanceof Object)){
var ex__109974__auto__ = e118362;
var statearr_118363_118369 = state_118354;
(statearr_118363_118369[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_118354);

return cljs.core.cst$kw$recur;
} else {
throw e118362;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__118370 = state_118354;
state_118354 = G__118370;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__109971__auto__ = function(state_118354){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__109971__auto____1.call(this,state_118354);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__109971__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__109971__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_118364 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_118364[(6)] = c__110077__auto__);

return statearr_118364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__118371_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__118371_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (labelVars,headers){
return (function (p1__118372_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__118372_SHARP_),(1)));
});})(labelVars,headers))
,headers);
var results = cljs.core.cst$kw$bindings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (labelVars,headers,headers_as_kws,results){
return (function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (labelVars,headers,headers_as_kws,results){
return (function (p1__118373_SHARP_){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((p1__118373_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__118373_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__118373_SHARP_.call(null,res)));
});})(labelVars,headers,headers_as_kws,results))
,headers_as_kws);
});})(labelVars,headers,headers_as_kws,results))
,results);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$tuples,tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__110077__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__110077__auto__){
return (function (){
var f__110078__auto__ = (function (){var switch__109970__auto__ = ((function (c__110077__auto__){
return (function (state_118408){
var state_val_118409 = (state_118408[(1)]);
if((state_val_118409 === (7))){
var inst_118383 = (state_118408[(2)]);
var inst_118384 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_118383,optional_clauses);
var inst_118385 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_118384);
var state_118408__$1 = state_118408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_118408__$1,(8),inst_118385);
} else {
if((state_val_118409 === (1))){
var state_118408__$1 = state_118408;
var statearr_118410_118426 = state_118408__$1;
(statearr_118410_118426[(2)] = null);

(statearr_118410_118426[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118409 === (4))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_118408,(3),Error,null,(2));
var inst_118378 = cljs.core.empty_QMARK_(matching_vars);
var state_118408__$1 = state_118408;
if(inst_118378){
var statearr_118411_118427 = state_118408__$1;
(statearr_118411_118427[(1)] = (5));

} else {
var statearr_118412_118428 = state_118408__$1;
(statearr_118412_118428[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_118409 === (6))){
var inst_118381 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_118408__$1 = state_118408;
var statearr_118413_118429 = state_118408__$1;
(statearr_118413_118429[(2)] = inst_118381);

(statearr_118413_118429[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118409 === (3))){
var inst_118374 = (state_118408[(2)]);
var state_118408__$1 = state_118408;
var statearr_118414_118430 = state_118408__$1;
(statearr_118414_118430[(2)] = inst_118374);


cljs.core.async.impl.ioc_helpers.process_exception(state_118408__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118409 === (2))){
var inst_118406 = (state_118408[(2)]);
var state_118408__$1 = state_118408;
return cljs.core.async.impl.ioc_helpers.return_chan(state_118408__$1,inst_118406);
} else {
if((state_val_118409 === (11))){
var inst_118404 = (state_118408[(2)]);
var state_118408__$1 = state_118408;
var statearr_118415_118431 = state_118408__$1;
(statearr_118415_118431[(2)] = inst_118404);


cljs.core.async.impl.ioc_helpers.process_exception(state_118408__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_118409 === (9))){
var inst_118388 = (state_118408[(7)]);
var inst_118392 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(inst_118388);
var inst_118393 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_118392,(0),(1000));
var inst_118394 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_118395 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_118388);
var inst_118396 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_118388);
var inst_118397 = [inst_118395,inst_118396];
var inst_118398 = cljs.core.PersistentHashMap.fromArrays(inst_118394,inst_118397);
var inst_118399 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_118393,inst_118398);
var inst_118400 = (function(){throw inst_118399})();
var state_118408__$1 = state_118408;
var statearr_118416_118432 = state_118408__$1;
(statearr_118416_118432[(2)] = inst_118400);

(statearr_118416_118432[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118409 === (5))){
var state_118408__$1 = state_118408;
var statearr_118417_118433 = state_118408__$1;
(statearr_118417_118433[(2)] = null);

(statearr_118417_118433[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118409 === (10))){
var inst_118388 = (state_118408[(7)]);
var inst_118402 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_118388,all_vars);
var state_118408__$1 = state_118408;
var statearr_118418_118434 = state_118408__$1;
(statearr_118418_118434[(2)] = inst_118402);

(statearr_118418_118434[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_118409 === (8))){
var inst_118388 = (state_118408[(7)]);
var inst_118387 = (state_118408[(2)]);
var inst_118388__$1 = fluree.db.util.async.throw_err(inst_118387);
var inst_118389 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_118388__$1);
var inst_118390 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_118389);
var state_118408__$1 = (function (){var statearr_118419 = state_118408;
(statearr_118419[(7)] = inst_118388__$1);

return statearr_118419;
})();
if(inst_118390){
var statearr_118420_118435 = state_118408__$1;
(statearr_118420_118435[(1)] = (9));

} else {
var statearr_118421_118436 = state_118408__$1;
(statearr_118421_118436[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__110077__auto__))
;
return ((function (switch__109970__auto__,c__110077__auto__){
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__109971__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__109971__auto____0 = (function (){
var statearr_118422 = [null,null,null,null,null,null,null,null];
(statearr_118422[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__109971__auto__);

(statearr_118422[(1)] = (1));

return statearr_118422;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__109971__auto____1 = (function (state_118408){
while(true){
var ret_value__109972__auto__ = (function (){try{while(true){
var result__109973__auto__ = switch__109970__auto__(state_118408);
if(cljs.core.keyword_identical_QMARK_(result__109973__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__109973__auto__;
}
break;
}
}catch (e118423){if((e118423 instanceof Object)){
var ex__109974__auto__ = e118423;
var statearr_118424_118437 = state_118408;
(statearr_118424_118437[(5)] = ex__109974__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_118408);

return cljs.core.cst$kw$recur;
} else {
throw e118423;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__109972__auto__,cljs.core.cst$kw$recur)){
var G__118438 = state_118408;
state_118408 = G__118438;
continue;
} else {
return ret_value__109972__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__109971__auto__ = function(state_118408){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__109971__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__109971__auto____1.call(this,state_118408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__109971__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__109971__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__109971__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__109971__auto__;
})()
;})(switch__109970__auto__,c__110077__auto__))
})();
var state__110079__auto__ = (function (){var statearr_118425 = (f__110078__auto__.cljs$core$IFn$_invoke$arity$0 ? f__110078__auto__.cljs$core$IFn$_invoke$arity$0() : f__110078__auto__.call(null));
(statearr_118425[(6)] = c__110077__auto__);

return statearr_118425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__110079__auto__);
});})(c__110077__auto__))
);

return c__110077__auto__;
});
